var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, a7 as AdministrationPagesClient, T as Transformer, b as baseUrl, n as normalizeComponent, a0 as userHasPermission, a6 as userIsSuperAdmin, _, t as toastr$1, a as lodashExports, a8 as Shared, s as SortableHeader, f as draggable, a9 as AdministrationImportClient, L as LoadingBarComponent, w as createUrl } from "./main-DAVWuHbi.js";
import AppPageGroupsConfigurationComponent from "./pageGroupsConfiguration-CsKiEWai.js";
import { A as AppPageDefaultSettingsComponent } from "./appPageDefaultSettings-CyMlCDI2.js";
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$3"), _a;
let AssignGroupModal$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "modalId");
    __publicField(this, "pageIds");
    __publicField(this, "appPageGroups", []);
    __publicField(this, "selectedGroup", null);
  }
  async mounted() {
    await this.loadAppPageGroups();
  }
  async loadAppPageGroups() {
    try {
      let groups = (await new AdministrationPagesClient(new Transformer(), baseUrl()).getAppPageGroups()).groups.map((g) => ({ value: g.groupName, text: g.groupName + " ( " + g.pages.length + " pages )" }));
      groups.unshift({ value: null, text: "Unassign" }), this.appPageGroups = groups;
    } catch (ex) {
      toastr.error(ex, "An error occurred when retrieving the App Page Groups");
    }
  }
  confirm() {
    this.$emit("assignToGroup", this.selectedGroup), this.hideModal();
  }
  async showModal() {
    this.selectedGroup = null, await this.loadAppPageGroups();
  }
  hideModal() {
    this.$bvModal.hide(this.modalId);
  }
}, __name(_a, "AssignGroupModal"), _a);
__decorateClass$3([
  Prop({ required: !0 })
], AssignGroupModal$1.prototype, "modalId", 2);
__decorateClass$3([
  Prop({ required: !0, default: [] })
], AssignGroupModal$1.prototype, "pageIds", 2);
AssignGroupModal$1 = __decorateClass$3([
  Component({
    components: {}
  })
], AssignGroupModal$1);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { id: _vm.modalId, size: "md", "hide-footer": "" }, on: { show: _vm.loadAppPageGroups }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h4", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "layer-group" } }), _vm._v(" Assign/Unassign " + _vm._s(_vm.pageIds.length) + " pages")], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), [_c("div", [_c("b-form", [_c("b-form-group", { attrs: { id: "groupAssignSelector", label: "Group", "label-for": "groupAssignSelector", description: "Select the group to assign these pages to. Select 'Unassign' to remove the pages from their groups." } }, [_c("b-form-select", { attrs: { options: _vm.appPageGroups }, model: { value: _vm.selectedGroup, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.selectedGroup = $$v;
  }, "callback"), expression: "selectedGroup" } })], 1)], 1)], 1), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: _vm.hideModal } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "success" }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(`
                Save
            `)], 1)], 1)]], 2);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  AssignGroupModal$1,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const AssignGroupModal = __component__$3.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$2"), _a2;
let AppPagesListComponent$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "modules");
    __publicField(this, "loading", !1);
    __publicField(this, "bulkActionLoading", !1);
    __publicField(this, "deletingAppPages", []);
    __publicField(this, "deletingAppPageNames", []);
    __publicField(this, "filter", "");
    __publicField(this, "sort", null);
    __publicField(this, "selectedPageIds", []);
    __publicField(this, "canCreatePage", !1);
    __publicField(this, "canEditPages", !1);
    __publicField(this, "canDeletePages", !1);
    __publicField(this, "canAccessGroups", !1);
    __publicField(this, "isSuperAdmin", !1);
    __publicField(this, "saveFilterDebounce", _.debounce(function() {
      localStorage.setItem("adminAppPageFilter", this.filter);
    }, 500));
  }
  get selectedPages() {
    return this.selectedPageIds;
  }
  set selectedPages(value) {
    this.selectedPageIds = value;
  }
  get partiallySelectedPages() {
    var _a5;
    return ((_a5 = this.selectedPageIds) == null ? void 0 : _a5.length) > 0 && this.selectedPageIds.length < this.filteredAppPages.length;
  }
  get canBulkExport() {
    var _a5;
    return ((_a5 = this.selectedPages) == null ? void 0 : _a5.length) > 0;
  }
  async mounted() {
    this.canCreatePage = await userHasPermission("apppages.pages.create"), this.canEditPages = await userHasPermission("apppages.pages.editall") || await userHasPermission("apppages.pages.editowner"), this.canDeletePages = await userHasPermission("apppages.pages.delete"), this.canAccessGroups = await userHasPermission("apppages.groups"), this.isSuperAdmin = await userIsSuperAdmin();
    let filter = localStorage.getItem("adminAppPageFilter");
    filter && (this.filter = filter);
  }
  appPageLicenseCreatable(appPage) {
    let licenseModule = this.modules.find((m) => m.id === appPage.type.toUpperCase());
    if (licenseModule.license.instances < 1)
      return !0;
    let allowed = licenseModule.license.instances, modulePages = this.appPages.filter((ap) => ap.type === appPage.type && ap.enabled);
    return allowed > modulePages.length;
  }
  get appPages() {
    return this.value;
  }
  set appPages(value) {
    this.$emit("sort", value);
  }
  get filterText() {
    return this.filter;
  }
  set filterText(value) {
    this.filter = value, this.saveFilterDebounce();
  }
  get sorted() {
    if (this.sort) {
      let sorted = this.filteredAppPages.sort((a, b) => {
        switch (this.sort.by) {
          case "name":
            return ("" + a.name).localeCompare(b.name);
          case "type":
            return ("" + a.type).localeCompare(b.type);
          case "group":
            return ("" + a.groupName).localeCompare(b.groupName);
        }
      });
      return this.sort.descending ? sorted.reverse() : sorted;
    } else
      return this.filteredAppPages;
  }
  get filteredAppPages() {
    if (this.filterText) {
      let filterText = this.filterText.toLocaleLowerCase();
      return this.appPages.filter((page) => {
        var _a5, _b, _c, _d, _e;
        return ((_a5 = page.name) == null ? void 0 : _a5.toLocaleLowerCase().includes(filterText)) || ((_b = page.type.toString()) == null ? void 0 : _b.toLocaleLowerCase().includes(filterText)) || ((_c = page.description) == null ? void 0 : _c.toLocaleLowerCase().includes(filterText)) || ((_d = page.groupName) == null ? void 0 : _d.toLocaleLowerCase().includes(filterText)) || ((_e = page.url) == null ? void 0 : _e.toLocaleLowerCase().includes(filterText));
      });
    } else
      return this.appPages;
  }
  setOrder() {
    this.isSuperAdmin && new AdministrationPagesClient(new Transformer(), baseUrl()).reorderPages(this.appPages).then((model) => {
      this.appPages = model;
    }).catch((e) => {
      toastr$1.error("Something has gone wrong while moving the app page: " + e);
    }).finally(() => {
    });
  }
  getPageEnabledTooltip(page) {
    return page.enabled ? "Page enabled" : "Page disabled";
  }
  async togglePageEnabled(page) {
    this.enableDisablePagesOperation({ enabled: !page.enabled, pageIds: [page.id] });
  }
  async setSelectedPagesEnabledDisabled(isEnabled) {
    const pages = this.filteredAppPages.filter((p) => this.selectedPageIds.includes(p.id));
    pages.length && this.enableDisablePagesOperation({ enabled: isEnabled, pageIds: pages.map((p) => p.id) });
  }
  async enableDisablePagesOperation(request) {
    this.loading = !0, request.pageIds.length > 1 && (this.bulkActionLoading = !0);
    try {
      let result = await new AdministrationPagesClient(new Transformer(), baseUrl()).enableDisablePages(request);
      result.forEach(
        (updatedPage) => {
          let currPage = this.appPages.find((x) => x.id == updatedPage.id);
          currPage.enabled = updatedPage.enabled;
        }
      );
      let count = result.length;
      count === 1 ? toastr$1.info(`${lodashExports.first(result).name} has been ${request.enabled ? "enabled" : "disabled"}`) : toastr$1.info(`${count} pages have been ${request.enabled ? "enabled" : "disabled"}`), this.$emit("refresh");
    } catch (ex) {
      Shared.HandleDomainError(ex);
    } finally {
      this.loading = !1, this.bulkActionLoading = !1;
    }
  }
  togglePageSelected(page) {
    var _a5;
    ((_a5 = this.selectedPages) == null ? void 0 : _a5.find((x) => x == page.id)) ? this.selectedPages = this.selectedPages.filter((x) => x != page.id) : this.selectedPages = this.selectedPages.concat([page.id]);
  }
  toggleAllPagesSelected() {
    var _a5;
    ((_a5 = this.selectedPages) == null ? void 0 : _a5.length) == 0 ? this.selectedPages = this.filteredAppPages.map((x) => x.id) : this.selectedPages = [];
  }
  isPageSelected(page) {
    var _a5;
    return (_a5 = this.selectedPages) == null ? void 0 : _a5.includes(page.id);
  }
  deletePages() {
    this.loading = !0;
    const deletingPageIds = this.deletingAppPages.map((x) => x.id);
    new AdministrationPagesClient(new Transformer(), baseUrl()).deletePages(deletingPageIds).then((model) => {
      $("#deletePageModal").modal("hide");
      let msg = this.deletingAppPageNames.length == 1 ? this.deletingAppPageNames[0] + " has been deleted" : `${this.deletingAppPageNames.length} app pages have been deleted`;
      toastr$1.info(msg), this.appPages = this.appPages.filter((page) => !deletingPageIds.includes(page.id)), this.deletingAppPages = [], this.deletingAppPageNames = [], this.selectedPages = [];
    }).catch((e) => {
      toastr$1.error("Something has gone wrong while deleting app pages: " + e);
    }).finally(() => {
      this.loading = !1;
    });
  }
  showAssignModal() {
    this.$bvModal.show("assignToGroupModal");
  }
  showDeletingModal(pageIdsToDelete) {
    const pagesToDelete = this.appPages.filter((x) => pageIdsToDelete.includes(x.id));
    $("#deletePageModal").modal("show"), this.deletingAppPages = pagesToDelete, this.deletingAppPageNames = pagesToDelete.map((x) => x.name);
  }
  clonePage(pageId) {
    this.loading = !0, new AdministrationPagesClient(new Transformer(), baseUrl()).clonePage(pageId).then((model) => {
      toastr$1.info(model.name + " has been created"), this.appPages.push(model);
    }).catch((e) => {
      toastr$1.error("Something has gone wrong while cloning the app page: " + e);
    }).finally(() => {
      this.loading = !1;
    });
  }
  async clonePages() {
    this.loading = !0;
    try {
      (await new AdministrationPagesClient(new Transformer(), baseUrl()).clonePages(this.selectedPageIds)).forEach((page) => this.appPages.push(page)), toastr$1.success("The selected pages have been cloned"), this.selectedPages = [];
    } catch (ex) {
      toastr$1.error("Something has gone wrong while cloning the app pages: " + ex);
    } finally {
      this.loading = !1;
    }
  }
  async assignPages(group) {
    this.loading = !0;
    try {
      let result = await new AdministrationPagesClient(new Transformer(), baseUrl()).assignPagesToGroup(this.selectedPageIds, group);
      group ? toastr$1.success("The selected pages have been assigned to group '" + group + "'") : toastr$1.success("The selected pages have been unassigned from their group."), this.selectedPages = [], this.$emit("refresh");
    } catch (ex) {
      toastr$1.error("Something has gone wrong while assigning/unassigning the app pages: " + ex);
    } finally {
      this.loading = !1;
    }
  }
  async exportSelected() {
    const response = await new AdministrationPagesClient(new Transformer(), baseUrl()).exportAppPages(this.selectedPageIds), blob = response.data, downloadUrl = window.URL.createObjectURL(blob), anchor = document.createElement("a");
    anchor.href = downloadUrl, anchor.download = response.fileName, document.body.appendChild(anchor), anchor.click(), anchor.remove();
  }
  getPageUrl(page) {
    return baseUrl() + "/Admin/AppPage/" + page.id;
  }
}, __name(_a2, "AppPagesListComponent"), _a2);
__decorateClass$2([
  Prop({
    required: !0
  })
], AppPagesListComponent$1.prototype, "value", 2);
__decorateClass$2([
  Prop({
    required: !0
  })
], AppPagesListComponent$1.prototype, "modules", 2);
AppPagesListComponent$1 = __decorateClass$2([
  Component({
    components: { draggable, SortableHeader, AssignGroupModal }
  })
], AppPagesListComponent$1);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _a5;
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-sm-12" }, [_c("b-form-group", { staticClass: "mb-0" }, [_c("b-input-group", { attrs: { size: "sm" } }, [_c("b-form-input", { attrs: { id: "filter-input", type: "search", placeholder: "Filter...", autocomplete: "off" }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)], 1)], 1)], 1), _vm._v(" "), _vm.sorted ? _c("span", { staticClass: "text-muted" }, [_vm.filterText && _vm.sorted.length ? _c("span", [_vm._v("Currently showing " + _vm._s(_vm.sorted.length) + " of " + _vm._s(_vm.appPages.length) + " pages")]) : _vm._e()]) : _vm._e(), _vm._v(" "), _vm.appPages.length > 0 ? _c("table", { staticClass: "table table-hover" }, [_c("thead", [_c("tr", [_c("th", { attrs: { scope: "col", id: "thSelectAll" } }, [_vm._v(` 
                    `), _c("b-checkbox", { attrs: { indeterminate: _vm.partiallySelectedPages, checked: !!((_a5 = _vm.selectedPages) != null && _a5.length), id: "selectAll" }, on: { change: _vm.toggleAllPagesSelected } })], 1), _vm._v(" "), _c("sortable-header", { attrs: { id: "type" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v("Type")]), _vm._v(" "), _c("sortable-header", { attrs: { id: "name" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v("Name")]), _vm._v(" "), _c("th", { attrs: { scope: "col" } }, [_vm._v("URL")]), _vm._v(" "), _c("th", { attrs: { scope: "col" } }, [_vm._v("Description")]), _vm._v(" "), _c("th", { attrs: { scope: "col" } }, [_vm._v("Permissions")]), _vm._v(" "), _c("sortable-header", { attrs: { id: "group" }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sort = $$v;
  }, "callback"), expression: "sort" } }, [_vm._v("Group")]), _vm._v(" "), _c("th", { attrs: { scope: "col" } }, [_vm._v(` 
                    `), _c("div", { staticClass: "btn-group btn-group-sm float-right text-nowrap" }, [_vm.bulkActionLoading ? _c("b-spinner", { attrs: { variant: "primary", label: "Spinning" } }) : _vm._e(), _vm._v(" "), _vm.bulkActionLoading ? _vm._e() : _c("b-dropdown", { attrs: { "no-flip": "", variant: "primary", size: "sm", id: "bulkModifyPages", disabled: _vm.loading || !_vm.canBulkExport, "no-caret": "", right: "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
  }, "fn"), proxy: !0 }], null, !1, 4030512936) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: _vm.exportSelected } }, [_c("font-awesome-icon", { attrs: { icon: "file-export" } }), _vm._v(` Export Selected
                            `)], 1), _vm._v(" "), _vm.canEditPages ? _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.setSelectedPagesEnabledDisabled(!0);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "toggle-on" } }), _vm._v(` Enable Selected
                            `)], 1) : _vm._e(), _vm._v(" "), _vm.canEditPages ? _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.setSelectedPagesEnabledDisabled(!1);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "toggle-off" } }), _vm._v(` Disable Selected
                            `)], 1) : _vm._e(), _vm._v(" "), _vm.canCreatePage ? _c("b-dropdown-item", { on: { click: _vm.clonePages } }, [_c("font-awesome-icon", { attrs: { icon: "copy" } }), _vm._v(` Clone Selected
                            `)], 1) : _vm._e(), _vm._v(" "), _vm.canAccessGroups ? _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.showAssignModal(_vm.selectedPageIds);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "layer-group" } }), _vm._v(` Assign to Group
                            `)], 1) : _vm._e(), _vm._v(" "), _vm.canDeletePages ? _c("b-dropdown-item", { attrs: { "data-delete-confirm": "true", variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.showDeletingModal(_vm.selectedPageIds);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete Selected
                            `)], 1) : _vm._e()], 1)], 1)])], 1)]), _vm._v(" "), _c("draggable", { attrs: { handle: ".field-handle", disabled: _vm.filterText || _vm.sort, tag: "tbody" }, on: { change: /* @__PURE__ */ __name(function($event) {
    return _vm.setOrder();
  }, "change") }, model: { value: _vm.appPages, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.appPages = $$v;
  }, "callback"), expression: "appPages" } }, _vm._l(_vm.sorted, function(appPage) {
    return _vm.sorted.length ? _c("tr", { key: appPage.id }, [_c("td", { staticClass: "text-nowrap align-middle" }, [_c("div", { staticClass: "d-inline-flex" }, [_c("b-checkbox", { attrs: { checked: _vm.isPageSelected(appPage), size: "sm" }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.togglePageSelected(appPage);
    }, "change") } }), _vm._v(" "), _vm.isSuperAdmin ? _c("span", { class: { "text-muted field-handle-disabled": _vm.filterText || _vm.sort, "field-handle": !_vm.filterText && !_vm.sort } }, [_c("font-awesome-icon", { attrs: { icon: "grip-vertical" } })], 1) : _vm._e(), _vm._v(` 
                            `), _vm.canEditPages ? _c("b-form-checkbox", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "ml-1", attrs: { checked: appPage.enabled, size: "sm", name: "pageEnabledButton", title: _vm.getPageEnabledTooltip(appPage), switch: "" }, nativeOn: { click: /* @__PURE__ */ __name(function($event) {
      return $event.preventDefault(), _vm.togglePageEnabled(appPage);
    }, "click") } }) : _vm._e()], 1)]), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(appPage.type.toUpperCase(), _vm.filterText)) } })]), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_vm.canEditPages ? _c("a", { staticClass: "py-0 my-0", attrs: { href: _vm.getPageUrl(appPage) } }, [_c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(appPage.name, _vm.filterText)) } })]) : _c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(appPage.name, _vm.filterText)) } })]), _vm._v(" "), _c("td", { staticClass: "align-middle text-break" }, [_c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(appPage.url, _vm.filterText)) } })]), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(appPage.description, _vm.filterText)) } })]), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { pill: "", variant: "secondary", title: "User Permissions" } }, [_vm._v(_vm._s(appPage.userPermissionCount))]), _vm._v(" "), _c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { pill: "", variant: "secondary", title: "Manager Permissions" } }, [_vm._v(_vm._s(appPage.managerPermissionCount))]), _vm._v(" "), _c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { pill: "", variant: "secondary", title: "Owner Permissions" } }, [_vm._v(_vm._s(appPage.ownerPermissionCount))])], 1), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_c("span", { domProps: { innerHTML: _vm._s(_vm.$options.filters.highlight(appPage.groupName, _vm.filterText)) } })]), _vm._v(" "), _c("td", [_c("div", { staticClass: "btn-group btn-group-sm float-right text-nowrap" }, [_vm.canEditPages ? _c("b-dropdown", { attrs: { "no-flip": "", "split-href": _vm.getPageUrl(appPage), split: "", variant: "primary", size: "sm", disabled: _vm.loading, text: "Edit", id: "dropdown" + appPage.id }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(` Edit
                                `)];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _vm.canDeletePages ? _c("b-dropdown-item", { attrs: { "data-delete-confirm": "true", disabled: _vm.loading, variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showDeletingModal([appPage.id]);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
                                `)], 1) : _vm._e(), _vm._v(" "), _c("b-dropdown-item", { attrs: { href: "ExportPage/" + appPage.id, disabled: _vm.loading } }, [_c("font-awesome-icon", { attrs: { icon: "file-export" } }), _vm._v(` Export
                                `)], 1), _vm._v(" "), _vm.canCreatePage ? _c("b-dropdown-item", { attrs: { disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.clonePage(appPage.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "copy" } }), _vm._v(` Clone
                                `)], 1) : _vm._e()], 1) : _vm._e()], 1)])]) : _vm._e();
  }), 0)], 1) : _vm._e(), _vm._v(" "), _vm.appPages.length ? _vm._e() : _c("div", { staticClass: "mt-2" }, [_c("b-alert", { attrs: { show: "", variant: "info", id: "noAppPagesAlert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`  There are no App Pages currently
            configured. Use the Add or Import buttons above to create one
        `)], 1)], 1), _vm._v(" "), _c("b-alert", { attrs: { show: _vm.appPages.length > 0 && _vm.sorted.length === 0 && _vm.filterText.length, variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` There are no App Pages matching
            your filter results
        `)], 1), _vm._v(" "), _c("div", { staticClass: "modal fade", attrs: { id: "deletePageModal", tabindex: "-1", role: "dialog", "aria-labelledby": "deletePageModal", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title", attrs: { id: "deletePageLabel" } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Delete " + _vm._s(_vm.deletingAppPageNames.length == 1 ? _vm.deletingAppPageNames[0] : "App Pages") + `
                        `)], 1), _vm._v(" "), _vm._m(0)]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_vm.deletingAppPages.length == 1 ? _c("p", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` 
                            Are you sure you want to delete ` + _vm._s(_vm.deletingAppPageNames[0]) + `? You will not be able to
                            reverse this.
                        `)], 1) : _c("div", [_c("p", [_vm._v("Are you sure you want to delete these selected pages?")]), _vm._v(" "), _c("ul", _vm._l(_vm.deletingAppPageNames, function(name2) {
    return _c("li", [_vm._v(_vm._s(name2))]);
  }), 0), _vm._v(" "), _c("p", [_vm._v("You will not be able to reverse this.")])])]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", "data-dismiss": "modal" } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-danger", class: { disabled: _vm.loading }, attrs: { type: "button", id: "confirmDelete", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.deletePages();
  }, "click") } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.loading, expression: "!loading" }] }, [_c("font-awesome-icon", { attrs: { icon: "trash", id: "confirmDeletePage" } }), _vm._v(" Delete")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.loading, expression: "loading" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Deleting")], 1)])])])])])], 1), _vm._v(" "), _c("assign-group-modal", { attrs: { pageIds: _vm.selectedPageIds, "modal-id": "assignToGroupModal" }, on: { assignToGroup: _vm.assignPages } })], 1);
}, "render"), _sfc_staticRenderFns$2 = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}], __component__$2 = /* @__PURE__ */ normalizeComponent(
  AppPagesListComponent$1,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "e9eebc96"
);
const AppPagesListComponent = __component__$2.exports;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$1"), _a3;
let SettingsPageImportComponent$1 = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "currentFile", null);
    __publicField(this, "appPagesToImport", []);
    __publicField(this, "appPagesAvailable", []);
    __publicField(this, "loading", !1);
    __publicField(this, "uploading", !1);
    __publicField(this, "uploadError", "");
    __publicField(this, "adminImportClient", new AdministrationImportClient(new Transformer(), baseUrl()));
  }
  get tableFields() {
    return [
      { key: "actions", sortable: !1, label: "", thStyle: "width: 25px" },
      { key: "type", thStyle: "width: 70px" },
      { key: "name" },
      { key: "id" },
      { key: "groupName", label: "Group" }
    ];
  }
  async onFileChange(e) {
    this.uploadError = "", this.loading = !0;
    let files = e.target.files || e.dataTransfer.files;
    if (!files.length)
      return;
    let newFile = files[0];
    this.currentFile = newFile, this.currentFile && await this.getAppPages(), this.loading = !1;
  }
  get partiallySelectedPages() {
    var _a5;
    return ((_a5 = this.appPagesToImport) == null ? void 0 : _a5.length) > 0 && this.appPagesToImport.length < this.appPagesAvailable.length;
  }
  get uploadButtonTooltip() {
    return this.appPagesToImport.length ? "" : "You must select AppPages";
  }
  togglePageSelected(page) {
    var _a5;
    ((_a5 = this.appPagesToImport) == null ? void 0 : _a5.find((x) => x.id == page.id)) ? this.appPagesToImport = this.appPagesToImport.filter((x) => x.id != page.id) : this.appPagesToImport = this.appPagesToImport.concat([page]);
  }
  toggleAllPagesSelected() {
    var _a5;
    ((_a5 = this.appPagesToImport) == null ? void 0 : _a5.length) != this.appPagesAvailable.length ? this.appPagesToImport = this.appPagesAvailable : this.appPagesToImport = [];
  }
  isPageSelected(page) {
    var _a5;
    return (_a5 = this.appPagesToImport) == null ? void 0 : _a5.some((y) => y.id == page.id);
  }
  async getAppPages() {
    try {
      let response = await this.adminImportClient.uploadSettingsFile({ fileName: this.currentFile.name, data: this.currentFile });
      this.appPagesAvailable = response.appPages, response.success ? this.appPagesToImport = [] : this.uploadError = response.error, response.success && this.appPagesAvailable.length == 1 && (this.appPagesToImport = this.appPagesAvailable);
    } catch (ex) {
      this.uploadError = ex.error;
    }
  }
  async uploadPages() {
    this.uploading = !0;
    try {
      let response = await this.adminImportClient.importAppPagesFromSettings(
        { fileName: this.currentFile.name, data: this.currentFile },
        this.appPagesToImport.map((p) => p.id)
      );
      if (!response.success)
        this.uploadError = response.error;
      else {
        let pagePlural = this.appPagesToImport.length > 1 ? " pages" : " page";
        toastr$1.success("Successfully imported " + this.appPagesToImport.length.toString() + pagePlural), this.reset();
      }
    } catch (ex) {
      this.uploadError = ex.error;
    } finally {
      this.uploading = !1;
    }
  }
  reset() {
    this.uploadError = "", this.currentFile = null, this.appPagesAvailable = [], this.appPagesToImport = [];
  }
}, __name(_a3, "SettingsPageImportComponent"), _a3);
SettingsPageImportComponent$1 = __decorateClass$1([
  Component({
    components: { LoadingBar: LoadingBarComponent }
  })
], SettingsPageImportComponent$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _a5, _b, _c2;
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
        From here you may upload a `), _c("b", [_vm._v("EWA-Export.ewx")]), _vm._v(" or "), _c("b", [_vm._v("Settings.xml")]), _vm._v(` file and then select AppPages to Import
      `)], 1)], 1)], 1), _vm._v(" "), _c("b-row", [_c("b-col", { attrs: { lg: "4", md: "6", sm: "12" } }, [_c("b-form-group", { attrs: { description: "Select the settings file to browse" } }, [_c("b-form-file", { attrs: { placeholder: "Upload a EWA-Export.ewx or settings.xml file", id: "importUpload", "drop-placeholder": "Drop file here...", accept: ".xml,.ewx", disabled: _vm.uploading }, on: { change: _vm.onFileChange }, model: { value: _vm.currentFile, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.currentFile = $$v;
  }, "callback"), expression: "currentFile" } })], 1)], 1)], 1), _vm._v(" "), _vm.uploadError ? _c("b-alert", { attrs: { show: "", variant: "danger", dismissible: "" } }, [_c("div", { staticClass: "font-weight-bold alert-heading" }, [_c("font-awesome-icon", { attrs: { icon: "times-circle" } }), _vm._v(`
      An error occurred while parsing the input file
    `)], 1), _vm._v(`
    ` + _vm._s(_vm.uploadError) + `
  `)]) : _vm._e(), _vm._v(" "), _vm.currentFile && !_vm.uploadError ? _c("span", [_c("b-row", [_c("b-col", [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "file-code" } }), _vm._v(`
        ` + _vm._s(_vm.currentFile.name || "Uploaded File") + `
          `), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: _vm.uploadButtonTooltip } }, [_c("b-button", { staticClass: "ml-2", attrs: { variant: "primary", disabled: !((_a5 = _vm.appPagesToImport) != null && _a5.length) || _vm.uploading, id: "importPages" }, on: { click: _vm.uploadPages } }, [_vm.uploading ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(`
                Uploading
              `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "file-import" } }), _vm._v(`
                Import selected pages
                `), (_b = _vm.appPagesToImport) != null && _b.length ? _c("span", [_vm._v("(" + _vm._s((_c2 = _vm.appPagesToImport) == null ? void 0 : _c2.length) + ")")]) : _vm._e()], 1)])], 1)], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", [_c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.appPagesAvailable, hover: "", busy: _vm.loading }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "head(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "Select all pages" } }, [_vm.appPagesAvailable ? _c("b-checkbox", { attrs: { indeterminate: _vm.partiallySelectedPages, id: "selectAllPagesImport", checked: _vm.appPagesToImport.length == _vm.appPagesAvailable.length, disabled: _vm.uploading }, on: { change: _vm.toggleAllPagesSelected } }) : _vm._e()], 1)];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-checkbox", { attrs: { checked: _vm.isPageSelected(row.item), size: "sm", disabled: _vm.uploading }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.togglePageSelected(row.item);
    }, "change") } })];
  }, "fn") }, { key: "cell(type)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
            ` + _vm._s(row.item.type.toUpperCase()) + `
          `)];
  }, "fn") }], null, !1, 3441265056) })], 1)], 1)], 1) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  SettingsPageImportComponent$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "760aa31f"
);
const SettingsPageImportComponent = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a4;
let AdministrationAppPagesComponent = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "pages", []);
    __publicField(this, "modules", []);
    __publicField(this, "tab", null);
    __publicField(this, "loadedPermissions", !1);
    __publicField(this, "showAppPages", !1);
    __publicField(this, "canCreatePage", !1);
    __publicField(this, "showGroups", !1);
    __publicField(this, "showDefaultSettings", !1);
  }
  async mounted() {
    this.showAppPages = await userHasPermission("apppages.pages"), this.canCreatePage = await userHasPermission("apppages.pages.create"), this.showGroups = await userHasPermission("apppages.groups"), this.showDefaultSettings = await userHasPermission("apppages.defaults"), this.loadedPermissions = !0, await this.refreshAppPages(), await this.refreshAppModules();
  }
  async refreshAppPages() {
    if (this.showAppPages)
      try {
        this.loading = !0;
        let appPages = await new AdministrationPagesClient(new Transformer(), baseUrl()).getAppPages();
        this.appPages = appPages;
      } catch (ex) {
        toastr.error("Something has gone wrong while loading the App Pages: " + ex);
      } finally {
        this.loading = !1;
      }
  }
  async refreshAppModules() {
    if (this.canCreatePage)
      try {
        this.loading = !0;
        let modules = await new AdministrationPagesClient(new Transformer(), baseUrl()).getAppPageModules();
        this.modules = modules;
      } catch (ex) {
        toastr.error("Something has gone wrong while loading the licensed modules: " + ex);
      } finally {
        this.loading = !1;
      }
  }
  get appPages() {
    return this.pages;
  }
  set appPages(value) {
    this.pages = value;
  }
  orderAppPages(value) {
    this.appPages = value;
  }
  addPageModuleNameText(moduleModel) {
    return moduleModel.shortName + " - " + moduleModel.fullName + " ";
  }
  addPageModuleUsedText(moduleModel) {
    var total = moduleModel.license.instances == 0 ? "Unlimited" : moduleModel.license.instances.toString(), used = this.enabledPageTypes(moduleModel.id) + " of " + total;
    return name + "(" + used + ")";
  }
  enabledPageTypes(type) {
    var total = this.pages.filter((ap) => ap.type === type.toLowerCase() && ap.enabled);
    return total ? total.length : 0;
  }
  get tabs() {
    var _a5;
    return [
      {
        id: "pages",
        name: "Pages",
        icon: "clone",
        description: "The app pages",
        show: this.showAppPages,
        component: AppPagesListComponent,
        count: ((_a5 = this.appPages) == null ? void 0 : _a5.length) ?? 0
      },
      {
        id: "groups",
        name: "Groups",
        icon: "list",
        description: "Manage groupings for the App Pages",
        show: this.showGroups,
        component: AppPageGroupsConfigurationComponent
      },
      {
        id: "import",
        name: "Import",
        icon: "file-import",
        description: "Import an app page",
        show: this.showAppPages,
        component: SettingsPageImportComponent
      },
      {
        id: "defaultSettings",
        name: "Defaults",
        icon: "wrench",
        description: "Configure the App Page defualt settings",
        show: this.showDefaultSettings,
        component: AppPageDefaultSettingsComponent
      }
    ];
  }
  get activeComponent() {
    if (this.activeTab) {
      let component = this.tabs.find((t) => t.id == this.activeTab);
      if (component)
        return component.component;
    }
    return null;
  }
  get activeTab() {
    return this.tab ? this.tab : (this.tabs.find((t) => t.show) || { id: null }).id;
  }
  selectTab(tabId) {
    this.tabs.find((t) => t.id === tabId && t.show) && (this.tab = tabId), tabId === "pages" && this.refreshAppPages();
  }
}, __name(_a4, "AdministrationAppPagesComponent"), _a4);
AdministrationAppPagesComponent = __decorateClass([
  Component({
    components: { LoadingBar: LoadingBarComponent },
    methods: {
      createUrl
    }
  })
], AdministrationAppPagesComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "clone" } }), _vm._v(` App Pages
    `)], 1)]), _vm._v(" "), _vm.loading || !_vm.loadedPermissions ? _c("div", [_c("loading-bar")], 1) : _vm.loadedPermissions ? _c("div", [_c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs", attrs: { id: "myTab", role: "tablist" } }, _vm._l(_vm.tabs.filter((y) => y.show), function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item" }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab === tab.id }, attrs: { id: tab.id + "tab", "data-toggle": "tab", role: "tab", "aria-selected": "true" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(" " + _vm._s(tab.name) + `
              `), tab.count != null && tab.count > 0 ? _c("span", { staticClass: "badge badge-info" }, [_vm._v(_vm._s(tab.count))]) : _vm._e()], 1)]);
  }), 0)]), _vm._v(" "), _vm.activeTab === "pages" ? _c("div", { staticClass: "tab-content" }, [_vm.canCreatePage ? _c("div", { staticClass: "container-fluid" }, [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-sm-12 form-inline mb-4" }, [_c("div", { staticClass: "dropdown" }, [_c("button", { staticClass: "btn btn-success dropdown-toggle", attrs: { type: "button", id: "addPageDropdownButton", "data-toggle": "dropdown", "aria-haspopup": "true", "aria-expanded": "false" } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(`
                Add Page
              `)], 1), _vm._v(" "), _c("div", { staticClass: "dropdown-menu", attrs: { "aria-labelledby": "addPageDropdownButton" } }, [_vm._l(_vm.modules, function(moduleModel, index2) {
    return _c("a", { key: index2, staticClass: "dropdown-item", attrs: { id: moduleModel.id + "Page", href: _vm.createUrl("/Admin/" + moduleModel.createPageUrl) } }, [_vm._v(`
                  ` + _vm._s(_vm.addPageModuleNameText(moduleModel)) + `
                  `), moduleModel.license.enabled ? _c("span", { staticClass: "small text-muted" }, [_vm._v(_vm._s(_vm.addPageModuleUsedText(moduleModel)))]) : _c("span", { staticClass: "small text-muted" }, [_vm._v("(Unlicensed)")])]);
  }), _vm._v(" "), _c("a", { staticClass: "dropdown-item", attrs: { href: _vm.createUrl("/Admin/QLAPage") } }, [_vm._v("QLA - Quick Link Assistant")])], 2)])])])]) : _vm._e()]) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_c("div", { staticClass: "container-fluid" }, [_vm.activeTab ? _c(_vm.activeComponent, { tag: "component", attrs: { modules: _vm.modules, value: _vm.appPages }, on: { sort: _vm.orderAppPages, loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading"), refresh: _vm.refreshAppPages } }) : _vm._e()], 1)])]) : _vm._e()]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationAppPagesComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "830e1010"
);
const index = __component__.exports;
export {
  index as default
};
