var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { C as Component, a0 as userHasPermission, w as createUrl, V as Vue, bO as AdministrationDashboardClient, T as Transformer, b as baseUrl, t as toastr, n as normalizeComponent, M as Moment, ad as AdministrationAdminUsersClient } from "./main-DAVWuHbi.js";
import { Q as QuotaBar } from "./quotaBar-YBpud5Td.js";
var __getOwnPropDesc$9 = Object.getOwnPropertyDescriptor, __decorateClass$9 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$9(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$9"), _a;
let DatabaseStatusPanel$2 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "databaseStatus", null);
    __publicField(this, "isRunning", !1);
    __publicField(this, "errorMessage", null);
    __publicField(this, "hasDBAccess", null);
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.loadStatus(), 15e3), this.loadStatus(), this.hasDBAccess = await this.setDBaccess();
  }
  get dbOnline() {
    return this.isRunning && this.databaseStatus != null;
  }
  get dbNoConnection() {
    return !this.isRunning && this.databaseStatus == null;
  }
  async setDBaccess() {
    return await userHasPermission("adminActions.database");
  }
  get getCardHeaderVariant() {
    if (this.isRunning)
      return "success";
    if (!this.isRunning && this.databaseStatus != null)
      return "danger";
    if (!this.isRunning && this.databaseStatus == null)
      return "info";
  }
  loadStatus() {
    new AdministrationDashboardClient(new Transformer(), baseUrl()).getDatabaseStatus().then((function(model) {
      this.databaseStatus = model, model.error ? (this.errorMessage = model.error, toastr.error(model.error), this.isRunning = !1) : this.isRunning = !0;
    }).bind(this));
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
}, __name(_a, "DatabaseStatusPanel"), _a);
DatabaseStatusPanel$2 = __decorateClass$9([
  Component({
    methods: {
      createUrl,
      userHasPermission
    }
  })
], DatabaseStatusPanel$2);
var _sfc_render$9 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-lg-4 col-md-6 col-sm-12 mb-3" }, [_c("div", { staticClass: "card" }, [_vm.hasDBAccess ? _c("a", { attrs: { href: _vm.createUrl("/Admin/Database") } }, [_c("div", { staticClass: "card-header", class: "alert-" + _vm.getCardHeaderVariant }, [_c("font-awesome-icon", { attrs: { icon: "database" } }), _vm._v(" "), _c("b", [_vm._v(" Database")])], 1)]) : _c("span", [_c("div", { staticClass: "card-header", class: "alert-" + _vm.getCardHeaderVariant }, [_c("font-awesome-icon", { attrs: { icon: "database" } }), _vm._v(" "), _c("b", [_vm._v(" Database")])], 1)]), _vm._v(" "), _vm.databaseStatus ? _c("div", { staticClass: "card-body p-0" }, [_c("ul", { staticClass: "list-group list-group-flush" }, [_c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
          Status
          `), _c("span", { staticClass: "badge", class: { "badge-success": _vm.dbOnline, "badge-danger": !_vm.dbOnline } }, [_vm.dbNoConnection ? _c("font-awesome-icon", { attrs: { icon: "question" } }) : _vm.dbOnline ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(`
              ` + _vm._s(this.databaseStatus.status) + `
            `)], 1) : _vm._e(), _vm._v(" "), !_vm.dbOnline && _vm.errorMessage ? _c("span", { staticClass: "alert alert-danger p-1" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
               ` + _vm._s(this.databaseStatus.status) + ": " + _vm._s(this.errorMessage) + `
            `)], 1) : _vm._e()], 1)]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
          Database Type
          `), _c("i", [_vm._v(_vm._s(this.databaseStatus.databaseType))])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
          Database Server
          `), _c("i", [_vm._v(_vm._s(this.databaseStatus.location))])])])]) : _vm._e(), _vm._v(" "), _vm.databaseStatus ? _vm._e() : _c("div", { staticClass: "card-body" }, [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v(" Loading...")])], 1)])])]);
}, "render"), _sfc_staticRenderFns$9 = [], __component__$9 = /* @__PURE__ */ normalizeComponent(
  DatabaseStatusPanel$2,
  _sfc_render$9,
  _sfc_staticRenderFns$9,
  !1,
  null,
  null
);
const DatabaseStatusPanel$1 = __component__$9.exports;
var __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor, __decorateClass$8 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$8"), _a2;
let IntegrationStatusPanel$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "integrationStatus", null);
    __publicField(this, "loading", !0);
  }
  get configured() {
    return !this.loading && this.integrationStatus && this.integrationStatus.isConfigured;
  }
  get isRunning() {
    return this.configured && this.integrationStatus.isRunning && this.integrationStatus.integrationsConfiguration.status && !this.integrationStatus.hasConfigurationErrors;
  }
  get inErrorState() {
    return this.configured && !this.isRunning || this.integrationStatus && this.integrationStatus.hasConfigurationErrors;
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.loadStatus(), 3e4), this.loadStatus();
  }
  loadStatus() {
    new AdministrationDashboardClient(new Transformer(), baseUrl()).getIntegrationStatus().then((function(model) {
      this.integrationStatus = model;
    }).bind(this)).finally(() => {
      this.loading = !1;
    });
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
}, __name(_a2, "IntegrationStatusPanel"), _a2);
IntegrationStatusPanel$1 = __decorateClass$8([
  Component({
    methods: {
      createUrl
    }
  })
], IntegrationStatusPanel$1);
var _sfc_render$8 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-lg-4 col-md-6 col-sm-12 mb-3" }, [_c("div", { staticClass: "card" }, [_c("a", { attrs: { href: _vm.createUrl("/Admin/Integrations") } }, [_c("div", { staticClass: "card-header", class: { "alert-secondary": !_vm.configured, "alert-success": _vm.isRunning, "alert-danger": _vm.inErrorState } }, [_c("font-awesome-icon", { attrs: { icon: "server" } }), _vm._v(" "), _c("b", [_vm._v(" Integration Server")]), _vm._v(" "), _vm.inErrorState ? _c("a", { staticClass: "btn btn-outline-secondary btn-sm mt-n1 float-right", attrs: { href: _vm.createUrl("/Admin/Integrations") } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(" Check Settings")], 1) : _vm._e()], 1)]), _vm._v(" "), _c("div", { staticClass: "card-body", class: { "p-0": _vm.isRunning } }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", [_vm.configured ? _vm._e() : _c("div", { staticClass: "text-muted" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Integration hasn't been configured.\r
            `)], 1), _vm._v(" "), _vm.inErrorState ? _c("div", { staticClass: "text-danger p-2" }, [_c("h6", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` \r
                `), _vm.integrationStatus && _vm.integrationStatus.hasConfigurationErrors ? _c("span", [_vm._v(`\r
                    An integration configuration is invalid\r
                `)]) : _c("span", [_vm._v(` \r
                     Integrations are not connected\r
                `)])], 1), _vm._v(" "), _c("p", [_c("b", [_vm._v("Error message:")]), _vm._v(" "), _vm.integrationStatus && _vm.integrationStatus.hasConfigurationErrors ? _c("span", [_vm._v(`\r
                        There is a configuration error with one of the integrations\r
                    `)]) : _c("span", [_vm._v(` \r
                        Unable to get integration service details\r
                    `)])])]) : _vm._e(), _vm._v(" "), _vm.isRunning ? _c("b-list-group", { attrs: { flush: "" } }, [_c("b-list-group-item", { staticClass: "d-flex justify-content-between align-items-center" }, [_vm._v(`\r
                Endpoint\r
                `), _c("a", { staticClass: "text-break ml-2", attrs: { href: this.integrationStatus.integrationsConfiguration.endpoint, target: "_blank" } }, [_c("font-awesome-icon", { attrs: { icon: "link" } }), _vm._v(" " + _vm._s(this.integrationStatus.integrationsConfiguration.endpoint))], 1)]), _vm._v(" "), _c("b-list-group-item", { staticClass: "d-flex justify-content-between align-items-center" }, [_vm._v(`\r
                Total Requests\r
                `), _c("b-badge", { attrs: { pill: "", variant: this.integrationStatus.integrationsConfiguration.status.requestsSinceStartup ? "info" : "secondary" } }, [_vm._v(_vm._s(this.integrationStatus.integrationsConfiguration.status.requestsSinceStartup))])], 1), _vm._v(" "), _c("b-list-group-item", { staticClass: "d-flex justify-content-between align-items-center" }, [_vm._v(`\r
                Integrations\r
                `), _c("b-badge", { attrs: { pill: "", variant: this.integrationStatus.configuredIntegrations ? "info" : "secondary" } }, [_vm._v(_vm._s(this.integrationStatus.configuredIntegrations))])], 1)], 1) : _vm._e()], 1)])])]);
}, "render"), _sfc_staticRenderFns$8 = [], __component__$8 = /* @__PURE__ */ normalizeComponent(
  IntegrationStatusPanel$1,
  _sfc_render$8,
  _sfc_staticRenderFns$8,
  !1,
  null,
  null
);
const IntegrationStatusPanel = __component__$8.exports;
var __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor, __decorateClass$7 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$7"), _a3;
let AuthorityServerStatusPanel$1 = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "authorityServerStatus", null);
    __publicField(this, "loading", !0);
  }
  get configured() {
    return !this.loading && this.authorityServerStatus && this.authorityServerStatus.authorityServerInfo != null;
  }
  get inErrorState() {
    return !this.loading && this.authorityServerStatus && this.authorityServerStatus.errorMessage;
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.loadStatus(), 3e4), this.loadStatus();
  }
  loadStatus() {
    new AdministrationDashboardClient(new Transformer(), baseUrl()).getAuthorityServerStatus().then((function(model) {
      this.authorityServerStatus = model, this.loading = !1;
    }).bind(this));
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
}, __name(_a3, "AuthorityServerStatusPanel"), _a3);
AuthorityServerStatusPanel$1 = __decorateClass$7([
  Component({
    methods: {
      createUrl
    }
  })
], AuthorityServerStatusPanel$1);
var _sfc_render$7 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-lg-4 col-md-6 col-sm-12 mb-3" }, [_c("div", { staticClass: "card" }, [_c("a", { attrs: { href: _vm.createUrl("/Admin/Authority") } }, [_c("div", { staticClass: "card-header", class: { "alert-secondary": !_vm.configured, "alert-success": _vm.configured && !_vm.inErrorState, "alert-danger": _vm.inErrorState } }, [_c("font-awesome-icon", { attrs: { icon: "toolbox" } }), _vm._v(`\r
                 `), _c("b", [_vm._v("Authority Server")]), _vm._v(" "), _vm.inErrorState ? _c("a", { staticClass: "btn btn-outline-secondary btn-sm mt-n1 float-right", attrs: { href: _vm.createUrl("/Admin/Authority") } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(" Check Settings")], 1) : _vm._e()], 1)]), _vm._v(" "), _c("div", { staticClass: "card-body", class: { "p-0": _vm.configured && !_vm.inErrorState } }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", [_vm.inErrorState ? _c("div", { staticClass: "text-danger p-2" }, [_c("h6", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` The Authority Server is not connected\r
            `)], 1), _vm._v(" "), _c("p", [_c("b", [_vm._v("Error Message:")]), _vm._v(" " + _vm._s(_vm.authorityServerStatus.errorMessage))])]) : _vm._e(), _vm._v(" "), _vm.authorityServerStatus && _vm.authorityServerStatus.status ? _c("span", { staticClass: "text-muted" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`\r
              ` + _vm._s(this.authorityServerStatus.status) + `\r
          `)], 1) : _vm._e(), _vm._v(" "), _vm.configured ? _c("b-list-group", { attrs: { flush: "" } }, [_c("b-list-group-item", { staticClass: "d-flex justify-content-between align-items-center" }, [_vm._v(`\r
              Endpoint\r
              `), _c("a", { staticClass: "text-break ml-2", attrs: { href: this.authorityServerStatus.url, target: "_blank" } }, [_c("font-awesome-icon", { attrs: { icon: "link" } }), _vm._v(" " + _vm._s(this.authorityServerStatus.url))], 1)]), _vm._v(" "), _c("b-list-group-item", { staticClass: "d-flex justify-content-between align-items-center" }, [_vm._v(`\r
              Tables\r
              `), _c("b-badge", { attrs: { pill: "", variant: this.authorityServerStatus.authorityServerTables ? "info" : "secondary" } }, [_vm._v(_vm._s(this.authorityServerStatus.authorityServerTables))])], 1), _vm._v(" "), _c("b-list-group-item", { staticClass: "d-flex justify-content-between align-items-center" }, [_vm._v(`\r
              ID Counters\r
              `), _c("b-badge", { attrs: { pill: "", variant: this.authorityServerStatus.authorityServerIDCounters ? "info" : "secondary" } }, [_vm._v(_vm._s(this.authorityServerStatus.authorityServerIDCounters))])], 1)], 1) : _vm._e()], 1)])])]);
}, "render"), _sfc_staticRenderFns$7 = [], __component__$7 = /* @__PURE__ */ normalizeComponent(
  AuthorityServerStatusPanel$1,
  _sfc_render$7,
  _sfc_staticRenderFns$7,
  !1,
  null,
  null
);
const AuthorityServerStatusPanel = __component__$7.exports;
var __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$6"), _a4;
let IndexingStatisticsPanel$1 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "indexingStatistics", null);
    __publicField(this, "hasProcessorAccess", null);
    __publicField(this, "hasConcurrentAccess", null);
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.loadStatus(), 3e4), this.loadStatus(), this.hasProcessorAccess = await this.setProcessingAccess(), this.hasConcurrentAccess = await this.setConcurrentLink();
  }
  async setProcessingAccess() {
    return await userHasPermission("adminActions.indexingManagement");
  }
  async setConcurrentLink() {
    return await userHasPermission("adminActions.concurrentUsers");
  }
  get userBadgeVariant() {
    if (this.indexingStatistics.currentUserStatus.currentUserCount < this.indexingStatistics.currentUserStatus.maximumUsers)
      return "success";
    if (this.indexingStatistics.currentUserStatus.currentUserCount == this.indexingStatistics.currentUserStatus.maximumUsers)
      return "warning";
  }
  loadStatus() {
    new AdministrationDashboardClient(new Transformer(), baseUrl()).getIndexingStatistics().then((function(model) {
      this.indexingStatistics = model;
    }).bind(this));
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
}, __name(_a4, "IndexingStatisticsPanel"), _a4);
IndexingStatisticsPanel$1 = __decorateClass$6([
  Component({
    methods: {
      createUrl,
      userHasPermission
    }
  })
], IndexingStatisticsPanel$1);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-lg-4 col-md-6 col-sm-12 mb-3", attrs: { id: "indexingPanel" } }, [_c("div", { staticClass: "card" }, [_vm.indexingStatistics ? _c("span", [_vm.hasProcessorAccess ? _c("a", { attrs: { href: _vm.createUrl("/Admin/IndexingManagement"), id: "indexingManagement" } }, [_c("div", { staticClass: "card-header alert-info" }, [_vm.hasConcurrentAccess && _vm.indexingStatistics.currentUserStatus ? _c("a", { staticClass: "btn btn-outline-secondary btn-sm mt-n1 float-right", attrs: { href: _vm.createUrl("/Admin/ConcurrentUsers") } }, [_c("font-awesome-icon", { attrs: { icon: "users" } }), _vm._v(" "), _c("b", [_vm._v("Users: ")]), _vm._v(" "), _c("span", { staticClass: "badge badge-pill", class: "badge-" + _vm.userBadgeVariant }, [_vm._v(`
                        ` + _vm._s(_vm.indexingStatistics.currentUserStatus.currentUserCount) + "/" + _vm._s(_vm.indexingStatistics.currentUserStatus.maximumUsers) + `
                    `)])], 1) : _vm._e(), _vm._v(" "), _c("font-awesome-icon", { attrs: { icon: "info-circle" } }), _vm._v(" "), _c("b", [_vm._v(" Indexing Statistics")])], 1)]) : _c("span", [_c("div", { staticClass: "card-header alert-info" }, [_vm.hasConcurrentAccess && _vm.indexingStatistics.currentUserStatus ? _c("a", { staticClass: "btn btn-outline-secondary btn-sm mt-n1 float-right", attrs: { href: _vm.createUrl("/Admin/ConcurrentUsers") } }, [_c("font-awesome-icon", { attrs: { icon: "users" } }), _vm._v(" "), _c("b", [_vm._v("Users: ")]), _vm._v(" "), _c("span", { staticClass: "badge badge-pill", class: "badge-" + _vm.userBadgeVariant }, [_vm._v(`
                        ` + _vm._s(_vm.indexingStatistics.currentUserStatus.currentUserCount) + "/" + _vm._s(_vm.indexingStatistics.currentUserStatus.maximumUsers) + `
                    `)])], 1) : _vm._e(), _vm._v(" "), _c("font-awesome-icon", { attrs: { icon: "info-circle" } }), _vm._v(" "), _c("b", [_vm._v(" Indexing Statistics")])], 1)])]) : _vm._e(), _vm._v(" "), _vm.indexingStatistics ? _c("div", { staticClass: "card-body p-0" }, [_c("ul", { staticClass: "list-group list-group-flush" }, [_c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
                    Active Claims
                    `), _c("span", { staticClass: "badge badge-pill", class: { "badge-info": this.indexingStatistics.activeClaims, "badge-secondary": !this.indexingStatistics.activeClaims } }, [_vm._v(`
                        ` + _vm._s(this.indexingStatistics.activeClaims) + `
                    `)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
                    Files in Queue
                    `), _c("span", { staticClass: "badge badge-pill", class: { "badge-info": this.indexingStatistics.itemsInQueue, "badge-secondary": !this.indexingStatistics.itemsInQueue } }, [_vm._v(`
                        ` + _vm._s(this.indexingStatistics.itemsInQueue) + `
                    `)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
                    Files Uploaded (Past 24h)
                    `), _c("span", { staticClass: "badge badge-pill", class: { "badge-info": this.indexingStatistics.itemsUploadedInLastDay, "badge-secondary": !this.indexingStatistics.itemsUploadedInLastDay } }, [_vm._v(`
                        ` + _vm._s(this.indexingStatistics.itemsUploadedInLastDay) + `
                    `)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
                    History Events (Past 24h)
                    `), _c("span", { staticClass: "badge badge-pill", class: { "badge-info": this.indexingStatistics.historyEvents, "badge-secondary": !this.indexingStatistics.historyEvents } }, [_vm._v(`
                        ` + _vm._s(this.indexingStatistics.historyEvents) + `
                    `)])])])]) : _vm._e(), _vm._v(" "), _vm.indexingStatistics ? _vm._e() : _c("div", { staticClass: "card-body card-body-min-height" }, [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)])])]);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  IndexingStatisticsPanel$1,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  null
);
const IndexingStatisticsPanel = __component__$6.exports;
var __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$5"), _a5;
let FormStatisticsPanel$1 = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "formStatistics", null);
    __publicField(this, "hasFormManagementAccess", !1);
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.loadStatus(), 3e4), this.loadStatus(), this.hasFormManagementAccess = await this.setFormManagementAccess();
  }
  async setFormManagementAccess() {
    return await userHasPermission("adminActions.indexingManagement");
  }
  loadStatus() {
    new AdministrationDashboardClient(new Transformer(), baseUrl()).getFormStatistics().then((function(model) {
      this.formStatistics = model;
    }).bind(this));
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
}, __name(_a5, "FormStatisticsPanel"), _a5);
FormStatisticsPanel$1 = __decorateClass$5([
  Component({
    methods: {
      createUrl,
      userHasPermission
    }
  })
], FormStatisticsPanel$1);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-lg-4 col-md-6 col-sm-12 mb-3" }, [_c("div", { staticClass: "card" }, [_vm.hasFormManagementAccess ? _c("a", { attrs: { href: _vm.createUrl("/Admin/FormsManagement"), id: "formsManagement" } }, [_c("div", { staticClass: "card-header alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "info-circle" } }), _vm._v(" "), _c("b", [_vm._v(" Form Statistics")])], 1)]) : _c("div", { staticClass: "card-header alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "info-circle" } }), _vm._v(" "), _c("b", [_vm._v(" Form Statistics")])], 1), _vm._v(" "), _vm.formStatistics ? _c("div", { staticClass: "card-body p-0" }, [_c("ul", { staticClass: "list-group list-group-flush" }, [_c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`\r
                    Forms Saved\r
                    `), _c("span", { staticClass: "badge badge-pill", class: { "badge-info": this.formStatistics.formsActive, "badge-secondary": !this.formStatistics.formsActive } }, [_vm._v(`\r
                        ` + _vm._s(this.formStatistics.formsActive) + `\r
                    `)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`\r
                    Forms Pending\r
                    `), _c("span", { staticClass: "badge badge-pill", class: { "badge-info": this.formStatistics.formsPending, "badge-secondary": !this.formStatistics.formsPending } }, [_vm._v(`\r
                        ` + _vm._s(this.formStatistics.formsPending) + `\r
                    `)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`\r
                    Forms Approved\r
                    `), _c("span", { staticClass: "badge badge-pill", class: { "badge-info": this.formStatistics.formsApproved, "badge-secondary": !this.formStatistics.formsApproved } }, [_vm._v(`\r
                        ` + _vm._s(this.formStatistics.formsApproved) + `\r
                    `)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(` \r
                    Total Forms\r
                    `), _c("span", { staticClass: "badge badge-pill", class: { "badge-info": this.formStatistics.formsTotal, "badge-secondary": !this.formStatistics.formsTotal } }, [_vm._v(`\r
                        ` + _vm._s(this.formStatistics.formsTotal) + `\r
                    `)])])])]) : _vm._e(), _vm._v(" "), _vm.formStatistics ? _vm._e() : _c("div", { staticClass: "card-body card-body-min-height" }, [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)])])]);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  FormStatisticsPanel$1,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  null
);
const FormStatisticsPanel = __component__$5.exports;
var __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$4"), _a6;
let QuotaStatisticsPanel$1 = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "loading", !0);
    __publicField(this, "errorMessage");
    __publicField(this, "loadingFormActive", !1);
    __publicField(this, "loadingIndexingActive", !1);
    __publicField(this, "activeFormsQuotas", []);
    __publicField(this, "activeIndexingQuotas", []);
    __publicField(this, "activeAppCreditQuotas", []);
  }
  get hasExceededQuota() {
    if (this.activeFormsQuotas && this.activeFormsQuotas.length) {
      for (var i = 0; i < this.activeFormsQuotas.length; i++)
        if (this.activeFormsQuotas[i].used >= this.activeFormsQuotas[i].total)
          return !0;
    }
    if (this.activeIndexingQuotas && this.activeIndexingQuotas.length) {
      for (var i = 0; i < this.activeIndexingQuotas.length; i++)
        if (this.activeIndexingQuotas[i].used >= this.activeIndexingQuotas[i].total)
          return !0;
    }
    if (this.activeAppCreditQuotas && this.activeAppCreditQuotas.length) {
      for (var i = 0; i < this.activeAppCreditQuotas.length; i++)
        if (this.activeAppCreditQuotas[i].used >= this.activeAppCreditQuotas[i].total)
          return !0;
    }
    return !1;
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.reloadQuotas(), 3e4), this.reloadQuotas();
  }
  get hasQuotas() {
    return this.activeFormsQuotas != null && this.activeFormsQuotas.length || this.activeIndexingQuotas != null && this.activeIndexingQuotas.length || this.activeAppCreditQuotas != null && this.activeAppCreditQuotas.length;
  }
  async reloadQuotas() {
    try {
      this.loadingFormActive = !0;
      let client = new AdministrationDashboardClient(new Transformer(), baseUrl());
      this.activeFormsQuotas = await client.getFormsQuota();
    } catch (e) {
      throw this.errorMessage = "Failed to load form quotas", toastr.error(e, "Failed to load form quotas"), e;
    } finally {
      this.loadingFormActive = !1;
    }
    try {
      this.loadingFormActive = !0;
      let client = new AdministrationDashboardClient(new Transformer(), baseUrl());
      this.activeIndexingQuotas = await client.getIndexingQuota();
    } catch (e) {
      throw this.errorMessage = "Failed to load indexing quotas", toastr.error(e, "Failed to load quotas"), e;
    } finally {
      this.loadingIndexingActive = !1, this.loading = !1;
    }
    try {
      this.loadingFormActive = !0;
      let client = new AdministrationDashboardClient(new Transformer(), baseUrl());
      this.activeAppCreditQuotas = await client.getAppCreditQuota();
    } catch (e) {
      throw this.errorMessage = "Failed to load AppCredit quotas", toastr.error(e, "Failed to load quotas"), e;
    } finally {
      this.loadingIndexingActive = !1, this.loading = !1;
    }
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
}, __name(_a6, "QuotaStatisticsPanel"), _a6);
QuotaStatisticsPanel$1 = __decorateClass$4([
  Component({
    components: {
      QuotaBar
    },
    methods: {
      createUrl
    }
  })
], QuotaStatisticsPanel$1);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-lg-4 col-md-6 col-sm-12 mb-3" }, [_c("div", { staticClass: "card" }, [_c("a", { attrs: { href: _vm.createUrl("/Admin/Quota") } }, [_c("div", { staticClass: "card-header", class: { "alert-success": _vm.hasQuotas && !_vm.hasExceededQuota, "alert-secondary": _vm.loading || !_vm.hasQuotas, "alert-danger": _vm.hasExceededQuota } }, [_c("font-awesome-icon", { attrs: { icon: "exchange-alt" } }), _vm._v(" "), _c("b", [_vm._v(" Throughput Quotas")])], 1)]), _vm._v(" "), _vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", { staticClass: "card-body", class: { "p-0 pb-3": _vm.hasQuotas && !_vm.loading } }, [_vm.activeFormsQuotas && _vm.activeFormsQuotas.length > 0 && !_vm.loading ? _c("div", { staticClass: "row ml-1 mt-1" }, [_c("div", { staticClass: "col-md-11 col-sm-12" }, [_c("h5", [_vm._v("Form Quotas")]), _vm._v(" "), _vm.activeFormsQuotas && _vm.activeFormsQuotas.length > 0 ? _c("div", [_vm._l(_vm.activeFormsQuotas, function(quota) {
    return [_c("quota-bar", { attrs: { total: quota.total, used: quota.used, expiry: quota.expiry } })];
  })], 2) : _c("div", { staticClass: "alert alert-secondary", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" No active Forms quotas.")], 1)]), _vm._v(" "), _c("hr")]) : _vm._e(), _vm._v(" "), _vm.activeIndexingQuotas && _vm.activeIndexingQuotas.length > 0 && !_vm.loading ? _c("div", { staticClass: "row ml-1 mt-1" }, [_c("div", { staticClass: "col-md-11 col-sm-12" }, [_c("h5", [_vm._v("Indexing Quotas")]), _vm._v(" "), _vm.activeIndexingQuotas && _vm.activeIndexingQuotas.length > 0 ? _c("div", [_vm._l(_vm.activeIndexingQuotas, function(quota) {
    return [_c("quota-bar", { attrs: { total: quota.total, used: quota.used, expiry: quota.expiry } })];
  })], 2) : _c("div", { staticClass: "alert alert-secondary", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" No active Indexing quotas.")], 1)]), _vm._v(" "), _c("hr")]) : _vm._e(), _vm._v(" "), _vm.activeAppCreditQuotas && _vm.activeAppCreditQuotas.length > 0 && !_vm.loading ? _c("div", { staticClass: "row ml-1 mt-1" }, [_c("div", { staticClass: "col-md-11 col-sm-12" }, [_c("h5", [_vm._v("App Credits")]), _vm._v(" "), _vm.activeAppCreditQuotas && _vm.activeAppCreditQuotas.length > 0 ? _c("div", [_vm._l(_vm.activeAppCreditQuotas, function(quota) {
    return [_c("quota-bar", { attrs: { total: quota.total, used: quota.used, expiry: quota.expiry } })];
  })], 2) : _c("div", { staticClass: "alert alert-secondary", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" No active App Credits.")], 1)]), _vm._v(" "), _c("hr")]) : _vm._e(), _vm._v(" "), !_vm.hasQuotas && !_vm.loading ? _c("div", { staticClass: "text-muted" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` No Active Quotas.
          `)], 1) : _vm._e()])])]);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  QuotaStatisticsPanel$1,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  null
);
const QuotaStatisticsPanel = __component__$4.exports;
var __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$3"), _a7;
let EzescanServerStatusPanel$1 = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "ezescanServerStatus", null);
    __publicField(this, "isRunning", !1);
    __publicField(this, "loading", !0);
  }
  get inWarningState() {
    return !this.loading && this.ezescanServerStatus && this.ezescanServerStatus.serverOnlineCount < this.ezescanServerStatus.instanceCount;
  }
  get inErrorState() {
    return !this.loading && this.ezescanServerStatus && this.ezescanServerStatus.serverOnlineCount == 0 && this.ezescanServerStatus.instanceCount > 0;
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.loadStatus(), 3e4), this.loadStatus();
  }
  loadStatus() {
    new AdministrationDashboardClient(new Transformer(), baseUrl()).getEzescanServerStatus().then((function(model) {
      this.ezescanServerStatus = model, this.loading = !1, !this.ezescanServerStatus.instanceCount && !this.ezescanServerStatus.poolCount ? this.isRunning = !1 : this.isRunning = !0;
    }).bind(this));
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
}, __name(_a7, "EzescanServerStatusPanel"), _a7);
EzescanServerStatusPanel$1 = __decorateClass$3([
  Component({
    methods: {
      createUrl
    }
  })
], EzescanServerStatusPanel$1);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-lg-4 col-md-6 col-sm-12 mb-3" }, [_c("div", { staticClass: "card" }, [_c("a", { attrs: { href: _vm.createUrl("/Admin/EzeScan") } }, [_c("div", { staticClass: "card-header", class: { "alert-secondary": !_vm.isRunning, "alert-success": _vm.isRunning && !_vm.inWarningState && !_vm.inErrorState && !_vm.loading, "alert-warning": _vm.inWarningState, "alert-danger": _vm.inErrorState } }, [_c("font-awesome-icon", { attrs: { icon: "server" } }), _vm._v(" "), _c("b", [_vm._v(" EzeScan Servers")]), _vm._v(" "), _vm.inErrorState ? _c("a", { staticClass: "btn btn-outline-secondary btn-sm mt-n1 float-right", attrs: { href: _vm.createUrl("/Admin/Ezescan") } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(" Check Settings")], 1) : _vm._e()], 1)]), _vm._v(" "), _c("div", { staticClass: "card-body", class: { "p-0": _vm.isRunning && !_vm.inErrorState } }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", [_vm.isRunning ? _c("b-list-group", { attrs: { flush: "" } }, [_c("b-list-group-item", { staticClass: "d-flex justify-content-between align-items-center" }, [_vm._v(`\r
              Server Instances\r
              `), _c("b-dropdown", { attrs: { "no-flip": "", id: "instancesDropdown", text: _vm.ezescanServerStatus.instances.length, right: "", size: "sm", "menu-class": "py-0", "toggle-class": "badge badge-info badge-pill", variant: _vm.ezescanServerStatus.instances.length ? "info" : "secondary" } }, _vm._l(_vm.ezescanServerStatus.instances, function(instance) {
    return _c("b-dropdown-item", { attrs: { target: "_blank", href: instance.endpoint } }, [_c("font-awesome-icon", { attrs: { icon: "link" } }), _vm._v(`\r
                  ` + _vm._s(instance.name) + " - "), _c("i", [_vm._v(_vm._s(instance.endpoint))])], 1);
  }), 1)], 1), _vm._v(" "), _c("b-list-group-item", { staticClass: "d-flex justify-content-between align-items-center" }, [_vm._v(`\r
              Server Pools\r
              `), _c("b-badge", { attrs: { pill: "", variant: _vm.ezescanServerStatus.poolCount ? "info" : "secondary" } }, [_vm._v(_vm._s(_vm.ezescanServerStatus.poolCount))])], 1), _vm._v(" "), _c("b-list-group-item", { staticClass: "d-flex justify-content-between align-items-center" }, [_vm._v(`\r
              Pool Routes\r
              `), _c("b-badge", { attrs: { pill: "", variant: _vm.ezescanServerStatus.routeCount ? "info" : "secondary" } }, [_vm._v(_vm._s(_vm.ezescanServerStatus.routeCount))])], 1)], 1) : _c("div", { staticClass: "text-muted" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` No EzeScan Servers have been configured.\r
          `)], 1)], 1)])])]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  EzescanServerStatusPanel$1,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const EzescanServerStatusPanel = __component__$3.exports;
var __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$2"), _a8;
let LicenseStatusPanel$1 = (_a8 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "licenseStatus", null);
    __publicField(this, "loading", !0);
  }
  get configured() {
    return !this.loading && this.licenseStatus != null;
  }
  get hasLicense() {
    return this.configured && this.licenseStatus.license && !this.inErrorState;
  }
  get inErrorState() {
    return this.configured && this.licenseStatus.error && this.hasRealError;
  }
  get isCloudLicense() {
    return this.configured && this.licenseStatus && this.licenseStatus.cmsLicenseId != null;
  }
  get expiresSoon() {
    return !this.licenseStatus || !this.licenseStatus.status || !this.licenseStatus.license || this.licenseStatus.license.expired ? !1 : this.licenseStatus.cmsLicenseId ? this.daysLeftToExpiry <= 14 : this.daysLeftToExpiry <= 30;
  }
  get daysLeftToExpiry() {
    var _a11, _b;
    if ((_b = (_a11 = this.licenseStatus) == null ? void 0 : _a11.license) != null && _b.expiry)
      return Moment(this.licenseStatus.license.expiry).diff(Moment(), "days");
  }
  get daysLeftToExpiryMessage() {
    var _a11, _b;
    if ((_b = (_a11 = this.licenseStatus) == null ? void 0 : _a11.license) != null && _b.expiry) {
      var daysLeft = this.daysLeftToExpiry;
      return daysLeft == 0 ? "Expires Today" : daysLeft == 1 ? "Expires in 1 day" : `Expires in ${daysLeft} days`;
    }
    return null;
  }
  get hasRealError() {
    var _a11, _b, _c;
    return !(!((_a11 = this.licenseStatus) != null && _a11.error) || ((_b = this.licenseStatus) == null ? void 0 : _b.error.indexOf("This instance of EzeScan WebApps is set to expire")) > -1 || ((_c = this.licenseStatus) == null ? void 0 : _c.error) == "This is a Demonstration instance of EzeScan WebApps");
  }
  get isDemostrationInstance() {
    var _a11;
    return ((_a11 = this.licenseStatus) == null ? void 0 : _a11.error) == "This is a Demonstration instance of EzeScan WebApps";
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.loadStatus(), 3e4), this.loadStatus();
  }
  loadStatus() {
    new AdministrationDashboardClient(new Transformer(), baseUrl()).getLicense().then((model) => {
      this.licenseStatus = model;
    }).catch((e) => {
      toastr.error("Something has gone wrong while loading the license: " + e);
    }).finally(() => {
      this.loading = !1;
    });
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
}, __name(_a8, "LicenseStatusPanel"), _a8);
LicenseStatusPanel$1 = __decorateClass$2([
  Component({
    methods: {
      createUrl
    }
  })
], LicenseStatusPanel$1);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-lg-4 col-md-6 col-sm-12 mb-3" }, [_c("div", { staticClass: "card" }, [_c("a", { attrs: { href: _vm.createUrl("/Admin/License") } }, [_c("div", { staticClass: "card-header", class: {
    "alert-secondary": !_vm.configured,
    "alert-success": _vm.hasLicense && !_vm.expiresSoon,
    "alert-danger": _vm.inErrorState,
    "alert-warning": _vm.expiresSoon || _vm.isDemostrationInstance
  } }, [_c("font-awesome-icon", { attrs: { icon: "certificate" } }), _vm._v(" "), _c("b", [_vm._v(` License \r
                    `), _vm.expiresSoon && !_vm.inErrorState ? _c("span", { staticClass: "badge badge-warning float-right mt-1" }, [_vm._v(" " + _vm._s(_vm.daysLeftToExpiryMessage))]) : _vm._e(), _vm._v(" "), _vm.isDemostrationInstance && !_vm.inErrorState ? _c("span", { staticClass: "badge badge-warning float-right mt-1 mr-1" }, [_vm._v(" Demonstration License")]) : _vm._e(), _vm._v(" "), !_vm.expiresSoon && !_vm.isDemostrationInstance && _vm.isCloudLicense && !_vm.inErrorState ? _c("span", { staticClass: "badge badge-success float-right mt-1 mr-1" }, [_c("font-awesome-icon", { attrs: { icon: "clouds" } }), _vm._v(`\r
                         Cloud License\r
                    `)], 1) : _vm._e()]), _vm._v(" "), _vm.inErrorState ? _c("a", { staticClass: "btn btn-outline-secondary btn-sm mt-n1 float-right", attrs: { href: _vm.createUrl("/Admin/License") } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(`\r
                     Check Settings\r
                `)], 1) : _vm._e()], 1)]), _vm._v(" "), _c("div", { staticClass: "card-body", class: { "p-0": _vm.hasLicense } }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", [_vm.configured ? _vm._e() : _c("div", { staticClass: "text-muted" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` License hasn't been configured.\r
            `)], 1), _vm._v(" "), _vm.inErrorState ? _c("div", { staticClass: "text-danger p-2" }, [_c("h6", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` There is an issue with the Ezescan WebApps license:\r
              `)], 1), _vm._v(" "), _c("p", [_vm._v(_vm._s(_vm.licenseStatus.error))])]) : _vm._e(), _vm._v(" "), _vm.hasLicense ? _c("ul", { staticClass: "list-group list-group-flush" }, [_c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`\r
                    Status\r
                    `), _c("span", { staticClass: "badge", class: { "badge-success": _vm.licenseStatus.status.valid, "badge-danger": !_vm.licenseStatus.status.valid } }, [_vm.licenseStatus.status.valid ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(`\r
                            License Valid\r
                        `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(`\r
                            License Invalid\r
                        `)], 1)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`\r
                    Hostname\r
                    `), _c("i", { staticClass: "text-break ml-2" }, [_vm._v(_vm._s(_vm.licenseStatus.license.host))])]), _vm._v(" "), !_vm.isCloudLicense || _vm.expiresSoon ? _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`\r
                    Expiry\r
                    `), [_c("span", { staticClass: "badge", class: {
    "badge-danger": _vm.licenseStatus.status.expired,
    "badge-warning": _vm.expiresSoon,
    "badge-success": _vm.licenseStatus.status.valid
  } }, [_vm._v(`\r
                            ` + _vm._s(_vm.$options.filters.toHumanReadableDate(_vm.licenseStatus.license.expiry)) + `\r
                        `)])]], 2) : _vm._e(), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`\r
                    Type\r
                    `), _c("i", [_vm._v(_vm._s(_vm.$options.filters.capitaliseFirstLetter(_vm.licenseStatus.license.type)))])])]) : _vm._e()])])])]);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  LicenseStatusPanel$1,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  null
);
const LicenseStatusPanel = __component__$2.exports;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$1"), _a9;
let DatabaseStatusPanel = (_a9 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "storageStatus", null);
    __publicField(this, "errorMessage", null);
    __publicField(this, "isRunning", !1);
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.loadStatus(), 15e3), this.loadStatus();
  }
  async loadStatus() {
    try {
      let model = await new AdministrationDashboardClient(new Transformer(), baseUrl()).getAzureStatus();
      this.storageStatus = model;
    } catch (ex) {
      toastr.error(ex), this.errorMessage = ex;
    } finally {
      this.isRunning = !1;
    }
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
}, __name(_a9, "DatabaseStatusPanel"), _a9);
DatabaseStatusPanel = __decorateClass$1([
  Component({
    methods: {
      createUrl
    }
  })
], DatabaseStatusPanel);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-lg-4 col-md-6 col-sm-12 mb-3" }, [_c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header", class: "alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "clouds" } }), _vm._v(" "), _c("b", [_vm._v(" Storage Container")])], 1), _vm._v(" "), _vm.storageStatus ? _c("div", { staticClass: "card-body p-0" }, [_c("ul", { staticClass: "list-group list-group-flush" }, [_c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
          Account Name
          `), _c("i", [_vm._v(_vm._s(this.storageStatus.accountName))])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
          Blob Container
          `), _c("i", [_vm._v(_vm._s(this.storageStatus.blobName))])])])]) : _vm._e(), _vm._v(" "), _vm.storageStatus ? _vm._e() : _c("div", { staticClass: "card-body" }, [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v(" Loading...")])], 1)])])]);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  DatabaseStatusPanel,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const AzureStorageStatusPanel = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a10;
let AdministrationDashboardComponent = (_a10 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "accessibleFeatures", null);
    __publicField(this, "loading", !1);
    __publicField(this, "hasAppPagesPermission", !1);
    __publicField(this, "usingAzureBlob", !1);
    __publicField(this, "hasIndexingStatsPermission", !1);
    __publicField(this, "hasFormsStatsPermission", !1);
    __publicField(this, "hasAuthorityPermission", !1);
    __publicField(this, "hasIntegrationsPermission", !1);
    __publicField(this, "hasEzeScanPermission", !1);
    __publicField(this, "hasQuotaPermission", !1);
    __publicField(this, "hasLicensePermission", !1);
  }
  async mounted() {
    await this.checkAzure(), this.hasAppPagesPermission = await userHasPermission("apppages"), this.hasIndexingStatsPermission = await userHasPermission("adminActions.indexingManagement") || this.hasAppPagesPermission, this.hasFormsStatsPermission = await userHasPermission("adminActions.formsManagement") || this.hasAppPagesPermission, this.hasAuthorityPermission = await userHasPermission("authority"), this.hasIntegrationsPermission = await userHasPermission("integrations"), this.hasQuotaPermission = await userHasPermission("quota"), this.hasEzeScanPermission = await userHasPermission("ezescan"), this.hasLicensePermission = await userHasPermission("license"), this.loadAdminFeatureAccess();
  }
  async loadAdminFeatureAccess() {
    this.loading = !0;
    try {
      this.accessibleFeatures = await new AdministrationAdminUsersClient(new Transformer(), baseUrl()).getAccessibleAdministratorFeatures();
    } catch (e) {
      toastr.error("Something has gone wrong while loading the settings: " + e);
    } finally {
      this.loading = !1;
    }
  }
  async checkAzure() {
    try {
      this.usingAzureBlob = await new AdministrationDashboardClient(new Transformer(), baseUrl()).checkUsingAzure();
    } catch (e) {
      toastr.error("Something has gone wrong while loading the settings: " + e);
    }
  }
}, __name(_a10, "AdministrationDashboardComponent"), _a10);
AdministrationDashboardComponent = __decorateClass([
  Component({
    components: {
      DatabaseStatusPanel: DatabaseStatusPanel$1,
      AuthorityServerStatusPanel,
      IntegrationStatusPanel,
      IndexingStatisticsPanel,
      FormStatisticsPanel,
      QuotaStatisticsPanel,
      EzescanServerStatusPanel,
      LicenseStatusPanel,
      AzureStorageStatusPanel
    }
  })
], AdministrationDashboardComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "chart-line" } }), _vm._v(" Dashboard")], 1)]), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("database-status-panel"), _vm._v(" "), _vm.hasIndexingStatsPermission ? _c("indexing-statistics-panel") : _vm._e(), _vm._v(" "), _vm.hasFormsStatsPermission ? _c("form-statistics-panel") : _vm._e(), _vm._v(" "), _vm.hasAuthorityPermission ? _c("authority-server-status-panel") : _vm._e(), _vm._v(" "), _vm.hasIntegrationsPermission ? _c("integration-status-panel") : _vm._e(), _vm._v(" "), _vm.hasEzeScanPermission ? _c("ezescan-server-status-panel") : _vm._e(), _vm._v(" "), _vm.hasQuotaPermission ? _c("quota-statistics-panel") : _vm._e(), _vm._v(" "), _vm.hasLicensePermission ? _c("license-status-panel") : _vm._e(), _vm._v(" "), _vm.usingAzureBlob ? _c("azure-storage-status-panel") : _vm._e()], 1)]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationDashboardComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "c9336562"
);
const index = __component__.exports;
export {
  index as default
};
