var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, n as normalizeComponent, W as Watch, N as CheckIcon, _, bT as AdministrationDatabaseClient, T as Transformer, b as baseUrl, t as toastr, z as systemInAzureMode } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$4"), _a;
let AdministrationDatabaseRebuildModalComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "databaseToRebuild");
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("rebuild-modal");
  }
  get modalTitle() {
    var _a6;
    return "Reorganise " + ((_a6 = this.databaseToRebuild) == null ? void 0 : _a6.databaseName) + " indexes?";
  }
}, __name(_a, "AdministrationDatabaseRebuildModalComponent"), _a);
__decorateClass$4([
  Prop({ required: !0 })
], AdministrationDatabaseRebuildModalComponent.prototype, "databaseToRebuild", 2);
AdministrationDatabaseRebuildModalComponent = __decorateClass$4([
  Component({})
], AdministrationDatabaseRebuildModalComponent);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "rebuild-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return cancel();
    }, "click") } }, [_vm._v(`
      Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.confirm();
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Rebuild
    `)], 1)];
  }, "fn") }]) }, [_c("div", [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`  Are you sure you want to reorganise the indexes on this database?
        `), _c("ul", { staticClass: "mb-0" }, [_c("li", [_vm._v("This process may take a while and may slow down normal usage. ")]), _vm._v(" "), _c("li", [_vm._v("It is recommended to perform this action outside of high-usage hours.")])])], 1)], 1)]);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  AdministrationDatabaseRebuildModalComponent,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  null
);
const RebuildModal = __component__$4.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$3"), _a2;
let AdministrationDatabaseIndexesModalComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "database");
  }
  get modalTitle() {
    var _a6;
    return (_a6 = this.database) == null ? void 0 : _a6.databaseName;
  }
}, __name(_a2, "AdministrationDatabaseIndexesModalComponent"), _a2);
__decorateClass$3([
  Prop({
    required: !0,
    default: null
  })
], AdministrationDatabaseIndexesModalComponent.prototype, "database", 2);
AdministrationDatabaseIndexesModalComponent = __decorateClass$3([
  Component({})
], AdministrationDatabaseIndexesModalComponent);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "index-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "ok-only": "" } }, [_vm.database ? _c("div", [_c("b-table", { attrs: { items: _vm.database.indexes } })], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  AdministrationDatabaseIndexesModalComponent,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const IndexesModal = __component__$3.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$2"), _a3;
let AdministrationDatabaseRecurringRebuildModalComponent = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "databaseSettings");
    __publicField(this, "daysOfTheWeek");
    __publicField(this, "showSchedule", !1);
  }
  modalLoading() {
    this.databaseSettings.reorganiseSchedule ? this.showSchedule = !0 : this.showSchedule = !1;
  }
  get reorganiseSchedule() {
    return this.databaseSettings.reorganiseSchedule ? this.databaseSettings.reorganiseSchedule.split(";") : [];
  }
  set reorganiseSchedule(value) {
    this.databaseSettings.reorganiseSchedule = value.join(";");
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("recurring-rebuild-modal");
  }
  close() {
    this.$bvModal.hide("recurring-rebuild-modal");
  }
  get modalTitle() {
    return "Schedule reorganise indexes";
  }
}, __name(_a3, "AdministrationDatabaseRecurringRebuildModalComponent"), _a3);
__decorateClass$2([
  Prop({ required: !0 })
], AdministrationDatabaseRecurringRebuildModalComponent.prototype, "databaseSettings", 2);
__decorateClass$2([
  Prop({ required: !0 })
], AdministrationDatabaseRecurringRebuildModalComponent.prototype, "daysOfTheWeek", 2);
__decorateClass$2([
  Watch("databaseSettings")
], AdministrationDatabaseRecurringRebuildModalComponent.prototype, "modalLoading", 1);
AdministrationDatabaseRecurringRebuildModalComponent = __decorateClass$2([
  Component({
    components: {
      DateDisplay,
      CheckIcon
    }
  })
], AdministrationDatabaseRecurringRebuildModalComponent);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "recurring-rebuild-modal", title: _vm.modalTitle, "no-close-on-backdrop": "" }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "success" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.confirm();
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1)];
  }, "fn") }]) }, [_vm.databaseSettings.lastReorganised ? _c("b-alert", { attrs: { show: "" } }, [_c("b", [_c("font-awesome-icon", { attrs: { icon: "clock" } }), _vm._v(" Last reorganised:")], 1), _vm._v(" "), _c("date-display", { attrs: { value: _vm.databaseSettings.lastReorganised } })], 1) : _vm._e(), _vm._v(" "), _c("b-form-group", { attrs: { description: "Shows whether the database indexes will be reorganised tonight" } }, [_c("b-form-checkbox", { attrs: { switch: "" }, model: { value: _vm.databaseSettings.reorganiseToday, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.databaseSettings, "reorganiseToday", $$v);
  }, "callback"), expression: "databaseSettings.reorganiseToday" } }, [_c("b", [_vm._v("Reorganise indexes tonight")])])], 1), _vm._v(" "), _c("b-form-group", { attrs: { description: "Automatically run the reorganising tool on specific days of the week at midnight server time" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Reorganising schedule")]), _vm._v(" "), _vm._l(_vm.daysOfTheWeek, function(day) {
    return _c("div", { key: day.name, staticClass: "form-group" }, [_c("div", { staticClass: "pretty p-svg p-curve p-smooth" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.reorganiseSchedule, expression: "reorganiseSchedule" }], staticClass: "form-check-input", attrs: { type: "checkbox" }, domProps: { value: day.number, checked: Array.isArray(_vm.reorganiseSchedule) ? _vm._i(_vm.reorganiseSchedule, day.number) > -1 : _vm.reorganiseSchedule }, on: { change: /* @__PURE__ */ __name(function($event) {
      var $$a = _vm.reorganiseSchedule, $$el = $event.target, $$c = !!$$el.checked;
      if (Array.isArray($$a)) {
        var $$v = day.number, $$i = _vm._i($$a, $$v);
        $$el.checked ? $$i < 0 && (_vm.reorganiseSchedule = $$a.concat([$$v])) : $$i > -1 && (_vm.reorganiseSchedule = $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
      } else
        _vm.reorganiseSchedule = $$c;
    }, "change") } }), _vm._v(" "), _c("div", { staticClass: "state p-primary" }, [_c("span", { staticClass: "svg svg-icon" }, [_c("CheckIcon")], 1), _vm._v(" "), _c("label", [_vm._v(_vm._s(day.name))])])])]);
  })], 2)], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  AdministrationDatabaseRecurringRebuildModalComponent,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  null
);
const SettingsModal = __component__$2.exports;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$1"), _a4;
let AdministrationRefreshMetadataValuesModalComponent = (_a4 = class extends Vue {
  confirm() {
    this.$emit("confirm");
  }
}, __name(_a4, "AdministrationRefreshMetadataValuesModalComponent"), _a4);
AdministrationRefreshMetadataValuesModalComponent = __decorateClass$1([
  Component({})
], AdministrationRefreshMetadataValuesModalComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "metadataValues-modal", title: "Refresh Metadata Values", "no-close-on-backdrop": "", "cancel-variant": "" }, on: { ok: _vm.confirm } }, [_c("div", [_c("b-alert", { attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`  Are you sure you want to refresh all metadata values?
                `), _c("ul", [_c("li", [_vm._v("This process is only recommended items are not displaying metadata values correctly. ")]), _vm._v(" "), _c("li", [_vm._v("Refreshing the metadata values will have an effect on SQL Databases.")])])], 1)], 1)]);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  AdministrationRefreshMetadataValuesModalComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const RefreshMetadataValuesModal = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a5;
let AdministrationDatabaseComponent = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "databaseInfo", null);
    __publicField(this, "databaseToRebuild", null);
    __publicField(this, "databaseToView", null);
    __publicField(this, "isLoading", !0);
    __publicField(this, "scheduleDatabaseSettings", null);
    __publicField(this, "isAzureMode", !1);
  }
  rebuildClicked(database) {
    this.databaseToRebuild = database;
  }
  viewDatabaseClicked(database) {
    this.databaseToView = database;
  }
  showScheduleModal() {
    this.scheduleDatabaseSettings = _.cloneDeep(this.databaseInfo.databaseSettings);
  }
  async refreshMetadataValues() {
    await new AdministrationDatabaseClient(new Transformer(), baseUrl()).refreshMetadataValues();
  }
  async rebuildIndexes() {
    this.databaseToRebuild.isRebuilding = !0, this.databaseToRebuild.rebuildSuccess = !1, this.databaseToRebuild.rebuildError = null;
    var response = await new AdministrationDatabaseClient(new Transformer(), baseUrl()).rebuildDatabaseIndexes(this.databaseToRebuild);
    if (response != null && response.databaseName) {
      var currentDatabaseInfo = this.databaseInfo.databases.find(function(e) {
        return e.databaseName == response.databaseName;
      });
      if (currentDatabaseInfo != null) {
        for (var key in currentDatabaseInfo)
          currentDatabaseInfo[key] = response[key];
        currentDatabaseInfo.isRebuilding = !1;
      }
    }
  }
  async saveDatabaseSettings() {
    let runToday = null;
    this.scheduleDatabaseSettings.reorganiseToday !== this.databaseInfo.databaseSettings.reorganiseToday && (runToday = this.scheduleDatabaseSettings.reorganiseToday);
    let response = await new AdministrationDatabaseClient(new Transformer(), baseUrl()).scheduleRebuildDatabaseIndexes(runToday, this.scheduleDatabaseSettings.reorganiseSchedule);
    this.databaseInfo.databaseSettings = response, toastr.success("Reorganise schedule settings saved");
  }
  async mounted() {
    this.isAzureMode = await systemInAzureMode(), await this.loadStatus();
  }
  async loadStatus() {
    var model = await new AdministrationDatabaseClient(new Transformer(), baseUrl()).getDatabaseInfo();
    this.isLoading = !1, this.databaseInfo = model;
  }
  get daysOfTheWeek() {
    return [
      { number: 1, name: "Monday" },
      { number: 2, name: "Tuesday" },
      { number: 3, name: "Wednesday" },
      { number: 4, name: "Thursday" },
      { number: 5, name: "Friday" },
      { number: 6, name: "Saturday" },
      { number: 7, name: "Sunday" }
    ];
  }
  getFragmentationLevelClass(indexFragmentationLevel) {
    switch (indexFragmentationLevel) {
      case "Low":
        return "badge-success";
      case "Medium":
        return "badge-warning";
      case "High":
        return "badge-danger";
      default:
        return "badge-info";
    }
  }
}, __name(_a5, "AdministrationDatabaseComponent"), _a5);
AdministrationDatabaseComponent = __decorateClass([
  Component({
    components: {
      RefreshMetadataValuesModal,
      RebuildModal,
      IndexesModal,
      SettingsModal,
      DateDisplay
    },
    methods: {
      systemInAzureMode
    }
  })
], AdministrationDatabaseComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h2", [_c("font-awesome-icon", { attrs: { icon: "database" } }), _vm._v(" Database Management")], 1)]), _vm._v(" "), _c("div", { staticClass: "row" }, [_vm.databaseInfo ? _c("div", { staticClass: "col" }, [_vm.databaseInfo.databases.filter((db) => db.databaseType == "SQL Server").length ? _c("span", { staticClass: "float-right mb-2" }, [_c("b-button", { directives: [{ name: "b-modal", rawName: "v-b-modal", value: "recurring-rebuild-modal", expression: "'recurring-rebuild-modal'" }], attrs: { size: "sm", variant: "primary" }, on: { click: _vm.showScheduleModal } }, [_c("font-awesome-icon", { attrs: { icon: "clock" } }), _vm._v(" Configure reorganisation schedule")], 1)], 1) : _vm._e(), _vm._v(" "), _vm.databaseInfo && (_vm.databaseInfo.databaseSettings.reorganiseToday || _vm.databaseInfo.databaseSettings.reorganiseSchedule || _vm.databaseInfo.databaseSettings.lastReorganised) ? _c("b-alert", { staticClass: "w-50", attrs: { show: "" } }, [_vm.databaseInfo.databaseSettings.reorganiseToday ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" The database indexes are currently scheduled to be reorganised "), _c("b", [_c("date-display", { attrs: { value: _vm.databaseInfo.databaseSettings.midnightDateTimeOffset } })], 1)], 1) : _vm._e(), _vm._v(" "), _vm.databaseInfo.databaseSettings.reorganiseToday && _vm.databaseInfo.databaseSettings.reorganiseSchedule ? _c("br") : _vm._e(), _vm._v(" "), _vm.databaseInfo.databaseSettings.reorganiseSchedule ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` The database indexes will reorganise at midnight server time on:
                `), _vm._l(_vm.databaseInfo.databaseSettings.reorganiseSchedule.split(";"), function(scheduleDayNumber, index2) {
    return _c("span", { key: index2, staticClass: "font-weight-bold" }, [_vm._v(`
                  ` + _vm._s(_vm.daysOfTheWeek.find((d) => d.number.toString() === scheduleDayNumber).name) + `
                  `), index2 + 1 != _vm.databaseInfo.databaseSettings.reorganiseSchedule.split(";").length ? _c("span", [_vm._v(",")]) : _vm._e()]);
  })], 2) : _vm._e()]) : _vm._e()], 1) : _vm._e()]), _vm._v(" "), _vm.databaseInfo && _vm.databaseInfo.databases ? _c("div", { staticClass: "row" }, _vm._l(_vm.databaseInfo.databases, function(database, index2) {
    return _c("div", { key: index2, staticClass: "col-lg-4 col-md-6 col-sm-12 mb-3" }, [_c("div", { staticClass: "card" }, [_c("div", { staticClass: "card-header" }, [_c("font-awesome-icon", { attrs: { icon: "database" } }), _vm._v(" "), _c("b", [_vm._v(_vm._s(database.databaseName))]), _vm._v(" "), !database.isRebuilding && database.databaseType == "SQL Server" ? _c("div", { staticClass: "float-right mt-n2" }, [_c("b-dropdown", { staticClass: "mt-1", attrs: { "no-flip": "", "no-caret": "", right: "", variant: "link", size: "sm" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-v" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { directives: [{ name: "b-modal", rawName: "v-b-modal", value: "rebuild-modal", expression: "'rebuild-modal'" }], on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.databaseToRebuild = database;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(`
                                 Reorganise Indexes
                            `)], 1), _vm._v(" "), _c("b-dropdown-item", { directives: [{ name: "b-modal", rawName: "v-b-modal", value: "index-modal", expression: "'index-modal'" }], on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.databaseToView = database;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "info-circle" } }), _vm._v(`
                                 View Indexes
                            `)], 1), _vm._v(" "), database.module == "indexing" && database.internalDatabaseType == "read" ? _c("b-dropdown-item", { directives: [{ name: "b-modal", rawName: "v-b-modal", value: "metadataValues-modal", expression: "'metadataValues-modal'" }] }, [_c("font-awesome-icon", { attrs: { icon: "refresh" } }), _vm._v(`
                             Refresh Metadata Values
                          `)], 1) : _vm._e()], 1)], 1) : _vm._e(), _vm._v(" "), database.isRebuilding && database.databaseType == "SQL Server" ? _c("div", { staticClass: "text-center text-primary float-right" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Reorganising...")])], 1) : _vm._e()], 1), _vm._v(" "), _c("div", { staticClass: "p-0 card-body" }, [_c("ul", { staticClass: "list-group list-group-flush" }, [_c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_c("b", [_vm._v("Database Type")]), _c("i", [_vm._v(_vm._s(database.databaseType))])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_c("b", [_vm._v("Location")]), _c("i", [_vm._v(_vm._s(database.databaseLocation))])]), _vm._v(" "), _vm.isAzureMode ? _vm._e() : _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_c("b", [_vm._v("Database Size")]), _c("i", [_vm._v(_vm._s(database.databaseSize) + `
                        `)])]), _vm._v(" "), database.databaseType == "SQL Server" && !_vm.isAzureMode ? _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_c("b", [_vm._v("Number of Indexes")]), _c("i", [_vm._v(_vm._s(database.indexCount))])]) : _vm._e(), _vm._v(" "), database.databaseType == "SQL Server" && !_vm.isAzureMode ? _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_c("b", [_vm._v("Average Index Fragmentation")]), _vm._v(" "), _c("span", [_c("div", { staticClass: "badge badge-pill", class: _vm.getFragmentationLevelClass(database.indexFragmentationLevel) }, [_vm._v(`
                                ` + _vm._s(database.indexFragmentationLevel) + `
                              `)]), _vm._v(`
                              (` + _vm._s(database.averageIndexFragmentation) + `%)
                           `)])]) : _vm._e()])])]), _vm._v(" "), database && database.rebuildError ? _c("div", { staticClass: "alert alert-danger alert-dismissible mt-2" }, [_c("strong", [_vm._v("An Error occurred")]), _vm._v(" "), _c("br"), _vm._v(" " + _vm._s(database.rebuildError) + `
              `), _c("button", { staticClass: "close", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      database.rebuildError = null;
    }, "click") } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]) : _vm._e(), _vm._v(" "), database && database.rebuildSuccess ? _c("div", { staticClass: "alert alert-success alert-dismissible mt-2" }, [_c("strong", [_vm._v("Database Indexes Reorganised")]), _vm._v(" "), _c("br"), _vm._v(" The indexes on " + _vm._s(database.databaseName) + ` have been reorganised.
                `), _c("button", { staticClass: "close", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
      database.rebuildSuccess = !1;
    }, "click") } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]) : _vm._e()]);
  }), 0) : _vm._e(), _vm._v(" "), _vm.isLoading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _vm._e(), _vm._v(" "), _c("refresh-metadata-values-modal", { on: { confirm: _vm.refreshMetadataValues } }), _vm._v(" "), _c("rebuild-modal", { attrs: { "database-to-rebuild": _vm.databaseToRebuild }, on: { confirm: _vm.rebuildIndexes } }), _vm._v(" "), _c("indexes-modal", { attrs: { database: _vm.databaseToView } }), _vm._v(" "), _vm.scheduleDatabaseSettings ? _c("settings-modal", { attrs: { "database-settings": _vm.scheduleDatabaseSettings, "days-of-the-week": _vm.daysOfTheWeek }, on: { confirm: _vm.saveDatabaseSettings } }) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationDatabaseComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  null
);
const index = __component__.exports;
export {
  index as default
};
