var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, u as AdministrationNotificationsClient, T as Transformer, b as baseUrl, t as toastr$1, P as Prop, C as Component, n as normalizeComponent, N as CheckIcon, a0 as userHasPermission, L as LoadingBarComponent } from "./main-DAVWuHbi.js";
import { D as DefaultableTextbox } from "./defaultableTextbox-DRxGWG_3.js";
import { H as HourPicker } from "./hourPicker-B5b_o7dz.js";
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$2"), _a;
let SMTPSettingsComponent$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "testEmailSuccess", !1);
    __publicField(this, "saving", !1);
  }
  sendTestEmail() {
    this.saving = !0, new AdministrationNotificationsClient(new Transformer(), baseUrl()).testNotifications(this.model).then((data) => {
      data ? data.success ? toastr$1.success("Email has been successfully sent.") : toastr$1.error("Error sending email: " + data.message) : toastr$1.error("Unknown error occured.");
    }).catch((e) => {
      toastr$1.error(e);
    }).finally(() => {
      this.saving = !1;
    });
  }
  saveSettings() {
    this.$validator.validateAll().then((valid) => {
      valid ? (this.saving = !0, this.testEmailSuccess = !1, new AdministrationNotificationsClient(new Transformer(), baseUrl()).setSmtpSettings(this.model).then((model) => {
        this.model = model, toastr$1.success("Smtp Configuration saved");
      }).catch((e) => {
        toastr$1.error(e);
      }).finally(() => {
        this.saving = !1;
      })) : toastr$1.error("You have not filled out the SMTP settings correctly");
    });
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get hostName() {
    return this.model.smtpHostName;
  }
  set hostName(value) {
    this.model.smtpHostName = value;
  }
  get port() {
    return this.model.smtpPort;
  }
  set port(value) {
    this.model.smtpPort = value;
  }
  get security() {
    return this.model.smtpSecurity;
  }
  set security(value) {
    this.model.smtpSecurity = value;
  }
  get username() {
    return this.model.smtpUsername;
  }
  set username(value) {
    this.model.smtpUsername = value;
  }
  get password() {
    return this.model.smtpPassword;
  }
  set password(value) {
    this.model.smtpPassword = value;
  }
  get ignoreSslErrors() {
    return this.model.ignoreSslErrors;
  }
  set ignoreSslErrors(value) {
    this.model.ignoreSslErrors = value;
  }
  get fromAddress() {
    return this.model.smtpFromAdddress;
  }
  set fromAddress(value) {
    this.model.smtpFromAdddress = value;
  }
  get fromName() {
    return this.model.smtpFromName;
  }
  set fromName(value) {
    this.model.smtpFromName = value;
  }
  get emailUrl() {
    return this.model.emailUrl;
  }
  set emailUrl(value) {
    this.model.emailUrl = value;
  }
  get testEmailAddress() {
    return this.model.testEmailAddress;
  }
  set testEmailAddress(value) {
    this.model.testEmailAddress = value;
  }
  get defaultEmailUrl() {
    return baseUrl();
  }
}, __name(_a, "SMTPSettingsComponent"), _a);
__decorateClass$2([
  Prop({
    required: !0
  })
], SMTPSettingsComponent$1.prototype, "value", 2);
SMTPSettingsComponent$1 = __decorateClass$2([
  Component({
    components: { DefaultableTextbox }
  })
], SMTPSettingsComponent$1);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-6 col-sm-12" }, [_c("h4", [_vm._v("SMTP Configuration")]), _vm._v(" "), _c("h5", [_vm._v("Server")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "hostNameInput" } }, [_vm._v("Host Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.hostName, expression: "hostName" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("hostName"), disabled: _vm.saving }, attrs: { type: "text", disabled: _vm.saving, id: "hostNameInput", "aria-describedby": "hostNameHelp", name: "hostName" }, domProps: { value: _vm.hostName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.hostName = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "hostNameHelp" } }, [_vm._v("Hostname or IP address of the SMTP server.")]), _vm._v(" "), _vm.errors.first("hostName") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a valid host name")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "portInput" } }, [_vm._v("Port")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.port, expression: "port" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("port"), disabled: _vm.saving }, attrs: { type: "number", disabled: _vm.saving, id: "portInput", "aria-describedby": "portHelp", name: "port" }, domProps: { value: _vm.port }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.port = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "portHelp" } }, [_vm._v("The port to use for SMTP. The default port for SMTP is 25.")]), _vm._v(" "), _vm.errors.first("port") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a valid port to use")]) : _vm._e()]), _vm._v(" "), _c("hr"), _vm._v(" "), _c("h5", [_vm._v("Security")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "securityTypeDropdown" } }, [_vm._v("Security Type")]), _vm._v(" "), _c("select", { directives: [{ name: "model", rawName: "v-model", value: _vm.security, expression: "security" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "custom-select", class: { "is-invalid": _vm.errors.first("security"), disabled: _vm.saving }, attrs: { id: "securityTypeDropdown", disabled: _vm.saving, name: "security" }, on: { change: /* @__PURE__ */ __name(function($event) {
    var $$selectedVal = Array.prototype.filter.call($event.target.options, function(o) {
      return o.selected;
    }).map(function(o) {
      var val = "_value" in o ? o._value : o.value;
      return val;
    });
    _vm.security = $event.target.multiple ? $$selectedVal : $$selectedVal[0];
  }, "change") } }, [_c("option", { attrs: { value: "none" } }, [_vm._v("None")]), _vm._v(" "), _c("option", { attrs: { value: "explicit" } }, [_vm._v("Explicit SSL/TLS")]), _vm._v(" "), _c("option", { attrs: { value: "implicit" } }, [_vm._v("Implicit SSL/TLS")])])]), _vm._v(" "), _vm.security != "none" ? _c("div", { staticClass: "form-group" }, [_c("b-form-checkbox", { attrs: { id: "ignoreSSLInput", name: "ignoreSSLInputSwitch", switch: "" }, model: { value: _vm.ignoreSslErrors, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.ignoreSslErrors = $$v;
  }, "callback"), expression: "ignoreSslErrors" } }, [_c("b", [_vm._v("Ignore SSL Issues")])]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Ignores any issues with the SSL certificate. Enabling this option potentially makes communication less secure.")])], 1) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "usernameInput" } }, [_vm._v("Username")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.username, expression: "username" }], staticClass: "form-control", class: { disabled: _vm.saving }, attrs: { type: "text", id: "usernameInput", "aria-describedby": "usernameHelp", name: "username", disabled: _vm.saving }, domProps: { value: _vm.username }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.username = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "usernameHelp" } }, [_vm._v("Username for SMTP authentication. Leave blank if authentication isn't required.")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "passwordInput" } }, [_vm._v("Password")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.password, expression: "password" }], staticClass: "form-control", class: { disabled: _vm.saving }, attrs: { type: "password", id: "passwordInput", "aria-describedby": "passwordHelp", name: "password", disabled: _vm.saving }, domProps: { value: _vm.password }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.password = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "passwordHelp" } }, [_vm._v("Password for SMTP authentication. Leave blank to keep current password.")])]), _vm._v(" "), _c("hr"), _vm._v(" "), _c("h5", [_vm._v("Email")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "fromAddressInput" } }, [_vm._v("From Address")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.fromAddress, expression: "fromAddress" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("fromAddress"), disabled: _vm.saving }, attrs: { type: "text", disabled: _vm.saving, id: "fromAddressInput", "aria-describedby": "fromAddressHelp", name: "fromAddress" }, domProps: { value: _vm.fromAddress }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.fromAddress = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "fromAddressHelp" } }, [_vm._v("The email address to send the emails from.")]), _vm._v(" "), _vm.errors.first("fromAddress") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a from address")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "fromNameInput" } }, [_vm._v("From Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.fromName, expression: "fromName" }], staticClass: "form-control", class: { disabled: _vm.saving }, attrs: { type: "text", disabled: _vm.saving, id: "fromNameInput", "aria-describedby": "fromNameHelp", name: "fromName" }, domProps: { value: _vm.fromName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.fromName = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "fromNameHelp" } }, [_vm._v("The email name to send the emails from.")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "emailUrlInput" } }, [_vm._v("Email Url")]), _vm._v(" "), _c("defaultable-textbox", { attrs: { placeholder: "Enter a path...", defaultValue: _vm.defaultEmailUrl }, model: { value: _vm.emailUrl, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.emailUrl = $$v;
  }, "callback"), expression: "emailUrl" } }), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.emailUrl, expression: "emailUrl" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("emailUrl"), disabled: _vm.saving }, attrs: { type: "hidden", disabled: _vm.saving, id: "emailUrlInput", "aria-describedby": "emailUrlHelp", name: "emailUrl" }, domProps: { value: _vm.emailUrl }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.emailUrl = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.first("emailUrl") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter an email url")]) : _c("span", { staticClass: "form-text text-muted", attrs: { id: "emailUrlHelp" } }, [_vm._v("Url to use in notification emails. Example: http://ewaserver.domain.com/ewa")])], 1), _vm._v(" "), _c("hr"), _vm._v(" "), _c("div", { staticClass: "input-group" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.testEmailAddress, expression: "testEmailAddress" }], staticClass: "form-control", class: { disabled: _vm.saving }, attrs: { type: "text", id: "sendTestEmailInput", placeholder: "username@email.com", "aria-describedby": "sendTestEmailHelp", disabled: _vm.saving }, domProps: { value: _vm.testEmailAddress }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.testEmailAddress = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("div", { staticClass: "input-group-append" }, [_c("button", { staticClass: "btn btn-info", class: { disabled: _vm.saving }, attrs: { type: "button", disabled: _vm.saving }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.sendTestEmail();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "envelope" } }), _vm._v(` Send test email
        `)], 1)])]), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "sendTestEmailHelp" } }, [_vm._v("Enter an email address and send a test email to ensure that the SMTP is configured correctly")]), _vm._v(" "), _vm.testEmailSuccess ? _c("div", { staticClass: "alert alert-success", attrs: { role: "alert" } }, [_vm._v(`
      A test email has been successfully sent. Make sure you check the address it has been sent to and then save your
      settings.
    `)]) : _vm._e(), _vm._v(" "), _c("hr"), _vm._v(" "), _c("button", { staticClass: "btn btn-success", class: { disabled: _vm.saving }, attrs: { disabled: _vm.saving }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.saveSettings();
  }, "click") } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.saving, expression: "!saving" }] }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.saving, expression: "saving" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Saving")], 1)])])]);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  SMTPSettingsComponent$1,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "234f43c2"
);
const SmtpSettingsComponent = __component__$2.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$1"), _a2;
let SMTPSettingsComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "saving", !1);
    __publicField(this, "loading", !1);
  }
  get daysOfTheWeek() {
    return [{ number: 1, name: "Monday" }, { number: 2, name: "Tuesday" }, { number: 3, name: "Wednesday" }, { number: 4, name: "Thursday" }, { number: 5, name: "Friday" }, { number: 6, name: "Saturday" }, { number: 7, name: "Sunday" }];
  }
  saveSettings() {
    this.$validator.validateAll().then((valid) => {
      valid ? (this.saving = !0, new AdministrationNotificationsClient(new Transformer(), baseUrl()).setReminderSettings(this.model).then((model) => {
        this.model = model, toastr$1.success("Notification Configuration saved");
      }).catch((e) => {
        toastr$1.success("notification Configuration could not save"), toastr$1.error(e);
      }).finally(() => {
        this.saving = !1;
      })) : toastr$1.error("You have not filled out the settings correctly");
    });
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get checkPendingInterval() {
    return this.model.checkPendingInterval;
  }
  set checkPendingInterval(value) {
    this.model.checkPendingInterval = value;
  }
  get checkRejectedInterval() {
    return this.model.checkRejectedInterval;
  }
  set checkRejectedInterval(value) {
    this.model.checkRejectedInterval = value;
  }
  get reminderDays() {
    return this.model.reminderDays;
  }
  set reminderDays(value) {
    this.model.reminderDays = value;
  }
  get reminderTime() {
    return this.model.reminderTime;
  }
  set reminderTime(value) {
    this.model.reminderTime = value;
  }
  get digestDays() {
    return this.model.digestDays;
  }
  set digestDays(value) {
    this.model.digestDays = value;
  }
  get digestTime() {
    return this.model.digestTime;
  }
  set digestTime(value) {
    this.model.digestTime = value;
  }
  get notificationsEnabled() {
    return this.model.notificationsEnabled;
  }
  set notificationsEnabled(notificationsEnabled) {
    this.model.notificationsEnabled = notificationsEnabled;
  }
  get riaNotificationsEnabled() {
    return this.model.riaNotificationsEnabled;
  }
  set riaNotificationsEnabled(riaNotificationsEnabled) {
    this.model.riaNotificationsEnabled = riaNotificationsEnabled;
  }
  get dfaNotificationsEnabled() {
    return this.model.dfaNotificationsEnabled;
  }
  set dfaNotificationsEnabled(dfaNotificationsEnabled) {
    this.model.dfaNotificationsEnabled = dfaNotificationsEnabled;
  }
  get remindersEnabled() {
    return this.model.remindersEnabled;
  }
  set remindersEnabled(remindersEnabled) {
    this.model.remindersEnabled = remindersEnabled;
  }
  get digestEnabled() {
    return this.model.digestEnabled;
  }
  set digestEnabled(digestEnabled) {
    this.model.digestEnabled = digestEnabled;
  }
  get intraySummaryEnabled() {
    return this.model.intraySummaryEnabled;
  }
  set intraySummaryEnabled(intraySummaryEnabled) {
    this.model.intraySummaryEnabled = intraySummaryEnabled;
  }
  get intraySummaryDays() {
    return this.model.intraySummaryDays;
  }
  set intraySummaryDays(value) {
    this.model.intraySummaryDays = value;
  }
  get intraySummaryTime() {
    return this.model.intraySummaryTime;
  }
  set intraySummaryTime(value) {
    this.model.intraySummaryTime = value;
  }
  mounted() {
  }
}, __name(_a2, "SMTPSettingsComponent"), _a2);
__decorateClass$1([
  Prop({
    required: !0
  })
], SMTPSettingsComponent.prototype, "value", 2);
SMTPSettingsComponent = __decorateClass$1([
  Component({
    components: {
      HourPicker,
      CheckIcon
    }
  })
], SMTPSettingsComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", { attrs: { md: "6", sm: "12" } }, [_c("b-card", { staticClass: "noBottomRoundedCorner", attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-form-checkbox", { staticClass: "mt-2 float-right", attrs: { switch: "" }, model: { value: _vm.notificationsEnabled, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.notificationsEnabled = $$v;
    }, "callback"), expression: "notificationsEnabled" } }), _vm._v(" "), _c("h4", { staticClass: "mb-0" }, [_vm._v("Notifications")])];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _vm.notificationsEnabled ? _c("b-card-body", [_c("b-alert", { attrs: { show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` When you have notifications enabled on RIA pages these settings will be used to determine the intervals to send notifications.
        `)], 1), _vm._v(" "), _c("b-form-group", [_c("label", { attrs: { for: "pendingIntervalInput" } }, [_vm._v("Pending Interval (in seconds)")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.checkPendingInterval, expression: "checkPendingInterval" }, { name: "validate", rawName: "v-validate", value: "required|numeric|min_value:1", expression: "'required|numeric|min_value:1'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("pendingInterval"), disabled: _vm.saving }, attrs: { type: "number", disabled: _vm.saving, id: "pendingIntervalInput", "aria-describedby": "pendingIntervalHelp", name: "pendingInterval" }, domProps: { value: _vm.checkPendingInterval }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.checkPendingInterval = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "pendingIntervalHelp" } }, [_vm._v("Interval in seconds to check for new files and send pending file notifications.")]), _vm._v(" "), _vm.errors.first("pendingInterval") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a valid number of seconds")]) : _vm._e()]), _vm._v(" "), _c("b-form-group", [_c("b-form-checkbox", { staticClass: "mt-2", attrs: { switch: "" }, model: { value: _vm.riaNotificationsEnabled, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.riaNotificationsEnabled = $$v;
  }, "callback"), expression: "riaNotificationsEnabled" } }, [_c("b", [_vm._v("Enable RIA Notifications")])]), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "riaNotificationHelps" } }, [_vm._v("Enable the email notifications for RIA pages")])], 1), _vm._v(" "), _c("b-alert", { attrs: { show: !_vm.riaNotificationsEnabled, variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
          This will prevent all notifications being sent from Remote Indexing app pages.
        `)], 1), _vm._v(" "), _c("b-form-group", [_c("b-form-checkbox", { staticClass: "mt-2", attrs: { switch: "" }, model: { value: _vm.dfaNotificationsEnabled, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.dfaNotificationsEnabled = $$v;
  }, "callback"), expression: "dfaNotificationsEnabled" } }, [_c("b", [_vm._v("Enable DFA Notifications")])]), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "dfaNotificationHelps" } }, [_vm._v("Enable the email notifications for DFA pages")])], 1), _vm._v(" "), _c("b-alert", { attrs: { show: !_vm.dfaNotificationsEnabled, variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
          This will prevent all notifications being sent from Digital Forms app pages.
        `)], 1)], 1) : _vm._e()], 1), _vm._v(" "), _c("b-card", { staticClass: "noRoundedCorner", attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-form-checkbox", { staticClass: "mt-2 float-right", attrs: { switch: "" }, model: { value: _vm.remindersEnabled, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.remindersEnabled = $$v;
    }, "callback"), expression: "remindersEnabled" } }), _vm._v(" "), _c("h4", { staticClass: "mb-0" }, [_vm._v("Reminders")])];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _vm.remindersEnabled ? _c("b-card-body", [_c("b-alert", { attrs: { show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` When you have reminders enabled on RIA pages these settings will be used to determine the intervals to send out the reminders.
        `)], 1), _vm._v(" "), _c("b-form-group", [_c("label", { attrs: { for: "rejectedIntervalInput" } }, [_vm._v("Reminder Days")]), _vm._v(" "), _c("br"), _vm._v(" "), _vm._l(_vm.daysOfTheWeek, function(day) {
    return _c("div", { key: day.name, staticClass: "pretty p-svg p-curve p-smooth" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.reminderDays, expression: "reminderDays" }], staticClass: "form-check-input", class: { disabled: _vm.saving }, attrs: { type: "checkbox", id: "showRiaSearchChecbox", disabled: _vm.saving }, domProps: { value: day.number, checked: Array.isArray(_vm.reminderDays) ? _vm._i(_vm.reminderDays, day.number) > -1 : _vm.reminderDays }, on: { change: /* @__PURE__ */ __name(function($event) {
      var $$a = _vm.reminderDays, $$el = $event.target, $$c = !!$$el.checked;
      if (Array.isArray($$a)) {
        var $$v = day.number, $$i = _vm._i($$a, $$v);
        $$el.checked ? $$i < 0 && (_vm.reminderDays = $$a.concat([$$v])) : $$i > -1 && (_vm.reminderDays = $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
      } else
        _vm.reminderDays = $$c;
    }, "change") } }), _vm._v(" "), _c("div", { staticClass: "state p-primary" }, [_c("span", { staticClass: "svg svg-icon" }, [_c("CheckIcon")], 1), _vm._v(" "), _c("label", [_vm._v(_vm._s(day.name))])])]);
  }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "reminderDaysHelp" } }, [_vm._v("The days of the week that notifications will be sent.")])], 2), _vm._v(" "), _c("b-form-group", [_c("label", { attrs: { for: "reminderTimeInput" } }, [_vm._v("Reminder time")]), _vm._v(" "), _c("hour-picker", { class: { disabled: _vm.reminderDays.length === 0, disabled: _vm.saving }, attrs: { disabled: _vm.reminderDays.length === 0 || _vm.saving, id: "reminderTimeInput", "aria-describedby": "reminderTimeHelp", name: "reminderTime" }, model: { value: _vm.reminderTime, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.reminderTime = $$v;
  }, "callback"), expression: "reminderTime" } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "reminderTimeHelp" } }, [_vm._v("Time of the day to send out the notifications.")])], 1)], 1) : _vm._e()], 1), _vm._v(" "), _c("b-card", { staticClass: "noTopRoundedCorner", attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-form-checkbox", { staticClass: "mt-2 float-right", attrs: { switch: "" }, model: { value: _vm.digestEnabled, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.digestEnabled = $$v;
    }, "callback"), expression: "digestEnabled" } }), _vm._v(" "), _c("h4", { staticClass: "mb-0" }, [_vm._v("Digest Emails")])];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _vm.digestEnabled ? _c("b-card-body", [_c("b-alert", { attrs: { show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Digest emails are daily recaps of items added to, or indexed from Remote Indexing Pages. Users are able to personalise their own digest email settings.
        `)], 1), _vm._v(" "), _c("b-form-group", [_c("label", { attrs: { for: "digestIntervalInput" } }, [_vm._v("Digest Days")]), _vm._v(" "), _c("br"), _vm._v(" "), _vm._l(_vm.daysOfTheWeek, function(day) {
    return _c("div", { key: day.name, staticClass: "pretty p-svg p-curve p-smooth" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.digestDays, expression: "digestDays" }], staticClass: "form-check-input", class: { disabled: _vm.saving }, attrs: { type: "checkbox", id: "showRiaSearchChecbox", disabled: _vm.saving }, domProps: { value: day.number, checked: Array.isArray(_vm.digestDays) ? _vm._i(_vm.digestDays, day.number) > -1 : _vm.digestDays }, on: { change: /* @__PURE__ */ __name(function($event) {
      var $$a = _vm.digestDays, $$el = $event.target, $$c = !!$$el.checked;
      if (Array.isArray($$a)) {
        var $$v = day.number, $$i = _vm._i($$a, $$v);
        $$el.checked ? $$i < 0 && (_vm.digestDays = $$a.concat([$$v])) : $$i > -1 && (_vm.digestDays = $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
      } else
        _vm.digestDays = $$c;
    }, "change") } }), _vm._v(" "), _c("div", { staticClass: "state p-primary" }, [_c("span", { staticClass: "svg svg-icon" }, [_c("CheckIcon")], 1), _vm._v(" "), _c("label", [_vm._v(_vm._s(day.name))])])]);
  }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "digestDaysHelp" } }, [_vm._v("The days of the week that digest emails will be sent.")])], 2), _vm._v(" "), _c("b-form-group", [_c("label", { attrs: { for: "digestTimeInput" } }, [_vm._v("Digest time")]), _vm._v(" "), _c("hour-picker", { class: { disabled: _vm.digestDays.length === 0, disabled: _vm.saving }, attrs: { disabled: _vm.digestDays.length === 0 || _vm.saving, id: "digestTimeInput", "aria-describedby": "digestTimeHelp", name: "digestTime" }, model: { value: _vm.digestTime, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.digestTime = $$v;
  }, "callback"), expression: "digestTime" } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "digestTimeHelp" } }, [_vm._v("Time of the day to send out the digest emails. Users are able to configure their own personal time.")])], 1)], 1) : _vm._e()], 1), _vm._v(" "), _c("b-card", { staticClass: "noTopRoundedCorner", attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-form-checkbox", { staticClass: "mt-2 float-right", attrs: { switch: "" }, model: { value: _vm.intraySummaryEnabled, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.intraySummaryEnabled = $$v;
    }, "callback"), expression: "intraySummaryEnabled" } }), _vm._v(" "), _c("h4", { staticClass: "mb-0" }, [_vm._v("Intray Summary Emails")])];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _vm.intraySummaryEnabled ? _c("b-card-body", [_c("b-alert", { attrs: { show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Intray Summary emails are daily summaries of a user's intray. Users are able to personalise their own Intray Summary email settings.
        `)], 1), _vm._v(" "), _c("b-form-group", [_c("label", { attrs: { for: "intraySummaryIntervalInput" } }, [_vm._v("Intray Summary Days")]), _vm._v(" "), _c("br"), _vm._v(" "), _vm._l(_vm.daysOfTheWeek, function(day) {
    return _c("div", { key: day.name, staticClass: "pretty p-svg p-curve p-smooth" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.intraySummaryDays, expression: "intraySummaryDays" }], staticClass: "form-check-input", class: { disabled: _vm.saving }, attrs: { type: "checkbox", id: "showRiaSearchChecbox", disabled: _vm.saving }, domProps: { value: day.number, checked: Array.isArray(_vm.intraySummaryDays) ? _vm._i(_vm.intraySummaryDays, day.number) > -1 : _vm.intraySummaryDays }, on: { change: /* @__PURE__ */ __name(function($event) {
      var $$a = _vm.intraySummaryDays, $$el = $event.target, $$c = !!$$el.checked;
      if (Array.isArray($$a)) {
        var $$v = day.number, $$i = _vm._i($$a, $$v);
        $$el.checked ? $$i < 0 && (_vm.intraySummaryDays = $$a.concat([$$v])) : $$i > -1 && (_vm.intraySummaryDays = $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
      } else
        _vm.intraySummaryDays = $$c;
    }, "change") } }), _vm._v(" "), _c("div", { staticClass: "state p-primary" }, [_c("span", { staticClass: "svg svg-icon" }, [_c("CheckIcon")], 1), _vm._v(" "), _c("label", [_vm._v(_vm._s(day.name))])])]);
  }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "intraySummaryDaysHelp" } }, [_vm._v("The days of the week that Intray Summary emails will be sent. Users are able to configure their own personal days.")])], 2), _vm._v(" "), _c("b-form-group", [_c("label", { attrs: { for: "intraySummaryTimeInput" } }, [_vm._v("Intray Summary time")]), _vm._v(" "), _c("hour-picker", { class: { disabled: _vm.saving }, attrs: { disabled: _vm.saving, id: "intraySummaryTimeInput", "aria-describedby": "intraySummaryTimeHelp", name: "intraySummaryTime" }, model: { value: _vm.intraySummaryTime, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.intraySummaryTime = $$v;
  }, "callback"), expression: "intraySummaryTime" } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "intraySummaryTimeHelp" } }, [_vm._v("Time of the day to send out the Intray Summary emails. Users are able to configure their own personal time.")])], 1)], 1) : _vm._e()], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-success mt-1", class: { disabled: _vm.saving }, attrs: { disabled: _vm.saving }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.saveSettings();
  }, "click") } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.saving, expression: "!saving" }] }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.saving, expression: "saving" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Saving")], 1)])], 1)], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  SMTPSettingsComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "376b4ad4"
);
const NotificationsSettingsComponent = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a3;
let AdministrationNotificationsComponent = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "notificationsSettings", null);
    __publicField(this, "tab", null);
    __publicField(this, "loading", !1);
    __publicField(this, "hasConfigPermissions", !1);
    __publicField(this, "hasSchedulePermissions", !1);
    __publicField(this, "tabs", [
      {
        id: "smtpConfig",
        name: "SMTP config",
        icon: "mail-bulk",
        description: "Manage the configuration of the notifications SMTP server",
        show: !0,
        component: SmtpSettingsComponent
      },
      {
        id: "notificationConfig",
        name: "Notifications & Reminders",
        icon: "bell",
        description: "Configure when to send notifications",
        show: !0,
        component: NotificationsSettingsComponent
      }
    ]);
  }
  async mounted() {
    this.hasConfigPermissions = await userHasPermission("notifications.config"), this.hasConfigPermissions || (this.tabs = this.tabs.filter((y) => y.id != "smtpConfig")), this.hasSchedulePermissions = await userHasPermission("notifications.schedule"), this.hasSchedulePermissions || (this.tabs = this.tabs.filter((y) => y.id != "notificationConfig")), this.$route.path === "/notificationConfig" && this.hasSchedulePermissions && this.selectTab("notificationConfig"), this.loading = !0, new AdministrationNotificationsClient(new Transformer(), baseUrl()).getNotificationsSettings().then((model) => {
      this.notificationsSettings = model;
    }).catch((e) => {
      toastr.error("Something has gone wrong while loading the notifications settings: " + e);
    }).finally(() => {
      this.loading = !1;
    });
  }
  get settings() {
    return this.notificationsSettings;
  }
  set settings(value) {
    this.notificationsSettings = value;
  }
  get activeTab() {
    return this.tab ? this.tab : (this.tabs.find((t) => t.show) || { id: null }).id;
  }
  selectTab(tabId) {
    this.tabs.find((t) => t.id === tabId && t.show) && (this.tab = tabId);
  }
}, __name(_a3, "AdministrationNotificationsComponent"), _a3);
AdministrationNotificationsComponent = __decorateClass([
  Component({
    components: { SmtpSettingsComponent, NotificationsSettingsComponent, LoadingBar: LoadingBarComponent }
  })
], AdministrationNotificationsComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "bell" } }), _vm._v(" Notifications")], 1)]), _vm._v(" "), _c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs", attrs: { id: "myTab", role: "tablist" } }, _vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item" }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab === tab.id }, attrs: { id: tab.id + "tab", "data-toggle": "tab", role: "tab", "aria-selected": "true" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(" " + _vm._s(tab.name) + `
                `)], 1)]);
  }), 0)]), _vm._v(" "), _vm.loading ? _c("div", { staticClass: "col-sm-12" }, [_c("loading-bar")], 1) : _c("div", { staticClass: "tab-content" }, [_vm.notificationsSettings ? _c("div", { staticClass: "container-fluid" }, [_vm.activeTab === "smtpConfig" ? _c("smtp-settings-component", { on: { loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading") }, model: { value: _vm.notificationsSettings, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.notificationsSettings = $$v;
  }, "callback"), expression: "notificationsSettings" } }) : _vm._e(), _vm._v(" "), _vm.activeTab === "notificationConfig" ? _c("notifications-settings-component", { attrs: { value: _vm.notificationsSettings }, on: { loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading") } }) : _vm._e()], 1) : _vm._e()])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationNotificationsComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "75a94ccc"
);
const index = __component__.exports;
export {
  index as default
};
