var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, W as Watch, C as Component, V as Vue, bN as AdministrationQuotaClient, T as Transformer, b as baseUrl, t as toastr, g as v4, n as normalizeComponent, M as Moment, _, G as Getter, S as State } from "./main-DAVWuHbi.js";
import { Q as QuotaBar } from "./quotaBar-YBpud5Td.js";
import TemplateSummary from "./templateSummary-BsyF-Lep.js";
import { P as Pie, C as Chart, p as plugin_title, a as plugin_tooltip, b as plugin_legend, L as LineElement, c as LinearScale, d as CategoryScale, e as PointElement, A as ArcElement, B as BarElement } from "./index-CL7C-Mhu.js";
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$6"), _a;
let IndexingBreakdownComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "quotaPeriod");
    __publicField(this, "reloadTimer");
    __publicField(this, "loading", !1);
    __publicField(this, "quotaSummary", []);
    __publicField(this, "mode", "table");
    __publicField(this, "pieComponent", Pie);
    __publicField(this, "pallet", ["#0074D9", "#FF4136", "#2ECC40", "#FF851B", "#7FDBFF", "#B10DC9", "#FFDC00", "#001f3f", "#39CCCC", "#01FF70", "#85144b", "#F012BE", "#3D9970", "#111111", "#AAAAAA"]);
  }
  mounted() {
    Chart.register(plugin_title, plugin_tooltip, plugin_legend, LineElement, LinearScale, CategoryScale, PointElement, ArcElement, BarElement, CategoryScale, LinearScale), this.load(), this.reloadTimer = setInterval(() => this.load(), 6e4);
  }
  beforeDestroy() {
    clearInterval(this.reloadTimer);
  }
  async watchAndReload() {
    await this.load();
  }
  async load() {
    try {
      this.loading = !0;
      let results = await new AdministrationQuotaClient(new Transformer(), baseUrl()).getIndexingQuotaBreakdown(this.quotaPeriod);
      results ? this.quotaSummary = results.results : this.quotaSummary = [];
    } catch (e) {
      throw toastr.error(e, "Failed to load quotas"), e;
    } finally {
      this.loading = !1;
    }
  }
  get model() {
    return this.quotaPeriod;
  }
  set model(value) {
    this.load();
  }
  get tableFields() {
    return [
      { key: "pageName", sortable: !0, thClass: "align-middle py-1" },
      { key: "pageId", sortable: !0, thClass: "align-middle py-1" },
      { key: "quotaConsumed", sortable: !0, thClass: "align-middle py-1" },
      { key: "actions", label: "", sortable: !1, thClass: "align-middle py-1" }
    ];
  }
  getPalletColours(length) {
    let colors = [];
    for (let i = 0; i < length; i++)
      colors.push(this.pallet[i % (this.pallet.length - 1)]);
    return colors;
  }
  get chartData() {
    let colours = this.getPalletColours(this.quotaSummary.length);
    return {
      labels: this.quotaSummary.map((q) => q.pageName),
      datasets: [
        {
          backgroundColor: colours,
          data: this.quotaSummary.map((q) => q.quotaConsumed)
        }
      ]
    };
  }
  get chartOptions() {
    return {
      responsive: !0,
      maintainAspectRatio: !1
    };
  }
  get canvasId() {
    return v4();
  }
}, __name(_a, "IndexingBreakdownComponent"), _a);
__decorateClass$6([
  Prop({ required: !0 })
], IndexingBreakdownComponent.prototype, "quotaPeriod", 2);
__decorateClass$6([
  Watch("quotaPeriod")
], IndexingBreakdownComponent.prototype, "watchAndReload", 1);
IndexingBreakdownComponent = __decorateClass$6([
  Component({ components: {} })
], IndexingBreakdownComponent);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "", "header-class": "align-middle" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("span", { staticClass: "align-middle" }, [_vm._v(`
            Expiry: ` + _vm._s(_vm.quotaPeriod) + `
          `)]), _vm._v(" "), _c("b-button", { staticClass: "float-right", staticStyle: { "margin-top": "4px" }, attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: _vm.load } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)]), _vm._v(" "), _c("b-button-group", { staticClass: "float-right mr-2", staticStyle: { "margin-top": "4px" }, attrs: { size: "sm" } }, [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn-sm", attrs: { title: "Table View", variant: _vm.mode == "table" ? "primary" : "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.mode = "table";
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "table" } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn-sm", attrs: { title: "Chart View", variant: _vm.mode == "chart" ? "primary" : "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.mode = "chart";
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "chart-simple" } })], 1)], 1)], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _vm.mode == "table" ? _c("b-table", { staticClass: "mb-0", attrs: { "sort-icon-left": "", fields: _vm.tableFields, items: _vm.quotaSummary, striped: "", busy: _vm.loading, "show-empty": "" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }], null, !1, 632667596) }) : _c("div", [_vm.quotaSummary && _vm.quotaSummary.length ? _c(_vm.pieComponent, { tag: "component", attrs: { "chart-data": _vm.chartData, "chart-id": _vm.canvasId, "chart-options": _vm.chartOptions } }) : _c("b-alert", { staticClass: "mb-0", attrs: { show: !0, variant: "primary" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
                No Quota has been consumed for the selected period.
            `)], 1)], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  IndexingBreakdownComponent,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  null
);
const IndexingBreakdown = __component__$6.exports;
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$5"), _a2;
let IndexingQuotaManagementComponent$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer");
    __publicField(this, "selected", null);
    __publicField(this, "activeQuotas");
    __publicField(this, "expiredQuotas");
    __publicField(this, "loadingActive");
    __publicField(this, "loadingExpired");
    __publicField(this, "fields", [
      { key: "expiry", label: "Expiry", tdClass: "align-middle" },
      { key: "active", label: "Status", tdClass: "align-middle" },
      { key: "usage", label: "Usage", tdClass: "align-middle" }
    ]);
  }
  mounted() {
    this.loadQuotas(), this.reloadTimer = setInterval(() => this.loadQuotas(), 6e4);
  }
  beforeDestroy() {
    clearInterval(this.reloadTimer);
  }
  onRowSelected(items) {
    this.selected = items[0];
  }
  formatDate(date) {
    return Moment(date).format("yyyy-MM-DD");
  }
  get allQuotas() {
    if (this.activeQuotas && this.expiredQuotas) {
      let cloned = _.cloneDeep(this.activeQuotas), cloned2 = _.cloneDeep(this.expiredQuotas);
      return cloned = cloned.concat(cloned2), cloned;
    }
  }
  async loadQuotas() {
    try {
      await this.$store.dispatch("administration/quota/indexing/actions/loadActive");
    } catch (e) {
      throw toastr.error(e, "Failed to load quotas"), e;
    }
    try {
      await this.$store.dispatch("administration/quota/indexing/actions/loadExpired");
    } catch (e) {
      throw toastr.error(e, "Failed to load expired quotas"), e;
    }
  }
}, __name(_a2, "IndexingQuotaManagementComponent"), _a2);
__decorateClass$5([
  Getter("administration/quota/indexing/getters/active")
], IndexingQuotaManagementComponent$1.prototype, "activeQuotas", 2);
__decorateClass$5([
  Getter("administration/quota/indexing/getters/expired")
], IndexingQuotaManagementComponent$1.prototype, "expiredQuotas", 2);
__decorateClass$5([
  State((state) => state.administration.quota.indexing.quotas.active.loading)
], IndexingQuotaManagementComponent$1.prototype, "loadingActive", 2);
__decorateClass$5([
  State((state) => state.administration.quota.indexing.quotas.expired.loading)
], IndexingQuotaManagementComponent$1.prototype, "loadingExpired", 2);
IndexingQuotaManagementComponent$1 = __decorateClass$5([
  Component({
    components: { IndexingBreakdown, TemplateSummary, QuotaBar },
    filters: {
      humanize: /* @__PURE__ */ __name((input) => Moment(input).format("L"), "humanize")
    }
  })
], IndexingQuotaManagementComponent$1);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", { attrs: { cols: "4" } }, [_c("b-table", { attrs: { selectable: "", "select-mode": "single", fields: _vm.fields, items: _vm.allQuotas, striped: "", "details-td-class": "pt-0", "show-empty": "", emptyText: "No quota periods available." }, on: { "row-selected": _vm.onRowSelected }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(expiry)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.rowSelected ? _c("font-awesome-icon", { staticClass: "text-primary", attrs: { icon: "circle-dot" } }) : _c("font-awesome-icon", { staticClass: "text-muted", attrs: { icon: "fa-regular fa-circle" } }), _vm._v(`
          ` + _vm._s(_vm.formatDate(row.item.expiry)) + `
        `)];
  }, "fn") }, { key: "cell(active)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.active ? _c("b-badge", { staticClass: "ml-2", attrs: { variant: "success" } }, [_vm._v("Active")]) : _c("b-badge", { staticClass: "ml-2", attrs: { variant: "secondary" } }, [_vm._v("Expired")])];
  }, "fn") }, { key: "cell(usage)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
          ` + _vm._s(row.item.used) + " / " + _vm._s(row.item.total) + `
        `)];
  }, "fn") }]) })], 1), _vm._v(" "), _c("b-col", { attrs: { cols: "8" } }, [_vm.selected ? _c("indexing-breakdown", { attrs: { "quota-period": _vm.formatDate(_vm.selected.expiry) } }) : _vm._e()], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  IndexingQuotaManagementComponent$1,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  "7e4a7981"
);
const IndexingQuotaManagementComponent = __component__$5.exports;
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$4"), _a3;
let AppCreditBreakdownComponent = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "quotaPeriod");
    __publicField(this, "reloadTimer");
    __publicField(this, "loading", !1);
    __publicField(this, "quotaSummary", []);
    __publicField(this, "mode", "table");
    __publicField(this, "pieComponent", Pie);
    __publicField(this, "pallet", ["#0074D9", "#FF4136", "#2ECC40", "#FF851B", "#7FDBFF", "#B10DC9", "#FFDC00", "#001f3f", "#39CCCC", "#01FF70", "#85144b", "#F012BE", "#3D9970", "#111111", "#AAAAAA"]);
  }
  mounted() {
    Chart.register(plugin_title, plugin_tooltip, plugin_legend, LineElement, LinearScale, CategoryScale, PointElement, ArcElement, BarElement, CategoryScale, LinearScale), this.load(), this.reloadTimer = setInterval(() => this.load(), 6e4);
  }
  beforeDestroy() {
    clearInterval(this.reloadTimer);
  }
  async watchAndReload() {
    await this.load();
  }
  async load() {
    try {
      this.loading = !0;
      let results = await new AdministrationQuotaClient(new Transformer(), baseUrl()).getAppCreditsQuotaBreakdown(this.quotaPeriod);
      results ? this.quotaSummary = results.results : this.quotaSummary = [];
    } catch (e) {
      throw toastr.error(e, "Failed to load quotas"), e;
    } finally {
      this.loading = !1;
    }
  }
  get model() {
    return this.quotaPeriod;
  }
  set model(value) {
    this.load();
  }
  get tableFields() {
    return [
      { key: "pageName", sortable: !0, thClass: "align-middle py-1" },
      { key: "pageId", sortable: !0, thClass: "align-middle py-1" },
      { key: "quotaConsumed", sortable: !0, thClass: "align-middle py-1" },
      { key: "actions", label: "", sortable: !1, thClass: "align-middle py-1" }
    ];
  }
  getPalletColours(length) {
    let colors = [];
    for (let i = 0; i < length; i++)
      colors.push(this.pallet[i % (this.pallet.length - 1)]);
    return colors;
  }
  get chartData() {
    let colours = this.getPalletColours(this.quotaSummary.length);
    return {
      labels: this.quotaSummary.map((q) => q.pageName),
      datasets: [
        {
          backgroundColor: colours,
          data: this.quotaSummary.map((q) => q.quotaConsumed)
        }
      ]
    };
  }
  get chartOptions() {
    return {
      responsive: !0,
      maintainAspectRatio: !1
    };
  }
  get canvasId() {
    return v4();
  }
}, __name(_a3, "AppCreditBreakdownComponent"), _a3);
__decorateClass$4([
  Prop({ required: !0 })
], AppCreditBreakdownComponent.prototype, "quotaPeriod", 2);
__decorateClass$4([
  Watch("quotaPeriod")
], AppCreditBreakdownComponent.prototype, "watchAndReload", 1);
AppCreditBreakdownComponent = __decorateClass$4([
  Component({ components: {} })
], AppCreditBreakdownComponent);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "", "header-class": "align-middle" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("span", { staticClass: "align-middle" }, [_vm._v(`
              Expiry: ` + _vm._s(_vm.quotaPeriod) + `
            `)]), _vm._v(" "), _c("b-button", { staticClass: "float-right", staticStyle: { "margin-top": "4px" }, attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: _vm.load } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)]), _vm._v(" "), _c("b-button-group", { staticClass: "float-right mr-2", staticStyle: { "margin-top": "4px" }, attrs: { size: "sm" } }, [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn-sm", attrs: { title: "Table View", variant: _vm.mode == "table" ? "primary" : "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.mode = "table";
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "table" } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn-sm", attrs: { title: "Chart View", variant: _vm.mode == "chart" ? "primary" : "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.mode = "chart";
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "chart-simple" } })], 1)], 1)], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _vm.mode == "table" ? _c("b-table", { staticClass: "mb-0", attrs: { "sort-icon-left": "", fields: _vm.tableFields, items: _vm.quotaSummary, striped: "", busy: _vm.loading, "show-empty": "" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }], null, !1, 632667596) }) : _c("div", [_vm.quotaSummary && _vm.quotaSummary.length ? _c(_vm.pieComponent, { tag: "component", attrs: { "chart-data": _vm.chartData, "chart-id": _vm.canvasId, "chart-options": _vm.chartOptions } }) : _c("b-alert", { staticClass: "mb-0", attrs: { show: !0, variant: "primary" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
        No Quota has been consumed for the selected period.
      `)], 1)], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  AppCreditBreakdownComponent,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  null
);
const AppCreditBreakdown = __component__$4.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$3"), _a4;
let AppCreditQuotaManagementComponent$1 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "activeQuotas");
    __publicField(this, "expiredQuotas");
    __publicField(this, "loadingActive");
    __publicField(this, "loadingExpired");
    __publicField(this, "selected", null);
    __publicField(this, "reloadTimer");
    __publicField(this, "fields", [
      { key: "expiry", label: "Expiry", tdClass: "align-middle" },
      { key: "active", label: "Status", tdClass: "align-middle" },
      { key: "usage", label: "Usage", tdClass: "align-middle" }
    ]);
  }
  mounted() {
    this.loadQuotas(), this.reloadTimer = setInterval(() => this.loadQuotas(), 6e4);
  }
  beforeDestroy() {
    clearInterval(this.reloadTimer);
  }
  onRowSelected(items) {
    this.selected = items[0];
  }
  formatDate(date) {
    return Moment(date).format("yyyy-MM-DD");
  }
  get allQuotas() {
    if (this.activeQuotas && this.expiredQuotas) {
      let cloned = _.cloneDeep(this.activeQuotas), cloned2 = _.cloneDeep(this.expiredQuotas);
      return cloned = cloned.concat(cloned2), cloned;
    }
  }
  async loadQuotas() {
    try {
      await this.$store.dispatch("administration/quota/appCredit/actions/loadActive");
    } catch (e) {
      throw toastr.error(e, "Failed to load quotas"), e;
    }
    try {
      await this.$store.dispatch("administration/quota/appCredit/actions/loadExpired");
    } catch (e) {
      throw toastr.error(e, "Failed to load expired quotas"), e;
    }
  }
}, __name(_a4, "AppCreditQuotaManagementComponent"), _a4);
__decorateClass$3([
  Getter("administration/quota/appCredit/getters/active")
], AppCreditQuotaManagementComponent$1.prototype, "activeQuotas", 2);
__decorateClass$3([
  Getter("administration/quota/appCredit/getters/expired")
], AppCreditQuotaManagementComponent$1.prototype, "expiredQuotas", 2);
__decorateClass$3([
  State((state) => state.administration.quota.appCredit.quotas.active.loading)
], AppCreditQuotaManagementComponent$1.prototype, "loadingActive", 2);
__decorateClass$3([
  State((state) => state.administration.quota.appCredit.quotas.expired.loading)
], AppCreditQuotaManagementComponent$1.prototype, "loadingExpired", 2);
AppCreditQuotaManagementComponent$1 = __decorateClass$3([
  Component({
    components: { AppCreditBreakdown, TemplateSummary, QuotaBar },
    filters: {
      humanize: /* @__PURE__ */ __name((input) => Moment(input).format("L"), "humanize")
    }
  })
], AppCreditQuotaManagementComponent$1);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", { attrs: { cols: "4" } }, [_c("b-table", { attrs: { selectable: "", "select-mode": "single", fields: _vm.fields, items: _vm.allQuotas, striped: "", "details-td-class": "pt-0", "show-empty": "", emptyText: "No quota periods available." }, on: { "row-selected": _vm.onRowSelected }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(expiry)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.rowSelected ? _c("font-awesome-icon", { staticClass: "text-primary", attrs: { icon: "circle-dot" } }) : _c("font-awesome-icon", { staticClass: "text-muted", attrs: { icon: "fa-regular fa-circle" } }), _vm._v(`
          ` + _vm._s(_vm.formatDate(row.item.expiry)) + `
        `)];
  }, "fn") }, { key: "cell(active)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.active ? _c("b-badge", { staticClass: "ml-2", attrs: { variant: "success" } }, [_vm._v("Active")]) : _c("b-badge", { staticClass: "ml-2", attrs: { variant: "secondary" } }, [_vm._v("Expired")])];
  }, "fn") }, { key: "cell(usage)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
          ` + _vm._s(row.item.used) + " / " + _vm._s(row.item.total) + `
        `)];
  }, "fn") }]) })], 1), _vm._v(" "), _c("b-col", { attrs: { cols: "8" } }, [_vm.selected ? _c("app-credit-breakdown", { attrs: { "quota-period": _vm.formatDate(_vm.selected.expiry) } }) : _vm._e()], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  AppCreditQuotaManagementComponent$1,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  "449450e4"
);
const AppCreditQuotaManagementComponent = __component__$3.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$2"), _a5;
let FormsBreakdownComponent = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "quotaPeriod");
    __publicField(this, "reloadTimer");
    __publicField(this, "loading", !1);
    __publicField(this, "quotaSummary", []);
    __publicField(this, "mode", "table");
    __publicField(this, "pieComponent", Pie);
    __publicField(this, "pallet", ["#0074D9", "#FF4136", "#2ECC40", "#FF851B", "#7FDBFF", "#B10DC9", "#FFDC00", "#001f3f", "#39CCCC", "#01FF70", "#85144b", "#F012BE", "#3D9970", "#111111", "#AAAAAA"]);
  }
  mounted() {
    Chart.register(plugin_title, plugin_tooltip, plugin_legend, LineElement, LinearScale, CategoryScale, PointElement, ArcElement, BarElement, CategoryScale, LinearScale), this.load(), this.reloadTimer = setInterval(() => this.load(), 6e4);
  }
  beforeDestroy() {
    clearInterval(this.reloadTimer);
  }
  async watchAndReload() {
    await this.load();
  }
  async load() {
    try {
      this.loading = !0;
      let results = await new AdministrationQuotaClient(new Transformer(), baseUrl()).getFormsQuotaBreakdown(this.quotaPeriod);
      results ? this.quotaSummary = results.results : this.quotaSummary = [];
    } catch (e) {
      throw toastr.error(e, "Failed to load quotas"), e;
    } finally {
      this.loading = !1;
    }
  }
  get model() {
    return this.quotaPeriod;
  }
  set model(value) {
    this.load();
  }
  get tableFields() {
    return [
      { key: "pageName", sortable: !0, thClass: "align-middle py-1" },
      { key: "pageId", sortable: !0, thClass: "align-middle py-1" },
      { key: "quotaConsumed", sortable: !0, thClass: "align-middle py-1" },
      { key: "actions", label: "", sortable: !1, thClass: "align-middle py-1" }
    ];
  }
  getPalletColours(length) {
    let colors = [];
    for (let i = 0; i < length; i++)
      colors.push(this.pallet[i % (this.pallet.length - 1)]);
    return colors;
  }
  get chartData() {
    let colours = this.getPalletColours(this.quotaSummary.length);
    return {
      labels: this.quotaSummary.map((q) => q.pageName),
      datasets: [
        {
          backgroundColor: colours,
          data: this.quotaSummary.map((q) => q.quotaConsumed)
        }
      ]
    };
  }
  get chartOptions() {
    return {
      responsive: !0,
      maintainAspectRatio: !1
    };
  }
  get canvasId() {
    return v4();
  }
}, __name(_a5, "FormsBreakdownComponent"), _a5);
__decorateClass$2([
  Prop({ required: !0 })
], FormsBreakdownComponent.prototype, "quotaPeriod", 2);
__decorateClass$2([
  Watch("quotaPeriod")
], FormsBreakdownComponent.prototype, "watchAndReload", 1);
FormsBreakdownComponent = __decorateClass$2([
  Component({ components: {} })
], FormsBreakdownComponent);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "", "header-class": "align-middle" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("span", { staticClass: "align-middle" }, [_vm._v(`
              Expiry: ` + _vm._s(_vm.quotaPeriod) + `
            `)]), _vm._v(" "), _c("b-button", { staticClass: "float-right", staticStyle: { "margin-top": "4px" }, attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: _vm.load } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)]), _vm._v(" "), _c("b-button-group", { staticClass: "float-right mr-2", staticStyle: { "margin-top": "4px" }, attrs: { size: "sm" } }, [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn-sm", attrs: { title: "Table View", variant: _vm.mode == "table" ? "primary" : "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.mode = "table";
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "table" } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn-sm", attrs: { title: "Chart View", variant: _vm.mode == "chart" ? "primary" : "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.mode = "chart";
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "chart-simple" } })], 1)], 1)], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _vm.mode == "table" ? _c("b-table", { staticClass: "mb-0", attrs: { "sort-icon-left": "", fields: _vm.tableFields, items: _vm.quotaSummary, striped: "", busy: _vm.loading, "show-empty": "" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }], null, !1, 632667596) }) : _c("div", [_vm.quotaSummary && _vm.quotaSummary.length ? _c(_vm.pieComponent, { tag: "component", attrs: { "chart-data": _vm.chartData, "chart-id": _vm.canvasId, "chart-options": _vm.chartOptions } }) : _c("b-alert", { staticClass: "mb-0", attrs: { show: !0, variant: "primary" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
        No Quota has been consumed for the selected period.
      `)], 1)], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  FormsBreakdownComponent,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  null
);
const FormsBreakdown = __component__$2.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$1"), _a6;
let FormsQuotaManagementComponent$1 = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "reloadTimer");
    __publicField(this, "selected", null);
    __publicField(this, "activeQuotas");
    __publicField(this, "expiredQuotas");
    __publicField(this, "loadingActive");
    __publicField(this, "loadingExpired");
    __publicField(this, "fields", [
      { key: "expiry", label: "Expiry", tdClass: "align-middle" },
      { key: "active", label: "Status", tdClass: "align-middle" },
      { key: "usage", label: "Usage", tdClass: "align-middle" }
    ]);
  }
  mounted() {
    this.loadQuotas(), this.reloadTimer = setInterval(() => this.loadQuotas(), 6e4);
  }
  beforeDestroy() {
    clearInterval(this.reloadTimer);
  }
  onRowSelected(items) {
    this.selected = items[0];
  }
  formatDate(date) {
    return Moment(date).format("yyyy-MM-DD");
  }
  get allQuotas() {
    if (this.activeQuotas && this.expiredQuotas) {
      let cloned = _.cloneDeep(this.activeQuotas), cloned2 = _.cloneDeep(this.expiredQuotas);
      return cloned = cloned.concat(cloned2), cloned;
    }
  }
  async loadQuotas() {
    try {
      await this.$store.dispatch("administration/quota/forms/actions/loadActive");
    } catch (e) {
      throw toastr.error(e, "Failed to load quotas"), e;
    }
    try {
      await this.$store.dispatch("administration/quota/forms/actions/loadExpired");
    } catch (e) {
      throw toastr.error(e, "Failed to load expired quotas"), e;
    }
  }
}, __name(_a6, "FormsQuotaManagementComponent"), _a6);
__decorateClass$1([
  Getter("administration/quota/forms/getters/active")
], FormsQuotaManagementComponent$1.prototype, "activeQuotas", 2);
__decorateClass$1([
  Getter("administration/quota/forms/getters/expired")
], FormsQuotaManagementComponent$1.prototype, "expiredQuotas", 2);
__decorateClass$1([
  State((state) => state.administration.quota.forms.quotas.active.loading)
], FormsQuotaManagementComponent$1.prototype, "loadingActive", 2);
__decorateClass$1([
  State((state) => state.administration.quota.forms.quotas.expired.loading)
], FormsQuotaManagementComponent$1.prototype, "loadingExpired", 2);
FormsQuotaManagementComponent$1 = __decorateClass$1([
  Component({
    components: { FormsBreakdown, TemplateSummary, QuotaBar },
    filters: {
      humanize: /* @__PURE__ */ __name((input) => Moment(input).format("L"), "humanize")
    }
  })
], FormsQuotaManagementComponent$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", { attrs: { cols: "4" } }, [_c("b-table", { attrs: { selectable: "", "select-mode": "single", fields: _vm.fields, items: _vm.allQuotas, striped: "", "details-td-class": "pt-0", "show-empty": "", emptyText: "No quota periods available." }, on: { "row-selected": _vm.onRowSelected }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(expiry)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.rowSelected ? _c("font-awesome-icon", { staticClass: "text-primary", attrs: { icon: "circle-dot" } }) : _c("font-awesome-icon", { staticClass: "text-muted", attrs: { icon: "fa-regular fa-circle" } }), _vm._v(`
          ` + _vm._s(_vm.formatDate(row.item.expiry)) + `
        `)];
  }, "fn") }, { key: "cell(active)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.active ? _c("b-badge", { staticClass: "ml-2", attrs: { variant: "success" } }, [_vm._v("Active")]) : _c("b-badge", { staticClass: "ml-2", attrs: { variant: "secondary" } }, [_vm._v("Expired")])];
  }, "fn") }, { key: "cell(usage)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
          ` + _vm._s(row.item.used) + " / " + _vm._s(row.item.total) + `
        `)];
  }, "fn") }]) })], 1), _vm._v(" "), _c("b-col", { attrs: { cols: "8" } }, [_vm.selected ? _c("forms-breakdown", { attrs: { "quota-period": _vm.formatDate(_vm.selected.expiry) } }) : _vm._e()], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  FormsQuotaManagementComponent$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "241b010d"
);
const FormsQuotaManagementComponent = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a7;
let AdministrationQuotaManagementComponent = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "tab", null);
  }
  mounted() {
    this.tab || (this.tab = tabs[0].id);
  }
  beforeDestroy() {
  }
  get currentTab() {
    return this.tabs.find((t) => t.id === this.tab);
  }
  activeTab(id) {
    return this.tab && this.tab === id;
  }
  selectTab(id) {
    this.tab = id;
  }
  get tabs() {
    return tabs;
  }
}, __name(_a7, "AdministrationQuotaManagementComponent"), _a7);
AdministrationQuotaManagementComponent = __decorateClass([
  Component
], AdministrationQuotaManagementComponent);
let tabs = [
  {
    id: "indexing",
    name: "Indexing",
    icon: null,
    component: IndexingQuotaManagementComponent,
    show: !0,
    description: "Throughput Quota Management for RIA Pages"
  },
  {
    id: "forms",
    name: "Forms",
    icon: null,
    component: FormsQuotaManagementComponent,
    show: !0,
    description: "Throughput Quota Management for DFA Pages"
  },
  {
    id: "appCredit",
    name: "App Credits",
    icon: null,
    component: AppCreditQuotaManagementComponent,
    show: !0,
    description: "App Credits for EWA"
  }
];
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "exchange-alt" } }), _vm._v(" Throughput Quota Management")], 1)]), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col mb-4" }, [_c("ul", { staticClass: "nav nav-tabs unselectable" }, _vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item", attrs: { role: "presentation" } }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab(tab.id), disabled: !tab.show }, attrs: { role: "tab", title: tab.description, id: tab.id, "data-toggle": "tab" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [tab.icon ? _c("font-awesome-icon", { attrs: { icon: tab.icon } }) : _vm._e(), _vm._v(`
                        ` + _vm._s(tab.name) + `
                    `)], 1)]);
  }), 0)])]), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_c("div", { staticClass: "container-fluid" }, [_vm.currentTab ? _c(_vm.currentTab.component, { tag: "component" }) : _vm._e()], 1)])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationQuotaManagementComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "da93dcfd"
);
const index = __component__.exports;
export {
  index as default
};
