var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, W as Watch, C as Component, V as Vue, cl as AdministrationConnectionsClient, T as Transformer, b as baseUrl, n as normalizeComponent, x as getBrowserTheme, y as CodeEditor, t as toastr, f as draggable, a1 as AdministrationOAuthClient, g as v4, c as Action, G as Getter } from "./main-DAVWuHbi.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
import { m as modalCommon } from "./modalCommon-CzcVAzcj.js";
import { P as PlaceholderInformation } from "./placeholderInformation-CJo0noa4.js";
import { P as PrivateInput } from "./privateInput-Co-cfsKm.js";
import TextBoxCopy from "./textBoxCopy-CLK7neeX.js";
import { V as VModel } from "./VModel-D6nuZPuz.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { d as deleteSessionModal } from "./deleteSessionModal-0NKRuLTa.js";
var __defProp$m = Object.defineProperty, __getOwnPropDesc$n = Object.getOwnPropertyDescriptor, __decorateClass$n = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$n(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$m(target, key, result), result;
}, "__decorateClass$n"), _a;
let DataSourceUsageModal$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "shouldShow");
    __publicField(this, "item");
    __publicField(this, "loading", !1);
    __publicField(this, "dataSourceUsageResponse", null);
  }
  async mounted() {
    this.$watch("shouldShow", modalCommon.listenForShow(this.$el));
  }
  async loadSourceUsage() {
    this.dataSourceUsageResponse = null, this.loading = !0;
    try {
      this.dataSourceUsageResponse = await new AdministrationConnectionsClient(new Transformer(), baseUrl()).getDataSourceUsage(this.item.id);
    } catch {
    } finally {
      this.loading = !1;
    }
  }
  async watchShouldShow(newVal) {
    await this.$nextTick(), newVal && await this.loadSourceUsage();
  }
  closeModal() {
    this.$emit("close");
  }
}, __name(_a, "DataSourceUsageModal"), _a);
__decorateClass$n([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], DataSourceUsageModal$1.prototype, "shouldShow", 2);
__decorateClass$n([
  Prop({
    required: !0
  })
], DataSourceUsageModal$1.prototype, "item", 2);
__decorateClass$n([
  Watch("shouldShow", { immediate: !0 })
], DataSourceUsageModal$1.prototype, "watchShouldShow", 1);
DataSourceUsageModal$1 = __decorateClass$n([
  Component({
    components: {}
  })
], DataSourceUsageModal$1);
var _sfc_render$n = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "modal fade", staticStyle: { "overflow-x": "auto" }, attrs: { tabindex: "-1", role: "dialog", "data-backdrop": "static", "data-keyboard": "false" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h4", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "clipboard-list" } }), _vm._v(` Data Source Usage
                    `)], 1), _vm._v(" "), _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" }, on: { click: _vm.closeModal } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", { staticStyle: { height: "75vh" } }, [_vm.dataSourceUsageResponse && _vm.dataSourceUsageResponse.dataSourceUsage.length ? _c("b-table", { attrs: { striped: "", hover: "", "sticky-header": "100%", items: _vm.dataSourceUsageResponse.dataSourceUsage } }) : _c("div", [_c("h3", [_vm._v("Not currently in use")])])], 1)])])]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("span", { staticClass: "float-left" }, [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: _vm.closeModal } }, [_vm._v("Close")])], 1)])])])])]);
}, "render"), _sfc_staticRenderFns$n = [], __component__$n = /* @__PURE__ */ normalizeComponent(
  DataSourceUsageModal$1,
  _sfc_render$n,
  _sfc_staticRenderFns$n,
  !1,
  null,
  "fbfa9bbf"
);
const DataSourceUsageModal = __component__$n.exports;
var __defProp$l = Object.defineProperty, __getOwnPropDesc$m = Object.getOwnPropertyDescriptor, __decorateClass$m = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$m(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$l(target, key, result), result;
}, "__decorateClass$m"), _a2;
let DataSourceEditorComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "saving", !1);
    __publicField(this, "showUsage", !1);
    __publicField(this, "testing", !1);
    __publicField(this, "hasTesting", !1);
    __publicField(this, "uniquePlaceHolderInfo", [
      { syntax: '{{passwords["name"]}}', description: "Access a stored password by the password's name" }
    ]);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  getDeleteHelpText() {
    return this.model != null && this.model.dataSourceUses ? "Unable to delete a data source which is in use" : "Delete data source";
  }
  removeDataSource() {
    this.model.dataSourceUses || $("#deleteDataSourceModal").modal("show");
  }
  removeDataSourceContinue() {
    $("#deleteDataSourceModal").modal("hide"), this.$emit("removeDataSource", this.model);
  }
  save(value) {
    this.$emit("save", value);
  }
  copy() {
    this.$store.dispatch("administration/connections/datasource/actions/copy");
  }
  async cancel() {
    this.$store.dispatch("administration/connections/datasource/actions/cancel");
  }
  async testConnection() {
    this.testing = !0, this.hasTesting = !0, await this.$store.dispatch("administration/connections/datasource/actions/test"), this.testing = !1;
  }
  get dataSourceName() {
    return this.model.name;
  }
  set dataSourceName(value) {
    this.model = { ...this.model, name: value };
  }
  get description() {
    return this.model.description;
  }
  set description(value) {
    this.model = { ...this.model, description: value };
  }
  get type() {
    return this.model.type;
  }
  set type(value) {
    this.model = { ...this.model, type: value };
  }
  get connectionString() {
    return this.model.connectionString ? this.model.connectionString : "";
  }
  set connectionString(value) {
    this.model = { ...this.model, connectionString: value };
  }
  get canSave() {
    return !this.$validator.errors.any();
  }
  get providers() {
    return [
      { text: "Select a source", value: null },
      { text: "ODBC", value: "System.Data.Odbc" },
      { text: "SQL", value: "System.Data.SqlClient" }
    ];
  }
  clearTestResult() {
    this.$store.dispatch("administration/connections/datasource/actions/clearTestResult");
  }
  get testResult() {
    return this.$store.getters["administration/connections/datasource/getters/testResult"];
  }
}, __name(_a2, "DataSourceEditorComponent"), _a2);
__decorateClass$m([
  Prop({ required: !0 })
], DataSourceEditorComponent.prototype, "value", 2);
DataSourceEditorComponent = __decorateClass$m([
  Component({
    components: {
      ReactiveDropdown,
      DataSourceUsageModal,
      PlaceholderInformation,
      CodeEditor
    },
    methods: { getBrowserTheme },
    inject: [
      "$validator"
    ]
  })
], DataSourceEditorComponent);
var _sfc_render$m = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v(`Summary
        `), _vm.model.id ? _vm._e() : [_vm._v(" "), _c("small", [_vm._v("(New Data Source)")])], _vm._v(" "), _vm.model ? _c("button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-danger float-right", attrs: { disabled: _vm.model.dataSourceUses > 0, title: _vm.getDeleteHelpText() }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.removeDataSource();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
        `)], 1) : _vm._e(), _vm._v(" "), _c("button", { staticClass: "btn btn-primary float-right mr-1", attrs: { disabled: !_vm.model.id }, on: { click: _vm.copy } }, [_c("font-awesome-icon", { attrs: { icon: "copy" } }), _vm._v(` Copy
        `)], 1)], 2), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.dataSourceName, expression: "dataSourceName" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("name"), disabled: _vm.saving }, attrs: { placeholder: "e.g. SQL Server", name: "name", disabled: _vm.saving }, domProps: { value: _vm.dataSourceName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.dataSourceName = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("name")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Name for the data source")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("description") } }, [_c("label", [_vm._v("Description")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.description, expression: "description" }], staticClass: "form-control", attrs: { placeholder: "Description for the data source", name: "description" }, domProps: { value: _vm.description }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.description = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Short description for the data source")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Data Source Type")]), _vm._v(" "), _c("b-form-select", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("type"), type: _vm.saving }, attrs: { options: _vm.providers, name: "type", id: "queryTypeSelector", disabled: _vm.saving }, model: { value: _vm.type, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.type = $$v;
  }, "callback"), expression: "type" } }), _vm._v(" "), _c("br"), _vm._v(" "), _vm.errors.has("type") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("type")))]) : _vm._e(), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("The type of the data source")])], 1), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("connectionString") } }, [_c("label", [_vm._v("Connection String")]), _vm._v(" "), _c("button", { staticClass: "btn btn-primary float-right btn-sm mb-1 mr-1 mt-n1", attrs: { disabled: _vm.saving || _vm.testing || !_vm.value.connectionString }, on: { click: _vm.testConnection } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.testing, expression: "!testing" }] }, [_c("font-awesome-icon", { attrs: { icon: "vial" } }), _vm._v(" Test connection")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.testing, expression: "testing" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Testing...")], 1)]), _vm._v(" "), _vm.model.id ? _c("button", { staticClass: "btn btn-info float-right btn-sm mb-1 mr-1 mt-n1", attrs: { disabled: _vm.saving || !_vm.value.dataSourceUses }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.showUsage = !0;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "clipboard-list" } }), _vm._v(` View Usage
        `)], 1) : _vm._e(), _vm._v(" "), _c("code-editor", { attrs: { spellcheck: "false", name: "connectionString", width: "100%", languages: [["plaintext", "Connection String"]], theme: _vm.getBrowserTheme() }, model: { value: _vm.connectionString, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.connectionString = $$v;
  }, "callback"), expression: "connectionString" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Connection string for the data source. You can use "), _c("placeholder-information", { attrs: { "unique-placeholders": _vm.uniquePlaceHolderInfo } }), _vm._v(" to securely store passwords. Check out the "), _c("a", { attrs: { target: "_blank", href: "https://docs.ezescan.com.au/ezescan-webapps/3.8/database-lookup" } }, [_vm._v("help page")]), _vm._v(" for configuration examples.")], 1)], 1), _vm._v(" "), _vm.testResult && _vm.testResult != "Valid" && _vm.hasTesting ? _c("b-alert", { attrs: { show: "", variant: "danger", dismissible: "" } }, [_c("strong", [_c("font-awesome-icon", { attrs: { icon: "" } }), _vm._v("Data Source connection was unsuccessful")], 1), _vm._v(" "), _c("br"), _vm._v(" " + _vm._s(_vm.testResult) + `
      `), _c("b-button", { staticClass: "close", on: { click: _vm.clearTestResult } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])], 1) : _vm._e(), _vm._v(" "), _vm.testResult === "Valid" && _vm.hasTesting ? _c("b-alert", { attrs: { variant: "success", dismissible: "", show: "" } }, [_c("strong", [_vm._v("Data Source connected successfully")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("b-button", { staticClass: "close", on: { click: _vm.clearTestResult } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])], 1) : _vm._e(), _vm._v(" "), _c("data-source-usage-modal", { attrs: { item: _vm.model, shouldShow: _vm.showUsage }, on: { close: /* @__PURE__ */ __name(function($event) {
    _vm.showUsage = !1;
  }, "close") } }), _vm._v(" "), _c("div", { staticClass: "form-group mt-2" }, [_c("button", { staticClass: "btn btn-success", attrs: { disabled: !_vm.canSave || _vm.saving }, on: { click: _vm.save } }, [_c("font-awesome-icon", { attrs: { icon: _vm.saving ? "sync" : "save", spin: _vm.saving } }), _vm._v(` Save
        `)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default", attrs: { disabled: _vm.saving }, on: { click: _vm.cancel } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Cancel
        `)], 1)]), _vm._v(" "), _c("div", { staticClass: "modal fade", attrs: { id: "deleteDataSourceModal", tabindex: "-1", role: "dialog", "aria-labelledby": "deleteDataSourceModal", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title", attrs: { id: "deleteDataSourceLabel" } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete Data Source?
                    `)], 1), _vm._v(" "), _vm._m(0)]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` 
                            Are you sure you want to delete this Data Source?
                `)], 1), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", "data-dismiss": "modal" } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-danger", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.removeDataSourceContinue();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` 
                        Delete Data Source
                    `)], 1)])])])])], 1);
}, "render"), _sfc_staticRenderFns$m = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}], __component__$m = /* @__PURE__ */ normalizeComponent(
  DataSourceEditorComponent,
  _sfc_render$m,
  _sfc_staticRenderFns$m,
  !1,
  null,
  "c34b2593"
);
const DataSourceEditor = __component__$m.exports;
var __defProp$k = Object.defineProperty, __getOwnPropDesc$l = Object.getOwnPropertyDescriptor, __decorateClass$l = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$l(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$k(target, key, result), result;
}, "__decorateClass$l"), _a3;
let DataSourceManager$1 = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "saving", !1);
    __publicField(this, "dataSourcesFilter", "");
    __publicField(this, "selectedItem");
  }
  mounted() {
    this.loadDataSources();
  }
  async addDataSource() {
    await this.$store.dispatch("administration/connections/datasource/actions/createDataSource");
  }
  async editDataSource(Id) {
    await this.$store.dispatch("administration/connections/datasource/actions/editDataSource", Id);
  }
  async removeDataSource(dataSource) {
    if (dataSource != null && dataSource.dataSourceUses) {
      toastr.error("Unable to delete a data source which is in use");
      return;
    }
    try {
      await this.$store.dispatch("administration/connections/datasource/actions/removeDataSource", dataSource.id), await this.loadDataSources(), this.editing = null, toastr.success("Data source deleted");
    } catch (e) {
      toastr.error(e, "Failed to remove data source");
    }
  }
  // Used in draggable sort v-model binding
  set filteredDataSources(value) {
    const orderedIds = value.map((x) => x.id), sortedDataSources = this.dataSources.sort((a, b) => orderedIds.indexOf(a.id) - orderedIds.indexOf(b.id));
    this.$store.dispatch("administration/connections/datasource/actions/reorderDataSources", sortedDataSources);
  }
  get filteredDataSources() {
    return this.dataSourcesFilter ? this.dataSources.filter((ds) => {
      var _a25;
      return (_a25 = ds.name) == null ? void 0 : _a25.toLocaleLowerCase().includes(this.dataSourcesFilter.toLocaleLowerCase());
    }) : this.dataSources;
  }
  get dataSources() {
    return this.$store.getters["administration/connections/datasource/getters/dataSources"];
  }
  get editing() {
    return this.$store.getters["administration/connections/datasource/getters/editing"];
  }
  set editing(value) {
    this.$store.dispatch("administration/connections/datasource/actions/updateEditing", value);
  }
  get editingId() {
    return this.editing ? this.editing.id : null;
  }
  async loadDataSources() {
    this.loading = !0, this.loadingError = null;
    try {
      await this.$store.dispatch("administration/connections/datasource/actions/loadDataSources");
    } catch (e) {
      toastr.error(e, "Failed to load data sources"), this.loadingError = e;
    } finally {
      this.loading = !1;
    }
    this.selectedItem && (await this.selectItem(this.selectedItem, !0), this.selectedItem = null);
  }
  async selectItem(id, isEdit) {
    await this.$nextTick();
    let editItem = document.getElementById(id);
    editItem != null && editItem.scrollIntoView({ behavior: "smooth" }), isEdit && editItem != null && (this.editing = this.dataSources.find((y) => y.id == id));
  }
  async validate() {
    let validators = this.$children.map((child) => child.$validator);
    return await Promise.all(validators.map((validator) => validator.validateAll())).then((result) => result.every((valid) => valid));
  }
  async save() {
    if (!await this.validate()) {
      toastr.error("Could not save, some values are missing.");
      return;
    }
    this.saving = !0;
    let result = null;
    try {
      result = await this.$store.dispatch("administration/connections/datasource/actions/save"), toastr.success("Saved data source successfully");
    } catch (e) {
      toastr.error(e, "Failed to save data source");
    } finally {
      this.saving = !1;
    }
    result && result.id && await this.selectItem(result.id, !0);
  }
  async cancel() {
    try {
      await this.$store.dispatch("administration/connections/datasource/actions/cancel");
    } catch (e) {
      toastr.error(e, "Failed to cancel ");
    }
  }
}, __name(_a3, "DataSourceManager"), _a3);
__decorateClass$l([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], DataSourceManager$1.prototype, "selectedItem", 2);
DataSourceManager$1 = __decorateClass$l([
  Component({
    components: {
      DataSourceEditor,
      draggable
    }
  })
], DataSourceManager$1);
var _sfc_render$l = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("h3", [_c("font-awesome-icon", { attrs: { icon: "server" } }), _vm._v(" Data Sources "), _vm.dataSources ? _c("b-badge", { staticClass: "small", attrs: { small: "", variant: "info", pill: "" } }, [_vm._v(_vm._s(_vm.dataSources.length))]) : _vm._e(), _vm._v(" "), _c("b-button", { attrs: { variant: "primary", size: "sm" }, on: { click: _vm.addDataSource } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(" Add data source")], 1)], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", { attrs: { cols: "6" } }, [_c("b-input-group", { staticClass: "mb-3", attrs: { size: "sm" } }, [_c("b-input-group-prepend", [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)], 1), _vm._v(" "), _c("b-input", { staticClass: "w-50", attrs: { type: "text", id: "dataSourcesFilterInput", placeholder: "Filter Data Sources" }, model: { value: _vm.dataSourcesFilter, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.dataSourcesFilter = $$v;
  }, "callback"), expression: "dataSourcesFilter" } }), _vm._v(" "), _vm.dataSourcesFilter.length && _vm.filteredDataSources ? _c("b-input-group-append", [_c("span", { staticClass: "input-group-text" }, [_vm._v(_vm._s(_vm.filteredDataSources.length))])]) : _vm._e()], 1)], 1)], 1), _vm._v(" "), _c("b-row", [_c("b-col", { attrs: { cols: "6" } }, [_vm.filteredDataSources && _vm.filteredDataSources.length ? _c("b-list-group", { staticStyle: { "overflow-y": "scroll", height: "65vh" } }, [_c("draggable", { attrs: { tag: "div", handle: ".field-handle", disabled: !!_vm.dataSourcesFilter }, model: { value: _vm.filteredDataSources, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filteredDataSources = $$v;
  }, "callback"), expression: "filteredDataSources" } }, _vm._l(_vm.filteredDataSources, function(dataSource) {
    return _c("b-list-group-item", { key: dataSource.id, attrs: { active: dataSource.id === _vm.editingId, id: dataSource.id, href: "#", name: dataSource.name }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editDataSource(dataSource.id);
    }, "click") } }, [_c("div", [_c("h4", { staticClass: "list-group-item-heading" }, [_c("font-awesome-icon", { staticClass: "field-handle", attrs: { icon: "grip-vertical" } }), _vm._v(" "), dataSource.name ? [_vm._v(_vm._s(dataSource.name))] : [_vm._v("Unnamed Data Source")], _vm._v(" "), dataSource.dataSourceUses ? [_c("span", { staticClass: "badge badge-info badge-pill", staticStyle: { "font-size": "small" } }, [_vm._v(`
                        Uses: ` + _vm._s(dataSource.dataSourceUses) + `
                    `)])] : _vm._e(), _vm._v(" "), _c("span", { staticClass: "float-right" }, [dataSource.id === _vm.editingId ? _c("font-awesome-icon", { attrs: { icon: "arrow-right" } }) : _vm._e()], 1)], 2), _vm._v(" "), dataSource.description ? _c("span", { staticClass: "list-group-item-text" }, [_vm._v(_vm._s(dataSource.description) + " "), _c("br")]) : _vm._e()])]);
  }), 1)], 1) : _c("b-alert", { attrs: { show: "", variant: "info" } }, [_vm.dataSourcesFilter.length ? _c("tenplate", [_vm._v("There are not results from your filter: '" + _vm._s(_vm.dataSourcesFilter) + "'")]) : [_vm._v("No data sources currently configured")]], 2)], 1), _vm._v(" "), _vm.editing ? _c("b-col", { attrs: { cols: "6" } }, [_c("data-source-editor", { on: { save: _vm.save, cancel: _vm.cancel, removeDataSource: _vm.removeDataSource }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } })], 1) : _vm._e()], 1)], 1);
}, "render"), _sfc_staticRenderFns$l = [], __component__$l = /* @__PURE__ */ normalizeComponent(
  DataSourceManager$1,
  _sfc_render$l,
  _sfc_staticRenderFns$l,
  !1,
  null,
  "756dd2c4"
);
const DataSourceManager = __component__$l.exports;
var __defProp$j = Object.defineProperty, __getOwnPropDesc$k = Object.getOwnPropertyDescriptor, __decorateClass$k = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$k(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$j(target, key, result), result;
}, "__decorateClass$k"), _a4;
let DataQueryUsageModal$1 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "shouldShow");
    __publicField(this, "item");
    __publicField(this, "loading", !1);
    __publicField(this, "dataQueryUsageResponse", null);
  }
  async mounted() {
    this.$watch("shouldShow", modalCommon.listenForShow(this.$el));
  }
  async loadQueryUsage() {
    this.dataQueryUsageResponse = null, this.loading = !0;
    try {
      this.dataQueryUsageResponse = await new AdministrationConnectionsClient(new Transformer(), baseUrl()).getDataQueryUsage(this.item.id);
    } catch {
    } finally {
      this.loading = !1;
    }
  }
  async watchShouldShow(newVal) {
    await this.$nextTick(), newVal && await this.loadQueryUsage();
  }
  closeModal() {
    this.$emit("close");
  }
}, __name(_a4, "DataQueryUsageModal"), _a4);
__decorateClass$k([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], DataQueryUsageModal$1.prototype, "shouldShow", 2);
__decorateClass$k([
  Prop({
    required: !0
  })
], DataQueryUsageModal$1.prototype, "item", 2);
__decorateClass$k([
  Watch("shouldShow", { immediate: !0 })
], DataQueryUsageModal$1.prototype, "watchShouldShow", 1);
DataQueryUsageModal$1 = __decorateClass$k([
  Component({
    components: {}
  })
], DataQueryUsageModal$1);
var _sfc_render$k = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "modal fade", staticStyle: { "overflow-x": "auto" }, attrs: { tabindex: "-1", role: "dialog", "data-backdrop": "static", "data-keyboard": "false" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h4", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "clipboard-list" } }), _vm._v(` Data Query Usage
                    `)], 1), _vm._v(" "), _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" }, on: { click: _vm.closeModal } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", { staticStyle: { height: "75vh" } }, [_vm.dataQueryUsageResponse && _vm.dataQueryUsageResponse.dataQueryUsage.length ? _c("b-table", { attrs: { striped: "", hover: "", "sticky-header": "100%", items: _vm.dataQueryUsageResponse.dataQueryUsage } }) : _c("div", [_c("h3", [_vm._v("Not currently in use")])])], 1)])])]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("span", { staticClass: "float-left" }, [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: _vm.closeModal } }, [_vm._v("Close")])], 1)])])])])]);
}, "render"), _sfc_staticRenderFns$k = [], __component__$k = /* @__PURE__ */ normalizeComponent(
  DataQueryUsageModal$1,
  _sfc_render$k,
  _sfc_staticRenderFns$k,
  !1,
  null,
  "9d05f2ab"
);
const DataQueryUsageModal = __component__$k.exports;
var __defProp$i = Object.defineProperty, __getOwnPropDesc$j = Object.getOwnPropertyDescriptor, __decorateClass$j = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$j(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$i(target, key, result), result;
}, "__decorateClass$j"), _a5;
let DataQueryEditorComponent = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "saving", !1);
    __publicField(this, "showUsage", !1);
    __publicField(this, "editorLanguages", [["sql", "SQL"]]);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  /*
    @Watch('type')
    watchType(type){
      this.getCodeEditorLanguages(type);
    }
  
      private getCodeEditorLanguages(type) {
        if(type != "EzeScan.WebApps.Placeholder")
          this.editorLanguages = [['sql', 'SQL']]
        else
          this.editorLanguages = [['plaintext', 'Placeholders']]
  
      }*/
  getDeleteHelpText() {
    return this.model != null && this.model.dataQueryUses ? "Unable to delete a data query which is in use" : "Delete data query";
  }
  removeDataQuery() {
    this.model.dataQueryUses || $("#deleteDataQueryModal").modal("show");
  }
  removeDataQueryContinue() {
    $("#deleteDataQueryModal").modal("hide"), this.$emit("removeDataQuery", this.model);
  }
  save(value) {
    this.$emit("save", value);
  }
  copy() {
    this.$store.dispatch("administration/connections/dataquery/actions/copy");
  }
  async cancel() {
    this.$store.dispatch("administration/connections/dataquery/actions/cancel");
  }
  get dataQueryName() {
    return this.model.name;
  }
  set dataQueryName(value) {
    this.model = { ...this.model, name: value };
  }
  get description() {
    return this.model.description;
  }
  set description(value) {
    this.model = { ...this.model, description: value };
  }
  get type() {
    return this.model.type;
  }
  set type(value) {
    this.model = { ...this.model, type: value };
  }
  get query() {
    return this.model.query;
  }
  set query(value) {
    this.model = { ...this.model, query: value };
  }
  get canSave() {
    return !this.$validator.errors.any();
  }
  get providers() {
    return [
      { text: "Select a query type", value: null },
      { text: "ODBC", value: "System.Data.Odbc" },
      { text: "SQL", value: "System.Data.SqlClient" },
      { text: "Authority Server", value: "Authority.Server" },
      { text: "EzeScan WebApps Placeholders", value: "EzeScan.WebApps.Placeholder" }
    ];
  }
}, __name(_a5, "DataQueryEditorComponent"), _a5);
__decorateClass$j([
  Prop({ required: !0 })
], DataQueryEditorComponent.prototype, "value", 2);
DataQueryEditorComponent = __decorateClass$j([
  Component({
    components: {
      ReactiveDropdown,
      DataQueryUsageModal,
      CodeEditor
    },
    methods: { getBrowserTheme },
    inject: [
      "$validator"
    ]
  })
], DataQueryEditorComponent);
var _sfc_render$j = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v(`Summary
			`), _vm.model.id ? _vm._e() : [_vm._v(" "), _c("small", [_vm._v("(New Data Query)")])], _vm._v(" "), _vm.model ? _c("button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-danger float-right", attrs: { disabled: _vm.model.dataQueryUses > 0, id: "deleteDataQuery", title: _vm.getDeleteHelpText(_vm.model) }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.removeDataQuery();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
			`)], 1) : _vm._e(), _vm._v(" "), _c("button", { staticClass: "btn btn-primary float-right mr-1", attrs: { disabled: !_vm.model.id }, on: { click: _vm.copy } }, [_c("font-awesome-icon", { attrs: { icon: "copy" } }), _vm._v(` Copy
            `)], 1)], 2), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.dataQueryName, expression: "dataQueryName" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("name"), disabled: _vm.saving }, attrs: { placeholder: "e.g. Invoice Number Query", name: "name", disabled: _vm.saving }, domProps: { value: _vm.dataQueryName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.dataQueryName = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("name")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Name for the data query")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("description") } }, [_c("label", [_vm._v("Description")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.description, expression: "description" }], staticClass: "form-control", attrs: { placeholder: "Description for the data query", name: "description" }, domProps: { value: _vm.description }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.description = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Short description for the data query")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Data Query Type")]), _vm._v(" "), _c("b-form-select", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("type"), type: _vm.saving }, attrs: { options: _vm.providers, name: "type", id: "queryTypeSelector", disabled: _vm.saving }, model: { value: _vm.type, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.type = $$v;
  }, "callback"), expression: "type" } }), _vm._v(" "), _c("br"), _vm._v(" "), _vm.errors.has("type") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("type")))]) : _vm._e(), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("The type of the data query")])], 1), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("query") } }, [_c("label", [_vm._v("Query")]), _vm._v(" "), _vm.model.id ? _c("button", { staticClass: "btn btn-info float-right btn-sm mb-1 mr-1 mt-n1", attrs: { disabled: _vm.saving || !_vm.value.dataQueryUses }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.showUsage = !0;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "clipboard-list" } }), _vm._v(` View Usage
			`)], 1) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_vm.type != "EzeScan.WebApps.Placeholder" ? _c("span", [_c("code-editor", { attrs: { name: "query", width: "100%", id: "queryEditor", languages: [["sql", "SQL"]], height: "33vh", theme: _vm.getBrowserTheme() }, model: { value: _vm.query, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.query = $$v;
  }, "callback"), expression: "query" } })], 1) : _c("span", [_c("code-editor", { attrs: { name: "query", width: "100%", id: "queryEditor", languages: [["plaintext", "Placeholders"]], height: "33vh", theme: _vm.getBrowserTheme() }, model: { value: _vm.query, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.query = $$v;
  }, "callback"), expression: "query" } })], 1)]), _vm._v(" "), _vm._m(0)]), _vm._v(" "), _c("data-query-usage-modal", { attrs: { item: _vm.model, shouldShow: _vm.showUsage }, on: { close: /* @__PURE__ */ __name(function($event) {
    _vm.showUsage = !1;
  }, "close") } }), _vm._v(" "), _c("div", { staticClass: "form-group mt-2" }, [_c("button", { staticClass: "btn btn-success", attrs: { id: "saveQuery", disabled: !_vm.canSave || _vm.saving }, on: { click: _vm.save } }, [_c("font-awesome-icon", { attrs: { icon: _vm.saving ? "sync" : "save", spin: _vm.saving } }), _vm._v(` Save
			`)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default", attrs: { id: "cancelQuery", disabled: _vm.saving }, on: { click: _vm.cancel } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Cancel
			`)], 1)]), _vm._v(" "), _c("div", { staticClass: "modal fade", attrs: { id: "deleteDataQueryModal", tabindex: "-1", role: "dialog", "aria-labelledby": "deleteDataQueryModal", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title", attrs: { id: "deleteDataQueryLabel" } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete Data Query?
              `)], 1), _vm._v(" "), _vm._m(1)]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` 
                  Are you sure you want to delete this Data Query?
          `)], 1), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", "data-dismiss": "modal" } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-danger", attrs: { type: "button", id: "deleteDataQueryConfirm" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.removeDataQueryContinue();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` 
                  Delete Data Query
              `)], 1)])])])])], 1);
}, "render"), _sfc_staticRenderFns$j = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("p", { staticClass: "text-muted" }, [_vm._v("The query to execute. Check out the "), _c("a", { attrs: { target: "_blank", href: "https://docs.ezescan.com.au/ezescan-webapps/3.8/database-lookup" } }, [_vm._v("help page")]), _vm._v(" for configuration examples.")]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}], __component__$j = /* @__PURE__ */ normalizeComponent(
  DataQueryEditorComponent,
  _sfc_render$j,
  _sfc_staticRenderFns$j,
  !1,
  null,
  "9876873a"
);
const DataQueryEditor = __component__$j.exports;
var __defProp$h = Object.defineProperty, __getOwnPropDesc$i = Object.getOwnPropertyDescriptor, __decorateClass$i = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$i(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$h(target, key, result), result;
}, "__decorateClass$i"), _a6;
let DataQueryManager$1 = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "saving", !1);
    __publicField(this, "dataQueriesFilter", "");
    __publicField(this, "selectedItem");
  }
  mounted() {
    this.loadDataQueries();
  }
  async addDataQuery() {
    await this.$store.dispatch("administration/connections/dataquery/actions/createDataQuery");
  }
  async editDataQuery(Id) {
    await this.$store.dispatch("administration/connections/dataquery/actions/editDataQuery", Id);
  }
  async removeDataQuery(dataQuery) {
    if (dataQuery != null && dataQuery.dataQueryUses) {
      toastr.error("Unable to delete a data query which is in use");
      return;
    }
    try {
      await this.$store.dispatch("administration/connections/dataquery/actions/removeDataQuery", dataQuery.id), await this.loadDataQueries(), this.editing = null, toastr.success("Data query deleted");
    } catch (e) {
      toastr.error(e, "Failed to remove data query");
    }
  }
  // Used in draggable sort v-model binding
  set filteredDataQueries(value) {
    const orderedIds = value.map((x) => x.id), sortedDataQueries = this.dataQueries.sort((a, b) => orderedIds.indexOf(a.id) - orderedIds.indexOf(b.id));
    this.$store.dispatch("administration/connections/dataquery/actions/reorderDataQueries", sortedDataQueries);
  }
  get filteredDataQueries() {
    return this.dataQueriesFilter ? this.dataQueries.filter((ds) => {
      var _a25;
      return (_a25 = ds.name) == null ? void 0 : _a25.toLocaleLowerCase().includes(this.dataQueriesFilter.toLocaleLowerCase());
    }) : this.dataQueries;
  }
  get dataQueries() {
    return this.$store.getters["administration/connections/dataquery/getters/dataQueries"];
  }
  get editing() {
    return this.$store.getters["administration/connections/dataquery/getters/editing"];
  }
  set editing(value) {
    this.$store.dispatch("administration/connections/dataquery/actions/updateEditing", value);
  }
  get editingId() {
    return this.editing ? this.editing.id : null;
  }
  async loadDataQueries() {
    this.loading = !0, this.loadingError = null;
    try {
      await this.$store.dispatch("administration/connections/dataquery/actions/loadDataQueries");
    } catch (e) {
      toastr.error(e, "Failed to load data queries"), this.loadingError = e;
    } finally {
      this.loading = !1;
    }
    this.selectedItem && (await this.selectItem(this.selectedItem, !0), this.selectedItem = null);
  }
  async selectItem(id, isEdit) {
    await this.$nextTick();
    var editItem = document.getElementById(id);
    editItem != null && editItem.scrollIntoView({ behavior: "smooth" }), isEdit && editItem != null && (this.editing = this.dataQueries.find((y) => y.id == id));
  }
  async validate() {
    let validators = this.$children.map((c) => c.$validator);
    return await Promise.all(validators.map((validator) => validator.validateAll())).then((result) => result.every((valid) => valid));
  }
  duplicateQueryString(dataQueryItem) {
    let conflictMessage = "";
    return this.dataQueries.forEach((dataQuery) => {
      dataQuery.id != dataQueryItem.id && (dataQuery.name === dataQueryItem.name && (conflictMessage = "This Data Query has a duplicate name"), dataQuery.query === dataQueryItem.query && (conflictMessage = "This Data Query has a duplicate query with " + dataQuery.name));
    }), conflictMessage;
  }
  async save() {
    var isValid = await this.validate();
    if (!isValid) {
      toastr.error("Could not save, some values are missing.");
      return;
    }
    this.saving = !0;
    var result = null;
    try {
      result = await this.$store.dispatch("administration/connections/dataquery/actions/save"), toastr.success("Saved data query successfully");
    } catch (e) {
      toastr.error(e, "Failed to save data query");
    } finally {
      this.saving = !1;
    }
    result && result.id && await this.selectItem(result.id, !0);
  }
  async cancel() {
    try {
      await this.$store.dispatch("administration/connections/dataquery/actions/cancel");
    } catch (e) {
      toastr.error(e, "Failed to cancel ");
    }
  }
}, __name(_a6, "DataQueryManager"), _a6);
__decorateClass$i([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], DataQueryManager$1.prototype, "selectedItem", 2);
DataQueryManager$1 = __decorateClass$i([
  Component({
    components: {
      DataQueryEditor,
      draggable
    }
  })
], DataQueryManager$1);
var _sfc_render$i = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("h3", [_c("font-awesome-icon", { attrs: { icon: "server" } }), _vm._v(" Data Queries "), _vm.dataQueries ? _c("b-badge", { staticClass: "small", attrs: { small: "", variant: "info", pill: "" } }, [_vm._v(_vm._s(_vm.dataQueries.length))]) : _vm._e(), _vm._v(" "), _c("b-button", { attrs: { variant: "primary", size: "sm", id: "addDataQuery" }, on: { click: _vm.addDataQuery } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(" Add data query")], 1)], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", { attrs: { cols: "6" } }, [_c("b-input-group", { staticClass: "mb-3", attrs: { size: "sm" } }, [_c("b-input-group-prepend", [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)], 1), _vm._v(" "), _c("b-input", { staticClass: "w-50", attrs: { type: "text", id: "dataQueriesFilterInput", placeholder: "Filter Data Queries" }, model: { value: _vm.dataQueriesFilter, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.dataQueriesFilter = $$v;
  }, "callback"), expression: "dataQueriesFilter" } }), _vm._v(" "), _vm.dataQueriesFilter.length ? _c("b-input-group-append", [_c("span", { staticClass: "input-group-text" }, [_vm._v(_vm._s(_vm.filteredDataQueries.length))])]) : _vm._e()], 1)], 1)], 1), _vm._v(" "), _c("b-row", [_c("b-col", { attrs: { cols: "6" } }, [_vm.filteredDataQueries && _vm.filteredDataQueries.length ? _c("b-list-group", { staticStyle: { "overflow-y": "scroll", height: "65vh" } }, [_c("draggable", { attrs: { tag: "div", handle: ".field-handle", disabled: !!_vm.dataQueriesFilter }, model: { value: _vm.filteredDataQueries, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filteredDataQueries = $$v;
  }, "callback"), expression: "filteredDataQueries" } }, _vm._l(_vm.filteredDataQueries, function(dataQuery) {
    return _c("b-list-group-item", { key: dataQuery.id, attrs: { active: dataQuery.id === _vm.editingId, id: dataQuery.id, name: dataQuery.name }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editDataQuery(dataQuery.id);
    }, "click") } }, [_c("h4", { staticClass: "list-group-item-heading" }, [_c("font-awesome-icon", { staticClass: "field-handle", attrs: { icon: "grip-vertical" } }), _vm._v(" "), dataQuery.name ? [_vm._v(_vm._s(dataQuery.name))] : [_vm._v("Unnamed Data Query")], _vm._v(" "), dataQuery.dataQueryUses ? [_c("span", { staticClass: "badge badge-info badge-pill", staticStyle: { "font-size": "small" } }, [_vm._v(`
                      Uses: ` + _vm._s(dataQuery.dataQueryUses) + `
                  `)])] : _vm._e(), _vm._v(" "), _vm.duplicateQueryString(dataQuery) ? _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "text-warning align-middle", attrs: { title: _vm.duplicateQueryString(dataQuery) } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } })], 1) : _vm._e(), _vm._v(" "), _c("span", { staticClass: "float-right" }, [dataQuery.id === _vm.editingId ? _c("font-awesome-icon", { attrs: { icon: "arrow-right" } }) : _vm._e()], 1)], 2), _vm._v(" "), dataQuery.description ? _c("span", { staticClass: "list-group-item-text" }, [_vm._v(_vm._s(dataQuery.description) + " "), _c("br")]) : _vm._e(), _vm._v(" "), dataQuery.type ? _c("strong", { staticClass: "list-group-item-text" }, [_vm._v(_vm._s(dataQuery.type))]) : _vm._e()]);
  }), 1)], 1) : _c("b-alert", { attrs: { show: "", variant: "info" } }, [_vm.dataQueriesFilter.length ? _c("span", [_vm._v("There are not results from your filter: '" + _vm._s(_vm.dataQueriesFilter) + "'")]) : _c("span", [_vm._v("No data queries currently configured")])])], 1), _vm._v(" "), _vm.editing ? _c("b-col", { attrs: { cols: "6" } }, [_c("data-query-editor", { on: { save: _vm.save, cancel: _vm.cancel, removeDataQuery: _vm.removeDataQuery }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } })], 1) : _vm._e()], 1)], 1);
}, "render"), _sfc_staticRenderFns$i = [], __component__$i = /* @__PURE__ */ normalizeComponent(
  DataQueryManager$1,
  _sfc_render$i,
  _sfc_staticRenderFns$i,
  !1,
  null,
  "70c3a283"
);
const DataQueryManager = __component__$i.exports;
var __defProp$g = Object.defineProperty, __getOwnPropDesc$h = Object.getOwnPropertyDescriptor, __decorateClass$h = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$h(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$g(target, key, result), result;
}, "__decorateClass$h"), _a7;
let PasswordStoreEditorComponent = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "saving", !1);
    __publicField(this, "useTextInput", !0);
    __publicField(this, "fileUploaded", !1);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  removePasswordStore() {
    $("#deletePasswordStoreModal").modal("show");
  }
  removePasswordStoreContinue() {
    $("#deletePasswordStoreModal").modal("hide"), this.$emit("removePasswordStore", this.model);
  }
  save(value) {
    this.$emit("save", value);
  }
  async cancel() {
    this.$store.dispatch("administration/connections/passwordstore/actions/cancel");
  }
  async onFileChange(e) {
    let files = e.target.files || e.dataTransfer.files;
    if (!files.length)
      return;
    let currentFile = files[0], reader = new FileReader();
    try {
      reader.onload = (readEvent) => {
        const arrayBuffer = readEvent.target.result;
        this.passwordValue = this.convertArrayBufferToBase64String(arrayBuffer);
      }, reader.readAsArrayBuffer(currentFile), toastr.success("The selected file has be imported into the password value"), this.fileUploaded = !0;
    } catch (ex) {
      toastr.error(ex, "An error occurred while parsing/uploading the selected file");
    }
  }
  resetFileUpload() {
    this.fileUploaded = !1, this.$refs["upload-file"].reset();
  }
  convertArrayBufferToBase64String(arrayBuffer) {
    const byteArray = new Uint8Array(arrayBuffer);
    byteArray.reduce((data, byte) => data + String.fromCharCode(byte), "");
    const charsString = String.fromCharCode.apply(null, byteArray);
    return btoa(charsString);
  }
  get placeholderExample() {
    if (this.passwordStoreName)
      return '{{passwords["' + this.passwordStoreName + '"]}}';
  }
  get passwordStoreName() {
    return this.model.name;
  }
  set passwordStoreName(value) {
    this.model = { ...this.model, name: value };
  }
  get description() {
    return this.model.description;
  }
  set description(value) {
    this.model = { ...this.model, description: value };
  }
  get passwordValue() {
    return this.model.value;
  }
  set passwordValue(value) {
    this.model = { ...this.model, value };
  }
  get canSave() {
    return !this.$validator.errors.any();
  }
}, __name(_a7, "PasswordStoreEditorComponent"), _a7);
__decorateClass$h([
  Prop({ required: !0 })
], PasswordStoreEditorComponent.prototype, "value", 2);
PasswordStoreEditorComponent = __decorateClass$h([
  Component({
    components: {
      PrivateInput,
      TextBoxCopy
    },
    inject: [
      "$validator"
    ]
  })
], PasswordStoreEditorComponent);
var _sfc_render$h = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v(_vm._s(_vm.passwordStoreName) + `
      `), _vm.passwordStoreName ? _vm._e() : _c("span", { staticClass: "text-muted" }, [_vm._v("Unnamed entry")]), _vm._v(" "), _vm.model.id ? _vm._e() : [_c("small", { staticClass: "text-muted" }, [_vm._v("(New password store entry)")])], _vm._v(" "), _vm.model ? _c("button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-danger float-right", attrs: { title: "'Delete Password Store'" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.removePasswordStore();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
      `)], 1) : _vm._e()], 2), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.passwordStoreName, expression: "passwordStoreName" }, { name: "validate", rawName: "v-validate", value: "required|alpha_dash", expression: "'required|alpha_dash'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("name"), disabled: _vm.saving }, attrs: { name: "name", disabled: _vm.saving }, domProps: { value: _vm.passwordStoreName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.passwordStoreName = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("name")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Name for the password store entry")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("description") } }, [_c("label", [_vm._v("Description")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.description, expression: "description" }], staticClass: "form-control", attrs: { name: "description" }, domProps: { value: _vm.description }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.description = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Short description for the password store entry")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v(`Placeholder
        `), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "text-primary", attrs: { pill: "", title: "Use this to access the value in areas that allow placeholders" } }, [_c("font-awesome-icon", { attrs: { icon: "question-circle" } })], 1)]), _vm._v(" "), _c("text-box-copy", { attrs: { id: "placeholder", value: _vm.placeholderExample, disabled: !0 } })], 1), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("passwordValue") } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Password")]), _vm._v(" "), _c("private-input", { directives: [{ name: "show", rawName: "v-show", value: _vm.useTextInput, expression: "useTextInput" }], attrs: { "input-name": "passwordValue", label: "", autocomplete: "off", name: "passwordValue", "help-text": "Password to store. Leave blank to keep current password" }, model: { value: _vm.passwordValue, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.passwordValue = $$v;
  }, "callback"), expression: "passwordValue" } }, [_c("b-input-group-prepend", [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "info", title: "Change the input type from text to file upload" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.useTextInput = !_vm.useTextInput;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.useTextInput ? "text" : "file" } })], 1)], 1)], 1), _vm._v(" "), _c("b-form-group", { directives: [{ name: "show", rawName: "v-show", value: !_vm.useTextInput, expression: "!useTextInput" }], attrs: { description: "Select a file/certificate to upload into the password store" } }, [_c("span", { staticClass: "forceHeight" }, [_vm.fileUploaded ? _c("b-input-group", [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("font-awesome-icon", { staticClass: "text-success", attrs: { icon: "check" } })], 1), _vm._v(" "), _c("b-form-input", { attrs: { disabled: "", value: "File Uploaded" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "danger", title: "Upload a new file" }, on: { click: _vm.resetFileUpload } }, [_c("font-awesome-icon", { attrs: { icon: "times" } })], 1)], 1)], 1) : _c("b-input-group", [_c("b-input-group-prepend", [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "info", title: "Change the input type from text to file upload" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.useTextInput = !_vm.useTextInput;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.useTextInput ? "text" : "file" } })], 1)], 1), _vm._v(" "), _c("b-form-file", { ref: "upload-file", attrs: { desciprion: "Upload a text file or certificate", id: "uploadFile", "drop-placeholder": "Drop file here..." }, on: { change: _vm.onFileChange } })], 1)], 1)])], 1), _vm._v(" "), _c("div", { staticClass: "form-group mt-2" }, [_c("button", { staticClass: "btn btn-success", attrs: { disabled: !_vm.canSave || _vm.saving }, on: { click: _vm.save } }, [_c("font-awesome-icon", { attrs: { icon: _vm.saving ? "sync" : "save", spin: _vm.saving } }), _vm._v(` Save
        `)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default", attrs: { disabled: _vm.saving }, on: { click: _vm.cancel } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Cancel
        `)], 1)]), _vm._v(" "), _c("div", { staticClass: "modal fade", attrs: { id: "deletePasswordStoreModal", tabindex: "-1", role: "dialog", "aria-labelledby": "deletePasswordStoreModal", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title", attrs: { id: "deletePasswordStoreLabel" } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete Password Store?
                    `)], 1), _vm._v(" "), _vm._m(0)]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` 
                            Are you sure you want to delete this Password Store?
                `)], 1), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", "data-dismiss": "modal" } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-danger", attrs: { type: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.removePasswordStoreContinue();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` 
                        Delete Password Store
                    `)], 1)])])])])]);
}, "render"), _sfc_staticRenderFns$h = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}], __component__$h = /* @__PURE__ */ normalizeComponent(
  PasswordStoreEditorComponent,
  _sfc_render$h,
  _sfc_staticRenderFns$h,
  !1,
  null,
  "da5d683a"
);
const PasswordStoreEditor = __component__$h.exports;
var __getOwnPropDesc$g = Object.getOwnPropertyDescriptor, __decorateClass$g = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$g(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$g"), _a8;
let PasswordStoreManager$1 = (_a8 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "saving", !1);
  }
  mounted() {
    this.loadPasswordStores();
  }
  async addPasswordStore() {
    await this.$store.dispatch("administration/connections/passwordstore/actions/createPasswordStore");
  }
  async editPasswordStore(Id) {
    await this.$store.dispatch("administration/connections/passwordstore/actions/editPasswordStore", Id);
  }
  async removePasswordStore(passwordStore) {
    try {
      await this.$store.dispatch("administration/connections/passwordstore/actions/removePasswordStore", passwordStore.id), await this.loadPasswordStores(), this.editing = null, toastr.success("Password store deleted");
    } catch (e) {
      toastr.error(e, "Failed to remove password store");
    }
  }
  get passwordStores() {
    return this.$store.getters["administration/connections/passwordstore/getters/passwordStores"];
  }
  get editing() {
    return this.$store.getters["administration/connections/passwordstore/getters/editing"];
  }
  set editing(value) {
    this.$store.dispatch("administration/connections/passwordstore/actions/updateEditing", value);
  }
  get editingId() {
    return this.editing ? this.editing.id : null;
  }
  async loadPasswordStores() {
    this.loading = !0, this.loadingError = null;
    try {
      await this.$store.dispatch("administration/connections/passwordstore/actions/loadPasswordStores");
    } catch (e) {
      toastr.error(e, "Failed to load password stores"), this.loadingError = e;
    } finally {
      this.loading = !1;
    }
  }
  async validate() {
    let validators = this.$children.map((child) => child.$validator);
    return await Promise.all(validators.map((validator) => validator.validateAll())).then((result) => result.every((valid) => valid));
  }
  async save() {
    var isValid = await this.validate();
    if (!isValid) {
      toastr.error("Could not save, some values are missing.");
      return;
    }
    this.saving = !0;
    var result = null;
    try {
      result = await this.$store.dispatch("administration/connections/passwordstore/actions/save"), toastr.success("Saved password store successfully");
    } catch (e) {
      toastr.error(e, "Failed to save password store");
    } finally {
      this.saving = !1;
    }
  }
  async cancel() {
    try {
      await this.$store.dispatch("administration/connections/passwordstore/actions/cancel");
    } catch (e) {
      toastr.error(e, "Failed to cancel ");
    }
  }
}, __name(_a8, "PasswordStoreManager"), _a8);
PasswordStoreManager$1 = __decorateClass$g([
  Component({
    components: {
      PasswordStoreEditor
    }
  })
], PasswordStoreManager$1);
var _sfc_render$g = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-6" }, [_c("button", { staticClass: "btn btn-success mb-2", on: { click: _vm.addPasswordStore } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add entry
        `)], 1), _vm._v(" "), _vm.passwordStores && _vm.passwordStores.length ? _c("div", { staticStyle: { "overflow-y": "scroll", height: "65vh" } }, _vm._l(_vm.passwordStores, function(passwordStore) {
    return _c("div", { key: passwordStore.id, staticClass: "list-group-item list-group-item-action", class: { active: passwordStore.id === _vm.editingId }, attrs: { id: passwordStore.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editPasswordStore(passwordStore.id);
    }, "click") } }, [_c("h4", { staticClass: "list-group-item-heading" }, [passwordStore.name ? [_vm._v(`
                        ` + _vm._s(passwordStore.name) + `
                    `)] : _vm._e(), _vm._v(" "), _c("span", { staticClass: "float-right" }, [passwordStore.id === _vm.editingId ? _c("font-awesome-icon", { attrs: { icon: "arrow-right" } }) : _vm._e()], 1)], 2), _vm._v(" "), passwordStore.description ? _c("span", { staticClass: "list-group-item-text" }, [_vm._v(_vm._s(passwordStore.description) + " "), _c("br")]) : _vm._e()]);
  }), 0) : _c("div", { staticClass: "alert alert-info" }, [_vm._v("No password stores are currently configured")])]), _vm._v(" "), _vm.editing ? _c("div", { staticClass: "col-md-6" }, [_c("password-store-editor", { on: { save: _vm.save, cancel: _vm.cancel, removePasswordStore: _vm.removePasswordStore }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } })], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$g = [], __component__$g = /* @__PURE__ */ normalizeComponent(
  PasswordStoreManager$1,
  _sfc_render$g,
  _sfc_staticRenderFns$g,
  !1,
  null,
  null
);
const PasswordStoreManager = __component__$g.exports;
var __defProp$f = Object.defineProperty, __getOwnPropDesc$f = Object.getOwnPropertyDescriptor, __decorateClass$f = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$f(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$f(target, key, result), result;
}, "__decorateClass$f"), _a9;
let AzureAccessKeyExternalConnectionConfiguration = (_a9 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
}, __name(_a9, "AzureAccessKeyExternalConnectionConfiguration"), _a9);
__decorateClass$f([
  VModel({ required: !0 })
], AzureAccessKeyExternalConnectionConfiguration.prototype, "model", 2);
AzureAccessKeyExternalConnectionConfiguration = __decorateClass$f([
  Component({ components: { PrivateInput }, inject: ["$validator"] })
], AzureAccessKeyExternalConnectionConfiguration);
var _sfc_render$f = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Storage Account Name")]), _vm._v(" "), _c("b-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("storageAccountName") }, attrs: { placeholder: "Storage account name", name: "storageAccountName", "data-vv-as": "storage account name" }, model: { value: _vm.model.storageAccountName, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "storageAccountName", $$v);
  }, "callback"), expression: "model.storageAccountName" } }), _vm._v(" "), _vm.errors.has("storageAccountName") ? _c("span", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("storageAccountName")))]) : _c("span", { staticClass: "text-muted" }, [_vm._v("The storage account name")])], 1), _vm._v(" "), _c("private-input", { attrs: { label: "Access Key", "input-name": "accessKey", "help-text": "Access key to the storage account. This field supports usage of the password store" }, model: { value: _vm.model.storageAccessKey, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "storageAccessKey", $$v);
  }, "callback"), expression: "model.storageAccessKey" } })], 1)], 1);
}, "render"), _sfc_staticRenderFns$f = [], __component__$f = /* @__PURE__ */ normalizeComponent(
  AzureAccessKeyExternalConnectionConfiguration,
  _sfc_render$f,
  _sfc_staticRenderFns$f,
  !1,
  null,
  "b129dd9a"
);
const accessKey = __component__$f.exports;
var __defProp$e = Object.defineProperty, __getOwnPropDesc$e = Object.getOwnPropertyDescriptor, __decorateClass$e = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$e(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$e(target, key, result), result;
}, "__decorateClass$e"), _a10;
let AzureConnectionStringExternalConnectionConfiguration = (_a10 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
}, __name(_a10, "AzureConnectionStringExternalConnectionConfiguration"), _a10);
__decorateClass$e([
  VModel({ required: !0 })
], AzureConnectionStringExternalConnectionConfiguration.prototype, "model", 2);
AzureConnectionStringExternalConnectionConfiguration = __decorateClass$e([
  Component({ components: { PrivateInput }, inject: ["$validator"] })
], AzureConnectionStringExternalConnectionConfiguration);
var _sfc_render$e = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("private-input", { attrs: { label: "Connection String", "input-name": "connectionString", "help-text": "Connection string for the azure account. This field supports usage of the password store" }, model: { value: _vm.model.connectionString, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "connectionString", $$v);
  }, "callback"), expression: "model.connectionString" } })], 1)], 1);
}, "render"), _sfc_staticRenderFns$e = [], __component__$e = /* @__PURE__ */ normalizeComponent(
  AzureConnectionStringExternalConnectionConfiguration,
  _sfc_render$e,
  _sfc_staticRenderFns$e,
  !1,
  null,
  "e3e8e7aa"
);
const connectionString = __component__$e.exports;
var __defProp$d = Object.defineProperty, __getOwnPropDesc$d = Object.getOwnPropertyDescriptor, __decorateClass$d = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$d(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$d(target, key, result), result;
}, "__decorateClass$d"), _a11;
let AzureManagedIdentityExternalConnectionConfiguration = (_a11 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
}, __name(_a11, "AzureManagedIdentityExternalConnectionConfiguration"), _a11);
__decorateClass$d([
  VModel({ required: !0 })
], AzureManagedIdentityExternalConnectionConfiguration.prototype, "model", 2);
AzureManagedIdentityExternalConnectionConfiguration = __decorateClass$d([
  Component({ components: {}, inject: ["$validator"] })
], AzureManagedIdentityExternalConnectionConfiguration);
var _sfc_render$d = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Storage Account Name")]), _vm._v(" "), _c("b-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("storageAccountName") }, attrs: { placeholder: "Storage account name", name: "storageAccountName", "data-vv-as": "storage account name" }, model: { value: _vm.model.storageAccountName, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "storageAccountName", $$v);
  }, "callback"), expression: "model.storageAccountName" } }), _vm._v(" "), _vm.errors.has("storageAccountName") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("storageAccountName")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("The storage account name")]), _vm._v(" "), _c("label", { staticClass: "font-weight-bold" }, [_vm._v("Client Id")]), _vm._v(" "), _c("b-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("clientId") }, attrs: { placeholder: "Client id", name: "clientId" }, model: { value: _vm.model.clientId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "clientId", $$v);
  }, "callback"), expression: "model.clientId" } }, [_vm._v(">")]), _vm._v(" "), _vm.errors.has("clientId") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("clientId")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("The Client Id for the managed identity")])], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$d = [], __component__$d = /* @__PURE__ */ normalizeComponent(
  AzureManagedIdentityExternalConnectionConfiguration,
  _sfc_render$d,
  _sfc_staticRenderFns$d,
  !1,
  null,
  "83951533"
);
const managedIdentity = __component__$d.exports;
var __defProp$c = Object.defineProperty, __getOwnPropDesc$c = Object.getOwnPropertyDescriptor, __decorateClass$c = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$c(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$c(target, key, result), result;
}, "__decorateClass$c"), _a12;
let AzureSasUrlExternalConnectionConfiguration = (_a12 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
}, __name(_a12, "AzureSasUrlExternalConnectionConfiguration"), _a12);
__decorateClass$c([
  VModel({ required: !0 })
], AzureSasUrlExternalConnectionConfiguration.prototype, "model", 2);
AzureSasUrlExternalConnectionConfiguration = __decorateClass$c([
  Component({ components: { PrivateInput }, inject: ["$validator"] })
], AzureSasUrlExternalConnectionConfiguration);
var _sfc_render$c = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("b-form-group", [_c("private-input", { attrs: { label: "SAS URL", "input-name": "sasUrl", "help-text": "The SAS url, including the signature for the azure connection." }, model: { value: _vm.model.sasUrl, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "sasUrl", $$v);
  }, "callback"), expression: "model.sasUrl" } })], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$c = [], __component__$c = /* @__PURE__ */ normalizeComponent(
  AzureSasUrlExternalConnectionConfiguration,
  _sfc_render$c,
  _sfc_staticRenderFns$c,
  !1,
  null,
  "9278f5ba"
);
const sasUrl = __component__$c.exports, authenticationTypeOptions = [
  {
    id: "AzureStorage.AuthenticationType.AccessKey",
    icon: "key",
    component: accessKey,
    name: "Access Key"
  },
  {
    id: "AzureStorage.AuthenticationType.ConnectionString",
    icon: "lock",
    component: connectionString,
    name: "Connection String"
  },
  {
    id: "AzureStorage.AuthenticationType.ManagedIdentity",
    icon: "passport",
    component: managedIdentity,
    name: "Managed Identity"
  },
  {
    id: "AzureStorage.AuthenticationType.SasUrl",
    icon: "globe",
    component: sasUrl,
    name: "SAS Url"
  }
], authenticationTypeOptions$1 = authenticationTypeOptions.sort(function(a, b) {
  return a.name.localeCompare(b.name);
});
var __defProp$b = Object.defineProperty, __getOwnPropDesc$b = Object.getOwnPropertyDescriptor, __decorateClass$b = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$b(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$b(target, key, result), result;
}, "__decorateClass$b"), _a13;
let AzureStorageExternalConnectionConfiguration = (_a13 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
  get componentEditor() {
    var _a25;
    return this.model ? (_a25 = authenticationTypeOptions$1.find((o) => o.id == this.model.authenticationType)) == null ? void 0 : _a25.component : null;
  }
  get authenticationTypes() {
    return authenticationTypeOptions$1.map((opt) => ({ value: opt.id, text: opt.name }));
  }
  get authenticationType() {
    return this.model.authenticationType;
  }
  set authenticationType(value) {
    this.model.authenticationType = value;
  }
}, __name(_a13, "AzureStorageExternalConnectionConfiguration"), _a13);
__decorateClass$b([
  VModel({ required: !0 })
], AzureStorageExternalConnectionConfiguration.prototype, "model", 2);
AzureStorageExternalConnectionConfiguration = __decorateClass$b([
  Component({ components: {}, inject: ["$validator"] })
], AzureStorageExternalConnectionConfiguration);
var _sfc_render$b = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("b-form-group", { attrs: { id: "authenticationType", label: "Authentication Type", "label-class": "font-weight-bold" } }, [_c("b-form-select", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("authenticationType") }, attrs: { options: _vm.authenticationTypes, name: "authenticationType", "data-vv-as": "authentication type" }, scopedSlots: _vm._u([{ key: "first", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-form-select-option", { attrs: { value: null, disabled: "" } }, [_vm._v("Select...")])];
  }, "fn"), proxy: !0 }]), model: { value: _vm.authenticationType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.authenticationType = $$v;
  }, "callback"), expression: "authenticationType" } }), _vm._v(" "), _vm.errors.has("authenticationType") ? _c("span", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("authenticationType")))]) : _c("span", { staticClass: "text-muted" }, [_vm._v("The authentication type to use for communication")])], 1), _vm._v(" "), _c(_vm.componentEditor, { tag: "component", model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } })], 1)], 1);
}, "render"), _sfc_staticRenderFns$b = [], __component__$b = /* @__PURE__ */ normalizeComponent(
  AzureStorageExternalConnectionConfiguration,
  _sfc_render$b,
  _sfc_staticRenderFns$b,
  !1,
  null,
  "093d0686"
);
const azureStorage = __component__$b.exports;
var __defProp$a = Object.defineProperty, __getOwnPropDesc$a = Object.getOwnPropertyDescriptor, __decorateClass$a = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$a(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$a(target, key, result), result;
}, "__decorateClass$a"), _a14;
let AzureFormRecognizerExternalConnectionConfiguration = (_a14 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
}, __name(_a14, "AzureFormRecognizerExternalConnectionConfiguration"), _a14);
__decorateClass$a([
  VModel({ required: !0 })
], AzureFormRecognizerExternalConnectionConfiguration.prototype, "model", 2);
AzureFormRecognizerExternalConnectionConfiguration = __decorateClass$a([
  Component({ components: { PrivateInput }, inject: ["$validator"] })
], AzureFormRecognizerExternalConnectionConfiguration);
var _sfc_render$a = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Endpoint Url")]), _vm._v(" "), _c("b-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("endpoint") }, attrs: { placeholder: "Endpoint", name: "endpoint", "data-vv-as": "endpoint" }, model: { value: _vm.model.endpoint, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "endpoint", $$v);
  }, "callback"), expression: "model.endpoint" } }), _vm._v(" "), _vm.errors.has("endpoint") ? _c("span", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("endpoint")))]) : _c("span", { staticClass: "text-muted" }, [_vm._v("The endpoint url for Azure Document Intelligence instance")])], 1), _vm._v(" "), _c("private-input", { attrs: { label: "Api Key", "input-name": "apiKey", "help-text": "Api key to the endpoint. This field supports usage of the password store" }, model: { value: _vm.model.apiKey, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "apiKey", $$v);
  }, "callback"), expression: "model.apiKey" } })], 1)], 1);
}, "render"), _sfc_staticRenderFns$a = [], __component__$a = /* @__PURE__ */ normalizeComponent(
  AzureFormRecognizerExternalConnectionConfiguration,
  _sfc_render$a,
  _sfc_staticRenderFns$a,
  !1,
  null,
  "56454d27"
);
const azureFormRecognizer = __component__$a.exports;
var __defProp$9 = Object.defineProperty, __getOwnPropDesc$9 = Object.getOwnPropertyDescriptor, __decorateClass$9 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$9(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$9(target, key, result), result;
}, "__decorateClass$9"), _a15;
let azureOpenAIExternalConnectionConfiguration = (_a15 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
}, __name(_a15, "azureOpenAIExternalConnectionConfiguration"), _a15);
__decorateClass$9([
  VModel({ required: !0 })
], azureOpenAIExternalConnectionConfiguration.prototype, "model", 2);
azureOpenAIExternalConnectionConfiguration = __decorateClass$9([
  Component({ components: { PrivateInput }, inject: ["$validator"] })
], azureOpenAIExternalConnectionConfiguration);
var _sfc_render$9 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Endpoint Url")]), _vm._v(" "), _c("b-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("endpoint") }, attrs: { placeholder: "Endpoint", name: "endpoint", "data-vv-as": "endpoint" }, model: { value: _vm.model.endpoint, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "endpoint", $$v);
  }, "callback"), expression: "model.endpoint" } }), _vm._v(" "), _vm.errors.has("endpoint") ? _c("span", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("endpoint")))]) : _c("span", { staticClass: "text-muted" }, [_vm._v("The endpoint url for Azure OpenAI instance")])], 1), _vm._v(" "), _c("private-input", { attrs: { label: "Api Key", "input-name": "apiKey", "help-text": "Api key to the endpoint. This field supports usage of the password store" }, model: { value: _vm.model.apiKey, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "apiKey", $$v);
  }, "callback"), expression: "model.apiKey" } })], 1)], 1);
}, "render"), _sfc_staticRenderFns$9 = [], __component__$9 = /* @__PURE__ */ normalizeComponent(
  azureOpenAIExternalConnectionConfiguration,
  _sfc_render$9,
  _sfc_staticRenderFns$9,
  !1,
  null,
  null
);
const azureOpenAI = __component__$9.exports;
var __defProp$8 = Object.defineProperty, __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor, __decorateClass$8 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$8(target, key, result), result;
}, "__decorateClass$8"), _a16;
let OAuthMicrosoftCustomProvider$1 = (_a16 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "clientId");
    __publicField(this, "externalConnectionId");
    __publicField(this, "grantType");
    __publicField(this, "tenantId");
    __publicField(this, "reloadTimer", null);
    __publicField(this, "loading", !0);
    __publicField(this, "authenticating", !1);
    __publicField(this, "provider", null);
    __publicField(this, "tempProviderId", null);
    __publicField(this, "loadingSession", !1);
  }
  get oAuthProviderId() {
    return this.value;
  }
  set oAuthProviderId(value) {
    this.$emit("input", value);
  }
  async mounted() {
    this.oAuthProviderId ? this.provider = await new AdministrationOAuthClient(new Transformer(), baseUrl()).query(this.oAuthProviderId, "microsoftCustom") : this.tempProviderId = v4(), this.loading = !1, this.reloadTimer = setInterval(() => this.refreshProvider(), 5e3);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  async refreshProvider() {
    this.provider && this.provider.status == "Pending Authentication" && !this.loadingSession && (this.loadingSession = !0, this.provider = await new AdministrationOAuthClient(new Transformer(), baseUrl()).query(this.currentProviderId, "microsoftInbuilt"), this.loadingSession = !1);
  }
  async clearSession() {
    this.oAuthProviderId && (await new AdministrationOAuthClient(new Transformer(), baseUrl()).clearSession(this.oAuthProviderId), this.oAuthProviderId = null, this.tempProviderId = v4(), this.provider = null, this.$emit("save"));
  }
  showClearSessionModal() {
    this.$bvModal.show("delete-session-modal");
  }
  async authorize() {
    this.$emit("save"), this.authenticating = !0, this.grantType == "authorization_code" && window.open(this.authenticationUrl);
    try {
      await new AdministrationOAuthClient(new Transformer(), baseUrl()).createMicrosoftCustomProvider(this.currentProviderId, this.externalConnectionId), this.provider = await new AdministrationOAuthClient(new Transformer(), baseUrl()).query(this.currentProviderId, "microsoftCustom", !1), this.provider && (this.oAuthProviderId = this.currentProviderId, this.$emit("save"));
    } catch {
    } finally {
      this.authenticating = !1;
    }
  }
  get currentProviderId() {
    if (this.tempProviderId)
      return this.tempProviderId;
    if (this.oAuthProviderId)
      return this.oAuthProviderId;
  }
  get redirect_uri() {
    return new URL(baseUrl() + "/administration/oauth/microsoftCustom").href;
  }
  async copyRedirect() {
    try {
      await navigator.clipboard.writeText(this.redirect_uri), toastr.success("Successfully copied");
    } catch {
      toastr.error("Could not copy");
    }
  }
  get authenticationUrl() {
    return "https://login.microsoftonline.com/" + this.tenantId + "/oauth2/v2.0/authorize?client_id=" + this.clientId + "&redirect_uri=" + encodeURI(this.redirect_uri) + "&state=" + this.currentProviderId + "&scope=" + encodeURI("https://graph.microsoft.com/.default offline_access") + "&response_type=code&prompt=select_account";
  }
}, __name(_a16, "OAuthMicrosoftCustomProvider"), _a16);
__decorateClass$8([
  Prop({
    required: !0
  })
], OAuthMicrosoftCustomProvider$1.prototype, "value", 2);
__decorateClass$8([
  Prop({
    required: !0
  })
], OAuthMicrosoftCustomProvider$1.prototype, "clientId", 2);
__decorateClass$8([
  Prop({
    required: !0
  })
], OAuthMicrosoftCustomProvider$1.prototype, "externalConnectionId", 2);
__decorateClass$8([
  Prop({
    required: !0
  })
], OAuthMicrosoftCustomProvider$1.prototype, "grantType", 2);
__decorateClass$8([
  Prop({
    required: !0
  })
], OAuthMicrosoftCustomProvider$1.prototype, "tenantId", 2);
OAuthMicrosoftCustomProvider$1 = __decorateClass$8([
  Component({
    components: { DateDisplay, deleteSessionModal },
    inject: ["$validator"]
  })
], OAuthMicrosoftCustomProvider$1);
var _sfc_render$8 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("OAuth Session")]), _vm._v(" "), _vm.provider ? _c("div", { staticClass: "row col" }, [_c("ul", { staticClass: "list-group mb-3 col-sm-6" }, [_c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
            Status
            `), _c("span", { staticClass: "badge", class: { "badge-success": _vm.provider.status === "Authenticated", "badge-warning": _vm.provider.status !== "Authenticated" } }, [_vm.provider.status === "Authenticated" ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(" " + _vm._s(_vm.provider.status) + `
                `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(" " + _vm._s(_vm.provider.status) + `
                `)], 1)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
            Last Updated
            `), _c("date-display", { attrs: { humanise: "true", value: _vm.provider.lastUpdated, "show-time": "true" } })], 1), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
            Expiry
            `), _c("date-display", { attrs: { humanise: "true", value: _vm.provider.tokenExpiresAt, "show-time": "true" } })], 1), _vm._v(" "), _vm.provider.providerIdentifier ? _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
          User
          `), _c("span", [_vm._v(`
                ` + _vm._s(_vm.provider.providerIdentifier) + `
            `)])]) : _vm._e()])]) : _c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Authorizing with OAuth will attempt to establish a session with the selected party
    `)], 1), _vm._v(" "), _vm.provider ? _vm._e() : _c("b-button", { staticClass: "mb-1", attrs: { size: "sm", variant: "primary" }, on: { click: _vm.authorize } }, [_c("font-awesome-icon", { attrs: { icon: "sign-in" } }), _vm._v(" "), _c("span", [_vm._v("Authorize")])], 1), _vm._v(" "), _vm.authenticating ? _c("b-button", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: !0 } })], 1) : _vm._e(), _vm._v(" "), _vm.provider ? _vm.provider ? _c("b-button", { staticClass: "mb-1", attrs: { size: "sm", variant: "danger" }, on: { click: _vm.showClearSessionModal } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete Session
    `)], 1) : _vm._e() : _c("b-button", { staticClass: "mb-1", attrs: { size: "sm", variant: "info" }, on: { click: _vm.copyRedirect } }, [_c("font-awesome-icon", { attrs: { icon: "clipboard" } }), _vm._v(` Copy Redirect URI
    `)], 1), _vm._v(" "), _c("delete-session-modal", { on: { confirm: _vm.clearSession } })], 1);
}, "render"), _sfc_staticRenderFns$8 = [], __component__$8 = /* @__PURE__ */ normalizeComponent(
  OAuthMicrosoftCustomProvider$1,
  _sfc_render$8,
  _sfc_staticRenderFns$8,
  !1,
  null,
  "a33a9e39"
);
const OAuthMicrosoftCustomProvider = __component__$8.exports;
var __defProp$7 = Object.defineProperty, __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor, __decorateClass$7 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$7(target, key, result), result;
}, "__decorateClass$7"), _a17;
let OAuthMicrosoftInbuiltProvider$1 = (_a17 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "externalConnectionId");
    __publicField(this, "sharedMailboxPermission");
    __publicField(this, "reloadTimer", null);
    __publicField(this, "loading", !0);
    __publicField(this, "authenticating", !1);
    __publicField(this, "provider", null);
    __publicField(this, "tempProviderId", null);
    __publicField(this, "loadingSession", !1);
  }
  get oAuthProviderId() {
    return this.value;
  }
  set oAuthProviderId(value) {
    this.$emit("input", value);
  }
  async mounted() {
    this.oAuthProviderId ? this.provider = await new AdministrationOAuthClient(new Transformer(), baseUrl()).query(this.oAuthProviderId, "microsoftInbuilt") : this.tempProviderId = v4(), this.loading = !1, this.reloadTimer = setInterval(() => this.refreshProvider(), 5e3);
  }
  async beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  async refreshProvider() {
    this.provider && this.provider.status == "Pending Authentication" && !this.loadingSession && (this.loadingSession = !0, this.provider = await new AdministrationOAuthClient(new Transformer(), baseUrl()).query(this.currentProviderId, "microsoftInbuilt"), this.loadingSession = !1);
  }
  async clearSession() {
    this.oAuthProviderId && (await new AdministrationOAuthClient(new Transformer(), baseUrl()).clearSession(this.oAuthProviderId), this.oAuthProviderId = null, this.tempProviderId = v4(), this.provider = null, this.$emit("save"));
  }
  showClearSessionModal() {
    this.$bvModal.show("delete-session-modal");
  }
  async authorize() {
    this.authenticating = !0, window.open(this.authenticationUrl);
    try {
      await new AdministrationOAuthClient(new Transformer(), baseUrl()).createMicrosoftInbuiltProvider(this.currentProviderId, this.externalConnectionId), this.provider = await new AdministrationOAuthClient(new Transformer(), baseUrl()).query(this.currentProviderId, "microsoftInbuilt"), this.provider && (this.oAuthProviderId = this.currentProviderId, this.$emit("save"));
    } catch {
    } finally {
      this.authenticating = !1;
    }
  }
  get currentProviderId() {
    if (this.tempProviderId)
      return this.tempProviderId;
    if (this.oAuthProviderId)
      return this.oAuthProviderId;
  }
  get redirect_uri() {
    return new URL(baseUrl() + "/administration/oauth/microsoftInbuilt").href;
  }
  get authenticationUrl() {
    let permission = "Mail.ReadWrite";
    return this.sharedMailboxPermission && (permission = "Mail.ReadWrite Mail.ReadWrite.Shared"), "https://oauth.services.ezescan.net/v1/authorise?client_id=d5ee84e6-ad92-4fdd-967b-315ac69c7db8&redirect_uri=" + encodeURI(this.redirect_uri) + "&state=" + this.currentProviderId + "&scope=" + permission + " offline_access openid profile&response_type=code&forward_to=" + encodeURI("https://login.microsoftonline.com/common/oauth2/v2.0/authorize?") + "&prompt=select_account";
  }
}, __name(_a17, "OAuthMicrosoftInbuiltProvider"), _a17);
__decorateClass$7([
  Prop({
    required: !0
  })
], OAuthMicrosoftInbuiltProvider$1.prototype, "value", 2);
__decorateClass$7([
  Prop({
    required: !0
  })
], OAuthMicrosoftInbuiltProvider$1.prototype, "externalConnectionId", 2);
__decorateClass$7([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], OAuthMicrosoftInbuiltProvider$1.prototype, "sharedMailboxPermission", 2);
OAuthMicrosoftInbuiltProvider$1 = __decorateClass$7([
  Component({
    components: { DateDisplay, deleteSessionModal },
    inject: ["$validator"]
  })
], OAuthMicrosoftInbuiltProvider$1);
var _sfc_render$7 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("OAuth Session")]), _vm._v(" "), _vm.loading ? _c("div", [_c("div", { staticClass: "text-primary my-auto mx-auto" }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v("Loading...")])], 1)]) : _c("div", [_vm.provider ? _c("div", { staticClass: "row col" }, [_c("ul", { staticClass: "list-group mb-3 col-sm-6" }, [_c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
          Status
          `), _c("span", { staticClass: "badge", class: { "badge-success": _vm.provider.status === "Authenticated", "badge-warning": _vm.provider.status !== "Authenticated" } }, [_vm.provider.status === "Authenticated" ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(" " + _vm._s(_vm.provider.status) + `
                `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(" " + _vm._s(_vm.provider.status) + `
                `)], 1)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
          Last Updated
          `), _c("date-display", { attrs: { humanise: "true", value: _vm.provider.lastUpdated, "show-time": "true" } })], 1), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
          Expiry
          `), _c("date-display", { attrs: { humanise: "true", value: _vm.provider.tokenExpiresAt, "show-time": "true" } })], 1), _vm._v(" "), _vm.provider.providerIdentifier ? _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
          User
            `), _c("span", [_vm._v(`
                ` + _vm._s(_vm.provider.providerIdentifier) + `
            `)])]) : _vm._e()])]) : _vm._e(), _vm._v(" "), _c("div", [_vm.provider ? _vm._e() : _c("div", [_c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Authorizing with OAuth will attempt to establish a session with the selected party
        `)], 1), _vm._v(" "), _c("b-button", { staticClass: "mb-1", attrs: { size: "sm", variant: "primary" }, on: { click: _vm.authorize } }, [_c("font-awesome-icon", { attrs: { icon: "sign-in" } }), _vm._v(" "), _c("span", [_vm._v("Authorize")])], 1)], 1), _vm._v(" "), _vm.authenticating ? _c("b-button", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: !0 } })], 1) : _vm.provider ? _c("b-button", { staticClass: "mb-1", attrs: { size: "sm", variant: "danger" }, on: { click: _vm.showClearSessionModal } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete Session
      `)], 1) : _vm._e(), _vm._v(" "), _c("delete-session-modal", { on: { confirm: _vm.clearSession } })], 1)])]);
}, "render"), _sfc_staticRenderFns$7 = [], __component__$7 = /* @__PURE__ */ normalizeComponent(
  OAuthMicrosoftInbuiltProvider$1,
  _sfc_render$7,
  _sfc_staticRenderFns$7,
  !1,
  null,
  "317d1422"
);
const OAuthMicrosoftInbuiltProvider = __component__$7.exports;
var __defProp$6 = Object.defineProperty, __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$6(target, key, result), result;
}, "__decorateClass$6"), _a18;
let MicrosoftGraphExternalConnectionConfiguration = (_a18 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
  get authenticationTypes() {
    return [
      { value: "inbuilt", text: "Inbuilt" },
      { value: "custom", text: "Custom" }
    ];
  }
  get grantTypes() {
    return [
      { value: "client_credentials", text: "Client Credentials" },
      { value: "authorization_code", text: "Authorization Code" }
    ];
  }
  get authenticationType() {
    return this.model.authenticationType;
  }
  set authenticationType(value) {
    this.model.authenticationType = value;
  }
  get grantType() {
    return this.model.grantType;
  }
  set grantType(value) {
    this.model.grantType = value;
  }
  get allowSharedMailbox() {
    return this.model.allowSharedMailbox;
  }
  set allowSharedMailbox(value) {
    this.model.allowSharedMailbox = value;
  }
  get oAuthProviderId() {
    return this.model.oAuthProviderId;
  }
  set oAuthProviderId(value) {
    this.model.oAuthProviderId = value;
  }
}, __name(_a18, "MicrosoftGraphExternalConnectionConfiguration"), _a18);
__decorateClass$6([
  VModel({ required: !0 })
], MicrosoftGraphExternalConnectionConfiguration.prototype, "model", 2);
MicrosoftGraphExternalConnectionConfiguration = __decorateClass$6([
  Component({ components: { PrivateInput, OAuthMicrosoftCustomProvider, OAuthMicrosoftInbuiltProvider }, inject: ["$validator"] })
], MicrosoftGraphExternalConnectionConfiguration);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("b-form-group", { attrs: { id: "authenticationType", label: "Authentication Type", "label-class": "font-weight-bold" } }, [_c("b-form-select", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("authenticationType") }, attrs: { options: _vm.authenticationTypes, name: "authenticationType", "data-vv-as": "authentication type" }, scopedSlots: _vm._u([{ key: "first", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-form-select-option", { attrs: { value: null, disabled: "" } }, [_vm._v("Select...")])];
  }, "fn"), proxy: !0 }]), model: { value: _vm.authenticationType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.authenticationType = $$v;
  }, "callback"), expression: "authenticationType" } }), _vm._v(" "), _vm.errors.has("authenticationType") ? _c("span", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("authenticationType")))]) : _c("span", { staticClass: "text-muted" }, [_vm._v("The authentication type to use for communication")])], 1), _vm._v(" "), _vm.authenticationType == "inbuilt" ? _c("div", [_c("b-form-group", { attrs: { description: "When enabled, the session will request 'Shared Mailbox Permissions'" } }, [_c("b-form-checkbox", { attrs: { switch: "" }, model: { value: _vm.allowSharedMailbox, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.allowSharedMailbox = $$v;
  }, "callback"), expression: "allowSharedMailbox" } }, [_c("b", [_vm._v("Allow Shared Mailbox")])])], 1), _vm._v(" "), _c("o-auth-microsoft-inbuilt-provider", { key: _vm.oAuthProviderId, attrs: { externalConnectionId: _vm.model.id, sharedMailboxPermission: _vm.allowSharedMailbox }, on: { save: /* @__PURE__ */ __name(function($event) {
    return _vm.$emit("save");
  }, "save") }, model: { value: _vm.oAuthProviderId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.oAuthProviderId = $$v;
  }, "callback"), expression: "oAuthProviderId" } })], 1) : _vm.authenticationType == "custom" ? _c("div", [_c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Grant Type")]), _vm._v(" "), _c("b-form-select", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("grantType") }, attrs: { options: _vm.grantTypes, name: "grantType", "data-vv-as": "grant type" }, scopedSlots: _vm._u([{ key: "first", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-form-select-option", { attrs: { value: null, disabled: "" } }, [_vm._v("Select...")])];
  }, "fn"), proxy: !0 }]), model: { value: _vm.grantType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.grantType = $$v;
  }, "callback"), expression: "grantType" } }), _vm._v(" "), _vm.errors.has("grantType") ? _c("span", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("grantType")))]) : _c("span", { staticClass: "text-muted" }, [_vm._v("The type of grant to use for the connection")])], 1), _vm._v(" "), _c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Tenant Id")]), _vm._v(" "), _c("b-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("tenantId") }, attrs: { placeholder: "Tenant Id", name: "tenantId" }, model: { value: _vm.model.tenantId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "tenantId", $$v);
  }, "callback"), expression: "model.tenantId" } }, [_vm._v(">")]), _vm._v(" "), _vm.errors.has("tenantId") ? _c("span", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("tenantId")))]) : _c("span", { staticClass: "text-muted" }, [_vm._v("The Tenant Id for the connection")])], 1), _vm._v(" "), _c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Client Id")]), _vm._v(" "), _c("b-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("clientId") }, attrs: { placeholder: "Client Id", name: "clientId" }, model: { value: _vm.model.clientId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "clientId", $$v);
  }, "callback"), expression: "model.clientId" } }, [_vm._v(">")]), _vm._v(" "), _vm.errors.has("clientId") ? _c("span", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("clientId")))]) : _c("span", { staticClass: "text-muted" }, [_vm._v("The Client Id for the connection")])], 1), _vm._v(" "), _c("private-input", { attrs: { label: "Client Secret", "input-name": "Secret", "help-text": "Client secret to connect to Microsoft Graph API" }, model: { value: _vm.model.secret, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "secret", $$v);
  }, "callback"), expression: "model.secret" } }), _vm._v(" "), _vm.model.id && _vm.model.clientId && _vm.model.tenantId && _vm.grantType && _vm.model.name && _vm.model.secret ? _c("o-auth-microsoft-custom-provider", { key: _vm.oAuthProviderId, attrs: { clientId: _vm.model.clientId, externalConnectionId: _vm.model.id, grantType: _vm.grantType, tenantId: _vm.model.tenantId }, on: { save: /* @__PURE__ */ __name(function($event) {
    return _vm.$emit("save");
  }, "save") }, model: { value: _vm.oAuthProviderId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.oAuthProviderId = $$v;
  }, "callback"), expression: "oAuthProviderId" } }) : _c("div", [_c("b-alert", { attrs: { show: !0, variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
                    Save the external connection to start authentication.
                `)], 1)], 1)], 1) : _c("div", [_c("b-alert", { attrs: { show: !0, variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
                Select an authentication type to configure additional fields.
            `)], 1)], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  MicrosoftGraphExternalConnectionConfiguration,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  "845ae953"
);
const microsoftGraph = __component__$6.exports;
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$5"), _a19;
let PresidioExternalConnectionConfiguration = (_a19 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
}, __name(_a19, "PresidioExternalConnectionConfiguration"), _a19);
__decorateClass$5([
  VModel({ required: !0 })
], PresidioExternalConnectionConfiguration.prototype, "model", 2);
PresidioExternalConnectionConfiguration = __decorateClass$5([
  Component({ components: {}, inject: ["$validator"] })
], PresidioExternalConnectionConfiguration);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Endpoint Url")]), _vm._v(" "), _c("b-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("endpoint") }, attrs: { placeholder: "Endpoint", name: "endpoint", "data-vv-as": "endpoint" }, model: { value: _vm.model.endpoint, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "endpoint", $$v);
  }, "callback"), expression: "model.endpoint" } }), _vm._v(" "), _vm.errors.has("endpoint") ? _c("span", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("endpoint")))]) : _c("span", { staticClass: "text-muted" }, [_vm._v("The endpoint url for the Presidio instance")])], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  PresidioExternalConnectionConfiguration,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  null
);
const presidio = __component__$5.exports;
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$4"), _a20;
let AzureAiLanguageExternalConnectionConfiguration = (_a20 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
}, __name(_a20, "AzureAiLanguageExternalConnectionConfiguration"), _a20);
__decorateClass$4([
  VModel({ required: !0 })
], AzureAiLanguageExternalConnectionConfiguration.prototype, "model", 2);
AzureAiLanguageExternalConnectionConfiguration = __decorateClass$4([
  Component({ components: { PrivateInput }, inject: ["$validator"] })
], AzureAiLanguageExternalConnectionConfiguration);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Endpoint Url")]), _vm._v(" "), _c("b-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("endpoint") }, attrs: { placeholder: "Endpoint", name: "endpoint", "data-vv-as": "endpoint" }, model: { value: _vm.model.endpoint, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "endpoint", $$v);
  }, "callback"), expression: "model.endpoint" } }), _vm._v(" "), _vm.errors.has("endpoint") ? _c("span", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("endpoint")))]) : _c("span", { staticClass: "text-muted" }, [_vm._v("The endpoint url for Azure AI Language instance")])], 1), _vm._v(" "), _c("private-input", { attrs: { label: "Api Key", "input-name": "apiKey", "help-text": "Api key to the endpoint. This field supports usage of the password store" }, model: { value: _vm.model.apiKey, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.model, "apiKey", $$v);
  }, "callback"), expression: "model.apiKey" } })], 1)], 1);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  AzureAiLanguageExternalConnectionConfiguration,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  null
);
const AzureAiLanguage = __component__$4.exports, options = [
  {
    id: "ExternalConnection.AzureStorage",
    icon: "database",
    component: azureStorage,
    name: "Azure Storage",
    factory: /* @__PURE__ */ __name(() => ({
      id: v4(),
      type: "ExternalConnection.AzureStorage",
      authenticationType: null
    }), "factory")
  },
  {
    id: "ExternalConnection.AzureFormRecognizer",
    icon: "clouds",
    component: azureFormRecognizer,
    name: "Azure Document Intelligence",
    factory: /* @__PURE__ */ __name(() => ({
      id: v4(),
      type: "ExternalConnection.AzureFormRecognizer"
    }), "factory")
  },
  {
    id: "ExternalConnection.MicrosoftGraph",
    icon: "chart-simple",
    component: microsoftGraph,
    name: "Microsoft Graph (Mailbox)",
    factory: /* @__PURE__ */ __name(() => ({
      id: v4(),
      type: "ExternalConnection.MicrosoftGraph",
      authenticationType: null,
      grantType: null,
      allowSharedMailbox: !1
    }), "factory")
  },
  {
    id: "ExternalConnection.AzureOpenAI",
    icon: "microchip-ai",
    component: azureOpenAI,
    name: "Azure OpenAI",
    factory: /* @__PURE__ */ __name(() => ({
      id: v4(),
      type: "ExternalConnection.AzureOpenAI"
    }), "factory")
  },
  {
    id: "ExternalConnection.Presidio",
    icon: "presentation-screen",
    component: presidio,
    name: "Presidio",
    factory: /* @__PURE__ */ __name(() => ({
      id: v4(),
      type: "ExternalConnection.Presidio"
    }), "factory")
  },
  {
    id: "ExternalConnection.AzureAiLanguage",
    icon: "language",
    component: AzureAiLanguage,
    name: "Azure AI Language",
    factory: /* @__PURE__ */ __name(() => ({
      id: v4(),
      type: "ExternalConnection.AzureAiLanguage"
    }), "factory")
  }
], options$1 = options.sort(function(a, b) {
  return a.name.localeCompare(b.name);
});
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$3"), _a21;
let ExternalConnectionUsageModal$1 = (_a21 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "item");
    __publicField(this, "loading", !1);
    __publicField(this, "externalConnectionUsageResponse", null);
  }
  async loadConnectionUsage() {
    this.externalConnectionUsageResponse = null, this.loading = !0;
    try {
      this.externalConnectionUsageResponse = await new AdministrationConnectionsClient(new Transformer(), baseUrl()).getExternalConnectionUsage(this.item.id);
    } catch {
    } finally {
      this.loading = !1;
    }
  }
}, __name(_a21, "ExternalConnectionUsageModal"), _a21);
__decorateClass$3([
  Prop({
    required: !0
  })
], ExternalConnectionUsageModal$1.prototype, "item", 2);
ExternalConnectionUsageModal$1 = __decorateClass$3([
  Component({
    components: {}
  })
], ExternalConnectionUsageModal$1);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "external-connection-usage-modal" }, on: { shown: _vm.loadConnectionUsage }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h4", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "clipboard-list" } }), _vm._v(` External Connection Usage
            `)], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
                Ok
            `)])];
  }, "fn") }]) }, [_vm._v(" "), _vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", { staticStyle: { height: "75vh" } }, [_vm.externalConnectionUsageResponse && _vm.externalConnectionUsageResponse.externalConnectionUses.length ? _c("b-table", { attrs: { striped: "", hover: "", "sticky-header": "100%", items: _vm.externalConnectionUsageResponse.externalConnectionUses } }) : _c("div", [_c("p", [_vm._v("Not currently in use")])])], 1)]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  ExternalConnectionUsageModal$1,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const ExternalConnectionUsageModal = __component__$3.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$2"), _a22;
let ExternalConnectionEditorComponent = (_a22 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "testing");
    __publicField(this, "saving", !1);
  }
  showUsage() {
    this.$bvModal.show("external-connection-usage-modal");
  }
  get componentEditor() {
    var _a25;
    return this.value ? (_a25 = options$1.find((o) => o.id == this.value.type)) == null ? void 0 : _a25.component : null;
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get builtIn() {
    return this.value.type == "ExternalConnection.AzureStorageBuiltIn" || this.value.type == "ExternalConnection.AzureFormRecognizerBuiltIn" || this.value.type == "ExternalConnection.AzureOpenAIBuiltIn";
  }
  testConnection() {
    this.$emit("testConnection");
  }
  remove() {
    $("#deleteExternalConnectionModal").modal("show");
  }
  removeContinue() {
    $("#deleteExternalConnectionModal").modal("hide"), this.$emit("remove", this.model);
  }
  save(value) {
    this.$emit("save", value);
  }
  async cancel() {
    this.$emit("cancel");
  }
  get name() {
    return this.model.name;
  }
  set name(value) {
    this.model = { ...this.model, name: value };
  }
  get description() {
    return this.model.description;
  }
  set description(value) {
    this.model = { ...this.model, description: value };
  }
  get canSave() {
    return !this.$validator.errors.any();
  }
}, __name(_a22, "ExternalConnectionEditorComponent"), _a22);
__decorateClass$2([
  Prop({ required: !0 })
], ExternalConnectionEditorComponent.prototype, "value", 2);
__decorateClass$2([
  Prop({ required: !0 })
], ExternalConnectionEditorComponent.prototype, "testing", 2);
ExternalConnectionEditorComponent = __decorateClass$2([
  Component({ components: { ExternalConnectionUsageModal }, inject: ["$validator"] })
], ExternalConnectionEditorComponent);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v(_vm._s(_vm.name) + `
      `), _vm.name ? _vm._e() : _c("span", { staticClass: "text-muted" }, [_vm._v("Unnamed entry")]), _vm._v(" "), _vm.model.id ? _vm._e() : [_c("small", { staticClass: "text-muted" }, [_vm._v("(New external connection)")])], _vm._v(" "), _vm.model && !_vm.builtIn ? _c("button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-danger float-right", attrs: { disabled: _vm.model.uses > 0, title: _vm.model.uses ? "Connection in use" : "Delete External Connection" }, on: { click: _vm.remove } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
        `)], 1) : _vm._e()], 2), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.name, expression: "name" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("name"), disabled: _vm.saving }, attrs: { name: "name", readonly: _vm.builtIn, disabled: _vm.saving }, domProps: { value: _vm.name }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.name = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("name")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Name for the external connection")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("description") } }, [_c("label", [_vm._v("Description")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.description, expression: "description" }], staticClass: "form-control", attrs: { readonly: _vm.builtIn, name: "description" }, domProps: { value: _vm.description }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.description = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Short description for the external connection")])]), _vm._v(" "), _vm.componentEditor ? _c(_vm.componentEditor, { tag: "component", on: { save: _vm.save }, model: { value: _vm.value, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.value = $$v;
  }, "callback"), expression: "value" } }) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group mt-2" }, [_vm.builtIn ? _vm._e() : _c("button", { staticClass: "btn btn-success", attrs: { disabled: !_vm.canSave || _vm.saving }, on: { click: _vm.save } }, [_c("font-awesome-icon", { attrs: { icon: _vm.saving ? "sync" : "save", spin: _vm.saving } }), _vm._v(` Save
        `)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default", attrs: { disabled: _vm.saving }, on: { click: _vm.cancel } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Cancel
        `)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-primary float-right", attrs: { disabled: _vm.saving || _vm.testing }, on: { click: _vm.testConnection } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.testing, expression: "!testing" }] }, [_c("font-awesome-icon", { attrs: { icon: "vial" } }), _vm._v(" Test")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.testing, expression: "testing" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Testing...")], 1)]), _vm._v(" "), _vm.model.id ? _c("button", { staticClass: "btn btn-info float-right mr-1", attrs: { disabled: _vm.saving || !_vm.model.uses }, on: { click: _vm.showUsage } }, [_c("font-awesome-icon", { attrs: { icon: "clipboard-list" } }), _vm._v(` View Usage
        `)], 1) : _vm._e()]), _vm._v(" "), _c("external-connection-usage-modal", { attrs: { item: _vm.model } }), _vm._v(" "), _c("div", { staticClass: "modal fade", attrs: { id: "deleteExternalConnectionModal", tabindex: "-1", role: "dialog", "aria-labelledby": "deleteExternalConnectionModal", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete External Connection?
                    `)], 1), _vm._v(" "), _vm._m(0)]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(` 
                            Are you sure you want to delete this external connection?
                `)], 1), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", "data-dismiss": "modal" } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-danger", attrs: { type: "button" }, on: { click: _vm.removeContinue } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` 
                        Delete
                    `)], 1)])])])])], 1);
}, "render"), _sfc_staticRenderFns$2 = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}], __component__$2 = /* @__PURE__ */ normalizeComponent(
  ExternalConnectionEditorComponent,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "830bdcbc"
);
const ExternalConnectionEditor = __component__$2.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a23;
let ExternalConnectionManager$1 = (_a23 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "saving", !1);
    __publicField(this, "loadExternalConnections");
    __publicField(this, "editExternalConnections");
    __publicField(this, "removeExternalConnections");
    __publicField(this, "saveExternalConnections");
    __publicField(this, "cancelEdit");
    __publicField(this, "externalConnectionGetter");
    __publicField(this, "updateEditing");
    __publicField(this, "getEditing");
    __publicField(this, "createExternalConnection");
    __publicField(this, "testExternalConnection");
    __publicField(this, "getTesting");
    __publicField(this, "selectedItem");
  }
  mounted() {
    this.load();
  }
  get connectionOptions() {
    return options$1;
  }
  async addExternalConnection(id) {
    let newConnection = options$1.find((o) => o.id === id).factory();
    this.createExternalConnection(newConnection);
  }
  async editExternalConnection(Id) {
    await this.editExternalConnections(Id);
  }
  async removeExternalConnection(externalConnection) {
    try {
      if (externalConnection.uses) {
        toastr.warning("Unable to delete a connection which is in use!");
        return;
      }
      await this.removeExternalConnections(externalConnection.id), await this.load(), this.editing = null, toastr.success("External Connection deleted");
    } catch (e) {
      toastr.error(e, "Failed to remove external connection");
    }
  }
  get externalConnections() {
    return this.externalConnectionGetter;
  }
  get editing() {
    return this.getEditing;
  }
  set editing(value) {
    this.updateEditing(value);
  }
  get editingId() {
    return this.editing ? this.editing.id : null;
  }
  async load() {
    this.loading = !0, this.loadingError = null;
    try {
      await this.loadExternalConnections();
    } catch (e) {
      toastr.error(e, "Failed to load external connections"), this.loadingError = e;
    } finally {
      this.loading = !1;
    }
    this.selectedItem && (await this.selectItem(this.selectedItem, !0), this.selectedItem = null);
  }
  async selectItem(id, isEdit) {
    await this.$nextTick();
    var editItem = document.getElementById(id);
    editItem != null && editItem.scrollIntoView({ behavior: "smooth" }), isEdit && editItem != null && (this.editing = this.externalConnections.find((y) => y.id == id));
  }
  getBuiltInTitle(connection) {
    switch (connection.type) {
      case "ExternalConnection.AzureFormRecognizerBuiltIn":
        return "Built-in Azure Document Intelligence";
      case "ExternalConnection.AzureStorageBuiltIn":
        return "Built-in Azure Storage";
      case "ExternalConnection.AzureOpenAIBuiltIn":
        return "Built-in Azure OpenAI";
    }
  }
  getBuiltInIcon(connection) {
    switch (connection.type) {
      case "ExternalConnection.AzureFormRecognizerBuiltIn":
        return "clouds";
      case "ExternalConnection.AzureStorageBuiltIn":
        return "database";
      case "ExternalConnection.AzureOpenAIBuiltIn":
        return "microchip-ai";
    }
  }
  async validate() {
    let validators = this.$children.map((child) => child.$validator);
    return await Promise.all(validators.map((validator) => validator.validateAll())).then((result) => result.every((valid) => valid));
  }
  async save() {
    var isValid = await this.validate();
    if (!isValid) {
      toastr.error("Could not save, some values are missing.");
      return;
    }
    this.saving = !0;
    var result = null;
    try {
      result = this.saveExternalConnections(), toastr.success("Saved external connection successfully");
    } catch (e) {
      toastr.error(e, "Failed to save external connection");
    } finally {
      this.saving = !1;
    }
  }
  async cancel() {
    try {
      await this.cancelEdit();
    } catch (e) {
      toastr.error(e, "Failed to cancel ");
    }
  }
}, __name(_a23, "ExternalConnectionManager"), _a23);
__decorateClass$1([
  Action("administration/connections/externalConnection/actions/load")
], ExternalConnectionManager$1.prototype, "loadExternalConnections", 2);
__decorateClass$1([
  Action("administration/connections/externalConnection/actions/edit")
], ExternalConnectionManager$1.prototype, "editExternalConnections", 2);
__decorateClass$1([
  Action("administration/connections/externalConnection/actions/remove")
], ExternalConnectionManager$1.prototype, "removeExternalConnections", 2);
__decorateClass$1([
  Action("administration/connections/externalConnection/actions/save")
], ExternalConnectionManager$1.prototype, "saveExternalConnections", 2);
__decorateClass$1([
  Action("administration/connections/externalConnection/actions/cancel")
], ExternalConnectionManager$1.prototype, "cancelEdit", 2);
__decorateClass$1([
  Getter("administration/connections/externalConnection/getters/externalConnections")
], ExternalConnectionManager$1.prototype, "externalConnectionGetter", 2);
__decorateClass$1([
  Action("administration/connections/externalConnection/actions/updateEditing")
], ExternalConnectionManager$1.prototype, "updateEditing", 2);
__decorateClass$1([
  Getter("administration/connections/externalConnection/getters/editing")
], ExternalConnectionManager$1.prototype, "getEditing", 2);
__decorateClass$1([
  Action("administration/connections/externalConnection/actions/create")
], ExternalConnectionManager$1.prototype, "createExternalConnection", 2);
__decorateClass$1([
  Action("administration/connections/externalConnection/actions/testConnection")
], ExternalConnectionManager$1.prototype, "testExternalConnection", 2);
__decorateClass$1([
  Getter("administration/connections/externalConnection/getters/testing")
], ExternalConnectionManager$1.prototype, "getTesting", 2);
__decorateClass$1([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], ExternalConnectionManager$1.prototype, "selectedItem", 2);
ExternalConnectionManager$1 = __decorateClass$1([
  Component({
    components: {
      ExternalConnectionEditor
    }
  })
], ExternalConnectionManager$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-6" }, [_c("h3", [_c("font-awesome-icon", { attrs: { icon: "arrow-up-right-from-square" } }), _vm._v(`
            External Connections
             `), _c("b-dropdown", { staticClass: "m-md-2", attrs: { "no-flip": "", variant: "outline-primary", size: "sm" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add
                `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _vm._l(_vm.connectionOptions, function(option) {
    return _c("b-dropdown-item", { key: option.id, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.addExternalConnection(option.id);
    }, "click") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: option.icon } }), _vm._v(" " + _vm._s(option.name) + `
                `)], 1);
  })], 2)], 1), _vm._v(" "), _vm.externalConnections && _vm.externalConnections.length ? _c("div", { staticStyle: { "overflow-y": "scroll", height: "65vh" } }, _vm._l(_vm.externalConnections, function(connection) {
    return _c("div", { key: connection.id, staticClass: "list-group-item list-group-item-action", class: { active: connection.id === _vm.editingId }, attrs: { id: connection.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editExternalConnection(connection.id);
    }, "click") } }, [_c("h4", { staticClass: "list-group-item-heading" }, [_vm.connectionOptions.find((y) => y.id == connection.type) ? _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: _vm.connectionOptions.find((y) => y.id == connection.type).name } }, [_vm.connectionOptions.find((y) => y.id == connection.type) ? _c("font-awesome-icon", { staticClass: "fa-sm", attrs: { icon: _vm.connectionOptions.find((y) => y.id == connection.type).icon } }) : _vm._e()], 1) : _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: _vm.getBuiltInTitle(connection) } }, [_c("font-awesome-icon", { staticClass: "fa-sm", attrs: { icon: _vm.getBuiltInIcon(connection), title: _vm.getBuiltInTitle(connection) } })], 1), _vm._v(" "), connection.name ? [_vm._v(`
                        ` + _vm._s(connection.name) + `
                    `)] : _vm._e(), _vm._v(" "), connection.uses ? [_c("span", { staticClass: "badge badge-info badge-pill", staticStyle: { "font-size": "small" } }, [_vm._v(`
                          Uses: ` + _vm._s(connection.uses) + `
                      `)])] : _vm._e(), _vm._v(" "), _c("span", { staticClass: "float-right" }, [connection.id === _vm.editingId ? _c("font-awesome-icon", { attrs: { icon: "arrow-right" } }) : _vm._e()], 1)], 2), _vm._v(" "), connection.description ? _c("span", { staticClass: "list-group-item-text" }, [_vm._v(_vm._s(connection.description) + " "), _c("br")]) : _vm._e()]);
  }), 0) : _c("div", { staticClass: "alert alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
          No external connections are currently configured
        `)], 1)]), _vm._v(" "), _vm.editing ? _c("div", { staticClass: "col-md-6" }, [_c("external-connection-editor", { attrs: { testing: _vm.getTesting }, on: { save: _vm.save, cancel: _vm.cancel, remove: _vm.removeExternalConnection, testConnection: _vm.testExternalConnection }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } })], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  ExternalConnectionManager$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const ExternalConnectionManager = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a24;
let AdministrationConnectionsComponent = (_a24 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "selectedTab");
    __publicField(this, "selectedItem");
    __publicField(this, "tab", null);
    __publicField(this, "tabs", [
      {
        id: "dataSource",
        name: "Data Sources",
        icon: "server",
        description: "A list of configured data sources",
        show: !0,
        component: DataSourceManager
      },
      {
        id: "dataQuery",
        name: "Data Queries",
        icon: "search",
        description: "A list of configured data queries",
        show: !0,
        component: DataQueryManager
      },
      {
        id: "passwordStore",
        name: "Password Store",
        icon: "key",
        description: "A list of configured connection passwords",
        show: !0,
        component: PasswordStoreManager
      },
      {
        id: "externalConnection",
        name: "External Connection",
        icon: "arrow-up-right-from-square",
        description: "A list of configured external connections",
        show: !0,
        component: ExternalConnectionManager
      }
    ]);
  }
  get activeTab() {
    if (this.tab)
      return this.tab;
    if (this.selectedTab) {
      var inputTab = this.tabs.find((t) => t.show && t.id == this.selectedTab);
      return inputTab ? inputTab.id : null;
    }
    return (this.tabs.find((t) => t.show) || { id: null }).id;
  }
  selectTab(tabId) {
    this.tabs.find((t) => t.id === tabId && t.show) && (this.tab = tabId);
  }
}, __name(_a24, "AdministrationConnectionsComponent"), _a24);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], AdministrationConnectionsComponent.prototype, "selectedTab", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], AdministrationConnectionsComponent.prototype, "selectedItem", 2);
AdministrationConnectionsComponent = __decorateClass([
  Component({
    components: {
      DataSourceManager,
      DataQueryManager,
      PasswordStoreManager,
      ExternalConnectionManager
    }
  })
], AdministrationConnectionsComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "database" } }), _vm._v(" Connections Management")], 1)]), _vm._v(" "), _c("div", [_c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs", attrs: { id: "myTab", role: "tablist" } }, _vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item" }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab === tab.id }, attrs: { id: tab.id + "tab", "data-toggle": "tab", role: "tab", "aria-selected": "true" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(" " + _vm._s(tab.name) + `
                    `)], 1)]);
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_c("div", { staticClass: "container-fluid" }, [_vm.activeTab === "dataSource" ? _c("data-source-manager", { key: "dataSourceTab", attrs: { "selected-item": _vm.selectedItem } }) : _vm._e(), _vm._v(" "), _vm.activeTab === "dataQuery" ? _c("data-query-manager", { key: "dataQueryTab", attrs: { "selected-item": _vm.selectedItem } }) : _vm._e(), _vm._v(" "), _vm.activeTab === "passwordStore" ? _c("password-store-manager", { key: "passwordStoreTab" }) : _vm._e(), _vm._v(" "), _vm.activeTab === "externalConnection" ? _c("external-connection-manager", { key: "externalConnectionTab", attrs: { "selected-item": _vm.selectedItem } }) : _vm._e()], 1)])])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationConnectionsComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  null
);
const index = __component__.exports;
export {
  index as default
};
