var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, M as Moment, V as Vue, a0 as userHasPermission, aa as AdministrationLocalUsersClient, T as Transformer, b as baseUrl, t as toastr, n as normalizeComponent, a2 as AdministrationAuthenticationClient, Z as promisify, W as Watch, L as LoadingBarComponent, c as Action, G as Getter, ab as UserSelectorModal, ac as AdministrationProfilesClient, _, v as vSelect, ad as AdministrationAdminUsersClient, B as VeeValidate$1, g as v4, ae as csv, af as AdministrationGroupsClient, ag as AuthenticationProviders } from "./main-DAVWuHbi.js";
import { P as PasswordComplexityRules } from "./passwordComplexityRules-BxrFfrmN.js";
import { b as bytesToSize } from "./fileSizeHelpers-DezEXWHc.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { U as UserNotificationModal, a as UserNotificationsTable } from "./userNotificationsEditModal-D8atBGD_.js";
import { D as DelegateTable } from "./delegateTable-3WUW9BCG.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
import { P as PermissionEditor, c as checkProviderQuery, q as queryAuthorisation } from "./permissionEditor-CEAGzDpF.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
import { V as VModel } from "./VModel-D6nuZPuz.js";
import { C as CopyValueButton } from "./copyValueButton-gP03Zkkc.js";
import { N as NoAccessAlert } from "./noAccessAlert-B1NMGa_u.js";
var __defProp$j = Object.defineProperty, __getOwnPropDesc$o = Object.getOwnPropertyDescriptor, __decorateClass$o = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$o(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$j(target, key, result), result;
}, "__decorateClass$o"), _a;
let LocalUsersListComponent$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "enforcePasswordComplexity");
    __publicField(this, "loading", !1);
    __publicField(this, "editingLocalUser", { userName: "", emailAddress: "", password: "" });
    __publicField(this, "originalEditingLocalUsername", null);
    __publicField(this, "editingUser", !1);
    __publicField(this, "deletingLocalUsername", null);
    __publicField(this, "deletingLocalUser", { userName: "", emailAddress: "", password: "" });
    __publicField(this, "enforcedPasswords", !1);
    __publicField(this, "hasWritePermission", !1);
    __publicField(this, "hasDeletePermission", !1);
  }
  async mounted() {
    this.hasWritePermission = await userHasPermission("users.localUsers.write"), this.hasDeletePermission = await userHasPermission("users.localUsers.delete");
  }
  showEditingModal(user) {
    $("#editingUserModal").modal("show"), this.editingLocalUser = user, this.originalEditingLocalUsername = user.userName, this.creatingUser = !1, this.editingUser = !0;
  }
  showDeletingModal(user) {
    $("#deleteUserModal").modal("show"), this.deletingLocalUsername = user.userName, this.deletingLocalUser = user;
  }
  updateUser() {
    this.$validator.validateAll("editForm").then((valid) => {
      valid ? (this.loading = !0, new AdministrationLocalUsersClient(new Transformer(), baseUrl()).updateLocalUser(this.editingLocalUser, this.originalEditingLocalUsername).then((model) => {
        $("#editingUserModal").modal("hide"), toastr.success(this.originalEditingLocalUsername + " has been successfully updated"), this.originalEditingLocalUsername = null, this.editingLocalUser = { userName: "", emailAddress: "", password: "" };
      }).catch((e) => {
        toastr.error("Could not update user: " + JSON.parse(e.response).message);
      }).finally(() => {
        this.loading = !1;
      })) : toastr.error("User could not update user. Some fields are required");
    });
  }
  deleteUser() {
    this.loading = !0, new AdministrationLocalUsersClient(new Transformer(), baseUrl()).deleteLocalUser(this.deletingLocalUsername).then((model) => {
      $("#deleteUserModal").modal("hide"), toastr.info(this.deletingLocalUsername + " has been successfully deleted"), this.users.splice($.inArray(this.deletingLocalUser, this.users), 1), this.deletingLocalUsername = null, this.deletingLocalUser = null;
    }).catch((e) => {
      toastr.error("Could not delete user: " + e);
    }).finally(() => {
      this.loading = !1;
    });
  }
  get users() {
    return this.value;
  }
  set users(value) {
    this.$emit("input", value);
  }
}, __name(_a, "LocalUsersListComponent"), _a);
__decorateClass$o([
  Prop({
    required: !0
  })
], LocalUsersListComponent$1.prototype, "value", 2);
__decorateClass$o([
  Prop({
    required: !0
  })
], LocalUsersListComponent$1.prototype, "enforcePasswordComplexity", 2);
LocalUsersListComponent$1 = __decorateClass$o([
  Component({
    components: { PasswordComplexityRules },
    filters: {
      moment: /* @__PURE__ */ __name((input) => Moment(input).fromNow(), "moment"),
      humanizeSize: /* @__PURE__ */ __name((input) => bytesToSize(input), "humanizeSize")
    }
  })
], LocalUsersListComponent$1);
var _sfc_render$o = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_vm.users && _vm.users.length > 0 ? _c("div", { staticClass: "col-sm-12 table-responsive" }, [_c("table", { staticClass: "table table-striped" }, [_vm._m(0), _vm._v(" "), _c("tbody", _vm._l(_vm.users, function(user) {
    return _c("tr", { key: user.userName }, [_c("td", { staticClass: "align-middle" }, [_vm._v(_vm._s(user.userName))]), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_vm._v(_vm._s(user.displayName))]), _vm._v(" "), _c("td", { staticClass: "align-middle" }, [_vm._v(_vm._s(user.emailAddress))]), _vm._v(" "), _c("td", { staticClass: "float-right" }, [_c("div", { staticClass: "float-right" }, [_vm.hasWritePermission ? _c("button", { staticClass: "btn btn-primary btn-sm", on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showEditingModal(user);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(` Edit
                                `)], 1) : _vm._e(), _vm._v(" "), _vm.hasDeletePermission ? _c("button", { staticClass: "btn btn-danger btn-sm", attrs: { "data-delete-confirm": "true", id: "delete-" + user.userName }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showDeletingModal(user);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1) : _vm._e()])])]);
  }), 0)])]) : _c("div", { staticClass: "ml-3 alert alert-primary", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` There are no local users currently in the list. Use the add button above to create one.
        `)], 1), _vm._v(" "), _c("div", { staticClass: "modal fade", attrs: { "data-backdrop": "static", id: "editingUserModal", tabindex: "-1", role: "dialog", "aria-labelledby": "editingUserModal", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title", attrs: { id: "editUserLabel" } }, [_c("font-awesome-icon", { attrs: { icon: "user-edit" } }), _vm._v(" Edit " + _vm._s(_vm.originalEditingLocalUsername))], 1), _vm._v(" "), _vm._m(1)]), _vm._v(" "), _c("form", { attrs: { "data-vv-scope": "editForm" }, on: { submit: /* @__PURE__ */ __name(function($event) {
    return $event.preventDefault(), _vm.updateUser();
  }, "submit") } }, [_c("div", { staticClass: "modal-body" }, [_c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "editUsernameInput" } }, [_vm._v(`
                                  Username
                                  `), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: "You cannot edit the username, if this is wrong you will need to create a new users with the correct username and delete this one." } }, [_c("font-awesome-icon", { staticClass: "text-primary", attrs: { icon: "question-circle" } })], 1)]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.editingLocalUser.userName, expression: "editingLocalUser.userName" }], staticClass: "form-control", attrs: { type: "text", id: "editUsernameInput", "aria-describedby": "usernameHelp", disabled: "", name: "editUsernameInput" }, domProps: { value: _vm.editingLocalUser.userName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.editingLocalUser, "userName", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "editUsernameInputHelp" } }, [_vm._v("The username is the unique identifier for the user. This does not need to be their email address.")]), _vm._v(" "), _vm.errors.first("editForm.editUsernameInput") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a username.")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "usernameInput" } }, [_vm._v("Display Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.editingLocalUser.displayName, expression: "editingLocalUser.displayName" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("createForm.displayNameInput") }, attrs: { type: "text", id: "displayNameInput", "aria-describedby": "displayNameHelp", name: "displayNameInput" }, domProps: { value: _vm.editingLocalUser.displayName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.editingLocalUser, "displayName", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "displayNameHelp" } }, [_vm._v("The display name for the user. ")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "editEmailAddressInput" } }, [_vm._v("Email Address")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.editingLocalUser.emailAddress, expression: "editingLocalUser.emailAddress" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("editForm.editEmailAddressInput") }, attrs: { type: "text", id: "editEmailAddressInput", "aria-describedby": "emailAddressHelp", name: "editEmailAddressInput" }, domProps: { value: _vm.editingLocalUser.emailAddress }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.editingLocalUser, "emailAddress", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "editEmailAddressInputHelp" } }, [_vm._v("An email address that will be used for notifications.")]), _vm._v(" "), _vm.errors.first("editForm.editEmailAddressInput") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter an email address.")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "editPasswordInput" } }, [_vm._v("Password")]), _vm._v(" "), _c("div", { staticClass: "alert alert-primary", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "user-shield" } }), _vm._v(` Leave this blank to keep the current password.
                                `)], 1), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.editingLocalUser.password, expression: "editingLocalUser.password" }], staticClass: "form-control", attrs: { type: "password", id: "editPasswordInput", "aria-describedby": "passwordHelp" }, domProps: { value: _vm.editingLocalUser.password }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.editingLocalUser, "password", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "editPasswordInputHelp" } }, [_vm._v(`The password the user will enter to login.
                                    `), _vm.enforcedPasswords ? _c("span", [_c("password-complexity-rules")], 1) : _vm._e()])])]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", "data-dismiss": "modal" } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", class: { disabled: _vm.loading }, attrs: { type: "button", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.updateUser();
  }, "click") } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.loading, expression: "!loading" }] }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.loading, expression: "loading" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Saving")], 1)])])])])])]), _vm._v(" "), _c("div", { staticClass: "modal fade", attrs: { "data-backdrop": "static", id: "deleteUserModal", tabindex: "-1", role: "dialog", "aria-labelledby": "deleteUserModal", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title", attrs: { id: "deleteUserLabel" } }, [_c("font-awesome-icon", { attrs: { icon: "user-times" } }), _vm._v(" Delete " + _vm._s(_vm.deletingLocalUsername))], 1), _vm._v(" "), _vm._m(2)]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("p", [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" Are you sure you want to delete " + _vm._s(_vm.deletingLocalUsername) + `? You will not be able to reverse this.
                        `)], 1)]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", "data-dismiss": "modal" } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-danger", class: { disabled: _vm.loading }, attrs: { type: "button", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.deleteUser();
  }, "click") } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.loading, expression: "!loading" }] }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Delete")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.loading, expression: "loading" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Deleting")], 1)])])])])])]);
}, "render"), _sfc_staticRenderFns$o = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("thead", [_c("tr", [_c("th", { staticClass: "text-nowrap", attrs: { scope: "col" } }, [_vm._v("Id")]), _vm._v(" "), _c("th", { staticClass: "text-nowrap", attrs: { scope: "col" } }, [_vm._v("Display Name")]), _vm._v(" "), _c("th", { staticClass: "text-nowrap", attrs: { scope: "col" } }, [_vm._v("Email Address")]), _vm._v(" "), _c("th", { attrs: { scope: "col float-right" } }, [_vm._v(" ")])])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}], __component__$o = /* @__PURE__ */ normalizeComponent(
  LocalUsersListComponent$1,
  _sfc_render$o,
  _sfc_staticRenderFns$o,
  !1,
  null,
  "8af61a6e"
);
const LocalUsersListComponent = __component__$o.exports;
var __defProp$i = Object.defineProperty, __getOwnPropDesc$n = Object.getOwnPropertyDescriptor, __decorateClass$n = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$n(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$i(target, key, result), result;
}, "__decorateClass$n"), _a2;
let AdministrationLocalUsersComponent$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "pageValue", 1);
    __publicField(this, "pageTotal", 0);
    __publicField(this, "pageSize", 50);
    __publicField(this, "userFilter", "");
    __publicField(this, "loading", !1);
    __publicField(this, "authenticationProvider", null);
    __publicField(this, "localUserResponse", null);
    __publicField(this, "newLocalUser", { userName: "", emailAddress: "", password: "" });
    __publicField(this, "creatingUser", !1);
    __publicField(this, "localUsersCsv", null);
    __publicField(this, "csvCreatedUsers", null);
    __publicField(this, "enforcedPasswords", null);
    __publicField(this, "hasWritePermission", !1);
  }
  async mounted() {
    this.hasWritePermission = await userHasPermission("users.localUsers.write"), this.loading = !0, new AdministrationAuthenticationClient(new Transformer(), baseUrl()).getAuthenticationSettings().then((model) => {
      this.provider = model;
    }).catch((e) => {
      toastr.error("Something has gone wrong while loading the authentication provider: " + e);
    }).finally(() => {
      this.getLocalUsers();
    }), new AdministrationAuthenticationClient(new Transformer(), baseUrl()).getAuthenticationSettings().then((model) => {
      this.enforcePasswordComplexityRules = model.enforcePasswordComplexity;
    });
  }
  pageChanged() {
    this.getLocalUsers();
  }
  filterChanged() {
    this.pageValue = 1, this.getLocalUsers();
  }
  getLocalUsers() {
    let skipValue = this.pageValue * this.pageSize - this.pageSize;
    new AdministrationLocalUsersClient(new Transformer(), baseUrl()).getLocalUsers(skipValue, this.pageSize, this.userFilter).then((model) => {
      this.localUserResponse = model, this.pageTotal = Math.ceil(this.localUserResponse.count / this.pageSize);
    }).catch((e) => {
      toastr.error("Something has gone wrong while loading the user: " + e);
    }).finally(() => {
      this.loading = !1;
    });
  }
  get localUsers() {
    if (this.localUserResponse)
      return this.localUserResponse.localUsers;
  }
  get usersCount() {
    if (this.localUserResponse)
      return this.localUserResponse.count;
  }
  get totalUsersCount() {
    if (this.localUserResponse)
      return this.localUserResponse.totalCount;
  }
  get provider() {
    return this.authenticationProvider;
  }
  set provider(value) {
    this.authenticationProvider = value;
  }
  get enforcePasswordComplexityRules() {
    return this.enforcedPasswords;
  }
  set enforcePasswordComplexityRules(value) {
    this.enforcedPasswords = value;
  }
  createUser() {
    this.$validator.validateAll("createForm").then((valid) => {
      valid ? (this.loading = !0, new AdministrationLocalUsersClient(new Transformer(), baseUrl()).createLocalUser(this.newLocalUser).then((model) => {
        this.getLocalUsers(), this.creatingUser = !1, this.newLocalUser = { userName: "", emailAddress: "", password: "" }, $("#createUserModal").modal("hide"), toastr.success(model.userName + " has been successfully created");
      }).catch((e) => {
        toastr.error("Could not create user: " + JSON.parse(e.response).message);
      }).finally(() => {
        this.loading = !1;
      })) : toastr.error("Could not create user. Some fields are required");
    });
  }
  get numberOfCreatedUsers() {
    return this.csvCreatedUsers.uploadableLocalUsers.filter(function(user) {
      return user.wasCreated === !0;
    }).length;
  }
  get csvCreatedAlertVariant() {
    return this.csvCreatedUsers && this.numberOfCreatedUsers === this.csvCreatedUsers.uploadableLocalUsers.length ? "success" : "warning";
  }
  get uploadFields() {
    return [
      {
        key: "userName",
        sortable: !0
      },
      {
        key: "emailAddress",
        sortable: !0
      },
      {
        key: "displayName",
        sortable: !0
      },
      {
        key: "wasCreated",
        label: "Created",
        sortable: !0
      }
    ];
  }
  async uploadLocalUserFile() {
    this.loading = !0;
    let file = this.localUsersCsv, xhr = new XMLHttpRequest(), formData = new FormData();
    formData.append("file", file), promisify(xhr);
    let url = baseUrl() + "/api/administration/localUsers/upload";
    xhr.open("POST", url);
    try {
      let response = await xhr.send(formData);
      this.loading = !1, this.csvCreatedUsers = JSON.parse(response.response), this.csvCreatedUsers.uploadableLocalUsers.forEach((model) => {
        model.wasCreated && this.localUsers.push(model);
      }), toastr.success("Users CSV uploaded");
    } catch {
      this.loading = !1;
    }
  }
  async downloadTemplateFile() {
    let blob = (await new AdministrationLocalUsersClient(new Transformer(), baseUrl()).downloadTemplateUsersCsvFile()).data, downloadUrl = window.URL.createObjectURL(blob), anchor = document.createElement("a");
    anchor.href = downloadUrl, anchor.download = "BulkUsersTemplate.csv", document.body.appendChild(anchor), anchor.click(), anchor.remove();
  }
  showUploadCsvModal() {
    $("#uploadCsvModal").modal("show"), this.csvCreatedUsers = null, this.localUsersCsv = null;
  }
  onFileChange(e) {
    let files = e.target.files || e.dataTransfer.files;
    if (files.length)
      this.localUsersCsv = files[0], this.uploadLocalUserFile();
    else
      return;
  }
  showCreatingModal() {
    $("#createUserModal").modal("show"), this.creatingUser = !0;
  }
}, __name(_a2, "AdministrationLocalUsersComponent"), _a2);
__decorateClass$n([
  Watch("pageValue")
], AdministrationLocalUsersComponent$1.prototype, "pageChanged", 1);
__decorateClass$n([
  Watch("userFilter")
], AdministrationLocalUsersComponent$1.prototype, "filterChanged", 1);
AdministrationLocalUsersComponent$1 = __decorateClass$n([
  Component({
    components: { PaginationControls, LocalUsersListComponent, LoadingBar: LoadingBarComponent }
  })
], AdministrationLocalUsersComponent$1);
var _sfc_render$n = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("h3", [_c("font-awesome-icon", { attrs: { icon: "users" } }), _vm._v(" Local Users "), _c("b-badge", { staticClass: "small", attrs: { small: "", variant: "info", pill: "" } }, [_vm._v(_vm._s(_vm.totalUsersCount))]), _vm._v(" "), _vm.hasWritePermission ? _c("button", { staticClass: "btn btn-primary btn-sm", attrs: { id: "addUser" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.showCreatingModal();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(" Add User")], 1) : _vm._e(), _vm._v(" "), _vm.hasWritePermission ? _c("span", { staticClass: "float-right" }, [_c("button", { staticClass: "btn btn-sm btn-primary", on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.showUploadCsvModal();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "upload" } }), _vm._v(" Bulk Upload")], 1)]) : _vm._e()], 1)])]), _vm._v(" "), _vm.provider && _vm.provider.provider !== "localUsers" ? _c("div", { staticClass: "alert alert-primary", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Your EWA instance is not configured to use Local Users. You can select to use local users on the Authentication page.
  `)], 1) : _vm._e(), _vm._v(" "), !_vm.loading && _vm.localUsers ? _c("div", { staticClass: "tab-content" }, [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-6" }, [_c("div", { staticClass: "input-group mb-3" }, [_c("div", { staticClass: "input-group-prepend" }, [_c("span", { staticClass: "input-group-text" }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.userFilter, expression: "userFilter" }], staticClass: "form-control input-sm w-50", attrs: { type: "text", id: "userFilterInput", placeholder: "Filter Users" }, domProps: { value: _vm.userFilter }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.userFilter = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.userFilter.length ? _c("div", { staticClass: "input-group-append" }, [_c("span", { staticClass: "input-group-text" }, [_vm._v(_vm._s(_vm.usersCount))])]) : _vm._e()])]), _vm._v(" "), _c("div", { staticClass: "col-6" }, [_vm.localUsers && _vm.pageTotal > 1 ? _c("pagination-controls", { staticClass: "float-right", attrs: { count: _vm.pageTotal, "justify-content": !1 }, model: { value: _vm.pageValue, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageValue = $$v;
  }, "callback"), expression: "pageValue" } }) : _vm._e()], 1)]), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("local-users-list-component", { attrs: { value: _vm.localUsers, "enforce-password-complexity": _vm.enforcePasswordComplexityRules }, on: { loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading") } }), _vm._v(" "), _vm.localUsers && _vm.pageTotal > 1 ? _c("pagination-controls", { attrs: { count: _vm.pageTotal }, model: { value: _vm.pageValue, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageValue = $$v;
  }, "callback"), expression: "pageValue" } }) : _vm._e()], 1)])]) : _vm._e(), _vm._v(" "), _vm.loading ? _c("div", { staticClass: "col-sm-12" }, [_c("loading-bar")], 1) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "modal fade", attrs: { id: "createUserModal", tabindex: "-1", role: "dialog", "aria-labelledby": "createUserLabel", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_vm._m(0), _vm._v(" "), _c("form", { attrs: { "data-vv-scope": "createForm" }, on: { submit: /* @__PURE__ */ __name(function($event) {
    return $event.preventDefault(), _vm.createUser();
  }, "submit") } }, [_c("div", { staticClass: "modal-body" }, [_c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "usernameInput" } }, [_vm._v("Username")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.newLocalUser.userName, expression: "newLocalUser.userName" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("createForm.usernameInput") }, attrs: { type: "text", id: "usernameInput", "aria-describedby": "usernameHelp", name: "usernameInput" }, domProps: { value: _vm.newLocalUser.userName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.newLocalUser, "userName", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "usernameHelp" } }, [_vm._v("The username is the unique identifier for the user. This does not need to be their email address.")]), _vm._v(" "), _vm.errors.first("createForm.usernameInput") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a username")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "usernameInput" } }, [_vm._v("Display Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.newLocalUser.displayName, expression: "newLocalUser.displayName" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("createForm.displayNameInput") }, attrs: { type: "text", id: "displayNameInput", "aria-describedby": "displayNameHelp", name: "displayNameInput" }, domProps: { value: _vm.newLocalUser.displayName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.newLocalUser, "displayName", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "displayNameHelp" } }, [_vm._v("The display name for the user. ")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "emailAddressInput" } }, [_vm._v("Email Address")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.newLocalUser.emailAddress, expression: "newLocalUser.emailAddress" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("createForm.emailAddressInput") }, attrs: { type: "text", id: "emailAddressInput", "aria-describedby": "emailAddressHelp", name: "emailAddressInput" }, domProps: { value: _vm.newLocalUser.emailAddress }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.newLocalUser, "emailAddress", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "emailAddressHelp" } }, [_vm._v("An email address that will be used for notifications.")]), _vm._v(" "), _vm.errors.first("createForm.emailAddressInput") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter an email address")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "passwordInput" } }, [_vm._v("Password")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.newLocalUser.password, expression: "newLocalUser.password" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("createForm.passwordInput") }, attrs: { type: "password", id: "passwordInput", "aria-describedby": "passwordHelp", name: "passwordInput" }, domProps: { value: _vm.newLocalUser.password }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.newLocalUser, "password", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "passwordHelp" } }, [_vm._v(`The password the user will enter to login.
                    `), _vm.enforcePasswordComplexityRules ? _c("span", [_c("password-complexity-rules")], 1) : _vm._e()]), _vm._v(" "), _vm.errors.first("createForm.passwordInput") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a password.")]) : _vm._e()])]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", "data-dismiss": "modal" } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", class: { disabled: _vm.loading }, attrs: { type: "submit", disabled: _vm.loading } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.loading, expression: "!loading" }] }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Create User")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.loading, expression: "loading" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Creating")], 1)])])])])])]), _vm._v(" "), _c("div", { staticClass: "modal fade", attrs: { "data-backdrop": "static", id: "uploadCsvModal", tabindex: "-1", role: "dialog", "aria-labelledby": "uploadCsvModal", "aria-hidden": "true" } }, [_c("div", { staticClass: "modal-dialog modal-lg", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title" }, [_c("font-awesome-icon", { attrs: { icon: "upload" } }), _vm._v(" Bulk Upload Users")], 1), _vm._v(" "), _vm._m(1)]), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [!_vm.localUsersCsv || _vm.csvCreatedUsers && !_vm.csvCreatedUsers.success ? _c("div", [_c("div", { staticClass: "custom-file mb-2" }, [_c("input", { staticClass: "custom-file-input", class: { disabled: _vm.loading }, attrs: { type: "file", id: "customFile", accept: ".csv", disabled: _vm.loading }, on: { change: _vm.onFileChange } }), _vm._v(" "), _c("label", { staticClass: "custom-file-label", attrs: { for: "customFile" } }, [_vm._v("Upload a .csv file to import users")])]), _vm._v(" "), _vm.csvCreatedUsers && !_vm.csvCreatedUsers.success ? _c("div", [_c("b-alert", { attrs: { variant: "danger", show: "", dismissible: "" } }, [_c("font-awesome-icon", { attrs: { icon: "times-circle" } }), _vm._v(" " + _vm._s(_vm.csvCreatedUsers.returnMessage) + `
                `)], 1)], 1) : _vm._e(), _vm._v(" "), _c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" Download the template file below, it has the correct column headings to import the users.")], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "link" }, on: { click: _vm.downloadTemplateFile } }, [_c("font-awesome-icon", { attrs: { icon: "file" } }), _vm._v(" Download template file")], 1)], 1) : _c("div", [_vm.loading ? _c("div", { staticClass: "text-center text-primary my-auto mx-auto" }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v("Loading...")])], 1) : _vm._e(), _vm._v(" "), _vm.csvCreatedUsers ? _c("div", [_vm.csvCreatedUsers.success ? _c("div", [_c("b-alert", { attrs: { variant: _vm.csvCreatedAlertVariant, show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" " + _vm._s(_vm.numberOfCreatedUsers) + "/" + _vm._s(_vm.csvCreatedUsers.uploadableLocalUsers.length) + ` users created.
                  `)], 1), _vm._v(" "), _c("b-table", { attrs: { striped: "", hover: "", "sort-icon-left": !0, "sort-by": "wasCreated", fields: _vm.uploadFields, items: _vm.csvCreatedUsers.uploadableLocalUsers }, scopedSlots: _vm._u([{ key: "cell(wasCreated)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.value ? _c("span", { staticClass: "text-success" }, [_c("font-awesome-icon", { attrs: { icon: "check-circle" } }), _vm._v(" User created")], 1) : _c("span", { staticClass: "text-danger" }, [_c("font-awesome-icon", { attrs: { icon: "times-circle" } }), _vm._v(" " + _vm._s(data.item.returnMessage))], 1)];
  }, "fn") }], null, !1, 1005870257) })], 1) : _vm._e()]) : _vm._e()])]), _vm._v(" "), _vm._m(2)])])])]);
}, "render"), _sfc_staticRenderFns$n = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal-header" }, [_c("h5", { staticClass: "modal-title", attrs: { id: "createUserLabel" } }, [_vm._v("Create New User")]), _vm._v(" "), _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "close", attrs: { type: "button", "data-dismiss": "modal", "aria-label": "Close" } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", "data-dismiss": "modal" } }, [_vm._v("Close")])]);
}], __component__$n = /* @__PURE__ */ normalizeComponent(
  AdministrationLocalUsersComponent$1,
  _sfc_render$n,
  _sfc_staticRenderFns$n,
  !1,
  null,
  "9d887f66"
);
const AdministrationLocalUsersComponent = __component__$n.exports;
var __defProp$h = Object.defineProperty, __getOwnPropDesc$m = Object.getOwnPropertyDescriptor, __decorateClass$m = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$m(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$h(target, key, result), result;
}, "__decorateClass$m"), _a3;
let AdministrationProfilesDeleteProfileComponent = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "deleteProfile");
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("delete-profile-modal");
  }
  get modalTitle() {
    var _a26;
    return "Delete " + ((_a26 = this.deleteProfile) == null ? void 0 : _a26.name) + "'s profile?";
  }
}, __name(_a3, "AdministrationProfilesDeleteProfileComponent"), _a3);
__decorateClass$m([
  Prop({ required: !0 })
], AdministrationProfilesDeleteProfileComponent.prototype, "deleteProfile", 2);
AdministrationProfilesDeleteProfileComponent = __decorateClass$m([
  Component({})
], AdministrationProfilesDeleteProfileComponent);
var _sfc_render$m = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "delete-profile-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return cancel();
    }, "click") } }, [_vm._v(`
      Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.confirm();
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
    `)], 1)];
  }, "fn") }]) }, [_vm.deleteProfile ? _c("div", [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" Are you sure you want to delete " + _vm._s(_vm.deleteProfile.name) + `'s profile? 
          The profile will be recreated the next time the user logs into EWA.
      `)], 1)], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$m = [], __component__$m = /* @__PURE__ */ normalizeComponent(
  AdministrationProfilesDeleteProfileComponent,
  _sfc_render$m,
  _sfc_staticRenderFns$m,
  !1,
  null,
  null
);
const deleteProfileModal = __component__$m.exports;
var __defProp$g = Object.defineProperty, __getOwnPropDesc$l = Object.getOwnPropertyDescriptor, __decorateClass$l = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$l(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$g(target, key, result), result;
}, "__decorateClass$l"), _a4;
let AdministrationProfilesEditProfileNotificationsComponent = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "profile");
    __publicField(this, "addNotificationConfiguration");
    __publicField(this, "setUserId");
    __publicField(this, "refresh");
    __publicField(this, "notifications");
  }
  userIdChanged(newProfile) {
    newProfile && (this.setUserId(newProfile.identityId), this.refresh());
  }
  mounted() {
    this.userIdChanged(this.profile);
  }
  addNotification() {
    this.addNotificationConfiguration(), this.$root.$emit("bv::show::modal", "notificationsModal");
  }
  closeModal() {
    this.$emit("updatedNotifications", this.notifications), this.$bvModal.hide("edit-notifications-profile-modal");
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("edit-notifications-profile-modal");
  }
  get modalTitle() {
    var _a26;
    return ((_a26 = this.profile) == null ? void 0 : _a26.name) + "'s Notification Settings";
  }
}, __name(_a4, "AdministrationProfilesEditProfileNotificationsComponent"), _a4);
__decorateClass$l([
  Prop({ required: !0 })
], AdministrationProfilesEditProfileNotificationsComponent.prototype, "profile", 2);
__decorateClass$l([
  Action("account/notifications/action/add")
], AdministrationProfilesEditProfileNotificationsComponent.prototype, "addNotificationConfiguration", 2);
__decorateClass$l([
  Action("account/notifications/action/setUserId")
], AdministrationProfilesEditProfileNotificationsComponent.prototype, "setUserId", 2);
__decorateClass$l([
  Action("account/notifications/action/refresh")
], AdministrationProfilesEditProfileNotificationsComponent.prototype, "refresh", 2);
__decorateClass$l([
  Getter("account/notifications/getters/notifications")
], AdministrationProfilesEditProfileNotificationsComponent.prototype, "notifications", 2);
__decorateClass$l([
  Watch("profile")
], AdministrationProfilesEditProfileNotificationsComponent.prototype, "userIdChanged", 1);
AdministrationProfilesEditProfileNotificationsComponent = __decorateClass$l([
  Component({
    components: { UserNotificationsTable, UserNotificationModal }
  })
], AdministrationProfilesEditProfileNotificationsComponent);
var _sfc_render$l = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "xl", id: "edit-notifications-profile-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "primary" }, on: { click: _vm.addNotification } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add
      `)], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: _vm.closeModal } }, [_vm._v(`
        Close
      `)])];
  }, "fn") }]) }, [_vm.profile ? _c("div", [_c("user-notifications-table", { attrs: { "profile-notifications": _vm.notifications, userId: _vm.profile.identityId } })], 1) : _vm._e(), _vm._v(" "), _vm._v(" "), _c("user-notification-modal")], 1);
}, "render"), _sfc_staticRenderFns$l = [], __component__$l = /* @__PURE__ */ normalizeComponent(
  AdministrationProfilesEditProfileNotificationsComponent,
  _sfc_render$l,
  _sfc_staticRenderFns$l,
  !1,
  null,
  null
);
const EditProfileNotificationsModal = __component__$l.exports;
var __defProp$f = Object.defineProperty, __getOwnPropDesc$k = Object.getOwnPropertyDescriptor, __decorateClass$k = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$k(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$f(target, key, result), result;
}, "__decorateClass$k"), _a5;
let AdministrationProfilesEditProfileDelegationComponent = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "profile");
    __publicField(this, "delegateClient", new AdministrationProfilesClient(new Transformer(), baseUrl()));
    __publicField(this, "delegates", []);
    __publicField(this, "loading", !1);
  }
  async loadDelegates() {
    this.delegates = await this.delegateClient.getPermissionDelegate(this.profile.identityId);
  }
  async addDelegate(user) {
    await this.delegateClient.addPermissionDelegate(this.profile.identityId, user.id), this.hideModal(), await this.loadDelegates();
  }
  hideModal() {
    this.$root.$emit("bv::hide::modal", "addDelegateModal");
  }
  onHide() {
    this.$emit("delegateCount", this.delegates.length), this.delegates = null;
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("edit-delegation-profile-modal");
  }
  async deleteDelegate(delegateId) {
    this.loading = !0, await this.delegateClient.deletePermissionDelegate(this.profile.identityId, delegateId), await this.loadDelegates(), this.loading = !1;
  }
  get modalTitle() {
    var _a26;
    return ((_a26 = this.profile) == null ? void 0 : _a26.name) + "'s Delegation Settings";
  }
}, __name(_a5, "AdministrationProfilesEditProfileDelegationComponent"), _a5);
__decorateClass$k([
  Prop({ required: !0 })
], AdministrationProfilesEditProfileDelegationComponent.prototype, "profile", 2);
AdministrationProfilesEditProfileDelegationComponent = __decorateClass$k([
  Component({
    components: { UserSelectorModal, DelegateTable }
  })
], AdministrationProfilesEditProfileDelegationComponent);
var _sfc_render$k = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "edit-delegation-profile-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, on: { shown: _vm.loadDelegates, hidden: _vm.onHide }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return cancel();
    }, "click") } }, [_vm._v(`
        Close
      `)])];
  }, "fn") }]) }, [_c("user-selector-modal", { attrs: { "modal-id": "addDelegateModal", "close-on-selection": "", "show-done-button": !1, "modal-header-text": "Add Delegate", "modal-header-icon": "user-tag", "non-admin": !0, types: ["profile"], "show-advanced-button": !1 }, on: { userSelected: _vm.addDelegate } }), _vm._v(" "), _c("b-row", [_c("b-col", [_c("h5", [_c("span", { staticClass: "align-middle" }, [_c("font-awesome-icon", { attrs: { icon: "user-tag" } }), _vm._v(` Delegate Access
              `), _c("b-button", { directives: [{ name: "b-modal", rawName: "v-b-modal.addDelegateModal", modifiers: { addDelegateModal: !0 } }], staticClass: "float-right", attrs: { size: "sm", variant: "outline-primary" } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add Delegate
              `)], 1)], 1)])])], 1), _vm._v(" "), _c("b-row", [_c("b-col", [_c("delegate-table", { attrs: { "delegate-permissions": _vm.delegates, loading: _vm.loading }, on: { deleteDelegate: _vm.deleteDelegate } })], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$k = [], __component__$k = /* @__PURE__ */ normalizeComponent(
  AdministrationProfilesEditProfileDelegationComponent,
  _sfc_render$k,
  _sfc_staticRenderFns$k,
  !1,
  null,
  null
);
const EditProfileDelegationModal = __component__$k.exports;
var __defProp$e = Object.defineProperty, __getOwnPropDesc$j = Object.getOwnPropertyDescriptor, __decorateClass$j = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$j(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$e(target, key, result), result;
}, "__decorateClass$j"), _a6;
let AdministrationProfilesEditUserDefinedValuesComponent = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "profile");
    __publicField(this, "definitionClient", new AdministrationProfilesClient(new Transformer(), baseUrl()));
    __publicField(this, "definitions", []);
    __publicField(this, "loading", !1);
    __publicField(this, "editingId", null);
  }
  async loadDefinitions() {
    this.loading = !0, this.definitions = await this.definitionClient.getUsersDefinedValues(this.profile.identityId), this.loading = !1;
  }
  editValue(definition) {
    this.editingId == definition.id ? (definition.value = definition.originalValue, delete definition.originalValue, this.editingId = null) : (definition.originalValue = definition.value, this.editingId = definition.id);
  }
  async saveValue(definition) {
    try {
      await this.definitionClient.updateUserDefinedValue(definition, this.profile.identityId), toastr.success("Definition value has been updated"), this.editingId = null, await this.loadDefinitions();
    } catch (ex) {
      toastr.error(ex);
    }
  }
  hideModal() {
    this.$bvModal.hide("edit-user-definition-profile-modal");
  }
  onHide() {
    this.$emit("definitionCount", this.definitions.length), this.definitions = [];
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("edit-user-definition-profile-modal");
  }
  get modalTitle() {
    var _a26;
    return ((_a26 = this.profile) == null ? void 0 : _a26.name) + "'s Defined Values";
  }
  get tableFields() {
    return [
      { key: "displayName", label: "Name" },
      { key: "key", label: "Identifier" },
      { key: "value" },
      { key: "actions", label: "" }
    ];
  }
}, __name(_a6, "AdministrationProfilesEditUserDefinedValuesComponent"), _a6);
__decorateClass$j([
  Prop({ required: !0 })
], AdministrationProfilesEditUserDefinedValuesComponent.prototype, "profile", 2);
AdministrationProfilesEditUserDefinedValuesComponent = __decorateClass$j([
  Component({
    components: {}
  })
], AdministrationProfilesEditUserDefinedValuesComponent);
var _sfc_render$j = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "xl", id: "edit-user-definition-profile-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, on: { shown: _vm.loadDefinitions, hidden: _vm.onHide }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return cancel();
    }, "click") } }, [_vm._v(`
        Close
      `)])];
  }, "fn") }]) }, [_c("b-table", { attrs: { items: _vm.definitions, fields: _vm.tableFields, "show-empty": "", busy: _vm.loading }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(displayName)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(`
          ` + _vm._s(data.item.displayName) + `
      `)];
  }, "fn") }, { key: "cell(key)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm._v(`
          ` + _vm._s(data.item.key) + `
      `)];
  }, "fn") }, { key: "cell(value)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-input-group", [_c("b-input", { attrs: { disabled: _vm.editingId != data.item.id }, model: { value: data.item.value, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(data.item, "value", $$v);
    }, "callback"), expression: "data.item.value" } }), _vm._v(" "), _c("b-input-group-append", [data.item.syncValue ? _vm._e() : _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", value: _vm.editingId == data.item.id ? "Cancel" : "Edit Value", expression: "editingId == data.item.id ? 'Cancel' : 'Edit Value'", modifiers: { hover: !0 } }], attrs: { variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editValue(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "pen-to-square" } })], 1), _vm._v(" "), _vm.editingId == data.item.id ? _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", value: "Save Value", expression: "'Save Value'", modifiers: { hover: !0 } }], attrs: { variant: "success" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.saveValue(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "floppy-disk" } })], 1) : _vm._e()], 1)], 1)];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" })];
  }, "fn") }]) })], 1);
}, "render"), _sfc_staticRenderFns$j = [], __component__$j = /* @__PURE__ */ normalizeComponent(
  AdministrationProfilesEditUserDefinedValuesComponent,
  _sfc_render$j,
  _sfc_staticRenderFns$j,
  !1,
  null,
  null
);
const EditUserDefinedValuesModal = __component__$j.exports;
var __defProp$d = Object.defineProperty, __getOwnPropDesc$i = Object.getOwnPropertyDescriptor, __decorateClass$i = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$i(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$d(target, key, result), result;
}, "__decorateClass$i"), _a7;
let AdministrationProfilesComponent$1 = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loading", !1);
    __publicField(this, "profiles", []);
    __publicField(this, "pageNumber", 1);
    __publicField(this, "pageSize", 25);
    __publicField(this, "filter", "");
    __publicField(this, "userProfileOptions", []);
    __publicField(this, "totalProfilesCount", 0);
    __publicField(this, "deleteProfile", null);
    __publicField(this, "notificationsProfile", null);
    __publicField(this, "delegatesProfile", null);
    __publicField(this, "definitionsProfile", null);
    __publicField(this, "hasWritePermission", !1);
    __publicField(this, "hasDeletePermission", !1);
    __publicField(this, "searchDebounce", _.debounce(function() {
      this.loadUserProfiles();
    }, 300));
    __publicField(this, "profileSort", null);
  }
  async mounted() {
    await this.getUserProfileIds(), await this.loadUserProfiles(), this.hasWritePermission = await userHasPermission("users.profiles.write"), this.hasDeletePermission = await userHasPermission("users.profiles.delete");
  }
  get filterText() {
    return this.filter;
  }
  set filterText(value) {
    this.filter = value, this.searchDebounce();
  }
  async pageChanged() {
    await this.loadUserProfiles();
  }
  async loadUserProfiles() {
    this.loading = !0;
    try {
      let sortValue = null;
      this.sort && this.sort.by && (sortValue = (this.sort.descending ? "-" : "+") + this.sort.by);
      let result = await new AdministrationProfilesClient(new Transformer(), baseUrl()).getProfiles((this.pageNumber - 1) * this.pageSize, this.pageSize, this.filterText, sortValue);
      this.profiles = result.profiles, this.totalProfilesCount = result.count;
    } catch (ex) {
      toastr.error("Something has gone wrong while loading the user profiles: " + ex);
    } finally {
      this.loading = !1;
    }
  }
  async showDeleteModal(profile) {
    this.deleteProfile = profile, this.$bvModal.show("delete-profile-modal");
  }
  async showEditNotificationsModal(profile) {
    this.notificationsProfile = profile, this.$bvModal.show("edit-notifications-profile-modal");
  }
  async showEditDelegatesModal(profile) {
    this.delegatesProfile = profile, this.$bvModal.show("edit-delegation-profile-modal");
  }
  async showEditUserDefinedValues(profile) {
    this.definitionsProfile = profile, this.$bvModal.show("edit-user-definition-profile-modal");
  }
  showUserSelectModal() {
    this.$bvModal.show("userProfileSelectorModal");
  }
  get sort() {
    return this.profileSort;
  }
  set sort(value) {
    this.profileSort = value, this.loadUserProfiles();
  }
  async confirmDeleteProfile() {
    try {
      await new AdministrationProfilesClient(new Transformer(), baseUrl()).deleteProfile(this.deleteProfile.id), await this.loadUserProfiles(), await this.getUserProfileIds(), this.deleteProfile = null, toastr.success("Profile deleted");
    } catch (ex) {
      toastr.error("Something has gone wrong while deleting the user profiles: " + ex);
    }
    $("#deleteProfileModal").modal("hide");
  }
  async updateDefinitionCount(definitionCount) {
    this.definitionsProfile.userDefinedValuesCount = definitionCount;
  }
  async updatedNotifications(notifications) {
    this.notificationsProfile.notifications = notifications;
  }
  async updateDelegateCount(delegatesCount) {
    this.delegatesProfile.permissionDelegatesCount = delegatesCount;
  }
  async addNewProfile(user) {
    try {
      await new AdministrationProfilesClient(new Transformer(), baseUrl()).addUserProfile(user.id), await this.loadUserProfiles(), await this.getUserProfileIds(), toastr.success("Added user profile");
    } catch (ex) {
      toastr.error(ex, "Unable to add user profile");
    }
  }
  async getUserProfileIds() {
    let profiles = await new AdministrationProfilesClient(new Transformer(), baseUrl()).getAllManagers();
    this.userProfileOptions = [], this.userProfileOptions = [{ value: null, text: "No manager" }], profiles.forEach((profile) => {
      this.userProfileOptions.push({ value: profile.identityId, text: profile.name });
    });
  }
  async setUserManager(userId, manager, index2) {
    if (userId === manager)
      toastr.error("You cannot set yourself as your manager.");
    else
      try {
        let setManager = await new AdministrationProfilesClient(new Transformer(), baseUrl()).setManager(userId, manager);
        await this.loadUserProfiles(), await this.getUserProfileIds(), setManager.manager ? toastr.success(manager + " successfully set as " + userId + "'s manager") : toastr.success("Successfully removed manager for " + userId);
      } catch (ex) {
        toastr.error("Something has gone wrong while loading the authentication provider: " + ex);
      }
  }
  get tableFields() {
    return [
      { key: "identityId", lable: "Identity", tdClass: "align-middle", thClass: "text-nowrap" },
      { key: "name", tdClass: "align-middle", thClass: "text-nowrap" },
      { key: "email", tdClass: "align-middle", thClass: "text-nowrap" },
      { key: "settings", label: "User settings", tdClass: "align-middle", thClass: "text-nowrap" },
      { key: "lastActive", label: "Last Login", tdClass: "align-middle", thClass: "text-nowrap" },
      { key: "manager", tdClass: "align-middle", thClass: "text-nowrap" },
      { key: "actions", label: "" }
    ];
  }
}, __name(_a7, "AdministrationProfilesComponent"), _a7);
__decorateClass$i([
  Watch("pageNumber")
], AdministrationProfilesComponent$1.prototype, "pageChanged", 1);
AdministrationProfilesComponent$1 = __decorateClass$i([
  Component({
    components: {
      EditProfileDelegationModal,
      EditProfileNotificationsModal,
      vSelect,
      DateDisplay,
      deleteProfileModal,
      EditUserDefinedValuesModal,
      UserSelectorModal,
      PaginationControls,
      SortableHeaderLink
    }
  })
], AdministrationProfilesComponent$1);
var _sfc_render$i = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("h3", [_c("font-awesome-icon", { attrs: { icon: "address-card" } }), _vm._v(` Profiles
        `), _c("b-badge", { staticClass: "small", attrs: { small: "", variant: "info", pill: "" } }, [_vm._v(`
            ` + _vm._s(_vm.totalProfilesCount) + `
        `)]), _vm._v(" "), _vm.hasWritePermission ? _c("b-button", { attrs: { size: "sm", variant: "primary" }, on: { click: _vm.showUserSelectModal } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add Profile
        `)], 1) : _vm._e(), _vm._v(" "), _c("b-button", { staticClass: "float-right mt-1", attrs: { pill: "", variant: "primary", size: "sm" }, on: { click: _vm.loadUserProfiles } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)])], 1)])]), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("b-input-group", { staticClass: "pb-2", attrs: { size: "sm" } }, [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1), _vm._v(" "), _c("b-form-input", { attrs: { type: "search", placeholder: "Filter results..." }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1), _vm._v(" "), _c("b-table", { attrs: { items: _vm.profiles, fields: _vm.tableFields, striped: "", hover: "", "sort-icon-left": "", busy: _vm.loading, "show-empty": "" }, scopedSlots: _vm._u([{ key: "head(identityId)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "identityId", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(name)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "name", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(email)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "email", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(lastActive)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "lastActive", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(manager)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "manager", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "empty", fn: /* @__PURE__ */ __name(function(scope) {
    return [_c("i", { staticClass: "text-muted" }, [_vm._v("There are no user profiles to configure")])];
  }, "fn") }, { key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(settings)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-badge", { attrs: { href: "#", variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showEditNotificationsModal(data.item);
    }, "click") } }, [_vm._v(_vm._s(data.item.notifications.length) + " Notifications")]), _vm._v(" "), _c("b-badge", { attrs: { href: "#", variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showEditDelegatesModal(data.item);
    }, "click") } }, [_vm._v(_vm._s(data.item.permissionDelegatesCount) + " Delegates")]), _vm._v(" "), _c("b-badge", { attrs: { href: "#", variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showEditUserDefinedValues(data.item);
    }, "click") } }, [_vm._v(_vm._s(data.item.userDefinedValuesCount) + " Defined Values")])];
  }, "fn") }, { key: "cell(lastActive)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.lastActive ? _c("date-display", { attrs: { value: data.item.lastActive } }) : _vm._e()];
  }, "fn") }, { key: "cell(manager)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm.userProfileOptions && _vm.hasWritePermission ? _c("v-select", { attrs: { placeholder: "No manager", options: _vm.userProfileOptions.filter((user) => user.value != data.item.identityId), reduce: /* @__PURE__ */ __name((option) => option.value, "reduce"), clearable: !0, label: "text" }, on: { input: /* @__PURE__ */ __name(function($event) {
      return _vm.setUserManager(data.item.identityId, data.value, data.index);
    }, "input") }, model: { value: data.value, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(data, "value", $$v);
    }, "callback"), expression: "data.value" } }) : data.value ? _c("span", [_vm._v(_vm._s(data.value))]) : _c("span", [_vm._v("No manager")])];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right text-nowrap" }, [_c("span", [_c("b-dropdown", { attrs: { "no-flip": "", size: "sm", variant: "primary", "no-caret": "", right: "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _vm.hasDeletePermission ? _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showDeleteModal(data.item);
    }, "click") } }, [_c("span", { staticClass: "text-danger" }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
                        `)], 1)]) : _vm._e(), _vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showEditNotificationsModal(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "mail-bulk" } }), _vm._v(` Notifications
                      `)], 1), _vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.showEditDelegatesModal(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "user-tag" } }), _vm._v(` Delegation
                      `)], 1)], 1)], 1)])];
  }, "fn") }]) }), _vm._v(" "), _vm.profiles && _vm.profiles.length ? _c("pagination-controls", { attrs: { count: Math.ceil(_vm.totalProfilesCount / _vm.pageSize) }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } }) : _vm._e()], 1)]), _vm._v(" "), _vm.hasDeletePermission ? _c("delete-profile-modal", { attrs: { "delete-profile": _vm.deleteProfile }, on: { confirm: _vm.confirmDeleteProfile } }) : _vm._e(), _vm._v(" "), _c("edit-profile-notifications-modal", { attrs: { profile: _vm.notificationsProfile }, on: { confirm: _vm.confirmDeleteProfile, updatedNotifications: _vm.updatedNotifications } }), _vm._v(" "), _c("edit-profile-delegation-modal", { attrs: { profile: _vm.delegatesProfile }, on: { confirm: _vm.confirmDeleteProfile, delegateCount: _vm.updateDelegateCount } }), _vm._v(" "), _c("edit-user-defined-values-modal", { attrs: { profile: _vm.definitionsProfile }, on: { definitionCount: _vm.updateDefinitionCount } }), _vm._v(" "), _c("user-selector-modal", { attrs: { "modal-id": "userProfileSelectorModal", "close-on-selection": !0, types: ["user"], modalHeaderText: "Add Profile for User" }, on: { userSelected: _vm.addNewProfile } })], 1);
}, "render"), _sfc_staticRenderFns$i = [], __component__$i = /* @__PURE__ */ normalizeComponent(
  AdministrationProfilesComponent$1,
  _sfc_render$i,
  _sfc_staticRenderFns$i,
  !1,
  null,
  "6d31ca3f"
);
const AdministrationProfilesComponent = __component__$i.exports;
var __defProp$c = Object.defineProperty, __getOwnPropDesc$h = Object.getOwnPropertyDescriptor, __decorateClass$h = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$h(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$c(target, key, result), result;
}, "__decorateClass$h"), _a8;
let AdministratorPermissionSettingsComponent = (_a8 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "pageOptions");
    __publicField(this, "loggedInUserIsSuperAdmin");
    __publicField(this, "loading", !1);
    __publicField(this, "filterText", "");
    __publicField(this, "confirmDeleteId", "");
    __publicField(this, "hasWritePermission", !1);
  }
  async mounted() {
    this.hasWritePermission = await userHasPermission("users.adminUsers.write");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get users() {
    if (this.model)
      return this.model.users;
  }
  set users(value) {
    this.model = { ...this.model, users: value };
  }
  get otherAdminUserAccess() {
    if (this.model)
      return this.model.otherAdminUserAccess;
  }
  set otherAdminUserAccess(value) {
    this.model = { ...this.model, otherAdminUserAccess: value };
  }
  getCurrentUser(userPermission) {
    return this.otherAdminUserAccess.slice().find((y) => y.userId === userPermission.principal.id);
  }
  getPrincipalIcon(type) {
    switch (type) {
      case "ewaGroup":
        return "screen-users";
      case "role":
        return "users";
      default:
        return "user";
    }
  }
  getAdminPageAccess(userId) {
    var _a26;
    let pages = (_a26 = this.model.otherAdminUserAccess.find((y) => y.userId == userId)) == null ? void 0 : _a26.permissions;
    return pages || [];
  }
  getPagePermissionVariant(user, page) {
    let currentUser = this.getCurrentUser(user), pages = this.getAdminPageAccess(user.principal.id);
    return currentUser.isSuperAdmin || pages.find((p) => p == page) ? "success" : "danger";
  }
  filterPermissionsTable(row, filter) {
    if (filter = filter.toLowerCase(), row.principal.email && row.principal.email.toLowerCase().includes(filter))
      return !0;
    if (row.principal.name && row.principal.name.toLowerCase().includes(filter))
      return !0;
    {
      let exists = !1;
      return this.getAdminPageAccess(row.principal.id).some((page) => {
        if (exists = page.toLowerCase().includes(filter), exists)
          return exists;
      }), exists;
    }
  }
  openEditModal(adminUser) {
    this.$emit("edit", adminUser), this.$bvModal.show("edit-administrator-modal");
  }
  removeAdmin(permission) {
    this.$emit("delete", permission);
  }
  get tableFields() {
    return [
      { key: "principal.name", label: "Name", sortable: !0 },
      { key: "principal.email", label: "Email", sortable: !0 },
      { key: "permissions", sortable: !1 },
      { key: "actions", label: "", sortable: !1 }
    ];
  }
}, __name(_a8, "AdministratorPermissionSettingsComponent"), _a8);
__decorateClass$h([
  Prop({ required: !0 })
], AdministratorPermissionSettingsComponent.prototype, "value", 2);
__decorateClass$h([
  Prop({ required: !0 })
], AdministratorPermissionSettingsComponent.prototype, "pageOptions", 2);
__decorateClass$h([
  Prop({ required: !0 })
], AdministratorPermissionSettingsComponent.prototype, "loggedInUserIsSuperAdmin", 2);
AdministratorPermissionSettingsComponent = __decorateClass$h([
  Component({
    components: {
      PermissionEditor,
      vSelect
    }
  })
], AdministratorPermissionSettingsComponent);
var _sfc_render$h = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col" }, [_c("b-input-group", { staticClass: "pb-2", attrs: { size: "sm" } }, [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1), _vm._v(" "), _c("b-form-input", { attrs: { disabled: _vm.loading, type: "search", placeholder: "Filter results..." }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1), _vm._v(" "), _c("b-table", { attrs: { items: _vm.users, fields: _vm.tableFields, striped: "", hover: "", "sort-icon-left": "", busy: _vm.loading, fixed: "", filter: _vm.filterText, "filter-function": _vm.filterPermissionsTable, "show-empty": "" }, scopedSlots: _vm._u([{ key: "empty", fn: /* @__PURE__ */ __name(function(scope) {
    return [_c("i", { staticClass: "text-muted" }, [_vm._v("There are no admin users to configure")])];
  }, "fn") }, { key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "head(permission)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_vm._v(_vm._s(data.label))])];
  }, "fn") }, { key: "cell(principal.name)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("font-awesome-icon", { attrs: { icon: _vm.getPrincipalIcon(data.item.principal.type) } }), _vm._v(`
                ` + _vm._s(data.item.principal.name) + `
              `)];
  }, "fn") }, { key: "cell(permissions)", fn: /* @__PURE__ */ __name(function(data) {
    return _vm._l(_vm.pageOptions, function(pageOption) {
      return _c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "mr-1", attrs: { title: pageOption.description, variant: _vm.getPagePermissionVariant(data.item, pageOption.id) } }, [_c("font-awesome-icon", { attrs: { icon: pageOption.icon } }), _vm._v(`
                        ` + _vm._s(pageOption.name) + `
                    `)], 1);
    });
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_vm.confirmDeleteId === data.item.principal.id && _vm.loggedInUserIsSuperAdmin ? _c("span", [_c("b-button", { attrs: { variant: "danger", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.removeAdmin(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Confirm")], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.confirmDeleteId = null;
    }, "click") } }, [_vm._v("Cancel")])], 1) : _c("span", [_vm.hasWritePermission ? _c("b-button", { attrs: { size: "sm", variant: "primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.openEditModal(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "pencil" } }), _vm._v(" Edit")], 1) : _vm._e(), _vm._v(" "), _vm.loggedInUserIsSuperAdmin ? _c("b-button", { attrs: { size: "sm", variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.confirmDeleteId = data.item.principal.id;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1) : _vm._e()], 1)])];
  }, "fn") }]) })], 1)])]);
}, "render"), _sfc_staticRenderFns$h = [], __component__$h = /* @__PURE__ */ normalizeComponent(
  AdministratorPermissionSettingsComponent,
  _sfc_render$h,
  _sfc_staticRenderFns$h,
  !1,
  null,
  "f49d834c"
);
const AdministratorPermissionSettings = __component__$h.exports;
var __defProp$b = Object.defineProperty, __getOwnPropDesc$g = Object.getOwnPropertyDescriptor, __decorateClass$g = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$g(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$b(target, key, result), result;
}, "__decorateClass$g"), _a9;
let EditAdministratorModal$1 = (_a9 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "editingUser");
    __publicField(this, "permissionOptions");
    __publicField(this, "loggedInUserIsSuperAdmin");
    __publicField(this, "userPermissionsAccess", []);
  }
  mounted() {
  }
  get editingUserName() {
    return this.editingUser ? this.editingUser.principal.name : "Administrative User";
  }
  watchEditingUser() {
    this.getAdminPageAccess();
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.value = value;
  }
  get otherAdminUserAccess() {
    if (this.model)
      return this.model.otherAdminUserAccess;
  }
  set otherAdminUserAccess(value) {
    this.model = { ...this.model, otherAdminUserAccess: value };
  }
  get currentUser() {
    return this.otherAdminUserAccess.slice().find((y) => y.userId === this.editingUser.principal.id);
  }
  get currentUserPermissions() {
    return this.currentUser.permissions;
  }
  set currentUserPermissions(value) {
    this.currentUser.permissions = value;
  }
  userHasAccessToPermission(permission) {
    return !!this.currentUserPermissions.find((p) => p == permission);
  }
  get isSuperAdmin() {
    return this.currentUser.isSuperAdmin === void 0 ? !1 : this.currentUser.isSuperAdmin;
  }
  set isSuperAdmin(value) {
    this.currentUser.isSuperAdmin = value, this.setAsSuperAdmin();
  }
  setAsSuperAdmin() {
    this.isSuperAdmin ? this.currentUserPermissions = [] : this.addAccess("dashboard");
  }
  saveAdminUserPermissions() {
    this.$emit("save", this.currentUser), this.$bvModal.hide("edit-administrator-modal");
  }
  getAdminPageAccess() {
    if (this.model && this.otherAdminUserAccess) {
      let adminUserAccessRecord = this.otherAdminUserAccess.find((y) => y.userId == this.editingUser.principal.id);
      adminUserAccessRecord && (this.userPermissionsAccess = adminUserAccessRecord.permissions);
    }
  }
  togglePageAccess(accessibleFeatureOption) {
    this.userHasAccessToPermission(accessibleFeatureOption.id) ? this.removePageAccess(accessibleFeatureOption) : this.addPageAccess(accessibleFeatureOption);
  }
  toggleChildAccess(accessibleFeaturePermission) {
    this.userHasAccessToPermission(accessibleFeaturePermission.permissionFullName) ? this.removeChildAccess(accessibleFeaturePermission) : this.addChildAccess(accessibleFeaturePermission);
  }
  toggleChildPermissionsAccess(accessibleFeaturePermission, featurePermission) {
    this.userHasAccessToPermission(featurePermission.permissionFullName) ? this.removeAccess(featurePermission.permissionFullName) : this.addAccess(featurePermission.permissionFullName);
  }
  removePageAccess(accessibleFeatureOption) {
    accessibleFeatureOption.children.forEach((child) => {
      this.removeChildAccess(child);
    }), this.removeAccess(accessibleFeatureOption.id);
  }
  removeChildAccess(child) {
    this.removeAccess(child.permissionFullName), child.children.forEach((childPermission) => {
      this.removeAccess(childPermission.permissionFullName);
    });
  }
  removeAccess(id) {
    this.userHasAccessToPermission(id) && this.currentUserPermissions.splice($.inArray(id, this.currentUserPermissions), 1);
  }
  addPageAccess(accessibleFeatureOption) {
    !accessibleFeatureOption || !accessibleFeatureOption.id || (accessibleFeatureOption.children.forEach((child) => {
      this.addChildAccess(child);
    }), this.currentUserPermissions.push(accessibleFeatureOption.id));
  }
  addChildAccess(child) {
    this.addAccess(child.permissionFullName), child.children.forEach((childPermission) => {
      this.addAccess(childPermission.permissionFullName);
    });
  }
  addAccess(id) {
    this.currentUser == null ? this.otherAdminUserAccess.slice().push({
      type: this.editingUser.principal.type,
      userId: this.editingUser.principal.id,
      permissions: [id]
    }) : this.currentUserPermissions.push(id);
  }
  get tableFields() {
    return [
      { key: "name", label: "Name", sortable: !1 },
      { key: "actions", label: "", sortable: !1 }
    ];
  }
}, __name(_a9, "EditAdministratorModal"), _a9);
__decorateClass$g([
  Prop({
    required: !0,
    default: /* @__PURE__ */ __name(() => [], "default")
  })
], EditAdministratorModal$1.prototype, "value", 2);
__decorateClass$g([
  Prop({ required: !0, default: null })
], EditAdministratorModal$1.prototype, "editingUser", 2);
__decorateClass$g([
  Prop({ required: !0 })
], EditAdministratorModal$1.prototype, "permissionOptions", 2);
__decorateClass$g([
  Prop({ required: !0 })
], EditAdministratorModal$1.prototype, "loggedInUserIsSuperAdmin", 2);
__decorateClass$g([
  Watch("editingUser", { immediate: !0 })
], EditAdministratorModal$1.prototype, "watchEditingUser", 1);
EditAdministratorModal$1 = __decorateClass$g([
  Component({
    components: {
      ReactiveDropdown,
      PermissionEditor,
      AdministratorPermissionSettings,
      vSelect
    },
    methods: { queryAuthorisation, checkProviderQuery }
  })
], EditAdministratorModal$1);
var _sfc_render$g = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { id: "edit-administrator-modal", title: "Editing access for " + _vm.editingUserName, size: "lg", "no-close-on-backdrop": "", "hide-footer": "" }, scopedSlots: _vm._u([{ key: "modal-header", fn: /* @__PURE__ */ __name(function({ close }) {
    return [_c("h4", { staticClass: "modal-title" }, [_vm._v("Editing access for " + _vm._s(_vm.editingUserName))]), _vm._v(" "), _c("button", { staticClass: "close", attrs: { type: "button", "aria-label": "Close" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.$emit("close");
    }, "click") } }, [_c("span", { attrs: { "aria-hidden": "true" } }, [_vm._v("×")])])];
  }, "fn") }]) }, [_vm._v(" "), _vm.editingUser ? _c("div", [_vm.isSuperAdmin ? _c("b-row", [_c("b-col", [_c("b-alert", { staticClass: "mt-2", attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "info-circle" } }), _vm._v(" This user is a super administrator and will be able to access all areas of the Admin Panel.")], 1)], 1)], 1) : _c("b-row", [_c("b-col", [_c("b-alert", { attrs: { show: "", variant: "primary" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` By ticking on the access pages for a user it will grant them the ability to alter features within that page
                `)], 1)], 1)], 1), _vm._v(" "), _c("b-row", [_c("b-col", [_c("b-table", { staticClass: "pageTable", attrs: { items: _vm.permissionOptions, fields: _vm.tableFields, hover: "", "sort-icon-left": "" }, scopedSlots: _vm._u([{ key: "head(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm.loggedInUserIsSuperAdmin ? _c("span", { staticClass: "float-right" }, [_c("b-form-checkbox", { attrs: { name: "check-button" }, model: { value: _vm.isSuperAdmin, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.isSuperAdmin = $$v;
    }, "callback"), expression: "isSuperAdmin" } }, [_vm._v("Set as Super Administrator")])], 1) : _vm._e()];
  }, "fn") }, { key: "cell(name)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("font-awesome-icon", { attrs: { icon: data.item.icon } }), _vm._v(" "), _c("span", [_vm._v(_vm._s(data.value))]), _vm._v(" "), data.item.description ? _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { title: data.item.description } }, [_c("font-awesome-icon", { staticClass: "text-primary", attrs: { icon: "question-circle" } })], 1) : _vm._e(), _vm._v(" "), data.item.children && data.item.children.length ? _c("b-button", { attrs: { size: "sm", variant: "link" }, on: { click: data.toggleDetails } }, [_c("font-awesome-icon", { attrs: { icon: data.detailsShowing ? "caret-down" : "caret-right" } })], 1) : _vm._e()];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_c("b-form-checkbox", { attrs: { name: "check-button", checked: _vm.userHasAccessToPermission(data.item.id), disabled: data.item.id === "dashboard" || _vm.isSuperAdmin }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.togglePageAccess(data.item);
    }, "change") } })], 1)];
  }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.children && data.item.children.length ? _c("b-table", { staticClass: "mb-0", attrs: { items: data.item.children, small: "", fields: _vm.tableFields, hover: "", "sort-icon-left": "", "thead-class": "d-none" }, scopedSlots: _vm._u([{ key: "cell(name)", fn: /* @__PURE__ */ __name(function(child) {
      return [_c("span", { staticClass: "ml-2 pl-2" }, [_c("font-awesome-icon", { attrs: { icon: "minus" } }), _vm._v(`
                          ` + _vm._s(_vm.$options.filters.capitaliseFirstLetter(_vm.$options.filters.addSpacesToCamelCase(child.item.name))) + `
                        `)], 1), _vm._v(" "), child.item.children && child.item.children.length ? _c("b-button", { attrs: { size: "sm", variant: "link" }, on: { click: child.toggleDetails } }, [_c("font-awesome-icon", { attrs: { icon: child.detailsShowing ? "caret-down" : "caret-right" } })], 1) : _vm._e()];
    }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(child) {
      return [_c("span", { staticClass: "float-right" }, [_c("b-form-checkbox", { staticClass: "mr-2", attrs: { name: "check-button", checked: _vm.userHasAccessToPermission(child.item.permissionFullName), disabled: !_vm.userHasAccessToPermission(data.item.id) || _vm.isSuperAdmin }, on: { change: /* @__PURE__ */ __name(function($event) {
        return _vm.toggleChildAccess(child.item);
      }, "change") } })], 1)];
    }, "fn") }, { key: "row-details", fn: /* @__PURE__ */ __name(function(child) {
      return [_c("table", { staticClass: "table table-hover mb-0" }, _vm._l(child.item.children, function(childPermission) {
        return _c("tr", [_c("td", [_c("span", { staticClass: "ml-2 pl-4" }, [childPermission.icon ? _c("font-awesome-icon", { attrs: { icon: childPermission.icon } }) : _c("font-awesome-icon", { attrs: { icon: "minus" } }), _vm._v(`
                              ` + _vm._s(_vm.$options.filters.capitaliseFirstLetter(_vm.$options.filters.addSpacesToCamelCase(childPermission.name))))], 1), _vm._v(" "), childPermission.description ? _c("font-awesome-icon", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "text-muted", attrs: { icon: "question-circle", title: childPermission.description } }) : _vm._e()], 1), _vm._v(" "), _c("td", [_c("span", { staticClass: "float-right" }, [_c("b-form-checkbox", { staticClass: "mr-2", attrs: { name: "check-button", checked: _vm.userHasAccessToPermission(childPermission.permissionFullName), disabled: !_vm.userHasAccessToPermission(child.item.permissionFullName) || _vm.isSuperAdmin }, on: { change: /* @__PURE__ */ __name(function($event) {
          return _vm.toggleChildPermissionsAccess(child.item, childPermission);
        }, "change") } })], 1)])]);
      }), 0)];
    }, "fn") }], null, !0) }) : _vm._e()];
  }, "fn") }], null, !1, 406561713) })], 1)], 1), _vm._v(" "), _c("span", { staticClass: "float-right" }, [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.$emit("close");
  }, "click") } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "success" }, on: { click: _vm.saveAdminUserPermissions } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1)], 1)], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$g = [], __component__$g = /* @__PURE__ */ normalizeComponent(
  EditAdministratorModal$1,
  _sfc_render$g,
  _sfc_staticRenderFns$g,
  !1,
  null,
  "02b74480"
);
const EditAdministratorModal = __component__$g.exports;
var __getOwnPropDesc$f = Object.getOwnPropertyDescriptor, __decorateClass$f = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$f(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$f"), _a10;
let AdministratorSettingsComponent$1 = (_a10 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "adminPermissions", null);
    __publicField(this, "accessibleFeatures", null);
    __publicField(this, "currentUserIsSuperAdmin", !1);
    __publicField(this, "loading", !1);
    __publicField(this, "editingUser", null);
    __publicField(this, "hasWritePermission", !1);
  }
  async mounted() {
    this.hasWritePermission = await userHasPermission("users.adminUsers.write"), await this.loadSettings(), await this.loadAdminFeatureAccess();
  }
  async loadSettings() {
    this.loading = !0;
    try {
      this.adminPermissions = await new AdministrationAdminUsersClient(new Transformer(), baseUrl()).getAdministratorPermissions();
    } catch (e) {
      toastr.error("Something has gone wrong while loading the settings: " + e);
    } finally {
      this.loading = !1;
    }
    try {
      this.currentUserIsSuperAdmin = await new AdministrationAdminUsersClient(new Transformer(), baseUrl()).currentUserIsSuperAdmin();
    } catch (e) {
      toastr.error("Something has gone wrong while loading the settings: " + e);
    } finally {
      this.loading = !1;
    }
  }
  async loadAdminFeatureAccess() {
    this.loading = !0;
    try {
      this.accessibleFeatures = await new AdministrationAdminUsersClient(new Transformer(), baseUrl()).getAccessibleAdministratorFeatures();
    } catch (e) {
      toastr.error("Something has gone wrong while loading the settings: " + e);
    } finally {
      this.loading = !1;
    }
  }
  get model() {
    return this.adminPermissions;
  }
  set model(value) {
    this.saveAdminPermissions(value);
  }
  get users() {
    if (this.model)
      return this.model.users;
  }
  set users(value) {
    this.model = { ...this.model, users: value };
  }
  get otherAdminUserAccess() {
    if (this.model)
      return this.model.otherAdminUserAccess;
  }
  set otherAdminUserAccess(value) {
    this.model = { ...this.model, otherAdminUserAccess: value };
  }
  showUserSelectModal() {
    this.$bvModal.show("adminUserUserSelectorModal");
  }
  addNewUser(user) {
    let existingPermission = this.users.find((p) => p.principal.id === user.id && p.principal.type === user.type);
    existingPermission || (this.otherAdminUserAccess.push({ type: user.type, userId: user.id, permissions: ["dashboard"], isSuperAdmin: user.isSuperAdmin }), existingPermission = { grant: !0, principal: user }, this.users.push(existingPermission)), this.setEditingUser(existingPermission);
  }
  setEditingUser(user) {
    this.editingUser = user, this.$bvModal.show("edit-administrator-modal");
  }
  async saveAdminPermissions(adminUserPermissionsModel) {
    try {
      let settings = await new AdministrationAdminUsersClient(new Transformer(), baseUrl()).setAdministratorPermission({ user: this.editingUser, otherAdminUserAccess: adminUserPermissionsModel });
      this.adminPermissions = settings, toastr.success("The user's admin permissions have been successfully saved.");
    } catch (e) {
      toastr.error("Something has gone wrong while saving the settings: " + e);
    } finally {
      this.loading = !1;
    }
  }
  closeEditModal() {
    this.$bvModal.hide("edit-administrator-modal"), this.loadSettings();
  }
  async removeAdminUser(permission) {
    try {
      let settings = await new AdministrationAdminUsersClient(new Transformer(), baseUrl()).deleteAdministratorPermission(permission);
      this.editingUser = null, this.adminPermissions = settings;
    } catch (e) {
      toastr.error("Something has gone wrong while saving the settings: " + e);
    } finally {
      this.loading = !1;
    }
  }
}, __name(_a10, "AdministratorSettingsComponent"), _a10);
AdministratorSettingsComponent$1 = __decorateClass$f([
  Component({
    components: {
      UserSelectorModal,
      EditAdministratorModal,
      PermissionEditor,
      AdministratorPermissionSettings
    }
  })
], AdministratorSettingsComponent$1);
var _sfc_render$f = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("h3", [_c("font-awesome-icon", { attrs: { icon: "users" } }), _vm._v(`
                Administrator Users `), _vm.model ? _c("b-badge", { staticClass: "small", attrs: { small: "", variant: "info", pill: "" } }, [_vm._v(_vm._s(_vm.model.users.length))]) : _vm._e(), _vm._v(" "), _vm.hasWritePermission ? _c("b-button", { attrs: { size: "sm", variant: "primary" }, on: { click: _vm.showUserSelectModal } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(" Add Admin")], 1) : _vm._e()], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", [_c("administrator-permission-settings", { attrs: { "page-options": _vm.accessibleFeatures, "logged-in-user-is-super-admin": _vm.currentUserIsSuperAdmin }, on: { save: _vm.saveAdminPermissions, edit: _vm.setEditingUser, delete: _vm.removeAdminUser }, model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } })], 1)], 1), _vm._v(" "), _c("user-selector-modal", { attrs: { "modal-id": "adminUserUserSelectorModal", "close-on-selection": !0, types: ["user", "profile", "role", "ewaGroup"], "show-done-button": !1, "select-button-variant": "primary" }, on: { userSelected: _vm.addNewUser } }), _vm._v(" "), _vm.hasWritePermission ? _c("edit-administrator-modal", { attrs: { "editing-user": _vm.editingUser, "permission-options": _vm.accessibleFeatures, "logged-in-user-is-super-admin": _vm.currentUserIsSuperAdmin }, on: { close: _vm.closeEditModal, save: _vm.saveAdminPermissions }, model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } }) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns$f = [], __component__$f = /* @__PURE__ */ normalizeComponent(
  AdministratorSettingsComponent$1,
  _sfc_render$f,
  _sfc_staticRenderFns$f,
  !1,
  null,
  "c660cdbd"
);
const AdministratorSettingsComponent = __component__$f.exports;
var __defProp$a = Object.defineProperty, __getOwnPropDesc$e = Object.getOwnPropertyDescriptor, __decorateClass$e = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$e(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$a(target, key, result), result;
}, "__decorateClass$e"), _a11;
let AdministrationGroupsDeleteGroupModal = (_a11 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "deleteGroup");
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("removeUserGroupModal");
  }
}, __name(_a11, "AdministrationGroupsDeleteGroupModal"), _a11);
__decorateClass$e([
  Prop({ required: !0 })
], AdministrationGroupsDeleteGroupModal.prototype, "deleteGroup", 2);
AdministrationGroupsDeleteGroupModal = __decorateClass$e([
  Component({})
], AdministrationGroupsDeleteGroupModal);
var _sfc_render$e = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { id: "delete-group-modal", "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Confirm delete - " + _vm._s(_vm.deleteGroup.name))], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
        Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "danger" }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Confirm
    `)], 1)];
  }, "fn") }]) }, [_vm._v(" "), _vm.deleteGroup ? _c("div", [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "danger", show: "" } }, [_c("p", { staticClass: "font-weight-bold" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" Are you sure you want to delete this user group?")], 1), _vm._v(" "), _c("ul", [_c("li", [_vm._v("Access granted via this group will not longer work")]), _vm._v(" "), _c("li", [_vm._v("There is no way to reverse this process")]), _vm._v(" "), _vm.deleteGroup.key ? _c("li", [_vm._v("When the group sync is run, this group may be re-created")]) : _vm._e()])])], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$e = [], __component__$e = /* @__PURE__ */ normalizeComponent(
  AdministrationGroupsDeleteGroupModal,
  _sfc_render$e,
  _sfc_staticRenderFns$e,
  !1,
  null,
  null
);
const UserGroupDeleteModal = __component__$e.exports;
var __defProp$9 = Object.defineProperty, __getOwnPropDesc$d = Object.getOwnPropertyDescriptor, __decorateClass$d = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$d(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$9(target, key, result), result;
}, "__decorateClass$d");
Vue.use(VeeValidate$1, {
  inject: !0,
  fieldsBagName: "veeFields",
  errorBagName: "veeErrors"
});
var _a12;
let AdministrationGroupsAddUserModal = (_a12 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "assignType");
    __publicField(this, "value", null);
    __publicField(this, "veeFields");
    __publicField(this, "errors");
  }
  mounted() {
    this.resetUserModel();
  }
  validateState(ref) {
    return this.veeFields[ref] && (this.veeFields[ref].dirty || this.veeFields[ref].validated) ? !this.errors.has(ref) : null;
  }
  resetUserModel() {
    this.value = {
      id: v4(),
      source: "EWA"
    }, this.$nextTick(() => {
      this.$validator.reset();
    });
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.value = value, this.$emit("input", value);
  }
  get email() {
    if (this.model)
      return this.model.email;
  }
  set email(value) {
    this.model = { ...this.model, email: value };
  }
  get userId() {
    if (this.model)
      return this.model.userId;
  }
  set userId(value) {
    this.model = { ...this.model, userId: value };
  }
  confirm() {
    this.$validator.validateAll().then((result) => {
      result && (this.$emit("addUser", this.value), this.$bvModal.hide("add-user-modal"));
    });
  }
}, __name(_a12, "AdministrationGroupsAddUserModal"), _a12);
__decorateClass$d([
  Prop({ required: !0 })
], AdministrationGroupsAddUserModal.prototype, "assignType", 2);
AdministrationGroupsAddUserModal = __decorateClass$d([
  Component({})
], AdministrationGroupsAddUserModal);
var _sfc_render$d = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "add-user-modal", "no-close-on-backdrop": "", "cancel-variant": "" }, on: { shown: _vm.resetUserModel }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "user-plus" } }), _vm._v(" Assign User to group")], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "success" }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "user-plus" } }), _vm._v(` Assign User
        `)], 1)];
  }, "fn") }]) }, [_vm._v(" "), _vm.assignType === "userId" ? _c("b-form-group", { attrs: { id: "userNameInputGroup", label: "Username", "label-for": "userNameInput" } }, [_c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: { required: !0 }, expression: "{ required: true }" }], class: { "is-invalid": _vm.errors.first("usernameInput") }, attrs: { id: "userNameInput", type: "text", name: "usernameInput", state: _vm.validateState("userNameInput"), "data-vv-as": "Username", "aria-describedby": "userNameInputFeedback" }, model: { value: _vm.userId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.userId = $$v;
  }, "callback"), expression: "userId" } }), _vm._v(" "), _c("b-form-invalid-feedback", { attrs: { id: "userNameInputFeedback" } }, [_vm._v(_vm._s(_vm.errors.first("usernameInput")))]), _vm._v(" "), _vm.errors.first("usernameInput") ? _vm._e() : _c("span", { staticClass: "form-text text-muted", attrs: { id: "usernameHelp" } }, [_vm._v("The username or ID that will be used to identify the user.")])], 1) : _vm._e(), _vm._v(" "), _vm.assignType === "email" ? _c("b-form-group", { attrs: { id: "emailAddressInputGroup", label: "Email Address", "label-for": "emailAddressInput" } }, [_c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: { required: !0, email: !0 }, expression: "{ required: true, email: true }" }], class: { "is-invalid": _vm.errors.first("emailAddressInput") }, attrs: { id: "emailAddressInput", type: "text", name: "emailAddressInput", state: _vm.validateState("emailAddressInput"), "data-vv-as": "Email Address", "aria-describedby": "emailAddressInputFeedback" }, model: { value: _vm.email, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.email = $$v;
  }, "callback"), expression: "email" } }), _vm._v(" "), _c("b-form-invalid-feedback", { attrs: { id: "emailAddressInputFeedback" } }, [_vm._v(_vm._s(_vm.errors.first("emailAddressInput")))]), _vm._v(" "), _vm.errors.first("emailAddressInput") ? _vm._e() : _c("span", { staticClass: "form-text text-muted", attrs: { id: "emailAddressHelp" } }, [_vm._v("The username or ID that will be used to identify the user.")])], 1) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns$d = [], __component__$d = /* @__PURE__ */ normalizeComponent(
  AdministrationGroupsAddUserModal,
  _sfc_render$d,
  _sfc_staticRenderFns$d,
  !1,
  null,
  null
);
const UserGroupAddUserModal = __component__$d.exports;
var __getOwnPropDesc$c = Object.getOwnPropertyDescriptor, __decorateClass$c = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$c(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$c"), _a13;
let AdministrationGroupsAddBulkUsersModal = (_a13 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "dataInput", null);
    __publicField(this, "importing", !1);
    __publicField(this, "error", null);
    __publicField(this, "importedRowCount", 0);
    __publicField(this, "importedJsonData", null);
  }
  downloadTemplate() {
    var encodedUri = encodeURI("data:text/csv;charset=utf-8, UserId, Email, Name"), link = document.createElement("a");
    link.setAttribute("href", encodedUri), link.setAttribute("download", "User group template.csv"), document.body.appendChild(link), link.click(), link.remove();
  }
  async importUsers() {
    try {
      this.importing = !0, this.importedRowCount = 0, this.error = null, await csv({
        delimiter: "auto",
        noheader: !1
      }).fromString(this.dataInput).then(async (jsonData) => {
        this.importedJsonData = jsonData, await this.importData(jsonData);
      }), this.importedRowCount == 0 ? this.error = "No users were imported. Please review the csv data and if the headers match/data is populated" : (this.dataInput = null, this.$bvModal.hide("bulk-add-users-modal"), this.importedJsonData.length != this.importedRowCount ? toastr.warning("Only " + this.importedRowCount + " out of " + this.importedJsonData.length + " users were imported.") : toastr.success(this.importedRowCount + " users were successfully imported"));
    } catch (Ex) {
      this.error = Ex;
    } finally {
      this.importing = !1;
    }
  }
  importData(users) {
    for (var i = 0; i < users.length; i++) {
      var user = users[i];
      if (!(!user.Email && !user.UserId)) {
        var newUser = {
          id: v4(),
          source: "EWA",
          userId: user.UserId,
          name: user.Name,
          email: user.Email
        };
        this.$emit("addUser", newUser), this.importedRowCount++;
      }
    }
  }
}, __name(_a13, "AdministrationGroupsAddBulkUsersModal"), _a13);
AdministrationGroupsAddBulkUsersModal = __decorateClass$c([
  Component({})
], AdministrationGroupsAddBulkUsersModal);
var _sfc_render$c = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "bulk-add-users-modal", "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "user-plus" } }), _vm._v(" Bulk assign users to group")], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "success", disabled: !_vm.dataInput || _vm.importing }, on: { click: _vm.importUsers } }, [_vm.importing ? _c("span", [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Importing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "upload" } }), _vm._v(" Import Users")], 1)])];
  }, "fn") }]) }, [_vm._v(" "), _c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
            This will allow you to paste in user data from the provided template
            `), _c("ul", { staticClass: "mb-0" }, [_c("li", [_vm._v("The data must be in either comma or tab separated format")]), _vm._v(" "), _c("li", [_vm._v("Only the UserId or Email fields are required")])])], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "link" }, on: { click: _vm.downloadTemplate } }, [_c("font-awesome-icon", { attrs: { icon: "file" } }), _vm._v(" Download template file")], 1), _vm._v(" "), _c("textarea", { directives: [{ name: "model", rawName: "v-model", value: _vm.dataInput, expression: "dataInput" }], staticClass: "form-control", attrs: { rows: "6", placeholder: "Paste in comma or tab separated data", name: "dataInput" }, domProps: { value: _vm.dataInput }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.dataInput = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.error ? _c("div", { staticClass: "alert alert-danger mt-2", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(`
            ` + _vm._s(_vm.error) + `
    `)], 1) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns$c = [], __component__$c = /* @__PURE__ */ normalizeComponent(
  AdministrationGroupsAddBulkUsersModal,
  _sfc_render$c,
  _sfc_staticRenderFns$c,
  !1,
  null,
  null
);
const UserGroupAddBulkUsersModal = __component__$c.exports;
var __defProp$8 = Object.defineProperty, __getOwnPropDesc$b = Object.getOwnPropertyDescriptor, __decorateClass$b = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$b(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$8(target, key, result), result;
}, "__decorateClass$b"), _a14;
let userGroupEditorComponent = (_a14 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "saving", !1);
    __publicField(this, "filterText", null);
    __publicField(this, "assignType", null);
    __publicField(this, "hasWritePermission", !1);
    __publicField(this, "hasDeletePermission", !1);
  }
  async mounted() {
    this.hasWritePermission = await userHasPermission("users.groups.write"), this.hasDeletePermission = await userHasPermission("users.groups.delete");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get users() {
    return this.model.users;
  }
  removeUserGroup() {
    this.$bvModal.show("delete-group-modal");
  }
  removeUserGroupContinue() {
    this.$bvModal.hide("delete-group-modal"), this.$emit("removeUserGroup", this.model);
  }
  save(value) {
    this.$emit("save", value);
  }
  cancel() {
    this.$emit("cancel");
  }
  get userGroupName() {
    return this.model.name;
  }
  set userGroupName(value) {
    this.model = { ...this.model, name: value };
  }
  get description() {
    return this.model.description;
  }
  set description(value) {
    this.model = { ...this.model, description: value };
  }
  get canSave() {
    return !this.$validator.errors.any();
  }
  deleteUser(user) {
    var index2 = this.model.users.indexOf(user);
    this.model.users.splice(index2, 1);
  }
  showAddUserModal(assignType) {
    this.assignType = assignType, this.$bvModal.show("add-user-modal");
  }
  addNewUser(user) {
    this.model.users.push(user);
  }
  showAddCsvUsersModal() {
    this.$bvModal.show("bulk-add-users-modal");
  }
  addUserFromSearch(user) {
    user != null && this.model.users.push(
      {
        id: v4(),
        source: "EWA",
        email: user.email,
        name: user.name,
        userId: user.id
      }
    );
  }
  showUserSelectModal() {
    this.$bvModal.show("userGroupEditorUserSelectorModal");
  }
  get tableFields() {
    return [
      { key: "userId", sortable: !0, tdClass: "align-middle", thClass: "text-nowrap" },
      { key: "name", sortable: !0, tdClass: "align-middle", thClass: "text-nowrap" },
      { key: "email", sortable: !0, tdClass: "align-middle", thClass: "text-nowrap" },
      { key: "source", sortable: !0, tdClass: "align-middle", thClass: "text-nowrap" },
      { key: "delete", sortable: !1, label: "" }
    ];
  }
}, __name(_a14, "userGroupEditorComponent"), _a14);
__decorateClass$b([
  Prop({ required: !0 })
], userGroupEditorComponent.prototype, "value", 2);
userGroupEditorComponent = __decorateClass$b([
  Component({
    components: { UserGroupDeleteModal, UserGroupAddUserModal, UserGroupAddBulkUsersModal, UserSelectorModal },
    inject: [
      "$validator"
    ]
  })
], userGroupEditorComponent);
var _sfc_render$b = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v(`Summary
			`), _vm.model.id ? _vm._e() : [_vm._v(" "), _c("small", [_vm._v("(New User Group)")])], _vm._v(" "), _vm.model && _vm.model.id && _vm.hasDeletePermission ? _c("button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-danger float-right", attrs: { title: "Remove the user group" }, on: { click: _vm.removeUserGroup } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
			`)], 1) : _vm._e()], 2), _vm._v(" "), _vm.value.key ? _c("b-alert", { staticClass: "font-weight-bold", attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "link" } }), _vm._v(`
      This group has been synced from your authentication provider and therefore you cannot edit any of its properties
    `)], 1) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.userGroupName, expression: "userGroupName" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("name"), disabled: _vm.saving }, attrs: { readonly: _vm.value.key, placeholder: "e.g. Admin Users", name: "name", disabled: _vm.saving || !_vm.hasWritePermission }, domProps: { value: _vm.userGroupName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.userGroupName = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("name")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Name for the User Group")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("description") } }, [_c("label", [_vm._v("Description")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.description, expression: "description" }], staticClass: "form-control", attrs: { readonly: _vm.value.key, placeholder: "e.g. Specific locations or teams", name: "description", disabled: _vm.saving || !_vm.hasWritePermission }, domProps: { value: _vm.description }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.description = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Short description for the User Group")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Users")]), _vm._v(" "), _c("b-badge", { staticClass: "small", attrs: { small: "", variant: "info", pill: "" } }, [_vm._v(_vm._s(_vm.users.length))]), _vm._v(" "), _vm.hasWritePermission && !_vm.value.key ? _c("b-dropdown", { ref: "createDropdown", staticClass: "m-md-2", attrs: { "no-flip": "", variant: "outline-primary", size: "sm" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "user-plus" } }), _vm._v(` Assign User
          `)];
  }, "fn"), proxy: !0 }], null, !1, 3031990786) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: _vm.showUserSelectModal } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "search" } }), _vm._v(" By Search")], 1), _vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.showAddUserModal("email");
  }, "click") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "at" } }), _vm._v(" By Email")], 1), _vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.showAddUserModal("userId");
  }, "click") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "id-badge" } }), _vm._v(" By User ID")], 1), _vm._v(" "), _c("b-dropdown-item", { on: { click: _vm.showAddCsvUsersModal } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "file-csv" } }), _vm._v(" By CSV")], 1)], 1) : _vm._e(), _vm._v(" "), _c("b-table", { attrs: { items: _vm.users, fields: _vm.tableFields, striped: "", hover: "", "sort-icon-left": "", filter: _vm.filterText, "filter-included-fields": ["name", "email"], "show-empty": "", responsive: "" }, scopedSlots: _vm._u([{ key: "empty", fn: /* @__PURE__ */ __name(function(scope) {
    return [_c("i", { staticClass: "text-muted" }, [_vm._v("There are no users in this group")])];
  }, "fn") }, _vm.hasWritePermission && !_vm.value.key ? { key: "cell(delete)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right text-nowrap" }, [_c("span", [_c("b-button", { attrs: { size: "sm", variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteUser(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "user-minus" } }), _vm._v(` Unassign
                        `)], 1)], 1)])];
  }, "fn") } : null], null, !0) })], 1), _vm._v(" "), _vm.hasWritePermission && !_vm.value.key ? _c("div", { staticClass: "form-group mt-2" }, [_c("button", { staticClass: "btn btn-success", attrs: { disabled: !_vm.canSave || _vm.saving }, on: { click: _vm.save } }, [_c("font-awesome-icon", { attrs: { icon: _vm.saving ? "sync" : "save", spin: _vm.saving } }), _vm._v(` Save
			`)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default", attrs: { disabled: _vm.saving }, on: { click: _vm.cancel } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Cancel
			`)], 1)]) : _vm._e(), _vm._v(" "), _c("user-group-delete-modal", { attrs: { "delete-group": _vm.value }, on: { confirm: _vm.removeUserGroupContinue } }), _vm._v(" "), _c("user-group-add-user-modal", { attrs: { "assign-type": _vm.assignType }, on: { addUser: _vm.addNewUser } }), _vm._v(" "), _c("user-group-add-bulk-users-modal", { on: { addUser: _vm.addNewUser } }), _vm._v(" "), _c("user-selector-modal", { attrs: { "modal-id": "userGroupEditorUserSelectorModal", "close-on-selection": !0, types: ["user", "profile"] }, on: { userSelected: _vm.addUserFromSearch } })], 1);
}, "render"), _sfc_staticRenderFns$b = [], __component__$b = /* @__PURE__ */ normalizeComponent(
  userGroupEditorComponent,
  _sfc_render$b,
  _sfc_staticRenderFns$b,
  !1,
  null,
  "412137c8"
);
const UserGroupEditor = __component__$b.exports;
var __defProp$7 = Object.defineProperty, __getOwnPropDesc$a = Object.getOwnPropertyDescriptor, __decorateClass$a = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$a(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$7(target, key, result), result;
}, "__decorateClass$a"), _a15;
let AdministrationGroupsSyncGroupsModal = (_a15 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "syncGroups");
    __publicField(this, "getSyncing");
    __publicField(this, "checkCanSync");
  }
  get syncing() {
    return this.getSyncing;
  }
  async confirm() {
    await this.syncGroups(), this.$bvModal.hide("sync-groups-modal");
  }
}, __name(_a15, "AdministrationGroupsSyncGroupsModal"), _a15);
__decorateClass$a([
  Action("administration/users/groups/actions/sync")
], AdministrationGroupsSyncGroupsModal.prototype, "syncGroups", 2);
__decorateClass$a([
  Getter("administration/users/groups/getters/syncing")
], AdministrationGroupsSyncGroupsModal.prototype, "getSyncing", 2);
__decorateClass$a([
  Action("administration/users/groups/actions/checkSync")
], AdministrationGroupsSyncGroupsModal.prototype, "checkCanSync", 2);
AdministrationGroupsSyncGroupsModal = __decorateClass$a([
  Component({})
], AdministrationGroupsSyncGroupsModal);
var _sfc_render$a = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "sync-groups-modal", "no-close-on-backdrop": "", "cancel-variant": "", "hide-header-close": "" }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(`
             Sync User Groups
        `)], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary", size: "sm", disabled: _vm.syncing }, on: { click: cancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "primary", size: "sm", disabled: _vm.syncing }, on: { click: _vm.confirm } }, [_vm.syncing ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(` Syncing
            `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(` Sync Groups
            `)], 1)])];
  }, "fn") }]) }, [_vm._v(" "), _c("b-alert", { staticClass: "mb-0", attrs: { variant: "info", show: "" } }, [_c("p", { staticClass: "font-weight-bold" }, [_c("font-awesome-icon", { attrs: { icon: "question-circle" } }), _vm._v(`
            Are you sure you want to manually sync the user groups with the authorisation provider?
        `)], 1), _vm._v(" "), _c("ul", [_c("li", [_vm._v("This process may take a while depending on the number of groups/users")]), _vm._v(" "), _c("li", [_vm._v("It is recommended against changing any user groups while the sync is in progress")])])])], 1);
}, "render"), _sfc_staticRenderFns$a = [], __component__$a = /* @__PURE__ */ normalizeComponent(
  AdministrationGroupsSyncGroupsModal,
  _sfc_render$a,
  _sfc_staticRenderFns$a,
  !1,
  null,
  null
);
const userSyncModal = __component__$a.exports;
var __defProp$6 = Object.defineProperty, __getOwnPropDesc$9 = Object.getOwnPropertyDescriptor, __decorateClass$9 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$9(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$6(target, key, result), result;
}, "__decorateClass$9"), _a16;
let AdministrationSyncEnabled$1 = (_a16 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
  }
  get syncEnabled() {
    return this.model.syncEnabled;
  }
  set syncEnabled(syncEnabled) {
    this.model = { ...this.model, syncEnabled };
  }
  get syncAllEnabled() {
    return this.model.syncAllEnabled;
  }
  set syncAllEnabled(syncAllEnabled) {
    this.model = { ...this.model, syncAllEnabled };
  }
}, __name(_a16, "AdministrationSyncEnabled"), _a16);
__decorateClass$9([
  VModel({ required: !0 })
], AdministrationSyncEnabled$1.prototype, "model", 2);
AdministrationSyncEnabled$1 = __decorateClass$9([
  Component({
    components: {}
  })
], AdministrationSyncEnabled$1);
var _sfc_render$9 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-form-group", { attrs: { label: "", description: "Enables or disables syncing of groups with the authentication provider" } }, [_c("b-checkbox", { attrs: { switch: "" }, model: { value: _vm.syncEnabled, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.syncEnabled = $$v;
  }, "callback"), expression: "syncEnabled" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Sync Groups")])])], 1), _vm._v(" "), _c("b-form-group", { attrs: { label: "", description: "Whether to sync all groups, or use a configured list of conditions to sync instead", disabled: !_vm.syncEnabled } }, [_c("b-checkbox", { attrs: { switch: "" }, model: { value: _vm.syncAllEnabled, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.syncAllEnabled = $$v;
  }, "callback"), expression: "syncAllEnabled" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Sync All Groups")])])], 1)], 1);
}, "render"), _sfc_staticRenderFns$9 = [], __component__$9 = /* @__PURE__ */ normalizeComponent(
  AdministrationSyncEnabled$1,
  _sfc_render$9,
  _sfc_staticRenderFns$9,
  !1,
  null,
  null
);
const AdministrationSyncEnabled = __component__$9.exports;
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor, __decorateClass$8 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$8"), _a17;
let AdministrationAzureSyncConfig = (_a17 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
    __publicField(this, "loading");
    __publicField(this, "filterText", "");
    __publicField(this, "propertyOptions", [{ text: "Id", value: "id" }, { text: "Name", value: "displayName" }]);
    __publicField(this, "operatorOptions", [{ text: "Equals", value: "equal" }, { text: "Starts With", value: "startsWith" }]);
    __publicField(this, "fields", [
      { key: "type", label: "Property" },
      { key: "comparisonOperator", label: "Operator" },
      { key: "value", label: "Value" },
      { key: "actions", label: "" }
    ]);
  }
  mounted() {
  }
  addManualRule() {
    this.model.syncRules.push({
      type: "displayName",
      comparisonOperator: "equal"
    });
  }
  addFromSearch() {
    this.$bvModal.show("addGroupSyncModal");
  }
  addRuleFromSearch(user) {
    this.model.syncRules.push({
      type: "id",
      comparisonOperator: "equal",
      value: user.id,
      displayName: user.name
    });
  }
  deleteSyncRule(syncEntry) {
    this.model.syncRules = this.model.syncRules.filter((obj) => obj !== syncEntry);
  }
}, __name(_a17, "AdministrationAzureSyncConfig"), _a17);
__decorateClass$8([
  VModel({ required: !0 })
], AdministrationAzureSyncConfig.prototype, "model", 2);
__decorateClass$8([
  Prop()
], AdministrationAzureSyncConfig.prototype, "loading", 2);
AdministrationAzureSyncConfig = __decorateClass$8([
  Component({ components: { UserSelectorModal } })
], AdministrationAzureSyncConfig);
var _sfc_render$8 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(`
          Sync Rules
            `), _c("b-dropdown", { attrs: { "no-flip": "", size: "sm", variant: "primary", "no-caret": "", right: "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(`
                  Add Rule
                `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: _vm.addManualRule } }, [_c("font-awesome-icon", { attrs: { icon: "edit" } }), _vm._v(` Manual Rule
                `)], 1), _vm._v(" "), _c("b-dropdown-item", { on: { click: _vm.addFromSearch } }, [_c("font-awesome-icon", { attrs: { icon: "search" } }), _vm._v(` From Search
                `)], 1)], 1)], 1), _vm._v(" "), _c("b-input-group", { staticClass: "pb-2", attrs: { size: "sm" } }, [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1), _vm._v(" "), _c("b-form-input", { attrs: { disabled: _vm.loading, type: "search", placeholder: "Filter results..." }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1), _vm._v(" "), _c("b-table", { attrs: { fields: _vm.fields, items: _vm.model.syncRules, busy: _vm.loading, "filter-included-fields": ["type", "value"], filter: _vm.filterText, "show-empty": "" }, scopedSlots: _vm._u([{ key: "empty", fn: /* @__PURE__ */ __name(function(scope) {
    return [_c("i", { staticClass: "text-muted" }, [_vm._v("There are no sync rules configured")])];
  }, "fn") }, { key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(type)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-form-select", { attrs: { options: _vm.propertyOptions, disabled: data.item.displayName }, model: { value: data.item.type, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(data.item, "type", $$v);
    }, "callback"), expression: "data.item.type" } })];
  }, "fn") }, { key: "cell(comparisonOperator)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-form-select", { attrs: { options: _vm.operatorOptions, disabled: data.item.displayName }, model: { value: data.item.comparisonOperator, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(data.item, "comparisonOperator", $$v);
    }, "callback"), expression: "data.item.comparisonOperator" } })];
  }, "fn") }, { key: "cell(value)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.displayName ? _c("b-form-input", { attrs: { value: data.item.displayName + " (" + data.item.value + ")", disabled: !0 } }) : _c("b-form-input", { model: { value: data.item.value, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(data.item, "value", $$v);
    }, "callback"), expression: "data.item.value" } })];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right align-middle" }, [_c("b-button", { attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteSyncRule(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)], 1)];
  }, "fn") }]) })], 1), _vm._v(" "), _c("user-selector-modal", { attrs: { "modal-id": "addGroupSyncModal", "close-on-selection": "true", "show-done-button": !1, "modal-header-text": "Add Group to Sync", "modal-header-icon": "user-tag", allowGroupQuery: !0, types: ["role"], "show-advanced-button": !1 }, on: { userSelected: _vm.addRuleFromSearch } })], 1);
}, "render"), _sfc_staticRenderFns$8 = [], __component__$8 = /* @__PURE__ */ normalizeComponent(
  AdministrationAzureSyncConfig,
  _sfc_render$8,
  _sfc_staticRenderFns$8,
  !1,
  null,
  null
);
const AzureConfigComponent = __component__$8.exports;
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor, __decorateClass$7 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$7"), _a18;
let AdministrationActiveDirectorySyncConfig = (_a18 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model");
    __publicField(this, "loading");
    __publicField(this, "filterText", "");
    __publicField(this, "propertyOptions", [{ text: "ID", value: "id" }, { text: "Name", value: "name" }]);
    __publicField(this, "operatorOptions", [
      { text: "Equals", value: "equal" },
      { text: "Starts With", value: "startsWith" },
      { text: "Ends With", value: "endsWith" },
      { text: "Contains", value: "contains" }
    ]);
    __publicField(this, "fields", [
      { key: "type", label: "Property" },
      { key: "comparisonOperator", label: "Operator" },
      { key: "value", label: "Value" },
      { key: "actions", label: "" }
    ]);
  }
  mounted() {
  }
  addManualRule() {
    this.model.syncRules.push({
      type: "name",
      comparisonOperator: "equal"
    });
  }
  addFromSearch() {
    this.$bvModal.show("addGroupSyncModal");
  }
  addRuleFromSearch(user) {
    this.model.syncRules.push({
      type: "id",
      comparisonOperator: "equal",
      value: user.id,
      displayName: user.name
    });
  }
  deleteSyncRule(syncEntry) {
    this.model.syncRules = this.model.syncRules.filter((obj) => obj !== syncEntry);
  }
}, __name(_a18, "AdministrationActiveDirectorySyncConfig"), _a18);
__decorateClass$7([
  VModel({ required: !0 })
], AdministrationActiveDirectorySyncConfig.prototype, "model", 2);
__decorateClass$7([
  Prop()
], AdministrationActiveDirectorySyncConfig.prototype, "loading", 2);
AdministrationActiveDirectorySyncConfig = __decorateClass$7([
  Component({ components: { UserSelectorModal } })
], AdministrationActiveDirectorySyncConfig);
var _sfc_render$7 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(`
          Sync Rules
            `), _c("b-dropdown", { attrs: { "no-flip": "", size: "sm", variant: "primary", "no-caret": "", right: "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(`
                  Add Rule
                `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: _vm.addManualRule } }, [_c("font-awesome-icon", { attrs: { icon: "edit" } }), _vm._v(` Manual Rule
                `)], 1), _vm._v(" "), _c("b-dropdown-item", { on: { click: _vm.addFromSearch } }, [_c("font-awesome-icon", { attrs: { icon: "search" } }), _vm._v(` From Search
                `)], 1)], 1)], 1), _vm._v(" "), _c("b-input-group", { staticClass: "pb-2", attrs: { size: "sm" } }, [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1), _vm._v(" "), _c("b-form-input", { attrs: { disabled: _vm.loading, type: "search", placeholder: "Filter results..." }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1), _vm._v(" "), _c("b-table", { attrs: { fields: _vm.fields, items: _vm.model.syncRules, busy: _vm.loading, "filter-included-fields": ["type", "value"], filter: _vm.filterText, "show-empty": "" }, scopedSlots: _vm._u([{ key: "empty", fn: /* @__PURE__ */ __name(function(scope) {
    return [_c("i", { staticClass: "text-muted" }, [_vm._v("There are no sync rules configured")])];
  }, "fn") }, { key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(type)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-form-select", { attrs: { options: _vm.propertyOptions, disabled: data.item.displayName }, model: { value: data.item.type, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(data.item, "type", $$v);
    }, "callback"), expression: "data.item.type" } })];
  }, "fn") }, { key: "cell(comparisonOperator)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-form-select", { attrs: { options: _vm.operatorOptions, disabled: data.item.displayName }, model: { value: data.item.comparisonOperator, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(data.item, "comparisonOperator", $$v);
    }, "callback"), expression: "data.item.comparisonOperator" } })];
  }, "fn") }, { key: "cell(value)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.displayName ? _c("b-form-input", { attrs: { value: data.item.displayName + " (" + data.item.value + ")", disabled: !0 } }) : _c("b-form-input", { model: { value: data.item.value, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.$set(data.item, "value", $$v);
    }, "callback"), expression: "data.item.value" } })];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right align-middle" }, [_c("b-button", { attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteSyncRule(data.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)], 1)];
  }, "fn") }]) })], 1), _vm._v(" "), _c("user-selector-modal", { attrs: { "modal-id": "addGroupSyncModal", "close-on-selection": "true", "show-done-button": !1, "modal-header-text": "Add Group to Sync", "modal-header-icon": "user-tag", allowGroupQuery: !0, types: ["role"], "show-advanced-button": !1 }, on: { userSelected: _vm.addRuleFromSearch } })], 1);
}, "render"), _sfc_staticRenderFns$7 = [], __component__$7 = /* @__PURE__ */ normalizeComponent(
  AdministrationActiveDirectorySyncConfig,
  _sfc_render$7,
  _sfc_staticRenderFns$7,
  !1,
  null,
  null
);
const ActiveDirectoryConfigComponent = __component__$7.exports;
var __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$6"), _a19;
let AdministrationGroupSyncConfigureModal = (_a19 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model", null);
    __publicField(this, "saving", !1);
    __publicField(this, "loading", !1);
  }
  async modalShown() {
    this.saving = !1, await this.loadConfig();
  }
  async loadConfig() {
    try {
      this.loading = !0;
      let syncConfig = await new AdministrationGroupsClient(new Transformer(), baseUrl()).getSyncConfig();
      this.model = syncConfig.config;
    } catch (ex) {
      console.log(ex), toastr.error("An error occured" + ex);
    } finally {
      this.loading = !1;
    }
  }
  async saveConfig() {
    try {
      this.saving = !0, await new AdministrationGroupsClient(new Transformer(), baseUrl()).saveSyncConfig(this.model), toastr.success("Sync configuration has been saved!"), this.$bvModal.hide("configure-group-sync-modal");
    } catch (ex) {
      toastr.error("An error occured" + ex);
    } finally {
      this.saving = !1;
    }
  }
  get configComponent() {
    return configs.find((y) => y.configType == this.model.configType).component;
  }
}, __name(_a19, "AdministrationGroupSyncConfigureModal"), _a19);
AdministrationGroupSyncConfigureModal = __decorateClass$6([
  Component({
    components: { AdministrationSyncEnabled }
  })
], AdministrationGroupSyncConfigureModal);
const configs = [
  {
    configType: "azure",
    component: AzureConfigComponent
  },
  {
    configType: "ad",
    component: ActiveDirectoryConfigComponent
  }
];
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "xl", id: "configure-group-sync-modal", "no-close-on-backdrop": "", "cancel-variant": "", "hide-header-close": "" }, on: { shown: _vm.modalShown }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "cog" } }), _vm._v(`
             Configure Group Sync Rules
        `)], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary", size: "sm", disabled: _vm.saving }, on: { click: cancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { attrs: { variant: "success", size: "sm", disabled: _vm.saving }, on: { click: _vm.saveConfig } }, [_vm.saving ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(` Saving
            `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save Config
            `)], 1)])];
  }, "fn") }]) }, [_vm._v(" "), _vm.loading ? _c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1) : _c("div", [_vm.model ? _c("administration-sync-enabled", { model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } }) : _vm._e(), _vm._v(" "), _vm.model && _vm.model.syncEnabled && !_vm.model.syncAllEnabled ? _c(_vm.configComponent, { tag: "component", attrs: { loading: _vm.loading }, model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } }) : _vm._e()], 1)]);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  AdministrationGroupSyncConfigureModal,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  null
);
const GroupSyncConfigModal = __component__$6.exports;
var __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$5"), _a20;
let AdministrationGroupsDeleteSyncedGroupsModal = (_a20 = class extends Vue {
  confirm() {
    this.$emit("confirm", !0), this.$bvModal.hide("delete-sync-groups-modal");
  }
}, __name(_a20, "AdministrationGroupsDeleteSyncedGroupsModal"), _a20);
AdministrationGroupsDeleteSyncedGroupsModal = __decorateClass$5([
  Component({})
], AdministrationGroupsDeleteSyncedGroupsModal);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { id: "delete-sync-groups-modal", "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Delete Synced User Groups")], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
        Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "danger" }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Confirm
    `)], 1)];
  }, "fn") }]) }, [_vm._v(" "), _c("div", [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "danger", show: "" } }, [_c("p", { staticClass: "font-weight-bold" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" Are you sure you want to delete all provider synced user groups?")], 1), _vm._v(" "), _c("ul", [_c("li", [_vm._v("Access granted via this group will not longer work")]), _vm._v(" "), _c("li", [_vm._v("There is no way to reverse this process")])])])], 1)]);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  AdministrationGroupsDeleteSyncedGroupsModal,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  null
);
const DeleteSyncedGroupModal = __component__$5.exports;
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$4"), _a21;
let UserGroupManagerComponent = (_a21 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "createUserGroup");
    __publicField(this, "editUserGroup");
    __publicField(this, "userGroupsGetter");
    __publicField(this, "getEditing");
    __publicField(this, "setEditing");
    __publicField(this, "disableUserGroup");
    __publicField(this, "deleteSyncedGroups");
    __publicField(this, "loadUserGroupsAction");
    __publicField(this, "cancelEditing");
    __publicField(this, "saveEditing");
    __publicField(this, "syncGroups");
    __publicField(this, "getSyncing");
    __publicField(this, "getCanSync");
    __publicField(this, "checkCanSync");
    __publicField(this, "cancelSync");
    __publicField(this, "getSyncStatus");
    __publicField(this, "setFilter");
    __publicField(this, "canConfigureSync");
    __publicField(this, "filterModel");
    __publicField(this, "groupCount");
    __publicField(this, "totalCount");
    __publicField(this, "syncStatus");
    __publicField(this, "syncRunning");
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "saving", !1);
    __publicField(this, "hasDeletePermission", !1);
    __publicField(this, "selectedItem");
    __publicField(this, "hasWritePermission", !1);
    __publicField(this, "filterDebounce", _.debounce(function(filterModel) {
      this.loadUserGroups(filterModel);
    }, 200, { trailing: !0 }));
    __publicField(this, "reloadTimer", null);
  }
  async mounted() {
    this.hasWritePermission = await userHasPermission("users.groups.write"), this.hasDeletePermission = await userHasPermission("users.groups.delete"), await this.loadUserGroups(), await this.checkCanSync(), this.canSync && (await this.getSyncStatus(), this.syncRunning && (this.reloadTimer = setInterval(() => this.getSyncStatus(), 3e3)));
  }
  get page() {
    return this.filterModel.page;
  }
  set page(value) {
    var filterModel = { ...this.filterModel, page: value };
    this.loadUserGroups(filterModel);
  }
  get filterText() {
    return this.filterModel.filter;
  }
  set filterText(value) {
    var filterModel = { ...this.filterModel, page: 1, filter: value };
    this.filterDebounce(filterModel);
  }
  get canSync() {
    return this.getCanSync;
  }
  get syncing() {
    return this.getSyncing;
  }
  get userGroups() {
    return this.userGroupsGetter;
  }
  syncChanged(newVal, oldVal) {
    newVal === !0 && oldVal === !1 ? this.reloadTimer = setInterval(() => this.getSyncStatus(), 3e3) : newVal === !1 && oldVal === !0 && (this.reloadTimer && clearTimeout(this.reloadTimer), toastr.success("Group sync has finished!"), this.loadUserGroups());
  }
  async cancelGroupSync() {
    await this.cancelSync(), toastr.warning("The group sync task has been cancelled"), await this.getSyncStatus(), await this.loadUserGroups();
  }
  async removeUserGroup(userGroup) {
    if (userGroup != null)
      try {
        await this.disableUserGroup(userGroup.id), await this.loadUserGroups(), this.editing = null, toastr.success("User Group removed");
      } catch (e) {
        toastr.error(e, "Failed to remove user group");
      }
  }
  async removeSyncedUserGroupsContinue() {
    try {
      await this.deleteSyncedGroups(), this.editing = null, toastr.success("Removed all synced user groups");
    } catch (e) {
      toastr.error(e, "Failed to remove synced user groups");
    }
  }
  showSyncModal() {
    if (this.syncRunning) {
      toastr.info("A group sync is already in progress.");
      return;
    }
    this.$bvModal.show("sync-groups-modal");
  }
  showConfigureSyncModal() {
    this.$bvModal.show("configure-group-sync-modal");
  }
  showDeleteSyncedGroupsModal() {
    this.$bvModal.show("delete-sync-groups-modal");
  }
  get editing() {
    return this.getEditing;
  }
  set editing(value) {
    this.setEditing(value);
  }
  get editingId() {
    return this.editing ? this.editing.id : null;
  }
  async loadUserGroups(filter = null) {
    this.loading = !0, this.loadingError = null;
    try {
      filter || (filter = this.filterModel), this.setFilter(filter), await this.loadUserGroupsAction(filter);
    } catch (e) {
      toastr.error(e, "Failed to load user groups"), this.loadingError = e;
    } finally {
      this.loading = !1;
    }
  }
  async validate() {
    let validators = this.$children.map((c) => c.$validator);
    return await Promise.all(validators.map((validator) => validator.validateAll())).then((result) => result.every((valid) => valid));
  }
  async save() {
    if (!await this.validate()) {
      toastr.error("Could not save, some values are missing.");
      return;
    }
    this.saving = !0;
    try {
      await this.saveEditing(), toastr.success("Saved user group successfully");
    } catch (e) {
      toastr.error(e, "Failed to save user group");
    } finally {
      this.saving = !1;
    }
  }
  async cancel() {
    try {
      await this.cancelEditing();
    } catch (e) {
      toastr.error(e, "Failed to cancel ");
    }
  }
}, __name(_a21, "UserGroupManagerComponent"), _a21);
__decorateClass$4([
  Action("administration/users/groups/actions/createUserGroup")
], UserGroupManagerComponent.prototype, "createUserGroup", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/editUserGroup")
], UserGroupManagerComponent.prototype, "editUserGroup", 2);
__decorateClass$4([
  Getter("administration/users/groups/getters/userGroups")
], UserGroupManagerComponent.prototype, "userGroupsGetter", 2);
__decorateClass$4([
  Getter("administration/users/groups/getters/editing")
], UserGroupManagerComponent.prototype, "getEditing", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/updateEditing")
], UserGroupManagerComponent.prototype, "setEditing", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/removeUserGroup")
], UserGroupManagerComponent.prototype, "disableUserGroup", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/removeSyncedGroups")
], UserGroupManagerComponent.prototype, "deleteSyncedGroups", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/loadUserGroups")
], UserGroupManagerComponent.prototype, "loadUserGroupsAction", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/cancel")
], UserGroupManagerComponent.prototype, "cancelEditing", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/save")
], UserGroupManagerComponent.prototype, "saveEditing", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/sync")
], UserGroupManagerComponent.prototype, "syncGroups", 2);
__decorateClass$4([
  Getter("administration/users/groups/getters/syncing")
], UserGroupManagerComponent.prototype, "getSyncing", 2);
__decorateClass$4([
  Getter("administration/users/groups/getters/canSync")
], UserGroupManagerComponent.prototype, "getCanSync", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/checkSync")
], UserGroupManagerComponent.prototype, "checkCanSync", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/cancelSync")
], UserGroupManagerComponent.prototype, "cancelSync", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/getSyncStatus")
], UserGroupManagerComponent.prototype, "getSyncStatus", 2);
__decorateClass$4([
  Action("administration/users/groups/actions/setFilter")
], UserGroupManagerComponent.prototype, "setFilter", 2);
__decorateClass$4([
  Getter("administration/users/groups/getters/canConfigureSync")
], UserGroupManagerComponent.prototype, "canConfigureSync", 2);
__decorateClass$4([
  Getter("administration/users/groups/getters/filterModel")
], UserGroupManagerComponent.prototype, "filterModel", 2);
__decorateClass$4([
  Getter("administration/users/groups/getters/groupCount")
], UserGroupManagerComponent.prototype, "groupCount", 2);
__decorateClass$4([
  Getter("administration/users/groups/getters/totalCount")
], UserGroupManagerComponent.prototype, "totalCount", 2);
__decorateClass$4([
  Getter("administration/users/groups/getters/sync/status")
], UserGroupManagerComponent.prototype, "syncStatus", 2);
__decorateClass$4([
  Getter("administration/users/groups/getters/sync/running")
], UserGroupManagerComponent.prototype, "syncRunning", 2);
__decorateClass$4([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], UserGroupManagerComponent.prototype, "selectedItem", 2);
__decorateClass$4([
  Watch("syncRunning")
], UserGroupManagerComponent.prototype, "syncChanged", 1);
UserGroupManagerComponent = __decorateClass$4([
  Component({
    components: {
      UserGroupEditor,
      userSyncModal,
      GroupSyncConfigModal,
      DeleteSyncedGroupModal,
      PaginationControls
    }
  })
], UserGroupManagerComponent);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("h3", [_c("font-awesome-icon", { attrs: { icon: "users-class" } }), _vm._v(`
                 User Groups `), _c("b-badge", { staticClass: "small", attrs: { small: "", variant: "info", pill: "" } }, [_vm._v(_vm._s(_vm.totalCount))]), _vm._v(" "), _vm.hasWritePermission ? _c("b-button", { attrs: { variant: "primary", size: "sm" }, on: { click: _vm.createUserGroup } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add User Group
                `)], 1) : _vm._e(), _vm._v(" "), _vm.canSync ? _c("b-dropdown", { attrs: { "no-flip": "", size: "sm", variant: "primary", split: "" }, on: { click: _vm.showSyncModal }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    return [_vm.syncRunning ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: !0 } }), _vm._v(` Syncing Groups...
                    `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(` Sync Groups
                    `)], 1)];
  }, "fn"), proxy: !0 }], null, !1, 1500564681) }, [_vm._v(" "), _vm.canConfigureSync ? _c("b-dropdown-item", { on: { click: _vm.showConfigureSyncModal } }, [_c("font-awesome-icon", { attrs: { icon: "cog" } }), _vm._v(` Configure Sync
                `)], 1) : _vm._e(), _vm._v(" "), _vm.canSync && _vm.hasDeletePermission ? _c("b-dropdown-item", { on: { click: _vm.showDeleteSyncedGroupsModal } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Remove Synced Groups
                `)], 1) : _vm._e(), _vm._v(" "), _vm.canSync ? _c("b-dropdown-item", { attrs: { disabled: !_vm.syncRunning }, on: { click: _vm.cancelGroupSync } }, [_c("font-awesome-icon", { attrs: { icon: "xmark" } }), _vm._v(` Cancel Group Sync
                `)], 1) : _vm._e()], 1) : _vm._e()], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", { staticClass: "mb-1", attrs: { cols: "5" } }, [_c("b-input-group", { scopedSlots: _vm._u([{ key: "prepend", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-input", { attrs: { placeholder: "Filter Groups..." }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1)], 1)], 1), _vm._v(" "), _c("b-row", [_c("div", { staticClass: "col-md-5" }, [_vm.userGroups && _vm.userGroups.length ? _c("div", { staticStyle: { "overflow-y": "scroll", height: "75vh" } }, [_c("b-list-group", { ref: "actions" }, _vm._l(_vm.userGroups, function(userGroup) {
    return _c("b-list-group-item", { key: userGroup.id, class: { active: userGroup.id === _vm.editingId }, attrs: { id: userGroup.id, href: "#" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editUserGroup(userGroup.id);
    }, "click") } }, [_c("h4", { staticClass: "list-group-item-heading" }, [userGroup.name ? [_vm._v(`
                            ` + _vm._s(userGroup.name) + `
                            `), _c("b-badge", { staticClass: "small", attrs: { small: "", variant: "info", pill: "" } }, [_vm._v(_vm._s(userGroup.users.length))]), _vm._v(" "), userGroup.key ? _c("font-awesome-icon", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { icon: "link", title: "Synced from Authentication Provider" } }) : _vm._e()] : [_vm._v("Unnamed User Group")], _vm._v(" "), _c("span", { staticClass: "float-right" }, [userGroup.id === _vm.editingId ? _c("font-awesome-icon", { attrs: { icon: "arrow-right" } }) : _vm._e()], 1)], 2), _vm._v(" "), userGroup.description ? _c("span", { staticClass: "list-group-item-text" }, [_vm._v(_vm._s(userGroup.description) + " "), _c("br")]) : _vm._e()]);
  }), 1), _vm._v(" "), _c("pagination-controls", { attrs: { "pagination-controls": "", count: Math.ceil(this.groupCount / this.filterModel.pageSize) }, model: { value: _vm.page, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.page = $$v;
  }, "callback"), expression: "page" } })], 1) : _c("div", { staticClass: "alert alert-info" }, [_vm._v("No user groups currently configured")])]), _vm._v(" "), _vm.editing ? _c("div", { staticClass: "col-md-7" }, [_c("user-group-editor", { on: { save: _vm.save, cancel: _vm.cancel, removeUserGroup: _vm.removeUserGroup }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } })], 1) : _vm._e()]), _vm._v(" "), _c("user-sync-modal"), _vm._v(" "), _c("group-sync-config-modal"), _vm._v(" "), _c("delete-synced-group-modal", { on: { confirm: _vm.removeSyncedUserGroupsContinue } })], 1);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  UserGroupManagerComponent,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  null
);
const AdministrationGroupsComponent = __component__$4.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$3"), _a22;
let AdministrationUserDefinedValueModal = (_a22 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "deleteDefinition");
  }
  confirm() {
    this.$emit("confirm"), this.$bvModal.hide("delete-definition-modal");
  }
}, __name(_a22, "AdministrationUserDefinedValueModal"), _a22);
__decorateClass$3([
  Prop({ required: !0 })
], AdministrationUserDefinedValueModal.prototype, "deleteDefinition", 2);
AdministrationUserDefinedValueModal = __decorateClass$3([
  Component({})
], AdministrationUserDefinedValueModal);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { id: "delete-definition-modal", "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Confirm delete - " + _vm._s(_vm.deleteDefinition.displayName))], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
        Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "danger" }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Confirm
    `)], 1)];
  }, "fn") }]) }, [_vm._v(" "), _vm.deleteDefinition ? _c("div", [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "danger", show: "" } }, [_c("p", { staticClass: "font-weight-bold" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } }), _vm._v(" Are you sure you want to delete this user defined value?")], 1), _vm._v(" "), _c("ul", [_c("li", [_vm._v("The existing values will be removed")]), _vm._v(" "), _c("li", [_vm._v("There is no way to reverse this process")])])])], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  AdministrationUserDefinedValueModal,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const userDefinedValueDeleteModal = __component__$3.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$2"), _a23;
let UserDefinedValueEditor = (_a23 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "providerClaims");
    __publicField(this, "userDefinedValuesGetter");
    __publicField(this, "saving", !1);
    __publicField(this, "hasWritePermission", !1);
    __publicField(this, "hasDeletePermission", !1);
    __publicField(this, "manuallyEnterClaim", !1);
  }
  watchValue(newVal, oldValue) {
    newVal.id != oldValue.id && this.setManuallyEnterClaim();
  }
  created() {
    this.$validator.extend("identifierUnique", {
      validate: /* @__PURE__ */ __name((value) => Promise.resolve({
        valid: this.identifierIsValid(value),
        data: value
      }), "validate"),
      getMessage: /* @__PURE__ */ __name(() => "Identifier must be unique", "getMessage")
    });
  }
  async mounted() {
    this.hasWritePermission = await userHasPermission("users.userDefinedValues.write"), this.hasDeletePermission = await userHasPermission("users.userDefinedValues.delete"), this.setManuallyEnterClaim();
  }
  get identifierFullName() {
    return "udv." + this.internalKey;
  }
  identifierIsValid(value) {
    return this.value.id ? !0 : !this.userDefinedValuesGetter.map((pc) => pc.internalKey.toLowerCase()).includes(value);
  }
  setManuallyEnterClaim() {
    this.providerClaims.length ? this.manuallyEnterClaim = !this.providerClaims.map((pc) => pc.value).includes(this.externalKey) && this.externalKey.length > 0 : this.manuallyEnterClaim = !0;
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  showDeleteDefinedValueModal() {
    this.$bvModal.show("delete-definition-modal");
  }
  confirmdeleteDefinedValue() {
    this.$bvModal.hide("delete-definition-modal"), this.$emit("deleteUserDefinedValue", this.model);
  }
  save(value) {
    this.$emit("save", value);
  }
  cancel() {
    this.$emit("cancel");
  }
  get displayName() {
    return this.model.displayName;
  }
  set displayName(value) {
    this.model = { ...this.model, displayName: value };
  }
  get internalKey() {
    return this.model.internalKey;
  }
  set internalKey(value) {
    this.model = { ...this.model, internalKey: value };
  }
  get externalKey() {
    return this.model.externalKey;
  }
  set externalKey(value) {
    this.model = { ...this.model, externalKey: value };
  }
  get defaultValue() {
    return this.model.defaultValue;
  }
  set defaultValue(value) {
    this.model = { ...this.model, defaultValue: value };
  }
  get syncValue() {
    return this.model.syncValue;
  }
  set syncValue(value) {
    this.model = { ...this.model, syncValue: value };
  }
  get public() {
    return this.model.public;
  }
  set public(value) {
    this.model = { ...this.model, public: value };
  }
  get canSave() {
    return !this.$validator.errors.any();
  }
}, __name(_a23, "UserDefinedValueEditor"), _a23);
__decorateClass$2([
  Prop({ required: !0 })
], UserDefinedValueEditor.prototype, "value", 2);
__decorateClass$2([
  Prop({ required: !0 })
], UserDefinedValueEditor.prototype, "providerClaims", 2);
__decorateClass$2([
  Getter("administration/users/definedValues/getters/userDefinedValues")
], UserDefinedValueEditor.prototype, "userDefinedValuesGetter", 2);
__decorateClass$2([
  Watch("value")
], UserDefinedValueEditor.prototype, "watchValue", 1);
UserDefinedValueEditor = __decorateClass$2([
  Component({
    components: { CopyValueButton, userDefinedValueDeleteModal },
    inject: ["$validator"]
  })
], UserDefinedValueEditor);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v(`Summary
			`), _vm.model.id ? _vm._e() : [_c("small", [_vm._v("(New User Defined Value)")])], _vm._v(" "), _vm.model && _vm.model.id && _vm.hasDeletePermission ? _c("button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-danger float-right", attrs: { title: "Remove the user defined value" }, on: { click: _vm.showDeleteDefinedValueModal } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
			`)], 1) : _vm._e()], 2), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.displayName, expression: "displayName" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("displayName"), disabled: _vm.saving }, attrs: { placeholder: "e.g. Spending Limit", name: "displayName", disabled: _vm.saving || !_vm.hasWritePermission }, domProps: { value: _vm.displayName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.displayName = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("displayName") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("displayName")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Display name for the user defined value")])]), _vm._v(" "), _c("b-form-group", { attrs: { id: "identifierGroup", label: "Identifier", "label-for": "identifierInput" } }, [_c("b-input-group", [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_vm._v("udv.")]), _vm._v(" "), _c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required|identifierUnique", expression: "'required|identifierUnique'" }], class: { "is-invalid": _vm.errors.first("internalKey"), disabled: _vm.saving }, attrs: { id: "internalKeyInput", name: "internalKey", placeholder: "e.g. spending-limit", disabled: _vm.model.id || _vm.saving || !_vm.hasWritePermission }, model: { value: _vm.internalKey, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.internalKey = $$v;
  }, "callback"), expression: "internalKey" } }), _vm._v(" "), _c("b-input-group-append", [_c("copy-value-button", { model: { value: _vm.identifierFullName, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.identifierFullName = $$v;
  }, "callback"), expression: "identifierFullName" } })], 1)], 1), _vm._v(" "), _vm.errors.has("internalKey") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("internalKey")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("The short name used to reference this user defined value")])], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("b-form-group", { staticClass: "mb-0" }, [_c("b-checkbox", { attrs: { switch: "" }, model: { value: _vm.public, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.public = $$v;
  }, "callback"), expression: "public" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Public")])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Allows users to see their own user defined values")])], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("b-form-group", { staticClass: "mb-0" }, [_c("b-checkbox", { attrs: { switch: "" }, model: { value: _vm.syncValue, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.syncValue = $$v;
  }, "callback"), expression: "syncValue" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Enable Sync")])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Automatically update this value from the specified claim")])], 1), _vm._v(" "), _vm.syncValue ? _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Claim mapping")]), _vm._v(" "), _c("b-input-group", { scopedSlots: _vm._u([{ key: "append", fn: /* @__PURE__ */ __name(function() {
    return [_vm.providerClaims.length ? _c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.manuallyEnterClaim = !_vm.manuallyEnterClaim;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.manuallyEnterClaim ? "ballot-check" : "pencil" } })], 1) : _vm._e()];
  }, "fn"), proxy: !0 }], null, !1, 2102073574) }, [_vm.manuallyEnterClaim ? _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.externalKey, expression: "externalKey" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("externalKey"), disabled: _vm.saving }, attrs: { placeholder: "e.g. authentication-provider-spending-limit", name: "externalKey", disabled: _vm.saving || !_vm.hasWritePermission }, domProps: { value: _vm.externalKey }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.externalKey = $event.target.value);
  }, "input") } }) : _c("b-form-select", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("externalKey"), disabled: _vm.saving }, attrs: { options: _vm.providerClaims, name: "externalKey", disabled: _vm.saving || !_vm.hasWritePermission }, model: { value: _vm.externalKey, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.externalKey = $$v;
  }, "callback"), expression: "externalKey" } })], 1), _vm._v(" "), _vm.errors.has("externalKey") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("externalKey")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("The claim to map to this user defined value")])], 1) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Default Value")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.defaultValue, expression: "defaultValue" }], staticClass: "form-control", attrs: { placeholder: "e.g. Unknown Spending Limit", disabled: _vm.saving || !_vm.hasWritePermission }, domProps: { value: _vm.defaultValue }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.defaultValue = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("The value that will be used if no value is synced or set")])]), _vm._v(" "), _vm.hasWritePermission ? _c("div", { staticClass: "form-group mt-2" }, [_c("button", { staticClass: "btn btn-success", attrs: { disabled: !_vm.canSave || _vm.saving }, on: { click: _vm.save } }, [_c("font-awesome-icon", { attrs: { icon: _vm.saving ? "sync" : "save", spin: _vm.saving } }), _vm._v(` Save
			`)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default", attrs: { disabled: _vm.saving }, on: { click: _vm.cancel } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(` Cancel
			`)], 1)]) : _vm._e(), _vm._v(" "), _c("user-defined-value-delete-modal", { attrs: { "delete-definition": _vm.value }, on: { confirm: _vm.confirmdeleteDefinedValue } })], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  UserDefinedValueEditor,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "04ccaaa9"
);
const userDefinedValueEditor = __component__$2.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$1"), _a24;
let UserDefinedValueManagerComponent = (_a24 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "createDefinedValue");
    __publicField(this, "editDefinedValue");
    __publicField(this, "userDefinedValuesGetter");
    __publicField(this, "loadDefinedValuesAction");
    __publicField(this, "deleteDefinedValue");
    __publicField(this, "getEditing");
    __publicField(this, "setEditing");
    __publicField(this, "cancelEditing");
    __publicField(this, "saveEditing");
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "saving", !1);
    __publicField(this, "filterText", "");
    __publicField(this, "authenticationSettings", null);
    __publicField(this, "hasWritePermission", !1);
    __publicField(this, "hasDeletePermission", !1);
    __publicField(this, "providerClaims");
    __publicField(this, "localUserClaims", []);
    __publicField(this, "adClaims", [
      { value: "", text: "Please select an option" },
      { value: "http://ewa.ezescan.com.au/account/claims/description", text: "Description" },
      { value: "http://ewa.ezescan.com.au/account/claims/title", text: "Title" },
      { value: "http://ewa.ezescan.com.au/account/claims/office", text: "Office" },
      { value: "http://ewa.ezescan.com.au/account/claims/department", text: "Department" },
      { value: "http://ewa.ezescan.com.au/account/claims/company", text: "Company" }
    ]);
    __publicField(this, "azureClaims", [
      { value: "", text: "Please select an option" },
      { value: "http://ewa.ezescan.com.au/account/claims/title", text: "Title" },
      { value: "http://ewa.ezescan.com.au/account/claims/office", text: "Office" },
      { value: "http://ewa.ezescan.com.au/account/claims/department", text: "Department" },
      { value: "http://ewa.ezescan.com.au/account/claims/company", text: "Company" }
    ]);
  }
  async mounted() {
    this.hasWritePermission = await userHasPermission("users.userDefinedValues.write"), this.hasDeletePermission = await userHasPermission("users.userDefinedValues.delete"), await this.loadUserDefinedValues(), await this.loadProviderSettings();
  }
  async loadProviderSettings() {
    new AdministrationAuthenticationClient(new Transformer(), baseUrl()).getAuthenticationSettings().then((model) => {
      switch (this.authenticationSettings = model, this.authenticationSettings.provider) {
        case AuthenticationProviders.LocalUsers:
          this.providerClaims = this.localUserClaims;
          break;
        case AuthenticationProviders.AzureActiveDirectory:
          this.providerClaims = this.azureClaims;
          break;
        case AuthenticationProviders.ActiveDirectory:
          this.providerClaims = this.adClaims;
          break;
        case AuthenticationProviders.None:
          break;
        default:
          this.providerClaims = this.adClaims;
      }
    }).catch((e) => {
      toastr.error("Something has gone wrong while loading the Authentication settings: " + e);
    }).finally(() => {
      this.loading = !1;
    });
  }
  get userDefinedValues() {
    return this.userDefinedValuesGetter;
  }
  get filteredUserDefinedValues() {
    return this.userDefinedValues.filter((a) => a.displayName.toLocaleLowerCase().includes(this.filterText.toLocaleLowerCase()));
  }
  async deleteUserDefinedValue(definedValue) {
    if (definedValue != null)
      try {
        await this.deleteDefinedValue(definedValue.id), await this.loadUserDefinedValues(), this.editing = null, toastr.info("User defined value removed");
      } catch (e) {
        toastr.error(e, "Failed to remove user defined value");
      }
  }
  get editing() {
    return this.getEditing;
  }
  set editing(value) {
    this.setEditing(value);
  }
  get editingId() {
    return this.editing ? this.editing.id : null;
  }
  async loadUserDefinedValues() {
    this.loading = !0, this.loadingError = null;
    try {
      await this.loadDefinedValuesAction();
    } catch (e) {
      toastr.error(e, "Failed to load user DefinedValues"), this.loadingError = e;
    } finally {
      this.loading = !1;
    }
  }
  async validate() {
    let validators = this.$children.map((c) => c.$validator);
    return await Promise.all(validators.map((validator) => validator.validateAll())).then((result) => result.every((valid) => valid));
  }
  async save() {
    if (!await this.validate()) {
      toastr.error("Could not save, some values are missing.");
      return;
    }
    this.saving = !0;
    try {
      await this.saveEditing(), toastr.success("Saved user defined value successfully");
    } catch (e) {
      toastr.error(e, "Failed to save user group");
    } finally {
      this.saving = !1;
    }
  }
  async cancel() {
    try {
      await this.cancelEditing();
    } catch (e) {
      toastr.error(e, "Failed to cancel ");
    }
  }
}, __name(_a24, "UserDefinedValueManagerComponent"), _a24);
__decorateClass$1([
  Action("administration/users/definedValues/actions/createDefinedValue")
], UserDefinedValueManagerComponent.prototype, "createDefinedValue", 2);
__decorateClass$1([
  Action("administration/users/definedValues/actions/editDefinedValue")
], UserDefinedValueManagerComponent.prototype, "editDefinedValue", 2);
__decorateClass$1([
  Getter("administration/users/definedValues/getters/userDefinedValues")
], UserDefinedValueManagerComponent.prototype, "userDefinedValuesGetter", 2);
__decorateClass$1([
  Action("administration/users/definedValues/actions/loadDefinedValues")
], UserDefinedValueManagerComponent.prototype, "loadDefinedValuesAction", 2);
__decorateClass$1([
  Action("administration/users/definedValues/actions/removeDefinedValue")
], UserDefinedValueManagerComponent.prototype, "deleteDefinedValue", 2);
__decorateClass$1([
  Getter("administration/users/definedValues/getters/editing")
], UserDefinedValueManagerComponent.prototype, "getEditing", 2);
__decorateClass$1([
  Action("administration/users/definedValues/actions/updateEditing")
], UserDefinedValueManagerComponent.prototype, "setEditing", 2);
__decorateClass$1([
  Action("administration/users/definedValues/actions/cancel")
], UserDefinedValueManagerComponent.prototype, "cancelEditing", 2);
__decorateClass$1([
  Action("administration/users/definedValues/actions/save")
], UserDefinedValueManagerComponent.prototype, "saveEditing", 2);
UserDefinedValueManagerComponent = __decorateClass$1([
  Component({
    components: {
      userDefinedValueEditor
    }
  })
], UserDefinedValueManagerComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("h3", [_c("font-awesome-icon", { attrs: { icon: "users-cog" } }), _vm._v(`
                 User Defined Values `), _c("b-badge", { staticClass: "small", attrs: { small: "", variant: "info", pill: "" } }, [_vm._v(_vm._s(_vm.userDefinedValues.length))]), _vm._v(" "), _vm.hasWritePermission ? _c("b-button", { attrs: { variant: "primary", size: "sm" }, on: { click: _vm.createDefinedValue } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Add User Defined Value
                `)], 1) : _vm._e()], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", { staticClass: "mb-1", attrs: { cols: "5" } }, [_c("b-input-group", { scopedSlots: _vm._u([{ key: "prepend", fn: /* @__PURE__ */ __name(function() {
    return [_c("b-input-group-text", [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-input", { attrs: { placeholder: "Filter Definitions..." }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1)], 1)], 1), _vm._v(" "), _c("b-row", [_c("div", { staticClass: "col-md-5" }, [_vm.userDefinedValues && _vm.userDefinedValues.length ? _c("div", { staticStyle: { "overflow-y": "scroll", height: "75vh" } }, [_c("b-list-group", { ref: "actions" }, _vm._l(_vm.filteredUserDefinedValues, function(definedValue) {
    return _c("b-list-group-item", { key: definedValue.id, class: { active: definedValue.id === _vm.editingId }, attrs: { id: definedValue.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editDefinedValue(definedValue.id);
    }, "click") } }, [_c("h4", { staticClass: "list-group-item-heading" }, [definedValue.displayName ? [_vm._v(`
                            ` + _vm._s(definedValue.displayName) + ` 
                        `)] : [_vm._v("Unnamed User Defined Value")], _vm._v(" "), _c("span", { staticClass: "float-right" }, [definedValue.id === _vm.editingId ? _c("font-awesome-icon", { attrs: { icon: "arrow-right" } }) : _vm._e()], 1)], 2)]);
  }), 1)], 1) : _c("div", { staticClass: "alert alert-info" }, [_vm._v("No user defined values currently configured")])]), _vm._v(" "), _vm.editing ? _c("div", { staticClass: "col-md-7" }, [_c("user-defined-value-editor", { attrs: { "provider-claims": _vm.providerClaims }, on: { save: _vm.save, cancel: _vm.cancel, deleteUserDefinedValue: _vm.deleteUserDefinedValue }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } })], 1) : _vm._e()])], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  UserDefinedValueManagerComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const AdministrationUserDefinedValuesComponent = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a25;
let AdministrationUsersComponent = (_a25 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "showLocalUsersTab", !1);
    __publicField(this, "showAdminUsersTab", !1);
    __publicField(this, "showGroupsTab", !1);
    __publicField(this, "showProfilesTab", !1);
    __publicField(this, "showUserDefinedValuesTab", !1);
    __publicField(this, "tab", null);
  }
  async mounted() {
    this.showLocalUsersTab = await userHasPermission("users.localUsers.read"), this.showAdminUsersTab = await userHasPermission("users.adminUsers.read"), this.showGroupsTab = await userHasPermission("users.groups.read"), this.showProfilesTab = await userHasPermission("users.profiles.read"), this.showUserDefinedValuesTab = await userHasPermission("users.userDefinedValues.read");
  }
  get tabs() {
    return [
      {
        id: "localUsers",
        name: "Local Users",
        description: "Local User configuration",
        show: this.showLocalUsersTab,
        icon: "users",
        component: AdministrationLocalUsersComponent
      },
      {
        id: "profiles",
        name: "User Profiles",
        description: "User profiles",
        show: this.showProfilesTab,
        icon: "address-card",
        component: AdministrationProfilesComponent
      },
      {
        id: "adminUsers",
        name: "Admin Users",
        description: "Admin Users",
        show: this.showAdminUsersTab,
        icon: "user-cog",
        component: AdministratorSettingsComponent
      },
      {
        id: "groups",
        name: "Groups",
        description: "Group Configuration",
        show: this.showGroupsTab,
        icon: "users-class",
        component: AdministrationGroupsComponent
      },
      {
        id: "userDefinedValues",
        name: "User Defined Values",
        description: "User Defined Values Configuration",
        show: this.showUserDefinedValuesTab,
        icon: "users-gear",
        component: AdministrationUserDefinedValuesComponent
      }
    ];
  }
  get currentTab() {
    return this.tab ? this.tab : (this.tabs.find((t) => t.show) || { id: null }).id;
  }
  selectTab(tabId) {
    this.tabs.find((t) => t.id === tabId && t.show) && (this.tab = tabId);
  }
}, __name(_a25, "AdministrationUsersComponent"), _a25);
AdministrationUsersComponent = __decorateClass([
  Component({
    components: {
      NoAccessAlert,
      AdministrationLocalUsersComponent,
      AdministrationProfilesComponent,
      AdministratorSettingsComponent,
      AdministrationGroupsComponent,
      AdministrationUserDefinedValuesComponent
    }
  })
], AdministrationUsersComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "container-fluid" }, [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "users-cog" } }), _vm._v(" Users")], 1)])]), _vm._v(" "), !_vm.showLocalUsersTab && !_vm.showAdminUsersTab && !_vm.showGroupsTab && !_vm.showProfilesTab ? _c("no-access-alert") : _c("div", { staticClass: "row mb-2" }, [_c("ul", { staticClass: "col nav nav-tabs unselectable" }, _vm._l(_vm.tabs, function(tab) {
    return tab.show ? _c("li", { key: tab.id, staticClass: "nav-item", attrs: { role: "presentation" } }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.currentTab == tab.id, disabled: !tab.show }, attrs: { title: tab.description, id: tab.id, "data-toggle": "tab" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(`
            ` + _vm._s(tab.name) + `
          `)], 1)]) : _vm._e();
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col tab-content" }, _vm._l(_vm.tabs, function(tab) {
    return tab.show ? _c(tab.component, { directives: [{ name: "show", rawName: "v-show", value: tab.id === _vm.currentTab, expression: "tab.id === currentTab" }], key: tab.id, ref: tab.id, refInFor: !0, tag: "component" }) : _vm._e();
  }), 1)])], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationUsersComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "6c5d195a"
);
const index = __component__.exports;
export {
  index as default
};
