var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, a1 as AdministrationOAuthClient, T as Transformer, b as baseUrl, g as v4, n as normalizeComponent, a2 as AdministrationAuthenticationClient, t as toastr, a3 as AdministrationServiceKeysClient, a4 as IntegrationActionTypes, a5 as AdministrationTempAdminKeysClient, _, N as CheckIcon, a0 as userHasPermission, a6 as userIsSuperAdmin, L as LoadingBarComponent } from "./main-DAVWuHbi.js";
import { P as PasswordComplexityRules } from "./passwordComplexityRules-BxrFfrmN.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { d as deleteSessionModal } from "./deleteSessionModal-0NKRuLTa.js";
import { P as PrivateInput } from "./privateInput-Co-cfsKm.js";
import TextBoxCopy from "./textBoxCopy-CLK7neeX.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
import { I as IntegrationInstanceDropdown } from "./IntegrationInstanceDropdown-DCcBBPtX.js";
var __defProp$8 = Object.defineProperty, __getOwnPropDesc$9 = Object.getOwnPropertyDescriptor, __decorateClass$9 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$9(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$8(target, key, result), result;
}, "__decorateClass$9"), _a;
let OAuthMicrosoftProviderSetting$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "loading", !0);
    __publicField(this, "oAuthProviderId", null);
    __publicField(this, "provider", null);
  }
  async mounted() {
    this.oAuthProviderId = this.value.oAuthProviderId, this.oAuthProviderId && (this.provider = await new AdministrationOAuthClient(new Transformer(), baseUrl()).query(this.oAuthProviderId, "microsoft")), this.loading = !1;
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  async clearSession() {
    if (this.oAuthProviderId) {
      let oauthId = this.oAuthProviderId;
      this.oAuthProviderId = null, this.provider = null, await this.$emit("save"), await new AdministrationOAuthClient(new Transformer(), baseUrl()).clearSession(oauthId);
    }
  }
  showClearSessionModal() {
    this.$bvModal.show("delete-session-modal");
  }
  async authorize() {
    this.loading = !0, this.oAuthProviderId || (this.oAuthProviderId = v4(), this.model.oAuthProviderId = this.oAuthProviderId, await this.$emit("save"));
    try {
      await new AdministrationOAuthClient(new Transformer(), baseUrl()).createMicrosoftProvider(this.oAuthProviderId), this.provider = await new AdministrationOAuthClient(new Transformer(), baseUrl()).query(this.oAuthProviderId, "microsoft");
    } catch {
    } finally {
      this.loading = !1;
    }
  }
  get redirect_uri() {
    return new URL(baseUrl() + "/administration/oauth/microsoft").href;
  }
}, __name(_a, "OAuthMicrosoftProviderSetting"), _a);
__decorateClass$9([
  Prop({
    required: !0
  })
], OAuthMicrosoftProviderSetting$1.prototype, "value", 2);
OAuthMicrosoftProviderSetting$1 = __decorateClass$9([
  Component({
    components: { DateDisplay, deleteSessionModal },
    inject: ["$validator"]
  })
], OAuthMicrosoftProviderSetting$1);
var _sfc_render$9 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("OAuth Session")]), _vm._v(" "), _vm.provider ? _c("div", { staticClass: "row col" }, [_c("ul", { staticClass: "list-group mb-3 col-sm-6" }, [_c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
            Status
            `), _c("span", { staticClass: "badge", class: { "badge-success": _vm.provider.status === "Authenticated", "badge-warning": _vm.provider.status !== "Authenticated" } }, [_vm.provider.status === "Authenticated" ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(" " + _vm._s(_vm.provider.status) + `
                `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(" " + _vm._s(_vm.provider.status) + `
                `)], 1)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
            Last Updated
            `), _c("date-display", { attrs: { humanise: "true", value: _vm.provider.lastUpdated, "show-time": "true" } })], 1), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
            Expiry
            `), _c("date-display", { attrs: { humanise: "true", value: _vm.provider.tokenExpiresAt, "show-time": "true" } })], 1)])]) : _c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Authorizing with OAuth will attempt to establish a session with the selected party
    `)], 1), _vm._v(" "), _vm.provider ? _vm.provider ? _c("b-button", { staticClass: "mb-1", attrs: { size: "sm", variant: "danger" }, on: { click: _vm.showClearSessionModal } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete Session
    `)], 1) : _vm._e() : _c("b-button", { staticClass: "mb-1", attrs: { size: "sm", variant: "primary" }, on: { click: _vm.authorize } }, [_c("font-awesome-icon", { attrs: { icon: "sign-in" } }), _vm._v(" "), _c("span", [_vm._v("Authorize")])], 1), _vm._v(" "), _c("delete-session-modal", { on: { confirm: _vm.clearSession } })], 1);
}, "render"), _sfc_staticRenderFns$9 = [], __component__$9 = /* @__PURE__ */ normalizeComponent(
  OAuthMicrosoftProviderSetting$1,
  _sfc_render$9,
  _sfc_staticRenderFns$9,
  !1,
  null,
  "bf6808c3"
);
const OAuthMicrosoftProviderSetting = __component__$9.exports;
var __defProp$7 = Object.defineProperty, __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor, __decorateClass$8 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$7(target, key, result), result;
}, "__decorateClass$8"), _a2;
let OAuthEimProviderSetting$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "loading", !0);
    __publicField(this, "oAuthProviderId", null);
    __publicField(this, "provider", null);
  }
  async mounted() {
    this.oAuthProviderId = this.value.oAuthProviderId, this.oAuthProviderId && (this.provider = await new AdministrationOAuthClient(new Transformer(), baseUrl()).query(this.oAuthProviderId, "eim")), this.loading = !1;
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  async clearSession() {
    this.oAuthProviderId && (this.oAuthProviderId, this.oAuthProviderId = null, this.provider = null, await this.$emit("save"), await new AdministrationOAuthClient(new Transformer(), baseUrl()).clearSession(this.oAuthProviderId));
  }
  showClearSessionModal() {
    this.$bvModal.show("delete-session-modal");
  }
  async authorize() {
    this.loading = !0, this.oAuthProviderId || (this.oAuthProviderId = v4(), this.model.oAuthProviderId = this.oAuthProviderId, await this.$emit("save"));
    try {
      await new AdministrationOAuthClient(new Transformer(), baseUrl()).createEimProvider(this.oAuthProviderId), this.provider = await new AdministrationOAuthClient(new Transformer(), baseUrl()).query(this.oAuthProviderId, "eim");
    } catch {
    } finally {
      this.loading = !1;
    }
  }
}, __name(_a2, "OAuthEimProviderSetting"), _a2);
__decorateClass$8([
  Prop({
    required: !0
  })
], OAuthEimProviderSetting$1.prototype, "value", 2);
OAuthEimProviderSetting$1 = __decorateClass$8([
  Component({
    components: { DateDisplay, deleteSessionModal },
    inject: ["$validator"]
  })
], OAuthEimProviderSetting$1);
var _sfc_render$8 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("OAuth Session")]), _vm._v(" "), _vm.provider ? _c("div", { staticClass: "row col" }, [_c("ul", { staticClass: "list-group mb-3 col-sm-6" }, [_c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
            Status
            `), _c("span", { staticClass: "badge", class: { "badge-success": _vm.provider.status === "Authenticated", "badge-warning": _vm.provider.status !== "Authenticated" } }, [_vm.provider.status === "Authenticated" ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "check" } }), _vm._v(" " + _vm._s(_vm.provider.status) + `
                `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(" " + _vm._s(_vm.provider.status) + `
                `)], 1)])]), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
            Last Updated
            `), _c("date-display", { attrs: { humanise: "true", value: _vm.provider.lastUpdated, "show-time": "true" } })], 1), _vm._v(" "), _c("li", { staticClass: "list-group-item d-flex justify-content-between align-items-center" }, [_vm._v(`
            Expiry
            `), _c("date-display", { attrs: { humanise: "true", value: _vm.provider.tokenExpiresAt, "show-time": "true" } })], 1)])]) : _c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Authorizing with OAuth will attempt to establish a session with the selected party
    `)], 1), _vm._v(" "), _vm.provider ? _vm.provider ? _c("b-button", { staticClass: "mb-1", attrs: { size: "sm", variant: "danger" }, on: { click: _vm.showClearSessionModal } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete Session
    `)], 1) : _vm._e() : _c("b-button", { staticClass: "mb-1", attrs: { size: "sm", variant: "primary" }, on: { click: _vm.authorize } }, [_c("font-awesome-icon", { attrs: { icon: "sign-in" } }), _vm._v(" "), _c("span", [_vm._v("Authorize")])], 1), _vm._v(" "), _c("delete-session-modal", { on: { confirm: _vm.clearSession } })], 1);
}, "render"), _sfc_staticRenderFns$8 = [], __component__$8 = /* @__PURE__ */ normalizeComponent(
  OAuthEimProviderSetting$1,
  _sfc_render$8,
  _sfc_staticRenderFns$8,
  !1,
  null,
  "183a5007"
);
const OAuthEimProviderSetting = __component__$8.exports;
var __defProp$6 = Object.defineProperty, __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor, __decorateClass$7 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$6(target, key, result), result;
}, "__decorateClass$7"), _a3;
let ProviderSettingsComponent$1 = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "loading", !1);
  }
  mounted() {
  }
  testAuthenticationProvider() {
    this.$validator.validateAll().then((valid) => {
      valid ? (this.loading = !0, new AdministrationAuthenticationClient(new Transformer(), baseUrl()).testAuthenticationProvider(this.model).then((data) => {
        data ? this.bindingPassword ? toastr.success("Successfully signed in, make sure you save your settings.") : toastr.success("Successfully signed in using saved password, make sure you save your settings.") : toastr.error("Could not sign in correctly, check your provider settings.");
      }).catch((e) => {
        toastr.error("Could not test authentication correctly, check your provider settings: " + e);
      }).finally(() => {
        this.loading = !1;
      })) : toastr.error("You must enter provider settings for the Active Directory authentication");
    });
  }
  async saveSettings() {
    this.provider === "activeDirectory" ? await this.$validator.validateAll().then(async (valid) => {
      valid ? await this.sendProviderSettings() : toastr.error("You must enter provider settings for the Active Directory authentication");
    }) : await this.sendProviderSettings();
  }
  async sendProviderSettings() {
    this.loading = !0;
    try {
      var settings = await new AdministrationAuthenticationClient(new Transformer(), baseUrl()).setProviderSettings(this.model);
      this.model = settings, this.bindingPassword = "", toastr.success("Provider Configuration saved");
    } catch (ex) {
      toastr.error("Something has gone wrong while saving the provider config: " + ex);
    } finally {
      this.loading = !1;
    }
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get provider() {
    return this.model.provider;
  }
  set provider(value) {
    this.model.oAuthProviderId = null, this.model.provider = value;
  }
  get serverAddress() {
    return this.model.serverAddress;
  }
  set serverAddress(value) {
    this.model.serverAddress = value;
  }
  get bindingUsername() {
    return this.model.bindingUsername;
  }
  set bindingUsername(value) {
    this.model.bindingUsername = value;
  }
  get bindingPassword() {
    return this.model.bindingPassword;
  }
  set bindingPassword(value) {
    this.model.bindingPassword = value;
  }
  get baseOU() {
    return this.model.baseOU;
  }
  set baseOU(value) {
    this.model.baseOU = value;
  }
  get enforcePasswordComplexity() {
    return this.model.enforcePasswordComplexity;
  }
  set enforcePasswordComplexity(value) {
    this.model.enforcePasswordComplexity = value;
  }
  get minimumPasswordLength() {
    return this.model.minimumPasswordLength;
  }
  set minimumPasswordLength(value) {
    this.model.minimumPasswordLength = value;
  }
  get useSsl() {
    return this.model.useSsl;
  }
  set useSsl(value) {
    this.model.useSsl = value;
  }
  get openIdClient() {
    return this.model.openIdClient;
  }
  set openIdClient(value) {
    this.model.openIdClient = value;
  }
  get openIdTenant() {
    return this.model.openIdTenant;
  }
  set openIdTenant(value) {
    this.model.openIdTenant = value;
  }
  get openIdSecret() {
    return this.model.openIdSecret;
  }
  set openIdSecret(value) {
    this.model.openIdSecret = value;
  }
  get inheritProviderManagers() {
    return this.model.inheritProviderManagers;
  }
  set inheritProviderManagers(value) {
    this.model.inheritProviderManagers = value;
  }
}, __name(_a3, "ProviderSettingsComponent"), _a3);
__decorateClass$7([
  Prop({
    required: !0
  })
], ProviderSettingsComponent$1.prototype, "value", 2);
ProviderSettingsComponent$1 = __decorateClass$7([
  Component({
    components: { PasswordComplexityRules, OAuthMicrosoftProviderSetting, OAuthEimProviderSetting }
  })
], ProviderSettingsComponent$1);
var _sfc_render$7 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-6 col-sm-12" }, [_c("h4", [_vm._v("Provider settings")]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Provider")]), _vm._v(" "), _c("select", { directives: [{ name: "model", rawName: "v-model", value: _vm.provider, expression: "provider" }], staticClass: "custom-select", class: { disabled: _vm.loading }, attrs: { name: "provider", disabled: _vm.loading }, on: { change: /* @__PURE__ */ __name(function($event) {
    var $$selectedVal = Array.prototype.filter.call($event.target.options, function(o) {
      return o.selected;
    }).map(function(o) {
      var val = "_value" in o ? o._value : o.value;
      return val;
    });
    _vm.provider = $event.target.multiple ? $$selectedVal : $$selectedVal[0];
  }, "change") } }, [_c("option", { attrs: { value: "none" } }, [_vm._v("None")]), _vm._v(" "), _c("option", { attrs: { value: "localUsers" } }, [_vm._v("Local Users")]), _vm._v(" "), _c("option", { attrs: { value: "activeDirectory" } }, [_vm._v("Active Directory")]), _vm._v(" "), _c("option", { attrs: { value: "azureActiveDirectory" } }, [_vm._v("Azure Entra ID")]), _vm._v(" "), _c("option", { attrs: { value: "ezeScanIdentityManagement" } }, [_vm._v("EzeScan Identity Management")])])]), _vm._v(" "), _vm.provider === "none" ? _c("div", { staticClass: "alert alert-primary", attrs: { role: "alert" } }, [_vm._v(`
            No authentication provider means that there will be no logins required to access the EWA instance.
            `), _c("br"), _vm._v(`
            You must enable anonymous authentication in IIS to allow this to work.
        `)]) : _vm._e(), _vm._v(" "), _vm.provider === "localUsers" ? _c("div", [_c("div", { staticClass: "form-group" }, [_c("b-form-checkbox", { attrs: { id: "passwordComplexityInput" }, model: { value: _vm.enforcePasswordComplexity, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.enforcePasswordComplexity = $$v;
  }, "callback"), expression: "enforcePasswordComplexity" } }, [_c("b", [_vm._v("Enforce password complexity")])]), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "passwordComplexityHelp" } }, [_vm._v("Ticking this option will enforce the rules below")]), _vm._v(" "), _vm.enforcePasswordComplexity ? _c("b-form-group", { staticClass: "mt-2", attrs: { id: "minimumPasswordLengthLabel", label: "Minimum password length", "label-for": "minimumPasswordLengthInput" } }, [_c("b-row", [_c("b-col", { attrs: { cols: "3" } }, [_c("b-form-input", { attrs: { id: "minimumPasswordLengthInput", type: "number", min: "1" }, model: { value: _vm.minimumPasswordLength, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.minimumPasswordLength = $$v;
  }, "callback"), expression: "minimumPasswordLength" } })], 1), _vm._v(" "), _c("b-col", { attrs: { cols: "12" } }, [_c("span", { staticClass: "form-text text-muted", attrs: { id: "passwordMinimumLengthHelp" } }, [_vm._v("Password must be this many characters long.")])])], 1)], 1) : _vm._e(), _vm._v(" "), _c("span", { staticClass: "form-text text-muted" }, [_c("password-complexity-rules")], 1)], 1), _vm._v(" "), _c("div", { staticClass: "alert alert-primary", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` EWA will keep a list of local users that can log in via usernames and passwords. You can manage them from the Local Users page.
            `)], 1)]) : _vm._e(), _vm._v(" "), _vm.provider === "azureActiveDirectory" ? _c("span", [_c("b-alert", { attrs: { variant: "primary", show: "" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` Ensure that your EWA site is already configured to run in OpenID mode
            `)], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "openIdClientInput" } }, [_vm._v("Application (client) ID")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.openIdClient, expression: "openIdClient" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("openIdClient"), disabled: _vm.loading }, attrs: { type: "text", id: "openIdClientInput", "aria-describedby": "openIdClientHelp", name: "openIdClient", disabled: _vm.loading }, domProps: { value: _vm.openIdClient }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.openIdClient = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "openIdClientHelp" } }, [_vm._v("The application id that has been generated in the Azure AD portal.")]), _vm._v(" "), _vm.errors.first("openIdClient") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter the Application (client) ID")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "openIdTenantInput" } }, [_vm._v("Directory (tenant) ID")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.openIdTenant, expression: "openIdTenant" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("openIdTenant"), disabled: _vm.loading }, attrs: { type: "text", id: "openIdTenantInput", "aria-describedby": "openIdTenantHelp", name: "openIdTenant", disabled: _vm.loading }, domProps: { value: _vm.openIdTenant }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.openIdTenant = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "openIdTenantHelp" } }, [_vm._v("The tenant id for your organisation that can be found in the Azure AD portal.")]), _vm._v(" "), _vm.errors.first("openIdTenant") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter the Directory (tenant) ID")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "openIdSecretInput" } }, [_vm._v("Client Secret")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.openIdSecret, expression: "openIdSecret" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("openIdSecret"), disabled: _vm.loading }, attrs: { type: "text", id: "openIdSecretInput", "aria-describedby": "openIdSecretHelp", name: "openIdSecret", disabled: _vm.loading }, domProps: { value: _vm.openIdSecret }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.openIdSecret = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "openIdSecretHelp" } }, [_vm._v("The client secret which is created in the Azure AD portal. Leave this blank to keep the current secret.")]), _vm._v(" "), _vm.errors.first("openIdSecret") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter the client secret")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "inheritProviderManagerSwitch", switch: "" }, model: { value: _vm.inheritProviderManagers, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.inheritProviderManagers = $$v;
  }, "callback"), expression: "inheritProviderManagers" } }, [_c("b", [_vm._v("Inherit managers from provider")])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("On login will copy the users manager from the authentication provider to the EWA user profile.")])]), _vm._v(" "), _c("o-auth-microsoft-provider-setting", { on: { save: _vm.saveSettings }, model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } })], 1) : _vm._e(), _vm._v(" "), _vm.provider === "activeDirectory" ? _c("span", [_c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "serverAddressInput" } }, [_vm._v("Server Address")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.serverAddress, expression: "serverAddress" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("serverAddress"), disabled: _vm.loading }, attrs: { type: "text", id: "serverAddressInput", "aria-describedby": "serverAddressHelp", name: "serverAddress", disabled: _vm.loading }, domProps: { value: _vm.serverAddress }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.serverAddress = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "serverAddressHelp" } }, [_vm._v("IP Address or hostname of the server to authenticate with.")]), _vm._v(" "), _vm.errors.first("serverAddress") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a Server address for Active Directory")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "useSslSwitch", switch: "" }, model: { value: _vm.useSsl, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.useSsl = $$v;
  }, "callback"), expression: "useSsl" } }, [_c("b", [_vm._v("Use SSL")])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Force the use of SSL only communication.")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "bindingUsernameInput" } }, [_vm._v("Binding Username")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.bindingUsername, expression: "bindingUsername" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("bindingUsername"), disabled: _vm.loading }, attrs: { type: "text", id: "bindingUsernameInput", "aria-describedby": "bindingUsernameHelp", name: "bindingUsername", disabled: _vm.loading, autocorrect: "off", spellcheck: "false", autocomplete: "off" }, domProps: { value: _vm.bindingUsername }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.bindingUsername = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "bindingUsernameHelp" } }, [_vm._v("Username to bind to the server with and use for email address lookups.")]), _vm._v(" "), _vm.errors.first("bindingUsername") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a Username for Active Directory")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "bindingPasswordInput" } }, [_vm._v("Binding Password")]), _vm._v(" "), _c("div", { staticClass: "alert alert-primary", attrs: { role: "alert" } }, [_c("font-awesome-icon", { attrs: { icon: "shield-alt" } }), _vm._v(` Leave this blank to keep the current password.
                `)], 1), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.bindingPassword, expression: "bindingPassword" }], staticClass: "form-control", class: { disabled: _vm.loading }, attrs: { type: "password", id: "bindingPasswordInput", "aria-describedby": "bindingPasswordHelp", name: "bindingPassword", disabled: _vm.loading }, domProps: { value: _vm.bindingPassword }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.bindingPassword = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "bindingPasswordHelp", autocorrect: "off", spellcheck: "false", autocomplete: "off" } }, [_vm._v("Password to bind to the server with and use for email address lookups.")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "baseOUInput" } }, [_vm._v("Base OU")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.baseOU, expression: "baseOU" }], staticClass: "form-control", class: { disabled: _vm.loading }, attrs: { type: "text", id: "baseOUInput", "aria-describedby": "baseOUHelp", name: "baseOU", disabled: _vm.loading }, domProps: { value: _vm.baseOU }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.baseOU = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "baseOUHelp" } }, [_vm._v("Base Organisational Unit for querying.")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "inheritProviderManagerSwitch", switch: "" }, model: { value: _vm.inheritProviderManagers, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.inheritProviderManagers = $$v;
  }, "callback"), expression: "inheritProviderManagers" } }, [_c("b", [_vm._v("Inherit managers from provider")])])], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("On login will copy the users manager from the authentication provider to the EWA user profile.")])]), _vm._v(" "), _c("button", { staticClass: "btn btn-default", on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.testAuthenticationProvider();
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sign-in-alt" } }), _vm._v(` Test provider login
            `)], 1)]) : _vm._e(), _vm._v(" "), _vm.provider === "ezeScanIdentityManagement" ? _c("span", [_c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "serverAddressInput" } }, [_vm._v("Server Address")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.serverAddress, expression: "serverAddress" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("serverAddress"), disabled: _vm.loading }, attrs: { type: "text", id: "serverAddressInput", "aria-describedby": "serverAddressHelp", name: "serverAddress", disabled: _vm.loading }, domProps: { value: _vm.serverAddress }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.serverAddress = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "serverAddressHelp" } }, [_vm._v("Web Url of the EzeScan Identity Management instance.")]), _vm._v(" "), _vm.errors.first("serverAddress") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter a Server address for EIM")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "openIdClientInput" } }, [_vm._v("Application (client) ID")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.openIdClient, expression: "openIdClient" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("openIdClient"), disabled: _vm.loading }, attrs: { type: "text", id: "openIdClientInput", "aria-describedby": "openIdClientHelp", name: "openIdClient", disabled: _vm.loading }, domProps: { value: _vm.openIdClient }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.openIdClient = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "openIdClientHelp" } }, [_vm._v("The application id/client id that has been generated in EIM.")]), _vm._v(" "), _vm.errors.first("openIdClient") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter the Application (client) ID")]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", { attrs: { for: "openIdSecretInput" } }, [_vm._v("Client Secret")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.openIdSecret, expression: "openIdSecret" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("openIdSecret"), disabled: _vm.loading }, attrs: { type: "text", id: "openIdSecretInput", "aria-describedby": "openIdSecretHelp", name: "openIdSecret", disabled: _vm.loading }, domProps: { value: _vm.openIdSecret }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.openIdSecret = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "openIdSecretHelp" } }, [_vm._v("The client secret which is created in EIM. Leave this blank to keep the current secret.")]), _vm._v(" "), _vm.errors.first("openIdSecret") ? _c("p", { staticClass: "text-danger" }, [_vm._v("You must enter the client secret")]) : _vm._e()]), _vm._v(" "), _c("o-auth-eim-provider-setting", { on: { save: _vm.saveSettings }, model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } })], 1) : _vm._e(), _vm._v(" "), _c("button", { staticClass: "btn btn-success", class: { disabled: _vm.loading }, attrs: { disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.saveSettings();
  }, "click") } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.loading, expression: "!loading" }] }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.loading, expression: "loading" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Saving")], 1)])])]);
}, "render"), _sfc_staticRenderFns$7 = [], __component__$7 = /* @__PURE__ */ normalizeComponent(
  ProviderSettingsComponent$1,
  _sfc_render$7,
  _sfc_staticRenderFns$7,
  !1,
  null,
  "ca0cee4c"
);
const ProviderSettingsComponent = __component__$7.exports;
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$6"), _a4;
let ServiceKeySettingsComponent$1 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "keys", []);
    __publicField(this, "newKey", {});
    __publicField(this, "loading", !1);
    __publicField(this, "confirmDeleteId", "");
    __publicField(this, "showServiceKeyList", []);
    __publicField(this, "filterText", "");
    __publicField(this, "keysField", [
      { key: "name" },
      { key: "key", label: "Service Key" },
      { key: "created", sortable: !0 },
      { key: "action", label: "" }
    ]);
  }
  mounted() {
    this.$root.$on("bv::modal::show", () => {
      this.generateKey();
    }), this.loadSettings(), this.resetNewKey();
  }
  async loadSettings() {
    this.loading = !0;
    try {
      let model = await new AdministrationServiceKeysClient(new Transformer(), baseUrl()).getServiceKeys();
      this.serviceKeys = model;
    } catch (ex) {
      toastr.error("Something has gone wrong while loading the service key: " + ex);
    } finally {
      this.loading = !1;
    }
  }
  resetNewKey() {
    this.newKey.name = "", this.newKey.key = "";
  }
  hideModal() {
    this.resetNewKey(), this.$root.$emit("bv::hide::modal", "addKeyModal");
  }
  async addKey() {
    if (await this.$validator.validateAll()) {
      this.loading = !0;
      try {
        await new AdministrationServiceKeysClient(new Transformer(), baseUrl()).addServiceKey(this.newKey), this.resetNewKey(), this.hideModal(), await this.loadSettings(), toastr.success("Service key added");
      } catch (ex) {
        toastr.error("Something has gone wrong while adding the service key: " + ex);
      } finally {
        this.loading = !1;
      }
    } else
      return;
  }
  async deleteKey() {
    if (await this.$validator.validateAll()) {
      this.loading = !0;
      try {
        await new AdministrationServiceKeysClient(new Transformer(), baseUrl()).deleteServiceKey(this.confirmDeleteId), this.confirmDeleteId = "", await this.loadSettings(), toastr.info("Service key deleted");
      } catch (ex) {
        toastr.error("Something has gone wrong while deleting the service key: " + ex);
      } finally {
        this.loading = !1;
      }
    } else
      return;
  }
  filteredKeyValue(keyModel) {
    return this.showServiceKeyList.includes(keyModel.id) ? keyModel.key : keyModel.key.substring(0, 5) + "...";
  }
  toggleShowServiceKey(keyModel) {
    this.showServiceKeyList.includes(keyModel.id) ? this.showServiceKeyList = this.showServiceKeyList.filter((k) => k !== keyModel.id) : this.showServiceKeyList.push(keyModel.id);
  }
  async generateKey() {
    let generatedKey = await new AdministrationServiceKeysClient(new Transformer(), baseUrl()).generateKey();
    this.newKey = { ...this.newKey, key: generatedKey };
  }
  get serviceKeys() {
    return this.keys;
  }
  set serviceKeys(value) {
    this.keys = value;
  }
  copyServiceKey(key) {
    let $temp = $("<input>");
    $("body").append($temp), $temp.val(key).select(), document.execCommand("copy"), $temp.remove(), toastr.info("Key copied to clipboard");
  }
}, __name(_a4, "ServiceKeySettingsComponent"), _a4);
__decorateClass$6([
  Prop({ required: !0 })
], ServiceKeySettingsComponent$1.prototype, "value", 2);
ServiceKeySettingsComponent$1 = __decorateClass$6([
  Component({
    components: { TextBoxCopy, DateDisplay, PrivateInput }
  })
], ServiceKeySettingsComponent$1);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("h4", [_c("font-awesome-icon", { attrs: { icon: "key" } }), _vm._v(`
          Keys
          `), _c("b-badge", { attrs: { pill: "" } }, [_vm._v(_vm._s(_vm.serviceKeys.length))]), _vm._v(" "), _c("b-button", { directives: [{ name: "b-modal", rawName: "v-b-modal.addKeyModal", modifiers: { addKeyModal: !0 } }], attrs: { variant: "primary", size: "sm" } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(" Add key")], 1)], 1), _vm._v(" "), _c("b-input-group", { staticClass: "pb-2", attrs: { size: "sm" } }, [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1), _vm._v(" "), _c("b-form-input", { attrs: { disabled: _vm.loading, type: "search", placeholder: "Filter results..." }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1), _vm._v(" "), _c("b-table", { attrs: { fields: _vm.keysField, "sort-icon-left": "", items: _vm.serviceKeys, busy: _vm.loading, "filter-included-fields": "name", filter: _vm.filterText }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.value } })];
  }, "fn") }, { key: "cell(key)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-input-group", { attrs: { size: "sm" }, scopedSlots: _vm._u([{ key: "append", fn: /* @__PURE__ */ __name(function() {
      return [_c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { size: "sm", variant: "outline-secondary", title: "Copy key" }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.copyServiceKey(data.item.key);
      }, "click") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "copy" } })], 1), _vm._v(" "), _c("b-button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], attrs: { variant: "outline-secondary", title: _vm.showServiceKeyList.includes(data.item.id) ? "Hide key" : "Show key" }, on: { click: /* @__PURE__ */ __name(function($event) {
        return _vm.toggleShowServiceKey(data.item);
      }, "click") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: _vm.showServiceKeyList.includes(data.item.id) ? "eye-slash" : "eye" } })], 1)];
    }, "fn"), proxy: !0 }], null, !0) }, [_c("b-form-input", { attrs: { value: _vm.filteredKeyValue(data.item), type: "text", disabled: "" } })], 1)];
  }, "fn") }, { key: "cell(action)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_vm.confirmDeleteId === data.item.id ? _c("span", [_c("b-button", { attrs: { variant: "danger", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteKey(data.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Confirm")], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.confirmDeleteId = null;
    }, "click") } }, [_vm._v("Cancel")])], 1) : _c("span", [_c("b-button", { attrs: { variant: "danger", size: "sm", disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.confirmDeleteId = data.item.id;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)], 1)])];
  }, "fn") }]) }), _vm._v(" "), _c("b-modal", { attrs: { id: "addKeyModal", title: "Add Service Key", "no-close-on-backdrop": "", "hide-footer": "" } }, [_c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: "exclamation-circle" } }), _vm._v(`
            This will add a new key into your service keys repository.
          `)], 1), _vm._v(" "), _c("b-form", { on: { submit: /* @__PURE__ */ __name(function($event) {
    return $event.stopPropagation(), $event.preventDefault(), _vm.addKey.apply(null, arguments);
  }, "submit") } }, [_c("b-form-group", { attrs: { id: "serviceKeyNameInputGroup", label: "Name", "label-for": "serviceKeyNameInput" } }, [_c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("serviceKeyNameInput") }, attrs: { id: "serviceKeyDNameInput", name: "serviceKeyNameInput", "data-vv-as": "Name", type: "text", disabled: _vm.loading }, model: { value: _vm.newKey.name, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.newKey, "name", $$v);
  }, "callback"), expression: "newKey.name" } }), _vm._v(" "), _c("b-form-invalid-feedback", { attrs: { id: "serviceKeyNameInputFeedback" } }, [_vm._v(_vm._s(_vm.errors.first("serviceKeyNameInput")))])], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "serviceKeyInputGroup", label: "Key", "label-for": "serviceKeyInput" } }, [_c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], class: { "is-invalid": _vm.errors.first("serviceKeyInput") }, attrs: { id: "serviceKeyInput", name: "serviceKeyInput", "data-vv-as": "Key", type: "text", disabled: _vm.loading }, model: { value: _vm.newKey.key, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.newKey, "key", $$v);
  }, "callback"), expression: "newKey.key" } }), _vm._v(" "), _c("b-form-invalid-feedback", { attrs: { id: "serviceKeyInputFeedback" } }, [_vm._v(_vm._s(_vm.errors.first("serviceKeyInput")))])], 1), _vm._v(" "), _c("b-button", { staticClass: "float-left", attrs: { variant: "outline-secondary" }, on: { click: _vm.hideModal } }, [_vm._v("Cancel")]), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { type: "submit", variant: "success", disabled: _vm.loading } }, [_vm.loading ? _c("span", [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Saving")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Add Key")], 1)])], 1)], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  ServiceKeySettingsComponent$1,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  "07e5c5c4"
);
const ServiceKeySettingsComponent = __component__$6.exports;
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$5"), _a5;
let ConfirmDeleteTempKeyModal$1 = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "entityName");
  }
  confirm() {
    this.$bvModal.hide("confirm-delete-key-modal"), this.$emit("confirm");
  }
  get modalTitle() {
    return "Delete " + this.entityName + " access key?";
  }
}, __name(_a5, "ConfirmDeleteTempKeyModal"), _a5);
__decorateClass$5([
  Prop({ required: !0 })
], ConfirmDeleteTempKeyModal$1.prototype, "entityName", 2);
ConfirmDeleteTempKeyModal$1 = __decorateClass$5([
  Component({})
], ConfirmDeleteTempKeyModal$1);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { size: "lg", id: "confirm-delete-key-modal", title: _vm.modalTitle, "no-close-on-backdrop": "", "cancel-variant": "" }, scopedSlots: _vm._u([{ key: "modal-footer", fn: /* @__PURE__ */ __name(function({ ok, cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v(`
      Cancel
    `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "danger" }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Confirm
    `)], 1)];
  }, "fn") }]) }, [_c("div", [_c("b-alert", { staticClass: "mb-0", attrs: { variant: "warning", show: !0 } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`  Are you sure you want to delete the selected access key?
      `)], 1)], 1)]);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  ConfirmDeleteTempKeyModal$1,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  null
);
const ConfirmDeleteTempKeyModal = __component__$5.exports;
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$4"), _a6;
let CreateTempKeyModal$1 = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model", null);
    __publicField(this, "entityId");
    __publicField(this, "entityType");
    __publicField(this, "entityName");
  }
  modalShown() {
    this.model = {}, this.entityId && this.entityType && this.entityName && (this.model = { ...this.model, entityId: this.entityId }, this.model = { ...this.model, entityName: this.entityType }, this.model = { ...this.model, entityDisplayName: this.entityName });
  }
  cancel() {
    this.$emit("cancel"), this.$bvModal.hide("create-temp-key-modal");
  }
  confirm() {
    this.$emit("create", this.model), this.$bvModal.hide("create-temp-key-modal");
  }
  setEntityDisplayName(value) {
    this.model.entityDisplayName = value;
  }
  get selectedEntityId() {
    return this.model.entityId;
  }
  set selectedEntityId(value) {
    this.model = { ...this.model, entityId: value };
  }
  setEntityType(entity) {
    this.model.entityId = null, this.model.entityDisplayName = null, this.model.entityName = null, this.model = { ...this.model, entityName: entity.id };
  }
  get options() {
    return [
      { id: "connector", name: "Integration", icon: "share-alt" }
    ];
  }
}, __name(_a6, "CreateTempKeyModal"), _a6);
__decorateClass$4([
  Prop({ required: !1, default: null })
], CreateTempKeyModal$1.prototype, "entityId", 2);
__decorateClass$4([
  Prop({ required: !1, default: null })
], CreateTempKeyModal$1.prototype, "entityType", 2);
__decorateClass$4([
  Prop({ required: !1, default: null })
], CreateTempKeyModal$1.prototype, "entityName", 2);
CreateTempKeyModal$1 = __decorateClass$4([
  Component({
    computed: {
      IntegrationActionTypes() {
        return IntegrationActionTypes;
      }
    },
    components: {
      IntegrationInstanceDropdown
    }
  })
], CreateTempKeyModal$1);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { id: "create-temp-key-modal", "no-close-on-backdrop": "", "cancel-variant": "" }, on: { show: _vm.modalShown }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "pen-to-square" } }), _vm._v(" Create new Access Key")], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({}) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: _vm.cancel } }, [_vm._v(`
             Cancel
         `)]), _vm._v(" "), _c("b-button", { attrs: { variant: "success" }, on: { click: _vm.confirm } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Create
         `)], 1)];
  }, "fn") }]) }, [_vm._v(" "), _vm.model ? _c("div", [_c("b-form-group", { attrs: { label: "Access Entity Type", "label-for": "entityTypeInput", description: "The type of item to grant configuration access to." } }, [_c("b-dropdown", { attrs: { "no-flip": "", variant: "outline-secondary", id: "entityTypeInput" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    var _a11, _b;
    return [_vm.model.entityName ? _c("span", [_c("font-awesome-icon", { attrs: { icon: (_a11 = _vm.options.find((y) => y.id == _vm.model.entityName)) == null ? void 0 : _a11.icon } }), _vm._v(`
                          ` + _vm._s((_b = _vm.options.find((y) => y.id == _vm.model.entityName)) == null ? void 0 : _b.name) + `
                     `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Select Access Type
                     `)], 1)];
  }, "fn"), proxy: !0 }], null, !1, 2735650243) }, [_vm._v(" "), _vm._l(_vm.options, function(option, index2) {
    return _c("b-dropdown-item", { key: index2, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setEntityType(option);
    }, "click") } }, [_c("font-awesome-icon", { staticClass: "fa-fw", attrs: { icon: option.icon } }), _vm._v(" " + _vm._s(option.name) + `
                 `)], 1);
  })], 2)], 1), _vm._v(" "), _vm.model.entityName ? _c("div", [_vm.model.entityName == "connector" ? _c("div", [_c("b-form-group", { attrs: { id: "connectorInstanceGroup", "label-for": "connectorInstanceInput", label: "Connector Instance", description: "The connector instance to create access to" } }, [_c("integration-instance-dropdown", { attrs: { id: "connectorInstanceInput", allowLegacyIntegrations: !1, "action-filter": [
    _vm.IntegrationActionTypes.Upload,
    _vm.IntegrationActionTypes.Browse,
    _vm.IntegrationActionTypes.Search,
    _vm.IntegrationActionTypes.Lookup,
    _vm.IntegrationActionTypes.Validation
  ], name: "integration" }, on: { integrationNameChanged: /* @__PURE__ */ __name(function($event) {
    return _vm.setEntityDisplayName($event);
  }, "integrationNameChanged") }, model: { value: _vm.selectedEntityId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.selectedEntityId = $$v;
  }, "callback"), expression: "selectedEntityId" } })], 1)], 1) : _c("div", [_vm._v(`
                 No selector configured.
             `)])]) : _vm._e()], 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  CreateTempKeyModal$1,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  null
);
const CreateTempKeyModal = __component__$4.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$3"), _a7;
let KeyCreatedModal$1 = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "accessKey");
    __publicField(this, "entityName");
  }
  get getTempKeyUrl() {
    return baseUrl() + "/ExternalAccess?AdminAccessKey=" + this.accessKey;
  }
}, __name(_a7, "KeyCreatedModal"), _a7);
__decorateClass$3([
  Prop({ required: !0 })
], KeyCreatedModal$1.prototype, "accessKey", 2);
__decorateClass$3([
  Prop({ required: !0 })
], KeyCreatedModal$1.prototype, "entityName", 2);
KeyCreatedModal$1 = __decorateClass$3([
  Component({
    components: { TextBoxCopy }
  })
], KeyCreatedModal$1);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { id: "key-created-modal" }, scopedSlots: _vm._u([{ key: "modal-title", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", [_c("font-awesome-icon", { attrs: { icon: "pen-to-square" } }), _vm._v(" New Access Key Created")], 1)];
  }, "fn"), proxy: !0 }, { key: "modal-footer", fn: /* @__PURE__ */ __name(function({ cancel }) {
    return [_c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: cancel } }, [_vm._v("Ok")])];
  }, "fn") }]) }, [_vm._v(" "), _c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
     Anyone with the link below will have access to edit ` + _vm._s(_vm.entityName) + `
   `)], 1), _vm._v(" "), _c("text-box-copy", { attrs: { value: _vm.getTempKeyUrl, disabled: !0 } })], 1);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  KeyCreatedModal$1,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const KeyCreatedModal = __component__$3.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$2"), _a8;
let AdministrationTempKeyComponent = (_a8 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "model", null);
    __publicField(this, "loading", !0);
    __publicField(this, "page", 1);
    __publicField(this, "pageSize", 20);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "keyToDelete", null);
    __publicField(this, "createdKey", null);
    __publicField(this, "filterModel", { pageId: null, sort: {} });
    __publicField(this, "entityId");
    __publicField(this, "entityType");
    __publicField(this, "entityName");
    __publicField(this, "routeEntityId", null);
    __publicField(this, "routeEntityType", null);
    __publicField(this, "routeEntityName", null);
    __publicField(this, "searchItemsDebounce", _.debounce(function() {
      this.getKeys(!0);
    }, 500));
  }
  async mounted() {
    this.reloadTimer = setInterval(() => this.getKeys(!1), 3e4), await this.getKeys(!0), this.entityId && this.entityType && this.entityName && (this.routeEntityId = this.entityId, this.routeEntityType = this.entityType, this.routeEntityName = this.entityName, await this.$nextTick(), this.showModal());
  }
  get pageNumber() {
    return this.page;
  }
  set pageNumber(value) {
    this.page = value, this.getKeys(!0);
  }
  get sort() {
    let sort = this.filterModel.sort;
    return sort || null;
  }
  set sort(sort) {
    this.filterModel.sort = sort, this.getKeys(!0);
  }
  async getKeys(setLoading) {
    this.loading = setLoading;
    try {
      let keyClient = new AdministrationTempAdminKeysClient(new Transformer(), baseUrl());
      this.model = await keyClient.getTempAdminKeys(this.filterModel, this.pageSize, this.page);
    } catch (ex) {
      toastr.error(ex, "An error occurred when retrieving the admin access keys");
    } finally {
      this.loading = !1;
    }
  }
  async deleteKey() {
    if (this.keyToDelete) {
      this.loading = !0;
      try {
        let result = await new AdministrationTempAdminKeysClient(new Transformer(), baseUrl()).deleteTempAdminKey(this.keyToDelete.id);
        toastr.success("The key has been deleted");
      } catch (ex) {
        toastr.error(ex, "An error occurred attempting to delete a key");
      } finally {
        this.keyToDelete = null, this.getKeys(!0);
      }
    }
  }
  cancelCreate() {
    this.routeEntityId = null, this.routeEntityType = null, this.routeEntityName = null;
  }
  async createKey(newKey) {
    this.cancelCreate(), this.loading = !0;
    try {
      let result = await new AdministrationTempAdminKeysClient(new Transformer(), baseUrl()).createTempAdminKey(newKey);
      this.createdKey = result, toastr.success("The key has been created"), await this.$nextTick(), this.$bvModal.show("key-created-modal");
    } catch (ex) {
      toastr.error(ex, "An error occurred attempting to create a new key");
    } finally {
      this.getKeys(!0);
    }
  }
  getTempKeyUrl(accessKey) {
    return baseUrl() + "/ExternalAccess?AdminAccessKey=" + accessKey;
  }
  showModal() {
    this.$bvModal.show("create-temp-key-modal");
  }
  get searchFilter() {
    return this.filterModel.search;
  }
  set searchFilter(value) {
    this.filterModel.search = value, this.searchItemsDebounce();
  }
  get totalPages() {
    if (this.model)
      return Math.ceil(this.model.count / this.pageSize);
  }
  get tableFields() {
    return [
      { key: "entityName" },
      { key: "accessKey" },
      { key: "accessUserName" },
      //temp
      { key: "createdByUser" },
      //temp
      { key: "entityDisplayName", label: "Display Name" },
      { key: "created" },
      { key: "expiresAt" },
      { key: "actions" }
    ];
  }
}, __name(_a8, "AdministrationTempKeyComponent"), _a8);
__decorateClass$2([
  Prop({ required: !1, default: null })
], AdministrationTempKeyComponent.prototype, "entityId", 2);
__decorateClass$2([
  Prop({ required: !1, default: null })
], AdministrationTempKeyComponent.prototype, "entityType", 2);
__decorateClass$2([
  Prop({ required: !1, default: null })
], AdministrationTempKeyComponent.prototype, "entityName", 2);
AdministrationTempKeyComponent = __decorateClass$2([
  Component({ components: { DateDisplay, PaginationControls, SortableHeaderLink, ConfirmDeleteTempKeyModal, CreateTempKeyModal, TextBoxCopy, KeyCreatedModal } })
], AdministrationTempKeyComponent);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _a11, _b, _c2;
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-card", { attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("font-awesome-icon", { attrs: { icon: "key-skeleton-left-right" } }), _vm._v(` Temporary Admin Keys
            `), _c("b-button", { attrs: { variant: "outline-primary", size: "sm" }, on: { click: _vm.showModal } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } })], 1)], 1)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _c("b-form-group", { staticClass: "mb-0" }, [_c("b-input-group", { attrs: { size: "sm" } }, [_c("b-form-input", { staticClass: "noAppendedBorder", attrs: { id: "filter-input", type: "search", placeholder: "Filter...", autocomplete: "off" }, model: { value: _vm.searchFilter, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.searchFilter = $$v;
  }, "callback"), expression: "searchFilter" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-input-group-text", { staticClass: "onlyBorderLeft" }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)], 1)], 1)], 1), _vm._v(" "), _vm.model ? _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.model.results, striped: "", busy: _vm.loading, "show-empty": "", emptyText: "No temporary admin access keys were found." }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "head(entityName)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "entityName", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(createdByUserDisplayName)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "createdByUserDisplayName", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(created)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "created", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(expiresAt)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "expiresAt", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(actions)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.getKeys(!0);
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } })], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } })], 1)])];
  }, "fn") }, { key: "cell(accessUserName)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-badge", { attrs: { pill: "" } }, [_c("font-awesome-icon", { attrs: { icon: "user" } }), _vm._v(`
              AdminAccessKey-` + _vm._s(row.item.id) + `
            `)], 1)];
  }, "fn") }, { key: "cell(accessKey)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("text-box-copy", { attrs: { value: _vm.getTempKeyUrl(row.item.accessKey), disabled: !0 } })];
  }, "fn") }, { key: "cell(createdByUser)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
                ` + _vm._s(row.item.createdByUserDisplayName ?? row.item.createdByUser) + `
            `)];
  }, "fn") }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.created ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.created } }) : _vm._e()];
  }, "fn") }, { key: "cell(expiresAt)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.expiresAt ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.expiresAt } }) : _vm._e()];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-button", { directives: [{ name: "b-modal", rawName: "v-b-modal", value: "confirm-delete-key-modal", expression: "'confirm-delete-key-modal'" }], staticClass: "float-right", attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.keyToDelete = row.item;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)];
  }, "fn") }], null, !1, 1342490705) }) : _vm._e(), _vm._v(" "), _vm.model ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } }) : _vm._e()], 1), _vm._v(" "), _c("confirm-delete-temp-key-modal", { attrs: { entityName: (_a11 = _vm.keyToDelete) == null ? void 0 : _a11.entityName }, on: { confirm: _vm.deleteKey } }), _vm._v(" "), _c("create-temp-key-modal", { attrs: { entityId: _vm.routeEntityId, entityType: _vm.routeEntityType, entityName: _vm.routeEntityName }, on: { create: _vm.createKey, cancel: _vm.cancelCreate } }), _vm._v(" "), _c("key-created-modal", { attrs: { accessKey: (_b = _vm.createdKey) == null ? void 0 : _b.accessKey, "entity-name": (_c2 = _vm.createdKey) == null ? void 0 : _c2.entityDisplayName } })], 1);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  AdministrationTempKeyComponent,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "766639b5"
);
const TempAdminKeysComponent = __component__$2.exports;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$1"), _a9;
let AuthenticationPermissionsSettingsComponent$1 = (_a9 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "settings", null);
    __publicField(this, "loading", !1);
  }
  mounted() {
    this.loadSettings();
  }
  async loadSettings() {
    this.loading = !0;
    try {
      this.settings = await new AdministrationAuthenticationClient(new Transformer(), baseUrl()).getPermissions();
    } catch (ex) {
      toastr.error("Something has gone wrong while loading the permissions: " + ex);
    } finally {
      this.loading = !1;
    }
  }
  async saveSettings() {
    this.loading = !0;
    try {
      var result = await new AdministrationAuthenticationClient(new Transformer(), baseUrl()).setPermissions(this.settings);
      this.settings = result, toastr.success("Permissions Configuration saved");
    } catch (ex) {
      toastr.error("Something has gone wrong while saving the permissions config: " + ex);
    } finally {
      this.loading = !1;
    }
  }
}, __name(_a9, "AuthenticationPermissionsSettingsComponent"), _a9);
AuthenticationPermissionsSettingsComponent$1 = __decorateClass$1([
  Component({
    components: {
      CheckIcon
    }
  })
], AuthenticationPermissionsSettingsComponent$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("h4", [_c("font-awesome-icon", { attrs: { icon: "id-badge" } }), _vm._v(`
          Permissions
        `)], 1), _vm._v(" "), _c("div", { staticClass: "form-group mt-3" }, [_c("div", { staticClass: "pretty p-svg p-curve p-smooth" }, [_c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.settings.isRecursivePermissionMode, expression: "settings.isRecursivePermissionMode" }], staticClass: "form-check-input", class: { disabled: _vm.loading }, attrs: { type: "checkbox", id: "isRecursivePermissionModeCheckbox", disabled: _vm.loading }, domProps: { checked: Array.isArray(_vm.settings.isRecursivePermissionMode) ? _vm._i(_vm.settings.isRecursivePermissionMode, null) > -1 : _vm.settings.isRecursivePermissionMode }, on: { change: /* @__PURE__ */ __name(function($event) {
    var $$a = _vm.settings.isRecursivePermissionMode, $$el = $event.target, $$c = !!$$el.checked;
    if (Array.isArray($$a)) {
      var $$v = null, $$i = _vm._i($$a, $$v);
      $$el.checked ? $$i < 0 && _vm.$set(_vm.settings, "isRecursivePermissionMode", $$a.concat([$$v])) : $$i > -1 && _vm.$set(_vm.settings, "isRecursivePermissionMode", $$a.slice(0, $$i).concat($$a.slice($$i + 1)));
    } else
      _vm.$set(_vm.settings, "isRecursivePermissionMode", $$c);
  }, "change") } }), _vm._v(" "), _c("div", { staticClass: "state p-primary" }, [_c("span", { staticClass: "svg svg-icon" }, [_c("CheckIcon")], 1), _vm._v(" "), _c("label", [_vm._v("Recursive Permission mode")])])]), _vm._v(" "), _c("span", { staticClass: "form-text text-muted", attrs: { id: "isRecursivePermissionModeCheckboxHelp" } }, [_vm._v("Enables recursive permissions for user managers.")])]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", class: { disabled: _vm.loading }, attrs: { disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.saveSettings();
  }, "click") } }, [_c("span", { directives: [{ name: "show", rawName: "v-show", value: !_vm.loading, expression: "!loading" }] }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(" Save")], 1), _vm._v(" "), _c("span", { directives: [{ name: "show", rawName: "v-show", value: _vm.loading, expression: "loading" }] }, [_c("font-awesome-icon", { staticClass: "fa-spin", attrs: { icon: "sync" } }), _vm._v(" Saving")], 1)])])], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  AuthenticationPermissionsSettingsComponent$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const AuthenticationPermissionsSettingsComponent = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a10;
let AdministrationAuthenticationComponent = (_a10 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "authenticationSettings", null);
    __publicField(this, "selectedTab", null);
    __publicField(this, "loading", !1);
    __publicField(this, "tab");
    __publicField(this, "entityId");
    __publicField(this, "entityType");
    __publicField(this, "entityName");
    __publicField(this, "hasServiceKeysPermission", !1);
    __publicField(this, "isSuperAdmin", !1);
    __publicField(this, "tabs", [
      {
        id: "providersettings",
        name: "Provider",
        icon: "id-card",
        description: "Set up the details for your authentication provider",
        show: !0,
        component: ProviderSettingsComponent
      },
      {
        id: "keys",
        name: "Service key",
        icon: "key",
        description: "Add a service key for EWA to use",
        show: !0,
        component: ServiceKeySettingsComponent
      },
      {
        id: "permissions",
        name: "Permissions",
        icon: "id-badge",
        description: "Manage global permission settings",
        show: !0,
        component: AuthenticationPermissionsSettingsComponent
      },
      {
        id: "tempAdminKeys",
        name: "Temporary Admin Keys",
        icon: "key-skeleton-left-right",
        description: "Manage temporary admin access keys",
        show: !0,
        component: TempAdminKeysComponent
      }
    ]);
  }
  async mounted() {
    this.loading = !0, this.hasServiceKeysPermission = await userHasPermission("authentication.serviceKeys"), this.hasServiceKeysPermission || (this.tabs = this.tabs.filter((y) => y.id != "keys")), this.isSuperAdmin = await userIsSuperAdmin(), this.isSuperAdmin || (this.tabs = this.tabs.filter((y) => y.id != "tempAdminKeys")), this.tab && this.tabs.find((t) => t.id === this.tab && t.show) && (this.selectedTab = this.tab), await this.loadSettings();
  }
  async loadSettings() {
    try {
      this.loading = !0;
      let model = await new AdministrationAuthenticationClient(new Transformer(), baseUrl()).getAuthenticationSettings();
      this.authenticationSettings = model;
    } catch (ex) {
      toastr.error("Something has gone wrong while loading the Authentication settings: " + ex);
    } finally {
      this.loading = !1;
    }
  }
  get settings() {
    return this.authenticationSettings;
  }
  set settings(value) {
    this.$emit("input", value);
  }
  get activeTab() {
    return this.selectedTab ? this.selectedTab : (this.tabs.find((t) => t.show) || { id: null }).id;
  }
  selectTab(tabId) {
    this.tabs.find((t) => t.id === tabId && t.show) && (this.selectedTab = tabId);
  }
}, __name(_a10, "AdministrationAuthenticationComponent"), _a10);
__decorateClass([
  Prop({ required: !1, default: null })
], AdministrationAuthenticationComponent.prototype, "tab", 2);
__decorateClass([
  Prop({ required: !1, default: null })
], AdministrationAuthenticationComponent.prototype, "entityId", 2);
__decorateClass([
  Prop({ required: !1, default: null })
], AdministrationAuthenticationComponent.prototype, "entityType", 2);
__decorateClass([
  Prop({ required: !1, default: null })
], AdministrationAuthenticationComponent.prototype, "entityName", 2);
AdministrationAuthenticationComponent = __decorateClass([
  Component({
    components: {
      ProviderSettingsComponent,
      ServiceKeySettingsComponent,
      AuthenticationPermissionsSettingsComponent,
      TempAdminKeysComponent,
      LoadingBar: LoadingBarComponent
    }
  })
], AdministrationAuthenticationComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "user-shield" } }), _vm._v(" Authentication")], 1)]), _vm._v(" "), _vm.loading ? _c("div", { staticClass: "col-sm-12" }, [_c("loading-bar")], 1) : _c("div", [_c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs", attrs: { id: "myTab", role: "tablist" } }, _vm._l(_vm.tabs, function(currentTab) {
    return _c("li", { key: currentTab.id, staticClass: "nav-item" }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab === currentTab.id }, attrs: { id: currentTab.id + "tab", "data-toggle": "tab", role: "tab", "aria-selected": "true" }, on: { click: /* @__PURE__ */ __name(function($event) {
      currentTab.show && _vm.selectTab(currentTab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: currentTab.icon } }), _vm._v(" " + _vm._s(currentTab.name) + `
                    `)], 1)]);
  }), 0)]), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_vm.authenticationSettings ? _c("div", { staticClass: "container-fluid" }, [_vm.activeTab === "providersettings" ? _c("provider-settings-component", { attrs: { value: _vm.authenticationSettings }, on: { loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading") } }) : _vm._e(), _vm._v(" "), _vm.activeTab === "keys" ? _c("service-key-settings-component", { attrs: { value: _vm.authenticationSettings }, on: { loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading") } }) : _vm._e(), _vm._v(" "), _vm.activeTab === "permissions" ? _c("authentication-permissions-settings-component", { attrs: { value: _vm.authenticationSettings }, on: { loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading") } }) : _vm._e(), _vm._v(" "), _vm.activeTab === "tempAdminKeys" ? _c("temp-admin-keys-component", { attrs: { entityId: _vm.entityId, entityType: _vm.entityType, entityName: _vm.entityName }, on: { loading: /* @__PURE__ */ __name(function($event) {
    _vm.loading = $event;
  }, "loading") } }) : _vm._e()], 1) : _vm._e()])])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationAuthenticationComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "3a1f65c4"
);
const index = __component__.exports;
export {
  index as default
};
