var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, R as Routes, W as Watch, C as Component, L as LoadingBarComponent, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let MonitorHomeRouteComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loadingObservees", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "selectedObservee", "");
    __publicField(this, "autoRefresh");
  }
  mounted() {
    this.loadPage();
  }
  get tableFields() {
    return [
      { key: "name" },
      { key: "modified", label: "Last Updated" },
      { key: "count" },
      { key: "actions", label: "" }
    ];
  }
  beforeDestroy() {
    this.autoRefresh && clearTimeout(this.autoRefresh);
  }
  reloadRouteData() {
    this.loadPage();
  }
  getCountOfChildItems() {
    return this.page.observees.map((o) => o.count).reduce((total, current) => total + current, 0);
  }
  loadPage() {
    return this.loadingObservees = !0, this.loadingError = null, this.$store.dispatch("loadMonitorPage", this.pageId).catch((e) => this.loadingError = e).finally(() => {
      this.setNextAutoReload(), this.loadingObservees = !1;
    });
  }
  get page() {
    return this.$store.getters.getCurrentMonitorPage(this.pageId);
  }
  get pageId() {
    return this.$route.params.pageId;
  }
  get refreshInterval() {
    let param = this.$route.query.refreshInterval, parsed = param ? parseInt(param) : 0;
    return parsed > 0 ? parsed : 0;
  }
  setNextAutoReload() {
    this.autoRefresh && clearTimeout(this.autoRefresh), this.refreshInterval && (this.autoRefresh = setTimeout(() => this.loadPage(), this.refreshInterval * 1e3));
  }
  loadObservee(observee) {
    this.selectedObservee = observee.id, this.$router.push({ name: Routes.Observee, params: { pageId: this.pageId, observeeId: observee.id }, query: { refreshInterval: this.refreshInterval ? this.refreshInterval.toString() : void 0 } });
  }
  isValidObserveeModifiedDate(observee) {
    return !(!observee.modified || observee.modified === "0001-01-01T00:00:00+00:00");
  }
  iconFor(observee) {
    switch (observee.type) {
      case "indexing":
        return "inbox";
      case "directory":
        return "folder";
      case "azure":
        return "cloud";
      default:
        return "";
    }
  }
}, __name(_a, "MonitorHomeRouteComponent"), _a);
__decorateClass([
  Watch("$route")
], MonitorHomeRouteComponent.prototype, "reloadRouteData", 1);
MonitorHomeRouteComponent = __decorateClass([
  Component({
    components: { LoadingBar: LoadingBarComponent, DateDisplay }
  })
], MonitorHomeRouteComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "clearfix" }, [_vm.page ? _c("div", [_c("b-row", [_c("b-col", [_c("b-breadcrumb", [_c("b-breadcrumb-item", { attrs: { active: "" } }, [_c("font-awesome-icon", { attrs: { icon: "home" } }), _vm._v(" "), _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "badge badge-secondary", attrs: { title: _vm.page.observees.length + " containers with " + _vm.getCountOfChildItems() + " items total" } }, [_vm._v(_vm._s(_vm.getCountOfChildItems()))])], 1)], 1)], 1)], 1), _vm._v(" "), _c("b-row", [_c("b-col", [_c("b-table", { staticClass: "table-vertical-align-content", attrs: { striped: "", items: _vm.page.observees, fields: _vm.tableFields, busy: _vm.loadingObservees }, scopedSlots: _vm._u([{ key: "head(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("span", { staticClass: "float-right" }, [_c("b-button", { attrs: { size: "sm", variant: "outline-secondary", disabled: _vm.loadingObservees }, on: { click: _vm.loadPage } }, [_c("font-awesome-icon", { attrs: { icon: "sync", spin: _vm.loadingObservees } })], 1)], 1)];
  }, "fn") }, { key: "cell(name)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("font-awesome-icon", { attrs: { icon: _vm.iconFor(data.item) } }), _vm._v(` 
                  `), _vm.loadingObservees || !data.item.exists ? _c("span", { staticClass: "text-muted" }, [_vm._v(_vm._s(data.item.name))]) : _vm._e(), _vm._v(" "), data.item.exists ? _vm.loadingObservees ? _vm._e() : _c("a", { attrs: { role: "button", href: "javascript:void(0)" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.loadObservee(data.item);
    }, "click") } }, [_vm._v(_vm._s(data.item.name))]) : _c("span", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "text-warning", attrs: { title: "This item does not exist" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-triangle" } })], 1), _vm._v(" "), _c("span", { staticClass: "clearfix" }), _vm._v(" "), data.item.description ? _c("small", { staticClass: "text-muted" }, [_vm._v(_vm._s(data.item.description))]) : _vm._e()];
  }, "fn") }, { key: "cell(modified)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm.isValidObserveeModifiedDate(data.item) ? _c("span", [_c("date-display", { attrs: { value: data.value } })], 1) : _vm._e()];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-button", { staticClass: "float-right", attrs: { size: "sm", variant: "primary", disabled: _vm.loadingObservees }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.loadObservee(data.item);
    }, "click") } }, [_vm.selectedObservee === data.item.id ? _c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }) : _c("font-awesome-icon", { attrs: { icon: "eye" } }), _vm._v(`
                    View
                `)], 1)];
  }, "fn") }]) })], 1)], 1)], 1) : _c("div", [_vm.loadingObservees ? _c("div", { staticClass: "text-center text-primary my-auto mx-auto" }, [_c("b-spinner", { staticClass: "align-middle" }), _vm._v(" "), _c("strong", [_vm._v("Loading...")])], 1) : _vm.loadingError ? _c("div", { staticClass: "alert alert-danger" }, [_vm._v(`
                An error has occurred while loading the page: ` + _vm._s(_vm.loadingError) + `
              `), _c("br"), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: _vm.loadPage } }, [_vm._v("Reload page")])], 1) : _vm._e()])])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  MonitorHomeRouteComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  null
);
const home = __component__.exports;
export {
  home as default
};
