var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, a7 as AdministrationPagesClient, T as Transformer, b as baseUrl, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { P as PermissionEditor } from "./permissionEditor-CEAGzDpF.js";
import { g as getReplacedName } from "./regexHelpers-D8RHIfkG.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let GeneralPageSettings$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "appPageIds", []);
    __publicField(this, "storedId", null);
  }
  created() {
    this.addUniqueValidator();
  }
  async mounted() {
    let appPages = await new AdministrationPagesClient(new Transformer(), baseUrl()).getAppPages();
    if (this.appPageIds = appPages.map((appPage) => appPage.id), this.id) {
      let idIndex = this.appPageIds.indexOf(this.id);
      this.appPageIds.splice(idIndex, 1);
    }
  }
  addUniqueValidator() {
    this.$validator.extend("pageIdUnique", {
      validate: /* @__PURE__ */ __name((value) => Promise.resolve({
        valid: !this.appPageIds.includes(this.id),
        data: value
      }), "validate"),
      getMessage: /* @__PURE__ */ __name(() => "Id must be unique", "getMessage")
    });
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get id() {
    return this.model.id;
  }
  set id(id) {
    let newModel = Object.assign({}, this.model, { id });
    this.model = newModel;
  }
  get name() {
    return this.model.name;
  }
  set name(name) {
    !this.model.id || this.model.id == getReplacedName(this.model.name) && this.storedId ? (this.storedId = getReplacedName(name), this.model = { ...this.model, id: this.storedId, name }, this.$validator.validate("id")) : this.model = Object.assign({}, this.model, { name });
  }
  get description() {
    return this.model.description;
  }
  set description(description) {
    this.model = Object.assign({}, this.model, { description });
  }
  get menuItemHidden() {
    return this.model.menuItemHidden;
  }
  set menuItemHidden(menuItemHidden) {
    this.model = { ...this.model, menuItemHidden };
  }
}, __name(_a, "GeneralPageSettings"), _a);
__decorateClass([
  Prop({ required: !0 })
], GeneralPageSettings$1.prototype, "value", 2);
GeneralPageSettings$1 = __decorateClass([
  Component({
    components: {
      PermissionsEditor: PermissionEditor
    },
    inject: ["$validator"]
  })
], GeneralPageSettings$1);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("h3", [_vm._v("Page Details")]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.first("name") } }, [_c("label", [_vm._v("Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.name, expression: "name" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("name") }, attrs: { type: "text", name: "name", id: "pageName" }, domProps: { value: _vm.name }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.name = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.first("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("name")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Friendly name of the Page")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.first("id") } }, [_c("label", [_vm._v("Id")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.id, expression: "id" }, { name: "validate", rawName: "v-validate", value: "pageIdUnique|required|alpha_dash", expression: "'pageIdUnique|required|alpha_dash'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("id") }, attrs: { type: "text", name: "id" }, domProps: { value: _vm.id }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.id = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.first("id") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("id")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Unique Id for the page")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Description")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.description, expression: "description" }], staticClass: "form-control", attrs: { type: "text" }, domProps: { value: _vm.description }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.description = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Description of the page")])])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  GeneralPageSettings$1,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "6223c07e"
);
const GeneralPageSettings = __component__.exports;
export {
  GeneralPageSettings as G
};
