/*!
 * Font Awesome Pro 6.7.2 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2024 Fonticons, Inc.
 */
const fa0 = {
  prefix: "fas",
  iconName: "0",
  icon: [320, 512, [], "30", "M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160l0 128c0 88.4-71.6 160-160 160S0 408.4 0 320L0 192zM160 96c-53 0-96 43-96 96l0 128c0 53 43 96 96 96s96-43 96-96l0-128c0-53-43-96-96-96z"]
}, fa1 = {
  prefix: "fas",
  iconName: "1",
  icon: [256, 512, [], "31", "M160 64c0-11.8-6.5-22.6-16.9-28.2s-23-5-32.8 1.6l-96 64C-.5 111.2-4.4 131 5.4 145.8s29.7 18.7 44.4 8.9L96 123.8 96 416l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-352z"]
}, fa2 = {
  prefix: "fas",
  iconName: "2",
  icon: [320, 512, [], "32", "M142.9 96c-21.5 0-42.2 8.5-57.4 23.8L54.6 150.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L40.2 74.5C67.5 47.3 104.4 32 142.9 32C223 32 288 97 288 177.1c0 38.5-15.3 75.4-42.5 102.6L109.3 416 288 416c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L200.2 234.5c15.2-15.2 23.8-35.9 23.8-57.4c0-44.8-36.3-81.1-81.1-81.1z"]
}, fa3 = {
  prefix: "fas",
  iconName: "3",
  icon: [320, 512, [], "33", "M0 64C0 46.3 14.3 32 32 32l240 0c13.2 0 25 8.1 29.8 20.4s1.5 26.3-8.2 35.2L162.3 208l21.7 0c75.1 0 136 60.9 136 136s-60.9 136-136 136l-78.6 0C63 480 24.2 456 5.3 418.1l-1.9-3.8c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3l1.9 3.8c8.1 16.3 24.8 26.5 42.9 26.5l78.6 0c39.8 0 72-32.2 72-72s-32.2-72-72-72L80 272c-13.2 0-25-8.1-29.8-20.4s-1.5-26.3 8.2-35.2L189.7 96 32 96C14.3 96 0 81.7 0 64z"]
}, fa4 = {
  prefix: "fas",
  iconName: "4",
  icon: [384, 512, [], "34", "M189 77.6c7.5-16 .7-35.1-15.3-42.6s-35.1-.7-42.6 15.3L3 322.4c-4.7 9.9-3.9 21.5 1.9 30.8S21 368 32 368l224 0 0 80c0 17.7 14.3 32 32 32s32-14.3 32-32l0-80 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144L82.4 304 189 77.6z"]
}, fa5 = {
  prefix: "fas",
  iconName: "5",
  icon: [320, 512, [], "35", "M32.5 58.3C35.3 43.1 48.5 32 64 32l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L90.7 96 70.3 208 184 208c75.1 0 136 60.9 136 136s-60.9 136-136 136l-83.5 0c-39.4 0-75.4-22.3-93-57.5l-4.1-8.2c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3l4.1 8.2c6.8 13.6 20.6 22.1 35.8 22.1l83.5 0c39.8 0 72-32.2 72-72s-32.2-72-72-72L32 272c-9.5 0-18.5-4.2-24.6-11.5s-8.6-16.9-6.9-26.2l32-176z"]
}, fa6 = {
  prefix: "fas",
  iconName: "6",
  icon: [320, 512, [], "36", "M232.4 84.7c11.4-13.5 9.7-33.7-3.8-45.1s-33.7-9.7-45.1 3.8L38.6 214.7C14.7 242.9 1.1 278.4 .1 315.2c0 1.4-.1 2.9-.1 4.3l0 .5c0 88.4 71.6 160 160 160s160-71.6 160-160c0-85.5-67.1-155.4-151.5-159.8l63.9-75.6zM256 320A96 96 0 1 1 64 320a96 96 0 1 1 192 0z"]
}, fa7 = {
  prefix: "fas",
  iconName: "7",
  icon: [320, 512, [], "37", "M0 64C0 46.3 14.3 32 32 32l256 0c11.5 0 22 6.1 27.7 16.1s5.7 22.2-.1 32.1l-224 384c-8.9 15.3-28.5 20.4-43.8 11.5s-20.4-28.5-11.5-43.8L232.3 96 32 96C14.3 96 0 81.7 0 64z"]
}, fa8 = {
  prefix: "fas",
  iconName: "8",
  icon: [320, 512, [], "38", "M304 160c0-70.7-57.3-128-128-128l-32 0C73.3 32 16 89.3 16 160c0 34.6 13.7 66 36 89C20.5 272.3 0 309.8 0 352c0 70.7 57.3 128 128 128l64 0c70.7 0 128-57.3 128-128c0-42.2-20.5-79.7-52-103c22.3-23 36-54.4 36-89zM176.1 288l15.9 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l15.9 0c0 0 .1 0 .1 0l32 0c0 0 .1 0 .1 0zm0-64c0 0 0 0 0 0l-32 0c0 0 0 0 0 0c-35.3 0-64-28.7-64-64c0-35.3 28.7-64 64-64l32 0c35.3 0 64 28.7 64 64c0 35.3-28.6 64-64 64z"]
}, fa9 = {
  prefix: "fas",
  iconName: "9",
  icon: [320, 512, [], "39", "M64 192a96 96 0 1 0 192 0A96 96 0 1 0 64 192zm87.5 159.8C67.1 347.4 0 277.5 0 192C0 103.6 71.6 32 160 32s160 71.6 160 160c0 2.6-.1 5.3-.2 7.9c-1.7 35.7-15.2 70-38.4 97.4l-145 171.4c-11.4 13.5-31.6 15.2-45.1 3.8s-15.2-31.6-3.8-45.1l63.9-75.6z"]
}, faFillDrip = {
  prefix: "fas",
  iconName: "fill-drip",
  icon: [576, 512, [], "f576", "M41.4 9.4C53.9-3.1 74.1-3.1 86.6 9.4L168 90.7l53.1-53.1c28.1-28.1 73.7-28.1 101.8 0L474.3 189.1c28.1 28.1 28.1 73.7 0 101.8L283.9 481.4c-37.5 37.5-98.3 37.5-135.8 0L30.6 363.9c-37.5-37.5-37.5-98.3 0-135.8L122.7 136 41.4 54.6c-12.5-12.5-12.5-32.8 0-45.3zm176 221.3L168 181.3 75.9 273.4c-4.2 4.2-7 9.3-8.4 14.6l319.2 0 42.3-42.3c3.1-3.1 3.1-8.2 0-11.3L277.7 82.9c-3.1-3.1-8.2-3.1-11.3 0L213.3 136l49.4 49.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0zM512 512c-35.3 0-64-28.7-64-64c0-25.2 32.6-79.6 51.2-108.7c6-9.4 19.5-9.4 25.5 0C543.4 368.4 576 422.8 576 448c0 35.3-28.7 64-64 64z"]
}, faArrowsToCircle = {
  prefix: "fas",
  iconName: "arrows-to-circle",
  icon: [640, 512, [], "e4bd", "M9.4 9.4C21.9-3.1 42.1-3.1 54.6 9.4L160 114.7 160 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 4.3-.9 8.5-2.4 12.2c-1.6 3.7-3.8 7.3-6.9 10.3l-.1 .1c-3.1 3-6.6 5.3-10.3 6.9c-3.8 1.6-7.9 2.4-12.2 2.4l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l18.7 0L9.4 54.6C-3.1 42.1-3.1 21.9 9.4 9.4zM256 256a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM114.7 352L96 352c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0s0 0 0 0l.1 0c8.8 0 16.7 3.6 22.5 9.3l.1 .1c3 3.1 5.3 6.6 6.9 10.3c1.6 3.8 2.4 7.9 2.4 12.2l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-18.7L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L114.7 352zM416 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 18.7L585.4 9.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L525.3 160l18.7 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-8.8 0-16.8-3.6-22.6-9.3l-.1-.1c-3-3.1-5.3-6.6-6.9-10.3s-2.4-7.8-2.4-12.2l0-.1s0 0 0 0l0-96zM525.3 352L630.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L480 397.3l0 18.7c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96s0 0 0 0l0-.1c0-4.3 .9-8.4 2.4-12.2c1.6-3.8 3.9-7.3 6.9-10.4c5.8-5.8 13.7-9.3 22.5-9.4l.1 0s0 0 0 0l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-18.7 0z"]
}, faCircleChevronRight = {
  prefix: "fas",
  iconName: "circle-chevron-right",
  icon: [512, 512, ["chevron-circle-right"], "f138", "M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM241 377c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l87-87-87-87c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L345 239c9.4 9.4 9.4 24.6 0 33.9L241 377z"]
}, faChevronCircleRight = faCircleChevronRight, faWagonCovered = {
  prefix: "fas",
  iconName: "wagon-covered",
  icon: [640, 512, [], "f8ee", "M4.5 57.4C-5.2 30.3 16.1 2.1 44.8 4.1L194.1 14C210.9 15.1 224 29.1 224 45.9L224 224 64 224 4.5 57.4zM288 16l64 0c17.7 0 32 14.3 32 32l0 176-128 0 0-176c0-17.7 14.3-32 32-32zM64 288c0-17.7 14.3-32 32-32l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-1.6 0c20.7 20.3 33.6 48.7 33.6 80c0 61.9-50.1 112-112 112c-56.4 0-103.1-41.7-110.9-96l-66.3 0c-7.8 54.3-54.4 96-110.9 96c-61.9 0-112-50.1-112-112c0-31.3 12.9-59.7 33.6-80L96 320c-17.7 0-32-14.3-32-32zm96 128l-46 0c5.8 22.5 23.5 40.2 46 46l0-46zm0-32l0-46c-22.5 5.8-40.2 23.5-46 46l46 0zm32 78c22.5-5.8 40.2-23.5 46-46l-46 0 0 46zm0-124l0 46 46 0c-5.8-22.5-23.5-40.2-46-46zM448 462l0-46-46 0c5.8 22.5 23.5 40.2 46 46zm-46-78l46 0 0-46c-22.5 5.8-40.2 23.5-46 46zm124 32l-46 0 0 46c22.5-5.8 40.2-23.5 46-46zm0-32c-5.8-22.5-23.5-40.2-46-46l0 46 46 0zM595.2 4.1c28.7-1.9 50 26.2 40.3 53.4L576 224l-160 0 0-178.1c0-16.8 13.1-30.8 29.9-31.9l149.3-10z"]
}, faLineHeight = {
  prefix: "fas",
  iconName: "line-height",
  icon: [576, 512, [], "f871", "M118.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l9.4-9.4 0 229.5-9.4-9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-9.4 9.4 0-229.5 9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64-64zM288 64c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L288 64zm0 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0zM256 416c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0c-17.7 0-32 14.3-32 32z"]
}, faBagel = {
  prefix: "fas",
  iconName: "bagel",
  icon: [640, 512, [129391], "e3d7", "M640 208c0 114.9-93.1 208-208 208c-3.9 0-7.7-.1-11.5-.3c6.5-12.3 12-25.3 16.3-38.8c4.7-.7 9.3-2.5 13.3-5.3L471 357.3c5.1-3.5 11-5.4 17.2-5.6l25.3-.7c13.2-.4 24.8-8.8 29.3-21.3l8.5-23.9c2.1-5.8 5.8-10.9 10.6-14.6L582 275.8c10.5-8.1 14.9-21.7 11.2-34.4L586 217c-1.7-5.9-1.7-12.2 0-18.1l7.2-24.3c3.7-12.7-.7-26.3-11.2-34.4l-20.1-15.5c-4.9-3.8-8.6-8.8-10.6-14.6l-8.5-23.9c-4.4-12.5-16.1-20.9-29.3-21.3l-25.3-.7c-6.2-.2-12.1-2.1-17.2-5.6L450.1 44.4c-10.9-7.5-25.3-7.5-36.2 0L393 58.7c-5.1 3.5-11 5.4-17.2 5.6L350.5 65c-13.2 .4-24.8 8.8-29.3 21.3l-1.8 5.1c-14.4-7.6-29.7-13.7-45.7-18.3C311.8 28.4 368.6 0 432 0C546.9 0 640 93.1 640 208zM396.1 155c10.2-6.9 22.6-11 35.9-11c35.3 0 64 28.7 64 64c0 30.6-21.5 56.3-50.3 62.5c-6-43.3-23.6-82.9-49.5-115.6zM0 304a208 208 0 1 1 416 0A208 208 0 1 1 0 304zm256 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM112 416a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm144 16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48-16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16-176a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM144 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 272a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]
}, faTransporter7 = {
  prefix: "fas",
  iconName: "transporter-7",
  icon: [512, 512, [], "e2a8", "M472.7 38.6c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L448 64l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7s2.7 7.6 6.6 8.7L448 96l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 96l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 64l-7.3-25.4zM64 288l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L32 288 6.6 295.3C2.7 296.4 0 299.9 0 304s2.7 7.6 6.6 8.7L32 320l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 320l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 288zM296 512l88 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l88 0 80 0z"]
}, faAt = {
  prefix: "fas",
  iconName: "at",
  icon: [512, 512, [61946], "40", "M256 64C150 64 64 150 64 256s86 192 192 192c17.7 0 32 14.3 32 32s-14.3 32-32 32C114.6 512 0 397.4 0 256S114.6 0 256 0S512 114.6 512 256l0 32c0 53-43 96-96 96c-29.3 0-55.6-13.2-73.2-33.9C320 371.1 289.5 384 256 384c-70.7 0-128-57.3-128-128s57.3-128 128-128c27.9 0 53.7 8.9 74.7 24.1c5.7-5 13.1-8.1 21.3-8.1c17.7 0 32 14.3 32 32l0 80 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32c0-106-86-192-192-192zm64 192a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]
}, faRectanglesMixed = {
  prefix: "fas",
  iconName: "rectangles-mixed",
  icon: [576, 512, [], "e323", "M0 80C0 53.5 21.5 32 48 32l224 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48L48 256c-26.5 0-48-21.5-48-48L0 80zm384 0c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 256c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-256zM112 304l176 0c26.5 0 48 21.5 48 48l0 80c0 26.5-21.5 48-48 48l-176 0c-26.5 0-48-21.5-48-48l0-80c0-26.5 21.5-48 48-48z"]
}, faPhoneArrowUpRight = {
  prefix: "fas",
  iconName: "phone-arrow-up-right",
  icon: [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", "M295 183l135-135L384 48c-13.3 0-24-10.7-24-24s10.7-24 24-24L488 0c13.3 0 24 10.7 24 24l0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-46.1L329 217c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9zM117.5 1.4c19.4-5.3 39.7 4.6 47.4 23.2l40 96c6.8 16.3 2.1 35.2-11.6 46.3L144 207.3c33.3 70.4 90.3 127.4 160.7 160.7L345 318.7c11.2-13.7 30-18.4 46.3-11.6l96 40c18.6 7.7 28.5 28 23.2 47.4l-24 88C481.8 499.9 466 512 448 512C200.6 512 0 311.4 0 64C0 46 12.1 30.2 29.5 25.4l88-24z"]
}, faPhoneArrowUp = faPhoneArrowUpRight, faPhoneOutgoing = faPhoneArrowUpRight, faTrashCan = {
  prefix: "fas",
  iconName: "trash-can",
  icon: [448, 512, [61460, "trash-alt"], "f2ed", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0L284.2 0c12.1 0 23.2 6.8 28.6 17.7L320 32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 7.2-14.3zM32 128l384 0 0 320c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-320zm96 64c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16z"]
}, faTrashAlt = faTrashCan, faCircleL = {
  prefix: "fas",
  iconName: "circle-l",
  icon: [512, 512, [], "e114", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM208 152l0 184 120 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faHeadSideGoggles = {
  prefix: "fas",
  iconName: "head-side-goggles",
  icon: [512, 512, ["head-vr"], "f6ea", "M45.9 128C75.3 53.1 148.3 0 233.7 0L256 0c39.3 0 75.8 11.8 106.2 32L304 32c-61.9 0-112 50.1-112 112c0 17.2 3.9 33.5 10.8 48L32.2 192l-.2 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l13.9 0zM304 256l203.1 0c3.2 6.2 4.9 13.1 4.9 20.2c0 24.2-19.6 43.8-43.8 43.8L448 320l0 64c0 35.3-28.7 64-64 64l-64 0 0 32c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-104.2c0-17-7.1-33-17.5-46.4C55 299.1 38.3 261.6 33.5 224l192.2 0c20.2 19.8 47.9 32 78.4 32zm0-192l112 0 0 160-112 0c-44.2 0-80-35.8-80-80s35.8-80 80-80zM480 224l-32 0 0-160 32 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32z"]
}, faHeadVr = faHeadSideGoggles, faTextHeight = {
  prefix: "fas",
  iconName: "text-height",
  icon: [576, 512, [], "f034", "M64 128l0-32 64 0 0 320-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-320 64 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48c0-26.5-21.5-48-48-48L160 32 48 32C21.5 32 0 53.5 0 80l0 48c0 17.7 14.3 32 32 32s32-14.3 32-32zM502.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l32 0 0 192-32 0c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8l-32 0 0-192 32 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-64-64z"]
}, faUserXmark = {
  prefix: "fas",
  iconName: "user-xmark",
  icon: [640, 512, ["user-times"], "f235", "M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM0 482.3C0 383.8 79.8 304 178.3 304l91.4 0C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7L29.7 512C13.3 512 0 498.7 0 482.3zM471 143c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z"]
}, faUserTimes = faUserXmark, faFaceHandYawn = {
  prefix: "fas",
  iconName: "face-hand-yawn",
  icon: [512, 512, [], "e379", "M336.9 498.9C438.7 465.1 512 369.1 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256c0 94.5 51.2 177 127.3 221.4c-9.8-18-15.3-38.6-15.3-60.5l0-32.8 0-53.6c0-28.7 23.3-52 52-52c1.8 0 3.6 .1 5.3 .3C184.8 246.3 217.8 224 256 224c28.7 0 54.5 12.6 72.1 32.6c14.8-2.4 30.4 2 41.8 13.4c12.2 12.2 16.5 29.4 12.8 45c1.1 .9 2.2 1.9 3.2 3c18.1 18.1 18.7 47.1 1.8 65.9c16.9 18.8 16.3 47.8-1.8 65.9l-49 49zM204.5 102c5.5 6.9 4.4 17-2.5 22.5l-80 64c-6.9 5.5-17 4.4-22.5-2.5s-4.4-17 2.5-22.5l80-64c6.9-5.5 17-4.4 22.5 2.5zM310 124.5c-6.9-5.5-8-15.6-2.5-22.5s15.6-8 22.5-2.5l80 64c6.9 5.5 8 15.6 2.5 22.5s-15.6 8-22.5 2.5l-80-64zM299.3 276.7c-6.2-6.2-16.4-6.2-22.6 0l-79 79c-5 5-13.7 1.5-13.7-5.7l0-19.7c0-11-9-20-20-20s-20 9-20 20l0 53.6 0 32.8c0 52.6 42.6 95.2 95.2 95.2c25.2 0 49.5-10 67.3-27.9l56.8-56.8c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L321.4 424c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l51.3-51.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L289.4 392c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l67.3-67.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L257.4 360c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l51.3-51.3c6.2-6.2 6.2-16.4 0-22.6z"]
}, faGaugeSimpleMin = {
  prefix: "fas",
  iconName: "gauge-simple-min",
  icon: [512, 512, ["tachometer-slowest"], "f62d", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-35.3-28.7-64-64-64c-14.1 0-27.2 4.6-37.8 12.4L100.6 227.6c-11.3-7-26.1-3.5-33 7.8s-3.5 26.1 7.8 33l117.5 72.8c-.6 3.5-.9 7.1-.9 10.8c0 35.3 28.7 64 64 64s64-28.7 64-64z"]
}, faTachometerSlowest = faGaugeSimpleMin, faStethoscope = {
  prefix: "fas",
  iconName: "stethoscope",
  icon: [576, 512, [129658], "f0f1", "M142.4 21.9c5.6 16.8-3.5 34.9-20.2 40.5L96 71.1 96 192c0 53 43 96 96 96s96-43 96-96l0-120.9-26.1-8.7c-16.8-5.6-25.8-23.7-20.2-40.5s23.7-25.8 40.5-20.2l26.1 8.7C334.4 19.1 352 43.5 352 71.1L352 192c0 77.2-54.6 141.6-127.3 156.7C231 404.6 278.4 448 336 448c61.9 0 112-50.1 112-112l0-70.7c-28.3-12.3-48-40.5-48-73.3c0-44.2 35.8-80 80-80s80 35.8 80 80c0 32.8-19.7 61-48 73.3l0 70.7c0 97.2-78.8 176-176 176c-92.9 0-168.9-71.9-175.5-163.1C87.2 334.2 32 269.6 32 192L32 71.1c0-27.5 17.6-52 43.8-60.7l26.1-8.7c16.8-5.6 34.9 3.5 40.5 20.2zM480 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faCoffin = {
  prefix: "fas",
  iconName: "coffin",
  icon: [384, 512, [9904], "f6c6", "M11.5 114.9l91-104C108.5 4 117.3 0 126.5 0h131c9.2 0 18 4 24.1 10.9l91 104c7.4 8.5 11.5 19.3 11.5 30.6c0 4.4-.6 8.7-1.8 12.9L286.7 488.9c-4 13.7-16.5 23.1-30.7 23.1H128.1c-14.3 0-26.8-9.4-30.7-23.1L1.8 158.3C.6 154.1 0 149.8 0 145.4c0-11.2 4.1-22.1 11.5-30.6z"]
}, faMessage = {
  prefix: "fas",
  iconName: "message",
  icon: [512, 512, ["comment-alt"], "f27a", "M64 0C28.7 0 0 28.7 0 64L0 352c0 35.3 28.7 64 64 64l96 0 0 80c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416 448 416c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L64 0z"]
}, faCommentAlt = faMessage, faSalad = {
  prefix: "fas",
  iconName: "salad",
  icon: [512, 512, [129367, "bowl-salad"], "f81e", "M416 96c2.6 0 5.2 .1 7.8 .2C406.2 76.5 380.5 64 352 64c-8.7 0-17.2 1.2-25.3 3.4C309.5 27.7 270 0 224 0s-85.5 27.7-102.7 67.4c-8-2.2-16.5-3.4-25.3-3.4C43 64 0 107 0 160s43 96 96 96l73.4 0L84.7 171.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L208 249.4 208 112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 144 52 0c-2.6-10.2-4-21-4-32c0-70.7 57.3-128 128-128zM27.4 288C12.3 288 0 300.3 0 315.4c0 70.5 44.4 130.7 106.7 154.1l1.8 14.4c2 16 15.6 28 31.8 28l231.5 0c16.1 0 29.8-12 31.8-28l1.8-14.4C467.6 446.1 512 385.9 512 315.4c0-15.1-12.3-27.4-27.4-27.4L27.4 288zM512 224c0-53-43-96-96-96s-96 43-96 96c0 11.2 1.9 22 5.5 32l181.1 0c3.5-10 5.5-20.8 5.5-32z"]
}, faBowlSalad = faSalad, faInfo = {
  prefix: "fas",
  iconName: "info",
  icon: [192, 512, [], "f129", "M48 80a48 48 0 1 1 96 0A48 48 0 1 1 48 80zM0 224c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 224 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-192-32 0c-17.7 0-32-14.3-32-32z"]
}, faRobotAstromech = {
  prefix: "fas",
  iconName: "robot-astromech",
  icon: [512, 512, [], "e2d2", "M256 0c70.7 0 128 57.3 128 128l0 32-256 0 0-32C128 57.3 185.3 0 256 0zm0 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm48 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM48 240c0-26.5 21.5-48 48-48l320 0c26.5 0 48 21.5 48 48l0 158.3c0 8.7 2.4 17.2 6.8 24.7l38.9 64.8c3 4.9 3 11.1 .2 16.1s-8.2 8.1-13.9 8.1l-96 0c-8.8 0-16-7.2-16-16l0-112-45.3 45.3c-12 12-28.3 18.7-45.3 18.7l-75 0c-17 0-33.3-6.7-45.3-18.7L128 384l0 112c0 8.8-7.2 16-16 16l-96 0c-5.8 0-11.1-3.1-13.9-8.1s-2.8-11.2 .2-16.1L41.2 423c4.5-7.5 6.8-16 6.8-24.7L48 240zm160 16c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0z"]
}, faRingDiamond = {
  prefix: "fas",
  iconName: "ring-diamond",
  icon: [384, 512, [], "e5ab", "M122.5 13.3C126.6 5.1 134.9 0 144 0l96 0c9.1 0 17.4 5.1 21.5 13.3l24 48c3.5 7.1 3.4 15.5-.5 22.4l-30.4 54.8C329.9 164.4 384 235.9 384 320c0 106-86 192-192 192S0 426 0 320c0-84.1 54.1-155.6 129.4-181.6L99 83.7c-3.8-6.9-4-15.3-.5-22.4l24-48zM192 192a128 128 0 1 0 0 256 128 128 0 1 0 0-256z"]
}, faFonduePot = {
  prefix: "fas",
  iconName: "fondue-pot",
  icon: [512, 512, [129749], "e40d", "M319 39.8l-24 96c-2.9 11.5-11.6 20-22.2 23L264.5 192l-33 0 10.2-41c-7.9-7.7-11.7-19.3-8.8-30.8l24-96C261.2 7.1 278.6-3.3 295.8 1s27.6 21.7 23.3 38.8zm62.9 120.2L360.6 192l-38.5 0 33.2-49.8c-4.9-9.9-4.5-22.1 2.1-31.9l64-96C431.2-.5 451-4.4 465.8 5.4s18.7 29.7 8.9 44.4l-64 96c-6.6 9.9-17.7 14.9-28.7 14.2zM32 224l32 0 0 16 0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c0-8.8 7.2-16 16-16s16 7.2 16 16s7.2 16 16 16s16-7.2 16-16l0-32 0-16 224 0 64 0 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 32c0 52.3-25.1 98.8-64 128l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-3.2c-10.3 2.1-21 3.2-32 3.2l-128 0c-11 0-21.7-1.1-32-3.2l0 3.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32C25.1 418.8 0 372.3 0 320l0-64c0-17.7 14.3-32 32-32z"]
}, faTheta = {
  prefix: "fas",
  iconName: "theta",
  icon: [384, 512, [], "f69e", "M64 256c0-51 15.9-96 40.2-127.6C128.5 96.9 159.8 80 192 80s63.5 16.9 87.8 48.4C304.1 160 320 205 320 256s-15.9 96-40.2 127.6C255.5 415.1 224.2 432 192 432s-63.5-16.9-87.8-48.4C79.9 352 64 307 64 256zM192 16C135.8 16 87.1 45.7 53.5 89.4C19.9 133.1 0 192.1 0 256s19.9 122.9 53.5 166.6C87.1 466.3 135.8 496 192 496s104.9-29.7 138.5-73.4C364.1 378.9 384 319.9 384 256s-19.9-122.9-53.5-166.6C296.9 45.7 248.2 16 192 16zM128 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0z"]
}, faFaceHandPeeking = {
  prefix: "fas",
  iconName: "face-hand-peeking",
  icon: [640, 512, [129763], "e481", "M497.8 144.3c12.9-12.9 31.8-16.1 47.7-9.6C502.2 54.5 417.5 0 320 0C248.5 0 183.8 29.3 137.3 76.6c7.7 1.8 14.9 5.7 20.9 11.7c17.2 17.2 17.2 45 0 62.2l-1.5 1.5 75.2 0c22.1 0 40 17.9 40 40c0 2.6-.2 5.1-.7 7.5c10.1 7.3 16.7 19.1 16.7 32.5s-6.6 25.3-16.7 32.5c.5 2.4 .7 4.9 .7 7.5c0 22.1-17.9 40-40 40l-8 0c0 .3 0 .6 0 .9c0 22.1-17.9 40-40 40l-64.8 0c-13.3 0-26.4-2.2-38.8-6.5C117 443.2 210.4 512 320 512c91.5 0 171.8-48 217.1-120.2c-5.4 .7-10.8 1.1-16.3 1.1l-64.8 0c-22.1 0-40-17.9-40-40l0-.3 0-.6-8 0c-22.1 0-40-17.9-40-40c0-1.1 0-2.2 .1-3.3c-37-10.4-64.1-44.4-64.1-84.7c0-48.6 39.4-88 88-88c6.6 0 13 .7 19.2 2.1c11.8-4 25.2-2.4 36.1 5.4l37.9 27.1c1.1-9.6 5.3-18.9 12.6-26.2zM320 448c-35.3 0-64-21.5-64-48s28.7-48 64-48s64 21.5 64 48s-28.7 48-64 48zm90.3-208c3.8-4.2 6.1-9.9 6.1-16c0-13.3-10.7-24-24-24s-24 10.7-24 24c0 6.1 2.3 11.8 6.1 16l35.8 0zM248 192c0-8.8-7.2-16-16-16l-113.8 0c-7.1 0-10.7-8.6-5.7-13.7l28.8-28.8c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0L51.9 166.4l-.8 .8C14.7 204.4 15 264.1 51.9 301c17.9 17.9 42.1 27.9 67.3 27.9l64.8 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-14 0c-2.5 0-4.5-2-4.5-4.5s2-4.5 4.5-4.5l62 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-62.4 0c-2.2 0-4-1.8-4-4s1.8-4 4-4l78.4 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-78.4 0c-2.2 0-4-1.8-4-4s1.8-4 4-4l62.4 0c8.8 0 16-7.2 16-16zm163-25.3c-5.1 7.2-3.5 17.2 3.7 22.3l59.7 42.6c3.5 2.5 5.6 6.6 5.6 10.9c0 7.4-6 13.4-13.4 13.4L392 256c-8.8 0-16 7.2-16 16s7.2 16 16 16l84 0c2.2 0 4 1.8 4 4s-1.8 4-4 4l-68 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l67.5 0c2.5 0 4.5 2 4.5 4.5s-2 4.5-4.5 4.5l-19.5 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64.8 0c25.2 0 49.5-10 67.3-27.9c36.9-36.9 37.2-96.6 .8-133.8l-.8-.8L543 161.3c-7.8-7.8-20.5-7.8-28.3 0s-7.8 20.5 0 28.3l14.8 14.8c6.6 6.6 2.7 18-6.6 19c-2.8 .3-5.6-.4-7.8-2L433.3 163c-7.2-5.1-17.2-3.5-22.3 3.7z"]
}, faSquareUser = {
  prefix: "fas",
  iconName: "square-user",
  icon: [448, 512, [], "e283", "M81.1 416l285.7 0c-7.8-54.3-54.4-96-110.9-96l-64 0c-56.4 0-103.1 41.7-110.9 96zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM224 272a72 72 0 1 0 0-144 72 72 0 1 0 0 144z"]
}, faDownLeftAndUpRightToCenter = {
  prefix: "fas",
  iconName: "down-left-and-up-right-to-center",
  icon: [512, 512, ["compress-alt"], "f422", "M439 7c9.4-9.4 24.6-9.4 33.9 0l32 32c9.4 9.4 9.4 24.6 0 33.9l-87 87 39 39c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8l-144 0c-13.3 0-24-10.7-24-24l0-144c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l39 39L439 7zM72 272l144 0c13.3 0 24 10.7 24 24l0 144c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-39-39L73 505c-9.4 9.4-24.6 9.4-33.9 0L7 473c-9.4-9.4-9.4-24.6 0-33.9l87-87L55 313c-6.9-6.9-8.9-17.2-5.2-26.2s12.5-14.8 22.2-14.8z"]
}, faCompressAlt = faDownLeftAndUpRightToCenter, faExplosion = {
  prefix: "fas",
  iconName: "explosion",
  icon: [576, 512, [], "e4e9", "M499.6 11.3c6.7-10.7 20.5-14.5 31.7-8.5s15.8 19.5 10.6 31L404.8 338.6c2.2 2.3 4.3 4.7 6.3 7.1l97.2-54.7c10.5-5.9 23.6-3.1 30.9 6.4s6.3 23-2.2 31.5l-87 87-71.4 0c-13.2-37.3-48.7-64-90.5-64s-77.4 26.7-90.5 64l-79.6 0L42.3 363.7c-9.7-6.7-13.1-19.6-7.9-30.3s17.4-15.9 28.7-12.4l97.2 30.4c3-3.9 6.1-7.7 9.4-11.3L107.4 236.3c-6.1-10.1-3.9-23.1 5.1-30.7s22.2-7.5 31.1 .1L246 293.6c1.5-.4 3-.8 4.5-1.1l13.6-142.7c1.2-12.3 11.5-21.7 23.9-21.7s22.7 9.4 23.9 21.7l13.5 141.9L499.6 11.3zM64 448s0 0 0 0l448 0s0 0 0 0l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0zM288 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"]
}, faFileLines = {
  prefix: "fas",
  iconName: "file-lines",
  icon: [384, 512, [128441, 128462, 61686, "file-alt", "file-text"], "f15c", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM112 256l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faFileAlt = faFileLines, faFileText = faFileLines, faWaveSquare = {
  prefix: "fas",
  iconName: "wave-square",
  icon: [640, 512, [], "f83e", "M128 64c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 352 96 0 0-160c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0 0 160c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-352-96 0 0 160c0 17.7-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0 0-160z"]
}, faRing = {
  prefix: "fas",
  iconName: "ring",
  icon: [512, 512, [], "f70b", "M64 208c0 7.8 4.4 18.7 17.1 30.3C126.5 214.1 188.9 200 256 200s129.5 14.1 174.9 38.3C443.6 226.7 448 215.8 448 208c0-12.3-10.8-32-47.9-50.6C364.9 139.8 314 128 256 128s-108.9 11.8-144.1 29.4C74.8 176 64 195.7 64 208zm192 40c-47 0-89.3 7.6-122.9 19.7C166.3 280.2 208.8 288 256 288s89.7-7.8 122.9-20.3C345.3 255.6 303 248 256 248zM0 208c0-49.6 39.4-85.8 83.3-107.8C129.1 77.3 190.3 64 256 64s126.9 13.3 172.7 36.2c43.9 22 83.3 58.2 83.3 107.8l0 96c0 49.6-39.4 85.8-83.3 107.8C382.9 434.7 321.7 448 256 448s-126.9-13.3-172.7-36.2C39.4 389.8 0 353.6 0 304l0-96z"]
}, faBuildingUn = {
  prefix: "fas",
  iconName: "building-un",
  icon: [384, 512, [], "e4d9", "M48 0C21.5 0 0 21.5 0 48L0 464c0 26.5 21.5 48 48 48l96 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 96 0c26.5 0 48-21.5 48-48l0-416c0-26.5-21.5-48-48-48L48 0zM64 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm112-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM237.3 71.1l34.7 52L272 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 7.1-4.6 13.3-11.4 15.3s-14-.6-17.9-6.4l-34.7-52 0 43.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4zM112 80l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16z"]
}, faDiceThree = {
  prefix: "fas",
  iconName: "dice-three",
  icon: [448, 512, [9858], "f527", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faTirePressureWarning = {
  prefix: "fas",
  iconName: "tire-pressure-warning",
  icon: [512, 512, [], "f633", "M384 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 22.5c0 24.1 3.9 48 11.5 70.8l2.5 7.4c4.8 14.4 11.5 28.6 19.3 44.4c17.5 35.6 33.4 82.6 27.5 136.2c-5.3 48.6-28.1 99-76.8 148.7l0 34c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-8-32 0 0 8c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-8-32 0 0 8c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-8-32 0 0 8c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-34C31.3 412.3 8.6 361.9 3.2 313.3c-5.9-53.6 9.9-100.6 27.5-136.2c7.8-15.8 14.5-30 19.3-44.4l2.5-7.4C60.1 102.5 64 78.5 64 54.5L64 32C64 14.3 78.3 0 96 0s32 14.3 32 32l0 22.5c0 31-5 61.7-14.8 91.1l-2.5 7.4c-6.3 19-14.8 36.6-22.6 52.5c-14.7 29.7-25.3 64-21.3 100.9c3.7 34 20.4 74.1 65.7 117.7l246.8 0c45.3-43.6 62-83.7 65.7-117.7c4.1-36.9-6.6-71.1-21.3-100.9c-7.8-15.8-16.3-33.5-22.6-52.5l-2.5-7.4C389 116.2 384 85.4 384 54.5L384 32zM280 120l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24s24 10.7 24 24zM256 288a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faWifiFair = {
  prefix: "fas",
  iconName: "wifi-fair",
  icon: [640, 512, ["wifi-2"], "f6ab", "M171.8 312c39.5-34.9 91.3-56 148.2-56s108.7 21.1 148.2 56c13.3 11.7 33.5 10.4 45.2-2.8s10.4-33.5-2.8-45.2C459.8 219.2 393 192 320 192s-139.8 27.2-190.5 72c-13.3 11.7-14.5 31.9-2.8 45.2s31.9 14.5 45.2 2.8zM320 480a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]
}, faWifi2 = faWifiFair, faCalendarDays = {
  prefix: "fas",
  iconName: "calendar-days",
  icon: [448, 512, ["calendar-alt"], "f073", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 48 0c26.5 0 48 21.5 48 48l0 48L0 160l0-48C0 85.5 21.5 64 48 64l48 0 0-32c0-17.7 14.3-32 32-32zM0 192l448 0 0 272c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 192zm64 80l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm128 0l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm144-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM64 400l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm144-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm112 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]
}, faCalendarAlt = faCalendarDays, faMp3Player = {
  prefix: "fas",
  iconName: "mp3-player",
  icon: [384, 512, [], "f8ce", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM192 320a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 128a96 96 0 1 0 0-192 96 96 0 1 0 0 192zM96 64C78.3 64 64 78.3 64 96l0 64c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L96 64z"]
}, faAnchorCircleCheck = {
  prefix: "fas",
  iconName: "anchor-circle-check",
  icon: [640, 512, [], "e4aa", "M320 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm21.1 80C367 158.8 384 129.4 384 96c0-53-43-96-96-96s-96 43-96 96c0 33.4 17 62.8 42.9 80L224 176c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 208-48 0c-53 0-96-43-96-96l0-6.1 7 7c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L97 263c-9.4-9.4-24.6-9.4-33.9 0L7 319c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l7-7 0 6.1c0 88.4 71.6 160 160 160l80 0 80 0c8.2 0 16.3-.6 24.2-1.8c-22.2-16.2-40.4-37.5-53-62.2L320 448l0-80 0-128 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-10.9 0zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-76.7-43.3c6.2 6.2 6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0z"]
}, faTally4 = {
  prefix: "fas",
  iconName: "tally-4",
  icon: [640, 512, [], "e297", "M160 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384zm128 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384zm96-32c-17.7 0-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32zM544 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384z"]
}, faRectangleHistory = {
  prefix: "fas",
  iconName: "rectangle-history",
  icon: [512, 512, [], "e4a2", "M512 224c0-35.3-28.7-64-64-64L64 160c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-224zM440 80L72 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l368 0c13.3 0 24-10.7 24-24s-10.7-24-24-24zM392 0L120 0C106.7 0 96 10.7 96 24s10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24z"]
}, faBuildingCircleArrowRight = {
  prefix: "fas",
  iconName: "building-circle-arrow-right",
  icon: [640, 512, [], "e4d1", "M0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 184.2c-39.1 32.3-64 81.1-64 135.8c0 49.5 20.4 94.2 53.3 126.2C364.5 505.1 351.1 512 336 512l-96 0 0-80c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 80-96 0c-26.5 0-48-21.5-48-48L0 48zM80 224c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm80 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM64 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L80 96c-8.8 0-16 7.2-16 16zM176 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm80 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96 256a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm140.7-67.3c-6.2 6.2-6.2 16.4 0 22.6L521.4 352 432 352c-8.8 0-16 7.2-16 16s7.2 16 16 16l89.4 0-28.7 28.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l56-56c6.2-6.2 6.2-16.4 0-22.6l-56-56c-6.2-6.2-16.4-6.2-22.6 0z"]
}, faVolleyball = {
  prefix: "fas",
  iconName: "volleyball",
  icon: [512, 512, [127952, "volleyball-ball"], "f45f", "M511.8 267.4c-26.1 8.7-53.4 13.8-81 15.1c9.2-105.3-31.5-204.2-103.2-272.4C434.1 41.1 512 139.5 512 256c0 3.8-.1 7.6-.2 11.4zm-3.9 34.7c-5.8 32-17.6 62-34.2 88.7c-97.5 48.5-217.7 42.6-311.9-24.5c23.7-36.2 55.4-67.7 94.5-91.8c79.9 43.2 170.1 50.8 251.6 27.6zm-236-55.5c-2.5-90.9-41.1-172.7-101.9-231.7C196.8 5.2 225.8 0 256 0c2.7 0 5.3 0 7.9 .1c90.8 60.2 145.7 167.2 134.7 282.3c-43.1-2.4-86.4-14.1-126.8-35.9zM138 28.8c20.6 18.3 38.7 39.4 53.7 62.6C95.9 136.1 30.6 220.8 7.3 316.9C2.5 297.4 0 277 0 256C0 157.2 56 71.5 138 28.8zm69.6 90.5c19.5 38.6 31 81.9 32.3 127.7C162.5 294.6 110.9 368.9 90.2 451C66 430.4 45.6 405.4 30.4 377.2c6.7-108.7 71.9-209.9 177.1-257.9zM256 512c-50.7 0-98-14.7-137.8-40.2c5.6-27 14.8-53.1 27.4-77.7C232.2 454.6 338.1 468.8 433 441c-46 44-108.3 71-177 71z"]
}, faVolleyballBall = faVolleyball, faSunHaze = {
  prefix: "fas",
  iconName: "sun-haze",
  icon: [640, 512, [], "f765", "M425.5 1.2c5 2.1 8.6 6.6 9.6 11.9L455 121l107.9 19.8c5.3 1 9.8 4.6 11.9 9.6s1.5 10.7-1.6 15.2L510.9 256 448 256c0-70.7-57.3-128-128-128s-128 57.3-128 128l-62.9 0L66.8 165.7c-3.1-4.5-3.7-10.2-1.6-15.2s6.6-8.6 11.9-9.6L185 121 204.9 13.1c1-5.3 4.6-9.8 9.6-11.9s10.7-1.5 15.2 1.6L320 65.1 410.3 2.8c4.5-3.1 10.2-3.7 15.2-1.6zM320 160c53 0 96 43 96 96l-192 0c0-53 43-96 96-96zM616 288c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0zm-208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 336c-13.3 0-24-10.7-24-24s10.7-24 24-24l320 0zm144 88c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 424c-13.3 0-24-10.7-24-24s10.7-24 24-24l528 0zM64 488c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 512c-13.3 0-24-10.7-24-24zm208 0c0-13.3 10.7-24 24-24l320 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-320 0c-13.3 0-24-10.7-24-24z"]
}, faTextSize = {
  prefix: "fas",
  iconName: "text-size",
  icon: [640, 512, [], "f894", "M64 128l0-32 96 0 0 320-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-320 96 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48c0-26.5-21.5-48-48-48L192 32 48 32C21.5 32 0 53.5 0 80l0 48c0 17.7 14.3 32 32 32s32-14.3 32-32zM384 304l0-16 64 0 0 128-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128 64 0 0 16c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32c0-26.5-21.5-48-48-48l-224 0c-26.5 0-48 21.5-48 48l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32z"]
}, faUfo = {
  prefix: "fas",
  iconName: "ufo",
  icon: [640, 512, [128760], "e047", "M320 112c59.2 0 109.6 37.9 128.3 90.7c5 14.2 7.7 29.4 7.7 45.3c0 0-40 40-136 40s-136-40-136-40c0-15.9 2.7-31.1 7.7-45.3c18.7-52.8 69-90.7 128.3-90.7zm0-48c-90.1 0-165.2 64.8-180.9 150.4C55.1 237.5 0 276.2 0 320c0 70.7 143.3 128 320 128s320-57.3 320-128c0-43.8-55.1-82.5-139.1-105.6C485.2 128.8 410.2 64 320 64zm0 288a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM104 328a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm408-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]
}, faFork = {
  prefix: "fas",
  iconName: "fork",
  icon: [512, 512, ["utensil-fork"], "f2e3", "M412.4 5.9c5.2 6.4 4.8 15.6-1.1 21.5L320 118.6c-5.2 5.2-5.2 13.6 0 18.8c4.9 4.9 12.8 5.2 18.1 .6l99.4-86.1c6.3-5.5 15.9-5.2 21.8 .8s6.3 15.4 .8 21.8L374 173.9c-4.6 5.3-4.3 13.2 .6 18.1c5.2 5.2 13.6 5.2 18.8 0l91.3-91.3c5.8-5.8 15.1-6.3 21.5-1.1s7.7 14.4 3.2 21.2l-71 106.5c-18.6 27.9-49.9 44.6-83.4 44.6c-19.3 0-37.9-5.5-53.9-15.7L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L255.7 211c-10.2-16-15.7-34.7-15.7-53.9c0-33.5 16.8-64.8 44.6-83.4l106.5-71c6.8-4.6 16-3.2 21.2 3.2z"]
}, faUtensilFork = faFork, faArrowsUpToLine = {
  prefix: "fas",
  iconName: "arrows-up-to-line",
  icon: [576, 512, [], "e4c2", "M32 96l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64S14.3 96 32 96zM9.4 233.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 237.3 96 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96c-12.5-12.5-32.8-12.5-45.3 0l-96 96zm320 45.3c12.5 12.5 32.8 12.5 45.3 0L416 237.3 416 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3z"]
}, faMobileSignal = {
  prefix: "fas",
  iconName: "mobile-signal",
  icon: [512, 512, [], "e1ef", "M64 64l224 0 0 251.7c18.3-21.2 39.9-39.5 64-54L352 64c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l160 0 0-24c0-13.6 1-27 3-40L64 448 64 64zm80 320c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0zM488 256c-128.1 0-232 103.9-232 232c0 13.3 10.7 24 24 24s24-10.7 24-24c0-101.6 82.4-184 184-184c13.3 0 24-10.7 24-24s-10.7-24-24-24zm-8 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32-136c0-13.3-10.7-24-24-24c-75.1 0-136 60.9-136 136c0 13.3 10.7 24 24 24s24-10.7 24-24c0-48.6 39.4-88 88-88c13.3 0 24-10.7 24-24z"]
}, faBarcodeScan = {
  prefix: "fas",
  iconName: "barcode-scan",
  icon: [640, 512, [], "f465", "M88 32C74.7 32 64 42.7 64 56l0 136 64 0 0-136c0-13.3-10.7-24-24-24L88 32zM64 456c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-136-64 0 0 136zm96 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144-32 0 0 144zm64-8c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-136-64 0 0 136zm0-264l64 0 0-136c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24l0 136zm96 264c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-136-64 0 0 136zm0-264l64 0 0-136c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24l0 136zM448 464c0 8.8 7.2 16 16 16s16-7.2 16-16l0-144-32 0 0 144zm0-416l0 144 32 0 0-144c0-8.8-7.2-16-16-16s-16 7.2-16 16zm64 408c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-136-64 0 0 136zm0-264l64 0 0-136c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24l0 136zm-352 0l32 0 0-144c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 144zM24 232c-13.3 0-24 10.7-24 24s10.7 24 24 24l592 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 232z"]
}, faSortDown = {
  prefix: "fas",
  iconName: "sort-down",
  icon: [320, 512, ["sort-desc"], "f0dd", "M182.6 470.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8l256 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128z"]
}, faSortDesc = faSortDown, faFolderArrowDown = {
  prefix: "fas",
  iconName: "folder-arrow-down",
  icon: [512, 512, ["folder-download"], "e053", "M512 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l128 0c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8l160 0c35.3 0 64 28.7 64 64l0 256zM280 200c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 102.1-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-31 31L280 200z"]
}, faFolderDownload = faFolderArrowDown, faCircleMinus = {
  prefix: "fas",
  iconName: "circle-minus",
  icon: [512, 512, ["minus-circle"], "f056", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 232l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faMinusCircle = faCircleMinus, faFaceIcicles = {
  prefix: "fas",
  iconName: "face-icicles",
  icon: [512, 512, [], "e37c", "M512 256c0 8.3-.4 16.6-1.2 24.7c0 .5-.1 1.1-.1 1.6l-14.8 200C494.7 499.1 480.8 512 464 512s-30.7-12.9-31.9-29.6l-2.8-37.9c-5 4.6-10.2 9-15.6 13.2l-11.5 32.9C397.7 503.4 385.6 512 372 512c-11.5 0-21.9-6.1-27.5-15.7C316.9 506.5 287.1 512 256 512c-69.4 0-132.3-27.6-178.4-72.4C71.9 444.9 64.3 448 56 448c-15.6 0-29-11.3-31.6-26.7L6.5 313.4C2.2 294.9 0 275.7 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256zM56 415.8l0 .2 0-.2 20-120.2C78.1 283.3 68.6 272 56 272s-22.1 11.3-20.1 23.7L56 415.8zM344 400l28 80 28-80 0-40-56 0 0 40zm55.3-56c-3.8-22.7-23.6-40-47.3-40l-8 0 0 40 55.3 0zM328 344l0-40-64 0 0 40 64 0zm0 56l0-40-64 0 0 40 32 48 32-48zm-80-96l-64 0 0 40 64 0 0-40zm0 56l-64 0 0 40 64 0 0-40zm-80-16l0-40-8 0c-23.8 0-43.5 17.3-47.3 40l55.3 0zm0 56l0-40-55.3 0c3.8 22.7 23.6 40 47.3 40l8 0zm40.4-192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM464 480l21.8-232.1C487 235.1 476.9 224 464 224s-23 11.1-21.8 23.9L464 480z"]
}, faShovel = {
  prefix: "fas",
  iconName: "shovel",
  icon: [512, 512, [], "f713", "M361.4 9.4c12.5-12.5 32.8-12.5 45.3 0l96 96c12.5 12.5 12.5 32.8 0 45.3l-44.1 44.1c-18.7 18.7-44.1 29.3-70.6 29.3c-15.9 0-30.9-3.7-44.3-10.3l-97 97 50.7 50.7c12.5 12.5 12.5 32.8 0 45.3l-58.5 58.5c-30 30-70.7 46.9-113.1 46.9L32 512c-17.7 0-32-14.3-32-32l0-93.7c0-42.4 16.9-83.1 46.9-113.1l58.5-58.5c12.5-12.5 32.8-12.5 45.3 0l50.7 50.7 97-97C291.7 155.1 288 140 288 124.1c0-26.5 10.5-51.9 29.3-70.6L361.4 9.4zM384 77.3L362.5 98.7c-6.7 6.7-10.5 15.9-10.5 25.4c0 19.8 16.1 35.9 35.9 35.9c9.5 0 18.6-3.8 25.4-10.5L434.7 128 384 77.3z"]
}, faDoorOpen = {
  prefix: "fas",
  iconName: "door-open",
  icon: [576, 512, [], "f52b", "M320 32c0-9.9-4.5-19.2-12.3-25.2S289.8-1.4 280.2 1l-179.9 45C79 51.3 64 70.5 64 92.5L64 448l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0 192 0 32 0 0-32 0-448zM256 256c0 17.7-10.7 32-24 32s-24-14.3-24-32s10.7-32 24-32s24 14.3 24 32zm96-128l96 0 0 352c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-320c0-35.3-28.7-64-64-64l-96 0 0 64z"]
}, faFilms = {
  prefix: "fas",
  iconName: "films",
  icon: [576, 512, [], "e17a", "M160 32c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l352 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L160 32zm8 48l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zM472 96c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zM168 184l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zm304 16c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zM168 288l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16zm304 16c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zM288 80l96 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32zM256 256c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-48zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120L0 344c0 75.1 60.9 136 136 136l320 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-320 0c-48.6 0-88-39.4-88-88l0-224z"]
}, faRightFromBracket = {
  prefix: "fas",
  iconName: "right-from-bracket",
  icon: [512, 512, ["sign-out-alt"], "f2f5", "M377.9 105.9L500.7 228.7c7.2 7.2 11.3 17.1 11.3 27.3s-4.1 20.1-11.3 27.3L377.9 406.1c-6.4 6.4-15 9.9-24 9.9c-18.7 0-33.9-15.2-33.9-33.9l0-62.1-128 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l128 0 0-62.1c0-18.7 15.2-33.9 33.9-33.9c9 0 17.6 3.6 24 9.9zM160 96L96 96c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32z"]
}, faSignOutAlt = faRightFromBracket, faFaceGlasses = {
  prefix: "fas",
  iconName: "face-glasses",
  icon: [512, 512, [], "e377", "M512 256c0 141.4-114.6 256-256 256S0 397.4 0 256c0-22.1 2.8-43.5 8.1-64L48 192l0 56c0 30.9 25.1 56 56 56l80 0c30.9 0 56-25.1 56-56l0-56 32 0 0 56c0 30.9 25.1 56 56 56l80 0c30.9 0 56-25.1 56-56l0-56 39.9 0c5.3 20.5 8.1 41.9 8.1 64zM256 0C363.4 0 455.4 66.2 493.4 160l-34.8 0c-9-18.9-28.3-32-50.6-32l-80 0c-22.3 0-41.6 13.1-50.6 32l-42.8 0c-9-18.9-28.3-32-50.6-32l-80 0c-22.3 0-41.6 13.1-50.6 32l-34.8 0C56.6 66.2 148.6 0 256 0zM80 192l0-8c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24l0 64c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-56zm61.5 147.9c-6.7 5.8-7.4 15.9-1.6 22.6c22.2 25.7 61 53.5 116.1 53.5s93.8-27.9 116.1-53.5c5.8-6.7 5.1-16.8-1.6-22.6s-16.8-5.1-22.6 1.6C330 362.2 299.4 384 256 384s-74-21.8-91.9-42.5c-5.8-6.7-15.9-7.4-22.6-1.6zM304 184c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24l0 8 0 56c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-64zM184.4 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm168 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faNfc = {
  prefix: "fas",
  iconName: "nfc",
  icon: [448, 512, [], "e1f7", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 48l0 224c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48l-80 0c-26.5 0-48 21.5-48 48l0 66.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3l0-66.7c0-8.8 7.2-16 16-16l80 0c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-26.5 0-48 21.5-48 48z"]
}, faAtom = {
  prefix: "fas",
  iconName: "atom",
  icon: [512, 512, [9883], "f5d2", "M256 398.8c-11.8 5.1-23.4 9.7-34.9 13.5c16.7 33.8 31 35.7 34.9 35.7s18.1-1.9 34.9-35.7c-11.4-3.9-23.1-8.4-34.9-13.5zM446 256c33 45.2 44.3 90.9 23.6 128c-20.2 36.3-62.5 49.3-115.2 43.2c-22 52.1-55.6 84.8-98.4 84.8s-76.4-32.7-98.4-84.8c-52.7 6.1-95-6.8-115.2-43.2C21.7 346.9 33 301.2 66 256c-33-45.2-44.3-90.9-23.6-128c20.2-36.3 62.5-49.3 115.2-43.2C179.6 32.7 213.2 0 256 0s76.4 32.7 98.4 84.8c52.7-6.1 95 6.8 115.2 43.2c20.7 37.1 9.4 82.8-23.6 128zm-65.8 67.4c-1.7 14.2-3.9 28-6.7 41.2c31.8 1.4 38.6-8.7 40.2-11.7c2.3-4.2 7-17.9-11.9-48.1c-6.8 6.3-14 12.5-21.6 18.6zm-6.7-175.9c2.8 13.1 5 26.9 6.7 41.2c7.6 6.1 14.8 12.3 21.6 18.6c18.9-30.2 14.2-44 11.9-48.1c-1.6-2.9-8.4-13-40.2-11.7zM290.9 99.7C274.1 65.9 259.9 64 256 64s-18.1 1.9-34.9 35.7c11.4 3.9 23.1 8.4 34.9 13.5c11.8-5.1 23.4-9.7 34.9-13.5zm-159 88.9c1.7-14.3 3.9-28 6.7-41.2c-31.8-1.4-38.6 8.7-40.2 11.7c-2.3 4.2-7 17.9 11.9 48.1c6.8-6.3 14-12.5 21.6-18.6zM110.2 304.8C91.4 335 96 348.7 98.3 352.9c1.6 2.9 8.4 13 40.2 11.7c-2.8-13.1-5-26.9-6.7-41.2c-7.6-6.1-14.8-12.3-21.6-18.6zM336 256a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zm-80-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faSoap = {
  prefix: "fas",
  iconName: "soap",
  icon: [512, 512, [129532], "e06e", "M208 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM320 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM416 32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0 160c0 27.6-11.7 52.5-30.4 70.1C422.1 275.7 448 310.8 448 352c0 53-43 96-96 96l-192 0c-53 0-96-43-96-96s43-96 96-96l88.4 0c-15.2-17-24.4-39.4-24.4-64L96 192c-53 0-96 43-96 96L0 416c0 53 43 96 96 96l320 0c53 0 96-43 96-96l0-128c0-53-43-96-96-96zM160 288c-35.3 0-64 28.7-64 64s28.7 64 64 64l192 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-32 0-160 0z"]
}, faIcons = {
  prefix: "fas",
  iconName: "icons",
  icon: [512, 512, ["heart-music-camera-bolt"], "f86d", "M500.3 7.3C507.7 13.3 512 22.4 512 32l0 144c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48l0-57L352 90.2 352 208c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48l0-96c0-15.3 10.8-28.4 25.7-31.4l160-32c9.4-1.9 19.1 .6 26.6 6.6zM74.7 304l11.8-17.8c5.9-8.9 15.9-14.2 26.6-14.2l61.7 0c10.7 0 20.7 5.3 26.6 14.2L213.3 304l26.7 0c26.5 0 48 21.5 48 48l0 112c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 352c0-26.5 21.5-48 48-48l26.7 0zM192 408a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM478.7 278.3L440.3 368l55.7 0c6.7 0 12.6 4.1 15 10.4s.6 13.3-4.4 17.7l-128 112c-5.6 4.9-13.9 5.3-19.9 .9s-8.2-12.4-5.3-19.2L391.7 400 336 400c-6.7 0-12.6-4.1-15-10.4s-.6-13.3 4.4-17.7l128-112c5.6-4.9 13.9-5.3 19.9-.9s8.2 12.4 5.3 19.2zm-339-59.2c-6.5 6.5-17 6.5-23 0L19.9 119.2c-28-29-26.5-76.9 5-103.9c27-23.5 68.4-19 93.4 6.5l10 10.5 9.5-10.5c25-25.5 65.9-30 93.9-6.5c31 27 32.5 74.9 4.5 103.9l-96.4 99.9z"]
}, faHeartMusicCameraBolt = faIcons, faMicrophoneLinesSlash = {
  prefix: "fas",
  iconName: "microphone-lines-slash",
  icon: [640, 512, ["microphone-alt-slash"], "f539", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L472.1 344.7c15.2-26 23.9-56.3 23.9-88.7l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24 0 16c0 21.2-5.1 41.1-14.2 58.7L416 300.8l0-44.8-57.1 0-34.5-27c2.9-3.1 7-5 11.6-5l80 0 0-32-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-32-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0c0-53-43-96-96-96s-96 43-96 96l0 54.3L38.8 5.1zm362.5 407l-43.1-33.9C346.1 382 333.3 384 320 384c-70.7 0-128-57.3-128-128l0-8.7L144.7 210c-.5 1.9-.7 3.9-.7 6l0 40c0 89.1 66.2 162.7 152 174.4l0 33.6-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-33.6c20.4-2.8 39.7-9.1 57.3-18.2z"]
}, faMicrophoneAltSlash = faMicrophoneLinesSlash, faClosedCaptioningSlash = {
  prefix: "fas",
  iconName: "closed-captioning-slash",
  icon: [640, 512, [], "e135", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-30-23.5c4.6-8.8 7.2-18.9 7.2-29.6l0-320c0-35.3-28.7-64-64-64L96 32c-6.7 0-13.1 1-19.2 2.9L38.8 5.1zm197.8 155c26.6 1.2 50.4 13.3 67 31.9c6.1 6.8 7.6 16.2 4.7 24.3l-71.6-56.2zm94 73.7c10-42.3 48-73.8 93.4-73.8c28.4 0 54 12.4 71.5 32c8.8 9.9 8 25-1.9 33.9s-25 8-33.9-1.9c-8.8-9.9-21.6-16-35.8-16c-26.5 0-48 21.5-48 48c0 5.4 .9 10.5 2.5 15.4l-47.9-37.6zm89.4 70c1.3 .1 2.7 .2 4.1 .2c14.2 0 27-6.1 35.8-16c8.8-9.9 24-10.7 33.9-1.9s10.7 24 1.9 33.9c-7.8 8.7-17.2 16-27.7 21.4l-47.9-37.6zM32 121.2L32 416c0 35.3 28.7 64 64 64l391.4 0L295 328.4c-16.8 14.7-38.9 23.6-63 23.6c-53 0-96-43-96-96c0-16 3.9-31.1 10.8-44.3L32 121.2zM232 304c8.7 0 16.9-2.3 23.9-6.4l-70-55.1c-1.3 4.3-1.9 8.8-1.9 13.5c0 26.5 21.5 48 48 48z"]
}, faCalculatorSimple = {
  prefix: "fas",
  iconName: "calculator-simple",
  icon: [512, 512, ["calculator-alt"], "f64c", "M0 48C0 21.5 21.5 0 48 0L176 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48L48 224c-26.5 0-48-21.5-48-48L0 48zm288 0c0-26.5 21.5-48 48-48L464 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-128zm48 240l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-128c0-26.5 21.5-48 48-48zM0 336c0-26.5 21.5-48 48-48l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 336zM416 64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-32zM64 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L64 96zM83.3 348.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L89.4 400 60.7 428.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L112 422.6l28.7 28.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L134.6 400l28.7-28.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L112 377.4 83.3 348.7zM352 352c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0z"]
}, faCalculatorAlt = faCalculatorSimple, faBridgeCircleCheck = {
  prefix: "fas",
  iconName: "bridge-circle-check",
  icon: [640, 512, [], "e4c9", "M64 32C46.3 32 32 46.3 32 64s14.3 32 32 32l40 0 0 64-72 0 0 128c53 0 96 43 96 96l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96c6.3 0 12.4 .6 18.3 1.7C367.1 231.8 426.9 192 496 192c42.5 0 81.6 15.1 112 40.2l0-72.2-72 0 0-64 40 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 32zM488 96l0 64-80 0 0-64 80 0zM360 96l0 64-80 0 0-64 80 0zM232 96l0 64-80 0 0-64 80 0zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-76.7-43.3c6.2 6.2 6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0z"]
}, faSlidersUp = {
  prefix: "fas",
  iconName: "sliders-up",
  icon: [512, 512, ["sliders-v"], "f3f1", "M96 0c17.7 0 32 14.3 32 32l0 54.7c28.3 12.3 48 40.5 48 73.3s-19.7 61-48 73.3L128 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-246.7C35.7 221 16 192.8 16 160s19.7-61 48-73.3L64 32C64 14.3 78.3 0 96 0zm0 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM256 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm80-32c0 32.8-19.7 61-48 73.3l0 54.7c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-54.7c-28.3-12.3-48-40.5-48-73.3s19.7-61 48-73.3L224 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 246.7c28.3 12.3 48 40.5 48 73.3zM448 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0 73.3L448 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-214.7c-28.3-12.3-48-40.5-48-73.3s19.7-61 48-73.3L384 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 86.7c28.3 12.3 48 40.5 48 73.3s-19.7 61-48 73.3z"]
}, faSlidersV = faSlidersUp, faLocationMinus = {
  prefix: "fas",
  iconName: "location-minus",
  icon: [384, 512, ["map-marker-minus"], "f609", "M215.7 499.2C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192c0 87.4 117 243 168.3 307.2c12.3 15.3 35.1 15.3 47.4 0zM120 168l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faMapMarkerMinus = faLocationMinus, faPumpMedical = {
  prefix: "fas",
  iconName: "pump-medical",
  icon: [448, 512, [], "e06a", "M128 32l0 96 128 0 0-32 60.1 0c4.2 0 8.3 1.7 11.3 4.7l33.9 33.9c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L372.7 55.4c-15-15-35.4-23.4-56.6-23.4L256 32c0-17.7-14.3-32-32-32L160 0c-17.7 0-32 14.3-32 32zM117.4 160c-33.3 0-61 25.5-63.8 58.7L35 442.7C31.9 480 61.3 512 98.8 512l186.4 0c37.4 0 66.9-32 63.8-69.3l-18.7-224c-2.8-33.2-30.5-58.7-63.8-58.7l-149.1 0zM216 280l0 32 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-32c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faFingerprint = {
  prefix: "fas",
  iconName: "fingerprint",
  icon: [512, 512, [], "f577", "M48 256C48 141.1 141.1 48 256 48c63.1 0 119.6 28.1 157.8 72.5c8.6 10.1 23.8 11.2 33.8 2.6s11.2-23.8 2.6-33.8C403.3 34.6 333.7 0 256 0C114.6 0 0 114.6 0 256l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40zm458.5-52.9c-2.7-13-15.5-21.3-28.4-18.5s-21.3 15.5-18.5 28.4c2.9 13.9 4.5 28.3 4.5 43.1l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40c0-18.1-1.9-35.8-5.5-52.9zM256 80c-19 0-37.4 3-54.5 8.6c-15.2 5-18.7 23.7-8.3 35.9c7.1 8.3 18.8 10.8 29.4 7.9c10.6-2.9 21.8-4.4 33.4-4.4c70.7 0 128 57.3 128 128l0 24.9c0 25.2-1.5 50.3-4.4 75.3c-1.7 14.6 9.4 27.8 24.2 27.8c11.8 0 21.9-8.6 23.3-20.3c3.3-27.4 5-55 5-82.7l0-24.9c0-97.2-78.8-176-176-176zM150.7 148.7c-9.1-10.6-25.3-11.4-33.9-.4C93.7 178 80 215.4 80 256l0 24.9c0 24.2-2.6 48.4-7.8 71.9C68.8 368.4 80.1 384 96.1 384c10.5 0 19.9-7 22.2-17.3c6.4-28.1 9.7-56.8 9.7-85.8l0-24.9c0-27.2 8.5-52.4 22.9-73.1c7.2-10.4 8-24.6-.2-34.2zM256 160c-53 0-96 43-96 96l0 24.9c0 35.9-4.6 71.5-13.8 106.1c-3.8 14.3 6.7 29 21.5 29c9.5 0 17.9-6.2 20.4-15.4c10.5-39 15.9-79.2 15.9-119.7l0-24.9c0-28.7 23.3-52 52-52s52 23.3 52 52l0 24.9c0 36.3-3.5 72.4-10.4 107.9c-2.7 13.9 7.7 27.2 21.8 27.2c10.2 0 19-7 21-17c7.7-38.8 11.6-78.3 11.6-118.1l0-24.9c0-53-43-96-96-96zm24 96c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24.9c0 59.9-11 119.3-32.5 175.2l-5.9 15.3c-4.8 12.4 1.4 26.3 13.8 31s26.3-1.4 31-13.8l5.9-15.3C267.9 411.9 280 346.7 280 280.9l0-24.9z"]
}, faSkiBoot = {
  prefix: "fas",
  iconName: "ski-boot",
  icon: [512, 512, [], "e3cc", "M383.4 38c3.3-17.4-8-34.1-25.4-37.5s-34.1 8-37.5 25.4l-1.2 6-73.7 0c-22.1 130.8-76 201.3-127.2 238.9c-26.2 19.3-51.2 29.5-69.9 35c-6.3 1.8-11.8 3.1-16.5 4L.6 474c-1.8 9.4 .7 19.1 6.8 26.4S22.5 512 32 512l416 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-72c0-12.3-7-23.4-18-28.8L340 288l-68 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l69.5 0 12.3-64L288 192c-8.8 0-16-7.2-16-16s7.2-16 16-16l72 0 17.3-90 6.2-32zM38.8 275.4c.3-.1 .6-.2 .9-.3c15.6-4.6 37.1-13.3 59.9-30c43-31.6 92.3-92.9 113.7-213.1L112 32C96.7 32 83.5 42.9 80.6 58L38.8 275.4z"]
}, faStandardDefinition = {
  prefix: "fas",
  iconName: "standard-definition",
  icon: [576, 512, ["rectangle-sd"], "e28a", "M0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm304 88l0 144c0 13.3 10.7 24 24 24l56 0c53 0 96-43 96-96s-43-96-96-96l-56 0c-13.3 0-24 10.7-24 24zm48 24l32 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-32 0 0-96zm-184.9 .1c7.4-2.4 19.5-2.9 36.2-.7l3-22.2-3 22.2c5.1 .7 21.1 3.4 25.7 4.4c12.1 2.8 24.1-4.8 26.8-16.9s-4.8-24.1-16.9-26.8c-6.5-1.5-23.9-4.4-29.7-5.1c-18.9-2.5-38.9-3.1-56 2.5c-18.8 6.1-33.9 19.7-38.5 42.3c-.1 .4-.1 .8-.2 1.2c-1.7 11.4-.2 22.4 5 32.3c5.1 9.6 12.9 16.1 20.5 20.7c13.7 8.2 31.5 12.3 45.1 15.5c0 0 0 0 0 0l1.7 .4c16 3.7 27.1 6.5 34.1 10.7c3 1.8 3.8 3 3.9 3.3c0 0 0 0 0 0c.1 .1 .7 1.2 .2 4.7c-.4 2.7-1.2 3.8-1.7 4.3c-.7 .7-2.3 2-5.8 3.1c-7.7 2.4-20.1 2.9-36.9 .6c-7.4-1-20.3-4.8-31.4-8c-2.5-.7-5-1.4-7.2-2.1c-11.9-3.4-24.3 3.5-27.7 15.4s3.5 24.3 15.4 27.7c1.5 .4 3.3 .9 5.3 1.5c0 0 0 0 0 0c10.8 3.2 28.4 8.3 39.4 9.9l.1 0c18.9 2.5 39.2 3.1 56.4-2.3c8.9-2.8 17.8-7.5 24.9-15.2c7.3-7.8 11.8-17.6 13.4-28.5c1.7-11.4 .2-22.4-5-32.3c-5.1-9.6-12.9-16.1-20.5-20.7c-13.7-8.2-31.5-12.3-45.1-15.5c0 0 0 0 0 0l-1.7-.4c-16-3.7-27.1-6.5-34.1-10.7c-3-1.8-3.8-3-3.9-3.3c0 0 0 0 0 0c-.1-.1-.6-1.1-.3-4.1c.9-4 2.8-6.2 8.3-8z"]
}, faRectangleSd = faStandardDefinition, faH1 = {
  prefix: "fas",
  iconName: "h1",
  icon: [576, 512, [], "f313", "M64 96c0-17.7-14.3-32-32-32S0 78.3 0 96L0 256 0 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 192 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128L64 224 64 96zm448 0c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4l-64 32c-15.8 7.9-22.2 27.1-14.3 42.9s27.1 22.2 42.9 14.3l17.7-8.8L448 384l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-288z"]
}, faHandPointRight = {
  prefix: "fas",
  iconName: "hand-point-right",
  icon: [512, 512, [], "f0a4", "M480 96c17.7 0 32 14.3 32 32s-14.3 32-32 32l-208 0 0-64 208 0zM320 288c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0zm64-64c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l48 0c17.7 0 32 14.3 32 32zM288 384c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0zm-88-96l.6 0c-5.4 9.4-8.6 20.3-8.6 32c0 13.2 4 25.4 10.8 35.6C177.9 364.3 160 388.1 160 416c0 11.7 3.1 22.6 8.6 32l-8.6 0C71.6 448 0 376.4 0 288l0-61.7c0-42.4 16.9-83.1 46.9-113.1l11.6-11.6C82.5 77.5 115.1 64 149 64l27 0c35.3 0 64 28.7 64 64l0 88c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-56c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 56c0 39.8 32.2 72 72 72z"]
}, faMagnifyingGlassLocation = {
  prefix: "fas",
  iconName: "magnifying-glass-location",
  icon: [512, 512, ["search-location"], "f689", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM288 176c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 48.8 46.5 111.6 68.6 138.6c6 7.3 16.8 7.3 22.7 0c22.1-27 68.6-89.8 68.6-138.6zm-112 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faSearchLocation = faMagnifyingGlassLocation, faMessageBot = {
  prefix: "fas",
  iconName: "message-bot",
  icon: [640, 512, [], "e3b8", "M160 0C124.7 0 96 28.7 96 64l0 112-36.3 0c-5.5-9.6-15.9-16-27.7-16c-17.7 0-32 14.3-32 32s14.3 32 32 32c11.8 0 22.2-6.4 27.7-16L96 208l0 144c0 35.3 28.7 64 64 64l64 0 0 80c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L373.3 416 480 416c35.3 0 64-28.7 64-64l0-144 36.3 0c5.5 9.6 15.9 16 27.7 16c17.7 0 32-14.3 32-32s-14.3-32-32-32c-11.8 0-22.2 6.4-27.7 16L544 176l0-112c0-35.3-28.7-64-64-64L160 0zm0 128c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-128zm64 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faForwardStep = {
  prefix: "fas",
  iconName: "forward-step",
  icon: [320, 512, ["step-forward"], "f051", "M52.5 440.6c-9.5 7.9-22.8 9.7-34.1 4.4S0 428.4 0 416L0 96C0 83.6 7.2 72.3 18.4 67s24.5-3.6 34.1 4.4l192 160L256 241l0-145c0-17.7 14.3-32 32-32s32 14.3 32 32l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-145-11.5 9.6-192 160z"]
}, faStepForward = faForwardStep, faFaceSmileBeam = {
  prefix: "fas",
  iconName: "face-smile-beam",
  icon: [512, 512, [128522, "smile-beam"], "f5b8", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM164.1 325.5C182 346.2 212.6 368 256 368s74-21.8 91.9-42.5c5.8-6.7 15.9-7.4 22.6-1.6s7.4 15.9 1.6 22.6C349.8 372.1 311.1 400 256 400s-93.8-27.9-116.1-53.5c-5.8-6.7-5.1-16.8 1.6-22.6s16.8-5.1 22.6 1.6zm53.5-96.7s0 0 0 0c0 0 0 0 0 0l-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8c0 0 0 0 0 0s0 0 0 0zm160 0c0 0 0 0 0 0l-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8c0 0 0 0 0 0s0 0 0 0s0 0 0 0z"]
}, faSmileBeam = faFaceSmileBeam, faLightCeiling = {
  prefix: "fas",
  iconName: "light-ceiling",
  icon: [512, 512, [], "e016", "M256 0c17.7 0 32 14.3 32 32l0 130c115.8 14.4 207.6 106.3 222 222.1c2.2 17.5-12.4 31.9-30 31.9L32 416C14.3 416-.2 401.6 2 384.1C16.4 268.2 108.2 176.4 224 162l0-130c0-17.7 14.3-32 32-32zm0 512c-35.3 0-64-28.7-64-64l128 0c0 35.3-28.7 64-64 64z"]
}, faMessageExclamation = {
  prefix: "fas",
  iconName: "message-exclamation",
  icon: [512, 512, ["comment-alt-exclamation"], "f4a5", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM256 80c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faCommentAltExclamation = faMessageExclamation, faBowlScoop = {
  prefix: "fas",
  iconName: "bowl-scoop",
  icon: [448, 512, [127847, "bowl-shaved-ice"], "e3de", "M32 224l384 0c0-106-86-192-192-192S32 118 32 224zM16 256c-4.6 0-9 2-12 5.4s-4.5 8-3.9 12.6l2 15.9C11.1 361.9 72.4 416 145 416l40.4 0-68.7 68.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9l192 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4L262.6 416l40.4 0c72.6 0 133.9-54.1 142.9-126.1l2-15.9c.6-4.6-.8-9.1-3.9-12.6s-7.4-5.4-12-5.4L16 256z"]
}, faBowlShavedIce = faBowlScoop, faSquareX = {
  prefix: "fas",
  iconName: "square-x",
  icon: [448, 512, [], "e286", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm90.3 104.5L224 218.8l69.7-82.3c8.6-10.1 23.7-11.4 33.8-2.8s11.4 23.7 2.8 33.8L255.4 256l74.9 88.5c8.6 10.1 7.3 25.3-2.8 33.8s-25.3 7.3-33.8-2.8L224 293.2l-69.7 82.3c-8.6 10.1-23.7 11.4-33.8 2.8s-11.4-23.7-2.8-33.8L192.6 256l-74.9-88.5c-8.6-10.1-7.3-25.3 2.8-33.8s25.3-7.3 33.8 2.8z"]
}, faBuildingMemo = {
  prefix: "fas",
  iconName: "building-memo",
  icon: [640, 512, [], "e61e", "M48 0C21.5 0 0 21.5 0 48L0 464c0 26.5 21.5 48 48 48l96 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 68.1 0c-12.6-15.2-20.1-34.7-20.1-56l0-168-16 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l16 0 0-64-16 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c1.3 0 2.5 .2 3.8 .4C323.9 76.6 348.5 64 376 64l8 0 0-16c0-26.5-21.5-48-48-48L48 0zM64 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm112-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM80 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM384 96c-35.3 0-64 28.7-64 64l0 288c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L384 96zm16 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM376 304a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm64-168c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm16 80l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM464 400c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16z"]
}, faUtilityPoleDouble = {
  prefix: "fas",
  iconName: "utility-pole-double",
  icon: [512, 512, [], "e2c4", "M256 0c17.7 0 32 14.3 32 32l0 32 96 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40c0 17.7-14.3 32-32 32l-51.2 0L288 221.9l0 34.1 96 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40c0 17.7-14.3 32-32 32l-51.2 0L288 413.9l0 66.1c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-66.1L83.2 320 32 320c-17.7 0-32-14.3-32-32l0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 96 0 0-34.1L83.2 128 32 128C14.3 128 0 113.7 0 96L0 56C0 42.7 10.7 32 24 32s24 10.7 24 24l0 8 32 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 96 0 0-32c0-17.7 14.3-32 32-32zM140.8 128L224 183.4l0-55.4-83.2 0zM288 183.4L371.2 128 288 128l0 55.4zM140.8 320L224 375.4l0-55.4-83.2 0zM288 375.4L371.2 320 288 320l0 55.4z"]
}, faFlagCheckered = {
  prefix: "fas",
  iconName: "flag-checkered",
  icon: [448, 512, [127937], "f11e", "M32 0C49.7 0 64 14.3 64 32l0 16 69-17.2c38.1-9.5 78.3-5.1 113.5 12.5c46.3 23.2 100.8 23.2 147.1 0l9.6-4.8C423.8 28.1 448 43.1 448 66.1l0 279.7c0 13.3-8.3 25.3-20.8 30l-34.7 13c-46.2 17.3-97.6 14.6-141.7-7.4c-37.9-19-81.3-23.7-122.5-13.4L64 384l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-80 0-66L0 64 0 32C0 14.3 14.3 0 32 0zM64 187.1l64-13.9 0 65.5L64 252.6 64 318l48.8-12.2c5.1-1.3 10.1-2.4 15.2-3.3l0-63.9 38.9-8.4c8.3-1.8 16.7-2.5 25.1-2.1l0-64c13.6 .4 27.2 2.6 40.4 6.4l23.6 6.9 0 66.7-41.7-12.3c-7.3-2.1-14.8-3.4-22.3-3.8l0 71.4c21.8 1.9 43.3 6.7 64 14.4l0-69.8 22.7 6.7c13.5 4 27.3 6.4 41.3 7.4l0-64.2c-7.8-.8-15.6-2.3-23.2-4.5l-40.8-12 0-62c-13-3.8-25.8-8.8-38.2-15c-8.2-4.1-16.9-7-25.8-8.8l0 72.4c-13-.4-26 .8-38.7 3.6L128 173.2 128 98 64 114l0 73.1zM320 335.7c16.8 1.5 33.9-.7 50-6.8l14-5.2 0-71.7-7.9 1.8c-18.4 4.3-37.3 5.7-56.1 4.5l0 77.4zm64-149.4l0-70.8c-20.9 6.1-42.4 9.1-64 9.1l0 69.4c13.9 1.4 28 .5 41.7-2.6l22.3-5.2z"]
}, faChevronsUp = {
  prefix: "fas",
  iconName: "chevrons-up",
  icon: [512, 512, ["chevron-double-up"], "f325", "M278.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-192 192c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L256 109.3 425.4 278.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-192-192zm192 384l-192-192c-12.5-12.5-32.8-12.5-45.3 0l-192 192c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L256 301.3 425.4 470.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3z"]
}, faChevronDoubleUp = faChevronsUp, faFootball = {
  prefix: "fas",
  iconName: "football",
  icon: [512, 512, [127944, "football-ball"], "f44e", "M247.5 25.4c-13.5 3.3-26.4 7.2-38.6 11.7C142.9 61.6 96.7 103.6 66 153.6C47.8 183.4 35.1 215.9 26.9 249L264.5 486.6c13.5-3.3 26.4-7.2 38.6-11.7c66-24.5 112.2-66.5 142.9-116.5c18.3-29.8 30.9-62.3 39.1-95.3L247.5 25.4zM495.2 205.3c6.1-56.8 1.4-112.2-7.7-156.4c-2.7-12.9-13-22.9-26.1-25.1c-58.2-9.7-109.9-12-155.6-7.9L495.2 205.3zM206.1 496L16.8 306.7c-6.1 56.8-1.4 112.2 7.7 156.4c2.7 12.9 13 22.9 26.1 25.1c58.2 9.7 109.9 12 155.6 7.9zm54.6-331.3c6.2-6.2 16.4-6.2 22.6 0l64 64c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6zm-48 48c6.2-6.2 16.4-6.2 22.6 0l64 64c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6zm-48 48c6.2-6.2 16.4-6.2 22.6 0l64 64c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6z"]
}, faFootballBall = faFootball, faUserVneck = {
  prefix: "fas",
  iconName: "user-vneck",
  icon: [448, 512, [], "e461", "M224 0a128 128 0 1 0 0 256A128 128 0 1 0 224 0zM145.9 314.9c-3.5-5.2-9.8-8-15.9-6.6C55.5 325.5 0 392.3 0 472l0 8c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-8c0-79.7-55.5-146.5-130-163.7c-6.1-1.4-12.4 1.4-15.9 6.6L237.3 412c-6.3 9.5-20.3 9.5-26.6 0l-64.8-97.1z"]
}, faSchoolCircleExclamation = {
  prefix: "fas",
  iconName: "school-circle-exclamation",
  icon: [640, 512, [], "e56c", "M337.8 5.4C327-1.8 313-1.8 302.2 5.4L166.3 96 48 96C21.5 96 0 117.5 0 144L0 464c0 26.5 21.5 48 48 48l272 0s0 0 0 0l-64 0 0-96c0-35.3 28.7-64 64-64l.3 0 .5 0c3.4-37.7 18.7-72.1 42.2-99.1C350.2 260 335.6 264 320 264c-48.6 0-88-39.4-88-88s39.4-88 88-88s88 39.4 88 88c0 18.3-5.6 35.3-15.1 49.4c29-21 64.6-33.4 103.1-33.4c59.5 0 112.1 29.6 144 74.8L640 144c0-26.5-21.5-48-48-48L473.7 96 337.8 5.4zM96 192l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zm0 128l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zM320 128c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0-144c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]
}, faCrop = {
  prefix: "fas",
  iconName: "crop",
  icon: [512, 512, [], "f125", "M448 109.3l54.6-54.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L402.7 64 160 64l0 64 178.7 0L128 338.7 128 32c0-17.7-14.3-32-32-32S64 14.3 64 32l0 32L32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l32 0 0 256c0 35.3 28.7 64 64 64l224 0 0-64-178.7 0L384 173.3 384 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-274.7z"]
}, faAnglesDown = {
  prefix: "fas",
  iconName: "angles-down",
  icon: [448, 512, ["angle-double-down"], "f103", "M246.6 470.6c-12.5 12.5-32.8 12.5-45.3 0l-160-160c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L224 402.7 361.4 265.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-160 160zm160-352l-160 160c-12.5 12.5-32.8 12.5-45.3 0l-160-160c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L224 210.7 361.4 73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3z"]
}, faAngleDoubleDown = faAnglesDown, faUsersRectangle = {
  prefix: "fas",
  iconName: "users-rectangle",
  icon: [640, 512, [], "e594", "M96 0C43 0 0 43 0 96L0 416c0 53 43 96 96 96l448 0c53 0 96-43 96-96l0-320c0-53-43-96-96-96L96 0zM64 96c0-17.7 14.3-32 32-32l448 0c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32L64 96zm159.8 80a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM96 309.3c0 14.7 11.9 26.7 26.7 26.7l56.1 0c8-34.1 32.8-61.7 65.2-73.6c-7.5-4.1-16.2-6.4-25.3-6.4l-69.3 0C119.9 256 96 279.9 96 309.3zM461.2 336l56.1 0c14.7 0 26.7-11.9 26.7-26.7c0-29.5-23.9-53.3-53.3-53.3l-69.3 0c-9.2 0-17.8 2.3-25.3 6.4c32.4 11.9 57.2 39.5 65.2 73.6zM372 289c-3.9-.7-7.9-1-12-1l-80 0c-4.1 0-8.1 .3-12 1c-26 4.4-47.3 22.7-55.9 47c-2.7 7.5-4.1 15.6-4.1 24c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24c0-8.4-1.4-16.5-4.1-24c-8.6-24.3-29.9-42.6-55.9-47zM512 176a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM320 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]
}, faPeopleRoof = {
  prefix: "fas",
  iconName: "people-roof",
  icon: [640, 512, [], "e537", "M335.5 4l288 160c15.4 8.6 21 28.1 12.4 43.5s-28.1 21-43.5 12.4L320 68.6 47.5 220c-15.4 8.6-34.9 3-43.5-12.4s-3-34.9 12.4-43.5L304.5 4c9.7-5.4 21.4-5.4 31.1 0zM320 160a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM144 256a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm312 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM226.9 491.4L200 441.5l0 38.5c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-38.5L61.1 491.4c-6.3 11.7-20.8 16-32.5 9.8s-16-20.8-9.8-32.5l37.9-70.3c15.3-28.5 45.1-46.3 77.5-46.3l19.5 0c16.3 0 31.9 4.5 45.4 12.6l33.6-62.3c15.3-28.5 45.1-46.3 77.5-46.3l19.5 0c32.4 0 62.1 17.8 77.5 46.3l33.6 62.3c13.5-8.1 29.1-12.6 45.4-12.6l19.5 0c32.4 0 62.1 17.8 77.5 46.3l37.9 70.3c6.3 11.7 1.9 26.2-9.8 32.5s-26.2 1.9-32.5-9.8L552 441.5l0 38.5c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-38.5-26.9 49.9c-6.3 11.7-20.8 16-32.5 9.8s-16-20.8-9.8-32.5l36.3-67.5c-1.7-1.7-3.2-3.6-4.3-5.8L376 345.5l0 54.5c0 17.7-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32l0-54.5-26.9 49.9c-1.2 2.2-2.6 4.1-4.3 5.8l36.3 67.5c6.3 11.7 1.9 26.2-9.8 32.5s-26.2 1.9-32.5-9.8z"]
}, faSquareArrowRight = {
  prefix: "fas",
  iconName: "square-arrow-right",
  icon: [448, 512, ["arrow-square-right"], "f33b", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM377 273L265 385c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l71-71L88 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l214.1 0-71-71c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L377 239c9.4 9.4 9.4 24.6 0 33.9z"]
}, faArrowSquareRight = faSquareArrowRight, faLocationPlus = {
  prefix: "fas",
  iconName: "location-plus",
  icon: [384, 512, ["map-marker-plus"], "f60a", "M215.7 499.2C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192c0 87.4 117 243 168.3 307.2c12.3 15.3 35.1 15.3 47.4 0zM168 280l0-64-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]
}, faMapMarkerPlus = faLocationPlus, faLightbulbExclamationOn = {
  prefix: "fas",
  iconName: "lightbulb-exclamation-on",
  icon: [640, 512, [], "e1ca", "M69.3 4l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3S58.3-3.3 69.3 4zM597.3 44l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zM24 160l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm528 0l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM117.3 332l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zm432-39.9l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3s22.3-14 33.3-6.7zm-100.1 5.7c-19.8 27.1-39.7 54.4-49.2 86.2l-160 0c-9.6-31.9-29.5-59.1-49.2-86.2c0 0 0 0 0 0s0 0 0 0c-5.2-7.1-10.4-14.2-15.4-21.4C155.6 247.9 144 213.3 144 176C144 78.8 222.8 0 320 0s176 78.8 176 176c0 37.3-11.6 71.9-31.4 100.3c-5 7.2-10.2 14.3-15.4 21.4c0 0 0 0 0 0s0 0 0 0zM400 432c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-16 160 0 0 16zM344 88c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM320 320a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faPeopleLine = {
  prefix: "fas",
  iconName: "people-line",
  icon: [640, 512, [], "e534", "M360 72a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM144 208a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l576 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 416zM496 208a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM200 313.5l26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-36.3-67.5c1.7-1.7 3.2-3.6 4.3-5.8L264 217.5l0 54.5c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-54.5 26.9 49.9c1.2 2.2 2.6 4.1 4.3 5.8l-36.3 67.5c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L440 313.5l0 38.5c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-38.5 26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-37.9-70.3c-15.3-28.5-45.1-46.3-77.5-46.3l-19.5 0c-16.3 0-31.9 4.5-45.4 12.6l-33.6-62.3c-15.3-28.5-45.1-46.3-77.5-46.3l-19.5 0c-32.4 0-62.1 17.8-77.5 46.3l-33.6 62.3c-13.5-8.1-29.1-12.6-45.4-12.6l-19.5 0c-32.4 0-62.1 17.8-77.5 46.3L18.9 340.6c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L88 313.5 88 352c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-38.5z"]
}, faBeerMugEmpty = {
  prefix: "fas",
  iconName: "beer-mug-empty",
  icon: [512, 512, ["beer"], "f0fc", "M32 64c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32l0 32 51.2 0c42.4 0 76.8 34.4 76.8 76.8l0 102.1c0 30.4-17.9 57.9-45.6 70.2L384 381.7l0 34.3c0 35.3-28.7 64-64 64L96 480c-35.3 0-64-28.7-64-64L32 64zM384 311.6l56.4-25.1c4.6-2.1 7.6-6.6 7.6-11.7l0-102.1c0-7.1-5.7-12.8-12.8-12.8L384 160l0 151.6zM160 144c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224z"]
}, faBeer = faBeerMugEmpty, faCarpool = {
  prefix: "fas",
  iconName: "carpool",
  icon: [512, 512, ["car-people"], "e69c", "M104.6 122.9L80.4 224l36.4 0c7.3-14.2 22.1-24 39.2-24l40 0c17.1 0 31.9 9.8 39.2 24l41.6 0c7.3-14.2 22.1-24 39.2-24l40 0c17.1 0 31.9 9.8 39.2 24l36.4 0L407.4 122.9c-6-25.2-28.6-42.9-54.5-42.9L159.1 80c-25.9 0-48.4 17.8-54.5 42.9zM28.4 234.8L57.9 111.7C69.2 65 111 32 159.1 32l193.9 0c48.1 0 89.9 33 101.1 79.7l29.5 123.1c17.1 11.5 28.4 31 28.4 53.2l0 112 0 16 0 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-32L96 416l0 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-32 0-16L0 288c0-22.2 11.3-41.7 28.4-53.2zM176 104a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM96 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM296 144a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"]
}, faCarPeople = faCarpool, faCrateEmpty = {
  prefix: "fas",
  iconName: "crate-empty",
  icon: [512, 512, [], "e151", "M48 224c-26.5 0-48 21.5-48 48l0 80 512 0 0-80c0-26.5-21.5-48-48-48L48 224zM512 384L0 384l0 80c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-80zM64 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM48 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM448 272a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM432 448a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]
}, faDiagramPredecessor = {
  prefix: "fas",
  iconName: "diagram-predecessor",
  icon: [512, 512, [], "e477", "M448 416l0-64L64 352l0 64 384 0zm0 64L64 480c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64zM288 160c0 35.3-28.7 64-64 64L64 224c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l144 0 16 0 144 0c44.2 0 80 35.8 80 80l0 16 38.1 0c21.4 0 32.1 25.9 17 41L433 239c-9.4 9.4-24.6 9.4-33.9 0L329 169c-15.1-15.1-4.4-41 17-41l38.1 0 0-16c0-8.8-7.2-16-16-16l-80 0 0 64z"]
}, faTransporter = {
  prefix: "fas",
  iconName: "transporter",
  icon: [512, 512, [], "e042", "M208 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 272l0 96-64 0 0-178.7L153 276c-11.1 13.8-31.2 16-45 5s-16-31.2-5-45l57.7-72c18.2-22.7 45.8-36 74.9-36l40.7 0c29.1 0 56.7 13.2 74.9 36L409 236c11 13.8 8.8 33.9-5 45s-33.9 8.8-45-5l-31-38.7L328 416l-64 0 0-96-16 0zM216 512l-88 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-88 0-80 0zM64 96l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L64 128l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L32 128 6.6 120.7C2.7 119.6 0 116.1 0 112s2.7-7.6 6.6-8.7L32 96l7.3-25.4C40.4 66.7 43.9 64 48 64s7.6 2.7 8.7 6.6L64 96zM472.7 6.6L480 32l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L480 64l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L448 64l-25.4-7.3c-3.9-1.1-6.6-4.7-6.6-8.7s2.7-7.6 6.6-8.7L448 32l7.3-25.4C456.4 2.7 459.9 0 464 0s7.6 2.7 8.7 6.6z"]
}, faCalendarCircleUser = {
  prefix: "fas",
  iconName: "calendar-circle-user",
  icon: [576, 512, [], "e471", "M128 0C110.3 0 96 14.3 96 32l0 32L48 64C21.5 64 0 85.5 0 112l0 48 448 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32zM256 368c0-91.8 70.3-167.2 160-175.3l0-.7L0 192 0 464c0 26.5 21.5 48 48 48l282.8 0C285.6 480.1 256 427.5 256 368zm320 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-66.3 80.7C489.5 468.1 462.2 480 432 480s-57.5-11.9-77.7-31.3c6.2-19 24-32.7 45.1-32.7l65.2 0c21 0 38.9 13.7 45.1 32.7zM384 336a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"]
}, faArrowUpLong = {
  prefix: "fas",
  iconName: "arrow-up-long",
  icon: [384, 512, ["long-arrow-up"], "f176", "M214.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 109.3 160 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-370.7 73.4 73.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-128-128z"]
}, faLongArrowUp = faArrowUpLong, faPersonCarryBox = {
  prefix: "fas",
  iconName: "person-carry-box",
  icon: [384, 512, ["person-carry"], "f4cf", "M80 96A48 48 0 1 0 80 0a48 48 0 1 0 0 96zM96 306.7l0-65.1 16.6 24.9c8.9 13.4 23.9 21.4 39.9 21.4l71.4 0 128 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L224 96c-17.7 0-32 14.3-32 32l0 96-30.9 0-42.6-64c-13.3-20-35.8-32-59.9-32C26.2 128 0 154.2 0 186.6l0 88.1c0 17 6.7 33.3 18.7 45.3l79.4 79.4 14.3 85.9c2.9 17.4 19.4 29.2 36.8 26.3s29.2-19.4 26.3-36.8l-15.2-90.9c-1.6-9.9-6.3-19-13.4-26.1l-51-51zM0 346.5L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32c0 0 0 0 0 0l0-69.5-64-64z"]
}, faPersonCarry = faPersonCarryBox, faFireFlameSimple = {
  prefix: "fas",
  iconName: "fire-flame-simple",
  icon: [384, 512, ["burn"], "f46a", "M372.5 256.5l-.7-1.9C337.8 160.8 282 76.5 209.1 8.5l-3.3-3C202.1 2 197.1 0 192 0s-10.1 2-13.8 5.5l-3.3 3C102 76.5 46.2 160.8 12.2 254.6l-.7 1.9C3.9 277.3 0 299.4 0 321.6C0 426.7 86.8 512 192 512s192-85.3 192-190.4c0-22.2-3.9-44.2-11.5-65.1zm-90.8 49.5c4.1 9.3 6.2 19.4 6.2 29.5c0 53-43 96.5-96 96.5s-96-43.5-96-96.5c0-10.1 2.1-20.3 6.2-29.5l1.9-4.3c15.8-35.4 37.9-67.7 65.3-95.1l8.9-8.9c3.6-3.6 8.5-5.6 13.6-5.6s10 2 13.6 5.6l8.9 8.9c27.4 27.4 49.6 59.7 65.3 95.1l1.9 4.3z"]
}, faBurn = faFireFlameSimple, faPerson = {
  prefix: "fas",
  iconName: "person",
  icon: [320, 512, [129485, "male"], "f183", "M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 304l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-223.1L59.4 304.5c-9.1 15.1-28.8 20-43.9 10.9s-20-28.8-10.9-43.9l58.3-97c17.4-28.9 48.6-46.6 82.3-46.6l29.7 0c33.7 0 64.9 17.7 82.3 46.6l58.3 97c9.1 15.1 4.2 34.8-10.9 43.9s-34.8 4.2-43.9-10.9L232 256.9 232 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-16 0z"]
}, faMale = faPerson, faLaptop = {
  prefix: "fas",
  iconName: "laptop",
  icon: [640, 512, [128187], "f109", "M128 32C92.7 32 64 60.7 64 96l0 256 64 0 0-256 384 0 0 256 64 0 0-256c0-35.3-28.7-64-64-64L128 32zM19.2 384C8.6 384 0 392.6 0 403.2C0 445.6 34.4 480 76.8 480l486.4 0c42.4 0 76.8-34.4 76.8-76.8c0-10.6-8.6-19.2-19.2-19.2L19.2 384z"]
}, faFileCsv = {
  prefix: "fas",
  iconName: "file-csv",
  icon: [512, 512, [], "f6dd", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-208 0c-35.3 0-64 28.7-64 64l0 144-48 0c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zM200 352l16 0c22.1 0 40 17.9 40 40l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-4.4-3.6-8-8-8l-16 0c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-8c0-8.8 7.2-16 16-16s16 7.2 16 16l0 8c0 22.1-17.9 40-40 40l-16 0c-22.1 0-40-17.9-40-40l0-80c0-22.1 17.9-40 40-40zm133.1 0l34.9 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-34.9 0c-7.2 0-13.1 5.9-13.1 13.1c0 5.2 3 9.9 7.8 12l37.4 16.6c16.3 7.2 26.8 23.4 26.8 41.2c0 24.9-20.2 45.1-45.1 45.1L304 512c-8.8 0-16-7.2-16-16s7.2-16 16-16l42.9 0c7.2 0 13.1-5.9 13.1-13.1c0-5.2-3-9.9-7.8-12l-37.4-16.6c-16.3-7.2-26.8-23.4-26.8-41.2c0-24.9 20.2-45.1 45.1-45.1zm98.9 0c8.8 0 16 7.2 16 16l0 31.6c0 23 5.5 45.6 16 66c10.5-20.3 16-42.9 16-66l0-31.6c0-8.8 7.2-16 16-16s16 7.2 16 16l0 31.6c0 34.7-10.3 68.7-29.6 97.6l-5.1 7.7c-3 4.5-8 7.1-13.3 7.1s-10.3-2.7-13.3-7.1l-5.1-7.7c-19.3-28.9-29.6-62.9-29.6-97.6l0-31.6c0-8.8 7.2-16 16-16z"]
}, faMenorah = {
  prefix: "fas",
  iconName: "menorah",
  icon: [640, 512, [], "f676", "M20.8 7.4C22.8 2.9 27.1 0 32 0s9.2 2.9 11.2 7.4L61.3 49.7c1.8 4.1 2.7 8.6 2.7 13.1L64 64c0 17.7-14.3 32-32 32S0 81.7 0 64l0-1.2c0-4.5 .9-8.9 2.7-13.1L20.8 7.4zm96 0C118.8 2.9 123.1 0 128 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1L116.8 7.4zm77.8 42.4L212.8 7.4C214.8 2.9 219.1 0 224 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1zM308.8 7.4C310.8 2.9 315.1 0 320 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1L308.8 7.4zm77.8 42.4L404.8 7.4C406.8 2.9 411.1 0 416 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1zM500.8 7.4C502.8 2.9 507.1 0 512 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1L500.8 7.4zm77.8 42.4L596.8 7.4C598.8 2.9 603.1 0 608 0s9.2 2.9 11.2 7.4l18.2 42.4c1.8 4.1 2.7 8.6 2.7 13.1l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-4.5 .9-8.9 2.7-13.1zM32 128c17.7 0 32 14.3 32 32l0 128c0 17.7 14.3 32 32 32l192 0 0-160c0-17.7 14.3-32 32-32s32 14.3 32 32l0 160 192 0c17.7 0 32-14.3 32-32l0-128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 128c0 53-43 96-96 96l-192 0 0 64 128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0-160 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l128 0 0-64L96 384c-53 0-96-43-96-96L0 160c0-17.7 14.3-32 32-32zm96 0c17.7 0 32 14.3 32 32l0 96 0 32-64 0 0-32 0-96c0-17.7 14.3-32 32-32zm96 0c17.7 0 32 14.3 32 32l0 96 0 32-64 0 0-32 0-96c0-17.7 14.3-32 32-32zm192 0c17.7 0 32 14.3 32 32l0 96 0 32-64 0 0-32 0-96c0-17.7 14.3-32 32-32zm96 0c17.7 0 32 14.3 32 32l0 96 0 32-64 0 0-32 0-96c0-17.7 14.3-32 32-32z"]
}, faUnion = {
  prefix: "fas",
  iconName: "union",
  icon: [384, 512, [8899], "f6a2", "M32 32c17.7 0 32 14.3 32 32l0 224c0 70.7 57.3 128 128 128s128-57.3 128-128l0-224c0-17.7 14.3-32 32-32s32 14.3 32 32l0 224c0 106-86 192-192 192S0 394 0 288L0 64C0 46.3 14.3 32 32 32z"]
}, faChevronsLeft = {
  prefix: "fas",
  iconName: "chevrons-left",
  icon: [512, 512, ["chevron-double-left"], "f323", "M41.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l192 192c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 256 278.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-192 192zm384-192l-192 192c-12.5 12.5-12.5 32.8 0 45.3l192 192c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L301.3 256 470.6 86.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0z"]
}, faChevronDoubleLeft = faChevronsLeft, faCircleHeart = {
  prefix: "fas",
  iconName: "circle-heart",
  icon: [512, 512, ["heart-circle"], "f4c7", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM131.9 280.9c-29.4-29.8-29.4-78.2 0-108s77-29.8 106.4 0l17.7 18 17.7-18c29.4-29.8 77-29.8 106.4 0s29.4 78.2 0 108L278.5 384.1c-6.2 6.3-14.3 9.4-22.5 9.4s-16.3-3.1-22.5-9.4L131.9 280.9z"]
}, faHeartCircle = faCircleHeart, faTruckPlane = {
  prefix: "fas",
  iconName: "truck-plane",
  icon: [640, 512, [], "e58f", "M200 0c-30.6 0-56 54.7-56 86.1l0 106.5L7.8 274.3C2.9 277.2 0 282.4 0 288l0 64c0 5.1 2.4 9.8 6.4 12.8s9.3 3.9 14.1 2.5l123.4-37 0 81.2-50 40c-3.8 3-6 7.6-6 12.5l0 32c0 5.1 2.5 10 6.6 13s9.5 3.8 14.4 2.2L200 480.9 290.4 511c-1.6-4.7-2.4-9.8-2.4-15l0-32.6c-18.2-10.5-30.7-29.7-31.9-51.8l-.1-.1 0-3.5 0-82.5L256 184l0-1.1s0 0 0 0l0-96.9C256 54.7 231.5 0 200 0zm88 176l0 224c0 20.9 13.4 38.7 32 45.3l0 42.7c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-40 160 0 0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-42.7c18.6-6.6 32-24.4 32-45.3l0-224c0-26.5-21.5-48-48-48l-256 0c-26.5 0-48 21.5-48 48zm79.8 78.7c3.3-8.7 11.2-14.7 20.5-14.7l151.4 0c9.2 0 17.2 6 20.5 14.7L576 304l-224 0 15.8-49.3zM568 352a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM336 376a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faRecordVinyl = {
  prefix: "fas",
  iconName: "record-vinyl",
  icon: [512, 512, [], "f8d9", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256-96a96 96 0 1 1 0 192 96 96 0 1 1 0-192zm0 224a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faBringForward = {
  prefix: "fas",
  iconName: "bring-forward",
  icon: [512, 512, [], "f856", "M224 448l224 0 0-224-64 0 0-64 64 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64l0-64 64 0 0 64zm64-96L64 352c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L288 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64z"]
}, faSquareP = {
  prefix: "fas",
  iconName: "square-p",
  icon: [448, 512, [], "e279", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm88 96l92 0c50.8 0 92 41.2 92 92s-41.2 92-92 92l-68 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72 0-136c0-13.3 10.7-24 24-24zm92 136c24.3 0 44-19.7 44-44s-19.7-44-44-44l-68 0 0 88 68 0z"]
}, faFaceGrinStars = {
  prefix: "fas",
  iconName: "face-grin-stars",
  icon: [512, 512, [129321, "grin-stars"], "f587", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm407.4 75.5c5-11.8-7-22.5-19.3-18.7c-39.7 12.2-84.5 19-131.8 19s-92.1-6.8-131.8-19c-12.3-3.8-24.3 6.9-19.3 18.7c25 59.1 83.2 100.5 151.1 100.5s126.2-41.4 151.1-100.5zM160 120c-3.1 0-5.9 1.8-7.2 4.6l-16.6 34.7-38.1 5c-3.1 .4-5.6 2.5-6.6 5.5s-.1 6.2 2.1 8.3l27.9 26.5-7 37.8c-.6 3 .7 6.1 3.2 7.9s5.8 2 8.5 .6L160 232.5l33.8 18.3c2.7 1.5 6 1.3 8.5-.6s3.7-4.9 3.2-7.9l-7-37.8L226.4 178c2.2-2.1 3.1-5.3 2.1-8.3s-3.5-5.1-6.6-5.5l-38.1-5-16.6-34.7c-1.3-2.8-4.1-4.6-7.2-4.6zm192 0c-3.1 0-5.9 1.8-7.2 4.6l-16.6 34.7-38.1 5c-3.1 .4-5.6 2.5-6.6 5.5s-.1 6.2 2.1 8.3l27.9 26.5-7 37.8c-.6 3 .7 6.1 3.2 7.9s5.8 2 8.5 .6L352 232.5l33.8 18.3c2.7 1.5 6 1.3 8.5-.6s3.7-4.9 3.2-7.9l-7-37.8L418.4 178c2.2-2.1 3.1-5.3 2.1-8.3s-3.5-5.1-6.6-5.5l-38.1-5-16.6-34.7c-1.3-2.8-4.1-4.6-7.2-4.6z"]
}, faGrinStars = faFaceGrinStars, faSigma = {
  prefix: "fas",
  iconName: "sigma",
  icon: [384, 512, [8721], "f68b", "M2.4 51.8C7.4 39.8 19.1 32 32 32l288 0c35.3 0 64 28.7 64 64l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32L109.3 96 246.6 233.4c12.5 12.5 12.5 32.8 0 45.3L109.3 416 320 416l0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32c0 35.3-28.7 64-64 64L32 480c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L178.7 256 9.4 86.6C.2 77.5-2.5 63.7 2.4 51.8z"]
}, faCameraMovie = {
  prefix: "fas",
  iconName: "camera-movie",
  icon: [576, 512, [127909, 127910], "f8a9", "M128 64a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM352 256l-224 0C57.3 256 0 198.7 0 128S57.3 0 128 0c48.2 0 90.2 26.6 112 66C261.8 26.6 303.8 0 352 0c70.7 0 128 57.3 128 128s-57.3 128-128 128zm0-192a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM558.3 259.4c10.8 5.4 17.7 16.5 17.7 28.6l0 192c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48L448 448l0-16 0-96 0-16 12.8-9.6 64-48c9.7-7.3 22.7-8.4 33.5-3zM64 288l64 0 224 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64l0-96-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0z"]
}, faBong = {
  prefix: "fas",
  iconName: "bong",
  icon: [448, 512, [], "f55c", "M160 208.5c0 29.1-15.6 53.9-37.2 67.8c-17.2 11.1-31.5 26.1-41.7 43.7l221.8 0c-10.2-17.6-24.5-32.6-41.7-43.7c-21.6-13.9-37.2-38.7-37.2-67.8L224 64l-64 0 0 144.5zM288 64l0 144.5c0 5.7 3.1 10.9 7.9 14c11.2 7.2 21.5 15.5 30.9 24.8L366.1 208l-7-7c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l24 24 24 24c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-7-7-43.3 43.3C374 314.1 384 347.9 384 384c0 39.4-11.9 76.1-32.2 106.5c-9.6 14.4-26.5 21.5-43.8 21.5L76.1 512c-17.3 0-34.2-7.1-43.8-21.5C11.9 460.1 0 423.4 0 384c0-67.8 35.1-127.3 88.1-161.5c4.8-3.1 7.9-8.3 7.9-14L96 64C78.3 64 64 49.7 64 32S78.3 0 96 0l16 0L272 0l16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32z"]
}, faClarinet = {
  prefix: "fas",
  iconName: "clarinet",
  icon: [640, 512, [], "f8ad", "M224 144c0-8.8 7.2-16 16-16l32 0 96 0 96 0 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0 0 32 76.6 0c9.5 0 18.7-2.8 26.6-8.1l31.9-21.3c4.9-3.3 11.2-3.6 16.4-.8s8.5 8.2 8.5 14.1l0 192c0 5.9-3.2 11.3-8.5 14.1s-11.5 2.5-16.4-.8l-31.9-21.3c-7.9-5.3-17.1-8.1-26.6-8.1l-448.3 0c-10.2 0-20.3-1.9-29.7-5.7L10.1 318.9C4 316.4 0 310.5 0 304l0-64c0-6.5 4-12.4 10.1-14.9l68.6-27.4c9.4-3.8 19.5-5.7 29.7-5.7L256 192l0-32-16 0c-8.8 0-16-7.2-16-16zm224 16l-64 0 0 32 64 0 0-32zm-96 0l-64 0 0 32 64 0 0-32zM272 296a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faTruckFlatbed = {
  prefix: "fas",
  iconName: "truck-flatbed",
  icon: [640, 512, [], "e2b6", "M608 416l-32 0c0 53-43 96-96 96s-96-43-96-96l-32 0-96 0c0 53-43 96-96 96s-96-43-96-96l-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l56.4 0c17.6-19.6 43.1-32 71.6-32s54 12.4 71.6 32L352 352l0-224c0-17.7 14.3-32 32-32l16 0 16 0 50.7 0c17 0 33.3 6.7 45.3 18.7L589.3 192c12 12 18.7 28.3 18.7 45.3l0 18.7 0 32 0 64c17.7 0 32 14.3 32 32s-14.3 32-32 32zM416 160l0 96 128 0 0-18.7L466.7 160 416 160zM208 416a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm272 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]
}, faSpaghettiMonsterFlying = {
  prefix: "fas",
  iconName: "spaghetti-monster-flying",
  icon: [640, 512, ["pastafarianism"], "f67b", "M208 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 0c0 16.2-6 31.1-16 42.3l15.6 31.2c18.7-6 39.9-9.5 64.4-9.5s45.8 3.5 64.4 9.5L400 106.3C390 95.1 384 80.2 384 64c0-35.3 28.7-64 64-64s64 28.7 64 64s-28.7 64-64 64c-1.7 0-3.4-.1-5.1-.2L427.8 158c21.1 13.6 37.7 30.2 51.4 46.4c7.1 8.3 13.5 16.6 19.3 24l1.4 1.8c6.3 8.1 11.6 14.8 16.7 20.4C527.3 262.3 532.7 264 536 264c2.5 0 4.3-.6 7.1-3.3c3.7-3.5 7.1-8.8 12.5-17.4l.6-.9c4.6-7.4 11-17.6 19.4-25.7c9.7-9.3 22.9-16.7 40.4-16.7c13.3 0 24 10.7 24 24s-10.7 24-24 24c-2.5 0-4.3 .6-7.1 3.3c-3.7 3.5-7.1 8.8-12.5 17.4l-.6 .9c-4.6 7.4-11 17.6-19.4 25.7c-9.7 9.3-22.9 16.7-40.4 16.7c-18.5 0-32.9-8.5-44.3-18.6c-3.1 4-6.6 8.3-10.5 12.7c1.4 4.3 2.8 8.5 4 12.5c.9 3 1.8 5.8 2.6 8.6c3 9.8 5.5 18.2 8.6 25.9c3.9 9.8 7.4 15.4 10.8 18.5c2.6 2.4 5.9 4.3 12.8 4.3c8.7 0 16.9-4.2 33.7-13.2c15-8 35.7-18.8 62.3-18.8c13.3 0 24 10.7 24 24s-10.7 24-24 24c-13.4 0-24.7 5.2-39.7 13.2c-1 .6-2.1 1.1-3.2 1.7C559.9 414 541.4 424 520 424c-18.4 0-33.6-6.1-45.5-17.2c-11.1-10.3-17.9-23.7-22.7-36c-3.6-9-6.7-19.1-9.5-28.5c-16.4 12.3-36.1 23.6-58.9 31.3c3.6 10.8 8.4 23.5 14.4 36.2c7.5 15.9 16.2 30.4 25.8 40.5C433 460.5 441.2 464 448 464c13.3 0 24 10.7 24 24s-10.7 24-24 24c-25.2 0-45-13.5-59.5-28.8c-14.5-15.4-25.7-34.9-34.2-53c-8-17-14.1-33.8-18.3-46.9c-5.2 .4-10.6 .6-16 .6s-10.8-.2-16-.6c-4.2 13-10.3 29.9-18.3 46.9c-8.5 18.1-19.8 37.6-34.2 53C237 498.5 217.2 512 192 512c-13.3 0-24-10.7-24-24s10.7-24 24-24c6.8 0 15-3.5 24.5-13.7c9.5-10.1 18.3-24.6 25.8-40.5c5.9-12.6 10.7-25.4 14.4-36.2c-22.8-7.7-42.5-19-58.9-31.3c-2.9 9.4-6 19.5-9.5 28.5c-4.8 12.2-11.6 25.6-22.7 36C153.6 417.9 138.4 424 120 424c-21.4 0-39.9-10-53.1-17.1c0 0 0 0 0 0c-1.1-.6-2.2-1.2-3.2-1.7c-15-8-26.3-13.2-39.7-13.2c-13.3 0-24-10.7-24-24s10.7-24 24-24c26.6 0 47.3 10.8 62.3 18.8c16.8 9 25 13.2 33.7 13.2c6.8 0 10.2-1.9 12.8-4.3c3.4-3.2 7-8.8 10.8-18.5c3-7.7 5.6-16.1 8.6-25.9c.8-2.7 1.7-5.6 2.6-8.6c1.2-4 2.6-8.2 4-12.5c-3.9-4.5-7.4-8.8-10.5-12.7C136.9 303.5 122.5 312 104 312c-17.5 0-30.7-7.4-40.4-16.7c-8.4-8.1-14.8-18.3-19.4-25.7l-.6-.9c-5.4-8.6-8.8-13.9-12.5-17.4c-2.8-2.7-4.6-3.3-7.1-3.3c-13.3 0-24-10.7-24-24s10.7-24 24-24c17.5 0 30.7 7.4 40.4 16.7c8.4 8.1 14.8 18.3 19.4 25.7l.6 .9c5.4 8.6 8.8 13.9 12.5 17.4c2.8 2.7 4.6 3.3 7.1 3.3c3.3 0 8.7-1.7 19.4-13.4c5.1-5.6 10.4-12.3 16.7-20.4l1.4-1.8c5.8-7.4 12.2-15.7 19.3-24c13.8-16.2 30.3-32.8 51.4-46.4l-15.1-30.2c-1.7 .1-3.4 .2-5.1 .2c-35.3 0-64-28.7-64-64s28.7-64 64-64s64 28.7 64 64zm208 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]
}, faPastafarianism = faSpaghettiMonsterFlying, faArrowDownUpAcrossLine = {
  prefix: "fas",
  iconName: "arrow-down-up-across-line",
  icon: [576, 512, [], "e4af", "M137.4 502.6c12.5 12.5 32.8 12.5 45.3 0l96-96c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 402.7 192 288l352 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0 0-114.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L384 109.3 384 224l-192 0-64 0-96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 0 114.7L86.6 361.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l96 96zM128 192l64 0 0-128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128zM448 320l-64 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128z"]
}, faArrowsRotateReverse = {
  prefix: "fas",
  iconName: "arrows-rotate-reverse",
  icon: [512, 512, [], "e630", "M406.6 202.6c-7.7-21.8-20.2-42.3-37.8-59.8c-62.5-62.5-163.8-62.5-226.3 0L125.5 160l34.3 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L48.3 224c0 0 0 0 0 0l-.4 0c-17.7 0-32-14.3-32-32l0-112c0-17.7 14.3-32 32-32s32 14.3 32 32l0 35.2L97.4 97.6c87.5-87.5 229.3-87.5 316.8 0c24.4 24.4 42.1 53.1 52.9 83.7c5.9 16.7-2.9 34.9-19.5 40.8s-34.9-2.9-40.8-19.5zm66.1 86.6c5 1.5 9.8 4.2 13.7 8.2c4 4 6.7 8.9 8.1 14c.3 1.2 .6 2.5 .8 3.8c.3 1.7 .4 3.4 .4 5.1l0 111.6c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-35.1-17.6 17.5c0 0 0 0 0 0c-87.5 87.4-229.3 87.4-316.7 0C73 390 55.3 361.3 44.5 330.6c-5.9-16.7 2.9-34.9 19.5-40.8s34.9 2.9 40.8 19.5c7.7 21.8 20.2 42.3 37.8 59.8c62.5 62.5 163.8 62.5 226.3 0l.1-.1L386.1 352l-34.4 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l111.6 0c1.6 0 3.2 .1 4.8 .3s3.1 .5 4.6 1z"]
}, faLeafHeart = {
  prefix: "fas",
  iconName: "leaf-heart",
  icon: [512, 512, [], "f4cb", "M272 96s0 0 0 0l104 0c42.7 0 79.9-23.9 98.8-59.1c3.5-6.5 13.6-6.8 16.2 .1c13.5 36.5 21.1 77 21.1 119.6C512 317.1 405.1 447.3 273 448l-1 0c-81.7 0-150.4-55.7-170.2-131.2C68.7 347.5 48 391.4 48 440l0 16c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-16c0-75.1 38.3-141.2 96.4-179.9C102.5 168.5 178.8 96 272 96c0 0 0 0 0 0zM189.7 242.8c0 14.4 5.8 28.3 16.2 38.4l70.9 69c6.2 6 16.1 6 22.3 0l70.9-69c10.4-10.1 16.2-23.9 16.2-38.4c0-29.5-23.9-53.5-53.5-53.5l-1.5 0c-14.3 0-28.1 5.6-38.4 15.6l-4.9 4.8-4.9-4.8c-10.3-10-24-15.6-38.4-15.6l-1.5 0c-29.5 0-53.5 23.9-53.5 53.5z"]
}, faHouseBuilding = {
  prefix: "fas",
  iconName: "house-building",
  icon: [640, 512, [], "e1b1", "M368 0c-26.5 0-48 21.5-48 48l0 105.9 64 58.7 0-4.6c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-18.8 0c1.9 6.8 2.8 13.9 2.8 21.1l0 10.9 16 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-16 0 0 112c0 18-6 34.6-16 48l192 0c26.5 0 48-21.5 48-48l0-416c0-26.5-21.5-48-48-48L368 0zM512 208c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM400 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm112 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM0 277.1L0 464c0 26.5 21.5 48 48 48l288 0c26.5 0 48-21.5 48-48l0-186.9c0-13.5-5.6-26.3-15.6-35.4l-144-132c-18.4-16.8-46.5-16.8-64.9 0l-144 132C5.6 250.8 0 263.7 0 277.1zM144 296c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z"]
}, faCheeseSwiss = {
  prefix: "fas",
  iconName: "cheese-swiss",
  icon: [512, 512, [129472], "f7f0", "M451 93c37.7 37.7 61 89.7 61 147.2l0 15.8-15.8 0L448 256 96 256l-80 0L0 256c0-5.4 .7-10.7 2.1-15.8c3.8-13.7 12.4-25.8 24.5-33.9L96 160l23.2-15.4c7.8-5.2 18.4-2.3 25.5 3.8C153.1 155.6 164 160 176 160c26.5 0 48-21.5 48-48c0-5.2-.8-10.2-2.3-14.9c-2.9-9-1.6-19.9 6.3-25.1l47-31.3c8.6-5.7 18.6-8.7 28.9-8.7c56 0 106.8 22.1 144.2 58c1 1 2 2 3 2.9zM432 288l16 0 48 0 16 0 0 16 0 112c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 304l0-16 16 0 80 0 208 0c8.8 0 15.7 7.4 18.6 15.7C329.1 322.5 347 336 368 336s38.9-13.5 45.4-32.3c2.9-8.4 9.8-15.7 18.6-15.7zM224 384a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]
}, faSpoon = {
  prefix: "fas",
  iconName: "spoon",
  icon: [512, 512, [129348, 61873, "utensil-spoon"], "f2e5", "M245.8 220.9c-14.5-17.6-21.8-39.2-21.8-60.8C224 80 320 0 416 0c53 0 96 43 96 96c0 96-80 192-160.2 192c-21.6 0-43.2-7.3-60.8-21.8L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L245.8 220.9z"]
}, faUtensilSpoon = faSpoon, faJarWheat = {
  prefix: "fas",
  iconName: "jar-wheat",
  icon: [320, 512, [], "e517", "M32 32C32 14.3 46.3 0 64 0L256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 64C46.3 64 32 49.7 32 32zM0 160c0-35.3 28.7-64 64-64l192 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 160zm112 0l-42.2 0c-3.2 0-5.8 2.6-5.8 5.8C64 198 90 224 122.2 224l21.8 0 32 0 21.8 0c32.1 0 58.2-26 58.2-58.2c0-3.2-2.6-5.8-5.8-5.8L208 160c-19.1 0-36.3 8.4-48 21.7c-11.7-13.3-28.9-21.7-48-21.7zm48 117.7c-11.7-13.3-28.9-21.7-48-21.7l-42.2 0c-3.2 0-5.8 2.6-5.8 5.8C64 294 90 320 122.2 320l21.8 0 32 0 21.8 0c32.1 0 58.2-26 58.2-58.2c0-3.2-2.6-5.8-5.8-5.8L208 256c-19.1 0-36.3 8.4-48 21.7zM112 352l-42.2 0c-3.2 0-5.8 2.6-5.8 5.8C64 390 90 416 122.2 416l21.8 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 21.8 0c32.1 0 58.2-26 58.2-58.2c0-3.2-2.6-5.8-5.8-5.8L208 352c-19.1 0-36.3 8.4-48 21.7c-11.7-13.3-28.9-21.7-48-21.7z"]
}, faEnvelopesBulk = {
  prefix: "fas",
  iconName: "envelopes-bulk",
  icon: [640, 512, ["mail-bulk"], "f674", "M128 0C110.3 0 96 14.3 96 32l0 192 96 0 0-32c0-35.3 28.7-64 64-64l224 0 0-96c0-17.7-14.3-32-32-32L128 0zM256 160c-17.7 0-32 14.3-32 32l0 32 96 0c35.3 0 64 28.7 64 64l0 128 192 0c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32l-320 0zm240 64l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM64 256c-17.7 0-32 14.3-32 32l0 13L187.1 415.9c1.4 1 3.1 1.6 4.9 1.6s3.5-.6 4.9-1.6L352 301l0-13c0-17.7-14.3-32-32-32L64 256zm288 84.8L216 441.6c-6.9 5.1-15.3 7.9-24 7.9s-17-2.8-24-7.9L32 340.8 32 480c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-139.2z"]
}, faMailBulk = faEnvelopesBulk, faFileCircleExclamation = {
  prefix: "fas",
  iconName: "file-circle-exclamation",
  icon: [576, 512, [], "e4eb", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 38.6C310.1 219.5 256 287.4 256 368c0 59.1 29.1 111.3 73.7 143.3c-3.2 .5-6.4 .7-9.7 .7L64 512c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zm48 96a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 240a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0-192c-8.8 0-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c0-8.8-7.2-16-16-16z"]
}, faBowArrow = {
  prefix: "fas",
  iconName: "bow-arrow",
  icon: [512, 512, [127993], "f6b9", "M511.7 18.9c1-5.2-.7-10.5-4.4-14.3S498.2-.7 493.1 .3l-128 24c-5.8 1.1-10.6 5.3-12.3 11s-.2 11.8 4 16l35 35L144.6 333.4 93.8 320.7c-8.2-2-16.8 .4-22.8 6.3L7 391c-6.1 6.1-8.5 15-6.2 23.4s8.9 14.8 17.3 16.9l50 12.5 12.5 50c2.1 8.4 8.5 15 16.9 17.3s17.3 0 23.4-6.2l64-64c6-6 8.4-14.6 6.3-22.8l-12.7-50.8L425.7 120.3l35 35c4.2 4.2 10.4 5.7 16 4s9.9-6.5 11-12.3l24-128zm-458 85.5c-12.6-11.6-32.1-11.3-44.3 .9c-12.5 12.5-12.5 32.8 0 45.3L145.8 287 191 241.8l-90.6-90.6c56.5-30.7 125.2-30.9 181.9-.7l46.8-46.8c-83.8-53.2-191.8-53-275.4 .8zM361.5 229.7c30.2 56.7 30 125.4-.7 181.9L270.2 321 225 366.2 361.4 502.6c12.5 12.5 32.8 12.5 45.3 0c12.2-12.2 12.5-31.8 .9-44.3c53.7-83.6 54-191.6 .8-275.4l-46.8 46.8z"]
}, faCartXmark = {
  prefix: "fas",
  iconName: "cart-xmark",
  icon: [576, 512, [], "e0dd", "M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l45.5 0c3.8 0 7.1 2.7 7.9 6.5l51.6 271c6.5 34 36.2 58.5 70.7 58.5L488 384c13.3 0 24-10.7 24-24s-10.7-24-24-24l-288.3 0c-11.5 0-21.4-8.2-23.6-19.5L170.7 288l288.5 0c32.6 0 61.1-21.8 69.5-53.3l41-152.3C576.6 57 557.4 32 531.1 32l-411 0C111 12.8 91.6 0 69.5 0L24 0zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm336-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM395.4 128.9L364.3 160l31.1 31.1c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0L336 188.3l-31.1 31.1c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3L307.7 160l-31.1-31.1c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0L336 131.7l31.1-31.1c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3z"]
}, faHexagonXmark = {
  prefix: "fas",
  iconName: "hexagon-xmark",
  icon: [512, 512, ["times-hexagon", "xmark-hexagon"], "f2ee", "M17.1 292c-12.9-22.3-12.9-49.7 0-72L105.4 67.1c12.9-22.3 36.6-36 62.4-36l176.6 0c25.7 0 49.5 13.7 62.4 36L494.9 220c12.9 22.3 12.9 49.7 0 72L406.6 444.9c-12.9 22.3-36.6 36-62.4 36l-176.6 0c-25.7 0-49.5-13.7-62.4-36L17.1 292zM175 175c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47c-9.4-9.4-24.6-9.4-33.9 0z"]
}, faTimesHexagon = faHexagonXmark, faXmarkHexagon = faHexagonXmark, faCircleH = {
  prefix: "fas",
  iconName: "circle-h",
  icon: [512, 512, [9405, "hospital-symbol"], "f47e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM368 152l0 104 0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80-128 0 0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80 128 0 0-80c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faHospitalSymbol = faCircleH, faMerge = {
  prefix: "fas",
  iconName: "merge",
  icon: [512, 512, [], "e526", "M32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l97.2 0c9.7 0 18.9 4.4 25 12L247 256 154.2 372c-6.1 7.6-15.3 12-25 12L32 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l97.2 0c29.2 0 56.7-13.3 75-36l99.2-124 80.6 0 0 32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c6-6 9.4-14.1 9.4-22.6s-3.4-16.6-9.4-22.6l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 32-80.6 0L204.2 100c-18.2-22.8-45.8-36-75-36L32 64z"]
}, faPager = {
  prefix: "fas",
  iconName: "pager",
  icon: [512, 512, [128223], "f815", "M0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm64 32l0 64c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L96 128c-17.7 0-32 14.3-32 32zM80 320c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0zm136 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0z"]
}, faCartMinus = {
  prefix: "fas",
  iconName: "cart-minus",
  icon: [576, 512, [], "e0db", "M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l45.5 0c3.8 0 7.1 2.7 7.9 6.5l51.6 271c6.5 34 36.2 58.5 70.7 58.5L488 384c13.3 0 24-10.7 24-24s-10.7-24-24-24l-288.3 0c-11.5 0-21.4-8.2-23.6-19.5L170.7 288l288.5 0c32.6 0 61.1-21.8 69.5-53.3l41-152.3C576.6 57 557.4 32 531.1 32l-411 0C111 12.8 91.6 0 69.5 0L24 0zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm336-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM280 132l112 0c11 0 20 9 20 20s-9 20-20 20l-112 0c-11 0-20-9-20-20s9-20 20-20z"]
}, faAddressBook = {
  prefix: "fas",
  iconName: "address-book",
  icon: [512, 512, [62138, "contact-book"], "f2b9", "M96 0C60.7 0 32 28.7 32 64l0 384c0 35.3 28.7 64 64 64l288 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L96 0zM208 288l64 0c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16c0-44.2 35.8-80 80-80zm-32-96a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM512 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64zM496 192c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16zm16 144c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64z"]
}, faContactBook = faAddressBook, faPanFrying = {
  prefix: "fas",
  iconName: "pan-frying",
  icon: [576, 512, [127859], "e42c", "M448 224c0 33.4-7.3 65.1-20.4 93.6l123.7 79.9C566.7 409.2 576 427.1 576 448c0 35.3-28.7 64-64 64c-15.2 0-28.3-4.6-39.3-13.5L364.8 398.3C326.3 429.4 277.3 448 224 448C100.3 448 0 347.7 0 224S100.3 0 224 0S448 100.3 448 224zM319.9 154c-21.2-5.4-50.6-22.6-65.8-38.4c-24.5-25.5-65-26.3-90.5-1.8c-11.6 11.2-18.1 25.6-19.4 40.5c-2.2 24.7-9.2 56.2-21.5 77.6c-22.1 38.3-9 87.2 29.3 109.3s87.2 9 109.3-29.3c9.4-16.3 33-30 51.6-32.6c10.2-1.4 20.3-5.4 29.2-12c28.4-21.1 34.3-61.1 13.3-89.5c-9.1-12.3-21.8-20.4-35.5-23.9zM528 448a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM224 176a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]
}, faGrid = {
  prefix: "fas",
  iconName: "grid",
  icon: [448, 512, ["grid-3"], "e195", "M0 72C0 49.9 17.9 32 40 32l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40L0 72zM0 232c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48zM128 392l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40zM160 72c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48zM288 232l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40zM160 392c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48zM448 72l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40zM320 232c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48zM448 392l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40z"]
}, faGrid3 = faGrid, faFootballHelmet = {
  prefix: "fas",
  iconName: "football-helmet",
  icon: [512, 512, [], "f44f", "M488.1 194.9c4.5 17.1-8.2 33.1-25.7 35.3L340.3 245.5l14 74.5L464 320c26.5 0 48 21.5 48 48l0 32 0 50.4c0 25.2-20.4 45.6-45.6 45.6l-17 0c-54.9 0-102-39.1-112.1-93.1L327.7 352 288 352l9.2 18.3c4.5 9 6.8 18.9 6.8 28.9c0 35.7-29 64.7-64.7 64.7l-1.7 0c-9 0-17.9-1.8-26.1-5.4l-93.4-40c-4-1.7-8.3-2.6-12.6-2.6l-14 0c-9.1 0-17.9-3.8-23.5-10.9C35.4 364.1 16 312.3 16 256C16 123.5 123.5 16 256 16c111.4 0 205.1 75.9 232.1 178.9zm-207.1 58c-14.3 1.8-25.1 14-25.1 28.4c0 4.4 1 8.8 3 12.8l13 26 49.7 0-13.2-70.6-27.4 3.4zM360.3 352l6 32L480 384l0-16c0-8.8-7.2-16-16-16l-103.7 0zM480 416l-105.3 0c13.1 28.7 42 48 74.7 48l17 0c7.5 0 13.6-6.1 13.6-13.6l0-34.4zM176 360a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faHandLove = {
  prefix: "fas",
  iconName: "hand-love",
  icon: [512, 512, [], "e1a5", "M160 0c17.7 0 32 14.3 32 32l0 159.9 0 .1 0 96c0 35.3 28.7 64 64 64c19.1 0 36.3-8.4 48-21.7c11.7 13.3 28.9 21.7 48 21.7c35.3 0 64-28.7 64-64l0-63.9c0 0 0 0 0-.1l0-128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 240c0 97.2-78.8 176-176 176l-19.2 0c-59.6 0-116.9-22.9-160-64L12.4 341c-16-15.2-16.6-40.6-1.4-56.6s40.6-16.6 56.6-1.4l60.5 57.6c0-1.5-.1-3.1-.1-4.6l0-304c0-17.7 14.3-32 32-32zm64 192c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96zm128 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32z"]
}, faTrees = {
  prefix: "fas",
  iconName: "trees",
  icon: [640, 512, [], "f724", "M70.2 121.4L178.5 5.8C182 2.1 186.9 0 192 0s10 2.1 13.5 5.8L313.8 121.4c4 4.3 6.2 9.9 6.2 15.7c0 12.7-10.3 22.9-22.9 22.9L272 160l74.6 89.5c3.5 4.2 5.4 9.5 5.4 15c0 13-10.5 23.5-23.5 23.5L304 288l74.6 89.5c3.5 4.2 5.4 9.5 5.4 15c0 13-10.5 23.5-23.5 23.5L224 416l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64L23.5 416C10.5 416 0 405.5 0 392.5c0-5.5 1.9-10.8 5.4-15L80 288l-24.5 0c-13 0-23.5-10.5-23.5-23.5c0-5.5 1.9-10.8 5.4-15L112 160l-25.1 0C74.3 160 64 149.7 64 137.1c0-5.8 2.2-11.4 6.2-15.7zm271.4-16.4L434.5 5.8C438 2.1 442.9 0 448 0s10 2.1 13.5 5.8L569.8 121.4c4 4.3 6.2 9.9 6.2 15.7c0 12.7-10.3 22.9-22.9 22.9L528 160l74.6 89.5c3.5 4.2 5.4 9.5 5.4 15c0 13-10.5 23.5-23.5 23.5L560 288l74.6 89.5c3.5 4.2 5.4 9.5 5.4 15c0 13-10.5 23.5-23.5 23.5L480 416l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64 0-23.4c0 0 0-.1 0-.1s0-.1 0-.1l0-.4s0 0 0 0c-.1-12.8-4.7-25.2-12.9-35l-40.6-48.7c13-10.2 21.4-26 21.4-43.8c0-13-4.6-25.6-12.9-35.5l-40.4-48.5c12.9-10 21.3-25.8 21.3-43.4c0-11.6-3.7-22.8-10.4-32.1z"]
}, faStrikethrough = {
  prefix: "fas",
  iconName: "strikethrough",
  icon: [512, 512, [], "f0cc", "M161.3 144c3.2-17.2 14-30.1 33.7-38.6c21.1-9 51.8-12.3 88.6-6.5c11.9 1.9 48.8 9.1 60.1 12c17.1 4.5 34.6-5.6 39.2-22.7s-5.6-34.6-22.7-39.2c-14.3-3.8-53.6-11.4-66.6-13.4c-44.7-7-88.3-4.2-123.7 10.9c-36.5 15.6-64.4 44.8-71.8 87.3c-.1 .6-.2 1.1-.2 1.7c-2.8 23.9 .5 45.6 10.1 64.6c4.5 9 10.2 16.9 16.7 23.9L32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-209.9 0-.4-.1-1.1-.3c-36-10.8-65.2-19.6-85.2-33.1c-9.3-6.3-15-12.6-18.2-19.1c-3.1-6.1-5.2-14.6-3.8-27.4zM348.9 337.2c2.7 6.5 4.4 15.8 1.9 30.1c-3 17.6-13.8 30.8-33.9 39.4c-21.1 9-51.7 12.3-88.5 6.5c-18-2.9-49.1-13.5-74.4-22.1c-5.6-1.9-11-3.7-15.9-5.4c-16.8-5.6-34.9 3.5-40.5 20.3s3.5 34.9 20.3 40.5c3.6 1.2 7.9 2.7 12.7 4.3c0 0 0 0 0 0s0 0 0 0c24.9 8.5 63.6 21.7 87.6 25.6c0 0 0 0 0 0l.2 0c44.7 7 88.3 4.2 123.7-10.9c36.5-15.6 64.4-44.8 71.8-87.3c3.6-21 2.7-40.4-3.1-58.1l-75.7 0c7 5.6 11.4 11.2 13.9 17.2z"]
}, faPage = {
  prefix: "fas",
  iconName: "page",
  icon: [384, 512, [], "e428", "M64 512H320c35.3 0 64-28.7 64-64V138.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0H64C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64z"]
}, faK = {
  prefix: "fas",
  iconName: "k",
  icon: [320, 512, [107], "4b", "M311 86.3c12.3-12.7 12-32.9-.7-45.2s-32.9-12-45.2 .7l-155.2 160L64 249 64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 328 0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-107 64.7-66.7 133 192c10.1 14.5 30 18.1 44.5 8.1s18.1-30 8.1-44.5L174.1 227.4 311 86.3z"]
}, faDiagramPrevious = {
  prefix: "fas",
  iconName: "diagram-previous",
  icon: [512, 512, [], "e478", "M448 352L64 352l0 64 384 0 0-64zm0-64c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l168 0 0-64-46.1 0c-21.4 0-32.1-25.9-17-41L239 113c9.4-9.4 24.6-9.4 33.9 0L343 183c15.1 15.1 4.4 41-17 41L280 224l0 64 168 0zM365.7 160.4L295.6 90.3c-21.9-21.9-57.3-21.9-79.2 0l-70.1 70.1c-18.4 18.4-20.4 43.7-11 63.6L64 224c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-71.3 0c9.4-19.9 7.4-45.2-11-63.6z"]
}, faGaugeMin = {
  prefix: "fas",
  iconName: "gauge-min",
  icon: [512, 512, ["tachometer-alt-slowest"], "f628", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64s-28.7-64-64-64c-14.1 0-27.2 4.6-37.8 12.4L100.6 227.6c-11.3-7-26.1-3.5-33 7.8s-3.5 26.1 7.8 33l117.5 72.8c-.6 3.5-.9 7.1-.9 10.8c0 35.3 28.7 64 64 64zM176 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faTachometerAltSlowest = faGaugeMin, faFolderGrid = {
  prefix: "fas",
  iconName: "folder-grid",
  icon: [512, 512, [], "e188", "M448 480L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l128 0c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8l160 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64zM104 240c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0zm128 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0zm104 24l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24z"]
}, faEggplant = {
  prefix: "fas",
  iconName: "eggplant",
  icon: [512, 512, [], "e16c", "M505 7c9.4 9.4 9.4 24.6 0 33.9l-9 9L496 192c0 8.8-7.2 16-16 16c-26.5 0-48-21.5-48-48c0-5.8-4-10.7-9.4-12.6c-13.3-4.8-25.4-13-35.1-22.8s-18-21.9-22.8-35.1c-2-5.4-6.9-9.4-12.6-9.4c-26.5 0-48-21.5-48-48c0-8.8 7.2-16 16-16l142.1 0 9-9c9.4-9.4 24.6-9.4 33.9 0zM169.9 139.3c40.3-19.6 81-39.3 113.4-66.6c11.8 20 32.1 34.4 55.9 38.3c6.7 14 15.8 26.3 25.8 36.2s22.2 19.1 36.2 25.8c5 30.4 27.1 55.1 56.2 63.8C410.6 362.7 311.1 512.2 176.4 512C79.9 511.9 1.4 431.3 0 336C-1.6 222.5 83.4 181.3 169.9 139.3z"]
}, faExcavator = {
  prefix: "fas",
  iconName: "excavator",
  icon: [640, 512, [], "e656", "M160 64l0 96 142.9 0-64-96L160 64zM384 190.5l0 17.5 0 16 0 48c0 26.5-21.5 48-48 48L48 320c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l48 0L96 48c0-26.5 21.5-48 48-48l94.9 0c21.4 0 41.4 10.7 53.3 28.5l78.4 117.7c8.8 13.1 13.4 28.6 13.4 44.4zM80 416c-8.8 0-16 7.2-16 16s7.2 16 16 16l256 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 416zM0 432c0-44.2 35.8-80 80-80l256 0c44.2 0 80 35.8 80 80s-35.8 80-80 80L80 512c-44.2 0-80-35.8-80-80zM640 320l0 64 0 48c0 44.2-35.8 80-80 80l-78.1 0c-18.7 0-33.9-15.2-33.9-33.9c0-9 3.6-17.6 9.9-24L576 336l0-208L416 288l0-128L562.7 13.3c8.5-8.5 20-13.3 32-13.3c25 0 45.3 20.3 45.3 45.3L640 320z"]
}, faRam = {
  prefix: "fas",
  iconName: "ram",
  icon: [640, 512, [128015], "f70a", "M336 64l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-8.8 7.2-16 16-16s16 7.2 16 16l0 24.4c-6.8 6.1-12.8 13.2-17.6 21l-47.8 20.5c-12.2 5.2-17.8 19.3-12.6 31.5s19.3 17.8 31.5 12.6l14.5-6.2 0 72.2c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-72.2 14.5 6.2c12.2 5.2 26.3-.4 31.5-12.6s-.4-26.3-12.6-31.5l-47.8-20.5c-4.9-7.8-10.8-14.9-17.6-21L544 64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 1.3c-5.2-.9-10.5-1.3-16-1.3s-10.8 .5-16 1.3l0-1.3c0-35.3-28.7-64-64-64s-64 28.7-64 64zM308.5 174.1c-8.9-20.8-4.3-44 10-59.7C312.3 85.6 286.7 64 256 64c-19.2 0-36.5 8.5-48.2 21.9C196.9 77.2 183 72 168 72c-30.1 0-55.3 20.8-62.2 48.8c-3.2-.5-6.5-.8-9.8-.8c-35.3 0-64 28.7-64 64c0 5.3 .7 10.5 1.9 15.5C13.7 210.3 0 231.5 0 256s13.7 45.7 33.9 56.5c-1.2 5-1.9 10.2-1.9 15.5c0 35.3 28.7 64 64 64c.5 0 1 0 1.5 0l17.6 93.9c2.8 15.1 16.1 26.1 31.5 26.1l29.4 0c17.7 0 32-14.3 32-32l0-53.7c11.7 13.3 28.9 21.7 48 21.7s36.3-8.4 48-21.7l0 53.7c0 17.7 14.3 32 32 32l29.4 0c15.4 0 28.6-11 31.4-26.1L414.5 392c.5 0 1 0 1.5 0c26.9 0 49.9-16.5 59.3-40L464 352c-61.9 0-112-50.1-112-112l0-32.6c-18.7-2.7-35.5-14.8-43.5-33.4zM464 160a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]
}, faLandmarkFlag = {
  prefix: "fas",
  iconName: "landmark-flag",
  icon: [512, 512, [], "e51c", "M272 0l80 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-80 0 0 32 192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L48 192c-17.7 0-32-14.3-32-32s14.3-32 32-32l192 0 0-112c0-8.8 7.2-16 16-16l16 0zM64 224l64 0 0 192 40 0 0-192 64 0 0 192 48 0 0-192 64 0 0 192 40 0 0-192 64 0 0 196.3c.6 .3 1.2 .7 1.8 1.1l48 32c11.7 7.8 17 22.4 12.9 35.9S494.1 512 480 512L32 512c-14.1 0-26.5-9.2-30.6-22.7s1.1-28.1 12.9-35.9l48-32c.6-.4 1.2-.7 1.8-1.1L64 224z"]
}, faLips = {
  prefix: "fas",
  iconName: "lips",
  icon: [576, 512, [128068, 128482], "f600", "M288 101.3c3-2.4 6.2-4.8 9.7-7.3c17.8-12.7 46.8-30 78.3-30c20.3 0 42.8 9.3 61.4 19.2c20 10.6 41.1 24.7 60.2 39.5c19.1 14.8 37.1 31.2 50.8 46.5c6.8 7.6 13.1 15.7 17.9 23.7c4.3 7.2 9.7 18.3 9.7 31c0 9.2-2.6 19.1-5.3 27.5c-3 9.1-7.4 19.4-12.8 30.3c-10.8 21.7-26.8 46.9-47.7 71.1C468.8 400.9 404.7 448 320 448l-64 0c-84.7 0-148.8-47.1-190.2-95.1C44.9 328.8 29 303.5 18.1 281.8C12.7 271 8.4 260.7 5.3 251.5C2.6 243.1 0 233.2 0 224c0-12.8 5.5-23.8 9.7-31c4.8-8.1 11.1-16.1 17.9-23.7c13.6-15.3 31.7-31.7 50.8-46.5c19.1-14.9 40.2-29 60.2-39.5C157.2 73.3 179.7 64 200 64c31.5 0 60.6 17.2 78.3 30c3.4 2.5 6.7 4.9 9.7 7.3zM64 224c0 7.9 80 96 224 96s224-88.1 224-96c0-7.7-46.3-31.1-138.8-32c-3.4 0-6.9 .5-10.1 1.5C350 197.6 313.7 208 288 208s-62-10.4-75.1-14.4c-3.3-1-6.7-1.6-10.1-1.5C110.3 192.9 64 216.3 64 224z"]
}, faPencil = {
  prefix: "fas",
  iconName: "pencil",
  icon: [512, 512, [9999, 61504, "pencil-alt"], "f303", "M410.3 231l11.3-11.3-33.9-33.9-62.1-62.1L291.7 89.8l-11.3 11.3-22.6 22.6L58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L387.7 253.7 410.3 231zM160 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1 0 32c0 8.8 7.2 16 16 16l32 0zM362.7 18.7L348.3 33.2 325.7 55.8 314.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L453.3 18.7c-25-25-65.5-25-90.5 0zm-47.4 168l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]
}, faPencilAlt = faPencil, faBackward = {
  prefix: "fas",
  iconName: "backward",
  icon: [512, 512, [9194], "f04a", "M459.5 440.6c9.5 7.9 22.8 9.7 34.1 4.4s18.4-16.6 18.4-29l0-320c0-12.4-7.2-23.7-18.4-29s-24.5-3.6-34.1 4.4L288 214.3l0 41.7 0 41.7L459.5 440.6zM256 352l0-96 0-128 0-32c0-12.4-7.2-23.7-18.4-29s-24.5-3.6-34.1 4.4l-192 160C4.2 237.5 0 246.5 0 256s4.2 18.5 11.5 24.6l192 160c9.5 7.9 22.8 9.7 34.1 4.4s18.4-16.6 18.4-29l0-64z"]
}, faCaretRight = {
  prefix: "fas",
  iconName: "caret-right",
  icon: [256, 512, [], "f0da", "M246.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 256c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l128-128z"]
}, faComments = {
  prefix: "fas",
  iconName: "comments",
  icon: [640, 512, [128490, 61670], "f086", "M208 352c114.9 0 208-78.8 208-176S322.9 0 208 0S0 78.8 0 176c0 38.6 14.7 74.3 39.6 103.4c-3.5 9.4-8.7 17.7-14.2 24.7c-4.8 6.2-9.7 11-13.3 14.3c-1.8 1.6-3.3 2.9-4.3 3.7c-.5 .4-.9 .7-1.1 .8l-.2 .2s0 0 0 0s0 0 0 0C1 327.2-1.4 334.4 .8 340.9S9.1 352 16 352c21.8 0 43.8-5.6 62.1-12.5c9.2-3.5 17.8-7.4 25.2-11.4C134.1 343.3 169.8 352 208 352zM448 176c0 112.3-99.1 196.9-216.5 207C255.8 457.4 336.4 512 432 512c38.2 0 73.9-8.7 104.7-23.9c7.5 4 16 7.9 25.2 11.4c18.3 6.9 40.3 12.5 62.1 12.5c6.9 0 13.1-4.5 15.2-11.1c2.1-6.6-.2-13.8-5.8-17.9c0 0 0 0 0 0s0 0 0 0l-.2-.2c-.2-.2-.6-.4-1.1-.8c-1-.8-2.5-2-4.3-3.7c-3.6-3.3-8.5-8.1-13.3-14.3c-5.5-7-10.7-15.4-14.2-24.7c24.9-29 39.6-64.7 39.6-103.4c0-92.8-84.9-168.9-192.6-175.5c.4 5.1 .6 10.3 .6 15.5z"]
}, faPaste = {
  prefix: "fas",
  iconName: "paste",
  icon: [512, 512, ["file-clipboard"], "f0ea", "M160 0c-23.7 0-44.4 12.9-55.4 32L48 32C21.5 32 0 53.5 0 80L0 400c0 26.5 21.5 48 48 48l144 0 0-272c0-44.2 35.8-80 80-80l48 0 0-16c0-26.5-21.5-48-48-48l-56.6 0C204.4 12.9 183.7 0 160 0zM272 128c-26.5 0-48 21.5-48 48l0 272 0 16c0 26.5 21.5 48 48 48l192 0c26.5 0 48-21.5 48-48l0-220.1c0-12.7-5.1-24.9-14.1-33.9l-67.9-67.9c-9-9-21.2-14.1-33.9-14.1L320 128l-48 0zM160 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]
}, faFileClipboard = faPaste, faDesktopArrowDown = {
  prefix: "fas",
  iconName: "desktop-arrow-down",
  icon: [576, 512, [], "e155", "M64 0C28.7 0 0 28.7 0 64L0 352c0 35.3 28.7 64 64 64l176 0-10.7 32L160 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-69.3 0L336 416l176 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L352 0l0 64 160 0 0 224L64 288 64 64l160 0 0-64L64 0zM312 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 150.1-39-39c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l80 80c9.4 9.4 24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-39 39L312 24z"]
}, faCodePullRequest = {
  prefix: "fas",
  iconName: "code-pull-request",
  icon: [512, 512, [], "e13c", "M305.8 2.1C314.4 5.9 320 14.5 320 24l0 40 16 0c70.7 0 128 57.3 128 128l0 166.7c28.3 12.3 48 40.5 48 73.3c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-32.8 19.7-61 48-73.3L400 192c0-35.3-28.7-64-64-64l-16 0 0 40c0 9.5-5.6 18.1-14.2 21.9s-18.8 2.3-25.8-4.1l-80-72c-5.1-4.6-7.9-11-7.9-17.8s2.9-13.3 7.9-17.8l80-72c7-6.3 17.2-7.9 25.8-4.1zM104 80A24 24 0 1 0 56 80a24 24 0 1 0 48 0zm8 73.3l0 205.3c28.3 12.3 48 40.5 48 73.3c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-32.8 19.7-61 48-73.3l0-205.3C19.7 141 0 112.8 0 80C0 35.8 35.8 0 80 0s80 35.8 80 80c0 32.8-19.7 61-48 73.3zM104 432a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm328 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faPumpkin = {
  prefix: "fas",
  iconName: "pumpkin",
  icon: [576, 512, [], "f707", "M234.6 103.9C251.5 98.8 269.4 96 288 96c22.8 0 44.7 4.2 64.8 11.7c-.6-2-.8-4.1-.8-6.3l0-66.1c0-6.9-4.1-13.2-10.5-15.9L299.3 1.4c-2.2-.9-4.5-1.4-6.8-1.4l-1.2 0c-6.9 0-13.1 4.1-15.8 10.4l-40.9 93.5zm161.6 27.3c12.1 8.8 23.1 19.1 32.7 30.5c5.6 6.7-2.9 14.6-10.4 10.1C380.3 149 335.7 136 288 136s-92.3 13-130.5 35.7c-7.5 4.5-16-3.4-10.4-10.1c9.6-11.4 20.6-21.7 32.7-30.5c-.6-.1-1.2-.2-1.8-.3c-8.5-1.8-17.2-2.8-26-2.8C68.1 128 0 214 0 320S68.1 512 152 512c19.3 0 37.8-4.5 54.7-12.8c8.3-4.1 18.2-4.1 26.5 0c17 8.3 35.4 12.8 54.7 12.8s37.8-4.5 54.7-12.8c8.3-4.1 18.2-4.1 26.5 0c17 8.3 35.4 12.8 54.7 12.8c83.9 0 152-86 152-192s-68.1-192-152-192c-8.9 0-17.6 1-26 2.8c-.6 .1-1.2 .2-1.8 .3z"]
}, faClipboardList = {
  prefix: "fas",
  iconName: "clipboard-list",
  icon: [384, 512, [], "f46d", "M192 0c-41.8 0-77.4 26.7-90.5 64L64 64C28.7 64 0 92.7 0 128L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l-37.5 0C269.4 26.7 233.8 0 192 0zm0 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM72 272a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM72 368a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88 0c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16z"]
}, faPenField = {
  prefix: "fas",
  iconName: "pen-field",
  icon: [640, 512, [], "e211", "M601.9 16c-18.8-18.8-49.2-18.7-67.9 0L494.4 55.7l89.3 89.3 39.8-38.9c19.1-18.7 19.2-49.4 .4-68.2L601.9 16zM328.5 221.8c-7 7-12.3 15.6-15.4 25l-23.8 71.3c-2.9 8.6-.6 18.1 5.8 24.6s15.9 8.7 24.6 5.8l71.5-23.9c9.2-3.1 17.6-8.2 24.5-15L560.8 167.5 471.7 78.4 328.5 221.8zM80 128c-44.2 0-80 35.8-80 80L0 432c0 44.2 35.8 80 80 80l416 0c44.2 0 80-35.8 80-80l0-128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128c0 8.8-7.2 16-16 16L80 448c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 128zm80 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faChartSine = {
  prefix: "fas",
  iconName: "chart-sine",
  icon: [512, 512, [], "e69d", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zm58.7 191.6c17.4 2.9 33.9-8.9 36.8-26.3c0 0 0 0 0 0c.7-4 1.7-7.9 2.8-11.8c2.1-7.7 5.5-17.7 10.3-27.3c10.5-21 22.3-30.3 35.4-30.3c12.1 0 19.3 4.5 26.6 15.6c8.9 13.4 15.1 32.6 22.9 57.9l.7 2.2c6.9 22.4 15.5 50.1 29.9 72c16.4 24.9 41.8 44.4 80 44.4c50.9 0 79.1-38.6 92.6-65.7c7.2-14.4 11.9-28.5 14.7-38.7c1.7-6 3.2-12.1 4.2-18.3c2.9-17.4-8.9-33.9-26.3-36.8s-33.9 8.9-36.8 26.3c0 0-.6 4-2.8 11.7c-2.1 7.7-5.5 17.7-10.3 27.3c-10.5 21-22.3 30.3-35.4 30.3c-12.1 0-19.3-4.5-26.6-15.6c-8.9-13.4-15.1-32.6-22.9-57.9l-.7-2.2c-6.9-22.4-15.5-50.1-29.9-72C271.6 115.5 246.2 96 208 96c-50.9 0-79.1 38.6-92.6 65.7c-7.2 14.4-11.9 28.5-14.7 38.7c-1.7 6-3.2 12.1-4.2 18.3c0 0 0 0 0 0c-2.9 17.4 8.9 33.9 26.3 36.8z"]
}, faBlueberries = {
  prefix: "fas",
  iconName: "blueberries",
  icon: [512, 512, [], "e2e8", "M512 176C512 78.8 433.2 0 336 0C255.4 0 187.4 54.2 166.6 128.2c3.1-.1 6.3-.2 9.4-.2c114.9 0 208 93.1 208 208c0 3.2-.1 6.3-.2 9.4C457.8 324.6 512 256.6 512 176zM176 512a176 176 0 1 0 0-352 176 176 0 1 0 0 352zm0-304c8.8 0 16 7.2 16 16l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16zM384 64l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16z"]
}, faTruckRampBox = {
  prefix: "fas",
  iconName: "truck-ramp-box",
  icon: [640, 512, ["truck-loading"], "f4de", "M640 0l0 400c0 61.9-50.1 112-112 112c-61 0-110.5-48.7-112-109.3L48.4 502.9c-17.1 4.6-34.6-5.4-39.3-22.5s5.4-34.6 22.5-39.3L352 353.8 352 64c0-35.3 28.7-64 64-64L640 0zM576 400a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM23.1 207.7c-4.6-17.1 5.6-34.6 22.6-39.2l46.4-12.4 20.7 77.3c2.3 8.5 11.1 13.6 19.6 11.3l30.9-8.3c8.5-2.3 13.6-11.1 11.3-19.6l-20.7-77.3 46.4-12.4c17.1-4.6 34.6 5.6 39.2 22.6l41.4 154.5c4.6 17.1-5.6 34.6-22.6 39.2L103.7 384.9c-17.1 4.6-34.6-5.6-39.2-22.6L23.1 207.7z"]
}, faTruckLoading = faTruckRampBox, faNote = {
  prefix: "fas",
  iconName: "note",
  icon: [448, 512, [], "e1ff", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 224-112 0c-26.5 0-48 21.5-48 48l0 112L64 480c-35.3 0-64-28.7-64-64L0 96zM402.7 352l45.3 0-32 32-64 64-32 32 0-45.3 0-66.7c0-8.8 7.2-16 16-16l66.7 0zM112 376a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM88 112a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm24 144a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]
}, faArrowDownToSquare = {
  prefix: "fas",
  iconName: "arrow-down-to-square",
  icon: [512, 512, [], "e096", "M374.6 246.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L288 242.7 288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 210.7-41.4-41.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l96 96c12.5 12.5 32.8 12.5 45.3 0l96-96zM80 32C35.8 32 0 67.8 0 112L0 432c0 44.2 35.8 80 80 80l352 0c44.2 0 80-35.8 80-80l0-320c0-44.2-35.8-80-80-80l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L80 448c-8.8 0-16-7.2-16-16l0-320c0-8.8 7.2-16 16-16l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 32z"]
}, faUserCheck = {
  prefix: "fas",
  iconName: "user-check",
  icon: [640, 512, [], "f4fc", "M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM0 482.3C0 383.8 79.8 304 178.3 304l91.4 0C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7L29.7 512C13.3 512 0 498.7 0 482.3zM625 177L497 305c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L591 143c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]
}, faCloudXmark = {
  prefix: "fas",
  iconName: "cloud-xmark",
  icon: [640, 512, [], "e35f", "M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128l-368 0zm95-273c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47c-9.4-9.4-24.6-9.4-33.9 0z"]
}, faVialVirus = {
  prefix: "fas",
  iconName: "vial-virus",
  icon: [512, 512, [], "e597", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l0 288c0 53 43 96 96 96c28.6 0 54.2-12.5 71.8-32.3c.1-14.2 5.6-28.3 16.4-39.1c.2-.2 .1-.6-.2-.6c-30.9 0-56-25.1-56-56s25.1-56 56-56c.3 0 .4-.4 .2-.6c-21.9-21.9-21.9-57.3 0-79.2c2.4-2.4 5-4.6 7.8-6.5L224 96c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0L96 32 32 32zM96 192l0-96 64 0 0 96-64 0zM216 376c28.8 0 43.2 34.8 22.9 55.2c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0c20.4-20.4 55.2-5.9 55.2 22.9c0 13.3 10.7 24 24 24s24-10.7 24-24c0-28.8 34.8-43.2 55.2-22.9c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9C444.8 410.8 459.2 376 488 376c13.3 0 24-10.7 24-24s-10.7-24-24-24c-28.8 0-43.2-34.8-22.9-55.2c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0C410.8 259.2 376 244.8 376 216c0-13.3-10.7-24-24-24s-24 10.7-24 24c0 28.8-34.8 43.2-55.2 22.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9c20.4 20.4 5.9 55.2-22.9 55.2c-13.3 0-24 10.7-24 24s10.7 24 24 24zm104-88a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm40 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faBookBlank = {
  prefix: "fas",
  iconName: "book-blank",
  icon: [448, 512, [128213, 128215, 128216, 128217, "book-alt"], "f5d9", "M96 0C43 0 0 43 0 96L0 416c0 53 43 96 96 96l288 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-64c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L384 0 96 0zm0 384l256 0 0 64L96 448c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faBookAlt = faBookBlank, faGolfFlagHole = {
  prefix: "fas",
  iconName: "golf-flag-hole",
  icon: [512, 512, [], "e3ac", "M162.7 2.5c-7.4-3.7-16.3-3.3-23.4 1.1S128 15.7 128 24l0 208c0 1.3 .1 2.7 .3 4c-.2 1.3-.3 2.6-.3 4l0 92.8C51.5 349.4 0 380.5 0 416c0 53 114.6 96 256 96s256-43 256-96s-114.6-96-256-96c-27.9 0-54.8 1.7-80 4.8l0-77.9 194.7-97.4c8.1-4.1 13.3-12.4 13.3-21.5s-5.1-17.4-13.3-21.5l-208-104zM288 416c0 17.7-28.7 32-64 32s-64-14.3-64-32s28.7-32 64-32s64 14.3 64 32z"]
}, faMessageArrowDown = {
  prefix: "fas",
  iconName: "message-arrow-down",
  icon: [512, 512, ["comment-alt-arrow-down"], "e1db", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zm280 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 118.1-31-31c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l72 72c9.4 9.4 24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-31 31L280 120z"]
}, faCommentAltArrowDown = faMessageArrowDown, faFaceUnamused = {
  prefix: "fas",
  iconName: "face-unamused",
  icon: [512, 512, [], "e39f", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm60.1-117.3c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6C188.2 355.4 216.3 336 256 336s67.8 19.4 83.9 37.3c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2zM112 192l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm176 16c0-8.8 7.2-16 16-16l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32l-32 0c-8.8 0-16-7.2-16-16z"]
}, faSheetPlastic = {
  prefix: "fas",
  iconName: "sheet-plastic",
  icon: [384, 512, [], "e571", "M0 448c0 35.3 28.7 64 64 64l160 0 0-128c0-17.7 14.3-32 32-32l128 0 0-288c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 448zM171.3 75.3l-96 96c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l96-96c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zm96 32l-160 160c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l160-160c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zM384 384l-128 0 0 128L384 384z"]
}, faCircle9 = {
  prefix: "fas",
  iconName: "circle-9",
  icon: [512, 512, [], "e0f6", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256 16a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm-26 44.4l-29.6 25.4c-10.1 8.6-11.2 23.8-2.6 33.8s23.8 11.2 33.8 2.6l81.6-70C337.8 287.2 352 256.4 352 224c0-53-43-96-96-96s-96 43-96 96c0 44 29.6 81.1 70 92.4z"]
}, faBlog = {
  prefix: "fas",
  iconName: "blog",
  icon: [512, 512, [], "f781", "M192 32c0 17.7 14.3 32 32 32c123.7 0 224 100.3 224 224c0 17.7 14.3 32 32 32s32-14.3 32-32C512 128.9 383.1 0 224 0c-17.7 0-32 14.3-32 32zm0 96c0 17.7 14.3 32 32 32c70.7 0 128 57.3 128 128c0 17.7 14.3 32 32 32s32-14.3 32-32c0-106-86-192-192-192c-17.7 0-32 14.3-32 32zM96 144c0-26.5-21.5-48-48-48S0 117.5 0 144L0 368c0 79.5 64.5 144 144 144s144-64.5 144-144s-64.5-144-144-144l-16 0 0 96 16 0c26.5 0 48 21.5 48 48s-21.5 48-48 48s-48-21.5-48-48l0-224z"]
}, faUserNinja = {
  prefix: "fas",
  iconName: "user-ninja",
  icon: [448, 512, [129399], "f504", "M224 256c-57.2 0-105.6-37.5-122-89.3c-1.1 1.3-2.2 2.6-3.5 3.8c-15.8 15.8-38.8 20.7-53.6 22.1c-8.1 .8-14.6-5.7-13.8-13.8c1.4-14.7 6.3-37.8 22.1-53.6c5.8-5.8 12.6-10.1 19.6-13.4c-7-3.2-13.8-7.6-19.6-13.4C37.4 82.7 32.6 59.7 31.1 44.9c-.8-8.1 5.7-14.6 13.8-13.8c14.7 1.4 37.8 6.3 53.6 22.1c4.8 4.8 8.7 10.4 11.7 16.1C131.4 28.2 174.4 0 224 0c70.7 0 128 57.3 128 128s-57.3 128-128 128zM0 482.3C0 399.5 56.4 330 132.8 309.9c6-1.6 12.2 .9 15.9 5.8l62.5 83.3c6.4 8.5 19.2 8.5 25.6 0l62.5-83.3c3.7-4.9 9.9-7.4 15.9-5.8C391.6 330 448 399.5 448 482.3c0 16.4-13.3 29.7-29.7 29.7L29.7 512C13.3 512 0 498.7 0 482.3zM160 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L160 96z"]
}, faPencilSlash = {
  prefix: "fas",
  iconName: "pencil-slash",
  icon: [640, 512, [], "e215", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L409.6 295.8l42.1-42.1L474.3 231l11.3-11.3-33.9-33.9-62.1-62.1L355.7 89.8l-11.3 11.3-22.6 22.6-57.8 57.8L38.8 5.1zM306.2 214.7l50.5-50.5c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-47.8 47.8-25.4-19.9zM195.5 250l-72.9 72.9c-10.4 10.4-18 23.3-22.2 37.4L65 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2l88.3-88.3-77.9-61.4-27.6 27.6c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l24.9-24.9L195.5 250zM224 399.4l-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9l-78.1 23 23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1 0 32c0 8.8 7.2 16 16 16l32 0zM426.7 18.7L412.3 33.2 389.7 55.8 378.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L517.3 18.7c-25-25-65.5-25-90.5 0z"]
}, faBowlingPins = {
  prefix: "fas",
  iconName: "bowling-pins",
  icon: [512, 512, [], "f437", "M128 0c35.3 0 64 28.7 64 64l0 1.1c0 7.4-1 14.8-2.9 22l-17.7 64.8c-.7 2.7-1.3 5.4-1.8 8.1l-83.1 0c-.5-2.7-1.1-5.4-1.8-8.1L66.9 87.1c-2-7.2-2.9-14.6-2.9-22L64 64C64 28.7 92.7 0 128 0zM82.1 210.4c2.2-6 3.8-12.1 4.8-18.4l82.3 0c1 6.3 2.6 12.4 4.8 18.4l38.6 104.7c7.6 20.6 11.5 42.5 11.5 64.4c0 28.9-6.7 57.5-19.7 83.4l-15.7 31.4C183.2 505.2 172.1 512 160 512l-64 0c-12.1 0-23.2-6.8-28.6-17.7L51.7 462.9C38.7 437 32 408.5 32 379.5c0-22 3.9-43.8 11.5-64.4L82.1 210.4zM384 0c35.3 0 64 28.7 64 64l0 1.1c0 7.4-1 14.8-2.9 22l-17.7 64.8c-.7 2.7-1.3 5.4-1.8 8.1l-83.1 0c-.5-2.7-1.1-5.4-1.8-8.1L322.9 87.1c-2-7.2-2.9-14.6-2.9-22l0-1.1c0-35.3 28.7-64 64-64zM338.1 210.4c2.2-6 3.8-12.1 4.8-18.4l82.3 0c1 6.3 2.6 12.4 4.8 18.4L470 319.3c6.6 17.9 10 36.8 10 55.8c0 20.5-3.9 40.9-11.5 59.9l-22.7 56.9C440.9 504 429.1 512 416 512l-64 0c-13.1 0-24.9-8-29.7-20.1L299.5 435C291.9 416 288 395.6 288 375.1c0-19 3.4-37.9 10-55.8l40.1-108.9z"]
}, faPersonArrowUpFromLine = {
  prefix: "fas",
  iconName: "person-arrow-up-from-line",
  icon: [640, 512, [], "e539", "M192 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-8 352l0-96 16 0 0 96-16 0zm-64 0l-88 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l120 0 80 0 376 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-344 0 0-191.1 28.6 47.5c9.1 15.1 28.8 20 43.9 10.9s20-28.8 10.9-43.9l-58.3-97c-17.4-28.9-48.6-46.6-82.3-46.6l-29.7 0c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9L120 256.9 120 448zM598.6 121.4l-80-80c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L464 141.3 464 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-242.7 25.4 25.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3z"]
}, faDownRight = {
  prefix: "fas",
  iconName: "down-right",
  icon: [384, 512, [], "e16b", "M336 432L96 432c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l72-72L11.3 171.3C4.1 164.1 0 154.2 0 144s4.1-20.1 11.3-27.3L52.7 75.3C59.9 68.1 69.8 64 80 64s20.1 4.1 27.3 11.3L241.4 209.4l72-72c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6l0 240c0 17.7-14.3 32-32 32z"]
}, faScrollTorah = {
  prefix: "fas",
  iconName: "scroll-torah",
  icon: [640, 512, ["torah"], "f6a0", "M96 480L96 32C96 14.3 74.5 0 48 0S0 14.3 0 32L0 480c0 17.7 21.5 32 48 32s48-14.3 48-32zM512 32L128 32l0 448 384 0 0-448zM592 0c-26.5 0-48 14.3-48 32l0 448c0 17.7 21.5 32 48 32s48-14.3 48-32l0-448c0-17.7-21.5-32-48-32zM196 313.7c0-3.2 .9-6.4 2.5-9.2L226.7 256l-28.3-48.5c-1.6-2.8-2.5-6-2.5-9.2c0-10.1 8.2-18.3 18.3-18.3l56.7 0 31.4-53.9c3.6-6.3 10.3-10.1 17.6-10.1s13.9 3.8 17.6 10.1L369 180l56.7 0c10.1 0 18.3 8.2 18.3 18.3c0 3.2-.9 6.4-2.5 9.2L413.3 256l28.3 48.5c1.6 2.8 2.5 6 2.5 9.2c0 10.1-8.2 18.3-18.3 18.3L369 332l-31.4 53.9c-3.6 6.3-10.3 10.1-17.6 10.1s-13.9-3.8-17.6-10.1L271 332l-56.7 0c-10.1 0-18.3-8.2-18.3-18.3zm124 54.7L341.2 332l-42.4 0L320 368.4zM254.5 256l30.3 52 70.4 0 30.3-52-30.3-52-70.4 0-30.3 52zm144.9 23.8L383 308l32.8 0-16.4-28.2zM415.8 204L383 204l16.4 28.2L415.8 204zM320 143.6L298.8 180l42.4 0L320 143.6zM224.2 204l16.4 28.2L257 204l-32.8 0zM257 308l-16.4-28.2L224.2 308l32.8 0z"]
}, faTorah = faScrollTorah, faWebhook = {
  prefix: "fas",
  iconName: "webhook",
  icon: [576, 512, [], "e5d5", "M306 50.1c-43.1-9.9-86 16.9-95.9 60c-7.9 34.1 7.4 68.2 35.5 85.9c5.4 3.4 9.2 8.8 10.7 15s.3 12.7-3 18.1L170.4 361.5c3.6 6.7 5.6 14.4 5.6 22.5c0 26.5-21.5 48-48 48s-48-21.5-48-48s21.5-48 48-48c.6 0 1.1 0 1.7 0L201 221.9c-32.5-30.2-48.4-76.4-37.7-122.7C179.2 30.3 247.9-12.6 316.8 3.3c65.9 15.2 108 78.7 97.7 144.4c-2.1 13.1-14.3 22-27.4 20s-22-14.3-20-27.4c6.4-41.1-19.9-80.7-61.1-90.2zM289.7 176c-.6 0-1.1 0-1.7 0c-26.5 0-48-21.5-48-48s21.5-48 48-48s48 21.5 48 48c0 8.1-2 15.8-5.6 22.5l71.3 114.1c45.8-17.7 99.8-8.2 136.8 28.9c50 50 50 131 0 181c-43 43-109 49-158.4 18c-11.2-7-14.6-21.8-7.6-33.1s21.8-14.6 33.1-7.6c30.9 19.3 72.1 15.5 99-11.3c31.2-31.2 31.2-81.9 0-113.1c-26.8-26.8-68.1-30.6-99-11.3c-5.4 3.4-11.9 4.5-18.1 3s-11.6-5.3-15-10.7L289.7 176zM448 432c-17.8 0-33.3-9.7-41.6-24l-152.7 0c-9.2 48.3-46 89-97 100.7c-68.9 15.9-137.6-27-153.5-95.9C-11 351 22.1 289.4 78.7 265.8c12.2-5.1 26.3 .7 31.4 12.9s-.7 26.3-12.9 31.4c-35.4 14.7-56 53.3-47.1 91.8c9.9 43 52.9 69.9 95.9 60c37-8.5 62.1-41.5 62-77.9c0-6.4 2.5-12.5 7-17s10.6-7 17-7l174.4 0c8.3-14.3 23.8-24 41.6-24c26.5 0 48 21.5 48 48s-21.5 48-48 48z"]
}, faBlindsOpen = {
  prefix: "fas",
  iconName: "blinds-open",
  icon: [512, 512, [], "f8fc", "M0 32C0 14.3 14.3 0 32 0L480 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L160 64l0 64 0 64 0 66.7c13.6 4.8 24.4 15.6 29.3 29.3c.1 .3 .2 .7 .4 1c1.5 4.7 2.4 9.7 2.4 15c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-5.6 1-11 2.7-16c4.8-13.6 15.6-24.4 29.3-29.3l0-66.7 0-64 0-64L32 64C14.3 64 0 49.7 0 32zm47.4 96L96 128l0 64-78.2 0C8 192 0 184 0 174.2c0-4 1.4-7.9 3.9-11.1L22.4 140c6.1-7.6 15.3-12 25-12zm0 160l18.2 0c-1 5.2-1.6 10.5-1.6 16c0 18 6 34.6 16 48l-62.2 0C8 352 0 344 0 334.2c0-4 1.4-7.9 3.9-11.1L22.4 300c6.1-7.6 15.3-12 25-12zm446.9 64L208 352c10-13.4 16-30 16-48c0-5.5-.6-10.8-1.6-16l242.2 0c9.7 0 18.9 4.4 25 12l18.5 23.1c2.5 3.2 3.9 7.1 3.9 11.1c0 9.8-8 17.8-17.8 17.8zm0-160L192 192l0-64 272.6 0c9.7 0 18.9 4.4 25 12l18.5 23.1c2.5 3.2 3.9 7.1 3.9 11.1c0 9.8-8 17.8-17.8 17.8zM17.8 512C8 512 0 504 0 494.2c0-4 1.4-7.9 3.9-11.1L22.4 460c6.1-7.6 15.3-12 25-12l417.2 0c9.7 0 18.9 4.4 25 12l18.5 23.1c2.5 3.2 3.9 7.1 3.9 11.1c0 9.8-8 17.8-17.8 17.8L17.8 512z"]
}, faFence = {
  prefix: "fas",
  iconName: "fence",
  icon: [512, 512, [], "e303", "M76.8 38.4C73.8 34.4 69 32 64 32s-9.8 2.4-12.8 6.4L6.4 98.1C2.2 103.7 0 110.4 0 117.3L0 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-32 32 0 0-64-32 0 0-128 32 0 0-64-32 0 0-42.7c0-6.9-2.2-13.7-6.4-19.2L76.8 38.4zm192 0c-3-4-7.8-6.4-12.8-6.4s-9.8 2.4-12.8 6.4L198.4 98.1c-4.2 5.5-6.4 12.3-6.4 19.2L192 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-32 32 0 0-64-32 0 0-128 32 0 0-64-32 0 0-42.7c0-6.9-2.2-13.7-6.4-19.2L268.8 38.4zM448 32c-5 0-9.8 2.4-12.8 6.4L390.4 98.1c-4.2 5.5-6.4 12.3-6.4 19.2L384 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-330.7c0-6.9-2.2-13.7-6.4-19.2L460.8 38.4c-3-4-7.8-6.4-12.8-6.4z"]
}, faUp = {
  prefix: "fas",
  iconName: "up",
  icon: [384, 512, ["arrow-alt-up"], "f357", "M169.4 41.4c12.5-12.5 32.8-12.5 45.3 0l160 160c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8l-96 0 0 184c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-184-96 0c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l160-160z"]
}, faArrowAltUp = faUp, faBroomBall = {
  prefix: "fas",
  iconName: "broom-ball",
  icon: [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", "M566.6 9.4c12.5 12.5 12.5 32.8 0 45.3l-192 192 34.7 34.7c4.2 4.2 6.6 10 6.6 16c0 12.5-10.1 22.6-22.6 22.6l-29.1 0L256 211.7l0-29.1c0-12.5 10.1-22.6 22.6-22.6c6 0 11.8 2.4 16 6.6l34.7 34.7 192-192c12.5-12.5 32.8-12.5 45.3 0zm-344 225.5L341.1 353.4c3.7 42.7-11.7 85.2-42.3 115.8C271.4 496.6 234.2 512 195.5 512L22.1 512C9.9 512 0 502.1 0 489.9c0-6.3 2.7-12.3 7.3-16.5L133.7 359.7c4.2-3.7-.4-10.4-5.4-7.9L77.2 377.4c-6.1 3-13.2-1.4-13.2-8.2c0-31.5 12.5-61.7 34.8-84l8-8c30.6-30.6 73.1-45.9 115.8-42.3zM464 352a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"]
}, faQuidditch = faBroomBall, faQuidditchBroomBall = faBroomBall, faDrumstick = {
  prefix: "fas",
  iconName: "drumstick",
  icon: [512, 512, [127831], "f6d6", "M150.6 287.8c6-6 9.4-14.1 9.4-22.6l0-89.2C160 78.8 238.8 0 336 0s176 78.8 176 176s-78.8 176-176 176l-89.2 0c-8.5 0-16.6 3.4-22.6 9.4l-26.8 26.8c-12.3 12.3-11.4 32.5-7.2 49.4c1.1 4.6 1.8 9.5 1.8 14.5c0 33.1-26.9 60-60 60s-60-26.9-60-60c0-6.3-5.7-12-12-12c-33.1 0-60-26.9-60-60s26.9-60 60-60c5 0 9.8 .6 14.5 1.8c16.9 4.2 37.1 5.2 49.4-7.2l26.8-26.8z"]
}, faSquareV = {
  prefix: "fas",
  iconName: "square-v",
  icon: [448, 512, [], "e284", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm77.5 125.3L224 322.3l82.5-165.1c5.9-11.9 20.3-16.7 32.2-10.7s16.7 20.3 10.7 32.2l-104 208c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3l-104-208c-5.9-11.9-1.1-26.3 10.7-32.2s26.3-1.1 32.2 10.7z"]
}, faFaceAwesome = {
  prefix: "fas",
  iconName: "face-awesome",
  icon: [512, 512, ["gave-dandy"], "e409", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm203.5-95.6c-5.6 9.4-15.8 15.6-27.5 15.6c-17.7 0-32-14.3-32-32c0-9.1 3.8-17.4 10-23.2c-3.3-.5-6.6-.8-10-.8c-35.3 0-64 28.7-64 64l0 10.3c0 16.4 13.3 29.7 29.7 29.7l68.6 0c16.4 0 29.7-13.3 29.7-29.7l0-10.3c0-8.3-1.6-16.3-4.5-23.6zM384 176c-17.7 0-32-14.3-32-32c0-8.5 3.3-16.3 8.8-22c-5.4-1.3-11-2-16.8-2c-39.8 0-72 32.2-72 72l0 7.5c0 13.5 11 24.5 24.5 24.5l95.1 0c13.5 0 24.5-11 24.5-24.5l0-7.5c0-10.4-2.2-20.2-6.1-29.1c-5.8 8-15.2 13.1-25.9 13.1zM245.5 447.8c2.7 .1 5.4 .2 8.1 .2l4.9 0c55.1 0 105.1-26.1 137-67.5c0 0 0 0 0 0c15.7-20.5 27-44.6 32.4-71.3c2.2-11-6.2-21.2-17.4-21.2c0 0 0 0 0 0l-308.8 0s0 0 0 0c-11.2 0-19.6 10.2-17.4 21.2c15.6 78.1 82.4 135 161.2 138.6zm-5.4-32.5c1.5-44.1 37.8-79.4 82.2-79.4c19.9 0 38.1 7 52.3 18.7C349 392.1 306.1 416 258.4 416l-4.9 0c-4.6 0-9.1-.2-13.5-.6z"]
}, faGaveDandy = faFaceAwesome, faDialOff = {
  prefix: "fas",
  iconName: "dial-off",
  icon: [576, 512, [], "e162", "M288 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM448 288c0 80.2-59 146.6-136 158.2L312 288c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 158.2c-77-11.6-136-78-136-158.2c0-88.4 71.6-160 160-160s160 71.6 160 160zm64 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0A32 32 0 1 1 64 96zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faToggleOff = {
  prefix: "fas",
  iconName: "toggle-off",
  icon: [576, 512, [], "f204", "M384 128c70.7 0 128 57.3 128 128s-57.3 128-128 128l-192 0c-70.7 0-128-57.3-128-128s57.3-128 128-128l192 0zM576 256c0-106-86-192-192-192L192 64C86 64 0 150 0 256S86 448 192 448l192 0c106 0 192-86 192-192zM192 352a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"]
}, faFaceSmileHorns = {
  prefix: "fas",
  iconName: "face-smile-horns",
  icon: [640, 512, [], "e391", "M320 512c141.4 0 256-114.6 256-256c0-24.6-3.5-48.4-9.9-70.9c44.3-59.4 67.4-135 73.6-166c1.3-6.3-1.4-12.8-6.8-16.4s-12.4-3.6-17.8 0c-19.3 12.9-48.5 24.2-78.4 33.1c-23.3 7-46 12.2-63 15.5C430.9 19.1 377.7 0 320 0S209.1 19.1 166.2 51.3c-17-3.3-39.7-8.6-63-15.5C73.4 26.9 44.2 15.5 24.9 2.7C19.5-.9 12.5-.9 7.1 2.7S-1 12.8 .3 19.1c6.2 31 29.3 106.6 73.6 166C67.5 207.6 64 231.4 64 256c0 141.4 114.6 256 256 256zM228.1 349.5C246 370.2 276.6 392 320 392s74-21.8 91.9-42.5c5.8-6.7 15.9-7.4 22.6-1.6s7.4 15.9 1.6 22.6C413.8 396.1 375.1 424 320 424s-93.8-27.9-116.1-53.5c-5.8-6.7-5.1-16.8 1.6-22.6s16.8-5.1 22.6 1.6zM272.4 272c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-8.8 3.6-16.8 9.3-22.6l-30.7-10.2c-8.4-2.8-12.9-11.9-10.1-20.2s11.9-12.9 20.2-10.1l96 32c8.4 2.8 12.9 11.9 10.1 20.2s-11.9 12.9-20.2 10.1l-10.9-3.6c.2 1.5 .3 2.9 .3 4.4zm128 32c-17.7 0-32-14.3-32-32c0-1.6 .1-3.2 .3-4.7l-11.7 3.9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l96-32c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-30.2 10.1c5.9 5.8 9.5 13.9 9.5 22.8c0 17.7-14.3 32-32 32z"]
}, faBoxArchive = {
  prefix: "fas",
  iconName: "box-archive",
  icon: [512, 512, ["archive"], "f187", "M32 32l448 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L32 128C14.3 128 0 113.7 0 96L0 64C0 46.3 14.3 32 32 32zm0 128l448 0 0 256c0 35.3-28.7 64-64 64L96 480c-35.3 0-64-28.7-64-64l0-256zm128 80c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16z"]
}, faArchive = faBoxArchive, faGrapes = {
  prefix: "fas",
  iconName: "grapes",
  icon: [512, 512, [], "e306", "M346.7 6C337.6 17 320 42.3 320 72c0 40 15.3 55.3 40 80s40 40 80 40c29.7 0 55-17.6 66-26.7c4-3.3 6-8.2 6-13.3s-2-10-6-13.2c-11.4-9.1-38.3-26.8-74-26.8c-32 0-40 8-40 8s8-8 8-40c0-35.7-17.7-62.6-26.8-74C370 2 365.1 0 360 0s-10 2-13.3 6zM304 152a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM112 232a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm32 80A56 56 0 1 0 32 312a56 56 0 1 0 112 0zM112 456A56 56 0 1 0 0 456a56 56 0 1 0 112 0zm144-32a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm80 32a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM280 288a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zm80 32a56 56 0 1 0 0-112 56 56 0 1 0 0 112z"]
}, faPersonDrowning = {
  prefix: "fas",
  iconName: "person-drowning",
  icon: [576, 512, [], "e545", "M192 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32.2c0 54.1 23.5 104 62.2 138.3l-21 146.7c7.8 2.1 15.5 3.3 22.8 3.3c21.1 0 42-8.5 59.2-20.3c22.1-15.5 51.6-15.5 73.7 0c12.4 8.5 26.1 14.8 39.7 18l17.7-97.6c10.7-1.2 21.3-3.1 31.9-5.5l105-23.9c17.2-3.9 28-21.1 24.1-38.3s-21.1-28-38.3-24.1L400 216.6c-41 9.3-83.7 7.5-123.7-5.2c-50.2-16-84.3-62.6-84.3-115.3L192 64zM320 192a64 64 0 1 0 0-128 64 64 0 1 0 0 128zM306.5 389.9c-11.1-7.9-25.9-7.9-37 0C247 405.4 219.5 416 192 416c-26.9 0-55.3-10.8-77.4-26.1c0 0 0 0 0 0c-11.9-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4s21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 469.7 159 480 192 480c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.4-27.3-10.1-39.2-1.7c0 0 0 0 0 0C439.4 405.2 410.9 416 384 416c-27.5 0-55-10.6-77.5-26.1z"]
}, faDialMax = {
  prefix: "fas",
  iconName: "dial-max",
  icon: [576, 512, [], "e15e", "M288 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM401.4 174.7c56.7 56.7 61.9 145.4 15.7 208L305.2 270.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L383.2 416.7c-62.6 46.2-151.3 41-208-15.7c-62.5-62.5-62.5-163.8 0-226.3s163.8-62.5 226.3 0zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0A32 32 0 1 1 64 96zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faCircleM = {
  prefix: "fas",
  iconName: "circle-m",
  icon: [512, 512, [], "e115", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM171.5 137.9L256 255l84.5-117.1c6.1-8.4 16.9-12 26.8-8.8s16.6 12.4 16.6 22.8l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-133.8-60.5 83.8c-4.5 6.2-11.7 9.9-19.5 9.9s-14.9-3.7-19.5-9.9L176 226.2 176 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-10.4 6.7-19.6 16.6-22.8s20.7 .3 26.8 8.8z"]
}, faCalendarImage = {
  prefix: "fas",
  iconName: "calendar-image",
  icon: [448, 512, [], "e0d4", "M96 32l0 32L48 64C21.5 64 0 85.5 0 112l0 48 448 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32S96 14.3 96 32zM448 192L0 192 0 464c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-272zM147.2 360.7c6.5-8.4 19.1-8.3 25.5 .2L184 376l58.3-84.2c6.5-9.4 20.5-9.1 26.7 .5l83.4 131.1c6.8 10.6-.9 24.6-13.5 24.6l-226.4 0c-13.3 0-20.8-15.2-12.7-25.8l47.3-61.5zM128 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faCircleCaretDown = {
  prefix: "fas",
  iconName: "circle-caret-down",
  icon: [512, 512, ["caret-circle-down"], "f32d", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zm0 368c-6.7 0-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9s12.5-14.4 22-14.4l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7z"]
}, faCaretCircleDown = faCircleCaretDown, faArrowDown91 = {
  prefix: "fas",
  iconName: "arrow-down-9-1",
  icon: [576, 512, ["sort-numeric-desc", "sort-numeric-down-alt"], "f886", "M160 480c9 0 17.5-3.8 23.6-10.4l88-96c11.9-13 11.1-33.3-2-45.2s-33.3-11.1-45.2 2L192 365.7 192 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 301.7L95.6 330.4c-11.9-13-32.2-13.9-45.2-2s-13.9 32.2-2 45.2l88 96C142.5 476.2 151 480 160 480zM450.7 294c-8.3-6-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 51.6-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l48 0 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-96c0-10.3-4.9-19.9-13.3-26zM418.3 91a32 32 0 1 1 27.4 57.9A32 32 0 1 1 418.3 91zM405.1 203.8l-6.8 9.2c-10.5 14.2-7.5 34.2 6.7 44.8s34.2 7.5 44.8-6.7l48.8-65.8c14-18.9 21.5-41.7 21.5-65.2c0-48.6-39.4-88-88-88s-88 39.4-88 88c0 39.2 25.6 72.4 61.1 83.8z"]
}, faSortNumericDesc = faArrowDown91, faSortNumericDownAlt = faArrowDown91, faFaceGrinTongueSquint = {
  prefix: "fas",
  iconName: "face-grin-tongue-squint",
  icon: [512, 512, [128541, "grin-tongue-squint"], "f58a", "M0 256C0 368.9 73.1 464.7 174.5 498.8C165.3 484 160 466.6 160 448l0-47.3c-24-17.5-43.1-41.4-54.8-69.2c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19c12.3-3.8 24.3 6.9 19.3 18.7c-11.8 28-31.1 52-55.4 69.6l0 46.9c0 18.6-5.3 36-14.5 50.8C438.9 464.7 512 368.9 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256zM116 141.1c0-9 9.6-14.7 17.5-10.5l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm262.5-10.5c7.9-4.2 17.5 1.5 17.5 10.5c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9zM320 448l0-45.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9c-2.8 12.6-20.8 12.6-23.6 0c-2.5-11.1-12.3-18.9-23.6-18.9l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 45.4c0 35.3 28.7 64 64 64s64-28.7 64-64z"]
}, faGrinTongueSquint = faFaceGrinTongueSquint, faShishKebab = {
  prefix: "fas",
  iconName: "shish-kebab",
  icon: [512, 512, [], "f821", "M438.6 73.4c-12.5-12.5-32.8-12.5-45.3 0c-11.5 11.5-12.4 29.7-2.7 42.2c11.1 14.2 13.3 37.7-3 53.9L346.2 211 301 165.8l28.4-28.4c-17-35.7-10.8-79.7 18.8-109.3c37.5-37.5 98.3-37.5 135.8 0c31.4 31.4 36.5 79.2 15.3 115.9c-8.8 15.3-28.4 20.5-43.7 11.7s-20.5-28.4-11.7-43.7c7.1-12.2 5.3-28.2-5.1-38.6zM61.8 405L107 450.2 54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L61.8 405zM244.3 154.3L357.7 267.7c15.6 15.6 15.6 40.9 0 56.6l-25.4 25.4c-15.6 15.6-40.9 15.6-56.6 0L162.3 236.3c-15.6-15.6-15.6-40.9 0-56.6l25.4-25.4c15.6-15.6 40.9-15.6 56.6 0zM75.7 266.3c15.6-15.6 40.9-15.6 56.6 0L245.7 379.7c15.6 15.6 15.6 40.9 0 56.6l-25.4 25.4c-15.6 15.6-40.9 15.6-56.6 0L50.3 348.3c-15.6-15.6-15.6-40.9 0-56.6l25.4-25.4z"]
}, faSprayCan = {
  prefix: "fas",
  iconName: "spray-can",
  icon: [512, 512, [], "f5bd", "M128 0l64 0c17.7 0 32 14.3 32 32l0 96L96 128l0-96c0-17.7 14.3-32 32-32zM0 256c0-53 43-96 96-96l128 0c53 0 96 43 96 96l0 208c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 256zm240 80A80 80 0 1 0 80 336a80 80 0 1 0 160 0zM256 64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM384 32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM448 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM384 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faAlarmSnooze = {
  prefix: "fas",
  iconName: "alarm-snooze",
  icon: [512, 512, [], "f845", "M160 25.4C143 9.6 120.2 0 95.2 0C42.6 0 0 42.6 0 95.2c0 18.8 5.5 36.3 14.9 51.1L160 25.4zM256 512c50.3 0 96.8-16.6 134.2-44.6l35.2 35.2c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-35.2-35.2c28-37.4 44.6-83.8 44.6-134.2C480 164.3 379.7 64 256 64S32 164.3 32 288c0 50.3 16.6 96.8 44.6 134.2L41.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l35.2-35.2c37.4 28 83.8 44.6 134.1 44.6zM497.1 146.4C506.5 131.6 512 114 512 95.2C512 42.6 469.4 0 416.8 0C391.8 0 369 9.6 352 25.4L497.1 146.4zM200 192l112 0c9.2 0 17.5 5.2 21.6 13.5s3 18-2.6 25.3L249.1 336l62.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-9.2 0-17.5-5.2-21.6-13.5s-3-18 2.6-25.3L262.9 240 200 240c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faScarecrow = {
  prefix: "fas",
  iconName: "scarecrow",
  icon: [448, 512, [], "f70d", "M320 96c0 11.2-1.9 22-5.5 32L416 128c5.9 0 11.3 3.2 14.1 8.5s2.5 11.5-.8 16.4l-7.6 11.4 19.9 14.9c4 3 6.4 7.8 6.4 12.8s-2.4 9.8-6.4 12.8l-19.9 14.9 7.6 11.4c3.3 4.9 3.6 11.2 .8 16.4s-8.2 8.5-14.1 8.5l-73 0c-10.1 0-17.7 9.2-15.7 19.1l24.3 121.7c1.2 6.2-1.2 12.5-6.3 16.1s-11.8 4-17.3 .9L287.9 391c-4.9-2.8-11-2.8-15.9 0l-40.1 22.9c-4.9 2.8-11 2.8-15.9 0L175.9 391c-4.9-2.8-11-2.8-15.9 0l-40.1 22.9c-5.4 3.1-12.2 2.8-17.3-.9s-7.6-10-6.3-16.1l24.3-121.7c2-9.9-5.6-19.1-15.7-19.1l-73 0c-5.9 0-11.3-3.2-14.1-8.5s-2.5-11.5 .8-16.4l7.6-11.4L6.4 204.8C2.4 201.8 0 197 0 192s2.4-9.8 6.4-12.8l19.9-14.9-7.6-11.4c-3.3-4.9-3.6-11.2-.8-16.4s8.2-8.5 14.1-8.5l101.5 0c-3.5-10-5.5-20.8-5.5-32c0-53 43-96 96-96s96 43 96 96zM208 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 32a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM192 480l0-52.2 12.2 6.9c12.3 7 27.4 7 39.7 0l12.2-6.9 0 52.2c0 17.7-14.3 32-32 32s-32-14.3-32-32z"]
}, faTruckMonster = {
  prefix: "fas",
  iconName: "truck-monster",
  icon: [640, 512, [], "f63b", "M288 64l0 64 128 0L368 64l-80 0zM419.2 25.6L496 128l80 0c17.7 0 32 14.3 32 32l0 64c17.7 0 32 14.3 32 32s-14.3 32-32 32c-29.2-38.9-75.7-64-128-64s-98.8 25.1-128 64l-64 0c-29.2-38.9-75.7-64-128-64s-98.8 25.1-128 64c-17.7 0-32-14.3-32-32s14.3-32 32-32l0-64c0-17.7 14.3-32 32-32l160 0 0-80c0-26.5 21.5-48 48-48l96 0c20.1 0 39.1 9.5 51.2 25.6zM152 256l16 0c12.1 0 22.1 8.9 23.8 20.6c7.6 2.2 14.9 5.3 21.7 9c9.4-7 22.8-6.3 31.3 2.3l11.3 11.3c8.6 8.6 9.3 21.9 2.3 31.3c3.7 6.8 6.8 14.1 9 21.7c11.6 1.7 20.6 11.7 20.6 23.8l0 16c0 12.1-8.9 22.1-20.6 23.8c-2.2 7.6-5.3 14.9-9 21.7c7 9.4 6.3 22.8-2.3 31.3l-11.3 11.3c-8.6 8.6-21.9 9.3-31.3 2.2c-6.8 3.7-14.1 6.8-21.7 9C190.1 503.1 180.1 512 168 512l-16 0c-12.1 0-22.1-8.9-23.8-20.6c-7.6-2.2-14.9-5.3-21.7-9c-9.4 7.1-22.8 6.3-31.3-2.2L63.8 468.9c-8.6-8.6-9.3-21.9-2.3-31.3c-3.7-6.9-6.8-14.1-9-21.8C40.9 414.1 32 404.1 32 392l0-16c0-12.1 8.9-22.1 20.6-23.8c2.2-7.6 5.3-14.9 9-21.8c-7-9.4-6.3-22.8 2.3-31.3l11.3-11.3c8.6-8.6 21.9-9.3 31.3-2.3c6.8-3.7 14.1-6.8 21.7-9c1.7-11.6 11.7-20.6 23.8-20.6zm8 176a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM448.2 276.6c1.7-11.6 11.7-20.6 23.8-20.6l16 0c12.1 0 22.1 8.9 23.8 20.6c7.6 2.2 14.9 5.3 21.8 9c9.4-7 22.8-6.3 31.3 2.3l11.3 11.3c8.6 8.6 9.3 21.9 2.2 31.3c3.7 6.8 6.8 14.1 9 21.7c11.6 1.7 20.6 11.7 20.6 23.8l0 16c0 12.1-8.9 22.1-20.6 23.8c-2.2 7.6-5.3 14.9-9 21.7c7 9.4 6.3 22.8-2.2 31.3l-11.3 11.3c-8.6 8.6-21.9 9.3-31.3 2.2c-6.9 3.7-14.1 6.8-21.8 9C510.1 503.1 500.1 512 488 512l-16 0c-12.1 0-22.1-8.9-23.8-20.6c-7.6-2.2-14.9-5.3-21.7-9c-9.4 7.1-22.8 6.3-31.3-2.2l-11.3-11.3c-8.6-8.6-9.3-21.9-2.2-31.3c-3.7-6.9-6.8-14.1-9-21.8C360.9 414.1 352 404.1 352 392l0-16c0-12.1 8.9-22.1 20.6-23.8c2.2-7.6 5.3-14.9 9-21.8c-7-9.4-6.3-22.8 2.2-31.3l11.3-11.3c8.6-8.6 21.9-9.3 31.3-2.3c6.8-3.7 14.1-6.8 21.7-9zM528 384a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]
}, faGiftCard = {
  prefix: "fas",
  iconName: "gift-card",
  icon: [576, 512, [], "f663", "M353.5 68.8C361.1 55.9 374.9 48 389.8 48l2.2 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-72 0-1.3 0 34.8-59.2zm-131 0L257.3 128l-1.3 0-72 0c-22.1 0-40-17.9-40-40s17.9-40 40-40l2.2 0c14.9 0 28.8 7.9 36.3 20.8zm89.6-24.3L288 85.5l-24.1-41C247.7 16.9 218.1 0 186.2 0L184 0C135.4 0 96 39.4 96 88c0 14.4 3.5 28 9.6 40L64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-41.6 0c6.1-12 9.6-25.6 9.6-40c0-48.6-39.4-88-88-88l-2.2 0c-31.9 0-61.5 16.9-77.7 44.4zM512 384l0 64L64 448l0-64 448 0zm0-64L64 320l0-128 166.1 0-40.5 48.6c-8.5 10.2-7.1 25.3 3.1 33.8s25.3 7.1 33.8-3.1L288 197.5l61.6 73.9c8.5 10.2 23.6 11.6 33.8 3.1s11.6-23.6 3.1-33.8L345.9 192 512 192l0 128z"]
}, faW = {
  prefix: "fas",
  iconName: "w",
  icon: [576, 512, [119], "57", "M20.8 34c16.5-6.2 35 2.2 41.2 18.7l110.2 294L257.3 55c4-13.7 16.5-23 30.7-23s26.7 9.4 30.7 23l85.1 291.7L514 52.8c6.2-16.5 24.6-24.9 41.2-18.7s24.9 24.7 18.7 41.2l-144 384c-4.8 12.9-17.4 21.3-31.2 20.7s-25.7-9.8-29.5-23L288 178.3 206.7 457c-3.9 13.2-15.8 22.5-29.5 23s-26.3-7.8-31.2-20.7L2 75.2C-4.2 58.7 4.2 40.2 20.8 34z"]
}, faCodePullRequestDraft = {
  prefix: "fas",
  iconName: "code-pull-request-draft",
  icon: [448, 512, [], "e3fa", "M56 80a24 24 0 1 1 48 0A24 24 0 1 1 56 80zm56 73.3c28.3-12.3 48-40.5 48-73.3c0-44.2-35.8-80-80-80S0 35.8 0 80c0 32.8 19.7 61 48 73.3l0 205.3C19.7 371 0 399.2 0 432c0 44.2 35.8 80 80 80s80-35.8 80-80c0-32.8-19.7-61-48-73.3l0-205.3zM56 432a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm312-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM416 80a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM368 288a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]
}, faSquareB = {
  prefix: "fas",
  iconName: "square-b",
  icon: [448, 512, [], "e264", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 120c0-13.3 10.7-24 24-24l92 0c42 0 76 34 76 76c0 16.2-5.1 31.3-13.8 43.7C324.3 261.6 336 283.4 336 308c0 42-34 76-76 76l-108 0c-13.3 0-24-10.7-24-24l0-104 0-104zm144 52c0-15.5-12.5-28-28-28l-68 0 0 56 68 0c15.5 0 28-12.5 28-28zM176 336l84 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-16 0-68 0 0 56z"]
}, faElephant = {
  prefix: "fas",
  iconName: "elephant",
  icon: [640, 512, [128024], "f6da", "M304 0C242.1 0 192 50.1 192 112s50.1 112 112 112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-79.5 0-144-64.5-144-144c0-25.3 6.5-49.1 18-69.8c-20.5 7-39.4 17.3-56.1 30.4C67.4 111.9 32 175.8 32 248l0 19c0 12.4-1.2 24.7-3.7 36.9c-1.9 9.3-5.8 18-11.4 25.6L4.8 345.6c-8 10.6-5.8 25.6 4.8 33.6s25.6 5.8 33.6-4.8l12.1-16.2c3.2-4.3 6.1-8.8 8.7-13.5L64 480c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-70c15.3 3.9 31.4 6 48 6s32.7-2.1 48-6l0 70c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-139.3c16.7 18.9 38.8 32.8 64 39.3l0 18.6c0 45 36.5 81.4 81.4 81.4c30.8 0 59-17.4 72.8-45l2.3-4.7c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3l-2.3 4.7c-3 5.9-9 9.6-15.6 9.6c-9.6 0-17.4-7.8-17.4-17.4l0-18.6c22.9-5.9 43.4-18 59.4-34.4c6.2-6.3 6.1-16.4-.2-22.6c-6.3-6.2-16.3-6.1-22.5 .1c-1.3 1.3-2.6 2.6-4 3.9c-1.5 1.4-3.1 2.7-4.6 4c-8.3 6.7-17.8 12-28 15.6c0 0 0 0 0 0c-10 3.5-20.8 5.5-32 5.5s-22-1.9-32-5.5c0 0 0 0 0 0c-7.5-2.6-14.6-6.2-21.1-10.5c0 0 0 0 0 0c-9.1-6.1-17.2-13.7-23.7-22.4c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2C472.5 310 491.1 320 512 320c11.7 0 22.6-3.1 32-8.6L544 192c0-88.4-71.6-160-160-160l-1.6 0C362.2 12.2 334.5 0 304 0zM464 192a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faEarthAfrica = {
  prefix: "fas",
  iconName: "earth-africa",
  icon: [512, 512, [127757, "globe-africa"], "f57c", "M177.8 63.2l10 17.4c2.8 4.8 4.2 10.3 4.2 15.9l0 41.4c0 3.9 1.6 7.7 4.3 10.4c6.2 6.2 16.5 5.7 22-1.2l13.6-17c4.7-5.9 12.9-7.7 19.6-4.3l15.2 7.6c3.4 1.7 7.2 2.6 11 2.6c6.5 0 12.8-2.6 17.4-7.2l3.9-3.9c2.9-2.9 7.3-3.6 11-1.8l29.2 14.6c7.8 3.9 12.6 11.8 12.6 20.5c0 10.5-7.1 19.6-17.3 22.2l-35.4 8.8c-7.4 1.8-15.1 1.5-22.4-.9l-32-10.7c-3.3-1.1-6.7-1.7-10.2-1.7c-7 0-13.8 2.3-19.4 6.5L176 212c-10.1 7.6-16 19.4-16 32l0 28c0 26.5 21.5 48 48 48l32 0c8.8 0 16 7.2 16 16l0 48c0 17.7 14.3 32 32 32c10.1 0 19.6-4.7 25.6-12.8l25.6-34.1c8.3-11.1 12.8-24.6 12.8-38.4l0-12.1c0-3.9 2.6-7.3 6.4-8.2l5.3-1.3c11.9-3 20.3-13.7 20.3-26c0-7.1-2.8-13.9-7.8-18.9l-33.5-33.5c-3.7-3.7-3.7-9.7 0-13.4c5.7-5.7 14.1-7.7 21.8-5.1l14.1 4.7c12.3 4.1 25.7-1.5 31.5-13c3.5-7 11.2-10.8 18.9-9.2l27.4 5.5C432 112.4 351.5 48 256 48c-27.7 0-54 5.4-78.2 15.2zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"]
}, faGlobeAfrica = faEarthAfrica, faRainbow = {
  prefix: "fas",
  iconName: "rainbow",
  icon: [640, 512, [127752], "f75b", "M320 96C178.6 96 64 210.6 64 352l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96C0 175.3 143.3 32 320 32s320 143.3 320 320l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96C576 210.6 461.4 96 320 96zm0 192c-35.3 0-64 28.7-64 64l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-70.7 57.3-128 128-128s128 57.3 128 128l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-35.3-28.7-64-64-64zM160 352l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-123.7 100.3-224 224-224s224 100.3 224 224l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-88.4-71.6-160-160-160s-160 71.6-160 160z"]
}, faCircleNotch = {
  prefix: "fas",
  iconName: "circle-notch",
  icon: [512, 512, [], "f1ce", "M222.7 32.1c5 16.9-4.6 34.8-21.5 39.8C121.8 95.6 64 169.1 64 256c0 106 86 192 192 192s192-86 192-192c0-86.9-57.8-160.4-137.1-184.1c-16.9-5-26.6-22.9-21.5-39.8s22.9-26.6 39.8-21.5C434.9 42.1 512 140 512 256c0 141.4-114.6 256-256 256S0 397.4 0 256C0 140 77.1 42.1 182.9 10.6c16.9-5 34.8 4.6 39.8 21.5z"]
}, faTabletScreenButton = {
  prefix: "fas",
  iconName: "tablet-screen-button",
  icon: [448, 512, ["tablet-alt"], "f3fa", "M0 64C0 28.7 28.7 0 64 0L384 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM256 448a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM384 64L64 64l0 320 320 0 0-320z"]
}, faTabletAlt = faTabletScreenButton, faPaw = {
  prefix: "fas",
  iconName: "paw",
  icon: [512, 512, [], "f1b0", "M226.5 92.9c14.3 42.9-.3 86.2-32.6 96.8s-70.1-15.6-84.4-58.5s.3-86.2 32.6-96.8s70.1 15.6 84.4 58.5zM100.4 198.6c18.9 32.4 14.3 70.1-10.2 84.1s-59.7-.9-78.5-33.3S-2.7 179.3 21.8 165.3s59.7 .9 78.5 33.3zM69.2 401.2C121.6 259.9 214.7 224 256 224s134.4 35.9 186.8 177.2c3.6 9.7 5.2 20.1 5.2 30.5l0 1.6c0 25.8-20.9 46.7-46.7 46.7c-11.5 0-22.9-1.4-34-4.2l-88-22c-15.3-3.8-31.3-3.8-46.6 0l-88 22c-11.1 2.8-22.5 4.2-34 4.2C84.9 480 64 459.1 64 433.3l0-1.6c0-10.4 1.6-20.8 5.2-30.5zM421.8 282.7c-24.5-14-29.1-51.7-10.2-84.1s54-47.3 78.5-33.3s29.1 51.7 10.2 84.1s-54 47.3-78.5 33.3zM310.1 189.7c-32.3-10.6-46.9-53.9-32.6-96.8s52.1-69.1 84.4-58.5s46.9 53.9 32.6 96.8s-52.1 69.1-84.4 58.5z"]
}, faMessageQuestion = {
  prefix: "fas",
  iconName: "message-question",
  icon: [512, 512, [], "e1e3", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zm169.8 53.3l-.4 1.2c-4.4 12.5 2.1 26.2 14.6 30.6s26.2-2.1 30.6-14.6l.4-1.2c1.1-3.2 4.2-5.3 7.5-5.3l58.3 0c8.4 0 15.1 6.8 15.1 15.1c0 5.4-2.9 10.4-7.6 13.1l-44.3 25.4c-7.5 4.3-12.1 12.2-12.1 20.8l0 13.5c0 13.3 10.7 24 24 24c13.1 0 23.8-10.5 24-23.6l32.3-18.5c19.6-11.3 31.7-32.2 31.7-54.8c0-34.9-28.3-63.1-63.1-63.1l-58.3 0c-23.7 0-44.8 14.9-52.8 37.3zM288 304a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faCloud = {
  prefix: "fas",
  iconName: "cloud",
  icon: [640, 512, [9729], "f0c2", "M0 336c0 79.5 64.5 144 144 144l368 0c70.7 0 128-57.3 128-128c0-61.9-44-113.6-102.4-125.4c4.1-10.7 6.4-22.4 6.4-34.6c0-53-43-96-96-96c-19.7 0-38.1 6-53.3 16.2C367 64.2 315.3 32 256 32C167.6 32 96 103.6 96 192c0 2.7 .1 5.4 .2 8.1C40.2 219.8 0 273.2 0 336z"]
}, faTrowelBricks = {
  prefix: "fas",
  iconName: "trowel-bricks",
  icon: [512, 512, [], "e58a", "M240.8 4.8C250.3 10.6 256 20.9 256 32l0 72 89 0c3.6-13.8 16.1-24 31-24l88 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-88 0c-14.9 0-27.4-10.2-31-24l-89 0 0 72c0 11.1-5.7 21.4-15.2 27.2s-21.2 6.4-31.1 1.4l-192-96C6.8 151.2 0 140.1 0 128s6.8-23.2 17.7-28.6l192-96c9.9-5 21.7-4.4 31.1 1.4zM288 256c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-64zM32 384l96 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zm192 0l256 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32z"]
}, faSquare3 = {
  prefix: "fas",
  iconName: "square-3",
  icon: [448, 512, [], "e258", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm88 96l128 0c9.9 0 18.8 6.1 22.4 15.3s1.1 19.7-6.2 26.4l-50.8 46.5c41.9 4.8 74.6 40.4 74.6 83.6c0 46.5-37.7 84.2-84.2 84.2L208 384c-30.1 0-58.1-15.6-73.9-41.2l-2.6-4.2c-7-11.3-3.5-26.1 7.8-33s26.1-3.5 33 7.8l2.6 4.2c7.1 11.5 19.6 18.4 33 18.4l27.8 0c20 0 36.2-16.2 36.2-36.2c0-20.1-16.3-36.3-36.4-36.2l-51.5 .3c-9.9 .1-18.9-6-22.5-15.2s-1.2-19.8 6.1-26.5L218.3 176 152 176c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faFaceFlushed = {
  prefix: "fas",
  iconName: "face-flushed",
  icon: [512, 512, [128563, "flushed"], "f579", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM176 384c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16zm-16-88a72 72 0 1 0 0-144 72 72 0 1 0 0 144zm264-72a72 72 0 1 0 -144 0 72 72 0 1 0 144 0zm-288 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm192 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faFlushed = faFaceFlushed, faHospitalUser = {
  prefix: "fas",
  iconName: "hospital-user",
  icon: [576, 512, [], "f80d", "M48 0C21.5 0 0 21.5 0 48L0 256l144 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L0 288l0 64 144 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L0 384l0 80c0 26.5 21.5 48 48 48l217.9 0c-6.3-10.2-9.9-22.2-9.9-35.1c0-46.9 25.8-87.8 64-109.2l0-95.9L320 48c0-26.5-21.5-48-48-48L48 0zM152 64l16 0c8.8 0 16 7.2 16 16l0 24 24 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-24 0 0 24c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-24-24 0c-8.8 0-16-7.2-16-16l0-16c0-8.8 7.2-16 16-16l24 0 0-24c0-8.8 7.2-16 16-16zM512 272a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM288 477.1c0 19.3 15.6 34.9 34.9 34.9l218.2 0c19.3 0 34.9-15.6 34.9-34.9c0-51.4-41.7-93.1-93.1-93.1l-101.8 0c-51.4 0-93.1 41.7-93.1 93.1z"]
}, faMicrowave = {
  prefix: "fas",
  iconName: "microwave",
  icon: [576, 512, [], "e01b", "M0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l-320 0c0 17.7-14.3 32-32 32s-32-14.3-32-32c-35.3 0-64-28.7-64-64L0 96zm96 56l0 176c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24l0-176c0-13.3-10.7-24-24-24l-272 0c-13.3 0-24 10.7-24 24zm400-40c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16z"]
}, faChfSign = {
  prefix: "fas",
  iconName: "chf-sign",
  icon: [640, 512, [], "e602", "M0 113.4C0 68.5 36.5 32 81.4 32c30.8 0 59 17.4 72.8 45l2.3 4.7c7.9 15.8 1.5 35-14.3 42.9s-35 1.5-42.9-14.3L97 105.6c-3-5.9-9-9.6-15.6-9.6C71.8 96 64 103.8 64 113.4l0 285.1c0 9.6 7.8 17.4 17.4 17.4c6.6 0 12.6-3.7 15.6-9.6l2.3-4.7c7.9-15.8 27.1-22.2 42.9-14.3s22.2 27.1 14.3 42.9l-2.3 4.7c-13.8 27.6-42 45-72.8 45C36.5 480 0 443.5 0 398.6L0 113.4zM224 32c17.7 0 32 14.3 32 32l0 160 96 0 0-160c0-17.7 14.3-32 32-32s32 14.3 32 32l0 384c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160-96 0 0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-384c0-17.7 14.3-32 32-32zM448 64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0 0 128 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0 0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-384z"]
}, faTentArrowLeftRight = {
  prefix: "fas",
  iconName: "tent-arrow-left-right",
  icon: [576, 512, [], "e57f", "M488.1 6.2c-9.9-8.9-25-8.1-33.9 1.8s-8.1 25 1.8 33.9L489.5 72 86.5 72l33.5-30.2c9.9-8.9 10.7-24 1.8-33.9S97.8-2.7 87.9 6.2l-80 72C2.9 82.7 0 89.2 0 96s2.9 13.3 7.9 17.8l80 72c9.9 8.9 25 8.1 33.9-1.8s8.1-25-1.8-33.9L86.5 120l402.9 0-33.5 30.2c-9.9 8.9-10.7 24-1.8 33.9s24 10.7 33.9 1.8l80-72c5.1-4.6 7.9-11 7.9-17.8s-2.9-13.3-7.9-17.8l-80-72zM307.4 166.5c-11.5-8.7-27.3-8.7-38.8 0l-168 128c-6.6 5-11 12.5-12.3 20.7l-24 160c-1.4 9.2 1.3 18.6 7.4 25.6S86.7 512 96 512l144 0 16 0c17.7 0 32-14.3 32-32l0-118.1c0-5.5 4.4-9.9 9.9-9.9c3.7 0 7.2 2.1 8.8 5.5l68.4 136.8c5.4 10.8 16.5 17.7 28.6 17.7l60.2 0 16 0c9.3 0 18.2-4.1 24.2-11.1s8.8-16.4 7.4-25.6l-24-160c-1.2-8.2-5.6-15.7-12.3-20.7l-168-128z"]
}, faCartCircleArrowUp = {
  prefix: "fas",
  iconName: "cart-circle-arrow-up",
  icon: [640, 512, [], "e3f0", "M0 24C0 10.7 10.7 0 24 0L69.5 0c22 0 41.5 12.8 50.6 32l411 0c26.3 0 45.5 25 38.6 50.4L538.8 197.2c-13.7-3.4-28.1-5.2-42.8-5.2c-68.4 0-127.7 39-156.8 96l-168.5 0 5.4 28.5c2.2 11.3 12.1 19.5 23.6 19.5l123.2 0c-1.9 10.4-2.9 21.1-2.9 32c0 5.4 .2 10.7 .7 16l-121 0c-34.6 0-64.3-24.6-70.7-58.5L77.4 54.5c-.7-3.8-4-6.5-7.9-6.5L24 48C10.7 48 0 37.3 0 24zM128 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm368 48a144 144 0 1 1 0-288 144 144 0 1 1 0 288zM428.7 371.3c6.2 6.2 16.4 6.2 22.6 0L480 342.6l0 89.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-89.4 28.7 28.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-56-56c-6.2-6.2-16.4-6.2-22.6 0l-56 56c-6.2 6.2-6.2 16.4 0 22.6z"]
}, faTrashClock = {
  prefix: "fas",
  iconName: "trash-clock",
  icon: [576, 512, [], "e2b0", "M135.2 17.7L128 32 32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0-7.2-14.3C307.4 6.8 296.3 0 284.2 0L163.8 0c-12.1 0-23.2 6.8-28.6 17.7zM416 128L32 128 53.2 467c1.6 25.3 22.6 45 47.9 45l229.7 0C285.6 480.1 256 427.5 256 368c0-90.4 68.2-164.9 155.9-174.9L416 128zM576 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM432 288c8.8 0 16 7.2 16 16l0 48 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16z"]
}, faReflectBoth = {
  prefix: "fas",
  iconName: "reflect-both",
  icon: [512, 512, [], "e66f", "M413.6 19.8C408.6 7.8 396.9 0 384 0L128 0c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l128 128c12.5 12.5 32.8 12.5 45.3 0l128-128c9.2-9.2 11.9-22.9 6.9-34.9zM19.8 98.4C7.8 103.4 0 115.1 0 128L0 384c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l128-128c12.5-12.5 12.5-32.8 0-45.3l-128-128c-9.2-9.2-22.9-11.9-34.9-6.9zM512 128c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-128 128c-12.5 12.5-12.5 32.8 0 45.3l128 128c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6l0-256zM413.6 492.2c5-12 2.2-25.7-6.9-34.9l-128-128c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l256 0c12.9 0 24.6-7.8 29.6-19.8z"]
}, faGavel = {
  prefix: "fas",
  iconName: "gavel",
  icon: [512, 512, ["legal"], "f0e3", "M318.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-120 120c-12.5 12.5-12.5 32.8 0 45.3l16 16c12.5 12.5 32.8 12.5 45.3 0l4-4L325.4 293.4l-4 4c-12.5 12.5-12.5 32.8 0 45.3l16 16c12.5 12.5 32.8 12.5 45.3 0l120-120c12.5-12.5 12.5-32.8 0-45.3l-16-16c-12.5-12.5-32.8-12.5-45.3 0l-4 4L330.6 74.6l4-4c12.5-12.5 12.5-32.8 0-45.3l-16-16zm-152 288c-12.5-12.5-32.8-12.5-45.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3l48 48c12.5 12.5 32.8 12.5 45.3 0l112-112c12.5-12.5 12.5-32.8 0-45.3l-1.4-1.4L272 285.3 226.7 240 168 298.7l-1.4-1.4z"]
}, faLegal = faGavel, faSprinklerCeiling = {
  prefix: "fas",
  iconName: "sprinkler-ceiling",
  icon: [384, 512, [], "e44c", "M0 0L0 96c0 15.3 10.8 28.4 25.7 31.4L128 147.8l0-65.3L64 69.8 64 0 0 0zM256 82.6l0 65.3 102.3-20.5c15-3 25.7-16.1 25.7-31.4l0-96L320 0l0 69.8L256 82.6zM160 344a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-48 64a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM24 496a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM272 344a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-80 88a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-32 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm136-40a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm88 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-128z"]
}, faBrowsers = {
  prefix: "fas",
  iconName: "browsers",
  icon: [576, 512, [], "e0cb", "M160 0C124.7 0 96 28.7 96 64l0 288c0 35.3 28.7 64 64 64l352 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L160 0zM280 72l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM224 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120L0 376c0 75.1 60.9 136 136 136l320 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-320 0c-48.6 0-88-39.4-88-88l0-256z"]
}, faTrillium = {
  prefix: "fas",
  iconName: "trillium",
  icon: [448, 512, [], "e588", "M128 160c0-64.1 61.6-128.2 86.1-151.1c5.6-5.3 14.1-5.3 19.8 0c24.5 23 86.1 87 86.1 151.1c0 15.7-3.7 30.4-10.4 43.5c16.2 0 32.6 4.2 47.7 12.9c55.5 32 80.2 117.4 87.8 150.2c1.8 7.5-2.5 14.9-9.9 17.1c-32.1 9.7-118.4 31.1-173.9-1c-16.6-9.6-29.2-23.3-37.4-39.2c-8.1 15.9-20.8 29.6-37.4 39.2c-55.5 32-141.8 10.7-173.9 1c-7.4-2.2-11.6-9.6-9.9-17.1c7.6-32.7 32.3-118.1 87.8-150.2c15.1-8.7 31.6-12.9 47.8-12.9C131.7 190.4 128 175.7 128 160zm136 80a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm88-80s0 0 0 0c0-12.5-1.8-24.8-4.8-36.6c38.6-12.8 68.2-11.9 83-10c14.9 1.9 23.7 17.1 17.9 31c-5.6 13.3-19 38.4-47.7 64.6c-8.1-7.7-17.1-14.6-27-20.3c0 0 0 0 0 0c-7.3-4.2-14.9-7.6-22.6-10.3c.9-6 1.3-12.1 1.3-18.4zM100.8 123.4c-3 11.8-4.8 24.1-4.8 36.6c0 6.2 .4 12.3 1.3 18.3c-7.8 2.7-15.4 6.1-22.7 10.3c0 0 0 0 0 0c-9.9 5.7-18.8 12.6-26.9 20.2C19 182.7 5.6 157.6 0 144.3c-5.8-13.8 3-29.1 17.9-31c14.7-1.9 44.4-2.8 83 10zm73.3 299.4c9.8-3.1 19.4-7.2 28.5-12.5c7.8-4.5 14.9-9.7 21.4-15.4c6.5 5.8 13.6 11 21.4 15.4c9.2 5.3 18.8 9.4 28.6 12.5c-8.2 36.1-22.6 61.6-31 74.2c-9.1 13.7-28.8 13.7-37.9 0c-8.3-12.6-22.8-38.2-31-74.3z"]
}, faTableCellsUnlock = {
  prefix: "fas",
  iconName: "table-cells-unlock",
  icon: [640, 512, [], "e692", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0 0-64-24 0 0-64 24 0c0-23.7 12.9-44.4 32-55.4l0-8.6-56 0 0-64 66.8 0c15.8-33.2 47.5-57.5 85.2-62.9L512 96c0-35.3-28.7-64-64-64L64 32zm88 64l0 64-88 0 0-64 88 0zm56 0l88 0 0 64-88 0 0-64zm240 0l0 64-88 0 0-64 88 0zM64 224l88 0 0 64-88 0 0-64zm232 0l0 64-88 0 0-64 88 0zM152 352l0 64-88 0 0-64 88 0zm56 0l88 0 0 64-88 0 0-64zm288-80c0-17.7 14.3-32 32-32s32 14.3 32 32l48 0c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 48c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l-48 0-32 0-32 0 0-48z"]
}, faMusicSlash = {
  prefix: "fas",
  iconName: "music-slash",
  icon: [640, 512, [], "f8d1", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-71.5-56C569.8 400.2 576 384.7 576 368l0-264 0-72c0-10.1-4.8-19.6-12.9-25.7s-18.6-7.9-28.3-5l-320 96c-12.7 3.8-21.6 14.9-22.7 27.9L38.8 5.1zM300.7 210.4L512 147l0 145.5c-10-2.9-20.8-4.6-32-4.6c-22.2 0-42.6 6.3-58.8 16.8L300.7 210.4zM192 247.3l0 109.3c-10-3-20.8-4.6-32-4.6c-53 0-96 35.8-96 80s43 80 96 80s96-35.8 96-80l0-134.3-64-50.4z"]
}, faTruckRamp = {
  prefix: "fas",
  iconName: "truck-ramp",
  icon: [640, 512, [], "f4e0", "M640 400L640 0 416 0c-35.3 0-64 28.7-64 64l0 289.8L31.6 441.1c-17.1 4.6-27.1 22.2-22.5 39.3s22.2 27.1 39.3 22.5L416 402.7C417.5 463.3 467 512 528 512c61.9 0 112-50.1 112-112zM528 352a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]
}, faBinoculars = {
  prefix: "fas",
  iconName: "binoculars",
  icon: [512, 512, [], "f1e5", "M128 32l32 0c17.7 0 32 14.3 32 32l0 32L96 96l0-32c0-17.7 14.3-32 32-32zm64 96l0 320c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32l0-59.1c0-34.6 9.4-68.6 27.2-98.3C40.9 267.8 49.7 242.4 53 216L60.5 156c2-16 15.6-28 31.8-28l99.8 0zm227.8 0c16.1 0 29.8 12 31.8 28L459 216c3.3 26.4 12.1 51.8 25.8 74.6c17.8 29.7 27.2 63.7 27.2 98.3l0 59.1c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-320 99.8 0zM320 64c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 32-96 0 0-32zm-32 64l0 160-64 0 0-160 64 0z"]
}, faMicrophoneSlash = {
  prefix: "fas",
  iconName: "microphone-slash",
  icon: [640, 512, [], "f131", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L472.1 344.7c15.2-26 23.9-56.3 23.9-88.7l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 21.2-5.1 41.1-14.2 58.7L416 300.8 416 96c0-53-43-96-96-96s-96 43-96 96l0 54.3L38.8 5.1zM344 430.4c20.4-2.8 39.7-9.1 57.3-18.2l-43.1-33.9C346.1 382 333.3 384 320 384c-70.7 0-128-57.3-128-128l0-8.7L144.7 210c-.5 1.9-.7 3.9-.7 6l0 40c0 89.1 66.2 162.7 152 174.4l0 33.6-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-33.6z"]
}, faBoxTissue = {
  prefix: "fas",
  iconName: "box-tissue",
  icon: [512, 512, [], "e05b", "M92.5 0L208 0c40 0 52 24 64 48s24 48 64 48l85.2 0C436 96 448 108 448 122.8c0 3.4-.7 6.8-1.9 10L409.6 224 384 288l-256 0-16-64L64.9 35.4c-.6-2.3-.9-4.6-.9-6.9C64 12.8 76.8 0 92.5 0zM79 224l16 64-15 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 256 0 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-13.5 0 25.6-64 19.9 0c26.5 0 48 21.5 48 48l0 112L0 384 0 272c0-26.5 21.5-48 48-48l31 0zM0 416l512 0 0 48c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48l0-48z"]
}, faCircleC = {
  prefix: "fas",
  iconName: "circle-c",
  icon: [512, 512, [], "e101", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM199.4 312.6c31.2 31.2 81.9 31.2 113.1 0c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-50 50-131 50-181 0s-50-131 0-181s131-50 181 0c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0c-31.2-31.2-81.9-31.2-113.1 0s-31.2 81.9 0 113.1z"]
}, faStarChristmas = {
  prefix: "fas",
  iconName: "star-christmas",
  icon: [512, 512, [], "f7d4", "M15.5 275.9L192 320l44.1 176.5c2.3 9.1 10.5 15.5 19.9 15.5s17.6-6.4 19.9-15.5L320 320l176.5-44.1c9.1-2.3 15.5-10.5 15.5-19.9s-6.4-17.6-15.5-19.9L320 192 275.9 15.5C273.6 6.4 265.4 0 256 0s-17.6 6.4-19.9 15.5L192 192 15.5 236.1C6.4 238.4 0 246.6 0 256s6.4 17.6 15.5 19.9zM71 71c-9.4 9.4-9.4 24.6 0 33.9l48 48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L105 71c-9.4-9.4-24.6-9.4-33.9 0zM441 71c-9.4-9.4-24.6-9.4-33.9 0l-48 48c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l48-48c9.4-9.4 9.4-24.6 0-33.9zm0 336l-48-48c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l48 48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9zM71 441c9.4 9.4 24.6 9.4 33.9 0l48-48c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L71 407c-9.4 9.4-9.4 24.6 0 33.9z"]
}, faChartBullet = {
  prefix: "fas",
  iconName: "chart-bullet",
  icon: [512, 512, [], "e0e1", "M264 32c13.3 0 24 10.7 24 24l0 8 176 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-176 0 0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8L48 224c-26.5 0-48-21.5-48-48l0-64C0 85.5 21.5 64 48 64l192 0 0-8c0-13.3 10.7-24 24-24zM160 128l0 32 80 0 0-32-80 0zm128 0l0 32 160 0 0-32-160 0zm48 256l0-32-80 0 0 32 80 0zm0 64L48 448c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l288 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 80 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-80 0 0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8zm48-96l0 32 64 0 0-32-64 0z"]
}, faMotorcycle = {
  prefix: "fas",
  iconName: "motorcycle",
  icon: [640, 512, [127949], "f21c", "M280 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l57.7 0 16.4 30.3L256 192l-45.3-45.3c-12-12-28.3-18.7-45.3-18.7L64 128c-17.7 0-32 14.3-32 32l0 32 96 0c88.4 0 160 71.6 160 160c0 11-1.1 21.7-3.2 32l70.4 0c-2.1-10.3-3.2-21-3.2-32c0-52.2 25-98.6 63.7-127.8l15.4 28.6C402.4 276.3 384 312 384 352c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-13.5 0-26.5 2.1-38.7 6L418.2 128l61.8 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-20.4 0c-7.5 0-14.7 2.6-20.5 7.4L391.7 78.9l-14-26c-7-12.9-20.5-21-35.2-21L280 32zM462.7 311.2l28.2 52.2c6.3 11.7 20.9 16 32.5 9.7s16-20.9 9.7-32.5l-28.2-52.2c2.3-.3 4.7-.4 7.1-.4c35.3 0 64 28.7 64 64s-28.7 64-64 64s-64-28.7-64-64c0-15.5 5.5-29.7 14.7-40.8zM187.3 376c-9.5 23.5-32.5 40-59.3 40c-35.3 0-64-28.7-64-64s28.7-64 64-64c26.9 0 49.9 16.5 59.3 40l66.4 0C242.5 268.8 190.5 224 128 224C57.3 224 0 281.3 0 352s57.3 128 128 128c62.5 0 114.5-44.8 125.8-104l-66.4 0zM128 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faTreeChristmas = {
  prefix: "fas",
  iconName: "tree-christmas",
  icon: [448, 512, [127876], "f7db", "M150.2 71l47.1-17.7L215 6.2c1.4-3.8 5-6.2 9-6.2s7.6 2.5 9 6.2l17.7 47.1L297.8 71c3.8 1.4 6.2 5 6.2 9s-2.5 7.6-6.2 9l-47.1 17.7L233 153.8c-1.4 3.8-5 6.2-9 6.2s-7.6-2.5-9-6.2l-17.7-47.1L150.2 89c-3.8-1.4-6.2-5-6.2-9s2.5-7.6 6.2-9zM263 165l11.8-31.5 144 180c3.4 4.2 5.2 9.4 5.2 14.8c0 13.1-10.6 23.7-23.7 23.7L368 352l76.2 122c2.5 4 3.8 8.5 3.8 13.2c0 13.7-11.1 24.9-24.9 24.9L24.9 512C11.1 512 0 500.9 0 487.1c0-4.7 1.3-9.2 3.8-13.2L80 352l-32.3 0C34.6 352 24 341.4 24 328.3c0-5.4 1.8-10.6 5.2-14.8l144-180L185 165c6.1 16.2 21.6 27 39 27s32.9-10.8 39-27zM184 288a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM288 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faTireFlat = {
  prefix: "fas",
  iconName: "tire-flat",
  icon: [512, 512, [], "f632", "M256 32C114.6 32 0 146.6 0 288c0 47.3 12.8 91.7 35.2 129.7C14.9 423.3 0 441.9 0 464c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48c0-22.1-14.9-40.7-35.2-46.3c22.4-38 35.2-82.4 35.2-129.7C512 146.6 397.4 32 256 32zm96 384c-2.1 1.6-4.3 3.2-6.6 4.7C319.9 437.9 289.1 448 256 448c-36 0-69.3-11.9-96-32c-38.9-29.2-64-75.7-64-128c0-88.4 71.6-160 160-160s160 71.6 160 160c0 52.3-25.1 98.8-64 128zm-96-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm16 95c44.3-5.5 81.5-33.6 99.8-72.4l-61.9-20.1c-8.6 13.5-22.1 23.5-38 27.6l0 65zM381.7 312.2c1.5-7.8 2.3-15.9 2.3-24.2c0-36.8-15.5-69.9-40.3-93.3l-38.2 52.6c9.1 11 14.5 25.2 14.5 40.6c0 1.4 0 2.7-.1 4l61.8 20.1zM256 224c8.3 0 16.3 1.6 23.6 4.5l38.2-52.6C299.5 165.8 278.4 160 256 160s-43.5 5.8-61.8 15.9l28.1 38.8 10 13.8c7.3-2.9 15.3-4.5 23.6-4.5zM128 288c0 8.3 .8 16.3 2.3 24.2L192.1 292c-.1-1.3-.1-2.7-.1-4c0-15.4 5.5-29.6 14.5-40.6l-10.1-13.9-28.1-38.7C143.5 218.1 128 251.2 128 288zm12.2 54.6c18.3 38.8 55.5 66.9 99.8 72.4l0-65c-15.8-4.1-29.3-14.1-37.9-27.5l-61.9 20.1z"]
}, faSunglasses = {
  prefix: "fas",
  iconName: "sunglasses",
  icon: [576, 512, [128374], "f892", "M118.6 80c-11.5 0-21.4 7.9-24 19.1L57 260.3c20.5-6.2 48.3-12.3 78.7-12.3c32.3 0 61.8 6.9 82.8 13.5c10.6 3.3 19.3 6.7 25.4 9.2c3.1 1.3 5.5 2.4 7.3 3.2c.9 .4 1.6 .7 2.1 1l.6 .3 .2 .1c0 0 .1 0 .1 0c0 0 0 0 0 0s0 0 0 0L247.9 288s0 0 0 0l6.3-12.7c5.8 2.9 10.4 7.3 13.5 12.7l40.6 0c3.1-5.3 7.7-9.8 13.5-12.7l6.3 12.7s0 0 0 0c-6.3-12.7-6.3-12.7-6.3-12.7s0 0 0 0s0 0 0 0c0 0 .1 0 .1 0l.2-.1 .6-.3c.5-.2 1.2-.6 2.1-1c1.8-.8 4.2-1.9 7.3-3.2c6.1-2.6 14.8-5.9 25.4-9.2c21-6.6 50.4-13.5 82.8-13.5c30.4 0 58.2 6.1 78.7 12.3L481.4 99.1c-2.6-11.2-12.6-19.1-24-19.1c-3.1 0-6.2 .6-9.2 1.8L416.9 94.3c-12.3 4.9-26.3-1.1-31.2-13.4s1.1-26.3 13.4-31.2l31.3-12.5c8.6-3.4 17.7-5.2 27-5.2c33.8 0 63.1 23.3 70.8 56.2l43.9 188c1.7 7.3 2.9 14.7 3.5 22.1c.3 1.9 .5 3.8 .5 5.7l0 6.7 0 41.3 0 16c0 61.9-50.1 112-112 112l-44.3 0c-59.4 0-108.5-46.4-111.8-105.8L306.6 352l-37.2 0-1.2 22.2C264.9 433.6 215.8 480 156.3 480L112 480C50.1 480 0 429.9 0 368l0-16 0-41.3L0 304c0-1.9 .2-3.8 .5-5.7c.6-7.4 1.8-14.8 3.5-22.1l43.9-188C55.5 55.3 84.8 32 118.6 32c9.2 0 18.4 1.8 27 5.2l31.3 12.5c12.3 4.9 18.3 18.9 13.4 31.2s-18.9 18.3-31.2 13.4L127.8 81.8c-2.9-1.2-6-1.8-9.2-1.8zM64 325.4L64 368l105.6-52.8c-10.7-1.9-22.2-3.2-33.9-3.2c-23.7 0-46.2 5.1-63.2 10.5c-3.1 1-5.9 1.9-8.5 2.9zm409.8-10.3c-10.5-1.9-21.9-3.1-33.4-3.1c-23.7 0-46.4 5.1-63.6 10.5c-2.7 .8-5.2 1.7-7.5 2.5l2.3 41.2 102.3-51.1z"]
}, faBadge = {
  prefix: "fas",
  iconName: "badge",
  icon: [512, 512, [], "f335", "M340.9 51.1C324.8 20.7 292.8 0 256 0s-68.8 20.7-84.9 51.1C138.2 41 101 49 75 75s-34 63.3-23.9 96.1C20.7 187.2 0 219.2 0 256s20.7 68.8 51.1 84.9C41 373.8 49 411 75 437s63.3 34 96.1 23.9C187.2 491.3 219.2 512 256 512s68.8-20.7 84.9-51.1C373.8 471 411 463 437 437s34-63.3 23.9-96.1C491.3 324.8 512 292.8 512 256s-20.7-68.8-51.1-84.9C471 138.2 463 101 437 75s-63.3-34-96.1-23.9z"]
}, faMessagePen = {
  prefix: "fas",
  iconName: "message-pen",
  icon: [512, 512, ["comment-alt-edit", "message-edit"], "f4a4", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zm340.8 59c-14.7-14.7-38.6-14.7-53.3 0L272.6 138l53.3 53.3 14.9-14.9c14.7-14.7 14.7-38.6 0-53.3zM178.1 232.5c-4.1 4.1-7 9.2-8.4 14.9L160.5 284c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4l71.9-71.9L250 160.6l-71.9 71.9z"]
}, faCommentAltEdit = faMessagePen, faMessageEdit = faMessagePen, faBellConcierge = {
  prefix: "fas",
  iconName: "bell-concierge",
  icon: [512, 512, [128718, "concierge-bell"], "f562", "M216 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0 0 33.3C119.6 157.2 32 252.4 32 368l448 0c0-115.6-87.6-210.8-200-222.7l0-33.3 16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0-40 0zM24 400c-13.3 0-24 10.7-24 24s10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 400z"]
}, faConciergeBell = faBellConcierge, faPenRuler = {
  prefix: "fas",
  iconName: "pen-ruler",
  icon: [512, 512, ["pencil-ruler"], "f5ae", "M469.3 19.3l23.4 23.4c25 25 25 65.5 0 90.5l-56.4 56.4L322.3 75.7l56.4-56.4c25-25 65.5-25 90.5 0zM44.9 353.2L299.7 98.3 413.7 212.3 158.8 467.1c-6.7 6.7-15.1 11.6-24.2 14.2l-104 29.7c-8.4 2.4-17.4 .1-23.6-6.1s-8.5-15.2-6.1-23.6l29.7-104c2.6-9.2 7.5-17.5 14.2-24.2zM249.4 103.4L103.4 249.4 16 161.9c-18.7-18.7-18.7-49.1 0-67.9L94.1 16c18.7-18.7 49.1-18.7 67.9 0l19.8 19.8c-.3 .3-.7 .6-1 .9l-64 64c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l64-64c.3-.3 .6-.7 .9-1l45.1 45.1zM408.6 262.6l45.1 45.1c-.3 .3-.7 .6-1 .9l-64 64c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l64-64c.3-.3 .6-.7 .9-1L496 350.1c18.7 18.7 18.7 49.1 0 67.9L417.9 496c-18.7 18.7-49.1 18.7-67.9 0l-87.4-87.4L408.6 262.6z"]
}, faPencilRuler = faPenRuler, faFileMp3 = {
  prefix: "fas",
  iconName: "file-mp3",
  icon: [512, 512, [], "e648", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-240 0c-35.3 0-64 28.7-64 64l0 144-16 0c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zM139.7 352.6c6.9-1.9 14.3 1 18 7.2L192 416.9l34.3-57.1c3.7-6.2 11.1-9.1 18-7.2s11.7 8.2 11.7 15.4l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-70.2-18.3 30.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8L160 425.8l0 70.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-7.2 4.8-13.5 11.7-15.4zM288 368c0-8.8 7.2-16 16-16l32 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-16 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48 0-80zm32 64l16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0 48zm144 80l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-24 0c-8.8 0-16-7.2-16-16c0-.6 0-1.1 .1-1.6c.8-8.1 7.6-14.4 15.9-14.4l24 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0c26.5 0 48 21.5 48 48c0 12.3-4.6 23.5-12.2 32c7.6 8.5 12.2 19.7 12.2 32c0 26.5-21.5 48-48 48z"]
}, faArrowProgress = {
  prefix: "fas",
  iconName: "arrow-progress",
  icon: [512, 512, [], "e5df", "M448 128A64 64 0 1 0 448 0a64 64 0 1 0 0 128zM128 32C57.3 32 0 89.3 0 160s57.3 128 128 128l256 0c35.3 0 64 28.7 64 64c0 27.9-17.9 51.7-42.8 60.4c-11.5-17.1-31-28.4-53.2-28.4c-35.3 0-64 28.7-64 64s28.7 64 64 64c24.7 0 46.1-14 56.8-34.4C467.6 466.1 512 414.2 512 352c0-70.7-57.3-128-128-128l-256 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l128 0 0 14.1c0 9.9 8 17.9 17.9 17.9c4 0 7.8-1.3 11-3.8l60.8-47.3c4-3.1 6.3-7.9 6.3-12.9s-2.3-9.8-6.3-12.9L284.8 3.8c-3.1-2.4-7-3.8-11-3.8C264 0 256 8 256 17.9L256 32 128 32zm-8.6 384c-11.1-19.1-31.7-32-55.4-32c-35.3 0-64 28.7-64 64s28.7 64 64 64c23.7 0 44.4-12.9 55.4-32l40.6 0 0 14.1c0 9.9 8 17.9 17.9 17.9c4 0 7.8-1.3 11-3.8l60.8-47.3c4-3.1 6.3-7.9 6.3-12.9s-2.3-9.8-6.3-12.9l-60.8-47.3c-3.1-2.4-7-3.8-11-3.8c-9.9 0-17.9 8-17.9 17.9l0 14.1-40.6 0z"]
}, faChessRookPiece = {
  prefix: "fas",
  iconName: "chess-rook-piece",
  icon: [320, 512, ["chess-rook-alt"], "f448", "M67.4 384L80 264 49.4 233.4c-6-6-9.4-14.1-9.4-22.6L40 112c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 24c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-24c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 24c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-24c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 98.7c0 8.5-3.4 16.6-9.4 22.6L240 264l12.6 120L67.4 384zM136 280.9c0 3.9 3.2 7.1 7.1 7.1l33.8 0c3.9 0 7.1-3.2 7.1-7.1l0-32.9c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32.9zM20.8 473.6L64 416l192 0 43.2 57.6c3.1 4.2 4.8 9.2 4.8 14.4c0 13.3-10.7 24-24 24L40 512c-13.3 0-24-10.7-24-24c0-5.2 1.7-10.2 4.8-14.4z"]
}, faChessRookAlt = faChessRookPiece, faSquareRoot = {
  prefix: "fas",
  iconName: "square-root",
  icon: [576, 512, [8730], "f697", "M282.6 78.1c8-27.3 33-46.1 61.4-46.1l200 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L344 96 238.7 457c-3.6 12.3-14.1 21.2-26.8 22.8s-25.1-4.6-31.5-15.6L77.6 288 32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l45.6 0c22.8 0 43.8 12.1 55.3 31.8l65.2 111.8L282.6 78.1z"]
}, faAlbumCollectionCirclePlus = {
  prefix: "fas",
  iconName: "album-collection-circle-plus",
  icon: [640, 512, [], "e48e", "M32 24c0 13.3 10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L56 0C42.7 0 32 10.7 32 24zM48 160c-13.8 0-26.9 5.9-36 16.2S-1.3 200.3 .4 214l32 256c3 24 23.4 42 47.6 42l314.8 0c-18.9-13.3-35.1-30.3-47.5-49.9c-26.9 11.4-58 17.9-91.3 17.9C154.4 480 72 419.1 72 344s82.4-136 184-136c45.4 0 86.9 12.1 119 32.2c31.5-29.9 74.2-48.2 121-48.2c4.5 0 9 .2 13.4 .5c-2-5.9-5.2-11.5-9.4-16.3c-9.1-10.3-22.2-16.2-36-16.2L48 160zM256 376c17.7 0 32-10.7 32-24s-14.3-24-32-24s-32 10.7-32 24s14.3 24 32 24zM40 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l432 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L40 80zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16z"]
}, faPeopleArrows = {
  prefix: "fas",
  iconName: "people-arrows",
  icon: [640, 512, ["people-arrows-left-right"], "e068", "M64 64a64 64 0 1 1 128 0A64 64 0 1 1 64 64zM25.9 233.4C29.3 191.9 64 160 105.6 160l44.8 0c27 0 51 13.4 65.5 34.1c-2.7 1.9-5.2 4-7.5 6.3l-64 64c-21.9 21.9-21.9 57.3 0 79.2L192 391.2l0 72.8c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-115.7c-26.5-9.5-44.7-35.8-42.2-65.6l4.1-49.3zM448 64a64 64 0 1 1 128 0A64 64 0 1 1 448 64zM431.6 200.4c-2.3-2.3-4.9-4.4-7.5-6.3c14.5-20.7 38.6-34.1 65.5-34.1l44.8 0c41.6 0 76.3 31.9 79.7 73.4l4.1 49.3c2.5 29.8-15.7 56.1-42.2 65.6L576 464c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-72.8 47.6-47.6c21.9-21.9 21.9-57.3 0-79.2l-64-64zM272 240l0 32 96 0 0-32c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l64 64c9.4 9.4 9.4 24.6 0 33.9l-64 64c-6.9 6.9-17.2 8.9-26.2 5.2s-14.8-12.5-14.8-22.2l0-32-96 0 0 32c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-64-64c-9.4-9.4-9.4-24.6 0-33.9l64-64c6.9-6.9 17.2-8.9 26.2-5.2s14.8 12.5 14.8 22.2z"]
}, faPeopleArrowsLeftRight = faPeopleArrows, faSignPost = {
  prefix: "fas",
  iconName: "sign-post",
  icon: [512, 512, [], "e624", "M224 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 129 0c9.5 0 18.5 4.2 24.6 11.5l61.9 74.2c4.9 5.9 4.9 14.6 0 20.5l-61.9 74.2c-6.1 7.3-15.1 11.5-24.6 11.5L80 256c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48l144 0 0-32zm64 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-192 64 0 0 192z"]
}, faFaceAngryHorns = {
  prefix: "fas",
  iconName: "face-angry-horns",
  icon: [640, 512, [], "e368", "M576 256c0 141.4-114.6 256-256 256S64 397.4 64 256c0-24.6 3.5-48.4 9.9-70.9C29.6 125.8 6.5 50.1 .3 19.1C-1 12.8 1.7 6.3 7.1 2.7s12.4-3.6 17.8 0c19.3 12.9 48.5 24.2 78.4 33.1c23.3 7 46 12.2 63 15.5C209.1 19.1 262.3 0 320 0s110.9 19.1 153.8 51.3c17-3.3 39.7-8.6 63-15.5c29.8-8.9 59.1-20.2 78.4-33.1c5.4-3.6 12.4-3.6 17.8 0s8.1 10.1 6.8 16.4c-6.2 31-29.3 106.6-73.6 166c6.5 22.5 9.9 46.3 9.9 70.9zM402.7 411.9c6.6-5.9 7.1-16 1.2-22.6C387.8 371.4 359.7 352 320 352s-67.8 19.4-83.9 37.3c-5.9 6.6-5.4 16.7 1.2 22.6s16.7 5.4 22.6-1.2c11.7-13 31.6-26.7 60.1-26.7s48.4 13.7 60.1 26.7c5.9 6.6 16 7.1 22.6 1.2zM240.4 296c13.3 0 24-10.7 24-24c0-2.6-.4-5.1-1.2-7.4l19.7 6.6c8.4 2.8 17.4-1.7 20.2-10.1s-1.7-17.4-10.1-20.2l-96-32c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2l39.6 13.2c-6.2 4.3-10.2 11.5-10.2 19.6c0 13.3 10.7 24 24 24zm184-24c0-8.2-4.1-15.5-10.4-19.8l39.1-13c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-96 32c-8.4 2.8-12.9 11.9-10.1 20.2s11.9 12.9 20.2 10.1l20.6-6.9c-.8 2.4-1.3 5-1.3 7.7c0 13.3 10.7 24 24 24s24-10.7 24-24z"]
}, faMarsAndVenusBurst = {
  prefix: "fas",
  iconName: "mars-and-venus-burst",
  icon: [640, 512, [], "e523", "M504 0c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l39 39-22.2 22.2C475.9 78.4 439.6 64 400 64c-88.4 0-160 71.6-160 160c0 80.2 59.1 146.7 136.1 158.2c0 .6-.1 1.2-.1 1.8l0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .4 0 .3 0 .4 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3 0 .3-24 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l24 0 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .2 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1 0 .1c0 0 0 .1 0 .1s0 .1 0 .1l0 .1c0 0 0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 .1 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 .1s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0l24 0-24 0c0 13.3 10.7 24 24 24s24-10.7 24-24l-24 0 24 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0 0 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1s0-.1 0-.1l0-.1c0 0 0-.1 0-.1s0-.1 0-.1l0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.1 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 0-.2 24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-24 0 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.3 0-.4 0-.3 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4 0-.4c0-.6 0-1.2-.1-1.8c77-11.6 136.1-78 136.1-158.2c0-31.4-9-60.7-24.7-85.4L560 113.9l39 39c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-112c0-13.3-10.7-24-24-24L504 0zM400 128a96 96 0 1 1 0 192 96 96 0 1 1 0-192zM190.9 18.1C188.4 12 182.6 8 176 8s-12.4 4-14.9 10.1l-29.4 74L55.6 68.9c-6.3-1.9-13.1 .2-17.2 5.3s-4.6 12.2-1.4 17.9l39.5 69.1L10.9 206.4c-5.4 3.7-8 10.3-6.5 16.7s6.7 11.2 13.1 12.2l78.7 12.2L90.6 327c-.5 6.5 3.1 12.7 9 15.5s12.9 1.8 17.8-2.6L176 286.1l58.6 53.9c4.1 3.8 9.9 5.1 15.2 3.6C223.6 310.8 208 269.2 208 224c0-60.8 28.3-115 72.4-150.2L220.3 92.1l-29.4-74z"]
}, faTombstone = {
  prefix: "fas",
  iconName: "tombstone",
  icon: [448, 512, [], "f720", "M32 192C32 86 118 0 224 0S416 86 416 192l0 224L32 416l0-224zM0 480c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32zM248 120c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 120c0 13.3 10.7 24 24 24s24-10.7 24-24l0-120 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-40z"]
}, faSquareCaretRight = {
  prefix: "fas",
  iconName: "square-caret-right",
  icon: [448, 512, ["caret-square-right"], "f152", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM320 256c0 6.7-2.8 13-7.7 17.6l-112 104c-7 6.5-17.2 8.2-25.9 4.4s-14.4-12.5-14.4-22l0-208c0-9.5 5.7-18.2 14.4-22s18.9-2.1 25.9 4.4l112 104c4.9 4.5 7.7 10.9 7.7 17.6z"]
}, faCaretSquareRight = faSquareCaretRight, faScissors = {
  prefix: "fas",
  iconName: "scissors",
  icon: [512, 512, [9984, 9986, 9988, "cut"], "f0c4", "M256 192l-39.5-39.5c4.9-12.6 7.5-26.2 7.5-40.5C224 50.1 173.9 0 112 0S0 50.1 0 112s50.1 112 112 112c14.3 0 27.9-2.7 40.5-7.5L192 256l-39.5 39.5c-12.6-4.9-26.2-7.5-40.5-7.5C50.1 288 0 338.1 0 400s50.1 112 112 112s112-50.1 112-112c0-14.3-2.7-27.9-7.5-40.5L499.2 76.8c7.1-7.1 7.1-18.5 0-25.6c-28.3-28.3-74.1-28.3-102.4 0L256 192zm22.6 150.6L396.8 460.8c28.3 28.3 74.1 28.3 102.4 0c7.1-7.1 7.1-18.5 0-25.6L342.6 278.6l-64 64zM64 112a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm48 240a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]
}, faCut = faScissors, faListMusic = {
  prefix: "fas",
  iconName: "list-music",
  icon: [512, 512, [], "f8c9", "M498.7 6c8.3 6 13.3 15.7 13.3 26l0 64c0 13.8-8.8 26-21.9 30.4L416 151.1 416 432c0 44.2-50.1 80-112 80s-112-35.8-112-80s50.1-80 112-80c17.2 0 33.5 2.8 48 7.7L352 128l0-64c0-13.8 8.8-26 21.9-30.4l96-32C479.6-1.6 490.4 0 498.7 6zM32 64l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 128C14.3 128 0 113.7 0 96S14.3 64 32 64zm0 128l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 256c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 128l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faSunPlantWilt = {
  prefix: "fas",
  iconName: "sun-plant-wilt",
  icon: [640, 512, [], "e57a", "M160 0c-6.3 0-12 3.7-14.6 9.5L120.6 64.9 63.9 43.2c-5.9-2.3-12.6-.8-17 3.6s-5.9 11.1-3.6 17l21.7 56.7L9.5 145.4C3.7 148 0 153.7 0 160s3.7 12 9.5 14.6l55.4 24.8L43.2 256.1c-2.3 5.9-.8 12.6 3.6 17s11.1 5.9 17 3.6l56.7-21.7 24.8 55.4c2.6 5.8 8.3 9.5 14.6 9.5s12-3.7 14.6-9.5l24.8-55.4 56.7 21.7c5.9 2.3 12.6 .8 17-3.6s5.9-11.1 3.6-17l-21.7-56.7 55.4-24.8c5.8-2.6 9.5-8.3 9.5-14.6s-3.7-12-9.5-14.6l-55.4-24.8 21.7-56.7c2.3-5.9 .8-12.6-3.6-17s-11.1-5.9-17-3.6L199.4 64.9 174.6 9.5C172 3.7 166.3 0 160 0zm0 96a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm32 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm312 16c0-17.7 14.3-32 32-32s32 14.3 32 32l0 53.4c-14.8 7.7-24 23.1-24 44.6c0 16.8 16 44 37.4 67.2c5.8 6.2 15.5 6.2 21.2 0C624 318 640 290.7 640 274c0-21.5-9.2-37-24-44.6l0-53.4c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 22.7c-9.8-4.3-20.6-6.7-32-6.7c-44.2 0-80 35.8-80 80l0 21.4c-14.8 7.7-24 23.1-24 44.6c0 16.8 16 44 37.4 67.2c5.8 6.2 15.5 6.2 21.2 0C400 382 416 354.7 416 338c0-21.5-9.2-37-24-44.6l0-21.4c0-17.7 14.3-32 32-32s32 14.3 32 32l0 8 0 168L32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l576 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-104 0 0-168 0-8 0-96z"]
}, faToiletsPortable = {
  prefix: "fas",
  iconName: "toilets-portable",
  icon: [576, 512, [], "e584", "M32 0L224 0c17.7 0 32 14.3 32 32l0 32L0 64 0 32C0 14.3 14.3 0 32 0zM0 96l24 0 208 0 24 0 0 24 0 368c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8L48 480l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24L0 120 0 96zM192 224c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16zM352 0L544 0c17.7 0 32 14.3 32 32l0 32L320 64l0-32c0-17.7 14.3-32 32-32zM320 96l24 0 208 0 24 0 0 24 0 368c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8-160 0 0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-368 0-24zM512 224c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16z"]
}, faHockeyPuck = {
  prefix: "fas",
  iconName: "hockey-puck",
  icon: [512, 512, [], "f453", "M256 256C114.6 256 0 213 0 160s114.6-96 256-96s256 43 256 96s-114.6 96-256 96zm192.3 1.8c24.7-9.3 46.9-21 63.7-35.6L512 352c0 53-114.6 96-256 96S0 405 0 352L0 222.3c16.8 14.6 39 26.3 63.7 35.6C114.5 276.9 182.5 288 256 288s141.5-11.1 192.3-30.2z"]
}, faMustache = {
  prefix: "fas",
  iconName: "mustache",
  icon: [640, 512, [], "e5bc", "M147.9 148.4C169.3 125.2 199.4 112 231 112c33 0 64.4 14.4 85.9 39.5l3.1 3.6 3.1-3.6C344.6 126.4 376 112 409 112c31.6 0 61.7 13.2 83.1 36.4l2 2.1c27.6 29.9 74.6 30.9 103.4 2.1L599 151c2.5-2.5 5.5-4.4 8.6-5.5c2.6-1 5.4-1.5 8.4-1.5c5.7 0 10.9 2 15 5.2c1.3 1.1 2.6 2.3 3.6 3.6c.4 .5 .7 1 1.1 1.4c.3 .4 .5 .8 .7 1.1c.3 .5 .6 .9 .8 1.4c1.8 3.3 2.7 7.1 2.7 11.2l0 39.4C640 313.8 553.8 400 447.4 400c-46.7 0-91.7-16.9-126.9-47.7l-.5-.4-.5 .4C284.4 383.1 239.3 400 192.6 400C86.2 400 0 313.8 0 207.4L0 168c0-4.2 1.1-8.1 2.9-11.5c.6-1 1.2-2.1 2-3c1.2-1.6 2.6-3 4.1-4.2c1.5-1.2 3.1-2.2 4.8-3c3.1-1.5 6.5-2.3 10.2-2.3c2.9 0 5.8 .5 8.4 1.5c3.1 1.2 6.1 3 8.6 5.5l1.6 1.6c28.8 28.8 75.8 27.9 103.4-2.1l2-2.1z"]
}, faHyphen = {
  prefix: "fas",
  iconName: "hyphen",
  icon: [320, 512, [], "2d", "M0 256c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32z"]
}, faTable = {
  prefix: "fas",
  iconName: "table",
  icon: [512, 512, [], "f0ce", "M64 256l0-96 160 0 0 96L64 256zm0 64l160 0 0 96L64 416l0-96zm224 96l0-96 160 0 0 96-160 0zM448 256l-160 0 0-96 160 0 0 96zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"]
}, faUserChef = {
  prefix: "fas",
  iconName: "user-chef",
  icon: [448, 512, [], "e3d2", "M384 48c0 20.9-13.4 38.7-32 45.3l0 18.7 0 64c0 70.7-57.3 128-128 128s-128-57.3-128-128l0-64 0-18.7C77.4 86.7 64 68.9 64 48C64 21.5 85.5 0 112 0c14.3 0 27.2 6.3 36 16.3C156.8 6.3 169.7 0 184 0c16.7 0 31.4 8.5 40 21.5C232.6 8.5 247.3 0 264 0c14.3 0 27.2 6.3 36 16.3C308.8 6.3 321.7 0 336 0c26.5 0 48 21.5 48 48zM304 176l0-16-160 0 0 16c0 44.2 35.8 80 80 80s80-35.8 80-80zM178.4 340.6c7.5 1.9 8.2 12.3 1 15.2l-43.2 17.3C111.9 382.8 96 406.3 96 432.5L96 480l0 24 0 8-8 0-24 0-38.4 0C11.5 512 0 500.5 0 486.4c0-58.8 37.7-108.8 90.3-127c3.3-1.2 5.7-4.3 5.7-7.8l0-21.4c0-5.2 4.9-9 9.9-7.8l72.5 18.1zM352 512l-192 0-24 0-8 0 0-8 0-24 0-47.5c0-13.1 8-24.9 20.1-29.7L341 325.6c5.3-2.1 11 1.8 11 7.4l0 18.6c0 3.5 2.3 6.6 5.7 7.8c52.6 18.2 90.3 68.2 90.3 127c0 14.1-11.5 25.6-25.6 25.6L352 512zM224 432a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]
}, faMessageImage = {
  prefix: "fas",
  iconName: "message-image",
  icon: [512, 512, ["comment-alt-image"], "e1e0", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zm176 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm120 0c-8 0-15.5 4-20 10.7l-56 84L202.7 201c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6l80 0 48 0 144 0c8.9 0 17-4.9 21.2-12.7s3.7-17.3-1.2-24.6l-96-144C311.5 132 304 128 296 128z"]
}, faCommentAltImage = faMessageImage, faUsersMedical = {
  prefix: "fas",
  iconName: "users-medical",
  icon: [640, 512, [], "f830", "M144 160A80 80 0 1 0 144 0a80 80 0 1 0 0 160zm368 0A80 80 0 1 0 512 0a80 80 0 1 0 0 160zM0 298.7C0 310.4 9.6 320 21.3 320l213.3 0c.2 0 .4 0 .7 0c-26.6-23.5-43.3-57.8-43.3-96c0-7.6 .7-15 1.9-22.3c-13.6-6.3-28.7-9.7-44.6-9.7l-42.7 0C47.8 192 0 239.8 0 298.7zM405.3 320l77.4 0c6.6-18.6 24.4-32 45.3-32l32 0c20.9 0 38.7 13.4 45.3 32l13.4 0c11.8 0 21.3-9.6 21.3-21.3C640 239.8 592.2 192 533.3 192l-42.7 0c-15.9 0-31 3.5-44.6 9.7c1.3 7.2 1.9 14.7 1.9 22.3c0 38.2-16.8 72.5-43.3 96c.2 0 .4 0 .7 0zM416 400c0-14.6 6.5-27.7 16.9-36.5C416.3 356.1 398 352 378.7 352l-117.3 0C187.7 352 128 411.7 128 485.3c0 14.7 11.9 26.7 26.7 26.7l328.1 0c-1.8-5-2.7-10.4-2.7-16l0-16-16 0c-26.5 0-48-21.5-48-48l0-32zm0-176a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zm96 112l0 48-48 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]
}, faSensorTriangleExclamation = {
  prefix: "fas",
  iconName: "sensor-triangle-exclamation",
  icon: [640, 512, ["sensor-alert"], "e029", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l161 0c-.6-4-1-8.1-1-12.3c0-13.2 3.4-26.2 9.9-37.7l150.4-265c13-22.9 37.3-37.1 63.7-37.1l0-32c0-35.3-28.7-64-64-64L64 32zm48 88l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24zm96 0l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24zm53.8 325.8c-3.8 6.7-5.8 14.2-5.8 21.9c0 24.5 19.8 44.3 44.3 44.3l295.4 0c24.5 0 44.3-19.8 44.3-44.3c0-7.7-2-15.2-5.8-21.9l-150.4-265C476.5 168 462.8 160 448 160s-28.5 8-35.8 20.9l-150.4 265zM464 272l0 88c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-88c0-8.8 7.2-16 16-16s16 7.2 16 16zM448 408a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]
}, faSensorAlert = faSensorTriangleExclamation, faMagnifyingGlassArrowRight = {
  prefix: "fas",
  iconName: "magnifying-glass-arrow-right",
  icon: [512, 512, [], "e521", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zM241 119c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l31 31L120 184c-13.3 0-24 10.7-24 24s10.7 24 24 24l118.1 0-31 31c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9l-72-72z"]
}, faTachographDigital = {
  prefix: "fas",
  iconName: "tachograph-digital",
  icon: [640, 512, ["digital-tachograph"], "f566", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l512 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm32 64l224 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zM64 368c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 384c-8.8 0-16-7.2-16-16zm320 0c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16zM80 288a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faDigitalTachograph = faTachographDigital, faFaceMask = {
  prefix: "fas",
  iconName: "face-mask",
  icon: [576, 512, [], "e37f", "M410.5 281.7L541.8 222C525.1 96.7 417.9 0 288 0S50.9 96.7 34.2 222l131.3 59.7c8-15.3 24.1-25.7 42.5-25.7l160 0c18.4 0 34.5 10.4 42.5 25.7zm5.5 32.6l0 69.7 93.8 0c21.8-37.6 34.2-81.3 34.2-127.9L416 314.3zM413.3 416c-6.6 18.6-24.4 32-45.3 32l-160 0c-20.9 0-38.7-13.4-45.3-32l-74.6 0c46.9 58.5 119 96 199.9 96s152.9-37.5 199.9-96l-74.6 0zM160 384l0-69.7L32 256.1c0 46.6 12.5 90.3 34.2 127.9l93.8 0zm-4.7-180.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6C146.4 167 184.6 144 240 144c8.8 0 16 7.2 16 16s-7.2 16-16 16c-47 0-77.1 19.7-84.7 27.3zM336 176c-8.8 0-16-7.2-16-16s7.2-16 16-16c55.4 0 93.6 23 107.3 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0C413.1 195.7 383 176 336 176zM208 304c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0z"]
}, faPickleball = {
  prefix: "fas",
  iconName: "pickleball",
  icon: [576, 512, [], "e435", "M250.4 28c37.5-37.4 98.4-37.4 136 0L499.9 141.3c29.2 29.2 35.7 72.4 19.4 107.8c-24.9-15.8-54.4-25-86.1-25c-72 0-133 47.3-153.3 112.5L155.7 212.8c-6.3-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L273 374.9c-.2 3-.3 6.1-.3 9.1c0 27.8 7.1 53.8 19.6 76.6c-9.3 .5-18.7-1-27.6-4.7l-56.7-23.2c-23.9-9.8-51.4-4.3-69.6 13.9L84.4 500.3c-15.6 15.6-41 15.6-56.7 0s-15.6-40.9 0-56.5l53.5-53.4c18.4-18.3 23.8-45.8 13.9-69.8L71.1 262.8c-10-23.9-4.5-51.4 13.9-69.7L250.4 28zM304 384a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zm32-16a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm80 80a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm0-64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm96 0a16 16 0 1 0 0 32 16 16 0 1 0 0-32zm-80-80a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z"]
}, faStarSharpHalf = {
  prefix: "fas",
  iconName: "star-sharp-half",
  icon: [576, 512, [], "e28c", "M254.4 50.4L214.5 176 90.3 176 88 176l-13.3 0L56 176c-10.3 0-19.4 6.5-22.7 16.2s-.1 20.4 8 26.7L56 230.4l10.5 8.2 1.8 1.4 103.7 80.7L132 446.7l-1.1 3.5L126.1 465l-5 15.7c-3.2 10 .5 21 9.1 27s20.2 5.7 28.5-.7l13-10.1 12.3-9.5 2.9-2.3L288 406.4l0-81.1 0-169.4L288 0c-10.5 0-19.7 6.8-22.9 16.7L260 32.9s0 0 0 0l-4.6 14.3-1 3.2z"]
}, faUsersSlash = {
  prefix: "fas",
  iconName: "users-slash",
  icon: [640, 512, [], "e073", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L440.6 320l178.1 0c11.8 0 21.3-9.6 21.3-21.3C640 239.8 592.2 192 533.3 192l-42.7 0c-15.9 0-31 3.5-44.6 9.7c1.3 7.2 1.9 14.7 1.9 22.3c0 30.2-10.5 58-28 79.9l-25.2-19.7C408.1 267.7 416 246.8 416 224c0-53-43-96-96-96c-31.1 0-58.7 14.8-76.3 37.7l-40.6-31.8c13-14.2 20.9-33.1 20.9-53.9c0-44.2-35.8-80-80-80C116.3 0 91.9 14.1 77.5 35.5L38.8 5.1zM106.7 192C47.8 192 0 239.8 0 298.7C0 310.4 9.6 320 21.3 320l213.3 0c.2 0 .4 0 .7 0c-20.6-18.2-35.2-42.8-40.8-70.8L121.8 192l-15.2 0zM261.3 352C187.7 352 128 411.7 128 485.3c0 14.7 11.9 26.7 26.7 26.7l330.7 0c10.5 0 19.5-6 23.9-14.8L324.9 352l-63.6 0zM512 160A80 80 0 1 0 512 0a80 80 0 1 0 0 160z"]
}, faClover = {
  prefix: "fas",
  iconName: "clover",
  icon: [448, 512, [], "e139", "M216.6 49.9C205.1 38.5 189.5 32 173.3 32C139.4 32 112 59.4 112 93.3l0 4.9c0 12 3.3 23.7 9.4 34l18.8 31.3c1.1 1.8 1.2 3.1 1 4.2c-.2 1.2-.8 2.5-2 3.6s-2.4 1.8-3.6 2c-1 .2-2.4 .1-4.2-1l-31.3-18.8c-10.3-6.2-22-9.4-34-9.4l-4.9 0C27.4 144 0 171.4 0 205.3c0 16.2 6.5 31.8 17.9 43.3l1.2 1.2c3.4 3.4 3.4 9 0 12.4l-1.2 1.2C6.5 274.9 0 290.5 0 306.7C0 340.6 27.4 368 61.3 368l4.9 0c12 0 23.7-3.3 34-9.4l31.3-18.8c1.8-1.1 3.1-1.2 4.2-1c1.2 .2 2.5 .8 3.6 2s1.8 2.4 2 3.6c.2 1 .1 2.4-1 4.2l-18.8 31.3c-6.2 10.3-9.4 22-9.4 34l0 4.9c0 33.8 27.4 61.3 61.3 61.3c16.2 0 31.8-6.5 43.3-17.9l1.2-1.2c3.4-3.4 9-3.4 12.4 0l1.2 1.2c11.5 11.5 27.1 17.9 43.3 17.9c33.8 0 61.3-27.4 61.3-61.3l0-4.9c0-12-3.3-23.7-9.4-34l-18.8-31.3c-1.1-1.8-1.2-3.1-1-4.2c.2-1.2 .8-2.5 2-3.6s2.4-1.8 3.6-2c1-.2 2.4-.1 4.2 1l31.3 18.8c10.3 6.2 22 9.4 34 9.4l4.9 0c33.8 0 61.3-27.4 61.3-61.3c0-16.2-6.5-31.8-17.9-43.3l-1.2-1.2c-3.4-3.4-3.4-9 0-12.4l1.2-1.2c11.5-11.5 17.9-27.1 17.9-43.3c0-33.8-27.4-61.3-61.3-61.3l-4.9 0c-12 0-23.7 3.3-34 9.4l-31.3 18.8c-1.8 1.1-3.1 1.2-4.2 1c-1.2-.2-2.5-.8-3.6-2s-1.8-2.4-2-3.6c-.2-1-.1-2.4 1-4.2l18.8-31.3c6.2-10.3 9.4-22 9.4-34l0-4.9C336 59.4 308.6 32 274.7 32c-16.2 0-31.8 6.5-43.3 17.9l-1.2 1.2c-3.4 3.4-9 3.4-12.4 0l-1.2-1.2z"]
}, faMeat = {
  prefix: "fas",
  iconName: "meat",
  icon: [512, 512, [127830], "f814", "M243.6 19.6C283.7-20.4 371.9 2.8 440.5 71.5s91.9 156.8 51.8 196.9l-40.5 40.5C403.9 357 338.7 384 270.8 384l-58.2 0c-7.1 0-13.9 2.8-18.9 7.8c-10.3 10.3-9.7 26.9-5 40.7c2.1 6.1 3.2 12.7 3.2 19.5c0 33.1-26.9 60-60 60s-60-26.9-60-60c0-6.3-5.7-12-12-12c-33.1 0-60-26.9-60-60s26.9-60 60-60c6.8 0 13.4 1.1 19.5 3.2c13.8 4.7 30.4 5.3 40.7-5c5-5 7.8-11.8 7.8-18.9l0-58.1c0-67.9 27-133 75-181l40.7-40.7zm64 184.8c49.6 49.6 113.3 66.4 142.2 37.4s12.2-92.6-37.4-142.2S299.1 33.2 270.2 62.2s-12.2 92.6 37.4 142.2zm36.3-36.3c-15.3-15.3-20.4-34.9-11.5-43.8s28.5-3.7 43.8 11.5s20.4 34.9 11.5 43.8s-28.5 3.7-43.8-11.5z"]
}, faReply = {
  prefix: "fas",
  iconName: "reply",
  icon: [512, 512, [61714, "mail-reply"], "f3e5", "M205 34.8c11.5 5.1 19 16.6 19 29.2l0 64 112 0c97.2 0 176 78.8 176 176c0 113.3-81.5 163.9-100.2 174.1c-2.5 1.4-5.3 1.9-8.1 1.9c-10.9 0-19.7-8.9-19.7-19.7c0-7.5 4.3-14.4 9.8-19.5c9.4-8.8 22.2-26.4 22.2-56.7c0-53-43-96-96-96l-96 0 0 64c0 12.6-7.4 24.1-19 29.2s-25 3-34.4-5.4l-160-144C3.9 225.7 0 217.1 0 208s3.9-17.7 10.6-23.8l160-144c9.4-8.5 22.9-10.6 34.4-5.4z"]
}, faMailReply = faReply, faStarAndCrescent = {
  prefix: "fas",
  iconName: "star-and-crescent",
  icon: [512, 512, [9770], "f699", "M0 256C0 114.6 114.6 0 256 0c33 0 64.6 6.3 93.6 17.7c7.4 2.9 11.5 10.7 9.8 18.4s-8.8 13-16.7 12.4c-4.8-.3-9.7-.5-14.6-.5c-114.9 0-208 93.1-208 208s93.1 208 208 208c4.9 0 9.8-.2 14.6-.5c7.9-.5 15 4.7 16.7 12.4s-2.4 15.5-9.8 18.4C320.6 505.7 289 512 256 512C114.6 512 0 397.4 0 256zM375.4 137.4c3.5-7.1 13.7-7.1 17.2 0l31.5 63.8c1.4 2.8 4.1 4.8 7.2 5.3l70.4 10.2c7.9 1.1 11 10.8 5.3 16.4l-50.9 49.6c-2.3 2.2-3.3 5.4-2.8 8.5l12 70.1c1.3 7.8-6.9 13.8-13.9 10.1l-63-33.1c-2.8-1.5-6.1-1.5-8.9 0l-63 33.1c-7 3.7-15.3-2.3-13.9-10.1l12-70.1c.5-3.1-.5-6.3-2.8-8.5L261 233.1c-5.7-5.6-2.6-15.2 5.3-16.4l70.4-10.2c3.1-.5 5.8-2.4 7.2-5.3l31.5-63.8z"]
}, faEmptySet = {
  prefix: "fas",
  iconName: "empty-set",
  icon: [512, 512, [8709, 216], "f656", "M435.4 121.9l67.2-67.2c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L390.2 76.6C352.8 48.6 306.3 32 256 32C132.3 32 32 132.3 32 256c0 50.3 16.6 96.8 44.6 134.2L9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l67.2-67.2c37.4 28 83.8 44.6 134.1 44.6c123.7 0 224-100.3 224-224c0-50.3-16.6-96.8-44.6-134.1zm-91.2 .7L122.5 344.2C105.8 318.9 96 288.6 96 256c0-88.4 71.6-160 160-160c32.6 0 62.9 9.8 88.2 26.5zm-176.5 267L389.5 167.8C406.2 193.1 416 223.4 416 256c0 88.4-71.6 160-160 160c-32.6 0-62.9-9.8-88.2-26.5z"]
}, faHouseFire = {
  prefix: "fas",
  iconName: "house-fire",
  icon: [640, 512, [], "e50c", "M288 350.1l0 1.9-32 0c-17.7 0-32 14.3-32 32l0 64 0 24c0 22.1-17.9 40-40 40l-24 0-31.9 0c-1.5 0-3-.1-4.5-.2c-1.2 .1-2.4 .2-3.6 .2l-16 0c-22.1 0-40-17.9-40-40l0-112c0-.9 0-1.9 .1-2.8l0-69.7-32 0c-18 0-32-14-32-32.1c0-9 3-17 10-24L266.4 8c7-7 15-8 22-8s15 2 21 7L447.3 128.1c-12.3-1-25 3-34.8 11.7c-35.4 31.6-65.6 67.7-87.3 102.8C304.3 276.5 288 314.9 288 350.1zM480 512c-88.4 0-160-71.6-160-160c0-76.7 62.5-144.7 107.2-179.4c5-3.9 10.9-5.8 16.8-5.8c7.9-.1 16 3.1 22 9.2l46 46 11.3-11.3c11.7-11.7 30.6-12.7 42.3-1C624.5 268 640 320.2 640 352c0 88.4-71.6 160-160 160zm64-111.8c0-36.5-37-73-54.8-88.4c-5.4-4.7-13.1-4.7-18.5 0C453 327.1 416 363.6 416 400.2c0 35.3 28.7 64 64 64s64-28.7 64-64z"]
}, faSquareMinus = {
  prefix: "fas",
  iconName: "square-minus",
  icon: [448, 512, [61767, "minus-square"], "f146", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm88 200l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faMinusSquare = faSquareMinus, faHelicopter = {
  prefix: "fas",
  iconName: "helicopter",
  icon: [640, 512, [128641], "f533", "M128 32c0-17.7 14.3-32 32-32L544 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L384 64l0 64 32 0c88.4 0 160 71.6 160 160l0 64c0 17.7-14.3 32-32 32l-160 0-64 0c-20.1 0-39.1-9.5-51.2-25.6l-71.4-95.2c-3.5-4.7-8.3-8.3-13.7-10.5L47.2 198.1c-9.5-3.8-16.7-12-19.2-22L5 83.9C2.4 73.8 10.1 64 20.5 64L48 64c10.1 0 19.6 4.7 25.6 12.8L112 128l208 0 0-64L160 64c-17.7 0-32-14.3-32-32zM384 320l128 0 0-32c0-53-43-96-96-96l-32 0 0 128zM630.6 425.4c12.5 12.5 12.5 32.8 0 45.3l-3.9 3.9c-24 24-56.6 37.5-90.5 37.5L256 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l280.2 0c17 0 33.3-6.7 45.3-18.7l3.9-3.9c12.5-12.5 32.8-12.5 45.3 0z"]
}, faBird = {
  prefix: "fas",
  iconName: "bird",
  icon: [512, 512, [], "e469", "M0 192l0-3.6C0 172.7 12.7 160 28.4 160L224 160c17.7 0 32-14.3 32-32l0-32c0-53 43-96 96-96c47.5 0 86.9 34.5 94.6 79.7l57.6 34.6c4.8 2.9 7.8 8.1 7.8 13.7s-2.9 10.8-7.8 13.7L448 175.5l0 16.5c0 93.9-57.7 174.3-139.7 207.6l40.9 77.2c6.2 11.7 1.7 26.2-10 32.4s-26.2 1.7-32.4-10l-45.7-86.3C249 415 236.6 416 224 416c-1 0-2 0-3 0l32.2 60.8c6.2 11.7 1.7 26.2-10 32.4s-26.2 1.7-32.4-10l-48.6-91.9C68.5 380.5 0 294.3 0 192zm376-72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]
}, faCompass = {
  prefix: "fas",
  iconName: "compass",
  icon: [512, 512, [129517], "f14e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm50.7-186.9L162.4 380.6c-19.4 7.5-38.5-11.6-31-31l55.5-144.3c3.3-8.5 9.9-15.1 18.4-18.4l144.3-55.5c19.4-7.5 38.5 11.6 31 31L325.1 306.7c-3.2 8.5-9.9 15.1-18.4 18.4zM288 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faSquareCaretDown = {
  prefix: "fas",
  iconName: "square-caret-down",
  icon: [448, 512, ["caret-square-down"], "f150", "M384 480c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0zM224 352c-6.7 0-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9s12.5-14.4 22-14.4l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7z"]
}, faCaretSquareDown = faSquareCaretDown, faHeartHalfStroke = {
  prefix: "fas",
  iconName: "heart-half-stroke",
  icon: [512, 512, ["heart-half-alt"], "e1ac", "M256 186.5l0 220.9L420.7 253.6c17.4-16.2 27.3-38.9 27.3-62.7l0-5.8c0-38.6-27.9-71.5-66-77.9c-25.1-4.2-50.8 4-68.8 22l-12 12L256 186.5zM119.4 44.1C165 36.5 211.3 51.4 244 84c0 0 0 0 0 0l12 12 12-12c32.6-32.6 79-47.5 124.6-39.9C461.5 55.6 512 115.2 512 185.1l0 5.8c0 41.5-17.2 81.2-47.6 109.5L283.7 469.1c-7.5 7-17.4 10.9-27.7 10.9s-20.2-3.9-27.7-10.9L47.6 300.4C17.2 272.1 0 232.4 0 190.9l0-5.8c0-69.9 50.5-129.5 119.4-141z"]
}, faHeartHalfAlt = faHeartHalfStroke, faFileCircleQuestion = {
  prefix: "fas",
  iconName: "file-circle-question",
  icon: [576, 512, [], "e4ef", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 38.6C310.1 219.5 256 287.4 256 368c0 59.1 29.1 111.3 73.7 143.3c-3.2 .5-6.4 .7-9.7 .7L64 512c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zm48 96a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 240a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM368 321.6l0 6.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-6.4c0-5.3 4.3-9.6 9.6-9.6l40.5 0c7.7 0 13.9 6.2 13.9 13.9c0 5.2-2.9 9.9-7.4 12.3l-32 16.8c-5.3 2.8-8.6 8.2-8.6 14.2l0 14.8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-5.1 23.5-12.3c15.1-7.9 24.5-23.6 24.5-40.6c0-25.4-20.6-45.9-45.9-45.9l-40.5 0c-23 0-41.6 18.6-41.6 41.6z"]
}, faTruckUtensils = {
  prefix: "fas",
  iconName: "truck-utensils",
  icon: [640, 512, [], "e628", "M48 0C21.5 0 0 21.5 0 48L0 368c0 26.5 21.5 48 48 48l16 0c0 53 43 96 96 96s96-43 96-96l128 0c0 53 43 96 96 96s96-43 96-96l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-64 0-32 0-18.7c0-17-6.7-33.3-18.7-45.3L512 114.7c-12-12-28.3-18.7-45.3-18.7L416 96l0-48c0-26.5-21.5-48-48-48L48 0zM416 160l50.7 0L544 237.3l0 18.7-128 0 0-96zM112 416a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm368-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM89.5 77.5c.7-5.9 5.6-10.3 11.6-10.3c6.2 0 11.3 4.8 11.6 11l4.4 75.5c.2 3 2.6 5.3 5.6 5.3s5.5-2.3 5.6-5.3l4.4-75.8c.3-6 5.3-10.6 11.3-10.6s10.9 4.7 11.3 10.6l4.4 75.8c.2 3 2.6 5.3 5.6 5.3s5.5-2.3 5.6-5.3l4.4-75.5c.4-6.2 5.5-11 11.6-11c5.9 0 10.9 4.4 11.6 10.3l9.5 81.4c0 29.4-20.5 54-48 60.3l0 84.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-84.8c-27.5-6.3-48-30.9-48-60.3l9.5-81.4zM256 154.9c0-63.1 41.3-86 50.3-90.2c1.1-.5 2.3-.8 3.6-.8c5.6 0 10.1 4.5 10.1 10.1l0 53.9 0 96 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c-17.7 0-32-14.3-32-32l0-37z"]
}, faLaptopCode = {
  prefix: "fas",
  iconName: "laptop-code",
  icon: [640, 512, [], "f5fc", "M64 96c0-35.3 28.7-64 64-64l384 0c35.3 0 64 28.7 64 64l0 256-64 0 0-256L128 96l0 256-64 0L64 96zM0 403.2C0 392.6 8.6 384 19.2 384l601.6 0c10.6 0 19.2 8.6 19.2 19.2c0 42.4-34.4 76.8-76.8 76.8L76.8 480C34.4 480 0 445.6 0 403.2zM281 209l-31 31 31 31c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48-48c-9.4-9.4-9.4-24.6 0-33.9l48-48c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zM393 175l48 48c9.4 9.4 9.4 24.6 0 33.9l-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0z"]
}, faJoystick = {
  prefix: "fas",
  iconName: "joystick",
  icon: [448, 512, [128377], "f8c5", "M336 112c0 50.7-33.7 93.6-80 107.4L256 320l-64 0 0-100.6c-46.3-13.8-80-56.6-80-107.4C112 50.1 162.1 0 224 0s112 50.1 112 112zM200 96a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM64 352c0-17.7 14.3-32 32-32s32 14.3 32 32l256 0c35.3 0 64 28.7 64 64l0 32c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64l0-32c0-35.3 28.7-64 64-64z"]
}, faGrillFire = {
  prefix: "fas",
  iconName: "grill-fire",
  icon: [576, 512, [], "e5a4", "M0 72C0 49.9 17.9 32 40 32l368 0c22.1 0 40 17.9 40 40l0 24c0 24.1-3.8 47.3-10.9 69.1c-8.5-8.6-17.2-17-26.2-25.1c-17.7-16-44.7-16-62.5-.1c-35.4 31.6-65.6 67.7-87.3 102.8c-15 24.3-27.7 51-33.6 77.3c-1.2 0-2.4 0-3.6 0c-16.9 0-33.4-1.9-49.3-5.4L151.8 368l73 0c1.5 16.6 5.2 32.7 10.7 48L160 416c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c3.4 0 6.8 .3 10.1 .8L129.2 299C52.9 263.3 0 185.8 0 96L0 72zM96 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm320 72c-88.4 0-160-71.6-160-160c0-76.7 62.5-144.7 107.2-179.4c5-3.9 10.9-5.8 16.8-5.8c7.9-.1 16 3.1 22 9.2l46 46 11.3-11.3c11.7-11.7 30.6-12.7 42.3-1C560.5 268 576 320.2 576 352c0 88.4-71.6 160-160 160zm64-111.8c0-36.5-37-73-54.8-88.4c-5.4-4.7-13.1-4.7-18.5 0C389 327.1 352 363.6 352 400.2c0 35.3 28.7 64 64 64s64-28.7 64-64z"]
}, faRectangleVerticalHistory = {
  prefix: "fas",
  iconName: "rectangle-vertical-history",
  icon: [576, 512, [], "e237", "M256 0c-35.3 0-64 28.7-64 64l0 384c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L256 0zM96 72l0 368c0 13.3 10.7 24 24 24s24-10.7 24-24l0-368c0-13.3-10.7-24-24-24s-24 10.7-24 24zM0 120L0 392c0 13.3 10.7 24 24 24s24-10.7 24-24l0-272c0-13.3-10.7-24-24-24S0 106.7 0 120z"]
}, faSwatchbook = {
  prefix: "fas",
  iconName: "swatchbook",
  icon: [512, 512, [], "f5c3", "M0 32C0 14.3 14.3 0 32 0L160 0c17.7 0 32 14.3 32 32l0 384c0 53-43 96-96 96s-96-43-96-96L0 32zM223.6 425.9c.3-3.3 .4-6.6 .4-9.9l0-262 75.4-75.4c12.5-12.5 32.8-12.5 45.3 0l90.5 90.5c12.5 12.5 12.5 32.8 0 45.3L223.6 425.9zM182.8 512l192-192L480 320c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-297.2 0zM128 64L64 64l0 64 64 0 0-64zM64 192l0 64 64 0 0-64-64 0zM96 440a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faPrescriptionBottle = {
  prefix: "fas",
  iconName: "prescription-bottle",
  icon: [384, 512, [], "f485", "M0 32C0 14.3 14.3 0 32 0L352 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64L0 32zm32 96l320 0 0 320c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-32 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L32 384l0-64 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L32 288l0-64 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L32 192l0-64z"]
}, faBars = {
  prefix: "fas",
  iconName: "bars",
  icon: [448, 512, ["navicon"], "f0c9", "M0 96C0 78.3 14.3 64 32 64l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 128C14.3 128 0 113.7 0 96zM0 256c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32zM448 416c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32z"]
}, faNavicon = faBars, faKeyboardLeft = {
  prefix: "fas",
  iconName: "keyboard-left",
  icon: [640, 512, [], "e1c3", "M224 64c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l352 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L224 64zm16 64l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM224 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80-176c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM320 336c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-32zM432 128l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM416 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM528 128l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM512 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM113.2 153.8c-9-3.7-19.3-1.7-26.2 5.2L7 239c-9.4 9.4-9.4 24.6 0 33.9l80 80c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-160c0-9.7-5.8-18.5-14.8-22.2z"]
}, faPeopleGroup = {
  prefix: "fas",
  iconName: "people-group",
  icon: [640, 512, [], "e533", "M72 88a56 56 0 1 1 112 0A56 56 0 1 1 72 88zM64 245.7C54 256.9 48 271.8 48 288s6 31.1 16 42.3l0-84.7zm144.4-49.3C178.7 222.7 160 261.2 160 304c0 34.3 12 65.8 32 90.5l0 21.5c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-26.8C26.2 371.2 0 332.7 0 288c0-61.9 50.1-112 112-112l32 0c24 0 46.2 7.5 64.4 20.3zM448 416l0-21.5c20-24.7 32-56.2 32-90.5c0-42.8-18.7-81.3-48.4-107.7C449.8 183.5 472 176 496 176l32 0c61.9 0 112 50.1 112 112c0 44.7-26.2 83.2-64 101.2l0 26.8c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32zm8-328a56 56 0 1 1 112 0A56 56 0 1 1 456 88zM576 245.7l0 84.7c10-11.3 16-26.1 16-42.3s-6-31.1-16-42.3zM320 32a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM240 304c0 16.2 6 31 16 42.3l0-84.7c-10 11.3-16 26.1-16 42.3zm144-42.3l0 84.7c10-11.3 16-26.1 16-42.3s-6-31.1-16-42.3zM448 304c0 44.7-26.2 83.2-64 101.2l0 42.8c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-42.8c-37.8-18-64-56.5-64-101.2c0-61.9 50.1-112 112-112l32 0c61.9 0 112 50.1 112 112z"]
}, faHourglassEnd = {
  prefix: "fas",
  iconName: "hourglass-end",
  icon: [384, 512, [8987, "hourglass-3"], "f253", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l0 11c0 42.4 16.9 83.1 46.9 113.1L146.7 256 78.9 323.9C48.9 353.9 32 394.6 32 437l0 11c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 256 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-11c0-42.4-16.9-83.1-46.9-113.1L237.3 256l67.9-67.9c30-30 46.9-70.7 46.9-113.1l0-11c17.7 0 32-14.3 32-32s-14.3-32-32-32L320 0 64 0 32 0zM96 75l0-11 192 0 0 11c0 25.5-10.1 49.9-28.1 67.9L192 210.7l-67.9-67.9C106.1 124.9 96 100.4 96 75z"]
}, faHourglass3 = faHourglassEnd, faHeartCrack = {
  prefix: "fas",
  iconName: "heart-crack",
  icon: [512, 512, [128148, "heart-broken"], "f7a9", "M119.4 44.1c23.3-3.9 46.8-1.9 68.6 5.3l49.8 77.5-75.4 75.4c-1.5 1.5-2.4 3.6-2.3 5.8s1 4.2 2.6 5.7l112 104c2.9 2.7 7.4 2.9 10.5 .3s3.8-7 1.7-10.4l-60.4-98.1 90.7-75.6c2.6-2.1 3.5-5.7 2.4-8.8L296.8 61.8c28.5-16.7 62.4-23.2 95.7-17.6C461.5 55.6 512 115.2 512 185.1l0 5.8c0 41.5-17.2 81.2-47.6 109.5L283.7 469.1c-7.5 7-17.4 10.9-27.7 10.9s-20.2-3.9-27.7-10.9L47.6 300.4C17.2 272.1 0 232.4 0 190.9l0-5.8c0-69.9 50.5-129.5 119.4-141z"]
}, faHeartBroken = faHeartCrack, faFaceBeamHandOverMouth = {
  prefix: "fas",
  iconName: "face-beam-hand-over-mouth",
  icon: [512, 512, [129325], "e47c", "M512 256c0 113.1-73.3 209.1-175.1 242.9l49-49c18.1-18.1 18.7-47.1 1.8-65.9c16.9-18.8 16.3-47.8-1.8-65.9c-1-1-2.1-2-3.2-3c3.7-15.7-.5-32.8-12.8-45s-29.4-16.5-45-12.8c-.9-1.1-1.9-2.2-3-3.2c-18.7-18.7-49.1-18.7-67.9 0L207 301.1c-9.4-13.7-25.1-22.7-43-22.7c-28.7 0-52 23.3-52 52l0 53.6 0 32.8c0 21.9 5.5 42.5 15.3 60.5C51.2 433 0 350.5 0 256C0 114.6 114.6 0 256 0S512 114.6 512 256zM217.6 212.8s0 0 0 0s0 0 0 0s0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 172.4 120 190.1 120 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2c0 0 0 0 0 0zm160 0s0 0 0 0s0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 172.4 280 190.1 280 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2c0 0 0 0 0 0c0 0 0 0 0 0zm-78.3 63.9c6.2 6.2 6.2 16.4 0 22.6L248 350.6c-2.6 2.6-2.6 6.8 0 9.4s6.8 2.6 9.4 0l67.3-67.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L280 382.6c-2.6 2.6-2.6 6.8 0 9.4s6.8 2.6 9.4 0l51.3-51.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L312 414.6c-2.6 2.6-2.6 6.8 0 9.4s6.8 2.6 9.4 0l19.3-19.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-56.8 56.8C288.7 502 264.4 512 239.2 512c-52.6 0-95.2-42.6-95.2-95.2l0-32.8 0-53.6c0-11 9-20 20-20s20 9 20 20l0 19.7c0 7.1 8.6 10.7 13.7 5.7l79-79c6.2-6.2 16.4-6.2 22.6 0z"]
}, faDropletPercent = {
  prefix: "fas",
  iconName: "droplet-percent",
  icon: [384, 512, ["humidity"], "f750", "M192 512C86 512 0 426 0 320C0 228.8 130.2 57.7 166.6 11.7C172.6 4.2 181.5 0 191.1 0l1.8 0c9.6 0 18.5 4.2 24.5 11.7C253.8 57.7 384 228.8 384 320c0 106-86 192-192 192zm75.3-267.3c-6.2-6.2-16.4-6.2-22.6 0l-128 128c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l128-128c6.2-6.2 6.2-16.4 0-22.6zM136 288a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM248 400a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faHumidity = faDropletPercent, faSquareUpRight = {
  prefix: "fas",
  iconName: "square-up-right",
  icon: [448, 512, [8599, "external-link-square-alt"], "f360", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM160 160c-6.5 0-12.3 3.9-14.8 9.9s-1.1 12.9 3.5 17.4l40 40-71 71C114 302 112 306.9 112 312s2 10 5.7 13.7l36.7 36.7c3.6 3.6 8.5 5.7 13.7 5.7s10-2 13.7-5.7l71-71 40 40c4.6 4.6 11.5 5.9 17.4 3.5s9.9-8.3 9.9-14.8l0-144c0-8.8-7.2-16-16-16l-144 0z"]
}, faExternalLinkSquareAlt = faSquareUpRight, faFaceKissBeam = {
  prefix: "fas",
  iconName: "face-kiss-beam",
  icon: [512, 512, [128537, "kiss-beam"], "f597", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm48.7-198.3c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C274.7 443.1 257.4 448 240 448c-3.6 0-6.8-2.5-7.7-6s.6-7.2 3.8-9c0 0 0 0 0 0s0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-.9-.5l-.2-.1c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.5-1.4-4.1-4.1-4.1-7s1.6-5.6 4.1-7c0 0 0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.1 .3-.2 .6-.4c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.4-.3-.5-.3-.2-.1c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-3.2-1.8-4.7-5.5-3.8-9s4.1-6 7.7-6c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4zm-87.1-84.9s0 0 0 0c0 0 0 0 0 0l-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8c0 0 0 0 0 0s0 0 0 0zm160 0c0 0 0 0 0 0l-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8c0 0 0 0 0 0s0 0 0 0s0 0 0 0z"]
}, faKissBeam = faFaceKissBeam, faCorn = {
  prefix: "fas",
  iconName: "corn",
  icon: [512, 512, [127805], "f6c7", "M512 40c0 15-8.3 28.1-20.5 34.9C499.2 82.2 504 92.6 504 104c0 18-11.8 33.2-28.2 38.2c2.7 5.4 4.2 11.4 4.2 17.8c0 18-11.8 33.2-28.2 38.2c2.7 5.4 4.2 11.4 4.2 17.8c0 22.1-17.9 40-40 40c-1.1 0-2.3 0-3.4-.1c2.2 4.9 3.4 10.4 3.4 16.1c0 13.6-6.8 25.7-17.3 32.9c-47.7-29.7-103.6-41.1-157.5-34.2c6.9-53.9-4.5-109.8-34.2-157.5C214.3 102.8 226.4 96 240 96c5.7 0 11.2 1.2 16.1 3.4c-.1-1.1-.1-2.2-.1-3.4c0-22.1 17.9-40 40-40c6.4 0 12.4 1.5 17.8 4.2C318.8 43.8 334 32 352 32c6.4 0 12.4 1.5 17.8 4.2C374.8 19.8 390 8 408 8c11.4 0 21.8 4.8 29.1 12.5C443.9 8.3 457 0 472 0c22.1 0 40 17.9 40 40zM137.7 98c1.2-6.3 8.9-8.7 13.2-3.9c45.4 50.5 69.5 114 56.9 183.4c-38.7 10.7-75.2 31.2-105.5 61.6L24.9 416.5c-34.2-37.7-33.1-96 3.2-132.4l64-64c18.3-18.3 30.6-41.7 35.3-67.1L137.7 98zM92.1 483.9L47.4 439.2l77.5-77.5c28.6-28.6 63.5-47.1 100.1-55.6c72.2-16.6 139.8 7.4 192.8 55c4.8 4.3 2.4 12.1-3.9 13.2l-54.9 10.2c-25.4 4.7-48.8 17-67.1 35.3l-64 64c-37.5 37.5-98.3 37.5-135.8 0z"]
}, faRollerCoaster = {
  prefix: "fas",
  iconName: "roller-coaster",
  icon: [640, 512, [], "e324", "M64 190.1c0-31.8 15.8-60 40-77L104 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-359.8c2-.1 4-.2 6.1-.2c14.8 0 29.1 3.5 41.9 9.9L200 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-301.3 48 69.1L296 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-163.1 20.3 29.2c7.9 11.3 17.2 21.3 27.7 29.8L392 456c0 13.3 10.7 24 24 24s24-10.7 24-24l0-78.4c13.6 4.2 28 6.4 42.6 6.4l5.4 0 0 72c0 13.3 10.7 24 24 24s24-10.7 24-24l0-77.6c14.4-4.2 27.8-10.5 40-18.6l0 88.2c0 17.7 14.3 32 32 32s32-14.3 32-32l0-200-.2 0c.1-2.6 .2-5.3 .2-8c0-79.5-64.5-144-144-144l-4 0c-28.9 0-57.3 7.1-82.8 20.7l-51.6 27.5L432 251.3l0-74.2 7.3-3.9c12.7-6.8 26.5-11 40.7-12.5L480 264c0 13.3 10.7 24 24 24s24-10.7 24-24l0-97.3c28.3 12.3 48 40.5 48 73.3c0 44.2-35.8 80-80 80l-13.4 0c-26.2 0-50.8-12.8-65.7-34.4L287.9 99.9C258.4 57.4 209.9 32 158.1 32C70.8 32 0 102.8 0 190.1L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-257.9z"]
}, faPhotoFilmMusic = {
  prefix: "fas",
  iconName: "photo-film-music",
  icon: [640, 512, [], "e228", "M192 64c0-35.3 28.7-64 64-64L576 0c35.3 0 64 28.7 64 64l0 69.6c-12.9-6.1-27.9-7.1-41.7-2.5l-98.9 33-37.8-60.5c-2.9-4.7-8.1-7.5-13.6-7.5s-10.6 2.8-13.6 7.5L388 177.9l-15.3-19.7c-3-3.9-7.7-6.2-12.6-6.2s-9.6 2.3-12.6 6.2l-56 72c-3.8 4.8-4.4 11.4-1.7 16.9s8.3 9 14.4 9l64 0 0 64-112 0c-35.3 0-64-28.7-64-64l0-192zM319.5 404.6c-13.8 10.3-25.2 25.2-29.6 43.4L64 448c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l96 0 0 264c0 17.7 14.3 32 32 32l150.2 0c-8.2 3.3-15.8 7.5-22.6 12.6zM320 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM56 168l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0zM56 360l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zM630 164.5c6.3 4.5 10 11.8 10 19.5l0 48 0 160c0 1.2-.1 2.4-.3 3.6c.2 1.5 .3 2.9 .3 4.4c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48c5.5 0 10.9 .5 16 1.5l0-88.2-144 48L448 464c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48c5.5 0 10.9 .5 16 1.5L400 296l0-48c0-10.3 6.6-19.5 16.4-22.8l192-64c7.3-2.4 15.4-1.2 21.6 3.3z"]
}, faRadar = {
  prefix: "fas",
  iconName: "radar",
  icon: [512, 512, [], "e024", "M304.8 173.3c-14.3-8.4-31-13.3-48.8-13.3c-53 0-96 43-96 96s43 96 96 96s96-43 96-96l64 0c0 73.5-49.6 135.5-117.2 154.2C290.8 394.7 274.7 384 256 384s-34.8 10.7-42.8 26.2c-51.7-14.3-92.8-53.9-109.4-104.6c14.4-8.3 24.1-23.8 24.1-41.7c0-19.4-11.5-36.1-28-43.7C116.2 149.1 179.9 96 256 96c35.5 0 68.3 11.6 94.9 31.2l22.8-22.8C341.2 79 300.4 64 256 64C163.1 64 85.7 129.9 67.9 217.6C47.2 222.9 32 241.7 32 264c0 23.8 17.3 43.6 40.1 47.4c19.3 64.3 71.5 114.4 137 130.9C213.8 463.8 233 480 256 480s42.2-16.2 46.9-37.8C386.3 421.3 448 345.9 448 256l64 0c0 141.4-114.6 256-256 256S0 397.4 0 256S114.6 0 256 0c62.1 0 118.9 22.1 163.3 58.8L463 15c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-182 182c3.3 7.7 5.1 16.1 5.1 25c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c8.9 0 17.3 1.8 25 5.1l23.8-23.8z"]
}, faSickle = {
  prefix: "fas",
  iconName: "sickle",
  icon: [512, 512, [], "f822", "M212.7 340.7L181 309c-33.9-33.9-53-80-53-128C128 81 209 0 309 0l11 0c90.1 0 165.8 62.1 186.4 145.8c1.8 7.3-4 14.2-11.5 14.2c-3.9 0-7.5-1.9-9.9-4.9C458.9 122.9 419.5 104 377.8 104C301.7 104 240 165.7 240 241.8l0 9.8c0 20.7 5.2 39.7 12.2 58.6c2.2 6 .9 12.8-3.7 17.3l-13.2 13.2c-6.2 6.2-16.4 6.2-22.6 0zM121 311l24 24 32 32 24 24c9.4 9.4 9.4 24.6 0 33.9l-16 16c-9.4 9.4-24.6 9.4-33.9 0l-7-7L73 505c-9.4 9.4-24.6 9.4-33.9 0L7 473c-9.4-9.4-9.4-24.6 0-33.9l71-71-7-7c-9.4-9.4-9.4-24.6 0-33.9l16-16c9.4-9.4 24.6-9.4 33.9 0z"]
}, faFilm = {
  prefix: "fas",
  iconName: "film",
  icon: [512, 512, [127902], "f008", "M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM48 368l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM48 240l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM48 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L64 96c-8.8 0-16 7.2-16 16zM416 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM160 128l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L192 96c-17.7 0-32 14.3-32 32zm32 160c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-128 0z"]
}, faCoconut = {
  prefix: "fas",
  iconName: "coconut",
  icon: [512, 512, [], "e2f6", "M141.2 141.2c-43.7 43.7-73 91.8-85.8 133.3c-13.2 42.7-7.4 71.9 7.5 86.7s44 20.6 86.7 7.5c41.5-12.8 89.6-42.1 133.3-85.8s73-91.8 85.8-133.3c13.2-42.7 7.4-71.9-7.5-86.7s-44-20.6-86.7-7.5C233 68.1 184.9 97.5 141.2 141.2zM260.4 9.5C309.6-5.7 361.5-4.8 395.2 28.8l40.9 40.9C484.7 118.4 512 184.3 512 252.9C512 396 396 512 253 512c-68.7 0-134.6-27.3-183.2-75.9l-41-41C-4.8 361.5-5.7 309.6 9.5 260.3c15.6-50.4 49.7-105 97.8-153.1S210 25 260.4 9.5zm63.5 88.1c25 25-5.4 95.9-67.9 158.4s-133.4 92.9-158.4 67.9s5.4-95.9 67.9-158.4S298.9 72.6 323.9 97.6zm95.4 107.1c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zm-56 136c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zm-136 56c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32z"]
}, faRulerHorizontal = {
  prefix: "fas",
  iconName: "ruler-horizontal",
  icon: [640, 512, [], "f547", "M0 336c0 26.5 21.5 48 48 48l544 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0c-26.5 0-48 21.5-48 48L0 336z"]
}, faShieldCross = {
  prefix: "fas",
  iconName: "shield-cross",
  icon: [512, 512, [9960], "f712", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2c.5 99.2 41.3 280.7 213.6 363.2c16.7 8 36.1 8 52.8 0C454.7 420.7 495.5 239.2 496 140c.1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM256 66.8l32 13.6 0 47.7c0 17.7 14.3 32 32 32l111.3 0c-1.2 19.6-4.2 41.4-9.4 64l-102 0c-17.7 0-32 14.3-32 32l0 170.8c-10 6.5-20.7 12.5-32 18c-11.3-5.5-22-11.5-32-18L224 256c0-17.7-14.3-32-32-32L90.1 224c-5.2-22.6-8.1-44.4-9.4-64L192 160c17.7 0 32-14.3 32-32l0-47.7 32-13.6z"]
}, faCassetteTape = {
  prefix: "fas",
  iconName: "cassette-tape",
  icon: [576, 512, [128429], "f8ab", "M0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64l-28.9 0-36.3-96.9c-7-18.7-24.9-31.1-44.9-31.1l-227.6 0c-20 0-37.9 12.4-44.9 31.1L92.9 480 64 480c-35.3 0-64-28.7-64-64L0 96zM416.8 394.4L448.9 480l-321.8 0 32.1-85.6c2.3-6.2 8.3-10.4 15-10.4l227.6 0c6.7 0 12.6 4.1 15 10.4zM341.5 192l-106.9 0c3.5 10 5.5 20.8 5.5 32s-1.9 22-5.5 32l106.9 0c-3.5-10-5.5-20.8-5.5-32s1.9-22 5.5-32zm90.5 0a32 32 0 1 0 0 64 32 32 0 1 0 0-64zM112 224a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z"]
}, faSquareTerminal = {
  prefix: "fas",
  iconName: "square-terminal",
  icon: [448, 512, [], "e32a", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm70.3 55.8c-9 9.8-8.3 25 1.5 33.9L148.5 256 71.8 326.3c-9.8 9-10.4 24.1-1.5 33.9s24.1 10.4 33.9 1.5l96-88c5-4.5 7.8-11 7.8-17.7s-2.8-13.1-7.8-17.7l-96-88c-9.8-9-25-8.3-33.9 1.5zM216 336c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"]
}, faPeopleRobbery = {
  prefix: "fas",
  iconName: "people-robbery",
  icon: [576, 512, [], "e536", "M488.2 59.1C478.1 99.6 441.7 128 400 128s-78.1-28.4-88.2-68.9L303 24.2C298.8 7.1 281.4-3.3 264.2 1S236.7 22.6 241 39.8l8.7 34.9c11 44 40.2 79.6 78.3 99.6L328 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 16 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-305.7c38.1-20 67.3-55.6 78.3-99.6L559 39.8c4.3-17.1-6.1-34.5-23.3-38.8S501.2 7.1 497 24.2l-8.7 34.9zM400 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM80 96A48 48 0 1 0 80 0a48 48 0 1 0 0 96zm-8 32c-35.3 0-64 28.7-64 64l0 96 0 .6L8 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 16 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-227.3 13 20.5c5.9 9.2 16.1 14.9 27 14.9l48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-30.4 0-37.4-58.9C157.6 142 132.1 128 104.7 128L72 128z"]
}, faLightbulb = {
  prefix: "fas",
  iconName: "lightbulb",
  icon: [384, 512, [128161], "f0eb", "M272 384c9.6-31.9 29.5-59.1 49.2-86.2c0 0 0 0 0 0c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C368 78.8 289.2 0 192 0S16 78.8 16 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4c0 0 0 0 0 0c19.8 27.1 39.7 54.4 49.2 86.2l160 0zM192 512c44.2 0 80-35.8 80-80l0-16-160 0 0 16c0 44.2 35.8 80 80 80zM112 176c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-61.9 50.1-112 112-112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.2 0-80 35.8-80 80z"]
}, faCaretLeft = {
  prefix: "fas",
  iconName: "caret-left",
  icon: [256, 512, [], "f0d9", "M9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6l0 256c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-128-128z"]
}, faCommentMiddle = {
  prefix: "fas",
  iconName: "comment-middle",
  icon: [512, 512, [], "e149", "M188.3 408.7l44.5 89c4.4 8.8 13.3 14.3 23.2 14.3s18.8-5.5 23.2-14.3l44.5-89C432.2 384.5 512 303.8 512 208C512 93.1 397.4 0 256 0S0 93.1 0 208c0 95.8 79.8 176.5 188.3 200.7z"]
}, faTrashCanList = {
  prefix: "fas",
  iconName: "trash-can-list",
  icon: [640, 512, [], "e2ab", "M147.8 0c-12.1 0-23.2 6.8-28.6 17.7L112 32 32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l352 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-80 0-7.2-14.3C291.4 6.8 280.3 0 268.2 0L147.8 0zM384 128L32 128l0 336c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-336zM160 208l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16s16 7.2 16 16zm128 0l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16s16 7.2 16 16zm192-80c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0zm0 128c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0zM448 416c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32z"]
}, faBlock = {
  prefix: "fas",
  iconName: "block",
  icon: [448, 512, [], "e46a", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm96 8a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm280 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM96 408a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm280 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faCircleExclamation = {
  prefix: "fas",
  iconName: "circle-exclamation",
  icon: [512, 512, ["exclamation-circle"], "f06a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-384c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24zM224 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faExclamationCircle = faCircleExclamation, faSchoolCircleXmark = {
  prefix: "fas",
  iconName: "school-circle-xmark",
  icon: [640, 512, [], "e56d", "M337.8 5.4C327-1.8 313-1.8 302.2 5.4L166.3 96 48 96C21.5 96 0 117.5 0 144L0 464c0 26.5 21.5 48 48 48l272 0s0 0 0 0l-64 0 0-96c0-35.3 28.7-64 64-64l.3 0 .5 0c3.4-37.7 18.7-72.1 42.2-99.1C350.2 260 335.6 264 320 264c-48.6 0-88-39.4-88-88s39.4-88 88-88s88 39.4 88 88c0 18.3-5.6 35.3-15.1 49.4c29-21 64.6-33.4 103.1-33.4c59.5 0 112.1 29.6 144 74.8L640 144c0-26.5-21.5-48-48-48L473.7 96 337.8 5.4zM96 192l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zm0 128l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zM320 128c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm22.6-144l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L496 390.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L473.4 368l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L496 345.4l36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L518.6 368z"]
}, faArrowRightFromBracket = {
  prefix: "fas",
  iconName: "arrow-right-from-bracket",
  icon: [512, 512, ["sign-out"], "f08b", "M502.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 224 192 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l210.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128zM160 96c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 32C43 32 0 75 0 128L0 384c0 53 43 96 96 96l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l64 0z"]
}, faSignOut = faArrowRightFromBracket, faFaceFrownSlight = {
  prefix: "fas",
  iconName: "face-frown-slight",
  icon: [512, 512, [], "e376", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm91.9-117.5C330 373.8 299.4 352 256 352s-74 21.8-91.9 42.5c-5.8 6.7-15.9 7.4-22.6 1.6s-7.4-15.9-1.6-22.6c22.2-25.7 61-53.5 116.1-53.5s93.8 27.9 116.1 53.5c5.8 6.7 5.1 16.8-1.6 22.6s-16.8 5.1-22.6-1.6zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faCircleChevronDown = {
  prefix: "fas",
  iconName: "circle-chevron-down",
  icon: [512, 512, ["chevron-circle-down"], "f13a", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM135 241c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l87 87 87-87c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L273 345c-9.4 9.4-24.6 9.4-33.9 0L135 241z"]
}, faChevronCircleDown = faCircleChevronDown, faSidebarFlip = {
  prefix: "fas",
  iconName: "sidebar-flip",
  icon: [512, 512, [], "e24f", "M512 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-320zM288 96l0 320L64 416 64 96l224 0zm136 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0zm24 120c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0c13.3 0 24 10.7 24 24zm-24 72c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0z"]
}, faUnlockKeyhole = {
  prefix: "fas",
  iconName: "unlock-keyhole",
  icon: [448, 512, ["unlock-alt"], "f13e", "M224 64c-44.2 0-80 35.8-80 80l0 48 240 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 256c0-35.3 28.7-64 64-64l16 0 0-48C80 64.5 144.5 0 224 0c57.5 0 107 33.7 130.1 82.3c7.6 16 .8 35.1-15.2 42.6s-35.1 .8-42.6-15.2C283.4 82.6 255.9 64 224 64zm32 320c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0z"]
}, faUnlockAlt = faUnlockKeyhole, faTemperatureList = {
  prefix: "fas",
  iconName: "temperature-list",
  icon: [512, 512, [], "e299", "M96 112c0-26.5 21.5-48 48-48s48 21.5 48 48l0 164.5c0 17.3 7.1 31.9 15.3 42.5C217.8 332.6 224 349.5 224 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-18.5 6.2-35.4 16.7-48.9C88.9 308.4 96 293.8 96 276.5L96 112zM144 0C82.1 0 32 50.2 32 112l0 164.4c0 .1-.1 .3-.2 .6c-.2 .6-.8 1.6-1.7 2.8C11.2 304.2 0 334.8 0 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-33.2-11.2-63.8-30.1-88.1c-.9-1.2-1.5-2.2-1.7-2.8c-.1-.3-.2-.5-.2-.6L256 112C256 50.2 205.9 0 144 0zm0 416c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3L160 176c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 146.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48zM352 32c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L352 32zM320 192c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32zm64 96c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0z"]
}, faCloudShowersHeavy = {
  prefix: "fas",
  iconName: "cloud-showers-heavy",
  icon: [512, 512, [], "f740", "M96 320c-53 0-96-43-96-96c0-42.5 27.6-78.6 65.9-91.2C64.7 126.1 64 119.1 64 112C64 50.1 114.1 0 176 0c43.1 0 80.5 24.3 99.2 60c14.7-17.1 36.5-28 60.8-28c44.2 0 80 35.8 80 80c0 5.5-.6 10.8-1.6 16c.5 0 1.1 0 1.6 0c53 0 96 43 96 96s-43 96-96 96L96 320zM81.5 353.9c12.2 5.2 17.8 19.3 12.6 31.5l-48 112c-5.2 12.2-19.3 17.8-31.5 12.6S-3.3 490.7 1.9 478.5l48-112c5.2-12.2 19.3-17.8 31.5-12.6zm120 0c12.2 5.2 17.8 19.3 12.6 31.5l-48 112c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5l48-112c5.2-12.2 19.3-17.8 31.5-12.6zm244.6 31.5l-48 112c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5l48-112c5.2-12.2 19.3-17.8 31.5-12.6s17.8 19.3 12.6 31.5zM313.5 353.9c12.2 5.2 17.8 19.3 12.6 31.5l-48 112c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5l48-112c5.2-12.2 19.3-17.8 31.5-12.6z"]
}, faHeadphonesSimple = {
  prefix: "fas",
  iconName: "headphones-simple",
  icon: [512, 512, ["headphones-alt"], "f58f", "M256 80C141.1 80 48 173.1 48 288l0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24L0 288C0 146.6 114.6 32 256 32s256 114.6 256 256l0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104c0-114.9-93.1-208-208-208zM80 352c0-35.3 28.7-64 64-64l16 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-16 0c-35.3 0-64-28.7-64-64l0-64zm288-64c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64l-16 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l16 0z"]
}, faHeadphonesAlt = faHeadphonesSimple, faSitemap = {
  prefix: "fas",
  iconName: "sitemap",
  icon: [576, 512, [], "f0e8", "M208 80c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-8 0 0 40 152 0c30.9 0 56 25.1 56 56l0 32 8 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l8 0 0-32c0-4.4-3.6-8-8-8l-152 0 0 40 8 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l8 0 0-40-152 0c-4.4 0-8 3.6-8 8l0 32 8 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l8 0 0-32c0-30.9 25.1-56 56-56l152 0 0-40-8 0c-26.5 0-48-21.5-48-48l0-64z"]
}, faPipeSection = {
  prefix: "fas",
  iconName: "pipe-section",
  icon: [640, 512, [], "e438", "M32 96C14.3 96 0 110.3 0 128L0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-256c0-17.7-14.3-32-32-32zm576 0c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32s32-14.3 32-32l0-256c0-17.7-14.3-32-32-32zm-64 32L96 128l0 256 448 0 0-256z"]
}, faSpaceStationMoonConstruction = {
  prefix: "fas",
  iconName: "space-station-moon-construction",
  icon: [512, 512, ["space-station-moon-alt"], "e034", "M512 256c0 7.8-.3 15.5-1 23.1C438.8 304.7 351.2 320 256 320s-182.8-15.3-255-40.9c-.7-7.6-1-15.3-1-23.1C0 114.6 114.6 0 256 0c57.8 0 111.1 19.1 153.9 51.4c3.9 2.9 6.1 7.5 6.1 12.4L416 80c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l48 0 16 0c8.8 0 16 7.2 16 16l0 32c0 8.8 7.2 16 16 16l31.9 0c8.1 0 14.9 6 15.5 14.1c.4 5.9 .6 11.9 .6 17.9zM256 512C134.9 512 33.4 427.9 6.8 314.8C79.4 338.4 164.7 352 256 352c44.3 0 87.3-3.2 128-9.2l0 25.2c0 8.8 7.2 16 16 16l32 0c8.8 0 16 7.2 16 16l0 19.3c0 3.9-1.4 7.7-4.1 10.5C397.2 480.4 330.3 512 256 512zM160 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]
}, faSpaceStationMoonAlt = faSpaceStationMoonConstruction, faCircleDollarToSlot = {
  prefix: "fas",
  iconName: "circle-dollar-to-slot",
  icon: [512, 512, ["donate"], "f4b9", "M326.7 403.7c-22.1 8-45.9 12.3-70.7 12.3s-48.7-4.4-70.7-12.3l-.8-.3c-30-11-56.8-28.7-78.6-51.4C70 314.6 48 263.9 48 208C48 93.1 141.1 0 256 0S464 93.1 464 208c0 55.9-22 106.6-57.9 144c-1 1-2 2.1-3 3.1c-21.4 21.4-47.4 38.1-76.3 48.6zM256 91.9c-11.1 0-20.1 9-20.1 20.1l0 6c-5.6 1.2-10.9 2.9-15.9 5.1c-15 6.8-27.9 19.4-31.1 37.7c-1.8 10.2-.8 20 3.4 29c4.2 8.8 10.7 15 17.3 19.5c11.6 7.9 26.9 12.5 38.6 16l2.2 .7c13.9 4.2 23.4 7.4 29.3 11.7c2.5 1.8 3.4 3.2 3.7 4c.3 .8 .9 2.6 .2 6.7c-.6 3.5-2.5 6.4-8 8.8c-6.1 2.6-16 3.9-28.8 1.9c-6-1-16.7-4.6-26.2-7.9c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-2.2-.7-4.3-1.5-6.4-2.1c-10.5-3.5-21.8 2.2-25.3 12.7s2.2 21.8 12.7 25.3c1.2 .4 2.7 .9 4.4 1.5c7.9 2.7 20.3 6.9 29.8 9.1l0 6.4c0 11.1 9 20.1 20.1 20.1s20.1-9 20.1-20.1l0-5.5c5.3-1 10.5-2.5 15.4-4.6c15.7-6.7 28.4-19.7 31.6-38.7c1.8-10.4 1-20.3-3-29.4c-3.9-9-10.2-15.6-16.9-20.5c-12.2-8.8-28.3-13.7-40.4-17.4l-.8-.2c-14.2-4.3-23.8-7.3-29.9-11.4c-2.6-1.8-3.4-3-3.6-3.5c-.2-.3-.7-1.6-.1-5c.3-1.9 1.9-5.2 8.2-8.1c6.4-2.9 16.4-4.5 28.6-2.6c4.3 .7 17.9 3.3 21.7 4.3c10.7 2.8 21.6-3.5 24.5-14.2s-3.5-21.6-14.2-24.5c-4.4-1.2-14.4-3.2-21-4.4l0-6.3c0-11.1-9-20.1-20.1-20.1zM48 352l16 0c19.5 25.9 44 47.7 72.2 64L64 416l0 32 192 0 192 0 0-32-72.2 0c28.2-16.3 52.8-38.1 72.2-64l16 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48z"]
}, faDonate = faCircleDollarToSlot, faMemory = {
  prefix: "fas",
  iconName: "memory",
  icon: [576, 512, [], "f538", "M64 64C28.7 64 0 92.7 0 128l0 7.4c0 6.8 4.4 12.6 10.1 16.3C23.3 160.3 32 175.1 32 192s-8.7 31.7-21.9 40.3C4.4 236 0 241.8 0 248.6L0 320l576 0 0-71.4c0-6.8-4.4-12.6-10.1-16.3C552.7 223.7 544 208.9 544 192s8.7-31.7 21.9-40.3c5.7-3.7 10.1-9.5 10.1-16.3l0-7.4c0-35.3-28.7-64-64-64L64 64zM576 352L0 352l0 64c0 17.7 14.3 32 32 32l48 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 96 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 96 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 96 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 48 0c17.7 0 32-14.3 32-32l0-64zM192 160l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32z"]
}, faFaceSleeping = {
  prefix: "fas",
  iconName: "face-sleeping",
  icon: [512, 512, [], "e38d", "M512 256c0-46.6-12.5-90.3-34.2-128L432 128c-19.4 0-36.9-11.7-44.3-29.6c-7.1-17.1-3.7-36.7 8.6-50.4c-2.9-3.2-5.4-6.9-7.3-10.8C350.2 13.6 304.7 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512s256-114.6 256-256zM272 96c-8.8 0-16-7.2-16-16s7.2-16 16-16l64 0c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4L310.6 128l25.4 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4L297.4 96 272 96zM216 384a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM387.2 238.4c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0zm-262.4 0c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2zM416 16c0 8.8 7.2 16 16 16l25.4 0L420.7 68.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-25.4 0 36.7-36.7c4.6-4.6 5.9-11.5 3.5-17.4S502.5 0 496 0L432 0c-8.8 0-16 7.2-16 16z"]
}, faRoadSpikes = {
  prefix: "fas",
  iconName: "road-spikes",
  icon: [640, 512, [], "e568", "M64 116.8c0-15.8 20.5-22 29.3-8.9L192 256l0-139.2c0-15.8 20.5-22 29.3-8.9L320 256l0-139.2c0-15.8 20.5-22 29.3-8.9L448 256l0-139.2c0-15.8 20.5-22 29.3-8.9L606.8 302.2c14.2 21.3-1.1 49.7-26.6 49.7L512 352l-64 0-64 0-64 0-64 0-64 0L64 352l0-235.2zM32 384l576 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faFireBurner = {
  prefix: "fas",
  iconName: "fire-burner",
  icon: [640, 512, [], "e4f1", "M345.7 48.3L358 34.5c5.4-6.1 13.3-8.8 20.9-8.9c7.2 0 14.3 2.6 19.9 7.8c19.7 18.3 39.8 43.2 55 70.6C469 131.2 480 162.2 480 192.2C480 280.8 408.7 352 320 352c-89.6 0-160-71.3-160-159.8c0-37.3 16-73.4 36.8-104.5c20.9-31.3 47.5-59 70.9-80.2C273.4 2.3 280.7-.2 288 0c14.1 .3 23.8 11.4 32.7 21.6c0 0 0 0 0 0c2 2.3 4 4.6 6 6.7l19 19.9zM384 240.2c0-36.5-37-73-54.8-88.4c-5.4-4.7-13.1-4.7-18.5 0C293 167.1 256 203.6 256 240.2c0 35.3 28.7 64 64 64s64-28.7 64-64zM32 288c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 64 448 0 0-64c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 96c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l0-96zM320 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM192 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faSquirrel = {
  prefix: "fas",
  iconName: "squirrel",
  icon: [512, 512, [], "f71a", "M160 296.2c0 2-.7 3.9-2 5.4c-18.7 22.3-30 51-30 82.3c0 70.7 57.3 128 128 128l96 0 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0c10-13.4 16-30 16-48c0-26.2-12.6-49.4-32-64c-13.4-10-30-16-48-16c-9.4 0-18.3 1.6-26.7 4.5c-8.3 2.9-17.5-1.4-20.4-9.8s1.4-17.5 9.8-20.4c11.7-4.1 24.3-6.4 37.3-6.4c17.2 0 33.5 3.9 48 10.8l0-58.8 21.2 0c26.7 0 51.7-13.4 66.6-35.6L512 192c0-53-43-96-96-96l0-20.8C416 69 411 64 404.8 64c-15.2 0-28.7 7.6-36.8 19.2C359.9 71.6 346.4 64 331.2 64C325 64 320 69 320 75.2L320 96c0 54.4-10.5 108.1-30.7 158c-.9-2-1.3-4.2-1.3-6.4L288 144C288 64.5 223.5 0 144 0S0 64.5 0 144s64.5 144 144 144c2.3 0 4.6-.1 6.9-.2c4.9-.2 9.1 3.5 9.1 8.4zM416 144a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faArrowUpToLine = {
  prefix: "fas",
  iconName: "arrow-up-to-line",
  icon: [384, 512, ["arrow-to-top"], "f341", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zM214.6 169.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L160 269.3 160 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-178.7 73.4 73.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-128-128z"]
}, faArrowToTop = faArrowUpToLine, faFlag = {
  prefix: "fas",
  iconName: "flag",
  icon: [448, 512, [127988, 61725], "f024", "M64 32C64 14.3 49.7 0 32 0S0 14.3 0 32L0 64 0 368 0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 64.3-16.1c41.1-10.3 84.6-5.5 122.5 13.4c44.2 22.1 95.5 24.8 141.7 7.4l34.7-13c12.5-4.7 20.8-16.6 20.8-30l0-247.7c0-23-24.2-38-44.8-27.7l-9.6 4.8c-46.3 23.2-100.8 23.2-147.1 0c-35.1-17.6-75.4-22-113.5-12.5L64 48l0-16z"]
}, faFaceCowboyHat = {
  prefix: "fas",
  iconName: "face-cowboy-hat",
  icon: [512, 512, [], "e36e", "M216 0c9.1 0 17.9 4 26.1 10.7c7.9 6.5 19.8 6.5 27.7 0C278.1 4 286.9 0 296 0c36.8 0 67.4 64.9 82.4 109.8C412 99.3 442 84.6 466.9 66.8c2.5-1.8 5.4-2.8 8.4-2.8c8.9 0 15.6 8.3 12.9 16.7C461.2 163.2 367.5 224 256 224S50.8 163.2 23.8 80.7C21 72.3 27.7 64 36.7 64c3 0 6 1 8.4 2.8C70 84.6 100 99.3 133.6 109.8C148.6 64.9 179.2 0 216 0zM48 304c0-37.9 10.1-73.4 27.8-104c48.8 35.3 112.5 56 180.2 56s131.4-20.6 180.2-56c17.7 30.6 27.8 66.1 27.8 104c0 114.9-93.1 208-208 208S48 418.9 48 304zm299.8 60.7c-27.9 7.8-59 12.1-91.6 12.1s-63.7-4.3-91.6-12.1c-12.4-3.5-24.3 7.3-18.6 18.8C166.2 424.1 208 452 256.2 452s90-27.9 110.2-68.6c5.7-11.5-6.2-22.2-18.6-18.8zM216 304a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm104 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faHanukiah = {
  prefix: "fas",
  iconName: "hanukiah",
  icon: [640, 512, [128334], "f6e6", "M314.2 3.3C309.1 12.1 296 36.6 296 56c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7C324.6 1.2 322.4 0 320 0s-4.6 1.2-5.8 3.3zm-288 48C21.1 60.1 8 84.6 8 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7C36.6 49.2 34.4 48 32 48s-4.6 1.2-5.8 3.3zM88 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C101.1 60.1 88 84.6 88 104zm82.2-52.7C165.1 60.1 152 84.6 152 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3zM216 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C229.1 60.1 216 84.6 216 104zM394.2 51.3C389.1 60.1 376 84.6 376 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3zM440 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C453.1 60.1 440 84.6 440 104zm82.2-52.7C517.1 60.1 504 84.6 504 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3zM584 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C597.1 60.1 584 84.6 584 104zM112 160c-8.8 0-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96c0-8.8-7.2-16-16-16zm64 0c-8.8 0-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96c0-8.8-7.2-16-16-16zm64 0c-8.8 0-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96c0-8.8-7.2-16-16-16zm160 0c-8.8 0-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96c0-8.8-7.2-16-16-16zm64 0c-8.8 0-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96c0-8.8-7.2-16-16-16zm64 0c-8.8 0-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96c0-8.8-7.2-16-16-16zM352 144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 176L96 320c-17.7 0-32-14.3-32-32l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 53 43 96 96 96l192 0 0 64-128 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0 160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0 0-64 192 0c53 0 96-43 96-96l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 17.7-14.3 32-32 32l-192 0 0-176z"]
}, faChartScatter3d = {
  prefix: "fas",
  iconName: "chart-scatter-3d",
  icon: [512, 512, [], "e0e8", "M32 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM288 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 209L43.5 423.4c-13.6 11.3-15.4 31.5-4.1 45.1s31.5 15.4 45.1 4.1L256 329.7 427.5 472.6c13.6 11.3 33.8 9.5 45.1-4.1s9.5-33.8-4.1-45.1L288 273l0-209zm96 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm32 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64-64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM160 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM64 256A32 32 0 1 0 0 256a32 32 0 1 0 64 0zM256 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faDisplayChartUp = {
  prefix: "fas",
  iconName: "display-chart-up",
  icon: [576, 512, [], "e5e3", "M0 64C0 28.7 28.7 0 64 0L512 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-176 0 10.7 32 69.3 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l69.3 0L240 416 64 416c-35.3 0-64-28.7-64-64L0 64zm64 0l0 288 448 0 0-288L64 64zM376 96l80 0c13.3 0 24 10.7 24 24l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-22.1L321 289c-4.5 4.5-10.6 7-17 7s-12.5-2.5-17-7l-63-63-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L207 175c9.4-9.4 24.6-9.4 33.9 0l63 63L398.1 144 376 144c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faSquareCode = {
  prefix: "fas",
  iconName: "square-code",
  icon: [448, 512, [], "e267", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm262.2 71.9c-8.9 9.9-8.1 25 1.8 33.9L324.1 256l-60.2 54.2c-9.9 8.9-10.7 24-1.8 33.9s24 10.7 33.9 1.8l80-72c5.1-4.6 7.9-11 7.9-17.8s-2.9-13.3-7.9-17.8l-80-72c-9.9-8.9-25-8.1-33.9 1.8zm-78.1 33.9c9.9-8.9 10.7-24 1.8-33.9s-24-10.7-33.9-1.8l-80 72c-5.1 4.6-7.9 11-7.9 17.8s2.9 13.3 7.9 17.8l80 72c9.9 8.9 25 8.1 33.9-1.8s8.1-25-1.8-33.9L123.9 256l60.2-54.2z"]
}, faFeather = {
  prefix: "fas",
  iconName: "feather",
  icon: [512, 512, [129718], "f52d", "M278.5 215.6L23 471c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l57-57 68 0c49.7 0 97.9-14.4 139-41c11.1-7.2 5.5-23-7.8-23c-5.1 0-9.2-4.1-9.2-9.2c0-4.1 2.7-7.6 6.5-8.8l81-24.3c2.5-.8 4.8-2.1 6.7-4l22.4-22.4c10.1-10.1 2.9-27.3-11.3-27.3l-32.2 0c-5.1 0-9.2-4.1-9.2-9.2c0-4.1 2.7-7.6 6.5-8.8l112-33.6c4-1.2 7.4-3.9 9.3-7.7C506.4 207.6 512 184.1 512 160c0-41-16.3-80.3-45.3-109.3l-5.5-5.5C432.3 16.3 393 0 352 0s-80.3 16.3-109.3 45.3L139 149C91 197 64 262.1 64 330l0 55.3L253.6 195.8c6.2-6.2 16.4-6.2 22.6 0c5.4 5.4 6.1 13.6 2.2 19.8z"]
}, faVolumeLow = {
  prefix: "fas",
  iconName: "volume-low",
  icon: [448, 512, [128264, "volume-down"], "f027", "M301.1 34.8C312.6 40 320 51.4 320 64l0 384c0 12.6-7.4 24-18.9 29.2s-25 3.1-34.4-5.3L131.8 352 64 352c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l67.8 0L266.7 40.1c9.4-8.4 22.9-10.4 34.4-5.3zM412.6 181.5C434.1 199.1 448 225.9 448 256s-13.9 56.9-35.4 74.5c-10.3 8.4-25.4 6.8-33.8-3.5s-6.8-25.4 3.5-33.8C393.1 284.4 400 271 400 256s-6.9-28.4-17.7-37.3c-10.3-8.4-11.8-23.5-3.5-33.8s23.5-11.8 33.8-3.5z"]
}, faVolumeDown = faVolumeLow, faXmarkToSlot = {
  prefix: "fas",
  iconName: "xmark-to-slot",
  icon: [576, 512, ["times-to-slot", "vote-nay"], "f771", "M96 80c0-26.5 21.5-48 48-48l288 0c26.5 0 48 21.5 48 48l0 304L96 384 96 80zm145 47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47zM0 336c0-26.5 21.5-48 48-48l16 0 0 128 448 0 0-128 16 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48l0-96z"]
}, faTimesToSlot = faXmarkToSlot, faVoteNay = faXmarkToSlot, faBoxTaped = {
  prefix: "fas",
  iconName: "box-taped",
  icon: [448, 512, ["box-alt"], "f49a", "M50.7 58.5L0 160l160 0L192 32 93.7 32C75.5 32 58.9 42.3 50.7 58.5zM288 160l160 0L397.3 58.5C389.1 42.3 372.5 32 354.3 32L256 32l32 128zM160 192L0 192 0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-224-160 0 0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64z"]
}, faBoxAlt = faBoxTaped, faCommentSlash = {
  prefix: "fas",
  iconName: "comment-slash",
  icon: [640, 512, [], "f4b3", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L512.9 376.7C552.2 340.2 576 292.3 576 240C576 125.1 461.4 32 320 32c-67.7 0-129.3 21.4-175.1 56.3L38.8 5.1zm385.2 425L82.9 161.3C70.7 185.6 64 212.2 64 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c37 0 72.3-6.4 104.1-17.9z"]
}, faSwords = {
  prefix: "fas",
  iconName: "swords",
  icon: [512, 512, [9876], "f71d", "M96 329.4l50.7-50.7 86.6 86.6L182.6 416l20.7 20.7c6.2 6.2 6.2 16.4 0 22.6l-16 16c-4.7 4.7-11.8 6-17.8 3.3l-62-27.5L51.3 507.3c-6.2 6.2-16.4 6.2-22.6 0l-24-24c-6.2-6.2-6.2-16.4 0-22.6l56.2-56.2-27.5-62c-2.7-6.1-1.4-13.1 3.3-17.8l16-16c6.2-6.2 16.4-6.2 22.6 0L96 329.4zM484.5 114.2L365.3 233.4l-86.6-86.6L397.8 27.5c6.7-6.7 15.2-11.3 24.5-13.1L492.9 .3c5.2-1 10.7 .6 14.5 4.4s5.4 9.2 4.4 14.5L497.6 89.6c-1.9 9.3-6.4 17.8-13.1 24.5zM4.7 4.7C8.5 .9 13.9-.7 19.1 .3L89.6 14.4c9.3 1.9 17.8 6.4 24.5 13.1L393.4 306.7l-86.6 86.6L27.5 114.2c-6.7-6.7-11.3-15.2-13.1-24.5L.3 19.1C-.7 13.9 .9 8.5 4.7 4.7zm454.6 304l16 16c4.7 4.7 6 11.8 3.3 17.8l-27.5 62 56.2 56.2c6.2 6.2 6.2 16.4 0 22.6l-24 24c-6.2 6.2-16.4 6.2-22.6 0l-56.2-56.2-62 27.5c-6.1 2.7-13.1 1.4-17.8-3.3l-16-16c-6.2-6.2-6.2-16.4 0-22.6l128-128c6.2-6.2 16.4-6.2 22.6 0z"]
}, faCloudSunRain = {
  prefix: "fas",
  iconName: "cloud-sun-rain",
  icon: [640, 512, [127782], "f743", "M294.2 1.2c5.1 2.1 8.7 6.7 9.6 12.1l10.4 62.4c-23.3 10.8-42.9 28.4-56 50.3c-14.6-9-31.8-14.1-50.2-14.1c-53 0-96 43-96 96c0 35.5 19.3 66.6 48 83.2c.8 31.8 13.2 60.7 33.1 82.7l-56 39.2c-4.5 3.2-10.3 3.8-15.4 1.6s-8.7-6.7-9.6-12.1L98.1 317.9 13.4 303.8c-5.4-.9-10-4.5-12.1-9.6s-1.5-10.9 1.6-15.4L52.5 208 2.9 137.2c-3.2-4.5-3.8-10.3-1.6-15.4s6.7-8.7 12.1-9.6L98.1 98.1l14.1-84.7c.9-5.4 4.5-10 9.6-12.1s10.9-1.5 15.4 1.6L208 52.5 278.8 2.9c4.5-3.2 10.3-3.8 15.4-1.6zM208 144c13.8 0 26.7 4.4 37.1 11.9c-1.2 4.1-2.2 8.3-3 12.6c-37.9 14.6-67.2 46.6-77.8 86.4C151.8 243.1 144 226.5 144 208c0-35.3 28.7-64 64-64zm69.4 276c11 7.4 14 22.3 6.7 33.3l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7zm96 0c11 7.4 14 22.3 6.7 33.3l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7zm96 0c11 7.4 14 22.3 6.7 33.3l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7zm96 0c11 7.4 14 22.3 6.7 33.3l-32 48c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l32-48c7.4-11 22.3-14 33.3-6.7zm74.5-116.1c0 44.2-35.8 80-80 80l-271.9 0c-53 0-96-43-96-96c0-47.6 34.6-87 80-94.6l0-1.3c0-53 43-96 96-96c34.9 0 65.4 18.6 82.2 46.4c13-9.1 28.8-14.4 45.8-14.4c44.2 0 80 35.8 80 80c0 5.9-.6 11.7-1.9 17.2c37.4 6.7 65.8 39.4 65.8 78.7z"]
}, faAlbum = {
  prefix: "fas",
  iconName: "album",
  icon: [448, 512, [128189], "f89f", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM384 256A160 160 0 1 0 64 256a160 160 0 1 0 320 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faCircleN = {
  prefix: "fas",
  iconName: "circle-n",
  icon: [512, 512, [], "e118", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM203.7 138.3L304 283.2 304 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 208c0 10.5-6.8 19.8-16.8 22.9s-20.9-.6-26.9-9.2L208 228.8 208 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-10.5 6.8-19.8 16.8-22.9s20.9 .6 26.9 9.2z"]
}, faCompress = {
  prefix: "fas",
  iconName: "compress",
  icon: [448, 512, [], "f066", "M160 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-96zM32 320c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-96 0zM352 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-64zM320 320c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0z"]
}, faWheatAwn = {
  prefix: "fas",
  iconName: "wheat-awn",
  icon: [512, 512, ["wheat-alt"], "e2cd", "M505 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L383 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l88-88zM305.5 27.3c-6.2-6.2-16.4-6.2-22.6 0L271.5 38.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8l-11.3-11.3c-6.2-6.2-16.4-6.2-22.6 0l-11.3 11.3c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8L101.8 231c-6.2-6.2-16.4-6.2-22.6 0L67.9 242.3c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4L9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l68.9-68.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6l-11.3-11.3c-21.8-21.8-49.6-34.1-78.1-36.9l31.9-31.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6l-11.3-11.3c-21.8-21.8-49.6-34.1-78.1-36.9l31.9-31.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0L486.5 231c6.2-6.2 6.2-16.4 0-22.6L475.2 197c-5.2-5.2-10.6-9.8-16.4-13.9L505 137c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-59.4 59.4c-20.6-4.4-42-3.7-62.3 2.1c6.1-21.3 6.6-43.8 1.4-65.3L409 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L329.1 52.9c-3.7-5-7.8-9.8-12.4-14.3L305.5 27.3z"]
}, faWheatAlt = faWheatAwn, faAnkh = {
  prefix: "fas",
  iconName: "ankh",
  icon: [320, 512, [9765], "f644", "M96 128c0-35.3 28.7-64 64-64s64 28.7 64 64c0 41.6-20.7 76.6-46.6 104.1c-5.9 6.2-11.8 11.8-17.4 16.7c-5.6-4.9-11.5-10.5-17.4-16.7C116.7 204.6 96 169.6 96 128zM160 0C89.3 0 32 57.3 32 128c0 52.4 21.5 95.5 46.8 128L32 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-46.8 0c25.4-32.5 46.8-75.6 46.8-128C288 57.3 230.7 0 160 0z"]
}, faHandsHoldingChild = {
  prefix: "fas",
  iconName: "hands-holding-child",
  icon: [640, 512, [], "e4fa", "M320 0a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm44.7 164.3L375.8 253c1.6 13.2-7.7 25.1-20.8 26.8s-25.1-7.7-26.8-20.8l-4.4-35-7.6 0-4.4 35c-1.6 13.2-13.6 22.5-26.8 20.8s-22.5-13.6-20.8-26.8l11.1-88.8L255.5 181c-10.1 8.6-25.3 7.3-33.8-2.8s-7.3-25.3 2.8-33.8l27.9-23.6C271.3 104.8 295.3 96 320 96s48.7 8.8 67.6 24.7l27.9 23.6c10.1 8.6 11.4 23.7 2.8 33.8s-23.7 11.4-33.8 2.8l-19.8-16.7zM40 64c22.1 0 40 17.9 40 40l0 40 0 80 0 40.2c0 17 6.7 33.3 18.7 45.3l51.1 51.1c8.3 8.3 21.3 9.6 31 3.1c12.9-8.6 14.7-26.9 3.7-37.8l-15.2-15.2-32-32c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l32 32 15.2 15.2c0 0 0 0 0 0l25.3 25.3c21 21 32.8 49.5 32.8 79.2l0 78.9c0 26.5-21.5 48-48 48l-66.7 0c-17 0-33.3-6.7-45.3-18.7L28.1 393.4C10.1 375.4 0 351 0 325.5L0 224l0-64 0-56C0 81.9 17.9 64 40 64zm560 0c22.1 0 40 17.9 40 40l0 56 0 64 0 101.5c0 25.5-10.1 49.9-28.1 67.9L512 493.3c-12 12-28.3 18.7-45.3 18.7L400 512c-26.5 0-48-21.5-48-48l0-78.9c0-29.7 11.8-58.2 32.8-79.2l25.3-25.3c0 0 0 0 0 0l15.2-15.2 32-32c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-32 32-15.2 15.2c-11 11-9.2 29.2 3.7 37.8c9.7 6.5 22.7 5.2 31-3.1l51.1-51.1c12-12 18.7-28.3 18.7-45.3l0-40.2 0-80 0-40c0-22.1 17.9-40 40-40z"]
}, faAsterisk = {
  prefix: "fas",
  iconName: "asterisk",
  icon: [384, 512, [10033, 61545], "2a", "M192 32c17.7 0 32 14.3 32 32l0 135.5 111.5-66.9c15.2-9.1 34.8-4.2 43.9 11s4.2 34.8-11 43.9L254.2 256l114.3 68.6c15.2 9.1 20.1 28.7 11 43.9s-28.7 20.1-43.9 11L224 312.5 224 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-135.5L48.5 379.4c-15.2 9.1-34.8 4.2-43.9-11s-4.2-34.8 11-43.9L129.8 256 15.5 187.4c-15.2-9.1-20.1-28.7-11-43.9s28.7-20.1 43.9-11L160 199.5 160 64c0-17.7 14.3-32 32-32z"]
}, faKeySkeletonLeftRight = {
  prefix: "fas",
  iconName: "key-skeleton-left-right",
  icon: [640, 512, [], "e3b4", "M576 128a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zm64 0c0 70.7-57.3 128-128 128c-59.6 0-109.8-40.8-124-96l-68 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-32 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l196 0C402.2 40.8 452.4 0 512 0c70.7 0 128 57.3 128 128zM64 384a64 64 0 1 0 128 0A64 64 0 1 0 64 384zM0 384c0-70.7 57.3-128 128-128c59.6 0 109.8 40.8 124 96l68 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 32 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-196 0c-14.2 55.2-64.3 96-124 96C57.3 512 0 454.7 0 384z"]
}, faCommentLines = {
  prefix: "fas",
  iconName: "comment-lines",
  icon: [512, 512, [], "f4b0", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM152 176l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm0 96l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faLuchadorMask = {
  prefix: "fas",
  iconName: "luchador-mask",
  icon: [448, 512, ["luchador", "mask-luchador"], "f455", "M224 0C100.3 0 0 100.3 0 224l0 96C0 426 86 512 192 512l64 0c106 0 192-86 192-192l0-96C448 100.3 347.7 0 224 0zM128 384c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-35.3 0-57.4 0L160 352c-17.7 0-32 14.3-32 32zm-32 0c0-33.2 25.2-60.5 57.6-63.7c-1-3.7-1.6-7.6-1.6-11.6c0-7.3 1.8-14.4 5.3-20.7L144 288c-44.2 0-80-35.8-80-80c0-26.5 21.5-48 48-48l32 0c44.2 0 80 35.8 80 80c0-44.2 35.8-80 80-80l32 0c26.5 0 48 21.5 48 48c0 44.2-35.8 80-80 80l-13.3 0c3.4 6.3 5.3 13.4 5.3 20.7c0 4-.6 7.9-1.6 11.6c32.3 3.2 57.6 30.5 57.6 63.7c0 35.3-28.7 64-64 64l-128 0c-35.3 0-64-28.7-64-64zm156.7-64l.2 0c6.1 0 11.1-5 11.1-11.1l0-.1 0-.1c0-3-1.2-5.9-3.3-8l-8-8-4.2-4.2-.4-.4-10.3-10.3C234 274 229.1 272 224 272s-10 2-13.7 5.7L200 288l-.4 .4-4.2 4.2-8 8c-2.1 2.1-3.3 5-3.3 8l0 .1 0 .1c0 6.1 5 11.1 11.1 11.1l.2 0 11.3 0 6 0 .6 0 21.5 0 .6 0 6 0 11.3 0zM112 192c-8.8 0-16 7.2-16 16c0 26.5 21.5 48 48 48l32 0c8.8 0 16-7.2 16-16c0-26.5-21.5-48-48-48l-32 0zm240 16c0-8.8-7.2-16-16-16l-32 0c-26.5 0-48 21.5-48 48c0 8.8 7.2 16 16 16l32 0c26.5 0 48-21.5 48-48z"]
}, faLuchador = faLuchadorMask, faMaskLuchador = faLuchadorMask, faSquareCheck = {
  prefix: "fas",
  iconName: "square-check",
  icon: [448, 512, [9745, 9989, 61510, "check-square"], "f14a", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM337 209L209 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L303 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]
}, faCheckSquare = faSquareCheck, faShredder = {
  prefix: "fas",
  iconName: "shredder",
  icon: [512, 512, [], "f68a", "M64 64C64 28.7 92.7 0 128 0L354.7 0c17 0 33.3 6.7 45.3 18.7L429.3 48c12 12 18.7 28.3 18.7 45.3l0 98.7c35.3 0 64 28.7 64 64l0 96c0 17.7-14.3 32-32 32L32 384c-17.7 0-32-14.3-32-32l0-96c0-35.3 28.7-64 64-64L64 64zM384 93.3L354.7 64 128 64l0 128 256 0 0-98.7zM432 296a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM40 416l48 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72zm96 0l48 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72zm96 0l48 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72zm96 0l48 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72zm96 0l48 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72z"]
}, faBookOpenCover = {
  prefix: "fas",
  iconName: "book-open-cover",
  icon: [640, 512, ["book-open-alt"], "e0c0", "M304 32l0 376L96 368 96 34.7C96 14.9 113.8-.2 133.3 3.1L304 32zM89.7 405.1L320 451.2l230.3-46.1c15-3 25.7-16.1 25.7-31.4l0-345 25.7-5.1C621.5 19.7 640 34.8 640 55l0 366.7c0 15.3-10.8 28.4-25.7 31.4L320 512 25.7 453.1C10.8 450.2 0 437 0 421.8L0 55C0 34.8 18.5 19.7 38.3 23.7L64 28.8l0 345c0 15.3 10.8 28.4 25.7 31.4zM336 408l0-376L506.7 3.1C526.2-.2 544 14.9 544 34.7L544 368 336 408z"]
}, faBookOpenAlt = faBookOpenCover, faSandwich = {
  prefix: "fas",
  iconName: "sandwich",
  icon: [512, 512, [129386], "f81f", "M0 96C0 78.3 14.3 64 32 64l448 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32L32 176c-17.7 0-32-14.3-32-32L0 96zM303.9 382.6c10 5.8 22.3 5.8 32.2 0l70.2-40.9c6.4-3.7 13.6-5.7 20.9-5.7l4.8 0 48 0c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32l176 0 4.8 0c7.4 0 14.6 2 20.9 5.7l70.2 40.9zM32 304c-17.7 0-32-14.3-32-32s14.3-32 32-32c7.2 0 15.8-3.7 35.4-13c16.6-7.8 40.6-19 68.6-19c30.6 0 53 10.2 70.1 18l1.9 .9c17.2 7.8 29.7 13.1 48.1 13.1s30.9-5.3 48.1-13.1l1.9-.9c17-7.8 39.4-18 70.1-18c28 0 52.1 11.3 68.6 19c19.6 9.2 28.2 13 35.4 13c17.7 0 32 14.3 32 32s-14.3 32-32 32c-22.7 0-44.3-10.3-58.8-17.2c0 0 0 0 0 0c-1.3-.6-2.6-1.2-3.8-1.8c-17.4-8.2-29.4-13-41.4-13c-16.2 0-27.5 5-45.4 13.1c0 0 0 0-.1 0c-18 8.2-41.4 18.9-74.5 18.9s-56.6-10.7-74.5-18.9c0 0 0 0-.1 0C163.5 277 152.2 272 136 272c-12 0-23.9 4.7-41.4 13c-1.2 .6-2.5 1.2-3.8 1.8C76.3 293.7 54.7 304 32 304z"]
}, faPesetaSign = {
  prefix: "fas",
  iconName: "peseta-sign",
  icon: [384, 512, [], "e221", "M64 32C46.3 32 32 46.3 32 64l0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 96 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 96 0c77.4 0 142-55 156.8-128l3.2 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-3.2 0C334 87 269.4 32 192 32L64 32zM282.5 160L96 160l0-64 96 0c41.8 0 77.4 26.7 90.5 64zM96 224l186.5 0c-13.2 37.3-48.7 64-90.5 64l-96 0 0-64z"]
}, faSquareParkingSlash = {
  prefix: "fas",
  iconName: "square-parking-slash",
  icon: [640, 512, ["parking-slash"], "f617", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-86.8-68L544 96c0-35.3-28.7-64-64-64L160 32c-21.6 0-40.7 10.7-52.3 27.1L38.8 5.1zM227 152.7c6-14.5 20.3-24.7 37-24.7l72 0c53 0 96 43 96 96c0 26.3-10.6 50.2-27.8 67.5l-51.4-40.3c9.1-5.6 15.2-15.7 15.2-27.2c0-17.7-14.3-32-32-32l-48 0 0 8.4-61-47.8zm259.9 327L288 322.9l0 29.1c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64 0-15.5L96 171.6 96 416c0 35.3 28.7 64 64 64l320 0c2.3 0 4.6-.1 6.9-.4z"]
}, faParkingSlash = faSquareParkingSlash, faTrainTunnel = {
  prefix: "fas",
  iconName: "train-tunnel",
  icon: [512, 512, [], "e454", "M256 0C114.6 0 0 114.6 0 256L0 448c0 35.3 28.7 64 64 64l41.4 0 64.3-64.3C137.3 444.5 112 417.2 112 384l0-192c0-35.3 28.7-64 64-64l160 0c35.3 0 64 28.7 64 64l0 192c0 33.2-25.3 60.5-57.7 63.7L406.6 512l41.4 0c35.3 0 64-28.7 64-64l0-192C512 114.6 397.4 0 256 0zM361.4 512l-64-64-82.7 0-64 64 210.7 0zM184 192c-13.3 0-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24l0-80c0-13.3-10.7-24-24-24l-144 0zM288 384a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faHeading = {
  prefix: "fas",
  iconName: "heading",
  icon: [448, 512, ["header"], "f1dc", "M0 64C0 46.3 14.3 32 32 32l48 0 48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0 0 112 224 0 0-112-16 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l48 0 48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0 0 144 0 176 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-144-224 0 0 144 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-176L48 96 32 96C14.3 96 0 81.7 0 64z"]
}, faHeader = faHeading, faGhost = {
  prefix: "fas",
  iconName: "ghost",
  icon: [384, 512, [128123], "f6e2", "M40.1 467.1l-11.2 9c-3.2 2.5-7.1 3.9-11.1 3.9C8 480 0 472 0 462.2L0 192C0 86 86 0 192 0S384 86 384 192l0 270.2c0 9.8-8 17.8-17.8 17.8c-4 0-7.9-1.4-11.1-3.9l-11.2-9c-13.4-10.7-32.8-9-44.1 3.9L269.3 506c-3.3 3.8-8.2 6-13.3 6s-9.9-2.2-13.3-6l-26.6-30.5c-12.7-14.6-35.4-14.6-48.2 0L141.3 506c-3.3 3.8-8.2 6-13.3 6s-9.9-2.2-13.3-6L84.2 471c-11.3-12.9-30.7-14.6-44.1-3.9zM160 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faFaceAnguished = {
  prefix: "fas",
  iconName: "face-anguished",
  icon: [512, 512, [], "e369", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-192c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16c0-44.2 35.8-80 80-80zM144.4 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM192 128c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16zm141 .9c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8z"]
}, faHockeySticks = {
  prefix: "fas",
  iconName: "hockey-sticks",
  icon: [640, 512, [], "f454", "M220.6 17.7l82.3 164.6-35.8 71.6L163.4 46.3c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3zM372.8 322.1L387.8 352 544 352l0 128 0 32-64 0s0 0 0 0l-44.2 0c-24.2 0-46.4-13.7-57.2-35.4l-41.5-83 35.8-71.6zM576 352l32 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-32 0 0-160zM462.3 3.4c15.8 7.9 22.2 27.1 14.3 42.9L261.5 476.6c-10.8 21.7-33 35.4-57.2 35.4L160 512l-32 0-32 0 0-32 0-128 156.2 0L419.4 17.7c7.9-15.8 27.1-22.2 42.9-14.3zM0 384c0-17.7 14.3-32 32-32l32 0 0 160-32 0c-17.7 0-32-14.3-32-32l0-96z"]
}, faAbacus = {
  prefix: "fas",
  iconName: "abacus",
  icon: [576, 512, [129518], "f640", "M512 96l0 112-64 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-32 64 0zm-96 32l-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-128 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-32 128 0 0 32zm-160 0l-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-96 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-32 96 0 0 32zm-128 0l-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-64 0L64 96l64 0 0 32zM64 416l0-176 64 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-64 0zm96-32l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24 96 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 24-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-96 0 0-32zm128-72l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24 128 0 0 96-8 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l8 0 0 32-128 0 0-32 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-24zm160 72l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0-96 64 0 0 176-64 0 0-32zM64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32z"]
}, faFilmSimple = {
  prefix: "fas",
  iconName: "film-simple",
  icon: [512, 512, ["film-alt"], "f3a0", "M384 32L128 32l0 48c0 8.8-7.2 16-16 16L80 96c-8.8 0-16-7.2-16-16l0-48C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l0-48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48 256 0 0-48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48zM64 176c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm336-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM64 304c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm336-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16z"]
}, faFilmAlt = faFilmSimple, faList = {
  prefix: "fas",
  iconName: "list",
  icon: [512, 512, ["list-squares"], "f03a", "M40 48C26.7 48 16 58.7 16 72l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24L40 48zM192 64c-17.7 0-32 14.3-32 32s14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L192 64zm0 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-288 0zm0 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-288 0zM16 232l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zM40 368c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0z"]
}, faListSquares = faList, faTreePalm = {
  prefix: "fas",
  iconName: "tree-palm",
  icon: [576, 512, [127796], "f82b", "M102.9 91.4l30.3 50.5c-4 3.5-8 7.2-12 11.2c-71 71-60.2 151-32.7 191.3c5 7.3 15.2 7.3 21.4 1L248.4 206.9c4 10.8 7.8 26.2 9.7 47.2c4.2 46.5-1.6 116.8-32.7 216.4c-3 9.7-1.3 20.3 4.8 28.5s15.6 13 25.8 13l64 0c16.1 0 29.8-12 31.8-28c12.4-99-2.3-207.2-31.7-292l126.6 0c2.8 0 5.4-1.5 6.9-3.9l19.6-32.7c3.1-5.2 10.6-5.2 13.7 0l19.6 32.7c1.4 2.4 4 3.9 6.9 3.9l46.7 0c8.8 0 16.1-7.2 14.4-15.9C565.3 128.2 516.4 64 416 64c-43.7 0-77.6 12.2-102.8 29.8C296.5 49.4 248 0 160 0C59.6 0 10.7 64.2 1.6 112.1C-.1 120.8 7.2 128 16 128l46.7 0c2.8 0 5.4-1.5 6.9-3.9L89.1 91.4c3.1-5.2 10.6-5.2 13.7 0z"]
}, faSquarePhoneFlip = {
  prefix: "fas",
  iconName: "square-phone-flip",
  icon: [448, 512, ["phone-square-alt"], "f87b", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zm-90.7 96.7c-9.7-2.6-19.9 2.3-23.7 11.6l-20 48c-3.4 8.2-1 17.6 5.8 23.2L280 231.7c-16.6 35.2-45.1 63.7-80.3 80.3l-20.2-24.7c-5.6-6.8-15-9.2-23.2-5.8l-48 20c-9.3 3.9-14.2 14-11.6 23.7l12 44C111.1 378 119 384 128 384c123.7 0 224-100.3 224-224c0-9-6-16.9-14.7-19.3l-44-12z"]
}, faPhoneSquareAlt = faSquarePhoneFlip, faUserBeardBolt = {
  prefix: "fas",
  iconName: "user-beard-bolt",
  icon: [576, 512, [], "e689", "M198.9 0L224 0l25.1 0C305.9 0 352 46.1 352 102.9c0 6 1 12 3.1 17.6l25.2 69.3c2.4 6.7 3.7 13.8 3.7 21c0 24.6-14.6 46-35.7 55.7c2.4 6.7 3.7 14 3.7 21.5c0 15.2-5.3 29.3-14.2 40.2C326 342.7 308.1 352 288 352c-6.3 0-12.4-.9-18.2-2.6c-.8-.2-1.6-.5-2.4-.8C259.7 364.8 243.1 376 224 376s-35.7-11.2-43.4-27.4c-6.5 2.2-13.4 3.4-20.6 3.4c-19.9 0-37.6-9.1-49.4-23.3l-.4-.5c-8.9-11-14.2-25-14.2-40.2c0-7.5 1.3-14.8 3.7-21.5c-21.1-9.7-35.7-31-35.7-55.7c0-7.1 1.2-14.3 3.7-21l25.2-69.3c2-5.6 3.1-11.6 3.1-17.6C96 46.1 142.1 0 198.9 0zM304 128c0-11.4-2.4-22.2-6.7-32L280 96c-24.1 0-45.1-13.3-56-33c-10.9 19.7-31.9 33-56 33l-17.3 0c-4.3 9.8-6.7 20.6-6.7 32l0 16c0 12.5 2.9 24.4 8 35c.9-.5 1.8-1.1 2.6-1.8l.6-.6c18.2-18.2 43-28.5 68.8-28.5s50.5 10.2 68.8 28.5l.6 .6c.8 .8 1.6 1.4 2.6 1.8c5.1-10.6 8-22.4 8-35l0-16zm-34.2 81.6c-1.6-1.3-3.2-2.7-4.7-4.2l-.6-.6C253.7 194 239.2 188 224 188s-29.7 6-40.5 16.8l-.6 .6c-1.5 1.5-3.1 2.9-4.7 4.2c2.6 1.8 5.2 3.4 8 4.9c11.3 6.1 24.2 9.5 37.9 9.5s26.6-3.4 37.9-9.5c2.8-1.5 5.4-3.1 8-4.9zM160 384c2.2 0 4.5-.1 6.7-.2C181.2 398.7 201.5 408 224 408s42.8-9.3 57.3-24.2c2.2 .2 4.4 .2 6.7 .2c11.6 0 22.8-2.1 33.1-5.9c.4 1.9 1 3.8 1.6 5.7c6.7 19.2 24.9 32.1 45.3 32.1l18.3 0-29.3 58.5c-6 12-6.5 25.5-2.3 37.5l-324 0C13.8 512 0 498.2 0 481.3c0-59.6 32.3-111.7 80.4-139.6C97.7 367.2 126.9 384 160 384zM538.1 227.6c5.8 4.7 7.6 12.9 4.2 19.6L489.9 352l70.1 0c6.8 0 12.9 4.3 15.1 10.7s.2 13.5-5.1 17.8l-160 128c-5.9 4.7-14.2 4.7-20.1-.1s-7.6-12.9-4.3-19.6L438.1 384 368 384c-6.8 0-12.8-4.3-15.1-10.7s-.2-13.5 5.1-17.8l160-128c5.9-4.7 14.2-4.7 20.1 .1z"]
}, faCartPlus = {
  prefix: "fas",
  iconName: "cart-plus",
  icon: [576, 512, [], "f217", "M0 24C0 10.7 10.7 0 24 0L69.5 0c22 0 41.5 12.8 50.6 32l411 0c26.3 0 45.5 25 38.6 50.4l-41 152.3c-8.5 31.4-37 53.3-69.5 53.3l-288.5 0 5.4 28.5c2.2 11.3 12.1 19.5 23.6 19.5L488 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-288.3 0c-34.6 0-64.3-24.6-70.7-58.5L77.4 54.5c-.7-3.8-4-6.5-7.9-6.5L24 48C10.7 48 0 37.3 0 24zM128 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm336-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM252 160c0 11 9 20 20 20l44 0 0 44c0 11 9 20 20 20s20-9 20-20l0-44 44 0c11 0 20-9 20-20s-9-20-20-20l-44 0 0-44c0-11-9-20-20-20s-20 9-20 20l0 44-44 0c-11 0-20 9-20 20z"]
}, faGamepad = {
  prefix: "fas",
  iconName: "gamepad",
  icon: [640, 512, [], "f11b", "M192 64C86 64 0 150 0 256S86 448 192 448l256 0c106 0 192-86 192-192s-86-192-192-192L192 64zM496 168a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM392 304a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM168 200c0-13.3 10.7-24 24-24s24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-32z"]
}, faBorderCenterV = {
  prefix: "fas",
  iconName: "border-center-v",
  icon: [448, 512, [], "f89d", "M448 448a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM64 352A32 32 0 1 0 0 352a32 32 0 1 0 64 0zM384 160a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM64 160A32 32 0 1 0 0 160a32 32 0 1 0 64 0zm320 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM64 256A32 32 0 1 0 0 256a32 32 0 1 0 64 0zM384 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM0 64a32 32 0 1 0 64 0A32 32 0 1 0 0 64zM64 448A32 32 0 1 0 0 448a32 32 0 1 0 64 0zM288 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM352 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM288 448a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM160 64A32 32 0 1 0 96 64a32 32 0 1 0 64 0zM96 448a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64-192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm32 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384z"]
}, faCircleDot = {
  prefix: "fas",
  iconName: "circle-dot",
  icon: [512, 512, [128280, "dot-circle"], "f192", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-352a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]
}, faDotCircle = faCircleDot, faClipboardMedical = {
  prefix: "fas",
  iconName: "clipboard-medical",
  icon: [384, 512, [], "e133", "M192 0c-41.8 0-77.4 26.7-90.5 64L64 64C28.7 64 0 92.7 0 128L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l-37.5 0C269.4 26.7 233.8 0 192 0zm0 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM160 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48 48 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l48 0 0-48z"]
}, faFaceDizzy = {
  prefix: "fas",
  iconName: "face-dizzy",
  icon: [512, 512, ["dizzy"], "f567", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-224a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM100.7 132.7c6.2-6.2 16.4-6.2 22.6 0L160 169.4l36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L182.6 192l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L160 214.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L137.4 192l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6zm192 0c6.2-6.2 16.4-6.2 22.6 0L352 169.4l36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L374.6 192l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L352 214.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L329.4 192l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6z"]
}, faDizzy = faFaceDizzy, faEgg = {
  prefix: "fas",
  iconName: "egg",
  icon: [384, 512, [129370], "f7fb", "M192 496C86 496 0 394 0 288C0 176 64 16 192 16s192 160 192 272c0 106-86 208-192 208zM154.8 134c6.5-6 7-16.1 1-22.6s-16.1-7-22.6-1c-23.9 21.8-41.1 52.7-52.3 84.2C69.7 226.1 64 259.7 64 288c0 8.8 7.2 16 16 16s16-7.2 16-16c0-24.5 5-54.4 15.1-82.8c10.1-28.5 25-54.1 43.7-71.2z"]
}, faUpToLine = {
  prefix: "fas",
  iconName: "up-to-line",
  icon: [384, 512, ["arrow-alt-to-top"], "f34d", "M342.1 262.1L219.3 139.3c-7.2-7.2-17.1-11.3-27.3-11.3s-20.1 4.1-27.3 11.3L41.9 262.1c-6.4 6.4-9.9 15-9.9 24C32 304.8 47.2 320 65.9 320l62.1 0 0 128c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-128 62.1 0c18.7 0 33.9-15.2 33.9-33.9c0-9-3.6-17.6-9.9-24zM32 96l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64S14.3 96 32 96z"]
}, faArrowAltToTop = faUpToLine, faHouseMedicalCircleXmark = {
  prefix: "fas",
  iconName: "house-medical-circle-xmark",
  icon: [640, 512, [], "e513", "M320 368c0 59.5 29.5 112.1 74.8 144l-266.7 0c-35.3 0-64-28.7-64-64l0-160.4-32 0c-18 0-32-14-32-32.1c0-9 3-17 10-24L266.4 8c7-7 15-8 22-8s15 2 21 7L522.1 193.9c-8.5-1.3-17.3-1.9-26.1-1.9c-54.7 0-103.5 24.9-135.8 64L320 256l0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zM496 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm22.6 144l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368z"]
}, faWatchFitness = {
  prefix: "fas",
  iconName: "watch-fitness",
  icon: [384, 512, [], "f63e", "M64 48C64 21.5 85.5 0 112 0L272 0c26.5 0 48 21.5 48 48L64 48zm0 416l256 0c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48zM0 160c0-44.2 35.8-80 80-80l224 0c44.2 0 80 35.8 80 80l0 192c0 44.2-35.8 80-80 80L80 432c-44.2 0-80-35.8-80-80L0 160zm141.3 0C107.4 160 80 187.4 80 221.3c0 16.2 6.5 31.8 17.9 43.3l82.7 82.7c6.2 6.2 16.4 6.2 22.6 0l82.7-82.7c11.5-11.5 17.9-27.1 17.9-43.3c0-33.8-27.4-61.3-61.3-61.3c-16.2 0-31.8 6.5-43.3 17.9l-7.4 7.4-7.4-7.4c-11.5-11.5-27.1-17.9-43.3-17.9z"]
}, faClockNineThirty = {
  prefix: "fas",
  iconName: "clock-nine-thirty",
  icon: [512, 512, [], "e34d", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120l0-136c0-13.3-10.7-24-24-24l-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0 0 112c0 13.3 10.7 24 24 24s24-10.7 24-24z"]
}, faCampground = {
  prefix: "fas",
  iconName: "campground",
  icon: [576, 512, [9978], "f6bb", "M377 52c11-13.8 8.8-33.9-5-45s-33.9-8.8-45 5L288 60.8 249 12c-11-13.8-31.2-16-45-5s-16 31.2-5 45l48 60L12.3 405.4C4.3 415.4 0 427.7 0 440.4L0 464c0 26.5 21.5 48 48 48l240 0 240 0c26.5 0 48-21.5 48-48l0-23.6c0-12.7-4.3-25.1-12.3-35L329 112l48-60zM288 448l-119.5 0L288 291.7 407.5 448 288 448z"]
}, faFolderPlus = {
  prefix: "fas",
  iconName: "folder-plus",
  icon: [512, 512, [], "f65e", "M512 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l128 0c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8l160 0c35.3 0 64 28.7 64 64l0 256zM232 376c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 64z"]
}, faJug = {
  prefix: "fas",
  iconName: "jug",
  icon: [448, 512, [], "f8c6", "M160 0L288 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L160 64c-17.7 0-32-14.3-32-32s14.3-32 32-32zM400 168c0-13.3-10.7-24-24-24c-10.3 0-19.1 6.5-22.5 15.6l25.1 32.2c12.1-1.3 21.4-11.5 21.4-23.9zm-89.3-63.3l11.8 15.1C335.7 105.2 354.8 96 376 96c39.8 0 72 32.2 72 72c0 29.2-17.4 54.3-42.3 65.6c6.8 15.8 10.3 32.9 10.3 50.3L416 448c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-164.1c0-28.5 9.5-56.1 27-78.6l78.3-100.7c2.1-2.6 3.7-5.6 4.8-8.7l163.9 0c1.1 3.1 2.7 6 4.8 8.7zM128 288c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-192 0z"]
}, faFutbol = {
  prefix: "fas",
  iconName: "futbol",
  icon: [512, 512, [9917, "futbol-ball", "soccer-ball"], "f1e3", "M417.3 360.1l-71.6-4.8c-5.2-.3-10.3 1.1-14.5 4.2s-7.2 7.4-8.4 12.5l-17.6 69.6C289.5 445.8 273 448 256 448s-33.5-2.2-49.2-6.4L189.2 372c-1.3-5-4.3-9.4-8.4-12.5s-9.3-4.5-14.5-4.2l-71.6 4.8c-17.6-27.2-28.5-59.2-30.4-93.6L125 228.3c4.4-2.8 7.6-7 9.2-11.9s1.4-10.2-.5-15l-26.7-66.6C128 109.2 155.3 89 186.7 76.9l55.2 46c4 3.3 9 5.1 14.1 5.1s10.2-1.8 14.1-5.1l55.2-46c31.3 12.1 58.7 32.3 79.6 57.9l-26.7 66.6c-1.9 4.8-2.1 10.1-.5 15s4.9 9.1 9.2 11.9l60.7 38.2c-1.9 34.4-12.8 66.4-30.4 93.6zM256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm14.1-325.7c-8.4-6.1-19.8-6.1-28.2 0L194 221c-8.4 6.1-11.9 16.9-8.7 26.8l18.3 56.3c3.2 9.9 12.4 16.6 22.8 16.6l59.2 0c10.4 0 19.6-6.7 22.8-16.6l18.3-56.3c3.2-9.9-.3-20.7-8.7-26.8l-47.9-34.8z"]
}, faFutbolBall = faFutbol, faSoccerBall = faFutbol, faSnowBlowing = {
  prefix: "fas",
  iconName: "snow-blowing",
  icon: [640, 512, [], "f761", "M512 48l32 0c53 0 96 43 96 96s-43 96-96 96l-128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zM176 64c13.3 0 24 10.7 24 24l0 25.4 12.7-12.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L200 158.6l0 55.8 48.3-27.9 12.9-48.2c2.3-8.5 11.1-13.6 19.6-11.3s13.6 11.1 11.3 19.6l-4.6 17.3 22-12.7c11.5-6.6 26.2-2.7 32.8 8.8s2.7 26.2-8.8 32.8l-22 12.7 17.3 4.6c8.5 2.3 13.6 11.1 11.3 19.6s-11.1 13.6-19.6 11.3l-48.2-12.9L224 256l48.3 27.9L320.6 271c8.5-2.3 17.3 2.8 19.6 11.3s-2.8 17.3-11.3 19.6l-17.3 4.6 22 12.7c11.5 6.6 15.4 21.3 8.8 32.8s-21.3 15.4-32.8 8.8l-22-12.7 4.6 17.3c2.3 8.5-2.8 17.3-11.3 19.6s-17.3-2.8-19.6-11.3l-12.9-48.2L200 297.6l0 55.8 35.3 35.3c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L200 398.6l0 25.4c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-25.4-12.7 12.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L152 353.4l0-55.8-48.3 27.9L90.7 373.7c-2.3 8.5-11.1 13.6-19.6 11.3s-13.6-11.1-11.3-19.6l4.6-17.3-22 12.7C31 367.4 16.4 363.5 9.7 352s-2.7-26.2 8.8-32.8l22-12.7-17.3-4.6c-8.5-2.3-13.6-11.1-11.3-19.6s11.1-13.6 19.6-11.3l48.2 12.9L128 256 79.7 228.1 31.4 241c-8.5 2.3-17.3-2.8-19.6-11.3s2.8-17.3 11.3-19.6l17.3-4.6-22-12.7C7 186.2 3.1 171.5 9.7 160s21.3-15.4 32.8-8.8l22 12.7-4.6-17.3c-2.3-8.5 2.8-17.3 11.3-19.6s17.3 2.8 19.6 11.3l12.9 48.2L152 214.4l0-55.8-35.3-35.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L152 113.4 152 88c0-13.3 10.7-24 24-24zM480 432c0-17.7 14.3-32 32-32l24 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-120 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l120 0c53 0 96 43 96 96s-43 96-96 96l-24 0c-17.7 0-32-14.3-32-32z"]
}, faPaintbrush = {
  prefix: "fas",
  iconName: "paintbrush",
  icon: [576, 512, [128396, "paint-brush"], "f1fc", "M339.3 367.1c27.3-3.9 51.9-19.4 67.2-42.9L568.2 74.1c12.6-19.5 9.4-45.3-7.6-61.2S517.7-4.4 499.1 9.6L262.4 187.2c-24 18-38.2 46.1-38.4 76.1L339.3 367.1zm-19.6 25.4l-116-104.4C143.9 290.3 96 339.6 96 400c0 3.9 .2 7.8 .6 11.6C98.4 429.1 86.4 448 68.8 448L64 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l144 0c61.9 0 112-50.1 112-112c0-2.5-.1-5-.2-7.5z"]
}, faPaintBrush = faPaintbrush, faLock = {
  prefix: "fas",
  iconName: "lock",
  icon: [448, 512, [128274], "f023", "M144 144l0 48 160 0 0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80zM80 192l0-48C80 64.5 144.5 0 224 0s144 64.5 144 144l0 48 16 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 256c0-35.3 28.7-64 64-64l16 0z"]
}, faArrowDownFromLine = {
  prefix: "fas",
  iconName: "arrow-down-from-line",
  icon: [384, 512, [8615, "arrow-from-top"], "f345", "M214.6 470.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L160 370.7 160 192c0-17.7 14.3-32 32-32s32 14.3 32 32l0 178.7 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-128 128zM32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96z"]
}, faArrowFromTop = faArrowDownFromLine, faGasPump = {
  prefix: "fas",
  iconName: "gas-pump",
  icon: [512, 512, [9981], "f52f", "M32 64C32 28.7 60.7 0 96 0L256 0c35.3 0 64 28.7 64 64l0 192 8 0c48.6 0 88 39.4 88 88l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-154c-27.6-7.1-48-32.2-48-62l0-64L384 64c-8.8-8.8-8.8-23.2 0-32s23.2-8.8 32 0l77.3 77.3c12 12 18.7 28.3 18.7 45.3l0 13.5 0 24 0 32 0 152c0 39.8-32.2 72-72 72s-72-32.2-72-72l0-32c0-22.1-17.9-40-40-40l-8 0 0 144c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32L32 64zM96 80l0 96c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16l0-96c0-8.8-7.2-16-16-16L112 64c-8.8 0-16 7.2-16 16z"]
}, faSignalBarsSlash = {
  prefix: "fas",
  iconName: "signal-bars-slash",
  icon: [640, 512, ["signal-alt-slash"], "f694", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L608 451.2 608 48c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 328-64-50.2L448 176c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 74.6L38.8 5.1zM288 322.9l-74.7-58.8C200.5 272.7 192 287.4 192 304l0 160c0 26.5 21.5 48 48 48s48-21.5 48-48l0-141.1zM448 464l0-15-96-75.6 0 90.7c0 26.5 21.5 48 48 48s48-21.5 48-48zM80 384c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48z"]
}, faSignalAltSlash = faSignalBarsSlash, faMonkey = {
  prefix: "fas",
  iconName: "monkey",
  icon: [576, 512, [128018], "f6fb", "M160 416c0-89.7 61.4-165 144.5-186.1C329.1 265 369.9 288 416 288c9.8 0 19.4-1 28.7-3L526.5 363c31.6 30.2 49.5 72 49.5 115.7l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-26.2-10.7-51.3-29.7-69.4L416 346.1 416 448l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0-256 0C71.6 512 0 440.4 0 352L0 110.1C0 49.3 49.3 0 110.1 0l10.4 0c57.2 0 102.8 47.8 100.1 104.9c-2.3 48.2-38.6 88-86.4 94.6l-1.9 .3c-17.5 2.4-33.7-9.8-36.1-27.3s9.8-33.7 27.3-36.1l1.9-.3c17.3-2.4 30.4-16.7 31.2-34.2c1-20.6-15.5-37.9-36.2-37.9l-10.4 0C84.7 64 64 84.7 64 110.1L64 352c0 53 43 96 96 96l0-32zM416 256c-29.3 0-55.9-12.2-74.8-31.7c-9-9.3-16.2-20.2-21.3-32.3c-35.3 0-64-28.7-64-64s28.6-64 64-64c15.7-37.6 52.8-64 96-64s80.4 26.4 96 64c35.3 0 64 28.7 64 64s-28.6 64-64 64c-15.7 37.6-52.8 64-96 64zM384 64c-26.5 0-48 21.5-48 48c0 20.8 13.2 38.4 31.6 45.1c4.7 1.7 8.4 5.9 8.4 10.9c0 22.1 17.9 40 40 40s40-17.9 40-40c0-5 3.7-9.2 8.4-10.9c18.5-6.7 31.6-24.4 31.6-45.1c0-26.5-21.5-48-48-48l-64 0zm0 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]
}, faRectanglePro = {
  prefix: "fas",
  iconName: "rectangle-pro",
  icon: [640, 512, ["pro"], "e235", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l512 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm40 128l56 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-32 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64 0-80c0-13.3 10.7-24 24-24zm56 80c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0 32 32 0zm80-56c0-13.3 10.7-24 24-24l56 0c35.3 0 64 28.7 64 64c0 21.9-11 41.2-27.7 52.7l24.1 38.5c7 11.2 3.6 26-7.6 33.1s-26 3.6-33.1-7.6l-33-52.7L288 288l0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64 0-80zm48 56l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0 32zm200-80c48.6 0 88 39.4 88 88l0 16c0 48.6-39.4 88-88 88s-88-39.4-88-88l0-16c0-48.6 39.4-88 88-88zm-40 88l0 16c0 22.1 17.9 40 40 40s40-17.9 40-40l0-16c0-22.1-17.9-40-40-40s-40 17.9-40 40z"]
}, faPro = faRectanglePro, faHouseNight = {
  prefix: "fas",
  iconName: "house-night",
  icon: [640, 512, [], "e010", "M125.2 16.1c6.2-4.4 5.4-14.8-2.2-15.6c-3.6-.4-7.3-.5-11-.5C50.1 0 0 50.1 0 112s50.1 112 112 112c32.1 0 61.1-13.5 81.5-35.2c5.2-5.6-1-14-8.6-13.2c-2.9 .3-5.9 .4-9 .4c-48.6 0-88-39.4-88-88c0-29.7 14.7-55.9 37.2-71.9zm138.3-3.8c-2.6-7-12.4-7-15 0L236.6 44.6 204.3 56.5c-7 2.6-7 12.4 0 15l32.3 11.9 11.9 32.3c2.6 7 12.4 7 15 0l11.9-32.3 32.3-11.9c7-2.6 7-12.4 0-15L275.4 44.6 263.5 12.3zm158.2 92.2c-12.3-11.3-31.2-11.3-43.4 0l-208 192c-9.7 8.9-12.9 22.9-8.1 35.2S178.8 352 192 352l32 0 0 112c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-112 32 0c13.2 0 25-8.1 29.8-20.3s1.6-26.2-8.1-35.2l-208-192zM352 304c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64zM88.5 332.3L76.6 364.6 44.3 376.5c-7 2.6-7 12.4 0 15l32.3 11.9 11.9 32.3c2.6 7 12.4 7 15 0l11.9-32.3 32.3-11.9c7-2.6 7-12.4 0-15l-32.3-11.9-11.9-32.3c-2.6-7-12.4-7-15 0z"]
}, faHotTubPerson = {
  prefix: "fas",
  iconName: "hot-tub-person",
  icon: [512, 512, ["hot-tub"], "f593", "M272 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 5.2c0 34 14.4 66.4 39.7 89.2l16.4 14.8c15.2 13.7 23.8 33.1 23.8 53.5l0 13.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-13.2c0-34-14.4-66.4-39.7-89.2L295.8 82.8C280.7 69.1 272 49.7 272 29.2l0-5.2zM0 320l0 16L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-128c0-35.3-28.7-64-64-64l-170.7 0c-13.8 0-27.3-4.5-38.4-12.8l-85.3-64C137 166.7 116.8 160 96 160c-53 0-96 43-96 96l0 64zm128 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16zm80-16c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16zm112 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16zm80-16c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-8.8 7.2-16 16-16zM360 0c-13.3 0-24 10.7-24 24l0 5.2c0 34 14.4 66.4 39.7 89.2l16.4 14.8c15.2 13.7 23.8 33.1 23.8 53.5l0 13.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-13.2c0-34-14.4-66.4-39.7-89.2L407.8 82.8C392.7 69.1 384 49.7 384 29.2l0-5.2c0-13.3-10.7-24-24-24zM64 128A64 64 0 1 0 64 0a64 64 0 1 0 0 128z"]
}, faHotTub = faHotTubPerson, faGlobePointer = {
  prefix: "fas",
  iconName: "globe-pointer",
  icon: [512, 512, [], "e60e", "M352 256c0 22.2-1.2 43.6-3.3 64l-66.8 0 12.6-42.8c10.7-36.4-23.1-70.3-59.6-59.6l-74.6 21.9c.4-16.3 1.5-32.2 3.1-47.5l185.3 0c2.2 20.4 3.3 41.8 3.3 64zM20.4 280.6c-7.1 2.1-13.1 5.5-18.1 9.9C.8 279.2 0 267.7 0 256c0-22.1 2.8-43.5 8.1-64l123.1 0c-1.9 18.4-2.9 37.4-3.1 57L20.4 280.6zM231.4 491.6L272.4 352l71.9 0c-6.1 36.4-15.5 68.6-27 94.6c-10.5 23.6-22.2 40.7-33.5 51.5C272.6 508.8 263.3 512 256 512c-7.2 0-16.3-3.1-27.3-13.4c1-2.2 1.9-4.6 2.7-7.1zM380.8 192l123.1 0c5.3 20.5 8.1 41.9 8.1 64s-2.8 43.5-8.1 64l-123.1 0c2.1-20.6 3.2-42 3.2-64s-1.1-43.4-3.2-64zm112.6-32l-116.7 0c-10-63.9-29.8-117.4-55.3-151.6c78.3 20.7 142 77.5 171.9 151.6zm-325.7 0c6.1-36.4 15.5-68.6 27-94.7c10.5-23.6 22.2-40.7 33.5-51.5C239.4 3.2 248.7 0 256 0s16.6 3.2 27.8 13.8c11.3 10.8 23 27.9 33.5 51.5c11.6 26 20.9 58.2 27 94.7l-176.6 0zm-32.4 0L18.6 160C48.6 85.9 112.2 29.1 190.6 8.4C165.1 42.6 145.3 96.1 135.3 160zM493.4 352c-30 74.1-93.6 130.9-171.9 151.6c25.5-34.2 45.2-87.7 55.3-151.6l116.7 0zM39 308.5l204.8-60.2c12.1-3.6 23.4 7.7 19.9 19.9L203.5 473c-4.1 13.9-23.2 15.6-29.7 2.6l-28.7-57.3c-.7-1.3-1.5-2.6-2.5-3.7l-88 88c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l88-88c-1.1-1-2.3-1.9-3.7-2.5L36.4 338.2c-13-6.5-11.3-25.6 2.6-29.7z"]
}, faBlanket = {
  prefix: "fas",
  iconName: "blanket",
  icon: [448, 512, [], "f498", "M0 128L0 352c0 70.7 57.3 128 128 128l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-288 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l240 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-240 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l240 0c44.2 0 80-35.8 80-80l0-176c0-53-43-96-96-96L96 32C43 32 0 75 0 128z"]
}, faMapLocation = {
  prefix: "fas",
  iconName: "map-location",
  icon: [576, 512, ["map-marked"], "f59f", "M302.8 312C334.9 271.9 408 174.6 408 120C408 53.7 354.3 0 288 0S168 53.7 168 120c0 54.6 73.1 151.9 105.2 192c7.7 9.6 22 9.6 29.6 0zM416 503l144.9-58c9.1-3.6 15.1-12.5 15.1-22.3L576 152c0-17-17.1-28.6-32.9-22.3l-116 46.4c-.5 1.2-1 2.5-1.5 3.7c-2.9 6.8-6.1 13.7-9.6 20.6L416 503zM15.1 187.3C6 191 0 199.8 0 209.6L0 480.4c0 17 17.1 28.6 32.9 22.3L160 451.8l0-251.4c-3.5-6.9-6.7-13.8-9.6-20.6c-5.6-13.2-10.4-27.4-12.8-41.5l-122.6 49zM384 255c-20.5 31.3-42.3 59.6-56.2 77c-20.5 25.6-59.1 25.6-79.6 0c-13.9-17.4-35.7-45.7-56.2-77l0 194.4 192 54.9L384 255z"]
}, faMapMarked = faMapLocation, faHouseFloodWater = {
  prefix: "fas",
  iconName: "house-flood-water",
  icon: [576, 512, [], "e50e", "M306.8 6.1C295.6-2 280.4-2 269.2 6.1l-176 128c-11.2 8.2-15.9 22.6-11.6 35.8S98.1 192 112 192l16 0 0 73c1.7 1 3.3 2 4.9 3.1c18 12.4 40.1 20.3 59.2 20.3c21.1 0 42-8.5 59.2-20.3c22.1-15.5 51.6-15.5 73.7 0c18.4 12.7 39.6 20.3 59.2 20.3c19 0 41.2-7.9 59.2-20.3c1.5-1 3-2 4.5-2.9l-.3-73.2 16.6 0c13.9 0 26.1-8.9 30.4-22.1s-.4-27.6-11.6-35.8l-176-128zM269.5 309.9C247 325.4 219.5 336 192 336c-26.9 0-55.3-10.8-77.4-26.1c0 0 0 0 0 0c-11.9-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4s21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 389.7 159 400 192 400c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.5-27.3-10.1-39.2-1.7c0 0 0 0 0 0C439.4 325.2 410.9 336 384 336c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0zM384 448c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 437.4 219.5 448 192 448c-26.9 0-55.3-10.8-77.4-26.1c0 0 0 0 0 0c-11.9-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4s21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 501.7 159 512 192 512c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.4-27.3-10.1-39.2-1.7c0 0 0 0 0 0C439.4 437.2 410.9 448 384 448z"]
}, faCommentsQuestionCheck = {
  prefix: "fas",
  iconName: "comments-question-check",
  icon: [640, 512, [], "e14f", "M208 352c114.9 0 208-78.8 208-176S322.9 0 208 0S0 78.8 0 176c0 38.6 14.7 74.3 39.6 103.4c-3.5 9.4-8.7 17.7-14.2 24.7c-4.8 6.2-9.7 11-13.3 14.3c-1.8 1.6-3.3 2.9-4.3 3.7c-.5 .4-.9 .7-1.1 .8l-.2 .2s0 0 0 0s0 0 0 0C1 327.2-1.4 334.4 .8 340.9S9.1 352 16 352c21.8 0 43.8-5.6 62.1-12.5c9.2-3.5 17.8-7.4 25.2-11.4C134.1 343.3 169.8 352 208 352zM448 176c0 112.3-99.1 196.9-216.5 207C255.8 457.4 336.4 512 432 512c38.2 0 73.9-8.7 104.7-23.9c7.5 4 16 7.9 25.2 11.4c18.3 6.9 40.3 12.5 62.1 12.5c6.9 0 13.1-4.5 15.2-11.1c2.1-6.6-.2-13.8-5.8-17.9c0 0 0 0 0 0s0 0 0 0l-.2-.2c-.2-.2-.6-.4-1.1-.8c-1-.8-2.5-2-4.3-3.7c-3.6-3.3-8.5-8.1-13.3-14.3c-5.5-7-10.7-15.4-14.2-24.7c24.9-29 39.6-64.7 39.6-103.4c0-92.8-84.9-168.9-192.6-175.5c.4 5.1 .6 10.3 .6 15.5zM180.2 77.3l48.5 0c29.1 0 52.6 23.6 52.6 52.6c0 18.8-10.1 36.3-26.4 45.6L228 191c-.2 10.9-9.1 19.6-20 19.6c-11 0-20-9-20-20l0-11.2c0-7.2 3.8-13.8 10-17.3L235 140.9c3.9-2.3 6.3-6.4 6.3-10.9c0-7-5.7-12.6-12.6-12.6l-48.5 0c-2.8 0-5.3 1.8-6.3 4.4l-.4 1c-3.7 10.4-15.1 15.9-25.5 12.2s-15.9-15.1-12.2-25.5l.4-1c6.6-18.6 24.2-31.1 44-31.1zm27.8 160a26.7 26.7 0 1 1 0 53.3 26.7 26.7 0 1 1 0-53.3zm358.1 88.8l-80 80c-7.8 7.8-20.5 7.8-28.3 0l-40-40c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0L472 363.7l65.9-65.9c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3z"]
}, faTree = {
  prefix: "fas",
  iconName: "tree",
  icon: [448, 512, [127794], "f1bb", "M210.6 5.9L62 169.4c-3.9 4.2-6 9.8-6 15.5C56 197.7 66.3 208 79.1 208l24.9 0L30.6 281.4c-4.2 4.2-6.6 10-6.6 16C24 309.9 34.1 320 46.6 320L80 320 5.4 409.5C1.9 413.7 0 419 0 424.5c0 13 10.5 23.5 23.5 23.5L192 448l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 168.5 0c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L368 320l33.4 0c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L344 208l24.9 0c12.7 0 23.1-10.3 23.1-23.1c0-5.7-2.1-11.3-6-15.5L237.4 5.9C234 2.1 229.1 0 224 0s-10 2.1-13.4 5.9z"]
}, faArrowsCross = {
  prefix: "fas",
  iconName: "arrows-cross",
  icon: [448, 512, [], "e0a2", "M288 32c-17.7 0-32 14.3-32 32s14.3 32 32 32l50.7 0L9.4 425.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L384 141.3l0 50.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L288 32zM54.6 41.4c-12.5-12.5-32.8-12.5-45.3 0S-3.1 74.1 9.4 86.6L156.1 233.4l45.3-45.3L54.6 41.4zM338.7 416L288 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 50.7-92.1-92.1-45.3 45.3L338.7 416z"]
}, faBackpack = {
  prefix: "fas",
  iconName: "backpack",
  icon: [448, 512, [127890], "f5d4", "M192 48l64 0c4.4 0 8 3.6 8 8l0 40-80 0 0-40c0-4.4 3.6-8 8-8zm-56 8l0 40-8 0C57.3 96 0 153.3 0 224L0 448c0 35.3 28.7 64 64 64l0-112 0-48c0-35.3 28.7-64 64-64l192 0c35.3 0 64 28.7 64 64l0 48 0 112c35.3 0 64-28.7 64-64l0-224c0-70.7-57.3-128-128-128l-8 0 0-40c0-30.9-25.1-56-56-56L192 0c-30.9 0-56 25.1-56 56zM352 512l0-96L96 416l0 96 256 0zM144 176l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM352 384l0-32c0-17.7-14.3-32-32-32l-192 0c-17.7 0-32 14.3-32 32l0 32 256 0z"]
}, faSquareSmall = {
  prefix: "fas",
  iconName: "square-small",
  icon: [320, 512, [], "e27e", "M0 160c0-35.3 28.7-64 64-64H256c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160z"]
}, faFolderArrowUp = {
  prefix: "fas",
  iconName: "folder-arrow-up",
  icon: [512, 512, ["folder-upload"], "e054", "M512 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l128 0c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8l160 0c35.3 0 64 28.7 64 64l0 256zM280 376l0-102.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31L232 376c0 13.3 10.7 24 24 24s24-10.7 24-24z"]
}, faFolderUpload = faFolderArrowUp, faBridgeLock = {
  prefix: "fas",
  iconName: "bridge-lock",
  icon: [640, 512, [], "e4cc", "M32 64c0-17.7 14.3-32 32-32l512 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-40 0 0 64-8 0c-61.9 0-112 50.1-112 112l0 24.6c-9.9 5.8-18.2 14.1-23.8 24.1c-17.6-20-43.4-32.7-72.2-32.7c-53 0-96 43-96 96l0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64c0-53-43-96-96-96l0-128 72 0 0-64L64 96C46.3 96 32 81.7 32 64zM408 96l0 64 80 0 0-64-80 0zm-48 64l0-64-80 0 0 64 80 0zM152 96l0 64 80 0 0-64-80 0zM528 240c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l0-48z"]
}, faCrosshairsSimple = {
  prefix: "fas",
  iconName: "crosshairs-simple",
  icon: [512, 512, [], "e59f", "M445.3 224L384 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l61.3 0C431.9 368.4 368.4 431.9 288 445.3l0-61.3c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 61.3C143.6 431.9 80.1 368.4 66.7 288l61.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-61.3 0C80.1 143.6 143.6 80.1 224 66.7l0 61.3c0 17.7 14.3 32 32 32s32-14.3 32-32l0-61.3C368.4 80.1 431.9 143.6 445.3 224zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256z"]
}, faSackDollar = {
  prefix: "fas",
  iconName: "sack-dollar",
  icon: [512, 512, [128176], "f81d", "M320 96L192 96 144.6 24.9C137.5 14.2 145.1 0 157.9 0L354.1 0c12.8 0 20.4 14.2 13.3 24.9L320 96zM192 128l128 0c3.8 2.5 8.1 5.3 13 8.4C389.7 172.7 512 250.9 512 416c0 53-43 96-96 96L96 512c-53 0-96-43-96-96C0 250.9 122.3 172.7 179 136.4c0 0 0 0 0 0s0 0 0 0c4.8-3.1 9.2-5.9 13-8.4zm84 88c0-11-9-20-20-20s-20 9-20 20l0 14c-7.6 1.7-15.2 4.4-22.2 8.5c-13.9 8.3-25.9 22.8-25.8 43.9c.1 20.3 12 33.1 24.7 40.7c11 6.6 24.7 10.8 35.6 14l1.7 .5c12.6 3.8 21.8 6.8 28 10.7c5.1 3.2 5.8 5.4 5.9 8.2c.1 5-1.8 8-5.9 10.5c-5 3.1-12.9 5-21.4 4.7c-11.1-.4-21.5-3.9-35.1-8.5c-2.3-.8-4.7-1.6-7.2-2.4c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3c1.9 .6 4 1.3 6.1 2.1c0 0 0 0 0 0s0 0 0 0c8.3 2.9 17.9 6.2 28.2 8.4l0 14.6c0 11 9 20 20 20s20-9 20-20l0-13.8c8-1.7 16-4.5 23.2-9c14.3-8.9 25.1-24.1 24.8-45c-.3-20.3-11.7-33.4-24.6-41.6c-11.5-7.2-25.9-11.6-37.1-15c0 0 0 0 0 0l-.7-.2c-12.8-3.9-21.9-6.7-28.3-10.5c-5.2-3.1-5.3-4.9-5.3-6.7c0-3.7 1.4-6.5 6.2-9.3c5.4-3.2 13.6-5.1 21.5-5c9.6 .1 20.2 2.2 31.2 5.2c10.7 2.8 21.6-3.5 24.5-14.2s-3.5-21.6-14.2-24.5c-6.5-1.7-13.7-3.4-21.1-4.7l0-13.9z"]
}, faPenToSquare = {
  prefix: "fas",
  iconName: "pen-to-square",
  icon: [512, 512, ["edit"], "f044", "M471.6 21.7c-21.9-21.9-57.3-21.9-79.2 0L362.3 51.7l97.9 97.9 30.1-30.1c21.9-21.9 21.9-57.3 0-79.2L471.6 21.7zm-299.2 220c-6.1 6.1-10.8 13.6-13.5 21.9l-29.6 88.8c-2.9 8.6-.6 18.1 5.8 24.6s15.9 8.7 24.6 5.8l88.8-29.6c8.2-2.7 15.7-7.4 21.9-13.5L437.7 172.3 339.7 74.3 172.4 241.7zM96 64C43 64 0 107 0 160L0 416c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 64z"]
}, faEdit = faPenToSquare, faSquareSliders = {
  prefix: "fas",
  iconName: "square-sliders",
  icon: [448, 512, ["sliders-h-square"], "f3f0", "M384 480c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0zm0-144c0 17.7-14.3 32-32 32l-32 0 0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16L96 368c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0 0-16c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16 32 0c17.7 0 32 14.3 32 32zM352 144c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0 0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-16c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16 160 0z"]
}, faSlidersHSquare = faSquareSliders, faCarSide = {
  prefix: "fas",
  iconName: "car-side",
  icon: [640, 512, [128663], "f5e4", "M171.3 96L224 96l0 96-112.7 0 30.4-75.9C146.5 104 158.2 96 171.3 96zM272 192l0-96 81.2 0c9.7 0 18.9 4.4 25 12l67.2 84L272 192zm256.2 1L428.2 68c-18.2-22.8-45.8-36-75-36L171.3 32c-39.3 0-74.6 23.9-89.1 60.3L40.6 196.4C16.8 205.8 0 228.9 0 256L0 368c0 17.7 14.3 32 32 32l33.3 0c7.6 45.4 47.1 80 94.7 80s87.1-34.6 94.7-80l130.7 0c7.6 45.4 47.1 80 94.7 80s87.1-34.6 94.7-80l33.3 0c17.7 0 32-14.3 32-32l0-48c0-65.2-48.8-119-111.8-127zM434.7 368a48 48 0 1 1 90.5 32 48 48 0 1 1 -90.5-32zM160 336a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]
}, faMessageMiddleTop = {
  prefix: "fas",
  iconName: "message-middle-top",
  icon: [512, 512, ["comment-middle-top-alt"], "e1e2", "M343.5 96L448 96c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l104.5 0L243.7 5.8c3-3.6 7.5-5.8 12.3-5.8s9.3 2.1 12.3 5.8L343.5 96z"]
}, faCommentMiddleTopAlt = faMessageMiddleTop, faLightbulbOn = {
  prefix: "fas",
  iconName: "lightbulb-on",
  icon: [640, 512, [], "f672", "M69.3 4l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3S58.3-3.3 69.3 4zM597.3 44l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zM24 160l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm528 0l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM117.3 332l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zm432-39.9l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3s22.3-14 33.3-6.7zm-100.1 5.7c-19.8 27.1-39.7 54.4-49.2 86.2l-160 0c-9.6-31.9-29.5-59.1-49.2-86.2c0 0 0 0 0 0s0 0 0 0c-5.2-7.1-10.4-14.2-15.4-21.4C155.6 247.9 144 213.3 144 176C144 78.8 222.8 0 320 0s176 78.8 176 176c0 37.3-11.6 71.9-31.4 100.3c-5 7.2-10.2 14.3-15.4 21.4c0 0 0 0 0 0s0 0 0 0zM400 432c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-16 160 0 0 16zM320 96c8.8 0 16-7.2 16-16s-7.2-16-16-16c-61.9 0-112 50.1-112 112c0 8.8 7.2 16 16 16s16-7.2 16-16c0-44.2 35.8-80 80-80z"]
}, faKnife = {
  prefix: "fas",
  iconName: "knife",
  icon: [512, 512, ["utensil-knife"], "f2e4", "M217.5 249.3l242-242c4.7-4.7 11-7.3 17.6-7.3c11.2 0 21 7.5 23.5 18.4C505.3 38.6 512 71.5 512 96c0 83.3-48.2 130.5-128.9 209.4c-6.5 6.4-13.3 13-20.3 19.9c-12.1 11.9-28.4 18.7-45.3 18.7l-11 0c-17 0-33.3-6.7-45.3-18.7l-14.6-14.6-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192 16-16 .1-.1z"]
}, faUtensilKnife = faKnife, faShareNodes = {
  prefix: "fas",
  iconName: "share-nodes",
  icon: [448, 512, ["share-alt"], "f1e0", "M352 224c53 0 96-43 96-96s-43-96-96-96s-96 43-96 96c0 4 .2 8 .7 11.9l-94.1 47C145.4 170.2 121.9 160 96 160c-53 0-96 43-96 96s43 96 96 96c25.9 0 49.4-10.2 66.6-26.9l94.1 47c-.5 3.9-.7 7.8-.7 11.9c0 53 43 96 96 96s96-43 96-96s-43-96-96-96c-25.9 0-49.4 10.2-66.6 26.9l-94.1-47c.5-3.9 .7-7.8 .7-11.9s-.2-8-.7-11.9l94.1-47C302.6 213.8 326.1 224 352 224z"]
}, faShareAlt = faShareNodes, faDisplayChartUpCircleDollar = {
  prefix: "fas",
  iconName: "display-chart-up-circle-dollar",
  icon: [640, 512, [], "e5e6", "M0 64C0 28.7 28.7 0 64 0L512 0c35.3 0 64 28.7 64 64l0 147.2c-19.5-10-41.1-16.4-64-18.5L512 64 64 64l0 288 256.7 0c-.5 5.3-.7 10.6-.7 16c0 59.5 29.5 112.1 74.8 144L160 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l69.3 0L240 416 64 416c-35.3 0-64-28.7-64-64L0 64zm480 56l0 72.7c-16.7 1.5-32.7 5.3-47.7 11.2c-.2-1.3-.3-2.6-.3-3.9l0-22.1L321 289c-4.5 4.5-10.6 7-17 7s-12.5-2.5-17-7l-63-63-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L207 175c9.4-9.4 24.6-9.4 33.9 0l63 63L398.1 144 376 144c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c13.3 0 24 10.7 24 24zM352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm120.8-32.6c.6-.9 1.8-2.1 4.2-3.4c5.1-2.7 12.5-4.1 18.7-4c8.2 .1 17.1 1.8 26.4 4.1c8.6 2.1 17.3-3.1 19.4-11.7s-3.1-17.3-11.7-19.4c-5.6-1.4-11.6-2.7-17.9-3.7l0-9.4c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 9.5c-6.1 1.2-12.3 3.2-18 6.3c-11.8 6.3-23 18.4-21.8 37.2c1 16 11.7 25.3 21.6 30.7c8.8 4.7 19.7 7.8 28.6 10.3l1.8 .5c10.3 2.9 17.9 5.2 23.2 8.3c4.5 2.7 4.7 4.2 4.7 5.6c.1 2.4-.5 3.7-1 4.5c-.6 1-1.8 2.2-4 3.3c-4.7 2.5-11.8 3.8-18.5 3.6c-9.5-.3-18.5-3.1-29.9-6.8c-1.9-.6-3.8-1.2-5.8-1.8c-8.4-2.6-17.4 2.1-20 10.5s2.1 17.4 10.5 20c1.6 .5 3.3 1 5 1.6c0 0 0 0 0 0s0 0 0 0c7 2.3 15.1 4.8 23.7 6.6l0 11.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-10.8c6.2-1.1 12.5-3.1 18.3-6.2c12.1-6.5 22.3-18.7 21.7-36.9c-.5-16.2-10.3-26.3-20.5-32.3c-9.4-5.6-21.2-8.9-30.5-11.5l-.2 0c-10.4-2.9-18.3-5.2-23.9-8.2c-4.8-2.6-4.8-4-4.8-4.5c0 0 0 0 0-.1c-.1-1.9 .3-2.9 .8-3.6z"]
}, faWaveSine = {
  prefix: "fas",
  iconName: "wave-sine",
  icon: [640, 512, [8767], "f899", "M63.4 230.3l0-.1 .2-1c.2-.9 .5-2.4 1-4.3c1-3.8 2.5-9.4 4.6-16.2C73.6 195 80.3 177 90 159.4C110.2 122.8 137.8 96 176 96c29 0 49.1 14.4 67 44.4c19 31.8 31.9 75.4 46.3 124.5c.2 .8 .5 1.6 .7 2.4c13.5 46.2 28.4 97.5 52 137c25.1 42 63 75.6 122 75.6c73.8 0 118.2-53.2 142-96.6c12.3-22.4 20.6-44.5 25.7-60.8c2.6-8.2 4.5-15.1 5.7-20c.6-2.5 1.1-4.4 1.4-5.9c.2-.7 .3-1.3 .4-1.7l.1-.5 0-.2c0 0 0 0 0-.1c0 0 0 0 0 0L608 288l31.4 6.3c3.5-17.3-7.8-34.2-25.1-37.7s-34.2 7.8-37.7 25.1c0 0 0 0 0 0l0 .1-.2 1c-.2 .9-.5 2.4-1 4.3c-1 3.8-2.5 9.4-4.6 16.2c-4.3 13.7-11.1 31.6-20.8 49.2c-20.1 36.6-47.8 63.4-86 63.4c-29 0-49.1-14.4-67-44.4c-19-31.8-31.9-75.4-46.3-124.5c-.2-.8-.5-1.6-.7-2.4c-13.5-46.2-28.4-97.5-52-137C272.9 65.6 235 32 176 32C102.2 32 57.8 85.2 34 128.6C21.7 151 13.4 173 8.2 189.3c-2.6 8.2-4.5 15.1-5.7 20c-.6 2.5-1.1 4.4-1.4 5.9c-.2 .7-.3 1.3-.4 1.7l-.1 .5 0 .2c0 0 0 0 0 .1c0 0 0 0 0 0L32 224 .6 217.7c-3.5 17.3 7.8 34.2 25.1 37.7s34.2-7.8 37.7-25.1z"]
}, faHeartCircleMinus = {
  prefix: "fas",
  iconName: "heart-circle-minus",
  icon: [576, 512, [], "e4ff", "M47.6 300.4L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9s20.2-3.9 27.7-10.9l2.6-2.4C267.2 438.6 256 404.6 256 368c0-97.2 78.8-176 176-176c28.3 0 55 6.7 78.7 18.5c.9-6.5 1.3-13 1.3-19.6l0-5.8c0-69.9-50.5-129.5-119.4-141C347 36.5 300.6 51.4 268 84L256 96 244 84c-32.6-32.6-79-47.5-124.6-39.9C50.5 55.6 0 115.2 0 185.1l0 5.8c0 41.5 17.2 81.2 47.6 109.5zM576 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-64 0c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l128 0c8.8 0 16 7.2 16 16z"]
}, faCircleW = {
  prefix: "fas",
  iconName: "circle-w",
  icon: [512, 512, [], "e12c", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM150.9 168.7L192 297.3l41.1-128.6c3.2-9.9 12.4-16.7 22.9-16.7s19.7 6.7 22.9 16.7L320 297.3l41.1-128.6c4-12.6 17.5-19.6 30.2-15.5s19.6 17.5 15.5 30.2l-64 200c-3.2 9.9-12.4 16.7-22.9 16.7s-19.7-6.7-22.9-16.7L256 254.7 214.9 383.3c-3.2 9.9-12.4 16.7-22.9 16.7s-19.7-6.7-22.9-16.7l-64-200c-4-12.6 2.9-26.1 15.5-30.2s26.1 2.9 30.2 15.5z"]
}, faCircleCalendar = {
  prefix: "fas",
  iconName: "circle-calendar",
  icon: [512, 512, ["calendar-circle"], "e102", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM208 96c8.8 0 16 7.2 16 16l0 16 64 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 32 0c17.7 0 32 14.3 32 32l0 32-256 0 0-32c0-17.7 14.3-32 32-32l32 0 0-16c0-8.8 7.2-16 16-16zM128 352l0-128 256 0 0 128c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32z"]
}, faCalendarCircle = faCircleCalendar, faHourglassHalf = {
  prefix: "fas",
  iconName: "hourglass-half",
  icon: [384, 512, ["hourglass-2"], "f252", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l0 11c0 42.4 16.9 83.1 46.9 113.1L146.7 256 78.9 323.9C48.9 353.9 32 394.6 32 437l0 11c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 256 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-11c0-42.4-16.9-83.1-46.9-113.1L237.3 256l67.9-67.9c30-30 46.9-70.7 46.9-113.1l0-11c17.7 0 32-14.3 32-32s-14.3-32-32-32L320 0 64 0 32 0zM96 75l0-11 192 0 0 11c0 19-5.6 37.4-16 53L112 128c-10.3-15.6-16-34-16-53zm16 309c3.5-5.3 7.6-10.3 12.1-14.9L192 301.3l67.9 67.9c4.6 4.6 8.6 9.6 12.1 14.9L112 384z"]
}, faHourglass2 = faHourglassHalf, faMicroscope = {
  prefix: "fas",
  iconName: "microscope",
  icon: [512, 512, [128300], "f610", "M160 32c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32c17.7 0 32 14.3 32 32l0 224c0 17.7-14.3 32-32 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32c-17.7 0-32-14.3-32-32l0-224c0-17.7 14.3-32 32-32zM32 448l288 0c70.7 0 128-57.3 128-128s-57.3-128-128-128l0-64c106 0 192 86 192 192c0 49.2-18.5 94-48.9 128l16.9 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32zm80-64l192 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faSunset = {
  prefix: "fas",
  iconName: "sunset",
  icon: [576, 512, [127751], "f767", "M354.5 104.3L320 135.7 320 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 103.7-34.5-31.3c-13.1-11.9-33.3-10.9-45.2 2.2s-10.9 33.3 2.2 45.2l88 80c12.2 11.1 30.8 11.1 43.1 0l88-80c13.1-11.9 14-32.1 2.2-45.2s-32.1-14-45.2-2.2zm48.7 132.8c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L288 289.1l-90.3-62.3c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L153 345 45.1 364.9c-5.3 1-9.8 4.6-11.9 9.6s-1.5 10.7 1.6 15.2L64 432l105.3 0c19-46.9 65-80 118.7-80s99.7 33.1 118.7 80L512 432l29.2-42.3c3.1-4.5 3.7-10.2 1.6-15.2s-6.6-8.6-11.9-9.6L423 345 403.1 237.1zM0 488c0 13.3 10.7 24 24 24l528 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 464c-13.3 0-24 10.7-24 24z"]
}, faSink = {
  prefix: "fas",
  iconName: "sink",
  icon: [512, 512, [], "e06d", "M288 96c0-17.7 14.3-32 32-32s32 14.3 32 32s14.3 32 32 32s32-14.3 32-32c0-53-43-96-96-96s-96 43-96 96l0 192-64 0 0-24c0-30.9-25.1-56-56-56l-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c4.4 0 8 3.6 8 8l0 24-80 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l224 0 224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-80 0 0-24c0-4.4 3.6-8 8-8l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0c-30.9 0-56 25.1-56 56l0 24-64 0 0-192zM480 416l0-32L32 384l0 32c0 53 43 96 96 96l256 0c53 0 96-43 96-96z"]
}, faCalendarExclamation = {
  prefix: "fas",
  iconName: "calendar-exclamation",
  icon: [448, 512, [], "f334", "M96 32l0 32L48 64C21.5 64 0 85.5 0 112l0 48 448 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32S96 14.3 96 32zM448 192L0 192 0 464c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-272zM192 432a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm56-176l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faTruckContainerEmpty = {
  prefix: "fas",
  iconName: "truck-container-empty",
  icon: [640, 512, [], "e2b5", "M456 144c-13.3 0-24 10.7-24 24l0 88 0 32 0 32-224 0L80 320l-48 0c-17.7 0-32 14.3-32 32l0 32 0 16c0 44.2 35.8 80 80 80c26.2 0 49.4-12.6 64-32c14.6 19.4 37.8 32 64 32c44.2 0 80-35.8 80-80c0-5.5-.6-10.8-1.6-16L432 384l17.6 0c-1 5.2-1.6 10.5-1.6 16c0 44.2 35.8 80 80 80s80-35.8 80-80c0-5.5-.6-10.8-1.6-16l1.6 0c17.7 0 32-14.3 32-32l0-64 0-16 0-10.3c0-9.2-3.2-18.2-9-25.3l-58.8-71.8c-10.6-13-26.5-20.5-43.3-20.5L456 144zM585 256l-105 0 0-64 48.8 0c2.4 0 4.7 1.1 6.2 2.9L585 256zM528 368a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM176 400a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM80 368a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faHandHeart = {
  prefix: "fas",
  iconName: "hand-heart",
  icon: [512, 512, [], "f4bc", "M256 0c17.7 0 32 14.3 32 32l0 208c0 8.8 7.2 16 16 16s16-7.2 16-16l0-176c0-17.7 14.3-32 32-32s32 14.3 32 32l0 176c0 8.8 7.2 16 16 16s16-7.2 16-16l0-112c0-17.7 14.3-32 32-32s32 14.3 32 32l0 208c0 97.2-78.8 176-176 176l-19.2 0c-59.6 0-116.9-22.9-160-64L12.4 341c-16-15.2-16.6-40.6-1.4-56.6s40.6-16.6 56.6-1.4l60.5 57.6c0-1.5-.1-3.1-.1-4.6l0-272c0-17.7 14.3-32 32-32s32 14.3 32 32l0 176c0 8.8 7.2 16 16 16s16-7.2 16-16l0-208c0-17.7 14.3-32 32-32zM208 362.6c0 12.1 5.1 23.6 14.1 31.6l55.2 49.7c6.1 5.5 15.3 5.5 21.4 0l55.2-49.7c9-8.1 14.1-19.6 14.1-31.6c0-23.5-19.1-42.6-42.6-42.6l-1.1 0c-14.6 0-28.3 7.3-36.4 19.5c-8.1-12.2-21.7-19.5-36.4-19.5l-1.1 0c-23.5 0-42.6 19.1-42.6 42.6z"]
}, faBagShopping = {
  prefix: "fas",
  iconName: "bag-shopping",
  icon: [448, 512, ["shopping-bag"], "f290", "M160 112c0-35.3 28.7-64 64-64s64 28.7 64 64l0 48-128 0 0-48zm-48 48l-64 0c-26.5 0-48 21.5-48 48L0 416c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-208c0-26.5-21.5-48-48-48l-64 0 0-48C336 50.1 285.9 0 224 0S112 50.1 112 112l0 48zm24 48a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm152 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faShoppingBag = faBagShopping, faArrowDownZA = {
  prefix: "fas",
  iconName: "arrow-down-z-a",
  icon: [576, 512, ["sort-alpha-desc", "sort-alpha-down-alt"], "f881", "M183.6 469.6C177.5 476.2 169 480 160 480s-17.5-3.8-23.6-10.4l-88-96c-11.9-13-11.1-33.3 2-45.2s33.3-11.1 45.2 2L128 365.7 128 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 301.7 32.4-35.4c11.9-13 32.2-13.9 45.2-2s13.9 32.2 2 45.2l-88 96zM320 64c0-17.7 14.3-32 32-32l128 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9L429.3 160l50.7 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L402.7 96 352 96c-17.7 0-32-14.3-32-32zm96 192c12.1 0 23.2 6.8 28.6 17.7l64 128 16 32c7.9 15.8 1.5 35-14.3 42.9s-35 1.5-42.9-14.3L460.2 448l-88.4 0-7.2 14.3c-7.9 15.8-27.1 22.2-42.9 14.3s-22.2-27.1-14.3-42.9l16-32 64-128c5.4-10.8 16.5-17.7 28.6-17.7zM395.8 400l40.4 0L416 359.6 395.8 400z"]
}, faSortAlphaDesc = faArrowDownZA, faSortAlphaDownAlt = faArrowDownZA, faMitten = {
  prefix: "fas",
  iconName: "mitten",
  icon: [448, 512, [], "f7b5", "M352 384L64 384 5.4 178.9C1.8 166.4 0 153.4 0 140.3C0 62.8 62.8 0 140.3 0l3.4 0c66 0 123.5 44.9 139.5 108.9l31.4 125.8 17.6-20.1C344.8 200.2 362.9 192 382 192l2.8 0c34.9 0 63.3 28.3 63.3 63.3c0 15.9-6 31.2-16.8 42.9L352 384zM32 448c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32l0-32z"]
}, faReplyClock = {
  prefix: "fas",
  iconName: "reply-clock",
  icon: [640, 512, ["reply-time"], "e239", "M352 144a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zM496 64c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-48c0-8.8-7.2-16-16-16zm0 256c5.1 0 10.2-.2 15.2-.6c.5 5.5 .8 11 .8 16.6c0 113.3-81.5 163.9-100.2 174.1c-2.5 1.4-5.3 1.9-8.1 1.9c-10.9 0-19.7-8.9-19.7-19.7c0-7.5 4.3-14.4 9.8-19.5c9.4-8.8 22.2-26.4 22.2-56.7c0-53-43-96-96-96l-96 0 0 64c0 12.6-7.4 24.1-19 29.2s-25 3-34.4-5.4l-160-144C3.9 257.7 0 249.1 0 240s3.9-17.7 10.6-23.8l160-144c9.4-8.5 22.9-10.6 34.4-5.4s19 16.6 19 29.2l0 64 96.7 0c8.1 89.7 83.5 160 175.3 160z"]
}, faReplyTime = faReplyClock, faPersonRays = {
  prefix: "fas",
  iconName: "person-rays",
  icon: [512, 512, [], "e54d", "M208 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 304l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-223.1-28.6 47.5c-9.1 15.1-28.8 20-43.9 10.9s-20-28.8-10.9-43.9l58.3-97c17.4-28.9 48.6-46.6 82.3-46.6l29.7 0c33.7 0 64.9 17.7 82.3 46.6l58.3 97c9.1 15.1 4.2 34.8-10.9 43.9s-34.8 4.2-43.9-10.9L328 256.9 328 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-16 0zM7 7C16.4-2.3 31.6-2.3 41 7l80 80c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L7 41C-2.3 31.6-2.3 16.4 7 7zM471 7c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L471 7zM7 505c-9.4-9.4-9.4-24.6 0-33.9l80-80c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L41 505c-9.4 9.4-24.6 9.4-33.9 0zm464 0l-80-80c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0z"]
}, faRight = {
  prefix: "fas",
  iconName: "right",
  icon: [448, 512, [11157, "arrow-alt-right"], "f356", "M438.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6l0-96L40 320c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40l184 0 0-96c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l160 160z"]
}, faArrowAltRight = faRight, faCircleF = {
  prefix: "fas",
  iconName: "circle-f",
  icon: [512, 512, [], "e10e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 64 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96 0-112c0-13.3 10.7-24 24-24z"]
}, faUsers = {
  prefix: "fas",
  iconName: "users",
  icon: [640, 512, [], "f0c0", "M144 0a80 80 0 1 1 0 160A80 80 0 1 1 144 0zM512 0a80 80 0 1 1 0 160A80 80 0 1 1 512 0zM0 298.7C0 239.8 47.8 192 106.7 192l42.7 0c15.9 0 31 3.5 44.6 9.7c-1.3 7.2-1.9 14.7-1.9 22.3c0 38.2 16.8 72.5 43.3 96c-.2 0-.4 0-.7 0L21.3 320C9.6 320 0 310.4 0 298.7zM405.3 320c-.2 0-.4 0-.7 0c26.6-23.5 43.3-57.8 43.3-96c0-7.6-.7-15-1.9-22.3c13.6-6.3 28.7-9.7 44.6-9.7l42.7 0C592.2 192 640 239.8 640 298.7c0 11.8-9.6 21.3-21.3 21.3l-213.3 0zM224 224a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zM128 485.3C128 411.7 187.7 352 261.3 352l117.3 0C452.3 352 512 411.7 512 485.3c0 14.7-11.9 26.7-26.7 26.7l-330.7 0c-14.7 0-26.7-11.9-26.7-26.7z"]
}, faFacePleading = {
  prefix: "fas",
  iconName: "face-pleading",
  icon: [512, 512, [], "e386", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM302.7 427.9c6.6-5.9 7.1-16 1.2-22.6C294.7 395.1 278.7 384 256 384s-38.7 11.1-47.9 21.3c-5.9 6.6-5.4 16.7 1.2 22.6s16.7 5.4 22.6-1.2c4.7-5.3 12.7-10.7 24.1-10.7s19.4 5.4 24.1 10.7c5.9 6.6 16 7.1 22.6 1.2zM240 240c0-41.5-31.5-75.6-72-79.6c10-10.8 17.6-24.1 21.9-38.8l1.5-5.2c2.4-8.5-2.5-17.4-11-19.8s-17.4 2.5-19.8 11l-1.5 5.2c-7 24.7-28.1 42.7-53.6 45.9L94 160.1c-8.8 1.1-15 9.1-13.9 17.9c1 8.1 7.9 14 15.9 14c-10 13.4-16 30-16 48c0 44.2 35.8 80 80 80s80-35.8 80-80zm192 0c0-18-6-34.6-16-48c8 0 14.9-5.9 15.9-14c1.1-8.8-5.1-16.8-13.9-17.9l-11.5-1.4c-25.5-3.2-46.6-21.3-53.6-45.9l-1.5-5.2c-2.4-8.5-11.3-13.4-19.8-11s-13.4 11.3-11 19.8l1.5 5.2c4.2 14.8 11.8 28 21.9 38.8c-40.4 4-72 38.1-72 79.6c0 44.2 35.8 80 80 80s80-35.8 80-80zm-304-8c17.7 0 32-14.3 32-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4zm224-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4c17.7 0 32-14.3 32-32z"]
}, faEyeSlash = {
  prefix: "fas",
  iconName: "eye-slash",
  icon: [640, 512, [], "f070", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L525.6 386.7c39.6-40.6 66.4-86.1 79.9-118.4c3.3-7.9 3.3-16.7 0-24.6c-14.9-35.7-46.2-87.7-93-131.1C465.5 68.8 400.8 32 320 32c-68.2 0-125 26.3-169.3 60.8L38.8 5.1zM223.1 149.5C248.6 126.2 282.7 112 320 112c79.5 0 144 64.5 144 144c0 24.9-6.3 48.3-17.4 68.7L408 294.5c8.4-19.3 10.6-41.4 4.8-63.3c-11.1-41.5-47.8-69.4-88.6-71.1c-5.8-.2-9.2 6.1-7.4 11.7c2.1 6.4 3.3 13.2 3.3 20.3c0 10.2-2.4 19.8-6.6 28.3l-90.3-70.8zM373 389.9c-16.4 6.5-34.3 10.1-53 10.1c-79.5 0-144-64.5-144-144c0-6.9 .5-13.6 1.4-20.2L83.1 161.5C60.3 191.2 44 220.8 34.5 243.7c-3.3 7.9-3.3 16.7 0 24.6c14.9 35.7 46.2 87.7 93 131.1C174.5 443.2 239.2 480 320 480c47.8 0 89.9-12.9 126.2-32.5L373 389.9z"]
}, faFlaskVial = {
  prefix: "fas",
  iconName: "flask-vial",
  icon: [640, 512, [], "e4f3", "M175 389.4c-9.8 16-15 34.3-15 53.1c-10 3.5-20.8 5.5-32 5.5c-53 0-96-43-96-96L32 64C14.3 64 0 49.7 0 32S14.3 0 32 0L96 0l64 0 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 245.9-49 79.6zM96 64l0 96 64 0 0-96L96 64zM352 0L480 0l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 150.9L629.7 406.2c6.7 10.9 10.3 23.5 10.3 36.4c0 38.3-31.1 69.4-69.4 69.4l-309.2 0c-38.3 0-69.4-31.1-69.4-69.4c0-12.8 3.6-25.4 10.3-36.4L320 214.9 320 64c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0zm32 64l0 160c0 5.9-1.6 11.7-4.7 16.8L330.5 320l171 0-48.8-79.2c-3.1-5-4.7-10.8-4.7-16.8l0-160-64 0z"]
}, faPoliceBox = {
  prefix: "fas",
  iconName: "police-box",
  icon: [384, 512, [], "e021", "M192 0c8.8 0 16 7.2 16 16l0 16 80 0c17.7 0 32 14.3 32 32c17.7 0 32 14.3 32 32l0 368 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0L32 96c0-17.7 14.3-32 32-32c0-17.7 14.3-32 32-32l80 0 0-16c0-8.8 7.2-16 16-16zM96 136l0 24 32 0 0-32-24 0c-4.4 0-8 3.6-8 8zm0 40l0 24c0 4.4 3.6 8 8 8l24 0 0-32-32 0zm72-48l-24 0 0 32 32 0 0-24c0-4.4-3.6-8-8-8zm-24 48l0 32 24 0c4.4 0 8-3.6 8-8l0-24-32 0zm72-48c-4.4 0-8 3.6-8 8l0 24 32 0 0-32-24 0zm24 48l-32 0 0 24c0 4.4 3.6 8 8 8l24 0 0-32zm16-48l0 32 32 0 0-24c0-4.4-3.6-8-8-8l-24 0zm32 48l-32 0 0 32 24 0c4.4 0 8-3.6 8-8l0-24zM96 256l0 48c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16l0-48c0-8.8-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16z"]
}, faCucumber = {
  prefix: "fas",
  iconName: "cucumber",
  icon: [512, 512, [129362], "e401", "M37.5 474.5c47.8 47.8 124 49.9 174.3 6.3c12.6 10.3 31.1 9.6 42.9-2.2c11.6-11.6 12.4-30 2.4-42.6L436 257c12.6 10.1 31 9.3 42.6-2.4c11.7-11.7 12.5-30.3 2.2-42.9c43.6-50.3 41.5-126.5-6.3-174.3c-50-50-131-50-181 0L172 159c-12.6-10.1-31-9.3-42.6 2.4s-12.4 30-2.4 42.6L37.5 293.5c-50 50-50 131 0 181zM400 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM304 248a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM120 304a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faHeadSideBrain = {
  prefix: "fas",
  iconName: "head-side-brain",
  icon: [512, 512, [], "f808", "M0 224.2C0 100.6 100.2 0 224 0l24 0c95.2 0 181.2 69.3 197.3 160.2c2.3 13 6.8 25.7 15.1 36l42 52.6c6.2 7.8 9.6 17.4 9.6 27.4c0 24.2-19.6 43.8-43.8 43.8L448 320l0 64c0 35.3-28.7 64-64 64l-64 0 0 32c0 17.7-14.3 32-32 32L96 512c-17.7 0-32-14.3-32-32l0-72.7c0-16.7-6.9-32.5-17.1-45.8C16.6 322.4 0 274.1 0 224.2zM285.3 208l50.7 0c26.5 0 48-21.5 48-48s-21.5-48-48-48c-.9 0-1.8 0-2.7 .1C326.7 93.4 308.9 80 288 80c-8.6 0-16.6 2.2-23.5 6.2C255.9 72.8 241 64 224 64s-31.9 8.8-40.5 22.2c-7-3.9-15-6.2-23.5-6.2c-26.5 0-48 21.5-48 48c-26.5 0-48 21.5-48 48c0 20.9 13.4 38.7 32.1 45.3c0 .9-.1 1.8-.1 2.7c0 26.5 21.5 48 48 48c5.6 0 11-1 16-2.7l0 18.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-18.7c5 1.8 10.4 2.7 16 2.7c26.5 0 48-21.5 48-48c0-5.6-1-11-2.7-16zM160 176l0 2.7c0 0 0 0-.1 0c0-.9 .1-1.8 .1-2.7z"]
}, faHand = {
  prefix: "fas",
  iconName: "hand",
  icon: [512, 512, [129306, 9995, "hand-paper"], "f256", "M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 208c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 272c0 1.5 0 3.1 .1 4.6L67.6 283c-16-15.2-41.3-14.6-56.6 1.4s-14.6 41.3 1.4 56.6L124.8 448c43.1 41.1 100.4 64 160 64l19.2 0c97.2 0 176-78.8 176-176l0-208c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-208z"]
}, faHandPaper = faHand, faPersonBikingMountain = {
  prefix: "fas",
  iconName: "person-biking-mountain",
  icon: [640, 512, [128693, "biking-mountain"], "f84b", "M448 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM427.2 160l-61.8-48.8c-17.3-13.6-41.7-13.8-59.1-.3l-83.1 64.2c-30.7 23.8-28.5 70.8 4.3 91.6L288 305.1 288 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-10.7-5.3-20.7-14.2-26.6L295 232.9l60.3-48.5L396 217c5.7 4.5 12.7 7 20 7l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-52.8 0zm-238.8 6.7L290.8 89.9c7.2-5.4 8.5-15.7 2.9-22.8L278.8 48.4c-21.6-27-60.7-32-88.4-11.2L125.2 86.1c-7.2 5.4-8.5 15.7-2.9 22.8l44 55c5.4 6.7 15.2 8 22.1 2.8zM120 256c-12.1 0-22.1 8.9-23.8 20.6c-7.6 2.2-14.9 5.3-21.7 9c-9.4-7.1-22.8-6.3-31.3 2.3L31.8 299.1c-8.6 8.6-9.3 21.9-2.3 31.3c-3.7 6.9-6.8 14.1-9 21.8C8.9 353.9 0 363.9 0 376l0 16c0 12.1 8.9 22.1 20.6 23.8c2.2 7.6 5.3 14.9 9 21.8c-7 9.4-6.3 22.8 2.3 31.3l11.3 11.3c8.6 8.6 21.9 9.3 31.3 2.2c6.8 3.7 14.1 6.8 21.7 9C97.9 503.1 107.9 512 120 512l16 0c12.1 0 22.1-8.9 23.8-20.6c7.6-2.2 14.9-5.3 21.7-9c9.4 7 22.8 6.3 31.3-2.2l11.3-11.3c8.6-8.6 9.3-21.9 2.3-31.3c3.7-6.8 6.8-14.1 9-21.7c11.6-1.7 20.6-11.7 20.6-23.8l0-16c0-12.1-8.9-22.1-20.6-23.8c-2.2-7.6-5.3-14.9-9-21.7c7-9.4 6.3-22.8-2.3-31.3l-11.3-11.3c-8.6-8.6-21.9-9.3-31.3-2.3c-6.8-3.7-14.1-6.8-21.7-9C158.1 264.9 148.1 256 136 256l-16 0zm8 64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm352.2-43.4c-7.6 2.2-14.9 5.3-21.7 9c-9.4-7.1-22.8-6.3-31.3 2.3l-11.3 11.3c-8.6 8.6-9.3 21.9-2.2 31.3c-3.7 6.9-6.8 14.1-9 21.8C392.9 353.9 384 363.9 384 376l0 16c0 12.1 8.9 22.1 20.6 23.8c2.2 7.6 5.3 14.9 9 21.8c-7 9.4-6.3 22.8 2.2 31.3l11.3 11.3c8.5 8.6 21.9 9.3 31.3 2.2c6.8 3.7 14.1 6.8 21.7 9c1.7 11.6 11.7 20.6 23.8 20.6l16 0c12.1 0 22.1-8.9 23.8-20.6c7.6-2.2 14.9-5.3 21.8-9c9.4 7 22.8 6.3 31.3-2.2l11.3-11.3c8.6-8.6 9.3-21.9 2.2-31.3c3.7-6.8 6.8-14.1 9-21.7c11.6-1.7 20.6-11.7 20.6-23.8l0-16c0-12.1-8.9-22.1-20.6-23.8c-2.2-7.6-5.3-14.9-9-21.7c7-9.4 6.3-22.8-2.2-31.3l-11.3-11.3c-8.6-8.6-21.9-9.3-31.3-2.3c-6.9-3.7-14.1-6.8-21.8-9C542.1 264.9 532.1 256 520 256l-16 0c-12.1 0-22.1 8.9-23.8 20.6zM448 384a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]
}, faBikingMountain = faPersonBikingMountain, faUtensilsSlash = {
  prefix: "fas",
  iconName: "utensils-slash",
  icon: [640, 512, [], "e464", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-86.8-68 0-49.1 0-112 0-208c0-17.7-14.3-32-32-32C496 0 384 32 384 176l0 99.7-77.6-60.8c8.6-13.6 13.6-29.7 13.6-47c0-6.4-.7-12.8-2.1-19.1L287.6 12.5c-1.8-8-9.3-13.3-17.4-12.4S256 7.8 256 16l0 134.2c0 5.4-4.4 9.8-9.8 9.8c-5.1 0-9.3-3.9-9.8-9L223.9 14.6C223.2 6.3 216.3 0 208 0s-15.2 6.3-15.9 14.6l-9.4 103.3L160 100.1 160 16c0-8.2-6.1-15-14.3-15.9s-15.6 4.5-17.4 12.4L116.5 66 38.8 5.1zM176 255.6L176 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-194.9L96.1 171.7c1.9 44.2 36.3 80 79.9 83.9z"]
}, faPrintMagnifyingGlass = {
  prefix: "fas",
  iconName: "print-magnifying-glass",
  icon: [640, 512, ["print-search"], "f81a", "M192 0L418.7 0c17 0 33.3 6.7 45.3 18.7L493.3 48c12 12 18.7 28.3 18.7 45.3l0 66.7-64 0 0-66.7L418.7 64 192 64l0 96-64 0 0-96c0-35.3 28.7-64 64-64zM128 192l224 0c-38.9 29.2-64 75.7-64 128c0 11 1.1 21.7 3.2 32L192 352l0 16 0 16 0 64 160 0c26.7 20.1 60 32 96 32c17.5 0 34.4-2.8 50.2-8l6.3 6.3c-10.8 20.1-32 33.8-56.4 33.8l-256 0c-35.3 0-64-28.7-64-64l0-64-32 0c-17.7 0-32-14.3-32-32l0-96c0-35.3 28.7-64 64-64zM448 400.2a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 48c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128c0 26.7-8.2 51.4-22.1 71.9L633 471.2c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L519.9 426c-20.5 14-45.3 22.1-71.9 22.1z"]
}, faPrintSearch = faPrintMagnifyingGlass, faTurnRight = {
  prefix: "fas",
  iconName: "turn-right",
  icon: [512, 512, [], "e639", "M334.5 66c8.8-3.8 19-2 26 4.6l144 136c4.8 4.5 7.5 10.8 7.5 17.4s-2.7 12.9-7.5 17.4l-144 136c-7 6.6-17.2 8.4-26 4.6s-14.5-12.5-14.5-22l0-88-192 0c-17.7 0-32 14.3-32 32l0 144c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 304c0-70.7 57.3-128 128-128l192 0 0-88c0-9.6 5.7-18.2 14.5-22z"]
}, faFolderBookmark = {
  prefix: "fas",
  iconName: "folder-bookmark",
  icon: [512, 512, [], "e186", "M448 480L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l128 0c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8l160 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64zM288 176l0 160c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L368 308l54.4 40.8c4.8 3.6 11.3 4.2 16.8 1.5s8.8-8.2 8.8-14.3l0-160c0-8.8-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16z"]
}, faArrowTurnLeftDown = {
  prefix: "fas",
  iconName: "arrow-turn-left-down",
  icon: [384, 512, [], "e633", "M342.6 374.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 402.7 224 96c0-17.7 14.3-32 32-32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L256 0c-53 0-96 43-96 96l0 306.7L86.6 329.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128c12.5 12.5 32.8 12.5 45.3 0l128-128z"]
}, faOm = {
  prefix: "fas",
  iconName: "om",
  icon: [512, 512, [128329], "f679", "M379.3 4.7c-6.2-6.2-16.4-6.2-22.6 0l-16 16c-6.2 6.2-6.2 16.4 0 22.6l16 16c6.2 6.2 16.4 6.2 22.6 0l16-16c6.2-6.2 6.2-16.4 0-22.6l-16-16zM281 66.7c-2.2-1.5-4.9-2.5-7.7-2.7c-.6 0-1.3-.1-1.9 0c-3.9 .2-7.4 1.7-10.1 4.2c-.9 .8-1.6 1.7-2.3 2.6c-1.7 2.4-2.7 5.3-2.9 8.5c0 .7 0 1.4 0 2.1c.2 2.2 .9 4.3 1.9 6.2l.3 .6c.3 .6 .8 1.4 1.4 2.4c1.2 2 2.9 4.8 5.1 8.2c4.4 6.7 11.1 15.5 20 24.4C302.4 141.1 330.3 160 368 160c31.2 0 56.6-10.4 73.9-20.2c8.7-5 15.6-9.9 20.4-13.8c2.4-1.9 4.3-3.6 5.7-4.9c.7-.6 1.3-1.2 1.7-1.6l.6-.5 .1-.1 .1-.1s0 0 0 0s0 0 0 0c5.9-5.8 9.5-13.9 9.5-22.8c0-17.7-14.3-32-32-32c-8.7 0-16.7 3.5-22.4 9.2c-.1 .1-.2 .2-.5 .4c-.5 .5-1.5 1.3-2.8 2.4c-2.7 2.2-6.8 5.2-12.1 8.2C399.4 90.4 384.8 96 368 96c-20.8 0-42.4-7-59.5-14.6c-8.4-3.7-15.4-7.5-20.3-10.3c-2.4-1.4-4.3-2.5-5.6-3.3c-.6-.4-1.1-.7-1.4-.9l-.3-.2zM115.2 169.6c8-6 17.9-9.6 28.8-9.6c26.5 0 48 21.5 48 48s-21.5 48-48 48l-34.2 0c-7.6 0-13.8 6.2-13.8 13.8c0 1.5 .2 2.9 .7 4.4l8 24c4.4 13.1 16.6 21.9 30.4 21.9l8.9 0 16 0c35.3 0 64 28.7 64 64s-28.7 64-64 64c-50.8 0-82.7-21.5-102.2-42.8c-9.9-10.8-16.6-21.6-20.9-29.7c-2.1-4-3.6-7.3-4.5-9.6c-.5-1.1-.8-2-1-2.5l-.2-.5c-.3-.9-.7-1.8-1.1-2.6c-1.2-2.2-2.8-4-4.7-5.4c-1.9-1.4-4.1-2.3-6.5-2.8c-1.4-.3-2.9-.3-4.4-.2c-2.5 .2-4.8 1-6.8 2.3c-1.1 .7-2.2 1.5-3.1 2.5c-2.4 2.5-4.1 5.8-4.5 9.5c-.1 .6-.1 1.1-.1 1.7c0 0 0 0 0 0c0 .8 .1 1.7 .2 2.5l0 .1c0 .3 .1 .8 .2 1.3c.2 1.1 .4 2.7 .8 4.6c.8 3.9 2 9.4 3.9 15.9c3.8 13 10.3 30.4 21.3 48C48.7 476.2 89.4 512 160 512c70.7 0 128-57.3 128-128c0-23.3-6.2-45.2-17.1-64l22.6 0c25.5 0 49.9-10.1 67.9-28.1l26.5-26.5c6-6 14.1-9.4 22.6-9.4l5.5 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32c-25.7 0-41.4-12.5-51.2-25.6c-5-6.7-8.4-13.4-10.5-18.6c-1.1-2.5-1.8-4.6-2.2-6c-.2-.7-.4-1.2-.5-1.5l-.1-.2c-.3-1.3-.8-2.6-1.5-3.8c-1.1-2-2.6-3.8-4.4-5.1c-2.7-2-6-3.2-9.6-3.2l-.2 0c-8 .1-14.6 6.1-15.6 13.9c0 0 0 0 0 0c0 .3-.1 .6-.2 1.1c-.1 .9-.3 2.1-.4 3.6c-.3 3-.6 7.3-.6 12.4c0 10.1 1.1 23.9 5.8 38.1c4.8 14.3 13.4 29.3 28.6 40.7C368.7 473.3 389.3 480 416 480c53 0 96-43 96-96l0-96c0-53-43-96-96-96l-5.5 0c-25.5 0-49.9 10.1-67.9 28.1l-26.5 26.5c-6 6-14.1 9.4-22.6 9.4l-48.3 0c6.9-14.5 10.8-30.8 10.8-48c0-61.9-50.1-112-112-112c-25.2 0-48.5 8.3-67.2 22.4c-14.1 10.6-17 30.7-6.4 44.8s30.7 17 44.8 6.4z"]
}, faPi = {
  prefix: "fas",
  iconName: "pi",
  icon: [448, 512, [], "f67e", "M32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l64 0 0 156c0 39.7-9.3 78.9-27 114.5l-1.6 3.2c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l1.6-3.2C148.4 382.7 160 333.7 160 284l0-156 128 0 0 238.6c0 45 36.5 81.4 81.4 81.4c30.8 0 59-17.4 72.8-45l2.3-4.7c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3l-2.3 4.7c-3 5.9-9 9.6-15.6 9.6c-9.6 0-17.4-7.8-17.4-17.4L352 128l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 64z"]
}, faFlaskRoundPotion = {
  prefix: "fas",
  iconName: "flask-round-potion",
  icon: [448, 512, ["flask-potion"], "f6e1", "M192 64l64 0 0 93.7c0 30.4 16.9 56.1 40.3 69.7c43 25 71.6 71.4 71.7 124.4c-58.6-1.7-85.4-12.6-109.9-22.6c-22-9-42.2-17.2-82.1-17.2c-42.3 0-73.4 9.2-94.5 18.8c6.5-44.1 33-81.7 70.2-103.4c23.4-13.6 40.3-39.3 40.3-69.7L192 64zm128 93.7L320 64c17.7 0 32-14.3 32-32s-14.3-32-32-32L304 0 144 0 128 0C110.3 0 96 14.3 96 32s14.3 32 32 32l0 93.7c0 6-3.3 11.4-8.5 14.4C57.6 208.2 16 275.2 16 352c0 56 22.1 106.9 58.2 144.3C84.5 507 99.3 512 114.2 512l219.6 0c15 0 29.7-5 40.1-15.7C409.9 458.9 432 408 432 352c0-76.8-41.6-143.8-103.5-179.9c-5.2-3-8.5-8.4-8.5-14.4z"]
}, faFlaskPotion = faFlaskRoundPotion, faFaceShush = {
  prefix: "fas",
  iconName: "face-shush",
  icon: [512, 512, [], "e38c", "M0 256C0 359.8 61.8 449.1 150.5 489.3c-4.2-10.3-6.5-21.5-6.5-33.3l0-24 0-24c0-37.3 23.2-69.2 56-82l0-50.1c-14.8-6.9-26.6-15.9-35.3-24.6c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0c3.7 3.7 8.1 7.4 13.3 10.9c4-27 27.3-47.6 55.4-47.6s51.3 20.7 55.4 47.6c5.2-3.5 9.6-7.3 13.3-10.9c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-8.7 8.7-20.5 17.7-35.3 24.6l0 58.3c17.9 11.7 31.3 29.7 37 50.9c16-3.2 33.3 .6 46.9 11.9c18.4 15.3 24.5 39.9 17.1 61.3c60.3-46.8 99-120 99-202.3C512 114.6 397.4 0 256 0S0 114.6 0 256zM176.4 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM280 248c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72 48 0 0-72zM224 408c0-4.4 3.6-8 8-8l32 0c4.4 0 8 3.6 8 8l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-30.9-25.1-56-56-56l-32 0c-30.9 0-56 25.1-56 56l0 24 0 24c0 30.9 25.1 56 56 56l48 0 17.5 0c21.4 0 41.6-9.5 55.3-25.9l25.6-30.7c8.5-10.2 7.1-25.3-3.1-33.8s-25.3-7.1-33.8 3.1L316 455.4c-4.6 5.5-11.3 8.6-18.4 8.6l-10 0L224 419.5l0-11.5z"]
}, faWorm = {
  prefix: "fas",
  iconName: "worm",
  icon: [512, 512, [], "e599", "M256 96c0-53 43-96 96-96l38.4 0C439.9 0 480 40.1 480 89.6l0 86.4 0 16 0 184c0 75.1-60.9 136-136 136s-136-60.9-136-136l0-80c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 168c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-168c0-75.1 60.9-136 136-136s136 60.9 136 136l0 80c0 22.1 17.9 40 40 40s40-17.9 40-40l0-184-32 0c-53 0-96-43-96-96zm144-8a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]
}, faHouseCircleXmark = {
  prefix: "fas",
  iconName: "house-circle-xmark",
  icon: [640, 512, [], "e50b", "M320.7 352c8.1-89.7 83.5-160 175.3-160c8.9 0 17.6 .7 26.1 1.9L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24c0 18 14 32.1 32 32.1l32 0 0 69.7c-.1 .9-.1 1.8-.1 2.8l0 112c0 22.1 17.9 40 40 40l16 0c1.2 0 2.4-.1 3.6-.2c1.5 .1 3 .2 4.5 .2l31.9 0 24 0c22.1 0 40-17.9 40-40l0-24 0-64c0-17.7 14.3-32 32-32l64 0 .7 0zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7L518.6 368l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L496 390.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L473.4 368l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L496 345.4l36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]
}, faPlug = {
  prefix: "fas",
  iconName: "plug",
  icon: [384, 512, [128268], "f1e6", "M96 0C78.3 0 64 14.3 64 32l0 96 64 0 0-96c0-17.7-14.3-32-32-32zM288 0c-17.7 0-32 14.3-32 32l0 96 64 0 0-96c0-17.7-14.3-32-32-32zM32 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 32c0 77.4 55 142 128 156.8l0 67.2c0 17.7 14.3 32 32 32s32-14.3 32-32l0-67.2C297 398 352 333.4 352 256l0-32c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 160z"]
}, faCalendarCircleExclamation = {
  prefix: "fas",
  iconName: "calendar-circle-exclamation",
  icon: [576, 512, [], "e46e", "M128 0C110.3 0 96 14.3 96 32l0 32L48 64C21.5 64 0 85.5 0 112l0 48 448 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32zM256 368c0-91.8 70.3-167.2 160-175.3l0-.7L0 192 0 464c0 26.5 21.5 48 48 48l282.8 0C285.6 480.1 256 427.5 256 368zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0-144c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]
}, faSquareI = {
  prefix: "fas",
  iconName: "square-i",
  icon: [448, 512, [], "e272", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm88 96l72 0 72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 160 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-160-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faChevronUp = {
  prefix: "fas",
  iconName: "chevron-up",
  icon: [512, 512, [], "f077", "M233.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 173.3 86.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z"]
}, faFaceSaluting = {
  prefix: "fas",
  iconName: "face-saluting",
  icon: [640, 512, [129761], "e484", "M258.1 58.5s0 0 0 0c14.5-9.8 18.4-29.4 8.8-44c0 0 0 0 0 0c-.1-.1-.2-.3-.3-.4C256.7-.6 236.8-4.4 222.2 5.5L35.1 132.5c-44.3 30.1-47.1 94.4-5.6 128.2l1.5 1.2c18.9 15.4 43.2 20.9 66 16.5c4.4-.9 8.8-2.1 13.1-3.8c.3-.1 .7-.3 1-.4c.5-.2 1-.4 1.5-.6c5.6-2.3 10.9-5.4 16-9l82.3-59.9s0 0 0 0c14.3-10.4 17.5-30.4 7.1-44.7c-4.8-6.7-11.8-10.9-19.3-12.5c-3.5-.7-7.2-.9-10.8-.4c-5.1 .7-10.1 2.6-14.6 5.8L128 185.8l0-39.1 27.3-18.5 13.1-8.9 89.7-60.9zM352 0c-18.4 0-36.3 1.9-53.5 5.6c12.6 27.9 3.8 61.6-22.4 79.4l-54.6 37c8.6 4.4 16.3 10.9 22.3 19.2c8.6 11.9 12.6 25.7 12.2 39.3c4.8-2.8 10.4-4.5 16.3-4.5c17.7 0 32 14.3 32 32s-14.3 32-32 32c-13.9 0-25.8-8.9-30.2-21.4c-3.5 4.4-7.7 8.5-12.5 12l-82.3 59.9c-13.9 10.1-29.5 16.6-45.6 19.6C126.5 425.5 229.1 512 352 512c141.4 0 256-114.6 256-256S493.4 0 352 0zM257.4 341c17.5 12.6 48.9 27 94.6 27s77.2-14.4 94.6-27c7.2-5.2 17.2-3.5 22.3 3.6s3.5 17.2-3.6 22.3c-22.7 16.4-60.7 33-113.4 33s-90.6-16.6-113.4-33c-7.2-5.2-8.8-15.2-3.6-22.3s15.2-8.8 22.3-3.6zm175-165a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faGaugeSimpleLow = {
  prefix: "fas",
  iconName: "gauge-simple-low",
  icon: [512, 512, ["tachometer-slow"], "f62c", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-35.3-28.7-64-64-64c-2.1 0-4.1 .1-6.1 .3L173.3 140.9c-6.1-11.8-20.6-16.3-32.4-10.2s-16.3 20.6-10.2 32.4l76.6 147.4C197.8 321.6 192 336.1 192 352c0 35.3 28.7 64 64 64s64-28.7 64-64z"]
}, faTachometerSlow = faGaugeSimpleLow, faFacePersevering = {
  prefix: "fas",
  iconName: "face-persevering",
  icon: [512, 512, [], "e385", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm60.1-101.3c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6C188.2 371.4 216.3 352 256 352s67.8 19.4 83.9 37.3c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2zm-104.8-310c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2s4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0zm89.4 22.6c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4zM133.5 210.7l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6c0-9 9.6-14.7 17.5-10.5zM396 221.1c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z"]
}, faCircleCamera = {
  prefix: "fas",
  iconName: "circle-camera",
  icon: [512, 512, ["camera-circle"], "e103", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM196 160l6.2-16.4c3.5-9.4 12.5-15.6 22.5-15.6l62.7 0c10 0 19 6.2 22.5 15.6L316 160l36 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l36 0zm108 96a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]
}, faCameraCircle = faCircleCamera, faHandSpock = {
  prefix: "fas",
  iconName: "hand-spock",
  icon: [576, 512, [128406], "f259", "M246.9 23.7C242.3 6.6 224.8-3.5 207.7 1.1s-27.2 22.1-22.6 39.2L238 237.8c2.5 9.2-4.5 18.2-14 18.2c-6.4 0-12-4.2-13.9-10.3L166.6 102.7c-5.1-16.9-23-26.4-39.9-21.3s-26.4 23-21.3 39.9l62.8 206.4c2.4 7.9-7.2 13.8-13.2 8.1L99.6 283c-16-15.2-41.3-14.6-56.6 1.4s-14.6 41.3 1.4 56.6L156.8 448c43.1 41.1 100.4 64 160 64l10.9 0 8.2 0c.1 0 .1-.1 .1-.1s.1-.1 .1-.1c58.3-3.5 108.6-43.2 125.3-99.7l81.2-275c5-16.9-4.7-34.7-21.6-39.8s-34.7 4.7-39.8 21.6L443.5 247.1c-1.6 5.3-6.4 8.9-12 8.9c-7.9 0-13.8-7.3-12.2-15.1l36-170.3c3.7-17.3-7.4-34.3-24.7-37.9s-34.3 7.4-37.9 24.7L355.1 235.1c-2.6 12.2-13.3 20.9-25.8 20.9c-11.9 0-22.4-8-25.4-19.5l-57-212.8z"]
}, faSpiderWeb = {
  prefix: "fas",
  iconName: "spider-web",
  icon: [576, 512, [128376], "f719", "M133.8 22.2c4.8-12.7 18-20.2 31.4-17.7l69 12.9c35.6 6.7 72.1 6.7 107.6 0l69-12.9c13.4-2.5 26.6 5 31.4 17.7l28.9 77.2c11.5 30.7 28.1 59.2 49.1 84.4l45.3 54.3c8.7 10.4 8.7 25.5 0 35.9l-45.3 54.3c-21 25.2-37.6 53.7-49.1 84.4l-28.9 77.2c-4.8 12.7-18 20.2-31.4 17.7l-69-12.9c-35.6-6.7-72.1-6.7-107.6 0l-69 12.9c-13.4 2.5-26.6-5-31.4-17.7l-28.9-77.2C93.3 382 76.7 353.4 55.7 328.2L10.5 273.9c-8.7-10.4-8.7-25.5 0-35.9l45.3-54.3c21-25.2 37.6-53.7 49.1-84.4l28.9-77.2zm33.3 70.6L157.3 119c-13.7 36.6-33.5 70.6-58.5 100.6L88.4 232l44.6 0c23.5-27.6 41.7-59.2 53.7-93.4l2.5-7L167.1 92.8zm42.1-23.1l21.4 37.4c37.7 9.5 77.2 9.5 114.9 0l21.4-37.4-14.7 2.8c-42.4 7.9-85.9 7.9-128.3 0l-14.7-2.8zM408.9 92.8l-22.2 38.8 2.5 7c12.1 34.2 30.3 65.8 53.8 93.4l44.6 0-10.3-12.4c-25-30-44.8-64-58.5-100.6l-9.8-26.2zM487.6 280L443 280c-23.6 28.1-41.8 60.4-53.6 95.3l-2.1 6.1 21.6 37.9 9.8-26.2c13.7-36.6 33.5-70.6 58.5-100.6L487.6 280zM366.8 442.3l-19.5-34.2c-37.9-11.7-78.3-12.8-116.7-3.2l-21.3 37.4 14.7-2.7c42.4-7.9 85.9-7.9 128.3 0l14.7 2.7zM167.1 419.2l22.2-38.8-2.5-7c-12.1-34.2-30.3-65.8-53.7-93.4l-44.6 0 10.3 12.4c25 30 44.8 64 58.5 100.6l9.8 26.2zM193.2 280c10.1 15 18.9 30.7 26.5 47.1L246.6 280l-53.4 0zm67.9 71.4c18.1-1.5 36.3-1.2 54.3 1L288 304.4l-26.9 47zm95.5-23.7c7.6-16.6 16.4-32.5 26.5-47.7l-53.8 0 27.3 47.7zM382.8 232c-10.1-15-18.9-30.7-26.5-47.1L329.4 232l53.4 0zm-68.1-71c-17.7 1.7-35.6 1.7-53.3 0L288 207.6 314.7 161zm-94.9 23.9c-7.6 16.4-16.5 32.1-26.5 47.1l53.4 0-26.9-47.1z"]
}, faCircleMicrophone = {
  prefix: "fas",
  iconName: "circle-microphone",
  icon: [512, 512, ["microphone-circle"], "e116", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM208 144c0-26.5 21.5-48 48-48s48 21.5 48 48l0 112c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-112zm-64 80c8.8 0 16 7.2 16 16l0 16c0 53 43 96 96 96s96-43 96-96l0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16c0 65.3-48.9 119.1-112 127l0 17c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-17c-63.1-7.9-112-61.7-112-127l0-16c0-8.8 7.2-16 16-16z"]
}, faMicrophoneCircle = faCircleMicrophone, faBookArrowUp = {
  prefix: "fas",
  iconName: "book-arrow-up",
  icon: [448, 512, [], "e0ba", "M0 96C0 43 43 0 96 0L384 0l32 0c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32l0 64c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0L96 512c-53 0-96-43-96-96L0 96zM64 416c0 17.7 14.3 32 32 32l256 0 0-64-88 0 0-174.1 39 39c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0l-80 80c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l39-39L216 384 96 384c-17.7 0-32 14.3-32 32z"]
}, faPopsicle = {
  prefix: "fas",
  iconName: "popsicle",
  icon: [320, 512, [], "e43e", "M160 0C71.6 0 0 71.6 0 160L0 336c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-176C320 71.6 248.4 0 160 0zm32 480l0-64-64 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32z"]
}, faCommand = {
  prefix: "fas",
  iconName: "command",
  icon: [512, 512, [], "e142", "M0 96C0 43 43 0 96 0s96 43 96 96l0 32 128 0 0-32c0-53 43-96 96-96s96 43 96 96s-43 96-96 96l-32 0 0 128 32 0c53 0 96 43 96 96s-43 96-96 96s-96-43-96-96l0-32-128 0 0 32c0 53-43 96-96 96s-96-43-96-96s43-96 96-96l32 0 0-128-32 0C43 192 0 149 0 96zm128 32l0-32c0-17.7-14.3-32-32-32S64 78.3 64 96s14.3 32 32 32l32 0zm64 192l128 0 0-128-128 0 0 128zm-64 64l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32s32-14.3 32-32l0-32zm256 0l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32s-14.3-32-32-32l-32 0zm0-256l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32s-32 14.3-32 32l0 32z"]
}, faBlinds = {
  prefix: "fas",
  iconName: "blinds",
  icon: [512, 512, [], "f8fb", "M32 0C14.3 0 0 14.3 0 32C0 43.4 6 53.4 15 59.1L1.1 100.8c-.7 2.1-1.1 4.3-1.1 6.5C0 118.8 9.2 128 20.6 128L128 128l0-64 32 0 0 64 331.4 0c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L497 59.1c9-5.7 15-15.7 15-27.1c0-17.7-14.3-32-32-32L32 0zM24 160L1.1 228.8c-.7 2.1-1.1 4.3-1.1 6.5C0 246.8 9.2 256 20.6 256l78.1 0c4.8-13.6 15.6-24.4 29.3-29.3l0-66.7L24 160zM144 320c-20.9 0-38.7-13.4-45.3-32L24 288 1.1 356.8c-.7 2.1-1.1 4.3-1.1 6.5C0 374.8 9.2 384 20.6 384l470.7 0c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L488 288l-298.7 0c-6.6 18.6-24.4 32-45.3 32zm16-93.3c13.6 4.8 24.4 15.6 29.3 29.3l302.1 0c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L488 160l-328 0 0 66.7zM20.6 512l470.7 0c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L488 416 24 416 1.1 484.8c-.7 2.1-1.1 4.3-1.1 6.5C0 502.8 9.2 512 20.6 512z"]
}, faStopwatch = {
  prefix: "fas",
  iconName: "stopwatch",
  icon: [448, 512, [9201], "f2f2", "M176 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l16 0 0 34.4C92.3 113.8 16 200 16 304c0 114.9 93.1 208 208 208s208-93.1 208-208c0-41.8-12.3-80.7-33.5-113.2l24.1-24.1c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L355.7 143c-28.1-23-62.2-38.8-99.7-44.6L256 64l16 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L224 0 176 0zm72 192l0 128c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-128c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faSaxophone = {
  prefix: "fas",
  iconName: "saxophone",
  icon: [640, 512, [127927], "f8dc", "M246.7 176L171.4 306.1c-2.2 3.8-3.4 8.2-3.4 12.6l0 2.6c0 12.5 10.1 22.6 22.6 22.6c6 0 11.8-2.4 16-6.6L319 225l-8-8c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l8 8L367 177l-8-8c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l8 8L415 129l-8-8c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l8 8 44.3-44.3c12-12 28.3-18.7 45.3-18.7l30.3 0c15 0 29.5 5.2 41 14.8l24.3 20.3c3.7 3.1 5.9 7.7 5.9 12.6c0 9-7.3 16.3-16.3 16.3l-64.2 0c-9.8 0-19 4.5-25.1 12.1L288.6 418.6C257.9 457.4 211.2 480 161.8 480C72.4 480 0 407.6 0 318.2l0-3.1c0-12.7 1.5-25.4 4.4-37.8L28.2 176 24 176c-13.3 0-24-10.7-24-24s10.7-24 24-24l240 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-17.3 0zM120 320a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm8-72a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faSquare2 = {
  prefix: "fas",
  iconName: "square-2",
  icon: [448, 512, [], "e257", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM190.7 184.7l-24.2 18.4c-10.5 8-25.6 6-33.6-4.5s-6-25.6 4.5-33.6l24.2-18.4c15.8-12 35.2-18.4 55.1-18.1l3.4 .1c46.5 .7 83.8 38.6 83.8 85.1c0 23.5-9.7 46-26.9 62.1L212.7 336l83.3 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-9.8 0-18.7-6-22.3-15.2s-1.3-19.6 5.9-26.3L244.3 240.6c7.5-7 11.7-16.8 11.7-27.1c0-20.3-16.3-36.8-36.6-37.1l-3.4-.1c-9.1-.1-18 2.8-25.3 8.3z"]
}, faFieldHockeyStickBall = {
  prefix: "fas",
  iconName: "field-hockey-stick-ball",
  icon: [512, 512, [127953, "field-hockey"], "f44c", "M491.2 8.5c21.8 15.1 27.3 45 12.2 66.8l-52.2 75.5L371.3 97.5l53.1-76.8c15.1-21.8 45-27.3 66.8-12.2zM353.1 123.9L433 177.2 241 454.9c-24.6 35.5-64.9 56.8-108.1 56.9C59.5 512 .1 452.3 .6 378.9l0-2.2c.2-25.7 7.8-50.8 21.8-72.4l17.3-26.5c14.5-22.2 44.2-28.4 66.4-13.9s28.4 44.2 13.9 66.4l-17.3 26.5c-4 6.1-6.2 13.3-6.2 20.6l0 2.2c-.1 20 16 36.2 36 36.1c11.7 0 22.7-5.8 29.4-15.5L353.1 123.9zM432 352a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"]
}, faFieldHockey = faFieldHockeyStickBall, faArrowUpSquareTriangle = {
  prefix: "fas",
  iconName: "arrow-up-square-triangle",
  icon: [576, 512, ["sort-shapes-up-alt"], "f88b", "M183.6 42.4C177.5 35.8 169 32 160 32s-17.5 3.8-23.6 10.4l-88 96c-11.9 13-11.1 33.3 2 45.2s33.3 11.1 45.2-2L128 146.3 128 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-301.7 32.4 35.4c11.9 13 32.2 13.9 45.2 2s13.9-32.2 2-45.2l-88-96zM320 80l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48zM443.1 303c-5.8-9.4-16.1-15-27.1-15s-21.3 5.7-27.1 15l-80 128c-6.2 9.9-6.5 22.3-.9 32.5s16.4 16.5 28 16.5l160 0c11.6 0 22.3-6.3 28-16.5s5.3-22.6-.9-32.5l-80-128z"]
}, faSortShapesUpAlt = faArrowUpSquareTriangle, faFaceScream = {
  prefix: "fas",
  iconName: "face-scream",
  icon: [640, 512, [], "e38b", "M573.9 288.5c1.4-10.7 2.1-21.5 2.1-32.5C576 114.6 461.4 0 320 0S64 114.6 64 256c0 11 .7 21.9 2.1 32.6c20.6-2.5 41.7 3.5 57.8 16.9c0 0 0 0 0 0c57.5 48 87.8 118 98 187C252.1 505.1 285.2 512 320 512c34.8 0 68-6.9 98.2-19.5c10.2-69 40.4-139 98-187c0 0 0 0 0 0c16.1-13.4 37.2-19.4 57.8-17zM320 320c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48zm-46.6-77c-22.5 36.9-62.8 54.7-90.1 39.8s-31.1-56.9-8.7-93.7s62.8-54.7 90.1-39.8s31.1 56.9 8.7 93.7zm183.3 39.8c-27.3 14.9-67.6-2.9-90.1-39.8s-18.6-78.8 8.7-93.7s67.6 2.9 90.1 39.8s18.6 78.8-8.7 93.7zM103.4 330.1C89.1 318.2 68 316.4 51.6 327c-20 13-25.6 39.5-12.4 59.3c26.4 40 43.6 75.3 43.2 125.7L192 512c-7-68.4-34.8-137-88.7-181.9zM588.5 327c-16.4-10.6-37.6-8.8-51.8 3.1C482.8 375 455 443.6 448 512l109.8 0c-.4-50.5 16.7-85.7 43.2-125.7c13.1-19.8 7.6-46.3-12.4-59.3z"]
}, faSquareM = {
  prefix: "fas",
  iconName: "square-m",
  icon: [448, 512, [], "e276", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm75.5 105.9L224 255l84.5-117.1c6.1-8.4 16.9-12 26.8-8.8s16.6 12.4 16.6 22.8l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-133.8-60.5 83.8c-4.5 6.2-11.7 9.9-19.5 9.9s-14.9-3.7-19.5-9.9L144 226.2 144 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-10.4 6.7-19.6 16.6-22.8s20.7 .3 26.8 8.8z"]
}, faCameraWeb = {
  prefix: "fas",
  iconName: "camera-web",
  icon: [448, 512, ["webcam"], "f832", "M344.2 413.1C406.6 373.3 448 303.5 448 224C448 100.3 347.7 0 224 0S0 100.3 0 224c0 79.5 41.4 149.3 103.8 189.1L45.6 453.8c-11.4 8-16.4 22.5-12.2 35.8S50 512 64 512l320 0c14 0 26.3-9.1 30.5-22.4s-.7-27.8-12.2-35.8l-58.2-40.7zM224 352a128 128 0 1 0 0-256 128 128 0 1 0 0 256zm0-288a160 160 0 1 1 0 320 160 160 0 1 1 0-320zM176 224c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-44.2 35.8-80 80-80c8.8 0 16 7.2 16 16s-7.2 16-16 16c-26.5 0-48 21.5-48 48z"]
}, faWebcam = faCameraWeb, faCommentArrowDown = {
  prefix: "fas",
  iconName: "comment-arrow-down",
  icon: [512, 512, [], "e143", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zm24-296l0 118.1 31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31L232 152c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faLightbulbCfl = {
  prefix: "fas",
  iconName: "lightbulb-cfl",
  icon: [320, 512, [], "e5a6", "M167.8 63c17.1-4.3 27.6-21.7 23.3-38.8S169.4-3.3 152.2 1L24.2 33C7.1 37.2-3.3 54.6 1 71.8S22.6 99.3 39.8 95l128-32zM319 88.2c-4.3-17.1-21.7-27.6-38.8-23.3l-256 64C7.1 133.2-3.3 150.6 1 167.8s21.7 27.6 38.8 23.3l256-64c17.1-4.3 27.6-21.7 23.3-38.8zM295.8 223c17.1-4.3 27.6-21.7 23.3-38.8s-21.7-27.6-38.8-23.3l-256 64C7.1 229.2-3.3 246.6 1 263.8s21.7 27.6 38.8 23.3l256-64zM64 416l0 32c0 17.7 14.3 32 32 32l32 0c0 17.7 14.3 32 32 32s32-14.3 32-32l32 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-80 0 0-90L96 306l0 78c-17.7 0-32 14.3-32 32zM319 280.2c-4.3-17.1-21.7-27.6-38.8-23.3l-64 16-16 4c-13.2 3.3-22.4 14.3-24 27l-.2 0 0 3.3c0 .5 0 .9 0 1.4l0 75.3 48 0 0-47 7.8-1.9 64-16c17.1-4.3 27.6-21.7 23.3-38.8z"]
}, faWindowFrameOpen = {
  prefix: "fas",
  iconName: "window-frame-open",
  icon: [512, 512, [], "e050", "M480 224l0-160c0-35.3-28.7-64-64-64L96 0C60.7 0 32 28.7 32 64l0 160 0 64 64 0 320 0 64 0 0-64zm-64 0l-136 0 0-160 136 0 0 160zm-184 0L96 224 96 64l136 0 0 160zM96 448l0-128-64 0 0 128c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 384 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-128-64 0 0 128L96 448z"]
}, faFaceKiss = {
  prefix: "fas",
  iconName: "face-kiss",
  icon: [512, 512, [128535, "kiss"], "f596", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm48.7-198.3c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C274.7 443.1 257.4 448 240 448c-3.6 0-6.8-2.5-7.7-6s.6-7.2 3.8-9c0 0 0 0 0 0s0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-.9-.5l-.2-.1c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.5-1.4-4.1-4.1-4.1-7s1.6-5.6 4.1-7c0 0 0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.1 .3-.2 .6-.4c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.4-.3-.5-.3-.2-.1c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-3.2-1.8-4.7-5.5-3.8-9s4.1-6 7.7-6c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faKiss = faFaceKiss, faBridgeCircleXmark = {
  prefix: "fas",
  iconName: "bridge-circle-xmark",
  icon: [640, 512, [], "e4cb", "M64 32C46.3 32 32 46.3 32 64s14.3 32 32 32l40 0 0 64-72 0 0 128c53 0 96 43 96 96l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96c6.3 0 12.4 .6 18.3 1.7C367.1 231.8 426.9 192 496 192c42.5 0 81.6 15.1 112 40.2l0-72.2-72 0 0-64 40 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 32zM488 96l0 64-80 0 0-64 80 0zM360 96l0 64-80 0 0-64 80 0zM232 96l0 64-80 0 0-64 80 0zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm59.3-180.7L518.6 368l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L496 390.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L473.4 368l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L496 345.4l36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]
}, faPeriod = {
  prefix: "fas",
  iconName: "period",
  icon: [192, 512, [], "2e", "M32 416a64 64 0 1 1 128 0A64 64 0 1 1 32 416z"]
}, faFaceGrinTongue = {
  prefix: "fas",
  iconName: "face-grin-tongue",
  icon: [512, 512, [128539, "grin-tongue"], "f589", "M0 256C0 368.9 73.1 464.7 174.5 498.8C165.3 484 160 466.6 160 448l0-47.3c-24-17.5-43.1-41.4-54.8-69.2c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19c12.3-3.8 24.3 6.9 19.3 18.7c-11.8 28-31.1 52-55.4 69.6l0 46.9c0 18.6-5.3 36-14.5 50.8C438.9 464.7 512 368.9 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256zm176.4-80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM320 448l0-45.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9c-2.8 12.6-20.8 12.6-23.6 0c-2.5-11.1-12.3-18.9-23.6-18.9l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 45.4c0 35.3 28.7 64 64 64s64-28.7 64-64z"]
}, faGrinTongue = faFaceGrinTongue, faUpToDottedLine = {
  prefix: "fas",
  iconName: "up-to-dotted-line",
  icon: [448, 512, [], "e457", "M64 64A32 32 0 1 1 0 64a32 32 0 1 1 64 0zm64 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM256 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm96 0a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM73.9 262.1L196.7 139.3c7.2-7.2 17.1-11.3 27.3-11.3s20.1 4.1 27.3 11.3L374.1 262.1c6.4 6.4 9.9 15 9.9 24c0 18.7-15.2 33.9-33.9 33.9L288 320l0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-128-62.1 0C79.2 320 64 304.8 64 286.1c0-9 3.6-17.6 9.9-24z"]
}, faThoughtBubble = {
  prefix: "fas",
  iconName: "thought-bubble",
  icon: [512, 512, [], "e32e", "M374.8 80.3C355.9 33.2 309.8 0 256 0s-99.9 33.2-118.8 80.3c-3-.2-6.1-.3-9.2-.3C57.3 80 0 137.3 0 208s57.3 128 128 128c14.4 0 28.3-2.4 41.3-6.8C184.7 361.6 217.7 384 256 384s71.3-22.4 86.7-54.8c12.9 4.4 26.8 6.8 41.3 6.8c70.7 0 128-57.3 128-128s-57.3-128-128-128c-3.1 0-6.1 .1-9.2 .3zM144 480a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM32 512a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faSkeletonRibs = {
  prefix: "fas",
  iconName: "skeleton-ribs",
  icon: [640, 512, [], "e5cb", "M352 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-27.8 0c-33.5 0-65.7 17.6-82.1 48.9C150.5 165.8 96 282.2 96 384l0 17c0 43.6 35.4 79 79 79c15.1 0 30.1-2.7 44.2-8l67.1-25.2c.6-.2 1.1-.4 1.7-.6l0 33.8c0 17.7 14.3 32 32 32s32-14.3 32-32l0-33.8c.6 .2 1.1 .4 1.7 .6L420.8 472c14.1 5.3 29.1 8 44.2 8c43.6 0 79-35.4 79-79l0-17c0-101.8-54.5-218.2-82.2-271.1C445.5 81.6 413.3 64 379.8 64L352 64l0-32zm-64 96l0 38.3-72.7 16.2c7-15.2 13.8-28.7 19.6-40c4.5-8.6 13.9-14.5 25.3-14.5l27.8 0zM186 254.6l102-22.7 0 39.7L171.2 303.4c4.1-16.5 9.2-32.9 14.7-48.8zM160.3 372.7L288 337.9l0 42c-8.2 1.7-16.3 4-24.2 7l-67.1 25.2c-7 2.6-14.3 3.9-21.7 3.9c-8.3 0-15-6.7-15-15l0-17c0-3.7 .1-7.5 .3-11.3zM352 379.9l0-40.9 118.8 35.6c3 .9 6.1 1.3 9.1 1.4c.1 2.7 .1 5.3 .1 8l0 17c0 8.3-6.7 15-15 15c-7.4 0-14.8-1.3-21.7-3.9l-67.1-25.2c-7.9-3-16-5.3-24.2-7zm117.8-72.4L352 272.2l0-40.3 102 22.7c6 17.2 11.4 35.1 15.7 53zm-45-125L352 166.3l0-38.3 27.8 0c11.4 0 20.8 5.9 25.3 14.5c5.9 11.3 12.6 24.8 19.6 40zM0 144l0 96L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-240c0-10.1 4.7-19.6 12.8-25.6l25.6-19.2C118.5 183.1 128 164.1 128 144c0-35.3-28.7-64-64-64S0 108.7 0 144zM576 80c-35.3 0-64 28.7-64 64c0 20.1 9.5 39.1 25.6 51.2l25.6 19.2c8.1 6 12.8 15.5 12.8 25.6l0 240c0 17.7 14.3 32 32 32s32-14.3 32-32l0-240 0-96c0-35.3-28.7-64-64-64z"]
}, faRaygun = {
  prefix: "fas",
  iconName: "raygun",
  icon: [576, 512, [], "e025", "M192 64l96 0 0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 240c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-.4L188.6 494.3c-7.9 15.8-27.1 22.2-42.9 14.3l-80-40c-15.8-7.9-22.2-27.1-14.3-42.9L120.2 288l-8.2 0C50.1 288 0 237.9 0 176C0 131.3 26.2 92.8 64 74.8l0-50.2C64 11 75 0 88.6 0c4.8 0 9.6 1.4 13.6 4.1L192 64zm200 0c13.3 0 24 10.7 24 24l0 56 60.9 0 77.1-30.9c4.9-2 10.5-1.4 14.9 1.6s7 7.9 7 13.2l0 96c0 5.3-2.6 10.3-7 13.2s-10 3.6-14.9 1.6L476.9 208 416 208l0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zM136 176a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faFlute = {
  prefix: "fas",
  iconName: "flute",
  icon: [640, 512, [], "f8b9", "M48 160l48 0 0 192-48 0c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48zM592 352l-464 0 0-192 464 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48zM320 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faAcorn = {
  prefix: "fas",
  iconName: "acorn",
  icon: [448, 512, [], "f6ae", "M262.4 4.8c10.6 8 12.8 23 4.8 33.6l-4.8 6.4c-4.4 5.9-7.9 12.4-10.3 19.2L352 64c53 0 96 43 96 96c0 17.7-14.3 32-32 32L32 192c-17.7 0-32-14.3-32-32c0-53 43-96 96-96l106.4 0C206 46.7 213.3 30.3 224 16l4.8-6.4c8-10.6 23-12.8 33.6-4.8zM213.9 476.4C78.5 425.9 48 302.1 48 224l176 0 176 0c0 78.1-30.5 201.9-165.9 252.4c-6.5 2.4-13.7 2.4-20.2 0z"]
}, faVideoArrowUpRight = {
  prefix: "fas",
  iconName: "video-arrow-up-right",
  icon: [576, 512, [], "e2c9", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm512 64c0-11.8-6.5-22.6-16.9-28.2s-23-5-32.9 1.6l-96 64L416 174.9l0 17.1 0 128 0 17.1 14.2 9.5 96 64c9.8 6.5 22.4 7.2 32.9 1.6s16.9-16.4 16.9-28.2l0-256zM152 160l112 0c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-54.1L137 345c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l103-103L152 208c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faGrateDroplet = {
  prefix: "fas",
  iconName: "grate-droplet",
  icon: [576, 512, [], "e194", "M0 96C0 60.7 28.7 32 64 32l64 0 96 0 96 0 64 0c35.3 0 64 28.7 64 64l0 66.2c-15.1 4.3-28.2 14.6-35.8 28.8L336.9 332.2C325.8 353.1 320 376.4 320 400c0 29.6 8.9 57.1 24.2 80L320 480l-96 0-96 0-64 0c-35.3 0-64-28.7-64-64L0 256 0 96zm96 0L64 96l0 128 32 0L96 96zM64 416l32 0 0-128-32 0 0 128zm128 0l0-128-32 0 0 128 32 0zm96 0l0-128-32 0 0 128 32 0zM384 96l-32 0 0 128 32 0 0-128zM256 96l0 128 32 0 0-128-32 0zm-96 0l0 128 32 0 0-128-32 0zM440.5 206.1c4.6-8.7 13.7-14.1 23.5-14.1s18.9 5.4 23.5 14.1l75.3 141.2c8.7 16.2 13.2 34.3 13.2 52.7c0 61.9-50.1 112-112 112s-112-50.1-112-112c0-18.4 4.5-36.5 13.2-52.7l75.3-141.2z"]
}, faSealExclamation = {
  prefix: "fas",
  iconName: "seal-exclamation",
  icon: [512, 512, [], "e242", "M222.1 17.9c18.7-18.7 49.1-18.7 67.9 0L336 64l64 0c26.5 0 48 21.5 48 48l0 64 45.6 45.6c18.7 18.7 18.7 49.1 0 67.9L448 335.1l0 64.9c0 26.5-21.5 48-48 48l-64.9 0-45.1 45.1c-18.7 18.7-49.1 18.7-67.9 0L176.9 448 112 448c-26.5 0-48-21.5-48-48l0-64.9L18.4 289.5c-18.7-18.7-18.7-49.1 0-67.9L64 176l0-64c0-26.5 21.5-48 48-48l64 0 46.1-46.1zM256 128c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faChessBishop = {
  prefix: "fas",
  iconName: "chess-bishop",
  icon: [320, 512, [9821], "f43a", "M128 0C110.3 0 96 14.3 96 32c0 16.1 11.9 29.4 27.4 31.7C78.4 106.8 8 190 8 288c0 47.4 30.8 72.3 56 84.7L64 400l192 0 0-27.3c25.2-12.5 56-37.4 56-84.7c0-37.3-10.2-72.4-25.3-104.1l-99.4 99.4c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L270.8 154.6c-23.2-38.1-51.8-69.5-74.2-90.9C212.1 61.4 224 48.1 224 32c0-17.7-14.3-32-32-32L128 0zM48 432L6.6 473.4c-4.2 4.2-6.6 10-6.6 16C0 501.9 10.1 512 22.6 512l274.7 0c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L272 432 48 432z"]
}, faMessageSms = {
  prefix: "fas",
  iconName: "message-sms",
  icon: [512, 512, [], "e1e5", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM96 180.8c0 12.3 6.2 23.8 16.4 30.7l29.4 19.6c1.3 .9 2.2 2.4 2.2 4c0 2.7-2.2 4.8-4.8 4.8L112 240c-8.8 0-16 7.2-16 16s7.2 16 16 16l27.2 0c20.3 0 36.8-16.5 36.8-36.8c0-12.3-6.2-23.8-16.4-30.7l-29.4-19.6c-1.3-.9-2.2-2.4-2.2-4c0-2.7 2.2-4.8 4.8-4.8l19.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-19.2 0C112.5 144 96 160.5 96 180.8zM372.8 144c-20.3 0-36.8 16.5-36.8 36.8c0 12.3 6.2 23.8 16.4 30.7l29.4 19.6c1.3 .9 2.2 2.4 2.2 4c0 2.7-2.2 4.8-4.8 4.8L352 240c-8.8 0-16 7.2-16 16s7.2 16 16 16l27.2 0c20.3 0 36.8-16.5 36.8-36.8c0-12.3-6.2-23.8-16.4-30.7l-29.4-19.6c-1.3-.9-2.2-2.4-2.2-4c0-2.7 2.2-4.8 4.8-4.8l19.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-19.2 0zm-152 6.4c-4.1-5.5-11.3-7.8-17.9-5.6S192 153.1 192 160l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 19.2 25.6c3 4 7.8 6.4 12.8 6.4s9.8-2.4 12.8-6.4L288 208l0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-6.9-4.4-13-10.9-15.2s-13.7 .1-17.9 5.6L256 197.3l-35.2-46.9z"]
}, faCoffeeBeans = {
  prefix: "fas",
  iconName: "coffee-beans",
  icon: [512, 512, [], "e13f", "M507.5 209.7c-3.4 12.3-19.1 11.8-25.4 .7c-5.4-9.5-11.3-18.5-17.6-26c-27.6-32.6-60.8-44.5-90.1-55l-1-.3c-30-10.7-55.8-20.2-77.5-45.9c-10.8-12.8-21.3-33.4-29.3-52c-1.7-4-.6-8.7 3-11.2C320.9-16 401.3-2.6 458 54c45.7 45.7 63.2 106.7 49.5 155.6zM228.5 78.3c3.4-12.3 19.1-11.8 25.4-.7c5.3 9.5 11.3 18.5 17.6 26c27.6 32.6 60.8 44.5 90.1 55l1 .3c30 10.7 55.8 20.2 77.5 45.9c10.8 12.8 21.3 33.4 29.3 52c1.7 4 .6 8.7-3 11.2C415.1 304 334.7 290.6 278 234c-45.7-45.7-63.2-106.7-49.5-155.6zM75.5 206c11.2-6.3 22 5.2 18.5 17.6c-2.9 10.5-5.2 21.2-6 31c-3.6 42.8 11.6 74.9 25 103.2l.4 .9c13.7 28.9 25.3 54.1 22.5 87.8c-1.4 16.7-8.6 38.9-16.1 57.9c-1.6 4.1-5.8 6.6-10.1 5.8C47.7 499.3 0 432.6 0 352c0-65 31-120.9 75.5-146zM180.5 498c-11.2 6.3-22-5.2-18.5-17.6c2.9-10.5 5.2-21.2 6-31c3.6-42.8-11.6-74.9-25-103.2l-.4-.9c-13.7-28.9-25.3-54.1-22.5-87.8c1.4-16.7 8.6-38.9 16.1-57.9c1.6-4.1 5.8-6.6 10.1-5.8C208.3 204.7 256 271.4 256 352c0 65-31 120.9-75.5 146z"]
}, faHatWitch = {
  prefix: "fas",
  iconName: "hat-witch",
  icon: [576, 512, [], "f6e7", "M200.7 181.4L112 384l112 0 0-48c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 48 112 0L386.7 206.1c-1.8-4-2.7-8.4-2.7-12.8l0-.8c0-5.6 1.5-11 4.2-15.9l18.6-32.5c5.7-10 16.3-16.1 27.8-16.1l20.4 0c14.7 0 27.5 10 31 24.2l6.2 24.6c2.2 8.9 10.2 15.1 19.4 15.1c9.5 0 17.7-6.7 19.6-16.1l12.2-60.8c.4-2.1 .6-4.2 .6-6.3l0-6.8c0-9-3.8-17.5-10.4-23.6L457.2 8.4C451.3 3 443.6 0 435.6 0l-2.2 0c-6.1 0-12.1 1.8-17.3 5L273.1 96.6c-32 20.5-57.2 50-72.4 84.8zM320 384l0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 48 64 0zM22.6 416C10.1 416 0 426.1 0 438.6c0 6 2.4 11.7 6.9 15.6C25.9 470.3 82.6 512 160 512l256 0c77.4 0 134.1-41.7 153.1-57.8c4.6-3.9 6.9-9.6 6.9-15.6c0-12.5-10.1-22.6-22.6-22.6L22.6 416z"]
}, faFaceGrinWink = {
  prefix: "fas",
  iconName: "face-grin-wink",
  icon: [512, 512, ["grin-wink"], "f58c", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM388.1 312.8c12.3-3.8 24.3 6.9 19.3 18.7C382.4 390.6 324.2 432 256.3 432s-126.2-41.4-151.1-100.5c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19zm-16.9-79.2c-17.6-23.5-52.8-23.5-70.4 0c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4c30.4-40.5 91.2-40.5 121.6 0c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faGrinWink = faFaceGrinWink, faClockThreeThirty = {
  prefix: "fas",
  iconName: "clock-three-thirty",
  icon: [512, 512, [], "e357", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392l0-136c0-13.3 10.7-24 24-24l104 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0 0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]
}, faEarDeaf = {
  prefix: "fas",
  iconName: "ear-deaf",
  icon: [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", "M502.6 54.6l-40 40c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l40-40c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zm-320 320l-128 128c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zM240 128c-57.6 0-105.1 43.6-111.3 99.5c-1.9 17.6-17.8 30.2-35.3 28.3s-30.2-17.8-28.3-35.3C74.8 132.5 149.4 64 240 64c97.2 0 176 78.8 176 176c0 46-17.7 87.9-46.6 119.3c-12 13-17.4 24.8-17.4 34.7l0 6.1c0 61.9-50.1 112-112 112c-17.7 0-32-14.3-32-32s14.3-32 32-32c26.5 0 48-21.5 48-48l0-6.1c0-32.9 17.4-59.6 34.4-78c18.4-20 29.6-46.6 29.6-75.9c0-61.9-50.1-112-112-112zm0 80c-17.7 0-32 14.3-32 32c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-44.2 35.8-80 80-80s80 35.8 80 80c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-17.7-14.3-32-32-32z"]
}, faDeaf = faEarDeaf, faDeafness = faEarDeaf, faHardOfHearing = faEarDeaf, faAlarmClock = {
  prefix: "fas",
  iconName: "alarm-clock",
  icon: [512, 512, [9200], "f34e", "M160 25.4C143 9.6 120.2 0 95.2 0C42.6 0 0 42.6 0 95.2c0 18.8 5.5 36.3 14.9 51.1L160 25.4zM256 512c50.3 0 96.8-16.6 134.2-44.6l35.2 35.2c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-35.2-35.2c28-37.4 44.6-83.8 44.6-134.2C480 164.3 379.7 64 256 64S32 164.3 32 288c0 50.3 16.6 96.8 44.6 134.2L41.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l35.2-35.2c37.4 28 83.8 44.6 134.1 44.6zM497.1 146.4C506.5 131.6 512 114 512 95.2C512 42.6 469.4 0 416.8 0C391.8 0 369 9.6 352 25.4L497.1 146.4zM280 184l0 94.1 41 41c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48-48c-4.5-4.5-7-10.6-7-17l0-104c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faEclipse = {
  prefix: "fas",
  iconName: "eclipse",
  icon: [640, 512, [], "f749", "M361.5 1.2c5 2.1 8.6 6.6 9.6 11.9l9.6 52.2c-34.2 15-63.7 38.9-85.4 68.8c-12.4-4-25.6-6.2-39.4-6.2c-70.7 0-128 57.3-128 128s57.3 128 128 128c13.7 0 27-2.2 39.4-6.2c21.7 29.9 51.1 53.9 85.4 68.8l-9.6 52.2c-1 5.3-4.6 9.8-9.6 11.9s-10.7 1.5-15.2-1.6L256 446.9l-90.3 62.3c-4.5 3.1-10.2 3.7-15.2 1.6s-8.6-6.6-9.6-11.9L121 391 13.1 371.1c-5.3-1-9.8-4.6-11.9-9.6s-1.5-10.7 1.6-15.2L65.1 256 2.8 165.7c-3.1-4.5-3.7-10.2-1.6-15.2s6.6-8.6 11.9-9.6L121 121 140.9 13.1c1-5.3 4.6-9.8 9.6-11.9s10.7-1.5 15.2 1.6L256 65.1 346.3 2.8c4.5-3.1 10.2-3.7 15.2-1.6zM256 160c7.6 0 15 .9 22.1 2.6C264 190.7 256 222.4 256 256s8 65.3 22.1 93.4c-7.1 1.7-14.5 2.6-22.1 2.6c-53 0-96-43-96-96s43-96 96-96zM464 80a176 176 0 1 1 0 352 176 176 0 1 1 0-352z"]
}, faFaceRelieved = {
  prefix: "fas",
  iconName: "face-relieved",
  icon: [512, 512, [], "e389", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM187.3 356.7c13 13 35.8 27.3 68.7 27.3s55.6-14.3 68.7-27.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6C329.4 397.2 298.9 416 256 416s-73.4-18.8-91.3-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zM387.2 238.4c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0zm-262.4 0c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2zM207.2 74.9c2.8 8.4-1.7 17.4-10.1 20.2l-6.3 2.1c-23.6 7.9-44 23.4-57.8 44.1l-7.6 11.5c-4.9 7.4-14.8 9.3-22.2 4.4s-9.3-14.8-4.4-22.2l7.6-11.5c17.8-26.6 43.9-46.6 74.3-56.7l6.3-2.1c8.4-2.8 17.4 1.7 20.2 10.1zM314.9 95.2c-8.4-2.8-12.9-11.9-10.1-20.2s11.9-12.9 20.2-10.1l6.3 2.1c30.4 10.1 56.5 30.1 74.3 56.7l7.6 11.5c4.9 7.4 2.9 17.3-4.4 22.2s-17.3 2.9-22.2-4.4L379 141.4c-13.8-20.7-34.1-36.3-57.8-44.1l-6.3-2.1z"]
}, faRoadCircleCheck = {
  prefix: "fas",
  iconName: "road-circle-check",
  icon: [640, 512, [], "e564", "M213.2 32L288 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 74.8 0c27.1 0 51.3 17.1 60.3 42.6l42.7 120.6c-10.9-2.1-22.2-3.2-33.8-3.2c-59.5 0-112.1 29.6-144 74.8l0-42.8c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32c2.3 0 4.6-.3 6.8-.7c-4.5 15.5-6.8 31.8-6.8 48.7c0 5.4 .2 10.7 .7 16l-.7 0c-17.7 0-32 14.3-32 32l0 64L86.6 480C56.5 480 32 455.5 32 425.4c0-6.2 1.1-12.4 3.1-18.2L152.9 74.6C162 49.1 186.1 32 213.2 32zM352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm211.3-43.3c-6.2-6.2-16.4-6.2-22.6 0L480 385.4l-28.7-28.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c6.2 6.2 16.4 6.2 22.6 0l72-72c6.2-6.2 6.2-16.4 0-22.6z"]
}, faDiceFive = {
  prefix: "fas",
  iconName: "dice-five",
  icon: [448, 512, [9860], "f523", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM96 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64-64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faOctagonMinus = {
  prefix: "fas",
  iconName: "octagon-minus",
  icon: [512, 512, ["minus-octagon"], "f308", "M140.6 21.2C154.1 7.7 172.4 .1 191.5 .1l129 0c19.1 0 37.4 7.6 50.9 21.1L490.8 140.6c13.5 13.5 21.1 31.8 21.1 50.9l0 129c0 19.1-7.6 37.4-21.1 50.9L371.4 490.8c-13.5 13.5-31.8 21.1-50.9 21.1l-129 0c-19.1 0-37.4-7.6-50.9-21.1L21.2 371.4C7.7 357.9 .1 339.6 .1 320.5l0-129c0-19.1 7.6-37.4 21.1-50.9L140.6 21.2zM184 232c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"]
}, faMinusOctagon = faOctagonMinus, faSquareRss = {
  prefix: "fas",
  iconName: "square-rss",
  icon: [448, 512, ["rss-square"], "f143", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM96 136c0-13.3 10.7-24 24-24c137 0 248 111 248 248c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-110.5-89.5-200-200-200c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24c83.9 0 152 68.1 152 152c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-57.4-46.6-104-104-104c-13.3 0-24-10.7-24-24zm0 120a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faRssSquare = faSquareRss, faFaceZany = {
  prefix: "fas",
  iconName: "face-zany",
  icon: [512, 512, [], "e3a4", "M384.1 477.7C506.5 407 548.5 250.4 477.8 128S250.5-36.4 128.1 34.3S-36.3 261.6 34.4 384c36.2 62.7 94.9 104.3 160.1 120.5c-11.5-15.8-18.4-35.4-18.4-56.5l0-39.8c-10.4-6.2-20.1-13.7-28.9-22.2c-10.2-9.9-6.6-26.3 5.7-33.4L391.2 214.9c12.3-7.1 28.3-2 31.8 11.8c15.2 59.4-5.9 124.1-55 165l0 56.3c0 15.4-3.6 30-10.1 42.9c8.8-3.8 17.5-8.2 26.1-13.2zM128 160a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm112-8a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zm96.1 296l0-45.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9c-2.8 12.6-20.8 12.6-23.6 0C257.8 383.9 248 376 236.7 376l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 45.4c0 35.3 28.7 64 64 64s64-28.7 64-64zM152 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm144-56a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faTricycle = {
  prefix: "fas",
  iconName: "tricycle",
  icon: [512, 512, [], "e5c3", "M280 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l73.6 0c7.9 0 14.4 6.4 14.4 14.4c0 4.2-1.8 8.2-5 10.9l-42.6 36.5c-.8 .7-1.6 1.4-2.3 2.2l-10.9 0c-58.8 0-114 23.9-154.1 64.6L133.6 176l2.4 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l21.6 0 44 73.4c-1.3 2.2-2.6 4.5-3.9 6.7c-1.9-.1-3.9-.1-5.8-.1C50.1 256 0 306.1 0 368s50.1 112 112 112s112-50.1 112-112c0-42.4-23.6-79.4-58.4-98.4c30.7-48.1 84-77.6 141.6-77.6l12.1 0 11 43.8C286.4 256.1 256 300.5 256 352c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-2.4 0-4.8 .1-7.2 .2l-13.9-55.6 31.3-26.9C408 129.9 416 112.6 416 94.4C416 59.9 388.1 32 353.6 32L280 32zm64.2 260l16.5 65.9c3.2 12.9 16.2 20.7 29.1 17.5s20.7-16.2 17.5-29.1l-16.5-65.9c36.6 3.4 65.2 34.2 65.2 71.7c0 39.8-32.2 72-72 72s-72-32.2-72-72c0-25.1 12.8-47.1 32.2-60zM112 312a56 56 0 1 1 0 112 56 56 0 1 1 0-112z"]
}, faLandMineOn = {
  prefix: "fas",
  iconName: "land-mine-on",
  icon: [640, 512, [], "e51b", "M344 24l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24zM192 320c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 32-256 0 0-32zm-77.3 90.5c8.1-16.3 24.8-26.5 42.9-26.5l324.7 0c18.2 0 34.8 10.3 42.9 26.5l27.6 55.2C563.5 487 548 512 524.2 512l-408.4 0c-23.8 0-39.3-25-28.6-46.3l27.6-55.2zM36.3 138.3c7.5-10.9 22.5-13.6 33.4-6.1l104 72c10.9 7.5 13.6 22.5 6.1 33.4s-22.5 13.6-33.4 6.1l-104-72c-10.9-7.5-13.6-22.5-6.1-33.4zm534.1-6.1c10.9-7.5 25.8-4.8 33.4 6.1s4.8 25.8-6.1 33.4l-104 72c-10.9 7.5-25.8 4.8-33.4-6.1s-4.8-25.8 6.1-33.4l104-72z"]
}, faSquareArrowUpLeft = {
  prefix: "fas",
  iconName: "square-arrow-up-left",
  icon: [448, 512, [], "e263", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM288 144c13.3 0 24 10.7 24 24s-10.7 24-24 24l-94.1 0L329 327c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-135-135L160 328c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-160c0-13.3 10.7-24 24-24l152 0z"]
}, faICursor = {
  prefix: "fas",
  iconName: "i-cursor",
  icon: [256, 512, [], "f246", "M.1 29.3C-1.4 47 11.7 62.4 29.3 63.9l8 .7C70.5 67.3 96 95 96 128.3L96 224l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 95.7c0 33.3-25.5 61-58.7 63.8l-8 .7C11.7 449.6-1.4 465 .1 482.7s16.9 30.7 34.5 29.2l8-.7c34.1-2.8 64.2-18.9 85.4-42.9c21.2 24 51.2 40 85.4 42.9l8 .7c17.6 1.5 33.1-11.6 34.5-29.2s-11.6-33.1-29.2-34.5l-8-.7C185.5 444.7 160 417 160 383.7l0-95.7 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-95.7c0-33.3 25.5-61 58.7-63.8l8-.7c17.6-1.5 30.7-16.9 29.2-34.5S239-1.4 221.3 .1l-8 .7C179.2 3.6 149.2 19.7 128 43.7c-21.2-24-51.2-40-85.4-42.9l-8-.7C17-1.4 1.6 11.7 .1 29.3z"]
}, faChartMixedUpCircleDollar = {
  prefix: "fas",
  iconName: "chart-mixed-up-circle-dollar",
  icon: [576, 512, [], "e5d9", "M400 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l28.8 0L319.4 151.5 211.2 70.4c-11.7-8.8-27.8-8.5-39.2 .6L12 199c-13.8 11-16 31.2-5 45s31.2 16 45 5L192.6 136.5l108.2 81.1c11.7 8.8 27.8 8.5 39.2-.6L480 105l0 39c0 17.7 14.3 32 32 32s32-14.3 32-32l0-112c0-17.7-14.3-32-32-32L400 0zM192 224c-17.7 0-32 14.3-32 32l0 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-192c0-17.7-14.3-32-32-32zM64 320c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zM408.1 339c0 0 0 0 0 .1c0 .4 0 1.9 4.8 4.5c5.6 3 13.5 5.2 23.9 8.2l.2 0c9.3 2.6 21.1 6 30.5 11.5c10.2 6 20 16.1 20.5 32.3c.5 18.2-9.7 30.4-21.7 36.9c-5.8 3.1-12.1 5.1-18.3 6.2l0 10.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-11.4c-8.6-1.7-16.7-4.3-23.7-6.6c0 0 0 0 0 0s0 0 0 0c-1.7-.6-3.4-1.1-5-1.6c-8.4-2.6-13.2-11.6-10.5-20s11.6-13.2 20-10.5c2 .6 3.9 1.2 5.8 1.8c11.4 3.6 20.4 6.5 29.9 6.8c6.7 .2 13.8-1.1 18.5-3.6c2.2-1.2 3.4-2.4 4-3.3c.5-.8 1.1-2.1 1-4.5c0-1.4-.2-3-4.7-5.6c-5.3-3.1-12.9-5.4-23.2-8.3l-1.8-.5c-8.9-2.5-19.8-5.6-28.6-10.3c-9.9-5.3-20.6-14.7-21.6-30.7c-1.2-18.8 10-30.9 21.8-37.2c5.7-3.1 12-5.1 18-6.3l0-9.5c0-8.8 7.2-16 16-16s16 7.2 16 16l0 9.4c6.3 .9 12.3 2.3 17.9 3.7c8.6 2.1 13.8 10.8 11.7 19.4s-10.8 13.8-19.4 11.7c-9.3-2.3-18.2-4-26.4-4.1c-6.2-.1-13.6 1.3-18.7 4c-2.4 1.3-3.6 2.5-4.2 3.4c-.4 .7-.9 1.6-.8 3.6z"]
}, faSaltShaker = {
  prefix: "fas",
  iconName: "salt-shaker",
  icon: [384, 512, [129474], "e446", "M319.4 448L64.6 448l36.6-256 181.6 0 36.6 256zM59.8 512l264.5 0c33 0 59.8-26.8 59.8-59.8c0-2.8-.2-5.7-.6-8.5L338.1 126.7C327.7 54 265.4 0 192 0S56.3 54 45.9 126.7L.6 443.8c-.4 2.8-.6 5.6-.6 8.5c0 33 26.8 59.8 59.8 59.8zM192 48a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM128 96a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM240 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faStamp = {
  prefix: "fas",
  iconName: "stamp",
  icon: [512, 512, [], "f5bf", "M312 201.8c0-17.4 9.2-33.2 19.9-47C344.5 138.5 352 118.1 352 96c0-53-43-96-96-96s-96 43-96 96c0 22.1 7.5 42.5 20.1 58.8c10.7 13.8 19.9 29.6 19.9 47c0 29.9-24.3 54.2-54.2 54.2L112 256C50.1 256 0 306.1 0 368c0 20.9 13.4 38.7 32 45.3L32 464c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-50.7c18.6-6.6 32-24.4 32-45.3c0-61.9-50.1-112-112-112l-33.8 0c-29.9 0-54.2-24.3-54.2-54.2zM416 416l0 32L96 448l0-32 320 0z"]
}, faFilePlus = {
  prefix: "fas",
  iconName: "file-plus",
  icon: [384, 512, [], "f319", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM192 240c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"]
}, faDrawSquare = {
  prefix: "fas",
  iconName: "draw-square",
  icon: [448, 512, [], "f5ef", "M96 151.4l0 209.1c9.7 5.6 17.8 13.7 23.4 23.4l209.1 0c5.6-9.7 13.7-17.8 23.4-23.4l0-209.1c-9.7-5.6-17.8-13.7-23.4-23.4l-209.1 0c-5.6 9.7-13.7 17.8-23.4 23.4zM119.4 448c-11.1 19.1-31.7 32-55.4 32c-35.3 0-64-28.7-64-64c0-23.7 12.9-44.4 32-55.4l0-209.1C12.9 140.4 0 119.7 0 96C0 60.7 28.7 32 64 32c23.7 0 44.4 12.9 55.4 32l209.1 0c11.1-19.1 31.7-32 55.4-32c35.3 0 64 28.7 64 64c0 23.7-12.9 44.4-32 55.4l0 209.1c19.1 11.1 32 31.7 32 55.4c0 35.3-28.7 64-64 64c-23.7 0-44.4-12.9-55.4-32l-209.1 0z"]
}, faToiletPaperUnderSlash = {
  prefix: "fas",
  iconName: "toilet-paper-under-slash",
  icon: [640, 512, ["toilet-paper-reverse-slash"], "e2a1", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-54.8-43 0-83.1c-9.9 19.5-23.2 38.2-39.9 51.8L510 374.4c22.6-14.8 41.4-46 53.1-86.4c8.2-28.2 12.8-61 12.8-96C576 86 533 0 480 0c-11.2 0-22 3.8-32 10.9c-37.3 26.4-64 97.5-64 181.1c0 33.8 4.4 65.5 12 93.1l-39.3-30.8c-3.1-19.9-4.7-40.8-4.7-62.3c0-56.9 11.5-110 31.5-150.1c7.5-15 17.1-29.7 28.7-41.9L160 0c-24.8 0-47.4 18.8-64.4 49.6L38.8 5.1zM528 512L406.2 416 224 416l0 48c0 26.5 21.5 48 48 48l256 0 .3 0-.3 0zM64 192c0 106 43 192 96 192l205.5 0L66.5 148.4C64.9 162.4 64 177 64 192zm416 64c-17.7 0-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64s-14.3 64-32 64z"]
}, faToiletPaperReverseSlash = faToiletPaperUnderSlash, faStairs = {
  prefix: "fas",
  iconName: "stairs",
  icon: [576, 512, [], "e289", "M384 64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0 0 96c0 17.7-14.3 32-32 32l-96 0 0 96c0 17.7-14.3 32-32 32l-96 0 0 96c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0 0-96c0-17.7 14.3-32 32-32l96 0 0-96c0-17.7 14.3-32 32-32l96 0 0-96z"]
}, faDroneFront = {
  prefix: "fas",
  iconName: "drone-front",
  icon: [640, 512, ["drone-alt"], "f860", "M155.7 112c-5.5-9.6-15.9-16-27.7-16s-22.2 6.4-27.7 16L24 112c-13.3 0-24 10.7-24 24s10.7 24 24 24l240 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-108.3 0zM376 112c-13.3 0-24 10.7-24 24s10.7 24 24 24l240 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-76.3 0c-5.5-9.6-15.9-16-27.7-16s-22.2 6.4-27.7 16L376 112zM96 192l0 64c0 12.6 7.4 24.1 19 29.2l56.5 25.1c-17.8 21.5-27.5 48.5-27.5 76.4l0 5.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-5.2c0-16.8 5.9-33.2 16.7-46.1l8.4-10.1L259 349.2c4.1 1.8 8.5 2.8 13 2.8l96 0c4.5 0 8.9-.9 13-2.8l41.9-18.6 8.4 10.1c10.8 12.9 16.7 29.3 16.7 46.1l0 5.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-5.2c0-27.9-9.7-54.9-27.5-76.4L525 285.2c11.6-5.1 19-16.6 19-29.2l0-64-64 0 0 43.2-17.8 7.9-40.6-23.7C390.7 201.5 355.7 192 320 192s-70.7 9.5-101.6 27.5l-40.6 23.7L160 235.2l0-43.2-64 0z"]
}, faDroneAlt = faDroneFront, faGlassEmpty = {
  prefix: "fas",
  iconName: "glass-empty",
  icon: [384, 512, [], "e191", "M8.6 10.2C14.6 3.7 23.1 0 32 0L352 0c8.9 0 17.4 3.7 23.4 10.2s9.1 15.2 8.5 24.1L355.1 437.7c-3 41.9-37.8 74.3-79.8 74.3l-166.6 0c-42 0-76.8-32.4-79.8-74.3L.1 34.3c-.6-8.9 2.4-17.6 8.5-24.1zM66.4 64L92.7 433.1c.6 8.4 7.6 14.9 16 14.9l166.6 0c8.4 0 15.4-6.5 16-14.9L317.6 64 66.4 64z"]
}, faDialHigh = {
  prefix: "fas",
  iconName: "dial-high",
  icon: [576, 512, [], "e15c", "M288 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm.4 127.6c80.2 0 146.6 59 158.2 136l-158.2 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l158.2 0c-11.6 77-78 136-158.2 136c-88.4 0-160-71.6-160-160s71.6-160 160-160zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0A32 32 0 1 1 64 96zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faUserHelmetSafety = {
  prefix: "fas",
  iconName: "user-helmet-safety",
  icon: [448, 512, [128119, "user-construction", "user-hard-hat"], "f82c", "M216 0c-13.3 0-24 10.7-24 24l0 56L163.6 23.1C125.6 43.5 99 82.6 96.2 128l-.2 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l256 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-.2 0C349 82.6 322.4 43.5 284.4 23.1L256 80l0-56c0-13.3-10.7-24-24-24L216 0zm8 320c65.3 0 119.1-48.9 127-112L97 208c7.9 63.1 61.7 112 127 112zm-89.6 32C60.2 352 0 412.2 0 486.4C0 500.5 11.5 512 25.6 512l396.8 0c14.1 0 25.6-11.5 25.6-25.6C448 412.2 387.8 352 313.6 352l-179.2 0z"]
}, faUserConstruction = faUserHelmetSafety, faUserHardHat = faUserHelmetSafety, faI = {
  prefix: "fas",
  iconName: "i",
  icon: [320, 512, [105], "49", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l96 0 0 320-96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0 0-320 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L160 32 32 32z"]
}, faHryvniaSign = {
  prefix: "fas",
  iconName: "hryvnia-sign",
  icon: [384, 512, [8372, "hryvnia"], "f6f2", "M121.9 116.2C138.3 103.1 158.7 96 179.6 96L223 96c27.1 0 49 21.9 49 49c0 11.5-4 22.4-11.1 31L32 176c-17.7 0-32 14.3-32 32s14.3 32 32 32l123.5 0-50.6 28.9c-1.7 1-3.4 2-5.1 3.1L32 272c-17.7 0-32 14.3-32 32s14.3 32 32 32l20.3 0c-2.8 9.9-4.3 20.4-4.3 31c0 62.4 50.6 113 113 113l43.4 0c35.5 0 70-12.1 97.7-34.3L308 441c13.8-11 16-31.2 5-45s-31.2-16-45-5l-5.9 4.7c-16.4 13.1-36.7 20.2-57.7 20.2L161 416c-27.1 0-49-21.9-49-49c0-11.5 4-22.4 11.1-31L352 336c17.7 0 32-14.3 32-32s-14.3-32-32-32l-123.5 0 50.6-28.9c1.7-1 3.4-2 5.1-3.1l67.8 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-20.3 0c2.8-10 4.3-20.4 4.3-31c0-62.4-50.6-113-113-113l-43.4 0c-35.5 0-70 12.1-97.7 34.3L76 71c-13.8 11-16 31.2-5 45s31.2 16 45 5l5.9-4.7z"]
}, faHryvnia = faHryvniaSign, faArrowDownLeftAndArrowUpRightToCenter = {
  prefix: "fas",
  iconName: "arrow-down-left-and-arrow-up-right-to-center",
  icon: [512, 512, [], "e092", "M502.6 54.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L336 130.7 336 80c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0L502.6 54.6zM80 272c-17.7 0-32 14.3-32 32s14.3 32 32 32l50.7 0L9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L176 381.3l0 50.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L80 272z"]
}, faPills = {
  prefix: "fas",
  iconName: "pills",
  icon: [576, 512, [], "f484", "M112 96c-26.5 0-48 21.5-48 48l0 112 96 0 0-112c0-26.5-21.5-48-48-48zM0 144C0 82.1 50.1 32 112 32s112 50.1 112 112l0 224c0 61.9-50.1 112-112 112S0 429.9 0 368L0 144zM554.9 399.4c-7.1 12.3-23.7 13.1-33.8 3.1L333.5 214.9c-10-10-9.3-26.7 3.1-33.8C360 167.7 387.1 160 416 160c88.4 0 160 71.6 160 160c0 28.9-7.7 56-21.1 79.4zm-59.5 59.5C472 472.3 444.9 480 416 480c-88.4 0-160-71.6-160-160c0-28.9 7.7-56 21.1-79.4c7.1-12.3 23.7-13.1 33.8-3.1L498.5 425.1c10 10 9.3 26.7-3.1 33.8z"]
}, faFaceGrinWide = {
  prefix: "fas",
  iconName: "face-grin-wide",
  icon: [512, 512, [128515, "grin-alt"], "f581", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM388.1 312.8c12.3-3.8 24.3 6.9 19.3 18.7C382.4 390.6 324.2 432 256.3 432s-126.2-41.4-151.1-100.5c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19zM208 192c0 35.3-14.3 64-32 64s-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64zm128 64c-17.7 0-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64s-14.3 64-32 64z"]
}, faGrinAlt = faFaceGrinWide, faTooth = {
  prefix: "fas",
  iconName: "tooth",
  icon: [448, 512, [129463], "f5c9", "M186.1 52.1C169.3 39.1 148.7 32 127.5 32C74.7 32 32 74.7 32 127.5l0 6.2c0 15.8 3.7 31.3 10.7 45.5l23.5 47.1c4.5 8.9 7.6 18.4 9.4 28.2l36.7 205.8c2 11.2 11.6 19.4 22.9 19.8s21.4-7.4 24-18.4l28.9-121.3C192.2 323.7 207 312 224 312s31.8 11.7 35.8 28.3l28.9 121.3c2.6 11.1 12.7 18.8 24 18.4s20.9-8.6 22.9-19.8l36.7-205.8c1.8-9.8 4.9-19.3 9.4-28.2l23.5-47.1c7.1-14.1 10.7-29.7 10.7-45.5l0-2.1c0-55-44.6-99.6-99.6-99.6c-24.1 0-47.4 8.8-65.6 24.6l-3.2 2.8 19.5 15.2c7 5.4 8.2 15.5 2.8 22.5s-15.5 8.2-22.5 2.8l-24.4-19-37-28.8z"]
}, faBasketballHoop = {
  prefix: "fas",
  iconName: "basketball-hoop",
  icon: [640, 512, [], "f435", "M6.8 187C24.7 153.1 116.7 0 320 0S615.3 153.1 633.2 187c4.9 9.4 6.8 19.1 6.8 28l0 116.3c0 25.3-14.9 48.2-38 58.5l-96.4 42.9L526.2 288l-32.3 0-7.2 50.3-22.9 160c-.9 6.1-5.2 11.2-11.1 13s-12.3 .1-16.5-4.4L384.4 451l-52.8 56c-3 3.2-7.2 5-11.6 5s-8.6-1.8-11.6-5l-52.8-56-51.9 55.9c-4.2 4.5-10.6 6.2-16.5 4.4s-10.2-6.9-11.1-13l-22.9-160L146.1 288l-32.3 0 20.7 144.6L38 389.7C14.9 379.4 0 356.5 0 331.2L0 214.9c0-8.9 1.8-18.6 6.8-28zM178.4 288l5.2 36.6 44-36.6-49.2 0zm99.3 0l-.6 .5L320 334.6l42.8-46.1-.6-.5-84.4 0zm134.5 0l44 36.6 5.2-36.6-49.2 0zM192 128c-17.7 0-32 14.3-32 32l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0 288 0 64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48c0-17.7-14.3-32-32-32l-256 0zm256 32l0 48-256 0 0-48 256 0zM387.5 309l-45.7 49.2 42.7 46 51.6-54.7L387.5 309zm49.4 151.6l11-76.8-41.5 44 30.5 32.9zM320 381.7l-42.6 45.9L320 472.7l42.6-45.2L320 381.7zm-21.8-23.5L252.5 309l-48.7 40.5 51.6 54.7 42.7-46zm-64.6 69.5l-41.5-44 11 76.8 30.5-32.9z"]
}, faObjectsAlignBottom = {
  prefix: "fas",
  iconName: "objects-align-bottom",
  icon: [512, 512, [], "e3bb", "M24 512l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24zM64 336c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48L112 0C85.5 0 64 21.5 64 48l0 288zm224 0c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48l0 160z"]
}, faV = {
  prefix: "fas",
  iconName: "v",
  icon: [384, 512, [118], "56", "M19.7 34.5c16.3-6.8 35 .9 41.8 17.2L192 364.8 322.5 51.7c6.8-16.3 25.5-24 41.8-17.2s24 25.5 17.2 41.8l-160 384c-5 11.9-16.6 19.7-29.5 19.7s-24.6-7.8-29.5-19.7L2.5 76.3c-6.8-16.3 .9-35 17.2-41.8z"]
}, faSparkles = {
  prefix: "fas",
  iconName: "sparkles",
  icon: [512, 512, [10024], "f890", "M327.5 85.2c-4.5 1.7-7.5 6-7.5 10.8s3 9.1 7.5 10.8L384 128l21.2 56.5c1.7 4.5 6 7.5 10.8 7.5s9.1-3 10.8-7.5L448 128l56.5-21.2c4.5-1.7 7.5-6 7.5-10.8s-3-9.1-7.5-10.8L448 64 426.8 7.5C425.1 3 420.8 0 416 0s-9.1 3-10.8 7.5L384 64 327.5 85.2zM205.1 73.3c-2.6-5.7-8.3-9.3-14.5-9.3s-11.9 3.6-14.5 9.3L123.3 187.3 9.3 240C3.6 242.6 0 248.3 0 254.6s3.6 11.9 9.3 14.5l114.1 52.7L176 435.8c2.6 5.7 8.3 9.3 14.5 9.3s11.9-3.6 14.5-9.3l52.7-114.1 114.1-52.7c5.7-2.6 9.3-8.3 9.3-14.5s-3.6-11.9-9.3-14.5L257.8 187.4 205.1 73.3zM384 384l-56.5 21.2c-4.5 1.7-7.5 6-7.5 10.8s3 9.1 7.5 10.8L384 448l21.2 56.5c1.7 4.5 6 7.5 10.8 7.5s9.1-3 10.8-7.5L448 448l56.5-21.2c4.5-1.7 7.5-6 7.5-10.8s-3-9.1-7.5-10.8L448 384l-21.2-56.5c-1.7-4.5-6-7.5-10.8-7.5s-9.1 3-10.8 7.5L384 384z"]
}, faSquid = {
  prefix: "fas",
  iconName: "squid",
  icon: [544, 512, [129425], "e450", "M276 .3c-5.3-1.1-10.8 .6-14.6 4.5s-5.4 9.4-4.2 14.7l13.1 58.9c-71.9 46.2-103.4 101.8-110.6 148.4L146 213l-2.3-2.3-22.6-22.6c-6.2-6.2-6.2-16.4 0-22.6l56.4-56.4c18.9-18.9 18.7-49.5-.3-68.2L140.1 4.6c-6.3-6.1-16.3-6.1-22.5 .1l-2.8 2.8c-34 34-33.3 87.7-1.9 121L98.5 142.9c-18.7 18.7-18.7 49.1 0 67.9l22.6 22.6c0 0 0 0 0 0l5.7 5.7c0 0 0 0 0 0c9.3 9.4 9.3 24.5 0 33.9c-9.3 9.3-24.4 9.4-33.8 .2L76.5 256.6c-19.1-19.1-50.2-18.7-68.7 .9L4.4 261c-6.1 6.4-5.8 16.5 .6 22.6s16.5 5.8 22.6-.6l3.3-3.5c6.2-6.5 16.6-6.7 22.9-.3l10.6 10.6 .1 .2 22.6 22.6c10.1 10.2 9 26.9-2.4 35.8l-20 15.6c-3.5 2.7-7.7 4.2-12.1 4.2c-10.9 0-19.7-8.8-19.7-19.7l0-12.3c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 12.3C.9 376.8 24.1 400 52.6 400c11.5 0 22.7-3.8 31.8-10.9l28.2-21.9c9.4-7.3 22.8-6.5 31.2 1.9s9.3 21.8 1.9 31.2l-21.9 28.2c-7.1 9.1-10.9 20.3-10.9 31.8c0 28.6 23.2 51.7 51.7 51.7l12.3 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-12.3 0c-10.9 0-19.7-8.8-19.7-19.7c0-4.4 1.5-8.7 4.2-12.1l15.6-20c8.8-11.4 25.6-12.4 35.8-2.3l.1 .1L223 448.3l.1 .1 9.9 9.8c6.5 6.5 6.2 17.2-.7 23.3l-2.8 2.5c-6.6 5.9-7.2 16-1.3 22.6s16 7.2 22.6 1.3l2.8-2.5c20.7-18.3 21.6-50.3 2.1-69.8l-9.9-9.9-5.7-5.7-.1-.1c-9.3-9.3-9.3-24.4 0-33.8l.1-.1 .1-.1c9.3-9.2 24.4-9.2 33.7 0l28.4 28.4c18.7 18.7 49.1 18.7 67.9 0L384.4 400c33.3 31.4 87 32.1 121-1.9l2.8-2.8c6.2-6.2 6.3-16.3 .1-22.5L472 335.7c-18.7-19-49.3-19.2-68.2-.3l-56.4 56.3c-6.2 6.2-16.4 6.2-22.6 0l-22.5-22.5-.1-.1-16-16c46.6-7.2 102.2-38.7 148.4-110.6l58.9 13.1c5.3 1.2 10.8-.4 14.7-4.2s5.6-9.3 4.5-14.6L489.3 120.2c9.2-30.2 17.2-64 23.4-101.5c.9-5.1-.8-10.3-4.5-13.9S499.4-.6 494.3 .2C456.7 6.5 423 14.4 392.7 23.6L276 .3zM168.9 280a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm64 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faLeafyGreen = {
  prefix: "fas",
  iconName: "leafy-green",
  icon: [576, 512, [129388], "e41d", "M97.9 28.4C92 34.4 87 40.8 83 47.7C70 69.6 50.6 89.9 30.9 105.9c-2.3 1.8-4.4 3.8-6.5 5.9C-1.4 137.6-6.8 176.2 8.5 207.2c5.7 11.7 11 24.1 11 37.1l0 35.7c0 14.7 5.8 28.8 16.3 39.2l26.3 26.3c10.4 10.4 16.3 24.5 16.3 39.2l0 12.9c0 2.9 .2 5.8 .7 8.7l7.6-7.6c6-6 9.4-14.1 9.4-22.6l0-45.7c0-25.5 10.1-49.9 28.1-67.9l10.5-10.5c6-6 9.4-14.1 9.4-22.6l0-43c0-25.5 10.1-49.9 28.1-67.9l29.1-29.1c5-5 8.8-12.9 13.7-27c4.4-12.9 10.8-24.8 18.9-35.5c-38-36.5-98.4-36-135.8 1.5zM567.5 229.9c-3.1-29.1-2.3-61.5 5-89.9c2.3-8.9 3.5-18.3 3.5-28C576 50.1 525.9 0 464 0c-9.7 0-19 1.2-28 3.5c-28.4 7.3-60.8 8.1-89.9 5c-3.3-.3-6.7-.5-10.1-.5c-42.1 0-77.9 27.1-90.8 64.9c-4.9 14.3-10.6 28.6-21.3 39.3l-29.1 29.1c-12 12-18.7 28.3-18.7 45.3l0 43c0 17-6.7 33.3-18.7 45.3l-10.5 10.5c-12 12-18.7 28.3-18.7 45.3l0 45.7c0 17-6.7 33.3-18.7 45.3L73.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l35.9-35.9c12-12 28.3-18.7 45.3-18.7l45.7 0c17 0 33.3-6.7 45.3-18.7l10.5-10.5c12-12 28.3-18.7 45.3-18.7l43 0c17 0 33.3-6.7 45.3-18.7l29.1-29.1c10.7-10.7 25-16.4 39.3-21.3C540.9 317.9 568 282.1 568 240c0-3.4-.2-6.8-.5-10.1zM475.3 100.7c6.2 6.2 6.2 16.4 0 22.6L390.6 208l57.4 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-89.4 0-59.3 59.3-48 48c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L272 281.4l0-89.4c0-8.8 7.2-16 16-16s16 7.2 16 16l0 57.4 36.7-36.7 112-112c6.2-6.2 16.4-6.2 22.6 0z"]
}, faCircleArrowUpRight = {
  prefix: "fas",
  iconName: "circle-arrow-up-right",
  icon: [512, 512, [], "e0fc", "M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm368 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-94.1L185 361c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l135-135L184 192c-13.3 0-24-10.7-24-24s10.7-24 24-24l160 0c13.3 0 24 10.7 24 24l0 152z"]
}, faCalendars = {
  prefix: "fas",
  iconName: "calendars",
  icon: [512, 512, [], "e0d7", "M224 0c-17.7 0-32 14.3-32 32l0 32-48 0c-26.5 0-48 21.5-48 48l0 48 416 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-96 0 0-32c0-17.7-14.3-32-32-32zM96 192l0 176c0 26.5 21.5 48 48 48l320 0c26.5 0 48-21.5 48-48l0-176L96 192zm-48-8c0-13.3-10.7-24-24-24s-24 10.7-24 24L0 392c0 66.3 53.7 120 120 120l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0c-39.8 0-72-32.2-72-72l0-208z"]
}, faBangladeshiTakaSign = {
  prefix: "fas",
  iconName: "bangladeshi-taka-sign",
  icon: [384, 512, [], "e2e6", "M36 32.3C18.4 30.1 2.4 42.5 .2 60S10.5 93.6 28 95.8l7.9 1c16 2 28 15.6 28 31.8L64 160l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 160c0 53 43 96 96 96l32 0c106 0 192-86 192-192l0-32c0-53-43-96-96-96l-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l16 0c17.7 0 32 14.3 32 32l0 32c0 70.7-57.3 128-128 128l-32 0c-17.7 0-32-14.3-32-32l0-160 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-31.5c0-48.4-36.1-89.3-84.1-95.3l-7.9-1z"]
}, faBicycle = {
  prefix: "fas",
  iconName: "bicycle",
  icon: [640, 512, [128690], "f206", "M312 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l25.7 0 34.6 64-149.4 0-27.4-38C191 99.7 183.7 96 176 96l-56 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l43.7 0 22.1 30.7-26.6 53.1c-10-2.5-20.5-3.8-31.2-3.8C57.3 224 0 281.3 0 352s57.3 128 128 128c65.3 0 119.1-48.9 127-112l49 0c8.5 0 16.3-4.5 20.7-11.8l84.8-143.5 21.7 40.1C402.4 276.3 384 312 384 352c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-13.5 0-26.5 2.1-38.7 6L375.4 48.8C369.8 38.4 359 32 347.2 32L312 32zM458.6 303.7l32.3 59.7c6.3 11.7 20.9 16 32.5 9.7s16-20.9 9.7-32.5l-32.3-59.7c3.6-.6 7.4-.9 11.2-.9c39.8 0 72 32.2 72 72s-32.2 72-72 72s-72-32.2-72-72c0-18.6 7-35.5 18.6-48.3zM133.2 368l65 0c-7.3 32.1-36 56-70.2 56c-39.8 0-72-32.2-72-72s32.2-72 72-72c1.7 0 3.4 .1 5.1 .2l-24.2 48.5c-9 18.1 4.1 39.4 24.3 39.4zm33.7-48l50.7-101.3 72.9 101.2-.1 .1-123.5 0zm90.6-128l108.5 0L317 274.8 257.4 192z"]
}, faHammerWar = {
  prefix: "fas",
  iconName: "hammer-war",
  icon: [384, 512, [], "f6e4", "M192 0c17.7 0 32 14.3 32 32l0 18.8L347.3 32.4c9.2-1.4 18.6 1.3 25.6 7.4S384 54.7 384 64l0 192c0 9.3-4.1 18.2-11.1 24.2s-16.4 8.8-25.6 7.4L196.7 265.1c-3.1-.5-6.3-.5-9.5 0L36.7 287.6c-9.2 1.4-18.6-1.3-25.6-7.4S0 265.3 0 256L0 64c0-9.3 4.1-18.2 11.1-24.2s16.4-8.8 25.6-7.4L160 50.8 160 32c0-17.7 14.3-32 32-32zm0 296.7l32 4.8L224 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-178.5 32-4.8z"]
}, faCircleD = {
  prefix: "fas",
  iconName: "circle-d",
  icon: [512, 512, [], "e104", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128l72 0c70.7 0 128 57.3 128 128s-57.3 128-128 128l-72 0c-13.3 0-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24zm72 208c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0 0 160 48 0z"]
}, faSpiderBlackWidow = {
  prefix: "fas",
  iconName: "spider-black-widow",
  icon: [512, 512, [], "f718", "M144.6 1.6c12.4 4.8 18.5 18.6 13.8 31l-32.5 84.6c-1.1 3-.4 6.3 1.8 8.5L176 174.1l0-14.1c0-31.8 18.6-59.3 45.5-72.2c9.1-4.4 18.5 3.3 18.5 13.4l0 10.8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-10.8c0-10.1 9.4-17.7 18.5-13.4C317.4 100.7 336 128.2 336 160l0 14.1 48.3-48.3c2.2-2.2 2.9-5.6 1.8-8.5L353.6 32.6c-4.8-12.4 1.4-26.3 13.8-31s26.3 1.4 31 13.8L430.9 100c7.9 20.7 3 44.1-12.7 59.7l-57.4 57.4 80.4-26.8c2.4-.8 4.3-2.7 5.1-5.1l18.9-56.8c4.2-12.6 17.8-19.4 30.4-15.2s19.4 17.8 15.2 30.4l-18.9 56.8c-5.6 16.7-18.7 29.8-35.4 35.4L395.9 256l60.5 20.2c16.7 5.6 29.8 18.7 35.4 35.4l18.9 56.8c4.2 12.6-2.6 26.2-15.2 30.4s-26.2-2.6-30.4-15.2l-18.9-56.8c-.8-2.4-2.7-4.3-5.1-5.1l-80.4-26.8 57.4 57.4c15.6 15.6 20.6 39 12.7 59.7l-32.5 84.6c-4.8 12.4-18.6 18.5-31 13.8s-18.5-18.6-13.8-31l32.5-84.6c1.1-3 .4-6.3-1.8-8.5L352 353.9c-1 52.1-43.6 94.1-96 94.1s-95-41.9-96-94.1l-32.3 32.3c-2.2 2.2-2.9 5.6-1.8 8.5l32.5 84.6c4.8 12.4-1.4 26.3-13.8 31s-26.3-1.4-31-13.8L81.1 412c-7.9-20.7-3-44.1 12.7-59.7l57.4-57.4L70.8 321.7c-2.4 .8-4.3 2.7-5.1 5.1L46.8 383.6C42.6 396.2 29 403 16.4 398.8S-3 381 1.2 368.4l18.9-56.8c5.6-16.7 18.7-29.8 35.4-35.4L116.1 256 55.6 235.8c-16.7-5.6-29.8-18.7-35.4-35.4L1.2 143.6C-3 131 3.8 117.4 16.4 113.2s26.2 2.6 30.4 15.2l18.9 56.8c.8 2.4 2.7 4.3 5.1 5.1l80.4 26.8L93.7 159.7C78.1 144 73.1 120.6 81.1 100l32.5-84.6c4.8-12.4 18.6-18.5 31-13.8zm73.8 305.6L240 336l-21.6 28.8c-1.6 2.1-2.4 4.6-2.4 7.2c0 6.6 5.4 12 12 12l56 0c6.6 0 12-5.4 12-12c0-2.6-.8-5.1-2.4-7.2L272 336l21.6-28.8c1.6-2.1 2.4-4.6 2.4-7.2c0-6.6-5.4-12-12-12l-56 0c-6.6 0-12 5.4-12 12c0 2.6 .8 5.1 2.4 7.2z"]
}, faStaffSnake = {
  prefix: "fas",
  iconName: "staff-snake",
  icon: [384, 512, ["rod-asclepius", "rod-snake", "staff-aesculapius"], "e579", "M222.6 43.2l-.1 4.8L288 48c53 0 96 43 96 96s-43 96-96 96l-40 0 0-80 40 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-40 0-28 0-4.5 144 40.5 0c53 0 96 43 96 96s-43 96-96 96l-16 0 0-80 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-43 0-3.1 99.5L208.5 495l0 1c-.3 8.9-7.6 16-16.5 16s-16.2-7.1-16.5-16l0-1-1-31L136 464c-22.1 0-40-17.9-40-40s17.9-40 40-40l36 0-1-32-19 0c-53 0-96-43-96-96c0-47.6 34.6-87.1 80-94.7l0 94.7c0 8.8 7.2 16 16 16l16.5 0L164 128l-28 0-13.4 0c-9 18.9-28.3 32-50.6 32l-16 0c-30.9 0-56-25.1-56-56S25.1 48 56 48l8 0 8 0 89.5 0-.1-4.8L161 32c0-.7 0-1.3 0-1.9c.5-16.6 14.1-30 31-30s30.5 13.4 31 30c0 .6 0 1.3 0 1.9l-.4 11.2zM64 112a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]
}, faRodAsclepius = faStaffSnake, faRodSnake = faStaffSnake, faStaffAesculapius = faStaffSnake, faPear = {
  prefix: "fas",
  iconName: "pear",
  icon: [512, 512, [], "e20c", "M505 7c9.4 9.4 9.4 24.6 0 33.9L457.9 88.1c14 20.5 22.1 45.3 22.1 71.9c0 30.7-10.8 58.9-28.9 81c-29.9 36.5-61.4 81.8-73.3 127.4c-8.3 32-25 62.3-50.1 87.3c-75 75-196.5 75-271.5 0s-75-196.5 0-271.5c25.1-25.1 55.3-41.8 87.3-50.1c45.7-11.8 90.9-43.4 127.4-73.3c22.1-18 50.3-28.9 81-28.9c26.7 0 51.4 8.2 71.9 22.1L471 7c9.4-9.4 24.6-9.4 33.9 0zM320 320c0-8.8-7.2-16-16-16s-16 7.2-16 16c0 53-43 96-96 96c-8.8 0-16 7.2-16 16s7.2 16 16 16c70.7 0 128-57.3 128-128z"]
}, faHeadSideCoughSlash = {
  prefix: "fas",
  iconName: "head-side-cough-slash",
  icon: [640, 512, [], "e062", "M448 325.8l44 34.5c8.1 1.4 14.8 6.8 18 14.1L552.9 408c10.6 .4 19.5 7.6 22.2 17.4l39.1 30.6c.6 0 1.2-.1 1.8-.1c11.1 0 20.4 7.5 23.2 17.8l-3.9 0c6.2 8.5 6.4 20.4-.4 29c-8.2 10.4-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2S28.4-3.1 38.8 5.1L89.6 44.9C127 16.7 173.5 0 224 0l24 0c95.2 0 181.2 69.3 197.3 160.2c2.3 13 6.8 25.7 15.1 36l42 52.6c6.2 7.8 9.6 17.4 9.6 27.4c0 24.2-19.6 43.8-43.8 43.8L448 320s0 0 0 0l0 5.8zM0 224.2c0-38.7 9.8-75.1 27.1-106.9L341.8 365.3l-2.5 .3c-11 1.4-19.2 10.7-19.2 21.8c0 11.6 9 21.2 20.6 21.9l62 3.9 43 33.9C439.3 466.2 421.2 480 400 480l-80 0 0 8c0 13.3-10.7 24-24 24l-40 0s0 0 0 0L96 512c-17.7 0-32-14.3-32-32l0-72.7c0-16.7-6.9-32.5-17.1-45.8C16.6 322.4 0 274.1 0 224.2zM616 360a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-64-48a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm40-24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faFileMov = {
  prefix: "fas",
  iconName: "file-mov",
  icon: [512, 512, [], "e647", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-240 0c-35.3 0-64 28.7-64 64l0 144-16 0c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zM157.7 359.8L192 416.9l34.3-57.1c3.7-6.2 11.1-9.1 18-7.2s11.7 8.2 11.7 15.4l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-70.2-18.3 30.5c-2.9 4.8-8.1 7.8-13.7 7.8s-10.8-3-13.7-7.8L160 425.8l0 70.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-7.2 4.8-13.5 11.7-15.4s14.3 1 18 7.2zM448 368l0 31.6c0 23 5.5 45.6 16 66c10.5-20.3 16-42.9 16-66l0-31.6c0-8.8 7.2-16 16-16s16 7.2 16 16l0 31.6c0 34.7-10.3 68.7-29.6 97.6l-5.1 7.7c-3 4.5-8 7.1-13.3 7.1s-10.3-2.7-13.3-7.1l-5.1-7.7c-19.3-28.9-29.6-62.9-29.6-97.6l0-31.6c0-8.8 7.2-16 16-16s16 7.2 16 16zM288 392c0-22.1 17.9-40 40-40l16 0c22.1 0 40 17.9 40 40l0 80c0 22.1-17.9 40-40 40l-16 0c-22.1 0-40-17.9-40-40l0-80zm40-8c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-80c0-4.4-3.6-8-8-8l-16 0z"]
}, faTriangle = {
  prefix: "fas",
  iconName: "triangle",
  icon: [512, 512, [9650], "f2ec", "M290.5 51.8C283.3 39.5 270.2 32 256 32s-27.3 7.5-34.5 19.8l-216 368c-7.3 12.4-7.3 27.7-.2 40.1S25.7 480 40 480l432 0c14.3 0 27.6-7.7 34.7-20.1s7-27.8-.2-40.1l-216-368z"]
}, faApartment = {
  prefix: "fas",
  iconName: "apartment",
  icon: [576, 512, [], "e468", "M176 0c-26.5 0-48 21.5-48 48l0 48L48 96C21.5 96 0 117.5 0 144L0 464c0 26.5 21.5 48 48 48l80 0 32 0 96 0 0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96 96 0 32 0 80 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48l-80 0 0-144c0-26.5-21.5-48-48-48L176 0zM368 320l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16zm144 80c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32zM112 320l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16zm16 80c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32zm112-80l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16zM384 80l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zM240 64c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0zM384 208c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32zM496 320l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16zM128 208c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32zm112 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16z"]
}, faTruckMedical = {
  prefix: "fas",
  iconName: "truck-medical",
  icon: [640, 512, [128657, "ambulance"], "f0f9", "M0 48C0 21.5 21.5 0 48 0L368 0c26.5 0 48 21.5 48 48l0 48 50.7 0c17 0 33.3 6.7 45.3 18.7L589.3 192c12 12 18.7 28.3 18.7 45.3l0 18.7 0 32 0 64c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c0 53-43 96-96 96s-96-43-96-96l-128 0c0 53-43 96-96 96s-96-43-96-96l-16 0c-26.5 0-48-21.5-48-48L0 48zM416 256l128 0 0-18.7L466.7 160 416 160l0 96zM160 464a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm368-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM176 80l0 48-48 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]
}, faAmbulance = faTruckMedical, faPepper = {
  prefix: "fas",
  iconName: "pepper",
  icon: [512, 512, [129745], "e432", "M252.6 11.7C245.8 .3 231-3.4 219.7 3.4s-15.1 21.6-8.2 32.9l10.3 17.2c6.7 11.2 10.3 24 10.3 37l0 10.9c-5-1.8-10.1-3.1-15.3-4l-.9-.2c-8.8-1.5-17.9-1.7-27.1-.6c-4 .5-7.9 1.2-11.9 2.2c-51.4 12.9-74.7 65-61.9 116.4l37.1 148.3c2.1 8.6-3.1 17.3-11.6 19.4s-17.3-3.1-19.4-11.6L83.8 223c-11.8-47 .4-94.4 31.3-125.2c-13.6-2.8-28-2.6-42.4 1C21.3 111.7-10 163.9 2.9 215.3l56 224c12.9 51.4 65 82.7 116.4 69.8c7-1.7 13.6-4.2 19.8-7.3c5.6-2.8 12.3-2.8 17.9 0c3 1.5 6 2.8 9.2 4c10.7 4 22.2 6.2 34 6.2c11.6 0 22.9-2.1 33.5-6.1c3.2-1.2 6.4-2.6 9.4-4.1c5.6-2.8 12.3-2.8 17.9 0c6.2 3.1 12.8 5.6 19.8 7.3c51.4 12.9 103.6-18.4 116.4-69.8l56-224c12.9-51.4-18.4-103.6-69.8-116.4c-23.2-5.8-46.5-2.6-66.3 7.3c-5.6 2.8-12.3 2.8-17.9 0c-6.2-3.1-12.8-5.6-19.8-7.3c-19-4.8-38.1-3.5-55.3 2.6l0-10.9c0-21.7-5.9-43.1-17.1-61.7L252.6 11.7z"]
}, faPiano = {
  prefix: "fas",
  iconName: "piano",
  icon: [512, 512, [], "f8d4", "M0 192L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-120.4c0-24.2-13.7-46.4-35.4-57.2l-58.4-29.2c-21-10.5-34.2-31.9-34.2-55.4C384 83.2 300.8 0 198.3 0L192 0C86 0 0 86 0 192zM416 352l32 0 0 96L64 448l0-96 32 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 32 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 32 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 64 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 32 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48z"]
}, faGunSquirt = {
  prefix: "fas",
  iconName: "gun-squirt",
  icon: [576, 512, [], "e19d", "M128 56c0-13.3-10.7-24-24-24S80 42.7 80 56l0 9.3C34.6 72.9 0 112.4 0 160c0 47.3 34.3 86.7 79.4 94.6L33 440.2c-2.4 9.6-.2 19.7 5.8 27.5S54.1 480 64 480l104 0c14.7 0 27.5-10 31-24.2L219 376l53 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-41 0 18-72 199 0c41.8 0 77.4-26.7 90.5-64l13.5 0c13.3 0 24-10.7 24-24l0-16c0-13.3-10.7-24-24-24l-13.5 0C525.4 90.7 489.8 64 448 64L128 64l0-8zM96 128l352 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L96 192c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faWheatAwnCircleExclamation = {
  prefix: "fas",
  iconName: "wheat-awn-circle-exclamation",
  icon: [640, 512, [], "e598", "M505 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L383 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l88-88zM305.5 27.3c-6.2-6.2-16.4-6.2-22.6 0L271.5 38.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8l-11.3-11.3c-6.2-6.2-16.4-6.2-22.6 0l-11.3 11.3c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8L101.8 231c-6.2-6.2-16.4-6.2-22.6 0L67.9 242.3c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4L9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l68.9-68.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6l-11.3-11.3c-21.8-21.8-49.6-34.1-78.1-36.9l31.9-31.9 12.2 12.2c22.5 22.5 53.3 31.5 82.4 27c0-1 0-2.1 0-3.1c0-33.1 9.1-64.1 25-90.6c-15.5-8.7-32.5-13.8-49.8-15.5l31.9-31.9 12.2 12.2c6 6 12.6 11.1 19.7 15.2c27.5-34 67.3-57.5 112.6-63.8c-4.1-3.8-8.4-7.3-12.9-10.5L505 137c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-59.4 59.4c-20.6-4.4-42-3.7-62.3 2.1c6.1-21.3 6.6-43.8 1.4-65.3L409 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L329.1 52.9c-3.7-5-7.8-9.8-12.4-14.3L305.5 27.3zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0-144c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]
}, faSnowman = {
  prefix: "fas",
  iconName: "snowman",
  icon: [512, 512, [9731, 9924], "f7d0", "M341.1 140.6c-2 3.9-1.6 8.6 1.2 12c7 8.5 12.9 18.1 17.2 28.4L408 160.2l0-40.2c0-13.3 10.7-24 24-24s24 10.7 24 24l0 19.6 22.5-9.7c12.2-5.2 26.3 .4 31.5 12.6s-.4 26.3-12.6 31.5l-56 24-73.6 31.5c-.5 9.5-2.1 18.6-4.8 27.3c-1.2 3.8-.1 8 2.8 10.8C396.7 296.9 416 338.2 416 384c0 44.7-18.3 85-47.8 114.1c-9.9 9.7-23.7 13.9-37.5 13.9l-149.3 0c-13.9 0-27.7-4.2-37.5-13.9C114.3 469 96 428.7 96 384c0-45.8 19.3-87.1 50.1-116.3c2.9-2.8 4-6.9 2.8-10.8c-2.7-8.7-4.3-17.9-4.8-27.3L70.5 198.1l-56-24C2.4 168.8-3.3 154.7 1.9 142.5s19.3-17.8 31.5-12.6L56 139.6 56 120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40.2L152.6 181c4.3-10.3 10.1-19.9 17.2-28.4c2.8-3.4 3.3-8.1 1.2-12C164 127.2 160 112.1 160 96c0-53 43-96 96-96s96 43 96 96c0 16.1-4 31.2-10.9 44.6zM224 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm48 128a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-16 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM288 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-48 24l0 3.2c0 3.2 .8 6.3 2.3 9l9 16.9c.9 1.7 2.7 2.8 4.7 2.8s3.8-1.1 4.7-2.8l9-16.9c1.5-2.8 2.3-5.9 2.3-9l0-3.2c0-8.8-7.2-16-16-16s-16 7.2-16 16z"]
}, faUserAlien = {
  prefix: "fas",
  iconName: "user-alien",
  icon: [448, 512, [], "e04a", "M64 167C64 74.8 135.6 0 224 0s160 74.8 160 167c0 101-106.6 185-139.2 208.3c-6.1 4.3-13.4 6.5-20.8 6.5s-14.7-2.1-20.8-6.5C170.6 352 64 268.1 64 167zm244.6 9c-37.9 0-68.6 30.7-68.6 68.6c0 6.3 5.1 11.4 11.4 11.4l16 0c37.9 0 68.6-30.7 68.6-68.6c0-6.3-5.1-11.4-11.4-11.4l-16 0zM208 244.6c0-37.9-30.7-68.6-68.6-68.6l-16 0c-6.3 0-11.4 5.1-11.4 11.4c0 37.9 30.7 68.6 68.6 68.6l16 0c6.3 0 11.4-5.1 11.4-11.4zM0 486.4C0 415 55.7 356.6 126.1 352.3c23.8 23.2 46.1 40.2 58.5 49.1c12 8.6 25.9 12.4 39.4 12.4s27.4-3.8 39.4-12.4c12.4-8.8 34.7-25.8 58.5-49.1C392.3 356.6 448 415 448 486.4c0 14.1-11.5 25.6-25.6 25.6L25.6 512C11.5 512 0 500.5 0 486.4z"]
}, faShieldCheck = {
  prefix: "fas",
  iconName: "shield-check",
  icon: [512, 512, [], "f2f7", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2c.5 99.2 41.3 280.7 213.6 363.2c16.7 8 36.1 8 52.8 0C454.7 420.7 495.5 239.2 496 140c.1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM369 209L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]
}, faMortarPestle = {
  prefix: "fas",
  iconName: "mortar-pestle",
  icon: [512, 512, [], "f5a7", "M504.3 11.1C493.3-1.6 474.5-3.7 461 6.2L252.3 160l144.9 0L502.6 54.6c11.8-11.8 12.6-30.8 1.6-43.5zM32 192c-17.7 0-32 14.3-32 32s14.3 32 32 32c0 82.5 43.4 147.7 123.9 176.2c-11.1 13.9-19.4 30.3-23.9 48.1C127.6 497.4 142.3 512 160 512l192 0c17.7 0 32.4-14.6 28.1-31.7c-4.5-17.8-12.8-34.1-23.9-48.1C436.6 403.7 480 338.5 480 256c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 192z"]
}, faRoadBarrier = {
  prefix: "fas",
  iconName: "road-barrier",
  icon: [640, 512, [], "e562", "M32 32C14.3 32 0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-181.7L149.2 96 64 96l0-32c0-17.7-14.3-32-32-32zM405.2 96l-74.3 0-5.4 10.7L234.8 288l74.3 0 5.4-10.7L405.2 96zM362.8 288l74.3 0 5.4-10.7L533.2 96l-74.3 0-5.4 10.7L362.8 288zM202.8 96l-5.4 10.7L106.8 288l74.3 0 5.4-10.7L277.2 96l-74.3 0zm288 192l85.2 0 0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 53.7L490.8 288z"]
}, faChartCandlestick = {
  prefix: "fas",
  iconName: "chart-candlestick",
  icon: [512, 512, [], "e0e2", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zM320 48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32l0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l0-48zm64 176l0 64c0 17.7 14.3 32 32 32l0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48c-17.7 0-32 14.3-32 32zM160 128c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48z"]
}, faBriefcaseBlank = {
  prefix: "fas",
  iconName: "briefcase-blank",
  icon: [512, 512, [], "e0c8", "M176 56l0 40 160 0 0-40c0-4.4-3.6-8-8-8L184 48c-4.4 0-8 3.6-8 8zM128 96l0-40c0-30.9 25.1-56 56-56L328 0c30.9 0 56 25.1 56 56l0 40 64 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l64 0z"]
}, faSchool = {
  prefix: "fas",
  iconName: "school",
  icon: [640, 512, [127979], "f549", "M337.8 5.4C327-1.8 313-1.8 302.2 5.4L166.3 96 48 96C21.5 96 0 117.5 0 144L0 464c0 26.5 21.5 48 48 48l208 0 0-96c0-35.3 28.7-64 64-64s64 28.7 64 64l0 96 208 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L473.7 96 337.8 5.4zM96 192l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zm400 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zM96 320l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zm400 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zM232 176a88 88 0 1 1 176 0 88 88 0 1 1 -176 0zm88-48c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16z"]
}, faIgloo = {
  prefix: "fas",
  iconName: "igloo",
  icon: [576, 512, [], "f7ae", "M320 33.8L320 160 48.5 160C100.2 82.8 188.1 32 288 32c10.8 0 21.5 .6 32 1.8zM352 160l0-120.9C424.9 55.7 487.2 99.8 527.5 160L352 160zM29.9 192L96 192l0 128L0 320c0-46 10.8-89.4 29.9-128zM192 320l-64 0 0-128 320 0 0 128-64 0 0 32 192 0 0 80c0 26.5-21.5 48-48 48l-176 0 0-128c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 128L48 480c-26.5 0-48-21.5-48-48l0-80 192 0 0-32zm288 0l0-128 66.1 0c19.2 38.6 29.9 82 29.9 128l-96 0z"]
}, faBracketRound = {
  prefix: "fas",
  iconName: "bracket-round",
  icon: [192, 512, ["parenthesis"], "28", "M154.6 46.2c9.8 14.7 5.8 34.6-8.9 44.4C120.1 107.7 64 167 64 256s56.1 148.3 81.8 165.4c14.7 9.8 18.7 29.7 8.9 44.4s-29.7 18.7-44.4 8.9C71.9 449.1 0 371.8 0 256S71.9 62.9 110.2 37.4c14.7-9.8 34.6-5.8 44.4 8.9z"]
}, faParenthesis = faBracketRound, faJoint = {
  prefix: "fas",
  iconName: "joint",
  icon: [640, 512, [], "f595", "M448 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 11c0 55.2 21.9 108.1 60.9 147.1l21 21c9 9 14.1 21.2 14.1 33.9l0 11c0 17.7 14.3 32 32 32s32-14.3 32-32l0-11c0-29.7-11.8-58.2-32.8-79.2l-21-21C463.2 117.8 448 81.2 448 43l0-11zM576 256c0 17.7 14.3 32 32 32s32-14.3 32-32l0-11c0-55.2-21.9-108.1-60.9-147.1l-21-21c-9-9-14.1-21.2-14.1-33.9l0-11c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 11c0 29.7 11.8 58.2 32.8 79.2l21 21c27 27 42.2 63.6 42.2 101.8l0 11zM229.8 360c-4.7-2.3-10-2.7-15.2-2c-37.8 5.6-75.2 14.3-106.9 22.8C81.3 388 58.3 395.1 42 400.4c-8.2 2.7-14.7 4.9-19.2 6.5c-2.3 .8-4 1.4-5.2 1.8l-1.3 .5C6.8 412.5 0 421.4 0 432s6.8 19.5 16.3 22.7l1.3 .5c1.2 .4 3 1.1 5.2 1.8c4.5 1.6 11 3.8 19.2 6.5c16.3 5.4 39.2 12.5 65.7 19.6C160.3 497.3 228.8 512 288 512l67.3 0c4.1 0 6.3-5.1 3.6-8.3L256.5 380.8c-7.4-8.9-16.5-15.9-26.7-20.8zM445 512l19 0 51.3 0c4.1 0 6.3-5.1 3.6-8.3L416.5 380.8C401.3 362.5 378.8 352 355 352l-19 0-48 0c-1.1 0-2.3 0-3.4 0c-4.1 0-6.2 5.1-3.5 8.3L383.5 483.2C398.7 501.5 421.2 512 445 512zm-3.9-151.7L543.5 483.2c14.6 17.5 35.9 27.9 58.6 28.7c21.1-1.1 37.9-18.6 37.9-39.9l0-80c0-22.1-17.9-40-40-40l-155.3 0c-4.1 0-6.3 5.1-3.6 8.3z"]
}, faHorseSaddle = {
  prefix: "fas",
  iconName: "horse-saddle",
  icon: [576, 512, [], "f8c3", "M448 238.1l0-78.1 16 0 9.8 19.6c12.5 25.1 42.2 36.4 68.3 26c20.5-8.2 33.9-28 33.9-50.1L576 80c0-19.1-8.4-36.3-21.7-48l5.7 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L480 0 448 0C377.3 0 320 57.3 320 128l0 32c0 41.8-26.7 77.4-64 90.5l0 78.6 51.7 14.8c4.1 1.2 8.2 2.1 12.3 2.8L320 480c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-164.3c19.2-19.2 31.5-45.7 32-75.7c0 0 0 0 0 0l0-1.9zM224 320l0-64c-53 0-96-43-96-96l0-29.4c-21.8 5.5-40.3 19.5-51.7 38.2C33.2 174.5 0 211.4 0 256l0 56c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56c0-13.4 6.6-25.2 16.7-32.5c1.6 13 6.3 25.4 13.6 36.4l28.2 42.4c8.3 12.4 6.4 28.7-1.2 41.6c-16.5 28-20.6 62.2-10 93.9l17.5 52.4c4.4 13.1 16.6 21.9 30.4 21.9l33.7 0c21.8 0 37.3-21.4 30.4-42.1l-20.8-62.5c-2.1-6.4-.5-13.4 4.3-18.2l12.7-12.7c13.2-13.2 20.6-31.1 20.6-49.7c0-2.3-.1-4.6-.3-6.9l.3 .1zm64-160l0-32-64 0-20.8 0L160 128l0 32c0 35.3 28.7 64 64 64s64-28.7 64-64zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faMugMarshmallows = {
  prefix: "fas",
  iconName: "mug-marshmallows",
  icon: [512, 512, [], "f7b7", "M192 32c7.5 0 14.4 2.6 19.8 6.9L175 75.7c-9.6 9.6-15 22.7-15 36.3c0 5.5 .9 10.9 2.6 16L32 128l0-64c0-17.7 14.3-32 32-32l128 0zm5.7 93.7C194 122 192 117.1 192 112s2-10 5.7-13.7l60.7-60.7C262 34 266.9 32 272 32s10 2 13.7 5.7l60.7 60.7c3.6 3.6 5.7 8.5 5.7 13.7s-2 10-5.7 13.7L344 128l-144 0-2.3-2.3zM0 192c0-17.7 14.3-32 32-32l64 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 192 0 48 0c61.9 0 112 50.1 112 112s-50.1 112-112 112l-16 0c0 53-43 96-96 96L96 480c-53 0-96-43-96-96L0 192zm384 32l0 96 16 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-16 0z"]
}, faFilters = {
  prefix: "fas",
  iconName: "filters",
  icon: [640, 512, [], "e17e", "M232 32c-15.9 0-30.2 9.4-36.6 23.9s-3.6 31.5 7.2 43.2L352 261.5 352 368c0 10.1 4.7 19.6 12.8 25.6l64 48c9.7 7.3 22.7 8.4 33.5 3s17.7-16.5 17.7-28.6l0-154.5L629.4 99.1c10.7-11.7 13.6-28.6 7.2-43.2S615.9 32 600 32L232 32zM40 96c-15.9 0-30.2 9.4-36.6 23.9s-3.6 31.5 7.2 43.2L160 325.5l0 74.5c0 10.1 4.7 19.6 12.8 25.6l64 48c9.7 7.3 22.7 8.4 33.5 3s17.7-16.5 17.7-28.6l0-122.5 32-34.8 0-16.7L179 120.7c-6.7-7.3-11.7-15.7-14.9-24.7L40 96z"]
}, faBellOn = {
  prefix: "fas",
  iconName: "bell-on",
  icon: [640, 512, [128365], "f8fa", "M320 0c-17.7 0-32 14.3-32 32l0 19.2C215 66 160 130.6 160 208l0 18.8c0 47-17.3 92.4-48.5 127.6l-7.4 8.3c-8.4 9.4-10.4 22.9-5.3 34.4S115.4 416 128 416l384 0c12.6 0 24-7.4 29.2-18.9s3.1-25-5.3-34.4l-7.4-8.3C497.3 319.2 480 273.9 480 226.8l0-18.8c0-77.4-55-142-128-156.8L352 32c0-17.7-14.3-32-32-32zm45.3 493.3c12-12 18.7-28.3 18.7-45.3l-64 0-64 0c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7zM0 200c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zm536-24c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zM597.5 21.3c-5.9-11.9-20.3-16.7-32.2-10.7l-64 32c-11.9 5.9-16.7 20.3-10.7 32.2s20.3 16.7 32.2 10.7l64-32c11.9-5.9 16.7-20.3 10.7-32.2zM53.3 53.5l64 32c11.9 5.9 26.3 1.1 32.2-10.7s1.1-26.3-10.7-32.2l-64-32C62.9 4.6 48.5 9.4 42.5 21.3s-1.1 26.3 10.7 32.2z"]
}, faAngleRight = {
  prefix: "fas",
  iconName: "angle-right",
  icon: [320, 512, [8250], "f105", "M278.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L210.7 256 73.4 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160z"]
}, faDialMed = {
  prefix: "fas",
  iconName: "dial-med",
  icon: [576, 512, [], "e15f", "M288 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM128 287.2C128 207 187 140.6 264 129l0 158.2c0 13.3 10.7 24 24 24s24-10.7 24-24L312 129c77 11.6 136 78 136 158.2c0 88.4-71.6 160-160 160s-160-71.6-160-160zm384 .8a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0A32 32 0 1 1 64 96zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faHorse = {
  prefix: "fas",
  iconName: "horse",
  icon: [576, 512, [128014], "f6f0", "M448 238.1l0-78.1 16 0 9.8 19.6c12.5 25.1 42.2 36.4 68.3 26c20.5-8.2 33.9-28 33.9-50.1L576 80c0-19.1-8.4-36.3-21.7-48l5.7 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L480 0 448 0C377.3 0 320 57.3 320 128l-96 0-20.8 0-54.4 0c-30.7 0-57.6 16.3-72.5 40.8C33.2 174.5 0 211.4 0 256l0 56c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56c0-13.4 6.6-25.2 16.7-32.5c1.6 13 6.3 25.4 13.6 36.4l28.2 42.4c8.3 12.4 6.4 28.7-1.2 41.6c-16.5 28-20.6 62.2-10 93.9l17.5 52.4c4.4 13.1 16.6 21.9 30.4 21.9l33.7 0c21.8 0 37.3-21.4 30.4-42.1l-20.8-62.5c-2.1-6.4-.5-13.4 4.3-18.2l12.7-12.7c13.2-13.2 20.6-31.1 20.6-49.7c0-2.3-.1-4.6-.3-6.9l84 24c4.1 1.2 8.2 2.1 12.3 2.8L320 480c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-164.3c19.2-19.2 31.5-45.7 32-75.7c0 0 0 0 0 0l0-1.9zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faQ = {
  prefix: "fas",
  iconName: "q",
  icon: [448, 512, [113], "51", "M64 256c0 88.4 71.6 160 160 160c28.9 0 56-7.7 79.4-21.1l-72-86.4c-11.3-13.6-9.5-33.8 4.1-45.1s33.8-9.5 45.1 4.1l70.9 85.1C371.9 325.8 384 292.3 384 256c0-88.4-71.6-160-160-160S64 167.6 64 256zM344.9 444.6C310 467 268.5 480 224 480C100.3 480 0 379.7 0 256S100.3 32 224 32s224 100.3 224 224c0 56.1-20.6 107.4-54.7 146.7l47.3 56.8c11.3 13.6 9.5 33.8-4.1 45.1s-33.8 9.5-45.1-4.1l-46.6-55.9z"]
}, faMonitorWaveform = {
  prefix: "fas",
  iconName: "monitor-waveform",
  icon: [576, 512, ["monitor-heart-rate"], "f611", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM80 96l416 0c8.8 0 16 7.2 16 16l0 288c0 8.8-7.2 16-16 16L80 416c-8.8 0-16-7.2-16-16l0-128 0-160c0-8.8 7.2-16 16-16zM96 256l96 0c6.1 0 11.6 3.4 14.3 8.8L224 300.2l49.7-99.4c2.7-5.4 8.3-8.8 14.3-8.8s11.6 3.4 14.3 8.8L329.9 256l70.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0c-6.1 0-11.6-3.4-14.3-8.8L288 243.8l-49.7 99.4c-2.7 5.4-8.3 8.8-14.3 8.8s-11.6-3.4-14.3-8.8L182.1 288 96 288l0 96 384 0 0-256L96 128l0 128z"]
}, faMonitorHeartRate = faMonitorWaveform, faLinkSimple = {
  prefix: "fas",
  iconName: "link-simple",
  icon: [576, 512, [], "e1cd", "M0 256C0 167.6 71.6 96 160 96l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-53 0-96 43-96 96s43 96 96 96l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0C71.6 416 0 344.4 0 256zm576 0c0 88.4-71.6 160-160 160l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c53 0 96-43 96-96s-43-96-96-96l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c88.4 0 160 71.6 160 160zM192 224l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faWhistle = {
  prefix: "fas",
  iconName: "whistle",
  icon: [640, 512, [], "f460", "M44.1 188.8C18.5 180.5 0 156.4 0 128C0 92.7 28.7 64 64 64c23.4 0 43.8 12.5 55 31.2C149.2 75.5 185.2 64 224 64c7.8 0 15.4 .5 22.9 1.4c.5 0 1.1 0 1.7 .1c37.8 4.5 73.8 19.4 103.9 43.2l69.8 55.2c5 4 7.2 10.6 5.5 16.8l-6.5 24c-3.2 11.7 1.1 24.2 10.8 31.5c9.6 7.2 22.7 7.9 33 1.7l19.3-11.6c5.7-3.4 12.9-3 18.2 1.2l127 100.4c6.6 5.2 10.5 13.2 10.5 21.6c0 6.9-2.6 13.5-7.2 18.5l-63.3 69.6c-6.1 6.7-14.7 10.5-23.7 10.5l-2 0c-5.2 0-10.2-1.2-14.8-3.6L380.7 367c-34.8 49-92 81-156.7 81C118 448 32 362 32 256c0-23.6 4.3-46.3 12.1-67.2zM80 128a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM224 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]
}, faG = {
  prefix: "fas",
  iconName: "g",
  icon: [448, 512, [103], "47", "M224 96C135.6 96 64 167.6 64 256s71.6 160 160 160c77.4 0 142-55 156.8-128L256 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l144 0c25.8 0 49.6 21.4 47.2 50.6C437.8 389.6 341.4 480 224 480C100.3 480 0 379.7 0 256S100.3 32 224 32c57.4 0 109.7 21.6 149.3 57c13.2 11.8 14.3 32 2.5 45.2s-32 14.3-45.2 2.5C302.3 111.4 265 96 224 96z"]
}, faWineGlassCrack = {
  prefix: "fas",
  iconName: "wine-glass-crack",
  icon: [320, 512, ["fragile"], "f4bb", "M64 0C47.4 0 33.5 12.8 32.1 29.3l-14 168.4c-6 72 42.5 135.2 109.9 150.6l0 99.6-48 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l80 0 80 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-48 0 0-99.6c67.4-15.4 115.9-78.6 109.9-150.6l-14-168.4C286.5 12.8 272.6 0 256 0L233.9 0C222 0 214.3 12.5 219.6 23.2l14.2 28.5c3.5 7.1 1.4 15.7-5.1 20.3l-58.4 40.9c-6 4.2-8.4 12-5.8 18.9l31.1 81c2.1 5.5-1.9 11.4-7.8 11.4c-2.4 0-4.7-1.1-6.3-2.9L92.1 118c-6.4-7.4-4.7-18.7 3.5-24l58.6-37.3c7.6-4.8 9.7-14.9 4.7-22.4L140.7 7.1c-3-4.5-8-7.1-13.3-7.1L64 0z"]
}, faFragile = faWineGlassCrack, faSlotMachine = {
  prefix: "fas",
  iconName: "slot-machine",
  icon: [640, 512, [], "e3ce", "M128 0C92.7 0 64 28.7 64 64l384 0c0-35.3-28.7-64-64-64L128 0zM64 96C28.7 96 0 124.7 0 160L0 352c0 35.3 28.7 64 64 64l0 32c0 35.3 28.7 64 64 64l288 0 32 0 80 0c53 0 96-43 96-96l0-204.2c9.8-8.8 16-21.6 16-35.8c0-26.5-21.5-48-48-48s-48 21.5-48 48c0 14.2 6.2 27 16 35.8L560 416c0 17.7-14.3 32-32 32l-80 0 0-32c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64L64 96zM56 200c0-13.3 10.7-24 24-24l59.9 0c23 0 38.5 23.5 29.4 44.6L126.1 321.5c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5L115.6 224 80 224c-13.3 0-24-10.7-24-24zm168-24l59.9 0c23 0 38.5 23.5 29.4 44.6L270.1 321.5c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5L259.6 224 224 224c-13.3 0-24-10.7-24-24s10.7-24 24-24zm120 24c0-13.3 10.7-24 24-24l59.9 0c23 0 38.5 23.5 29.4 44.6L414.1 321.5c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5L403.6 224 368 224c-13.3 0-24-10.7-24-24z"]
}, faNotesMedical = {
  prefix: "fas",
  iconName: "notes-medical",
  icon: [512, 512, [], "f481", "M96 352L96 96c0-35.3 28.7-64 64-64l256 0c35.3 0 64 28.7 64 64l0 197.5c0 17-6.7 33.3-18.7 45.3l-58.5 58.5c-12 12-28.3 18.7-45.3 18.7L160 416c-35.3 0-64-28.7-64-64zM272 128c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16l-32 0zm24 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0C60.9 512 0 451.1 0 376L0 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 224c0 48.6 39.4 88 88 88l160 0z"]
}, faCarWash = {
  prefix: "fas",
  iconName: "car-wash",
  icon: [448, 512, [], "f5e6", "M64 128c26.5 0 48-16 48-48c0-22.2-23-52-37.2-68.2C69 5.1 59 5.1 53.2 11.8C39 28 16 57.8 16 80c0 26.5 21.5 48 48 48zm160 0c26.5 0 48-16 48-48c0-22.2-23-52-37.2-68.2c-5.8-6.7-15.9-6.7-21.7 0C199 28 176 57.8 176 80c0 26.5 21.5 48 48 48zM432 80c0-22.2-23-52-37.2-68.2c-5.8-6.7-15.9-6.7-21.7 0C359 28 336 57.8 336 80c0 26.5 21.5 48 48 48s48-16 48-48zM153.8 224l140.3 0c6.8 0 12.8 4.3 15.1 10.6L328.3 288l-208.6 0 19.1-53.4c2.3-6.4 8.3-10.6 15.1-10.6zM78.5 213.1L50.2 292.4C30.1 300.9 16 320.8 16 344l0 40 0 64 0 32c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-32 256 0 0 32c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-32 0-64 0-40c0-23.2-14.1-43.1-34.2-51.6l-28.3-79.3C358.1 181.3 328 160 294.2 160l-140.3 0c-33.8 0-64 21.3-75.3 53.1zM96 344a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm232 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faEscalator = {
  prefix: "fas",
  iconName: "escalator",
  icon: [640, 512, [], "e171", "M208 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM405.9 175.8C417.5 165.6 432.5 160 448 160l96 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-72 0L234.1 496.2C222.5 506.4 207.5 512 192 512l-96 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l72 0L405.9 175.8zM320 192l0 16.4-128 112L192 192c0-35.3 28.7-64 64-64s64 28.7 64 64z"]
}, faCommentImage = {
  prefix: "fas",
  iconName: "comment-image",
  icon: [512, 512, [], "e148", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM128 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm168-16c7.6 0 14.7 3.6 19.2 9.6l96 128c5.5 7.3 6.3 17 2.3 25.1s-12.4 13.3-21.5 13.3l-192 0-80 0c-9.3 0-17.8-5.4-21.7-13.8s-2.7-18.4 3.3-25.5l40-48c4.6-5.5 11.3-8.6 18.4-8.6s13.9 3.2 18.4 8.6L199 257.3l77.8-103.7c4.5-6 11.6-9.6 19.2-9.6z"]
}, faTemperatureHalf = {
  prefix: "fas",
  iconName: "temperature-half",
  icon: [320, 512, [127777, "temperature-2", "thermometer-2", "thermometer-half"], "f2c9", "M160 64c-26.5 0-48 21.5-48 48l0 164.5c0 17.3-7.1 31.9-15.3 42.5C86.2 332.6 80 349.5 80 368c0 44.2 35.8 80 80 80s80-35.8 80-80c0-18.5-6.2-35.4-16.7-48.9c-8.2-10.6-15.3-25.2-15.3-42.5L208 112c0-26.5-21.5-48-48-48zM48 112C48 50.2 98.1 0 160 0s112 50.1 112 112l0 164.4c0 .1 .1 .3 .2 .6c.2 .6 .8 1.6 1.7 2.8c18.9 24.4 30.1 55 30.1 88.1c0 79.5-64.5 144-144 144S16 447.5 16 368c0-33.2 11.2-63.8 30.1-88.1c.9-1.2 1.5-2.2 1.7-2.8c.1-.3 .2-.5 .2-.6L48 112zM208 368c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3L144 208c0-8.8 7.2-16 16-16s16 7.2 16 16l0 114.7c18.6 6.6 32 24.4 32 45.3z"]
}, faTemperature2 = faTemperatureHalf, faThermometer2 = faTemperatureHalf, faThermometerHalf = faTemperatureHalf, faDongSign = {
  prefix: "fas",
  iconName: "dong-sign",
  icon: [384, 512, [], "e169", "M288 32c-17.7 0-32 14.3-32 32l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 49.1c-18.8-10.9-40.7-17.1-64-17.1c-70.7 0-128 57.3-128 128s57.3 128 128 128c24.5 0 47.4-6.9 66.8-18.8c5 11.1 16.2 18.8 29.2 18.8c17.7 0 32-14.3 32-32l0-96 0-160c17.7 0 32-14.3 32-32s-14.3-32-32-32c0-17.7-14.3-32-32-32zM128 288a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448z"]
}, faDonut = {
  prefix: "fas",
  iconName: "donut",
  icon: [512, 512, [127849, "doughnut"], "e406", "M0 208C0 119.6 114.6 48 256 48s256 71.6 256 160l0 31c-.7 10-4.3 19.5-10.5 27.4c-6.2 8-14.7 14-24.4 17.1l-.3 .1-.3 .1c-13.1 4.9-24.4 13.8-32 25.5c-9.4 13-22 23.3-36.5 30.1c-14.7 6.8-30.8 9.6-46.9 8.3l-.6 0-.6 0c-17.7-.2-35.3 3.3-51.7 10.1c0 0 0 0 0 0l-.1 0c-16.4 7-34.1 10.5-51.9 10.3c0 0 0 0 0 0l-.3 0c-17.8 .2-35.5-3.3-51.9-10.3l-.1 0c-16.4-6.8-34-10.2-51.7-10.1l-.6 0-.6 0c-16.1 1.3-32.3-1.6-46.9-8.4c-14.6-6.8-27.1-17.1-36.5-30.2c-7.7-11.7-18.9-20.6-32-25.5l-.4-.1-.4-.1c-9.7-3.1-18.2-9.1-24.4-17.1C4.3 258.4 .7 248.9 0 238.9L0 208zm0 92.7c7.4 5.7 15.7 10.1 24.6 13c6.7 2.6 12.4 7.2 16.3 13.2l.2 .3 .2 .3c12.6 17.6 29.6 31.7 49.3 40.8c19.5 9 41 12.9 62.4 11.3c13.2-.1 26.3 2.5 38.5 7.6c20.4 8.6 42.4 13 64.5 12.8c22.1 .2 44.1-4.2 64.5-12.8c12.2-5.1 25.3-7.6 38.5-7.6c21.4 1.7 42.9-2.2 62.3-11.2c19.7-9.1 36.7-23.1 49.3-40.7l.2-.3 .2-.3c3.9-6 9.6-10.6 16.3-13.2c8.9-2.9 17.3-7.4 24.6-13l0 3.2c0 88.4-114.6 160-256 160S0 392.4 0 304l0-3.3zM320 192c0-17.7-28.7-32-64-32s-64 14.3-64 32s28.7 32 64 32s64-14.3 64-32zM283.3 84.7c-6.2-6.2-16.4-6.2-22.6 0l-16 16c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l16-16c6.2-6.2 6.2-16.4 0-22.6zm-112 38.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-32 32c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l32-32zm224 9.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zM64 192c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0zm331.3 36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zm-240 16c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zm176 38.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-32 32c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l32-32z"]
}, faDoughnut = faDonut, faCapsules = {
  prefix: "fas",
  iconName: "capsules",
  icon: [576, 512, [], "f46b", "M64 144c0-26.5 21.5-48 48-48s48 21.5 48 48l0 112-96 0 0-112zM0 144L0 368c0 61.9 50.1 112 112 112s112-50.1 112-112l0-178.4c1.8 19.1 8.2 38 19.8 54.8L372.3 431.7c35.5 51.7 105.3 64.3 156 28.1s63-107.5 27.5-159.2L427.3 113.3C391.8 61.5 321.9 49 271.3 85.2c-28 20-44.3 50.8-47.3 83l0-24.2c0-61.9-50.1-112-112-112S0 82.1 0 144zm296.6 64.2c-16-23.3-10-55.3 11.9-71c21.2-15.1 50.5-10.3 66 12.2l67 97.6L361.6 303l-65-94.8zM491 407.7c-.8 .6-1.6 1.1-2.4 1.6l4-2.8c-.5 .4-1 .8-1.6 1.2z"]
}, faPooStorm = {
  prefix: "fas",
  iconName: "poo-storm",
  icon: [448, 512, ["poo-bolt"], "f75a", "M236.9 .2c-5.5-.7-11 1.4-14.5 5.7s-4.6 10.1-2.8 15.3c2.8 8.2 4.3 16.9 4.3 26.1c0 21.7-8.5 37.2-21.9 47.6c-13.8 10.8-34 17-57.8 17L128 112c-35.3 0-64 28.7-64 64c0 12.2 3.4 23.5 9.3 33.2C31.7 216.2 0 252.4 0 296c0 40.9 28 75.4 65.8 85.2c-5.3-18.5 1-38.5 16.2-50.7l160-128c17.6-14.1 42.6-14 60.2 .2s22.8 38.6 12.8 58.8L285.7 320l18.3 0c20.4 0 38.5 12.9 45.3 32.1c3.7 10.6 3.5 21.8 0 31.9l10.7 0c48.6 0 88-39.4 88-88c0-43.6-31.7-79.8-73.3-86.8c5.9-9.7 9.3-21.1 9.3-33.2c0-35.3-28.7-64-64-64l-1.4 0c.9-5.4 1.4-10.9 1.4-16.6c0-48.7-36.1-88.9-83.1-95.2zm45.1 227.4c-5.8-4.7-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7l70.1 0L129.7 488.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7l-70.1 0 52.4-104.8c3.4-6.7 1.6-14.9-4.3-19.6z"]
}, faPooBolt = faPooStorm, faTally1 = {
  prefix: "fas",
  iconName: "tally-1",
  icon: [640, 512, [], "e294", "M128 32c17.7 0 32 14.3 32 32l0 384c0 17.7-14.3 32-32 32s-32-14.3-32-32L96 64c0-17.7 14.3-32 32-32z"]
}, faFileVector = {
  prefix: "fas",
  iconName: "file-vector",
  icon: [384, 512, [], "e64c", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM128 208l0 16 128 0 0-16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-16 0 0 128 16 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16-128 0 0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l16 0 0-128-16 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zm0 176l128 0 0-128-128 0 0 128z"]
}, faFaceFrownOpen = {
  prefix: "fas",
  iconName: "face-frown-open",
  icon: [512, 512, [128550, "frown-open"], "f57a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-122 174.5c-12.4 5.2-26.5-4.1-21.1-16.4c16-36.6 52.4-62.1 94.8-62.1s78.8 25.6 94.8 62.1c5.4 12.3-8.7 21.6-21.1 16.4c-22.4-9.5-47.4-14.8-73.7-14.8s-51.3 5.3-73.7 14.8z"]
}, faFrownOpen = faFaceFrownOpen, faSquareDashed = {
  prefix: "fas",
  iconName: "square-dashed",
  icon: [448, 512, [], "e269", "M96 32l32 0 0 64L96 96c-17.7 0-32 14.3-32 32l0 32L0 160l0-32C0 75 43 32 96 32zM0 192l64 0 0 128L0 320 0 192zm384 0l64 0 0 128-64 0 0-128zm64-32l-64 0 0-32c0-17.7-14.3-32-32-32l-32 0 0-64 32 0c53 0 96 43 96 96l0 32zm0 192l0 32c0 53-43 96-96 96l-32 0 0-64 32 0c17.7 0 32-14.3 32-32l0-32 64 0zM64 352l0 32c0 17.7 14.3 32 32 32l32 0 0 64-32 0c-53 0-96-43-96-96l0-32 64 0zm96 128l0-64 128 0 0 64-128 0zm0-384l0-64 128 0 0 64L160 96z"]
}, faBagShoppingPlus = {
  prefix: "fas",
  iconName: "bag-shopping-plus",
  icon: [448, 512, [], "e651", "M224 48c-35.3 0-64 28.7-64 64l0 48 128 0 0-48c0-35.3-28.7-64-64-64zM48 160l64 0 0-48C112 50.1 162.1 0 224 0s112 50.1 112 112l0 48 64 0c26.5 0 48 21.5 48 48l0 208c0 53-43 96-96 96L96 512c-53 0-96-43-96-96L0 208c0-26.5 21.5-48 48-48zM200 416c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56 56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0 0-56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 56-56 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l56 0 0 56z"]
}, faSquareJ = {
  prefix: "fas",
  iconName: "square-j",
  icon: [448, 512, [], "e273", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM304 152l0 136c0 53-43 96-96 96s-96-43-96-96l0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8c0 26.5 21.5 48 48 48s48-21.5 48-48l0-136c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faHandPointUp = {
  prefix: "fas",
  iconName: "hand-point-up",
  icon: [384, 512, [9757], "f0a6", "M32 32C32 14.3 46.3 0 64 0S96 14.3 96 32l0 208-64 0L32 32zM224 192c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-64-64c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32zm160 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-96 88l0-.6c9.4 5.4 20.3 8.6 32 8.6c13.2 0 25.4-4 35.6-10.8c8.7 24.9 32.5 42.8 60.4 42.8c11.7 0 22.6-3.1 32-8.6l0 8.6c0 88.4-71.6 160-160 160l-61.7 0c-42.4 0-83.1-16.9-113.1-46.9L37.5 453.5C13.5 429.5 0 396.9 0 363l0-27c0-35.3 28.7-64 64-64l88 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-56 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l56 0c39.8 0 72-32.2 72-72z"]
}, faMoneyBill = {
  prefix: "fas",
  iconName: "money-bill",
  icon: [576, 512, [], "f0d6", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm64 320l-64 0 0-64c35.3 0 64 28.7 64 64zM64 192l0-64 64 0c0 35.3-28.7 64-64 64zM448 384c0-35.3 28.7-64 64-64l0 64-64 0zm64-192c-35.3 0-64-28.7-64-64l64 0 0 64zM288 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]
}, faArrowUpBigSmall = {
  prefix: "fas",
  iconName: "arrow-up-big-small",
  icon: [576, 512, ["sort-size-up"], "f88e", "M160 32c9 0 17.5 3.8 23.6 10.4l88 96c11.9 13 11.1 33.3-2 45.2s-33.3 11.1-45.2-2L192 146.3 192 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-301.7L95.6 181.6c-11.9 13-32.2 13.9-45.2 2s-13.9-32.2-2-45.2l88-96C142.5 35.8 151 32 160 32zM320 368c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64zM368 32l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-128c0-26.5 21.5-48 48-48z"]
}, faSortSizeUp = faArrowUpBigSmall, faBarcodeRead = {
  prefix: "fas",
  iconName: "barcode-read",
  icon: [576, 512, [], "f464", "M56 48c-4.4 0-8 3.6-8 8l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24L0 56C0 25.1 25.1 0 56 0l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L56 48zm96 80l16 0c13.3 0 24 10.7 24 24l0 208c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24zm160 0l16 0c13.3 0 24 10.7 24 24l0 208c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24zm72 24c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24l0 208c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-208zM240 128c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16zM528 56c0-4.4-3.6-8-8-8l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c30.9 0 56 25.1 56 56l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80zM56 464l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-30.9 0-56-25.1-56-56l0-80c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80c0 4.4 3.6 8 8 8zm472-8l0-80c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80c0 30.9-25.1 56-56 56l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c4.4 0 8-3.6 8-8z"]
}, faBaguette = {
  prefix: "fas",
  iconName: "baguette",
  icon: [640, 512, [129366], "e3d8", "M583 234.5c58.8-39.2 74.7-118.7 35.5-177.5S499.8-17.7 441 21.5L356.5 77.8l70.8 70.8c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L329.3 95.9l-88 58.7 74 74c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-78.6-78.6-88 58.7 77.2 77.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L98.9 249.5 57 277.5C-1.8 316.7-17.7 396.2 21.5 455s118.7 74.7 177.5 35.5l384-256z"]
}, faBowlSoftServe = {
  prefix: "fas",
  iconName: "bowl-soft-serve",
  icon: [512, 512, [], "e46b", "M257.2 9.9c2.5-6 8.3-9.9 14.8-9.9l36.6 0C367.9 0 416 48.1 416 107.4c0 19.9-6.9 38.1-18.3 52.6l18.3 0c35.3 0 64 28.7 64 64s-28.7 64-64 64L96 288c-35.3 0-64-28.7-64-64s28.7-64 64-64l8.6 0c-5.4-9.4-8.6-20.3-8.6-32c0-35.3 28.7-64 64-64l94.1 0C264 64 272 56 272 46.1c0-4.8-1.9-9.3-5.3-12.7l-6.1-6.1c-4.6-4.6-5.9-11.5-3.5-17.4zM64 320l384 0c8.8 0 16 7.2 16 16l0 8c0 57.4-46.6 104-104 104l-30.1 0 20.4 40.8c1.1 2.3 1.7 4.7 1.7 7.2c0 2.9-.8 5.8-2.4 8.4c-2.9 4.7-8.1 7.6-13.6 7.6l-160 0c-5.5 0-10.7-2.9-13.6-7.6c-1.6-2.6-2.4-5.5-2.4-8.4c0-2.4 .6-4.9 1.7-7.2L182.1 448 152 448C94.6 448 48 401.4 48 344l0-8c0-8.8 7.2-16 16-16z"]
}, faFaceHoldingBackTears = {
  prefix: "fas",
  iconName: "face-holding-back-tears",
  icon: [512, 512, [129401], "e482", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM344.5 367.9c-6.7-5.8-16.8-5.1-22.6 1.6C309 384.4 287.1 400 256 400s-53-15.6-65.9-30.5c-5.8-6.7-15.9-7.4-22.6-1.6s-7.4 15.9-1.6 22.6C183.1 410.3 213.2 432 256 432s72.9-21.7 90.1-41.5c5.8-6.7 5.1-16.8-1.6-22.6zM240 272l0-32c0-41.5-31.5-75.6-72-79.6c10-10.8 17.6-24.1 21.9-38.8l1.5-5.2c2.4-8.5-2.5-17.4-11-19.8s-17.4 2.5-19.8 11l-1.5 5.2c-7 24.7-28.1 42.7-53.6 45.9L94 160.1c-8.8 1.1-15 9.1-13.9 17.9c1 8.1 7.9 14 15.9 14c-10 13.4-16 30-16 48s6 34.6 16 48l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-6.7c9.8 4.3 20.6 6.7 32 6.7c18 0 34.6-6 48-16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 0-16zm144 41.3l0 6.7c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c10-13.4 16-30 16-48s-6-34.6-16-48c8 0 14.9-5.9 15.9-14c1.1-8.8-5.1-16.8-13.9-17.9l-11.5-1.4c-25.5-3.2-46.6-21.3-53.6-45.9l-1.5-5.2c-2.4-8.5-11.3-13.4-19.8-11s-13.4 11.3-11 19.8l1.5 5.2c4.2 14.8 11.8 28 21.9 38.8c-40.4 4-72 38.1-72 79.6c0 44.2 35.8 80 80 80c11.4 0 22.2-2.4 32-6.7zM128 232c17.7 0 32-14.3 32-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4zm224-32c0-5.8-1.5-11.2-4.2-15.8c1.4-.1 2.8-.2 4.2-.2c30.9 0 56 25.1 56 56s-25.1 56-56 56s-56-25.1-56-56c0-5.7 .8-11.2 2.4-16.4c5.7 5.2 13.3 8.4 21.6 8.4c17.7 0 32-14.3 32-32z"]
}, faSquareUp = {
  prefix: "fas",
  iconName: "square-up",
  icon: [448, 512, [11014, "arrow-alt-square-up"], "f353", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm171.3 84.7l112 112c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9l-64 0 0 96c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-96-64 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l112-112c6.2-6.2 16.4-6.2 22.6 0z"]
}, faArrowAltSquareUp = faSquareUp, faTrainSubwayTunnel = {
  prefix: "fas",
  iconName: "train-subway-tunnel",
  icon: [512, 512, ["subway-tunnel"], "e2a3", "M256 0C114.6 0 0 114.6 0 256L0 448c0 35.3 28.7 64 64 64l41.4 0 64.3-64.3C137.3 444.5 112 417.2 112 384l0-192c0-35.3 28.7-64 64-64l160 0c35.3 0 64 28.7 64 64l0 192c0 33.2-25.3 60.5-57.7 63.7L406.6 512l41.4 0c35.3 0 64-28.7 64-64l0-192C512 114.6 397.4 0 256 0zM361.4 512l-64-64-82.7 0-64 64 210.7 0zM184 192c-13.3 0-24 10.7-24 24l0 8 0 64 0 8c0 13.3 10.7 24 24 24l8 0 16 0 8 0c13.3 0 24-10.7 24-24l0-8 0-64 0-8c0-13.3-10.7-24-24-24l-8 0-16 0-8 0zm88 24l0 8 0 64 0 8c0 13.3 10.7 24 24 24l8 0 16 0 8 0c13.3 0 24-10.7 24-24l0-8 0-64 0-8c0-13.3-10.7-24-24-24l-8 0-16 0-8 0c-13.3 0-24 10.7-24 24zM184 400a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm168-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]
}, faSubwayTunnel = faTrainSubwayTunnel, faSquareExclamation = {
  prefix: "fas",
  iconName: "square-exclamation",
  icon: [448, 512, ["exclamation-square"], "f321", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm160 96c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24zM192 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faExclamationSquare = faSquareExclamation, faSemicolon = {
  prefix: "fas",
  iconName: "semicolon",
  icon: [192, 512, [], "3b", "M96 64a64 64 0 1 1 0 128A64 64 0 1 1 96 64zm54.8 319L83.7 492.8C76.4 504.7 63.5 512 49.5 512C24 512 5 488.5 10.4 463.6L37.5 337c6.1-28.6 31.4-49 60.6-49c34.2 0 61.9 28.1 61.9 62.3c0 11.5-3.2 22.9-9.2 32.7z"]
}, faBookmark = {
  prefix: "fas",
  iconName: "bookmark",
  icon: [384, 512, [128278, 61591], "f02e", "M0 48V487.7C0 501.1 10.9 512 24.3 512c5 0 9.9-1.5 14-4.4L192 400 345.7 507.6c4.1 2.9 9 4.4 14 4.4c13.4 0 24.3-10.9 24.3-24.3V48c0-26.5-21.5-48-48-48H48C21.5 0 0 21.5 0 48z"]
}, faFanTable = {
  prefix: "fas",
  iconName: "fan-table",
  icon: [448, 512, [], "e004", "M256 413.6C355.7 398.2 432 312 432 208C432 93.1 338.9 0 224 0S16 93.1 16 208c0 104 76.3 190.2 176 205.6l0 34.4-96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0 128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0 0-34.4zM184.9 68.5L224.3 166c18.5-25.3 50-39.8 83.3-35.1c48.1 6.8 81.7 51.3 74.9 99.4c-1.2 8.8-9.3 14.8-18.1 13.6L260.2 229.2c12.6 28.7 9.5 63.2-11.2 89.7c-29.9 38.3-85.2 45.1-123.5 15.2c-7-5.4-8.2-15.5-2.8-22.5l64.8-82.9c-31.2-3.4-59.5-23.4-72.1-54.5C97.2 129.1 119 77.9 164.1 59.7c8.2-3.3 17.5 .6 20.8 8.8zM224 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]
}, faAlignJustify = {
  prefix: "fas",
  iconName: "align-justify",
  icon: [448, 512, [], "f039", "M448 64c0-17.7-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32zm0 256c0-17.7-14.3-32-32-32L32 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32zM0 192c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 160c-17.7 0-32 14.3-32 32zM448 448c0-17.7-14.3-32-32-32L32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32z"]
}, faBatteryLow = {
  prefix: "fas",
  iconName: "battery-low",
  icon: [576, 512, ["battery-1"], "e0b1", "M464 160c8.8 0 16 7.2 16 16l0 160c0 8.8-7.2 16-16 16L80 352c-8.8 0-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16l384 0zM80 96C35.8 96 0 131.8 0 176L0 336c0 44.2 35.8 80 80 80l384 0c44.2 0 80-35.8 80-80l0-16c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-16c0-44.2-35.8-80-80-80L80 96zm80 96l-64 0 0 128 64 0 0-128z"]
}, faBattery1 = faBatteryLow, faCreditCardFront = {
  prefix: "fas",
  iconName: "credit-card-front",
  icon: [576, 512, [], "f38a", "M0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM112 288c-8.8 0-16 7.2-16 16s7.2 16 16 16l352 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-352 0zM96 368c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm128 0c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16zM408 96c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-80 0z"]
}, faBrainArrowCurvedRight = {
  prefix: "fas",
  iconName: "brain-arrow-curved-right",
  icon: [640, 512, ["mind-share"], "f677", "M240 56c0-30.9-25.1-56-56-56c-28.9 0-52.7 21.9-55.7 49.9C100.6 56.9 80 82.1 80 112c0 6 .8 11.9 2.4 17.4C53.6 135.7 32 161.3 32 192c0 15 5.1 28.8 13.8 39.7C18.7 244.5 0 272.1 0 304c0 34.2 21.4 63.4 51.6 74.8C49.3 385.4 48 392.6 48 400c0 35.3 28.7 64 64 64c5.6 0 11.1-.7 16.3-2.1c2.9 28.2 26.8 50.1 55.7 50.1c30.9 0 56-25.1 56-56l0-400zm32 0l0 400c0 30.9 25.1 56 56 56c3.2 0 6.4-.3 9.5-.8C321.3 491 304 459.3 304 416c0-79.5 64.5-144 144-144l32 0 0-16c0-4.9 .8-9.8 2.2-14.3c-4.9-3.9-10.2-7.3-16-10C474.9 220.8 480 207 480 192c0-30.7-21.6-56.3-50.4-62.6c1.6-5.5 2.4-11.4 2.4-17.4c0-29.9-20.6-55.1-48.3-62.1C380.6 21.9 356.9 0 328 0c-30.9 0-56 25.1-56 56zM539.3 244.7c-4.6-4.6-11.5-5.9-17.4-3.5s-9.9 8.3-9.9 14.8l0 48-64 0c-61.9 0-112 50.1-112 112c0 54.3 34.6 85.6 45 93.8c1.9 1.5 4.3 2.2 6.7 2.2c6.8 0 12.3-5.5 12.3-12.3l0-35.7c0-35.3 28.7-64 64-64l48 0 0 48c0 6.5 3.9 12.3 9.9 14.8s12.9 1.1 17.4-3.5l96-96c6.2-6.2 6.2-16.4 0-22.6l-96-96z"]
}, faMindShare = faBrainArrowCurvedRight, faUmbrellaBeach = {
  prefix: "fas",
  iconName: "umbrella-beach",
  icon: [576, 512, [127958], "f5ca", "M346.3 271.8l-60.1-21.9L214 448 32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-261.9 0 64.1-176.2zm121.1-.2l-3.3 9.1 67.7 24.6c18.1 6.6 38-4.2 39.6-23.4c6.5-78.5-23.9-155.5-80.8-208.5c2 8 3.2 16.3 3.4 24.8l.2 6c1.8 57-7.3 113.8-26.8 167.4zM462 99.1c-1.1-34.4-22.5-64.8-54.4-77.4c-.9-.4-1.9-.7-2.8-1.1c-33-11.7-69.8-2.4-93.1 23.8l-4 4.5C272.4 88.3 245 134.2 226.8 184l-3.3 9.1L434 269.7l3.3-9.1c18.1-49.8 26.6-102.5 24.9-155.5l-.2-6zM107.2 112.9c-11.1 15.7-2.8 36.8 15.3 43.4l71 25.8 3.3-9.1c19.5-53.6 49.1-103 87.1-145.5l4-4.5c6.2-6.9 13.1-13 20.5-18.2c-79.6 2.5-154.7 42.2-201.2 108z"]
}, faHelmetUn = {
  prefix: "fas",
  iconName: "helmet-un",
  icon: [512, 512, [], "e503", "M479.5 224C471.2 98.9 367.2 0 240 0C107.5 0 0 107.5 0 240l0 56.3C0 344.8 39.2 384 87.7 384L200 384l14.9 0L343.5 505.4c4.5 4.2 10.4 6.6 16.5 6.6l96 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-86.5 0-1.5-1.5L368 288l80 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-.5 0zM320 417.2l-78-73.7L274.4 288l45.6 0 0 129.2zM285.3 103.1l34.7 52 0-43.2c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 7.1-4.6 13.3-11.4 15.3s-14-.6-17.9-6.4l-34.7-52 0 43.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4zM160 112l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16z"]
}, faLocationSmile = {
  prefix: "fas",
  iconName: "location-smile",
  icon: [384, 512, ["map-marker-smile"], "f60d", "M215.7 499.2C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192c0 87.4 117 243 168.3 307.2c12.3 15.3 35.1 15.3 47.4 0zM128 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-95.4 84.9c6.2 9.4 29.1 31.1 63.4 31.1s57.1-21.7 63.4-31.1c6.1-9.2 18.5-11.7 27.7-5.5s11.7 18.5 5.5 27.7C277.1 284.4 243.1 316 192 316s-85.1-31.6-96.6-48.9c-6.1-9.2-3.6-21.6 5.5-27.7s21.6-3.6 27.7 5.5z"]
}, faMapMarkerSmile = faLocationSmile, faArrowLeftToLine = {
  prefix: "fas",
  iconName: "arrow-left-to-line",
  icon: [448, 512, [8676, "arrow-to-left"], "f33e", "M0 96C0 78.3 14.3 64 32 64s32 14.3 32 32l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 96zM137.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L237.3 224 416 224c17.7 0 32 14.3 32 32s-14.3 32-32 32l-178.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-128-128z"]
}, faArrowToLeft = faArrowLeftToLine, faBullseye = {
  prefix: "fas",
  iconName: "bullseye",
  icon: [512, 512, [], "f140", "M448 256A192 192 0 1 0 64 256a192 192 0 1 0 384 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256 80a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faSushi = {
  prefix: "fas",
  iconName: "sushi",
  icon: [576, 512, [127843, "nigiri"], "e48a", "M479.7 320l-73.8-24.5L506.3 125.6c24.8 26.7 42.1 60.7 48.5 98.8l12.5 75.2c4 23.8-18.8 43.2-41.7 35.6l-7-2.3L479.7 320s0 0 0 0zM393.5 66.1c32.9 4.8 63.2 18 88.7 37.5L374.8 285.2 323.1 268c-14.6-4.9-29.9-7-45.2-6.4L393.5 66.1zm-36-2.1L235.6 270.4 96.1 318.7 246.6 64l110.9 0zM21.3 224.4C36.6 132.2 116.1 64.6 209.5 64L49.4 334.8C27 341.5 5 322.3 8.9 298.9l12.4-74.4zM32 384l0-15c8.5 .7 17.5-.3 26.4-3.4l193-66.9c20-6.9 41.6-7.1 61.7-.4l205.5 68.2c8.6 2.9 17.2 3.8 25.5 3.1l0 14.3c0 35.3-28.7 64-64 64c-19.1 0-36.3-8.4-48-21.7c-11.7 13.3-28.9 21.7-48 21.7s-36.3-8.4-48-21.7c-11.7 13.3-28.9 21.7-48 21.7s-36.3-8.4-48-21.7c-11.7 13.3-28.9 21.7-48 21.7s-36.3-8.4-48-21.7C132.3 439.6 115.1 448 96 448c-35.3 0-64-28.7-64-64z"]
}, faNigiri = faSushi, faMessageCaptions = {
  prefix: "fas",
  iconName: "message-captions",
  icon: [512, 512, ["comment-alt-captions"], "e1de", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM120 192c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0zm224 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0zM120 272c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0zm128 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"]
}, faCommentAltCaptions = faMessageCaptions, faTrashList = {
  prefix: "fas",
  iconName: "trash-list",
  icon: [640, 512, [], "e2b1", "M147.8 0L268.2 0c12.1 0 23.2 6.8 28.6 17.7L304 32l80 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l80 0 7.2-14.3C124.6 6.8 135.7 0 147.8 0zM32 128l352 0L362.8 467c-1.6 25.3-22.6 45-47.9 45l-213.8 0c-25.3 0-46.3-19.7-47.9-45L32 128zm448 0l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 128l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zM448 416c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32z"]
}, faBacon = {
  prefix: "fas",
  iconName: "bacon",
  icon: [576, 512, [129363], "f7e5", "M439.2 1.2c11.2-3.2 23.2-.1 31.4 8.1L518 56.7l-26.5 7.9c-58 16.6-98.1 39.6-129.6 67.4c-31.2 27.5-53.2 59.1-75.1 90.9l-2.3 3.3C241.6 288.7 195 356.6 72.8 417.7L37.9 435.2 9.4 406.6c-7.3-7.3-10.6-17.6-9-27.8s8.1-18.9 17.3-23.5C136.1 296.2 180.9 231 223.3 169.3l2.3-3.4c21.8-31.8 44.9-64.9 77.7-93.9c33.4-29.5 75.8-53.6 135.9-70.8zM61.8 459l25.4-12.7c129.5-64.7 179.9-138.1 223.8-202l2.2-3.3c22.1-32.1 42.1-60.5 69.9-85.1c27.5-24.3 63.4-45.2 117.3-60.6c0 0 0 0 0 0l.2-.1 43.1-12.9 23 23c8 8 11.2 19.7 8.3 30.7s-11.3 19.6-22.2 22.7c-51.9 14.8-85.6 34.7-111.1 57.2c-26.1 23-45.1 49.9-67.3 82.1l-2.2 3.2C327.8 365.9 275.5 442 142.3 508.6c-12.3 6.2-27.2 3.7-36.9-6L61.8 459z"]
}, faOption = {
  prefix: "fas",
  iconName: "option",
  icon: [640, 512, [], "e318", "M448 448c-9.7 0-18.9-4.4-25-12L176.6 128 32 128C14.3 128 0 113.7 0 96S14.3 64 32 64l160 0c9.7 0 18.9 4.4 25 12L463.4 384 608 384c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0zm0-320c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0z"]
}, faRaccoon = {
  prefix: "fas",
  iconName: "raccoon",
  icon: [512, 512, [], "e613", "M336 32c20.5 0 39.9 9.2 52.8 25.1l28.9 35.6-31.5-7.3c-20.2-4.7-39.7 4.2-50.2 19.9c-10.5-15.7-30.1-24.6-50.2-19.9l-31.5 7.3 28.9-35.6C296.1 41.2 315.5 32 336 32zM296.7 205.3c-5.6-3.7-11.4-7-17.5-10l39.9-21.8c6.9-3.8 12.6-9.1 16.8-15.3c4.2 6.3 9.9 11.6 16.8 15.3l39.9 21.8c-6 2.9-11.9 6.2-17.5 10L360 215.4c-.3-13-10.9-23.4-24-23.4s-23.7 10.4-24 23.4l-15.3-10.2zm187.5-81.4l-20.3-25 13.8-41.5c1.5-4.4 2.2-9.1 2.2-13.8C480 19.5 460.5 0 436.5 0l-1.3 0c-3.3 0-6.5 .4-9.7 1.1l-44.1 9.8C367.5 3.8 352 0 336 0s-31.5 3.8-45.3 10.9L246.6 1.1c-3.2-.7-6.5-1.1-9.7-1.1l-1.3 0C211.5 0 192 19.5 192 43.5c0 4.7 .8 9.3 2.2 13.8l13.8 41.5-20.3 25c-7.6 9.3-11.7 21-11.7 33c0 23.1 15.2 43.5 37.3 50.2l35.8 10.7c10.6 3.2 20.6 7.9 29.8 14l18.8 12.6C309.1 252 322.4 256 336 256s26.9-4 38.2-11.6L393 231.9c9.2-6.1 19.2-10.9 29.8-14l35.8-10.7c22.2-6.6 37.3-27 37.3-50.2c0-12-4.1-23.7-11.7-33zM288 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM185.1 229.3C131.2 266.9 96 329.4 96 400c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-16.4 1.7-32.5 4.8-48L0 352l0 48c0 61.9 50.1 112 112 112l128 0 80 0 0-16c0-26.5-21.5-48-48-48l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0c44.2 0 80 35.8 80 80l0 16 24 0c0 0 0 0 .1 0l39.9 0 64 0 0-16.4c-.2-26.3-21.6-47.6-48-47.6l-16 0s0 0 0 0l0-72-6.4 4.8c-7.1 5.3-17.1 3.9-22.4-3.2s-3.9-17.1 3.2-22.4l38.1-28.5c12.3-9.2 19.5-23.7 19.5-39.1c0-14.9-6.8-29-18.5-38.3c-6.6 2.2-12.9 5.3-18.7 9.2l-18.8 12.6c-16.6 11-36 16.9-55.9 16.9s-39.4-5.9-55.9-16.9l-18.8-12.6c-6.6-4.4-13.7-7.7-21.3-10l-35.8-10.7c-6.8-2-13.2-4.9-19.1-8.4zM0 128l128 0 0-32c0-35.3-28.7-64-64-64S0 60.7 0 96l0 32zm0 32l0 64 128 0 0-64L0 160zM0 320l77.7 0c8.2-23.2 19.8-44.7 34.3-64L0 256l0 64zm480-24l-.3-.9c0 .4-.1 .9-.1 1.3l.5-.4zM317.7 376.2c-4.5 7.6-14.4 10-22 5.5l-80-48c-7.6-4.5-10-14.4-5.5-22s14.4-10 22-5.5l80 48c7.6 4.5 10 14.4 5.5 21.9z"]
}, faHandPointDown = {
  prefix: "fas",
  iconName: "hand-point-down",
  icon: [384, 512, [], "f0a7", "M32 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-208-64 0 0 208zM224 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64zm-64 64c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32zm160-96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64zm-96-88l0 .6c9.4-5.4 20.3-8.6 32-8.6c13.2 0 25.4 4 35.6 10.8c8.7-24.9 32.5-42.8 60.4-42.8c11.7 0 22.6 3.1 32 8.6l0-8.6C384 71.6 312.4 0 224 0L162.3 0C119.8 0 79.1 16.9 49.1 46.9L37.5 58.5C13.5 82.5 0 115.1 0 149l0 27c0 35.3 28.7 64 64 64l88 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-56 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0c39.8 0 72 32.2 72 72z"]
}, faArrowUpFromBracket = {
  prefix: "fas",
  iconName: "arrow-up-from-bracket",
  icon: [448, 512, [], "e09a", "M246.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 109.3 192 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.7 73.4 73.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-128-128zM64 352c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-64z"]
}, faHeadSideGear = {
  prefix: "fas",
  iconName: "head-side-gear",
  icon: [512, 512, [], "e611", "M0 224.2C0 100.6 100.2 0 224 0l24 0c95.2 0 181.2 69.3 197.3 160.2c2.3 13 6.8 25.7 15.1 36l42 52.6c6.2 7.8 9.6 17.4 9.6 27.4c0 24.2-19.6 43.8-43.8 43.8L448 320l0 64c0 35.3-28.7 64-64 64l-64 0 0 32c0 17.7-14.3 32-32 32L96 512c-17.7 0-32-14.3-32-32l0-72.7c0-16.7-6.9-32.5-17.1-45.8C16.6 322.4 0 274.1 0 224.2zm336.6-28.3c6.3-3.6 9.5-11.1 6.8-18c-2.1-5.5-4.6-10.8-7.4-15.9l-2.3-4c-3.1-5.1-6.5-9.9-10.2-14.5c-4.6-5.7-12.7-6.7-19-3l-2.9 1.7c-9.2 5.3-20.4 4-29.6-1.3s-16.1-14.5-16.1-25.1l0-3.4c0-7.3-4.9-13.8-12.1-14.9c-6.5-1-13.1-1.5-19.9-1.5s-13.4 .5-19.9 1.5c-7.2 1.1-12.1 7.6-12.1 14.9l0 3.4c0 10.6-6.9 19.8-16.1 25.1s-20.4 6.6-29.6 1.3l-2.9-1.7c-6.3-3.6-14.4-2.6-19 3c-3.7 4.6-7.1 9.5-10.2 14.6l-2.3 3.9c-2.8 5.1-5.3 10.4-7.4 15.9c-2.6 6.8 .5 14.3 6.8 18l2.9 1.7c9.2 5.3 13.7 15.8 13.7 26.4s-4.5 21.1-13.7 26.4l-3 1.7c-6.3 3.6-9.5 11.1-6.8 18c2.1 5.5 4.6 10.7 7.4 15.8l2.4 4.1c3.1 5.1 6.4 9.9 10.1 14.5c4.6 5.7 12.7 6.7 19 3l2.9-1.7c9.2-5.3 20.4-4 29.6 1.3s16.1 14.5 16.1 25.1l0 3.4c0 7.3 4.9 13.8 12.1 14.9c6.5 1 13.1 1.5 19.9 1.5s13.4-.5 19.9-1.5c7.2-1.1 12.1-7.6 12.1-14.9l0-3.4c0-10.6 6.9-19.8 16.1-25.1s20.4-6.6 29.6-1.3l2.9 1.7c6.3 3.6 14.4 2.6 19-3c3.7-4.6 7.1-9.4 10.1-14.5l2.4-4.2c2.8-5.1 5.3-10.3 7.4-15.8c2.6-6.8-.5-14.3-6.8-18l-3-1.7c-9.2-5.3-13.7-15.8-13.7-26.4s4.5-21.1 13.7-26.4l3-1.7zM184 224a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"]
}, faTrashPlus = {
  prefix: "fas",
  iconName: "trash-plus",
  icon: [448, 512, [], "e2b2", "M163.8 0L284.2 0c12.1 0 23.2 6.8 28.6 17.7L320 32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 7.2-14.3C140.6 6.8 151.7 0 163.8 0zM32 128l384 0L394.8 467c-1.6 25.3-22.6 45-47.9 45l-245.8 0c-25.3 0-46.3-19.7-47.9-45L32 128zM200 408c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 64z"]
}, faFileCad = {
  prefix: "fas",
  iconName: "file-cad",
  icon: [512, 512, [], "e672", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-208 0c-35.3 0-64 28.7-64 64l0 144-48 0c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zM200 352l16 0c22.1 0 40 17.9 40 40l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-4.4-3.6-8-8-8l-16 0c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-8c0-8.8 7.2-16 16-16s16 7.2 16 16l0 8c0 22.1-17.9 40-40 40l-16 0c-22.1 0-40-17.9-40-40l0-80c0-22.1 17.9-40 40-40zm232 0l32 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-32 0c-8.8 0-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16zm16 32l0 96 16 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-16 0zm-160 8c0-22.1 17.9-40 40-40l16 0c22.1 0 40 17.9 40 40l0 56 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48 0-56zm32 40l32 0 0-40c0-4.4-3.6-8-8-8l-16 0c-4.4 0-8 3.6-8 8l0 40z"]
}, faObjectsAlignTop = {
  prefix: "fas",
  iconName: "objects-align-top",
  icon: [512, 512, [], "e3c0", "M24 0L488 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 48C10.7 48 0 37.3 0 24S10.7 0 24 0zM64 176c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 288c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-288zm224 0c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-160z"]
}, faFolder = {
  prefix: "fas",
  iconName: "folder",
  icon: [512, 512, [128193, 128447, 61716, "folder-blank"], "f07b", "M64 480H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H288c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64z"]
}, faFolderBlank = faFolder, faFaceAnxiousSweat = {
  prefix: "fas",
  iconName: "face-anxious-sweat",
  icon: [576, 512, [], "e36a", "M288 512c141.4 0 256-114.6 256-256S429.4 0 288 0S32 114.6 32 256c0 1.1 0 2.2 0 3.3c16.3-7.1 36.4-2.8 48 12.8c7 9.2 18.1 24.6 27.7 40.7c4.8 8.1 9.6 17 13.2 25.7c3.4 8 7.1 19 7.1 30.5c0 24.5-11.1 46-28.4 60.3C146.4 480.2 213.5 512 288 512zM79.5 404.5C89.6 395.9 96 383.2 96 369c0-20-28.4-60.4-41.6-77.7c-3.2-4.4-9.6-4.4-12.8 0c-1.7 2.3-3.8 5-5.9 8.1C21.4 319.1 0 351.7 0 369c0 26 21.5 47 48 47c12 0 23-4.3 31.5-11.5zM208 400c0-44.2 35.8-80 80-80s80 35.8 80 80c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16zM367.6 240a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-128 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM227.3 171.3l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2s4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zm121.4-22.6c6.2-6.2 16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4c-6.2-6.2-6.2-16.4 0-22.6z"]
}, faCreditCardBlank = {
  prefix: "fas",
  iconName: "credit-card-blank",
  icon: [576, 512, [], "f389", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM96 368c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16zm128 0c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16z"]
}, faFileWaveform = {
  prefix: "fas",
  iconName: "file-waveform",
  icon: [448, 512, ["file-medical-alt"], "f478", "M96 0C60.7 0 32 28.7 32 64l0 224 112 0c6.1 0 11.6 3.4 14.3 8.8L176 332.2l49.7-99.4c2.7-5.4 8.3-8.8 14.3-8.8s11.6 3.4 14.3 8.8L281.9 288l70.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0c-6.1 0-11.6-3.4-14.3-8.8L240 275.8l-49.7 99.4c-2.7 5.4-8.3 8.8-14.3 8.8s-11.6-3.4-14.3-8.8L134.1 320 32 320l0 128c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L256 0 96 0zM288 0l0 128 128 0L288 0z"]
}, faFileMedicalAlt = faFileWaveform, faMicrochipAi = {
  prefix: "fas",
  iconName: "microchip-ai",
  icon: [512, 512, [], "e1ec", "M176 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c-35.3 0-64 28.7-64 64l-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 56-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 56-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0c0 35.3 28.7 64 64 64l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 56 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 56 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40c35.3 0 64-28.7 64-64l40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-56 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-56 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0c0-35.3-28.7-64-64-64l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-56 0 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-56 0 0-40zm32 152c6.4 0 12.1 3.8 14.7 9.6l42 96 14 32c3.5 8.1-.1 17.5-8.2 21.1s-17.5-.2-21.1-8.2L239.5 304l-63.1 0-9.8 22.4c-3.5 8.1-13 11.8-21.1 8.2s-11.8-13-8.2-21.1l14-32 42-96c2.5-5.8 8.3-9.6 14.7-9.6zm17.5 96L208 231.9 190.5 272l35.1 0zM336 176c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16z"]
}, faMug = {
  prefix: "fas",
  iconName: "mug",
  icon: [576, 512, [], "f874", "M64 64C46.3 64 32 78.3 32 96l0 256c0 53 43 96 96 96l192 0c53 0 96-43 96-96l0-32 32 0c70.7 0 128-57.3 128-128s-57.3-128-128-128l-64 0L64 64zm352 64l32 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-32 0 0-128z"]
}, faPlaneUpSlash = {
  prefix: "fas",
  iconName: "plane-up-slash",
  icon: [640, 512, [], "e22e", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L482.4 352.8 554.9 377c10.4 3.5 21.1-4.3 21.1-15.2l0-56.7c0-10.7-5.3-20.7-14.2-26.6L384 160l0-66.3C384 59.5 356 0 320 0c-35 0-64 59.5-64 93.7l0 66.3-10.6 7.1L38.8 5.1zm122.5 218L78.2 278.5C69.3 284.4 64 294.4 64 305.1l0 56.7c0 10.9 10.7 18.6 21.1 15.2L256 320l0 80-57.6 43.2c-4 3-6.4 7.8-6.4 12.8l0 42c0 7.8 6.3 14 14 14c1.3 0 2.6-.2 3.9-.5L320 480l110.1 31.5c1.3 .4 2.6 .5 3.9 .5c7.8 0 14-6.3 14-14l0-42.7c0-2.8-.7-5.6-2.1-8L161.3 223.1z"]
}, faRadiation = {
  prefix: "fas",
  iconName: "radiation",
  icon: [512, 512, [], "f7b9", "M216 186.7c-23.9 13.8-40 39.7-40 69.3L32 256C14.3 256-.2 241.6 2 224.1C10.7 154 47.8 92.7 101.3 52c14.1-10.7 33.8-5.3 42.7 10l72 124.7zM256 336c14.6 0 28.2-3.9 40-10.7l72 124.8c8.8 15.3 3.7 35.1-12.6 41.9c-30.6 12.9-64.2 20-99.4 20s-68.9-7.1-99.4-20c-16.3-6.9-21.4-26.6-12.6-41.9l72-124.8c11.8 6.8 25.4 10.7 40 10.7zm224-80l-144 0c0-29.6-16.1-55.5-40-69.3L368 62c8.8-15.3 28.6-20.7 42.7-10c53.6 40.7 90.6 102 99.4 172.1c2.2 17.5-12.4 31.9-30 31.9zM256 208a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]
}, faPenCircle = {
  prefix: "fas",
  iconName: "pen-circle",
  icon: [512, 512, [], "e20e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM357.8 139.7l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6l-21.4 21.4-71-71 21.4-21.4c15.6-15.6 40.9-15.6 56.6 0zM151.9 289L257.1 183.8l71 71L222.9 359.9c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9z"]
}, faBagSeedling = {
  prefix: "fas",
  iconName: "bag-seedling",
  icon: [512, 512, [], "e5f2", "M64 64L38.6 38.6c-4.2-4.2-6.6-10-6.6-16C32 10.1 42.1 0 54.6 0L457.4 0C469.9 0 480 10.1 480 22.6c0 6-2.4 11.8-6.6 16L448 64 64 64zM56 96l400 0 10.6 42.5c8.9 35.5 13.4 72 13.4 108.7l0 17.7c0 36.6-4.5 73.1-13.4 108.7L456 416 56 416 45.4 373.5C36.5 338 32 301.5 32 264.8l0-17.7c0-36.6 4.5-73.1 13.4-108.7L56 96zm8 352l384 0 25.4 25.4c4.2 4.2 6.6 10 6.6 16c0 12.5-10.1 22.6-22.6 22.6L54.6 512C42.1 512 32 501.9 32 489.4c0-6 2.4-11.8 6.6-16L64 448zm80-288c-8.8 0-16 7.2-16 16c0 59.2 45.9 107.6 104 111.7l0 40.3c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40.3c58.1-4.1 104-52.6 104-111.7c0-8.8-7.2-16-16-16l-2 0c-47.3 0-88.4 26-110 64.5C234.4 186 193.3 160 146 160l-2 0z"]
}, faChartSimple = {
  prefix: "fas",
  iconName: "chart-simple",
  icon: [448, 512, [], "e473", "M160 80c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 352c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-352zM0 272c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48L0 272zM368 96l32 0c26.5 0 48 21.5 48 48l0 288c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-288c0-26.5 21.5-48 48-48z"]
}, faCrutches = {
  prefix: "fas",
  iconName: "crutches",
  icon: [640, 512, [], "f7f8", "M470.6 9.4l160 160c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-160-160c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0zM294.6 188.2L404.1 78.6l45.3 45.3L397.3 176 464 242.7l52.1-52.1 45.3 45.3-74.6 74.6-.1 .1-.1 .1-34.7 34.7c-12.9 12.9-29.2 21.9-47.1 25.8L297.1 395.2c-5.9 1.3-11.4 4.3-15.7 8.6l-98.8 98.8c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l98.8-98.8c4.3-4.3 7.3-9.7 8.6-15.7l23.9-107.6c4-17.8 12.9-34.1 25.8-47.1zm45.3 45.3c-4.3 4.3-7.3 9.7-8.6 15.7l-17 76.7 76.7-17c5.9-1.3 11.4-4.3 15.7-8.6L418.7 288 352 221.3l-12.2 12.2zM169.4 9.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L213.3 56l84.1 84.1-25.4 25.4c-6.7 6.7-12.6 14.1-17.6 22L168 101.3 101.3 168 223.7 290.4l-10.1 45.5-17 17c-2.9-2.3-5.7-4.8-8.4-7.5L56 213.3l-1.4 1.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l160-160zM411.7 402.5c9.3-2.1 18.3-5.2 26.9-9.2l64.1 64.1c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-90.2-90.2 44.5-9.9z"]
}, faCircleParking = {
  prefix: "fas",
  iconName: "circle-parking",
  icon: [512, 512, ["parking-circle"], "f615", "M448 256A192 192 0 1 0 64 256a192 192 0 1 0 384 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm232 0l48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-48 0 0 64zm48 64l-48 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64 0-120c0-22.1 17.9-40 40-40l72 0c53 0 96 43 96 96s-43 96-96 96z"]
}, faParkingCircle = faCircleParking, faMarsStroke = {
  prefix: "fas",
  iconName: "mars-stroke",
  icon: [512, 512, [9894], "f229", "M376 0c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l33.4 33.4L370.3 96.4 345 71c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l25.4 25.4L307.8 159c-28.4-19.5-62.7-31-99.8-31c-97.2 0-176 78.8-176 176s78.8 176 176 176s176-78.8 176-176c0-37-11.4-71.4-31-99.8l28.6-28.6L407 201c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-25.4-25.4 22.1-22.1L471 153c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-112c0-13.3-10.7-24-24-24L376 0zm88 48s0 0 0 0s0 0 0 0s0 0 0 0zM96 304a112 112 0 1 1 224 0A112 112 0 1 1 96 304z"]
}, faLeafOak = {
  prefix: "fas",
  iconName: "leaf-oak",
  icon: [512, 512, [], "f6f7", "M429.7 268.6l40.9-10.2c24.4-6.1 41.4-28 41.4-53.1c0-18.3-9.1-35.4-24.4-45.5l-14.3-9.5c-5.6-3.8-8.3-10.6-6.6-17.2l5-20.1c5.1-20.4-.9-42-15.8-56.9s-36.5-20.9-56.9-15.8l-20.1 5c-6.6 1.6-13.4-1-17.2-6.6l-9.5-14.3C342.1 9.1 325 0 306.7 0c-25.1 0-47 17.1-53.1 41.4L243.4 82.3c-1.5 6-9 8.1-13.4 3.7L208 64c-17.7-17.7-46.3-17.7-64 0c-10.1 10.1-14.8 24.3-12.8 38.4l10.7 75.1c.8 5.6-5.4 9.5-10.1 6.4C111 170 83.3 172.7 65.6 190.4l-3.6 3.6c-17.9 17.9-22.3 45.2-11 67.8L66.5 293C75.4 310.7 80 330.3 80 350.2l0 35.2L229.6 235.8c6.2-6.2 16.4-6.2 22.6 0c5.4 5.4 6.1 13.6 2.2 19.8L39 471c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l73-73 15.8 0c19.9 0 39.5 4.6 57.2 13.5l31.1 15.5c22.6 11.3 49.9 6.9 67.8-11l3.6-3.6c17.7-17.7 20.4-45.4 6.6-66.2c-3.1-4.7 .8-10.9 6.4-10.1l75.1 10.7c14.1 2 28.3-2.7 38.4-12.8c17.7-17.7 17.7-46.3 0-64l-22-22c-4.4-4.4-2.3-11.9 3.7-13.4z"]
}, faSquareBolt = {
  prefix: "fas",
  iconName: "square-bolt",
  icon: [448, 512, [], "e265", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm234.1 83.6c5.8 4.7 7.6 12.9 4.3 19.6L249.9 240l70.1 0c6.8 0 12.9 4.3 15.1 10.7s.2 13.5-5.1 17.8l-160 128c-5.9 4.7-14.2 4.7-20.1-.1s-7.6-12.9-4.3-19.6L198.1 272 128 272c-6.8 0-12.8-4.3-15.1-10.7s-.2-13.5 5.1-17.8l160-128c5.9-4.7 14.2-4.7 20.1 .1z"]
}, faVial = {
  prefix: "fas",
  iconName: "vial",
  icon: [512, 512, [129514], "f492", "M342.6 9.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l9.4 9.4L28.1 342.6C10.1 360.6 0 385 0 410.5L0 416c0 53 43 96 96 96l5.5 0c25.5 0 49.9-10.1 67.9-28.1L448 205.3l9.4 9.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-32-32-96-96-32-32zM205.3 256L352 109.3 402.7 160l-96 96-101.5 0z"]
}, faGauge = {
  prefix: "fas",
  iconName: "gauge",
  icon: [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-26.9-16.5-49.9-40-59.3L280 88c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 204.7c-23.5 9.5-40 32.5-40 59.3c0 35.3 28.7 64 64 64s64-28.7 64-64zM144 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-16 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faDashboard = faGauge, faGaugeMed = faGauge, faTachometerAltAverage = faGauge, faWandMagicSparkles = {
  prefix: "fas",
  iconName: "wand-magic-sparkles",
  icon: [576, 512, ["magic-wand-sparkles"], "e2ca", "M234.7 42.7L197 56.8c-3 1.1-5 4-5 7.2s2 6.1 5 7.2l37.7 14.1L248.8 123c1.1 3 4 5 7.2 5s6.1-2 7.2-5l14.1-37.7L315 71.2c3-1.1 5-4 5-7.2s-2-6.1-5-7.2L277.3 42.7 263.2 5c-1.1-3-4-5-7.2-5s-6.1 2-7.2 5L234.7 42.7zM46.1 395.4c-18.7 18.7-18.7 49.1 0 67.9l34.6 34.6c18.7 18.7 49.1 18.7 67.9 0L529.9 116.5c18.7-18.7 18.7-49.1 0-67.9L495.3 14.1c-18.7-18.7-49.1-18.7-67.9 0L46.1 395.4zM484.6 82.6l-105 105-23.3-23.3 105-105 23.3 23.3zM7.5 117.2C3 118.9 0 123.2 0 128s3 9.1 7.5 10.8L64 160l21.2 56.5c1.7 4.5 6 7.5 10.8 7.5s9.1-3 10.8-7.5L128 160l56.5-21.2c4.5-1.7 7.5-6 7.5-10.8s-3-9.1-7.5-10.8L128 96 106.8 39.5C105.1 35 100.8 32 96 32s-9.1 3-10.8 7.5L64 96 7.5 117.2zm352 256c-4.5 1.7-7.5 6-7.5 10.8s3 9.1 7.5 10.8L416 416l21.2 56.5c1.7 4.5 6 7.5 10.8 7.5s9.1-3 10.8-7.5L480 416l56.5-21.2c4.5-1.7 7.5-6 7.5-10.8s-3-9.1-7.5-10.8L480 352l-21.2-56.5c-1.7-4.5-6-7.5-10.8-7.5s-9.1 3-10.8 7.5L416 352l-56.5 21.2z"]
}, faMagicWandSparkles = faWandMagicSparkles, faLambda = {
  prefix: "fas",
  iconName: "lambda",
  icon: [448, 512, [], "f66e", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l108.2 0 16.4 32.7L18.8 434.9c-7.3 16.1-.1 35.1 16 42.3s35.1 .1 42.3-16L193.5 202.6l121 242c10.8 21.7 33 35.4 57.2 35.4l44.2 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-44.2 0L197.5 67.4C186.6 45.7 164.5 32 140.2 32L32 32z"]
}, faE = {
  prefix: "fas",
  iconName: "e",
  icon: [320, 512, [101], "45", "M64 32C28.7 32 0 60.7 0 96L0 256 0 416c0 35.3 28.7 64 64 64l224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 416l0-128 160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 224 64 96l224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 32z"]
}, faPizza = {
  prefix: "fas",
  iconName: "pizza",
  icon: [576, 512, [127829], "f817", "M385.2 419c10.4-8.2 25.5-8.4 34.9 1s9.4 24.7-.8 33.1C375 489.9 318.1 512 256 512C114.6 512 0 397.4 0 256S114.6 0 256 0c62.1 0 119 22.1 163.3 58.8c10.2 8.5 10.1 23.8 .8 33.1s-24.5 9.2-34.9 1C349.7 64.8 304.8 48 256 48C141.1 48 48 141.1 48 256s93.1 208 208 208c48.8 0 93.7-16.8 129.2-45zm-16-49.9c6.2 6.2 6.3 16.5-.5 22.1c-69.1 57.7-172.2 54.1-237.1-10.8c-68.7-68.7-68.7-180.2 0-248.9C196.5 66.6 299.5 63 368.6 120.8c6.8 5.7 6.7 15.9 .5 22.1L267.3 244.7c-6.2 6.2-6.2 16.4 0 22.6L369.1 369.1zM192 264a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm24-88a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm72 200a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM443.4 156.6c6.7-6.7 17.7-6.2 23 1.7c39.5 59 39.5 136.5 0 195.5c-5.2 7.8-16.3 8.3-23 1.7l-88.1-88.1c-6.2-6.2-6.2-16.4 0-22.6l24.2-24.2c3.6 2.2 7.9 3.5 12.5 3.5c13.3 0 24-10.7 24-24c0-4.6-1.3-8.9-3.5-12.5l30.9-30.9zM472 280a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm22.4 126.4c-8.9-8.9-9.4-23.1-2.3-33.5C514.8 339.6 528 299.3 528 256s-13.2-83.6-35.9-116.9c-7.1-10.4-6.6-24.6 2.3-33.5c9.9-9.9 26.2-9.4 34.3 2C558.5 149.5 576 200.7 576 256s-17.5 106.5-47.4 148.4c-8.1 11.4-24.4 11.9-34.3 2z"]
}, faBowlChopsticksNoodles = {
  prefix: "fas",
  iconName: "bowl-chopsticks-noodles",
  icon: [512, 512, [], "e2ea", "M13.1 93.6L128 72l0-16c0-13.3 10.7-24 24-24s24 10.7 24 24l0 7 0 37.5 0 38 0 37.5 0 48s0 0 0 0l32 0s0 0 0 0l0-48 0-38.5 0-42L208 57l0-17c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8 0 40 0 48 0 40 0 48s0 0 0 0l32 0s0 0 0 0l190.4 0c18.2 0 32.7 15.3 31.6 33.5c-5.4 91.7-59.7 169.7-136.4 209.7l-1.2 9.7c-2.5 20-19.5 35-39.7 35l-153.4 0c-20.2 0-37.2-15-39.7-35l-1.2-9.7C61.6 427.2 7.4 349.3 2 257.5C.9 239.3 15.4 224 33.6 224l94.4 0 0-48L16.2 176C7.3 176 0 168.7 0 159.7c0-8.8 7-16 15.7-16.2L128 140l0-32L18.5 125.1C8.8 126.6 0 119.1 0 109.3C0 101.6 5.5 95 13.1 93.6zM488.4 176L288 176l0-41 199.6-6.2C501 128.3 512 139 512 152.4c0 13-10.6 23.6-23.6 23.6zm3.9-124.9L288 83l0-41L484.4 5.2C498.7 2.5 512 13.5 512 28.1c0 11.5-8.4 21.2-19.7 23z"]
}, faH3 = {
  prefix: "fas",
  iconName: "h3",
  icon: [640, 512, [], "f315", "M64 96c0-17.7-14.3-32-32-32S0 78.3 0 96L0 256 0 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 192 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128L64 224 64 96zM400 64c-17.7 0-32 14.3-32 32s14.3 32 32 32l114.7 0-89.4 89.4c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l72 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-64.6 0c-11.7 0-21.7-8.5-23.7-20.1l-.2-1.2c-2.9-17.4-19.4-29.2-36.8-26.3s-29.2 19.4-26.3 36.8l.2 1.2c7.1 42.4 43.8 73.5 86.8 73.5l64.6 0c66.3 0 120-53.7 120-120c0-64.6-51-117.2-114.9-119.9l89.5-89.5c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8L400 64z"]
}, faPenClip = {
  prefix: "fas",
  iconName: "pen-clip",
  icon: [512, 512, ["pen-alt"], "f305", "M453.3 19.3l39.4 39.4c25 25 25 65.5 0 90.5l-52.1 52.1s0 0 0 0l-1-1s0 0 0 0l-16-16-96-96-17-17 52.1-52.1c25-25 65.5-25 90.5 0zM241 114.9c-9.4-9.4-24.6-9.4-33.9 0L105 217c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L173.1 81c28.1-28.1 73.7-28.1 101.8 0L288 94.1l17 17 96 96 16 16 1 1-17 17L229.5 412.5c-48 48-109.2 80.8-175.8 94.1l-25 5c-7.9 1.6-16-.9-21.7-6.6s-8.1-13.8-6.6-21.7l5-25c13.3-66.6 46.1-127.8 94.1-175.8L254.1 128 241 114.9z"]
}, faPenAlt = faPenClip, faBridgeCircleExclamation = {
  prefix: "fas",
  iconName: "bridge-circle-exclamation",
  icon: [640, 512, [], "e4ca", "M64 32C46.3 32 32 46.3 32 64s14.3 32 32 32l40 0 0 64-72 0 0 128c53 0 96 43 96 96l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96c6.3 0 12.4 .6 18.3 1.7C367.1 231.8 426.9 192 496 192c42.5 0 81.6 15.1 112 40.2l0-72.2-72 0 0-64 40 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 32zM488 96l0 64-80 0 0-64 80 0zM360 96l0 64-80 0 0-64 80 0zM232 96l0 64-80 0 0-64 80 0zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0-144c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]
}, faBadgePercent = {
  prefix: "fas",
  iconName: "badge-percent",
  icon: [512, 512, [], "f646", "M256 0c36.8 0 68.8 20.7 84.9 51.1C373.8 41 411 49 437 75s34 63.3 23.9 96.1C491.3 187.2 512 219.2 512 256s-20.7 68.8-51.1 84.9C471 373.8 463 411 437 437s-63.3 34-96.1 23.9C324.8 491.3 292.8 512 256 512s-68.8-20.7-84.9-51.1C138.2 471 101 463 75 437s-34-63.3-23.9-96.1C20.7 324.8 0 292.8 0 256s20.7-68.8 51.1-84.9C41 138.2 49 101 75 75s63.3-34 96.1-23.9C187.2 20.7 219.2 0 256 0zM192 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM337 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L175 303c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L337 209z"]
}, faRotateReverse = {
  prefix: "fas",
  iconName: "rotate-reverse",
  icon: [512, 512, [], "e631", "M368.9 142.9c17.5 17.5 30.1 38 37.8 59.8c5.9 16.7 24.2 25.4 40.8 19.5s25.4-24.2 19.5-40.8c-10.8-30.6-28.4-59.3-52.9-83.7C327 10.5 185.9 10.1 98.3 96.6L56.7 55c-6.9-6.9-17.2-8.9-26.2-5.2s-14.8 12.5-14.8 22.2l0 128c0 13.3 10.7 24 24 24l8.4 0c0 0 0 0 0 0l119.5 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-41.1-41.1c62.6-61.5 163.1-61.2 225.3 1zM495.8 312c0-13.3-10.7-24-24-24l-7.6 0-.7 0-119.6 0c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l41.1 41.1c-62.6 61.5-163.1 61.2-225.3-1c-17.5-17.5-30.1-38-37.8-59.8c-5.9-16.7-24.2-25.4-40.8-19.5s-25.4 24.2-19.5 40.8C55.3 361.3 73 390 97.4 414.4c87.2 87.2 228.3 87.5 315.8 1L454.8 457c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-119.6 0-.7 0-7.6z"]
}, faUser = {
  prefix: "fas",
  iconName: "user",
  icon: [448, 512, [128100, 62144], "f007", "M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512l388.6 0c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304l-91.4 0z"]
}, faSensor = {
  prefix: "fas",
  iconName: "sensor",
  icon: [448, 512, [], "e028", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm48 88l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24zm96 0l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faComma = {
  prefix: "fas",
  iconName: "comma",
  icon: [192, 512, [], "2c", "M160 350.4V349c0-33.7-27.3-61-61-61c-29.5 0-54.8 21.1-60.1 50.1l-22.2 122c-.5 2.6-.7 5.2-.7 7.9v8.2C16 495.9 32.1 512 51.9 512c12.5 0 24.1-6.5 30.6-17.2L150.8 383c6-9.8 9.2-21.1 9.2-32.6z"]
}, faSchoolCircleCheck = {
  prefix: "fas",
  iconName: "school-circle-check",
  icon: [640, 512, [], "e56b", "M337.8 5.4C327-1.8 313-1.8 302.2 5.4L166.3 96 48 96C21.5 96 0 117.5 0 144L0 464c0 26.5 21.5 48 48 48l272 0s0 0 0 0l-64 0 0-96c0-35.3 28.7-64 64-64l.3 0 .5 0c3.4-37.7 18.7-72.1 42.2-99.1C350.2 260 335.6 264 320 264c-48.6 0-88-39.4-88-88s39.4-88 88-88s88 39.4 88 88c0 18.3-5.6 35.3-15.1 49.4c29-21 64.6-33.4 103.1-33.4c59.5 0 112.1 29.6 144 74.8L640 144c0-26.5-21.5-48-48-48L473.7 96 337.8 5.4zM96 192l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zm0 128l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zM320 128c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-99.3-43.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7z"]
}, faToiletPaperUnder = {
  prefix: "fas",
  iconName: "toilet-paper-under",
  icon: [512, 512, ["toilet-paper-reverse"], "e2a0", "M96 0L348.2 0C336.6 12.2 327 26.9 319.5 41.9C299.5 82 288 135.1 288 192s11.5 110 31.5 150.1c7.5 15 17.1 29.7 28.7 41.9L96 384C43 384 0 298 0 192S43 0 96 0zM320 192c0-83.6 26.7-154.7 64-181.1C394 3.8 404.8 0 416 0c53 0 96 86 96 192c0 35-4.7 67.8-12.8 96c-16.6 57.4-47.6 96-83.2 96c-11.2 0-22-3.8-32-10.9c-37.3-26.4-64-97.5-64-181.1zm64 0c0 35.3 14.3 64 32 64s32-28.7 32-64s-14.3-64-32-64s-32 28.7-32 64zM160 416l256 0c44.8 0 76.9-35.2 96-72.9L512 464c0 26.5-21.5 48-48 48l-256 0c-26.5 0-48-21.5-48-48l0-48zM64 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm64 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]
}, faToiletPaperReverse = faToiletPaperUnder, faLightEmergency = {
  prefix: "fas",
  iconName: "light-emergency",
  icon: [448, 512, [], "e41f", "M64 192c0-88.4 71.6-160 160-160s160 71.6 160 160l0 160L64 352l0-160zm160-80c8.8 0 16-7.2 16-16s-7.2-16-16-16c-61.9 0-112 50.1-112 112c0 8.8 7.2 16 16 16s16-7.2 16-16c0-44.2 35.8-80 80-80zM32 384l384 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32z"]
}, faArrowDownToArc = {
  prefix: "fas",
  iconName: "arrow-down-to-arc",
  icon: [512, 512, [], "e4ae", "M256 448c106 0 192-86 192-192c0-17.7 14.3-32 32-32s32 14.3 32 32c0 141.4-114.6 256-256 256S0 397.4 0 256c0-17.7 14.3-32 32-32s32 14.3 32 32c0 106 86 192 192 192zM390.6 230.6l-112 112c-12.5 12.5-32.8 12.5-45.3 0l-112-112c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L224 242.7 224 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 210.7 57.4-57.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3z"]
}, faDumpster = {
  prefix: "fas",
  iconName: "dumpster",
  icon: [576, 512, [], "f793", "M49.7 32c-10.5 0-19.8 6.9-22.9 16.9L.9 133c-.6 2-.9 4.1-.9 6.1C0 150.7 9.3 160 20.9 160l94 0L140.5 32 49.7 32zM272 160l0-128-98.9 0L147.5 160 272 160zm32 0l124.5 0L402.9 32 304 32l0 128zm157.1 0l94 0c11.5 0 20.9-9.3 20.9-20.9c0-2.1-.3-4.1-.9-6.1L549.2 48.9C546.1 38.9 536.8 32 526.3 32l-90.8 0 25.6 128zM32 192l4 32-4 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l12 0L64 448c0 17.7 14.3 32 32 32s32-14.3 32-32l320 0c0 17.7 14.3 32 32 32s32-14.3 32-32l20-160 12 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-4 0 4-32L32 192z"]
}, faVanShuttle = {
  prefix: "fas",
  iconName: "van-shuttle",
  icon: [640, 512, [128656, "shuttle-van"], "f5b6", "M64 104l0 88 96 0 0-96L72 96c-4.4 0-8 3.6-8 8zm482 88L465.1 96 384 96l0 96 162 0zm-226 0l0-96-96 0 0 96 96 0zM592 384l-16 0c0 53-43 96-96 96s-96-43-96-96l-128 0c0 53-43 96-96 96s-96-43-96-96l-16 0c-26.5 0-48-21.5-48-48L0 104C0 64.2 32.2 32 72 32l120 0 160 0 113.1 0c18.9 0 36.8 8.3 49 22.8L625 186.5c9.7 11.5 15 26.1 15 41.2L640 336c0 26.5-21.5 48-48 48zm-64 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM160 432a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]
}, faShuttleVan = faVanShuttle, faBuildingUser = {
  prefix: "fas",
  iconName: "building-user",
  icon: [640, 512, [], "e4da", "M48 0C21.5 0 0 21.5 0 48L0 464c0 26.5 21.5 48 48 48l96 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 89.9 0c-6.3-10.2-9.9-22.2-9.9-35.1c0-46.9 25.8-87.8 64-109.2l0-95.9L384 48c0-26.5-21.5-48-48-48L48 0zM64 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm112-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM80 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM576 272a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM352 477.1c0 19.3 15.6 34.9 34.9 34.9l218.2 0c19.3 0 34.9-15.6 34.9-34.9c0-51.4-41.7-93.1-93.1-93.1l-101.8 0c-51.4 0-93.1 41.7-93.1 93.1z"]
}, faLightSwitch = {
  prefix: "fas",
  iconName: "light-switch",
  icon: [384, 512, [], "e017", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zm96 96l64 0c35.3 0 64 28.7 64 64l0 80L96 240l0-80c0-35.3 28.7-64 64-64zM288 272l0 80c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64l0-80 192 0zM192 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm0 416a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faSquareCaretLeft = {
  prefix: "fas",
  iconName: "square-caret-left",
  icon: [448, 512, ["caret-square-left"], "f191", "M0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416zM128 256c0-6.7 2.8-13 7.7-17.6l112-104c7-6.5 17.2-8.2 25.9-4.4s14.4 12.5 14.4 22l0 208c0 9.5-5.7 18.2-14.4 22s-18.9 2.1-25.9-4.4l-112-104c-4.9-4.5-7.7-10.9-7.7-17.6z"]
}, faCaretSquareLeft = faSquareCaretLeft, faHighlighter = {
  prefix: "fas",
  iconName: "highlighter",
  icon: [576, 512, [], "f591", "M315 315l158.4-215L444.1 70.6 229 229 315 315zm-187 5s0 0 0 0l0-71.7c0-15.3 7.2-29.6 19.5-38.6L420.6 8.4C428 2.9 437 0 446.2 0c11.4 0 22.4 4.5 30.5 12.6l54.8 54.8c8.1 8.1 12.6 19 12.6 30.5c0 9.2-2.9 18.2-8.4 25.6L334.4 396.5c-9 12.3-23.4 19.5-38.6 19.5L224 416l-25.4 25.4c-12.5 12.5-32.8 12.5-45.3 0l-50.7-50.7c-12.5-12.5-12.5-32.8 0-45.3L128 320zM7 466.3l63-63 70.6 70.6-31 31c-4.5 4.5-10.6 7-17 7L24 512c-13.3 0-24-10.7-24-24l0-4.7c0-6.4 2.5-12.5 7-17z"]
}, faWavePulse = {
  prefix: "fas",
  iconName: "wave-pulse",
  icon: [640, 512, ["heart-rate"], "f5f8", "M319.1 0c14.8-.4 27.9 9.3 31.8 23.6l74 271.2 17.7-35.4c10.8-21.7 33-35.4 57.2-35.4L608 224c17.7 0 32 14.3 32 32s-14.3 32-32 32l-108.2 0L444.6 398.3c-5.9 11.9-18.6 18.8-31.8 17.5s-24.2-10.6-27.7-23.4L323.7 167.3 255.3 486.7c-3.1 14.4-15.5 24.8-30.2 25.3s-27.8-9.1-31.8-23.2L135.9 288 32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l103.9 0c28.6 0 53.7 18.9 61.5 46.4L219.6 348 288.7 25.3C291.8 10.9 304.4 .4 319.1 0z"]
}, faHeartRate = faWavePulse, faKey = {
  prefix: "fas",
  iconName: "key",
  icon: [512, 512, [128273], "f084", "M336 352c97.2 0 176-78.8 176-176S433.2 0 336 0S160 78.8 160 176c0 18.7 2.9 36.8 8.3 53.7L7 391c-4.5 4.5-7 10.6-7 17l0 80c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24l0-40 40 0c13.3 0 24-10.7 24-24l0-40 40 0c6.4 0 12.5-2.5 17-7l33.3-33.3c16.9 5.4 35 8.3 53.7 8.3zM376 96a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]
}, faArrowLeftToBracket = {
  prefix: "fas",
  iconName: "arrow-left-to-bracket",
  icon: [512, 512, [], "e669", "M160 96L96 96c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-53 0-96-43-96-96L0 128C0 75 43 32 96 32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32zm9.4 182.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L269.3 224 480 224c17.7 0 32 14.3 32 32s-14.3 32-32 32l-210.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-128-128z"]
}, faHatSanta = {
  prefix: "fas",
  iconName: "hat-santa",
  icon: [640, 512, [], "f7a7", "M149.7 137.8L64 352l384 0L385.1 210.6c-.8-1.7-1.1-3.5-1.1-5.4c0-7.3 5.9-13.2 13.2-13.2l.8 0c1.4 0 2.7 .2 4 .6l55.3 16.6c2.1-3.2 4.5-6.1 7.2-8.8c0-14.3 5.5-28.7 16.4-39.6c2.2-2.2 4.6-4.2 7.1-6L434.4 91.6c-32-37.8-79-59.6-128.5-59.6c-68.8 0-130.7 41.9-156.3 105.8zm434.3 44.4C583 169.8 572.7 160 560 160s-23 9.8-23.9 22.2c-9.4-8.1-23.7-7.7-32.6 1.2s-9.4 23.2-1.2 32.6C489.8 217 480 227.3 480 240s9.8 23 22.2 23.9c-8.1 9.4-7.7 23.7 1.2 32.6s23.2 9.4 32.6 1.2C537 310.2 547.3 320 560 320s23-9.8 23.9-22.2c9.4 8.1 23.7 7.7 32.6-1.2s9.4-23.2 1.2-32.6C630.2 263 640 252.7 640 240s-9.8-23-22.2-23.9c8.1-9.4 7.7-23.7-1.2-32.6s-23.2-9.4-32.6-1.2zM0 432c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48s-21.5-48-48-48L48 384c-26.5 0-48 21.5-48 48z"]
}, faTamale = {
  prefix: "fas",
  iconName: "tamale",
  icon: [320, 512, [129748], "e451", "M48.1 18.3C72.3 8.6 108.4 0 160 0s87.7 8.6 111.9 18.3c12.1 4.8 21 9.9 27.4 14.1c12.7 8.5 23.1 20.4 20.3 36.9L296.4 208l-.4 0H236.2L248 72.7c.4-4.4-2.9-8.3-7.3-8.7s-8.3 2.9-8.7 7.3L220.1 208H168V64c0-4.4-3.6-8-8-8s-8 3.6-8 8V208H99.9L88 71.3c-.4-4.4-4.3-7.7-8.7-7.3s-7.7 4.3-7.3 8.7L83.8 208H24l-.4 0L.4 69.3C-2.3 52.8 8.1 40.8 20.8 32.4c6.3-4.2 15.3-9.3 27.4-14.1zM24 240H296c8.8 0 16 7.2 16 16s-7.2 16-16 16H192l28.8 38.4c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2L160 282.7l-35.2 46.9c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4L128 272H24c-8.8 0-16-7.2-16-16s7.2-16 16-16zM152 448c0 4.4 3.6 8 8 8s8-3.6 8-8V346.7c13.4 17.9 35.9 26.5 57.4 18.1l6.6 76c.4 4.4 4.3 7.7 8.7 7.3s7.7-4.3 7.3-8.7l-7.3-84.1c14.2-13.2 18.9-33.4 12.6-51.2H296l.4 0 23.1 138.7c1.7 10.2-1.6 20.6-8.9 27.9l0 0c-10.6 10.5-25.1 17.6-38.7 23C247.7 503.4 211.6 512 160 512s-87.7-8.6-111.9-18.3c-13.7-5.5-28.1-12.5-38.7-23l0 0c-7.3-7.3-10.6-17.7-8.9-27.9L23.6 304l.4 0H66.7c-6.3 17.7-1.6 38 12.6 51.2L72 439.3c-.4 4.4 2.9 8.3 7.3 8.7s8.3-2.9 8.7-7.3l6.6-76c21.5 8.4 44-.2 57.4-18.1V448z"]
}, faBoxCheck = {
  prefix: "fas",
  iconName: "box-check",
  icon: [448, 512, [], "f467", "M93.7 32L208 32l0 128L0 160 50.7 58.5C58.9 42.3 75.5 32 93.7 32zM240 32l114.3 0c18.2 0 34.8 10.3 42.9 26.5L448 160l-208 0 0-128zM0 192l448 0 0 224c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 192zm337 89c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L337 281z"]
}, faBullhorn = {
  prefix: "fas",
  iconName: "bullhorn",
  icon: [512, 512, [128226, 128363], "f0a1", "M480 32c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9L381.7 53c-48 48-113.1 75-181 75l-8.7 0-32 0-96 0c-35.3 0-64 28.7-64 64l0 96c0 35.3 28.7 64 64 64l0 128c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-128 8.7 0c67.9 0 133 27 181 75l43.6 43.6c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6l0-147.6c18.6-8.8 32-32.5 32-60.4s-13.4-51.6-32-60.4L480 32zm-64 76.7L416 240l0 131.3C357.2 317.8 280.5 288 200.7 288l-8.7 0 0-96 8.7 0c79.8 0 156.5-29.8 215.3-83.3z"]
}, faSteak = {
  prefix: "fas",
  iconName: "steak",
  icon: [576, 512, [129385], "f824", "M268.8 37.4C295.7 12.4 329.7 0 368 0c65 0 117.7 39 150.5 80c33.9 42.4 57.5 99.6 57.5 160c0 83.9-55.1 152.8-113.4 196.2C402.1 481.2 321.7 512 240 512c-36.8 0-86.5-4.4-130-19.3C73.4 480.1 0 444.3 0 360c0-38.6 17.8-68.3 42.5-88.1c19.6-15.8 41.4-26.8 63.3-37.8c27.3-13.8 54.6-27.6 77.7-50.7c13.8-13.8 19.7-27.9 30-52.9c3.2-7.7 6.8-16.5 11.2-26.6c7.7-17.6 20.6-44.7 44.1-66.5zm36.8 122s0 0 0 0c2.5-6 4.8-11.8 7.1-17c6.9-15.7 13.3-27.1 21.5-34.7c7.5-7 17.5-11.7 33.9-11.7c25.4 0 53.3 16.2 75.5 44c22 27.5 36.5 64.1 36.5 100c0 40.8-28.3 84.6-74.7 119.2C359.4 393.4 298.6 416 240 416c-31 0-69.1-3.9-98.8-14.1C110.1 391.2 96 376.7 96 360c0-9 2.6-13.2 6.9-16.9c5.8-5 15-9.1 30.2-15.5l1.2-.5c29.3-12.4 71.2-30 117-75.8c28.6-28.6 42.9-63.7 54.3-91.9zm6.8-75.2c-13.3 12.4-21.9 29-29 45.3c-2.9 6.6-5.6 13.2-8.3 19.8c-11.4 27.8-22.8 55.7-46.4 79.3c-41.4 41.4-78.6 57.1-107 69l-1.1 .5-.7 .3s0 0 0 0c-13.5 5.7-27.5 11.6-37.7 20.3C70.4 328.8 64 342.1 64 360c0 39.3 33.9 60.8 66.8 72.1C165.1 443.9 207 448 240 448c66.3 0 133.6-25.4 184.4-63.2C474.8 347.4 512 295.2 512 240c0-44.1-17.5-87.5-43.5-120C442.7 87.8 406.6 64 368 64c-23.7 0-41.7 7.3-55.6 20.3zM384 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faLocationCrosshairsSlash = {
  prefix: "fas",
  iconName: "location-crosshairs-slash",
  icon: [640, 512, ["location-slash"], "f603", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-146-114.5c12.1-20.1 20.6-42.6 24.6-66.6l34.7 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-34.7 0C495.9 143.6 432.4 80.1 352 66.7L352 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 34.7c-39.9 6.7-75.6 25.7-103.1 52.9L38.8 5.1zm197 154.4C258.3 139.9 287.8 128 320 128c70.7 0 128 57.3 128 128c0 21.2-5.1 41.1-14.2 58.7l-38.9-30.5c3.3-8.8 5.1-18.3 5.1-28.2c0-44.2-35.8-80-80-80c-16.8 0-32.4 5.2-45.3 14l-38.9-30.5zM414.9 422.9l-56.8-44.7C346.1 382 333.3 384 320 384c-70.7 0-128-57.3-128-128c0-2.9 .1-5.7 .3-8.5l-56.8-44.7c-2 6.9-3.6 14-4.8 21.3L96 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l34.7 0c13.5 80.4 76.9 143.9 157.3 157.3l0 34.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-34.7c22.6-3.8 43.8-11.5 62.9-22.4z"]
}, faLocationSlash = faLocationCrosshairsSlash, faPersonDolly = {
  prefix: "fas",
  iconName: "person-dolly",
  icon: [512, 512, [], "f4d0", "M32 48a48 48 0 1 1 96 0A48 48 0 1 1 32 48zM96 241.7l0 65.1 51 51c7.1 7.1 11.8 16.2 13.4 26.1l15.2 90.9c2.9 17.4-8.9 33.9-26.3 36.8s-33.9-8.9-36.8-26.3L98.1 399.4 18.7 320C6.7 308 0 291.7 0 274.7l0-88.1C0 154.2 26.2 128 58.6 128c24.1 0 46.5 12 59.9 32l42.6 64 46.1 0-6.5-26.2c-3.2-12.9 4.6-25.9 17.5-29.1s25.9 4.6 29.1 17.5l49.6 198.4c17.6 2.4 32.9 12 42.8 25.7l134.4-33.6c12.9-3.2 25.9 4.6 29.1 17.5s-4.6 25.9-17.5 29.1L351.4 456.9C347.1 488 320.3 512 288 512c-35.3 0-64-28.7-64-64c0-21.3 10.4-40.1 26.3-51.7L223.3 288l-70.7 0c-16 0-31-8-39.9-21.4L96 241.7zM0 480L0 346.5l64 64L64 480s0 0 0 0c0 17.7-14.3 32-32 32s-32-14.3-32-32zm288-16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm69.4-87.8c-17.1 4.3-34.5-6.1-38.8-23.3l-22.9-91.5c-4.3-17.1 6.1-34.5 23.3-38.8l91.5-22.9c17.1-4.3 34.5 6.1 38.8 23.3l22.9 91.5c4.3 17.1-6.1 34.5-23.3 38.8l-91.5 22.9z"]
}, faGlobe = {
  prefix: "fas",
  iconName: "globe",
  icon: [512, 512, [127760], "f0ac", "M352 256c0 22.2-1.2 43.6-3.3 64l-185.3 0c-2.2-20.4-3.3-41.8-3.3-64s1.2-43.6 3.3-64l185.3 0c2.2 20.4 3.3 41.8 3.3 64zm28.8-64l123.1 0c5.3 20.5 8.1 41.9 8.1 64s-2.8 43.5-8.1 64l-123.1 0c2.1-20.6 3.2-42 3.2-64s-1.1-43.4-3.2-64zm112.6-32l-116.7 0c-10-63.9-29.8-117.4-55.3-151.6c78.3 20.7 142 77.5 171.9 151.6zm-149.1 0l-176.6 0c6.1-36.4 15.5-68.6 27-94.7c10.5-23.6 22.2-40.7 33.5-51.5C239.4 3.2 248.7 0 256 0s16.6 3.2 27.8 13.8c11.3 10.8 23 27.9 33.5 51.5c11.6 26 20.9 58.2 27 94.7zm-209 0L18.6 160C48.6 85.9 112.2 29.1 190.6 8.4C165.1 42.6 145.3 96.1 135.3 160zM8.1 192l123.1 0c-2.1 20.6-3.2 42-3.2 64s1.1 43.4 3.2 64L8.1 320C2.8 299.5 0 278.1 0 256s2.8-43.5 8.1-64zM194.7 446.6c-11.6-26-20.9-58.2-27-94.6l176.6 0c-6.1 36.4-15.5 68.6-27 94.6c-10.5 23.6-22.2 40.7-33.5 51.5C272.6 508.8 263.3 512 256 512s-16.6-3.2-27.8-13.8c-11.3-10.8-23-27.9-33.5-51.5zM135.3 352c10 63.9 29.8 117.4 55.3 151.6C112.2 482.9 48.6 426.1 18.6 352l116.7 0zm358.1 0c-30 74.1-93.6 130.9-171.9 151.6c25.5-34.2 45.2-87.7 55.3-151.6l116.7 0z"]
}, faSynagogue = {
  prefix: "fas",
  iconName: "synagogue",
  icon: [640, 512, [128333], "f69b", "M309.8 3.7c5.9-4.9 14.6-4.9 20.5 0l121 100.8C469.5 119.7 480 142.2 480 166l0 114.1L480 512l-16 0-112 0 0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96-112 0-16 0 0-231.9L160 166c0-23.7 10.5-46.3 28.8-61.5L309.8 3.7zM512 512l0-267.5 28.1-31.2c3-3.4 7.4-5.3 11.9-5.3s8.9 1.9 11.9 5.3l63.8 70.9c7.9 8.8 12.3 20.3 12.3 32.1L640 448c0 35.3-28.7 64-64 64l-64 0zM128 244.5L128 512l-64 0c-35.3 0-64-28.7-64-64L0 316.3c0-11.9 4.4-23.3 12.3-32.1l63.8-70.9c3-3.4 7.4-5.3 11.9-5.3s8.9 1.9 11.9 5.3L128 244.5zM327 124.3c-3.1-5.4-10.9-5.4-13.9 0l-15.9 28.1-32.3-.3c-6.2-.1-10.1 6.7-7 12.1L274.3 192l-16.4 27.8c-3.2 5.4 .7 12.1 7 12.1l32.3-.3L313 259.7c3.1 5.4 10.9 5.4 13.9 0l15.9-28.1 32.3 .3c6.2 .1 10.1-6.7 7-12.1L365.7 192l16.4-27.8c3.2-5.4-.7-12.1-7-12.1l-32.3 .3L327 124.3z"]
}, faFileChartColumn = {
  prefix: "fas",
  iconName: "file-chart-column",
  icon: [384, 512, ["file-chart-line"], "f659", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM216 248l0 176c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24s24 10.7 24 24zm88 64l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24s24 10.7 24 24zM128 376l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faFileChartLine = faFileChartColumn, faPersonHalfDress = {
  prefix: "fas",
  iconName: "person-half-dress",
  icon: [320, 512, [], "e548", "M160 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm8 352l0-224 6.9 0c33.7 0 64.9 17.7 82.3 46.6l58.3 97c9.1 15.1 4.2 34.8-10.9 43.9s-34.8 4.2-43.9-10.9L232 256.9 232 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128s0 0 0 0zM58.2 182.3c19.9-33.1 55.3-53.5 93.8-54.3l0 256s0 0 0 0l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-17.8 0c-10.9 0-18.6-10.7-15.2-21.1L93.3 248.1 59.4 304.5c-9.1 15.1-28.8 20-43.9 10.9s-20-28.8-10.9-43.9l53.6-89.2z"]
}, faFolderImage = {
  prefix: "fas",
  iconName: "folder-image",
  icon: [512, 512, [], "e18a", "M448 480L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l128 0c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8l160 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64zM176 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm120 0c-8 0-15.5 4-20 10.7l-56 84L202.7 297c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6l80 0 48 0 144 0c8.9 0 17-4.9 21.2-12.7s3.7-17.3-1.2-24.6l-96-144C311.5 228 304 224 296 224z"]
}, faCalendarPen = {
  prefix: "fas",
  iconName: "calendar-pen",
  icon: [448, 512, ["calendar-edit"], "f333", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 48 0c26.5 0 48 21.5 48 48l0 48L0 160l0-48C0 85.5 21.5 64 48 64l48 0 0-32c0-17.7 14.3-32 32-32zM0 192l448 0 0 272c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 192zm308.8 75c-14.7-14.7-38.6-14.7-53.3 0L240.6 282l53.3 53.3 14.9-14.9c14.7-14.7 14.7-38.6 0-53.3zM146.1 376.5c-4.1 4.1-7 9.2-8.4 14.9L128.5 428c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4l71.9-71.9L218 304.6l-71.9 71.9z"]
}, faCalendarEdit = faCalendarPen, faRoadBridge = {
  prefix: "fas",
  iconName: "road-bridge",
  icon: [640, 512, [], "e563", "M352 0L608 0c17.7 0 32 14.3 32 32l0 448c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-448c0-17.7 14.3-32 32-32zM480 200c-13.3 0-24 10.7-24 24l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64c0-13.3-10.7-24-24-24zm24 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64zM480 40c-13.3 0-24 10.7-24 24l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64c0-13.3-10.7-24-24-24zM32 96l256 0 0 64-40 0 0 64 40 0 0 96c-53 0-96 43-96 96l0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64c0-53-43-96-96-96l0-96 72 0 0-64-40 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm168 64l-80 0 0 64 80 0 0-64z"]
}, faFaceSmileTear = {
  prefix: "fas",
  iconName: "face-smile-tear",
  icon: [512, 512, [], "e393", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm141.5 67.9c-6.7 5.8-7.4 15.9-1.6 22.6c22.2 25.7 61 53.5 116.1 53.5c8.8 0 16-7.2 16-16s-7.2-16-16-16c-43.4 0-74-21.8-91.9-42.5c-5.8-6.7-15.9-7.4-22.6-1.6zM352 416c26.5 0 48-21 48-47c0-20-28.6-60.4-41.6-77.7c-3.2-4.4-9.6-4.4-12.8 0C332.4 308.6 304 349 304 369c0 26 21.5 47 48 47zM208.4 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faMessagePlus = {
  prefix: "fas",
  iconName: "message-plus",
  icon: [512, 512, ["comment-alt-plus"], "f4a8", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM232 296c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 64z"]
}, faCommentAltPlus = faMessagePlus, faLocationArrow = {
  prefix: "fas",
  iconName: "location-arrow",
  icon: [448, 512, [], "f124", "M429.6 92.1c4.9-11.9 2.1-25.6-7-34.7s-22.8-11.9-34.7-7l-352 144c-14.2 5.8-22.2 20.8-19.3 35.8s16.1 25.8 31.4 25.8l176 0 0 176c0 15.3 10.8 28.4 25.8 31.4s30-5.1 35.8-19.3l144-352z"]
}, faC = {
  prefix: "fas",
  iconName: "c",
  icon: [384, 512, [99], "43", "M329.1 142.9c-62.5-62.5-155.8-62.5-218.3 0s-62.5 163.8 0 226.3s155.8 62.5 218.3 0c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3c-87.5 87.5-221.3 87.5-308.8 0s-87.5-229.3 0-316.8s221.3-87.5 308.8 0c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0z"]
}, faTabletButton = {
  prefix: "fas",
  iconName: "tablet-button",
  icon: [448, 512, [], "f10a", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM224 400a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faPersonDressFairy = {
  prefix: "fas",
  iconName: "person-dress-fairy",
  icon: [640, 512, [], "e607", "M320 0a64 64 0 1 1 0 128A64 64 0 1 1 320 0zM304.3 160l31.5 0c28.6 0 53.7 18.9 61.5 46.4l39.1 136.8c5.8 20.4-9.5 40.8-30.8 40.8L384 384l0 80c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-80-21.6 0c-21.3 0-36.6-20.3-30.8-40.8l39.1-136.8c7.8-27.5 33-46.4 61.5-46.4zM32 32c91.1 0 172.4 42.3 225.1 108.4c-21.5 12.1-38 32.3-45.2 57.3L172.9 334.4c-10.7 37.5 14.2 74.8 51.1 80.7l0 32.1C191.7 468 153.2 480 112 480l-16 0c-17.7 0-32-14.3-32-32c0-45.7 14.7-88 39.7-122.3C40.6 275.9 0 198.7 0 112L0 64C0 46.3 14.3 32 32 32zM528 480c-41.2 0-79.7-12-112-32.7l0-32.1c36.9-6 61.8-43.3 51.1-80.7L428 197.6c-7.1-24.9-23.7-45.1-45.2-57.3C435.6 74.3 516.9 32 608 32c17.7 0 32 14.3 32 32l0 48c0 86.7-40.6 163.9-103.7 213.7C561.3 360 576 402.3 576 448c0 17.7-14.3 32-32 32l-16 0z"]
}, faRectangleHistoryCircleUser = {
  prefix: "fas",
  iconName: "rectangle-history-circle-user",
  icon: [640, 512, [], "e4a4", "M320 368c0 59.5 29.5 112.1 74.8 144L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64l384 0c23.8 0 44.5 12.9 55.5 32.2c-2.5-.1-5-.2-7.5-.2c-97.2 0-176 78.8-176 176zM440 80c13.3 0 24 10.7 24 24s-10.7 24-24 24L72 128c-13.3 0-24-10.7-24-24s10.7-24 24-24l368 0zM392 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L120 48c-13.3 0-24-10.7-24-24s10.7-24 24-24L392 0zM352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm221.7 80.7c-6.2-19-24-32.7-45.1-32.7l-65.2 0c-21 0-38.9 13.7-45.1 32.7C438.5 468.1 465.8 480 496 480s57.5-11.9 77.7-31.3zM544 336a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]
}, faBuildingLock = {
  prefix: "fas",
  iconName: "building-lock",
  icon: [576, 512, [], "e4d6", "M48 0C21.5 0 0 21.5 0 48L0 464c0 26.5 21.5 48 48 48l96 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 88.6 0c-5.4-9.4-8.6-20.3-8.6-32l0-128c0-23.7 12.9-44.4 32-55.4l0-24.6c0-30.5 12.2-58.2 32-78.4L384 48c0-26.5-21.5-48-48-48L48 0zM64 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm112-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM80 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM464 240c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]
}, faChartLineUp = {
  prefix: "fas",
  iconName: "chart-line-up",
  icon: [512, 512, [], "e0e5", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zM439 279c15.1 15.1 41 4.4 41-17L480 152c0-13.3-10.7-24-24-24l-110.1 0c-21.4 0-32.1 25.9-17 41l32.4 32.4L304 258.7l-73.4-73.4c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L208 253.3l73.4 73.4c12.5 12.5 32.8 12.5 45.3 0l80-80L439 279z"]
}, faMailbox = {
  prefix: "fas",
  iconName: "mailbox",
  icon: [576, 512, [128234], "f813", "M0 208L0 384c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-176c0-79.5-64.5-144-144-144S0 128.5 0 208zm64 0c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 224c-8.8 0-16-7.2-16-16zm256 0l0 176c0 24.6-9.2 47-24.4 64L512 448c35.3 0 64-28.7 64-64l0-176c0-79.5-64.5-144-144-144L245.2 64C290.4 95.9 320 148.5 320 208zm64 0c0-8.8 7.2-16 16-16l64 0 32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16z"]
}, faSignPosts = {
  prefix: "fas",
  iconName: "sign-posts",
  icon: [576, 512, [], "e625", "M96 0C78.3 0 64 14.3 64 32L48 32C21.5 32 0 53.5 0 80L0 368c0 26.5 21.5 48 48 48l480 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-16 0c0-17.7-14.3-32-32-32s-32 14.3-32 32L128 32c0-17.7-14.3-32-32-32zm32 448l-64 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32zm320 0l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32-64 0z"]
}, faTruckBolt = {
  prefix: "fas",
  iconName: "truck-bolt",
  icon: [640, 512, [], "e3d0", "M48 0C21.5 0 0 21.5 0 48L0 368c0 26.5 21.5 48 48 48l16 0c0 53 43 96 96 96s96-43 96-96l128 0c0 53 43 96 96 96s96-43 96-96l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-64 0-32 0-18.7c0-17-6.7-33.3-18.7-45.3L512 114.7c-12-12-28.3-18.7-45.3-18.7L416 96l0-48c0-26.5-21.5-48-48-48L48 0zM416 160l50.7 0L544 237.3l0 18.7-128 0 0-96zM112 416a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm368-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM270.3 87.2L233.9 160l54.1 0c6.9 0 13 4.4 15.2 10.9s-.1 13.7-5.6 17.9l-128 96c-5.9 4.5-14.2 4.2-19.9-.5s-7.4-12.8-4.1-19.4L182.1 192 128 192c-6.9 0-13-4.4-15.2-10.9s.1-13.7 5.6-17.9l128-96c5.9-4.5 14.2-4.2 19.9 .5s7.4 12.8 4.1 19.4z"]
}, faPizzaSlice = {
  prefix: "fas",
  iconName: "pizza-slice",
  icon: [512, 512, [], "f818", "M169.7 .9c-22.8-1.6-41.9 14-47.5 34.7L110.4 80c.5 0 1.1 0 1.6 0c176.7 0 320 143.3 320 320c0 .5 0 1.1 0 1.6l44.4-11.8c20.8-5.5 36.3-24.7 34.7-47.5C498.5 159.5 352.5 13.5 169.7 .9zM399.8 410.2c.1-3.4 .2-6.8 .2-10.2c0-159.1-128.9-288-288-288c-3.4 0-6.8 .1-10.2 .2L.5 491.9c-1.5 5.5 .1 11.4 4.1 15.4s9.9 5.6 15.4 4.1L399.8 410.2zM176 208a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM96 384a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faMoneyBillWave = {
  prefix: "fas",
  iconName: "money-bill-wave",
  icon: [576, 512, [], "f53a", "M0 112.5L0 422.3c0 18 10.1 35 27 41.3c87 32.5 174 10.3 261-11.9c79.8-20.3 159.6-40.7 239.3-18.9c23 6.3 48.7-9.5 48.7-33.4l0-309.9c0-18-10.1-35-27-41.3C462 15.9 375 38.1 288 60.3C208.2 80.6 128.4 100.9 48.7 79.1C25.6 72.8 0 88.6 0 112.5zM288 352c-44.2 0-80-43-80-96s35.8-96 80-96s80 43 80 96s-35.8 96-80 96zM64 352c35.3 0 64 28.7 64 64l-64 0 0-64zm64-208c0 35.3-28.7 64-64 64l0-64 64 0zM512 304l0 64-64 0c0-35.3 28.7-64 64-64zM448 96l64 0 0 64c-35.3 0-64-28.7-64-64z"]
}, faChartArea = {
  prefix: "fas",
  iconName: "chart-area",
  icon: [512, 512, ["area-chart"], "f1fe", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zm96 288l288 0c17.7 0 32-14.3 32-32l0-68.2c0-7.6-2.7-15-7.7-20.8l-65.8-76.8c-12.1-14.2-33.7-15-46.9-1.8l-21 21c-10 10-26.4 9.2-35.4-1.6l-39.2-47c-12.6-15.1-35.7-15.4-48.7-.6L135.9 215c-5.1 5.8-7.9 13.3-7.9 21.1l0 84c0 17.7 14.3 32 32 32z"]
}, faAreaChart = faChartArea, faHouseFlag = {
  prefix: "fas",
  iconName: "house-flag",
  icon: [640, 512, [], "e50d", "M480 0c-17.7 0-32 14.3-32 32l0 160 0 320 64 0 0-320 112 0c8.8 0 16-7.2 16-16l0-128c0-8.8-7.2-16-16-16L512 32c0-17.7-14.3-32-32-32zM416 159L276.8 39.7c-12-10.3-29.7-10.3-41.7 0l-224 192C1 240.4-2.7 254.5 2 267.1S18.6 288 32 288l32 0 0 192c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-96c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 96c0 17.7 14.3 32 32 32l64.7 0 .2 0-1 0 0-353z"]
}, faCircleThreeQuartersStroke = {
  prefix: "fas",
  iconName: "circle-three-quarters-stroke",
  icon: [512, 512, [], "e5d4", "M256 64l0 160c0 17.7 14.3 32 32 32l160 0c0-106-86-192-192-192zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"]
}, faPersonCircleMinus = {
  prefix: "fas",
  iconName: "person-circle-minus",
  icon: [576, 512, [], "e540", "M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 304l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-223.1L59.4 304.5c-9.1 15.1-28.8 20-43.9 10.9s-20-28.8-10.9-43.9l58.3-97c17.4-28.9 48.6-46.6 82.3-46.6l29.7 0c33.7 0 64.9 17.7 82.3 46.6l44.9 74.7c-16.1 17.6-28.6 38.5-36.6 61.5c-1.9-1.8-3.5-3.9-4.9-6.3L232 256.9 232 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-16 0zm136 16a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm224 0c0-8.8-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16z"]
}, faScalpel = {
  prefix: "fas",
  iconName: "scalpel",
  icon: [512, 512, [], "f61d", "M387.4 25.1C400.8 9.2 420.6 0 441.4 0c39 0 70.6 31.6 70.6 70.6l0 4c0 17.6-6.2 34.6-17.6 48.1L369.3 271c-9.1 10.8-22.5 17-36.7 17L200 288c-6.2 0-11.9-3.6-14.5-9.3s-1.7-12.3 2.3-17.1L387.4 25.1zM169.4 320l6.6 0 96 0 16 0 0 16c0 74.9-65.5 118.6-126.1 142.9C100.1 503.6 34.1 512 16 512c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l160-160 4.7-4.7z"]
}, faBan = {
  prefix: "fas",
  iconName: "ban",
  icon: [512, 512, [128683, "cancel"], "f05e", "M367.2 412.5L99.5 144.8C77.1 176.1 64 214.5 64 256c0 106 86 192 192 192c41.5 0 79.9-13.1 111.2-35.5zm45.3-45.3C434.9 335.9 448 297.5 448 256c0-106-86-192-192-192c-41.5 0-79.9 13.1-111.2 35.5L412.5 367.2zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256z"]
}, faCancel = faBan, faBellExclamation = {
  prefix: "fas",
  iconName: "bell-exclamation",
  icon: [448, 512, [], "f848", "M224 0c-17.7 0-32 14.3-32 32l0 19.2C119 66 64 130.6 64 208l0 18.8c0 47-17.3 92.4-48.5 127.6l-7.4 8.3c-8.4 9.4-10.4 22.9-5.3 34.4S19.4 416 32 416l384 0c12.6 0 24-7.4 29.2-18.9s3.1-25-5.3-34.4l-7.4-8.3C401.3 319.2 384 273.9 384 226.8l0-18.8c0-77.4-55-142-128-156.8L256 32c0-17.7-14.3-32-32-32zm45.3 493.3c12-12 18.7-28.3 18.7-45.3l-64 0-64 0c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7zM192 320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm56-184l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faCircleBookmark = {
  prefix: "fas",
  iconName: "circle-bookmark",
  icon: [512, 512, ["bookmark-circle"], "e100", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 176c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 192c0 6.2-3.5 11.8-9.1 14.4s-12.1 1.9-16.9-1.9l-70-56-70 56c-4.8 3.8-11.4 4.6-16.9 1.9s-9.1-8.3-9.1-14.4l0-192z"]
}, faBookmarkCircle = faCircleBookmark, faEggFried = {
  prefix: "fas",
  iconName: "egg-fried",
  icon: [512, 512, [], "f7fc", "M284.3 39.3c30.4 31.6 89.1 65.9 131.5 76.7c27.5 7 52.8 23.2 71 47.8c42.1 56.8 30.2 137-26.6 179.1c-17.8 13.2-37.9 21.1-58.4 24c-37.2 5.2-84.5 32.7-103.3 65.2c-44.2 76.5-142 102.7-218.6 58.6S-22.7 348.5 21.4 272c24.8-42.9 38.7-105.9 43.1-155.2C67.1 87 80.1 58 103.3 35.7c51-49 132-47.4 181 3.6zM336 240a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zm-160-8c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-39.8 32.2-72 72-72c8.8 0 16 7.2 16 16s-7.2 16-16 16c-22.1 0-40 17.9-40 40z"]
}, faFaceWeary = {
  prefix: "fas",
  iconName: "face-weary",
  icon: [512, 512, [], "e3a1", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM164.7 328.7c22-22 53.9-40.7 91.3-40.7s69.3 18.7 91.3 40.7c11.1 11.1 20.1 23.4 26.4 35.4c6.2 11.7 10.3 24.4 10.3 35.9c0 5.2-2.6 10.2-6.9 13.2s-9.8 3.7-14.7 1.8l-20.5-7.7c-26.9-10.1-55.5-15.3-84.3-15.3l-3.2 0c-28.8 0-57.3 5.2-84.3 15.3L149.6 415c-4.9 1.8-10.4 1.2-14.7-1.8s-6.9-7.9-6.9-13.2c0-11.6 4.2-24.2 10.3-35.9c6.3-12 15.3-24.3 26.4-35.4zm46.6-164c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2s4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0zm89.4 22.6c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4z"]
}, faUniformMartialArts = {
  prefix: "fas",
  iconName: "uniform-martial-arts",
  icon: [640, 512, [], "e3d1", "M180 0l28 0 9.6 0c12.3 0 23.5 7 28.8 18.1l61.1 126.7L253 288l-109 0 0-154.9L98 216.7c-1.3 2.4-2 5-2 7.7L96 384c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 224.4c0-18.9 4.8-37.4 13.9-54L80.3 49.7C95.9 21.2 124.9 2.8 157 .3c1-.2 2-.3 3-.3l4.4 0L180 0zM389.1 20.6C393.8 8.2 405.7 0 419 0l13 0 28 0 15.6 0L480 0c1 0 2 .1 3 .3c32.1 2.5 61 20.9 76.7 49.5l66.4 120.7c9.1 16.5 13.9 35.1 13.9 54L640 384c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-159.6c0-2.7-.7-5.3-2-7.7l-46-83.7L496 288l-208.8 0 52.7-138.3L389.1 20.6zM320 320l176 0 0 32-107.6 0-38.5 0 47.4 71.1c4.9 7.4 2.9 17.3-4.4 22.2s-17.3 2.9-22.2-4.4l-50.7-76-50.7 76c-4.9 7.4-14.8 9.3-22.2 4.4s-9.3-14.8-4.4-22.2L290.1 352l-38.5 0L144 352l0-32 120 0 56 0zM216.1 405.4c-14.7 22.1-8.7 51.9 13.3 66.6s51.9 8.7 66.6-13.3L320 422.5l24.1 36.1c14.7 22.1 44.5 28 66.6 13.3s28-44.5 13.3-66.6L409.7 384l86.3 0 0 64c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64l0-64 86.3 0-14.2 21.4z"]
}, faCameraRotate = {
  prefix: "fas",
  iconName: "camera-rotate",
  icon: [640, 512, [], "e0d8", "M213.1 64.8L202.7 96 128 96c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-74.7 0L426.9 64.8C420.4 45.2 402.1 32 381.4 32L258.6 32c-20.7 0-39 13.2-45.5 32.8zM448 256c0 8.8-7.2 16-16 16l-76.7 0c-6.2 0-11.3-5.1-11.3-11.3c0-3 1.2-5.9 3.3-8L371 229c-13.6-13.4-31.9-21-51-21c-19.2 0-37.7 7.6-51.3 21.3L249 249c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l19.7-19.7C257.4 172.7 288 160 320 160c31.8 0 62.4 12.6 85 35l23.7-23.7c2.1-2.1 5-3.3 8-3.3c6.2 0 11.3 5.1 11.3 11.3l0 76.7zM192 320c0-8.8 7.2-16 16-16l76.7 0c6.2 0 11.3 5.1 11.3 11.3c0 3-1.2 5.9-3.3 8L269 347c13.6 13.4 31.9 21 51 21c19.2 0 37.7-7.6 51.3-21.3L391 327c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-19.7 19.7C382.6 403.3 352 416 320 416c-31.8 0-62.4-12.6-85-35l-23.7 23.7c-2.1 2.1-5 3.3-8 3.3c-6.2 0-11.3-5.1-11.3-11.3l0-76.7z"]
}, faSunDust = {
  prefix: "fas",
  iconName: "sun-dust",
  icon: [512, 512, [], "f764", "M371.1 13.1L391 121l-44.5 44.5C323.3 142.3 291.3 128 256 128c-70.7 0-128 57.3-128 128c0 35.3 14.3 67.3 37.5 90.5L121 391 13.1 371.1c-5.3-1-9.8-4.6-11.9-9.6s-1.5-10.7 1.6-15.2L65.1 256 2.8 165.7c-3.1-4.5-3.7-10.2-1.6-15.2s6.6-8.6 11.9-9.6L121 121 140.9 13.1c1-5.3 4.6-9.8 9.6-11.9s10.7-1.5 15.2 1.6L256 65.1 346.3 2.8c4.5-3.1 10.2-3.7 15.2-1.6s8.6 6.6 9.6 11.9zM256 160c26.5 0 50.5 10.7 67.9 28.1L188.1 323.9C170.7 306.5 160 282.5 160 256c0-53 43-96 96-96zm192 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-80 80a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 48a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM240 368a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm-80 80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM368 400a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM320 288a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faCommentText = {
  prefix: "fas",
  iconName: "comment-text",
  icon: [512, 512, [], "e14d", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM184 160l72 0 72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faSprayCanSparkles = {
  prefix: "fas",
  iconName: "spray-can-sparkles",
  icon: [512, 512, ["air-freshener"], "f5d0", "M96 32l0 96 128 0 0-96c0-17.7-14.3-32-32-32L128 0C110.3 0 96 14.3 96 32zm0 128c-53 0-96 43-96 96L0 464c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-208c0-53-43-96-96-96L96 160zm64 96a80 80 0 1 1 0 160 80 80 0 1 1 0-160zM384 48c0-1.4-1-3-2.2-3.6L352 32 339.6 2.2C339 1 337.4 0 336 0s-3 1-3.6 2.2L320 32 290.2 44.4C289 45 288 46.6 288 48c0 1.4 1 3 2.2 3.6L320 64l12.4 29.8C333 95 334.6 96 336 96s3-1 3.6-2.2L352 64l29.8-12.4C383 51 384 49.4 384 48zm76.4 45.8C461 95 462.6 96 464 96s3-1 3.6-2.2L480 64l29.8-12.4C511 51 512 49.4 512 48c0-1.4-1-3-2.2-3.6L480 32 467.6 2.2C467 1 465.4 0 464 0s-3 1-3.6 2.2L448 32 418.2 44.4C417 45 416 46.6 416 48c0 1.4 1 3 2.2 3.6L448 64l12.4 29.8zm7.2 100.4c-.6-1.2-2.2-2.2-3.6-2.2s-3 1-3.6 2.2L448 224l-29.8 12.4c-1.2 .6-2.2 2.2-2.2 3.6c0 1.4 1 3 2.2 3.6L448 256l12.4 29.8c.6 1.2 2.2 2.2 3.6 2.2s3-1 3.6-2.2L480 256l29.8-12.4c1.2-.6 2.2-2.2 2.2-3.6c0-1.4-1-3-2.2-3.6L480 224l-12.4-29.8zM448 144c0-1.4-1-3-2.2-3.6L416 128 403.6 98.2C403 97 401.4 96 400 96s-3 1-3.6 2.2L384 128l-29.8 12.4c-1.2 .6-2.2 2.2-2.2 3.6c0 1.4 1 3 2.2 3.6L384 160l12.4 29.8c.6 1.2 2.2 2.2 3.6 2.2s3-1 3.6-2.2L416 160l29.8-12.4c1.2-.6 2.2-2.2 2.2-3.6z"]
}, faAirFreshener = faSprayCanSparkles, faSignalBars = {
  prefix: "fas",
  iconName: "signal-bars",
  icon: [640, 512, ["signal-alt", "signal-alt-4", "signal-bars-strong"], "f690", "M560 0c-26.5 0-48 21.5-48 48l0 416c0 26.5 21.5 48 48 48s48-21.5 48-48l0-416c0-26.5-21.5-48-48-48zM352 176l0 288c0 26.5 21.5 48 48 48s48-21.5 48-48l0-288c0-26.5-21.5-48-48-48s-48 21.5-48 48zM240 256c-26.5 0-48 21.5-48 48l0 160c0 26.5 21.5 48 48 48s48-21.5 48-48l0-160c0-26.5-21.5-48-48-48zM80 384c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48z"]
}, faSignalAlt = faSignalBars, faSignalAlt4 = faSignalBars, faSignalBarsStrong = faSignalBars, faDiamondExclamation = {
  prefix: "fas",
  iconName: "diamond-exclamation",
  icon: [512, 512, [], "e405", "M227.7 11.7c15.6-15.6 40.9-15.6 56.6 0l216 216c15.6 15.6 15.6 40.9 0 56.6l-216 216c-15.6 15.6-40.9 15.6-56.6 0l-216-216c-15.6-15.6-15.6-40.9 0-56.6l216-216zM256 128c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faStar = {
  prefix: "fas",
  iconName: "star",
  icon: [576, 512, [11088, 61446], "f005", "M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z"]
}, faDialMin = {
  prefix: "fas",
  iconName: "dial-min",
  icon: [576, 512, [], "e161", "M288 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM400.9 401c-56.7 56.7-145.4 62-208 15.7L304.7 304.9c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L158.9 382.8c-46.2-62.6-41-151.3 15.7-208c62.5-62.5 163.8-62.5 226.3 0s62.5 163.8 0 226.3zM512 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM32 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 96a32 32 0 1 1 64 0A32 32 0 1 1 64 96zM480 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 480a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm416-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faRepeat = {
  prefix: "fas",
  iconName: "repeat",
  icon: [512, 512, [128257], "f363", "M0 224c0 17.7 14.3 32 32 32s32-14.3 32-32c0-53 43-96 96-96l160 0 0 32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9S320 19.1 320 32l0 32L160 64C71.6 64 0 135.6 0 224zm512 64c0-17.7-14.3-32-32-32s-32 14.3-32 32c0 53-43 96-96 96l-160 0 0-32c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6l0-32 160 0c88.4 0 160-71.6 160-160z"]
}, faCross = {
  prefix: "fas",
  iconName: "cross",
  icon: [384, 512, [128327, 10013], "f654", "M176 0c-26.5 0-48 21.5-48 48l0 80-80 0c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l80 0 0 208c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-208 80 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-80 0 0-80c0-26.5-21.5-48-48-48L176 0z"]
}, faPageCaretDown = {
  prefix: "fas",
  iconName: "page-caret-down",
  icon: [384, 512, ["file-caret-down"], "e429", "M320 512c35.3 0 64-28.7 64-64l0-309.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0zM192 352c-4.5 0-8.8-1.9-11.8-5.2l-75.7-82.6c-14.1-15.4-3.2-40.2 17.7-40.2l139.6 0c20.9 0 31.8 24.8 17.7 40.2l-75.7 82.6c-3 3.3-7.3 5.2-11.8 5.2z"]
}, faFileCaretDown = faPageCaretDown, faBox = {
  prefix: "fas",
  iconName: "box",
  icon: [448, 512, [128230], "f466", "M50.7 58.5L0 160l208 0 0-128L93.7 32C75.5 32 58.9 42.3 50.7 58.5zM240 160l208 0L397.3 58.5C389.1 42.3 372.5 32 354.3 32L240 32l0 128zm208 32L0 192 0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-224z"]
}, faVenusMars = {
  prefix: "fas",
  iconName: "venus-mars",
  icon: [640, 512, [9892], "f228", "M176 288a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM352 176c0 86.3-62.1 158.1-144 173.1l0 34.9 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-34.9C62.1 334.1 0 262.3 0 176C0 78.8 78.8 0 176 0s176 78.8 176 176zM271.9 360.6c19.3-10.1 36.9-23.1 52.1-38.4c20 18.5 46.7 29.8 76.1 29.8c61.9 0 112-50.1 112-112s-50.1-112-112-112c-7.2 0-14.3 .7-21.1 2c-4.9-21.5-13-41.7-24-60.2C369.3 66 384.4 64 400 64c37 0 71.4 11.4 99.8 31l20.6-20.6L487 41c-6.9-6.9-8.9-17.2-5.2-26.2S494.3 0 504 0L616 0c13.3 0 24 10.7 24 24l0 112c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-33.4-33.4L545 140.2c19.5 28.4 31 62.7 31 99.8c0 97.2-78.8 176-176 176c-50.5 0-96-21.3-128.1-55.4z"]
}, faClockSevenThirty = {
  prefix: "fas",
  iconName: "clock-seven-thirty",
  icon: [512, 512, [], "e351", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392l0-56.7-20 30c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l64-96c5.9-8.8 16.8-12.7 26.9-9.7s17 12.4 17 23l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]
}, faArrowPointer = {
  prefix: "fas",
  iconName: "arrow-pointer",
  icon: [320, 512, ["mouse-pointer"], "f245", "M0 55.2L0 426c0 12.2 9.9 22 22 22c6.3 0 12.4-2.7 16.6-7.5L121.2 346l58.1 116.3c7.9 15.8 27.1 22.2 42.9 14.3s22.2-27.1 14.3-42.9L179.8 320l118.1 0c12.2 0 22.1-9.9 22.1-22.1c0-6.3-2.7-12.3-7.4-16.5L38.6 37.9C34.3 34.1 28.9 32 23.2 32C10.4 32 0 42.4 0 55.2z"]
}, faMousePointer = faArrowPointer, faClockFourThirty = {
  prefix: "fas",
  iconName: "clock-four-thirty",
  icon: [512, 512, [], "e34b", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120l0-91.2L338.7 340c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3l-96-64c-7.4-4.9-16.8-5.4-24.6-1.2S232 247.1 232 256l0 136c0 13.3 10.7 24 24 24s24-10.7 24-24z"]
}, faSignalBarsGood = {
  prefix: "fas",
  iconName: "signal-bars-good",
  icon: [640, 512, ["signal-alt-3"], "f693", "M400 128c-26.5 0-48 21.5-48 48l0 288c0 26.5 21.5 48 48 48s48-21.5 48-48l0-288c0-26.5-21.5-48-48-48zM192 304l0 160c0 26.5 21.5 48 48 48s48-21.5 48-48l0-160c0-26.5-21.5-48-48-48s-48 21.5-48 48zM32 432l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48z"]
}, faSignalAlt3 = faSignalBarsGood, faCactus = {
  prefix: "fas",
  iconName: "cactus",
  icon: [512, 512, [127797], "f8a7", "M160 96c0-53 43-96 96-96s96 43 96 96l0 256 48 0c8.8 0 16-7.2 16-16l0-64c0-26.5 21.5-48 48-48s48 21.5 48 48l0 64c0 61.9-50.1 112-112 112l-48 0 0 16c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-144-48 0C50.1 320 0 269.9 0 208l0-64c0-26.5 21.5-48 48-48s48 21.5 48 48l0 64c0 8.8 7.2 16 16 16l48 0 0-128zm80 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 240a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]
}, faLightbulbGear = {
  prefix: "fas",
  iconName: "lightbulb-gear",
  icon: [576, 512, [], "e5fd", "M262.1 352.2c-11 7-19.1 18.6-21.4 31.8L112 384c-9.6-31.9-29.5-59.1-49.2-86.2c0 0 0 0 0 0c-5.2-7.1-10.4-14.2-15.4-21.4C27.6 247.9 16 213.3 16 176C16 78.8 94.8 0 192 0c97 0 175.6 78.4 176 175.3c-17.8 7.7-28 25.6-28 43.3l0 .9c-17.6-9.7-41.5-8.2-57.2 8.7c-9.2 9.9-17.4 20.9-24.4 33s-12.4 24.7-16.4 37.6c-6.7 21.6 3.4 42.7 20 53.3zM112 416l133.6 0c3.5 9.2 7.7 18.3 12.8 27c2.9 5 6 9.9 9.4 14.6C257.1 489.2 227.2 512 192 512c-44.2 0-80-35.8-80-80l0-16zm0-240c0-44.2 35.8-80 80-80c8.8 0 16-7.2 16-16s-7.2-16-16-16C130.1 64 80 114.1 80 176c0 8.8 7.2 16 16 16s16-7.2 16-16zm260 42.2c0-7 4.5-13.3 11.3-14.8c10.5-2.4 21.5-3.7 32.7-3.7s22.2 1.3 32.7 3.7c6.8 1.5 11.3 7.8 11.3 14.8l0 17.7c0 7.8 4.8 14.8 11.6 18.7c6.8 3.9 15.1 4.5 21.8 .6l13.8-7.9c6.1-3.5 13.7-2.7 18.5 2.4c7.6 8.1 14.3 17.2 20.1 27.2s10.3 20.4 13.5 31c2.1 6.7-1.1 13.7-7.2 17.2l-14.4 8.3c-6.5 3.7-10 10.9-10 18.4s3.5 14.7 10 18.4l14.4 8.3c6.1 3.5 9.2 10.5 7.2 17.2c-3.3 10.6-7.8 21-13.5 31s-12.5 19.1-20.1 27.2c-4.8 5.1-12.5 5.9-18.5 2.4l-13.8-7.9c-6.7-3.9-15.1-3.3-21.8 .6c-6.8 3.9-11.6 10.9-11.6 18.7l0 17.7c0 7-4.5 13.3-11.3 14.8c-10.5 2.4-21.5 3.7-32.7 3.7s-22.2-1.3-32.7-3.7c-6.8-1.5-11.3-7.8-11.3-14.8l0-17.4c0-7.9-4.9-14.9-11.7-18.9c-6.8-3.9-15.2-4.5-22-.6l-13.5 7.8c-6.1 3.5-13.7 2.7-18.5-2.4c-7.6-8.1-14.3-17.2-20.1-27.2s-10.3-20.4-13.5-31c-2.1-6.7 1.1-13.7 7.2-17.2l14-8.1c6.5-3.8 10.1-11.1 10.1-18.6s-3.5-14.8-10.1-18.6l-14-8.1c-6.1-3.5-9.2-10.5-7.2-17.2c3.3-10.6 7.7-21 13.5-31s12.5-19.1 20.1-27.2c4.8-5.1 12.4-5.9 18.5-2.4l13.6 7.8c6.8 3.9 15.2 3.3 22-.6c6.9-3.9 11.7-11 11.7-18.9l0-17.4zm92.1 133.5a48.1 48.1 0 1 0 -96.1 0 48.1 48.1 0 1 0 96.1 0z"]
}, faMaximize = {
  prefix: "fas",
  iconName: "maximize",
  icon: [512, 512, ["expand-arrows-alt"], "f31e", "M200 32L56 32C42.7 32 32 42.7 32 56l0 144c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2l40-40 79 79-79 79L73 295c-6.9-6.9-17.2-8.9-26.2-5.2S32 302.3 32 312l0 144c0 13.3 10.7 24 24 24l144 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-40-40 79-79 79 79-40 40c-6.9 6.9-8.9 17.2-5.2 26.2s12.5 14.8 22.2 14.8l144 0c13.3 0 24-10.7 24-24l0-144c0-9.7-5.8-18.5-14.8-22.2s-19.3-1.7-26.2 5.2l-40 40-79-79 79-79 40 40c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-144c0-13.3-10.7-24-24-24L312 32c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l40 40-79 79-79-79 40-40c6.9-6.9 8.9-17.2 5.2-26.2S209.7 32 200 32z"]
}, faExpandArrowsAlt = faMaximize, faChargingStation = {
  prefix: "fas",
  iconName: "charging-station",
  icon: [576, 512, [], "f5e7", "M96 0C60.7 0 32 28.7 32 64l0 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-144 16 0c22.1 0 40 17.9 40 40l0 32c0 39.8 32.2 72 72 72s72-32.2 72-72l0-123.7c32.5-10.2 56-40.5 56-76.3l0-32c0-8.8-7.2-16-16-16l-16 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-32 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-16 0c-8.8 0-16 7.2-16 16l0 32c0 35.8 23.5 66.1 56 76.3L472 376c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32c0-48.6-39.4-88-88-88l-16 0 0-192c0-35.3-28.7-64-64-64L96 0zM216.9 82.7c6 4 8.5 11.5 6.3 18.3l-25 74.9 57.8 0c6.7 0 12.7 4.2 15 10.4s.5 13.3-4.6 17.7l-112 96c-5.5 4.7-13.4 5.1-19.3 1.1s-8.5-11.5-6.3-18.3l25-74.9L96 208c-6.7 0-12.7-4.2-15-10.4s-.5-13.3 4.6-17.7l112-96c5.5-4.7 13.4-5.1 19.3-1.1z"]
}, faShapes = {
  prefix: "fas",
  iconName: "shapes",
  icon: [512, 512, ["triangle-circle-square"], "f61f", "M315.4 15.5C309.7 5.9 299.2 0 288 0s-21.7 5.9-27.4 15.5l-96 160c-5.9 9.9-6.1 22.2-.4 32.2s16.3 16.2 27.8 16.2l192 0c11.5 0 22.2-6.2 27.8-16.2s5.5-22.3-.4-32.2l-96-160zM288 312l0 144c0 22.1 17.9 40 40 40l144 0c22.1 0 40-17.9 40-40l0-144c0-22.1-17.9-40-40-40l-144 0c-22.1 0-40 17.9-40 40zM128 512a128 128 0 1 0 0-256 128 128 0 1 0 0 256z"]
}, faTriangleCircleSquare = faShapes, faPlaneTail = {
  prefix: "fas",
  iconName: "plane-tail",
  icon: [512, 512, [], "e22c", "M61.5 308.8L.8 39C-3.7 19 11.5 0 32 0l76.9 0c17.3 0 33.9 7 46 19.5L384 256l104 0 24 0 0 24 0 24 0 160 0 24 0 24-24 0-220.3 0c-10.7 0-21.2-1.9-31.2-5.7L40.4 431.9C16.1 422.7 0 399.4 0 373.4c0-28.2 18.8-52.8 45.9-60.3l15.5-4.3zM216 352c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0z"]
}, faGaugeSimpleMax = {
  prefix: "fas",
  iconName: "gauge-simple-max",
  icon: [512, 512, ["tachometer-fastest"], "f62b", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm320 96c0-3.7-.3-7.3-.9-10.8l117.5-72.8c11.3-7 14.7-21.8 7.8-33s-21.8-14.8-33-7.8L293.8 300.4C283.2 292.6 270.1 288 256 288c-35.3 0-64 28.7-64 64s28.7 64 64 64s64-28.7 64-64z"]
}, faTachometerFastest = faGaugeSimpleMax, faCircleU = {
  prefix: "fas",
  iconName: "circle-u",
  icon: [512, 512, [], "e127", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM192 168l0 120c0 35.3 28.7 64 64 64s64-28.7 64-64l0-120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 120c0 61.9-50.1 112-112 112s-112-50.1-112-112l0-120c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faShieldSlash = {
  prefix: "fas",
  iconName: "shield-slash",
  icon: [640, 512, [], "e24b", "M320 0c4.6 0 9.2 1 13.4 2.9L521.7 82.8c22 9.3 38.4 31 38.3 57.2c-.3 58.7-14.7 146.2-62.1 225L630.8 469.1c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2S28.4-3.1 38.8 5.1L131 77.4 306.7 2.9C310.8 1 315.4 0 320 0zM80.6 159.5L437.5 440.7c-25.2 24-55.3 45.4-91.1 62.5c-16.7 8-36.1 8-52.8 0C132 425.8 86.1 261.5 80.6 159.5z"]
}, faSquarePhoneHangup = {
  prefix: "fas",
  iconName: "square-phone-hangup",
  icon: [448, 512, ["phone-square-down"], "e27a", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM359.4 310c-5.3 8.6-16.8 12.3-26.7 8.5l-46.2-17.6c-8.7-3.3-14.1-11.6-13.1-20.3l2.9-26.7c-33.8-10.8-70.8-10.8-104.6 0l2.9 26.7c.9 8.7-4.4 16.9-13.1 20.3l-46.2 17.6c-9.9 3.8-21.4 .2-26.7-8.5L66.8 274.8C62 267 63.4 257.3 70.3 251c84.9-78.6 222.6-78.6 307.5 0c6.8 6.3 8.2 16.1 3.4 23.8L359.4 310z"]
}, faPhoneSquareDown = faSquarePhoneHangup, faArrowUpLeft = {
  prefix: "fas",
  iconName: "arrow-up-left",
  icon: [384, 512, [], "e09d", "M64 96c-17.7 0-32 14.3-32 32l0 224c0 17.7 14.3 32 32 32s32-14.3 32-32l0-146.7L297.4 406.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L141.3 160 288 160c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 96z"]
}, faTransporter1 = {
  prefix: "fas",
  iconName: "transporter-1",
  icon: [512, 512, [], "e043", "M256 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM128 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-88 0-80 0-88 0zM383.7 288c-9.3-.1-18.5-4.2-24.7-12l-31-38.7 0 50.7-144 0 0-50.7L153 276c-6.3 7.8-15.4 11.9-24.7 12l-.3 0s0 0 0 0c-7 0-14.1-2.3-20-7c-13.8-11.1-16-31.2-5-45l57.7-72c18.2-22.7 45.8-36 74.9-36l40.7 0c29.1 0 56.7 13.2 74.9 36L409 236c11 13.8 8.8 33.9-5 45c-5.9 4.7-13 7-20 7c0 0 0 0 0 0l-.3 0zm-327 38.6L64 352l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L64 384l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L32 384 6.6 376.7C2.7 375.6 0 372.1 0 368s2.7-7.6 6.6-8.7L32 352l7.3-25.4c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6zM480 160l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L480 192l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L448 192l-25.4-7.3c-3.9-1.1-6.6-4.7-6.6-8.7s2.7-7.6 6.6-8.7L448 160l7.3-25.4c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6L480 160zM176 320l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faPeanuts = {
  prefix: "fas",
  iconName: "peanuts",
  icon: [640, 512, [129372], "e431", "M119.7 506.3c-33.1 14.7-71.8-.2-86.6-33.2L10.5 422.2C3.8 407.2 .4 391.5 0 376c-.4-15.5 2.2-31.3 8-46.6C14 314 22.7 300.5 33.4 289.3c5.8-6.1 12.3-11.7 19.5-16.6c16.7-11.8 32.5-25.8 39.8-44.9s5-40.1 .4-60c-2.1-8.4-3.2-17-3.4-25.4c-.4-15.4 2.1-31.1 7.9-46.4l.2-.5c5.9-15.3 14.5-28.7 25.2-39.9c10.7-11.2 23.6-20.6 38.7-27.3L212.6 5.7c33.1-14.7 71.8 .1 86.6 33.2l22.6 50.7c-3.6 10.8-6.5 22.2-8.8 31.5c0 0 0 0 0 0c-1.2 4.6-2.2 8.8-3.1 12.1c-4.2 14.8-8.7 24.6-16.3 32.2s-17.4 12.1-32.2 16.3c-3.4 1-7.5 2-12.1 3.1c-12.5 3.1-28.5 7.1-42 12.7c-21.3 8.8-41.2 21.9-58.4 39.1C114.3 271.1 96 315.4 96 364l0 68c0 27.8 10.2 53.3 27 72.9l-3.2 1.4zM492 0l68 0c44.2 0 80 35.8 80 80l0 68c0 40.6-16.4 77.4-42.9 104.2l-.9 .9c-14.1 14-30.3 24.6-47.6 31.7c-9.5 4-19.6 6.9-30 8.8c-24.5 4.8-49.1 12.6-66.7 30.3s-25.4 42.2-30.3 66.7c-1.9 10.4-4.9 20.5-8.8 30c-7.1 17.1-17.5 33.2-31.3 47.2c-.6 .6-1.1 1.1-1.7 1.7C353.1 495.8 316.5 512 276 512l-68 0c-44.2 0-80-35.8-80-80l0-68c0-20.1 4-39.2 11.2-56.7c7.2-17.5 17.9-33.8 32.1-48c14.2-14.2 30.6-24.9 48.1-32.1c9.5-4 19.6-6.9 30-8.8c24.5-4.8 49.1-12.6 66.7-30.3s25.4-42.2 30.3-66.7c1.9-10.4 4.9-20.5 8.8-30C362.4 74 373 57.8 387.1 43.6l.4-.4c14.2-14.1 30.5-24.8 47.8-32C452.8 4 471.9 0 492 0zm52 147.2a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zm0 64a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zm-64 0a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zm-224 224a19.2 19.2 0 1 0 0-38.4 19.2 19.2 0 1 0 0 38.4zM339.2 416a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0zm0-64a19.2 19.2 0 1 0 -38.4 0 19.2 19.2 0 1 0 38.4 0z"]
}, faShuffle = {
  prefix: "fas",
  iconName: "shuffle",
  icon: [512, 512, [128256, "random"], "f074", "M403.8 34.4c12-5 25.7-2.2 34.9 6.9l64 64c6 6 9.4 14.1 9.4 22.6s-3.4 16.6-9.4 22.6l-64 64c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6l0-32-32 0c-10.1 0-19.6 4.7-25.6 12.8L284 229.3 244 176l31.2-41.6C293.3 110.2 321.8 96 352 96l32 0 0-32c0-12.9 7.8-24.6 19.8-29.6zM164 282.7L204 336l-31.2 41.6C154.7 401.8 126.2 416 96 416l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c10.1 0 19.6-4.7 25.6-12.8L164 282.7zm274.6 188c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6l0-32-32 0c-30.2 0-58.7-14.2-76.8-38.4L121.6 172.8c-6-8.1-15.5-12.8-25.6-12.8l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c30.2 0 58.7 14.2 76.8 38.4L326.4 339.2c6 8.1 15.5 12.8 25.6 12.8l32 0 0-32c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l64 64c6 6 9.4 14.1 9.4 22.6s-3.4 16.6-9.4 22.6l-64 64z"]
}, faRandom = faShuffle, faPersonRunning = {
  prefix: "fas",
  iconName: "person-running",
  icon: [448, 512, [127939, "running"], "f70c", "M320 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM125.7 175.5c9.9-9.9 23.4-15.5 37.5-15.5c1.9 0 3.8 .1 5.6 .3L137.6 254c-9.3 28 1.7 58.8 26.8 74.5l86.2 53.9-25.4 88.8c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22l28.7-100.4c5.9-20.6-2.6-42.6-20.7-53.9L238 299l30.9-82.4 5.1 12.3C289 264.7 323.9 288 362.7 288l21.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-21.3 0c-12.9 0-24.6-7.8-29.5-19.7l-6.3-15c-14.6-35.1-44.1-61.9-80.5-73.1l-48.7-15c-11.1-3.4-22.7-5.2-34.4-5.2c-31 0-60.8 12.3-82.7 34.3L57.4 153.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l23.1-23.1zM91.2 352L32 352c-17.7 0-32 14.3-32 32s14.3 32 32 32l69.6 0c19 0 36.2-11.2 43.9-28.5L157 361.6l-9.5-6c-17.5-10.9-30.5-26.8-37.9-44.9L91.2 352z"]
}, faRunning = faPersonRunning, faMobileRetro = {
  prefix: "fas",
  iconName: "mobile-retro",
  icon: [320, 512, [], "e527", "M0 64C0 28.7 28.7 0 64 0L256 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm64 96l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L96 128c-17.7 0-32 14.3-32 32zM80 352a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 56a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56-56a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 56a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56-56a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 56a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM128 48c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0z"]
}, faGripLinesVertical = {
  prefix: "fas",
  iconName: "grip-lines-vertical",
  icon: [192, 512, [], "f7a5", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32L64 64zm128 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384z"]
}, faBinBottlesRecycle = {
  prefix: "fas",
  iconName: "bin-bottles-recycle",
  icon: [640, 512, [], "e5f6", "M152 0c-13.3 0-24 10.7-24 24l0 8c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l0-8c0-13.3-10.7-24-24-24L152 0zM32 192l320 0c0-26.5-10.7-50.5-28.1-67.9c-1.1-1.1-2.1-2.1-3.2-3.1c-17.1-15.5-39.7-25-64.6-25L128 96c-53 0-96 43-96 96zm352 0l191.1 0c-1.2-9.7-4.6-18.7-9.6-26.5c6.4-9.5 10.1-21 10.1-33.3c0-23.2-13.4-44.3-34.4-54.2L528 71.8c-5.3-2.5-10.8-4.4-16.4-5.7l0-42.1c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24l0 42.1c-5.6 1.3-11.1 3.2-16.4 5.7L354.1 78c-7.2 3.4-13.5 8-18.6 13.6C365 115.1 384 151.3 384 192zM32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32L56.2 457c4.5 31.5 31.5 55 63.4 55l401 0c31.8 0 58.9-23.4 63.4-55L608 288c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 224zM308.5 326.1l-7.6 11.4c-4.8 7.2-14.5 9.3-21.8 4.7c-7.6-4.8-9.8-14.9-4.8-22.4l7.6-11.4c8.5-12.7 22.8-20.4 38.1-20.4c15.4 0 29.8 7.7 38.2 20.6l8.5 12.9c4.9 7.5 2.7 17.6-4.9 22.4c-7.4 4.6-17.1 2.5-21.8-4.8l-8.5-12.9c-2.6-3.9-6.9-6.2-11.5-6.2c-4.6 0-8.9 2.3-11.5 6.1zm-43.1 64.7l-7.9 11.9c-.9 1.4-1.4 3.1-1.4 4.7c0 4.7 3.8 8.6 8.6 8.6l25.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-25.2 0c-22.4 0-40.6-18.2-40.6-40.6c0-8 2.4-15.8 6.8-22.5l7.9-11.9c4.8-7.2 14.5-9.3 21.8-4.7c7.6 4.8 9.8 14.9 4.8 22.4zM353.7 416l20.9 0c4.8 0 8.6-3.9 8.6-8.6c0-1.7-.5-3.3-1.4-4.7l-6.6-10.1c-4.9-7.5-2.7-17.6 4.9-22.4c7.4-4.6 17.1-2.5 21.8 4.8l6.6 10.1c4.4 6.6 6.7 14.4 6.7 22.4c0 22.4-18.2 40.6-40.6 40.6l-20.9 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faArrowUpFromSquare = {
  prefix: "fas",
  iconName: "arrow-up-from-square",
  icon: [512, 512, [], "e09c", "M278.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L224 109.3 224 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96zM64 112c0-8.8 7.2-16 16-16l8 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-8 0C35.8 32 0 67.8 0 112L0 432c0 44.2 35.8 80 80 80l352 0c44.2 0 80-35.8 80-80l0-320c0-44.2-35.8-80-80-80l-8 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l8 0c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L80 448c-8.8 0-16-7.2-16-16l0-320z"]
}, faFileDashedLine = {
  prefix: "fas",
  iconName: "file-dashed-line",
  icon: [640, 512, ["page-break"], "f877", "M128 64c0-35.3 28.7-64 64-64L352 0l0 128c0 17.7 14.3 32 32 32l128 0 0 96-384 0 0-192zm0 304l384 0 0 80c0 35.3-28.7 64-64 64l-256 0c-35.3 0-64-28.7-64-64l0-80zM512 128l-128 0L384 0 512 128zM56 288l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L56 336c-13.3 0-24-10.7-24-24s10.7-24 24-24zm224 0l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm192 0l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faPageBreak = faFileDashedLine, faBracketCurlyRight = {
  prefix: "fas",
  iconName: "bracket-curly-right",
  icon: [256, 512, [], "7d", "M192 128c0-53-43-96-96-96L64 32C46.3 32 32 46.3 32 64s14.3 32 32 32l32 0c17.7 0 32 14.3 32 32l0 37.5c0 25.5 10.1 49.9 28.1 67.9L178.7 256l-22.6 22.6c-18 18-28.1 42.4-28.1 67.9l0 37.5c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0c53 0 96-43 96-96l0-37.5c0-8.5 3.4-16.6 9.4-22.6l45.3-45.3c12.5-12.5 12.5-32.8 0-45.3l-45.3-45.3c-6-6-9.4-14.1-9.4-22.6l0-37.5z"]
}, faSpider = {
  prefix: "fas",
  iconName: "spider",
  icon: [512, 512, [128375], "f717", "M158.4 32.6c4.8-12.4-1.4-26.3-13.8-31s-26.3 1.4-31 13.8L81.1 100c-7.9 20.7-3 44.1 12.7 59.7l57.4 57.4L70.8 190.3c-2.4-.8-4.3-2.7-5.1-5.1L46.8 128.4C42.6 115.8 29 109 16.4 113.2S-3 131 1.2 143.6l18.9 56.8c5.6 16.7 18.7 29.8 35.4 35.4L116.1 256 55.6 276.2c-16.7 5.6-29.8 18.7-35.4 35.4L1.2 368.4C-3 381 3.8 394.6 16.4 398.8s26.2-2.6 30.4-15.2l18.9-56.8c.8-2.4 2.7-4.3 5.1-5.1l80.4-26.8L93.7 352.3C78.1 368 73.1 391.4 81.1 412l32.5 84.6c4.8 12.4 18.6 18.5 31 13.8s18.5-18.6 13.8-31l-32.5-84.6c-1.1-3-.4-6.3 1.8-8.5L160 353.9c1 52.1 43.6 94.1 96 94.1s95-41.9 96-94.1l32.3 32.3c2.2 2.2 2.9 5.6 1.8 8.5l-32.5 84.6c-4.8 12.4 1.4 26.3 13.8 31s26.3-1.4 31-13.8L430.9 412c7.9-20.7 3-44.1-12.7-59.7l-57.4-57.4 80.4 26.8c2.4 .8 4.3 2.7 5.1 5.1l18.9 56.8c4.2 12.6 17.8 19.4 30.4 15.2s19.4-17.8 15.2-30.4l-18.9-56.8c-5.6-16.7-18.7-29.8-35.4-35.4L395.9 256l60.5-20.2c16.7-5.6 29.8-18.7 35.4-35.4l18.9-56.8c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-18.9 56.8c-.8 2.4-2.7 4.3-5.1 5.1l-80.4 26.8 57.4-57.4c15.6-15.6 20.6-39 12.7-59.7L398.4 15.4C393.6 3 379.8-3.2 367.4 1.6s-18.5 18.6-13.8 31l32.5 84.6c1.1 3 .4 6.3-1.8 8.5L336 174.1l0-14.1c0-31.8-18.6-59.3-45.5-72.2c-9.1-4.4-18.5 3.3-18.5 13.4l0 10.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-10.8c0-10.1-9.4-17.7-18.5-13.4C194.6 100.7 176 128.2 176 160l0 14.1-48.3-48.3c-2.2-2.2-2.9-5.6-1.8-8.5l32.5-84.6z"]
}, faClockThree = {
  prefix: "fas",
  iconName: "clock-three",
  icon: [512, 512, [], "e356", "M256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zM232 120l0 136c0 13.3 10.7 24 24 24l104 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24z"]
}, faHandsBound = {
  prefix: "fas",
  iconName: "hands-bound",
  icon: [640, 512, [], "e4f9", "M96 32C96 14.3 81.7 0 64 0S32 14.3 32 32l0 64 0 59.1 0 .7L32 192l0 21.9c0 14.2 5.1 27.9 14.3 38.7L131.6 352l-3.6 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 128 0 64 0 128 0 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-3.6 0 85.3-99.5c9.2-10.8 14.3-24.5 14.3-38.7l0-21.9 0-36.2 0-.7L608 96l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64 0 48.8-69.3 92.4c-5.7 7.6-16.1 9.6-24.2 4.8c-9.7-5.7-12.1-18.7-5.1-27.5L473 180c10.8-13.5 8.9-33.3-4.4-44.5s-33-9.8-44.5 3.2l-46.7 52.5C361 209.7 352 233.4 352 258.1l0 61.9 0 32-64 0 0-32 0-61.9c0-24.6-9-48.4-25.4-66.8l-46.7-52.5c-11.5-13-31.3-14.4-44.5-3.2s-15.2 30.9-4.4 44.5l27.6 34.5c7 8.8 4.7 21.8-5.1 27.5c-8.1 4.8-18.6 2.7-24.2-4.8L96 144.8 96 96l0-64zm64 448l0 32 128 0 0-32 64 0 0 32 128 0 0-32 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0-128 0-64 0-128 0-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0z"]
}, faScalpelLineDashed = {
  prefix: "fas",
  iconName: "scalpel-line-dashed",
  icon: [576, 512, ["scalpel-path"], "f61e", "M441.4 0c-20.8 0-40.6 9.2-54 25.1L187.8 261.7c-4 4.8-4.9 11.4-2.3 17.1s8.3 9.3 14.5 9.3l132.6 0c14.1 0 27.6-6.2 36.7-17L494.4 122.7C505.8 109.2 512 92.2 512 74.6l0-4C512 31.6 480.4 0 441.4 0zM164.7 324.7l-160 160c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9c18.1 0 84.1-8.4 145.9-33.1C222.5 454.6 288 410.9 288 336l0-16-16 0-96 0-6.6 0-4.7 4.7zM304 480l-64 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16zm64 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0zm128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0z"]
}, faScalpelPath = faScalpelLineDashed, faFileInvoiceDollar = {
  prefix: "fas",
  iconName: "file-invoice-dollar",
  icon: [384, 512, [], "f571", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM64 80c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 96c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16zm128 72c8.8 0 16 7.2 16 16l0 17.3c8.5 1.2 16.7 3.1 24.1 5.1c8.5 2.3 13.6 11 11.3 19.6s-11 13.6-19.6 11.3c-11.1-3-22-5.2-32.1-5.3c-8.4-.1-17.4 1.8-23.6 5.5c-5.7 3.4-8.1 7.3-8.1 12.8c0 3.7 1.3 6.5 7.3 10.1c6.9 4.1 16.6 7.1 29.2 10.9l.5 .1s0 0 0 0s0 0 0 0c11.3 3.4 25.3 7.6 36.3 14.6c12.1 7.6 22.4 19.7 22.7 38.2c.3 19.3-9.6 33.3-22.9 41.6c-7.7 4.8-16.4 7.6-25.1 9.1l0 17.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-17.8c-11.2-2.1-21.7-5.7-30.9-8.9c0 0 0 0 0 0c-2.1-.7-4.2-1.4-6.2-2.1c-8.4-2.8-12.9-11.9-10.1-20.2s11.9-12.9 20.2-10.1c2.5 .8 4.8 1.6 7.1 2.4c0 0 0 0 0 0s0 0 0 0s0 0 0 0c13.6 4.6 24.6 8.4 36.3 8.7c9.1 .3 17.9-1.7 23.7-5.3c5.1-3.2 7.9-7.3 7.8-14c-.1-4.6-1.8-7.8-7.7-11.6c-6.8-4.3-16.5-7.4-29-11.2l-1.6-.5s0 0 0 0c-11-3.3-24.3-7.3-34.8-13.7c-12-7.2-22.6-18.9-22.7-37.3c-.1-19.4 10.8-32.8 23.8-40.5c7.5-4.4 15.8-7.2 24.1-8.7l0-17.3c0-8.8 7.2-16 16-16z"]
}, faPipeSmoking = {
  prefix: "fas",
  iconName: "pipe-smoking",
  icon: [640, 512, [], "e3c4", "M575.2 64c-32.1 0-62.1 16-79.9 42.7l-61.8 92.7c-3.9-4.8-8.6-9.1-14-12.7l-24-16c-4.7-3.2-9.7-5.6-14.9-7.4L442 71.2C471.7 26.7 521.7 0 575.2 0L608 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32.8 0zM333.4 206.2c9.8-14.7 29.7-18.7 44.4-8.9l24 16c14.7 9.8 18.7 29.7 8.9 44.4L287.8 442.1C258.6 485.8 209.6 512 157.1 512C70.3 512 0 441.7 0 354.9L0 272c0-26.5 21.5-48 48-48l160 0c26.5 0 48 21.5 48 48l0 50.3 77.4-116.1z"]
}, faFaceAstonished = {
  prefix: "fas",
  iconName: "face-astonished",
  icon: [512, 512, [], "e36b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-208c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48zM144.4 224a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM192 128c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16zm141 .9c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8z"]
}, faWindow = {
  prefix: "fas",
  iconName: "window",
  icon: [512, 512, [], "f40e", "M512 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-320zM96 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM288 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faPlaneCircleExclamation = {
  prefix: "fas",
  iconName: "plane-circle-exclamation",
  icon: [640, 512, [], "e556", "M256 0c-35 0-64 59.5-64 93.7l0 84.6L8.1 283.4c-5 2.8-8.1 8.2-8.1 13.9l0 65.5c0 10.6 10.2 18.3 20.4 15.4l171.6-49 0 70.9-57.6 43.2c-4 3-6.4 7.8-6.4 12.8l0 42c0 7.8 6.3 14 14 14c1.3 0 2.6-.2 3.9-.5L256 480l110.1 31.5c1.3 .4 2.6 .5 3.9 .5c6 0 11.1-3.7 13.1-9C344.5 470.7 320 422.2 320 368c0-60.6 30.6-114 77.1-145.6L320 178.3l0-84.6C320 59.5 292 0 256 0zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0-144c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]
}, faEar = {
  prefix: "fas",
  iconName: "ear",
  icon: [384, 512, [128066], "f5f0", "M319.9 335.2c-18.2 16.3-30 39.1-35.1 62.9c-5.6 26.3-18.6 51.3-39 71.7c-56.2 56.2-147.4 56.2-203.6 0C14.1 441.7 0 404.9 0 368L0 192C0 86 86 0 192 0S384 86 384 192c0 56.9-24.8 108-64.1 143.2zM128 192c0-35.3 28.7-64 64-64s64 28.7 64 64l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-61.9-50.1-112-112-112S80 130.1 80 192l0 20.2c0 21.2 12 40.6 31 50.1l14 7c1.8 .9 3 2.8 3 4.9c0 1.6-.7 3.2-2 4.2L88.6 309.6c-10.2 8.5-11.6 23.6-3.1 33.8s23.6 11.6 33.8 3.1l37.4-31.2C169 305.1 176 290.1 176 274.2c0-20.2-11.4-38.8-29.5-47.8l-14-7c-2.7-1.4-4.4-4.1-4.4-7.2l0-20.2z"]
}, faFileLock = {
  prefix: "fas",
  iconName: "file-lock",
  icon: [576, 512, [], "e3a6", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 33.6c-19.8 20.2-32 47.9-32 78.4l0 24.6c-19.1 11.1-32 31.7-32 55.4l0 128c0 11.4 3 22.2 8.3 31.5c-2.7 .3-5.5 .5-8.3 .5L64 512c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zm80 112c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l0-48z"]
}, faDiagramVenn = {
  prefix: "fas",
  iconName: "diagram-venn",
  icon: [640, 512, [], "e15a", "M256 412.8C216.4 372.4 192 317 192 256s24.4-116.4 64-156.8C245.7 97.1 235 96 224 96C135.6 96 64 167.6 64 256s71.6 160 160 160c11 0 21.7-1.1 32-3.2zm64 45.7c-29.1 13.8-61.6 21.6-96 21.6C100.3 480 0 379.7 0 256S100.3 32 224 32c34.4 0 66.9 7.7 96 21.6C349.1 39.7 381.6 32 416 32c123.7 0 224 100.3 224 224s-100.3 224-224 224c-34.4 0-66.9-7.7-96-21.6zM370.7 192l-101.4 0c-6.5 14.9-10.8 31.1-12.5 48l126.4 0c-1.7-16.9-6-33.1-12.5-48zM269.3 320l101.4 0c6.5-14.9 10.8-31.1 12.5-48l-126.4 0c1.7 16.9 6 33.1 12.5 48zM288 352c9.1 12.1 19.9 22.9 32 32c12.1-9.1 22.9-19.9 32-32l-64 0zm64-192c-9.1-12.1-19.9-22.9-32-32c-12.1 9.1-22.9 19.9-32 32l64 0z"]
}, faArrowDownFromBracket = {
  prefix: "fas",
  iconName: "arrow-down-from-bracket",
  icon: [448, 512, [], "e667", "M246.6 502.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L192 402.7 192 192c0-17.7 14.3-32 32-32s32 14.3 32 32l0 210.7 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-128 128zM64 160c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 96C0 43 43 0 96 0L352 0c53 0 96 43 96 96l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7-14.3-32-32-32L96 64C78.3 64 64 78.3 64 96l0 64z"]
}, faXRay = {
  prefix: "fas",
  iconName: "x-ray",
  icon: [512, 512, [], "f497", "M0 64C0 46.3 14.3 32 32 32l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 320c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32L32 96C14.3 96 0 81.7 0 64zM256 96c-8.8 0-16 7.2-16 16l0 32-80 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l80 0 0 48-112 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l112 0 0 70.6L189.1 307c-5.2-2-10.6-3-16.2-3l-2.1 0c-23.6 0-42.8 19.2-42.8 42.8c0 9.6 3.2 18.9 9.1 26.4l18.2 23.2c9.7 12.4 24.6 19.6 40.3 19.6l120.8 0c15.7 0 30.6-7.2 40.3-19.6l18.2-23.2c5.9-7.5 9.1-16.8 9.1-26.4c0-23.6-19.2-42.8-42.8-42.8l-2.2 0c-5.5 0-11 1-16.2 3L272 326.6l0-70.6 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-112 0 0-48 80 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-80 0 0-32c0-8.8-7.2-16-16-16zM208 352a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]
}, faGoalNet = {
  prefix: "fas",
  iconName: "goal-net",
  icon: [640, 512, [], "e3ab", "M64 128c0-17.7 14.3-32 32-32l448 0c17.7 0 32 14.3 32 32l0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-53-43-96-96-96L96 32C43 32 0 75 0 128L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320zm112 0c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 64-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 64-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 64 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 64 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 64 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-64 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-64 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-64 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-64 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-64 0 0-48c0-8.8-7.2-16-16-16zm80 256l-64 0 0-64 64 0 0 64zm96 0l-64 0 0-64 64 0 0 64zm96 0l-64 0 0-64 64 0 0 64zm0-96l-64 0 0-64 64 0 0 64zm-96 0l-64 0 0-64 64 0 0 64zm-96 0l-64 0 0-64 64 0 0 64z"]
}, faCoffinCross = {
  prefix: "fas",
  iconName: "coffin-cross",
  icon: [384, 512, [], "e051", "M102.4 10.9l-91 104C4.1 123.3 0 134.2 0 145.4c0 4.4 .6 8.7 1.8 12.9L97.3 488.9c4 13.7 16.5 23.1 30.7 23.1l127.9 0c14.3 0 26.8-9.4 30.7-23.1l95.5-330.6c1.2-4.2 1.8-8.5 1.8-12.9c0-11.2-4.1-22.1-11.5-30.6l-91-104C275.5 4 266.7 0 257.5 0l-131 0c-9.2 0-18 4-24.1 10.9zM216 120l0 40 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faOctopus = {
  prefix: "fas",
  iconName: "octopus",
  icon: [640, 512, [], "e688", "M207.8 359.6c-2.8 40.4-36.4 72.4-77.6 72.4c-36.7 0-68.3-25.6-76-61.5L47.5 339c-2.8-13-15.5-21.2-28.5-18.4S-2.2 336.1 .5 349l6.8 31.6c12.4 58 63.6 99.4 122.9 99.4c0 0 .1 0 .1 0l4.1 0c42.4 0 83.8-12.5 119-36l21.4-14.2c13.4-8.9 29.2-13.7 45.3-13.7s31.9 4.8 45.3 13.7L386.7 444c35.2 23.5 76.6 36 119 36l4.1 0c59.3 0 110.5-41.4 123-99.4l6.8-31.6c2.8-13-5.5-25.7-18.4-28.5s-25.7 5.5-28.5 18.4l-6.8 31.6c-7.7 35.8-39.4 61.5-76 61.5c-41.1 0-74.8-31.9-77.6-72.4c11.3 7.3 24.5 11.9 38.9 13c38.8 2.8 74.3-21.9 85.3-59.2l10.9-36.9c6.4-21.6 26.2-36.5 48.8-36.5c13.3 0 24-10.7 24-24s-10.7-24-24-24c-43.8 0-82.5 28.9-94.8 71l-10.8 36.9c-4.6 15.7-19.5 26-35.8 24.8c-20.5-1.5-35.3-20.3-31.7-40.6l19-109.3c1.5-8.4 2.2-17 2.2-25.6l0-5.2C464 64.5 399.5 0 320 0S176 64.5 176 144l0 5.2c0 8.6 .7 17.1 2.2 25.6l19 109.3c3.5 20.3-11.2 39.1-31.7 40.6c-16.3 1.2-31.2-9.2-35.8-24.8L118.8 263c-12.4-42.1-51-71-94.8-71c-13.3 0-24 10.7-24 24s10.7 24 24 24c22.6 0 42.4 14.9 48.8 36.5l10.9 36.9c11 37.3 46.5 62 85.3 59.2c14.4-1 27.7-5.7 38.9-13zM240 272a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm144-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faSpellCheck = {
  prefix: "fas",
  iconName: "spell-check",
  icon: [576, 512, [], "f891", "M112 0C99.1 0 87.4 7.8 82.5 19.7l-66.7 160-13.3 32c-6.8 16.3 .9 35 17.2 41.8s35-.9 41.8-17.2L66.7 224l90.7 0 5.1 12.3c6.8 16.3 25.5 24 41.8 17.2s24-25.5 17.2-41.8l-13.3-32-66.7-160C136.6 7.8 124.9 0 112 0zm18.7 160l-37.3 0L112 115.2 130.7 160zM256 32l0 96 0 96c0 17.7 14.3 32 32 32l80 0c44.2 0 80-35.8 80-80c0-23.1-9.8-43.8-25.4-58.4c6-11.2 9.4-24 9.4-37.6c0-44.2-35.8-80-80-80L288 0c-17.7 0-32 14.3-32 32zm96 64l-32 0 0-32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16zm-32 64l32 0 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0-32zM566.6 310.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L352 434.7l-73.4-73.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l96 96c12.5 12.5 32.8 12.5 45.3 0l192-192z"]
}, faLocationXmark = {
  prefix: "fas",
  iconName: "location-xmark",
  icon: [384, 512, ["map-marker-times", "map-marker-xmark"], "f60e", "M215.7 499.2C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192c0 87.4 117 243 168.3 307.2c12.3 15.3 35.1 15.3 47.4 0zM111 111c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z"]
}, faMapMarkerTimes = faLocationXmark, faMapMarkerXmark = faLocationXmark, faCircleQuarterStroke = {
  prefix: "fas",
  iconName: "circle-quarter-stroke",
  icon: [512, 512, [], "e5d3", "M64 256l160 0c17.7 0 32-14.3 32-32l0-160c106 0 192 86 192 192s-86 192-192 192S64 362 64 256zM0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256z"]
}, faLasso = {
  prefix: "fas",
  iconName: "lasso",
  icon: [576, 512, [], "f8c8", "M576 176c0 97.2-128.9 176-288 176c-13.2 0-26.3-.5-39-1.6c4.6 12.8 7 26.5 7 40.6c0 66.8-54.2 121-121 121l-71 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l71 0c31.5 0 57-25.5 57-57c0-21.6-12.2-41.3-31.5-51l-46.8-23.4 .2-.4C44.7 284.1 0 233.2 0 176C0 78.8 128.9 0 288 0S576 78.8 576 176zM288 288c123.7 0 224-50.1 224-112s-100.3-112-224-112S64 114.1 64 176s100.3 112 224 112z"]
}, faSlash = {
  prefix: "fas",
  iconName: "slash",
  icon: [640, 512, [], "f715", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]
}, faPersonToPortal = {
  prefix: "fas",
  iconName: "person-to-portal",
  icon: [512, 512, ["portal-enter"], "e022", "M272 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM163.2 160c-14.1 0-27.5 5.6-37.5 15.5l-23.1 23.1c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l23.1-23.1C102.4 108.3 132.2 96 163.2 96c11.7 0 23.3 1.7 34.4 5.2l48.7 15c36.4 11.2 65.9 38 80.5 73.1l6.3 15c3.6 8.7 10.9 15.2 19.6 18.1C357.8 96.9 391.4 0 432 0c44.2 0 80 114.6 80 256s-35.8 256-80 256c-40.9 0-74.6-98-79.4-224.5c-34.6-3.6-64.9-25.9-78.5-58.5l-5.1-12.3L238 299l56.7 35.4c18.1 11.3 26.6 33.3 20.7 53.9L286.8 488.8c-4.9 17-22.6 26.8-39.6 22s-26.8-22.6-22-39.6l25.4-88.8-86.2-53.9c-25.1-15.7-36.1-46.5-26.8-74.5l31.2-93.7c-1.9-.2-3.7-.3-5.6-.3zM109.5 310.7c7.4 18.1 20.4 33.9 37.9 44.9l9.5 6-11.5 25.9c-7.7 17.3-24.9 28.5-43.9 28.5L32 416c-17.7 0-32-14.3-32-32s14.3-32 32-32l59.2 0 18.3-41.3z"]
}, faPortalEnter = faPersonToPortal, faCalendarStar = {
  prefix: "fas",
  iconName: "calendar-star",
  icon: [448, 512, [], "f736", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 48 0c26.5 0 48 21.5 48 48l0 48L0 160l0-48C0 85.5 21.5 64 48 64l48 0 0-32c0-17.7 14.3-32 32-32zM0 192l448 0 0 272c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 192zm233.3 58.9c-3.8-7.7-14.8-7.7-18.7 0l-23.6 47.8-52.7 7.7c-8.5 1.2-11.9 11.7-5.8 17.7l38.2 37.2-9 52.5c-1.5 8.5 7.5 15 15.1 11L224 400l47.2 24.8c7.6 4 16.5-2.5 15.1-11l-9-52.5 38.2-37.2c6.2-6 2.8-16.5-5.8-17.7l-52.7-7.7-23.6-47.8z"]
}, faComputerMouse = {
  prefix: "fas",
  iconName: "computer-mouse",
  icon: [384, 512, [128433, "mouse"], "f8cc", "M0 192l176 0L176 0 160 0C71.6 0 0 71.6 0 160l0 32zm0 32L0 352c0 88.4 71.6 160 160 160l64 0c88.4 0 160-71.6 160-160l0-128-192 0L0 224zm384-32l0-32C384 71.6 312.4 0 224 0L208 0l0 192 176 0z"]
}, faMouse = faComputerMouse, faArrowRightToBracket = {
  prefix: "fas",
  iconName: "arrow-right-to-bracket",
  icon: [512, 512, ["sign-in"], "f090", "M352 96l64 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zm-9.4 182.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L242.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l210.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"]
}, faSignIn = faArrowRightToBracket, faPegasus = {
  prefix: "fas",
  iconName: "pegasus",
  icon: [576, 512, [], "f703", "M448 238.1l0-78.1 16 0 9.8 19.6c12.5 25.1 42.2 36.4 68.3 26c20.5-8.2 33.9-28 33.9-50.1L576 80c0-19.1-8.4-36.3-21.7-48l5.7 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L480 0 448 0C378.4 0 321.7 55.6 320 124.8L184.9 34.7c-4.9-3.3-11.2-3.6-16.4-.8s-8.5 8.2-8.5 14.1c0 48.1 3.8 99.9 26 139.8c9.2 16.6 21.7 31.3 38.2 42.7c-7.2-2.5-14-5.4-20.3-8.8c-22.5-12.1-38.6-29.4-49.9-49.8c-7.3-13.2-12.7-27.8-16.5-43c-25.9 3.5-48.1 18.6-61.1 40C33.2 174.5 0 211.4 0 256l0 56c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56c0-13.4 6.6-25.2 16.7-32.5c1.6 13 6.3 25.4 13.6 36.4l28.2 42.4c8.3 12.4 6.4 28.7-1.2 41.6c-16.5 28-20.6 62.2-10 93.9l17.5 52.4c4.4 13.1 16.6 21.9 30.4 21.9l33.7 0c21.8 0 37.3-21.4 30.4-42.1l-20.8-62.5c-2.1-6.4-.5-13.4 4.3-18.2l12.7-12.7c13.2-13.2 20.6-31.1 20.6-49.7c0-2.3-.1-4.6-.3-6.9l84 24c4.1 1.2 8.2 2.1 12.3 2.8L320 480c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-164.3c19.2-19.2 31.5-45.7 32-75.7c0 0 0 0 0 0l0-1.9zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faFilesMedical = {
  prefix: "fas",
  iconName: "files-medical",
  icon: [448, 512, [], "f7fd", "M160 0L320 0l0 96c0 17.7 14.3 32 32 32l96 0 0 224c0 35.3-28.7 64-64 64l-224 0c-35.3 0-64-28.7-64-64L96 64c0-35.3 28.7-64 64-64zM416 64l32 32-45.3 0L384 96l-32 0 0-32 0-18.7L352 0l32 32 32 32zM24 96c13.3 0 24 10.7 24 24l0 256c0 48.6 39.4 88 88 88l192 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-192 0C60.9 512 0 451.1 0 376L0 120c0-13.3 10.7-24 24-24zm216 80l0 48-48 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]
}, faCannon = {
  prefix: "fas",
  iconName: "cannon",
  icon: [640, 512, [], "e642", "M49.1 353.8L26.5 365.1C2.8 376.9-6.8 405.8 5.1 429.5s40.7 33.3 64.4 21.5L92 439.7c42.7 41.2 108.3 53.2 164.4 25.1c6.1-3.2 14.8-8.1 25.4-14.5C265.5 427 256 398.6 256 368c0-79.5 64.5-144 144-144c52.4 0 98.3 28 123.5 69.9c32.9-21.9 62.9-41.9 86-57.4c26.7-17.9 35.7-52.7 21.4-81.5L600.2 93.5c-14.4-28.7-47.7-42.4-78-31.8C414.8 99.3 177.1 183.2 127.6 207.2c-56.1 28-85.9 87.7-78.5 146.6zM400 480a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm0-144a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faNfcLock = {
  prefix: "fas",
  iconName: "nfc-lock",
  icon: [576, 512, [], "e1f8", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 65.1c-24.9 3.6-47.2 15.3-64 32.5l0-49.6c0-26.5-21.5-48-48-48l-80 0c-26.5 0-48 21.5-48 48l0 66.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3l0-66.7c0-8.8 7.2-16 16-16l80 0c8.8 0 16 7.2 16 16l0 128 0 24.6c-19.1 11.1-32 31.7-32 55.4l0 32-208 0c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-26.5 0-48 21.5-48 48l0 224c0 26.5 21.5 48 48 48l208 0 0 64L64 480c-35.3 0-64-28.7-64-64L0 96zM464 240c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l0-48z"]
}, faPersonSkiLift = {
  prefix: "fas",
  iconName: "person-ski-lift",
  icon: [512, 512, ["ski-lift"], "f7c8", "M240 0c8.8 0 16 7.2 16 16l0 182.3-32 8.5L224 16c0-8.8 7.2-16 16-16zM64 80a48 48 0 1 1 96 0A48 48 0 1 1 64 80zm36.4 138c-14.2-30.8 8.3-66 42.2-66c18.2 0 34.8 10.7 42.3 27.3l28.8 63.4 55.9-14.9c25.4-6.8 50.3 12.4 50.3 38.6l0 122.1L443.1 343c12.6-4.6 20.9-16.6 20.9-30l0-1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 1c0 33.5-20.9 63.4-52.3 75L128.3 510.5c-12.4 4.6-26.2-1.8-30.8-14.2s1.8-26.2 14.2-30.8L256 412.2l0-114.5-66.7 17.8c-22.6 6-46.2-5.1-55.9-26.3L100.4 218zM45.7 189.6l65 135.8c8.3 17.4 28 26.4 46.6 21.3l36.5-9.9c12.8-3.5 26 4.1 29.5 16.8s-4.1 26-16.8 29.5l-36.5 9.9c-41 11.2-84.2-8.6-102.5-46.9L2.3 210.4c-5.7-12-.7-26.3 11.3-32s26.3-.7 32 11.3z"]
}, faSkiLift = faPersonSkiLift, faSquare6 = {
  prefix: "fas",
  iconName: "square-6",
  icon: [448, 512, [], "e25b", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM224 240a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm-96 48c0 53 43 96 96 96s96-43 96-96c0-44-29.6-81.1-70-92.4l29.6-25.4c10.1-8.6 11.2-23.8 2.6-33.8s-23.8-11.2-33.8-2.6l-81.6 70C142.2 224.8 128 255.6 128 288z"]
}, faShopSlash = {
  prefix: "fas",
  iconName: "shop-slash",
  icon: [640, 512, ["store-alt-slash"], "e070", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-54.8-43L576 224l-64 0 0 152L384 275.7l0-51.7-64 0 0 1.5L277.2 192l325.9 0c20.3 0 36.8-16.5 36.8-36.8c0-7.3-2.2-14.4-6.2-20.4L558.2 21.4C549.3 8 534.4 0 518.3 0L121.7 0c-16 0-31 8-39.9 21.4L74.1 32.8 38.8 5.1zM36.8 192l85 0L21 112.5 6.2 134.7c-4 6.1-6.2 13.2-6.2 20.4C0 175.5 16.5 192 36.8 192zM320 384l-192 0 0-160-64 0 0 160 0 80c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-65.5-64-50.4 0 35.9z"]
}, faStoreAltSlash = faShopSlash, faWindTurbine = {
  prefix: "fas",
  iconName: "wind-turbine",
  icon: [512, 512, [], "f89b", "M315.7 414.8c9.1 14.8 32 6.5 29.5-10.7L316.9 212c-.5-3.4 .1-6.9 1.8-9.9L411 31.2c8.3-15.3-10.4-31-24-20.1L234.7 131.7c-2.7 2.1-6 3.4-9.5 3.5L31.1 140.6C13.7 141 9.5 165 25.7 171.4l180.6 71.5c3.2 1.3 5.9 3.5 7.7 6.5L315.7 414.8zM224 326.8L224 464l-72 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0 0-33.2-64-104zM256 168a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]
}, faSlidersSimple = {
  prefix: "fas",
  iconName: "sliders-simple",
  icon: [512, 512, [], "e253", "M96 320a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm90.5 0L480 320c17.7 0 32 14.3 32 32s-14.3 32-32 32l-293.5 0c-13.2 37.3-48.7 64-90.5 64c-53 0-96-43-96-96s43-96 96-96c41.8 0 77.4 26.7 90.5 64zM384 160a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm-58.5-32c13.2-37.3 48.7-64 90.5-64c53 0 96 43 96 96s-43 96-96 96c-41.8 0-77.4-26.7-90.5-64L32 192c-17.7 0-32-14.3-32-32s14.3-32 32-32l293.5 0z"]
}, faGridRound = {
  prefix: "fas",
  iconName: "grid-round",
  icon: [448, 512, [], "e5da", "M128 96A64 64 0 1 1 0 96a64 64 0 1 1 128 0zm0 160A64 64 0 1 1 0 256a64 64 0 1 1 128 0zM64 480a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM288 96A64 64 0 1 1 160 96a64 64 0 1 1 128 0zM224 320a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm64 96a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm96-256a64 64 0 1 1 0-128 64 64 0 1 1 0 128zm64 96a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM384 480a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"]
}, faBadgeSheriff = {
  prefix: "fas",
  iconName: "badge-sheriff",
  icon: [448, 512, [], "f8a2", "M272 48c0 14.8-6.7 28-17.2 36.8l25 42.8c5.7 9.8 16.2 15.8 27.5 15.9l47.6 .2c6.7-18.5 24.4-31.7 45.2-31.7c26.5 0 48 21.5 48 48s-21.5 48-48 48c-5.9 0-11.6-1.1-16.9-3.1L363 240.1c-5.6 9.8-5.6 21.9 0 31.8l20.1 35.2c5.3-2 10.9-3.1 16.9-3.1c26.5 0 48 21.5 48 48s-21.5 48-48 48c-20.8 0-38.5-13.2-45.2-31.7l-47.6 .2c-11.3 0-21.8 6.1-27.5 15.9l-25 42.8c10.5 8.8 17.2 22 17.2 36.8c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-14.8 6.7-28 17.2-36.8l-25-42.8c-5.7-9.8-16.2-15.8-27.5-15.9l-47.6-.2C86.5 386.8 68.8 400 48 400c-26.5 0-48-21.5-48-48s21.5-48 48-48c5.9 0 11.6 1.1 16.9 3.1L85 271.9c5.6-9.8 5.6-21.9 0-31.8L64.9 204.9c-5.3 2-10.9 3.1-16.9 3.1c-26.5 0-48-21.5-48-48s21.5-48 48-48c20.8 0 38.5 13.2 45.2 31.7l47.6-.2c11.3 0 21.8-6.1 27.5-15.9l25-42.8C182.7 76 176 62.8 176 48c0-26.5 21.5-48 48-48s48 21.5 48 48zM224 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]
}, faServer = {
  prefix: "fas",
  iconName: "server",
  icon: [512, 512, [], "f233", "M64 32C28.7 32 0 60.7 0 96l0 64c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64L64 32zm280 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm48 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM64 288c-35.3 0-64 28.7-64 64l0 64c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64L64 288zm280 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm56 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faVirusCovidSlash = {
  prefix: "fas",
  iconName: "virus-covid-slash",
  icon: [640, 512, [], "e4a9", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L472.1 344.7c11.4-19.5 19.1-41.4 22.3-64.7l33.6 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-33.6 0c-4.2-30.7-16.3-58.8-34.1-82.3L484 125.9l11.3 11.3c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L472.7 46.7c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L450.1 92l-23.8 23.8C402.8 97.9 374.7 85.8 344 81.6L344 48l16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L280 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0 0 33.6c-30.7 4.2-58.8 16.3-82.3 34.1L189.9 92l11.3-11.3c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L134.1 79.8 38.8 5.1zM149.2 213.5c-1.5 6-2.7 12.2-3.5 18.5L112 232l0-16c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16 33.6 0c4.2 30.7 16.3 58.8 34.1 82.3L156 386.1l-11.3-11.3c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56.6 56.6c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L189.9 420l23.8-23.8c23.5 17.9 51.7 29.9 82.3 34.1l0 33.6-16 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0-33.6c20.4-2.8 39.7-9.1 57.3-18.2L149.2 213.5z"]
}, faIntersection = {
  prefix: "fas",
  iconName: "intersection",
  icon: [384, 512, [8898], "f668", "M32 480c17.7 0 32-14.3 32-32l0-224c0-70.7 57.3-128 128-128s128 57.3 128 128l0 224c0 17.7 14.3 32 32 32s32-14.3 32-32l0-224c0-106-86-192-192-192S0 118 0 224L0 448c0 17.7 14.3 32 32 32z"]
}, faShopLock = {
  prefix: "fas",
  iconName: "shop-lock",
  icon: [640, 512, [], "e4a5", "M36.8 192l412.8 0c20.2-19.8 47.9-32 78.4-32c30.5 0 58.1 12.2 78.3 31.9c18.9-1.6 33.7-17.4 33.7-36.7c0-7.3-2.2-14.4-6.2-20.4L558.2 21.4C549.3 8 534.4 0 518.3 0L121.7 0c-16 0-31 8-39.9 21.4L6.2 134.7c-4 6.1-6.2 13.2-6.2 20.4C0 175.5 16.5 192 36.8 192zM384 224l-64 0 0 160-192 0 0-160-64 0 0 160 0 80c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-80 0-32 0-128zm144 16c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]
}, faFamily = {
  prefix: "fas",
  iconName: "family",
  icon: [512, 512, [], "e300", "M128 0a64 64 0 1 1 0 128A64 64 0 1 1 128 0zM105.6 160l44.8 0c9.2 0 18.1 1.6 26.4 4.5c-.5 3.8-.8 7.6-.8 11.5c0 24.3 10.9 46.1 28 60.8c-35.7 18.7-60 56.1-60 99.2l0 16c0 28.4 12.4 54 32 71.6l0 56.4c0 6.1 .8 11.9 2.4 17.5c-8.7 9-20.9 14.5-34.4 14.5l-32 0c-26.5 0-48-21.5-48-48l0-115.7c-26.5-9.5-44.7-35.8-42.2-65.6l4.1-49.3C29.3 191.9 64 160 105.6 160zM368 512c-13.5 0-25.7-5.6-34.4-14.5c1.6-5.6 2.4-11.4 2.4-17.5l0-56.4c19.6-17.6 32-43.1 32-71.6l0-16c0-43.1-24.3-80.5-60-99.2c17.1-14.7 28-36.5 28-60.8c0-2.4-.1-4.7-.3-7.1c9.6-5.7 20.8-8.9 32.6-8.9l31.4 0c28.6 0 53.7 18.9 61.5 46.4l39.1 136.8c5.8 20.4-9.5 40.8-30.8 40.8L448 384l0 80c0 26.5-21.5 48-48 48l-32 0zM384 0a64 64 0 1 1 0 128A64 64 0 1 1 384 0zM256 128a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm0 128c44.2 0 80 35.8 80 80l0 16c0 23.7-12.9 44.4-32 55.4l0 72.6c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-72.6c-19.1-11.1-32-31.7-32-55.4l0-16c0-44.2 35.8-80 80-80z"]
}, faHourglassStart = {
  prefix: "fas",
  iconName: "hourglass-start",
  icon: [384, 512, ["hourglass-1"], "f251", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l0 11c0 42.4 16.9 83.1 46.9 113.1L146.7 256 78.9 323.9C48.9 353.9 32 394.6 32 437l0 11c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 256 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-11c0-42.4-16.9-83.1-46.9-113.1L237.3 256l67.9-67.9c30-30 46.9-70.7 46.9-113.1l0-11c17.7 0 32-14.3 32-32s-14.3-32-32-32L320 0 64 0 32 0zM288 437l0 11L96 448l0-11c0-25.5 10.1-49.9 28.1-67.9L192 301.3l67.9 67.9c18 18 28.1 42.4 28.1 67.9z"]
}, faHourglass1 = faHourglassStart, faUserHairBuns = {
  prefix: "fas",
  iconName: "user-hair-buns",
  icon: [448, 512, [], "e3d3", "M304 128l0 16c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-16c0-5.5 .6-10.8 1.6-16l14.4 0c26.2 0 49.4-12.6 64-32c14.6 19.4 37.8 32 64 32l14.4 0c1 5.2 1.6 10.5 1.6 16zM84 192c7 0 13.7-1.6 19.6-4.6c17.8 49.3 65 84.6 120.4 84.6s102.7-35.3 120.4-84.6c5.9 2.9 12.5 4.6 19.6 4.6c24.3 0 44-19.7 44-44l0-40c0-24.3-19.7-44-44-44c-9.3 0-17.9 2.9-25 7.8C318.2 29.3 274.5 0 224 0s-94.2 29.3-115 71.8C101.9 66.9 93.3 64 84 64c-24.3 0-44 19.7-44 44l0 40c0 24.3 19.7 44 44 44zm77.3 128C72.2 320 0 392.2 0 481.3c0 17 13.8 30.7 30.7 30.7l386.6 0c17 0 30.7-13.8 30.7-30.7C448 392.2 375.8 320 286.7 320l-125.4 0z"]
}, faBlenderPhone = {
  prefix: "fas",
  iconName: "blender-phone",
  icon: [576, 512, [], "f6b6", "M224 352L196.8 52.3C194.2 24.2 216.3 0 244.6 0L534.1 0c21.1 0 36.4 20.1 30.9 40.4L558.5 64 400 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l149.8 0-17.5 64L400 160c-8.8 0-16 7.2-16 16s7.2 16 16 16l123.6 0-17.5 64L400 256c-8.8 0-16 7.2-16 16s7.2 16 16 16l97.5 0L480 352l-256 0zm-16 32l288 0c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48l-288 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48zm144 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM147.5 30.7c10.8 6.7 15.3 21 10.6 33.4l-22 57.8c-4.2 10.9-14.5 17.6-25.3 16.4l-33.3-3.6c-13.6 42.2-13.6 88.4 0 130.7l33.3-3.6c10.9-1.2 21.2 5.5 25.3 16.4l22 57.8c4.7 12.4 .2 26.7-10.6 33.4l-44 27.2c-9.7 6-21.9 4.2-29.8-4.3C-24.6 286-24.6 114 73.7 7.8C81.6-.7 93.8-2.5 103.5 3.5l44 27.2z"]
}, faHourglassClock = {
  prefix: "fas",
  iconName: "hourglass-clock",
  icon: [576, 512, [], "e41b", "M0 32C0 14.3 14.3 0 32 0L64 0 320 0l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 11c0 42.4-16.9 83.1-46.9 113.1L237.3 256l36 36c-10.7 22.2-16.8 47.1-17.2 73.3l-64-64-67.9 67.9c-18 18-28.1 42.4-28.1 67.9l0 11 179.2 0c13.1 25.6 32.2 47.6 55.6 64L320 512 64 512l-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l0-11c0-42.4 16.9-83.1 46.9-113.1L146.7 256 78.9 188.1C48.9 158.1 32 117.4 32 75l0-11C14.3 64 0 49.7 0 32zM96 64l0 11c0 25.5 10.1 49.9 28.1 67.9L192 210.7l67.9-67.9c18-18 28.1-42.4 28.1-67.9l0-11L96 64zM288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-48c0-8.8-7.2-16-16-16z"]
}, faPersonSeatReclined = {
  prefix: "fas",
  iconName: "person-seat-reclined",
  icon: [512, 512, [], "e21f", "M176 128a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm89 160l-8-32 63 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-79.2 0c-6.6-19-24.5-32-44.9-32c-30.9 0-53.6 29.1-46.1 59l21.1 84.5C178 332 203.6 352 233 352l6.3 0c.5 0 .9 0 1.4 0l78.1 0c6.7 0 12.6 4.1 15 10.4L370 459.2c6 16.1 23.8 24.6 40.1 19.1l48-16c16.8-5.6 25.8-23.7 20.2-40.5s-23.7-25.8-40.5-20.2l-18.7 6.2-25.5-68c-11.7-31.2-41.6-51.9-74.9-51.9L265 288zM95.5 154.1c-3.3-17.4-20-28.8-37.3-25.6s-28.8 20-25.6 37.3L65.9 343.6C77.2 404.1 130.1 448 191.7 448l80.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-80.3 0c-30.8 0-57.2-21.9-62.9-52.2L95.5 154.1z"]
}, faPaperPlaneTop = {
  prefix: "fas",
  iconName: "paper-plane-top",
  icon: [512, 512, ["paper-plane-alt", "send"], "e20a", "M57.6 35.8C23.1 20.6-11.3 57.4 6.1 90.9l63 121.2c4.4 8.4 12.6 14.1 22 15.3c0 0 0 0 0 0L266 249.3c3.4 .4 6 3.3 6 6.7s-2.6 6.3-6 6.7L91.1 284.6s0 0 0 0c-9.4 1.2-17.6 6.9-22 15.3L6.1 421.1c-17.4 33.5 17 70.2 51.6 55.1L492.9 285.3c25.5-11.2 25.5-47.4 0-58.6L57.6 35.8z"]
}, faPaperPlaneAlt = faPaperPlaneTop, faSend = faPaperPlaneTop, faMessageArrowUp = {
  prefix: "fas",
  iconName: "message-arrow-up",
  icon: [512, 512, ["comment-alt-arrow-up"], "e1dc", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM280 177.9l31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31L232 296c0 13.3 10.7 24 24 24s24-10.7 24-24l0-118.1z"]
}, faCommentAltArrowUp = faMessageArrowUp, faLightbulbExclamation = {
  prefix: "fas",
  iconName: "lightbulb-exclamation",
  icon: [384, 512, [], "f671", "M272 384c9.6-31.9 29.5-59.1 49.2-86.2c0 0 0 0 0 0c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C368 78.8 289.2 0 192 0S16 78.8 16 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4c0 0 0 0 0 0c19.8 27.1 39.7 54.4 49.2 86.2l160 0zM192 512c44.2 0 80-35.8 80-80l0-16-160 0 0 16c0 44.2 35.8 80 80 80zm0-448c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24zM160 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faLayerMinus = {
  prefix: "fas",
  iconName: "layer-minus",
  icon: [576, 512, ["layer-group-minus"], "f5fe", "M408 56c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L408 56zm-96.5 77.2c-14.9-6.9-32.1-6.9-47 0L45.9 234.2C37.4 238.1 32 246.6 32 256s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-218.6-101zm13.4 274.7c-23.4 10.8-50.4 10.8-73.8 0l-152-70.2L45.9 362.2C37.4 366.1 32 374.6 32 384s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-53.2-24.6-152 70.2z"]
}, faLayerGroupMinus = faLayerMinus, faChartPieSimpleCircleCurrency = {
  prefix: "fas",
  iconName: "chart-pie-simple-circle-currency",
  icon: [640, 512, [], "e604", "M496 192c4.6 0 9.3 .2 13.8 .5C494.5 83.7 401 0 288 0c-9 0-16 7.6-16 16.6L272 240l103.2 0c31.5-29.8 74-48 120.8-48zM320 368c0-28.8 6.9-56 19.2-80L224 288l0-221.3c0-18.5-15.7-33.3-33.8-29.5C81.5 60.1 0 156.5 0 272C0 404.6 107.5 512 240 512c43.8 0 84.8-11.7 120.1-32.2C335 449.4 320 410.5 320 368zm320 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM521.4 393.4a35.9 35.9 0 1 0 -50.7-50.7 35.9 35.9 0 1 0 50.7 50.7zm10 32.6c-21.6 13.2-49.1 13.2-70.7 0l-17.3 17.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L438 403.3c-13.2-21.6-13.2-49.1 0-70.7l-17.3-17.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L460.7 310c21.6-13.2 49.1-13.2 70.7 0l17.3-17.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L554 332.7c13.2 21.6 13.2 49.1 0 70.7l17.3 17.3c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L531.3 426z"]
}, faCircleE = {
  prefix: "fas",
  iconName: "circle-e",
  icon: [512, 512, [], "e109", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 56 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 56 120 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24l0-104 0-104c0-13.3 10.7-24 24-24z"]
}, faBuildingWheat = {
  prefix: "fas",
  iconName: "building-wheat",
  icon: [640, 512, [], "e4db", "M0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 416c0 26.5-21.5 48-48 48l-96 0 0-80c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 80-96 0c-26.5 0-48-21.5-48-48L0 48zM80 224c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm80 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm112-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM64 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L80 96c-8.8 0-16 7.2-16 16zM176 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zm80 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm384 80l0 16c0 44.2-35.8 80-80 80l-16 0 0-16c0-44.2 35.8-80 80-80l16 0zm0 128c0 44.2-35.8 80-80 80l-16 0 0-16c0-44.2 35.8-80 80-80l16 0 0 16zm0 112c0 44.2-35.8 80-80 80l-16 0 0-16c0-44.2 35.8-80 80-80l16 0 0 16zM512 496l0 16-16 0c-44.2 0-80-35.8-80-80l0-16 16 0c44.2 0 80 35.8 80 80zm0-96l-16 0c-44.2 0-80-35.8-80-80l0-16 16 0c44.2 0 80 35.8 80 80l0 16zm0-128l0 16-16 0c-44.2 0-80-35.8-80-80l0-16 16 0c44.2 0 80 35.8 80 80zM528 32c13.3 0 24 10.7 24 24l0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104c0-13.3 10.7-24 24-24zm96 64l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32c0-13.3 10.7-24 24-24s24 10.7 24 24zM456 72c13.3 0 24 10.7 24 24l0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32c0-13.3 10.7-24 24-24z"]
}, faGaugeMax = {
  prefix: "fas",
  iconName: "gauge-max",
  icon: [512, 512, ["tachometer-alt-fastest"], "f626", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64c0-3.7-.3-7.3-.9-10.8l117.5-72.8c11.3-7 14.7-21.8 7.8-33s-21.8-14.8-33-7.8L293.8 300.4C283.2 292.6 270.1 288 256 288c-35.3 0-64 28.7-64 64s28.7 64 64 64zM176 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faTachometerAltFastest = faGaugeMax, faPersonBreastfeeding = {
  prefix: "fas",
  iconName: "person-breastfeeding",
  icon: [448, 512, [], "e53a", "M224 0a80 80 0 1 1 0 160A80 80 0 1 1 224 0zM436.8 382.8L373.5 462c-16.6 20.7-46.8 24.1-67.5 7.5c-17.6-14.1-22.7-38.1-13.5-57.7l-.8-.1c-38.9-5.6-74.3-25.1-99.7-54.8l0-36.8c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 48c0 .8 0 1.6 .1 2.4l101.4 50.7c23.7 11.9 33.3 40.7 21.5 64.4s-40.7 33.3-64.4 21.5L27.2 427.3c-1.1-.5-2.2-1.1-3.3-1.7c-4.9-2.8-9.2-6.4-12.6-10.6c-4.6-5.4-7.8-11.7-9.6-18.4c-3.3-12-1.9-25.2 4.8-36.6c.6-1.1 1.3-2.2 2-3.2L75.6 256.1c26.7-40.1 71.7-64.1 119.8-64.1l75.2 0c46.5 0 90.1 22.5 117.2 60.3l50.7 70.9c2.2 3 4 6.1 5.5 9.4c2.9 6.7 4.3 13.8 4 20.8c-.3 10.6-4.2 21-11.2 29.4zM320 332a44 44 0 1 0 -88 0 44 44 0 1 0 88 0z"]
}, faApostrophe = {
  prefix: "fas",
  iconName: "apostrophe",
  icon: [192, 512, [], "27", "M72 352c66.3 0 120-53.7 120-120l0-72 0-32 0-32c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96l0 64c0 35.3 28.7 64 64 64l64 0 0 8c0 30.9-25.1 56-56 56l-8 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l8 0z"]
}, faFilePng = {
  prefix: "fas",
  iconName: "file-png",
  icon: [512, 512, [], "e666", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-208 0c-35.3 0-64 28.7-64 64l0 144-48 0c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zM318.3 360.8L352 428.2l0-60.2c0-8.8 7.2-16 16-16s16 7.2 16 16l0 128c0 7.4-5.1 13.9-12.3 15.6s-14.7-1.8-18-8.4L320 435.8l0 60.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-7.4 5.1-13.9 12.3-15.6s14.7 1.8 18 8.4zM176 352l32 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-16 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48 0-80c0-8.8 7.2-16 16-16zm32 80c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0 48 16 0zm208-40c0-22.1 17.9-40 40-40l16 0c22.1 0 40 17.9 40 40l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-4.4-3.6-8-8-8l-16 0c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-8c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 24c0 22.1-17.9 40-40 40l-16 0c-22.1 0-40-17.9-40-40l0-80z"]
}, faFireHydrant = {
  prefix: "fas",
  iconName: "fire-hydrant",
  icon: [384, 512, [], "e17f", "M224 32l0 4c45 11.6 80.4 47 92 92l12 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L56 176c-13.3 0-24-10.7-24-24s10.7-24 24-24l12 0c11.6-45 47-80.4 92-92l0-4c0-17.7 14.3-32 32-32s32 14.3 32 32zM32 488c0-13.3 10.7-24 24-24l8 0 0-64-16 0c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l16 0 0-64 256 0 0 64 16 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-16 0 0 64 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0L64 512l-8 0c-13.3 0-24-10.7-24-24zm160-88a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]
}, faRightToBracket = {
  prefix: "fas",
  iconName: "right-to-bracket",
  icon: [512, 512, ["sign-in-alt"], "f2f6", "M217.9 105.9L340.7 228.7c7.2 7.2 11.3 17.1 11.3 27.3s-4.1 20.1-11.3 27.3L217.9 406.1c-6.4 6.4-15 9.9-24 9.9c-18.7 0-33.9-15.2-33.9-33.9l0-62.1L32 320c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l128 0 0-62.1c0-18.7 15.2-33.9 33.9-33.9c9 0 17.6 3.6 24 9.9zM352 416l64 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c53 0 96 43 96 96l0 256c0 53-43 96-96 96l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faSignInAlt = faRightToBracket, faVideoPlus = {
  prefix: "fas",
  iconName: "video-plus",
  icon: [576, 512, [], "f4e1", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm512 64c0-11.8-6.5-22.6-16.9-28.2s-23-5-32.9 1.6l-96 64L416 174.9l0 17.1 0 128 0 17.1 14.2 9.5 96 64c9.8 6.5 22.4 7.2 32.9 1.6s16.9-16.4 16.9-28.2l0-256zM216 184l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faSquareRight = {
  prefix: "fas",
  iconName: "square-right",
  icon: [448, 512, [10145, "arrow-alt-square-right"], "f352", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM363.3 267.3l-112 112c-4.6 4.6-11.5 5.9-17.4 3.5s-9.9-8.3-9.9-14.8l0-64-96 0c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l96 0 0-64c0-6.5 3.9-12.3 9.9-14.8s12.9-1.1 17.4 3.5l112 112c6.2 6.2 6.2 16.4 0 22.6z"]
}, faArrowAltSquareRight = faSquareRight, faCommentSmile = {
  prefix: "fas",
  iconName: "comment-smile",
  icon: [512, 512, [], "f4b4", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM192 144a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM150.5 270.1c9.9-8.8 25-8 33.9 1.9c17.6 19.7 43.1 32 71.6 32s53.9-12.3 71.6-32c8.8-9.9 24-10.7 33.9-1.9s10.7 24 1.9 33.9C337 333.4 298.6 352 256 352s-81-18.6-107.3-48c-8.8-9.9-8-25 1.9-33.9z"]
}, faVenus = {
  prefix: "fas",
  iconName: "venus",
  icon: [384, 512, [9792], "f221", "M80 176a112 112 0 1 1 224 0A112 112 0 1 1 80 176zM224 349.1c81.9-15 144-86.8 144-173.1C368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144 173.1l0 34.9-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-34.9z"]
}, faPassport = {
  prefix: "fas",
  iconName: "passport",
  icon: [448, 512, [], "f5ab", "M0 64C0 28.7 28.7 0 64 0L384 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM183 278.8c-27.9-13.2-48.4-39.4-53.7-70.8l39.1 0c1.6 30.4 7.7 53.8 14.6 70.8zm41.3 9.2l-.3 0-.3 0c-2.4-3.5-5.7-8.9-9.1-16.5c-6-13.6-12.4-34.3-14.2-63.5l47.1 0c-1.8 29.2-8.1 49.9-14.2 63.5c-3.4 7.6-6.7 13-9.1 16.5zm40.7-9.2c6.8-17.1 12.9-40.4 14.6-70.8l39.1 0c-5.3 31.4-25.8 57.6-53.7 70.8zM279.6 176c-1.6-30.4-7.7-53.8-14.6-70.8c27.9 13.2 48.4 39.4 53.7 70.8l-39.1 0zM223.7 96l.3 0 .3 0c2.4 3.5 5.7 8.9 9.1 16.5c6 13.6 12.4 34.3 14.2 63.5l-47.1 0c1.8-29.2 8.1-49.9 14.2-63.5c3.4-7.6 6.7-13 9.1-16.5zM183 105.2c-6.8 17.1-12.9 40.4-14.6 70.8l-39.1 0c5.3-31.4 25.8-57.6 53.7-70.8zM352 192A128 128 0 1 0 96 192a128 128 0 1 0 256 0zM112 384c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0z"]
}, faThumbtackSlash = {
  prefix: "fas",
  iconName: "thumbtack-slash",
  icon: [640, 512, ["thumb-tack-slash"], "e68f", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L481.4 352c9.8-.4 18.9-5.3 24.6-13.3c6-8.3 7.7-19.1 4.4-28.8l-1-3c-13.8-41.5-42.8-74.8-79.5-94.7L418.5 64 448 64c17.7 0 32-14.3 32-32s-14.3-32-32-32L192 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l29.5 0-6.1 79.5L38.8 5.1zM324.9 352L177.1 235.6c-20.9 18.9-37.2 43.3-46.5 71.3l-1 3c-3.3 9.8-1.6 20.5 4.4 28.8s15.7 13.3 26 13.3l164.9 0zM288 384l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96-64 0z"]
}, faThumbTackSlash = faThumbtackSlash, faInboxIn = {
  prefix: "fas",
  iconName: "inbox-in",
  icon: [512, 512, [128229, "inbox-arrow-down"], "f310", "M288 32l0 178.7 41.4-41.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-96 96c-12.5 12.5-32.8 12.5-45.3 0l-96-96c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L224 210.7 224 32c0-17.7 14.3-32 32-32s32 14.3 32 32zM48 320l76.2 0c12.1 0 23.2 6.8 28.6 17.7l14.3 28.6c5.4 10.8 16.5 17.7 28.6 17.7l120.4 0c12.1 0 23.2-6.8 28.6-17.7l14.3-28.6c5.4-10.8 16.5-17.7 28.6-17.7l76.2 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48z"]
}, faInboxArrowDown = faInboxIn, faHeartPulse = {
  prefix: "fas",
  iconName: "heart-pulse",
  icon: [512, 512, ["heartbeat"], "f21e", "M228.3 469.1L47.6 300.4c-4.2-3.9-8.2-8.1-11.9-12.4l87 0c22.6 0 43-13.6 51.7-34.5l10.5-25.2 49.3 109.5c3.8 8.5 12.1 14 21.4 14.1s17.8-5 22-13.3L320 253.7l1.7 3.4c9.5 19 28.9 31 50.1 31l104.5 0c-3.7 4.3-7.7 8.5-11.9 12.4L283.7 469.1c-7.5 7-17.4 10.9-27.7 10.9s-20.2-3.9-27.7-10.9zM503.7 240l-132 0c-3 0-5.8-1.7-7.2-4.4l-23.2-46.3c-4.1-8.1-12.4-13.3-21.5-13.3s-17.4 5.1-21.5 13.3l-41.4 82.8L205.9 158.2c-3.9-8.7-12.7-14.3-22.2-14.1s-18.1 5.9-21.8 14.8l-31.8 76.3c-1.2 3-4.2 4.9-7.4 4.9L16 240c-2.6 0-5 .4-7.3 1.1C3 225.2 0 208.2 0 190.9l0-5.8c0-69.9 50.5-129.5 119.4-141C165 36.5 211.4 51.4 244 84l12 12 12-12c32.6-32.6 79-47.5 124.6-39.9C461.5 55.6 512 115.2 512 185.1l0 5.8c0 16.9-2.8 33.5-8.3 49.1z"]
}, faHeartbeat = faHeartPulse, faCircle8 = {
  prefix: "fas",
  iconName: "circle-8",
  icon: [512, 512, [], "e0f5", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM264 128l-16 0c-39.8 0-72 32.2-72 72c0 15.7 5 30.1 13.5 42c-18 14.7-29.5 37-29.5 62c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80c0-25-11.5-47.4-29.5-62c8.5-11.8 13.5-26.3 13.5-42c0-39.8-32.2-72-72-72zm-16 96c-13.2 0-24-10.8-24-24s10.7-24 24-24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24c0 0 0 0 0 0l-16 0s0 0 0 0zm16 48l8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0 16 0z"]
}, faCloudsMoon = {
  prefix: "fas",
  iconName: "clouds-moon",
  icon: [640, 512, [], "f745", "M352 160c0 11.5 1.2 22.7 3.5 33.4c53.7 8.2 96.5 49.8 106.4 103c14.2 5.5 27.2 13.4 38.5 23.2c3.7 .3 7.4 .4 11.2 .4c43.2 0 82.5-17.3 111.2-45.3c5-4.9 6.3-12.5 3.1-18.7s-10.1-9.7-17-8.5c-6.5 1.1-13.2 1.7-20 1.7c-64.3 0-116.5-52.3-116.5-116.9c0-43.7 23.9-81.8 59.3-101.9c6.1-3.5 9.2-10.5 7.7-17.3S532 1.2 525.1 .6c-4.5-.4-9-.6-13.5-.6C423.4 0 352 71.7 352 160zM114.8 273.9c20.1-30.1 54.3-49.9 93.2-49.9c12.9 0 25.3 2.2 36.8 6.2c19.6-19.9 45.8-33.5 75-37.2l0-.9c0-35.3-28.6-64-64-64c-7.4 0-14.6 1.3-21.2 3.6c-11.5-30.1-40.6-51.6-74.8-51.6c-38.9 0-71.3 27.8-78.5 64.6c-3.1-.4-6.3-.6-9.5-.6c-39.8 0-72 32.2-72 72s32.2 72 72 72c16.1 0 30.9-5.3 42.9-14.1zM64 431.9c0 44.2 35.8 80 80 80l271.9 0c53 0 96-43 96-96c0-47.6-34.6-87-80-94.6l0-1.3c0-53-43-96-96-96c-34.9 0-65.4 18.6-82.2 46.4C240.8 261.3 225 256 208 256c-44.2 0-80 35.8-80 80c0 5.9 .6 11.7 1.9 17.2C92.4 359.9 64 392.6 64 431.9z"]
}, faClockTenThirty = {
  prefix: "fas",
  iconName: "clock-ten-thirty",
  icon: [512, 512, [], "e355", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zm24-120l0-136c0-8-4-15.5-10.7-20l-96-64c-11-7.4-25.9-4.4-33.3 6.7s-4.4 25.9 6.7 33.3L232 268.8 232 392c0 13.3 10.7 24 24 24s24-10.7 24-24z"]
}, faPeopleCarryBox = {
  prefix: "fas",
  iconName: "people-carry-box",
  icon: [640, 512, ["people-carry"], "f4ce", "M80 48a48 48 0 1 1 96 0A48 48 0 1 1 80 48zm64 193.7l0 65.1 51 51c7.1 7.1 11.8 16.2 13.4 26.1l15.2 90.9c2.9 17.4-8.9 33.9-26.3 36.8s-33.9-8.9-36.8-26.3l-14.3-85.9L66.8 320C54.8 308 48 291.7 48 274.7l0-88.1c0-32.4 26.2-58.6 58.6-58.6c24.1 0 46.5 12 59.9 32l47.4 71.1 10.1 5 0-76.2c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 76.2 10.1-5L473.5 160c13.3-20 35.8-32 59.9-32c32.4 0 58.6 26.2 58.6 58.6l0 88.1c0 17-6.7 33.3-18.7 45.3l-79.4 79.4-14.3 85.9c-2.9 17.4-19.4 29.2-36.8 26.3s-29.2-19.4-26.3-36.8l15.2-90.9c1.6-9.9 6.3-19 13.4-26.1l51-51 0-65.1-19 28.5c-4.6 7-11 12.6-18.5 16.3l-59.6 29.8c-2.4 1.3-4.9 2.2-7.6 2.8c-2.6 .6-5.3 .9-7.9 .8l-126.7 0c-2.5 .1-5-.2-7.5-.7c-2.9-.6-5.6-1.6-8.1-3l-59.5-29.8c-7.5-3.7-13.8-9.4-18.5-16.3l-19-28.5zM2.3 468.1L50.1 348.6l49.2 49.2-37.6 94c-6.6 16.4-25.2 24.4-41.6 17.8S-4.3 484.5 2.3 468.1zM512 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm77.9 348.6l47.8 119.5c6.6 16.4-1.4 35-17.8 41.6s-35-1.4-41.6-17.8l-37.6-94 49.2-49.2z"]
}, faPeopleCarry = faPeopleCarryBox, faFolderUser = {
  prefix: "fas",
  iconName: "folder-user",
  icon: [512, 512, [], "e18e", "M512 416c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l128 0c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8l160 0c35.3 0 64 28.7 64 64l0 256zM320 256a64 64 0 1 0 -128 0 64 64 0 1 0 128 0zM144 405.3c0 5.9 4.8 10.7 10.7 10.7l202.7 0c5.9 0 10.7-4.8 10.7-10.7c0-29.5-23.9-53.3-53.3-53.3l-117.3 0c-29.5 0-53.3 23.9-53.3 53.3z"]
}, faTrashCanXmark = {
  prefix: "fas",
  iconName: "trash-can-xmark",
  icon: [448, 512, [], "e2ae", "M163.8 0L284.2 0c12.1 0 23.2 6.8 28.6 17.7L320 32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 7.2-14.3C140.6 6.8 151.7 0 163.8 0zM32 128l384 0 0 320c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-320zM143 239c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47c-9.4-9.4-24.6-9.4-33.9 0z"]
}, faTemperatureHigh = {
  prefix: "fas",
  iconName: "temperature-high",
  icon: [512, 512, [], "f769", "M416 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 128A96 96 0 1 0 416 0a96 96 0 1 0 0 192zM96 112c0-26.5 21.5-48 48-48s48 21.5 48 48l0 164.5c0 17.3 7.1 31.9 15.3 42.5C217.8 332.6 224 349.5 224 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-18.5 6.2-35.4 16.7-48.9C88.9 308.4 96 293.8 96 276.5L96 112zM144 0C82.1 0 32 50.2 32 112l0 164.4c0 .1-.1 .3-.2 .6c-.2 .6-.8 1.6-1.7 2.8C11.2 304.2 0 334.8 0 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-33.2-11.2-63.8-30.1-88.1c-.9-1.2-1.5-2.2-1.7-2.8c-.1-.3-.2-.5-.2-.6L256 112C256 50.2 205.9 0 144 0zm0 416c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3L160 112c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 210.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48z"]
}, faMicrochip = {
  prefix: "fas",
  iconName: "microchip",
  icon: [512, 512, [], "f2db", "M176 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c-35.3 0-64 28.7-64 64l-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 56-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0 0 56-40 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l40 0c0 35.3 28.7 64 64 64l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 56 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 56 0 0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40c35.3 0 64-28.7 64-64l40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-56 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0 0-56 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0c0-35.3-28.7-64-64-64l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-56 0 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-56 0 0-40zM160 128l192 0c17.7 0 32 14.3 32 32l0 192c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-192c0-17.7 14.3-32 32-32zm192 32l-192 0 0 192 192 0 0-192z"]
}, faLeftLongToLine = {
  prefix: "fas",
  iconName: "left-long-to-line",
  icon: [640, 512, [], "e41e", "M0 96L0 416c0 17.7 14.3 32 32 32s32-14.3 32-32L64 96c0-17.7-14.3-32-32-32S0 78.3 0 96zM279.5 409.4c7 6.6 17.2 8.4 26 4.6s14.5-12.5 14.5-22l0-72 288 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-288 0 0-72c0-9.6-5.7-18.2-14.5-22s-19-2-26 4.6l-144 136c-4.8 4.5-7.5 10.8-7.5 17.4s2.7 12.9 7.5 17.4l144 136z"]
}, faCrown = {
  prefix: "fas",
  iconName: "crown",
  icon: [576, 512, [128081], "f521", "M309 106c11.4-7 19-19.7 19-34c0-22.1-17.9-40-40-40s-40 17.9-40 40c0 14.4 7.6 27 19 34L209.7 220.6c-9.1 18.2-32.7 23.4-48.6 10.7L72 160c5-6.7 8-15 8-24c0-22.1-17.9-40-40-40S0 113.9 0 136s17.9 40 40 40c.2 0 .5 0 .7 0L86.4 427.4c5.5 30.4 32 52.6 63 52.6l277.2 0c30.9 0 57.4-22.1 63-52.6L535.3 176c.2 0 .5 0 .7 0c22.1 0 40-17.9 40-40s-17.9-40-40-40s-40 17.9-40 40c0 9 3 17.3 8 24l-89.1 71.3c-15.9 12.7-39.5 7.5-48.6-10.7L309 106z"]
}, faWeightHanging = {
  prefix: "fas",
  iconName: "weight-hanging",
  icon: [512, 512, [], "f5cd", "M224 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm122.5 32c3.5-10 5.5-20.8 5.5-32c0-53-43-96-96-96s-96 43-96 96c0 11.2 1.9 22 5.5 32L120 128c-22 0-41.2 15-46.6 36.4l-72 288c-3.6 14.3-.4 29.5 8.7 41.2S33.2 512 48 512l416 0c14.8 0 28.7-6.8 37.8-18.5s12.3-26.8 8.7-41.2l-72-288C433.2 143 414 128 392 128l-45.5 0z"]
}, faXmarksLines = {
  prefix: "fas",
  iconName: "xmarks-lines",
  icon: [640, 512, [], "e59a", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l576 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zm0 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l576 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 416zM7 167c-9.4 9.4-9.4 24.6 0 33.9l55 55L7 311c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l55-55 55 55c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-55-55 55-55c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-55 55L41 167c-9.4-9.4-24.6-9.4-33.9 0zM265 167c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l55 55-55 55c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l55-55 55 55c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-55-55 55-55c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-55 55-55-55zM455 167c-9.4 9.4-9.4 24.6 0 33.9l55 55-55 55c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l55-55 55 55c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-55-55 55-55c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-55 55-55-55c-9.4-9.4-24.6-9.4-33.9 0z"]
}, faFilePrescription = {
  prefix: "fas",
  iconName: "file-prescription",
  icon: [384, 512, [], "f572", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM104 196l72 0c33.1 0 60 26.9 60 60c0 25.5-15.9 47.2-38.3 55.9l43 40.3 33.8-31c8.1-7.5 20.8-6.9 28.3 1.2s6.9 20.8-1.2 28.3L270 379.7l31.7 29.7c8.1 7.6 8.5 20.2 .9 28.3s-20.2 8.5-28.3 .9l-33.9-31.8-34.9 32c-8.1 7.5-20.8 6.9-28.3-1.2s-6.9-20.8 1.2-28.3l32.6-29.9-64.8-60.8c-.9-.8-1.6-1.7-2.3-2.6l-20 0 0 44c0 11-9 20-20 20s-20-9-20-20l0-64 0-80c0-11 9-20 20-20zm72 80c11 0 20-9 20-20s-9-20-20-20l-52 0 0 40 52 0z"]
}, faTableCellsLock = {
  prefix: "fas",
  iconName: "table-cells-lock",
  icon: [640, 512, [], "e679", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0 0-64-24 0 0-64 24 0c0-23.7 12.9-44.4 32-55.4l0-8.6-56 0 0-64 66.8 0c15.8-33.2 47.5-57.5 85.2-62.9L512 96c0-35.3-28.7-64-64-64L64 32zm88 64l0 64-88 0 0-64 88 0zm56 0l88 0 0 64-88 0 0-64zm240 0l0 64-88 0 0-64 88 0zM64 224l88 0 0 64-88 0 0-64zm232 0l0 64-88 0 0-64 88 0zM152 352l0 64-88 0 0-64 88 0zm56 0l88 0 0 64-88 0 0-64zM528 240c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]
}, faCalendarRange = {
  prefix: "fas",
  iconName: "calendar-range",
  icon: [448, 512, [], "e0d6", "M96 32l0 32L48 64C21.5 64 0 85.5 0 112l0 48 448 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32S96 14.3 96 32zM448 192L0 192 0 464c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-272zM128 288a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM352 448a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM192 288c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24zm40 104c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 440c-13.3 0-24-10.7-24-24s10.7-24 24-24l144 0z"]
}, faFlowerDaffodil = {
  prefix: "fas",
  iconName: "flower-daffodil",
  icon: [512, 512, [9880], "f800", "M288 281.3c9.8 4.3 20.6 6.7 32 6.7c44.2 0 80-35.8 80-80c0-26.2-12.6-49.4-32-64c19.4-14.6 32-37.8 32-64c0-44.2-35.8-80-80-80c-26.2 0-49.4 12.6-64 32C241.4 12.6 218.2 0 192 0c-44.2 0-80 35.8-80 80c0 26.2 12.6 49.4 32 64c-19.4 14.6-32 37.8-32 64c0 44.2 35.8 80 80 80c11.4 0 22.2-2.4 32-6.7l0 113.4C192.1 349.5 139.5 320 80 320l-50.5 0C13.2 320 0 333.2 0 349.5C0 439.3 72.7 512 162.5 512l61.5 0 32 0 32 0 61.5 0C439.3 512 512 439.3 512 349.5c0-16.3-13.2-29.5-29.5-29.5L432 320c-59.5 0-112.1 29.5-144 74.8l0-113.4zM208 144a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"]
}, faHandBackPointUp = {
  prefix: "fas",
  iconName: "hand-back-point-up",
  icon: [448, 512, [], "e1a2", "M136 0C113.9 0 96 17.9 96 40l0 200 0 7 0 73c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-55.7c-2 1.4-3.9 3-5.8 4.5L39 284.8C24.4 297 16 315 16 334L16 372c0 38 16.9 74 46.1 98.3l5.4 4.5c28.8 24 65 37.1 102.4 37.1L288 512c70.7 0 128-57.3 128-128l0-64 0-32c0-26.5-21.5-48-48-48c-12.4 0-23.6 4.7-32.1 12.3C334 227.5 313.3 208 288 208c-12.4 0-23.6 4.7-32.1 12.3C254 195.5 233.3 176 208 176c-12.3 0-23.5 4.6-32 12.2L176 40c0-22.1-17.9-40-40-40z"]
}, faWeightScale = {
  prefix: "fas",
  iconName: "weight-scale",
  icon: [512, 512, ["weight"], "f496", "M128 176a128 128 0 1 1 256 0 128 128 0 1 1 -256 0zM391.8 64C359.5 24.9 310.7 0 256 0S152.5 24.9 120.2 64L64 64C28.7 64 0 92.7 0 128L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l-56.2 0zM296 224c0-10.6-4.1-20.2-10.9-27.4l33.6-78.3c3.5-8.1-.3-17.5-8.4-21s-17.5 .3-21 8.4L255.7 184c-22 .1-39.7 18-39.7 40c0 22.1 17.9 40 40 40s40-17.9 40-40z"]
}, faWeight = faWeightScale, faArrowUpToArc = {
  prefix: "fas",
  iconName: "arrow-up-to-arc",
  icon: [512, 512, [], "e617", "M256 64c106 0 192 86 192 192c0 17.7 14.3 32 32 32s32-14.3 32-32C512 114.6 397.4 0 256 0S0 114.6 0 256c0 17.7 14.3 32 32 32s32-14.3 32-32C64 150 150 64 256 64zM390.6 281.4l-112-112c-12.5-12.5-32.8-12.5-45.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L224 269.3 224 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.7 57.4 57.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3z"]
}, faStarExclamation = {
  prefix: "fas",
  iconName: "star-exclamation",
  icon: [576, 512, [], "f2f3", "M288.1 0c12.2 0 23.4 7 28.8 18l64.3 132.3 143.6 21.2c12 1.8 22 10.2 25.7 21.7s.7 24.2-7.9 32.7L438.5 329l24.6 145.7c2 12-3 24.2-12.9 31.3s-23 8-33.8 2.3L288.1 439.8 159.8 508.3C149 514 135.9 513.1 126 506s-14.9-19.3-12.9-31.3L137.8 329 33.6 225.9c-8.6-8.5-11.7-21.2-7.9-32.7s13.7-19.9 25.7-21.7L195 150.3 259.4 18c5.4-11 16.5-18 28.8-18zM288 128c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faBooks = {
  prefix: "fas",
  iconName: "books",
  icon: [512, 512, [128218], "f5db", "M0 32C0 14.3 14.3 0 32 0L96 0c17.7 0 32 14.3 32 32l0 64L0 96 0 32zm0 96l128 0 0 256L0 384 0 128zM0 416l128 0 0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64zM160 32c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64L160 96l0-64zm0 96l128 0 0 256-128 0 0-256zm0 288l128 0 0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64zm203.6-19.9L320 232.6l0-89.9 100.4-26.9 66 247.4L363.6 396.1zM412.2 85L320 109.6 320 11l36.9-9.9c16.9-4.6 34.4 5.5 38.9 22.6L412.2 85zM371.8 427l122.8-32.9 16.3 61.1c4.5 17-5.5 34.5-22.5 39.1l-61.4 16.5c-16.9 4.6-34.4-5.5-38.9-22.6L371.8 427z"]
}, faUserGroup = {
  prefix: "fas",
  iconName: "user-group",
  icon: [640, 512, [128101, "user-friends"], "f500", "M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM0 482.3C0 383.8 79.8 304 178.3 304l91.4 0C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7L29.7 512C13.3 512 0 498.7 0 482.3zM609.3 512l-137.8 0c5.4-9.4 8.6-20.3 8.6-32l0-8c0-60.7-27.1-115.2-69.8-151.8c2.4-.1 4.7-.2 7.1-.2l61.4 0C567.8 320 640 392.2 640 481.3c0 17-13.8 30.7-30.7 30.7zM432 256c-31 0-59-12.6-79.3-32.9C372.4 196.5 384 163.6 384 128c0-26.8-6.6-52.1-18.3-74.3C384.3 40.1 407.2 32 432 32c61.9 0 112 50.1 112 112s-50.1 112-112 112z"]
}, faUserFriends = faUserGroup, faArrowUpAZ = {
  prefix: "fas",
  iconName: "arrow-up-a-z",
  icon: [576, 512, ["sort-alpha-up"], "f15e", "M183.6 42.4C177.5 35.8 169 32 160 32s-17.5 3.8-23.6 10.4l-88 96c-11.9 13-11.1 33.3 2 45.2s33.3 11.1 45.2-2L128 146.3 128 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-301.7 32.4 35.4c11.9 13 32.2 13.9 45.2 2s13.9-32.2 2-45.2l-88-96zM320 320c0 17.7 14.3 32 32 32l50.7 0-73.4 73.4c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0 73.4-73.4c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8l-128 0c-17.7 0-32 14.3-32 32zM416 32c-12.1 0-23.2 6.8-28.6 17.7l-64 128-16 32c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l7.2-14.3 88.4 0 7.2 14.3c7.9 15.8 27.1 22.2 42.9 14.3s22.2-27.1 14.3-42.9l-16-32-64-128C439.2 38.8 428.1 32 416 32zM395.8 176L416 135.6 436.2 176l-40.4 0z"]
}, faSortAlphaUp = faArrowUpAZ, faLayerPlus = {
  prefix: "fas",
  iconName: "layer-plus",
  icon: [576, 512, ["layer-group-plus"], "f5ff", "M464 0c-13.3 0-24 10.7-24 24l0 32-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-32c0-13.3-10.7-24-24-24zM311.5 133.2c-14.9-6.9-32.1-6.9-47 0L45.9 234.2C37.4 238.1 32 246.6 32 256s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-218.6-101zm13.4 274.7c-23.4 10.8-50.4 10.8-73.8 0l-152-70.2L45.9 362.2C37.4 366.1 32 374.6 32 384s5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-53.2-24.6-152 70.2z"]
}, faLayerGroupPlus = faLayerPlus, faPlayPause = {
  prefix: "fas",
  iconName: "play-pause",
  icon: [640, 512, [], "e22f", "M116.5 71.4c-9.5-7.9-22.8-9.7-34.1-4.4S64 83.6 64 96l0 320c0 12.4 7.2 23.7 18.4 29s24.5 3.6 34.1-4.4l192-160c7.3-6.1 11.5-15.1 11.5-24.6s-4.2-18.5-11.5-24.6l-192-160zM448 96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320zm128 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320z"]
}, faBlockQuestion = {
  prefix: "fas",
  iconName: "block-question",
  icon: [448, 512, [], "e3dd", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm73.8 149.3c7.9-22.3 29.1-37.3 52.8-37.3l58.3 0c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L248 280.4c-.2 13-10.9 23.6-24 23.6c-13.3 0-24-10.7-24-24l0-13.5c0-8.6 4.6-16.5 12.1-20.8l44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1l-58.3 0c-3.4 0-6.4 2.1-7.5 5.3l-.4 1.2c-4.4 12.5-18.2 19-30.6 14.6s-19-18.2-14.6-30.6l.4-1.2zM192 368a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM48 104a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM376 80a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM48 408a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm328-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]
}, faSnooze = {
  prefix: "fas",
  iconName: "snooze",
  icon: [448, 512, [128164, "zzz"], "f880", "M192 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0-57.6 76.8c-7.3 9.7-8.4 22.7-3 33.5s16.5 17.7 28.6 17.7l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 57.6-76.8c7.3-9.7 8.4-22.7 3-33.5S300.1 0 288 0L192 0zM320 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0-57.6 76.8c-7.3 9.7-8.4 22.7-3 33.5s16.5 17.7 28.6 17.7l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 57.6-76.8c7.3-9.7 8.4-22.7 3-33.5S428.1 224 416 224l-96 0zM32 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l91.7 0L7.4 459.5c-7.9 9.5-9.7 22.8-4.4 34.1S19.6 512 32 512l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-91.7 0L216.6 308.5c7.9-9.5 9.7-22.8 4.4-34.1s-16.6-18.4-29-18.4L32 256z"]
}, faZzz = faSnooze, faScannerImage = {
  prefix: "fas",
  iconName: "scanner-image",
  icon: [576, 512, [], "f8f3", "M79.1 35.8c-15.6-8.3-35-2.4-43.3 13.2s-2.4 35 13.2 43.3L416 288 64 288c-35.3 0-64 28.7-64 64l0 64c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-76.8c0-23.6-13-45.3-33.9-56.5L79.1 35.8zM64 384a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faTvRetro = {
  prefix: "fas",
  iconName: "tv-retro",
  icon: [512, 512, [128250], "f401", "M169 7c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l55 55L80 96C35.8 96 0 131.8 0 176L0 432c0 44.2 35.8 80 80 80l352 0c44.2 0 80-35.8 80-80l0-256c0-44.2-35.8-80-80-80L321.9 96l55-55c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-87 87L169 7zM424 232a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM64 224c0-35.3 28.7-64 64-64l192 0c35.3 0 64 28.7 64 64l0 160c0 35.3-28.7 64-64 64l-192 0c-35.3 0-64-28.7-64-64l0-160z"]
}, faSquareT = {
  prefix: "fas",
  iconName: "square-t",
  icon: [448, 512, [], "e280", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm56 112l104 0 104 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0 0 168c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-168-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faFarm = {
  prefix: "fas",
  iconName: "farm",
  icon: [576, 512, ["barn-silo"], "f864", "M0 96C0 43 43 0 96 0s96 43 96 96L0 96zm181.4 32L132.8 246c-3.2 7.7-4.8 16-4.8 24.4L128 480c0 11.7 3.1 22.6 8.6 32L48 512c-26.5 0-48-21.5-48-48L0 128l181.4 0zM160 480l0-209.7c0-4.2 .8-8.3 2.4-12.2l48.9-118.7c3-7.4 8.7-13.3 15.9-16.7L354.3 62.5c8.7-4.1 18.7-4.1 27.4 0l127.1 60.2c7.2 3.4 12.9 9.4 15.9 16.7l48.9 118.7c1.6 3.9 2.4 8 2.4 12.2L576 480c0 17.7-14.3 32-32 32l-112 0 0-64c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48l0 64-112 0c-17.7 0-32-14.3-32-32zM320 248l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24z"]
}, faBarnSilo = faFarm, faChessKnight = {
  prefix: "fas",
  iconName: "chess-knight",
  icon: [448, 512, [9822], "f441", "M96 48L82.7 61.3C70.7 73.3 64 89.5 64 106.5l0 132.4c0 10.7 5.3 20.7 14.2 26.6l10.6 7c14.3 9.6 32.7 10.7 48.1 3l3.2-1.6c2.6-1.3 5-2.8 7.3-4.5l49.4-37c6.6-5 15.7-5 22.3 0c10.2 7.7 9.9 23.1-.7 30.3L90.4 350C73.9 361.3 64 380 64 400l320 0 28.9-159c2.1-11.3 3.1-22.8 3.1-34.3l0-14.7C416 86 330 0 224 0L83.8 0C72.9 0 64 8.9 64 19.8c0 7.5 4.2 14.3 10.9 17.7L96 48zm24 68a20 20 0 1 1 40 0 20 20 0 1 1 -40 0zM22.6 473.4c-4.2 4.2-6.6 10-6.6 16C16 501.9 26.1 512 38.6 512l370.7 0c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L384 432 64 432 22.6 473.4z"]
}, faBarsSort = {
  prefix: "fas",
  iconName: "bars-sort",
  icon: [448, 512, [], "e0ae", "M0 96C0 78.3 14.3 64 32 64l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 128C14.3 128 0 113.7 0 96zM0 256c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32zM192 416c0 17.7-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32l128 0c17.7 0 32 14.3 32 32z"]
}, faPalletBoxes = {
  prefix: "fas",
  iconName: "pallet-boxes",
  icon: [640, 512, [57863, "palette-boxes", "pallet-alt"], "f483", "M64 32C64 14.3 78.3 0 96 0L288 0c17.7 0 32 14.3 32 32l0 192c0 17.7-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32L64 32zM384 96c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128zM0 352c0-17.7 14.3-32 32-32l64 0 224 0 224 0 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 64 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0-224 0L96 512l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-64-32 0c-17.7 0-32-14.3-32-32zm128 96l160 0 0-64-160 0 0 64zm224 0l160 0 0-64-160 0 0 64z"]
}, faPaletteBoxes = faPalletBoxes, faPalletAlt = faPalletBoxes, faFaceLaughSquint = {
  prefix: "fas",
  iconName: "face-laugh-squint",
  icon: [512, 512, ["laugh-squint"], "f59b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM96.8 314.1c-3.8-13.7 7.4-26.1 21.6-26.1l275.2 0c14.2 0 25.5 12.4 21.6 26.1C396.2 382 332.1 432 256 432s-140.2-50-159.2-117.9zm36.7-199.4l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6c0-9 9.6-14.7 17.5-10.5zM396 125.1c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z"]
}, faLaughSquint = faFaceLaughSquint, faCodeSimple = {
  prefix: "fas",
  iconName: "code-simple",
  icon: [576, 512, [], "e13d", "M214.6 118.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-160 160c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256 214.6 118.6zm146.7 0L498.7 256 361.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3z"]
}, faBoltSlash = {
  prefix: "fas",
  iconName: "bolt-slash",
  icon: [640, 512, [], "e0b8", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-182.4-143 52.7-46.1c10-8.8 13.6-22.9 8.9-35.3s-16.6-20.7-30-20.7l-111.5 0L445.4 44.6c5.9-13.7 1.5-29.7-10.6-38.5s-28.6-8-39.9 1.8L228.4 153.7 38.8 5.1zM138.9 231.9c-10 8.8-13.6 22.9-8.9 35.3s16.6 20.7 30 20.7l83.7 0-88.9-70-15.9 13.9zm55.7 235.5c-5.9 13.7-1.5 29.7 10.6 38.5s28.6 8 39.9-1.8L374.4 391 264.5 304.4l-69.9 163z"]
}, faPanelFire = {
  prefix: "fas",
  iconName: "panel-fire",
  icon: [640, 512, [], "e42f", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 32.2c-12.6-1.2-25.5 2.7-35.5 11.7c-9.9 8.9-19.4 18.1-28.5 27.5l0-39.4c0-17.7-14.3-32-32-32L96 96c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l241.5 0c-4.4 6.2-8.5 12.5-12.3 18.7c-10.9 17.6-20.5 36.4-27.2 55.4c-3-1.4-6.4-2.1-9.9-2.1c-13.3 0-24 10.7-24 24s10.7 24 24 24l.2 0c-.1 2-.2 4.1-.2 6.1c0 49.3 18.6 95.2 49.6 129.9L64 480c-35.3 0-64-28.7-64-64L0 96zM120 320a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM505.7 208.1L518 194.3c5.4-6.1 13.3-8.8 20.9-8.9c7.2 0 14.3 2.6 19.9 7.8c19.7 18.3 39.8 43.2 55 70.6C629 291.1 640 322 640 352c0 88.7-71.3 159.8-160 159.8c-89.6 0-160-71.3-160-159.8c0-37.3 16-73.4 36.8-104.5c20.9-31.3 47.5-59 70.9-80.2c5.7-5.2 13.1-7.7 20.3-7.5c14.1 .3 23.8 11.4 32.7 21.6c0 0 0 0 0 0c2 2.3 4 4.6 6 6.7l19 19.9zM544 400c0-36.5-37-73-54.8-88.4c-5.4-4.7-13.1-4.7-18.5 0C453 327 416 363.5 416 400c0 35.3 28.7 64 64 64s64-28.7 64-64z"]
}, faBinaryCircleCheck = {
  prefix: "fas",
  iconName: "binary-circle-check",
  icon: [640, 512, [], "e33c", "M322.7 6c8.3 6 13.3 15.7 13.3 26l0 128 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-83.6-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16C303.6-1.6 314.4 0 322.7 6zM98.7 294c8.3 6 13.3 15.7 13.3 26l0 128 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-83.6-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16c9.8-3.3 20.5-1.6 28.8 4.4zM64 0l64 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0zm0 64l0 96 64 0 0-96L64 64zM192 352c0-35.3 28.7-64 64-64l64 0c6.2 0 12.2 .9 17.9 2.5c-11.2 22.9-17.6 48.6-17.9 75.7l0-14.2-64 0 0 96 64 0s0 0 0 0l19.2 0c7.8 15.3 17.8 29.3 29.5 41.5C357 503.3 339.5 512 320 512l-64 0c-35.3 0-64-28.7-64-64l0-96zm128.7 32l-.7 0 0-14.2c0 4.8 .3 9.5 .7 14.2zM352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm211.3-43.3c-6.2-6.2-16.4-6.2-22.6 0L480 385.4l-28.7-28.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c6.2 6.2 16.4 6.2 22.6 0l72-72c6.2-6.2 6.2-16.4 0-22.6z"]
}, faCommentMinus = {
  prefix: "fas",
  iconName: "comment-minus",
  icon: [512, 512, [], "f4b1", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM184 216l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faBurrito = {
  prefix: "fas",
  iconName: "burrito",
  icon: [512, 512, [127791], "f7ed", "M251.4 52.6L33.9 270.1c-9.9 9.9-17.8 21.3-23.4 33.7C39.2 324.1 74.2 336 112 336c79.2 0 146.2-52.3 168.3-124.3c5-16.3 7.7-33.7 7.7-51.7c0-40.4-13.6-77.7-36.6-107.4zm15-32C299.7 57.5 320 106.4 320 160c0 11.9-1 23.6-2.9 34.9c11.4-1.9 23-2.9 34.9-2.9c53.6 0 102.5 20.3 139.4 53.6c12.8-14.2 20.6-33 20.6-53.6c0-11.4-2.4-22.2-6.7-32c4.3-9.8 6.7-20.6 6.7-32c0-34.6-22-64.1-52.8-75.2C448.1 22 418.6 0 384 0c-11.4 0-22.2 2.4-32 6.7C342.2 2.4 331.4 0 320 0c-20.6 0-39.4 7.8-53.6 20.6zm193 240C429.7 237.6 392.4 224 352 224c-15.2 0-29.9 1.9-43.9 5.5C279.5 310.2 202.5 368 112 368c-40.8 0-78.8-11.7-110.9-32C.4 341.3 0 346.6 0 352c0 30.7 12.2 60.2 33.9 81.9l44.1 44.1C99.8 499.8 129.3 512 160 512s60.2-12.2 81.9-33.9L459.4 260.6z"]
}, faViolin = {
  prefix: "fas",
  iconName: "violin",
  icon: [640, 512, [127931], "f8ed", "M630.6 54.6c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L417 177.7C398 166.5 375.7 160 352 160c-20.8 0-40.4 5-57.8 13.8c-6.7 3.4-9.1 11.4-7.7 18.8c1 5 1.5 10.2 1.5 15.4c0 44.2-35.8 80-80 80c-11.6 0-22.7-2.5-32.7-7c-7.4-3.3-16.6-2.4-21.3 4.3C137.6 308.7 128 337.2 128 368c0 15 2.3 29.5 6.6 43.1l44.6-33.5c19.1-14.3 45.9-12.4 62.7 4.5l16 16c16.9 16.9 18.8 43.6 4.5 62.7l-33.5 44.6c13.6 4.3 28.1 6.6 43.1 6.6c30.8 0 59.3-9.6 82.6-26.1c6.7-4.7 7.6-13.8 4.3-21.3c-4.5-10-7-21-7-32.7c0-44.2 35.8-80 80-80c5.3 0 10.5 .5 15.4 1.5c7.4 1.4 15.4-1 18.8-7.7c8.8-17.4 13.8-37 13.8-57.8c0-23.7-6.5-46-17.7-65L630.6 54.6zM520 48a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM345 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L7 311c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L345 41zM472 96a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm48-48a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM198.4 403.2l-64 48c-3.7 2.8-6 7-6.4 11.7s1.4 9.2 4.6 12.4l32 32c3.3 3.3 7.8 5 12.4 4.6s8.9-2.6 11.7-6.4l48-64c4.8-6.4 4.1-15.3-1.5-20.9l-16-16c-5.6-5.6-14.5-6.3-20.9-1.5z"]
}, faObjectsColumn = {
  prefix: "fas",
  iconName: "objects-column",
  icon: [448, 512, [], "e3c1", "M48 32C21.5 32 0 53.5 0 80L0 240c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48L48 32zM304 224c-26.5 0-48 21.5-48 48l0 160c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-96 0zM0 400l0 32c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48zM304 32c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-96 0z"]
}, faSquareChevronDown = {
  prefix: "fas",
  iconName: "square-chevron-down",
  icon: [448, 512, ["chevron-square-down"], "f329", "M384 480c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0zM207 345L103 241c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l87 87 87-87c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L241 345c-9.4 9.4-24.6 9.4-33.9 0z"]
}, faChevronSquareDown = faSquareChevronDown, faCommentPlus = {
  prefix: "fas",
  iconName: "comment-plus",
  icon: [512, 512, [], "f4b2", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM232 328l0-64-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]
}, faTriangleInstrument = {
  prefix: "fas",
  iconName: "triangle-instrument",
  icon: [576, 512, ["triangle-music"], "f8e2", "M320 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 37.9c-18 6.8-33.6 19.4-44.1 36.1L46.5 367.7C37 382.8 32 400.2 32 418c0 51.9 42.1 94 94 94L450 512c51.9 0 94-42.1 94-94c0-17.8-5-35.2-14.5-50.2L448.2 239l-46.4 46.4 73.6 116.5c3 4.8 4.6 10.4 4.6 16c0 16.6-13.5 30-30 30L126 448c-16.6 0-30-13.5-30-30c0-5.7 1.6-11.2 4.6-16L266 140.1c4.8-7.6 13.1-12.1 22-12.1s17.3 4.6 22 12.1l48 75.9-51.2 51.2c-5.9-2.1-12.2-3.2-18.8-3.2c-30.9 0-56 25.1-56 56s25.1 56 56 56s56-25.1 56-56c0-6.6-1.1-12.9-3.2-18.8l43.5-43.5 46.4-46.4L537 105c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-98.6 98.6L364.1 106C353.6 89.2 338 76.7 320 69.9L320 32z"]
}, faTriangleMusic = faTriangleInstrument, faWheelchair = {
  prefix: "fas",
  iconName: "wheelchair",
  icon: [512, 512, [], "f193", "M192 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM120.5 247.2c12.4-4.7 18.7-18.5 14-30.9s-18.5-18.7-30.9-14C43.1 225.1 0 283.5 0 352c0 88.4 71.6 160 160 160c61.2 0 114.3-34.3 141.2-84.7c6.2-11.7 1.8-26.2-9.9-32.5s-26.2-1.8-32.5 9.9C240 440 202.8 464 160 464C98.1 464 48 413.9 48 352c0-47.9 30.1-88.8 72.5-104.8zM259.8 176l-1.9-9.7c-4.5-22.3-24-38.3-46.8-38.3c-30.1 0-52.7 27.5-46.8 57l23.1 115.5c6 29.9 32.2 51.4 62.8 51.4l5.1 0c.4 0 .8 0 1.3 0l94.1 0c6.7 0 12.6 4.1 15 10.4L402 459.2c6 16.1 23.8 24.6 40.1 19.1l48-16c16.8-5.6 25.8-23.7 20.2-40.5s-23.7-25.8-40.5-20.2l-18.7 6.2-25.5-68c-11.7-31.2-41.6-51.9-74.9-51.9l-68.5 0-9.6-48 63.4 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-76.2 0z"]
}, faUserPilotTie = {
  prefix: "fas",
  iconName: "user-pilot-tie",
  icon: [448, 512, [], "e2c1", "M230.1 .8c-4-1.1-8.2-1.1-12.2 0l-152 40c-8.6 2.3-15.3 9.1-17.3 17.8s1 17.8 7.8 23.6L80 102.5l0 8.4c0 10.7 5.3 20.8 15.1 25.2c24.1 10.8 68.6 24 128.9 24s104.8-13.2 128.9-24c9.8-4.4 15.1-14.5 15.1-25.2l0-8.4 23.6-20.2c6.8-5.8 9.8-14.9 7.8-23.6s-8.7-15.6-17.3-17.8l-152-40zM161.7 72.8c4-7.9 13.6-11.1 21.5-7.2L224 86.1l40.8-20.4c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5l-48 24c-4.5 2.3-9.8 2.3-14.3 0l-48-24c-7.9-4-11.1-13.6-7.2-21.5zm-63.6 96C96.7 176.3 96 184.1 96 192c0 70.7 57.3 128 128 128s128-57.3 128-128c0-7.9-.7-15.7-2.1-23.2C310.8 183.8 268.4 192 224 192s-86.8-8.2-125.9-23.2zm89.5 206.3L208 416l-12.2 48.9L133 360.3c-3-5-8.6-8.1-14.4-7.4C51.8 360.8 0 417.5 0 486.4C0 500.5 11.5 512 25.6 512L192 512s0 0 0 0l64 0s0 0 0 0l166.4 0c14.1 0 25.6-11.5 25.6-25.6c0-68.9-51.8-125.6-118.6-133.5c-5.8-.7-11.4 2.4-14.4 7.4L252.2 464.9 240 416l20.4-40.8c5.3-10.6-2.4-23.2-14.3-23.2l-44.2 0c-11.9 0-19.6 12.5-14.3 23.2zM320 432c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16z"]
}, faPianoKeyboard = {
  prefix: "fas",
  iconName: "piano-keyboard",
  icon: [576, 512, [127929], "f8d5", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM512 224l0 160-80 0 0-68.3c9.6-5.5 16-15.9 16-27.7l0-64 64 0zM400 384l-96 0 0-68.3c9.6-5.5 16-15.9 16-27.7l0-64 64 0 0 64c0 11.8 6.4 22.2 16 27.7l0 68.3zm-128 0l-96 0 0-68.3c9.6-5.5 16-15.9 16-27.7l0-64 64 0 0 64c0 11.8 6.4 22.2 16 27.7l0 68.3zm-128 0l-80 0 0-160 64 0 0 64c0 11.8 6.4 22.2 16 27.7l0 68.3z"]
}, faBedEmpty = {
  prefix: "fas",
  iconName: "bed-empty",
  icon: [640, 512, [128719], "f8f9", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 256l0 96 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 288 0 224 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-53-43-96-96-96L64 224 64 64z"]
}, faCircleArrowUp = {
  prefix: "fas",
  iconName: "circle-arrow-up",
  icon: [512, 512, ["arrow-circle-up"], "f0aa", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM385 215c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-71-71L280 392c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-214.1-71 71c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 103c9.4-9.4 24.6-9.4 33.9 0L385 215z"]
}, faArrowCircleUp = faCircleArrowUp, faToggleOn = {
  prefix: "fas",
  iconName: "toggle-on",
  icon: [576, 512, [], "f205", "M192 64C86 64 0 150 0 256S86 448 192 448l192 0c106 0 192-86 192-192s-86-192-192-192L192 64zm192 96a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]
}, faRectangleVertical = {
  prefix: "fas",
  iconName: "rectangle-vertical",
  icon: [384, 512, ["rectangle-portrait"], "f2fb", "M320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L320 0z"]
}, faRectanglePortrait = faRectangleVertical, faPersonWalking = {
  prefix: "fas",
  iconName: "person-walking",
  icon: [320, 512, [128694, "walking"], "f554", "M160 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM126.5 199.3c-1 .4-1.9 .8-2.9 1.2l-8 3.5c-16.4 7.3-29 21.2-34.7 38.2l-2.6 7.8c-5.6 16.8-23.7 25.8-40.5 20.2s-25.8-23.7-20.2-40.5l2.6-7.8c11.4-34.1 36.6-61.9 69.4-76.5l8-3.5c20.8-9.2 43.3-14 66.1-14c44.6 0 84.8 26.8 101.9 67.9L281 232.7l21.4 10.7c15.8 7.9 22.2 27.1 14.3 42.9s-27.1 22.2-42.9 14.3L247 287.3c-10.3-5.2-18.4-13.8-22.8-24.5l-9.6-23-19.3 65.5 49.5 54c5.4 5.9 9.2 13 11.2 20.8l23 92.1c4.3 17.1-6.1 34.5-23.3 38.8s-34.5-6.1-38.8-23.3l-22-88.1-70.7-77.1c-14.8-16.1-20.3-38.6-14.7-59.7l16.9-63.5zM68.7 398l25-62.4c2.1 3 4.5 5.8 7 8.6l40.7 44.4-14.5 36.2c-2.4 6-6 11.5-10.6 16.1L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L68.7 398z"]
}, faWalking = faPersonWalking, faL = {
  prefix: "fas",
  iconName: "l",
  icon: [320, 512, [108], "4c", "M64 32c17.7 0 32 14.3 32 32l0 352 192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32L32 64c0-17.7 14.3-32 32-32z"]
}, faSignalStream = {
  prefix: "fas",
  iconName: "signal-stream",
  icon: [576, 512, [], "f8dd", "M108.2 71c13.8 11.1 16 31.2 5 45C82.4 154.4 64 203 64 256s18.4 101.6 49.1 140c11.1 13.8 8.8 33.9-5 45s-33.9 8.8-45-5C23.7 386.7 0 324.1 0 256S23.7 125.3 63.2 76c11.1-13.8 31.2-16 45-5zm359.7 0c13.8-11.1 33.9-8.8 45 5C552.3 125.3 576 187.9 576 256s-23.7 130.7-63.2 180c-11.1 13.8-31.2 16-45 5s-16-31.2-5-45c30.7-38.4 49.1-87 49.1-140s-18.4-101.6-49.1-140c-11.1-13.8-8.8-33.9 5-45zM232 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0zm-27.5-74.7c-17.8 19.8-28.5 46-28.5 74.7s10.8 54.8 28.5 74.7c11.8 13.2 10.7 33.4-2.5 45.2s-33.4 10.7-45.2-2.5C129 342.2 112 301.1 112 256s17-86.2 44.8-117.3c11.8-13.2 32-14.3 45.2-2.5s14.3 32 2.5 45.2zm214.7-42.7C447 169.8 464 210.9 464 256s-17 86.2-44.8 117.3c-11.8 13.2-32 14.3-45.2 2.5s-14.3-32-2.5-45.2c17.8-19.8 28.5-46 28.5-74.7s-10.8-54.8-28.5-74.7c-11.8-13.2-10.7-33.4 2.5-45.2s33.4-10.7 45.2 2.5z"]
}, faDownToBracket = {
  prefix: "fas",
  iconName: "down-to-bracket",
  icon: [448, 512, [], "e4e7", "M378.1 198.6L249.5 341.4c-6.1 6.7-14.7 10.6-23.8 10.6l-3.5 0c-9.1 0-17.7-3.8-23.8-10.6L69.9 198.6c-3.8-4.2-5.9-9.8-5.9-15.5C64 170.4 74.4 160 87.1 160l72.9 0 0-128c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 128 72.9 0c12.8 0 23.1 10.4 23.1 23.1c0 5.7-2.1 11.2-5.9 15.5zM64 352l0 64c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 53-43 96-96 96L96 512c-53 0-96-43-96-96l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32z"]
}, faCircleZ = {
  prefix: "fas",
  iconName: "circle-z",
  icon: [512, 512, [], "e130", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128l144 0c8.9 0 17.1 5 21.3 12.9s3.6 17.5-1.5 24.8L229.8 336l98.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-8.9 0-17.1-5-21.3-12.9s-3.6-17.5 1.5-24.8L282.2 176 184 176c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faStars = {
  prefix: "fas",
  iconName: "stars",
  icon: [512, 512, [], "f762", "M325.8 152.3c1.3 4.6 5.5 7.7 10.2 7.7s8.9-3.1 10.2-7.7L360 104l48.3-13.8c4.6-1.3 7.7-5.5 7.7-10.2s-3.1-8.9-7.7-10.2L360 56 346.2 7.7C344.9 3.1 340.7 0 336 0s-8.9 3.1-10.2 7.7L312 56 263.7 69.8c-4.6 1.3-7.7 5.5-7.7 10.2s3.1 8.9 7.7 10.2L312 104l13.8 48.3zm-112.4 5.1c-8.8-17.9-34.3-17.9-43.1 0l-46.3 94L20.5 266.5C.9 269.3-7 293.5 7.2 307.4l74.9 73.2L64.5 483.9c-3.4 19.6 17.2 34.6 34.8 25.3l92.6-48.8 92.6 48.8c17.6 9.3 38.2-5.7 34.8-25.3L301.6 380.6l74.9-73.2c14.2-13.9 6.4-38.1-13.3-40.9L259.7 251.4l-46.3-94zm215.4 85.8l11 38.6c1 3.6 4.4 6.2 8.2 6.2s7.1-2.5 8.2-6.2l11-38.6 38.6-11c3.6-1 6.2-4.4 6.2-8.2s-2.5-7.1-6.2-8.2l-38.6-11-11-38.6c-1-3.6-4.4-6.2-8.2-6.2s-7.1 2.5-8.2 6.2l-11 38.6-38.6 11c-3.6 1-6.2 4.4-6.2 8.2s2.5 7.1 6.2 8.2l38.6 11z"]
}, faFire = {
  prefix: "fas",
  iconName: "fire",
  icon: [448, 512, [128293], "f06d", "M159.3 5.4c7.8-7.3 19.9-7.2 27.7 .1c27.6 25.9 53.5 53.8 77.7 84c11-14.4 23.5-30.1 37-42.9c7.9-7.4 20.1-7.4 28 .1c34.6 33 63.9 76.6 84.5 118c20.3 40.8 33.8 82.5 33.8 111.9C448 404.2 348.2 512 224 512C98.4 512 0 404.1 0 276.5c0-38.4 17.8-85.3 45.4-131.7C73.3 97.7 112.7 48.6 159.3 5.4zM225.7 416c25.3 0 47.7-7 68.8-21c42.1-29.4 53.4-88.2 28.1-134.4c-4.5-9-16-9.6-22.5-2l-25.2 29.3c-6.6 7.6-18.5 7.4-24.7-.5c-16.5-21-46-58.5-62.8-79.8c-6.3-8-18.3-8.1-24.7-.1c-33.8 42.5-50.8 69.3-50.8 99.4C112 375.4 162.6 416 225.7 416z"]
}, faBedPulse = {
  prefix: "fas",
  iconName: "bed-pulse",
  icon: [640, 512, ["procedures"], "f487", "M483.2 9.6L524 64l92 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-104 0c-7.6 0-14.7-3.6-19.2-9.6L468.7 70.3l-47 99.9c-3.7 7.8-11.3 13.1-19.9 13.7s-16.9-3.4-21.7-10.6L339.2 112 216 112c-13.3 0-24-10.7-24-24s10.7-24 24-24l136 0c8 0 15.5 4 20 10.7l24.4 36.6 45.9-97.5C445.9 6.2 453.2 1 461.6 .1s16.6 2.7 21.6 9.5zM320 160l12.7 0 20.7 31.1c11.2 16.8 30.6 26.3 50.7 24.8s37.9-13.7 46.5-32L461.9 160l82.1 0c53 0 96 43 96 96l0 224c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-224 0-32 0L64 448l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 96C0 78.3 14.3 64 32 64s32 14.3 32 32l0 256 224 0 0-160c0-17.7 14.3-32 32-32zm-144 0a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"]
}, faProcedures = faBedPulse, faHouseDay = {
  prefix: "fas",
  iconName: "house-day",
  icon: [640, 512, [], "e00e", "M174.2 8.3C171.4 3.2 166-.1 160.1-.1s-11.3 3.2-14.1 8.4L118.4 59.5 62.8 42.9c-5.6-1.7-11.7-.1-15.9 4s-5.7 10.3-4 15.9l16.7 55.7L8.3 146.1c-5.2 2.8-8.4 8.2-8.4 14.1s3.2 11.3 8.4 14.1l51.2 27.6L42.8 257.6c-1.7 5.6-.1 11.7 4 15.9s10.3 5.7 15.9 4l55.7-16.7L133.1 288l57.4-53c-9.4 3.9-19.7 6-30.5 6c-44.2 0-80-35.8-80-80s35.8-80 80-80s80 35.8 80 80c0 13.1-3.1 25.4-8.7 36.3L296 137.5l-35.3-19 16.7-55.7c1.7-5.6 .1-11.7-4-15.9s-10.3-5.7-15.9-4L201.8 59.5 174.2 8.3zM112 160a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm309.7-55.5c-12.3-11.3-31.2-11.3-43.4 0l-208 192c-9.7 8.9-12.9 22.9-8.1 35.2S178.8 352 192 352l32 0 0 112c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-112 32 0c13.2 0 25-8.1 29.8-20.3s1.6-26.2-8.1-35.2l-208-192zM352 304c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16l0-64z"]
}, faShuttleSpace = {
  prefix: "fas",
  iconName: "shuttle-space",
  icon: [640, 512, ["space-shuttle"], "f197", "M130 480c40.6 0 80.4-11 115.2-31.9L352 384l-224 0 0 96 2 0zM352 128L245.2 63.9C210.4 43 170.6 32 130 32l-2 0 0 96 224 0zM96 128l0-96L80 32C53.5 32 32 53.5 32 80l0 48 8 0c-22.1 0-40 17.9-40 40l0 16L0 328l0 16c0 22.1 17.9 40 40 40l-8 0 0 48c0 26.5 21.5 48 48 48l16 0 0-96 8 0c26.2 0 49.4-12.6 64-32l288 0c69.3 0 135-22.7 179.2-81.6c6.4-8.5 6.4-20.3 0-28.8C591 182.7 525.3 160 456 160l-288 0c-14.6-19.4-37.8-32-64-32l-8 0zM512 243.6l0 24.9c0 19.6-15.9 35.6-35.6 35.6c-2.5 0-4.4-2-4.4-4.4l0-87.1c0-2.5 2-4.4 4.4-4.4c19.6 0 35.6 15.9 35.6 35.6z"]
}, faSpaceShuttle = faShuttleSpace, faShirtLongSleeve = {
  prefix: "fas",
  iconName: "shirt-long-sleeve",
  icon: [640, 512, [], "e3c7", "M157 .3c-32.1 2.5-61 20.9-76.7 49.5L13.9 170.5C4.8 187 0 205.6 0 224.4L0 384c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-159.6c0-2.7 .7-5.3 2-7.7l46-83.7L144 448c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-314.9 46 83.7c1.3 2.4 2 5 2 7.7L544 384c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-159.6c0-18.9-4.8-37.4-13.9-54L559.7 49.7C544.1 21.2 515.1 2.8 483 .3c-1-.2-2-.3-3-.3l-4.4 0L460 0 432 0c-8.8 0-15.9 7.2-17.3 15.9C407.1 61.4 367.6 96 320 96s-87.1-34.6-94.7-80.1C223.9 7.2 216.8 0 208 0L180 0 164.4 0 160 0c-1 0-2 .1-3 .3z"]
}, faChartPieSimple = {
  prefix: "fas",
  iconName: "chart-pie-simple",
  icon: [512, 512, ["chart-pie-alt"], "f64e", "M495.4 240L272 240l0-223.4c0-9 7-16.6 16-16.6C411.7 0 512 100.3 512 224c0 9-7.6 16-16.6 16zM190.2 37.2c18.1-3.8 33.8 11 33.8 29.5L224 288l221.3 0c18.5 0 33.3 15.7 29.5 33.8C451.9 430.5 355.5 512 240 512C107.5 512 0 404.6 0 272C0 156.5 81.5 60.1 190.2 37.2z"]
}, faChartPieAlt = faChartPieSimple, faFaceLaugh = {
  prefix: "fas",
  iconName: "face-laugh",
  icon: [512, 512, ["laugh"], "f599", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM96.8 314.1c-3.8-13.7 7.4-26.1 21.6-26.1l275.2 0c14.2 0 25.5 12.4 21.6 26.1C396.2 382 332.1 432 256 432s-140.2-50-159.2-117.9zM144.4 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faLaugh = faFaceLaugh, faFolderOpen = {
  prefix: "fas",
  iconName: "folder-open",
  icon: [576, 512, [128194, 128449, 61717], "f07c", "M88.7 223.8L0 375.8 0 96C0 60.7 28.7 32 64 32l117.5 0c17 0 33.3 6.7 45.3 18.7l26.5 26.5c12 12 28.3 18.7 45.3 18.7L416 96c35.3 0 64 28.7 64 64l0 32-336 0c-22.8 0-43.8 12.1-55.3 31.8zm27.6 16.1C122.1 230 132.6 224 144 224l400 0c11.5 0 22 6.1 27.7 16.1s5.7 22.2-.1 32.1l-112 192C453.9 474 443.4 480 432 480L32 480c-11.5 0-22-6.1-27.7-16.1s-5.7-22.2 .1-32.1l112-192z"]
}, faAlbumCollectionCircleUser = {
  prefix: "fas",
  iconName: "album-collection-circle-user",
  icon: [640, 512, [], "e48f", "M32 24c0 13.3 10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L56 0C42.7 0 32 10.7 32 24zM48 160c-13.8 0-26.9 5.9-36 16.2S-1.3 200.3 .4 214l32 256c3 24 23.4 42 47.6 42l314.8 0c-18.9-13.3-35.1-30.3-47.5-49.9c-26.9 11.4-58 17.9-91.3 17.9C154.4 480 72 419.1 72 344s82.4-136 184-136c45.4 0 86.9 12.1 119 32.2c31.5-29.9 74.2-48.2 121-48.2c4.5 0 9 .2 13.4 .5c-2-5.9-5.2-11.5-9.4-16.3c-9.1-10.3-22.2-16.2-36-16.2L48 160zM256 376c17.7 0 32-10.7 32-24s-14.3-24-32-24s-32 10.7-32 24s14.3 24 32 24zM40 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l432 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L40 80zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-66.3 80.7C553.5 468.1 526.2 480 496 480s-57.5-11.9-77.7-31.3c6.2-19 24-32.7 45.1-32.7l65.2 0c21 0 38.9 13.7 45.1 32.7zM448 336a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"]
}, faCandy = {
  prefix: "fas",
  iconName: "candy",
  icon: [640, 512, [127852], "e3e7", "M318.1 64c-24.5 .2-47.9 5.1-69.4 13.7L419.9 420c20.3-12.4 38.2-28.5 52.6-47.3L318.1 64zM492.3 340.8c4.7-9.6 8.7-19.6 11.8-30l93.2 46.6c10.5 5.3 23.3 2.1 30.2-7.4s5.8-22.7-2.5-31l-29.6-29.6 29.1-10.9C633.8 275 640 266 640 256s-6.2-19-15.6-22.5l-29.1-10.9L625 193c8.3-8.3 9.4-21.5 2.5-31s-19.7-12.7-30.2-7.4L504 201.1C483.7 132.9 426.5 80.6 355.5 67.3L492.3 340.8zm-101 93.5L220.1 92c-20.3 12.4-38.2 28.5-52.6 47.3L321.9 448c24.5-.2 47.9-5.1 69.4-13.7zM284.5 444.7L147.7 171.2c-4.7 9.6-8.7 19.6-11.8 30L42.7 154.5c-10.5-5.3-23.3-2.1-30.2 7.4s-5.8 22.7 2.5 31l29.6 29.6L15.6 233.5C6.2 237 0 246 0 256s6.2 19 15.6 22.5l29.1 10.9L15 319c-8.3 8.3-9.4 21.5-2.5 31s19.7 12.7 30.2 7.4L136 310.9c20.3 68.2 77.5 120.6 148.5 133.9z"]
}, faBowlHot = {
  prefix: "fas",
  iconName: "bowl-hot",
  icon: [512, 512, ["soup"], "f823", "M152 0c-13.3 0-24 10.7-24 24l0 8c0 32.7 15.4 63.6 41.6 83.2C183.7 125.8 192 142.4 192 160l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-32.7-15.4-63.6-41.6-83.2C184.3 66.2 176 49.6 176 32l0-8c0-13.3-10.7-24-24-24zM33.6 224C15.4 224 .9 239.3 2 257.5c5.4 91.7 59.7 169.7 136.4 209.7l1.2 9.7c2.5 20 19.5 35 39.7 35l153.4 0c20.2 0 37.2-15 39.7-35l1.2-9.7c76.8-40 131-118 136.4-209.7c1.1-18.2-13.4-33.5-31.6-33.5L33.6 224zM304 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 8c0 32.7 15.4 63.6 41.6 83.2C311.7 125.8 320 142.4 320 160l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-32.7-15.4-63.6-41.6-83.2C312.3 66.2 304 49.6 304 32l0-8z"]
}, faSoup = faBowlHot, faFlatbread = {
  prefix: "fas",
  iconName: "flatbread",
  icon: [512, 512, [129747], "e40b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM363.3 171.3l-192 192c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l192-192c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zm-112-70.6c6.2 6.2 6.2 16.4 0 22.6l-128 128c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l128-128c6.2-6.2 16.4-6.2 22.6 0zm160 182.6l-128 128c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l128-128c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]
}, faHeartCirclePlus = {
  prefix: "fas",
  iconName: "heart-circle-plus",
  icon: [576, 512, [], "e500", "M47.6 300.4L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9s20.2-3.9 27.7-10.9l2.6-2.4C267.2 438.6 256 404.6 256 368c0-97.2 78.8-176 176-176c28.3 0 55 6.7 78.7 18.5c.9-6.5 1.3-13 1.3-19.6l0-5.8c0-69.9-50.5-129.5-119.4-141C347 36.5 300.6 51.4 268 84L256 96 244 84c-32.6-32.6-79-47.5-124.6-39.9C50.5 55.6 0 115.2 0 185.1l0 5.8c0 41.5 17.2 81.2 47.6 109.5zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16z"]
}, faCodeFork = {
  prefix: "fas",
  iconName: "code-fork",
  icon: [448, 512, [], "e13b", "M80 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm80-24c0 32.8-19.7 61-48 73.3l0 38.7c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-38.7C307.7 141 288 112.8 288 80c0-44.2 35.8-80 80-80s80 35.8 80 80c0 32.8-19.7 61-48 73.3l0 38.7c0 53-43 96-96 96l-48 0 0 70.7c28.3 12.3 48 40.5 48 73.3c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-32.8 19.7-61 48-73.3l0-70.7-48 0c-53 0-96-43-96-96l0-38.7C19.7 141 0 112.8 0 80C0 35.8 35.8 0 80 0s80 35.8 80 80zm208 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM248 432a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]
}, faCity = {
  prefix: "fas",
  iconName: "city",
  icon: [640, 512, [127961], "f64f", "M480 48c0-26.5-21.5-48-48-48L336 0c-26.5 0-48 21.5-48 48l0 48-64 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72-64 0 0-72c0-13.3-10.7-24-24-24S64 10.7 64 24l0 72L48 96C21.5 96 0 117.5 0 144l0 96L0 464c0 26.5 21.5 48 48 48l256 0 32 0 96 0 160 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48l-112 0 0-144zm96 320l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zM240 416l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16zM128 400c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32zM560 256c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0zM256 176l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zM112 160c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0zM256 304c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32zM112 320l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16zm304-48l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zM400 64c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0zm16 112l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16z"]
}, faSignalBarsWeak = {
  prefix: "fas",
  iconName: "signal-bars-weak",
  icon: [640, 512, ["signal-alt-1"], "f691", "M32 432c0-26.5 21.5-48 48-48s48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V432z"]
}, faSignalAlt1 = faSignalBarsWeak, faMicrophoneLines = {
  prefix: "fas",
  iconName: "microphone-lines",
  icon: [384, 512, [127897, "microphone-alt"], "f3c9", "M96 96l0 160c0 53 43 96 96 96s96-43 96-96l-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-32-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-32-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0c0-53-43-96-96-96S96 43 96 96zM320 240l0 16c0 70.7-57.3 128-128 128s-128-57.3-128-128l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 89.1 66.2 162.7 152 174.4l0 33.6-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-33.6c85.8-11.7 152-85.3 152-174.4l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24z"]
}, faMicrophoneAlt = faMicrophoneLines, faClockTwelve = {
  prefix: "fas",
  iconName: "clock-twelve",
  icon: [512, 512, [], "e358", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm24-392l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faPepperHot = {
  prefix: "fas",
  iconName: "pepper-hot",
  icon: [512, 512, [127798], "f816", "M428.3 3c11.6-6.4 26.2-2.3 32.6 9.3l4.8 8.7c19.3 34.7 19.8 75.7 3.4 110C495.8 159.6 512 197.9 512 240c0 18.5-3.1 36.3-8.9 52.8c-6.1 17.3-28.5 16.3-36.8-.1l-11.7-23.4c-4.1-8.1-12.4-13.3-21.5-13.3L360 256c-13.3 0-24-10.7-24-24l0-80c0-13.3-10.7-24-24-24l-17.1 0c-21.3 0-30-23.9-10.8-32.9C304.7 85.4 327.7 80 352 80c28.3 0 54.8 7.3 77.8 20.2c5.5-18.2 3.7-38.4-6-55.8L419 35.7c-6.4-11.6-2.3-26.2 9.3-32.6zM171.2 345.5L264 160l40 0 0 80c0 26.5 21.5 48 48 48l76.2 0 23.9 47.8C372.3 443.9 244.3 512 103.2 512l-58.8 0C19.9 512 0 492.1 0 467.6c0-20.8 14.5-38.8 34.8-43.3l49.8-11.1c37.6-8.4 69.5-33.2 86.7-67.7z"]
}, faCitrusSlice = {
  prefix: "fas",
  iconName: "citrus-slice",
  icon: [512, 512, [], "e2f5", "M41 391c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9c115.6 115.6 302.6 116 418.3 .3S540.5 122.6 425 7c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9c96.9 96.9 97.1 253.6 .3 350.4S137.9 487.9 41 391zm116.3 32.9c9.6 2.7 18.8-4.9 18.8-14.9l0-144.5c0-6.2-4.3-11.5-10-14c-5.9-2.6-13-2.1-17.6 2.5L59.3 342.2c-6.2 6.2-6.2 16.4 0 22.6l4 4c27.1 27.1 59.6 45.5 94 55.2zM250.5 166c2.5 5.7 7.8 10 14 10L409 176c10 0 17.6-9.1 14.9-18.8C414.2 123 396 90.6 369.1 63.6l-4.3-4.3c-6.2-6.2-16.4-6.2-22.6 0L253 148.4c-4.6 4.6-5.2 11.7-2.5 17.6zm.6 50.5c-2 4.9-1.4 10.6 2.4 14.3l114 114c6.6 6.6 17.4 6.2 22.9-1.3c26.2-35.8 40.1-77.8 41.5-120.1c.3-8.6-6.8-15.4-15.4-15.4L263 208c-5.3 0-9.8 3.7-11.8 8.5zm-34.6 34.6c-4.9 2-8.5 6.5-8.5 11.8l0 153.5c0 8.6 6.8 15.7 15.4 15.4c42.4-1.4 84.4-15.3 120.1-41.5c7.5-5.5 7.9-16.3 1.3-22.9l-114-114c-3.7-3.7-9.4-4.4-14.3-2.4z"]
}, faSheep = {
  prefix: "fas",
  iconName: "sheep",
  icon: [640, 512, [128017], "f711", "M384 135.8l0 72.2c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-72.2 14.5 6.2c12.2 5.2 26.3-.4 31.5-12.6s-.4-26.3-12.6-31.5L561.6 77.4C544.7 50.2 514.5 32 480 32s-64.7 18.2-81.6 45.4L350.5 97.9c-12.2 5.2-17.8 19.3-12.6 31.5s19.3 17.8 31.5 12.6l14.5-6.2zm80-7.8a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM352 175.4c-18.7-2.7-35.5-14.8-43.5-33.4c-6.9-16.1-5.7-33.5 1.8-47.9C299 76 278.9 64 256 64c-19.2 0-36.5 8.5-48.2 21.9C196.9 77.2 183 72 168 72c-30.1 0-55.3 20.8-62.2 48.8c-3.2-.5-6.5-.8-9.8-.8c-35.3 0-64 28.7-64 64c0 5.3 .7 10.5 1.9 15.5C13.7 210.3 0 231.5 0 256s13.7 45.7 33.9 56.5c-1.2 5-1.9 10.2-1.9 15.5c0 35.3 28.7 64 64 64c.5 0 1 0 1.5 0l17.6 93.9c2.8 15.1 16.1 26.1 31.5 26.1l29.4 0c17.7 0 32-14.3 32-32l0-53.7c11.7 13.3 28.9 21.7 48 21.7s36.3-8.4 48-21.7l0 53.7c0 17.7 14.3 32 32 32l29.4 0c15.4 0 28.6-11 31.4-26.1L414.5 392c.5 0 1 0 1.5 0c35.3 0 64-28.7 64-64c0-2.7-.2-5.4-.5-8L464 320c-61.9 0-112-50.1-112-112l0-32.6z"]
}, faUnlock = {
  prefix: "fas",
  iconName: "unlock",
  icon: [448, 512, [128275], "f09c", "M144 144c0-44.2 35.8-80 80-80c31.9 0 59.4 18.6 72.3 45.7c7.6 16 26.7 22.8 42.6 15.2s22.8-26.7 15.2-42.6C331 33.7 281.5 0 224 0C144.5 0 80 64.5 80 144l0 48-16 0c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64l-240 0 0-48z"]
}, faColonSign = {
  prefix: "fas",
  iconName: "colon-sign",
  icon: [384, 512, [], "e140", "M255 39.8c4.3-17.1-6.1-34.5-23.3-38.8S197.2 7.1 193 24.2L181.9 68.6C96.1 87.8 32 164.4 32 256c0 58.1 25.8 110.2 66.7 145.4L81 472.2c-4.3 17.1 6.1 34.5 23.3 38.8s34.5-6.1 38.8-23.3l13-52.1c9 3.4 18.4 6.2 28 8.2L177 472.2c-4.3 17.1 6.1 34.5 23.3 38.8s34.5-6.1 38.8-23.3l10.4-41.4c33.4-4.4 64.1-17.4 89.8-36.7c14.1-10.6 17-30.7 6.4-44.8s-30.7-17-44.8-6.4c-10.2 7.7-21.7 13.9-34 18.3L321 160c9.4-.3 18.5-4.7 24.6-12.8c10.6-14.1 7.8-34.2-6.4-44.8c-1.1-.8-2.2-1.6-3.3-2.4L351 39.8c4.3-17.1-6.1-34.5-23.3-38.8S293.2 7.1 289 24.2L277.2 71.5c-9.3-2.7-18.8-4.6-28.6-5.9L255 39.8zM163.2 143.3L117.3 326.8C103.9 306.5 96 282.2 96 256c0-48.7 27.2-91 67.2-112.7zm8.6 229.5l61.1-244.6c9.9 .7 19.5 2.5 28.7 5.3l-62 248.1c-9.7-1.9-19-4.8-27.8-8.8z"]
}, faHeadset = {
  prefix: "fas",
  iconName: "headset",
  icon: [512, 512, [], "f590", "M256 48C141.1 48 48 141.1 48 256l0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40C0 114.6 114.6 0 256 0S512 114.6 512 256l0 144.1c0 48.6-39.4 88-88.1 88L313.6 488c-8.3 14.3-23.8 24-41.6 24l-32 0c-26.5 0-48-21.5-48-48s21.5-48 48-48l32 0c17.8 0 33.3 9.7 41.6 24l110.4 .1c22.1 0 40-17.9 40-40L464 256c0-114.9-93.1-208-208-208zM144 208l16 0c17.7 0 32 14.3 32 32l0 112c0 17.7-14.3 32-32 32l-16 0c-35.3 0-64-28.7-64-64l0-48c0-35.3 28.7-64 64-64zm224 0c35.3 0 64 28.7 64 64l0 48c0 35.3-28.7 64-64 64l-16 0c-17.7 0-32-14.3-32-32l0-112c0-17.7 14.3-32 32-32l16 0z"]
}, faBadgerHoney = {
  prefix: "fas",
  iconName: "badger-honey",
  icon: [640, 512, [129441], "f6b4", "M164.6 389.3l16-37.3 118.1 0 16.9 101.3c2.6 15.4 15.9 26.7 31.6 26.7l31.1 0c19.8 0 34.8-17.8 31.6-37.3L393 342.1c27.9-29 80.6-70.8 144.1-90.8l16.1 25.8c3.1 5 10.4 5 13.6 0l22.8-36.5c12.9-2.1 25.2-7.4 34.4-16.6c10.2-10.2 16-24.1 16-38.6l0-3.8c0-23.2-12.6-44.5-32.8-55.8L525.3 80.3C506.1 69.6 484.5 64 462.5 64c-20.1 0-39.9 4.7-57.8 13.6L400 80c-21 10.5-44.2 16-67.8 16L160 96l-32 0C57.3 96 0 153.3 0 224l0 32c0 17.7 14.3 32 32 32c5.4 0 10.6-1.4 15-3.7c9.1 17.1 22.1 31.9 37.7 43.3l-16.8 59c-2.5 8.8-2.5 18.2 .2 27l13.1 43.7c4.1 13.5 16.5 22.8 30.7 22.8l29.2 0c21.4 0 36.8-20.7 30.7-41.2l-8.3-27.7c-2.2-7.2-1.7-14.9 1.2-21.8zM570 160l-51.3 0c.9 2.5 1.4 5.2 1.4 8c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-2.8 .5-5.5 1.4-8l-5.9 0c-23.2 0-46 6.3-65.9 18.2L294.8 242.3c-14.9 9-32 13.7-49.4 13.7L192 256c-46.4 0-86.2-28.2-103.2-68.5C102 161.7 129 144 160 144l172.2 0c31 0 61.5-7.2 89.2-21.1l4.7-2.4c11.3-5.6 23.7-8.6 36.3-8.6c13.8 0 27.4 3.5 39.5 10.2L570 160z"]
}, faH4 = {
  prefix: "fas",
  iconName: "h4",
  icon: [640, 512, [], "f86a", "M479 103.8L441 256l135 0 0-160c0-17.7 14.3-32 32-32s32 14.3 32 32l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-176 0c-9.9 0-19.2-4.5-25.2-12.3s-8.2-17.9-5.8-27.5l48-192c4.3-17.1 21.7-27.6 38.8-23.3s27.6 21.7 23.3 38.8zM32 64c17.7 0 32 14.3 32 32l0 128 192 0 0-128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 160 0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128L64 288l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 256 0 96C0 78.3 14.3 64 32 64z"]
}, faStoreSlash = {
  prefix: "fas",
  iconName: "store-slash",
  icon: [640, 512, [], "e071", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-86.8-68 0-17.1 0-131.4c-4 1-8 1.8-12.3 2.3c0 0 0 0-.1 0c-5.3 .7-10.7 1.1-16.2 1.1c-12.4 0-24.3-1.9-35.4-5.3l0 100.3L301.2 210.7c7-4.4 13.3-9.7 18.8-15.7c15.9 17.6 39.1 29 65.2 29c26.2 0 49.3-11.4 65.2-29c16 17.6 39.1 29 65.2 29c4.1 0 8.1-.3 12.1-.8c55.5-7.4 81.8-72.5 52.1-119.4L522.3 13.1C517.2 5 508.1 0 498.4 0L141.6 0c-9.7 0-18.8 5-23.9 13.1l-22.7 36L38.8 5.1zm73.4 218.1c4 .5 8.1 .8 12.1 .8c11 0 21.4-2 31-5.6L48.9 134.5c-6.1 40.6 19.5 82.8 63.3 88.7zM160 384l0-133.4c-11.2 3.5-23.2 5.4-35.6 5.4c-5.5 0-11-.4-16.3-1.1l-.1 0c-4.1-.6-8.1-1.3-12-2.3L96 384l0 64c0 35.3 28.7 64 64 64l320 0c12.9 0 24.8-3.8 34.9-10.3L365.5 384 160 384z"]
}, faRoadCircleXmark = {
  prefix: "fas",
  iconName: "road-circle-xmark",
  icon: [640, 512, [], "e566", "M213.2 32L288 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 74.8 0c27.1 0 51.3 17.1 60.3 42.6l42.7 120.6c-10.9-2.1-22.2-3.2-33.8-3.2c-59.5 0-112.1 29.6-144 74.8l0-42.8c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32c2.3 0 4.6-.3 6.8-.7c-4.5 15.5-6.8 31.8-6.8 48.7c0 5.4 .2 10.7 .7 16l-.7 0c-17.7 0-32 14.3-32 32l0 64L86.6 480C56.5 480 32 455.5 32 425.4c0-6.2 1.1-12.4 3.1-18.2L152.9 74.6C162 49.1 186.1 32 213.2 32zM496 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm22.6 144l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368z"]
}, faSignalSlash = {
  prefix: "fas",
  iconName: "signal-slash",
  icon: [640, 512, [], "f695", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L608 451.2 608 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 369.1-64-50.2L480 128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 172.8-64-50.2 0-26.6c0-17.7-14.3-32-32-32c-10.7 0-20.1 5.2-25.9 13.2L38.8 5.1zM576 512l-.3 0 .6 0-.3 0zm-96-32l0-5.8-64-50.4 0 56.2c0 17.7 14.3 32 32 32s32-14.3 32-32zM352 373.3l-64-50.4L288 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-106.7zM192 288c-17.7 0-32 14.3-32 32l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-17.7-14.3-32-32-32zM96 416c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64z"]
}, faUserMinus = {
  prefix: "fas",
  iconName: "user-minus",
  icon: [640, 512, [], "f503", "M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM0 482.3C0 383.8 79.8 304 178.3 304l91.4 0C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7L29.7 512C13.3 512 0 498.7 0 482.3zM472 200l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faMarsStrokeUp = {
  prefix: "fas",
  iconName: "mars-stroke-up",
  icon: [320, 512, [9896, "mars-stroke-v"], "f22a", "M148.7 4.7c6.2-6.2 16.4-6.2 22.6 0l64 64c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9l-40 0 0 24 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 24c0 .6 0 1.2-.1 1.8c77 11.6 136.1 78 136.1 158.2c0 88.4-71.6 160-160 160S0 440.4 0 352c0-80.2 59.1-146.7 136.1-158.2c0-.6-.1-1.2-.1-1.8l0-24-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-24L96 96c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l64-64zM256 352A96 96 0 1 0 64 352a96 96 0 1 0 192 0z"]
}, faMarsStrokeV = faMarsStrokeUp, faChampagneGlasses = {
  prefix: "fas",
  iconName: "champagne-glasses",
  icon: [640, 512, [129346, "glass-cheers"], "f79f", "M155.6 17.3C163 3 179.9-3.6 195 1.9L320 47.5l125-45.6c15.1-5.5 32 1.1 39.4 15.4l78.8 152.9c28.8 55.8 10.3 122.3-38.5 156.6L556.1 413l41-15c16.6-6 35 2.5 41 19.1s-2.5 35-19.1 41l-71.1 25.9L476.8 510c-16.6 6.1-35-2.5-41-19.1s2.5-35 19.1-41l41-15-31.3-86.2c-59.4 5.2-116.2-34-130-95.2L320 188.8l-14.6 64.7c-13.8 61.3-70.6 100.4-130 95.2l-31.3 86.2 41 15c16.6 6 25.2 24.4 19.1 41s-24.4 25.2-41 19.1L92.2 484.1 21.1 458.2c-16.6-6.1-25.2-24.4-19.1-41s24.4-25.2 41-19.1l41 15 31.3-86.2C66.5 292.5 48.1 226 76.9 170.2L155.6 17.3zm44 54.4l-27.2 52.8L261.6 157l13.1-57.9L199.6 71.7zm240.9 0L365.4 99.1 378.5 157l89.2-32.5L440.5 71.7z"]
}, faGlassCheers = faChampagneGlasses, faTaco = {
  prefix: "fas",
  iconName: "taco",
  icon: [512, 512, [127790], "f826", "M274.8 38.4l44.1 34.2c5.6 4.4 12.6 6.6 19.7 6.4l55.8-1.7c14-.4 26.5 8.6 30.4 22.1l15.6 53.6c2 6.8 6.3 12.8 12.2 16.8L498.6 201c11.6 7.9 16.3 22.5 11.6 35.7l-17.1 47.7C441.1 209.2 354.3 160 256 160s-185.1 49.2-237.1 124.4L1.8 236.7c-4.7-13.1 0-27.8 11.6-35.7l46.1-31.4c5.9-4 10.2-9.9 12.2-16.8L87.3 99.3c3.9-13.4 16.4-22.5 30.4-22.1L173.4 79c7.1 .2 14.1-2 19.7-6.4l44.1-34.2c11-8.6 26.5-8.6 37.5 0zM512 448c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32C0 306.6 114.6 192 256 192s256 114.6 256 256zM112 416a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]
}, faHexagonPlus = {
  prefix: "fas",
  iconName: "hexagon-plus",
  icon: [512, 512, ["plus-hexagon"], "f300", "M17.1 292c-12.9-22.3-12.9-49.7 0-72L105.4 67.1c12.9-22.3 36.6-36 62.4-36l176.6 0c25.7 0 49.5 13.7 62.4 36L494.9 220c12.9 22.3 12.9 49.7 0 72L406.6 444.9c-12.9 22.3-36.6 36-62.4 36l-176.6 0c-25.7 0-49.5-13.7-62.4-36L17.1 292zM232 344c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 64z"]
}, faPlusHexagon = faHexagonPlus, faClipboard = {
  prefix: "fas",
  iconName: "clipboard",
  icon: [384, 512, [128203], "f328", "M192 0c-41.8 0-77.4 26.7-90.5 64L64 64C28.7 64 0 92.7 0 128L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l-37.5 0C269.4 26.7 233.8 0 192 0zm0 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM112 192l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faHouseCircleExclamation = {
  prefix: "fas",
  iconName: "house-circle-exclamation",
  icon: [640, 512, [], "e50a", "M320.7 352c8.1-89.7 83.5-160 175.3-160c8.9 0 17.6 .7 26.1 1.9L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24c0 18 14 32.1 32 32.1l32 0 0 69.7c-.1 .9-.1 1.8-.1 2.8l0 112c0 22.1 17.9 40 40 40l16 0c1.2 0 2.4-.1 3.6-.2c1.5 .1 3 .2 4.5 .2l31.9 0 24 0c22.1 0 40-17.9 40-40l0-24 0-64c0-17.7 14.3-32 32-32l64 0 .7 0zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0-144c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]
}, faFileArrowUp = {
  prefix: "fas",
  iconName: "file-arrow-up",
  icon: [384, 512, ["file-upload"], "f574", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM216 408c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-102.1-31 31c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l72-72c9.4-9.4 24.6-9.4 33.9 0l72 72c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-31-31L216 408z"]
}, faFileUpload = faFileArrowUp, faWifi = {
  prefix: "fas",
  iconName: "wifi",
  icon: [640, 512, ["wifi-3", "wifi-strong"], "f1eb", "M54.2 202.9C123.2 136.7 216.8 96 320 96s196.8 40.7 265.8 106.9c12.8 12.2 33 11.8 45.2-.9s11.8-33-.9-45.2C549.7 79.5 440.4 32 320 32S90.3 79.5 9.8 156.7C-2.9 169-3.3 189.2 8.9 202s32.5 13.2 45.2 .9zM320 256c56.8 0 108.6 21.1 148.2 56c13.3 11.7 33.5 10.4 45.2-2.8s10.4-33.5-2.8-45.2C459.8 219.2 393 192 320 192s-139.8 27.2-190.5 72c-13.3 11.7-14.5 31.9-2.8 45.2s31.9 14.5 45.2 2.8c39.5-34.9 91.3-56 148.2-56zm64 160a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]
}, faWifi3 = faWifi, faWifiStrong = faWifi, faMessages = {
  prefix: "fas",
  iconName: "messages",
  icon: [640, 512, ["comments-alt"], "f4b6", "M64 0C28.7 0 0 28.7 0 64L0 256c0 35.3 28.7 64 64 64l32 0 0 48c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L202.7 320 352 320c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64L64 0zM352 352l-96 0 0 32c0 35.3 28.7 64 64 64l117.3 0 81.1 60.8c4.8 3.6 11.3 4.2 16.8 1.5s8.8-8.2 8.8-14.3l0-48 32 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64l-128 0 0 128c0 53-43 96-96 96z"]
}, faCommentsAlt = faMessages, faBath = {
  prefix: "fas",
  iconName: "bath",
  icon: [512, 512, [128705, "bathtub"], "f2cd", "M96 77.3c0-7.3 5.9-13.3 13.3-13.3c3.5 0 6.9 1.4 9.4 3.9l14.9 14.9C130 91.8 128 101.7 128 112c0 19.9 7.2 38 19.2 52c-5.3 9.2-4 21.1 3.8 29c9.4 9.4 24.6 9.4 33.9 0L289 89c9.4-9.4 9.4-24.6 0-33.9c-7.9-7.9-19.8-9.1-29-3.8C246 39.2 227.9 32 208 32c-10.3 0-20.2 2-29.2 5.5L163.9 22.6C149.4 8.1 129.7 0 109.3 0C66.6 0 32 34.6 32 77.3L32 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 256 96 77.3zM32 352l0 16c0 28.4 12.4 54 32 71.6L64 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-16 256 0 0 16c0 17.7 14.3 32 32 32s32-14.3 32-32l0-40.4c19.6-17.6 32-43.1 32-71.6l0-16L32 352z"]
}, faBathtub = faBath, faUmbrellaSimple = {
  prefix: "fas",
  iconName: "umbrella-simple",
  icon: [512, 512, ["umbrella-alt"], "e2bc", "M256 0c17.7 0 32 14.3 32 32l0 2C403.8 48.4 495.6 140.2 510 256.1c2.2 17.5-12.4 31.9-30 31.9L32 288C14.3 288-.2 273.6 2 256.1C16.4 140.2 108.2 48.4 224 34l0-2c0-17.7 14.3-32 32-32zm32 430.6c0 45-36.5 81.4-81.4 81.4c-30.8 0-59-17.4-72.8-45l-2.3-4.7c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3l2.3 4.7c3 5.9 9 9.6 15.6 9.6c9.6 0 17.4-7.8 17.4-17.4L224 320l64 0 0 110.6z"]
}, faUmbrellaAlt = faUmbrellaSimple, faRectangleHistoryCirclePlus = {
  prefix: "fas",
  iconName: "rectangle-history-circle-plus",
  icon: [640, 512, [], "e4a3", "M320 368c0 59.5 29.5 112.1 74.8 144L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64l384 0c23.8 0 44.5 12.9 55.5 32.2c-2.5-.1-5-.2-7.5-.2c-97.2 0-176 78.8-176 176zM440 80c13.3 0 24 10.7 24 24s-10.7 24-24 24L72 128c-13.3 0-24-10.7-24-24s10.7-24 24-24l368 0zM392 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L120 48c-13.3 0-24-10.7-24-24s10.7-24 24-24L392 0zM496 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48z"]
}, faUnderline = {
  prefix: "fas",
  iconName: "underline",
  icon: [448, 512, [], "f0cd", "M16 64c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0 0 128c0 53 43 96 96 96s96-43 96-96l0-128-16 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0 0 128c0 88.4-71.6 160-160 160s-160-71.6-160-160L64 96 48 96C30.3 96 16 81.7 16 64zM0 448c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32z"]
}, faPrescriptionBottlePill = {
  prefix: "fas",
  iconName: "prescription-bottle-pill",
  icon: [576, 512, [], "e5c0", "M0 32C0 14.3 14.3 0 32 0L352 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64L0 32zm32 96l320 0 0 83.2c-57 29.1-96 88.4-96 156.8c0 54.5 24.8 103.3 63.8 135.6c-9.4 5.4-20.2 8.4-31.8 8.4L96 512c-35.3 0-64-28.7-64-64l0-32 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L32 384l0-64 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L32 288l0-64 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L32 192l0-64zM304.8 300.5c6.7-12.6 23.6-13.5 33.7-3.4L502.9 461.5c10.1 10.1 9.2 27-3.4 33.7C479.4 505.9 456.4 512 432 512c-79.5 0-144-64.5-144-144c0-24.4 6.1-47.4 16.8-67.5zm254.5 135c-6.7 12.6-23.6 13.5-33.7 3.4L361.1 274.5c-10.1-10.1-9.2-27 3.4-33.7C384.6 230.1 407.6 224 432 224c79.5 0 144 64.5 144 144c0 24.4-6.1 47.4-16.8 67.5z"]
}, faUserPen = {
  prefix: "fas",
  iconName: "user-pen",
  icon: [640, 512, ["user-edit"], "f4ff", "M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512l293.1 0c-3.1-8.8-3.7-18.4-1.4-27.8l15-60.1c2.8-11.3 8.6-21.5 16.8-29.7l40.3-40.3c-32.1-31-75.7-50.1-123.9-50.1l-91.4 0zm435.5-68.3c-15.6-15.6-40.9-15.6-56.6 0l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4zM375.9 417c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L576.1 358.7l-71-71L375.9 417z"]
}, faUserEdit = faUserPen, faBinarySlash = {
  prefix: "fas",
  iconName: "binary-slash",
  icon: [640, 512, [], "e33e", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L512 376l0-24c0-35.3-28.7-64-64-64l-48.3 0L298 208.3c13.5-11.7 22-29 22-48.3l0-96c0-35.3-28.7-64-64-64L192 0c-35.3 0-64 28.7-64 64l0 11L38.8 5.1zM192 125.2L192 64l64 0 0 96-19.6 0L192 125.2zM464 32c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 83.6-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l48 0 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128zM240 320c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 83.6-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l48 0 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128zm80 32l0 96c0 35.3 28.7 64 64 64l64 0c20.1 0 38.1-9.3 49.8-23.8l-51-40.2L384 448l0-49.5-63.9-50.3c-.1 1.3-.1 2.5-.1 3.8z"]
}, faSquareO = {
  prefix: "fas",
  iconName: "square-o",
  icon: [448, 512, [], "e278", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 224a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zm80 128a128 128 0 1 1 0-256 128 128 0 1 1 0 256z"]
}, faCaduceus = {
  prefix: "fas",
  iconName: "caduceus",
  icon: [512, 512, [], "e681", "M280 89.6c14.3-8.3 24-23.8 24-41.6c0-26.5-21.5-48-48-48s-48 21.5-48 48c0 17.8 9.7 33.3 24 41.6l0 22.4L171.5 71.7c-7.5-5-16.4-7.7-25.4-7.7c-11.6 0-22.9 4.4-31.3 12.4L8.8 175.7C3.2 181 0 188.4 0 196.1C0 211.5 12.5 224 27.9 224l110.8 0c33.5 0 66.2-10.5 93.3-30l0 136.5-20.6-12.3c-12-7.2-19.4-20.2-19.4-34.3l0-3.8c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 3.8c0 30.9 16.2 59.6 42.7 75.5l22.6 13.6-6.6 4c-26.5 15.9-42.7 44.5-42.7 75.5l0 3.8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-3.8c0-14.1 7.4-27.1 19.4-34.3l4.6-2.7 0 40.8 0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32 0-40.8 4.6 2.7c12 7.2 19.4 20.2 19.4 34.3l0 3.8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-3.8c0-30.9-16.2-59.6-42.7-75.5l-6.6-4 22.6-13.6c26.5-15.9 42.7-44.5 42.7-75.5l0-3.8c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 3.8c0 14.1-7.4 27.1-19.4 34.3L280 330.4 280 194c27.2 19.5 59.8 30 93.3 30l110.8 0c15.4 0 27.9-12.5 27.9-27.9c0-7.7-3.2-15.1-8.8-20.4l-106-99.3c-8.5-8-19.7-12.4-31.3-12.4c-9 0-17.9 2.7-25.4 7.7L280 112l0-22.4z"]
}, faSignature = {
  prefix: "fas",
  iconName: "signature",
  icon: [640, 512, [], "f5b7", "M192 128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 7.8c0 27.7-2.4 55.3-7.1 82.5l-84.4 25.3c-40.6 12.2-68.4 49.6-68.4 92l0 71.9c0 40 32.5 72.5 72.5 72.5c26 0 50-13.9 62.9-36.5l13.9-24.3c26.8-47 46.5-97.7 58.4-150.5l94.4-28.3-12.5 37.5c-3.3 9.8-1.6 20.5 4.4 28.8s15.7 13.3 26 13.3l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-83.6 0 18-53.9c3.8-11.3 .9-23.8-7.4-32.4s-20.7-11.8-32.2-8.4L316.4 198.1c2.4-20.7 3.6-41.4 3.6-62.3l0-7.8c0-53-43-96-96-96s-96 43-96 96l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32zm-9.2 177l49-14.7c-10.4 33.8-24.5 66.4-42.1 97.2l-13.9 24.3c-1.5 2.6-4.3 4.3-7.4 4.3c-4.7 0-8.5-3.8-8.5-8.5l0-71.9c0-14.1 9.3-26.6 22.8-30.7zM24 368c-13.3 0-24 10.7-24 24s10.7 24 24 24l40.3 0c-.2-2.8-.3-5.6-.3-8.5L64 368l-40 0zm592 48c13.3 0 24-10.7 24-24s-10.7-24-24-24l-310.1 0c-6.7 16.3-14.2 32.3-22.3 48L616 416z"]
}, faStroopwafel = {
  prefix: "fas",
  iconName: "stroopwafel",
  icon: [512, 512, [], "f551", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM312.6 63.7c-6.2-6.2-16.4-6.2-22.6 0L256 97.6 222.1 63.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l33.9 33.9-45.3 45.3-56.6-56.6c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l56.6 56.6-45.3 45.3L86.3 199.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L97.6 256 63.7 289.9c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l33.9-33.9 45.3 45.3-56.6 56.6c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l56.6-56.6 45.3 45.3-33.9 33.9c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L256 414.4l33.9 33.9c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-33.9-33.9 45.3-45.3 56.6 56.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-56.6-56.6 45.3-45.3 33.9 33.9c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L414.4 256l33.9-33.9c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-33.9 33.9-45.3-45.3 56.6-56.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-56.6 56.6-45.3-45.3 33.9-33.9c6.2-6.2 6.2-16.4 0-22.6zM142.9 256l45.3-45.3L233.4 256l-45.3 45.3L142.9 256zm67.9 67.9L256 278.6l45.3 45.3L256 369.1l-45.3-45.3zM278.6 256l45.3-45.3L369.1 256l-45.3 45.3L278.6 256zm22.6-67.9L256 233.4l-45.3-45.3L256 142.9l45.3 45.3z"]
}, faBold = {
  prefix: "fas",
  iconName: "bold",
  icon: [384, 512, [], "f032", "M0 64C0 46.3 14.3 32 32 32l48 0 16 0 128 0c70.7 0 128 57.3 128 128c0 31.3-11.3 60.1-30 82.3c37.1 22.4 62 63.1 62 109.7c0 70.7-57.3 128-128 128L96 480l-16 0-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-160L48 96 32 96C14.3 96 0 81.7 0 64zM224 224c35.3 0 64-28.7 64-64s-28.7-64-64-64L112 96l0 128 112 0zM112 288l0 128 144 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-32 0-112 0z"]
}, faAnchorLock = {
  prefix: "fas",
  iconName: "anchor-lock",
  icon: [640, 512, [], "e4ad", "M320 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm21.1 80C367 158.8 384 129.4 384 96c0-53-43-96-96-96s-96 43-96 96c0 33.4 17 62.8 42.9 80L224 176c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 208-48 0c-53 0-96-43-96-96l0-6.1 7 7c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L97 263c-9.4-9.4-24.6-9.4-33.9 0L7 319c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l7-7 0 6.1c0 88.4 71.6 160 160 160l80 0 80 0c8 0 15.9-.6 23.6-1.7c-4.8-9-7.6-19.3-7.6-30.3l0-33.3c-5.2 .9-10.5 1.3-16 1.3l-48 0 0-208 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-10.9 0zM528 240c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]
}, faBuildingNgo = {
  prefix: "fas",
  iconName: "building-ngo",
  icon: [384, 512, [], "e4d7", "M48 0C21.5 0 0 21.5 0 48L0 464c0 26.5 21.5 48 48 48l96 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 96 0c26.5 0 48-21.5 48-48l0-416c0-26.5-21.5-48-48-48L48 0zM64 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm112-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM168 64l48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 64 16 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 24c0 13.3-10.7 24-24 24l-32 0c-13.3 0-24-10.7-24-24l0-88c0-8.8 7.2-16 16-16zM304 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c0-8.8-7.2-16-16-16zm-48 16c0-26.5 21.5-48 48-48s48 21.5 48 48l0 32c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-32zM61.3 71.1l34.7 52L96 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 7.1-4.6 13.3-11.4 15.3s-14-.6-17.9-6.4L64 132.8 64 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4z"]
}, faTransporter3 = {
  prefix: "fas",
  iconName: "transporter-3",
  icon: [512, 512, [], "e045", "M256 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM128 512l88 0 80 0 88 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0c-17.7 0-32 14.3-32 32s14.3 32 32 32zM56.7 102.6C55.6 98.7 52.1 96 48 96s-7.6 2.7-8.7 6.6L32 128 6.6 135.3C2.7 136.4 0 139.9 0 144s2.7 7.6 6.6 8.7L32 160l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 160l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 128l-7.3-25.4zM480 32L472.7 6.6C471.6 2.7 468.1 0 464 0s-7.6 2.7-8.7 6.6L448 32l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7s2.7 7.6 6.6 8.7L448 64l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 64l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 32zM176 128c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0zm-32 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0zm-32 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0zm64 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0z"]
}, faEngineWarning = {
  prefix: "fas",
  iconName: "engine-warning",
  icon: [640, 512, ["engine-exclamation"], "f5f2", "M400 112c13.3 0 24-10.7 24-24s-10.7-24-24-24L208 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 0 32-72 0-48 0-32 0c-17.7 0-32 14.3-32 32l0 56-48 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24L0 352c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 48 0 0 72c0 17.7 14.3 32 32 32l44.8 0 32 40c12.1 15.2 30.5 24 50 24L448 448c35.3 0 64-28.7 64-64l0-145.2c0-19.4-8.8-37.8-24-50L449.5 158c-11.3-9.1-25.4-14-40-14L328 144l0-32 72 0zM544 224l0 192c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32zM304 188c11 0 20 9 20 20l0 88c0 11-9 20-20 20s-20-9-20-20l0-88c0-11 9-20 20-20zM280 368a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faEngineExclamation = faEngineWarning, faCircleDownRight = {
  prefix: "fas",
  iconName: "circle-down-right",
  icon: [512, 512, [], "e108", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zm96 198.6L352 336c0 8.8-7.2 16-16 16l-137.4 0c-12.5 0-22.6-10.1-22.6-22.6c0-6 2.4-11.8 6.6-16L216 280l-66.3-66.3C146 210 144 205.1 144 200s2-10 5.7-13.7l36.7-36.7c3.6-3.6 8.5-5.7 13.7-5.7s10 2 13.7 5.7L280 216l33.4-33.4c4.2-4.2 10-6.6 16-6.6c12.5 0 22.6 10.1 22.6 22.6z"]
}, faSquareK = {
  prefix: "fas",
  iconName: "square-k",
  icon: [448, 512, [], "e274", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM313.1 168.8l-73 74.3 75.3 102.7c7.8 10.7 5.5 25.7-5.2 33.5s-25.7 5.5-33.5-5.2L206 277.8l-30 30.5 0 51.7c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-61.5L128 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 87.8L278.9 135.2c9.3-9.5 24.5-9.6 33.9-.3s9.6 24.5 .3 33.9z"]
}, faManatSign = {
  prefix: "fas",
  iconName: "manat-sign",
  icon: [384, 512, [], "e1d5", "M192 32c-17.7 0-32 14.3-32 32l0 34.7C69.2 113.9 0 192.9 0 288L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-59.6 40.8-109.8 96-124l0 284c0 17.7 14.3 32 32 32s32-14.3 32-32l0-284c55.2 14.2 96 64.3 96 124l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-95.1-69.2-174.1-160-189.3L224 64c0-17.7-14.3-32-32-32z"]
}, faMoneyCheckPen = {
  prefix: "fas",
  iconName: "money-check-pen",
  icon: [640, 512, ["money-check-edit"], "f872", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l266.5 0 6-23.9c2.8-11.3 8.6-21.5 16.8-29.7L534.6 213.1c11.6-11.6 26.3-18.5 41.4-20.5l0-64.6c0-35.3-28.7-64-64-64L64 64zm48 224l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM96 208c0-8.8 7.2-16 16-16l320 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-320 0c-8.8 0-16-7.2-16-16zm517.8 27.7c-15.6-15.6-40.9-15.6-56.6 0l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4zM375.9 417c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L576.1 358.7l-71-71L375.9 417z"]
}, faMoneyCheckEdit = faMoneyCheckPen, faNotEqual = {
  prefix: "fas",
  iconName: "not-equal",
  icon: [448, 512, [], "f53e", "M369.8 37.4c14.7 9.8 18.7 29.7 8.9 44.4L337.1 144l62.9 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-105.5 0-64 96L400 304c17.7 0 32 14.3 32 32s-14.3 32-32 32l-212.2 0-65.2 97.7c-9.8 14.7-29.7 18.7-44.4 8.9s-18.7-29.7-8.9-44.4L110.9 368 48 368c-17.7 0-32-14.3-32-32s14.3-32 32-32l105.5 0 64-96L48 208c-17.7 0-32-14.3-32-32s14.3-32 32-32l212.2 0 65.2-97.7c9.8-14.7 29.7-18.7 44.4-8.9z"]
}, faBorderTopLeft = {
  prefix: "fas",
  iconName: "border-top-left",
  icon: [448, 512, ["border-style"], "f853", "M0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-336c0-8.8 7.2-16 16-16l336 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 32C35.8 32 0 67.8 0 112L0 448zm160 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm192 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-96 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm192 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM416 288a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm0 32a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm0-128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faBorderStyle = faBorderTopLeft, faMapLocationDot = {
  prefix: "fas",
  iconName: "map-location-dot",
  icon: [576, 512, ["map-marked-alt"], "f5a0", "M408 120c0 54.6-73.1 151.9-105.2 192c-7.7 9.6-22 9.6-29.6 0C241.1 271.9 168 174.6 168 120C168 53.7 221.7 0 288 0s120 53.7 120 120zm8 80.4c3.5-6.9 6.7-13.8 9.6-20.6c.5-1.2 1-2.5 1.5-3.7l116-46.4C558.9 123.4 576 135 576 152l0 270.8c0 9.8-6 18.6-15.1 22.3L416 503l0-302.6zM137.6 138.3c2.4 14.1 7.2 28.3 12.8 41.5c2.9 6.8 6.1 13.7 9.6 20.6l0 251.4L32.9 502.7C17.1 509 0 497.4 0 480.4L0 209.6c0-9.8 6-18.6 15.1-22.3l122.6-49zM327.8 332c13.9-17.4 35.7-45.7 56.2-77l0 249.3L192 449.4 192 255c20.5 31.3 42.3 59.6 56.2 77c20.5 25.6 59.1 25.6 79.6 0zM288 152a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]
}, faMapMarkedAlt = faMapLocationDot, faTilde = {
  prefix: "fas",
  iconName: "tilde",
  icon: [448, 512, [63135], "7e", "M99.9 192C80.1 192 64 208.1 64 227.9L64 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-92.1C0 172.7 44.7 128 99.9 128c26.5 0 51.9 10.5 70.6 29.3L322.7 309.5c6.7 6.7 15.9 10.5 25.4 10.5c19.8 0 35.9-16.1 35.9-35.9l0-92.1c0-17.7 14.3-32 32-32s32 14.3 32 32l0 92.1c0 55.2-44.7 99.9-99.9 99.9c-26.5 0-51.9-10.5-70.6-29.3L125.3 202.5c-6.7-6.7-15.9-10.5-25.4-10.5z"]
}, faJedi = {
  prefix: "fas",
  iconName: "jedi",
  icon: [576, 512, [], "f669", "M246 315.7l-21.2-31.9c-2.1-3.2-1.7-7.4 1-10.1s6.9-3.1 10.1-1l29.5 19.7c2.1 1.4 4.9 0 5-2.6L279.7 8c.1-4.5 3.8-8 8.3-8s8.1 3.5 8.3 8l9.4 281.9c.1 2.5 2.9 3.9 5 2.6l29.5-19.7c3.2-2.1 7.4-1.7 10.1 1s3.1 6.9 1 10.1L330 315.7c-1.3 1.9-.2 4.5 2 4.9l37.6 7.5c3.7 .7 6.4 4 6.4 7.8s-2.7 7.1-6.4 7.8L332 351.4c-2.2 .4-3.3 3-2 4.9l21.2 31.9c2.1 3.2 1.7 7.4-1 10.1s-6.9 3.1-10.1 1l-26.3-17.6c-2.2-1.4-5.1 .2-5 2.8l2.1 61.5C370.6 435.2 416 382.9 416 320c0-37-15.7-70.4-40.8-93.7c-7-6.5-6.5-18.6 1-24.4C410.1 175.5 432 134.3 432 88c0-16.8-2.9-33-8.2-48c-4.6-13 10.2-30 21.4-22c53.5 38 92.7 94.8 107.8 160.7c.5 2.1-.2 4.3-1.7 5.9l-28.4 28.4c-4 4-1.2 10.9 4.5 10.9l26 0c3.4 0 6.2 2.6 6.3 6c.1 3.3 .2 6.6 .2 10c0 17.5-1.7 34.7-4.8 51.3c-.2 1.2-.9 2.4-1.7 3.3l-46.5 46.5c-4 4-1.2 10.9 4.5 10.9l14.6 0c4.6 0 7.7 4.8 5.7 9C487.2 450.5 394.8 512 288 512S88.8 450.5 44.3 361c-2.1-4.2 1-9 5.7-9l14.6 0c5.7 0 8.6-6.9 4.5-10.9L22.6 294.6c-.9-.9-1.5-2-1.7-3.3C17.7 274.7 16 257.5 16 240c0-3.3 .1-6.7 .2-10c.1-3.4 2.9-6 6.3-6l26 0c5.7 0 8.6-6.9 4.5-10.9L24.6 184.6c-1.5-1.5-2.2-3.8-1.7-5.9C38.1 112.8 77.3 56 130.8 18c11.3-8 26 8.9 21.4 22c-5.3 15-8.2 31.2-8.2 48c0 46.3 21.9 87.5 55.8 113.9c7.5 5.8 8 17.9 1 24.4C175.7 249.6 160 283 160 320c0 62.9 45.4 115.2 105.1 126l2.1-61.5c.1-2.6-2.8-4.2-5-2.8l-26.3 17.6c-3.2 2.1-7.4 1.7-10.1-1s-3.1-6.9-1-10.1L246 356.3c1.3-1.9 .2-4.5-2-4.9l-37.6-7.5c-3.7-.7-6.4-4-6.4-7.8s2.7-7.1 6.4-7.8l37.6-7.5c2.2-.4 3.3-3 2-4.9z"]
}, faSquarePollVertical = {
  prefix: "fas",
  iconName: "square-poll-vertical",
  icon: [448, 512, ["poll"], "f681", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 192c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32zm64-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-192zM320 288c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32z"]
}, faPoll = faSquarePollVertical, faArrowDownSquareTriangle = {
  prefix: "fas",
  iconName: "arrow-down-square-triangle",
  icon: [576, 512, ["sort-shapes-down-alt"], "f889", "M183.6 469.6C177.5 476.2 169 480 160 480s-17.5-3.8-23.6-10.4l-88-96c-11.9-13-11.1-33.3 2-45.2s33.3-11.1 45.2 2L128 365.7 128 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 301.7 32.4-35.4c11.9-13 32.2-13.9 45.2-2s13.9 32.2 2 45.2l-88 96zM320 72c0-22.1 17.9-40 40-40l112 0c22.1 0 40 17.9 40 40l0 112c0 22.1-17.9 40-40 40l-112 0c-22.1 0-40-17.9-40-40l0-112zM443.1 303l80 128c6.2 9.9 6.5 22.3 .9 32.5s-16.4 16.5-28 16.5l-160 0c-11.6 0-22.3-6.3-28-16.5s-5.3-22.6 .9-32.5l80-128c5.8-9.4 16.1-15 27.1-15s21.3 5.7 27.1 15z"]
}, faSortShapesDownAlt = faArrowDownSquareTriangle, faMugHot = {
  prefix: "fas",
  iconName: "mug-hot",
  icon: [512, 512, [9749], "f7b6", "M88 0C74.7 0 64 10.7 64 24c0 38.9 23.4 59.4 39.1 73.1l1.1 1C120.5 112.3 128 119.9 128 136c0 13.3 10.7 24 24 24s24-10.7 24-24c0-38.9-23.4-59.4-39.1-73.1l-1.1-1C119.5 47.7 112 40.1 112 24c0-13.3-10.7-24-24-24zM32 192c-17.7 0-32 14.3-32 32L0 416c0 53 43 96 96 96l192 0c53 0 96-43 96-96l16 0c61.9 0 112-50.1 112-112s-50.1-112-112-112l-48 0L32 192zm352 64l16 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0 0-96zM224 24c0-13.3-10.7-24-24-24s-24 10.7-24 24c0 38.9 23.4 59.4 39.1 73.1l1.1 1C232.5 112.3 240 119.9 240 136c0 13.3 10.7 24 24 24s24-10.7 24-24c0-38.9-23.4-59.4-39.1-73.1l-1.1-1C231.5 47.7 224 40.1 224 24z"]
}, faDogLeashed = {
  prefix: "fas",
  iconName: "dog-leashed",
  icon: [576, 512, [129454], "f6d4", "M122.7 4.1l160 144c6.6 5.9 7.1 16 1.2 22.6s-16 7.1-22.6 1.2l-160-144c-6.6-5.9-7.1-16-1.2-22.6s16-7.1 22.6-1.2zM144 192l112 0 0 191.3c-5.3 .5-10.6 .7-16 .7c-28.8 0-56-6.9-80-19.2L160 480c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-230.2c-28.8-10.9-51.4-35.3-59.2-66.5L1 167.8c-4.3-17.1 6.1-34.5 23.3-38.8s34.5 6.1 38.8 23.3l3.9 15.5C70.5 182 83.3 192 98 192l30 0 16 0zM320 364.8c-10.1 5.2-20.8 9.4-32 12.6l0-169.3L416 262l0 218c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-115.2zM426.7 192l-6.2 37.2L305.9 180.9l26.8-161C334.6 8.4 344.5 0 356.1 0c7.5 0 14.5 3.5 19 9.5L392 32l52.1 0c12.7 0 24.9 5.1 33.9 14.1L496 64l56 0c13.3 0 24 10.7 24 24l0 24c0 44.2-35.8 80-80 80l-32 0-16 0-21.3 0zM448 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]
}, faCarBattery = {
  prefix: "fas",
  iconName: "car-battery",
  icon: [512, 512, ["battery-car"], "f5df", "M80 96c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l96 0c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l16 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l16 0zm304 96c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-32zM80 240c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16z"]
}, faBatteryCar = faCarBattery, faFaceDowncastSweat = {
  prefix: "fas",
  iconName: "face-downcast-sweat",
  icon: [512, 512, [], "e371", "M35.2 126.3c4.1 1.1 8.4 1.7 12.8 1.7c26.5 0 48-21 48-47c0-5-1.8-11.3-4.6-18.1c-.3-.7-.6-1.4-.9-2.1c-8.9-20.2-26.5-44.9-36-57.5c-3.2-4.4-9.6-4.4-12.8 0C28.6 20.6 0 61 0 81c0 21.7 14.9 39.8 35.2 45.3zM256 0c-51.4 0-99.3 15.2-139.4 41.2c1.5 3.1 3 6.2 4.3 9.3c3.4 8 7.1 19 7.1 30.5c0 44.3-36.6 79-80 79c-9.6 0-18.8-1.7-27.4-4.8C7.3 186.2 0 220.2 0 256C0 397.4 114.6 512 256 512s256-114.6 256-256S397.4 0 256 0zM195.9 410.7c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6C188.2 371.4 216.3 352 256 352s67.8 19.4 83.9 37.3c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7zM96 272c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm208-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faMailboxFlagUp = {
  prefix: "fas",
  iconName: "mailbox-flag-up",
  icon: [576, 512, [], "e5bb", "M400 16c-29.8 0-54.9 20.4-62 48l-92.8 0C290.4 95.9 320 148.5 320 208l0 176c0 24.6-9.2 47-24.4 64L512 448c35.3 0 64-28.7 64-64l0-176c0-42.6-18.5-81-48-107.3L528 80c0-35.3-28.7-64-64-64l-64 0zm0 208c-8.8 0-16-7.2-16-16l0-96 0-32c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 80c0 8.8-7.2 16-16 16zM0 208L0 384c0 35.3 28.7 64 64 64l160 0c35.3 0 64-28.7 64-64l0-176c0-79.5-64.5-144-144-144S0 128.5 0 208zm64 0c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 224c-8.8 0-16-7.2-16-16z"]
}, faMemoCircleInfo = {
  prefix: "fas",
  iconName: "memo-circle-info",
  icon: [576, 512, [], "e49a", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 134.6C310.1 219.5 256 287.4 256 368c0 59.1 29.1 111.3 73.7 143.3c-3.2 .5-6.4 .7-9.7 .7L64 512c-35.3 0-64-28.7-64-64L0 64zm64 80c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 128c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 224zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zm352-96a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm0 96a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-32 48c0 8.8 7.2 16 16 16c0 0 0 0 0 0l0 48s0 0 0 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l0-64c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16z"]
}, faGift = {
  prefix: "fas",
  iconName: "gift",
  icon: [512, 512, [127873], "f06b", "M190.5 68.8L225.3 128l-1.3 0-72 0c-22.1 0-40-17.9-40-40s17.9-40 40-40l2.2 0c14.9 0 28.8 7.9 36.3 20.8zM64 88c0 14.4 3.5 28 9.6 40L32 128c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-41.6 0c6.1-12 9.6-25.6 9.6-40c0-48.6-39.4-88-88-88l-2.2 0c-31.9 0-61.5 16.9-77.7 44.4L256 85.5l-24.1-41C215.7 16.9 186.1 0 154.2 0L152 0C103.4 0 64 39.4 64 88zm336 0c0 22.1-17.9 40-40 40l-72 0-1.3 0 34.8-59.2C329.1 55.9 342.9 48 357.8 48l2.2 0c22.1 0 40 17.9 40 40zM32 288l0 176c0 26.5 21.5 48 48 48l144 0 0-224L32 288zM288 512l144 0c26.5 0 48-21.5 48-48l0-176-192 0 0 224z"]
}, faDiceTwo = {
  prefix: "fas",
  iconName: "dice-two",
  icon: [448, 512, [9857], "f528", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM352 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faVolume = {
  prefix: "fas",
  iconName: "volume",
  icon: [576, 512, [128265, "volume-medium"], "f6a8", "M333.1 34.8C344.6 40 352 51.4 352 64l0 384c0 12.6-7.4 24-18.9 29.2s-25 3.1-34.4-5.3L163.8 352 96 352c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l67.8 0L298.7 40.1c9.4-8.4 22.9-10.4 34.4-5.3zm172 72.2c43.2 35.2 70.9 88.9 70.9 149s-27.7 113.8-70.9 149c-10.3 8.4-25.4 6.8-33.8-3.5s-6.8-25.4 3.5-33.8C507.3 341.3 528 301.1 528 256s-20.7-85.3-53.2-111.8c-10.3-8.4-11.8-23.5-3.5-33.8s23.5-11.8 33.8-3.5zm-60.5 74.5C466.1 199.1 480 225.9 480 256s-13.9 56.9-35.4 74.5c-10.3 8.4-25.4 6.8-33.8-3.5s-6.8-25.4 3.5-33.8C425.1 284.4 432 271 432 256s-6.9-28.4-17.7-37.3c-10.3-8.4-11.8-23.5-3.5-33.8s23.5-11.8 33.8-3.5z"]
}, faVolumeMedium = faVolume, faTransporter5 = {
  prefix: "fas",
  iconName: "transporter-5",
  icon: [512, 512, [], "e2a6", "M480 32l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L480 64l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L448 64l-25.4-7.3c-3.9-1.1-6.6-4.7-6.6-8.7s2.7-7.6 6.6-8.7L448 32l7.3-25.4C456.4 2.7 459.9 0 464 0s7.6 2.7 8.7 6.6L480 32zM56.7 134.6L64 160l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L64 192l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L32 192 6.6 184.7C2.7 183.6 0 180.1 0 176s2.7-7.6 6.6-8.7L32 160l7.3-25.4c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6zM384 512l-88 0-80 0-88 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32zM224 0l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM176 128l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM112 256l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm64 128l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faGaugeCircleBolt = {
  prefix: "fas",
  iconName: "gauge-circle-bolt",
  icon: [640, 512, [], "e496", "M496 192c2.7 0 5.3 .1 8 .2C475.6 81.7 375.4 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c39.5 0 77-9 110.4-25C337.6 455.7 320 413.9 320 368c0-97.2 78.8-176 176-176zM320 352c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-26.9 16.5-49.9 40-59.3L232 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 204.7c23.5 9.5 40 32.5 40 59.3zM144 112a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM336 144a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm47.9-225c4.3 3.7 5.4 9.9 2.6 14.9L516.4 356l35.6 0c5.2 0 9.8 3.3 11.4 8.2s-.1 10.3-4.2 13.4l-96 72c-4.5 3.4-10.8 3.2-15.1-.6s-5.4-9.9-2.6-14.9L475.6 380 440 380c-5.2 0-9.8-3.3-11.4-8.2s.1-10.3 4.2-13.4l96-72c4.5-3.4 10.8-3.2 15.1 .6z"]
}, faCoinFront = {
  prefix: "fas",
  iconName: "coin-front",
  icon: [512, 512, [], "e3fc", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM256 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320zm0 352a192 192 0 1 0 0-384 192 192 0 1 0 0 384zm24-264c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144z"]
}, faFileSlash = {
  prefix: "fas",
  iconName: "file-slash",
  icon: [640, 512, [], "e3a7", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L512 376l0-216-128 0c-17.7 0-32-14.3-32-32L352 0 192 0c-35.3 0-64 28.7-64 64l0 11L38.8 5.1zM128 196.9L128 448c0 35.3 28.7 64 64 64l256 0c20.1 0 38.1-9.3 49.8-23.8L128 196.9zM512 128L384 0l0 128 128 0z"]
}, faMessageArrowUpRight = {
  prefix: "fas",
  iconName: "message-arrow-up-right",
  icon: [512, 512, [], "e1dd", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zm200 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l54.1 0-87 87c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l87-87 0 54.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24l-112 0z"]
}, faTreasureChest = {
  prefix: "fas",
  iconName: "treasure-chest",
  icon: [576, 512, [], "f723", "M0 160l0 96 128 0 0-224C57.3 32 0 89.3 0 160zM0 432c0 26.5 21.5 48 48 48l80 0 0-192L0 288 0 432zM416 288l-64 0 0 32c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-32-64 0 0 192 256 0 0-192zM528 480c26.5 0 48-21.5 48-48l0-144-128 0 0 192 80 0zm48-320c0-70.7-57.3-128-128-128l0 224 128 0 0-96zM416 256l0-224L160 32l0 224 64 0 0-32c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 32 64 0zM304 240c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64z"]
}, faChessQueen = {
  prefix: "fas",
  iconName: "chess-queen",
  icon: [512, 512, [9819], "f445", "M256 0a56 56 0 1 1 0 112A56 56 0 1 1 256 0zM134.1 143.8c3.3-13 15-23.8 30.2-23.8c12.3 0 22.6 7.2 27.7 17c12 23.2 36.2 39 64 39s52-15.8 64-39c5.1-9.8 15.4-17 27.7-17c15.3 0 27 10.8 30.2 23.8c7 27.8 32.2 48.3 62.1 48.3c10.8 0 21-2.7 29.8-7.4c8.4-4.4 18.9-4.5 27.6 .9c13 8 17.1 25 9.2 38L399.7 400 384 400l-40.4 0-175.1 0L128 400l-15.7 0L5.4 223.6c-7.9-13-3.8-30 9.2-38c8.7-5.3 19.2-5.3 27.6-.9c8.9 4.7 19 7.4 29.8 7.4c29.9 0 55.1-20.5 62.1-48.3zM256 224s0 0 0 0s0 0 0 0s0 0 0 0zM112 432l288 0 41.4 41.4c4.2 4.2 6.6 10 6.6 16c0 12.5-10.1 22.6-22.6 22.6L86.6 512C74.1 512 64 501.9 64 489.4c0-6 2.4-11.8 6.6-16L112 432z"]
}, faPaintbrushFine = {
  prefix: "fas",
  iconName: "paintbrush-fine",
  icon: [576, 512, ["paint-brush-alt", "paint-brush-fine", "paintbrush-alt"], "f5a9", "M559.6 16.4c21.9 21.9 21.9 57.3 0 79.2L306.9 348.3l-79.2-79.2L480.4 16.4c21.9-21.9 57.3-21.9 79.2 0zM205.1 291.7l79.2 79.2-.1 .1c2.5 9.3 3.8 19 3.8 29c0 61.9-50.1 112-112 112L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l4.8 0c17.6 0 29.6-18.9 27.8-36.4c-.4-3.8-.6-7.7-.6-11.6c0-61.9 50.1-112 112-112c10 0 19.8 1.3 29 3.8l.1-.1z"]
}, faPaintBrushAlt = faPaintbrushFine, faPaintBrushFine = faPaintbrushFine, faPaintbrushAlt = faPaintbrushFine, faGlasses = {
  prefix: "fas",
  iconName: "glasses",
  icon: [576, 512, [], "f530", "M118.6 80c-11.5 0-21.4 7.9-24 19.1L57 260.3c20.5-6.2 48.3-12.3 78.7-12.3c32.3 0 61.8 6.9 82.8 13.5c10.6 3.3 19.3 6.7 25.4 9.2c3.1 1.3 5.5 2.4 7.3 3.2c.9 .4 1.6 .7 2.1 1l.6 .3 .2 .1c0 0 .1 0 .1 0c0 0 0 0 0 0s0 0 0 0L247.9 288s0 0 0 0l6.3-12.7c5.8 2.9 10.4 7.3 13.5 12.7l40.6 0c3.1-5.3 7.7-9.8 13.5-12.7l6.3 12.7s0 0 0 0c-6.3-12.7-6.3-12.7-6.3-12.7s0 0 0 0s0 0 0 0c0 0 .1 0 .1 0l.2-.1 .6-.3c.5-.2 1.2-.6 2.1-1c1.8-.8 4.2-1.9 7.3-3.2c6.1-2.6 14.8-5.9 25.4-9.2c21-6.6 50.4-13.5 82.8-13.5c30.4 0 58.2 6.1 78.7 12.3L481.4 99.1c-2.6-11.2-12.6-19.1-24-19.1c-3.1 0-6.2 .6-9.2 1.8L416.9 94.3c-12.3 4.9-26.3-1.1-31.2-13.4s1.1-26.3 13.4-31.2l31.3-12.5c8.6-3.4 17.7-5.2 27-5.2c33.8 0 63.1 23.3 70.8 56.2l43.9 188c1.7 7.3 2.9 14.7 3.5 22.1c.3 1.9 .5 3.8 .5 5.7l0 6.7 0 41.3 0 16c0 61.9-50.1 112-112 112l-44.3 0c-59.4 0-108.5-46.4-111.8-105.8L306.6 352l-37.2 0-1.2 22.2C264.9 433.6 215.8 480 156.3 480L112 480C50.1 480 0 429.9 0 368l0-16 0-41.3L0 304c0-1.9 .2-3.8 .5-5.7c.6-7.4 1.8-14.8 3.5-22.1l43.9-188C55.5 55.3 84.8 32 118.6 32c9.2 0 18.4 1.8 27 5.2l31.3 12.5c12.3 4.9 18.3 18.9 13.4 31.2s-18.9 18.3-31.2 13.4L127.8 81.8c-2.9-1.2-6-1.8-9.2-1.8zM64 325.4L64 368c0 26.5 21.5 48 48 48l44.3 0c25.5 0 46.5-19.9 47.9-45.3l2.5-45.6c-2.3-.8-4.9-1.7-7.5-2.5c-17.2-5.4-39.9-10.5-63.6-10.5c-23.7 0-46.2 5.1-63.2 10.5c-3.1 1-5.9 1.9-8.5 2.9zM512 368l0-42.6c-2.6-.9-5.5-1.9-8.5-2.9c-17-5.4-39.5-10.5-63.2-10.5c-23.7 0-46.4 5.1-63.6 10.5c-2.7 .8-5.2 1.7-7.5 2.5l2.5 45.6c1.4 25.4 22.5 45.3 47.9 45.3l44.3 0c26.5 0 48-21.5 48-48z"]
}, faHoodCloak = {
  prefix: "fas",
  iconName: "hood-cloak",
  icon: [576, 512, [], "f6ef", "M432 0L288 0s0 0 0 0c-9.8 0-66 0-120.2 37.7C111.4 76.9 64 151.8 64 288c0 58.5-14.6 101.6-28.6 129.7c-7 14.1-14 24.5-19 31.1c-2.5 3.3-4.5 5.7-5.7 7.1c-.6 .7-1.1 1.2-1.3 1.4l-.2 .2c-9 9.1-11.7 22.8-6.8 34.7c5 12 16.6 19.8 29.6 19.8l96 0 0-192c0-88.4 71.6-160 160-160s160 71.6 160 160l0 192 96 0c12.9 0 24.6-7.8 29.6-19.8c4.9-11.9 2.2-25.6-6.8-34.7c0 0 0 0 0 0s0 0 0 0s0 0 0 0l-.1-.1c-.2-.2-.7-.7-1.3-1.4c-1.3-1.4-3.2-3.8-5.7-7.1c-5-6.6-11.9-17-19-31.1C526.6 389.6 512 346.5 512 288c0-103.1-46.5-172.8-95.8-217.2l32-29c7.3-6.7 9.8-17.2 6.2-26.4S441.9 0 432 0zM416 512l0-192c0-70.7-57.3-128-128-128s-128 57.3-128 128l0 192 256 0z"]
}, faSquareQuote = {
  prefix: "fas",
  iconName: "square-quote",
  icon: [448, 512, [], "e329", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 128l48 0c17.7 0 32 14.3 32 32l0 24 0 24 0 39.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7l0-7.3-32 0c-17.7 0-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32zm224 80l0 39.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7l0-7.3-32 0c-17.7 0-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 24 0 24z"]
}, faUpLeft = {
  prefix: "fas",
  iconName: "up-left",
  icon: [384, 512, [], "e2bd", "M48 80l240 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-72 72L372.7 340.7c7.2 7.2 11.3 17.1 11.3 27.3s-4.1 20.1-11.3 27.3l-41.4 41.4c-7.2 7.2-17.1 11.3-27.3 11.3s-20.1-4.1-27.3-11.3L142.6 302.6l-72 72c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6l0-240c0-17.7 14.3-32 32-32z"]
}, faBringFront = {
  prefix: "fas",
  iconName: "bring-front",
  icon: [640, 512, [], "f857", "M64 64l64 0 32 0 32 0 64 0c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64L0 192c0 35.3 28.7 64 64 64l64 0 0-64-64 0L64 64zM480 448l-32 0-64 0c0 35.3 28.7 64 64 64l128 0c35.3 0 64-28.7 64-64l0-128c0-35.3-28.7-64-64-64l-64 0 0 64 64 0 0 128-64 0-32 0zM224 96c-35.3 0-64 28.7-64 64l0 192c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64L224 96z"]
}, faChessBoard = {
  prefix: "fas",
  iconName: "chess-board",
  icon: [448, 512, [], "f43c", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 64l0 64 64 0 0-64 64 0 0 64 64 0 0-64 64 0 0 64-64 0 0 64 64 0 0 64-64 0 0 64 64 0 0 64-64 0 0-64-64 0 0 64-64 0 0-64-64 0 0 64-64 0 0-64 64 0 0-64-64 0 0-64 64 0 0-64-64 0 0-64 64 0zm64 128l64 0 0-64-64 0 0 64zm0 64l0-64-64 0 0 64 64 0zm64 0l-64 0 0 64 64 0 0-64zm0 0l64 0 0-64-64 0 0 64z"]
}, faBurgerCheese = {
  prefix: "fas",
  iconName: "burger-cheese",
  icon: [512, 512, [127828, "cheeseburger"], "f7f1", "M32 194.9C32 211 45 224 61.1 224l389.8 0c16.1 0 29.1-13 29.1-29.1c0-1.9-.2-3.7-.6-5.6C474.1 168.3 433.2 32 256 32S37.9 168.3 32.6 189.3c-.5 1.9-.6 3.7-.6 5.6zM128 112a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm240 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM256 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM32 400l0 16c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-16c0-8.8-7.2-16-16-16L48 384c-8.8 0-16 7.2-16 16zM234 262.7c-6.5-4.4-14.2-6.7-22.1-6.7l-3.9 0-.1 0L64 256c-26.5 0-48 21.5-48 48s21.5 48 48 48l384 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-15.9 0-.1 0-3.9 0c-7.9 0-15.6 2.3-22.1 6.7l-68.2 45.5c-10.7 7.2-24.8 7.2-35.5 0L234 262.7z"]
}, faCheeseburger = faBurgerCheese, faBuildingCircleCheck = {
  prefix: "fas",
  iconName: "building-circle-check",
  icon: [640, 512, [], "e4d2", "M48 0C21.5 0 0 21.5 0 48L0 464c0 26.5 21.5 48 48 48l96 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 96 0c15.1 0 28.5-6.9 37.3-17.8C340.4 462.2 320 417.5 320 368c0-54.7 24.9-103.5 64-135.8L384 48c0-26.5-21.5-48-48-48L48 0zM64 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm112-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM80 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-76.7-43.3c6.2 6.2 6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0z"]
}, faRepeat1 = {
  prefix: "fas",
  iconName: "repeat-1",
  icon: [512, 512, [128258], "f365", "M32 256c-17.7 0-32-14.3-32-32C0 135.6 71.6 64 160 64l160 0 0-32c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l64 64c12.5 12.5 12.5 32.8 0 45.3l-64 64c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6l0-32-160 0c-53 0-96 43-96 96c0 17.7-14.3 32-32 32zm448 0c17.7 0 32 14.3 32 32c0 88.4-71.6 160-160 160l-160 0 0 32c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-64-64c-12.5-12.5-12.5-32.8 0-45.3l64-64c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6l0 32 160 0c53 0 96-43 96-96c0-17.7 14.3-32 32-32zM288 216l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c-10 0-19.4-6.4-22.8-16.4c-4.2-12.6 2.6-26.2 15.2-30.4l24-8c7.3-2.4 15.4-1.2 21.6 3.3s10 11.8 10 19.5z"]
}, faArrowDownToLine = {
  prefix: "fas",
  iconName: "arrow-down-to-line",
  icon: [384, 512, ["arrow-to-bottom"], "f33d", "M32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480zM214.6 342.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L160 242.7 160 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 178.7 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-128 128z"]
}, faArrowToBottom = faArrowDownToLine, faGrid5 = {
  prefix: "fas",
  iconName: "grid-5",
  icon: [448, 512, [], "e199", "M0 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16L16 96C7.2 96 0 88.8 0 80L0 48zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM0 336c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM96 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM96 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM96 432c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM208 32l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM192 144c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM192 336c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM288 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM288 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM288 432c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM400 32l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM384 144c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM384 336c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16z"]
}, faSwapArrows = {
  prefix: "fas",
  iconName: "swap-arrows",
  icon: [640, 512, [], "e60a", "M105.4 9.4c12.5-12.5 32.8-12.5 45.3 0l96 96c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L160 109.3 160 352c0 35.3 28.7 64 64 64s64-28.7 64-64l0-192c0-70.7 57.3-128 128-128s128 57.3 128 128l0 242.7 41.4-41.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-96 96c-12.5 12.5-32.8 12.5-45.3 0l-96-96c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L480 402.7 480 160c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 192c0 70.7-57.3 128-128 128s-128-57.3-128-128l0-242.7L54.6 150.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l96-96z"]
}, faRightLongToLine = {
  prefix: "fas",
  iconName: "right-long-to-line",
  icon: [640, 512, [], "e444", "M640 96l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-320c0-17.7 14.3-32 32-32s32 14.3 32 32zM360.5 409.4c-7 6.6-17.2 8.4-26 4.6s-14.5-12.5-14.5-22l0-72L32 320c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l288 0 0-72c0-9.6 5.7-18.2 14.5-22s19-2 26 4.6l144 136c4.8 4.5 7.5 10.8 7.5 17.4s-2.7 12.9-7.5 17.4l-144 136z"]
}, faPersonChalkboard = {
  prefix: "fas",
  iconName: "person-chalkboard",
  icon: [640, 512, [], "e53d", "M192 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm-8 384l0-128 16 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-288 56 0 64 0 16 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-64 192 0 0 192-192 0 0-32-64 0 0 48c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L368 0c-26.5 0-48 21.5-48 48l0 80-76.9 0-65.9 0c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9L120 256.9 120 480c0 17.7 14.3 32 32 32s32-14.3 32-32z"]
}, faMarsStrokeRight = {
  prefix: "fas",
  iconName: "mars-stroke-right",
  icon: [640, 512, [9897, "mars-stroke-h"], "f22b", "M208 368a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm174.4-88C370.7 365.8 297.1 432 208 432c-97.2 0-176-78.8-176-176s78.8-176 176-176c89.1 0 162.7 66.2 174.4 152l33.6 0 0-56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 56 32 0 0-56c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80c-6.9 6.9-17.2 8.9-26.2 5.2s-14.8-12.5-14.8-22.2l0-56-32 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56-33.6 0z"]
}, faMarsStrokeH = faMarsStrokeRight, faHandBackFist = {
  prefix: "fas",
  iconName: "hand-back-fist",
  icon: [448, 512, ["hand-rock"], "f255", "M144 0C117.5 0 96 21.5 96 48l0 48 0 28.5L96 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-26.7-9 7.5C40.4 169 32 187 32 206L32 244c0 38 16.9 74 46.1 98.3L128 384l0 96c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-105.3c46.9-19 80-65 80-118.7l0-80 0-16 0-16c0-26.5-21.5-48-48-48c-12.4 0-23.6 4.7-32.1 12.3C350 83.5 329.3 64 304 64c-12.4 0-23.6 4.7-32.1 12.3C270 51.5 249.3 32 224 32c-12.4 0-23.6 4.7-32.1 12.3C190 19.5 169.3 0 144 0z"]
}, faHandRock = faHandBackFist, faGridRound5 = {
  prefix: "fas",
  iconName: "grid-round-5",
  icon: [448, 512, [], "e5de", "M64 64A32 32 0 1 1 0 64a32 32 0 1 1 64 0zm0 96A32 32 0 1 1 0 160a32 32 0 1 1 64 0zM32 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64A32 32 0 1 1 0 352a32 32 0 1 1 64 0zM32 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM160 64A32 32 0 1 1 96 64a32 32 0 1 1 64 0zM128 192a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM128 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224 96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM352 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM320 192a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM320 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"]
}, faTally = {
  prefix: "fas",
  iconName: "tally",
  icon: [640, 512, ["tally-5"], "f69c", "M128 32c17.7 0 32 14.3 32 32l0 211.6 64-21.3L224 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 168.9 64-21.3L352 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 126.3 64-21.3L480 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 83.6 53.9-18c16.8-5.6 34.9 3.5 40.5 20.2s-3.5 34.9-20.2 40.5L544 215.1 544 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-211.6-64 21.3L416 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-168.9-64 21.3L288 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-126.3-64 21.3L160 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-83.6-53.9 18c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5L96 296.9 96 64c0-17.7 14.3-32 32-32z"]
}, faTally5 = faTally, faSquareCaretUp = {
  prefix: "fas",
  iconName: "square-caret-up",
  icon: [448, 512, ["caret-square-up"], "f151", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM224 160c6.7 0 13 2.8 17.6 7.7l104 112c6.5 7 8.2 17.2 4.4 25.9s-12.5 14.4-22 14.4l-208 0c-9.5 0-18.2-5.7-22-14.4s-2.1-18.9 4.4-25.9l104-112c4.5-4.9 10.9-7.7 17.6-7.7z"]
}, faCaretSquareUp = faSquareCaretUp, faCloudShowersWater = {
  prefix: "fas",
  iconName: "cloud-showers-water",
  icon: [576, 512, [], "e4e4", "M224 0c38.6 0 71.9 22.8 87.2 55.7C325.7 41.1 345.8 32 368 32c38.7 0 71 27.5 78.4 64l1.6 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-320 0c-35.3 0-64-28.7-64-64s28.7-64 64-64c0-53 43-96 96-96zM140.6 292.3l-48 80c-6.8 11.4-21.6 15-32.9 8.2s-15.1-21.6-8.2-32.9l48-80c6.8-11.4 21.6-15.1 32.9-8.2s15.1 21.6 8.2 32.9zm327.8-32.9c11.4 6.8 15 21.6 8.2 32.9l-48 80c-6.8 11.4-21.6 15-32.9 8.2s-15-21.6-8.2-32.9l48-80c6.8-11.4 21.6-15.1 32.9-8.2zM252.6 292.3l-48 80c-6.8 11.4-21.6 15-32.9 8.2s-15.1-21.6-8.2-32.9l48-80c6.8-11.4 21.6-15.1 32.9-8.2s15.1 21.6 8.2 32.9zm103.8-32.9c11.4 6.8 15 21.6 8.2 32.9l-48 80c-6.8 11.4-21.6 15-32.9 8.2s-15.1-21.6-8.2-32.9l48-80c6.8-11.4 21.6-15.1 32.9-8.2zM306.5 421.9C329 437.4 356.5 448 384 448c26.9 0 55.4-10.8 77.4-26.1c0 0 0 0 0 0c11.9-8.5 28.1-7.8 39.2 1.7c14.4 11.9 32.5 21 50.6 25.2c17.2 4 27.9 21.2 23.9 38.4s-21.2 27.9-38.4 23.9c-24.5-5.7-44.9-16.5-58.2-25C449.5 501.7 417 512 384 512c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9c-33 0-65.5-10.3-94.5-25.8c-13.4 8.4-33.7 19.3-58.2 25c-17.2 4-34.4-6.7-38.4-23.9s6.7-34.4 23.9-38.4c18.1-4.2 36.2-13.3 50.6-25.2c11.1-9.4 27.3-10.1 39.2-1.7c0 0 0 0 0 0C136.7 437.2 165.1 448 192 448c27.5 0 55-10.6 77.5-26.1c11.1-7.9 25.9-7.9 37 0z"]
}, faChartBar = {
  prefix: "fas",
  iconName: "chart-bar",
  icon: [512, 512, ["bar-chart"], "f080", "M32 32c17.7 0 32 14.3 32 32l0 336c0 8.8 7.2 16 16 16l400 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 480c-44.2 0-80-35.8-80-80L0 64C0 46.3 14.3 32 32 32zm96 96c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32zm32 64l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 96l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faBarChart = faChartBar, faHandsBubbles = {
  prefix: "fas",
  iconName: "hands-bubbles",
  icon: [576, 512, ["hands-wash"], "e05e", "M416 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM160 464a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM32 160l.1 72.6c.1 52.2 24 101 64 133.1c-.1-1.9-.1-3.8-.1-5.7l0-8c0-71.8 37-138.6 97.9-176.7l60.2-37.6c8.6-5.4 17.9-8.4 27.3-9.4l45.9-79.5c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8l-78 135.1c-3.3 5.7-10.7 7.7-16.4 4.4s-7.7-10.7-4.4-16.4l62-107.4c6.6-11.5 2.7-26.2-8.8-32.8S214 5 207.4 16.5l-68 117.8s0 0 0 0s0 0 0 0l-43.3 75L96 160c0-17.7-14.4-32-32-32s-32 14.4-32 32zM332.1 88.5L307.5 131c13.9 4.5 26.4 13.7 34.7 27c.9 1.5 1.8 2.9 2.5 4.4l28.9-50c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8zm46.4 63.7l-26.8 46.4c-.6 6-2.1 11.8-4.3 17.4l4.7 0 13.3 0s0 0 0 0l31.8 0 23-39.8c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8zM315.1 175c-9.4-15-29.1-19.5-44.1-10.2l-60.2 37.6C159.3 234.7 128 291.2 128 352l0 8c0 8.9 .8 17.6 2.2 26.1c35.4 8.2 61.8 40 61.8 77.9c0 6.3-.7 12.5-2.1 18.4C215.1 501 246.3 512 280 512l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-92 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l124 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-124 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l156 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-156 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l124 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-136 0s0 0 0 0s0 0 0 0l-93.2 0L305 219.1c15-9.4 19.5-29.1 10.2-44.1z"]
}, faHandsWash = faHandsBubbles, faLessThanEqual = {
  prefix: "fas",
  iconName: "less-than-equal",
  icon: [448, 512, [], "f537", "M395.9 93.7c16.4-6.6 24.4-25.2 17.8-41.6s-25.2-24.4-41.6-17.8l-320 128C40 167.1 32 178.9 32 192s8 24.9 20.1 29.7l320 128c16.4 6.6 35-1.4 41.6-17.8s-1.4-35-17.8-41.6L150.2 192 395.9 93.7zM32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 416z"]
}, faTrain = {
  prefix: "fas",
  iconName: "train",
  icon: [448, 512, [128646], "f238", "M96 0C43 0 0 43 0 96L0 352c0 48 35.2 87.7 81.1 94.9l-46 46C28.1 499.9 33.1 512 43 512l39.7 0c8.5 0 16.6-3.4 22.6-9.4L160 448l128 0 54.6 54.6c6 6 14.1 9.4 22.6 9.4l39.7 0c10 0 15-12.1 7.9-19.1l-46-46c46-7.1 81.1-46.9 81.1-94.9l0-256c0-53-43-96-96-96L96 0zM64 96c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32L96 224c-17.7 0-32-14.3-32-32l0-96zM224 288a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]
}, faUpFromDottedLine = {
  prefix: "fas",
  iconName: "up-from-dotted-line",
  icon: [448, 512, [], "e456", "M73.9 166.1L196.7 43.3C203.9 36.1 213.8 32 224 32s20.1 4.1 27.3 11.3L374.1 166.1c6.4 6.4 9.9 15 9.9 24c0 18.7-15.2 33.9-33.9 33.9L288 224l0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-128-62.1 0C79.2 224 64 208.8 64 190.1c0-9 3.6-17.6 9.9-24zM32 416a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm96 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faEyeLowVision = {
  prefix: "fas",
  iconName: "eye-low-vision",
  icon: [640, 512, ["low-vision"], "f2a8", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L525.6 386.7c39.6-40.6 66.4-86.1 79.9-118.4c3.3-7.9 3.3-16.7 0-24.6c-14.9-35.7-46.2-87.7-93-131.1C465.5 68.8 400.8 32 320 32c-68.2 0-125 26.3-169.3 60.8L38.8 5.1zM223 149.5c48.6-44.3 123-50.8 179.3-11.7c60.8 42.4 78.9 123.2 44.2 186.9L408 294.5c8.4-19.3 10.6-41.4 4.8-63.3c-11.1-41.5-47.8-69.4-88.6-71.1c-5.8-.2-9.2 6.1-7.4 11.7c2.1 6.4 3.3 13.2 3.3 20.3c0 10.2-2.4 19.8-6.6 28.3L223 149.5zm223.1 298L83.1 161.5c-11 14.4-20.5 28.7-28.4 42.2l339 265.7c18.7-5.5 36.2-13 52.6-21.8zM34.5 268.3c14.9 35.7 46.2 87.7 93 131.1C174.5 443.2 239.2 480 320 480c3.1 0 6.1-.1 9.2-.2L33.1 247.8c-1.8 6.8-1.3 14 1.4 20.5z"]
}, faLowVision = faEyeLowVision, faTrafficLightGo = {
  prefix: "fas",
  iconName: "traffic-light-go",
  icon: [320, 512, [], "f638", "M64 0C28.7 0 0 28.7 0 64L0 352c0 88.4 71.6 160 160 160s160-71.6 160-160l0-288c0-35.3-28.7-64-64-64L64 0zm96 416a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm0-200a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm0 72a48 48 0 1 1 0-96 48 48 0 1 1 0 96zM136 112a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm72 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z"]
}, faFaceExhaling = {
  prefix: "fas",
  iconName: "face-exhaling",
  icon: [576, 512, [], "e480", "M256 512c55.8 0 107.4-17.9 149.5-48.2c-10.5-9.3-17.9-22.1-20.5-36.5l-42.2-12.7C329.3 410.6 320 398.1 320 384s9.3-26.6 22.8-30.6L385 340.7c5.3-30 31.5-52.7 63-52.7c.7 0 1.4 0 2.1 0c13.2-14.7 32.3-24 53.7-24c2.7 0 5.4 .2 8.1 .5c.1-2.8 .1-5.6 .1-8.5C512 114.6 397.4 0 256 0S0 114.6 0 256S114.6 512 256 512zM195.2 238.4c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0zm121.6 0c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2zM256 344a40 40 0 1 1 0 80 40 40 0 1 1 0-80zm287.4-5.5c.1-.8 .1-1.7 .1-2.5c0-22.1-17.9-40-39.9-40c-16.9 0-31.4 10.5-37.2 25.4c-3.3-.9-6.9-1.4-10.5-1.4c-22.1 0-39.9 17.9-39.9 40l-56.1 14.1c-4.6 1.1-7.8 5.2-7.8 9.9s3.2 8.8 7.8 9.9l56.9 14.2c-.5 2.5-.8 5.1-.8 7.8c0 22.1 17.9 40 39.9 40c4.9 0 9.6-.9 14-2.5c7.1 11.1 19.5 18.5 33.7 18.5c22.1 0 39.9-17.9 39.9-40c0-.8 0-1.7-.1-2.5c19-6.4 32.6-24.4 32.6-45.5s-13.6-39.1-32.6-45.5z"]
}, faSensorFire = {
  prefix: "fas",
  iconName: "sensor-fire",
  icon: [640, 512, [], "e02a", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l273.6 0c-31-34.7-49.6-80.6-49.6-129.9c0-35.2 16.3-73.6 37.2-107.4c21.7-35.2 51.9-71.2 87.3-102.8c10-8.9 23-12.8 35.5-11.7L448 96c0-35.3-28.7-64-64-64L64 32zm48 88l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24zm96 0l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24zm297.7 88.1l-19-19.9c-2-2.1-4-4.4-6-6.7c0 0 0 0 0 0c-9-10.2-18.6-21.3-32.7-21.6c-7.3-.2-14.6 2.3-20.3 7.5c-23.4 21.1-50 48.9-70.9 80.2C336 278.6 320 314.7 320 352c0 88.6 70.4 159.8 160 159.8c88.7 0 160-71.2 160-159.8c0-30-11-60.9-26.2-88.1c-15.2-27.4-35.3-52.3-55-70.6c-5.6-5.2-12.8-7.8-19.9-7.8c-7.6 0-15.5 2.8-20.9 8.9l-12.3 13.8zM544 400c0 35.3-28.7 64-64 64s-64-28.7-64-64c0-36.5 37-73 54.8-88.4c5.4-4.7 13.1-4.7 18.5 0C507 327 544 363.5 544 400z"]
}, faUserUnlock = {
  prefix: "fas",
  iconName: "user-unlock",
  icon: [640, 512, [], "e058", "M96 128a128 128 0 1 1 256 0A128 128 0 1 1 96 128zM0 482.3C0 383.8 79.8 304 178.3 304l91.4 0c43.6 0 83.6 15.7 114.6 41.7c-.2 2.1-.3 4.2-.3 6.3l0 128c0 11.7 3.1 22.6 8.6 32L29.7 512C13.3 512 0 498.7 0 482.3zM496 272l0 48 16 0 48 0 48 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l-48 0c0-17.7-14.3-32-32-32s-32 14.3-32 32z"]
}, faHexagonDivide = {
  prefix: "fas",
  iconName: "hexagon-divide",
  icon: [512, 512, [], "e1ad", "M17.1 292c-12.9-22.3-12.9-49.7 0-72L105.4 67.1c12.9-22.3 36.6-36 62.4-36l176.6 0c25.7 0 49.5 13.7 62.4 36L494.9 220c12.9 22.3 12.9 49.7 0 72L406.6 444.9c-12.9 22.3-36.6 36-62.4 36l-176.6 0c-25.7 0-49.5-13.7-62.4-36L17.1 292zM256 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-88 40c-13.3 0-24 10.7-24 24s10.7 24 24 24l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-176 0zM288 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, fa00 = {
  prefix: "fas",
  iconName: "00",
  icon: [640, 512, [], "e467", "M144 32C64.5 32 0 96.5 0 176L0 336c0 79.5 64.5 144 144 144s144-64.5 144-144l0-160c0-79.5-64.5-144-144-144zM64 176c0-44.2 35.8-80 80-80s80 35.8 80 80l0 160c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-160zM496 32c-79.5 0-144 64.5-144 144l0 160c0 79.5 64.5 144 144 144s144-64.5 144-144l0-160c0-79.5-64.5-144-144-144zM416 176c0-44.2 35.8-80 80-80s80 35.8 80 80l0 160c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-160z"]
}, faCrow = {
  prefix: "fas",
  iconName: "crow",
  icon: [640, 512, [], "f520", "M456 0c-48.6 0-88 39.4-88 88l0 29.2L12.5 390.6c-14 10.8-16.6 30.9-5.9 44.9s30.9 16.6 44.9 5.9L126.1 384l133.1 0 46.6 113.1c5 12.3 19.1 18.1 31.3 13.1s18.1-19.1 13.1-31.3L311.1 384l40.9 0c1.1 0 2.1 0 3.2 0l46.6 113.2c5 12.3 19.1 18.1 31.3 13.1s18.1-19.1 13.1-31.3l-42-102C484.9 354.1 544 280 544 192l0-64 0-8 80.5-20.1c8.6-2.1 13.8-10.8 11.6-19.4C629 52 603.4 32 574 32l-50.1 0C507.7 12.5 483.3 0 456 0zm0 64a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]
}, faCassetteBetamax = {
  prefix: "fas",
  iconName: "cassette-betamax",
  icon: [576, 512, ["betamax"], "f8a4", "M64 32C28.7 32 0 60.7 0 96l0 32 576 0 0-32c0-35.3-28.7-64-64-64L64 32zM576 160L0 160 0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-256zM192 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM64 320a96 96 0 1 1 192 0A96 96 0 1 1 64 320zm256-64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128z"]
}, faBetamax = faCassetteBetamax, faSailboat = {
  prefix: "fas",
  iconName: "sailboat",
  icon: [576, 512, [], "e445", "M256 16c0-7 4.5-13.2 11.2-15.3s13.9 .4 17.9 6.1l224 320c3.4 4.9 3.8 11.3 1.1 16.6s-8.2 8.6-14.2 8.6l-224 0c-8.8 0-16-7.2-16-16l0-320zM212.1 96.5c7 1.9 11.9 8.2 11.9 15.5l0 224c0 8.8-7.2 16-16 16L80 352c-5.7 0-11-3-13.8-8s-2.9-11-.1-16l128-224c3.6-6.3 11-9.4 18-7.5zM5.7 404.3C2.8 394.1 10.5 384 21.1 384l533.8 0c10.6 0 18.3 10.1 15.4 20.3l-4 14.3C550.7 473.9 500.4 512 443 512L133 512C75.6 512 25.3 473.9 9.7 418.7l-4-14.3z"]
}, faWindowRestore = {
  prefix: "fas",
  iconName: "window-restore",
  icon: [512, 512, [], "f2d2", "M432 64L208 64c-8.8 0-16 7.2-16 16l0 16-64 0 0-16c0-44.2 35.8-80 80-80L432 0c44.2 0 80 35.8 80 80l0 224c0 44.2-35.8 80-80 80l-16 0 0-64 16 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16zM0 192c0-35.3 28.7-64 64-64l256 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 192zm64 32c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 192c-17.7 0-32 14.3-32 32z"]
}, faNfcMagnifyingGlass = {
  prefix: "fas",
  iconName: "nfc-magnifying-glass",
  icon: [640, 512, [], "e1f9", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 64c-22.8 0-44.4 4.8-64 13.3l0-29.3c0-26.5-21.5-48-48-48l-80 0c-26.5 0-48 21.5-48 48l0 66.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3l0-66.7c0-8.8 7.2-16 16-16l80 0c8.8 0 16 7.2 16 16l0 48c-38.9 29.2-64 75.7-64 128c0 22.8 4.8 44.4 13.3 64L112 384c-8.8 0-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0c-26.5 0-48 21.5-48 48l0 224c0 26.5 21.5 48 48 48l208 0c21.6 28.8 52.7 50 88.6 59.1c-7.6 3.2-15.9 4.9-24.6 4.9L64 480c-35.3 0-64-28.7-64-64L0 96zM448 400.2a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0 48c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128c0 26.7-8.2 51.4-22.1 71.9L633 471.2c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L519.9 426c-20.5 14-45.3 22.1-71.9 22.1z"]
}, faFileBinary = {
  prefix: "fas",
  iconName: "file-binary",
  icon: [384, 512, [], "e175", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM112 256l32 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48zM96 304l0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm144-48l32 0c8.8 0 16 7.2 16 16l0 112 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 0-96-16 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faCircleV = {
  prefix: "fas",
  iconName: "circle-v",
  icon: [512, 512, [], "e12a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM173.5 157.3L256 322.3l82.5-165.1c5.9-11.9 20.3-16.7 32.2-10.7s16.7 20.3 10.7 32.2l-104 208c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3l-104-208c-5.9-11.9-1.1-26.3 10.7-32.2s26.3-1.1 32.2 10.7z"]
}, faSquarePlus = {
  prefix: "fas",
  iconName: "square-plus",
  icon: [448, 512, [61846, "plus-square"], "f0fe", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM200 344l0-64-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]
}, faPlusSquare = faSquarePlus, faBowlScoops = {
  prefix: "fas",
  iconName: "bowl-scoops",
  icon: [448, 512, [127813], "e3df", "M224 208c0 5.4 .4 10.8 1.1 16l221.7 0c.7-5.2 1.1-10.6 1.1-16c0-61.9-50.1-112-112-112l-1.1 0c-38.7 .4-72.7 20.4-92.6 50.6C230.7 164.2 224 185.3 224 208zM0 208c0 5.4 .4 10.8 1.1 16l191.7 0c-.6-5.3-.9-10.6-.9-16c0-22 4.9-42.8 13.7-61.4c-13.9-21.2-34.9-37.4-59.6-45.3C135.4 97.9 123.9 96 112 96C50.1 96 0 146.1 0 208zM325.4 64.4C307.5 26.3 268.8 0 224 0s-83.5 26.3-101.4 64.4c40.9 3 77.1 23 101.4 53.1c24.3-30.1 60.5-50.1 101.4-53.1zM16 256c-4.6 0-9 2-12 5.4s-4.5 8-3.9 12.6l2 15.9C11.1 361.9 72.4 416 145 416l40.4 0-68.7 68.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9l192 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4L262.6 416l40.4 0c72.6 0 133.9-54.1 142.9-126.1l2-15.9c.6-4.6-.8-9.1-3.9-12.6s-7.4-5.4-12-5.4L16 256z"]
}, faMistletoe = {
  prefix: "fas",
  iconName: "mistletoe",
  icon: [576, 512, [], "f7b4", "M312 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 94.1-98 98L91.3 230.4C38.3 240.6 0 287 0 341c0 41.4 33.6 75 75 75c50.5 0 94.3-33.5 108.1-81.2c7.2 10.4 19.3 17.2 32.9 17.2c22.1 0 40-17.9 40-40s-17.9-40-40-40c-7.9 0-15.3 2.3-21.5 6.3l5.4-28.2L264 185.9l0 72.4c14.7 13.2 24 32.3 24 53.7c0 39.8-32.2 72-72 72c-7.2 0-14.2-1.1-20.8-3c-2.1 8.4-3.2 17.1-3.2 25.9l0 9.1c0 53 43 96 96 96s96-43 96-96l0-9.1c0-25.1-9-49.4-25.3-68.4L312 284l0-98.1L376.1 250l14.4 74.7C400.6 377.7 447 416 501 416c41.4 0 75-33.6 75-75c0-54-38.3-100.3-91.3-110.5L410 216.1l-98-98L312 24zm64 88a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]
}, faCustard = {
  prefix: "fas",
  iconName: "custard",
  icon: [576, 512, [127854], "e403", "M396.7 64c30 0 56 20.8 62.5 50.1l13.5 60.8C450.9 167.4 423.5 160 400 160c-26.4 0-45.8 9.4-62.2 17.2l-.7 .3c-16.7 8-30.4 14.4-49.1 14.4s-32.3-6.4-49.1-14.4l-.7-.3C221.8 169.4 202.4 160 176 160c-23.5 0-50.9 7.4-72.6 14.9l13.5-60.8C123.4 84.8 149.3 64 179.3 64l217.3 0zM64.3 350.9L95.1 212.1c4.1-1.6 8.5-3.3 13.2-5c22-7.9 47.8-15.1 67.7-15.1c18.7 0 32.3 6.4 49.1 14.4l.7 .3c16.4 7.9 35.8 17.2 62.2 17.2s45.8-9.4 62.2-17.2l.7-.3c16.7-8 30.4-14.4 49.1-14.4c19.8 0 45.6 7.2 67.7 15.1c4.7 1.7 9.2 3.4 13.2 5L512 352 64.3 350.9zM32 384l512 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faLacrosseStick = {
  prefix: "fas",
  iconName: "lacrosse-stick",
  icon: [512, 512, [], "e3b5", "M336 64s0 0 0 0l.3 0c19.9 0 48.1 13.6 73.1 38.6s38.6 53.2 38.6 73.1c0 .1 0 .2 0 .3c0 0 0 0 0 0c0 33.1-21.9 62.1-53.7 71.2l-11.5 3.3c-19.6 5.6-37.9 15.1-53.9 27.8L294 306.2c-11.1 8.9-25 13.8-39.2 13.8c-34.7 0-62.8-28.1-62.8-62.8c0-14.3 4.9-28.1 13.8-39.2l27.9-34.9c12.8-15.9 22.2-34.3 27.8-53.9l3.3-11.5C273.9 85.9 302.9 64 336 64zm0-64s0 0 0 0C274.4 0 220.2 40.9 203.3 100.1L200 111.7c-3.3 11.5-8.8 22.2-16.2 31.5l-27.9 34.9c-18 22.5-27.8 50.4-27.8 79.2c0 23.4 6.3 45.3 17.4 64.1l-136 136c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l136-136c18.8 11.1 40.7 17.4 64.1 17.4c28.8 0 56.7-9.8 79.2-27.8l34.9-27.9c9.3-7.4 20-13 31.5-16.2l11.5-3.3C471.1 291.8 512 237.6 512 176c0 0 0 0 0 0l0-.3c0-43.8-26.4-87.4-57.3-118.4S380.1 0 336.3 0L336 0z"]
}, faHockeyMask = {
  prefix: "fas",
  iconName: "hockey-mask",
  icon: [448, 512, [], "f6ee", "M0 240C0 111 64 0 224 0S448 111 448 240c0 192-48 272-224 272S0 432 0 240zM160 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm88 24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM176 344a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm0 64a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72-104a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM312 80a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM272 408a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 40a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM128 272c35.3 0 64-28.7 64-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32c0 35.3 28.7 64 64 64zm256-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32c0 35.3 28.7 64 64 64s64-28.7 64-64z"]
}, faSunrise = {
  prefix: "fas",
  iconName: "sunrise",
  icon: [576, 512, [127749], "f766", "M354.5 135.7L320 104.3 320 208c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-103.7-34.5 31.3c-13.1 11.9-33.3 10.9-45.2-2.2s-10.9-33.3 2.2-45.2l88-80c12.2-11.1 30.8-11.1 43.1 0l88 80c13.1 11.9 14 32.1 2.2 45.2s-32.1 14-45.2 2.2zm39.1 89.5c5 2.1 8.6 6.6 9.6 11.9L423 345l107.9 19.8c5.3 1 9.8 4.6 11.9 9.6s1.5 10.7-1.6 15.2L512 432l-105.3 0c-19-46.9-65-80-118.7-80s-99.7 33.1-118.7 80L64 432 34.8 389.7c-3.1-4.5-3.7-10.2-1.6-15.2s6.6-8.6 11.9-9.6L153 345l19.8-107.9c1-5.3 4.6-9.8 9.6-11.9s10.7-1.5 15.2 1.6L288 289.1l90.3-62.3c4.5-3.1 10.2-3.7 15.2-1.6zM0 488c0-13.3 10.7-24 24-24l528 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24z"]
}, faSubtitles = {
  prefix: "fas",
  iconName: "subtitles",
  icon: [576, 512, [], "e60f", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm56 208l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm256 0l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM120 336l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm160 0l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faPanelEws = {
  prefix: "fas",
  iconName: "panel-ews",
  icon: [512, 512, [], "e42e", "M64 0C28.7 0 0 28.7 0 64L0 288l16 0c44.2 0 80 35.8 80 80l0 16c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l0 32c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-16c0-26.5-21.5-48-48-48L0 320 0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zm48 64l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm192 0l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM112 128l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm192 0l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm16 128l64 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]
}, faToriiGate = {
  prefix: "fas",
  iconName: "torii-gate",
  icon: [512, 512, [9961], "f6a1", "M0 80c0 26.5 21.5 48 48 48l16 0 0 64 64 0 0-64 96 0 0 64 64 0 0-64 96 0 0 64 64 0 0-64 16 0c26.5 0 48-21.5 48-48l0-66.6C512 6 506 0 498.6 0c-1.7 0-3.4 .3-5 1l-49 19.6C425.7 28.1 405.5 32 385.2 32L126.8 32c-20.4 0-40.5-3.9-59.4-11.4L18.4 1c-1.6-.6-3.3-1-5-1C6 0 0 6 0 13.4L0 80zM64 288l0 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-192 256 0 0 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-192 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0z"]
}, faCloudExclamation = {
  prefix: "fas",
  iconName: "cloud-exclamation",
  icon: [640, 512, [], "e491", "M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128l-368 0zM320 160c-13.3 0-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24zm32 224a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faMessageLines = {
  prefix: "fas",
  iconName: "message-lines",
  icon: [512, 512, ["comment-alt-lines"], "f4a6", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zm152 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-208 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0z"]
}, faCommentAltLines = faMessageLines, faFrog = {
  prefix: "fas",
  iconName: "frog",
  icon: [576, 512, [], "f52e", "M368 32c41.7 0 75.9 31.8 79.7 72.5l85.6 26.3c25.4 7.8 42.8 31.3 42.8 57.9c0 21.8-11.7 41.9-30.7 52.7L400.8 323.5 493.3 416l50.7 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-8.5 0-16.6-3.4-22.6-9.4L346.9 360.2c11.7-36 3.2-77.1-25.4-105.7c-40.6-40.6-106.3-40.6-146.9-.1L101 324.4c-6.4 6.1-6.7 16.2-.6 22.6s16.2 6.6 22.6 .6l73.8-70.2 .1-.1 .1-.1c3.5-3.5 7.3-6.6 11.3-9.2c27.9-18.5 65.9-15.4 90.5 9.2c24.7 24.7 27.7 62.9 9 90.9c-2.6 3.8-5.6 7.5-9 10.9L261.8 416l90.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 480c-35.3 0-64-28.7-64-64C0 249.6 127 112.9 289.3 97.5C296.2 60.2 328.8 32 368 32zm0 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faBucket = {
  prefix: "fas",
  iconName: "bucket",
  icon: [448, 512, [], "e4cf", "M96 152l0 8-48 0 0-8C48 68.1 116.1 0 200 0l48 0c83.9 0 152 68.1 152 152l0 8-48 0 0-8c0-57.4-46.6-104-104-104l-48 0C142.6 48 96 94.6 96 152zM0 224c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-5.1 0L388.5 469c-2.6 24.4-23.2 43-47.7 43l-233.6 0c-24.6 0-45.2-18.5-47.7-43L37.1 256 32 256c-17.7 0-32-14.3-32-32z"]
}, faFloppyDiskPen = {
  prefix: "fas",
  iconName: "floppy-disk-pen",
  icon: [576, 512, [], "e182", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l194.5 0 14-55.9c2.8-11.3 8.6-21.5 16.8-29.7L448 235.6l0-62.4c0-17-6.7-33.3-18.7-45.3L352 50.7C340 38.7 323.7 32 306.7 32L64 32zm0 96c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32L96 224c-17.7 0-32-14.3-32-32l0-64zM224 288a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm325.8-52.2c-15.6-15.6-40.9-15.6-56.6 0l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4zM311.9 417.1c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L512.1 358.8l-71-71L311.9 417.1z"]
}, faImage = {
  prefix: "fas",
  iconName: "image",
  icon: [512, 512, [], "f03e", "M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM323.8 202.5c-4.5-6.6-11.9-10.5-19.8-10.5s-15.4 3.9-19.8 10.5l-87 127.6L170.7 297c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6l96 0 32 0 208 0c8.9 0 17.1-4.9 21.2-12.8s3.6-17.4-1.4-24.7l-120-176zM112 192a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]
}, faWindowFrame = {
  prefix: "fas",
  iconName: "window-frame",
  icon: [512, 512, [129695], "e04f", "M32 256L32 64C32 28.7 60.7 0 96 0L416 0c35.3 0 64 28.7 64 64l0 192 0 192c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0L96 512l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l0-192zm384 32l-136 0 0 160 136 0 0-160zm-184 0L96 288l0 160 136 0 0-160zm48-64l136 0 0-160L280 64l0 160zM232 64L96 64l0 160 136 0 0-160z"]
}, faMicrophone = {
  prefix: "fas",
  iconName: "microphone",
  icon: [384, 512, [], "f130", "M192 0C139 0 96 43 96 96l0 160c0 53 43 96 96 96s96-43 96-96l0-160c0-53-43-96-96-96zM64 216c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 89.1 66.2 162.7 152 174.4l0 33.6-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-33.6c85.8-11.7 152-85.3 152-174.4l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 70.7-57.3 128-128 128s-128-57.3-128-128l0-40z"]
}, faCow = {
  prefix: "fas",
  iconName: "cow",
  icon: [640, 512, [128004], "f6c8", "M96 224l0 32 0 160c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-88.2c9.9 6.6 20.6 12 32 16.1l0 24.2c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16.9c5.3 .6 10.6 .9 16 .9s10.7-.3 16-.9l0 16.9c0 8.8 7.2 16 16 16s16-7.2 16-16l0-24.2c11.4-4 22.1-9.4 32-16.1l0 88.2c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-160 32 32 0 49.5c0 9.5 2.8 18.7 8.1 26.6L530 427c8.8 13.1 23.5 21 39.3 21c22.5 0 41.9-15.9 46.3-38l20.3-101.6c2.6-13-.3-26.5-8-37.3l-3.9-5.5 0-81.6c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 14.4-52.9-74.1C496 86.5 452.4 64 405.9 64L272 64l-16 0-64 0-48 0C77.7 64 24 117.7 24 184l0 54C9.4 249.8 0 267.8 0 288l0 17.6c0 8 6.4 14.4 14.4 14.4C46.2 320 72 294.2 72 262.4l0-6.4 0-32 0-40c0-24.3 12.1-45.8 30.5-58.9C98.3 135.9 96 147.7 96 160l0 64zM560 336a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM166.6 166.6c-4.2-4.2-6.6-10-6.6-16c0-12.5 10.1-22.6 22.6-22.6l178.7 0c12.5 0 22.6 10.1 22.6 22.6c0 6-2.4 11.8-6.6 16l-23.4 23.4C332.2 211.8 302.7 224 272 224s-60.2-12.2-81.9-33.9l-23.4-23.4z"]
}, faFileZip = {
  prefix: "fas",
  iconName: "file-zip",
  icon: [512, 512, [], "e5ee", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-144 0c-35.3 0-64 28.7-64 64l0 144L64 512c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zM240 352l64 0c5.5 0 10.7 2.9 13.6 7.6s3.2 10.6 .7 15.6L265.9 480l38.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-5.5 0-10.7-2.9-13.6-7.6s-3.2-10.6-.7-15.6L278.1 384 240 384c-8.8 0-16-7.2-16-16s7.2-16 16-16zm144 16l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16s16 7.2 16 16zm32 0c0-8.8 7.2-16 16-16l24 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-8 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48 0-80zm32 64l8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0 0 48z"]
}, faSquareRing = {
  prefix: "fas",
  iconName: "square-ring",
  icon: [448, 512, [], "e44f", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm64 224a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm96 160a160 160 0 1 1 0-320 160 160 0 1 1 0 320z"]
}, faDownFromLine = {
  prefix: "fas",
  iconName: "down-from-line",
  icon: [384, 512, ["arrow-alt-from-top"], "f349", "M41.9 345.9L164.7 468.7c7.2 7.2 17.1 11.3 27.3 11.3s20.1-4.1 27.3-11.3L342.1 345.9c6.4-6.4 9.9-15 9.9-24c0-18.7-15.2-33.9-33.9-33.9L256 288l0-128c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32l0 128-62.1 0C47.2 288 32 303.2 32 321.9c0 9 3.6 17.6 9.9 24zM32 96l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64S14.3 96 32 96z"]
}, faArrowAltFromTop = faDownFromLine, faCaretUp = {
  prefix: "fas",
  iconName: "caret-up",
  icon: [320, 512, [], "f0d8", "M182.6 137.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l256 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-128-128z"]
}, faShieldXmark = {
  prefix: "fas",
  iconName: "shield-xmark",
  icon: [512, 512, ["shield-times"], "e24c", "M269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8c-22 9.3-38.4 31-38.3 57.2c.5 99.2 41.3 280.7 213.6 363.2c16.7 8 36.1 8 52.8 0C454.7 420.7 495.5 239.2 496 140c.1-26.2-16.3-47.9-38.3-57.2L269.4 2.9zM175 175c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z"]
}, faShieldTimes = faShieldXmark, faScrewdriver = {
  prefix: "fas",
  iconName: "screwdriver",
  icon: [512, 512, [129691], "f54a", "M465 7c-8.5-8.5-22-9.4-31.6-2.1l-104 80c-5.9 4.5-9.4 11.6-9.4 19l0 54.1-85.6 85.6c6.7 4.2 13 9.3 18.8 15.1s10.9 12.2 15.1 18.8L353.9 192l54.1 0c7.5 0 14.5-3.5 19-9.4l80-104c7.4-9.6 6.5-23.1-2.1-31.6L465 7zM121.4 281.4l-112 112c-12.5 12.5-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0l112-112c30.2-30.2 30.2-79.1 0-109.3s-79.1-30.2-109.3 0z"]
}, faCircleSortDown = {
  prefix: "fas",
  iconName: "circle-sort-down",
  icon: [512, 512, ["sort-circle-down"], "e031", "M512 256A256 256 0 1 0 0 256a256 256 0 1 0 512 0zM267.3 411.3c-6.2 6.2-16.4 6.2-22.6 0l-96-96c-4.6-4.6-5.9-11.5-3.5-17.4s8.3-9.9 14.8-9.9l192 0c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4l-96 96zm0-310.6l96 96c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9l-192 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l96-96c6.2-6.2 16.4-6.2 22.6 0zM313.4 192L256 134.6 198.6 192l114.7 0z"]
}, faSortCircleDown = faCircleSortDown, faFolderClosed = {
  prefix: "fas",
  iconName: "folder-closed",
  icon: [512, 512, [], "e185", "M448 480L64 480c-35.3 0-64-28.7-64-64L0 192l512 0 0 224c0 35.3-28.7 64-64 64zm64-320L0 160 0 96C0 60.7 28.7 32 64 32l128 0c20.1 0 39.1 9.5 51.2 25.6l19.2 25.6c6 8.1 15.5 12.8 25.6 12.8l160 0c35.3 0 64 28.7 64 64z"]
}, faHouseTsunami = {
  prefix: "fas",
  iconName: "house-tsunami",
  icon: [576, 512, [], "e515", "M80.8 136.5C104.9 93.8 152.6 64 209 64c16.9 0 33.1 2.7 48.2 7.7c16.8 5.5 34.9-3.6 40.4-20.4s-3.6-34.9-20.4-40.4C255.8 3.8 232.8 0 209 0C95.2 0 0 88 0 200c0 91.6 53.5 172.1 142.2 194.1c13.4 3.8 27.5 5.9 42.2 5.9c.7 0 1.4 0 2.1-.1c1.8 0 3.7 .1 5.5 .1c0 0 0 0 0 0c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.5-27.3-10.1-39.2-1.7c0 0 0 0 0 0C439.4 325.2 410.9 336 384 336c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0c-22.4 15.5-49.9 26.1-77.4 26.1c0 0-.1 0-.1 0c-12.4 0-24-1.5-34.9-4.3C121.6 320.2 96 287 96 248c0-48.5 39.5-88 88.4-88c13.5 0 26.1 3 37.5 8.3c16 7.5 35.1 .6 42.5-15.5s.6-35.1-15.5-42.5C229.3 101.1 207.4 96 184.4 96c-40 0-76.4 15.4-103.6 40.5zm252-18.1c-8.1 6-12.8 15.5-12.8 25.6l0 121c1.6 1 3.3 2 4.8 3.1c18.4 12.7 39.6 20.3 59.2 20.3c19 0 41.2-7.9 59.2-20.3c23.8-16.7 55.8-15.3 78.1 3.4c10.6 8.8 24.2 15.6 37.3 18.6c5.8 1.4 11.2 3.4 16.2 6.2c.7-2.7 1.1-5.5 1.1-8.4l-.4-144c0-10-4.7-19.4-12.7-25.5l-95.5-72c-11.4-8.6-27.1-8.6-38.5 0l-96 72zM384 448c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 437.4 219.5 448 192 448c-26.9 0-55.3-10.8-77.4-26.1c0 0 0 0 0 0c-11.9-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4s21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 501.7 159 512 192 512c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.4-27.3-10.1-39.2-1.7c0 0 0 0 0 0C439.4 437.2 410.9 448 384 448z"]
}, faSquareNfi = {
  prefix: "fas",
  iconName: "square-nfi",
  icon: [448, 512, [], "e576", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm75.7 64.6C68.8 162.5 64 168.8 64 176l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-102.2 66.3 110.5c3.7 6.2 11.1 9.1 18 7.2s11.7-8.2 11.7-15.4l0-160c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 102.2L93.7 167.8c-3.7-6.2-11.1-9.1-18-7.2zM224 176l0 64 0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-32 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm160 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160z"]
}, faForklift = {
  prefix: "fas",
  iconName: "forklift",
  icon: [640, 512, [], "f47a", "M48 160l48 0L96 48c0-26.5 21.5-48 48-48L292.7 0c20.3 0 38.4 12.8 45.2 31.9l75.3 210.8c1.8 5.2 2.8 10.6 2.8 16.1l0 85.7c19.6 17.6 32 43.1 32 71.6c0 53-43 96-96 96s-96-43-96-96l-64 0c0 53-43 96-96 96s-96-43-96-96L0 208c0-26.5 21.5-48 48-48zm208 96l94 0L281.4 64 160 64l0 96 96 96zM96 464a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm256 0a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM544 32l0 352 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-384c0-17.7 14.3-32 32-32s32 14.3 32 32z"]
}, faArrowUpFromGroundWater = {
  prefix: "fas",
  iconName: "arrow-up-from-ground-water",
  icon: [576, 512, [], "e4b5", "M288 352c17.7 0 32-14.3 32-32l0-210.7 25.4 25.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-80-80c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L256 109.3 256 320c0 17.7 14.3 32 32 32zm-18.5 69.9C247 437.4 219.5 448 192 448c-26.9 0-55.3-10.8-77.4-26.1c0 0 0 0 0 0c-11.9-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4s21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 501.7 159 512 192 512c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9s-6.7-34.4-23.9-38.4c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.4-27.3-10.1-39.2-1.7c0 0 0 0 0 0C439.4 437.2 410.9 448 384 448c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0zM192 192L48 192c-26.5 0-48 21.5-48 48L0 425c5.3-3.1 11.2-5.4 17.5-6.9c13.1-3.1 26.7-9.8 37.3-18.6c22.2-18.7 54.3-20.1 78.1-3.4c18 12.4 40.1 20.3 59.1 20.3L192 192zm384 48c0-26.5-21.5-48-48-48l-144 0 0 224.5s0 0 0 0c19 0 41.2-7.9 59.2-20.3c23.8-16.7 55.8-15.4 78.1 3.4c10.6 8.8 24.2 15.6 37.3 18.6c6.3 1.5 12.1 3.8 17.5 6.9l0-185z"]
}, faBracketSquareRight = {
  prefix: "fas",
  iconName: "bracket-square-right",
  icon: [192, 512, [], "5d", "M192 96c0-35.3-28.7-64-64-64L64 32C46.3 32 32 46.3 32 64s14.3 32 32 32l64 0 0 320-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c35.3 0 64-28.7 64-64l0-320z"]
}, faMartiniGlass = {
  prefix: "fas",
  iconName: "martini-glass",
  icon: [512, 512, [127864, "glass-martini-alt"], "f57b", "M32 0C19.1 0 7.4 7.8 2.4 19.8s-2.2 25.7 6.9 34.9L224 269.3 224 448l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-178.7L502.6 54.6c9.2-9.2 11.9-22.9 6.9-34.9S492.9 0 480 0L32 0zM173.3 128l-64-64 293.5 0-64 64-165.5 0z"]
}, faGlassMartiniAlt = faMartiniGlass, faSquareBinary = {
  prefix: "fas",
  iconName: "square-binary",
  icon: [448, 512, [], "e69b", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm144 4c-24.3 0-44 19.7-44 44l0 48c0 24.3 19.7 44 44 44l32 0c24.3 0 44-19.7 44-44l0-48c0-24.3-19.7-44-44-44l-32 0zm-4 44c0-2.2 1.8-4 4-4l32 0c2.2 0 4 1.8 4 4l0 48c0 2.2-1.8 4-4 4l-32 0c-2.2 0-4-1.8-4-4l0-48zm140-44c-11 0-20 9-20 20c0 9.7 6.9 17.7 16 19.6l0 76.4c0 11 9 20 20 20s20-9 20-20l0-96c0-11-9-20-20-20l-16 0zM132 296c0 9.7 6.9 17.7 16 19.6l0 76.4c0 11 9 20 20 20s20-9 20-20l0-96c0-11-9-20-20-20l-16 0c-11 0-20 9-20 20zm96 24l0 48c0 24.3 19.7 44 44 44l32 0c24.3 0 44-19.7 44-44l0-48c0-24.3-19.7-44-44-44l-32 0c-24.3 0-44 19.7-44 44zm44-4l32 0c2.2 0 4 1.8 4 4l0 48c0 2.2-1.8 4-4 4l-32 0c-2.2 0-4-1.8-4-4l0-48c0-2.2 1.8-4 4-4z"]
}, faRotateLeft = {
  prefix: "fas",
  iconName: "rotate-left",
  icon: [512, 512, ["rotate-back", "rotate-backward", "undo-alt"], "f2ea", "M48.5 224L40 224c-13.3 0-24-10.7-24-24L16 72c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2L98.6 96.6c87.6-86.5 228.7-86.2 315.8 1c87.5 87.5 87.5 229.3 0 316.8s-229.3 87.5-316.8 0c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0c62.5 62.5 163.8 62.5 226.3 0s62.5-163.8 0-226.3c-62.2-62.2-162.7-62.5-225.3-1L185 183c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8L48.5 224z"]
}, faRotateBack = faRotateLeft, faRotateBackward = faRotateLeft, faUndoAlt = faRotateLeft, faTableColumns = {
  prefix: "fas",
  iconName: "table-columns",
  icon: [512, 512, ["columns"], "f0db", "M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 64l0 256 160 0 0-256L64 160zm384 0l-160 0 0 256 160 0 0-256z"]
}, faColumns = faTableColumns, faSquareA = {
  prefix: "fas",
  iconName: "square-a",
  icon: [448, 512, [], "e25f", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm160 96c9.1 0 17.4 5.1 21.5 13.3l104 208c5.9 11.9 1.1 26.3-10.7 32.2s-26.3 1.1-32.2-10.7L289.2 336l-130.3 0-17.4 34.7c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2l104-208c4.1-8.1 12.4-13.3 21.5-13.3zm0 77.7L182.8 288l82.3 0L224 205.7z"]
}, faTick = {
  prefix: "fas",
  iconName: "tick",
  icon: [192, 512, [], "e32f", "M32 98.3V96c0-35.3 28.7-64 64-64s64 28.7 64 64v2.3c0 3.8-.3 7.6-1 11.4L133.5 256.5c-3.2 18.2-19 31.5-37.5 31.5s-34.3-13.3-37.5-31.5L33 109.6c-.7-3.8-1-7.5-1-11.4z"]
}, faLemon = {
  prefix: "fas",
  iconName: "lemon",
  icon: [448, 512, [127819], "f094", "M448 96c0-35.3-28.7-64-64-64c-6.6 0-13 1-19 2.9c-22.5 7-48.1 14.9-71 9c-75.2-19.1-156.4 11-213.7 68.3S-7.2 250.8 11.9 326c5.8 22.9-2 48.4-9 71C1 403 0 409.4 0 416c0 35.3 28.7 64 64 64c6.6 0 13-1 19.1-2.9c22.5-7 48.1-14.9 71-9c75.2 19.1 156.4-11 213.7-68.3s87.5-138.5 68.3-213.7c-5.8-22.9 2-48.4 9-71c1.9-6 2.9-12.4 2.9-19.1zM212.5 127.4c-54.6 16-101.1 62.5-117.1 117.1C92.9 253 84 257.8 75.5 255.4S62.2 244 64.6 235.5c19.1-65.1 73.7-119.8 138.9-138.9c8.5-2.5 17.4 2.4 19.9 10.9s-2.4 17.4-10.9 19.9z"]
}, faHeadSideMask = {
  prefix: "fas",
  iconName: "head-side-mask",
  icon: [576, 512, [], "e063", "M32 224.2c0-22.2 3.2-43.6 9.2-63.9L262.2 321c-4 9.5-6.2 20-6.2 31l0 160-128 0c-17.7 0-32-14.3-32-32l0-72.7c0-16.7-6.9-32.5-17.1-45.8C48.6 322.4 32 274.1 32 224.2zm248.3 70.4L53 129.3C88.7 53 166.2 0 256 0l24 0c95.2 0 181.2 69.3 197.3 160.2c2.3 13 6.8 25.7 15.1 36l42 52.6c5.4 6.7 8.6 14.8 9.4 23.2L336 272c-21.7 0-41.3 8.6-55.7 22.6zM336 304l198 0s0 0 0 0l10 0-19.7 64L368 368c-8.8 0-16 7.2-16 16s7.2 16 16 16l146.5 0-9.8 32L368 432c-8.8 0-16 7.2-16 16s7.2 16 16 16l126.8 0-.9 2.8c-8.3 26.9-33.1 45.2-61.2 45.2L288 512l0-160c0-14 6-26.7 15.6-35.4c0 0 0 0 0 0c8.5-7.8 19.9-12.6 32.4-12.6zm48-80a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faHandshake = {
  prefix: "fas",
  iconName: "handshake",
  icon: [640, 512, [], "f2b5", "M323.4 85.2l-96.8 78.4c-16.1 13-19.2 36.4-7 53.1c12.9 17.8 38 21.3 55.3 7.8l99.3-77.2c7-5.4 17-4.2 22.5 2.8s4.2 17-2.8 22.5l-20.9 16.2L512 316.8 512 128l-.7 0-3.9-2.5L434.8 79c-15.3-9.8-33.2-15-51.4-15c-21.8 0-43 7.5-60 21.2zm22.8 124.4l-51.7 40.2C263 274.4 217.3 268 193.7 235.6c-22.2-30.5-16.6-73.1 12.7-96.8l83.2-67.3c-11.6-4.9-24.1-7.4-36.8-7.4C234 64 215.7 69.6 200 80l-72 48 0 224 28.2 0 91.4 83.4c19.6 17.9 49.9 16.5 67.8-3.1c5.5-6.1 9.2-13.2 11.1-20.6l17 15.6c19.5 17.9 49.9 16.6 67.8-2.9c4.5-4.9 7.8-10.6 9.9-16.5c19.4 13 45.8 10.3 62.1-7.5c17.9-19.5 16.6-49.9-2.9-67.8l-134.2-123zM16 128c-8.8 0-16 7.2-16 16L0 352c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-224-80 0zM48 320a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM544 128l0 224c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-208c0-8.8-7.2-16-16-16l-80 0zm32 208a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]
}, faGem = {
  prefix: "fas",
  iconName: "gem",
  icon: [512, 512, [128142], "f3a5", "M116.7 33.8c4.5-6.1 11.7-9.8 19.3-9.8l240 0c7.6 0 14.8 3.6 19.3 9.8l112 152c6.8 9.2 6.1 21.9-1.5 30.4l-232 256c-4.5 5-11 7.9-17.8 7.9s-13.2-2.9-17.8-7.9l-232-256c-7.7-8.5-8.3-21.2-1.5-30.4l112-152zm38.5 39.8c-3.3 2.5-4.2 7-2.1 10.5l57.4 95.6L63.3 192c-4.1 .3-7.3 3.8-7.3 8s3.2 7.6 7.3 8l192 16c.4 0 .9 0 1.3 0l192-16c4.1-.3 7.3-3.8 7.3-8s-3.2-7.6-7.3-8L301.5 179.8l57.4-95.6c2.1-3.5 1.2-8.1-2.1-10.5s-7.9-2-10.7 1L256 172.2 165.9 74.6c-2.8-3-7.4-3.4-10.7-1z"]
}, faDolly = {
  prefix: "fas",
  iconName: "dolly",
  icon: [576, 512, ["dolly-box"], "f472", "M0 32C0 14.3 14.3 0 32 0l72.9 0c27.5 0 52 17.6 60.7 43.8L257.7 320c30.1 .5 56.8 14.9 74 37l202.1-67.4c16.8-5.6 34.9 3.5 40.5 20.2s-3.5 34.9-20.2 40.5L352 417.7c-.9 52.2-43.5 94.3-96 94.3c-53 0-96-43-96-96c0-30.8 14.5-58.2 37-75.8L104.9 64 32 64C14.3 64 0 49.7 0 32zM244.8 134.5c-5.5-16.8 3.7-34.9 20.5-40.3L311 79.4l19.8 60.9 60.9-19.8L371.8 59.6l45.7-14.8c16.8-5.5 34.9 3.7 40.3 20.5l49.4 152.2c5.5 16.8-3.7 34.9-20.5 40.3L334.5 307.2c-16.8 5.5-34.9-3.7-40.3-20.5L244.8 134.5z"]
}, faDollyBox = faDolly, faSmoking = {
  prefix: "fas",
  iconName: "smoking",
  icon: [640, 512, [128684], "f48d", "M448 32l0 11c0 38.2 15.2 74.8 42.2 101.8l21 21c21 21 32.8 49.5 32.8 79.2l0 11c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-11c0-12.7-5.1-24.9-14.1-33.9l-21-21C405.9 151.1 384 98.1 384 43l0-11c0-17.7 14.3-32 32-32s32 14.3 32 32zM576 256l0-11c0-38.2-15.2-74.8-42.2-101.8l-21-21c-21-21-32.8-49.5-32.8-79.2l0-11c0-17.7 14.3-32 32-32s32 14.3 32 32l0 11c0 12.7 5.1 24.9 14.1 33.9l21 21c39 39 60.9 91.9 60.9 147.1l0 11c0 17.7-14.3 32-32 32s-32-14.3-32-32zM0 416c0-35.3 28.7-64 64-64l352 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32L64 512c-35.3 0-64-28.7-64-64l0-32zm224 0l0 32 160 0 0-32-160 0zm288-64c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32zm96 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32z"]
}, faMinimize = {
  prefix: "fas",
  iconName: "minimize",
  icon: [512, 512, ["compress-arrows-alt"], "f78c", "M456 224l-144 0c-13.3 0-24-10.7-24-24l0-144c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l40 40L442.3 5.7C446 2 450.9 0 456 0s10 2 13.7 5.7l36.7 36.7C510 46 512 50.9 512 56s-2 10-5.7 13.7L433 143l40 40c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8zm0 64c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-40 40 73.4 73.4c3.6 3.6 5.7 8.5 5.7 13.7s-2 10-5.7 13.7l-36.7 36.7C466 510 461.1 512 456 512s-10-2-13.7-5.7L369 433l-40 40c-6.9 6.9-17.2 8.9-26.2 5.2s-14.8-12.5-14.8-22.2l0-144c0-13.3 10.7-24 24-24l144 0zm-256 0c13.3 0 24 10.7 24 24l0 144c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-40-40L69.7 506.3C66 510 61.1 512 56 512s-10-2-13.7-5.7L5.7 469.7C2 466 0 461.1 0 456s2-10 5.7-13.7L79 369 39 329c-6.9-6.9-8.9-17.2-5.2-26.2s12.5-14.8 22.2-14.8l144 0zM56 224c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l40-40L5.7 69.7C2 66 0 61.1 0 56s2-10 5.7-13.7L42.3 5.7C46 2 50.9 0 56 0s10 2 13.7 5.7L143 79l40-40c6.9-6.9 17.2-8.9 26.2-5.2s14.8 12.5 14.8 22.2l0 144c0 13.3-10.7 24-24 24L56 224z"]
}, faCompressArrowsAlt = faMinimize, faRefrigerator = {
  prefix: "fas",
  iconName: "refrigerator",
  icon: [384, 512, [], "e026", "M96 0C43 0 0 43 0 96l0 64 288 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 64 0 0-64c0-53-43-96-96-96L96 0zM384 192l-64 0 0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176L0 192 0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256z"]
}, faMonument = {
  prefix: "fas",
  iconName: "monument",
  icon: [384, 512, [], "f5a6", "M180.7 4.7c6.2-6.2 16.4-6.2 22.6 0l80 80c2.5 2.5 4.1 5.8 4.6 9.3l40.2 322L55.9 416 96.1 94c.4-3.5 2-6.8 4.6-9.3l80-80zM152 272c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0zM32 448l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faOctagonXmark = {
  prefix: "fas",
  iconName: "octagon-xmark",
  icon: [512, 512, ["times-octagon", "xmark-octagon"], "f2f0", "M140.6 21.2C154.1 7.7 172.4 .1 191.5 .1l129 0c19.1 0 37.4 7.6 50.9 21.1L490.8 140.6c13.5 13.5 21.1 31.8 21.1 50.9l0 129c0 19.1-7.6 37.4-21.1 50.9L371.4 490.8c-13.5 13.5-31.8 21.1-50.9 21.1l-129 0c-19.1 0-37.4-7.6-50.9-21.1L21.2 371.4C7.7 357.9 .1 339.6 .1 320.5l0-129c0-19.1 7.6-37.4 21.1-50.9L140.6 21.2zM175 175c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47c-9.4-9.4-24.6-9.4-33.9 0z"]
}, faTimesOctagon = faOctagonXmark, faXmarkOctagon = faOctagonXmark, faAlignSlash = {
  prefix: "fas",
  iconName: "align-slash",
  icon: [640, 512, [], "f846", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L481.4 352l30.6 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-112.3 0-81.7-64L512 224c17.7 0 32-14.3 32-32s-14.3-32-32-32l-275.6 0L154.8 96 512 96c17.7 0 32-14.3 32-32s-14.3-32-32-32L128 32c-13.4 0-24.8 8.2-29.6 19.8L38.8 5.1zM324.9 352l-81.2-64L128 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l196.9 0zM162.5 224l-61.8-48.7c-3 4.9-4.7 10.6-4.7 16.7c0 17.7 14.3 32 32 32l34.5 0zM487.4 480l-81.2-64L128 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l359.4 0z"]
}, faSnowplow = {
  prefix: "fas",
  iconName: "snowplow",
  icon: [640, 512, [], "f7d2", "M298.9 64l68.6 160L256 224l-64-64 0-96 106.9 0zM445.1 242.7l-87.4-204C347.6 15.3 324.5 0 298.9 0L176 0c-26.5 0-48 21.5-48 48l0 112-32 0c-17.7 0-32 14.3-32 32l0 106.8C26.2 316.8 0 355.3 0 400c0 61.9 50.1 112 112 112l256 0c61.9 0 112-50.1 112-112c0-17.2-3.9-33.5-10.8-48l42.8 0 0 50.7c0 17 6.7 33.3 18.7 45.3l54.6 54.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L576 402.7l0-82.7 0-84.8L633 164c11-13.8 8.8-33.9-5-45s-33.9-8.8-45 5l-57 71.2c-9.1 11.3-14 25.4-14 40l0 52.8-64 0 0-31.3c.1-2.4-.2-4.8-.6-7.1s-1.2-4.7-2.2-6.8zM368 352c26.5 0 48 21.5 48 48s-21.5 48-48 48l-256 0c-26.5 0-48-21.5-48-48s21.5-48 48-48l256 0zM144 400a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm216 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-56-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM200 424a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faAnglesRight = {
  prefix: "fas",
  iconName: "angles-right",
  icon: [512, 512, [187, "angle-double-right"], "f101", "M470.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 265.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l160-160zm-352 160l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L210.7 256 73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z"]
}, faAngleDoubleRight = faAnglesRight, faTruckRampCouch = {
  prefix: "fas",
  iconName: "truck-ramp-couch",
  icon: [640, 512, ["truck-couch"], "f4dd", "M640 0l0 400c0 61.9-50.1 112-112 112c-61 0-110.5-48.7-112-109.3L48.4 502.9c-17.1 4.6-34.6-5.4-39.3-22.5s5.4-34.6 22.5-39.3L352 353.8 352 64c0-35.3 28.7-64 64-64L640 0zM576 400a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM294.5 209.2c8.7-2.3 17.4-2.1 25.5 .2l0 125.5-38.7 10.4L126.7 386.6 64.9 403.2c-17.1 4.6-34.6-5.6-39.2-22.6L13.3 334.2c-6.9-25.6 8.3-51.9 33.9-58.8s51.9 8.3 58.8 33.9l4.1 15.5 154.5-41.4-4.1-15.5c-6.9-25.6 8.3-51.9 33.9-58.8zM8 252.8c-9.1-34.1 11.1-69.2 45.3-78.4l185.5-49.7c34.1-9.1 69.2 11.1 78.4 45.3l1.7 6.4c-10.6-1.6-21.6-1.1-32.6 1.9c-37.4 10-61.5 44.9-59.2 82.1L131.2 286c-16.6-33.4-54.9-51.5-92.3-41.5c-11 2.9-20.8 8-29.2 14.7L8 252.8z"]
}, faTruckCouch = faTruckRampCouch, faCannabis = {
  prefix: "fas",
  iconName: "cannabis",
  icon: [512, 512, [], "f55f", "M256 0c5.3 0 10.3 2.7 13.3 7.1c15.8 23.5 36.7 63.7 49.2 109c7.2 26.4 11.8 55.2 10.4 84c11.5-8.8 23.7-16.7 35.8-23.6c41-23.3 84.4-36.9 112.2-42.5c5.2-1 10.7 .6 14.4 4.4s5.4 9.2 4.4 14.5c-5.6 27.7-19.3 70.9-42.7 111.7c-9.1 15.9-19.9 31.7-32.4 46.3c27.8 6.6 52.4 17.3 67.2 25.5c5.1 2.8 8.2 8.2 8.2 14s-3.2 11.2-8.2 14c-15.2 8.4-40.9 19.5-69.8 26.1c-20.2 4.6-42.9 7.2-65.2 4.6l8.3 33.1c1.5 6.1-.6 12.4-5.5 16.4s-11.6 4.6-17.2 1.9L280 417.2l0 70.8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-70.8-58.5 29.1c-5.6 2.8-12.3 2.1-17.2-1.9s-7-10.3-5.5-16.4l8.3-33.1c-22.2 2.6-45 0-65.2-4.6c-28.9-6.6-54.6-17.6-69.8-26.1c-5.1-2.8-8.2-8.2-8.2-14s3.2-11.2 8.2-14c14.8-8.2 39.4-18.8 67.2-25.5C78.9 296.3 68.1 280.5 59 264.6c-23.4-40.8-37.1-84-42.7-111.7c-1.1-5.2 .6-10.7 4.4-14.5s9.2-5.4 14.4-4.4c27.9 5.5 71.2 19.2 112.2 42.5c12.1 6.9 24.3 14.7 35.8 23.6c-1.4-28.7 3.1-57.6 10.4-84c12.5-45.3 33.4-85.5 49.2-109c3-4.4 8-7.1 13.3-7.1z"]
}, faCirclePlay = {
  prefix: "fas",
  iconName: "circle-play",
  icon: [512, 512, [61469, "play-circle"], "f144", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM188.3 147.1c-7.6 4.2-12.3 12.3-12.3 20.9l0 176c0 8.7 4.7 16.7 12.3 20.9s16.8 4.1 24.3-.5l144-88c7.1-4.4 11.5-12.1 11.5-20.5s-4.4-16.1-11.5-20.5l-144-88c-7.4-4.5-16.7-4.7-24.3-.5z"]
}, faPlayCircle = faCirclePlay, faArrowUpRightAndArrowDownLeftFromCenter = {
  prefix: "fas",
  iconName: "arrow-up-right-and-arrow-down-left-from-center",
  icon: [512, 512, [], "e0a0", "M352 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l50.7 0L297.4 169.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L448 109.3l0 50.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L352 0zM214.6 297.4c-12.5-12.5-32.8-12.5-45.3 0L64 402.7 64 352c0-17.7-14.3-32-32-32s-32 14.3-32 32L0 480c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0L214.6 342.6c12.5-12.5 12.5-32.8 0-45.3z"]
}, faLocationArrowUp = {
  prefix: "fas",
  iconName: "location-arrow-up",
  icon: [448, 512, [], "e63a", "M35.8 431.9L190.9 54.2C196.4 40.8 209.5 32 224 32s27.6 8.8 33.1 22.2L412.2 431.9c9.4 23-7.4 48.1-32.3 48.1c-7.8 0-15.3-2.6-21.4-7.3L224 368 89.4 472.7C83.3 477.4 75.8 480 68 480c-24.8 0-41.7-25.2-32.3-48.1z"]
}, faTablets = {
  prefix: "fas",
  iconName: "tablets",
  icon: [640, 512, [], "f490", "M614.3 247c-5.2 7.9-16.2 8.5-22.9 1.8L391.2 48.6c-6.7-6.7-6.2-17.8 1.8-22.9C418.1 9.4 447.9 0 480 0c88.4 0 160 71.6 160 160c0 32.1-9.4 61.9-25.7 87zM567 294.3c-25 16.3-54.9 25.7-87 25.7c-88.4 0-160-71.6-160-160c0-32.1 9.4-61.9 25.7-87c5.2-7.9 16.2-8.5 22.9-1.8L568.8 271.4c6.7 6.7 6.2 17.8-1.8 22.9zM301.5 368c9.5 0 16.9 8.2 15 17.5C301.1 457.8 236.9 512 160 512S18.9 457.8 3.5 385.5c-2-9.3 5.5-17.5 15-17.5l283.1 0zm0-32L18.5 336c-9.5 0-16.9-8.2-15-17.5C18.9 246.2 83.1 192 160 192s141.1 54.2 156.5 126.5c2 9.3-5.5 17.5-15 17.5z"]
}, fa360Degrees = {
  prefix: "fas",
  iconName: "360-degrees",
  icon: [640, 512, [], "e2dc", "M640 32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l64 0L38.4 204.8c-7.3 9.7-8.4 22.7-3 33.5S51.9 256 64 256l16 0c26.5 0 48 21.5 48 48l0 48c0 17.7-14.3 32-32 32l-5.5 0c-8.5 0-16.6-3.4-22.6-9.4L54.6 361.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l13.3 13.3c18 18 42.4 28.1 67.9 28.1l5.5 0c53 0 96-43 96-96l0-48c0-47-29-87.3-70.1-103.9l63.7-84.9c7.3-9.7 8.4-22.7 3-33.5S172.1 64 160 64L32 64zm448 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224zm96 224l0-224c0-44.2-35.8-80-80-80s-80 35.8-80 80l0 224c0 44.2 35.8 80 80 80s80-35.8 80-80zM288 160c0-17.7 14.3-32 32-32s32-14.3 32-32s-14.3-32-32-32c-53 0-96 43-96 96l0 128 0 .2 0 79.8c0 44.2 35.8 80 80 80s80-35.8 80-80l0-96c0-44.2-35.8-80-80-80c-5.5 0-10.8 .6-16 1.6l0-33.6zm0 112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96z"]
}, faEthernet = {
  prefix: "fas",
  iconName: "ethernet",
  icon: [512, 512, [], "f796", "M0 224L0 416c0 17.7 14.3 32 32 32l64 0 0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 64 0 0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 64 0 0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 64 0 0-112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 64 0c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32l-32 0 0-32c0-17.7-14.3-32-32-32l-32 0 0-32c0-17.7-14.3-32-32-32L160 64c-17.7 0-32 14.3-32 32l0 32-32 0c-17.7 0-32 14.3-32 32l0 32-32 0c-17.7 0-32 14.3-32 32z"]
}, faEuroSign = {
  prefix: "fas",
  iconName: "euro-sign",
  icon: [320, 512, [8364, "eur", "euro"], "f153", "M48.1 240c-.1 2.7-.1 5.3-.1 8l0 16c0 2.7 0 5.3 .1 8L32 272c-17.7 0-32 14.3-32 32s14.3 32 32 32l28.3 0C89.9 419.9 170 480 264 480l24 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-24 0c-57.9 0-108.2-32.4-133.9-80L256 336c17.7 0 32-14.3 32-32s-14.3-32-32-32l-143.8 0c-.1-2.6-.2-5.3-.2-8l0-16c0-2.7 .1-5.4 .2-8L256 240c17.7 0 32-14.3 32-32s-14.3-32-32-32l-125.9 0c25.7-47.6 76-80 133.9-80l24 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-24 0C170 32 89.9 92.1 60.3 176L32 176c-17.7 0-32 14.3-32 32s14.3 32 32 32l16.1 0z"]
}, faEur = faEuroSign, faEuro = faEuroSign, faChair = {
  prefix: "fas",
  iconName: "chair",
  icon: [448, 512, [129681], "f6c0", "M248 48l0 208 48 0 0-197.3c23.9 13.8 40 39.7 40 69.3l0 128 48 0 0-128C384 57.3 326.7 0 256 0L192 0C121.3 0 64 57.3 64 128l0 128 48 0 0-128c0-29.6 16.1-55.5 40-69.3L152 256l48 0 0-208 48 0zM48 288c-12.1 0-23.2 6.8-28.6 17.7l-16 32c-5 9.9-4.4 21.7 1.4 31.1S20.9 384 32 384l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 256 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c11.1 0 21.4-5.7 27.2-15.2s6.4-21.2 1.4-31.1l-16-32C423.2 294.8 412.1 288 400 288L48 288z"]
}, faCircleCheck = {
  prefix: "fas",
  iconName: "circle-check",
  icon: [512, 512, [61533, "check-circle"], "f058", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM369 209L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]
}, faCheckCircle = faCircleCheck, faSquareDashedCirclePlus = {
  prefix: "fas",
  iconName: "square-dashed-circle-plus",
  icon: [576, 512, [], "e5c2", "M96 32C43 32 0 75 0 128l0 32 64 0 0-32c0-17.7 14.3-32 32-32l32 0 0-64L96 32zM0 192L0 320l64 0 0-128L0 192zM64 352L0 352l0 32c0 53 43 96 96 96l32 0 0-64-32 0c-17.7 0-32-14.3-32-32l0-32zM384 128l0 70.6c15.3-4.3 31.4-6.6 48-6.6c5.4 0 10.7 .2 16 .7l0-64.7c0-53-43-96-96-96l-32 0 0 64 32 0c17.7 0 32 14.3 32 32zM160 480l136.2 0c-15.3-18.5-26.9-40.2-33.6-64L160 416l0 64zm0-384l128 0 0-64L160 32l0 64zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16z"]
}, faHandHoldingCircleDollar = {
  prefix: "fas",
  iconName: "hand-holding-circle-dollar",
  icon: [576, 512, [], "e621", "M128 144a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm120.8-32.6c.6-.9 1.8-2.1 4.2-3.4c5.1-2.7 12.5-4.1 18.7-4c8.2 .1 17.1 1.8 26.4 4.1c8.6 2.1 17.3-3.1 19.4-11.7s-3.1-17.3-11.7-19.4c-5.6-1.4-11.6-2.7-17.9-3.7l0-9.4c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 9.5c-6.1 1.2-12.3 3.2-18 6.3c-11.8 6.3-23 18.4-21.8 37.2c1 16 11.7 25.3 21.6 30.7c8.8 4.7 19.7 7.8 28.6 10.3l1.8 .5c10.3 2.9 17.9 5.2 23.2 8.3c4.5 2.7 4.7 4.2 4.7 5.6c.1 2.4-.5 3.7-1 4.5c-.6 1-1.8 2.2-4 3.3c-4.7 2.5-11.8 3.8-18.5 3.6c-9.5-.3-18.5-3.1-29.9-6.8c-1.9-.6-3.8-1.2-5.8-1.8c-8.4-2.6-17.4 2.1-20 10.5s2.1 17.4 10.5 20c1.6 .5 3.3 1 5 1.6c0 0 0 0 0 0s0 0 0 0c7.1 2.3 15.1 4.9 23.7 6.6l0 11.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-10.8c6.2-1.1 12.5-3.1 18.3-6.2c12.1-6.5 22.3-18.7 21.7-36.9c-.5-16.2-10.3-26.3-20.5-32.3c-9.4-5.6-21.2-8.9-30.5-11.5l-.2 0c-10.4-2.9-18.3-5.2-23.9-8.2c-4.8-2.6-4.8-4-4.8-4.5c0 0 0 0 0-.1c-.1-1.9 .3-2.9 .8-3.6zM568.2 336.3c13.1 17.8 9.3 42.8-8.5 55.9L433.1 485.5c-23.4 17.2-51.6 26.5-80.7 26.5L192 512 32 512c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l36.8 0 44.9-36c22.7-18.2 50.9-28 80-28l78.3 0 16 0 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l120.6 0 119.7-88.2c17.8-13.1 42.8-9.3 55.9 8.5zM193.6 384c0 0 0 0 0 0l-.9 0c.3 0 .6 0 .9 0z"]
}, faMoneySimpleFromBracket = {
  prefix: "fas",
  iconName: "money-simple-from-bracket",
  icon: [640, 512, [], "e313", "M64 96l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 96C0 43 43 0 96 0L544 0c53 0 96 43 96 96l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7-14.3-32-32-32L96 64C78.3 64 64 78.3 64 96zm64 0l384 0 0 352c0 35.3-28.7 64-64 64l-256 0c-35.3 0-64-28.7-64-64l0-352zM320 352c53 0 96-35.8 96-80s-43-80-96-80s-96 35.8-96 80s43 80 96 80z"]
}, faBat = {
  prefix: "fas",
  iconName: "bat",
  icon: [576, 512, [], "f6b5", "M235.6 52.8l10.8 14.4c6 8.1 15.5 12.8 25.6 12.8l32 0c10.1 0 19.6-4.7 25.6-12.8l10.8-14.4c2.3-3 5.8-4.8 9.6-4.8c5.8 0 10.8 4.1 11.8 9.8l19 101.4L452.6 125c16.2-7.7 35.5-3.6 47.1 10C548.9 192.4 576 265.6 576 341.2l0 37.6c0 9.7-10.2 16-18.9 11.7l-63.8-31.9c-7.5-3.7-16.6-1.1-20.9 6.1l-29.8 49.7c-5.4 8.9-17.7 10.4-25 3.1l-36.6-36.6c-6.8-6.8-18.1-6.1-24 1.6l-56.2 73.1c-6.4 8.3-19 8.3-25.4 0l-56.2-73.1c-5.9-7.7-17.2-8.4-24-1.6l-36.6 36.6c-7.4 7.4-19.7 5.8-25-3.1l-29.8-49.7c-4.3-7.2-13.4-9.8-20.9-6.1L18.9 390.5c-8.7 4.3-18.9-2-18.9-11.7l0-37.6C0 265.6 27.1 192.4 76.3 135c11.6-13.6 30.9-17.7 47.1-10l71.8 34.2 19-101.4c1.1-5.7 6-9.8 11.8-9.8c3.8 0 7.4 1.8 9.6 4.8z"]
}, faCircleStop = {
  prefix: "fas",
  iconName: "circle-stop",
  icon: [512, 512, [62094, "stop-circle"], "f28d", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM192 160l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]
}, faStopCircle = faCircleStop, faHeadSideHeadphones = {
  prefix: "fas",
  iconName: "head-side-headphones",
  icon: [512, 512, [], "f8c2", "M256 0s0 0 0 0c95.2 0 174.2 69.3 189.4 160.1c2.2 13 6.7 25.7 15 36.1l42 52.6c6.2 7.8 9.6 17.4 9.6 27.4c0 24.2-19.6 43.8-43.8 43.8L448 320l0 64c0 35.3-28.7 64-64 64l-64 0 0 32c0 17.7-14.3 32-32 32L96 512c-17.7 0-32-14.3-32-32l0-72.7c0-16.7-6.9-32.5-17.1-45.8C16.6 322.4 0 274.1 0 224.2C0 122.8 67.4 36.9 160 9.3l0 77.3c0 12.4-7.4 23.3-17.4 30.5C114.4 137.4 96 170.6 96 208c0 61.9 50.1 112 112 112s112-50.1 112-112c0-37.4-18.4-70.6-46.6-90.9c-10-7.2-17.4-18.2-17.4-30.5L256 0zM240 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-96 0a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]
}, faPhoneRotary = {
  prefix: "fas",
  iconName: "phone-rotary",
  icon: [512, 512, [9742], "f8d3", "M0 141.3c0-8.5 3.4-16.6 9.9-22.1C38.2 95.4 125.9 32 256 32s217.8 63.4 246.1 87.2c6.5 5.5 9.9 13.6 9.9 22.1l0 34.7c0 17.7-14.3 32-32 32l-42.3 0c-13.1 0-24.9-8-29.7-20.1l-19.4-48.6c-2.9-7.3-8.4-13.2-15.7-16c-18.6-7-59.5-19.3-116.8-19.3s-98.2 12.3-116.8 19.3c-7.3 2.8-12.8 8.7-15.7 16L104 187.9C99.2 200 87.4 208 74.3 208L32 208c-17.7 0-32-14.3-32-32l0-34.7zM32 432l0-31c0-11.1 2.9-22.1 8.4-31.8l101.1-177C153 172.3 174.2 160 197.1 160l117.7 0c23 0 44.2 12.3 55.6 32.2l101.1 177c5.5 9.7 8.4 20.6 8.4 31.8l0 31c0 26.5-21.5 48-48 48L80 480c-26.5 0-48-21.5-48-48zM328 312a72 72 0 1 0 -144 0 72 72 0 1 0 144 0z"]
}, faArrowUpToBracket = {
  prefix: "fas",
  iconName: "arrow-up-to-bracket",
  icon: [448, 512, [], "e66a", "M374.6 297.4l-128-128c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 269.3 192 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.7 73.4 73.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3zM64 160l0-64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-53-43-96-96-96L96 0C43 0 0 43 0 96l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32z"]
}, faCompassDrafting = {
  prefix: "fas",
  iconName: "compass-drafting",
  icon: [512, 512, ["drafting-compass"], "f568", "M352 96c0 14.3-3.1 27.9-8.8 40.2L396 227.4c-23.7 25.3-54.2 44.1-88.5 53.6L256 192c0 0 0 0 0 0s0 0 0 0l-68 117.5c21.5 6.8 44.3 10.5 68.1 10.5c70.7 0 133.8-32.7 174.9-84c11.1-13.8 31.2-16 45-5s16 31.2 5 45C428.1 341.8 347 384 256 384c-35.4 0-69.4-6.4-100.7-18.1L98.7 463.7C94 471.8 87 478.4 78.6 482.6L23.2 510.3c-5 2.5-10.9 2.2-15.6-.7S0 501.5 0 496l0-55.4c0-8.4 2.2-16.7 6.5-24.1l60-103.7C53.7 301.6 41.8 289.3 31.2 276c-11.1-13.8-8.8-33.9 5-45s33.9-8.8 45 5c5.7 7.1 11.8 13.8 18.2 20.1l69.4-119.9c-5.6-12.2-8.8-25.8-8.8-40.2c0-53 43-96 96-96s96 43 96 96zm21 297.9c32.6-12.8 62.5-30.8 88.9-52.9l43.7 75.5c4.2 7.3 6.5 15.6 6.5 24.1l0 55.4c0 5.5-2.9 10.7-7.6 13.6s-10.6 3.2-15.6 .7l-55.4-27.7c-8.4-4.2-15.4-10.8-20.1-18.9L373 393.9zM256 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faDraftingCompass = faCompassDrafting, faPlateWheat = {
  prefix: "fas",
  iconName: "plate-wheat",
  icon: [512, 512, [], "e55a", "M176 32c44.2 0 80 35.8 80 80l0 16c0 8.8-7.2 16-16 16c-44.2 0-80-35.8-80-80l0-16c0-8.8 7.2-16 16-16zM56 64l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM24 136l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 184c-13.3 0-24-10.7-24-24s10.7-24 24-24zm8 96c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zM272 48c0-8.8 7.2-16 16-16c44.2 0 80 35.8 80 80l0 16c0 8.8-7.2 16-16 16c-44.2 0-80-35.8-80-80l0-16zM400 32c44.2 0 80 35.8 80 80l0 16c0 8.8-7.2 16-16 16c-44.2 0-80-35.8-80-80l0-16c0-8.8 7.2-16 16-16zm80 160l0 16c0 44.2-35.8 80-80 80c-8.8 0-16-7.2-16-16l0-16c0-44.2 35.8-80 80-80c8.8 0 16 7.2 16 16zM352 176c8.8 0 16 7.2 16 16l0 16c0 44.2-35.8 80-80 80c-8.8 0-16-7.2-16-16l0-16c0-44.2 35.8-80 80-80zm-96 16l0 16c0 44.2-35.8 80-80 80c-8.8 0-16-7.2-16-16l0-16c0-44.2 35.8-80 80-80c8.8 0 16 7.2 16 16zM3.5 347.6C1.6 332.9 13 320 27.8 320l456.4 0c14.8 0 26.2 12.9 24.4 27.6C502.3 397.8 464.2 437 416 446l0 2c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-2c-48.2-9-86.3-48.2-92.5-98.4z"]
}, faCalendarCircleMinus = {
  prefix: "fas",
  iconName: "calendar-circle-minus",
  icon: [576, 512, [], "e46f", "M128 0C110.3 0 96 14.3 96 32l0 32L48 64C21.5 64 0 85.5 0 112l0 48 448 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32zM256 368c0-91.8 70.3-167.2 160-175.3l0-.7L0 192 0 464c0 26.5 21.5 48 48 48l282.8 0C285.6 480.1 256 427.5 256 368zm320 0a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-64 0c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l128 0c8.8 0 16 7.2 16 16z"]
}, faChopsticks = {
  prefix: "fas",
  iconName: "chopsticks",
  icon: [640, 512, [], "e3f7", "M368 0c-15.3 0-29 7.2-37.7 18.3L3.4 486.1c-5.5 6.9-4.3 17 2.7 22.5s17 4.2 22.5-2.7L405.7 77.7C412.2 69.5 416 59.2 416 48c0-26.5-21.5-48-48-48zM131.9 506.4c5.8 6.7 15.9 7.5 22.6 1.7L623.2 148.4c10.3-8.8 16.8-21.9 16.8-36.4c0-26.5-21.5-48-48-48c-11.9 0-22.8 4.4-31.2 11.6L133.6 483.9c-6.7 5.8-7.5 15.8-1.7 22.6z"]
}, faCarWrench = {
  prefix: "fas",
  iconName: "car-wrench",
  icon: [512, 512, ["car-mechanic"], "f5e3", "M468.9 104L456 104l-.5 0c-.7 0-1.4-.1-2.1-.1C441.3 102.5 432 92.4 432 80s9.3-22.5 21.3-23.9c.7-.1 1.4-.1 2.1-.1l.5 0 12.9 0 17.6 0c10.8 0 18.4-10.6 12.5-19.6c-3.6-5.5-7.8-10.5-12.5-14.9c-4.2-3.9-8.8-7.4-13.8-10.3C470.8 10 468.9 9 466.9 8C456.4 2.9 444.5 0 432 0c-29.1 0-54.5 15.5-68.5 38.7c-3.3 5.4-8.9 9.3-15.3 9.3L163.8 48c-6.4 0-12-3.8-15.3-9.3C134.5 15.5 109.1 0 80 0C67.5 0 55.6 2.9 45.1 8c-2 1-3.9 2-5.8 3.1c-5 2.9-9.6 6.4-13.8 10.3c-4.7 4.4-9 9.4-12.5 14.9C7 45.4 14.7 56 25.5 56l17.6 0L56 56l.5 0c.7 0 1.4 .1 2.1 .1C70.7 57.5 80 67.6 80 80s-9.3 22.5-21.3 23.9c-.7 .1-1.4 .1-2.1 .1l-.5 0-12.9 0-17.6 0C14.7 104 7 114.6 12.9 123.6c3.6 5.5 7.8 10.5 12.5 14.9c4.2 3.9 8.8 7.4 13.8 10.3c1.9 1.1 3.8 2.2 5.8 3.1c10.6 5.1 22.4 8 34.9 8c29.1 0 54.5-15.5 68.5-38.7c3.3-5.4 8.9-9.3 15.3-9.3l184.4 0c6.4 0 12 3.8 15.3 9.3c14 23.2 39.5 38.7 68.5 38.7c12.5 0 24.4-2.9 34.9-8c2-1 3.9-2 5.8-3.1c5-2.9 9.6-6.4 13.8-10.3c4.7-4.4 9-9.4 12.5-14.9c5.9-9-1.7-19.6-12.5-19.6l-17.6 0zM185.8 224l140.3 0c6.8 0 12.8 4.3 15.1 10.6L360.3 288l-208.6 0 19.1-53.4c2.3-6.4 8.3-10.6 15.1-10.6zm-75.3-10.9L82.2 292.4C62.1 300.9 48 320.8 48 344l0 40 0 64 0 32c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-32 256 0 0 32c0 17.7 14.3 32 32 32l16 0c17.7 0 32-14.3 32-32l0-32 0-64 0-40c0-23.2-14.1-43.1-34.2-51.6l-28.3-79.3C390.1 181.3 360 160 326.2 160l-140.3 0c-33.8 0-64 21.3-75.3 53.1zM128 344a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm232 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faCarMechanic = faCarWrench, faIcicles = {
  prefix: "fas",
  iconName: "icicles",
  icon: [512, 512, [], "f7ad", "M75.8 304.8L1 35.7c-.7-2.5-1-5-1-7.5C0 12.6 12.6 0 28.2 0H482.4C498.8 0 512 13.2 512 29.6c0 1.6-.1 3.3-.4 4.9L434.6 496.1c-1.5 9.2-9.5 15.9-18.8 15.9c-9.2 0-17.1-6.6-18.7-15.6L336 160 307.2 303.9c-1.9 9.3-10.1 16.1-19.6 16.1c-9.2 0-17.2-6.2-19.4-15.1L240 192 210.6 368.2c-1.5 9.1-9.4 15.8-18.6 15.8s-17.1-6.7-18.6-15.8L144 192 115.9 304.3c-2.3 9.2-10.6 15.7-20.1 15.7c-9.3 0-17.5-6.2-20-15.2z"]
}, faPersonShelter = {
  prefix: "fas",
  iconName: "person-shelter",
  icon: [512, 512, [], "e54f", "M271.9 4.2c-9.8-5.6-21.9-5.6-31.8 0l-224 128C6.2 137.9 0 148.5 0 160L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-301.4L256 68.9 448 178.6 448 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-11.5-6.2-22.1-16.1-27.8l-224-128zM256 208a40 40 0 1 0 0-80 40 40 0 1 0 0 80zm-8 280l0-88 16 0 0 88c0 13.3 10.7 24 24 24s24-10.7 24-24l0-174.5 26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-37.9-70.3c-15.3-28.5-45.1-46.3-77.5-46.3l-19.5 0c-32.4 0-62.1 17.8-77.5 46.3l-37.9 70.3c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L200 313.5 200 488c0 13.3 10.7 24 24 24s24-10.7 24-24z"]
}, faNeuter = {
  prefix: "fas",
  iconName: "neuter",
  icon: [384, 512, [9906], "f22c", "M80 176a112 112 0 1 1 224 0A112 112 0 1 1 80 176zM224 349.1c81.9-15 144-86.8 144-173.1C368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144 173.1L160 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-130.9z"]
}, faIdBadge = {
  prefix: "fas",
  iconName: "id-badge",
  icon: [384, 512, [], "f2c1", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zm96 320l64 0c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16L96 416c-8.8 0-16-7.2-16-16c0-44.2 35.8-80 80-80zm-32-96a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zM144 64l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faKazoo = {
  prefix: "fas",
  iconName: "kazoo",
  icon: [640, 512, [], "f8c7", "M514 128l94 0c17.7 0 32 14.3 32 32l0 192c0 17.7-14.3 32-32 32l-94 0c-19.8 10.2-42.2 16-66 16s-46.3-5.8-66-16l-158 0c-3 0-6-.4-9-1.3l-192-56C9.4 322.7 0 310.2 0 296l0-80c0-14.2 9.4-26.7 23-30.7l192-56c2.9-.8 5.9-1.3 9-1.3l158 0c19.8-10.2 42.2-16 66-16s46.3 5.8 66 16zm30 128a96 96 0 1 0 -192 0 96 96 0 1 0 192 0zM427.3 212.7L448 233.4l20.7-20.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L470.6 256l20.7 20.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L448 278.6l-20.7 20.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L425.4 256l-20.7-20.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z"]
}, faMarker = {
  prefix: "fas",
  iconName: "marker",
  icon: [512, 512, [], "f5a1", "M481 31C445.1-4.8 386.9-4.8 351 31l-15 15L322.9 33C294.8 4.9 249.2 4.9 221.1 33L135 119c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L255 66.9c9.4-9.4 24.6-9.4 33.9 0L302.1 80 186.3 195.7 316.3 325.7 481 161c35.9-35.9 35.9-94.1 0-129.9zM293.7 348.3L163.7 218.3 99.5 282.5c-48 48-80.8 109.2-94.1 175.8l-5 25c-1.6 7.9 .9 16 6.6 21.7s13.8 8.1 21.7 6.6l25-5c66.6-13.3 127.8-46.1 175.8-94.1l64.2-64.2z"]
}, faBinBottles = {
  prefix: "fas",
  iconName: "bin-bottles",
  icon: [640, 512, [], "e5f5", "M152 0l80 0c13.3 0 24 10.7 24 24l0 8c8.8 0 16 7.2 16 16s-7.2 16-16 16L128 64c-8.8 0-16-7.2-16-16s7.2-16 16-16l0-8c0-13.3 10.7-24 24-24zM32 192c0-53 43-96 96-96l128 0c24.9 0 47.6 9.5 64.6 25c1.1 1 2.2 2 3.2 3.1C341.3 141.5 352 165.5 352 192L32 192zm352 0c0-40.7-19-76.9-48.6-100.4c5.2-5.6 11.5-10.3 18.6-13.6l13.2-6.2c5.3-2.5 10.8-4.4 16.4-5.7l0-42.1c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24l0 42.1c5.6 1.3 11.1 3.2 16.4 5.7L541.2 78c21 9.9 34.4 31 34.4 54.2c0 12.3-3.7 23.8-10.1 33.3c5 7.8 8.4 16.9 9.6 26.5L384 192zM0 256c0-17.7 14.3-32 32-32l576 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L583.8 457c-4.5 31.5-31.5 55-63.4 55l-401 0c-31.8 0-58.9-23.4-63.4-55L32 288c-17.7 0-32-14.3-32-32z"]
}, faFaceLaughBeam = {
  prefix: "fas",
  iconName: "face-laugh-beam",
  icon: [512, 512, [128513, "laugh-beam"], "f59a", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM96.8 314.1c-3.8-13.7 7.4-26.1 21.6-26.1l275.2 0c14.2 0 25.5 12.4 21.6 26.1C396.2 382 332.1 432 256 432s-140.2-50-159.2-117.9zM217.6 212.8s0 0 0 0c0 0 0 0 0 0l-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8c0 0 0 0 0 0s0 0 0 0zm160 0c0 0 0 0 0 0l-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8c0 0 0 0 0 0s0 0 0 0s0 0 0 0z"]
}, faLaughBeam = faFaceLaughBeam, faSquareArrowDownLeft = {
  prefix: "fas",
  iconName: "square-arrow-down-left",
  icon: [448, 512, [], "e261", "M64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480zM288 368c13.3 0 24-10.7 24-24s-10.7-24-24-24l-94.1 0L329 185c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-135 135L160 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 160c0 13.3 10.7 24 24 24l152 0z"]
}, faBatteryBolt = {
  prefix: "fas",
  iconName: "battery-bolt",
  icon: [576, 512, [], "f376", "M80 96C35.8 96 0 131.8 0 176L0 336c0 44.2 35.8 80 80 80l92.2 0c-12.9-14.5-16.1-35.6-7.2-53.5l5.3-10.5L80 352c-8.8 0-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16l139.2 0 80-64L80 96zM464 352l-139.2 0-80 64L464 416c44.2 0 80-35.8 80-80l0-16c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-16c0-44.2-35.8-80-80-80l-92.2 0c13 14.5 16.1 35.6 7.2 53.5L373.7 160l90.3 0c8.8 0 16 7.2 16 16l0 160c0 8.8-7.2 16-16 16zM346.1 115.6c-5.8-4.7-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7l70.1 0L193.7 376.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7l-70.1 0 52.4-104.8c3.4-6.7 1.6-14.9-4.2-19.6z"]
}, faTreeLarge = {
  prefix: "fas",
  iconName: "tree-large",
  icon: [448, 512, [], "f7dd", "M62 169.4L210.6 5.9C214 2.1 218.9 0 224 0s10 2.1 13.4 5.9L386 169.4c3.9 4.2 6 9.8 6 15.5c0 12.7-10.3 23.1-23.1 23.1H344l75.5 105.7c2.9 4.1 4.5 9 4.5 14.1c0 13.4-10.9 24.2-24.2 24.2H368l76.2 122c2.5 4 3.8 8.5 3.8 13.2c0 13.7-11.1 24.9-24.9 24.9H24.9C11.1 512 0 500.9 0 487.1c0-4.7 1.3-9.2 3.8-13.2L80 352H48.2C34.8 352 24 341.1 24 327.8c0-5 1.6-10 4.5-14.1L104 208H79.1C66.3 208 56 197.7 56 184.9c0-5.7 2.1-11.3 6-15.5z"]
}, faHelicopterSymbol = {
  prefix: "fas",
  iconName: "helicopter-symbol",
  icon: [512, 512, [], "e502", "M445.3 224l64.7 0C495.6 108.2 403.8 16.4 288 2l0 64.7C368.4 80.1 431.9 143.6 445.3 224zM510 288l-64.7 0C431.9 368.4 368.4 431.9 288 445.3l0 64.7c115.8-14.4 207.6-106.2 222-222zM2 288C16.4 403.8 108.2 495.6 224 510l0-64.7C143.6 431.9 80.1 368.4 66.7 288L2 288zm0-64l64.7 0C80.1 143.6 143.6 80.1 224 66.7L224 2C108.2 16.4 16.4 108.2 2 224zm206-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 96 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-192c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64-96 0 0-64z"]
}, faAperture = {
  prefix: "fas",
  iconName: "aperture",
  icon: [512, 512, [], "e2df", "M256 0c4 0 7.9 .1 11.9 .3c11.3 .5 17.5 12.9 11.8 22.8L177.5 200c-6.2 10.7-21.6 10.7-27.7 0L82.8 84.1c-3.6-6.3-2.6-14.3 2.9-19.2C130.9 24.5 190.6 0 256 0zM0 256c0-50.9 14.9-98.3 40.5-138.2c6.1-9.5 19.9-8.6 25.6 1.2L168.2 296c6.2 10.7-1.5 24-13.9 24L20.5 320c-7.3 0-13.7-4.9-15.2-12.1C1.8 291.2 0 273.8 0 256zM193.7 492c-3.6 6.3-11.1 9.4-18 7.1C111.8 478 59 432.5 28.5 373.6C23.3 363.5 31 352 42.3 352l204.4 0c12.3 0 20 13.3 13.9 24l-67 116zM256 512c-4 0-7.9-.1-11.9-.3c-11.3-.5-17.5-12.9-11.8-22.8L334.5 312c6.2-10.7 21.6-10.7 27.7 0l66.9 115.9c3.6 6.3 2.6 14.3-2.9 19.2C381.1 487.5 321.4 512 256 512zM512 256c0 50.9-14.9 98.3-40.5 138.2c-6.1 9.5-19.9 8.6-25.6-1.2L343.8 216c-6.2-10.7 1.5-24 13.9-24l133.9 0c7.3 0 13.7 4.9 15.2 12.1c3.5 16.8 5.3 34.1 5.3 51.9zM318.3 20c3.6-6.3 11.1-9.4 18-7.1C400.2 34 453 79.5 483.5 138.4c5.2 10.1-2.5 21.6-13.8 21.6l-204.4 0c-12.3 0-20-13.3-13.9-24l67-116z"]
}, faUniversalAccess = {
  prefix: "fas",
  iconName: "universal-access",
  icon: [512, 512, [], "f29a", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm161.5-86.1c-12.2-5.2-26.3 .4-31.5 12.6s.4 26.3 12.6 31.5l11.9 5.1c17.3 7.4 35.2 12.9 53.6 16.3l0 50.1c0 4.3-.7 8.6-2.1 12.6l-28.7 86.1c-4.2 12.6 2.6 26.2 15.2 30.4s26.2-2.6 30.4-15.2l24.4-73.2c1.3-3.8 4.8-6.4 8.8-6.4s7.6 2.6 8.8 6.4l24.4 73.2c4.2 12.6 17.8 19.4 30.4 15.2s19.4-17.8 15.2-30.4l-28.7-86.1c-1.4-4.1-2.1-8.3-2.1-12.6l0-50.1c18.4-3.5 36.3-8.9 53.6-16.3l11.9-5.1c12.2-5.2 17.8-19.3 12.6-31.5s-19.3-17.8-31.5-12.6L338.7 175c-26.1 11.2-54.2 17-82.7 17s-56.5-5.8-82.7-17l-11.9-5.1zM256 160a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]
}, faGearComplex = {
  prefix: "fas",
  iconName: "gear-complex",
  icon: [512, 512, [], "e5e9", "M305.4 21.8c-1.3-10.4-9.1-18.8-19.5-20C276.1 .6 266.1 0 256 0c-11.1 0-22.1 .7-32.8 2.1c-10.3 1.3-18 9.7-19.3 20l-2.9 23.1c-.8 6.4-5.4 11.6-11.5 13.7c-9.6 3.2-19 7.2-27.9 11.7c-5.8 3-12.8 2.5-18-1.5l-18-14c-8.2-6.4-19.7-6.8-27.9-.4c-16.6 13-31.5 28-44.4 44.7c-6.3 8.2-5.9 19.6 .5 27.8l14.2 18.3c4 5.1 4.4 12 1.5 17.8c-4.4 8.8-8.2 17.9-11.3 27.4c-2 6.2-7.3 10.8-13.7 11.6l-22.8 2.9c-10.3 1.3-18.7 9.1-20 19.4C.7 234.8 0 245.3 0 256c0 10.6 .6 21.1 1.9 31.4c1.3 10.3 9.7 18.1 20 19.4l22.8 2.9c6.4 .8 11.7 5.4 13.7 11.6c3.1 9.5 6.9 18.7 11.3 27.5c2.9 5.8 2.4 12.7-1.5 17.8L54 384.8c-6.4 8.2-6.8 19.6-.5 27.8c12.9 16.7 27.8 31.7 44.4 44.7c8.2 6.4 19.7 6 27.9-.4l18-14c5.1-4 12.2-4.4 18-1.5c9 4.6 18.3 8.5 27.9 11.7c6.1 2.1 10.7 7.3 11.5 13.7l2.9 23.1c1.3 10.3 9 18.7 19.3 20c10.7 1.4 21.7 2.1 32.8 2.1c10.1 0 20.1-.6 29.9-1.7c10.4-1.2 18.2-9.7 19.5-20l2.8-22.5c.8-6.5 5.5-11.8 11.7-13.8c10-3.2 19.7-7.2 29-11.8c5.8-2.9 12.7-2.4 17.8 1.5L385 457.9c8.2 6.4 19.6 6.8 27.8 .5c2.8-2.2 5.5-4.4 8.2-6.7L451.7 421c1.8-2.2 3.6-4.4 5.4-6.6c6.5-8.2 6-19.7-.4-27.9l-14-17.9c-4-5.1-4.4-12.2-1.5-18c4.8-9.4 9-19.3 12.3-29.5c2-6.2 7.3-10.8 13.7-11.6l22.8-2.8c10.3-1.3 18.8-9.1 20-19.4c.2-1.7 .4-3.5 .6-5.2l0-51.9c-.2-1.7-.4-3.5-.6-5.2c-1.3-10.3-9.7-18.1-20-19.4l-22.8-2.8c-6.4-.8-11.7-5.4-13.7-11.6c-3.4-10.2-7.5-20.1-12.3-29.5c-3-5.8-2.5-12.8 1.5-18l14-17.9c6.4-8.2 6.8-19.7 .4-27.9c-1.8-2.2-3.6-4.4-5.4-6.6L421 60.3c-2.7-2.3-5.4-4.5-8.2-6.7c-8.2-6.4-19.6-5.9-27.8 .5L366.7 68.3c-5.1 4-12.1 4.4-17.8 1.5c-9.3-4.6-19-8.6-29-11.8c-6.2-2-10.9-7.3-11.7-13.7l-2.8-22.5zM256 176a80 80 0 1 1 0 160 80 80 0 1 1 0-160z"]
}, faFileMagnifyingGlass = {
  prefix: "fas",
  iconName: "file-magnifying-glass",
  icon: [384, 512, ["file-search"], "f865", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zm16 304c0 17.8-4.9 34.5-13.3 48.9L297 391.2c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-38.4-38.4C210.4 395.2 193.8 400 176 400c-53 0-96-43-96-96s43-96 96-96s96 43 96 96zm-96 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]
}, faFileSearch = faFileMagnifyingGlass, faUpRight = {
  prefix: "fas",
  iconName: "up-right",
  icon: [384, 512, [], "e2be", "M336 80L96 80c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l72 72L11.3 340.7C4.1 347.9 0 357.8 0 368s4.1 20.1 11.3 27.3l41.4 41.4C59.9 443.9 69.8 448 80 448s20.1-4.1 27.3-11.3L241.4 302.6l72 72c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6l0-240c0-17.7-14.3-32-32-32z"]
}, faCircleChevronUp = {
  prefix: "fas",
  iconName: "circle-chevron-up",
  icon: [512, 512, ["chevron-circle-up"], "f139", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM377 271c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-87-87-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 167c9.4-9.4 24.6-9.4 33.9 0L377 271z"]
}, faChevronCircleUp = faCircleChevronUp, faUserPolice = {
  prefix: "fas",
  iconName: "user-police",
  icon: [448, 512, [], "e333", "M230.1 .8l152 40c8.6 2.3 15.3 9.1 17.3 17.8s-1 17.8-7.8 23.6L368 102.5l0 8.4c0 10.7-5.3 20.8-15.1 25.2c-24.1 10.8-68.6 24-128.9 24s-104.8-13.2-128.9-24C85.3 131.7 80 121.6 80 110.9l0-8.4L56.4 82.2c-6.8-5.8-9.8-14.9-7.8-23.6s8.7-15.6 17.3-17.8l152-40c4-1.1 8.2-1.1 12.2 0zM227 48.6c-1.9-.8-4-.8-5.9 0L189 61.4c-3 1.2-5 4.2-5 7.4c0 17.2 7 46.1 36.9 58.6c2 .8 4.2 .8 6.2 0C257 114.9 264 86 264 68.8c0-3.3-2-6.2-5-7.4L227 48.6zM98.1 168.8c39.1 15 81.5 23.2 125.9 23.2s86.8-8.2 125.9-23.2c1.4 7.5 2.1 15.3 2.1 23.2c0 70.7-57.3 128-128 128s-128-57.3-128-128c0-7.9 .7-15.7 2.1-23.2zM134.4 352c2.8 0 5.5 .9 7.7 2.6l72.3 54.2c5.7 4.3 13.5 4.3 19.2 0l72.3-54.2c2.2-1.7 4.9-2.6 7.7-2.6C387.8 352 448 412.2 448 486.4c0 14.1-11.5 25.6-25.6 25.6L25.6 512C11.5 512 0 500.5 0 486.4C0 412.2 60.2 352 134.4 352zM352 408c-3.5 0-6.5 2.2-7.6 5.5L339 430.2l-17.4 0c-3.5 0-6.6 2.2-7.6 5.5s.1 6.9 2.9 9L331 454.8l-5.4 16.6c-1.1 3.3 .1 6.9 2.9 9s6.6 2 9.4 0L352 470.1l14.1 10.3c2.8 2 6.6 2.1 9.4 0s4-5.7 2.9-9L373 454.8l14.1-10.2c2.8-2 4-5.7 2.9-9s-4.2-5.5-7.6-5.5l-17.4 0-5.4-16.6c-1.1-3.3-4.1-5.5-7.6-5.5z"]
}, faLariSign = {
  prefix: "fas",
  iconName: "lari-sign",
  icon: [384, 512, [], "e1c8", "M144 32c17.7 0 32 14.3 32 32l0 32.7c5.3-.4 10.6-.7 16-.7s10.7 .2 16 .7L208 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 49.4c54.9 25.2 95.8 75.5 108.2 136.2c3.5 17.3-7.7 34.2-25 37.7s-34.2-7.7-37.7-25c-6.1-29.9-22.5-55.9-45.4-74.3l0 67.9c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-95c-5.2-.7-10.6-1-16-1s-10.8 .3-16 1l0 95c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-67.9C82.7 211.5 64 247.6 64 288c0 70.7 57.3 128 128 128l160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l16.9 0C18.5 382 0 337.2 0 288c0-77.5 45.9-144.3 112-174.6L112 64c0-17.7 14.3-32 32-32z"]
}, faVolcano = {
  prefix: "fas",
  iconName: "volcano",
  icon: [512, 512, [127755], "f770", "M160 144c-35.3 0-64-28.7-64-64s28.7-64 64-64c15.7 0 30 5.6 41.2 15C212.4 12.4 232.7 0 256 0s43.6 12.4 54.8 31C322 21.6 336.3 16 352 16c35.3 0 64 28.7 64 64s-28.7 64-64 64c-14.7 0-28.3-5-39.1-13.3l-32 48C275.3 187 266 192 256 192s-19.3-5-24.9-13.3l-32-48C188.3 139 174.7 144 160 144zM144 352l48.4-24.2c10.2-5.1 21.6-7.8 33-7.8c19.6 0 38.4 7.8 52.2 21.6l32.5 32.5c6.3 6.3 14.9 9.9 23.8 9.9c11.3 0 21.8-5.6 28-15l9.7-14.6-58.9-66.3c-9.1-10.2-22.2-16.1-35.9-16.1l-41.8 0c-13.7 0-26.8 5.9-35.9 16.1l-59.9 67.4L144 352zm19.4-95.8c18.2-20.5 44.3-32.2 71.8-32.2l41.8 0c27.4 0 53.5 11.7 71.8 32.2l150.2 169c8.5 9.5 13.2 21.9 13.2 34.7c0 28.8-23.4 52.2-52.2 52.2L52.2 512C23.4 512 0 488.6 0 459.8c0-12.8 4.7-25.1 13.2-34.7l150.2-169z"]
}, faTeddyBear = {
  prefix: "fas",
  iconName: "teddy-bear",
  icon: [576, 512, [], "e3cf", "M154.7 103.7C138.7 93.9 128 76.2 128 56c0-30.9 25.1-56 56-56c24.2 0 44.7 15.3 52.6 36.7C252.5 33.5 269.8 32 288 32s35.5 1.5 51.4 4.7C347.3 15.3 367.8 0 392 0c30.9 0 56 25.1 56 56c0 20.2-10.7 37.9-26.7 47.7c1.8 7.4 2.7 15.5 2.7 24.3c0 70.7-60.9 128-136 128s-136-57.3-136-128c0-8.8 .9-16.8 2.7-24.3zM240 128a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm112-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm0 64c0-26.5-28.7-48-64-48s-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48zm-32-8c0 13.3-14.3 24-32 24s-32-10.7-32-24s14.3-24 32-24s32 10.7 32 24zM50.3 178.3c20.8-16.4 51-12.8 67.4 8L143.5 219c73.7 93.5 215.4 93.5 289.1 0l25.8-32.7c16.4-20.8 46.6-24.4 67.4-8s24.4 46.6 8 67.4l-25.8 32.7c-17.7 22.4-37.9 41.3-59.9 56.7l0 64.9 16.6 0c3.9-27.1 27.2-48 55.4-48c30.9 0 56 25.1 56 56c0 2.7-.2 5.4-.6 8l-13 53.3c-5.8 23.8-26.3 40.9-50.4 42.6l0 .1-4 0-28 0L96 512l-28 0-4 0 0-.1c-24.1-1.7-44.6-18.8-50.4-42.6L.6 416c-.4-2.6-.6-5.3-.6-8c0-30.9 25.1-56 56-56c28.2 0 51.6 20.9 55.4 48l16.6 0 0-64.9c-22-15.4-42.3-34.3-59.9-56.7L42.3 245.7c-16.4-20.8-12.8-51 8-67.4zM256 352c-35.3 0-64 28.7-64 64l192 0c0-35.3-28.7-64-64-64l-64 0z"]
}, faStocking = {
  prefix: "fas",
  iconName: "stocking",
  icon: [384, 512, [], "f7d5", "M96 0C78.3 0 64 14.3 64 32l0 32c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32L96 0zm0 128l0 110.9c0 10.7-5.3 20.7-14.2 26.6L55.7 282.9C20.9 306.1 0 345.1 0 386.9l0 2.2C0 457 55 512 122.8 512c24.2 0 48-7.2 68.1-20.6L295 422c35.6-23.7 57-63.7 57-106.5L352 128 96 128z"]
}, faPersonWalkingDashedLineArrowRight = {
  prefix: "fas",
  iconName: "person-walking-dashed-line-arrow-right",
  icon: [640, 512, [], "e553", "M208 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM123.7 200.5c1-.4 1.9-.8 2.9-1.2l-16.9 63.5c-5.6 21.1-.1 43.6 14.7 59.7l70.7 77.1 22 88.1c4.3 17.1 21.7 27.6 38.8 23.3s27.6-21.7 23.3-38.8l-23-92.1c-1.9-7.8-5.8-14.9-11.2-20.8l-49.5-54 19.3-65.5 9.6 23c4.4 10.6 12.5 19.3 22.8 24.5l26.7 13.3c15.8 7.9 35 1.5 42.9-14.3s1.5-35-14.3-42.9L281 232.7l-15.3-36.8C248.5 154.8 208.3 128 163.7 128c-22.8 0-45.3 4.8-66.1 14l-8 3.5c-32.9 14.6-58.1 42.4-69.4 76.5l-2.6 7.8c-5.6 16.8 3.5 34.9 20.2 40.5s34.9-3.5 40.5-20.2l2.6-7.8c5.7-17.1 18.3-30.9 34.7-38.2l8-3.5zm-30 135.1L68.7 398 9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L116.3 441c4.6-4.6 8.2-10.1 10.6-16.1l14.5-36.2-40.7-44.4c-2.5-2.7-4.8-5.6-7-8.6zM550.6 153.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L530.7 224 384 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l146.7 0-25.4 25.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l80-80c12.5-12.5 12.5-32.8 0-45.3l-80-80zM392 0c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-13.3-10.7-24-24-24zm24 152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16zM392 320c-13.3 0-24 10.7-24 24l0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16c0-13.3-10.7-24-24-24zm24 120c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48z"]
}, faImageSlash = {
  prefix: "fas",
  iconName: "image-slash",
  icon: [640, 512, [], "e1b7", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-55.5-43.5c.5-3.1 .7-6.3 .7-9.6l0-320c0-35.3-28.7-64-64-64L128 32c-14.4 0-27.8 4.8-38.5 12.9L38.8 5.1zm120 94.1c5.3-2 11.1-3.2 17.2-3.2c26.5 0 48 21.5 48 48c0 2-.1 4-.4 6L158.8 99.2zM328.1 231.9l20-29.4c4.5-6.6 11.9-10.5 19.8-10.5s15.4 3.9 19.8 10.5L499.4 366.1 328.1 231.9zM221.7 272.5c.3-.4 .6-.7 1-1.1L64 146.4 64 416c0 35.3 28.7 64 64 64l359.4 0-81.2-64L320 416l-72 0-96 0c-9.3 0-17.8-5.4-21.8-13.9s-2.6-18.5 3.5-25.6l88-104z"]
}, faMaskSnorkel = {
  prefix: "fas",
  iconName: "mask-snorkel",
  icon: [576, 512, [], "e3b7", "M544 32c-17.7 0-32 14.3-32 32l0 96 64 0 0-96c0-17.7-14.3-32-32-32zM512 367.4c0 44.5-36.1 80.6-80.6 80.6c-39.4 0-73-28.5-79.5-67.4l-.3-1.9c-2.9-17.4-19.4-29.2-36.8-26.3s-29.2 19.4-26.3 36.8l.3 1.9C300.4 460.9 360.7 512 431.4 512C511.3 512 576 447.3 576 367.4L576 192l-64 0 0 175.4zM64 64C28.7 64 0 92.7 0 128l0 96c0 35.3 28.7 64 64 64l79.7 0c28.6 0 53.7-18.9 61.5-46.4l3.4-11.7c4.4-15.5 26.3-15.5 30.8 0l3.4 11.7c7.8 27.5 33 46.4 61.5 46.4l79.7 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64L64 64z"]
}, faSmoke = {
  prefix: "fas",
  iconName: "smoke",
  icon: [640, 512, [], "f760", "M172.3 194.3c-9.2-1.5-18.7-2.3-28.3-2.3c-29.2 0-56.7 7.1-80.9 19.6C43.7 189.2 32 160 32 128C32 57.3 89.3 0 160 0c40.1 0 75.9 18.4 99.3 47.3C277.4 37.5 298 32 320 32c44.3 0 83.4 22.5 106.4 56.8c-11.5 7.3-22 16-31.2 25.9C372.7 102.8 347.2 96 320 96c-66.5 0-123.5 40.6-147.7 98.3zm276.3 62.5C419.5 217.5 372.7 192 320 192c-31.5 0-60.9 9.1-85.7 24.9c-9.6-5.8-19.8-10.6-30.5-14.5C224 158.5 268.4 128 320 128c31.3 0 60.1 11.3 82.3 30c22.4-37.1 63.1-62 109.7-62c70.7 0 128 57.3 128 128c0 42.2-20.4 79.6-51.9 102.9C563.1 284.5 516.9 256 464 256c-5.2 0-10.3 .3-15.4 .8zM144 512C64.5 512 0 447.5 0 368s64.5-144 144-144c34.5 0 66.1 12.1 90.9 32.3C257.6 236.2 287.4 224 320 224c49.1 0 91.8 27.7 113.2 68.3c9.8-2.8 20.1-4.3 30.8-4.3c61.9 0 112 50.1 112 112s-50.1 112-112 112l-320 0z"]
}, faSterlingSign = {
  prefix: "fas",
  iconName: "sterling-sign",
  icon: [320, 512, [163, "gbp", "pound-sign"], "f154", "M112 160.4c0-35.5 28.8-64.4 64.4-64.4c6.9 0 13.8 1.1 20.4 3.3l81.2 27.1c16.8 5.6 34.9-3.5 40.5-20.2s-3.5-34.9-20.2-40.5L217 38.6c-13.1-4.4-26.8-6.6-40.6-6.6C105.5 32 48 89.5 48 160.4L48 224l-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l16 0 0 44.5c0 17.4-4.7 34.5-13.7 49.4L4.6 431.5c-5.9 9.9-6.1 22.2-.4 32.2S20.5 480 32 480l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L88.5 416l.7-1.1C104.1 390 112 361.5 112 332.5l0-44.5 112 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-112 0 0-63.6z"]
}, faGbp = faSterlingSign, faPoundSign = faSterlingSign, faBatteryExclamation = {
  prefix: "fas",
  iconName: "battery-exclamation",
  icon: [576, 512, [], "e0b0", "M208 96l0 64L80 160c-8.8 0-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16l118.7 0c-4.3 9.8-6.7 20.6-6.7 32s2.4 22.2 6.7 32L80 416c-44.2 0-80-35.8-80-80L0 176c0-44.2 35.8-80 80-80l128 0zM464 416l-118.7 0c4.3-9.8 6.7-20.6 6.7-32s-2.4-22.2-6.7-32L464 352c8.8 0 16-7.2 16-16l0-160c0-8.8-7.2-16-16-16l-128 0 0-64 128 0c44.2 0 80 35.8 80 80l0 16c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l0 16c0 44.2-35.8 80-80 80zM272 96c13.3 0 24 10.7 24 24l0 176c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-13.3 10.7-24 24-24zM240 384a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faViruses = {
  prefix: "fas",
  iconName: "viruses",
  icon: [640, 512, [], "e076", "M192 0c13.3 0 24 10.7 24 24l0 13.5c0 35.6 43.1 53.5 68.3 28.3l9.5-9.5c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-9.5 9.5C293 124.9 310.9 168 346.5 168l13.5 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-13.5 0c-35.6 0-53.5 43.1-28.3 68.3l9.5 9.5c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-9.5-9.5C259.1 293 216 310.9 216 346.5l0 13.5c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-13.5c0-35.6-43.1-53.5-68.3-28.3l-9.5 9.5c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l9.5-9.5C91 259.1 73.1 216 37.5 216L24 216c-13.3 0-24-10.7-24-24s10.7-24 24-24l13.5 0c35.6 0 53.5-43.1 28.3-68.3l-9.5-9.5c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l9.5 9.5C124.9 91 168 73.1 168 37.5L168 24c0-13.3 10.7-24 24-24zm48 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-48-64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm320 80c0 33 39.9 49.5 63.2 26.2c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6C574.5 312.1 591 352 624 352c8.8 0 16 7.2 16 16s-7.2 16-16 16c-33 0-49.5 39.9-26.2 63.2c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0C551.9 446.5 512 463 512 496c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-33-39.9-49.5-63.2-26.2c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6C417.5 423.9 401 384 368 384c-8.8 0-16-7.2-16-16s7.2-16 16-16c33 0 49.5-39.9 26.2-63.2c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0C440.1 289.5 480 273 480 240c0-8.8 7.2-16 16-16s16 7.2 16 16zm0 112a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faSquarePersonConfined = {
  prefix: "fas",
  iconName: "square-person-confined",
  icon: [448, 512, [], "e577", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm96 112a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm80 104c0-30.9 25.1-56 56-56s56 25.1 56 56l0 102.1c0 36.4-29.5 65.9-65.9 65.9c-17.5 0-34.3-6.9-46.6-19.3L184.8 342l-28.1 56.3c-7.9 15.8-27.1 22.2-42.9 14.3s-22.2-27.1-14.3-42.9l48-96c4.6-9.2 13.3-15.6 23.5-17.3s20.5 1.7 27.8 9L240 306.7l0-58.7z"]
}, faUserTie = {
  prefix: "fas",
  iconName: "user-tie",
  icon: [448, 512, [], "f508", "M96 128a128 128 0 1 0 256 0A128 128 0 1 0 96 128zm94.5 200.2l18.6 31L175.8 483.1l-36-146.9c-2-8.1-9.8-13.4-17.9-11.3C51.9 342.4 0 405.8 0 481.3c0 17 13.8 30.7 30.7 30.7l131.7 0c0 0 0 0 .1 0l5.5 0 112 0 5.5 0c0 0 0 0 .1 0l131.7 0c17 0 30.7-13.8 30.7-30.7c0-75.5-51.9-138.9-121.9-156.4c-8.1-2-15.9 3.3-17.9 11.3l-36 146.9L238.9 359.2l18.6-31c6.4-10.7-1.3-24.2-13.7-24.2L224 304l-19.7 0c-12.4 0-20.1 13.6-13.7 24.2z"]
}, faUpToBracket = {
  prefix: "fas",
  iconName: "up-to-bracket",
  icon: [448, 512, [], "e66e", "M374.1 294.1L251.3 171.3c-7.2-7.2-17.1-11.3-27.3-11.3s-20.1 4.1-27.3 11.3L73.9 294.1c-6.4 6.4-9.9 15-9.9 24C64 336.8 79.2 352 97.9 352l62.1 0 0 128c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-128 62.1 0c18.7 0 33.9-15.2 33.9-33.9c0-9-3.6-17.6-9.9-24zM64 160l0-64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-53-43-96-96-96L96 0C43 0 0 43 0 96l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32z"]
}, faArrowDownLong = {
  prefix: "fas",
  iconName: "arrow-down-long",
  icon: [384, 512, ["long-arrow-down"], "f175", "M169.4 502.6c12.5 12.5 32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 402.7 224 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 370.7L86.6 329.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128z"]
}, faLongArrowDown = faArrowDownLong, faTentArrowDownToLine = {
  prefix: "fas",
  iconName: "tent-arrow-down-to-line",
  icon: [640, 512, [], "e57e", "M241.8 111.9c8.9 9.9 8.1 25-1.8 33.9l-80 72c-9.1 8.2-23 8.2-32.1 0l-80-72c-9.9-8.9-10.7-24-1.8-33.9s24-10.7 33.9-1.8l39.9 36L120 24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 122.1 39.9-36c9.9-8.9 25-8.1 33.9 1.8zm122.8 22.6c11.5-8.7 27.3-8.7 38.8 0l168 128c6.6 5 11 12.5 12.3 20.7l24 160 .7 4.7c17.5 .2 31.6 14.4 31.6 32c0 17.7-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l127.6 0 .7-4.7 24-160c1.2-8.2 5.6-15.7 12.3-20.7l168-128zM384 448l80 0L402.7 325.5c-1.7-3.4-5.1-5.5-8.8-5.5c-5.5 0-9.9 4.4-9.9 9.9L384 448z"]
}, faCertificate = {
  prefix: "fas",
  iconName: "certificate",
  icon: [512, 512, [], "f0a3", "M211 7.3C205 1 196-1.4 187.6 .8s-14.9 8.9-17.1 17.3L154.7 80.6l-62-17.5c-8.4-2.4-17.4 0-23.5 6.1s-8.5 15.1-6.1 23.5l17.5 62L18.1 170.6c-8.4 2.1-15 8.7-17.3 17.1S1 205 7.3 211l46.2 45L7.3 301C1 307-1.4 316 .8 324.4s8.9 14.9 17.3 17.1l62.5 15.8-17.5 62c-2.4 8.4 0 17.4 6.1 23.5s15.1 8.5 23.5 6.1l62-17.5 15.8 62.5c2.1 8.4 8.7 15 17.1 17.3s17.3-.2 23.4-6.4l45-46.2 45 46.2c6.1 6.2 15 8.7 23.4 6.4s14.9-8.9 17.1-17.3l15.8-62.5 62 17.5c8.4 2.4 17.4 0 23.5-6.1s8.5-15.1 6.1-23.5l-17.5-62 62.5-15.8c8.4-2.1 15-8.7 17.3-17.1s-.2-17.4-6.4-23.4l-46.2-45 46.2-45c6.2-6.1 8.7-15 6.4-23.4s-8.9-14.9-17.3-17.1l-62.5-15.8 17.5-62c2.4-8.4 0-17.4-6.1-23.5s-15.1-8.5-23.5-6.1l-62 17.5L341.4 18.1c-2.1-8.4-8.7-15-17.1-17.3S307 1 301 7.3L256 53.5 211 7.3z"]
}, faCrystalBall = {
  prefix: "fas",
  iconName: "crystal-ball",
  icon: [448, 512, [], "e362", "M448 224c0 62.7-25.7 119.3-67.2 160L67.2 384C25.7 343.3 0 286.7 0 224C0 100.3 100.3 0 224 0S448 100.3 448 224zM152.5 84.3l-9.8 26.4-26.4 9.8c-7 2.6-7 12.4 0 15l26.4 9.8 9.8 26.4c2.6 7 12.4 7 15 0l9.8-26.4 26.4-9.8c7-2.6 7-12.4 0-15l-26.4-9.8-9.8-26.4c-2.6-7-12.4-7-15 0zm159 48c-2.6-7-12.4-7-15 0l-18.4 49.8-49.8 18.4c-7 2.6-7 12.4 0 15l49.8 18.4 18.4 49.8c2.6 7 12.4 7 15 0l18.4-49.8 49.8-18.4c7-2.6 7-12.4 0-15l-49.8-18.4-18.4-49.8zm98.9 331.8c3.7 5.1 5.6 11.3 5.6 17.6c0 16.7-13.6 30.3-30.3 30.3L62.3 512C45.6 512 32 498.4 32 481.7c0-6.3 2-12.5 5.6-17.6L72 416l304 0 34.4 48.1z"]
}, faReplyAll = {
  prefix: "fas",
  iconName: "reply-all",
  icon: [576, 512, ["mail-reply-all"], "f122", "M209.4 39.5c-9.1-9.6-24.3-10-33.9-.9L33.8 173.2c-19.9 18.9-19.9 50.7 0 69.6L175.5 377.4c9.6 9.1 24.8 8.7 33.9-.9s8.7-24.8-.9-33.9L66.8 208 208.5 73.4c9.6-9.1 10-24.3 .9-33.9zM352 64c0-12.6-7.4-24.1-19-29.2s-25-3-34.4 5.4l-160 144c-6.7 6.1-10.6 14.7-10.6 23.8s3.9 17.7 10.6 23.8l160 144c9.4 8.5 22.9 10.6 34.4 5.4s19-16.6 19-29.2l0-64 32 0c53 0 96 43 96 96c0 30.4-12.8 47.9-22.2 56.7c-5.5 5.1-9.8 12-9.8 19.5c0 10.9 8.8 19.7 19.7 19.7c2.8 0 5.6-.6 8.1-1.9C494.5 467.9 576 417.3 576 304c0-97.2-78.8-176-176-176l-48 0 0-64z"]
}, faMailReplyAll = faReplyAll, faSuitcase = {
  prefix: "fas",
  iconName: "suitcase",
  icon: [512, 512, [129523], "f0f2", "M176 56l0 40 160 0 0-40c0-4.4-3.6-8-8-8L184 48c-4.4 0-8 3.6-8 8zM128 96l0-40c0-30.9 25.1-56 56-56L328 0c30.9 0 56 25.1 56 56l0 40 0 32 0 352-256 0 0-352 0-32zM64 96l32 0 0 384-32 0c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64zM448 480l-32 0 0-384 32 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64z"]
}, faPersonSkating = {
  prefix: "fas",
  iconName: "person-skating",
  icon: [448, 512, ["skating"], "f7c5", "M352 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM128 128c0-17.7 14.3-32 32-32l159.4 0c43.6 0 64.6 53.4 32.8 83.1l-74.4 69.4 60.2 60.2c9 9 14.1 21.2 14.1 33.9l0 73.4c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-66.7-77.9-77.8c-26.6-26.6-24.6-70.3 4.3-94.4l20.4-17L160 160c-17.7 0-32-14.3-32-32zM81.4 353.4l86.9-86.9c4.6 10 11 19.3 19.3 27.5l21.8 21.8-82.7 82.7c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3zm322.5 95.1c8.6 2.1 13.8 10.8 11.6 19.4l-.4 1.7c-6.2 24.9-28.6 42.4-54.3 42.4L272 512c-8.8 0-16-7.2-16-16s7.2-16 16-16l88.8 0c11 0 20.6-7.5 23.3-18.2l.4-1.7c2.1-8.6 10.8-13.8 19.4-11.6zM135.2 478.3l-6.2 3.1c-21.6 10.8-47.6 6.6-64.6-10.5L4.7 411.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l59.6 59.6c7.3 7.3 18.5 9.1 27.7 4.5l6.2-3.1c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5z"]
}, faSkating = faPersonSkating, faStarShooting = {
  prefix: "fas",
  iconName: "star-shooting",
  icon: [512, 512, [127776], "e036", "M313 41L265 89c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L279 7c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zM170.4 157.4c8.8-17.9 34.3-17.9 43.1 0l46.3 94 103.5 15.1c19.7 2.9 27.5 27 13.3 40.9l-74.9 73.2 17.7 103.3c3.4 19.6-17.2 34.6-34.8 25.3l-92.6-48.8L99.3 509.2c-17.6 9.3-38.2-5.7-34.8-25.3L82.2 380.6 7.2 307.4C-7 293.5 .9 269.3 20.5 266.5l103.5-15.1 46.3-94zM505 199c9.4 9.4 9.4 24.6 0 33.9l-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l48-48c9.4-9.4 24.6-9.4 33.9 0zM505 41L361 185c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L471 7c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]
}, faBinaryLock = {
  prefix: "fas",
  iconName: "binary-lock",
  icon: [640, 512, [], "e33d", "M322.7 6c-8.3-6-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 83.6-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l48 0 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128c0-10.3-4.9-19.9-13.3-26zM98.7 294c-8.3-6-19.1-7.7-28.8-4.4l-48 16C5.1 311.2-3.9 329.4 1.7 346.1s23.7 25.8 40.5 20.2l5.9-2L48 448l-16 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l48 0 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128c0-10.3-4.9-19.9-13.3-26zM64 0C28.7 0 0 28.7 0 64l0 96c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64L64 0zm0 64l64 0 0 96-64 0 0-96zM192 352l0 96c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64l-64 0c-35.3 0-64 28.7-64 64zm128 0l0 96-64 0 0-96 64 0zM528 240c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]
}, faFilterCircleDollar = {
  prefix: "fas",
  iconName: "filter-circle-dollar",
  icon: [576, 512, ["funnel-dollar"], "f662", "M3.9 22.9C10.5 8.9 24.5 0 40 0L472 0c15.5 0 29.5 8.9 36.1 22.9s4.6 30.5-5.2 42.5L396.4 195.6C316.2 212.1 256 283 256 368c0 27.4 6.3 53.4 17.5 76.5c-1.6-.8-3.2-1.8-4.7-2.9l-64-48c-8.1-6-12.8-15.5-12.8-25.6l0-79.1L9 65.3C-.7 53.4-2.8 36.8 3.9 22.9zM288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm120.8-32.6c.6-.9 1.8-2.1 4.2-3.4c5.1-2.7 12.5-4.1 18.7-4c8.2 .1 17.1 1.8 26.4 4.1c8.6 2.1 17.3-3.1 19.4-11.7s-3.1-17.3-11.7-19.4c-5.6-1.4-11.6-2.7-17.9-3.7l0-9.4c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 9.5c-6.1 1.2-12.3 3.2-18 6.3c-11.8 6.3-23 18.4-21.8 37.2c1 16 11.7 25.3 21.6 30.7c8.8 4.7 19.7 7.8 28.6 10.3l1.8 .5c10.3 2.9 17.9 5.2 23.2 8.3c4.5 2.7 4.7 4.2 4.7 5.6c.1 2.4-.5 3.7-1 4.5c-.6 1-1.8 2.2-4 3.3c-4.7 2.5-11.8 3.8-18.5 3.6c-9.5-.3-18.5-3.1-29.9-6.8c-1.9-.6-3.8-1.2-5.8-1.8c-8.4-2.6-17.4 2.1-20 10.5s2.1 17.4 10.5 20c1.6 .5 3.3 1 5 1.6c0 0 0 0 0 0s0 0 0 0c7 2.3 15.1 4.8 23.7 6.6l0 11.4c0 8.8 7.2 16 16 16s16-7.2 16-16l0-10.8c6.2-1.1 12.5-3.1 18.3-6.2c12.1-6.5 22.3-18.7 21.7-36.9c-.5-16.2-10.3-26.3-20.5-32.3c-9.4-5.6-21.2-8.9-30.5-11.5l-.2 0c-10.4-2.9-18.3-5.2-23.9-8.2c-4.8-2.6-4.8-4-4.8-4.5c0 0 0 0 0-.1c-.1-1.9 .3-2.9 .8-3.6z"]
}, faFunnelDollar = faFilterCircleDollar, faCameraRetro = {
  prefix: "fas",
  iconName: "camera-retro",
  icon: [512, 512, [128247], "f083", "M220.6 121.2L271.1 96 448 96l0 96-114.8 0c-21.9-15.1-48.5-24-77.2-24s-55.2 8.9-77.2 24L64 192l0-64 128 0c9.9 0 19.7-2.3 28.6-6.8zM0 128L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L271.1 32c-9.9 0-19.7 2.3-28.6 6.8L192 64l-32 0 0-16c0-8.8-7.2-16-16-16L80 32c-8.8 0-16 7.2-16 16l0 16C28.7 64 0 92.7 0 128zM168 304a88 88 0 1 1 176 0 88 88 0 1 1 -176 0z"]
}, faCircleArrowDown = {
  prefix: "fas",
  iconName: "circle-arrow-down",
  icon: [512, 512, ["arrow-circle-down"], "f0ab", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM127 297c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l71 71L232 120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 214.1 71-71c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L273 409c-9.4 9.4-24.6 9.4-33.9 0L127 297z"]
}, faArrowCircleDown = faCircleArrowDown, faCommentPen = {
  prefix: "fas",
  iconName: "comment-pen",
  icon: [512, 512, ["comment-edit"], "f4ae", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zm84.8-293c14.7 14.7 14.7 38.6 0 53.3l-14.9 14.9L272.6 170 287.5 155c14.7-14.7 38.6-14.7 53.3 0zM178.1 264.5L250 192.6l53.3 53.3-71.9 71.9c-4.1 4.1-9.2 7-14.9 8.4l-36.6 9.2c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l9.2-36.7c1.4-5.6 4.3-10.8 8.4-14.9z"]
}, faCommentEdit = faCommentPen, faFileImport = {
  prefix: "fas",
  iconName: "file-import",
  icon: [512, 512, ["arrow-right-to-file"], "f56f", "M128 64c0-35.3 28.7-64 64-64L352 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64l-256 0c-35.3 0-64-28.7-64-64l0-112 174.1 0-39 39c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l39 39L128 288l0-224zm0 224l0 48L24 336c-13.3 0-24-10.7-24-24s10.7-24 24-24l104 0zM512 128l-128 0L384 0 512 128z"]
}, faArrowRightToFile = faFileImport, faBanjo = {
  prefix: "fas",
  iconName: "banjo",
  icon: [512, 512, [129685], "f8a3", "M465 7c-9.4-9.4-24.6-9.4-33.9 0L383 55c-2.4 2.4-4.3 5.3-5.5 8.5l-15.4 41L286 180.7c-20.6-13.9-44.3-23.4-70-27l0-1.7c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 1.7c-28.5 4.1-54.6 15.3-76.6 31.7l-1.2-1.2c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l1.2 1.2C41 241.4 29.8 267.5 25.7 296L24 296c-13.3 0-24 10.7-24 24s10.7 24 24 24l1.7 0c4.1 28.5 15.3 54.6 31.7 76.6l-1.2 1.2c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l1.2-1.2c22 16.5 48.2 27.7 76.6 31.7l0 1.7c0 13.3 10.7 24 24 24s24-10.7 24-24l0-1.7c28.5-4.1 54.6-15.3 76.6-31.7l1.2 1.2c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-1.2-1.2c16.5-22 27.7-48.2 31.7-76.6l1.7 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-1.7 0c-3.7-25.7-13.1-49.5-27-70l76.1-76.1 41-15.4c3.2-1.2 6.1-3.1 8.5-5.5l48-48c9.4-9.4 9.4-24.6 0-33.9L465 7zM192 208a112 112 0 1 1 0 224 112 112 0 1 1 0-224zM155.3 308.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l48 48c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-48-48z"]
}, faSquareArrowUpRight = {
  prefix: "fas",
  iconName: "square-arrow-up-right",
  icon: [448, 512, ["external-link-square"], "f14c", "M384 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0zM160 144c-13.3 0-24 10.7-24 24s10.7 24 24 24l94.1 0L119 327c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l135-135L288 328c0 13.3 10.7 24 24 24s24-10.7 24-24l0-160c0-13.3-10.7-24-24-24l-152 0z"]
}, faExternalLinkSquare = faSquareArrowUpRight, faLightEmergencyOn = {
  prefix: "fas",
  iconName: "light-emergency-on",
  icon: [640, 512, [], "e420", "M69.3 36c-11-7.4-25.9-4.4-33.3 6.7s-4.4 25.9 6.7 33.3l48 32c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3l-48-32zM597.3 76c11-7.4 14-22.3 6.7-33.3s-22.3-14-33.3-6.7l-48 32c-11 7.4-14 22.3-6.7 33.3s22.3 14 33.3 6.7l48-32zM24 192c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zm528 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zM320 32c-88.4 0-160 71.6-160 160l0 160 320 0 0-160c0-88.4-71.6-160-160-160zM240 192c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-61.9 50.1-112 112-112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.2 0-80 35.8-80 80zM96 416l0 32c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-384 0c-17.7 0-32 14.3-32 32z"]
}, faKerning = {
  prefix: "fas",
  iconName: "kerning",
  icon: [640, 512, [], "f86f", "M454.3 23.2c4-7.9 .7-17.5-7.2-21.5s-17.5-.7-21.5 7.2l-240 480c-4 7.9-.7 17.5 7.2 21.5s17.5 .7 21.5-7.2l240-480zM60.6 113.7C52.7 97.9 33.5 91.5 17.7 99.4S-4.5 126.5 3.4 142.3l128 256c5.4 10.8 16.5 17.7 28.6 17.7s23.2-6.8 28.6-17.7l128-256c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3L160 312.4 60.6 113.7zm320 284.6L403.8 352l152.4 0 23.2 46.3c7.9 15.8 27.1 22.2 42.9 14.3s22.2-27.1 14.3-42.9l-128-256C503.2 102.9 492.1 96 480 96s-23.2 6.8-28.6 17.7l-128 256c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3zM480 199.6L524.2 288l-88.4 0L480 199.6z"]
}, faBoxOpen = {
  prefix: "fas",
  iconName: "box-open",
  icon: [640, 512, [], "f49e", "M58.9 42.1c3-6.1 9.6-9.6 16.3-8.7L320 64 564.8 33.4c6.7-.8 13.3 2.7 16.3 8.7l41.7 83.4c9 17.9-.6 39.6-19.8 45.1L439.6 217.3c-13.9 4-28.8-1.9-36.2-14.3L320 64 236.6 203c-7.4 12.4-22.3 18.3-36.2 14.3L37.1 170.6c-19.3-5.5-28.8-27.2-19.8-45.1L58.9 42.1zM321.1 128l54.9 91.4c14.9 24.8 44.6 36.6 72.5 28.6L576 211.6l0 167c0 22-15 41.2-36.4 46.6l-204.1 51c-10.2 2.6-20.9 2.6-31 0l-204.1-51C79 419.7 64 400.5 64 378.5l0-167L191.6 248c27.8 8 57.6-3.8 72.5-28.6L318.9 128l2.2 0z"]
}, faSquareF = {
  prefix: "fas",
  iconName: "square-f",
  icon: [448, 512, [], "e270", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm88 96l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 64 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96 0-112c0-13.3 10.7-24 24-24z"]
}, faScroll = {
  prefix: "fas",
  iconName: "scroll",
  icon: [576, 512, [128220], "f70e", "M0 80l0 48c0 17.7 14.3 32 32 32l16 0 48 0 0-80c0-26.5-21.5-48-48-48S0 53.5 0 80zM112 32c10 13.4 16 30 16 48l0 304c0 35.3 28.7 64 64 64s64-28.7 64-64l0-5.3c0-32.4 26.3-58.7 58.7-58.7L480 320l0-192c0-53-43-96-96-96L112 32zM464 480c61.9 0 112-50.1 112-112c0-8.8-7.2-16-16-16l-245.3 0c-14.7 0-26.7 11.9-26.7 26.7l0 5.3c0 53-43 96-96 96l176 0 96 0z"]
}, faSpa = {
  prefix: "fas",
  iconName: "spa",
  icon: [576, 512, [], "f5bb", "M183.1 235.3c33.7 20.7 62.9 48.1 85.8 80.5c7 9.9 13.4 20.3 19.1 31c5.7-10.8 12.1-21.1 19.1-31c22.9-32.4 52.1-59.8 85.8-80.5C437.6 207.8 490.1 192 546 192l9.9 0c11.1 0 20.1 9 20.1 20.1C576 360.1 456.1 480 308.1 480L288 480l-20.1 0C119.9 480 0 360.1 0 212.1C0 201 9 192 20.1 192l9.9 0c55.9 0 108.4 15.8 153.1 43.3zM301.5 37.6c15.7 16.9 61.1 71.8 84.4 164.6c-38 21.6-71.4 50.8-97.9 85.6c-26.5-34.8-59.9-63.9-97.9-85.6c23.2-92.8 68.6-147.7 84.4-164.6C278 33.9 282.9 32 288 32s10 1.9 13.5 5.6z"]
}, faArrowLeftFromLine = {
  prefix: "fas",
  iconName: "arrow-left-from-line",
  icon: [448, 512, [8612, "arrow-from-right"], "f344", "M384 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-320zM9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L109.3 224 288 224c17.7 0 32 14.3 32 32s-14.3 32-32 32l-178.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-128-128z"]
}, faArrowFromRight = faArrowLeftFromLine, faStrawberry = {
  prefix: "fas",
  iconName: "strawberry",
  icon: [512, 512, [], "e32b", "M481.5 1.9c12.2 5.2 17.8 19.3 12.6 31.5c-13.4 31.2-36.9 59-56.3 78.7c32.8 1.8 57.4 18 68.2 26.6c4 3.2 6 8.1 6 13.2s-2 10-6 13.3C495 174.4 469.7 192 440 192c-40 0-55.3-15.3-80-40s-40-40-40-80c0-29.7 17.6-55 26.7-66c3.3-4 8.2-6 13.3-6s10 2 13.2 6C382.3 17.4 400 44.3 400 80c0 .7 0 1.4 0 2.1c.7-.7 1.4-1.3 2-2c18.2-18.2 37.7-41.7 47.9-65.5c5.2-12.2 19.3-17.8 31.5-12.6zM0 336C0 160 96.2 64 192.2 64c32.7 .1 65.3 12.6 90.3 37.5l128 128c25 25 37.5 57.8 37.5 90.5c0 96-96 192-272 192C48 512 0 464 0 336zM172.8 172.8c11.9-11.9 14.6-28.3 8.7-34.3s-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3s22.4 3.2 34.3-8.7zm72.7 29.7c-5.9-5.9-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3s22.4 3.2 34.3-8.7s14.6-28.3 8.7-34.3zm-32 96c-5.9-5.9-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3s22.4 3.2 34.3-8.7s14.6-28.3 8.7-34.3zm-32 96c-5.9-5.9-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3s22.4 3.2 34.3-8.7s14.6-28.3 8.7-34.3zm87.3 2.3c11.9-11.9 14.6-28.3 8.7-34.3s-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3s22.4 3.2 34.3-8.7zm32-96c11.9-11.9 14.6-28.3 8.7-34.3s-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3s22.4 3.2 34.3-8.7zm72.7 29.7c-5.9-5.9-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3s22.4 3.2 34.3-8.7s14.6-28.3 8.7-34.3zm-224-96c-5.9-5.9-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3s22.4 3.2 34.3-8.7s14.6-28.3 8.7-34.3zM108.8 364.8c11.9-11.9 14.6-28.3 8.7-34.3s-22.4-3.2-34.3 8.7s-14.6 28.3-8.7 34.3s22.4 3.2 34.3-8.7z"]
}, faLocationPinLock = {
  prefix: "fas",
  iconName: "location-pin-lock",
  icon: [512, 512, [], "e51f", "M215.7 499.2c11-13.8 25.1-31.7 40.3-52.3l0-94.8c0-23.7 12.9-44.4 32-55.4l0-24.6c0-55.6 40.5-101.7 93.6-110.5C367 70 287.7 0 192 0C86 0 0 86 0 192c0 87.4 117 243 168.3 307.2c12.3 15.3 35.1 15.3 47.4 0zM192 128a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM400 240c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]
}, faPause = {
  prefix: "fas",
  iconName: "pause",
  icon: [320, 512, [9208], "f04c", "M48 64C21.5 64 0 85.5 0 112L0 400c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48L48 64zm192 0c-26.5 0-48 21.5-48 48l0 288c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-32 0z"]
}, faClockEightThirty = {
  prefix: "fas",
  iconName: "clock-eight-thirty",
  icon: [512, 512, [], "e346", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392l0-91.2L173.3 340c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l96-64c7.4-4.9 16.8-5.4 24.6-1.2S280 247.1 280 256l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]
}, faPlaneEngines = {
  prefix: "fas",
  iconName: "plane-engines",
  icon: [576, 512, [9992, "plane-alt"], "f3de", "M576 256c0-35-59.5-64-93.7-64l-116.6 0-37.2-65.1C342 123.1 352 110.7 352 96c0-17.7-14.3-32-32-32l-27.4 0L265.2 16.1C259.5 6.2 248.9 0 237.4 0L181.2 0c-10.6 0-18.3 10.2-15.4 20.4l49 171.6L112 192 68.8 134.4c-3-4-7.8-6.4-12.8-6.4l-42 0c-7.8 0-14 6.3-14 14c0 1.3 .2 2.6 .5 3.9l22.7 79.3C9.8 229 0 241.4 0 256s9.8 27 23.2 30.8L.5 366.1c-.4 1.3-.5 2.6-.5 3.9c0 7.8 6.3 14 14 14l42 0c5 0 9.8-2.4 12.8-6.4L112 320l102.9 0-49 171.6c-2.9 10.2 4.8 20.4 15.4 20.4l56.2 0c11.5 0 22.1-6.2 27.8-16.1L292.6 448l27.4 0c17.7 0 32-14.3 32-32c0-14.7-10-27.1-23.5-30.9L365.7 320l116.6 0c34.2 0 93.7-28 93.7-64z"]
}, faPlaneAlt = faPlaneEngines, faHillAvalanche = {
  prefix: "fas",
  iconName: "hill-avalanche",
  icon: [576, 512, [], "e507", "M439.7 401.9c34.2 23.1 81.1 19.5 111.4-10.8c34.4-34.4 34.4-90.1 0-124.4c-27.8-27.8-69.5-33.1-102.6-16c-11.8 6.1-16.4 20.6-10.3 32.3s20.6 16.4 32.3 10.3c15.1-7.8 34-5.3 46.6 7.3c15.6 15.6 15.6 40.9 0 56.6s-40.9 15.6-56.6 0l-81.7-81.7C401.2 261.3 416 236.4 416 208c0-33.9-21.1-62.9-50.9-74.5c1.9-6.8 2.9-14 2.9-21.5c0-44.2-35.8-80-80-80c-27.3 0-51.5 13.7-65.9 34.6C216.3 46.6 197.9 32 176 32c-26.5 0-48 21.5-48 48c0 4 .5 7.9 1.4 11.6L439.7 401.9zM480 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM68.3 87C43.1 61.8 0 79.7 0 115.3L0 432c0 44.2 35.8 80 80 80l316.7 0c35.6 0 53.5-43.1 28.3-68.3L68.3 87z"]
}, faTemperatureEmpty = {
  prefix: "fas",
  iconName: "temperature-empty",
  icon: [320, 512, ["temperature-0", "thermometer-0", "thermometer-empty"], "f2cb", "M112 112c0-26.5 21.5-48 48-48s48 21.5 48 48l0 164.5c0 17.3 7.1 31.9 15.3 42.5C233.8 332.6 240 349.5 240 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-18.5 6.2-35.4 16.7-48.9c8.2-10.6 15.3-25.2 15.3-42.5L112 112zM160 0C98.1 0 48 50.2 48 112l0 164.4c0 .1-.1 .3-.2 .6c-.2 .6-.8 1.6-1.7 2.8C27.2 304.2 16 334.8 16 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-33.2-11.2-63.8-30.1-88.1c-.9-1.2-1.5-2.2-1.7-2.8c-.1-.3-.2-.5-.2-.6L272 112C272 50.2 221.9 0 160 0zm0 416a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]
}, faTemperature0 = faTemperatureEmpty, faThermometer0 = faTemperatureEmpty, faThermometerEmpty = faTemperatureEmpty, faBomb = {
  prefix: "fas",
  iconName: "bomb",
  icon: [512, 512, [128163], "f1e2", "M459.1 52.4L442.6 6.5C440.7 2.6 436.5 0 432.1 0s-8.5 2.6-10.4 6.5L405.2 52.4l-46 16.8c-4.3 1.6-7.3 5.9-7.2 10.4c0 4.5 3 8.7 7.2 10.2l45.7 16.8 16.8 45.8c1.5 4.4 5.8 7.5 10.4 7.5s8.9-3.1 10.4-7.5l16.5-45.8 45.7-16.8c4.2-1.5 7.2-5.7 7.2-10.2c0-4.6-3-8.9-7.2-10.4L459.1 52.4zm-132.4 53c-12.5-12.5-32.8-12.5-45.3 0l-2.9 2.9C256.5 100.3 232.7 96 208 96C93.1 96 0 189.1 0 304S93.1 512 208 512s208-93.1 208-208c0-24.7-4.3-48.5-12.2-70.5l2.9-2.9c12.5-12.5 12.5-32.8 0-45.3l-80-80zM200 192c-57.4 0-104 46.6-104 104l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-75.1 60.9-136 136-136l8 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-8 0z"]
}, faGaugeLow = {
  prefix: "fas",
  iconName: "gauge-low",
  icon: [512, 512, ["tachometer-alt-slow"], "f627", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM256 416c35.3 0 64-28.7 64-64s-28.7-64-64-64c-.6 0-1.3 0-1.9 0L190 142.3c-5.3-12.1-19.5-17.6-31.6-12.3s-17.6 19.5-12.3 31.6l64.1 145.7C198.9 318.9 192 334.6 192 352c0 35.3 28.7 64 64 64zM128 256a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm288 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM400 144a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faTachometerAltSlow = faGaugeLow, faRegistered = {
  prefix: "fas",
  iconName: "registered",
  icon: [512, 512, [174], "f25d", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM160 152c0-13.3 10.7-24 24-24l88 0c44.2 0 80 35.8 80 80c0 28-14.4 52.7-36.3 67l34.1 75.1c5.5 12.1 .1 26.3-11.9 31.8s-26.3 .1-31.8-11.9L268.9 288 208 288l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96 0-112zm48 88l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0 64z"]
}, faTrashCanPlus = {
  prefix: "fas",
  iconName: "trash-can-plus",
  icon: [448, 512, [], "e2ac", "M163.8 0L284.2 0c12.1 0 23.2 6.8 28.6 17.7L320 32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 7.2-14.3C140.6 6.8 151.7 0 163.8 0zM32 128l384 0 0 320c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-320zM200 408c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 64z"]
}, faAddressCard = {
  prefix: "fas",
  iconName: "address-card",
  icon: [576, 512, [62140, "contact-card", "vcard"], "f2bb", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 256l64 0c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16L80 384c-8.8 0-16-7.2-16-16c0-44.2 35.8-80 80-80zm-32-96a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm256-32l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faContactCard = faAddressCard, faVcard = faAddressCard, faChartFft = {
  prefix: "fas",
  iconName: "chart-fft",
  icon: [512, 512, [], "e69e", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zM284.6 81.7c-5.7-11.5-17.8-18.4-30.6-17.6s-23.9 9.1-28.2 21.2L153.4 288 128 288c-17.7 0-32 14.3-32 32s14.3 32 32 32l48 0c13.5 0 25.6-8.5 30.1-21.2l54.8-153.4 30.5 60.9c5.4 10.8 16.5 17.7 28.6 17.7l60.2 0 39.2 78.3c7.9 15.8 27.1 22.2 42.9 14.3s22.2-27.1 14.3-42.9l-48-96C423.2 198.8 412.1 192 400 192l-60.2 0L284.6 81.7z"]
}, faScaleUnbalancedFlip = {
  prefix: "fas",
  iconName: "scale-unbalanced-flip",
  icon: [640, 512, ["balance-scale-right"], "f516", "M117.9 62.4c-16.8-5.6-25.8-23.7-20.2-40.5s23.7-25.8 40.5-20.2l113 37.7C265 15.8 290.7 0 320 0c44.2 0 80 35.8 80 80c0 3-.2 5.9-.5 8.8l122.6 40.9c16.8 5.6 25.8 23.7 20.2 40.5s-23.7 25.8-40.5 20.2L366.4 145.2c-4.5 3.2-9.3 5.9-14.4 8.2L352 480c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0 0-294.7c-21-9.2-37.2-27-44.2-49l-125.9-42zM200.4 288L128 163.8 55.6 288l144.9 0zM128 384C65.1 384 12.8 350 2 305.1c-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1C243.2 350 190.9 384 128 384zm382.8-92.2L438.4 416l144.9 0L510.8 291.8zm126 141.3C626 478 573.7 512 510.8 512s-115.2-34-126-78.9c-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1z"]
}, faBalanceScaleRight = faScaleUnbalancedFlip, faGlobeSnow = {
  prefix: "fas",
  iconName: "globe-snow",
  icon: [448, 512, [], "f7a3", "M448 224c0 62.7-25.7 119.3-67.2 160L256 384l0-32 64 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4L262.6 256l25.4 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4l-64-64c-6.2-6.2-16.4-6.2-22.6 0l-64 64c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9l25.4 0-68.7 68.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9l64 0 0 32L67.2 384C25.7 343.3 0 286.7 0 224C0 100.3 100.3 0 224 0S448 100.3 448 224zM256 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 112a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM20.3 474.2L61.1 416l325.8 0 40.8 58.2c5.1 7.3 5.8 16.9 1.6 24.8S416.9 512 408 512L40 512c-8.9 0-17.2-5-21.3-12.9s-3.5-17.5 1.6-24.8z"]
}, faSubscript = {
  prefix: "fas",
  iconName: "subscript",
  icon: [512, 512, [], "f12c", "M32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l15.3 0 89.6 128L47.3 384 32 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0c10.4 0 20.2-5.1 26.2-13.6L176 311.8l85.8 122.6c6 8.6 15.8 13.6 26.2 13.6l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-15.3 0L215.1 256l89.6-128 15.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0c-10.4 0-20.2 5.1-26.2 13.6L176 200.2 90.2 77.6C84.2 69.1 74.4 64 64 64L32 64zM480 320c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4l-32 16c-15.8 7.9-22.2 27.1-14.3 42.9C393 361.5 404.3 368 416 368l0 80c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-128z"]
}, faDiamondTurnRight = {
  prefix: "fas",
  iconName: "diamond-turn-right",
  icon: [512, 512, ["directions"], "f5eb", "M227.7 11.7c15.6-15.6 40.9-15.6 56.6 0l216 216c15.6 15.6 15.6 40.9 0 56.6l-216 216c-15.6 15.6-40.9 15.6-56.6 0l-216-216c-15.6-15.6-15.6-40.9 0-56.6l216-216zm87.6 137c-4.6-4.6-11.5-5.9-17.4-3.5s-9.9 8.3-9.9 14.8l0 56-64 0c-35.3 0-64 28.7-64 64l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-8.8 7.2-16 16-16l64 0 0 56c0 6.5 3.9 12.3 9.9 14.8s12.9 1.1 17.4-3.5l80-80c6.2-6.2 6.2-16.4 0-22.6l-80-80z"]
}, faDirections = faDiamondTurnRight, faIntegral = {
  prefix: "fas",
  iconName: "integral",
  icon: [320, 512, [], "f667", "M216 64c-13.3 0-24 10.7-24 24l0 336c0 48.6-39.4 88-88 88s-88-39.4-88-88l0-8c0-17.7 14.3-32 32-32s32 14.3 32 32l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-336c0-48.6 39.4-88 88-88s88 39.4 88 88l0 8c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-8c0-13.3-10.7-24-24-24z"]
}, faBurst = {
  prefix: "fas",
  iconName: "burst",
  icon: [512, 512, [], "e4dc", "M37.6 4.2C28-2.3 15.2-1.1 7 7s-9.4 21-2.8 30.5l112 163.3L16.6 233.2C6.7 236.4 0 245.6 0 256s6.7 19.6 16.6 22.8l103.1 33.4L66.8 412.8c-4.9 9.3-3.2 20.7 4.3 28.1s18.8 9.2 28.1 4.3l100.6-52.9 33.4 103.1c3.2 9.9 12.4 16.6 22.8 16.6s19.6-6.7 22.8-16.6l33.4-103.1 100.6 52.9c9.3 4.9 20.7 3.2 28.1-4.3s9.2-18.8 4.3-28.1L392.3 312.2l103.1-33.4c9.9-3.2 16.6-12.4 16.6-22.8s-6.7-19.6-16.6-22.8L388.9 198.7l25.7-70.4c3.2-8.8 1-18.6-5.6-25.2s-16.4-8.8-25.2-5.6l-70.4 25.7L278.8 16.6C275.6 6.7 266.4 0 256 0s-19.6 6.7-22.8 16.6l-32.3 99.6L37.6 4.2z"]
}, faHouseLaptop = {
  prefix: "fas",
  iconName: "house-laptop",
  icon: [640, 512, ["laptop-house"], "e066", "M218.3 8.5c12.3-11.3 31.2-11.3 43.4 0l208 192c6.7 6.2 10.3 14.8 10.3 23.5l-144 0c-19.1 0-36.3 8.4-48 21.7l0-37.7c0-8.8-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l64 0 0 128-160 0c-26.5 0-48-21.5-48-48l0-112-32 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8.1-35.2l208-192zM352 304l0 144 192 0 0-144-192 0zm-48-16c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32l0 160 32 0c8.8 0 16 7.2 16 16c0 26.5-21.5 48-48 48l-48 0-192 0-48 0c-26.5 0-48-21.5-48-48c0-8.8 7.2-16 16-16l32 0 0-160z"]
}, faLaptopHouse = faHouseLaptop, faFaceTired = {
  prefix: "fas",
  iconName: "face-tired",
  icon: [512, 512, [128555, "tired"], "f5c8", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM164.7 328.7c22-22 53.9-40.7 91.3-40.7s69.3 18.7 91.3 40.7c11.1 11.1 20.1 23.4 26.4 35.4c6.2 11.7 10.3 24.4 10.3 35.9c0 5.2-2.6 10.2-6.9 13.2s-9.8 3.7-14.7 1.8l-20.5-7.7c-26.9-10.1-55.5-15.3-84.3-15.3l-3.2 0c-28.8 0-57.3 5.2-84.3 15.3L149.6 415c-4.9 1.8-10.4 1.2-14.7-1.8s-6.9-7.9-6.9-13.2c0-11.6 4.2-24.2 10.3-35.9c6.3-12 15.3-24.3 26.4-35.4zm-31.2-182l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6c0-9 9.6-14.7 17.5-10.5zM396 157.1c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z"]
}, faTired = faFaceTired, faMoneyBills = {
  prefix: "fas",
  iconName: "money-bills",
  icon: [640, 512, [], "e1f3", "M96 96l0 224c0 35.3 28.7 64 64 64l416 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L160 32c-35.3 0-64 28.7-64 64zm64 160c35.3 0 64 28.7 64 64l-64 0 0-64zM224 96c0 35.3-28.7 64-64 64l0-64 64 0zM576 256l0 64-64 0c0-35.3 28.7-64 64-64zM512 96l64 0 0 64c-35.3 0-64-28.7-64-64zM288 208a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120L0 360c0 66.3 53.7 120 120 120l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-400 0c-39.8 0-72-32.2-72-72l0-240z"]
}, faBlindsRaised = {
  prefix: "fas",
  iconName: "blinds-raised",
  icon: [512, 512, [], "f8fd", "M32 0C14.3 0 0 14.3 0 32C0 43.9 6.5 54.2 16.1 59.8L1.2 100.6c-.8 2.2-1.2 4.6-1.2 7C0 118.9 9.1 128 20.4 128L128 128l0-64 32 0 0 64 331.6 0c11.3 0 20.4-9.1 20.4-20.4c0-2.4-.4-4.7-1.2-7L495.9 59.8C505.5 54.2 512 43.9 512 32c0-17.7-14.3-32-32-32L32 0zM144 512c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3L160 224l331.9 0c11.1 0 20.1-9 20.1-20.1c0-2.6-.5-5.1-1.4-7.5L496 160l-336 0 0 64-32 0 0-64L16 160 1.4 196.4c-1 2.4-1.4 4.9-1.4 7.5C0 215 9 224 20.1 224L128 224l0 194.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48z"]
}, faSmog = {
  prefix: "fas",
  iconName: "smog",
  icon: [640, 512, [], "f75f", "M32 144c0 79.5 64.5 144 144 144l123.3 0c22.6 19.9 52.2 32 84.7 32s62.1-12.1 84.7-32l27.3 0c61.9 0 112-50.1 112-112s-50.1-112-112-112c-10.7 0-21 1.5-30.8 4.3C443.8 27.7 401.1 0 352 0c-32.6 0-62.4 12.2-85.1 32.3C242.1 12.1 210.5 0 176 0C96.5 0 32 64.5 32 144zM616 368l-336 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24zm-64 96l-112 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24zm-192 0L24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24zM224 392c0-13.3-10.7-24-24-24L96 368c-13.3 0-24 10.7-24 24s10.7 24 24 24l104 0c13.3 0 24-10.7 24-24z"]
}, faUfoBeam = {
  prefix: "fas",
  iconName: "ufo-beam",
  icon: [576, 512, [], "e048", "M184 152s24 40 104 40s104-40 104-40c0-48-33.3-104-104-104s-104 56-104 104zm-42.6-40.4C159.1 47.2 218.1 0 288 0s128.9 47.2 146.6 111.6C519.2 131.1 576 167 576 208c0 61.9-128.9 112-288 112S0 269.9 0 208c0-41 56.8-76.9 141.4-96.4zM120 208a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm360 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM312 256a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM74.3 325.7l4.2-8.9c14.3 5.6 29.7 10.6 46 15l-6.8 14.5-72 152c-5.7 12-20 17.1-32 11.4s-17.1-20-11.4-32l72-152zm384 20.6l-6.8-14.5c16.3-4.4 31.7-9.4 46-15l4.2 8.9 72 152c5.7 12 .6 26.3-11.4 32s-26.3 .6-32-11.4l-72-152z"]
}, faHydra = {
  prefix: "fas",
  iconName: "hydra",
  icon: [640, 512, [], "e686", "M384 73.1C384.2 32.7 417 0 457.5 0c16.7 0 32.9 5.7 45.9 16.1L532 39c10.6 8.5 14.7 22.8 10.2 35.6S525.6 96 512 96l-48 0s0 0 0 0c-8.8 0-16 7.2-16 16l0 16s0 0 0 0l0 .8 .1 .8 11.5 115c2.4 23.7-6 47.3-22.9 64.1c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0c23.6-23.6 35.4-56.7 32.1-89.9l-4.5-45.2c14.2-29.5 48.3-46.8 82.5-37c8.9 2.6 17.3 6.9 24.6 12.7L628 199c10.6 8.5 14.7 22.8 10.2 35.6S621.6 256 608 256l-48 0c-8.8 0-16 7.2-16 16l0 16 0 24.8c0 61-40.4 112.6-96 129.4l0 37.8c0 17.7-14.3 32-32 32l-36.9 0c-15.6 0-29-11.3-31.6-26.7L341.3 448l-74.7 0-6.2 37.3c-2.6 15.4-15.9 26.7-31.6 26.7L192 512c-17.7 0-32-14.3-32-32l0-32-32 0C57.3 448 0 390.7 0 320c0-40.3 19-78.2 51.2-102.4l25-18.8c1.8-1.4 3.7-2.6 5.7-3.6c4.3-2.1 8.9-3.2 13.5-3.2s9.3 .8 13.6 2.8c3.3 1.5 6.4 3.6 9.1 6.2c2.7 2.6 4.9 5.7 6.5 9c2.1 4.3 3.2 8.9 3.2 13.5s-.8 9.3-2.8 13.6c-.9 2-2.1 4-3.4 5.8L89.2 289.6c-18.4 26.3 .4 62.4 32.5 62.4c13.3 0 25.6-6.6 33-17.7l10.7-16.1c25.9-38.9 69.5-62.2 116.2-62.2l.1 0 9.2 0 5.3 0c47.8 0 87-38.4 87.8-85.3c0-.5 0-.9 0-1.4l0-.6 0-4.7c0-.4 0-.8 0-1.2l0-34.9 0-16 0-27.8 0-11.1zm-32 36.9l0 60.4c-.5 25-18.8 46.7-43.3 52.3l-4-24.1L298 172.1c-1.8-7.1-8.2-12.1-15.5-12.1L224 160c-13.6 0-25.7-8.6-30.2-21.4s-.4-27.1 10.2-35.6l27.2-21.8c14-11.2 31.3-17.3 49.2-17.3c31.4 0 59 18.5 71.6 45.9z"]
}, faCircleCaretUp = {
  prefix: "fas",
  iconName: "circle-caret-up",
  icon: [512, 512, ["caret-circle-up"], "f331", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-368c6.7 0 13 2.8 17.6 7.7l104 112c6.5 7 8.2 17.2 4.4 25.9s-12.5 14.4-22 14.4l-208 0c-9.5 0-18.2-5.7-22-14.4s-2.1-18.9 4.4-25.9l104-112c4.5-4.9 10.9-7.7 17.6-7.7z"]
}, faCaretCircleUp = faCircleCaretUp, faUserVneckHairLong = {
  prefix: "fas",
  iconName: "user-vneck-hair-long",
  icon: [448, 512, [], "e463", "M304 128c0-11.4-2.4-22.2-6.7-32L296 96c-20.5 0-38.7-9.6-50.4-24.5C231.9 95.7 205.8 112 176 112l-30.4 0c-1 5.2-1.6 10.5-1.6 16l0 16c0 44.2 35.8 80 80 80s80-35.8 80-80l0-16zM96 128C96 57.3 153.3 0 224 0s128 57.3 128 128l0 11c0 33.9 13.5 66.5 37.5 90.5l3.9 3.9c4.2 4.2 6.6 10 6.6 16c0 12.5-10.1 22.6-22.6 22.6L224 272 70.6 272C58.1 272 48 261.9 48 249.4c0-6 2.4-11.8 6.6-16l3.9-3.9c24-24 37.5-56.6 37.5-90.5l0-11zm49.9 186.9L210.7 412c6.3 9.5 20.3 9.5 26.6 0l64.8-97.1c3.5-5.2 9.8-8 15.9-6.6c74.5 17.2 130 84 130 163.7l0 8c0 17.7-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32l0-8c0-79.7 55.5-146.5 130-163.7c6.1-1.4 12.4 1.4 15.9 6.6z"]
}, faSquareALock = {
  prefix: "fas",
  iconName: "square-a-lock",
  icon: [576, 512, [], "e44d", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l256 0 0-96c-9.1 0-17.7-5.2-21.8-13.9l-12-26.1-124.4 0-12 26.1c-5.6 12-19.8 17.3-31.8 11.7s-17.3-19.8-11.7-31.8l96-208c3.9-8.5 12.4-13.9 21.8-13.9s17.9 5.4 21.8 13.9l82.4 178.6c5.6-10 13.9-18.3 23.8-24l0-24.6c0-56.4 41.7-103.1 96-110.9L448 96c0-35.3-28.7-64-64-64L64 32zM224 209.3L184 296l80 0-40-86.7zM464 240c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]
}, faCrutch = {
  prefix: "fas",
  iconName: "crutch",
  icon: [512, 512, [], "f7f7", "M297.4 9.4c-12.5 12.5-12.5 32.8 0 45.3l160 160c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-160-160c-12.5-12.5-32.8-12.5-45.3 0zm-96 144l-34.8 34.8c-12.9 12.9-21.9 29.2-25.8 47.1L116.8 342.9c-1.3 5.9-4.3 11.4-8.6 15.7L9.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l98.8-98.8c4.3-4.3 9.7-7.3 15.7-8.6l107.6-23.9c17.8-4 34.1-12.9 47.1-25.8l34.7-34.7c0 0 .1-.1 .1-.1s.1-.1 .1-.1l74.6-74.6-45.3-45.3L336 242.7 269.3 176l52.1-52.1L276.1 78.6l-74.7 74.7zM224 221.3L290.7 288l-12.2 12.2c-4.3 4.3-9.7 7.3-15.7 8.6l-76.7 17 17-76.7c1.3-5.9 4.3-11.4 8.6-15.7L224 221.3z"]
}, faGasPumpSlash = {
  prefix: "fas",
  iconName: "gas-pump-slash",
  icon: [640, 512, [], "f5f4", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-72.2-56.6C569.5 397.9 576 379.7 576 360l0-136 0-32 0-24 0-13.5c0-17-6.7-33.3-18.7-45.3L480 32c-8.8-8.8-23.2-8.8-32 0s-8.8 23.2 0 32l32 32 0 64c0 29.8 20.4 54.9 48 62l0 138c0 8.5-2.7 16.4-7.2 22.9L384 275.7 384 64c0-35.3-28.7-64-64-64L160 0c-30.9 0-56.7 21.9-62.7 51L38.8 5.1zM96 171.6L96 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-49.5L96 171.6z"]
}, faFontAwesome = {
  prefix: "fas",
  iconName: "font-awesome",
  icon: [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", "M91.7 96C106.3 86.8 116 70.5 116 52C116 23.3 92.7 0 64 0S12 23.3 12 52c0 16.7 7.8 31.5 20 41l0 3 0 352 0 64 64 0 0-64 373.6 0c14.6 0 26.4-11.8 26.4-26.4c0-3.7-.8-7.3-2.3-10.7L432 272l61.7-138.9c1.5-3.4 2.3-7 2.3-10.7c0-14.6-11.8-26.4-26.4-26.4L91.7 96z"]
}, faFontAwesomeFlag = faFontAwesome, faFontAwesomeLogoFull = faFontAwesome, faCloudArrowUp = {
  prefix: "fas",
  iconName: "cloud-arrow-up",
  icon: [640, 512, [62338, "cloud-upload", "cloud-upload-alt"], "f0ee", "M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128l-368 0zm79-217c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l39-39L296 392c0 13.3 10.7 24 24 24s24-10.7 24-24l0-134.1 39 39c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0l-80 80z"]
}, faCloudUpload = faCloudArrowUp, faCloudUploadAlt = faCloudArrowUp, faPalette = {
  prefix: "fas",
  iconName: "palette",
  icon: [512, 512, [127912], "f53f", "M512 256c0 .9 0 1.8 0 2.7c-.4 36.5-33.6 61.3-70.1 61.3L344 320c-26.5 0-48 21.5-48 48c0 3.4 .4 6.7 1 9.9c2.1 10.2 6.5 20 10.8 29.9c6.1 13.8 12.1 27.5 12.1 42c0 31.8-21.6 60.7-53.4 62c-3.5 .1-7 .2-10.6 .2C114.6 512 0 397.4 0 256S114.6 0 256 0S512 114.6 512 256zM128 288a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0-96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM288 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm96 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faTransporter4 = {
  prefix: "fas",
  iconName: "transporter-4",
  icon: [512, 512, [], "e2a5", "M224 0l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm-48 64l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm-32 64l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm-32 64l288 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-288 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm64 64l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM480 160l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L480 192l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L448 192l-25.4-7.3c-3.9-1.1-6.6-4.7-6.6-8.7s2.7-7.6 6.6-8.7L448 160l7.3-25.4c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6L480 160zM56.7 358.6L64 384l25.4 7.3c3.9 1.1 6.6 4.7 6.6 8.7s-2.7 7.6-6.6 8.7L64 416l-7.3 25.4c-1.1 3.9-4.7 6.6-8.7 6.6s-7.6-2.7-8.7-6.6L32 416 6.6 408.7C2.7 407.6 0 404.1 0 400s2.7-7.6 6.6-8.7L32 384l7.3-25.4c1.1-3.9 4.7-6.6 8.7-6.6s7.6 2.7 8.7 6.6zM96 480c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-88 0-80 0-88 0c-17.7 0-32-14.3-32-32z"]
}, faChartMixedUpCircleCurrency = {
  prefix: "fas",
  iconName: "chart-mixed-up-circle-currency",
  icon: [576, 512, [], "e5d8", "M400 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l28.8 0L319.4 151.5 211.2 70.4c-11.7-8.8-27.8-8.5-39.2 .6L12 199c-13.8 11-16 31.2-5 45s31.2 16 45 5L192.6 136.5l108.2 81.1c11.7 8.8 27.8 8.5 39.2-.6L480 105l0 39c0 17.7 14.3 32 32 32s32-14.3 32-32l0-112c0-17.7-14.3-32-32-32L400 0zM192 224c-17.7 0-32 14.3-32 32l0 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-192c0-17.7-14.3-32-32-32zM64 320c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32zM432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm25.4-169.4a35.9 35.9 0 1 0 -50.7 50.7 35.9 35.9 0 1 0 50.7-50.7zM396.7 426l-17.3 17.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L374 403.3c-13.2-21.6-13.2-49.1 0-70.7l-17.3-17.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L396.7 310c21.6-13.2 49.1-13.2 70.7 0l17.3-17.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L490 332.7c13.2 21.6 13.2 49.1 0 70.7l17.3 17.3c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L467.3 426c-21.6 13.2-49.1 13.2-70.7 0z"]
}, faObjectsAlignRight = {
  prefix: "fas",
  iconName: "objects-align-right",
  icon: [512, 512, [], "e3bf", "M512 24l0 464c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-464c0-13.3 10.7-24 24-24s24 10.7 24 24zM336 64c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48L48 224c-26.5 0-48-21.5-48-48l0-64C0 85.5 21.5 64 48 64l288 0zm0 224c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48l160 0z"]
}, faArrowsTurnRight = {
  prefix: "fas",
  iconName: "arrows-turn-right",
  icon: [448, 512, [], "e4c0", "M297.4 9.4c12.5-12.5 32.8-12.5 45.3 0l96 96c12.5 12.5 12.5 32.8 0 45.3l-96 96c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L338.7 160 128 160c-35.3 0-64 28.7-64 64l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32C0 153.3 57.3 96 128 96l210.7 0L297.4 54.6c-12.5-12.5-12.5-32.8 0-45.3zm-96 256c12.5-12.5 32.8-12.5 45.3 0l96 96c12.5 12.5 12.5 32.8 0 45.3l-96 96c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L242.7 416 96 416c-17.7 0-32 14.3-32 32l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c0-53 43-96 96-96l146.7 0-41.4-41.4c-12.5-12.5-12.5-32.8 0-45.3z"]
}, faVest = {
  prefix: "fas",
  iconName: "vest",
  icon: [448, 512, [], "e085", "M207.1 237.4L151.2 69.7C168.6 79.7 192.6 88 224 88s55.4-8.3 72.8-18.3L226.5 280.6c-1.6 4.9-2.5 10-2.5 15.2L224 464c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-193.5c0-9.5-2.8-18.7-8.1-26.6l-47.9-71.8c-5.3-7.9-8.1-17.1-8.1-26.6l0-17.5 0-73.7 0-6.3c0-26.5-21.5-48-48-48l-4.5 0c-.2 0-.4 0-.6 0c-.4 0-.8 0-1.2 0C311 0 295.7 9.7 285.7 18.8C276.4 27.2 257.2 40 224 40s-52.4-12.8-61.7-21.2C152.3 9.7 137 0 118.3 0c-.4 0-.8 0-1.2 0c-.2 0-.4 0-.6 0L112 0C85.5 0 64 21.5 64 48l0 6.3L64 128l0 17.5c0 9.5-2.8 18.7-8.1 26.6L8.1 243.9C2.8 251.8 0 261.1 0 270.5L0 464c0 26.5 21.5 48 48 48l128 0c9.9 0 19-3 26.7-8.1C195.9 492.2 192 478.5 192 464l0-168.2c0-8.6 1.4-17.1 4.1-25.3l11-33.1zM347.3 356.7l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-294.6 48l48-48c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-48 48c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z"]
}, faPig = {
  prefix: "fas",
  iconName: "pig",
  icon: [640, 512, [128022], "f706", "M513.5 32c8 0 14.5 6.5 14.5 14.5L528 78c0 19.7-9 37.8-23.6 49.7c6.4 4.9 12.7 10.1 18.6 15.7c17.6-15.9 28.5-38.6 29-63.3l40 0c8.8 0 16 7.2 16 16l0 16c0 32.8-24.6 59.8-56.3 63.5l6.8 9C570 200 585 212.5 602.2 221.1L608 224l8 0c13.3 0 24 10.7 24 24l0 96c0 13.3-10.7 24-24 24l-43.5 0c-22.2 21.2-49.7 36.2-79.8 43.3l-13 45.5C475.8 470.5 463.3 480 449 480l-33 0c-17.7 0-32-14.3-32-32l0-32-64 0-48 0 0 32c0 17.7-14.3 32-32 32l-33 0c-14.3 0-26.8-9.5-30.8-23.2L155 382.4C110.3 358 80 310.5 80 256l0-16-32.6 0C21.2 240 0 218.8 0 192.6c0-21.8 14.8-40.7 35.9-46l8.2-2c8.6-2.1 17.3 3.1 19.4 11.6s-3.1 17.3-11.6 19.4l-8.2 2c-6.9 1.7-11.7 7.9-11.7 15c0 8.5 6.9 15.4 15.4 15.4l35.8 0C98 135 162.6 80 240 80l122.4 0c14.5 0 28.8 1.3 42.7 3.9c8.1-19.5 25.4-34.4 47-39.1l58.4-12.5c1-.2 2-.3 3-.3zM468 256a20 20 0 1 0 0-40 20 20 0 1 0 0 40z"]
}, faInboxFull = {
  prefix: "fas",
  iconName: "inbox-full",
  icon: [512, 512, [], "e1ba", "M58.9 80.5C66 52 91.6 32 121 32l270 0c29.4 0 55 20 62.1 48.5l57 227.9c1.3 5.1 1.9 10.3 1.9 15.5l0 92.1c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-92.1c0-5.2 .6-10.4 1.9-15.5l57-227.9zM391 96L121 96 73 288l51.2 0c12.1 0 23.2 6.8 28.6 17.7l14.3 28.6c5.4 10.8 16.5 17.7 28.6 17.7l120.4 0c12.1 0 23.2-6.8 28.6-17.7l14.3-28.6c5.4-10.8 16.5-17.7 28.6-17.7l51.2 0L391 96zM176 144l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm-32 80l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]
}, faCircleEnvelope = {
  prefix: "fas",
  iconName: "circle-envelope",
  icon: [512, 512, ["envelope-circle"], "e10c", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM128 192c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 9.3L264.7 255.6c-2.7 1.2-5.7 1.9-8.7 1.9s-5.9-.6-8.7-1.9L128 201.3l0-9.3zm149.9 92.7L384 236.5l0 83.5c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-83.5 106.1 48.3c6.9 3.1 14.3 4.8 21.9 4.8s15-1.6 21.9-4.8z"]
}, faEnvelopeCircle = faCircleEnvelope, faTrianglePersonDigging = {
  prefix: "fas",
  iconName: "triangle-person-digging",
  icon: [640, 512, ["construction"], "f85d", "M354.5 51.8C347.3 39.5 334.2 32 320 32s-27.3 7.5-34.5 19.8l-216 368c-7.3 12.4-7.3 27.7-.2 40.1S89.7 480 104 480l432 0c14.3 0 27.6-7.7 34.7-20.1s7-27.8-.2-40.1l-216-368zM216.9 304.7l15.6 9.8 64 40c4.7 2.9 7.5 8.1 7.5 13.6l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-23.1-40.9-25.5-24.5 55.2c-3.6 8.1-13 11.7-21.1 8.1s-11.7-13-8.1-21.1l32-72 7.5-16.8zm112-45.7l19.7 49.2L402 339l16.3-27.2c2.9-4.8 8.1-7.8 13.7-7.8s10.8 2.9 13.7 7.8l48 80c3 4.9 3 11.1 .2 16.1s-8.2 8.1-13.9 8.1l-96 0c-5.8 0-11.1-3.1-13.9-8.1s-2.8-11.2 .2-16.1l15.2-25.4L232 277.9c-3.8-2.2-6.6-5.9-7.6-10.2s-.2-8.8 2.3-12.5l4.2-6.4c10.3-15.5 27.7-24.8 46.3-24.8c22.7 0 43.2 13.8 51.6 34.9zM288 184a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]
}, faConstruction = faTrianglePersonDigging, faFerry = {
  prefix: "fas",
  iconName: "ferry",
  icon: [576, 512, [], "e4ea", "M224 0L352 0c17.7 0 32 14.3 32 32l75.1 0c20.6 0 31.6 24.3 18.1 39.8L456 96 120 96 98.8 71.8C85.3 56.3 96.3 32 116.9 32L192 32c0-17.7 14.3-32 32-32zM96 128l384 0c17.7 0 32 14.3 32 32l0 123.5c0 13.3-4.2 26.3-11.9 37.2l-51.4 71.9c-1.9 1.1-3.7 2.2-5.5 3.5c-15.5 10.7-34 18-51 19.9l-16.5 0c-17.1-1.8-35-9-50.8-19.9c-22.1-15.5-51.6-15.5-73.7 0c-14.8 10.2-32.5 18-50.6 19.9l-16.6 0c-17-1.8-35.6-9.2-51-19.9c-1.8-1.3-3.7-2.4-5.6-3.5L75.9 320.7C68.2 309.8 64 296.8 64 283.5L64 160c0-17.7 14.3-32 32-32zm32 64l0 96 320 0 0-96-320 0zM306.5 421.9C329 437.4 356.5 448 384 448c26.9 0 55.3-10.8 77.4-26.1c0 0 0 0 0 0c11.9-8.5 28.1-7.8 39.2 1.7c14.4 11.9 32.5 21 50.6 25.2c17.2 4 27.9 21.2 23.9 38.4s-21.2 27.9-38.4 23.9c-24.5-5.7-44.9-16.5-58.2-25C449.5 501.7 417 512 384 512c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9c-33 0-65.5-10.3-94.5-25.8c-13.4 8.4-33.7 19.3-58.2 25c-17.2 4-34.4-6.7-38.4-23.9s6.7-34.4 23.9-38.4c18.1-4.2 36.2-13.3 50.6-25.2c11.1-9.4 27.3-10.1 39.2-1.7c0 0 0 0 0 0C136.7 437.2 165.1 448 192 448c27.5 0 55-10.6 77.5-26.1c11.1-7.9 25.9-7.9 37 0z"]
}, faBullseyeArrow = {
  prefix: "fas",
  iconName: "bullseye-arrow",
  icon: [512, 512, [127919], "f648", "M335.2 244.7c.5 3.7 .8 7.5 .8 11.3c0 44.2-35.8 80-80 80s-80-35.8-80-80s35.8-80 80-80c3.8 0 7.6 .3 11.3 .8l31.2-31.2L293.7 117c-12-3.3-24.7-5-37.7-5c-79.5 0-144 64.5-144 144s64.5 144 144 144s144-64.5 144-144c0-13.1-1.7-25.7-5-37.7l-28.6-4.8-31.2 31.2zm110.1-20.8c1.8 10.4 2.7 21.1 2.7 32.1c0 106-86 192-192 192S64 362 64 256S150 64 256 64c10.9 0 21.6 .9 32.1 2.7l9.3-9.3 43.1-43.1C314 5 285.6 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512s256-114.6 256-256c0-29.6-5-58-14.3-84.5l-43.1 43.1-9.3 9.3zm-80.2-43.1l50.7 8.4c10.2 1.7 20.6-1.6 27.9-8.9l51.2-51.2c8.1-8.1 5.3-21.9-5.4-26.2L432 80 409 22.5c-4.3-10.7-18-13.5-26.2-5.4L331.6 68.4c-7.3 7.3-10.6 17.7-8.9 27.9l8.4 50.7L239 239c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l92.1-92.1z"]
}, faArrowsDownToPeople = {
  prefix: "fas",
  iconName: "arrows-down-to-people",
  icon: [640, 512, [], "e4b9", "M144 0c-13.3 0-24 10.7-24 24l0 118.1L97 119c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0l64-64c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23 23L168 24c0-13.3-10.7-24-24-24zM360 200a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zM184 296a40 40 0 1 0 -80 0 40 40 0 1 0 80 0zm312 40a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM200 441.5l26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-36.3-67.5c1.7-1.7 3.2-3.6 4.3-5.8L264 345.5l0 54.5c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-54.5 26.9 49.9c1.2 2.2 2.6 4.1 4.3 5.8l-36.3 67.5c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L440 441.5l0 38.5c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-38.5 26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-37.9-70.3c-15.3-28.5-45.1-46.3-77.5-46.3l-19.5 0c-16.3 0-31.9 4.5-45.4 12.6l-33.6-62.3c-15.3-28.5-45.1-46.3-77.5-46.3l-19.5 0c-32.4 0-62.1 17.8-77.5 46.3l-33.6 62.3c-13.5-8.1-29.1-12.6-45.4-12.6l-19.5 0c-32.4 0-62.1 17.8-77.5 46.3L18.9 468.6c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L88 441.5 88 480c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-38.5zM415 153l64 64c9.4 9.4 24.6 9.4 33.9 0l64-64c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-23 23L520 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 118.1-23-23c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9z"]
}, faSeedling = {
  prefix: "fas",
  iconName: "seedling",
  icon: [512, 512, [127793, "sprout"], "f4d8", "M512 32c0 113.6-84.6 207.5-194.2 222c-7.1-53.4-30.6-101.6-65.3-139.3C290.8 46.3 364 0 448 0l32 0c17.7 0 32 14.3 32 32zM0 96C0 78.3 14.3 64 32 64l32 0c123.7 0 224 100.3 224 224l0 32 0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160C100.3 320 0 219.7 0 96z"]
}, faSprout = faSeedling, faClockSeven = {
  prefix: "fas",
  iconName: "clock-seven",
  icon: [512, 512, [], "e350", "M256 0a256 256 0 1 1 0 512A256 256 0 1 1 256 0zM232 120l0 128.7-60 90c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l64-96c2.6-3.9 4-8.6 4-13.3l0-136c0-13.3-10.7-24-24-24s-24 10.7-24 24z"]
}, faLeftRight = {
  prefix: "fas",
  iconName: "left-right",
  icon: [512, 512, [8596, "arrows-alt-h"], "f337", "M504.3 273.6c4.9-4.5 7.7-10.9 7.7-17.6s-2.8-13-7.7-17.6l-112-104c-7-6.5-17.2-8.2-25.9-4.4s-14.4 12.5-14.4 22l0 56-192 0 0-56c0-9.5-5.7-18.2-14.4-22s-18.9-2.1-25.9 4.4l-112 104C2.8 243 0 249.3 0 256s2.8 13 7.7 17.6l112 104c7 6.5 17.2 8.2 25.9 4.4s14.4-12.5 14.4-22l0-56 192 0 0 56c0 9.5 5.7 18.2 14.4 22s18.9 2.1 25.9-4.4l112-104z"]
}, faArrowsAltH = faLeftRight, faBoxesPacking = {
  prefix: "fas",
  iconName: "boxes-packing",
  icon: [640, 512, [], "e4c7", "M256 48c0-26.5 21.5-48 48-48L592 0c26.5 0 48 21.5 48 48l0 416c0 26.5-21.5 48-48 48l-210.7 0c1.8-5 2.7-10.4 2.7-16l0-242.7c18.6-6.6 32-24.4 32-45.3l0-32c0-26.5-21.5-48-48-48l-112 0 0-80zM571.3 347.3c6.2-6.2 6.2-16.4 0-22.6l-64-64c-6.2-6.2-16.4-6.2-22.6 0l-64 64c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L480 310.6 480 432c0 8.8 7.2 16 16 16s16-7.2 16-16l0-121.4 36.7 36.7c6.2 6.2 16.4 6.2 22.6 0zM0 176c0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16L16 224c-8.8 0-16-7.2-16-16l0-32zm352 80l0 224c0 17.7-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32l0-224 320 0zM144 320c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0z"]
}, faCircleArrowLeft = {
  prefix: "fas",
  iconName: "circle-arrow-left",
  icon: [512, 512, ["arrow-circle-left"], "f0a8", "M512 256A256 256 0 1 0 0 256a256 256 0 1 0 512 0zM215 127c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-71 71L392 232c13.3 0 24 10.7 24 24s-10.7 24-24 24l-214.1 0 71 71c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L103 273c-9.4-9.4-9.4-24.6 0-33.9L215 127z"]
}, faArrowCircleLeft = faCircleArrowLeft, faFlashlight = {
  prefix: "fas",
  iconName: "flashlight",
  icon: [640, 512, [128294], "f8b8", "M576 416l32 0c17.7 0 32-14.3 32-32l0-256c0-17.7-14.3-32-32-32l-32 0 0 320zM544 97.7C449.1 107.9 384 160 384 160L48 160c-26.5 0-48 21.5-48 48l0 96c0 26.5 21.5 48 48 48l336 0s65.1 52.1 160 62.3l0-316.5zM224 256c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32z"]
}, faFileJpg = {
  prefix: "fas",
  iconName: "file-jpg",
  icon: [512, 512, [], "e646", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-208 0c-35.3 0-64 28.7-64 64l0 144-48 0c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zM208 512c-26.5 0-48-21.5-48-48l0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 26.5-21.5 48-48 48zm96-160l32 0c30.9 0 56 25.1 56 56s-25.1 56-56 56l-16 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48 0-80c0-8.8 7.2-16 16-16zm32 80c13.3 0 24-10.7 24-24s-10.7-24-24-24l-16 0 0 48 16 0zm80-40c0-22.1 17.9-40 40-40l16 0c22.1 0 40 17.9 40 40l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-4.4-3.6-8-8-8l-16 0c-4.4 0-8 3.6-8 8l0 80c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-8c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 24c0 22.1-17.9 40-40 40l-16 0c-22.1 0-40-17.9-40-40l0-80z"]
}, faGroupArrowsRotate = {
  prefix: "fas",
  iconName: "group-arrows-rotate",
  icon: [512, 512, [], "e4f6", "M201.1 71.9c16.9-5 26.6-22.9 21.5-39.8s-22.9-26.6-39.8-21.5c-21.5 6.4-41.8 15.5-60.6 27C114.3 34 105.4 32 96 32C60.7 32 32 60.7 32 96c0 9.4 2 18.3 5.6 26.3c-11.5 18.7-20.6 39-27 60.6c-5 16.9 4.6 34.8 21.5 39.8s34.8-4.6 39.8-21.5c4.3-14.6 10.4-28.5 17.9-41.4c2 .2 4.1 .3 6.1 .3c35.3 0 64-28.7 64-64c0-2.1-.1-4.1-.3-6.1c12.9-7.5 26.8-13.6 41.4-17.9zm128-61.3c-16.9-5-34.8 4.6-39.8 21.5s4.6 34.8 21.5 39.8c14.6 4.3 28.5 10.4 41.4 17.9c-.2 2-.3 4.1-.3 6.1c0 35.3 28.7 64 64 64c2.1 0 4.1-.1 6.2-.3c7.5 12.9 13.6 26.8 17.9 41.4c5 16.9 22.9 26.6 39.8 21.5s26.6-22.9 21.5-39.8c-6.4-21.5-15.5-41.8-27-60.6c3.6-8 5.6-16.9 5.6-26.3c0-35.3-28.7-64-64-64c-9.4 0-18.3 2-26.3 5.6c-18.7-11.5-39-20.6-60.6-27zM71.9 310.9c-5-16.9-22.9-26.6-39.8-21.5s-26.6 22.9-21.5 39.8c6.4 21.5 15.5 41.8 27 60.6C34 397.7 32 406.6 32 416c0 35.3 28.7 64 64 64c9.4 0 18.3-2 26.3-5.6c18.7 11.5 39 20.6 60.6 27c16.9 5 34.8-4.6 39.8-21.5s-4.6-34.8-21.5-39.8c-14.6-4.3-28.5-10.4-41.4-17.9c.2-2 .3-4.1 .3-6.2c0-35.3-28.7-64-64-64c-2.1 0-4.1 .1-6.2 .3c-7.5-12.9-13.6-26.8-17.9-41.4zm429.4 18.3c5-16.9-4.6-34.8-21.5-39.8s-34.8 4.6-39.8 21.5c-4.3 14.6-10.4 28.5-17.9 41.4c-2-.2-4.1-.3-6.2-.3c-35.3 0-64 28.7-64 64c0 2.1 .1 4.1 .3 6.2c-12.9 7.5-26.8 13.6-41.4 17.9c-16.9 5-26.6 22.9-21.5 39.8s22.9 26.6 39.8 21.5c21.5-6.4 41.8-15.5 60.6-27c8 3.6 16.9 5.6 26.3 5.6c35.3 0 64-28.7 64-64c0-9.4-2-18.3-5.6-26.3c11.5-18.7 20.6-39 27-60.6zM192.8 256.8c0-15.6 5.6-29.9 14.9-41.1L223 231c6.6 6.6 17.8 1.9 17.8-7.4l0-60.5c0-5.7-4.7-10.4-10.4-10.4l-60.5 0c-9.3 0-13.9 11.2-7.4 17.8l11.2 11.2c-17.9 19.8-28.9 46.2-28.9 75.1c0 43.6 24.9 81.3 61.1 99.8c11.8 6 26.3 1.4 32.3-10.4s1.4-26.3-10.4-32.3c-20.8-10.6-34.9-32.2-34.9-57zm93.1-58.6c20.8 10.6 34.9 32.2 34.9 57c0 15.6-5.6 29.9-14.9 41.1L290.6 281c-6.6-6.6-17.8-1.9-17.8 7.4l0 60.5c0 5.7 4.7 10.4 10.4 10.4l60.5 0c9.3 0 13.9-11.2 7.4-17.8l-11.2-11.2c17.9-19.8 28.9-46.2 28.9-75.1c0-43.6-24.9-81.3-61.1-99.8c-11.8-6-26.3-1.4-32.3 10.4s-1.4 26.3 10.4 32.3z"]
}, faBowlFood = {
  prefix: "fas",
  iconName: "bowl-food",
  icon: [512, 512, [], "e4c6", "M0 192c0-35.3 28.7-64 64-64c.5 0 1.1 0 1.6 0C73 91.5 105.3 64 144 64c15 0 29 4.1 40.9 11.2C198.2 49.6 225.1 32 256 32s57.8 17.6 71.1 43.2C339 68.1 353 64 368 64c38.7 0 71 27.5 78.4 64c.5 0 1.1 0 1.6 0c35.3 0 64 28.7 64 64c0 11.7-3.1 22.6-8.6 32L8.6 224C3.1 214.6 0 203.7 0 192zm0 91.4C0 268.3 12.3 256 27.4 256l457.1 0c15.1 0 27.4 12.3 27.4 27.4c0 70.5-44.4 130.7-106.7 154.1L403.5 452c-2 16-15.6 28-31.8 28l-231.5 0c-16.1 0-29.8-12-31.8-28l-1.8-14.4C44.4 414.1 0 353.9 0 283.4z"]
}, faSquare9 = {
  prefix: "fas",
  iconName: "square-9",
  icon: [448, 512, [], "e25e", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM224 272a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm-26 44.4l-29.6 25.4c-10.1 8.6-11.2 23.8-2.6 33.8s23.8 11.2 33.8 2.6l81.6-70C305.8 287.2 320 256.4 320 224c0-53-43-96-96-96s-96 43-96 96c0 44 29.6 81.1 70 92.4z"]
}, faCandyCane = {
  prefix: "fas",
  iconName: "candy-cane",
  icon: [512, 512, [], "f786", "M348.8 131.5c3.7-2.3 7.9-3.5 12.2-3.5c12.7 0 23 10.3 23 23l0 5.6c0 9.9-5.1 19.1-13.5 24.3L30.1 393.7C.1 412.5-9 451.9 9.7 481.9s58.2 39.1 88.2 20.4L438.4 289.5c45.8-28.6 73.6-78.8 73.6-132.8l0-5.6C512 67.6 444.4 0 361 0c-28.3 0-56 8-80.1 23L254.1 39.7c-30 18.7-39.1 58.2-20.4 88.2s58.2 39.1 88.2 20.4l26.8-16.8zM298.4 49.8c9.2-5.7 19.1-10.1 29.4-13.1L348 97.5c-5.7 1.4-11.2 3.7-16.3 6.8l-12.6 7.9L298.4 49.8zm88.5 52.7l46.2-46.2c8.5 6.5 16.1 14.1 22.6 22.6l-46.2 46.2c-5.1-9.6-13-17.5-22.6-22.6zm28.9 59.3l61.6 20.5c-2.2 10.5-5.8 20.7-10.5 30.2l-62-20.7c6.2-8.8 10.1-19.1 11-30.1zm-86.1 82.5l60.4 37.7-30.2 18.9-60.4-37.7 30.2-18.9zm-107.2 67l60.4 37.7-30.2 18.9-60.4-37.7 30.2-18.9zM119.3 375.7l60.4 37.7-30.2 18.9L89.1 394.6l30.2-18.9z"]
}, faArrowDownWideShort = {
  prefix: "fas",
  iconName: "arrow-down-wide-short",
  icon: [576, 512, ["sort-amount-asc", "sort-amount-down"], "f160", "M151.6 469.6C145.5 476.2 137 480 128 480s-17.5-3.8-23.6-10.4l-88-96c-11.9-13-11.1-33.3 2-45.2s33.3-11.1 45.2 2L96 365.7 96 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 301.7 32.4-35.4c11.9-13 32.2-13.9 45.2-2s13.9 32.2 2 45.2l-88 96zM320 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0zm0-128c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0zm0-128c-17.7 0-32-14.3-32-32s14.3-32 32-32l160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0zm0-128c-17.7 0-32-14.3-32-32s14.3-32 32-32l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L320 96z"]
}, faSortAmountAsc = faArrowDownWideShort, faSortAmountDown = faArrowDownWideShort, faSquareDollar = {
  prefix: "fas",
  iconName: "square-dollar",
  icon: [448, 512, ["dollar-square", "usd-square"], "f2e9", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM244.8 133.6l0 14.2c9.7 1.2 19.4 3.9 29 6.6c1.9 .5 3.7 1 5.6 1.6c11.5 3.2 18.3 15.1 15.1 26.6s-15.1 18.2-26.6 15.1c-1.6-.4-3.1-.9-4.7-1.3c-7-2-14-3.9-21.1-5.3c-13.2-2.5-28.5-1.3-40.8 4c-11 4.8-20.1 16.4-7.6 24.4c9.8 6.3 21.8 9.5 33.2 12.6c2.4 .6 4.7 1.3 7 1.9c15.6 4.4 35.5 10.1 50.4 20.3c19.4 13.3 28.5 34.9 24.2 58.1c-4.1 22.4-19.7 37.1-38.4 44.7c-7.8 3.2-16.3 5.2-25.2 6.2l0 15.2c0 11.9-9.7 21.6-21.6 21.6s-21.6-9.7-21.6-21.6l0-17.4c-14.5-3.3-28.7-7.9-42.8-12.5c-11.3-3.7-17.5-16-13.7-27.3s16-17.5 27.3-13.7c2.5 .8 5 1.7 7.5 2.5c11.3 3.8 22.9 7.7 34.5 9.6c17 2.5 30.6 1 39.5-2.6c12-4.8 17.7-19.1 5.9-27.1c-10.1-6.9-22.6-10.3-34.5-13.5c-2.3-.6-4.5-1.2-6.8-1.9c-15.1-4.3-34-9.6-48.2-18.7c-19.5-12.5-29.4-33.3-25.2-56.4c4-21.8 21-36.3 39-44.1c5.5-2.4 11.4-4.3 17.5-5.7l0-16.1c0-11.9 9.7-21.6 21.6-21.6s21.6 9.7 21.6 21.6z"]
}, faDollarSquare = faSquareDollar, faUsdSquare = faSquareDollar, faPhoneArrowRight = {
  prefix: "fas",
  iconName: "phone-arrow-right",
  icon: [512, 512, [], "e5be", "M117.5 1.4c19.4-5.3 39.7 4.6 47.4 23.2l40 96c6.8 16.3 2.1 35.2-11.6 46.3L144 207.3c33.3 70.4 90.3 127.4 160.7 160.7L345 318.7c11.2-13.7 30-18.4 46.3-11.6l96 40c18.6 7.7 28.5 28 23.2 47.4l-24 88C481.8 499.9 466 512 448 512C200.6 512 0 311.4 0 64C0 46 12.1 30.2 29.5 25.4l88-24zM425 7l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l39-39L312 128c-13.3 0-24-10.7-24-24s10.7-24 24-24l118.1 0L391 41c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0z"]
}, faHandHoldingSeedling = {
  prefix: "fas",
  iconName: "hand-holding-seedling",
  icon: [576, 512, [], "f4bf", "M96 14.5C96 6.5 102.5 0 110.5 0L160 0c88.4 0 160 71.6 160 160l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-14.5 0C161.1 160 96 94.9 96 14.5zm384 0C480 89 424.1 150.3 352 159c-.2-44.9-15.9-86.2-42-118.8C338.2 15.2 375.3 0 416 0l49.5 0c8 0 14.5 6.5 14.5 14.5zm88.2 321.7c13.1 17.8 9.3 42.8-8.5 55.9L433.1 485.5c-23.4 17.2-51.6 26.5-80.7 26.5L192 512 32 512c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l36.8 0 44.9-36c22.7-18.2 50.9-28 80-28l78.3 0 16 0 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l120.6 0 119.7-88.2c17.8-13.1 42.8-9.3 55.9 8.5zM193.6 384c0 0 0 0 0 0l-.9 0c.3 0 .6 0 .9 0z"]
}, faMessageCheck = {
  prefix: "fas",
  iconName: "message-check",
  icon: [512, 512, ["comment-alt-check"], "f4a2", "M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zm369 89c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-111 111-47-47c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l64 64c9.4 9.4 24.6 9.4 33.9 0L369 153z"]
}, faCommentAltCheck = faMessageCheck, faCloudBolt = {
  prefix: "fas",
  iconName: "cloud-bolt",
  icon: [512, 512, [127785, "thunderstorm"], "f76c", "M0 224c0 53 43 96 96 96l47.2 0L290 202.5c17.6-14.1 42.6-14 60.2 .2s22.8 38.6 12.8 58.8L333.7 320l18.3 0 64 0c53 0 96-43 96-96s-43-96-96-96c-.5 0-1.1 0-1.6 0c1.1-5.2 1.6-10.5 1.6-16c0-44.2-35.8-80-80-80c-24.3 0-46.1 10.9-60.8 28C256.5 24.3 219.1 0 176 0C114.1 0 64 50.1 64 112c0 7.1 .7 14.1 1.9 20.8C27.6 145.4 0 181.5 0 224zm330.1 3.6c-5.8-4.7-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7l70.1 0L177.7 488.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7l-70.1 0 52.4-104.8c3.4-6.7 1.6-14.9-4.2-19.6z"]
}, faThunderstorm = faCloudBolt, faChartLineUpDown = {
  prefix: "fas",
  iconName: "chart-line-up-down",
  icon: [512, 512, [], "e5d7", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64zm313.4 57.4L288 210.7l-57.4-57.4c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L208 221.3l57.4 57.4c12.5 12.5 32.8 12.5 45.3 0l112-112 18.7 18.7c4.2 4.2 10 6.6 16 6.6c12.5 0 22.6-10.1 22.6-22.6l0-73.2 0-.3L480 80c0-8.8-7.2-16-16-16l-89.4 0C362.1 64 352 74.1 352 86.6c0 6 2.4 11.8 6.6 16l18.7 18.7zm64 141.3l-18.7 18.7-34.7-34.7-45.3 45.3 34.7 34.7-18.7 18.7c-4.2 4.2-6.6 10-6.6 16c0 12.5 10.1 22.6 22.6 22.6l89.4 0c8.8 0 16-7.2 16-16l0-89.4c0-12.5-10.1-22.6-22.6-22.6c-6 0-11.8 2.4-16 6.6z"]
}, faTextSlash = {
  prefix: "fas",
  iconName: "text-slash",
  icon: [640, 512, ["remove-format"], "f87d", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L355.7 253.5 400.2 96 503 96 497 120.2c-4.3 17.1 6.1 34.5 23.3 38.8s34.5-6.1 38.8-23.3l11-44.1C577.6 61.3 554.7 32 523.5 32L376.1 32l-.3 0L204.5 32c-22 0-41.2 15-46.6 36.4l-6.3 25.2L38.8 5.1zm168 131.7c.1-.3 .2-.7 .3-1L217 96l116.7 0L301.3 210.8l-94.5-74.1zM243.3 416L192 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-42.2 0 17.6-62.1L272.9 311 243.3 416z"]
}, faRemoveFormat = faTextSlash, faWatch = {
  prefix: "fas",
  iconName: "watch",
  icon: [384, 512, [8986], "f2e1", "M112 0L272 0c26.5 0 48 21.5 48 48l0 24.2C283.7 46.8 239.6 32 192 32s-91.7 14.8-128 40.2L64 48C64 21.5 85.5 0 112 0zM64 464l0-24.2c36.3 25.3 80.4 40.2 128 40.2s91.7-14.8 128-40.2l0 24.2c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48zM0 256a192 192 0 1 1 384 0A192 192 0 1 1 0 256zM192 152c-13.3 0-24 10.7-24 24l0 80c0 8 4 15.5 10.7 20l48 32c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3L216 243.2l0-67.2c0-13.3-10.7-24-24-24z"]
}, faCircleDownLeft = {
  prefix: "fas",
  iconName: "circle-down-left",
  icon: [512, 512, [], "e107", "M256 512A256 256 0 1 1 256 0a256 256 0 1 1 0 512zM160 198.6L160 336c0 8.8 7.2 16 16 16l137.4 0c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L296 280l66.3-66.3c3.6-3.6 5.7-8.5 5.7-13.7s-2-10-5.7-13.7l-36.7-36.7C322 146 317.1 144 312 144s-10 2-13.7 5.7L232 216l-33.4-33.4c-4.2-4.2-10-6.6-16-6.6c-12.5 0-22.6 10.1-22.6 22.6z"]
}, faText = {
  prefix: "fas",
  iconName: "text",
  icon: [448, 512, [], "f893", "M64 96l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 80C0 53.5 21.5 32 48 32l176 0 176 0c26.5 0 48 21.5 48 48l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32L256 96l0 320 48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l48 0 0-320L64 96z"]
}, faProjector = {
  prefix: "fas",
  iconName: "projector",
  icon: [640, 512, [], "f8d6", "M440 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80zM281 39c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l56 56c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L281 39zM585 73c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L495 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l56-56zm-9 119l-64 0c-26.7-20.1-60-32-96-32s-69.3 11.9-96 32L64 192c-35.3 0-64 28.7-64 64L0 384c0 35.3 28.7 64 64 64l9.9 39.8C77.5 502 90.3 512 105 512l14 0c14.7 0 27.5-10 31-24.2L160 448l160 0c26.7 20.1 60 32 96 32c24.4 0 47.5-5.5 68.2-15.2l5.7 23c3.6 14.2 16.4 24.2 31 24.2l14 0c14.7 0 27.5-10 31-24.2L576 448c35.3 0 64-28.7 64-64l0-128c0-35.3-28.7-64-64-64zM416 224a96 96 0 1 1 0 192 96 96 0 1 1 0-192zM64 320a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faFaceSmileWink = {
  prefix: "fas",
  iconName: "face-smile-wink",
  icon: [512, 512, [128521, "smile-wink"], "f4da", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM164.1 325.5C182 346.2 212.6 368 256 368s74-21.8 91.9-42.5c5.8-6.7 15.9-7.4 22.6-1.6s7.4 15.9 1.6 22.6C349.8 372.1 311.1 400 256 400s-93.8-27.9-116.1-53.5c-5.8-6.7-5.1-16.8 1.6-22.6s16.8-5.1 22.6 1.6zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm156.4 25.6c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4c30.4-40.5 91.2-40.5 121.6 0c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2c-17.6-23.5-52.8-23.5-70.4 0z"]
}, faSmileWink = faFaceSmileWink, faTombstoneBlank = {
  prefix: "fas",
  iconName: "tombstone-blank",
  icon: [448, 512, [129702, "tombstone-alt"], "f721", "M224 0C118 0 32 86 32 192l0 224 384 0 0-224C416 86 330 0 224 0zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448z"]
}, faTombstoneAlt = faTombstoneBlank, faChessKingPiece = {
  prefix: "fas",
  iconName: "chess-king-piece",
  icon: [256, 512, ["chess-king-alt"], "f440", "M144 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 16L96 32c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 32L60.2 96C49.1 96 40 105.1 40 116.2c0 2.5 .5 4.9 1.3 7.3L73.8 208 72 208c-13.3 0-24 10.7-24 24s10.7 24 24 24l4 0L60 384l136 0L180 256l4 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-1.8 0 32.5-84.5c.9-2.3 1.3-4.8 1.3-7.3c0-11.2-9.1-20.2-20.2-20.2L144 96l0-32 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16zM48 416L4.8 473.6C1.7 477.8 0 482.8 0 488c0 13.3 10.7 24 24 24l208 0c13.3 0 24-10.7 24-24c0-5.2-1.7-10.2-4.8-14.4L208 416 48 416z"]
}, faChessKingAlt = faChessKingPiece, faCircle6 = {
  prefix: "fas",
  iconName: "circle-6",
  icon: [512, 512, [], "e0f3", "M0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256-16a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm-96 48c0 53 43 96 96 96s96-43 96-96c0-44-29.6-81.1-70-92.4l29.6-25.4c10.1-8.6 11.2-23.8 2.6-33.8s-23.8-11.2-33.8-2.6l-81.6 70C174.2 224.8 160 255.6 160 288z"]
}, faWavesSine = {
  prefix: "fas",
  iconName: "waves-sine",
  icon: [640, 512, [], "e65d", "M256.2 140.6c-11 18.2-20.4 40.1-29.3 64.6c-9.2-27.9-19.8-57.4-32.9-84.7c2.4-4.5 4.9-8.9 7.5-13.2C226.3 66.4 263.3 32 320 32s93.7 34.4 118.6 75.4c23.8 39.2 40.3 90.2 55.2 136.5l.7 2.3c15.8 49.1 30.2 93.1 49.7 125.2C563 402.4 582.6 416 608 416c17.7 0 32 14.3 32 32s-14.3 32-32 32c-56.7 0-93.7-34.4-118.6-75.4c-23.8-39.2-40.3-90.2-55.2-136.5l-.7-2.3c-15.8-49.1-30.2-93.1-49.7-125.2C365 109.6 345.4 96 320 96s-45 13.6-63.8 44.6zM158.1 391.4c-2.4 4.5-4.9 8.9-7.5 13.2C125.7 445.6 88.7 480 32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32c25.4 0 45-13.6 63.8-44.6c11-18.2 20.4-40.1 29.3-64.6c9.2 27.9 19.8 57.4 32.9 84.7zm225.8-20c11-18.2 20.4-40.1 29.3-64.6c9.2 27.9 19.8 57.4 32.9 84.7c-2.4 4.5-4.9 8.9-7.5 13.2C413.7 445.6 376.7 480 320 480s-93.7-34.4-118.6-75.4c-23.8-39.2-40.3-90.2-55.2-136.5c0 0 0 0 0 0l-.7-2.3c-15.8-49.1-30.2-93.1-49.7-125.2C77 109.6 57.4 96 32 96C14.3 96 0 81.7 0 64S14.3 32 32 32c56.7 0 93.7 34.4 118.6 75.4c23.8 39.2 40.3 90.2 55.2 136.5l.7 2.3c15.8 49.1 30.2 93.1 49.7 125.2C275 402.4 294.6 416 320 416s45-13.6 63.8-44.6zM544.2 140.6c-11 18.2-20.4 40.1-29.3 64.6c-9.2-27.9-19.8-57.5-32.9-84.7c2.4-4.5 4.9-8.9 7.5-13.2C514.3 66.4 551.3 32 608 32c17.7 0 32 14.3 32 32s-14.3 32-32 32c-25.4 0-45 13.6-63.8 44.6z"]
}, faLeft = {
  prefix: "fas",
  iconName: "left",
  icon: [448, 512, ["arrow-alt-left"], "f355", "M9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l160-160c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6l0 96 184 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-184 0 0 96c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-160-160z"]
}, faArrowAltLeft = faLeft, faFileWord = {
  prefix: "fas",
  iconName: "file-word",
  icon: [384, 512, [], "f1c2", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM111 257.1l26.8 89.2 31.6-90.3c3.4-9.6 12.5-16.1 22.7-16.1s19.3 6.4 22.7 16.1l31.6 90.3L273 257.1c3.8-12.7 17.2-19.9 29.9-16.1s19.9 17.2 16.1 29.9l-48 160c-3 10-12 16.9-22.4 17.1s-19.8-6.2-23.2-16.1L192 336.6l-33.3 95.3c-3.4 9.8-12.8 16.3-23.2 16.1s-19.5-7.1-22.4-17.1l-48-160c-3.8-12.7 3.4-26.1 16.1-29.9s26.1 3.4 29.9 16.1z"]
}, faFilePowerpoint = {
  prefix: "fas",
  iconName: "file-powerpoint",
  icon: [384, 512, [], "f1c4", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM136 240l68 0c42 0 76 34 76 76s-34 76-76 76l-44 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56 0-104c0-13.3 10.7-24 24-24zm68 104c15.5 0 28-12.5 28-28s-12.5-28-28-28l-44 0 0 56 44 0z"]
}, faSquareDown = {
  prefix: "fas",
  iconName: "square-down",
  icon: [448, 512, [11015, "arrow-alt-square-down"], "f350", "M64 480c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480zm171.3-84.7l112-112c4.6-4.6 5.9-11.5 3.5-17.4s-8.3-9.9-14.8-9.9l-64 0 0-96c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 96-64 0c-6.5 0-12.3 3.9-14.8 9.9s-1.1 12.9 3.5 17.4l112 112c6.2 6.2 16.4 6.2 22.6 0z"]
}, faArrowAltSquareDown = faSquareDown, faObjectsAlignCenterVertical = {
  prefix: "fas",
  iconName: "objects-align-center-vertical",
  icon: [512, 512, [], "e3bd", "M64 80c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 152 64 0 0-88c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 88 40 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-40 0 0 88c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-88-64 0 0 152c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-152-40 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l40 0L64 80z"]
}, faArrowsLeftRight = {
  prefix: "fas",
  iconName: "arrows-left-right",
  icon: [512, 512, ["arrows-h"], "f07e", "M406.6 374.6l96-96c12.5-12.5 12.5-32.8 0-45.3l-96-96c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 224l-293.5 0 41.4-41.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3l96 96c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L109.3 288l293.5 0-41.4 41.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0z"]
}, faArrowsH = faArrowsLeftRight, faHouseLock = {
  prefix: "fas",
  iconName: "house-lock",
  icon: [640, 512, [], "e510", "M384 480c0 11.7 3.1 22.6 8.6 32l-.6 0c-22.1 0-40-17.9-40-40l0-24 0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32l0 64 0 24c0 22.1-17.9 40-40 40l-24 0-31.9 0c-1.5 0-3-.1-4.5-.2c-1.2 .1-2.4 .2-3.6 .2l-16 0c-22.1 0-40-17.9-40-40l0-112c0-.9 0-1.9 .1-2.8l0-69.7-32 0c-18 0-32-14-32-32.1c0-9 3-17 10-24L266.4 8c7-7 15-8 22-8s15 2 21 7L490.7 166.3C447.2 181.7 416 223.2 416 272l0 24.6c-19.1 11.1-32 31.7-32 55.4l0 128zM528 240c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l0-48z"]
}, faCloudArrowDown = {
  prefix: "fas",
  iconName: "cloud-arrow-down",
  icon: [640, 512, [62337, "cloud-download", "cloud-download-alt"], "f0ed", "M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128l-368 0zm79-167l80 80c9.4 9.4 24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-39 39L344 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 134.1-39-39c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9z"]
}, faCloudDownload = faCloudArrowDown, faCloudDownloadAlt = faCloudArrowDown, faWreath = {
  prefix: "fas",
  iconName: "wreath",
  icon: [448, 512, [], "f7e2", "M182.6 0c15.8 0 30.2 5.7 41.4 15.2C235.2 5.7 249.6 0 265.4 0c27.9 0 51.6 17.8 60.3 42.6c5.8-1.7 11.9-2.6 18.2-2.6c35.3 0 64 28.7 64 64c0 6.3-.9 12.5-2.6 18.2c24.8 8.8 42.6 32.5 42.6 60.3c0 15.8-5.7 30.2-15.2 41.4c9.5 11.2 15.2 25.6 15.2 41.4c0 27.9-17.8 51.6-42.6 60.3c1.7 5.8 2.6 11.9 2.6 18.2c0 32.6-24.4 59.6-56 63.5l0-3.7c0-28.6-23.2-51.8-51.8-51.8c-7.2 0-14.4 1.5-21 4.5L224 381l-55.2-24.5c-6.6-2.9-13.8-4.5-21-4.5C119.2 352 96 375.2 96 403.8l0 3.7c-31.6-3.9-56-30.9-56-63.5c0-6.3 .9-12.5 2.6-18.2C17.8 317 0 293.3 0 265.4c0-15.8 5.7-30.2 15.2-41.4C5.7 212.8 0 198.4 0 182.6c0-27.9 17.8-51.6 42.6-60.3C40.9 116.5 40 110.3 40 104c0-35.3 28.7-64 64-64c6.3 0 12.5 .9 18.2 2.6C131 17.8 154.7 0 182.6 0zM203 142.4c-5.7 6-13.6 9.4-21.9 9.1c-16.6-.6-30.2 13-29.6 29.6c.3 8.3-3 16.3-9.1 21.9c-12.1 11.3-12.1 30.6 0 41.9c6 5.7 9.4 13.6 9.1 21.9c-.6 16.6 13 30.2 29.6 29.6c8.3-.3 16.3 3 21.9 9.1c11.3 12.1 30.6 12.1 41.9 0c5.7-6 13.6-9.4 21.9-9.1c16.6 .6 30.2-13 29.6-29.6c-.3-8.3 3-16.3 9.1-21.9c12.1-11.3 12.1-30.6 0-41.9c-6-5.7-9.4-13.6-9.1-21.9c.6-16.6-13-30.2-29.6-29.6c-8.3 .3-16.3-3-21.9-9.1c-11.3-12.1-30.6-12.1-41.9 0zM128 403.8c0-10.9 8.9-19.8 19.8-19.8c2.8 0 5.5 .6 8 1.7L224 416l68.2-30.3c2.5-1.1 5.3-1.7 8-1.7c10.9 0 19.8 8.9 19.8 19.8l0 88.4c0 10.9-8.9 19.8-19.8 19.8c-2.8 0-5.5-.6-8-1.7L224 480l-68.2 30.3c-2.5 1.1-5.3 1.7-8 1.7c-10.9 0-19.8-8.9-19.8-19.8l0-88.4z"]
}, faChildren = {
  prefix: "fas",
  iconName: "children",
  icon: [640, 512, [], "e4e1", "M160 0a64 64 0 1 1 0 128A64 64 0 1 1 160 0zM88 480l0-80-17.8 0c-10.9 0-18.6-10.7-15.2-21.1l31.1-93.4L57.5 323.3c-10.7 14.1-30.8 16.8-44.8 6.2s-16.8-30.7-6.2-44.8L65.4 207c22.4-29.6 57.5-47 94.6-47s72.2 17.4 94.6 47l58.9 77.7c10.7 14.1 7.9 34.2-6.2 44.8s-34.2 7.9-44.8-6.2l-28.6-37.8L265 378.9c3.5 10.4-4.3 21.1-15.2 21.1L232 400l0 80c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-80-16 0 0 80c0 17.7-14.3 32-32 32s-32-14.3-32-32zM480 0a64 64 0 1 1 0 128A64 64 0 1 1 480 0zm-8 384l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-179.5L395.1 321c-9.4 15-29.2 19.4-44.1 10s-19.4-29.2-10-44.1l51.7-82.1c17.6-27.9 48.3-44.9 81.2-44.9l12.3 0c33 0 63.7 16.9 81.2 44.9L619.1 287c9.4 15 4.9 34.7-10 44.1s-34.7 4.9-44.1-10L552 300.5 552 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96-16 0z"]
}, faMeterDroplet = {
  prefix: "fas",
  iconName: "meter-droplet",
  icon: [640, 512, [], "e1ea", "M256 512c53.7 0 103.5-16.5 144.6-44.7C390 447.2 384 424.3 384 400c0-23.6 5.8-46.9 16.9-67.8l75.3-141.2c4.9-9.2 12.1-16.7 20.6-22.1C461.2 70.4 366.8 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512zM192 160l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32s32 14.3 32 32zm96 0l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32s32 14.3 32 32zm96 0l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32s32 14.3 32 32zm120.5 46.1L429.2 347.3C420.5 363.5 416 381.6 416 400c0 61.9 50.1 112 112 112s112-50.1 112-112c0-18.4-4.5-36.5-13.2-52.7L551.5 206.1c-4.6-8.7-13.7-14.1-23.5-14.1s-18.9 5.4-23.5 14.1z"]
}, faChalkboard = {
  prefix: "fas",
  iconName: "chalkboard",
  icon: [576, 512, ["blackboard"], "f51b", "M96 32C60.7 32 32 60.7 32 96l0 288 64 0L96 96l384 0 0 288 64 0 0-288c0-35.3-28.7-64-64-64L96 32zM224 384l0 32L32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0 0-32c0-17.7-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32z"]
}, faBlackboard = faChalkboard, faUserLargeSlash = {
  prefix: "fas",
  iconName: "user-large-slash",
  icon: [640, 512, ["user-alt-slash"], "f4fa", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L381.9 274c48.5-23.2 82.1-72.7 82.1-130C464 64.5 399.5 0 320 0C250.4 0 192.4 49.3 178.9 114.9L38.8 5.1zM545.5 512L528 512 284.3 320l-59 0C136.2 320 64 392.2 64 481.3c0 17 13.8 30.7 30.7 30.7l450.6 0 .3 0z"]
}, faUserAltSlash = faUserLargeSlash, faSignalStrong = {
  prefix: "fas",
  iconName: "signal-strong",
  icon: [640, 512, ["signal-4"], "f68f", "M480 128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 352c0 17.7 14.3 32 32 32s32-14.3 32-32l0-352zM352 224c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32s32-14.3 32-32l0-256zM192 288c-17.7 0-32 14.3-32 32l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-17.7-14.3-32-32-32zM96 416c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64z"]
}, faSignal4 = faSignalStrong, faLollipop = {
  prefix: "fas",
  iconName: "lollipop",
  icon: [512, 512, [127853, "lollypop"], "e424", "M210.8 334.8C265.3 314.2 304 261.6 304 200l0-8c0-61.9-50.1-112-112-112S80 130.1 80 192c0 39.8 32.2 72 72 72s72-32.2 72-72l0-8c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24c0-35.3 28.7-64 64-64s64 28.7 64 64l0 8c0 53-43 96-96 96l-8 0C94.6 296 48 249.4 48 192c0-79.5 64.5-144 144-144s144 64.5 144 144c0 73.2-54.6 133.6-125.2 142.8zM0 192C0 298 86 384 192 384c41.5 0 79.9-13.1 111.2-35.5L457.4 502.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L348.5 303.2C370.9 271.9 384 233.5 384 192C384 86 298 0 192 0S0 86 0 192z"]
}, faLollypop = faLollipop, faListTree = {
  prefix: "fas",
  iconName: "list-tree",
  icon: [512, 512, [], "e1d2", "M24 48C10.7 48 0 58.7 0 72l0 48c0 13.3 10.7 24 24 24l0 112 0 128c0 30.9 25.1 56 56 56l48 0c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24l-48 0c-4.4 0-8-3.6-8-8l0-104 56 0c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24l-56 0 0-88c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24L24 48zM160 96c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L192 64c-17.7 0-32 14.3-32 32zM288 256c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-160 0c-17.7 0-32 14.3-32 32zm0 160c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-160 0c-17.7 0-32 14.3-32 32z"]
}, faEnvelopeOpen = {
  prefix: "fas",
  iconName: "envelope-open",
  icon: [512, 512, [62135], "f2b6", "M64 208.1L256 65.9 448 208.1l0 47.4L289.5 373c-9.7 7.2-21.4 11-33.5 11s-23.8-3.9-33.5-11L64 255.5l0-47.4zM256 0c-12.1 0-23.8 3.9-33.5 11L25.9 156.7C9.6 168.8 0 187.8 0 208.1L0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-239.9c0-20.3-9.6-39.4-25.9-51.4L289.5 11C279.8 3.9 268.1 0 256 0z"]
}, faDrawCircle = {
  prefix: "fas",
  iconName: "draw-circle",
  icon: [512, 512, [], "f5ed", "M472.1 196.7c-20.8-76-80.7-135.9-156.7-156.7C305.8 16.5 282.8 0 256 0s-49.8 16.5-59.3 39.9c-76 20.8-135.9 80.7-156.7 156.7C16.5 206.2 0 229.2 0 256s16.5 49.8 39.9 59.3c20.8 76 80.7 135.9 156.7 156.7c9.5 23.4 32.5 39.9 59.3 39.9s49.8-16.5 59.3-39.9c76-20.8 135.9-80.7 156.7-156.7c23.4-9.5 39.9-32.5 39.9-59.3s-16.5-49.8-39.9-59.3zM408 206c-14.7 11.7-24 29.8-24 50s9.4 38.3 24 50c-15.8 48.2-53.9 86.2-102 102c-11.7-14.7-29.8-24-50-24s-38.3 9.4-50 24c-48.2-15.8-86.2-53.9-102-102c14.7-11.7 24-29.8 24-50s-9.4-38.3-24-50c15.8-48.2 53.9-86.2 102-102c11.7 14.7 29.8 24 50 24s38.3-9.4 50-24c48.2 15.8 86.2 53.9 102 102z"]
}, faCatSpace = {
  prefix: "fas",
  iconName: "cat-space",
  icon: [640, 512, [], "e001", "M576 160c0 70.7-57.3 128-128 128s-128-57.3-128-128c0-32.5 12.1-62.1 32-84.7l0 84.7c0 53 43 96 96 96s96-43 96-96l0-84.7c19.9 22.6 32 52.2 32 84.7zM411.2 89.6L381.8 50.4C401.1 38.7 423.8 32 448 32s46.9 6.7 66.2 18.4L484.8 89.6c-3 4-7.8 6.4-12.8 6.4l-48 0c-5 0-9.8-2.4-12.8-6.4zM480 316.8C553 302 608 237.4 608 160C608 71.6 536.4 0 448 0S288 71.6 288 160c0 11.7 1.3 23.1 3.6 34.1c-54.9 8.1-102.2 39.5-131.6 83.8l0-85.3c0-48.4-36.1-89.3-84.1-95.3l-7.9-1C50.4 94.1 34.4 106.5 32.2 124s10.2 33.5 27.8 35.7l7.9 1c16 2 28 15.6 28 31.8L96 416c0 53 43 96 96 96l144 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-56 0L416 339.2 416 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-163.2zM400 160a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm80-16a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM231.5 12.3c-2.6-7-12.4-7-15 0L205.8 41.1c-.8 2.2-2.5 3.9-4.7 4.7L172.3 56.5c-7 2.6-7 12.4 0 15l28.8 10.7c2.2 .8 3.9 2.5 4.7 4.7l10.7 28.8c2.6 7 12.4 7 15 0l10.7-28.8c.8-2.2 2.5-3.9 4.7-4.7l28.8-10.7c7-2.6 7-12.4 0-15L246.9 45.8c-2.2-.8-3.9-2.5-4.7-4.7L231.5 12.3z"]
}, faHandshakeSimpleSlash = {
  prefix: "fas",
  iconName: "handshake-simple-slash",
  icon: [640, 512, ["handshake-alt-slash"], "e05f", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7l-135-105.8c-1.1-11.4-6.3-22.3-15.3-30.7l-134.2-123-23.4 18.2-26-20.3 77.2-60.1c7-5.4 17-4.2 22.5 2.8s4.2 17-2.8 22.5l-20.9 16.2L550.2 352l41.8 0c26.5 0 48-21.5 48-48l0-128c0-26.5-21.5-48-48-48l-76 0-4 0-.7 0-3.9-2.5L434.8 79c-15.3-9.8-33.2-15-51.4-15c-21.8 0-43 7.5-60 21.2l-89.7 72.6-25.8-20.3 81.8-66.2c-11.6-4.9-24.1-7.4-36.8-7.4C234 64 215.7 69.6 200 80l-35.5 23.7L38.8 5.1zM0 176L0 304c0 26.5 21.5 48 48 48l108.2 0 91.4 83.4c19.6 17.9 49.9 16.5 67.8-3.1c5.5-6.1 9.2-13.2 11.1-20.6l17 15.6c19.5 17.9 49.9 16.6 67.8-2.9c.8-.8 1.5-1.7 2.2-2.6L41.2 128.5C17.9 131.8 0 151.8 0 176z"]
}, faHandshakeAltSlash = faHandshakeSimpleSlash, faRabbitRunning = {
  prefix: "fas",
  iconName: "rabbit-running",
  icon: [576, 512, ["rabbit-fast"], "f709", "M460.7 39.3l-2.2-2.1c-4.7-4.6-11.5-6.4-17.9-4.7s-11.4 6.6-13.1 13l-.8 2.9c-3.3 11.8-5.1 23.7-5.5 35.6c24.3 20.6 42.9 47.8 53.3 78.8c-8.2-1.9-16.5-2.9-25-2.9c-.6 0-1.1 0-1.7 0c-18.4-44-56.5-77.4-103.6-89.3l-3.4-.9c-6.2-1.6-12.9-.6-18.5 2.6c-10.8 6.2-15.6 19.5-11.2 31.1c14.9 39.5 44.3 71.4 81.4 89.7c-3.7 6.6-6.4 14-7.6 21.8L279.7 154.9C248.8 137.3 213.8 128 178.2 128c-32.3 0-62.2 16.8-78.9 44.4C89 159.9 73.4 152 56 152c-30.9 0-56 25.1-56 56s25.1 56 56 56c11.3 0 21.8-3.3 30.6-9.1c4.9 17.2 14.5 33.1 28.4 45.9L257.2 431.2C269 442 284.4 448 300.4 448L416 448c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0-16.8 0L320 384l0-43.5c0-42.9-28.4-80.5-69.6-92.3l-30.8-8.8c-8.5-2.4-13.4-11.3-11-19.8s11.3-13.4 19.8-11l30.8 8.8c55 15.7 92.8 65.9 92.8 123.1l0 15.7 56-32.4 6.4-3.7 101.3 0c33.3 0 60.3-27 60.3-60.3c0-18.1-8.2-35.3-22.2-46.7l-34.6-28.2c-4.6-3.7-9.4-7.1-14.5-10c8.4-49.3-7.8-100-43.9-135.5zm-318.5 382c-14.7 9.8-18.7 29.7-8.9 44.4s29.7 18.7 44.4 8.9l46-30.7-48.6-44.5-32.9 22zM480 240a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]
}, faRabbitFast = faRabbitRunning, faMemoPad = {
  prefix: "fas",
  iconName: "memo-pad",
  icon: [448, 512, [], "e1da", "M0 64L0 96l448 0 0-32c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zm0 64L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320L0 128zm96 96c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16z"]
}, faMattressPillow = {
  prefix: "fas",
  iconName: "mattress-pillow",
  icon: [640, 512, [], "e525", "M256 64L64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l192 0 0-384zm32 384l288 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L288 64l0 384zM64 160c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 192c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-192z"]
}, faAlarmPlus = {
  prefix: "fas",
  iconName: "alarm-plus",
  icon: [512, 512, [], "f844", "M14.9 146.4C5.5 131.6 0 114 0 95.2C0 42.6 42.6 0 95.2 0c25 0 47.8 9.6 64.8 25.4L14.9 146.4zM390.2 467.4C352.8 495.4 306.3 512 256 512s-96.8-16.6-134.1-44.6L86.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l35.2-35.2C48.6 384.8 32 338.3 32 288C32 164.3 132.3 64 256 64s224 100.3 224 224c0 50.3-16.6 96.8-44.6 134.2l35.2 35.2c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-35.2-35.2zM352 25.4C369 9.6 391.8 0 416.8 0C469.4 0 512 42.6 512 95.2c0 18.8-5.5 36.3-14.9 51.1L352 25.4zM256 176c-13.3 0-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24z"]
}, faAlicorn = {
  prefix: "fas",
  iconName: "alicorn",
  icon: [640, 512, [], "f6b0", "M448 160l0 78.1 0 1.9s0 0 0 0c-.5 30-12.8 56.4-32 75.7L416 480c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-133.3c-4.1-.7-8.2-1.6-12.3-2.8l-84-24c.2 2.3 .3 4.6 .3 6.9c0 18.6-7.4 36.5-20.6 49.7l-12.7 12.7c-4.8 4.8-6.4 11.8-4.3 18.2l20.8 62.5c6.9 20.7-8.5 42.1-30.4 42.1l-33.7 0c-13.8 0-26-8.8-30.4-21.9L95.3 437.7c-10.6-31.7-6.5-65.9 10-93.9c7.6-12.9 9.5-29.1 1.2-41.6L78.2 259.9c-7.3-11-11.9-23.4-13.6-36.4C54.6 230.8 48 242.6 48 256l0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56c0-44.6 33.2-81.5 76.3-87.2c13-21.4 35.2-36.5 61.1-40c3.8 15.3 9.2 29.8 16.5 43c11.3 20.4 27.4 37.7 49.9 49.8c6.3 3.4 13.1 6.4 20.3 8.8c-16.5-11.4-28.9-26-38.2-42.7C163.8 147.9 160 96.1 160 48c0-5.9 3.2-11.3 8.5-14.1s11.5-2.5 16.4 .8L320 124.8C321.7 55.6 378.4 0 448 0l16 0 16 0 64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-5.7 0c5.2 4.6 9.6 10 13.1 16l79.3 0c5.1 0 9.3 4.2 9.3 9.3c0 4-2.6 7.6-6.4 8.8L560 90.7l0 64.8c0 22.1-13.4 41.9-33.9 50.1c-26.1 10.4-55.7-.9-68.3-26L448 160zm64-80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]
}, faCommentQuestion = {
  prefix: "fas",
  iconName: "comment-question",
  icon: [512, 512, [], "e14b", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM169.8 149.3c7.9-22.3 29.1-37.3 52.8-37.3l58.3 0c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L280 248.4c-.2 13-10.9 23.6-24 23.6c-13.3 0-24-10.7-24-24l0-13.5c0-8.6 4.6-16.5 12.1-20.8l44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1l-58.3 0c-3.4 0-6.4 2.1-7.5 5.3l-.4 1.2c-4.4 12.5-18.2 19-30.6 14.6s-19-18.2-14.6-30.6l.4-1.2zM224 336a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faGingerbreadMan = {
  prefix: "fas",
  iconName: "gingerbread-man",
  icon: [448, 512, [], "f79d", "M296.9 158.5c-5.2 6-1.2 17.5 6.7 17.5l64.4 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-20.9 0c-19 0-29.4 22.2-17.2 36.7L385.2 407c22.6 27.2 19 67.5-8.2 90.1s-67.5 19-90.1-8.2l-45.6-54.8c-9-10.7-25.5-10.7-34.4 0L161.2 489c-22.6 27.2-63 30.8-90.1 8.2s-30.8-63-8.2-90.1l55.2-66.3c12.2-14.6 1.8-36.7-17.2-36.7L80 304c-35.3 0-64-28.7-64-64s28.7-64 64-64l64.4 0c7.9 0 11.9-11.5 6.7-17.5C136.7 141.7 128 119.9 128 96c0-53 43-96 96-96s96 43 96 96c0 23.9-8.7 45.7-23.1 62.5zM192 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM224 240a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16 112a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-16-48a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]
}, faGuaraniSign = {
  prefix: "fas",
  iconName: "guarani-sign",
  icon: [384, 512, [], "e19a", "M192 0c-17.7 0-32 14.3-32 32l0 34.7C69.2 81.9 0 160.9 0 256s69.2 174.1 160 189.3l0 34.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-34.7c90.8-15.2 160-94.2 160-189.3c0-17.7-14.3-32-32-32l-128 0 0-92c22.1 5.7 41.8 17.1 57.6 32.6c12.6 12.4 32.9 12.2 45.3-.4s12.2-32.9-.5-45.3C299 92 263.5 73.3 224 66.7L224 32c0-17.7-14.3-32-32-32zM160 132L160 380c-55.2-14.2-96-64.3-96-124s40.8-109.8 96-124zM224 380l0-92 92 0c-11.6 45-47 80.4-92 92z"]
}, faBurgerFries = {
  prefix: "fas",
  iconName: "burger-fries",
  icon: [640, 512, [], "e0cd", "M183.2 1.7c-5-2.5-10.8-2.2-15.6 .7S160 10.5 160 16l0 190.7s0 0 0 0l0 63.2c9.2 1.4 19.8 2.2 32 2.2s22.8-.8 32-2.2l0-238c-.1-6-3.5-11.4-8.8-14.1l-32-16zM128 14.7l-.2-1.3c-.8-5-4-9.3-8.5-11.6s-9.9-2.3-14.4-.1l-32 16c-6.3 3.1-9.8 10-8.6 16.9l32 192c.5 1.2 .9 2.3 1.2 3.4c2 6.3 6.7 15.9 18.7 24.3c3.2 2.2 7.1 4.5 11.8 6.6l0-246.3zM40.3 85.6L19.9 80.5c-5.3-1.3-10.8 .1-14.8 3.8S-.7 93.4 .2 98.8l16.5 93.4c1.6-.1 3.1-.2 4.7-.2L48 192c3.6 0 7 .4 10.2 1L40.3 85.6zM383.8 98.8c.9-5.3-.9-10.8-4.8-14.5s-9.5-5.1-14.8-3.8L346.2 85l-19 107.8c2-.3 4-.6 6.1-.7c11-6.5 23.3-12.3 37.1-17.2l13.4-76.1zM276.3 337.2c-11.8-10.4-19.5-25.3-20.2-42.1c-16.6 5.4-37.6 8.8-64.1 8.8c-91.7 0-117.7-41-125.1-64.3C64.3 231.2 56.8 224 48 224l-26.6 0C9.6 224 0 233.6 0 245.4c0 1.7 .2 3.4 .6 5.1l57.5 237C61.5 501.9 74.4 512 89.2 512L272 512c-10-13.4-16-30-16-48c0-14.7 6.6-27.8 17-36.6c-10.5-11.4-17-26.6-17-43.4c0-18.5 7.8-35.1 20.3-46.8zm-8.5-82.9c.8-.6 1.6-1.1 2.4-1.7c4.1-6.6 9.4-14 16.1-21.6c.1-.3 .2-.6 .3-.9c.7-2.3 1.7-4.7 2.8-7L319.8 50.8c.9-5.3-.9-10.8-4.8-14.5s-9.5-5.1-14.8-3.8l-32 8C262 42 257.3 47 256.2 53.2l-.2 1.4L256 261c4.8-2.1 8.7-4.4 11.8-6.6zm372.2 38c0-3-.5-5.9-1.7-8.6c-8.1-18.4-48.4-91.9-174.3-91.9s-166.2 73.5-174.3 91.9c-1.2 2.7-1.7 5.7-1.7 8.6c0 15.2 12.3 27.5 27.5 27.5l296.9 0c15.2 0 27.5-12.3 27.5-27.5zM384 239.8a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm96 0a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-224 112c-17.7 0-32 14.3-32 32s14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-288 0zm-16 96c-8.8 0-16 7.2-16 16c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48c0-8.8-7.2-16-16-16l-320 0z"]
}, faMugTea = {
  prefix: "fas",
  iconName: "mug-tea",
  icon: [576, 512, [], "f875", "M144 64l0 50.7c0 8.5-3.4 16.6-9.4 22.6l-29.3 29.3c-6 6-9.4 14.1-9.4 22.6L96 256c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-66.7c0-8.5-3.4-16.6-9.4-22.6l-29.3-29.3c-6-6-9.4-14.1-9.4-22.6L176 64l208 0 64 0c70.7 0 128 57.3 128 128s-57.3 128-128 128l-32 0 0 32c0 53-43 96-96 96l-192 0c-53 0-96-43-96-96L32 96c0-17.7 14.3-32 32-32l80 0zM416 256l32 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-32 0 0 128z"]
}, faBorderTop = {
  prefix: "fas",
  iconName: "border-top",
  icon: [448, 512, [], "f855", "M0 64C0 46.3 14.3 32 32 32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64zm64 96A32 32 0 1 1 0 160a32 32 0 1 1 64 0zm320 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-128 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM0 352a32 32 0 1 1 64 0A32 32 0 1 1 0 352zm448 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-256 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM64 256A32 32 0 1 1 0 256a32 32 0 1 1 64 0zm320 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-128 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM0 448a32 32 0 1 1 64 0A32 32 0 1 1 0 448zm448 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-256 0a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM160 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM96 448a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm256 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM288 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faArrowsRotate = {
  prefix: "fas",
  iconName: "arrows-rotate",
  icon: [512, 512, [128472, "refresh", "sync"], "f021", "M105.1 202.6c7.7-21.8 20.2-42.3 37.8-59.8c62.5-62.5 163.8-62.5 226.3 0L386.3 160 352 160c-17.7 0-32 14.3-32 32s14.3 32 32 32l111.5 0c0 0 0 0 0 0l.4 0c17.7 0 32-14.3 32-32l0-112c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 35.2L414.4 97.6c-87.5-87.5-229.3-87.5-316.8 0C73.2 122 55.6 150.7 44.8 181.4c-5.9 16.7 2.9 34.9 19.5 40.8s34.9-2.9 40.8-19.5zM39 289.3c-5 1.5-9.8 4.2-13.7 8.2c-4 4-6.7 8.8-8.1 14c-.3 1.2-.6 2.5-.8 3.8c-.3 1.7-.4 3.4-.4 5.1L16 432c0 17.7 14.3 32 32 32s32-14.3 32-32l0-35.1 17.6 17.5c0 0 0 0 0 0c87.5 87.4 229.3 87.4 316.7 0c24.4-24.4 42.1-53.1 52.9-83.8c5.9-16.7-2.9-34.9-19.5-40.8s-34.9 2.9-40.8 19.5c-7.7 21.8-20.2 42.3-37.8 59.8c-62.5 62.5-163.8 62.5-226.3 0l-.1-.1L125.6 352l34.4 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L48.4 288c-1.6 0-3.2 .1-4.8 .3s-3.1 .5-4.6 1z"]
}, faRefresh = faArrowsRotate, faSync = faArrowsRotate, faCircleBookOpen = {
  prefix: "fas",
  iconName: "circle-book-open",
  icon: [512, 512, ["book-circle"], "e0ff", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 336c-23.1 0-41 11.1-46.3 14.8c-1.1 .8-2.4 1.2-3.7 1.2c-3.3 0-5.9-2.7-5.9-5.9l0-160.7c0-5.8 3.1-11.1 8.3-13.5c10.4-4.7 29.1-11.9 47.7-11.9s37.2 7.1 47.7 11.9c5.2 2.4 8.3 7.7 8.3 13.5l0 160.7c0 3.3-2.7 5.9-5.9 5.9c-1.3 0-2.6-.4-3.7-1.2C225 347.1 207.1 336 184 336zm144 0c-23.1 0-41 11.1-46.3 14.8c-1.1 .8-2.4 1.2-3.7 1.2c-3.3 0-5.9-2.7-5.9-5.9l0-160.7c0-5.8 3.1-11.1 8.3-13.5c10.4-4.7 29.1-11.9 47.7-11.9s37.2 7.1 47.7 11.9c5.2 2.4 8.3 7.7 8.3 13.5l0 160.7c0 3.3-2.7 5.9-5.9 5.9c-1.3 0-2.6-.4-3.7-1.2C369 347.1 351.1 336 328 336z"]
}, faBookCircle = faCircleBookOpen, faArrowsToDottedLine = {
  prefix: "fas",
  iconName: "arrows-to-dotted-line",
  icon: [448, 512, [], "e0a6", "M256 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-32 0c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8l-32 0 0-32zM201.4 329.4l-64 64c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l32 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-64-64c-12.5-12.5-32.8-12.5-45.3 0zM32 224a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm96 0a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm96 64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96-64a32 32 0 1 0 0 64 32 32 0 1 0 0-64zm64 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z"]
}, faFireExtinguisher = {
  prefix: "fas",
  iconName: "fire-extinguisher",
  icon: [512, 512, [129519], "f134", "M500.3 7.3C507.7 13.3 512 22.4 512 32l0 96c0 9.6-4.3 18.7-11.7 24.7s-17.2 8.5-26.6 6.6l-160-32C301.5 124.9 292 115.7 289 104l-65 0 0 34.8c37.8 18 64 56.5 64 101.2l0 144L64 384l0-144c0-44.7 26.2-83.2 64-101.2l0-28.8c-36.2 11.1-66 36.9-82.3 70.5c-5.8 11.9-20.2 16.9-32.1 11.1S-3.3 171.4 2.5 159.5C26.7 109.8 72.7 72.6 128 60.4L128 32c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 24 65 0c3-11.7 12.5-20.9 24.7-23.4l160-32c9.4-1.9 19.1 .6 26.6 6.6zM288 416l0 32c0 35.3-28.7 64-64 64l-96 0c-35.3 0-64-28.7-64-64l0-32 224 0zM176 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]
}, faMagnifyingGlassArrowsRotate = {
  prefix: "fas",
  iconName: "magnifying-glass-arrows-rotate",
  icon: [512, 512, [], "e65e", "M73.8 155.6C69 168 57.3 175.7 44.7 176l-1.5 0c-3.6-.1-7.3-.8-10.9-2.2c-16.5-6.4-24.6-25-18.2-41.4C44.4 54.9 119.8 0 208 0c52.9 0 101.1 19.7 137.8 52.2L375 23c6.9-6.9 17.2-8.9 26.2-5.2s14.8 12.5 14.8 22.2l0 112c0 13.3-10.7 24-24 24l-112 0c-9.7 0-18.5-5.8-22.2-14.8s-1.7-19.3 5.2-26.2l37.4-37.4C275.4 76.6 243.2 64 208 64c-61 0-113.2 37.9-134.2 91.6zM342.2 260.4c4.8-12.4 16.6-20.1 29.1-20.4l1.5 0c3.6 .1 7.3 .8 10.9 2.2c16.5 6.4 24.6 25 18.2 41.4c-6.6 16.9-15.3 32.7-25.8 47.1L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40c-52.9 0-101.1-19.7-137.8-52.2L41 393c-6.9 6.9-17.2 8.9-26.2 5.2S0 385.7 0 376L0 264c0-13.3 10.7-24 24-24l112 0c9.7 0 18.5 5.8 22.2 14.8s1.7 19.3-5.2 26.2l-37.4 37.4c25 21 57.3 33.6 92.5 33.6c61 0 113.2-37.9 134.2-91.6z"]
}, faGarageOpen = {
  prefix: "fas",
  iconName: "garage-open",
  icon: [640, 512, [], "e00b", "M0 171.3L0 488c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-264c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32l0 264c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-316.7c0-26.2-15.9-49.7-40.2-59.4L331.9 4.8c-7.6-3.1-16.1-3.1-23.8 0L40.2 111.9C15.9 121.6 0 145.2 0 171.3zM194.1 320l-5.2 15c-17.2 9.5-28.9 27.9-28.9 49l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-16 192 0 0 16c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-21.1-11.7-39.5-28.9-49l-5.2-15L395 320l2.8 8-155.6 0 2.8-8-50.8 0zM240 376a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm136 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM512 224l-384 0 0 64 384 0 0-64z"]
}, faShelvesEmpty = {
  prefix: "fas",
  iconName: "shelves-empty",
  icon: [640, 512, [], "e246", "M64 32C64 14.3 49.7 0 32 0S0 14.3 0 32L0 192 0 448l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l512 0c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 0-256 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128L64 160 64 32zm0 192l512 0 0 192L64 416l0-192z"]
}, faCruzeiroSign = {
  prefix: "fas",
  iconName: "cruzeiro-sign",
  icon: [448, 512, [], "e152", "M96 256c0-88.4 71.6-160 160-160c41 0 78.3 15.4 106.7 40.7c13.2 11.8 33.4 10.7 45.2-2.5s10.7-33.4-2.5-45.2c-39.6-35.5-92-57-149.3-57C132.3 32 32 132.3 32 256s100.3 224 224 224c57.4 0 109.7-21.6 149.3-57c13.2-11.8 14.3-32 2.5-45.2s-32-14.3-45.2-2.5C334.3 400.6 297 416 256 416l0-96 0-8.7c0-12.8 10.4-23.3 23.3-23.3c4.6 0 9.1 1.4 12.9 3.9l10.1 6.7c14.7 9.8 34.6 5.8 44.4-8.9s5.8-34.6-8.9-44.4l-10.1-6.7c-14.3-9.6-31.2-14.7-48.4-14.7c-12.4 0-24.2 2.6-34.9 7.3c-5.5-4.5-12.6-7.3-20.3-7.3c-17.7 0-32 14.3-32 32l0 55.3 0 8.7 0 82.7C135.5 378 96 321.6 96 256z"]
}, faWatchApple = {
  prefix: "fas",
  iconName: "watch-apple",
  icon: [384, 512, [], "e2cb", "M64 48l256 0c0-26.5-21.5-48-48-48L112 0C85.5 0 64 21.5 64 48zM80 80C35.8 80 0 115.8 0 160L0 352c0 44.2 35.8 80 80 80l224 0c44.2 0 80-35.8 80-80l0-192c0-44.2-35.8-80-80-80L80 80zM192 213.3a42.7 42.7 0 1 1 0 85.3 42.7 42.7 0 1 1 0-85.3zM213.3 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-74.7-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm74.7-160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-74.7-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM64 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm224-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM112 512l160 0c26.5 0 48-21.5 48-48L64 464c0 26.5 21.5 48 48 48z"]
}, faWatchCalculator = {
  prefix: "fas",
  iconName: "watch-calculator",
  icon: [384, 512, [], "f8f0", "M64 48l256 0c0-26.5-21.5-48-48-48L112 0C85.5 0 64 21.5 64 48zM80 80C35.8 80 0 115.8 0 160L0 352c0 44.2 35.8 80 80 80l224 0c44.2 0 80-35.8 80-80l0-192c0-44.2-35.8-80-80-80L80 80zm0 64l224 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16L80 208c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm32 128a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm128-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM88 384a24 24 0 1 1 0-48 24 24 0 1 1 0 48zm128-24a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 24a24 24 0 1 1 0-48 24 24 0 1 1 0 48zM112 512l160 0c26.5 0 48-21.5 48-48L64 464c0 26.5 21.5 48 48 48z"]
}, faListDropdown = {
  prefix: "fas",
  iconName: "list-dropdown",
  icon: [512, 512, [], "e1cf", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM448 192l0 224L64 416l0-224 384 0zM436.7 96c7.1 0 10.7 8.6 5.7 13.7l-36.7 36.7c-3.1 3.1-8.2 3.1-11.3 0l-36.7-36.7c-5-5-1.5-13.7 5.7-13.7l73.4 0zM128 232c-13.3 0-24 10.7-24 24s10.7 24 24 24l256 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-256 0zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24l256 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-256 0z"]
}, faCabinetFiling = {
  prefix: "fas",
  iconName: "cabinet-filing",
  icon: [448, 512, [128452], "f64b", "M0 64C0 28.7 28.7 0 64 0L384 0c35.3 0 64 28.7 64 64l0 176L0 240 0 64zM0 272l448 0 0 176c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 272zM128 128l0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 128 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16c0-17.7-14.3-32-32-32L160 96c-17.7 0-32 14.3-32 32zm0 256l0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16 128 0 0 16c0 8.8 7.2 16 16 16s16-7.2 16-16l0-16c0-17.7-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32z"]
}, faBurgerSoda = {
  prefix: "fas",
  iconName: "burger-soda",
  icon: [640, 512, [], "f858", "M249.3 0c-26 0-48.6 17.9-54.5 43.2l-20 84.8L32 128c-17.7 0-32 14.3-32 32s14.3 32 32 32l301.4 0c14-8.2 30.1-15.4 48.6-20.9c1.3-3.5 2-7.2 2-11.1c0-17.7-14.3-32-32-32l-127.8 0 17.4-73.8c.9-3.6 4.1-6.2 7.8-6.2L280 48c13.3 0 24-10.7 24-24s-10.7-24-24-24L249.3 0zM40 224L60.3 468c2.1 24.9 22.9 44 47.8 44L272 512c-10-13.4-16-30-16-48c0-14.7 6.6-27.8 17-36.6c-10.5-11.4-17-26.6-17-43.4c0-18.5 7.8-35.1 20.3-46.8c-12.4-10.9-20.3-26.9-20.3-44.8c0-6.3 1-13.8 4.4-21.5c4.2-9.5 13.8-27.8 32.2-47L40 224zm600 68.3c0-3-.5-5.9-1.7-8.6c-8.1-18.4-48.4-91.9-174.3-91.9s-166.2 73.5-174.3 91.9c-1.2 2.7-1.7 5.7-1.7 8.6c0 15.2 12.3 27.5 27.5 27.5l296.9 0c15.2 0 27.5-12.3 27.5-27.5zM384 239.8a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm64 0a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm96 0a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm-224 112c-17.7 0-32 14.3-32 32s14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-288 0zm-16 96c-8.8 0-16 7.2-16 16c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48c0-8.8-7.2-16-16-16l-320 0z"]
}, faSquareArrowUp = {
  prefix: "fas",
  iconName: "square-arrow-up",
  icon: [448, 512, ["arrow-square-up"], "f33c", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm177 71L353 215c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-71-71L248 392c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-214.1-71 71c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L207 103c9.4-9.4 24.6-9.4 33.9 0z"]
}, faArrowSquareUp = faSquareArrowUp, faGreaterThanEqual = {
  prefix: "fas",
  iconName: "greater-than-equal",
  icon: [448, 512, [], "f532", "M52.1 93.7C35.7 87.1 27.7 68.5 34.3 52.1s25.2-24.4 41.6-17.8l320 128C408 167.1 416 178.9 416 192s-8 24.9-20.1 29.7l-320 128c-16.4 6.6-35-1.4-41.6-17.8s1.4-35 17.8-41.6L297.8 192 52.1 93.7zM416 416c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0z"]
}, faPalletBox = {
  prefix: "fas",
  iconName: "pallet-box",
  icon: [640, 512, [], "e208", "M176 0l80 0 0 112c0 5.9 3.2 11.3 8.5 14.1s11.5 2.5 16.4-.8L320 99.2l39.1 26.1c4.9 3.3 11.2 3.6 16.4 .8s8.5-8.2 8.5-14.1L384 0l80 0c26.5 0 48 21.5 48 48l0 160c0 26.5-21.5 48-48 48l-288 0c-26.5 0-48-21.5-48-48l0-160c0-26.5 21.5-48 48-48zM0 352c0-17.7 14.3-32 32-32l64 0 224 0 224 0 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 64 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0-224 0L96 512l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-64-32 0c-17.7 0-32-14.3-32-32zm128 96l160 0 0-64-160 0 0 64zm224 0l160 0 0-64-160 0 0 64z"]
}, faFaceConfounded = {
  prefix: "fas",
  iconName: "face-confounded",
  icon: [512, 512, [], "e36c", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM116 205.1c0-9 9.6-14.7 17.5-10.5l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm262.5-10.5c7.9-4.2 17.5 1.5 17.5 10.5c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9zm-161.6 160L256 380.8l39.1-26.1c5.4-3.6 12.4-3.6 17.8 0l40.3 26.8 23.7-11.8c7.9-4 17.5-.7 21.5 7.2s.7 17.5-7.2 21.5l-32 16c-5.1 2.6-11.3 2.2-16-1L304 387.2l-39.1 26.1c-5.4 3.6-12.4 3.6-17.8 0L208 387.2l-39.1 26.1c-4.8 3.2-10.9 3.6-16 1l-32-16c-7.9-4-11.1-13.6-7.2-21.5s13.6-11.1 21.5-7.2l23.7 11.8 40.3-26.8c5.4-3.6 12.4-3.6 17.8 0z"]
}, faShieldHalved = {
  prefix: "fas",
  iconName: "shield-halved",
  icon: [512, 512, ["shield-alt"], "f3ed", "M256 0c4.6 0 9.2 1 13.4 2.9L457.7 82.8c22 9.3 38.4 31 38.3 57.2c-.5 99.2-41.3 280.7-213.6 363.2c-16.7 8-36.1 8-52.8 0C57.3 420.7 16.5 239.2 16 140c-.1-26.2 16.3-47.9 38.3-57.2L242.7 2.9C246.8 1 251.4 0 256 0zm0 66.8l0 378.1C394 378 431.1 230.1 432 141.4L256 66.8s0 0 0 0z"]
}, faShieldAlt = faShieldHalved, faTruckPlow = {
  prefix: "fas",
  iconName: "truck-plow",
  icon: [640, 512, [], "f7de", "M192 96l0 96 135.5 0L269.9 96 192 96zm-64 96l0-112c0-26.5 21.5-48 48-48l93.9 0c22.5 0 43.3 11.8 54.9 31.1L402.1 192l45.9 0c17.7 0 32 14.3 32 32l0 64 32 0 0-112c0-7.3 2.5-14.3 7-20l64-80c11-13.8 31.2-16 45-5s16 31.2 5 45l-57 71.2L576 320l0 36.8L633 428c11 13.8 8.8 33.9-5 45s-33.9 8.8-45-5l-64-80c-4.5-5.7-7-12.7-7-20l0-16-37.5 0c3.5 10 5.5 20.8 5.5 32c0 53-43 96-96 96s-96-43-96-96c0-11.2 1.9-22 5.5-32L224 352c-1.9 0-3.8-.2-5.6-.5c3.7 10.2 5.6 21.1 5.6 32.5c0 53-43 96-96 96s-96-43-96-96c0-11.2 1.9-22 5.5-32L32 352c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l96 0zm32 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm256 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]
}, faBookAtlas = {
  prefix: "fas",
  iconName: "book-atlas",
  icon: [448, 512, ["atlas"], "f558", "M0 96C0 43 43 0 96 0L384 0l32 0c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32l0 64c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0L96 512c-53 0-96-43-96-96L0 96zM64 416c0 17.7 14.3 32 32 32l256 0 0-64L96 384c-17.7 0-32 14.3-32 32zM247.4 283.8c-3.7 3.7-6.2 4.2-7.4 4.2s-3.7-.5-7.4-4.2c-3.8-3.7-8-10-11.8-18.9c-6.2-14.5-10.8-34.3-12.2-56.9l63 0c-1.5 22.6-6 42.4-12.2 56.9c-3.8 8.9-8 15.2-11.8 18.9zm42.7-9.9c7.3-18.3 12-41.1 13.4-65.9l31.1 0c-4.7 27.9-21.4 51.7-44.5 65.9zm0-163.8c23.2 14.2 39.9 38 44.5 65.9l-31.1 0c-1.4-24.7-6.1-47.5-13.4-65.9zM368 192a128 128 0 1 0 -256 0 128 128 0 1 0 256 0zM145.3 208l31.1 0c1.4 24.7 6.1 47.5 13.4 65.9c-23.2-14.2-39.9-38-44.5-65.9zm31.1-32l-31.1 0c4.7-27.9 21.4-51.7 44.5-65.9c-7.3 18.3-12 41.1-13.4 65.9zm56.1-75.8c3.7-3.7 6.2-4.2 7.4-4.2s3.7 .5 7.4 4.2c3.8 3.7 8 10 11.8 18.9c6.2 14.5 10.8 34.3 12.2 56.9l-63 0c1.5-22.6 6-42.4 12.2-56.9c3.8-8.9 8-15.2 11.8-18.9z"]
}, faAtlas = faBookAtlas, faVirus = {
  prefix: "fas",
  iconName: "virus",
  icon: [512, 512, [], "e074", "M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 11.5c0 49.9-60.3 74.9-95.6 39.6L120.2 75C107.7 62.5 87.5 62.5 75 75s-12.5 32.8 0 45.3l8.2 8.2C118.4 163.7 93.4 224 43.5 224L32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l11.5 0c49.9 0 74.9 60.3 39.6 95.6L75 391.8c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l8.2-8.2c35.3-35.3 95.6-10.3 95.6 39.6l0 11.5c0 17.7 14.3 32 32 32s32-14.3 32-32l0-11.5c0-49.9 60.3-74.9 95.6-39.6l8.2 8.2c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-8.2-8.2c-35.3-35.3-10.3-95.6 39.6-95.6l11.5 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-11.5 0c-49.9 0-74.9-60.3-39.6-95.6l8.2-8.2c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-8.2 8.2C348.3 118.4 288 93.4 288 43.5L288 32zM176 224a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm128 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]
}, faGridRound2 = {
  prefix: "fas",
  iconName: "grid-round-2",
  icon: [512, 512, [], "e5db", "M128 32a96 96 0 1 0 0 192 96 96 0 1 0 0-192zm0 256a96 96 0 1 0 0 192 96 96 0 1 0 0-192zM288 128a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm96 160a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"]
}, faCommentMiddleTop = {
  prefix: "fas",
  iconName: "comment-middle-top",
  icon: [512, 512, [], "e14a", "M188.3 103.3l44.5-89C237.2 5.5 246.2 0 256 0s18.8 5.5 23.2 14.3l44.5 89C432.2 127.5 512 208.2 512 304c0 114.9-114.6 208-256 208S0 418.9 0 304c0-95.8 79.8-176.5 188.3-200.7z"]
}, faWave = {
  prefix: "fas",
  iconName: "wave",
  icon: [576, 512, [], "e65b", "M0 336c0-17.7 14.3-32 32-32c35.3 0 64-28.7 64-64C96 125.1 189.1 32 304 32c84.7 0 157.6 50.7 190 123.2c4.7 10.5 1.3 22.8-8.1 29.4s-22.2 5.6-30.4-2.3C441 168.5 421.5 160 400 160c-44.2 0-80 35.8-80 80c0 35.3 28.7 64 64 64c0 0 0 0 0 0c26.9 0 55.4-10.8 77.4-26.1c0 0 0 0 0 0c11.9-8.5 28.1-7.8 39.2 1.7c14.4 11.9 32.5 21 50.6 25.2c15 3.5 25.1 17.1 24.7 31.9l0 41.9c-28.7 0-55.1-8.9-73.8-17.4c-5.5-2.5-10.3-5-14.5-7.2c-4.8-2.6-10.5-2.6-15.3 0c-4.2 2.3-9.1 4.8-14.5 7.2c-18.7 8.5-45.1 17.4-73.8 17.4s-55.1-8.9-73.8-17.4c-5.5-2.5-10.3-5-14.5-7.2c-4.8-2.6-10.5-2.6-15.3 0c-4.2 2.3-9.1 4.8-14.5 7.2c-18.7 8.5-45.1 17.4-73.8 17.4s-55.1-8.9-73.8-17.4c-5.5-2.5-10.3-5-14.5-7.2c-4.8-2.6-10.5-2.6-15.3 0c-4.2 2.3-9.1 4.8-14.5 7.2C55.1 369.7 28.7 378.6 0 378.6L0 336zm0 74.6c35 0 66.1-10.8 87.1-20.3c3.2-1.4 6.1-2.9 8.9-4.3c2.8 1.4 5.8 2.8 8.9 4.3c20.9 9.5 52 20.3 87.1 20.3s66.1-10.8 87.1-20.3c3.2-1.4 6.1-2.9 8.9-4.3c2.8 1.4 5.8 2.8 8.9 4.3c20.9 9.5 52 20.3 87.1 20.3s66.1-10.8 87.1-20.3c3.2-1.4 6.1-2.9 8.9-4.3c2.8 1.4 5.8 2.8 8.9 4.3c21 9.5 52 20.3 87.1 20.3l0 36.6c.1 2.7-.2 5.4-.8 8.1c-4 17.2-21.2 27.9-38.4 23.9c-24.5-5.7-44.9-16.5-58.2-25C449.5 469.7 417 480 384 480c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9c-33 0-65.5-10.3-94.5-25.8c-13.4 8.4-33.7 19.3-58.2 25c-17.2 4-34.4-6.7-38.4-23.9c-.6-2.4-.8-4.9-.8-7.3c0 0 0 0 0 0s0 0 0 0l0-37.4z"]
}, faEnvelopeCircleCheck = {
  prefix: "fas",
  iconName: "envelope-circle-check",
  icon: [640, 512, [], "e4e8", "M48 64C21.5 64 0 85.5 0 112c0 15.1 7.1 29.3 19.2 38.4L236.8 313.6c11.4 8.5 27 8.5 38.4 0l57.4-43c23.9-59.8 79.7-103.3 146.3-109.8l13.9-10.4c12.1-9.1 19.2-23.3 19.2-38.4c0-26.5-21.5-48-48-48L48 64zM294.4 339.2c-22.8 17.1-54 17.1-76.8 0L0 176 0 384c0 35.3 28.7 64 64 64l296.2 0C335.1 417.6 320 378.5 320 336c0-5.6 .3-11.1 .8-16.6l-26.4 19.8zM640 336a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-76.7-43.3c6.2 6.2 6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 353.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0z"]
}, faLayerGroup = {
  prefix: "fas",
  iconName: "layer-group",
  icon: [576, 512, [], "f5fd", "M264.5 5.2c14.9-6.9 32.1-6.9 47 0l218.6 101c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L45.9 149.8C37.4 145.8 32 137.3 32 128s5.4-17.9 13.9-21.8L264.5 5.2zM476.9 209.6l53.2 24.6c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L45.9 277.8C37.4 273.8 32 265.3 32 256s5.4-17.9 13.9-21.8l53.2-24.6 152 70.2c23.4 10.8 50.4 10.8 73.8 0l152-70.2zm-152 198.2l152-70.2 53.2 24.6c8.5 3.9 13.9 12.4 13.9 21.8s-5.4 17.9-13.9 21.8l-218.6 101c-14.9 6.9-32.1 6.9-47 0L45.9 405.8C37.4 401.8 32 393.3 32 384s5.4-17.9 13.9-21.8l53.2-24.6 152 70.2c23.4 10.8 50.4 10.8 73.8 0z"]
}, faRestroomSimple = {
  prefix: "fas",
  iconName: "restroom-simple",
  icon: [640, 512, [], "e23a", "M192 64A64 64 0 1 0 64 64a64 64 0 1 0 128 0zM25.9 233.4l-4.1 49.3c-2.5 29.8 15.7 56.1 42.2 65.6L64 464c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-115.7c26.5-9.5 44.7-35.8 42.2-65.6l-4.1-49.3C226.7 191.9 192 160 150.4 160l-44.8 0c-41.6 0-76.3 31.9-79.7 73.4zM320 0c-13.3 0-24 10.7-24 24l0 464c0 13.3 10.7 24 24 24s24-10.7 24-24l0-464c0-13.3-10.7-24-24-24zM512 128A64 64 0 1 0 512 0a64 64 0 1 0 0 128zm-15.7 32c-28.6 0-53.7 18.9-61.5 46.4L395.7 343.2c-5.8 20.4 9.5 40.8 30.8 40.8l21.6 0 0 80c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-80 21.6 0c21.3 0 36.6-20.3 30.8-40.8L589.3 206.4c-7.8-27.5-33-46.4-61.5-46.4l-31.4 0z"]
}, faArrowsToDot = {
  prefix: "fas",
  iconName: "arrows-to-dot",
  icon: [512, 512, [], "e4be", "M256 0c17.7 0 32 14.3 32 32l0 32 32 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-64 64c-12.5 12.5-32.8 12.5-45.3 0l-64-64c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8l32 0 0-32c0-17.7 14.3-32 32-32zM169.4 393.4l64-64c12.5-12.5 32.8-12.5 45.3 0l64 64c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8l-32 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-32 0c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9zM32 224l32 0 0-32c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l64 64c12.5 12.5 12.5 32.8 0 45.3l-64 64c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6l0-32-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm297.4 54.6c-12.5-12.5-12.5-32.8 0-45.3l64-64c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6l0 32 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 32c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-64-64zM256 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faBorderOuter = {
  prefix: "fas",
  iconName: "border-outer",
  icon: [448, 512, [], "f851", "M64 96l0 320 320 0 0-320L64 96zM0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm224 96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm-64 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64 32a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm128-32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"]
}, faHashtagLock = {
  prefix: "fas",
  iconName: "hashtag-lock",
  icon: [576, 512, [], "e415", "M181.3 32.4c17.4 2.9 29.2 19.4 26.3 36.8L197.8 128l95.1 0 11.5-69.3c2.9-17.4 19.4-29.2 36.8-26.3s29.2 19.4 26.3 36.8L357.8 128l58.2 0c17.7 0 32 14.3 32 32c0 .4 0 .8 0 1.1c-24.1 3.5-45.8 14.6-62.4 30.9l-38.5 0L325.8 320l2.8 0c-5.4 9.4-8.6 20.3-8.6 32l0 32-4.9 0-11.5 69.3c-2.9 17.4-19.4 29.2-36.8 26.3s-29.2-19.4-26.3-36.8l9.8-58.7-95.1 0-11.5 69.3c-2.9 17.4-19.4 29.2-36.8 26.3s-29.2-19.4-26.3-36.8L90.2 384 32 384c-17.7 0-32-14.3-32-32s14.3-32 32-32l68.9 0 21.3-128L64 192c-17.7 0-32-14.3-32-32s14.3-32 32-32l68.9 0 11.5-69.3c2.9-17.4 19.4-29.2 36.8-26.3zM187.1 192L165.8 320l95.1 0 21.3-128-95.1 0zM464 240c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l0-48z"]
}, faClockTwoThirty = {
  prefix: "fas",
  iconName: "clock-two-thirty",
  icon: [512, 512, [], "e35b", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM232 392l0-136c0-8 4-15.5 10.7-20l96-64c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3L280 268.8 280 392c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]
}, faArchway = {
  prefix: "fas",
  iconName: "archway",
  icon: [512, 512, [], "f557", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zm0 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0 64 0 0-128c0-53 43-96 96-96s96 43 96 96l0 128 64 0 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-288L32 128l0 288z"]
}, faHeartCircleCheck = {
  prefix: "fas",
  iconName: "heart-circle-check",
  icon: [576, 512, [], "e4fd", "M47.6 300.4L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9s20.2-3.9 27.7-10.9l2.6-2.4C267.2 438.6 256 404.6 256 368c0-97.2 78.8-176 176-176c28.3 0 55 6.7 78.7 18.5c.9-6.5 1.3-13 1.3-19.6l0-5.8c0-69.9-50.5-129.5-119.4-141C347 36.5 300.6 51.4 268 84L256 96 244 84c-32.6-32.6-79-47.5-124.6-39.9C50.5 55.6 0 115.2 0 185.1l0 5.8c0 41.5 17.2 81.2 47.6 109.5zM576 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zm-76.7-43.3c6.2 6.2 6.2 16.4 0 22.6l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L416 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0z"]
}, faHouseChimneyCrack = {
  prefix: "fas",
  iconName: "house-chimney-crack",
  icon: [576, 512, ["house-damage"], "f6f1", "M575.8 255.5c0 18-15 32.1-32 32.1l-32 0 .7 160.2c.2 35.5-28.5 64.3-64 64.3l-122.1 0L288 448l80.8-67.3c7.8-6.5 7.6-18.6-.4-24.9L250.6 263.2c-14.6-11.5-33.8 7-22.8 22L288 368l-85.5 71.2c-6.1 5-7.5 13.8-3.5 20.5L230.4 512l-102.3 0c-35.3 0-64-28.7-64-64l0-160.4-32 0c-18 0-32-14-32-32.1c0-9 3-17 10-24L266.4 8c7-7 15-8 22-8s15 2 21 7L416 100.7 416 64c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 121 52.8 46.4c8 7 12 15 11 24z"]
}, faHouseDamage = faHouseChimneyCrack, faFileZipper = {
  prefix: "fas",
  iconName: "file-zipper",
  icon: [384, 512, ["file-archive"], "f1c6", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM96 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16zm-6.3 71.8c3.7-14 16.4-23.8 30.9-23.8l14.8 0c14.5 0 27.2 9.7 30.9 23.8l23.5 88.2c1.4 5.4 2.1 10.9 2.1 16.4c0 35.2-28.8 63.7-64 63.7s-64-28.5-64-63.7c0-5.5 .7-11.1 2.1-16.4l23.5-88.2zM112 336c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0z"]
}, faFileArchive = faFileZipper, faTicketPerforated = {
  prefix: "fas",
  iconName: "ticket-perforated",
  icon: [640, 512, [], "e63e", "M0 128C0 92.7 28.7 64 64 64l512 0c35.3 0 64 28.7 64 64l0 48c0 8.8-7.3 15.8-15.8 18c-27.7 7-48.2 32.1-48.2 62s20.5 55 48.2 62c8.6 2.2 15.8 9.1 15.8 18l0 48c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm432 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0 64a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-16 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]
}, faHeartHalf = {
  prefix: "fas",
  iconName: "heart-half",
  icon: [512, 512, [], "e1ab", "M256 96L244 84s0 0 0 0c-32.6-32.6-79-47.5-124.6-39.9C50.5 55.6 0 115.2 0 185.1l0 5.8c0 41.5 17.2 81.2 47.6 109.5L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9l0-50.7 0-265.4L256 96z"]
}, faCommentCheck = {
  prefix: "fas",
  iconName: "comment-check",
  icon: [512, 512, [], "f4ac", "M256 448c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-4.6 4.6-5.9 11.4-3.4 17.4c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9zM369 193L241 321c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 159c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]
}, faSquare = {
  prefix: "fas",
  iconName: "square",
  icon: [448, 512, [9632, 9723, 9724, 61590], "f0c8", "M0 96C0 60.7 28.7 32 64 32H384c35.3 0 64 28.7 64 64V416c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V96z"]
}, faMemo = {
  prefix: "fas",
  iconName: "memo",
  icon: [384, 512, [], "e1d8", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm64 80c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 128c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 224zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 320z"]
}, faMartiniGlassEmpty = {
  prefix: "fas",
  iconName: "martini-glass-empty",
  icon: [512, 512, ["glass-martini"], "f000", "M32 0C19.1 0 7.4 7.8 2.4 19.8s-2.2 25.7 6.9 34.9L224 269.3 224 448l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-178.7L502.6 54.6c9.2-9.2 11.9-22.9 6.9-34.9S492.9 0 480 0L32 0zM256 210.7L109.3 64l293.5 0L256 210.7z"]
}, faGlassMartini = faMartiniGlassEmpty, faCouch = {
  prefix: "fas",
  iconName: "couch",
  icon: [640, 512, [], "f4b8", "M64 160C64 89.3 121.3 32 192 32l256 0c70.7 0 128 57.3 128 128l0 33.6c-36.5 7.4-64 39.7-64 78.4l0 48-384 0 0-48c0-38.7-27.5-71-64-78.4L64 160zM544 272c0-20.9 13.4-38.7 32-45.3c5-1.8 10.4-2.7 16-2.7c26.5 0 48 21.5 48 48l0 176c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L96 448c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 272c0-26.5 21.5-48 48-48c5.6 0 11 1 16 2.7c18.6 6.6 32 24.4 32 45.3l0 48 0 32 32 0 384 0 32 0 0-32 0-48z"]
}, faCediSign = {
  prefix: "fas",
  iconName: "cedi-sign",
  icon: [384, 512, [], "e0df", "M256 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 34.7C101.2 81.9 32 160.9 32 256s69.2 174.1 160 189.3l0 34.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-34.7c30.9-5.2 59.2-17.7 83.2-35.8c14.1-10.6 17-30.7 6.4-44.8s-30.7-17-44.8-6.4c-13.2 9.9-28.3 17.3-44.8 21.6L256 132c16.4 4.2 31.6 11.6 44.8 21.6c14.1 10.6 34.2 7.8 44.8-6.4s7.8-34.2-6.4-44.8c-24-18-52.4-30.6-83.2-35.8L256 32zM192 132L192 380c-55.2-14.2-96-64.3-96-124s40.8-109.8 96-124z"]
}, faItalic = {
  prefix: "fas",
  iconName: "italic",
  icon: [384, 512, [], "f033", "M128 64c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-58.7 0L160 416l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l58.7 0L224 96l-64 0c-17.7 0-32-14.3-32-32z"]
}, faGlassCitrus = {
  prefix: "fas",
  iconName: "glass-citrus",
  icon: [512, 512, [], "f869", "M448 144c0-44.2-35.8-80-80-80c-26.2 0-49.4 12.6-64 32l-71.8 0C252 40.1 305.3 0 368 0c79.5 0 144 64.5 144 144c0 78.4-62.6 142.1-140.5 144l6.5-64.6c39.5-4.9 70-38.6 70-79.4zM249.3 224l-.1 1.3-.9-1.3 1 0zM8.3 138.5C14.3 131.8 23 128 32 128l288 0c9 0 17.7 3.8 23.7 10.5s9 15.7 8.1 24.7L322.7 454.4C319.5 487.1 291.9 512 259 512L93 512c-32.9 0-60.4-24.9-63.7-57.6L.2 163.2c-.9-9 2-18 8.1-24.7zM67.4 192l6.4 64 204.5 0 6.4-64L67.4 192z"]
}, faCalendarLinesPen = {
  prefix: "fas",
  iconName: "calendar-lines-pen",
  icon: [576, 512, [], "e472", "M128 0c17.7 0 32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 48 0c26.5 0 48 21.5 48 48l0 48L0 160l0-48C0 85.5 21.5 64 48 64l48 0 0-32c0-17.7 14.3-32 32-32zM0 192l448 0 0 43.6L289.3 394.3c-8.2 8.2-14 18.5-16.8 29.7l-15 60.1c-2.3 9.4-1.8 19 1.4 27.8L48 512c-26.5 0-48-21.5-48-48L0 192zm120 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0zM96 392c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zM549.8 235.7l14.4 14.4c15.6 15.6 15.6 40.9 0 56.6l-29.4 29.4-71-71 29.4-29.4c15.6-15.6 40.9-15.6 56.6 0zM311.9 417L441.1 287.8l71 71L382.9 487.9c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9z"]
}, faTableCellsColumnLock = {
  prefix: "fas",
  iconName: "table-cells-column-lock",
  icon: [640, 512, [], "e678", "M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 65.1c-37.8 5.4-69.4 29.6-85.2 62.9L360 224l0 64 56 0 0 8.6c-19.1 11.1-32 31.7-32 55.4l-24 0 0 64 24 0 0 64L64 480c-35.3 0-64-28.7-64-64L0 96zm208 0l0 64 88 0 0-64-88 0zm240 0l-88 0 0 64 88 0 0-64zM208 224l0 64 88 0 0-64-88 0zm0 128l0 64 88 0 0-64-88 0zM528 240c-17.7 0-32 14.3-32 32l0 48 64 0 0-48c0-17.7-14.3-32-32-32zm-80 32c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l0-48z"]
}, faChurch = {
  prefix: "fas",
  iconName: "church",
  icon: [640, 512, [9962], "f51d", "M344 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 46.4L183.3 210c-14.5 8.7-23.3 24.3-23.3 41.2L160 512l96 0 0-96c0-35.3 28.7-64 64-64s64 28.7 64 64l0 96 96 0 0-260.8c0-16.9-8.8-32.5-23.3-41.2L344 142.4 344 96l32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-24zM24.9 330.3C9.5 338.8 0 354.9 0 372.4L0 464c0 26.5 21.5 48 48 48l80 0 0-238.4L24.9 330.3zM592 512c26.5 0 48-21.5 48-48l0-91.6c0-17.5-9.5-33.6-24.9-42.1L512 273.6 512 512l80 0z"]
}, faPersonSnowmobiling = {
  prefix: "fas",
  iconName: "person-snowmobiling",
  icon: [640, 512, ["snowmobile"], "f7d1", "M240 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM373.5 85.3c-5.9-11.9-20.3-16.7-32.2-10.7s-16.7 20.3-10.7 32.2l37.4 74.7L360 192l-56 0-61.7-55.6c-11.8-10.6-27-16.4-42.8-16.4l-.9 0c-23.7 0-45.5 13.1-56.6 34.1l-35.3 66.6c-11.4 21.6-9.4 47.8 5.3 67.4l-12.2 0c-12.1 0-23.2 6.8-28.6 17.7l-32 64c-2.5 5-3.6 10.2-3.4 15.2c4-.6 8.1-.9 12.3-.9l224 0c26.2 0 49.4 12.6 64 32l114 0 36 48-46 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l136 0c6.4 0 12.5-2.5 17-7l40-40c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-33 33L546 464l-46-61.3 68.9-45.9c4.5-3 7.1-8 7.1-13.3l0-77.5c0-6.1-3.4-11.6-8.8-14.3L419.8 177.9 373.5 85.3zM298.5 256l13.5 0-24 32-24 0-72-32 32-48 29.3 29.3c12 12 28.3 18.7 45.3 18.7zM48 416c-26.5 0-48 21.5-48 48s21.5 48 48 48l224 0c26.5 0 48-21.5 48-48s-21.5-48-48-48L48 416z"]
}, faSnowmobile = faPersonSnowmobiling, faFaceHushed = {
  prefix: "fas",
  iconName: "face-hushed",
  icon: [512, 512, [], "e37b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176.4 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm128 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM179 160.9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16c-4.4 0-8.8 .3-13 .9zm141-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8c-4.3-.6-8.6-.9-13-.9zM256 336a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]
}, faCommentsDollar = {
  prefix: "fas",
  iconName: "comments-dollar",
  icon: [640, 512, [], "f653", "M416 176c0 97.2-93.1 176-208 176c-38.2 0-73.9-8.7-104.7-23.9c-7.5 4-16 7.9-25.2 11.4C59.8 346.4 37.8 352 16 352c-6.9 0-13.1-4.5-15.2-11.1s.2-13.8 5.8-17.9c0 0 0 0 0 0s0 0 0 0l.2-.2c.2-.2 .6-.4 1.1-.8c1-.8 2.5-2 4.3-3.7c3.6-3.3 8.5-8.1 13.3-14.3c5.5-7 10.7-15.4 14.2-24.7C14.7 250.3 0 214.6 0 176C0 78.8 93.1 0 208 0S416 78.8 416 176zM231.5 383C348.9 372.9 448 288.3 448 176c0-5.2-.2-10.4-.6-15.5C555.1 167.1 640 243.2 640 336c0 38.6-14.7 74.3-39.6 103.4c3.5 9.4 8.7 17.7 14.2 24.7c4.8 6.2 9.7 11 13.3 14.3c1.8 1.6 3.3 2.9 4.3 3.7c.5 .4 .9 .7 1.1 .8l.2 .2s0 0 0 0s0 0 0 0c5.6 4.1 7.9 11.3 5.8 17.9c-2.1 6.6-8.3 11.1-15.2 11.1c-21.8 0-43.8-5.6-62.1-12.5c-9.2-3.5-17.8-7.4-25.2-11.4C505.9 503.3 470.2 512 432 512c-95.6 0-176.2-54.6-200.5-129zM228 72c0-11-9-20-20-20s-20 9-20 20l0 14c-7.6 1.7-15.2 4.4-22.2 8.5c-13.9 8.3-25.9 22.8-25.8 43.9c.1 20.3 12 33.1 24.7 40.7c11 6.6 24.7 10.8 35.6 14l1.7 .5c12.6 3.8 21.8 6.8 28 10.7c5.1 3.2 5.8 5.4 5.9 8.2c.1 5-1.8 8-5.9 10.5c-5 3.1-12.9 5-21.4 4.7c-11.1-.4-21.5-3.9-35.1-8.5c-2.3-.8-4.7-1.6-7.2-2.4c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3c1.9 .6 4 1.3 6.1 2.1c0 0 0 0 0 0s0 0 0 0c8.3 2.9 17.9 6.2 28.2 8.4l0 14.6c0 11 9 20 20 20s20-9 20-20l0-13.8c8-1.7 16-4.5 23.2-9c14.3-8.9 25.1-24.1 24.8-45c-.3-20.3-11.7-33.4-24.6-41.6c-11.5-7.2-25.9-11.6-37.1-15l-.7-.2c-12.8-3.9-21.9-6.7-28.3-10.5c-5.2-3.1-5.3-4.9-5.3-6.7c0-3.7 1.4-6.5 6.2-9.3c5.4-3.2 13.6-5.1 21.5-5c9.6 .1 20.2 2.2 31.2 5.2c10.7 2.8 21.6-3.5 24.5-14.2s-3.5-21.6-14.2-24.5c-6.5-1.7-13.7-3.4-21.1-4.7L228 72z"]
}, faTicketsSimple = {
  prefix: "fas",
  iconName: "tickets-simple",
  icon: [640, 512, [], "e659", "M160 32c-35.3 0-64 28.7-64 64l0 48c0 8.8 7.4 15.7 15.7 18.6C130.5 169.1 144 187 144 208s-13.5 38.9-32.3 45.4C103.4 256.3 96 263.2 96 272l0 48c0 35.3 28.7 64 64 64l416 0c35.3 0 64-28.7 64-64l0-48c0-8.8-7.4-15.7-15.7-18.6C605.5 246.9 592 229 592 208s13.5-38.9 32.3-45.4c8.3-2.9 15.7-9.8 15.7-18.6l0-48c0-35.3-28.7-64-64-64L160 32zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120L0 360c0 66.3 53.7 120 120 120l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-400 0c-39.8 0-72-32.2-72-72l0-240z"]
}, faPickaxe = {
  prefix: "fas",
  iconName: "pickaxe",
  icon: [512, 512, [], "e5bf", "M462.4 373.5s0 0 0 0l-.1-.2-.3-.8c-.3-.7-.7-1.8-1.3-3.3c-1.2-2.9-3-7.2-5.5-12.7c-5-11-12.6-26.7-23.1-45.3c-21-37.3-53.6-86-99.5-132s-94.7-78.5-132-99.5c-18.6-10.5-34.3-18.1-45.3-23.1c-5.5-2.5-9.8-4.3-12.7-5.5c-1.4-.6-2.5-1-3.3-1.3l-.8-.3-.2-.1s0 0 0 0s0 0 0 0c-6.2-2.3-10.4-8.2-10.5-14.8s3.9-12.6 10-15.1C169.5 7 204 0 240 0c59.6 0 114.7 19.2 159.5 51.6l9.4-9.8c6-6.2 14.2-9.7 22.8-9.8s16.9 3.3 22.9 9.4l16 16c6.1 6.1 9.5 14.3 9.4 22.9s-3.6 16.8-9.8 22.8l-9.8 9.4C492.8 157.3 512 212.4 512 272c0 36-7 70.5-19.8 102c-2.5 6.1-8.5 10.1-15.1 10s-12.5-4.3-14.8-10.5c0 0 0 0 0 0zM9.4 502.6C-3 490.3-3.1 470.4 8.9 457.8l272-282.9c9.7 8.4 19.5 17.4 29.1 27s18.6 19.4 27 29.1L54.2 503.1c-12.6 12.1-32.5 11.9-44.8-.4z"]
}, faLinkSimpleSlash = {
  prefix: "fas",
  iconName: "link-simple-slash",
  icon: [640, 512, [], "e1ce", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L532.4 392c45.4-28.2 75.6-78.6 75.6-136c0-88.4-71.6-160-160-160l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c53 0 96 43 96 96c0 43.3-28.6 79.8-67.9 91.8L399.7 288l16.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-97.9 0-81.7-64 19.6 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-11.3 0-22.3 1.2-32.9 3.4L38.8 5.1zM121 191.4L70.7 151.7C46.6 179.7 32 216.1 32 256c0 88.4 71.6 160 160 160l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-53 0-96-43-96-96c0-24.9 9.5-47.6 25-64.6z"]
}, faDemocrat = {
  prefix: "fas",
  iconName: "democrat",
  icon: [640, 512, [], "f747", "M64 32c0-8.9 3.8-20.9 6.2-27.3C71.2 1.8 74 0 77 0c1.9 0 3.8 .7 5.2 2.1L128 45.7 173.8 2.1C175.2 .7 177.1 0 179 0c3 0 5.8 1.8 6.8 4.7c2.4 6.5 6.2 18.4 6.2 27.3c0 26.5-21.9 42-29.5 46.6l76.2 72.6c6 5.7 13.9 8.8 22.1 8.8L480 160l32 0c40.3 0 78.2 19 102.4 51.2l19.2 25.6c10.6 14.1 7.7 34.2-6.4 44.8s-34.2 7.7-44.8-6.4l-19.2-25.6c-5.3-7-11.8-12.8-19.2-17l0 87.4-352 0-40.4-94.3c-3.9-9.2-15.3-12.6-23.6-7l-42.1 28c-9.1 6.1-19.7 9.3-30.7 9.3l-2 0C23.9 256 0 232.1 0 202.7c0-12.1 4.1-23.8 11.7-33.3L87.6 74.6C78.1 67.4 64 53.2 64 32zM448 352l96 0 0 64 0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64-160 0 0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64 0-64 96 0 160 0zM260.9 210.9c-.9-1.8-2.8-2.9-4.8-2.9s-3.9 1.1-4.8 2.9l-10.5 20.5-23.5 3.3c-2 .3-3.7 1.6-4.3 3.5s-.1 3.9 1.3 5.3l17 16-4 22.6c-.3 1.9 .5 3.9 2.1 5s3.8 1.3 5.6 .4l21-10.7 21 10.7c1.8 .9 4 .8 5.6-.4s2.5-3.1 2.1-5l-4-22.6 17-16c1.5-1.4 2-3.4 1.3-5.3s-2.3-3.2-4.3-3.5l-23.5-3.3-10.5-20.5zM368.1 208c-2 0-3.9 1.1-4.8 2.9l-10.5 20.5-23.5 3.3c-2 .3-3.7 1.6-4.3 3.5s-.1 3.9 1.3 5.3l17 16-4 22.6c-.3 1.9 .5 3.9 2.1 5s3.8 1.3 5.6 .4l21-10.7 21 10.7c1.8 .9 4 .8 5.6-.4s2.5-3.1 2.1-5l-4-22.6 17-16c1.5-1.4 2-3.4 1.4-5.3s-2.3-3.2-4.3-3.5l-23.5-3.3-10.5-20.5c-.9-1.8-2.8-2.9-4.8-2.9zm116.8 2.9c-.9-1.8-2.8-2.9-4.8-2.9s-3.9 1.1-4.8 2.9l-10.5 20.5-23.5 3.3c-2 .3-3.7 1.6-4.3 3.5s-.1 3.9 1.3 5.3l17 16-4 22.6c-.3 1.9 .5 3.9 2.1 5s3.8 1.3 5.6 .4l21-10.7 21 10.7c1.8 .9 4 .8 5.6-.4s2.5-3.1 2.1-5l-4-22.6 17-16c1.5-1.4 2-3.4 1.4-5.3s-2.3-3.2-4.3-3.5l-23.5-3.3-10.5-20.5z"]
}, faFaceConfused = {
  prefix: "fas",
  iconName: "face-confused",
  icon: [512, 512, [], "e36d", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM171.1 395.6l-1.1 .9c-6.9 5.5-17 4.4-22.5-2.5s-4.4-17 2.5-22.5l1.1-.9C205 327.5 272 304 341 304l11 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-11 0c-61.8 0-121.7 21-169.9 59.6zM144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm192-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]
}, faPinball = {
  prefix: "fas",
  iconName: "pinball",
  icon: [448, 512, [], "e229", "M352 224a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm22.1 254.4c14.9 4.8 30.7-1.8 37.9-15c7.4-13.5 4.2-30.8-8.4-40.6l-246-208.3c-40.6-34.1-101.2-28.8-135.2 11.8S-6.3 327.5 34.3 361.6c9.2 7.7 19.9 13.8 32 17.7l307.8 99.1zM64 288a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faZ = {
  prefix: "fas",
  iconName: "z",
  icon: [384, 512, [122], "5a", "M0 64C0 46.3 14.3 32 32 32l320 0c12.4 0 23.7 7.2 29 18.4s3.6 24.5-4.4 34.1L100.3 416 352 416c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-12.4 0-23.7-7.2-29-18.4s-3.6-24.5 4.4-34.1L283.7 96 32 96C14.3 96 0 81.7 0 64z"]
}, faPersonSkiing = {
  prefix: "fas",
  iconName: "person-skiing",
  icon: [512, 512, [9975, "skiing"], "f7c9", "M380.7 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM2.7 268.9c6.1-11.8 20.6-16.3 32.4-10.2L232.7 361.3l46.2-69.2-75.1-75.1c-14.6-14.6-20.4-33.9-18.4-52.1l108.8 52 39.3 39.3c16.2 16.2 18.7 41.5 6 60.6L289.8 391l128.7 66.8c13.6 7.1 29.8 7.2 43.6 .3l15.2-7.6c11.9-5.9 26.3-1.1 32.2 10.7s1.1 26.3-10.7 32.2l-15.2 7.6c-27.5 13.7-59.9 13.5-87.2-.7L12.9 301.3C1.2 295.2-3.4 280.7 2.7 268.9zM118.9 65.6L137 74.2l8.7-17.4c4-7.9 13.6-11.1 21.5-7.2s11.1 13.6 7.2 21.5l-8.5 16.9 54.7 26.2c1.5-.7 3.1-1.4 4.7-2.1l83.4-33.4c34.2-13.7 72.8 4.2 84.5 39.2l17.1 51.2 52.1 26.1c15.8 7.9 22.2 27.1 14.3 42.9s-27.1 22.2-42.9 14.3l-58.1-29c-11.4-5.7-20-15.7-24.1-27.8l-5.8-17.3-27.3 12.1-6.8 3-6.7-3.2L151.5 116.7l-9.2 18.4c-4 7.9-13.6 11.1-21.5 7.2s-11.1-13.6-7.2-21.5l9-18-17.6-8.4c-8-3.8-11.3-13.4-7.5-21.3s13.4-11.3 21.3-7.5z"]
}, faSkiing = faPersonSkiing, faDeer = {
  prefix: "fas",
  iconName: "deer",
  icon: [512, 512, [129420], "f78e", "M240 0c8.8 0 16 7.2 16 16l0 24c0 13.3 10.7 24 24 24l8 0 8 0c13.3 0 24-10.7 24-24l0-24c0-8.8 7.2-16 16-16s16 7.2 16 16l0 24c0 8.6-1.9 16.7-5.4 24l30.6 0L416 64c13.3 0 24-10.7 24-24l0-24c0-8.8 7.2-16 16-16s16 7.2 16 16l0 24c0 21.7-12.3 40.4-30.3 49.8c.6 .5 1.1 1.1 1.7 1.6l55.3 55.3c8.5 8.5 13.3 20 13.3 32c0 25-20.3 45.3-45.3 45.3L416 224l-5.3 0L384 304l0 64 0 112c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-112-36.3 0c-28.8 0-55.3-9.8-76.3-26.4c-2.1 16.9-9.8 32.6-21.9 44.8L142.9 397c-4.6 4.6-6.2 11.5-4 17.7l19.3 54.7c7.3 20.8-8.1 42.6-30.2 42.6l-33.9 0c-13.6 0-25.7-8.6-30.2-21.4l-15.5-44c-11.4-32.4-7.4-67.8 10-96.3C65 339.4 65 324.9 56 315.9c-3-3-5.7-6.1-8.1-9.5c-1.3 12.9-12.7 22.5-25.7 21.5C8.9 326.9-.9 315.4 .1 302.2L2.4 272c4.2-54.2 49.3-96 103.7-96l7.9 0 14.1 0 64 0c.6 0 1.2 0 1.7 0c.8 0 1.7 0 2.5 0l106.1 0 9.6-32-38 0c-9.9 0-18-8-18-18c0-8.2 5.6-15.4 13.6-17.4L320 96l-24 0-8 0-8 0c-30.9 0-56-25.1-56-56l0-24c0-8.8 7.2-16 16-16zM400 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]
}, faInputPipe = {
  prefix: "fas",
  iconName: "input-pipe",
  icon: [640, 512, [], "e1be", "M64 128l0 256 512 0 0-256L64 128zM0 128C0 92.7 28.7 64 64 64l512 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zm144 56l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faRoadLock = {
  prefix: "fas",
  iconName: "road-lock",
  icon: [640, 512, [], "e567", "M288 32l-74.8 0c-27.1 0-51.3 17.1-60.3 42.6L35.1 407.2c-2.1 5.9-3.1 12-3.1 18.2C32 455.5 56.5 480 86.6 480L288 480l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64 32 0 0-128c0-23.7 12.9-44.4 32-55.4l0-24.6c0-58.3 44.6-106.2 101.5-111.5L487.1 74.6C478 49.1 453.9 32 426.8 32L352 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm64 192l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm176 16c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]
}, faA = {
  prefix: "fas",
  iconName: "a",
  icon: [384, 512, [97], "41", "M221.5 51.7C216.6 39.8 204.9 32 192 32s-24.6 7.8-29.5 19.7l-120 288-40 96c-6.8 16.3 .9 35 17.2 41.8s35-.9 41.8-17.2L93.3 384l197.3 0 31.8 76.3c6.8 16.3 25.5 24 41.8 17.2s24-25.5 17.2-41.8l-40-96-120-288zM264 320l-144 0 72-172.8L264 320z"]
}, faBookmarkSlash = {
  prefix: "fas",
  iconName: "bookmark-slash",
  icon: [640, 512, [], "e0c2", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L512 376l0-328c0-26.5-21.5-48-48-48L176 0c-26.5 0-48 21.5-48 48l0 27L38.8 5.1zM128 487.7c0 13.4 10.9 24.3 24.3 24.3c5 0 9.9-1.5 14-4.4L320 400 473.7 507.6c4.1 2.9 9 4.4 14 4.4c9.9 0 18.4-5.9 22.2-14.3L128 196.9l0 290.8z"]
}, faTemperatureArrowDown = {
  prefix: "fas",
  iconName: "temperature-arrow-down",
  icon: [576, 512, ["temperature-down"], "e03f", "M128 112c0-26.5 21.5-48 48-48s48 21.5 48 48l0 164.5c0 17.3 7.1 31.9 15.3 42.5C249.8 332.6 256 349.5 256 368c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-18.5 6.2-35.4 16.7-48.9c8.2-10.6 15.3-25.2 15.3-42.5L128 112zM176 0C114.1 0 64 50.1 64 112l0 164.4c0 .1-.1 .3-.2 .6c-.2 .6-.8 1.6-1.7 2.8C43.2 304.2 32 334.8 32 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-33.2-11.2-63.8-30.1-88.1c-.9-1.2-1.5-2.2-1.7-2.8c-.1-.3-.2-.5-.2-.6L288 112C288 50.1 237.9 0 176 0zm0 416c26.5 0 48-21.5 48-48c0-20.9-13.4-38.7-32-45.3l0-50.7c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 50.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48zm336-64l-32 0 0-288c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 288-32 0c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l64 64c6 6 14.1 9.4 22.6 9.4s16.6-3.4 22.6-9.4l64-64c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8z"]
}, faTemperatureDown = faTemperatureArrowDown, faMace = {
  prefix: "fas",
  iconName: "mace",
  icon: [512, 512, [], "f6f8", "M244.8 95l28-84.1C275 4.4 281.1 0 288 0s13 4.4 15.2 10.9l28 84.1c40.4 13.5 72.3 45.4 85.8 85.8l84.1 28c6.5 2.2 10.9 8.3 10.9 15.2s-4.4 13-10.9 15.2l-84.1 28c-13.5 40.4-45.4 72.3-85.8 85.8l-28 84.1C301 443.6 294.9 448 288 448s-13-4.4-15.2-10.9l-28-84.1c-9.8-3.3-19-7.6-27.7-12.9L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L171.9 294.9c-5.3-8.6-9.6-17.9-12.9-27.7l-84.1-28C68.4 237 64 230.9 64 224s4.4-13 10.9-15.2l84.1-28c13.5-40.4 45.4-72.3 85.8-85.8zM288 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]
}, faFeatherPointed = {
  prefix: "fas",
  iconName: "feather-pointed",
  icon: [512, 512, ["feather-alt"], "f56b", "M278.5 215.6L23 471c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l74.8-74.8c7.4 4.6 15.3 8.2 23.8 10.5C200.3 452.8 270 454.5 338 409.4c12.2-8.1 5.8-25.4-8.8-25.4l-16.1 0c-5.1 0-9.2-4.1-9.2-9.2c0-4.1 2.7-7.6 6.5-8.8l97.7-29.3c3.4-1 6.4-3.1 8.4-6.1c4.4-6.4 8.6-12.9 12.6-19.6c6.2-10.3-1.5-23-13.5-23l-38.6 0c-5.1 0-9.2-4.1-9.2-9.2c0-4.1 2.7-7.6 6.5-8.8l80.9-24.3c4.6-1.4 8.4-4.8 10.2-9.3C494.5 163 507.8 86.1 511.9 36.8c.8-9.9-3-19.6-10-26.6s-16.7-10.8-26.6-10C391.5 7 228.5 40.5 137.4 131.6C57.3 211.7 56.7 302.3 71.3 356.4c2.1 7.9 12 9.6 17.8 3.8L253.6 195.8c6.2-6.2 16.4-6.2 22.6 0c5.4 5.4 6.1 13.6 2.2 19.8z"]
}, faFeatherAlt = faFeatherPointed, faSausage = {
  prefix: "fas",
  iconName: "sausage",
  icon: [512, 512, [], "f820", "M320 160c0-42 26.9-77.7 64.5-90.7L369.2 27.4c-.8-2.2-1.2-4.6-1.2-7C368 9.1 377.1 0 388.4 0l55.2 0C454.9 0 464 9.1 464 20.4c0 2.4-.4 4.7-1.2 7L447.5 69.3C485.1 82.3 512 118 512 160c0 194.4-157.6 352-352 352c-42 0-77.7-26.9-90.7-64.5L27.4 462.8c-2.2 .8-4.6 1.2-7 1.2C9.1 464 0 454.9 0 443.6l0-55.2C0 377.1 9.1 368 20.4 368c2.4 0 4.7 .4 7 1.2l41.9 15.2C82.3 346.9 118 320 160 320c88.4 0 160-71.6 160-160zm80 0c0-8.8-7.2-16-16-16s-16 7.2-16 16c0 114.9-93.1 208-208 208c-8.8 0-16 7.2-16 16s7.2 16 16 16c132.5 0 240-107.5 240-240z"]
}, faTrashCanClock = {
  prefix: "fas",
  iconName: "trash-can-clock",
  icon: [576, 512, [], "e2aa", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0L284.2 0c12.1 0 23.2 6.8 28.6 17.7L320 32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 7.2-14.3zM32 128l384 0 0 64.7c-29.3 2.6-56.6 12.5-80 27.7l0-12.5c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 39.2c-29.8 31.5-48 74-48 120.8c0 59.5 29.6 112.1 74.8 144L96 512c-35.3 0-64-28.7-64-64l0-320zm96 64c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16zm96 0c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16zm64 176a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-48c0-8.8-7.2-16-16-16z"]
}, faP = {
  prefix: "fas",
  iconName: "p",
  icon: [320, 512, [112], "50", "M0 96C0 60.7 28.7 32 64 32l96 0c88.4 0 160 71.6 160 160s-71.6 160-160 160l-96 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 320 0 96zM64 288l96 0c53 0 96-43 96-96s-43-96-96-96L64 96l0 192z"]
}, faBroomWide = {
  prefix: "fas",
  iconName: "broom-wide",
  icon: [512, 512, [], "e5d1", "M502.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128-15.8-15.8c-15.2-15.2-38.5-18.4-57.3-8l-32.5 18L380.4 288.1l18-32.5c10.4-18.7 7.1-42.1-8-57.3l-15.8-15.8 128-128c12.5-12.5 12.5-32.8 0-45.3zM187.5 151.8L16.4 246.9C6.3 252.5 0 263.2 0 274.8c0 8.5 3.4 16.6 9.3 22.6l43.2 43.2c2.1 2.1 5.3 2.9 8.2 1.9l52.1-17.4c6.3-2.1 12.2 3.9 10.1 10.1l-17.4 52.1c-1 2.9-.2 6 1.9 8.2L214.7 502.7c6 6 14.1 9.3 22.6 9.3c11.6 0 22.3-6.3 27.9-16.4l95.1-171.1L187.5 151.8z"]
}, faSnowflake = {
  prefix: "fas",
  iconName: "snowflake",
  icon: [448, 512, [10052, 10054], "f2dc", "M224 0c17.7 0 32 14.3 32 32l0 30.1 15-15c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-49 49 0 70.3 61.4-35.8 17.7-66.1c3.4-12.8 16.6-20.4 29.4-17s20.4 16.6 17 29.4l-5.2 19.3 23.6-13.8c15.3-8.9 34.9-3.7 43.8 11.5s3.8 34.9-11.5 43.8l-25.3 14.8 21.7 5.8c12.8 3.4 20.4 16.6 17 29.4s-16.6 20.4-29.4 17l-67.7-18.1L287.5 256l60.9 35.5 67.7-18.1c12.8-3.4 26 4.2 29.4 17s-4.2 26-17 29.4l-21.7 5.8 25.3 14.8c15.3 8.9 20.4 28.5 11.5 43.8s-28.5 20.4-43.8 11.5l-23.6-13.8 5.2 19.3c3.4 12.8-4.2 26-17 29.4s-26-4.2-29.4-17l-17.7-66.1L256 311.7l0 70.3 49 49c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-15-15 0 30.1c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-30.1-15 15c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l49-49 0-70.3-61.4 35.8-17.7 66.1c-3.4 12.8-16.6 20.4-29.4 17s-20.4-16.6-17-29.4l5.2-19.3L48.1 395.6c-15.3 8.9-34.9 3.7-43.8-11.5s-3.7-34.9 11.5-43.8l25.3-14.8-21.7-5.8c-12.8-3.4-20.4-16.6-17-29.4s16.6-20.4 29.4-17l67.7 18.1L160.5 256 99.6 220.5 31.9 238.6c-12.8 3.4-26-4.2-29.4-17s4.2-26 17-29.4l21.7-5.8L15.9 171.6C.6 162.7-4.5 143.1 4.4 127.9s28.5-20.4 43.8-11.5l23.6 13.8-5.2-19.3c-3.4-12.8 4.2-26 17-29.4s26 4.2 29.4 17l17.7 66.1L192 200.3l0-70.3L143 81c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l15 15L192 32c0-17.7 14.3-32 32-32z"]
}, faStomach = {
  prefix: "fas",
  iconName: "stomach",
  icon: [512, 512, [], "f623", "M192 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 70.7 57.3 128 128 128l0 64c0 35.3-28.7 64-64 64l-64 0C57.3 352 0 409.3 0 480c0 17.7 14.3 32 32 32s32-14.3 32-32c0-26.5 21.5-48 48-48c24.6 0 36 9.5 58.2 28.2c0 0 0 0 0 0c1.7 1.4 3.4 2.9 5.3 4.4c12.6 10.5 28.4 22.9 49.6 32.2C246.5 506.2 272 512 304 512c114.9 0 208-93.1 208-208l0-80c0-70.7-57.3-128-128-128c-47.4 0-88.7 25.7-110.9 64L256 160c-35.3 0-64-28.7-64-64l0-64zM445.1 332.7c-7.2 1.9-14.6 3.3-21.1 3.3c-16.8 .2-28.4-7.9-40-16s-23.2-16.3-40-16c-7.9 .1-17.1 2.1-25.6 4.6c1.1-6.7 1.6-13.6 1.6-20.6l0-64c0-35.3 28.7-64 64-64s64 28.7 64 64l0 80c0 9.8-1 19.4-2.9 28.7z"]
}, faNewspaper = {
  prefix: "fas",
  iconName: "newspaper",
  icon: [512, 512, [128240], "f1ea", "M96 96c0-35.3 28.7-64 64-64l288 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L80 480c-44.2 0-80-35.8-80-80L0 128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 272c0 8.8 7.2 16 16 16s16-7.2 16-16L96 96zm64 24l0 80c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24l0-80c0-13.3-10.7-24-24-24L184 96c-13.3 0-24 10.7-24 24zm208-8c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zm0 96c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zM160 304c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-256 0c-8.8 0-16 7.2-16 16zm0 96c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-256 0c-8.8 0-16 7.2-16 16z"]
}, faRectangleAd = {
  prefix: "fas",
  iconName: "rectangle-ad",
  icon: [576, 512, ["ad"], "f641", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM229.5 173.3l72 144c5.9 11.9 1.1 26.3-10.7 32.2s-26.3 1.1-32.2-10.7L253.2 328l-90.3 0-5.4 10.7c-5.9 11.9-20.3 16.7-32.2 10.7s-16.7-20.3-10.7-32.2l72-144c4.1-8.1 12.4-13.3 21.5-13.3s17.4 5.1 21.5 13.3zM208 237.7L186.8 280l42.3 0L208 237.7zM392 256a24 24 0 1 0 0 48 24 24 0 1 0 0-48zm24-43.9l0-28.1c0-13.3 10.7-24 24-24s24 10.7 24 24l0 96 0 48c0 13.3-10.7 24-24 24c-6.6 0-12.6-2.7-17-7c-9.4 4.5-19.9 7-31 7c-39.8 0-72-32.2-72-72s32.2-72 72-72c8.4 0 16.5 1.4 24 4.1z"]
}, faAd = faRectangleAd, faGuitarElectric = {
  prefix: "fas",
  iconName: "guitar-electric",
  icon: [512, 512, [127928], "f8be", "M352 81.1l0 33.6L243.8 223c-14.6-26.1-5.5-50.4 3.2-64.7c4.8-7.9 4.8-18.7-1.7-25.3s-17.1-6.6-23.6 0l-29.9 30.2c-9.1 9.2-14.7 21.5-20.2 33.5c0 0 0 0 0 0s0 0 0 0c-1.2 2.6-2.3 5.1-3.5 7.6c-3.5 7.3-8.9 15.7-17.1 24c-24.7 25-64.7 40.2-89.6 47.7c-14.5 4.4-28.1 11.7-38.7 22.4c-30 30.4-30 79.6 0 110l79.9 80.8c30 30.4 78.7 30.4 108.8 0c10.7-10.8 17.9-24.5 22.2-39.2c7.5-25.2 22.5-65.6 47.2-90.6c10-10.1 20-16 28.3-19.3l1.1-.5s0 0 0 0c11.3-4.6 23-9.4 31.6-18l21.6-21.8c6.5-6.6 6.5-17.3 0-23.8s-17.3-6.6-25.8-3c-11.1 4.7-28 7.3-48.3-4.7L461.3 96l2.7 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-1.1 0c-9.7 0-19.2 2.9-27.3 8.3L366.2 54.5C357.3 60.4 352 70.4 352 81.1zM195.3 268.7l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-64 64l48 48c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-48-48c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z"]
}, faArrowTurnDownRight = {
  prefix: "fas",
  iconName: "arrow-turn-down-right",
  icon: [512, 512, [], "e3d6", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 224c0 53 43 96 96 96l306.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L402.7 256 96 256c-17.7 0-32-14.3-32-32L64 64z"]
}, faMoonCloud = {
  prefix: "fas",
  iconName: "moon-cloud",
  icon: [640, 512, [], "f754", "M479.5 32c-118.2 0-214.9 92-223 208.3C310 244.7 352 289.4 352 344c0 27.9-11 53.3-29 72c40.3 39.6 95.5 64 156.4 64c60.6 0 115.5-24.2 155.8-63.4c5-4.9 6.3-12.5 3.1-18.7s-10.1-9.7-17-8.5c-9.8 1.7-19.8 2.6-30.1 2.6c-96.9 0-175.5-78.8-175.5-176c0-65.8 36-123.1 89.3-153.3c6.1-3.5 9.2-10.5 7.7-17.3s-7.3-11.9-14.3-12.5c-6.2-.5-12.6-.8-19-.8zM64 416l184 0c39.8 0 72-32.2 72-72s-32.2-72-72-72c-10.1 0-19.7 2.1-28.4 5.8C208.8 246.5 179 224 144 224c-38.7 0-71 27.5-78.4 64c-.5 0-1.1 0-1.6 0c-35.3 0-64 28.7-64 64s28.7 64 64 64z"]
}, faBreadSliceButter = {
  prefix: "fas",
  iconName: "bread-slice-butter",
  icon: [512, 512, [], "e3e1", "M0 192C0 64 192 32 256 32s256 32 256 160c0 35.3-28.7 64-64 64l0 176c0 26.5-21.5 48-48 48l-288 0c-26.5 0-48-21.5-48-48l0-176c-35.3 0-64-28.7-64-64zm182.6 73.4c-12.5 12.5-12.5 32.8 0 45.3l50.7 50.7c12.5 12.5 32.8 12.5 45.3 0l50.7-50.7c12.5-12.5 12.5-32.8 0-45.3l-50.7-50.7c-12.5-12.5-32.8-12.5-45.3 0l-50.7 50.7z"]
}, faCircleArrowRight = {
  prefix: "fas",
  iconName: "circle-arrow-right",
  icon: [512, 512, ["arrow-circle-right"], "f0a9", "M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM297 385c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l71-71L120 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l214.1 0-71-71c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L409 239c9.4 9.4 9.4 24.6 0 33.9L297 385z"]
}, faArrowCircleRight = faCircleArrowRight, faUserGroupCrown = {
  prefix: "fas",
  iconName: "user-group-crown",
  icon: [640, 512, ["users-crown"], "f6a5", "M144 144l0-16 160 0 0 16c0 44.2-35.8 80-80 80s-80-35.8-80-80zm-.1-124.9c-.3-.2-.6-.4-.8-.6L140 16 124.4 3.5C121.5 1.2 118 0 114.4 0L112 0c-8.8 0-16 7.2-16 16l0 23 0 3.2c0 0 0 .1 0 .1L96 144c0 70.7 57.3 128 128 128s128-57.3 128-128l0-101.7c0 0 0-.1 0-.1l0-3.2 0-23c0-8.8-7.2-16-16-16l-2.4 0c-3.6 0-7.2 1.2-10 3.5L308 16l-3 2.4c-.3 .2-.6 .4-.8 .6l-.1 .1c-10.2 7.5-23.8 8.3-34.9 2L238.9 4c-4.6-2.6-9.7-4-14.9-4s-10.4 1.4-14.9 4L178.9 21.2c-11 6.3-24.7 5.5-34.9-2l-.1-.1zM168 304C75.2 304 0 379.2 0 472l0 8c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-8c0-92.8-75.2-168-168-168l-112 0zm264-48c61.9 0 112-50.1 112-112s-50.1-112-112-112c-17.2 0-33.5 3.9-48 10.8L384 144c0 5.4-.3 10.7-.8 16c-2.4 24.3-10.3 47.1-22.4 67c-.5 .8-1 1.6-1.4 2.3C379 245.9 404.3 256 432 256zm39.4 256l137.8 0c17 0 30.7-13.8 30.7-30.7C640 392.2 567.8 320 478.7 320l-61.4 0c-2.4 0-4.8 .1-7.1 .2C452.9 356.8 480 411.3 480 472l0 8c0 11.7-3.1 22.6-8.6 32z"]
}, faUsersCrown = faUserGroupCrown, faCircleI = {
  prefix: "fas",
  iconName: "circle-i",
  icon: [512, 512, [], "e111", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM184 128l72 0 72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 160 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-160-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]
}, faToiletPaperCheck = {
  prefix: "fas",
  iconName: "toilet-paper-check",
  icon: [640, 512, [], "e5b2", "M444.2 0C397.2 49.6 384 126.5 384 192c0 158.8-27.3 247-42.7 283.9c-10 24-33.2 36.1-55.4 36.1L48 512c-11.5 0-22.2-6.2-27.8-16.2s-5.6-22.3 .4-32.2c9.8-17.7 15.4-38.2 20.5-57.7C52.3 362.8 64 293.5 64 192C64 86 107 0 160 0L444.2 0zM512 384c-53 0-96-86-96-192S459 0 512 0s96 86 96 192s-43 192-96 192zm0-128c17.7 0 32-28.7 32-64s-14.3-64-32-64s-32 28.7-32 64s14.3 64 32 64zM291.3 187.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L208 225.4l-28.7-28.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c6.2 6.2 16.4 6.2 22.6 0l72-72z"]
}, faFilterCircleXmark = {
  prefix: "fas",
  iconName: "filter-circle-xmark",
  icon: [576, 512, [], "e17b", "M3.9 22.9C10.5 8.9 24.5 0 40 0L472 0c15.5 0 29.5 8.9 36.1 22.9s4.6 30.5-5.2 42.5L396.4 195.6C316.2 212.1 256 283 256 368c0 27.4 6.3 53.4 17.5 76.5c-1.6-.8-3.2-1.8-4.7-2.9l-64-48c-8.1-6-12.8-15.5-12.8-25.6l0-79.1L9 65.3C-.7 53.4-2.8 36.8 3.9 22.9zM432 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm59.3 107.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L432 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L409.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L432 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L454.6 368l36.7-36.7z"]
}, faLocust = {
  prefix: "fas",
  iconName: "locust",
  icon: [576, 512, [], "e520", "M312 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l16 0c98.7 0 180.6 71.4 197 165.4c-9-3.5-18.8-5.4-29-5.4l-64.2 0-41.8-97.5c-3.4-7.9-10.8-13.4-19.3-14.4s-17 2.7-22.1 9.6l-40.9 55.5-21.7-50.7c-3.3-7.8-10.5-13.2-18.9-14.3s-16.7 2.3-22 8.9l-240 304c-8.2 10.4-6.4 25.5 4 33.7s25.5 6.4 33.7-4l79.4-100.5 43 16.4-40.5 55c-7.9 10.7-5.6 25.7 5.1 33.6s25.7 5.6 33.6-5.1L215.1 400l74.5 0-29.3 42.3c-7.5 10.9-4.8 25.8 6.1 33.4s25.8 4.8 33.4-6.1L348 400l80.4 0 38.8 67.9c6.6 11.5 21.2 15.5 32.7 8.9s15.5-21.2 8.9-32.7L483.6 400l12.4 0c44.1 0 79.8-35.7 80-79.7c0-.1 0-.2 0-.3l0-40C576 143 465 32 328 32l-16 0zm50.5 168l17.1 40L333 240l29.5-40zm-87.7 38.1l-1.4 1.9-48.2 0 32.7-41.5 16.9 39.5zM88.8 240C57.4 240 32 265.4 32 296.8c0 15.5 6.3 30 16.9 40.4L126.7 240l-37.9 0zM496 288a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]
}, faSort = {
  prefix: "fas",
  iconName: "sort",
  icon: [320, 512, ["unsorted"], "f0dc", "M137.4 41.4c12.5-12.5 32.8-12.5 45.3 0l128 128c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8L32 224c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l128-128zm0 429.3l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8l256 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128c-12.5 12.5-32.8 12.5-45.3 0z"]
}, faUnsorted = faSort, faListOl = {
  prefix: "fas",
  iconName: "list-ol",
  icon: [512, 512, ["list-1-2", "list-numeric"], "f0cb", "M24 56c0-13.3 10.7-24 24-24l32 0c13.3 0 24 10.7 24 24l0 120 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0 0-96-8 0C34.7 80 24 69.3 24 56zM86.7 341.2c-6.5-7.4-18.3-6.9-24 1.2L51.5 357.9c-7.7 10.8-22.7 13.3-33.5 5.6s-13.3-22.7-5.6-33.5l11.1-15.6c23.7-33.2 72.3-35.6 99.2-4.9c21.3 24.4 20.8 60.9-1.1 84.7L86.8 432l33.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0c-9.5 0-18.2-5.6-22-14.4s-2.1-18.9 4.3-25.9l72-78c5.3-5.8 5.4-14.6 .3-20.5zM224 64l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 160l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 160l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faList12 = faListOl, faListNumeric = faListOl, faChartWaterfall = {
  prefix: "fas",
  iconName: "chart-waterfall",
  icon: [512, 512, [], "e0eb", "M32 32c17.7 0 32 14.3 32 32l0 336c0 8.8 7.2 16 16 16l400 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 480c-44.2 0-80-35.8-80-80L0 64C0 46.3 14.3 32 32 32zM160 224c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zm128-64l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm64-96c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zM480 96l0 224c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-224c0-17.7 14.3-32 32-32s32 14.3 32 32z"]
}, faSparkle = {
  prefix: "fas",
  iconName: "sparkle",
  icon: [448, 512, [], "e5d6", "M245.8 45.9C241.9 37.4 233.4 32 224 32s-17.9 5.4-21.8 13.9L142.7 174.7 13.9 234.2C5.4 238.1 0 246.6 0 256s5.4 17.9 13.9 21.8l128.8 59.5 59.5 128.8c3.9 8.5 12.4 13.9 21.8 13.9s17.9-5.4 21.8-13.9l59.5-128.8 128.8-59.5c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8L305.3 174.7 245.8 45.9z"]
}, faFaceParty = {
  prefix: "fas",
  iconName: "face-party",
  icon: [640, 512, [], "e383", "M531.7 400C485.6 467.6 408 512 320 512C178.6 512 64 397.4 64 256S178.6 0 320 0C433.4 0 529.7 73.8 563.3 176l-3.3 0c-44.2 0-80 35.8-80 80c0 18 6 34.6 16 48l-80 0c-1 0-2 0-3 .1c-1.2-2.3-2.7-4.4-4.3-6.4c-4.3-5.2-10.1-9.7-16.7-13.4C378.7 276.9 361.4 272 344 272c-3.6 0-6.8 2.5-7.7 6s.6 7.2 3.8 9c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2 .1c.2 .1 .5 .3 .9 .5c.8 .5 2 1.2 3.4 2.1c2.8 1.9 6.5 4.5 10.2 7.6c3.7 3.1 7.2 6.6 9.6 10.1c2.5 3.5 3.5 6.4 3.5 8.6s-1 5-3.5 8.6c-2.5 3.5-5.9 6.9-9.6 10.1c-3.7 3.1-7.4 5.7-10.2 7.6c-1.4 .9-2.6 1.6-3.4 2.1c-.4 .2-.7 .4-.9 .5l-.2 .1c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0c-2.5 1.4-4.1 4.1-4.1 7s1.6 5.6 4.1 7c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2 .1c.2 .1 .5 .3 .9 .5c.8 .5 2 1.2 3.4 2.1c2.8 1.9 6.5 4.5 10.2 7.6c3.7 3.1 7.2 6.6 9.6 10.1c2.5 3.5 3.5 6.4 3.5 8.6s-1 5-3.5 8.6c-2.5 3.5-5.9 6.9-9.6 10.1c-3.7 3.1-7.4 5.7-10.2 7.6c-1.4 .9-2.6 1.6-3.4 2.1c-.4 .2-.7 .4-.9 .5l-.2 .1c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-3.2 1.8-4.7 5.5-3.8 9s4.1 6 7.7 6c17.4 0 34.7-4.9 47.9-12.3c6.6-3.7 12.5-8.2 16.7-13.4c1.6-2 3.1-4.1 4.3-6.4c1 .1 2 .1 3 .1l115.7 0zM275.2 233.6c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4c-30.4-40.5-91.2-40.5-121.6 0c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2c17.6-23.5 52.8-23.5 70.4 0zm89.6 0c17.6-23.5 52.8-23.5 70.4 0c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4c-30.4-40.5-91.2-40.5-121.6 0c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2zM512 256c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-192 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l192 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0c-26.5 0-48-21.5-48-48zM51.3 152.2l-20-52C46.6 71.8 66 46 88.8 23.4L132 37.8C96.5 68.5 68.5 107.7 51.3 152.2zM55.1 12.2C40.9 27.6 28 44.4 16.6 62.1L1.1 21.7C-1.2 16 .2 9.4 4.4 4.9S15.2-1.1 21.1 .8L55.1 12.2z"]
}, faKidneys = {
  prefix: "fas",
  iconName: "kidneys",
  icon: [640, 512, [], "f5fb", "M152 0c-21.5 0-45.5 6.3-64.3 23.8C56.4 52.8 0 119.6 0 224c0 24.9 3.5 54.7 7.1 79.1c7.1 48 48.8 80.9 95.3 80.9c58.4 0 104-50.4 98.2-108.5l-4.1-41.2c-2-20.1 4.5-40.1 17.9-55.1l18.2-20.5c15.2-17.1 23.5-39.1 23.5-61.9c0-31.2-15.6-60.2-41.5-77.5l-3.4-2.3C194.5 5.9 175.1 0 155.2 0L152 0zM488 0l-3.2 0c-19.9 0-39.4 5.9-55.9 16.9l-3.4 2.3C399.6 36.5 384 65.6 384 96.7c0 22.8 8.4 44.8 23.5 61.9l18.2 20.5c13.4 15.1 19.9 35.1 17.9 55.1l-4.1 41.2C433.7 333.6 479.3 384 537.7 384c46.5 0 88.2-32.9 95.3-80.9c3.6-24.4 7.1-54.2 7.1-79.1c0-104.4-56.4-171.2-87.7-200.2C533.5 6.3 509.5 0 488 0zM228.2 231.1l1.9 18.8 21.5 10.7c2.7 1.4 4.4 4.1 4.4 7.2L256 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-220.2c0-21.2-12-40.6-31-50.1l-34.8-17.4-.1 .1c-7.5 8.4-11.1 19.5-10 30.7zm173.6-30.7l-.1-.1L367 217.7c-19 9.5-31 28.9-31 50.1L336 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-220.2c0-3 1.7-5.8 4.4-7.2l21.5-10.7 1.9-18.8c1.1-11.2-2.5-22.3-10-30.7z"]
}, faWifiExclamation = {
  prefix: "fas",
  iconName: "wifi-exclamation",
  icon: [640, 512, [], "e2cf", "M320 32c-27.2 0-48.7 23.1-46.8 50.2l14.9 208C289.3 307 303.2 320 320 320s30.7-13 31.9-29.7l14.9-208C368.7 55.1 347.2 32 320 32zM241.3 84.5c-1.2-17.4 3.3-33.9 11.9-47.6C159.4 51 75.1 94.1 9.8 156.7C-2.9 169-3.3 189.2 8.9 202s32.5 13.2 45.2 .9c51.3-49.2 116.2-84.3 188.5-99.1l-1.4-19.3zm157.4 0l-1.4 19.3c72.3 14.8 137.2 49.9 188.5 99.1c12.8 12.2 33 11.8 45.2-.9s11.8-33-.9-45.2C564.9 94.1 480.6 51 386.8 37c8.6 13.7 13.1 30.1 11.9 47.6zM129.5 264c-13.3 11.7-14.5 31.9-2.8 45.2s31.9 14.5 45.2 2.8c23.6-20.8 51.6-36.7 82.4-46.2l-4.7-65.1C204.4 212 163.4 234.1 129.5 264zm260.9-63.3l-4.6 65.1c30.8 9.4 58.8 25.4 82.4 46.2c13.3 11.7 33.5 10.4 45.2-2.8s10.4-33.5-2.8-45.2c-33.9-29.9-74.9-52-120.1-63.3zM384 416a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]
}, faChartNetwork = {
  prefix: "fas",
  iconName: "chart-network",
  icon: [640, 512, [], "f78a", "M288 64c0 13.7-4.3 26.3-11.6 36.7l29.2 62.5c9.8-2.1 20-3.2 30.4-3.2c36.1 0 69 13.3 94.3 35.2L512.4 135c-.2-2.3-.4-4.6-.4-7c0-35.3 28.7-64 64-64s64 28.7 64 64s-28.7 64-64 64c-9.2 0-17.9-1.9-25.8-5.4l-82 60.2c7.6 17.5 11.8 36.9 11.8 57.2c0 15.6-2.5 30.7-7.1 44.8l72 43.2c9.2-5.1 19.8-8 31.1-8c35.3 0 64 28.7 64 64s-28.7 64-64 64s-64-28.7-64-64l0-1.1-72.1-43.3C413.7 431 376.8 448 336 448c-68.5 0-125.9-47.9-140.4-112l-76.1 0c-11.1 19.1-31.7 32-55.4 32c-35.3 0-64-28.7-64-64s28.7-64 64-64c23.7 0 44.4 12.9 55.4 32l76.1 0c7.5-33 26.3-61.6 52.1-81.7l-29.2-62.5C185.7 124.9 160 97.5 160 64c0-35.3 28.7-64 64-64s64 28.7 64 64zm48 288a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]
}, faPersonDressBurst = {
  prefix: "fas",
  iconName: "person-dress-burst",
  icon: [640, 512, [], "e544", "M528 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM390.2 384l17.8 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 16 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 17.8 0c10.9 0 18.6-10.7 15.2-21.1L546.7 248.1l33.9 56.3c9.1 15.1 28.8 20 43.9 10.9s20-28.8 10.9-43.9l-53.6-89.2c-20.2-33.7-56.7-54.3-96-54.3l-11.6 0c-39.3 0-75.7 20.6-96 54.3l-53.6 89.2c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9l33.9-56.3L375 362.9c-3.5 10.4 4.3 21.1 15.2 21.1zM190.9 18.1C188.4 12 182.6 8 176 8s-12.4 4-14.9 10.1l-29.4 74L55.6 68.9c-6.3-1.9-13.1 .2-17.2 5.3s-4.6 12.2-1.4 17.9l39.5 69.1L10.9 206.4c-5.4 3.7-8 10.3-6.5 16.7s6.7 11.2 13.1 12.2l78.7 12.2L90.6 327c-.5 6.5 3.1 12.7 9 15.5s12.9 1.8 17.8-2.6L176 286.1l58.6 53.9c4.8 4.4 11.9 5.5 17.8 2.6s9.5-9 9-15.5l-5.6-79.4 50.5-7.8 24.4-40.5-55.2-38L315 92.2c3.3-5.7 2.7-12.8-1.4-17.9s-10.9-7.2-17.2-5.3L220.3 92.1l-29.4-74z"]
}, faDiceD4 = {
  prefix: "fas",
  iconName: "dice-d4",
  icon: [512, 512, [], "f6d0", "M228.8 .7C235.5 2.8 240 9 240 16l0 480c0 6.3-3.7 12-9.4 14.6s-12.5 1.6-17.2-2.6L5.4 324c-6.1-5.4-7.2-14.5-2.5-21.2l208-296c4-5.7 11.3-8.2 17.9-6.1zm54.4 0c6.7-2.1 13.9 .3 17.9 6.1l208 296c4.7 6.7 3.6 15.8-2.5 21.2l-208 184c-4.7 4.2-11.4 5.2-17.2 2.6s-9.4-8.3-9.4-14.6l0-480c0-7 4.5-13.2 11.2-15.3z"]
}, faMoneyCheckDollar = {
  prefix: "fas",
  iconName: "money-check-dollar",
  icon: [576, 512, ["money-check-alt"], "f53d", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zM272 192l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM256 304c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-224 0c-8.8 0-16-7.2-16-16zM164 152l0 13.9c7.5 1.2 14.6 2.9 21.1 4.7c10.7 2.8 17 13.8 14.2 24.5s-13.8 17-24.5 14.2c-11-2.9-21.6-5-31.2-5.2c-7.9-.1-16 1.8-21.5 5c-4.8 2.8-6.2 5.6-6.2 9.3c0 1.8 .1 3.5 5.3 6.7c6.3 3.8 15.5 6.7 28.3 10.5l.7 .2c11.2 3.4 25.6 7.7 37.1 15c12.9 8.1 24.3 21.3 24.6 41.6c.3 20.9-10.5 36.1-24.8 45c-7.2 4.5-15.2 7.3-23.2 9l0 13.8c0 11-9 20-20 20s-20-9-20-20l0-14.6c-10.3-2.2-20-5.5-28.2-8.4c0 0 0 0 0 0s0 0 0 0c-2.1-.7-4.1-1.4-6.1-2.1c-10.5-3.5-16.1-14.8-12.6-25.3s14.8-16.1 25.3-12.6c2.5 .8 4.9 1.7 7.2 2.4c13.6 4.6 24 8.1 35.1 8.5c8.6 .3 16.5-1.6 21.4-4.7c4.1-2.5 6-5.5 5.9-10.5c0-2.9-.8-5-5.9-8.2c-6.3-4-15.4-6.9-28-10.7l-1.7-.5c-10.9-3.3-24.6-7.4-35.6-14c-12.7-7.7-24.6-20.5-24.7-40.7c-.1-21.1 11.8-35.7 25.8-43.9c6.9-4.1 14.5-6.8 22.2-8.5l0-14c0-11 9-20 20-20s20 9 20 20z"]
}, faMoneyCheckAlt = faMoneyCheckDollar, faVectorSquare = {
  prefix: "fas",
  iconName: "vector-square",
  icon: [448, 512, [], "f5cb", "M368 80l32 0 0 32-32 0 0-32zM352 32c-17.7 0-32 14.3-32 32L128 64c0-17.7-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64l0 64c0 17.7 14.3 32 32 32l0 192c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l192 0c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-192c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0zM96 160c17.7 0 32-14.3 32-32l192 0c0 17.7 14.3 32 32 32l0 192c-17.7 0-32 14.3-32 32l-192 0c0-17.7-14.3-32-32-32l0-192zM48 400l32 0 0 32-32 0 0-32zm320 32l0-32 32 0 0 32-32 0zM48 112l0-32 32 0 0 32-32 0z"]
}, faBreadSlice = {
  prefix: "fas",
  iconName: "bread-slice",
  icon: [512, 512, [], "f7ec", "M256 32C192 32 0 64 0 192c0 35.3 28.7 64 64 64V432c0 26.5 21.5 48 48 48H400c26.5 0 48-21.5 48-48V256c35.3 0 64-28.7 64-64C512 64 320 32 256 32z"]
}, faLanguage = {
  prefix: "fas",
  iconName: "language",
  icon: [640, 512, [], "f1ab", "M0 128C0 92.7 28.7 64 64 64l192 0 48 0 16 0 256 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64l-256 0-16 0-48 0L64 448c-35.3 0-64-28.7-64-64L0 128zm320 0l0 256 256 0 0-256-256 0zM178.3 175.9c-3.2-7.2-10.4-11.9-18.3-11.9s-15.1 4.7-18.3 11.9l-64 144c-4.5 10.1 .1 21.9 10.2 26.4s21.9-.1 26.4-10.2l8.9-20.1 73.6 0 8.9 20.1c4.5 10.1 16.3 14.6 26.4 10.2s14.6-16.3 10.2-26.4l-64-144zM160 233.2L179 276l-38 0 19-42.8zM448 164c11 0 20 9 20 20l0 4 44 0 16 0c11 0 20 9 20 20s-9 20-20 20l-2 0-1.6 4.5c-8.9 24.4-22.4 46.6-39.6 65.4c.9 .6 1.8 1.1 2.7 1.6l18.9 11.3c9.5 5.7 12.5 18 6.9 27.4s-18 12.5-27.4 6.9l-18.9-11.3c-4.5-2.7-8.8-5.5-13.1-8.5c-10.6 7.5-21.9 14-34 19.4l-3.6 1.6c-10.1 4.5-21.9-.1-26.4-10.2s.1-21.9 10.2-26.4l3.6-1.6c6.4-2.9 12.6-6.1 18.5-9.8l-12.2-12.2c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0l14.6 14.6 .5 .5c12.4-13.1 22.5-28.3 29.8-45L448 228l-72 0c-11 0-20-9-20-20s9-20 20-20l52 0 0-4c0-11 9-20 20-20z"]
}, faWheatAwnSlash = {
  prefix: "fas",
  iconName: "wheat-awn-slash",
  icon: [640, 512, [], "e338", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L362.5 258.8l28.7-28.7 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0L550.5 231c6.2-6.2 6.2-16.4 0-22.6L539.2 197c-5.2-5.2-10.6-9.8-16.4-13.9L569 137c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-59.4 59.4c-20.6-4.4-42-3.7-62.3 2.1c6.1-21.3 6.6-43.8 1.4-65.3L473 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L393.1 52.9c-3.7-5-7.8-9.8-12.4-14.3L369.5 27.3c-6.2-6.2-16.4-6.2-22.6 0L335.5 38.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8l-11.3-11.3c-6.2-6.2-16.4-6.2-22.6 0l-11.3 11.3c-3.3 3.3-6.3 6.8-9 10.4L38.8 5.1zm255 322.4l-50.6-39.9-29.5 29.5c-3.4-27.3-15.5-53.8-36.5-74.8L165.8 231c-6.2-6.2-16.4-6.2-22.6 0l-11.3 11.3c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4L73.4 457.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l68.9-68.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l11.3-11.3c6.2-6.2 6.2-16.4 0-22.6l-11.3-11.3c-21.8-21.8-49.6-34.1-78.1-36.9l36.3-36.3zM569 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L447 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l88-88z"]
}, faFaceKissWinkHeart = {
  prefix: "fas",
  iconName: "face-kiss-wink-heart",
  icon: [512, 512, [128536, "kiss-wink-heart"], "f598", "M498 339.7c9.1-26.2 14-54.4 14-83.7C512 114.6 397.4 0 256 0S0 114.6 0 256S114.6 512 256 512c35.4 0 69.1-7.2 99.7-20.2c-4.8-5.5-8.5-12.2-10.4-19.7l-22.9-89.3c-10-39 11.8-80.9 51.8-92.1c37.2-10.4 73.8 10.1 87.5 44c12.7-1.6 25.1 .4 36.2 5zM296 332c0 6.9-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C258.7 443.1 241.4 448 224 448c-3.6 0-6.8-2.5-7.7-6s.6-7.2 3.8-9c0 0 0 0 0 0s0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.6-.4-.3-.2-.2-.1c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.5-1.4-4.1-4.1-4.1-7s1.6-5.6 4.1-7c0 0 0 0 0 0s0 0 0 0s0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-.9-.5l-.2-.1c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-3.2-1.8-4.7-5.5-3.8-9s4.1-6 7.7-6c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3zM176.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm194.8 57.6c-17.6-23.5-52.8-23.5-70.4 0c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4c30.4-40.5 91.2-40.5 121.6 0c5.3 7.1 3.9 17.1-3.2 22.4s-17.1 3.9-22.4-3.2zM434 352.3c-6-23.2-28.8-37-51.1-30.8s-35.4 30.1-29.5 53.4l22.9 89.3c2.2 8.7 11.2 13.9 19.8 11.4l84.9-23.8c22.2-6.2 35.4-30.1 29.5-53.4s-28.8-37-51.1-30.8l-20.2 5.6-5.4-21z"]
}, faKissWinkHeart = faFaceKissWinkHeart, faDagger = {
  prefix: "fas",
  iconName: "dagger",
  icon: [384, 512, [], "f6cb", "M224 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96L48 128c-26.5 0-48 21.5-48 48s21.5 48 48 48c20.9 0 38.7-13.4 45.3-32l98.7 0 98.7 0c6.6 18.6 24.4 32 45.3 32c26.5 0 48-21.5 48-48s-21.5-48-48-48l-112 0 0-96zM128 224l0 24 0 166.8c0 10.5 2.9 20.8 8.5 29.7l35.1 56.2c4.4 7 12.1 11.3 20.4 11.3s16-4.3 20.4-11.3l35.1-56.2c5.6-8.9 8.5-19.2 8.5-29.7L256 248l0-24-24 0-80 0-24 0z"]
}, faPodium = {
  prefix: "fas",
  iconName: "podium",
  icon: [448, 512, [], "f680", "M182.4 72c8.3 14.3 23.8 24 41.6 24l64 0c26.5 0 48-21.5 48-48s-21.5-48-48-48L224 0c-17.8 0-33.3 9.7-41.6 24L168 24c-48.6 0-88 39.4-88 88l0 32-56 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-296 0 0-32c0-22.1 17.9-40 40-40l14.4 0zM48 224L73.7 455.1c3.6 32.4 31 56.9 63.6 56.9l173.4 0c32.6 0 60-24.5 63.6-56.9L400 224 48 224z"]
}, faDiamonds4 = {
  prefix: "fas",
  iconName: "diamonds-4",
  icon: [512, 512, [], "e68b", "M227.7 11.7c15.6-15.6 40.9-15.6 56.6 0l74.1 74.1c12.5 12.5 12.5 32.8 0 45.3l-79.7 79.7c-12.5 12.5-32.8 12.5-45.3 0L153.7 131c-12.5-12.5-12.5-32.8 0-45.3l74.1-74.1zM131 153.7l79.7 79.7c12.5 12.5 12.5 32.8 0 45.3L131 358.3c-12.5 12.5-32.8 12.5-45.3 0L11.7 284.3c-15.6-15.6-15.6-40.9 0-56.6l74.1-74.1c12.5-12.5 32.8-12.5 45.3 0zM153.7 381l79.7-79.7c12.5-12.5 32.8-12.5 45.3 0L358.3 381c12.5 12.5 12.5 32.8 0 45.3l-74.1 74.1c-15.6 15.6-40.9 15.6-56.6 0l-74.1-74.1c-12.5-12.5-12.5-32.8 0-45.3zM381 358.3l-79.7-79.7c-12.5-12.5-12.5-32.8 0-45.3L381 153.7c12.5-12.5 32.8-12.5 45.3 0l74.1 74.1c15.6 15.6 15.6 40.9 0 56.6l-74.1 74.1c-12.5 12.5-32.8 12.5-45.3 0z"]
}, faMemoCircleCheck = {
  prefix: "fas",
  iconName: "memo-circle-check",
  icon: [576, 512, [], "e1d9", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 134.6C310.1 219.5 256 287.4 256 368c0 59.1 29.1 111.3 73.7 143.3c-3.2 .5-6.4 .7-9.7 .7L64 512c-35.3 0-64-28.7-64-64L0 64zm64 80c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 128c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 224zm0 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zm208 48a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm188.7-43.3L416 385.4l-28.7-28.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l40 40c6.2 6.2 16.4 6.2 22.6 0l72-72c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0z"]
}, faRouteHighway = {
  prefix: "fas",
  iconName: "route-highway",
  icon: [448, 512, [], "f61a", "M240.5 4.6c-10.1-6.1-22.8-6.1-32.9 0l-4.7 2.8c-37.5 22.5-84 24.3-123.1 4.7l-1.4-.7c-15.2-7.6-33.7-2-42.1 12.7l-32 56c-5.3 9.3-5.6 20.6-.8 30.2l16.2 32.5C27.8 159.1 32 177 32 195.2c0 14.9-2.8 29.7-8.4 43.6L9.3 274.5C3.2 289.9 0 306.4 0 323c0 49.5 28 94.8 72.2 116.9l137.4 68.7c9 4.5 19.6 4.5 28.6 0l137.4-68.7C420 417.8 448 372.5 448 323c0-16.6-3.2-33.1-9.3-48.5l-14.3-35.7c-5.5-13.9-8.4-28.6-8.4-43.6c0-18.2 4.2-36.2 12.4-52.5l16.2-32.5c4.8-9.6 4.5-20.9-.8-30.2l-32-56c-8.4-14.7-26.9-20.3-42.1-12.7l-1.4 .7c-39.1 19.6-85.6 17.8-123.1-4.7l-4.7-2.8zM96 192L352 192c0 1.1 0 2.2 0 3.2c0 23.1 4.4 45.9 13 67.3l14.3 35.7c3.2 7.9 4.8 16.3 4.8 24.8c0 25.3-14.3 48.4-36.9 59.7L224 444.2 100.9 382.7C78.3 371.4 64 348.3 64 323c0-8.5 1.6-16.9 4.8-24.8L83 262.6c8.6-21.4 13-44.3 13-67.3c0-1.1 0-2.2 0-3.2z"]
}, faDownToLine = {
  prefix: "fas",
  iconName: "down-to-line",
  icon: [384, 512, ["arrow-alt-to-bottom"], "f34a", "M342.1 249.9L219.3 372.7c-7.2 7.2-17.1 11.3-27.3 11.3s-20.1-4.1-27.3-11.3L41.9 249.9c-6.4-6.4-9.9-15-9.9-24C32 207.2 47.2 192 65.9 192l62.1 0 0-128c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 128 62.1 0c18.7 0 33.9 15.2 33.9 33.9c0 9-3.6 17.6-9.9 24zM32 416l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]
}, faArrowAltToBottom = faDownToLine, faFilter = {
  prefix: "fas",
  iconName: "filter",
  icon: [512, 512, [], "f0b0", "M3.9 54.9C10.5 40.9 24.5 32 40 32l432 0c15.5 0 29.5 8.9 36.1 22.9s4.6 30.5-5.2 42.5L320 320.9 320 448c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48c-8.1-6-12.8-15.5-12.8-25.6l0-79.1L9 97.3C-.7 85.4-2.8 68.8 3.9 54.9z"]
}, faSquareG = {
  prefix: "fas",
  iconName: "square-g",
  icon: [448, 512, [], "e271", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm80 224c0 44.2 35.8 80 80 80c35.8 0 66.1-23.5 76.3-56L248 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c13.3 0 24 10.7 24 24c0 70.7-57.3 128-128 128s-128-57.3-128-128s57.3-128 128-128c32.8 0 62.7 12.3 85.3 32.6c9.9 8.8 10.7 24 1.9 33.9s-24 10.7-33.9 1.9C263.2 183.7 244.5 176 224 176c-44.2 0-80 35.8-80 80z"]
}, faCirclePhone = {
  prefix: "fas",
  iconName: "circle-phone",
  icon: [512, 512, ["phone-circle"], "e11b", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM186.7 128.7c9.7-2.6 19.9 2.3 23.7 11.6l20 48c3.4 8.2 1 17.6-5.8 23.2L200 231.7c16.6 35.2 45.1 63.7 80.3 80.3l20.2-24.7c5.6-6.8 15-9.2 23.2-5.8l48 20c9.3 3.9 14.2 14 11.6 23.7l-12 44C368.9 378 361 384 352 384c-123.7 0-224-100.3-224-224c0-9 6-16.9 14.7-19.3l44-12z"]
}, faPhoneCircle = faCirclePhone, faClipboardPrescription = {
  prefix: "fas",
  iconName: "clipboard-prescription",
  icon: [384, 512, [], "f5e8", "M192 0c-41.8 0-77.4 26.7-90.5 64L64 64C28.7 64 0 92.7 0 128L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l-37.5 0C269.4 26.7 233.8 0 192 0zm0 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM104 196l72 0c33.1 0 60 26.9 60 60c0 25.5-15.9 47.2-38.3 55.9l43 40.3 33.8-31c8.1-7.5 20.8-6.9 28.3 1.2s6.9 20.8-1.2 28.3L270 379.7l31.7 29.7c8.1 7.6 8.5 20.2 .9 28.3s-20.2 8.5-28.3 .9l-33.9-31.8-34.9 32c-8.1 7.5-20.8 6.9-28.3-1.2s-6.9-20.8 1.2-28.3l32.6-29.9-64.8-60.8c-.9-.8-1.6-1.7-2.3-2.6l-20 0 0 44c0 11-9 20-20 20s-20-9-20-20l0-64 0-80c0-11 9-20 20-20zm72 80c11 0 20-9 20-20s-9-20-20-20l-52 0 0 40 52 0z"]
}, faUserNurseHair = {
  prefix: "fas",
  iconName: "user-nurse-hair",
  icon: [448, 512, [], "e45d", "M96 70.2L96 128l.3 0c-.2 2.6-.3 5.3-.3 8l0 40c0 70.7 57.3 128 128 128s128-57.3 128-128l0-40c0-2.7-.1-5.4-.3-8l.3 0 0-57.8c0-13.3-8.3-25.3-20.8-30l-96-36c-7.2-2.7-15.2-2.7-22.5 0l-96 36C104.3 44.9 96 56.8 96 70.2zM304 160l0 16c0 44.2-35.8 80-80 80s-80-35.8-80-80l32 0c29.8 0 55.9-16.3 69.6-40.5C257.3 150.4 275.5 160 296 160l8 0zM141.3 336.2c-7.6-8.1-18.9-11.9-29.4-8.5C47 348.5 0 409.4 0 481.3c0 17 13.8 30.7 30.7 30.7l386.6 0c17 0 30.7-13.8 30.7-30.7c0-71.8-47-132.7-111.9-153.6c-10.5-3.4-21.8 .4-29.4 8.5l-71 75.5c-6.3 6.7-17 6.7-23.3 0l-71-75.5zM208 48c0-4.4 3.6-8 8-8l16 0c4.4 0 8 3.6 8 8l0 16 16 0c4.4 0 8 3.6 8 8l0 16c0 4.4-3.6 8-8 8l-16 0 0 16c0 4.4-3.6 8-8 8l-16 0c-4.4 0-8-3.6-8-8l0-16-16 0c-4.4 0-8-3.6-8-8l0-16c0-4.4 3.6-8 8-8l16 0 0-16z"]
}, faQuestion = {
  prefix: "fas",
  iconName: "question",
  icon: [320, 512, [10067, 10068, 61736], "3f", "M80 160c0-35.3 28.7-64 64-64l32 0c35.3 0 64 28.7 64 64l0 3.6c0 21.8-11.1 42.1-29.4 53.8l-42.2 27.1c-25.2 16.2-40.4 44.1-40.4 74l0 1.4c0 17.7 14.3 32 32 32s32-14.3 32-32l0-1.4c0-8.2 4.2-15.8 11-20.2l42.2-27.1c36.6-23.6 58.8-64.1 58.8-107.7l0-3.6c0-70.7-57.3-128-128-128l-32 0C73.3 32 16 89.3 16 160c0 17.7 14.3 32 32 32s32-14.3 32-32zm80 320a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]
}, faFileSignature = {
  prefix: "fas",
  iconName: "file-signature",
  icon: [576, 512, [], "f573", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-19.3c-2.7 1.1-5.4 2-8.2 2.7l-60.1 15c-3 .7-6 1.2-9 1.4c-.9 .1-1.8 .2-2.7 .2l-64 0c-6.1 0-11.6-3.4-14.3-8.8l-8.8-17.7c-1.7-3.4-5.1-5.5-8.8-5.5s-7.2 2.1-8.8 5.5l-8.8 17.7c-2.9 5.9-9.2 9.4-15.7 8.8s-12.1-5.1-13.9-11.3L144 381l-9.8 32.8c-6.1 20.3-24.8 34.2-46 34.2L80 448c-8.8 0-16-7.2-16-16s7.2-16 16-16l8.2 0c7.1 0 13.3-4.6 15.3-11.4l14.9-49.5c3.4-11.3 13.8-19.1 25.6-19.1s22.2 7.8 25.6 19.1l11.6 38.6c7.4-6.2 16.8-9.7 26.8-9.7c15.9 0 30.4 9 37.5 23.2l4.4 8.8 8.9 0c-3.1-8.8-3.7-18.4-1.4-27.8l15-60.1c2.8-11.3 8.6-21.5 16.8-29.7L384 203.6l0-43.6-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM549.8 139.7c-15.6-15.6-40.9-15.6-56.6 0l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4zM311.9 321c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L512.1 262.7l-71-71L311.9 321z"]
}, faToggleLargeOn = {
  prefix: "fas",
  iconName: "toggle-large-on",
  icon: [576, 512, [], "e5b1", "M192 64C86 64 0 150 0 256S86 448 192 448l192 0c106 0 192-86 192-192s-86-192-192-192L192 64zm192 64a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"]
}, faUpDownLeftRight = {
  prefix: "fas",
  iconName: "up-down-left-right",
  icon: [512, 512, ["arrows-alt"], "f0b2", "M278.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-64 64c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l32 0 0 96-96 0 0-32c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-64 64c-12.5 12.5-12.5 32.8 0 45.3l64 64c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6l0-32 96 0 0 96-32 0c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l64 64c12.5 12.5 32.8 12.5 45.3 0l64-64c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8l-32 0 0-96 96 0 0 32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 32-96 0 0-96 32 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-64-64z"]
}, faArrowsAlt = faUpDownLeftRight, faDryerHeat = {
  prefix: "fas",
  iconName: "dryer-heat",
  icon: [448, 512, ["dryer-alt"], "f862", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0zM224 160a144 144 0 1 1 0 288 144 144 0 1 1 0-288zM64 88a24 24 0 1 1 48 0A24 24 0 1 1 64 88zM184 64a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM156.7 212.7c-6.2 6.2-6.2 16.4 0 22.6L177.4 256c4.2 4.2 6.6 10 6.6 16s-2.4 11.8-6.6 16l-9.4 9.4c-10.2 10.2-16 24.1-16 38.6s5.8 28.4 16 38.6l20.7 20.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L190.6 352c-4.2-4.2-6.6-10-6.6-16s2.4-11.8 6.6-16l9.4-9.4c10.2-10.2 16-24.1 16-38.6s-5.8-28.4-16-38.6l-20.7-20.7c-6.2-6.2-16.4-6.2-22.6 0zm102.6 0c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L257.4 256c4.2 4.2 6.6 10 6.6 16s-2.4 11.8-6.6 16l-9.4 9.4c-10.2 10.2-16 24.1-16 38.6s5.8 28.4 16 38.6l20.7 20.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L270.6 352c-4.2-4.2-6.6-10-6.6-16s2.4-11.8 6.6-16l9.4-9.4c10.2-10.2 16-24.1 16-38.6s-5.8-28.4-16-38.6l-20.7-20.7z"]
}, faDryerAlt = faDryerHeat, faHouseChimneyUser = {
  prefix: "fas",
  iconName: "house-chimney-user",
  icon: [576, 512, [], "e065", "M543.8 287.6c17 0 32-14 32-32.1c1-9-3-17-11-24L512 185l0-121c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32l0 36.7L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24c0 18 14 32.1 32 32.1l32 0 0 160.4c0 35.3 28.7 64 64 64l320.4 0c35.5 0 64.2-28.8 64-64.3l-.7-160.2 32 0zM288 160a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM176 400c0-44.2 35.8-80 80-80l64 0c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16z"]
}, faHandHoldingHeart = {
  prefix: "fas",
  iconName: "hand-holding-heart",
  icon: [576, 512, [], "f4be", "M163.9 136.9c-29.4-29.8-29.4-78.2 0-108s77-29.8 106.4 0l17.7 18 17.7-18c29.4-29.8 77-29.8 106.4 0s29.4 78.2 0 108L310.5 240.1c-6.2 6.3-14.3 9.4-22.5 9.4s-16.3-3.1-22.5-9.4L163.9 136.9zM568.2 336.3c13.1 17.8 9.3 42.8-8.5 55.9L433.1 485.5c-23.4 17.2-51.6 26.5-80.7 26.5L192 512 32 512c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l36.8 0 44.9-36c22.7-18.2 50.9-28 80-28l78.3 0 16 0 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l120.6 0 119.7-88.2c17.8-13.1 42.8-9.3 55.9 8.5zM193.6 384c0 0 0 0 0 0l-.9 0c.3 0 .6 0 .9 0z"]
}, faArrowUpSmallBig = {
  prefix: "fas",
  iconName: "arrow-up-small-big",
  icon: [576, 512, ["sort-size-up-alt"], "f88f", "M160 32c9 0 17.5 3.8 23.6 10.4l88 96c11.9 13 11.1 33.3-2 45.2s-33.3 11.1-45.2-2L192 146.3 192 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-301.7L95.6 181.6c-11.9 13-32.2 13.9-45.2 2s-13.9-32.2-2-45.2l88-96C142.5 35.8 151 32 160 32zM320 80c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64zm48 176l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-128c0-26.5 21.5-48 48-48z"]
}, faSortSizeUpAlt = faArrowUpSmallBig, faTrainTrack = {
  prefix: "fas",
  iconName: "train-track",
  icon: [576, 512, [], "e453", "M222.4 74.1c5.6-16.8-3.5-34.9-20.2-40.5s-34.9 3.5-40.5 20.2L147.6 96 112 96c-17.7 0-32 14.3-32 32s14.3 32 32 32l14.3 0-21.3 64L72 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l11.6 0L62.3 352 32 352c-17.7 0-32 14.3-32 32s14.3 32 32 32l8.9 0-7.3 21.9c-5.6 16.8 3.5 34.9 20.2 40.5s34.9-3.5 40.5-20.2l14-42.1 359.2 0 14 42.1c5.6 16.8 23.7 25.8 40.5 20.2s25.8-23.7 20.2-40.5L535.1 416l8.9 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-30.3 0-21.3-64 11.6 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32.9 0-21.3-64 14.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-35.6 0-14-42.1c-5.6-16.8-23.7-25.8-40.5-20.2s-25.8 23.7-20.2 40.5L360.9 96 215.1 96l7.3-21.9zM193.7 160l188.5 0 21.3 64-231.2 0 21.3-64zM446.3 352l-316.5 0 21.3-64 273.9 0 21.3 64z"]
}, faPuzzlePiece = {
  prefix: "fas",
  iconName: "puzzle-piece",
  icon: [512, 512, [129513], "f12e", "M192 104.8c0-9.2-5.8-17.3-13.2-22.8C167.2 73.3 160 61.3 160 48c0-26.5 28.7-48 64-48s64 21.5 64 48c0 13.3-7.2 25.3-18.8 34c-7.4 5.5-13.2 13.6-13.2 22.8c0 12.8 10.4 23.2 23.2 23.2l56.8 0c26.5 0 48 21.5 48 48l0 56.8c0 12.8 10.4 23.2 23.2 23.2c9.2 0 17.3-5.8 22.8-13.2c8.7-11.6 20.7-18.8 34-18.8c26.5 0 48 28.7 48 64s-21.5 64-48 64c-13.3 0-25.3-7.2-34-18.8c-5.5-7.4-13.6-13.2-22.8-13.2c-12.8 0-23.2 10.4-23.2 23.2L384 464c0 26.5-21.5 48-48 48l-56.8 0c-12.8 0-23.2-10.4-23.2-23.2c0-9.2 5.8-17.3 13.2-22.8c11.6-8.7 18.8-20.7 18.8-34c0-26.5-28.7-48-64-48s-64 21.5-64 48c0 13.3 7.2 25.3 18.8 34c7.4 5.5 13.2 13.6 13.2 22.8c0 12.8-10.4 23.2-23.2 23.2L48 512c-26.5 0-48-21.5-48-48L0 343.2C0 330.4 10.4 320 23.2 320c9.2 0 17.3 5.8 22.8 13.2C54.7 344.8 66.7 352 80 352c26.5 0 48-28.7 48-64s-21.5-64-48-64c-13.3 0-25.3 7.2-34 18.8C40.5 250.2 32.4 256 23.2 256C10.4 256 0 245.6 0 232.8L0 176c0-26.5 21.5-48 48-48l120.8 0c12.8 0 23.2-10.4 23.2-23.2z"]
}, faMoneyCheck = {
  prefix: "fas",
  iconName: "money-check",
  icon: [576, 512, [], "f53c", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm48 160l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM96 336c0-8.8 7.2-16 16-16l352 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-352 0c-8.8 0-16-7.2-16-16zM376 160l80 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"]
}, faStarHalfStroke = {
  prefix: "fas",
  iconName: "star-half-stroke",
  icon: [576, 512, ["star-half-alt"], "f5c0", "M288 376.4l.1-.1 26.4 14.1 85.2 45.5-16.5-97.6-4.8-28.7 20.7-20.5 70.1-69.3-96.1-14.2-29.3-4.3-12.9-26.6L288.1 86.9l-.1 .3 0 289.2zm175.1 98.3c2 12-3 24.2-12.9 31.3s-23 8-33.8 2.3L288.1 439.8 159.8 508.3C149 514 135.9 513.1 126 506s-14.9-19.3-12.9-31.3L137.8 329 33.6 225.9c-8.6-8.5-11.7-21.2-7.9-32.7s13.7-19.9 25.7-21.7L195 150.3 259.4 18c5.4-11 16.5-18 28.8-18s23.4 7 28.8 18l64.3 132.3 143.6 21.2c12 1.8 22 10.2 25.7 21.7s.7 24.2-7.9 32.7L438.5 329l24.6 145.7z"]
}, faStarHalfAlt = faStarHalfStroke, faFileExclamation = {
  prefix: "fas",
  iconName: "file-exclamation",
  icon: [384, 512, [], "f31a", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM192 192c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112c0-13.3 10.7-24 24-24zM160 416a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faCode = {
  prefix: "fas",
  iconName: "code",
  icon: [640, 512, [], "f121", "M392.8 1.2c-17-4.9-34.7 5-39.6 22l-128 448c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22l128-448c4.9-17-5-34.7-22-39.6zm80.6 120.1c-12.5 12.5-12.5 32.8 0 45.3L562.7 256l-89.4 89.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l112-112c12.5-12.5 12.5-32.8 0-45.3l-112-112c-12.5-12.5-32.8-12.5-45.3 0zm-306.7 0c-12.5-12.5-32.8-12.5-45.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3l112 112c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L77.3 256l89.4-89.4c12.5-12.5 12.5-32.8 0-45.3z"]
}, faWhiskeyGlass = {
  prefix: "fas",
  iconName: "whiskey-glass",
  icon: [512, 512, [129347, "glass-whiskey"], "f7a0", "M32 32c-9.3 0-18.1 4-24.2 11.1S-1 59.4 .3 68.6l50 342.9c5.7 39.3 39.4 68.5 79.2 68.5l253 0c39.7 0 73.4-29.1 79.2-68.5l50-342.9c1.3-9.2-1.4-18.5-7.5-25.5S489.3 32 480 32L32 32zM87.7 224L69 96l374 0L424.3 224 87.7 224z"]
}, faGlassWhiskey = faWhiskeyGlass, faMoonStars = {
  prefix: "fas",
  iconName: "moon-stars",
  icon: [512, 512, [], "f755", "M284.8 99.2l11 38.6c1 3.6 4.4 6.2 8.2 6.2s7.1-2.5 8.2-6.2l11-38.6 38.6-11c3.6-1 6.2-4.4 6.2-8.2s-2.5-7.1-6.2-8.2l-38.6-11-11-38.6c-1-3.6-4.4-6.2-8.2-6.2s-7.1 2.5-8.2 6.2l-11 38.6-38.6 11c-3.6 1-6.2 4.4-6.2 8.2s2.5 7.1 6.2 8.2l38.6 11zm119 211.6c1.6 5.5 6.6 9.2 12.2 9.2s10.7-3.8 12.2-9.2l16.6-58 58-16.6c5.5-1.6 9.2-6.6 9.2-12.2s-3.8-10.7-9.2-12.2l-58-16.6-16.6-58c-1.6-5.5-6.6-9.2-12.2-9.2s-10.7 3.8-12.2 9.2l-16.6 58-58 16.6c-5.5 1.6-9.2 6.6-9.2 12.2s3.8 10.7 9.2 12.2l58 16.6 16.6 58zM191.8 128C85.8 128 0 214.1 0 320.2S85.8 512.4 191.8 512.4c52 0 99.1-20.7 133.6-54.4c5-4.9 6.3-12.5 3.1-18.7s-10.1-9.7-17-8.5c-8.1 1.4-16.5 2.2-25.1 2.2c-80.7 0-146.2-65.6-146.2-146.6c0-54.8 30-102.6 74.4-127.8c6.1-3.5 9.2-10.5 7.7-17.3s-7.3-11.9-14.3-12.5c-5.4-.5-10.8-.7-16.3-.7z"]
}, faBuildingCircleExclamation = {
  prefix: "fas",
  iconName: "building-circle-exclamation",
  icon: [640, 512, [], "e4d3", "M48 0C21.5 0 0 21.5 0 48L0 464c0 26.5 21.5 48 48 48l96 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 96 0c15.1 0 28.5-6.9 37.3-17.8C340.4 462.2 320 417.5 320 368c0-54.7 24.9-103.5 64-135.8L384 48c0-26.5-21.5-48-48-48L48 0zM64 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm112-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM80 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0-144c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]
}, faClothesHanger = {
  prefix: "fas",
  iconName: "clothes-hanger",
  icon: [640, 512, [], "e136", "M209.8 84.8C222.3 35 267.1 0 318.5 0L320 0c61.9 0 112 50.1 112 112l0 6.3c0 36.5-17.8 70.8-47.8 91.8l-8.3 5.8L608.2 377.2C628.1 391 640 413.7 640 438c0 40.9-33.1 74-74 74L74 512c-40.9 0-74-33.1-74-74c0-24.2 11.9-47 31.8-60.8L301.6 189.8l.1-.1 45.8-32c12.8-9 20.5-23.7 20.5-39.3l0-6.3c0-26.5-21.5-48-48-48l-1.5 0c-22 0-41.2 15-46.6 36.4l-.9 3.4c-4.3 17.1-21.7 27.6-38.8 23.3s-27.6-21.7-23.3-38.8l.9-3.4zM320 255L68.3 429.7c-2.7 1.9-4.3 4.9-4.3 8.2c0 5.5 4.5 10 10 10l492 0c5.5 0 10-4.5 10-10c0-3.3-1.6-6.4-4.3-8.2L320 255z"]
}, faMobileNotch = {
  prefix: "fas",
  iconName: "mobile-notch",
  icon: [384, 512, ["mobile-iphone"], "e1ee", "M128 64l0 16c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16l0-16 32 0c8.8 0 16 7.2 16 16l0 352c0 8.8-7.2 16-16 16L96 448c-8.8 0-16-7.2-16-16L80 80c0-8.8 7.2-16 16-16l32 0zM96 0C51.8 0 16 35.8 16 80l0 352c0 44.2 35.8 80 80 80l192 0c44.2 0 80-35.8 80-80l0-352c0-44.2-35.8-80-80-80L96 0zm32 400c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16z"]
}, faMobileIphone = faMobileNotch, faMagnifyingGlassChart = {
  prefix: "fas",
  iconName: "magnifying-glass-chart",
  icon: [512, 512, [], "e522", "M416 208c0 45.9-14.9 88.3-40 122.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376c-34.4 25.2-76.8 40-122.7 40C93.1 416 0 322.9 0 208S93.1 0 208 0S416 93.1 416 208zm-312 8l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24zm80-96l0 160c0 13.3 10.7 24 24 24s24-10.7 24-24l0-160c0-13.3-10.7-24-24-24s-24 10.7-24 24zm80 64l0 96c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96c0-13.3-10.7-24-24-24s-24 10.7-24 24z"]
}, faArrowUpRightFromSquare = {
  prefix: "fas",
  iconName: "arrow-up-right-from-square",
  icon: [512, 512, ["external-link"], "f08e", "M320 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l82.7 0L201.4 265.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L448 109.3l0 82.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-17.7-14.3-32-32-32L320 0zM80 32C35.8 32 0 67.8 0 112L0 432c0 44.2 35.8 80 80 80l320 0c44.2 0 80-35.8 80-80l0-112c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 8.8-7.2 16-16 16L80 448c-8.8 0-16-7.2-16-16l0-320c0-8.8 7.2-16 16-16l112 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 32z"]
}, faExternalLink = faArrowUpRightFromSquare, faCubesStacked = {
  prefix: "fas",
  iconName: "cubes-stacked",
  icon: [448, 512, [], "e4e6", "M192 64l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zM82.7 207c-15.3 8.8-20.5 28.4-11.7 43.7l32 55.4c8.8 15.3 28.4 20.5 43.7 11.7l55.4-32c15.3-8.8 20.5-28.4 11.7-43.7l-32-55.4c-8.8-15.3-28.4-20.5-43.7-11.7L82.7 207zM288 192c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0zm64 160c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0zM160 384l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zM32 352c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-64 0z"]
}, faImagesUser = {
  prefix: "fas",
  iconName: "images-user",
  icon: [576, 512, [], "e1b9", "M96 96l0 224c0 35.3 28.7 64 64 64l352 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L160 32c-35.3 0-64 28.7-64 64zm240 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zM269.7 256l132.6 0c25.2 0 45.7 20.5 45.7 45.7c0 10.1-8.2 18.3-18.3 18.3l-187.4 0c-10.1 0-18.3-8.2-18.3-18.3c0-25.2 20.5-45.7 45.7-45.7zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120L0 344c0 75.1 60.9 136 136 136l320 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-320 0c-48.6 0-88-39.4-88-88l0-224z"]
}, faWonSign = {
  prefix: "fas",
  iconName: "won-sign",
  icon: [512, 512, [8361, "krw", "won"], "f159", "M62.4 53.9C56.8 37.1 38.6 28.1 21.9 33.6S-3.9 57.4 1.6 74.1L51.6 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l40.9 0 56.7 170.1c4.5 13.5 17.4 22.4 31.6 21.9s26.4-10.4 29.8-24.2L233 288l46 0L321 455.8c3.4 13.8 15.6 23.7 29.8 24.2s27.1-8.4 31.6-21.9L439.1 288l40.9 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-19.6 0 50-149.9c5.6-16.8-3.5-34.9-20.2-40.5s-34.9 3.5-40.5 20.2L392.9 224l-64 0L287 56.2C283.5 42 270.7 32 256 32s-27.5 10-31 24.2L183 224l-64 0L62.4 53.9zm78 234.1l26.6 0-11.4 45.6L140.4 288zM249 224l7-28.1 7 28.1-14 0zm96 64l26.6 0-15.2 45.6L345 288z"]
}, faKrw = faWonSign, faWon = faWonSign, faImagePolaroidUser = {
  prefix: "fas",
  iconName: "image-polaroid-user",
  icon: [448, 512, [], "e1b6", "M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 32l0 192c0 17.7 14.3 32 32 32l16 0c0-35.3 28.7-64 64-64l96 0c35.3 0 64 28.7 64 64l16 0c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32L96 96c-17.7 0-32 14.3-32 32zm96 64a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]
}, faVirusCovid = {
  prefix: "fas",
  iconName: "virus-covid",
  icon: [512, 512, [], "e4a8", "M192 24c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0 0 33.6c30.7 4.2 58.8 16.3 82.3 34.1L386.1 92 374.8 80.6c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l56.6 56.6c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L420 125.9l-23.8 23.8c17.9 23.5 29.9 51.7 34.1 82.3l33.6 0 0-16c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-16-33.6 0c-4.2 30.7-16.3 58.8-34.1 82.3L420 386.1l11.3-11.3c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-56.6 56.6c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L386.1 420l-23.8-23.8c-23.5 17.9-51.7 29.9-82.3 34.1l0 33.6 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0 0-33.6c-30.7-4.2-58.8-16.3-82.3-34.1L125.9 420l11.3 11.3c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L46.7 408.7c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L92 386.1l23.8-23.8C97.9 338.8 85.8 310.7 81.6 280L48 280l0 16c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80c0-13.3 10.7-24 24-24s24 10.7 24 24l0 16 33.6 0c4.2-30.7 16.3-58.8 34.1-82.3L92 125.9 80.6 137.2c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l56.6-56.6c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L125.9 92l23.8 23.8c23.5-17.9 51.7-29.9 82.3-34.1L232 48l-16 0c-13.3 0-24-10.7-24-24zm48 200a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm64 104a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]
}, faSquareEllipsis = {
  prefix: "fas",
  iconName: "square-ellipsis",
  icon: [448, 512, [], "e26e", "M448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320zM256 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM160 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z"]
}, faPie = {
  prefix: "fas",
  iconName: "pie",
  icon: [576, 512, [129383], "f705", "M525.8 225.1c3.1 7.8 8.8 14.4 16.3 18.2l16.2 8.1c15.8 7.9 22.2 27.1 14.3 42.9s-27.1 22.2-42.9 14.3l-29.6-14.8c-14.7-7.4-31.7-8.8-47.4-3.9l-41.6 12.8c-23.3 7.2-48.3 6.5-71.2-1.8l-30-10.9c-14.1-5.1-29.6-5.1-43.7 0l-30 10.9c-22.9 8.3-47.9 9-71.2 1.8l-41.6-12.8c-15.7-4.8-32.7-3.4-47.4 3.9L46.3 308.6c-15.8 7.9-35 1.5-42.9-14.3s-1.5-35 14.3-42.9l16.2-8.1c7.5-3.8 13.2-10.4 16.3-18.2C87.9 130.7 180.1 64 288 64s200.1 66.7 237.8 161.1zM199.2 129.7c-7.9-4-17.5-.7-21.5 7.2l-16 32c-4 7.9-.7 17.5 7.2 21.5c2.2 1.1 4.5 1.6 6.8 1.7l.7 0c5.7-.1 11.2-3.3 14-8.8l16-32c4-7.9 .7-17.5-7.2-21.5zm177.7 0c-7.9 4-11.1 13.6-7.2 21.5l16 32c2.7 5.5 8.2 8.7 14 8.8l.7 0c2.3 0 4.6-.6 6.8-1.7c7.9-4 11.1-13.6 7.2-21.5l-16-32c-4-7.9-13.6-11.1-21.5-7.2zM288 128c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c0-8.8-7.2-16-16-16zm10.9 192.1l30 10.9c29.5 10.7 61.6 11.5 91.6 2.3l41.6-12.8c7.9-2.4 16.4-1.7 23.7 2l29.6 14.8c.4 .2 .9 .4 1.3 .6l-22.1 66.4c-8.7 26.1-33.2 43.8-60.7 43.8l-291.7 0c-27.5 0-52-17.6-60.7-43.8L59.3 337.9c.4-.2 .9-.4 1.3-.6l29.6-14.8c7.4-3.7 15.9-4.4 23.7-2l41.6 12.8c30 9.2 62.1 8.4 91.6-2.3l30-10.9c7.1-2.6 14.8-2.6 21.9 0z"]
}, faChessKnightPiece = {
  prefix: "fas",
  iconName: "chess-knight-piece",
  icon: [320, 512, ["chess-knight-alt"], "f442", "M57.6 102.4l-6.9 6.9c-12 12-18.7 28.3-18.7 45.3l0 81.2c0 10.7 5.3 20.7 14.2 26.6l3.5 2.4c12.7 8.5 29.1 9.5 42.8 2.7c2.3-1.1 4.5-2.5 6.5-4l38.8-29.1c5.5-4.1 13.1-4.1 18.6 0c8.2 6.1 8.3 18.4 .2 24.7L81 317c-20.8 16-33 40.7-33 67l224 0 26.9-107.6c3.4-13.6 5.1-27.5 5.1-41.5c0-94.4-76.5-171-171-171L47.8 64C39.1 64 32 71.1 32 79.8c0 6 3.4 11.5 8.7 14.2l16.9 8.4zm19.2 54.4a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM48 416L4.8 473.6C1.7 477.8 0 482.8 0 488c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24c0-5.2-1.7-10.2-4.8-14.4L272 416 48 416z"]
}, faChessKnightAlt = faChessKnightPiece, faAustralSign = {
  prefix: "fas",
  iconName: "austral-sign",
  icon: [448, 512, [], "e0a9", "M253.5 51.7C248.6 39.8 236.9 32 224 32s-24.6 7.8-29.5 19.7L122.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0L82.7 320 32 320c-17.7 0-32 14.3-32 32s14.3 32 32 32l24 0L34.5 435.7c-6.8 16.3 .9 35 17.2 41.8s35-.9 41.8-17.2L125.3 384l197.3 0 31.8 76.3c6.8 16.3 25.5 24 41.8 17.2s24-25.5 17.2-41.8L392 384l24 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0L352 288l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-90.7 0L253.5 51.7zM256 224l-64 0 32-76.8L256 224zm-90.7 64l117.3 0L296 320l-144 0 13.3-32z"]
}, faCloudPlus = {
  prefix: "fas",
  iconName: "cloud-plus",
  icon: [640, 512, [], "e35e", "M144 480C64.5 480 0 415.5 0 336c0-62.8 40.2-116.2 96.2-135.9c-.1-2.7-.2-5.4-.2-8.1c0-88.4 71.6-160 160-160c59.3 0 111 32.2 138.7 80.2C409.9 102 428.3 96 448 96c53 0 96 43 96 96c0 12.2-2.3 23.8-6.4 34.6C596 238.4 640 290.1 640 352c0 70.7-57.3 128-128 128l-368 0zM296 376c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0 0 64z"]
}, faF = {
  prefix: "fas",
  iconName: "f",
  icon: [320, 512, [102], "46", "M64 32C28.7 32 0 60.7 0 96L0 256 0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160 160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 224 64 96l224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 32z"]
}, faLeaf = {
  prefix: "fas",
  iconName: "leaf",
  icon: [512, 512, [], "f06c", "M272 96c-78.6 0-145.1 51.5-167.7 122.5c33.6-17 71.5-26.5 111.7-26.5l88 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-16 0-72 0s0 0 0 0c-16.6 0-32.7 1.9-48.3 5.4c-25.9 5.9-49.9 16.4-71.4 30.7c0 0 0 0 0 0C38.3 298.8 0 364.9 0 440l0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16c0-48.7 20.7-92.5 53.8-123.2C121.6 392.3 190.3 448 272 448l1 0c132.1-.7 239-130.9 239-291.4c0-42.6-7.5-83.1-21.1-119.6c-2.6-6.9-12.7-6.6-16.2-.1C455.9 72.1 418.7 96 376 96L272 96z"]
}, faBedBunk = {
  prefix: "fas",
  iconName: "bed-bunk",
  icon: [576, 512, [], "f8f8", "M64 32C64 14.3 49.7 0 32 0S0 14.3 0 32L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 192 0 256 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 0-32 0-128 0-32 0-64 0-32 0-48C576 50.1 525.9 0 464 0L256 0c-17.7 0-32 14.3-32 32l0 96L64 128l0-96zM512 256l-256 0c-17.7 0-32 14.3-32 32l0 96L64 384l0-192 192 0 256 0 0 64zM192 304a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM144 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]
}, faRoad = {
  prefix: "fas",
  iconName: "road",
  icon: [576, 512, [128739], "f018", "M256 32l-74.8 0c-27.1 0-51.3 17.1-60.3 42.6L3.1 407.2C1.1 413 0 419.2 0 425.4C0 455.5 24.5 480 54.6 480L256 480l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64 201.4 0c30.2 0 54.6-24.5 54.6-54.6c0-6.2-1.1-12.4-3.1-18.2L455.1 74.6C446 49.1 421.9 32 394.8 32L320 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm64 192l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32z"]
}, faTaxi = {
  prefix: "fas",
  iconName: "taxi",
  icon: [512, 512, [128662, "cab"], "f1ba", "M192 0c-17.7 0-32 14.3-32 32l0 32 0 .2c-38.6 2.2-72.3 27.3-85.2 64.1L39.6 228.8C16.4 238.4 0 261.3 0 288L0 432l0 48c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-48 320 0 0 48c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-48 0-144c0-26.7-16.4-49.6-39.6-59.2L437.2 128.3c-12.9-36.8-46.6-62-85.2-64.1l0-.2 0-32c0-17.7-14.3-32-32-32L192 0zM165.4 128l181.2 0c13.6 0 25.7 8.6 30.2 21.4L402.9 224l-293.8 0 26.1-74.6c4.5-12.8 16.6-21.4 30.2-21.4zM96 288a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm288 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faCab = faTaxi, faPersonCirclePlus = {
  prefix: "fas",
  iconName: "person-circle-plus",
  icon: [576, 512, [], "e541", "M112 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 304l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-223.1L59.4 304.5c-9.1 15.1-28.8 20-43.9 10.9s-20-28.8-10.9-43.9l58.3-97c17.4-28.9 48.6-46.6 82.3-46.6l29.7 0c33.7 0 64.9 17.7 82.3 46.6l44.9 74.7c-16.1 17.6-28.6 38.5-36.6 61.5c-1.9-1.8-3.5-3.9-4.9-6.3L232 256.9 232 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-16 0zM432 224a144 144 0 1 1 0 288 144 144 0 1 1 0-288zm16 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48z"]
}, faChartPie = {
  prefix: "fas",
  iconName: "chart-pie",
  icon: [576, 512, ["pie-chart"], "f200", "M304 240l0-223.4c0-9 7-16.6 16-16.6C443.7 0 544 100.3 544 224c0 9-7.6 16-16.6 16L304 240zM32 272C32 150.7 122.1 50.3 239 34.3c9.2-1.3 17 6.1 17 15.4L256 288 412.5 444.5c6.7 6.7 6.2 17.7-1.5 23.1C371.8 495.6 323.8 512 272 512C139.5 512 32 404.6 32 272zm526.4 16c9.3 0 16.6 7.8 15.4 17c-7.7 55.9-34.6 105.6-73.9 142.3c-6 5.6-15.4 5.2-21.2-.7L320 288l238.4 0z"]
}, faPieChart = faChartPie, faBoltLightning = {
  prefix: "fas",
  iconName: "bolt-lightning",
  icon: [384, 512, [], "e0b7", "M0 256L28.5 28c2-16 15.6-28 31.8-28H228.9c15 0 27.1 12.1 27.1 27.1c0 3.2-.6 6.5-1.7 9.5L208 160H347.3c20.2 0 36.7 16.4 36.7 36.7c0 7.4-2.2 14.6-6.4 20.7l-192.2 281c-5.9 8.6-15.6 13.7-25.9 13.7h-2.9c-15.7 0-28.5-12.8-28.5-28.5c0-2.3 .3-4.6 .9-6.9L176 288H32c-17.7 0-32-14.3-32-32z"]
}, faClockEight = {
  prefix: "fas",
  iconName: "clock-eight",
  icon: [512, 512, [], "e345", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm24-392l0 136c0 8-4 15.5-10.7 20l-96 64c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3L232 243.2 232 120c0-13.3 10.7-24 24-24s24 10.7 24 24z"]
}, faSackXmark = {
  prefix: "fas",
  iconName: "sack-xmark",
  icon: [512, 512, [], "e56a", "M192 96l128 0 47.4-71.1C374.5 14.2 366.9 0 354.1 0L157.9 0c-12.8 0-20.4 14.2-13.3 24.9L192 96zm128 32l-128 0c-3.8 2.5-8.1 5.3-13 8.4c0 0 0 0 0 0s0 0 0 0C122.3 172.7 0 250.9 0 416c0 53 43 96 96 96l320 0c53 0 96-43 96-96c0-165.1-122.3-243.3-179-279.6c-4.8-3.1-9.2-5.9-13-8.4zM289.9 336l47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47z"]
}, faFileXls = {
  prefix: "fas",
  iconName: "file-xls",
  icon: [512, 512, [], "e64d", "M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-176 0c-35.3 0-64 28.7-64 64l0 144-80 0c-35.3 0-64-28.7-64-64L0 64zm384 64l-128 0L256 0 384 128zM224 368c0 7.3 2.2 14.4 6.2 20.4l9.8 14.7 9.8-14.7c4-6.1 6.2-13.2 6.2-20.4c0-8.8 7.2-16 16-16s16 7.2 16 16c0 13.6-4 26.9-11.6 38.2L259.2 432l17.2 25.8C284 469.1 288 482.4 288 496c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-7.3-2.2-14.4-6.2-20.4L240 460.8l-9.8 14.7c-4 6.1-6.2 13.2-6.2 20.4c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-13.6 4-26.9 11.6-38.2L220.8 432l-17.2-25.8C196 394.9 192 381.6 192 368c0-8.8 7.2-16 16-16s16 7.2 16 16zm96 128l0-128c0-8.8 7.2-16 16-16s16 7.2 16 16l0 112 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16zm88-98.3c0-25.2 20.4-45.7 45.7-45.7l26.3 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-26.3 0c-7.5 0-13.7 6.1-13.7 13.7c0 5.2 2.9 9.9 7.6 12.2l31.2 15.6c15.5 7.7 25.2 23.5 25.2 40.8c0 25.2-20.4 45.7-45.7 45.7L432 512c-8.8 0-16-7.2-16-16s7.2-16 16-16l26.3 0c7.5 0 13.7-6.1 13.7-13.7c0-5.2-2.9-9.9-7.6-12.2l-31.2-15.6C417.8 430.8 408 415 408 397.7z"]
}, faFileExcel = {
  prefix: "fas",
  iconName: "file-excel",
  icon: [384, 512, [], "f1c3", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM155.7 250.2L192 302.1l36.3-51.9c7.6-10.9 22.6-13.5 33.4-5.9s13.5 22.6 5.9 33.4L221.3 344l46.4 66.2c7.6 10.9 5 25.8-5.9 33.4s-25.8 5-33.4-5.9L192 385.8l-36.3 51.9c-7.6 10.9-22.6 13.5-33.4 5.9s-13.5-22.6-5.9-33.4L162.7 344l-46.4-66.2c-7.6-10.9-5-25.8 5.9-33.4s25.8-5 33.4 5.9z"]
}, faFileContract = {
  prefix: "fas",
  iconName: "file-contract",
  icon: [384, 512, [], "f56c", "M64 0C28.7 0 0 28.7 0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-288-128 0c-17.7 0-32-14.3-32-32L224 0 64 0zM256 0l0 128 128 0L256 0zM80 64l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 96c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm54.2 253.8c-6.1 20.3-24.8 34.2-46 34.2L80 416c-8.8 0-16-7.2-16-16s7.2-16 16-16l8.2 0c7.1 0 13.3-4.6 15.3-11.4l14.9-49.5c3.4-11.3 13.8-19.1 25.6-19.1s22.2 7.7 25.6 19.1l11.6 38.6c7.4-6.2 16.8-9.7 26.8-9.7c15.9 0 30.4 9 37.5 23.2l4.4 8.8 54.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-6.1 0-11.6-3.4-14.3-8.8l-8.8-17.7c-1.7-3.4-5.1-5.5-8.8-5.5s-7.2 2.1-8.8 5.5l-8.8 17.7c-2.9 5.9-9.2 9.4-15.7 8.8s-12.1-5.1-13.9-11.3L144 349l-9.8 32.8z"]
}, faFishFins = {
  prefix: "fas",
  iconName: "fish-fins",
  icon: [576, 512, [], "e4f2", "M275.2 38.4c-10.6-8-25-8.5-36.3-1.5S222 57.3 224.6 70.3l9.7 48.6c-19.4 9-36.9 19.9-52.4 31.5c-15.3 11.5-29 23.9-40.7 36.3L48.1 132.4c-12.5-7.3-28.4-5.3-38.6 4.9S-3 163.3 4.2 175.9L50 256 4.2 336.1c-7.2 12.6-5 28.4 5.3 38.6s26.1 12.2 38.6 4.9l93.1-54.3c11.8 12.3 25.4 24.8 40.7 36.3c15.5 11.6 33 22.5 52.4 31.5l-9.7 48.6c-2.6 13 3.1 26.3 14.3 33.3s25.6 6.5 36.3-1.5l77.6-58.2c54.9-4 101.5-27 137.2-53.8c39.2-29.4 67.2-64.7 81.6-89.5c5.8-9.9 5.8-22.2 0-32.1c-14.4-24.8-42.5-60.1-81.6-89.5c-35.8-26.8-82.3-49.8-137.2-53.8L275.2 38.4zM384 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]
}, faCircleQ = {
  prefix: "fas",
  iconName: "circle-q",
  icon: [512, 512, [], "e11e", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM176 256c0 44.2 35.8 80 80 80c13.4 0 25.9-3.3 37-9.1l-30-30c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l30 30c5.8-11.1 9.1-23.7 9.1-37c0-44.2-35.8-80-80-80s-80 35.8-80 80zm208 0c0 26.7-8.2 51.4-22.1 71.9L377 343c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-15.1-15.1c-20.5 14-45.3 22.1-71.9 22.1c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128z"]
}, faBuildingFlag = {
  prefix: "fas",
  iconName: "building-flag",
  icon: [640, 512, [], "e4d5", "M48 0C21.5 0 0 21.5 0 48L0 464c0 26.5 21.5 48 48 48l96 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 96 0c26.5 0 48-21.5 48-48l0-416c0-26.5-21.5-48-48-48L48 0zM64 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm112-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM80 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm80 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM272 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM448 0c-17.7 0-32 14.3-32 32l0 480 64 0 0-320 144 0c8.8 0 16-7.2 16-16l0-128c0-8.8-7.2-16-16-16L480 32c0-17.7-14.3-32-32-32z"]
}, faFaceGrinBeam = {
  prefix: "fas",
  iconName: "face-grin-beam",
  icon: [512, 512, [128516, "grin-beam"], "f582", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zM388.1 312.8c12.3-3.8 24.3 6.9 19.3 18.7C382.4 390.6 324.2 432 256.3 432s-126.2-41.4-151.1-100.5c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19zm-170.5-84s0 0 0 0c0 0 0 0 0 0l-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8c0 0 0 0 0 0s0 0 0 0zm160 0c0 0 0 0 0 0l-.2-.2c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .2c0 0 0 0 0 0c0 0 0 0 0 0s0 0 0 0c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8c0 0 0 0 0 0s0 0 0 0s0 0 0 0z"]
}, faGrinBeam = faFaceGrinBeam, faObjectUngroup = {
  prefix: "fas",
  iconName: "object-ungroup",
  icon: [640, 512, [], "f248", "M32 119.4C12.9 108.4 0 87.7 0 64C0 28.7 28.7 0 64 0c23.7 0 44.4 12.9 55.4 32l209.1 0C339.6 12.9 360.3 0 384 0c35.3 0 64 28.7 64 64c0 23.7-12.9 44.4-32 55.4l0 113.1c19.1 11.1 32 31.7 32 55.4c0 35.3-28.7 64-64 64c-23.7 0-44.4-12.9-55.4-32l-209.1 0c-11.1 19.1-31.7 32-55.4 32c-35.3 0-64-28.7-64-64c0-23.7 12.9-44.4 32-55.4l0-113.1zM119.4 96c-5.6 9.7-13.7 17.8-23.4 23.4l0 113.1c9.7 5.6 17.8 13.7 23.4 23.4l209.1 0c5.6-9.7 13.7-17.8 23.4-23.4l0-113.1c-9.7-5.6-17.8-13.7-23.4-23.4L119.4 96zm192 384c-11.1 19.1-31.7 32-55.4 32c-35.3 0-64-28.7-64-64c0-23.7 12.9-44.4 32-55.4l0-40.6 64 0 0 40.6c9.7 5.6 17.8 13.7 23.4 23.4l209.1 0c5.6-9.7 13.7-17.8 23.4-23.4l0-113.1c-9.7-5.6-17.8-13.7-23.4-23.4l-46 0c-5.4-15.4-14.6-28.9-26.5-39.6l0-24.4 72.6 0c11.1-19.1 31.7-32 55.4-32c35.3 0 64 28.7 64 64c0 23.7-12.9 44.4-32 55.4l0 113.1c19.1 11.1 32 31.7 32 55.4c0 35.3-28.7 64-64 64c-23.7 0-44.4-12.9-55.4-32l-209.1 0z"]
}, faFaceDisguise = {
  prefix: "fas",
  iconName: "face-disguise",
  icon: [512, 512, [], "e370", "M256 512c141.4 0 256-114.6 256-256c0-16.4-1.5-32.5-4.5-48L440 208c0 50.1-38.4 91.2-87.3 95.6c9.6 7.9 15.3 19.7 15.3 32.4c0 15.9-9 30.4-23.1 37.5L364.5 398c5.5 6.9 4.4 17-2.5 22.5s-17 4.4-22.5-2.5l-23.9-29.9-7.3 3.6 10.5 26.3c3.3 8.2-.7 17.5-8.9 20.8s-17.5-.7-20.8-8.9l-10-24.9c-2.4 .7-4.8 1.3-7.2 1.8l0 25.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-25.2c-2.4-.5-4.8-1.1-7.2-1.8l-10 24.9c-3.3 8.2-12.6 12.2-20.8 8.9s-12.2-12.6-8.9-20.8l10.5-26.3-7.3-3.6L172.5 418c-5.5 6.9-15.6 8-22.5 2.5s-8-15.6-2.5-22.5l19.6-24.5C153 366.4 144 351.9 144 336c0-12.7 5.7-24.5 15.3-32.4C110.4 299.2 72 258.1 72 208L4.5 208C1.5 223.5 0 239.6 0 256C0 397.4 114.6 512 256 512zm61.9-245.5c7.9 3.5 16.8 5.5 26.1 5.5c35.3 0 64-28.7 64-64s-28.7-64-64-64s-64 28.7-64 64c0 2.5 .1 4.9 .4 7.3c5.4 3.6 10.1 8.4 13.5 14.1l21.4 35.7c1.1 .6 1.9 1 2.6 1.3zM232 208c0-35.3-28.7-64-64-64s-64 28.7-64 64s28.7 64 64 64c9.3 0 18.1-2 26.1-5.5c.6-.3 1.5-.7 2.6-1.3L218 229.5c3.5-5.8 8.1-10.6 13.5-14.1c.3-2.4 .4-4.9 .4-7.3zM12.7 176l64.7 0c5.3-14.9 14.1-28 25.4-38.5l-5.2-10.3c-4-7.9-.7-17.5 7.2-21.5s17.5-.7 21.5 7.2l3.5 7c4.6-2 9.3-3.6 14.2-4.9l0-19c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16.3c4.4 .4 8.7 1 13 2l4.7-9.5c4-7.9 13.6-11.1 21.5-7.2s11.1 13.6 7.2 21.5l-3.6 7.3c16.4 10.2 29.5 25.3 37.3 43.1c7.8-17.9 20.9-32.9 37.3-43.1l-3.6-7.3c-4-7.9-.7-17.5 7.2-21.5s17.5-.7 21.5 7.2l4.7 9.5c4.2-.9 8.6-1.6 13-2L336 96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 19c4.9 1.3 9.6 2.9 14.2 4.9l3.5-7c4-7.9 13.6-11.1 21.5-7.2s11.1 13.6 7.2 21.5l-5.2 10.3c11.3 10.5 20.1 23.7 25.4 38.5l64.7 0C465.7 73.8 369.4 0 256 0S46.3 73.8 12.7 176zM256 240c-4.3 0-8.3 2.3-10.5 6l-39.8 66.3-2.4 4-4.2 2.1-17.7 8.8c-3.4 1.7-5.5 5.1-5.5 8.8s2.1 7.2 5.5 8.8l53.1 26.5c13.5 6.8 29.4 6.8 42.9 0l53.1-26.5c3.4-1.7 5.5-5.1 5.5-8.8s-2.1-7.2-5.5-8.8l-17.7-8.8-4.2-2.1-2.4-4L266.5 246c-2.2-3.7-6.2-6-10.5-6zM144 216a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm200-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]
}, faCircleArrowDownRight = {
  prefix: "fas",
  iconName: "circle-arrow-down-right",
  icon: [512, 512, [], "e0fa", "M256 0a256 256 0 1 0 0 512A256 256 0 1 0 256 0zM192 368c-13.3 0-24-10.7-24-24s10.7-24 24-24l94.1 0L151 185c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l135 135L320 184c0-13.3 10.7-24 24-24s24 10.7 24 24l0 160c0 13.3-10.7 24-24 24l-152 0z"]
}, faAlien8bit = {
  prefix: "fas",
  iconName: "alien-8bit",
  icon: [576, 512, [128126, "alien-monster"], "f8f6", "M96 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 16 48 0c8.8 0 16 7.2 16 16l0 48 128 0 0-48c0-8.8 7.2-16 16-16l48 0 0-16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 32 0 32 48 0c8.8 0 16 7.2 16 16l0 48 32 0 0-80c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 128c0 8.8-7.2 16-16 16l-48 0 0 80c0 8.8-7.2 16-16 16l-48 0 0 80c0 8.8-7.2 16-16 16l-48 0-48 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l48 0 0-32-192 0 0 32 48 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0-48 0c-8.8 0-16-7.2-16-16l0-80-48 0c-8.8 0-16-7.2-16-16l0-80-48 0c-8.8 0-16-7.2-16-16L0 144c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 80 32 0 0-48c0-8.8 7.2-16 16-16l48 0 0-32 0-32-48 0c-8.8 0-16-7.2-16-16l0-32zm64 192l0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm192 0l0 64c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]
}, faAlienMonster = faAlien8bit, faHandPointRibbon = {
  prefix: "fas",
  iconName: "hand-point-ribbon",
  icon: [448, 512, [], "e1a6", "M64 32C64 14.3 78.3 0 96 0s32 14.3 32 32l16 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16L11.8 128C5.3 128 0 122.7 0 116.2c0-3.9 1.9-7.5 5.1-9.7L43.6 80 5.1 53.5C1.9 51.3 0 47.7 0 43.8C0 37.3 5.3 32 11.8 32L64 32zm0 208l0-80 64 0 0 80-64 0zm192-48c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-64-64c17.7 0 32 14.3 32 32l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32zm160 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm-96 88l0-.6c9.4 5.4 20.3 8.6 32 8.6c13.2 0 25.4-4 35.6-10.8c8.7 24.9 32.5 42.8 60.4 42.8c11.7 0 22.6-3.1 32-8.6l