/*!
 * Font Awesome Pro 6.7.2 by @fontawesome - https://fontawesome.com
 * License - https://fontawesome.com/license (Commercial License)
 * Copyright 2024 Fonticons, Inc.
 */
const fa0 = {
  prefix: "fad",
  iconName: "0",
  icon: [320, 512, [], "30", ["M0 192C0 103.6 71.6 32 160 32s160 71.6 160 160l0 128c0 88.4-71.6 160-160 160S0 408.4 0 320L0 192zM160 96c-53 0-96 43-96 96l0 128c0 53 43 96 96 96s96-43 96-96l0-128c0-53-43-96-96-96z", ""]]
}, fa1 = {
  prefix: "fad",
  iconName: "1",
  icon: [256, 512, [], "31", ["M160 64c0-11.8-6.5-22.6-16.9-28.2s-23-5-32.8 1.6l-96 64C-.5 111.2-4.4 131 5.4 145.8s29.7 18.7 44.4 8.9L96 123.8 96 416l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-352z", ""]]
}, fa2 = {
  prefix: "fad",
  iconName: "2",
  icon: [320, 512, [], "32", ["M142.9 96c-21.5 0-42.2 8.5-57.4 23.8L54.6 150.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L40.2 74.5C67.5 47.3 104.4 32 142.9 32C223 32 288 97 288 177.1c0 38.5-15.3 75.4-42.5 102.6L109.3 416 288 416c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L200.2 234.5c15.2-15.2 23.8-35.9 23.8-57.4c0-44.8-36.3-81.1-81.1-81.1z", ""]]
}, fa3 = {
  prefix: "fad",
  iconName: "3",
  icon: [320, 512, [], "33", ["M0 64C0 46.3 14.3 32 32 32l240 0c13.2 0 25 8.1 29.8 20.4s1.5 26.3-8.2 35.2L162.3 208l21.7 0c75.1 0 136 60.9 136 136s-60.9 136-136 136l-78.6 0C63 480 24.2 456 5.3 418.1l-1.9-3.8c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3l1.9 3.8c8.1 16.3 24.8 26.5 42.9 26.5l78.6 0c39.8 0 72-32.2 72-72s-32.2-72-72-72L80 272c-13.2 0-25-8.1-29.8-20.4s-1.5-26.3 8.2-35.2L189.7 96 32 96C14.3 96 0 81.7 0 64z", ""]]
}, fa4 = {
  prefix: "fad",
  iconName: "4",
  icon: [384, 512, [], "34", ["M189 77.6c7.5-16 .7-35.1-15.3-42.6s-35.1-.7-42.6 15.3L3 322.4c-4.7 9.9-3.9 21.5 1.9 30.8S21 368 32 368l224 0 0 80c0 17.7 14.3 32 32 32s32-14.3 32-32l0-80 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 144L82.4 304 189 77.6z", ""]]
}, fa5 = {
  prefix: "fad",
  iconName: "5",
  icon: [320, 512, [], "35", ["M32.5 58.3C35.3 43.1 48.5 32 64 32l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L90.7 96 70.3 208 184 208c75.1 0 136 60.9 136 136s-60.9 136-136 136l-83.5 0c-39.4 0-75.4-22.3-93-57.5l-4.1-8.2c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3l4.1 8.2c6.8 13.6 20.6 22.1 35.8 22.1l83.5 0c39.8 0 72-32.2 72-72s-32.2-72-72-72L32 272c-9.5 0-18.5-4.2-24.6-11.5s-8.6-16.9-6.9-26.2l32-176z", ""]]
}, fa6 = {
  prefix: "fad",
  iconName: "6",
  icon: [320, 512, [], "36", ["M232.4 84.7c11.4-13.5 9.7-33.7-3.8-45.1s-33.7-9.7-45.1 3.8L38.6 214.7C14.7 242.9 1.1 278.4 .1 315.2c0 1.4-.1 2.9-.1 4.3l0 .5c0 88.4 71.6 160 160 160s160-71.6 160-160c0-85.5-67.1-155.4-151.5-159.8l63.9-75.6zM256 320A96 96 0 1 1 64 320a96 96 0 1 1 192 0z", ""]]
}, fa7 = {
  prefix: "fad",
  iconName: "7",
  icon: [320, 512, [], "37", ["M0 64C0 46.3 14.3 32 32 32l256 0c11.5 0 22 6.1 27.7 16.1s5.7 22.2-.1 32.1l-224 384c-8.9 15.3-28.5 20.4-43.8 11.5s-20.4-28.5-11.5-43.8L232.3 96 32 96C14.3 96 0 81.7 0 64z", ""]]
}, fa8 = {
  prefix: "fad",
  iconName: "8",
  icon: [320, 512, [], "38", ["M304 160c0-70.7-57.3-128-128-128l-32 0C73.3 32 16 89.3 16 160c0 34.6 13.7 66 36 89C20.5 272.3 0 309.8 0 352c0 70.7 57.3 128 128 128l64 0c70.7 0 128-57.3 128-128c0-42.2-20.5-79.7-52-103c22.3-23 36-54.4 36-89zM176.1 288l15.9 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l15.9 0c0 0 .1 0 .1 0l32 0c0 0 .1 0 .1 0zm0-64c0 0 0 0 0 0l-32 0c0 0 0 0 0 0c-35.3 0-64-28.7-64-64c0-35.3 28.7-64 64-64l32 0c35.3 0 64 28.7 64 64c0 35.3-28.6 64-64 64z", ""]]
}, fa9 = {
  prefix: "fad",
  iconName: "9",
  icon: [320, 512, [], "39", ["M64 192a96 96 0 1 0 192 0A96 96 0 1 0 64 192zm87.5 159.8C67.1 347.4 0 277.5 0 192C0 103.6 71.6 32 160 32s160 71.6 160 160c0 2.6-.1 5.3-.2 7.9c-1.7 35.7-15.2 70-38.4 97.4l-145 171.4c-11.4 13.5-31.6 15.2-45.1 3.8s-15.2-31.6-3.8-45.1l63.9-75.6z", ""]]
}, faFillDrip = {
  prefix: "fad",
  iconName: "fill-drip",
  icon: [576, 512, [], "f576", ["M66.5 296c0 8.2 3.1 16.4 9.4 22.6L193.4 436.1c12.5 12.5 32.8 12.5 45.3 0C288 386.7 337.4 337.4 386.7 288L67.5 288c-.7 2.6-1 5.3-1 8zM448 448c0 35.3 28.7 64 64 64s64-28.7 64-64c0-25.2-32.6-79.6-51.2-108.7c-6-9.4-19.5-9.4-25.5 0C480.6 368.4 448 422.8 448 448z", "M86.6 9.4C74.1-3.1 53.9-3.1 41.4 9.4s-12.5 32.8 0 45.3L122.7 136 30.6 228.1c-37.5 37.5-37.5 98.3 0 135.8L148.1 481.4c37.5 37.5 98.3 37.5 135.8 0L474.3 290.9c28.1-28.1 28.1-73.7 0-101.8L322.9 37.7c-28.1-28.1-73.7-28.1-101.8 0L168 90.7 86.6 9.4zM168 181.3l49.4 49.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L213.3 136l53.1-53.1c3.1-3.1 8.2-3.1 11.3 0L429.1 234.3c3.1 3.1 3.1 8.2 0 11.3L238.6 436.1c-12.5 12.5-32.8 12.5-45.3 0L75.9 318.6c-12.5-12.5-12.5-32.8 0-45.3L168 181.3z"]]
}, faArrowsToCircle = {
  prefix: "fad",
  iconName: "arrows-to-circle",
  icon: [640, 512, [], "e4bd", ["M256 256a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M9.4 9.4C21.9-3.1 42.1-3.1 54.6 9.4L160 114.7 160 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 4.3-.9 8.5-2.4 12.2c-1.6 3.7-3.8 7.3-6.9 10.3l-.1 .1c-3.1 3-6.6 5.3-10.3 6.9c-3.8 1.6-7.9 2.4-12.2 2.4l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l18.7 0L9.4 54.6C-3.1 42.1-3.1 21.9 9.4 9.4zM114.7 352L96 352c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0s0 0 0 0l.1 0c8.8 0 16.7 3.6 22.5 9.3l.1 .1c3 3.1 5.3 6.6 6.9 10.3c1.6 3.8 2.4 7.9 2.4 12.2l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-18.7L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L114.7 352zM416 96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 18.7L585.4 9.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L525.3 160l18.7 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-8.8 0-16.8-3.6-22.6-9.3l-.1-.1c-3-3.1-5.3-6.6-6.9-10.3s-2.4-7.8-2.4-12.2l0-.1s0 0 0 0l0-96zM525.3 352L630.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L480 397.3l0 18.7c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96s0 0 0 0l0-.1c0-4.3 .9-8.4 2.4-12.2c1.6-3.8 3.9-7.3 6.9-10.4c5.8-5.8 13.7-9.3 22.5-9.4l.1 0s0 0 0 0l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-18.7 0z"]]
}, faCircleChevronRight = {
  prefix: "fad",
  iconName: "circle-chevron-right",
  icon: [512, 512, ["chevron-circle-right"], "f138", ["M512 256A256 256 0 1 1 0 256a256 256 0 1 1 512 0zM200 152c0 6.1 2.3 12.3 7 17l87 87-87 87c-4.7 4.7-7 10.8-7 17s2.3 12.3 7 17s10.8 7 17 7s12.3-2.3 17-7L345 273c4.7-4.7 7-10.8 7-17s-2.3-12.3-7-17L241 135c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7s-7 10.8-7 17z", "M345 239c9.4 9.4 9.4 24.6 0 33.9L241 377c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l87-87-87-87c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L345 239z"]]
}, faChevronCircleRight = faCircleChevronRight, faWagonCovered = {
  prefix: "fad",
  iconName: "wagon-covered",
  icon: [640, 512, [], "f8ee", ["M2.1 43.9c0 4.4 .8 9 2.4 13.5L64 224l160 0 0-178.1c0-16.8-13.1-30.8-29.9-31.9L44.8 4.1C20.9 2.5 2.1 21.7 2.1 43.9zM64 400c0 61.9 50.1 112 112 112c56.4 0 103.1-41.7 110.9-96c.4-2.6 .7-5.3 .8-7.9c.1-1.3 .2-2.7 .2-4c0-1.4 .1-2.7 .1-4.1c0-2 0-2.4 0-2.9c0-.9-.1-1.9-.1-2.9c-.1-1.9-.2-3.8-.4-5.7c-.4-3.8-1-7.5-1.7-11.1c-1.5-7.3-3.7-14.3-6.5-21c-5.7-13.4-13.9-25.5-24-35.6C234.9 300.5 206.9 288 176 288c-30.5 0-58.2 12.2-78.4 32C76.9 340.3 64 368.7 64 400zm50-16c5.8-22.5 23.5-40.2 46-46l0 46-46 0zm0 32l46 0 0 46c-22.5-5.8-40.2-23.5-46-46zm78-78c22.5 5.8 40.2 23.5 46 46l-46 0 0-46zm0 78l46 0c-5.8 22.5-23.5 40.2-46 46l0-46zM256 48l0 176 128 0 0-176c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zm96 352a112 112 0 1 0 224 .2A112 112 0 1 0 352 400zm50-16c5.8-22.5 23.5-40.2 46-46l0 46-46 0zm0 32l46 0 0 46c-22.5-5.8-40.2-23.5-46-46zM416 45.9L416 224l160 0L635.5 57.4C644.9 31.2 625.2 4 597.9 4c-.9 0-1.8 0-2.8 .1L445.9 14C429.1 15.1 416 29.1 416 45.9zM480 338c22.5 5.8 40.2 23.5 46 46l-46 0 0-46zm0 78l46 0c-5.8 22.5-23.5 40.2-46 46l0-46z", "M96 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l1.6 0c20.2-19.8 47.9-32 78.4-32c61.9 0 112 50.1 112 112c0 5.4-.4 10.8-1.1 16l66.3 0c-.7-5.2-1.1-10.6-1.1-16c0-61.9 50.1-112 112-112c30.5 0 58.2 12.2 78.4 32l1.6 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 256z"]]
}, faLineHeight = {
  prefix: "fad",
  iconName: "line-height",
  icon: [576, 512, [], "f871", ["M256 96c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32zm0 160c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32zm0 160c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32z", "M73.4 41.4c12.5-12.5 32.8-12.5 45.3 0l64 64c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-9.4-9.4 0 229.5 9.4-9.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-64 64c-12.5 12.5-32.8 12.5-45.3 0l-64-64c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l9.4 9.4 0-229.5-9.4 9.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l64-64z"]]
}, faBagel = {
  prefix: "fad",
  iconName: "bagel",
  icon: [640, 512, [129391], "e3d7", ["M319.4 91.4c29.8 15.7 56 37.4 76.8 63.6c10.2-6.9 22.6-11 35.9-11c35.3 0 64 28.7 64 64c0 30.6-21.5 56.3-50.3 62.5c1.5 10.9 2.3 22.1 2.3 33.5c0 25.4-3.9 49.9-11.3 72.9c4.7-.7 9.3-2.5 13.3-5.2c7-4.8 13.9-9.6 20.9-14.3c5.1-3.5 11.1-5.4 17.2-5.6c8.4-.2 16.9-.5 25.3-.7c13.2-.4 24.8-8.8 29.3-21.3c2.8-8 5.7-15.9 8.5-23.9c2.1-5.8 5.8-10.9 10.6-14.6c6.7-5.2 13.4-10.3 20.1-15.5c10.5-8.1 14.9-21.7 11.2-34.4c-2.4-8.1-4.8-16.2-7.2-24.3c-1.7-5.9-1.7-12.2 0-18.1c2.4-8.1 4.8-16.2 7.2-24.3c3.7-12.7-.7-26.3-11.2-34.4c-6.7-5.2-13.4-10.3-20.1-15.5c-4.9-3.8-8.6-8.8-10.6-14.6c-2.8-8-5.7-15.9-8.5-23.9c-4.4-12.4-16.1-20.9-29.3-21.3c-8.4-.2-16.9-.5-25.3-.7c-6.2-.2-12.1-2.1-17.2-5.6c-7-4.8-13.9-9.5-20.9-14.3c-1.4-1-2.8-1.8-4.3-2.5s-2.9-1.3-4.4-1.7c-3.1-.9-6.2-1.4-9.4-1.4c-6.3 0-12.6 1.9-18 5.6c-7 4.8-14 9.6-21 14.4c-5.1 3.5-11.1 5.4-17.2 5.6c-8.4 .2-16.9 .5-25.3 .7c-13.2 .4-24.8 8.8-29.3 21.3c-.6 1.7-1.2 3.4-1.8 5.1z", "M432 416c-3.9 0-7.7-.1-11.5-.3c6.5-12.3 12-25.3 16.3-38.8c4.7-.7 9.3-2.5 13.3-5.3L471 357.3c5.1-3.5 11-5.4 17.2-5.6l25.3-.7c13.2-.4 24.8-8.8 29.3-21.3l8.5-23.9c2.1-5.8 5.8-10.9 10.6-14.6L582 275.8c10.5-8.1 14.9-21.7 11.2-34.4L586 217c-1.7-5.9-1.7-12.2 0-18.1l7.2-24.3c3.7-12.7-.7-26.3-11.2-34.4l-20.1-15.5c-4.9-3.8-8.6-8.8-10.6-14.6l-8.5-23.9c-4.4-12.5-16.1-20.9-29.3-21.3l-25.3-.7c-6.2-.2-12.1-2.1-17.2-5.6L450.1 44.4c-10.9-7.5-25.3-7.5-36.2 0L393 58.7c-5.1 3.5-11 5.4-17.2 5.6L350.5 65c-13.2 .4-24.8 8.8-29.3 21.3l-1.8 5.1c-14.4-7.6-29.7-13.7-45.7-18.3C311.8 28.4 368.6 0 432 0C546.9 0 640 93.1 640 208s-93.1 208-208 208zM0 304a208 208 0 1 1 416 0A208 208 0 1 1 0 304zm256 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM112 416a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm144 16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48-16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16-176a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM144 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM96 272a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]]
}, faTransporter7 = {
  prefix: "fad",
  iconName: "transporter-7",
  icon: [512, 512, [], "e2a8", ["M0 304c0 4.1 2.7 7.6 6.6 8.7L32 320l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 320l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 288l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L32 288 6.6 295.3C2.7 296.4 0 299.9 0 304zM416 80c0 4.1 2.7 7.6 6.6 8.7L448 96l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 96l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 64l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L448 64l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7z", "M96 480c0-17.7 14.3-32 32-32H384c17.7 0 32 14.3 32 32s-14.3 32-32 32H128c-17.7 0-32-14.3-32-32z"]]
}, faAt = {
  prefix: "fad",
  iconName: "at",
  icon: [512, 512, [61946], "40", ["M256 64C150 64 64 150 64 256s86 192 192 192c17.7 0 32 14.3 32 32s-14.3 32-32 32C114.6 512 0 397.4 0 256S114.6 0 256 0S512 114.6 512 256l0 32c0 53-43 96-96 96c-29.3 0-55.6-13.2-73.2-33.9C320 371.1 289.5 384 256 384c-70.7 0-128-57.3-128-128s57.3-128 128-128c27.9 0 53.7 8.9 74.7 24.1c5.7-5 13.1-8.1 21.3-8.1c17.7 0 32 14.3 32 32l0 80 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32c0-106-86-192-192-192zm64 192a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z", ""]]
}, faRectanglesMixed = {
  prefix: "fad",
  iconName: "rectangles-mixed",
  icon: [576, 512, [], "e323", ["M64 352l0 80c0 26.5 21.5 48 48 48l176 0c26.5 0 48-21.5 48-48l0-80c0-26.5-21.5-48-48-48l-176 0c-26.5 0-48 21.5-48 48zM384 80l0 256c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-256c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48z", "M0 80C0 53.5 21.5 32 48 32H272c26.5 0 48 21.5 48 48V208c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80z"]]
}, faPhoneArrowUpRight = {
  prefix: "fad",
  iconName: "phone-arrow-up-right",
  icon: [512, 512, ["phone-arrow-up", "phone-outgoing"], "e224", ["M0 64C0 311.4 200.6 512 448 512c18 0 33.8-12.1 38.6-29.5l24-88c1-3.5 1.4-7 1.4-10.5c0-15.8-9.4-30.6-24.6-36.9l-96-40c-16.3-6.8-35.2-2.1-46.3 11.6L304.7 368C234.3 334.7 177.3 277.7 144 207.3L193.3 167c13.7-11.2 18.4-30 11.6-46.3l-40-96C158.6 9.4 143.8 0 128 0c-3.5 0-7 .5-10.5 1.4l-88 24C12.1 30.2 0 46 0 64z", "M295 217c-9.4-9.4-9.4-24.6 0-33.9l135-135L384 48c-13.3 0-24-10.7-24-24s10.7-24 24-24L488 0c13.3 0 24 10.7 24 24l0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-46.1L329 217c-9.4 9.4-24.6 9.4-33.9 0z"]]
}, faPhoneArrowUp = faPhoneArrowUpRight, faPhoneOutgoing = faPhoneArrowUpRight, faTrashCan = {
  prefix: "fad",
  iconName: "trash-can",
  icon: [448, 512, [61460, "trash-alt"], "f2ed", ["M32 96l0 352c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-352L32 96zm80 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224zm96 0c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224zm96 0c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224z", "M163.8 0c-12.1 0-23.2 6.8-28.6 17.7L128 32 32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0-7.2-14.3C307.4 6.8 296.3 0 284.2 0L163.8 0z"]]
}, faTrashAlt = faTrashCan, faCircleL = {
  prefix: "fad",
  iconName: "circle-l",
  icon: [512, 512, [], "e114", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM160 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 184 120 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24l0-208z", "M184 128c13.3 0 24 10.7 24 24l0 184 120 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24z"]]
}, faHeadSideGoggles = {
  prefix: "fad",
  iconName: "head-side-goggles",
  icon: [512, 512, ["head-vr"], "f6ea", ["M32 192l208 0c14.6 19.4 37.8 32 64 32l112 0 32 0 32 0 2.6 0 19.8 24.8c6.2 7.8 9.6 17.4 9.6 27.4c0 24.2-19.6 43.8-43.8 43.8L448 320l0 64c0 35.3-28.7 64-64 64l-64 0 0 32c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-104.2c0-17-7.1-33-17.5-46.4C50.3 293.2 32 246.5 32 201.7c0-3.3 .1-6.5 0-9.7zm13.9-64C75.3 53.1 148.3 0 233.7 0L256 0c56.9 0 108 24.7 143.1 64L304 64c-38.7 0-71 27.5-78.4 64L45.9 128z", "M304 64l112 0 0 160-112 0c-26.2 0-49.4-12.6-64-32L32 192c-17.7 0-32-14.3-32-32s14.3-32 32-32l193.6 0C233 91.5 265.3 64 304 64zM480 224l-32 0 0-160 32 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32z"]]
}, faHeadVr = faHeadSideGoggles, faTextHeight = {
  prefix: "fad",
  iconName: "text-height",
  icon: [576, 512, [], "f034", ["M0 80l0 48c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 64 0 0 320-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-320 64 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48c0-26.5-21.5-48-48-48L160 32 48 32C21.5 32 0 53.5 0 80z", "M457.4 41.4c12.5-12.5 32.8-12.5 45.3 0l64 64c9.2 9.2 11.9 22.9 6.9 34.9s-16.6 19.8-29.6 19.8l-32 0 0 192 32 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-64 64c-12.5 12.5-32.8 12.5-45.3 0l-64-64c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8l32 0 0-192-32 0c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l64-64z"]]
}, faUserXmark = {
  prefix: "fad",
  iconName: "user-xmark",
  icon: [640, 512, ["user-times"], "f235", ["M0 482.3C0 498.7 13.3 512 29.7 512l388.6 0c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304l-91.4 0C79.8 304 0 383.8 0 482.3zM96 128a128 128 0 1 0 256 0A128 128 0 1 0 96 128z", "M505 143c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]]
}, faUserTimes = faUserXmark, faFaceHandYawn = {
  prefix: "fad",
  iconName: "face-hand-yawn",
  icon: [512, 512, [], "e379", ["M0 256c0 94.5 51.2 177 127.3 221.4c-9.8-18-15.3-38.6-15.3-60.5l0-32.8 0-53.6c0-28.7 23.3-52 52-52c1.8 0 3.6 .1 5.3 .3C184.8 246.3 217.8 224 256 224c28.7 0 54.5 12.6 72.1 32.6c14.8-2.4 30.4 2 41.8 13.4c12.2 12.2 16.5 29.4 12.8 45c1.1 .9 2.2 1.9 3.2 3c18.1 18.1 18.7 47.1 1.8 65.9c16.9 18.8 16.3 47.8-1.8 65.9l-49 49C438.7 465.1 512 369.1 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256zm99.5-70c-5.5-6.9-4.4-17 2.5-22.5c26.7-21.3 53.3-42.7 80-64c6.9-5.5 17-4.4 22.5 2.5s4.4 17-2.5 22.5c-26.7 21.3-53.3 42.7-80 64c-6.9 5.5-17 4.4-22.5-2.5zm208-84c5.5-6.9 15.6-8 22.5-2.5c26.7 21.3 53.3 42.7 80 64c3.9 3.2 6 7.8 6 12.5c0 3.5-1.1 7-3.5 10c-5.5 6.9-15.6 8-22.5 2.5c-26.7-21.3-53.3-42.7-80-64c-6.9-5.5-8-15.6-2.5-22.5z", "M204.5 102c-5.5-6.9-15.6-8-22.5-2.5l-80 64c-6.9 5.5-8 15.6-2.5 22.5s15.6 8 22.5 2.5l80-64c6.9-5.5 8-15.6 2.5-22.5zm94.8 197.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-79 79c-5 5-13.7 1.5-13.7-5.7l0-19.7c0-11-9-20-20-20s-20 9-20 20l0 53.6 0 32.8c0 52.6 42.6 95.2 95.2 95.2c25.2 0 49.5-10 67.3-27.9l56.8-56.8c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L321.4 424c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l51.3-51.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L289.4 392c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l67.3-67.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L257.4 360c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l51.3-51.3zM310 124.5l80 64c6.9 5.5 17 4.4 22.5-2.5s4.4-17-2.5-22.5l-80-64c-6.9-5.5-17-4.4-22.5 2.5s-4.4 17 2.5 22.5z"]]
}, faGaugeSimpleMin = {
  prefix: "fad",
  iconName: "gauge-simple-min",
  icon: [512, 512, ["tachometer-slowest"], "f62d", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm64-8c0-4.3 1.2-8.7 3.6-12.6c7-11.3 21.8-14.8 33-7.8c39.2 24.3 78.4 48.5 117.6 72.8c10.6-7.8 23.7-12.4 37.8-12.4c35.3 0 64 28.7 64 64s-28.7 64-64 64s-64-28.7-64-64c0-3.7 .3-7.3 .9-10.8L75.4 268.4C68 263.9 64 256 64 248z", "M100.6 227.6c-11.3-7-26.1-3.5-33 7.8s-3.5 26.1 7.8 33l117.5 72.8c-.6 3.5-.9 7.1-.9 10.8c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64c-14.1 0-27.2 4.6-37.8 12.4L100.6 227.6z"]]
}, faTachometerSlowest = faGaugeSimpleMin, faStethoscope = {
  prefix: "fad",
  iconName: "stethoscope",
  icon: [576, 512, [129658], "f0f1", ["M160.5 348.9c5.1 1 10.3 1.8 15.5 2.3c2.6 .3 5.3 .5 7.9 .6c1.3 .1 2.7 .1 4 .1s2.7 0 4 0c11.2 0 22.1-1.2 32.8-2.8C231.3 404.8 278.6 448 336 448c61.9 0 112-50.1 112-112l0-70.7c4.9 2.1 10.1 3.8 15.4 4.9c2.7 .6 5.4 1 8.2 1.3c1.4 .1 2.8 .3 4.2 .3s2.8 .1 4.3 .1c11.4 0 22.2-2.4 32-6.7l0 70.7c0 97.2-78.8 176-176 176c-92.9 0-168.9-71.9-175.5-163.1z", "M122.1 62.4c16.8-5.6 25.8-23.7 20.2-40.5S118.6-3.9 101.9 1.6L75.8 10.3C49.6 19.1 32 43.5 32 71.1L32 192c0 88.4 71.6 160 160 160s160-71.6 160-160l0-120.9c0-27.5-17.6-52-43.8-60.7L282.1 1.6c-16.8-5.6-34.9 3.5-40.5 20.2s3.5 34.9 20.2 40.5L288 71.1 288 192c0 53-43 96-96 96s-96-43-96-96L96 71.1l26.1-8.7zM512 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-80a80 80 0 1 0 0 160 80 80 0 1 0 0-160z"]]
}, faCoffin = {
  prefix: "fad",
  iconName: "coffin",
  icon: [384, 512, [9904], "f6c6", ["M11.5 114.9l91-104C108.5 4 117.3 0 126.5 0h131c9.2 0 18 4 24.1 10.9l91 104c7.4 8.5 11.5 19.3 11.5 30.6c0 4.4-.6 8.7-1.8 12.9L286.7 488.9c-4 13.7-16.5 23.1-30.7 23.1H128.1c-14.3 0-26.8-9.4-30.7-23.1L1.8 158.3C.6 154.1 0 149.8 0 145.4c0-11.2 4.1-22.1 11.5-30.6z", ""]]
}, faMessage = {
  prefix: "fad",
  iconName: "message",
  icon: [512, 512, ["comment-alt"], "f27a", ["M64 0C28.7 0 0 28.7 0 64L0 352c0 35.3 28.7 64 64 64l96 0 0 80c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L309.3 416 448 416c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L64 0z", ""]]
}, faCommentAlt = faMessage, faSalad = {
  prefix: "fad",
  iconName: "salad",
  icon: [512, 512, [129367, "bowl-salad"], "f81e", ["M0 160c0 53 43 96 96 96l73.4 0L84.7 171.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L208 249.4 208 112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 144 52 0c-2.6-10.2-4-21-4-32c0-70.7 57.3-128 128-128c2.6 0 5.2 .1 7.8 .2C406.2 76.5 380.5 64 352 64c-8.7 0-17.2 1.2-25.3 3.4C309.5 27.7 270 0 224 0s-85.5 27.7-102.7 67.4c-8-2.2-16.5-3.4-25.3-3.4C43 64 0 107 0 160zm320 64c0 11.2 1.9 22 5.5 32l181.1 0c3.5-10 5.5-20.8 5.5-32c0-53-43-96-96-96s-96 43-96 96z", "M27.4 288C12.3 288 0 300.3 0 315.4c0 70.5 44.4 130.7 106.7 154.1l1.8 14.4c2 16 15.6 28 31.8 28l231.5 0c16.1 0 29.8-12 31.8-28l1.8-14.4C467.6 446.1 512 385.9 512 315.4c0-15.1-12.3-27.4-27.4-27.4L27.4 288z"]]
}, faBowlSalad = faSalad, faInfo = {
  prefix: "fad",
  iconName: "info",
  icon: [192, 512, [], "f129", ["M48 80a48 48 0 1 0 96 0A48 48 0 1 0 48 80z", "M32 192c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 192-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-224c0-17.7-14.3-32-32-32l-64 0z"]]
}, faRobotAstromech = {
  prefix: "fad",
  iconName: "robot-astromech",
  icon: [512, 512, [], "e2d2", ["M2.3 487.8c-3 4.9-3 11.1-.2 16.1s8.2 8.1 13.9 8.1l96 0c8.8 0 16-7.2 16-16l0-112 45.3 45.3c12 12 28.3 18.7 45.3 18.7l75 0c17 0 33.3-6.7 45.3-18.7L384 384l0 112c0 8.8 7.2 16 16 16l96 0c5.8 0 11.1-3.1 13.9-8.1c1.4-2.4 2.1-5.2 2.1-7.9c0-2.9-.8-5.7-2.3-8.2L470.8 423c-4.5-7.5-6.8-16-6.8-24.7L464 240c0-26.5-21.5-48-48-48l-32 0-256 0-32 0c-26.5 0-48 21.5-48 48l0 158.3c0 8.7-2.4 17.2-6.8 24.7L2.3 487.8zM192 272c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16z", "M128 128C128 57.3 185.3 0 256 0s128 57.3 128 128l0 64-256 0 0-64zm96 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm96-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM208 256l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]]
}, faRingDiamond = {
  prefix: "fad",
  iconName: "ring-diamond",
  icon: [384, 512, [], "e5ab", ["M98.5 61.3C95 68.4 95.2 76.7 99 83.7l30.4 54.8c19.6-6.8 40.7-10.4 62.6-10.4c1.4 0 2.7 0 4.1 0s2.7 .1 4.1 .1c2.7 .1 5.4 .3 8.1 .5c5.4 .4 10.7 1.1 15.9 2c10.4 1.8 20.6 4.4 30.4 7.7L285 83.7c3.8-6.9 4-15.3 .5-22.4l-24-48C257.4 5.1 249.1 0 240 0L144 0c-9.1 0-17.4 5.1-21.5 13.3l-24 48z", "M192 192a128 128 0 1 0 0 256 128 128 0 1 0 0-256zM384 320A192 192 0 1 1 0 320a192 192 0 1 1 384 0z"]]
}, faFonduePot = {
  prefix: "fad",
  iconName: "fondue-pot",
  icon: [512, 512, [129749], "e40d", ["M64 224l0 16 0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c0-8.8 7.2-16 16-16s16 7.2 16 16s7.2 16 16 16s16-7.2 16-16l0-32 0-16-48 0-48 0zm160 0l32.5 0 16.3-65.2c10.6-3 19.4-11.5 22.2-23l24-96c4.3-17.1-6.1-34.5-23.3-38.8S261.2 7.1 257 24.2l-24 96c-2.9 11.5 .9 23.1 8.8 30.8l-17.3 69.1c-.3 1.3-.5 2.6-.5 3.9zm80 0l35.2 0 42.7-64.1c11 .7 22.1-4.3 28.7-14.2l64-96c9.8-14.7 5.8-34.6-8.9-44.4S431.2-.5 421.4 14.2l-64 96c-6.6 9.9-7 22-2.1 31.9l-48.6 72.9c-1.8 2.7-2.7 5.8-2.7 8.9z", "M64 224l-32 0c-17.7 0-32 14.3-32 32l0 64c0 52.3 25.1 98.8 64 128l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-3.2c10.3 2.1 21 3.2 32 3.2l128 0c11 0 21.7-1.1 32-3.2l0 3.2c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32c38.9-29.2 64-75.7 64-128l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0-64 0-224 0 0 16 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16s-7.2-16-16-16s-16 7.2-16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64 0-16z"]]
}, faTheta = {
  prefix: "fad",
  iconName: "theta",
  icon: [384, 512, [], "f69e", ["M96 256c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32z", "M104.2 128.4C79.9 160 64 205 64 256s15.9 96 40.2 127.6C128.5 415.1 159.8 432 192 432s63.5-16.9 87.8-48.4C304.1 352 320 307 320 256s-15.9-96-40.2-127.6C255.5 96.9 224.2 80 192 80s-63.5 16.9-87.8 48.4zm-50.7-39C87.1 45.7 135.8 16 192 16s104.9 29.7 138.5 73.4C364.1 133.1 384 192.1 384 256s-19.9 122.9-53.5 166.6C296.9 466.3 248.2 496 192 496s-104.9-29.7-138.5-73.4C19.9 378.9 0 319.9 0 256S19.9 133.1 53.5 89.4z"]]
}, faFaceHandPeeking = {
  prefix: "fad",
  iconName: "face-hand-peeking",
  icon: [640, 512, [129763], "e481", ["M80.4 346.4C117 443.2 210.4 512 320 512c91.5 0 171.8-48 217.1-120.2c-5.4 .7-10.8 1.1-16.3 1.1l-64.8 0c-22.1 0-40-17.9-40-40c0-.3 0-.6 0-.9l-8 0c-22.1 0-40-17.9-40-40c0-1.1 0-2.2 .1-3.3c-37-10.4-64.1-44.4-64.1-84.7c0-48.6 39.4-88 88-88c6.6 0 13 .7 19.2 2.1c11.8-4 25.2-2.4 36.1 5.4l37.9 27.1c1.1-9.6 5.3-18.9 12.6-26.2c12.9-12.9 31.8-16.1 47.7-9.6C502.2 54.5 417.5 0 320 0C248.5 0 183.8 29.3 137.3 76.6c7.7 1.8 14.9 5.7 20.9 11.7c17.2 17.2 17.2 45 0 62.2l-1.5 1.5 75.2 0c22.1 0 40 17.9 40 40c0 2.6-.2 5.1-.7 7.5c10.1 7.3 16.7 19.1 16.7 32.5s-6.6 25.3-16.7 32.5c.5 2.4 .7 4.9 .7 7.5c0 22.1-17.9 40-40 40l-8 0c0 .3 0 .6 0 .9c0 22.1-17.9 40-40 40l-64.8 0c-13.3 0-26.4-2.2-38.8-6.5zM256 400c0-26.5 28.7-48 64-48s64 21.5 64 48s-28.7 48-64 48s-64-21.5-64-48zM368.4 224c0 6.1 2.3 11.8 6.1 16l35.8 0c3.8-4.2 6.1-9.9 6.1-16c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M232 208c8.8 0 16-7.2 16-16s-7.2-16-16-16H118.2c-7.1 0-10.7-8.6-5.7-13.7l28.8-28.8c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0L51.9 166.4l-.8 .8C14.7 204.4 15 264.1 51.9 301c17.9 17.9 42.1 27.9 67.3 27.9l64.8 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-14 0c-2.5 0-4.5-2-4.5-4.5s2-4.5 4.5-4.5h62c8.8 0 16-7.2 16-16s-7.2-16-16-16H169.6c-2.2 0-4-1.8-4-4s1.8-4 4-4l78.4 0c8.8 0 16-7.2 16-16s-7.2-16-16-16H169.6c-2.2 0-4-1.8-4-4s1.8-4 4-4l62.4 0zm182.7-19c-7.2-5.1-8.9-15.1-3.7-22.3s15.1-8.9 22.3-3.7l81.8 58.4c2.3 1.6 5.1 2.3 7.8 2c9.3-1.1 13.2-12.4 6.6-19l-14.8-14.8c-7.8-7.8-7.8-20.5 0-28.3s20.5-7.8 28.3 0l45.1 45.1 .8 .8c36.4 37.2 36.1 96.9-.8 133.8c-17.9 17.9-42.1 27.9-67.3 27.9H456c-8.8 0-16-7.2-16-16s7.2-16 16-16h19.5c2.5 0 4.5-2 4.5-4.5s-2-4.5-4.5-4.5L408 328c-8.8 0-16-7.2-16-16s7.2-16 16-16h68c2.2 0 4-1.8 4-4s-1.8-4-4-4H392c-8.8 0-16-7.2-16-16s7.2-16 16-16l74.6 0c7.4 0 13.4-6 13.4-13.4c0-4.3-2.1-8.4-5.6-10.9L414.7 189z"]]
}, faSquareUser = {
  prefix: "fad",
  iconName: "square-user",
  icon: [448, 512, [], "e283", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM81.1 416l285.7 0c-7.8-54.3-54.4-96-110.9-96l-64 0c-56.4 0-103.1 41.7-110.9 96zM152 200c0 39.8 32.2 72 72 72c19.9 0 37.9-8.1 50.9-21.1c6.5-6.5 11.8-14.3 15.4-22.9c1.8-4.3 3.2-8.8 4.2-13.5c.5-2.3 .8-4.7 1.1-7.1c.1-1.2 .2-2.4 .3-3.6c.1-1.2 .1-2.4 .1-3.7c0-1.4 0-2.6-.1-3.8s-.2-2.4-.3-3.7c-.2-2.4-.6-4.8-1.1-7.2c-1-4.7-2.4-9.2-4.2-13.5c-3.6-8.6-8.9-16.4-15.4-22.9c-13-13-31-21.1-50.9-21.1c-39.8 0-72 32.2-72 72z", "M152 200a72 72 0 1 1 144 0 72 72 0 1 1 -144 0zM81.1 416c7.8-54.3 54.4-96 110.9-96l64 0c56.4 0 103.1 41.7 110.9 96L81.1 416z"]]
}, faDownLeftAndUpRightToCenter = {
  prefix: "fad",
  iconName: "down-left-and-up-right-to-center",
  icon: [512, 512, ["compress-alt"], "f422", ["M0 456c0 6.1 2.3 12.3 7 17l32 32c9.4 9.4 24.6 9.4 33.9 0l87-87 39 39c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-144c0-13.3-10.7-24-24-24L72 272c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l39 39L7 439c-4.7 4.7-7 10.8-7 17z", "M473 7c-9.4-9.4-24.6-9.4-33.9 0l-87 87L313 55c-6.9-6.9-17.2-8.9-26.2-5.2S272 62.3 272 72l0 144c0 13.3 10.7 24 24 24l144 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-39-39 87-87c9.4-9.4 9.4-24.6 0-33.9L473 7z"]]
}, faCompressAlt = faDownLeftAndUpRightToCenter, faExplosion = {
  prefix: "fad",
  iconName: "explosion",
  icon: [576, 512, [], "e4e9", ["M34.4 333.5c-5.2 10.7-1.8 23.5 7.9 30.3l87.4 60.5c-1.2 7.7-1.8 15.7-1.8 23.7c21.3 0 42.7 0 64 0c0-53 43-96 96-96s96 43 96 96c21.3 0 42.7 0 64 0c0-9.4-.8-18.7-2.4-27.7L537 329c8.5-8.5 9.4-21.9 2.2-31.5s-20.4-12.3-30.9-6.4l-97.2 54.7c-2-2.4-4.1-4.8-6.3-7.1L541.9 33.9c1.4-3.2 2.1-6.5 2.1-9.8c0-8.6-4.7-16.9-12.7-21.2c-11.2-5.9-25-2.2-31.7 8.5L325.4 291.6 311.9 149.7C310.7 137.4 300.4 128 288 128s-22.7 9.4-23.9 21.7L250.5 292.4c-1.5 .4-3 .7-4.5 1.1L143.6 205.8c-8.9-7.7-22.1-7.7-31.1-.1s-11.2 20.6-5.1 30.7l62.3 103.9c-3.3 3.6-6.4 7.4-9.4 11.3L63.2 321.1c-11.3-3.5-23.5 1.7-28.7 12.4zM264 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M0 480c0-17.7 14.3-32 32-32l512 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32z"]]
}, faFileLines = {
  prefix: "fad",
  iconName: "file-lines",
  icon: [384, 512, [128441, 128462, 61686, "file-alt", "file-text"], "f15c", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM96 272c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM112 256c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0zm0 64c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0z"]]
}, faFileAlt = faFileLines, faFileText = faFileLines, faWaveSquare = {
  prefix: "fad",
  iconName: "wave-square",
  icon: [640, 512, [], "f83e", ["M128 64c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 352 96 0 0-160c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0 0 160c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-352-96 0 0 160c0 17.7-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l96 0 0-160z", ""]]
}, faRing = {
  prefix: "fad",
  iconName: "ring",
  icon: [512, 512, [], "f70b", ["M64 206.5c0 .5 0 1 0 1.5c0 .6 0 1.2 0 1.7c.9 11.3 10.6 28 39.3 44.3c40-18.6 93.7-30 152.6-30s112.6 11.4 152.6 30c28.8-16.3 38.4-33 39.3-44.3c0-.6 0-1.2 0-1.7c0-.5 0-1 0-1.5c-.9-12.3-12.2-31.2-47.9-49.1c-31-15.5-74.3-26.5-123.8-29c-6.7-.3-13.4-.4-20.3-.4s-13.6 .1-20.3 .4c-49.5 2.4-92.8 13.5-123.8 29c-35.6 17.8-47 36.7-47.9 49.1z", "M111.9 157.4C147.1 139.8 198 128 256 128s108.9 11.8 144.1 29.4C437.2 176 448 195.7 448 208s-10.8 32-47.9 50.6C364.9 276.2 314 288 256 288s-108.9-11.8-144.1-29.4C74.8 240 64 220.3 64 208s10.8-32 47.9-50.6zM83.3 100.2C39.4 122.2 0 158.4 0 208l0 96c0 49.6 39.4 85.8 83.3 107.8C129.1 434.7 190.3 448 256 448s126.9-13.3 172.7-36.2c43.9-22 83.3-58.2 83.3-107.8l0-96c0-49.6-39.4-85.8-83.3-107.8C382.9 77.3 321.7 64 256 64s-126.9 13.3-172.7 36.2z"]]
}, faBuildingUn = {
  prefix: "fad",
  iconName: "building-un",
  icon: [384, 512, [], "e4d9", ["M0 48L0 464c0 26.5 21.5 48 48 48l96 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 96 0c26.5 0 48-21.5 48-48l0-416c0-26.5-21.5-48-48-48L48 0C21.5 0 0 21.5 0 48zM64 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM80 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-64zm80 160c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM208 80c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4c11.6 17.3 23.1 34.7 34.7 52L272 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 7.1-4.6 13.3-11.4 15.3c-1.5 .5-3.1 .7-4.6 .7c-5.2 0-10.3-2.6-13.3-7.1c-11.6-17.3-23.1-34.7-34.7-52l0 43.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96zm48 160c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32z", "M237.3 71.1c-3.9-5.9-11.2-8.5-17.9-6.4s-11.4 8.3-11.4 15.3l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-43.2 34.7 52c3.9 5.9 11.2 8.5 17.9 6.4s11.4-8.3 11.4-15.3l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 43.2-34.7-52zM112 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 26.5 21.5 48 48 48s48-21.5 48-48l0-64c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64z"]]
}, faDiceThree = {
  prefix: "fad",
  iconName: "dice-three",
  icon: [448, 512, [9858], "f527", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm160 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M96 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm96 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm128 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]]
}, faTirePressureWarning = {
  prefix: "fad",
  iconName: "tire-pressure-warning",
  icon: [512, 512, [], "f633", ["M2 290.4c0 7.5 .4 15.1 1.3 22.9C8.6 361.9 31.3 412.3 80 462l0 34c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-8 32 0 0 8c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-8 32 0 0 8c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-8 32 0 0 8c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-34c48.7-49.7 71.4-100.1 76.8-148.7c.9-7.8 1.3-15.4 1.3-22.9c0-44.1-13.7-82.8-28.7-113.2c-7.8-15.8-14.5-30-19.3-44.4l-2.5-7.4C451.9 102.5 448 78.5 448 54.5L448 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 22.5c0 31 5 61.7 14.8 91.1l2.5 7.4c6.3 19 14.8 36.6 22.6 52.5c14.7 29.7 25.3 64 21.3 100.9c-3.7 34-20.4 74.1-65.7 117.7l-246.8 0c-45.3-43.6-62-83.7-65.7-117.7c-4.1-36.9 6.6-71.1 21.3-100.9c7.8-15.8 16.3-33.5 22.6-52.5l2.5-7.4C123 116.2 128 85.4 128 54.5L128 32c0-17.7-14.3-32-32-32S64 14.3 64 32l0 22.5c0 24.1-3.9 48-11.5 70.8L50 132.7c-4.8 14.4-11.5 28.6-19.3 44.4C15.7 207.6 2 246.3 2 290.4z", "M280 120c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM256 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faWifiFair = {
  prefix: "fad",
  iconName: "wifi-fair",
  icon: [640, 512, ["wifi-2"], "f6ab", ["M0 179.8c0 8 3 15.9 8.9 22.2c6.3 6.5 14.7 9.8 23.1 9.8c8 0 15.9-3 22.2-8.9C123.2 136.7 216.8 96 320 96s196.8 40.7 265.8 106.9c6.2 6 14.2 8.9 22.2 8.9c8.4 0 16.8-3.3 23.1-9.8c12.2-12.8 11.8-33-.9-45.2C549.7 79.5 440.4 32 320 32S90.3 79.5 9.8 156.7C3.3 163 0 171.4 0 179.8z", "M171.8 312c39.5-34.9 91.3-56 148.2-56s108.7 21.1 148.2 56c13.3 11.7 33.5 10.4 45.2-2.8s10.4-33.5-2.8-45.2C459.8 219.2 393 192 320 192s-139.8 27.2-190.5 72c-13.3 11.7-14.5 31.9-2.8 45.2s31.9 14.5 45.2 2.8zM320 480a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]]
}, faWifi2 = faWifiFair, faCalendarDays = {
  prefix: "fad",
  iconName: "calendar-days",
  icon: [448, 512, ["calendar-alt"], "f073", ["M0 192l448 0 0 272c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 192zm64 80l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM192 272l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM320 272l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M160 32c0-17.7-14.3-32-32-32S96 14.3 96 32l0 32L48 64C21.5 64 0 85.5 0 112l0 80 448 0 0-80c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32z"]]
}, faCalendarAlt = faCalendarDays, faMp3Player = {
  prefix: "fad",
  iconName: "mp3-player",
  icon: [384, 512, [], "f8ce", ["M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM64 96l0 64c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L96 64C78.3 64 64 78.3 64 96zM96 352a96 96 0 1 0 192 0A96 96 0 1 0 96 352z", "M96 64l192 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32L96 192c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zM224 352a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM96 352a96 96 0 1 1 192 0A96 96 0 1 1 96 352z"]]
}, faAnchorCircleCheck = {
  prefix: "fad",
  iconName: "anchor-circle-check",
  icon: [640, 512, [], "e4aa", ["M0 336c0 6.1 2.3 12.3 7 17c9.4 9.4 24.6 9.4 33.9 0l7-7 0 6.1c0 88.4 71.6 160 160 160l80 0 80 0c8.2 0 16.3-.6 24.2-1.8c-22.2-16.2-40.4-37.5-53-62.2L320 448l0-80 0-128 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-10.9 0C367 158.8 384 129.4 384 96c0-53-43-96-96-96s-96 43-96 96c0 33.4 17 62.8 42.9 80L224 176c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 208-48 0c-53 0-96-43-96-96l0-6.1 7 7c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L97 263c-9.4-9.4-24.6-9.4-33.9 0L7 319c-4.7 4.7-7 10.8-7 17zM320 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]]
}, faTally4 = {
  prefix: "fad",
  iconName: "tally-4",
  icon: [640, 512, [], "e297", ["M96 64l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32s-32 14.3-32 32zm128 0l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32s-32 14.3-32 32zm128 0l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M512 32c17.7 0 32 14.3 32 32l0 384c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-384c0-17.7 14.3-32 32-32z"]]
}, faRectangleHistory = {
  prefix: "fad",
  iconName: "rectangle-history",
  icon: [512, 512, [], "e4a2", ["M48 104c0 13.3 10.7 24 24 24l368 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L72 80c-13.3 0-24 10.7-24 24zM96 24c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L120 0C106.7 0 96 10.7 96 24z", "M448 160c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 224c0-35.3 28.7-64 64-64l384 0z"]]
}, faBuildingCircleArrowRight = {
  prefix: "fad",
  iconName: "building-circle-arrow-right",
  icon: [640, 512, [], "e4d1", ["M0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 184.2c-39.1 32.3-64 81.1-64 135.8c0 49.5 20.4 94.2 53.3 126.2C364.5 505.1 351.1 512 336 512l-96 0 0-80c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 80-96 0c-26.5 0-48-21.5-48-48L0 48zm64 64l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L80 96c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm19.3-211.3l56 56c6.2 6.2 6.2 16.4 0 22.6l-56 56c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L521.4 384 432 384c-8.8 0-16-7.2-16-16s7.2-16 16-16l89.4 0-28.7-28.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z"]]
}, faVolleyball = {
  prefix: "fad",
  iconName: "volleyball",
  icon: [512, 512, [127952, "volleyball-ball"], "f45f", ["M0 256C0 157.2 56 71.5 138 28.8c20.6 18.3 38.7 39.4 53.7 62.6C95.9 136.1 30.6 220.8 7.3 316.9C2.5 297.4 0 277 0 256zM30.4 377.2c6.7-108.7 71.9-209.9 177.1-257.9c9.7 19.3 17.5 39.8 22.9 61.1c2.7 10.7 4.9 21.6 6.5 32.7c.8 5.6 1.4 11.2 1.9 16.8c.2 2.8 .4 5.6 .6 8.5c.2 2.7 .3 5.5 .4 8.1c0 .1 0 .3 0 .4C162.5 294.6 110.9 368.9 90.2 451C66 430.4 45.6 405.4 30.4 377.2zm87.8 94.6c5.6-27 14.8-53.1 27.4-77.7C232.2 454.6 338.1 468.8 433 441c-46 44-108.3 71-177 71c-50.7 0-98-14.7-137.8-40.2zm43.5-105.5c23.7-36.2 55.4-67.8 94.5-91.8c79.9 43.2 170.1 50.8 251.6 27.6c-5.8 32-17.6 62-34.2 88.7c-97.5 48.5-217.7 42.6-311.9-24.5zm8.2-351.5C196.8 5.2 225.8 0 256 0c2.7 0 5.3 0 7.9 .1c90.8 60.2 145.7 167.2 134.7 282.3c-43.1-2.4-86.4-14.1-126.8-35.9c0-.1 0-.2 0-.4c-.1-2.6-.2-5.3-.3-8c-.1-2.8-.3-5.6-.6-8.6c-.2-2.7-.5-5.5-.7-8.3c-.3-2.7-.6-5.5-1-8.3c-1.4-11-3.4-21.9-5.8-32.6s-5.4-21.2-8.9-31.5c-1.7-5.1-3.6-10.2-5.6-15.3c-1-2.5-2-4.9-3.1-7.5c-1-2.3-2-4.7-3.2-7.3c-8.8-19.6-19.4-38.2-31.6-55.6c-6.1-8.7-12.6-17.1-19.5-25.2c-3.4-4-6.9-7.9-10.6-11.8c-1.8-1.9-3.6-3.8-5.6-5.8c-1.8-1.8-3.5-3.6-5.3-5.3c-.1-.1-.2-.2-.2-.2zm157.6-4.7C434.1 41.1 512 139.5 512 256c0 3.8-.1 7.6-.3 11.4c-26.1 8.7-53.4 13.8-81 15.1c9.2-105.3-31.6-204.2-103.2-272.4z", "M138 28.8c20.6 18.3 38.7 39.4 53.7 62.6C95.9 136.1 30.6 220.8 7.3 316.9c5.2 21.2 13 41.5 23.1 60.3c6.7-108.7 71.9-209.9 177.1-257.9c19.5 38.6 31 81.9 32.3 127.7C162.5 294.6 110.9 368.9 90.2 451c8.9 7.5 18.2 14.5 28.1 20.8c5.6-27 14.8-53.1 27.4-77.7C232.2 454.6 338.1 468.8 433 441c15.6-14.9 29.3-31.8 40.7-50.2c-97.5 48.5-217.7 42.6-311.9-24.5c23.7-36.2 55.4-67.8 94.5-91.8c79.9 43.2 170.1 50.8 251.6 27.6c2.1-11.3 3.4-22.9 3.9-34.7c-26.1 8.7-53.4 13.8-81 15.1c9.2-105.3-31.5-204.2-103.2-272.4C307.3 4.2 286 .8 263.9 .1c90.8 60.2 145.7 167.2 134.7 282.3c-43.2-2.4-86.4-14.1-126.8-35.9c-2.5-90.9-41.1-172.7-101.9-231.7c-11 3.9-21.7 8.6-32 14z"]]
}, faVolleyballBall = faVolleyball, faSunHaze = {
  prefix: "fad",
  iconName: "sun-haze",
  icon: [640, 512, [], "f765", ["M64 156.6c0 3.2 1 6.4 2.8 9.1L129.1 256l62.9 0c0-70.7 57.3-128 128-128s128 57.3 128 128l62.9 0 62.3-90.3c1.9-2.7 2.8-5.9 2.8-9.1c0-2.1-.4-4.2-1.2-6.1c-2.1-5-6.6-8.6-11.9-9.6L455 121 435.1 13.1c-1-5.3-4.6-9.8-9.6-11.9c-2-.8-4-1.2-6.1-1.2c-3.2 0-6.4 1-9.1 2.8L320 65.1 229.7 2.8c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L185 121 77.1 140.9c-5.3 1-9.8 4.6-11.9 9.6c-.8 2-1.2 4.1-1.2 6.1zM224 256l192 0c0-53-43-96-96-96s-96 43-96 96z", "M640 312c0-13.3-10.7-24-24-24l-112 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24zm-208 0c0-13.3-10.7-24-24-24L88 288c-13.3 0-24 10.7-24 24s10.7 24 24 24l320 0c13.3 0 24-10.7 24-24zm144 88c0-13.3-10.7-24-24-24L24 376c-13.3 0-24 10.7-24 24s10.7 24 24 24l528 0c13.3 0 24-10.7 24-24zM88 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L88 464zm208 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l320 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-320 0z"]]
}, faTextSize = {
  prefix: "fad",
  iconName: "text-size",
  icon: [640, 512, [], "f894", ["M0 80l0 48c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 96 0 0 320-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-320 96 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-48c0-26.5-21.5-48-48-48L192 32 48 32C21.5 32 0 53.5 0 80z", "M384 288l0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c0-26.5 21.5-48 48-48l224 0c26.5 0 48 21.5 48 48l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16-64 0 0 128 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-128-64 0z"]]
}, faUfo = {
  prefix: "fad",
  iconName: "ufo",
  icon: [640, 512, [128760], "e047", ["M144 237.1s51.8 50.9 176 50.9s176-50.9 176-50.9c0-8.3-.6-16.5-1.7-24.5C482.2 128.6 408.8 64 320 64s-162.2 64.6-174.3 148.6c-1.2 8-1.7 16.2-1.7 24.5z", "M320 288c124.2 0 176-50.9 176-50.9c0-8.3-.6-16.5-1.7-24.5C582 235.5 640 275 640 320c0 70.7-143.3 128-320 128S0 390.7 0 320c0-45 58-84.5 145.7-107.4c-1.2 8-1.7 16.2-1.7 24.5c0 0 51.8 50.9 176 50.9zm24 88a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM128 352a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm408-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]]
}, faFork = {
  prefix: "fad",
  iconName: "fork",
  icon: [512, 512, ["utensil-fork"], "f2e3", ["M240 157.1c0 19.3 5.5 37.9 15.7 53.9c3.9 6.1 8.4 11.8 13.6 17c4.9 4.9 9.8 9.8 14.6 14.6c5.2 5.2 10.9 9.8 17 13.6c16 10.2 34.7 15.7 53.9 15.7c33.5 0 64.8-16.8 83.4-44.6l71-106.5c1.8-2.7 2.7-5.8 2.7-8.9c0-4.6-2-9.2-5.9-12.4c-6.4-5.2-15.6-4.8-21.5 1.1L393.4 192c-5.2 5.2-13.6 5.2-18.8 0c-4.9-4.9-5.2-12.8-.6-18.1l86.1-99.4c5.5-6.3 5.2-15.9-.8-21.8s-15.4-6.3-21.8-.8L338.1 138c-5.3 4.6-13.2 4.3-18.1-.6c-5.2-5.2-5.2-13.6 0-18.8l91.3-91.3c5.8-5.8 6.3-15.1 1.1-21.5S398-1.9 391.1 2.7l-106.5 71C256.8 92.3 240 123.6 240 157.1z", "M9.4 457.4L255.7 211c3.9 6.1 8.4 11.8 13.6 17L284 242.6c5.2 5.2 10.9 9.8 17 13.6L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3z"]]
}, faUtensilFork = faFork, faArrowsUpToLine = {
  prefix: "fad",
  iconName: "arrows-up-to-line",
  icon: [576, 512, [], "e4c2", ["M0 64C0 46.3 14.3 32 32 32l512 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64z", "M54.6 278.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l96-96c12.5-12.5 32.8-12.5 45.3 0l96 96c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L160 237.3 160 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-210.7L54.6 278.6zm320 0c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l96-96c12.5-12.5 32.8-12.5 45.3 0l96 96c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L480 237.3 480 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-210.7-41.4 41.4z"]]
}, faMobileSignal = {
  prefix: "fad",
  iconName: "mobile-signal",
  icon: [512, 512, [], "e1ef", ["M0 64L0 448c0 35.3 28.7 64 64 64l160 0 0-24c0-13.6 1-27 3-40L64 448 64 64l224 0 0 251.7c18.3-21.2 39.9-39.5 64-54L352 64c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zM128 400c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16z", "M512 280c0-13.3-10.7-24-24-24c-128.1 0-232 103.9-232 232c0 13.3 10.7 24 24 24s24-10.7 24-24c0-101.6 82.4-184 184-184c13.3 0 24-10.7 24-24zM448 480a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm40-128c-75.1 0-136 60.9-136 136c0 13.3 10.7 24 24 24s24-10.7 24-24c0-48.6 39.4-88 88-88c13.3 0 24-10.7 24-24s-10.7-24-24-24z"]]
}, faBarcodeScan = {
  prefix: "fad",
  iconName: "barcode-scan",
  icon: [640, 512, [], "f465", ["M0 256c0-13.3 10.7-24 24-24l592 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 280c-13.3 0-24-10.7-24-24z", "M64 56c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24l0 136-64 0L64 56zm0 264l64 0 0 136c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-136zm96 0l32 0 0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144zm64 0l64 0 0 136c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-136zm64-128l-64 0 0-136c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24l0 136zm32 128l64 0 0 136c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-136zm64-128l-64 0 0-136c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24l0 136zm64 128l32 0 0 144c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-144zm32-128l-32 0 0-144c0-8.8 7.2-16 16-16s16 7.2 16 16l0 144zm32 128l64 0 0 136c0 13.3-10.7 24-24 24l-16 0c-13.3 0-24-10.7-24-24l0-136zm64-128l-64 0 0-136c0-13.3 10.7-24 24-24l16 0c13.3 0 24 10.7 24 24l0 136zm-384 0l-32 0 0-144c0-8.8 7.2-16 16-16s16 7.2 16 16l0 144z"]]
}, faSortDown = {
  prefix: "fad",
  iconName: "sort-down",
  icon: [320, 512, ["sort-desc"], "f0dd", ["M0 192c0 4.1 .8 8.3 2.4 12.2c5 12 16.6 19.8 29.6 19.8l256 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-128-128c-12.5-12.5-32.8-12.5-45.3 0l-128 128C3.3 175.5 0 183.7 0 192zm109.3-32L160 109.3 210.7 160l-101.5 0z", "M182.6 470.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-9.2-9.2-11.9-22.9-6.9-34.9s16.6-19.8 29.6-19.8l256 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-128 128z"]]
}, faSortDesc = faSortDown, faFolderArrowDown = {
  prefix: "fad",
  iconName: "folder-arrow-down",
  icon: [512, 512, ["folder-download"], "e053", ["M0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L288 96c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32L64 32C28.7 32 0 60.7 0 96zM160 288c0-6.1 2.3-12.3 7-17c9.4-9.4 24.6-9.4 33.9 0l31 31L232 200c0-13.3 10.7-24 24-24s24 10.7 24 24l0 102.1 31-31c9.4-9.4 24.6-9.4 33.9 0c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17l-72 72c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7l-72-72c-4.7-4.7-7-10.8-7-17z", "M256 176c13.3 0 24 10.7 24 24l0 102.1 31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31L232 200c0-13.3 10.7-24 24-24z"]]
}, faFolderDownload = faFolderArrowDown, faCircleMinus = {
  prefix: "fad",
  iconName: "circle-minus",
  icon: [512, 512, ["minus-circle"], "f056", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm160 0c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z", "M160 256c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z"]]
}, faMinusCircle = faCircleMinus, faFaceIcicles = {
  prefix: "fad",
  iconName: "face-icicles",
  icon: [512, 512, [], "e37c", ["M0 256c0 19.7 2.2 38.9 6.5 57.4l18 107.9C27 436.7 40.4 448 56 448c8.3 0 15.9-3.1 21.6-8.4C123.7 484.4 186.6 512 256 512c31.1 0 60.9-5.5 88.5-15.7c5.7 9.6 16.1 15.7 27.5 15.7c13.6 0 25.7-8.6 30.2-21.4l11.5-32.9c5.4-4.2 10.5-8.6 15.6-13.2l2.8 37.9c1.2 16.7 15.2 29.6 31.9 29.6s30.7-12.9 31.9-29.6l14.8-200c0-.5 .1-1.1 .1-1.6c.8-8.1 1.2-16.4 1.2-24.7C512 114.6 397.4 0 256 0S0 114.6 0 256zm35.9 39.7C33.9 283.3 43.4 272 56 272s22.1 11.3 20.1 23.7C69.4 335.7 62.7 375.8 56 415.8l-20-120.1zM112.7 344c3.8-22.7 23.6-40 47.3-40l8 0 0 40-55.3 0zm0 16l55.3 0 0 40-8 0c-23.8 0-43.5-17.3-47.3-40zm95.7-152a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM184 304l64 0 0 40-64 0 0-40zm0 56l64 0 0 40-64 0 0-40zm80-56l64 0 0 40-64 0 0-40zm0 56l64 0 0 40-32 48-32-48 0-40zM368.4 208a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM344 304l8 0c23.8 0 43.5 17.3 47.3 40L344 344l0-40zm0 56l56 0 0 40-28 80-28-80 0-40zm98.2-112.1C441 235.1 451.1 224 464 224s23 11.1 21.8 23.9L464 480 442.2 247.9z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faShovel = {
  prefix: "fad",
  iconName: "shovel",
  icon: [512, 512, [], "f713", ["M201.4 265.4c15.1 15.1 30.2 30.2 45.3 45.3l97-97c13.3 6.6 28.4 10.3 44.3 10.3c26.5 0 51.9-10.5 70.6-29.3l44.1-44.1c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6l-96-96C400.4 3.1 392.2 0 384 0s-16.4 3.1-22.6 9.4L317.3 53.5C298.5 72.2 288 97.6 288 124.1c0 15.9 3.7 30.9 10.3 44.3l-97 97zM352 124.1c0-9.5 3.8-18.6 10.5-25.4L384 77.3 434.7 128l-21.5 21.5c-6.7 6.7-15.9 10.5-25.4 10.5c-19.8 0-35.9-16.1-35.9-35.9z", "M0 386.3V480c0 17.7 14.3 32 32 32h93.7c42.4 0 83.1-16.9 113.1-46.9l58.5-58.5c12.5-12.5 12.5-32.8 0-45.3L150.6 214.6c-12.5-12.5-32.8-12.5-45.3 0L46.9 273.1C16.9 303.1 0 343.8 0 386.3z"]]
}, faDoorOpen = {
  prefix: "fad",
  iconName: "door-open",
  icon: [576, 512, [], "f52b", ["M64 92.5L64 448l0 32 0 32 32 0 192 0 32 0 0-32 0-352 0-64 0-32c0-9.9-4.5-19.2-12.3-25.2C302 2.3 295.1 0 288 0c-2.6 0-5.2 .3-7.8 1l-179.9 45C79 51.3 64 70.5 64 92.5zM208 256c0-17.7 10.7-32 24-32s24 14.3 24 32s-10.7 32-24 32s-24-14.3-24-32z", "M320 128l128 0 0 352c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-320c0-35.3-28.7-64-64-64L320 64l0 64zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0-64-32 0zM232 288c13.3 0 24-14.3 24-32s-10.7-32-24-32s-24 14.3-24 32s10.7 32 24 32z"]]
}, faFilms = {
  prefix: "fad",
  iconName: "films",
  icon: [576, 512, [], "e17a", ["M0 120L0 344c0 75.1 60.9 136 136 136l320 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-320 0c-48.6 0-88-39.4-88-88l0-224c0-13.3-10.7-24-24-24S0 106.7 0 120zm256-8l0 48c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32zm0 144l0 48c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32z", "M96 96c0-35.3 28.7-64 64-64l352 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64l-352 0c-35.3 0-64-28.7-64-64L96 96zm56 0l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zM488 80c-8.8 0-16 7.2-16 16l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0zM152 200l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zm336-16c-8.8 0-16 7.2-16 16l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0zM152 304l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16zm336-16c-8.8 0-16 7.2-16 16l0 16c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-16 0zM256 112l0 48c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32zm32 112c-17.7 0-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-96 0z"]]
}, faRightFromBracket = {
  prefix: "fad",
  iconName: "right-from-bracket",
  icon: [512, 512, ["sign-out-alt"], "f2f5", ["M-.3 128l0 256c0 53 43 96 96 96l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-53 0-96 43-96 96z", "M500.4 228.7L377.7 105.9c-6.4-6.4-15-9.9-24-9.9c-18.7 0-33.9 15.2-33.9 33.9l0 62.1-128 0c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l128 0 0 62.1c0 18.7 15.2 33.9 33.9 33.9c9 0 17.6-3.6 24-9.9L500.4 283.3c7.2-7.2 11.3-17.1 11.3-27.3s-4.1-20.1-11.3-27.3z"]]
}, faSignOutAlt = faRightFromBracket, faFaceGlasses = {
  prefix: "fad",
  iconName: "face-glasses",
  icon: [512, 512, [], "e377", ["M0 256C0 397.4 114.6 512 256 512s256-114.6 256-256c0-22.8-3-44.8-8.5-65.8c-2.2 1.2-4.8 1.8-7.5 1.8l-32 0 0 56c0 30.9-25.1 56-56 56l-80 0c-30.9 0-56-25.1-56-56l0-56-32 0 0 56c0 30.9-25.1 56-56 56l-80 0c-30.9 0-56-25.1-56-56l0-56-32 0c-.7 0-1.3 0-2-.1s-1.3-.2-1.9-.4c-1.2-.3-2.4-.8-3.6-1.4C3 211.2 0 233.2 0 256zm18.6-96l34.8 0c9-18.9 28.3-32 50.6-32l80 0c22.3 0 41.6 13.1 50.6 32l42.8 0c9-18.9 28.3-32 50.6-32l80 0c22.3 0 41.6 13.1 50.6 32l34.8 0C455.4 66.2 363.4 0 256 0S56.6 66.2 18.6 160zM139.9 362.5c-5.8-6.7-5.1-16.8 1.6-22.6s16.8-5.1 22.6 1.6C182 362.2 212.6 384 256 384s74-21.8 91.9-42.5c5.8-6.7 15.9-7.4 22.6-1.6s7.4 15.9 1.6 22.6C349.8 388.1 311.1 416 256 416s-93.8-27.9-116.1-53.5z", "M16 192l32 0 0 56c0 30.9 25.1 56 56 56l80 0c30.9 0 56-25.1 56-56l0-56 32 0 0 56c0 30.9 25.1 56 56 56l80 0c30.9 0 56-25.1 56-56l0-56 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-37.4 0c-9-18.9-28.3-32-50.6-32l-80 0c-22.3 0-41.6 13.1-50.6 32l-42.8 0c-9-18.9-28.3-32-50.6-32l-80 0c-22.3 0-41.6 13.1-50.6 32L16 160c-8.8 0-16 7.2-16 16s7.2 16 16 16zm64 56l0-56 0-8c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24l0 64c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zm352-56l0 56c0 13.3-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24l0 8zM184.4 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm168 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]]
}, faNfc = {
  prefix: "fad",
  iconName: "nfc",
  icon: [448, 512, [], "e1f7", ["M96 144l0 224c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16l0-224c0-8.8-7.2-16-16-16l-80 0c-8.8 0-16 7.2-16 16l0 66.7c18.6 6.6 32 24.4 32 45.3c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3l0-66.7c0-5.6 1-11 2.7-16L144 128l-32 0c-8.8 0-16 7.2-16 16z", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zm48 64l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l66.7 0c6.6-18.6 24.4-32 45.3-32l80 0c26.5 0 48 21.5 48 48l0 224c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48z"]]
}, faAtom = {
  prefix: "fad",
  iconName: "atom",
  icon: [512, 512, [9883], "f5d2", ["M42.4 128C21.7 165.1 33 210.8 66 256c-33 45.2-44.3 90.9-23.6 128c20.2 36.3 62.5 49.3 115.2 43.2c22 52.1 55.7 84.8 98.4 84.8s76.4-32.7 98.4-84.8c52.7 6.1 95-6.8 115.2-43.2c7.1-12.7 10.4-26.4 10.4-40.8c0-27.6-12.3-57.5-34-87.2c21.7-29.8 34-59.7 34-87.2c0-14.3-3.3-28.1-10.4-40.8c-20.2-36.3-62.5-49.3-115.2-43.2C332.4 32.7 298.8 0 256 0s-76.4 32.7-98.4 84.8c-52.7-6.1-95 6.8-115.2 43.2zm55.9 31.1c1.6-2.9 8.4-13 40.2-11.7c-2.8 13.1-5 26.9-6.7 41.2c-7.6 6.1-14.8 12.3-21.6 18.6C91.4 177 96 163.3 98.3 159.1zm0 193.8c-2.3-4.2-7-17.9 11.9-48.1c6.8 6.3 14 12.5 21.6 18.6c1.7 14.2 3.9 28 6.7 41.2c-31.8 1.4-38.6-8.7-40.2-11.7zM336 256a80 80 0 1 1 -160 0 80 80 0 1 1 160 0zM221.1 99.7C237.9 65.9 252.1 64 256 64s18.1 1.9 34.9 35.7c-11.4 3.9-23.1 8.4-34.9 13.5c-11.8-5.1-23.4-9.7-34.9-13.5zm0 312.6c11.4-3.9 23.1-8.4 34.9-13.5c11.8 5.1 23.4 9.7 34.9 13.5c-16.7 33.8-31 35.7-34.9 35.7s-18.1-1.9-34.9-35.7zM373.5 147.5c31.8-1.4 38.6 8.7 40.2 11.7c2.3 4.2 7 17.9-11.9 48.1c-6.8-6.3-14-12.5-21.6-18.6c-1.7-14.3-3.9-28-6.7-41.2zm0 217.1c2.8-13.1 5-26.9 6.7-41.2c7.6-6.1 14.8-12.3 21.6-18.6c18.9 30.2 14.2 44 11.9 48.1c-1.6 2.9-8.4 13-40.2 11.7z", "M224 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]]
}, faSoap = {
  prefix: "fad",
  iconName: "soap",
  icon: [512, 512, [129532], "e06e", ["M160 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm96 144a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zM352 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M385.6 262.1C404.3 244.5 416 219.6 416 192c53 0 96 43 96 96l0 128c0 53-43 96-96 96L96 512c-53 0-96-43-96-96L0 288c0-53 43-96 96-96l128 0c0 24.6 9.2 47 24.4 64L160 256c-53 0-96 43-96 96s43 96 96 96l192 0c53 0 96-43 96-96c0-41.2-25.9-76.3-62.4-89.9zM320 288l32 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-192 0c-35.3 0-64-28.7-64-64s28.7-64 64-64l160 0z"]]
}, faIcons = {
  prefix: "fad",
  iconName: "icons",
  icon: [512, 512, ["heart-music-camera-bolt"], "f86d", ["M19.9 119.2l96.9 99.9c6 6.5 16.5 6.5 23 0l96.4-99.9c28-29 26.5-76.9-4.5-103.9C219.2 4.9 204.2 0 189.2 0c-18.8 0-37.6 7.7-51.5 21.8l-9.5 10.5-10-10.5c-25-25.5-66.4-30-93.4-6.5c-31.5 27-33 74.9-5 103.9zM321 389.6c2.3 6.2 8.3 10.4 15 10.4l55.7 0-38.4 89.7c-2.9 6.9-.7 14.9 5.3 19.2s14.3 4 19.9-.9l128-112c5-4.4 6.8-11.4 4.4-17.7s-8.3-10.4-15-10.4l-55.7 0 38.4-89.7c2.9-6.9 .7-14.9-5.3-19.2s-14.3-4-19.9 .9l-128 112c-5 4.4-6.8 11.4-4.4 17.7z", "M500.3 7.3C507.7 13.3 512 22.4 512 32l0 144c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48l0-57L352 90.2 352 208c0 26.5-28.7 48-64 48s-64-21.5-64-48s28.7-48 64-48l0-96c0-15.3 10.8-28.4 25.7-31.4l160-32c9.4-1.9 19.1 .6 26.6 6.6zM74.7 304l11.8-17.8c5.9-8.9 15.9-14.2 26.6-14.2l61.7 0c10.7 0 20.7 5.3 26.6 14.2L213.3 304l42.7 0c17.7 0 32 14.3 32 32l0 144c0 17.7-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32L0 336c0-17.7 14.3-32 32-32l42.7 0zM192 408a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]]
}, faHeartMusicCameraBolt = faIcons, faMicrophoneLinesSlash = {
  prefix: "fad",
  iconName: "microphone-lines-slash",
  icon: [640, 512, ["microphone-alt-slash"], "f539", ["M144 216l0 40c0 89.1 66.2 162.7 152 174.4l0 33.6-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-33.6c20.4-2.8 39.7-9.1 57.3-18.2l-43.1-33.9C346.1 382 333.3 384 320 384c-70.7 0-128-57.3-128-128l0-8.7L144.7 210c-.5 1.9-.7 3.9-.7 6zM224 96l0 54.3c33.5 26.2 66.9 52.5 100.4 78.7c2.9-3.1 7-5 11.6-5l80 0 0-32-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-32-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0c0-53-43-96-96-96s-96 43-96 96zM358.9 256c16.4 12.8 32.7 25.6 49.1 38.5c5.2-11.8 8-24.8 8-38.5l-57.1 0zm74.9 58.7c12.8 10 25.5 20 38.3 30c15.2-26 23.9-56.3 23.9-88.7l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24 0 16c0 21.2-5.1 41.1-14.2 58.7z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faMicrophoneAltSlash = faMicrophoneLinesSlash, faClosedCaptioningSlash = {
  prefix: "fad",
  iconName: "closed-captioning-slash",
  icon: [640, 512, [], "e135", ["M32 121.2L32 416c0 35.3 28.7 64 64 64l391.4 0L295 328.4c-16.8 14.7-38.9 23.6-63 23.6c-53 0-96-43-96-96c0-16 3.9-31.1 10.8-44.3L32 121.2zM76.8 34.9L236.6 160.1c26.6 1.2 50.4 13.3 67 31.9c6.1 6.8 7.6 16.2 4.7 24.3c7.5 5.8 14.9 11.7 22.4 17.5c10-42.3 48-73.8 93.4-73.8c28.4 0 54 12.4 71.5 32c8.8 9.9 8 25-1.9 33.9s-25 8-33.9-1.9c-8.8-9.9-21.6-16-35.8-16c-26.5 0-48 21.5-48 48c0 5.4 .9 10.5 2.5 15.4l41.4 32.5c1.3 .1 2.7 .2 4.1 .2c14.2 0 27-6.1 35.8-16c8.8-9.9 24-10.7 33.9-1.9s10.7 24 1.9 33.9c-7.8 8.7-17.2 16-27.7 21.4L600.8 445.6c4.6-8.8 7.2-18.9 7.2-29.6l0-320c0-35.3-28.7-64-64-64L96 32c-6.7 0-13.1 1-19.2 2.9zM184 256c0 26.5 21.5 48 48 48c8.7 0 16.9-2.3 23.9-6.4l-70-55.1c-1.3 4.3-1.9 8.8-1.9 13.5z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faCalculatorSimple = {
  prefix: "fad",
  iconName: "calculator-simple",
  icon: [512, 512, ["calculator-alt"], "f64c", ["M0 48L0 176c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-128c0-26.5-21.5-48-48-48L48 0C21.5 0 0 21.5 0 48zM0 336L0 464c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-128c0-26.5-21.5-48-48-48L48 288c-26.5 0-48 21.5-48 48zM48 112c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zM60.7 348.7c6.2-6.2 16.4-6.2 22.6 0L112 377.4l28.7-28.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L134.6 400l28.7 28.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L112 422.6 83.3 451.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L89.4 400 60.7 371.3c-6.2-6.2-6.2-16.4 0-22.6zM288 48l0 128c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-128c0-26.5-21.5-48-48-48L336 0c-26.5 0-48 21.5-48 48zm48 64c0-8.8 7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16z", "M416 64l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16zM64 96l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zM83.3 348.7L112 377.4l28.7-28.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L134.6 400l28.7 28.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L112 422.6 83.3 451.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L89.4 400 60.7 371.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zM288 336c0-26.5 21.5-48 48-48l128 0c26.5 0 48 21.5 48 48l0 128c0 26.5-21.5 48-48 48l-128 0c-26.5 0-48-21.5-48-48l0-128zm48 32c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16z"]]
}, faCalculatorAlt = faCalculatorSimple, faBridgeCircleCheck = {
  prefix: "fad",
  iconName: "bridge-circle-check",
  icon: [640, 512, [], "e4c9", ["M32 64c0-17.7 14.3-32 32-32l512 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-40 0 0 64 72 0 0 72.2C577.6 207.1 538.5 192 496 192c-69.1 0-128.9 39.8-157.7 97.7c-5.9-1.1-12-1.7-18.3-1.7c-53 0-96 43-96 96l0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64c0-53-43-96-96-96l0-128 72 0 0-64L64 96C46.3 96 32 81.7 32 64zM152 96l0 64 80 0 0-64-80 0zm128 0l0 64 80 0 0-64-80 0zm128 0l0 64 80 0 0-64-80 0z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]]
}, faSlidersUp = {
  prefix: "fad",
  iconName: "sliders-up",
  icon: [512, 512, ["sliders-v"], "f3f1", ["M64 32C64 14.3 78.3 0 96 0s32 14.3 32 32l0 54.7c-4.9-2.1-10.1-3.8-15.4-4.9c-2.7-.6-5.4-1-8.2-1.3c-1.4-.1-2.8-.3-4.2-.3S97.4 80 96 80c-11.4 0-22.2 2.4-32 6.7L64 32zm0 201.3c4.9 2.1 10.1 3.8 15.4 4.9c2.7 .6 5.4 1 8.2 1.3c1.4 .1 2.8 .3 4.2 .3s2.8 .1 4.2 .1c11.4 0 22.2-2.4 32-6.7L128 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-246.7zM224 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 246.7c-4.9-2.1-10.1-3.8-15.4-4.9c-2.7-.6-5.4-1-8.2-1.3c-1.4-.1-2.8-.3-4.2-.3s-2.8-.1-4.2-.1c-11.4 0-22.2 2.4-32 6.7L224 32zm0 393.3c4.9 2.1 10.1 3.8 15.4 4.9c2.7 .6 5.4 1 8.2 1.3c1.4 .1 2.8 .3 4.2 .3s2.8 .1 4.2 .1c11.4 0 22.2-2.4 32-6.7l0 54.7c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-54.7zM384 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 86.7c-4.9-2.1-10.1-3.8-15.4-4.9c-2.7-.6-5.4-1-8.2-1.3c-1.4-.1-2.8-.3-4.2-.3s-2.8-.1-4.2-.1c-11.4 0-22.2 2.4-32 6.7L384 32zm0 233.3c4.9 2.1 10.1 3.8 15.4 4.9c2.7 .6 5.4 1 8.2 1.3c1.4 .1 2.8 .3 4.2 .3s2.8 .1 4.2 .1c11.4 0 22.2-2.4 32-6.7L448 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-214.7z", "M96 128a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 112A80 80 0 1 0 96 80a80 80 0 1 0 0 160zm160 80a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 112a80 80 0 1 0 0-160 80 80 0 1 0 0 160zM384 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm112 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]]
}, faSlidersV = faSlidersUp, faLocationMinus = {
  prefix: "fad",
  iconName: "location-minus",
  icon: [384, 512, ["map-marker-minus"], "f609", ["M0 192c0 87.4 117 243 168.3 307.2c6.1 7.7 14.9 11.5 23.7 11.5s17.6-3.8 23.7-11.5C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192zm96 0c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z", "M96 192c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z"]]
}, faMapMarkerMinus = faLocationMinus, faPumpMedical = {
  prefix: "fad",
  iconName: "pump-medical",
  icon: [448, 512, [], "e06a", ["M35 442.7C31.9 480 61.3 512 98.8 512l186.4 0c35.6 0 64-29 64-63.9c0-1.8-.1-3.6-.2-5.4l-18.7-224c-2.8-33.2-30.5-58.7-63.8-58.7L256 160l-128 0-10.6 0c-33.3 0-61 25.5-63.8 58.7L35 442.7zM112 336c0-13.3 10.7-24 24-24l32 0 0-32c0-13.3 10.7-24 24-24s24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24z", "M128 32c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l60.1 0c21.2 0 41.6 8.4 56.6 23.4l33.9 33.9c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-33.9-33.9c-3-3-7.1-4.7-11.3-4.7L256 96l0 64-128 0 0-128zm64 224c13.3 0 24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-32c0-13.3 10.7-24 24-24z"]]
}, faFingerprint = {
  prefix: "fad",
  iconName: "fingerprint",
  icon: [512, 512, [], "f577", ["M71.6 358.5C71.6 372 82 384 96.1 384c10.5 0 19.9-7 22.2-17.3c6.4-28.1 9.7-56.8 9.7-85.8l0-24.9c0-27.2 8.5-52.4 22.9-73.1c7.2-10.4 8-24.6-.2-34.2c-9.1-10.6-25.3-11.4-33.9-.4C93.7 178 80 215.4 80 256l0 24.9c0 24.2-2.6 48.4-7.8 71.9c-.4 1.9-.6 3.8-.6 5.6zm121.6-234c7.1 8.3 18.8 10.8 29.4 7.9c10.6-2.9 21.8-4.4 33.4-4.4c70.7 0 128 57.3 128 128l0 24.9c0 25.2-1.5 50.3-4.4 75.3c-1.7 14.6 9.4 27.8 24.2 27.8c11.8 0 21.9-8.6 23.3-20.3c3.3-27.4 5-55 5-82.7l0-24.9c0-97.2-78.8-176-176-176c-19 0-37.4 3-54.5 8.6c-15.2 5-18.7 23.7-8.3 35.9zm.4 346.9c-4.8 12.4 1.4 26.3 13.8 31s26.3-1.4 31-13.8l5.9-15.3C267.9 411.9 280 346.7 280 280.9l0-24.9c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 24.9c0 59.9-11 119.3-32.5 175.2l-5.9 15.3z", "M48 256C48 141.1 141.1 48 256 48c63.1 0 119.6 28.1 157.8 72.5c8.6 10.1 23.8 11.2 33.8 2.6s11.2-23.8 2.6-33.8C403.3 34.6 333.7 0 256 0C114.6 0 0 114.6 0 256l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40zm458.5-52.9c-2.7-13-15.5-21.3-28.4-18.5s-21.3 15.5-18.5 28.4c2.9 13.9 4.5 28.3 4.5 43.1l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40c0-18.1-1.9-35.8-5.5-52.9zM352 256c0-53-43-96-96-96s-96 43-96 96l0 24.9c0 35.9-4.6 71.5-13.8 106.1c-3.8 14.3 6.7 29 21.5 29c9.5 0 17.9-6.2 20.4-15.4c10.5-39 15.9-79.2 15.9-119.7l0-24.9c0-28.7 23.3-52 52-52s52 23.3 52 52l0 24.9c0 36.3-3.5 72.4-10.4 107.9c-2.7 13.9 7.7 27.2 21.8 27.2c10.2 0 19-7 21-17c7.7-38.8 11.6-78.3 11.6-118.1l0-24.9z"]]
}, faSkiBoot = {
  prefix: "fad",
  iconName: "ski-boot",
  icon: [512, 512, [], "e3cc", ["M0 480c0-2 .2-4 .6-6c1.7-8.7 3.3-17.3 5-26L480 448c17.7 0 32 14.3 32 32c0 17.7-14.3 32-31.9 32L31.9 512c-9.5 0-18.5-4.3-24.6-11.6C2.6 494.6 0 487.4 0 480zM35.4 292.8C50.5 214.5 65.5 136.3 80.6 58C83.5 42.9 96.7 32 112 32l117.4 0C194.3 234.8 81.1 282 35.4 292.8z", "M358 .6c17.4 3.3 28.7 20.1 25.4 37.5l-6.2 32L360 160l-72 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l65.8 0-12.3 64L272 256c-8.8 0-16 7.2-16 16s7.2 16 16 16l68 0 122 59.2c11 5.4 18 16.5 18 28.8l0 72L5.6 448 35.4 292.8c45.7-10.8 158.9-58 194-260.8l90 0 1.2-6C323.9 8.6 340.7-2.8 358 .6z"]]
}, faStandardDefinition = {
  prefix: "fad",
  iconName: "standard-definition",
  icon: [576, 512, ["rectangle-sd"], "e28a", ["M0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm304 88c0-13.3 10.7-24 24-24l56 0c53 0 96 43 96 96s-43 96-96 96l-56 0c-13.3 0-24-10.7-24-24c0-48 0-96 0-144zm48 24l0 96 32 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-32 0z", "M328 160c-13.3 0-24 10.7-24 24l0 144c0 13.3 10.7 24 24 24l56 0c53 0 96-43 96-96s-43-96-96-96l-56 0zm24 144l0-96 32 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-32 0zM167.1 208.1c7.4-2.4 19.5-2.9 36.2-.7c5.1 .7 21.1 3.4 25.7 4.4c12.1 2.8 24.1-4.8 26.8-16.9s-4.8-24.1-16.9-26.8c-6.5-1.5-23.9-4.4-29.7-5.1c-18.9-2.5-38.9-3.1-56 2.5c-18.8 6.1-33.9 19.7-38.5 42.3c-.1 .4-.1 .8-.2 1.2c-1.7 11.4-.2 22.4 5 32.3c5.1 9.6 12.9 16.1 20.5 20.7c13.7 8.2 31.5 12.3 45.1 15.5l1.7 .4c16 3.7 27.1 6.5 34.1 10.7c3 1.8 3.8 3 3.9 3.3c0 0 0 0 0 0c.1 .1 .7 1.2 .2 4.7c-.4 2.7-1.2 3.8-1.7 4.3c-.7 .7-2.3 2-5.8 3.1c-7.7 2.4-20.1 2.9-36.9 .6c-7.4-1-20.3-4.8-31.4-8c-2.5-.7-5-1.4-7.2-2.1c-11.9-3.4-24.3 3.5-27.7 15.4s3.5 24.3 15.4 27.7c1.5 .4 3.3 1 5.3 1.6c0 0 0 0 0 0s0 0 0 0c10.8 3.2 28.4 8.3 39.4 9.9c0 0 0 0 0 0l.1 0c18.9 2.5 39.2 3.1 56.4-2.3c8.9-2.8 17.8-7.5 24.9-15.2c7.3-7.8 11.8-17.6 13.4-28.5c1.7-11.4 .2-22.4-5-32.3c-5.1-9.6-12.9-16.1-20.5-20.7c-13.7-8.2-31.5-12.3-45.1-15.5c0 0 0 0 0 0l-1.7-.4c-16-3.7-27.1-6.5-34.1-10.7c-3-1.8-3.8-3-3.9-3.3c0 0 0 0 0 0c-.1-.1-.6-1.1-.3-4.1c.9-4 2.8-6.2 8.3-8z"]]
}, faRectangleSd = faStandardDefinition, faH1 = {
  prefix: "fad",
  iconName: "h1",
  icon: [576, 512, [], "f313", ["M0 96L0 256 0 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 192 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128L64 224 64 96c0-17.7-14.3-32-32-32S0 78.3 0 96z", "M496.8 68.8C506.3 74.6 512 84.9 512 96l0 288 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-236.2-17.7 8.8c-15.8 7.9-35 1.5-42.9-14.3s-1.5-35 14.3-42.9l64-32c9.9-5 21.7-4.4 31.1 1.4z"]]
}, faHandPointRight = {
  prefix: "fad",
  iconName: "hand-point-right",
  icon: [512, 512, [], "f0a4", ["M0 226.3L0 288c0 88.4 71.6 160 160 160l8.6 0c-5.4-9.4-8.6-20.3-8.6-32c0-27.9 17.9-51.7 42.8-60.4C196 345.4 192 333.2 192 320c0-11.7 3.1-22.6 8.6-32l-.6 0c-39.8 0-72-32.2-72-72l0-56c0-8.8 7.2-16 16-16s16 7.2 16 16l0 56c0 22.1 17.9 40 40 40s40-17.9 40-40l0-88c0-35.3-28.7-64-64-64l-27 0c-33.9 0-66.5 13.5-90.5 37.5L46.9 113.1C16.9 143.1 0 183.8 0 226.3zM272 96l0 64 208 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L272 96z", "M352 192c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l48 0zm-32 96c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0zm0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c17.7 0 32 14.3 32 32z"]]
}, faMagnifyingGlassLocation = {
  prefix: "fad",
  iconName: "magnifying-glass-location",
  icon: [512, 512, ["search-location"], "f689", ["M0 208a208 208 0 1 0 416 0A208 208 0 1 0 0 208zm128-32c0-44.2 35.8-80 80-80s80 35.8 80 80c0 48.8-46.5 111.6-68.6 138.6c-6 7.3-16.8 7.3-22.7 0C174.5 287.6 128 224.8 128 176z", "M288 176c0 48.8-46.5 111.6-68.6 138.6c-6 7.3-16.8 7.3-22.7 0C174.5 287.6 128 224.8 128 176c0-44.2 35.8-80 80-80s80 35.8 80 80zm-48 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm90.7 200C348 363.3 363.3 348 376 330.7L502.6 457.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L330.7 376z"]]
}, faSearchLocation = faMagnifyingGlassLocation, faMessageBot = {
  prefix: "fad",
  iconName: "message-bot",
  icon: [640, 512, [], "e3b8", ["M96 64c0-35.3 28.7-64 64-64L480 0c35.3 0 64 28.7 64 64l0 112 0 32 0 144c0 35.3-28.7 64-64 64l-106.7 0L249.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-64 0c-35.3 0-64-28.7-64-64l0-144 0-32L96 64zm64 64l0 128c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L192 96c-17.7 0-32 14.3-32 32z", "M59.7 208c-5.5 9.6-15.9 16-27.7 16c-17.7 0-32-14.3-32-32s14.3-32 32-32c11.8 0 22.2 6.4 27.7 16L96 176l0 32-36.3 0zM192 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm224-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm224 32c0 17.7-14.3 32-32 32c-11.8 0-22.2-6.4-27.7-16L544 208l0-32 36.3 0c5.5-9.6 15.9-16 27.7-16c17.7 0 32 14.3 32 32z"]]
}, faForwardStep = {
  prefix: "fad",
  iconName: "forward-step",
  icon: [320, 512, ["step-forward"], "f051", ["M256 96l0 145 0 30 0 145c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M18.4 445c11.2 5.3 24.5 3.6 34.1-4.4l192-160L256 271l0-30-11.5-9.6-192-160c-9.5-7.9-22.8-9.7-34.1-4.4S0 83.6 0 96L0 416c0 12.4 7.2 23.7 18.4 29z"]]
}, faStepForward = faForwardStep, faFaceSmileBeam = {
  prefix: "fad",
  iconName: "face-smile-beam",
  icon: [512, 512, [128522, "smile-beam"], "f5b8", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm120-32c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l-.2-.3c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .3c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6zm19.9 122.5c-5.8-6.7-5.1-16.8 1.6-22.6s16.8-5.1 22.6 1.6C182 346.2 212.6 368 256 368s74-21.8 91.9-42.5c5.8-6.7 15.9-7.4 22.6-1.6s7.4 15.9 1.6 22.6C349.8 372.1 311.1 400 256 400s-93.8-27.9-116.1-53.5zM280 224c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l-.2-.3c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .3c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6z", "M217.6 228.8s0 0 0 0s0 0 0 0s0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 188.4 120 206.1 120 224c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2c0 0 0 0 0 0zm160 0s0 0 0 0s0 0 0 0s0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 188.4 280 206.1 280 224c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2c0 0 0 0 0 0z"]]
}, faSmileBeam = faFaceSmileBeam, faLightCeiling = {
  prefix: "fad",
  iconName: "light-ceiling",
  icon: [512, 512, [], "e016", ["M192 448c0 35.3 28.7 64 64 64s64-28.7 64-64l-128 0zM224 32l0 160 32 0 32 0 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M256 192C125.4 192 17.7 289.8 2 416.1C-.2 433.6 14.3 448 32 448H480c17.7 0 32.2-14.4 30-31.9C494.3 289.8 386.6 192 256 192z"]]
}, faMessageExclamation = {
  prefix: "fad",
  iconName: "message-exclamation",
  icon: [512, 512, ["comment-alt-exclamation"], "f4a5", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM224 304a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm8-200l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M280 104c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM256 336a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faCommentAltExclamation = faMessageExclamation, faBowlScoop = {
  prefix: "fad",
  iconName: "bowl-scoop",
  icon: [448, 512, [127847, "bowl-shaved-ice"], "e3de", ["M32 224c0 10.9 .9 21.6 2.7 32l378.7 0c1.7-10.4 2.7-21.1 2.7-32c0-106-86-192-192-192S32 118 32 224z", "M4 261.4c3-3.4 7.4-5.4 12-5.4l416 0c4.6 0 9 2 12 5.4s4.5 8 3.9 12.6l-2 15.9C436.9 361.9 375.6 416 303 416l-40.4 0 68.7 68.7c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9l-192 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4L185.4 416 145 416C72.4 416 11.1 361.9 2.1 289.9L.1 274c-.6-4.6 .8-9.1 3.9-12.6z"]]
}, faBowlShavedIce = faBowlScoop, faSquareX = {
  prefix: "fad",
  iconName: "square-x",
  icon: [448, 512, [], "e286", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM112 360c0-5.5 1.9-11 5.7-15.5c25-29.5 49.9-59 74.9-88.5l-74.9-88.5c-8.6-10.2-7.3-25.3 2.8-33.8c4.5-3.8 10-5.7 15.5-5.7c6.8 0 13.6 2.9 18.3 8.5c23.2 27.5 46.5 54.9 69.7 82.3c23.2-27.5 46.5-54.9 69.7-82.3c4.7-5.6 11.5-8.5 18.3-8.5c5.5 0 11 1.9 15.5 5.7c5.6 4.7 8.5 11.5 8.5 18.3c0 5.5-1.9 11-5.7 15.5c-25 29.5-49.9 59-74.9 88.5c25 29.5 49.9 59 74.9 88.5c3.8 4.5 5.7 10 5.7 15.5c0 6.8-2.9 13.6-8.5 18.3c-10.1 8.6-25.3 7.3-33.8-2.8c-23.2-27.5-46.5-54.9-69.7-82.3c-23.2 27.5-46.5 54.9-69.7 82.3c-4.7 5.6-11.5 8.5-18.3 8.5c-5.5 0-11-1.9-15.5-5.7c-5.6-4.7-8.5-11.5-8.5-18.3z", "M120.5 133.7c10.1-8.6 25.3-7.3 33.8 2.8L224 218.8l69.7-82.3c8.6-10.1 23.7-11.4 33.8-2.8s11.4 23.7 2.8 33.8L255.4 256l74.9 88.5c8.6 10.1 7.3 25.3-2.8 33.8s-25.3 7.3-33.8-2.8L224 293.2l-69.7 82.3c-8.6 10.1-23.7 11.4-33.8 2.8s-11.4-23.7-2.8-33.8L192.6 256l-74.9-88.5c-8.6-10.1-7.3-25.3 2.8-33.8z"]]
}, faBuildingMemo = {
  prefix: "fad",
  iconName: "building-memo",
  icon: [640, 512, [], "e61e", ["M0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 16-8 0c-27.5 0-52.1 12.6-68.2 32.4c-1.2-.3-2.5-.4-3.8-.4l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l16 0 0 64-16 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l16 0 0 168c0 21.3 7.5 40.8 20.1 56L240 512l0-80c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 80-96 0c-26.5 0-48-21.5-48-48L0 48zm64 64l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L80 96c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M320 160c0-35.3 28.7-64 64-64l192 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-192 0c-35.3 0-64-28.7-64-64l0-288zm104 48a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM400 328a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm24 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm56-208c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0zM464 304c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zm16 80c-8.8 0-16 7.2-16 16s7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0z"]]
}, faUtilityPoleDouble = {
  prefix: "fad",
  iconName: "utility-pole-double",
  icon: [512, 512, [], "e2c4", ["M0 56C0 42.7 10.7 32 24 32s24 10.7 24 24l0 8L0 64l0-8zM0 248c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8L0 256l0-8zM80 56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8L80 64l0-8zm0 192c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8-48 0 0-8zm3.2-120l57.7 0L224 183.4l0 38.5L83.2 128zm0 192l57.7 0L224 375.4l0 38.5L83.2 320zM288 183.4L371.2 128l57.7 0L288 221.9l0-38.5zm0 192L371.2 320l57.7 0L288 413.9l0-38.5zM384 56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8-48 0 0-8zm0 192c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8-48 0 0-8zM464 56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8-48 0 0-8zm0 192c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8-48 0 0-8z", "M256 0c17.7 0 32 14.3 32 32l0 32 224 0 0 32c0 17.7-14.3 32-32 32l-192 0 0 128 224 0 0 32c0 17.7-14.3 32-32 32l-192 0 0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160L32 320c-17.7 0-32-14.3-32-32l0-32 224 0 0-128L32 128C14.3 128 0 113.7 0 96L0 64l224 0 0-32c0-17.7 14.3-32 32-32z"]]
}, faFlagCheckered = {
  prefix: "fad",
  iconName: "flag-checkered",
  icon: [448, 512, [127937], "f11e", ["M64 150.2l69-17.2c19.4-4.9 39.4-6.1 59-3.8l0 96c-19.6-2.3-39.6-1.1-59 3.8L64 246.2l0-96zM192 27c18.8 2.2 37.2 7.7 54.4 16.3c23.2 11.6 48.4 17.4 73.6 17.4l0 102.2c-25.2 0-50.4-5.8-73.6-17.4c-17.2-8.6-35.6-14-54.4-16.3L192 27zm0 198.2c18.8 2.2 37.2 7.7 54.4 16.3c23.2 11.6 48.4 17.4 73.6 17.4l0 109.1c-23.9-1.4-47.4-7.5-69.3-18.5c-18.6-9.3-38.5-15.2-58.7-17.5l0-106.7zm128-62.4c25.2 0 50.4-5.8 73.6-17.4c18.1-9.1 36.3-18.1 54.4-27.2l0 96c-18.1 9.1-36.3 18.1-54.4 27.2c-23.2 11.6-48.4 17.4-73.6 17.4l0-96z", "M64 32C64 14.3 49.7 0 32 0S0 14.3 0 32L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 64.3-16.1c21-5.2 42.6-6.6 63.7-4.1l0-106.7c-19.6-2.3-39.6-1.1-59 3.8L64 246.2l0-96 69-17.2c19.4-4.9 39.4-6.1 59-3.8l0 96c18.8 2.2 37.2 7.7 54.4 16.3c23.2 11.6 48.4 17.4 73.6 17.4l0 109.1c24.4 1.4 49.1-2.2 72.5-11l34.7-13c12.5-4.7 20.8-16.6 20.8-30l0-99.7-54.4 27.2c-23.2 11.6-48.4 17.4-73.6 17.4l0-96c25.2 0 50.4-5.8 73.6-17.4L448 118.2l0-52c0-23-24.2-38-44.8-27.7l-9.6 4.8C370.4 54.8 345.2 60.6 320 60.6l0 102.2c-25.2 0-50.4-5.8-73.6-17.4c-17.2-8.6-35.6-14-54.4-16.3L192 27c-19.6-2.3-39.6-1.1-59 3.8L64 48l0-16z"]]
}, faChevronsUp = {
  prefix: "fad",
  iconName: "chevrons-up",
  icon: [512, 512, ["chevron-double-up"], "f325", ["M32 448c0 8.2 3.1 16.4 9.4 22.6c12.5 12.5 32.8 12.5 45.3 0L256 301.3 425.4 470.6c12.5 12.5 32.8 12.5 45.3 0c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6l-192-192c-6.2-6.2-14.4-9.4-22.6-9.4s-16.4 3.1-22.6 9.4l-192 192C35.1 431.6 32 439.8 32 448z", "M233.4 41.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 109.3 86.6 278.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z"]]
}, faChevronDoubleUp = faChevronsUp, faFootball = {
  prefix: "fad",
  iconName: "football",
  icon: [512, 512, [127944, "football-ball"], "f44e", ["M16.8 306.7c2.1-19.2 5.4-38.6 10.1-57.8L264.5 486.6c-18.3 4.4-37.7 7.6-58.4 9.5L16.8 306.7zM247.5 25.4c18.3-4.4 37.7-7.6 58.4-9.5C369 79.1 432.1 142.2 495.2 205.3c-2.1 19.2-5.4 38.6-10.1 57.8C405.9 183.8 326.7 104.6 247.5 25.4z", "M247.5 25.4c-13.5 3.3-26.4 7.2-38.6 11.7C142.9 61.6 96.7 103.6 66 153.6C47.8 183.4 35.1 215.9 26.9 249L264.5 486.6c13.5-3.3 26.4-7.2 38.6-11.7c66-24.5 112.2-66.5 142.9-116.5c18.3-29.8 30.9-62.3 39.1-95.3L247.5 25.4zM495.2 205.3c6.1-56.8 1.4-112.2-7.7-156.4c-2.7-12.9-13-22.9-26.1-25.1c-58.2-9.7-109.9-12-155.6-7.9L495.2 205.3zM206.1 496L16.8 306.7c-6.1 56.8-1.4 112.2 7.7 156.4c2.7 12.9 13 22.9 26.1 25.1c58.2 9.7 109.9 12 155.6 7.9zm54.6-331.3c6.2-6.2 16.4-6.2 22.6 0l64 64c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6zm-48 48c6.2-6.2 16.4-6.2 22.6 0l64 64c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6zm-48 48c6.2-6.2 16.4-6.2 22.6 0l64 64c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-64-64c-6.2-6.2-6.2-16.4 0-22.6z"]]
}, faFootballBall = faFootball, faUserVneck = {
  prefix: "fad",
  iconName: "user-vneck",
  icon: [448, 512, [], "e461", ["M352 128A128 128 0 1 1 96 128a128 128 0 1 1 256 0z", "M130 308.3c6.1-1.4 12.4 1.4 15.9 6.6L210.7 412c6.3 9.5 20.3 9.5 26.6 0l64.8-97.1c3.5-5.2 9.8-8 15.9-6.6c74.5 17.2 130 84 130 163.7l0 8c0 17.7-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32l0-8c0-79.7 55.5-146.5 130-163.7z"]]
}, faSchoolCircleExclamation = {
  prefix: "fad",
  iconName: "school-circle-exclamation",
  icon: [640, 512, [], "e56c", ["M0 144L0 464c0 26.5 21.5 48 48 48l272 0-64 0 0-96c0-35.3 28.7-64 64-64l.7 0c3.4-37.7 18.7-72.1 42.2-99.1C350.2 260 335.6 264 320 264c-48.6 0-88-39.4-88-88s39.4-88 88-88s88 39.4 88 88c0 18.3-5.6 35.3-15.1 49.4c29-21 64.6-33.4 103.1-33.4c59.5 0 112.1 29.6 144 74.8L640 144c0-26.5-21.5-48-48-48L473.7 96 337.8 5.4C332.4 1.8 326.2 0 320 0s-12.4 1.8-17.8 5.4L166.3 96 48 96C21.5 96 0 117.5 0 144zm80 64c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zm0 128c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zM304 144l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80z"]]
}, faCrop = {
  prefix: "fad",
  iconName: "crop",
  icon: [512, 512, [], "f125", ["M64 32l0 32 0 64 0 256c0 35.3 28.7 64 64 64l256 0 0-64-210.7 0L384 173.3l0-45.3-45.3 0L128 338.7 128 128l0-64 0-32c0-17.7-14.3-32-32-32S64 14.3 64 32zM400.6 66.2c22 5.9 39.4 23.2 45.3 45.3l56.8-56.8c12.5-12.5 12.5-32.8 0-45.3C496.4 3.1 488.2 0 480 0s-16.4 3.1-22.6 9.4L400.6 66.2zM448 384l0 64 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0z", "M32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l32 0 0-64L32 64zM384 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-352c0-35.3-28.7-64-64-64L128 64l0 64 256 0 0 352z"]]
}, faAnglesDown = {
  prefix: "fad",
  iconName: "angles-down",
  icon: [448, 512, ["angle-double-down"], "f103", ["M32 96c0 8.2 3.1 16.4 9.4 22.6l160 160c12.5 12.5 32.8 12.5 45.3 0l160-160c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6S392.2 64 384 64s-16.4 3.1-22.6 9.4L224 210.7 86.6 73.4C80.4 67.1 72.2 64 64 64s-16.4 3.1-22.6 9.4S32 87.8 32 96z", "M201.4 470.6c12.5 12.5 32.8 12.5 45.3 0l160-160c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 402.7 86.6 265.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l160 160z"]]
}, faAngleDoubleDown = faAnglesDown, faUsersRectangle = {
  prefix: "fad",
  iconName: "users-rectangle",
  icon: [640, 512, [], "e594", ["M96 309.3c0 14.7 11.9 26.7 26.7 26.7l56.1 0c8-34.1 32.8-61.7 65.2-73.6c-7.5-4.1-16.2-6.4-25.3-6.4l-69.3 0C119.9 256 96 279.9 96 309.3zM127.8 176a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM208 360c0 13.3 10.7 24 24 24l176 0c13.3 0 24-10.7 24-24c0-8.4-1.4-16.5-4.1-24c-8.6-24.3-29.9-42.6-55.9-47c-3.9-.7-7.9-1-12-1l-80 0c-4.1 0-8.1 .3-12 1c-26 4.4-47.3 22.7-55.9 47c-2.7 7.5-4.1 15.6-4.1 24zm48-168a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm140 70.4c32.4 11.9 57.2 39.5 65.2 73.6l56.1 0c14.7 0 26.7-11.9 26.7-26.7c0-29.5-23.9-53.3-53.3-53.3l-69.3 0c-9.2 0-17.8 2.3-25.3 6.4zM416 176a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M0 96C0 43 43 0 96 0L544 0c53 0 96 43 96 96l0 320c0 53-43 96-96 96L96 512c-53 0-96-43-96-96L0 96zM96 64C78.3 64 64 78.3 64 96l0 320c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L96 64z"]]
}, faPeopleRoof = {
  prefix: "fad",
  iconName: "people-roof",
  icon: [640, 512, [], "e537", ["M18.9 468.6c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L88 441.5 88 480c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-38.5 26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-36.3-67.5c1.7-1.7 3.2-3.6 4.3-5.8L264 345.5l0 54.5c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-54.5 26.9 49.9c1.2 2.2 2.6 4.1 4.3 5.8l-36.3 67.5c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L440 441.5l0 38.5c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-38.5 26.9 49.9c6.3 11.7 20.8 16 32.5 9.8c8.1-4.3 12.6-12.6 12.6-21.2c0-3.8-.9-7.7-2.9-11.4l-37.9-70.3c-15.3-28.5-45.1-46.3-77.5-46.3l-19.5 0c-16.3 0-31.9 4.5-45.4 12.6l-33.6-62.3c-15.3-28.5-45.1-46.3-77.5-46.3l-19.5 0c-32.4 0-62.1 17.8-77.5 46.3l-33.6 62.3c-13.5-8.1-29.1-12.6-45.4-12.6l-19.5 0c-32.4 0-62.1 17.8-77.5 46.3L18.9 468.6zM104 296a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm176-96a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm176 96a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M304.5 4c9.7-5.4 21.4-5.4 31.1 0l288 160c15.4 8.6 21 28.1 12.4 43.5s-28.1 21-43.5 12.4L320 68.6 47.5 220c-15.4 8.6-34.9 3-43.5-12.4s-3-34.9 12.4-43.5L304.5 4z"]]
}, faSquareArrowRight = {
  prefix: "fad",
  iconName: "square-arrow-right",
  icon: [448, 512, ["arrow-square-right"], "f33b", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM80 256c0-13.3 10.7-24 24-24l182.1 0-71-71c-9.4-9.4-9.4-24.6 0-33.9c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7L361 239c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17L249 385c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7c-9.4-9.4-9.4-24.6 0-33.9l71-71L104 280c-13.3 0-24-10.7-24-24z", "M361 239c9.4 9.4 9.4 24.6 0 33.9L249 385c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l71-71L104 280c-13.3 0-24-10.7-24-24s10.7-24 24-24l182.1 0-71-71c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L361 239z"]]
}, faArrowSquareRight = faSquareArrowRight, faLocationPlus = {
  prefix: "fad",
  iconName: "location-plus",
  icon: [384, 512, ["map-marker-plus"], "f60a", ["M0 192c0 87.4 117 243 168.3 307.2c6.1 7.7 14.9 11.5 23.7 11.5s17.6-3.8 23.7-11.5C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192zm80 0c0-13.3 10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64-64 0c-13.3 0-24-10.7-24-24z", "M168 216l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0z"]]
}, faMapMarkerPlus = faLocationPlus, faLightbulbExclamationOn = {
  prefix: "fad",
  iconName: "lightbulb-exclamation-on",
  icon: [640, 512, [], "e1ca", ["M144 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4c19.8 27.1 39.7 54.4 49.2 86.2l160 0c9.6-31.9 29.5-59.1 49.2-86.2c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C496 78.8 417.2 0 320 0S144 78.8 144 176zM352 288a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM296 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112z", "M69.3 4l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3S58.3-3.3 69.3 4zM597.3 44l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zM24 160l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm528 0l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM117.3 332l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zm432-39.9l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3s22.3-14 33.3-6.7zM400 432c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-48 160 0 0 48z"]]
}, faPeopleLine = {
  prefix: "fad",
  iconName: "people-line",
  icon: [640, 512, [], "e534", ["M18.9 340.6c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L88 313.5 88 352c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-38.5 26.9 49.9c6.3 11.7 20.8 16 32.5 9.8s16-20.8 9.8-32.5l-36.3-67.5c1.7-1.7 3.2-3.6 4.3-5.8L264 217.5l0 54.5c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-54.5 26.9 49.9c1.2 2.2 2.6 4.1 4.3 5.8l-36.3 67.5c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L440 313.5l0 38.5c0 17.7 14.3 32 32 32l48 0c17.7 0 32-14.3 32-32l0-38.5 26.9 49.9c6.3 11.7 20.8 16 32.5 9.8c8.1-4.3 12.6-12.6 12.6-21.2c0-3.8-.9-7.7-2.9-11.4l-37.9-70.3c-15.3-28.5-45.1-46.3-77.5-46.3l-19.5 0c-16.3 0-31.9 4.5-45.4 12.6l-33.6-62.3c-15.3-28.5-45.1-46.3-77.5-46.3l-19.5 0c-32.4 0-62.1 17.8-77.5 46.3l-33.6 62.3c-13.5-8.1-29.1-12.6-45.4-12.6l-19.5 0c-32.4 0-62.1 17.8-77.5 46.3L18.9 340.6zM104 168a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zM280 72a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm176 96a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M0 448c0-17.7 14.3-32 32-32l576 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32z"]]
}, faBeerMugEmpty = {
  prefix: "fad",
  iconName: "beer-mug-empty",
  icon: [512, 512, ["beer"], "f0fc", ["M32 64c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32l0 32 51.2 0c42.4 0 76.8 34.4 76.8 76.8l0 102.1c0 30.4-17.9 57.9-45.6 70.2L384 381.7l0 34.3c0 35.3-28.7 64-64 64L96 480c-35.3 0-64-28.7-64-64L32 64zm96 80l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16s-16 7.2-16 16zm64 0l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16s-16 7.2-16 16zm64 0l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16s-16 7.2-16 16zm128 16l0 151.6 56.4-25.1c4.6-2.1 7.6-6.6 7.6-11.7l0-102.1c0-7.1-5.7-12.8-12.8-12.8L384 160z", "M144 128c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16zm64 0c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16zm64 0c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224c0-8.8 7.2-16 16-16z"]]
}, faBeer = faBeerMugEmpty, faCarpool = {
  prefix: "fad",
  iconName: "carpool",
  icon: [512, 512, ["car-people"], "e69c", ["M0 416l0 32c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-32L0 416zM116.8 224l118.4 0c-7.3-14.2-22.1-24-39.2-24l-40 0c-17.1 0-31.9 9.8-39.2 24zM136 144a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zm140.8 80l118.4 0c-7.3-14.2-22.1-24-39.2-24l-40 0c-17.1 0-31.9 9.8-39.2 24zM296 144a40 40 0 1 0 80 0 40 40 0 1 0 -80 0zM416 416l0 32c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-32-96 0z", "M104.6 122.9L80.4 224l351.3 0L407.4 122.9c-6-25.2-28.6-42.9-54.5-42.9L159.1 80c-25.9 0-48.4 17.8-54.5 42.9zM28.4 234.8L57.9 111.7C69.2 65 111 32 159.1 32l193.9 0c48.1 0 89.9 33 101.1 79.7l29.5 123.1c17.1 11.5 28.4 31 28.4 53.2l0 128L0 416 0 288c0-22.2 11.3-41.7 28.4-53.2zM96 352a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]]
}, faCarPeople = faCarpool, faCrateEmpty = {
  prefix: "fad",
  iconName: "crate-empty",
  icon: [512, 512, [], "e151", ["M0 272l0 80 512 0 0-80c0-26.5-21.5-48-48-48L48 224c-26.5 0-48 21.5-48 48zM0 384l0 80c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-80L0 384zm80-96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 160a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM464 288a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 160a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M64 304a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm0 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM464 288a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM448 464a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]]
}, faDiagramPredecessor = {
  prefix: "fad",
  iconName: "diagram-predecessor",
  icon: [512, 512, [], "e477", ["M0 352l0 64c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64L64 288c-35.3 0-64 28.7-64 64z", "M224 224c35.3 0 64-28.7 64-64l0-64 80 0c8.8 0 16 7.2 16 16l0 16-38.1 0c-21.4 0-32.1 25.9-17 41L399 239c9.4 9.4 24.6 9.4 33.9 0L503 169c15.1-15.1 4.4-41-17-41L448 128l0-16c0-44.2-35.8-80-80-80L224 32l-16 0L64 32C28.7 32 0 60.7 0 96l0 64c0 35.3 28.7 64 64 64l160 0z"]]
}, faTransporter = {
  prefix: "fad",
  iconName: "transporter",
  icon: [512, 512, [], "e042", ["M0 112c0 4.1 2.7 7.6 6.6 8.7L32 128l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 128l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 96 56.7 70.6C55.6 66.7 52.1 64 48 64s-7.6 2.7-8.7 6.6L32 96 6.6 103.3C2.7 104.4 0 107.9 0 112zM416 48c0 4.1 2.7 7.6 6.6 8.7L448 64l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 64l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 32 472.7 6.6C471.6 2.7 468.1 0 464 0s-7.6 2.7-8.7 6.6L448 32l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7z", "M208 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm40 272l0 96-64 0 0-178.7L153 276c-11.1 13.8-31.2 16-45 5s-16-31.2-5-45l57.7-72c18.2-22.7 45.8-36 74.9-36l40.7 0c29.1 0 56.7 13.2 74.9 36L409 236c11 13.8 8.8 33.9-5 45s-33.9 8.8-45-5l-31-38.7L328 416l-64 0 0-96-16 0zM216 512l-88 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-88 0-80 0z"]]
}, faCalendarCircleUser = {
  prefix: "fad",
  iconName: "calendar-circle-user",
  icon: [576, 512, [], "e471", ["M0 112l0 48 448 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32S96 14.3 96 32l0 32L48 64C21.5 64 0 85.5 0 112zm0 80L0 464c0 26.5 21.5 48 48 48l282.8 0C285.6 480.1 256 427.5 256 368c0-91.8 70.3-167.2 160-175.3l0-.7L0 192z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-32c-30.2 0-57.5-11.9-77.7-31.3c6.2-19 24-32.7 45.1-32.7l65.2 0c21 0 38.9 13.7 45.1 32.7C489.5 468.1 462.2 480 432 480zm0-192a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]]
}, faArrowUpLong = {
  prefix: "fad",
  iconName: "arrow-up-long",
  icon: [384, 512, ["long-arrow-up"], "f176", ["M160 109.3c10.7-10.7 21.3-21.3 32-32c10.7 10.7 21.3 21.3 32 32L224 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-370.7z", "M169.4 9.4c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L192 77.3 86.6 182.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128z"]]
}, faLongArrowUp = faArrowUpLong, faPersonCarryBox = {
  prefix: "fad",
  iconName: "person-carry-box",
  icon: [384, 512, ["person-carry"], "f4cf", ["M192 128l0 96 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l128 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L224 96c-17.7 0-32 14.3-32 32z", "M32 48a48 48 0 1 1 96 0A48 48 0 1 1 32 48zM96 241.7l0 65.1 51 51c7.1 7.1 11.8 16.2 13.4 26.1l15.2 90.9c2.9 17.4-8.9 33.9-26.3 36.8s-33.9-8.9-36.8-26.3L98.1 399.4 18.7 320C6.7 308 0 291.7 0 274.7l0-88.1C0 154.2 26.2 128 58.6 128c24.1 0 46.5 12 59.9 32l42.6 64 62.9 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-71.4 0c-16 0-31-8-39.9-21.4L96 241.7zM0 480L0 346.5l64 64L64 480s0 0 0 0c0 17.7-14.3 32-32 32s-32-14.3-32-32z"]]
}, faPersonCarry = faPersonCarryBox, faFireFlameSimple = {
  prefix: "fad",
  iconName: "fire-flame-simple",
  icon: [384, 512, ["burn"], "f46a", ["M0 321.6C0 426.7 86.8 512 192 512s192-85.3 192-190.4c0-22.2-3.9-44.2-11.5-65.1l-.7-1.9C337.8 160.8 282 76.5 209.1 8.5l-3.3-3C202.1 2 197.1 0 192 0s-10.1 2-13.8 5.5l-3.3 3C102 76.5 46.2 160.8 12.2 254.6l-.7 1.9C3.9 277.3 0 299.4 0 321.6zm96 13.9c0-10.1 2.1-20.3 6.2-29.5l1.9-4.3c15.8-35.4 37.9-67.7 65.3-95.1l8.9-8.9c3.6-3.6 8.5-5.6 13.6-5.6s10 2 13.6 5.6l8.9 8.9c27.4 27.4 49.6 59.7 65.3 95.1l1.9 4.3c4.1 9.3 6.2 19.4 6.2 29.5c0 53-43 96.5-96 96.5s-96-43.5-96-96.5z", "M279.8 301.6l1.9 4.3c4.1 9.3 6.2 19.4 6.2 29.5c0 53-43 96.5-96 96.5s-96-43.5-96-96.5c0-10.1 2.1-20.3 6.2-29.5l1.9-4.3c15.8-35.4 37.9-67.7 65.3-95.1l8.9-8.9c3.6-3.6 8.5-5.6 13.6-5.6s10 2 13.6 5.6l8.9 8.9c27.4 27.4 49.6 59.7 65.3 95.1z"]]
}, faBurn = faFireFlameSimple, faPerson = {
  prefix: "fad",
  iconName: "person",
  icon: [320, 512, [129485, "male"], "f183", ["M112 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M88 256.9L59.4 304.5c-9.1 15.1-28.8 20-43.9 10.9s-20-28.8-10.9-43.9l58.3-97c17.4-28.9 48.6-46.6 82.3-46.6l29.7 0c33.7 0 64.9 17.7 82.3 46.6l58.3 97c9.1 15.1 4.2 34.8-10.9 43.9s-34.8 4.2-43.9-10.9L232 256.9 232 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-16 0 0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-223.1z"]]
}, faMale = faPerson, faLaptop = {
  prefix: "fad",
  iconName: "laptop",
  icon: [640, 512, [128187], "f109", ["M0 403.2C0 445.6 34.4 480 76.8 480l486.4 0c42.4 0 76.8-34.4 76.8-76.8c0-10.6-8.6-19.2-19.2-19.2L19.2 384C8.6 384 0 392.6 0 403.2zM64 96l0 256 64 0 0-256 384 0 0 256 64 0 0-256c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96z", "M128 96H512V352H128V96z"]]
}, faFileCsv = {
  prefix: "fad",
  iconName: "file-csv",
  icon: [512, 512, [], "f6dd", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-208 0c-35.3 0-64 28.7-64 64l0 144-48 0c-35.3 0-64-28.7-64-64L0 64z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM200 352c-22.1 0-40 17.9-40 40l0 80c0 22.1 17.9 40 40 40l16 0c22.1 0 40-17.9 40-40l0-8c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 8c0 4.4-3.6 8-8 8l-16 0c-4.4 0-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8l16 0c4.4 0 8 3.6 8 8l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8c0-22.1-17.9-40-40-40l-16 0zm133.1 0c-24.9 0-45.1 20.2-45.1 45.1c0 17.8 10.5 34 26.8 41.2l37.4 16.6c4.7 2.1 7.8 6.8 7.8 12c0 7.2-5.9 13.1-13.1 13.1L304 480c-8.8 0-16 7.2-16 16s7.2 16 16 16l42.9 0c24.9 0 45.1-20.2 45.1-45.1c0-17.8-10.5-34-26.8-41.2l-37.4-16.6c-4.7-2.1-7.8-6.8-7.8-12c0-7.2 5.9-13.1 13.1-13.1l34.9 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-34.9 0zm98.9 0c-8.8 0-16 7.2-16 16l0 31.6c0 34.7 10.3 68.7 29.6 97.6l5.1 7.7c3 4.5 8 7.1 13.3 7.1s10.3-2.7 13.3-7.1l5.1-7.7c19.3-28.9 29.6-62.9 29.6-97.6l0-31.6c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 31.6c0 23-5.5 45.6-16 66c-10.5-20.3-16-42.9-16-66l0-31.6c0-8.8-7.2-16-16-16z"]]
}, faMenorah = {
  prefix: "fad",
  iconName: "menorah",
  icon: [640, 512, [], "f676", ["M0 62.8L0 64C0 81.7 14.3 96 32 96s32-14.3 32-32l0-1.2c0-4.5-.9-8.9-2.7-13.1L43.2 7.4C41.2 2.9 36.9 0 32 0s-9.2 2.9-11.2 7.4L2.7 49.7C.9 53.9 0 58.3 0 62.8zm96 0L96 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-1.2c0-4.5-.9-8.9-2.7-13.1L139.2 7.4C137.2 2.9 132.9 0 128 0s-9.2 2.9-11.2 7.4L98.7 49.7C96.9 53.9 96 58.3 96 62.8zm96 0l0 1.2c0 17.7 14.3 32 32 32s32-14.3 32-32l0-1.2c0-4.5-.9-8.9-2.7-13.1L235.2 7.4C233.2 2.9 228.9 0 224 0s-9.2 2.9-11.2 7.4L194.7 49.7c-1.8 4.1-2.7 8.6-2.7 13.1zm96 0l0 1.2c0 17.7 14.3 32 32 32s32-14.3 32-32l0-1.2c0-4.5-.9-8.9-2.7-13.1L331.2 7.4C329.2 2.9 324.9 0 320 0s-9.2 2.9-11.2 7.4L290.7 49.7c-1.8 4.1-2.7 8.6-2.7 13.1zm96 0l0 1.2c0 17.7 14.3 32 32 32s32-14.3 32-32l0-1.2c0-4.5-.9-8.9-2.7-13.1L427.2 7.4C425.2 2.9 420.9 0 416 0s-9.2 2.9-11.2 7.4L386.7 49.7c-1.8 4.1-2.7 8.6-2.7 13.1zm96 0l0 1.2c0 17.7 14.3 32 32 32s32-14.3 32-32l0-1.2c0-4.5-.9-8.9-2.7-13.1L523.2 7.4C521.2 2.9 516.9 0 512 0s-9.2 2.9-11.2 7.4L482.7 49.7c-1.8 4.1-2.7 8.6-2.7 13.1zm96 0l0 1.2c0 17.7 14.3 32 32 32s32-14.3 32-32l0-1.2c0-4.5-.9-8.9-2.7-13.1L619.2 7.4C617.2 2.9 612.9 0 608 0s-9.2 2.9-11.2 7.4L578.7 49.7c-1.8 4.1-2.7 8.6-2.7 13.1z", "M64 160c0-17.7-14.3-32-32-32s-32 14.3-32 32L0 288c0 53 43 96 96 96l192 0 0 64-128 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0 160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0 0-64 192 0c53 0 96-43 96-96l0-128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128c0 17.7-14.3 32-32 32l-192 0 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 160L96 320c-17.7 0-32-14.3-32-32l0-128zm96 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96 0 32 64 0 0-32 0-96zm96 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96 0 32 64 0 0-32 0-96zm192 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96 0 32 64 0 0-32 0-96zm96 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96 0 32 64 0 0-32 0-96z"]]
}, faUnion = {
  prefix: "fad",
  iconName: "union",
  icon: [384, 512, [8899], "f6a2", ["M32 32c17.7 0 32 14.3 32 32l0 224c0 70.7 57.3 128 128 128s128-57.3 128-128l0-224c0-17.7 14.3-32 32-32s32 14.3 32 32l0 224c0 106-86 192-192 192S0 394 0 288L0 64C0 46.3 14.3 32 32 32z", ""]]
}, faChevronsLeft = {
  prefix: "fad",
  iconName: "chevrons-left",
  icon: [512, 512, ["chevron-double-left"], "f323", ["M224 256c0 8.2 3.1 16.4 9.4 22.6l192 192c6.2 6.2 14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4c12.5-12.5 12.5-32.8 0-45.3L301.3 256 470.6 86.6c12.5-12.5 12.5-32.8 0-45.3C464.4 35.1 456.2 32 448 32s-16.4 3.1-22.6 9.4l-192 192c-6.2 6.2-9.4 14.4-9.4 22.6z", "M41.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l192-192c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L109.3 256 278.6 425.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-192-192z"]]
}, faChevronDoubleLeft = faChevronsLeft, faCircleHeart = {
  prefix: "fad",
  iconName: "circle-heart",
  icon: [512, 512, ["heart-circle"], "f4c7", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm109.8-29.1c0-19.5 7.3-39.1 22-54s33.9-22.4 53.2-22.4s38.5 7.5 53.2 22.4c5.9 6 11.8 12 17.7 18c5.9-6 11.8-12 17.7-18c14.7-14.9 33.9-22.4 53.2-22.4s38.5 7.5 53.2 22.4s22 34.5 22 54s-7.3 39.1-22 54L278.5 384.1c-6.2 6.3-14.3 9.4-22.5 9.4s-16.3-3.1-22.5-9.4L131.9 280.9c-14.7-14.9-22-34.5-22-54z", "M131.9 172.9c-29.4 29.8-29.4 78.2 0 108L233.5 384.1c6.2 6.3 14.3 9.4 22.5 9.4s16.3-3.1 22.5-9.4L380.1 280.9c29.4-29.8 29.4-78.2 0-108s-77-29.8-106.4 0l-17.7 18-17.7-18c-29.4-29.8-77-29.8-106.4 0z"]]
}, faHeartCircle = faCircleHeart, faTruckPlane = {
  prefix: "fad",
  iconName: "truck-plane",
  icon: [640, 512, [], "e58f", ["M0 288l0 64c0 5.1 2.4 9.8 6.4 12.8s9.3 3.9 14.1 2.5l123.4-37 0 81.2-50 40c-3.8 3-6 7.6-6 12.5l0 32c0 5.1 2.5 10 6.6 13s9.5 3.8 14.4 2.2L200 480.9 290.4 511c-1.6-4.7-2.4-9.8-2.4-15l0-32.6c-18.2-10.5-30.7-29.7-31.9-51.8c-.1-1.3-.1-2.4-.1-3.6l0-82.5L256 184c0-.4 0-.7 0-1.1c0-32.3 0-64.6 0-96.9C256 54.7 231.5 0 200 0c-30.6 0-56 54.7-56 86.1l0 106.5L7.8 274.3C2.9 277.2 0 282.4 0 288z", "M336 128c-26.5 0-48 21.5-48 48l0 224c0 20.9 13.4 38.7 32 45.3l0 42.7c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-40 160 0 0 40c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-42.7c18.6-6.6 32-24.4 32-45.3l0-224c0-26.5-21.5-48-48-48l-256 0zm16 176l15.8-49.3c3.3-8.7 11.2-14.7 20.5-14.7l151.4 0c9.2 0 17.2 6 20.5 14.7L576 304l-224 0zm192 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM360 352a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faRecordVinyl = {
  prefix: "fad",
  iconName: "record-vinyl",
  icon: [512, 512, [], "f8d9", ["M128 256a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm160 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M256 512A256 256 0 1 0 256 0a256 256 0 1 0 0 512zm0-384a128 128 0 1 1 0 256 128 128 0 1 1 0-256z"]]
}, faBringForward = {
  prefix: "fad",
  iconName: "bring-forward",
  icon: [512, 512, [], "f856", ["M160 352l0 96c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64l-96 0 0 64 96 0 0 224-224 0 0-96-64 0z", "M0 288c0 35.3 28.7 64 64 64H288c35.3 0 64-28.7 64-64V64c0-35.3-28.7-64-64-64H64C28.7 0 0 28.7 0 64V288z"]]
}, faSquareP = {
  prefix: "fad",
  iconName: "square-p",
  icon: [448, 512, [], "e279", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm128 56c0-13.3 10.7-24 24-24l92 0c50.8 0 92 41.2 92 92s-41.2 92-92 92l-68 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72 0-136zm48 24l0 88 68 0c24.3 0 44-19.7 44-44s-19.7-44-44-44l-68 0z", "M128 152c0-13.3 10.7-24 24-24l92 0c50.8 0 92 41.2 92 92s-41.2 92-92 92l-68 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72 0-136zm48 112l68 0c24.3 0 44-19.7 44-44s-19.7-44-44-44l-68 0 0 88z"]]
}, faFaceGrinStars = {
  prefix: "fad",
  iconName: "face-grin-stars",
  icon: [512, 512, [129321, "grin-stars"], "f587", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm91.5-86.2c1-2.9 3.5-5.1 6.6-5.5l38.1-5 16.6-34.7c1.3-2.8 4.1-4.6 7.2-4.6s5.9 1.8 7.2 4.6l16.6 34.7 38.1 5c3.1 .4 5.6 2.5 6.6 5.5s.1 6.2-2.1 8.3l-27.9 26.5 7 37.8c.6 3-.7 6.1-3.2 7.9s-5.8 2-8.5 .6L160 232.5l-33.8 18.3c-2.7 1.5-6 1.3-8.5-.6s-3.7-4.9-3.2-7.9l7-37.8L93.6 178c-2.2-2.1-3.1-5.3-2.1-8.3zm13.6 161.7c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19c12.3-3.8 24.3 6.9 19.3 18.7C382.4 390.6 324.2 432 256.3 432s-126.2-41.4-151.1-100.5zM283.5 169.8c1-2.9 3.5-5.1 6.6-5.5l38.1-5 16.6-34.7c1.3-2.8 4.1-4.6 7.2-4.6s5.9 1.8 7.2 4.6l16.6 34.7 38.1 5c3.1 .4 5.6 2.5 6.6 5.5c.3 .8 .4 1.6 .4 2.5c0 2.2-.9 4.3-2.5 5.8l-27.9 26.5 7 37.8c.6 3-.7 6.1-3.2 7.9s-5.8 2-8.5 .6L352 232.5l-33.8 18.3c-2.7 1.5-6 1.3-8.5-.6s-3.7-4.9-3.2-7.9l7-37.8L285.6 178c-2.2-2.1-3.1-5.3-2.1-8.3z", "M167.2 124.6c-1.3-2.8-4.1-4.6-7.2-4.6s-5.9 1.8-7.2 4.6l-16.6 34.7-38.1 5c-3.1 .4-5.6 2.5-6.6 5.5s-.1 6.2 2.1 8.3l27.9 26.5-7 37.8c-.6 3 .7 6.1 3.2 7.9s5.8 2 8.5 .6L160 232.5l33.8 18.3c2.7 1.5 6 1.3 8.5-.6s3.7-4.9 3.2-7.9l-7-37.8L226.4 178c2.2-2.1 3.1-5.3 2.1-8.3s-3.5-5.1-6.6-5.5l-38.1-5-16.6-34.7zm192 0c-1.3-2.8-4.1-4.6-7.2-4.6s-5.9 1.8-7.2 4.6l-16.6 34.7-38.1 5c-3.1 .4-5.6 2.5-6.6 5.5s-.1 6.2 2.1 8.3l27.9 26.5-7 37.8c-.6 3 .7 6.1 3.2 7.9s5.8 2 8.5 .6L352 232.5l33.8 18.3c2.7 1.5 6 1.3 8.5-.6s3.7-4.9 3.2-7.9l-7-37.8L418.4 178c2.2-2.1 3.1-5.3 2.1-8.3s-3.5-5.1-6.6-5.5l-38.1-5-16.6-34.7z"]]
}, faGrinStars = faFaceGrinStars, faSigma = {
  prefix: "fad",
  iconName: "sigma",
  icon: [384, 512, [8721], "f68b", ["M2.4 51.8C7.4 39.8 19.1 32 32 32l288 0c35.3 0 64 28.7 64 64l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32L109.3 96 246.6 233.4c12.5 12.5 12.5 32.8 0 45.3L109.3 416 320 416l0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32c0 35.3-28.7 64-64 64L32 480c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L178.7 256 9.4 86.6C.2 77.5-2.5 63.7 2.4 51.8z", ""]]
}, faCameraMovie = {
  prefix: "fad",
  iconName: "camera-movie",
  icon: [576, 512, [127909, 127910], "f8a9", ["M0 288c0 17.7 14.3 32 32 32l32 0 0 128c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-16 0-96 0-16c0-35.3-28.7-64-64-64l-32 0-224 0-64 0-32 0c-17.7 0-32 14.3-32 32z", "M128 64a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM352 256l-224 0C57.3 256 0 198.7 0 128S57.3 0 128 0c48.2 0 90.2 26.6 112 66C261.8 26.6 303.8 0 352 0c70.7 0 128 57.3 128 128s-57.3 128-128 128zm0-192a64 64 0 1 0 0 128 64 64 0 1 0 0-128zM558.3 259.4c10.8 5.4 17.7 16.5 17.7 28.6l0 192c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48L448 448l0-16 0-96 0-16 12.8-9.6 64-48c9.7-7.3 22.7-8.4 33.5-3z"]]
}, faBong = {
  prefix: "fad",
  iconName: "bong",
  icon: [448, 512, [], "f55c", ["M0 384c0 39.4 11.9 76.1 32.2 106.5C41.9 504.9 58.8 512 76.1 512l231.9 0c17.3 0 34.2-7.1 43.8-21.5C372.1 460.1 384 423.4 384 384c0-36.1-10-69.9-27.3-98.8L400 241.9l7 7c9.4 9.4 24.6 9.4 33.9 0c4.7-4.7 7-10.8 7-17s-2.3-12.3-7-17l-24-24-24-24c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l7 7-39.3 39.3c-9.4-9.3-19.8-17.6-30.9-24.8c-4.8-3.1-7.9-8.3-7.9-14L288 64c17.7 0 32-14.3 32-32s-14.3-32-32-32L272 0 112 0 96 0C78.3 0 64 14.3 64 32s14.3 32 32 32l0 144.5c0 5.7-3.1 10.9-7.9 14C35.1 256.7 0 316.2 0 384zm64 0c0-23.3 6.2-45.2 17.1-64c10.2-17.6 24.5-32.6 41.7-43.7c21.6-13.9 37.2-38.7 37.2-67.8L160 64l64 0 0 144.5c0 29.1 15.6 53.9 37.2 67.8c17.2 11.1 31.5 26.1 41.7 43.7c10.9 18.8 17.1 40.7 17.1 64c0 23.4-6.2 45.2-17.1 64L81.1 448C70.2 429.2 64 407.4 64 384z", "M302.9 320L81.1 320C70.2 338.8 64 360.7 64 384c0 23.4 6.2 45.2 17.1 64l221.8 0c10.9-18.8 17.1-40.6 17.1-64c0-23.3-6.2-45.2-17.1-64z"]]
}, faClarinet = {
  prefix: "fad",
  iconName: "clarinet",
  icon: [640, 512, [], "f8ad", ["M0 240l0 64c0 6.5 4 12.4 10.1 14.9l68.6 27.4c9.4 3.8 19.5 5.7 29.7 5.7l448.3 0c9.5 0 18.7 2.8 26.6 8.1l31.9 21.3c2.7 1.8 5.8 2.7 8.9 2.7c2.6 0 5.2-.6 7.5-1.9c5.2-2.8 8.5-8.2 8.5-14.1l0-192c0-5.9-3.2-11.3-8.5-14.1c-2.4-1.3-5-1.9-7.5-1.9c-3.1 0-6.2 .9-8.9 2.7l-31.9 21.3c-7.9 5.3-17.1 8.1-26.6 8.1L480 192l-32 0-64 0-32 0-64 0-32 0-147.7 0c-10.2 0-20.3 1.9-29.7 5.7L10.1 225.1C4 227.6 0 233.5 0 240zm296 32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M240 128c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 32 32 0 0-32 64 0 0 32 32 0 0-32 64 0 0 32 32 0 0-32 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0-96 0-96 0-32 0zm32 168a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm72 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]]
}, faTruckFlatbed = {
  prefix: "fad",
  iconName: "truck-flatbed",
  icon: [640, 512, [], "e2b6", ["M96 432a80 80 0 1 0 160 0A80 80 0 1 0 96 432zm288 0a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M640 384c0 17.7-14.3 32-32 32l-33.1 0c-7.8-54.3-54.4-96-110.9-96s-103.1 41.7-110.9 96l-1.1 0-65.1 0c-3.6-24.9-15.3-47.2-32.5-64l97.6 0 0-224c0-17.7 14.3-32 32-32l16 0 16 0 50.7 0c17 0 33.3 6.7 45.3 18.7L589.3 192c12 12 18.7 28.3 18.7 45.3l0 18.7 0 32 0 64c17.7 0 32 14.3 32 32zM97.6 352c-17.1 16.8-28.9 39.1-32.5 64L32 416c-17.7 0-32-14.3-32-32s14.3-32 32-32l65.6 0zM544 256l0-18.7L466.7 160 416 160l0 96 128 0z"]]
}, faSpaghettiMonsterFlying = {
  prefix: "fad",
  iconName: "spaghetti-monster-flying",
  icon: [640, 512, ["pastafarianism"], "f67b", ["M0 224c0 13.3 10.7 24 24 24c2.5 0 4.3 .6 7.1 3.3c3.7 3.5 7.1 8.8 12.5 17.4l.6 .9c4.6 7.4 11 17.6 19.4 25.7C73.3 304.6 86.5 312 104 312c18.5 0 32.9-8.5 44.3-18.6c3.1 4 6.6 8.3 10.5 12.7c-1.4 4.3-2.8 8.5-4 12.5c-.9 3-1.8 5.8-2.6 8.6c-3 9.8-5.5 18.2-8.6 25.9c-3.9 9.8-7.4 15.4-10.8 18.5c-2.6 2.4-5.9 4.3-12.8 4.3c-8.7 0-16.9-4.2-33.7-13.2c-15-8-35.7-18.8-62.3-18.8c-13.3 0-24 10.7-24 24s10.7 24 24 24c13.4 0 24.7 5.2 39.7 13.2c1 .6 2.1 1.1 3.2 1.7C80.1 414 98.6 424 120 424c18.4 0 33.6-6.1 45.5-17.2c11.1-10.3 17.9-23.7 22.7-36c3.6-9 6.7-19.1 9.5-28.5c16.4 12.3 36.1 23.6 58.9 31.3c-3.6 10.8-8.4 23.5-14.4 36.2c-7.5 15.9-16.2 30.4-25.8 40.5C207 460.5 198.8 464 192 464c-13.3 0-24 10.7-24 24s10.7 24 24 24c25.2 0 45-13.5 59.5-28.8c14.5-15.4 25.7-34.9 34.2-53c8-17 14.1-33.8 18.3-46.9c5.2 .4 10.6 .6 16 .6s10.8-.2 16-.6c4.2 13 10.3 29.9 18.3 46.9c8.5 18.1 19.8 37.6 34.2 53C403 498.5 422.8 512 448 512c13.3 0 24-10.7 24-24s-10.7-24-24-24c-6.8 0-15-3.5-24.5-13.7c-9.5-10.1-18.3-24.6-25.8-40.5c-5.9-12.6-10.7-25.4-14.4-36.2c22.8-7.7 42.5-19 58.9-31.3c2.9 9.4 6 19.5 9.5 28.5c4.8 12.2 11.6 25.6 22.7 36C486.4 417.9 501.6 424 520 424c21.4 0 39.9-10 53.1-17.1c1.1-.6 2.2-1.2 3.2-1.7c15-8 26.3-13.2 39.7-13.2c13.3 0 24-10.7 24-24s-10.7-24-24-24c-26.6 0-47.3 10.8-62.3 18.8c-16.8 9-25 13.2-33.7 13.2c-6.8 0-10.2-1.9-12.8-4.3c-3.4-3.2-7-8.8-10.8-18.5c-3-7.7-5.6-16.1-8.6-25.9c-.8-2.7-1.7-5.6-2.6-8.6c-1.2-4-2.6-8.2-4-12.5c3.9-4.5 7.4-8.8 10.5-12.7C503.1 303.5 517.5 312 536 312c17.5 0 30.7-7.4 40.4-16.7c8.4-8.1 14.8-18.3 19.4-25.7l.6-.9c5.4-8.6 8.8-13.9 12.5-17.4c2.8-2.7 4.6-3.3 7.1-3.3c13.3 0 24-10.7 24-24s-10.7-24-24-24c-17.5 0-30.7 7.4-40.4 16.7c-8.4 8.1-14.8 18.3-19.4 25.7l-.6 .9c-5.4 8.6-8.8 13.9-12.5 17.4c-2.8 2.7-4.6 3.3-7.1 3.3c-3.3 0-8.7-1.7-19.4-13.4c-5.1-5.6-10.4-12.3-16.7-20.4l-1.4-1.8c-5.8-7.4-12.2-15.7-19.3-24c-13.8-16.2-30.4-32.8-51.4-46.4l15.1-30.2c-17.1-1.3-32.2-9.4-42.9-21.5l-15.6 31.2c-18.7-6-39.9-9.5-64.4-9.5s-45.8 3.5-64.4 9.5L240 106.3c-10.7 12.1-25.9 20.1-42.9 21.5L212.2 158c-21.1 13.6-37.7 30.2-51.4 46.4c-7.1 8.3-13.5 16.6-19.3 24l-1.4 1.8c-6.3 8.1-11.6 14.8-16.7 20.4C112.7 262.3 107.3 264 104 264c-2.5 0-4.3-.6-7.1-3.3c-3.7-3.5-7.1-8.8-12.5-17.4l-.6-.9c-4.6-7.4-11-17.6-19.4-25.7C54.7 207.4 41.5 200 24 200c-13.3 0-24 10.7-24 24z", "M208 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80 0a64 64 0 1 1 128 0A64 64 0 1 1 128 64zm336 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-80 0a64 64 0 1 1 128 0A64 64 0 1 1 384 64z"]]
}, faPastafarianism = faSpaghettiMonsterFlying, faArrowDownUpAcrossLine = {
  prefix: "fad",
  iconName: "arrow-down-up-across-line",
  icon: [576, 512, [], "e4af", ["M0 256c0-17.7 14.3-32 32-32l96 0 64 0 192 0 64 0 96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0-64 0-192 0-64 0-96 0c-17.7 0-32-14.3-32-32z", "M137.4 502.6c12.5 12.5 32.8 12.5 45.3 0l96-96c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 402.7 192 288l-64 0 0 114.7L86.6 361.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l96 96zM128 224l64 0 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 160zM393.4 9.4l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L384 109.3 384 224l64 0 0-114.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96c-12.5-12.5-32.8-12.5-45.3 0zM448 448l0-160-64 0 0 160c0 17.7 14.3 32 32 32s32-14.3 32-32z"]]
}, faArrowsRotateReverse = {
  prefix: "fad",
  iconName: "arrows-rotate-reverse",
  icon: [512, 512, [], "e630", ["M42.7 320c0 3.5 .6 7.1 1.8 10.6C55.3 361.3 73 390 97.4 414.4C141.1 458.1 198.4 480 255.8 480c57.3 0 114.6-21.9 158.4-65.6l17.6-17.5 0 35.1c0 17.7 14.3 32 32 32s32-14.3 32-32l0-111.6 0-.4c0-1.6-.1-3.2-.4-4.8c-.2-1.3-.5-2.6-.8-3.8c-1.4-5.1-4.1-9.9-8.1-14c-3.9-4-8.7-6.7-13.7-8.2c-1.5-.4-3-.8-4.6-1c-1.6-.2-3.2-.3-4.8-.3l-111.6 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l34.4 0L369 369.1c-62.6 62.6-163.9 62.6-226.3 .1c-17.5-17.5-30.1-38-37.8-59.8c-5.9-16.7-24.2-25.4-40.8-19.5c-13.1 4.6-21.4 17-21.4 30.2z", "M406.6 202.6c-7.7-21.8-20.2-42.3-37.8-59.8c-62.5-62.5-163.8-62.5-226.3 0L125.5 160l34.3 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L48.3 224c0 0 0 0 0 0l-.4 0c-17.7 0-32-14.3-32-32l0-112c0-17.7 14.3-32 32-32s32 14.3 32 32l0 35.2L97.4 97.6c87.5-87.5 229.3-87.5 316.8 0c24.4 24.4 42.1 53.1 52.9 83.7c5.9 16.7-2.9 34.9-19.5 40.8s-34.9-2.9-40.8-19.5z"]]
}, faLeafHeart = {
  prefix: "fad",
  iconName: "leaf-heart",
  icon: [512, 512, [], "f4cb", ["M0 440l0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-16c0-48.6 20.7-92.5 53.8-123.2C121.6 392.3 190.3 448 272 448l1 0c132.1-.7 239-130.9 239-291.4c0-42.6-7.5-83.1-21.1-119.6c-2.6-6.9-12.7-6.6-16.2-.1C455.9 72.1 418.7 96 376 96c-34.7 0-69.3 0-104 0c-93.2 0-169.5 72.5-175.6 164.1C38.3 298.8 0 364.9 0 440zM190 237.3c.2-1.8 .5-3.6 .8-5.3c.7-3.5 1.8-6.8 3.1-10c2.7-6.4 6.6-12.2 11.5-17c9.7-9.7 23.1-15.7 37.8-15.7c.5 0 1 0 1.5 0c14.3 0 28.1 5.6 38.4 15.6c1.6 1.6 3.3 3.2 4.9 4.8c1.6-1.6 3.3-3.2 4.9-4.8c10.3-10 24-15.6 38.4-15.6c.5 0 1 0 1.5 0c29.5 0 53.5 23.9 53.5 53.5c0 14.4-5.8 28.3-16.2 38.4c-23.6 23-47.3 46-70.9 69c-3.1 3-7.1 4.5-11.2 4.5s-8-1.5-11.2-4.5c-23.6-23-47.3-46-70.9-69c-5.2-5-9.2-11-12-17.5c-1.4-3.3-2.4-6.7-3.1-10.1c-.4-1.7-.6-3.5-.8-5.3c-.1-.9-.2-1.8-.2-2.7s-.1-1.8-.1-2.7c0-1.9 0-2.3 .1-2.8c0-.9 .1-1.8 .2-2.7z", "M243.2 189.3c-29.5 0-53.5 23.9-53.5 53.5c0 14.4 5.8 28.3 16.2 38.4l70.9 69c6.2 6 16.1 6 22.3 0l70.9-69c10.4-10.1 16.2-23.9 16.2-38.4c0-29.5-23.9-53.5-53.5-53.5l-1.5 0c-14.3 0-28.1 5.6-38.4 15.6l-4.9 4.8-4.9-4.8c-10.3-10-24-15.6-38.4-15.6l-1.5 0z"]]
}, faHouseBuilding = {
  prefix: "fad",
  iconName: "house-building",
  icon: [640, 512, [], "e1b1", ["M320 48c0-26.5 21.5-48 48-48L592 0c26.5 0 48 21.5 48 48l0 416c0 26.5-21.5 48-48 48l-192 0c10-13.4 16-30 16-48l0-112 16 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-16 0 0-10.9c0-7.2-1-14.3-2.8-21.1l18.8 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 4.6-64-58.7L320 48zm64 64l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm128 0l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 96l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 96l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M0 464L0 277.1c0-13.5 5.6-26.3 15.6-35.4l144-132c18.4-16.8 46.5-16.8 64.9 0l144 132c9.9 9.1 15.6 21.9 15.6 35.4L384 464c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48zM168 272c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0z"]]
}, faCheeseSwiss = {
  prefix: "fad",
  iconName: "cheese-swiss",
  icon: [512, 512, [129472], "f7f0", ["M0 256l332.2 0c-7.6 8.5-12.2 19.7-12.2 32c0 26.5 21.5 48 48 48s48-21.5 48-48c0-12.3-4.6-23.5-12.2-32L512 256l0-15.8C512 125.2 418.8 32 303.8 32c-10.3 0-20.3 3-28.9 8.7l-47 31.3c-7.8 5.2-9.2 16.1-6.3 25.1c1.5 4.7 2.3 9.7 2.3 14.9c0 26.5-21.5 48-48 48c-12 0-22.9-4.4-31.3-11.6c-7.1-6.1-17.7-9.1-25.5-3.8L28.5 205C11.3 216.5 .8 235.5 0 256zM128 384a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M368 336c26.5 0 48-21.5 48-48c0-12.3-4.6-23.5-12.2-32L512 256l0 160c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 256l332.2 0c-7.6 8.5-12.2 19.7-12.2 32c0 26.5 21.5 48 48 48zM224 384a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]]
}, faSpoon = {
  prefix: "fad",
  iconName: "spoon",
  icon: [512, 512, [129348, 61873, "utensil-spoon"], "f2e5", ["M224 160.2C224 80 320 0 416 0c53 0 96 43 96 96c0 96-80 192-160.2 192c-21.6 0-43.2-7.3-60.8-21.8c-2.4-2-4.7-4.1-6.9-6.3l-32-32c-2.2-2.2-4.3-4.6-6.3-6.9c-14.5-17.6-21.8-39.2-21.8-60.8z", "M245.8 220.9c2 2.4 4.1 4.7 6.3 6.9l32 32c2.2 2.2 4.6 4.3 6.9 6.3L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L245.8 220.9z"]]
}, faUtensilSpoon = faSpoon, faJarWheat = {
  prefix: "fad",
  iconName: "jar-wheat",
  icon: [320, 512, [], "e517", ["M0 128L0 448c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 64C28.7 64 0 92.7 0 128zm64 37.8c0-3.2 2.6-5.8 5.8-5.8l42.2 0c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7l42.2 0c3.2 0 5.8 2.6 5.8 5.8c0 32.1-26 58.2-58.2 58.2L176 224l-32 0-21.8 0C90 224 64 198 64 165.8zm0 96c0-3.2 2.6-5.8 5.8-5.8l42.2 0c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7l42.2 0c3.2 0 5.8 2.6 5.8 5.8c0 32.1-26 58.2-58.2 58.2L176 320l-32 0-21.8 0C90 320 64 294 64 261.8zm0 96c0-3.2 2.6-5.8 5.8-5.8l42.2 0c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7l42.2 0c3.2 0 5.8 2.6 5.8 5.8c0 32.1-26 58.2-58.2 58.2L176 416l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-21.8 0C90 416 64 390 64 357.8z", "M64 0L256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 64C46.3 64 32 49.7 32 32S46.3 0 64 0zM256 165.8c0 32.1-26 58.2-58.2 58.2L176 224l-32 0-21.8 0C90 224 64 198 64 165.8c0-3.2 2.6-5.8 5.8-5.8l42.2 0c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7l42.2 0c3.2 0 5.8 2.6 5.8 5.8zM250.2 256c3.2 0 5.8 2.6 5.8 5.8c0 32.1-26 58.2-58.2 58.2L176 320l-32 0-21.8 0C90 320 64 294 64 261.8c0-3.2 2.6-5.8 5.8-5.8l42.2 0c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7l42.2 0zm0 96c3.2 0 5.8 2.6 5.8 5.8c0 32.1-26 58.2-58.2 58.2L176 416l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-21.8 0C90 416 64 390 64 357.8c0-3.2 2.6-5.8 5.8-5.8l42.2 0c19.1 0 36.3 8.4 48 21.7c11.7-13.3 28.9-21.7 48-21.7l42.2 0z"]]
}, faEnvelopesBulk = {
  prefix: "fad",
  iconName: "envelopes-bulk",
  icon: [640, 512, ["mail-bulk"], "f674", ["M32 301l0 39.8L168 441.6c6.9 5.1 15.3 7.9 24 7.9s17-2.8 24-7.9L352 340.8l0-39.8c-51.7 38.3-103.4 76.6-155.1 114.9c-1.4 1-3.1 1.6-4.9 1.6s-3.5-.6-4.9-1.6C135.4 377.6 83.7 339.3 32 301zM96 32l0 192 96 0 0-32c0-35.3 28.7-64 64-64l224 0 0-96c0-17.7-14.3-32-32-32L128 0C110.3 0 96 14.3 96 32zM224 192l0 32 96 0c35.3 0 64 28.7 64 64l0 128 192 0c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32l-320 0c-17.7 0-32 14.3-32 32zm256 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32z", "M496 224l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM32 288c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 13L196.9 415.9c-1.4 1-3.1 1.6-4.9 1.6s-3.5-.6-4.9-1.6L32 301l0-13zM216 441.6L352 340.8 352 480c0 17.7-14.3 32-32 32L64 512c-17.7 0-32-14.3-32-32l0-139.2L168 441.6c6.9 5.1 15.3 7.9 24 7.9s17-2.8 24-7.9z"]]
}, faMailBulk = faEnvelopesBulk, faFileCircleExclamation = {
  prefix: "fad",
  iconName: "file-circle-exclamation",
  icon: [576, 512, [], "e4eb", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 38.6C310.1 219.5 256 287.4 256 368c0 59.1 29.1 111.3 73.7 143.3c-3.2 .5-6.4 .7-9.7 .7L64 512c-35.3 0-64-28.7-64-64L0 64z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zm48 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0-144c8.8 0 16 7.2 16 16l0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c0-8.8 7.2-16 16-16z"]]
}, faBowArrow = {
  prefix: "fad",
  iconName: "bow-arrow",
  icon: [512, 512, [127993], "f6b9", ["M0 128c0 8.2 3.1 16.4 9.4 22.6c53 53 106 106 159 159c11.3 11.3 22.6 22.6 33.9 33.9l159 159c12.5 12.5 32.8 12.5 45.3 0c12.2-12.2 12.5-31.8 .9-44.3c59.5-92.6 53.4-215.1-18.3-301.5c-15.2 15.2-30.3 30.3-45.5 45.5c47.3 60.7 53 143.3 17.1 209.3c-37.7-37.7-75.5-75.5-113.2-113.2c-11.3-11.3-22.6-22.6-33.9-33.9c-37.7-37.7-75.5-75.5-113.2-113.2c66-35.8 148.6-30.1 209.3 17.1l45.5-45.5C268.8 51.1 146.3 45 53.7 104.5c-12.6-11.6-32.1-11.3-44.3 .9C3.1 111.6 0 119.8 0 128z", "M511.7 18.9c1-5.2-.7-10.5-4.4-14.3S498.2-.7 493.1 .3l-128 24c-5.8 1.1-10.6 5.3-12.3 11s-.2 11.8 4 16l35 35L213.7 264.4l33.9 33.9L425.7 120.3l35 35c4.2 4.2 10.4 5.7 16 4s9.9-6.5 11-12.3l24-128zM202.3 343.6l-33.9-33.9-23.8 23.8L93.8 320.7c-8.2-2-16.8 .4-22.8 6.3L7 391c-6.1 6.1-8.5 15-6.2 23.4s8.9 14.8 17.3 16.9l50 12.5 12.5 50c2.1 8.4 8.5 15 16.9 17.3s17.3 0 23.4-6.2l64-64c6-6 8.4-14.6 6.3-22.8l-12.7-50.8 23.8-23.8z"]]
}, faCartXmark = {
  prefix: "fad",
  iconName: "cart-xmark",
  icon: [576, 512, [], "e0dd", ["M120.1 32c2 4.2 3.5 8.8 4.4 13.5c15.4 80.8 30.8 161.6 46.2 242.5l288.5 0c32.6 0 61.1-21.8 69.5-53.3l41-152.3c.9-3.5 1.4-7 1.4-10.5c0-21.4-17.4-39.9-40-39.9l-411 0zm156.5 68.6c7.8-7.8 20.5-7.8 28.3 0L336 131.7l31.1-31.1c7.8-7.8 20.5-7.8 28.3 0s7.8 20.5 0 28.3L364.3 160l31.1 31.1c7.8 7.8 7.8 20.5 0 28.3s-20.5 7.8-28.3 0L336 188.3c-10.4 10.4-20.7 20.7-31.1 31.1c-7.8 7.8-20.5 7.8-28.3 0s-7.8-20.5 0-28.3L307.7 160c-10.4-10.4-20.7-20.7-31.1-31.1c-7.8-7.8-7.8-20.5 0-28.3z", "M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l45.5 0c3.8 0 7.1 2.7 7.9 6.5l51.6 271c6.5 34 36.2 58.5 70.7 58.5L488 384c13.3 0 24-10.7 24-24s-10.7-24-24-24l-288.3 0c-11.5 0-21.4-8.2-23.6-19.5l-51.6-271C119.5 19.1 96.4 0 69.5 0L24 0zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm336-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM395.4 128.9c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0L336 131.7l-31.1-31.1c-7.8-7.8-20.5-7.8-28.3 0s-7.8 20.5 0 28.3L307.7 160l-31.1 31.1c-7.8 7.8-7.8 20.5 0 28.3s20.5 7.8 28.3 0L336 188.3l31.1 31.1c7.8 7.8 20.5 7.8 28.3 0s7.8-20.5 0-28.3L364.3 160l31.1-31.1z"]]
}, faHexagonXmark = {
  prefix: "fad",
  iconName: "hexagon-xmark",
  icon: [512, 512, ["times-hexagon", "xmark-hexagon"], "f2ee", ["M7.4 256c0 12.4 3.2 24.9 9.6 36l88.3 152.9c12.9 22.3 36.6 36 62.4 36l176.6 0c25.7 0 49.5-13.7 62.4-36L494.9 292c6.4-11.1 9.6-23.6 9.6-36s-3.2-24.9-9.6-36L406.6 67.1c-12.9-22.3-36.6-36-62.4-36l-176.6 0c-25.7 0-49.5 13.7-62.4 36L17.1 220c-6.4 11.1-9.6 23.6-9.6 36zm160.7 61.7c.1-.7 .2-1.5 .3-2.3c.3-1.5 .7-3 1.3-4.4c1.2-2.9 2.9-5.6 5.3-7.9c15.7-15.7 31.3-31.4 47-47c-15.7-15.7-31.3-31.3-47-47c-9.4-9.4-9.4-24.6 0-33.9c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c15.7 15.7 31.3 31.3 47 47c15.7-15.7 31.3-31.3 47-47c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c9.4 9.4 9.4 24.6 0 33.9c-15.7 15.7-31.3 31.3-47 47c15.7 15.7 31.4 31.4 47 47c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17s-10.8 7-17 7s-12.3-2.3-17-7l-47-47c-15.7 15.7-31.3 31.3-47 47c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7c-2.3-2.3-4.1-5.1-5.3-7.9c-.6-1.4-1-2.9-1.3-4.4c-.2-1.1-.4-2.3-.3-2.2c-.1-1.2-.1-1.2-.1-2.4c0-1.5 .1-1.9 .1-2.3z", "M209 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]]
}, faTimesHexagon = faHexagonXmark, faXmarkHexagon = faHexagonXmark, faCircleH = {
  prefix: "fad",
  iconName: "circle-h",
  icon: [512, 512, [9405, "hospital-symbol"], "f47e", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM144 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80 128 0 0-80c0-13.3 10.7-24 24-24s24 10.7 24 24l0 104 0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80-128 0 0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208z", "M344 128c13.3 0 24 10.7 24 24l0 104 0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80-128 0 0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80 128 0 0-80c0-13.3 10.7-24 24-24z"]]
}, faHospitalSymbol = faCircleH, faMerge = {
  prefix: "fad",
  iconName: "merge",
  icon: [512, 512, [], "e526", ["M0 416c0 17.7 14.3 32 32 32l97.2 0c29.2 0 56.7-13.3 75-36l99.2-124c5.1 0 10.3 0 15.4 0c-27.4 0-53.5-11.7-71.7-32L154.2 372c-6.1 7.6-15.3 12-25 12L32 384c-17.7 0-32 14.3-32 32zM243.8 252c1.1 1.3 2.2 2.6 3.2 4c-1.1-1.3-2.1-2.7-3.2-4z", "M32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l97.2 0c9.7 0 18.9 4.4 25 12l89.6 112c18.2 22.8 45.8 36 75 36l65.2 0 0 32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c6-6 9.4-14.1 9.4-22.6s-3.4-16.6-9.4-22.6l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 32-65.2 0c-9.7 0-18.9-4.4-25-12L204.2 100c-18.2-22.8-45.8-36-75-36L32 64z"]]
}, faPager = {
  prefix: "fad",
  iconName: "pager",
  icon: [512, 512, [128223], "f815", ["M0 128C0 92.7 28.7 64 64 64l384 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 128zM56 344c0 13.3 10.7 24 24 24l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0c-13.3 0-24 10.7-24 24zm8-184l0 64c0 17.7 14.3 32 32 32l320 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L96 128c-17.7 0-32 14.3-32 32zM192 344c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24z", "M64 160c0-17.7 14.3-32 32-32H416c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V160z"]]
}, faCartMinus = {
  prefix: "fad",
  iconName: "cart-minus",
  icon: [576, 512, [], "e0db", ["M120.1 32c2 4.2 3.5 8.8 4.4 13.5c15.4 80.8 30.8 161.6 46.2 242.5l288.5 0c32.6 0 61.1-21.8 69.5-53.3l41-152.3c.9-3.5 1.4-7 1.4-10.5c0-21.4-17.4-39.9-40-39.9l-411 0zM252 160c0-11 9-20 20-20l128 0c11 0 20 9 20 20s-9 20-20 20l-128 0c-11 0-20-9-20-20z", "M24 0C10.7 0 0 10.7 0 24S10.7 48 24 48l45.5 0c3.8 0 7.1 2.7 7.9 6.5l51.6 271c6.5 34 36.2 58.5 70.7 58.5L488 384c13.3 0 24-10.7 24-24s-10.7-24-24-24l-288.3 0c-11.5 0-21.4-8.2-23.6-19.5l-51.6-271C119.5 19.1 96.4 0 69.5 0L24 0zM176 512a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm336-48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM272 140c-11 0-20 9-20 20s9 20 20 20l128 0c11 0 20-9 20-20s-9-20-20-20l-128 0z"]]
}, faAddressBook = {
  prefix: "fad",
  iconName: "address-book",
  icon: [512, 512, [62138, "contact-book"], "f2b9", ["M32 64C32 28.7 60.7 0 96 0L384 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64L32 64zm96 304c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16c0-44.2-35.8-80-80-80l-64 0c-44.2 0-80 35.8-80 80zm48-176a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M496 64c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zm0 128c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zm16 144l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16zM128 368c0-44.2 35.8-80 80-80l64 0c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16l-192 0c-8.8 0-16-7.2-16-16zM240 128a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"]]
}, faContactBook = faAddressBook, faPanFrying = {
  prefix: "fad",
  iconName: "pan-frying",
  icon: [576, 512, [127859], "e42c", ["M176 224a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M427.6 317.6C440.7 289.1 448 257.4 448 224C448 100.3 347.7 0 224 0S0 100.3 0 224S100.3 448 224 448c53.3 0 102.3-18.6 140.8-49.7L472.7 498.5c11 8.8 24.1 13.5 39.3 13.5c35.3 0 64-28.7 64-64c0-20.9-9.3-38.8-24.7-50.5L427.6 317.6zM254.1 115.6c15.2 15.8 44.5 32.9 65.8 38.4c13.7 3.5 26.4 11.6 35.5 23.9c21 28.4 15.1 68.5-13.3 89.5c-8.9 6.6-18.9 10.5-29.2 12c-18.6 2.6-42.2 16.3-51.6 32.6c-22.1 38.3-71 51.4-109.3 29.3s-51.4-71-29.3-109.3c12.4-21.4 19.4-53 21.5-77.6c1.3-14.9 7.8-29.4 19.4-40.5c25.5-24.5 66-23.7 90.5 1.8zM512 432a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]]
}, faGrid = {
  prefix: "fad",
  iconName: "grid",
  icon: [448, 512, ["grid-3"], "e195", ["M0 232l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zM160 72l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zm0 320l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40zM320 232l0 48c0 22.1 17.9 40 40 40l48 0c22.1 0 40-17.9 40-40l0-48c0-22.1-17.9-40-40-40l-48 0c-22.1 0-40 17.9-40 40z", "M0 72C0 49.9 17.9 32 40 32l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40L0 72zM0 392c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48zM288 232l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40zM320 72c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48zM448 392l0 48c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40l0-48c0-22.1 17.9-40 40-40l48 0c22.1 0 40 17.9 40 40z"]]
}, faGrid3 = faGrid, faFootballHelmet = {
  prefix: "fad",
  iconName: "football-helmet",
  icon: [512, 512, [], "f44f", ["M272 320l49.7 0-13.2-70.6 31.8-4 14 74.5L464 320c26.5 0 48 21.5 48 48l0 32 0 50.4c0 25.2-20.4 45.6-45.6 45.6l-17 0c-54.9 0-102-39.1-112.1-93l-9.6-51L288 352c-5.3-10.7-10.7-21.3-16-32zm88.3 32l6 32L480 384l0-16c0-8.8-7.2-16-16-16l-103.7 0zm14.4 64c13.1 28.7 42 48 74.7 48l17 0c7.5 0 13.6-6.1 13.6-13.6l0-34.4-105.3 0z", "M462.5 230.2c17.5-2.2 30.2-18.3 25.7-35.3C461.1 91.9 367.4 16 256 16C123.5 16 16 123.5 16 256c0 56.3 19.4 108.1 51.9 149.1c5.7 7.1 14.4 10.9 23.5 10.9l14 0c4.3 0 8.6 .9 12.6 2.6l93.4 40c8.3 3.5 17.2 5.4 26.1 5.4l1.7 0c35.7 0 64.7-29 64.7-64.7c0-10-2.3-20-6.8-28.9L259 294c-2-4-3-8.4-3-12.8c0-14.4 10.7-26.6 25.1-28.4l181.4-22.7zM176 312a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faHandLove = {
  prefix: "fad",
  iconName: "hand-love",
  icon: [512, 512, [], "e1a5", ["M11 284.4c-15.2 16-14.6 41.3 1.4 56.6L124.8 448c43.1 41.1 100.4 64 160 64l19.2 0c97.2 0 176-78.8 176-176l0-240c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128 0 64c0 35.3-28.7 64-64 64c-19.1 0-36.3-8.4-48-21.7c-11.7 13.3-28.9 21.7-48 21.7c-35.3 0-64-28.7-64-64l0-96 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 304c0 1.5 0 3.1 .1 4.6L67.6 283c-16-15.2-41.3-14.6-56.6 1.4z", "M256 160c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32zm96 32c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7-14.3-32-32-32z"]]
}, faTrees = {
  prefix: "fad",
  iconName: "trees",
  icon: [640, 512, [], "f724", ["M0 392.5c0 13 10.5 23.5 23.5 23.5L160 416l0-200c0-17.7 14.3-32 32-32s32 14.3 32 32l0 200 136.5 0c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L304 288l24.5 0c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L272 160l25.1 0c12.7 0 22.9-10.3 22.9-22.9c0-5.8-2.2-11.4-6.2-15.7L205.5 5.8C202 2.1 197.1 0 192 0s-10 2.1-13.5 5.8L70.2 121.4c-4 4.3-6.2 9.9-6.2 15.7C64 149.7 74.3 160 86.9 160l25.1 0L37.4 249.5c-3.5 4.2-5.4 9.5-5.4 15c0 13 10.5 23.5 23.5 23.5L80 288 5.4 377.5C1.9 381.7 0 387 0 392.5zm330.7-212L371.1 229c8.3 10 12.9 22.5 12.9 35.5c0 17.8-8.4 33.6-21.4 43.8L403.1 357c8.2 9.8 12.7 22.2 12.9 35c0-58.7 0-117.3 0-176c0-17.7 14.3-32 32-32s32 14.3 32 32l0 200 136.5 0c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L560 288l24.5 0c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L528 160l25.1 0c12.7 0 22.9-10.3 22.9-22.9c0-5.8-2.2-11.4-6.2-15.7L461.5 5.8C458 2.1 453.1 0 448 0s-10 2.1-13.5 5.8l-92.9 99.1c6.7 9.3 10.4 20.5 10.4 32.1c0 17.7-8.3 33.4-21.3 43.4z", "M224 216c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 264c0 17.7 14.3 32 32 32s32-14.3 32-32l0-264zm256 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 264c0 17.7 14.3 32 32 32s32-14.3 32-32l0-264z"]]
}, faStrikethrough = {
  prefix: "fad",
  iconName: "strikethrough",
  icon: [512, 512, [], "f0cc", ["M96 416c0 13.4 8.5 25.9 21.9 30.4c3.6 1.2 7.9 2.7 12.7 4.3c24.9 8.5 63.6 21.7 87.6 25.6c15.5 2.4 30.7 3.7 45.5 3.7c28.3 0 55.2-4.6 78.4-14.6c36.5-15.6 64.4-44.8 71.8-87.3c3.6-21 2.7-40.4-3.1-58.1l-75.7 0c7 5.6 11.4 11.2 13.9 17.2c2.7 6.5 4.4 15.8 1.9 30.1c-3 17.6-13.8 30.8-33.9 39.4c-21.1 9-51.7 12.3-88.5 6.5c-18-2.9-49.1-13.5-74.4-22.1c-5.6-1.9-11-3.7-15.9-5.4c-16.8-5.6-34.9 3.5-40.5 20.3c-1.1 3.4-1.6 6.8-1.6 10.1zm2.1-282.1c-.1 .6-.2 1.1-.2 1.7c-2.8 23.9 .5 45.6 10.1 64.6c4.5 9 10.2 16.9 16.7 23.9l145.5 0-.4-.1-1.1-.3c-36-10.8-65.2-19.6-85.2-33.1c-9.3-6.3-15-12.6-18.2-19.1c-3.1-6.1-5.2-14.6-3.8-27.4c3.2-17.2 14-30.1 33.7-38.6c21.1-9 51.8-12.3 88.6-6.5c11.9 1.9 48.8 9.1 60.1 12c17.1 4.5 34.6-5.6 39.1-22.7s-5.6-34.6-22.7-39.2c-14.3-3.8-53.6-11.4-66.6-13.4c-15.3-2.4-30.5-3.6-45.3-3.6c-28.3 0-55.2 4.6-78.4 14.6c-36.5 15.6-64.4 44.8-71.8 87.3z", "M0 256c0-17.7 14.3-32 32-32l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32z"]]
}, faPage = {
  prefix: "fad",
  iconName: "page",
  icon: [384, 512, [], "e428", ["M64 512H320c35.3 0 64-28.7 64-64V138.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0H64C28.7 0 0 28.7 0 64V448c0 35.3 28.7 64 64 64z", ""]]
}, faK = {
  prefix: "fad",
  iconName: "k",
  icon: [320, 512, [107], "4b", ["M311 86.3c12.3-12.7 12-32.9-.7-45.2s-32.9-12-45.2 .7l-155.2 160L64 249 64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 328 0 448c0 17.7 14.3 32 32 32s32-14.3 32-32l0-107 64.7-66.7 133 192c10.1 14.5 30 18.1 44.5 8.1s18.1-30 8.1-44.5L174.1 227.4 311 86.3z", ""]]
}, faDiagramPrevious = {
  prefix: "fad",
  iconName: "diagram-previous",
  icon: [512, 512, [], "e478", ["M0 96l0 64c0 35.3 28.7 64 64 64l49 0c-5.5-18.4-2-39.6 14.1-55.6L216.4 79c21.9-21.9 57.3-21.9 79.2 0L385 168.4c16 16 19.6 37.2 14.1 55.6l49 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96z", "M448 288c35.3 0 64 28.7 64 64l0 64c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64l0-64c0-35.3 28.7-64 64-64l168 0 0-64-46.1 0c-21.4 0-32.1-25.9-17-41L239 113c9.4-9.4 24.6-9.4 33.9 0L343 183c15.1 15.1 4.4 41-17 41L280 224l0 64 168 0z"]]
}, faGaugeMin = {
  prefix: "fad",
  iconName: "gauge-min",
  icon: [512, 512, ["tachometer-alt-slowest"], "f628", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm64-8c0-4.3 1.2-8.7 3.6-12.6C72.1 228 80 224 88 224c4.3 0 8.7 1.2 12.6 3.6c39.2 24.3 78.4 48.5 117.6 72.8c10.6-7.8 23.7-12.4 37.8-12.4c35.3 0 64 28.7 64 64s-28.7 64-64 64s-64-28.7-64-64c0-3.7 .3-7.3 .9-10.8c-39.2-24.3-78.4-48.5-117.5-72.8C68 263.9 64 256 64 248zM176 144a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM288 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm112 48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48 112a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M100.6 227.6c-11.3-7-26.1-3.5-33 7.8s-3.5 26.1 7.8 33l117.5 72.8c-.6 3.5-.9 7.1-.9 10.8c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64c-14.1 0-27.2 4.6-37.8 12.4L100.6 227.6z"]]
}, faTachometerAltSlowest = faGaugeMin, faFolderGrid = {
  prefix: "fad",
  iconName: "folder-grid",
  icon: [512, 512, [], "e188", ["M0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L288 96c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32L64 32C28.7 32 0 60.7 0 96zM80 264c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48zm128 0c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48zm128 0c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48z", "M80 264c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48zm128 0c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48zm152-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"]]
}, faEggplant = {
  prefix: "fad",
  iconName: "eggplant",
  icon: [512, 512, [], "e16c", ["M0 332.7c0 1.1 0 2.2 0 3.3c1.4 95.3 79.8 175.9 176.4 176c145.7 .1 250.1-174.5 291.3-305.6C447.1 201 432 182.3 432 160c0-5.8-4-10.7-9.4-12.6c-13.3-4.8-25.4-13-35.1-22.8s-18-21.9-22.8-35.1c-2-5.4-6.9-9.4-12.6-9.4c-.7 0-1.3 0-1.9 0c-.6 0-1.3-.1-1.9-.1c-1.3-.1-2.5-.2-3.7-.4c-2.4-.4-4.8-1-7.1-1.7c-4.6-1.5-8.9-3.6-12.8-6.4c-7.8-5.5-13.9-13.2-17.3-22.2c-34.6 40.3-86.2 65.3-137.3 90.1C84.2 180.9 0 221.7 0 332.7z", "M505 41c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-9 9L320 16c-8.8 0-16 7.2-16 16c0 26.5 21.5 48 48 48c5.8 0 10.7 4 12.6 9.4c4.8 13.3 13 25.4 22.8 35.1s21.9 18 35.1 22.8c5.4 2 9.4 6.9 9.4 12.6c0 26.5 21.5 48 48 48c8.8 0 16-7.2 16-16l0-142.1 9-9z"]]
}, faExcavator = {
  prefix: "fad",
  iconName: "excavator",
  icon: [640, 512, [], "e656", ["M0 432c0-44.2 35.8-80 80-80l256 0c44.2 0 80 35.8 80 80s-35.8 80-80 80L80 512c-44.2 0-80-35.8-80-80zm64 0c0 8.8 7.2 16 16 16l256 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 416c-8.8 0-16 7.2-16 16zM416 160L562.7 13.3c8.5-8.5 20-13.3 32-13.3c25 0 45.3 20.3 45.3 45.3L640 320l0 64 0 48c0 44.2-35.8 80-80 80l-78.1 0c-18.7 0-33.9-15.2-33.9-33.9c0-9 3.6-17.6 9.9-24L576 336l0-208L416 288l0-128z", "M238.9 64l64 96L160 160l0-96 78.9 0zM384 208l0-17.5c0-15.8-4.7-31.2-13.4-44.4L292.1 28.5C280.3 10.7 260.3 0 238.9 0L144 0C117.5 0 96 21.5 96 48l0 112-48 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l288 0c26.5 0 48-21.5 48-48l0-48 0-16z"]]
}, faRam = {
  prefix: "fad",
  iconName: "ram",
  icon: [640, 512, [128015], "f70a", ["M0 256c0 24.5 13.7 45.7 33.9 56.5c-1.2 5-1.9 10.2-1.9 15.5c0 35.3 28.7 64 64 64c.5 0 1 0 1.5 0c2.8-.1 5.6-.3 8.3-.7c6.8 28 32.1 48.7 62.2 48.7c7.5 0 14.7-1.3 21.3-3.6c6.8-2.4 13-5.9 18.5-10.2C219.7 439.6 236.9 448 256 448c19.2 0 36.5-8.5 48.2-21.9C315.1 434.8 329 440 344 440c30.1 0 55.3-20.8 62.2-48.7c2.7 .4 5.5 .7 8.3 .7c.5 0 1 0 1.5 0c26.9 0 49.9-16.5 59.3-40L464 352c-61.9 0-112-50.1-112-112l0-32.6c-18.7-2.7-35.5-14.8-43.5-33.4c-8.9-20.8-4.3-44 10-59.7C312.3 85.6 286.7 64 256 64c-19.2 0-36.5 8.5-48.2 21.9C196.9 77.2 183 72 168 72c-30.1 0-55.3 20.8-62.2 48.8c-3.2-.5-6.5-.8-9.8-.8c-35.3 0-64 28.7-64 64c0 5.3 .7 10.5 1.9 15.5C13.7 210.3 0 231.5 0 256z", "M400 0c-35.3 0-64 28.7-64 64l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-8.8 7.2-16 16-16s16 7.2 16 16l0 24.4c-6.8 6.1-12.8 13.2-17.6 21l-47.8 20.5c-12.2 5.2-17.8 19.3-12.6 31.5s19.3 17.8 31.5 12.6l14.5-6.2 0 72.2c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80l0-72.2 14.5 6.2c12.2 5.2 26.3-.4 31.5-12.6s-.4-26.3-12.6-31.5l-47.8-20.5c-4.9-7.8-10.8-14.9-17.6-21L544 64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 1.3c-5.2-.9-10.5-1.3-16-1.3s-10.8 .5-16 1.3l0-1.3c0-35.3-28.7-64-64-64zm64 160a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm48 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM115.1 485.9c2.8 15.1 16.1 26.1 31.5 26.1l29.4 0c17.7 0 32-14.3 32-32l0-53.7-.2-.2C196.9 434.8 183 440 168 440c-30.1 0-55.3-20.8-62.2-48.7c-2.7 .4-5.5 .7-8.3 .7l17.6 93.9zM304 480c0 17.7 14.3 32 32 32l29.4 0c15.4 0 28.6-11 31.4-26.1L414.5 392c-2.8-.1-5.6-.3-8.3-.7c-6.8 28-32.1 48.7-62.2 48.7c-15 0-28.9-5.2-39.8-13.9l-.2 .2 0 53.7z"]]
}, faLandmarkFlag = {
  prefix: "fad",
  iconName: "landmark-flag",
  icon: [512, 512, [], "e51c", ["M0 480c0 3.1 .4 6.2 1.4 9.3C5.5 502.8 17.9 512 32 512l448 0c14.1 0 26.5-9.2 30.6-22.7c.9-3.1 1.4-6.2 1.4-9.3c0-10.5-5.2-20.6-14.2-26.6l-48-32c-.6-.4-1.2-.7-1.8-1.1L448 192l-64 0 0 224-40 0 0-224-64 0 0 224-48 0 0-224-64 0 0 224-40 0 0-224-64 0 0 228.3c-.6 .3-1.2 .7-1.7 1.1l-48 32C5.2 459.4 0 469.5 0 480z", "M272 0l80 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-80 0 0 32 192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L48 192c-17.7 0-32-14.3-32-32s14.3-32 32-32l192 0 0-112c0-8.8 7.2-16 16-16l16 0z"]]
}, faLips = {
  prefix: "fad",
  iconName: "lips",
  icon: [576, 512, [128068, 128482], "f600", ["M0 224l64 0c0 7.9 80 96 224 96s224-88.1 224-96l64 0c0 9.2-2.6 19.1-5.3 27.5c-3 9.1-7.4 19.4-12.8 30.3c-10.8 21.7-26.8 46.9-47.7 71.1C468.8 400.9 404.7 448 320 448l-64 0c-84.7 0-148.8-47.1-190.2-95.1C44.9 328.8 29 303.5 18.1 281.8C12.7 271 8.4 260.7 5.3 251.5C2.6 243.1 0 233.2 0 224z", "M297.7 94c-3.4 2.5-6.7 4.9-9.7 7.3c-3-2.4-6.2-4.8-9.7-7.3C260.6 81.2 231.5 64 200 64c-20.3 0-42.8 9.3-61.4 19.2c-20 10.6-41.1 24.7-60.2 39.5c-19.1 14.8-37.1 31.2-50.8 46.5c-6.8 7.6-13.1 15.7-17.9 23.7C5.5 200.2 0 211.2 0 224l64 0c0-7.7 46.3-31.1 138.8-32c3.4 0 6.9 .5 10.1 1.5c13.1 4 49.4 14.4 75.1 14.4s62-10.4 75.1-14.4c3.3-1 6.7-1.6 10.1-1.5c92.5 .9 138.8 24.2 138.8 32l64 0c0-12.8-5.5-23.8-9.7-31c-4.8-8.1-11.1-16.1-17.9-23.7c-13.6-15.3-31.7-31.7-50.8-46.5c-19.1-14.9-40.2-29-60.2-39.5C418.8 73.3 396.3 64 376 64c-31.5 0-60.6 17.2-78.3 30z"]]
}, faPencil = {
  prefix: "fad",
  iconName: "pencil",
  icon: [512, 512, [9999, 61504, "pencil-alt"], "f303", ["M144 319.4c0 4.1 1.6 8.2 4.7 11.3s7.2 4.7 11.3 4.7s8.2-1.6 11.3-4.7c48-48 96-96 144-144c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0c-48 48-96 96-144 144c-3.1 3.1-4.7 7.2-4.7 11.3zM302.7 78.7c43.3 43.3 86.6 86.6 129.9 129.9c20-20 40-40 60-60c12.5-12.5 18.7-28.9 18.7-45.3s-6.2-32.8-18.7-45.3L453.3 18.7c-25-25-65.5-25-90.5 0l-60 60z", "M432.7 208.7L302.7 78.7 58.6 322.9c-10.4 10.4-18 23.3-22.2 37.4L1 480.7c-2.5 8.4-.2 17.5 6.1 23.7s15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2L432.7 208.7zM89.3 360.5l22.7-9.1 0 32c0 8.8 7.2 16 16 16l32 0-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9L59.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3zm226-196.4c6.2 6.2 6.2 16.4 0 22.6l-144 144c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l144-144c6.2-6.2 16.4-6.2 22.6 0z"]]
}, faPencilAlt = faPencil, faBackward = {
  prefix: "fad",
  iconName: "backward",
  icon: [512, 512, [9194], "f04a", ["M256 241l0 30L459.5 440.6c9.5 7.9 22.8 9.7 34.1 4.4s18.4-16.6 18.4-29l0-320c0-12.4-7.2-23.7-18.4-29s-24.5-3.6-34.1 4.4L256 241z", "M203.5 440.6c9.5 7.9 22.8 9.7 34.1 4.4s18.4-16.6 18.4-29l0-320c0-12.4-7.2-23.7-18.4-29s-24.5-3.6-34.1 4.4l-192 160C4.2 237.5 0 246.5 0 256s4.2 18.5 11.5 24.6l192 160z"]]
}, faCaretRight = {
  prefix: "fad",
  iconName: "caret-right",
  icon: [256, 512, [], "f0da", ["M246.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 256c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l128-128z", ""]]
}, faComments = {
  prefix: "fad",
  iconName: "comments",
  icon: [640, 512, [128490, 61670], "f086", ["M231.5 383C348.9 372.9 448 288.3 448 176c0-5.2-.2-10.4-.6-15.5C555.1 167.1 640 243.2 640 336c0 38.6-14.7 74.3-39.6 103.4c3.5 9.4 8.7 17.7 14.2 24.7c4.8 6.2 9.7 11 13.3 14.3c1.8 1.6 3.3 2.9 4.3 3.7c.5 .4 .9 .7 1.3 1c5.6 4.1 7.9 11.3 5.8 17.9c-2.1 6.6-8.3 11.1-15.2 11.1c-21.8 0-43.8-5.6-62.1-12.5c-9.2-3.5-17.8-7.4-25.3-11.4C505.9 503.3 470.2 512 432 512c-95.6 0-176.2-54.6-200.5-129z", "M416 176c0 97.2-93.1 176-208 176c-38.2 0-73.9-8.7-104.7-23.9c-7.5 4-16 7.9-25.2 11.4C59.8 346.4 37.8 352 16 352c-6.9 0-13.1-4.5-15.2-11.1s.2-13.8 5.8-17.9c0 0 0 0 0 0s0 0 0 0l.2-.2c.2-.2 .6-.4 1.1-.8c1-.8 2.5-2 4.3-3.7c3.6-3.3 8.5-8.1 13.3-14.3c5.5-7 10.7-15.4 14.2-24.7C14.7 250.3 0 214.6 0 176C0 78.8 93.1 0 208 0S416 78.8 416 176z"]]
}, faPaste = {
  prefix: "fad",
  iconName: "paste",
  icon: [512, 512, ["file-clipboard"], "f0ea", ["M224 176c0-26.5 21.5-48 48-48l124.1 0c12.7 0 24.9 5.1 33.9 14.1l67.9 67.9c9 9 14.1 21.2 14.1 33.9L512 464c0 26.5-21.5 48-48 48l-192 0c-26.5 0-48-21.5-48-48l0-288z", "M160 0c-23.7 0-44.4 12.9-55.4 32L48 32C21.5 32 0 53.5 0 80L0 400c0 26.5 21.5 48 48 48l144 0 0-272c0-44.2 35.8-80 80-80l48 0 0-16c0-26.5-21.5-48-48-48l-56.6 0C204.4 12.9 183.7 0 160 0zm0 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faFileClipboard = faPaste, faDesktopArrowDown = {
  prefix: "fad",
  iconName: "desktop-arrow-down",
  icon: [576, 512, [], "e155", ["M0 64L0 352c0 35.3 28.7 64 64 64l176 0 96 0 176 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L312 0l0 64 200 0 0 224L64 288 64 64l200 0 0-64L64 0C28.7 0 0 28.7 0 64z", "M264 64L64 64l0 224 448 0 0-224L312 64l0 110.1 39-39c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0l-80-80c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l39 39L264 64zm82.7 384L336 416l-96 0-10.7 32L160 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-69.3 0z"]]
}, faCodePullRequest = {
  prefix: "fad",
  iconName: "code-pull-request",
  icon: [512, 512, [], "e13c", ["M48 153.3l0 205.3c9.8-4.3 20.6-6.7 32-6.7c1.4 0 2.8 0 4.2 .1s2.8 .2 4.2 .3c2.8 .3 5.5 .7 8.2 1.3c5.4 1.1 10.5 2.8 15.4 4.9l0-205.3c-9.8 4.3-20.6 6.7-32 6.7c-1.4 0-2.8 0-4.2-.1s-2.8-.2-4.2-.3c-2.8-.3-5.5-.7-8.2-1.3c-5.4-1.1-10.5-2.8-15.4-4.9zM192 96c0 6.8 2.9 13.3 7.9 17.8l80 72c7 6.3 17.2 7.9 25.8 4.1s14.2-12.4 14.2-21.9l0-40 16 0c35.3 0 64 28.7 64 64l0 166.7c9.8-4.3 20.6-6.7 32-6.7c1.4 0 2.8 0 4.2 .1s2.8 .2 4.2 .3c2.8 .3 5.5 .7 8.2 1.3c5.4 1.1 10.5 2.8 15.4 4.9L464 192c0-70.7-57.3-128-128-128l-16 0 0-40c0-9.5-5.6-18.1-14.2-21.9C302.6 .7 299.3 0 296 0c-5.8 0-11.6 2.1-16.1 6.2l-80 72c-5.1 4.6-7.9 11-7.9 17.8z", "M80 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104A80 80 0 1 0 80 0a80 80 0 1 0 0 160zm0 248a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm328-80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]]
}, faPumpkin = {
  prefix: "fad",
  iconName: "pumpkin",
  icon: [576, 512, [], "f707", ["M0 320C0 426 68.1 512 152 512c19.3 0 37.8-4.5 54.7-12.8c8.3-4.1 18.2-4.1 26.5 0c17 8.3 35.4 12.8 54.7 12.8s37.8-4.5 54.7-12.8c8.3-4.1 18.2-4.1 26.5 0c17 8.3 35.4 12.8 54.7 12.8c83.9 0 152-86 152-192s-68.1-192-152-192c-8.9 0-17.6 1-26 2.8c-.6 .1-1.2 .2-1.8 .3c12.1 8.8 23.1 19.1 32.7 30.5c5.6 6.7-2.9 14.6-10.4 10.1C380.3 149 335.7 136 288 136s-92.3 13-130.5 35.7c-7.5 4.5-16-3.4-10.4-10.1c9.6-11.4 20.6-21.7 32.7-30.5c-.6-.1-1.2-.2-1.8-.3c-8.5-1.8-17.2-2.8-26-2.8C68.1 128 0 214 0 320z", "M234.6 103.9l40.9-93.5c2.8-6.3 9-10.4 15.8-10.4l1.2 0c2.3 0 4.7 .5 6.8 1.4l42.3 18.1c6.4 2.7 10.5 9 10.5 15.9l0 72C332.1 100 310.5 96 288 96c-18.6 0-36.5 2.8-53.5 7.9z"]]
}, faClipboardList = {
  prefix: "fad",
  iconName: "clipboard-list",
  icon: [384, 512, [], "f46d", ["M0 128L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l-49.6 0c.2 .8 .3 1.6 .4 2.3C290.1 72.6 304 90.7 304 112l0 24c0 13.3-10.7 24-24 24l-88 0-88 0c-13.3 0-24-10.7-24-24l0-24c0-21.3 13.9-39.4 33.2-45.7c.1-.8 .3-1.6 .4-2.3L64 64C28.7 64 0 92.7 0 128zM120 272a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm40-96c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16z", "M113.2 66.3C119.6 28.7 152.5 0 192 0s72.4 28.7 78.8 66.3C290.1 72.6 304 90.7 304 112l0 24c0 13.3-10.7 24-24 24l-88 0-88 0c-13.3 0-24-10.7-24-24l0-24c0-21.3 13.9-39.4 33.2-45.7zM216 80a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM72 272a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm0 96a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]]
}, faPenField = {
  prefix: "fad",
  iconName: "pen-field",
  icon: [640, 512, [], "e211", ["M0 208c0-44.2 35.8-80 80-80l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 192c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16l416 0c8.8 0 16-7.2 16-16l0-128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 128c0 44.2-35.8 80-80 80L80 512c-44.2 0-80-35.8-80-80L0 208z", "M534.1 16L494.4 55.7l89.3 89.3 39.8-38.9c19.1-18.7 19.2-49.4 .4-68.2L601.9 16c-18.8-18.8-49.2-18.7-67.9 0zM471.7 78.4L328.5 221.8c-7 7-12.3 15.6-15.4 25l-23.8 71.3c-2.9 8.6-.6 18.1 5.8 24.6s15.9 8.7 24.6 5.8l71.5-23.9c9.2-3.1 17.6-8.2 24.5-15L560.8 167.5 471.7 78.4zM160 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faChartSine = {
  prefix: "fad",
  iconName: "chart-sine",
  icon: [512, 512, [], "e69d", ["M0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64c0-17.7-14.3-32-32-32S0 46.3 0 64z", "M159.6 229.3c-2.9 17.4-19.4 29.2-36.8 26.3s-29.2-19.4-26.3-36.8l0 0c1-6.2 2.6-12.2 4.2-18.3c2.9-10.3 7.5-24.3 14.7-38.7C128.9 134.6 157.1 96 208 96c38.2 0 63.6 19.5 80 44.4c14.4 21.9 23 49.6 29.9 72l.7 2.2c7.8 25.3 14 44.4 22.9 57.9c7.3 11.1 14.4 15.6 26.6 15.6c13.1 0 24.9-9.4 35.4-30.3c4.8-9.6 8.1-19.5 10.3-27.3c2.1-7.7 2.8-11.7 2.8-11.7c2.9-17.4 19.4-29.2 36.8-26.3s29.2 19.4 26.3 36.8c-1 6.2-2.6 12.3-4.2 18.3c-2.9 10.3-7.5 24.3-14.7 38.7c-13.5 27-41.7 65.7-92.6 65.7c-38.2 0-63.6-19.5-80-44.4c-14.4-21.9-23-49.6-29.9-72l-.7-2.2c-7.8-25.3-14-44.4-22.9-57.9C227.3 164.5 220.1 160 208 160c-13.1 0-24.9 9.4-35.4 30.3c-4.8 9.6-8.1 19.5-10.3 27.3c-1.1 3.9-2 7.8-2.8 11.8l0 0z"]]
}, faBlueberries = {
  prefix: "fad",
  iconName: "blueberries",
  icon: [512, 512, [], "e2e8", ["M112 272c0 8.8 7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-32 0c-8.8 0-16 7.2-16 16zm48.7-111.3c5.1-.4 10.2-.7 15.3-.7c97.2 0 176 78.8 176 176c0 1.3 0 2.6 0 3.9s-.1 2.6-.1 3.8c-.1 2.6-.3 5.1-.5 7.6C441.4 343.6 512 268 512 176C512 78.8 433.2 0 336 0C244 0 168.4 70.6 160.7 160.7zM304 112c0-8.8 7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16z", "M384 64l0 32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0 0-32c0-8.8 7.2-16 16-16s16 7.2 16 16zM0 336a176 176 0 1 1 352 0A176 176 0 1 1 0 336zM176 208c-8.8 0-16 7.2-16 16l0 32-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-32c0-8.8-7.2-16-16-16z"]]
}, faTruckRampBox = {
  prefix: "fad",
  iconName: "truck-ramp-box",
  icon: [640, 512, ["truck-loading"], "f4de", ["M23.1 207.7L64.5 362.3c4.6 17.1 22.1 27.2 39.2 22.6l154.5-41.4c17.1-4.6 27.2-22.1 22.6-39.2L239.5 149.7c-4.6-17.1-22.1-27.2-39.2-22.6l-46.4 12.4c6.9 25.8 13.8 51.5 20.7 77.3c2.3 8.5-2.8 17.3-11.3 19.6c-10.3 2.8-20.6 5.5-30.9 8.3c-8.5 2.3-17.3-2.8-19.6-11.3L92.1 156.1c-15.5 4.1-30.9 8.3-46.4 12.4c-17.1 4.6-27.2 22.1-22.6 39.2zM448 416a96 96 0 1 0 192 0 96 96 0 1 0 -192 0z", "M544 288c-66.1 0-120.6 50.2-127.3 114.5L48.4 502.9c-17.1 4.6-34.6-5.4-39.3-22.5s5.4-34.6 22.5-39.3L352 353.8V64c0-35.3 28.7-64 64-64H640V331.3c-23.5-26.6-57.8-43.3-96-43.3zM153.9 139.5L92.1 156.1l20.7 77.3c2.3 8.5 11.1 13.6 19.6 11.3l30.9-8.3c8.5-2.3 13.6-11.1 11.3-19.6l-20.7-77.3z"]]
}, faTruckLoading = faTruckRampBox, faNote = {
  prefix: "fad",
  iconName: "note",
  icon: [448, 512, [], "e1ff", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 224-128 0c-17.7 0-32 14.3-32 32l0 128L64 480c-35.3 0-64-28.7-64-64L0 96zm64 32a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 128a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 128a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M288 352V480h5.5c17 0 33.3-6.7 45.3-18.7l90.5-90.5c12-12 18.7-28.3 18.7-45.3V320H320c-17.7 0-32 14.3-32 32z"]]
}, faArrowDownToSquare = {
  prefix: "fad",
  iconName: "arrow-down-to-square",
  icon: [512, 512, [], "e096", ["M0 112C0 67.8 35.8 32 80 32l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 96c-8.8 0-16 7.2-16 16l0 320c0 8.8 7.2 16 16 16l352 0c8.8 0 16-7.2 16-16l0-320c0-8.8-7.2-16-16-16l-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0c44.2 0 80 35.8 80 80l0 320c0 44.2-35.8 80-80 80L80 512c-44.2 0-80-35.8-80-80L0 112z", "M233.4 342.6c12.5 12.5 32.8 12.5 45.3 0l96-96c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L288 242.7 288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 210.7-41.4-41.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l96 96z"]]
}, faUserCheck = {
  prefix: "fad",
  iconName: "user-check",
  icon: [640, 512, [], "f4fc", ["M0 482.3C0 498.7 13.3 512 29.7 512l388.6 0c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304l-91.4 0C79.8 304 0 383.8 0 482.3zM96 128a128 128 0 1 0 256 0A128 128 0 1 0 96 128z", "M625 143c9.4 9.4 9.4 24.6 0 33.9L497 305c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L591 143c9.4-9.4 24.6-9.4 33.9 0z"]]
}, faCloudXmark = {
  prefix: "fad",
  iconName: "cloud-xmark",
  icon: [640, 512, [], "e35f", ["M0 336c0 79.5 64.5 144 144 144l368 0c70.7 0 128-57.3 128-128c0-61.9-44-113.6-102.4-125.4c4.1-10.7 6.4-22.4 6.4-34.6c0-53-43-96-96-96c-19.7 0-38.1 6-53.3 16.2C367 64.2 315.3 32 256 32C167.6 32 96 103.6 96 192c0 2.7 .1 5.4 .2 8.1C40.2 219.8 0 273.2 0 336zm232 16c0-6.1 2.3-12.3 7-17c15.7-15.7 31.4-31.4 47-47l-47-47c-9.4-9.4-9.4-24.6 0-33.9c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7l47 47 47-47c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7s7 10.8 7 17s-2.3 12.3-7 17l-47 47 47 47c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17s-10.8 7-17 7s-12.3-2.3-17-7c-15.7-15.7-31.3-31.3-47-47c-15.7 15.7-31.4 31.3-47 47c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7s-7-10.8-7-17z", "M273 207c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]]
}, faVialVirus = {
  prefix: "fad",
  iconName: "vial-virus",
  icon: [512, 512, [], "e597", ["M0 64C0 46.3 14.3 32 32 32l64 0 64 0 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 111.1c-3.1 2.1-6.1 4.4-8.8 7.2c-21.9 21.9-21.9 57.3 0 79.2c.2 .2 .2 .3 .3 .4c0 .1 0 .3-.1 .6s-.2 .4-.4 .5c-.1 0-.2 0-.4 0c-30.9 0-56 25.1-56 56s25.1 56 56 56c.2 0 .4 0 .5 0c.1 .1 .2 .2 .3 .5s.1 .5 .1 .6c0 .1-.1 .2-.3 .3c-11.2 11.2-16.6 25.9-16.4 40.5C181.3 468 156 480 128 480c-53 0-96-43-96-96L32 96C14.3 96 0 81.7 0 64zM96 96l0 96 64 0 0-96L96 96z", "M376 216c0-13.3-10.7-24-24-24s-24 10.7-24 24c0 28.8-34.9 43.3-55.2 22.9c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9c20.4 20.4 5.9 55.2-22.9 55.2c-13.3 0-24 10.7-24 24s10.7 24 24 24c28.8 0 43.3 34.9 22.9 55.3c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0c20.4-20.4 55.2-6 55.2 22.8c0 13.3 10.7 24 24 24s24-10.7 24-24c0-28.8 34.8-43.2 55.2-22.8c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9c-20.4-20.4-5.9-55.3 22.9-55.3c13.3 0 24-10.7 24-24s-10.7-24-24-24c-28.8 0-43.2-34.8-22.9-55.2c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0C410.9 259.3 376 244.8 376 216zM288.8 321.4a31.7 31.7 0 1 1 63.5 0 31.7 31.7 0 1 1 -63.5 0zm95.2 39.6a23.8 23.8 0 1 1 0 47.6 23.8 23.8 0 1 1 0-47.6z"]]
}, faBookBlank = {
  prefix: "fad",
  iconName: "book-blank",
  icon: [448, 512, [128213, 128215, 128216, 128217, "book-alt"], "f5d9", ["M64 416c0-17.7 14.3-32 32-32l160 0 96 0 64 0 0 64-64 0-96 0L96 448c-17.7 0-32-14.3-32-32z", "M0 96C0 43 43 0 96 0L384 0l32 0c17.7 0 32 14.3 32 32l0 320c0 17.7-14.3 32-32 32l-64 0-96 0L96 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0 96 0 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0L96 512c-53 0-96-43-96-96L0 96z"]]
}, faBookAlt = faBookBlank, faGolfFlagHole = {
  prefix: "fad",
  iconName: "golf-flag-hole",
  icon: [512, 512, [], "e3ac", ["M0 416c0 53 114.6 96 256 96s256-43 256-96s-114.6-96-256-96c-27.9 0-54.8 1.7-80 4.8l0 70.1c11.7-6.6 28.9-10.8 48-10.8c35.3 0 64 14.3 64 32s-28.7 32-64 32c-23.1 0-43.4-6.1-54.6-15.3c-4.4 4.5-10.6 7.3-17.4 7.3c-13.3 0-24-10.7-24-24l0-83.2C51.5 349.4 0 380.5 0 416z", "M139.4 3.6c7.1-4.4 15.9-4.8 23.4-1.1l208 104c8.1 4.1 13.3 12.4 13.3 21.5s-5.1 17.4-13.3 21.5L176 246.8 176 416c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-176c0-1.4 .1-2.7 .3-4c-.2-1.3-.3-2.6-.3-4l0-208c0-8.3 4.3-16 11.4-20.4z"]]
}, faMessageArrowDown = {
  prefix: "fad",
  iconName: "message-arrow-down",
  icon: [512, 512, ["comment-alt-arrow-down"], "e1db", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM160 224c0 6.1 2.3 12.3 7 17l72 72c4.7 4.7 10.8 7 17 7s12.3-2.3 17-7l72-72c4.7-4.7 7-10.8 7-17s-2.3-12.3-7-17c-9.4-9.4-24.6-9.4-33.9 0l-31 31L280 120c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 118.1-31-31c-9.4-9.4-24.6-9.4-33.9 0c-4.7 4.7-7 10.8-7 17z", "M256 96c13.3 0 24 10.7 24 24l0 118.1 31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31L232 120c0-13.3 10.7-24 24-24z"]]
}, faCommentAltArrowDown = faMessageArrowDown, faFaceUnamused = {
  prefix: "fad",
  iconName: "face-unamused",
  icon: [512, 512, [], "e39f", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm96-48c0-8.8 7.2-16 16-16l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32l-32 0c-8.8 0-16-7.2-16-16zm76.1 165.3C188.2 355.4 216.3 336 256 336s67.8 19.4 83.9 37.3c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6zM288 208c0-8.8 7.2-16 16-16l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32l-32 0c-8.8 0-16-7.2-16-16z", "M96 208c0-8.8 7.2-16 16-16l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32l-32 0c-8.8 0-16-7.2-16-16zm192 0c0-8.8 7.2-16 16-16l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32s-32-14.3-32-32l-32 0c-8.8 0-16-7.2-16-16z"]]
}, faSheetPlastic = {
  prefix: "fad",
  iconName: "sheet-plastic",
  icon: [384, 512, [], "e571", ["M0 64L0 448c0 35.3 28.7 64 64 64l160 0 0-128c0-17.7 14.3-32 32-32l128 0 0-288c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zm52.7 84.7l96-96c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-96 96c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6zm32 96l160-160c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-160 160c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z", "M224 512L384 352H256c-17.7 0-32 14.3-32 32V512z"]]
}, faCircle9 = {
  prefix: "fad",
  iconName: "circle-9",
  icon: [512, 512, [], "e0f6", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm160-32c0-53 43-96 96-96s96 43 96 96c0 32.4-14.2 63.2-38.8 84.3l-81.6 70c-4.5 3.9-10.1 5.8-15.6 5.8c-6.8 0-13.5-2.8-18.2-8.4c-8.6-10.1-7.5-25.2 2.6-33.8L230 316.4c-40.4-11.4-70-48.4-70-92.4zm48 0a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M304 224a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-74 92.4l-29.6 25.4c-10.1 8.6-11.2 23.8-2.6 33.8s23.8 11.2 33.8 2.6l81.6-70C337.8 287.2 352 256.4 352 224c0-53-43-96-96-96s-96 43-96 96c0 44 29.6 81.1 70 92.4z"]]
}, faBlog = {
  prefix: "fad",
  iconName: "blog",
  icon: [512, 512, [], "f781", ["M192 32c0 17.7 14.3 32 32 32c123.7 0 224 100.3 224 224c0 17.7 14.3 32 32 32s32-14.3 32-32C512 128.9 383.1 0 224 0c-17.7 0-32 14.3-32 32zm0 96c0 17.7 14.3 32 32 32c70.7 0 128 57.3 128 128c0 17.7 14.3 32 32 32s32-14.3 32-32c0-106-86-192-192-192c-17.7 0-32 14.3-32 32z", "M48 96c26.5 0 48 21.5 48 48l0 224c0 26.5 21.5 48 48 48s48-21.5 48-48s-21.5-48-48-48l-16 0 0-96 16 0c79.5 0 144 64.5 144 144s-64.5 144-144 144S0 447.5 0 368L0 144c0-26.5 21.5-48 48-48z"]]
}, faUserNinja = {
  prefix: "fad",
  iconName: "user-ninja",
  icon: [448, 512, [129399], "f504", ["M144 112c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16z", "M224 256c-57.2 0-105.6-37.5-122-89.3c-1.1 1.3-2.2 2.6-3.5 3.8c-15.8 15.8-38.8 20.7-53.6 22.1c-8.1 .8-14.6-5.7-13.8-13.8c1.4-14.7 6.3-37.8 22.1-53.6c5.8-5.8 12.6-10.1 19.6-13.4c-7-3.2-13.8-7.6-19.6-13.4C37.4 82.7 32.6 59.7 31.1 44.9c-.8-8.1 5.7-14.6 13.8-13.8c14.7 1.4 37.8 6.3 53.6 22.1c4.8 4.8 8.7 10.4 11.7 16.1C131.4 28.2 174.4 0 224 0c70.7 0 128 57.3 128 128s-57.3 128-128 128zM0 482.3C0 399.5 56.4 330 132.8 309.9c6-1.6 12.2 .9 15.9 5.8l62.5 83.3c6.4 8.5 19.2 8.5 25.6 0l62.5-83.3c3.7-4.9 9.9-7.4 15.9-5.8C391.6 330 448 399.5 448 482.3c0 16.4-13.3 29.7-29.7 29.7L29.7 512C13.3 512 0 498.7 0 482.3zM160 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L160 96z"]]
}, faPencilSlash = {
  prefix: "fad",
  iconName: "pencil-slash",
  icon: [640, 512, [], "e215", ["M64 487.4c0 6.3 2.5 12.4 7 17c6.2 6.2 15.3 8.5 23.7 6.1l120.3-35.4c14.1-4.2 27-11.8 37.4-22.2l88.3-88.3-77.9-61.4-27.6 27.6c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l24.9-24.9L195.5 250l-72.9 72.9c-10.4 10.4-18 23.3-22.2 37.4L65 480.7c-.7 2.2-1 4.5-1 6.8zM123.4 452l23-78.1c1.4-4.9 3.8-9.4 6.9-13.3l22.7-9.1 0 32c0 8.8 7.2 16 16 16l32 0-9.1 22.7c-4 3.1-8.5 5.4-13.3 6.9l-78.1 23zM263.9 181.6c14.1 11 28.1 22.1 42.2 33.1l50.5-50.5c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-47.8 47.8c26 20.4 52.1 40.8 78.1 61.2l42.1-42.1L474.3 231l11.3-11.3-33.9-33.9-62.1-62.1L355.7 89.8l-11.3 11.3-22.6 22.6-57.8 57.8zM378.3 67.1l33.9 33.9 62.1 62.1 33.9 33.9 11.3-11.3 22.6-22.6 14.5-14.5c25-25 25-65.5 0-90.5L517.3 18.7C504.8 6.2 488.4 0 472 0s-32.8 6.2-45.3 18.7L412.3 33.2 389.7 55.8 378.3 67.1z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faBowlingPins = {
  prefix: "fad",
  iconName: "bowling-pins",
  icon: [512, 512, [], "f437", ["M32 379.5c0 28.9 6.7 57.5 19.7 83.4l15.7 31.4C72.8 505.2 83.9 512 96 512l64 0c12.1 0 23.2-6.8 28.6-17.7l15.7-31.4C217.3 437 224 408.5 224 379.5c0-22-3.9-43.8-11.5-64.4L173.9 210.4c-2.2-6-3.8-12.1-4.8-18.4l-82.3 0c-1 6.3-2.6 12.4-4.8 18.4L43.5 315.1C35.9 335.7 32 357.5 32 379.5zM64 64l0 1.1c0 7.4 1 14.8 2.9 22l17.7 64.8c.7 2.7 1.3 5.4 1.8 8.1l83.1 0c.5-2.7 1.1-5.4 1.8-8.1l17.7-64.8c2-7.2 2.9-14.6 2.9-22l0-1.1c0-35.3-28.7-64-64-64S64 28.7 64 64zM288 375.1c0 20.5 3.9 40.9 11.5 59.9l22.7 56.9C327.1 504 338.9 512 352 512l64 0c13.1 0 24.9-8 29.7-20.1L468.5 435c7.6-19.1 11.5-39.4 11.5-59.9c0-19-3.4-37.9-10-55.8L429.9 210.4c-2.2-6-3.8-12.1-4.8-18.4l-82.3 0c-1 6.3-2.6 12.4-4.8 18.4L298 319.3c-6.6 17.9-10 36.8-10 55.8zM320 64l0 1.1c0 7.4 1 14.8 2.9 22l17.7 64.8c.7 2.7 1.3 5.4 1.8 8.1l83.1 0c.5-2.7 1.1-5.4 1.8-8.1l17.7-64.8c2-7.2 2.9-14.6 2.9-22l0-1.1c0-35.3-28.7-64-64-64s-64 28.7-64 64z", "M86.8 192c.8-4.9 1.2-9.9 1.2-14.8c0-5.8-.5-11.5-1.5-17.2l83.1 0c-1 5.7-1.5 11.4-1.5 17.2c0 5 .4 9.9 1.2 14.8l-82.3 0zm256 0c.8-4.9 1.2-9.9 1.2-14.8c0-5.8-.5-11.5-1.5-17.2l83.1 0c-1 5.7-1.5 11.4-1.5 17.2c0 5 .4 9.9 1.2 14.8l-82.3 0z"]]
}, faPersonArrowUpFromLine = {
  prefix: "fad",
  iconName: "person-arrow-up-from-line",
  icon: [640, 512, [], "e539", ["M32 288c0 10.9 5.5 21.5 15.5 27.5c15.1 9.1 34.8 4.2 43.9-10.9L120 256.9 120 448l64 0 0-96 16 0 0 96 64 0 0-191.1 28.6 47.5c9.1 15.1 28.8 20 43.9 10.9c10-6 15.5-16.6 15.5-27.5c0-5.6-1.5-11.3-4.6-16.5l-58.3-97c-17.4-28.9-48.6-46.6-82.3-46.6l-29.7 0c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97C33.5 276.7 32 282.4 32 288zM144 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M598.6 166.6c12.5-12.5 12.5-32.8 0-45.3l-80-80c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L464 141.3 464 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-242.7 25.4 25.4c12.5 12.5 32.8 12.5 45.3 0zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l576 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448z"]]
}, faDownRight = {
  prefix: "fad",
  iconName: "down-right",
  icon: [384, 512, [], "e16b", ["M0 144c0 10.2 4.1 20.1 11.3 27.3L145.4 305.4l96-96L107.3 75.3C100.1 68.1 90.2 64 80 64s-20.1 4.1-27.3 11.3L11.3 116.7C4.1 123.9 0 133.8 0 144z", "M336 432H96c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9l240-240c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6V400c0 17.7-14.3 32-32 32z"]]
}, faScrollTorah = {
  prefix: "fad",
  iconName: "scroll-torah",
  icon: [640, 512, ["torah"], "f6a0", ["M96 32l0 448 448 0 0-448L96 32zM196 198.3c0-10.1 8.2-18.3 18.3-18.3l56.7 0 31.4-53.9c3.6-6.3 10.3-10.1 17.6-10.1s13.9 3.8 17.6 10.1L369 180l56.7 0c10.1 0 18.3 8.2 18.3 18.3c0 3.2-.9 6.4-2.5 9.2L413.3 256l28.3 48.5c1.6 2.8 2.5 6 2.5 9.2c0 10.1-8.2 18.3-18.3 18.3L369 332l-31.4 53.9c-3.6 6.3-10.3 10.1-17.6 10.1s-13.9-3.8-17.6-10.1L271 332l-56.7 0c-10.1 0-18.3-8.2-18.3-18.3c0-3.2 .9-6.4 2.5-9.2L226.7 256l-28.3-48.5c-1.6-2.8-2.5-6-2.5-9.2zm28.2 5.7l16.4 28.2L257 204l-32.8 0zm0 104l32.8 0-16.4-28.2L224.2 308zm30.3-52l30.3 52 70.4 0 30.3-52-30.3-52-70.4 0-30.3 52zm44.3-76l42.4 0L320 143.6 298.8 180zm0 152L320 368.4 341.2 332l-42.4 0zM383 204l16.4 28.2L415.8 204 383 204zm0 104l32.8 0-16.4-28.2L383 308z", "M96 480L96 32C96 14.3 74.5 0 48 0S0 14.3 0 32L0 480c0 17.7 21.5 32 48 32s48-14.3 48-32zm544 0l0-448c0-17.7-21.5-32-48-32s-48 14.3-48 32l0 448c0 17.7 21.5 32 48 32s48-14.3 48-32z"]]
}, faTorah = faScrollTorah, faWebhook = {
  prefix: "fad",
  iconName: "webhook",
  icon: [576, 512, [], "e5d5", ["M0 383.9c0-51.3 31-98.2 78.8-118c12.2-5.1 26.3 .7 31.4 12.9s-.7 26.3-12.9 31.4c-35.4 14.7-56 53.3-47.1 91.8c9.9 43 52.9 69.9 95.9 60c37-8.5 62.1-41.5 62-77.9c0-6.4 2.5-12.5 7-17s10.6-7 17-7l174.4 0c-2 3.5-3.6 7.3-4.7 11.4c-.5 2-1 4.1-1.2 6.2c-.1 1.1-.2 2.1-.3 3.2s-.1 2.2-.1 3.3c0 8.7 2.3 16.9 6.4 24l-152.7 0c-9.2 48.3-46 89-97 100.7c-9.7 2.2-19.4 3.3-28.9 3.3C69.6 512 16.9 472 3.3 412.8C1 403.1 0 393.4 0 383.9zM129.7 336L201 221.9c-32.5-30.2-48.4-76.4-37.7-122.7C179.2 30.3 247.9-12.6 316.8 3.3c65.9 15.2 108 78.7 97.7 144.4c-2.1 13.1-14.3 22-27.4 20s-22-14.3-20-27.4c6.4-41.1-19.9-80.7-61.1-90.2c-43.1-9.9-86 16.9-95.9 60c-7.9 34.1 7.4 68.2 35.5 85.9c5.4 3.4 9.2 8.8 10.7 15s.3 12.7-3 18.1L170.4 361.5c-7.8-14.7-23.1-24.8-40.7-25.4zM289.7 176c17.7-.6 32.9-10.7 40.7-25.4l71.3 114.1c45.8-17.7 99.8-8.2 136.8 28.9c50 50 50 131 0 181c-43 43-109 49-158.4 18c-11.2-7-14.6-21.8-7.6-33.1s21.8-14.6 33.1-7.6c30.9 19.3 72.1 15.5 99-11.3c31.2-31.2 31.2-81.9 0-113.1c-26.8-26.8-68.1-30.6-99-11.3c-5.4 3.4-11.9 4.5-18.1 3s-11.6-5.3-15-10.7L289.7 176z", "M288 176a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM176 384a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm320 0a48 48 0 1 0 -96 0 48 48 0 1 0 96 0z"]]
}, faBlindsOpen = {
  prefix: "fad",
  iconName: "blinds-open",
  icon: [512, 512, [], "f8fc", ["M0 174.2C0 184 8 192 17.8 192L128 192l0-64-80.6 0c-9.7 0-18.9 4.4-25 12L3.9 163.1C1.4 166.3 0 170.2 0 174.2zm0 160C0 344 8 352 17.8 352L144 352c-26.5 0-48-21.5-48-48c0-.7 0-1.4 0-2.1s.1-1.4 .1-2.1c.1-1.4 .3-2.7 .5-4.1c.5-2.7 1.1-5.3 2-7.8l-51.4 0c-9.7 0-18.9 4.4-25 12L3.9 323.1C1.4 326.3 0 330.2 0 334.2zm0 160C0 504 8 512 17.8 512l476.5 0c9.8 0 17.8-8 17.8-17.8c0-4-1.4-7.9-3.9-11.1L489.6 460c-6.1-7.6-15.3-12-25-12L47.4 448c-9.7 0-18.9 4.4-25 12L3.9 483.1C1.4 486.3 0 490.2 0 494.2zM144 352l350.2 0c9.8 0 17.8-8 17.8-17.8c0-4-1.4-7.9-3.9-11.1L489.6 300c-6.1-7.6-15.3-12-25-12l-275.4 0c1.8 5 2.7 10.4 2.7 16c0 26.5-21.5 48-48 48zm16-224l0 64 334.2 0c9.8 0 17.8-8 17.8-17.8c0-4-1.4-7.9-3.9-11.1L489.6 140c-6.1-7.6-15.3-12-25-12L160 128z", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l96 0 0 194.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3L160 64l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 0z"]]
}, faFence = {
  prefix: "fad",
  iconName: "fence",
  icon: [512, 512, [], "e303", ["M128 160l0 64 64 0 0-64-64 0zm0 192l0 64 64 0 0-64-64 0zM320 160l0 64 64 0 0-64-64 0zm0 192l0 64 64 0 0-64-64 0z", "M76.8 38.4C73.8 34.4 69 32 64 32s-9.8 2.4-12.8 6.4L6.4 98.1C2.2 103.7 0 110.4 0 117.3L0 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-330.7c0-6.9-2.2-13.7-6.4-19.2L76.8 38.4zm192 0c-3-4-7.8-6.4-12.8-6.4s-9.8 2.4-12.8 6.4L198.4 98.1c-4.2 5.5-6.4 12.3-6.4 19.2L192 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-330.7c0-6.9-2.2-13.7-6.4-19.2L268.8 38.4zM448 32c-5 0-9.8 2.4-12.8 6.4L390.4 98.1c-4.2 5.5-6.4 12.3-6.4 19.2L384 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-330.7c0-6.9-2.2-13.7-6.4-19.2L460.8 38.4c-3-4-7.8-6.4-12.8-6.4z"]]
}, faUp = {
  prefix: "fad",
  iconName: "up",
  icon: [384, 512, ["arrow-alt-up"], "f357", ["M128 256c42.7 0 85.3 0 128 0c0 61.3 0 122.7 0 184c0 22.1-17.9 40-40 40l-48 0c-22.1 0-40-17.9-40-40c0-61.3 0-122.7 0-184z", "M214.6 41.4c-12.5-12.5-32.8-12.5-45.3 0l-160 160c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l96 0s0 0 0 0l128 0s0 0 0 0l96 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-160-160z"]]
}, faArrowAltUp = faUp, faBroomBall = {
  prefix: "fad",
  iconName: "broom-ball",
  icon: [576, 512, ["quidditch", "quidditch-broom-ball"], "f458", ["M329.4 201.4l45.3 45.3 192-192c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6S552.2 0 544 0s-16.4 3.1-22.6 9.4l-192 192zM384 432a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M409.4 281.4L294.6 166.6c-4.2-4.2-10-6.6-16-6.6c-12.5 0-22.6 10.1-22.6 22.6l0 29.1L364.3 320l29.1 0c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16zm-68.3 72L222.6 234.9c-42.7-3.7-85.2 11.7-115.8 42.3l-8 8C76.5 307.5 64 337.7 64 369.2c0 6.8 7.1 11.2 13.2 8.2l51.1-25.5c5-2.5 9.5 4.1 5.4 7.9L7.3 473.4C2.7 477.6 0 483.6 0 489.9C0 502.1 9.9 512 22.1 512l173.3 0c38.8 0 75.9-15.4 103.4-42.8c30.6-30.6 45.9-73.1 42.3-115.8z"]]
}, faQuidditch = faBroomBall, faQuidditchBroomBall = faBroomBall, faDrumstick = {
  prefix: "fad",
  iconName: "drumstick",
  icon: [512, 512, [127831], "f6d6", ["M0 380c0 33.1 26.9 60 60 60c6.3 0 12 5.7 12 12c0 33.1 26.9 60 60 60s60-26.9 60-60c0-5-.6-9.8-1.8-14.5c-4.2-16.9-5.2-37.1 7.2-49.4l36.4-36.4c-39.2-3-70.5-34.3-73.5-73.5l-36.4 36.4c-12.3 12.3-32.5 11.4-49.4 7.2C69.8 320.6 65 320 60 320c-33.1 0-60 26.9-60 60z", "M160 176v96c0 44.2 35.8 80 80 80h96c97.2 0 176-78.8 176-176S433.2 0 336 0S160 78.8 160 176z"]]
}, faSquareV = {
  prefix: "fad",
  iconName: "square-v",
  icon: [448, 512, [], "e284", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm98.5 82.7c-5.9-11.9-1.1-26.3 10.7-32.2s26.3-1.1 32.2 10.7c27.5 55 55 110.1 82.5 165.1c27.5-55 55-110 82.5-165.1c5.9-11.9 20.3-16.7 32.2-10.7c8.4 4.2 13.3 12.7 13.3 21.5c0 3.6-.8 7.3-2.5 10.7c-34.7 69.3-69.3 138.7-104 208c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3c-34.7-69.3-69.3-138.7-104-208z", "M109.3 146.5c11.9-5.9 26.3-1.1 32.2 10.7L224 322.3l82.5-165.1c5.9-11.9 20.3-16.7 32.2-10.7s16.7 20.3 10.7 32.2l-104 208c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3l-104-208c-5.9-11.9-1.1-26.3 10.7-32.2z"]]
}, faFaceAwesome = {
  prefix: "fad",
  iconName: "face-awesome",
  icon: [512, 512, ["gave-dandy"], "e409", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm80-72c0-35.3 28.7-64 64-64c3.4 0 6.7 .3 10 .8c22.6 3.5 41.3 18.9 49.5 39.6c2.9 7.3 4.5 15.3 4.5 23.6l0 10.3c0 16.4-13.3 29.7-29.7 29.7l-68.6 0C93.3 224 80 210.7 80 194.3L80 184zm20 120.2c0-8.7 7.1-16.2 16.3-16.2l279.4 0c10.4 0 18.1 9.6 15.9 19.8c-5 22.3-14.6 42.7-27.7 60.2c-29.4 39.3-76.5 64-127.9 64c-74.3 0-139.5-51.6-155.6-124.2c-.3-1.2-.4-2.4-.4-3.6zM272 192c0-39.8 32.2-72 72-72c5.8 0 11.4 .7 16.8 2c22 5.3 40.1 20.6 49.1 40.9c3.9 8.9 6.1 18.8 6.1 29.1l0 7.5c0 13.5-11 24.5-24.5 24.5l-95.1 0C283 224 272 213 272 199.5l0-7.5z", "M154 120.8c22.6 3.5 41.3 18.9 49.5 39.6c-5.6 9.4-15.8 15.6-27.5 15.6c-17.7 0-32-14.3-32-32c0-9.1 3.8-17.4 10-23.2zM360.8 122c22 5.3 40.1 20.6 49.1 40.9c-5.8 8-15.2 13.1-25.9 13.1c-17.7 0-32-14.3-32-32c0-8.5 3.3-16.3 8.8-22zM100.4 307.8c-2.3-10.2 5.5-19.8 15.9-19.8l279.4 0c10.4 0 18.1 9.6 15.9 19.8c-5 22.3-14.6 42.7-27.7 60.2c-13.4-10-30-16-47.9-16c-44.2 0-80 35.8-80 80c-74.3 0-139.5-51.6-155.6-124.2z"]]
}, faGaveDandy = faFaceAwesome, faDialOff = {
  prefix: "fad",
  iconName: "dial-off",
  icon: [576, 512, [], "e162", ["M0 288a32 32 0 1 0 64 0A32 32 0 1 0 0 288zM64 96a32 32 0 1 0 64 0A32 32 0 1 0 64 96zm0 384a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM256 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM448 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 384a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64-192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M312 446.2c77-11.6 136-78 136-158.2c0-88.4-71.6-160-160-160s-160 71.6-160 160c0 80.2 59 146.6 136 158.2L264 288c0-13.3 10.7-24 24-24s24 10.7 24 24l0 158.2z"]]
}, faToggleOff = {
  prefix: "fad",
  iconName: "toggle-off",
  icon: [576, 512, [], "f204", ["M0 256C0 362 86 448 192 448l192 0c106 0 192-86 192-192s-86-192-192-192L192 64C86 64 0 150 0 256zm64 0c0-70.7 57.3-128 128-128l192 0c70.7 0 128 57.3 128 128s-57.3 128-128 128l-192 0c-70.7 0-128-57.3-128-128z", "M96 256a96 96 0 1 0 192 0A96 96 0 1 0 96 256z"]]
}, faFaceSmileHorns = {
  prefix: "fad",
  iconName: "face-smile-horns",
  icon: [640, 512, [], "e391", ["M64 256c0-24.6 3.5-48.4 9.9-70.9C89.5 131 122.4 84.3 166.2 51.3C209.1 19.1 262.3 0 320 0s110.9 19.1 153.8 51.3c43.8 33 76.7 79.7 92.3 133.8c6.5 22.5 9.9 46.3 9.9 70.9c0 141.4-114.6 256-256 256S64 397.4 64 256zm112.8-37.1c-2.8 8.4 1.7 17.4 10.1 20.2l30.7 10.2c-5.8 5.8-9.3 13.8-9.3 22.6c0 17.7 14.3 32 32 32s32-14.3 32-32c0-1.5-.1-3-.3-4.4l10.9 3.6c8.4 2.8 17.4-1.7 20.2-10.1s-1.7-17.4-10.1-20.2l-96-32c-8.4-2.8-17.4 1.7-20.2 10.1zm27.1 151.5c22.2 25.7 61 53.5 116.1 53.5s93.8-27.9 116.1-53.5c5.8-6.7 5.1-16.8-1.6-22.6s-16.8-5.1-22.6 1.6C394 370.2 363.4 392 320 392s-74-21.8-91.9-42.5c-5.8-6.7-15.9-7.4-22.6-1.6s-7.4 15.9-1.6 22.6zM336.8 261.1c2.8 8.4 11.9 12.9 20.2 10.1l11.7-3.9c-.2 1.5-.3 3.1-.3 4.7c0 17.7 14.3 32 32 32s32-14.3 32-32c0-8.9-3.6-17-9.5-22.8l30.2-10.1c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-96 32c-8.4 2.8-12.9 11.9-10.1 20.2z", "M566.1 185.1C550.5 131 517.6 84.3 473.8 51.3c17-3.3 39.7-8.6 63-15.5c29.8-8.9 59.1-20.2 78.4-33.1c5.4-3.6 12.4-3.6 17.8 0s8.1 10.1 6.8 16.4c-6.2 31-29.3 106.6-73.6 166zM103.3 35.8c23.3 7 46 12.2 63 15.5c-43.8 33-76.7 79.7-92.3 133.8C29.6 125.8 6.5 50.1 .3 19.1C-1 12.8 1.7 6.3 7.1 2.7s12.4-3.6 17.8 0c19.3 12.9 48.5 24.2 78.4 33.1zM240.4 304c-17.7 0-32-14.3-32-32c0-8.8 3.6-16.8 9.3-22.6l-30.7-10.2c-8.4-2.8-12.9-11.9-10.1-20.2s11.9-12.9 20.2-10.1l96 32c8.4 2.8 12.9 11.9 10.1 20.2s-11.9 12.9-20.2 10.1l-10.9-3.6c.2 1.5 .3 2.9 .3 4.4c0 17.7-14.3 32-32 32zm192-32c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-1.6 .1-3.2 .3-4.7l-11.7 3.9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l96-32c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-30.2 10.1c5.9 5.8 9.5 13.9 9.5 22.8z"]]
}, faBoxArchive = {
  prefix: "fad",
  iconName: "box-archive",
  icon: [512, 512, ["archive"], "f187", ["M32 128l0 288c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-288L32 128zm128 96c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32z", "M0 64C0 46.3 14.3 32 32 32H480c17.7 0 32 14.3 32 32V96c0 17.7-14.3 32-32 32H32C14.3 128 0 113.7 0 96V64z"]]
}, faArchive = faBoxArchive, faGrapes = {
  prefix: "fad",
  iconName: "grapes",
  icon: [512, 512, [], "e306", ["M320 72c0-29.7 17.6-55 26.7-66c3.3-4 8.2-6 13.3-6s10 2 13.2 6C382.3 17.4 400 44.3 400 80c0 32-8 40-8 40s8-8 40-8c35.7 0 62.6 17.7 74 26.8c4 3.2 6 8.1 6 13.2s-2 10-6 13.3C495 174.4 469.7 192 440 192c-40 0-55.3-15.3-80-40s-40-40-40-80z", "M248 208a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm-80-32A56 56 0 1 0 56 176a56 56 0 1 0 112 0zM88 368a56 56 0 1 0 0-112 56 56 0 1 0 0 112zM56 512a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm144-32a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm192-80a56 56 0 1 0 -112 0 56 56 0 1 0 112 0zM224 344a56 56 0 1 0 0-112 56 56 0 1 0 0 112zm192-80a56 56 0 1 0 -112 0 56 56 0 1 0 112 0z"]]
}, faPersonDrowning = {
  prefix: "fad",
  iconName: "person-drowning",
  icon: [576, 512, [], "e545", ["M.8 455.3c4 17.2 21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 469.7 159 480 192 480c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9c.6-2.4 .8-4.9 .8-7.3c0-14.5-10-27.7-24.7-31.1c-18.1-4.2-36.2-13.3-50.6-25.2c-5.9-5-13.3-7.6-20.7-7.6c-6.5 0-12.9 2-18.5 5.9C439.4 405.2 410.9 416 384 416c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 405.4 219.5 416 192 416c-26.9 0-55.3-10.8-77.4-26.1C109 386 102.5 384 96 384c-7.4 0-14.8 2.6-20.7 7.6c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4z", "M160 32c17.7 0 32 14.3 32 32l0 32.2c0 52.7 34.1 99.3 84.3 115.3c40 12.7 82.7 14.5 123.7 5.2l105-23.9c17.2-3.9 34.4 6.9 38.3 24.1s-6.9 34.4-24.1 38.3l-105 23.9c-10.6 2.4-21.2 4.2-31.9 5.5l-17.7 97.6c-13.6-3.2-27.3-9.4-39.7-18c-22.1-15.5-51.6-15.5-73.7 0c-17.1 11.8-38 20.3-59.2 20.3c-7.3 0-15-1.2-22.8-3.3l21-146.7C151.5 200.1 128 150.2 128 96.2L128 64c0-17.7 14.3-32 32-32zm96 96a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]]
}, faDialMax = {
  prefix: "fad",
  iconName: "dial-max",
  icon: [576, 512, [], "e15e", ["M0 288a32 32 0 1 0 64 0A32 32 0 1 0 0 288zM64 96a32 32 0 1 0 64 0A32 32 0 1 0 64 96zm0 384a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM256 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM448 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 384a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64-192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M417.1 382.8c46.2-62.6 41-151.3-15.7-208c-62.5-62.5-163.8-62.5-226.3 0s-62.5 163.8 0 226.3c56.7 56.7 145.4 62 208 15.7L271.3 304.9c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L417.1 382.8z"]]
}, faCircleM = {
  prefix: "fad",
  iconName: "circle-m",
  icon: [512, 512, [], "e115", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM128 152c0-10.4 6.7-19.6 16.6-22.8c2.4-.8 4.9-1.2 7.4-1.2c7.6 0 14.9 3.6 19.5 9.9c28.2 39 56.4 78 84.5 117.1c28.2-39 56.4-78 84.5-117.1c4.6-6.4 11.9-10 19.5-9.9c2.5 0 4.9 .4 7.4 1.2c9.9 3.2 16.6 12.4 16.6 22.8l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-133.8c-20.2 27.9-40.4 55.9-60.5 83.8c-4.5 6.2-11.7 10-19.5 9.9s-14.9-3.7-19.5-9.9c-20.2-27.9-40.4-55.9-60.5-83.8L176 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208z", "M144.6 129.2c9.9-3.2 20.7 .3 26.8 8.8L256 255l84.5-117.1c6.1-8.4 16.9-12 26.8-8.8s16.6 12.4 16.6 22.8l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-133.8-60.5 83.8c-4.5 6.2-11.7 9.9-19.5 9.9s-14.9-3.7-19.5-9.9L176 226.2 176 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-10.4 6.7-19.6 16.6-22.8z"]]
}, faCalendarImage = {
  prefix: "fad",
  iconName: "calendar-image",
  icon: [448, 512, [], "e0d4", ["M0 192l448 0 0 272c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 192zm96 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm3.8 134.2c-8.1 10.5-.6 25.8 12.7 25.8l226.4 0c12.6 0 20.3-13.9 13.5-24.6L268.9 292.3c-6.1-9.7-20.1-9.9-26.7-.5L184 376l-11.4-15.1c-6.4-8.5-19-8.5-25.5-.2L99.8 422.2z", "M128 0C110.3 0 96 14.3 96 32l0 32L48 64C21.5 64 0 85.5 0 112l0 80 448 0 0-80c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32zM99.8 422.2c-8.1 10.5-.6 25.8 12.7 25.8l226.4 0c12.6 0 20.3-13.9 13.5-24.6L268.9 292.3c-6.1-9.7-20.1-9.9-26.7-.5L184 376l-11.4-15.1c-6.4-8.5-19-8.5-25.5-.2L99.8 422.2z"]]
}, faCircleCaretDown = {
  prefix: "fad",
  iconName: "circle-caret-down",
  icon: [512, 512, ["caret-circle-down"], "f32d", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128-24c0-3.2 .7-6.5 2-9.6c3.8-8.7 12.5-14.4 22-14.4l208 0c9.5 0 18.2 5.7 22 14.4c1.3 3.1 2 6.3 2 9.6c0 5.9-2.2 11.8-6.4 16.3l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7s-13-2.8-17.6-7.7l-104-112c-4.2-4.5-6.4-10.4-6.4-16.3z", "M273.6 360.3c-4.5 4.9-10.9 7.7-17.6 7.7s-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9s12.5-14.4 22-14.4l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112z"]]
}, faCaretCircleDown = faCircleCaretDown, faArrowDown91 = {
  prefix: "fad",
  iconName: "arrow-down-9-1",
  icon: [576, 512, ["sort-numeric-desc", "sort-numeric-down-alt"], "f886", ["M344 120c0 39.2 25.6 72.4 61.1 83.8l-6.8 9.2c-10.5 14.2-7.5 34.2 6.7 44.8s34.2 7.5 44.8-6.7l48.8-65.8c14-18.9 21.5-41.7 21.5-65.2c0-48.6-39.4-88-88-88s-88 39.4-88 88zm8 328c0 17.7 14.3 32 32 32l48 0 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-96c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 51.6-16 0c-17.7 0-32 14.3-32 32zM464 120a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M160 480c9 0 17.5-3.8 23.6-10.4l88-96c11.9-13 11.1-33.3-2-45.2s-33.3-11.1-45.2 2L192 365.7 192 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 301.7L95.6 330.4c-11.9-13-32.2-13.9-45.2-2s-13.9 32.2-2 45.2l88 96C142.5 476.2 151 480 160 480z"]]
}, faSortNumericDesc = faArrowDown91, faSortNumericDownAlt = faArrowDown91, faFaceGrinTongueSquint = {
  prefix: "fad",
  iconName: "face-grin-tongue-squint",
  icon: [512, 512, [128541, "grin-tongue-squint"], "f58a", ["M0 256C0 368.9 73.1 464.7 174.5 498.8C165.3 484 160 466.6 160 448l0-47.3c-24-17.5-43.1-41.4-54.8-69.2c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19c12.3-3.8 24.3 6.9 19.3 18.7c-11.8 28-31.1 52-55.4 69.6l0 46.9c0 18.6-5.3 36-14.5 50.8C438.9 464.7 512 368.9 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256zM116 141.1c0-6.9 5.7-11.9 11.9-11.9c1.9 0 3.8 .4 5.6 1.4c30 16 59.9 32 89.9 47.9c10.7 5.7 10.7 21.1 0 26.8c-30 16-59.9 32-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6c12-14.4 24-28.8 36-43.2c-12-14.4-24-28.8-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm172.6 37.4c30-16 59.9-32 89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5c0 2.8-1 5.5-2.8 7.6c-12 14.4-24 28.8-36 43.2c12 14.4 24 28.8 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5c-30-16-59.9-32-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8z", "M133.5 130.7c-7.9-4.2-17.5 1.5-17.5 10.5c0 2.8 1 5.5 2.8 7.6l36 43.2-36 43.2c-1.8 2.1-2.8 4.8-2.8 7.6c0 9 9.6 14.7 17.5 10.5l89.9-47.9c10.7-5.7 10.7-21.1 0-26.8l-89.9-47.9zm245 0l-89.9 47.9c-10.7 5.7-10.7 21.1 0 26.8l89.9 47.9c7.9 4.2 17.5-1.5 17.5-10.5c0-2.8-1-5.5-2.8-7.6l-36-43.2 36-43.2c1.8-2.1 2.8-4.8 2.8-7.6c0-9-9.6-14.7-17.5-10.5zM320 448l0-45.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9c-2.8 12.6-20.8 12.6-23.6 0c-2.5-11.1-12.3-18.9-23.6-18.9l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 45.4c0 35.3 28.7 64 64 64s64-28.7 64-64z"]]
}, faGrinTongueSquint = faFaceGrinTongueSquint, faShishKebab = {
  prefix: "fad",
  iconName: "shish-kebab",
  icon: [512, 512, [], "f821", ["M0 480c0 8.2 3.1 16.4 9.4 22.6c12.5 12.5 32.8 12.5 45.3 0l59-59c-15.1-15.1-30.2-30.2-45.3-45.3l-59 59C3.1 463.6 0 471.8 0 480zM166.3 300.4c15.1 15.1 30.2 30.2 45.3 45.3l30.1-30.1c-15.1-15.1-30.2-30.2-45.3-45.3l-30.1 30.1zm128-128c15.1 15.1 30.2 30.2 45.3 45.3l48.1-48.1c16.2-16.2 14.1-39.7 3-53.9c-9.8-12.5-8.8-30.7 2.7-42.2c12.5-12.5 32.8-12.5 45.3 0c10.4 10.4 12.2 26.4 5.1 38.6c-8.8 15.3-3.6 34.9 11.7 43.7s34.9 3.6 43.7-11.7c8.6-14.8 12.8-31.4 12.8-48c0-24.6-9.4-49.1-28.1-67.9c-37.5-37.5-98.3-37.5-135.8 0c-29.6 29.6-35.8 73.6-18.8 109.3l-35 35z", "M203.7 138.3l-41.4 41.4c-15.6 15.6-15.6 40.9 0 56.6L275.7 349.7c15.6 15.6 40.9 15.6 56.6 0l41.4-41.4c15.6-15.6 15.6-40.9 0-56.6L260.3 138.3c-15.6-15.6-40.9-15.6-56.6 0zm-71.4 128c-15.6-15.6-40.9-15.6-56.6 0L34.3 307.7c-15.6 15.6-15.6 40.9 0 56.6L147.7 477.7c15.6 15.6 40.9 15.6 56.6 0l41.4-41.4c15.6-15.6 15.6-40.9 0-56.6L132.3 266.3z"]]
}, faSprayCan = {
  prefix: "fad",
  iconName: "spray-can",
  icon: [512, 512, [], "f5bd", ["M80 336a80 80 0 1 0 160 0A80 80 0 1 0 80 336zM256 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96-96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M128 0l64 0c17.7 0 32 14.3 32 32l0 96L96 128l0-96c0-17.7 14.3-32 32-32zM0 256c0-53 43-96 96-96l128 0c53 0 96 43 96 96l0 208c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 256zm240 80A80 80 0 1 0 80 336a80 80 0 1 0 160 0z"]]
}, faAlarmSnooze = {
  prefix: "fad",
  iconName: "alarm-snooze",
  icon: [512, 512, [], "f845", ["M32 288c0 50.3 16.6 96.8 44.6 134.2L41.4 457.4C35.1 463.6 32 471.8 32 480s3.1 16.4 9.4 22.6c12.5 12.5 32.8 12.5 45.3 0l35.2-35.2c37.4 28 83.8 44.6 134.1 44.6s96.8-16.6 134.2-44.6l35.2 35.2c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-35.2-35.2c28-37.4 44.6-83.8 44.6-134.2C480 164.3 379.7 64 256 64S32 164.3 32 288zm144-72c0-13.3 10.7-24 24-24l112 0c9.2 0 17.5 5.2 21.6 13.5s3 18-2.6 25.3L249.1 336l62.9 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-9.2 0-17.5-5.2-21.6-13.5s-3-18 2.6-25.3L262.9 240 200 240c-13.3 0-24-10.7-24-24z", "M14.9 146.4L160 25.4C143 9.6 120.2 0 95.2 0C42.6 0 0 42.6 0 95.2c0 18.8 5.5 36.3 14.9 51.1zm482.3 0C506.5 131.6 512 114 512 95.2C512 42.6 469.4 0 416.8 0C391.8 0 369 9.6 352 25.4L497.1 146.4zM200 192c-13.3 0-24 10.7-24 24s10.7 24 24 24l62.9 0L181.1 345.3c-5.6 7.2-6.6 17-2.6 25.3s12.4 13.5 21.6 13.5l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-62.9 0 81.9-105.3c5.6-7.2 6.6-17 2.6-25.3s-12.4-13.5-21.6-13.5l-112 0z"]]
}, faScarecrow = {
  prefix: "fad",
  iconName: "scarecrow",
  icon: [448, 512, [], "f70d", ["M128 96c0 11.2 1.9 22 5.5 32c13.2 37.3 48.7 64 90.5 64s77.4-26.7 90.5-64c3.5-10 5.5-20.8 5.5-32c0-53-43-96-96-96s-96 43-96 96zm80-16a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM192 400.1l0 79.9c0 17.7 14.3 32 32 32s32-14.3 32-32l0-79.9-24.1 13.8c-2.5 1.4-5.2 2.1-7.9 2.1s-5.5-.7-7.9-2.1c-8-4.6-16-9.2-24.1-13.8zM272 96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M133.5 128L32 128c-5.9 0-11.3 3.2-14.1 8.5s-2.5 11.5 .8 16.4l7.6 11.4L6.4 179.2C2.4 182.2 0 187 0 192s2.4 9.8 6.4 12.8l19.9 14.9-7.6 11.4c-3.3 4.9-3.6 11.2-.8 16.4s8.2 8.5 14.1 8.5l73 0c10.1 0 17.7 9.2 15.7 19.1L96.3 396.9c-1.2 6.2 1.2 12.5 6.3 16.1s11.8 4 17.3 .9L160.1 391c4.9-2.8 11-2.8 15.9 0l40.1 22.9c4.9 2.8 11 2.8 15.9 0L272.1 391c4.9-2.8 11-2.8 15.9 0l40.1 22.9c5.4 3.1 12.2 2.8 17.3-.9s7.6-10 6.3-16.1L327.3 275.1c-2-9.9 5.6-19.1 15.7-19.1l73 0c5.9 0 11.3-3.2 14.1-8.5s2.5-11.5-.8-16.4l-7.6-11.4 19.9-14.9c4-3 6.4-7.8 6.4-12.8s-2.4-9.8-6.4-12.8l-19.9-14.9 7.6-11.4c3.3-4.9 3.6-11.2 .8-16.4s-8.2-8.5-14.1-8.5l-101.5 0c-13.2 37.3-48.7 64-90.5 64s-77.4-26.7-90.5-64z"]]
}, faTruckMonster = {
  prefix: "fad",
  iconName: "truck-monster",
  icon: [640, 512, [], "f63b", ["M32 384c0 13.4 8.3 24.9 20 29.7c2.5 9.1 6.1 17.7 10.7 25.7C57.7 451 60 465 69.5 474.5s23.5 11.8 35.1 6.9c8 4.6 16.6 8.2 25.7 10.7c4.8 11.7 16.2 20 29.7 20s24.9-8.3 29.7-20c9.1-2.5 17.7-6.1 25.7-10.7c11.6 4.9 25.6 2.6 35.1-6.8s11.8-23.5 6.8-35.1c4.6-8 8.2-16.6 10.7-25.7c11.7-4.8 20-16.2 20-29.7s-8.3-24.9-20-29.7c-2.5-9.1-6.1-17.7-10.7-25.7c4.9-11.6 2.6-25.6-6.8-35.1s-23.5-11.8-35.1-6.8c-8-4.6-16.6-8.2-25.7-10.7c-4.8-11.7-16.2-20-29.7-20s-24.9 8.3-29.7 20c-9.1 2.5-17.7 6.1-25.7 10.7C93 281.7 79 284 69.5 293.5S57.7 317 62.6 328.6c-4.6 8-8.2 16.6-10.7 25.7c-11.7 4.8-20 16.2-20 29.7zm176 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm144 0c0 13.4 8.3 24.9 20 29.7c2.5 9.1 6.1 17.7 10.7 25.7c-4.9 11.6-2.6 25.6 6.8 35.1s23.5 11.8 35.1 6.9c8 4.6 16.6 8.2 25.7 10.7c4.8 11.7 16.2 20 29.7 20s24.9-8.3 29.7-20c9.1-2.5 17.7-6.1 25.7-10.7c11.6 4.9 25.6 2.6 35.1-6.8s11.8-23.5 6.9-35.1c4.6-8 8.2-16.6 10.7-25.7c11.7-4.8 20-16.2 20-29.7s-8.3-24.9-20-29.7c-2.5-9.1-6.1-17.7-10.7-25.7c4.9-11.6 2.6-25.6-6.9-35.1s-23.5-11.8-35.1-6.8c-8-4.6-16.6-8.2-25.7-10.7c-4.8-11.7-16.2-20-29.7-20s-24.9 8.3-29.7 20c-9.1 2.5-17.7 6.1-25.7 10.7c-11.6-4.9-25.6-2.6-35.1 6.8s-11.8 23.5-6.8 35.1c-4.6 8-8.2 16.6-10.7 25.7c-11.7 4.8-20 16.2-20 29.7zm176 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M288 64l0 64 128 0L368 64l-80 0zM419.2 25.6L496 128l80 0c17.7 0 32 14.3 32 32l0 64c17.7 0 32 14.3 32 32s-14.3 32-32 32c-29.2-38.9-75.7-64-128-64s-98.8 25.1-128 64l-64 0c-29.2-38.9-75.7-64-128-64s-98.8 25.1-128 64c-17.7 0-32-14.3-32-32s14.3-32 32-32l0-64c0-17.7 14.3-32 32-32l160 0 0-80c0-26.5 21.5-48 48-48l96 0c20.1 0 39.1 9.5 51.2 25.6z"]]
}, faGiftCard = {
  prefix: "fad",
  iconName: "gift-card",
  icon: [576, 512, [], "f663", ["M0 192L0 320l576 0 0-128c0-35.3-28.7-64-64-64l-41.6 0c-14.6 28.5-44.2 48-78.4 48l-59.4 0 53.9 64.6c8.5 10.2 7.1 25.3-3.1 33.8s-25.3 7.1-33.8-3.1L288 197.5l-61.6 73.9c-8.5 10.2-23.6 11.6-33.8 3.1s-11.6-23.6-3.1-33.8L243.4 176 184 176c-1.1 0-2.1 0-3.2-.1s-2.1-.1-3.2-.2c-2.1-.1-4.2-.4-6.2-.7c-4.1-.6-8.1-1.5-12-2.6c-7.8-2.3-15.2-5.6-21.9-9.8c-13.5-8.4-24.6-20.4-31.8-34.7L64 128c-35.3 0-64 28.7-64 64zM0 416l0 32c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-32L0 416z", "M186.2 48L184 48c-22.1 0-40 17.9-40 40s17.9 40 40 40l73.3 0L222.5 68.8C214.9 55.9 201.1 48 186.2 48zm57.3 128L184 176c-48.6 0-88-39.4-88-88s39.4-88 88-88l2.2 0c31.9 0 61.5 16.9 77.7 44.4l24.1 41 24.1-41C328.3 16.9 357.9 0 389.8 0L392 0c48.6 0 88 39.4 88 88s-39.4 88-88 88l-59.4 0 53.9 64.6c8.5 10.2 7.1 25.3-3.1 33.8s-25.3 7.1-33.8-3.1L288 197.5l-61.6 73.9c-8.5 10.2-23.6 11.6-33.8 3.1s-11.6-23.6-3.1-33.8L243.4 176zM392 128c22.1 0 40-17.9 40-40s-17.9-40-40-40l-2.2 0c-14.9 0-28.8 7.9-36.3 20.8L318.7 128l1.3 0 72 0zM576 416L0 416l0-96 576 0 0 96z"]]
}, faW = {
  prefix: "fad",
  iconName: "w",
  icon: [576, 512, [119], "57", ["M20.8 34c16.5-6.2 35 2.2 41.2 18.7l110.2 294L257.3 55c4-13.7 16.5-23 30.7-23s26.7 9.4 30.7 23l85.1 291.7L514 52.8c6.2-16.5 24.6-24.9 41.2-18.7s24.9 24.7 18.7 41.2l-144 384c-4.8 12.9-17.4 21.3-31.2 20.7s-25.7-9.8-29.5-23L288 178.3 206.7 457c-3.9 13.2-15.8 22.5-29.5 23s-26.3-7.8-31.2-20.7L2 75.2C-4.2 58.7 4.2 40.2 20.8 34z", ""]]
}, faCodePullRequestDraft = {
  prefix: "fad",
  iconName: "code-pull-request-draft",
  icon: [448, 512, [], "e3fa", ["M48 153.3c4.9 2.1 10.1 3.8 15.4 4.9c2.7 .6 5.4 1 8.2 1.3c1.4 .1 2.8 .3 4.2 .3c1.4 .1 2.8 .1 4.2 .1c11.4 0 22.2-2.4 32-6.7l0 205.3c-4.9-2.1-10.1-3.8-15.4-4.9c-2.7-.6-5.4-1-8.2-1.3c-1.4-.1-2.8-.3-4.2-.3s-2.8-.1-4.2-.1c-11.4 0-22.2 2.4-32 6.7l0-205.3zM416 80a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm0 160a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M80 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104A80 80 0 1 0 80 0a80 80 0 1 0 0 160zm0 248a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm264-80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]]
}, faSquareB = {
  prefix: "fad",
  iconName: "square-b",
  icon: [448, 512, [], "e264", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm128 56c0-13.3 10.7-24 24-24l92 0c42 0 76 34 76 76c0 16.2-5.1 31.3-13.8 43.7C324.3 261.6 336 283.4 336 308c0 42-34 76-76 76l-108 0c-13.3 0-24-10.7-24-24l0-104 0-104zm48 24l0 56 68 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-68 0zm0 104l0 56 84 0c15.5 0 28-12.5 28-28s-12.5-28-28-28l-16 0-68 0z", "M152 128c-13.3 0-24 10.7-24 24l0 104 0 104c0 13.3 10.7 24 24 24l108 0c42 0 76-34 76-76c0-24.6-11.7-46.4-29.8-60.3c8.7-12.4 13.8-27.4 13.8-43.7c0-42-34-76-76-76l-92 0zm92 104l-68 0 0-56 68 0c15.5 0 28 12.5 28 28s-12.5 28-28 28zm-68 48l68 0 16 0c15.5 0 28 12.5 28 28s-12.5 28-28 28l-84 0 0-56z"]]
}, faElephant = {
  prefix: "fad",
  iconName: "elephant",
  icon: [640, 512, [128024], "f6da", ["M0 360c0 7.3 3.3 14.5 9.6 19.2c10.6 8 25.6 5.8 33.6-4.8l12.1-16.2c3.2-4.3 6.1-8.8 8.7-13.5L64 480c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-70c15.3 3.9 31.4 6 48 6s32.7-2.1 48-6l0 70c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-139.3c-5.1-5.8-9.7-12-13.7-18.7c-1.6-2.6-2.3-5.4-2.3-8.2c0-5.4 2.8-10.7 7.7-13.7c7.6-4.6 17.4-2.1 22 5.4C446.5 333.4 477.1 352 512 352c1.4 0 2.8 0 4.2-.1s2.8-.1 4.1-.3c2.7-.2 5.5-.6 8.1-1c5.3-.9 10.5-2.3 15.5-4.1L544 192c0-88.4-71.6-160-160-160l-1.6 0C362.2 12.2 334.5 0 304 0C242.1 0 192 50.1 192 112s50.1 112 112 112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-79.5 0-144-64.5-144-144c0-25.3 6.5-49.1 18-69.8c-20.5 7-39.4 17.3-56.1 30.4C67.4 111.9 32 175.8 32 248l0 19c0 12.4-1.2 24.7-3.7 36.9c-1.9 9.3-5.8 18-11.4 25.6L4.8 345.6C1.6 349.9 0 355 0 360zM480 208a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm0 172l0 18.6c0 45 36.5 81.4 81.4 81.4c30.8 0 59-17.4 72.8-45l2.3-4.7c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3l-2.3 4.7c-3 5.9-9 9.6-15.6 9.6c-9.6 0-17.4-7.8-17.4-17.4l0-18.6c-10.2 2.6-21 4-32 4c-1.4 0-2.8 0-4.1-.1s-2.7-.1-4.1-.2c-2.7-.2-5.4-.4-8.1-.8c-5.3-.7-10.6-1.7-15.7-3z", "M464 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm-34.3 81.5c-4.6-7.6-14.4-10-22-5.4s-10 14.4-5.4 22c22.4 37.1 63.1 62 109.7 62c35.8 0 68.2-14.7 91.4-38.4c6.2-6.3 6.1-16.4-.2-22.6s-16.4-6.1-22.6 .2C563.1 341 538.9 352 512 352c-34.9 0-65.5-18.6-82.3-46.5z"]]
}, faEarthAfrica = {
  prefix: "fad",
  iconName: "earth-africa",
  icon: [512, 512, [127757, "globe-africa"], "f57c", ["M0 256C0 397.4 114.6 512 256 512s256-114.6 256-256c0-22.1-2.8-43.5-8.1-64c-25.5 0-50.9 0-76.4 0c-7.1 0-13.5 4-16.7 10.3c-6.2 12.4-20.7 18.4-33.9 14c-4.2-1.4-8.3-2.8-12.5-4.2c-7.7-2.6-16.1-.6-21.8 5.1c-3.7 3.7-3.7 9.7 0 13.4c11.2 11.2 22.3 22.3 33.5 33.5c.6 .6 1.2 1.3 1.8 2s1.1 1.4 1.6 2.1c1 1.5 1.8 3 2.5 4.6c.7 1.6 1.2 3.3 1.5 5c.2 .9 .3 1.7 .4 2.6c.1 .9 .1 1.7 .1 2.2l0 .4c0 .2 0 .3 0 .4c0 .4 0 1.1-.1 1.8c-.1 .8-.2 1.5-.3 2.2c-.3 1.5-.6 2.9-1.1 4.3c-1 2.8-2.4 5.3-4.2 7.6c-3.6 4.6-8.7 8-14.6 9.5c-1.8 .4-3.5 .9-5.3 1.3c-3.8 .9-6.4 4.3-6.4 8.2c0 4 0 8 0 12.1c0 .1 0 .2 0 .3c0 .7 0 1.4 0 2.2l0 .4c0 .6-.1 1.3-.1 2.1c-.2 1.9-.4 3.6-.6 5.3c-.6 3.4-1.4 6.7-2.5 10c-2.2 6.5-5.4 12.6-9.5 18.2c-8.5 11.4-17.1 22.8-25.6 34.1c-6 8.1-15.5 12.8-25.6 12.8c-17.7 0-32-14.3-32-32c0-16 0-32 0-48c0-.1 0-.3 0-.4c0-.3 0-.7-.1-1.2c-.1-.6-.1-1.1-.2-1.6c-.2-1-.5-2-.9-3c-.8-1.9-2-3.6-3.4-5.1c-2.9-2.9-6.9-4.7-11.3-4.7l-32 0c-26.5 0-48-21.5-48-48c0-9.3 0-18.7 0-28c0-12.6 5.9-24.4 16-32l39.4-29.5c5.6-4.2 12.4-6.5 19.4-6.5c3.5 0 6.9 .6 10.2 1.7l32 10.7c7.2 2.4 15 2.7 22.4 .9c11.8-2.9 23.6-5.9 35.4-8.8c.7-.2 1.3-.4 1.8-.5c.7-.2 1.3-.5 1.8-.7c1.2-.5 2.3-1.1 3.3-1.8c2.1-1.4 4-3.1 5.5-5s2.7-4.2 3.6-6.5c.4-1.2 .7-2.4 .9-3.7c.1-.7 .2-1.3 .2-1.9c0-.6 .1-1.2 .1-1.5l0-.4c0-.1 0-.3 0-.4c0-.2 0-.7-.1-1.2c0-.5-.1-1.1-.2-1.6c-.2-1.1-.4-2.1-.7-3.1c-.6-2-1.4-3.9-2.5-5.7c-2.2-3.5-5.4-6.5-9.2-8.4l-29.2-14.6c-3.7-1.8-8.1-1.1-11 1.8c-1.3 1.3-2.6 2.6-3.9 3.9c-4.6 4.6-10.9 7.2-17.4 7.2c-3.8 0-7.6-.9-11-2.6c-5.1-2.5-10.2-5.1-15.2-7.6c-6.8-3.4-14.9-1.6-19.7 4.3c-4.5 5.7-9.1 11.3-13.6 17c-5.5 6.9-15.8 7.4-22 1.2c-2.8-2.8-4.3-6.5-4.3-10.4c0-13.2 0-26.3 0-39.5c0-.9 0-1.7-.1-2.5c-.1-.8-.2-1.7-.3-2.5c-.3-1.7-.7-3.3-1.2-4.9c-1-3.2-2.6-6.2-4.6-8.9C172.6 61.3 159.3 43 146 24.8C59.7 65.9 0 154 0 256z", "M146 24.8l39.9 54.8c4 5.5 6.1 12.1 6.1 18.8l0 39.5c0 3.9 1.6 7.7 4.3 10.4c6.2 6.2 16.5 5.7 22-1.2l13.6-17c4.7-5.9 12.9-7.7 19.6-4.3l15.2 7.6c3.4 1.7 7.2 2.6 11 2.6c6.5 0 12.8-2.6 17.4-7.2l3.9-3.9c2.9-2.9 7.3-3.6 11-1.8l29.2 14.6c7.8 3.9 12.6 11.8 12.6 20.5c0 10.5-7.1 19.6-17.3 22.2l-35.4 8.8c-7.4 1.8-15.1 1.5-22.4-.9l-32-10.7c-3.3-1.1-6.7-1.7-10.2-1.7c-7 0-13.8 2.3-19.4 6.5L176 212c-10.1 7.6-16 19.4-16 32l0 28c0 26.5 21.5 48 48 48l32 0c8.8 0 16 7.2 16 16l0 48c0 17.7 14.3 32 32 32c10.1 0 19.6-4.7 25.6-12.8l25.6-34.1c8.3-11.1 12.8-24.6 12.8-38.4l0-12.1c0-3.9 2.6-7.3 6.4-8.2l5.3-1.3c11.9-3 20.3-13.7 20.3-26c0-7.1-2.8-13.9-7.8-18.9l-33.5-33.5c-3.7-3.7-3.7-9.7 0-13.4c5.7-5.7 14.1-7.7 21.8-5.1l12.5 4.2c13.2 4.4 27.6-1.6 33.9-14c3.2-6.3 9.6-10.3 16.7-10.3l76.4 0C475.5 81.6 375.3 0 256 0c-39.4 0-76.7 8.9-110 24.8z"]]
}, faGlobeAfrica = faEarthAfrica, faRainbow = {
  prefix: "fad",
  iconName: "rainbow",
  icon: [640, 512, [127752], "f75b", ["M96 352l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-88.4 71.6-160 160-160s160 71.6 160 160l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-123.7-100.3-224-224-224S96 228.3 96 352z", "M64 352C64 210.6 178.6 96 320 96s256 114.6 256 256l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96C640 175.3 496.7 32 320 32S0 175.3 0 352l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96zm192 0c0-35.3 28.7-64 64-64s64 28.7 64 64l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-70.7-57.3-128-128-128s-128 57.3-128 128l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96z"]]
}, faCircleNotch = {
  prefix: "fad",
  iconName: "circle-notch",
  icon: [512, 512, [], "f1ce", ["M222.7 32.1c5 16.9-4.6 34.8-21.5 39.8C121.8 95.6 64 169.1 64 256c0 106 86 192 192 192s192-86 192-192c0-86.9-57.8-160.4-137.1-184.1c-16.9-5-26.6-22.9-21.5-39.8s22.9-26.6 39.8-21.5C434.9 42.1 512 140 512 256c0 141.4-114.6 256-256 256S0 397.4 0 256C0 140 77.1 42.1 182.9 10.6c16.9-5 34.8 4.6 39.8 21.5z", ""]]
}, faTabletScreenButton = {
  prefix: "fad",
  iconName: "tablet-screen-button",
  icon: [448, 512, ["tablet-alt"], "f3fa", ["M0 64C0 28.7 28.7 0 64 0L384 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm64 0l0 320 320 0 0-320L64 64zM192 448a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M64 64H384V384H64V64z"]]
}, faTabletAlt = faTabletScreenButton, faPaw = {
  prefix: "fad",
  iconName: "paw",
  icon: [512, 512, [], "f1b0", ["M0 208.4c0 13.2 3.8 27.6 11.6 41.1c18.9 32.4 54 47.3 78.5 33.3s29.1-51.7 10.2-84.1s-54-47.3-78.5-33.3C7.5 173.5 0 189.8 0 208.4zm109.5-77.2c14.3 42.9 52.1 69.1 84.4 58.5s46.9-53.9 32.6-96.8S174.4 23.8 142.1 34.3s-46.9 53.9-32.6 96.8zm168-38.3c-14.3 42.9 .3 86.2 32.6 96.8s70.1-15.6 84.4-58.5s-.3-86.2-32.6-96.8S291.8 50 277.5 92.9zM411.6 198.6c-18.9 32.4-14.3 70.1 10.2 84.1s59.7-.9 78.5-33.3c7.8-13.5 11.6-27.8 11.6-41.1c0-18.6-7.5-34.9-21.8-43.1c-24.5-14-59.7 .9-78.5 33.3z", "M69.2 401.2C121.6 259.9 214.7 224 256 224s134.4 35.9 186.8 177.2c3.6 9.7 5.2 20.1 5.2 30.5v1.6c0 25.8-20.9 46.7-46.7 46.7c-11.5 0-22.9-1.4-34-4.2l-88-22c-15.3-3.8-31.3-3.8-46.6 0l-88 22c-11.1 2.8-22.5 4.2-34 4.2C84.9 480 64 459.1 64 433.3v-1.6c0-10.4 1.6-20.8 5.2-30.5z"]]
}, faMessageQuestion = {
  prefix: "fad",
  iconName: "message-question",
  icon: [512, 512, [], "e1e3", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zm169.4 54.5c-4.4 12.5 2.1 26.2 14.6 30.6s26.2-2.1 30.6-14.6c.1-.2 .1-.4 .2-.6c1.4-3.9 4.4-5.9 7.8-5.9l58.3 0c4.2 0 8 1.7 10.7 4.4c1.4 1.4 2.5 3 3.2 4.8c.4 .9 .7 1.9 .9 2.8c.1 .5 .2 1 .2 1.5s.1 1 .1 1.5c0 .5 0 .8 0 1.1s-.1 .7-.1 1c-.1 .7-.2 1.3-.4 2c-.3 1.3-.9 2.5-1.5 3.6c-1.3 2.3-3.2 4.2-5.6 5.5c-14.8 8.5-29.6 17-44.3 25.4c-7.5 4.3-12.1 12.2-12.1 20.8c0 4.5 0 9 0 13.5c0 13.3 10.7 24 24 24c6.6 0 12.5-2.6 16.8-6.9c2.2-2.1 3.9-4.7 5.2-7.5c.6-1.4 1.1-2.9 1.4-4.4c.2-.8 .3-1.6 .4-2.3s.1-1.6 .2-2.3c10.8-6.3 21.5-12.5 32.3-18.6c19.6-11.3 31.7-32.2 31.7-54.8c0-34.9-28.3-63.1-63.1-63.1l-58.3 0c-23.7 0-44.8 14.9-52.8 37.3c-.1 .4-.3 .8-.4 1.2zM224 304c0 17.7 14.3 32 32 32c8.8 0 16.8-3.6 22.6-9.4c2.9-2.9 5.2-6.3 6.9-10.2c.8-1.9 1.4-3.9 1.9-6c.2-1 .4-2.1 .5-3.2c.1-.6 .1-1.1 .1-1.6c0-.5 0-1 0-1.5c0-.8 0-1.3 0-1.8s-.1-1.1-.1-1.6c-.1-1.1-.3-2.1-.5-3.2c-.4-2.1-1.1-4.1-1.9-6c-1.6-3.8-4-7.3-6.9-10.2c-5.8-5.8-13.8-9.4-22.6-9.4c-17.7 0-32 14.3-32 32z", "M222.6 80c-23.7 0-44.8 14.9-52.8 37.3l-.4 1.2c-4.4 12.5 2.1 26.2 14.6 30.6s26.2-2.1 30.6-14.6l.4-1.2c1.1-3.2 4.2-5.3 7.5-5.3l58.3 0c8.4 0 15.1 6.8 15.1 15.1c0 5.4-2.9 10.4-7.6 13.1l-44.3 25.4c-7.5 4.3-12.1 12.2-12.1 20.8l0 13.5c0 13.3 10.7 24 24 24c13.1 0 23.8-10.5 24-23.6l32.3-18.5c19.6-11.3 31.7-32.2 31.7-54.8c0-34.9-28.3-63.1-63.1-63.1l-58.3 0zM256 336a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faCloud = {
  prefix: "fad",
  iconName: "cloud",
  icon: [640, 512, [9729], "f0c2", ["M0 336c0 79.5 64.5 144 144 144l368 0c70.7 0 128-57.3 128-128c0-61.9-44-113.6-102.4-125.4c4.1-10.7 6.4-22.4 6.4-34.6c0-53-43-96-96-96c-19.7 0-38.1 6-53.3 16.2C367 64.2 315.3 32 256 32C167.6 32 96 103.6 96 192c0 2.7 .1 5.4 .2 8.1C40.2 219.8 0 273.2 0 336z", ""]]
}, faTrowelBricks = {
  prefix: "fad",
  iconName: "trowel-bricks",
  icon: [512, 512, [], "e58a", ["M0 416c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32l0-64zm192 0c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32l0-64zm96-160c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-64z", "M256 32c0-11.1-5.7-21.4-15.2-27.2s-21.2-6.4-31.1-1.4l-192 96C6.8 104.8 0 115.9 0 128s6.8 23.2 17.7 28.6l192 96c9.9 5 21.7 4.4 31.1-1.4s15.2-16.1 15.2-27.2l0-72 89 0c3.6 13.8 16.1 24 31 24l88 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-88 0c-14.9 0-27.4 10.2-31 24l-89 0 0-72z"]]
}, faSquare3 = {
  prefix: "fad",
  iconName: "square-3",
  icon: [448, 512, [], "e258", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm128 56c0-13.3 10.7-24 24-24l128 0c9.9 0 18.8 6.1 22.4 15.3s1.1 19.7-6.2 26.4c-16.9 15.5-33.8 31-50.8 46.5c21 2.4 39.6 12.5 53 27.4c6.7 7.5 12.1 16.1 15.8 25.6c1.9 4.7 3.3 9.7 4.3 14.8c.5 2.6 .9 5.2 1.1 7.8c.1 1.3 .2 2.6 .3 4c.1 1.4 .1 2.7 .1 4.1c0 1.5 0 2.9-.1 4.4c-.1 1.4-.2 2.8-.3 4.3c-.3 2.8-.7 5.6-1.3 8.3c-1.1 5.5-2.8 10.8-4.9 15.8c-4.3 10.1-10.4 19.1-18 26.7c-15.2 15.2-36.3 24.6-59.5 24.6L208 384c-30.1 0-58.1-15.6-73.9-41.2c-.9-1.4-1.7-2.8-2.6-4.2c-2.4-3.9-3.6-8.3-3.6-12.6c0-8 4-15.9 11.4-20.4c11.3-7 26.1-3.5 33 7.8l2.6 4.2c7.1 11.5 19.6 18.4 33 18.4l27.8 0c10 0 19-4 25.6-10.6c3.3-3.3 5.9-7.2 7.7-11.5c.9-2.2 1.6-4.4 2.1-6.8c.2-1.2 .4-2.4 .5-3.6c.1-.6 .1-1.2 .1-1.8s0-1.2 0-2c0-.7 0-1.2 0-1.8c0-.6-.1-1.2-.1-1.8c-.1-1.2-.3-2.4-.6-3.6c-.5-2.4-1.2-4.6-2.1-6.8c-1.8-4.3-4.5-8.2-7.8-11.5c-6.6-6.5-15.7-10.6-25.7-10.5l-51.5 .3c-9.9 .1-18.9-6-22.5-15.2s-1.2-19.8 6.1-26.5c16.8-15.4 33.7-30.9 50.5-46.3L152 176c-13.3 0-24-10.7-24-24z", "M128 152c0-13.3 10.7-24 24-24l128 0c9.9 0 18.8 6.1 22.4 15.3s1.1 19.7-6.1 26.4l-50.8 46.5c41.9 4.8 74.6 40.4 74.6 83.6c0 46.5-37.7 84.2-84.2 84.2L208 384c-30.1 0-58.1-15.6-73.9-41.2l-2.6-4.2c-7-11.3-3.5-26.1 7.8-33s26.1-3.5 33 7.8l2.6 4.2c7.1 11.5 19.6 18.4 33 18.4l27.8 0c20 0 36.2-16.2 36.2-36.2c0-20.1-16.3-36.3-36.4-36.2l-51.5 .3c-9.9 .1-18.9-6-22.5-15.2s-1.2-19.8 6.1-26.5L218.3 176 152 176c-13.3 0-24-10.7-24-24z"]]
}, faFaceFlushed = {
  prefix: "fad",
  iconName: "face-flushed",
  icon: [512, 512, [128563, "flushed"], "f579", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm232-32A72 72 0 1 1 88 224a72 72 0 1 1 144 0zM176 384c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16zM424 224a72 72 0 1 1 -144 0 72 72 0 1 1 144 0z", "M160 248a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm192 0a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]]
}, faFlushed = faFaceFlushed, faHospitalUser = {
  prefix: "fad",
  iconName: "hospital-user",
  icon: [576, 512, [], "f80d", ["M0 48C0 21.5 21.5 0 48 0L272 0c26.5 0 48 21.5 48 48l0 223.8 0 95.9c-38.2 21.4-64 62.3-64 109.2c0 12.9 3.6 24.9 9.9 35.1L48 512c-26.5 0-48-21.5-48-48l0-80 144 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L0 352l0-64 144 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L0 256 0 48zm96 72l0 16c0 8.8 7.2 16 16 16l24 0 0 24c0 8.8 7.2 16 16 16l16 0c8.8 0 16-7.2 16-16l0-24 24 0c8.8 0 16-7.2 16-16l0-16c0-8.8-7.2-16-16-16l-24 0 0-24c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16l0 24-24 0c-8.8 0-16 7.2-16 16z", "M432 352a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm-50.9 32c-51.4 0-93.1 41.7-93.1 93.1c0 19.3 15.6 34.9 34.9 34.9l218.2 0c19.3 0 34.9-15.6 34.9-34.9c0-51.4-41.7-93.1-93.1-93.1l-101.8 0z"]]
}, faMicrowave = {
  prefix: "fad",
  iconName: "microwave",
  icon: [576, 512, [], "e01b", ["M96 152l0 176c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24l0-176c0-13.3-10.7-24-24-24l-272 0c-13.3 0-24 10.7-24 24z", "M0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l-320 0c0 17.7-14.3 32-32 32s-32-14.3-32-32c-35.3 0-64-28.7-64-64L0 96zm96 56l0 176c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24l0-176c0-13.3-10.7-24-24-24l-272 0c-13.3 0-24 10.7-24 24zm400-40c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16z"]]
}, faChfSign = {
  prefix: "fad",
  iconName: "chf-sign",
  icon: [640, 512, [], "e602", ["M192 64l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160 96 0 0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 160-96 0 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M0 113.4C0 68.5 36.5 32 81.4 32c30.8 0 59 17.4 72.8 45l2.3 4.7c7.9 15.8 1.5 35-14.3 42.9s-35 1.5-42.9-14.3L97 105.6c-3-5.9-9-9.6-15.6-9.6C71.8 96 64 103.8 64 113.4l0 285.1c0 9.6 7.8 17.4 17.4 17.4c6.6 0 12.6-3.7 15.6-9.6l2.3-4.7c7.9-15.8 27.1-22.2 42.9-14.3s22.2 27.1 14.3 42.9l-2.3 4.7c-13.8 27.6-42 45-72.8 45C36.5 480 0 443.5 0 398.6L0 113.4zM448 64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0 0 128 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0 0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-384z"]]
}, faTentArrowLeftRight = {
  prefix: "fad",
  iconName: "tent-arrow-left-right",
  icon: [576, 512, [], "e57f", ["M64.4 475.3c-1.4 9.2 1.3 18.6 7.4 25.6S86.7 512 96 512l144 0 16 0c17.7 0 32-14.3 32-32l0-118.1c0-5.5 4.4-9.9 9.9-9.9c3.7 0 7.2 2.1 8.8 5.5l68.4 136.8c5.4 10.8 16.5 17.7 28.6 17.7l60.2 0 16 0c9.3 0 18.2-4.1 24.2-11.1s8.8-16.4 7.4-25.6l-24-160c-1.2-8.2-5.6-15.7-12.3-20.7l-168-128c-5.7-4.4-12.6-6.5-19.4-6.5s-13.7 2.2-19.4 6.5l-168 128c-6.6 5-11 12.5-12.3 20.7l-24 160z", "M454.2 7.9c8.9-9.9 24-10.7 33.9-1.8l80 72c5.1 4.6 7.9 11 7.9 17.8s-2.9 13.3-7.9 17.8l-80 72c-9.9 8.9-25 8.1-33.9-1.8s-8.1-25 1.8-33.9L489.5 120 86.5 120l33.5 30.2c9.9 8.9 10.7 24 1.8 33.9s-24 10.7-33.9 1.8l-80-72C2.9 109.3 0 102.8 0 96s2.9-13.3 7.9-17.8l80-72c9.9-8.9 25-8.1 33.9 1.8s8.1 25-1.8 33.9L86.5 72l402.9 0L455.9 41.8c-9.9-8.9-10.7-24-1.8-33.9z"]]
}, faCartCircleArrowUp = {
  prefix: "fad",
  iconName: "cart-circle-arrow-up",
  icon: [640, 512, [], "e3f0", ["M0 24C0 37.3 10.7 48 24 48l45.5 0c3.8 0 7.1 2.7 7.9 6.5l51.6 271c6.5 34 36.2 58.5 70.7 58.5l121 0c-.5-5.3-.7-10.6-.7-16c0-10.9 1-21.6 2.9-32l-123.2 0c-11.5 0-21.4-8.2-23.6-19.5L170.7 288l168.5 0c29.1-57 88.4-96 156.8-96c14.8 0 29.1 1.8 42.8 5.2L569.7 82.4c.9-3.5 1.4-7 1.4-10.5c0-21.4-17.3-39.9-40-39.9l-411 0C111 12.8 91.6 0 69.5 0L24 0C10.7 0 0 10.7 0 24zM128 464a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M640 368a144 144 0 1 0 -288 0 144 144 0 1 0 288 0zM428.7 348.7l56-56c6.2-6.2 16.4-6.2 22.6 0l56 56c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L512 342.6l0 89.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-89.4-28.7 28.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6z"]]
}, faTrashClock = {
  prefix: "fad",
  iconName: "trash-clock",
  icon: [576, 512, [], "e2b0", ["M32 96L53.4 466.8c1.5 25.4 22.5 45.2 47.9 45.2l229.5 0C285.6 480.1 256 427.5 256 368c0-89.9 67.4-164 154.4-174.7L416 96 32 96z", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0L284.2 0c12.1 0 23.2 6.8 28.6 17.7L320 32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 7.2-14.3zM288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-48c0-8.8-7.2-16-16-16z"]]
}, faReflectBoth = {
  prefix: "fad",
  iconName: "reflect-both",
  icon: [512, 512, [], "e66f", ["M0 128L0 384c0 12.9 7.8 24.6 19.8 29.6c4 1.6 8.1 2.4 12.2 2.4c8.3 0 16.5-3.3 22.6-9.4l128-128c12.5-12.5 12.5-32.8 0-45.3l-128-128c-9.2-9.2-22.9-11.9-34.9-6.9S0 115.1 0 128zM329.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l128 128c6.1 6.1 14.3 9.4 22.6 9.4c4.1 0 8.3-.8 12.2-2.4c12-5 19.8-16.6 19.8-29.6l0-256c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-128 128z", "M413.6 19.8C408.6 7.8 396.9 0 384 0L128 0c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l128 128c12.5 12.5 32.8 12.5 45.3 0l128-128c9.2-9.2 11.9-22.9 6.9-34.9zM384 512c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-128-128c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l256 0z"]]
}, faGavel = {
  prefix: "fad",
  iconName: "gavel",
  icon: [512, 512, ["legal"], "f0e3", ["M0 432c0 8.2 3.1 16.4 9.4 22.6l48 48c6.2 6.2 14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4l112-112c12.5-12.5 12.5-32.8 0-45.3l-1.4-1.4 81.4-81.4c-15.1-15.1-30.2-30.2-45.3-45.3L168 298.7l-1.4-1.4c-12.5-12.5-32.8-12.5-45.3 0l-112 112C3.1 415.6 0 423.8 0 432z", "M273.4 9.4c12.5-12.5 32.8-12.5 45.3 0l16 16c12.5 12.5 12.5 32.8 0 45.3l-4 4L437.4 181.4l4-4c12.5-12.5 32.8-12.5 45.3 0l16 16c12.5 12.5 12.5 32.8 0 45.3l-120 120c-12.5 12.5-32.8 12.5-45.3 0l-16-16c-12.5-12.5-12.5-32.8 0-45.3l4-4L218.6 186.6l-4 4c-12.5 12.5-32.8 12.5-45.3 0l-16-16c-12.5-12.5-12.5-32.8 0-45.3l120-120z"]]
}, faLegal = faGavel, faSprinklerCeiling = {
  prefix: "fad",
  iconName: "sprinkler-ceiling",
  icon: [384, 512, [], "e44c", ["M0 472a24 24 0 1 0 48 0A24 24 0 1 0 0 472zm64-64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm48-64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 128a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm56-64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm56-64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 128a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm48-64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm64 64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M0 96c0 15.3 10.8 28.4 25.7 31.4L128 147.8l0-65.3L64 69.8 64 0 0 0 0 96zm256 51.8l102.3-20.5c15-3 25.7-16.1 25.7-31.4l0-96L320 0l0 69.8L256 82.6l0 65.3zM224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-128z"]]
}, faBrowsers = {
  prefix: "fad",
  iconName: "browsers",
  icon: [576, 512, [], "e0cb", ["M96 192l480 0 0 160c0 35.3-28.7 64-64 64l-352 0c-35.3 0-64-28.7-64-64l0-160zM224 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M160 0C124.7 0 96 28.7 96 64l0 128 480 0 0-128c0-35.3-28.7-64-64-64L160 0zm32 128a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm64-32c0-13.3 10.7-24 24-24l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24zM48 120c0-13.3-10.7-24-24-24S0 106.7 0 120L0 376c0 75.1 60.9 136 136 136l320 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-320 0c-48.6 0-88-39.4-88-88l0-256z"]]
}, faTrillium = {
  prefix: "fad",
  iconName: "trillium",
  icon: [448, 512, [], "e588", ["M-1.8 135.5c0-10.8 7.9-20.6 19.7-22.1c18.3-2.3 59.8-3.2 112.9 22.2c-.9 4-1.6 8.1-2.1 12.2c-.2 2-.4 4.1-.5 6.1c-.1 1-.1 2-.1 3.1s0 2 0 3.1c0 15.7 3.8 30.4 10.4 43.5c-16.3 0-32.7 4.2-47.8 12.9c-6.3 3.6-12.2 7.9-17.7 12.8C26.4 196.4 7 161 0 144.3c-1.2-2.9-1.8-5.9-1.8-8.9zM169 390.8c3-1.1 6-2.3 9-3.7c1.5-.7 2.9-1.4 4.3-2.1s2.8-1.5 4.2-2.3c16.6-9.6 29.2-23.3 37.4-39.2c8.1 15.8 20.8 29.6 37.4 39.2c5.6 3.2 11.5 5.9 17.7 8.2c-4.9 53.2-25.4 90.3-36 106.3c-9.1 13.7-28.8 13.7-37.9 0c-10.6-16-31.2-53.2-36-106.3zM309.6 203.5c6.6-13.1 10.4-27.8 10.4-43.5c0-8.2-1-16.3-2.8-24.4c53.1-25.4 94.6-24.5 112.9-22.2c11.7 1.5 19.7 11.3 19.7 22.1c0 2.9-.6 5.9-1.8 8.9c-7 16.7-26.4 52-73 84.9c-2.8-2.4-5.6-4.7-8.6-6.9c-1.5-1.1-3-2.1-4.5-3.1c-.8-.5-1.5-1-2.3-1.5s-1.6-.9-2.3-1.4c-15-8.7-31.5-12.8-47.7-12.9z", "M214.1 8.9C189.6 31.8 128 95.9 128 160c0 15.7 3.8 30.4 10.4 43.5c-16.3 0-32.7 4.2-47.8 12.9c-55.5 32-80.2 117.5-87.8 150.2c-1.8 7.5 2.5 14.9 9.9 17.1c32.1 9.7 118.4 31.1 173.9-1c16.6-9.6 29.2-23.3 37.4-39.2c8.1 15.8 20.8 29.6 37.4 39.2c55.5 32 141.8 10.7 173.9 1c7.4-2.2 11.6-9.6 9.9-17.1c-7.6-32.7-32.3-118.1-87.8-150.2c-15-8.7-31.5-12.8-47.7-12.9c6.6-13.1 10.4-27.8 10.4-43.5c0-64.1-61.6-128.2-86.1-151.1c-5.6-5.3-14.1-5.3-19.8 0zM224 200a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]]
}, faTableCellsUnlock = {
  prefix: "fad",
  iconName: "table-cells-unlock",
  icon: [640, 512, [], "e692", ["M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 65.1c-37.8 5.4-69.4 29.6-85.2 62.9L360 224l0 64 56 0 0 8.6c-19.1 11.1-32 31.7-32 55.4l-24 0 0 64 24 0 0 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 0l0 64 88 0 0-64L64 96zm0 128l0 64 88 0 0-64-88 0zm0 128l0 64 88 0 0-64-88 0zM208 96l0 64 88 0 0-64-88 0zm0 128l0 64 88 0 0-64-88 0zm0 128l0 64 88 0 0-64-88 0zM360 96l0 64 88 0 0-64-88 0z", "M528 240c-17.7 0-32 14.3-32 32l0 48 32 0 32 0 48 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l-48 0c0-17.7-14.3-32-32-32z"]]
}, faMusicSlash = {
  prefix: "fad",
  iconName: "music-slash",
  icon: [640, 512, [], "f8d1", ["M64 432c0 44.2 43 80 96 80s96-35.8 96-80l0-134.3-64-50.4 0 109.3c-10-3-20.8-4.6-32-4.6c-53 0-96 35.8-96 80zM192.1 125.3c36.2 28.4 72.4 56.7 108.6 85.1L512 147l0 145.5c-10-2.9-20.8-4.6-32-4.6c-22.2 0-42.6 6.3-58.8 16.8c46.1 36.1 92.1 72.2 138.2 108.3C569.8 400.2 576 384.7 576 368l0-264 0-72c0-10.1-4.8-19.6-12.9-25.7C557.5 2.2 550.8 0 544 0c-3.1 0-6.2 .4-9.2 1.3l-320 96c-12.7 3.8-21.6 14.9-22.7 27.9z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faTruckRamp = {
  prefix: "fad",
  iconName: "truck-ramp",
  icon: [640, 512, [], "f4e0", ["M448 416a96 96 0 1 0 192 0 96 96 0 1 0 -192 0z", "M416.7 402.5C423.4 338.2 477.9 288 544 288c38.2 0 72.5 16.8 96 43.3L640 0 416 0c-35.3 0-64 28.7-64 64l0 289.8L31.6 441.1c-17.1 4.6-27.1 22.2-22.5 39.3s22.2 27.1 39.3 22.5L416.7 402.5z"]]
}, faBinoculars = {
  prefix: "fad",
  iconName: "binoculars",
  icon: [512, 512, [], "f1e5", ["M96 64l0 32 96 0 0-32c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32zM224 96l0 160 64 0 0-160-64 0zm96-32l0 32 96 0 0-32c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32z", "M192 448l0-192 32 0 0-160-32 0L93 96c-16.4 0-30.2 12.5-31.8 28.8l-9 89.7c-2.7 27.3-11.5 53.7-25.6 77.3C9.2 320.7 0 353.8 0 387.6L0 448c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32zm128 0c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-60.4c0-33.8-9.2-66.9-26.5-95.8c-14.1-23.6-22.9-49.9-25.6-77.3l-9-89.7C449.2 108.5 435.5 96 419 96l-99 0-32 0 0 160 32 0 0 192z"]]
}, faMicrophoneSlash = {
  prefix: "fad",
  iconName: "microphone-slash",
  icon: [640, 512, [], "f131", ["M144 216l0 40c0 89.1 66.2 162.7 152 174.4l0 33.6-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-33.6c20.4-2.8 39.7-9.1 57.3-18.2l-43.1-33.9C346.1 382 333.3 384 320 384c-70.7 0-128-57.3-128-128l0-8.7L144.7 210c-.5 1.9-.7 3.9-.7 6zM224 96l0 54.3c61.3 48.1 122.7 96.1 184 144.2c5.2-11.8 8-24.8 8-38.5l0-160c0-53-43-96-96-96s-96 43-96 96zM433.8 314.7c12.8 10 25.5 20 38.3 30c15.2-26 23.9-56.3 23.9-88.7l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 21.2-5.1 41.1-14.2 58.7z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faBoxTissue = {
  prefix: "fad",
  iconName: "box-tissue",
  icon: [512, 512, [], "e05b", ["M0 272L0 384l512 0 0-112c0-26.5-21.5-48-48-48l-58.7 0L384 288l48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-58.7 0-238.2 0L80 320c-8.8 0-16-7.2-16-16s7.2-16 16-16l48 0c-4.7-21.3-9.5-42.7-14.2-64L48 224c-26.5 0-48 21.5-48 48z", "M103.9 0L208 0c40 0 52 24 64 48s24 48 64 48l67.6 0c21.8 0 37.3 21.4 30.4 42.1L373.3 320l-238.2 0L72.7 38.9C68.2 19 83.4 0 103.9 0zM512 384l0 80c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48l0-80 512 0z"]]
}, faCircleC = {
  prefix: "fad",
  iconName: "circle-c",
  icon: [512, 512, [], "e101", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128 0c0-32.8 12.5-65.5 37.5-90.5s57.8-37.5 90.5-37.5s65.5 12.5 90.5 37.5c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17c-9.4 9.4-24.6 9.4-34 0l-.4-.4c-31.3-30.8-81.6-30.7-112.7 .4c-31.2 31.2-31.2 81.9 0 113.1s81.9 31.2 113.1 0c9.4-9.4 24.6-9.4 33.9 0c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17c-25 25-57.8 37.5-90.5 37.5s-65.5-12.5-90.5-37.5s-37.5-57.8-37.5-90.5z", "M312.6 199.4c-31.2-31.2-81.9-31.2-113.1 0s-31.2 81.9 0 113.1s81.9 31.2 113.1 0c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9c-50 50-131 50-181 0s-50-131 0-181s131-50 181 0c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0z"]]
}, faStarChristmas = {
  prefix: "fad",
  iconName: "star-christmas",
  icon: [512, 512, [], "f7d4", ["M64 88c0 6.1 2.3 12.3 7 17l48 48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L105 71c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7s-7 10.8-7 17zm0 336c0 6.1 2.3 12.3 7 17s10.8 7 17 7s12.3-2.3 17-7l48-48c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L71 407c-4.7 4.7-7 10.8-7 17zM359 119c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l48-48c4.7-4.7 7-10.8 7-17s-2.3-12.3-7-17s-10.8-7-17-7s-12.3 2.3-17 7l-48 48zm0 240c-9.4 9.4-9.4 24.6 0 33.9l48 48c4.7 4.7 10.8 7 17 7s12.3-2.3 17-7s7-10.8 7-17s-2.3-12.3-7-17l-48-48c-9.4-9.4-24.6-9.4-33.9 0z", "M192 320L15.5 275.9C6.4 273.6 0 265.4 0 256s6.4-17.6 15.5-19.9L192 192 236.1 15.5C238.4 6.4 246.6 0 256 0s17.6 6.4 19.9 15.5L320 192l176.5 44.1c9.1 2.3 15.5 10.5 15.5 19.9s-6.4 17.6-15.5 19.9L320 320 275.9 496.5c-2.3 9.1-10.5 15.5-19.9 15.5s-17.6-6.4-19.9-15.5L192 320z"]]
}, faChartBullet = {
  prefix: "fad",
  iconName: "chart-bullet",
  icon: [512, 512, [], "e0e1", ["M160 64l0 64 80 0 0-64-80 0zm0 96l0 64 80 0 0-64-80 0zm96 128l0 64 80 0 0-64-80 0zm0 96l0 64 80 0 0-64-80 0zM288 64l0 64 160 0 0 32-160 0 0 64 176 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48L288 64zm96 224l0 64 64 0 0 32-64 0 0 64 80 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-80 0z", "M264 32c-13.3 0-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176c0-13.3-10.7-24-24-24zM48 64C21.5 64 0 85.5 0 112l0 64c0 26.5 21.5 48 48 48l112 0 0-160L48 64zm0 224c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l208 0 0-160L48 288zm336-8c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176z"]]
}, faMotorcycle = {
  prefix: "fad",
  iconName: "motorcycle",
  icon: [640, 512, [127949], "f21c", ["M0 352c0-70.7 57.3-128 128-128c62.5 0 114.5 44.8 125.8 104l-66.4 0c-9.5-23.5-32.5-40-59.3-40c-35.3 0-64 28.7-64 64s28.7 64 64 64c26.9 0 49.9-16.5 59.3-40l66.4 0C242.5 435.2 190.5 480 128 480C57.3 480 0 422.7 0 352zm384 0c0-40 18.4-75.7 47.1-99.2c10.5 19.5 21.1 38.9 31.6 58.4C453.5 322.3 448 336.5 448 352c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64c-2.4 0-4.8 .1-7.1 .4c-10.5-19.5-21.1-39-31.6-58.4c12.2-3.9 25.2-6 38.7-6c70.7 0 128 57.3 128 128s-57.3 128-128 128s-128-57.3-128-128z", "M280 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l57.7 0 16.4 30.3L256 192l-45.3-45.3c-12-12-28.3-18.7-45.3-18.7L64 128c-17.7 0-32 14.3-32 32l0 32 96 0c88.4 0 160 71.6 160 160c0 11-1.1 21.7-3.2 32l70.4 0c-2.1-10.3-3.2-21-3.2-32c0-52.2 25-98.6 63.7-127.8l75.2 139.2c6.3 11.7 20.9 16 32.5 9.7s16-20.9 9.7-32.5L418.2 128l61.8 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32l-20.4 0c-7.5 0-14.7 2.6-20.5 7.4L391.7 78.9l-14-26c-7-12.9-20.5-21-35.2-21L280 32zM128 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faTreeChristmas = {
  prefix: "fad",
  iconName: "tree-christmas",
  icon: [448, 512, [127876], "f7db", ["M0 487.1C0 500.9 11.1 512 24.9 512l398.3 0c13.7 0 24.9-11.1 24.9-24.9c0-4.7-1.3-9.2-3.8-13.2L368 352l32.3 0c13.1 0 23.7-10.6 23.7-23.7c0-5.4-1.8-10.6-5.2-14.8L252.7 105.9c-.7 .3-1.4 .5-2.1 .8c-5.9 15.7-11.8 31.4-17.7 47.1c-1.4 3.8-5 6.2-9 6.2s-7.6-2.5-9-6.2c-5.9-15.7-11.8-31.4-17.7-47.1c-.7-.3-1.4-.5-2.1-.8L29.2 313.5c-3.4 4.2-5.2 9.4-5.2 14.8C24 341.4 34.6 352 47.7 352L80 352 3.8 474c-2.5 4-3.8 8.5-3.8 13.2zM184 288a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm80 128c0-.4 0-.8 0 0z", "M150.2 71l47.1-17.7L215 6.2c1.4-3.8 5-6.2 9-6.2s7.6 2.5 9 6.2l17.7 47.1L297.8 71c3.8 1.4 6.2 5 6.2 9s-2.5 7.6-6.2 9l-47.1 17.7L233 153.8c-1.4 3.8-5 6.2-9 6.2s-7.6-2.5-9-6.2l-17.7-47.1L150.2 89c-3.8-1.4-6.2-5-6.2-9s2.5-7.6 6.2-9zM288 392a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faTireFlat = {
  prefix: "fad",
  iconName: "tire-flat",
  icon: [512, 512, [], "f632", ["M96 288c0 52.3 25.1 98.8 64 128c26.7 20.1 60 32 96 32c33.1 0 63.9-10.1 89.5-27.3c2.2-1.5 4.4-3.1 6.6-4.7c38.9-29.2 64-75.7 64-128c0-88.4-71.6-160-160-160s-160 71.6-160 160zm32 0c0-36.8 15.5-69.9 40.3-93.3l28.1 38.7 10.1 13.9c-9.1 11-14.5 25.2-14.5 40.6c0 1.4 0 2.7 .1 4l-61.8 20.1c-1.5-7.8-2.3-15.9-2.3-24.2zm12.2 54.6l61.9-20.1c8.6 13.4 22.1 23.4 37.9 27.5l0 65c-44.2-5.5-81.5-33.6-99.8-72.4zm54-166.7C212.5 165.8 233.6 160 256 160s43.5 5.8 61.8 15.9l-38.2 52.6c-7.3-2.9-15.3-4.5-23.6-4.5s-16.3 1.6-23.6 4.5l-10-13.8-28.1-38.8zM288 288a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-16.1 62c15.9-4.1 29.4-14.1 38-27.6l61.9 20.1c-18.3 38.8-55.6 66.9-99.8 72.4l0-65zm33.5-102.6l38.2-52.6C368.5 218.1 384 251.2 384 288c0 8.3-.8 16.3-2.3 24.2L319.9 292c.1-1.3 .1-2.7 .1-4c0-15.4-5.5-29.6-14.5-40.6z", "M0 288C0 146.6 114.6 32 256 32s256 114.6 256 256c0 47.3-12.8 91.7-35.2 129.7c20.3 5.6 35.2 24.2 35.2 46.3c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48c0-22.1 14.9-40.7 35.2-46.3C12.8 379.7 0 335.3 0 288zm416 0c0-88.4-71.6-160-160-160s-160 71.6-160 160c0 52.3 25.1 98.8 64 128c26.7 20.1 60 32 96 32c33.1 0 63.9-10.1 89.5-27.3c2.2-1.5 4.4-3.1 6.6-4.7c38.9-29.2 64-75.7 64-128zM256 256a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]]
}, faSunglasses = {
  prefix: "fad",
  iconName: "sunglasses",
  icon: [576, 512, [128374], "f892", ["M48.5 375.8C52.3 407.5 79.3 432 112 432l44.3 0c34 0 62-26.5 63.9-60.4c1.1-19.2 2.1-38.4 3.2-57.5c-9.8-4.2-20.1-7.7-30.5-10.4L48.5 375.8zM356 374c3.1 32.7 30.6 58 63.7 58l44.3 0c35.3 0 64-28.7 64-64l0-53.8c-9.9-4.3-20.3-7.9-31-10.7L356 374z", "M118.6 80c-11.5 0-21.4 7.9-24 19.1L57.1 259.8c25.6-7.8 52.6-11.8 78.6-11.8c40.1 0 82.2 9.6 118.5 27.3c5.8 2.9 10.4 7.3 13.5 12.7l40.6 0c3.1-5.4 7.7-9.8 13.5-12.7c36.2-17.8 78.4-27.3 118.5-27.3c26 0 53 4.1 78.6 11.8L481.4 99.1c-2.6-11.2-12.6-19.1-24-19.1c-3.1 0-6.2 .6-9.2 1.8L416.9 94.3c-12.3 4.9-26.3-1.1-31.2-13.4s1.1-26.3 13.4-31.2l31.3-12.5c8.6-3.4 17.7-5.2 27-5.2c33.8 0 63.1 23.3 70.8 56.2l43.9 188c1.7 7.3 2.9 14.7 3.5 22.2c.3 1.8 .5 3.7 .5 5.6l0 5.2c0 .5 0 1 0 1.5l0 41.3c0 .2 0 .4 0 .6l0 15.4c0 61.9-50.1 112-112 112l-44.3 0c-59.4 0-108.5-46.4-111.8-105.8L306.6 352l-37.2 0-1.2 22.2C264.9 433.6 215.8 480 156.3 480L112 480C50.1 480 0 429.9 0 368l0-16 0-41.3L0 304c0-1.9 .2-3.8 .5-5.7c.6-7.4 1.8-14.8 3.5-22.1l43.9-188C55.5 55.3 84.8 32 118.6 32c9.2 0 18.4 1.8 27 5.2l31.3 12.5c12.3 4.9 18.3 18.9 13.4 31.2s-18.9 18.3-31.2 13.4L127.8 81.8c-2.9-1.2-6-1.8-9.2-1.8zM48 352l0 16c0 35.3 28.7 64 64 64l44.3 0c34 0 62-26.5 63.9-60.5l3.2-57.5c-27.3-11.7-58.3-18-87.7-18c-29.5 0-60.5 6.4-87.7 18.2L48 352zm392.3-56c-29.4 0-60.4 6.3-87.7 18l3.2 57.5c1.9 33.9 29.9 60.5 63.9 60.5l44.3 0c35.3 0 64-28.7 64-64l0-53.8c-27.2-11.8-58.2-18.2-87.7-18.2z"]]
}, faBadge = {
  prefix: "fad",
  iconName: "badge",
  icon: [512, 512, [], "f335", ["M340.9 51.1C324.8 20.7 292.8 0 256 0s-68.8 20.7-84.9 51.1C138.2 41 101 49 75 75s-34 63.3-23.9 96.1C20.7 187.2 0 219.2 0 256s20.7 68.8 51.1 84.9C41 373.8 49 411 75 437s63.3 34 96.1 23.9C187.2 491.3 219.2 512 256 512s68.8-20.7 84.9-51.1C373.8 471 411 463 437 437s34-63.3 23.9-96.1C491.3 324.8 512 292.8 512 256s-20.7-68.8-51.1-84.9C471 138.2 463 101 437 75s-63.3-34-96.1-23.9z", ""]]
}, faMessagePen = {
  prefix: "fad",
  iconName: "message-pen",
  icon: [512, 512, ["comment-alt-edit", "message-edit"], "f4a4", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM160 287.9c0 4.2 1.6 8.3 4.7 11.3s7.1 4.7 11.3 4.7c1.3 0 2.6-.2 3.9-.5c12.2-3.1 24.4-6.1 36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4c24-24 47.9-48 71.9-71.9L250 160.6c-24 24-47.9 48-71.9 71.9c-4.1 4.1-7 9.2-8.4 14.9c-3.1 12.2-6.1 24.4-9.2 36.7c-.3 1.3-.5 2.6-.5 3.9zM272.6 138c17.8 17.8 35.6 35.6 53.3 53.3c5-5 9.9-9.9 14.9-14.9c7.4-7.4 11-17 11-26.7s-3.7-19.3-11-26.7c-14.7-14.7-38.6-14.7-53.3 0c-5 5-9.9 9.9-14.9 14.9z", "M287.5 123L272.6 138l53.3 53.3 14.9-14.9c14.7-14.7 14.7-38.6 0-53.3s-38.6-14.7-53.3 0zM250 160.6l-71.9 71.9c-4.1 4.1-7 9.2-8.4 14.9L160.5 284c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4l71.9-71.9L250 160.6z"]]
}, faCommentAltEdit = faMessagePen, faMessageEdit = faMessagePen, faBellConcierge = {
  prefix: "fad",
  iconName: "bell-concierge",
  icon: [512, 512, [128718, "concierge-bell"], "f562", ["M0 424c0 13.3 10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0L32 400l-8 0c-13.3 0-24 10.7-24 24zM192 88c0 13.3 10.7 24 24 24l16 0 0 33.3c7.9-.8 15.9-1.3 24-1.3c2 0 4 0 6.1 .1s4 .1 6 .2c4 .2 8 .5 11.9 1l0-33.3 16 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0-40 0c-13.3 0-24 10.7-24 24z", "M480 368c0-123.7-100.3-224-224-224S32 244.3 32 368v32H480V368z"]]
}, faConciergeBell = faBellConcierge, faPenRuler = {
  prefix: "fad",
  iconName: "pen-ruler",
  icon: [512, 512, ["pencil-ruler"], "f5ae", ["M16 94.1c-18.7 18.7-18.7 49.1 0 67.9l87.4 87.4L249.4 103.4 204.2 58.3c-.3 .3-.6 .7-.9 1l-64 64c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l64-64c.3-.3 .7-.6 1-.9L161.9 16C152.6 6.6 140.3 1.9 128 1.9s-24.6 4.7-33.9 14.1L16 94.1zM262.6 408.6L350.1 496c9.4 9.4 21.7 14.1 33.9 14.1s24.6-4.7 33.9-14.1L496 417.9c18.7-18.7 18.7-49.1 0-67.9l-19.8-19.8c-.3 .3-.6 .7-.9 1l-64 64c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l64-64c.3-.3 .7-.6 1-.9l-45.1-45.1L262.6 408.6z", "M378.7 19.3L322.3 75.7 436.3 189.7l56.4-56.4c25-25 25-65.5 0-90.5L469.3 19.3c-25-25-65.5-25-90.5 0zm-79 79L44.9 353.2c-6.7 6.7-11.6 15.1-14.2 24.2L.9 481.4C-1.5 489.8 .9 498.8 7 505s15.2 8.5 23.6 6.1l104-29.7c9.2-2.6 17.5-7.5 24.2-14.2L413.7 212.3 299.7 98.3z"]]
}, faPencilRuler = faPenRuler, faFileMp3 = {
  prefix: "fad",
  iconName: "file-mp3",
  icon: [512, 512, [], "e648", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-240 0c-35.3 0-64 28.7-64 64l0 144-16 0c-35.3 0-64-28.7-64-64L0 64z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM139.7 352.6c-6.9 1.9-11.7 8.2-11.7 15.4l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-70.2 18.3 30.5c2.9 4.8 8.1 7.8 13.7 7.8s10.8-3 13.7-7.8L224 425.8l0 70.2c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-7.2-4.8-13.5-11.7-15.4s-14.3 1-18 7.2L192 416.9l-34.3-57.1c-3.7-6.2-11.1-9.1-18-7.2zM288 368l0 80 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 16 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-32 0c-8.8 0-16 7.2-16 16zm32 64l0-48 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0zm144 80c26.5 0 48-21.5 48-48c0-12.3-4.6-23.5-12.2-32c7.6-8.5 12.2-19.7 12.2-32c0-26.5-21.5-48-48-48l-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-24 0c-8.3 0-15.1 6.3-15.9 14.4c-.1 .5-.1 1.1-.1 1.6c0 8.8 7.2 16 16 16l24 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0z"]]
}, faArrowProgress = {
  prefix: "fad",
  iconName: "arrow-progress",
  icon: [512, 512, [], "e5df", ["M0 448c0 35.3 28.7 64 64 64c23.7 0 44.4-12.9 55.4-32l40.6 0 0 14.1c0 9.9 8 17.9 17.9 17.9c4 0 7.8-1.3 11-3.8l60.8-47.3c4-3.1 6.3-7.9 6.3-12.9s-2.3-9.8-6.3-12.9l-60.8-47.3c-3.1-2.4-7-3.8-11-3.8c-9.9 0-17.9 8-17.9 17.9l0 14.1-40.6 0c-11.1-19.1-31.7-32-55.4-32c-35.3 0-64 28.7-64 64zM384 64a64 64 0 1 0 128 0A64 64 0 1 0 384 64z", "M256 110.1L256 96 128 96c-35.3 0-64 28.7-64 64s28.7 64 64 64l256 0c70.7 0 128 57.3 128 128c0 62.2-44.4 114.1-103.2 125.6C398.1 498 376.7 512 352 512c-35.3 0-64-28.7-64-64s28.7-64 64-64c22.2 0 41.7 11.3 53.2 28.4c24.9-8.7 42.8-32.5 42.8-60.4c0-35.3-28.7-64-64-64l-256 0C57.3 288 0 230.7 0 160S57.3 32 128 32l128 0 0-14.1C256 8 264 0 273.9 0c4 0 7.8 1.3 11 3.8l60.8 47.3c4 3.1 6.3 7.9 6.3 12.9s-2.3 9.8-6.3 12.9l-60.8 47.3c-3.1 2.4-7 3.8-11 3.8c-9.9 0-17.9-8-17.9-17.9z"]]
}, faChessRookPiece = {
  prefix: "fad",
  iconName: "chess-rook-piece",
  icon: [320, 512, ["chess-rook-alt"], "f448", ["M0 488c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24c0-5.2-1.7-10.2-4.8-14.4L272 416 48 416 4.8 473.6C1.7 477.8 0 482.8 0 488z", "M48 416L72 264 47 232.8c-4.5-5.7-7-12.7-7-20L40 112c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 24c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-24c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 24c0 4.4 3.6 8 8 8l16 0c4.4 0 8-3.6 8-8l0-24c0-8.8 7.2-16 16-16l24 0c8.8 0 16 7.2 16 16l0 100.8c0 7.3-2.5 14.3-7 20L248 264l24 152L48 416zm88-135.1c0 3.9 3.2 7.1 7.1 7.1l33.8 0c3.9 0 7.1-3.2 7.1-7.1l0-32.9c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32.9z"]]
}, faChessRookAlt = faChessRookPiece, faSquareRoot = {
  prefix: "fad",
  iconName: "square-root",
  icon: [576, 512, [8730], "f697", ["M282.6 78.1c8-27.3 33-46.1 61.4-46.1l200 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L344 96 238.7 457c-3.6 12.3-14.1 21.2-26.8 22.8s-25.1-4.6-31.5-15.6L77.6 288 32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l45.6 0c22.8 0 43.8 12.1 55.3 31.8l65.2 111.8L282.6 78.1z", ""]]
}, faAlbumCollectionCirclePlus = {
  prefix: "fad",
  iconName: "album-collection-circle-plus",
  icon: [640, 512, [], "e48e", ["M.4 214l32 256c3 24 23.4 42 47.6 42l314.8 0c-18.9-13.3-35.1-30.3-47.5-49.9c-26.9 11.4-58 17.9-91.3 17.9C154.4 480 72 419.1 72 344s82.4-136 184-136c45.4 0 86.9 12.1 119 32.2c31.5-29.9 74.2-48.2 121-48.2c4.5 0 9 .2 13.4 .5c-2-5.9-5.2-11.5-9.4-16.3c-9.1-10.3-22.2-16.2-36-16.2L48 160c-13.8 0-26.9 5.9-36 16.2S-1.3 200.3 .4 214zM16 104c0 13.3 10.7 24 24 24l432 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L40 80c-13.3 0-24 10.7-24 24zM32 24c0 13.3 10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L56 0C42.7 0 32 10.7 32 24zM224 352c0 13.3 14.3 24 32 24s32-10.7 32-24s-14.3-24-32-24s-32 10.7-32 24z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16z"]]
}, faPeopleArrows = {
  prefix: "fad",
  iconName: "people-arrows",
  icon: [640, 512, ["people-arrows-left-right"], "e068", ["M21.8 282.7c-.2 1.8-.2 3.6-.2 5.4c0 27.5 17.6 51.3 42.4 60.2L64 464c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-115.7c.6-.2 1.1-.4 1.7-.6c-8.9-8.9-17.8-17.8-26.7-26.7c-2.3-2.3-4.1-5.1-5.3-7.9c-.6-1.4-1-2.9-1.3-4.4c-.1-.8-.3-1.5-.3-2.3c-.1-.8-.1-1.5-.1-2.3c0-.8 0-1.5 .1-2.3s.2-1.5 .3-2.3c.3-1.5 .7-3 1.3-4.4c1.2-2.9 2.9-5.6 5.3-7.9c20.7-20.7 41.3-41.3 62-62c-7.1-37.4-39.8-65.1-78.6-65.1l-44.8 0c-41.6 0-76.3 31.9-79.7 73.4l-4.1 49.3zM64 64a64 64 0 1 0 128 0A64 64 0 1 0 64 64zM411 225.1l62 62c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17c-8.9 8.9-17.8 17.8-25.8 27c.3 .1 .6 .2 .9 .3L448 464c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-115.7c26.5-9.5 44.7-35.8 42.2-65.6l-4.1-49.3C610.7 191.9 576 160 534.4 160l-44.8 0c-38.8 0-71.5 27.7-78.6 65.1zM448 64a64 64 0 1 0 128 0A64 64 0 1 0 448 64z", "M257.2 217.8c9 3.7 14.8 12.5 14.8 22.2l0 32 96 0 0-32c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l64 64c9.4 9.4 9.4 24.6 0 33.9l-64 64c-6.9 6.9-17.2 8.9-26.2 5.2s-14.8-12.5-14.8-22.2l0-32-96 0 0 32c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-64-64c-9.4-9.4-9.4-24.6 0-33.9l64-64c6.9-6.9 17.2-8.9 26.2-5.2z"]]
}, faPeopleArrowsLeftRight = faPeopleArrows, faSignPost = {
  prefix: "fad",
  iconName: "sign-post",
  icon: [512, 512, [], "e624", ["M224 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32-64 0 0-32zm0 224l64 0 0 224c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-224z", "M441.6 75.5l61.9 74.2c4.9 5.9 4.9 14.6 0 20.5l-61.9 74.2c-6.1 7.3-15.1 11.5-24.6 11.5H64c-17.7 0-32-14.3-32-32V96c0-17.7 14.3-32 32-32H417c9.5 0 18.5 4.2 24.6 11.5z"]]
}, faFaceAngryHorns = {
  prefix: "fad",
  iconName: "face-angry-horns",
  icon: [640, 512, [], "e368", ["M64 256c0-24.6 3.5-48.4 9.9-70.9C89.5 131 122.4 84.3 166.2 51.3C209.1 19.1 262.3 0 320 0s110.9 19.1 153.8 51.3c43.8 33 76.7 79.7 92.3 133.8c6.5 22.5 9.9 46.3 9.9 70.9c0 141.4-114.6 256-256 256S64 397.4 64 256zm112.8-37.1c-2.8 8.4 1.7 17.4 10.1 20.2l30.7 10.2c-5.8 5.8-9.3 13.8-9.3 22.6c0 17.7 14.3 32 32 32s32-14.3 32-32c0-1.5-.1-3-.3-4.4l10.9 3.6c8.4 2.8 17.4-1.7 20.2-10.1s-1.7-17.4-10.1-20.2l-96-32c-8.4-2.8-17.4 1.7-20.2 10.1zm59.3 170.4c-5.9 6.6-5.4 16.7 1.2 22.6s16.7 5.4 22.6-1.2c11.7-13 31.6-26.7 60.1-26.7s48.4 13.7 60.1 26.7c5.9 6.6 16 7.1 22.6 1.2s7.1-16 1.2-22.6C387.8 371.4 359.7 352 320 352s-67.8 19.4-83.9 37.3zM336.8 261.1c2.8 8.4 11.9 12.9 20.2 10.1l11.7-3.9c-.2 1.5-.3 3.1-.3 4.7c0 17.7 14.3 32 32 32s32-14.3 32-32c0-8.9-3.6-17-9.5-22.8l30.2-10.1c8.4-2.8 12.9-11.9 10.1-20.2s-11.9-12.9-20.2-10.1l-96 32c-8.4 2.8-12.9 11.9-10.1 20.2z", "M566.1 185.1C550.5 131 517.6 84.3 473.8 51.3c17-3.3 39.7-8.6 63-15.5c29.8-8.9 59.1-20.2 78.4-33.1c5.4-3.6 12.4-3.6 17.8 0s8.1 10.1 6.8 16.4c-6.2 31-29.3 106.6-73.6 166zM103.3 35.8c23.3 7 46 12.2 63 15.5c-43.8 33-76.7 79.7-92.3 133.8C29.6 125.8 6.5 50.1 .3 19.1C-1 12.8 1.7 6.3 7.1 2.7s12.4-3.6 17.8 0c19.3 12.9 48.5 24.2 78.4 33.1zM240.4 304c-17.7 0-32-14.3-32-32c0-8.8 3.6-16.8 9.3-22.6l-30.7-10.2c-8.4-2.8-12.9-11.9-10.1-20.2s11.9-12.9 20.2-10.1l96 32c8.4 2.8 12.9 11.9 10.1 20.2s-11.9 12.9-20.2 10.1l-10.9-3.6c.2 1.5 .3 2.9 .3 4.4c0 17.7-14.3 32-32 32zm192-32c0 17.7-14.3 32-32 32s-32-14.3-32-32c0-1.6 .1-3.2 .3-4.7l-11.7 3.9c-8.4 2.8-17.4-1.7-20.2-10.1s1.7-17.4 10.1-20.2l96-32c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2l-30.2 10.1c5.9 5.8 9.5 13.9 9.5 22.8z"]]
}, faMarsAndVenusBurst = {
  prefix: "fad",
  iconName: "mars-and-venus-burst",
  icon: [640, 512, [], "e523", ["M4 219.6c0 1.2 .1 2.4 .4 3.6c1.5 6.4 6.7 11.2 13.1 12.2l78.7 12.2L90.6 327c-.5 6.5 3.1 12.7 9 15.5s12.9 1.8 17.8-2.6L176 286.1l58.6 53.9c4.8 4.4 11.9 5.5 17.8 2.6s9.5-9 9-15.5l-1.9-26.4C247.1 277.9 240 251.8 240 224c0-1.8 0-3.6 .1-5.4s.1-3.6 .3-5.4c.2-3.6 .6-7.1 1.1-10.6c.9-7 2.3-13.8 4.1-20.5c3.6-13.3 8.9-26 15.6-37.7c13.4-23.4 32.6-43.1 55.7-57.2c.9-4.5-.2-9.3-3.2-13c-4.1-5.1-10.9-7.2-17.2-5.3L220.3 92.1l-29.4-74C188.4 12 182.6 8 176 8s-12.4 4-14.9 10.1l-29.4 74L55.6 68.9c-6.3-1.9-13.1 .2-17.2 5.3s-4.6 12.2-1.4 17.9l39.5 69.1L10.9 206.4c-4.4 3-6.9 8-6.9 13.2z", "M481.8 14.8C485.5 5.8 494.3 0 504 0L616 0c13.3 0 24 10.7 24 24l0 112c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-39-39-24.7 24.7C551 163.3 560 192.6 560 224c0 80.2-59 146.6-136 158.2l0 25.8 24 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-24 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32-24 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l24 0 0-25.8c-77-11.6-136-78-136-158.2c0-88.4 71.6-160 160-160c39.6 0 75.9 14.4 103.8 38.2L526.1 80 487 41c-6.9-6.9-8.9-17.2-5.2-26.2zM592 48s0 0 0 0s0 0 0 0s0 0 0 0zM496 224a96 96 0 1 0 -192 0 96 96 0 1 0 192 0z"]]
}, faTombstone = {
  prefix: "fad",
  iconName: "tombstone",
  icon: [448, 512, [], "f720", ["M32 192l0 256 384 0 0-256C416 86 330 0 224 0S32 86 32 192zm96 24c0-13.3 10.7-24 24-24l48 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120-48 0c-13.3 0-24-10.7-24-24z", "M248 152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 120c0 13.3 10.7 24 24 24s24-10.7 24-24l0-120 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-40zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448z"]]
}, faSquareCaretRight = {
  prefix: "fad",
  iconName: "square-caret-right",
  icon: [448, 512, ["caret-square-right"], "f152", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm160 56c0-9.5 5.7-18.2 14.4-22c3.1-1.3 6.3-2 9.6-2c5.9 0 11.8 2.2 16.3 6.4l112 104c4.9 4.5 7.7 10.9 7.7 17.6s-2.8 13-7.7 17.6l-112 104c-4.5 4.2-10.4 6.4-16.3 6.4c-3.2 0-6.5-.7-9.6-2c-8.7-3.8-14.4-12.5-14.4-22l0-208z", "M312.3 273.6c4.9-4.5 7.7-10.9 7.7-17.6s-2.8-13-7.7-17.6l-112-104c-7-6.5-17.2-8.2-25.9-4.4s-14.4 12.5-14.4 22l0 208c0 9.5 5.7 18.2 14.4 22s18.9 2.1 25.9-4.4l112-104z"]]
}, faCaretSquareRight = faSquareCaretRight, faScissors = {
  prefix: "fad",
  iconName: "scissors",
  icon: [512, 512, [9984, 9986, 9988, "cut"], "f0c4", ["M0 112c0 61.9 50.1 112 112 112c14.3 0 27.9-2.7 40.5-7.5L192 256c21.3-21.3 42.7-42.7 64-64l-39.5-39.5c4.9-12.6 7.5-26.2 7.5-40.5C224 50.1 173.9 0 112 0S0 50.1 0 112zm160 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm96 208L396.8 460.8C410.9 474.9 429.5 482 448 482s37.1-7.1 51.2-21.2c3.5-3.5 5.3-8.2 5.3-12.8s-1.8-9.3-5.3-12.8L320 256l-64 64z", "M216.5 359.5L499.2 76.8c7.1-7.1 7.1-18.5 0-25.6c-28.3-28.3-74.1-28.3-102.4 0L152.5 295.5c-12.6-4.9-26.2-7.5-40.5-7.5C50.1 288 0 338.1 0 400s50.1 112 112 112s112-50.1 112-112c0-14.3-2.7-27.9-7.5-40.5zM64 400a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"]]
}, faCut = faScissors, faListMusic = {
  prefix: "fad",
  iconName: "list-music",
  icon: [512, 512, [], "f8c9", ["M0 96C0 78.3 14.3 64 32 64l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 128C14.3 128 0 113.7 0 96zM0 224c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 256c-17.7 0-32-14.3-32-32zM0 352c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32z", "M512 32c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-96 32C360.8 38 352 50.2 352 64l0 64 0 231.7c-14.5-4.9-30.8-7.7-48-7.7c-61.9 0-112 35.8-112 80s50.1 80 112 80s112-35.8 112-80l0-280.9 74.1-24.7C503.2 122 512 109.8 512 96l0-64z"]]
}, faSunPlantWilt = {
  prefix: "fad",
  iconName: "sun-plant-wilt",
  icon: [640, 512, [], "e57a", ["M0 160c0 6.3 3.7 12 9.5 14.6l55.4 24.8L43.2 256.1c-2.3 5.9-.8 12.6 3.6 17s11.1 5.9 17 3.6l56.7-21.7 24.8 55.4c2.6 5.8 8.3 9.5 14.6 9.5s12-3.7 14.6-9.5l24.8-55.4 56.7 21.7c5.9 2.3 12.6 .8 17-3.6s5.9-11.1 3.6-17l-21.7-56.7 55.4-24.8c5.8-2.6 9.5-8.3 9.5-14.6s-3.7-12-9.5-14.6l-55.4-24.8 21.7-56.7c2.3-5.9 .8-12.6-3.6-17s-11.1-5.9-17-3.6L199.4 64.9 174.6 9.5C172 3.7 166.3 0 160 0s-12 3.7-14.6 9.5L120.6 64.9 63.9 43.2c-5.9-2.3-12.6-.8-17 3.6s-5.9 11.1-3.6 17l21.7 56.7L9.5 145.4C3.7 148 0 153.7 0 160zm224 0A64 64 0 1 1 96 160a64 64 0 1 1 128 0zm-96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M536 144c-17.7 0-32 14.3-32 32l0 96 0 8 0 168 104 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l424 0 0-168 0-8c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 21.4c14.8 7.7 24 23.1 24 44.6c0 16.6-16 43.9-37.4 67.2c-5.7 6.2-15.5 6.2-21.2 0C336 382 320 354.9 320 338c0-21.5 9.2-37 24-44.6l0-21.4c0-44.2 35.8-80 80-80c11.4 0 22.2 2.4 32 6.7l0-22.7c0-44.2 35.8-80 80-80s80 35.8 80 80l0 53.4c14.8 7.7 24 23.1 24 44.6c0 16.6-16 43.9-37.4 67.2c-5.7 6.2-15.5 6.2-21.2 0C560 318 544 290.9 544 274c0-21.5 9.2-37 24-44.6l0-53.4c0-17.7-14.3-32-32-32z"]]
}, faToiletsPortable = {
  prefix: "fad",
  iconName: "toilets-portable",
  icon: [576, 512, [], "e584", ["M0 64L0 88 0 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8 160 0 0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-400 0-24-24 0L24 64 0 64zM176 240c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64zM320 64l0 24 0 400c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8 160 0 0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-400 0-24-24 0-8 0L352 64l-8 0-24 0zM496 240c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-64z", "M32 0C14.3 0 0 14.3 0 32L0 64l256 0 0-32c0-17.7-14.3-32-32-32L32 0zM352 0c-17.7 0-32 14.3-32 32l0 32 256 0 0-32c0-17.7-14.3-32-32-32L352 0zM192 224c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16zm336 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64z"]]
}, faHockeyPuck = {
  prefix: "fad",
  iconName: "hockey-puck",
  icon: [512, 512, [], "f453", ["M0 160c0 53 114.6 96 256 96s256-43 256-96s-114.6-96-256-96S0 107 0 160z", "M256 256c141.4 0 256-43 256-96l0 192c0 53-114.6 96-256 96S0 405 0 352L0 160c0 53 114.6 96 256 96z"]]
}, faMustache = {
  prefix: "fad",
  iconName: "mustache",
  icon: [640, 512, [], "e5bc", ["M48 223.4c0 .2 0 .4 0 .6c0 .7 0 1.3 .1 2s.2 1.3 .4 2c.1 .4 .2 .8 .3 1.2c9.4 28.2 32.9 54.6 58.8 73.7c25.8 19 57.3 33.1 85 33.1c16.4 0 34.4-4.7 50.1-11.2c15.6-6.5 30.6-15.5 40.6-25.5c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0c-6 6-17 13-30.3 18.5c-13.2 5.5-26.9 8.8-37.8 8.8c-18.2 0-43-9.9-66-26.9c-9.5-7-18.1-14.8-25.4-22.9c7 1.2 14.2 1.8 21.4 1.8c27.8 0 54.8-9 77-25.7l13.1-9.8c10.8-8.1 24-12.5 37.6-12.5c19 0 37 8.6 48.9 23.5l8.2 10.2c.4 .6 .9 1.1 1.4 1.6c1.3 1.3 2.8 2.4 4.5 3.1c4.3 2 9.3 2.1 13.7 0c1.6-.8 3.1-1.8 4.5-3.1c.5-.5 1-1 1.4-1.6l8.2-10.2c11.9-14.9 29.9-23.5 48.9-23.5c13.6 0 26.7 4.4 37.6 12.5l13.1 9.8c22.2 16.7 49.3 25.7 77 25.7c7.2 0 14.3-.6 21.4-1.8c-7.3 8.1-16 15.9-25.4 22.9c-23 17-47.9 26.9-66 26.9c-10.9 0-24.6-3.3-37.8-8.8c-13.3-5.5-24.3-12.5-30.3-18.5c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6c10 10 25 19 40.6 25.5C413 331.3 431 336 447.4 336c27.7 0 59.2-14.1 85-33.1c25.9-19.1 49.4-45.6 58.8-73.8c.7-2.3 1-4.6 .7-6.8c-.2-1.5-.5-3-1.1-4.4c-.3-.7-.6-1.3-1-1.9c-.8-1.4-1.9-2.7-3-3.7c-1.6-1.5-3.5-2.6-5.7-3.3c-.3-.1-.5-.2-.8-.2c-1.8-.5-3.6-.7-5.4-.5c-2 .1-4.1 .7-6 1.7l-8.3 4.1c-13.4 6.7-28.1 10.2-43.1 10.2c-20.9 0-41.2-6.8-57.8-19.3l-13.1-9.8c-16.4-12.3-36.3-18.9-56.8-18.9c-26.6 0-51.9 11.2-69.8 30.7c-17.9-19.5-43.2-30.7-69.8-30.7c-20.5 0-40.4 6.6-56.8 18.9l-13.1 9.8c-16.7 12.5-37 19.3-57.8 19.3c-15 0-29.7-3.5-43.1-10.2l-8.2-4.1c-.2-.1-.5-.2-.7-.3c-3.4-1.5-7.3-1.9-11.1-.7c-.3 .1-.7 .2-1 .3c-1.7 .6-3.3 1.6-4.6 2.7c-1.7 1.4-3.1 3.1-4.1 5.2c-1.1 2.1-1.6 4.3-1.7 6.5z", "M231 112c-31.6 0-61.7 13.2-83.1 36.4l-2 2.1c-27.6 29.9-74.6 30.9-103.4 2.1L41 151c-2.5-2.5-5.5-4.4-8.6-5.5c-2.6-1-5.4-1.5-8.4-1.5c-3.6 0-7.1 .8-10.2 2.3c-1.7 .8-3.3 1.8-4.8 3c-1.5 1.2-2.9 2.7-4.1 4.2c-.7 1-1.4 2-2 3C1.1 159.9 0 163.8 0 168l0 39.4C0 313.8 86.2 400 192.6 400c46.7 0 91.7-16.9 126.9-47.7l.5-.4 .5 .4c35.1 30.7 80.2 47.7 126.9 47.7C553.8 400 640 313.8 640 207.4l0-39.4c0-4-1-7.8-2.7-11.2c-.2-.5-.5-.9-.8-1.4c-.2-.4-.5-.8-.7-1.1c-.3-.5-.7-1-1.1-1.4c-1.1-1.3-2.3-2.5-3.6-3.6c-4.1-3.3-9.3-5.2-15-5.2c-2.9 0-5.8 .5-8.4 1.5c-3.1 1.2-6.1 3-8.6 5.5l-1.6 1.6c-28.8 28.8-75.8 27.9-103.4-2.1l-2-2.1C470.7 125.2 440.6 112 409 112c-33 0-64.4 14.4-85.9 39.5l-3.1 3.6-3.1-3.6C295.4 126.4 264 112 231 112zm19.2 64c26.6 0 51.9 11.2 69.8 30.7c17.9-19.5 43.2-30.7 69.8-30.7c20.5 0 40.4 6.6 56.8 18.9l13.1 9.8c16.7 12.5 37 19.3 57.8 19.3c15 0 29.7-3.5 43.1-10.2l8.3-4.1c1.9-1 4-1.5 6-1.7c1.8-.1 3.6 0 5.4 .5c.3 .1 .5 .2 .8 .2c2.2 .7 4.1 1.9 5.7 3.3c1.2 1.1 2.2 2.3 3 3.7c.4 .6 .7 1.3 1 1.9c.6 1.5 1 2.9 1.1 4.4c.2 2.2 0 4.5-.7 6.8c-9.4 28.3-32.9 54.7-58.8 73.8c-25.8 19-57.3 33.1-85 33.1c-16.4 0-34.4-4.7-50.1-11.2c-15.6-6.5-30.6-15.5-40.6-25.5c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0c6 6 17 13 30.3 18.5c13.2 5.5 26.9 8.8 37.8 8.8c18.2 0 43-9.9 66-26.9c9.5-7 18.1-14.8 25.4-22.9c-7 1.2-14.2 1.8-21.4 1.8c-27.8 0-54.8-9-77-25.7l-13.1-9.8c-10.8-8.1-24-12.5-37.6-12.5c-19 0-37 8.6-48.9 23.5l-8.2 10.2c-.4 .6-.9 1.1-1.4 1.6c-1.3 1.3-2.8 2.4-4.5 3.1c-4.4 2.1-9.4 2-13.7 0c-1.6-.8-3.1-1.8-4.5-3.1c-.5-.5-1-1-1.4-1.6l-8.2-10.2c-11.9-14.9-29.9-23.5-48.9-23.5c-13.6 0-26.7 4.4-37.6 12.5l-13.1 9.8c-22.2 16.7-49.3 25.7-77 25.7c-7.2 0-14.3-.6-21.4-1.8c7.3 8.1 16 15.9 25.4 22.9c23 17 47.9 26.9 66 26.9c10.9 0 24.6-3.3 37.8-8.8c13.3-5.5 24.3-12.5 30.3-18.5c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-10 10-25 19-40.6 25.5C227 331.3 209 336 192.6 336c-27.7 0-59.2-14.1-85-33.1c-25.9-19.1-49.3-45.5-58.8-73.7c-.1-.4-.2-.8-.3-1.2c-.4-1.5-.6-3.1-.5-4.6c.1-2.2 .6-4.4 1.7-6.5c1-2.1 2.4-3.8 4.1-5.2c1.3-1.1 2.9-2 4.6-2.7c.3-.1 .7-.2 1-.3c3.8-1.1 7.7-.8 11.1 .7c.2 .1 .5 .2 .7 .3l8.2 4.1c13.4 6.7 28.1 10.2 43.1 10.2c20.9 0 41.2-6.8 57.8-19.3l13.1-9.8c16.4-12.3 36.3-18.9 56.8-18.9z"]]
}, faHyphen = {
  prefix: "fad",
  iconName: "hyphen",
  icon: [320, 512, [], "2d", ["M0 256c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32z", ""]]
}, faTable = {
  prefix: "fad",
  iconName: "table",
  icon: [512, 512, [], "f0ce", ["M64 256l0 64 160 0 0 96 64 0 0-96 160 0 0-64-160 0 0-96-64 0 0 96L64 256z", "M64 160l0 256 384 0 0-256L64 160zM0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96z"]]
}, faUserChef = {
  prefix: "fad",
  iconName: "user-chef",
  icon: [448, 512, [], "e3d2", ["M96 160l32 0 16 0 160 0 16 0 32 0c0 70.7-57.3 128-128 128s-128-57.3-128-128z", "M384 48c0 20.9-13.4 38.7-32 45.3l0 18.7 0 48-32 0-16 0-160 0-16 0-32 0 0-48 0-18.7C77.4 86.7 64 68.9 64 48C64 21.5 85.5 0 112 0c14.3 0 27.2 6.3 36 16.3C156.8 6.3 169.7 0 184 0c16.7 0 31.4 8.5 40 21.5C232.6 8.5 247.3 0 264 0c14.3 0 27.2 6.3 36 16.3C308.8 6.3 321.7 0 336 0c26.5 0 48 21.5 48 48zM178.4 340.6c7.5 1.9 8.2 12.3 1 15.2l-43.2 17.3C111.9 382.8 96 406.3 96 432.5L96 480l0 24 0 8-8 0-24 0-38.4 0C11.5 512 0 500.5 0 486.4c0-58.8 37.7-108.8 90.3-127c3.3-1.2 5.7-4.3 5.7-7.8l0-21.4c0-5.2 4.9-9 9.9-7.8l72.5 18.1zM352 512l-192 0-24 0-8 0 0-8 0-24 0-47.5c0-13.1 8-24.9 20.1-29.7L341 325.6c5.3-2.1 11 1.8 11 7.4l0 18.6c0 3.5 2.3 6.6 5.7 7.8c52.6 18.2 90.3 68.2 90.3 127c0 14.1-11.5 25.6-25.6 25.6L352 512zM224 432a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]]
}, faMessageImage = {
  prefix: "fad",
  iconName: "message-image",
  icon: [512, 512, ["comment-alt-image"], "e1e0", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM98.4 306.4c4 8.3 12.4 13.6 21.6 13.6l80 0 48 0 144 0c8.9 0 17-4.9 21.2-12.7s3.7-17.3-1.2-24.6l-96-144C311.5 132 304 128 296 128s-15.5 4-20 10.7l-56 84L202.7 201c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4zM112 128a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M144 160a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm172-21.3C311.5 132 304 128 296 128s-15.5 4-20 10.7l-56 84L202.7 201c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6l80 0 48 0 144 0c8.9 0 17-4.9 21.2-12.7s3.7-17.3-1.2-24.6l-96-144z"]]
}, faCommentAltImage = faMessageImage, faUsersMedical = {
  prefix: "fad",
  iconName: "users-medical",
  icon: [640, 512, [], "f830", ["M0 298.7C0 310.4 9.6 320 21.3 320l213.3 0c.2 0 .4 0 .7 0c-26.6-23.5-43.3-57.8-43.3-96c0-7.6 .7-15 1.9-22.3c-13.6-6.3-28.7-9.7-44.6-9.7l-42.7 0C47.8 192 0 239.8 0 298.7zM64 80a80 80 0 1 0 160 0A80 80 0 1 0 64 80zm64 405.3c0 14.7 11.9 26.7 26.7 26.7l328.1 0c-1.8-5-2.7-10.4-2.7-16l0-16-16 0c-26.5 0-48-21.5-48-48l0-32c0-14.6 6.5-27.7 16.9-36.5C416.3 356.1 398 352 378.7 352l-117.3 0C187.7 352 128 411.7 128 485.3zM224 224a96 96 0 1 0 192 0 96 96 0 1 0 -192 0zm180.7 96c.2 0 .4 0 .7 0l77.4 0c6.6-18.6 24.4-32 45.3-32l32 0c20.9 0 38.7 13.4 45.3 32l13.4 0c11.8 0 21.3-9.6 21.3-21.3C640 239.8 592.2 192 533.3 192l-42.7 0c-15.9 0-31 3.5-44.6 9.7c1.3 7.2 1.9 14.7 1.9 22.3c0 38.2-16.8 72.5-43.3 96zM432 80a80 80 0 1 0 160 0A80 80 0 1 0 432 80z", "M528 320c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16l-32 0z"]]
}, faSensorTriangleExclamation = {
  prefix: "fad",
  iconName: "sensor-triangle-exclamation",
  icon: [640, 512, ["sensor-alert"], "e029", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 32c-26.4 0-50.7 14.2-63.7 37.1L233.9 430c-6.5 11.5-9.9 24.5-9.9 37.7c0 4.2 .3 8.3 1 12.3L64 480c-35.3 0-64-28.7-64-64L0 96zm64 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144c0-13.3-10.7-24-24-24s-24 10.7-24 24zm96 0l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M412.2 180.9l-150.4 265c-3.8 6.7-5.8 14.2-5.8 21.9c0 24.5 19.8 44.3 44.3 44.3l295.4 0c24.5 0 44.3-19.8 44.3-44.3c0-7.7-2-15.2-5.8-21.9l-150.4-265C476.5 168 462.8 160 448 160s-28.5 8-35.8 20.9zM448 256c8.8 0 16 7.2 16 16l0 88c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-88c0-8.8 7.2-16 16-16zM424 432a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]]
}, faSensorAlert = faSensorTriangleExclamation, faMagnifyingGlassArrowRight = {
  prefix: "fad",
  iconName: "magnifying-glass-arrow-right",
  icon: [512, 512, [], "e521", ["M0 208a208 208 0 1 0 416 0A208 208 0 1 0 0 208zm96 0c0-13.3 10.7-24 24-24l118.1 0-31-31c-9.4-9.4-9.4-24.6 0-33.9c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7l72 72c9.4 9.4 9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31L120 232c-13.3 0-24-10.7-24-24z", "M241 119c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l31 31L120 184c-13.3 0-24 10.7-24 24s10.7 24 24 24l118.1 0-31 31c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l72-72c9.4-9.4 9.4-24.6 0-33.9l-72-72zM457.4 502.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L376 330.7C363.3 348 348 363.3 330.7 376L457.4 502.6z"]]
}, faTachographDigital = {
  prefix: "fad",
  iconName: "tachograph-digital",
  icon: [640, 512, ["digital-tachograph"], "f566", ["M0 128L0 384c0 35.3 28.7 64 64 64l512 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64C28.7 64 0 92.7 0 128zm64 32c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32l0-64zM96 304a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM64 368c0-8.8 7.2-16 16-16l256 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 384c-8.8 0-16-7.2-16-16zm96-64a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm32 64c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16z", "M96 128c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l224 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L96 128zM80 352c-8.8 0-16 7.2-16 16s7.2 16 16 16l256 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 352zm320 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0z"]]
}, faDigitalTachograph = faTachographDigital, faFaceMask = {
  prefix: "fad",
  iconName: "face-mask",
  icon: [576, 512, [], "e37f", ["M32 257.5c.3 47.9 13.7 92.7 36.9 131c2.9-2.8 6.8-4.5 11.1-4.5l64 0c0-25.6 0-51.1 0-76.7c-37.3-16.6-74.7-33.2-112-49.8zm2-33.4c1.5 .2 3.1 .6 4.5 1.3c38.1 16.9 76.2 33.9 114.4 50.8c8.7-12.2 23-20.2 39.1-20.2c64 0 128 0 192 0c16.2 0 30.4 8 39.1 20.2c38.1-16.9 76.2-33.9 114.4-50.8c.7-.3 1.5-.6 2.2-.8s1.5-.4 2.3-.5C526.3 97.8 418.6 0 288 0S49.7 97.8 34 224.1zM88.1 416c46.9 58.5 119 96 199.9 96s152.9-37.5 199.9-96l-58.6 0c-6.6 18.6-24.4 32-45.3 32l-192 0c-20.9 0-38.7-13.4-45.3-32l-58.6 0zm44.5-235.3C146.4 167 184.6 144 240 144c8.8 0 16 7.2 16 16s-7.2 16-16 16c-47 0-77.1 19.7-84.7 27.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6zM320 160c0-8.8 7.2-16 16-16c55.4 0 93.6 23 107.3 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0C413.1 195.7 383 176 336 176c-8.8 0-16-7.2-16-16zM432 307.3l0 76.7 64 0c.5 0 1.1 0 1.6 .1s1 .1 1.6 .2c1 .2 2 .5 2.9 .9c1.9 .8 3.6 1.9 5 3.3c23.2-38.2 36.6-83 36.9-131c-37.3 16.6-74.7 33.2-112 49.8z", "M38.5 225.4c-8.1-3.6-17.5 0-21.1 8.1s0 17.5 8.1 21.1L144 307.3l0 76.7-64 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l66.7 0c6.6 18.6 24.4 32 45.3 32l192 0c20.9 0 38.7-13.4 45.3-32l66.7 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0 0-76.7 118.5-52.7c8.1-3.6 11.7-13 8.1-21.1s-13-11.7-21.1-8.1L423.1 276.2C414.4 264 400.2 256 384 256l-192 0c-16.2 0-30.4 8-39.1 20.2L38.5 225.4zM208 304l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm0 64l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-160 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]]
}, faPickleball = {
  prefix: "fad",
  iconName: "pickleball",
  icon: [576, 512, [], "e435", ["M304 384a128 128 0 1 0 256 0 128 128 0 1 0 -256 0zm64-16a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm16-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm16-80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M386.3 28c-37.5-37.4-98.4-37.4-136 0L84.9 193c-18.4 18.3-23.8 45.8-13.9 69.7l24.2 57.9c10 23.9 4.5 51.5-13.9 69.8L27.8 443.8c-15.6 15.6-15.7 40.9 0 56.5s41 15.6 56.7 0l53.8-53.6c18.3-18.2 45.7-23.7 69.6-13.9l56.7 23.2c8.7 3.6 17.9 5.1 26.9 4.7C279.1 437.9 272 411.8 272 384c0-3.3 .1-6.5 .3-9.8L133.1 235.5c-6.3-6.2-6.3-16.4 0-22.6s16.4-6.3 22.6 0L279.3 336.1C299.7 271.1 360.3 224 432 224c32.1 0 62 9.4 87 25.7c16.7-35.5 10.3-79.1-19.1-108.4L386.3 28z"]]
}, faStarSharpHalf = {
  prefix: "fad",
  iconName: "star-sharp-half",
  icon: [576, 512, [], "e28c", ["M288 0l0 155.9 0 169.4 0 81.1L389.1 485l2.9 2.3 12.3 9.5 13 10.1c8.3 6.5 19.8 6.8 28.5 .7s12.3-16.9 9.1-27l-5-15.7-4.7-14.8-1.1-3.5-40.1-126L507.7 240l1.8-1.4 10.5-8.2 14.7-11.5c8.1-6.3 11.3-17 8-26.7s-12.4-16.2-22.7-16.2l-18.7 0L488 176l-2.3 0-124.2 0-40-125.6-1-3.2L316 32.9c-1.7-5.4-3.4-10.8-5.2-16.2C307.7 6.8 298.5 0 288 0z", "M254.4 50.4L214.5 176 90.3 176 88 176l-13.3 0L56 176c-10.3 0-19.4 6.5-22.7 16.2s-.1 20.4 8 26.7L56 230.4l10.5 8.2 1.8 1.4 103.7 80.7L132 446.7l-1.1 3.5L126.1 465l-5 15.7c-3.2 10 .5 21 9.1 27s20.2 5.7 28.5-.7l13-10.1 12.3-9.5 2.9-2.3L288 406.4l0-81.1 0-169.4L288 0c-10.5 0-19.7 6.8-22.9 16.7L260 32.9s0 0 0 0l-4.6 14.3-1 3.2z"]]
}, faUsersSlash = {
  prefix: "fad",
  iconName: "users-slash",
  icon: [640, 512, [], "e073", ["M0 298.7C0 310.4 9.6 320 21.3 320l213.3 0c.2 0 .4 0 .7 0c-20.6-18.2-35.2-42.8-40.8-70.8L121.8 192l-15.2 0C47.8 192 0 239.8 0 298.7zM77.5 35.5c41.9 32.8 83.7 65.6 125.6 98.4c13-14.2 20.9-33.1 20.9-53.9c0-44.2-35.8-80-80-80C116.3 0 91.9 14.1 77.5 35.5zM128 485.3c0 14.7 11.9 26.7 26.7 26.7l330.7 0c10.5 0 19.5-6 23.9-14.8L324.9 352l-63.6 0C187.7 352 128 411.7 128 485.3zM243.7 165.7c50.4 39.5 100.7 79 151.1 118.4C408.1 267.7 416 246.8 416 224c0-53-43-96-96-96c-31.1 0-58.7 14.8-76.3 37.7zM420 303.9c6.9 5.4 13.7 10.7 20.5 16.1l178.1 0c11.8 0 21.3-9.6 21.3-21.3C640 239.8 592.2 192 533.3 192l-42.7 0c-15.9 0-31 3.5-44.6 9.7c1.3 7.2 1.9 14.7 1.9 22.3c0 30.2-10.5 58-28 79.9zM432 80a80 80 0 1 0 160 0A80 80 0 1 0 432 80z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faClover = {
  prefix: "fad",
  iconName: "clover",
  icon: [448, 512, [], "e139", ["M216.6 49.9C205.1 38.5 189.5 32 173.3 32C139.4 32 112 59.4 112 93.3l0 4.9c0 12 3.3 23.7 9.4 34l31.9 53.2-53.2-31.9c-10.3-6.2-22-9.4-34-9.4l-4.9 0C27.4 144 0 171.4 0 205.3c0 16.2 6.5 31.8 17.9 43.3l7.4 7.4-7.4 7.4C6.5 274.9 0 290.5 0 306.7C0 340.6 27.4 368 61.3 368l4.9 0c12 0 23.7-3.3 34-9.4l53.2-31.9-31.9 53.2c-6.2 10.3-9.4 22-9.4 34l0 4.9c0 33.8 27.4 61.3 61.3 61.3c16.2 0 31.8-6.5 43.3-17.9l7.4-7.4 7.4 7.4c11.5 11.5 27.1 17.9 43.3 17.9c33.8 0 61.3-27.4 61.3-61.3l0-4.9c0-12-3.3-23.7-9.4-34l-31.9-53.2 53.2 31.9c10.3 6.2 22 9.4 34 9.4l4.9 0c33.8 0 61.3-27.4 61.3-61.3c0-16.2-6.5-31.8-17.9-43.3l-7.4-7.4 7.4-7.4c11.5-11.5 17.9-27.1 17.9-43.3c0-33.8-27.4-61.3-61.3-61.3l-4.9 0c-12 0-23.7 3.3-34 9.4l-53.2 31.9 31.9-53.2c6.2-10.3 9.4-22 9.4-34l0-4.9C336 59.4 308.6 32 274.7 32c-16.2 0-31.8 6.5-43.3 17.9L224 57.4l-7.4-7.4z", ""]]
}, faMeat = {
  prefix: "fad",
  iconName: "meat",
  icon: [512, 512, [127830], "f814", ["M0 380c0 33.1 26.9 60 60 60c6.3 0 12 5.7 12 12c0 33.1 26.9 60 60 60s60-26.9 60-60c0-5-.6-9.8-1.8-14.5c-4.2-16.9-5.2-37.1 7.2-49.4l6.3-6.3c-36.7-7.9-65.6-36.8-73.5-73.5l-6.3 6.3c-12.3 12.3-32.5 11.4-49.4 7.2C69.8 320.6 65 320 60 320c-33.1 0-60 26.9-60 60zM332.4 124.4c-8.9 8.9-3.8 28.5 11.5 43.8s34.9 20.4 43.8 11.5c3-3 4.4-7.1 4.4-11.9c0-9.6-5.7-21.7-15.9-31.9s-22.3-15.9-31.9-15.9c-4.8 0-8.9 1.4-11.9 4.4z", "M243.6 19.6C283.7-20.4 371.9 2.8 440.5 71.5s91.9 156.8 51.8 196.9l-40.5 40.5C403.9 357 338.7 384 270.8 384L224 384c-53 0-96-43-96-96l0-46.7c0-67.9 27-133 75-181l40.7-40.7zm64 184.8c49.6 49.6 113.3 66.4 142.2 37.4s12.2-92.6-37.4-142.2S299.1 33.2 270.2 62.2s-12.2 92.6 37.4 142.2z"]]
}, faReply = {
  prefix: "fad",
  iconName: "reply",
  icon: [512, 512, [61714, "mail-reply"], "f3e5", ["M224 128l112 0c97.2 0 176 78.8 176 176c0 113.3-81.5 163.9-100.2 174.1c-2.5 1.4-5.3 1.9-8.1 1.9c-10.9 0-19.7-8.9-19.7-19.7c0-7.5 4.3-14.4 9.8-19.5c9.4-8.8 22.2-26.4 22.2-56.7c0-53-43-96-96-96l-96 0 0-160z", "M224 64c0-12.6-7.4-24.1-19-29.2s-25-3-34.4 5.4l-160 144C3.9 190.3 0 198.9 0 208s3.9 17.7 10.6 23.8l160 144c9.4 8.5 22.9 10.6 34.4 5.4s19-16.6 19-29.2l0-288z"]]
}, faMailReply = faReply, faStarAndCrescent = {
  prefix: "fad",
  iconName: "star-and-crescent",
  icon: [512, 512, [9770], "f699", ["M258.1 226.3c0 2.4 .9 4.9 2.9 6.8l50.9 49.6c2.3 2.2 3.3 5.4 2.8 8.5l-12 70.1c-1.1 6.2 3.9 11.2 9.5 11.2c1.5 0 3-.4 4.5-1.1l63-33.1c2.8-1.5 6.1-1.5 8.9 0l63 33.1c1.5 .8 3 1.1 4.5 1.1c5.6 0 10.5-5 9.5-11.2l-12-70.1c-.5-3.1 .5-6.3 2.8-8.5L507 233.1c2-1.9 2.9-4.4 2.9-6.8c0-4.5-3.1-8.8-8.2-9.6l-70.4-10.2c-3.1-.5-5.8-2.4-7.2-5.3l-31.5-63.8c-1.8-3.6-5.2-5.4-8.6-5.4s-6.8 1.8-8.6 5.4l-31.5 63.8c-1.4 2.8-4.1 4.8-7.2 5.3l-70.4 10.2c-5.1 .7-8.2 5.1-8.2 9.6z", "M256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c33 0 64.6-6.3 93.6-17.7c7.4-2.9 11.5-10.7 9.8-18.4s-8.8-13-16.7-12.4c-4.8 .3-9.7 .5-14.6 .5c-114.9 0-208-93.1-208-208s93.1-208 208-208c4.9 0 9.8 .2 14.6 .5c7.9 .5 15-4.7 16.7-12.4s-2.4-15.5-9.8-18.4C320.6 6.3 289 0 256 0z"]]
}, faEmptySet = {
  prefix: "fad",
  iconName: "empty-set",
  icon: [512, 512, [8709, 216], "f656", ["M32 256c0 50.3 16.6 96.8 44.6 134.2l45.9-45.9C105.8 318.9 96 288.6 96 256c0-88.4 71.6-160 160-160c32.6 0 62.9 9.8 88.2 26.5c15.3-15.3 30.6-30.6 45.9-45.9C352.8 48.6 306.3 32 256 32C132.3 32 32 132.3 32 256zm89.9 179.4c37.4 28 83.8 44.6 134.1 44.6c123.7 0 224-100.3 224-224c0-50.3-16.6-96.8-44.6-134.1l-45.9 45.9C406.2 193.1 416 223.4 416 256c0 88.4-71.6 160-160 160c-32.6 0-62.9-9.8-88.2-26.5c-15.3 15.3-30.6 30.6-45.9 45.9z", "M502.6 9.4c12.5 12.5 12.5 32.8 0 45.3l-448 448c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l448-448c12.5-12.5 32.8-12.5 45.3 0z"]]
}, faHouseFire = {
  prefix: "fad",
  iconName: "house-fire",
  icon: [640, 512, [], "e50c", ["M0 255.5c0 18 14 32.1 32 32.1l32 0 0 69.7c-.1 .9-.1 1.8-.1 2.8l0 112c0 22.1 17.9 40 40 40l16 0c1.2 0 2.4-.1 3.6-.2c1.5 .1 3 .2 4.5 .2l31.9 0 24 0c22.1 0 40-17.9 40-40l0-24 0-64c0-17.7 14.3-32 32-32l32 0c0-.6 0-1.3 0-1.9c0-35.2 16.3-73.6 37.2-107.4c21.7-35.2 51.9-71.2 87.3-102.8c9.8-8.8 22.5-12.7 34.8-11.7L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24z", "M640 352c0 88.4-71.6 160-160 160s-160-71.6-160-160c0-76.7 62.5-144.7 107.2-179.4c5-3.9 10.9-5.8 16.8-5.8c7.9-.1 16 3.1 22 9.2l46 46 11.3-11.3c11.7-11.7 30.6-12.7 42.3-1C624.5 268 640 320.2 640 352zM480 464.2c35.3 0 64-28.7 64-64c0-36.5-37-73-54.8-88.4c-5.4-4.7-13.1-4.7-18.5 0C453 327.1 416 363.6 416 400.2c0 35.3 28.7 64 64 64z"]]
}, faSquareMinus = {
  prefix: "fad",
  iconName: "square-minus",
  icon: [448, 512, [61767, "minus-square"], "f146", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM128 256c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z", "M128 256c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z"]]
}, faMinusSquare = faSquareMinus, faHelicopter = {
  prefix: "fad",
  iconName: "helicopter",
  icon: [640, 512, [128641], "f533", ["M128 32c0-17.7 14.3-32 32-32L544 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L384 64l0 64-64 0 0-64L160 64c-17.7 0-32-14.3-32-32zm96 448c0-17.7 14.3-32 32-32l280.2 0c17 0 33.3-6.7 45.3-18.7l3.9-3.9c12.5-12.5 32.8-12.5 45.3 0c6.2 6.2 9.4 14.4 9.4 22.6s-3.1 16.4-9.4 22.6l-3.9 3.9c-24 24-56.6 37.5-90.5 37.5L256 512c-17.7 0-32-14.3-32-32z", "M384 384l-64 0c-20.1 0-39.1-9.5-51.2-25.6l-71.4-95.2c-3.5-4.7-8.3-8.3-13.7-10.5L47.2 198.1c-9.5-3.8-16.7-12-19.2-22L5 83.9C2.4 73.8 10.1 64 20.5 64L48 64c10.1 0 19.6 4.7 25.6 12.8L112 128l272 0 32 0c88.4 0 160 71.6 160 160l0 64c0 17.7-14.3 32-32 32l-160 0zm0-64l128 0 0-32c0-53-43-96-96-96l-32 0 0 128z"]]
}, faBird = {
  prefix: "fad",
  iconName: "bird",
  icon: [512, 512, [], "e469", ["M162.1 407.4c18.7 5.4 38.5 8.4 58.9 8.6l32.2 60.8c6.2 11.7 1.7 26.2-10 32.4s-26.2 1.7-32.4-10l-48.6-91.9zm99 5.6c16.4-2.7 32.2-7.3 47.2-13.4l40.9 77.2c6.2 11.7 1.7 26.2-10 32.4s-26.2 1.7-32.4-10l-45.7-86.3zM446.6 79.7l57.6 34.6c4.8 2.9 7.8 8.1 7.8 13.7s-2.9 10.8-7.8 13.7L448 175.5 448 96c0-5.6-.5-11-1.4-16.3z", "M0 188.4L0 192C0 315.7 100.3 416 224 416s224-100.3 224-224l0-96c0-53-43-96-96-96s-96 43-96 96l0 32c0 17.7-14.3 32-32 32L28.4 160C12.7 160 0 172.7 0 188.4zM352 96a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faCompass = {
  prefix: "fad",
  iconName: "compass",
  icon: [512, 512, [129517], "f14e", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM129.7 358.3c0-2.8 .5-5.8 1.7-8.7c18.5-48.1 37-96.2 55.5-144.3c3.3-8.5 9.9-15.1 18.4-18.4c48.1-18.5 96.2-37 144.3-55.5c19.4-7.5 38.5 11.6 31 31c-18.5 48.1-37 96.2-55.5 144.3c-3.3 8.5-9.9 15.1-18.4 18.4c-48.1 18.5-96.2 37-144.3 55.5c-16.5 6.3-32.7-6.4-32.7-22.3z", "M162.4 380.6l144.3-55.5c8.5-3.3 15.1-9.9 18.4-18.4l55.5-144.3c7.5-19.4-11.6-38.5-31-31L205.3 186.9c-8.5 3.3-15.1 9.9-18.4 18.4L131.4 349.6c-7.5 19.4 11.6 38.5 31 31zM256 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]]
}, faSquareCaretDown = {
  prefix: "fad",
  iconName: "square-caret-down",
  icon: [448, 512, ["caret-square-down"], "f150", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM96 216c0-3.2 .7-6.5 2-9.6c3.8-8.7 12.5-14.4 22-14.4l208 0c9.5 0 18.2 5.7 22 14.4c1.3 3.1 2 6.3 2 9.6c0 5.9-2.2 11.8-6.4 16.3l-104 112c-4.5 4.9-10.9 7.7-17.6 7.7s-13-2.8-17.6-7.7l-104-112C98.2 227.8 96 221.9 96 216z", "M241.6 344.3c-4.5 4.9-10.9 7.7-17.6 7.7s-13-2.8-17.6-7.7l-104-112c-6.5-7-8.2-17.2-4.4-25.9s12.5-14.4 22-14.4l208 0c9.5 0 18.2 5.7 22 14.4s2.1 18.9-4.4 25.9l-104 112z"]]
}, faCaretSquareDown = faSquareCaretDown, faHeartHalfStroke = {
  prefix: "fad",
  iconName: "heart-half-stroke",
  icon: [512, 512, ["heart-half-alt"], "e1ac", ["M256 96l0 67.9 0 22.6 45.3-45.3 12-12c18-18 43.6-26.2 68.8-22c38.1 6.3 66 39.3 66 77.9l0 5.8c0 23.8-9.9 46.5-27.3 62.7L256 407.4l0 21.9 0 50.7c10.3 0 20.2-3.9 27.7-10.9L464.4 300.4c30.4-28.3 47.6-68 47.6-109.5l0-5.8c0-69.9-50.5-129.5-119.4-141C347 36.5 300.6 51.4 268 84L256 96z", "M256 96L244 84s0 0 0 0c-32.6-32.6-79-47.5-124.6-39.9C50.5 55.6 0 115.2 0 185.1l0 5.8c0 41.5 17.2 81.2 47.6 109.5L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9l0-50.7 0-265.4L256 96z"]]
}, faHeartHalfAlt = faHeartHalfStroke, faFileCircleQuestion = {
  prefix: "fad",
  iconName: "file-circle-question",
  icon: [576, 512, [], "e4ef", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 38.6C310.1 219.5 256 287.4 256 368c0 59.1 29.1 111.3 73.7 143.3c-3.2 .5-6.4 .7-9.7 .7L64 512c-35.3 0-64-28.7-64-64L0 64z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zm48 352a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-96a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm-64-94.4c0-23 18.6-41.6 41.6-41.6l40.5 0c25.4 0 45.9 20.6 45.9 45.9c0 17.1-9.5 32.7-24.5 40.6L448 378.9l0 5.1c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-14.8c0-5.9 3.3-11.4 8.6-14.2l32-16.8c4.6-2.4 7.4-7.2 7.4-12.3c0-7.7-6.2-13.9-13.9-13.9l-40.5 0c-5.3 0-9.6 4.3-9.6 9.6l0 6.4c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-6.4z"]]
}, faTruckUtensils = {
  prefix: "fad",
  iconName: "truck-utensils",
  icon: [640, 512, [], "e628", ["M96 432a80 80 0 1 0 160 0A80 80 0 1 0 96 432zm288 0a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M48 0C21.5 0 0 21.5 0 48L0 368c0 26.5 21.5 48 48 48l17.1 0c7.8-54.3 54.4-96 110.9-96s103.1 41.7 110.9 96l66.3 0c7.8-54.3 54.4-96 110.9-96s103.1 41.7 110.9 96l1.1 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-64 0-32 0-18.7c0-17-6.7-33.3-18.7-45.3L512 114.7c-12-12-28.3-18.7-45.3-18.7L416 96l0-48c0-26.5-21.5-48-48-48L48 0zM416 160l50.7 0L544 237.3l0 18.7-128 0 0-96zM89.5 77.5c.7-5.9 5.6-10.3 11.6-10.3c6.2 0 11.3 4.8 11.6 11l4.4 75.5c.2 3 2.6 5.3 5.6 5.3s5.5-2.3 5.6-5.3l4.4-75.8c.3-6 5.3-10.6 11.3-10.6s10.9 4.7 11.3 10.6l4.4 75.8c.2 3 2.6 5.3 5.6 5.3s5.5-2.3 5.6-5.3l4.4-75.5c.4-6.2 5.5-11 11.6-11c5.9 0 10.9 4.4 11.6 10.3l9.5 81.4c0 29.4-20.5 54-48 60.3l0 52.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-52.8c-27.5-6.3-48-30.9-48-60.3l9.5-81.4zM256 154.9c0-63.1 41.3-86 50.3-90.2c1.1-.5 2.3-.8 3.6-.8c5.6 0 10.1 4.5 10.1 10.1l0 53.9 0 96 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80c-17.7 0-32-14.3-32-32l0-37z"]]
}, faLaptopCode = {
  prefix: "fad",
  iconName: "laptop-code",
  icon: [640, 512, [], "f5fc", ["M0 403.2C0 445.6 34.4 480 76.8 480l486.4 0c42.4 0 76.8-34.4 76.8-76.8c0-10.6-8.6-19.2-19.2-19.2L19.2 384C8.6 384 0 392.6 0 403.2zM64 96l0 256 64 0 0-256 384 0 0 256 64 0 0-256c0-35.3-28.7-64-64-64L128 32C92.7 32 64 60.7 64 96z", "M512 96L128 96l0 256 384 0 0-256zM281 193l-31 31 31 31c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-48-48c-9.4-9.4-9.4-24.6 0-33.9l48-48c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9zM393 159l48 48c9.4 9.4 9.4 24.6 0 33.9l-48 48c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l31-31-31-31c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0z"]]
}, faJoystick = {
  prefix: "fad",
  iconName: "joystick",
  icon: [448, 512, [128377], "f8c5", ["M64 352c0-17.7 14.3-32 32-32s32 14.3 32 32l-64 0zM192 219.4c5.1 1.5 10.3 2.7 15.6 3.5c2.7 .4 5.4 .7 8.1 .9s5.5 .3 8.3 .3c11.1 0 21.9-1.6 32-4.6L256 352l-64 0 0-132.6z", "M336 112a112 112 0 1 0 -224 0 112 112 0 1 0 224 0zM176 72a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM64 352c-35.3 0-64 28.7-64 64l0 32c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-32c0-35.3-28.7-64-64-64L64 352z"]]
}, faGrillFire = {
  prefix: "fad",
  iconName: "grill-fire",
  icon: [576, 512, [], "e5a4", ["M0 72L0 96c0 89.8 52.9 167.3 129.2 203l-23.1 53.8c-3.3-.5-6.7-.8-10.1-.8c-35.3 0-64 28.7-64 64s28.7 64 64 64s64-28.7 64-64l75.5 0c-5.5-15.3-9.1-31.4-10.7-48l-73 0 22.9-53.4c15.9 3.6 32.3 5.4 49.3 5.4c1.2 0 2.4 0 3.6 0c5.9-26.2 18.6-52.9 33.6-77.3c21.7-35.2 51.9-71.2 87.3-102.8C366.2 124 393.3 124 411 140c9 8.1 17.7 16.4 26.2 25.1c7-21.8 10.9-45 10.9-69.1l0-24c0-22.1-17.9-40-40-40L40 32C17.9 32 0 49.9 0 72zM120 416a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M576 352c0 88.4-71.6 160-160 160s-160-71.6-160-160c0-76.7 62.5-144.7 107.2-179.4c5-3.9 10.9-5.8 16.8-5.8c7.9-.1 16 3.1 22 9.2l46 46 11.3-11.3c11.7-11.7 30.6-12.7 42.3-1C560.5 268 576 320.2 576 352zM416 464.2c35.3 0 64-28.7 64-64c0-36.5-37-73-54.8-88.4c-5.4-4.7-13.1-4.7-18.5 0C389 327.1 352 363.6 352 400.2c0 35.3 28.7 64 64 64z"]]
}, faRectangleVerticalHistory = {
  prefix: "fad",
  iconName: "rectangle-vertical-history",
  icon: [576, 512, [], "e237", ["M0 120L0 392c0 13.3 10.7 24 24 24s24-10.7 24-24l0-272c0-13.3-10.7-24-24-24S0 106.7 0 120zM96 72l0 368c0 13.3 10.7 24 24 24s24-10.7 24-24l0-368c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M192 64c0-35.3 28.7-64 64-64H512c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H256c-35.3 0-64-28.7-64-64V64z"]]
}, faSwatchbook = {
  prefix: "fad",
  iconName: "swatchbook",
  icon: [512, 512, [], "f5c3", ["M64 64l64 0 0 64-64 0 0-64zm0 128l64 0 0 64-64 0 0-64zM173.1 473.1c.8-1.1 1.7-2.3 2.5-3.5c5.2-7.7 9.3-16.1 12.1-25.1c1.4-4.5 2.5-9.2 3.2-13.9c.4-2.4 .6-4.8 .8-7.2c.1-1.2 .2-2.4 .2-3.7s.1-2.5 .1-3.7l0-230L299.4 78.6c12.5-12.5 32.8-12.5 45.3 0l90.5 90.5c12.5 12.5 12.5 32.8 0 45.3L189.7 459.9c-5.1 5.1-10.7 9.5-16.5 13.2zm9.7 38.9l192-192L480 320c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-297.2 0z", "M32 0C14.3 0 0 14.3 0 32L0 416c0 53 43 96 96 96s96-43 96-96l0-384c0-17.7-14.3-32-32-32L32 0zm96 64l0 64-64 0 0-64 64 0zM64 192l64 0 0 64-64 0 0-64zM96 392a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faPrescriptionBottle = {
  prefix: "fad",
  iconName: "prescription-bottle",
  icon: [384, 512, [], "f485", ["M32 96l320 0 0 352c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64l0-32 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L32 384l0-64 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L32 288l0-64 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L32 192l0-96z", "M32 0C14.3 0 0 14.3 0 32L0 64C0 81.7 14.3 96 32 96l320 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32L32 0zM144 192L32 192l0 32 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16zm0 96L32 288l0 32 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16zm0 96L32 384l0 32 112 0c8.8 0 16-7.2 16-16s-7.2-16-16-16z"]]
}, faBars = {
  prefix: "fad",
  iconName: "bars",
  icon: [448, 512, ["navicon"], "f0c9", ["M0 256c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32z", "M448 96c0-17.7-14.3-32-32-32L32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32zm0 320c0-17.7-14.3-32-32-32L32 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32z"]]
}, faNavicon = faBars, faKeyboardLeft = {
  prefix: "fad",
  iconName: "keyboard-left",
  icon: [640, 512, [], "e1c3", ["M160 128l0 256c0 35.3 28.7 64 64 64l352 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L224 64c-35.3 0-64 28.7-64 64zm64 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm96-192c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-32zm96-192c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm96-96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32z", "M240 128l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm0 96l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM224 336c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM336 128l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM320 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM432 128l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM416 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM528 128l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM512 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 80l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM113.2 153.8c9 3.7 14.8 12.5 14.8 22.2l0 160c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2L7 273c-9.4-9.4-9.4-24.6 0-33.9l80-80c6.9-6.9 17.2-8.9 26.2-5.2z"]]
}, faPeopleGroup = {
  prefix: "fad",
  iconName: "people-group",
  icon: [640, 512, [], "e533", ["M0 304c0 44.7 26.2 83.2 64 101.2L64 448c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-42.8 0-10.7c-20-24.7-32-56.2-32-90.5c0-37.8 14.6-72.2 38.4-97.9c-16.1-9-34.7-14.1-54.4-14.1l-32 0C50.1 192 0 242.1 0 304zm48 0c0-16.2 6-31.1 16-42.3l0 84.7C54 335 48 320.2 48 304zM64 96a64 64 0 1 0 128 0A64 64 0 1 0 64 96zM441.6 206.1C465.4 231.8 480 266.2 480 304c0 34.3-12 65.8-32 90.5l0 10.7 0 42.8c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-42.8c37.8-18 64-56.5 64-101.2c0-61.9-50.1-112-112-112l-32 0c-19.7 0-38.3 5.1-54.4 14.1zM448 96a64 64 0 1 0 128 0A64 64 0 1 0 448 96zM576 261.7c10 11.3 16 26.1 16 42.3s-6 31-16 42.3l0-84.7z", "M384 96A64 64 0 1 0 256 96a64 64 0 1 0 128 0zM256 261.7l0 84.7c-10-11.3-16-26.1-16-42.3s6-31.1 16-42.3zm128 84.7l0-84.7c10 11.3 16 26.1 16 42.3s-6 31-16 42.3zm0 58.9c37.8-18 64-56.5 64-101.2c0-61.9-50.1-112-112-112l-32 0c-61.9 0-112 50.1-112 112c0 44.7 26.2 83.2 64 101.2l0 42.8c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-42.8z"]]
}, faHourglassEnd = {
  prefix: "fad",
  iconName: "hourglass-end",
  icon: [384, 512, [8987, "hourglass-3"], "f253", ["M32 64l64 0 0 11c0 25.5 10.1 49.9 28.1 67.9L192 210.7l67.9-67.9c18-18 28.1-42.4 28.1-67.9l0-11 64 0 0 11c0 42.4-16.9 83.1-46.9 113.1L237.3 256l67.9 67.9c30 30 46.9 70.7 46.9 113.1l0 11-32 0-32 0L96 448l-32 0-32 0 0-11c0-42.4 16.9-83.1 46.9-113.1L146.7 256 78.9 188.1C48.9 158.1 32 117.4 32 75l0-11z", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 0zm0 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448z"]]
}, faHourglass3 = faHourglassEnd, faHeartCrack = {
  prefix: "fad",
  iconName: "heart-crack",
  icon: [512, 512, [128148, "heart-broken"], "f7a9", ["M0 185.1l0 5.8c0 41.5 17.2 81.2 47.6 109.5L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9s20.2-3.9 27.7-10.9L464.4 300.4c30.4-28.3 47.6-68 47.6-109.5l0-5.8c0-69.9-50.5-129.5-119.4-141c-33.4-5.6-67.2 .9-95.7 17.6c7.6 21.2 15.1 42.4 22.7 63.6c1.1 3.2 .2 6.7-2.4 8.8c-30.2 25.2-60.4 50.4-90.7 75.6c20.1 32.7 40.2 65.4 60.4 98.1c2.1 3.4 1.4 7.8-1.7 10.4s-7.6 2.4-10.5-.3c-37.3-34.7-74.7-69.3-112-104c-1.6-1.5-2.5-3.5-2.6-5.7s.8-4.3 2.3-5.8c25.1-25.1 50.3-50.3 75.4-75.4c-16.6-25.8-33.2-51.6-49.8-77.5c-21.8-7.2-45.3-9.2-68.5-5.3C50.5 55.6 0 115.2 0 185.1z", "M296.8 61.7C286.4 67.8 276.7 75.3 268 84L256 96 244 84c-16-16-35.2-27.7-56-34.6l49.8 77.5-75.4 75.4c-1.5 1.5-2.4 3.6-2.3 5.8s1 4.2 2.6 5.7l112 104c2.9 2.7 7.4 2.9 10.5 .3s3.8-7 1.7-10.4l-60.4-98.1 90.7-75.6c2.6-2.1 3.5-5.7 2.4-8.8L296.8 61.7z"]]
}, faHeartBroken = faHeartCrack, faFaceBeamHandOverMouth = {
  prefix: "fad",
  iconName: "face-beam-hand-over-mouth",
  icon: [512, 512, [129325], "e47c", ["M0 256c0 94.5 51.2 177 127.3 221.4c-9.8-18-15.3-38.6-15.3-60.5l0-32.8 0-53.6c0-28.7 23.3-52 52-52c17.9 0 33.6 9 43 22.7l47.1-47.1c18.7-18.7 49.1-18.7 67.9 0c1 1 2 2.1 3 3.2c15.7-3.7 32.8 .5 45 12.8s16.5 29.4 12.8 45c1.1 .9 2.2 1.9 3.2 3c18.1 18.1 18.7 47.1 1.8 65.9c16.9 18.8 16.3 47.8-1.8 65.9l-49 49C438.7 465.1 512 369.1 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256zm120-48c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l-.2-.3c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .3c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6zm160 0c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l-.2-.3c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .3c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6z", "M217.6 212.8s0 0 0 0s0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 172.4 120 190.1 120 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2c0 0 0 0 0 0c0 0 0 0 0 0zm81.7 86.5c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-79 79c-5 5-13.7 1.5-13.7-5.7l0-19.7c0-11-9-20-20-20s-20 9-20 20l0 53.6 0 32.8c0 52.6 42.6 95.2 95.2 95.2c25.2 0 49.5-10 67.3-27.9l56.8-56.8c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L321.4 424c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l51.3-51.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L289.4 392c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l67.3-67.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L257.4 360c-2.6 2.6-6.8 2.6-9.4 0s-2.6-6.8 0-9.4l51.3-51.3zm78.3-86.5s0 0 0 0s0 0 0 0s0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 172.4 280 190.1 280 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2c0 0 0 0 0 0z"]]
}, faDropletPercent = {
  prefix: "fad",
  iconName: "droplet-percent",
  icon: [384, 512, ["humidity"], "f750", ["M0 320C0 426 86 512 192 512s192-86 192-192c0-91.2-130.2-262.3-166.6-308.3C211.4 4.2 202.5 0 192.9 0l-1.8 0c-9.6 0-18.5 4.2-24.5 11.7C130.2 57.7 0 228.8 0 320zm160-56a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zM112 384c0-4.1 1.6-8.2 4.7-11.3l128-128c3.1-3.1 7.2-4.7 11.3-4.7s8.2 1.6 11.3 4.7s4.7 7.2 4.7 11.3s-1.6 8.2-4.7 11.3l-128 128c-3.1 3.1-7.2 4.7-11.3 4.7s-8.2-1.6-11.3-4.7s-4.7-7.2-4.7-11.3zm160-8a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M267.3 267.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-128 128c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l128-128zM160 264a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM272 376a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]]
}, faHumidity = faDropletPercent, faSquareUpRight = {
  prefix: "fad",
  iconName: "square-up-right",
  icon: [448, 512, [8599, "external-link-square-alt"], "f360", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM112 312c0-5.1 2-10 5.7-13.7L184 232l-33.4-33.4c-4.2-4.2-6.6-10-6.6-16c0-12.5 10.1-22.6 22.6-22.6L304 160c8.8 0 16 7.2 16 16l0 137.4c0 12.5-10.1 22.6-22.6 22.6c-6 0-11.8-2.4-16-6.6L248 296l-66.3 66.3C178 366 173.1 368 168 368s-10-2-13.7-5.7l-36.7-36.7C114 322 112 317.1 112 312z", "M320 176l0 137.4c0 12.5-10.1 22.6-22.6 22.6c-6 0-11.8-2.4-16-6.6L248 296l-66.3 66.3C178 366 173.1 368 168 368s-10-2-13.7-5.7l-36.7-36.7C114 322 112 317.1 112 312s2-10 5.7-13.7L184 232l-33.4-33.4c-4.2-4.2-6.6-10-6.6-16c0-12.5 10.1-22.6 22.6-22.6L304 160c8.8 0 16 7.2 16 16z"]]
}, faExternalLinkSquareAlt = faSquareUpRight, faFaceKissBeam = {
  prefix: "fad",
  iconName: "face-kiss-beam",
  icon: [512, 512, [128537, "kiss-beam"], "f597", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm120-32c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l-.2-.3c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .3c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6zm112.3 70c.9-3.5 4.1-6 7.7-6c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C274.7 443.1 257.4 448 240 448c-3.6 0-6.8-2.5-7.7-6s.6-7.2 4.1-9.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-1.2-.7c-2.5-1.4-4.1-4.1-4.1-7s1.6-5.6 4.1-7c.1 0 .1-.1 .5-.3l.6-.4c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.4-.3c-.2-.1-.3-.2-.7-.4c-3.2-1.8-4.7-5.5-3.8-9zM280 224c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l-.2-.3c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .3c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6z", "M217.6 228.8s0 0 0 0s0 0 0 0s0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 188.4 120 206.1 120 224c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2c0 0 0 0 0 0zm160 0s0 0 0 0s0 0 0 0s0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 188.4 280 206.1 280 224c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2c0 0 0 0 0 0z"]]
}, faKissBeam = faFaceKissBeam, faCorn = {
  prefix: "fad",
  iconName: "corn",
  icon: [512, 512, [127805], "f6c7", ["M207.1 113.3c29.7 47.7 41.1 103.6 34.2 157.5c53.9-6.9 109.8 4.5 157.5 34.2c10.4-7.2 17.3-19.3 17.3-32.9c0-5.7-1.2-11.2-3.4-16.1c1.1 .1 2.2 .1 3.4 .1c22.1 0 40-17.9 40-40c0-6.4-1.5-12.4-4.2-17.8c16.3-5 28.2-20.2 28.2-38.2c0-6.4-1.5-12.4-4.2-17.8c16.3-5 28.2-20.2 28.2-38.2c0-11.4-4.8-21.8-12.5-29.1C503.7 68.1 512 55 512 40c0-22.1-17.9-40-40-40c-15 0-28.1 8.3-34.9 20.5C429.8 12.8 419.4 8 408 8c-18 0-33.2 11.8-38.2 28.2C364.4 33.5 358.4 32 352 32c-18 0-33.2 11.8-38.2 28.2C308.4 57.5 302.4 56 296 56c-22.1 0-40 17.9-40 40c0 1.1 0 2.3 .1 3.4C251.2 97.2 245.7 96 240 96c-13.6 0-25.7 6.8-32.9 17.3z", "M150.9 94.1c-4.3-4.8-12.1-2.4-13.2 3.9l-10.2 54.9c-4.7 25.4-17 48.8-35.3 67.1l-64 64c-36.4 36.4-37.5 94.7-3.2 132.4l77.4-77.4c30.4-30.4 66.9-50.9 105.5-61.6c12.6-69.3-11.5-132.9-56.9-183.4zM47.4 439.2l44.7 44.7c37.5 37.5 98.3 37.5 135.8 0l64-64c18.3-18.3 41.7-30.6 67.1-35.3L414 374.3c6.3-1.2 8.7-8.9 3.9-13.2c-53-47.6-120.7-71.6-192.8-55c-36.7 8.5-71.5 27-100.1 55.6L47.4 439.2z"]]
}, faRollerCoaster = {
  prefix: "fad",
  iconName: "roller-coaster",
  icon: [640, 512, [], "e324", ["M104 113.1c13.7-9.7 30.2-15.8 48-16.9L152 456c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-342.9zm96-7.2c7 3.5 13.5 7.8 19.5 12.9c3 2.6 5.8 5.3 8.4 8.3c1.3 1.5 2.6 3 3.8 4.5c.6 .8 1.2 1.6 1.8 2.4c.6 .8 1.2 1.6 1.7 2.4L248 154.7 248 456c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-350.1zm96 117.9c16 23 32 46.1 48 69.1L344 456c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-232.2zm96 128.2c14.2 11.5 30.5 20.2 48 25.6l0 78.4c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104.1zM488 384l8 0c13.9 0 27.3-2 40-5.6l0 77.6c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72z", "M158.1 96c-52 0-94.1 42.1-94.1 94.1L64 448c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 190.1C0 102.8 70.8 32 158.1 32c51.8 0 100.3 25.4 129.8 67.9l129 185.7c15 21.5 39.5 34.4 65.7 34.4l13.4 0c44.2 0 80-35.8 80-80c0-32.8-19.7-61-48-73.3l0 97.3c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-103.4c-14.2 1.5-28 5.8-40.7 12.5l-7.3 3.9 0 74.2L357.6 144.2l51.6-27.5C434.7 103.1 463.1 96 492 96l4 0c79.5 0 144 64.5 144 144c0 2.7-.1 5.4-.2 8l.2 0 0 200c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-88.2c-22.9 15.3-50.4 24.2-80 24.2l-13.4 0c-47.2 0-91.4-23.1-118.3-61.9l-129-185.7C217.7 111.1 188.9 96 158.1 96z"]]
}, faPhotoFilmMusic = {
  prefix: "fad",
  iconName: "photo-film-music",
  icon: [640, 512, [], "e228", ["M0 160L0 384c0 35.3 28.7 64 64 64l225.9 0c4.4-18.2 15.9-33.1 29.6-43.4c6.8-5.1 14.5-9.4 22.6-12.6L192 392c-17.7 0-32-14.3-32-32l0-264L64 96C28.7 96 0 124.7 0 160zm56 8c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zm0 96c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zm0 96c0-8.8 7.2-16 16-16l16 0c8.8 0 16 7.2 16 16l0 16c0 8.8-7.2 16-16 16l-16 0c-8.8 0-16-7.2-16-16l0-16zM289.6 247c2.7 5.5 8.3 9 14.4 9l64 0 0-7.9c0-24.1 15.4-45.5 38.3-53.1l93.1-31-37.8-60.5c-2.9-4.7-8.1-7.5-13.6-7.5s-10.6 2.8-13.6 7.5L388 177.9l-15.3-19.7c-3-3.9-7.7-6.2-12.6-6.2s-9.6 2.3-12.6 6.2l-56 72c-3.8 4.8-4.4 11.4-1.7 16.9zM320 464c0 26.5 28.7 48 64 48s64-21.5 64-48l0-150.7 144-48 0 88.2c-5.1-1-10.5-1.5-16-1.5c-35.3 0-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48c0-1.5-.1-3-.3-4.4c.2-1.2 .3-2.4 .3-3.6l0-160 0-48c0-7.7-3.7-15-10-19.5s-14.3-5.7-21.6-3.3l-192 64c-9.8 3.3-16.4 12.4-16.4 22.8l0 48 0 121.5c-5.1-1-10.5-1.5-16-1.5c-35.3 0-64 21.5-64 48z", "M192 64c0-35.3 28.7-64 64-64L576 0c35.3 0 64 28.7 64 64l0 69.6c-12.9-6.1-27.9-7.1-41.7-2.5l-98.9 33-37.8-60.5c-2.9-4.7-8.1-7.5-13.6-7.5s-10.6 2.8-13.6 7.5L388 177.9l-15.3-19.7c-3-3.9-7.7-6.2-12.6-6.2s-9.6 2.3-12.6 6.2l-56 72c-3.8 4.8-4.4 11.4-1.7 16.9s8.3 9 14.4 9l64 0 0 64-112 0c-35.3 0-64-28.7-64-64l0-192zM320 96a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]]
}, faRadar = {
  prefix: "fad",
  iconName: "radar",
  icon: [512, 512, [], "e024", ["M0 256C0 397.4 114.6 512 256 512s256-114.6 256-256l-64 0c0 89.9-61.7 165.3-145.1 186.2C298.2 463.8 279 480 256 480s-42.2-16.2-46.9-37.8c-65.5-16.5-117.7-66.6-137-130.9C49.3 307.6 32 287.8 32 264c0-22.3 15.2-41.1 35.9-46.4C85.7 129.9 163.1 64 256 64c44.4 0 85.2 15 117.7 40.3l45.5-45.5C374.9 22.1 318.1 0 256 0C114.6 0 0 114.6 0 256zm100-35.7c16.5 7.6 28 24.3 28 43.7c0 17.8-9.7 33.4-24.1 41.7c16.5 50.7 57.7 90.3 109.4 104.6c7.9-15.6 24.1-26.2 42.8-26.2s34.8 10.7 42.8 26.2C366.4 391.5 416 329.5 416 256l-64 0c0 53-43 96-96 96s-96-43-96-96s43-96 96-96c17.8 0 34.5 4.8 48.8 13.3c15.4-15.4 30.7-30.7 46.1-46.1C324.3 107.6 291.5 96 256 96c-76.1 0-139.8 53.1-156 124.3z", "M497 49c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-182 182c-7.7-3.3-16.1-5.1-25-5.1c-35.3 0-64 28.7-64 64s28.7 64 64 64s64-28.7 64-64c0-8.9-1.8-17.3-5.1-25L497 49z"]]
}, faSickle = {
  prefix: "fad",
  iconName: "sickle",
  icon: [512, 512, [], "f822", ["M128 181C128 81 209 0 309 0l11 0c90.1 0 165.8 62.1 186.4 145.8c.2 .9 .3 1.8 .3 2.7c0 6.2-5.2 11.4-11.9 11.4c-3.9 0-7.5-1.9-9.9-4.9C458.9 122.9 419.5 104 377.8 104C301.7 104 240 165.7 240 241.8l0 9.8c0 20.7 5.2 39.7 12.2 58.6c2.2 6 .9 12.8-3.7 17.3L224 352l-23 23-16-16-32-32-16-16 24.8-24.8C139.9 255.8 128 219 128 181z", "M129 303c-9.4-9.4-24.6-9.4-33.9 0L79 319c-9.4 9.4-9.4 24.6 0 33.9l7 7L7 439c-9.4 9.4-9.4 24.6 0 33.9l32 32c9.4 9.4 24.6 9.4 33.9 0l79-79 7 7c9.4 9.4 24.6 9.4 33.9 0l16-16c9.4-9.4 9.4-24.6 0-33.9l-24-24-32-32-24-24z"]]
}, faFilm = {
  prefix: "fad",
  iconName: "film",
  icon: [512, 512, [127902], "f008", ["M160 128l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L192 96c-17.7 0-32 14.3-32 32zm0 192l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32z", "M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM48 368l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM48 240l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm368-16c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM48 112l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L64 96c-8.8 0-16 7.2-16 16zM416 96c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0zM160 128l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L192 96c-17.7 0-32 14.3-32 32zm32 160c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-128 0z"]]
}, faCoconut = {
  prefix: "fad",
  iconName: "coconut",
  icon: [512, 512, [], "e2f6", ["M97.6 323.9c5.9 5.9 14.5 8.7 24.8 8.7c33.4 0 85.9-29 133.5-76.6c62.5-62.5 92.9-133.4 67.9-158.4s-95.9 5.4-158.4 67.9S72.6 298.9 97.6 323.9z", "M274.5 55.3c42.7-13.2 71.9-7.4 86.7 7.5s20.6 44 7.5 86.7c-12.8 41.5-42.1 89.6-85.8 133.3s-91.8 73-133.3 85.8c-42.7 13.2-71.9 7.4-86.7-7.5s-20.6-44-7.5-86.7c12.8-41.5 42.1-89.6 85.8-133.3s91.8-73 133.3-85.8zM395.2 28.8C361.5-4.8 309.6-5.7 260.4 9.5C210 25 155.3 59.1 107.2 107.2S25 209.9 9.5 260.3C-5.7 309.6-4.8 361.5 28.9 395.2l41 41C118.4 484.7 184.3 512 253 512c143.1 0 259-116 259-259c0-68.7-27.3-134.6-75.9-183.2L395.2 28.8zm24.1 175.8l32 32c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-32-32c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-56 136l32 32c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-32-32c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0zm-136 56l32 32c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-32-32c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0z"]]
}, faRulerHorizontal = {
  prefix: "fad",
  iconName: "ruler-horizontal",
  icon: [640, 512, [], "f547", ["M0 176L0 336c0 26.5 21.5 48 48 48l544 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0 0 80c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-80-64 0c-26.5 0-48 21.5-48 48z", "M144 208l0-80-32 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16zm96-80l-32 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80zm96 80l0-80-32 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16zm96-80l-32 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80zm96 0l-32 0 0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80z"]]
}, faShieldCross = {
  prefix: "fad",
  iconName: "shield-cross",
  icon: [512, 512, [9960], "f712", ["M16 139.7c0-26.1 16.4-47.6 38.3-56.9L224 10.8c0 39.1 0 78.1 0 117.2c0 .1 0 .3 0 .7c0 .1 0 .5 0 .9c0 .5-.1 1.1-.1 1.6c-.1 1.1-.3 2.2-.5 3.2c-.4 2.1-1.1 4.1-1.9 6c-1.6 3.8-4 7.3-6.9 10.2s-6.3 5.2-10.2 6.9c-1.9 .8-3.9 1.4-6 1.9c-1 .2-2.1 .4-3.2 .5s-2.2 .2-3.3 .2c-58.5 0-116.9 0-175.4 0c-.4-7-.6-13.7-.6-20.3zM24.7 224c55.7 0 111.5 0 167.3 0c8.8 0 16.8 3.6 22.6 9.4c2.9 2.9 5.2 6.3 6.9 10.2c.8 1.9 1.4 3.9 1.9 6c.2 1 .4 2.1 .5 3.4c0 .4 .1 .8 .1 1c0 .1 0 .3 0 .4c0 .5 0 .8 0 .9c0 .2 0 .5 0 .7c0 81.5 0 162.9 0 244.4C97.4 437.2 43.7 319.9 24.7 224zM288 10.8c56.6 24 113.1 48 169.7 72C479.6 92.1 496 113.6 496 140c0 6.4-.2 13-.6 20c-58.5 0-117 0-175.4 0c-17.7 0-32-14.3-32-32c0-39.1 0-78.1 0-117.2zM288 256c0-17.7 14.3-32 32-32c55.8 0 111.5 0 167.3 0c-19 95.9-72.7 213.2-199.3 276.4c0-81.5 0-163 0-244.4z", "M288 10.8L269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L224 10.8 224 128c0 17.7-14.3 32-32 32L16.6 160c1.1 19.4 3.6 41.1 8.1 64L192 224c17.7 0 32 14.3 32 32l0 244.4c1.9 .9 3.7 1.8 5.6 2.7c16.7 8 36.1 8 52.8 0c1.9-.9 3.8-1.8 5.6-2.7L288 256c0-17.7 14.3-32 32-32l167.3 0c4.5-22.9 7.1-44.6 8.1-64L320 160c-17.7 0-32-14.3-32-32l0-117.2z"]]
}, faCassetteTape = {
  prefix: "fad",
  iconName: "cassette-tape",
  icon: [576, 512, [128429], "f8ab", ["M0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64l-28.9 0-36.3-96.9c-7-18.7-24.9-31.1-44.9-31.1l-227.6 0c-20 0-37.9 12.4-44.9 31.1L92.9 480 64 480c-35.3 0-64-28.7-64-64L0 96zM80 208c0 44.2 35.8 80 80 80l256 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-256 0c-44.2 0-80 35.8-80 80zm47.1 272l32.1-85.6c2.3-6.2 8.3-10.4 15-10.4l227.6 0c6.7 0 12.6 4.1 15 10.4L448.9 480l-321.8 0z", "M240 208c0 11.4-2.4 22.2-6.7 32l109.3 0c-4.3-9.8-6.7-20.6-6.7-32s2.4-22.2 6.7-32l-109.3 0c4.3 9.8 6.7 20.6 6.7 32zm176 80l-256 0c-44.2 0-80-35.8-80-80s35.8-80 80-80l256 0c44.2 0 80 35.8 80 80s-35.8 80-80 80zM160 224a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm272-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]]
}, faSquareTerminal = {
  prefix: "fad",
  iconName: "square-terminal",
  icon: [448, 512, [], "e32a", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64.4 67.7c-.1 .7-.2 1.4-.3 2.2s-.1 1.4-.1 2.1c0 1.7 .2 3.3 .5 4.9s.8 3.2 1.5 4.7c1.3 3 3.2 5.8 5.8 8.2L148.5 256 71.8 326.3c-2.6 2.4-4.5 5.2-5.8 8.2c-.7 1.5-1.1 3.1-1.5 4.7s-.5 3.2-.5 4.8c0 .8 0 1.5 .1 2.2s.2 1.4 .3 2.2c.3 1.4 .7 2.8 1.2 4.2c1 2.8 2.6 5.4 4.7 7.7c9 9.8 24.1 10.4 33.9 1.5c32-29.3 64-58.7 96-88c5-4.5 7.8-11 7.8-17.7s-2.8-13.1-7.8-17.7c-32-29.3-64-58.7-96-88c-9.8-9-25-8.3-33.9 1.5c-2.1 2.3-3.7 4.9-4.7 7.7c-.5 1.4-.9 2.8-1.2 4.2zM192 360c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24z", "M71.8 185.7c-9.8-9-10.4-24.1-1.5-33.9s24.1-10.4 33.9-1.5l96 88c5 4.5 7.8 11 7.8 17.7s-2.8 13.1-7.8 17.7l-96 88c-9.8 9-25 8.3-33.9-1.5s-8.3-25 1.5-33.9L148.5 256 71.8 185.7zM216 336l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]]
}, faPeopleRobbery = {
  prefix: "fad",
  iconName: "people-robbery",
  icon: [576, 512, [], "e536", ["M241 39.8l8.7 34.9c11 44 40.2 79.6 78.3 99.6L328 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 16 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-305.7c38.1-20 67.3-55.6 78.3-99.6L559 39.8c.7-2.6 1-5.2 1-7.8c0-14.3-9.7-27.4-24.2-31C518.6-3.3 501.2 7.1 497 24.2l-8.7 34.9C478.1 99.6 441.7 128 400 128s-78.1-28.4-88.2-68.9L303 24.2C298.8 7.1 281.4-3.3 264.2 1S236.7 22.6 241 39.8zM352 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M32 48a48 48 0 1 1 96 0A48 48 0 1 1 32 48zM8 192c0-35.3 28.7-64 64-64l32.7 0c27.4 0 52.9 14 67.5 37.1L209.6 224l30.4 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0c-11 0-21.1-5.6-27-14.9l-13-20.5L152 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-16 0 0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32L8 288.6l0-.6 0-96z"]]
}, faLightbulb = {
  prefix: "fad",
  iconName: "lightbulb",
  icon: [384, 512, [128161], "f0eb", ["M16 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4c19.8 27.1 39.7 54.4 49.2 86.2l160 0c9.6-31.9 29.5-59.1 49.2-86.2c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C368 78.8 289.2 0 192 0S16 78.8 16 176zm64 0c0-61.9 50.1-112 112-112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.2 0-80 35.8-80 80c0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M192 512c44.2 0 80-35.8 80-80V384H112v48c0 44.2 35.8 80 80 80z"]]
}, faCaretLeft = {
  prefix: "fad",
  iconName: "caret-left",
  icon: [256, 512, [], "f0d9", ["M9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c9.2-9.2 22.9-11.9 34.9-6.9s19.8 16.6 19.8 29.6l0 256c0 12.9-7.8 24.6-19.8 29.6s-25.7 2.2-34.9-6.9l-128-128z", ""]]
}, faCommentMiddle = {
  prefix: "fad",
  iconName: "comment-middle",
  icon: [512, 512, [], "e149", ["M188.3 408.7l44.5 89c4.4 8.8 13.3 14.3 23.2 14.3s18.8-5.5 23.2-14.3l44.5-89C432.2 384.5 512 303.8 512 208C512 93.1 397.4 0 256 0S0 93.1 0 208c0 95.8 79.8 176.5 188.3 200.7z", ""]]
}, faTrashCanList = {
  prefix: "fad",
  iconName: "trash-can-list",
  icon: [640, 512, [], "e2ab", ["M32 96l0 368c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-368L32 96zm96 96c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224zm128 0c0-8.8 7.2-16 16-16s16 7.2 16 16l0 224c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-224z", "M119.2 17.7C124.6 6.8 135.7 0 147.8 0L268.2 0c12.1 0 23.2 6.8 28.6 17.7L304 32l80 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l80 0 7.2-14.3zM480 128l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 128l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zM448 416c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32z"]]
}, faBlock = {
  prefix: "fad",
  iconName: "block",
  icon: [448, 512, [], "e46a", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm48 8a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 304a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zM352 104a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 304a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M72 128a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm304 0a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM96 408a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm280 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]]
}, faCircleExclamation = {
  prefix: "fad",
  iconName: "circle-exclamation",
  icon: [512, 512, ["exclamation-circle"], "f06a", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm288 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM232 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112z", "M280 152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM256 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faExclamationCircle = faCircleExclamation, faSchoolCircleXmark = {
  prefix: "fad",
  iconName: "school-circle-xmark",
  icon: [640, 512, [], "e56d", ["M0 144L0 464c0 26.5 21.5 48 48 48l272 0-64 0 0-96c0-35.3 28.7-64 64-64l.7 0c3.4-37.7 18.7-72.1 42.2-99.1C350.2 260 335.6 264 320 264c-48.6 0-88-39.4-88-88s39.4-88 88-88s88 39.4 88 88c0 18.3-5.6 35.3-15.1 49.4c29-21 64.6-33.4 103.1-33.4c59.5 0 112.1 29.6 144 74.8L640 144c0-26.5-21.5-48-48-48L473.7 96 337.8 5.4C332.4 1.8 326.2 0 320 0s-12.4 1.8-17.8 5.4L166.3 96 48 96C21.5 96 0 117.5 0 144zm80 64c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zm0 128c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zM304 144l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]]
}, faArrowRightFromBracket = {
  prefix: "fad",
  iconName: "arrow-right-from-bracket",
  icon: [512, 512, ["sign-out"], "f08b", ["M0 128L0 384c0 53 43 96 96 96l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 32C43 32 0 75 0 128z", "M502.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-128 128c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L402.7 288 192 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l210.7 0-73.4-73.4c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l128 128z"]]
}, faSignOut = faArrowRightFromBracket, faFaceFrownSlight = {
  prefix: "fad",
  iconName: "face-frown-slight",
  icon: [512, 512, [], "e376", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM139.9 373.5c22.2-25.7 61-53.5 116.1-53.5s93.8 27.9 116.1 53.5c5.8 6.7 5.1 16.8-1.6 22.6s-16.8 5.1-22.6-1.6C330 373.8 299.4 352 256 352s-74 21.8-91.9 42.5c-5.8 6.7-15.9 7.4-22.6 1.6s-7.4-15.9-1.6-22.6zM144.4 208c0-17.7 14.3-32 32-32c8.8 0 16.8 3.6 22.6 9.4c2.9 2.9 5.2 6.3 6.9 10.2c.8 1.9 1.4 3.9 1.9 6c.2 1 .4 2.1 .5 3.2c.1 .5 .1 1.1 .1 1.6s0 1 0 1.8c0 .5 0 1 0 1.5s-.1 1.1-.1 1.6c-.1 1.1-.3 2.1-.5 3.2c-.4 2.1-1.1 4.1-1.9 6c-1.6 3.8-4 7.3-6.9 10.2c-5.8 5.8-13.8 9.4-22.6 9.4c-17.7 0-32-14.3-32-32zm224 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faCircleChevronDown = {
  prefix: "fad",
  iconName: "circle-chevron-down",
  icon: [512, 512, ["chevron-circle-down"], "f13a", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128-32c0-6.1 2.3-12.3 7-17s10.8-7 17-7s12.3 2.3 17 7l87 87 87-87c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7s7 10.8 7 17s-2.3 12.3-7 17L273 345c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7L135 241c-4.7-4.7-7-10.8-7-17z", "M239 345c9.4 9.4 24.6 9.4 33.9 0L377 241c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-87 87-87-87c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L239 345z"]]
}, faChevronCircleDown = faCircleChevronDown, faSidebarFlip = {
  prefix: "fad",
  iconName: "sidebar-flip",
  icon: [512, 512, [], "e24f", ["M0 96C0 60.7 28.7 32 64 32l224 0 0 448L64 480c-35.3 0-64-28.7-64-64L0 96z", "M448 32c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64l-160 0 0-448 160 0zM424 96l-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24zm24 120c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c13.3 0 24-10.7 24-24zm-24 72l-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24z"]]
}, faUnlockKeyhole = {
  prefix: "fad",
  iconName: "unlock-keyhole",
  icon: [448, 512, ["unlock-alt"], "f13e", ["M80 144l0 48 64 0 0-48c0-44.2 35.8-80 80-80c31.9 0 59.4 18.6 72.3 45.7c7.6 16 26.7 22.8 42.6 15.2s22.8-26.7 15.2-42.6C331 33.7 281.5 0 224 0C144.5 0 80 64.5 80 144z", "M64 192c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64L64 192zM256 384l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32z"]]
}, faUnlockAlt = faUnlockKeyhole, faTemperatureList = {
  prefix: "fad",
  iconName: "temperature-list",
  icon: [512, 512, [], "e299", ["M0 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-33.2-11.2-63.8-30.1-88.1c-.9-1.2-1.5-2.2-1.7-2.8c-.1-.3-.2-.5-.2-.6L256 112C256 50.2 205.9 0 144 0S32 50.2 32 112l0 164.4c0 .1-.1 .3-.2 .6c-.2 .6-.8 1.6-1.7 2.8C11.2 304.2 0 334.8 0 368zm64 0c0-18.5 6.2-35.4 16.7-48.9C88.9 308.4 96 293.8 96 276.5L96 112c0-26.5 21.5-48 48-48s48 21.5 48 48l0 164.5c0 17.3 7.1 31.9 15.3 42.5C217.8 332.6 224 349.5 224 368c0 44.2-35.8 80-80 80s-80-35.8-80-80z", "M320 64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L352 96c-17.7 0-32-14.3-32-32zM192 368c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3L128 176c0-8.8 7.2-16 16-16s16 7.2 16 16l0 146.7c18.6 6.6 32 24.4 32 45.3zM352 160l128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32s14.3-32 32-32zm0 160c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32-14.3-32-32z"]]
}, faCloudShowersHeavy = {
  prefix: "fad",
  iconName: "cloud-showers-heavy",
  icon: [512, 512, [], "f740", ["M1.9 478.5c-5.2 12.2 .4 26.3 12.6 31.5s26.3-.4 31.5-12.6l48-112c5.2-12.2-.4-26.3-12.6-31.5c-3.1-1.3-6.3-1.9-9.4-1.9c-9.3 0-18.2 5.5-22.1 14.6l-48 112zm120 0c-5.2 12.2 .4 26.3 12.6 31.5s26.3-.4 31.5-12.6l48-112c5.2-12.2-.4-26.3-12.6-31.5c-3.1-1.3-6.3-1.9-9.4-1.9c-9.3 0-18.2 5.5-22.1 14.6l-48 112zm112 0c-5.2 12.2 .4 26.3 12.6 31.5s26.3-.4 31.5-12.6l48-112c5.2-12.2-.4-26.3-12.6-31.5c-3.1-1.3-6.3-1.9-9.4-1.9c-9.3 0-18.2 5.5-22.1 14.6l-48 112zm120 0c-5.2 12.2 .4 26.3 12.6 31.5s26.3-.4 31.5-12.6l48-112c1.3-3.1 1.9-6.3 1.9-9.4c0-9.3-5.5-18.2-14.6-22.1c-3.1-1.3-6.3-1.9-9.4-1.9c-9.3 0-18.2 5.5-22.1 14.6l-48 112z", "M0 224c0 53 43 96 96 96l320 0c53 0 96-43 96-96s-43-96-96-96c-.5 0-1.1 0-1.6 0c1.1-5.2 1.6-10.5 1.6-16c0-44.2-35.8-80-80-80c-24.3 0-46.1 10.9-60.8 28C256.5 24.3 219.1 0 176 0C114.1 0 64 50.1 64 112c0 7.1 .7 14.1 1.9 20.8C27.6 145.4 0 181.5 0 224z"]]
}, faHeadphonesSimple = {
  prefix: "fad",
  iconName: "headphones-simple",
  icon: [512, 512, ["headphones-alt"], "f58f", ["M0 288L0 392c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104C48 173.1 141.1 80 256 80s208 93.1 208 208l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104C512 146.6 397.4 32 256 32S0 146.6 0 288z", "M144 288c-35.3 0-64 28.7-64 64l0 64c0 35.3 28.7 64 64 64l16 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l-16 0zm224 0l-16 0c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l16 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64z"]]
}, faHeadphonesAlt = faHeadphonesSimple, faSitemap = {
  prefix: "fad",
  iconName: "sitemap",
  icon: [576, 512, [], "f0e8", ["M56 288l0 32 48 0 0-32c0-4.4 3.6-8 8-8l152 0 0 40 48 0 0-40 152 0c4.4 0 8 3.6 8 8l0 32 48 0 0-32c0-30.9-25.1-56-56-56l-152 0 0-40-48 0 0 40-152 0c-30.9 0-56 25.1-56 56z", "M208 80c0-26.5 21.5-48 48-48l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64zM48 320l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48zm208 0l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48zm208 0l64 0c26.5 0 48 21.5 48 48l0 64c0 26.5-21.5 48-48 48l-64 0c-26.5 0-48-21.5-48-48l0-64c0-26.5 21.5-48 48-48z"]]
}, faPipeSection = {
  prefix: "fad",
  iconName: "pipe-section",
  icon: [640, 512, [], "e438", ["M64 128l0 256 512 0 0-256L64 128z", "M64 128c0-17.7-14.3-32-32-32S0 110.3 0 128L0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-256zm576 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32s32-14.3 32-32l0-256z"]]
}, faSpaceStationMoonConstruction = {
  prefix: "fad",
  iconName: "space-station-moon-construction",
  icon: [512, 512, ["space-station-moon-alt"], "e034", ["M0 256c0 7.8 .3 15.5 1 23.1C73.2 304.7 160.8 320 256 320s182.8-15.3 255-40.9c.7-7.6 1-15.3 1-23.1c0-10.8-.7-21.5-2-32l-62 0 0-64-80 0 0-64 48 0 0-39.9C372.2 21 316.5 0 256 0C114.6 0 0 114.6 0 256zm6.8 58.8C33.4 427.9 134.9 512 256 512c76.5 0 145.1-33.5 192-86.7l0-41.3-64 0 0-41.2c-40.7 6-83.7 9.2-128 9.2c-91.3 0-176.6-13.6-249.2-37.2zM272 160a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M224 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-112 0a80 80 0 1 1 160 0 80 80 0 1 1 -160 0zM6.8 314.8C4.1 303.2 2.1 291.3 1 279.1C73.2 304.7 160.8 320 256 320s182.8-15.3 255-40.9c-1.1 12.2-3 24.1-5.8 35.8C432.6 338.4 347.3 352 256 352s-176.6-13.6-249.2-37.2z"]]
}, faSpaceStationMoonAlt = faSpaceStationMoonConstruction, faCircleDollarToSlot = {
  prefix: "fad",
  iconName: "circle-dollar-to-slot",
  icon: [512, 512, ["donate"], "f4b9", ["M48 208a208 208 0 1 0 416 0A208 208 0 1 0 48 208zm140.2-41.4c.1-1.3 .2-2.5 .4-3.7c.3-2.4 .9-4.8 1.5-7c1.3-4.5 3.2-8.5 5.6-12.2c4.7-7.3 11.2-13 18.2-17.1c6.9-4.1 14.5-6.8 22.2-8.5l0-14c0-11 9-20 20-20s20 9 20 20l0 13.9c7.5 1.2 14.6 2.9 21.1 4.7c10.7 2.8 17 13.8 14.2 24.5s-13.8 17-24.5 14.2c-11-2.9-21.6-5-31.2-5.2c-7.9-.1-16 1.8-21.5 5c-4.8 2.8-6.2 5.6-6.2 9.3c0 1.8 .1 3.5 5.3 6.7c6.3 3.8 15.5 6.7 28.3 10.5l.7 .2c11.2 3.4 25.6 7.7 37.1 15c12.9 8.1 24.3 21.3 24.6 41.6c0 .7 0 1.3 0 1.9s0 1.3-.1 1.9c-.1 1.3-.2 2.5-.3 3.7c-.3 2.4-.7 4.8-1.3 7c-1.2 4.5-3 8.6-5.2 12.4c-4.4 7.5-10.7 13.5-17.9 18c-7.2 4.5-15.2 7.3-23.2 9l0 13.8c0 11-9 20-20 20s-20-9-20-20l0-14.6c-10.3-2.2-20-5.5-28.3-8.4c-2.1-.7-4.1-1.4-6.1-2.1c-10.5-3.5-16.1-14.8-12.6-25.3s14.8-16.1 25.3-12.6c2.5 .8 4.9 1.7 7.2 2.4c13.6 4.6 24 8.1 35.1 8.5c8.6 .3 16.5-1.6 21.4-4.7c4.1-2.5 6-5.5 5.9-10.5c0-2.9-.8-5-5.9-8.2c-6.3-4-15.4-6.9-28-10.7l-1.7-.5c-10.9-3.3-24.6-7.4-35.6-14c-12.7-7.7-24.6-20.5-24.7-40.7c0-.7 0-1.3 0-2s.1-1.3 .1-1.9z", "M276 104c0-11-9-20-20-20s-20 9-20 20l0 14c-7.6 1.7-15.2 4.4-22.2 8.5c-13.9 8.3-25.9 22.8-25.8 43.9c.1 20.3 12 33.1 24.7 40.7c11 6.6 24.7 10.8 35.6 14l1.7 .5c12.6 3.8 21.8 6.8 28 10.7c5.1 3.2 5.8 5.4 5.9 8.2c.1 5-1.8 8-5.9 10.5c-5 3.1-12.9 5-21.4 4.7c-11.1-.4-21.5-3.9-35.1-8.5c-2.3-.8-4.7-1.6-7.2-2.4c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3c1.9 .6 4 1.3 6.1 2.1c0 0 0 0 0 0s0 0 0 0c8.3 2.9 17.9 6.2 28.2 8.4l0 14.6c0 11 9 20 20 20s20-9 20-20l0-13.8c8-1.7 16-4.5 23.2-9c14.3-8.9 25.1-24.1 24.8-45c-.3-20.3-11.7-33.4-24.6-41.6c-11.5-7.2-25.9-11.6-37.1-15l-.7-.2c-12.8-3.9-21.9-6.7-28.3-10.5c-5.2-3.1-5.3-4.9-5.3-6.7c0-3.7 1.4-6.5 6.2-9.3c5.4-3.2 13.6-5.1 21.5-5c9.6 .1 20.2 2.2 31.2 5.2c10.7 2.8 21.6-3.5 24.5-14.2s-3.5-21.6-14.2-24.5c-6.5-1.7-13.7-3.4-21.1-4.7l0-13.9zM64 352l-16 0c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-16 0c-19.4 25.9-44 47.7-72.2 64l72.2 0 0 32-192 0L64 448l0-32 72.2 0C108 399.7 83.4 377.9 64 352z"]]
}, faDonate = faCircleDollarToSlot, faMemory = {
  prefix: "fad",
  iconName: "memory",
  icon: [576, 512, [], "f538", ["M0 128l0 7.4c0 6.8 4.4 12.6 10.1 16.3C23.3 160.3 32 175.1 32 192s-8.7 31.7-21.9 40.3C4.4 236 0 241.8 0 248.6L0 320l576 0 0-71.4c0-6.8-4.4-12.6-10.1-16.3C552.7 223.7 544 208.9 544 192s8.7-31.7 21.9-40.3c5.7-3.7 10.1-9.5 10.1-16.3l0-7.4c0-35.3-28.7-64-64-64L64 64C28.7 64 0 92.7 0 128zm128 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm128 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm128 0c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64z", "M192 160l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zm128 0l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32zM0 416l0-96 576 0 0 96c0 17.7-14.3 32-32 32l-48 0 0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-96 0 0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-96 0 0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-96 0 0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-48 0c-17.7 0-32-14.3-32-32z"]]
}, faFaceSleeping = {
  prefix: "fad",
  iconName: "face-sleeping",
  icon: [512, 512, [], "e38d", ["M0 256C0 397.4 114.6 512 256 512s256-114.6 256-256c0-46.6-12.5-90.3-34.2-128L432 128c-19.4 0-36.9-11.7-44.3-29.6c-7.1-17.1-3.7-36.7 8.6-50.4c-2.9-3.2-5.4-6.9-7.3-10.8C350.2 13.6 304.7 0 256 0C114.6 0 0 114.6 0 256zm99.2 1.6c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0zM296 384a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zM256.3 76.8c.2-1 .5-2 .9-3c.8-1.9 2-3.6 3.4-5.1c2.9-2.9 6.9-4.7 11.3-4.7l64 0c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4c-12.2 12.2-24.5 24.5-36.7 36.7l25.4 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4c12.2-12.2 24.5-24.5 36.7-36.7L272 96c-4.4 0-8.4-1.8-11.3-4.7c-1.4-1.4-2.6-3.2-3.4-5.1c-.4-1-.7-2-.9-3c-.1-.5-.2-1.1-.2-1.6s-.1-1.1-.1-1.8c0-.4 0-1 .1-1.5s.1-1.1 .2-1.6zm34.9 180.8c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0z", "M416 16c0 8.8 7.2 16 16 16l25.4 0L420.7 68.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-25.4 0 36.7-36.7c4.6-4.6 5.9-11.5 3.5-17.4S502.5 0 496 0L432 0c-8.8 0-16 7.2-16 16zM256 80c0 8.8 7.2 16 16 16l25.4 0-36.7 36.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-25.4 0 36.7-36.7c4.6-4.6 5.9-11.5 3.5-17.4s-8.3-9.9-14.8-9.9l-64 0c-8.8 0-16 7.2-16 16zM387.2 238.4c-17.6 23.5-52.8 23.5-70.4 0c-5.3-7.1-15.3-8.5-22.4-3.2s-8.5 15.3-3.2 22.4c30.4 40.5 91.2 40.5 121.6 0c5.3-7.1 3.9-17.1-3.2-22.4s-17.1-3.9-22.4 3.2zm-262.4 0c-5.3-7.1-15.3-8.5-22.4-3.2s-8.5 15.3-3.2 22.4c30.4 40.5 91.2 40.5 121.6 0c5.3-7.1 3.9-17.1-3.2-22.4s-17.1-3.9-22.4 3.2c-17.6 23.5-52.8 23.5-70.4 0z"]]
}, faRoadSpikes = {
  prefix: "fad",
  iconName: "road-spikes",
  icon: [640, 512, [], "e568", ["M32 114.8L32 384l128 0 34.5 0 93.5 0 34.5 0 93.5 0 34.5 0L608 384c0-29.8-9.2-58.8-26.2-83.2L445.1 105.6c-9-12.8-29.1-6.5-29.1 9.2l0 132.1L317.1 105.6c-9-12.8-29.1-6.5-29.1 9.2l0 132.1L189.1 105.6c-9-12.8-29.1-6.5-29.1 9.2l0 132.1L61.1 105.6c-9-12.8-29.1-6.5-29.1 9.2z", "M0 416c0-17.7 14.3-32 32-32l576 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 448c-17.7 0-32-14.3-32-32z"]]
}, faFireBurner = {
  prefix: "fad",
  iconName: "fire-burner",
  icon: [640, 512, [], "e4f1", ["M0 416l0 64c0 17.7 14.3 32 32 32l576 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-104c0-13.3-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l24 0 0 80L80 384l0-80 24 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24l0 104c-17.7 0-32 14.3-32 32zm224 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm128 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm128 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M358 34.5L345.7 48.3l-19-19.9c-2-2.1-4-4.4-6-6.7C311.8 11.4 302.1 .4 288 0c-7.3-.2-14.6 2.3-20.3 7.5c-23.4 21.1-50 48.9-70.9 80.2C176 118.8 160 154.8 160 192.2C160 280.7 230.4 352 320 352c88.7 0 160-71.2 160-159.8c0-30-11-60.9-26.2-88.1c-15.2-27.4-35.3-52.3-55-70.6c-5.6-5.2-12.8-7.8-19.9-7.8c-7.6 0-15.5 2.8-20.9 8.9zM320 304.2c-35.3 0-64-28.7-64-64c0-36.5 37-73 54.8-88.4c5.4-4.7 13.1-4.7 18.5 0C347 167.1 384 203.6 384 240.2c0 35.3-28.7 64-64 64z"]]
}, faSquirrel = {
  prefix: "fad",
  iconName: "squirrel",
  icon: [512, 512, [], "f71a", ["M0 144c0 79.5 64.5 144 144 144c2.3 0 4.6-.1 6.9-.2c4.9-.2 9.1 3.5 9.1 8.4c0 2-.7 3.9-2 5.4c-18.7 22.3-30 51-30 82.3c0 70.7 57.3 128 128 128c16 0 32 0 48 0c-62-.6-112-51-112-113.1l0-3.8c0-27.6 11-54.1 30.5-73.6l7-7c1.5-1.5 3-3 4.5-4.5s2.9-3.1 4.4-4.6c2.9-3.1 5.7-6.3 8.4-9.5c5.5-6.4 10.6-13.1 15.5-19.9c9.8-13.6 18.4-28 25.8-43l0-88.9C288 64.5 223.5 0 144 0S0 64.5 0 144z", "M320 75.2C320 69 325 64 331.2 64c15.2 0 28.7 7.6 36.8 19.2C376.1 71.6 389.6 64 404.8 64C411 64 416 69 416 75.2L416 96c53 0 96 43 96 96l-8.2 12.4c-14.8 22.3-39.8 35.6-66.6 35.6L416 240l0 58.8c-14.5-6.9-30.8-10.8-48-10.8c-13.1 0-25.6 2.2-37.3 6.4c-8.3 2.9-12.7 12.1-9.8 20.4s12.1 12.7 20.4 9.8c8.3-2.9 17.3-4.5 26.7-4.5c18 0 34.6 6 48 16c19.4 14.6 32 37.8 32 64c0 18-6 34.6-16 48l16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-72 0-24 0-32 0-14.9 0-1.1 0s0 0 0 0c-62-.6-112-51-112-113.1l0-3.8c0-27.6 11-54.1 30.5-73.6l7-7C287.4 256.6 320 178 320 96l0-20.8zM416 176a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]]
}, faArrowUpToLine = {
  prefix: "fad",
  iconName: "arrow-up-to-line",
  icon: [384, 512, ["arrow-to-top"], "f341", ["M0 64C0 46.3 14.3 32 32 32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64z", "M169.4 169.4c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L224 269.3 224 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-178.7L86.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128z"]]
}, faArrowToTop = faArrowUpToLine, faFlag = {
  prefix: "fad",
  iconName: "flag",
  icon: [448, 512, [127988, 61725], "f024", ["M64 48l69-17.2c38.1-9.5 78.3-5.1 113.5 12.5c46.3 23.2 100.8 23.2 147.1 0l9.6-4.8C423.8 28.1 448 43.1 448 66.1l0 247.7c0 13.3-8.3 25.3-20.8 30l-34.7 13c-20.1 7.6-41.3 11.3-62.3 11.3c-27.3 0-54.5-6.3-79.4-18.7c-37.9-19-81.3-23.7-122.5-13.4L64 352 64 48z", "M32 0C49.7 0 64 14.3 64 32l0 448c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 32C0 14.3 14.3 0 32 0z"]]
}, faFaceCowboyHat = {
  prefix: "fad",
  iconName: "face-cowboy-hat",
  icon: [512, 512, [], "e36e", ["M48 304c0-49.4 17.2-94.7 45.9-130.4c21.3 15.6 46.2 28.2 73.6 36.9c13.7 4.3 28 7.7 42.8 10c7.4 1.1 14.9 2 22.5 2.6c3.8 .3 7.6 .5 11.4 .7s7.7 .2 11.7 .2c62.5 0 119.4-19.1 162.1-50.4c28.7 35.7 45.9 81 45.9 130.4c0 114.9-93.1 208-208 208S48 418.9 48 304zm98 79.5C166.2 424.1 208 452 256.2 452s90-27.9 110.2-68.6c5.7-11.5-6.2-22.2-18.6-18.8c-27.9 7.8-59 12.1-91.6 12.1s-63.7-4.3-91.6-12.1c-12.4-3.5-24.3 7.3-18.6 18.8zM168 296a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm128 0a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M133.6 109.8C148.6 64.9 179.2 0 216 0c9.1 0 17.9 4 26.1 10.7c7.9 6.5 19.8 6.5 27.7 0C278.1 4 286.9 0 296 0c36.8 0 67.4 64.9 82.4 109.8C412 99.3 442 84.6 466.9 66.8c2.5-1.8 5.4-2.8 8.4-2.8c8.9 0 15.6 8.3 12.9 16.7C461.2 163.2 367.5 224 256 224S50.8 163.2 23.8 80.7C21 72.3 27.7 64 36.7 64c3 0 6 1 8.4 2.8C70 84.6 100 99.3 133.6 109.8zM168 296a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm152-24a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faHanukiah = {
  prefix: "fad",
  iconName: "hanukiah",
  icon: [640, 512, [128334], "f6e6", ["M8 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7C36.6 49.2 34.4 48 32 48s-4.6 1.2-5.8 3.3C21.1 60.1 8 84.6 8 104zm80 0c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C101.1 60.1 88 84.6 88 104zm64 0c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C165.1 60.1 152 84.6 152 104zm64 0c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C229.1 60.1 216 84.6 216 104zm80-48c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7C324.6 1.2 322.4 0 320 0s-4.6 1.2-5.8 3.3C309.1 12.1 296 36.6 296 56zm80 48c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C389.1 60.1 376 84.6 376 104zm64 0c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C453.1 60.1 440 84.6 440 104zm64 0c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C517.1 60.1 504 84.6 504 104zm80 0c0 13.3 10.7 24 24 24s24-10.7 24-24c0-19.4-13.1-43.9-18.2-52.7c-1.2-2.1-3.4-3.3-5.8-3.3s-4.6 1.2-5.8 3.3C597.1 60.1 584 84.6 584 104z", "M352 144c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 176L96 320c-17.7 0-32-14.3-32-32l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 53 43 96 96 96l192 0 0 64-128 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0 160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0 0-64 192 0c53 0 96-43 96-96l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 17.7-14.3 32-32 32l-192 0 0-176zM128 176c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96zm160 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96zm64 0c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96 0 16 32 0 0-16 0-96z"]]
}, faChartScatter3d = {
  prefix: "fad",
  iconName: "chart-scatter-3d",
  icon: [512, 512, [], "e0e8", ["M32 448c0 7.2 2.4 14.5 7.4 20.5c11.3 13.6 31.5 15.4 45.1 4.1L256 329.7 427.5 472.6c13.6 11.3 33.8 9.5 45.1-4.1s9.5-33.8-4.1-45.1L288 273l0-209c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 209L43.5 423.4C35.9 429.7 32 438.8 32 448z", "M32 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM416 64a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm0 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64-64a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM160 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM64 256A32 32 0 1 0 0 256a32 32 0 1 0 64 0zM256 480a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faDisplayChartUp = {
  prefix: "fad",
  iconName: "display-chart-up",
  icon: [576, 512, [], "e5e3", ["M0 64L0 352c0 35.3 28.7 64 64 64l176 0 96 0 176 0c35.3 0 64-28.7 64-64l0-288c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zm64 0l448 0 0 288L64 352 64 64z", "M64 64l448 0 0 288L64 352 64 64zM346.7 448l69.3 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-256 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l69.3 0L240 416l96 0 10.7 32zM344 112c-13.3 0-24 10.7-24 24s10.7 24 24 24l38.1 0L304 238.1l-63-63c-9.4-9.4-24.6-9.4-33.9 0l-88 88c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l71-71 63 63c4.5 4.5 10.6 7 17 7s12.5-2.5 17-7l95-95 0 38.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96c0-13.3-10.7-24-24-24l-96 0z"]]
}, faSquareCode = {
  prefix: "fad",
  iconName: "square-code",
  icon: [448, 512, [], "e267", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM64 256c0 6.8 2.9 13.3 7.9 17.8c26.7 24 53.3 48 80 72c9.9 8.9 25 8.1 33.9-1.8s8.1-25-1.8-33.9c-20.1-18.1-40.1-36.1-60.2-54.2c20.1-18.1 40.1-36.1 60.2-54.2c9.9-8.9 10.7-24 1.8-33.9s-24-10.7-33.9-1.8c-26.7 24-53.3 48-80 72c-5.1 4.6-7.9 11-7.9 17.8zm198.2-88.1c-8.9 9.9-8.1 25 1.8 33.9c20.1 18.1 40.1 36.1 60.2 54.2c-20.1 18.1-40.1 36.1-60.2 54.2c-9.9 8.9-10.7 24-1.8 33.9s24 10.7 33.9 1.8c26.7-24 53.3-48 80-72c5.1-4.6 7.9-11 7.9-17.8s-2.9-13.3-7.9-17.8c-26.7-24-53.3-48-80-72c-9.9-8.9-25-8.1-33.9 1.8z", "M184.1 201.8c9.9-8.9 10.7-24 1.8-33.9s-24-10.7-33.9-1.8l-80 72c-5.1 4.6-7.9 11-7.9 17.8s2.9 13.3 7.9 17.8l80 72c9.9 8.9 25 8.1 33.9-1.8s8.1-25-1.8-33.9L123.9 256l60.2-54.2zm79.9 0L324.1 256l-60.2 54.2c-9.9 8.9-10.7 24-1.8 33.9s24 10.7 33.9 1.8l80-72c5.1-4.6 7.9-11 7.9-17.8s-2.9-13.3-7.9-17.8l-80-72c-9.9-8.9-25-8.1-33.9 1.8s-8.1 25 1.8 33.9z"]]
}, faFeather = {
  prefix: "fad",
  iconName: "feather",
  icon: [512, 512, [129718], "f52d", ["M64 330l0 84c82.4-82.4 164.7-164.7 247-247c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7s7 10.8 7 17s-2.3 12.3-7 17L97.9 448l84 0c49.7 0 97.9-14.4 139-41c11.1-7.2 5.5-23-7.8-23c-5.1 0-9.2-4.1-9.2-9.2c0-4.1 2.7-7.6 6.5-8.8l81-24.3c2.5-.8 4.8-2.1 6.7-4l22.4-22.4c10.1-10.1 2.9-27.3-11.3-27.3l-32.2 0c-5.1 0-9.2-4.1-9.2-9.2c0-4.1 2.7-7.6 6.5-8.8l112-33.6c4-1.2 7.4-3.9 9.3-7.7C506.4 207.6 512 184.1 512 160c0-41-16.3-80.3-45.3-109.3l-5.5-5.5C432.3 16.3 393 0 352 0s-80.3 16.3-109.3 45.3L139 149C91 197 64 262.1 64 330z", "M24 512c-6.2 0-12.3-2.3-17-7c-9.4-9.4-9.4-24.6 0-33.9L311 167c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L41 505c-4.7 4.7-10.8 7-17 7z"]]
}, faVolumeLow = {
  prefix: "fad",
  iconName: "volume-low",
  icon: [448, 512, [128264, "volume-down"], "f027", ["M378.8 185c4.7-5.8 11.7-8.9 18.6-8.9c5.3 0 10.7 1.8 15.1 5.4C434.1 199.1 448 225.9 448 256s-13.9 56.9-35.4 74.5c-4.5 3.6-9.8 5.4-15.1 5.4c-7 0-13.9-3-18.6-8.9c-8.4-10.3-6.8-25.4 3.5-33.8C393.1 284.4 400 271 400 256s-6.9-28.4-17.7-37.3c-10.3-8.4-11.8-23.5-3.5-33.8z", "M320 64c0-12.6-7.4-24-18.9-29.2s-25-3.1-34.4 5.3L131.8 160 64 160c-35.3 0-64 28.7-64 64l0 64c0 35.3 28.7 64 64 64l67.8 0L266.7 471.9c9.4 8.4 22.9 10.4 34.4 5.3S320 460.6 320 448l0-384z"]]
}, faVolumeDown = faVolumeLow, faXmarkToSlot = {
  prefix: "fad",
  iconName: "xmark-to-slot",
  icon: [576, 512, ["times-to-slot", "vote-nay"], "f771", ["M96 80l0 208 0 80 0 32 384 0 0-32 0-80 0-208c0-26.5-21.5-48-48-48L144 32c-26.5 0-48 21.5-48 48zm111 55c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7l47 47 47-47c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c9.4 9.4 9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z", "M207 135c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9zM48 288l48 0 0 80-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l416 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-80 48 0c26.5 0 48 21.5 48 48l0 96c0 26.5-21.5 48-48 48L48 480c-26.5 0-48-21.5-48-48l0-96c0-26.5 21.5-48 48-48z"]]
}, faTimesToSlot = faXmarkToSlot, faVoteNay = faXmarkToSlot, faBoxTaped = {
  prefix: "fad",
  iconName: "box-taped",
  icon: [448, 512, ["box-alt"], "f49a", ["M0 160l160 0L192 32 93.7 32C75.5 32 58.9 42.3 50.7 58.5L0 160zm160 0l128 0 0 96c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-96zM256 32l32 128 160 0L397.3 58.5C389.1 42.3 372.5 32 354.3 32L256 32z", "M160 160L0 160 0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-256-160 0 0 96c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-96z"]]
}, faBoxAlt = faBoxTaped, faCommentSlash = {
  prefix: "fad",
  iconName: "comment-slash",
  icon: [640, 512, [], "f4b3", ["M64 240c0-27.8 6.7-54.4 18.9-78.7L424.1 430.1C392.3 441.6 357 448 320 448c-37.1 0-72.3-6.4-104.1-17.9c-11.9 8.7-31.3 20.6-54.3 30.6C137.6 471.1 108.7 480 80 480c-6.5 0-12.3-3.9-14.8-9.9c-.8-2-1.2-4.1-1.2-6.1c0-4.2 1.6-8.2 4.7-11.3l.3-.3c.3-.3 .7-.7 1.3-1.4c1.1-1.2 2.8-3.1 4.9-5.7c4.1-5 9.6-12.4 15.2-21.6c10-16.6 19.5-38.4 21.4-62.9C81.7 326.8 64 285.1 64 240zM144.9 88.3C190.7 53.4 252.3 32 320 32c141.4 0 256 93.1 256 208c0 52.3-23.8 100.2-63.1 136.7c-122.7-96.1-245.3-192.3-368-288.5z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faSwords = {
  prefix: "fad",
  iconName: "swords",
  icon: [512, 512, [9876], "f71d", ["M.3 19.1L14.4 89.6c1.9 9.3 6.4 17.8 13.1 24.5L329.4 416 416 329.4 114.2 27.5c-6.7-6.7-15.2-11.3-24.5-13.1L19.1 .3C13.9-.7 8.5 .9 4.7 4.7S-.7 13.9 .3 19.1zM96 329.4c28.9 28.9 57.7 57.7 86.6 86.6l50.7-50.7-86.6-86.6L96 329.4zM278.6 146.7l86.6 86.6L484.5 114.2c6.7-6.7 11.3-15.2 13.1-24.5l14.1-70.5c.2-1 .3-2.1 .3-3.1c0-4.2-1.7-8.3-4.7-11.3c-3.8-3.8-9.2-5.4-14.5-4.4L422.4 14.4c-9.3 1.9-17.8 6.4-24.5 13.1L278.6 146.7z", "M75.3 308.7c-6.2-6.2-16.4-6.2-22.6 0l-16 16c-4.7 4.7-6 11.8-3.3 17.8l27.5 62L4.7 460.7c-6.2 6.2-6.2 16.4 0 22.6l24 24c6.2 6.2 16.4 6.2 22.6 0l56.2-56.2 62 27.5c6 2.7 13.1 1.4 17.8-3.3l16-16c6.2-6.2 6.2-16.4 0-22.6l-128-128zm361.4 0l-128 128c-6.2 6.2-6.2 16.4 0 22.6l16 16c4.7 4.7 11.8 6 17.8 3.3l62-27.5 56.2 56.2c6.2 6.2 16.4 6.2 22.6 0l24-24c6.2-6.2 6.2-16.4 0-22.6l-56.2-56.2 27.5-62c2.7-6.1 1.4-13.1-3.3-17.8l-16-16c-6.2-6.2-16.4-6.2-22.6 0z"]]
}, faCloudSunRain = {
  prefix: "fad",
  iconName: "cloud-sun-rain",
  icon: [640, 512, [127782], "f743", ["M0 128c0 3.2 1 6.4 2.9 9.2L52.5 208 2.9 278.8c-3.2 4.5-3.8 10.3-1.6 15.4s6.7 8.7 12.1 9.6l84.7 14.1 14.1 84.7c.9 5.4 4.5 10 9.6 12.1s10.9 1.5 15.4-1.6l56-39.2c-19.9-22-32.3-50.9-33.1-82.7c-28.7-16.6-48-47.6-48-83.2c0-53 43-96 96-96c18.4 0 35.6 5.2 50.2 14.1c13.2-21.9 32.7-39.5 56-50.3L303.8 13.4c-.9-5.4-4.5-10-9.6-12.1c-2-.8-4.1-1.2-6.2-1.2c-3.2 0-6.4 1-9.2 2.9L208 52.5 137.2 2.9c-4.5-3.2-10.3-3.8-15.4-1.6s-8.7 6.7-9.6 12.1L98.1 98.1 13.4 112.2c-5.4 .9-10 4.5-12.1 9.6c-.8 2-1.2 4.1-1.2 6.2zm144 80c0 18.5 7.8 35.1 20.3 46.8c10.6-39.7 39.9-71.8 77.8-86.4c.8-4.3 1.8-8.4 3-12.6C234.7 148.4 221.8 144 208 144c-35.3 0-64 28.7-64 64zm68.1 266.7c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l32-48c7.4-11 4.4-25.9-6.7-33.3s-25.9-4.4-33.3 6.7l-32 48zm96 0c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l32-48c7.4-11 4.4-25.9-6.7-33.3s-25.9-4.4-33.3 6.7l-32 48zm96 0c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l32-48c7.4-11 4.4-25.9-6.7-33.3s-25.9-4.4-33.3 6.7l-32 48zm96 0c-7.4 11-4.4 25.9 6.7 33.3s25.9 4.4 33.3-6.7l32-48c2.7-4.1 4-8.7 4-13.3c0-7.8-3.8-15.4-10.7-20c-11-7.4-25.9-4.4-33.3 6.7l-32 48z", "M559.9 383.9c44.2 0 80-35.8 80-80c0-39.3-28.4-72.1-65.8-78.7c1.2-5.6 1.9-11.3 1.9-17.2c0-44.2-35.8-80-80-80c-17 0-32.8 5.3-45.8 14.4C433.3 114.6 402.8 96 368 96c-53 0-96 43-96 96l0 1.3c-45.4 7.6-80 47.1-80 94.6c0 53 43 96 96 96l271.9 0z"]]
}, faAlbum = {
  prefix: "fad",
  iconName: "album",
  icon: [448, 512, [128189], "f89f", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM384 256A160 160 0 1 1 64 256a160 160 0 1 1 320 0z", "M224 416a160 160 0 1 0 0-320 160 160 0 1 0 0 320zm0-192a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]]
}, faCircleN = {
  prefix: "fad",
  iconName: "circle-n",
  icon: [512, 512, [], "e118", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM160 152c0-10.5 6.8-19.8 16.8-22.9s20.9 .6 26.9 9.2c33.4 48.3 66.8 96.6 100.3 144.8L304 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 208c0 10.5-6.8 19.8-16.8 22.9c-2.4 .7-4.8 1.1-7.2 1.1c-7.7 0-15.2-3.7-19.7-10.3c-33.4-48.3-66.8-96.6-100.3-144.8L208 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208z", "M176.8 129.1c10-3.1 20.9 .6 26.9 9.2L304 283.2 304 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 208c0 10.5-6.8 19.8-16.8 22.9s-20.9-.6-26.9-9.2L208 228.8 208 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-10.5 6.8-19.8 16.8-22.9z"]]
}, faCompress = {
  prefix: "fad",
  iconName: "compress",
  icon: [448, 512, [], "f066", ["M0 352c0 17.7 14.3 32 32 32l64 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32zM288 64l0 96c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M160 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0c17.7 0 32-14.3 32-32l0-96zM320 320c-17.7 0-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0z"]]
}, faWheatAwn = {
  prefix: "fad",
  iconName: "wheat-awn",
  icon: [512, 512, ["wheat-alt"], "e2cd", ["M0 480c0 8.2 3.1 16.4 9.4 22.6s14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4l68.9-68.9c-3.5-3.5-6.9-6.9-10.4-10.4c-4.8-4.8-9.6-9.6-14.4-14.4c-6.8-6.8-13.6-13.6-20.4-20.4L9.4 457.4C3.1 463.6 0 471.8 0 480zM145.7 368.1c1-.3 2-.6 2.9-.8c1-.3 2-.5 3-.7c2-.5 3.9-.9 5.9-1.2c4-.7 7.9-1.3 11.9-1.6c8-.7 16.1-.7 24.1 .1c10.6-10.6 21.3-21.3 31.9-31.9c-3.5-3.5-6.9-6.9-10.4-10.4c-11.6-11.6-23.2-23.2-34.8-34.8l-30.5 30.5c2.1 17 .8 34.4-4 51zM247.5 266.3c2-.6 4-1.1 5.9-1.5s3.9-.9 5.9-1.2c4-.7 8-1.3 12-1.7c8-.7 16.1-.7 24.1 .1c10.6-10.6 21.3-21.3 31.9-31.9l-10.4-10.4L294.2 197l-12.2-12.2-30.5 30.5c2.1 17 .8 34.4-4 51zM329.1 52.9c10.5 14.1 17.7 29.9 21.6 46.3L409 41c9.4-9.4 9.4-24.6 0-33.9c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7L329.1 52.9zM383 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l88-88c9.4-9.4 9.4-24.6 0-33.9c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7L383 95zm28.6 67.4c16.6 3.6 32.7 10.5 47.1 20.8L505 137c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-59.4 59.4z", "M282.8 27.3c6.2-6.2 16.4-6.2 22.6 0l11.3 11.3c34.1 34.1 44.9 82.6 32.5 125.9c43.3-12.4 91.8-1.5 125.9 32.5l11.3 11.3c6.2 6.2 6.2 16.4 0 22.6l-11.3 11.3c-37.5 37.5-98.3 37.5-135.8 0l-22.6-22.6s0 0 0 0l-45.3-45.3c-37.5-37.5-37.5-98.3 0-135.8l11.3-11.3zM203.6 129.1L215 140.5c34.1 34.1 44.9 82.6 32.5 125.9c43.3-12.4 91.8-1.5 125.9 32.5l11.3 11.3c6.2 6.2 6.2 16.4 0 22.6l-11.3 11.3c-37.5 37.5-98.3 37.5-135.8 0L215 321.5s0 0 0 0l-45.3-45.3c-37.5-37.5-37.5-98.3 0-135.8L181 129.1c6.2-6.2 16.4-6.2 22.6 0zM79.2 231c6.2-6.2 16.4-6.2 22.6 0l11.3 11.3c34.1 34.1 44.9 82.6 32.5 125.9c43.3-12.4 91.8-1.5 125.9 32.5L282.8 412c6.2 6.2 6.2 16.4 0 22.6l-11.3 11.3c-37.5 37.5-98.3 37.5-135.8 0l-22.6-22.6s0 0 0 0L67.9 378c-37.5-37.5-37.5-98.3 0-135.8L79.2 231z"]]
}, faWheatAlt = faWheatAwn, faAnkh = {
  prefix: "fad",
  iconName: "ankh",
  icon: [320, 512, [9765], "f644", ["M128 320l19.4 0 25.1 0 19.4 0 0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160z", "M160 64c-35.3 0-64 28.7-64 64c0 41.6 20.7 76.6 46.6 104.1c5.9 6.2 11.8 11.8 17.4 16.7c5.6-4.9 11.5-10.5 17.4-16.7C203.3 204.6 224 169.6 224 128c0-35.3-28.7-64-64-64zM32 128C32 57.3 89.3 0 160 0s128 57.3 128 128c0 52.4-21.5 95.5-46.8 128l46.8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-115.4 0-25.1 0L32 320c-17.7 0-32-14.3-32-32s14.3-32 32-32l46.8 0C53.5 223.5 32 180.4 32 128z"]]
}, faHandsHoldingChild = {
  prefix: "fad",
  iconName: "hands-holding-child",
  icon: [640, 512, [], "e4fa", ["M0 104l0 56 0 64L0 325.5c0 25.5 10.1 49.9 28.1 67.9L128 493.3c12 12 28.3 18.7 45.3 18.7l66.7 0c26.5 0 48-21.5 48-48l0-78.9c0-29.7-11.8-58.2-32.8-79.2l-25.3-25.3c-5.1-5.1-10.2-10.2-15.2-15.2l-32-32c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l32 32 15.2 15.2c11 11 9.2 29.2-3.7 37.8c-9.7 6.5-22.7 5.2-31-3.1L98.7 309.5c-12-12-18.7-28.3-18.7-45.3L80 224l0-80 0-40c0-22.1-17.9-40-40-40S0 81.9 0 104zM352 385.1l0 78.9c0 26.5 21.5 48 48 48l66.7 0c17 0 33.3-6.7 45.3-18.7l99.9-99.9c18-18 28.1-42.4 28.1-67.9L640 224l0-64 0-56c0-22.1-17.9-40-40-40s-40 17.9-40 40l0 40 0 80 0 40.2c0 17-6.7 33.3-18.7 45.3l-51.1 51.1c-8.3 8.3-21.3 9.6-31 3.1c-12.9-8.6-14.7-26.9-3.7-37.8l15.2-15.2 32-32c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-32 32-15.2 15.2c-8.5 8.5-16.9 16.9-25.4 25.4c-21 21-32.8 49.5-32.8 79.2z", "M280 40a40 40 0 1 1 80 0 40 40 0 1 1 -80 0zM384.5 181l-19.8-16.7L375.8 253c1.6 13.2-7.7 25.1-20.8 26.8s-25.1-7.7-26.8-20.8l-4.4-35-7.6 0-4.4 35c-1.6 13.2-13.6 22.5-26.8 20.8s-22.5-13.6-20.8-26.8l11.1-88.8L255.5 181c-10.1 8.6-25.3 7.3-33.8-2.8s-7.3-25.3 2.8-33.8L266 109.2c10.1-8.5 22.9-13.2 36.2-13.2l35.6 0c13.2 0 26 4.7 36.2 13.2l41.5 35.1c10.1 8.6 11.4 23.7 2.8 33.8s-23.7 11.4-33.8 2.8z"]]
}, faAsterisk = {
  prefix: "fad",
  iconName: "asterisk",
  icon: [384, 512, [10033, 61545], "2a", ["M192 32c17.7 0 32 14.3 32 32l0 135.5 111.5-66.9c15.2-9.1 34.8-4.2 43.9 11s4.2 34.8-11 43.9L254.2 256l114.3 68.6c15.2 9.1 20.1 28.7 11 43.9s-28.7 20.1-43.9 11L224 312.5 224 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-135.5L48.5 379.4c-15.2 9.1-34.8 4.2-43.9-11s-4.2-34.8 11-43.9L129.8 256 15.5 187.4c-15.2-9.1-20.1-28.7-11-43.9s28.7-20.1 43.9-11L160 199.5 160 64c0-17.7 14.3-32 32-32z", ""]]
}, faKeySkeletonLeftRight = {
  prefix: "fad",
  iconName: "key-skeleton-left-right",
  icon: [640, 512, [], "e3b4", ["M0 384c0 70.7 57.3 128 128 128c59.6 0 109.8-40.8 124-96l196 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-32 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-68 0c-14.2-55.2-64.3-96-124-96C57.3 256 0 313.3 0 384zm192 0A64 64 0 1 1 64 384a64 64 0 1 1 128 0z", "M512 64a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0 192c70.7 0 128-57.3 128-128S582.7 0 512 0C452.4 0 402.2 40.8 388 96L192 96c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 68 0c14.2 55.2 64.3 96 124 96z"]]
}, faCommentLines = {
  prefix: "fad",
  iconName: "comment-lines",
  icon: [512, 512, [], "f4b0", ["M0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c-4.6 4.6-6 11.5-3.5 17.5c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240zm128-40c0-13.3 10.7-24 24-24l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24z", "M128 200c0-13.3 10.7-24 24-24l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24z"]]
}, faLuchadorMask = {
  prefix: "fad",
  iconName: "luchador-mask",
  icon: [448, 512, ["luchador", "mask-luchador"], "f455", ["M64 208c0 44.2 35.8 80 80 80l13.3 0c-3.4 6.3-5.3 13.4-5.3 20.7c0 4 .6 7.9 1.6 11.6C121.2 323.5 96 350.8 96 384c0 35.3 28.7 64 64 64l128 0c35.3 0 64-28.7 64-64c0-33.2-25.2-60.5-57.6-63.7c1-3.7 1.6-7.6 1.6-11.6c0-7.3-1.8-14.4-5.3-20.7l13.3 0c44.2 0 80-35.8 80-80c0-26.5-21.5-48-48-48l-32 0c-44.2 0-80 35.8-80 80c0-44.2-35.8-80-80-80l-32 0c-26.5 0-48 21.5-48 48zm32 0c0-8.8 7.2-16 16-16l32 0c26.5 0 48 21.5 48 48c0 8.8-7.2 16-16 16l-32 0c-26.5 0-48-21.5-48-48zm32 176c0-17.7 14.3-32 32-32l35.3 0 57.4 0 35.3 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32zm56-75.3c0-3 1.2-5.9 3.3-8l8-8 4.2-4.2 .4-.4 10.3-10.3c3.6-3.6 8.5-5.7 13.7-5.7s10 2 13.7 5.7L248 288l.4 .4 4.2 4.2 8 8c2.1 2.1 3.3 5 3.3 8c0 6.2-5.1 11.3-11.3 11.3l-11.3 0-6 0-.6 0-21.5 0-.6 0-6 0-11.3 0c-6.2 0-11.3-5.1-11.3-11.3zM256 240c0-26.5 21.5-48 48-48l32 0c8.8 0 16 7.2 16 16c0 26.5-21.5 48-48 48l-32 0c-8.8 0-16-7.2-16-16z", "M0 224C0 100.3 100.3 0 224 0S448 100.3 448 224l0 96c0 106-86 192-192 192l-64 0C86 512 0 426 0 320l0-96zm153.6 96.3C121.2 323.5 96 350.8 96 384c0 35.3 28.7 64 64 64l128 0c35.3 0 64-28.7 64-64c0-33.2-25.2-60.5-57.6-63.7c1-3.7 1.6-7.6 1.6-11.6c0-7.3-1.8-14.4-5.3-20.7l13.3 0c44.2 0 80-35.8 80-80c0-26.5-21.5-48-48-48l-32 0c-44.2 0-80 35.8-80 80c0-44.2-35.8-80-80-80l-32 0c-26.5 0-48 21.5-48 48c0 44.2 35.8 80 80 80l13.3 0c-3.4 6.3-5.3 13.4-5.3 20.7c0 4 .6 7.9 1.6 11.6z"]]
}, faLuchador = faLuchadorMask, faMaskLuchador = faLuchadorMask, faSquareCheck = {
  prefix: "fad",
  iconName: "square-check",
  icon: [448, 512, [9745, 9989, 61510, "check-square"], "f14a", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM104 256c0-6.1 2.3-12.3 7-17c9.4-9.4 24.6-9.4 33.9 0l47 47c37-37 74-74 111-111c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c2.3 2.3 4.1 5 5.3 7.9c.6 1.5 1 2.9 1.3 4.4c.2 1.1 .3 2.2 .3 2.2c.1 1.2 .1 1.2 .1 2.5c-.1 1.5-.1 1.9-.1 2.3c-.1 .7-.2 1.5-.3 2.2c-.3 1.5-.7 3-1.3 4.4c-1.2 2.9-2.9 5.6-5.3 7.9c-42.7 42.7-85.3 85.3-128 128c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7c-21.3-21.3-42.7-42.7-64-64c-4.7-4.7-7-10.8-7-17z", "M337 175c9.4 9.4 9.4 24.6 0 33.9L209 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L303 175c9.4-9.4 24.6-9.4 33.9 0z"]]
}, faCheckSquare = faSquareCheck, faShredder = {
  prefix: "fad",
  iconName: "shredder",
  icon: [512, 512, [], "f68a", ["M40 384l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104-48 0zM64 64l0 128 384 0 0-101.5c0-17-6.7-33.3-18.7-45.3L402.7 18.7C390.7 6.7 374.5 0 357.5 0L128 0C92.7 0 64 28.7 64 64zm72 320l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104-48 0zm96 0l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104-48 0zm96 0l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104-48 0zm96 0l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104-48 0z", "M64 192c-35.3 0-64 28.7-64 64l0 96c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-96c0-35.3-28.7-64-64-64L64 192zm368 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faBookOpenCover = {
  prefix: "fad",
  iconName: "book-open-cover",
  icon: [640, 512, ["book-open-alt"], "e0c0", ["M64 33.8C64 14.3 81.3-.7 100.6 2.2L304 32l0 416L89.7 405.1c-15-3-25.7-16.1-25.7-31.4L64 33.8zM336 32L539.4 2.2C558.7-.7 576 14.3 576 33.8l0 339.9c0 15.3-10.8 28.4-25.7 31.4L336 448l0-416z", "M89.7 405.1L320 451.2l230.3-46.1c15-3 25.7-16.1 25.7-31.4l0-345 25.7-5.1C621.5 19.7 640 34.8 640 55l0 366.7c0 15.3-10.8 28.4-25.7 31.4L320 512 25.7 453.1C10.8 450.2 0 437 0 421.8L0 55C0 34.8 18.5 19.7 38.3 23.7L64 28.8l0 345c0 15.3 10.8 28.4 25.7 31.4z"]]
}, faBookOpenAlt = faBookOpenCover, faSandwich = {
  prefix: "fad",
  iconName: "sandwich",
  icon: [512, 512, [129386], "f81f", ["M0 272c0 17.7 14.3 32 32 32c22.7 0 44.3-10.3 58.8-17.2c1.3-.6 2.6-1.2 3.8-1.8c17.4-8.2 29.4-13 41.4-13c16.2 0 27.5 5 45.4 13.1c18 8.2 41.4 18.9 74.6 18.9s56.6-10.7 74.5-18.9C348.5 277 359.8 272 376 272c12 0 23.9 4.7 41.4 13c1.2 .6 2.5 1.2 3.8 1.8c14.5 6.9 36.1 17.2 58.8 17.2c17.7 0 32-14.3 32-32s-14.3-32-32-32c-7.2 0-15.8-3.7-35.4-13c-16.6-7.8-40.6-19-68.6-19c-30.6 0-53 10.2-70.1 18l-1.9 .9C286.9 234.7 274.3 240 256 240s-30.9-5.3-48.1-13.1l-1.9-.9c-17-7.8-39.4-18-70.1-18c-28 0-52.1 11.3-68.6 19c-19.6 9.2-28.2 13-35.4 13c-17.7 0-32 14.3-32 32zm212.8 64c7.4 0 14.6 2 20.9 5.7c23.4 13.6 46.8 27.3 70.2 40.9c.6 .4 1.3 .7 1.9 1s1.3 .6 1.9 .9c1.3 .5 2.6 1 4 1.4c2.7 .7 5.5 1.1 8.3 1.1c5.6 0 11.1-1.5 16.1-4.4l70.2-40.9c6.4-3.7 13.6-5.7 20.9-5.7l-214.5 0z", "M32 64C14.3 64 0 78.3 0 96l0 48c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32L32 64zM233.7 341.7c-6.4-3.7-13.6-5.7-20.9-5.7l-4.8 0L32 336c-17.7 0-32 14.3-32 32l0 48c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32l0-48c0-17.7-14.3-32-32-32l-48 0-4.8 0c-7.4 0-14.6 2-20.9 5.7l-70.2 40.9c-10 5.8-22.3 5.8-32.2 0l-70.2-40.9z"]]
}, faPesetaSign = {
  prefix: "fad",
  iconName: "peseta-sign",
  icon: [384, 512, [], "e221", ["M0 192c0 17.7 14.3 32 32 32l0-64c-17.7 0-32 14.3-32 32zm96-32l0 64 186.5 0c3.5-10 5.5-20.8 5.5-32s-1.9-22-5.5-32L96 160zm252.8 0c2.1 10.3 3.2 21 3.2 32c0 1.4 0 2.7-.1 4.1s-.1 2.7-.2 4.1c-.1 2.7-.3 5.4-.6 8.1c-.5 5.3-1.3 10.6-2.4 15.8l3.2 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-3.2 0z", "M32 64c0-17.7 14.3-32 32-32l128 0c88.4 0 160 71.6 160 160s-71.6 160-160 160l-96 0 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128L32 64zM96 288l96 0c53 0 96-43 96-96s-43-96-96-96L96 96l0 192z"]]
}, faSquareParkingSlash = {
  prefix: "fad",
  iconName: "square-parking-slash",
  icon: [640, 512, ["parking-slash"], "f617", ["M96 171.6L96 416c0 35.3 28.7 64 64 64l320 0c2.3 0 4.6-.1 6.9-.4L288 322.9l0 29.1c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64 0-15.5L96 171.6zM107.7 59.1c39.8 31.2 79.6 62.4 119.4 93.5c6-14.5 20.3-24.7 37-24.7l72 0c53 0 96 43 96 96c0 26.3-10.6 50.2-27.8 67.5c46.6 36.5 93.2 73 139.8 109.5L544 96c0-35.3-28.7-64-64-64L160 32c-21.6 0-40.7 10.7-52.3 27.1zM288 192l0 8.4c21.6 16.9 43.2 33.9 64.8 50.8c9.1-5.6 15.2-15.7 15.2-27.2c0-17.7-14.3-32-32-32l-48 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faParkingSlash = faSquareParkingSlash, faTrainTunnel = {
  prefix: "fad",
  iconName: "train-tunnel",
  icon: [512, 512, [], "e454", ["M0 256L0 448c0 35.3 28.7 64 64 64l41.4 0 64.3-64.3C137.3 444.5 112 417.2 112 384l0-192c0-35.3 28.7-64 64-64l160 0c35.3 0 64 28.7 64 64l0 192c0 1 0 2.1-.1 3.1s-.1 2-.2 3.1c-.2 2-.5 4-.9 6c-.8 3.9-1.9 7.7-3.3 11.4c-2.9 7.3-7.1 13.9-12.2 19.6c-10.4 11.4-24.8 19-41 20.6L406.6 512l41.4 0c35.3 0 64-28.7 64-64l0-192C512 114.6 397.4 0 256 0S0 114.6 0 256zM150.6 512l210.7 0-64-64-82.7 0-64 64zM160 216l0 80c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24l0-80c0-13.3-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24z", "M112 192c0-35.3 28.7-64 64-64l160 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64l-160 0c-35.3 0-64-28.7-64-64l0-192zm48 24l0 80c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24l0-80c0-13.3-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zm96 200a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faHeading = {
  prefix: "fad",
  iconName: "heading",
  icon: [448, 512, ["header"], "f1dc", ["M0 64C0 46.3 14.3 32 32 32l48 0 48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0 0 112 224 0 0-112-16 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l48 0 48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0 0 144 0 176 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-144-224 0 0 144 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-176L48 96 32 96C14.3 96 0 81.7 0 64z", ""]]
}, faHeader = faHeading, faGhost = {
  prefix: "fad",
  iconName: "ghost",
  icon: [384, 512, [128123], "f6e2", ["M0 192L0 462.2C0 472 8 480 17.8 480c4 0 7.9-1.4 11.1-3.9l11.2-9c13.4-10.7 32.8-9 44.1 3.9L114.7 506c3.3 3.8 8.2 6 13.3 6s9.9-2.2 13.3-6l26.6-30.5c12.7-14.6 35.4-14.6 48.2 0L242.7 506c3.3 3.8 8.2 6 13.3 6s9.9-2.2 13.3-6L299.8 471c11.3-12.9 30.7-14.6 44.1-3.9l11.2 9c3.2 2.5 7.1 3.9 11.1 3.9c9.8 0 17.8-8 17.8-17.8L384 192C384 86 298 0 192 0S0 86 0 192zm160 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm128 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M128 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm128 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faFaceAnguished = {
  prefix: "fad",
  iconName: "face-anguished",
  icon: [512, 512, [], "e369", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM100.3 154.9c-6-6.5-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8zM208.4 224a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM176 400c0-44.2 35.8-80 80-80s80 35.8 80 80c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16zM304 112c0-8.8 7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16zm64.4 112a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M192 128c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16zm-15.6 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM333 128.9c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8z"]]
}, faHockeySticks = {
  prefix: "fad",
  iconName: "hockey-sticks",
  icon: [640, 512, [], "f454", ["M0 384l0 96c0 17.7 14.3 32 32 32l32 0 0-160-32 0c-17.7 0-32 14.3-32 32zm96-32l0 128 0 32 32 0 32 0 44.2 0c24.2 0 46.4-13.7 57.2-35.4L476.6 46.3c7.9-15.8 1.5-35-14.3-42.9C457.7 1.1 452.8 0 448 0c-11.7 0-23 6.5-28.6 17.7L252.2 352 96 352zm448 0l0 128c0 10.7 0 21.3 0 32l32 0c0-53.3 0-106.7 0-160l-32 0z", "M220.6 17.7l81.5 163-35.8 71.6L163.4 46.3c-7.9-15.8-1.5-35 14.3-42.9s35-1.5 42.9 14.3zM337.9 395.3l35.8-71.6L387.8 352 544 352l0 128 0 32-32 0-32 0-44.2 0c-24.2 0-46.4-13.7-57.2-35.4l-40.6-81.3zM608 352c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-32 0 0-160 32 0zM96 352l0 160-32 0 0-160 32 0z"]]
}, faAbacus = {
  prefix: "fad",
  iconName: "abacus",
  icon: [576, 512, [129518], "f640", ["M0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm64 0l64 0 0 32 32 0 0-32 96 0 0 32 32 0 0-32 128 0 0 32 32 0 0-32 64 0 0 112-64 0 0-32-32 0 0 32-128 0 0-32-32 0 0 32-96 0 0-32-32 0 0 32-64 0L64 96zm0 144l64 0 0 24 32 0 0-24 96 0 0 24 32 0 0-24 128 0 0 96 32 0 0-96 64 0 0 176-64 0 0-32-32 0 0 32-128 0 0-32-32 0 0 32-96 0 0-32-32 0 0 32-64 0 0-176zm64 72l0 24 32 0 0-24-32 0zm128 0l0 24 32 0 0-24-32 0z", "M96 152c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zm128 0c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zm160 0c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zM96 288c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zm128 0c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zM96 360c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zm128 0c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zm160 0c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24z"]]
}, faFilmSimple = {
  prefix: "fad",
  iconName: "film-simple",
  icon: [512, 512, ["film-alt"], "f3a0", ["M160 32l192 0 0 448-192 0 0-448z", "M160 32l-48 0 0 48c0 8.8-7.2 16-16 16L64 96c-8.8 0-16-7.2-16-16l0-46C20.4 41.1 0 66.2 0 96L0 416c0 29.8 20.4 54.9 48 62l0-46c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48 48 0 0-448zM352 480l48 0 0-48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 46c27.6-7.1 48-32.2 48-62l0-320c0-29.8-20.4-54.9-48-62l0 46c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0 0 448zM64 160l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm336 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM64 288l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm336 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32z"]]
}, faFilmAlt = faFilmSimple, faList = {
  prefix: "fad",
  iconName: "list",
  icon: [512, 512, ["list-squares"], "f03a", ["M160 96c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-288 0c-17.7 0-32-14.3-32-32zm0 160c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-288 0c-17.7 0-32-14.3-32-32zm0 160c0-17.7 14.3-32 32-32l288 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-288 0c-17.7 0-32-14.3-32-32z", "M16 72c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48zm0 160c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48zM40 368l48 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24z"]]
}, faListSquares = faList, faTreePalm = {
  prefix: "fad",
  iconName: "tree-palm",
  icon: [576, 512, [127796], "f82b", ["M224 480c0 6.7 2.1 13.4 6.2 19c6 8.2 15.6 13 25.8 13l64 0c16.1 0 29.8-12 31.8-28c3-24 4.4-48.4 4.4-73c0-77-13.8-154.7-36.1-219c-16 0-32 0-48 0c-2.5 0-5-.6-7.1-1.7c-5.5 5.5-11 11-16.5 16.5c4 10.8 7.8 26.2 9.7 47.2c4.2 46.5-1.6 116.8-32.7 216.4c-1 3.1-1.5 6.3-1.5 9.5z", "M133.2 141.9L102.9 91.4c-3.1-5.2-10.6-5.2-13.7 0L69.5 124.1c-1.4 2.4-4 3.9-6.9 3.9L16 128c-8.8 0-16.1-7.2-14.4-15.9C10.7 64.2 59.6 0 160 0c88 0 136.5 49.4 153.2 93.8C338.4 76.2 372.3 64 416 64c100.4 0 149.3 64.2 158.4 112.1c1.7 8.7-5.6 15.9-14.4 15.9l-46.7 0c-2.8 0-5.4-1.5-6.9-3.9l-19.6-32.7c-3.1-5.2-10.6-5.2-13.7 0l-19.6 32.7c-1.4 2.4-4.1 3.9-6.9 3.9L272 192c-2.5 0-5-.6-7.1-1.7L109.8 345.5c-6.2 6.2-16.5 6.3-21.4-1C61 304.1 50.2 224.1 121.1 153.1c4-4 8-7.7 12-11.2z"]]
}, faSquarePhoneFlip = {
  prefix: "fad",
  iconName: "square-phone-flip",
  icon: [448, 512, ["phone-square-alt"], "f87b", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM96 320c0-7.9 4.7-15.3 12.3-18.5c16-6.7 32-13.3 48-20c8.2-3.4 17.6-1 23.2 5.8c6.7 8.2 13.4 16.4 20.2 24.7c35.2-16.6 63.7-45.1 80.3-80.3c-8.2-6.7-16.4-13.4-24.7-20.2c-6.8-5.6-9.2-15-5.8-23.2c6.7-16 13.3-32 20-48c3.2-7.6 10.6-12.3 18.5-12.3c1.7 0 3.5 .2 5.3 .7c14.7 4 29.3 8 44 12C346 143.1 352 151 352 160c0 123.7-100.3 224-224 224c-9 0-16.9-6-19.3-14.7l-12-44c-.5-1.8-.7-3.5-.7-5.3z", "M269.5 140.3c3.9-9.3 14-14.2 23.7-11.6l44 12C346 143.1 352 151 352 160c0 123.7-100.3 224-224 224c-9 0-16.9-6-19.3-14.7l-12-44c-2.6-9.7 2.3-19.9 11.6-23.7l48-20c8.2-3.4 17.6-1 23.2 5.8L199.7 312c35.2-16.6 63.7-45.1 80.3-80.3l-24.7-20.2c-6.8-5.6-9.2-15-5.8-23.2l20-48z"]]
}, faPhoneSquareAlt = faSquarePhoneFlip, faUserBeardBolt = {
  prefix: "fad",
  iconName: "user-beard-bolt",
  icon: [576, 512, [], "e689", ["M0 481.3c0 17 13.8 30.7 30.7 30.7l324 0c-4.2-12-3.7-25.5 2.3-37.5L386.3 416 368 416c-20.4 0-38.5-12.9-45.3-32.1c-.7-1.9-1.2-3.8-1.6-5.7c-10.3 3.8-21.5 5.9-33.1 5.9c-2.2 0-4.5-.1-6.7-.2C266.8 398.7 246.5 408 224 408s-42.8-9.3-57.3-24.2c-2.2 .2-4.4 .2-6.7 .2c-33.1 0-62.3-16.8-79.6-42.3C32.3 369.6 0 421.7 0 481.3zM64 210.8c0 24.6 14.6 46 35.7 55.7c-2.4 6.7-3.7 14-3.7 21.5c0 15.2 5.3 29.3 14.2 40.2l.4 .5C122.4 342.9 140.1 352 160 352c7.2 0 14.2-1.2 20.6-3.4c7.7 16.2 24.2 27.4 43.4 27.4s35.7-11.2 43.4-27.4c.8 .3 1.6 .5 2.4 .8c5.8 1.7 11.9 2.6 18.2 2.6c20.1 0 38-9.3 49.8-23.8c8.9-11 14.2-25 14.2-40.2c0-7.5-1.3-14.8-3.7-21.5c21.1-9.7 35.7-31 35.7-55.7c0-7.1-1.2-14.3-3.7-21l-25.2-69.3c-2-5.6-3.1-11.6-3.1-17.6C352 46.1 305.9 0 249.1 0L224 0 198.9 0C142.1 0 96 46.1 96 102.9c0 6-1 12-3.1 17.6L67.7 189.9c-2.4 6.7-3.7 13.8-3.7 21zM144 128c0-11.4 2.4-22.2 6.7-32L168 96c24.1 0 45.1-13.3 56-33c10.9 19.7 31.9 33 56 33l17.3 0c4.3 9.8 6.7 20.6 6.7 32l0 16c0 12.5-2.9 24.4-8 35c-.9-.5-1.8-1.1-2.6-1.8l-.6-.6c-18.2-18.2-43-28.5-68.8-28.5s-50.5 10.2-68.8 28.5l-.6 .6c-.8 .8-1.6 1.4-2.6 1.8c-5.1-10.6-8-22.4-8-35l0-16zm34.2 81.6c1.6-1.3 3.2-2.7 4.7-4.2l.6-.6C194.3 194 208.8 188 224 188s29.7 6 40.5 16.8l.6 .6c1.5 1.5 3.1 2.9 4.7 4.2c-2.6 1.8-5.2 3.4-8 4.9c-11.3 6.1-24.2 9.5-37.9 9.5s-26.6-3.4-37.9-9.5c-2.8-1.5-5.4-3.1-8-4.9z", "M542.3 247.2c3.4-6.7 1.6-14.9-4.2-19.6s-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7l70.1 0L385.7 488.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7l-70.1 0 52.4-104.8z"]]
}, faCartPlus = {
  prefix: "fad",
  iconName: "cart-plus",
  icon: [576, 512, [], "f217", ["M120.1 32c2 4.2 3.5 8.8 4.4 13.5c15.4 80.8 30.8 161.7 46.2 242.5l288.5 0c32.6 0 61.1-21.8 69.5-53.3l41-152.3C576.6 57 557.4 32 531.1 32l-411 0zM252 160c0-11 9-20 20-20l44 0c0-14.7 0-29.3 0-44c0-11 9-20 20-20s20 9 20 20l0 44 44 0c11 0 20 9 20 20s-9 20-20 20l-44 0 0 44c0 11-9 20-20 20s-20-9-20-20c0-14.7 0-29.3 0-44l-44 0c-11 0-20-9-20-20z", "M0 24C0 10.7 10.7 0 24 0L69.5 0c26.9 0 50 19.1 55 45.5l51.6 271c2.2 11.3 12.1 19.5 23.6 19.5L488 336c13.3 0 24 10.7 24 24s-10.7 24-24 24l-288.3 0c-34.6 0-64.3-24.6-70.7-58.5L77.4 54.5c-.7-3.8-4-6.5-7.9-6.5L24 48C10.7 48 0 37.3 0 24zM128 464a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm336-48a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM252 160c0-11 9-20 20-20l44 0 0-44c0-11 9-20 20-20s20 9 20 20l0 44 44 0c11 0 20 9 20 20s-9 20-20 20l-44 0 0 44c0 11-9 20-20 20s-20-9-20-20l0-44-44 0c-11 0-20-9-20-20z"]]
}, faGamepad = {
  prefix: "fad",
  iconName: "gamepad",
  icon: [640, 512, [], "f11b", ["M0 256C0 362 86 448 192 448l256 0c106 0 192-86 192-192s-86-192-192-192L192 64C86 64 0 150 0 256zm112 0c0-13.3 10.7-24 24-24l32 0 0-32c0-13.3 10.7-24 24-24s24 10.7 24 24l0 32 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32-32 0c-13.3 0-24-10.7-24-24zm360 48a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm64-96a40 40 0 1 1 -80 0 40 40 0 1 1 80 0z", "M192 176c-13.3 0-24 10.7-24 24l0 32-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-32c0-13.3-10.7-24-24-24z"]]
}, faBorderCenterV = {
  prefix: "fad",
  iconName: "border-center-v",
  icon: [448, 512, [], "f89d", ["M0 64a32 32 0 1 0 64 0A32 32 0 1 0 0 64zm0 96a32 32 0 1 0 64 0A32 32 0 1 0 0 160zm0 96a32 32 0 1 0 64 0A32 32 0 1 0 0 256zm0 96a32 32 0 1 0 64 0A32 32 0 1 0 0 352zm0 96a32 32 0 1 0 64 0A32 32 0 1 0 0 448zM96 64a32 32 0 1 0 64 0A32 32 0 1 0 96 64zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM288 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM384 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M224 480c-17.7 0-32-14.3-32-32l0-384c0-17.7 14.3-32 32-32s32 14.3 32 32l0 384c0 17.7-14.3 32-32 32z"]]
}, faCircleDot = {
  prefix: "fad",
  iconName: "circle-dot",
  icon: [512, 512, [128280, "dot-circle"], "f192", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm352 0a96 96 0 1 1 -192 0 96 96 0 1 1 192 0z", "M256 160a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"]]
}, faDotCircle = faCircleDot, faClipboardMedical = {
  prefix: "fad",
  iconName: "clipboard-medical",
  icon: [384, 512, [], "e133", ["M0 128L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l-49.6 0c.2 .8 .3 1.6 .4 2.3C290.1 72.6 304 90.7 304 112l0 24c0 13.3-10.7 24-24 24l-88 0-88 0c-13.3 0-24-10.7-24-24l0-24c0-21.3 13.9-39.4 33.2-45.7c.1-.8 .3-1.6 .4-2.3L64 64C28.7 64 0 92.7 0 128zM96 304c0-8.8 7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48 48 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16l0-32z", "M113.2 66.3C119.6 28.7 152.5 0 192 0s72.4 28.7 78.8 66.3C290.1 72.6 304 90.7 304 112l0 24c0 13.3-10.7 24-24 24l-88 0-88 0c-13.3 0-24-10.7-24-24l0-24c0-21.3 13.9-39.4 33.2-45.7zM216 80a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM160 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48 48 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l48 0 0-48z"]]
}, faFaceDizzy = {
  prefix: "fad",
  iconName: "face-dizzy",
  icon: [512, 512, ["dizzy"], "f567", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM96 144c0-4.1 1.6-8.2 4.7-11.3s7.2-4.7 11.3-4.7s8.2 1.6 11.3 4.7L160 169.4l36.7-36.7c3.1-3.1 7.2-4.7 11.3-4.7s8.2 1.6 11.3 4.7c6.2 6.2 6.2 16.4 0 22.6L182.6 192l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6c-3.1 3.1-7.2 4.7-11.3 4.7s-8.2-1.6-11.3-4.7L160 214.6l-36.7 36.7c-3.1 3.1-7.2 4.7-11.3 4.7s-8.2-1.6-11.3-4.7s-4.7-7.2-4.7-11.3s1.6-8.2 4.7-11.3L137.4 192l-36.7-36.7c-3.1-3.1-4.7-7.2-4.7-11.3zM320 352a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zM292.7 132.7c3.1-3.1 7.2-4.7 11.3-4.7s8.2 1.6 11.3 4.7L352 169.4l36.7-36.7c3.1-3.1 7.2-4.7 11.3-4.7s8.2 1.6 11.3 4.7s4.7 7.2 4.7 11.3s-1.6 8.2-4.7 11.3L374.6 192l36.7 36.7c3.1 3.1 4.7 7.2 4.7 11.3s-1.6 8.2-4.7 11.3s-7.2 4.7-11.3 4.7s-8.2-1.6-11.3-4.7L352 214.6l-36.7 36.7c-3.1 3.1-7.2 4.7-11.3 4.7s-8.2-1.6-11.3-4.7c-6.2-6.2-6.2-16.4 0-22.6L329.4 192l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6z", "M196.7 132.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L182.6 192l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L160 214.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L137.4 192l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L160 169.4l36.7-36.7zm96 0c6.2-6.2 16.4-6.2 22.6 0L352 169.4l36.7-36.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L374.6 192l36.7 36.7c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L352 214.6l-36.7 36.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L329.4 192l-36.7-36.7c-6.2-6.2-6.2-16.4 0-22.6z"]]
}, faDizzy = faFaceDizzy, faEgg = {
  prefix: "fad",
  iconName: "egg",
  icon: [384, 512, [129370], "f7fb", ["M0 288C0 394 86 496 192 496s192-102 192-208c0-112-64-272-192-272S0 176 0 288zm64 0c0-28.3 5.7-61.9 16.9-93.5c11.2-31.5 28.4-62.4 52.3-84.2c6.5-6 16.7-5.5 22.6 1c2.8 3.1 4.2 6.9 4.2 10.8c0 4.3-1.8 8.7-5.2 11.8c-18.8 17.1-33.6 42.7-43.7 71.2C101 233.6 96 263.5 96 288c0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M155.8 111.4c6 6.5 5.5 16.7-1 22.6c-18.8 17.1-33.6 42.7-43.7 71.2C101 233.6 96 263.5 96 288c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-28.3 5.7-61.9 16.9-93.5c11.2-31.5 28.4-62.4 52.3-84.2c6.5-6 16.7-5.5 22.6 1z"]]
}, faUpToLine = {
  prefix: "fad",
  iconName: "up-to-line",
  icon: [384, 512, ["arrow-alt-to-top"], "f34d", ["M0 64C0 46.3 14.3 32 32 32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64z", "M219.3 139.3L342.1 262.1c6.4 6.4 9.9 15 9.9 24c0 18.7-15.2 33.9-33.9 33.9L256 320l0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-128-62.1 0C47.2 320 32 304.8 32 286.1c0-9 3.6-17.6 9.9-24L164.7 139.3c7.2-7.2 17.1-11.3 27.3-11.3s20.1 4.1 27.3 11.3z"]]
}, faArrowAltToTop = faUpToLine, faHouseMedicalCircleXmark = {
  prefix: "fad",
  iconName: "house-medical-circle-xmark",
  icon: [640, 512, [], "e513", ["M0 255.5c0 18 14 32.1 32 32.1l32 0 0 160.4c0 35.3 28.7 64 64 64l266.7 0C349.5 480.1 320 427.5 320 368c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48 40.2 0c32.3-39.1 81.1-64 135.8-64c8.9 0 17.6 .7 26.1 1.9L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24zM320 352l0 16c0-5.4 .2-10.7 .7-16l-.7 0z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]]
}, faWatchFitness = {
  prefix: "fad",
  iconName: "watch-fitness",
  icon: [384, 512, [], "f63e", ["M0 144c0-38.7 27.5-71 64-78.4c5.2-1 10.5-1.6 16-1.6l224 0c5.5 0 10.8 .6 16 1.6c36.5 7.4 64 39.7 64 78.4l0 224c0 38.7-27.5 71-64 78.4c-5.2 1-10.5 1.6-16 1.6L80 448c-5.5 0-10.8-.6-16-1.6C27.5 439 0 406.7 0 368L0 144zm80 77.3c0 16.2 6.5 31.8 17.9 43.3l82.7 82.7c6.2 6.2 16.4 6.2 22.6 0l82.7-82.7c11.5-11.5 17.9-27.1 17.9-43.3c0-33.8-27.4-61.3-61.3-61.3c-16.2 0-31.8 6.5-43.3 17.9l-7.4 7.4-7.4-7.4c-11.5-11.5-27.1-17.9-43.3-17.9C107.4 160 80 187.4 80 221.3z", "M112.3 0L271.7 0C298.4 0 320 21.6 320 48.3l0 17.3c-5.2-1-10.5-1.6-16-1.6L80 64c-5.5 0-10.8 .6-16 1.6l0-17.3C64 21.6 85.6 0 112.3 0zM64 464l0-17.6c5.2 1 10.5 1.6 16 1.6l224 0c5.5 0 10.8-.6 16-1.6l0 17.6c0 26.5-21.5 48-48 48l-160 0c-26.5 0-48-21.5-48-48zM80 221.3c0-33.8 27.4-61.3 61.3-61.3c16.2 0 31.8 6.5 43.3 17.9l7.4 7.4 7.4-7.4c11.5-11.5 27.1-17.9 43.3-17.9c33.8 0 61.3 27.4 61.3 61.3c0 16.2-6.5 31.8-17.9 43.3l-82.7 82.7c-6.2 6.2-16.4 6.2-22.6 0L97.9 264.6C86.5 253.1 80 237.5 80 221.3z"]]
}, faClockNineThirty = {
  prefix: "fad",
  iconName: "clock-nine-thirty",
  icon: [512, 512, [], "e34d", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128 0c0-13.3 10.7-24 24-24l104 0c13.3 0 24 10.7 24 24l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112-80 0c-13.3 0-24-10.7-24-24z", "M256 416c13.3 0 24-10.7 24-24l0-136c0-13.3-10.7-24-24-24l-104 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l80 0 0 112c0 13.3 10.7 24 24 24z"]]
}, faCampground = {
  prefix: "fad",
  iconName: "campground",
  icon: [576, 512, [9978], "f6bb", ["M0 448l168.5 0L288 448l119.5 0L576 448l0 16c0 26.4-21.3 47.8-47.7 48l-.3 0-240 0L48 512l-.3 0C21.3 511.8 0 490.4 0 464l0-16z", "M372 7c13.8 11 16 31.2 5 45l-48 60L563.7 405.4c7.9 9.9 12.3 22.3 12.3 35l0 7.6-168.5 0L288 291.7 168.5 448 0 448l0-7.6c0-12.7 4.3-25.1 12.3-35L247 112 199 52c-11-13.8-8.8-33.9 5-45s33.9-8.8 45 5l39 48.8L327 12c11-13.8 31.2-16 45-5zM47.7 512l480.7 0-.3 0-240 0L48 512l-.3 0z"]]
}, faFolderPlus = {
  prefix: "fad",
  iconName: "folder-plus",
  icon: [512, 512, [], "f65e", ["M0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L288 96c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32L64 32C28.7 32 0 60.7 0 96zM144 288c0-13.3 10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64-64 0c-13.3 0-24-10.7-24-24z", "M232 312l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0z"]]
}, faJug = {
  prefix: "fad",
  iconName: "jug",
  icon: [448, 512, [], "f8c6", ["M32 288c128 0 256 0 384 0l0 128L32 416l0-128zM128 32c0-17.7 14.3-32 32-32L288 0c17.7 0 32 14.3 32 32c0 11.8-6.4 22.2-16 27.7c-4.7 2.7-10.2 4.3-16 4.3c-42.7 0-85.3 0-128 0c-5.8 0-11.3-1.6-16-4.3c-9.6-5.5-16-15.9-16-27.7z", "M144 59.7L144 85c0 7.1-2.4 14-6.7 19.6L59 205.3c-17.5 22.5-27 50.1-27 78.6l0 4.1 384 0 0-4.1c0-17.4-3.5-34.5-10.3-50.3C430.6 222.3 448 197.2 448 168c0-39.8-32.2-72-72-72c-21.2 0-40.3 9.2-53.5 23.8l-11.8-15.1C306.4 99 304 92.1 304 85l0-25.3c-4.7 2.7-10.2 4.3-16 4.3L160 64c-5.8 0-11.3-1.6-16-4.3zM32 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-32L32 416l0 32zM378.6 191.9l-25.1-32.2c3.4-9.1 12.2-15.6 22.5-15.6c13.3 0 24 10.7 24 24c0 12.4-9.4 22.6-21.4 23.9z"]]
}, faFutbol = {
  prefix: "fad",
  iconName: "futbol",
  icon: [512, 512, [9917, "futbol-ball", "soccer-ball"], "f1e3", ["M1 278.9c3.5 39.4 15.9 76.3 35.2 108.5c35.9-2.4 71.8-4.8 107.6-7.2c6.4-.4 12.8 1.4 18.1 5.2s9 9.3 10.5 15.6c8.8 34.9 17.6 69.7 26.5 104.6c18.3 4.2 37.4 6.4 57 6.4s38.7-2.2 57-6.4c8.8-34.9 17.6-69.7 26.5-104.6c1.6-6.3 5.3-11.8 10.5-15.6s11.6-5.6 18.1-5.2l107.6 7.2c19.3-32.2 31.8-69.1 35.2-108.5c-30.4-19.2-60.9-38.3-91.3-57.5c-5.5-3.4-9.6-8.7-11.6-14.8s-1.8-12.8 .6-18.8c13.4-33.4 26.7-66.8 40.1-100.1c-25.1-28.8-56.6-51.9-92.3-67.1c-27.6 23-55.3 46.1-82.9 69.1c-5 4.1-11.2 6.4-17.7 6.4s-12.7-2.3-17.7-6.4c-27.6-23-55.3-46.1-82.9-69.1C119.8 35.8 88.3 58.9 63.1 87.6c13.4 33.4 26.7 66.8 40.1 100.1c2.4 6 2.6 12.6 .6 18.8s-6.1 11.4-11.6 14.8C61.8 240.6 31.4 259.7 1 278.9zm165.3-37.2c-3.2-9.9 .3-20.7 8.7-26.8l66.9-48.6c8.4-6.1 19.8-6.1 28.2 0c22.3 16.2 44.6 32.4 66.9 48.6c8.4 6.1 11.9 16.9 8.7 26.8c-8.5 26.2-17 52.4-25.6 78.6c-3.2 9.9-12.4 16.6-22.8 16.6l-82.7 0c-10.4 0-19.6-6.7-22.8-16.6c-8.5-26.2-17-52.4-25.5-78.6z", "M1 278.9c-.7-7.5-1-15.2-1-22.9C0 191.5 23.8 132.6 63.1 87.6l40.1 100.1c2.4 6 2.6 12.6 .6 18.8s-6.1 11.4-11.6 14.8L1 278.9zM199 505.6C130 489.9 71.6 446.4 36.2 387.4l107.6-7.2c6.4-.4 12.8 1.4 18.1 5.2s9 9.3 10.5 15.6L199 505.6zM475.8 387.4C440.4 446.4 382 489.9 313 505.6L339.5 401c1.6-6.3 5.3-11.8 10.5-15.6s11.6-5.6 18.1-5.2l107.6 7.2zM448.9 87.6C488.2 132.6 512 191.5 512 256c0 7.7-.3 15.3-1 22.9l-91.3-57.5c-5.5-3.4-9.6-8.7-11.6-14.8s-1.8-12.8 .6-18.8L448.9 87.6zM356.6 20.5L273.7 89.6c-5 4.1-11.2 6.4-17.7 6.4s-12.7-2.3-17.7-6.4L155.4 20.5C186.3 7.3 220.3 0 256 0s69.7 7.3 100.6 20.5zM241.9 166.3c8.4-6.1 19.8-6.1 28.2 0L337 214.8c8.4 6.1 11.9 16.9 8.7 26.8l-25.5 78.6c-3.2 9.9-12.4 16.6-22.8 16.6l-82.7 0c-10.4 0-19.6-6.7-22.8-16.6l-25.6-78.6c-3.2-9.9 .3-20.7 8.7-26.8l66.9-48.6z"]]
}, faFutbolBall = faFutbol, faSoccerBall = faFutbol, faSnowBlowing = {
  prefix: "fad",
  iconName: "snow-blowing",
  icon: [640, 512, [], "f761", ["M384 208c0 17.7 14.3 32 32 32l128 0c53 0 96-43 96-96s-43-96-96-96l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32 14.3-32 32zm0 96c0 17.7 14.3 32 32 32l120 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-24 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l24 0c53 0 96-43 96-96s-43-96-96-96l-120 0c-17.7 0-32 14.3-32 32z", "M176 64c13.3 0 24 10.7 24 24l0 25.4 12.7-12.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L200 158.6l0 55.8 48.3-27.9 12.9-48.2c2.3-8.5 11.1-13.6 19.6-11.3s13.6 11.1 11.3 19.6l-4.6 17.3 22-12.7c11.5-6.6 26.2-2.7 32.8 8.8s2.7 26.2-8.8 32.8l-22 12.7 17.3 4.6c8.5 2.3 13.6 11.1 11.3 19.6s-11.1 13.6-19.6 11.3l-48.2-12.9L224 256l48.3 27.9L320.6 271c8.5-2.3 17.3 2.8 19.6 11.3s-2.8 17.3-11.3 19.6l-17.3 4.6 22 12.7c11.5 6.6 15.4 21.3 8.8 32.8s-21.3 15.4-32.8 8.8l-22-12.7 4.6 17.3c2.3 8.5-2.8 17.3-11.3 19.6s-17.3-2.8-19.6-11.3l-12.9-48.2L200 297.6l0 55.8 35.3 35.3c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L200 398.6l0 25.4c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-25.4-12.7 12.7c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L152 353.4l0-55.8-48.3 27.9L90.7 373.7c-2.3 8.5-11.1 13.6-19.6 11.3s-13.6-11.1-11.3-19.6l4.6-17.3-22 12.7C31 367.4 16.4 363.5 9.7 352s-2.7-26.2 8.8-32.8l22-12.7-17.3-4.6c-8.5-2.3-13.6-11.1-11.3-19.6s11.1-13.6 19.6-11.3l48.2 12.9L128 256 79.7 228.1 31.4 241c-8.5 2.3-17.3-2.8-19.6-11.3s2.8-17.3 11.3-19.6l17.3-4.6-22-12.7C7 186.2 3.1 171.5 9.7 160s21.3-15.4 32.8-8.8l22 12.7-4.6-17.3c-2.3-8.5 2.8-17.3 11.3-19.6s17.3 2.8 19.6 11.3l12.9 48.2L152 214.4l0-55.8-35.3-35.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L152 113.4 152 88c0-13.3 10.7-24 24-24z"]]
}, faPaintbrush = {
  prefix: "fad",
  iconName: "paintbrush",
  icon: [576, 512, [128396, "paint-brush"], "f1fc", ["M0 480c0 17.7 14.3 32 32 32l143.9 0c.1-.2 .2-.3 .3-.3c2.6 .2 5.2 .3 7.9 .3c66.3 0 120-53.7 120-120c0-2.8-.1-5.5-.2-8.3l-.6-.6L208 272c-.5 0-1.1 0-1.7 0L184 272c-66.3 0-120 53.7-120 120c0 6.2 .5 12.4 1.4 18.4C68.1 428.2 56.1 448 38 448l-6 0c-17.7 0-32 14.3-32 32z", "M411 331.6c-19.9 32.6-55.3 52.4-93.4 52.4c-4.8 0-9.6-.3-14.3-.9L208 272c.2-35.9 17.8-69.4 47.1-90.1L500.2 8.8C518.8-4.3 544.1-2.6 560.7 13s20 40.6 8.2 60.1L411 331.6z"]]
}, faPaintBrush = faPaintbrush, faLock = {
  prefix: "fad",
  iconName: "lock",
  icon: [448, 512, [128274], "f023", ["M80 144l0 48 64 0 0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48 64 0 0-48C368 64.5 303.5 0 224 0S80 64.5 80 144z", "M0 256c0-35.3 28.7-64 64-64H384c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V256z"]]
}, faArrowDownFromLine = {
  prefix: "fad",
  iconName: "arrow-down-from-line",
  icon: [384, 512, [8615, "arrow-from-top"], "f345", ["M0 64C0 46.3 14.3 32 32 32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64z", "M169.4 470.6c12.5 12.5 32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 370.7l0-66.7 0-112c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112 0 66.7L86.6 297.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128z"]]
}, faArrowFromTop = faArrowDownFromLine, faGasPump = {
  prefix: "fad",
  iconName: "gas-pump",
  icon: [512, 512, [9981], "f52f", ["M32 64l0 384 288 0 0-144 0-48 0-192c0-35.3-28.7-64-64-64L96 0C60.7 0 32 28.7 32 64zM96 80c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16l0 96c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16l0-96z", "M384 64l32 32 0 64c0 29.8 20.4 54.9 48 62l0 154c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32c0-48.6-39.4-88-88-88l-8 0 0 48 8 0c22.1 0 40 17.9 40 40l0 32c0 39.8 32.2 72 72 72s72-32.2 72-72l0-152 0-32 0-24 0-13.5c0-17-6.7-33.3-18.7-45.3L416 32c-8.8-8.8-23.2-8.8-32 0s-8.8 23.2 0 32zM0 480c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448c-17.7 0-32 14.3-32 32z"]]
}, faSignalBarsSlash = {
  prefix: "fad",
  iconName: "signal-bars-slash",
  icon: [640, 512, ["signal-alt-slash"], "f694", ["M32 432l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48zM192 304l0 160c0 26.5 21.5 48 48 48s48-21.5 48-48l0-141.1-74.7-58.8C200.5 272.7 192 287.4 192 304zM352 176l0 74.6c32 25.1 64 50.2 96 75.2L448 176c0-26.5-21.5-48-48-48s-48 21.5-48 48zm0 197.3l0 90.7c0 26.5 21.5 48 48 48s48-21.5 48-48l0-15-96-75.6zM512 48l0 328c32 25.1 64 50.2 96 75.2L608 48c0-26.5-21.5-48-48-48s-48 21.5-48 48zm47.7 464l.7 0-.3 0-.3 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faSignalAltSlash = faSignalBarsSlash, faMonkey = {
  prefix: "fad",
  iconName: "monkey",
  icon: [576, 512, [128018], "f6fb", ["M336 112c0 20.8 13.2 38.4 31.6 45.1c4.7 1.7 8.4 5.9 8.4 10.9c0 22.1 17.9 40 40 40s40-17.9 40-40c0-5 3.7-9.2 8.4-10.9c18.5-6.7 31.6-24.4 31.6-45.1c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48zm64 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M160 416c0-89.7 61.4-165 144.5-186.1C329.1 265 369.9 288 416 288c9.8 0 19.4-1 28.7-3L526.5 363c31.6 30.2 49.5 72 49.5 115.7l0 1.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-1.2c0-26.2-10.7-51.3-29.7-69.4L416 346.1 416 448l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0-256 0C71.6 512 0 440.4 0 352L0 110.1C0 49.3 49.3 0 110.1 0l10.4 0c57.2 0 102.8 47.8 100.1 104.9c-2.3 48.2-38.6 88-86.4 94.6l-1.9 .3c-17.5 2.4-33.7-9.8-36.1-27.3s9.8-33.7 27.3-36.1l1.9-.3c17.3-2.4 30.4-16.7 31.2-34.2c1-20.6-15.5-37.9-36.2-37.9l-10.4 0C84.7 64 64 84.7 64 110.1L64 352c0 53 43 96 96 96l0-32zM416 256c-29.3 0-55.9-12.2-74.8-31.7c-9-9.3-16.2-20.2-21.3-32.3c-35.3 0-64-28.7-64-64s28.6-64 64-64c15.7-37.6 52.8-64 96-64s80.4 26.4 96 64c35.3 0 64 28.7 64 64s-28.6 64-64 64c-15.7 37.6-52.8 64-96 64zM384 64c-26.5 0-48 21.5-48 48c0 20.8 13.2 38.4 31.6 45.1c4.7 1.7 8.4 5.9 8.4 10.9c0 22.1 17.9 40 40 40s40-17.9 40-40c0-5 3.7-9.2 8.4-10.9c18.5-6.7 31.6-24.4 31.6-45.1c0-26.5-21.5-48-48-48l-64 0z"]]
}, faRectanglePro = {
  prefix: "fad",
  iconName: "rectangle-pro",
  icon: [640, 512, ["pro"], "e235", ["M0 96L0 416c0 35.3 28.7 64 64 64l512 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm80 88c0-13.3 10.7-24 24-24l56 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-32 0 0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64 0-80zm48 24l0 32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0zm112-24c0-13.3 10.7-24 24-24l56 0c35.3 0 64 28.7 64 64c0 21.9-11 41.2-27.7 52.7l24.1 38.5c7 11.2 3.6 26-7.6 33.1c-4 2.5-8.4 3.7-12.7 3.7c-8 0-15.8-4-20.4-11.3l-33-52.7L288 288l0 40c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64 0-80zm48 24l0 32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0zm112 40c0-48.6 39.4-88 88-88s88 39.4 88 88l0 16c0 48.6-39.4 88-88 88s-88-39.4-88-88l0-16zm48 0l0 16c0 22.1 17.9 40 40 40s40-17.9 40-40l0-16c0-22.1-17.9-40-40-40s-40 17.9-40 40z", "M80 184l0 80 0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 32 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-56 0c-13.3 0-24 10.7-24 24zm48 56l0-32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0zm112-56l0 80 0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 18.7 0 33 52.7c7 11.2 21.8 14.7 33.1 7.6s14.7-21.8 7.6-33.1l-24.1-38.5C373 265.2 384 245.9 384 224c0-35.3-28.7-64-64-64l-56 0c-13.3 0-24 10.7-24 24zm48 56l0-32 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0zm200-80c-48.6 0-88 39.4-88 88l0 16c0 48.6 39.4 88 88 88s88-39.4 88-88l0-16c0-48.6-39.4-88-88-88zm-40 88c0-22.1 17.9-40 40-40s40 17.9 40 40l0 16c0 22.1-17.9 40-40 40s-40-17.9-40-40l0-16z"]]
}, faPro = faRectanglePro, faHouseNight = {
  prefix: "fad",
  iconName: "house-night",
  icon: [640, 512, [], "e010", ["M0 112c0 61.9 50.1 112 112 112c32.1 0 61.1-13.5 81.5-35.2c5.2-5.6-1-14-8.6-13.2c-2.9 .3-5.9 .4-9 .4c-48.6 0-88-39.4-88-88c0-29.7 14.7-55.9 37.2-71.9c6.2-4.4 5.4-14.8-2.2-15.6c-3.6-.4-7.3-.5-11-.5C50.1 0 0 50.1 0 112zM44.3 376.5c-7 2.6-7 12.4 0 15l32.3 11.9 11.9 32.3c1.3 3.5 4.4 5.2 7.5 5.2s6.2-1.7 7.5-5.2l11.9-32.3 32.3-11.9c7-2.6 7-12.4 0-15l-32.3-11.9-11.9-32.3c-2.6-7-12.4-7-15 0L76.6 364.6 44.3 376.5zm160-320c-7 2.6-7 12.4 0 15l32.3 11.9 11.9 32.3c2.6 7 12.4 7 15 0l11.9-32.3 32.3-11.9c3.5-1.3 5.2-4.4 5.2-7.5s-1.7-6.2-5.2-7.5L275.4 44.6 263.5 12.3c-2.6-7-12.4-7-15 0L236.6 44.6 204.3 56.5z", "M378.3 104.5c12.3-11.3 31.2-11.3 43.4 0l208 192c9.7 8.9 12.9 22.9 8.1 35.2S621.2 352 608 352l-32 0 0 112c0 26.5-21.5 48-48 48l-256 0c-26.5 0-48-21.5-48-48l0-112-32 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8.1-35.2l208-192zM368 288c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0z"]]
}, faHotTubPerson = {
  prefix: "fad",
  iconName: "hot-tub-person",
  icon: [512, 512, ["hot-tub"], "f593", ["M0 64a64 64 0 1 0 128 0A64 64 0 1 0 0 64zM0 256l256 0L153.6 179.2C137 166.7 116.8 160 96 160c-53 0-96 43-96 96zM224 24l0 5.2c0 34 14.4 66.4 39.7 89.2l16.4 14.8c15.2 13.7 23.8 33.1 23.8 53.5l0 13.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-13.2c0-34-14.4-66.4-39.7-89.2L295.8 82.8C280.7 69.1 272 49.7 272 29.2l0-5.2c0-13.3-10.7-24-24-24s-24 10.7-24 24zm112 0l0 5.2c0 34 14.4 66.4 39.7 89.2l16.4 14.8c15.2 13.7 23.8 33.1 23.8 53.5l0 13.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-13.2c0-34-14.4-66.4-39.7-89.2L407.8 82.8C392.7 69.1 384 49.7 384 29.2l0-5.2c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M0 256l448 0c35.3 0 64 28.7 64 64l0 128c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 256zm112 64c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16zm112 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96zm80-16c-8.8 0-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16zm112 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96z"]]
}, faHotTub = faHotTubPerson, faGlobePointer = {
  prefix: "fad",
  iconName: "globe-pointer",
  icon: [512, 512, [], "e60e", ["M0 256c0-22.1 2.8-43.5 8.1-64l123.1 0c-1.9 18.4-2.9 37.4-3.1 57L20.4 280.6c-7.1 2.1-13.1 5.5-18.1 9.9C.8 279.2 0 267.7 0 256zm18.6-96C48.6 85.9 112.2 29.1 190.6 8.4C165.1 42.6 145.3 96.1 135.3 160L18.6 160zm141.6 79.5c.4-16.3 1.5-32.2 3.1-47.5l185.3 0c2.2 20.4 3.3 41.8 3.3 64s-1.2 43.6-3.3 64l-66.8 0 12.6-42.8c10.7-36.4-23.1-70.3-59.6-59.6l-74.6 21.9zm7.5-79.5c6.1-36.4 15.5-68.6 27-94.7c10.5-23.6 22.2-40.7 33.5-51.5C239.4 3.2 248.7 0 256 0s16.6 3.2 27.8 13.8c11.3 10.8 23 27.9 33.5 51.5c11.6 26 20.9 58.2 27 94.7l-176.6 0zm61 338.6c1-2.2 1.9-4.6 2.7-7.1L272.4 352l71.9 0c-6.1 36.4-15.5 68.6-27 94.6c-10.5 23.6-22.2 40.7-33.5 51.5C272.6 508.8 263.3 512 256 512c-7.2 0-16.3-3.1-27.3-13.4zM321.4 8.4c78.3 20.7 142 77.5 171.9 151.6l-116.7 0c-10-63.9-29.8-117.4-55.3-151.6zm0 495.1c25.5-34.2 45.2-87.7 55.3-151.6l116.7 0c-30 74.1-93.6 130.9-171.9 151.6zM380.8 192l123.1 0c5.3 20.5 8.1 41.9 8.1 64s-2.8 43.5-8.1 64l-123.1 0c2.1-20.6 3.2-42 3.2-64s-1.1-43.4-3.2-64z", "M243.9 248.3L39 308.5c-13.9 4.1-15.6 23.2-2.6 29.7l57.3 28.7c1.3 .7 2.6 1.5 3.7 2.5l-88 88c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l88-88c1 1.1 1.9 2.3 2.5 3.7l28.7 57.3c6.5 13 25.6 11.3 29.7-2.6l60.2-204.8c3.6-12.1-7.7-23.4-19.9-19.9z"]]
}, faBlanket = {
  prefix: "fad",
  iconName: "blanket",
  icon: [448, 512, [], "f498", ["M0 128L0 352c0-70.7 57.3-128 128-128l240 0c44.2 0 80 35.8 80 80l0-176c0-53-43-96-96-96L96 32C43 32 0 75 0 128z", "M128 288c-35.3 0-64 28.7-64 64s28.7 64 64 64l288 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-288 0C57.3 480 0 422.7 0 352s57.3-128 128-128l240 0c44.2 0 80 35.8 80 80s-35.8 80-80 80l-240 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l240 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-240 0z"]]
}, faMapLocation = {
  prefix: "fad",
  iconName: "map-location",
  icon: [576, 512, ["map-marked"], "f59f", ["M0 209.6L0 480.4c0 17 17.1 28.6 32.9 22.3L160 451.8l0-251.4c-3.5-6.9-6.7-13.8-9.6-20.6c-5.6-13.2-10.4-27.4-12.8-41.5l-122.6 49C6 191 0 199.8 0 209.6zM192 255l0 194.4 192 54.9L384 255c-20.5 31.3-42.3 59.6-56.2 77c-20.5 25.6-59.1 25.6-79.6 0c-13.9-17.4-35.7-45.7-56.2-77zm224-54.6L416 503l144.9-58c9.1-3.6 15.1-12.5 15.1-22.3L576 152c0-17-17.1-28.6-32.9-22.3l-116 46.4c-.5 1.2-1 2.5-1.5 3.7c-2.9 6.8-6.1 13.7-9.6 20.6z", "M408 120c0 54.6-73.1 151.9-105.2 192c-7.7 9.6-22 9.6-29.6 0C241.1 271.9 168 174.6 168 120C168 53.7 221.7 0 288 0s120 53.7 120 120z"]]
}, faMapMarked = faMapLocation, faHouseFloodWater = {
  prefix: "fad",
  iconName: "house-flood-water",
  icon: [576, 512, [], "e50e", ["M0 368c0 2.4 .3 4.8 .8 7.3c4 17.2 21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 389.7 159 400 192 400c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9c.6-2.4 .8-4.9 .8-7.3c0-14.5-10-27.7-24.7-31.1c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.5-27.3-10.1-39.2-1.7C439.4 325.2 410.9 336 384 336c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 325.4 219.5 336 192 336c-26.9 0-55.3-10.8-77.4-26.1c-12-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2C10 340.3 0 353.4 0 368zM0 480c0 2.4 .3 4.8 .8 7.3c4 17.2 21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 501.7 159 512 192 512c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9c.6-2.4 .8-4.9 .8-7.3c0-14.5-10-27.7-24.7-31.1c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.4-27.3-10.1-39.2-1.7C439.4 437.2 410.9 448 384 448c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 437.4 219.5 448 192 448c-26.9 0-55.3-10.8-77.4-26.1c-12-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2C10 452.3 0 465.4 0 480z", "M306.8 6.1C295.6-2 280.4-2 269.2 6.1l-176 128c-11.2 8.2-15.9 22.6-11.6 35.8S98.1 192 112 192l16 0 0 73c1.7 1 3.3 2 4.9 3.1c18 12.4 40.1 20.3 59.2 20.3c21.1 0 42-8.5 59.2-20.3c22.1-15.5 51.6-15.5 73.7 0c18.4 12.7 39.6 20.3 59.2 20.3c19 0 41.2-7.9 59.2-20.3c1.5-1 3-2 4.5-2.9l-.3-73.2 16.6 0c13.9 0 26.1-8.9 30.4-22.1s-.4-27.6-11.6-35.8l-176-128z"]]
}, faCommentsQuestionCheck = {
  prefix: "fad",
  iconName: "comments-question-check",
  icon: [640, 512, [], "e14f", ["M0 176c0 38.6 14.7 74.3 39.6 103.4c-3.5 9.4-8.7 17.7-14.2 24.7c-4.8 6.2-9.7 11-13.3 14.3c-1.8 1.6-3.3 2.9-4.3 3.7c-.5 .4-.9 .7-1.1 .8C2.4 326.1 0 331 0 336c0 1.6 .3 3.3 .8 4.9C2.9 347.5 9.1 352 16 352c21.8 0 43.8-5.6 62.1-12.5c9.2-3.5 17.8-7.4 25.2-11.4C134.1 343.3 169.8 352 208 352c114.9 0 208-78.8 208-176S322.9 0 208 0S0 78.8 0 176zm134.7-59.9c0-2.2 .4-4.5 1.2-6.7l.4-1c6.6-18.6 24.2-31.1 44-31.1l48.5 0c29.1 0 52.6 23.6 52.6 52.6c0 18.8-10.1 36.3-26.4 45.6L228 191c-.2 10.9-9.1 19.6-20 19.6c-11 0-20-9-20-20l0-11.2c0-7.2 3.8-13.8 10-17.3L235 140.9c3.9-2.3 6.3-6.4 6.3-10.9c0-7-5.7-12.6-12.6-12.6l-48.5 0c-2.8 0-5.3 1.8-6.3 4.4l-.4 1c-3.7 10.4-15.1 15.9-25.5 12.2c-8.2-2.9-13.3-10.6-13.3-18.8zM234.7 264a26.7 26.7 0 1 1 -53.3 0 26.7 26.7 0 1 1 53.3 0z", "M136.2 108.4c6.6-18.6 24.2-31.1 44-31.1l48.5 0c29.1 0 52.6 23.6 52.6 52.6c0 18.8-10.1 36.3-26.4 45.6L228 191c-.2 10.9-9.1 19.6-20 19.6c-11 0-20-9-20-20l0-11.2c0-7.2 3.8-13.8 10-17.3L235 140.9c3.9-2.3 6.3-6.4 6.3-10.9c0-7-5.7-12.6-12.6-12.6l-48.5 0c-2.8 0-5.3 1.8-6.3 4.4l-.4 1c-3.7 10.4-15.1 15.9-25.5 12.2s-15.9-15.1-12.2-25.5l.4-1zM181.3 264a26.7 26.7 0 1 1 53.3 0 26.7 26.7 0 1 1 -53.3 0zM432 512c-95.6 0-176.2-54.6-200.5-129C348.9 372.9 448 288.3 448 176c0-5.2-.2-10.4-.6-15.5C555.1 167.1 640 243.2 640 336c0 38.6-14.7 74.3-39.6 103.4c3.5 9.4 8.7 17.7 14.2 24.7c4.8 6.2 9.7 11 13.3 14.3c1.8 1.6 3.3 2.9 4.3 3.7c.5 .4 .9 .7 1.1 .8l.2 .2s0 0 0 0s0 0 0 0c5.6 4.1 7.9 11.3 5.8 17.9c-2.1 6.6-8.3 11.1-15.2 11.1c-21.8 0-43.8-5.6-62.1-12.5c-9.2-3.5-17.8-7.4-25.3-11.4C505.9 503.3 470.2 512 432 512zM566.1 318.1c7.8-7.8 7.8-20.5 0-28.3s-20.5-7.8-28.3 0L472 355.7l-25.9-25.9c-7.8-7.8-20.5-7.8-28.3 0s-7.8 20.5 0 28.3l40 40c7.8 7.8 20.5 7.8 28.3 0l80-80z"]]
}, faTree = {
  prefix: "fad",
  iconName: "tree",
  icon: [448, 512, [127794], "f1bb", ["M0 424.5c0 13 10.5 23.5 23.5 23.5L192 448l0-224c0-.6 0-1.1 0-1.6s.1-1.1 .1-1.6c.1-1.1 .3-2.1 .5-3.2c.4-2.1 1.1-4.1 1.9-6c1.6-3.8 4-7.3 6.9-10.2c5.8-5.8 13.8-9.4 22.6-9.4c17.7 0 32 14.3 32 32c0 74.7 0 149.3 0 224l168.5 0c13 0 23.5-10.5 23.5-23.5c0-5.5-1.9-10.8-5.4-15L368 320l33.4 0c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L344 208l24.9 0c12.7 0 23.1-10.3 23.1-23.1c0-5.7-2.1-11.3-6-15.5L237.4 5.9C234 2.1 229.1 0 224 0s-10 2.1-13.4 5.9L62 169.4c-3.9 4.2-6 9.8-6 15.5C56 197.7 66.3 208 79.1 208l24.9 0L30.6 281.4c-4.2 4.2-6.6 10-6.6 16C24 309.9 34.1 320 46.6 320L80 320 5.4 409.5C1.9 413.7 0 419 0 424.5z", "M224 192c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32z"]]
}, faArrowsCross = {
  prefix: "fad",
  iconName: "arrows-cross",
  icon: [448, 512, [], "e0a2", ["M0 64c0 8.2 3.1 16.4 9.4 22.6L178.7 256c15.1-15.1 30.2-30.2 45.3-45.3L54.6 41.4C48.4 35.1 40.2 32 32 32s-16.4 3.1-22.6 9.4S0 55.8 0 64zM224 301.3L338.7 416 288 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 50.7L269.3 256 224 301.3z", "M256 64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-50.7L54.6 470.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L338.7 96 288 96c-17.7 0-32-14.3-32-32z"]]
}, faBackpack = {
  prefix: "fad",
  iconName: "backpack",
  icon: [448, 512, [127890], "f5d4", ["M96 384l0 16 0 112 256 0 0-112 0-16L96 384zM136 56l0 40 48 0 0-40c0-4.4 3.6-8 8-8l64 0c4.4 0 8 3.6 8 8l0 40 48 0 0-40c0-30.9-25.1-56-56-56L192 0c-30.9 0-56 25.1-56 56z", "M0 224C0 153.3 57.3 96 128 96l192 0c70.7 0 128 57.3 128 128l0 224c0 35.3-28.7 64-64 64l-32 0 0-112 0-64c0-26.5-21.5-48-48-48l-160 0c-26.5 0-48 21.5-48 48l0 64 0 112-32 0c-35.3 0-64-28.7-64-64L0 224zm144-48c-8.8 0-16 7.2-16 16s7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0z"]]
}, faSquareSmall = {
  prefix: "fad",
  iconName: "square-small",
  icon: [320, 512, [], "e27e", ["M0 160c0-35.3 28.7-64 64-64H256c35.3 0 64 28.7 64 64V352c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V160z", ""]]
}, faFolderArrowUp = {
  prefix: "fad",
  iconName: "folder-arrow-up",
  icon: [512, 512, ["folder-upload"], "e054", ["M0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L288 96c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32L64 32C28.7 32 0 60.7 0 96zM160 272c0-6.1 2.3-12.3 7-17l72-72c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7l72 72c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17c-9.4 9.4-24.6 9.4-33.9 0l-31-31L280 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-102.1-31 31c-9.4 9.4-24.6 9.4-33.9 0c-4.7-4.7-7-10.8-7-17z", "M256 384c13.3 0 24-10.7 24-24l0-102.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31L232 360c0 13.3 10.7 24 24 24z"]]
}, faFolderUpload = faFolderArrowUp, faBridgeLock = {
  prefix: "fad",
  iconName: "bridge-lock",
  icon: [640, 512, [], "e4cc", ["M32 64c0 17.7 14.3 32 32 32l40 0 0 64-72 0 0 128c53 0 96 43 96 96l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96c28.8 0 54.6 12.7 72.2 32.7c5.6-10 13.9-18.4 23.8-24.1l0-24.6c0-61.9 50.1-112 112-112l8 0 0-64 40 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 32C46.3 32 32 46.3 32 64zM152 96l80 0 0 64-80 0 0-64zm128 0l80 0 0 64-80 0 0-64zm128 0l80 0 0 64-80 0 0-64z", "M496 272l0 48 64 0 0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]]
}, faCrosshairsSimple = {
  prefix: "fad",
  iconName: "crosshairs-simple",
  icon: [512, 512, [], "e59f", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm64 0c0-10.9 .9-21.6 2.7-32C80.1 143.6 143.6 80.1 224 66.7c10.4-1.7 21.1-2.7 32-2.7s21.6 .9 32 2.7C368.4 80.1 431.9 143.6 445.3 224c1.7 10.4 2.7 21.1 2.7 32s-.9 21.6-2.7 32C431.9 368.4 368.4 431.9 288 445.3c-10.4 1.7-21.1 2.7-32 2.7s-21.6-.9-32-2.7C143.6 431.9 80.1 368.4 66.7 288c-1.7-10.4-2.7-21.1-2.7-32z", "M288 66.7c-10.4-1.7-21.1-2.7-32-2.7s-21.6 .9-32 2.7l0 61.3c0 17.7 14.3 32 32 32s32-14.3 32-32l0-61.3zM66.7 288l61.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-61.3 0c-1.7 10.4-2.7 21.1-2.7 32s.9 21.6 2.7 32zM224 445.3c10.4 1.7 21.1 2.7 32 2.7s21.6-.9 32-2.7l0-61.3c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 61.3zM445.3 224L384 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l61.3 0c1.7-10.4 2.7-21.1 2.7-32s-.9-21.6-2.7-32z"]]
}, faSackDollar = {
  prefix: "fad",
  iconName: "sack-dollar",
  icon: [512, 512, [128176], "f81d", ["M0 416c0 53 43 96 96 96l320 0c53 0 96-43 96-96c0-165.1-122.3-243.3-179-279.6c-4.8-3.1-9.2-5.9-13-8.4l-128 0c-3.8 2.5-8.1 5.3-13 8.4C122.3 172.7 0 250.9 0 416zM144.6 24.9L192 96l128 0 47.4-71.1C374.5 14.2 366.9 0 354.1 0L157.9 0c-12.8 0-20.4 14.2-13.3 24.9zm43.6 253.7c.1-1.3 .2-2.5 .4-3.7c.3-2.4 .9-4.8 1.5-7c1.3-4.5 3.2-8.5 5.6-12.2c4.7-7.3 11.2-13 18.2-17.1c6.9-4.1 14.5-6.8 22.2-8.5l0-14c0-11 9-20 20-20s20 9 20 20l0 13.9c7.5 1.2 14.6 2.9 21.1 4.7c10.7 2.8 17 13.8 14.2 24.5s-13.8 17-24.5 14.2c-11-2.9-21.6-5-31.2-5.2c-7.9-.1-16 1.8-21.5 5c-4.8 2.8-6.2 5.6-6.2 9.3c0 1.8 .1 3.5 5.3 6.7c6.3 3.8 15.5 6.7 28.3 10.5l.7 .2c11.2 3.4 25.6 7.7 37.1 15c12.9 8.1 24.3 21.3 24.6 41.6c0 .7 0 1.3 0 1.9s0 1.3-.1 1.9c-.1 1.3-.2 2.5-.3 3.7c-.3 2.4-.7 4.8-1.3 7c-1.2 4.5-3 8.6-5.2 12.4c-4.4 7.5-10.7 13.5-17.9 18c-7.2 4.5-15.2 7.3-23.2 9l0 13.8c0 11-9 20-20 20s-20-9-20-20l0-14.6c-10.3-2.2-20-5.5-28.3-8.4c-2.1-.7-4.1-1.4-6.1-2.1c-10.5-3.5-16.1-14.8-12.6-25.3s14.8-16.1 25.3-12.6c2.5 .8 4.9 1.7 7.2 2.4c13.6 4.6 24 8.1 35.1 8.5c8.6 .3 16.5-1.6 21.4-4.7c4.1-2.5 6-5.5 5.9-10.5c0-2.9-.8-5-5.9-8.2c-6.3-4-15.4-6.9-28-10.7l-1.7-.5c-10.9-3.3-24.6-7.4-35.6-14c-12.7-7.7-24.6-20.5-24.7-40.7c0-.7 0-1.3 0-2s.1-1.3 .1-1.9z", "M192 96c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L192 96zm84 120c0-11-9-20-20-20s-20 9-20 20l0 14c-7.6 1.7-15.2 4.4-22.2 8.5c-13.9 8.3-25.9 22.8-25.8 43.9c.1 20.3 12 33.1 24.7 40.7c11 6.6 24.7 10.8 35.6 14l1.7 .5c12.6 3.8 21.8 6.8 28 10.7c5.1 3.2 5.8 5.4 5.9 8.2c.1 5-1.8 8-5.9 10.5c-5 3.1-12.9 5-21.4 4.7c-11.1-.4-21.5-3.9-35.1-8.5c0 0 0 0 0 0c-2.3-.8-4.7-1.6-7.2-2.4c-10.5-3.5-21.8 2.2-25.3 12.6s2.2 21.8 12.6 25.3c1.9 .6 4 1.3 6.1 2.1c0 0 0 0 0 0s0 0 0 0c8.3 2.9 17.9 6.2 28.2 8.4l0 14.6c0 11 9 20 20 20s20-9 20-20l0-13.8c8-1.7 16-4.5 23.2-9c14.3-8.9 25.1-24.1 24.8-45c-.3-20.3-11.7-33.4-24.6-41.6c-11.5-7.2-25.9-11.6-37.1-15l-.7-.2c-12.8-3.9-21.9-6.7-28.3-10.5c-5.2-3.1-5.3-4.9-5.3-6.7c0-3.7 1.4-6.5 6.2-9.3c5.4-3.2 13.6-5.1 21.5-5c9.6 .1 20.2 2.2 31.2 5.2c10.7 2.8 21.6-3.5 24.5-14.2s-3.5-21.6-14.2-24.5c-6.5-1.7-13.7-3.4-21.1-4.7l0-13.9z"]]
}, faPenToSquare = {
  prefix: "fad",
  iconName: "pen-to-square",
  icon: [512, 512, ["edit"], "f044", ["M0 160c0-53 43-96 96-96l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-17.7 0-32 14.3-32 32l0 256c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 53-43 96-96 96L96 512c-53 0-96-43-96-96L0 160z", "M392.4 21.7L362.3 51.7l97.9 97.9 30.1-30.1c21.9-21.9 21.9-57.3 0-79.2L471.6 21.7c-21.9-21.9-57.3-21.9-79.2 0zM339.7 74.3L172.4 241.7c-6.1 6.1-10.8 13.6-13.5 21.9l-29.6 88.8c-2.9 8.6-.6 18.1 5.8 24.6s15.9 8.7 24.6 5.8l88.8-29.6c8.2-2.7 15.7-7.4 21.9-13.5L437.7 172.3 339.7 74.3z"]]
}, faEdit = faPenToSquare, faSquareSliders = {
  prefix: "fad",
  iconName: "square-sliders",
  icon: [448, 512, ["sliders-h-square"], "f3f0", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm64 80c0-17.7 14.3-32 32-32l32 0 0-16c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16 160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0 0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16-32 0c-17.7 0-32-14.3-32-32zm0 160c0-17.7 14.3-32 32-32l160 0 0-16c0-17.7 14.3-32 32-32s32 14.3 32 32l0 16 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 16c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-16L96 368c-17.7 0-32-14.3-32-32z", "M192 224c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96zM320 384c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96z"]]
}, faSlidersHSquare = faSquareSliders, faCarSide = {
  prefix: "fad",
  iconName: "car-side",
  icon: [640, 512, [128663], "f5e4", ["M64 432a80 80 0 1 0 160 0A80 80 0 1 0 64 432zm47.3-208L224 224c0-32 0-64 0-96l-52.7 0c-13.1 0-24.9 8-29.7 20.1c-10.1 25.3-20.2 50.6-30.4 75.9zM272 128c0 32 0 64 0 96l173.4 0-67.2-84c-6.1-7.6-15.3-12-25-12L272 128zM416 432a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M171.3 128l52.7 0 0 96-112.7 0 30.4-75.9c4.9-12.1 16.6-20.1 29.7-20.1zM272 224l0-96 81.2 0c9.7 0 18.9 4.4 25 12l67.2 84L272 224zm256.2 1l-100-125c-18.2-22.8-45.8-36-75-36L171.3 64c-39.3 0-74.6 23.9-89.1 60.3L40.6 228.4C16.8 237.8 0 260.9 0 288L0 400c0 17.7 14.3 32 32 32c0-61.9 50.1-112 112-112s112 50.1 112 112l128 0c0-61.9 50.1-112 112-112s112 50.1 112 112c17.7 0 32-14.3 32-32l0-48c0-65.2-48.8-119-111.8-127z"]]
}, faMessageMiddleTop = {
  prefix: "fad",
  iconName: "message-middle-top",
  icon: [512, 512, ["comment-middle-top-alt"], "e1e2", ["M343.5 96L448 96c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64l104.5 0L243.7 5.8c3-3.6 7.5-5.8 12.3-5.8s9.3 2.1 12.3 5.8L343.5 96z", ""]]
}, faCommentMiddleTopAlt = faMessageMiddleTop, faLightbulbOn = {
  prefix: "fad",
  iconName: "lightbulb-on",
  icon: [640, 512, [], "f672", ["M144 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4c19.8 27.1 39.7 54.4 49.2 86.2l160 0c9.6-31.9 29.5-59.1 49.2-86.2c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C496 78.8 417.2 0 320 0S144 78.8 144 176zm64 0c0-61.9 50.1-112 112-112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.2 0-80 35.8-80 80c0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M69.3 4l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3S58.3-3.3 69.3 4zM597.3 44l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zM24 160l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zm528 0l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24zM117.3 332l-48 32c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l48-32c11-7.4 25.9-4.4 33.3 6.7s4.4 25.9-6.7 33.3zm432-39.9l48 32c11 7.4 14 22.3 6.7 33.3s-22.3 14-33.3 6.7l-48-32c-11-7.4-14-22.3-6.7-33.3s22.3-14 33.3-6.7zM400 432c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-48 160 0 0 48z"]]
}, faKnife = {
  prefix: "fad",
  iconName: "knife",
  icon: [512, 512, ["utensil-knife"], "f2e4", ["M201.4 265.4l16-16C298.1 168.7 378.7 88 459.5 7.3c4.7-4.7 11-7.3 17.6-7.3c11.2 0 21 7.5 23.5 18.4C505.3 38.6 512 71.5 512 96c0 90.1-56.3 137.9-149.2 229.3c-12.1 11.9-28.4 18.7-45.3 18.7l-11 0c-17 0-33.3-6.7-45.3-18.7c-4.9-4.9-9.8-9.8-14.6-14.6c-15.1-15.1-30.2-30.2-45.3-45.3z", "M217.4 249.4l-16 16 45.3 45.3-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l208-208z"]]
}, faUtensilKnife = faKnife, faShareNodes = {
  prefix: "fad",
  iconName: "share-nodes",
  icon: [448, 512, ["share-alt"], "f1e0", ["M162.6 186.9c15.4 14.9 25.9 34.9 28.6 57.2l94.1-47c-15.4-14.9-25.9-34.9-28.6-57.2l-94.1 47zm0 138.2l94.1 47c2.8-22.4 13.2-42.4 28.6-57.2l-94.1-47c-2.8 22.4-13.2 42.4-28.6 57.2z", "M256 128a96 96 0 1 1 192 0 96 96 0 1 1 -192 0zM0 256a96 96 0 1 1 192 0A96 96 0 1 1 0 256zm352 32a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]]
}, faShareAlt = faShareNodes, faDisplayChartUpCircleDollar = {
  prefix: "fad",
  iconName: "display-chart-up-circle-dollar",
  icon: [640, 512, [], "e5e6", ["M0 64L0 352c0 35.3 28.7 64 64 64l176 0-10.7 32L160 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l234.8 0C349.5 480.1 320 427.5 320 368c0-5.4 .2-10.7 .7-16L64 352 64 64l448 0 0 128.7c22.9 2.1 44.5 8.5 64 18.5L576 64c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zM103 279c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l87-87 63 63c4.5 4.5 10.6 7 17 7s12.5-2.5 17-7l111-111 0 22.1c0 1.3 .1 2.6 .3 3.9c15-5.8 31-9.7 47.7-11.2l0-72.7c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l22.1 0L304 238.1l-63-63c-9.4-9.4-24.6-9.4-33.9 0L103 279z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zM472.1 339c0 0 0 0 0 .1c0 .4 0 1.9 4.8 4.5c5.6 3 13.5 5.2 23.9 8.2l.2 0c9.3 2.6 21.1 6 30.5 11.5c10.2 6 20 16.1 20.5 32.3c.5 18.2-9.7 30.4-21.7 36.9c-5.8 3.1-12.1 5.1-18.3 6.2l0 10.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-11.4c-8.6-1.7-16.7-4.3-23.7-6.6c0 0 0 0 0 0c-1.7-.6-3.4-1.1-5-1.6c-8.4-2.6-13.2-11.6-10.5-20s11.6-13.2 20-10.5c2 .6 3.9 1.2 5.8 1.8c11.4 3.6 20.4 6.5 29.9 6.8c6.7 .2 13.8-1.1 18.5-3.6c2.2-1.2 3.4-2.4 4-3.3c.5-.8 1.1-2.1 1-4.5c0-1.4-.2-3-4.7-5.6c-5.3-3.1-12.9-5.4-23.2-8.3l-1.8-.5c-8.9-2.5-19.8-5.6-28.6-10.3c-9.9-5.3-20.6-14.7-21.6-30.7c-1.2-18.8 10-30.9 21.8-37.2c5.7-3.1 12-5.1 18-6.3l0-9.5c0-8.8 7.2-16 16-16s16 7.2 16 16l0 9.4c6.3 .9 12.3 2.3 17.9 3.7c8.6 2.1 13.8 10.8 11.7 19.4s-10.8 13.8-19.4 11.7c-9.3-2.3-18.2-4-26.4-4.1c-6.2-.1-13.6 1.3-18.7 4c-2.4 1.3-3.6 2.5-4.2 3.4c-.4 .7-.9 1.6-.8 3.6z"]]
}, faWaveSine = {
  prefix: "fad",
  iconName: "wave-sine",
  icon: [640, 512, [8767], "f899", ["M63.4 230.3l0-.1 .2-1c.2-.9 .5-2.4 1-4.3c1-3.8 2.5-9.4 4.6-16.2C73.6 195 80.3 177 90 159.4C110.2 122.8 137.8 96 176 96c29 0 49.1 14.4 67 44.4c19 31.8 31.9 75.4 46.3 124.5c.2 .8 .5 1.6 .7 2.4c13.5 46.2 28.4 97.5 52 137c25.1 42 63 75.6 122 75.6c73.8 0 118.2-53.2 142-96.6c12.3-22.4 20.6-44.5 25.7-60.8c2.6-8.2 4.5-15.1 5.7-20c.6-2.5 1.1-4.4 1.4-5.9c.2-.7 .3-1.3 .4-1.7l.1-.5 0-.2c0 0 0 0 0-.1c0 0 0 0 0 0L608 288l31.4 6.3c3.5-17.3-7.8-34.2-25.1-37.7s-34.2 7.8-37.7 25.1c0 0 0 0 0 0l0 .1-.2 1c-.2 .9-.5 2.4-1 4.3c-1 3.8-2.5 9.4-4.6 16.2c-4.3 13.7-11.1 31.6-20.8 49.2c-20.1 36.6-47.8 63.4-86 63.4c-29 0-49.1-14.4-67-44.4c-19-31.8-31.9-75.4-46.3-124.5c-.2-.8-.5-1.6-.7-2.4c-13.5-46.2-28.4-97.5-52-137C272.9 65.6 235 32 176 32C102.2 32 57.8 85.2 34 128.6C21.7 151 13.4 173 8.2 189.3c-2.6 8.2-4.5 15.1-5.7 20c-.6 2.5-1.1 4.4-1.4 5.9c-.2 .7-.3 1.3-.4 1.7l-.1 .5 0 .2c0 0 0 0 0 .1c0 0 0 0 0 0L32 224 .6 217.7c-3.5 17.3 7.8 34.2 25.1 37.7s34.2-7.8 37.7-25.1z", ""]]
}, faHeartCircleMinus = {
  prefix: "fad",
  iconName: "heart-circle-minus",
  icon: [576, 512, [], "e4ff", ["M0 185.1l0 5.8c0 41.5 17.2 81.2 47.6 109.5L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9s20.2-3.9 27.7-10.9l2.6-2.4C267.2 438.6 256 404.6 256 368c0-97.2 78.8-176 176-176c28.3 0 55 6.7 78.7 18.5c.9-6.5 1.3-13 1.3-19.6l0-5.8c0-69.9-50.5-129.5-119.4-141c-7.8-1.3-15.7-1.9-23.5-1.9C331.5 42.2 295 57 268 84L256 96 244 84c-27-27-63.5-41.9-101.1-41.9c-7.8 0-15.7 .6-23.5 1.9C50.5 55.6 0 115.2 0 185.1z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm64-128l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16z"]]
}, faCircleW = {
  prefix: "fad",
  iconName: "circle-w",
  icon: [512, 512, [], "e12c", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm104.3-83.8c.2-1.2 .5-2.5 .9-3.6c.8-2.4 1.9-4.6 3.3-6.6c2.9-4 7.1-7.2 12.2-8.8c12.6-4 26.1 2.9 30.2 15.5c13.7 42.9 27.4 85.7 41.1 128.6c13.7-42.9 27.4-85.7 41.1-128.6c3.2-9.9 12.4-16.7 22.9-16.7s19.7 6.7 22.9 16.7c13.7 42.9 27.4 85.7 41.1 128.6c13.7-42.9 27.4-85.7 41.1-128.6c4-12.6 17.5-19.6 30.2-15.5s19.6 17.5 15.5 30.2c-21.3 66.7-42.7 133.3-64 200c-3.2 9.9-12.4 16.7-22.9 16.7s-19.7-6.7-22.9-16.7L256 254.7c-13.7 42.9-27.4 85.7-41.1 128.6c-3.2 9.9-12.4 16.7-22.9 16.7s-19.7-6.7-22.9-16.7c-21.3-66.7-42.7-133.3-64-200c-.4-1.2-.7-2.4-.9-3.7c-.1-.9-.2-1.8-.2-1.8c-.1-.9-.1-.9-.1-1.8c0-.6 0-1.3 .1-1.9s.1-1.2 .2-1.9z", "M120.7 153.1c12.6-4 26.1 2.9 30.2 15.5L192 297.3l41.1-128.6c3.2-9.9 12.4-16.7 22.9-16.7s19.7 6.7 22.9 16.7L320 297.3l41.1-128.6c4-12.6 17.5-19.6 30.2-15.5s19.6 17.5 15.5 30.2l-64 200c-3.2 9.9-12.4 16.7-22.9 16.7s-19.7-6.7-22.9-16.7L256 254.7 214.9 383.3c-3.2 9.9-12.4 16.7-22.9 16.7s-19.7-6.7-22.9-16.7l-64-200c-4-12.6 2.9-26.1 15.5-30.2z"]]
}, faCircleCalendar = {
  prefix: "fad",
  iconName: "circle-calendar",
  icon: [512, 512, ["calendar-circle"], "e102", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128-96c0-17.7 14.3-32 32-32l32 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 64 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 32 0c17.7 0 32 14.3 32 32l0 64 0 128c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-128 0-64z", "M192 112c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 64 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 32 0c17.7 0 32 14.3 32 32l0 64-256 0 0-64c0-17.7 14.3-32 32-32l32 0 0-16z"]]
}, faCalendarCircle = faCircleCalendar, faHourglassHalf = {
  prefix: "fad",
  iconName: "hourglass-half",
  icon: [384, 512, ["hourglass-2"], "f252", ["M32 64l64 0 0 11c0 19 5.6 37.4 16 53L272 128c10.3-15.6 16-34 16-53l0-11 64 0 0 11c0 42.4-16.9 83.1-46.9 113.1L237.3 256l67.9 67.9c30 30 46.9 70.7 46.9 113.1l0 11-48 0-16 0L96 448l-32 0-32 0 0-11c0-42.4 16.9-83.1 46.9-113.1L146.7 256 78.9 188.1C48.9 158.1 32 117.4 32 75l0-11zm80 320L272 384c-3.5-5.3-7.6-10.3-12.1-14.9L192 301.3l-67.9 67.9c-4.6 4.6-8.6 9.6-12.1 14.9z", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 0zm0 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448z"]]
}, faHourglass2 = faHourglassHalf, faMicroscope = {
  prefix: "fad",
  iconName: "microscope",
  icon: [512, 512, [128300], "f610", ["M96 400c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-192 0c-8.8 0-16 7.2-16 16zM160 32l96 0c0-17.7-14.3-32-32-32L192 0c-17.7 0-32 14.3-32 32z", "M128 64c0-17.7 14.3-32 32-32l96 0c17.7 0 32 14.3 32 32l0 224c0 17.7-14.3 32-32 32c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32c-17.7 0-32-14.3-32-32l0-224zM512 320c0 49.2-18.5 94-48.9 128l16.9 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32l288 0c70.7 0 128-57.3 128-128s-57.3-128-128-128l0-64c106 0 192 86 192 192z"]]
}, faSunset = {
  prefix: "fad",
  iconName: "sunset",
  icon: [576, 512, [127751], "f767", ["M32 380.6c0 3.2 1 6.4 2.8 9.1L86.1 464l74.9 0c7.9-63.1 61.7-112 127-112s119.1 48.9 127 112l74.9 0 51.3-74.3c3.1-4.5 3.7-10.2 1.6-15.2s-6.6-8.6-11.9-9.6L423 345 403.1 237.1c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L288 289.1l-90.3-62.3c-2.7-1.9-5.9-2.8-9.1-2.8c-2.1 0-4.2 .4-6.1 1.2c-5 2.1-8.6 6.6-9.6 11.9L153 345 45.1 364.9c-5.3 1-9.8 4.6-11.9 9.6c-.8 2-1.2 4-1.2 6.1zM193.3 464l189.3 0c-7.6-45.4-47.1-80-94.7-80s-87.1 34.6-94.7 80z", "M354.5 104.3L320 135.7 320 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 103.7-34.5-31.3c-13.1-11.9-33.3-10.9-45.2 2.2s-10.9 33.3 2.2 45.2l88 80c12.2 11.1 30.8 11.1 43.1 0l88-80c13.1-11.9 14-32.1 2.2-45.2s-32.1-14-45.2-2.2zM24 464c-13.3 0-24 10.7-24 24s10.7 24 24 24l528 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 464z"]]
}, faSink = {
  prefix: "fad",
  iconName: "sink",
  icon: [512, 512, [], "e06d", ["M0 320c0 17.7 14.3 32 32 32l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-80 0-48 0-64 0-64 0-64 0-48 0-80 0c-17.7 0-32 14.3-32 32zm32 64l0 32c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-32L32 384z", "M288 96c0-17.7 14.3-32 32-32s32 14.3 32 32s14.3 32 32 32s32-14.3 32-32c0-53-43-96-96-96s-96 43-96 96l0 192 64 0 0-192zM56 208c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0c4.4 0 8 3.6 8 8l0 24 48 0 0-24c0-30.9-25.1-56-56-56l-48 0zm344 56c0-4.4 3.6-8 8-8l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0c-30.9 0-56 25.1-56 56l0 24 48 0 0-24z"]]
}, faCalendarExclamation = {
  prefix: "fad",
  iconName: "calendar-exclamation",
  icon: [448, 512, [], "f334", ["M0 192l448 0 0 272c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 192zM192 432a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm8-176l0 96c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M96 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 48 0c26.5 0 48 21.5 48 48l0 80L0 192l0-80C0 85.5 21.5 64 48 64l48 0 0-32zm96 400a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm56-176l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96c0-13.3 10.7-24 24-24s24 10.7 24 24z"]]
}, faTruckContainerEmpty = {
  prefix: "fad",
  iconName: "truck-container-empty",
  icon: [640, 512, [], "e2b5", ["M32 416a64 64 0 1 0 128 0A64 64 0 1 0 32 416zm160 0a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zm288 0a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M456 144c-13.3 0-24 10.7-24 24l0 88 0 32 0 16L32 304c-17.7 0-32 14.3-32 32l0 16c0 8.8 3.6 16.8 9.4 22.6C24.8 342.3 57.8 320 96 320c33.4 0 62.8 17 80 42.9C193.2 337 222.6 320 256 320c41.8 0 77.4 26.7 90.5 64l85.5 0 21.5 0c13.2-37.3 48.7-64 90.5-64c38.2 0 71.2 22.3 86.6 54.6c5.8-5.8 9.4-13.8 9.4-22.6l0-64 0-16 0-10.3c0-9.2-3.2-18.2-9-25.3l-58.8-71.8c-10.6-13-26.5-20.5-43.3-20.5L456 144zM585 256l-105 0 0-64 48.8 0c2.4 0 4.7 1.1 6.2 2.9L585 256z"]]
}, faHandHeart = {
  prefix: "fad",
  iconName: "hand-heart",
  icon: [512, 512, [], "f4bc", ["M11 284.4c-15.2 16-14.6 41.3 1.4 56.6L124.8 448c43.1 41.1 100.4 64 160 64l19.2 0c97.2 0 176-78.8 176-176l0-208c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-208c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 208c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 272c0 1.5 0 3.1 .1 4.6L67.6 283c-16-15.2-41.3-14.6-56.6 1.4zm197 78.2c0-23.5 19.1-42.6 42.6-42.6l1.1 0c14.6 0 28.3 7.3 36.4 19.5c8.1-12.2 21.7-19.5 36.4-19.5l1.1 0c23.5 0 42.6 19.1 42.6 42.6c0 12.1-5.1 23.6-14.1 31.6l-55.2 49.7c-3 2.7-6.9 4.1-10.7 4.1s-7.7-1.4-10.7-4.1l-55.2-49.7c-9-8.1-14.1-19.6-14.1-31.6z", "M250.6 320c-23.5 0-42.6 19.1-42.6 42.6c0 12.1 5.1 23.6 14.1 31.6l55.2 49.7c6.1 5.5 15.3 5.5 21.4 0l55.2-49.7c9-8.1 14.1-19.6 14.1-31.6c0-23.5-19.1-42.6-42.6-42.6l-1.1 0c-14.6 0-28.3 7.3-36.4 19.5c-8.1-12.2-21.7-19.5-36.4-19.5l-1.1 0z"]]
}, faBagShopping = {
  prefix: "fad",
  iconName: "bag-shopping",
  icon: [448, 512, ["shopping-bag"], "f290", ["M0 208L0 416c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-208c0-26.5-21.5-48-48-48l-64 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-128 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-72-64 0c-26.5 0-48 21.5-48 48z", "M224 48c-35.3 0-64 28.7-64 64l0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120C112 50.1 162.1 0 224 0s112 50.1 112 112l0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120c0-35.3-28.7-64-64-64z"]]
}, faShoppingBag = faBagShopping, faArrowDownZA = {
  prefix: "fad",
  iconName: "arrow-down-z-a",
  icon: [576, 512, ["sort-alpha-desc", "sort-alpha-down-alt"], "f881", ["M304 448c0 11.7 6.5 23 17.7 28.6c15.8 7.9 35 1.5 42.9-14.3l7.2-14.3 88.4 0 7.2 14.3c7.9 15.8 27.1 22.2 42.9 14.3C521.5 471 528 459.7 528 448c0-4.8-1.1-9.7-3.4-14.3l-16-32-64-128C439.2 262.8 428.1 256 416 256s-23.2 6.8-28.6 17.7l-64 128-16 32c-2.3 4.6-3.4 9.5-3.4 14.3zM320 64c0 17.7 14.3 32 32 32l50.7 0-73.4 73.4c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0 73.4-73.4c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8L352 32c-17.7 0-32 14.3-32 32zm75.8 336L416 359.6 436.2 400l-40.4 0z", "M160 480c9 0 17.5-3.8 23.6-10.4l88-96c11.9-13 11.1-33.3-2-45.2s-33.3-11.1-45.2 2L192 365.7 192 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 301.7L95.6 330.4c-11.9-13-32.2-13.9-45.2-2s-13.9 32.2-2 45.2l88 96C142.5 476.2 151 480 160 480z"]]
}, faSortAlphaDesc = faArrowDownZA, faSortAlphaDownAlt = faArrowDownZA, faMitten = {
  prefix: "fad",
  iconName: "mitten",
  icon: [448, 512, [], "f7b5", ["M32 416l0 64c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L64 384c-17.7 0-32 14.3-32 32z", "M314.7 234.7L283.2 108.9C267.2 44.9 209.7 0 143.8 0l-3.4 0C62.8 0 0 62.8 0 140.3c0 13 1.8 26 5.4 38.6L64 384l288 0 79.2-85.8c10.8-11.7 16.8-27 16.8-42.9c0-34.9-28.3-63.3-63.3-63.3l-2.8 0c-19 0-37.2 8.2-49.7 22.6l-17.6 20.1z"]]
}, faReplyClock = {
  prefix: "fad",
  iconName: "reply-clock",
  icon: [640, 512, ["reply-time"], "e239", ["M0 240c0 9.1 3.9 17.7 10.6 23.8l160 144c9.4 8.5 22.9 10.6 34.4 5.4s19-16.6 19-29.2l0-64 96 0c53 0 96 43 96 96c0 30.4-12.8 47.9-22.2 56.7c-5.5 5.1-9.8 12-9.8 19.5c0 10.9 8.8 19.7 19.7 19.7c2.8 0 5.6-.6 8.1-1.9C430.5 499.9 512 449.3 512 336c0-5.6-.3-11.2-.8-16.6c-5 .4-10.1 .6-15.2 .6c-91.8 0-167.2-70.3-175.3-160L224 160l0-64c0-12.6-7.4-24.1-19-29.2s-25-3-34.4 5.4l-160 144C3.9 222.3 0 230.9 0 240z", "M496 288A144 144 0 1 0 496 0a144 144 0 1 0 0 288zM512 80l0 48 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16z"]]
}, faReplyTime = faReplyClock, faPersonRays = {
  prefix: "fad",
  iconName: "person-rays",
  icon: [512, 512, [], "e54d", ["M100.6 271.5c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9L184 256.9 184 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 16 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-223.1 28.6 47.5c9.1 15.1 28.8 20 43.9 10.9c10-6 15.5-16.6 15.5-27.5c0-5.6-1.5-11.3-4.6-16.5l-58.3-97c-17.4-28.9-48.6-46.6-82.3-46.6l-29.7 0c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97zM208 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M41 7C31.6-2.3 16.4-2.3 7 7S-2.3 31.6 7 41l80 80c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L41 7zM471 7L391 87c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0zM7 505c9.4 9.4 24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L7 471c-9.4 9.4-9.4 24.6 0 33.9zm464 0c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l80 80z"]]
}, faRight = {
  prefix: "fad",
  iconName: "right",
  icon: [448, 512, [11157, "arrow-alt-right"], "f356", ["M0 232l0 48c0 22.1 17.9 40 40 40l184 0c0-42.7 0-85.3 0-128c-61.3 0-122.7 0-184 0c-22.1 0-40 17.9-40 40z", "M224 320s0 0 0 0l0 96c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l160-160c12.5-12.5 12.5-32.8 0-45.3l-160-160c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 96s0 0 0 0l0 128z"]]
}, faArrowAltRight = faRight, faCircleF = {
  prefix: "fad",
  iconName: "circle-f",
  icon: [512, 512, [], "e10e", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM160 152c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 64 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96 0-112z", "M160 152c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 64 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96 0-112z"]]
}, faUsers = {
  prefix: "fad",
  iconName: "users",
  icon: [640, 512, [], "f0c0", ["M0 298.7C0 310.4 9.6 320 21.3 320l213.3 0c.2 0 .4 0 .7 0c-26.6-23.5-43.3-57.8-43.3-96c0-7.6 .7-15 1.9-22.3c-13.6-6.3-28.7-9.7-44.6-9.7l-42.7 0C47.8 192 0 239.8 0 298.7zM64 80a80 80 0 1 0 160 0A80 80 0 1 0 64 80zM404.7 320c.2 0 .4 0 .7 0l213.3 0c11.8 0 21.3-9.6 21.3-21.3C640 239.8 592.2 192 533.3 192l-42.7 0c-15.9 0-31 3.5-44.6 9.7c1.3 7.2 1.9 14.7 1.9 22.3c0 38.2-16.8 72.5-43.3 96zM432 80a80 80 0 1 0 160 0A80 80 0 1 0 432 80z", "M320 320a96 96 0 1 0 0-192 96 96 0 1 0 0 192zm-58.7 32C187.7 352 128 411.7 128 485.3c0 14.7 11.9 26.7 26.7 26.7l330.7 0c14.7 0 26.7-11.9 26.7-26.7C512 411.7 452.3 352 378.7 352l-117.3 0z"]]
}, faFacePleading = {
  prefix: "fad",
  iconName: "face-pleading",
  icon: [512, 512, [], "e386", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm80.3-83c.2-.9 .4-1.9 .8-2.8c.7-1.8 1.7-3.4 2.9-4.8c2.5-2.8 6-4.8 10-5.3c3.8-.5 7.7-1 11.5-1.4c25.5-3.2 46.6-21.3 53.6-45.9c.5-1.7 1-3.4 1.5-5.2c2.4-8.5 11.3-13.4 19.8-11s13.4 11.3 11 19.8l-1.5 5.2c-4.2 14.8-11.8 28-21.9 38.8c40.4 4 72 38.1 72 79.6c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-18 6-34.6 16-48c-8 0-14.9-5.9-15.9-14c-.1-.7-.1-1.4-.1-2c0-1 0-1.2 .1-1.5c0-.5 .1-.9 .2-1.4zM208.1 405.3c9.2-10.2 25.2-21.3 47.9-21.3s38.7 11.1 47.9 21.3c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2c-4.7-5.3-12.7-10.7-24.1-10.7s-19.4 5.4-24.1 10.7c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6zM272 240c0-41.4 31.4-75.4 72-79.6c-10-10.8-17.6-24.1-21.9-38.8c-.5-1.7-1-3.4-1.5-5.2c-2.4-8.5 2.5-17.4 11-19.8s17.4 2.5 19.8 11l1.5 5.2c7 24.7 28.1 42.7 53.6 45.9c3.8 .5 7.7 1 11.5 1.4c8.1 1 14 7.9 14 15.9c0 .7 0 1.3-.1 2c-1 8.1-7.9 14-15.9 14c10 13.4 16 30 16 48c0 44.2-35.8 80-80 80s-80-35.8-80-80z", "M191.4 116.4c2.4-8.5-2.5-17.4-11-19.8s-17.4 2.5-19.8 11l-1.5 5.2c-7 24.7-28.1 42.7-53.6 45.9L94 160.1c-8.8 1.1-15 9.1-13.9 17.9s9.1 15 17.9 13.9l11.5-1.4c38.2-4.8 69.8-31.9 80.4-68.9l1.5-5.2zm129.2 0l1.5 5.2c10.6 37 42.2 64.1 80.4 68.9l11.5 1.4c8.8 1.1 16.8-5.1 17.9-13.9s-5.1-16.8-13.9-17.9l-11.5-1.4c-25.5-3.2-46.6-21.3-53.6-45.9l-1.5-5.2c-2.4-8.5-11.3-13.4-19.8-11s-13.4 11.3-11 19.8zM128 232c-8.3 0-15.9-3.2-21.6-8.4c-1.6 5.2-2.4 10.7-2.4 16.4c0 30.9 25.1 56 56 56s56-25.1 56-56s-25.1-56-56-56c-1.4 0-2.8 .1-4.2 .2c2.7 4.7 4.2 10.1 4.2 15.8c0 17.7-14.3 32-32 32zm224-32c0 17.7-14.3 32-32 32c-8.3 0-15.9-3.2-21.6-8.4c-1.6 5.2-2.4 10.7-2.4 16.4c0 30.9 25.1 56 56 56s56-25.1 56-56s-25.1-56-56-56c-1.4 0-2.8 .1-4.2 .2c2.7 4.7 4.2 10.1 4.2 15.8z"]]
}, faEyeSlash = {
  prefix: "fad",
  iconName: "eye-slash",
  icon: [640, 512, [], "f070", ["M0 256c0 4.2 .8 8.4 2.5 12.3C17.3 304 48.6 356 95.4 399.4C142.5 443.2 207.2 480 288 480c56.1 0 104.4-17.8 144.5-43.2l-71.7-56.5C339.4 392.8 314.6 400 288 400c-79.5 0-144-64.5-144-144c0-14.5 2.1-28.5 6.1-41.7L63.5 146c-29.4 34.7-49.9 70.8-61.1 97.6C.8 247.6 0 251.8 0 256zM135.2 80.7L207 136.9c23.1-15.7 51-24.9 81-24.9c79.5 0 144 64.5 144 144c0 17.7-3.2 34.6-9 50.2c28 22 56.1 44 84.1 65.9c32.3-36.6 54.6-75.4 66.4-103.9c1.6-3.9 2.5-8.1 2.5-12.3s-.8-8.4-2.5-12.3c-14.9-35.7-46.2-87.7-93-131.1C433.5 68.8 368.8 32 288 32c-60 0-111.1 20.3-152.8 48.7zm56.8 179.4c.3 6.9 1.3 13.8 3.2 20.7c13.7 51.2 66.4 81.6 117.6 67.9c1.9-.5 3.9-1.1 5.7-1.7l-120-94.6c-3.7 .8-6.7 3.7-6.5 7.7zm92.7-88.4c2.1 6.4 3.3 13.2 3.3 20.3c0 2.7-.2 5.4-.5 8c31.6 24.8 63.2 49.5 94.8 74.3c2.7-13.9 2.4-28.6-1.5-43.2c-11.1-41.5-47.8-69.4-88.6-71.1c-5.8-.2-9.2 6.1-7.4 11.7z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faFlaskVial = {
  prefix: "fad",
  iconName: "flask-vial",
  icon: [640, 512, [], "e4f3", ["M0 32C0 49.7 14.3 64 32 64l0 288c0 53 43 96 96 96c11.2 0 22-1.9 32-5.5c0-18.7 5.2-37.1 15-53.1l49-79.6L224 64c17.7 0 32-14.3 32-32s-14.3-32-32-32L160 0 96 0 32 0C14.3 0 0 14.3 0 32zM96 64l64 0 0 96-64 0 0-96z", "M480 0L352 0 320 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l0 150.9L202.3 406.2c-6.7 10.9-10.3 23.5-10.3 36.4c0 38.3 31.1 69.4 69.4 69.4l309.2 0c38.3 0 69.4-31.1 69.4-69.4c0-12.8-3.6-25.4-10.3-36.4L512 214.9 512 64c17.7 0 32-14.3 32-32s-14.3-32-32-32L480 0zM384 224l0-160 64 0 0 160c0 5.9 1.6 11.7 4.7 16.8L501.5 320l-171 0 48.8-79.2c3.1-5 4.7-10.8 4.7-16.8z"]]
}, faPoliceBox = {
  prefix: "fad",
  iconName: "police-box",
  icon: [384, 512, [], "e021", ["M0 488c0 13.3 10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-8 0L32 464l-8 0c-13.3 0-24 10.7-24 24zM96 136l0 24 32 0 0-32-24 0c-4.4 0-8 3.6-8 8zm0 40l0 24c0 4.4 3.6 8 8 8l24 0 0-32-32 0zm48-48l0 32 32 0 0-24c0-4.4-3.6-8-8-8l-24 0zm0 48l0 32 24 0c4.4 0 8-3.6 8-8l0-24-32 0zM176 16l0 16 32 0 0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16zm32 120l0 24 32 0 0-32-24 0c-4.4 0-8 3.6-8 8zm0 40l0 24c0 4.4 3.6 8 8 8l24 0 0-32-32 0zm48-48l0 32 32 0 0-24c0-4.4-3.6-8-8-8l-24 0zm0 48l0 32 24 0c4.4 0 8-3.6 8-8l0-24-32 0z", "M96 32C78.3 32 64 46.3 64 64C46.3 64 32 78.3 32 96l0 368 320 0 0-368c0-17.7-14.3-32-32-32c0-17.7-14.3-32-32-32L96 32zm0 104c0-4.4 3.6-8 8-8l24 0 0 32-32 0 0-24zm0 40l32 0 0 32-24 0c-4.4 0-8-3.6-8-8l0-24zm72-48c4.4 0 8 3.6 8 8l0 24-32 0 0-32 24 0zm-24 48l32 0 0 24c0 4.4-3.6 8-8 8l-24 0 0-32zm72-48l24 0 0 32-32 0 0-24c0-4.4 3.6-8 8-8zm24 48l0 32-24 0c-4.4 0-8-3.6-8-8l0-24 32 0zm16-48l24 0c4.4 0 8 3.6 8 8l0 24-32 0 0-32zm32 48l0 24c0 4.4-3.6 8-8 8l-24 0 0-32 32 0zM96 256c0-8.8 7.2-16 16-16l48 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-48z"]]
}, faCucumber = {
  prefix: "fad",
  iconName: "cucumber",
  icon: [512, 512, [129362], "e401", ["M120 304a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm160-32a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm96-160a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M37.5 474.5c47.8 47.8 124 49.9 174.3 6.3c12.6 10.3 31.1 9.6 42.9-2.2c11.6-11.6 12.4-30 2.4-42.6L436 257c12.6 10.1 31 9.3 42.6-2.4c11.7-11.7 12.5-30.3 2.2-42.9c43.6-50.3 41.5-126.5-6.3-174.3c-50-50-131-50-181 0L172 159c-12.6-10.1-31-9.3-42.6 2.4s-12.4 30-2.4 42.6L37.5 293.5c-50 50-50 131 0 181zM400 88a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM304 248a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM120 304a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]]
}, faHeadSideBrain = {
  prefix: "fad",
  iconName: "head-side-brain",
  icon: [512, 512, [], "f808", ["M0 224.2C0 100.6 100.2 0 224 0l24 0c95.2 0 181.2 69.3 197.3 160.2c2.3 13 6.8 25.7 15.1 36l42 52.6c6.2 7.8 9.6 17.4 9.6 27.4c0 24.2-19.6 43.8-43.8 43.8L448 320l0 64c0 35.3-28.7 64-64 64l-64 0 0 32c0 17.7-14.3 32-32 32L96 512c-17.7 0-32-14.3-32-32l0-72.7c0-16.7-6.9-32.5-17.1-45.8C16.6 322.4 0 274.1 0 224.2zM64 176c0 20.9 13.4 38.7 32.1 45.3c0 .9-.1 1.8-.1 2.7c0 26.5 21.5 48 48 48c5.6 0 11-1 16-2.7l0 18.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-18.7c5 1.8 10.4 2.7 16 2.7c26.5 0 48-21.5 48-48c0-5.6-1-11-2.7-16l50.7 0c26.5 0 48-21.5 48-48s-21.5-48-48-48c-.9 0-1.8 0-2.7 .1C326.7 93.4 308.9 80 288 80c-8.6 0-16.6 2.2-23.5 6.2C255.9 72.8 241 64 224 64s-31.9 8.8-40.5 22.2c-7-3.9-15-6.2-23.5-6.2c-26.5 0-48 21.5-48 48c-26.5 0-48 21.5-48 48z", "M336 208l-50.7 0c1.8 5 2.7 10.4 2.7 16c0 26.5-21.5 48-48 48c-5.6 0-11-1-16-2.7l0 18.7c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-18.7c-5 1.8-10.4 2.7-16 2.7c-26.5 0-48-21.5-48-48c0-.9 0-1.8 .1-2.7C77.4 214.7 64 196.9 64 176c0-26.5 21.5-48 48-48c0-26.5 21.5-48 48-48c8.6 0 16.6 2.2 23.5 6.2C192.1 72.8 207 64 224 64s31.9 8.8 40.5 22.2c7-3.9 15-6.2 23.5-6.2c20.9 0 38.7 13.4 45.3 32.1c.9 0 1.8-.1 2.7-.1c26.5 0 48 21.5 48 48s-21.5 48-48 48zM159.9 178.7c0 0 0 0 .1 0l0-2.7c0 .9 0 1.8-.1 2.7z"]]
}, faHand = {
  prefix: "fad",
  iconName: "hand",
  icon: [512, 512, [129306, 9995, "hand-paper"], "f256", ["M11 284.4c-15.2 16-14.6 41.3 1.4 56.6L124.8 448c43.1 41.1 100.4 64 160 64l19.2 0c97.2 0 176-78.8 176-176l0-208c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 112c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-208c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 208c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 272c0 1.5 0 3.1 .1 4.6L67.6 283c-16-15.2-41.3-14.6-56.6 1.4zM192 336c0-8.8 7.2-16 16-16l8 0 152 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-77 0c17.9 18.7 29 44.1 29 72l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-39.8-32.2-72-72-72l-8 0c-8.8 0-16-7.2-16-16z", "M208 320c-8.8 0-16 7.2-16 16s7.2 16 16 16l8 0c39.8 0 72 32.2 72 72l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8c0-27.9-11-53.3-29-72l77 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-152 0-8 0z"]]
}, faHandPaper = faHand, faPersonBikingMountain = {
  prefix: "fad",
  iconName: "person-biking-mountain",
  icon: [640, 512, [128693, "biking-mountain"], "f84b", ["M0 376l0 16c0 12.1 8.9 22.1 20.6 23.8c2.2 7.6 5.3 14.9 9 21.8c-7 9.4-6.3 22.8 2.3 31.3l11.3 11.3c8.6 8.6 21.9 9.3 31.3 2.2c6.8 3.7 14.1 6.8 21.7 9C97.9 503.1 107.9 512 120 512l16 0c12.1 0 22.1-8.9 23.8-20.6c7.6-2.2 14.9-5.3 21.7-9c9.4 7 22.8 6.3 31.3-2.2l11.3-11.3c8.6-8.6 9.3-21.9 2.3-31.3c3.7-6.8 6.8-14.1 9-21.7c11.6-1.7 20.6-11.7 20.6-23.8l0-16c0-12.1-8.9-22.1-20.6-23.8c-2.2-7.6-5.3-14.9-9-21.7c7-9.4 6.3-22.8-2.3-31.3l-11.3-11.3c-8.6-8.6-21.9-9.3-31.3-2.3c-6.8-3.7-14.1-6.8-21.7-9C158.1 264.9 148.1 256 136 256l-16 0c-12.1 0-22.1 8.9-23.8 20.6c-7.6 2.2-14.9 5.3-21.7 9c-9.4-7.1-22.8-6.3-31.3 2.3L31.8 299.1c-8.6 8.6-9.3 21.9-2.3 31.3c-3.7 6.9-6.8 14.1-9 21.8C8.9 353.9 0 363.9 0 376zm192 8A64 64 0 1 1 64 384a64 64 0 1 1 128 0zm192-8l0 16c0 12.1 8.9 22.1 20.6 23.8c2.2 7.6 5.3 14.9 9 21.8c-7 9.4-6.3 22.8 2.2 31.3l11.3 11.3c8.5 8.6 21.9 9.3 31.3 2.2c6.8 3.7 14.1 6.8 21.7 9c1.7 11.6 11.7 20.6 23.8 20.6l16 0c12.1 0 22.1-8.9 23.8-20.6c7.6-2.2 14.9-5.3 21.8-9c9.4 7 22.8 6.3 31.3-2.2l11.3-11.3c8.6-8.6 9.3-21.9 2.2-31.3c3.7-6.8 6.8-14.1 9-21.7c11.6-1.7 20.6-11.7 20.6-23.8l0-16c0-12.1-8.9-22.1-20.6-23.8c-2.2-7.6-5.3-14.9-9-21.7c7-9.4 6.3-22.8-2.2-31.3l-11.3-11.3c-8.6-8.6-21.9-9.3-31.3-2.3c-6.9-3.7-14.1-6.8-21.8-9C542.1 264.9 532.1 256 520 256l-16 0c-12.1 0-22.1 8.9-23.8 20.6c-7.6 2.2-14.9 5.3-21.7 9c-9.4-7.1-22.8-6.3-31.3 2.3l-11.3 11.3c-8.6 8.6-9.3 21.9-2.2 31.3c-3.7 6.9-6.8 14.1-9 21.8C392.9 353.9 384 363.9 384 376zm192 8a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M448 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM427.2 160l-61.8-48.8c-17.3-13.6-41.7-13.8-59.1-.3l-83.1 64.2c-30.7 23.8-28.5 70.8 4.3 91.6L288 305.1 288 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-10.7-5.3-20.7-14.2-26.6L295 232.9l60.3-48.5L396 217c5.7 4.5 12.7 7 20 7l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-52.8 0zm-238.8 6.7L290.8 89.9c7.2-5.4 8.5-15.7 2.9-22.8L278.7 48.4c-21.6-27-60.7-32-88.4-11.2L125.2 86.1c-7.2 5.4-8.5 15.7-2.9 22.8l44 55c5.4 6.7 15.2 8 22.1 2.8z"]]
}, faBikingMountain = faPersonBikingMountain, faUtensilsSlash = {
  prefix: "fad",
  iconName: "utensils-slash",
  icon: [640, 512, [], "e464", ["M96.1 171.7c1.9 44.2 36.3 80 79.9 83.9L176 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-194.9L96.1 171.7zM116.5 66c14.5 11.4 29 22.7 43.5 34.1L160 16c0-8.2-6.1-15-14.3-15.9s-15.6 4.5-17.4 12.4L116.5 66zm66.2 51.9c41.3 32.3 82.5 64.7 123.8 97c8.6-13.6 13.6-29.7 13.6-47c0-6.4-.7-12.8-2.1-19.1L287.6 12.5c-1.8-8-9.3-13.3-17.4-12.4S256 7.8 256 16l0 134.2c0 5.4-4.4 9.8-9.8 9.8c-5.1 0-9.3-3.9-9.8-9L223.9 14.6C223.2 6.3 216.3 0 208 0s-15.2 6.3-15.9 14.6l-9.4 103.3zM384 176l0 99.7c53.3 41.8 106.7 83.6 160 125.4l0-49.1 0-112 0-208c0-17.7-14.3-32-32-32C496 0 384 32 384 176z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faPrintMagnifyingGlass = {
  prefix: "fad",
  iconName: "print-magnifying-glass",
  icon: [640, 512, ["print-search"], "f81a", ["M64 256l0 96c0 17.7 14.3 32 32 32l32 0 0 64c0 35.3 28.7 64 64 64l256 0c24.4 0 45.6-13.7 56.4-33.8l-6.3-6.3c-15.8 5.2-32.6 8-50.2 8c-36 0-69.3-11.9-96-32l-160 0 0-64 0-16 0-16 99.2 0c-2.1-10.3-3.2-21-3.2-32c0-52.3 25.1-98.8 64-128l-224 0c-35.3 0-64 28.7-64 64zM128 64l0 96 64 0 0-96 226.7 0L448 93.3l0 66.7 64 0 0-66.7c0-17-6.7-33.3-18.7-45.3L464 18.7C452 6.7 435.7 0 418.7 0L192 0c-35.3 0-64 28.7-64 64z", "M528 320.2a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM519.9 426c-20.5 14-45.3 22.1-71.9 22.1c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128c0 26.7-8.2 51.4-22.1 71.9L633 471.2c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L519.9 426z"]]
}, faPrintSearch = faPrintMagnifyingGlass, faTurnRight = {
  prefix: "fad",
  iconName: "turn-right",
  icon: [512, 512, [], "e639", ["M0 304c0-70.7 57.3-128 128-128l192 0 0 96-192 0c-17.7 0-32 14.3-32 32l0 144c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 304z", "M360.5 70.6c-7-6.6-17.2-8.4-26-4.6S320 78.4 320 88l0 272c0 9.6 5.7 18.2 14.5 22s19 2 26-4.6l144-136c4.8-4.5 7.5-10.8 7.5-17.4s-2.7-12.9-7.5-17.4l-144-136z"]]
}, faFolderBookmark = {
  prefix: "fad",
  iconName: "folder-bookmark",
  icon: [512, 512, [], "e186", ["M0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l0 240c0 6.1-3.4 11.6-8.8 14.3s-11.9 2.1-16.8-1.5L368 308l-54.4 40.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-240c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32L64 32C28.7 32 0 60.7 0 96z", "M288 96l0 240c0 6.1 3.4 11.6 8.8 14.3s11.9 2.1 16.8-1.5L368 308l54.4 40.8c4.8 3.6 11.3 4.2 16.8 1.5s8.8-8.2 8.8-14.3l0-240L288 96z"]]
}, faArrowTurnLeftDown = {
  prefix: "fad",
  iconName: "arrow-turn-left-down",
  icon: [384, 512, [], "e633", ["M160 96l0 306.7c10.7 10.7 21.3 21.3 32 32c10.7-10.7 21.3-21.3 32-32L224 96c0-17.7 14.3-32 32-32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L256 0c-53 0-96 43-96 96z", "M342.6 329.4c12.5 12.5 12.5 32.8 0 45.3l-128 128c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L192 434.7 297.4 329.4c12.5-12.5 32.8-12.5 45.3 0z"]]
}, faOm = {
  prefix: "fad",
  iconName: "om",
  icon: [512, 512, [128329], "f679", ["M256 79.3c0 .7 0 1.4 0 2.1c.2 2.2 .9 4.3 1.9 6.2l.3 .6c.3 .6 .8 1.4 1.4 2.4c1.2 2 2.9 4.8 5.1 8.2c4.4 6.7 11.1 15.5 20 24.4C302.4 141.1 330.3 160 368 160c31.2 0 56.6-10.4 73.9-20.2c8.7-5 15.6-9.9 20.4-13.8c2.4-1.9 4.3-3.6 5.7-4.9c.7-.6 1.3-1.2 1.7-1.6l.6-.5c6.1-6 9.7-14.1 9.7-23c0-17.7-14.3-32-32-32c-8.7 0-16.7 3.5-22.4 9.2c-.1 .1-.2 .2-.5 .4c-.5 .5-1.5 1.3-2.8 2.4c-2.7 2.2-6.8 5.2-12.1 8.2C399.4 90.4 384.8 96 368 96c-20.8 0-42.4-7-59.5-14.6c-8.4-3.7-15.4-7.5-20.3-10.3c-2.4-1.4-4.3-2.5-5.6-3.3c-.6-.4-1.1-.7-1.4-.9c-2.5-1.7-5.2-2.7-8-2.9c-.6 0-1.3-.1-1.9 0c-3.9 .2-7.4 1.7-10.1 4.2c-.9 .8-1.6 1.7-2.3 2.6c-1.7 2.4-2.7 5.3-2.9 8.5zm84.7-58.6c-6.2 6.2-6.2 16.4 0 22.6l16 16c6.2 6.2 16.4 6.2 22.6 0l16-16c6.2-6.2 6.2-16.4 0-22.6l-16-16C376.2 1.6 372.1 0 368 0s-8.2 1.6-11.3 4.7l-16 16z", "M115.2 169.6c8-6 17.9-9.6 28.8-9.6c26.5 0 48 21.5 48 48s-21.5 48-48 48l-34.2 0c-7.6 0-13.8 6.2-13.8 13.8c0 1.5 .2 2.9 .7 4.4l8 24c4.4 13.1 16.6 21.9 30.4 21.9l8.9 0 16 0s0 0 0 0c35.3 0 64 28.7 64 64s-28.7 64-64 64c-50.8 0-82.7-21.5-102.2-42.8c-9.9-10.8-16.6-21.6-20.9-29.7c-2.1-4-3.6-7.3-4.5-9.6c-.5-1.1-.8-2-1-2.5l-.2-.5c-.3-.9-.7-1.8-1.1-2.6c-1.2-2.2-2.8-4-4.7-5.4c-1.9-1.4-4.1-2.3-6.5-2.8c-1.4-.3-2.9-.3-4.4-.2c-2.5 .2-4.8 1-6.8 2.3c-1.1 .7-2.2 1.5-3.1 2.5c-2.4 2.5-4.1 5.8-4.5 9.5c-.1 .6-.1 1.1-.1 1.7c0 0 0 0 0 0c0 .8 .1 1.7 .2 2.5l0 .1c0 .3 .1 .8 .2 1.3c.2 1.1 .4 2.7 .8 4.6c.8 3.9 2 9.4 3.9 15.9c3.8 13 10.3 30.4 21.3 48C48.7 476.2 89.4 512 160 512c70.7 0 128-57.3 128-128c0-23.3-6.2-45.2-17.1-64l22.6 0c25.5 0 49.9-10.1 67.9-28.1l26.5-26.5c6-6 14.1-9.4 22.6-9.4l5.5 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32c-25.7 0-41.4-12.5-51.2-25.6c-5-6.7-8.4-13.4-10.5-18.6c-1.1-2.5-1.8-4.6-2.2-6c-.2-.7-.4-1.2-.5-1.5l-.1-.2c-.3-1.3-.8-2.6-1.5-3.8c-1.1-2-2.6-3.8-4.4-5.1c-2.7-2-6-3.2-9.6-3.2l-.2 0c-8 .1-14.6 6.1-15.6 13.9c0 0 0 0 0 0l-.1 .5-.1 .6c-.1 .9-.3 2.1-.4 3.6c-.3 3-.6 7.3-.6 12.4c0 10.1 1.1 23.9 5.8 38.1c4.8 14.3 13.4 29.3 28.6 40.7C368.7 473.3 389.3 480 416 480c53 0 96-43 96-96l0-96c0-53-43-96-96-96l-5.5 0c-25.5 0-49.9 10.1-67.9 28.1l-26.5 26.5c-6 6-14.1 9.4-22.6 9.4l-48.3 0c6.9-14.5 10.8-30.8 10.8-48c0-61.9-50.1-112-112-112c-25.2 0-48.5 8.3-67.2 22.4c-14.1 10.6-17 30.7-6.4 44.8s30.7 17 44.8 6.4z"]]
}, faPi = {
  prefix: "fad",
  iconName: "pi",
  icon: [448, 512, [], "f67e", ["M32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l64 0 0 156c0 39.7-9.3 78.9-27 114.5l-1.6 3.2c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3l1.6-3.2C148.4 382.7 160 333.7 160 284l0-156 128 0 0 238.6c0 45 36.5 81.4 81.4 81.4c30.8 0 59-17.4 72.8-45l2.3-4.7c7.9-15.8 1.5-35-14.3-42.9s-35-1.5-42.9 14.3l-2.3 4.7c-3 5.9-9 9.6-15.6 9.6c-9.6 0-17.4-7.8-17.4-17.4L352 128l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 64z", ""]]
}, faFlaskRoundPotion = {
  prefix: "fad",
  iconName: "flask-round-potion",
  icon: [448, 512, ["flask-potion"], "f6e1", ["M16 352c0 56 22.1 106.9 58.2 144.3C84.5 507 99.3 512 114.2 512l219.6 0c15 0 29.7-5 40.1-15.7C409.9 458.9 432 408 432 352c0-76.8-41.6-143.8-103.5-179.9c-5.2-3-8.5-8.4-8.5-14.4L320 64c17.7 0 32-14.3 32-32s-14.3-32-32-32L304 0 144 0 128 0C110.3 0 96 14.3 96 32s14.3 32 32 32l0 93.7c0 6-3.3 11.4-8.5 14.4C57.6 208.2 16 275.2 16 352zm64 0c0-7.2 .5-14.3 1.5-21.2c6.5-44.1 33-81.7 70.2-103.4c23.4-13.6 40.3-39.3 40.3-69.7L192 64l64 0 0 93.7c0 30.4 16.9 56.1 40.3 69.7c43 25 71.6 71.4 71.7 124.7c0 .8 0 1.7 0 2.9c0 .1 0 .5 0 1c0 .4 0 .9-.1 1.6c-.5 14.1-3.1 27.7-7.4 40.5c-.7 2-1.4 4.1-2.2 6.1c-6.3 16.2-15.5 31-26.9 43.7l-214.7 0C93.8 422.5 80 388.9 80 352z", "M368 351.8c-58.6-1.7-85.4-12.6-109.9-22.6c-22-9-42.2-17.2-82.1-17.2c-42.3 0-73.4 9.2-94.5 18.8c-1 6.9-1.5 14-1.5 21.2c0 36.9 13.8 70.5 36.7 96l214.7 0c22.9-25.5 36.7-59.1 36.7-96l0-.2z"]]
}, faFlaskPotion = faFlaskRoundPotion, faFaceShush = {
  prefix: "fad",
  iconName: "face-shush",
  icon: [512, 512, [], "e38c", ["M0 256C0 114.6 114.6 0 256 0S512 114.6 512 256c0 82.2-38.8 155.4-99 202.3c7.4-21.4 1.3-46-17.1-61.3c-13.5-11.3-30.8-15.1-46.9-11.9c-5.7-21.2-19.1-39.2-37-50.9l0-58.3c14.8-6.9 26.6-15.9 35.3-24.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0c-3.7 3.7-8.1 7.4-13.3 10.9c-4-27-27.3-47.6-55.4-47.6s-51.3 20.7-55.4 47.6c-5.2-3.5-9.6-7.3-13.3-10.9c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6c8.7 8.7 20.5 17.7 35.3 24.6l0 50.1c-32.8 12.8-56 44.7-56 82l0 24 0 24c0 11.8 2.3 23.1 6.5 33.3C61.8 449.1 0 359.8 0 256zM144.4 128a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm160 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M256 224c13.3 0 24 10.7 24 24l0 72-48 0 0-72c0-13.3 10.7-24 24-24zM232 400c-4.4 0-8 3.6-8 8l0 11.5L287.6 464l10 0c7.1 0 13.9-3.2 18.4-8.6l25.6-30.7c8.5-10.2 23.6-11.6 33.8-3.1s11.6 23.6 3.1 33.8l-25.6 30.7c-13.7 16.4-33.9 25.9-55.3 25.9L280 512l-48 0c-30.9 0-56-25.1-56-56l0-24 0-24c0-30.9 25.1-56 56-56l32 0c30.9 0 56 25.1 56 56l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8c0-4.4-3.6-8-8-8l-32 0z"]]
}, faWorm = {
  prefix: "fad",
  iconName: "worm",
  icon: [512, 512, [], "e599", ["M0 312L0 464c0 26.5 21.5 48 48 48s48-21.5 48-48l0-152c0-30.9 25.1-56 56-56s56 25.1 56 56l0 48c0 83.9 68.1 152 152 152s152-68.1 152-152l0-168 0-16 0-86.4C512 40.1 471.9 0 422.4 0L384 0c-53 0-96 43-96 96s43 96 96 96l32 0 0 168c0 30.9-25.1 56-56 56s-56-25.1-56-56l0-48c0-83.9-68.1-152-152-152S0 228.1 0 312zM432 88a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M384 88a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]]
}, faHouseCircleXmark = {
  prefix: "fad",
  iconName: "house-circle-xmark",
  icon: [640, 512, [], "e50b", ["M0 255.5c0 18 14 32.1 32 32.1l32 0 0 69.7c-.1 .9-.1 1.8-.1 2.8l0 112c0 22.1 17.9 40 40 40l16 0c1.2 0 2.4-.1 3.6-.2c1.5 .1 3 .2 4.5 .2l31.9 0 24 0c22.1 0 40-17.9 40-40l0-24 0-64c0-17.7 14.3-32 32-32l64 0 .7 0c8.1-89.7 83.5-160 175.3-160c8.9 0 17.6 .7 26.1 1.9L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]]
}, faPlug = {
  prefix: "fad",
  iconName: "plug",
  icon: [384, 512, [128268], "f1e6", ["M64 32l0 128 64 0 0-128c0-17.7-14.3-32-32-32S64 14.3 64 32zm192 0l0 128 64 0 0-128c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M0 192c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l0 32c0 77.4-55 142-128 156.8l0 67.2c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-67.2C87 398 32 333.4 32 256l0-32c-17.7 0-32-14.3-32-32z"]]
}, faCalendarCircleExclamation = {
  prefix: "fad",
  iconName: "calendar-circle-exclamation",
  icon: [576, 512, [], "e46e", ["M0 112l0 48 448 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32S96 14.3 96 32l0 32L48 64C21.5 64 0 85.5 0 112zm0 80L0 464c0 26.5 21.5 48 48 48l282.8 0C285.6 480.1 256 427.5 256 368c0-91.8 70.3-167.2 160-175.3l0-.7L0 192z", "M288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80z"]]
}, faSquareI = {
  prefix: "fad",
  iconName: "square-i",
  icon: [448, 512, [], "e272", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm128 56c0-13.3 10.7-24 24-24l72 0 72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 160 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-160-48 0c-13.3 0-24-10.7-24-24z", "M128 152c0-13.3 10.7-24 24-24l72 0 72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 160 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-160-48 0c-13.3 0-24-10.7-24-24z"]]
}, faChevronUp = {
  prefix: "fad",
  iconName: "chevron-up",
  icon: [512, 512, [], "f077", ["M233.4 105.4c12.5-12.5 32.8-12.5 45.3 0l192 192c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 173.3 86.6 342.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192z", ""]]
}, faFaceSaluting = {
  prefix: "fad",
  iconName: "face-saluting",
  icon: [640, 512, [129761], "e484", ["M101.7 310C126.5 425.5 229.1 512 352 512c141.4 0 256-114.6 256-256S493.4 0 352 0c-18.4 0-36.3 1.9-53.5 5.6c12.6 27.9 3.8 61.6-22.4 79.4l-54.6 37c8.6 4.4 16.3 10.9 22.3 19.2c8.6 11.9 12.6 25.7 12.2 39.3c4.8-2.8 10.4-4.5 16.3-4.5c17.7 0 32 14.3 32 32s-14.3 32-32 32c-13.9 0-25.8-8.9-30.2-21.4c-3.5 4.4-7.7 8.5-12.5 12l-82.3 59.9c-13.9 10.1-29.5 16.6-45.6 19.6zM235 344.6c5.2-7.2 15.2-8.8 22.3-3.6c17.5 12.6 48.9 27 94.6 27s77.2-14.4 94.6-27c7.2-5.2 17.2-3.5 22.3 3.6s3.5 17.2-3.6 22.3c-22.7 16.4-60.7 33-113.4 33s-90.6-16.6-113.4-33c-7.2-5.2-8.8-15.2-3.6-22.3zM464.4 208a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M258.1 58.5c14.6-9.9 18.4-29.8 8.5-44.4S236.8-4.4 222.2 5.5L35.1 132.5c-44.3 30.1-47.1 94.4-5.6 128.2l1.5 1.2c28.1 22.9 68.2 24 97.5 2.7l82.3-59.9c14.3-10.4 17.5-30.4 7.1-44.7s-30.4-17.5-44.7-7.1L128 185.8l0-39.1L258.1 58.5z"]]
}, faGaugeSimpleLow = {
  prefix: "fad",
  iconName: "gauge-simple-low",
  icon: [512, 512, ["tachometer-slow"], "f62c", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM128 152c0-8.7 4.7-17 12.9-21.3c11.8-6.1 26.3-1.5 32.4 10.2c25.5 49.1 51.1 98.2 76.6 147.4c2-.2 4-.3 6.1-.3c35.3 0 64 28.7 64 64s-28.7 64-64 64s-64-28.7-64-64c0-15.9 5.8-30.4 15.3-41.6L130.7 163.1c-1.8-3.5-2.7-7.3-2.7-11.1z", "M173.3 140.9c-6.1-11.8-20.6-16.3-32.4-10.2s-16.3 20.6-10.2 32.4l76.6 147.4C197.8 321.6 192 336.1 192 352c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64c-2.1 0-4.1 .1-6.1 .3L173.3 140.9z"]]
}, faTachometerSlow = faGaugeSimpleLow, faFacePersevering = {
  prefix: "fad",
  iconName: "face-persevering",
  icon: [512, 512, [], "e385", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm96-96c0-7.7 5.5-14.5 13.4-15.8l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-2.5 2.5-4.9 4.9-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2c-.1-.9-.2-1.8-.2-2.6zm20 61.2c0-9 9.6-14.7 17.5-10.5c30 16 59.9 32 89.9 47.9c10.7 5.7 10.7 21.1 0 26.8c-30 16-59.9 32-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2c-12-14.4-24-28.8-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm56.1 168.2C188.2 371.4 216.3 352 256 352s67.8 19.4 83.9 37.3c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6zM288.6 258.6l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5c-30-16-59.9-32-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8zm12-157.9c6.2-6.2 16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2c-.8-.1-1.7-.3-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7c-2.5-2.5-4.9-4.9-7.4-7.4c-6.2-6.2-6.2-16.4 0-22.6z", "M211.3 123.3c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-7.4 7.4c-18.9 18.9-43.2 31.4-69.5 35.7l-2.5 .4c-8.7 1.5-14.6 9.7-13.2 18.4s9.7 14.6 18.4 13.2l2.5-.4c32.9-5.5 63.3-21.1 86.8-44.7l7.4-7.4zm89.4 0l7.4 7.4c23.6 23.6 53.9 39.2 86.8 44.7l2.5 .4c8.7 1.5 17-4.4 18.4-13.2s-4.4-17-13.2-18.4l-2.5-.4c-26.3-4.4-50.6-16.9-69.5-35.7l-7.4-7.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6zM133.5 210.7c-7.9-4.2-17.5 1.5-17.5 10.5c0 2.8 1 5.5 2.8 7.6l36 43.2-36 43.2c-1.8 2.1-2.8 4.8-2.8 7.6c0 9 9.6 14.7 17.5 10.5l89.9-47.9c10.7-5.7 10.7-21.1 0-26.8l-89.9-47.9zM396 221.1c0-9-9.6-14.7-17.5-10.5l-89.9 47.9c-10.7 5.7-10.7 21.1 0 26.8l89.9 47.9c7.9 4.2 17.5-1.5 17.5-10.5c0-2.8-1-5.5-2.8-7.6l-36-43.2 36-43.2c1.8-2.1 2.8-4.8 2.8-7.6z"]]
}, faCircleCamera = {
  prefix: "fad",
  iconName: "circle-camera",
  icon: [512, 512, ["camera-circle"], "e103", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128-64c0-17.7 14.3-32 32-32l36 0 6.2-16.4c3.5-9.4 12.5-15.6 22.5-15.6l62.7 0c10 0 19 6.2 22.5 15.6L316 160l36 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-128z", "M202.2 143.6L196 160l-36 0c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l-36 0-6.2-16.4c-3.5-9.4-12.5-15.6-22.5-15.6l-62.7 0c-10 0-19 6.2-22.5 15.6zM256 208a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]]
}, faCameraCircle = faCircleCamera, faHandSpock = {
  prefix: "fad",
  iconName: "hand-spock",
  icon: [576, 512, [128406], "f259", ["M32 312c0 10.6 4.2 21.1 12.4 29L156.8 448c43.1 41.1 100.4 64 160 64l10.9 0 8.2 0c.1-.2 .2-.2 .2-.3c58.3-3.5 108.6-43.2 125.3-99.7l81.2-275c5-16.9-4.7-34.7-21.6-39.8s-34.7 4.7-39.8 21.6L443.5 247.1c-1.6 5.3-6.4 8.9-12 8.9c-7.9 0-13.8-7.3-12.2-15.1l36-170.3c3.7-17.3-7.4-34.3-24.7-37.9s-34.3 7.4-37.9 24.7L355.1 235.1c-2.6 12.2-13.3 20.9-25.8 20.9c-11.9 0-22.4-8-25.4-19.5l-57-212.8C242.3 6.6 224.8-3.5 207.7 1.1s-27.2 22.1-22.6 39.2L238 237.8c2.5 9.2-4.5 18.2-14 18.2c-6.4 0-12-4.2-13.9-10.3L166.6 102.7c-5.1-16.9-23-26.4-39.9-21.3s-26.4 23-21.3 39.9l62.8 206.4c2.4 7.9-7.2 13.8-13.2 8.1L99.6 283c-16-15.2-41.3-14.6-56.6 1.4c-7.4 7.7-11 17.7-11 27.6zm192 24c0-8.8 7.2-16 16-16l8 0 152 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-77 0c17.9 18.7 29 44.1 29 72l0 8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-8c0-39.8-32.2-72-72-72l-8 0c-8.8 0-16-7.2-16-16z", "M240 320c-8.8 0-16 7.2-16 16s7.2 16 16 16l8 0c39.8 0 72 32.2 72 72l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8c0-27.9-11-53.3-29-72l77 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-152 0-8 0z"]]
}, faSpiderWeb = {
  prefix: "fad",
  iconName: "spider-web",
  icon: [576, 512, [128376], "f719", ["M68.4 256l23.3 28 44.6 0c21.9 26.6 38.9 56.9 50.4 89.4l.7 2-22.2 38.9c4.2 11.3 8.5 22.5 12.7 33.8c12.1-2.3 24.3-4.5 36.4-6.8L235.1 405l.8-.2c34.4-6.1 69.7-6.1 104.1 0l.8 .2 20.8 36.4 36.4 6.8 12.7-33.8-22.2-38.9 .7-2c11.5-32.5 28.5-62.8 50.4-89.4l44.6 0c7.8-9.3 15.6-18.7 23.3-28c-7.8-9.3-15.6-18.7-23.3-28l-44.6 0c-21.9-26.6-38.9-56.9-50.4-89.4l-.7-2 22.2-38.9c-4.2-11.3-8.5-22.5-12.7-33.8c-12.1 2.3-24.3 4.5-36.4 6.8L340.9 107l-.8 .1c-34.4 6.1-69.7 6.1-104.1 0l-.8-.1L214.4 70.7c-12.1-2.3-24.3-4.5-36.4-6.8c-4.2 11.3-8.5 22.5-12.7 33.8l22.2 38.9-.7 2c-11.5 32.5-28.5 62.8-50.4 89.4l-44.6 0L68.4 256zm127.4-28c8.1-12.4 15.4-25.3 21.8-38.7L239.8 228l-43.9 0zm0 56l43.9 0-22.1 38.7c-6.4-13.4-13.7-26.3-21.8-38.7zm69-125c15.4 1 30.9 1 46.3 0L288 199.6 264.8 159zm0 194L288 312.4 311.2 353c-15.4-1-30.9-1-46.3 0zm71.4-125l22.1-38.7c6.4 13.4 13.7 26.3 21.8 38.7l-43.9 0zm0 56l43.9 0c-8.1 12.4-15.4 25.3-21.8 38.7L336.2 284z", "M133.8 22.2c4.8-12.7 18-20.2 31.4-17.7l69 12.9c35.6 6.7 72.1 6.7 107.6 0l69-12.9c13.4-2.5 26.6 5 31.4 17.7l28.9 77.2c11.5 30.7 28.1 59.2 49.1 84.4l45.3 54.3c8.7 10.4 8.7 25.5 0 35.9l-45.3 54.3c-21 25.2-37.6 53.7-49.1 84.4l-28.9 77.2c-4.8 12.7-18 20.2-31.4 17.7l-69-12.9c-35.6-6.7-72.1-6.7-107.6 0l-69 12.9c-13.4 2.5-26.6-5-31.4-17.7l-28.9-77.2C93.3 382 76.7 353.4 55.7 328.2L10.5 273.9c-8.7-10.4-8.7-25.5 0-35.9l45.3-54.3c21-25.2 37.6-53.7 49.1-84.4l28.9-77.2zM178 63.9L157.3 119c-13.7 36.6-33.5 70.6-58.5 100.6L68.4 256l30.3 36.4c25 30 44.8 64 58.5 100.6L178 448.1l45.9-8.6c42.4-7.9 85.9-7.9 128.3 0l45.9 8.6L418.7 393c13.7-36.6 33.5-70.6 58.5-100.6L507.6 256l-30.3-36.4c-25-30-44.8-64-58.5-100.6L398 63.9l-45.9 8.6c-42.4 7.9-85.9 7.9-128.3 0L178 63.9z"]]
}, faCircleMicrophone = {
  prefix: "fad",
  iconName: "circle-microphone",
  icon: [512, 512, ["microphone-circle"], "e116", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16c0 53 43 96 96 96s96-43 96-96l0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16c0 65.3-48.9 119.1-112 127l0 17c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-17c-63.1-7.9-112-61.7-112-127l0-16zm80-96c0-26.5 21.5-48 48-48s48 21.5 48 48l0 112c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-112z", "M256 96c-26.5 0-48 21.5-48 48l0 112c0 26.5 21.5 48 48 48s48-21.5 48-48l0-112c0-26.5-21.5-48-48-48zM160 240c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 16c0 65.3 48.9 119.1 112 127l0 17c0 8.8 7.2 16 16 16s16-7.2 16-16l0-17c63.1-7.9 112-61.7 112-127l0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 16c0 53-43 96-96 96s-96-43-96-96l0-16z"]]
}, faMicrophoneCircle = faCircleMicrophone, faBookArrowUp = {
  prefix: "fad",
  iconName: "book-arrow-up",
  icon: [448, 512, [], "e0ba", ["M64 416c0 17.7 14.3 32 32 32l120 0 0-64L96 384c-17.7 0-32 14.3-32 32zm200-32l0 64 88 0 64 0 0-64-64 0-88 0z", "M96 0C43 0 0 43 0 96L0 416c0 53 43 96 96 96l120 0 0-64L96 448c-17.7 0-32-14.3-32-32s14.3-32 32-32l120 0 0-174.1-39 39c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l80-80c9.4-9.4 24.6-9.4 33.9 0l80 80c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-39-39L264 384l88 0 64 0c17.7 0 32-14.3 32-32l0-320c0-17.7-14.3-32-32-32L384 0 96 0zM264 448l0 64 120 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0-88 0z"]]
}, faPopsicle = {
  prefix: "fad",
  iconName: "popsicle",
  icon: [320, 512, [], "e43e", ["M0 160L0 336c0 26.5 21.5 48 48 48l80 0 0-192c0-17.7 14.3-32 32-32s32 14.3 32 32l0 192 80 0c26.5 0 48-21.5 48-48l0-176C320 71.6 248.4 0 160 0S0 71.6 0 160z", "M128 192c0-17.7 14.3-32 32-32s32 14.3 32 32V480c0 17.7-14.3 32-32 32s-32-14.3-32-32V192z"]]
}, faCommand = {
  prefix: "fad",
  iconName: "command",
  icon: [512, 512, [], "e142", ["M0 416c0 53 43 96 96 96s96-43 96-96l0-32 0-64 0-128-64 0 0 128-32 0c-53 0-96 43-96 96zm64 0c0-17.7 14.3-32 32-32l32 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32zM320 96l0 32 0 64 0 128 64 0 0-128 32 0c53 0 96-43 96-96s-43-96-96-96s-96 43-96 96zm64 0c0-17.7 14.3-32 32-32s32 14.3 32 32s-14.3 32-32 32l-32 0 0-32z", "M0 96C0 43 43 0 96 0s96 43 96 96l0 32 128 0 0 64-128 0-64 0-32 0c0 0 0 0 0 0C43 192 0 149 0 96zM320 320l64 0 32 0c53 0 96 43 96 96s-43 96-96 96s-96-43-96-96l0-32-128 0 0-64 128 0zM128 128l0-32c0-17.7-14.3-32-32-32S64 78.3 64 96s14.3 32 32 32l32 0zM384 384l0 32c0 17.7 14.3 32 32 32s32-14.3 32-32s-14.3-32-32-32l-32 0z"]]
}, faBlinds = {
  prefix: "fad",
  iconName: "blinds",
  icon: [512, 512, [], "f8fb", ["M0 107.3C0 118.8 9.2 128 20.6 128L128 128l0-64c-32 0-64 0-96 0c-1.6 0-3.1-.1-4.6-.3s-3-.5-4.4-1c-2.9-.8-5.6-2.1-8-3.6L1.1 100.8c-.7 2.1-1.1 4.3-1.1 6.5zm0 128C0 246.8 9.2 256 20.6 256l78.1 0c4.8-13.6 15.6-24.4 29.3-29.3l0-66.7L24 160 1.1 228.8c-.7 2.1-1.1 4.3-1.1 6.5zm0 128C0 374.8 9.2 384 20.6 384l470.7 0c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L488 288l-298.7 0c-6.6 18.6-24.4 32-45.3 32c-2.6 0-5.2-.2-7.7-.6s-4.9-1-7.3-1.8c-4.7-1.5-9.1-3.8-13-6.6c-7.9-5.7-14-13.7-17.3-23L24 288 1.1 356.8c-.7 2.1-1.1 4.3-1.1 6.5zm0 128C0 502.8 9.2 512 20.6 512l470.7 0c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L488 416 24 416 1.1 484.8c-.7 2.1-1.1 4.3-1.1 6.5zM160 64l0 64 331.4 0c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L497 59.1c-4.9 3.1-10.8 4.9-17 4.9c-106.7 0-213.3 0-320 0zm0 96l0 66.7c.9 .3 1.7 .6 2.5 1c.9 .4 1.7 .7 2.5 1.1c1.6 .8 3.2 1.7 4.7 2.6c3 1.9 5.8 4.1 8.3 6.6c5 5 8.9 11.1 11.3 17.9l302.1 0c11.4 0 20.6-9.2 20.6-20.6c0-2.2-.4-4.4-1.1-6.5L488 160l-328 0z", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l96 0 0 162.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3L160 64l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 0z"]]
}, faStopwatch = {
  prefix: "fad",
  iconName: "stopwatch",
  icon: [448, 512, [9201], "f2f2", ["M16 304C16 200 92.3 113.8 192 98.4c10.4-1.6 21.1-2.4 32-2.4s21.6 .8 32 2.4c37.5 5.8 71.7 21.6 99.7 44.6c16.6 13.6 31 29.7 42.8 47.7C419.7 223.3 432 262.2 432 304c0 114.9-93.1 208-208 208S16 418.9 16 304zM200 192l0 128c0 13.3 10.7 24 24 24s24-10.7 24-24l0-128c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M144 32c0-17.7 14.3-32 32-32l48 0 48 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-16 0 0 34.4c-10.4-1.6-21.1-2.4-32-2.4s-21.6 .8-32 2.4L192 64l-16 0c-17.7 0-32-14.3-32-32zM355.7 143l21.6-21.6c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-24.1 24.1c-11.7-18-26.2-34.1-42.8-47.7zM248 192l0 128c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-128c0-13.3 10.7-24 24-24s24 10.7 24 24z"]]
}, faSaxophone = {
  prefix: "fad",
  iconName: "saxophone",
  icon: [640, 512, [127927], "f8dc", ["M0 152c0 13.3 10.7 24 24 24l4.2 0L4.4 277.4C1.5 289.7 0 302.4 0 315.1l0 3.1C0 407.6 72.4 480 161.8 480c49.4 0 96.1-22.6 126.8-61.4L534.4 108.1c6.1-7.7 15.3-12.1 25.1-12.1l64.2 0c9 0 16.3-7.3 16.3-16.3c0-4.9-2.2-9.5-5.9-12.6L609.8 46.8c-11.5-9.6-26-14.8-41-14.8l-30.3 0c-17 0-33.3 6.7-45.3 18.7L449 95 415 129 401 143 367 177 353 191 319 225 206.6 337.4c-4.2 4.2-10 6.6-16 6.6c-12.5 0-22.6-10.1-22.6-22.6l0-2.6c0-4.4 1.2-8.8 3.4-12.6L246.7 176l17.3 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 128c-13.3 0-24 10.7-24 24zM120 320a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm32-96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M319 225L353 191l-8-8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l8 8zm48-48L401 143l-8-8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l8 8zm48-48L449 95l-8-8c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l8 8zM152 224a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-32 96a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]]
}, faSquare2 = {
  prefix: "fad",
  iconName: "square-2",
  icon: [448, 512, [], "e257", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm128.2 85.3c.1-.9 .3-1.8 .5-2.7c.4-1.8 1-3.5 1.8-5.1c1.6-3.3 4-6.3 7.1-8.6c8.1-6.1 16.1-12.3 24.2-18.4c15.8-12 35.2-18.4 55.1-18.1c1.1 0 2.3 0 3.4 .1c46.5 .7 83.8 38.6 83.8 85.1c0 23.5-9.7 46-26.9 62.1c-21.5 20.1-42.9 40.3-64.4 60.4c27.8 0 55.5 0 83.3 0c13.3 0 24 10.7 24 24s-10.7 24-24 24c-48 0-96 0-144 0c-9.8 0-18.7-6-22.3-15.2s-1.3-19.6 5.9-26.3c36.2-34 72.5-67.9 108.7-101.9c7.5-7 11.7-16.8 11.7-27.1c0-20.3-16.3-36.8-36.6-37.1l-3.4-.1c-9.1-.1-18 2.8-25.3 8.3c-8.1 6.1-16.1 12.3-24.2 18.4c-10.5 8-25.6 6-33.6-4.6c-1.7-2.2-2.9-4.5-3.7-7c-.4-1.2-.7-2.5-.9-3.7c-.1-.9-.2-1.9-.2-1.8c-.1-1-.1-1-.1-2c0-.9 0-1.1 0-1.4c0-.4 .1-.9 .1-1.3z", "M216 176.3c-9.1-.1-18 2.8-25.3 8.3l-24.2 18.4c-10.5 8-25.6 6-33.6-4.5s-6-25.6 4.5-33.6l24.2-18.4c15.8-12 35.2-18.4 55.1-18.1l3.4 .1c46.5 .7 83.8 38.6 83.8 85.1c0 23.5-9.7 46-26.9 62.1L212.7 336l83.3 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-9.8 0-18.7-6-22.3-15.2s-1.3-19.6 5.9-26.3L244.3 240.6c7.5-7 11.7-16.8 11.7-27.1c0-20.3-16.3-36.8-36.6-37.1l-3.4-.1z"]]
}, faFieldHockeyStickBall = {
  prefix: "fad",
  iconName: "field-hockey-stick-ball",
  icon: [512, 512, [127953, "field-hockey"], "f44c", ["M352 432a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zm10.2-321.3c26.6 17.8 53.2 35.5 79.9 53.3c20.4-29.6 40.9-59.1 61.3-88.7c15.1-21.8 9.6-51.7-12.2-66.8C482.9 2.8 473.4 0 464 0c-15.2 0-30.2 7.2-39.5 20.7l-62.2 90z", "M442.1 164l-79.9-53.3L162 400.3c-6.7 9.7-17.7 15.4-29.4 15.5c-20 .1-36.1-16.2-36-36.1l0-2.2c.1-7.3 2.2-14.4 6.2-20.6l17.3-26.5c14.5-22.2 8.3-51.9-13.9-66.4s-51.9-8.3-66.4 13.9L22.5 304.3C8.4 325.8 .8 350.9 .6 376.7l0 2.2C.1 452.3 59.5 512 132.9 511.8c43.2-.1 83.5-21.4 108.1-56.9L442.1 164z"]]
}, faFieldHockey = faFieldHockeyStickBall, faArrowUpSquareTriangle = {
  prefix: "fad",
  iconName: "arrow-up-square-triangle",
  icon: [576, 512, ["sort-shapes-up-alt"], "f88b", ["M304 448c0 5.3 1.3 10.7 4 15.5c5.6 10.2 16.4 16.5 28 16.5l160 0c11.6 0 22.3-6.3 28-16.5c2.7-4.8 4-10.2 4-15.5c0-5.9-1.6-11.8-4.9-17l-80-128c-5.8-9.4-16.1-15-27.1-15s-21.3 5.7-27.1 15l-80 128c-3.2 5.2-4.9 11.1-4.9 17zM320 80l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48z", "M160 32c9 0 17.5 3.8 23.6 10.4l88 96c11.9 13 11.1 33.3-2 45.2s-33.3 11.1-45.2-2L192 146.3 192 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-301.7L95.6 181.6c-11.9 13-32.2 13.9-45.2 2s-13.9-32.2-2-45.2l88-96C142.5 35.8 151 32 160 32z"]]
}, faSortShapesUpAlt = faArrowUpSquareTriangle, faFaceScream = {
  prefix: "fad",
  iconName: "face-scream",
  icon: [640, 512, [], "e38b", ["M64 256c0 11 .7 21.9 2.1 32.6c20.6-2.5 41.7 3.5 57.8 16.9c57.6 48 87.8 118 98 187C252.1 505.1 285.2 512 320 512c34.8 0 68-6.9 98.2-19.5c10.2-69 40.4-139 98-187c16.1-13.4 37.2-19.5 57.8-17c1.4-10.7 2.1-21.5 2.1-32.5C576 114.6 461.4 0 320 0S64 114.6 64 256zm110.6-67c17.1-28 44.5-45 68.7-45c7.6 0 14.9 1.7 21.4 5.3c27.3 14.9 31.1 56.9 8.7 93.7s-62.8 54.7-90.1 39.8s-31.1-56.9-8.7-93.7zM272 368c0-26.5 21.5-48 48-48s48 21.5 48 48l0 32c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-32zm94.6-125c-22.5-36.9-18.6-78.8 8.7-93.7s67.6 2.9 90.1 39.8s18.6 78.8-8.7 93.7s-67.6-2.9-90.1-39.8z", "M183.3 282.7c27.3 14.9 67.6-2.9 90.1-39.8s18.6-78.8-8.7-93.7s-67.6 2.9-90.1 39.8s-18.6 78.8 8.7 93.7zm273.4 0c27.3-14.9 31.1-56.9 8.7-93.7s-62.8-54.7-90.1-39.8s-31.1 56.9-8.7 93.7s62.8 54.7 90.1 39.8zM103.4 330.1C89.1 318.2 68 316.4 51.6 327c-20 13-25.6 39.5-12.4 59.3c26.4 40 43.6 75.3 43.2 125.7L192 512c-7-68.4-34.8-137-88.7-181.9zM588.5 327c-16.4-10.6-37.6-8.8-51.8 3.1C482.8 375 455 443.6 448 512l109.8 0c-.4-50.5 16.7-85.7 43.2-125.7c13.1-19.8 7.6-46.3-12.4-59.3z"]]
}, faSquareM = {
  prefix: "fad",
  iconName: "square-m",
  icon: [448, 512, [], "e276", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm96 56c0-10.4 6.7-19.6 16.6-22.8c2.4-.8 4.9-1.2 7.4-1.2c7.6 0 14.9 3.6 19.5 9.9c28.2 39 56.4 78 84.5 117.1c28.2-39 56.4-78 84.5-117.1c4.6-6.4 11.9-10 19.5-9.9c2.5 0 4.9 .4 7.4 1.2c9.9 3.2 16.6 12.4 16.6 22.8l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-133.8c-20.2 27.9-40.4 55.9-60.5 83.8c-4.5 6.2-11.7 10-19.5 9.9s-14.9-3.7-19.5-9.9c-20.2-27.9-40.4-55.9-60.5-83.8L144 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208z", "M112.6 129.2c9.9-3.2 20.7 .3 26.8 8.8L224 255l84.5-117.1c6.1-8.4 16.9-12 26.8-8.8s16.6 12.4 16.6 22.8l0 208c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-133.8-60.5 83.8c-4.5 6.2-11.7 9.9-19.5 9.9s-14.9-3.7-19.5-9.9L144 226.2 144 360c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-208c0-10.4 6.7-19.6 16.6-22.8z"]]
}, faCameraWeb = {
  prefix: "fad",
  iconName: "camera-web",
  icon: [448, 512, ["webcam"], "f832", ["M96 224a128 128 0 1 0 256 0A128 128 0 1 0 96 224zm48 0c0-44.2 35.8-80 80-80c8.8 0 16 7.2 16 16s-7.2 16-16 16c-26.5 0-48 21.5-48 48c0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M448 224c0 79.5-41.4 149.3-103.8 189.1l58.2 40.7c11.4 8 16.4 22.5 12.2 35.8S398 512 384 512L64 512c-14 0-26.3-9.1-30.5-22.4s.7-27.8 12.2-35.8l58.2-40.7C41.4 373.3 0 303.5 0 224C0 100.3 100.3 0 224 0S448 100.3 448 224zM224 384a160 160 0 1 0 0-320 160 160 0 1 0 0 320z"]]
}, faWebcam = faCameraWeb, faCommentArrowDown = {
  prefix: "fad",
  iconName: "comment-arrow-down",
  icon: [512, 512, [], "e143", ["M0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3C1.6 455.8 0 459.9 0 464c0 2.1 .4 4.1 1.2 6.1c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240zm160 16c0-6.1 2.3-12.3 7-17c9.4-9.4 24.6-9.4 33.9 0l31 31L232 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 118.1 31-31c9.4-9.4 24.6-9.4 33.9 0c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17l-72 72c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7l-72-72c-4.7-4.7-7-10.8-7-17z", "M256 128c13.3 0 24 10.7 24 24l0 118.1 31-31c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-72 72c-9.4 9.4-24.6 9.4-33.9 0l-72-72c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l31 31L232 152c0-13.3 10.7-24 24-24z"]]
}, faLightbulbCfl = {
  prefix: "fad",
  iconName: "lightbulb-cfl",
  icon: [320, 512, [], "e5a6", ["M0 64c0 2.6 .3 5.2 1 7.8C5.2 88.9 22.6 99.3 39.8 95l128-32c17.1-4.3 27.6-21.7 23.3-38.8C187.4 9.7 174.4 0 160 0c-2.6 0-5.2 .3-7.8 1L24.2 33C9.7 36.6 0 49.6 0 64zm0 96c0 2.6 .3 5.2 1 7.8c4.3 17.1 21.7 27.6 38.8 23.3l256-64c17.1-4.3 27.6-21.7 23.3-38.8s-21.7-27.6-38.8-23.3l-256 64C9.7 132.6 0 145.6 0 160zm0 96c0 2.6 .3 5.2 1 7.8c4.3 17.1 21.7 27.6 38.8 23.3L96 273l3.9-1 195.8-49c17.1-4.3 27.6-21.7 23.3-38.8s-21.7-27.6-38.8-23.3l-256 64C9.7 228.6 0 241.6 0 256zm96 50l0 78 48 0 0-90L96 306zm80.2-2c-.2 1.1-.2 2.2-.2 3.3c0 .5 0 .9 0 1.4l0 75.3 48 0c0-15.7 0-31.3 0-47l7.8-1.9 64-16c17.1-4.3 27.6-21.7 23.3-38.8s-21.7-27.6-38.8-23.3l-64 16-16 4c-13.2 3.3-22.4 14.3-24 27z", "M96 384c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l32 0c0 17.7 14.3 32 32 32s32-14.3 32-32l32 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32L96 384z"]]
}, faWindowFrameOpen = {
  prefix: "fad",
  iconName: "window-frame-open",
  icon: [512, 512, [], "e050", ["M96 64l0 160 136 0 0-160L96 64zm184 0l0 160 136 0 0-160L280 64z", "M480 224l0-160c0-35.3-28.7-64-64-64L96 0C60.7 0 32 28.7 32 64l0 160 0 64 64 0 320 0 64 0 0-64zm-64 0l-136 0 0-160 136 0 0 160zm-184 0L96 224 96 64l136 0 0 160zM96 448l0-128-64 0 0 128c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 384 0 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l0-128-64 0 0 128L96 448z"]]
}, faFaceKiss = {
  prefix: "fad",
  iconName: "face-kiss",
  icon: [512, 512, [128535, "kiss"], "f596", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm144.4-48c0-17.7 14.3-32 32-32c8.8 0 16.8 3.6 22.6 9.4c2.9 2.9 5.2 6.3 6.9 10.2c.8 1.9 1.4 3.9 1.9 6c.2 1 .4 2.1 .5 3.2c.1 .5 .1 1.1 .1 1.6s0 1 0 1.8c0 .5 0 1 0 1.5s-.1 1.1-.1 1.6c-.1 1.1-.3 2.1-.5 3.2c-.4 2.1-1.1 4.1-1.9 6c-1.6 3.8-4 7.3-6.9 10.2c-5.8 5.8-13.8 9.4-22.6 9.4c-17.7 0-32-14.3-32-32zm87.9 86c.9-3.5 4.1-6 7.7-6c17.4 0 34.7 4.9 47.9 12.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4c-2.7 1.5-5.7 3-8.7 4.3c3.1 1.3 6 2.7 8.7 4.3c6.6 3.7 12.5 8.2 16.7 13.4c4.3 5.1 7.3 11.4 7.3 18.3s-3.1 13.2-7.3 18.3c-4.3 5.2-10.1 9.7-16.7 13.4C274.7 443.1 257.4 448 240 448c-3.6 0-6.8-2.5-7.7-6s.6-7.2 4.1-9.1c.2-.1 .5-.3 .9-.5c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1c-.4-.2-.7-.4-1.2-.7c-2.5-1.4-4.1-4.1-4.1-7s1.6-5.6 4.1-7c.1 0 .1-.1 .5-.3l.6-.4c.8-.5 2-1.2 3.4-2.1c2.8-1.9 6.5-4.5 10.2-7.6c3.7-3.1 7.2-6.6 9.6-10.1c2.5-3.5 3.5-6.4 3.5-8.6s-1-5-3.5-8.6c-2.5-3.5-5.9-6.9-9.6-10.1c-3.7-3.1-7.4-5.7-10.2-7.6c-1.4-.9-2.6-1.6-3.4-2.1l-.4-.3c-.2-.1-.3-.2-.7-.4c-3.2-1.8-4.7-5.5-3.8-9zm136.1-86a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faKiss = faFaceKiss, faBridgeCircleXmark = {
  prefix: "fad",
  iconName: "bridge-circle-xmark",
  icon: [640, 512, [], "e4cb", ["M32 64c0-17.7 14.3-32 32-32l512 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-40 0 0 64 72 0 0 72.2C577.6 207.1 538.5 192 496 192c-69.1 0-128.9 39.8-157.7 97.7c-5.9-1.1-12-1.7-18.3-1.7c-53 0-96 43-96 96l0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64c0-53-43-96-96-96l0-128 72 0 0-64L64 96C46.3 96 32 81.7 32 64zM152 96l0 64 80 0 0-64-80 0zm128 0l0 64 80 0 0-64-80 0zm128 0l0 64 80 0 0-64-80 0z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]]
}, faPeriod = {
  prefix: "fad",
  iconName: "period",
  icon: [192, 512, [], "2e", ["M32 416a64 64 0 1 1 128 0A64 64 0 1 1 32 416z", ""]]
}, faFaceGrinTongue = {
  prefix: "fad",
  iconName: "face-grin-tongue",
  icon: [512, 512, [128539, "grin-tongue"], "f589", ["M0 256C0 368.9 73.1 464.7 174.5 498.8C165.3 484 160 466.6 160 448l0-47.3c-24-17.5-43.1-41.4-54.8-69.2c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19c12.3-3.8 24.3 6.9 19.3 18.7c-11.8 28-31.1 52-55.4 69.6l0 46.9c0 18.6-5.3 36-14.5 50.8C438.9 464.7 512 368.9 512 256C512 114.6 397.4 0 256 0S0 114.6 0 256zm144.4-48c0-17.7 14.3-32 32-32c8.8 0 16.8 3.6 22.6 9.4c2.9 2.9 5.2 6.3 6.9 10.2c.8 1.9 1.4 3.9 1.9 6c.2 1 .4 2.1 .5 3.2c.1 .5 .1 1.1 .1 1.6s0 1 0 1.8c0 .5 0 1 0 1.5s-.1 1.1-.1 1.6c-.1 1.1-.3 2.1-.5 3.2c-.4 2.1-1.1 4.1-1.9 6c-1.6 3.8-4 7.3-6.9 10.2c-5.8 5.8-13.8 9.4-22.6 9.4c-17.7 0-32-14.3-32-32zm224 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M208.4 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm160 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM320 448l0-45.4c0-14.7-11.9-26.6-26.6-26.6l-2 0c-11.3 0-21.1 7.9-23.6 18.9c-2.8 12.6-20.8 12.6-23.6 0c-2.5-11.1-12.3-18.9-23.6-18.9l-2 0c-14.7 0-26.6 11.9-26.6 26.6l0 45.4c0 35.3 28.7 64 64 64s64-28.7 64-64z"]]
}, faGrinTongue = faFaceGrinTongue, faUpToDottedLine = {
  prefix: "fad",
  iconName: "up-to-dotted-line",
  icon: [448, 512, [], "e457", ["M64 64A32 32 0 1 1 0 64a32 32 0 1 1 64 0zm96 0A32 32 0 1 1 96 64a32 32 0 1 1 64 0zm96 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M196.7 139.3L73.9 262.1c-6.4 6.4-9.9 15-9.9 24C64 304.8 79.2 320 97.9 320l62.1 0 0 128c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-128 62.1 0c18.7 0 33.9-15.2 33.9-33.9c0-9-3.6-17.6-9.9-24L251.3 139.3c-7.2-7.2-17.1-11.3-27.3-11.3s-20.1 4.1-27.3 11.3z"]]
}, faThoughtBubble = {
  prefix: "fad",
  iconName: "thought-bubble",
  icon: [512, 512, [], "e32e", ["M0 480a32 32 0 1 0 64 0A32 32 0 1 0 0 480zm96-48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M374.8 80.3C355.9 33.2 309.8 0 256 0s-99.9 33.2-118.8 80.3c-3-.2-6.1-.3-9.2-.3C57.3 80 0 137.3 0 208s57.3 128 128 128c14.4 0 28.3-2.4 41.3-6.8C184.7 361.6 217.7 384 256 384s71.3-22.4 86.7-54.8c12.9 4.4 26.8 6.8 41.3 6.8c70.7 0 128-57.3 128-128s-57.3-128-128-128c-3.1 0-6.1 .1-9.2 .3z"]]
}, faSkeletonRibs = {
  prefix: "fad",
  iconName: "skeleton-ribs",
  icon: [640, 512, [], "e5cb", ["M0 144l0 96L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-240c0-10.1 4.7-19.6 12.8-25.6l25.6-19.2C118.5 183.1 128 164.1 128 144c0-35.3-28.7-64-64-64S0 108.7 0 144zM160.3 372.7L288 337.9l0 42c21.1-4.3 42.9-4.3 64 0l0-40.9 118.8 35.6c3 .9 6.1 1.3 9.1 1.4c-.7-22.1-4.5-45.3-10.1-68.5L352 272.2l0-40.3 102 22.7c-9-26-19.4-50.6-29.3-72.1L352 166.3l0-38.3-64 0 0 38.3-72.7 16.2c-9.9 21.4-20.2 46.1-29.3 72.1l102-22.7 0 39.7L171.2 303.4c-5.9 23.4-9.9 46.9-11 69.3zM288 32l0 32 64 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32zm0 414.2l0 33.8c0 17.7 14.3 32 32 32s32-14.3 32-32l0-33.8c-20.7-7.3-43.3-7.3-64 0zM512 144c0 20.1 9.5 39.1 25.6 51.2l25.6 19.2c8.1 6 12.8 15.5 12.8 25.6l0 240c0 17.7 14.3 32 32 32s32-14.3 32-32l0-240 0-96c0-35.3-28.7-64-64-64s-64 28.7-64 64z", "M178.2 112.9C194.5 81.6 226.7 64 260.2 64l119.5 0c33.5 0 65.8 17.6 82.1 48.9C489.5 165.8 544 282.2 544 384l0 17c0 43.6-35.4 79-79 79c-15.1 0-30.1-2.7-44.2-8l-67.1-25.2c-21.7-8.2-45.7-8.2-67.4 0L219.2 472c-14.1 5.3-29.1 8-44.2 8c-43.6 0-79-35.4-79-79l0-17c0-101.8 54.5-218.2 82.2-271.1zM260.2 128c-11.4 0-20.8 5.9-25.3 14.5C207.2 195.6 160 299.4 160 384l0 17c0 8.3 6.7 15 15 15c7.4 0 14.8-1.3 21.7-3.9l67.1-25.2c36.2-13.6 76.1-13.6 112.4 0l67.1 25.2c7 2.6 14.3 3.9 21.7 3.9c8.3 0 15-6.7 15-15l0-17c0-84.6-47.2-188.4-74.9-241.5c-4.5-8.6-13.9-14.5-25.3-14.5l-119.5 0z"]]
}, faRaygun = {
  prefix: "fad",
  iconName: "raygun",
  icon: [576, 512, [], "e025", ["M64 24.6l0 50.2C78.5 67.9 94.8 64 112 64l80 0L102.2 4.1C98.2 1.4 93.4 0 88.6 0C75 0 64 11 64 24.6zM288 56l0 8 0 231.6 0 .4c0 13.3 10.7 24 24 24s24-10.7 24-24l0-240c0-13.3-10.7-24-24-24s-24 10.7-24 24zm80 32l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56 0-64 0-56c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M288 64L112 64C50.1 64 0 114.1 0 176s50.1 112 112 112l8.2 0L51.4 425.7c-7.9 15.8-1.5 35 14.3 42.9l80 40c15.8 7.9 35 1.5 42.9-14.3L288 295.6 288 64zM416 208l60.9 0 77.1 30.9c4.9 2 10.5 1.4 14.9-1.6s7-7.9 7-13.2l0-96c0-5.3-2.6-10.3-7-13.2s-10-3.6-14.9-1.6L476.9 144 416 144l0 64zM112 152a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm72 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0z"]]
}, faFlute = {
  prefix: "fad",
  iconName: "flute",
  icon: [640, 512, [], "f8b9", ["M0 208l0 96c0 26.5 21.5 48 48 48l48 0 0-192-48 0c-26.5 0-48 21.5-48 48zm128-48l0 192 464 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-464 0zm216 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M128 160l-32 0 0 192 32 0 0-192zM320 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm96 0a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm120-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]]
}, faAcorn = {
  prefix: "fad",
  iconName: "acorn",
  icon: [448, 512, [], "f6ae", ["M48 192l0 32c0 78.1 30.5 201.9 165.9 252.4c3.2 1.2 6.7 1.8 10.1 1.8s6.9-.6 10.1-1.8C369.5 425.9 400 302.1 400 224l0-32L48 192z", "M267.2 38.4c8-10.6 5.8-25.6-4.8-33.6s-25.6-5.8-33.6 4.8L224 16c-10.7 14.3-18 30.7-21.6 48L96 64C43 64 0 107 0 160c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32c0-53-43-96-96-96l-99.9 0c2.4-6.8 5.9-13.3 10.3-19.2l4.8-6.4z"]]
}, faVideoArrowUpRight = {
  prefix: "fad",
  iconName: "video-arrow-up-right",
  icon: [576, 512, [], "e2c9", ["M0 128L0 384c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-68.2 0-119.6 0-68.2c0-35.3-28.7-64-64-64L64 64C28.7 64 0 92.7 0 128zM96 328c0-6.1 2.3-12.3 7-17l103-103L152 208c-13.3 0-24-10.7-24-24s10.7-24 24-24l112 0c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-54.1L137 345c-9.4 9.4-24.6 9.4-33.9 0c-4.7-4.7-7-10.8-7-17z", "M559.1 99.8c10.4 5.6 16.9 16.4 16.9 28.2l0 256c0 11.8-6.5 22.6-16.9 28.2s-23 5-32.9-1.6L384 315.8l0-119.6 142.2-94.8c9.8-6.5 22.4-7.2 32.9-1.6zM152 160l112 0c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-54.1L137 345c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l103-103L152 208c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]]
}, faGrateDroplet = {
  prefix: "fad",
  iconName: "grate-droplet",
  icon: [576, 512, [], "e194", ["M0 96L0 256 0 416c0 35.3 28.7 64 64 64l64 0 96 0 96 0 24.2 0c-15.3-22.9-24.2-50.4-24.2-80c0-23.6 5.8-46.9 16.9-67.8l75.3-141.2c7.6-14.3 20.6-24.5 35.8-28.8L448 96c0-35.3-28.7-64-64-64l-64 0-96 0-96 0L64 32C28.7 32 0 60.7 0 96zm64 0l32 0 0 128-32 0L64 96zm0 192l32 0 0 128-32 0 0-128zM160 96l32 0 0 128-32 0 0-128zm0 192l32 0 0 128-32 0 0-128zM256 96l32 0 0 128-32 0 0-128zm0 192l32 0 0 128-32 0 0-128zM352 96l32 0 0 128-32 0 0-128z", "M365.2 347.3l75.3-141.2c4.6-8.7 13.7-14.1 23.5-14.1s18.9 5.4 23.5 14.1l75.3 141.2c8.7 16.2 13.2 34.3 13.2 52.7c0 61.9-50.1 112-112 112s-112-50.1-112-112c0-18.4 4.5-36.5 13.2-52.7z"]]
}, faSealExclamation = {
  prefix: "fad",
  iconName: "seal-exclamation",
  icon: [512, 512, [], "e242", ["M4.4 256c0 12.3 4.7 24.6 14.1 33.9L64 335.5 64 400c0 26.5 21.5 48 48 48l64.5 0 45.6 45.6c18.7 18.7 49.1 18.7 67.9 0L335.5 448l64.5 0c26.5 0 48-21.5 48-48l0-64.5 45.6-45.6c18.7-18.7 18.7-49.1 0-67.9L448 176.5l0-64.5c0-26.5-21.5-48-48-48l-64.5 0L289.9 18.4c-18.7-18.7-49.1-18.7-67.9 0L176.5 64 112 64c-26.5 0-48 21.5-48 48l0 64.5L18.4 222.1C9 231.4 4.4 243.7 4.4 256zM288 352a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM232 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112z", "M280 152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM256 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faChessBishop = {
  prefix: "fad",
  iconName: "chess-bishop",
  icon: [320, 512, [9821], "f43a", ["M0 489.4C0 501.9 10.1 512 22.6 512l274.7 0c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16l-32-32c-6-6-14.1-9.4-22.6-9.4l-2.7 0L64 432l-2.7 0c-8.5 0-16.6 3.4-22.6 9.4l-32 32c-4.2 4.2-6.6 10-6.6 16z", "M96 32c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32c0 16.1-11.9 29.4-27.4 31.7c22.4 21.4 51 52.8 74.2 90.9L164.7 260.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l99.4-99.4C301.8 215.6 312 250.7 312 288c0 47.4-30.8 72.3-56 84.7l0 59.3L64 432l0-59.3C38.8 360.3 8 335.4 8 288C8 190 78.4 106.8 123.4 63.7C107.9 61.4 96 48.1 96 32z"]]
}, faMessageSms = {
  prefix: "fad",
  iconName: "message-sms",
  icon: [512, 512, [], "e1e5", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM96 180.8c0 12.3 6.2 23.8 16.4 30.7l29.4 19.6c1.3 .9 2.2 2.4 2.2 4c0 2.7-2.2 4.8-4.8 4.8L112 240c-8.8 0-16 7.2-16 16s7.2 16 16 16l27.2 0c20.3 0 36.8-16.5 36.8-36.8c0-12.3-6.2-23.8-16.4-30.7l-29.4-19.6c-1.3-.9-2.2-2.4-2.2-4c0-2.7 2.2-4.8 4.8-4.8l19.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-19.2 0C112.5 144 96 160.5 96 180.8zM192 160l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 19.2 25.6c3 4 7.8 6.4 12.8 6.4s9.8-2.4 12.8-6.4L288 208l0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-6.9-4.4-13-10.9-15.2s-13.7 .1-17.9 5.6L256 197.3l-35.2-46.9c-4.1-5.5-11.3-7.8-17.9-5.6S192 153.1 192 160zm144 20.8c0 12.3 6.2 23.8 16.4 30.7l29.4 19.6c1.3 .9 2.2 2.4 2.2 4c0 2.7-2.2 4.8-4.8 4.8L352 240c-8.8 0-16 7.2-16 16s7.2 16 16 16l27.2 0c20.3 0 36.8-16.5 36.8-36.8c0-12.3-6.2-23.8-16.4-30.7l-29.4-19.6c-1.3-.9-2.2-2.4-2.2-4c0-2.7 2.2-4.8 4.8-4.8l19.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-19.2 0c-20.3 0-36.8 16.5-36.8 36.8z", "M132.8 144l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-2.7 0-4.8 2.2-4.8 4.8c0 1.6 .8 3.1 2.2 4l29.4 19.6c10.2 6.8 16.4 18.3 16.4 30.7c0 20.3-16.5 36.8-36.8 36.8L112 272c-8.8 0-16-7.2-16-16s7.2-16 16-16l27.2 0c2.7 0 4.8-2.2 4.8-4.8c0-1.6-.8-3.1-2.2-4l-29.4-19.6C102.2 204.7 96 193.2 96 180.8c0-20.3 16.5-36.8 36.8-36.8zM336 180.8c0-20.3 16.5-36.8 36.8-36.8l19.2 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-19.2 0c-2.7 0-4.8 2.2-4.8 4.8c0 1.6 .8 3.1 2.2 4l29.4 19.6c10.2 6.8 16.4 18.3 16.4 30.7c0 20.3-16.5 36.8-36.8 36.8L352 272c-8.8 0-16-7.2-16-16s7.2-16 16-16l27.2 0c2.7 0 4.8-2.2 4.8-4.8c0-1.6-.8-3.1-2.2-4l-29.4-19.6c-10.2-6.8-16.4-18.3-16.4-30.7zm-133.1-36c6.5-2.2 13.7 .1 17.9 5.6L256 197.3l35.2-46.9c4.1-5.5 11.3-7.8 17.9-5.6s10.9 8.3 10.9 15.2l0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48-19.2 25.6c-3 4-7.8 6.4-12.8 6.4s-9.8-2.4-12.8-6.4L224 208l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-6.9 4.4-13 10.9-15.2z"]]
}, faCoffeeBeans = {
  prefix: "fad",
  iconName: "coffee-beans",
  icon: [512, 512, [], "e13f", ["M1.8 352c0-77.4 43.6-141.9 101.6-156.8c-6.8 18.2-13.8 40.4-15.4 59.5c-3.6 42.8 11.6 74.9 25 103.2l.4 .9c13.7 28.9 25.3 54.1 22.5 87.8c-1.4 16.7-8.6 38.9-16.1 57.9c-.9 2.3-1.8 4.6-2.7 6.8C52.5 503.9 1.8 435.4 1.8 352zm118.2-94.7c1.4-16.7 8.6-38.9 16.1-57.9c1-2.4 1.9-4.7 2.8-7C204.4 198.9 256 267.9 256 352c0 78.3-44.6 143.4-103.6 157.3c6.9-18.4 13.9-40.8 15.5-59.9c3.6-42.8-11.6-74.9-25-103.2l-.4-.9c-13.7-28.9-25.3-54.1-22.5-87.8zM240.6 51.2c8.1 17.8 18.9 38.4 31.3 53.1c27.7 32.8 61.2 44.7 90.7 55.3l1 .4c30.1 10.8 56.2 20.3 78 46.2c10.9 12.8 21.4 33.6 29.5 52.3c.9 2 1.7 4 2.5 5.9c-50.8 42.6-136.1 30.7-195.3-29c-54.7-55-69-132.4-37.7-184.2zm23.3-26.8C284 8 309.4 0 336.4 0c41.2 0 86 18.6 121.6 54.4s54 80.9 54 122.4c0 21.7-5.1 42.5-15.5 60.3c-8-17.4-18.5-37.4-30.6-51.6c-27.7-32.8-61.2-44.7-90.7-55.3l-1-.4c-30.1-10.8-56.2-20.3-78-46.2c-10.9-12.8-21.4-33.6-29.5-52.3c-1-2.4-2-4.7-2.9-6.9z", "M471 258.5c.9 2 1.7 4 2.5 5.9c2.4-2 4.7-4.1 6.9-6.4c6.3-6.4 11.7-13.4 16.1-21c-8-17.4-18.5-37.4-30.6-51.6c-27.7-32.8-61.2-44.7-90.7-55.3l-1-.4c-30.1-10.8-56.2-20.3-78-46.2c-10.9-12.8-21.4-33.6-29.5-52.3c-1-2.4-2-4.7-2.9-6.9c-2.8 2.3-5.5 4.7-8.1 7.3c-5.9 6-11 12.5-15.2 19.5c8.1 17.8 18.9 38.4 31.3 53.1c27.7 32.8 61.2 44.7 90.7 55.3l1 .4c30.1 10.8 56.2 20.3 78 46.2c10.9 12.8 21.4 33.6 29.5 52.3zM119.9 504.5c-.9 2.3-1.8 4.6-2.7 6.8c3.9 .4 7.8 .7 11.7 .7c8 0 15.9-.9 23.5-2.7c6.9-18.3 13.9-40.7 15.5-59.9c3.6-42.8-11.6-74.9-25-103.2l-.4-.9c-13.7-28.9-25.3-54.1-22.5-87.8c1.4-16.7 8.6-38.9 16.1-57.9c1-2.4 1.9-4.7 2.8-7c-3.3-.3-6.6-.5-10-.5c-8.7 0-17.2 1.1-25.5 3.2c-6.8 18.2-13.8 40.4-15.4 59.5c-3.6 42.8 11.6 74.9 25 103.2l.4 .9c13.7 28.9 25.3 54.1 22.5 87.8c-1.4 16.7-8.6 38.9-16.1 57.9z"]]
}, faHatWitch = {
  prefix: "fad",
  iconName: "hat-witch",
  icon: [576, 512, [], "f6e7", ["M0 438.6c0 6 2.4 11.7 6.9 15.6C25.9 470.3 82.6 512 160 512l256 0c77.4 0 134.1-41.7 153.1-57.8c4.6-3.9 6.9-9.6 6.9-15.6c0-12.5-10.1-22.6-22.6-22.6L480 416l-128 0-32 0-64 0-32 0L96 416l-73.4 0C10.1 416 0 426.1 0 438.6z", "M96 416L200.6 180.7c15.3-34.4 40.3-63.5 72-83.7L416.1 5c5.2-3.3 11.1-5 17.3-5l2.2 0c8 0 15.7 3 21.6 8.4l76.4 70.1c6.6 6.1 10.4 14.6 10.4 23.6l0 6.8c0 2.1-.2 4.2-.6 6.3l-12.2 60.8c-1.9 9.3-10.1 16.1-19.6 16.1c-9.2 0-17.2-6.2-19.4-15.1l-6.2-24.6C482.5 138 469.7 128 455 128l-20.4 0c-11.5 0-22.1 6.2-27.8 16.1l-18.6 32.5c-2.8 4.8-4.2 10.3-4.2 15.9l0 .7c0 4.5 .9 8.9 2.8 13L480 416l-128 0 0-48c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48l0 48L96 416zm160 0l0-48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48-64 0z"]]
}, faFaceGrinWink = {
  prefix: "fad",
  iconName: "face-grin-wink",
  icon: [512, 512, ["grin-wink"], "f58c", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm105.2 75.5c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19c12.3-3.8 24.3 6.9 19.3 18.7C382.4 390.6 324.2 432 256.3 432s-126.2-41.4-151.1-100.5zM208.4 208a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm66.8 6.4c30.4-40.5 91.2-40.5 121.6 0c2.2 2.9 3.2 6.2 3.2 9.6c0 4.9-2.2 9.7-6.4 12.8c-7.1 5.3-17.1 3.9-22.4-3.2c-17.6-23.5-52.8-23.5-70.4 0c-5.3 7.1-15.3 8.5-22.4 3.2s-8.5-15.3-3.2-22.4z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm124.4-6.4c17.6-23.5 52.8-23.5 70.4 0c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4c-30.4-40.5-91.2-40.5-121.6 0c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2z"]]
}, faGrinWink = faFaceGrinWink, faClockThreeThirty = {
  prefix: "fad",
  iconName: "clock-three-thirty",
  icon: [512, 512, [], "e357", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm232 0c0-13.3 10.7-24 24-24l104 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0 0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136z", "M256 416c-13.3 0-24-10.7-24-24l0-136c0-13.3 10.7-24 24-24l104 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0 0 112c0 13.3-10.7 24-24 24z"]]
}, faEarDeaf = {
  prefix: "fad",
  iconName: "ear-deaf",
  icon: [512, 512, ["deaf", "deafness", "hard-of-hearing"], "f2a4", ["M0 480c0 8.2 3.1 16.4 9.4 22.6s14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4l128-128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-128 128C3.1 463.6 0 471.8 0 480zM417.4 49.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l40-40c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6S488.2 0 480 0s-16.4 3.1-22.6 9.4l-40 40z", "M128.7 227.5c6.2-56 53.7-99.5 111.3-99.5c61.9 0 112 50.1 112 112c0 29.3-11.2 55.9-29.6 75.9c-17 18.4-34.4 45.1-34.4 78l0 6.1c0 26.5-21.5 48-48 48c-17.7 0-32 14.3-32 32s14.3 32 32 32c61.9 0 112-50.1 112-112l0-6.1c0-9.8 5.4-21.7 17.4-34.7C398.3 327.9 416 286 416 240c0-97.2-78.8-176-176-176C149.4 64 74.8 132.5 65.1 220.5c-1.9 17.6 10.7 33.4 28.3 35.3s33.4-10.7 35.3-28.3zM208 240c0-17.7 14.3-32 32-32s32 14.3 32 32c0 13.3 10.7 24 24 24s24-10.7 24-24c0-44.2-35.8-80-80-80s-80 35.8-80 80c0 13.3 10.7 24 24 24s24-10.7 24-24z"]]
}, faDeaf = faEarDeaf, faDeafness = faEarDeaf, faHardOfHearing = faEarDeaf, faAlarmClock = {
  prefix: "fad",
  iconName: "alarm-clock",
  icon: [512, 512, [9200], "f34e", ["M32 288c0 50.3 16.6 96.8 44.6 134.2L41.4 457.4C35.1 463.6 32 471.8 32 480s3.1 16.4 9.4 22.6c12.5 12.5 32.8 12.5 45.3 0l35.2-35.2c37.4 28 83.8 44.6 134.1 44.6s96.8-16.6 134.2-44.6l35.2 35.2c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-35.2-35.2c28-37.4 44.6-83.8 44.6-134.2C480 164.3 379.7 64 256 64S32 164.3 32 288zM232 184c0-13.3 10.7-24 24-24s24 10.7 24 24l0 94.1 41 41c9.4 9.4 9.4 24.6 0 33.9c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7l-48-48c-4.5-4.5-7-10.6-7-17l0-104z", "M14.9 146.4L160 25.4C143 9.6 120.2 0 95.2 0C42.6 0 0 42.6 0 95.2c0 18.8 5.5 36.3 14.9 51.1zM256 160c-13.3 0-24 10.7-24 24l0 104c0 6.4 2.5 12.5 7 17l48 48c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-41-41 0-94.1c0-13.3-10.7-24-24-24zM352 25.4L497.1 146.4C506.5 131.6 512 114 512 95.2C512 42.6 469.4 0 416.8 0C391.8 0 369 9.6 352 25.4z"]]
}, faEclipse = {
  prefix: "fad",
  iconName: "eclipse",
  icon: [640, 512, [], "f749", ["M0 355.4c0 2.1 .4 4.2 1.2 6.1c2.1 5 6.6 8.6 11.9 9.6L121 391l19.8 107.9c1 5.3 4.6 9.8 9.6 11.9s10.7 1.5 15.2-1.6L256 446.9l90.3 62.3c4.5 3.1 10.2 3.7 15.2 1.6s8.6-6.6 9.6-11.9l9.6-52.2c-34.2-15-63.7-38.9-85.4-68.8c-12.4 4-25.6 6.2-39.4 6.2c-70.7 0-128-57.3-128-128s57.3-128 128-128c13.7 0 27 2.2 39.4 6.2c21.7-29.9 51.1-53.9 85.4-68.8l-9.6-52.2c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L256 65.1 165.7 2.8c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L121 121 13.1 140.9c-5.3 1-9.8 4.6-11.9 9.6s-1.5 10.7 1.6 15.2L65.1 256 2.8 346.3C1 349 0 352.2 0 355.4zM160 256c0 53 43 96 96 96c7.6 0 15-.9 22.1-2.6C264 321.3 256 289.6 256 256s8-65.3 22.1-93.4c-7.1-1.7-14.5-2.6-22.1-2.6c-53 0-96 43-96 96z", "M464 80a176 176 0 1 0 0 352 176 176 0 1 0 0-352z"]]
}, faFaceRelieved = {
  prefix: "fad",
  iconName: "face-relieved",
  icon: [512, 512, [], "e389", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM96 144c0-3 .9-6.1 2.7-8.9c2.5-3.8 5.1-7.6 7.6-11.5c17.8-26.6 43.9-46.6 74.3-56.7c2.1-.7 4.2-1.4 6.3-2.1c8.4-2.8 17.4 1.7 20.2 10.1s-1.7 17.4-10.1 20.2c-2.1 .7-4.2 1.4-6.3 2.1c-23.6 7.9-44 23.4-57.8 44.1c-2.5 3.8-5.1 7.6-7.6 11.5c-4.9 7.4-14.8 9.3-22.2 4.4c-4.6-3.1-7.1-8.2-7.1-13.3zm3.2 113.6c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0zm65.5 99.1c6.2-6.2 16.4-6.2 22.6 0c13 13 35.8 27.3 68.7 27.3s55.6-14.3 68.7-27.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6C329.4 397.2 298.9 416 256 416s-73.4-18.8-91.3-36.7c-6.2-6.2-6.2-16.4 0-22.6zm126.5-99.1c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0zM304.8 74.9C307.1 68.2 313.3 64 320 64c1.7 0 3.4 .3 5.1 .8l6.3 2.1c30.4 10.1 56.5 30.1 74.3 56.7l7.6 11.5c1.8 2.7 2.7 5.8 2.7 8.9c0 5.2-2.5 10.2-7.1 13.3c-7.4 4.9-17.3 2.9-22.2-4.4L379 141.4c-13.8-20.7-34.1-36.3-57.8-44.1l-6.3-2.1c-8.4-2.8-12.9-11.9-10.1-20.2z", "M207.2 74.9c2.8 8.4-1.7 17.4-10.1 20.2l-6.3 2.1c-23.6 7.9-44 23.4-57.8 44.1l-7.6 11.5c-4.9 7.4-14.8 9.3-22.2 4.4s-9.3-14.8-4.4-22.2l7.6-11.5c17.8-26.6 43.9-46.6 74.3-56.7l6.3-2.1c8.4-2.8 17.4 1.7 20.2 10.1zM124.8 238.4c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2zm192 0c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2zM314.9 95.2c-8.4-2.8-12.9-11.9-10.1-20.2s11.9-12.9 20.2-10.1l6.3 2.1c30.4 10.1 56.5 30.1 74.3 56.7l7.6 11.5c4.9 7.4 2.9 17.3-4.4 22.2s-17.3 2.9-22.2-4.4L379 141.4c-13.8-20.7-34.1-36.3-57.8-44.1l-6.3-2.1z"]]
}, faRoadCircleCheck = {
  prefix: "fad",
  iconName: "road-circle-check",
  icon: [640, 512, [], "e564", ["M32 425.4C32 455.5 56.5 480 86.6 480L288 480l0-64c0-17.7 14.3-32 32-32l.7 0c-.5-5.3-.7-10.6-.7-16c0-16.9 2.4-33.3 6.8-48.7c-2.2 .5-4.5 .7-6.8 .7c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 42.8c31.9-45.2 84.5-74.8 144-74.8c11.6 0 22.9 1.1 33.8 3.2L487.1 74.6C478 49.1 453.9 32 426.8 32L352 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64-74.8 0c-27.1 0-51.3 17.1-60.3 42.6L35.1 407.2c-2.1 5.9-3.1 12-3.1 18.2z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]]
}, faDiceFive = {
  prefix: "fad",
  iconName: "dice-five",
  icon: [448, 512, [9860], "f523", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm160 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M96 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm0 192a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM224 224a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64-64a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm32 160a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]]
}, faOctagonMinus = {
  prefix: "fad",
  iconName: "octagon-minus",
  icon: [512, 512, ["minus-octagon"], "f308", ["M.1 191.5l0 129c0 19.1 7.6 37.4 21.1 50.9L140.6 490.8c13.5 13.5 31.8 21.1 50.9 21.1l129 0c19.1 0 37.4-7.6 50.9-21.1L490.8 371.4c13.5-13.5 21.1-31.8 21.1-50.9l0-129c0-19.1-7.6-37.4-21.1-50.9L371.4 21.2C357.9 7.7 339.6 .1 320.5 .1l-129 0c-19.1 0-37.4 7.6-50.9 21.1L21.2 140.6C7.7 154.1 .1 172.4 .1 191.5zM160 256c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z", "M160 256c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z"]]
}, faMinusOctagon = faOctagonMinus, faSquareRss = {
  prefix: "fad",
  iconName: "square-rss",
  icon: [448, 512, ["rss-square"], "f143", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm96 40c0 13.3 10.7 24 24 24c110.5 0 200 89.5 200 200c0 13.3 10.7 24 24 24s24-10.7 24-24c0-137-111-248-248-248c-13.3 0-24 10.7-24 24zm0 96c0 13.3 10.7 24 24 24c57.4 0 104 46.6 104 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-83.9-68.1-152-152-152c-13.3 0-24 10.7-24 24zm0 120a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M120 112c-13.3 0-24 10.7-24 24s10.7 24 24 24c110.5 0 200 89.5 200 200c0 13.3 10.7 24 24 24s24-10.7 24-24c0-137-111-248-248-248zm0 96c-13.3 0-24 10.7-24 24s10.7 24 24 24c57.4 0 104 46.6 104 104c0 13.3 10.7 24 24 24s24-10.7 24-24c0-83.9-68.1-152-152-152zm8 176a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faRssSquare = faSquareRss, faFaceZany = {
  prefix: "fad",
  iconName: "face-zany",
  icon: [512, 512, [], "e3a4", ["M34.4 384c36.2 62.7 94.9 104.3 160.1 120.5c-11.5-15.8-18.4-35.4-18.4-56.5l0-39.8c-10.4-6.2-20.1-13.7-28.9-22.2c-10.2-9.9-6.6-26.3 5.7-33.4L391.2 214.9c12.3-7.1 28.3-2 31.8 11.8c15.2 59.4-5.9 124.1-55 165l0 56.3c0 15.4-3.6 30-10.1 42.9c8.8-3.8 17.5-8.2 26.1-13.2c82.1-47.4 128-133.5 128-221.9c0-43.4-11.1-87.4-34.3-127.8C407.1 5.6 250.5-36.4 128.1 34.3S-36.3 261.6 34.4 384zM192 224A64 64 0 1 1 64 224a64 64 0 1 1 128 0zm192-72a72 72 0 1 1 -144 0 72 72 0 1 1 144 0z", "M296 104a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM104 224a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM336.1 402.6l0 45.4c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-45.4c0-14.7 11.9-26.6 26.6-26.6l2 0c11.3 0 21.1 7.9 23.6 18.9c2.8 12.6 20.8 12.6 23.6 0c2.5-11.1 12.3-18.9 23.6-18.9l2 0c14.7 0 26.6 11.9 26.6 26.6z"]]
}, faTricycle = {
  prefix: "fad",
  iconName: "tricycle",
  icon: [512, 512, [], "e5c3", ["M224 368.1A112 112 0 1 1 0 368a112 112 0 1 1 224 .1zM56 368a56 56 0 1 0 112 0A56 56 0 1 0 56 368zm200-16c0-51.5 30.4-95.9 74.2-116.2c4.7 18.7 9.4 37.4 14 56.1c-19.4 12.9-32.2 35-32.2 60c0 39.8 32.2 72 72 72s72-32.2 72-72c0-37.5-28.6-68.2-65.2-71.7c-4.7-18.7-9.4-37.4-14-56.1c2.4-.1 4.8-.2 7.2-.2c70.7 0 128 57.3 128 128s-57.3 128-128 128s-128-57.3-128-128z", "M256 56c0-13.3 10.7-24 24-24l73.6 0C388.1 32 416 59.9 416 94.4c0 18.2-8 35.5-21.8 47.3l-31.3 26.9 44.4 177.6c3.2 12.9-4.6 25.9-17.5 29.1s-25.9-4.6-29.1-17.5L319.3 192l-12.1 0c-57.6 0-110.9 29.5-141.6 77.6c-14.3-7.8-30.5-12.6-47.8-13.5c1.2-2.3 2.5-4.5 3.9-6.7L77.6 176 56 176c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-2.4 0 19.6 32.6c40-40.7 95.3-64.6 154.1-64.6l10.9 0c.7-.8 1.5-1.5 2.3-2.2L363 105.3c3.2-2.7 5-6.7 5-10.9c0-7.9-6.4-14.4-14.4-14.4L280 80c-13.3 0-24-10.7-24-24z"]]
}, faLandMineOn = {
  prefix: "fad",
  iconName: "land-mine-on",
  icon: [640, 512, [], "e51b", ["M83.7 480c0 16.8 13.5 32 32 32l408.4 0c23.8 0 39.3-25 28.6-46.3l-27.6-55.2c-8.1-16.3-24.7-26.5-42.9-26.5l-324.7 0c-18.2 0-34.8 10.3-42.9 26.5L87.2 465.7c-2.3 4.7-3.4 9.6-3.4 14.3zM192 320l0 32 256 0 0-32c0-17.7-14.3-32-32-32l-192 0c-17.7 0-32 14.3-32 32z", "M320 0c13.3 0 24 10.7 24 24l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24zM36.3 138.3c7.5-10.9 22.5-13.6 33.4-6.1l104 72c10.9 7.5 13.6 22.5 6.1 33.4s-22.5 13.6-33.4 6.1l-104-72c-10.9-7.5-13.6-22.5-6.1-33.4zm534.1-6.1c10.9-7.5 25.8-4.8 33.4 6.1s4.8 25.8-6.1 33.4l-104 72c-10.9 7.5-25.8 4.8-33.4-6.1s-4.8-25.8 6.1-33.4l104-72z"]]
}, faSquareArrowUpLeft = {
  prefix: "fad",
  iconName: "square-arrow-up-left",
  icon: [448, 512, [], "e263", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm112 72c0-13.3 10.7-24 24-24l152 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-94.1 0L329 327c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17s-10.8 7-17 7s-12.3-2.3-17-7l-135-135L160 328c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-160z", "M136 144l152 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-94.1 0L329 327c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-135-135L160 328c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-160c0-13.3 10.7-24 24-24z"]]
}, faICursor = {
  prefix: "fad",
  iconName: "i-cursor",
  icon: [256, 512, [], "f246", ["M32 256c0 17.7 14.3 32 32 32l32 0c0-21.3 0-42.7 0-64l-32 0c-17.7 0-32 14.3-32 32zm128-32l0 64 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0z", "M29.3 63.9C11.7 62.4-1.4 47 .1 29.3S17-1.4 34.7 .1l8 .7C76.8 3.6 106.8 19.7 128 43.7c21.2-24 51.2-40 85.4-42.9l8-.7c17.6-1.5 33.1 11.6 34.5 29.2s-11.6 33.1-29.2 34.5l-8 .7C185.5 67.3 160 95 160 128.3l0 255.3c0 33.3 25.5 61 58.7 63.8l8 .7c17.6 1.5 30.7 16.9 29.2 34.5s-16.9 30.7-34.5 29.2l-8-.7c-34.1-2.8-64.2-18.9-85.4-42.9c-21.2 24-51.2 40-85.4 42.9l-8 .7C17 513.4 1.6 500.3 .1 482.7s11.6-33.1 29.2-34.5l8-.7C70.5 444.7 96 417 96 383.7l0-255.3c0-33.3-25.5-61-58.7-63.8l-8-.7z"]]
}, faChartMixedUpCircleDollar = {
  prefix: "fad",
  iconName: "chart-mixed-up-circle-dollar",
  icon: [576, 512, [], "e5d9", ["M0 224c0 7 2.3 14.1 7 20c11 13.8 31.2 16 45 5L192.6 136.5l108.2 81.1c11.7 8.8 27.8 8.5 39.2-.6L480 105l0 39c0 17.7 14.3 32 32 32s32-14.3 32-32l0-112c0-17.7-14.3-32-32-32L400 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l28.8 0L319.4 151.5 211.2 70.4c-11.7-8.8-27.8-8.5-39.2 .6L12 199c-7.9 6.3-12 15.6-12 25zM32 352l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32zm128-96l0 192c0 17.7 14.3 32 32 32s32-14.3 32-32l0-192c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zM408.1 339c0 0 0 0 0 .1c0 .4 0 1.9 4.8 4.5c5.6 3 13.5 5.2 23.9 8.2l.2 0c9.3 2.6 21.1 6 30.5 11.5c10.2 6 20 16.1 20.5 32.3c.5 18.2-9.7 30.4-21.7 36.9c-5.8 3.1-12.1 5.1-18.3 6.2l0 10.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-11.4c-8.6-1.7-16.7-4.3-23.7-6.6c0 0 0 0 0 0c-1.7-.6-3.4-1.1-5-1.6c-8.4-2.6-13.2-11.6-10.5-20s11.6-13.2 20-10.5c2 .6 3.9 1.2 5.8 1.8c11.4 3.6 20.4 6.5 29.9 6.8c6.7 .2 13.8-1.1 18.5-3.6c2.2-1.2 3.4-2.4 4-3.3c.5-.8 1.1-2.1 1-4.5c0-1.4-.2-3-4.7-5.6c-5.3-3.1-12.9-5.4-23.2-8.3l-1.8-.5c-8.9-2.5-19.8-5.6-28.6-10.3c-9.9-5.3-20.6-14.7-21.6-30.7c-1.2-18.8 10-30.9 21.8-37.2c5.7-3.1 12-5.1 18-6.3l0-9.5c0-8.8 7.2-16 16-16s16 7.2 16 16l0 9.4c6.3 .9 12.3 2.3 17.9 3.7c8.6 2.1 13.8 10.8 11.7 19.4s-10.8 13.8-19.4 11.7c-9.3-2.3-18.2-4-26.4-4.1c-6.2-.1-13.6 1.3-18.7 4c-2.4 1.3-3.6 2.5-4.2 3.4c-.4 .7-.9 1.6-.8 3.6z"]]
}, faSaltShaker = {
  prefix: "fad",
  iconName: "salt-shaker",
  icon: [384, 512, [129474], "e446", ["M0 452.2c0 33 26.8 59.8 59.8 59.8l264.5 0c33 0 59.8-26.8 59.8-59.8c0-2.8-.2-5.7-.6-8.5L347.4 192l-64.6 0c12.2 85.4 24.4 170.7 36.6 256L64.6 448l36.6-256-64.6 0L.6 443.8c-.4 2.8-.6 5.6-.6 8.5z", "M101.2 192l181.6 0 64.6 0-9.3-65.3C327.7 54 265.4 0 192 0S56.3 54 45.9 126.7L36.6 192l64.6 0zM176 64a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zM144 80a16 16 0 1 1 0 32 16 16 0 1 1 0-32zm80 16a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]]
}, faStamp = {
  prefix: "fad",
  iconName: "stamp",
  icon: [512, 512, [], "f5bf", ["M32 416l8 0 56 0 0 32 320 0 0-32 56 0 8 0 0 48c0 26.5-21.5 48-48 48L80 512c-26.5 0-48-21.5-48-48l0-48z", "M312 201.8c0-17.4 9.2-33.2 19.9-47C344.5 138.5 352 118.1 352 96c0-53-43-96-96-96s-96 43-96 96c0 22.1 7.5 42.5 20.1 58.8c10.7 13.8 19.9 29.6 19.9 47c0 29.9-24.3 54.2-54.2 54.2L112 256C50.1 256 0 306.1 0 368l0 8c0 22.1 17.9 40 40 40l432 0c22.1 0 40-17.9 40-40l0-8c0-61.9-50.1-112-112-112l-33.8 0c-29.9 0-54.2-24.3-54.2-54.2z"]]
}, faFilePlus = {
  prefix: "fad",
  iconName: "file-plus",
  icon: [384, 512, [], "f319", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM96 336c0 13.3 10.7 24 24 24l48 0 0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-48c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48-48 0c-13.3 0-24 10.7-24 24z", "M384 160l-128 0c-17.7 0-32-14.3-32-32L224 0 384 160zM192 240c13.3 0 24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24z"]]
}, faDrawSquare = {
  prefix: "fad",
  iconName: "draw-square",
  icon: [448, 512, [], "f5ef", ["M32 151.4c4.7 2.7 9.8 4.9 15.2 6.3c2.7 .7 5.4 1.3 8.2 1.7c1.4 .2 2.8 .3 4.3 .4c.7 0 1.4 .1 2.2 .1s1.4 0 2.2 0c11.7 0 22.6-3.1 32-8.6l0 209.1c-4.7-2.7-9.8-4.9-15.2-6.3c-2.7-.7-5.4-1.3-8.2-1.7c-1.4-.2-2.8-.3-4.3-.4c-.7 0-1.4-.1-2.2-.1s-1.4 0-2.2 0c-11.7 0-22.6 3.1-32 8.6l0-209.1zM119.4 64l209.1 0c-2.7 4.7-4.9 9.8-6.3 15.2c-.7 2.7-1.3 5.4-1.7 8.2c-.2 1.4-.3 2.8-.4 4.3c0 .7-.1 1.4-.1 2.2s0 1.4 0 2.2c0 11.7 3.1 22.6 8.6 32l-209.1 0c2.7-4.7 4.9-9.8 6.3-15.2c.7-2.7 1.3-5.4 1.7-8.2c.2-1.4 .3-2.8 .4-4.3c0-.7 .1-1.4 .1-2.2s0-1.4 0-2.2c0-11.7-3.1-22.6-8.6-32zm0 320l209.1 0c-2.7 4.7-4.9 9.8-6.3 15.2c-.7 2.7-1.3 5.4-1.7 8.2c-.2 1.4-.3 2.8-.4 4.3c0 .7-.1 1.4-.1 2.2s0 1.4 0 2.2c0 11.7 3.1 22.6 8.6 32l-209.1 0c2.7-4.7 4.9-9.8 6.3-15.2c.7-2.7 1.3-5.4 1.7-8.2c.2-1.4 .3-2.8 .4-4.3c0-.7 .1-1.4 .1-2.2s0-1.4 0-2.2c0-11.7-3.1-22.6-8.6-32zM352 151.4c4.7 2.7 9.8 4.9 15.2 6.3c2.7 .7 5.4 1.3 8.2 1.7c1.4 .2 2.8 .3 4.3 .4c.7 0 1.4 .1 2.2 .1s1.4 0 2.2 0c11.7 0 22.6-3.1 32-8.6l0 209.1c-4.7-2.7-9.8-4.9-15.2-6.3c-2.7-.7-5.4-1.3-8.2-1.7c-1.4-.2-2.8-.3-4.3-.4c-.7 0-1.4-.1-2.2-.1s-1.4 0-2.2 0c-11.7 0-22.6 3.1-32 8.6l0-209.1z", "M0 96a64 64 0 1 1 128 0A64 64 0 1 1 0 96zM64 352a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm320 0a64 64 0 1 1 0 128 64 64 0 1 1 0-128zm0-320a64 64 0 1 1 0 128 64 64 0 1 1 0-128z"]]
}, faToiletPaperUnderSlash = {
  prefix: "fad",
  iconName: "toilet-paper-under-slash",
  icon: [640, 512, ["toilet-paper-reverse-slash"], "e2a1", ["M64 192c0-15 .9-29.6 2.5-43.6L365.5 384 160 384c-53 0-96-86-96-192zM95.6 49.6C112.6 18.8 135.2 0 160 0L412.2 0C400.6 12.2 391 26.9 383.5 41.9C363.5 82 352 135.1 352 192c0 21.5 1.6 42.4 4.7 62.3c-87-68.2-174.1-136.4-261.1-204.7zM224 416l182.2 0c40.6 32 81.2 64 121.8 96l-256 0c-26.5 0-48-21.5-48-48l0-48zM384 192c0-83.6 26.7-154.7 64-181.1C458 3.8 468.8 0 480 0c53 0 96 86 96 192c0 35-4.7 67.8-12.8 96c-11.7 40.5-30.6 71.6-53.1 86.4c-38-29.8-76-59.6-114-89.3c-7.7-27.6-12-59.3-12-93.1zm64 0c0 35.3 14.3 64 32 64s32-28.7 32-64s-14.3-64-32-64s-32 28.7-32 64zm88.1 202.9c16.7-13.6 30-32.4 39.9-51.8l0 83.1c-13.3-10.4-26.6-20.8-39.9-31.2z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faToiletPaperReverseSlash = faToiletPaperUnderSlash, faStairs = {
  prefix: "fad",
  iconName: "stairs",
  icon: [576, 512, [], "e289", ["M128 352l0 64 64 0 0-64-64 0zM256 224l0 64 64 0 0-64-64 0zM384 96l0 64 64 0 0-64-64 0z", "M416 32c-17.7 0-32 14.3-32 32l0 32 64 0 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L416 32zM384 160l-96 0c-17.7 0-32 14.3-32 32l0 32 64 0 96 0c17.7 0 32-14.3 32-32l0-32-64 0zM160 288c-17.7 0-32 14.3-32 32l0 32 64 0 96 0c17.7 0 32-14.3 32-32l0-32-64 0-96 0zm32 128l-64 0-96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-32z"]]
}, faDroneFront = {
  prefix: "fad",
  iconName: "drone-front",
  icon: [640, 512, ["drone-alt"], "f860", ["M0 136c0 13.3 10.7 24 24 24l72 0 64 0 104 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-108.3 0-55.4 0L24 112c-13.3 0-24 10.7-24 24zm352 0c0 13.3 10.7 24 24 24l104 0 64 0 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-76.3 0-55.4 0L376 112c-13.3 0-24 10.7-24 24z", "M160 160l-64 0 0 32 0 64c0 12.6 7.4 24.1 19 29.2l56.5 25.1c-17.8 21.5-27.5 48.5-27.5 76.4l0 5.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-5.2c0-16.8 5.9-33.2 16.7-46.1l8.4-10.1L259 349.2c4.1 1.8 8.5 2.8 13 2.8l96 0c4.5 0 8.9-.9 13-2.8l41.9-18.6 8.4 10.1c10.8 12.9 16.7 29.3 16.7 46.1l0 5.2c0 13.3 10.7 24 24 24s24-10.7 24-24l0-5.2c0-27.9-9.7-54.9-27.5-76.4L525 285.2c11.6-5.1 19-16.6 19-29.2l0-64 0-32-64 0 0 32 0 43.2-17.8 7.9-40.6-23.7C390.7 201.5 355.7 192 320 192s-70.7 9.5-101.6 27.5l-40.6 23.7L160 235.2l0-43.2 0-32zm324.3-48l55.4 0c-5.5-9.6-15.9-16-27.7-16s-22.2 6.4-27.7 16zM128 96c-11.8 0-22.2 6.4-27.7 16l55.4 0c-5.5-9.6-15.9-16-27.7-16z"]]
}, faDroneAlt = faDroneFront, faGlassEmpty = {
  prefix: "fad",
  iconName: "glass-empty",
  icon: [384, 512, [], "e191", ["M8.6 10.2C14.6 3.7 23.1 0 32 0L352 0c8.9 0 17.4 3.7 23.4 10.2s9.1 15.2 8.5 24.1L355.1 437.7c-3 41.9-37.8 74.3-79.8 74.3l-166.6 0c-42 0-76.8-32.4-79.8-74.3L.1 34.3c-.6-8.9 2.4-17.6 8.5-24.1zM66.4 64L92.7 433.1c.6 8.4 7.6 14.9 16 14.9l166.6 0c8.4 0 15.4-6.5 16-14.9L317.6 64 66.4 64z", ""]]
}, faDialHigh = {
  prefix: "fad",
  iconName: "dial-high",
  icon: [576, 512, [], "e15c", ["M0 288a32 32 0 1 0 64 0A32 32 0 1 0 0 288zM64 96a32 32 0 1 0 64 0A32 32 0 1 0 64 96zm0 384a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM256 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM448 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 384a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64-192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M446.6 263.6c-11.6-77-78-136-158.2-136c-88.4 0-160 71.6-160 160s71.6 160 160 160c80.2 0 146.6-59 158.2-136l-158.2 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l158.2 0z"]]
}, faUserHelmetSafety = {
  prefix: "fad",
  iconName: "user-helmet-safety",
  icon: [448, 512, [128119, "user-construction", "user-hard-hat"], "f82c", ["M96 192c0 70.7 57.3 128 128 128s128-57.3 128-128c0-5.4-.3-10.8-1-16L97 176c-.7 5.2-1 10.6-1 16z", "M216 0c-13.3 0-24 10.7-24 24l0 56L163.6 23.1C125.6 43.5 99 82.6 96.2 128l-.2 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l256 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-.2 0C349 82.6 322.4 43.5 284.4 23.1L256 80l0-56c0-13.3-10.7-24-24-24L216 0zM134.4 352C60.2 352 0 412.2 0 486.4C0 500.5 11.5 512 25.6 512l396.8 0c14.1 0 25.6-11.5 25.6-25.6C448 412.2 387.8 352 313.6 352l-179.2 0z"]]
}, faUserConstruction = faUserHelmetSafety, faUserHardHat = faUserHelmetSafety, faI = {
  prefix: "fad",
  iconName: "i",
  icon: [320, 512, [105], "49", ["M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l96 0 0 320-96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0 0-320 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L160 32 32 32z", ""]]
}, faHryvniaSign = {
  prefix: "fad",
  iconName: "hryvnia-sign",
  icon: [384, 512, [8372, "hryvnia"], "f6f2", ["M0 208c0 17.7 14.3 32 32 32l123.5 0 91.8-52.5c.7-.4 1.3-.8 2-1.2s1.3-.8 1.9-1.3c1.2-.9 2.4-1.8 3.6-2.8c2.3-1.9 4.4-4.1 6.2-6.4L32 176c-17.7 0-32 14.3-32 32zm0 96c0 17.7 14.3 32 32 32l20.3 0c7.5-26.1 24.2-49 47.5-64L32 272c-17.7 0-32 14.3-32 32zm123.1 32L352 336c17.7 0 32-14.3 32-32s-14.3-32-32-32l-123.5 0-91.8 52.5c-.7 .4-1.3 .8-2 1.2s-1.3 .8-1.9 1.3c-1.2 .9-2.4 1.8-3.6 2.8c-2.3 1.9-4.4 4.1-6.2 6.4zm161.1-96l67.8 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-20.3 0c-7.5 26.1-24.2 49-47.5 64z", "M179.6 96c-21 0-41.3 7.1-57.7 20.2L116 121c-13.8 11-33.9 8.8-45-5s-8.8-33.9 5-45l5.9-4.7C109.7 44.1 144.1 32 179.6 32L223 32c62.4 0 113 50.6 113 113c0 40.5-21.7 78-56.9 98.1L136.7 324.5c-15.3 8.7-24.7 25-24.7 42.5c0 27.1 21.9 49 49 49l43.4 0c21 0 41.3-7.1 57.7-20.2L268 391c13.8-11 33.9-8.8 45 5s8.8 33.9-5 45l-5.9 4.7c-27.7 22.2-62.2 34.3-97.7 34.3L161 480C98.6 480 48 429.4 48 367c0-40.6 21.7-78 56.9-98.1l142.4-81.4c15.3-8.7 24.7-25 24.7-42.5c0-27.1-21.9-49-49-49l-43.4 0z"]]
}, faHryvnia = faHryvniaSign, faArrowDownLeftAndArrowUpRightToCenter = {
  prefix: "fad",
  iconName: "arrow-down-left-and-arrow-up-right-to-center",
  icon: [512, 512, [], "e092", ["M0 480c0 8.2 3.1 16.4 9.4 22.6s14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4L176 381.3l0 50.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L80 272c-17.7 0-32 14.3-32 32s14.3 32 32 32l50.7 0L9.4 457.4C3.1 463.6 0 471.8 0 480z", "M502.6 9.4c12.5 12.5 12.5 32.8 0 45.3L381.3 176l50.7 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32s32 14.3 32 32l0 50.7L457.4 9.4c12.5-12.5 32.8-12.5 45.3 0z"]]
}, faPills = {
  prefix: "fad",
  iconName: "pills",
  icon: [576, 512, [], "f484", ["M0 144l0 80 0 32 32 0 160 0 32 0 0-32 0-80c0-61.9-50.1-112-112-112S0 82.1 0 144zM256 320c0 88.4 71.6 160 160 160c28.9 0 56-7.7 79.4-21.1c12.3-7.1 13.1-23.7 3.1-33.8L310.9 237.5c-10-10-26.7-9.3-33.8 3.1C263.7 264 256 291.1 256 320zm77.5-105.1L521.1 402.5c10 10 26.7 9.3 33.8-3.1C568.3 376 576 348.9 576 320c0-88.4-71.6-160-160-160c-28.9 0-56 7.7-79.4 21.1c-12.3 7.1-13.1 23.7-3.1 33.8z", "M32 256L0 256l0 32 0 80c0 61.9 50.1 112 112 112s112-50.1 112-112l0-80 0-32-32 0L32 256z"]]
}, faFaceGrinWide = {
  prefix: "fad",
  iconName: "face-grin-wide",
  icon: [512, 512, [128515, "grin-alt"], "f581", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm105.2 75.5c-5-11.8 7-22.5 19.3-18.7c39.7 12.2 84.5 19 131.8 19s92.1-6.8 131.8-19c12.3-3.8 24.3 6.9 19.3 18.7C382.4 390.6 324.2 432 256.3 432s-126.2-41.4-151.1-100.5zM144 192c0-35.3 14.3-64 32-64s32 28.7 32 64s-14.3 64-32 64s-32-28.7-32-64zm160 0c0-35.3 14.3-64 32-64s32 28.7 32 64s-14.3 64-32 64s-32-28.7-32-64z", "M176 256c17.7 0 32-28.7 32-64s-14.3-64-32-64s-32 28.7-32 64s14.3 64 32 64zm160 0c17.7 0 32-28.7 32-64s-14.3-64-32-64s-32 28.7-32 64s14.3 64 32 64z"]]
}, faGrinAlt = faFaceGrinWide, faTooth = {
  prefix: "fad",
  iconName: "tooth",
  icon: [448, 512, [129463], "f5c9", ["M186.1 52.1C169.3 39.1 148.7 32 127.5 32C74.7 32 32 74.7 32 127.5l0 6.2c0 15.8 3.7 31.3 10.7 45.5l23.5 47.1c4.5 8.9 7.6 18.4 9.4 28.2l36.7 205.8c2 11.2 11.6 19.4 22.9 19.8s21.4-7.4 24-18.4l28.9-121.3C192.2 323.7 207 312 224 312s31.8 11.7 35.8 28.3l28.9 121.3c2.6 11.1 12.7 18.8 24 18.4s20.9-8.6 22.9-19.8l36.7-205.8c1.8-9.8 4.9-19.3 9.4-28.2l23.5-47.1c7.1-14.1 10.7-29.7 10.7-45.5l0-2.1c0-55-44.6-99.6-99.6-99.6c-24.1 0-47.4 8.8-65.6 24.6l-3.2 2.8 19.5 15.2c7 5.4 8.2 15.5 2.8 22.5s-15.5 8.2-22.5 2.8l-24.4-19-37-28.8z", ""]]
}, faBasketballHoop = {
  prefix: "fad",
  iconName: "basketball-hoop",
  icon: [640, 512, [], "f435", ["M0 214.9L0 331.2c0 25.3 14.9 48.2 38 58.5l96.4 42.9L113.8 288l-1.8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-16 0-64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 64 0 16 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-1.8 0L505.6 432.6 602 389.7c23.1-10.3 38-33.2 38-58.5l0-116.3c0-8.9-1.8-18.6-6.8-28C615.3 153.1 523.3 0 320 0S24.7 153.1 6.8 187C1.8 196.3 0 206 0 214.9zM192 160l0 64 0 16 256 0 0-16 0-64-256 0z", "M112 240c-13.3 0-24 10.7-24 24s10.7 24 24 24l34.1 0 7.2 50.3 22.9 160c.9 6.1 5.2 11.2 11.1 13s12.3 .1 16.5-4.4L255.6 451l52.8 56c3 3.2 7.2 5 11.6 5s8.6-1.8 11.6-5l52.8-56 51.9 55.9c4.2 4.5 10.6 6.2 16.5 4.4s10.2-6.9 11.1-13l22.9-160 7.2-50.3 34.1 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-416 0zm349.6 48l-5.2 36.6-44-36.6 49.2 0zm-99.3 0l.6 .5L320 334.6l-42.8-46.1 .6-.5 84.4 0zm-134.5 0l-44 36.6L178.4 288l49.2 0zm159.8 21l48.7 40.5-51.6 54.7-42.7-46L387.5 309zm49.4 151.6l-30.5-32.9 41.5-44-11 76.8zM320 381.7l42.6 45.9L320 472.7l-42.6-45.2L320 381.7zm-21.8-23.5l-42.7 46-51.6-54.7L252.5 309l45.7 49.2zm-64.6 69.5l-30.5 32.9-11-76.8 41.5 44z"]]
}, faObjectsAlignBottom = {
  prefix: "fad",
  iconName: "objects-align-bottom",
  icon: [512, 512, [], "e3bb", ["M64 48l0 288c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48L112 0C85.5 0 64 21.5 64 48zM288 176l0 160c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48z", "M0 488c0 13.3 10.7 24 24 24l464 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 464c-13.3 0-24 10.7-24 24z"]]
}, faV = {
  prefix: "fad",
  iconName: "v",
  icon: [384, 512, [118], "56", ["M19.7 34.5c16.3-6.8 35 .9 41.8 17.2L192 364.8 322.5 51.7c6.8-16.3 25.5-24 41.8-17.2s24 25.5 17.2 41.8l-160 384c-5 11.9-16.6 19.7-29.5 19.7s-24.6-7.8-29.5-19.7L2.5 76.3c-6.8-16.3 .9-35 17.2-41.8z", ""]]
}, faSparkles = {
  prefix: "fad",
  iconName: "sparkles",
  icon: [512, 512, [10024], "f890", ["M320 96c0 4.8 3 9.1 7.5 10.8L384 128l21.2 56.5c1.7 4.5 6 7.5 10.8 7.5s9.1-3 10.8-7.5L448 128l56.5-21.2c4.5-1.7 7.5-6 7.5-10.8s-3-9.1-7.5-10.8L448 64 426.8 7.5C425.1 3 420.8 0 416 0s-9.1 3-10.8 7.5L384 64 327.5 85.2c-4.5 1.7-7.5 6-7.5 10.8zm0 320c0 4.8 3 9.1 7.5 10.8L384 448l21.2 56.5c1.7 4.5 6 7.5 10.8 7.5s9.1-3 10.8-7.5L448 448l56.5-21.2c4.5-1.7 7.5-6 7.5-10.8s-3-9.1-7.5-10.8L448 384l-21.2-56.5c-1.7-4.5-6-7.5-10.8-7.5s-9.1 3-10.8 7.5L384 384l-56.5 21.2c-4.5 1.7-7.5 6-7.5 10.8z", "M205.1 73.3c-2.6-5.7-8.3-9.3-14.5-9.3s-11.9 3.6-14.5 9.3L123.4 187.4 9.3 240C3.6 242.6 0 248.3 0 254.6s3.6 11.9 9.3 14.5l114.1 52.7L176 435.8c2.6 5.7 8.3 9.3 14.5 9.3s11.9-3.6 14.5-9.3l52.7-114.1 114.1-52.7c5.7-2.6 9.3-8.3 9.3-14.5s-3.6-11.9-9.3-14.5L257.8 187.4 205.1 73.3z"]]
}, faSquid = {
  prefix: "fad",
  iconName: "squid",
  icon: [544, 512, [129425], "e450", ["M256.9 16c0-4.1 1.6-8.2 4.6-11.2c3-3.1 7.2-4.8 11.4-4.8c1 0 2.1 .1 3.1 .3L392.7 23.6c-49.9 15.2-90.2 34-122.4 54.7L257.3 19.5c-.3-1.2-.4-2.3-.4-3.5zM434.6 242.5c20.7-32.2 39.4-72.5 54.7-122.4l23.3 116.7c.2 1 .3 2.1 .3 3.1c0 4.3-1.7 8.4-4.8 11.4c-3.9 3.8-9.4 5.4-14.7 4.2l-58.9-13.1z", "M512.7 18.6c.8-5.1-.8-10.3-4.5-13.9S499.4-.6 494.3 .2c-238 39.7-322.1 146.4-334.5 226.5l-14-14-2-2-22.6-22.6c-6.2-6.2-6.2-16.4 0-22.6l56.4-56.4c18.9-18.9 18.7-49.5-.3-68.2L140.1 4.6c-6.3-6.1-16.3-6.1-22.5 .1l-2.8 2.8c-34 34-33.3 87.7-1.9 121L98.5 142.9c-18.7 18.7-18.7 49.1 0 67.9l22.6 22.6c0 0 0 0 0 0l5.7 5.7c0 0 0 0 0 0c9.3 9.4 9.3 24.5 0 33.9c-9.3 9.3-24.4 9.4-33.8 .2L76.5 256.6c-19.1-19.1-50.2-18.7-68.7 .9L4.4 261c-6.1 6.4-5.8 16.5 .6 22.6s16.5 5.8 22.6-.6l3.3-3.5c6.2-6.5 16.6-6.7 22.9-.3l10.6 10.6 .2 .2 22.6 22.6c10.1 10.2 9 26.9-2.4 35.8l-20 15.6c-3.5 2.7-7.7 4.2-12.1 4.2c-10.9 0-19.7-8.8-19.7-19.7l0-12.3c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 12.3C.9 376.8 24.1 400 52.6 400c11.5 0 22.7-3.8 31.8-10.9l28.2-21.9c9.4-7.3 22.8-6.5 31.2 1.9s9.3 21.8 1.9 31.2l-21.9 28.2c-7.1 9.1-10.9 20.3-10.9 31.8c0 28.6 23.2 51.7 51.7 51.7l12.3 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-12.3 0c-10.9 0-19.7-8.8-19.7-19.7c0-4.4 1.5-8.7 4.2-12.1l15.6-20c8.8-11.4 25.6-12.4 35.8-2.3l.1 .1L223 448.3l.1 .1 9.9 9.9c6.5 6.5 6.2 17.2-.7 23.3l-2.8 2.5c-6.6 5.9-7.2 16-1.3 22.6s16 7.2 22.6 1.3l2.8-2.5c20.7-18.3 21.6-50.3 2.1-69.8l-9.9-9.9-5.7-5.7-.1-.1c-9.2-9.3-9.2-24.4 0-33.8l.1-.1 .1-.1c9.3-9.2 24.4-9.2 33.7 0l28.4 28.4c18.7 18.7 49.1 18.7 67.9 0L384.4 400c33.3 31.4 87 32.1 121-1.9l2.8-2.8c6.2-6.2 6.3-16.3 .1-22.5L472 335.7c-18.7-19-49.3-19.2-68.2-.3l-56.4 56.4c-6.2 6.2-16.4 6.2-22.6 0l-22.5-22.5-.1-.1-16-16C366.3 340.8 473 256.6 512.7 18.6zM168.9 280a16 16 0 1 1 32 0 16 16 0 1 1 -32 0zm64 32a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]]
}, faLeafyGreen = {
  prefix: "fad",
  iconName: "leafy-green",
  icon: [576, 512, [129388], "e41d", ["M0 170.7c0 12.5 2.8 25.1 8.5 36.6c5.7 11.7 11 24.1 11 37.1l0 35.7c0 14.7 5.8 28.8 16.3 39.2l26.3 26.3c10.4 10.4 16.3 24.5 16.3 39.2l0 12.9c0 14.5 5.7 28.5 15.8 38.8c5-5 10.1-10.1 15.1-15.1c12-12 18.7-28.3 18.7-45.3l0-45.7c0-17 6.7-33.3 18.7-45.3l10.5-10.5c12-12 18.7-28.3 18.7-45.3l0-43c0-17 6.7-33.3 18.7-45.3l29.1-29.1c10.7-10.7 16.4-25 21.3-39.3c.3-.8 .6-1.7 .9-2.5s.6-1.6 1-2.5c.7-1.6 1.4-3.2 2.1-4.8c1.5-3.2 3.1-6.2 5-9.2c-1.3-2-2.6-4.1-3.9-6.2c-4.1-6.9-9.1-13.4-15-19.3C216.3 9.5 191.4 0 166.6 0s-49.7 9.5-68.7 28.4C92 34.4 87 40.8 83 47.7C70 69.6 50.6 89.9 30.9 105.9c-2.3 1.8-4.4 3.8-6.5 5.9C8.1 128.1 0 149.4 0 170.7zm228.7 154c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l48-48L358.6 240l89.4 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-57.4 0 84.7-84.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-112 112L304 249.4l0-57.4c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 89.4-43.3 43.3z", "M572.5 140c-7.3 28.4-8.1 60.8-5 89.9c.3 3.3 .5 6.7 .5 10.1c0 42.1-27.1 77.9-64.9 90.8c-14.3 4.9-28.6 10.6-39.3 21.3l-29.1 29.1c-12 12-28.3 18.7-45.3 18.7l-43 0c-17 0-33.3 6.7-45.3 18.7l-10.5 10.5c-12 12-28.3 18.7-45.3 18.7l-45.7 0c-17 0-33.3 6.7-45.3 18.7l-35.9 35.9c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l35.9-35.9c12-12 18.7-28.3 18.7-45.3l0-45.7c0-17 6.7-33.3 18.7-45.3l10.5-10.5c12-12 18.7-28.3 18.7-45.3l0-43c0-17 6.7-33.3 18.7-45.3l29.1-29.1c10.7-10.7 16.4-25 21.3-39.3C258.1 35.1 293.9 8 336 8c3.4 0 6.8 .2 10.1 .5c29.1 3.1 61.5 2.3 89.9-5C445 1.2 454.3 0 464 0c61.9 0 112 50.1 112 112c0 9.7-1.2 19-3.5 28zm-97.2-16.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-112 112L304 249.4l0-57.4c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 89.4-43.3 43.3c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l48-48L358.6 240l89.4 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-57.4 0 84.7-84.7z"]]
}, faCircleArrowUpRight = {
  prefix: "fad",
  iconName: "circle-arrow-up-right",
  icon: [512, 512, [], "e0fc", ["M512 256A256 256 0 1 1 0 256a256 256 0 1 1 512 0zM144 344c0 6.1 2.3 12.3 7 17s10.8 7 17 7s12.3-2.3 17-7l135-135 0 94.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-152c0-13.3-10.7-24-24-24l-160 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l102.1 0L151 327c-4.7 4.7-7 10.8-7 17z", "M368 168l0 152c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-94.1L185 361c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l135-135L184 192c-13.3 0-24-10.7-24-24s10.7-24 24-24l160 0c13.3 0 24 10.7 24 24z"]]
}, faCalendars = {
  prefix: "fad",
  iconName: "calendars",
  icon: [512, 512, [], "e0d7", ["M96 192l416 0 0 176c0 26.5-21.5 48-48 48l-320 0c-26.5 0-48-21.5-48-48l0-176z", "M224 0c-17.7 0-32 14.3-32 32l0 32-48 0c-26.5 0-48 21.5-48 48l0 80 416 0 0-80c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32-96 0 0-32c0-17.7-14.3-32-32-32zM48 184c0-13.3-10.7-24-24-24s-24 10.7-24 24L0 392c0 66.3 53.7 120 120 120l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-272 0c-39.8 0-72-32.2-72-72l0-208z"]]
}, faBangladeshiTakaSign = {
  prefix: "fad",
  iconName: "bangladeshi-taka-sign",
  icon: [384, 512, [], "e2e6", ["M0 192c0 17.7 14.3 32 32 32l32 0 0-64-32 0c-17.7 0-32 14.3-32 32zm128-32l0 64 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0z", "M.2 60C2.4 42.5 18.4 30.1 36 32.3l7.9 1c48 6 84.1 46.8 84.1 95.3L128 384c0 17.7 14.3 32 32 32l32 0c70.7 0 128-57.3 128-128l0-32c0-17.7-14.3-32-32-32l-16 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0c53 0 96 43 96 96l0 32c0 106-86 192-192 192l-32 0c-53 0-96-43-96-96l0-255.5c0-16.1-12-29.8-28-31.8l-7.9-1C10.5 93.6-1.9 77.6 .2 60z"]]
}, faBicycle = {
  prefix: "fad",
  iconName: "bicycle",
  icon: [640, 512, [128690], "f206", ["M0 352c0 70.7 57.3 128 128 128c65.3 0 119.1-48.9 127-112l-56.8 0c-7.3 32.1-36 56-70.2 56c-39.8 0-72-32.2-72-72s32.2-72 72-72c1.7 0 3.4 .1 5.1 .2l26.2-52.3c-10-2.5-20.5-3.8-31.2-3.8C57.3 224 0 281.3 0 352zm384 0c0 70.7 57.3 128 128 128s128-57.3 128-128s-57.3-128-128-128c-13.5 0-26.5 2.1-38.7 6c9.2 17 18.3 33.9 27.5 50.9c3.6-.6 7.4-.9 11.2-.9c39.8 0 72 32.2 72 72s-32.2 72-72 72s-72-32.2-72-72c0-18.6 7-35.5 18.6-48.3c-9.2-17-18.3-33.9-27.5-50.9C402.4 276.3 384 312 384 352z", "M312 32c-13.3 0-24 10.7-24 24s10.7 24 24 24l25.7 0 34.6 64-149.4 0-27.4-38C191 99.7 183.7 96 176 96l-56 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l43.7 0 22.1 30.7-77 153.9c-9 18.1 4.1 39.4 24.3 39.4L304 368c8.5 0 16.3-4.5 20.7-11.8l84.8-143.5 81.4 150.7c6.3 11.7 20.9 16 32.5 9.7s16-20.9 9.7-32.5L375.4 48.8C369.8 38.4 359 32 347.2 32L312 32zM166.8 320l50.7-101.3 72.9 101.2-.1 .1-123.5 0zm90.6-128l108.5 0L317 274.8 257.4 192z"]]
}, faHammerWar = {
  prefix: "fad",
  iconName: "hammer-war",
  icon: [384, 512, [], "f6e4", ["M160 32l0 18.8c9.1 1.4 18.2 2.7 27.3 4.1c3.1 .5 6.3 .5 9.5 0c9.1-1.4 18.2-2.7 27.3-4.1L224 32c0-17.7-14.3-32-32-32s-32 14.3-32 32zm0 237.2L160 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.8c-9.1-1.4-18.2-2.7-27.3-4.1c-3.1-.5-6.3-.5-9.5 0c-9.1 1.4-18.2 2.7-27.3 4.1z", "M36.7 32.4c-9.2-1.4-18.6 1.3-25.6 7.4S0 54.7 0 64L0 256c0 9.3 4.1 18.2 11.1 24.2s16.4 8.8 25.6 7.4l150.5-22.6c3.1-.5 6.3-.5 9.5 0l150.5 22.6c9.2 1.4 18.6-1.3 25.6-7.4s11.1-14.9 11.1-24.2l0-192c0-9.3-4.1-18.2-11.1-24.2s-16.4-8.8-25.6-7.4L196.7 54.9c-3.1 .5-6.3 .5-9.5 0L36.7 32.4z"]]
}, faCircleD = {
  prefix: "fad",
  iconName: "circle-d",
  icon: [512, 512, [], "e104", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM160 152c0-13.3 10.7-24 24-24l72 0c70.7 0 128 57.3 128 128s-57.3 128-128 128l-72 0c-13.3 0-24-10.7-24-24l0-208zm48 24l0 160 48 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0z", "M160 152c0-13.3 10.7-24 24-24l72 0c70.7 0 128 57.3 128 128s-57.3 128-128 128l-72 0c-13.3 0-24-10.7-24-24l0-208zm48 24l0 160 48 0c44.2 0 80-35.8 80-80s-35.8-80-80-80l-48 0z"]]
}, faSpiderBlackWidow = {
  prefix: "fad",
  iconName: "spider-black-widow",
  icon: [512, 512, [], "f718", ["M81.1 100c-7.9 20.7-3 44.1 12.7 59.7l57.4 57.4c8.3 2.8 16.6 5.5 24.9 8.3c0-17.1 0-34.2 0-51.3l-48.3-48.3c-2.2-2.2-2.9-5.6-1.8-8.5l32.5-84.6c4.8-12.4-1.4-26.3-13.8-31s-26.3 1.4-31 13.8L81.1 100zM216 300c0 2.6 .8 5.1 2.4 7.2c7.2 9.6 14.4 19.2 21.6 28.8l-21.6 28.8c-1.6 2.1-2.4 4.6-2.4 7.2c0 6.6 5.4 12 12 12l56 0c3.3 0 6.3-1.3 8.5-3.5c1.1-1.1 2-2.4 2.6-3.8c.3-.7 .5-1.5 .7-2.2c.1-.4 .1-.8 .2-1.2c0-.3 .1-.7 .1-1.1c0-.6 0-.9 0-1.1c0-.3-.1-.6-.1-1c-.1-.6-.3-1.3-.5-1.9c-.4-1.2-1-2.4-1.8-3.4c-7.2-9.6-14.4-19.2-21.6-28.8c7.2-9.6 14.4-19.2 21.6-28.8c.8-1 1.4-2.2 1.8-3.4c.2-.6 .4-1.2 .5-1.9c.1-.3 .1-.6 .1-1c0-.2 0-.5 0-.8c0-.7 0-1.1-.1-1.4c0-.4-.1-.8-.2-1.2c-.2-.8-.4-1.5-.7-2.2c-.6-1.4-1.5-2.7-2.6-3.8c-2.2-2.2-5.2-3.5-8.5-3.5l-56 0c-6.6 0-12 5.4-12 12zM336 174.1l0 51.3 24.9-8.3 57.4-57.4c10.7-10.7 16.4-25 16.4-39.6c0-6.8-1.2-13.6-3.7-20.1L398.4 15.4C394.7 5.8 385.6 0 376 0c-2.9 0-5.8 .5-8.6 1.6c-12.4 4.8-18.5 18.6-13.8 31l32.5 84.6c1.1 3 .4 6.3-1.8 8.5L336 174.1z", "M240 101.2c0-10.1-9.4-17.7-18.5-13.4C194.6 100.7 176 128.2 176 160l0 65.4L70.8 190.3c-2.4-.8-4.3-2.7-5.1-5.1L46.8 128.4C42.6 115.8 29 109 16.4 113.2S-3 131 1.2 143.6l18.9 56.8c5.6 16.7 18.7 29.8 35.4 35.4L116.1 256 55.6 276.2c-16.7 5.6-29.8 18.7-35.4 35.4L1.2 368.4C-3 381 3.8 394.6 16.4 398.8s26.2-2.6 30.4-15.2l18.9-56.8c.8-2.4 2.7-4.3 5.1-5.1l80.4-26.8L93.7 352.3C78.1 368 73.1 391.4 81.1 412l32.5 84.6c4.8 12.4 18.6 18.5 31 13.8s18.5-18.6 13.8-31l-32.5-84.6c-1.1-3-.4-6.3 1.8-8.5L160 353.9c1 52.1 43.6 94.1 96 94.1s95-41.9 96-94.1l32.3 32.3c2.2 2.2 2.9 5.6 1.8 8.5l-32.5 84.6c-4.8 12.4 1.4 26.3 13.8 31s26.3-1.4 31-13.8L430.9 412c7.9-20.7 3-44.1-12.7-59.7l-57.4-57.4 80.4 26.8c2.4 .8 4.3 2.7 5.1 5.1l18.9 56.8c4.2 12.6 17.8 19.4 30.4 15.2s19.4-17.8 15.2-30.4l-18.9-56.8c-5.6-16.7-18.7-29.8-35.4-35.4L395.9 256l60.5-20.2c16.7-5.6 29.8-18.7 35.4-35.4l18.9-56.8c4.2-12.6-2.6-26.2-15.2-30.4s-26.2 2.6-30.4 15.2l-18.9 56.8c-.8 2.4-2.7 4.3-5.1 5.1L336 225.4l0-65.4c0-31.8-18.6-59.3-45.5-72.2c-9.1-4.4-18.5 3.3-18.5 13.4l0 10.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-10.8zm-21.6 206c-1.6-2.1-2.4-4.6-2.4-7.2c0-6.6 5.4-12 12-12l56 0c6.6 0 12 5.4 12 12c0 2.6-.8 5.1-2.4 7.2L272 336l21.6 28.8c1.6 2.1 2.4 4.6 2.4 7.2c0 6.6-5.4 12-12 12l-56 0c-6.6 0-12-5.4-12-12c0-2.6 .8-5.1 2.4-7.2L240 336l-21.6-28.8z"]]
}, faStaffSnake = {
  prefix: "fad",
  iconName: "staff-snake",
  icon: [384, 512, ["rod-asclepius", "rod-snake", "staff-aesculapius"], "e579", ["M0 104c0 30.9 25.1 56 56 56l16 0c22.3 0 41.6-13.1 50.6-32l41.4 0 56 0 68 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-69 0-2.5 80 71.5 0c53 0 96-43 96-96s-43-96-96-96l-65.5 0-61 0L72 48l-8 0-8 0C25.1 48 0 73.1 0 104zm80-8A16 16 0 1 1 48 96a16 16 0 1 1 32 0zM56 256c0 53 43 96 96 96l19 0 42 0 43 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-44 0-2.1 67.5-.4 12.5 46.5 0c53 0 96-43 96-96s-43-96-96-96l-40.5 0-47 0L152 272c-8.8 0-16-7.2-16-16s7.2-16 16-16l15.5 0L165 160l-13 0c-53 0-96 43-96 96zM96 424c0 22.1 17.9 40 40 40l38.5 0c-.1-4.2-.3-8.3-.4-12.5c-.7-22.5-1.4-45-2.1-67.5l-36 0c-22.1 0-40 17.9-40 40z", "M222.6 43.2L223 32c0-.7 0-1.3 0-1.9c-.5-16.6-14.1-30-31-30s-30.5 13.4-31 30c0 .6 0 1.3 0 1.9l.4 11.2 .1 4.8 61 0 .1-4.8zM215.5 272L220 128l-56 0 4.5 144 47 0zM213 352l-42 0 3.1 99.5 1.4 43.5 0 1c.3 8.9 7.6 16 16.5 16s16.2-7.1 16.5-16l0-1 1.4-43.5L213 352z"]]
}, faRodAsclepius = faStaffSnake, faRodSnake = faStaffSnake, faStaffAesculapius = faStaffSnake, faPear = {
  prefix: "fad",
  iconName: "pear",
  icon: [512, 512, [], "e20c", ["M0 320c0 49.1 18.7 98.3 56.2 135.8c75 75 196.5 75 271.5 0c25.1-25.1 41.8-55.3 50.1-87.3c11.8-45.7 43.4-90.9 73.3-127.4c18-22.1 28.9-50.3 28.9-81c0-26.7-8.2-51.4-22.1-71.9C446.9 99 435.9 110 425 121c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7s-7-10.8-7-17s2.3-12.3 7-17c11-11 21.9-21.9 32.9-32.9C403.4 40.2 378.7 32 352 32c-30.7 0-58.9 10.8-81 28.9c-36.5 29.9-81.8 61.4-127.4 73.3c-32 8.3-62.3 25-87.3 50.1C18.7 221.7 0 270.9 0 320zM176 432c0-8.8 7.2-16 16-16c53 0 96-43 96-96c0-8.8 7.2-16 16-16s16 7.2 16 16c0 70.7-57.3 128-128 128c-8.8 0-16-7.2-16-16z", "M505 7c9.4 9.4 9.4 24.6 0 33.9l-80 80c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L471 7c9.4-9.4 24.6-9.4 33.9 0z"]]
}, faHeadSideCoughSlash = {
  prefix: "fad",
  iconName: "head-side-cough-slash",
  icon: [640, 512, [], "e062", ["M0 224.2c0-38.7 9.8-75.1 27.1-106.9L341.8 365.3l-2.5 .3c-11 1.4-19.2 10.7-19.2 21.8c0 11.6 9 21.2 20.6 21.9l62 3.9 43 33.9C439.3 466.2 421.2 480 400 480l-80 0 0 8c0 13.3-10.7 24-24 24c-13.3 0-26.7 0-40 0L96 512c-17.7 0-32-14.3-32-32l0-72.7c0-16.7-6.9-32.5-17.1-45.8C16.6 322.4 0 274.1 0 224.2zM89.6 44.9C127 16.7 173.5 0 224 0l24 0c95.2 0 181.2 69.3 197.3 160.2c2.3 13 6.8 25.7 15.1 36l42 52.6c6.2 7.8 9.6 17.4 9.6 27.4c0 24.2-19.6 43.8-43.8 43.8c-6.7 0-13.4 0-20.2 0l0 5.8C328.5 232.2 209 138.5 89.6 44.9zM576 336a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm64-48a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 96a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faFileMov = {
  prefix: "fad",
  iconName: "file-mov",
  icon: [512, 512, [], "e647", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-240 0c-35.3 0-64 28.7-64 64l0 144-16 0c-35.3 0-64-28.7-64-64L0 64z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM157.7 359.8c-3.7-6.2-11.1-9.1-18-7.2s-11.7 8.2-11.7 15.4l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-70.2 18.3 30.5c2.9 4.8 8.1 7.8 13.7 7.8s10.8-3 13.7-7.8L224 425.8l0 70.2c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128c0-7.2-4.8-13.5-11.7-15.4s-14.3 1-18 7.2L192 416.9l-34.3-57.1zM448 368c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 31.6c0 34.7 10.3 68.7 29.6 97.6l5.1 7.7c3 4.5 8 7.1 13.3 7.1s10.3-2.7 13.3-7.1l5.1-7.7c19.3-28.9 29.6-62.9 29.6-97.6l0-31.6c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 31.6c0 23-5.5 45.6-16 66c-10.5-20.3-16-42.9-16-66l0-31.6zM288 392l0 80c0 22.1 17.9 40 40 40l16 0c22.1 0 40-17.9 40-40l0-80c0-22.1-17.9-40-40-40l-16 0c-22.1 0-40 17.9-40 40zm40-8l16 0c4.4 0 8 3.6 8 8l0 80c0 4.4-3.6 8-8 8l-16 0c-4.4 0-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8z"]]
}, faTriangle = {
  prefix: "fad",
  iconName: "triangle",
  icon: [512, 512, [9650], "f2ec", ["M290.5 51.8C283.3 39.5 270.2 32 256 32s-27.3 7.5-34.5 19.8l-216 368c-7.3 12.4-7.3 27.7-.2 40.1S25.7 480 40 480l432 0c14.3 0 27.6-7.7 34.7-20.1s7-27.8-.2-40.1l-216-368z", ""]]
}, faApartment = {
  prefix: "fad",
  iconName: "apartment",
  icon: [576, 512, [], "e468", ["M0 144L0 464c0 26.5 21.5 48 48 48l80 0 32 0 96 0 0-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96 96 0 32 0 80 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48l-80 0 0-144c0-26.5-21.5-48-48-48L176 0c-26.5 0-48 21.5-48 48l0 48L48 96C21.5 96 0 117.5 0 144zm64 32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM192 80c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM320 80c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm128 0c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32z", "M384 80c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32zM112 320c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zm272-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zm128 96l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zm-384 0l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zm112-80c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zm0-256l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16zM384 208l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zM496 320c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zM128 208l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zm112 16c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0z"]]
}, faTruckMedical = {
  prefix: "fad",
  iconName: "truck-medical",
  icon: [640, 512, [128657, "ambulance"], "f0f9", ["M96 432a80 80 0 1 0 160 0A80 80 0 1 0 96 432zm16-288l0 32c0 8.8 7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16zM384 432a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M0 48C0 21.5 21.5 0 48 0L368 0c26.5 0 48 21.5 48 48l0 48 50.7 0c17 0 33.3 6.7 45.3 18.7L589.3 192c12 12 18.7 28.3 18.7 45.3l0 18.7 0 32 0 64c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0-1.1 0c-7.8-54.3-54.4-96-110.9-96s-103.1 41.7-110.9 96l-66.3 0c-7.8-54.3-54.4-96-110.9-96s-103.1 41.7-110.9 96L48 416c-26.5 0-48-21.5-48-48L0 48zM416 256l128 0 0-18.7L466.7 160 416 160l0 96zM176 80l0 48-48 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z"]]
}, faAmbulance = faTruckMedical, faPepper = {
  prefix: "fad",
  iconName: "pepper",
  icon: [512, 512, [129745], "e432", ["M2.9 215.3l56 224c12.9 51.4 65 82.7 116.4 69.8c7-1.7 13.6-4.2 19.8-7.3c5.6-2.8 12.3-2.8 17.9 0c3 1.5 6 2.8 9.2 4c10.7 4 22.2 6.2 34 6.2c11.6 0 22.9-2.1 33.5-6.1c3.2-1.2 6.4-2.6 9.4-4.1c5.6-2.8 12.3-2.8 17.9 0c6.2 3.1 12.8 5.6 19.8 7.3c51.4 12.9 103.6-18.4 116.4-69.8l56-224c2-7.8 2.9-15.6 2.9-23.4c0-43-29.1-82.2-72.7-93.1c-23.2-5.8-46.5-2.6-66.3 7.3c-5.6 2.8-12.3 2.8-17.9 0c-6.2-3.1-12.8-5.6-19.8-7.3c-19-4.8-38.1-3.5-55.3 2.6c-4.9 1.8-9.7 3.9-14.3 6.4c-6 3.3-13.4 3.3-19.4 0c-4.6-2.5-9.4-4.7-14.3-6.4c-5-1.8-10.1-3.1-15.3-4c-.3-.1-.6-.1-.9-.2c-8.8-1.5-17.9-1.7-27.1-.6c-4 .5-7.9 1.2-11.9 2.2c-51.4 12.9-74.7 65-61.9 116.4l37.1 148.3c2.1 8.6-3.1 17.3-11.6 19.4s-17.3-3.1-19.4-11.6L83.8 223c-11.8-47 .4-94.4 31.3-125.2c-6.2-1.3-12.6-1.9-19-1.9c-7.7 0-15.5 .9-23.4 2.9C21.3 111.7-10 163.8 2.9 215.3z", "M252.6 11.7C245.8 .3 231-3.4 219.7 3.4s-15.1 21.6-8.2 32.9l10.3 17.2c6.7 11.2 10.3 24 10.3 37l0 10.9c4.9 1.8 9.7 3.9 14.3 6.4c6 3.3 13.4 3.3 19.4 0c4.6-2.5 9.4-4.7 14.3-6.4l0-10.9c0-21.7-5.9-43.1-17.1-61.7L252.6 11.7z"]]
}, faPiano = {
  prefix: "fad",
  iconName: "piano",
  icon: [512, 512, [], "f8d4", ["M0 352l0 96c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-96-64 0 0 96L64 448l0-96L0 352z", "M0 192L0 352l96 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 32 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 32 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 64 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 32 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 96 0 0-24.4c0-24.2-13.7-46.4-35.4-57.2l-58.4-29.2c-21-10.5-34.2-31.9-34.2-55.4C384 83.2 300.8 0 198.3 0L192 0C86 0 0 86 0 192z"]]
}, faGunSquirt = {
  prefix: "fad",
  iconName: "gun-squirt",
  icon: [576, 512, [], "e19d", ["M64 160c0 17.7 14.3 32 32 32l352 0c17.7 0 32-14.3 32-32L64 160zM219 376l53 0 0 16c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 16-41 0-12 48z", "M104 32c13.3 0 24 10.7 24 24l0 8 320 0c41.8 0 77.4 26.7 90.5 64l13.5 0c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24l-13.5 0c-13.2 37.3-48.7 64-90.5 64l-199 0L199 455.8C195.5 470 182.7 480 168 480L64 480c-9.9 0-19.2-4.5-25.2-12.3s-8.2-17.9-5.8-27.5L79.4 254.6C34.3 246.7 0 207.3 0 160c0-47.6 34.6-87.1 80-94.7L80 56c0-13.3 10.7-24 24-24zm-8 96c-17.7 0-32 14.3-32 32s14.3 32 32 32l352 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 128z"]]
}, faWheatAwnCircleExclamation = {
  prefix: "fad",
  iconName: "wheat-awn-circle-exclamation",
  icon: [640, 512, [], "e598", ["M0 480c0 8.2 3.1 16.4 9.4 22.6s14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4l68.9-68.9 12.2 12.2c37.5 37.5 98.3 37.5 135.8 0l22.6-22.6-22.6-22.6c-21.8-21.8-49.6-34.1-78.1-36.9l31.9-31.9 12.2 12.2c22.5 22.5 53.3 31.5 82.4 27c0-1 0-2.1 0-3.1c0-33.1 9.1-64.1 25-90.6c-15.5-8.7-32.5-13.8-49.8-15.5l31.9-31.9 12.2 12.2c6 6 12.6 11.1 19.7 15.2c27.5-34 67.3-57.5 112.6-63.8c-4.1-3.8-8.4-7.3-12.9-10.5L505 137c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-59.4 59.4c-20.6-4.4-42-3.7-62.3 2.1c6.1-21.3 6.6-43.8 1.4-65.3L409 41c9.4-9.4 9.4-24.6 0-33.9c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7L329.1 52.9c-3.7-5-7.8-9.8-12.4-14.3L294.2 16 271.5 38.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8l-22.6-22.6-22.6 22.6c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4-30.5 30.5c-3.4-27.3-15.5-53.8-36.5-74.8L90.5 219.6 67.9 242.3c-37.5 37.5-37.5 98.3 0 135.8l10.4 10.4L9.4 457.4C3.1 463.6 0 471.8 0 480zM383 95c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l88-88c9.4-9.4 9.4-24.6 0-33.9c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7L383 95z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80z"]]
}, faSnowman = {
  prefix: "fad",
  iconName: "snowman",
  icon: [512, 512, [9731, 9924], "f7d0", ["M96 384c0 44.7 18.3 85 47.8 114.1c9.9 9.7 23.7 13.9 37.5 13.9l149.3 0c13.9 0 27.7-4.2 37.5-13.9C397.7 469 416 428.7 416 384c0-45.8-19.3-87.1-50.1-116.3c-2.9-2.8-4-6.9-2.8-10.8c2.7-8.7 4.3-17.9 4.8-27.3c.1-1.9 .1-3.7 .1-5.6c0-15.2-3-29.8-8.6-43c-4.3-10.3-10.1-19.9-17.2-28.4c-2.8-3.4-3.3-8.1-1.2-12C348 127.2 352 112.1 352 96c0-53-43-96-96-96s-96 43-96 96c0 16.1 4 31.2 10.9 44.6c2 3.9 1.6 8.6-1.2 12c-7 8.5-12.9 18.1-17.2 28.4c-5.5 13.2-8.6 27.8-8.6 43c0 1.9 0 3.7 .1 5.6c.5 9.5 2.1 18.6 4.8 27.3c1.2 3.8 .1 8-2.8 10.8C115.3 296.9 96 338.2 96 384zM208 80c0-8.8 7.2-16 16-16c4.4 0 8.4 1.8 11.3 4.7c1.4 1.4 2.6 3.2 3.4 5.1c.4 1 .7 2 .9 3c.1 .5 .2 1.1 .2 1.6s.1 1 .1 1.8c0 .5 0 1-.1 1.5c-.1 .5-.1 1.1-.2 1.6c-.2 1-.5 2-.9 3c-.8 1.9-2 3.6-3.4 5.1c-2.9 2.9-6.9 4.7-11.3 4.7c-8.8 0-16-7.2-16-16zm32 40c0-8.8 7.2-16 16-16s16 7.2 16 16l0 3.2c0 3.2-.8 6.3-2.3 9l-9 16.9c-.9 1.7-2.7 2.8-4.7 2.8s-3.8-1.1-4.7-2.8l-9-16.9c-1.5-2.8-2.3-5.9-2.3-9l0-3.2zm0 104c0-8.8 7.2-16 16-16c4.4 0 8.4 1.8 11.3 4.7c1.4 1.4 2.6 3.2 3.4 5.1c.4 1 .7 2 .9 3c.1 .5 .2 1.1 .2 1.6c0 .5 .1 .9 .1 1.8c0 .6 0 1.1-.1 1.5c-.1 .5-.1 1.1-.2 1.6c-.2 1-.5 2-.9 3c-.8 1.9-2 3.6-3.4 5.1c-2.9 2.9-6.9 4.7-11.3 4.7c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16c4.4 0 8.4 1.8 11.3 4.7c1.4 1.4 2.6 3.2 3.4 5.1c.4 1 .7 2 .9 3c.1 .5 .2 1.1 .2 1.6s.1 1 .1 1.8c0 .5 0 1-.1 1.5c-.1 .5-.1 1.1-.2 1.6c-.2 1-.5 2-.9 3c-.8 1.9-2 3.6-3.4 5.1c-2.9 2.9-6.9 4.7-11.3 4.7c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16c4.4 0 8.4 1.8 11.3 4.7c1.4 1.4 2.6 3.2 3.4 5.1c.4 1 .7 2 .9 3c.1 .5 .2 1.1 .2 1.6s.1 1 .1 1.8c0 .5 0 1-.1 1.5c-.1 .5-.1 1.1-.2 1.6c-.2 1-.5 2-.9 3c-.8 1.9-2 3.6-3.4 5.1c-2.9 2.9-6.9 4.7-11.3 4.7c-8.8 0-16-7.2-16-16zM272 80c0-8.8 7.2-16 16-16c4.4 0 8.4 1.8 11.3 4.7c1.4 1.4 2.6 3.2 3.4 5.1c.4 1 .7 2 .9 3c.1 .5 .2 1.1 .2 1.6s.1 1 .1 1.8c0 .5 0 1-.1 1.5c-.1 .5-.1 1.1-.2 1.6c-.2 1-.5 2-.9 3c-.8 1.9-2 3.6-3.4 5.1c-2.9 2.9-6.9 4.7-11.3 4.7c-8.8 0-16-7.2-16-16z", "M224 96a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm32 144a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm16 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm-16 80a16 16 0 1 0 0-32 16 16 0 1 0 0 32zM304 80a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM80 96c-13.3 0-24 10.7-24 24l0 19.6-22.5-9.7c-12.2-5.2-26.3 .4-31.5 12.6s.4 26.3 12.6 31.5l56 24 73.6 31.5c-.1-1.9-.1-3.7-.1-5.6c0-15.2 3-29.8 8.6-43L104 160.2l0-40.2c0-13.3-10.7-24-24-24zM368 224c0 1.9 0 3.7-.1 5.6l73.6-31.5 56-24c12.2-5.2 17.8-19.3 12.6-31.5s-19.3-17.8-31.5-12.6L456 139.6l0-19.6c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40.2L359.4 181c5.5 13.2 8.6 27.8 8.6 43z"]]
}, faUserAlien = {
  prefix: "fad",
  iconName: "user-alien",
  icon: [448, 512, [], "e04a", ["M0 486.4C0 415 55.7 356.6 126.1 352.3c23.8 23.2 46.1 40.2 58.5 49.1c12 8.6 25.9 12.4 39.4 12.4s27.4-3.8 39.4-12.4c12.4-8.8 34.7-25.8 58.5-49.1C392.3 356.6 448 415 448 486.4c0 14.1-11.5 25.6-25.6 25.6L25.6 512C11.5 512 0 500.5 0 486.4zM64 167C64 74.8 135.6 0 224 0s160 74.8 160 167c0 101-106.6 185-139.2 208.3c-6.1 4.3-13.4 6.5-20.8 6.5s-14.7-2.1-20.8-6.5C170.6 352 64 268.1 64 167zm48 20.4c0 37.9 30.7 68.6 68.6 68.6l16 0c6.3 0 11.4-5.1 11.4-11.4c0-37.9-30.7-68.6-68.6-68.6l-16 0c-6.3 0-11.4 5.1-11.4 11.4zm128 57.1c0 6.3 5.1 11.4 11.4 11.4l16 0c37.9 0 68.6-30.7 68.6-68.6c0-6.3-5.1-11.4-11.4-11.4l-16 0c-37.9 0-68.6 30.7-68.6 68.6z", "M139.4 176c37.9 0 68.6 30.7 68.6 68.6c0 6.3-5.1 11.4-11.4 11.4l-16 0c-37.9 0-68.6-30.7-68.6-68.6c0-6.3 5.1-11.4 11.4-11.4l16 0zm169.1 0l16 0c6.3 0 11.4 5.1 11.4 11.4c0 37.9-30.7 68.6-68.6 68.6l-16 0c-6.3 0-11.4-5.1-11.4-11.4c0-37.9 30.7-68.6 68.6-68.6z"]]
}, faShieldCheck = {
  prefix: "fad",
  iconName: "shield-check",
  icon: [512, 512, [], "f2f7", ["M16 139.7c.5 99.5 41.3 281 213.6 363.5c16.7 8 36.1 8 52.8 0C454.7 420.7 495.5 239.2 496 140c0-26.4-16.4-47.9-38.3-57.2L269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8C32.4 92.1 16 113.6 16 139.7zM136 256c0-6.1 2.3-12.3 7-17c9.4-9.4 24.6-9.4 33.9 0l47 47c37-37 74-74 111-111c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c2.3 2.3 4.1 5 5.3 7.9c.6 1.4 1 2.9 1.3 4.4c.2 1.1 .3 2.2 .3 2.2c.1 1.2 .1 1.2 .1 2.5c-.1 1.5-.1 1.9-.1 2.3c-.1 .7-.2 1.5-.3 2.2c-.3 1.5-.7 3-1.3 4.4c-1.2 2.9-2.9 5.6-5.3 7.9c-42.7 42.7-85.3 85.3-128 128c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7c-21.3-21.3-42.7-42.7-64-64c-4.7-4.7-7-10.8-7-17z", "M369 175c9.4 9.4 9.4 24.6 0 33.9L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0z"]]
}, faMortarPestle = {
  prefix: "fad",
  iconName: "mortar-pestle",
  icon: [512, 512, [], "f5a7", ["M209.3 192c52 0 103.9 0 155.9 0L502.6 54.6c11.8-11.8 12.6-30.8 1.6-43.5S474.5-3.7 461 6.2L213.7 188.5c-1.5 1.1-3 2.3-4.4 3.5z", "M0 224c0-17.7 14.3-32 32-32l448 0c17.7 0 32 14.3 32 32s-14.3 32-32 32c0 82.5-43.4 147.7-123.9 176.2c11.1 13.9 19.4 30.3 23.9 48.1c4.4 17.1-10.4 31.7-28.1 31.7l-192 0c-17.7 0-32.4-14.6-28.1-31.7c4.5-17.8 12.8-34.1 23.9-48.1C75.4 403.7 32 338.5 32 256c-17.7 0-32-14.3-32-32z"]]
}, faRoadBarrier = {
  prefix: "fad",
  iconName: "road-barrier",
  icon: [640, 512, [], "e562", ["M64 96l85.2 0L64 266.3 64 96zm42.8 192l90.6-181.3L202.8 96l74.3 0L186.5 277.3 181.2 288l-74.3 0zm128 0l90.6-181.3L330.8 96l74.3 0L314.5 277.3 309.2 288l-74.3 0zm128 0l90.6-181.3L458.8 96l74.3 0L442.5 277.3 437.2 288l-74.3 0zm128 0L576 117.7 576 288l-85.2 0z", "M64 64c0-17.7-14.3-32-32-32S0 46.3 0 64L0 448c0 17.7 14.3 32 32 32s32-14.3 32-32L64 64zm576 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 384c0 17.7 14.3 32 32 32s32-14.3 32-32l0-384z"]]
}, faChartCandlestick = {
  prefix: "fad",
  iconName: "chart-candlestick",
  icon: [512, 512, [], "e0e2", ["M0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64c0-17.7-14.3-32-32-32S0 46.3 0 64z", "M304 32c8.8 0 16 7.2 16 16l0 48c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48c-17.7 0-32-14.3-32-32l0-96c0-17.7 14.3-32 32-32l0-48c0-8.8 7.2-16 16-16zM416 192l0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32zM128 160c0-17.7 14.3-32 32-32l0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l0 48c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-48c-17.7 0-32-14.3-32-32l0-128z"]]
}, faBriefcaseBlank = {
  prefix: "fad",
  iconName: "briefcase-blank",
  icon: [512, 512, [], "e0c8", ["M128 56l0 40 48 0 0-40c0-4.4 3.6-8 8-8l144 0c4.4 0 8 3.6 8 8l0 40 48 0 0-40c0-30.9-25.1-56-56-56L184 0c-30.9 0-56 25.1-56 56z", "M64 96C28.7 96 0 124.7 0 160L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 96z"]]
}, faSchool = {
  prefix: "fad",
  iconName: "school",
  icon: [640, 512, [127979], "f549", ["M0 144L0 464c0 26.5 21.5 48 48 48l208 0 0-96c0-35.3 28.7-64 64-64s64 28.7 64 64l0 96 208 0c26.5 0 48-21.5 48-48l0-320c0-26.5-21.5-48-48-48L473.7 96 337.8 5.4C332.4 1.8 326.2 0 320 0s-12.4 1.8-17.8 5.4L166.3 96 48 96C21.5 96 0 117.5 0 144zm80 64c0-8.8 7.2-16 16-16c10.7 0 21.3 0 32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16c-10.7 0-21.3 0-32 0c-8.8 0-16-7.2-16-16l0-64zm0 128c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zM408 176a88 88 0 1 1 -176 0 88 88 0 1 1 176 0zm88 32c0-8.8 7.2-16 16-16c10.7 0 21.3 0 32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16c-10.7 0-21.3 0-32 0c-8.8 0-16-7.2-16-16l0-64zm0 128c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64z", "M336 144l0 16 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16s16 7.2 16 16zM80 208c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zm416 0c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zM96 320l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16zm400 16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64z"]]
}, faIgloo = {
  prefix: "fad",
  iconName: "igloo",
  icon: [576, 512, [], "f7ae", ["M0 320l96 0 0-128-66.1 0C10.8 230.6 0 274 0 320zm0 32l0 80c0 26.5 21.5 48 48 48l144 0 0-128L0 352zM48.5 160L320 160l0-126.2c-10.5-1.2-21.2-1.8-32-1.8C188.1 32 100.2 82.8 48.5 160zM128 192l0 128 69.5 0c13.2-37.3 48.7-64 90.5-64s77.4 26.7 90.5 64l69.5 0 0-128-320 0zM352 39.1L352 160l175.5 0C487.2 99.8 424.9 55.7 352 39.1zM384 352l0 128 144 0c26.5 0 48-21.5 48-48l0-80-192 0zm96-160l0 128 96 0c0-46-10.8-89.4-29.9-128L480 192z", "M320 33.8c10.9 1.2 21.5 3 32 5.4L352 160l175.5 0c6.8 10.2 13 20.9 18.6 32L480 192l0 128 96 0 0 32-192 0 0 128-32 0 0-128c0-35.3-28.7-64-64-64s-64 28.7-64 64l0 128-32 0 0-128L0 352l0-32 96 0 0-128-66.1 0c5.5-11.1 11.7-21.8 18.6-32L320 160l0-126.2zM197.5 320c13.2-37.3 48.7-64 90.5-64s77.4 26.7 90.5 64l69.5 0 0-128-320 0 0 128 69.5 0z"]]
}, faBracketRound = {
  prefix: "fad",
  iconName: "bracket-round",
  icon: [192, 512, ["parenthesis"], "28", ["M154.6 46.2c9.8 14.7 5.8 34.6-8.9 44.4C120.1 107.7 64 167 64 256s56.1 148.3 81.8 165.4c14.7 9.8 18.7 29.7 8.9 44.4s-29.7 18.7-44.4 8.9C71.9 449.1 0 371.8 0 256S71.9 62.9 110.2 37.4c14.7-9.8 34.6-5.8 44.4 8.9z", ""]]
}, faParenthesis = faBracketRound, faJoint = {
  prefix: "fad",
  iconName: "joint",
  icon: [640, 512, [], "f595", ["M384 32l0 11c0 55.2 21.9 108.1 60.9 147.1l21 21c9 9 14.1 21.2 14.1 33.9l0 11c0 17.7 14.3 32 32 32s32-14.3 32-32l0-11c0-29.7-11.8-58.2-32.8-79.2l-21-21C463.2 117.8 448 81.2 448 43l0-11c0-17.7-14.3-32-32-32s-32 14.3-32 32zm96 0l0 11c0 29.7 11.8 58.2 32.8 79.2l21 21c27 27 42.2 63.6 42.2 101.8l0 11c0 17.7 14.3 32 32 32s32-14.3 32-32l0-11c0-55.2-21.9-108.1-60.9-147.1l-21-21c-9-9-14.1-21.2-14.1-33.9l0-11c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M214.7 358c5.2-.8 10.5-.3 15.2 2c10.2 4.9 19.3 12 26.7 20.8L358.9 503.7c2.6 3.2 .5 8.3-3.6 8.3L288 512c-59.2 0-127.7-14.7-180.2-28.8C81.3 476 58.3 468.9 42 463.6c-8.2-2.7-14.7-4.9-19.2-6.5c-2.3-.8-4-1.4-5.2-1.8l-1.3-.5C6.8 451.5 0 442.6 0 432s6.8-19.5 16.3-22.7l1.3-.5c1.2-.4 3-1.1 5.2-1.8c4.5-1.6 11-3.8 19.2-6.5c16.3-5.4 39.2-12.5 65.7-19.6c31.7-8.5 69.2-17.3 106.9-22.8zM464 512l-19 0c-23.7 0-46.3-10.5-61.5-28.8L281.1 360.3c-2.6-3.2-.6-8.2 3.5-8.3c1.1 0 2.3 0 3.4 0l48 0 19 0c23.7 0 46.3 10.5 61.5 28.8L518.9 503.7c2.6 3.2 .5 8.3-3.6 8.3L464 512zM444.7 352L600 352c22.1 0 40 17.9 40 40l0 80c0 21.4-16.8 38.9-37.9 39.9c-22.7-.8-44-11.2-58.6-28.7L441.1 360.3c-2.6-3.2-.5-8.3 3.6-8.3z"]]
}, faHorseSaddle = {
  prefix: "fad",
  iconName: "horse-saddle",
  icon: [576, 512, [], "f8c3", ["M0 256c0-44.6 33.2-81.5 76.3-87.2c-3.9 6.4-7 13.4-9.1 20.8c-1.1 3.7-1.9 7.5-2.4 11.4c-.3 1.9-.5 3.9-.6 5.9c-.1 1-.1 2-.2 3s-.1 2-.1 3c0 3.6 .2 7.1 .7 10.7C54.6 230.8 48 242.6 48 256l0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56zM160 128l160 0 0 48c0 38.7-27.5 71-64 78.4l0 73.6c0 8.8-7.2 16-16 16c-8.7 0-15.7-6.9-16-15.5c0-1.1 0-1.4 0-1.7l0-6.8 0-65.6c-36.5-7.4-64-39.7-64-78.4l0-48z", "M448 238.1l0-78.1 16 0 9.8 19.6c12.5 25.1 42.2 36.4 68.3 26c20.5-8.2 33.9-28 33.9-50.1L576 80c0-19.1-8.4-36.3-21.7-48l5.7 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L480 0 448 0C377.3 0 320 57.3 320 128l0 48c0 38.7-27.5 71-64 78.4l0 74.7 51.7 14.8c4.1 1.2 8.2 2.1 12.3 2.8L320 480c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-164.3c19.2-19.2 31.5-45.7 32-75.7c0 0 0 0 0 0l0-1.9zM224 254.4c-36.5-7.4-64-39.7-64-78.4l0-48-11.2 0C102 128 64 166 64 212.8c0 16.8 5 33.1 14.2 47.1l28.2 42.4c8.3 12.4 6.4 28.7-1.2 41.6c-16.5 28-20.6 62.2-10 93.9l17.5 52.4c4.4 13.1 16.6 21.9 30.4 21.9l33.7 0c21.8 0 37.3-21.4 30.4-42.1l-20.8-62.5c-2.1-6.4-.5-13.4 4.3-18.2l12.7-12.7c13.2-13.2 20.6-31.1 20.6-49.7c0-2.3-.1-4.6-.3-6.9l.3 .1 0-65.6zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]]
}, faMugMarshmallows = {
  prefix: "fad",
  iconName: "mug-marshmallows",
  icon: [512, 512, [], "f7b7", ["M32 64c0-17.7 14.3-32 32-32l128 0c7.5 0 14.4 2.6 19.8 6.9L175 75.7c-9.6 9.6-15 22.7-15 36.3c0 5.5 .9 10.9 2.6 16L32 128l0-64zm64 96l64 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm96-48c0-5.1 2-10 5.7-13.7l60.7-60.7C262 34 266.9 32 272 32s10 2 13.7 5.7l60.7 60.7c3.6 3.6 5.7 8.5 5.7 13.7s-2 10-5.7 13.7L344 128l-144 0-2.3-2.3C194 122 192 117.1 192 112z", "M96 160l-64 0c-17.7 0-32 14.3-32 32L0 384c0 53 43 96 96 96l192 0c53 0 96-43 96-96l16 0c61.9 0 112-50.1 112-112s-50.1-112-112-112l-48 0-192 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zM384 320l0-96 16 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0z"]]
}, faFilters = {
  prefix: "fad",
  iconName: "filters",
  icon: [640, 512, [], "e17e", ["M0 136c0 9.8 3.6 19.6 10.6 27.1L160 325.5l0 74.5c0 10.1 4.7 19.6 12.8 25.6l64 48c9.7 7.3 22.7 8.4 33.5 3s17.7-16.5 17.7-28.6l0-122.5 32-34.8 0-16.7L179 120.7c-6.7-7.3-11.7-15.7-14.9-24.7L40 96c-15.9 0-30.2 9.4-36.6 23.9C1.1 125.1 0 130.6 0 136z", "M195.4 55.9C201.7 41.4 216.1 32 232 32l368 0c15.9 0 30.2 9.4 36.6 23.9s3.6 31.5-7.2 43.2L480 261.5 480 416c0 12.1-6.8 23.2-17.7 28.6s-23.8 4.3-33.5-3l-64-48c-8.1-6-12.8-15.5-12.8-25.6l0-106.5L202.6 99.1c-10.7-11.7-13.6-28.6-7.2-43.2z"]]
}, faBellOn = {
  prefix: "fad",
  iconName: "bell-on",
  icon: [640, 512, [128365], "f8fa", ["M96 384c0 4.4 .9 8.9 2.8 13.1C104 408.6 115.4 416 128 416l384 0c12.6 0 24-7.4 29.2-18.9s3.1-25-5.3-34.4l-7.4-8.3C497.3 319.2 480 273.9 480 226.8l0-18.8c0-77.4-55-142-128-156.8L352 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 19.2C215 66 160 130.6 160 208l0 18.8c0 47-17.3 92.4-48.5 127.6l-7.4 8.3c-5.3 6-8.1 13.6-8.1 21.3z", "M586.7 53.5c11.9-5.9 16.7-20.3 10.7-32.2s-20.3-16.7-32.2-10.7l-64 32c-11.9 5.9-16.7 20.3-10.7 32.2s20.3 16.7 32.2 10.7l64-32zM0 200c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zm512 0c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24zM42.5 21.3c-5.9 11.9-1.1 26.3 10.7 32.2l64 32c11.9 5.9 26.3 1.1 32.2-10.7s1.1-26.3-10.7-32.2l-64-32C62.9 4.6 48.5 9.4 42.5 21.3zm322.7 472c12-12 18.7-28.3 18.7-45.3l-64 0-64 0c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7z"]]
}, faAngleRight = {
  prefix: "fad",
  iconName: "angle-right",
  icon: [320, 512, [8250], "f105", ["M278.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L210.7 256 73.4 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160z", ""]]
}, faDialMed = {
  prefix: "fad",
  iconName: "dial-med",
  icon: [576, 512, [], "e15f", ["M0 288a32 32 0 1 0 64 0A32 32 0 1 0 0 288zM64 96a32 32 0 1 0 64 0A32 32 0 1 0 64 96zm0 384a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM256 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM448 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 384a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64-192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M264 129c-77 11.6-136 78-136 158.2c0 88.4 71.6 160 160 160s160-71.6 160-160C448 207 389 140.6 312 129l0 158.2c0 13.3-10.7 24-24 24s-24-10.7-24-24L264 129z"]]
}, faHorse = {
  prefix: "fad",
  iconName: "horse",
  icon: [576, 512, [128014], "f6f0", ["M0 256l0 56c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56c0-13.4 6.6-25.2 16.7-32.5c-.4-3.5-.7-7.1-.7-10.7c0-1 0-2 .1-3s.1-2 .2-3c.1-2 .3-3.9 .6-5.9c.5-3.9 1.4-7.7 2.4-11.4c2.1-7.4 5.2-14.4 9.1-20.8C33.2 174.5 0 211.4 0 256z", "M448 238.1l0-78.1 16 0 9.8 19.6c12.5 25.1 42.2 36.4 68.3 26c20.5-8.2 33.9-28 33.9-50.1L576 80c0-19.1-8.4-36.3-21.7-48l5.7 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L480 0 448 0C377.3 0 320 57.3 320 128l-96 0-20.8 0-54.4 0C102 128 64 166 64 212.8c0 16.8 5 33.1 14.2 47.1l28.2 42.4c8.3 12.4 6.4 28.7-1.2 41.6c-16.5 28-20.6 62.2-10 93.9l17.5 52.4c4.4 13.1 16.6 21.9 30.4 21.9l33.7 0c21.8 0 37.3-21.4 30.4-42.1l-20.8-62.5c-2.1-6.4-.5-13.4 4.3-18.2l12.7-12.7c13.2-13.2 20.6-31.1 20.6-49.7c0-2.3-.1-4.6-.3-6.9l84 24c4.1 1.2 8.2 2.1 12.3 2.8L320 480c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-164.3c19.2-19.2 31.5-45.7 32-75.7c0 0 0 0 0 0l0-1.9zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]]
}, faQ = {
  prefix: "fad",
  iconName: "q",
  icon: [448, 512, [113], "51", ["M64 256c0 88.4 71.6 160 160 160c28.9 0 56-7.7 79.4-21.1l-72-86.4c-11.3-13.6-9.5-33.8 4.1-45.1s33.8-9.5 45.1 4.1l70.9 85.1C371.9 325.8 384 292.3 384 256c0-88.4-71.6-160-160-160S64 167.6 64 256zM344.9 444.6C310 467 268.5 480 224 480C100.3 480 0 379.7 0 256S100.3 32 224 32s224 100.3 224 224c0 56.1-20.6 107.4-54.7 146.7l47.3 56.8c11.3 13.6 9.5 33.8-4.1 45.1s-33.8 9.5-45.1-4.1l-46.6-55.9z", ""]]
}, faMonitorWaveform = {
  prefix: "fad",
  iconName: "monitor-waveform",
  icon: [576, 512, ["monitor-heart-rate"], "f611", ["M64 96l0 160 128 0c6.1 0 11.6 3.4 14.3 8.8L224 300.2l49.7-99.4c2.7-5.4 8.3-8.8 14.3-8.8s11.6 3.4 14.3 8.8L329.9 256l70.1 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0c-6.1 0-11.6-3.4-14.3-8.8L288 243.8l-49.7 99.4c-2.7 5.4-8.3 8.8-14.3 8.8s-11.6-3.4-14.3-8.8L182.1 288 64 288l0 128 448 0 0-320L64 96z", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM512 96l0 320L64 416 64 96l448 0z"]]
}, faMonitorHeartRate = faMonitorWaveform, faLinkSimple = {
  prefix: "fad",
  iconName: "link-simple",
  icon: [576, 512, [], "e1cd", ["M160 256c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32z", "M160 96C71.6 96 0 167.6 0 256s71.6 160 160 160l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-53 0-96-43-96-96s43-96 96-96l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0zm256 0l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c53 0 96 43 96 96s-43 96-96 96l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c88.4 0 160-71.6 160-160s-71.6-160-160-160z"]]
}, faWhistle = {
  prefix: "fad",
  iconName: "whistle",
  icon: [640, 512, [], "f460", ["M32 256c0-23.6 4.3-46.3 12.1-67.2c6.1-16.3 14.4-31.6 24.4-45.5c3.6-5 7.4-9.7 11.5-14.3c11.4-12.9 24.5-24.3 39-33.8C149.2 75.5 185.2 64 224 64c7.8 0 15.4 .5 22.9 1.4c.5 0 1.1 0 1.7 .1c37.8 4.5 73.8 19.4 103.9 43.2l69.8 55.2c5 4 7.2 10.6 5.5 16.8l-6.5 24c-3.2 11.7 1.1 24.2 10.8 31.5c9.6 7.2 22.7 7.9 33 1.7l19.3-11.6c5.7-3.4 12.9-3 18.2 1.2l127 100.4c6.6 5.2 10.5 13.2 10.5 21.6c0 6.9-2.6 13.5-7.2 18.5l-63.3 69.6c-6.1 6.7-14.7 10.5-23.7 10.5l-2 0c-5.2 0-10.2-1.2-14.8-3.6L380.7 367c-34.8 49-92 81-156.7 81C118 448 32 362 32 256zm128 0a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M0 128c0 28.4 18.5 52.5 44.1 60.8c6.1-16.3 14.4-31.6 24.4-45.5c-1.4 .4-2.9 .6-4.5 .6c-8.8 0-16-7.2-16-16s7.2-16 16-16s16 7.2 16 16c0 .3 0 .7 0 1c11.4-12.9 24.5-24.3 39-33.8C107.8 76.5 87.4 64 64 64C28.7 64 0 92.7 0 128zM224 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]]
}, faG = {
  prefix: "fad",
  iconName: "g",
  icon: [448, 512, [103], "47", ["M224 96C135.6 96 64 167.6 64 256s71.6 160 160 160c77.4 0 142-55 156.8-128L256 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l144 0c25.8 0 49.6 21.4 47.2 50.6C437.8 389.6 341.4 480 224 480C100.3 480 0 379.7 0 256S100.3 32 224 32c57.4 0 109.7 21.6 149.3 57c13.2 11.8 14.3 32 2.5 45.2s-32 14.3-45.2 2.5C302.3 111.4 265 96 224 96z", ""]]
}, faWineGlassCrack = {
  prefix: "fad",
  iconName: "wine-glass-crack",
  icon: [320, 512, ["fragile"], "f4bb", ["M18.1 197.8c-6 72 42.5 135.2 109.9 150.6l0 99.6-48 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l80 0 80 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-48 0 0-99.6c67.4-15.4 115.9-78.6 109.9-150.6l-14-168.4C286.5 12.8 272.6 0 256 0L208 0l25.8 51.7c3.5 7.1 1.4 15.7-5.1 20.3l-58.4 40.9c-6 4.2-8.4 12-5.8 18.9l31.1 81c2.1 5.5-1.9 11.4-7.8 11.4c-2.4 0-4.7-1.1-6.3-2.9L92.1 118c-6.4-7.4-4.7-18.7 3.5-24l58.6-37.3c7.6-4.8 9.7-14.9 4.7-22.4L136 0 64 0C47.4 0 33.5 12.8 32.1 29.3l-14 168.4z", "M154.2 56.8L95.7 94c-8.2 5.2-9.9 16.6-3.5 24l89.3 103.1c1.6 1.8 3.9 2.9 6.3 2.9c5.9 0 9.9-5.9 7.8-11.4l-31.1-81c-2.6-6.9-.3-14.6 5.8-18.9l58.4-40.9c6.5-4.5 8.7-13.2 5.1-20.3L208 0H136l22.9 34.4c5 7.5 2.8 17.6-4.7 22.4z"]]
}, faFragile = faWineGlassCrack, faSlotMachine = {
  prefix: "fad",
  iconName: "slot-machine",
  icon: [640, 512, [], "e3ce", ["M0 160L0 352c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64L64 96C28.7 96 0 124.7 0 160zm56 40c0-13.3 10.7-24 24-24l59.9 0c23 0 38.5 23.5 29.4 44.6L126.1 321.5c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5L115.6 224 80 224c-13.3 0-24-10.7-24-24zm144 0c0-13.3 10.7-24 24-24l59.9 0c23 0 38.5 23.5 29.4 44.6L270.1 321.5c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5L259.6 224 224 224c-13.3 0-24-10.7-24-24zm144 0c0-13.3 10.7-24 24-24l59.9 0c23 0 38.5 23.5 29.4 44.6L414.1 321.5c-5.2 12.2-19.3 17.8-31.5 12.6s-17.8-19.3-12.6-31.5L403.6 224 368 224c-13.3 0-24-10.7-24-24z", "M128 0L384 0c35.3 0 64 28.7 64 64L64 64C64 28.7 92.7 0 128 0zM640 176c0 14.2-6.2 27-16 35.8L624 416c0 53-43 96-96 96l-80 0-32 0-288 0c-35.3 0-64-28.7-64-64l0-32 384 0 0 32 80 0c17.7 0 32-14.3 32-32l0-204.2c-9.8-8.8-16-21.6-16-35.8c0-26.5 21.5-48 48-48s48 21.5 48 48z"]]
}, faNotesMedical = {
  prefix: "fad",
  iconName: "notes-medical",
  icon: [512, 512, [], "f481", ["M96 96c0-35.3 28.7-64 64-64l256 0c35.3 0 64 28.7 64 64l0 197.5c0 17-6.7 33.3-18.7 45.3l-58.5 58.5c-12 12-28.3 18.7-45.3 18.7L160 416c-35.3 0-64-28.7-64-64L96 96zm96 112l0 32c0 8.8 7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16z", "M296 464c13.3 0 24 10.7 24 24s-10.7 24-24 24l-160 0C60.9 512 0 451.1 0 376L0 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 224c0 48.6 39.4 88 88 88l160 0zM256 144c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48 48 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l48 0 0-48z"]]
}, faCarWash = {
  prefix: "fad",
  iconName: "car-wash",
  icon: [448, 512, [], "f5e6", ["M16 80c0 26.5 21.5 48 48 48s48-16 48-48S64 0 64 0s-48 48-48 80zm160 0c0 26.5 21.5 48 48 48s48-16 48-48s-48-80-48-80s-48 48-48 80zm160 0c0 26.5 21.5 48 48 48s48-16 48-48s-48-80-48-80s-48 48-48 80z", "M138.8 234.6L119.7 288l208.6 0-19.1-53.4c-2.3-6.4-8.3-10.6-15.1-10.6l-140.3 0c-6.8 0-12.8 4.3-15.1 10.6zM50.2 292.4l28.3-79.3C89.9 181.3 120 160 153.8 160l140.3 0c33.8 0 64 21.3 75.3 53.1l28.3 79.3c20.1 8.5 34.2 28.4 34.2 51.6l0 40 0 64 0 32c0 17.7-14.3 32-32 32l-16 0c-17.7 0-32-14.3-32-32l0-32L96 448l0 32c0 17.7-14.3 32-32 32l-16 0c-17.7 0-32-14.3-32-32l0-32 0-64 0-40c0-23.2 14.1-43.1 34.2-51.6zM120 368a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm232 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]]
}, faEscalator = {
  prefix: "fad",
  iconName: "escalator",
  icon: [640, 512, [], "e171", ["M32 448c0 35.3 28.7 64 64 64l96 0c15.5 0 30.5-5.6 42.1-15.8L472 288l72 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-96 0c-15.5 0-30.5 5.6-42.1 15.8L168 384l-72 0c-35.3 0-64 28.7-64 64z", "M256 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zm64 192l0 16.4-128 112L192 192c0-35.3 28.7-64 64-64s64 28.7 64 64z"]]
}, faCommentImage = {
  prefix: "fad",
  iconName: "comment-image",
  icon: [512, 512, [], "e148", ["M0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3c-4.6 4.6-6 11.5-3.5 17.5c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240zm98.3 66.2c-4-8.4-2.7-18.4 3.3-25.5l40-48c4.6-5.5 11.3-8.6 18.4-8.6s13.9 3.2 18.4 8.6L199 257.3l77.8-103.7c4.5-6 11.6-9.6 19.2-9.6s14.7 3.6 19.2 9.6l96 128c3.2 4.2 4.8 9.3 4.8 14.4c0 3.7-.8 7.3-2.5 10.7c-4.1 8.1-12.4 13.3-21.5 13.3l-192 0-80 0c-9.3 0-17.8-5.4-21.7-13.8zM192 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M296 144c7.6 0 14.7 3.6 19.2 9.6l96 128c5.5 7.3 6.3 17 2.3 25.1s-12.4 13.3-21.5 13.3l-192 0-80 0c-9.3 0-17.8-5.4-21.7-13.8s-2.7-18.4 3.3-25.5l40-48c4.6-5.5 11.3-8.6 18.4-8.6s13.9 3.2 18.4 8.6L199 257.3l77.8-103.7c4.5-6 11.6-9.6 19.2-9.6z"]]
}, faTemperatureHalf = {
  prefix: "fad",
  iconName: "temperature-half",
  icon: [320, 512, [127777, "temperature-2", "thermometer-2", "thermometer-half"], "f2c9", ["M16 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-33.2-11.2-63.8-30.1-88.1c-.9-1.2-1.5-2.2-1.7-2.8c-.1-.3-.2-.5-.2-.6L272 112C272 50.2 221.9 0 160 0S48 50.2 48 112l0 164.4c0 .1-.1 .3-.2 .6c-.2 .6-.8 1.6-1.7 2.8C27.2 304.2 16 334.8 16 368zm64 0c0-18.5 6.2-35.4 16.7-48.9c8.2-10.6 15.3-25.2 15.3-42.5L112 112c0-26.5 21.5-48 48-48s48 21.5 48 48l0 164.5c0 17.3 7.1 31.9 15.3 42.5C233.8 332.6 240 349.5 240 368c0 44.2-35.8 80-80 80s-80-35.8-80-80z", "M176 208c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 114.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3L176 208z"]]
}, faTemperature2 = faTemperatureHalf, faThermometer2 = faTemperatureHalf, faThermometerHalf = faTemperatureHalf, faDongSign = {
  prefix: "fad",
  iconName: "dong-sign",
  icon: [384, 512, [], "e169", ["M0 480c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32zM192 96c0-17.7 14.3-32 32-32l32 0 0 64-32 0c-17.7 0-32-14.3-32-32zM320 64c17.7 0 32 14.3 32 32s-14.3 32-32 32l0-64z", "M288 32c-17.7 0-32 14.3-32 32l0 113.1c-18.8-10.9-40.7-17.1-64-17.1c-70.7 0-128 57.3-128 128s57.3 128 128 128c24.5 0 47.4-6.9 66.8-18.8c5 11.1 16.2 18.8 29.2 18.8c17.7 0 32-14.3 32-32l0-96 0-224c0-17.7-14.3-32-32-32zM128 288a64 64 0 1 1 128 0 64 64 0 1 1 -128 0z"]]
}, faDonut = {
  prefix: "fad",
  iconName: "donut",
  icon: [512, 512, [127849, "doughnut"], "e406", ["M0 278.8L0 304c0 88.4 114.6 160 256 160s256-71.6 256-160l0-25.1c-7.9 9.2-18.3 16.1-29.9 19.9c-10 3.7-18.6 10.6-24.4 19.6c-11 15.4-25.8 27.6-43 35.5c-17.2 7.9-36.1 11.3-54.9 9.7c-15.6-.2-31.1 2.9-45.5 8.8c-18.4 7.8-38.3 11.7-58.2 11.6c-.7 0-1.1 0-1.5 0c-19.6 0-38.9-3.9-57-11.6c-14.4-6-29.8-9-45.4-8.8c-18.9 1.5-37.8-1.8-55-9.8s-32-20.2-43-35.6c-5.8-8.9-14.4-15.8-24.4-19.6C18.3 294.9 7.9 288 0 278.8zM116.7 132.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l32-32c6.2-6.2 6.2-16.4 0-22.6c-3.1-3.1-7.2-4.7-11.3-4.7s-8.2 1.6-11.3 4.7l-32 32zm160 160c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l32-32c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-32 32zm96-160c-6.2 6.2-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32c-6.2-6.2-16.4-6.2-22.6 0z", "M0 208C0 119.6 114.6 48 256 48s256 71.6 256 160l0 70.9c-7.9 9.2-18.3 16.1-29.9 19.9c-10 3.7-18.6 10.6-24.4 19.6c-11 15.4-25.8 27.6-43 35.5s-36.1 11.3-54.9 9.7c-15.6-.2-31 2.9-45.4 8.8C295.9 380.3 276 384.2 256 384c-20 .2-39.9-3.7-58.3-11.6c-14.4-6-29.8-9-45.4-8.8c-18.9 1.5-37.8-1.8-55-9.8s-32-20.2-43-35.6c-5.8-9-14.4-15.8-24.4-19.6C18.3 294.9 7.9 288 0 278.8L0 208zm320-16c0-17.7-28.7-32-64-32s-64 14.3-64 32s28.7 32 64 32s64-14.3 64-32zM283.3 84.7c-6.2-6.2-16.4-6.2-22.6 0l-16 16c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l16-16c6.2-6.2 6.2-16.4 0-22.6zm-112 38.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-32 32c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l32-32zm224 9.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zM64 192c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0zm331.3 36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zm-240 16c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l32 32c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-32-32zm176 38.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-32 32c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l32-32z"]]
}, faDoughnut = faDonut, faCapsules = {
  prefix: "fad",
  iconName: "capsules",
  icon: [576, 512, [], "f46b", ["M0 144l0 48 0 64c10.7 0 21.3 0 32 0s21.3 0 32 0c32 0 64 0 96 0c10.7 0 21.3 0 32 0s21.3 0 32 0l0-64 0-48c0-61.9-50.1-112-112-112S0 82.1 0 144zM256 98.3l0 163.9 53.1 77.5c17.5-12.2 35-24.5 52.4-36.7c26.6-18.6 53.3-37.3 79.9-55.9l52.4-36.7c-22.2-32.4-44.4-64.7-66.6-97.1C391.8 61.5 321.9 49 271.3 85.2c-5.6 4-10.7 8.4-15.3 13.1z", "M372.3 431.7l-63.1-92L361.6 303s0 0 0 0l79.9-55.9s0 0 0 0l52.4-36.7 61.9 90.2c35.5 51.7 23.2 123-27.5 159.2s-120.5 23.6-156-28.1zm116.4-22.4c.8-.5 1.6-1 2.4-1.6c.5-.4 1.1-.8 1.6-1.2l-4 2.8zM0 256l32 0 32 0 96 0 32 0 32 0 0 64 0 48c0 61.9-50.1 112-112 112S0 429.9 0 368l0-48 0-64z"]]
}, faPooStorm = {
  prefix: "fad",
  iconName: "poo-storm",
  icon: [448, 512, ["poo-bolt"], "f75a", ["M96.9 373.3c2.2 6.4 8.3 10.7 15.1 10.7l70.1 0L129.7 488.8c-3.4 6.7-1.6 14.9 4.3 19.6c2.9 2.4 6.5 3.6 10.1 3.6c3.5 0 7.1-1.2 10-3.5l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7l-70.1 0 52.4-104.8c3.4-6.7 1.6-14.9-4.3-19.6s-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8z", "M222.4 5.9c3.5-4.3 9-6.5 14.5-5.7C283.9 6.5 320 46.7 320 95.4c0 5.7-.5 11.2-1.4 16.6l1.4 0c35.3 0 64 28.7 64 64c0 12-3.3 23.1-9 32.7c41.2 5.4 73 40.6 73 83.3c0 46.4-37.6 84-84 84l-12.7 0c1.3-7.8 .7-16-2-23.9C342.5 332.9 324.4 320 304 320l-18.3 0 29.3-58.5c10.1-20.2 4.8-44.6-12.8-58.8s-42.6-14.2-60.2-.2L82 330.5C68.9 341 62.4 357.5 64.3 373.7C27.4 364.8 0 331.6 0 292c0-42.7 31.8-77.9 73-83.3c-5.7-9.6-9-20.8-9-32.7c0-35.3 28.7-64 64-64l16.3 0c23.8 0 44-6.3 57.8-17C215.5 84.5 224 69.1 224 47.3c0-9.2-1.5-18-4.3-26.1c-1.8-5.2-.8-11.1 2.8-15.3z"]]
}, faPooBolt = faPooStorm, faTally1 = {
  prefix: "fad",
  iconName: "tally-1",
  icon: [640, 512, [], "e294", ["", "M128 32c17.7 0 32 14.3 32 32l0 384c0 17.7-14.3 32-32 32s-32-14.3-32-32L96 64c0-17.7 14.3-32 32-32z"]]
}, faFileVector = {
  prefix: "fad",
  iconName: "file-vector",
  icon: [384, 512, [], "e64c", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM64 208l0 32c0 8.8 7.2 16 16 16l16 0 0 128-16 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-16 128 0 0 16c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-16 0 0-128 16 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 16-128 0 0-16c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm64 48l128 0 0 128-128 0 0-128z", "M384 160l-128 0c-17.7 0-32-14.3-32-32L224 0 384 160zM128 208l0 16 128 0 0-16c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-16 0 0 128 16 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-16-128 0 0 16c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l16 0 0-128-16 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16zm0 176l128 0 0-128-128 0 0 128z"]]
}, faFaceFrownOpen = {
  prefix: "fad",
  iconName: "face-frown-open",
  icon: [512, 512, [128550, "frown-open"], "f57a", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm144.4-48c0-17.7 14.3-32 32-32c8.8 0 16.8 3.6 22.6 9.4c2.9 2.9 5.2 6.3 6.9 10.2c.8 1.9 1.4 3.9 1.9 6c.2 1 .4 2.1 .5 3.2c.1 .5 .1 1.1 .1 1.6s0 1 0 1.8c0 .5 0 1 0 1.5s-.1 1.1-.1 1.6c-.1 1.1-.3 2.1-.5 3.2c-.4 2.1-1.1 4.1-1.9 6c-1.6 3.8-4 7.3-6.9 10.2c-5.8 5.8-13.8 9.4-22.6 9.4c-17.7 0-32-14.3-32-32zm14.1 161.1c16.7-38.2 55.8-65.1 101.5-65.1c45.7 0 84.9 26.9 101.5 65.1c5.3 12.2-8.6 21.5-20.8 16.4c-24.4-10.3-51.8-16.1-80.7-16.1c-28.9 0-56.2 5.8-80.6 16.1c-12.3 5.2-26.1-4.2-20.8-16.4zM368.4 208a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M176.4 240a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faFrownOpen = faFaceFrownOpen, faSquareDashed = {
  prefix: "fad",
  iconName: "square-dashed",
  icon: [448, 512, [], "e269", ["M0 128l0 32 64 0 0-32c0-17.7 14.3-32 32-32l32 0 0-64L96 32C43 32 0 75 0 128zM0 352l0 32c0 53 43 96 96 96l32 0 0-64-32 0c-17.7 0-32-14.3-32-32l0-32L0 352zM320 32l0 64 32 0c17.7 0 32 14.3 32 32l0 32 64 0 0-32c0-53-43-96-96-96l-32 0zm0 384l0 64 32 0c53 0 96-43 96-96l0-32-64 0 0 32c0 17.7-14.3 32-32 32l-32 0z", "M0 192L0 320l64 0 0-128L0 192zm384 0l0 128 64 0 0-128-64 0zM160 480l128 0 0-64-128 0 0 64zm0-384l128 0 0-64L160 32l0 64z"]]
}, faBagShoppingPlus = {
  prefix: "fad",
  iconName: "bag-shopping-plus",
  icon: [448, 512, [], "e651", ["M0 208c0-26.5 21.5-48 48-48l64 0 48 0 128 0 48 0 64 0c26.5 0 48 21.5 48 48l0 208c0 53-43 96-96 96L96 512c-53 0-96-43-96-96L0 208zM120 336c0 13.3 10.7 24 24 24l56 0 0 56c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56 56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-56 0 0-56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 56-56 0c-13.3 0-24 10.7-24 24z", "M224 48c-35.3 0-64 28.7-64 64l0 48-48 0 0-48C112 50.1 162.1 0 224 0s112 50.1 112 112l0 48-48 0 0-48c0-35.3-28.7-64-64-64zM120 336c0-13.3 10.7-24 24-24l56 0 0-56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 56 56 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-56 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56-56 0c-13.3 0-24-10.7-24-24z"]]
}, faSquareJ = {
  prefix: "fad",
  iconName: "square-j",
  icon: [448, 512, [], "e273", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM112 280c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8c0 26.5 21.5 48 48 48s48-21.5 48-48l0-136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 136c0 53-43 96-96 96s-96-43-96-96l0-8z", "M280 128c13.3 0 24 10.7 24 24l0 136c0 53-43 96-96 96s-96-43-96-96l0-8c0-13.3 10.7-24 24-24s24 10.7 24 24l0 8c0 26.5 21.5 48 48 48s48-21.5 48-48l0-136c0-13.3 10.7-24 24-24z"]]
}, faHandPointUp = {
  prefix: "fad",
  iconName: "hand-point-up",
  icon: [384, 512, [9757], "f0a6", ["M0 336l0 27c0 33.9 13.5 66.5 37.5 90.5l11.6 11.6c30 30 70.7 46.9 113.1 46.9l61.7 0c88.4 0 160-71.6 160-160l0-8.6c-9.4 5.4-20.3 8.6-32 8.6c-27.9 0-51.7-17.9-60.4-42.8C281.4 316 269.2 320 256 320c-11.7 0-22.6-3.1-32-8.6l0 .6c0 39.8-32.2 72-72 72l-56 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-88 0c-35.3 0-64 28.7-64 64zM32 32l0 208 64 0L96 32C96 14.3 81.7 0 64 0S32 14.3 32 32z", "M128 160c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-48zm96 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zm128 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32z"]]
}, faMoneyBill = {
  prefix: "fad",
  iconName: "money-bill",
  icon: [576, 512, [], "f0d6", ["M64 192l0 128c35.3 0 64 28.7 64 64l320 0c0-35.3 28.7-64 64-64l0-128c-35.3 0-64-28.7-64-64l-320 0c0 35.3-28.7 64-64 64zm320 64a96 96 0 1 1 -192 0 96 96 0 1 1 192 0z", "M64 64C28.7 64 0 92.7 0 128L0 384c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 64zm384 64c0 35.3 28.7 64 64 64l0 128c-35.3 0-64 28.7-64 64l-320 0c0-35.3-28.7-64-64-64l0-128c35.3 0 64-28.7 64-64l320 0z"]]
}, faArrowUpBigSmall = {
  prefix: "fad",
  iconName: "arrow-up-big-small",
  icon: [576, 512, ["sort-size-up"], "f88e", ["M320 80l0 128c0 26.5 21.5 48 48 48l128 0c26.5 0 48-21.5 48-48l0-128c0-26.5-21.5-48-48-48L368 32c-26.5 0-48 21.5-48 48zm0 288l0 64c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48z", "M160 32c9 0 17.5 3.8 23.6 10.4l88 96c11.9 13 11.1 33.3-2 45.2s-33.3 11.1-45.2-2L192 146.3 192 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-301.7L95.6 181.6c-11.9 13-32.2 13.9-45.2 2s-13.9-32.2-2-45.2l88-96C142.5 35.8 151 32 160 32z"]]
}, faSortSizeUp = faArrowUpBigSmall, faBarcodeRead = {
  prefix: "fad",
  iconName: "barcode-read",
  icon: [576, 512, [], "f464", ["M0 56l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80c0-4.4 3.6-8 8-8l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L56 0C25.1 0 0 25.1 0 56zM0 376l0 80c0 30.9 25.1 56 56 56l80 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0c-4.4 0-8-3.6-8-8l0-80c0-13.3-10.7-24-24-24s-24 10.7-24 24zM416 24c0 13.3 10.7 24 24 24l80 0c4.4 0 8 3.6 8 8l0 80c0 13.3 10.7 24 24 24s24-10.7 24-24l0-80c0-30.9-25.1-56-56-56L440 0c-13.3 0-24 10.7-24 24zm0 464c0 13.3 10.7 24 24 24l80 0c30.9 0 56-25.1 56-56l0-80c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 80c0 4.4-3.6 8-8 8l-80 0c-13.3 0-24 10.7-24 24z", "M152 128c-13.3 0-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-208c0-13.3-10.7-24-24-24l-16 0zm160 0c-13.3 0-24 10.7-24 24l0 208c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-208c0-13.3-10.7-24-24-24l-16 0zm72 24l0 208c0 13.3 10.7 24 24 24l16 0c13.3 0 24-10.7 24-24l0-208c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24zM240 128c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16z"]]
}, faBaguette = {
  prefix: "fad",
  iconName: "baguette",
  icon: [640, 512, [129366], "e3d8", ["M0 384.1c0 24.4 7 49.1 21.5 70.9c24.7 37 65.3 57 106.6 57c24.4 0 49.1-7 70.9-21.5l384-256c58.8-39.2 74.7-118.7 35.5-177.5S499.8-17.7 441 21.5L356.5 77.8c23.6 23.6 47.2 47.2 70.8 70.8c3.1 3.1 4.7 7.2 4.7 11.3s-1.6 8.2-4.7 11.3c-6.2 6.2-16.4 6.2-22.6 0c-25.1-25.1-50.2-50.2-75.4-75.4c-29.4 19.6-58.7 39.1-88 58.7c24.7 24.7 49.4 49.4 74 74c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-78.6-78.6c-29.4 19.6-58.7 39.1-88 58.7c25.8 25.8 51.5 51.5 77.2 77.2c6.2 6.2 6.2 16.4 0 22.6c-3.1 3.1-7.2 4.7-11.3 4.7s-8.2-1.6-11.3-4.7L98.9 249.5c-14 9.3-28 18.6-41.9 28C20 302.2 0 342.8 0 384.1z", "M356.5 77.8L329.3 95.9l75.4 75.4c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L356.5 77.8zM126.1 231.4L98.9 249.5l81.8 81.8c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-77.2-77.2zm115.2-76.8l-27.2 18.1 78.6 78.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-74-74z"]]
}, faBowlSoftServe = {
  prefix: "fad",
  iconName: "bowl-soft-serve",
  icon: [512, 512, [], "e46b", ["M32 240c0 44.2 35.8 80 80 80l288 0c44.2 0 80-35.8 80-80c0-41.7-32-76-72.8-79.7c5.6-9.5 8.8-20.5 8.8-32.3C416 57.3 358.7 0 288 0L256 0l10.8 16.3c3.4 5 5.2 11 5.2 17c0 17-13.7 30.7-30.7 30.7L160 64c-35.3 0-64 28.7-64 64c0 11.8 3.2 22.8 8.8 32.3C64 164 32 198.3 32 240z", "M64 320c-8.8 0-16 7.2-16 16l0 8c0 57.4 46.6 104 104 104l30.1 0-20.4 40.8c-1.1 2.3-1.7 4.7-1.7 7.2c0 2.9 .8 5.8 2.4 8.4c2.9 4.7 8.1 7.6 13.6 7.6l160 0c5.5 0 10.7-2.9 13.6-7.6c1.6-2.6 2.4-5.5 2.4-8.4c0-2.4-.6-4.9-1.7-7.2L329.9 448l30.1 0c57.4 0 104-46.6 104-104l0-8c0-8.8-7.2-16-16-16L64 320z"]]
}, faFaceHoldingBackTears = {
  prefix: "fad",
  iconName: "face-holding-back-tears",
  icon: [512, 512, [129401], "e482", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm80.3-83c.2-.9 .4-1.9 .8-2.8c.7-1.8 1.7-3.4 2.9-4.8c2.5-2.8 6-4.8 10-5.3c3.8-.5 7.7-1 11.5-1.4c25.5-3.2 46.6-21.3 53.6-45.9c.5-1.7 1-3.4 1.5-5.2c2.4-8.5 11.3-13.4 19.8-11s13.4 11.3 11 19.8l-1.5 5.2c-4.2 14.8-11.8 28-21.9 38.8c40.4 4 72 38.1 72 79.6l0 32 0 16 0 16c0 8.8-7.2 16-16 16s-16-7.2-16-16c-13.4 10-30 16-48 16c-11.4 0-22.2-2.4-32-6.7l0 6.7c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c-10-13.4-16-30-16-48s6-34.6 16-48c-8 0-14.9-5.9-15.9-14c-.1-.7-.1-1.4-.1-2c0-1 0-1.2 .1-1.5c0-.5 .1-.9 .2-1.4zm85.6 217.4c-5.8-6.7-5.1-16.8 1.6-22.6s16.8-5.1 22.6 1.6C203 384.4 224.9 400 256 400s53-15.6 65.9-30.5c5.8-6.7 15.9-7.4 22.6-1.6s7.4 15.9 1.6 22.6C328.9 410.3 298.8 432 256 432s-72.9-21.7-90.1-41.5zM272 240c0-41.4 31.4-75.4 72-79.6c-10-10.8-17.6-24.1-21.9-38.8c-.5-1.7-1-3.4-1.5-5.2c-2.4-8.5 2.5-17.4 11-19.8c1.5-.4 2.9-.6 4.4-.6c7 0 13.4 4.6 15.4 11.6l1.5 5.2c7 24.7 28.1 42.7 53.6 45.9c3.8 .5 7.7 1 11.5 1.4c8.1 1 14 7.9 14 15.9c0 .7 0 1.3-.1 2c-1 8.1-7.9 14-15.9 14c10 13.4 16 30 16 48s-6 34.6-16 48l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-6.7c-9.8 4.3-20.6 6.7-32 6.7c-44.2 0-80-35.8-80-80z", "M191.4 116.4c2.4-8.5-2.5-17.4-11-19.8s-17.4 2.5-19.8 11l-1.5 5.2c-7 24.7-28.1 42.7-53.6 45.9L94 160.1c-8.8 1.1-15 9.1-13.9 17.9s9.1 15 17.9 13.9l11.5-1.4c38.2-4.8 69.8-31.9 80.4-68.9l1.5-5.2zm129.2 0l1.5 5.2c10.6 37 42.2 64.1 80.4 68.9l11.5 1.4c8.8 1.1 16.8-5.1 17.9-13.9s-5.1-16.8-13.9-17.9l-11.5-1.4c-25.5-3.2-46.6-21.3-53.6-45.9l-1.5-5.2c-2.4-8.5-11.3-13.4-19.8-11s-13.4 11.3-11 19.8zM128 232c-8.3 0-15.9-3.2-21.6-8.4c-1.6 5.2-2.4 10.7-2.4 16.4c0 30.9 25.1 56 56 56s56-25.1 56-56s-25.1-56-56-56c-1.4 0-2.8 .1-4.2 .2c2.7 4.7 4.2 10.1 4.2 15.8c0 17.7-14.3 32-32 32zm224-32c0 17.7-14.3 32-32 32c-8.3 0-15.9-3.2-21.6-8.4c-1.6 5.2-2.4 10.7-2.4 16.4c0 30.9 25.1 56 56 56s56-25.1 56-56s-25.1-56-56-56c-1.4 0-2.8 .1-4.2 .2c2.7 4.7 4.2 10.1 4.2 15.8z"]]
}, faSquareUp = {
  prefix: "fad",
  iconName: "square-up",
  icon: [448, 512, [11014, "arrow-alt-square-up"], "f353", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM96 233.7c0-6.2 2.6-12.1 7.1-16.3l107.1-99.9c3.8-3.5 8.7-5.5 13.8-5.5s10.1 2 13.8 5.5c35.7 33.3 71.4 66.6 107.1 99.9c4.5 4.2 7.1 10.1 7.1 16.3c0 12.3-10 22.3-22.3 22.3L272 256l0 96c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-96-57.7 0C106 256 96 246 96 233.7z", "M210.2 117.5L103.1 217.4c-4.5 4.2-7.1 10.1-7.1 16.3C96 246 106 256 118.3 256l57.7 0 0 96c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-96 57.7 0c12.3 0 22.3-10 22.3-22.3c0-6.2-2.6-12.1-7.1-16.3L237.8 117.5c-3.8-3.5-8.7-5.5-13.8-5.5s-10.1 2-13.8 5.5z"]]
}, faArrowAltSquareUp = faSquareUp, faTrainSubwayTunnel = {
  prefix: "fad",
  iconName: "train-subway-tunnel",
  icon: [512, 512, ["subway-tunnel"], "e2a3", ["M0 256L0 448c0 35.3 28.7 64 64 64l41.4 0 64.3-64.3C137.3 444.5 112 417.2 112 384l0-192c0-35.3 28.7-64 64-64l160 0c35.3 0 64 28.7 64 64l0 192c0 1 0 2.1-.1 3.1s-.1 2-.2 3.1c-.2 2-.5 4-.9 6c-.8 3.9-1.9 7.7-3.3 11.4c-2.9 7.3-7.1 13.9-12.2 19.6c-10.4 11.4-24.8 19-41 20.6L406.6 512l41.4 0c35.3 0 64-28.7 64-64l0-192C512 114.6 397.4 0 256 0S0 114.6 0 256zM150.6 512l210.7 0-64-64-82.7 0-64 64zM160 216l0 8 0 64 0 8c0 13.3 10.7 24 24 24l8 0 16 0 8 0c13.3 0 24-10.7 24-24l0-8 0-64 0-8c0-13.3-10.7-24-24-24l-8 0-16 0-8 0c-13.3 0-24 10.7-24 24zm112 0l0 8 0 64 0 8c0 13.3 10.7 24 24 24l8 0 16 0 8 0c13.3 0 24-10.7 24-24l0-8 0-64 0-8c0-13.3-10.7-24-24-24l-8 0-16 0-8 0c-13.3 0-24 10.7-24 24z", "M112 192c0-35.3 28.7-64 64-64l160 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64l-160 0c-35.3 0-64-28.7-64-64l0-192zm48 24l0 8 0 64 0 8c0 13.3 10.7 24 24 24l8 0 16 0 8 0c13.3 0 24-10.7 24-24l0-8 0-64 0-8c0-13.3-10.7-24-24-24l-8 0-16 0-8 0c-13.3 0-24 10.7-24 24zm136-24c-13.3 0-24 10.7-24 24l0 8 0 64 0 8c0 13.3 10.7 24 24 24l8 0 16 0 8 0c13.3 0 24-10.7 24-24l0-8 0-64 0-8c0-13.3-10.7-24-24-24l-8 0-16 0-8 0zM208 376a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm120 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]]
}, faSubwayTunnel = faTrainSubwayTunnel, faSquareExclamation = {
  prefix: "fad",
  iconName: "square-exclamation",
  icon: [448, 512, ["exclamation-square"], "f321", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM256 352a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM200 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112z", "M248 152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM224 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faExclamationSquare = faSquareExclamation, faSemicolon = {
  prefix: "fad",
  iconName: "semicolon",
  icon: [192, 512, [], "3b", ["M9.5 472c0 21.5 17.5 40 40.1 40c14 0 26.9-7.3 34.2-19.2L150.8 383c6-9.8 9.2-21.2 9.2-32.7c0-34.2-27.7-62.3-61.9-62.3c-29.2 0-54.4 20.4-60.6 49L10.4 463.6c-.6 2.9-.9 5.7-.9 8.5z", "M32 128a64 64 0 1 1 128 0A64 64 0 1 1 32 128z"]]
}, faBookmark = {
  prefix: "fad",
  iconName: "bookmark",
  icon: [384, 512, [128278, 61591], "f02e", ["M96 0l0 322.1c0 12.8 14.2 20.4 24.9 13.3L192 288l71.1 47.4c10.6 7.1 24.9-.5 24.9-13.3L288 0 96 0z", "M0 487.7L0 48C0 21.5 21.5 0 48 0L96 0l0 322.1c0 12.8 14.2 20.4 24.9 13.3L192 288l71.1 47.4c10.6 7.1 24.9-.5 24.9-13.3L288 0l48 0c26.5 0 48 21.5 48 48l0 439.7c0 13.4-10.9 24.3-24.3 24.3c-5 0-9.9-1.5-14-4.4L192 400 38.3 507.6c-4.1 2.9-9 4.4-14 4.4C10.9 512 0 501.1 0 487.7z"]]
}, faFanTable = {
  prefix: "fad",
  iconName: "fan-table",
  icon: [448, 512, [], "e004", ["M16 208c0 104 76.3 190.2 176 205.6l0 34.4 32 0 32 0 0-34.4C355.7 398.2 432 312 432 208C432 93.1 338.9 0 224 0S16 93.1 16 208zm99.4-33.8C97.2 129.1 119 77.9 164.1 59.7c2-.8 4-1.2 6-1.2c6.3 0 12.3 3.8 14.8 10c13.1 32.5 26.3 65 39.4 97.5c18.5-25.3 50-39.8 83.3-35.1c48.1 6.8 81.7 51.3 74.9 99.4c-1.2 8.8-9.3 14.8-18.1 13.6c-34.7-4.9-69.4-9.8-104.2-14.6c12.6 28.7 9.5 63.2-11.2 89.7c-29.9 38.3-85.2 45.1-123.5 15.2c-7-5.4-8.2-15.5-2.8-22.5c21.6-27.6 43.2-55.3 64.8-82.9c-31.2-3.4-59.5-23.4-72.1-54.5z", "M184.9 68.5L224.3 166c18.5-25.3 50-39.8 83.3-35.1c48.1 6.8 81.7 51.3 74.9 99.4c-1.2 8.8-9.3 14.8-18.1 13.6L260.2 229.2c12.6 28.7 9.5 63.2-11.2 89.7c-29.9 38.3-85.2 45.1-123.5 15.2c-7-5.4-8.2-15.5-2.8-22.5l64.8-82.9c-31.2-3.4-59.5-23.4-72.1-54.5C97.2 129.1 119 77.9 164.1 59.7c8.2-3.3 17.5 .6 20.8 8.8zM240 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM96 448l128 0 128 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0L96 512c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]]
}, faAlignJustify = {
  prefix: "fad",
  iconName: "align-justify",
  icon: [448, 512, [], "f039", ["M0 64C0 81.7 14.3 96 32 96l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64zM0 320c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 288c-17.7 0-32 14.3-32 32z", "M32 480c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480zm0-256c-17.7 0-32-14.3-32-32s14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 224z"]]
}, faBatteryLow = {
  prefix: "fad",
  iconName: "battery-low",
  icon: [576, 512, ["battery-1"], "e0b1", ["M0 176c0-44.2 35.8-80 80-80l384 0c44.2 0 80 35.8 80 80l0 16c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l0 16c0 44.2-35.8 80-80 80L80 416c-44.2 0-80-35.8-80-80L0 176zm64 0l0 160c0 8.8 7.2 16 16 16l384 0c8.8 0 16-7.2 16-16l0-160c0-8.8-7.2-16-16-16L80 160c-8.8 0-16 7.2-16 16z", "M96 192h64v128H96V192z"]]
}, faBattery1 = faBatteryLow, faCreditCardFront = {
  prefix: "fad",
  iconName: "credit-card-front",
  icon: [576, 512, [], "f38a", ["M96 304c0 8.8 7.2 16 16 16l352 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-352 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm128 0c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16z", "M0 96C0 60.7 28.7 32 64 32l448 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM112 288c-8.8 0-16 7.2-16 16s7.2 16 16 16l352 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-352 0zM96 368c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm128 0c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16zM408 96c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-80 0z"]]
}, faBrainArrowCurvedRight = {
  prefix: "fad",
  iconName: "brain-arrow-curved-right",
  icon: [640, 512, ["mind-share"], "f677", ["M0 304c0 34.2 21.4 63.4 51.6 74.8C49.3 385.4 48 392.6 48 400c0 35.3 28.7 64 64 64c5.6 0 11.1-.7 16.3-2.1c2.9 28.2 26.8 50.1 55.7 50.1c30.9 0 56-25.1 56-56l0-400c0-30.9-25.1-56-56-56c-28.9 0-52.7 21.9-55.7 49.9C100.6 56.9 80 82.1 80 112c0 6 .8 11.9 2.4 17.4C53.6 135.7 32 161.3 32 192c0 15 5.1 28.8 13.8 39.7C18.7 244.5 0 272.1 0 304zM272 56l0 400c0 30.9 25.1 56 56 56c3.2 0 6.4-.3 9.5-.8C321.3 491 304 459.3 304 416c0-79.5 64.5-144 144-144l32 0 0-16c0-4.9 .8-9.8 2.2-14.3c-4.9-3.9-10.2-7.3-16-10C474.9 220.8 480 207 480 192c0-30.7-21.6-56.3-50.4-62.6c1.6-5.5 2.4-11.4 2.4-17.4c0-29.9-20.6-55.1-48.3-62.1C380.6 21.9 356.9 0 328 0c-30.9 0-56 25.1-56 56z", "M521.9 241.2c6-2.5 12.9-1.1 17.4 3.5l96 96c6.2 6.2 6.2 16.4 0 22.6l-96 96c-4.6 4.6-11.5 5.9-17.4 3.5s-9.9-8.3-9.9-14.8l0-48-48 0c-35.3 0-64 28.7-64 64l0 35.7c0 6.8-5.5 12.3-12.3 12.3c-2.4 0-4.8-.7-6.7-2.2c-10.5-8.2-45-39.5-45-93.8c0-61.9 50.1-112 112-112l64 0 0-48c0-6.5 3.9-12.3 9.9-14.8z"]]
}, faMindShare = faBrainArrowCurvedRight, faUmbrellaBeach = {
  prefix: "fad",
  iconName: "umbrella-beach",
  icon: [576, 512, [127958], "f5ca", ["M214 448l68.1 0 75.1-206.3c-20-7.3-40.1-14.6-60.1-21.9L214 448z", "M434 269.7L223.5 193l3.3-9.1c18.1-49.8 45.6-95.6 80.9-135.1l4-4.5C335 18.3 371.8 8.9 404.8 20.6c.9 .3 1.9 .7 2.8 1.1c31.9 12.6 53.3 43 54.4 77.4l.2 6c1.7 52.9-6.8 105.7-24.9 155.5l-3.3 9.1zM287.8 23.1l-4 4.5c-38 42.5-67.6 91.9-87.1 145.5l-3.3 9.1-71-25.8c-18.1-6.6-26.4-27.7-15.3-43.4C153.7 47.1 228.8 7.3 308.4 4.9C300.9 10 294 16.1 287.8 23.1zM494 98.1c-.3-8.5-1.4-16.8-3.4-24.8c56.9 53 87.3 130 80.8 208.5c-1.6 19.2-21.5 30-39.6 23.4l-67.7-24.6 3.3-9.1c19.5-53.6 28.6-110.4 26.8-167.4l-.2-6zM32 448l512 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]]
}, faHelmetUn = {
  prefix: "fad",
  iconName: "helmet-un",
  icon: [512, 512, [], "e503", ["M215.7 384l2.7 0c3.1-5.3 6.2-10.6 9.3-15.9L242.3 343 320 416.9 320 288l48 0 0 174.5 1.6 1.5 70.4 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-6.2 0-12.1-2.4-16.5-6.6L215.7 384z", "M479.5 224C471.2 98.9 367.2 0 240 0C107.5 0 0 107.5 0 240l0 56.3C0 344.8 39.2 384 87.7 384L200 384l18.4 0 9.3-15.9L274.4 288 448 288l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-.5 0zM285.3 103.1l34.7 52 0-43.2c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 7.1-4.6 13.3-11.4 15.3s-14-.6-17.9-6.4l-34.7-52 0 43.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4zM160 112l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16l0 64c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16z"]]
}, faLocationSmile = {
  prefix: "fad",
  iconName: "location-smile",
  icon: [384, 512, ["map-marker-smile"], "f60d", ["M0 192c0 87.4 117 243 168.3 307.2c6.1 7.7 14.9 11.5 23.7 11.5s17.6-3.8 23.7-11.5C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192zm92 64c0-6.5 3.1-12.8 8.9-16.7c9.2-6.1 21.6-3.6 27.7 5.5c6.2 9.4 29.1 31.1 63.4 31.1s57.1-21.7 63.4-31.1c6.1-9.2 18.5-11.7 27.7-5.5c2.9 1.9 5.1 4.5 6.6 7.3c.8 1.4 1.3 3 1.7 4.5c.2 .8 .3 1.6 .4 2.4c.1 .6 .1 1.2 .1 1.1c0 .4 0 .9 0 1.4c0 .9 0 1.2-.1 1.4c0 .4-.1 .9-.2 1.4c-.1 .9-.3 1.9-.6 2.8c-.6 1.9-1.4 3.7-2.5 5.4C277.1 284.4 243.1 316 192 316s-85.1-31.6-96.6-48.9c-2.3-3.4-3.4-7.3-3.4-11.1zm4-96c0-17.7 14.3-32 32-32c8.8 0 16.8 3.6 22.6 9.4c2.9 2.9 5.2 6.3 6.9 10.2c.8 1.9 1.4 3.9 1.9 6c.2 1 .4 2.1 .5 3.2c.1 .5 .1 1.1 .1 1.6s0 1 0 1.2l0 .4 0 .4c0 .3 0 .8 0 1.3c0 .5-.1 1.1-.1 1.6c-.1 1.1-.3 2.1-.5 3.2c-.4 2.1-1.1 4.1-1.9 6c-1.6 3.8-4 7.3-6.9 10.2c-5.8 5.8-13.8 9.4-22.6 9.4c-17.7 0-32-14.3-32-32zm128 0c0-17.7 14.3-32 32-32c8.8 0 16.8 3.6 22.6 9.4c2.9 2.9 5.2 6.3 6.9 10.2c.8 1.9 1.4 3.9 1.9 6c.2 1 .4 2.1 .5 3.2c.1 .5 .1 1.1 .1 1.6s0 1 0 1.2l0 .4 0 .4c0 .3 0 .8 0 1.3c0 .5-.1 1.1-.1 1.6c-.1 1.1-.3 2.1-.5 3.2c-.4 2.1-1.1 4.1-1.9 6c-1.6 3.8-4 7.3-6.9 10.2c-5.8 5.8-13.8 9.4-22.6 9.4c-17.7 0-32-14.3-32-32z", "M160 160a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM128.6 244.9c-6.1-9.2-18.5-11.7-27.7-5.5s-11.7 18.5-5.5 27.7C106.9 284.4 140.9 316 192 316s85.1-31.6 96.6-48.9c6.1-9.2 3.6-21.6-5.5-27.7s-21.6-3.6-27.7 5.5c-6.2 9.4-29.1 31.1-63.4 31.1s-57.1-21.7-63.4-31.1z"]]
}, faMapMarkerSmile = faLocationSmile, faArrowLeftToLine = {
  prefix: "fad",
  iconName: "arrow-left-to-line",
  icon: [448, 512, [8676, "arrow-to-left"], "f33e", ["M0 96L0 416c0 17.7 14.3 32 32 32s32-14.3 32-32L64 96c0-17.7-14.3-32-32-32S0 78.3 0 96z", "M137.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L237.3 224 416 224c17.7 0 32 14.3 32 32s-14.3 32-32 32l-178.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-128-128z"]]
}, faArrowToLeft = faArrowLeftToLine, faBullseye = {
  prefix: "fad",
  iconName: "bullseye",
  icon: [512, 512, [], "f140", ["M112 256a144 144 0 1 0 288 0 144 144 0 1 0 -288 0zm224 0a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M448 256A192 192 0 1 0 64 256a192 192 0 1 0 384 0zM0 256a256 256 0 1 1 512 0A256 256 0 1 1 0 256zm256-32a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]]
}, faSushi = {
  prefix: "fad",
  iconName: "sushi",
  icon: [576, 512, [127843, "nigiri"], "e48a", ["M32 369l0 15c0 35.3 28.7 64 64 64c19.1 0 36.3-8.4 48-21.7c11.7 13.3 28.9 21.7 48 21.7s36.3-8.4 48-21.7c11.7 13.3 28.9 21.7 48 21.7s36.3-8.4 48-21.7c11.7 13.3 28.9 21.7 48 21.7s36.3-8.4 48-21.7c11.7 13.3 28.9 21.7 48 21.7c35.3 0 64-28.7 64-64l0-14.3c-8.3 .7-16.9-.3-25.5-3.1L313 298.4c-20-6.7-41.7-6.5-61.7 .4l-193 66.9c-8.9 3.1-17.8 4.1-26.4 3.4z", "M405.9 295.5L506.3 125.6c24.8 26.7 42.1 60.7 48.5 98.8l12.5 75.2c4 23.8-18.8 43.2-41.7 35.6L405.9 295.5zm76.2-191.9L374.8 285.2 323.1 268c-14.6-4.9-29.9-7-45.2-6.4L393.5 66.1c32.9 4.8 63.2 18 88.7 37.5zM246.6 64l110.9 0L235.6 270.4 96.1 318.7 246.6 64zm-37.2 0L49.4 334.8C27 341.5 5 322.3 8.9 298.9l12.4-74.4C36.6 132.2 116.1 64.6 209.5 64z"]]
}, faNigiri = faSushi, faMessageCaptions = {
  prefix: "fad",
  iconName: "message-captions",
  icon: [512, 512, ["comment-alt-captions"], "e1de", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM96 216c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zm0 80c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24zm128 0c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zm96-80c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0c-13.3 0-24 10.7-24 24z", "M96 216c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24zm224 0c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zM96 296c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zm128 0c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z"]]
}, faCommentAltCaptions = faMessageCaptions, faTrashList = {
  prefix: "fad",
  iconName: "trash-list",
  icon: [640, 512, [], "e2b1", ["M32 96L53.4 466.8c1.5 25.4 22.5 45.2 47.9 45.2l213.4 0c25.4 0 46.5-19.8 47.9-45.2L384 96 32 96z", "M147.8 0c-12.1 0-23.2 6.8-28.6 17.7L112 32 32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l352 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-80 0-7.2-14.3C291.4 6.8 280.3 0 268.2 0L147.8 0zM448 160c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32zm0 128c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32zm32 96c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0z"]]
}, faBacon = {
  prefix: "fad",
  iconName: "bacon",
  icon: [576, 512, [129363], "f7e5", ["M0 384c0 8.4 3.3 16.6 9.4 22.6l28.5 28.5c11.6-5.8 23.3-11.6 34.9-17.5c122.1-61.1 168.8-129 211.7-191.4c.8-1.1 1.5-2.2 2.3-3.3c21.9-31.9 43.9-63.5 75.1-90.9c31.4-27.7 71.6-50.8 129.6-67.4c8.8-2.6 17.6-5.3 26.5-7.9c-15.8-15.8-31.6-31.6-47.3-47.3C462.4 1.2 450.4-2 439.2 1.2C379.1 18.4 336.8 42.5 303.3 72c-32.9 29-55.9 62.1-77.7 93.9l-2.3 3.4C180.9 231 136.1 296.2 17.7 355.4C8.5 360 2.1 368.7 .4 378.9c-.3 1.7-.4 3.4-.4 5.1zm61.8 75l43.6 43.6c6.1 6.1 14.3 9.4 22.6 9.4c4.9 0 9.8-1.1 14.3-3.4C275.5 442 327.8 365.9 372.1 301.4l2.2-3.2c22.2-32.2 41.1-59.1 67.3-82.1c25.6-22.5 59.2-42.4 111.1-57.2c10.9-3.1 19.3-11.8 22.2-22.7s-.3-22.6-8.3-30.7l-23-23C529.2 86.7 515 91 500.6 95.3c-27.2 7.8-49.6 16.9-68.8 27.1c-19.2 10.2-35 21.5-48.8 33.6c-27.8 24.5-47.8 52.9-69.9 85.1l-2.2 3.3c-43.9 63.9-94.3 137.2-223.8 202L61.8 459z", "M518 56.7l-26.5 7.9c-58 16.6-98.1 39.6-129.6 67.4c-31.2 27.5-53.2 59.1-75.1 90.9l-2.3 3.3C241.6 288.7 195 356.6 72.8 417.7L37.9 435.2 61.8 459l25.4-12.7c129.5-64.7 179.9-138.1 223.8-202l2.2-3.3c22.1-32.1 42.1-60.5 69.9-85.1c27.5-24.3 63.4-45.2 117.3-60.6c0 0 0 0 0 0l.2-.1 43.1-12.9L518 56.7z"]]
}, faOption = {
  prefix: "fad",
  iconName: "option",
  icon: [640, 512, [], "e318", ["M416 96c0-17.7 14.3-32 32-32l160 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32z", "M423 436c6.1 7.6 15.3 12 25 12l160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-144.6 0L217 76c-6.1-7.6-15.3-12-25-12L32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l144.6 0L423 436z"]]
}, faRaccoon = {
  prefix: "fad",
  iconName: "raccoon",
  icon: [512, 512, [], "e613", ["M0 128l0 32 128 0 0-32L0 128zm0 96l0 32 112 0c5-6.7 10.4-13.1 16-19.2l0-12.8L0 224zm0 96l0 80c0 61.9 50.1 112 112 112l128 0 80 0 0-16c0-26.5-21.5-48-48-48l-32 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l32 0c44.2 0 80 35.8 80 80l0 16 24 0 40 0 64 0 0-16.4c-.2-26.3-21.6-47.6-48-47.6l-16 0c0-24 0-48 0-72l-6.4 4.8c-7.1 5.3-17.1 3.9-22.4-3.2s-3.9-17.1 3.2-22.4l38.1-28.5c12.3-9.2 19.5-23.7 19.5-39.1c0-14.9-6.8-29-18.5-38.3c-6.6 2.2-12.9 5.3-18.7 9.2l-18.8 12.6c-16.6 11-36 16.9-55.9 16.9s-39.4-5.9-55.9-16.9l-18.8-12.6c-6.6-4.4-13.7-7.7-21.3-10l-35.8-10.7c-6.8-2-13.2-4.9-19.1-8.4C131.2 266.9 96 329.4 96 400c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-28.1 4.8-55 13.7-80L0 320zM192 43.5c0 4.7 .8 9.3 2.2 13.8l13.8 41.5L194 116.2c28.8-10 57.6-20 86.4-30.1c21.7-7.5 44 1.4 55.6 18.6c11.5-17.3 33.9-26.2 55.6-18.6c28.8 10 57.6 20 86.5 30.1L463.9 98.8l13.8-41.5c1.5-4.4 2.2-9.1 2.2-13.8C480 19.5 460.5 0 436.5 0l-1.3 0c-3.3 0-6.5 .4-9.7 1.1l-44.1 9.8C367.5 3.8 352 0 336 0s-31.5 3.8-45.3 10.9L246.6 1.1c-3.2-.7-6.5-1.1-9.7-1.1l-1.3 0C211.5 0 192 19.5 192 43.5zm18.3 268.2c4.5-7.6 14.4-10 22-5.5l80 48c7.6 4.5 10 14.4 5.5 21.9s-14.4 10-22 5.5l-80-48c-7.6-4.5-10-14.4-5.5-22zM224 43.5c0-6.4 5.2-11.5 11.5-11.5l1.3 0c.9 0 1.9 .1 2.8 .3l19.1 4.2-.3 .4L232 69.4l-7.4-22.2c-.4-1.2-.6-2.4-.6-3.6zm16.4 171.7c2.9 .9 5.8 1.7 8.7 2.6c10.6 3.2 20.6 7.9 29.8 14l18.8 12.6c11.1 7.4 24 11.4 37.3 11.6c-12.8-.5-23.1-11-23.1-24c0-13.3 10.7-24 24-24s24 10.7 24 24c0 13-10.3 23.5-23.1 24c13.3-.2 26.2-4.2 37.3-11.6L393 231.9c9.2-6.1 19.2-10.9 29.8-14l8.7-2.6c-26.1-13.9-52.2-27.8-78.2-41.7c-7.1-3.8-13-9.2-17.3-15.7c-4.3 6.5-10.2 11.9-17.3 15.7c-26.1 13.9-52.2 27.8-78.2 41.7zM413.3 36.5l19.1-4.2c.9-.2 1.8-.3 2.8-.3l1.3 0c6.4 0 11.5 5.2 11.5 11.5c0 1.2-.2 2.5-.6 3.6L440 69.4 413.6 37l-.3-.4zm66.3 258.6c0 .4-.1 .9-.1 1.3l.5-.4-.3-.9z", "M64 32c35.3 0 64 28.7 64 64l0 32L0 128 0 96C0 60.7 28.7 32 64 32zm64 192L0 224l0-64 128 0 0 64zm-16 32c-14.5 19.3-26.1 40.8-34.3 64L0 320l0-64 112 0zM391.6 86.1L478 116.2l6.3 7.7c7.6 9.3 11.7 21 11.7 33c0 23.1-15.2 43.5-37.3 50.2l-27.1 8.1-78.2-41.7c-7.1-3.8-13-9.2-17.3-15.7c-4.3 6.5-10.2 11.9-17.3 15.7l-78.2 41.7-27.1-8.1c-22.2-6.6-37.3-27-37.3-50.2c0-12 4.1-23.7 11.7-33l6.3-7.7 86.4-30.1c21.7-7.5 44 1.4 55.6 18.6c11.5-17.3 33.9-26.2 55.6-18.6zM312 232a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm-8-104a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm80 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]]
}, faHandPointDown = {
  prefix: "fad",
  iconName: "hand-point-down",
  icon: [384, 512, [], "f0a7", ["M0 149l0 27c0 35.3 28.7 64 64 64l88 0c22.1 0 40-17.9 40-40s-17.9-40-40-40l-56 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l56 0c39.8 0 72 32.2 72 72l0 .6c9.4-5.4 20.3-8.6 32-8.6c13.2 0 25.4 4 35.6 10.8c8.7-24.9 32.5-42.8 60.4-42.8c11.7 0 22.6 3.1 32 8.6l0-8.6C384 71.6 312.4 0 224 0L162.3 0C119.8 0 79.1 16.9 49.1 46.9L37.5 58.5C13.5 82.5 0 115.1 0 149zM32 272l0 208c0 17.7 14.3 32 32 32s32-14.3 32-32l0-208-64 0z", "M352 320c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32zm-128 0l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32zm-96 32l0-48c0-17.7 14.3-32 32-32s32 14.3 32 32l0 48c0 17.7-14.3 32-32 32s-32-14.3-32-32z"]]
}, faArrowUpFromBracket = {
  prefix: "fad",
  iconName: "arrow-up-from-bracket",
  icon: [448, 512, [], "e09a", ["M0 352l0 64c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M201.4 9.4c12.5-12.5 32.8-12.5 45.3 0l128 128c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L256 109.3 256 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-210.7-73.4 73.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l128-128z"]]
}, faHeadSideGear = {
  prefix: "fad",
  iconName: "head-side-gear",
  icon: [512, 512, [], "e611", ["M0 224.2c0 49.9 16.6 98.2 46.9 137.3c10.2 13.2 17.1 29 17.1 45.8L64 480c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-32 64 0c35.3 0 64-28.7 64-64l0-64 20.2 0c24.2 0 43.8-19.6 43.8-43.8c0-10-3.4-19.6-9.6-27.4l-42-52.6c-8.3-10.3-12.8-23-15.1-36C429.2 69.3 343.2 0 248 0L224 0C100.2 0 0 100.6 0 224.2zM104.5 178c2.1-5.5 4.6-10.8 7.4-15.9l2.3-3.9c3.1-5.1 6.5-10 10.2-14.6c4.6-5.7 12.7-6.7 19-3l2.9 1.7c9.2 5.3 20.4 4 29.6-1.3s16.1-14.5 16.1-25.1l0-3.4c0-7.3 4.9-13.8 12.1-14.9c6.5-1 13.1-1.5 19.9-1.5s13.4 .5 19.9 1.5c7.2 1.1 12.1 7.6 12.1 14.9l0 3.4c0 10.6 6.9 19.8 16.1 25.1s20.4 6.6 29.6 1.3l2.9-1.7c6.3-3.6 14.4-2.6 19 3c3.7 4.6 7.1 9.5 10.2 14.5l2.3 4c2.8 5.1 5.3 10.4 7.4 15.9c2.6 6.8-.5 14.3-6.8 18l-3 1.7c-9.2 5.3-13.7 15.8-13.7 26.4s4.5 21.1 13.7 26.4l3 1.7c4.8 2.8 7.8 7.8 7.8 13c0 1.7-.3 3.3-.9 5c-2.1 5.5-4.6 10.7-7.4 15.8l-2.4 4.2c-3 5.1-6.4 9.9-10.1 14.5c-4.6 5.7-12.7 6.7-19 3l-2.9-1.7c-9.2-5.3-20.4-4-29.6 1.3s-16.1 14.5-16.1 25.1l0 3.4c0 7.3-4.9 13.8-12.1 14.9c-6.5 1-13.1 1.5-19.9 1.5s-13.4-.5-19.9-1.5c-7.2-1.1-12.1-7.6-12.1-14.9l0-3.4c0-10.6-6.9-19.8-16.1-25.1s-20.4-6.6-29.6-1.3l-2.9 1.7c-6.3 3.6-14.4 2.6-19-3c-3.7-4.6-7.1-9.4-10.1-14.5l-2.4-4.1c-2.8-5.1-5.3-10.4-7.4-15.8c-2.6-6.8 .5-14.3 6.8-18l3-1.7c9.2-5.3 13.7-15.8 13.7-26.4s-4.5-21.1-13.7-26.4l-2.9-1.7c-6.3-3.6-9.5-11.1-6.8-18z", "M343.5 178c2.6 6.8-.5 14.3-6.8 18l-3 1.7c-9.2 5.3-13.7 15.8-13.7 26.4s4.5 21.1 13.7 26.4l3 1.7c6.3 3.6 9.5 11.1 6.8 18c-2.1 5.5-4.6 10.7-7.4 15.8l-2.4 4.2c-3 5.1-6.4 9.9-10.1 14.5c-4.6 5.7-12.7 6.7-19 3l-2.9-1.7c-9.2-5.3-20.4-4-29.6 1.3s-16.1 14.5-16.1 25.1l0 3.4c0 7.3-4.9 13.8-12.1 14.9c-6.5 1-13.1 1.5-19.9 1.5s-13.4-.5-19.9-1.5c-7.2-1.1-12.1-7.6-12.1-14.9l0-3.4c0-10.6-6.9-19.8-16.1-25.1s-20.4-6.6-29.6-1.3l-2.9 1.7c-6.3 3.6-14.4 2.6-19-3c-3.7-4.6-7.1-9.4-10.1-14.5l-2.4-4.1c-2.8-5.1-5.3-10.4-7.4-15.8c-2.6-6.8 .5-14.3 6.8-18l3-1.7c9.2-5.3 13.7-15.8 13.7-26.4s-4.5-21.1-13.7-26.4l-2.9-1.7c-6.3-3.6-9.5-11.1-6.8-18c2.1-5.5 4.6-10.8 7.4-15.9l2.3-3.9c3.1-5.1 6.5-10 10.2-14.6c4.6-5.7 12.7-6.7 19-3l2.9 1.7c9.2 5.3 20.4 4 29.6-1.3s16.1-14.5 16.1-25.1l0-3.4c0-7.3 4.9-13.8 12.1-14.9c6.5-1 13.1-1.5 19.9-1.5s13.4 .5 19.9 1.5c7.2 1.1 12.1 7.6 12.1 14.9l0 3.4c0 10.6 6.9 19.8 16.1 25.1s20.4 6.6 29.6 1.3l2.9-1.7c6.3-3.6 14.4-2.6 19 3c3.7 4.6 7.1 9.5 10.2 14.5l2.3 4c2.8 5.1 5.3 10.4 7.4 15.9zM224 264a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]]
}, faTrashPlus = {
  prefix: "fad",
  iconName: "trash-plus",
  icon: [448, 512, [], "e2b2", ["M32 96L53.4 466.8c1.5 25.4 22.5 45.2 47.9 45.2l245.4 0c25.4 0 46.5-19.8 47.9-45.2L416 96 32 96zm80 192c0-13.3 10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64-64 0c-13.3 0-24-10.7-24-24z", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0L284.2 0c12.1 0 23.2 6.8 28.6 17.7L320 32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 7.2-14.3zM200 376l0-64-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]]
}, faFileCad = {
  prefix: "fad",
  iconName: "file-cad",
  icon: [512, 512, [], "e672", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-208 0c-35.3 0-64 28.7-64 64l0 144-48 0c-35.3 0-64-28.7-64-64L0 64z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM200 352c-22.1 0-40 17.9-40 40l0 80c0 22.1 17.9 40 40 40l16 0c22.1 0 40-17.9 40-40l0-8c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 8c0 4.4-3.6 8-8 8l-16 0c-4.4 0-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8l16 0c4.4 0 8 3.6 8 8l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8c0-22.1-17.9-40-40-40l-16 0zm232 0c-8.8 0-16 7.2-16 16l0 128c0 8.8 7.2 16 16 16l32 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-32 0zm16 32l16 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-16 0 0-96zm-160 8l0 56 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 32 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 0-56c0-22.1-17.9-40-40-40l-16 0c-22.1 0-40 17.9-40 40zm32 40l0-40c0-4.4 3.6-8 8-8l16 0c4.4 0 8 3.6 8 8l0 40-32 0z"]]
}, faObjectsAlignTop = {
  prefix: "fad",
  iconName: "objects-align-top",
  icon: [512, 512, [], "e3c0", ["M64 176l0 288c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48zm224 0l0 160c0 26.5 21.5 48 48 48l64 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-64 0c-26.5 0-48 21.5-48 48z", "M0 24C0 10.7 10.7 0 24 0H488c13.3 0 24 10.7 24 24s-10.7 24-24 24H24C10.7 48 0 37.3 0 24z"]]
}, faFolder = {
  prefix: "fad",
  iconName: "folder",
  icon: [512, 512, [128193, 128447, 61716, "folder-blank"], "f07b", ["M64 480H448c35.3 0 64-28.7 64-64V160c0-35.3-28.7-64-64-64H288c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32H64C28.7 32 0 60.7 0 96V416c0 35.3 28.7 64 64 64z", ""]]
}, faFolderBlank = faFolder, faFaceAnxiousSweat = {
  prefix: "fad",
  iconName: "face-anxious-sweat",
  icon: [576, 512, [], "e36a", ["M32 256c0 1.1 0 2.2 0 3.3c16.3-7.1 36.4-2.8 48 12.8c7 9.2 18.1 24.6 27.7 40.7c4.8 8.1 9.6 17 13.2 25.7c3.4 8 7.1 19 7.1 30.5c0 24.5-11.1 46-28.4 60.3C146.4 480.2 213.5 512 288 512c141.4 0 256-114.6 256-256S429.4 0 288 0S32 114.6 32 256zm80.2-45.4c-1.5-8.7 4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c3.1-3.1 7.2-4.7 11.3-4.7s8.2 1.6 11.3 4.7c6.2 6.2 6.2 16.4 0 22.6l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2zM239.6 272a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM208 400c0-44.2 35.8-80 80-80s80 35.8 80 80c0 8.8-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16zM399.6 272a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM348.7 148.7c3.1-3.1 7.2-4.7 11.3-4.7s8.2 1.6 11.3 4.7l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c7.8 1.3 13.4 8.1 13.4 15.8c0 .9-.1 1.8-.2 2.6c-1.5 8.7-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4c-6.2-6.2-6.2-16.4 0-22.6z", "M227.3 171.3l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2s4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zM239.6 272a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm160 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM348.7 148.7c6.2-6.2 16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4c-6.2-6.2-6.2-16.4 0-22.6zM48 416c-26.5 0-48-21-48-47c0-20 28.6-60.4 41.6-77.7c3.2-4.4 9.6-4.4 12.8 0C67.6 308.6 96 349 96 369c0 26-21.5 47-48 47z"]]
}, faCreditCardBlank = {
  prefix: "fad",
  iconName: "credit-card-blank",
  icon: [576, 512, [], "f389", ["M96 368c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm128 0c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-128 0c-8.8 0-16 7.2-16 16z", "M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM96 368c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16zm128 0c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16z"]]
}, faFileWaveform = {
  prefix: "fad",
  iconName: "file-waveform",
  icon: [448, 512, ["file-medical-alt"], "f478", ["M64 64C64 28.7 92.7 0 128 0L288 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64l-256 0c-35.3 0-64-28.7-64-64l0-128 65.2 0 41.4 82.7c4.2 8.5 13 13.6 22.5 13.2s17.8-6.3 21.3-15.1l44.2-110.4 8.1 16.2c4.1 8.1 12.4 13.3 21.5 13.3l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-41.2 0-25.4-50.7c-4.2-8.5-13-13.6-22.5-13.2s-17.8 6.3-21.3 15.1L189.6 333.5l-24.1-48.2c-4.1-8.1-12.4-13.3-21.5-13.3l-80 0L64 64z", "M448 160L288 0l0 128c0 17.7 14.3 32 32 32l128 0zM277.5 221.3c-4.2-8.5-13-13.6-22.5-13.2s-17.8 6.3-21.3 15.1L189.6 333.5l-24.1-48.2c-4.1-8.1-12.4-13.3-21.5-13.3L24 272c-13.3 0-24 10.7-24 24s10.7 24 24 24l105.2 0 41.4 82.7c4.2 8.5 13 13.6 22.5 13.2s17.8-6.3 21.3-15.1l44.2-110.4 8.1 16.2c4.1 8.1 12.4 13.3 21.5 13.3l56 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-41.2 0-25.4-50.7z"]]
}, faFileMedicalAlt = faFileWaveform, faMicrochipAi = {
  prefix: "fad",
  iconName: "microchip-ai",
  icon: [512, 512, [], "e1ec", ["M0 152c0 13.3 10.7 24 24 24l40 0 0-48-40 0c-13.3 0-24 10.7-24 24zM0 256c0 13.3 10.7 24 24 24l40 0 0-48-40 0c-13.3 0-24 10.7-24 24zM0 360c0 13.3 10.7 24 24 24l40 0 0-48-40 0c-13.3 0-24 10.7-24 24zM128 24l0 40 48 0 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24zm0 424l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40-48 0zM232 24l0 40 48 0 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24zm0 424l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40-48 0zM336 24l0 40 48 0 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24zm0 424l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40-48 0zM448 128l0 48 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0zm0 104l0 48 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0zm0 104l0 48 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0z", "M128 64c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L128 64zm94.7 121.6l42 96 14 32c3.5 8.1-.1 17.5-8.2 21.1s-17.5-.2-21.1-8.2L239.5 304l-63.1 0-9.8 22.4c-3.5 8.1-13 11.8-21.1 8.2s-11.8-13-8.2-21.1l14-32 42-96c2.5-5.8 8.3-9.6 14.7-9.6s12.1 3.8 14.7 9.6zM208 231.9L190.5 272l35.1 0L208 231.9zM352 192l0 128c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-128c0-8.8 7.2-16 16-16s16 7.2 16 16z"]]
}, faMug = {
  prefix: "fad",
  iconName: "mug",
  icon: [576, 512, [], "f874", ["M384 64c17.7 0 32 14.3 32 32l0 32 32 0c35.3 0 64 28.7 64 64s-28.7 64-64 64l-32 0 0 64 32 0c70.7 0 128-57.3 128-128s-57.3-128-128-128l-64 0z", "M32 96c0-17.7 14.3-32 32-32H384c17.7 0 32 14.3 32 32V352c0 53-43 96-96 96H128c-53 0-96-43-96-96V96z"]]
}, faPlaneUpSlash = {
  prefix: "fad",
  iconName: "plane-up-slash",
  icon: [640, 512, [], "e22e", ["M64 305.1l0 56.7c0 10.9 10.7 18.6 21.1 15.2L256 320l0 80-57.6 43.2c-4 3-6.4 7.8-6.4 12.8l0 42c0 7.8 6.3 14 14 14c1.3 0 2.6-.2 3.9-.5L320 480l110.1 31.5c1.3 .4 2.6 .5 3.9 .5c7.8 0 14-6.3 14-14l0-42.7c0-2.8-.7-5.6-2.1-8L161.3 223.1 78.2 278.5C69.3 284.4 64 294.4 64 305.1zM245.4 167.1c79 61.9 158 123.8 237 185.8L554.9 377c10.4 3.5 21.1-4.3 21.1-15.2l0-56.7c0-10.7-5.3-20.7-14.2-26.6L384 160l0-66.3C384 59.5 356 0 320 0c-35 0-64 59.5-64 93.7l0 66.3-10.6 7.1z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faRadiation = {
  prefix: "fad",
  iconName: "radiation",
  icon: [512, 512, [], "f7b9", ["M208 256a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M176 256c0-29.6 16.1-55.5 40-69.3L144 62c-8.8-15.3-28.6-20.7-42.7-10C47.8 92.7 10.7 154 2 224.1C-.2 241.6 14.3 256 32 256l144 0zm40 69.3L144 450.1c-8.8 15.3-3.7 35.1 12.6 41.9c30.6 12.9 64.2 20 99.4 20s68.9-7.1 99.4-20c16.3-6.9 21.4-26.6 12.6-41.9L296 325.3c-11.8 6.8-25.4 10.7-40 10.7s-28.2-3.9-40-10.7zM336 256l144 0c17.7 0 32.2-14.4 30-31.9C501.3 154 464.2 92.7 410.7 52c-14.1-10.7-33.8-5.3-42.7 10L296 186.7c23.9 13.8 40 39.7 40 69.3z"]]
}, faPenCircle = {
  prefix: "fad",
  iconName: "pen-circle",
  icon: [512, 512, [], "e20e", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM128.5 364l15-60.1c1.4-5.6 4.3-10.8 8.4-14.9L257.1 183.8l71 71L222.9 359.9c-4.1 4.1-9.2 7-14.9 8.4l-60.1 15c-5.5 1.4-11.2-.2-15.2-4.2s-5.6-9.7-4.2-15.2zM279.8 161.1l21.4-21.4c15.6-15.6 40.9-15.6 56.6 0l14.4 14.4c7.8 7.8 11.7 18 11.7 28.3s-3.9 20.5-11.7 28.3l-21.4 21.4-71-71z", "M301.2 139.7l-21.4 21.4 71 71 21.4-21.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4c-15.6-15.6-40.9-15.6-56.6 0zm-44 44L151.9 289c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L328.1 254.7l-71-71z"]]
}, faBagSeedling = {
  prefix: "fad",
  iconName: "bag-seedling",
  icon: [512, 512, [], "e5f2", ["M32 247.2l0 17.7c0 36.6 4.5 73.1 13.4 108.7L64 448l384 0 18.6-74.5c8.9-35.5 13.4-72 13.4-108.7l0-17.7c0-36.6-4.5-73.1-13.4-108.7L448 64 64 64 45.4 138.5C36.5 174 32 210.5 32 247.2zM128 176c0-8.8 7.2-16 16-16l2 0c47.3 0 88.4 26 110 64.5C277.6 186 318.7 160 366 160l2 0c8.8 0 16 7.2 16 16c0 59.2-45.9 107.6-104 111.7l0 40.3c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-40.3c-58.1-4.1-104-52.6-104-111.7z", "M38.6 38.6L64 64l384 0 25.4-25.4c4.2-4.2 6.6-10 6.6-16C480 10.1 469.9 0 457.4 0L54.6 0C42.1 0 32 10.1 32 22.6c0 6 2.4 11.8 6.6 16zm0 434.7c-4.2 4.2-6.6 10-6.6 16C32 501.9 42.1 512 54.6 512l402.7 0c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L448 448 64 448 38.6 473.4zM144 160c-8.8 0-16 7.2-16 16c0 59.2 45.9 107.6 104 111.7l0 40.3c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40.3c58.1-4.1 104-52.6 104-111.7c0-8.8-7.2-16-16-16l-2 0c-47.3 0-88.4 26-110 64.5C234.4 186 193.3 160 146 160l-2 0z"]]
}, faChartSimple = {
  prefix: "fad",
  iconName: "chart-simple",
  icon: [448, 512, [], "e473", ["M160 80c0-26.5 21.5-48 48-48l32 0c26.5 0 48 21.5 48 48l0 352c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-352z", "M368 96c-26.5 0-48 21.5-48 48l0 288c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-32 0zM48 224c-26.5 0-48 21.5-48 48L0 432c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-32 0z"]]
}, faCrutches = {
  prefix: "fad",
  iconName: "crutches",
  icon: [640, 512, [], "f7f8", ["M0 192c0 8.2 3.1 16.4 9.4 22.6c12.5 12.5 32.8 12.5 45.3 0l1.4-1.4L188.2 345.4c2.7 2.7 5.5 5.1 8.4 7.5l17-17 10.1-45.5L101.3 168 168 101.3l86.3 86.3c5-7.9 10.9-15.3 17.6-22l25.4-25.4L213.3 56l1.4-1.4c12.5-12.5 12.5-32.8 0-45.3C208.4 3.1 200.2 0 192 0s-16.4 3.1-22.6 9.4l-160 160C3.1 175.6 0 183.8 0 192zM367.2 412.4l90.2 90.2c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-64.1-64.1c-8.6 4-17.6 7.1-26.9 9.2l-44.5 9.9zm58.2-403c-12.5 12.5-12.5 32.8 0 45.3c.5 .5 .9 .9 1.4 1.4L472 101.3c22.3 22.3 44.5 44.5 66.7 66.7L584 213.3l1.4 1.4c12.5 12.5 32.8 12.5 45.3 0c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6l-160-160C464.4 3.1 456.2 0 448 0s-16.4 3.1-22.6 9.4z", "M329.4 153.4L426.7 56 472 101.3 397.3 176 464 242.7 538.7 168 584 213.3l-97.3 97.3-.1 .1-.1 .1-34.7 34.7c-12.9 12.9-29.2 21.9-47.1 25.8L297.1 395.2c-5.9 1.3-11.4 4.3-15.7 8.6l-98.8 98.8c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l98.8-98.8c4.3-4.3 7.3-9.7 8.6-15.7l23.9-107.6c4-17.8 12.9-34.1 25.8-47.1l34.8-34.8zM352 221.3l-12.2 12.2c-4.3 4.3-7.3 9.7-8.6 15.7l-17 76.7 76.7-17c5.9-1.3 11.4-4.3 15.7-8.6L418.7 288 352 221.3z"]]
}, faCircleParking = {
  prefix: "fad",
  iconName: "circle-parking",
  icon: [512, 512, ["parking-circle"], "f615", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm448 0A192 192 0 1 1 64 256a192 192 0 1 1 384 0z", "M240 192l0 64 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-48 0zm144 32c0 53-43 96-96 96l-48 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64 0-120c0-22.1 17.9-40 40-40l72 0c53 0 96 43 96 96z"]]
}, faParkingCircle = faCircleParking, faMarsStroke = {
  prefix: "fad",
  iconName: "mars-stroke",
  icon: [512, 512, [9894], "f229", ["M128 304a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M376 0c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l33.4 33.4L370.3 96.4 345 71c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l25.4 25.4L307.8 159c-28.4-19.5-62.7-31-99.8-31c-97.2 0-176 78.8-176 176s78.8 176 176 176s176-78.8 176-176c0-37-11.4-71.4-31-99.8l28.6-28.6L407 201c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-25.4-25.4 22.1-22.1L471 153c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-112c0-13.3-10.7-24-24-24L376 0zm88 48s0 0 0 0s0 0 0 0s0 0 0 0zM96 304a112 112 0 1 1 224 0A112 112 0 1 1 96 304z"]]
}, faLeafOak = {
  prefix: "fad",
  iconName: "leaf-oak",
  icon: [512, 512, [], "f6f7", ["M50.9 261.9L66.5 293C75.4 310.7 80 330.3 80 350.2l0 47.8c66.6-66.6 133.3-133.3 199.9-199.9c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7s7 10.8 7 17s-2.3 12.3-7 17C247.2 298.7 180.6 365.3 113.9 432l47.8 0c19.9 0 39.5 4.6 57.2 13.5l31.1 15.5c8.3 4.2 17.3 6.2 26.3 6.2c15.2 0 30.3-5.9 41.6-17.2l3.6-3.6c17.7-17.7 20.4-45.4 6.6-66.2c-3.1-4.7 .8-10.9 6.4-10.1l75.1 10.7c14.1 2 28.3-2.7 38.4-12.8c17.7-17.7 17.7-46.3 0-64l-22-22c-4.4-4.4-2.3-11.9 3.7-13.4l40.8-10.2c24.4-6.1 41.4-28 41.4-53.1c0-18.3-9.1-35.4-24.4-45.5l-14.3-9.5c-5.6-3.8-8.3-10.6-6.6-17.2l5-20.1c5.1-20.4-.9-42-15.8-56.9s-36.5-20.9-56.9-15.8l-20.1 5c-6.6 1.6-13.4-1-17.2-6.6l-9.5-14.3C342.1 9.1 325 0 306.7 0c-25.1 0-47 17.1-53.1 41.4L243.4 82.3c-1.5 6-9 8.1-13.4 3.7L208 64c-17.7-17.7-46.3-17.7-64 0c-10.1 10.1-14.8 24.3-12.8 38.4l10.7 75.1c.8 5.6-5.4 9.5-10.1 6.4C111 170 83.3 172.7 65.6 190.4l-3.6 3.6c-17.9 17.9-22.3 45.2-11 67.8z", "M7 505c-9.4-9.4-9.4-24.6 0-33.9L279.9 198.1c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L41 505c-9.4 9.4-24.6 9.4-33.9 0z"]]
}, faSquareBolt = {
  prefix: "fad",
  iconName: "square-bolt",
  icon: [448, 512, [], "e265", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM112.9 261.3c-2.2-6.4-.2-13.5 5.1-17.8l160-128c2.9-2.3 6.5-3.5 10-3.5c3.6 0 7.1 1.2 10.1 3.6c5.8 4.7 7.6 12.9 4.3 19.6L249.9 240l70.1 0c6.8 0 12.9 4.3 15.1 10.7s.2 13.5-5.1 17.8l-160 128c-2.9 2.3-6.5 3.5-10 3.5c-3.6 0-7.1-1.2-10.1-3.6c-5.8-4.7-7.6-12.9-4.3-19.6L198.1 272 128 272c-6.8 0-12.8-4.3-15.1-10.7z", "M302.3 135.2c3.4-6.7 1.6-14.9-4.3-19.6s-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7l70.1 0L145.7 376.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7l-70.1 0 52.4-104.8z"]]
}, faVial = {
  prefix: "fad",
  iconName: "vial",
  icon: [512, 512, [129514], "f492", ["M0 410.5L0 416c0 53 43 96 96 96l5.5 0c25.5 0 49.9-10.1 67.9-28.1L448 205.3l9.4 9.4c12.5 12.5 32.8 12.5 45.3 0c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6l-32-32-96-96-32-32C336.4 3.1 328.2 0 320 0s-16.4 3.1-22.6 9.4c-12.5 12.5-12.5 32.8 0 45.3l9.4 9.4L28.1 342.6C10.1 360.6 0 385 0 410.5zm64 0c0-8.5 3.4-16.6 9.4-22.6L205.3 256c48.9-48.9 97.8-97.8 146.7-146.7L402.7 160c-32 32-64 64-96 96C245.9 316.9 185 377.7 124.1 438.6c-6 6-14.1 9.4-22.6 9.4L96 448c-17.7 0-32-14.3-32-32l0-5.5z", "M306.7 256l-101.5 0L73.4 387.9c-6 6-9.4 14.1-9.4 22.6l0 5.5c0 17.7 14.3 32 32 32l5.5 0c8.5 0 16.6-3.4 22.6-9.4L306.7 256z"]]
}, faGauge = {
  prefix: "fad",
  iconName: "gauge",
  icon: [512, 512, ["dashboard", "gauge-med", "tachometer-alt-average"], "f624", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48-112a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm16 208c0-26.9 16.5-49.9 40-59.3L232 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 204.7c23.5 9.5 40 32.5 40 59.3c0 35.3-28.7 64-64 64s-64-28.7-64-64zM400 144a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48 112a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M280 88c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 204.7c-23.5 9.5-40 32.5-40 59.3c0 35.3 28.7 64 64 64s64-28.7 64-64c0-26.9-16.5-49.9-40-59.3L280 88z"]]
}, faDashboard = faGauge, faGaugeMed = faGauge, faTachometerAltAverage = faGauge, faWandMagicSparkles = {
  prefix: "fad",
  iconName: "wand-magic-sparkles",
  icon: [576, 512, ["magic-wand-sparkles"], "e2ca", ["M0 128c0 4.8 3 9.1 7.5 10.8L64 160l21.2 56.5c1.7 4.5 6 7.5 10.8 7.5s9.1-3 10.8-7.5L128 160l56.5-21.2c4.5-1.7 7.5-6 7.5-10.8s-3-9.1-7.5-10.8L128 96 106.8 39.5C105.1 35 100.8 32 96 32s-9.1 3-10.8 7.5L64 96 7.5 117.2C3 118.9 0 123.2 0 128zM192 64c0 3.2 2 6.1 5 7.2l37.7 14.1L248.8 123c1.1 3 4 5 7.2 5s6.1-2 7.2-5l14.1-37.7L315 71.2c3-1.1 5-4 5-7.2s-2-6.1-5-7.2L277.3 42.7 263.2 5c-1.1-3-4-5-7.2-5s-6.1 2-7.2 5L234.7 42.7 197 56.8c-3 1.1-5 4-5 7.2zm124.7 60.7c13.2 13.2 26.4 26.4 39.6 39.6l105-105 23.3 23.3-105 105c13.2 13.2 26.4 26.4 39.6 39.6c36.9-36.9 73.8-73.8 110.7-110.7c18.7-18.7 18.7-49.1 0-67.9L495.3 14.1c-18.7-18.7-49.1-18.7-67.9 0C390.5 51 353.6 87.8 316.7 124.7zM352 384c0 4.8 3 9.1 7.5 10.8L416 416l21.2 56.5c1.7 4.5 6 7.5 10.8 7.5s9.1-3 10.8-7.5L480 416l56.5-21.2c4.5-1.7 7.5-6 7.5-10.8s-3-9.1-7.5-10.8L480 352l-21.2-56.5c-1.7-4.5-6-7.5-10.8-7.5s-9.1 3-10.8 7.5L416 352l-56.5 21.2c-4.5 1.7-7.5 6-7.5 10.8z", "M419.2 227.2L316.7 124.7 46.1 395.4c-18.7 18.7-18.7 49.1 0 67.9l34.6 34.6c18.7 18.7 49.1 18.7 67.9 0L419.2 227.2z"]]
}, faMagicWandSparkles = faWandMagicSparkles, faLambda = {
  prefix: "fad",
  iconName: "lambda",
  icon: [448, 512, [], "f66e", ["M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l108.2 0 16.4 32.7L18.8 434.9c-7.3 16.1-.1 35.1 16 42.3s35.1 .1 42.3-16L193.5 202.6l121 242c10.8 21.7 33 35.4 57.2 35.4l44.2 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-44.2 0L197.5 67.4C186.6 45.7 164.5 32 140.2 32L32 32z", ""]]
}, faE = {
  prefix: "fad",
  iconName: "e",
  icon: [320, 512, [101], "45", ["M64 32C28.7 32 0 60.7 0 96L0 256 0 416c0 35.3 28.7 64 64 64l224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 416l0-128 160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 224 64 96l224 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L64 32z", ""]]
}, faPizza = {
  prefix: "fad",
  iconName: "pizza",
  icon: [576, 512, [127829], "f817", ["M48.1 251.2c0-1.8 .1-3.6 .2-5.4c.1-1.1 .1-2.2 .2-3.3c0-.8 .1-1.6 .2-2.3c.1-.8 .1-1.6 .2-2.4c1.5-17.6 5.3-34.9 11.3-51.7c.3-.9 .6-1.8 1-2.7c.1-.3 .2-.7 .4-1c.6-1.5 1.1-3 1.8-4.6c1.3-3.1 2.6-6.2 4.1-9.5c.6-1.4 1.3-2.8 2-4.2c.7-1.4 1.4-2.8 2.1-4.1c3.3-6.3 6.9-12.4 10.7-18.3c.2-.2 .3-.5 .5-.7c1.8-2.7 3.7-5.4 5.7-8.1c2-2.7 4-5.4 6.3-8.1c2.2-2.7 4.5-5.4 6.9-8c1.2-1.3 2.4-2.6 3.6-3.9s2.5-2.6 3.8-3.8c2.5-2.5 5.1-5 7.8-7.4s5.3-4.7 8.2-7c2.6-2.1 5.3-4.2 8-6.2c8.5-6.3 17.5-11.8 26.7-16.7c3-1.6 6-3 9-4.5s6.1-2.7 9.4-4.1c1.2-.5 2.4-.9 3.5-1.4c.3-.1 .5-.2 .8-.3c1.4-.5 2.8-1 4.2-1.5c.2-.1 .4-.2 .6-.2c3.1-1.1 6.2-2.1 9.3-3l.6-.2c3-.9 6.1-1.7 9.2-2.5s6.1-1.4 9.2-2c3.6-.7 7.3-1.3 10.9-1.9c3.2-.5 6.4-.8 9.5-1.1l.4 0c3.3-.3 6.7-.5 10-.7c1.6-.1 3.2-.1 4.8-.2s3.2-.1 4.8-.1c3.6 0 7.1 .1 10.6 .3c3.5 .2 6.9 .4 10.3 .8c3.6 .3 7.1 .8 10.6 1.3c3.3 .5 6.6 1.1 9.8 1.7c3.6 .7 7.1 1.5 10.6 2.4c3.2 .8 6.4 1.7 9.6 2.7c1.8 .5 3.5 1.1 5.3 1.7c1.5 .5 2.9 1 4.4 1.5c3.3 1.2 6.5 2.4 9.6 3.8c3.1 1.3 6.2 2.7 9.3 4.2c3 1.4 6 3 8.9 4.6c2.9 1.6 5.7 3.2 8.5 4.9c3.1 1.9 6.1 3.8 9.1 5.9c2.7 1.8 5.3 3.7 7.9 5.6c2.6 2 5.1 4 7.6 6c2.6 2.1 5.1 4.3 7.5 6.5s4.9 4.5 7.2 6.9L278.6 233.4c-12.5 12.5-12.5 32.8 0 45.3L403.1 403.1c-2.4 2.4-4.8 4.6-7.2 6.9s-5 4.4-7.5 6.5c-2.5 2.1-5.1 4.1-7.6 6c-2.6 1.9-5.2 3.8-7.9 5.7c-.3 .2-.6 .4-.8 .6c-2.7 1.8-5.5 3.6-8.3 5.3c-2.8 1.7-5.6 3.3-8.5 4.9c-2.9 1.6-5.9 3.1-9 4.6c-3 1.4-6.1 2.8-9.2 4.2c-3.1 1.3-6.3 2.6-9.4 3.7c-3.1 1.1-6.2 2.2-9.3 3.2c-3.4 1.1-6.7 2-10.2 2.9c-3.2 .8-6.4 1.6-9.6 2.2c-3.6 .8-7.2 1.4-10.8 1.9c-3.4 .5-6.8 .9-10.1 1.3c-.5 .1-1 .1-1.5 .1c-1 .1-1.9 .2-2.9 .3c-.4 0-.8 .1-1.2 .1c-1.7 .1-3.4 .2-5 .3c-3.6 .2-7.2 .3-10.8 .3c-3.3 0-6.6-.1-9.9-.2c-3.3-.2-6.6-.4-9.8-.7c-3.3-.3-6.6-.7-10-1.2c-3.1-.4-6.2-.9-9.2-1.5c-.6-.1-1.1-.2-1.7-.3c-3.1-.6-6.2-1.3-9.2-2s-6.1-1.6-9.2-2.5c-3.3-1-6.6-2-9.9-3.2c-3.1-1.1-6.2-2.3-9.4-3.6c-3.1-1.3-6.2-2.6-9.4-4.1c-1.4-.7-2.8-1.3-4.2-2c-.4-.2-.8-.4-1.2-.6c-.5-.3-1-.5-1.5-.8c-.7-.4-1.5-.8-2.2-1.2c-2.9-1.6-5.8-3.2-8.6-4.8c-3.2-1.9-6.4-3.9-9.5-5.9c-2.8-1.9-5.5-3.8-8.2-5.7c-2.7-2-5.5-4.1-8.1-6.3c-2.7-2.2-5.4-4.5-8-6.9c-1.3-1.2-2.6-2.4-3.9-3.6s-2.6-2.5-3.9-3.8c-2.5-2.5-5-5.1-7.5-7.8c-1.1-1.2-2.2-2.5-3.3-3.7l-.4-.4c-.8-.9-1.5-1.8-2.2-2.7c-.4-.4-.7-.8-1-1.3c-2.1-2.6-4.2-5.3-6.2-8c-2.2-3-4.3-6.1-6.4-9.2c-1.8-2.8-3.6-5.6-5.3-8.5c-1.7-3-3.4-6-5-9c-1.6-3-3-6-4.5-9s-2.7-6.1-4.1-9.4c-.5-1.2-.9-2.3-1.4-3.5c-.1-.3-.2-.6-.3-.9c-.5-1.4-1-2.8-1.5-4.2c-5.9-16.6-9.6-33.8-11.1-51.2c-.1-.8-.1-1.6-.2-2.4c-.1-.7-.1-1.4-.2-2.3c-.1-1.1-.1-2.2-.2-3.3c-.2-3.4-.3-6.9-.3-10.3c0-1.6 0-3.3 .1-4.8zM128 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64-128a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm32 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM366.6 233.4c37.3-37.3 74.6-74.6 112-112C509.4 157.7 528 204.7 528 256s-18.6 98.3-49.4 134.6c-37.3-37.3-74.6-74.6-112-112c-12.5-12.5-12.5-32.8 0-45.3zM416 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M403.1 403.1C365.4 440.7 313.4 464 256 464C141.1 464 48 370.9 48 256S141.1 48 256 48c57.4 0 109.4 23.3 147.1 60.9l11.3-11.3C426.9 85.1 427 64.7 413 53.8C369.7 20.1 315.2 0 256 0C114.6 0 0 114.6 0 256S114.6 512 256 512c59.2 0 113.7-20.1 157-53.8c13.9-10.9 13.8-31.3 1.3-43.8l-11.3-11.3zm75.5-12.5l9.9 9.9c13.1 13.1 34.7 12.5 44.9-3C560.3 357 576 308.3 576 256s-15.7-101-42.6-141.5c-10.2-15.4-31.8-16-44.9-3l-9.9 9.9C509.4 157.7 528 204.7 528 256s-18.6 98.3-49.4 134.6zM192 128a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM128 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM256 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM416 256a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]]
}, faBowlChopsticksNoodles = {
  prefix: "fad",
  iconName: "bowl-chopsticks-noodles",
  icon: [512, 512, [], "e2ea", ["M0 109.3c0 9.8 8.8 17.3 18.5 15.8L64 118c0-11.3 0-22.7 0-34L13.1 93.6C5.5 95 0 101.6 0 109.3zm0 50.5c0 9 7.3 16.2 16.2 16.2L64 176c0-11.3 0-22.7 0-34l-48.3 1.5C7 143.8 0 151 0 159.7zM224 54l0 39L492.3 51.1c11.3-1.8 19.7-11.5 19.7-23C512 15 501.3 4.8 488.8 4.8c-1.4 0-2.9 .1-4.3 .4L224 54zm0 83l0 39 264.4 0c13 0 23.6-10.6 23.6-23.6c0-13.3-11-24-24.4-23.6L224 137z", "M192 40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 184-32 0 0-168c0-13.3-10.7-24-24-24S64 42.7 64 56l0 168-30.4 0C15.4 224 .9 239.3 2 257.5c5.4 91.7 59.7 169.7 136.4 209.7l1.2 9.7c2.5 20 19.5 35 39.7 35l153.4 0c20.2 0 37.2-15 39.7-35l1.2-9.7c76.8-40 131-118 136.4-209.7c1.1-18.2-13.4-33.5-31.6-33.5L192 224l0-184z"]]
}, faH3 = {
  prefix: "fad",
  iconName: "h3",
  icon: [640, 512, [], "f315", ["M0 96L0 256 0 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 192 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128L64 224 64 96c0-17.7-14.3-32-32-32S0 78.3 0 96z", "M368 96c0-17.7 14.3-32 32-32l192 0c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-89.5 89.5C589 210.8 640 263.4 640 328c0 66.3-53.7 120-120 120l-64.6 0c-43 0-79.7-31.1-86.8-73.5l-.2-1.2c-2.9-17.4 8.9-33.9 26.3-36.8s33.9 8.9 36.8 26.3l.2 1.2c1.9 11.6 11.9 20.1 23.7 20.1l64.6 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-72 0c-12.9 0-24.6-7.8-29.6-19.8s-2.2-25.7 6.9-34.9L514.7 128 400 128c-17.7 0-32-14.3-32-32z"]]
}, faPenClip = {
  prefix: "fad",
  iconName: "pen-clip",
  icon: [512, 512, ["pen-alt"], "f305", ["M288 94.1c5.7 5.7 11.3 11.3 17 17c32 32 64 64 96 96c5.3 5.3 10.7 10.7 16 16l1 1c24.9-24.9 49.8-49.8 74.7-74.7c12.5-12.5 18.7-28.9 18.7-45.3s-6.2-32.8-18.7-45.3L453.3 19.3C440.8 6.8 424.4 .6 408 .6s-32.8 6.2-45.3 18.7L288 94.1z", "M207 114.9c9.4-9.4 24.6-9.4 33.9 0L254.1 128 99.5 282.5c-48 48-80.8 109.2-94.1 175.8l-5 25c-1.6 7.9 .9 16 6.6 21.7s13.8 8.1 21.7 6.6l25-5c66.6-13.3 127.8-46.1 175.8-94.1L401 241l17-17-1-1-16-16-96-96-17-17L274.9 81c-28.1-28.1-73.7-28.1-101.8 0L71 183c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L207 114.9z"]]
}, faPenAlt = faPenClip, faBridgeCircleExclamation = {
  prefix: "fad",
  iconName: "bridge-circle-exclamation",
  icon: [640, 512, [], "e4ca", ["M32 64c0-17.7 14.3-32 32-32l512 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-40 0 0 64 72 0 0 72.2C577.6 207.1 538.5 192 496 192c-69.1 0-128.9 39.8-157.7 97.7c-5.9-1.1-12-1.7-18.3-1.7c-53 0-96 43-96 96l0 64c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-64c0-53-43-96-96-96l0-128 72 0 0-64L64 96C46.3 96 32 81.7 32 64zM152 96l0 64 80 0 0-64-80 0zm128 0l0 64 80 0 0-64-80 0zm128 0l0 64 80 0 0-64-80 0z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80z"]]
}, faBadgePercent = {
  prefix: "fad",
  iconName: "badge-percent",
  icon: [512, 512, [], "f646", ["M0 256c0 36.8 20.7 68.8 51.1 84.9C41 373.8 49 411 75 437s63.3 34 96.1 23.9C187.2 491.3 219.2 512 256 512s68.8-20.7 84.9-51.1C373.8 471 411 463 437 437s34-63.3 23.9-96.1C491.3 324.8 512 292.8 512 256s-20.7-68.8-51.1-84.9C471 138.2 463 101 437 75s-63.3-34-96.1-23.9C324.8 20.7 292.8 0 256 0s-68.8 20.7-84.9 51.1C138.2 41 101 49 75 75s-34 63.3-23.9 96.1C20.7 187.2 0 219.2 0 256zm224-64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM175 303L303 175c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L209 337c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9zm177 17a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M224 192a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM352 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM337 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L175 303c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L337 209z"]]
}, faRotateReverse = {
  prefix: "fad",
  iconName: "rotate-reverse",
  icon: [512, 512, [], "e631", ["M44.5 330.6C55.3 361.3 73 390 97.4 414.4C141.1 458.1 198.4 480 255.8 480c56.9 0 113.8-21.5 157.4-64.6L454.8 457c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-119.6 0-.4 0-.4 0-7.6c0-13.3-10.7-24-24-24l-7.6 0c-.2 0-.5 0-.7 0l-119.6 0c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l41.1 41.1c-62.6 61.5-163.1 61.2-225.3-1c-17.5-17.5-30.1-38-37.8-59.8c-4.6-13.1-17-21.4-30.2-21.4c-3.5 0-7.1 .6-10.6 1.8c-16.7 5.9-25.4 24.2-19.5 40.8z", "M406.6 202.6c-7.7-21.8-20.2-42.3-37.8-59.8c-62.2-62.2-162.7-62.5-225.3-1L184.7 183c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8L48.3 224c0 0 0 0 0 0l-8.4 0c-13.3 0-24-10.7-24-24l0-128c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2L98.3 96.6c87.6-86.5 228.7-86.2 315.8 1c24.4 24.4 42.1 53.1 52.9 83.7c5.9 16.7-2.9 34.9-19.5 40.8s-34.9-2.9-40.8-19.5z"]]
}, faUser = {
  prefix: "fad",
  iconName: "user",
  icon: [448, 512, [128100, 62144], "f007", ["M96 128a128 128 0 1 0 256 0A128 128 0 1 0 96 128z", "M0 482.3C0 383.8 79.8 304 178.3 304h91.4C368.2 304 448 383.8 448 482.3c0 16.4-13.3 29.7-29.7 29.7H29.7C13.3 512 0 498.7 0 482.3z"]]
}, faSensor = {
  prefix: "fad",
  iconName: "sensor",
  icon: [448, 512, [], "e028", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm64 24c0-13.3 10.7-24 24-24s24 10.7 24 24l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144zm96 0c0-13.3 10.7-24 24-24s24 10.7 24 24l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144z", "M88 96c13.3 0 24 10.7 24 24l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24zm96 0c13.3 0 24 10.7 24 24l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144c0-13.3 10.7-24 24-24z"]]
}, faComma = {
  prefix: "fad",
  iconName: "comma",
  icon: [192, 512, [], "2c", ["M160 350.4V349c0-33.7-27.3-61-61-61c-29.5 0-54.8 21.1-60.1 50.1l-22.2 122c-.5 2.6-.7 5.2-.7 7.9v8.2C16 495.9 32.1 512 51.9 512c12.5 0 24.1-6.5 30.6-17.2L150.8 383c6-9.8 9.2-21.1 9.2-32.6z", ""]]
}, faSchoolCircleCheck = {
  prefix: "fad",
  iconName: "school-circle-check",
  icon: [640, 512, [], "e56b", ["M0 144L0 464c0 26.5 21.5 48 48 48l272 0-64 0 0-96c0-35.3 28.7-64 64-64l.7 0c3.4-37.7 18.7-72.1 42.2-99.1C350.2 260 335.6 264 320 264c-48.6 0-88-39.4-88-88s39.4-88 88-88s88 39.4 88 88c0 18.3-5.6 35.3-15.1 49.4c29-21 64.6-33.4 103.1-33.4c59.5 0 112.1 29.6 144 74.8L640 144c0-26.5-21.5-48-48-48L473.7 96 337.8 5.4C332.4 1.8 326.2 0 320 0s-12.4 1.8-17.8 5.4L166.3 96 48 96C21.5 96 0 117.5 0 144zm80 64c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zm0 128c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zM304 144l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-16c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]]
}, faToiletPaperUnder = {
  prefix: "fad",
  iconName: "toilet-paper-under",
  icon: [512, 512, ["toilet-paper-reverse"], "e2a0", ["M0 192C0 298 43 384 96 384l32 0 32 0 256 0c-52.4 0-94.9-83.9-96-188.1c0-1.3 0-2.6 0-3.9C320 86 363 0 416 0L96 0C43 0 0 86 0 192zm80 16a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm64 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M320 195.9c1 104.2 43.6 188.1 96 188.1l-256 0 0 80c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48l0-272C512 86 469 0 416 0s-96 86-96 192c0 1.3 0 2.6 0 3.9zM448 192c0 35.3-14.3 64-32 64s-32-28.7-32-64s14.3-64 32-64s32 28.7 32 64zM80 208a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm64 0a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]]
}, faToiletPaperReverse = faToiletPaperUnder, faLightEmergency = {
  prefix: "fad",
  iconName: "light-emergency",
  icon: [448, 512, [], "e41f", ["M64 192l0 160 320 0 0-160c0-88.4-71.6-160-160-160S64 103.6 64 192zm48 0c0-61.9 50.1-112 112-112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.2 0-80 35.8-80 80c0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M32 352c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L32 352z"]]
}, faArrowDownToArc = {
  prefix: "fad",
  iconName: "arrow-down-to-arc",
  icon: [512, 512, [], "e4ae", ["M0 256C0 397.4 114.6 512 256 512s256-114.6 256-256c0-17.7-14.3-32-32-32s-32 14.3-32 32c0 106-86 192-192 192S64 362 64 256c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M390.6 185.4c12.5 12.5 12.5 32.8 0 45.3l-112 112c-12.5 12.5-32.8 12.5-45.3 0l-112-112c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L224 242.7 224 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 210.7 57.4-57.4c12.5-12.5 32.8-12.5 45.3 0z"]]
}, faDumpster = {
  prefix: "fad",
  iconName: "dumpster",
  icon: [576, 512, [], "f793", ["M0 139.1c0-2.1 .3-4.1 .9-6.1L26.8 48.9C29.9 38.9 39.2 32 49.7 32l90.8 0L114.9 160l-94 0C9.3 160 0 150.7 0 139.1zM147.5 160L173.1 32 272 32l0 128-124.5 0zM304 32l98.9 0 25.6 128L304 160l0-128zm131.5 0l90.8 0c10.5 0 19.8 6.9 22.9 16.9L575.1 133c.6 2 .9 4.1 .9 6.1c0 11.5-9.3 20.9-20.9 20.9l-94 0L435.5 32z", "M64 448L44 288l-12 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l4 0-4-32 512 0-4 32 4 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-12 0L512 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l-320 0c0 17.7-14.3 32-32 32s-32-14.3-32-32z"]]
}, faVanShuttle = {
  prefix: "fad",
  iconName: "van-shuttle",
  icon: [640, 512, [128656, "shuttle-van"], "f5b6", ["M80 400a80 80 0 1 0 160 0A80 80 0 1 0 80 400zm320 0a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M64 104c0-4.4 3.6-8 8-8l88 0 0 96-96 0 0-88zm482 88l-162 0 0-96 81.1 0L546 192zm-226 0l-96 0 0-96 96 0 0 96zM72 32C32.2 32 0 64.2 0 104L0 336c0 26.5 21.5 48 48 48l1.1 0c7.8-54.3 54.4-96 110.9-96s103.1 41.7 110.9 96l98.3 0c7.8-54.3 54.4-96 110.9-96s103.1 41.7 110.9 96l1.1 0c26.5 0 48-21.5 48-48l0-108.3c0-15.1-5.3-29.7-15-41.2L514.1 54.8C501.9 40.3 484 32 465.1 32L352 32 192 32 72 32z"]]
}, faShuttleVan = faVanShuttle, faBuildingUser = {
  prefix: "fad",
  iconName: "building-user",
  icon: [640, 512, [], "e4da", ["M0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 223.8 0 95.9c-38.2 21.4-64 62.3-64 109.2c0 12.9 3.6 24.9 9.9 35.1L240 512l0-80c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 80-96 0c-26.5 0-48-21.5-48-48L0 48zm64 64l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L80 96c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M496 352a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm-50.9 32c-51.4 0-93.1 41.7-93.1 93.1c0 19.3 15.6 34.9 34.9 34.9l218.2 0c19.3 0 34.9-15.6 34.9-34.9c0-51.4-41.7-93.1-93.1-93.1l-101.8 0z"]]
}, faLightSwitch = {
  prefix: "fad",
  iconName: "light-switch",
  icon: [384, 512, [], "e017", ["M96 240l0 32 192 0 0-32L96 240z", "M0 64C0 28.7 28.7 0 64 0L320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zm96 96l0 192c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64l-64 0c-35.3 0-64 28.7-64 64zM208 48a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm0 416a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]]
}, faSquareCaretLeft = {
  prefix: "fad",
  iconName: "square-caret-left",
  icon: [448, 512, ["caret-square-left"], "f191", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM128 256c0-6.7 2.8-13 7.7-17.6l112-104c4.5-4.2 10.4-6.4 16.3-6.4c3.2 0 6.5 .7 9.6 2c8.7 3.8 14.4 12.5 14.4 22l0 208c0 9.5-5.7 18.2-14.4 22c-3.1 1.3-6.3 2-9.6 2c-5.9 0-11.8-2.2-16.3-6.4l-112-104c-4.9-4.5-7.7-10.9-7.7-17.6z", "M135.7 238.4c-4.9 4.5-7.7 10.9-7.7 17.6s2.8 13 7.7 17.6l112 104c7 6.5 17.2 8.2 25.9 4.4s14.4-12.5 14.4-22l0-208c0-9.5-5.7-18.2-14.4-22s-18.9-2.1-25.9 4.4l-112 104z"]]
}, faCaretSquareLeft = faSquareCaretLeft, faHighlighter = {
  prefix: "fad",
  iconName: "highlighter",
  icon: [576, 512, [], "f591", ["M61.3 400c0 3.5 .6 7 1.7 10.4c1.5 4.5 4.1 8.7 7.6 12.2c16.9 16.9 33.8 33.8 50.7 50.7c3.6 3.6 7.8 6.1 12.2 7.6c3.4 1.2 6.9 1.7 10.4 1.7c8.2 0 16.4-3.1 22.6-9.4L224 416l71.7 0c15.3 0 29.6-7.2 38.6-19.5l26.3-35.8L183.3 183.3l-35.7 26.3c-12.3 9-19.5 23.4-19.5 38.6l0 71.7c-19.1 19.1-38.2 38.3-57.4 57.4c-6.2 6.2-9.4 14.4-9.4 22.6z", "M360.7 360.7L183.3 183.3 420.6 8.4C428 2.9 437 0 446.2 0c11.4 0 22.4 4.5 30.5 12.6l54.8 54.8c8.1 8.1 12.6 19 12.6 30.5c0 9.2-2.9 18.2-8.4 25.6L360.7 360.7zM7 466.3l56-56c1.5 4.5 4.1 8.7 7.6 12.2l50.7 50.7c3.6 3.6 7.8 6.1 12.2 7.6l-24 24c-4.5 4.5-10.6 7-17 7L24 512c-13.3 0-24-10.7-24-24l0-4.7c0-6.4 2.5-12.5 7-17z"]]
}, faWavePulse = {
  prefix: "fad",
  iconName: "wave-pulse",
  icon: [640, 512, ["heart-rate"], "f5f8", ["M319.1 0c14.8-.4 27.9 9.3 31.8 23.6l74 271.2 17.7-35.4c10.8-21.7 33-35.4 57.2-35.4L608 224c17.7 0 32 14.3 32 32s-14.3 32-32 32l-108.2 0L444.6 398.3c-5.9 11.9-18.6 18.8-31.8 17.5s-24.2-10.6-27.7-23.4L323.7 167.3 255.3 486.7c-3.1 14.4-15.5 24.8-30.2 25.3s-27.8-9.1-31.8-23.2L135.9 288 32 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l103.9 0c28.6 0 53.7 18.9 61.5 46.4L219.6 348 288.7 25.3C291.8 10.9 304.4 .4 319.1 0z", ""]]
}, faHeartRate = faWavePulse, faKey = {
  prefix: "fad",
  iconName: "key",
  icon: [512, 512, [128273], "f084", ["M0 408l0 80c0 13.3 10.7 24 24 24l80 0c13.3 0 24-10.7 24-24l0-40 40 0c13.3 0 24-10.7 24-24l0-40 40 0c6.4 0 12.5-2.5 17-7c11.1-11.1 22.2-22.2 33.3-33.3c-38-38-76-76-113.9-113.9C114.6 283.5 60.8 337.2 7 391c-4.5 4.5-7 10.6-7 17z", "M168.3 229.7L282.3 343.7s0 0 0 0c16.9 5.4 35 8.3 53.7 8.3c97.2 0 176-78.8 176-176S433.2 0 336 0S160 78.8 160 176c0 18.7 2.9 36.8 8.3 53.7c0 0 0 0 0 0zM336 136a40 40 0 1 1 80 0 40 40 0 1 1 -80 0z"]]
}, faArrowLeftToBracket = {
  prefix: "fad",
  iconName: "arrow-left-to-bracket",
  icon: [512, 512, [], "e669", ["M0 128L0 384c0 53 43 96 96 96l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0c-17.7 0-32-14.3-32-32l0-256c0-17.7 14.3-32 32-32l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 32C43 32 0 75 0 128z", "M169.4 233.4c-12.5 12.5-12.5 32.8 0 45.3l128 128c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L269.3 288 480 288c17.7 0 32-14.3 32-32s-14.3-32-32-32l-210.7 0 73.4-73.4c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0l-128 128z"]]
}, faHatSanta = {
  prefix: "fad",
  iconName: "hat-santa",
  icon: [640, 512, [], "f7a7", ["M0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64s-28.7-64-64-64L64 352c-35.3 0-64 28.7-64 64zM480 240c0 12.7 9.8 23 22.2 23.9c-8.1 9.4-7.7 23.7 1.2 32.6s23.2 9.4 32.6 1.2C537 310.2 547.3 320 560 320s23-9.8 23.9-22.2c9.4 8.1 23.7 7.7 32.6-1.2s9.4-23.2 1.2-32.6C630.2 263 640 252.7 640 240s-9.8-23-22.2-23.9c8.1-9.4 7.7-23.7-1.2-32.6s-23.2-9.4-32.6-1.2C583 169.8 572.7 160 560 160s-23 9.8-23.9 22.2c-7.7-6.7-18.7-7.6-27.3-2.8c-1.9 1.1-3.7 2.4-5.3 4c-8.9 8.9-9.4 23.2-1.2 32.6c-3.9 .3-7.5 1.5-10.7 3.4c-6.9 4.2-11.6 11.8-11.6 20.5z", "M64 352l85.7-214.2C175.2 73.9 237.1 32 305.9 32c49.5 0 96.5 21.8 128.5 59.6l74.3 87.8c-1.9 1.1-3.7 2.4-5.3 4c-8.9 8.9-9.4 23.2-1.2 32.6c-3.9 .3-7.5 1.5-10.7 3.4L402 192.6c-1.3-.4-2.7-.6-4-.6l-.8 0c-7.3 0-13.2 5.9-13.2 13.2c0 1.8 .4 3.7 1.1 5.4L448 352 64 352z"]]
}, faTamale = {
  prefix: "fad",
  iconName: "tamale",
  icon: [320, 512, [129748], "e451", ["M.4 69.3L28.9 240l57.7 0L72 72.7c-.4-4.4 2.9-8.3 7.3-8.7s8.3 2.9 8.7 7.3L102.6 240l49.4 0 0-176c0-4.4 3.6-8 8-8s8 3.6 8 8l0 176 49.4 0L232 71.3c.4-4.4 4.3-7.7 8.7-7.3s7.7 4.3 7.3 8.7L233.4 240l57.7 0L319.6 69.3c.3-1.8 .4-3.6 .4-5.3c0-13.8-9.5-24.1-20.8-31.6c-6.3-4.2-15.3-9.3-27.4-14.1C247.7 8.6 211.6 0 160 0S72.3 8.6 48.1 18.3c-12.1 4.8-21 9.9-27.4 14.1C8.1 40.8-2.3 52.8 .4 69.3zm0 373.5c-1.7 10.2 1.6 20.6 8.9 27.9c10.6 10.6 25.1 17.6 38.7 23.1C72.3 503.4 108.4 512 160 512s87.7-8.6 111.9-18.3c13.7-5.5 28.1-12.5 38.7-23c7.3-7.3 10.7-17.7 9-27.9L291.1 272l-57.7 0L248 439.3c.4 4.4-2.9 8.3-7.3 8.7s-8.3-2.9-8.7-7.3l-9.8-113.3c-1.1 2.1-2.6 3.9-4.6 5.4c-2.9 2.2-6.3 3.2-9.6 3.2c-4.9 0-9.7-2.2-12.8-6.4L168 293.3 168 448c0 4.4-3.6 8-8 8s-8-3.6-8-8l0-154.7-27.2 36.3c-3.2 4.2-8 6.4-12.8 6.4c-3.3 0-6.7-1-9.6-3.2c-1-.8-1.9-1.6-2.6-2.5s-1.4-1.9-1.9-2.9L88 440.7c-.4 4.4-4.3 7.7-8.7 7.3s-7.7-4.3-7.3-8.7L86.6 272l-57.7 0L.4 442.7zM99.3 310.2c9.6-12.7 19.1-25.5 28.7-38.2l-25.4 0-3.3 38.2zM192 272c9.6 12.7 19.1 25.5 28.8 38.4c-1.2-12.9-2.3-25.6-3.4-38.4L192 272z", "M24 240c-8.8 0-16 7.2-16 16s7.2 16 16 16l104 0L99.2 310.4c-5.3 7.1-3.9 17.1 3.2 22.4s17.1 3.9 22.4-3.2L160 282.7l35.2 46.9c5.3 7.1 15.3 8.5 22.4 3.2s8.5-15.3 3.2-22.4L192 272l104 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-136 0L24 240z"]]
}, faBoxCheck = {
  prefix: "fad",
  iconName: "box-check",
  icon: [448, 512, [], "f467", ["M0 160l208 0 0-128L93.7 32C75.5 32 58.9 42.3 50.7 58.5L0 160zM240 32l0 128 208 0L397.3 58.5C389.1 42.3 372.5 32 354.3 32L240 32z", "M448 160l-208 0 0-128-32 0 0 128L0 160 0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-256zM337 265L209 393c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L303 231c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9z"]]
}, faBullhorn = {
  prefix: "fad",
  iconName: "bullhorn",
  icon: [512, 512, [128226, 128363], "f0a1", ["M192 128l0 32 0 32 0 96 0 32 0 32 8.7 0c67.9 0 133 27 181 75l43.6 43.6c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6l0-147.6 0-120.7L480 32c0-12.9-7.8-24.6-19.8-29.6C456.3 .8 452.1 0 448 0c-8.3 0-16.5 3.3-22.6 9.4L381.7 53c-48 48-113.1 75-181 75c-2.9 0-5.8 0-8.7 0z", "M0 192c0-35.3 28.7-64 64-64l128 0 0 192 0 32 0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-128c-35.3 0-64-28.7-64-64l0-96zm512 48c0 27.9-13.4 51.6-32 60.4l0-120.7c18.6 8.8 32 32.5 32 60.4z"]]
}, faSteak = {
  prefix: "fad",
  iconName: "steak",
  icon: [576, 512, [129385], "f824", ["M0 360c0 84.3 73.4 120.1 110 132.7c43.5 15 93.3 19.3 130 19.3c81.7 0 162.1-30.8 222.6-75.8C520.9 392.8 576 323.9 576 240c0-60.4-23.6-117.6-57.5-160C485.7 39 433 0 368 0c-38.3 0-72.3 12.4-99.2 37.4c-23.5 21.9-36.3 48.9-44.1 66.5c-4.4 10.1-8 18.9-11.2 26.6c-10.4 25.1-16.2 39.1-30 52.9c-23.1 23.1-50.4 36.9-77.7 50.7c-21.8 11-43.6 22.1-63.3 37.8C17.8 291.7 0 321.4 0 360zm64 9.5c0-29.8 19.8-38.3 51.7-51.9c31.1-13.3 73.6-31.5 120.6-79c28.1-28.5 41.9-62.8 54.2-93.4C308.4 100.7 323.1 64 374.2 64C443.1 64 512 151.3 512 238.5C512 343.3 370.9 448 236.3 448C167.4 448 64 430.5 64 369.5z", "M236.3 448C167.4 448 64 430.5 64 369.5c0-29.8 19.8-38.3 51.7-51.9c31.1-13.3 73.6-31.5 120.6-79c28.1-28.5 41.9-62.8 54.2-93.4C308.4 100.7 323.1 64 374.2 64C443.1 64 512 151.3 512 238.5C512 343.3 370.9 448 236.3 448zM384 256a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faLocationCrosshairsSlash = {
  prefix: "fad",
  iconName: "location-crosshairs-slash",
  icon: [640, 512, ["location-slash"], "f603", ["M64 256c0 17.7 14.3 32 32 32l34.7 0c13.5 80.4 76.9 143.9 157.3 157.3l0 34.7c0 17.7 14.3 32 32 32s32-14.3 32-32l0-34.7c22.6-3.8 43.8-11.5 62.9-22.4l-56.8-44.7C346.1 382 333.3 384 320 384c-70.7 0-128-57.3-128-128c0-2.9 .1-5.7 .3-8.5l-56.8-44.7c-2 6.9-3.6 14-4.8 21.3L96 224c-17.7 0-32 14.3-32 32zM184.9 119.6c17 13.3 34 26.6 51 40C258.3 139.9 287.8 128 320 128c70.7 0 128 57.3 128 128c0 21.2-5.1 41.1-14.2 58.7c17 13.3 34 26.6 51 40c12.1-20.1 20.6-42.6 24.6-66.6l34.7 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-34.7 0C495.9 143.6 432.4 80.1 352 66.7L352 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 34.7c-39.9 6.7-75.6 25.7-103.1 52.9zM274.7 190c40 31.4 80.1 62.8 120.2 94.2c3.3-8.8 5.1-18.3 5.1-28.2c0-44.2-35.8-80-80-80c-16.8 0-32.4 5.2-45.3 14z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faLocationSlash = faLocationCrosshairsSlash, faPersonDolly = {
  prefix: "fad",
  iconName: "person-dolly",
  icon: [512, 512, [], "f4d0", ["M200 192c0 1.9 .2 3.9 .7 5.8c2.2 8.7 4.4 17.5 6.5 26.2c5.3 21.3 10.7 42.7 16 64c9 36.1 18 72.2 27.1 108.3c-16 11.6-26.3 30.5-26.3 51.7c0 35.3 28.7 64 64 64c32.3 0 59.1-24 63.4-55.1l134.4-33.6c12.9-3.2 20.7-16.2 17.5-29.1s-16.2-20.7-29.1-17.5L339.7 410.3c-10-13.7-25.3-23.3-42.8-25.7L247.3 186.2C244.6 175.3 234.8 168 224 168c-1.9 0-3.9 .2-5.8 .7C207.3 171.4 200 181.2 200 192zM304 448a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm-8.2-186.6L318.6 353c4.3 17.1 21.7 27.6 38.8 23.3L449 353.4c17.1-4.3 27.6-21.7 23.3-38.8L449.4 223c-4.3-17.1-21.7-27.6-38.8-23.3L319 222.6c-17.1 4.3-27.6 21.7-23.3 38.8z", "M80 96A48 48 0 1 0 80 0a48 48 0 1 0 0 96zM96 306.7l0-65.1 16.6 24.9c8.9 13.4 23.9 21.4 39.9 21.4l70.7 0-16-64-46.1 0-42.6-64c-13.3-20-35.8-32-59.9-32C26.2 128 0 154.2 0 186.6l0 88.1c0 17 6.7 33.3 18.7 45.3l79.4 79.4 14.3 85.9c2.9 17.4 19.4 29.2 36.8 26.3s29.2-19.4 26.3-36.8l-15.2-90.9c-1.6-9.9-6.3-19-13.4-26.1l-51-51zM0 346.5L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32c0 0 0 0 0 0l0-69.5-64-64z"]]
}, faGlobe = {
  prefix: "fad",
  iconName: "globe",
  icon: [512, 512, [127760], "f0ac", ["M0 256c0-22.1 2.8-43.5 8.1-64c41 0 82.1 0 123.1 0c-1 10.3-1.8 20.8-2.4 31.6c-.1 2.6-.2 5.3-.4 8.1c-.1 2.5-.2 5-.2 7.5l0 .6c-.1 2.6-.1 5.1-.1 7.5l0 .4c0 2.6 0 5.2-.1 7.7l0 .4c0 8.2 .2 16.4 .5 24.5c.1 2.6 .2 5.3 .3 7.9c.5 10.7 1.3 21.3 2.4 31.6L8.1 320C2.8 299.5 0 278.1 0 256zm18.6-96C48.5 86.3 111.6 29.6 189.5 8.7c-25 34.6-44.3 88-54.2 151.3c-38.9 0-77.8 0-116.6 0zm0 192l116.6 0c9.9 63.3 29.2 116.7 54.2 151.3C111.6 482.4 48.5 425.7 18.6 352zM160.5 231.4c.1-2.7 .2-5.4 .4-8.1c.6-10.7 1.4-21.1 2.5-31.4c61.8 0 123.6 0 185.3 0c2.2 20.4 3.3 41.9 3.3 64c0 22.1-1.2 43.5-3.3 64c-61.8 0-123.6 0-185.3 0c-1.1-10.2-1.9-20.7-2.5-31.4c-.3-5.4-.5-10.9-.6-16.4c-.1-2.7-.1-5.3-.2-8c0-2.6-.1-5.2-.1-7.8l0-.4c0-.1 0-.3 0-.4c0-2.8 0-5.5 .1-8.2c0-2.5 .1-5.1 .2-7.6l0-.6c.1-2.5 .2-5.1 .3-7.7zm7.2-71.4c6.1-36.7 15.5-69.2 27.1-95.5c10.5-23.8 22.2-41.2 33.6-52.1c6.8-6.5 12.8-10.2 18.1-12.2c3.2-.1 6.3-.2 9.5-.2s6.3 .1 9.5 .2c5.3 1.9 11.4 5.7 18.1 12.2c11.4 10.9 23.1 28.3 33.6 52.1c11.6 26.3 21 58.8 27.1 95.5c-58.9 0-117.8 0-176.7 0zm0 192l176.7 0c-6.1 36.7-15.5 69.2-27.1 95.5c-10.5 23.8-22.2 41.2-33.6 52.1c-6.8 6.5-12.8 10.2-18.1 12.2c-3.2 .1-6.3 .2-9.5 .2s-6.3-.1-9.5-.2c-5.3-1.9-11.4-5.7-18.1-12.2c-11.4-10.9-23.1-28.3-33.6-52.1c-11.6-26.3-21-58.8-27.1-95.5zM322.5 8.7c77.8 20.9 141 77.5 170.9 151.3c-38.9 0-77.8 0-116.6 0C366.9 96.7 347.5 43.3 322.5 8.7zm0 494.6c25-34.6 44.3-88 54.2-151.3l116.6 0c-29.8 73.7-93 130.4-170.9 151.3zM380.8 192c41 0 82.1 0 123.1 0c5.3 20.5 8.1 41.9 8.1 64s-2.8 43.5-8.1 64l-123.1 0c2.1-20.6 3.2-42 3.2-64c0-22-1.1-43.4-3.2-64z", "M344.3 352c-6.1 36.7-15.5 69.2-27.1 95.5c-10.5 23.8-22.2 41.2-33.6 52.1c-6.8 6.5-12.8 10.2-18.1 12.2c19.7-.7 38.7-3.6 57-8.6c25-34.6 44.3-88 54.2-151.3l116.6 0c4.2-10.3 7.7-21 10.5-32l-123.1 0c2.1-20.6 3.2-42 3.2-64s-1.1-43.4-3.2-64l123.1 0c-2.8-11-6.4-21.7-10.5-32l-116.6 0C366.9 96.7 347.5 43.3 322.5 8.7c-18.3-4.9-37.4-7.8-57-8.6c5.3 1.9 11.4 5.7 18.1 12.2c11.4 10.9 23.1 28.3 33.6 52.1c11.6 26.3 21 58.8 27.1 95.5l-176.7 0c6.1-36.7 15.5-69.2 27.1-95.5c10.5-23.8 22.2-41.2 33.6-52.1c6.8-6.5 12.8-10.2 18.1-12.2c-19.7 .7-38.7 3.6-57 8.6c-25 34.6-44.4 88-54.2 151.3L18.6 160c-4.2 10.3-7.7 21-10.5 32l123.1 0c-2.1 20.6-3.2 42-3.2 64s1.1 43.4 3.2 64L8.1 320c2.8 11 6.4 21.7 10.5 32l116.6 0c9.9 63.3 29.2 116.7 54.2 151.3c18.3 4.9 37.4 7.8 57 8.6c-5.3-1.9-11.4-5.7-18.1-12.2c-11.4-10.9-23.1-28.3-33.6-52.1c-11.6-26.3-21-58.8-27.1-95.5l176.7 0zm7.7-96c0 22.1-1.2 43.6-3.3 64l-185.3 0c-2.2-20.4-3.3-41.9-3.3-64s1.2-43.6 3.3-64l185.3 0c2.2 20.4 3.3 41.9 3.3 64z"]]
}, faSynagogue = {
  prefix: "fad",
  iconName: "synagogue",
  icon: [640, 512, [128333], "f69b", ["M0 309.3L0 448c0 35.3 28.7 64 64 64l96 0 0-16 0-222.6L99.3 212.7c-3.1-3.1-7.2-4.7-11.3-4.7s-8.2 1.6-11.3 4.7L14.1 275.3c-9 9-14.1 21.2-14.1 33.9zm480-35.9L480 496l0 16 112 0c26.5 0 48-21.5 48-48l0-154.7c0-12.7-5.1-24.9-14.1-33.9l-62.6-62.6c-3.1-3.1-7.2-4.7-11.3-4.7s-8.2 1.6-11.3 4.7L480 273.4z", "M330.2 3.7c-5.9-4.9-14.6-4.9-20.5 0l-121 100.8C170.5 119.7 160 142.2 160 166l0 330 0 16 16 0 80 0 0-128c0-35.3 28.7-64 64-64s64 28.7 64 64l0 128 80 0 16 0 0-16 0-330c0-23.7-10.5-46.3-28.8-61.5L330.2 3.7zM313 124.3c3.1-5.4 10.9-5.4 13.9 0l15.9 28.1 32.3-.3c6.2-.1 10.1 6.7 7 12.1L365.7 192l16.4 27.8c3.2 5.4-.7 12.1-7 12.1l-32.3-.3L327 259.7c-3.1 5.4-10.9 5.4-13.9 0l-15.9-28.1-32.3 .3c-6.2 .1-10.1-6.7-7-12.1L274.3 192l-16.4-27.8c-3.2-5.4 .7-12.1 7-12.1l32.3 .3L313 124.3z"]]
}, faFileChartColumn = {
  prefix: "fad",
  iconName: "file-chart-column",
  icon: [384, 512, ["file-chart-line"], "f659", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM80 376l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48c0-13.3-10.7-24-24-24s-24 10.7-24 24zm88-128l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176c0-13.3-10.7-24-24-24s-24 10.7-24 24zm88 64l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM216 248c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176zm88 64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM128 376c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24s24-10.7 24-24l0-48z"]]
}, faFileChartLine = faFileChartColumn, faPersonHalfDress = {
  prefix: "fad",
  iconName: "person-half-dress",
  icon: [320, 512, [], "e548", ["M160 0c26.5 0 48 21.5 48 48s-21.5 48-48 48c0-32 0-64 0-96zm0 128l14.9 0c33.7 0 64.9 17.7 82.3 46.6l58.3 97c3.1 5.2 4.6 10.8 4.6 16.5c0 10.9-5.5 21.5-15.5 27.5c-15.1 9.1-34.8 4.2-43.9-10.9L232 256.9 232 480c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-128-8 0 0-224z", "M160 96l0-96s0 0 0 0c-26.5 0-48 21.5-48 48s21.5 48 48 48c0 0 0 0 0 0zm0 32l-5.8 0c-39.3 0-75.7 20.6-96 54.3L4.6 271.5c-9.1 15.1-4.2 34.8 10.9 43.9s34.8 4.2 43.9-10.9l33.9-56.3L55 362.9C51.6 373.3 59.3 384 70.2 384L88 384l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 8 0 0-256z"]]
}, faFolderImage = {
  prefix: "fad",
  iconName: "folder-image",
  icon: [512, 512, [], "e18a", ["M0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L288 96c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32L64 32C28.7 32 0 60.7 0 96zM98.4 402.4c-4-8.3-2.9-18.2 2.9-25.4l64-80c4.6-5.7 11.5-9 18.7-9s14.2 3.3 18.7 9c5.8 7.2 11.5 14.4 17.3 21.6l56-84C280.5 228 288 224 296 224s15.5 4 20 10.7l96 144c4.9 7.4 5.4 16.8 1.2 24.6S400.9 416 392 416l-144 0-48 0-80 0c-9.2 0-17.6-5.3-21.6-13.6zM176 224a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M296 224c8 0 15.5 4 20 10.7l96 144c4.9 7.4 5.4 16.8 1.2 24.6S400.9 416 392 416l-144 0-48 0-80 0c-9.2 0-17.6-5.3-21.6-13.6s-2.9-18.2 2.9-25.4l64-80c4.6-5.7 11.4-9 18.7-9s14.2 3.3 18.7 9l17.3 21.6 56-84C280.5 228 288 224 296 224z"]]
}, faCalendarPen = {
  prefix: "fad",
  iconName: "calendar-pen",
  icon: [448, 512, ["calendar-edit"], "f333", ["M0 192l448 0 0 272c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 192zM128.5 428c-1.4 5.5 .2 11.2 4.2 15.2c3 3 7.1 4.7 11.3 4.7c1.3 0 2.6-.2 3.9-.5l36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4l71.9-71.9L218 304.6l-71.9 71.9c-4.1 4.1-7 9.2-8.4 14.9L128.5 428zM240.6 282l53.3 53.3 14.9-14.9c14.7-14.7 14.7-38.6 0-53.3c-14.7-14.7-38.6-14.7-53.3 0L240.6 282z", "M128 0C110.3 0 96 14.3 96 32l0 32L48 64C21.5 64 0 85.5 0 112l0 80 448 0 0-80c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32zM308.8 267c-14.7-14.7-38.6-14.7-53.3 0L240.6 282l53.3 53.3 14.9-14.9c14.7-14.7 14.7-38.6 0-53.3zM146.1 376.5c-4.1 4.1-7 9.2-8.4 14.9L128.5 428c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4l71.9-71.9L218 304.6l-71.9 71.9z"]]
}, faCalendarEdit = faCalendarPen, faRoadBridge = {
  prefix: "fad",
  iconName: "road-bridge",
  icon: [640, 512, [], "e563", ["M0 128c0 17.7 14.3 32 32 32l40 0 0 64L0 224l0 96c53 0 96 43 96 96l0 64c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-64c0-53 43-96 96-96l0-96-40 0 0-64 40 0 0-64L32 96C14.3 96 0 110.3 0 128zm120 32l80 0 0 64-80 0 0-64z", "M608 0L352 0c-17.7 0-32 14.3-32 32l0 448c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-448c0-17.7-14.3-32-32-32zM504 224l0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24s24 10.7 24 24zM480 360c13.3 0 24 10.7 24 24l0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24zM504 64l0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64c0-13.3 10.7-24 24-24s24 10.7 24 24z"]]
}, faFaceSmileTear = {
  prefix: "fad",
  iconName: "face-smile-tear",
  icon: [512, 512, [], "e393", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm139.9 90.5c-5.8-6.7-5.1-16.8 1.6-22.6s16.8-5.1 22.6 1.6C182 346.2 212.6 368 256 368c8.8 0 16 7.2 16 16s-7.2 16-16 16c-55.1 0-93.8-27.9-116.1-53.5zM208.4 208a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM304 369c0-20 28.4-60.4 41.6-77.7c3.2-4.4 9.6-4.4 12.8 0C371.4 308.6 400 349 400 369c0 26-21.5 47-48 47s-48-21-48-47zm64.4-161a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M144.4 208a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM400 369c0 26-21.5 47-48 47s-48-21-48-47c0-20 28.4-60.4 41.6-77.7c3.2-4.4 9.6-4.4 12.8 0C371.4 308.6 400 349 400 369zM336.4 176a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]]
}, faMessagePlus = {
  prefix: "fad",
  iconName: "message-plus",
  icon: [512, 512, ["comment-alt-plus"], "f4a8", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM144 208c0 13.3 10.7 24 24 24l64 0 0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24z", "M232 232l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0z"]]
}, faCommentAltPlus = faMessagePlus, faLocationArrow = {
  prefix: "fad",
  iconName: "location-arrow",
  icon: [448, 512, [], "f124", ["M429.6 92.1c4.9-11.9 2.1-25.6-7-34.7s-22.8-11.9-34.7-7l-352 144c-14.2 5.8-22.2 20.8-19.3 35.8s16.1 25.8 31.4 25.8l176 0 0 176c0 15.3 10.8 28.4 25.8 31.4s30-5.1 35.8-19.3l144-352z", ""]]
}, faC = {
  prefix: "fad",
  iconName: "c",
  icon: [384, 512, [99], "43", ["M329.1 142.9c-62.5-62.5-155.8-62.5-218.3 0s-62.5 163.8 0 226.3s155.8 62.5 218.3 0c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3c-87.5 87.5-221.3 87.5-308.8 0s-87.5-229.3 0-316.8s221.3-87.5 308.8 0c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0z", ""]]
}, faTabletButton = {
  prefix: "fad",
  iconName: "tablet-button",
  icon: [448, 512, [], "f10a", ["M0 384l448 0 0 64c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64l0-64zm192 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M0 64C0 28.7 28.7 0 64 0H384c35.3 0 64 28.7 64 64V384H0V64z"]]
}, faPersonDressFairy = {
  prefix: "fad",
  iconName: "person-dress-fairy",
  icon: [640, 512, [], "e607", ["M0 64l0 48c0 86.7 40.6 163.9 103.7 213.7C78.7 360 64 402.3 64 448c0 17.7 14.3 32 32 32l16 0c55.9 0 106.6-22 144-57.9l0-38.1-21.6 0c-21.3 0-36.6-20.3-30.8-40.8l39.1-136.8c.3-1.1 .7-2.2 1-3.3s.8-2.1 1.2-3.2c.9-2.1 1.8-4.1 2.9-6.1c2.1-3.9 4.6-7.6 7.4-11c5.7-6.7 12.7-12.2 20.6-16.2C224.8 85.8 134.7 32 32 32C14.3 32 0 46.3 0 64zM364.2 166.7c15.8 7.8 28 22 33.1 39.8l39.1 136.8c.8 3 1.3 5.9 1.3 8.8c0 17.1-13.9 31.9-32 31.9L384 384l0 38.1C421.4 458 472.1 480 528 480l16 0c17.7 0 32-14.3 32-32c0-45.7-14.7-88-39.7-122.3C599.4 275.9 640 198.7 640 112l0-48c0-17.7-14.3-32-32-32C505.3 32 415.2 85.8 364.2 166.7z", "M256 64a64 64 0 1 1 128 0A64 64 0 1 1 256 64zM242.7 206.4c7.8-27.5 33-46.4 61.5-46.4l31.5 0c28.6 0 53.7 18.9 61.5 46.4l39.1 136.8c5.8 20.4-9.5 40.8-30.8 40.8L384 384l0 80c0 26.5-21.5 48-48 48l-32 0c-26.5 0-48-21.5-48-48l0-80-21.6 0c-21.3 0-36.6-20.3-30.8-40.8l39.1-136.8z"]]
}, faRectangleHistoryCircleUser = {
  prefix: "fad",
  iconName: "rectangle-history-circle-user",
  icon: [640, 512, [], "e4a4", ["M0 224L0 448c0 35.3 28.7 64 64 64l330.8 0C349.5 480.1 320 427.5 320 368c0-97.2 78.8-176 176-176c2.5 0 5 .1 7.5 .2c-11-19.2-31.8-32.2-55.5-32.2L64 160c-35.3 0-64 28.7-64 64zM48 104c0 13.3 10.7 24 24 24l368 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L72 80c-13.3 0-24 10.7-24 24zM96 24c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L120 0C106.7 0 96 10.7 96 24z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-32c-30.2 0-57.5-11.9-77.7-31.3c6.2-19 24-32.7 45.1-32.7l65.2 0c21 0 38.9 13.7 45.1 32.7C553.5 468.1 526.2 480 496 480zm0-192a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]]
}, faBuildingLock = {
  prefix: "fad",
  iconName: "building-lock",
  icon: [576, 512, [], "e4d6", ["M0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 145.6c-19.8 20.2-32 47.9-32 78.4l0 24.6c-19.1 11.1-32 31.7-32 55.4l0 128c0 11.7 3.1 22.6 8.6 32L240 512l0-80c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 80-96 0c-26.5 0-48-21.5-48-48L0 48zm64 64l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L80 96c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M432 272l0 48 64 0 0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]]
}, faChartLineUp = {
  prefix: "fad",
  iconName: "chart-line-up",
  icon: [512, 512, [], "e0e5", ["M0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64c0-17.7-14.3-32-32-32S0 46.3 0 64z", "M406.6 246.6L439 279c15.1 15.1 41 4.4 41-17L480 152c0-13.3-10.7-24-24-24l-110.1 0c-21.4 0-32.1 25.9-17 41l32.4 32.4L304 258.7l-73.4-73.4c-12.5-12.5-32.8-12.5-45.3 0l-80 80c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L208 253.3l73.4 73.4c12.5 12.5 32.8 12.5 45.3 0l80-80z"]]
}, faMailbox = {
  prefix: "fad",
  iconName: "mailbox",
  icon: [576, 512, [128234], "f813", ["M144 64c79.5 0 144 64.5 144 144l0 176c0 35.3-28.7 64-64 64l288 0c35.3 0 64-28.7 64-64l0-176c0-79.5-64.5-144-144-144L144 64zM384 208c0-8.8 7.2-16 16-16l64 0 32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16z", "M0 208C0 128.5 64.5 64 144 64s144 64.5 144 144l0 176c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 208zm64 0c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 192c-8.8 0-16 7.2-16 16zm336-16l64 0 32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]]
}, faSignPosts = {
  prefix: "fad",
  iconName: "sign-posts",
  icon: [576, 512, [], "e625", ["M64 32C64 14.3 78.3 0 96 0s32 14.3 32 32L64 32zm0 384l64 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64zM448 32c26.7 0 53.3 0 80 0c26.5 0 48 21.5 48 48l0 288c0 26.5-21.5 48-48 48l-16 0 0-384c0-17.7-14.3-32-32-32s-32 14.3-32 32zm0 384l64 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64z", "M0 80C0 53.5 21.5 32 48 32H528c26.5 0 48 21.5 48 48V368c0 26.5-21.5 48-48 48H48c-26.5 0-48-21.5-48-48V80z"]]
}, faTruckBolt = {
  prefix: "fad",
  iconName: "truck-bolt",
  icon: [640, 512, [], "e3d0", ["M96 432a80 80 0 1 0 160 0A80 80 0 1 0 96 432zm16.8-266.9c2.2 6.5 8.3 10.9 15.2 10.9l54.1 0-36.4 72.8c-3.3 6.6-1.6 14.7 4.1 19.4s13.9 5 19.9 .5l128-96c5.5-4.1 7.8-11.3 5.6-17.9S294.9 144 288 144l-54.1 0 36.4-72.8c3.3-6.6 1.6-14.7-4.1-19.4s-13.9-5-19.9-.5l-128 96c-5.5 4.1-7.8 11.3-5.6 17.9zM384 432a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M0 48C0 21.5 21.5 0 48 0L368 0c26.5 0 48 21.5 48 48l0 48 50.7 0c17 0 33.3 6.7 45.3 18.7L589.3 192c12 12 18.7 28.3 18.7 45.3l0 18.7 0 32 0 64c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0-1.1 0c-7.8-54.3-54.4-96-110.9-96s-103.1 41.7-110.9 96l-66.3 0c-7.8-54.3-54.4-96-110.9-96s-103.1 41.7-110.9 96L48 416c-26.5 0-48-21.5-48-48L0 48zM416 256l128 0 0-18.7L466.7 160 416 160l0 96zM266.3 51.7c-5.7-4.8-13.9-5-19.9-.5l-128 96c-5.5 4.1-7.8 11.3-5.6 17.9s8.3 10.9 15.2 10.9l54.1 0-36.4 72.8c-3.3 6.6-1.6 14.7 4.1 19.4s13.9 5 19.9 .5l128-96c5.5-4.1 7.8-11.3 5.6-17.9S294.9 144 288 144l-54.1 0 36.4-72.8c3.3-6.6 1.6-14.7-4.1-19.4z"]]
}, faPizzaSlice = {
  prefix: "fad",
  iconName: "pizza-slice",
  icon: [512, 512, [], "f818", ["M.5 491.9c-1.5 5.5 .1 11.4 4.1 15.4s9.9 5.6 15.4 4.1L432 401.6l0-1.6C432 223.3 288.7 80 112 80l-1.6 0L.5 491.9zM160 384a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48-144a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M169.7 .9c-22.8-1.6-41.9 14-47.5 34.7L110.4 80l1.6 0c176.7 0 320 143.3 320 320l0 1.6 44.4-11.8c20.8-5.5 36.3-24.7 34.7-47.5C498.5 159.5 352.5 13.5 169.7 .9zM208 240a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm64 128a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM128 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faMoneyBillWave = {
  prefix: "fad",
  iconName: "money-bill-wave",
  icon: [576, 512, [], "f53a", ["M64 208l0 144c33.9 0 61.6 26.3 63.9 59.7c40-.9 83.5-10.5 134.2-23.2c4.7-1.2 9.4-2.3 14.2-3.6c51.1-12.8 110.4-27.8 172.9-28.6c5.5-29.8 31.6-52.4 63-52.4l0-144c-33.9 0-61.6-26.3-63.9-59.7c-40 .9-83.5 10.5-134.2 23.2c-4.6 1.2-9.4 2.3-14.2 3.6c-51.1 12.8-110.4 27.8-172.9 28.6C121.5 185.4 95.4 208 64 208zm144 48c0-53 35.8-96 80-96s80 43 80 96s-35.8 96-80 96s-80-43-80-96z", "M0 112.5L0 422.3c0 18 10.1 35 27 41.3c87 32.5 174 10.3 261-11.9c79.8-20.3 159.6-40.7 239.3-18.9c23 6.3 48.7-9.5 48.7-33.4l0-309.9c0-18-10.1-35-27-41.3C462 15.9 375 38.1 288 60.3C208.2 80.6 128.4 100.9 48.7 79.1C25.6 72.8 0 88.6 0 112.5zM512 160l0 144c-31.4 0-57.5 22.6-63 52.4c-62.5 .8-121.8 15.7-172.9 28.6c0 0 0 0 0 0c-4.8 1.2-9.5 2.4-14.2 3.6c-50.7 12.6-94.1 22.2-134.2 23.2C125.6 378.3 97.9 352 64 352l0-144c31.4 0 57.5-22.6 63-52.4c62.5-.8 121.8-15.7 172.9-28.6c0 0 0 0 0 0c4.8-1.2 9.5-2.4 14.2-3.6c50.7-12.6 94.1-22.2 134.2-23.2c2.2 33.3 30 59.7 63.9 59.7z"]]
}, faChartArea = {
  prefix: "fad",
  iconName: "chart-area",
  icon: [512, 512, ["area-chart"], "f1fe", ["M0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64c0-17.7-14.3-32-32-32S0 46.3 0 64z", "M448 352H160c-17.7 0-32-14.3-32-32V236c0-7.8 2.8-15.2 7.9-21.1l79.4-90.8c13-14.8 36.1-14.5 48.7 .6l39.2 47c9 10.8 25.4 11.6 35.4 1.6l21-21c13.2-13.2 34.8-12.4 46.9 1.8L472.3 231c5 5.8 7.7 13.2 7.7 20.8V320c0 17.7-14.3 32-32 32z"]]
}, faAreaChart = faChartArea, faHouseFlag = {
  prefix: "fad",
  iconName: "house-flag",
  icon: [640, 512, [], "e50d", ["M2 267.1C6.6 279.7 18.6 288 32 288l32 0 0 192c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-96c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 96c0 17.7 14.3 32 32 32l64.7 0-.8 0 0-353L276.8 39.7c-6-5.1-13.4-7.7-20.8-7.7s-14.8 2.6-20.8 7.7l-224 192C1 240.4-2.7 254.5 2 267.1z", "M512 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 160 0 320 64 0 0-320 112 0c8.8 0 16-7.2 16-16l0-128c0-8.8-7.2-16-16-16L512 32z"]]
}, faCircleThreeQuartersStroke = {
  prefix: "fad",
  iconName: "circle-three-quarters-stroke",
  icon: [512, 512, [], "e5d4", ["M256 0C397.4 0 512 114.6 512 256l-64 0c0-106-86-192-192-192l0-64z", "M256 0C114.6 0 0 114.6 0 256S114.6 512 256 512s256-114.6 256-256H288c-17.7 0-32-14.3-32-32V0z"]]
}, faPersonCircleMinus = {
  prefix: "fad",
  iconName: "person-circle-minus",
  icon: [576, 512, [], "e540", ["M0 288c0 10.9 5.5 21.5 15.5 27.5c15.1 9.1 34.8 4.2 43.9-10.9L88 256.9 88 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 16 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-223.1 28.6 47.5c1.4 2.3 3.1 4.5 4.9 6.3c7.9-23 20.5-43.9 36.6-61.5l-44.9-74.7c-17.4-28.9-48.6-46.6-82.3-46.6l-29.7 0c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97C1.5 276.7 0 282.4 0 288zM112 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm64-128l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16z"]]
}, faScalpel = {
  prefix: "fad",
  iconName: "scalpel",
  icon: [512, 512, [], "f61d", ["M1.2 502.1c2.5 6 8.3 9.9 14.8 9.9c18.1 0 84.1-8.4 145.9-33.1C222.5 454.6 288 410.9 288 336l0-16-16 0-96 0-6.6 0-4.7 4.7-160 160c-4.6 4.6-5.9 11.5-3.5 17.4z", "M441.2 0c-20.6 0-40.2 9-53.7 24.6L155.9 293.6c-4.1 4.7-5 11.4-2.4 17.1s8.3 9.3 14.5 9.3l132.9 0c13.9 0 27.1-6 36.3-16.5L493.8 122.9C505.5 109.4 512 92.1 512 74.2l0-3.4C512 31.7 480.3 0 441.2 0z"]]
}, faBan = {
  prefix: "fad",
  iconName: "ban",
  icon: [512, 512, [128683, "cancel"], "f05e", ["M99.5 144.8c12.5-17.5 27.8-32.8 45.3-45.3L412.5 367.2c-12.5 17.5-27.8 32.8-45.3 45.3L99.5 144.8z", "M256 64a192 192 0 1 1 0 384 192 192 0 1 1 0-384zm0 448A256 256 0 1 0 256 0a256 256 0 1 0 0 512z"]]
}, faCancel = faBan, faBellExclamation = {
  prefix: "fad",
  iconName: "bell-exclamation",
  icon: [448, 512, [], "f848", ["M2.8 397.1C8 408.6 19.4 416 32 416l384 0c12.6 0 24-7.4 29.2-18.9c1.9-4.2 2.8-8.7 2.8-13.1c0-7.7-2.8-15.3-8.1-21.3l-7.4-8.3C401.3 319.2 384 273.9 384 226.8l0-18.8c0-77.4-55-142-128-156.8L256 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 19.2C119 66 64 130.6 64 208l0 18.8c0 47-17.3 92.4-48.5 127.6l-7.4 8.3c-8.4 9.4-10.4 22.9-5.3 34.4zM256 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM200 136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 96c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96z", "M224 112c-13.3 0-24 10.7-24 24l0 96c0 13.3 10.7 24 24 24s24-10.7 24-24l0-96c0-13.3-10.7-24-24-24zm32 208a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm13.3 173.3c12-12 18.7-28.3 18.7-45.3l-64 0-64 0c0 17 6.7 33.3 18.7 45.3s28.3 18.7 45.3 18.7s33.3-6.7 45.3-18.7z"]]
}, faCircleBookmark = {
  prefix: "fad",
  iconName: "circle-bookmark",
  icon: [512, 512, ["bookmark-circle"], "e100", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm160-80c0-26.5 21.5-48 48-48l96 0c26.5 0 48 21.5 48 48l0 192c0 6.2-3.5 11.8-9.1 14.4s-12.1 1.9-16.9-1.9l-70-56-70 56c-4.8 3.8-11.4 4.6-16.9 1.9s-9.1-8.3-9.1-14.4l0-192z", "M208 128c-26.5 0-48 21.5-48 48l0 192c0 6.2 3.5 11.8 9.1 14.4s12.1 1.9 16.9-1.9l70-56 70 56c4.8 3.8 11.4 4.6 16.9 1.9s9.1-8.3 9.1-14.4l0-192c0-26.5-21.5-48-48-48l-96 0z"]]
}, faBookmarkCircle = faCircleBookmark, faEggFried = {
  prefix: "fad",
  iconName: "egg-fried",
  icon: [512, 512, [], "f7fc", ["M0 351.8c0 55.3 28.7 109.1 80 138.7c76.5 44.2 174.4 18 218.6-58.6c18.8-32.5 66.1-60 103.3-65.2c20.5-2.9 40.6-10.8 58.4-24c33.9-25.1 51.8-63.8 51.8-102.9c0-26.5-8.2-53.2-25.2-76.1c-18.2-24.6-43.5-40.7-71-47.8c-42.4-10.9-101.2-45.1-131.5-76.7c-49-51-130-52.6-181-3.6C80.1 58 67.1 87 64.5 116.8C60.2 166.1 46.2 229.1 21.4 272C6.9 297.2 0 324.7 0 351.8zM336 240a112 112 0 1 1 -224 0 112 112 0 1 1 224 0z", "M224 352a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM176 232c0 8.8-7.2 16-16 16s-16-7.2-16-16c0-39.8 32.2-72 72-72c8.8 0 16 7.2 16 16s-7.2 16-16 16c-22.1 0-40 17.9-40 40z"]]
}, faFaceWeary = {
  prefix: "fad",
  iconName: "face-weary",
  icon: [512, 512, [], "e3a1", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm96-32c0-7.7 5.5-14.5 13.4-15.8l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-2.5 2.5-4.9 4.9-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2c-.1-.9-.2-1.8-.2-2.6zm32 176c0-11.6 4.2-24.2 10.3-35.9c6.3-12 15.3-24.3 26.4-35.4c22-22 53.9-40.7 91.3-40.7s69.3 18.7 91.3 40.7c11.1 11.1 20.1 23.4 26.4 35.4c6.2 11.7 10.3 24.4 10.3 35.9c0 5.2-2.6 10.2-6.9 13.2s-9.8 3.7-14.7 1.8l-20.5-7.7c-26.9-10.1-55.5-15.3-84.3-15.3l-3.2 0c-28.8 0-57.3 5.2-84.3 15.3L149.6 415c-4.9 1.8-10.4 1.2-14.7-1.8s-6.9-7.9-6.9-13.2zM300.7 164.7c6.2-6.2 16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c3.9 .7 7.3 2.7 9.6 5.5c1.2 1.4 2.1 3 2.8 4.8c.3 .9 .6 1.8 .7 2.7c.1 .5 .1 .9 .2 1.4s.1 .9 .1 1.4c0 .4 0 .9-.1 1.3s-.1 .9-.2 1.3c-1.5 8.7-9.7 14.6-18.4 13.2c-.8-.1-1.7-.3-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7c-2.5-2.5-4.9-4.9-7.4-7.4c-6.2-6.2-6.2-16.4 0-22.6z", "M211.3 187.3l-7.4 7.4c-23.6 23.6-53.9 39.2-86.8 44.7l-2.5 .4c-8.7 1.5-17-4.4-18.4-13.2s4.4-17 13.2-18.4l2.5-.4c26.3-4.4 50.6-16.9 69.5-35.7l7.4-7.4c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6zm89.4 0c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0l7.4 7.4c18.9 18.9 43.2 31.4 69.5 35.7l2.5 .4c8.7 1.5 14.6 9.7 13.2 18.4s-9.7 14.6-18.4 13.2l-2.5-.4c-32.9-5.5-63.3-21.1-86.8-44.7l-7.4-7.4z"]]
}, faUniformMartialArts = {
  prefix: "fad",
  iconName: "uniform-martial-arts",
  icon: [640, 512, [], "e3d1", ["M0 224.4L0 384c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-159.6c0-2.7 .7-5.3 2-7.7l46-83.7L144 288l109 0 54.6-143.3L246.4 18.1C241.1 7 229.9 0 217.6 0L208 0 180 0 164.4 0 160 0c-1 0-2 .1-3 .3c-32.1 2.5-61 20.9-76.7 49.5L13.9 170.5C4.8 187 0 205.6 0 224.4zM144 384l0 64c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-64-86.3 0 14.2 21.4c14.7 22.1 8.7 51.9-13.3 66.6s-51.9 8.7-66.6-13.3L320 422.5l-24.1 36.1c-14.7 22.1-44.5 28-66.6 13.3s-28-44.5-13.3-66.6L230.3 384 144 384zm143.2-96L496 288l0-154.9 46 83.7c1.3 2.4 2 5 2 7.7L544 384c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-159.6c0-18.9-4.8-37.4-13.9-54L559.7 49.7C544.1 21.2 515.1 2.8 483 .3c-1-.2-2-.3-3-.3l-4.4 0L460 0 432 0 419 0c-13.3 0-25.2 8.2-29.9 20.6L339.9 149.7 287.2 288z", "M496 288l-352 0 0 64 146.1 0-47.4 71.1c-4.9 7.4-2.9 17.3 4.4 22.2s17.3 2.9 22.2-4.4l50.7-76 50.7 76c4.9 7.4 14.8 9.3 22.2 4.4s9.3-14.8 4.4-22.2L349.9 352 496 352l0-64z"]]
}, faCameraRotate = {
  prefix: "fad",
  iconName: "camera-rotate",
  icon: [640, 512, [], "e0d8", ["M64 160l0 256c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64l-74.7 0L426.9 64.8C420.4 45.2 402.1 32 381.4 32L258.6 32c-20.7 0-39 13.2-45.5 32.8L202.7 96 128 96c-35.3 0-64 28.7-64 64zM192 320c0-8.8 7.2-16 16-16l76.7 0c6.2 0 11.3 5.1 11.3 11.3c0 3-1.2 5.9-3.3 8L269 347c13.6 13.4 31.9 21 51 21c19.2 0 37.7-7.6 51.3-21.3L391 327c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-19.7 19.7C382.6 403.3 352 416 320 416c-31.8 0-62.4-12.6-85-35l-23.7 23.7c-2.1 2.1-5 3.3-8 3.3c-6.2 0-11.3-5.1-11.3-11.3l0-76.7zm23-105l19.7-19.7C257.4 172.7 288 160 320 160c31.8 0 62.4 12.6 85 35l23.7-23.7c2.1-2.1 5-3.3 8-3.3c6.2 0 11.3 5.1 11.3 11.3l0 76.7c0 8.8-7.2 16-16 16l-76.7 0c-6.2 0-11.3-5.1-11.3-11.3c0-3 1.2-5.9 3.3-8L371 229c-13.6-13.4-31.9-21-51-21c-19.2 0-37.7 7.6-51.3 21.3L249 249c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9z", "M448 179.3l0 76.7c0 8.8-7.2 16-16 16l-76.7 0c-6.2 0-11.3-5.1-11.3-11.3c0-3 1.2-5.9 3.3-8L371 229c-13.6-13.4-31.9-21-51-21c-19.2 0-37.7 7.6-51.3 21.3L249 249c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l19.7-19.7C257.4 172.7 288 160 320 160c31.8 0 62.4 12.6 85 35l23.7-23.7c2.1-2.1 5-3.3 8-3.3c6.2 0 11.3 5.1 11.3 11.3zM192 396.7l0-76.7c0-8.8 7.2-16 16-16l76.7 0c6.2 0 11.3 5.1 11.3 11.3c0 3-1.2 5.9-3.3 8L269 347c13.6 13.4 31.9 21 51 21c19.2 0 37.7-7.6 51.3-21.3L391 327c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-19.7 19.7C382.6 403.3 352 416 320 416c-31.8 0-62.4-12.6-85-35l-23.7 23.7c-2.1 2.1-5 3.3-8 3.3c-6.2 0-11.3-5.1-11.3-11.3z"]]
}, faSunDust = {
  prefix: "fad",
  iconName: "sun-dust",
  icon: [512, 512, [], "f764", ["M1.2 150.5c-2.1 5-1.5 10.7 1.6 15.2L65.1 256 2.8 346.3c-3.1 4.5-3.7 10.2-1.6 15.2s6.6 8.6 11.9 9.6L121 391l44.5-44.5C142.3 323.3 128 291.3 128 256c0-70.7 57.3-128 128-128c35.3 0 67.3 14.3 90.5 37.5L391 121 371.1 13.1c-1-5.3-4.6-9.8-9.6-11.9c-2-.8-4-1.2-6.1-1.2c-3.2 0-6.4 1-9.1 2.8L256 65.1 165.7 2.8c-4.5-3.1-10.2-3.7-15.2-1.6s-8.6 6.6-9.6 11.9L121 121 13.1 140.9c-5.3 1-9.8 4.6-11.9 9.6zM160 256c0 26.5 10.7 50.5 28.1 67.9L323.9 188.1C306.5 170.7 282.5 160 256 160c-53 0-96 43-96 96z", "M480 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm-80 80a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm112 48a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM272 400a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm-80 80a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 32a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm192-32a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM400 432a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM352 320a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]]
}, faCommentText = {
  prefix: "fad",
  iconName: "comment-text",
  icon: [512, 512, [], "e14d", ["M0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3C1.6 455.8 0 459.9 0 464c0 2.1 .4 4.1 1.2 6.1c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240zm160-56c0-13.3 10.7-24 24-24l72 0 72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-48 0c-13.3 0-24-10.7-24-24z", "M160 184c0-13.3 10.7-24 24-24l72 0 72 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 104c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-104-48 0c-13.3 0-24-10.7-24-24z"]]
}, faSprayCanSparkles = {
  prefix: "fad",
  iconName: "spray-can-sparkles",
  icon: [512, 512, ["air-freshener"], "f5d0", ["M80 336a80 80 0 1 0 160 0A80 80 0 1 0 80 336zM288 48c0 1.4 1 3 2.2 3.6L320 64l12.4 29.8C333 95 334.6 96 336 96s3-1 3.6-2.2L352 64l29.8-12.4C383 51 384 49.4 384 48c0-1.4-1-3-2.2-3.6L352 32 339.6 2.2C339 1 337.4 0 336 0s-3 1-3.6 2.2L320 32 290.2 44.4C289 45 288 46.6 288 48zm64 96c0 1.4 1 3 2.2 3.6L384 160l12.4 29.8c.6 1.2 2.2 2.2 3.6 2.2s3-1 3.6-2.2L416 160l29.8-12.4c1.2-.6 2.2-2.2 2.2-3.6c0-1.4-1-3-2.2-3.6L416 128 403.6 98.2C403 97 401.4 96 400 96s-3 1-3.6 2.2L384 128l-29.8 12.4c-1.2 .6-2.2 2.2-2.2 3.6zm64-96c0 1.4 1 3 2.2 3.6L448 64l12.4 29.8C461 95 462.6 96 464 96s3-1 3.6-2.2L480 64l29.8-12.4C511 51 512 49.4 512 48c0-1.4-1-3-2.2-3.6L480 32 467.6 2.2C467 1 465.4 0 464 0s-3 1-3.6 2.2L448 32 418.2 44.4C417 45 416 46.6 416 48zm0 192c0 1.4 1 3 2.2 3.6L448 256l12.4 29.8c.6 1.2 2.2 2.2 3.6 2.2s3-1 3.6-2.2L480 256l29.8-12.4c1.2-.6 2.2-2.2 2.2-3.6c0-1.4-1-3-2.2-3.6L480 224l-12.4-29.8c-.6-1.2-2.2-2.2-3.6-2.2s-3 1-3.6 2.2L448 224l-29.8 12.4c-1.2 .6-2.2 2.2-2.2 3.6z", "M128 0l64 0c17.7 0 32 14.3 32 32l0 96L96 128l0-96c0-17.7 14.3-32 32-32zM0 256c0-53 43-96 96-96l128 0c53 0 96 43 96 96l0 208c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 256zm240 80A80 80 0 1 0 80 336a80 80 0 1 0 160 0z"]]
}, faAirFreshener = faSprayCanSparkles, faSignalBars = {
  prefix: "fad",
  iconName: "signal-bars",
  icon: [640, 512, ["signal-alt", "signal-alt-4", "signal-bars-strong"], "f690", ["", "M560 0c-26.5 0-48 21.5-48 48l0 416c0 26.5 21.5 48 48 48s48-21.5 48-48l0-416c0-26.5-21.5-48-48-48zM352 176l0 288c0 26.5 21.5 48 48 48s48-21.5 48-48l0-288c0-26.5-21.5-48-48-48s-48 21.5-48 48zM240 256c-26.5 0-48 21.5-48 48l0 160c0 26.5 21.5 48 48 48s48-21.5 48-48l0-160c0-26.5-21.5-48-48-48zM80 384c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48z"]]
}, faSignalAlt = faSignalBars, faSignalAlt4 = faSignalBars, faSignalBarsStrong = faSignalBars, faDiamondExclamation = {
  prefix: "fad",
  iconName: "diamond-exclamation",
  icon: [512, 512, [], "e405", ["M0 256c0 10.2 3.9 20.5 11.7 28.3l216 216c15.6 15.6 40.9 15.6 56.6 0l216-216c15.6-15.6 15.6-40.9 0-56.6l-216-216C276.5 3.9 266.2 0 256 0s-20.5 3.9-28.3 11.7l-216 216C3.9 235.5 0 245.8 0 256zm288 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM232 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112z", "M280 152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM256 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faStar = {
  prefix: "fad",
  iconName: "star",
  icon: [576, 512, [11088, 61446], "f005", ["M316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7s-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c10.8 5.7 23.9 4.9 33.8-2.3s14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c8.6-8.5 11.7-21.2 7.9-32.7s-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18z", ""]]
}, faDialMin = {
  prefix: "fad",
  iconName: "dial-min",
  icon: [576, 512, [], "e161", ["M0 288a32 32 0 1 0 64 0A32 32 0 1 0 0 288zM64 96a32 32 0 1 0 64 0A32 32 0 1 0 64 96zm0 384a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM256 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM448 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 384a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm64-192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M192.8 416.7c62.6 46.2 151.3 41 208-15.7c62.5-62.5 62.5-163.8 0-226.3s-163.8-62.5-226.3 0c-56.7 56.7-62 145.4-15.7 208L270.7 270.9c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L192.8 416.7z"]]
}, faRepeat = {
  prefix: "fad",
  iconName: "repeat",
  icon: [512, 512, [128257], "f363", ["M64 416c0 8.2 3.1 16.4 9.4 22.6l64 64c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6l0-32 160 0c88.4 0 160-71.6 160-160c0-17.7-14.3-32-32-32s-32 14.3-32 32c0 53-43 96-96 96l-160 0 0-32c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-64 64C67.1 399.6 64 407.8 64 416z", "M32 256c-17.7 0-32-14.3-32-32C0 135.6 71.6 64 160 64l160 0 0-32c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l64 64c12.5 12.5 12.5 32.8 0 45.3l-64 64c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6l0-32-160 0c-53 0-96 43-96 96c0 17.7-14.3 32-32 32z"]]
}, faCross = {
  prefix: "fad",
  iconName: "cross",
  icon: [384, 512, [128327, 10013], "f654", ["M0 176l0 32c0 26.5 21.5 48 48 48l80 0 128 0 80 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-80 0 0-80c0-26.5-21.5-48-48-48L176 0c-26.5 0-48 21.5-48 48l0 80-80 0c-26.5 0-48 21.5-48 48zM128 288l0 176c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-176-128 0z", "M128 256H256v32H128V256z"]]
}, faPageCaretDown = {
  prefix: "fad",
  iconName: "page-caret-down",
  icon: [384, 512, ["file-caret-down"], "e429", ["M0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-309.5c0-17-6.7-33.3-18.7-45.3L290.7 18.7C278.7 6.7 262.5 0 245.5 0L64 0C28.7 0 0 28.7 0 64zM98.3 245.8c.1-.8 .2-1.5 .3-2.3c.3-1.5 .7-3 1.3-4.4c1.1-2.8 2.8-5.5 4.9-7.7c4.2-4.5 10.2-7.4 17.4-7.4l139.6 0c20.9 0 31.8 24.8 17.7 40.2l-75.7 82.6c-3 3.3-7.3 5.2-11.8 5.2s-8.8-1.9-11.8-5.2c-25.2-27.5-50.5-55.1-75.7-82.6c-2.2-2.4-3.8-5-4.8-7.7c-.5-1.4-.9-2.7-1.2-4.1c-.1-.7-.2-1.4-.3-2.1s-.1-1.4-.1-2.1c0-.8 0-1.5 .1-2.3z", "M180.2 346.8c3 3.3 7.3 5.2 11.8 5.2s8.8-1.9 11.8-5.2l75.7-82.6c14.1-15.4 3.2-40.2-17.7-40.2l-139.6 0c-20.9 0-31.8 24.8-17.7 40.2l75.7 82.6z"]]
}, faFileCaretDown = faPageCaretDown, faBox = {
  prefix: "fad",
  iconName: "box",
  icon: [448, 512, [128230], "f466", ["M0 160l208 0 0-128L93.7 32C75.5 32 58.9 42.3 50.7 58.5L0 160zM240 32l0 128 208 0L397.3 58.5C389.1 42.3 372.5 32 354.3 32L240 32z", "M240 160l208 0 0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 160l208 0 0-128 32 0 0 128z"]]
}, faVenusMars = {
  prefix: "fad",
  iconName: "venus-mars",
  icon: [640, 512, [9892], "f228", ["M256 176A80 80 0 1 1 96 176a80 80 0 1 1 160 0zm15.9 184.6c19.3-10.1 36.9-23.1 52.1-38.4c20 18.5 46.7 29.8 76.1 29.8c61.9 0 112-50.1 112-112s-50.1-112-112-112c-7.2 0-14.3 .7-21.1 2c-4.9-21.5-13-41.7-24-60.2C369.3 66 384.4 64 400 64c37 0 71.4 11.4 99.8 31l20.6-20.6L487 41c-6.9-6.9-8.9-17.2-5.2-26.2S494.3 0 504 0L616 0c13.3 0 24 10.7 24 24l0 112c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-33.4-33.4L545 140.2c19.5 28.4 31 62.7 31 99.8c0 97.2-78.8 176-176 176c-50.5 0-96-21.3-128.1-55.4z", "M176 288a112 112 0 1 0 0-224 112 112 0 1 0 0 224zM352 176c0 86.3-62.1 158.1-144 173.1l0 34.9 32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0 0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l32 0 0-34.9C62.1 334.1 0 262.3 0 176C0 78.8 78.8 0 176 0s176 78.8 176 176zm32 0c0-4.8-.2-9.6-.5-14.3c5.3-1.1 10.8-1.7 16.5-1.7c44.2 0 80 35.8 80 80s-35.8 80-80 80c-21.5 0-41-8.5-55.3-22.2C369.4 263.5 384 221.5 384 176z"]]
}, faClockSevenThirty = {
  prefix: "fad",
  iconName: "clock-seven-thirty",
  icon: [512, 512, [], "e351", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm168 96c0-4.6 1.3-9.2 4-13.3l64-96c5.9-8.8 16.8-12.7 26.9-9.7s17 12.4 17 23l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56.7-20 30c-7.4 11-22.3 14-33.3 6.7c-6.9-4.6-10.7-12.2-10.7-20z", "M256 416c-13.3 0-24-10.7-24-24l0-56.7-20 30c-7.4 11-22.3 14-33.3 6.7s-14-22.3-6.7-33.3l64-96c5.9-8.8 16.8-12.7 26.9-9.7s17 12.4 17 23l0 136c0 13.3-10.7 24-24 24z"]]
}, faArrowPointer = {
  prefix: "fad",
  iconName: "arrow-pointer",
  icon: [320, 512, ["mouse-pointer"], "f245", ["M121.2 346c7.6-8.7 15.2-17.3 22.8-26l35.8 0 56.8 113.7c2.3 4.6 3.4 9.5 3.4 14.3c0 11.7-6.5 23-17.7 28.6c-4.6 2.3-9.5 3.4-14.3 3.4c-11.7 0-23-6.5-28.6-17.7L121.2 346z", "M0 426V55.2C0 42.4 10.4 32 23.2 32c5.7 0 11.2 2.1 15.4 5.9l274 243.6c4.7 4.2 7.4 10.2 7.4 16.5c0 12.2-9.9 22.1-22.1 22.1H144L38.6 440.5C34.4 445.3 28.4 448 22 448c-12.2 0-22-9.9-22-22z"]]
}, faMousePointer = faArrowPointer, faClockFourThirty = {
  prefix: "fad",
  iconName: "clock-four-thirty",
  icon: [512, 512, [], "e34b", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm232 0c0-8.9 4.9-17 12.7-21.2s17.3-3.7 24.6 1.2l96 64c6.9 4.6 10.7 12.2 10.7 20c0 4.6-1.3 9.2-4 13.3c-7.4 11-22.3 14-33.3 6.7L280 300.8l0 91.2c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136z", "M256 416c13.3 0 24-10.7 24-24l0-91.2L338.7 340c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3l-96-64c-7.4-4.9-16.8-5.4-24.6-1.2S232 247.1 232 256l0 136c0 13.3 10.7 24 24 24z"]]
}, faSignalBarsGood = {
  prefix: "fad",
  iconName: "signal-bars-good",
  icon: [640, 512, ["signal-alt-3"], "f693", ["M512 48c0-26.5 21.5-48 48-48s48 21.5 48 48l0 416c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-416z", "M400 128c-26.5 0-48 21.5-48 48l0 288c0 26.5 21.5 48 48 48s48-21.5 48-48l0-288c0-26.5-21.5-48-48-48zM192 304l0 160c0 26.5 21.5 48 48 48s48-21.5 48-48l0-160c0-26.5-21.5-48-48-48s-48 21.5-48 48zM32 432l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48z"]]
}, faSignalAlt3 = faSignalBarsGood, faCactus = {
  prefix: "fad",
  iconName: "cactus",
  icon: [512, 512, [127797], "f8a7", ["M0 144l0 64c0 61.9 50.1 112 112 112l48 0 0-96-48 0c-8.8 0-16-7.2-16-16l0-64c0-26.5-21.5-48-48-48S0 117.5 0 144zM352 352l0 96 48 0c61.9 0 112-50.1 112-112l0-64c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 64c0 8.8-7.2 16-16 16l-48 0z", "M160 96c0-53 43-96 96-96s96 43 96 96l0 368c0 26.5-21.5 48-48 48l-96 0c-26.5 0-48-21.5-48-48l0-368zm80 64a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm48 240a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]]
}, faLightbulbGear = {
  prefix: "fad",
  iconName: "lightbulb-gear",
  icon: [576, 512, [], "e5fd", ["M16 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4c19.8 27.1 39.7 54.4 49.2 86.2l128.6 0c2.3-13.3 10.5-24.9 21.4-31.8c-16.6-10.6-26.7-31.7-20-53.3c4-12.9 9.4-25.5 16.4-37.6s15.2-23.1 24.4-33c15.7-16.9 39.6-18.5 57.2-8.7l0-.9c0-17.8 10.2-35.6 28-43.3C367.6 78.4 289 0 192 0C94.8 0 16 78.8 16 176zm64 0c0-61.9 50.1-112 112-112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.2 0-80 35.8-80 80c0 8.8-7.2 16-16 16s-16-7.2-16-16zm32 240l0 16c0 44.2 35.8 80 80 80c35.2 0 65.1-22.8 75.8-54.4c-3.3-4.7-6.4-9.5-9.4-14.6c-5.1-8.8-9.3-17.8-12.8-27L112 416z", "M383.3 203.4c-6.8 1.5-11.3 7.8-11.3 14.8l0 17.4c0 7.9-4.9 15-11.7 18.9c-6.8 3.9-15.2 4.5-22 .6l-13.6-7.8c-6.1-3.5-13.7-2.7-18.5 2.4c-7.5 8.1-14.3 17.2-20.1 27.2s-10.3 20.4-13.5 31c-2.1 6.7 1.1 13.7 7.2 17.2l14 8.1c6.5 3.8 10.1 11 10.1 18.6s-3.5 14.8-10.1 18.6l-14 8.1c-6.1 3.5-9.2 10.5-7.2 17.2c3.3 10.6 7.8 21 13.5 31s12.5 19.1 20.1 27.2c4.8 5.1 12.5 5.9 18.5 2.4l13.5-7.8c6.8-3.9 15.2-3.3 22 .6c6.9 3.9 11.7 11 11.7 18.9l0 17.4c0 7 4.5 13.3 11.3 14.8c10.5 2.4 21.5 3.7 32.7 3.7s22.2-1.3 32.7-3.7c6.8-1.5 11.3-7.8 11.3-14.8l0-17.7c0-7.8 4.8-14.8 11.6-18.7c6.7-3.9 15.1-4.5 21.8-.6l13.8 7.9c6.1 3.5 13.7 2.7 18.5-2.4c7.6-8.1 14.3-17.2 20.1-27.2s10.3-20.4 13.5-31c2.1-6.7-1.1-13.7-7.2-17.2l-14.4-8.3c-6.5-3.7-10-10.9-10-18.4s3.5-14.7 10-18.4l14.4-8.3c6.1-3.5 9.2-10.5 7.2-17.2c-3.3-10.6-7.8-21-13.5-31s-12.5-19.1-20.1-27.2c-4.8-5.1-12.5-5.9-18.5-2.4l-13.8 7.9c-6.7 3.9-15.1 3.3-21.8-.6c-6.8-3.9-11.6-10.9-11.6-18.7l0-17.7c0-7-4.5-13.3-11.3-14.8c-10.5-2.4-21.5-3.7-32.7-3.7s-22.2 1.3-32.7 3.7zM416 303.7a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]]
}, faMaximize = {
  prefix: "fad",
  iconName: "maximize",
  icon: [512, 512, ["expand-arrows-alt"], "f31e", ["M32 56l0 144c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2l40-40 79 79c21.3-21.3 42.7-42.7 64-64l-79-79 40-40c6.9-6.9 8.9-17.2 5.2-26.2S209.7 32 200 32L56 32C42.7 32 32 42.7 32 56zM256 320l79 79-40 40c-6.9 6.9-8.9 17.2-5.2 26.2s12.5 14.8 22.2 14.8l144 0c13.3 0 24-10.7 24-24l0-144c0-9.7-5.8-18.5-14.8-22.2s-19.3-1.7-26.2 5.2l-40 40-79-79-64 64z", "M480 56l0 144c0 9.7-5.8 18.5-14.8 22.2s-19.3 1.7-26.2-5.2l-40-40L177 399l40 40c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8L56 480c-13.3 0-24-10.7-24-24l0-144c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l40 40L335 113 295 73c-6.9-6.9-8.9-17.2-5.2-26.2s12.5-14.8 22.2-14.8l144 0c13.3 0 24 10.7 24 24z"]]
}, faExpandArrowsAlt = faMaximize, faChargingStation = {
  prefix: "fad",
  iconName: "charging-station",
  icon: [576, 512, [], "f5e7", ["M32 64C32 28.7 60.7 0 96 0L256 0c35.3 0 64 28.7 64 64l0 192 0 48 0 144L32 448 32 64zM81 197.6c2.3 6.3 8.3 10.4 15 10.4l57.8 0-25 74.9c-2.3 6.8 .3 14.3 6.3 18.3s13.9 3.6 19.3-1.1l112-96c5.1-4.4 6.9-11.4 4.6-17.7s-8.3-10.4-15-10.4l-57.8 0 25-74.9c2.3-6.8-.3-14.3-6.3-18.3s-13.9-3.6-19.3 1.1l-112 96c-5.1 4.4-6.9 11.4-4.6 17.7z", "M480 80c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-16 0c-8.8 0-16 7.2-16 16l0 32c0 35.8 23.5 66.1 56 76.3L472 376c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32c0-48.6-39.4-88-88-88l-16 0 0 48 16 0c22.1 0 40 17.9 40 40l0 32c0 39.8 32.2 72 72 72s72-32.2 72-72l0-123.7c32.5-10.2 56-40.5 56-76.3l0-32c0-8.8-7.2-16-16-16l-16 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-32 0 0-48zM0 480c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448c-17.7 0-32 14.3-32 32z"]]
}, faShapes = {
  prefix: "fad",
  iconName: "shapes",
  icon: [512, 512, ["triangle-circle-square"], "f61f", ["M0 384a128 128 0 1 0 256 0A128 128 0 1 0 0 384zM164.2 207.8c5.7 10 16.3 16.2 27.8 16.2l192 0c11.5 0 22.2-6.2 27.8-16.2s5.5-22.3-.4-32.2l-96-160C309.7 5.9 299.2 0 288 0s-21.7 5.9-27.4 15.5l-96 160c-5.9 9.9-6.1 22.2-.4 32.2z", "M328 272c-22.1 0-40 17.9-40 40l0 144c0 22.1 17.9 40 40 40l144 0c22.1 0 40-17.9 40-40l0-144c0-22.1-17.9-40-40-40l-144 0z"]]
}, faTriangleCircleSquare = faShapes, faPlaneTail = {
  prefix: "fad",
  iconName: "plane-tail",
  icon: [512, 512, [], "e22c", ["M.8 39L61.5 308.8c59.9-16.5 119.8-33.1 179.8-49.6c7.6-2.1 15.5-3.2 23.4-3.2L384 256 154.9 19.5C142.8 7 126.2 0 108.9 0L32 0C11.5 0-3.7 19 .8 39z", "M512 464l0-160 0-24 0-24-24 0-223.3 0c-7.9 0-15.8 1.1-23.4 3.2L45.9 313.1C18.8 320.5 0 345.2 0 373.4c0 26 16.1 49.3 40.4 58.5l196.1 74.4c10 3.8 20.5 5.7 31.2 5.7L488 512l24 0 0-24 0-24zM216 352l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]]
}, faGaugeSimpleMax = {
  prefix: "fad",
  iconName: "gauge-simple-max",
  icon: [512, 512, ["tachometer-fastest"], "f62b", ["M512 256A256 256 0 1 1 0 256a256 256 0 1 1 512 0zM192.3 345.4c-.1 1.1-.2 2.2-.2 3.2c-.1 1.1-.1 2.2-.1 3.3s0 2.2 .1 3.3c.1 1.1 .1 2.2 .2 3.2c.2 2.1 .5 4.3 1 6.4c.9 4.2 2.1 8.2 3.7 12c3.2 7.7 7.9 14.6 13.7 20.3C222.3 408.8 238.3 416 256 416c35.3 0 64-28.7 64-64c0-3.7-.3-7.3-.9-10.8c39.2-24.3 78.4-48.5 117.5-72.8c11.3-7 14.7-21.8 7.8-33s-21.8-14.8-33-7.8c-39.2 24.3-78.4 48.5-117.6 72.8C283.2 292.6 270.1 288 256 288c-17.7 0-33.7 7.2-45.3 18.7c-5.8 5.8-10.5 12.7-13.7 20.3c-1.6 3.8-2.9 7.8-3.7 12c-.4 2.1-.8 4.2-1 6.3z", "M411.4 227.6c11.3-7 26.1-3.5 33 7.8s3.5 26.1-7.8 33L319.1 341.2c.6 3.5 .9 7.1 .9 10.8c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c14.1 0 27.2 4.6 37.8 12.4l117.6-72.8z"]]
}, faTachometerFastest = faGaugeSimpleMax, faCircleU = {
  prefix: "fad",
  iconName: "circle-u",
  icon: [512, 512, [], "e127", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm144-88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 120c0 35.3 28.7 64 64 64s64-28.7 64-64l0-120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 120c0 61.9-50.1 112-112 112s-112-50.1-112-112l0-120z", "M168 144c13.3 0 24 10.7 24 24l0 120c0 35.3 28.7 64 64 64s64-28.7 64-64l0-120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 120c0 61.9-50.1 112-112 112s-112-50.1-112-112l0-120c0-13.3 10.7-24 24-24z"]]
}, faShieldSlash = {
  prefix: "fad",
  iconName: "shield-slash",
  icon: [640, 512, [], "e24b", ["M80.6 159.5c5.5 102 51.4 266.3 213 343.7c16.7 8 36.1 8 52.8 0c35.8-17.1 65.8-38.5 91.1-62.5L80.6 159.5zM131 77.4C253.3 173.3 375.6 269.1 497.9 365c47.4-78.8 61.8-166.3 62.1-225c.1-26.2-16.3-47.9-38.3-57.2L333.4 2.9C329.2 1 324.7 0 320 0s-9.2 1-13.4 2.9L131 77.4z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faSquarePhoneHangup = {
  prefix: "fad",
  iconName: "square-phone-hangup",
  icon: [448, 512, ["phone-square-down"], "e27a", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM66.8 274.8C62 267 63.4 257.3 70.3 251c42.5-39.3 98.1-59 153.7-59s111.3 19.7 153.7 59c4.1 3.8 6.3 8.9 6.3 14c0 3.4-.9 6.7-2.8 9.8L359.4 310c-5.3 8.6-16.8 12.3-26.7 8.5l-46.2-17.6c-8.7-3.3-14.1-11.6-13.1-20.3l2.9-26.7c-33.8-10.8-70.8-10.8-104.6 0l2.9 26.7c.9 8.7-4.4 16.9-13.1 20.3l-46.2 17.6c-9.9 3.8-21.4 .2-26.7-8.5L66.8 274.8z", "M332.7 318.5c9.9 3.8 21.4 .2 26.7-8.5l21.7-35.2c4.8-7.8 3.4-17.5-3.4-23.8c-84.9-78.6-222.6-78.6-307.5 0c-6.8 6.3-8.2 16.1-3.4 23.8L88.6 310c5.3 8.6 16.8 12.3 26.7 8.5l46.2-17.6c8.7-3.3 14.1-11.6 13.1-20.3L171.7 254c33.8-10.8 70.8-10.8 104.6 0l-2.9 26.7c-.9 8.7 4.4 16.9 13.1 20.3l46.2 17.6z"]]
}, faPhoneSquareDown = faSquarePhoneHangup, faArrowUpLeft = {
  prefix: "fad",
  iconName: "arrow-up-left",
  icon: [384, 512, [], "e09d", ["M96 160l45.3 0L342.6 361.4c6.2 6.2 9.4 14.4 9.4 22.6s-3.1 16.4-9.4 22.6s-14.4 9.4-22.6 9.4s-16.4-3.1-22.6-9.4L96 205.3 96 160z", "M32 128c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L96 160l0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-224z"]]
}, faTransporter1 = {
  prefix: "fad",
  iconName: "transporter-1",
  icon: [512, 512, [], "e043", ["M0 368c0 4.1 2.7 7.6 6.6 8.7L32 384l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 384l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 352l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L32 352 6.6 359.3C2.7 360.4 0 363.9 0 368zm160-32c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zM416 176c0 4.1 2.7 7.6 6.6 8.7L448 192l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 192l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 160l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L448 160l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7z", "M304 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM216 512l80 0 88 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l88 0zM359 276c6.3 7.8 15.4 11.9 24.7 12l.3 0s0 0 0 0c7 0 14.1-2.3 20-7c13.8-11.1 16-31.2 5-45l-57.7-72c-18.2-22.7-45.8-36-74.9-36l-40.7 0c-29.1 0-56.7 13.2-74.9 36L103 236c-11.1 13.8-8.8 33.9 5 45c5.9 4.7 13 7 20 7c0 0 0 0 0 0l.3 0c9.3-.1 18.5-4.2 24.7-12l31-38.7 0 50.7 144 0 0-50.7L359 276z"]]
}, faPeanuts = {
  prefix: "fad",
  iconName: "peanuts",
  icon: [640, 512, [129372], "e431", ["M128 364l0 68c0 23.4 10 44.4 26 59c14.2 13 33.2 21 54 21l68 0c40.5 0 77.1-16.2 103.8-42.5c.6-.6 1.1-1.1 1.7-1.7c13.8-14 24.2-30.1 31.3-47.2c4-9.5 6.9-19.6 8.8-30c4.8-24.5 12.6-49.1 30.3-66.7s42.2-25.4 66.7-30.3c10.4-1.9 20.5-4.9 30-8.8c17.3-7.2 33.5-17.7 47.6-31.7l.9-.9C623.6 225.4 640 188.6 640 148l0-68c0-44.2-35.8-80-80-80L492 0c-20.1 0-39.2 4-56.7 11.2c-17.4 7.2-33.7 17.8-47.8 32l-.4 .4C373 57.8 362.4 74 355.2 91.4c-4 9.5-6.9 19.6-8.8 30c-3.7 18.7-9.1 37.5-19.4 53.2c-3.1 4.8-6.7 9.4-10.9 13.5c-17.6 17.6-42.2 25.4-66.7 30.3c-10.4 1.9-20.5 4.9-30 8.8c-17.5 7.2-33.9 17.9-48.1 32.1c-14.2 14.2-24.9 30.5-32.1 48C132 324.8 128 343.9 128 364zm147.2 52.1a19.2 19.2 0 1 1 -38.4-.3 19.2 19.2 0 1 1 38.4 .3zm63.6-60.2a19.2 19.2 0 1 1 -37.6-7.8 19.2 19.2 0 1 1 37.6 7.8zm0 64a19.2 19.2 0 1 1 -37.6-7.8 19.2 19.2 0 1 1 37.6 7.8zM499.2 192a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zm64-64a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0zm0 64a19.2 19.2 0 1 1 -38.4 0 19.2 19.2 0 1 1 38.4 0z", "M161.7 28.3L212.6 5.7c33.1-14.7 71.8 .1 86.6 33.2l22.7 50.9c12.4 27.8 13.5 57.8 5.2 84.8c-3.1 4.8-6.7 9.4-10.9 13.5c-17.6 17.6-42.2 25.4-66.7 30.3c-10.4 1.9-20.5 4.9-30 8.8c-17.5 7.2-33.9 17.9-48.1 32.1c-14.2 14.2-24.9 30.5-32.1 48C132 324.8 128 343.9 128 364l0 68c0 23.4 10 44.4 26 59l-34.3 15.3c-33.1 14.7-71.8-.2-86.6-33.2L10.5 422.2C3.8 407.2 .4 391.5 0 376c-.4-15.5 2.2-31.3 8-46.6C14 314 22.7 300.5 33.4 289.3c5.8-6.1 12.3-11.7 19.5-16.6c16.7-11.8 32.5-25.8 39.8-44.9s5-40.1 .4-60c-2.1-8.4-3.2-17-3.4-25.4c-.4-15.4 2.1-31.1 7.9-46.4l.2-.5c5.9-15.3 14.5-28.7 25.2-39.9c10.7-11.2 23.6-20.6 38.7-27.3zM524.8 128a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zm0 64a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zm-64 0a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zm-224 224a19.2 19.2 0 1 1 38.4 0 19.2 19.2 0 1 1 -38.4 0zM320 396.8a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4zm0-64a19.2 19.2 0 1 1 0 38.4 19.2 19.2 0 1 1 0-38.4z"]]
}, faShuffle = {
  prefix: "fad",
  iconName: "shuffle",
  icon: [512, 512, [128256, "random"], "f074", ["M0 384c0 17.7 14.3 32 32 32l64 0c30.2 0 58.7-14.2 76.8-38.4L224 309.3c-13.3-17.8-26.7-35.6-40-53.3l-62.4 83.2c-6 8.1-15.5 12.8-25.6 12.8l-64 0c-17.7 0-32 14.3-32 32zM224 202.7c13.3 17.8 26.7 35.6 40 53.3l62.4-83.2c6-8.1 15.5-12.8 25.6-12.8l32 0 0 32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c6-6 9.4-14.1 9.4-22.6s-3.4-16.6-9.4-22.6l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9s-19.8 16.6-19.8 29.6l0 32-32 0c-30.2 0-58.7 14.2-76.8 38.4L224 202.7z", "M352 416c-30.2 0-58.7-14.2-76.8-38.4L121.6 172.8c-6-8.1-15.5-12.8-25.6-12.8l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l64 0c30.2 0 58.7 14.2 76.8 38.4L326.4 339.2c6 8.1 15.5 12.8 25.6 12.8l32 0 0-32c0-12.9 7.8-24.6 19.8-29.6s25.7-2.2 34.9 6.9l64 64c6 6 9.4 14.1 9.4 22.6s-3.4 16.6-9.4 22.6l-64 64c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6l0-32-32 0z"]]
}, faRandom = faShuffle, faPersonRunning = {
  prefix: "fad",
  iconName: "person-running",
  icon: [448, 512, [127939, "running"], "f70c", ["M0 384c0 17.7 14.3 32 32 32l69.6 0c19 0 36.2-11.2 43.9-28.5l24.6-55.4-5.7-3.6c-25.1-15.7-36.1-46.5-26.8-74.5c2.8-8.5 5.7-17 8.5-25.6L91.2 352 32 352c-17.7 0-32 14.3-32 32z", "M272 0a48 48 0 1 1 0 96 48 48 0 1 1 0-96zM163.2 160c-14.1 0-27.5 5.6-37.5 15.5l-23.1 23.1c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l23.1-23.1C102.4 108.3 132.2 96 163.2 96c11.7 0 23.3 1.7 34.4 5.2l48.7 15c36.4 11.2 65.9 38 80.5 73.1l6.3 15c5 11.9 16.6 19.7 29.5 19.7l21.3 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-21.3 0c-38.8 0-73.7-23.3-88.6-59.1l-5.1-12.3L238 299l56.7 35.4c18.1 11.3 26.6 33.3 20.7 53.9L286.8 488.8c-4.9 17-22.6 26.8-39.6 22s-26.8-22.6-22-39.6l25.4-88.8-86.2-53.9c-25.1-15.7-36.1-46.5-26.8-74.5l31.2-93.7c-1.9-.2-3.7-.3-5.6-.3z"]]
}, faRunning = faPersonRunning, faMobileRetro = {
  prefix: "fad",
  iconName: "mobile-retro",
  icon: [320, 512, [], "e527", ["M0 64C0 28.7 28.7 0 64 0L256 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM56 328a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 80a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm8-248l0 64c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L96 128c-17.7 0-32 14.3-32 32zm48-96c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm24 264a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 80a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm80-80a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 80a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M64 160c0-17.7 14.3-32 32-32H224c17.7 0 32 14.3 32 32v64c0 17.7-14.3 32-32 32H96c-17.7 0-32-14.3-32-32V160z"]]
}, faGripLinesVertical = {
  prefix: "fad",
  iconName: "grip-lines-vertical",
  icon: [192, 512, [], "f7a5", ["M128 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 384c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-384z", "M0 64C0 46.3 14.3 32 32 32s32 14.3 32 32V448c0 17.7-14.3 32-32 32s-32-14.3-32-32V64z"]]
}, faBinBottlesRecycle = {
  prefix: "fad",
  iconName: "bin-bottles-recycle",
  icon: [640, 512, [], "e5f6", ["M32 192l320 0c0-26.5-10.7-50.5-28.1-67.9c-1.1-1.1-2.1-2.1-3.2-3.1c-17.1-15.5-39.7-25-64.6-25L128 96c-53 0-96 43-96 96zM112 48c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l0-8c0-13.3-10.7-24-24-24L152 0c-13.3 0-24 10.7-24 24l0 8c-8.8 0-16 7.2-16 16zM335.4 91.6C365 115.1 384 151.3 384 192l191.1 0c-1.2-9.7-4.6-18.7-9.6-26.5c6.4-9.5 10.1-21 10.1-33.3c0-23.2-13.4-44.3-34.4-54.2L528 71.8c-5.3-2.5-10.8-4.4-16.4-5.7l0-42.1c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24l0 42.1c-5.6 1.3-11.1 3.2-16.4 5.7L354.1 78c-7.2 3.4-13.5 8-18.6 13.6z", "M0 256c0-17.7 14.3-32 32-32l576 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L583.8 457c-4.5 31.5-31.5 55-63.4 55l-401 0c-31.8 0-58.9-23.4-63.4-55L32 288c-17.7 0-32-14.3-32-32zm319.9 64c4.6 0 9 2.3 11.5 6.2l8.5 12.9c4.8 7.3 14.5 9.4 21.8 4.8c7.6-4.8 9.8-14.9 4.9-22.4l-8.5-12.9c-8.5-12.9-22.8-20.6-38.2-20.6c-15.3 0-29.6 7.7-38.1 20.4l-7.6 11.4c-5 7.5-2.8 17.7 4.8 22.4c7.3 4.6 17 2.5 21.8-4.7l7.6-11.4c2.6-3.8 6.9-6.1 11.5-6.1zm-59.4 48.4c-7.3-4.6-17-2.5-21.8 4.7l-7.9 11.9c-4.4 6.7-6.8 14.5-6.8 22.5c0 22.4 18.2 40.6 40.6 40.6l25.2 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-25.2 0c-4.7 0-8.6-3.8-8.6-8.6c0-1.7 .5-3.3 1.4-4.7l7.9-11.9c5-7.5 2.8-17.7-4.8-22.4zM337.7 432c0 8.8 7.2 16 16 16l20.9 0c22.4 0 40.6-18.2 40.6-40.6c0-7.9-2.3-15.7-6.7-22.4l-6.6-10.1c-4.8-7.3-14.5-9.4-21.8-4.8c-7.6 4.8-9.8 14.9-4.9 22.4l6.6 10.1c.9 1.4 1.4 3.1 1.4 4.7c0 4.8-3.9 8.6-8.6 8.6l-20.9 0c-8.8 0-16 7.2-16 16z"]]
}, faArrowUpFromSquare = {
  prefix: "fad",
  iconName: "arrow-up-from-square",
  icon: [512, 512, [], "e09c", ["M0 112L0 432c0 44.2 35.8 80 80 80l352 0c44.2 0 80-35.8 80-80l0-320c0-44.2-35.8-80-80-80l-8 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l8 0c8.8 0 16 7.2 16 16l0 320c0 8.8-7.2 16-16 16L80 448c-8.8 0-16-7.2-16-16l0-320c0-8.8 7.2-16 16-16l8 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-8 0C35.8 32 0 67.8 0 112z", "M233.4 9.4c12.5-12.5 32.8-12.5 45.3 0l96 96c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L288 109.3 288 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-210.7-41.4 41.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l96-96z"]]
}, faFileDashedLine = {
  prefix: "fad",
  iconName: "file-dashed-line",
  icon: [640, 512, ["page-break"], "f877", ["M128 64l0 192 384 0 0-96-128 0c-17.7 0-32-14.3-32-32L352 0 192 0c-35.3 0-64 28.7-64 64zm0 304l0 80c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-80-384 0zM384 0l0 128 128 0L384 0z", "M32 312c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L56 336c-13.3 0-24-10.7-24-24zm224 0c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zm192 0c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24z"]]
}, faPageBreak = faFileDashedLine, faBracketCurlyRight = {
  prefix: "fad",
  iconName: "bracket-curly-right",
  icon: [256, 512, [], "7d", ["M192 128c0-53-43-96-96-96L64 32C46.3 32 32 46.3 32 64s14.3 32 32 32l32 0c17.7 0 32 14.3 32 32l0 37.5c0 25.5 10.1 49.9 28.1 67.9L178.7 256l-22.6 22.6c-18 18-28.1 42.4-28.1 67.9l0 37.5c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0c53 0 96-43 96-96l0-37.5c0-8.5 3.4-16.6 9.4-22.6l45.3-45.3c12.5-12.5 12.5-32.8 0-45.3l-45.3-45.3c-6-6-9.4-14.1-9.4-22.6l0-37.5z", ""]]
}, faSpider = {
  prefix: "fad",
  iconName: "spider",
  icon: [512, 512, [128375], "f717", ["M81.1 100c-7.9 20.7-3 44.1 12.7 59.7l57.4 57.4c8.3 2.8 16.6 5.5 24.9 8.3c0-17.1 0-34.2 0-51.3l-48.3-48.3c-2.2-2.2-2.9-5.6-1.8-8.5l32.5-84.6c4.8-12.4-1.4-26.3-13.8-31s-26.3 1.4-31 13.8L81.1 100zM336 174.1l0 51.3c8.3-2.8 16.6-5.5 24.9-8.3l57.4-57.4c15.7-15.6 20.6-39 12.7-59.7L398.4 15.4C393.6 3 379.8-3.2 367.4 1.6s-18.5 18.6-13.8 31l32.5 84.6c1.1 3 .4 6.3-1.8 8.5L336 174.1z", "M221.5 87.8c9.1-4.4 18.5 3.3 18.5 13.4l0 10.8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-10.8c0-10.1 9.4-17.7 18.5-13.4C317.4 100.7 336 128.2 336 160l0 65.4 105.2-35.1c2.4-.8 4.3-2.7 5.1-5.1l18.9-56.8c4.2-12.6 17.8-19.4 30.4-15.2s19.4 17.8 15.2 30.4l-18.9 56.8c-5.6 16.7-18.7 29.8-35.4 35.4L395.9 256l60.5 20.2c16.7 5.6 29.8 18.7 35.4 35.4l18.9 56.8c4.2 12.6-2.6 26.2-15.2 30.4s-26.2-2.6-30.4-15.2l-18.9-56.8c-.8-2.4-2.7-4.3-5.1-5.1l-80.4-26.8 57.4 57.4c15.6 15.6 20.6 39 12.7 59.7l-32.5 84.6c-4.8 12.4-18.6 18.5-31 13.8s-18.5-18.6-13.8-31l32.5-84.6c1.1-3 .4-6.3-1.8-8.5L352 353.9c-1 52.1-43.6 94.1-96 94.1s-95-41.9-96-94.1l-32.3 32.3c-2.2 2.2-2.9 5.6-1.8 8.5l32.5 84.6c4.8 12.4-1.4 26.3-13.8 31s-26.3-1.4-31-13.8L81.1 412c-7.9-20.7-3-44.1 12.7-59.7l57.4-57.4L70.8 321.7c-2.4 .8-4.3 2.7-5.1 5.1L46.8 383.6C42.6 396.2 29 403 16.4 398.8S-3 381 1.2 368.4l18.9-56.8c5.6-16.7 18.7-29.8 35.4-35.4L116.1 256 55.6 235.8c-16.7-5.6-29.8-18.7-35.4-35.4L1.2 143.6C-3 131 3.8 117.4 16.4 113.2s26.2 2.6 30.4 15.2l18.9 56.8c.8 2.4 2.7 4.3 5.1 5.1L176 225.4l0-65.4c0-31.8 18.6-59.3 45.5-72.2z"]]
}, faClockThree = {
  prefix: "fad",
  iconName: "clock-three",
  icon: [512, 512, [], "e356", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112 80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-104 0c-13.3 0-24-10.7-24-24l0-136z", "M256 96c-13.3 0-24 10.7-24 24l0 136c0 13.3 10.7 24 24 24l104 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-80 0 0-112c0-13.3-10.7-24-24-24z"]]
}, faHandsBound = {
  prefix: "fad",
  iconName: "hands-bound",
  icon: [640, 512, [], "e4f9", ["M32 32l0 64 0 59.1 0 .7L32 192l0 21.9c0 14.2 5.1 27.9 14.3 38.7L131.6 352 288 352l0-32 0-61.9c0-24.6-9-48.4-25.4-66.8l-46.7-52.5c-11.5-13-31.3-14.4-44.5-3.2s-15.2 30.9-4.4 44.5l27.6 34.5c7 8.8 4.7 21.8-5.1 27.5c-8.1 4.8-18.6 2.7-24.2-4.8L96 144.8 96 96l0-64C96 14.3 81.7 0 64 0S32 14.3 32 32zM160 480l0 32 128 0 0-32-128 0zM352 258.1l0 61.9 0 32 156.4 0 85.3-99.5c9.2-10.8 14.3-24.5 14.3-38.7l0-21.9 0-36.2 0-.7L608 96l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64 0 48.8-69.3 92.4c-5.7 7.6-16.1 9.6-24.2 4.8c-9.7-5.7-12.1-18.7-5.1-27.5L473 180c10.8-13.5 8.9-33.3-4.4-44.5s-33-9.8-44.5 3.2l-46.7 52.5C361 209.7 352 233.4 352 258.1zM352 480l0 32 128 0 0-32-128 0z", "M128 352c-13.3 0-24 10.7-24 24s10.7 24 24 24l384 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-384 0zm0 80c-13.3 0-24 10.7-24 24s10.7 24 24 24l384 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-384 0z"]]
}, faScalpelLineDashed = {
  prefix: "fad",
  iconName: "scalpel-line-dashed",
  icon: [576, 512, ["scalpel-path"], "f61e", ["M1.2 502.1c2.5 6 8.3 9.9 14.8 9.9c18.1 0 84.1-8.4 145.9-33.1C222.5 454.6 288 410.9 288 336l0-16-16 0-96 0-6.6 0-4.7 4.7-160 160c-4.6 4.6-5.9 11.5-3.5 17.4z", "M387.5 24.6C400.9 9 420.5 0 441.2 0C480.3 0 512 31.7 512 70.8l0 3.4c0 17.9-6.5 35.2-18.2 48.7L337.2 303.5C328 314 314.8 320 300.9 320L168 320c-6.3 0-11.9-3.6-14.5-9.3s-1.7-12.4 2.4-17.1L387.5 24.6zM240 480l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm128 0l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16zm128 0l64 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-64 0c-8.8 0-16-7.2-16-16s7.2-16 16-16z"]]
}, faScalpelPath = faScalpelLineDashed, faFileInvoiceDollar = {
  prefix: "fad",
  iconName: "file-invoice-dollar",
  icon: [384, 512, [], "f571", ["M0 64C0 28.7 28.7 0 64 0L224 0c0 42.7 0 85.3 0 128c0 .6 0 1.1 0 1.6c0 .5 .1 1.1 .1 1.6c.1 1.1 .3 2.1 .5 3.2c.2 1 .5 2.1 .8 3.1c.2 .5 .3 1 .5 1.5s.4 1 .6 1.5c1.6 3.8 4 7.3 6.9 10.2s6.3 5.2 10.2 6.9c1.9 .8 3.9 1.4 6 1.9c1 .2 2.1 .4 3.2 .5c.5 .1 1.1 .1 1.6 .1s1.1 0 1.6 0l128 0 0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM64 80c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 64c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0c-8.8 0-16 7.2-16 16zm64.2 150.9c-.1 1.2-.1 2.3-.1 3.6c0 1.2 .1 2.3 .1 3.4s.2 2.2 .4 3.2c.3 2.1 .8 4.1 1.4 6c1.2 3.8 2.9 7.2 5 10.3c4.2 6.1 9.8 10.9 15.8 14.5c10.5 6.3 23.8 10.4 34.8 13.7c.5 .2 1.1 .3 1.6 .5c12.5 3.8 22.2 6.9 29 11.2c5.9 3.7 7.7 7 7.7 11.6c.1 6.6-2.7 10.8-7.8 14c-5.8 3.6-14.5 5.6-23.7 5.3c-11.8-.4-22.7-4.1-36.3-8.7c-2.3-.8-4.7-1.6-7.1-2.4c-8.4-2.8-17.4 1.7-20.2 10.1c-.3 .8-.5 1.7-.6 2.5c-.1 .4-.1 .8-.2 1.3c0 .2 0 .4-.1 1.3l.1 1.3c0 0 0 .6 .1 1.2c.1 .8 .3 1.6 .6 2.4c.5 1.6 1.2 3 2.2 4.4c1.9 2.7 4.6 4.8 8 5.9c2 .7 4.1 1.4 6.2 2.1c9.2 3.2 19.7 6.8 30.9 8.9c0 5.9 0 11.9 0 17.8c0 .6 0 1.1 .1 1.6s.1 1.1 .2 1.6c.2 1 .5 2 .9 3c.8 1.9 2 3.6 3.4 5.1c2.9 2.9 6.9 4.7 11.3 4.7c8.8 0 16-7.2 16-16l0-17.1c8.7-1.4 17.4-4.3 25.1-9.1c6.6-4.1 12.4-9.7 16.5-16.6c2-3.5 3.7-7.3 4.8-11.4c.5-2.1 1-4.2 1.2-6.5c.1-1.1 .2-2.3 .3-3.4c.1-1.1 .1-2.3 .1-3.5c-.2-18.6-10.6-30.7-22.7-38.3c-11-6.9-25-11.2-36.3-14.6l-.5-.1c-12.6-3.8-22.3-6.8-29.2-10.9c-3-1.8-4.8-3.4-5.9-5c-.5-.8-.9-1.6-1.1-2.4c-.1-.4-.2-.8-.2-1.3c0-.4-.1-.8-.1-1.2c0-.8 0-1.4 .1-2.1s.2-1.3 .4-1.8c.3-1.2 .8-2.3 1.5-3.3c1.3-2.1 3.4-3.9 6.2-5.6c6.2-3.7 15.1-5.7 23.6-5.5c10.1 .2 21 2.3 32.1 5.3c8.5 2.3 17.3-2.8 19.6-11.3s-2.8-17.3-11.3-19.6c-7.5-2-15.6-3.9-24.1-5.1c0-5.8 0-11.5 0-17.3c0-8.8-7.2-16-16-16c-4.4 0-8.4 1.8-11.3 4.7c-1.4 1.4-2.6 3.2-3.4 5.1c-.4 1-.7 2-.9 3c-.1 .5-.2 1.1-.2 1.6s-.1 1.1-.1 1.5c0 5.9 0 11.7 0 17.5c-8.3 1.5-16.7 4.3-24.1 8.7c-6.5 3.9-12.5 9.1-16.8 15.9c-2.2 3.4-3.9 7.1-5.1 11.2c-.6 2.1-1.1 4.2-1.4 6.4c-.2 1.1-.3 2.3-.4 3.4z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM208 232c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 17.3c-8.3 1.5-16.7 4.3-24.1 8.7c-13 7.7-23.9 21.1-23.8 40.5c.1 18.4 10.8 30.1 22.7 37.3c10.5 6.3 23.8 10.4 34.8 13.7c0 0 0 0 0 0l1.6 .5c12.5 3.8 22.2 6.9 29 11.2c5.9 3.7 7.7 7 7.7 11.6c.1 6.6-2.7 10.8-7.8 14c-5.8 3.6-14.5 5.6-23.7 5.3c-11.8-.4-22.7-4.1-36.3-8.7c0 0 0 0 0 0s0 0 0 0s0 0 0 0c-2.3-.8-4.7-1.6-7.1-2.4c-8.4-2.8-17.4 1.7-20.2 10.1s1.7 17.4 10.1 20.2c2 .7 4.1 1.4 6.2 2.1c0 0 0 0 0 0c9.2 3.2 19.7 6.8 30.9 8.9l0 17.8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-17.1c8.7-1.4 17.4-4.3 25.1-9.1c13.3-8.3 23.2-22.2 22.9-41.6c-.2-18.5-10.6-30.6-22.7-38.2c-11-6.9-25-11.2-36.3-14.6c0 0 0 0 0 0s0 0 0 0l-.5-.1c-12.6-3.8-22.3-6.8-29.2-10.9c-6-3.6-7.2-6.4-7.3-10.1c0-5.4 2.4-9.4 8.1-12.8c6.2-3.7 15.1-5.7 23.6-5.5c10.1 .2 21 2.3 32.1 5.3c8.5 2.3 17.3-2.8 19.6-11.3s-2.8-17.3-11.3-19.6c-7.5-2-15.6-3.9-24.1-5.1l0-17.3z"]]
}, faPipeSmoking = {
  prefix: "fad",
  iconName: "pipe-smoking",
  icon: [640, 512, [], "e3c4", ["M361.5 192c5.6 .3 11.2 2 16.2 5.3l24 16c.7 .5 1.4 1 2.1 1.5s1.3 1.1 1.9 1.7c1.2 1.1 2.4 2.4 3.4 3.7c2 2.6 3.6 5.5 4.8 8.5l81.3-122C513.1 80 543.1 64 575.2 64L608 64c17.7 0 32-14.3 32-32s-14.3-32-32-32L575.2 0C521.7 0 471.7 26.7 442 71.2L361.5 192z", "M377.8 197.4c-14.7-9.8-34.6-5.8-44.4 8.9L256 322.3l0-50.3c0-26.5-21.5-48-48-48L48 224c-26.5 0-48 21.5-48 48l0 82.9C0 441.7 70.3 512 157.1 512c52.5 0 101.6-26.2 130.7-69.9L410.6 257.8c9.8-14.7 5.8-34.6-8.9-44.4l-24-16z"]]
}, faFaceAstonished = {
  prefix: "fad",
  iconName: "face-astonished",
  icon: [512, 512, [], "e36b", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM100.3 154.9c-6-6.5-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8zM208.4 224a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM208 352c0-26.5 21.5-48 48-48s48 21.5 48 48l0 32c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-32zm96-240c0-8.8 7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16zm64.4 112a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M192 128c-4.4 0-8.8 .3-13 .9c-21.2 2.8-40.6 12.4-56.1 26.8c-6.5 6-16.6 5.7-22.6-.8s-5.7-16.6 .8-22.6c20.1-18.7 45.5-31.5 73.7-35.2c5.6-.7 11.4-1.1 17.2-1.1c8.8 0 16 7.2 16 16s-7.2 16-16 16zm-15.6 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm160 0a32 32 0 1 1 0 64 32 32 0 1 1 0-64zM333 128.9c-4.3-.6-8.6-.9-13-.9c-8.8 0-16-7.2-16-16s7.2-16 16-16c5.8 0 11.6 .4 17.2 1.1c28.2 3.7 53.7 16.4 73.7 35.2c6.5 6 6.8 16.2 .8 22.6s-16.2 6.8-22.6 .8c-15.5-14.5-34.8-24-56.1-26.8z"]]
}, faWindow = {
  prefix: "fad",
  iconName: "window",
  icon: [512, 512, [], "f40e", ["M0 224l512 0 0 192c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 224zm224-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M64 32C28.7 32 0 60.7 0 96L0 224l512 0 0-128c0-35.3-28.7-64-64-64L64 32zM96 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm64 32a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM288 96a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]]
}, faPlaneCircleExclamation = {
  prefix: "fad",
  iconName: "plane-circle-exclamation",
  icon: [640, 512, [], "e556", ["M0 297.3l0 65.5c0 10.6 10.2 18.3 20.4 15.4l171.6-49 0 70.9-57.6 43.2c-4 3-6.4 7.8-6.4 12.8l0 42c0 7.8 6.3 14 14 14c1.3 0 2.6-.2 3.9-.5L256 480l110.1 31.5c1.3 .4 2.6 .5 3.9 .5c6 0 11.1-3.7 13.1-9C344.5 470.7 320 422.2 320 368c0-60.6 30.6-114 77.1-145.6L320 178.3l0-84.6C320 59.5 292 0 256 0c-35 0-64 59.5-64 93.7l0 84.6L8.1 283.4c-5 2.8-8.1 8.2-8.1 13.9z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80z"]]
}, faEar = {
  prefix: "fad",
  iconName: "ear",
  icon: [384, 512, [128066], "f5f0", ["M0 192L0 368c0 36.9 14.1 73.7 42.2 101.8c56.2 56.2 147.4 56.2 203.6 0c20.4-20.4 33.4-45.4 39-71.7c5.1-23.9 16.9-46.7 35.1-62.9C359.2 300 384 248.9 384 192C384 86 298 0 192 0S0 86 0 192zm80.1-5.8c.1-1.9 .2-3.8 .4-5.7c.4-3.8 1-7.5 1.7-11.1c1.5-7.3 3.7-14.3 6.5-21c5.7-13.4 13.9-25.5 24-35.6C133.1 92.5 161.1 80 192 80c61.9 0 112 50.1 112 112c0 2.7 0 5.3 0 8c-.1 13.4-10.8 24-24 24c-6.6 0-12.6-2.7-17-7c-2.2-2.2-3.9-4.8-5.1-7.6c-.6-1.4-1.1-2.9-1.4-4.5c-.2-.8-.3-1.6-.4-2.4s-.1-1.6-.1-2.5c0-2.7 0-5.3 0-8c0-35.3-28.7-64-64-64c-17.7 0-33.7 7.2-45.3 18.7c-5.8 5.8-10.5 12.7-13.7 20.3c-1.6 3.8-2.9 7.8-3.7 12c-.4 2.1-.8 4.2-1 6.4c-.1 1.1-.2 2.1-.2 3.2c-.1 1.1-.1 2.2-.1 3.3c0 6.7 0 13.5 0 20.3c0 .3 0 .7 .1 1c.1 .4 .1 .7 .2 1.1c.2 .7 .5 1.4 .9 2c.8 1.2 1.9 2.3 3.2 2.9c4.7 2.3 9.4 4.7 14 7c18.1 9.1 29.5 27.6 29.5 47.8c0 15.9-7 30.9-19.2 41.1c-12.5 10.4-24.9 20.8-37.4 31.2c-10.2 8.5-25.3 7.1-33.8-3.1c-1.9-2.2-3.3-4.7-4.2-7.3c-.5-1.3-.8-2.6-1-4c-.2-1-.3-2-.3-2c-.1-1-.1-1-.1-2.1c0-.9 0-1.1 0-1.3c0-.4 .1-.8 .1-1.3c.1-.8 .2-1.7 .4-2.5c.4-1.7 .9-3.3 1.6-4.9c1.4-3.2 3.6-6.1 6.5-8.4c12.5-10.4 24.9-20.8 37.4-31.2c1.2-1 2-2.6 2-4.2c0-2.1-1.2-4-3-4.9c-4.7-2.3-9.4-4.7-14-7c-9.5-4.7-17.2-12-22.6-20.6c-2.7-4.3-4.8-9.1-6.2-14c-.7-2.5-1.3-5-1.6-7.6c-.2-1.3-.3-2.6-.4-3.9c0-.7-.1-1.3-.1-2s0-1.3 0-2c0-6.7 0-13.5 0-20.3c0-1.9 0-2.4 0-2.9c0-.9 .1-1.9 .1-2.8z", "M192 128c-35.3 0-64 28.7-64 64l0 20.2c0 3 1.7 5.8 4.4 7.2l14 7c18.1 9.1 29.5 27.6 29.5 47.8c0 15.9-7 30.9-19.2 41.1l-37.4 31.2c-10.2 8.5-25.3 7.1-33.8-3.1s-7.1-25.3 3.1-33.8L126 278.4c1.2-1 2-2.6 2-4.2c0-2.1-1.2-4-3-4.9l-14-7c-19-9.5-31-28.9-31-50.1L80 192c0-61.9 50.1-112 112-112s112 50.1 112 112l0 8c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-8c0-35.3-28.7-64-64-64z"]]
}, faFileLock = {
  prefix: "fad",
  iconName: "file-lock",
  icon: [576, 512, [], "e3a6", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 33.6c-19.8 20.2-32 47.9-32 78.4l0 24.6c-19.1 11.1-32 31.7-32 55.4l0 128c0 11.4 3 22.2 8.3 31.5c-2.7 .3-5.5 .5-8.3 .5L64 512c-35.3 0-64-28.7-64-64L0 64z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zm80 80c17.7 0 32 14.3 32 32l0 48-64 0 0-48c0-17.7 14.3-32 32-32zm-80 32l0 48c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l0-48c0-44.2-35.8-80-80-80s-80 35.8-80 80z"]]
}, faDiagramVenn = {
  prefix: "fad",
  iconName: "diagram-venn",
  icon: [640, 512, [], "e15a", ["M192 256c0 61 24.4 116.4 64 156.8c23.6-4.8 45.4-14.8 64-28.8c-12.1-9.1-22.9-19.9-32-32c-7.4-9.8-13.7-20.6-18.7-32c-6.5-14.9-10.8-31.1-12.5-48c-.5-5.3-.8-10.6-.8-16s.3-10.7 .8-16c1.7-16.9 6-33.1 12.5-48c5-11.4 11.3-22.2 18.7-32c9.1-12.1 19.9-22.9 32-32c-18.5-14-40.3-24-63.9-28.8C216.4 139.6 192 195 192 256zM320 53.6c12.2 5.8 23.8 12.7 34.6 20.5c.5 .3 1 .7 1.5 1.1c9.9 7.3 19.3 15.4 27.9 24.1c39.6 40.4 64 95.7 64 156.8c0 1.9 0 3.8-.1 5.7s-.1 3.8-.2 5.7c-.2 3.8-.5 7.5-.8 11.2c-.7 7.4-1.9 14.8-3.3 22c-2.9 14.4-7.2 28.3-12.7 41.6c-11.1 26.5-27.1 50.5-46.9 70.7c-9 9.2-18.8 17.6-29.3 25.2c-10.9 7.8-22.4 14.7-34.6 20.5c29.2 13.8 61.7 21.6 96 21.6c123.7 0 224-100.3 224-224S539.7 32 416 32c-34.4 0-66.9 7.7-96 21.6z", "M352 352l-64 0c-7.4-9.8-13.7-20.6-18.7-32l101.4 0c6.5-14.9 10.8-31.1 12.5-48l-126.4 0c-.5-5.3-.8-10.6-.8-16s.3-10.7 .8-16l126.4 0c-1.7-16.9-6-33.1-12.5-48l-101.4 0c5-11.4 11.3-22.2 18.7-32l64 0c-29.2-38.9-75.7-64-128-64C135.6 96 64 167.6 64 256s71.6 160 160 160c52.3 0 98.8-25.1 128-64zM0 256a224 224 0 1 1 448 0A224 224 0 1 1 0 256z"]]
}, faArrowDownFromBracket = {
  prefix: "fad",
  iconName: "arrow-down-from-bracket",
  icon: [448, 512, [], "e667", ["M0 96l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-53-43-96-96-96L96 0C43 0 0 43 0 96z", "M246.6 502.6c-12.5 12.5-32.8 12.5-45.3 0l-128-128c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L192 402.7 192 192c0-17.7 14.3-32 32-32s32 14.3 32 32l0 210.7 73.4-73.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-128 128z"]]
}, faXRay = {
  prefix: "fad",
  iconName: "x-ray",
  icon: [512, 512, [], "f497", ["M32 96l0 320 448 0 0-320L32 96zm80 144c0-8.8 7.2-16 16-16l112 0 0-32-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 16 80 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-80 0 0 32 112 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-112 0 0 48c0 .4 0 .8 0 1.2l50.4-21.6c5.5-2.4 11.4-3.6 17.4-3.6l7.4 0c20.4 0 36.9 16.5 36.9 36.9c0 8.2-2.8 16.3-7.9 22.8l-19.4 24.8C347 376.8 332.1 384 316.4 384l-120.8 0c-15.7 0-30.6-7.2-40.3-19.6l-19.4-24.8c-5.1-6.5-7.9-14.5-7.9-22.8c0-20.4 16.5-36.9 36.9-36.9l7.4 0c6 0 11.9 1.2 17.4 3.6L240 305.2c0-.4 0-.8 0-1.2l0-48-112 0c-8.8 0-16-7.2-16-16zm80 96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm96 0a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M32 32C14.3 32 0 46.3 0 64S14.3 96 32 96l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32zm0 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 416z"]]
}, faGoalNet = {
  prefix: "fad",
  iconName: "goal-net",
  icon: [640, 512, [], "e3ab", ["M96 208c0 8.8 7.2 16 16 16l48 0 0 64-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 64-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 64 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 64 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 64 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-64 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-64 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-64 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-64 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-64 0 0-48c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16zm96 16l64 0 0 64-64 0 0-64zm0 96l64 0 0 64-64 0 0-64zm96-96l64 0 0 64-64 0 0-64zm0 96l64 0 0 64-64 0 0-64zm96-96l64 0 0 64-64 0 0-64zm0 96l64 0 0 64-64 0 0-64z", "M96 96c-17.7 0-32 14.3-32 32l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 128C0 75 43 32 96 32l448 0c53 0 96 43 96 96l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-320c0-17.7-14.3-32-32-32L96 96z"]]
}, faCoffinCross = {
  prefix: "fad",
  iconName: "coffin-cross",
  icon: [384, 512, [], "e051", ["M0 145.4c0 4.4 .6 8.7 1.8 12.9L97.3 488.9c4 13.7 16.5 23.1 30.7 23.1l127.9 0c14.3 0 26.8-9.4 30.7-23.1l95.5-330.6c1.2-4.2 1.8-8.5 1.8-12.9c0-11.2-4.1-22.1-11.5-30.6l-91-104C275.5 4 266.7 0 257.5 0l-131 0c-9.2 0-18 4-24.1 10.9l-91 104C4.1 123.3 0 134.2 0 145.4zM96 184c0-13.3 10.7-24 24-24l48 0 0-40c0-13.3 10.7-24 24-24s24 10.7 24 24l0 40 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 120c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-120-48 0c-13.3 0-24-10.7-24-24z", "M216 120c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l48 0 0 120c0 13.3 10.7 24 24 24s24-10.7 24-24l0-120 48 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-40z"]]
}, faOctopus = {
  prefix: "fad",
  iconName: "octopus",
  icon: [640, 512, [], "e688", ["M0 344c0 1.7 .2 3.4 .5 5.1l6.8 31.6c12.4 58 63.6 99.4 122.9 99.4l4.1 0c42.4 0 83.8-12.5 119-36l21.4-14.2c13.4-8.9 29.2-13.7 45.3-13.7s31.9 4.8 45.3 13.7L386.7 444c35.2 23.5 76.6 36 119 36l4.1 0c59.3 0 110.5-41.4 123-99.4l6.8-31.6c.4-1.7 .5-3.4 .5-5.1c0-11.1-7.7-21-19-23.4c-13-2.8-25.7 5.5-28.5 18.4l-6.8 31.6c-7.7 35.8-39.4 61.5-76 61.5c-41.1 0-74.8-31.9-77.6-72.4c-.1-1.8-.2-3.6-.2-5.4l0-1.4c0-4.5 .4-9.1 1.2-13.6l9.5-54.6 19.1-109.9c1.5-8.4 2.2-17 2.2-25.6l0-5.2C464 64.5 399.5 0 320 0S176 64.5 176 144c0 1.7 0 3.5 0 5.2c0 8.6 .7 17.1 2.2 25.6c9.5 54.9 19.1 109.7 28.6 164.6c.8 4.5 1.2 9 1.2 13.6l0 1.4c0 1.8-.1 3.6-.2 5.4c-2.8 40.4-36.4 72.4-77.6 72.4c-36.7 0-68.3-25.6-76-61.5L47.5 339c-2.8-13-15.5-21.2-28.5-18.4C7.7 322.9 0 332.9 0 344zm272-72a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm128 0a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M207.8 359.6c.1-1.8 .2-3.6 .2-5.4l0-1.4c0-4.5-.4-9.1-1.2-13.6L178.2 174.8c-1.5-8.4-2.2-17-2.2-25.6l0-5.2C176 64.5 240.5 0 320 0c0 0 0 0 0 0C240.5 0 176 64.5 176 144l0 5.2c0 8.6 .7 17.1 2.2 25.6l19 109.3c3.5 20.3-11.2 39.1-31.7 40.6c-16.3 1.2-31.2-9.2-35.8-24.8L118.8 263c-12.4-42.1-51-71-94.8-71c-13.3 0-24 10.7-24 24s10.7 24 24 24c22.6 0 42.4 14.9 48.8 36.5l10.9 36.9c11 37.3 46.5 62 85.3 59.2c14.4-1 27.7-5.7 38.9-13zm224.4 0c11.3 7.3 24.5 11.9 38.9 12.9c38.8 2.8 74.3-21.9 85.3-59.2l10.9-36.9c6.4-21.6 26.2-36.5 48.8-36.5c13.3 0 24-10.7 24-24s-10.7-24-24-24c-43.8 0-82.5 28.9-94.8 71l-10.9 36.9c-4.6 15.7-19.5 26-35.8 24.8c-20.3-1.5-35-20-31.8-40l-9.5 54.7c-.8 4.5-1.2 9-1.2 13.6l0 1.4c0 1.8 .1 3.6 .2 5.4zM272 272a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm112 16a16 16 0 1 0 0-32 16 16 0 1 0 0 32z"]]
}, faSpellCheck = {
  prefix: "fad",
  iconName: "spell-check",
  icon: [576, 512, [], "f891", ["M2.5 211.7c-6.8 16.3 .9 35 17.2 41.8c4 1.7 8.2 2.5 12.3 2.5c12.5 0 24.4-7.4 29.6-19.7L66.7 224l90.7 0 5.1 12.3c5.1 12.3 17 19.7 29.6 19.7c4.1 0 8.3-.8 12.3-2.5c16.3-6.8 24-25.5 17.2-41.8l-13.3-32-66.7-160C136.6 7.8 124.9 0 112 0S87.4 7.8 82.5 19.7l-66.7 160-13.3 32zM93.3 160L112 115.2 130.7 160l-37.3 0zM256 32l0 96 0 96c0 17.7 14.3 32 32 32l80 0c44.2 0 80-35.8 80-80c0-23.1-9.8-43.8-25.4-58.4c6-11.2 9.4-24 9.4-37.6c0-44.2-35.8-80-80-80L288 0c-17.7 0-32 14.3-32 32zm64 32l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0 0-32zm0 96l32 0 16 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0 0-32z", "M566.6 265.4c12.5 12.5 12.5 32.8 0 45.3l-192 192c-12.5 12.5-32.8 12.5-45.3 0l-96-96c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L352 434.7 521.4 265.4c12.5-12.5 32.8-12.5 45.3 0z"]]
}, faLocationXmark = {
  prefix: "fad",
  iconName: "location-xmark",
  icon: [384, 512, ["map-marker-times", "map-marker-xmark"], "f60e", ["M0 192c0 87.4 117 243 168.3 307.2c6.1 7.7 14.9 11.5 23.7 11.5s17.6-3.8 23.7-11.5C267 435 384 279.4 384 192C384 86 298 0 192 0S0 86 0 192zm104.1 61.7c.1-.8 .2-1.5 .3-2.3c.3-1.5 .7-3 1.3-4.4c1.2-2.9 2.9-5.6 5.3-7.9c15.7-15.7 31.4-31.4 47-47c-15.7-15.7-31.3-31.3-47-47c-9.4-9.4-9.4-24.6 0-33.9c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c15.7 15.7 31.4 31.4 47 47c15.7-15.7 31.4-31.4 47-47c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c9.4 9.4 9.4 24.6 0 33.9c-15.7 15.7-31.3 31.3-47 47c15.7 15.7 31.4 31.4 47 47c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17s-10.8 7-17 7s-12.3-2.3-17-7l-47-47c-15.7 15.7-31.3 31.4-47 47c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7c-2.3-2.3-4.1-5.1-5.3-7.9c-.6-1.4-1-2.9-1.3-4.4c-.2-1.1-.4-2.3-.3-2.3c-.1-1.2-.1-1.2-.1-2.3c0-1.5 .1-1.9 .1-2.3z", "M145 111c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]]
}, faMapMarkerTimes = faLocationXmark, faMapMarkerXmark = faLocationXmark, faCircleQuarterStroke = {
  prefix: "fad",
  iconName: "circle-quarter-stroke",
  icon: [512, 512, [], "e5d3", ["M0 256C0 397.4 114.6 512 256 512s256-114.6 256-256S397.4 0 256 0l0 64c106 0 192 86 192 192s-86 192-192 192S64 362 64 256L0 256z", "M256 0C114.6 0 0 114.6 0 256l224 0c17.7 0 32-14.3 32-32L256 0z"]]
}, faLasso = {
  prefix: "fad",
  iconName: "lasso",
  icon: [576, 512, [], "f8c8", ["M576 176c0 97.2-128.9 176-288 176c-13.2 0-26.3-.5-39-1.6c4.6 12.8 7 26.5 7 40.6c0 66.8-54.2 121-121 121l-71 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l71 0c31.5 0 57-25.5 57-57c0-21.6-12.2-41.3-31.5-51l-46.8-23.4 .2-.4C44.7 284.1 0 233.2 0 176C0 78.8 128.9 0 288 0S576 78.8 576 176zM288 288c123.7 0 224-50.1 224-112s-100.3-112-224-112S64 114.1 64 176s100.3 112 224 112z", ""]]
}, faSlash = {
  prefix: "fad",
  iconName: "slash",
  icon: [640, 512, [], "f715", ["M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z", ""]]
}, faPersonToPortal = {
  prefix: "fad",
  iconName: "person-to-portal",
  icon: [512, 512, ["portal-enter"], "e022", ["M352.7 222.4c3.2 1 6.5 1.6 10 1.6l21.3 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-21.3 0c-.8 0-1.7 0-2.5 0c-.9 0-1.7-.1-2.5-.1c-1.7-.1-3.4-.2-5-.4C357.4 414 391.1 512 432 512c44.2 0 80-114.6 80-256S476.2 0 432 0c-40.6 0-74.2 96.9-79.3 222.4z", "M320 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zM125.7 175.5c9.9-9.9 23.4-15.5 37.5-15.5c1.9 0 3.8 .1 5.6 .3L137.6 254c-9.3 28 1.7 58.8 26.8 74.5l86.2 53.9-25.4 88.8c-4.9 17 5 34.7 22 39.6s34.7-5 39.6-22l28.7-100.4c5.9-20.6-2.6-42.6-20.7-53.9L238 299l30.9-82.4 5.1 12.3C289 264.7 323.9 288 362.7 288l21.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-21.3 0c-12.9 0-24.6-7.8-29.5-19.7l-6.3-15c-14.6-35.1-44.1-61.9-80.5-73.1l-48.7-15c-11.1-3.4-22.7-5.2-34.4-5.2c-31 0-60.8 12.3-82.7 34.3L57.4 153.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l23.1-23.1zM91.2 352L32 352c-17.7 0-32 14.3-32 32s14.3 32 32 32l69.6 0c19 0 36.2-11.2 43.9-28.5L157 361.6l-9.5-6c-17.5-10.9-30.5-26.8-37.9-44.9L91.2 352z"]]
}, faPortalEnter = faPersonToPortal, faCalendarStar = {
  prefix: "fad",
  iconName: "calendar-star",
  icon: [448, 512, [], "f736", ["M0 192l448 0 0 272c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 192zM132.6 324.1l38.2 37.2-9 52.5c-1.5 8.5 7.5 15 15.1 11L224 400l47.2 24.8c7.6 4 16.5-2.5 15.1-11l-9-52.5 38.2-37.2c6.2-6 2.8-16.5-5.8-17.7l-52.7-7.7-23.6-47.8c-3.8-7.7-14.8-7.7-18.7 0l-23.6 47.8-52.7 7.7c-8.5 1.2-11.9 11.7-5.8 17.7z", "M128 0C110.3 0 96 14.3 96 32l0 32L48 64C21.5 64 0 85.5 0 112l0 80 448 0 0-80c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32zM233.3 250.9c-3.8-7.7-14.8-7.7-18.7 0l-23.6 47.8-52.7 7.7c-8.5 1.2-11.9 11.7-5.8 17.7l38.2 37.2-9 52.5c-1.5 8.5 7.5 15 15.1 11L224 400l47.2 24.8c7.6 4 16.5-2.5 15.1-11l-9-52.5 38.2-37.2c6.2-6 2.8-16.5-5.8-17.7l-52.7-7.7-23.6-47.8z"]]
}, faComputerMouse = {
  prefix: "fad",
  iconName: "computer-mouse",
  icon: [384, 512, [128433, "mouse"], "f8cc", ["M0 160C0 71.6 71.6 0 160 0l16 0 0 192L0 192l0-32zm0 64l192 0 192 0 0 128c0 88.4-71.6 160-160 160l-64 0C71.6 512 0 440.4 0 352L0 224zM208 0l16 0c88.4 0 160 71.6 160 160l0 32-176 0L208 0z", "M176 192L0 192l0 32 192 0 192 0 0-32-176 0L208 0 176 0l0 192z"]]
}, faMouse = faComputerMouse, faArrowRightToBracket = {
  prefix: "fad",
  iconName: "arrow-right-to-bracket",
  icon: [512, 512, ["sign-in"], "f090", ["M320 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-64 0c-17.7 0-32 14.3-32 32z", "M342.6 278.6c12.5-12.5 12.5-32.8 0-45.3l-128-128c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3L242.7 224 32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l210.7 0-73.4 73.4c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0l128-128z"]]
}, faSignIn = faArrowRightToBracket, faPegasus = {
  prefix: "fad",
  iconName: "pegasus",
  icon: [576, 512, [], "f703", ["M0 256l0 56c0 13.3 10.7 24 24 24s24-10.7 24-24l0-56c0-13.4 6.6-25.2 16.7-32.5c-.4-3.5-.7-7.1-.7-10.7c0-1 0-2 .1-3s.1-2 .2-3c.1-2 .3-3.9 .6-5.9c.5-3.9 1.4-7.7 2.4-11.4c2.1-7.4 5.2-14.4 9.1-20.8C33.2 174.5 0 211.4 0 256z", "M448 238.1l0-78.1 16 0 9.8 19.6c12.5 25.1 42.2 36.4 68.3 26c20.5-8.2 33.9-28 33.9-50.1L576 80c0-19.1-8.4-36.3-21.7-48l5.7 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L480 0 448 0C378.4 0 321.7 55.6 320 124.8L184.9 34.7c-4.9-3.3-11.2-3.6-16.4-.8s-8.5 8.2-8.5 14.1c0 48.1 3.8 99.9 26 139.8c9.2 16.6 21.7 31.3 38.2 42.7c-7.2-2.5-14-5.4-20.3-8.8c-22.5-12.1-38.6-29.4-49.9-49.8c-7.3-13.2-12.7-27.8-16.5-43C96 134.3 64 169.8 64 212.8c0 16.8 5 33.1 14.2 47.1l28.2 42.4c8.3 12.4 6.4 28.7-1.2 41.6c-16.5 28-20.6 62.2-10 93.9l17.5 52.4c4.4 13.1 16.6 21.9 30.4 21.9l33.7 0c21.8 0 37.3-21.4 30.4-42.1l-20.8-62.5c-2.1-6.4-.5-13.4 4.3-18.2l12.7-12.7c13.2-13.2 20.6-31.1 20.6-49.7c0-2.3-.1-4.6-.3-6.9l84 24c4.1 1.2 8.2 2.1 12.3 2.8L320 480c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-164.3c19.2-19.2 31.5-45.7 32-75.7c0 0 0 0 0 0l0-1.9zM496 64a16 16 0 1 1 0 32 16 16 0 1 1 0-32z"]]
}, faFilesMedical = {
  prefix: "fad",
  iconName: "files-medical",
  icon: [448, 512, [], "f7fd", ["M96 64l0 288c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-256-64 0c-17.7 0-32-14.3-32-32l0-64L160 0C124.7 0 96 28.7 96 64zm80 176c0-8.8 7.2-16 16-16l48 0 0-48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48 48 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16l0-32z", "M352 64l0-64 96 96-64 0c-17.7 0-32-14.3-32-32zM24 96c13.3 0 24 10.7 24 24l0 256c0 48.6 39.4 88 88 88l192 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-192 0C60.9 512 0 451.1 0 376L0 120c0-13.3 10.7-24 24-24zm216 80c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 48 48 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-48 0 0 48c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-48-48 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16l48 0 0-48z"]]
}, faCannon = {
  prefix: "fad",
  iconName: "cannon",
  icon: [640, 512, [], "e642", ["M0 408c0-17.6 9.7-34.6 26.5-43l22.5-11.3c1 7.9 2.6 15.8 5 23.6c1.2 3.9 2.5 7.8 4.1 11.6c.8 1.9 1.6 3.8 2.4 5.8c.4 .9 .8 1.9 1.3 2.9c.4 .9 .8 1.7 1.3 2.7c7.5 15 17.3 28.2 28.8 39.3L69.5 450.9c-23.7 11.9-52.5 2.2-64.4-21.5C1.6 422.6 0 415.3 0 408zm288-40c0-61.9 50.1-112 112-112c41.3 0 77.4 22.4 96.8 55.6c9.7 16.6 15.2 35.8 15.2 56.4c0 61.9-50.1 112-112 112c-37.4 0-70.5-18.3-90.9-46.5C295.8 415.1 288 392.5 288 368zm80 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M256.4 464.8c-71.1 35.6-157.6 6.7-193.2-64.4s-6.7-157.6 64.4-193.2c49.5-24 287.2-107.9 394.6-145.5c30.3-10.6 63.6 3.1 78 31.8L630.9 155c14.4 28.7 5.3 63.6-21.4 81.5C580.3 256.1 540 283 496.8 311.6C477.4 278.4 441.3 256 400 256c-61.9 0-112 50.1-112 112c0 24.5 7.8 47.1 21.2 65.5c-23.4 14.6-42 25.7-52.7 31.3z"]]
}, faNfcLock = {
  prefix: "fad",
  iconName: "nfc-lock",
  icon: [576, 512, [], "e1f8", ["M0 96L0 416c0 35.3 28.7 64 64 64l256 0 0-64-208 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16l208 0 0-32c0-23.7 12.9-44.4 32-55.4l0-24.6 0-128c0-8.8-7.2-16-16-16l-80 0c-8.8 0-16 7.2-16 16l0 66.7c18.6 6.6 32 24.4 32 45.3c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3l0-66.7c0-26.5 21.5-48 48-48l80 0c26.5 0 48 21.5 48 48l0 49.6c16.8-17.1 39.1-28.9 64-32.5L448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96z", "M432 272l0 48 64 0 0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]]
}, faPersonSkiLift = {
  prefix: "fad",
  iconName: "person-ski-lift",
  icon: [512, 512, ["ski-lift"], "f7c8", ["M2.3 210.4l65 135.8c18.3 38.4 61.5 58.1 102.5 46.9l36.5-9.9c12.8-3.5 20.3-16.7 16.8-29.5s-16.7-20.3-29.5-16.8l-36.5 9.9c-18.7 5.1-38.3-3.9-46.6-21.3l-65-135.8c-5.7-12-20-17-32-11.3s-17 20-11.3 32zm95.1 286C101.1 506 110.2 512 120 512c2.8 0 5.6-.5 8.3-1.5L459.7 388c31.4-11.6 52.3-41.6 52.3-75l0-1c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 1c0 13.4-8.3 25.4-20.9 30c-41 15.2-82.1 30.3-123.1 45.5c-21.3 7.9-42.7 15.8-64 23.7L111.7 465.5c-12.4 4.6-18.8 18.4-14.2 30.8zM224 16l0 190.8 32-8.5L256 16c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M64 80a48 48 0 1 1 96 0A48 48 0 1 1 64 80zm36.4 138c-14.2-30.8 8.3-66 42.2-66c18.2 0 34.8 10.7 42.3 27.3l28.8 63.4 55.9-14.9c25.4-6.8 50.3 12.4 50.3 38.6l0 122.1-64 23.7 0-114.5-66.7 17.8c-22.6 6-46.2-5.1-55.9-26.3L100.4 218z"]]
}, faSkiLift = faPersonSkiLift, faSquare6 = {
  prefix: "fad",
  iconName: "square-6",
  icon: [448, 512, [], "e25b", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zM128 288c0 53 43 96 96 96s96-43 96-96c0-44-29.6-81.1-70-92.4c9.9-8.5 19.7-16.9 29.6-25.4c10.1-8.6 11.2-23.8 2.6-33.8c-4.7-5.5-11.5-8.4-18.2-8.4c-5.5 0-11.1 1.9-15.6 5.8c-27.2 23.3-54.4 46.6-81.6 70C142.2 224.8 128 255.6 128 288zm144 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M279.6 170.2c10.1-8.6 11.2-23.8 2.6-33.8s-23.8-11.2-33.8-2.6l-81.6 70C142.2 224.8 128 255.6 128 288c0 53 43 96 96 96s96-43 96-96c0-44-29.6-81.1-70-92.4l29.6-25.4zM272 288a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z"]]
}, faShopSlash = {
  prefix: "fad",
  iconName: "shop-slash",
  icon: [640, 512, ["store-alt-slash"], "e070", ["M0 155.2c0-7.3 2.2-14.4 6.2-20.4L21 112.5 121.8 192l-85 0C16.5 192 0 175.5 0 155.2zM64 224l64 0 0 160 192 0 0-35.9 64 50.4 0 65.5c0 26.5-21.5 48-48 48l-224 0c-26.5 0-48-21.5-48-48l0-80 0-160zM74.1 32.8l7.6-11.4C90.7 8 105.6 0 121.7 0L518.3 0c16.1 0 31 8 39.9 21.4l75.6 113.3c4 6.1 6.2 13.2 6.2 20.4c0 20.3-16.5 36.8-36.8 36.8l-325.9 0C209.5 138.9 141.8 85.9 74.1 32.8zM320 224l64 0 0 51.7-64-50.2 0-1.5zm192 0l64 0 0 202.2c-21.3-16.7-42.7-33.4-64-50.2l0-152z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faStoreAltSlash = faShopSlash, faWindTurbine = {
  prefix: "fad",
  iconName: "wind-turbine",
  icon: [512, 512, [], "f89b", ["M128 488c0 13.3 10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-72 0 0-94.3c-21.3-34.7-42.7-69.3-64-104L224 464l-72 0c-13.3 0-24 10.7-24 24z", "M345.2 404.1c2.5 17.2-20.3 25.5-29.5 10.7L214 249.4c-1.8-2.9-4.5-5.2-7.7-6.5L25.7 171.4C9.5 165 13.7 141 31.1 140.6l194.1-5.4c3.5-.1 6.8-1.3 9.5-3.5L387 11c13.6-10.8 32.3 4.8 24 20.1L318.6 202c-1.6 3-2.3 6.5-1.8 9.9l28.4 192.1zM256 216a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]]
}, faSlidersSimple = {
  prefix: "fad",
  iconName: "sliders-simple",
  icon: [512, 512, [], "e253", ["M0 160c0 17.7 14.3 32 32 32l293.5 0c-3.5-10-5.5-20.8-5.5-32c0-1.4 0-2.8 .1-4.2s.1-2.8 .3-4.1c.2-2.7 .6-5.5 1-8.1c.9-5.3 2.3-10.5 4.1-15.5L32 128c-17.7 0-32 14.3-32 32zM186.5 320c3.5 10 5.5 20.8 5.5 32c0 1.4 0 2.8-.1 4.2s-.1 2.8-.3 4.1c-.2 2.7-.6 5.5-1 8.1c-.9 5.3-2.3 10.5-4.1 15.5L480 384c17.7 0 32-14.3 32-32s-14.3-32-32-32l-293.5 0z", "M416 192a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-128a96 96 0 1 0 0 192 96 96 0 1 0 0-192zM96 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm0-128a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"]]
}, faGridRound = {
  prefix: "fad",
  iconName: "grid-round",
  icon: [448, 512, [], "e5da", ["M0 256a64 64 0 1 0 128 0A64 64 0 1 0 0 256zM160 96a64 64 0 1 0 128 0A64 64 0 1 0 160 96zm0 320a64 64 0 1 0 128 0 64 64 0 1 0 -128 0zM320 256a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M128 96A64 64 0 1 1 0 96a64 64 0 1 1 128 0zm0 320A64 64 0 1 1 0 416a64 64 0 1 1 128 0zm96-96a64 64 0 1 1 0-128 64 64 0 1 1 0 128zM448 96A64 64 0 1 1 320 96a64 64 0 1 1 128 0zM384 480a64 64 0 1 1 0-128 64 64 0 1 1 0 128z"]]
}, faBadgeSheriff = {
  prefix: "fad",
  iconName: "badge-sheriff",
  icon: [448, 512, [], "f8a2", ["M160 256a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M272 48c0 14.8-6.7 28-17.2 36.8l25 42.8c5.7 9.8 16.2 15.8 27.5 15.9l47.6 .2c6.7-18.5 24.4-31.7 45.2-31.7c26.5 0 48 21.5 48 48s-21.5 48-48 48c-5.9 0-11.6-1.1-16.9-3.1L363 240.1c-5.6 9.8-5.6 21.9 0 31.8l20.1 35.2c5.3-2 10.9-3.1 16.9-3.1c26.5 0 48 21.5 48 48s-21.5 48-48 48c-20.8 0-38.5-13.2-45.2-31.7l-47.6 .2c-11.3 0-21.8 6.1-27.5 15.9l-25 42.8c10.5 8.8 17.2 22 17.2 36.8c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-14.8 6.7-28 17.2-36.8l-25-42.8c-5.7-9.8-16.2-15.8-27.5-15.9l-47.6-.2C86.5 386.8 68.8 400 48 400c-26.5 0-48-21.5-48-48s21.5-48 48-48c5.9 0 11.6 1.1 16.9 3.1L85 271.9c5.6-9.8 5.6-21.9 0-31.8L64.9 204.9c-5.3 2-10.9 3.1-16.9 3.1c-26.5 0-48-21.5-48-48s21.5-48 48-48c20.8 0 38.5 13.2 45.2 31.7l47.6-.2c11.3 0 21.8-6.1 27.5-15.9l25-42.8C182.7 76 176 62.8 176 48c0-26.5 21.5-48 48-48s48 21.5 48 48zM224 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]]
}, faServer = {
  prefix: "fad",
  iconName: "server",
  icon: [512, 512, [], "f233", ["M0 352l0 64c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64L64 288c-35.3 0-64 28.7-64 64zm368 32a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm24-256a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm56 256a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M64 32C28.7 32 0 60.7 0 96l0 64c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64L64 32zm280 72a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm48 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm32 280a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]]
}, faVirusCovidSlash = {
  prefix: "fad",
  iconName: "virus-covid-slash",
  icon: [640, 512, [], "e4a9", ["M64 216c0-13.3 10.7-24 24-24s24 10.7 24 24l0 16 33.6 0c.9-6.3 2-12.4 3.5-18.5L401.3 412.2c-17.6 9.2-36.9 15.4-57.3 18.2l0 33.6 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l16 0 0-33.6c-30.7-4.2-58.8-16.3-82.3-34.1L189.9 420l11.3 11.3c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-56.6-56.6c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0L156 386.1l23.8-23.8c-17.9-23.5-29.9-51.7-34.1-82.3L112 280l0 16c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-80zM134.1 79.8l33.1-33.1c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9L189.9 92l23.8 23.8c23.5-17.9 51.7-29.9 82.3-34.1L296 48l-16 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-16 0 0 33.6c30.7 4.2 58.8 16.3 82.3 34.1L450.1 92 438.8 80.6c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l56.6 56.6c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L484 125.9l-23.8 23.8c17.9 23.5 29.9 51.7 34.1 82.3l33.6 0 0-16c0-13.3 10.7-24 24-24s24 10.7 24 24l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-16-33.6 0c-3.2 23.3-10.9 45.2-22.3 64.7C359.4 256.4 246.8 168.1 134.1 79.8z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faIntersection = {
  prefix: "fad",
  iconName: "intersection",
  icon: [384, 512, [8898], "f668", ["M32 480c17.7 0 32-14.3 32-32l0-224c0-70.7 57.3-128 128-128s128 57.3 128 128l0 224c0 17.7 14.3 32 32 32s32-14.3 32-32l0-224c0-106-86-192-192-192S0 118 0 224L0 448c0 17.7 14.3 32 32 32z", ""]]
}, faShopLock = {
  prefix: "fad",
  iconName: "shop-lock",
  icon: [640, 512, [], "e4a5", ["M0 155.2C0 175.5 16.5 192 36.8 192l412.8 0c20.2-19.8 47.9-32 78.4-32c30.5 0 58.1 12.2 78.3 31.9c18.9-1.6 33.7-17.4 33.7-36.7c0-7.3-2.2-14.4-6.2-20.4L558.2 21.4C549.3 8 534.4 0 518.3 0L121.7 0c-16 0-31 8-39.9 21.4L6.2 134.7c-4 6.1-6.2 13.2-6.2 20.4zM64 224l0 160 0 80c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-80 0-32 0-128-64 0 0 160-192 0 0-160-64 0z", "M496 272l0 48 64 0 0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]]
}, faFamily = {
  prefix: "fad",
  iconName: "family",
  icon: [512, 512, [], "e300", ["M21.8 282.7c-.2 1.8-.2 3.6-.2 5.4c0 27.5 17.6 51.3 42.4 60.2L64 464c0 26.5 21.5 48 48 48l32 0c13.5 0 25.7-5.6 34.4-14.5c-1.6-5.5-2.4-11.4-2.4-17.5l0-56.4c-19.6-17.6-32-43.1-32-71.6l0-16c0-43.1 24.3-80.5 60-99.2c-17.1-14.7-28-36.5-28-60.8c0-3.9 .3-7.8 .8-11.5c-8.3-2.9-17.2-4.5-26.4-4.5l-44.8 0c-41.6 0-76.3 31.9-79.7 73.4l-4.1 49.3zM64 64a64 64 0 1 0 128 0A64 64 0 1 0 64 64zM308 236.8c35.7 18.7 60 56.1 60 99.2l0 16c0 28.4-12.4 54-32 71.6l0 56.4c0 6.1-.8 11.9-2.4 17.5c8.7 9 20.9 14.5 34.4 14.5l32 0c26.5 0 48-21.5 48-48l0-80 21.6 0c18.2 0 32-14.9 32-31.9c0-2.9-.4-5.9-1.3-8.8L461.3 206.4c-7.8-27.5-33-46.4-61.5-46.4l-31.4 0c-11.8 0-23 3.2-32.6 8.9c.2 2.3 .3 4.7 .3 7.1c0 24.3-10.9 46.1-28 60.8zM320 64a64 64 0 1 0 128 0A64 64 0 1 0 320 64z", "M208 176a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM176 336c0-44.2 35.8-80 80-80s80 35.8 80 80l0 16c0 23.7-12.9 44.4-32 55.4l0 72.6c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32l0-72.6c-19.1-11.1-32-31.7-32-55.4l0-16z"]]
}, faHourglassStart = {
  prefix: "fad",
  iconName: "hourglass-start",
  icon: [384, 512, ["hourglass-1"], "f251", ["M32 64l32 0 32 0 192 0 32 0 32 0 0 11c0 42.4-16.9 83.1-46.9 113.1L237.3 256l67.9 67.9c30 30 46.9 70.7 46.9 113.1l0 11-64 0 0-11c0-25.5-10.1-49.9-28.1-67.9L192 301.3l-67.9 67.9c-18 18-28.1 42.4-28.1 67.9l0 11-64 0 0-11c0-42.4 16.9-83.1 46.9-113.1L146.7 256 78.9 188.1C48.9 158.1 32 117.4 32 75l0-11z", "M32 0C14.3 0 0 14.3 0 32S14.3 64 32 64l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 0zm0 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l320 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448z"]]
}, faHourglass1 = faHourglassStart, faUserHairBuns = {
  prefix: "fad",
  iconName: "user-hair-buns",
  icon: [448, 512, [], "e3d3", ["M128 112l0 64c0 5.5 .5 10.8 1.3 16c7.6 45.4 47.1 80 94.7 80s87.1-34.6 94.7-80c.9-5.2 1.3-10.5 1.3-16l0-64-32 0c-26.2 0-49.4-12.6-64-32c-14.6 19.4-37.8 32-64 32l-32 0z", "M109.8 70.1C131 28.5 174.1 0 224 0s93 28.5 114.2 70.1c6.8-3.9 14.7-6.1 23.1-6.1c25.8 0 46.7 20.9 46.7 46.7l0 25.3c0 30.9-25.1 56-56 56l-33.3 0c.9-5.2 1.3-10.5 1.3-16l0-64-32 0c-26.2 0-49.4-12.6-64-32c-14.6 19.4-37.8 32-64 32l-32 0 0 64c0 5.5 .5 10.8 1.3 16L96 192c-30.9 0-56-25.1-56-56l0-25.3C40 84.9 60.9 64 86.7 64c8.4 0 16.2 2.2 23.1 6.1zM0 481.3C0 392.2 72.2 320 161.3 320l125.4 0C375.8 320 448 392.2 448 481.3c0 17-13.8 30.7-30.7 30.7L30.7 512C13.8 512 0 498.2 0 481.3z"]]
}, faBlenderPhone = {
  prefix: "fad",
  iconName: "blender-phone",
  icon: [576, 512, [], "f6b6", ["M196.2 47.9c0 1.3 .1 2.7 .2 4.1L224 384l256 0 24-96-104 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l112 0 16-64-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l136 0 16-64L400 96c-8.8 0-16-7.2-16-16s7.2-16 16-16l160 0 6.1-24.2C571.1 19.6 555.8 0 535 0L244.2 0c-26.7 0-48 21.7-48 47.9z", "M147.5 30.7c10.8 6.7 15.3 21 10.6 33.4l-22 57.8c-4.2 10.9-14.5 17.6-25.3 16.4l-33.3-3.6c-13.6 42.2-13.6 88.4 0 130.7l33.3-3.6c10.9-1.2 21.2 5.5 25.3 16.4l22 57.8c4.7 12.4 .2 26.7-10.6 33.4l-44 27.2c-9.7 6-21.9 4.2-29.8-4.3C-24.6 286-24.6 114 73.7 7.8C81.6-.7 93.8-2.5 103.5 3.5l44 27.2zM560 64l-8 32L400 96c-8.8 0-16-7.2-16-16s7.2-16 16-16l160 0zm-24 96l-8 32-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l136 0zm-24 96l-8 32-104 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l112 0zM208 384l288 0c26.5 0 48 21.5 48 48l0 32c0 26.5-21.5 48-48 48l-288 0c-26.5 0-48-21.5-48-48l0-32c0-26.5 21.5-48 48-48zm144 96a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faHourglassClock = {
  prefix: "fad",
  iconName: "hourglass-clock",
  icon: [576, 512, [], "e41b", ["M0 32C0 49.7 14.3 64 32 64l0 11c0 42.4 16.9 83.1 46.9 113.1L146.7 256 78.9 323.9C48.9 353.9 32 394.6 32 437l0 11c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 256 0 10.8 0c-23.3-16.4-42.5-38.4-55.6-64L96 448l0-11c0-25.5 10.1-49.9 28.1-67.9L192 301.3l64 64c.4-26.2 6.5-51.1 17.2-73.3l-36-36 67.9-67.9c30-30 46.9-70.7 46.9-113.1l0-11c17.7 0 32-14.3 32-32s-14.3-32-32-32L320 0 64 0 32 0C14.3 0 0 14.3 0 32zM96 64l192 0 0 11c0 25.5-10.1 49.9-28.1 67.9L192 210.7l-67.9-67.9C106.1 124.9 96 100.4 96 75l0-11z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm16-208l0 48 32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-48 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16s16 7.2 16 16z"]]
}, faPersonSeatReclined = {
  prefix: "fad",
  iconName: "person-seat-reclined",
  icon: [512, 512, [], "e21f", ["M32.5 165.9L65.9 343.6C77.2 404.1 130.1 448 191.7 448l80.3 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-80.3 0c-30.8 0-57.2-21.9-62.9-52.2L95.5 154.1C92.6 138.7 79.1 128 64 128c-2 0-3.9 .2-5.9 .6c-17.4 3.3-28.8 20-25.6 37.3z", "M128 80a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM257 256l8 32 53.8 0c33.3 0 63.2 20.7 74.9 51.9l25.5 68 18.7-6.2c16.8-5.6 34.9 3.5 40.5 20.2s-3.5 34.9-20.2 40.5l-48 16c-16.3 5.4-34-3-40.1-19.1l-36.3-96.9c-2.3-6.2-8.3-10.4-15-10.4l-78.1 0c-.5 0-.9 0-1.4 0l-6.3 0c-29.4 0-55-20-62.1-48.5L149.8 219c-7.5-30 15.2-59 46.1-59c20.4 0 38.4 13 44.9 32l79.2 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-63 0z"]]
}, faPaperPlaneTop = {
  prefix: "fad",
  iconName: "paper-plane-top",
  icon: [512, 512, ["paper-plane-alt", "send"], "e20a", ["M1.4 72.3c0 6.1 1.4 12.4 4.7 18.6l70 134.6c63.3 7.9 126.6 15.8 190 23.7c3.4 .4 6 3.3 6 6.7s-2.6 6.3-6 6.7l-190 23.7L6.1 421.1c-14.6 28.1 7.3 58.6 35.2 58.6c5.3 0 10.8-1.1 16.3-3.5L492.9 285.3c11.6-5.1 19.1-16.6 19.1-29.3s-7.5-24.2-19.1-29.3L57.6 35.8C29.5 23.5 1.4 45.6 1.4 72.3z", "M76.1 286.5l190-23.7c3.4-.4 6-3.3 6-6.7s-2.6-6.3-6-6.7l-190-23.7 8.2 15.7c4.8 9.3 4.8 20.3 0 29.5l-8.2 15.7z"]]
}, faPaperPlaneAlt = faPaperPlaneTop, faSend = faPaperPlaneTop, faMessageArrowUp = {
  prefix: "fad",
  iconName: "message-arrow-up",
  icon: [512, 512, ["comment-alt-arrow-up"], "e1dc", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM160 192c0 6.1 2.3 12.3 7 17c9.4 9.4 24.6 9.4 33.9 0l31-31L232 296c0 13.3 10.7 24 24 24s24-10.7 24-24l0-118.1 31 31c9.4 9.4 24.6 9.4 33.9 0c4.7-4.7 7-10.8 7-17s-2.3-12.3-7-17l-72-72c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7l-72 72c-4.7 4.7-7 10.8-7 17z", "M256 320c13.3 0 24-10.7 24-24l0-118.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l31-31L232 296c0 13.3 10.7 24 24 24z"]]
}, faCommentAltArrowUp = faMessageArrowUp, faLightbulbExclamation = {
  prefix: "fad",
  iconName: "lightbulb-exclamation",
  icon: [384, 512, [], "f671", ["M16 176c0 37.3 11.6 71.9 31.4 100.3c5 7.2 10.2 14.3 15.4 21.4c19.8 27.1 39.7 54.4 49.2 86.2l160 0c9.6-31.9 29.5-59.1 49.2-86.2c5.2-7.1 10.4-14.2 15.4-21.4c19.8-28.5 31.4-63 31.4-100.3C368 78.8 289.2 0 192 0S16 78.8 16 176zM224 288a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM168 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112z", "M192 512c44.2 0 80-35.8 80-80V384H112v48c0 44.2 35.8 80 80 80z"]]
}, faLayerMinus = {
  prefix: "fad",
  iconName: "layer-minus",
  icon: [576, 512, ["layer-group-minus"], "f5fe", ["M32 256c0 9.4 5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-218.6-101C304 129.7 296 128 288 128s-16 1.7-23.5 5.2L45.9 234.2C37.4 238.1 32 246.6 32 256zm0 128c0 9.4 5.4 17.9 13.9 21.8l218.6 101C272 510.2 280 512 288 512s16-1.7 23.5-5.2l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-53.2-24.6-152 70.2c-23.4 10.8-50.4 10.8-73.8 0l-152-70.2L45.9 362.2C37.4 366.1 32 374.6 32 384z", "M384 80c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24z"]]
}, faLayerGroupMinus = faLayerMinus, faChartPieSimpleCircleCurrency = {
  prefix: "fad",
  iconName: "chart-pie-simple-circle-currency",
  icon: [640, 512, [], "e604", ["M0 272C0 404.6 107.5 512 240 512c43.8 0 84.8-11.7 120.1-32.2C335 449.4 320 410.5 320 368c0-28.8 6.9-56 19.2-80L224 288l0-221.3c0-18.5-15.7-33.3-33.8-29.5C81.5 60.1 0 156.5 0 272zM272 16.6L272 240l103.2 0c31.5-29.8 74-48 120.8-48c4.6 0 9.3 .2 13.8 .5C494.5 83.7 401 0 288 0c-9 0-16 7.6-16 16.6z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm25.4-169.4a35.9 35.9 0 1 0 -50.7 50.7 35.9 35.9 0 1 0 50.7-50.7zM460.7 426l-17.3 17.3c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6L438 403.3c-13.2-21.6-13.2-49.1 0-70.7l-17.3-17.3c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L460.7 310c21.6-13.2 49.1-13.2 70.7 0l17.3-17.3c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6L554 332.7c13.2 21.6 13.2 49.1 0 70.7l17.3 17.3c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0L531.3 426c-21.6 13.2-49.1 13.2-70.7 0z"]]
}, faCircleE = {
  prefix: "fad",
  iconName: "circle-e",
  icon: [512, 512, [], "e109", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM160 152c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 56 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 56 120 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24l0-104 0-104z", "M160 152c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 56 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 56 120 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24l0-104 0-104z"]]
}, faBuildingWheat = {
  prefix: "fad",
  iconName: "building-wheat",
  icon: [640, 512, [], "e4db", ["M0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 416c0 26.5-21.5 48-48 48l-96 0 0-80c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 80-96 0c-26.5 0-48-21.5-48-48L0 48zm64 64l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L80 96c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M640 208l0-16-16 0c-44.2 0-80 35.8-80 80l0 16 16 0c44.2 0 80-35.8 80-80zm0 96l-16 0c-44.2 0-80 35.8-80 80l0 16 16 0c44.2 0 80-35.8 80-80l0-16zm0 112l-16 0c-44.2 0-80 35.8-80 80l0 16 16 0c44.2 0 80-35.8 80-80l0-16zM512 512l0-16c0-44.2-35.8-80-80-80l-16 0 0 16c0 44.2 35.8 80 80 80l16 0zm0-128c0-44.2-35.8-80-80-80l-16 0 0 16c0 44.2 35.8 80 80 80l16 0 0-16zm0-96l0-16c0-44.2-35.8-80-80-80l-16 0 0 16c0 44.2 35.8 80 80 80l16 0zM552 56c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 104c0 13.3 10.7 24 24 24s24-10.7 24-24l0-104zm48 16c-13.3 0-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32c0-13.3-10.7-24-24-24zM480 96c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32z"]]
}, faGaugeMax = {
  prefix: "fad",
  iconName: "gauge-max",
  icon: [512, 512, ["tachometer-alt-fastest"], "f626", ["M512 256A256 256 0 1 1 0 256a256 256 0 1 1 512 0zM64 256a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm48-112a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm80 208c0 35.3 28.7 64 64 64c17.7 0 33.7-7.2 45.3-18.7c5.8-5.8 10.5-12.7 13.7-20.3c1.6-3.8 2.9-7.8 3.7-12c.4-2.1 .8-4.2 1-6.4c.1-1.1 .2-2.2 .2-3.2c.1-1.1 .1-2.2 .1-3.3c0-.9 0-1.8-.1-2.7s-.1-1.8-.2-2.7c-.2-1.8-.4-3.6-.7-5.4c39.2-24.3 78.4-48.5 117.5-72.8c3.7-2.3 6.5-5.4 8.4-8.9c1-1.8 1.7-3.6 2.2-5.6c.2-1 .4-2 .6-2.9c.1-.5 .1-1 .1-1.5c0-.3 0-.5 0-1.5l-.1-1.7c0 0-.1-.8-.2-1.6c-.1-1.1-.4-2.1-.7-3.2c-.6-2.1-1.5-4.2-2.7-6.2c-7-11.3-21.8-14.8-33-7.8c-39.2 24.3-78.4 48.5-117.5 72.8C283.2 292.6 270.1 288 256 288c-35.3 0-64 28.7-64 64zM224 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm112 48a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M411.4 227.6c11.3-7 26.1-3.5 33 7.8s3.5 26.1-7.8 33L319.1 341.2c.6 3.5 .9 7.1 .9 10.8c0 35.3-28.7 64-64 64s-64-28.7-64-64s28.7-64 64-64c14.1 0 27.2 4.6 37.8 12.4l117.5-72.8z"]]
}, faTachometerAltFastest = faGaugeMax, faPersonBreastfeeding = {
  prefix: "fad",
  iconName: "person-breastfeeding",
  icon: [448, 512, [], "e53a", ["M128 320l0 48c0 .8 0 1.6 .1 2.4l101.4 50.7c.6 .3 1.2 .6 1.7 .9s1.1 .6 1.7 1c1.1 .7 2.1 1.4 3.2 2.1c2 1.5 3.9 3.1 5.7 4.8c3.5 3.4 6.4 7.4 8.7 11.6c4.5 8.5 6.4 18.3 5.3 28c8.8 2.4 17.8 4.2 27 5.6l32.8 4.7c3.8 .6 7.6 .4 11.2-.4c.5-.1 .5-.1 .5-.1c-7.5-1.4-14.8-4.6-21.2-9.7c-17.6-14.1-22.7-38.1-13.5-57.7l-.8-.1c-38.9-5.6-74.3-25.1-99.7-54.8l0-36.8c0-17.7-14.3-32-32-32s-32 14.3-32 32zm104 12a44 44 0 1 0 88 0 44 44 0 1 0 -88 0z", "M224 0a80 80 0 1 1 0 160A80 80 0 1 1 224 0zM436.8 382.8L373.5 462c-16.6 20.7-46.8 24.1-67.5 7.5c-17.6-14.1-22.7-38.1-13.5-57.7l-.8-.1c-38.9-5.6-74.3-25.1-99.7-54.8l0-36.8c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 48c0 .8 0 1.6 .1 2.4l101.4 50.7c23.7 11.9 33.3 40.7 21.5 64.4s-40.7 33.3-64.4 21.5L27.2 427.3c-1.1-.5-2.2-1.1-3.3-1.7c-4.9-2.8-9.2-6.4-12.6-10.6c-4.6-5.4-7.8-11.7-9.6-18.4c-3.3-12-1.9-25.2 4.8-36.6c.6-1.1 1.3-2.2 2-3.2L75.6 256.1c26.7-40.1 71.7-64.1 119.8-64.1l75.2 0c46.5 0 90.1 22.5 117.2 60.3l50.7 70.9c2.2 3 4 6.1 5.5 9.4c2.9 6.7 4.3 13.8 4 20.8c-.3 10.6-4.2 21-11.2 29.4zM320 332a44 44 0 1 0 -88 0 44 44 0 1 0 88 0z"]]
}, faApostrophe = {
  prefix: "fad",
  iconName: "apostrophe",
  icon: [192, 512, [], "27", ["M72 352c66.3 0 120-53.7 120-120l0-72 0-32 0-32c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96l0 64c0 35.3 28.7 64 64 64l64 0 0 8c0 30.9-25.1 56-56 56l-8 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l8 0z", ""]]
}, faFilePng = {
  prefix: "fad",
  iconName: "file-png",
  icon: [512, 512, [], "e666", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-208 0c-35.3 0-64 28.7-64 64l0 144-48 0c-35.3 0-64-28.7-64-64L0 64z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM318.3 360.8c-3.3-6.6-10.8-10.1-18-8.4s-12.3 8.2-12.3 15.6l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-60.2 33.7 67.4c3.3 6.6 10.8 10.1 18 8.4s12.3-8.2 12.3-15.6l0-128c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 60.2-33.7-67.4zM176 352c-8.8 0-16 7.2-16 16l0 80 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 16 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-32 0zm32 80l-16 0 0-48 16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24zm208-40l0 80c0 22.1 17.9 40 40 40l16 0c22.1 0 40-17.9 40-40l0-24c0-8.8-7.2-16-16-16l-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l0 8c0 4.4-3.6 8-8 8l-16 0c-4.4 0-8-3.6-8-8l0-80c0-4.4 3.6-8 8-8l16 0c4.4 0 8 3.6 8 8l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8c0-22.1-17.9-40-40-40l-16 0c-22.1 0-40 17.9-40 40z"]]
}, faFireHydrant = {
  prefix: "fad",
  iconName: "fire-hydrant",
  icon: [384, 512, [], "e17f", ["M16 304l0 64c0 17.7 14.3 32 32 32l16 0 0-128-16 0c-17.7 0-32 14.3-32 32zM32 152c0 13.3 10.7 24 24 24l8 0 256 0 8 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-12 0c-11.6-45-47-80.4-92-92l0-4c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 4c-45 11.6-80.4 47-92 92l-12 0c-13.3 0-24 10.7-24 24zM320 272l0 128 16 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-16 0z", "M64 176l256 0 0 288 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0L64 512l-8 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l8 0 0-288zM192 400a64 64 0 1 0 0-128 64 64 0 1 0 0 128z"]]
}, faRightToBracket = {
  prefix: "fad",
  iconName: "right-to-bracket",
  icon: [512, 512, ["sign-in-alt"], "f2f6", ["M320 64c0 17.7 14.3 32 32 32l64 0c17.7 0 32 14.3 32 32l0 256c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c53 0 96-43 96-96l0-256c0-53-43-96-96-96l-64 0c-17.7 0-32 14.3-32 32z", "M340.7 228.7L217.9 105.9c-6.4-6.4-15-9.9-24-9.9c-18.7 0-33.9 15.2-33.9 33.9l0 62.1L32 192c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l128 0 0 62.1c0 18.7 15.2 33.9 33.9 33.9c9 0 17.6-3.6 24-9.9L340.7 283.3c7.2-7.2 11.3-17.1 11.3-27.3s-4.1-20.1-11.3-27.3z"]]
}, faSignInAlt = faRightToBracket, faVideoPlus = {
  prefix: "fad",
  iconName: "video-plus",
  icon: [576, 512, [], "f4e1", ["M0 128L0 384c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-68.2 0-119.6 0-68.2c0-35.3-28.7-64-64-64L64 64C28.7 64 0 92.7 0 128zM96 256c0-13.3 10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24s24 10.7 24 24l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24z", "M559.1 99.8c10.4 5.6 16.9 16.4 16.9 28.2l0 256c0 11.8-6.5 22.6-16.9 28.2s-23 5-32.9-1.6L384 315.8l0-119.6 142.2-94.8c9.8-6.5 22.4-7.2 32.9-1.6zM216 184l0 48 48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0 0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48-48 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l48 0 0-48c0-13.3 10.7-24 24-24s24 10.7 24 24z"]]
}, faSquareRight = {
  prefix: "fad",
  iconName: "square-right",
  icon: [448, 512, [10145, "arrow-alt-square-right"], "f352", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM96 240c0-17.7 14.3-32 32-32l96 0 0-57.7c0-12.3 10-22.3 22.3-22.3c6.2 0 12.1 2.6 16.3 7.1l99.9 107.1c3.5 3.8 5.5 8.7 5.5 13.8s-2 10.1-5.5 13.8L262.6 376.9c-4.2 4.5-10.1 7.1-16.3 7.1C234 384 224 374 224 361.7l0-57.7-96 0c-17.7 0-32-14.3-32-32l0-32z", "M362.5 242.2L262.6 135.1c-4.2-4.5-10.1-7.1-16.3-7.1C234 128 224 138 224 150.3l0 57.7-96 0c-17.7 0-32 14.3-32 32l0 32c0 17.7 14.3 32 32 32l96 0 0 57.7c0 12.3 10 22.3 22.3 22.3c6.2 0 12.1-2.6 16.3-7.1l99.9-107.1c3.5-3.8 5.5-8.7 5.5-13.8s-2-10.1-5.5-13.8z"]]
}, faArrowAltSquareRight = faSquareRight, faCommentSmile = {
  prefix: "fad",
  iconName: "comment-smile",
  icon: [512, 512, [], "f4b4", ["M0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3C1.6 455.8 0 459.9 0 464c0 2.1 .4 4.1 1.2 6.1c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240zm148.7 64c-8.8-9.9-8-25 1.9-33.9s25-8 33.9 1.9c17.6 19.7 43.1 32 71.6 32s53.9-12.3 71.6-32c8.8-9.9 24-10.7 33.9-1.9c5.3 4.7 8 11.3 8 17.9c0 5.7-2 11.4-6.1 16C337 333.4 298.6 352 256 352s-81-18.6-107.3-48zM224 176a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm128 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M224 176a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zm128 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0zM184.4 272c-8.8-9.9-24-10.7-33.9-1.9s-10.7 24-1.9 33.9c26.3 29.4 64.7 48 107.3 48s81-18.6 107.3-48c8.8-9.9 8-25-1.9-33.9s-25-8-33.9 1.9c-17.6 19.7-43.1 32-71.6 32s-53.9-12.3-71.6-32z"]]
}, faVenus = {
  prefix: "fad",
  iconName: "venus",
  icon: [384, 512, [9792], "f221", ["M112 176a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M80 176a112 112 0 1 1 224 0A112 112 0 1 1 80 176zM224 349.1c81.9-15 144-86.8 144-173.1C368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144 173.1l0 34.9-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-34.9z"]]
}, faPassport = {
  prefix: "fad",
  iconName: "passport",
  icon: [448, 512, [], "f5ab", ["M96 192a128 128 0 1 0 256 0A128 128 0 1 0 96 192zm33.3-16c5.3-31.4 25.8-57.6 53.7-70.8c-6.8 17.1-12.9 40.4-14.6 70.8l-39.1 0zm0 32l39.1 0c1.6 30.4 7.7 53.8 14.6 70.8c-27.9-13.2-48.4-39.4-53.7-70.8zm71.1-32c1.8-29.2 8.1-49.9 14.2-63.5c3.4-7.6 6.7-13 9.1-16.5l.6 0c2.4 3.5 5.7 8.9 9.1 16.5c6 13.6 12.4 34.3 14.2 63.5l-47.1 0zm0 32l47.1 0c-1.8 29.2-8.1 49.9-14.2 63.5c-3.4 7.6-6.7 13-9.1 16.5l-.6 0c-2.4-3.5-5.7-8.9-9.1-16.5c-6-13.6-12.4-34.3-14.2-63.5zM265 105.2c27.9 13.2 48.4 39.4 53.7 70.8l-39.1 0c-1.6-30.4-7.7-53.8-14.6-70.8zm0 173.6c6.8-17.1 12.9-40.4 14.6-70.8l39.1 0c-5.3 31.4-25.8 57.6-53.7 70.8z", "M0 64C0 28.7 28.7 0 64 0L384 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM183 278.8c-27.9-13.2-48.4-39.4-53.7-70.8l39.1 0c1.6 30.4 7.7 53.8 14.6 70.8zm41.3 9.2l-.3 0-.3 0c-2.4-3.5-5.7-8.9-9.1-16.5c-6-13.6-12.4-34.3-14.2-63.5l47.1 0c-1.8 29.2-8.1 49.9-14.2 63.5c-3.4 7.6-6.7 13-9.1 16.5zm40.7-9.2c6.8-17.1 12.9-40.4 14.6-70.8l39.1 0c-5.3 31.4-25.8 57.6-53.7 70.8zM279.6 176c-1.6-30.4-7.7-53.8-14.6-70.8c27.9 13.2 48.4 39.4 53.7 70.8l-39.1 0zM223.7 96l.3 0 .3 0c2.4 3.5 5.7 8.9 9.1 16.5c6 13.6 12.4 34.3 14.2 63.5l-47.1 0c1.8-29.2 8.1-49.9 14.2-63.5c3.4-7.6 6.7-13 9.1-16.5zM183 105.2c-6.8 17.1-12.9 40.4-14.6 70.8l-39.1 0c5.3-31.4 25.8-57.6 53.7-70.8zM352 192A128 128 0 1 0 96 192a128 128 0 1 0 256 0zM112 384c-8.8 0-16 7.2-16 16s7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0z"]]
}, faThumbtackSlash = {
  prefix: "fad",
  iconName: "thumbtack-slash",
  icon: [640, 512, ["thumb-tack-slash"], "e68f", ["M128 320c0 6.6 2.1 13.2 6 18.7c6 8.3 15.7 13.3 26 13.3l164.9 0L177.1 235.6c-20.9 18.9-37.2 43.3-46.5 71.3l-1 3c-1.1 3.3-1.6 6.7-1.6 10.1zM160 32c0 17.7 14.3 32 32 32l29.5 0-6.1 79.5L481.4 352c9.8-.4 18.9-5.3 24.6-13.3c6-8.3 7.7-19.1 4.4-28.8l-1-3c-13.8-41.5-42.8-74.8-79.5-94.7L418.5 64 448 64c17.7 0 32-14.3 32-32s-14.3-32-32-32L192 0c-17.7 0-32 14.3-32 32zM288 384l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96-64 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faThumbTackSlash = faThumbtackSlash, faInboxIn = {
  prefix: "fad",
  iconName: "inbox-in",
  icon: [512, 512, [128229, "inbox-arrow-down"], "f310", ["M0 368l0 96c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-76.2 0c-12.1 0-23.2 6.8-28.6 17.7l-14.3 28.6c-5.4 10.8-16.5 17.7-28.6 17.7l-120.4 0c-12.1 0-23.2-6.8-28.6-17.7l-14.3-28.6c-5.4-10.8-16.5-17.7-28.6-17.7L48 320c-26.5 0-48 21.5-48 48z", "M256 0c17.7 0 32 14.3 32 32l0 178.7 41.4-41.4c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3l-96 96c-12.5 12.5-32.8 12.5-45.3 0l-96-96c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0L224 210.7 224 32c0-17.7 14.3-32 32-32z"]]
}, faInboxArrowDown = faInboxIn, faHeartPulse = {
  prefix: "fad",
  iconName: "heart-pulse",
  icon: [512, 512, ["heartbeat"], "f21e", ["M0 185.1l0 5.8c0 17.3 3 34.3 8.7 50.2c2.3-.7 4.8-1.1 7.3-1.1l106.7 0c3.2 0 6.1-1.9 7.4-4.9l31.8-76.3c3.7-8.8 12.3-14.6 21.8-14.8s18.3 5.4 22.2 14.1l51.3 113.9 41.4-82.8c4.1-8.1 12.4-13.3 21.5-13.3s17.4 5.1 21.5 13.3l23.2 46.3c1.4 2.7 4.1 4.4 7.2 4.4l132 0c5.4-15.6 8.3-32.2 8.3-49.1l0-5.8c0-69.9-50.5-129.5-119.4-141c-7.8-1.3-15.7-1.9-23.5-1.9C331.5 42.2 295 57 268 84L256 96 244 84c-27-27-63.5-41.9-101.1-41.9c-7.8 0-15.7 .6-23.5 1.9C50.5 55.6 0 115.2 0 185.1zM35.7 288c3.7 4.3 7.7 8.5 11.9 12.4L228.3 469.1c7.5 7 17.4 10.9 27.7 10.9s20.2-3.9 27.7-10.9L464.4 300.4c4.2-3.9 8.2-8.1 11.9-12.4l-104.5 0c-21.2 0-40.6-12-50.1-31l-1.7-3.4-42.5 85.1c-4.1 8.3-12.7 13.5-22 13.3s-17.6-5.7-21.4-14.1L184.8 228.4l-10.5 25.2c-8.7 20.9-29.1 34.5-51.7 34.5l-87 0z", "M35.7 288l87 0c22.6 0 43-13.6 51.7-34.5l10.5-25.2 49.3 109.5c3.8 8.5 12.1 14 21.4 14.1s17.8-5 22-13.3L320 253.7l1.7 3.4c9.5 19 28.9 31 50.1 31l104.5 0c12.1-14.2 21.4-30.5 27.4-48l-132 0c-3 0-5.8-1.7-7.2-4.4l-23.2-46.3c-4.1-8.1-12.4-13.3-21.5-13.3s-17.4 5.1-21.5 13.3l-41.4 82.8L205.9 158.2c-3.9-8.7-12.7-14.3-22.2-14.1s-18.1 5.9-21.8 14.8l-31.8 76.3c-1.2 3-4.2 4.9-7.4 4.9L16 240c-2.6 0-5 .4-7.3 1.1c6.1 17 15.2 32.9 27 46.9z"]]
}, faHeartbeat = faHeartPulse, faCircle8 = {
  prefix: "fad",
  iconName: "circle-8",
  icon: [512, 512, [], "e0f5", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm160 48c0-25 11.5-47.4 29.5-62C181 230.1 176 215.7 176 200c0-39.8 32.2-72 72-72l16 0c39.8 0 72 32.2 72 72c0 15.7-5 30.1-13.5 42c18 14.7 29.5 37 29.5 62c0 44.2-35.8 80-80 80l-32 0c-44.2 0-80-35.8-80-80zm48 0c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-8 0-16 0-8 0c-17.7 0-32 14.3-32 32zm16-104c0 13.2 10.7 24 24 24l16 0c13.3 0 24-10.8 24-24c0-13.3-10.7-24-24-24l-16 0c-13.3 0-24 10.7-24 24z", "M336 200c0-39.8-32.2-72-72-72l-16 0c-39.8 0-72 32.2-72 72c0 15.7 5 30.1 13.5 42c-18 14.7-29.5 37-29.5 62c0 44.2 35.8 80 80 80l32 0c44.2 0 80-35.8 80-80c0-25-11.5-47.4-29.5-62c8.5-11.8 13.5-26.3 13.5-42zm-72 72l8 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l8 0c0 0 0 0 0 0l16 0c0 0 0 0 0 0zm0-48L248 224c-13.2 0-24-10.8-24-24s10.7-24 24-24l16 0c13.3 0 24 10.7 24 24s-10.7 24-24 24z"]]
}, faCloudsMoon = {
  prefix: "fad",
  iconName: "clouds-moon",
  icon: [640, 512, [], "f745", ["M352 160C352 71.7 423.4 0 511.5 0c4.6 0 9.1 .2 13.5 .6c7 .6 12.8 5.7 14.3 12.5s-1.6 13.9-7.7 17.3c-35.4 20.1-59.3 58.2-59.3 101.9c0 64.6 52.2 116.9 116.5 116.9c6.8 0 13.5-.6 20-1.7c6.9-1.2 13.8 2.2 17 8.5c1.2 2.3 1.8 4.8 1.8 7.3c0 4.2-1.7 8.4-4.8 11.5C594 302.8 554.8 320 511.5 320c-3.8 0-7.5-.1-11.2-.4c-11.3-9.9-24.2-17.8-38.5-23.2c-9.9-53.2-52.6-94.8-106.4-103c-2.3-10.8-3.5-22-3.5-33.4z", "M208.1 224c12.9 0 25.3 2.2 36.8 6.2c19.6-19.9 45.8-33.5 75-37.2l0-.9c0-35.3-28.6-64-64-64c-7.4 0-14.6 1.3-21.2 3.6c-11.5-30.1-40.6-51.6-74.8-51.6c-38.9 0-71.3 27.8-78.5 64.6c-3.1-.4-6.3-.6-9.5-.6c-39.8 0-72 32.2-72 72s32.2 72 72 72c16.1 0 30.9-5.3 42.9-14.1c20.1-30.1 54.3-49.9 93.2-49.9zM64 431.9c0 44.2 35.8 80 80 80l271.9 0c53 0 96-43 96-96c0-47.6-34.6-87-80-94.6l0-1.3c0-53-43-96-96-96c-34.9 0-65.4 18.6-82.2 46.4C240.8 261.3 225 256 208 256c-44.2 0-80 35.8-80 80c0 5.9 .6 11.7 1.9 17.2C92.4 359.9 64 392.6 64 431.9z"]]
}, faClockTenThirty = {
  prefix: "fad",
  iconName: "clock-ten-thirty",
  icon: [512, 512, [], "e355", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm140-77.3c4.6-6.9 12.2-10.7 20-10.7c4.6 0 9.2 1.3 13.3 4c32 21.3 64 42.7 96 64C276 240.5 280 248 280 256c0 45.3 0 90.7 0 136c0 13.3-10.7 24-24 24c-6.6 0-12.6-2.7-17-7c-2.2-2.2-3.9-4.8-5.1-7.6c-.6-1.4-1.1-2.9-1.4-4.5c-.2-.8-.3-1.6-.4-2.4s-.1-1.6-.1-2.5c0-41 0-82.1 0-123.2c-28.4-19-56.9-37.9-85.3-56.9c-11-7.4-14-22.3-6.7-33.3z", "M256 416c13.3 0 24-10.7 24-24l0-136c0-8-4-15.5-10.7-20l-96-64c-11-7.4-25.9-4.4-33.3 6.7s-4.4 25.9 6.7 33.3L232 268.8 232 392c0 13.3 10.7 24 24 24z"]]
}, faPeopleCarryBox = {
  prefix: "fad",
  iconName: "people-carry-box",
  icon: [640, 512, ["people-carry"], "f4ce", ["M224 160l0 76.2 46.3 23.2c15.8 7.9 22.2 27.1 14.3 42.9c-.7 1.4-1.5 2.7-2.3 3.9s-1.8 2.4-2.8 3.5c-2 2.2-4.2 4-6.7 5.5c-4.9 3-10.5 4.7-16.2 4.8l126.7 0c-11.5-.2-22.5-6.7-28-17.7c-7.9-15.8-1.5-35 14.3-42.9c15.4-7.7 30.9-15.4 46.3-23.2l0-76.2c0-17.7-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32z", "M176 48A48 48 0 1 0 80 48a48 48 0 1 0 96 0zM144 306.7l0-65.1 19 28.5c4.6 7 11 12.6 18.5 16.3l60.2 30.1c15.8 7.9 35 1.5 42.9-14.3s1.5-35-14.3-42.9l-56.4-28.2L166.5 160c-13.3-20-35.8-32-59.9-32C74.2 128 48 154.2 48 186.6l0 88.1c0 17 6.7 33.3 18.7 45.3l79.4 79.4 14.3 85.9c2.9 17.4 19.4 29.2 36.8 26.3s29.2-19.4 26.3-36.8l-15.2-90.9c-1.6-9.9-6.3-19-13.4-26.1l-51-51zM2.3 468.1c-6.6 16.4 1.4 35 17.8 41.6s35-1.4 41.6-17.8l37.6-94L50.1 348.6 2.3 468.1zM464 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm32 258.7l-51 51c-7.1 7.1-11.8 16.2-13.4 26.1l-15.2 90.9c-2.9 17.4 8.9 33.9 26.3 36.8s33.9-8.9 36.8-26.3l14.3-85.9L573.3 320c12-12 18.7-28.3 18.7-45.3l0-88.1c0-32.4-26.2-58.6-58.6-58.6c-24.1 0-46.5 12-59.9 32l-47.4 71.1-56.4 28.2c-15.8 7.9-22.2 27.1-14.3 42.9s27.1 22.2 42.9 14.3l60.2-30.1c7.5-3.7 13.8-9.4 18.5-16.3l19-28.5 0 65.1zM637.7 468.1L589.9 348.6l-49.2 49.2 37.6 94c6.6 16.4 25.2 24.4 41.6 17.8s24.4-25.2 17.8-41.6z"]]
}, faPeopleCarry = faPeopleCarryBox, faFolderUser = {
  prefix: "fad",
  iconName: "folder-user",
  icon: [512, 512, [], "e18e", ["M0 96L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L288 96c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32L64 32C28.7 32 0 60.7 0 96zM144 405.3c0-29.5 23.9-53.3 53.3-53.3l117.3 0c29.5 0 53.3 23.9 53.3 53.3c0 5.9-4.8 10.7-10.7 10.7l-202.7 0c-5.9 0-10.7-4.8-10.7-10.7zM320 256a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M256 320a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-58.7 32c-29.5 0-53.3 23.9-53.3 53.3c0 5.9 4.8 10.7 10.7 10.7l202.7 0c5.9 0 10.7-4.8 10.7-10.7c0-29.5-23.9-53.3-53.3-53.3l-117.3 0z"]]
}, faTrashCanXmark = {
  prefix: "fad",
  iconName: "trash-can-xmark",
  icon: [448, 512, [], "e2ae", ["M32 96l384 0 0 352c0 35.3-28.7 64-64 64L96 512c-35.3 0-64-28.7-64-64L32 96zM143 207c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9c4.7 4.7 10.8 7 17 7s12.3-2.3 17-7l47-47 47 47c4.7 4.7 10.8 7 17 7s12.3-2.3 17-7c9.4-9.4 9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47c-9.4-9.4-24.6-9.4-33.9 0z", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0L284.2 0c12.1 0 23.2 6.8 28.6 17.7L320 32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 7.2-14.3zM143 207c9.4-9.4 24.6-9.4 33.9 0l47 47 47-47c9.4-9.4 24.6-9.4 33.9 0s9.4 24.6 0 33.9l-47 47 47 47c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-47-47-47 47c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l47-47-47-47c-9.4-9.4-9.4-24.6 0-33.9z"]]
}, faTemperatureHigh = {
  prefix: "fad",
  iconName: "temperature-high",
  icon: [512, 512, [], "f769", ["M0 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-33.2-11.2-63.8-30.1-88.1c-.9-1.2-1.5-2.2-1.7-2.8c-.1-.3-.2-.5-.2-.6L256 112C256 50.2 205.9 0 144 0S32 50.2 32 112l0 164.4c0 .1-.1 .3-.2 .6c-.2 .6-.8 1.6-1.7 2.8C11.2 304.2 0 334.8 0 368zm64 0c0-18.5 6.2-35.4 16.7-48.9C88.9 308.4 96 293.8 96 276.5L96 112c0-26.5 21.5-48 48-48s48 21.5 48 48l0 164.5c0 17.3 7.1 31.9 15.3 42.5C217.8 332.6 224 349.5 224 368c0 44.2-35.8 80-80 80s-80-35.8-80-80z", "M416 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64zm0 128A96 96 0 1 0 416 0a96 96 0 1 0 0 192zM144 96c-8.8 0-16 7.2-16 16l0 210.7c-18.6 6.6-32 24.4-32 45.3c0 26.5 21.5 48 48 48s48-21.5 48-48c0-20.9-13.4-38.7-32-45.3L160 112c0-8.8-7.2-16-16-16z"]]
}, faMicrochip = {
  prefix: "fad",
  iconName: "microchip",
  icon: [512, 512, [], "f2db", ["M0 152c0 13.3 10.7 24 24 24l40 0 0-48-40 0c-13.3 0-24 10.7-24 24zM0 256c0 13.3 10.7 24 24 24l40 0 0-48-40 0c-13.3 0-24 10.7-24 24zM0 360c0 13.3 10.7 24 24 24l40 0 0-48-40 0c-13.3 0-24 10.7-24 24zM128 24l0 40 48 0 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24zm0 424l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40-48 0zm32-288l0 192 192 0 0-192-192 0zM232 24l0 40 48 0 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24zm0 424l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40-48 0zM336 24l0 40 48 0 0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24zm0 424l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40-48 0zM448 128l0 48 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0zm0 104l0 48 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0zm0 104l0 48 40 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-40 0z", "M128 64c-35.3 0-64 28.7-64 64l0 256c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L128 64zm32 64l192 0c17.7 0 32 14.3 32 32l0 192c0 17.7-14.3 32-32 32l-192 0c-17.7 0-32-14.3-32-32l0-192c0-17.7 14.3-32 32-32z"]]
}, faLeftLongToLine = {
  prefix: "fad",
  iconName: "left-long-to-line",
  icon: [640, 512, [], "e41e", ["M0 96L0 416c0 17.7 14.3 32 32 32s32-14.3 32-32L64 96c0-17.7-14.3-32-32-32S0 78.3 0 96z", "M305.5 414c-8.8 3.8-19 2-26-4.6l-144-136c-4.8-4.5-7.5-10.8-7.5-17.4s2.7-12.9 7.5-17.4l144-136c7-6.6 17.2-8.4 26-4.6s14.5 12.5 14.5 22l0 72 288 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-288 0 0 72c0 9.6-5.7 18.2-14.5 22z"]]
}, faCrown = {
  prefix: "fad",
  iconName: "crown",
  icon: [576, 512, [128081], "f521", ["M0 136a40 40 0 1 0 80 0A40 40 0 1 0 0 136zM248 72a40 40 0 1 0 80-.1A40 40 0 1 0 248 72zm248 64a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M504 160l-89.1 71.3c-15.9 12.7-39.5 7.5-48.6-10.7L309 106c-6.1 3.8-13.3 6-21 6s-14.9-2.2-21-6L209.7 220.6c-9.1 18.2-32.7 23.4-48.6 10.7L72 160c-7.2 9.5-18.5 15.8-31.3 16L86.4 427.4c5.5 30.4 32 52.6 63 52.6l277.2 0c30.9 0 57.4-22.1 63-52.6L535.3 176c-12.8-.2-24.1-6.5-31.3-16z"]]
}, faWeightHanging = {
  prefix: "fad",
  iconName: "weight-hanging",
  icon: [512, 512, [], "f5cd", ["M160 96c0 11.2 1.9 22 5.5 32l81 0c-12.7-4.4-22-17-22.4-31c0-.3 0-.7 0-1c0-17.7 14.3-32 32-32s32 14.3 32 32c0 .3 0 .6 0 .8c-.4 14-9.7 26.8-22.4 31.2l81 0c3.5-10 5.5-20.8 5.5-32c0-53-43-96-96-96s-96 43-96 96z", "M120 128c-22 0-41.2 15-46.6 36.4l-72 288c-3.6 14.3-.4 29.5 8.7 41.2S33.2 512 48 512l416 0c14.8 0 28.7-6.8 37.8-18.5s12.3-26.8 8.7-41.2l-72-288C433.2 143 414 128 392 128l-272 0z"]]
}, faXmarksLines = {
  prefix: "fad",
  iconName: "xmarks-lines",
  icon: [640, 512, [], "e59a", ["M0 64C0 81.7 14.3 96 32 96l576 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 32C14.3 32 0 46.3 0 64zM0 448c0 17.7 14.3 32 32 32l576 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 416c-17.7 0-32 14.3-32 32z", "M177 209c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47L49 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47L15 303c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47zM273 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47zM463 175c-9.4 9.4-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47c-9.4-9.4-24.6-9.4-33.9 0z"]]
}, faFilePrescription = {
  prefix: "fad",
  iconName: "file-prescription",
  icon: [384, 512, [], "f572", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM84 216l0 80 0 64c0 11 9 20 20 20s20-9 20-20l0-44 20 0c.7 .9 1.5 1.8 2.3 2.6l64.8 60.8-32.6 29.9c-8.1 7.5-8.7 20.1-1.2 28.3c3.9 4.3 9.3 6.5 14.7 6.5c4.8 0 9.7-1.7 13.5-5.3l34.9-32 33.9 31.8c8.1 7.6 20.7 7.1 28.3-.9s7.1-20.7-.9-28.3L270 379.7l31.6-28.9c8.1-7.5 8.7-20.1 1.2-28.3s-20.1-8.7-28.3-1.2l-33.8 31-43-40.3c22.4-8.7 38.3-30.5 38.3-55.9c0-33.1-26.9-60-60-60l-72 0c-11 0-20 9-20 20zm40 20l52 0c11 0 20 9 20 20s-9 20-20 20l-52 0 0-40z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM104 196c-11 0-20 9-20 20l0 80 0 64c0 11 9 20 20 20s20-9 20-20l0-44 20 0c.7 .9 1.5 1.8 2.3 2.6l64.8 60.8-32.6 29.9c-8.1 7.5-8.7 20.1-1.2 28.3s20.1 8.7 28.3 1.2l34.9-32 33.9 31.8c8.1 7.6 20.7 7.1 28.3-.9s7.1-20.7-.9-28.3L270 379.7l31.6-28.9c8.1-7.5 8.7-20.1 1.2-28.3s-20.1-8.7-28.3-1.2l-33.8 31-43-40.3c22.4-8.7 38.3-30.5 38.3-55.9c0-33.1-26.9-60-60-60l-72 0zm72 80l-52 0 0-40 52 0c11 0 20 9 20 20s-9 20-20 20z"]]
}, faTableCellsLock = {
  prefix: "fad",
  iconName: "table-cells-lock",
  icon: [640, 512, [], "e679", ["M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 65.1c-37.8 5.4-69.4 29.6-85.2 62.9L360 224l0 64 56 0 0 8.6c-19.1 11.1-32 31.7-32 55.4l-24 0 0 64 24 0 0 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 0l0 64 88 0 0-64L64 96zm0 128l0 64 88 0 0-64-88 0zm0 128l0 64 88 0 0-64-88 0zM208 96l0 64 88 0 0-64-88 0zm0 128l0 64 88 0 0-64-88 0zm0 128l0 64 88 0 0-64-88 0zM360 96l0 64 88 0 0-64-88 0z", "M496 272l0 48 64 0 0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]]
}, faCalendarRange = {
  prefix: "fad",
  iconName: "calendar-range",
  icon: [448, 512, [], "e0d6", ["M0 192l448 0 0 272c0 26.5-21.5 48-48 48L48 512c-26.5 0-48-21.5-48-48L0 192zm64 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 128c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L88 392c-13.3 0-24 10.7-24 24zM192 288c0 13.3 10.7 24 24 24l144 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-144 0c-13.3 0-24 10.7-24 24zM320 416a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M96 32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 128 0 0-32c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32 48 0c26.5 0 48 21.5 48 48l0 80L0 192l0-80C0 85.5 21.5 64 48 64l48 0 0-32zm32 256a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM352 448a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM192 288c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24zm40 104c13.3 0 24 10.7 24 24s-10.7 24-24 24L88 440c-13.3 0-24-10.7-24-24s10.7-24 24-24l144 0z"]]
}, faFlowerDaffodil = {
  prefix: "fad",
  iconName: "flower-daffodil",
  icon: [512, 512, [9880], "f800", ["M0 349.5C0 439.3 72.7 512 162.5 512l61.5 0 32 0 32 0 61.5 0C439.3 512 512 439.3 512 349.5c0-16.3-13.2-29.5-29.5-29.5L432 320c-59.5 0-112.1 29.6-144 74.8l0-113.4c-12.7-5.6-23.8-14.4-32-25.3c-.5 .7-1 1.4-1.6 2s-1.1 1.3-1.6 2c-1.1 1.3-2.3 2.6-3.5 3.8c-2.4 2.5-4.9 4.8-7.6 6.9c-5.4 4.3-11.3 7.9-17.7 10.6l0 113.4C192.1 349.6 139.5 320 80 320l-50.5 0C13.2 320 0 333.2 0 349.5z", "M320 288c-26.2 0-49.4-12.6-64-32c-14.6 19.4-37.8 32-64 32c-44.2 0-80-35.8-80-80c0-26.2 12.6-49.4 32-64c-19.4-14.6-32-37.8-32-64c0-44.2 35.8-80 80-80c26.2 0 49.4 12.6 64 32c14.6-19.4 37.8-32 64-32c44.2 0 80 35.8 80 80c0 26.2-12.6 49.4-32 64c19.4 14.6 32 37.8 32 64c0 44.2-35.8 80-80 80zm-64-96a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]]
}, faHandBackPointUp = {
  prefix: "fad",
  iconName: "hand-back-point-up",
  icon: [448, 512, [], "e1a2", ["M136 0C113.9 0 96 17.9 96 40l0 200 0 7 0 73c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-55.7c-2 1.4-3.9 3-5.8 4.5L39 284.8C24.4 297 16 315 16 334L16 372c0 38 16.9 74 46.1 98.3l5.4 4.5c28.8 24 65 37.1 102.4 37.1L288 512c70.7 0 128-57.3 128-128l0-64 0-32c0-26.5-21.5-48-48-48c-12.4 0-23.6 4.7-32.1 12.3C334 227.5 313.3 208 288 208c-12.4 0-23.6 4.7-32.1 12.3C254 195.5 233.3 176 208 176c-12.3 0-23.5 4.6-32 12.2L176 40c0-22.1-17.9-40-40-40z", ""]]
}, faWeightScale = {
  prefix: "fad",
  iconName: "weight-scale",
  icon: [512, 512, ["weight"], "f496", ["M432 176A176 176 0 1 1 80 176a176 176 0 1 1 352 0zM216 224c0 22.1 17.9 40 40 40s40-17.9 40-40c0-10.6-4.1-20.2-10.9-27.4l33.6-78.3c3.5-8.1-.3-17.5-8.4-21s-17.5 .3-21 8.4L255.7 184c-22 .1-39.7 18-39.7 40z", "M256 352c97.2 0 176-78.8 176-176c0-42.5-15.1-81.6-40.2-112L448 64c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 128C0 92.7 28.7 64 64 64l56.2 0C95.1 94.4 80 133.5 80 176c0 97.2 78.8 176 176 176zm40-128c0 22.1-17.9 40-40 40s-40-17.9-40-40c0-22 17.8-39.9 39.7-40l33.6-78.3c3.5-8.1 12.9-11.9 21-8.4s11.9 12.9 8.4 21l-33.6 78.3c6.7 7.2 10.9 16.8 10.9 27.4z"]]
}, faWeight = faWeightScale, faArrowUpToArc = {
  prefix: "fad",
  iconName: "arrow-up-to-arc",
  icon: [512, 512, [], "e617", ["M0 256c0 17.7 14.3 32 32 32s32-14.3 32-32C64 150 150 64 256 64s192 86 192 192c0 17.7 14.3 32 32 32s32-14.3 32-32C512 114.6 397.4 0 256 0S0 114.6 0 256z", "M390.6 326.6c12.5-12.5 12.5-32.8 0-45.3l-112-112c-12.5-12.5-32.8-12.5-45.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L224 269.3 224 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.7 57.4 57.4c12.5 12.5 32.8 12.5 45.3 0z"]]
}, faStarExclamation = {
  prefix: "fad",
  iconName: "star-exclamation",
  icon: [576, 512, [], "f2f3", ["M25.7 193.1c-3.8 11.5-.7 24.2 7.9 32.7L137.8 329 113.2 474.7c-2 12 3 24.2 12.9 31.3s23 8 33.8 2.3l128.3-68.5 128.3 68.5c4.7 2.5 9.9 3.8 15.1 3.8c6.6 0 13.1-2 18.7-6c9.9-7.1 14.9-19.3 12.9-31.3L438.5 329 542.7 225.9c6.2-6.1 9.5-14.3 9.5-22.7c0-3.3-.5-6.7-1.6-10c-3.8-11.5-13.7-19.9-25.7-21.7L381.2 150.3 316.9 18C311.6 7 300.4 0 288.1 0s-23.4 7-28.8 18L195 150.3 51.4 171.5c-12 1.8-22 10.2-25.7 21.7zM320 352a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM264 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112z", "M312 152c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM288 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faBooks = {
  prefix: "fad",
  iconName: "books",
  icon: [512, 512, [128218], "f5db", ["M0 32C0 14.3 14.3 0 32 0L96 0c17.7 0 32 14.3 32 32l0 64L0 96 0 32zm0 96l128 0 0 256L0 384 0 128zM0 416l128 0 0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64zM160 32c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 64L160 96l0-64zm0 96l128 0 0 256-128 0 0-256zm0 288l128 0 0 64c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-64zM289.4 117.8c40.9-11 81.8-21.9 122.8-32.9l8.2 30.9L297.6 148.8l-8.2-30.9zm74.2 278.3c40.9-11 81.8-21.9 122.8-32.9l8.2 30.9L371.8 427c-2.7-10.3-5.5-20.6-8.2-30.9z", "M288 112.6l1.4 5.2L412.2 85 395.8 23.7c-4.5-17-22-27.1-38.9-22.6L295.5 17.6c-2.7 .7-5.2 1.8-7.5 3.1L288 96 160 96l0 32 128 0 0-15.4zm132.4 3.2L297.6 148.8l66 247.4 122.8-32.9-66-247.4zM388.2 488.3c4.5 17 22 27.1 38.9 22.6l61.4-16.5c16.9-4.6 27-22.1 22.5-39.1l-16.3-61.1L371.8 427l16.3 61.3zM0 96l0 32 128 0 0-32L0 96zM128 384L0 384l0 32 128 0 0-32zm160 0l-128 0 0 32 128 0 0-32z"]]
}, faUserGroup = {
  prefix: "fad",
  iconName: "user-group",
  icon: [640, 512, [128101, "user-friends"], "f500", ["M352.7 223.1C373 243.4 401 256 432 256c61.9 0 112-50.1 112-112s-50.1-112-112-112c-24.8 0-47.7 8.1-66.3 21.7C377.4 75.9 384 101.2 384 128c0 35.6-11.6 68.5-31.3 95.1zm57.5 97.1C452.9 356.8 480 411.3 480 472l0 8c0 11.7-3.1 22.6-8.6 32l137.8 0c17 0 30.7-13.8 30.7-30.7C640 392.2 567.8 320 478.7 320l-61.4 0c-2.4 0-4.8 .1-7.1 .2z", "M224 256A128 128 0 1 0 224 0a128 128 0 1 0 0 256zm-45.7 48C79.8 304 0 383.8 0 482.3C0 498.7 13.3 512 29.7 512l388.6 0c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304l-91.4 0z"]]
}, faUserFriends = faUserGroup, faArrowUpAZ = {
  prefix: "fad",
  iconName: "arrow-up-a-z",
  icon: [576, 512, ["sort-alpha-up"], "f15e", ["M304 224c0 11.7 6.5 23 17.7 28.6c15.8 7.9 35 1.5 42.9-14.3l7.2-14.3 88.4 0 7.2 14.3c7.9 15.8 27.1 22.2 42.9 14.3C521.5 247 528 235.7 528 224c0-4.8-1.1-9.7-3.4-14.3l-16-32-64-128C439.2 38.8 428.1 32 416 32s-23.2 6.8-28.6 17.7l-64 128-16 32c-2.3 4.6-3.4 9.5-3.4 14.3zm16 96c0 17.7 14.3 32 32 32l50.7 0-73.4 73.4c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0 73.4-73.4c9.2-9.2 11.9-22.9 6.9-34.9s-16.6-19.8-29.6-19.8l-128 0c-17.7 0-32 14.3-32 32zm75.8-144L416 135.6 436.2 176l-40.4 0z", "M160 32c9 0 17.5 3.8 23.6 10.4l88 96c11.9 13 11.1 33.3-2 45.2s-33.3 11.1-45.2-2L192 146.3 192 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-301.7L95.6 181.6c-11.9 13-32.2 13.9-45.2 2s-13.9-32.2-2-45.2l88-96C142.5 35.8 151 32 160 32z"]]
}, faSortAlphaUp = faArrowUpAZ, faLayerPlus = {
  prefix: "fad",
  iconName: "layer-plus",
  icon: [576, 512, ["layer-group-plus"], "f5ff", ["M32 256c0 9.4 5.4 17.9 13.9 21.8l218.6 101c14.9 6.9 32.1 6.9 47 0l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-218.6-101C304 129.7 296 128 288 128s-16 1.7-23.5 5.2L45.9 234.2C37.4 238.1 32 246.6 32 256zm0 128c0 9.4 5.4 17.9 13.9 21.8l218.6 101C272 510.2 280 512 288 512s16-1.7 23.5-5.2l218.6-101c8.5-3.9 13.9-12.4 13.9-21.8s-5.4-17.9-13.9-21.8l-53.2-24.6-152 70.2c-23.4 10.8-50.4 10.8-73.8 0l-152-70.2L45.9 362.2C37.4 366.1 32 374.6 32 384z", "M488 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 32-32 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l32 0 0 32c0 13.3 10.7 24 24 24s24-10.7 24-24l0-32 32 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-32 0 0-32z"]]
}, faLayerGroupPlus = faLayerPlus, faPlayPause = {
  prefix: "fad",
  iconName: "play-pause",
  icon: [640, 512, [], "e22f", ["M384 96l0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32zm128 0l0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M116.5 71.4c-9.5-7.9-22.8-9.7-34.1-4.4S64 83.6 64 96l0 320c0 12.4 7.2 23.7 18.4 29s24.5 3.6 34.1-4.4l192-160c7.3-6.1 11.5-15.1 11.5-24.6s-4.2-18.5-11.5-24.6l-192-160z"]]
}, faBlockQuestion = {
  prefix: "fad",
  iconName: "block-question",
  icon: [448, 512, [], "e3dd", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm96 8a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 304a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm41.4-233.5l.4-1.2c7.9-22.3 29.1-37.3 52.8-37.3l58.3 0c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L248 272.4c-.2 13-10.9 23.6-24 23.6c-13.3 0-24-10.7-24-24l0-13.5c0-8.6 4.6-16.5 12.1-20.8l44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1l-58.3 0c-3.4 0-6.4 2.1-7.5 5.3l-.4 1.2c-4.4 12.5-18.2 19-30.6 14.6s-19-18.2-14.6-30.6zM256 360a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM400 104a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 304a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M48 104a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm304 0a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM72 384a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm280 24a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM137.8 173.3c7.9-22.3 29.1-37.3 52.8-37.3l58.3 0c34.9 0 63.1 28.3 63.1 63.1c0 22.6-12.1 43.5-31.7 54.8L248 272.4c-.2 13-10.9 23.6-24 23.6c-13.3 0-24-10.7-24-24l0-13.5c0-8.6 4.6-16.5 12.1-20.8l44.3-25.4c4.7-2.7 7.6-7.7 7.6-13.1c0-8.4-6.8-15.1-15.1-15.1l-58.3 0c-3.4 0-6.4 2.1-7.5 5.3l-.4 1.2c-4.4 12.5-18.2 19-30.6 14.6s-19-18.2-14.6-30.6l.4-1.2zM192 360a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]]
}, faSnooze = {
  prefix: "fad",
  iconName: "snooze",
  icon: [448, 512, [128164, "zzz"], "f880", ["M160 32c0-17.7 14.3-32 32-32l96 0c12.1 0 23.2 6.8 28.6 17.7s4.3 23.8-3 33.5L256 128l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-12.1 0-23.2-6.8-28.6-17.7s-4.3-23.8 3-33.5L224 64l-32 0c-17.7 0-32-14.3-32-32zM288 256c0-17.7 14.3-32 32-32l96 0c12.1 0 23.2 6.8 28.6 17.7c2.3 4.5 3.4 9.4 3.4 14.3c0 6.8-2.2 13.6-6.4 19.2L384 352l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-96 0c-12.1 0-23.2-6.8-28.6-17.7s-4.3-23.8 3-33.5L352 288l-32 0c-17.7 0-32-14.3-32-32z", "M0 288c0-17.7 14.3-32 32-32l160 0c12.4 0 23.7 7.2 29 18.4s3.6 24.5-4.4 34.1L100.3 448l91.7 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-12.4 0-23.7-7.2-29-18.4s-3.6-24.5 4.4-34.1L123.7 320 32 320c-17.7 0-32-14.3-32-32z"]]
}, faZzz = faSnooze, faScannerImage = {
  prefix: "fad",
  iconName: "scanner-image",
  icon: [576, 512, [], "f8f3", ["M0 352l0 64c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-64c0-35.3-28.7-64-64-64c-32 0-64 0-96 0L64 288c-35.3 0-64 28.7-64 64zm128 32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm96 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M35.8 48.9c8.3-15.6 27.7-21.5 43.3-13.2L525.2 273.7c20.9 11.2 36.6 29.4 44.7 50.9C559.6 303 537.5 288 512 288l-96 0L48.9 92.2C33.3 83.9 27.4 64.5 35.8 48.9zM96 352a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]]
}, faTvRetro = {
  prefix: "fad",
  iconName: "tv-retro",
  icon: [512, 512, [128250], "f401", ["M0 176L0 432c0 44.2 35.8 80 80 80l352 0c44.2 0 80-35.8 80-80l0-256c0-44.2-35.8-80-80-80L321.9 96l55-55c9.4-9.4 9.4-24.6 0-33.9c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7l-87 87L169 7c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7c-9.4 9.4-9.4 24.6 0 33.9l55 55L80 96C35.8 96 0 131.8 0 176zm64 48c0-35.3 28.7-64 64-64l192 0c35.3 0 64 28.7 64 64l0 160c0 35.3-28.7 64-64 64l-192 0c-35.3 0-64-28.7-64-64l0-160zm408 8a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm0 80a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M64 224c0-35.3 28.7-64 64-64H320c35.3 0 64 28.7 64 64V384c0 35.3-28.7 64-64 64H128c-35.3 0-64-28.7-64-64V224z"]]
}, faSquareT = {
  prefix: "fad",
  iconName: "square-t",
  icon: [448, 512, [], "e280", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm96 72c0-13.3 10.7-24 24-24l104 0 104 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0 0 168c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-168-80 0c-13.3 0-24-10.7-24-24z", "M96 168c0-13.3 10.7-24 24-24l104 0 104 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0 0 168c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-168-80 0c-13.3 0-24-10.7-24-24z"]]
}, faFarm = {
  prefix: "fad",
  iconName: "farm",
  icon: [576, 512, ["barn-silo"], "f864", ["M160 270.3c0-4.2 .8-8.3 2.4-12.2l48.9-118.7c3-7.4 8.7-13.3 15.9-16.7L354.3 62.5c4.3-2.1 9-3.1 13.7-3.1s9.4 1 13.7 3.1l127.1 60.2c7.2 3.4 12.9 9.4 15.9 16.7l48.9 118.7c1.6 3.9 2.4 8 2.4 12.2L576 480c0 17.7-14.3 32-32 32l-112 0 0-64c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48l0 64-112 0c-17.7 0-32-14.3-32-32l0-209.7zM320 248l0 48c0 13.3 10.7 24 24 24c16 0 32 0 48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24c-16 0-32 0-48 0c-13.3 0-24 10.7-24 24z", "M0 96l192 0c0-53-43-96-96-96S0 43 0 96zm181.4 32L0 128 0 464c0 26.5 21.5 48 48 48l88.6 0c-5.4-9.4-8.6-20.3-8.6-32l0-209.7c0-8.4 1.6-16.6 4.8-24.4l48.6-118zM344 224c-13.3 0-24 10.7-24 24l0 48c0 13.3 10.7 24 24 24l48 0c13.3 0 24-10.7 24-24l0-48c0-13.3-10.7-24-24-24l-48 0z"]]
}, faBarnSilo = faFarm, faChessKnight = {
  prefix: "fad",
  iconName: "chess-knight",
  icon: [448, 512, [9822], "f441", ["M16 489.4C16 501.9 26.1 512 38.6 512l370.7 0c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L384 432 64 432 22.6 473.4c-4.2 4.2-6.6 10-6.6 16z", "M82.7 61.3L96 48 74.9 37.5C68.2 34.1 64 27.3 64 19.8C64 8.9 72.9 0 83.8 0L224 0C330 0 416 86 416 192l0 17.3c0 9.8-.7 19.5-2.2 29.2L384 432 64 432l0-13.3c0-31.7 15.7-61.4 41.9-79.3l112.6-76.8c10.5-7.2 10.9-22.6 .7-30.3c-6.6-5-15.7-5-22.3 0l-49.4 37c-2.3 1.7-4.8 3.2-7.3 4.5l-3.2 1.6c-15.4 7.7-33.8 6.6-48.1-3l-10.6-7C69.3 259.6 64 249.6 64 238.9l0-132.4c0-17 6.7-33.3 18.7-45.3zM140 136a20 20 0 1 0 0-40 20 20 0 1 0 0 40z"]]
}, faBarsSort = {
  prefix: "fad",
  iconName: "bars-sort",
  icon: [448, 512, [], "e0ae", ["M0 256c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 288c-17.7 0-32-14.3-32-32z", "M448 96c0-17.7-14.3-32-32-32L32 64C14.3 64 0 78.3 0 96s14.3 32 32 32l384 0c17.7 0 32-14.3 32-32zM192 416c0-17.7-14.3-32-32-32L32 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32z"]]
}, faPalletBoxes = {
  prefix: "fad",
  iconName: "pallet-boxes",
  icon: [640, 512, [57863, "palette-boxes", "pallet-alt"], "f483", ["M0 352c0 17.7 14.3 32 32 32l32 0 0 64-32 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0 224 0 224 0 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-32 0 0-64 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0-224 0L96 320l-64 0c-17.7 0-32 14.3-32 32zm128 32l160 0 0 64-160 0 0-64zm224 0l160 0 0 64-160 0 0-64z", "M96 0C78.3 0 64 14.3 64 32l0 192c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32L96 0zM416 64c-17.7 0-32 14.3-32 32l0 128c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32L416 64z"]]
}, faPaletteBoxes = faPalletBoxes, faPalletAlt = faPalletBoxes, faFaceLaughSquint = {
  prefix: "fad",
  iconName: "face-laugh-squint",
  icon: [512, 512, ["laugh-squint"], "f59b", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm96.8 58.1c-3.8-13.7 7.4-26.1 21.6-26.1l275.2 0c14.2 0 25.5 12.4 21.6 26.1C396.2 382 332.1 432 256 432s-140.2-50-159.2-117.9zM116 125.1c0-9 9.6-14.7 17.5-10.5c30 16 59.9 32 89.9 47.9c10.7 5.7 10.7 21.1 0 26.8c-30 16-59.9 32-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6c12-14.4 24-28.8 36-43.2c-12-14.4-24-28.8-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm172.6 37.4c30-16 59.9-32 89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5c0 2.8-1 5.5-2.8 7.6c-12 14.4-24 28.8-36 43.2c12 14.4 24 28.8 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5c-30-16-59.9-32-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8z", "M116 125.1c0-9 9.6-14.7 17.5-10.5l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm280 0c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z"]]
}, faLaughSquint = faFaceLaughSquint, faCodeSimple = {
  prefix: "fad",
  iconName: "code-simple",
  icon: [576, 512, [], "e13d", ["M352 96c0 8.2 3.1 16.4 9.4 22.6L498.7 256 361.4 393.4c-6.2 6.2-9.4 14.4-9.4 22.6s3.1 16.4 9.4 22.6s14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4l160-160c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6l-160-160C400.4 67.1 392.2 64 384 64s-16.4 3.1-22.6 9.4S352 87.8 352 96z", "M214.6 73.4c12.5 12.5 12.5 32.8 0 45.3L77.3 256 214.6 393.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-160-160c-12.5-12.5-12.5-32.8 0-45.3l160-160c12.5-12.5 32.8-12.5 45.3 0z"]]
}, faBoltSlash = {
  prefix: "fad",
  iconName: "bolt-slash",
  icon: [640, 512, [], "e0b8", ["M128 256c0 3.8 .7 7.6 2 11.2c4.7 12.5 16.6 20.7 30 20.7l83.7 0-88.9-70-15.9 13.9c-7.1 6.2-10.9 15-10.9 24.1zm66.6 211.4c-5.9 13.7-1.5 29.7 10.6 38.5c5.6 4.1 12.2 6.1 18.8 6.1c7.5 0 15.1-2.7 21.1-7.9L374.4 391 264.5 304.4l-69.9 163zm33.8-313.7c73.4 57.5 146.7 115 220.1 172.5l52.7-46.1c10-8.8 13.6-22.9 8.9-35.3s-16.6-20.7-30-20.7l-111.5 0L445.4 44.6c5.9-13.7 1.5-29.7-10.6-38.5s-28.6-8-39.9 1.8L228.4 153.7z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faPanelFire = {
  prefix: "fad",
  iconName: "panel-fire",
  icon: [640, 512, [], "e42f", ["M0 96L0 416c0 35.3 28.7 64 64 64l273.6 0c-31-34.7-49.6-80.6-49.6-129.9c0-2 .1-4 .2-6.1c-13.4 0-24.2-10.7-24.2-24s10.7-24 24-24c3.5 0 6.9 .8 9.9 2.1c6.7-19 16.4-37.8 27.2-55.4c3.8-6.2 7.9-12.5 12.3-18.7L96 224c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 39.4c9-9.4 18.5-18.6 28.5-27.5c10-8.9 23-12.8 35.5-11.7L448 96c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM120 320a24 24 0 1 1 -48 0 24 24 0 1 1 48 0zm96 0a24 24 0 1 1 -48 0 24 24 0 1 1 48 0z", "M518 194.3l-12.3 13.8-19-19.9c-2-2.1-4-4.4-6-6.7c-9-10.2-18.6-21.3-32.7-21.6c-7.3-.2-14.6 2.3-20.3 7.5c-23.4 21.1-50 48.9-70.9 80.2C336 278.6 320 314.7 320 352c0 88.6 70.4 159.8 160 159.8c88.7 0 160-71.2 160-159.8c0-30-11-60.9-26.2-88.1c-15.2-27.4-35.3-52.3-55-70.6c-5.6-5.2-12.8-7.8-19.9-7.8c-7.6 0-15.5 2.8-20.9 8.9zM480 464c-35.3 0-64-28.7-64-64c0-36.5 37-73 54.8-88.4c5.4-4.7 13.1-4.7 18.5 0C507 327 544 363.5 544 400c0 35.3-28.7 64-64 64z"]]
}, faBinaryCircleCheck = {
  prefix: "fad",
  iconName: "binary-circle-check",
  icon: [640, 512, [], "e33c", ["M0 64C0 28.7 28.7 0 64 0l64 0c35.3 0 64 28.7 64 64l0 96c0 35.3-28.7 64-64 64l-64 0c-35.3 0-64-28.7-64-64L0 64zM0 480c0-17.7 14.3-32 32-32l16 0 0-83.6-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16c9.8-3.3 20.5-1.6 28.8 4.4s13.3 15.7 13.3 26l0 128 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0-48 0c-17.7 0-32-14.3-32-32zM64 64l0 96 64 0 0-96L64 64zM192 352c0-35.3 28.7-64 64-64l64 0c6.2 0 12.2 .9 17.9 2.5c-11.2 22.9-17.6 48.6-17.9 75.7l0-14.2-64 0 0 96 64 0 19.2 0c7.8 15.3 17.8 29.3 29.5 41.5C357 503.3 339.5 512 320 512l-64 0c-35.3 0-64-28.7-64-64l0-96zm32-160c0-17.7 14.3-32 32-32l16 0 0-83.6-5.9 2c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l48-16C297.2 .5 300.6 0 304 0c6.6 0 13.2 2.1 18.7 6c8.3 6 13.3 15.7 13.3 26l0 128 16 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-48 0-48 0c-17.7 0-32-14.3-32-32zm96 177.8c0 4.8 .3 9.5 .7 14.2l-.7 0 0-14.2z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]]
}, faCommentMinus = {
  prefix: "fad",
  iconName: "comment-minus",
  icon: [512, 512, [], "f4b1", ["M0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3C1.6 455.8 0 459.9 0 464c0 2.1 .4 4.1 1.2 6.1c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240zm160 0c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z", "M160 240c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z"]]
}, faBurrito = {
  prefix: "fad",
  iconName: "burrito",
  icon: [512, 512, [127791], "f7ed", ["M0 352c0 30.7 12.2 60.2 33.9 81.9l44.1 44.1C99.8 499.8 129.3 512 160 512s60.2-12.2 81.9-33.9L459.4 260.6C429.7 237.6 392.4 224 352 224c-15.2 0-29.9 1.9-43.9 5.5C279.5 310.2 202.5 368 112 368c-40.8 0-78.8-11.7-110.9-32C.4 341.3 0 346.6 0 352zm10.5-48.2C39.2 324.1 74.2 336 112 336c79.2 0 146.2-52.3 168.3-124.3c5-16.3 7.7-33.7 7.7-51.7c0-40.4-13.6-77.7-36.6-107.4L33.9 270.1c-9.9 9.9-17.8 21.3-23.4 33.7z", "M320 160c0-53.6-20.3-102.5-53.6-139.4C280.6 7.8 299.4 0 320 0c11.4 0 22.2 2.4 32 6.7C361.8 2.4 372.6 0 384 0c34.6 0 64.1 22 75.2 52.8C490 63.9 512 93.4 512 128c0 11.4-2.4 22.2-6.7 32c4.3 9.8 6.7 20.6 6.7 32c0 20.6-7.8 39.4-20.6 53.6C454.5 212.3 405.6 192 352 192c-11.9 0-23.6 1-34.9 2.9c1.9-11.4 2.9-23 2.9-34.9z"]]
}, faViolin = {
  prefix: "fad",
  iconName: "violin",
  icon: [640, 512, [127931], "f8ed", ["M128 368c0 26.7 7.3 51.7 19.9 73.1c16.8-12.6 33.7-25.3 50.5-37.9c6.4-4.8 15.3-4.1 20.9 1.5c5.3 5.3 10.7 10.7 16 16c5.6 5.6 6.3 14.5 1.5 20.9c-12.6 16.8-25.3 33.7-37.9 50.5C220.3 504.7 245.3 512 272 512c30.8 0 59.3-9.6 82.6-26.1c6.7-4.7 7.6-13.8 4.3-21.3c-4.5-10-7-21-7-32.7c0-44.2 35.8-80 80-80c5.3 0 10.5 .5 15.4 1.5c7.4 1.4 15.4-1 18.8-7.7c8.8-17.4 13.8-37 13.8-57.8c0-23.7-6.5-46-17.7-65c-7.9 7.9-15.8 15.8-23.7 23.7c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3c7.9-7.9 15.8-15.8 23.7-23.7C398 166.5 375.7 160 352 160c-20.8 0-40.4 5-57.8 13.8c-6.7 3.4-9.1 11.4-7.7 18.8c1 5 1.5 10.2 1.5 15.4c0 44.2-35.8 80-80 80c-11.6 0-22.7-2.5-32.7-7c-7.4-3.3-16.6-2.4-21.3 4.3C137.6 308.7 128 337.2 128 368zM448 72a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm48-48a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm48 144a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm48-48a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M630.6 54.6l-192 192c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l192-192c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3zM345 7c9.4 9.4 9.4 24.6 0 33.9L41 345c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L311 7c9.4-9.4 24.6-9.4 33.9 0zM219.3 404.7l16 16c5.6 5.6 6.3 14.5 1.5 20.9l-48 64c-2.8 3.7-7 6-11.7 6.4s-9.2-1.4-12.4-4.6l-32-32c-3.3-3.3-5-7.8-4.6-12.4s2.6-8.9 6.4-11.7l64-48c6.4-4.8 15.3-4.1 20.9 1.5z"]]
}, faObjectsColumn = {
  prefix: "fad",
  iconName: "objects-column",
  icon: [448, 512, [], "e3c1", ["M256 80l0 32c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48zm0 192l0 160c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48z", "M48 32C21.5 32 0 53.5 0 80L0 240c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-160c0-26.5-21.5-48-48-48L48 32zm0 320c-26.5 0-48 21.5-48 48l0 32c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-32c0-26.5-21.5-48-48-48l-96 0z"]]
}, faSquareChevronDown = {
  prefix: "fad",
  iconName: "square-chevron-down",
  icon: [448, 512, ["chevron-square-down"], "f329", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM96 224c0-6.1 2.3-12.3 7-17s10.8-7 17-7s12.3 2.3 17 7l87 87 87-87c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7s7 10.8 7 17s-2.3 12.3-7 17L241 345c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7L103 241c-4.7-4.7-7-10.8-7-17z", "M207 345c9.4 9.4 24.6 9.4 33.9 0L345 241c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-87 87-87-87c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L207 345z"]]
}, faChevronSquareDown = faSquareChevronDown, faCommentPlus = {
  prefix: "fad",
  iconName: "comment-plus",
  icon: [512, 512, [], "f4b2", ["M0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3C1.6 455.8 0 459.9 0 464c0 2.1 .4 4.1 1.2 6.1c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240zm144 0c0-13.3 10.7-24 24-24l64 0 0-64c.1-13.4 10.8-24 24-24c6.6 0 12.6 2.7 17 7c2.2 2.2 3.9 4.8 5.1 7.6c.6 1.4 1.1 2.9 1.4 4.5c.2 .8 .3 1.6 .4 2.4s.1 1.6 .1 2.5c0 21.3 0 42.7 0 64l64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0c0 21.3 0 42.7 0 64.2c0 .6 0 1.4-.1 2.2s-.2 1.6-.4 2.4c-.3 1.6-.8 3.1-1.4 4.5c-1.2 2.9-3 5.5-5.1 7.6c-4.3 4.3-10.3 7-17 7c-13.3 0-24-10.7-24-24c0-21.3 0-42.7 0-64l-64 0c-13.3 0-24-10.7-24-24z", "M232 264l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0z"]]
}, faTriangleInstrument = {
  prefix: "fad",
  iconName: "triangle-instrument",
  icon: [576, 512, ["triangle-music"], "f8e2", ["M32 418c0 51.9 42.1 94 94 94L450 512c51.9 0 94-42.1 94-94c0-17.8-5-35.2-14.5-50.2L430.7 211.3l-46.4 46.4 91.1 144.2c3 4.8 4.6 10.4 4.6 16c0 16.6-13.5 30-30 30L126 448c-16.6 0-30-13.5-30-30c0-5.7 1.6-11.2 4.6-16L266 140.1c4.8-7.6 13.1-12.1 22-12.1s17.3 4.6 22 12.1l48 75.9c15.5-15.5 30.9-30.9 46.4-46.4L364.1 106C353.6 89.2 338 76.7 320 69.9L320 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 37.9c-18 6.8-33.6 19.4-44.1 36.1L46.5 367.7C37 382.8 32 400.2 32 418z", "M537 105c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0L306.8 267.2c-5.9-2.1-12.2-3.2-18.8-3.2c-30.9 0-56 25.1-56 56s25.1 56 56 56s56-25.1 56-56c0-6.6-1.1-12.9-3.2-18.8L537 105z"]]
}, faTriangleMusic = faTriangleInstrument, faWheelchair = {
  prefix: "fad",
  iconName: "wheelchair",
  icon: [512, 512, [], "f193", ["M0 352c0 88.4 71.6 160 160 160s160-71.6 160-160l-48 0c0 61.9-50.1 112-112 112S48 413.9 48 352s50.1-112 112-112c5.3 0 10.5 .4 15.6 1.1c-3.3-16.3-6.5-32.6-9.8-49c-1.9-.1-3.8-.1-5.8-.1C71.6 192 0 263.6 0 352z", "M240 48a48 48 0 1 0 -96 0 48 48 0 1 0 96 0zm19.8 128l-1.9-9.7c-4.5-22.3-24-38.3-46.8-38.3c-30.1 0-52.7 27.5-46.8 57l23.1 115.5c6 29.9 32.2 51.4 62.8 51.4l5.1 0c.4 0 .8 0 1.3 0l94.1 0c6.7 0 12.6 4.1 15 10.4L402 459.2c6 16.1 23.8 24.6 40.1 19.1l48-16c16.8-5.6 25.8-23.7 20.2-40.5s-23.7-25.8-40.5-20.2l-18.7 6.2-25.5-68c-11.7-31.2-41.6-51.9-74.9-51.9l-68.5 0-9.6-48 63.4 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-76.2 0z"]]
}, faUserPilotTie = {
  prefix: "fad",
  iconName: "user-pilot-tie",
  icon: [448, 512, [], "e2c1", ["M96 192c0-13 1.9-25.5 5.5-37.2c23.9 9.6 62.8 20.1 113.9 21.1c2.7 .1 5.5 .1 8.2 .1l.4 0 .4 0c2.7 0 5.5 0 8.2-.1c51.1-1.1 90.1-11.5 113.9-21.1c3.6 11.8 5.5 24.3 5.5 37.2c0 70.7-57.3 128-128 128s-128-57.3-128-128z", "M230.1 .8l152 40c8.6 2.3 15.3 9.1 17.3 17.8s-1 17.8-7.8 23.6l-23.8 20.4c.1 1 .1 2 .1 3.1l0 21.2c0 10.7-5.3 20.8-15.1 25.2c-24.1 10.8-68.6 24-128.9 24s-104.8-13.2-128.9-24C85.3 147.7 80 137.6 80 126.9l0-21.2c0-1 0-2.1 .1-3.1L56.4 82.2c-6.8-5.8-9.8-14.9-7.8-23.6s8.7-15.6 17.3-17.8l152-40c4-1.1 8.2-1.1 12.2 0zM161.7 72.8c-4 7.9-.7 17.5 7.2 21.5l48 24c4.5 2.3 9.8 2.3 14.3 0l48-24c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2L224 86.1 183.2 65.7c-7.9-4-17.5-.7-21.5 7.2zM208 416l-20.4-40.8c-5.3-10.6 2.4-23.2 14.3-23.2l44.2 0c11.9 0 19.6 12.5 14.3 23.2L240 416l12.2 48.9L315 360.3c3-5 8.6-8.1 14.4-7.4C396.2 360.8 448 417.5 448 486.4c0 14.1-11.5 25.6-25.6 25.6L256 512s0 0 0 0l-64 0s0 0 0 0L25.6 512C11.5 512 0 500.5 0 486.4c0-68.9 51.8-125.6 118.6-133.5c5.8-.7 11.4 2.4 14.4 7.4l62.8 104.6L208 416zm128 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0z"]]
}, faPianoKeyboard = {
  prefix: "fad",
  iconName: "piano-keyboard",
  icon: [576, 512, [127929], "f8d5", ["M0 224l64 0 0 160 80 0 0-68.3c2.4 1.4 4.9 2.4 7.6 3.2c1.3 .4 2.7 .6 4.1 .8c.7 .1 1.4 .2 2.1 .2s1.4 .1 2.2 .1c5.8 0 11.3-1.6 16-4.3l0 68.3 96 0 0-68.3c2.4 1.4 4.9 2.4 7.6 3.2c1.3 .4 2.7 .6 4.1 .8c.7 .1 1.4 .2 2.1 .2s1.4 .1 2.2 .1c5.8 0 11.3-1.6 16-4.3l0 68.3 96 0 0-68.3c2.4 1.4 4.9 2.4 7.6 3.2c1.3 .4 2.7 .6 4.1 .8c.7 .1 1.4 .2 2.1 .2s1.4 .1 2.2 .1c5.8 0 11.3-1.6 16-4.3l0 68.3 80 0 0-160 64 0 0 160c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 224z", "M64 64C28.7 64 0 92.7 0 128l0 96 128 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 64 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 64 0 0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64 128 0 0-96c0-35.3-28.7-64-64-64L64 64z"]]
}, faBedEmpty = {
  prefix: "fad",
  iconName: "bed-empty",
  icon: [640, 512, [128719], "f8f9", ["M64 224l32 0 448 0c24.3 0 46.6 9.1 63.5 24l.5 0 0 .4c19.6 17.6 32 43.1 32 71.6l-32 0L64 320l0-64 0-32z", "M32 32c17.7 0 32 14.3 32 32l0 256 544 0 32 0 0 32 0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32L64 416l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 64C0 46.3 14.3 32 32 32z"]]
}, faCircleArrowUp = {
  prefix: "fad",
  iconName: "circle-arrow-up",
  icon: [512, 512, ["arrow-circle-up"], "f0aa", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm120-8c0-6.1 2.3-12.3 7-17L239 119c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7L385 231c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17c-9.4 9.4-24.6 9.4-33.9 0l-71-71L280 376c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-182.1-71 71c-9.4 9.4-24.6 9.4-33.9 0c-4.7-4.7-7-10.8-7-17z", "M239 119c9.4-9.4 24.6-9.4 33.9 0L385 231c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-71-71L280 376c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-182.1-71 71c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 119z"]]
}, faArrowCircleUp = faCircleArrowUp, faToggleOn = {
  prefix: "fad",
  iconName: "toggle-on",
  icon: [576, 512, [], "f205", ["M0 256C0 362 86 448 192 448l192 0c106 0 192-86 192-192s-86-192-192-192L192 64C86 64 0 150 0 256zm480 0a96 96 0 1 1 -192 0 96 96 0 1 1 192 0z", "M288 256a96 96 0 1 1 192 0 96 96 0 1 1 -192 0z"]]
}, faRectangleVertical = {
  prefix: "fad",
  iconName: "rectangle-vertical",
  icon: [384, 512, ["rectangle-portrait"], "f2fb", ["M320 0c35.3 0 64 28.7 64 64l0 384c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64L0 64C0 28.7 28.7 0 64 0L320 0z", ""]]
}, faRectanglePortrait = faRectangleVertical, faPersonWalking = {
  prefix: "fad",
  iconName: "person-walking",
  icon: [320, 512, [128694, "walking"], "f554", ["M0 480c0 8.2 3.1 16.4 9.4 22.6s14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4L116.3 441c4.6-4.6 8.2-10.1 10.6-16.1l27.7-69.2c-10.1-11-20.2-22.1-30.3-33.1c-.9-1-1.7-1.9-2.5-2.9c-.8-1-1.6-2.1-2.4-3.1c-1.5-2.1-2.9-4.3-4.1-6.5c-2.5-4.5-4.3-9.2-5.7-14.1L68.7 398 9.4 457.4C3.1 463.6 0 471.8 0 480z", "M208 96a48 48 0 1 0 0-96 48 48 0 1 0 0 96zM123.7 200.5c1-.4 1.9-.8 2.9-1.2l-16.9 63.5c-5.6 21.1-.1 43.6 14.7 59.7l70.7 77.1 22 88.1c4.3 17.1 21.7 27.6 38.8 23.3s27.6-21.7 23.3-38.8l-23-92.1c-1.9-7.8-5.8-14.9-11.2-20.8l-49.5-54 19.3-65.5 9.6 23c4.4 10.6 12.5 19.3 22.8 24.5l26.7 13.3c15.8 7.9 35 1.5 42.9-14.3s1.5-35-14.3-42.9L281 232.7l-15.3-36.8C248.5 154.8 208.3 128 163.7 128c-22.8 0-45.3 4.8-66.1 14l-8 3.5c-32.9 14.6-58.1 42.4-69.4 76.5l-2.6 7.8c-5.6 16.8 3.5 34.9 20.2 40.5s34.9-3.5 40.5-20.2l2.6-7.8c5.7-17.1 18.3-30.9 34.7-38.2l8-3.5z"]]
}, faWalking = faPersonWalking, faL = {
  prefix: "fad",
  iconName: "l",
  icon: [320, 512, [108], "4c", ["M64 32c17.7 0 32 14.3 32 32l0 352 192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L64 480c-17.7 0-32-14.3-32-32L32 64c0-17.7 14.3-32 32-32z", ""]]
}, faSignalStream = {
  prefix: "fad",
  iconName: "signal-stream",
  icon: [576, 512, [], "f8dd", ["M0 256c0 68.1 23.7 130.7 63.2 180c11.1 13.8 31.2 16 45 5s16-31.2 5-45C82.4 357.6 64 309 64 256s18.4-101.6 49.1-140c11.1-13.8 8.8-33.9-5-45s-33.9-8.8-45 5C23.7 125.3 0 187.9 0 256zm112 0c0 45.1 17 86.2 44.8 117.3c11.8 13.2 32 14.3 45.2 2.5s14.3-32 2.5-45.2c-17.8-19.8-28.5-46-28.5-74.7s10.8-54.8 28.5-74.7c11.8-13.2 10.7-33.4-2.5-45.2s-33.4-10.7-45.2 2.5C129 169.8 112 210.9 112 256zm259.5-74.7c17.8 19.8 28.5 46 28.5 74.7s-10.8 54.8-28.5 74.7c-11.8 13.2-10.7 33.4 2.5 45.2s33.4 10.7 45.2-2.5C447 342.2 464 301.1 464 256s-17-86.2-44.8-117.3c-11.8-13.2-32-14.3-45.2-2.5s-14.3 32-2.5 45.2zM462.9 116c30.7 38.4 49.1 87 49.1 140s-18.4 101.6-49.1 140c-11.1 13.8-8.8 33.9 5 45s33.9 8.8 45-5C552.3 386.7 576 324.1 576 256s-23.7-130.7-63.2-180c-11.1-13.8-31.2-16-45-5s-16 31.2-5 45z", "M232 256a56 56 0 1 1 112 0 56 56 0 1 1 -112 0z"]]
}, faDownToBracket = {
  prefix: "fad",
  iconName: "down-to-bracket",
  icon: [448, 512, [], "e4e7", ["M0 352l0 64c0 53 43 96 96 96l256 0c53 0 96-43 96-96l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 64c0 17.7-14.3 32-32 32L96 448c-17.7 0-32-14.3-32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M251.3 340.7L374.1 217.9c6.4-6.4 9.9-15 9.9-24c0-18.7-15.2-33.9-33.9-33.9L288 160l0-128c0-17.7-14.3-32-32-32L192 0c-17.7 0-32 14.3-32 32l0 128-62.1 0C79.2 160 64 175.2 64 193.9c0 9 3.6 17.6 9.9 24L196.7 340.7c7.2 7.2 17.1 11.3 27.3 11.3s20.1-4.1 27.3-11.3z"]]
}, faCircleZ = {
  prefix: "fad",
  iconName: "circle-z",
  icon: [512, 512, [], "e130", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM160 152c0-13.3 10.7-24 24-24l144 0c8.9 0 17.1 5 21.3 12.9s3.6 17.5-1.5 24.8L229.8 336l98.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-8.9 0-17.1-5-21.3-12.9c-1.8-3.5-2.7-7.3-2.7-11.1c0-4.8 1.4-9.6 4.3-13.7L282.2 176 184 176c-13.3 0-24-10.7-24-24z", "M160 152c0-13.3 10.7-24 24-24l144 0c8.9 0 17.1 5 21.3 12.9s3.6 17.5-1.5 24.8L229.8 336l98.2 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-8.9 0-17.1-5-21.3-12.9s-3.6-17.5 1.5-24.8L282.2 176 184 176c-13.3 0-24-10.7-24-24z"]]
}, faStars = {
  prefix: "fad",
  iconName: "stars",
  icon: [512, 512, [], "f762", ["M256 80c0 4.7 3.1 8.9 7.7 10.2L312 104l13.8 48.3c1.3 4.6 5.5 7.7 10.2 7.7s8.9-3.1 10.2-7.7L360 104l48.3-13.8c4.6-1.3 7.7-5.5 7.7-10.2s-3.1-8.9-7.7-10.2L360 56 346.2 7.7C344.9 3.1 340.7 0 336 0s-8.9 3.1-10.2 7.7L312 56 263.7 69.8c-4.6 1.3-7.7 5.5-7.7 10.2zM384 224c0 3.8 2.5 7.1 6.2 8.2l38.6 11 11 38.6c1 3.6 4.4 6.2 8.2 6.2s7.1-2.5 8.2-6.2l11-38.6 38.6-11c3.6-1 6.2-4.4 6.2-8.2s-2.5-7.1-6.2-8.2l-38.6-11-11-38.6c-1-3.6-4.4-6.2-8.2-6.2s-7.1 2.5-8.2 6.2l-11 38.6-38.6 11c-3.6 1-6.2 4.4-6.2 8.2z", "M213.4 157.4c-8.8-17.9-34.3-17.9-43.1 0l-46.3 94L20.5 266.5C.9 269.3-7 293.5 7.2 307.4l74.9 73.2L64.5 483.9c-3.4 19.6 17.2 34.6 34.8 25.3l92.6-48.8 92.6 48.8c17.6 9.3 38.2-5.7 34.8-25.3L301.6 380.6l74.9-73.2c14.2-13.9 6.4-38.1-13.3-40.9L259.7 251.4l-46.3-94z"]]
}, faFire = {
  prefix: "fad",
  iconName: "fire",
  icon: [448, 512, [128293], "f06d", ["M0 276.5C0 404.1 98.4 512 224 512c124.2 0 224-107.8 224-235.5c0-29.3-13.5-71.1-33.8-111.9c-20.7-41.4-49.9-85-84.5-118c-7.8-7.5-20.1-7.5-28-.1c-13.5 12.8-26 28.5-37 42.9c-24.2-30.2-50.1-58.1-77.7-84C183.1 1.8 178.1 0 173.1 0c-5 0-9.9 1.8-13.8 5.4c-46.5 43.2-86 92.3-113.9 139.3C17.8 191.2 0 238.1 0 276.5zm112 30.3c0-30.1 16.9-56.9 50.8-99.4c6.3-8 18.4-7.9 24.7 .1c16.8 21.3 46.3 58.8 62.8 79.8c6.2 7.9 18.1 8.1 24.7 .5l25.2-29.3c6.5-7.6 18-6.9 22.5 2c9 16.4 13.4 34.5 13.4 52.2c0 32.1-14.3 63.2-41.5 82.2c-21.1 14-43.5 21-68.8 21C162.6 416 112 375.4 112 306.8z", "M294.5 395c-21.1 14-43.5 21-68.8 21C162.6 416 112 375.4 112 306.8c0-30.1 16.9-56.9 50.8-99.4c6.3-8 18.4-7.9 24.7 .1c16.8 21.3 46.3 58.8 62.8 79.8c6.2 7.9 18.1 8.1 24.7 .5l25.2-29.3c6.5-7.6 18-6.9 22.5 2c25.3 46.2 14 105-28.1 134.4z"]]
}, faBedPulse = {
  prefix: "fad",
  iconName: "bed-pulse",
  icon: [640, 512, ["procedures"], "f487", ["M96 240a80 80 0 1 0 160 0A80 80 0 1 0 96 240zm192-48l0 128 0 32 32 0 288 0 32 0 0-32 0-64c0-53-43-96-96-96l-82.1 0-11.2 23.8c-8.6 18.3-26.4 30.5-46.5 32s-39.5-8-50.7-24.8L332.7 160 320 160c-17.7 0-32 14.3-32 32z", "M483.2 9.6C478.1 2.9 469.9-.7 461.6 .1s-15.7 6-19.3 13.7l-45.9 97.5L372 74.7C367.5 68 360 64 352 64L216 64c-13.3 0-24 10.7-24 24s10.7 24 24 24l123.2 0L380 173.3c4.8 7.2 13.1 11.3 21.7 10.6s16.3-5.9 19.9-13.7l47-99.9 24.1 32.1c4.5 6 11.6 9.6 19.2 9.6l104 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-92 0L483.2 9.6zM64 96c0-17.7-14.3-32-32-32S0 78.3 0 96L0 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32 512 0 0 32c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96 0-32-32 0L64 352 64 96z"]]
}, faProcedures = faBedPulse, faHouseDay = {
  prefix: "fad",
  iconName: "house-day",
  icon: [640, 512, [], "e00e", ["M-.1 160.2c0 5.9 3.2 11.3 8.4 14.1l51.2 27.6L42.8 257.6c-1.7 5.6-.1 11.7 4 15.9s10.3 5.7 15.9 4l55.7-16.7L133.1 288l15.7-14.5 41.7-38.5c-9.4 3.9-19.7 6-30.5 6c-44.2 0-80-35.8-80-80s35.8-80 80-80s80 35.8 80 80c0 13.1-3.1 25.4-8.7 36.3L296 137.5l-35.3-19 16.7-55.7c1.7-5.6 .1-11.7-4-15.9s-10.3-5.7-15.9-4L201.8 59.5 174.2 8.3C171.4 3.2 166-.1 160.1-.1s-11.3 3.2-14.1 8.4L118.4 59.5 62.8 42.9c-5.6-1.7-11.7-.1-15.9 4s-5.7 10.3-4 15.9l16.7 55.7L8.3 146.1c-5.2 2.8-8.4 8.2-8.4 14.1zM112 160a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M378.3 104.5c12.3-11.3 31.2-11.3 43.4 0l208 192c9.7 8.9 12.9 22.9 8.1 35.2S621.2 352 608 352l-32 0 0 112c0 26.5-21.5 48-48 48l-256 0c-26.5 0-48-21.5-48-48l0-112-32 0c-13.2 0-25-8.1-29.8-20.3s-1.6-26.2 8.1-35.2l208-192zM368 288c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16l0-64c0-8.8-7.2-16-16-16l-64 0z"]]
}, faShuttleSpace = {
  prefix: "fad",
  iconName: "shuttle-space",
  icon: [640, 512, ["space-shuttle"], "f197", ["M32 80l0 48 8 0 56 0 0-96L80 32C53.5 32 32 53.5 32 80zm0 304l0 48c0 26.5 21.5 48 48 48l16 0 0-96-56 0-8 0zM128 32l0 99.7c16.1 5.1 30.1 15.1 40 28.3l237.3 0L245.2 63.9C210.4 43 170.6 32 130 32l-2 0zm0 348.3l0 99.7 2 0c40.6 0 80.4-11 115.2-31.9L405.3 352 168 352c-.6 .8-1.3 1.6-1.9 2.4s-1.3 1.6-2 2.4c-1.4 1.5-2.8 3-4.3 4.5c-3 2.9-6.1 5.5-9.5 7.9c-6.7 4.8-14.3 8.6-22.3 11.1z", "M0 168c0-22.1 17.9-40 40-40l64 0c26.2 0 49.4 12.6 64 32l288 0c69.3 0 135 22.7 179.2 81.6c6.4 8.5 6.4 20.3 0 28.8C591 329.3 525.3 352 456 352l-288 0c-14.6 19.4-37.8 32-64 32l-64 0c-22.1 0-40-17.9-40-40l0-16L0 184l0-16zM512 268.4l0-24.9c0-19.6-15.9-35.6-35.6-35.6c-2.5 0-4.4 2-4.4 4.4l0 87.1c0 2.5 2 4.4 4.4 4.4c19.6 0 35.6-15.9 35.6-35.6z"]]
}, faSpaceShuttle = faShuttleSpace, faShirtLongSleeve = {
  prefix: "fad",
  iconName: "shirt-long-sleeve",
  icon: [640, 512, [], "e3c7", ["M0 224.4L0 384c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-159.6c0-2.7 .7-5.3 2-7.7l46-83.7L144 448c0 35.3 28.7 64 64 64l224 0c35.3 0 64-28.7 64-64l0-314.9 46 83.7c1.3 2.4 2 5 2 7.7L544 384c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-159.6c0-18.9-4.8-37.4-13.9-54L559.7 49.7C544.1 21.2 515.1 2.8 483 .3c-1-.2-2-.3-3-.3l-4.4 0L460 0 432 0c0 61.9-50.1 112-112 112S208 61.9 208 0L180 0 164.4 0 160 0c-1 0-2 .1-3 .3c-32.1 2.5-61 20.9-76.7 49.5L13.9 170.5C4.8 187 0 205.6 0 224.4z", "M208 0c0 61.9 50.1 112 112 112s112-50.1 112-112L400 0c0 44.2-35.8 80-80 80s-80-35.8-80-80L208 0z"]]
}, faChartPieSimple = {
  prefix: "fad",
  iconName: "chart-pie-simple",
  icon: [512, 512, ["chart-pie-alt"], "f64e", ["M0 272C0 404.6 107.5 512 240 512c121.4 0 221.7-90.1 237.7-207c.1-.7 .1-1.4 .1-2c0-8.3-6.9-15-15.5-15L224 288l0-238.4c0-8.6-6.7-15.5-15-15.5c-.7 0-1.4 0-2 .1C90.1 50.3 0 150.7 0 272z", "M272 240H495.4c9 0 16.6-7 16.6-16C512 100.3 411.7 0 288 0c-9 0-16 7.6-16 16.6V240z"]]
}, faChartPieAlt = faChartPieSimple, faFaceLaugh = {
  prefix: "fad",
  iconName: "face-laugh",
  icon: [512, 512, ["laugh"], "f599", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm96.8 58.1c-3.8-13.7 7.4-26.1 21.6-26.1l275.2 0c14.2 0 25.5 12.4 21.6 26.1C396.2 382 332.1 432 256 432s-140.2-50-159.2-117.9zM144.4 192c0-17.7 14.3-32 32-32c8.8 0 16.8 3.6 22.6 9.4c2.9 2.9 5.2 6.3 6.9 10.2c.8 1.9 1.4 3.9 1.9 6c.2 1 .4 2.1 .5 3.2c.1 .5 .1 1.1 .1 1.6s0 1 0 1.8c0 .5 0 1 0 1.5s-.1 1.1-.1 1.6c-.1 1.1-.3 2.1-.5 3.2c-.4 2.1-1.1 4.1-1.9 6c-1.6 3.8-4 7.3-6.9 10.2c-5.8 5.8-13.8 9.4-22.6 9.4c-17.7 0-32-14.3-32-32zm224 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M176.4 224a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm160 0a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faLaugh = faFaceLaugh, faFolderOpen = {
  prefix: "fad",
  iconName: "folder-open",
  icon: [576, 512, [128194, 128449, 61717], "f07c", ["M0 96L0 448c0-5.6 1.5-11.1 4.4-16.1l112-192C122.1 230 132.6 224 144 224l336 0 0-64c0-35.3-28.7-64-64-64L298.5 96c-17 0-33.3-6.7-45.3-18.7L226.7 50.7c-12-12-28.3-18.7-45.3-18.7L64 32C28.7 32 0 60.7 0 96zM2.4 460.1c.3 .7 .6 1.3 .9 1.9s.6 1.3 1 1.9c-.7-1.2-1.3-2.5-1.9-3.8zm459 1c7.6-7.6 13.3-17.2 16.2-27.9l-16.2 27.9z", "M144 224c-11.4 0-21.9 6-27.6 15.9l-112 192c-5.8 9.9-5.8 22.1-.1 32.1S20.5 480 32 480l400 0c11.4 0 21.9-6 27.6-15.9l112-192c5.8-9.9 5.8-22.1 .1-32.1S555.5 224 544 224l-400 0z"]]
}, faAlbumCollectionCircleUser = {
  prefix: "fad",
  iconName: "album-collection-circle-user",
  icon: [640, 512, [], "e48f", ["M.4 214l32 256c3 24 23.4 42 47.6 42l314.8 0c-18.9-13.3-35.1-30.3-47.5-49.9c-26.9 11.4-58 17.9-91.3 17.9C154.4 480 72 419.1 72 344s82.4-136 184-136c45.4 0 86.9 12.1 119 32.2c31.5-29.9 74.2-48.2 121-48.2c4.5 0 9 .2 13.4 .5c-2-5.9-5.2-11.5-9.4-16.3c-9.1-10.3-22.2-16.2-36-16.2L48 160c-13.8 0-26.9 5.9-36 16.2S-1.3 200.3 .4 214zM16 104c0 13.3 10.7 24 24 24l432 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L40 80c-13.3 0-24 10.7-24 24zM32 24c0 13.3 10.7 24 24 24l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L56 0C42.7 0 32 10.7 32 24zM224 352c0 13.3 14.3 24 32 24s32-10.7 32-24s-14.3-24-32-24s-32 10.7-32 24z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-32c-30.2 0-57.5-11.9-77.7-31.3c6.2-19 24-32.7 45.1-32.7l65.2 0c21 0 38.9 13.7 45.1 32.7C553.5 468.1 526.2 480 496 480zm0-192a48 48 0 1 1 0 96 48 48 0 1 1 0-96z"]]
}, faCandy = {
  prefix: "fad",
  iconName: "candy",
  icon: [640, 512, [127852], "e3e7", ["M0 256c0 10 6.2 19 15.6 22.5l29.1 10.9L15 319c-8.3 8.3-9.4 21.5-2.5 31s19.7 12.7 30.2 7.4L136 310.9c-5.2-17.4-8-35.8-8-54.9c0-1.2 0-2.4 0-3.6s.1-2.4 .1-3.6c.1-2.4 .2-4.7 .4-7.1c.3-4.7 .9-9.3 1.5-13.9c1.3-9.2 3.3-18.1 5.9-26.8L42.7 154.5c-10.5-5.3-23.3-2.1-30.2 7.4s-5.8 22.7 2.5 31l29.6 29.6L15.6 233.5C6.2 237 0 246 0 256zm504-54.9c5.2 17.4 8 35.8 8 54.9c0 1.2 0 2.4 0 3.6s-.1 2.4-.1 3.6c-.1 2.4-.2 4.7-.4 7.1c-.3 4.7-.9 9.3-1.5 13.9c-1.3 9.2-3.3 18.1-5.9 26.8l93.2 46.6c10.5 5.3 23.3 2.1 30.2-7.4s5.8-22.7-2.5-31l-29.6-29.6 29.1-10.9C633.8 275 640 266 640 256s-6.2-19-15.6-22.5l-29.1-10.9L625 193c8.3-8.3 9.4-21.5 2.5-31s-19.7-12.7-30.2-7.4L504 201.1z", "M318.1 64c-24.5 .2-47.9 5.1-69.4 13.7L419.9 420c20.3-12.4 38.2-28.5 52.6-47.3L318.1 64zM492.3 340.8C504.9 315.2 512 286.4 512 256c0-93.9-67.4-172.1-156.5-188.7L492.3 340.8zm-101 93.5L220.1 92c-20.3 12.4-38.2 28.5-52.6 47.3L321.9 448c24.5-.2 47.9-5.1 69.4-13.7zM284.5 444.7L147.7 171.2C135.1 196.8 128 225.6 128 256c0 93.9 67.4 172.1 156.5 188.7z"]]
}, faBowlHot = {
  prefix: "fad",
  iconName: "bowl-hot",
  icon: [512, 512, ["soup"], "f823", ["M128 24l0 8c0 32.7 15.4 63.6 41.6 83.2C183.7 125.8 192 142.4 192 160l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-32.7-15.4-63.6-41.6-83.2C184.3 66.2 176 49.6 176 32l0-8c0-13.3-10.7-24-24-24s-24 10.7-24 24zm128 0l0 8c0 32.7 15.4 63.6 41.6 83.2C311.7 125.8 320 142.4 320 160l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-8c0-32.7-15.4-63.6-41.6-83.2C312.3 66.2 304 49.6 304 32l0-8c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M33.6 224C15.4 224 .9 239.3 2 257.5c5.4 91.7 59.7 169.7 136.4 209.7l1.2 9.7c2.5 20 19.5 35 39.7 35l153.4 0c20.2 0 37.2-15 39.7-35l1.2-9.7c76.8-40 131-118 136.4-209.7c1.1-18.2-13.4-33.5-31.6-33.5L33.6 224z"]]
}, faSoup = faBowlHot, faFlatbread = {
  prefix: "fad",
  iconName: "flatbread",
  icon: [512, 512, [129747], "e40b", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm96-16c0-4.1 1.6-8.2 4.7-11.3l128-128c3.1-3.1 7.2-4.7 11.3-4.7s8.2 1.6 11.3 4.7c6.2 6.2 6.2 16.4 0 22.6l-128 128c-6.2 6.2-16.4 6.2-22.6 0c-3.1-3.1-4.7-7.2-4.7-11.3zm52.7 100.7l192-192c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-192 192c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6zm112 48l128-128c6.2-6.2 16.4-6.2 22.6 0c3.1 3.1 4.7 7.2 4.7 11.3s-1.6 8.2-4.7 11.3l-128 128c-3.1 3.1-7.2 4.7-11.3 4.7s-8.2-1.6-11.3-4.7c-6.2-6.2-6.2-16.4 0-22.6z", "M251.3 100.7c6.2 6.2 6.2 16.4 0 22.6l-128 128c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l128-128c6.2-6.2 16.4-6.2 22.6 0zm112 48c6.2 6.2 6.2 16.4 0 22.6l-192 192c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l192-192c6.2-6.2 16.4-6.2 22.6 0zm48 134.6l-128 128c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6l128-128c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]]
}, faHeartCirclePlus = {
  prefix: "fad",
  iconName: "heart-circle-plus",
  icon: [576, 512, [], "e500", ["M39.7 270.5L233.5 470.3c12 13 33 13 45.9 0l5.4-5.6C266.6 436.9 256 403.7 256 368c0-97.2 78.8-176 176-176c26.8 0 52.3 6 75 16.7c13.7-51.1-.9-108.7-43.8-146.1c-55.9-47-137.8-38-187.8 13l-19 21-20-21C208.7 47.4 170.8 32 133.3 32c-30 0-59.7 9.8-83.6 30.7c-62.9 53.9-65.9 149.8-10 207.8z", "M288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16z"]]
}, faCodeFork = {
  prefix: "fad",
  iconName: "code-fork",
  icon: [448, 512, [], "e13b", ["M48 153.3c4.9 2.1 10.1 3.8 15.4 4.9c2.7 .6 5.4 1 8.2 1.3c1.4 .1 2.8 .3 4.2 .3c1.4 .1 2.8 .1 4.2 .1c11.4 0 22.2-2.4 32-6.7l0 38.7c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-38.7c4.9 2.1 10.1 3.8 15.4 4.9c2.7 .6 5.4 1 8.2 1.3c1.4 .1 2.8 .3 4.2 .3c1.4 .1 2.8 .1 4.2 .1c11.4 0 22.2-2.4 32-6.7l0 38.7c0 53-43 96-96 96l-48 0 0 70.7c-4.9-2.1-10.1-3.8-15.4-4.9c-2.7-.6-5.4-1-8.2-1.3c-1.4-.1-2.8-.3-4.2-.3s-2.8-.1-4.2-.1c-11.4 0-22.2 2.4-32 6.7l0-70.7-48 0c-53 0-96-43-96-96l0-38.7z", "M80 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104A80 80 0 1 0 80 0a80 80 0 1 0 0 160zM368 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm0 104A80 80 0 1 0 368 0a80 80 0 1 0 0 160zM200 432a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm104 0a80 80 0 1 0 -160 0 80 80 0 1 0 160 0z"]]
}, faCity = {
  prefix: "fad",
  iconName: "city",
  icon: [640, 512, [127961], "f64f", ["M0 144l0 96L0 464c0 26.5 21.5 48 48 48l256 0 32 0 96 0 160 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48l-112 0 0-144c0-26.5-21.5-48-48-48L336 0c-26.5 0-48 21.5-48 48l0 48-64 0-48 0-64 0L64 96 48 96C21.5 96 0 117.5 0 144zm64 32c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM192 176c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM352 80c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm160 0c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm0 96c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32z", "M112 24c0-13.3-10.7-24-24-24S64 10.7 64 24l0 72 48 0 0-72zm112 0c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 72 48 0 0-72zm16 136l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16zM576 272c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32zM112 416c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zm144-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16zm320-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32zM128 176c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32zM240 320c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0zM128 304l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16z"]]
}, faSignalBarsWeak = {
  prefix: "fad",
  iconName: "signal-bars-weak",
  icon: [640, 512, ["signal-alt-1"], "f691", ["M192 304l0 160c0 26.5 21.5 48 48 48s48-21.5 48-48l0-160c0-26.5-21.5-48-48-48s-48 21.5-48 48zM352 176l0 288c0 26.5 21.5 48 48 48s48-21.5 48-48l0-288c0-26.5-21.5-48-48-48s-48 21.5-48 48zM512 48l0 416c0 26.5 21.5 48 48 48s48-21.5 48-48l0-416c0-26.5-21.5-48-48-48s-48 21.5-48 48z", "M32 432c0-26.5 21.5-48 48-48s48 21.5 48 48v32c0 26.5-21.5 48-48 48s-48-21.5-48-48V432z"]]
}, faSignalAlt1 = faSignalBarsWeak, faMicrophoneLines = {
  prefix: "fad",
  iconName: "microphone-lines",
  icon: [384, 512, [127897, "microphone-alt"], "f3c9", ["M16 216l0 40c0 89.1 66.2 162.7 152 174.4l0 33.6-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-33.6c85.8-11.7 152-85.3 152-174.4l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 70.7-57.3 128-128 128s-128-57.3-128-128l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24zM192 112c0 8.8 7.2 16 16 16l80 0 0-32-80 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l80 0 0-32-80 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l80 0 0-32-80 0c-8.8 0-16 7.2-16 16z", "M192 0C139 0 96 43 96 96l0 160c0 53 43 96 96 96s96-43 96-96l-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-32-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0 0-32-80 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l80 0c0-53-43-96-96-96z"]]
}, faMicrophoneAlt = faMicrophoneLines, faClockTwelve = {
  prefix: "fad",
  iconName: "clock-twelve",
  icon: [512, 512, [], "e358", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM232 120c0-13.3 10.7-24 24-24s24 10.7 24 24l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136z", "M256 96c13.3 0 24 10.7 24 24l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-136c0-13.3 10.7-24 24-24z"]]
}, faPepperHot = {
  prefix: "fad",
  iconName: "pepper-hot",
  icon: [512, 512, [127798], "f816", ["M0 467.6C0 492.1 19.9 512 44.4 512l58.8 0c155.2 0 294.6-82.3 371.5-210c-3.3-2.1-6.3-5.3-8.3-9.4c-3.9-7.8-7.8-15.6-11.7-23.4c-4.1-8.1-12.4-13.3-21.5-13.3c-24.4 0-48.8 0-73.2 0c-13.3 0-24-10.7-24-24c0-26.7 0-53.3 0-80c0-.1 0-.3 0-.4c0-.5 0-1.3-.1-2c-.1-.8-.2-1.6-.4-2.4c-.3-1.6-.8-3.1-1.4-4.5c-1.2-2.9-3-5.5-5.1-7.6c-4.3-4.3-10.3-7-17-7c-5.7 0-11.4 0-17.1 0c-.7 0-1.3 0-1.9-.1c-.6 0-1.2-.1-1.8-.2c-1.2-.2-2.3-.4-3.4-.7c-2.2-.6-4.2-1.5-5.9-2.7L171.2 345.5C154 380 122.2 404.9 84.5 413.2L34.8 424.3C14.5 428.8 0 446.8 0 467.6z", "M461 12.3C454.5 .8 439.9-3.4 428.3 3s-15.8 21-9.3 32.6l4.8 8.7c9.7 17.5 11.5 37.6 6 55.8C406.8 87.3 380.2 80 352 80c-24.3 0-47.3 5.4-67.9 15.1c-19.3 9-10.5 32.9 10.8 32.9l17.1 0c13.3 0 24 10.7 24 24l0 80c0 13.3 10.7 24 24 24l73.2 0c9.1 0 17.4 5.1 21.5 13.3l11.7 23.4c8.2 16.4 30.7 17.5 36.7 .1c5.8-16.5 8.9-34.3 8.9-52.8c0-42.1-16.2-80.4-42.8-108.9c16.4-34.3 15.9-75.4-3.4-110L461 12.3z"]]
}, faCitrusSlice = {
  prefix: "fad",
  iconName: "citrus-slice",
  icon: [512, 512, [], "e2f5", ["M33.4 371.7c0 6.5 4.1 15.8 7.5 19.3c2.1 2.1 4.2 4.2 6.4 6.1s4.3 3.9 6.5 5.8c4.4 3.8 8.9 7.4 13.4 10.9c9.2 6.9 18.7 13.1 28.5 18.6c19.7 11 40.6 19.1 61.8 24.2c9.7 2.2 18.5-5.3 18.5-15.1l0-177.2c0-6.2-4.3-11.5-10-14c-5.9-2.6-13-2.1-17.6 2.5L35.1 366.3c-1.2 1.2-1.7 3.1-1.7 5.4zM208 262.9l0 185.3c0 8.5 6.6 15.5 15 15.5c.1 0 .3 0 .4 0c50.6-1.4 100.8-18.3 143-50.6c7.3-5.6 7.7-16.3 1.1-22.9L230.9 253.5c-3.7-3.7-9.4-4.4-14.3-2.4s-8.5 6.5-8.5 11.8zM250.5 166c2.5 5.7 7.8 10 14 10l177.2 0c9.9 0 17.4-8.9 15.1-18.5C446.3 114.8 424.4 74.4 391 41c-3.4-3.4-12.8-7.5-19.3-7.5c-2.3 0-4.2 .5-5.4 1.7L253 148.4c-4.6 4.6-5.2 11.7-2.5 17.6zm.6 50.5c-2 4.9-1.4 10.6 2.4 14.3L390.3 367.6c6.5 6.5 17.3 6.2 22.9-1.1c32.3-42.2 49.2-92.5 50.6-143c.2-8.6-6.9-15.5-15.5-15.5L263 208c-5.3 0-9.8 3.7-11.8 8.5z", "M7 391c9.4-9.4 24.6-9.4 33.9 0c96.9 96.9 253.6 97.1 350.4 .3s96.6-253.5-.3-350.4c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0c115.6 115.6 116 302.6 .3 418.3S122.6 540.5 7 425c-9.4-9.4-9.4-24.6 0-33.9z"]]
}, faSheep = {
  prefix: "fad",
  iconName: "sheep",
  icon: [640, 512, [128017], "f711", ["M0 256c0 24.5 13.7 45.7 33.9 56.5c-1.2 5-1.9 10.2-1.9 15.5c0 35.3 28.7 64 64 64c.5 0 1 0 1.5 0c2.8-.1 5.6-.3 8.3-.7c6.8 28 32.1 48.7 62.2 48.7c7.5 0 14.7-1.3 21.3-3.6c6.8-2.4 13-5.9 18.5-10.2C219.7 439.6 236.9 448 256 448c19.2 0 36.5-8.5 48.2-21.9C315.1 434.8 329 440 344 440c30.1 0 55.3-20.8 62.2-48.7c2.7 .4 5.5 .7 8.3 .7c.5 0 1 0 1.5 0c35.3 0 64-28.7 64-64c0-2.7-.2-5.4-.5-8L464 320c-61.9 0-112-50.1-112-112l0-32.6c-18.7-2.7-35.5-14.8-43.5-33.4c-6.9-16.1-5.7-33.5 1.8-47.9C299 76 278.9 64 256 64c-19.2 0-36.5 8.5-48.2 21.9C196.9 77.2 183 72 168 72c-30.1 0-55.3 20.8-62.2 48.8c-3.2-.5-6.5-.8-9.8-.8c-35.3 0-64 28.7-64 64c0 5.3 .7 10.5 1.9 15.5C13.7 210.3 0 231.5 0 256z", "M384 135.8l-14.5 6.2c-12.2 5.2-26.3-.4-31.5-12.6s.4-26.3 12.6-31.5l47.8-20.5C415.3 50.2 445.5 32 480 32s64.7 18.2 81.6 45.4l47.8 20.5c12.2 5.2 17.8 19.3 12.6 31.5s-19.3 17.8-31.5 12.6L576 135.8l0 72.2c0 44.2-35.8 80-80 80l-32 0c-44.2 0-80-35.8-80-80l0-72.2zM464 160a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm80-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zM115.1 485.9L97.5 392c2.8-.1 5.6-.3 8.3-.7c6.8 28 32.1 48.7 62.2 48.7c15 0 28.9-5.2 39.8-13.9l.2 .2 0 53.7c0 17.7-14.3 32-32 32l-29.4 0c-15.4 0-28.6-11-31.5-26.1zM304 480l0-53.7 .2-.2C315.1 434.8 329 440 344 440c30.1 0 55.3-20.8 62.2-48.7c2.7 .4 5.5 .7 8.3 .7l-17.6 93.9C394.1 501 380.8 512 365.4 512L336 512c-17.7 0-32-14.3-32-32z"]]
}, faUnlock = {
  prefix: "fad",
  iconName: "unlock",
  icon: [448, 512, [128275], "f09c", ["M80 144l0 48 64 0 0-48c0-44.2 35.8-80 80-80c31.9 0 59.4 18.6 72.3 45.7c7.6 16 26.7 22.8 42.6 15.2s22.8-26.7 15.2-42.6C331 33.7 281.5 0 224 0C144.5 0 80 64.5 80 144z", "M0 256c0-35.3 28.7-64 64-64H384c35.3 0 64 28.7 64 64V448c0 35.3-28.7 64-64 64H64c-35.3 0-64-28.7-64-64V256z"]]
}, faColonSign = {
  prefix: "fad",
  iconName: "colon-sign",
  icon: [384, 512, [], "e140", ["M81 472.2l17.7-70.8c16.8 14.5 36.2 26.2 57.4 34.2l-13 52.1c-3.6 14.5-16.7 24.2-31 24.2c-2.6 0-5.2-.3-7.8-1c-17.1-4.3-27.6-21.7-23.3-38.8zm36.4-145.5l45.9-183.4c9-4.9 18.7-8.7 28.9-11.3c5.1-1.3 10.3-2.3 15.6-3c2.7-.3 5.3-.6 8.1-.8c1.4-.1 2.7-.1 4.1-.2c1.3 0 2.7-.1 4.1-.1c3 0 6 .1 8.9 .3L171.8 372.9c-22.2-9.9-41.1-26-54.4-46.1zM177 472.2l7.1-28.4c6.4 1.4 13 2.4 19.7 3.1c3.3 .3 6.7 .6 10.1 .8c1.7 .1 3.4 .2 5.1 .2s3.4 .1 5.1 .1c8.6 0 17.1-.6 25.4-1.7L239 487.8c-3.6 14.5-16.7 24.2-31 24.2c-2.6 0-5.2-.3-7.8-1c-17.1-4.3-27.6-21.7-23.3-38.8zm4.9-403.6L193 24.2C197.2 7.1 214.6-3.3 231.8 1s27.6 21.7 23.3 38.8l-6.5 25.8c-4-.5-8.1-.9-12.2-1.2c-2-.1-4.1-.2-6.2-.3c-2-.1-4.1-.1-6.2-.1c-14.5 0-28.6 1.6-42.1 4.6zm17.7 313l62-248.1c7.1 2.2 14 5 20.6 8.3c3.3 1.7 6.5 3.5 9.6 5.4c1.6 1 3.1 2 4.6 3s3 2.1 4.4 3.2c6 4.5 13.2 6.6 20.2 6.4L266.8 376.7c-6.7 2.4-13.6 4.2-20.8 5.4c-3.6 .6-7.2 1.1-10.9 1.4c-1.8 .2-3.7 .3-5.5 .4s-3.7 .1-5.6 .1c-8.3 0-16.5-.8-24.4-2.3zM277.2 71.5L289 24.2C293.2 7.1 310.6-3.3 327.8 1C342.3 4.6 352 17.6 352 32c0 2.6-.3 5.2-1 7.8L336 100c-17.6-12.7-37.5-22.4-58.8-28.6z", "M224 128c-70.7 0-128 57.3-128 128s57.3 128 128 128c28.9 0 55.4-9.5 76.8-25.6c14.1-10.6 34.2-7.8 44.8 6.4s7.8 34.2-6.4 44.8C307.1 433.7 267.2 448 224 448C118 448 32 362 32 256S118 64 224 64c43.2 0 83.1 14.3 115.2 38.4c14.1 10.6 17 30.7 6.4 44.8s-30.7 17-44.8 6.4C279.4 137.5 252.9 128 224 128z"]]
}, faHeadset = {
  prefix: "fad",
  iconName: "headset",
  icon: [512, 512, [], "f590", ["M0 256l0 40c0 13.3 10.7 24 24 24s24-10.7 24-24l0-40C48 141.1 141.1 48 256 48s208 93.1 208 208l0 144.1c0 22.1-17.9 40-40 40L313.6 440c-8.3-14.4-23.8-24-41.6-24l-32 0c-26.5 0-48 21.5-48 48s21.5 48 48 48l32 0c17.8 0 33.3-9.7 41.6-24l110.4 .1c48.6 0 88.1-39.4 88.1-88L512 256C512 114.6 397.4 0 256 0S0 114.6 0 256z", "M144 208c-35.3 0-64 28.7-64 64l0 48c0 35.3 28.7 64 64 64l16 0c17.7 0 32-14.3 32-32l0-112c0-17.7-14.3-32-32-32l-16 0zm224 0l-16 0c-17.7 0-32 14.3-32 32l0 112c0 17.7 14.3 32 32 32l16 0c35.3 0 64-28.7 64-64l0-48c0-35.3-28.7-64-64-64z"]]
}, faBadgerHoney = {
  prefix: "fad",
  iconName: "badger-honey",
  icon: [640, 512, [129441], "f6b4", ["M88.8 187.5c17 40.2 56.8 68.5 103.2 68.5l53.4 0c17.4 0 34.5-4.7 49.4-13.7l106.8-64.1c19.9-11.9 42.7-18.2 65.9-18.2l5.9 0 45.3 0 51.3 0-68-37.8c-12.1-6.7-25.6-10.2-39.5-10.2c-12.6 0-25.1 2.9-36.3 8.6l-4.7 2.4c-27.7 13.9-58.3 21.1-89.2 21.1L160 144c-31 0-58 17.7-71.2 43.5zm448.3 63.8l16.1 25.8c1.6 2.5 4.2 3.8 6.8 3.8s5.2-1.3 6.8-3.8l22.8-36.5c-1.4 .2-2.8 .4-4.2 .6c-2.2 .2-4.2 .5-6.2 .7c-2.1 .3-4.2 .6-6.2 .9c-4.1 .7-8.2 1.4-12.2 2.3c-8.1 1.7-16 3.8-23.7 6.3z", "M180.6 352l-16 37.3c-3 6.9-3.4 14.6-1.2 21.8l8.3 27.7c6.2 20.5-9.2 41.2-30.7 41.2l-29.2 0c-14.1 0-26.6-9.3-30.7-22.8L68 413.5c-2.6-8.8-2.7-18.2-.2-27l16.8-59C69.1 316.2 56.2 301.4 47 284.3c-4.5 2.4-9.6 3.7-15 3.7c-17.7 0-32-14.3-32-32l0-32C0 153.3 57.3 96 128 96l32 0 172.2 0c23.5 0 46.7-5.5 67.8-16l4.7-2.4c17.9-9 37.7-13.6 57.8-13.6c22 0 43.6 5.6 62.8 16.3l81.9 45.5C627.4 137 640 158.4 640 181.6l0 3.8c0 14.5-5.8 28.4-16 38.6s-24.2 15.7-38.6 17.2C500.8 250 427.7 306.1 393 342.1l16.8 100.6C413 462.2 398 480 378.2 480l-31.1 0c-15.6 0-29-11.3-31.6-26.7L298.7 352l-118.1 0zM570 160l-68-37.8c-12.1-6.7-25.6-10.2-39.5-10.2c-12.6 0-25.1 2.9-36.3 8.6l-4.7 2.4c-27.7 13.9-58.3 21.1-89.2 21.1L160 144c-31 0-58 17.7-71.2 43.5c17 40.2 56.8 68.5 103.2 68.5l53.4 0c17.4 0 34.5-4.7 49.4-13.7l106.8-64.1c19.9-11.9 42.7-18.2 65.9-18.2l5.9 0c-.9 2.5-1.4 5.2-1.4 8c0 13.3 10.7 24 24 24s24-10.7 24-24c0-2.8-.5-5.5-1.4-8l51.3 0z"]]
}, faH4 = {
  prefix: "fad",
  iconName: "h4",
  icon: [640, 512, [], "f86a", ["M0 96L0 256 0 416c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 192 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160 0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 128L64 224 64 96c0-17.7-14.3-32-32-32S0 78.3 0 96z", "M479 103.8c4.3-17.1-6.1-34.5-23.3-38.8s-34.5 6.1-38.8 23.3l-48 192c-2.4 9.6-.2 19.7 5.8 27.5s15.4 12.3 25.2 12.3l176 0 0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 160-135 0L479 103.8z"]]
}, faStoreSlash = {
  prefix: "fad",
  iconName: "store-slash",
  icon: [640, 512, [], "e071", ["M48 146.5c0-4 .3-8 .9-12l106.4 83.9c-9.6 3.6-20 5.6-31 5.6c-4.1 0-8.2-.3-12.1-.8C72.7 217.9 48 183 48 146.5zM94.9 49.1l22.7-36C122.8 5 131.9 0 141.6 0L498.4 0c9.7 0 18.8 5 23.9 13.1l57.3 90.7c29.7 46.9 3.4 112-52.1 119.4c-4 .5-7.9 .8-12.1 .8c-26.1 0-49.2-11.4-65.2-29c-15.9 17.6-39 29-65.2 29c-26.1 0-49.3-11.4-65.2-29c-5.5 6-11.8 11.3-18.8 15.7L94.9 49.1zM96 252.6c3.9 1 7.9 1.7 12.1 2.3c5.3 .7 10.7 1.1 16.3 1.1c12.5 0 24.4-1.9 35.6-5.4L160 384l205.5 0L514.9 501.7c-10 6.5-22 10.3-34.9 10.3l-320 0c-35.3 0-64-28.7-64-64l0-64 0-131.4zm384-2c11.2 3.5 23.1 5.3 35.4 5.3c5.6 0 10.9-.4 16.3-1.1c4.2-.6 8.3-1.3 12.3-2.3L544 384l0 17.1c-21.3-16.7-42.7-33.4-64-50.2l0-100.3z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faRoadCircleXmark = {
  prefix: "fad",
  iconName: "road-circle-xmark",
  icon: [640, 512, [], "e566", ["M32 425.4C32 455.5 56.5 480 86.6 480L288 480l0-64c0-17.7 14.3-32 32-32l.7 0c-.5-5.3-.7-10.6-.7-16c0-16.9 2.4-33.3 6.8-48.7c-2.2 .5-4.5 .7-6.8 .7c-17.7 0-32-14.3-32-32l0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 42.8c31.9-45.2 84.5-74.8 144-74.8c11.6 0 22.9 1.1 33.8 3.2L487.1 74.6C478 49.1 453.9 32 426.8 32L352 32l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64-74.8 0c-27.1 0-51.3 17.1-60.3 42.6L35.1 407.2c-2.1 5.9-3.1 12-3.1 18.2z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm203.3-59.3c-6.2-6.2-16.4-6.2-22.6 0L496 345.4l-36.7-36.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L473.4 368l-36.7 36.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L496 390.6l36.7 36.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L518.6 368l36.7-36.7c6.2-6.2 6.2-16.4 0-22.6z"]]
}, faSignalSlash = {
  prefix: "fad",
  iconName: "signal-slash",
  icon: [640, 512, [], "f695", ["M32 416l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7-14.3-32-32-32s-32 14.3-32 32zm128-96l0 160c0 17.7 14.3 32 32 32s32-14.3 32-32l0-160c0-17.7-14.3-32-32-32s-32 14.3-32 32zm128 2.9L288 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-106.7-64-50.4zm6.1-117.7c19.3 15.1 38.6 30.3 57.9 45.4l0-26.6c0-17.7-14.3-32-32-32c-10.7 0-20.1 5.2-25.9 13.2zM416 128l0 172.7c21.3 16.7 42.7 33.4 64 50.2L480 128c0-17.7-14.3-32-32-32s-32 14.3-32 32zm0 295.8l0 56.2c0 17.7 14.3 32 32 32s32-14.3 32-32l0-5.8-64-50.4zM544 32l0 369.1c21.3 16.7 42.7 33.4 64 50.2L608 32c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faUserMinus = {
  prefix: "fad",
  iconName: "user-minus",
  icon: [640, 512, [], "f503", ["M0 482.3C0 498.7 13.3 512 29.7 512l388.6 0c16.4 0 29.7-13.3 29.7-29.7C448 383.8 368.2 304 269.7 304l-91.4 0C79.8 304 0 383.8 0 482.3zM96 128a128 128 0 1 0 256 0A128 128 0 1 0 96 128z", "M448 224c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-144 0c-13.3 0-24-10.7-24-24z"]]
}, faMarsStrokeUp = {
  prefix: "fad",
  iconName: "mars-stroke-up",
  icon: [320, 512, [9896, "mars-stroke-v"], "f22a", ["M96 352a64 64 0 1 0 128 0A64 64 0 1 0 96 352z", "M148.7 4.7c6.2-6.2 16.4-6.2 22.6 0l64 64c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9l-40 0 0 24 32 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-32 0 0 24c0 .6 0 1.2-.1 1.8c77 11.6 136.1 78 136.1 158.2c0 88.4-71.6 160-160 160S0 440.4 0 352c0-80.2 59.1-146.7 136.1-158.2c0-.6-.1-1.2-.1-1.8l0-24-32 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l32 0 0-24L96 96c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l64-64zM256 352A96 96 0 1 0 64 352a96 96 0 1 0 192 0z"]]
}, faMarsStrokeV = faMarsStrokeUp, faChampagneGlasses = {
  prefix: "fad",
  iconName: "champagne-glasses",
  icon: [640, 512, [129346, "glass-cheers"], "f79f", ["M0 428.1c0 13.1 8.1 25.4 21.1 30.1l71.1 25.9L163.3 510c3.6 1.3 7.3 1.9 10.9 1.9c13.1 0 25.3-8.1 30.1-21.1c6-16.6-2.5-35-19.1-41l-41-15 31.3-86.2c59.4 5.2 116.2-33.9 130-95.2L320 188.8l14.6 64.7c13.8 61.3 70.6 100.4 130 95.2l31.3 86.2-41 15c-16.6 6.1-25.2 24.4-19.1 41c4.7 13 17 21.1 30 21.1c3.6 0 7.3-.6 10.9-1.9l71.1-25.9L619 458.2c13-4.7 21.1-17 21.1-30.1c0-3.6-.6-7.3-1.9-10.9c-6-16.6-24.4-25.2-41-19.1l-41 15-31.3-86.2c48.8-34.3 67.2-100.8 38.5-156.6L484.4 17.3C478.8 6.4 467.7 0 456 0c-3.6 0-7.3 .6-10.9 1.9L320 47.5 195 1.9C191.4 .6 187.7 0 184 0c-11.7 0-22.8 6.4-28.4 17.3L76.9 170.2C48.1 226 66.5 292.5 115.3 326.8L84 413l-41-15c-16.6-6.1-35 2.5-41 19.1C.6 420.8 0 424.4 0 428.1zM133.7 199.6c12.9-25 25.8-50 38.7-75l27.2-52.8 75.1 27.4c-4.4 19.3-8.7 38.6-13.1 57.9c-6.2 27.5-12.4 54.9-18.6 82.4c-6.2 27.6-30.6 45.7-57.1 45.7c-6.6 0-13.4-1.1-20.1-3.6c-33.2-12.1-48.2-50.6-32.1-82z", "M172.4 124.5l-38.7 75c-16.2 31.4-1.1 69.9 32.1 82s69.4-7.7 77.2-42.2L261.6 157l-89.2-32.5zm295.2 0L378.5 157 397 239.4c7.8 34.5 44 54.3 77.2 42.2s48.2-50.6 32.1-82l-38.7-75z"]]
}, faGlassCheers = faChampagneGlasses, faTaco = {
  prefix: "fad",
  iconName: "taco",
  icon: [512, 512, [127790], "f826", ["M0 448c0-43.2 10.7-84 29.7-119.7C72.6 247.2 157.9 192 256 192s183.4 55.2 226.3 136.3C501.3 364 512 404.8 512 448c0 17.7-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32zm96-48a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm64-64a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M237.2 38.4c11-8.6 26.5-8.6 37.5 0l44.1 34.2c5.6 4.4 12.6 6.6 19.7 6.4l55.8-1.7c14-.4 26.5 8.6 30.4 22.1l15.6 53.6c2 6.8 6.3 12.8 12.2 16.8L498.6 201c11.6 7.9 16.3 22.5 11.6 35.7l-27.8 91.6C439.4 247.2 354.1 192 256 192s-183.4 55.2-226.3 136.3L1.8 236.7c-4.7-13.1 0-27.8 11.6-35.7l46.1-31.4c5.9-4 10.2-9.9 12.2-16.8L87.3 99.3c3.9-13.4 16.4-22.5 30.4-22.1L173.4 79c7.1 .2 14.1-2 19.7-6.4l44.1-34.2z"]]
}, faHexagonPlus = {
  prefix: "fad",
  iconName: "hexagon-plus",
  icon: [512, 512, ["plus-hexagon"], "f300", ["M7.4 256c0 12.4 3.2 24.9 9.6 36l88.3 152.9c12.9 22.3 36.6 36 62.4 36l176.6 0c25.7 0 49.5-13.7 62.4-36L494.9 292c6.4-11.1 9.6-23.6 9.6-36s-3.2-24.9-9.6-36L406.6 67.1c-12.9-22.3-36.6-36-62.4-36l-176.6 0c-25.7 0-49.5 13.7-62.4 36L17.1 220c-6.4 11.1-9.6 23.6-9.6 36zM144 256c0-13.3 10.7-24 24-24c21.3 0 42.7 0 64 0l0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64c21.3 0 42.7 0 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24c-21.3 0-42.7 0-64 0l0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64c-21.3 0-42.7 0-64 0c-13.3 0-24-10.7-24-24z", "M232 280l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0z"]]
}, faPlusHexagon = faHexagonPlus, faClipboard = {
  prefix: "fad",
  iconName: "clipboard",
  icon: [384, 512, [128203], "f328", ["M0 128L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64l-49.6 0c.2 .8 .3 1.6 .4 2.3C290.1 72.6 304 90.7 304 112l0 24c0 13.3-10.7 24-24 24l-88 0-88 0c-13.3 0-24-10.7-24-24l0-24c0-21.3 13.9-39.4 33.2-45.7c.1-.8 .3-1.6 .4-2.3L64 64C28.7 64 0 92.7 0 128z", "M192 0c-39.5 0-72.4 28.7-78.8 66.3C93.9 72.6 80 90.7 80 112l0 24c0 13.3 10.7 24 24 24l88 0 88 0c13.3 0 24-10.7 24-24l0-24c0-21.3-13.9-39.4-33.2-45.7C264.4 28.7 231.5 0 192 0zm0 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faHouseCircleExclamation = {
  prefix: "fad",
  iconName: "house-circle-exclamation",
  icon: [640, 512, [], "e50a", ["M0 255.5c0 18 14 32.1 32 32.1l32 0 0 69.7c-.1 .9-.1 1.8-.1 2.8l0 112c0 22.1 17.9 40 40 40l16 0c1.2 0 2.4-.1 3.6-.2c1.5 .1 3 .2 4.5 .2l31.9 0 24 0c22.1 0 40-17.9 40-40l0-24 0-64c0-17.7 14.3-32 32-32l64 0 .7 0c8.1-89.7 83.5-160 175.3-160c8.9 0 17.6 .7 26.1 1.9L309.5 7c-6-5-14-7-21-7s-15 1-22 8L10 231.5c-7 7-10 15-10 24z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168 72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-8-152c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 80c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80z"]]
}, faFileArrowUp = {
  prefix: "fad",
  iconName: "file-arrow-up",
  icon: [384, 512, ["file-upload"], "f574", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM96 304c0 6.1 2.3 12.3 7 17c9.4 9.4 24.6 9.4 33.9 0l31-31L168 392c0 13.3 10.7 24 24 24s24-10.7 24-24l0-102.1 31 31c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-72-72c-9.4-9.4-24.6-9.4-33.9 0l-72 72c-4.7 4.7-7 10.8-7 17z", "M384 160l-128 0c-17.7 0-32-14.3-32-32L224 0 384 160zM216 392c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-102.1-31 31c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l72-72c9.4-9.4 24.6-9.4 33.9 0l72 72c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-31-31L216 392z"]]
}, faFileUpload = faFileArrowUp, faWifi = {
  prefix: "fad",
  iconName: "wifi",
  icon: [640, 512, ["wifi-3", "wifi-strong"], "f1eb", ["", "M54.2 202.9C123.2 136.7 216.8 96 320 96s196.8 40.7 265.8 106.9c12.8 12.2 33 11.8 45.2-.9s11.8-33-.9-45.2C549.7 79.5 440.4 32 320 32S90.3 79.5 9.8 156.7C-2.9 169-3.3 189.2 8.9 202s32.5 13.2 45.2 .9zM320 256c56.8 0 108.6 21.1 148.2 56c13.3 11.7 33.5 10.4 45.2-2.8s10.4-33.5-2.8-45.2C459.8 219.2 393 192 320 192s-139.8 27.2-190.5 72c-13.3 11.7-14.5 31.9-2.8 45.2s31.9 14.5 45.2 2.8c39.5-34.9 91.3-56 148.2-56zm64 160a64 64 0 1 0 -128 0 64 64 0 1 0 128 0z"]]
}, faWifi3 = faWifi, faWifiStrong = faWifi, faMessages = {
  prefix: "fad",
  iconName: "messages",
  icon: [640, 512, ["comments-alt"], "f4b6", ["M256 352l96 0c53 0 96-43 96-96l0-128 128 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64l-32 0 0 48c0 6.1-3.4 11.6-8.8 14.3s-11.9 2.1-16.8-1.5L437.3 448 320 448c-35.3 0-64-28.7-64-64l0-32z", "M0 64C0 28.7 28.7 0 64 0L352 0c35.3 0 64 28.7 64 64l0 192c0 35.3-28.7 64-64 64l-149.3 0-81.1 60.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-48-32 0c-35.3 0-64-28.7-64-64L0 64z"]]
}, faCommentsAlt = faMessages, faBath = {
  prefix: "fad",
  iconName: "bath",
  icon: [512, 512, [128705, "bathtub"], "f2cd", ["M32 77.3L32 256l64 0L96 77.3c0-7.3 5.9-13.3 13.3-13.3c3.5 0 6.9 1.4 9.4 3.9l14.9 14.9C130 91.8 128 101.7 128 112c0 19.9 7.2 38 19.2 52c-5.3 9.2-4 21.1 3.8 29c9.4 9.4 24.6 9.4 33.9 0L289 89c4.7-4.7 7-10.8 7-17s-2.3-12.3-7-17c-7.9-7.9-19.8-9.1-29-3.8C246 39.2 227.9 32 208 32c-10.3 0-20.2 2-29.2 5.5L163.9 22.6C149.4 8.1 129.7 0 109.3 0C66.6 0 32 34.6 32 77.3z", "M32 256c-17.7 0-32 14.3-32 32s14.3 32 32 32l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 256zm448 96L32 352l0 16c0 28.4 12.4 54 32 71.6L64 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-16 256 0 0 16c0 17.7 14.3 32 32 32s32-14.3 32-32l0-40.4c19.6-17.6 32-43.1 32-71.6l0-16z"]]
}, faBathtub = faBath, faUmbrellaSimple = {
  prefix: "fad",
  iconName: "umbrella-simple",
  icon: [512, 512, ["umbrella-alt"], "e2bc", ["M131.4 462.3l2.3 4.7c13.8 27.6 42 45 72.8 45c45 0 81.4-36.5 81.4-81.4L288 288l-64 0 0 142.6c0 9.6-7.8 17.4-17.4 17.4c-6.6 0-12.6-3.7-15.6-9.6l-2.3-4.7c-7.9-15.8-27.1-22.2-42.9-14.3s-22.2 27.1-14.3 42.9z", "M288 32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 2C108.2 48.4 16.4 140.2 2 256.1C-.2 273.6 14.3 288 32 288l448 0c17.7 0 32.2-14.4 30-31.9C495.6 140.2 403.8 48.4 288 34l0-2z"]]
}, faUmbrellaAlt = faUmbrellaSimple, faRectangleHistoryCirclePlus = {
  prefix: "fad",
  iconName: "rectangle-history-circle-plus",
  icon: [640, 512, [], "e4a3", ["M0 224L0 448c0 35.3 28.7 64 64 64l330.8 0C349.5 480.1 320 427.5 320 368c0-97.2 78.8-176 176-176c2.5 0 5 .1 7.5 .2c-11-19.2-31.8-32.2-55.5-32.2L64 160c-35.3 0-64 28.7-64 64zM48 104c0 13.3 10.7 24 24 24l368 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L72 80c-13.3 0-24 10.7-24 24zM96 24c0 13.3 10.7 24 24 24l272 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L120 0C106.7 0 96 10.7 96 24z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16z"]]
}, faUnderline = {
  prefix: "fad",
  iconName: "underline",
  icon: [448, 512, [], "f0cd", ["M16 64c0 17.7 14.3 32 32 32l16 0 0 128c0 88.4 71.6 160 160 160s160-71.6 160-160l0-128 16 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-96 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l16 0 0 128c0 53-43 96-96 96s-96-43-96-96l0-128 16 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L48 32C30.3 32 16 46.3 16 64z", "M0 448c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32z"]]
}, faPrescriptionBottlePill = {
  prefix: "fad",
  iconName: "prescription-bottle-pill",
  icon: [576, 512, [], "e5c0", ["M0 32L0 64C0 81.7 14.3 96 32 96l320 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32L32 0C14.3 0 0 14.3 0 32zm32 96l0 64 112 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L32 224l0 64 112 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L32 320l0 64 112 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L32 416l0 32c0 35.3 28.7 64 64 64l192 0c11.6 0 22.4-3.1 31.8-8.4c-39-32.3-63.8-81-63.8-135.6c0-68.4 39-127.7 96-156.8l0-83.2L32 128z", "M338.5 297.1c-10.1-10.1-27-9.2-33.7 3.4C294.1 320.6 288 343.6 288 368c0 79.5 64.5 144 144 144c24.4 0 47.4-6.1 67.5-16.8c12.6-6.7 13.5-23.6 3.4-33.7L338.5 297.1zM525.5 438.9c10.1 10.1 27 9.2 33.7-3.4C569.9 415.4 576 392.4 576 368c0-79.5-64.5-144-144-144c-24.4 0-47.4 6.1-67.5 16.8c-12.6 6.7-13.5 23.6-3.4 33.7L525.5 438.9z"]]
}, faUserPen = {
  prefix: "fad",
  iconName: "user-pen",
  icon: [640, 512, ["user-edit"], "f4ff", ["M0 482.3C0 383.8 79.8 304 178.3 304l91.4 0c48.1 0 91.8 19.1 123.9 50.1l-40.3 40.3c-8.2 8.2-14 18.5-16.8 29.7l-15 60.1c-2.3 9.4-1.8 19 1.4 27.8L29.7 512C13.3 512 0 498.7 0 482.3zM352 128A128 128 0 1 1 96 128a128 128 0 1 1 256 0z", "M557.2 235.7l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4c-15.6-15.6-40.9-15.6-56.6 0zm-52 52L375.9 417c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L576.1 358.7l-71-71z"]]
}, faUserEdit = faUserPen, faBinarySlash = {
  prefix: "fad",
  iconName: "binary-slash",
  icon: [640, 512, [], "e33e", ["M128 64l0 11 64 50.2L192 64l64 0 0 96-19.6 0c20.5 16.1 41.1 32.2 61.6 48.3c13.5-11.7 22-29 22-48.3l0-96c0-35.3-28.7-64-64-64L192 0c-35.3 0-64 28.7-64 64zm0 416c0 17.7 14.3 32 32 32l48 0 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 83.6-16 0c-17.7 0-32 14.3-32 32zM320.1 348.2c-.1 1.3-.1 2.5-.1 3.8l0 96c0 35.3 28.7 64 64 64l64 0c20.1 0 38.1-9.3 49.8-23.8l-51-40.2L384 448l0-49.5-63.9-50.3zM352 192c0 17.7 14.3 32 32 32l48 0 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 83.6-16 0c-17.7 0-32 14.3-32 32zm47.7 96c37.4 29.3 74.8 58.7 112.3 88l0-24c0-35.3-28.7-64-64-64l-48.3 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faSquareO = {
  prefix: "fad",
  iconName: "square-o",
  icon: [448, 512, [], "e278", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM352 256A128 128 0 1 1 96 256a128 128 0 1 1 256 0zm-208 0a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M224 176a80 80 0 1 0 0 160 80 80 0 1 0 0-160zm128 80A128 128 0 1 1 96 256a128 128 0 1 1 256 0z"]]
}, faCaduceus = {
  prefix: "fad",
  iconName: "caduceus",
  icon: [512, 512, [], "e681", ["M0 196.1C0 211.5 12.5 224 27.9 224l110.8 0c33.5 0 66.2-10.5 93.3-30l0-82L171.5 71.7c-7.5-5-16.4-7.7-25.4-7.7c-11.6 0-22.9 4.4-31.3 12.4L8.8 175.7C3.2 181 0 188.4 0 196.1zM144 280l0 3.8c0 30.9 16.2 59.6 42.7 75.5l22.6 13.6-6.6 4c-26.5 15.9-42.7 44.5-42.7 75.5l0 3.8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-3.8c0-14.1 7.4-27.1 19.4-34.3l4.6-2.7 24-14.4 24-14.4 0 28.8 4.6 2.7c12 7.2 19.4 20.2 19.4 34.3l0 3.8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-3.8c0-30.9-16.2-59.6-42.7-75.5l-6.6-4 22.6-13.6c26.5-15.9 42.7-44.5 42.7-75.5l0-3.8c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 3.8c0 14.1-7.4 27.1-19.4 34.3L280 330.4l-24 14.4-24 14.4 0-28.8-20.6-12.3c-12-7.2-19.4-20.2-19.4-34.3l0-3.8c0-13.3-10.7-24-24-24s-24 10.7-24 24zM280 112l0 82c27.2 19.5 59.8 30 93.3 30l110.8 0c15.4 0 27.9-12.5 27.9-27.9c0-7.7-3.2-15.1-8.8-20.4l-106-99.3c-8.5-8-19.7-12.4-31.3-12.4c-9 0-17.9 2.7-25.4 7.7L280 112z", "M304 48c0 17.8-9.7 33.3-24 41.6l0 240.8-48 28.8 0-269.6c-14.3-8.3-24-23.8-24-41.6c0-26.5 21.5-48 48-48s48 21.5 48 48zM232 415.2l48-28.8 0 69.6 0 32c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-32 0-40.8z"]]
}, faSignature = {
  prefix: "fad",
  iconName: "signature",
  icon: [640, 512, [], "f5b7", ["M0 392c0-13.3 10.7-24 24-24l40 0 0 39.5c0 2.9 .1 5.7 .3 8.5L24 416c-13.3 0-24-10.7-24-24zm283.5 24c8.2-15.7 15.6-31.7 22.3-48L616 368c13.3 0 24 10.7 24 24s-10.7 24-24 24l-332.5 0z", "M224 96c-17.7 0-32 14.3-32 32l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c0-53 43-96 96-96s96 43 96 96l0 7.8c0 20.8-1.2 41.6-3.6 62.3l122.4-36.7c11.4-3.4 23.8-.2 32.2 8.4s11.2 21.1 7.4 32.4l-18 53.9 83.6 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-128 0c-10.3 0-19.9-4.9-26-13.3s-7.7-19.1-4.4-28.8l12.5-37.5-94.4 28.3c-11.9 52.8-31.6 103.5-58.4 150.5l-13.9 24.3c-12.9 22.6-36.9 36.5-62.9 36.5c-40 0-72.5-32.5-72.5-72.5l0-71.9c0-42.4 27.8-79.8 68.4-92l84.4-25.3c4.8-27.2 7.1-54.9 7.1-82.5l0-7.8c0-17.7-14.3-32-32-32zm7.8 194.3l-49 14.7C169.3 309 160 321.5 160 335.6l0 71.9c0 4.7 3.8 8.5 8.5 8.5c3 0 5.9-1.6 7.4-4.3l13.9-24.3c17.6-30.8 31.7-63.4 42.1-97.2z"]]
}, faStroopwafel = {
  prefix: "fad",
  iconName: "stroopwafel",
  icon: [512, 512, [], "f551", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm59-45.3c0-4.1 1.6-8.2 4.7-11.3c6.2-6.2 16.4-6.2 22.6 0c11.3 11.3 22.6 22.6 33.9 33.9c15.1-15.1 30.2-30.2 45.3-45.3c-18.9-18.9-37.7-37.7-56.6-56.6c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0c18.9 18.9 37.7 37.7 56.6 56.6c15.1-15.1 30.2-30.2 45.3-45.3c-11.3-11.3-22.6-22.6-33.9-33.9c-6.2-6.2-6.2-16.4 0-22.6c3.1-3.1 7.2-4.7 11.3-4.7s8.2 1.6 11.3 4.7C233.4 75 244.7 86.3 256 97.6c11.3-11.3 22.6-22.6 33.9-33.9c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6c-11.3 11.3-22.6 22.6-33.9 33.9c15.1 15.1 30.2 30.2 45.3 45.3c18.9-18.9 37.7-37.7 56.6-56.6c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6l-56.6 56.6c15.1 15.1 30.2 30.2 45.3 45.3c11.3-11.3 22.6-22.6 33.9-33.9c6.2-6.2 16.4-6.2 22.6 0c3.1 3.1 4.7 7.2 4.7 11.3s-1.6 8.2-4.7 11.3c-11.3 11.3-22.6 22.6-33.9 33.9c11.3 11.3 22.6 22.6 33.9 33.9c3.1 3.1 4.7 7.2 4.7 11.3s-1.6 8.2-4.7 11.3c-6.2 6.2-16.4 6.2-22.6 0c-11.3-11.3-22.6-22.6-33.9-33.9l-45.3 45.3c18.9 18.9 37.7 37.7 56.6 56.6c6.2 6.2 6.2 16.4 0 22.6s-16.4 6.2-22.6 0l-56.6-56.6c-15.1 15.1-30.2 30.2-45.3 45.3c11.3 11.3 22.6 22.6 33.9 33.9c6.2 6.2 6.2 16.4 0 22.6c-3.1 3.1-7.2 4.7-11.3 4.7s-8.2-1.6-11.3-4.7c-11.3-11.3-22.6-22.6-33.9-33.9c-11.3 11.3-22.6 22.6-33.9 33.9c-3.1 3.1-7.2 4.7-11.3 4.7s-8.2-1.6-11.3-4.7c-6.2-6.2-6.2-16.4 0-22.6c11.3-11.3 22.6-22.6 33.9-33.9c-15.1-15.1-30.2-30.2-45.3-45.3l-56.6 56.6c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6c18.9-18.9 37.7-37.7 56.6-56.6c-15.1-15.1-30.2-30.2-45.3-45.3c-11.3 11.3-22.6 22.6-33.9 33.9c-6.2 6.2-16.4 6.2-22.6 0c-3.1-3.1-4.7-7.2-4.7-11.3s1.6-8.2 4.7-11.3C75 278.6 86.3 267.3 97.6 256L63.7 222.1c-3.1-3.1-4.7-7.2-4.7-11.3zM142.9 256a45.3 45.3 0 1 0 90.5 0 45.3 45.3 0 1 0 -90.5 0zm67.9-67.9c15.1 15.1 30.2 30.2 45.3 45.3l45.3-45.3c-15.1-15.1-30.2-30.2-45.3-45.3c-15.1 15.1-30.2 30.2-45.3 45.3zm0 135.8C225.8 339 240.9 354 256 369.1c15.1-15.1 30.2-30.2 45.3-45.3c-15.1-15.1-30.2-30.2-45.3-45.3l-45.3 45.3zM278.6 256l45.3 45.3c15.1-15.1 30.2-30.2 45.3-45.3c-15.1-15.1-30.2-30.2-45.3-45.3c-15.1 15.1-30.2 30.2-45.3 45.3z", "M425.7 312.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L414.4 256l33.9-33.9c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-33.9 33.9-45.3-45.3 56.6-56.6c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0l-56.6 56.6-45.3-45.3 33.9-33.9c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L256 97.6 222.1 63.7c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l33.9 33.9-45.3 45.3-56.6-56.6c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6l56.6 56.6-45.3 45.3L86.3 199.4c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6L97.6 256 63.7 289.9c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l33.9-33.9 45.3 45.3-56.6 56.6c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0l56.6-56.6 45.3 45.3-33.9 33.9c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L256 414.4l33.9 33.9c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-33.9-33.9 45.3-45.3 56.6 56.6c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-56.6-56.6 45.3-45.3 33.9 33.9zM256 369.1l-45.3-45.3L256 278.6l45.3 45.3L256 369.1zm-67.9-67.9L142.9 256l45.3-45.3L233.4 256l-45.3 45.3zM256 233.4l-45.3-45.3L256 142.9l45.3 45.3L256 233.4zm67.9 67.9L278.6 256l45.3-45.3L369.1 256l-45.3 45.3z"]]
}, faBold = {
  prefix: "fad",
  iconName: "bold",
  icon: [384, 512, [], "f032", ["M0 64C0 46.3 14.3 32 32 32l48 0 16 0 128 0c70.7 0 128 57.3 128 128c0 31.3-11.3 60.1-30 82.3c37.1 22.4 62 63.1 62 109.7c0 70.7-57.3 128-128 128L96 480l-16 0-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l16 0 0-160L48 96 32 96C14.3 96 0 81.7 0 64zM224 224c35.3 0 64-28.7 64-64s-28.7-64-64-64L112 96l0 128 112 0zM112 288l0 128 144 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-32 0-112 0z", ""]]
}, faAnchorLock = {
  prefix: "fad",
  iconName: "anchor-lock",
  icon: [640, 512, [], "e4ad", ["M0 336c0 6.1 2.3 12.3 7 17c9.4 9.4 24.6 9.4 33.9 0l7-7 0 6.1c0 88.4 71.6 160 160 160l80 0 80 0c8 0 15.9-.6 23.6-1.7c-4.8-9-7.6-19.3-7.6-30.3l0-33.3c-5.2 .9-10.5 1.3-16 1.3l-48 0 0-208 32 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-10.9 0C367 158.8 384 129.4 384 96c0-53-43-96-96-96s-96 43-96 96c0 33.4 17 62.8 42.9 80L224 176c-17.7 0-32 14.3-32 32s14.3 32 32 32l32 0 0 208-48 0c-53 0-96-43-96-96l0-6.1 7 7c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9L97 263c-9.4-9.4-24.6-9.4-33.9 0L7 319c-4.7 4.7-7 10.8-7 17zM320 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M496 272l0 48 64 0 0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]]
}, faBuildingNgo = {
  prefix: "fad",
  iconName: "building-ngo",
  icon: [384, 512, [], "e4d7", ["M0 48L0 464c0 26.5 21.5 48 48 48l96 0 0-80c0-26.5 21.5-48 48-48s48 21.5 48 48l0 80 96 0c26.5 0 48-21.5 48-48l0-416c0-26.5-21.5-48-48-48L48 0C21.5 0 0 21.5 0 48zM32 80c0-7.1 4.6-13.3 11.4-15.3s14 .6 17.9 6.4c11.6 17.3 23.1 34.7 34.7 52L96 80c0-8.8 7.2-16 16-16s16 7.2 16 16l0 96c0 7.1-4.6 13.3-11.4 15.3s-14-.6-17.9-6.4c-11.6-17.3-23.1-34.7-34.7-52L64 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-96zM64 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM152 80c0-8.8 7.2-16 16-16c16 0 32 0 48 0c8.8 0 16 7.2 16 16s-7.2 16-16 16c-10.7 0-21.3 0-32 0l0 64c5.3 0 10.7 0 16 0l0-16c0-8.8 7.2-16 16-16s16 7.2 16 16l0 24c0 13.3-10.7 24-24 24c-10.7 0-21.3 0-32 0c-13.3 0-24-10.7-24-24l0-88zm8 160c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm96-128c0-26.5 21.5-48 48-48s48 21.5 48 48l0 32c0 26.5-21.5 48-48 48s-48-21.5-48-48l0-32zm0 128c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm32-128l0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M61.3 71.1c-3.9-5.9-11.2-8.5-17.9-6.4S32 72.9 32 80l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-43.2 34.7 52c3.9 5.9 11.2 8.5 17.9 6.4s11.4-8.3 11.4-15.3l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 43.2-34.7-52zM152 80l0 88c0 13.3 10.7 24 24 24l32 0c13.3 0 24-10.7 24-24l0-24c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 16-16 0 0-64 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0c-8.8 0-16 7.2-16 16zM304 96c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zm-48 16l0 32c0 26.5 21.5 48 48 48s48-21.5 48-48l0-32c0-26.5-21.5-48-48-48s-48 21.5-48 48z"]]
}, faTransporter3 = {
  prefix: "fad",
  iconName: "transporter-3",
  icon: [512, 512, [], "e045", ["M0 144c0 4.1 2.7 7.6 6.6 8.7L32 160l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 160l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 128l-7.3-25.4C55.6 98.7 52.1 96 48 96s-7.6 2.7-8.7 6.6L32 128 6.6 135.3C2.7 136.4 0 139.9 0 144zM96 272c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0c-8.8 0-16 7.2-16 16zm32-64c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0c-8.8 0-16 7.2-16 16zm32-64c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zm0 192c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zm0 64c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zM416 48c0 4.1 2.7 7.6 6.6 8.7L448 64l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 64l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 32 472.7 6.6C471.6 2.7 468.1 0 464 0s-7.6 2.7-8.7 6.6L448 32l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7z", "M208 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zm8 464l-88 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l256 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-88 0-80 0zM96 256.5l0-1c0 .3 0 .7 0 1z"]]
}, faEngineWarning = {
  prefix: "fad",
  iconName: "engine-warning",
  icon: [640, 512, ["engine-exclamation"], "f5f2", ["M0 160L0 352c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 48 0 0-48-48 0 0-72c0-13.3-10.7-24-24-24s-24 10.7-24 24zM184 88c0 13.3 10.7 24 24 24l72 0 0 32 48 0 0-32 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L208 64c-13.3 0-24 10.7-24 24zM544 224l0 192c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32l-32 0c-17.7 0-32 14.3-32 32z", "M128 144c-17.7 0-32 14.3-32 32l0 176c0 17.7 14.3 32 32 32l44.8 0 32 40c12.1 15.2 30.5 24 50 24L448 448c35.3 0 64-28.7 64-64l0-145.2c0-19.4-8.8-37.8-24-50L449.5 158c-11.3-9.1-25.4-14-40-14L208 144l-48 0-32 0zm196 64l0 88c0 11-9 20-20 20s-20-9-20-20l0-88c0-11 9-20 20-20s20 9 20 20zM304 344a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faEngineExclamation = faEngineWarning, faCircleDownRight = {
  prefix: "fad",
  iconName: "circle-down-right",
  icon: [512, 512, [], "e108", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm144-56c0-5.1 2-10 5.7-13.7l36.7-36.7c3.6-3.6 8.5-5.7 13.7-5.7s10 2 13.7 5.7L280 216l33.4-33.4c4.2-4.2 10-6.6 16-6.6c12.5 0 22.6 10.1 22.6 22.6L352 336c0 8.8-7.2 16-16 16l-137.4 0c-12.5 0-22.6-10.1-22.6-22.6c0-6 2.4-11.8 6.6-16L216 280l-66.3-66.3C146 210 144 205.1 144 200z", "M352 336l0-137.4c0-12.5-10.1-22.6-22.6-22.6c-6 0-11.8 2.4-16 6.6L280 216l-66.3-66.3C210 146 205.1 144 200 144s-10 2-13.7 5.7l-36.7 36.7C146 190 144 194.9 144 200s2 10 5.7 13.7L216 280l-33.4 33.4c-4.2 4.2-6.6 10-6.6 16c0 12.5 10.1 22.6 22.6 22.6L336 352c8.8 0 16-7.2 16-16z"]]
}, faSquareK = {
  prefix: "fad",
  iconName: "square-k",
  icon: [448, 512, [], "e274", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm128 56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 87.8L278.9 135.2c4.7-4.8 10.9-7.2 17.1-7.2c6.1 0 12.1 2.3 16.8 6.9c9.5 9.3 9.6 24.5 .3 33.9l-73 74.3 75.3 102.7c7.8 10.7 5.5 25.7-5.2 33.5c-4.3 3.1-9.2 4.6-14.2 4.6c-7.4 0-14.7-3.4-19.4-9.8L206 277.8l-30 30.5 0 51.7c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-61.5L128 152z", "M312.8 134.9c9.5 9.3 9.6 24.5 .3 33.9l-73 74.3 75.3 102.7c7.8 10.7 5.5 25.7-5.2 33.5s-25.7 5.5-33.5-5.2L206 277.8l-30 30.5 0 51.7c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-61.5L128 152c0-13.3 10.7-24 24-24s24 10.7 24 24l0 87.8L278.9 135.2c9.3-9.5 24.5-9.6 33.9-.3z"]]
}, faManatSign = {
  prefix: "fad",
  iconName: "manat-sign",
  icon: [384, 512, [], "e1d5", ["M160 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 34.7c-5.2-.9-10.5-1.5-15.8-2c-2.7-.2-5.4-.4-8-.5c-1.3-.1-2.7-.1-4.1-.1s-2.7 0-4.1 0c-10.9 0-21.6 .9-32 2.7L160 64zm0 100c5.1-1.3 10.3-2.3 15.7-3c2.7-.3 5.4-.6 8.1-.8c1.4-.1 2.7-.2 4.1-.2s2.7-.1 4.1-.1c11 0 21.8 1.4 32 4l0 284c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-284z", "M0 288C0 182 86 96 192 96s192 86 192 192l0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-160c0-70.7-57.3-128-128-128s-128 57.3-128 128l0 160c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 288z"]]
}, faMoneyCheckPen = {
  prefix: "fad",
  iconName: "money-check-pen",
  icon: [640, 512, ["money-check-edit"], "f872", ["M0 128C0 92.7 28.7 64 64 64l448 0c35.3 0 64 28.7 64 64l0 64.6c-15.2 2-29.8 8.8-41.4 20.5L353.3 394.3c-8.2 8.2-14 18.5-16.8 29.7l-6 23.9L64 448c-35.3 0-64-28.7-64-64L0 128zm96 80c0 8.8 7.2 16 16 16l320 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-320 0c-8.8 0-16 7.2-16 16zm0 96c0 8.8 7.2 16 16 16l224 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-224 0c-8.8 0-16 7.2-16 16z", "M557.2 235.7l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4c-15.6-15.6-40.9-15.6-56.6 0zm-52 52L375.9 417c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L576.1 358.7l-71-71z"]]
}, faMoneyCheckEdit = faMoneyCheckPen, faNotEqual = {
  prefix: "fad",
  iconName: "not-equal",
  icon: [448, 512, [], "f53e", ["M16 176c0-17.7 14.3-32 32-32l212.2 0c-14.2 21.3-28.4 42.7-42.7 64L48 208c-17.7 0-32-14.3-32-32zm0 160c0-17.7 14.3-32 32-32l105.5 0c-14.2 21.3-28.4 42.7-42.7 64L48 368c-17.7 0-32-14.3-32-32zm171.8 32c14.2-21.3 28.4-42.7 42.7-64L400 304c17.7 0 32 14.3 32 32s-14.3 32-32 32l-212.2 0zM294.5 208c14.2-21.3 28.4-42.7 42.7-64l62.9 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-105.5 0z", "M369.8 37.4c14.7 9.8 18.7 29.7 8.9 44.4l-256 384c-9.8 14.7-29.7 18.7-44.4 8.9s-18.7-29.7-8.9-44.4l256-384c9.8-14.7 29.7-18.7 44.4-8.9z"]]
}, faBorderTopLeft = {
  prefix: "fad",
  iconName: "border-top-left",
  icon: [448, 512, ["border-style"], "f853", ["M96 448a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96-288a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M32 480c-17.7 0-32-14.3-32-32L0 112C0 67.8 35.8 32 80 32l336 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L80 96c-8.8 0-16 7.2-16 16l0 336c0 17.7-14.3 32-32 32z"]]
}, faBorderStyle = faBorderTopLeft, faMapLocationDot = {
  prefix: "fad",
  iconName: "map-location-dot",
  icon: [576, 512, ["map-marked-alt"], "f5a0", ["M0 209.6L0 480.4c0 17 17.1 28.6 32.9 22.3L160 451.8l0-251.4c-3.5-6.9-6.7-13.8-9.6-20.6c-5.6-13.2-10.4-27.4-12.8-41.5l-122.6 49C6 191 0 199.8 0 209.6zM192 255l0 194.4 192 54.9L384 255c-20.5 31.3-42.3 59.6-56.2 77c-20.5 25.6-59.1 25.6-79.6 0c-13.9-17.4-35.7-45.7-56.2-77zm224-54.6L416 503l144.9-58c9.1-3.6 15.1-12.5 15.1-22.3L576 152c0-17-17.1-28.6-32.9-22.3l-116 46.4c-.5 1.2-1 2.5-1.5 3.7c-2.9 6.8-6.1 13.7-9.6 20.6z", "M302.8 312C334.9 271.9 408 174.6 408 120C408 53.7 354.3 0 288 0S168 53.7 168 120c0 54.6 73.1 151.9 105.2 192c7.7 9.6 22 9.6 29.6 0zM288 72a40 40 0 1 1 0 80 40 40 0 1 1 0-80z"]]
}, faMapMarkedAlt = faMapLocationDot, faTilde = {
  prefix: "fad",
  iconName: "tilde",
  icon: [448, 512, [63135], "7e", ["M99.9 192C80.1 192 64 208.1 64 227.9L64 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-92.1C0 172.7 44.7 128 99.9 128c26.5 0 51.9 10.5 70.6 29.3L322.7 309.5c6.7 6.7 15.9 10.5 25.4 10.5c19.8 0 35.9-16.1 35.9-35.9l0-92.1c0-17.7 14.3-32 32-32s32 14.3 32 32l0 92.1c0 55.2-44.7 99.9-99.9 99.9c-26.5 0-51.9-10.5-70.6-29.3L125.3 202.5c-6.7-6.7-15.9-10.5-25.4-10.5z", ""]]
}, faJedi = {
  prefix: "fad",
  iconName: "jedi",
  icon: [576, 512, [], "f669", ["M200 336c0 3.8 2.7 7.1 6.4 7.8l37.6 7.5c2.2 .4 3.3 3 2 4.9l-21.2 31.9c-2.1 3.2-1.7 7.4 1 10.1s6.9 3.1 10.1 1l26.3-17.6c2.2-1.4 5.1 .2 5 2.8L265.1 446c7.4 1.3 15.1 2 22.9 2c1 0 1.9 0 2.9 0s1.9-.1 2.9-.1c1.9-.1 3.9-.2 5.8-.4c3.8-.3 7.6-.9 11.3-1.5l-2.1-61.5c-.1-2.6 2.8-4.2 5-2.8l26.3 17.6c3.2 2.1 7.4 1.7 10.1-1s3.1-6.9 1-10.1L330 356.3c-1.3-1.9-.2-4.5 2-4.9l37.5-7.5c3.7-.7 6.4-4 6.4-7.8s-2.7-7.1-6.4-7.8L332 320.6c-2.2-.4-3.3-3-2-4.9l21.2-31.9c2.1-3.2 1.7-7.4-1-10.1s-6.9-3.1-10.1-1l-29.5 19.7c-2.1 1.4-4.9 0-5-2.6L296.3 8c-.1-4.5-3.8-8-8.3-8s-8.1 3.5-8.3 8l-9.4 281.9c-.1 2.5-2.9 3.9-5 2.6l-29.5-19.7c-3.2-2.1-7.4-1.7-10.1 1s-3.1 6.9-1 10.1L246 315.7c1.3 1.9 .2 4.5-2 4.9l-37.6 7.5c-3.7 .7-6.4 4-6.4 7.8z", "M376.2 201.9c-7.5 5.8-8 17.9-1 24.4C400.3 249.6 416 283 416 320c0 70.7-57.3 128-128 128s-128-57.3-128-128c0-37 15.7-70.4 40.8-93.7c7-6.5 6.5-18.6-1-24.4C165.9 175.5 144 134.3 144 88c0-16.8 2.9-33 8.2-48c4.6-13-10.2-30-21.4-22C77.3 56 38.1 112.8 22.9 178.8c-.5 2.1 .2 4.3 1.7 5.9l28.4 28.4c4 4 1.2 10.9-4.5 10.9l-26 0c-3.4 0-6.2 2.6-6.3 6c-.1 3.3-.2 6.6-.2 10c0 17.5 1.7 34.7 4.8 51.3c.2 1.2 .8 2.4 1.7 3.3l46.5 46.5c4 4 1.2 10.9-4.5 10.9L50 352c-4.6 0-7.7 4.8-5.7 9C88.8 450.5 181.2 512 288 512s199.2-61.5 243.7-151c2.1-4.2-1-9-5.7-9l-14.6 0c-5.7 0-8.6-6.9-4.5-10.9l46.5-46.5c.9-.9 1.5-2 1.7-3.3c3.2-16.6 4.8-33.8 4.8-51.3c0-3.3-.1-6.7-.2-10c-.1-3.4-2.9-6-6.3-6l-26 0c-5.7 0-8.6-6.9-4.5-10.9l28.4-28.4c1.5-1.5 2.2-3.8 1.7-5.9C537.9 112.8 498.7 56 445.2 18c-11.3-8-26 8.9-21.4 22c5.3 15 8.2 31.2 8.2 48c0 46.3-21.9 87.5-55.8 113.9z"]]
}, faSquarePollVertical = {
  prefix: "fad",
  iconName: "square-poll-vertical",
  icon: [448, 512, ["poll"], "f681", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM96 256c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96zm96-96c0-17.7 14.3-32 32-32s32 14.3 32 32l0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-192zm96 160c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32z", "M192 160c0-17.7 14.3-32 32-32s32 14.3 32 32l0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-192zM96 256c0-17.7 14.3-32 32-32s32 14.3 32 32l0 96c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-96zm224 32c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32z"]]
}, faPoll = faSquarePollVertical, faArrowDownSquareTriangle = {
  prefix: "fad",
  iconName: "arrow-down-square-triangle",
  icon: [576, 512, ["sort-shapes-down-alt"], "f889", ["M304 448c0 5.3 1.3 10.7 4 15.5c5.6 10.2 16.4 16.5 28 16.5l160 0c11.6 0 22.3-6.3 28-16.5c2.7-4.8 4-10.2 4-15.5c0-5.9-1.6-11.8-4.9-17l-80-128c-5.8-9.4-16.1-15-27.1-15s-21.3 5.7-27.1 15l-80 128c-3.2 5.2-4.9 11.1-4.9 17zM320 80l0 96c0 26.5 21.5 48 48 48l96 0c26.5 0 48-21.5 48-48l0-96c0-26.5-21.5-48-48-48l-96 0c-26.5 0-48 21.5-48 48z", "M160 480c9 0 17.5-3.8 23.6-10.4l88-96c11.9-13 11.1-33.3-2-45.2s-33.3-11.1-45.2 2L192 365.7 192 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 301.7L95.6 330.4c-11.9-13-32.2-13.9-45.2-2s-13.9 32.2-2 45.2l88 96C142.5 476.2 151 480 160 480z"]]
}, faSortShapesDownAlt = faArrowDownSquareTriangle, faMugHot = {
  prefix: "fad",
  iconName: "mug-hot",
  icon: [512, 512, [9749], "f7b6", ["M64 24c0 38.9 23.4 59.4 39.1 73.1l1.1 1C120.5 112.3 128 119.9 128 136c0 13.3 10.7 24 24 24s24-10.7 24-24c0-38.9-23.4-59.4-39.1-73.1l-1.1-1C119.5 47.7 112 40.1 112 24c0-13.3-10.7-24-24-24S64 10.7 64 24zm112 0c0 38.9 23.4 59.4 39.1 73.1l1.1 1C232.5 112.3 240 119.9 240 136c0 13.3 10.7 24 24 24s24-10.7 24-24c0-38.9-23.4-59.4-39.1-73.1l-1.1-1C231.5 47.7 224 40.1 224 24c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M32 192c-17.7 0-32 14.3-32 32L0 416c0 53 43 96 96 96l192 0c53 0 96-43 96-96l16 0c61.9 0 112-50.1 112-112s-50.1-112-112-112l-48 0L32 192zm352 64l16 0c26.5 0 48 21.5 48 48s-21.5 48-48 48l-16 0 0-96z"]]
}, faDogLeashed = {
  prefix: "fad",
  iconName: "dog-leashed",
  icon: [576, 512, [129454], "f6d4", ["M96 16c0 4 1.5 7.9 4.4 11L256 190.4 256 384c0 8.8 7.2 16 16 16s16-7.2 16-16c0-2.2 0-4.4 0-6.6c0-56.4 0-112.8 0-169.3c42.7 18 85.3 35.9 128 53.9c.6 .3 1.2 .5 1.8 .8c8.1 3.4 17.5-.4 21-8.5s-.4-17.5-8.5-21c-3.2-1.4-6.5-2.7-9.7-4.1c-38.2-16.1-76.4-32.2-114.6-48.3l-24.6-10.3L123.6 5c-3.1-3.3-7.4-5-11.6-5c-4 0-7.9 1.5-11 4.4c-3.3 3.1-5 7.4-5 11.6z", "M256 192l-112 0-16 0-30 0c-14.7 0-27.5-10-31-24.2L63 152.2c-4.3-17.1-21.7-27.6-38.8-23.3S-3.3 150.6 1 167.8l3.9 15.5c7.8 31.2 30.4 55.6 59.2 66.5L64 480c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-115.2c24 12.3 51.2 19.2 80 19.2c5.4 0 10.7-.2 16-.7L256 192zm32 185.4c11.2-3.2 21.9-7.4 32-12.6L320 480c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-218L288 208.1l0 169.3zM420.5 229.2l6.2-37.2 21.3 0 16 0 32 0c44.2 0 80-35.8 80-80l0-24c0-13.3-10.7-24-24-24l-56 0L478.1 46.1c-9-9-21.2-14.1-33.9-14.1L392 32 375.1 9.5c-4.5-6-11.5-9.5-19-9.5c-11.6 0-21.5 8.4-23.4 19.8l-26.8 161 114.6 48.3zM432 80a16 16 0 1 1 32 0 16 16 0 1 1 -32 0z"]]
}, faCarBattery = {
  prefix: "fad",
  iconName: "car-battery",
  icon: [512, 512, ["battery-car"], "f5df", ["M0 160c0-35.3 28.7-64 64-64l16 0 128 0 96 0 128 0 16 0c35.3 0 64 28.7 64 64l0 224c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 160zm80 80c0 8.8 7.2 16 16 16l96 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-96 0c-8.8 0-16 7.2-16 16zm224 0c0 8.8 7.2 16 16 16l32 0 0 32c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-32 0 0-32c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 32-32 0c-8.8 0-16 7.2-16 16z", "M80 96c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32H80zm224 0c0-17.7 14.3-32 32-32h64c17.7 0 32 14.3 32 32H304z"]]
}, faBatteryCar = faCarBattery, faFaceDowncastSweat = {
  prefix: "fad",
  iconName: "face-downcast-sweat",
  icon: [512, 512, [], "e371", ["M0 256C0 397.4 114.6 512 256 512s256-114.6 256-256S397.4 0 256 0c-51.4 0-99.3 15.2-139.4 41.2c1.5 3.1 3 6.2 4.3 9.3c3.4 8 7.1 19 7.1 30.5c0 44.3-36.6 79-80 79c-9.6 0-18.8-1.7-27.4-4.8C7.3 186.1 0 220.2 0 256zm96 16c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm76.1 117.3C188.2 371.4 216.3 352 256 352s67.8 19.4 83.9 37.3c5.9 6.6 5.4 16.7-1.2 22.6s-16.7 5.4-22.6-1.2c-11.7-13-31.6-26.7-60.1-26.7s-48.4 13.7-60.1 26.7c-5.9 6.6-16 7.1-22.6 1.2s-7.1-16-1.2-22.6zM288 272c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16z", "M48 128C21.5 128 0 107 0 81C0 61 28.6 20.6 41.6 3.3c3.2-4.4 9.6-4.4 12.8 0C67.6 20.6 96 61 96 81c0 26-21.5 47-48 47zM96 272c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm192 0c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16z"]]
}, faMailboxFlagUp = {
  prefix: "fad",
  iconName: "mailbox-flag-up",
  icon: [576, 512, [], "e5bb", ["M144 64c79.5 0 144 64.5 144 144l0 176c0 35.3-28.7 64-64 64l288 0c35.3 0 64-28.7 64-64l0-176c0-56.5-32.6-105.5-80-129l0 17c0 8.8-7.2 16-16 16l-64 0 0 96c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-112 0-32L144 64z", "M400 224c-8.8 0-16-7.2-16-16l0-112 0-48c0-8.8 7.2-16 16-16l80 0c8.8 0 16 7.2 16 16l0 48c0 8.8-7.2 16-16 16l-64 0 0 96c0 8.8-7.2 16-16 16zM0 208C0 128.5 64.5 64 144 64s144 64.5 144 144l0 176c0 35.3-28.7 64-64 64L64 448c-35.3 0-64-28.7-64-64L0 208zm64 0c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L80 192c-8.8 0-16 7.2-16 16z"]]
}, faMemoCircleInfo = {
  prefix: "fad",
  iconName: "memo-circle-info",
  icon: [576, 512, [], "e49a", ["M0 64L0 448c0 35.3 28.7 64 64 64l256 0c3.3 0 6.6-.3 9.7-.7C285.1 479.3 256 427.1 256 368c0-80.6 54.1-148.5 128-169.4L384 64c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zm64 80c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 160c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l160 0c8.8 0 16 7.2 16 16s-7.2 16-16 16L80 256c-8.8 0-16-7.2-16-16zm0 96c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16z", "M288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm168-72a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm-40 56c-8.8 0-16 7.2-16 16s7.2 16 16 16c0 0 0 0 0 0l0 48s0 0 0 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 16 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l0-64c0-8.8-7.2-16-16-16l-16 0z"]]
}, faGift = {
  prefix: "fad",
  iconName: "gift",
  icon: [512, 512, [127873], "f06b", ["M0 160c0-17.7 14.3-32 32-32l41.6 0c7.3 14.2 18.3 26.2 31.8 34.7c6.8 4.2 14.1 7.5 21.9 9.8c3.9 1.1 7.9 2 12 2.6c2.1 .3 4.1 .5 6.2 .7c1 .1 2.1 .1 3.2 .2s2.1 .1 3.2 .1l64 0 8 0 0 80L32 256c-17.7 0-32-14.3-32-32l0-64zM32 288l192 0 0 224L80 512c-26.5 0-48-21.5-48-48l0-176zM288 176l72 0c34.2 0 63.8-19.5 78.4-48l41.6 0c17.7 0 32 14.3 32 32l0 64c0 17.7-14.3 32-32 32l-192 0 0-80zm0 112l192 0 0 176c0 26.5-21.5 48-48 48l-144 0 0-224z", "M190.5 68.8L225.3 128l-1.3 0-8 0-64 0c-22.1 0-40-17.9-40-40s17.9-40 40-40l2.2 0c14.9 0 28.8 7.9 36.3 20.8zM256 85.5l-24.1-41C215.7 16.9 186.1 0 154.2 0L152 0C103.4 0 64 39.4 64 88s39.4 88 88 88l64 0 8 0 0 80 64 0 0-80 72 0c48.6 0 88-39.4 88-88s-39.4-88-88-88l-2.2 0c-31.9 0-61.5 16.9-77.7 44.4L256 85.5zm65.5-16.7C329.1 55.9 342.9 48 357.8 48l2.2 0c22.1 0 40 17.9 40 40s-17.9 40-40 40l-73.3 0 34.8-59.2zM288 512l0-224-64 0 0 224 64 0z"]]
}, faDiceTwo = {
  prefix: "fad",
  iconName: "dice-two",
  icon: [448, 512, [9857], "f528", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm96 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM288 352a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M128 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zM320 384a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faVolume = {
  prefix: "fad",
  iconName: "volume",
  icon: [576, 512, [128265, "volume-medium"], "f6a8", ["M405.4 200.1c0-5.3 1.8-10.7 5.4-15.1c8.4-10.3 23.5-11.8 33.8-3.5C466.1 199.1 480 225.9 480 256s-13.9 56.9-35.4 74.5c-10.3 8.4-25.4 6.8-33.8-3.5s-6.8-25.4 3.5-33.8C425.1 284.4 432 271 432 256s-6.9-28.4-17.7-37.3c-5.8-4.7-8.9-11.7-8.9-18.6zm65.9-89.6c8.4-10.3 23.5-11.8 33.8-3.5c43.2 35.2 70.9 88.9 70.9 149s-27.7 113.8-70.9 149c-10.3 8.4-25.4 6.8-33.8-3.5s-6.8-25.4 3.5-33.8C507.3 341.3 528 301.1 528 256s-20.7-85.3-53.2-111.8c-10.3-8.4-11.8-23.5-3.5-33.8z", "M352 64c0-12.6-7.4-24-18.9-29.2s-25-3.1-34.4 5.3L163.8 160 96 160c-35.3 0-64 28.7-64 64l0 64c0 35.3 28.7 64 64 64l67.8 0L298.7 471.9c9.4 8.4 22.9 10.4 34.4 5.3S352 460.6 352 448l0-384z"]]
}, faVolumeMedium = faVolume, faTransporter5 = {
  prefix: "fad",
  iconName: "transporter-5",
  icon: [512, 512, [], "e2a6", ["M0 176c0 4.1 2.7 7.6 6.6 8.7L32 192l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L64 192l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L64 160l-7.3-25.4c-1.1-3.9-4.7-6.6-8.7-6.6s-7.6 2.7-8.7 6.6L32 160 6.6 167.3C2.7 168.4 0 171.9 0 176zm96 96c0 8.8 7.2 16 16 16l288 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-288 0c-8.8 0-16 7.2-16 16zm64-128c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zm0 256c0 8.8 7.2 16 16 16l160 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-160 0c-8.8 0-16 7.2-16 16zM208 16c0 8.8 7.2 16 16 16l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16L224 0c-8.8 0-16 7.2-16 16zM416 48c0 4.1 2.7 7.6 6.6 8.7L448 64l7.3 25.4c1.1 3.9 4.7 6.6 8.7 6.6s7.6-2.7 8.7-6.6L480 64l25.4-7.3c3.9-1.1 6.6-4.7 6.6-8.7s-2.7-7.6-6.6-8.7L480 32 472.7 6.6C471.6 2.7 468.1 0 464 0s-7.6 2.7-8.7 6.6L448 32l-25.4 7.3c-3.9 1.1-6.6 4.7-6.6 8.7z", "M96 480c0-17.7 14.3-32 32-32H384c17.7 0 32 14.3 32 32s-14.3 32-32 32H128c-17.7 0-32-14.3-32-32z"]]
}, faGaugeCircleBolt = {
  prefix: "fad",
  iconName: "gauge-circle-bolt",
  icon: [640, 512, [], "e496", ["M0 256C0 397.4 114.6 512 256 512c39.5 0 77-9 110.4-25C337.6 455.7 320 413.9 320 368c0-97.2 78.8-176 176-176c2.7 0 5.3 .1 8 .2C475.6 81.7 375.4 0 256 0C114.6 0 0 114.6 0 256zm128 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48-112a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm16 208c0-26.9 16.5-49.9 40-59.3L232 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 204.7c23.5 9.5 40 32.5 40 59.3c0 35.3-28.7 64-64 64s-64-28.7-64-64zM400 144a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M352 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm194.5-66.2c2.8-5 1.7-11.1-2.6-14.9s-10.6-4-15.1-.6l-96 72c-4.1 3.1-5.8 8.5-4.2 13.4s6.2 8.2 11.4 8.2l35.6 0-30.1 54.2c-2.8 5-1.7 11.1 2.6 14.9s10.6 4 15.1 .6l96-72c4.1-3.1 5.8-8.5 4.2-13.4s-6.2-8.2-11.4-8.2l-35.6 0 30.1-54.2z"]]
}, faCoinFront = {
  prefix: "fad",
  iconName: "coin-front",
  icon: [512, 512, [], "e3fc", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm448 0A192 192 0 1 1 64 256a192 192 0 1 1 384 0zM96 256a160 160 0 1 0 320 0A160 160 0 1 0 96 256zm136-72c0-13.3 10.7-24 24-24s24 10.7 24 24l0 144c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-144z", "M256 96a160 160 0 1 1 0 320 160 160 0 1 1 0-320zm0 352a192 192 0 1 0 0-384 192 192 0 1 0 0 384z"]]
}, faFileSlash = {
  prefix: "fad",
  iconName: "file-slash",
  icon: [640, 512, [], "e3a7", ["M128 64l0 11C256 175.4 384 275.7 512 376l0-216-128 0c-17.7 0-32-14.3-32-32L352 0 192 0c-35.3 0-64 28.7-64 64zm0 132.8L128 448c0 35.3 28.7 64 64 64l256 0c20.1 0 38.1-9.3 49.8-23.8L128 196.8zM384 0l0 128 128 0L384 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faMessageArrowUpRight = {
  prefix: "fad",
  iconName: "message-arrow-up-right",
  icon: [512, 512, [], "e1dd", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM160 280c0 6.1 2.3 12.3 7 17s10.8 7 17 7s12.3-2.3 17-7l87-87 0 54.1c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112c0-13.3-10.7-24-24-24l-112 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l54.1 0-87 87c-4.7 4.7-7 10.8-7 17z", "M176 152c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-54.1-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9l87-87L200 176c-13.3 0-24-10.7-24-24z"]]
}, faTreasureChest = {
  prefix: "fad",
  iconName: "treasure-chest",
  icon: [576, 512, [], "f723", ["M0 160l0 96 96 0L96 36C40.8 50.2 0 100.4 0 160zM0 288L0 432c0 26.5 21.5 48 48 48l48 0 0-192L0 288zM160 32l0 224 64 0 0-32c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 32 64 0 0-224L160 32zm0 256l0 192 256 0 0-192-64 0 0 32c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-32-64 0zM480 36l0 220 96 0 0-96c0-59.6-40.8-109.8-96-124zm0 252l0 192 48 0c26.5 0 48-21.5 48-48l0-144-96 0z", "M160 32l0 224-64 0L96 36c10.2-2.6 21-4 32-4l32 0zM416 256l0-224 32 0c11 0 21.8 1.4 32 4l0 220-64 0zM224 224c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 96c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-96zm64 0c-8.8 0-16 7.2-16 16l0 64c0 8.8 7.2 16 16 16s16-7.2 16-16l0-64c0-8.8-7.2-16-16-16zM160 480l-64 0 0-192 64 0 0 192zm256 0l0-192 64 0 0 192-64 0z"]]
}, faChessQueen = {
  prefix: "fad",
  iconName: "chess-queen",
  icon: [512, 512, [9819], "f445", ["M64 489.4C64 501.9 74.1 512 86.6 512l338.7 0c12.5 0 22.6-10.1 22.6-22.6c0-6-2.4-11.8-6.6-16L400 432l-.4 0L384 432l-38.4 0-179.2 0L128 432l-15.6 0-.4 0L70.6 473.4c-4.2 4.2-6.6 10-6.6 16z", "M312 56A56 56 0 1 0 200 56a56 56 0 1 0 112 0zM164.3 120c-15.3 0-27 10.8-30.2 23.8c-7 27.8-32.2 48.3-62.1 48.3c-10.8 0-20.9-2.7-29.8-7.3c-8.4-4.4-19-4.5-27.7 .9C2.1 193.3-2.4 209.2 4.3 222.2L112.4 432l15.6 0 38.4 0 179.2 0 38.4 0 15.6 0L507.7 222.2c6.7-13 2.2-28.9-10.2-36.5c-8.7-5.4-19.3-5.4-27.7-.9c-8.9 4.7-19 7.3-29.8 7.3c-29.9 0-55.1-20.5-62.1-48.3c-3.3-13-15-23.8-30.2-23.8c-12.3 0-22.6 7.2-27.7 17c-12 23.2-36.2 39-64 39s-52-15.8-64-39c-5.1-9.8-15.4-17-27.7-17zM256 224s0 0 0 0s0 0 0 0s0 0 0 0z"]]
}, faPaintbrushFine = {
  prefix: "fad",
  iconName: "paintbrush-fine",
  icon: [576, 512, ["paint-brush-alt", "paint-brush-fine", "paintbrush-alt"], "f5a9", ["M0 480c0 17.7 14.3 32 32 32l144 0c61.9 0 112-50.1 112-112c0-10-1.3-19.7-3.8-29c-26.4-26.5-52.7-52.8-79.2-79.2c-9.3-2.4-19-3.8-29-3.8c-61.9 0-112 50.1-112 112c0 3.9 .2 7.8 .6 11.6C66.4 429.1 54.4 448 36.8 448L32 448c-17.7 0-32 14.3-32 32z", "M559.6 95.6c21.9-21.9 21.9-57.3 0-79.2s-57.3-21.9-79.2 0L205.1 291.7l79.2 79.2L559.6 95.6z"]]
}, faPaintBrushAlt = faPaintbrushFine, faPaintBrushFine = faPaintbrushFine, faPaintbrushAlt = faPaintbrushFine, faGlasses = {
  prefix: "fad",
  iconName: "glasses",
  icon: [576, 512, [], "f530", ["M48 314.2c27.2-11.8 58.2-18.2 87.7-18.2c29.4 0 60.4 6.3 87.7 18l-3.2 57.5c-1.9 33.9-29.9 60.5-63.9 60.5L112 432c-35.3 0-64-28.7-64-64l0-16 0-37.8zm304.6-.2c27.3-11.7 58.3-18 87.7-18c29.5 0 60.5 6.4 87.7 18.2l0 53.8c0 35.3-28.7 64-64 64l-44.3 0c-34 0-62-26.5-63.9-60.5L352.6 314z", "M118.6 80c-11.5 0-21.4 7.9-24 19.1L57.1 259.8c25.6-7.8 52.6-11.8 78.6-11.8c40.1 0 82.2 9.6 118.5 27.3c5.8 2.9 10.4 7.3 13.5 12.7l40.6 0c3.1-5.4 7.7-9.8 13.5-12.7c36.2-17.8 78.4-27.3 118.5-27.3c26 0 53 4.1 78.6 11.8L481.4 99.1c-2.6-11.2-12.6-19.1-24-19.1c-3.1 0-6.2 .6-9.2 1.8L416.9 94.3c-12.3 4.9-26.3-1.1-31.2-13.4s1.1-26.3 13.4-31.2l31.3-12.5c8.6-3.4 17.7-5.2 27-5.2c33.8 0 63.1 23.3 70.8 56.2l43.9 188c1.7 7.3 2.9 14.7 3.5 22.2c.3 1.8 .5 3.7 .5 5.6l0 5.2c0 .5 0 1 0 1.5l0 41.3c0 .2 0 .4 0 .6l0 15.4c0 61.9-50.1 112-112 112l-44.3 0c-59.4 0-108.5-46.4-111.8-105.8L306.6 352l-37.2 0-1.2 22.2C264.9 433.6 215.8 480 156.3 480L112 480C50.1 480 0 429.9 0 368l0-16 0-41.3L0 304c0-1.9 .2-3.8 .5-5.7c.6-7.4 1.8-14.8 3.5-22.1l43.9-188C55.5 55.3 84.8 32 118.6 32c9.2 0 18.4 1.8 27 5.2l31.3 12.5c12.3 4.9 18.3 18.9 13.4 31.2s-18.9 18.3-31.2 13.4L127.8 81.8c-2.9-1.2-6-1.8-9.2-1.8zM48 352l0 16c0 35.3 28.7 64 64 64l44.3 0c34 0 62-26.5 63.9-60.5l3.2-57.5c-27.3-11.7-58.3-18-87.7-18c-29.5 0-60.5 6.4-87.7 18.2L48 352zm392.3-56c-29.4 0-60.4 6.3-87.7 18l3.2 57.5c1.9 33.9 29.9 60.5 63.9 60.5l44.3 0c35.3 0 64-28.7 64-64l0-53.8c-27.2-11.8-58.2-18.2-87.7-18.2z"]]
}, faHoodCloak = {
  prefix: "fad",
  iconName: "hood-cloak",
  icon: [576, 512, [], "f6ef", ["M160 320l0 192 256 0 0-192c0-70.7-57.3-128-128-128s-128 57.3-128 128z", "M432 0L288 0s0 0 0 0c-9.8 0-66 0-120.2 37.7C111.4 76.9 64 151.8 64 288c0 58.5-14.6 101.6-28.6 129.7c-7 14.1-14 24.5-19 31.1c-2.5 3.3-4.5 5.7-5.7 7.1c-.6 .7-1.1 1.2-1.3 1.4l-.2 .2c-9 9.1-11.7 22.8-6.8 34.7c5 12 16.6 19.8 29.6 19.8l128 0 0-192c0-70.7 57.3-128 128-128s128 57.3 128 128l0 192 128 0c12.9 0 24.6-7.8 29.6-19.8c4.9-11.9 2.2-25.6-6.8-34.7c0 0 0 0 0 0s0 0 0 0s0 0 0 0l-.1-.1c-.2-.2-.7-.7-1.3-1.4c-1.3-1.4-3.2-3.8-5.7-7.1c-5-6.6-11.9-17-19-31.1C526.6 389.6 512 346.5 512 288c0-103.1-46.5-172.8-95.8-217.2l32-29c7.3-6.7 9.8-17.2 6.2-26.4S441.9 0 432 0z"]]
}, faSquareQuote = {
  prefix: "fad",
  iconName: "square-quote",
  icon: [448, 512, [], "e329", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm96 96c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 24 0 24 0 39.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7l0-7.3-32 0c-17.7 0-32-14.3-32-32l0-48zm144 0c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 24 0 24 0 39.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7l0-7.3-32 0c-17.7 0-32-14.3-32-32l0-48z", "M96 192c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 24 0 24 0 39.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7l0-7.3-32 0c-17.7 0-32-14.3-32-32l0-48zm256 87.3c0 35.2-25.4 65.2-60.2 71l-7.9 1.3c-13.1 2.2-25.4-6.7-27.6-19.7s6.7-25.4 19.7-27.6l7.9-1.3c11.6-1.9 20.1-11.9 20.1-23.7l0-7.3-32 0c-17.7 0-32-14.3-32-32l0-48c0-17.7 14.3-32 32-32l48 0c17.7 0 32 14.3 32 32l0 24 0 24 0 39.3z"]]
}, faUpLeft = {
  prefix: "fad",
  iconName: "up-left",
  icon: [384, 512, [], "e2bd", ["M142.6 302.6L276.7 436.7c7.2 7.2 17.1 11.3 27.3 11.3s20.1-4.1 27.3-11.3l41.4-41.4c7.2-7.2 11.3-17.1 11.3-27.3s-4.1-20.1-11.3-27.3L238.6 206.6l-96 96z", "M48 80H288c12.9 0 24.6 7.8 29.6 19.8s2.2 25.7-6.9 34.9l-240 240c-9.2 9.2-22.9 11.9-34.9 6.9s-19.8-16.6-19.8-29.6V112c0-17.7 14.3-32 32-32z"]]
}, faBringFront = {
  prefix: "fad",
  iconName: "bring-front",
  icon: [640, 512, [], "f857", ["M0 64L0 192c0 35.3 28.7 64 64 64l96 0 0-64-96 0L64 64l128 0 0 40.6c9.4-5.4 20.3-8.6 32-8.6l32 0 0-32c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zM384 416l0 32c0 35.3 28.7 64 64 64l128 0c35.3 0 64-28.7 64-64l0-128c0-35.3-28.7-64-64-64l-96 0 0 64 96 0 0 128-128 0 0-40.6c-9.4 5.4-20.3 8.6-32 8.6l-32 0z", "M224 96c-35.3 0-64 28.7-64 64l0 192c0 35.3 28.7 64 64 64l192 0c35.3 0 64-28.7 64-64l0-192c0-35.3-28.7-64-64-64L224 96z"]]
}, faChessBoard = {
  prefix: "fad",
  iconName: "chess-board",
  icon: [448, 512, [], "f43c", ["M64 32C28.7 32 0 60.7 0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32zM384 96l0 320L64 416 64 96l320 0z", "M192 96l-64 0 0 64-64 0 0 64 64 0 0 64-64 0 0 64 64 0 0 64 64 0 0-64 64 0 0 64 64 0 0-64 64 0 0-64-64 0 0-64 64 0 0-64-64 0 0-64-64 0 0 64-64 0 0-64zm0 128l-64 0 0-64 64 0 0 64zm64 0l0 64 64 0 0 64-64 0 0-64-64 0 0 64-64 0 0-64 64 0 0-64 64 0zm0 0l0-64 64 0 0 64-64 0z"]]
}, faBurgerCheese = {
  prefix: "fad",
  iconName: "burger-cheese",
  icon: [512, 512, [127828, "cheeseburger"], "f7f1", ["M32 194.9c0-1.9 .2-3.7 .6-5.6C37.9 168.3 78.8 32 256 32s218.1 136.3 223.4 157.3c.5 1.9 .6 3.7 .6 5.6c0 16.1-13 29.1-29.1 29.1L61.1 224C45 224 32 211 32 194.9zM32 400c0-8.8 7.2-16 16-16l416 0c8.8 0 16 7.2 16 16l0 16c0 35.3-28.7 64-64 64L96 480c-35.3 0-64-28.7-64-64l0-16zm80-272a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm99.9 128c72 0 144.1 0 216.1 0c-7.9 0-15.6 2.3-22.1 6.7c-22.7 15.2-45.5 30.3-68.2 45.5c-10.7 7.2-24.8 7.2-35.5 0c-22.7-15.2-45.5-30.3-68.2-45.5c-6.5-4.4-14.2-6.7-22.1-6.7zM240 96a16 16 0 1 0 32 0 16 16 0 1 0 -32 0zm128 32a16 16 0 1 0 32 0 16 16 0 1 0 -32 0z", "M302.2 308.2L234 262.7c-6.5-4.4-14.2-6.7-22.1-6.7l-3.9 0-.1 0L64 256c-26.5 0-48 21.5-48 48s21.5 48 48 48l384 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-15.9 0-.1 0-3.9 0c-7.9 0-15.6 2.3-22.1 6.7l-68.2 45.5c-10.7 7.2-24.8 7.2-35.5 0z"]]
}, faCheeseburger = faBurgerCheese, faBuildingCircleCheck = {
  prefix: "fad",
  iconName: "building-circle-check",
  icon: [640, 512, [], "e4d2", ["M0 48C0 21.5 21.5 0 48 0L336 0c26.5 0 48 21.5 48 48l0 184.2c-39.1 32.3-64 81.1-64 135.8c0 49.5 20.4 94.2 53.3 126.2C364.5 505.1 351.1 512 336 512l-96 0 0-80c0-26.5-21.5-48-48-48s-48 21.5-48 48l0 80-96 0c-26.5 0-48-21.5-48-48L0 48zm64 64l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16L80 96c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 128l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M496 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm67.3-164.7l-72 72c-6.2 6.2-16.4 6.2-22.6 0l-40-40c-6.2-6.2-6.2-16.4 0-22.6s16.4-6.2 22.6 0L480 385.4l60.7-60.7c6.2-6.2 16.4-6.2 22.6 0s6.2 16.4 0 22.6z"]]
}, faRepeat1 = {
  prefix: "fad",
  iconName: "repeat-1",
  icon: [512, 512, [128258], "f365", ["M0 224c0 17.7 14.3 32 32 32s32-14.3 32-32c0-53 43-96 96-96l160 0 0 32c0 12.9 7.8 24.6 19.8 29.6s25.7 2.2 34.9-6.9l64-64c12.5-12.5 12.5-32.8 0-45.3l-64-64c-9.2-9.2-22.9-11.9-34.9-6.9S320 19.1 320 32l0 32L160 64C71.6 64 0 135.6 0 224zM73.4 393.4c-12.5 12.5-12.5 32.8 0 45.3l64 64c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6l0-32 160 0c88.4 0 160-71.6 160-160c0-17.7-14.3-32-32-32s-32 14.3-32 32c0 53-43 96-96 96l-160 0 0-32c0-12.9-7.8-24.6-19.8-29.6s-25.7-2.2-34.9 6.9l-64 64z", "M278 196.5c6.3 4.5 10 11.8 10 19.5l0 80c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c-10 0-19.4-6.4-22.8-16.4c-4.2-12.6 2.6-26.2 15.2-30.4l24-8c7.3-2.4 15.4-1.2 21.6 3.3z"]]
}, faArrowDownToLine = {
  prefix: "fad",
  iconName: "arrow-down-to-line",
  icon: [384, 512, ["arrow-to-bottom"], "f33d", ["M0 448c0-17.7 14.3-32 32-32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32z", "M169.4 342.6c12.5 12.5 32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L224 242.7 224 64c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 178.7L86.6 169.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128z"]]
}, faArrowToBottom = faArrowDownToLine, faGrid5 = {
  prefix: "fad",
  iconName: "grid-5",
  icon: [448, 512, [], "e199", ["M0 144l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM0 336l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM96 48l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 192l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 192l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-288l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 192l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zM288 48l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 192l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 192l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm96-288l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16zm0 192l0 32c0 8.8 7.2 16 16 16l32 0c8.8 0 16-7.2 16-16l0-32c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M0 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16L16 96C7.2 96 0 88.8 0 80L0 48zM0 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM16 416l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM96 144c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 176l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM192 48c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 176l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM192 432c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM304 128l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM288 336c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zM400 32l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16zM384 240c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32zm16 176l32 0c8.8 0 16 7.2 16 16l0 32c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-32c0-8.8 7.2-16 16-16z"]]
}, faSwapArrows = {
  prefix: "fad",
  iconName: "swap-arrows",
  icon: [640, 512, [], "e60a", ["M288 160l0 96 64 0 0-96c0-35.3 28.7-64 64-64s64 28.7 64 64l0 242.7-41.4-41.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l96 96c6.2 6.2 14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4l96-96c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6c-12.5-12.5-32.8-12.5-45.3 0L544 402.7 544 160c0-70.7-57.3-128-128-128s-128 57.3-128 128z", "M150.6 9.4c-12.5-12.5-32.8-12.5-45.3 0l-96 96c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L96 109.3 96 352c0 70.7 57.3 128 128 128s128-57.3 128-128l0-96-64 0 0 96c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-242.7 41.4 41.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-96-96z"]]
}, faRightLongToLine = {
  prefix: "fad",
  iconName: "right-long-to-line",
  icon: [640, 512, [], "e444", ["M576 96l0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M334.5 414c8.8 3.8 19 2 26-4.6l144-136c4.8-4.5 7.5-10.8 7.5-17.4s-2.7-12.9-7.5-17.4l-144-136c-7-6.6-17.2-8.4-26-4.6s-14.5 12.5-14.5 22l0 72L32 192c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l288 0 0 72c0 9.6 5.7 18.2 14.5 22z"]]
}, faPersonChalkboard = {
  prefix: "fad",
  iconName: "person-chalkboard",
  icon: [640, 512, [], "e53d", ["M32 288c0 10.9 5.5 21.5 15.5 27.5c15.1 9.1 34.8 4.2 43.9-10.9L120 256.9 120 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-128 16 0 0 128c0 17.7 14.3 32 32 32s32-14.3 32-32l0-288 56 0 64 0 16 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0-64 0-76.9 0-65.9 0c-33.7 0-64.9 17.7-82.3 46.6l-58.3 97C33.5 276.7 32 282.4 32 288zM144 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M384 128l0-64 192 0 0 192-192 0 0-64-64 0 0 80c0 26.5 21.5 48 48 48l224 0c26.5 0 48-21.5 48-48l0-224c0-26.5-21.5-48-48-48L368 0c-26.5 0-48 21.5-48 48l0 80 64 0z"]]
}, faMarsStrokeRight = {
  prefix: "fad",
  iconName: "mars-stroke-right",
  icon: [640, 512, [9897, "mars-stroke-h"], "f22b", ["M128 256a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M208 368a112 112 0 1 0 0-224 112 112 0 1 0 0 224zm174.4-88C370.7 365.8 297.1 432 208 432c-97.2 0-176-78.8-176-176s78.8-176 176-176c89.1 0 162.7 66.2 174.4 152l33.6 0 0-56c0-13.3 10.7-24 24-24s24 10.7 24 24l0 56 32 0 0-56c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2l80 80c9.4 9.4 9.4 24.6 0 33.9l-80 80c-6.9 6.9-17.2 8.9-26.2 5.2s-14.8-12.5-14.8-22.2l0-56-32 0 0 56c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-56-33.6 0z"]]
}, faMarsStrokeH = faMarsStrokeRight, faHandBackFist = {
  prefix: "fad",
  iconName: "hand-back-fist",
  icon: [448, 512, ["hand-rock"], "f255", ["M144 0C117.5 0 96 21.5 96 48l0 48 0 28.5L96 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-26.7-9 7.5C40.4 169 32 187 32 206L32 244c0 38 16.9 74 46.1 98.3L128 384l0 96c0 17.7 14.3 32 32 32l160 0c17.7 0 32-14.3 32-32l0-105.3c46.9-19 80-65 80-118.7l0-80 0-16 0-16c0-26.5-21.5-48-48-48c-12.4 0-23.6 4.7-32.1 12.3C350 83.5 329.3 64 304 64c-12.4 0-23.6 4.7-32.1 12.3C270 51.5 249.3 32 224 32c-12.4 0-23.6 4.7-32.1 12.3C190 19.5 169.3 0 144 0z", ""]]
}, faHandRock = faHandBackFist, faGridRound5 = {
  prefix: "fad",
  iconName: "grid-round-5",
  icon: [448, 512, [], "e5de", ["M0 160a32 32 0 1 0 64 0A32 32 0 1 0 0 160zM0 352a32 32 0 1 0 64 0A32 32 0 1 0 0 352zM96 64a32 32 0 1 0 64 0A32 32 0 1 0 96 64zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96-288a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zM288 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96-288a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm0 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M64 64A32 32 0 1 1 0 64a32 32 0 1 1 64 0zm0 192A32 32 0 1 1 0 256a32 32 0 1 1 64 0zM32 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM160 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM128 384a32 32 0 1 1 0-64 32 32 0 1 1 0 64zM256 64a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM224 288a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64-256a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 96a32 32 0 1 1 0-64 32 32 0 1 1 0 64zm32 160a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM416 480a32 32 0 1 1 0-64 32 32 0 1 1 0 64z"]]
}, faTally = {
  prefix: "fad",
  iconName: "tally",
  icon: [640, 512, ["tally-5"], "f69c", ["M96 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 211.6L96 296.9 96 64zm0 300.4c21.3-7.1 42.7-14.2 64-21.3L160 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-83.6zM224 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 168.9-64 21.3L224 64zm0 257.7c21.3-7.1 42.7-14.2 64-21.3L288 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-126.3zM352 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 126.3-64 21.3L352 64zm0 215.1c21.3-7.1 42.7-14.2 64-21.3L416 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-168.9zM480 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 83.6-64 21.3L480 64zm0 172.4c21.3-7.1 42.7-14.2 64-21.3L544 448c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-211.6z", "M638.4 149.9c5.6 16.8-3.5 34.9-20.2 40.5l-576 192c-16.8 5.6-34.9-3.5-40.5-20.2s3.5-34.9 20.2-40.5l576-192c16.8-5.6 34.9 3.5 40.5 20.2z"]]
}, faTally5 = faTally, faSquareCaretUp = {
  prefix: "fad",
  iconName: "square-caret-up",
  icon: [448, 512, ["caret-square-up"], "f151", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM96 296c0-5.9 2.2-11.8 6.4-16.3l104-112c4.5-4.9 10.9-7.7 17.6-7.7s13 2.8 17.6 7.7l104 112c4.2 4.5 6.4 10.4 6.4 16.3c0 3.2-.7 6.5-2 9.6c-3.8 8.7-12.5 14.4-22 14.4l-208 0c-9.5 0-18.2-5.7-22-14.4c-1.3-3.1-2-6.3-2-9.6z", "M241.6 167.7c-4.5-4.9-10.9-7.7-17.6-7.7s-13 2.8-17.6 7.7l-104 112c-6.5 7-8.2 17.2-4.4 25.9s12.5 14.4 22 14.4l208 0c9.5 0 18.2-5.7 22-14.4s2.1-18.9-4.4-25.9l-104-112z"]]
}, faCaretSquareUp = faSquareCaretUp, faCloudShowersWater = {
  prefix: "fad",
  iconName: "cloud-showers-water",
  icon: [576, 512, [], "e4e4", ["M.8 487.3c4 17.2 21.2 27.9 38.4 23.9c24.5-5.7 44.9-16.5 58.2-25C126.5 501.7 159 512 192 512c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9c.6-2.4 .8-4.9 .8-7.3c0-14.5-10-27.7-24.7-31.1c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.4-27.3-10.1-39.2-1.7C439.4 437.2 410.9 448 384 448c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 437.4 219.5 448 192 448c-26.9 0-55.3-10.8-77.4-26.1c-12-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4zM51.4 347.7c-6.8 11.4-3.1 26.1 8.2 32.9s26.1 3.1 32.9-8.2l48-80c6.8-11.4 3.1-26.1-8.2-32.9c-3.9-2.3-8.1-3.4-12.3-3.4c-8.2 0-16.1 4.2-20.6 11.7l-48 80zm112 0c-6.8 11.4-3.1 26.1 8.2 32.9s26.1 3.1 32.9-8.2l48-80c6.8-11.4 3.1-26.1-8.2-32.9c-3.9-2.3-8.1-3.4-12.3-3.4c-8.2 0-16.1 4.2-20.6 11.7l-48 80zm112 0c-6.8 11.4-3.1 26.1 8.2 32.9s26.1 3.1 32.9-8.2l48-80c6.8-11.4 3.1-26.1-8.2-32.9c-3.9-2.3-8.1-3.4-12.3-3.4c-8.2 0-16.1 4.2-20.6 11.7l-48 80zm112 0c-6.8 11.4-3.1 26.1 8.2 32.9s26.1 3.1 32.9-8.2l48-80c6.8-11.4 3.1-26.1-8.2-32.9c-3.9-2.3-8.1-3.4-12.3-3.4c-8.2 0-16.1 4.2-20.6 11.7l-48 80z", "M311.2 55.7C295.9 22.8 262.6 0 224 0c-53 0-96 43-96 96c-35.3 0-64 28.7-64 64s28.7 64 64 64l320 0c35.3 0 64-28.7 64-64s-28.7-64-64-64l-1.6 0C439 59.5 406.7 32 368 32c-22.2 0-42.3 9.1-56.8 23.7z"]]
}, faChartBar = {
  prefix: "fad",
  iconName: "chart-bar",
  icon: [512, 512, ["bar-chart"], "f080", ["M0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64c0-17.7-14.3-32-32-32S0 46.3 0 64z", "M160 96c-17.7 0-32 14.3-32 32s14.3 32 32 32l192 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L160 96zm0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-128 0zm0 96c-17.7 0-32 14.3-32 32s14.3 32 32 32l256 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-256 0z"]]
}, faBarChart = faChartBar, faHandsBubbles = {
  prefix: "fad",
  iconName: "hands-bubbles",
  icon: [576, 512, ["hands-wash"], "e05e", ["M32 160l.1 72.6c.1 52.2 24 101 64 133.1c-.1-1.9-.1-3.8-.1-5.7l0-8c0-71.8 37-138.6 97.9-176.7l60.2-37.6c8.6-5.4 17.9-8.4 27.3-9.4l45.9-79.5c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8L218.3 141.7c-3.3 5.7-10.7 7.7-16.4 4.4s-7.7-10.7-4.4-16.4l51.5-89.1c6.6-11.5 2.7-26.2-8.8-32.8S214 5 207.4 16.5L149.9 116c-18 31.1-35.9 62.2-53.9 93.3L96 160c0-17.7-14.4-32-32-32s-32 14.4-32 32zM64 464a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zM307.5 131c13.9 4.5 26.4 13.7 34.7 27c.9 1.4 1.7 2.9 2.5 4.4l28.9-50c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8L307.5 131zm39.8 85l4.7 0 13.3 0c10.6 0 21.2 0 31.8 0l23-39.8c6.6-11.5 2.7-26.2-8.8-32.8s-26.2-2.7-32.8 8.8l-26.8 46.4c-.6 6-2.1 11.8-4.3 17.4zM384 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 128a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M315.1 175c-9.4-15-29.1-19.5-44.1-10.2l-60.2 37.6C159.3 234.7 128 291.2 128 352l0 8c0 8.9 .8 17.6 2.2 26.1c35.4 8.2 61.8 40 61.8 77.9c0 6.3-.7 12.5-2.1 18.4C215.1 501 246.3 512 280 512l176 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-92 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l124 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-124 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l156 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-156 0c-6.6 0-12-5.4-12-12s5.4-12 12-12l124 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-136 0s0 0 0 0s0 0 0 0l-93.2 0L305 219.1c15-9.4 19.5-29.1 10.2-44.1z"]]
}, faHandsWash = faHandsBubbles, faLessThanEqual = {
  prefix: "fad",
  iconName: "less-than-equal",
  icon: [448, 512, [], "f537", ["M32 192c0 13.1 8 24.9 20.1 29.7l320 128c16.4 6.6 35-1.4 41.6-17.8c1.6-3.9 2.3-7.9 2.3-11.9c0-12.7-7.6-24.7-20.1-29.7L150.2 192 395.9 93.7c12.5-5 20.1-17 20.1-29.7c0-4-.7-8-2.3-11.9c-6.6-16.4-25.2-24.4-41.6-17.8l-320 128C40 167.1 32 178.9 32 192z", "M0 448c0-17.7 14.3-32 32-32l384 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-17.7 0-32-14.3-32-32z"]]
}, faTrain = {
  prefix: "fad",
  iconName: "train",
  icon: [448, 512, [128646], "f238", ["M35.1 492.9C28.1 499.9 33.1 512 43 512l39.7 0c8.5 0 16.6-3.4 22.6-9.4L160 448c-21.3 0-42.7 0-64 0c-2.6 0-5.1-.1-7.5-.3s-4.9-.5-7.3-.9l-46 46zm29-400.2c-.1 .5-.1 1.1-.1 1.6s0 1.1 0 1.6c0 32 0 64 0 96c0 .6 0 1.1 0 1.7s.1 1.1 .1 1.6c.1 1.1 .3 2.1 .5 3.2c.4 2.1 1.1 4.1 1.9 6c1.6 3.8 4 7.3 6.9 10.2c5.8 5.8 13.8 9.4 22.6 9.4l256 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L96 64c-8.8 0-16.8 3.6-22.6 9.4c-2.9 2.9-5.2 6.3-6.9 10.2c-.8 1.9-1.4 3.9-1.9 6c-.2 1-.4 2.1-.5 3.2zM288 448l54.6 54.6c6 6 14.1 9.4 22.6 9.4l39.7 0c6.8 0 11.2-5.5 11.2-11.3c0-2.8-1-5.6-3.3-7.8l-46-46c-4.8 .8-9.8 1.1-14.9 1.1c-21.3 0-42.7 0-64 0z", "M0 96C0 43 43 0 96 0L352 0c53 0 96 43 96 96l0 256c0 53-43 96-96 96L96 448c-53 0-96-43-96-96L0 96zm64 0l0 96c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L96 64C78.3 64 64 78.3 64 96zM224 384a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]]
}, faUpFromDottedLine = {
  prefix: "fad",
  iconName: "up-from-dotted-line",
  icon: [448, 512, [], "e456", ["M0 448a32 32 0 1 0 64 0A32 32 0 1 0 0 448zm96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm96 0a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M196.7 43.3L73.9 166.1c-6.4 6.4-9.9 15-9.9 24C64 208.8 79.2 224 97.9 224l62.1 0 0 128c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-128 62.1 0c18.7 0 33.9-15.2 33.9-33.9c0-9-3.6-17.6-9.9-24L251.3 43.3C244.1 36.1 234.2 32 224 32s-20.1 4.1-27.3 11.3z"]]
}, faEyeLowVision = {
  prefix: "fad",
  iconName: "eye-low-vision",
  icon: [640, 512, ["low-vision"], "f2a8", ["M150.7 92.8l72.4 56.7C248.6 126.2 282.7 112 320 112c79.5 0 144 64.5 144 144c0 24.9-6.3 48.3-17.4 68.7c26.4 20.7 52.7 41.3 79.1 62c39.6-40.6 66.4-86.1 79.9-118.4c1.6-3.9 2.5-8.1 2.5-12.3s-.8-8.4-2.5-12.3c-14.9-35.7-46.2-87.7-93-131.1C465.5 68.8 400.8 32 320 32c-68.2 0-125 26.3-169.3 60.8zm161 67.6c5.3 9.3 8.4 20.1 8.4 31.6c0 10.2-2.4 19.8-6.6 28.3c31.5 24.7 63 49.4 94.6 74.1c5.2-11.8 8-24.8 8-38.5c0-53-43-96-96-96c-2.8 0-5.6 .1-8.4 .4z", "M38.8 5.1C28.4-3.1 13.3-1.2 5.1 9.2S-1.2 34.7 9.2 42.9l592 464c10.4 8.2 25.5 6.3 33.7-4.1s6.3-25.5-4.1-33.7L38.8 5.1zM33.1 247.8c-1.8 6.8-1.3 14 1.4 20.5c14.9 35.7 46.2 87.7 93 131.1C174.5 443.2 239.2 480 320 480c3.1 0 6.1-.1 9.2-.2L33.1 247.8zM393.6 469.4c18.7-5.5 36.2-13 52.6-21.8L83.1 161.5c-11 14.4-20.5 28.7-28.4 42.2l339 265.7z"]]
}, faLowVision = faEyeLowVision, faTrafficLightGo = {
  prefix: "fad",
  iconName: "traffic-light-go",
  icon: [320, 512, [], "f638", ["M112 368a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M64 0C28.7 0 0 28.7 0 64L0 352c0 88.4 71.6 160 160 160s160-71.6 160-160l0-288c0-35.3-28.7-64-64-64L64 0zm96 416a48 48 0 1 1 0-96 48 48 0 1 1 0 96zm48-176a48 48 0 1 1 -96 0 48 48 0 1 1 96 0zm-48-80a48 48 0 1 1 0-96 48 48 0 1 1 0 96z"]]
}, faFaceExhaling = {
  prefix: "fad",
  iconName: "face-exhaling",
  icon: [576, 512, [], "e480", ["M0 256C0 397.4 114.6 512 256 512c55.8 0 107.4-17.9 149.5-48.2c-10.5-9.3-17.9-22.1-20.5-36.5l-42.2-12.7C329.3 410.6 320 398.1 320 384s9.3-26.6 22.8-30.6L385 340.7c5.3-30 31.5-52.7 63-52.7c.7 0 1.4 0 2.1 0c13.2-14.7 32.3-24 53.7-24c2.7 0 5.4 .2 8.1 .5c.1-2.8 .1-5.6 .1-8.5C512 114.6 397.4 0 256 0S0 114.6 0 256zm99.2 1.6c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0zM296 384a40 40 0 1 1 -80 0 40 40 0 1 1 80 0zm-4.8-126.4c-5.3-7.1-3.9-17.1 3.2-22.4s17.1-3.9 22.4 3.2c17.6 23.5 52.8 23.5 70.4 0c5.3-7.1 15.3-8.5 22.4-3.2s8.5 15.3 3.2 22.4c-30.4 40.5-91.2 40.5-121.6 0z", "M543.5 336c0 .8 0 1.7-.1 2.5c19 6.4 32.6 24.4 32.6 45.5s-13.6 39.1-32.6 45.5c.1 .8 .1 1.7 .1 2.5c0 22.1-17.9 40-39.9 40c-14.2 0-26.6-7.4-33.7-18.5c-4.4 1.6-9.1 2.5-14 2.5c-22.1 0-39.9-17.9-39.9-40c0-2.7 .3-5.3 .8-7.8l-56.9-14.2c-4.6-1.1-7.8-5.2-7.8-9.9s3.2-8.8 7.8-9.9L415.9 360c0-22.1 17.9-40 39.9-40c3.6 0 7.2 .5 10.5 1.4c5.8-14.9 20.3-25.4 37.2-25.4c22.1 0 39.9 17.9 39.9 40z"]]
}, faSensorFire = {
  prefix: "fad",
  iconName: "sensor-fire",
  icon: [640, 512, [], "e02a", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 32.2c-12.6-1.2-25.5 2.7-35.5 11.7c-35.4 31.6-65.6 67.7-87.3 102.8C304.3 276.5 288 314.9 288 350.1c0 49.3 18.6 95.2 49.6 129.9L64 480c-35.3 0-64-28.7-64-64L0 96zm64 24l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144c0-13.3-10.7-24-24-24s-24 10.7-24 24zm96 0l0 144c0 13.3 10.7 24 24 24s24-10.7 24-24l0-144c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M433.8 163.6c5.6-5 14.2-5 19.8 0c19.7 17.8 38.2 37 55.5 57.7c7.9-9.9 16.8-20.7 26.5-29.5c5.6-5.1 14.4-5.1 20 0c24.7 22.7 45.6 52.7 60.4 81.1c14.5 28 24.2 56.7 24.2 76.9c0 87.8-71.3 161.9-160 161.9c-89.7 0-160-74.2-160-161.9c0-26.4 12.7-58.6 32.4-90.6c20-32.4 48.1-66.1 81.4-95.8zM481 447.9c18 0 34-5 49-15c30-21 38-63 20-96c-2-4-4-8-7-12l-36 42s-58-74-62-79c-30 37-45 58-45 82c0 49 36 78 81 78z"]]
}, faUserUnlock = {
  prefix: "fad",
  iconName: "user-unlock",
  icon: [640, 512, [], "e058", ["M0 482.3C0 383.8 79.8 304 178.3 304l91.4 0c43.6 0 83.6 15.7 114.6 41.7c-.2 2.1-.3 4.2-.3 6.3l0 128c0 11.7 3.1 22.6 8.6 32L29.7 512C13.3 512 0 498.7 0 482.3zM352 128A128 128 0 1 1 96 128a128 128 0 1 1 256 0z", "M528 240c-17.7 0-32 14.3-32 32l0 48 16 0 48 0 48 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l-48 0c0-17.7-14.3-32-32-32z"]]
}, faHexagonDivide = {
  prefix: "fad",
  iconName: "hexagon-divide",
  icon: [512, 512, [], "e1ad", ["M7.4 256c0 12.4 3.2 24.9 9.6 36l88.3 152.9c12.9 22.3 36.6 36 62.4 36l176.6 0c25.7 0 49.5-13.7 62.4-36L494.9 292c6.4-11.1 9.6-23.6 9.6-36s-3.2-24.9-9.6-36L406.6 67.1c-12.9-22.3-36.6-36-62.4-36l-176.6 0c-25.7 0-49.5 13.7-62.4 36L17.1 220c-6.4 11.1-9.6 23.6-9.6 36zM144 256c0-13.3 10.7-24 24-24c58.7 0 117.3 0 176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24c-58.7 0-117.3 0-176 0c-13.3-.1-24-10.8-24-24zm144-96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm0 192a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M224 160a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zm-80 96c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zm112 64a32 32 0 1 1 0 64 32 32 0 1 1 0-64z"]]
}, fa00 = {
  prefix: "fad",
  iconName: "00",
  icon: [640, 512, [], "e467", ["M352 176c0-79.5 64.5-144 144-144s144 64.5 144 144l0 160c0 79.5-64.5 144-144 144s-144-64.5-144-144l0-160zm64 0l0 160c0 44.2 35.8 80 80 80s80-35.8 80-80l0-160c0-44.2-35.8-80-80-80s-80 35.8-80 80z", "M0 176C0 96.5 64.5 32 144 32s144 64.5 144 144l0 160c0 79.5-64.5 144-144 144S0 415.5 0 336L0 176zM144 96c-44.2 0-80 35.8-80 80l0 160c0 44.2 35.8 80 80 80s80-35.8 80-80l0-160c0-44.2-35.8-80-80-80z"]]
}, faCrow = {
  prefix: "fad",
  iconName: "crow",
  icon: [640, 512, [], "f520", ["M259.2 384l51.9 0 39.1 94.9c5 12.3-.8 26.3-13.1 31.3c-3 1.2-6.1 1.8-9.1 1.8c-9.4 0-18.4-5.6-22.2-14.9L259.2 384zm96 0c16.9-.3 33.4-2.8 49-7.1l42 102c5 12.3-.8 26.3-13.1 31.3c-3 1.2-6.1 1.8-9.1 1.8c-9.4 0-18.4-5.6-22.2-14.9L355.2 384zM523.9 32L574 32c29.4 0 55 20 62.1 48.5L640 96l-96 24 0-32c0-21.3-7.5-40.8-20.1-56z", "M456 0c-48.6 0-88 39.4-88 88l0 29.2L12.5 390.6c-14 10.8-16.6 30.9-5.9 44.9s30.9 16.6 44.9 5.9L126.1 384 352 384c106 0 192-86 192-192l0-64 0-40c0-48.6-39.4-88-88-88zm0 64a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faCassetteBetamax = {
  prefix: "fad",
  iconName: "cassette-betamax",
  icon: [576, 512, ["betamax"], "f8a4", ["M0 160l576 0 0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 160zM64 320a96 96 0 1 0 192 0A96 96 0 1 0 64 320zm256-64l0 128c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32l0-128c0-17.7-14.3-32-32-32l-128 0c-17.7 0-32 14.3-32 32z", "M64 32C28.7 32 0 60.7 0 96l0 64 576 0 0-64c0-35.3-28.7-64-64-64L64 32zM192 320a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm-32-96a96 96 0 1 0 0 192 96 96 0 1 0 0-192z"]]
}, faBetamax = faCassetteBetamax, faSailboat = {
  prefix: "fad",
  iconName: "sailboat",
  icon: [576, 512, [], "e445", ["M66.1 328.1l128-224c3.6-6.3 11-9.4 18-7.5s11.9 8.2 11.9 15.5l0 224c0 8.8-7.2 16-16 16L80 352c-5.7 0-11-3-13.8-8s-2.9-11-.1-16zM256 16c0-7 4.5-13.2 11.2-15.3s13.9 .4 17.9 6.1l224 320c1.9 2.7 2.9 6 2.9 9.2c0 2.5-.6 5.1-1.8 7.4c-2.8 5.3-8.2 8.6-14.2 8.6l-224 0c-8.8 0-16-7.2-16-16l0-320z", "M5.7 404.3C2.8 394.1 10.5 384 21.1 384H554.9c10.6 0 18.3 10.1 15.4 20.3l-4 14.3C550.7 473.9 500.4 512 443 512H133C75.6 512 25.3 473.9 9.7 418.7l-4-14.3z"]]
}, faWindowRestore = {
  prefix: "fad",
  iconName: "window-restore",
  icon: [512, 512, [], "f2d2", ["M128 80l0 16 64 0 0-16c0-8.8 7.2-16 16-16l224 0c8.8 0 16 7.2 16 16l0 224c0 8.8-7.2 16-16 16l-16 0 0 64 16 0c44.2 0 80-35.8 80-80l0-224c0-44.2-35.8-80-80-80L208 0c-44.2 0-80 35.8-80 80z", "M64 128c-35.3 0-64 28.7-64 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256c0-35.3-28.7-64-64-64L64 128zm32 64l192 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L96 256c-17.7 0-32-14.3-32-32s14.3-32 32-32z"]]
}, faNfcMagnifyingGlass = {
  prefix: "fad",
  iconName: "nfc-magnifying-glass",
  icon: [640, 512, [], "e1f9", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c8.7 0 17-1.7 24.6-4.9c-35.9-9.1-67-30.3-88.6-59.1l-208 0c-26.5 0-48-21.5-48-48l0-224c0-26.5 21.5-48 48-48l32 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-32 0c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16l189.3 0c-8.6-19.6-13.3-41.2-13.3-64c0-52.3 25.1-98.8 64-128l0-48c0-8.8-7.2-16-16-16l-80 0c-8.8 0-16 7.2-16 16l0 66.7c18.6 6.6 32 24.4 32 45.3c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3l0-66.7c0-26.5 21.5-48 48-48l80 0c26.5 0 48 21.5 48 48l0 29.3c19.6-8.6 41.2-13.3 64-13.3l0-64c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96z", "M528 320.1a80 80 0 1 0 -160 0 80 80 0 1 0 160 0zM519.9 426c-20.5 14-45.3 22.1-71.9 22.1c-70.7 0-128-57.3-128-128s57.3-128 128-128s128 57.3 128 128c0 26.7-8.2 51.4-22.1 71.9L633 471.2c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0L519.9 426z"]]
}, faFileBinary = {
  prefix: "fad",
  iconName: "file-binary",
  icon: [384, 512, [], "e175", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM64 304l0 64c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-32 0c-26.5 0-48 21.5-48 48zm32 0c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zm128-32c0 8.8 7.2 16 16 16l16 0 0 96-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-112c0-8.8-7.2-16-16-16l-32 0c-8.8 0-16 7.2-16 16z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM112 256c-26.5 0-48 21.5-48 48l0 64c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-64c0-26.5-21.5-48-48-48l-32 0zM96 304c0-8.8 7.2-16 16-16l32 0c8.8 0 16 7.2 16 16l0 64c0 8.8-7.2 16-16 16l-32 0c-8.8 0-16-7.2-16-16l0-64zm144-48c-8.8 0-16 7.2-16 16s7.2 16 16 16l16 0 0 96-16 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l32 0 32 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-16 0 0-112c0-8.8-7.2-16-16-16l-32 0z"]]
}, faCircleV = {
  prefix: "fad",
  iconName: "circle-v",
  icon: [512, 512, [], "e12a", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm130.5-77.3c-5.9-11.9-1.1-26.3 10.7-32.2s26.3-1.1 32.2 10.7c27.5 55 55 110 82.5 165.1c27.5-55 55-110 82.5-165.1c5.9-11.9 20.3-16.7 32.2-10.7c8.4 4.2 13.3 12.7 13.3 21.5c0 3.6-.8 7.3-2.5 10.7c-34.7 69.3-69.3 138.7-104 208c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3c-34.7-69.3-69.3-138.7-104-208z", "M141.3 146.5c11.9-5.9 26.3-1.1 32.2 10.7L256 322.3l82.5-165.1c5.9-11.9 20.3-16.7 32.2-10.7s16.7 20.3 10.7 32.2l-104 208c-4.1 8.1-12.4 13.3-21.5 13.3s-17.4-5.1-21.5-13.3l-104-208c-5.9-11.9-1.1-26.3 10.7-32.2z"]]
}, faSquarePlus = {
  prefix: "fad",
  iconName: "square-plus",
  icon: [448, 512, [61846, "plus-square"], "f0fe", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM112 256c0-13.3 10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64-64 0c-13.3 0-24-10.7-24-24z", "M200 280l0 64c0 13.3 10.7 24 24 24s24-10.7 24-24l0-64 64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0 0-64c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 64-64 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0z"]]
}, faPlusSquare = faSquarePlus, faBowlScoops = {
  prefix: "fad",
  iconName: "bowl-scoops",
  icon: [448, 512, [127813], "e3df", ["M0 208c0 17.2 3.9 33.5 10.8 48l5.2 0 184.2 0c-5.3-15-8.2-31.2-8.2-48c0-22 4.9-42.8 13.7-61.4c-19.8-30.2-53.8-50.2-92.6-50.6L112 96C50.1 96 0 146.1 0 208zM122.6 64.4c40.9 3 77.1 23 101.4 53.1c24.3-30.1 60.5-50.1 101.4-53.1C307.5 26.3 268.8 0 224 0s-83.5 26.3-101.4 64.4zM224 208c0 17.2 3.9 33.5 10.8 48L432 256l5.2 0c6.9-14.5 10.8-30.8 10.8-48c0-61.9-50.1-112-112-112l-1.1 0c-38.7 .4-72.7 20.4-92.6 50.6C230.7 164.2 224 185.3 224 208z", "M4 261.4c3-3.4 7.4-5.4 12-5.4l416 0c4.6 0 9 2 12 5.4s4.5 8 3.9 12.6l-2 15.9C436.9 361.9 375.6 416 303 416l-40.4 0 68.7 68.7c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9l-192 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4L185.4 416 145 416C72.4 416 11.1 361.9 2.1 289.9L.1 274c-.6-4.6 .8-9.1 3.9-12.6z"]]
}, faMistletoe = {
  prefix: "fad",
  iconName: "mistletoe",
  icon: [576, 512, [], "f7b4", ["M0 341c0 41.4 33.6 75 75 75c50.5 0 94.3-33.5 108.1-81.2c-4.5-6.5-7.1-14.3-7.1-22.8c0-.9 0-1.8 .1-2.6s.1-1.7 .3-2.6c.2-1.7 .6-3.4 1-5c.9-3.3 2.1-6.4 3.7-9.3c3.2-5.8 7.9-10.7 13.4-14.2l5.4-28.2L264 185.9l0 72.4c14.7 13.2 24 32.3 24 53.7c0 39.8-32.2 72-72 72c-7.2 0-14.2-1.1-20.8-3c-2.1 8.4-3.2 17.1-3.2 25.9l0 9.1c0 53 43 96 96 96s96-43 96-96l0-9.1c0-25.1-9-49.4-25.3-68.4L312 284l0-98.1L376.1 250l14.4 74.7C400.6 377.7 447 416 501 416c41.4 0 75-33.6 75-75c0-54-38.3-100.3-91.3-110.5L410 216.1l-98-98L312 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 94.1-98 98L91.3 230.4C38.3 240.6 0 287 0 341z", "M376 112a40 40 0 1 0 0-80 40 40 0 1 0 0 80zM216 352a40 40 0 1 0 0-80 40 40 0 1 0 0 80z"]]
}, faCustard = {
  prefix: "fad",
  iconName: "custard",
  icon: [576, 512, [127854], "e403", ["M64.2 350.9L512 352 476.7 193.3C453.9 184.9 424 176 400 176c-22.7 0-39.4 8-56 16s-33.3 16-56 16s-39.4-8-56-16s-33.3-16-56-16c-24 0-53.9 8.9-76.7 17.3c-11.7 52.5-23.3 105-35 157.5z", "M396.7 64L179.3 64c-30 0-56 20.8-62.5 50.1L99.3 193.3C122.1 184.9 152 176 176 176c22.7 0 39.4 8 56 16s33.3 16 56 16s39.4-8 56-16s33.3-16 56-16c24 0 53.9 8.9 76.7 17.3l-17.6-79.2C452.6 84.8 426.7 64 396.7 64zM32 384c-17.7 0-32 14.3-32 32s14.3 32 32 32l512 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 384z"]]
}, faLacrosseStick = {
  prefix: "fad",
  iconName: "lacrosse-stick",
  icon: [512, 512, [], "e3b5", ["M0 480c0 8.2 3.1 16.4 9.4 22.6s14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4l136-136c-18.7-11-34.3-26.6-45.3-45.3l-136 136C3.1 463.6 0 471.8 0 480z", "M264.8 117.7l-3.3 11.5c-5.6 19.6-15.1 37.9-27.8 53.9L205.8 218c-8.9 11.1-13.8 25-13.8 39.2c0 34.7 28.1 62.8 62.8 62.8c14.3 0 28.1-4.9 39.2-13.8l34.9-27.9c15.9-12.8 34.3-22.2 53.9-27.8l11.5-3.3c31.8-9.1 53.7-38.1 53.7-71.2c0 0 0 0 0 0c0-.1 0-.2 0-.3c0-19.9-13.6-48.1-38.6-73.1s-53.2-38.6-73.1-38.6l-.3 0s0 0 0 0c-33.1 0-62.1 21.9-71.2 53.7zM512 176s0 0 0 0c0 61.6-40.9 115.8-100.1 132.7L400.3 312c-11.5 3.3-22.2 8.8-31.5 16.2l-34.9 27.9c-22.5 18-50.4 27.8-79.2 27.8c-70 0-126.8-56.8-126.8-126.8c0-28.8 9.8-56.7 27.8-79.2l27.9-34.9c7.4-9.3 13-20 16.2-31.5l3.3-11.5C220.2 40.9 274.4 0 336 0c0 0 0 0 0 0l.3 0c43.8 0 87.4 26.4 118.4 57.3s57.3 74.5 57.3 118.4l0 .3z"]]
}, faHockeyMask = {
  prefix: "fad",
  iconName: "hockey-mask",
  icon: [448, 512, [], "f6ee", ["M0 240C0 111 64 0 224 0S448 111 448 240c0 192-48 272-224 272S0 432 0 240zm64-32c0 35.3 28.7 64 64 64s64-28.7 64-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zM136 80a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm16 240a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm48-320a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm48 192a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm0 64a24 24 0 1 0 48 0 24 24 0 1 0 -48 0zm8-240c0 35.3 28.7 64 64 64s64-28.7 64-64c0-17.7-14.3-32-32-32l-64 0c-17.7 0-32 14.3-32 32zm8-128a24 24 0 1 0 48 0 24 24 0 1 0 -48 0z", "M136 80a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm88 24a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM152 320a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm0 64a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48zm72-104a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zM288 56a24 24 0 1 1 0 48 24 24 0 1 1 0-48zM248 384a24 24 0 1 1 48 0 24 24 0 1 1 -48 0zm24 40a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faSunrise = {
  prefix: "fad",
  iconName: "sunrise",
  icon: [576, 512, [127749], "f766", ["M32 380.6c0 3.2 1 6.4 2.8 9.1L86.1 464l74.9 0c7.9-63.1 61.7-112 127-112s119.1 48.9 127 112l74.9 0 51.3-74.3c3.1-4.5 3.7-10.2 1.6-15.2s-6.6-8.6-11.9-9.6L423 345 403.1 237.1c-1-5.3-4.6-9.8-9.6-11.9s-10.7-1.5-15.2 1.6L288 289.1l-90.3-62.3c-2.7-1.9-5.9-2.8-9.1-2.8c-2.1 0-4.2 .4-6.1 1.2c-5 2.1-8.6 6.6-9.6 11.9L153 345 45.1 364.9c-5.3 1-9.8 4.6-11.9 9.6c-.8 2-1.2 4-1.2 6.1zM193.3 464l189.3 0c-7.6-45.4-47.1-80-94.7-80s-87.1 34.6-94.7 80z", "M354.5 135.7L320 104.3 320 208c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-103.7-34.5 31.3c-13.1 11.9-33.3 10.9-45.2-2.2s-10.9-33.3 2.2-45.2l88-80c12.2-11.1 30.8-11.1 43.1 0l88 80c13.1 11.9 14 32.1 2.2 45.2s-32.1 14-45.2 2.2zM24 464l528 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 512c-13.3 0-24-10.7-24-24s10.7-24 24-24z"]]
}, faSubtitles = {
  prefix: "fad",
  iconName: "subtitles",
  icon: [576, 512, [], "e60f", ["M0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM96 264c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zm160 0c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zm96-96c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24z", "M96 264c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24zm256 0c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zM96 360c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24zm160 0c0-13.3 10.7-24 24-24l176 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-176 0c-13.3 0-24-10.7-24-24z"]]
}, faPanelEws = {
  prefix: "fad",
  iconName: "panel-ews",
  icon: [512, 512, [], "e42e", ["M0 64L0 288l16 0c44.2 0 80 35.8 80 80l0 16c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32c-17.7 0-32-14.3-32-32l0-32c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l0 32c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-16c0-26.5-21.5-48-48-48L0 320 0 448c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zM96 80c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zM288 80c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zm0 144c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-128z", "M128 288c0-17.7 14.3-32 32-32l32 0c17.7 0 32 14.3 32 32l0 32c0 17.7-14.3 32-32 32l0 32c0 35.3-28.7 64-64 64s-64-28.7-64-64l0-16c0-26.5-21.5-48-48-48L0 320l0-32 16 0c44.2 0 80 35.8 80 80l0 16c0 17.7 14.3 32 32 32s32-14.3 32-32l0-32c-17.7 0-32-14.3-32-32l0-32zm192-32l64 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-64 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]]
}, faToriiGate = {
  prefix: "fad",
  iconName: "torii-gate",
  icon: [512, 512, [9961], "f6a1", ["M64 128l64 0 0 96-64 0 0-96zm0 160l64 0 0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-192zM224 128l64 0 0 96-64 0 0-96zm160 0l64 0 0 96-64 0 0-96zm0 160l64 0 0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-192z", "M0 13.4L0 80c0 26.5 21.5 48 48 48l416 0c26.5 0 48-21.5 48-48l0-66.6C512 6 506 0 498.6 0c-1.7 0-3.4 .3-5 1l-49 19.6C425.7 28.1 405.5 32 385.2 32L126.8 32c-20.4 0-40.5-3.9-59.4-11.4L18.4 1c-1.6-.6-3.3-1-5-1C6 0 0 6 0 13.4zM32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32l448 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 224z"]]
}, faCloudExclamation = {
  prefix: "fad",
  iconName: "cloud-exclamation",
  icon: [640, 512, [], "e491", ["M0 336c0 79.5 64.5 144 144 144l368 0c70.7 0 128-57.3 128-128c0-61.9-44-113.6-102.4-125.4c4.1-10.7 6.4-22.4 6.4-34.6c0-53-43-96-96-96c-19.7 0-38.1 6-53.3 16.2C367 64.2 315.3 32 256 32C167.6 32 96 103.6 96 192c0 2.7 .1 5.4 .2 8.1C40.2 219.8 0 273.2 0 336zm352 48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zM296 184c0-13.3 10.7-24 24-24s24 10.7 24 24l0 112c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-112z", "M344 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112zM320 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faMessageLines = {
  prefix: "fad",
  iconName: "message-lines",
  icon: [512, 512, ["comment-alt-lines"], "f4a6", ["M0 64C0 28.7 28.7 0 64 0L448 0c35.3 0 64 28.7 64 64l0 288c0 35.3-28.7 64-64 64l-138.7 0L185.6 508.8c-4.8 3.6-11.3 4.2-16.8 1.5s-8.8-8.2-8.8-14.3l0-80-96 0c-35.3 0-64-28.7-64-64L0 64zM128 168c0 13.3 10.7 24 24 24l208 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-208 0c-13.3 0-24 10.7-24 24zm0 96c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0c-13.3 0-24 10.7-24 24z", "M128 168c0-13.3 10.7-24 24-24l208 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-208 0c-13.3 0-24-10.7-24-24zm0 96c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-112 0c-13.3 0-24-10.7-24-24z"]]
}, faCommentAltLines = faMessageLines, faFrog = {
  prefix: "fad",
  iconName: "frog",
  icon: [576, 512, [], "f52e", ["M0 416c0 35.3 28.7 64 64 64l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-90.2 0 37.1-37.1c3.4-3.4 6.4-7.1 9-10.9c18.7-28 15.7-66.2-9-90.9c-24.6-24.6-62.6-27.7-90.5-9.2c-4 2.6-7.8 5.7-11.3 9.2c-.2 .2-.2 .2-.3 .3L123 347.6c-6.4 6.1-16.5 5.8-22.6-.6s-5.8-16.5 .6-22.6l73.6-70.1c40.6-40.5 106.4-40.4 146.9 .1c28.6 28.6 37.1 69.7 25.4 105.7L457.4 470.6c6 6 14.1 9.4 22.6 9.4l64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0-92.5-92.5 144.5-82.1c18.9-10.8 30.7-30.9 30.7-52.7c0-26.6-17.3-50.1-42.8-57.9l-85.6-26.3c.2 2.5 .3 5 .3 7.5c0 44.2-35.8 80-80 80s-80-35.8-80-80c0-1.2 0-2.5 .1-3.7s.1-2.5 .3-3.7c.2-2.4 .6-4.8 1-7.2C127 112.9 0 249.6 0 416z", "M368 192a80 80 0 1 0 0-160 80 80 0 1 0 0 160zm0-104a24 24 0 1 1 0 48 24 24 0 1 1 0-48z"]]
}, faBucket = {
  prefix: "fad",
  iconName: "bucket",
  icon: [448, 512, [], "e4cf", ["M48 152l0 40 48 0 0-40C96 94.6 142.6 48 200 48l48 0c57.4 0 104 46.6 104 104l0 40 48 0 0-40C400 68.1 331.9 0 248 0L200 0C116.1 0 48 68.1 48 152z", "M32 192c-17.7 0-32 14.3-32 32s14.3 32 32 32l5.1 0L59.5 469c2.6 24.4 23.2 43 47.7 43l233.6 0c24.6 0 45.2-18.5 47.7-43l22.4-213 5.1 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 192z"]]
}, faFloppyDiskPen = {
  prefix: "fad",
  iconName: "floppy-disk-pen",
  icon: [576, 512, [], "e182", ["M0 96C0 60.7 28.7 32 64 32l242.7 0c17 0 33.3 6.7 45.3 18.7L429.3 128c12 12 18.7 28.3 18.7 45.3l0 62.4L289.3 394.3c-8.2 8.2-14 18.5-16.8 29.7l-14 55.9L64 480c-35.3 0-64-28.7-64-64L0 96zm64 32l0 64c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32L96 96c-17.7 0-32 14.3-32 32zm96 224a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M493.2 235.8l-29.4 29.4 71 71 29.4-29.4c15.6-15.6 15.6-40.9 0-56.6l-14.4-14.4c-15.6-15.6-40.9-15.6-56.6 0zm-52 52L311.9 417.1c-4.1 4.1-7 9.2-8.4 14.9l-15 60.1c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l60.1-15c5.6-1.4 10.8-4.3 14.9-8.4L512.1 358.8l-71-71z"]]
}, faImage = {
  prefix: "fad",
  iconName: "image",
  icon: [512, 512, [], "f03e", ["M0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0zm2.4 258.4c4 8.3 12.4 13.6 21.6 13.6l96 0 32 0 208 0c8.9 0 17.1-4.9 21.2-12.8s3.6-17.4-1.4-24.7l-120-176c-4.5-6.6-11.9-10.5-19.8-10.5s-15.4 3.9-19.8 10.5l-87 127.6L170.7 297c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4z", "M323.8 202.5c-4.5-6.6-11.9-10.5-19.8-10.5s-15.4 3.9-19.8 10.5l-87 127.6L170.7 297c-4.6-5.7-11.5-9-18.7-9s-14.2 3.3-18.7 9l-64 80c-5.8 7.2-6.9 17.1-2.9 25.4s12.4 13.6 21.6 13.6l96 0 32 0 208 0c8.9 0 17.1-4.9 21.2-12.8s3.6-17.4-1.4-24.7l-120-176z"]]
}, faWindowFrame = {
  prefix: "fad",
  iconName: "window-frame",
  icon: [512, 512, [129695], "e04f", ["M96 64l0 160 136 0 0-160L96 64zm0 224l0 160 136 0 0-160L96 288zM280 64l0 160 136 0 0-160L280 64zm0 224l0 160 136 0 0-160-136 0z", "M32 256L32 64C32 28.7 60.7 0 96 0L416 0c35.3 0 64 28.7 64 64l0 192 0 192c17.7 0 32 14.3 32 32s-14.3 32-32 32l-64 0L96 512l-64 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l0-192zm384 32l-136 0 0 160 136 0 0-160zm-184 0L96 288l0 160 136 0 0-160zm48-64l136 0 0-160L280 64l0 160zM232 64L96 64l0 160 136 0 0-160z"]]
}, faMicrophone = {
  prefix: "fad",
  iconName: "microphone",
  icon: [384, 512, [], "f130", ["M16 216l0 40c0 89.1 66.2 162.7 152 174.4l0 33.6-48 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l72 0 72 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-48 0 0-33.6c85.8-11.7 152-85.3 152-174.4l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 40c0 70.7-57.3 128-128 128s-128-57.3-128-128l0-40c0-13.3-10.7-24-24-24s-24 10.7-24 24z", "M96 96c0-53 43-96 96-96s96 43 96 96V256c0 53-43 96-96 96s-96-43-96-96V96z"]]
}, faCow = {
  prefix: "fad",
  iconName: "cow",
  icon: [640, 512, [128004], "f6c8", ["M0 288c0-20.2 9.4-38.2 24-50c11-8.8 24.9-14 40-14l8 0 0 38.4C72 294.2 46.2 320 14.4 320C6.4 320 0 313.6 0 305.6L0 288zm192.1 37.4c.7-14.3 6.8-27.4 16.3-37l.3-.3c2.5-2.5 5.3-4.7 8.2-6.7s6.1-3.7 9.4-5.1c3.3-1.4 6.8-2.5 10.5-3.2c1.8-.4 3.7-.7 5.5-.8c.9-.1 1.9-.2 2.8-.2s1.9-.1 2.9-.1l48 0c30.8 0 55.9 24.9 56 55.8c-9.9 6.6-20.6 12-32 16.1l0 24.2c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-16.9c-5.3 .6-10.6 .9-16 .9s-10.7-.3-16-.9l0 16.9c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-24.2c-11.4-4-22.1-9.4-32-15.8l0-.5c0-.5 0-1.2 .1-2.1z", "M72 184c0-24.3 12.1-45.8 30.5-58.9C98.3 135.9 96 147.7 96 160l0 64 0 32 0 160c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-88 0-.2s0 0 0 0c.1-30.8 25.2-55.8 56-55.8l48 0c30.8 0 55.9 24.9 56 55.8c0 0 0 0 0 0l0 .2 0 88c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-160 32 32 0 49.5c0 9.5 2.8 18.7 8.1 26.6L530 427c8.8 13.1 23.5 21 39.3 21c22.5 0 41.9-15.9 46.3-38l20.3-101.6c2.6-13-.3-26.5-8-37.3l-3.9-5.5 0-81.6c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 14.4-52.9-74.1C496 86.5 452.4 64 405.9 64L272 64l-16 0-64 0-48 0C77.7 64 24 117.7 24 184l0 54c11-8.8 24.9-14 40-14l8 0 0-40zM576 320a16 16 0 1 1 0 32 16 16 0 1 1 0-32zM190.1 190.1l-23.4-23.4c-4.2-4.2-6.6-10-6.6-16c0-12.5 10.1-22.6 22.6-22.6l178.7 0c12.5 0 22.6 10.1 22.6 22.6c0 6-2.4 11.8-6.6 16l-23.4 23.4C332.2 211.8 302.7 224 272 224s-60.2-12.2-81.9-33.9z"]]
}, faFileZip = {
  prefix: "fad",
  iconName: "file-zip",
  icon: [512, 512, [], "e5ee", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 144-144 0c-35.3 0-64 28.7-64 64l0 144L64 512c-35.3 0-64-28.7-64-64L0 64z", "M384 160L224 0l0 128c0 17.7 14.3 32 32 32l128 0zM240 352c-8.8 0-16 7.2-16 16s7.2 16 16 16l38.1 0L225.7 488.8c-2.5 5-2.2 10.9 .7 15.6s8.1 7.6 13.6 7.6l64 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-38.1 0 52.4-104.8c2.5-5 2.2-10.9-.7-15.6s-8.1-7.6-13.6-7.6l-64 0zm144 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 128c0 8.8 7.2 16 16 16s16-7.2 16-16l0-128zm32 0l0 80 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-32 8 0c30.9 0 56-25.1 56-56s-25.1-56-56-56l-24 0c-8.8 0-16 7.2-16 16zm32 64l0-48 8 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-8 0z"]]
}, faSquareRing = {
  prefix: "fad",
  iconName: "square-ring",
  icon: [448, 512, [], "e44f", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM384 256A160 160 0 1 1 64 256a160 160 0 1 1 320 0z", "M224 160a96 96 0 1 0 0 192 96 96 0 1 0 0-192zm160 96A160 160 0 1 1 64 256a160 160 0 1 1 320 0z"]]
}, faDownFromLine = {
  prefix: "fad",
  iconName: "down-from-line",
  icon: [384, 512, ["arrow-alt-from-top"], "f349", ["M0 64C0 46.3 14.3 32 32 32l320 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64z", "M164.7 468.7L41.9 345.9c-6.4-6.4-9.9-15-9.9-24C32 303.2 47.2 288 65.9 288l62.1 0 0-128c0-17.7 14.3-32 32-32l64 0c17.7 0 32 14.3 32 32l0 128 62.1 0c18.7 0 33.9 15.2 33.9 33.9c0 9-3.6 17.6-9.9 24L219.3 468.7c-7.2 7.2-17.1 11.3-27.3 11.3s-20.1-4.1-27.3-11.3z"]]
}, faArrowAltFromTop = faDownFromLine, faCaretUp = {
  prefix: "fad",
  iconName: "caret-up",
  icon: [320, 512, [], "f0d8", ["M182.6 137.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-9.2 9.2-11.9 22.9-6.9 34.9s16.6 19.8 29.6 19.8l256 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-128-128z", ""]]
}, faShieldXmark = {
  prefix: "fad",
  iconName: "shield-xmark",
  icon: [512, 512, ["shield-times"], "e24c", ["M16 139.7c.5 99.5 41.3 281 213.6 363.5c16.7 8 36.1 8 52.8 0C454.7 420.7 495.5 239.2 496 140c0-26.4-16.4-47.9-38.3-57.2L269.4 2.9C265.2 1 260.7 0 256 0s-9.2 1-13.4 2.9L54.3 82.8C32.4 92.1 16 113.6 16 139.7zM168 320c0-6.1 2.3-12.3 7-17c15.7-15.7 31.3-31.4 47-47l-47-47c-9.4-9.4-9.4-24.6 0-33.9c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c15.7 15.7 31.3 31.3 47 47c15.7-15.7 31.3-31.3 47-47c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c9.4 9.4 9.4 24.6 0 33.9c-15.7 15.7-31.4 31.4-47 47l47 47c2.3 2.3 4.1 5 5.3 7.9c.6 1.4 1 2.9 1.3 4.4c.2 1.1 .4 2.3 .3 2.2c.1 1.2 .1 1.2 .1 2.4c-.1 1.5-.1 1.9-.1 2.3c-.1 .7-.2 1.5-.3 2.2c-.3 1.5-.7 3-1.3 4.4c-1.2 2.9-2.9 5.6-5.3 7.9c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7c-15.7-15.7-31.4-31.4-47-47c-15.7 15.7-31.4 31.3-47 47c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7s-7-10.8-7-17z", "M209 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]]
}, faShieldTimes = faShieldXmark, faScrewdriver = {
  prefix: "fad",
  iconName: "screwdriver",
  icon: [512, 512, [129691], "f54a", ["M211 267.1c7.1 3.6 13.7 8.4 19.7 14.3c1.5 1.5 2.9 3 4.2 4.6s2.6 3.2 3.8 4.8c2.4 3.3 4.5 6.7 6.3 10.3l109-109 54.1 0c7.4 0 14.5-3.5 19-9.4l80-104c7.4-9.6 6.5-23.1-2.1-31.6L465 7c-8.5-8.5-22-9.4-31.6-2.1l-104 80c-5.9 4.5-9.4 11.6-9.4 19l0 54.1-109 109z", "M230.6 281.4c-30.2-30.2-79.1-30.2-109.3 0l-112 112c-12.5 12.5-12.5 32.8 0 45.3l64 64c12.5 12.5 32.8 12.5 45.3 0l112-112c30.2-30.2 30.2-79.1 0-109.3z"]]
}, faCircleSortDown = {
  prefix: "fad",
  iconName: "circle-sort-down",
  icon: [512, 512, ["sort-circle-down"], "e031", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm145.2-41.9c-2.5-6-1.1-12.9 3.5-17.4l96-96c6.2-6.2 16.4-6.2 22.6 0l96 96c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9l-192 0c-6.5 0-12.3-3.9-14.8-9.9zm0 83.8c2.5-6 8.3-9.9 14.8-9.9l192 0c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4l-96 96c-6.2 6.2-16.4 6.2-22.6 0l-96-96c-4.6-4.6-5.9-11.5-3.5-17.4z", "M267.3 411.3c-6.2 6.2-16.4 6.2-22.6 0l-96-96c-4.6-4.6-5.9-11.5-3.5-17.4s8.3-9.9 14.8-9.9l192 0c6.5 0 12.3 3.9 14.8 9.9s1.1 12.9-3.5 17.4l-96 96z"]]
}, faSortCircleDown = faCircleSortDown, faFolderClosed = {
  prefix: "fad",
  iconName: "folder-closed",
  icon: [512, 512, [], "e185", ["M0 96l0 96 512 0 0-32c0-35.3-28.7-64-64-64L288 96c-10.1 0-19.6-4.7-25.6-12.8L243.2 57.6C231.1 41.5 212.1 32 192 32L64 32C28.7 32 0 60.7 0 96z", "M0 192L0 416c0 35.3 28.7 64 64 64l384 0c35.3 0 64-28.7 64-64l0-224L0 192z"]]
}, faHouseTsunami = {
  prefix: "fad",
  iconName: "house-tsunami",
  icon: [576, 512, [], "e515", ["M0 200c0 91.6 53.5 172.1 142.2 194.1c13.4 3.8 27.5 5.9 42.2 5.9c.7 0 1.4 0 2.1-.1c1.8 0 3.7 .1 5.5 .1c32 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c17.2 4 34.4-6.7 38.4-23.9c.6-2.4 .8-4.9 .8-7.3c0-14.5-10-27.7-24.7-31.1c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.5-27.3-10.1-39.2-1.7C439.4 325.2 410.9 336 384 336c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 325.4 219.5 336 192 336c-12.4 0-24-1.5-34.9-4.3C121.6 320.2 96 287 96 248c0-48.5 39.5-88 88.4-88c13.5 0 26.1 3 37.5 8.3c16 7.5 35.1 .6 42.5-15.5s.6-35.1-15.5-42.5C229.3 101.1 207.4 96 184.4 96c-40 0-76.4 15.4-103.6 40.5C104.9 93.8 152.6 64 209 64c16.9 0 33.1 2.7 48.2 7.7c16.8 5.5 34.9-3.6 40.4-20.4s-3.6-34.9-20.4-40.4C255.8 3.8 232.8 0 209 0C95.2 0 0 88 0 200zM.8 487.3C4.3 502 17.4 512 32 512c2.4 0 4.8-.3 7.3-.8c24.5-5.7 44.9-16.5 58.2-25C126.5 501.7 159 512 192 512c31.9 0 60.6-9.9 80.4-18.9c5.8-2.7 11.1-5.3 15.6-7.7c4.5 2.4 9.7 5.1 15.6 7.7c19.8 9 48.5 18.9 80.4 18.9c33 0 65.5-10.3 94.5-25.8c13.4 8.4 33.7 19.3 58.2 25c2.4 .6 4.9 .8 7.3 .8c14.5 0 27.7-10 31.1-24.7c.6-2.4 .8-4.9 .8-7.3c0-14.5-10-27.7-24.7-31.1c-18.1-4.2-36.2-13.3-50.6-25.2c-11.1-9.4-27.3-10.1-39.2-1.7C439.4 437.2 410.9 448 384 448c-27.5 0-55-10.6-77.5-26.1c-11.1-7.9-25.9-7.9-37 0C247 437.4 219.5 448 192 448c-26.9 0-55.3-10.8-77.4-26.1c-12-8.5-28.1-7.8-39.2 1.7c-14.4 11.9-32.5 21-50.6 25.2c-17.2 4-27.9 21.2-23.9 38.4z", "M332.8 118.4c-8.1 6-12.8 15.5-12.8 25.6l0 121c1.6 1 3.3 2 4.8 3.1c18.4 12.7 39.6 20.3 59.2 20.3c19 0 41.2-7.9 59.2-20.3c23.8-16.7 55.8-15.3 78.1 3.4c10.6 8.8 24.2 15.6 37.3 18.6c5.8 1.4 11.2 3.4 16.2 6.2c.7-2.7 1.1-5.5 1.1-8.4l-.4-144c0-10-4.7-19.4-12.7-25.5l-95.5-72c-11.4-8.6-27.1-8.6-38.5 0l-96 72z"]]
}, faSquareNfi = {
  prefix: "fad",
  iconName: "square-nfi",
  icon: [448, 512, [], "e576", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64L0 96zm64 80l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-102.2c22.1 36.8 44.2 73.6 66.3 110.5c2.9 4.9 8.2 7.8 13.7 7.8c1.4 0 2.9-.2 4.3-.6c6.9-1.9 11.7-8.2 11.7-15.4l0-160c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 102.2c-22.1-36.8-44.2-73.6-66.3-110.5c-3.7-6.2-11.1-9.1-18-7.2S64 168.8 64 176zm160 0l0 64 0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80c16 0 32 0 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16c-16 0-32 0-48 0l0-32c16 0 32 0 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16c-21.3 0-42.7 0-64 0c-8.8 0-16 7.2-16 16zm128 0l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160c0-8.8-7.2-16-16-16s-16 7.2-16 16z", "M93.7 167.8c-3.7-6.2-11.1-9.1-18-7.2S64 168.8 64 176l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-102.2 66.3 110.5c3.7 6.2 11.1 9.1 18 7.2s11.7-8.2 11.7-15.4l0-160c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 102.2L93.7 167.8zM240 160c-8.8 0-16 7.2-16 16l0 64 0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-80 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-32 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-64 0zm144 16c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 160c0 8.8 7.2 16 16 16s16-7.2 16-16l0-160z"]]
}, faForklift = {
  prefix: "fad",
  iconName: "forklift",
  icon: [640, 512, [], "f47a", ["M0 432a80 80 0 1 0 160 0A80 80 0 1 0 0 432zm256 0a80 80 0 1 0 160 0 80 80 0 1 0 -160 0zM480 32l0 384c0 17.7 14.3 32 32 32l96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-352c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M160 160l96 96 94 0L281.4 64 160 64l0 96zm-64 0L96 48c0-26.5 21.5-48 48-48L292.7 0c20.3 0 38.4 12.8 45.2 31.9l75.3 210.8c1.8 5.2 2.8 10.6 2.8 16.1l0 94.8c-20.3-20.7-48.7-33.6-80-33.6c-56.4 0-103.1 41.7-110.9 96l-34.3 0c-7.8-54.3-54.4-96-110.9-96c-31.3 0-59.7 12.9-80 33.6L0 208c0-26.5 21.5-48 48-48l48 0z"]]
}, faArrowUpFromGroundWater = {
  prefix: "fad",
  iconName: "arrow-up-from-ground-water",
  icon: [576, 512, [], "e4b5", ["M0 240L0 425c5.3-3.1 11.2-5.4 17.5-6.9c13.1-3.1 26.7-9.8 37.3-18.6c22.2-18.7 54.3-20.1 78.1-3.4c18 12.4 40.1 20.3 59.1 20.3L192 192 48 192c-26.5 0-48 21.5-48 48zm384-48l0 224.5c19 0 41.2-7.9 59.2-20.3c23.8-16.7 55.8-15.3 78.1 3.4c10.6 8.8 24.2 15.6 37.3 18.6c6.3 1.5 12.1 3.8 17.5 6.9l0-185c0-26.5-21.5-48-48-48l-144 0z", "M320 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-210.7-25.4 25.4c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l80-80c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0L320 109.3 320 320zM306.5 421.9C329 437.4 356.5 448 384 448c26.9 0 55.4-10.8 77.4-26.1c0 0 0 0 0 0c11.9-8.5 28.1-7.8 39.2 1.7c14.4 11.9 32.5 21 50.6 25.2c17.2 4 27.9 21.2 23.9 38.4s-21.2 27.9-38.4 23.9c-24.5-5.7-44.9-16.5-58.2-25C449.5 501.7 417 512 384 512c-31.9 0-60.6-9.9-80.4-18.9c-5.8-2.7-11.1-5.3-15.6-7.7c-4.5 2.4-9.7 5.1-15.6 7.7c-19.8 9-48.5 18.9-80.4 18.9c-33 0-65.5-10.3-94.5-25.8c-13.4 8.4-33.7 19.3-58.2 25c-17.2 4-34.4-6.7-38.4-23.9s6.7-34.4 23.9-38.4c18.1-4.2 36.2-13.3 50.6-25.2c11.1-9.4 27.3-10.1 39.2-1.7c0 0 0 0 0 0C136.7 437.2 165.1 448 192 448c27.5 0 55-10.6 77.5-26.1c11.1-7.9 25.9-7.9 37 0z"]]
}, faBracketSquareRight = {
  prefix: "fad",
  iconName: "bracket-square-right",
  icon: [192, 512, [], "5d", ["M192 96c0-35.3-28.7-64-64-64L64 32C46.3 32 32 46.3 32 64s14.3 32 32 32l64 0 0 320-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l64 0c35.3 0 64-28.7 64-64l0-320z", ""]]
}, faMartiniGlass = {
  prefix: "fad",
  iconName: "martini-glass",
  icon: [512, 512, [127864, "glass-martini-alt"], "f57b", ["M0 32c0 8.3 3.3 16.5 9.4 22.6L224 269.3 224 448l-64 0c-17.7 0-32 14.3-32 32s14.3 32 32 32l96 0 96 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0 0-178.7L502.6 54.6c9.2-9.2 11.9-22.9 6.9-34.9S492.9 0 480 0L32 0C19.1 0 7.4 7.8 2.4 19.8C.8 23.7 0 27.9 0 32zM109.3 64l293.5 0c-21.3 21.3-42.7 42.7-64 64L256 210.7c-27.6-27.6-55.2-55.2-82.7-82.7c-21.3-21.3-42.7-42.7-64-64z", "M338.7 128L256 210.7 173.3 128l165.5 0z"]]
}, faGlassMartiniAlt = faMartiniGlass, faSquareBinary = {
  prefix: "fad",
  iconName: "square-binary",
  icon: [512, 512, [], "e69b", ["M32 96l0 320c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L96 32C60.7 32 32 60.7 32 96zm100 48c0-24.3 19.7-44 44-44l32 0c24.3 0 44 19.7 44 44l0 48c0 24.3-19.7 44-44 44l-32 0c-24.3 0-44-19.7-44-44l0-48zm32 152c0-11 9-20 20-20l16 0c11 0 20 9 20 20l0 96c0 11-9 20-20 20s-20-9-20-20l0-76.4c-9.1-1.9-16-9.9-16-19.6zm8-152l0 48c0 2.2 1.8 4 4 4l32 0c2.2 0 4-1.8 4-4l0-48c0-2.2-1.8-4-4-4l-32 0c-2.2 0-4 1.8-4 4zm88 176c0-24.3 19.7-44 44-44l32 0c24.3 0 44 19.7 44 44l0 48c0 24.3-19.7 44-44 44l-32 0c-24.3 0-44-19.7-44-44l0-48zm32-200c0-11 9-20 20-20l16 0c11 0 20 9 20 20l0 96c0 11-9 20-20 20s-20-9-20-20l0-76.4c-9.1-1.9-16-9.9-16-19.6zm8 200l0 48c0 2.2 1.8 4 4 4l32 0c2.2 0 4-1.8 4-4l0-48c0-2.2-1.8-4-4-4l-32 0c-2.2 0-4 1.8-4 4z", "M132 144c0-24.3 19.7-44 44-44l32 0c24.3 0 44 19.7 44 44l0 48c0 24.3-19.7 44-44 44l-32 0c-24.3 0-44-19.7-44-44l0-48zm44-4c-2.2 0-4 1.8-4 4l0 48c0 2.2 1.8 4 4 4l32 0c2.2 0 4-1.8 4-4l0-48c0-2.2-1.8-4-4-4l-32 0zm116-20c0-11 9-20 20-20l16 0c11 0 20 9 20 20l0 96c0 11-9 20-20 20s-20-9-20-20l0-76.4c-9.1-1.9-16-9.9-16-19.6zM164 296c0-11 9-20 20-20l16 0c11 0 20 9 20 20l0 96c0 11-9 20-20 20s-20-9-20-20l0-76.4c-9.1-1.9-16-9.9-16-19.6zm96 24c0-24.3 19.7-44 44-44l32 0c24.3 0 44 19.7 44 44l0 48c0 24.3-19.7 44-44 44l-32 0c-24.3 0-44-19.7-44-44l0-48zm44-4c-2.2 0-4 1.8-4 4l0 48c0 2.2 1.8 4 4 4l32 0c2.2 0 4-1.8 4-4l0-48c0-2.2-1.8-4-4-4l-32 0z"]]
}, faRotateLeft = {
  prefix: "fad",
  iconName: "rotate-left",
  icon: [512, 512, ["rotate-back", "rotate-backward", "undo-alt"], "f2ea", ["M97.6 369.1c-12.5 12.5-12.5 32.8 0 45.3C141.3 458.1 198.7 480 256 480s114.7-21.9 158.4-65.6S480 313.3 480 256s-21.9-114.7-65.6-158.4c-87.2-87.2-228.3-87.5-315.8-1c15.1 15.1 30.2 30.2 45.3 45.3c62.6-61.5 163.1-61.2 225.3 1c62.5 62.5 62.5 163.8 0 226.3s-163.8 62.5-226.3 0c-12.5-12.5-32.8-12.5-45.3 0z", "M168 224L40 224c-13.3 0-24-10.7-24-24L16 72c0-9.7 5.8-18.5 14.8-22.2s19.3-1.7 26.2 5.2L185 183c6.9 6.9 8.9 17.2 5.2 26.2s-12.5 14.8-22.2 14.8z"]]
}, faRotateBack = faRotateLeft, faRotateBackward = faRotateLeft, faUndoAlt = faRotateLeft, faTableColumns = {
  prefix: "fad",
  iconName: "table-columns",
  icon: [512, 512, ["columns"], "f0db", ["M224 160l64 0 0 256-64 0 0-256z", "M64 160l0 256 384 0 0-256L64 160zm0 320c-35.3 0-64-28.7-64-64L0 96C0 60.7 28.7 32 64 32l384 0c35.3 0 64 28.7 64 64l0 320c0 35.3-28.7 64-64 64L64 480z"]]
}, faColumns = faTableColumns, faSquareA = {
  prefix: "fad",
  iconName: "square-a",
  icon: [448, 512, [], "e25f", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM96 360c0-3.6 .8-7.3 2.5-10.7c34.7-69.3 69.3-138.7 104-208c4.1-8.1 12.4-13.3 21.5-13.3s17.4 5.1 21.5 13.3l104 208c.9 1.7 1.5 3.5 1.9 5.3c.2 .9 .4 1.8 .5 2.7c.1 .7 .1 1.3 .1 1.3l0 1.5c0 1.1 0 1.4-.1 1.6c0 .5-.1 1.1-.2 1.6c-.1 1.1-.4 2.1-.7 3.2c-.6 2.1-1.5 4.1-2.6 6c-2.3 3.7-5.6 6.9-9.8 9c-11.9 5.9-26.3 1.1-32.2-10.7c-5.8-11.6-11.6-23.2-17.4-34.7l-130.3 0c-5.8 11.6-11.6 23.2-17.4 34.7c-4.2 8.4-12.7 13.3-21.5 13.3c-3.6 0-7.3-.8-10.7-2.5C100.9 377.3 96 368.8 96 360zm86.8-72l82.3 0L224 205.7c-13.7 27.5-27.4 54.9-41.2 82.3z", "M245.5 141.3c-4.1-8.1-12.4-13.3-21.5-13.3s-17.4 5.1-21.5 13.3l-104 208c-5.9 11.9-1.1 26.3 10.7 32.2s26.3 1.1 32.2-10.7L158.8 336l130.3 0 17.4 34.7c5.9 11.9 20.3 16.7 32.2 10.7s16.7-20.3 10.7-32.2l-104-208zM265.2 288l-82.3 0L224 205.7 265.2 288z"]]
}, faTick = {
  prefix: "fad",
  iconName: "tick",
  icon: [192, 512, [], "e32f", ["M32 98.3V96c0-35.3 28.7-64 64-64s64 28.7 64 64v2.3c0 3.8-.3 7.6-1 11.4L133.5 256.5c-3.2 18.2-19 31.5-37.5 31.5s-34.3-13.3-37.5-31.5L33 109.6c-.7-3.8-1-7.5-1-11.4z", ""]]
}, faLemon = {
  prefix: "fad",
  iconName: "lemon",
  icon: [448, 512, [127819], "f094", ["M0 416c0 35.3 28.7 64 64 64c6.6 0 13-1 19.1-2.9c22.5-7 48.1-14.9 71-9c75.2 19.1 156.4-11 213.7-68.3s87.5-138.5 68.3-213.7c-5.8-22.9 2-48.4 9-71c1.9-6 2.9-12.4 2.9-19.1c0-35.3-28.7-64-64-64c-6.6 0-13 1-19 2.9c-22.5 7-48.1 14.9-71 9c-75.2-19.1-156.4 11-213.7 68.3S-7.2 250.8 11.9 326c5.8 22.9-2 48.4-9 71C1 403 0 409.4 0 416zM64.2 237.8c.1-.7 .3-1.5 .5-2.3c19.1-65.1 73.7-119.8 138.9-138.9c8.5-2.5 17.4 2.4 19.9 10.9s-2.4 17.4-10.9 19.9c-54.6 16-101.1 62.5-117.1 117.1C92.9 253 84 257.8 75.5 255.4c-3.5-1-6.4-3.1-8.4-5.8c-1-1.4-1.8-2.9-2.3-4.5c-.3-.8-.5-1.6-.6-2.5c-.1-.6-.2-1.3-.2-1.3L64 240c0-.7 0-.9 0-1.1c0-.4 .1-.7 .1-1.1z", "M223.4 107.5c2.5 8.5-2.4 17.4-10.9 19.9c-54.6 16-101.1 62.5-117.1 117.1C92.9 253 84 257.8 75.5 255.4S62.2 244 64.6 235.5c19.1-65.1 73.7-119.8 138.9-138.9c8.5-2.5 17.4 2.4 19.9 10.9z"]]
}, faHeadSideMask = {
  prefix: "fad",
  iconName: "head-side-mask",
  icon: [576, 512, [], "e063", ["M32 224.2c0-20.2 2.7-39.9 7.7-58.5c77.4 57.5 154.8 115 232.3 172.5c0 57.9 0 115.8 0 173.8c-48 0-96 0-144 0c-17.7 0-32-14.3-32-32l0-72.7c0-16.7-6.9-32.5-17.1-45.8C48.6 322.4 32 274.1 32 224.2zM57.9 119.4C95.5 48.4 170.1 0 256 0l24 0c96.1 0 182.8 70.6 197.7 162.8c1.8 11.4 5.4 22.6 11.9 32.2l44.8 65.7c6.2 7.8 9.6 17.4 9.6 27.4l-259.1 0C209.2 231.8 133.6 175.6 57.9 119.4zM352 192a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M20.7 121.7c7.9-10.6 22.9-12.9 33.6-5L284.9 288 544 288l0 21.6c0 6.9-1.1 13.7-3.3 20.2L528 368l-160 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l149.3 0-10.7 32L368 432c-8.8 0-16 7.2-16 16s7.2 16 16 16l128 0-1.4 4.2c-8.7 26.1-33.2 43.8-60.7 43.8L272 512l0-173.8L25.7 155.3c-10.6-7.9-12.9-22.9-5-33.6z"]]
}, faHandshake = {
  prefix: "fad",
  iconName: "handshake",
  icon: [640, 512, [], "f2b5", ["M208.3 186.4c-.1 .9-.2 1.9-.2 2.8c-.1 .9-.1 1.9-.1 2.8c0 9.7 2.9 19.4 8.9 27.9c15.4 21.6 45.4 26.6 67 11.2l57.2-40.8c4.4 4 8.8 8 13.1 12L496.4 332.6c5.5 5 9.5 11.1 12.1 17.5c.3 .6 .5 1.2 .7 1.8l2.7 0 0-224-1.5 0-71-47.3C423.2 69.8 404.1 64 384.5 64c-20.7 0-40.9 6.5-57.7 18.5c-3.1 2.2-6.2 4.4-9.3 6.7c-29.8 21.3-59.5 42.5-89.3 63.8c-.8 .6-1.6 1.2-2.4 1.8s-1.5 1.3-2.2 1.9c-1.4 1.3-2.8 2.7-4 4.2c-2.5 2.9-4.6 6.1-6.3 9.5s-3 6.9-3.8 10.5c-.4 1.8-.8 3.7-1 5.5zM544 128l0 224c0 17.7 14.3 32 32 32l32 0c17.7 0 32-14.3 32-32l0-208c0-8.8-7.2-16-16-16l-80 0zm64 208a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M156.2 352L128 352l0-224 72-48c15.6-10.4 34-16 52.8-16c22.7 0 44.7 8.1 61.9 22.9l2.7 2.3-89.3 63.8c-21.6 15.4-26.6 45.4-11.2 67s45.4 26.6 67 11.2l57.2-40.8 13.1 12L496.4 332.6c5.5 5 9.6 11.1 12.1 17.5c6.6 16.6 3.7 36.2-9.2 50.3c-17.9 19.5-48.3 20.9-67.8 2.9l-7.8-7.1c-.9 10.1-5 20.1-12.4 28.2c-17.9 19.5-48.3 20.9-67.8 2.9l-17-15.6c-1.9 7.4-5.6 14.5-11.1 20.6c-17.9 19.6-48.2 21-67.8 3.1L156.2 352zM0 144c0-8.8 7.2-16 16-16l80 0 0 224c0 17.7-14.3 32-32 32l-32 0c-17.7 0-32-14.3-32-32L0 144zM64 336a16 16 0 1 0 -32 0 16 16 0 1 0 32 0z"]]
}, faGem = {
  prefix: "fad",
  iconName: "gem",
  icon: [512, 512, [128142], "f3a5", ["M4.7 185.8c-6.8 9.2-6.1 21.9 1.5 30.4l232 256c4.5 5 11 7.9 17.8 7.9s13.2-2.9 17.8-7.9l232-256c4.1-4.6 6.2-10.3 6.2-16.1c0-5-1.5-10-4.7-14.2l-112-152C390.8 27.6 383.6 24 376 24L136 24c-7.6 0-14.8 3.6-19.3 9.8l-112 152zm51.5 12.7c.1-.5 .2-1 .4-1.4c.4-.9 .9-1.7 1.5-2.5c1.3-1.4 3.1-2.4 5.2-2.6c49.1-4.1 98.1-8.2 147.2-12.3L153.1 84.1c-2.1-3.5-1.2-8.1 2.1-10.5s7.9-2 10.7 1c30 32.5 60.1 65.1 90.1 97.6c30-32.5 60.1-65.1 90.1-97.6c2.8-3 7.4-3.4 10.7-1s4.2 7 2.1 10.5c-19.1 31.9-38.3 63.8-57.4 95.6c49.1 4.1 98.1 8.2 147.2 12.3c4.1 .3 7.3 3.8 7.3 8s-3.2 7.6-7.3 8c-64 5.3-128 10.7-192 16c-.2 0-.4 0-.7 0s-.4 0-.7 0c-64-5.3-128-10.7-192-16c-2.1-.2-3.9-1.1-5.2-2.6c-.7-.7-1.2-1.6-1.6-2.5c-.2-.5-.3-.9-.4-1.4c0-.2-.1-.5-.1-.7s0-.5 0-.9c0-.2 0-.4 0-.7s.1-.5 .1-.7z", "M165.9 74.6c-2.8-3-7.4-3.4-10.7-1s-4.2 7-2.1 10.5l57.4 95.6L63.3 192c-4.1 .3-7.3 3.8-7.3 8s3.2 7.6 7.3 8l192 16c.4 0 .9 0 1.3 0l192-16c4.1-.3 7.3-3.8 7.3-8s-3.2-7.6-7.3-8L301.5 179.8l57.4-95.6c2.1-3.5 1.2-8.1-2.1-10.5s-7.9-2-10.7 1L256 172.2 165.9 74.6z"]]
}, faDolly = {
  prefix: "fad",
  iconName: "dolly",
  icon: [576, 512, ["dolly-box"], "f472", ["M351.9 416A96 96 0 1 1 160 416a96 96 0 1 1 191.9 0zM244.8 134.5c-5.5-16.8 3.7-34.9 20.5-40.3c15.2-4.9 30.4-9.9 45.7-14.8l19.8 60.9c20.3-6.6 40.6-13.2 60.9-19.8c-6.6-20.3-13.2-40.6-19.8-60.9l45.7-14.8c3.3-1.1 6.6-1.6 9.9-1.6c13.5 0 26 8.6 30.4 22.1l49.4 152.2c1.1 3.3 1.6 6.6 1.6 9.9c0 13.5-8.6 26-22.1 30.4L334.5 307.2c-16.8 5.5-34.9-3.7-40.3-20.5L244.8 134.5z", "M0 32C0 14.3 14.3 0 32 0l72.9 0c27.5 0 52 17.6 60.7 43.8L257.7 320c-.6 0-1.2 0-1.7 0c-22.2 0-42.7 7.6-59 20.2L104.9 64 32 64C14.3 64 0 49.7 0 32zM352 416c0-22.2-7.6-42.7-20.2-59l202.1-67.4c16.8-5.6 34.9 3.5 40.5 20.2s-3.5 34.9-20.2 40.5L352 417.7c0-.6 0-1.2 0-1.7zM371.8 59.6l19.8 60.9-60.9 19.8L311 79.4l60.9-19.8z"]]
}, faDollyBox = faDolly, faSmoking = {
  prefix: "fad",
  iconName: "smoking",
  icon: [640, 512, [128684], "f48d", ["M384 32l0 11c0 55.2 21.9 108.1 60.9 147.1l21 21c9 9 14.1 21.2 14.1 33.9l0 11c0 17.7 14.3 32 32 32s32-14.3 32-32l0-11c0-29.7-11.8-58.2-32.8-79.2l-21-21C463.2 117.8 448 81.2 448 43l0-11c0-17.7-14.3-32-32-32s-32 14.3-32 32zm96 0l0 11c0 29.7 11.8 58.2 32.8 79.2l21 21c27 27 42.2 63.6 42.2 101.8l0 11c0 17.7 14.3 32 32 32s32-14.3 32-32l0-11c0-55.2-21.9-108.1-60.9-147.1l-21-21c-9-9-14.1-21.2-14.1-33.9l0-11c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M64 352c-35.3 0-64 28.7-64 64l0 32c0 35.3 28.7 64 64 64l352 0c17.7 0 32-14.3 32-32l0-96c0-17.7-14.3-32-32-32L64 352zm160 64l160 0 0 32-160 0 0-32zm320-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96zm96 0c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96z"]]
}, faMinimize = {
  prefix: "fad",
  iconName: "minimize",
  icon: [512, 512, ["compress-arrows-alt"], "f78c", ["M0 456c0 5.1 2 10 5.7 13.7l36.7 36.7C46 510 50.9 512 56 512s10-2 13.7-5.7L143 433l40 40c6.9 6.9 17.2 8.9 26.2 5.2s14.8-12.5 14.8-22.2l0-144c0-13.3-10.7-24-24-24L56 288c-9.7 0-18.5 5.8-22.2 14.8s-1.7 19.3 5.2 26.2l40 40L5.7 442.3C2 446 0 450.9 0 456zM288 56l0 144c0 13.3 10.7 24 24 24l144 0c9.7 0 18.5-5.8 22.2-14.8s1.7-19.3-5.2-26.2l-40-40 73.4-73.4C510 66 512 61.1 512 56s-2-10-5.7-13.7L469.7 5.7C466 2 461.1 0 456 0s-10 2-13.7 5.7L369 79 329 39c-6.9-6.9-17.2-8.9-26.2-5.2S288 46.3 288 56z", "M56 224l144 0c13.3 0 24-10.7 24-24l0-144c0-9.7-5.8-18.5-14.8-22.2s-19.3-1.7-26.2 5.2L143 79 69.7 5.7C66 2 61.1 0 56 0S46 2 42.3 5.7L5.7 42.3C2 46 0 50.9 0 56s2 10 5.7 13.7L79 143 39 183c-6.9 6.9-8.9 17.2-5.2 26.2s12.5 14.8 22.2 14.8zm400 64l-144 0c-13.3 0-24 10.7-24 24l0 144c0 9.7 5.8 18.5 14.8 22.2s19.3 1.7 26.2-5.2l40-40 73.4 73.4c3.6 3.6 8.5 5.7 13.7 5.7s10-2 13.7-5.7l36.7-36.7c3.6-3.6 5.7-8.5 5.7-13.7s-2-10-5.7-13.7L433 369l40-40c6.9-6.9 8.9-17.2 5.2-26.2s-12.5-14.8-22.2-14.8z"]]
}, faCompressArrowsAlt = faMinimize, faRefrigerator = {
  prefix: "fad",
  iconName: "refrigerator",
  icon: [384, 512, [], "e026", ["M0 160l0 32 288 0 0-32L0 160zm320 0l0 32 64 0 0-32-64 0z", "M96 0C43 0 0 43 0 96l0 64 288 0 0-48c0-8.8 7.2-16 16-16s16 7.2 16 16l0 48 64 0 0-64c0-53-43-96-96-96L96 0zM384 192l-64 0 0 176c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-176L0 192 0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-256z"]]
}, faMonument = {
  prefix: "fad",
  iconName: "monument",
  icon: [384, 512, [], "f5a6", ["M0 480c0-17.7 14.3-32 32-32l19.9 0 280.2 0 19.9 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32z", "M203.3 4.7c-6.2-6.2-16.4-6.2-22.6 0l-80 80c-2.5 2.5-4.1 5.8-4.6 9.3L51.9 448l280.2 0L287.9 94c-.4-3.5-2-6.8-4.6-9.3l-80-80zM128 296c0-13.3 10.7-24 24-24l80 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-80 0c-13.3 0-24-10.7-24-24z"]]
}, faOctagonXmark = {
  prefix: "fad",
  iconName: "octagon-xmark",
  icon: [512, 512, ["times-octagon", "xmark-octagon"], "f2f0", ["M.1 191.5l0 129c0 19.1 7.6 37.4 21.1 50.9L140.6 490.8c13.5 13.5 31.8 21.1 50.9 21.1l129 0c19.1 0 37.4-7.6 50.9-21.1L490.8 371.4c13.5-13.5 21.1-31.8 21.1-50.9l0-129c0-19.1-7.6-37.4-21.1-50.9L371.4 21.2C357.9 7.7 339.6 .1 320.5 .1l-129 0c-19.1 0-37.4 7.6-50.9 21.1L21.2 140.6C7.7 154.1 .1 172.4 .1 191.5zm168 126.2c.1-.7 .2-1.5 .3-2.3c.3-1.5 .7-3 1.3-4.4c1.2-2.9 2.9-5.6 5.3-7.9c15.7-15.7 31.3-31.3 47-47c-15.7-15.7-31.3-31.3-47-47c-9.4-9.4-9.4-24.6 0-33.9c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c15.7 15.7 31.3 31.3 47 47c15.7-15.7 31.3-31.3 47-47c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c9.4 9.4 9.4 24.6 0 33.9c-15.7 15.7-31.3 31.3-47 47c15.7 15.7 31.3 31.4 47 47c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17s-10.8 7-17 7s-12.3-2.3-17-7l-47-47c-15.7 15.7-31.3 31.3-47 47c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7c-2.3-2.3-4.1-5.1-5.3-7.9c-.6-1.4-1-2.9-1.3-4.4c-.2-1.1-.4-2.3-.3-2.2c-.1-1.2-.1-1.2-.1-2.4c0-1.5 .1-1.9 .1-2.3z", "M209 175c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l47 47-47 47c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l47-47 47 47c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-47-47 47-47c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-47 47-47-47z"]]
}, faTimesOctagon = faOctagonXmark, faXmarkOctagon = faOctagonXmark, faAlignSlash = {
  prefix: "fad",
  iconName: "align-slash",
  icon: [640, 512, [], "f846", ["M96 192c0 17.7 14.3 32 32 32l34.5 0-61.8-48.7c-3 4.9-4.7 10.6-4.7 16.7zm0 128c0 17.7 14.3 32 32 32l196.9 0-81.2-64L128 288c-17.7 0-32 14.3-32 32zm0 128c0 17.7 14.3 32 32 32l359.4 0-81.2-64L128 416c-17.7 0-32 14.3-32 32zM98.4 51.8C117.2 66.5 136 81.3 154.8 96L512 96c17.7 0 32-14.3 32-32s-14.3-32-32-32L128 32c-13.4 0-24.8 8.2-29.6 19.8zM236.4 160c27.2 21.3 54.4 42.7 81.7 64L512 224c17.7 0 32-14.3 32-32s-14.3-32-32-32l-275.6 0zM399.7 288c27.2 21.3 54.4 42.7 81.7 64l30.6 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-112.3 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faSnowplow = {
  prefix: "fad",
  iconName: "snowplow",
  icon: [640, 512, [], "f7d2", ["M0 400c0-44.7 26.2-83.2 64-101.2c14.5-6.9 30.8-10.8 48-10.8l256 0c44.7 0 83.2 26.2 101.2 64c6.9 14.5 10.8 30.8 10.8 48c0 61.9-50.1 112-112 112l-256 0C50.1 512 0 461.9 0 400zm64 0c0 26.5 21.5 48 48 48l256 0c26.5 0 48-21.5 48-48s-21.5-48-48-48l-256 0c-26.5 0-48 21.5-48 48z", "M298.9 64l68.6 160L256 224l-64-64 0-96 106.9 0zM445.1 242.7l-87.4-204C347.6 15.3 324.5 0 298.9 0L176 0c-26.5 0-48 21.5-48 48l0 112-32 0c-17.7 0-32 14.3-32 32l0 106.8c14.5-6.9 30.8-10.8 48-10.8l256 0c44.7 0 83.2 26.2 101.2 64l42.8 0 0 50.7c0 17 6.7 33.3 18.7 45.3l54.6 54.6c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3L576 402.7l0-82.7 0-84.8L633 164c11-13.8 8.8-33.9-5-45s-33.9-8.8-45 5l-57 71.2c-9.1 11.3-14 25.4-14 40l0 52.8-64 0 0-31.3c.1-2.4-.2-4.8-.6-7.1s-1.2-4.7-2.2-6.8zM144 400a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm216 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zm-56-24a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zM200 424a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]]
}, faAnglesRight = {
  prefix: "fad",
  iconName: "angles-right",
  icon: [512, 512, [187, "angle-double-right"], "f101", ["M64 96c0 8.2 3.1 16.4 9.4 22.6L210.7 256 73.4 393.4C67.1 399.6 64 407.8 64 416s3.1 16.4 9.4 22.6s14.4 9.4 22.6 9.4s16.4-3.1 22.6-9.4l160-160c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6l-160-160C112.4 67.1 104.2 64 96 64s-16.4 3.1-22.6 9.4S64 87.8 64 96z", "M470.6 233.4c12.5 12.5 12.5 32.8 0 45.3l-160 160c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L402.7 256 265.4 118.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l160 160z"]]
}, faAngleDoubleRight = faAnglesRight, faTruckRampCouch = {
  prefix: "fad",
  iconName: "truck-ramp-couch",
  icon: [640, 512, ["truck-couch"], "f4dd", ["M8 252.8l1.7 6.4c8.4-6.7 18.2-11.8 29.2-14.7c37.4-10 75.7 8.2 92.3 41.5L227 260.4c-2.3-37.2 21.8-72.1 59.2-82.1c11-2.9 22.1-3.5 32.6-1.9l-1.7-6.4c-7.7-28.6-33.5-47.5-61.8-47.5c-5.5 0-11.1 .7-16.6 2.2L53.3 174.4C19.1 183.5-1.1 218.6 8 252.8zm5.3 81.4l12.4 46.4c4.6 17.1 22.1 27.2 39.2 22.6l61.8-16.6 154.5-41.4L320 334.8l0-125.5c-8.1-2.3-16.8-2.5-25.5-.2c-25.6 6.9-40.8 33.2-33.9 58.8l4.1 15.5L110.1 324.8 106 309.3c-6.9-25.6-33.2-40.8-58.8-33.9s-40.8 33.2-33.9 58.8zM448 416a96 96 0 1 0 192 0 96 96 0 1 0 -192 0z", "M416.7 402.5C423.4 338.2 477.9 288 544 288c38.2 0 72.5 16.8 96 43.3L640 0 416 0c-35.3 0-64 28.7-64 64l0 289.8L31.6 441.1c-17.1 4.6-27.1 22.2-22.5 39.3s22.2 27.1 39.3 22.5L416.7 402.5z"]]
}, faTruckCouch = faTruckRampCouch, faCannabis = {
  prefix: "fad",
  iconName: "cannabis",
  icon: [512, 512, [], "f55f", ["M16.3 152.9c5.6 27.7 19.3 70.9 42.7 111.7c9.1 15.9 19.9 31.7 32.4 46.3c-27.8 6.6-52.4 17.3-67.2 25.5c-5.1 2.8-8.2 8.2-8.2 14s3.2 11.2 8.2 14c15.2 8.4 40.9 19.5 69.8 26.1c20.2 4.6 42.9 7.2 65.2 4.6l-8.3 33.1c-1.5 6.1 .6 12.4 5.5 16.4s11.6 4.6 17.2 1.9L232 417.2l0-41.2c0-13.3 10.7-24 24-24s24 10.7 24 24l0 41.2 58.5 29.1c5.6 2.8 12.3 2.1 17.2-1.9s7-10.3 5.5-16.4L352.8 395c22.2 2.6 45 0 65.2-4.6c28.9-6.6 54.6-17.6 69.8-26.1c5.1-2.8 8.2-8.2 8.2-14s-3.2-11.2-8.2-14c-14.8-8.2-39.4-18.8-67.2-25.5c12.5-14.5 23.3-30.4 32.4-46.3c23.4-40.8 37.1-84 42.7-111.7c1.1-5.2-.6-10.7-4.4-14.5s-9.2-5.4-14.4-4.4c-27.9 5.5-71.2 19.2-112.2 42.5c-12.1 6.9-24.3 14.7-35.8 23.6c1.4-28.7-3.1-57.6-10.4-84C306 70.8 285.1 30.6 269.3 7.1c-3-4.4-8-7.1-13.3-7.1s-10.3 2.7-13.3 7.1c-15.8 23.5-36.7 63.7-49.2 109c-7.2 26.4-11.8 55.2-10.4 84c-11.5-8.8-23.7-16.7-35.8-23.6C106.3 153.2 63 139.6 35.1 134c-5.2-1-10.7 .6-14.4 4.4s-5.4 9.2-4.4 14.5z", "M280 376c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 112c0 13.3 10.7 24 24 24s24-10.7 24-24l0-112z"]]
}, faCirclePlay = {
  prefix: "fad",
  iconName: "circle-play",
  icon: [512, 512, [61469, "play-circle"], "f144", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm176-88c0-8.7 4.7-16.7 12.3-20.9c3.7-2 7.7-3.1 11.7-3.1c4.3 0 8.7 1.2 12.5 3.5l144 88c7.1 4.4 11.5 12.1 11.5 20.5s-4.4 16.1-11.5 20.5l-144 88c-7.4 4.5-16.7 4.7-24.3 .5s-12.3-12.2-12.3-20.9l0-176z", "M212.5 147.5c-7.4-4.5-16.7-4.7-24.3-.5s-12.3 12.3-12.3 20.9l0 176c0 8.7 4.7 16.7 12.3 20.9s16.8 4.1 24.3-.5l144-88c7.1-4.4 11.5-12.1 11.5-20.5s-4.4-16.1-11.5-20.5l-144-88z"]]
}, faPlayCircle = faCirclePlay, faArrowUpRightAndArrowDownLeftFromCenter = {
  prefix: "fad",
  iconName: "arrow-up-right-and-arrow-down-left-from-center",
  icon: [512, 512, [], "e0a0", ["M0 352L0 480c0 17.7 14.3 32 32 32l128 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-50.7 0L214.6 342.6c6.2-6.2 9.4-14.4 9.4-22.6s-3.1-16.4-9.4-22.6s-14.4-9.4-22.6-9.4s-16.4 3.1-22.6 9.4L64 402.7 64 352c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M320 32c0-17.7 14.3-32 32-32L480 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-50.7L342.6 214.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L402.7 64 352 64c-17.7 0-32-14.3-32-32z"]]
}, faLocationArrowUp = {
  prefix: "fad",
  iconName: "location-arrow-up",
  icon: [448, 512, [], "e63a", ["M36.6 432L201.7 46.7C205.5 37.8 214.3 32 224 32s18.5 5.8 22.3 14.7L411.4 432c9.7 22.7-6.9 48-31.6 48c-7.7 0-15.1-2.6-21.1-7.2L224 368 89.3 472.8c-6 4.7-13.5 7.2-21.1 7.2c-24.7 0-41.4-25.3-31.6-48z", ""]]
}, faTablets = {
  prefix: "fad",
  iconName: "tablets",
  icon: [640, 512, [], "f490", ["M320 160c0 88.4 71.6 160 160 160c32.1 0 61.9-9.4 87-25.7c7.9-5.2 8.5-16.2 1.8-22.9L368.6 71.2c-6.7-6.7-17.8-6.2-22.9 1.8c-16.3 25-25.7 54.9-25.7 87zM391.2 48.6L591.4 248.8c6.7 6.7 17.8 6.2 22.9-1.8c16.3-25 25.7-54.9 25.7-87C640 71.6 568.4 0 480 0c-32.1 0-61.9 9.4-87 25.7c-7.9 5.2-8.5 16.2-1.8 22.9z", "M316.5 385.5c2-9.3-5.5-17.5-15-17.5L18.5 368c-9.5 0-16.9 8.2-15 17.5C18.9 457.8 83.1 512 160 512s141.1-54.2 156.5-126.5zm0-66.9C301.1 246.2 236.9 192 160 192S18.9 246.2 3.5 318.5c-2 9.3 5.5 17.5 15 17.5l283.1 0c9.5 0 16.9-8.2 15-17.5z"]]
}, fa360Degrees = {
  prefix: "fad",
  iconName: "360-degrees",
  icon: [640, 512, [], "e2dc", ["M576 32a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M0 96C0 78.3 14.3 64 32 64l128 0c12.1 0 23.2 6.8 28.6 17.7s4.3 23.8-3 33.5l-63.7 84.9C163 216.7 192 257 192 304l0 48c0 53-43 96-96 96l-5.5 0c-25.5 0-49.9-10.1-67.9-28.1L9.4 406.6c-12.5-12.5-12.5-32.8 0-45.3s32.8-12.5 45.3 0l13.3 13.3c6 6 14.1 9.4 22.6 9.4l5.5 0c17.7 0 32-14.3 32-32l0-48c0-26.5-21.5-48-48-48l-16 0c-12.1 0-23.2-6.8-28.6-17.7s-4.3-23.8 3-33.5L96 128l-64 0C14.3 128 0 113.7 0 96zm496 32c-8.8 0-16 7.2-16 16l0 224c0 8.8 7.2 16 16 16s16-7.2 16-16l0-224c0-8.8-7.2-16-16-16zm0 320c-44.2 0-80-35.8-80-80l0-224c0-44.2 35.8-80 80-80s80 35.8 80 80l0 224c0 44.2-35.8 80-80 80zM320 128c-17.7 0-32 14.3-32 32l0 33.6c5.2-1 10.5-1.6 16-1.6c44.2 0 80 35.8 80 80l0 96c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-79.8 0-.2 0-128c0-53 43-96 96-96c17.7 0 32 14.3 32 32s-14.3 32-32 32zM288 272l0 96c0 8.8 7.2 16 16 16s16-7.2 16-16l0-96c0-8.8-7.2-16-16-16s-16 7.2-16 16z"]]
}, faEthernet = {
  prefix: "fad",
  iconName: "ethernet",
  icon: [512, 512, [], "f796", ["M0 224c0-17.7 14.3-32 32-32l32 0 0-32c0-17.7 14.3-32 32-32l32 0 0-32c0-17.7 14.3-32 32-32l192 0c17.7 0 32 14.3 32 32l0 32 32 0c17.7 0 32 14.3 32 32l0 32 32 0c17.7 0 32 14.3 32 32l0 192c0 17.7-14.3 32-32 32l-64 0 0-112c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 112-64 0 0-112c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 112-64 0 0-112c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 112-64 0 0-112c0-8.8-7.2-16-16-16s-16 7.2-16 16l0 112-64 0c-17.7 0-32-14.3-32-32L0 224z", "M112 320c8.8 0 16 7.2 16 16l0 112-32 0 0-112c0-8.8 7.2-16 16-16zm96 0c8.8 0 16 7.2 16 16l0 112-32 0 0-112c0-8.8 7.2-16 16-16zm96 0c8.8 0 16 7.2 16 16l0 112-32 0 0-112c0-8.8 7.2-16 16-16zm96 0c8.8 0 16 7.2 16 16l0 112-32 0 0-112c0-8.8 7.2-16 16-16z"]]
}, faEuroSign = {
  prefix: "fad",
  iconName: "euro-sign",
  icon: [320, 512, [8364, "eur", "euro"], "f153", ["M0 208c0-17.7 14.3-32 32-32l28.3 0c-7.1 20.1-11.3 41.6-12.1 64L32 240c-17.7 0-32-14.3-32-32zm0 96c0-17.7 14.3-32 32-32l16.1 0c.8 22.4 5 43.9 12.1 64L32 336c-17.7 0-32-14.3-32-32zm112.2-64c1.2-23.1 7.5-44.8 17.9-64L256 176c17.7 0 32 14.3 32 32s-14.3 32-32 32l-143.8 0zm0 32L256 272c17.7 0 32 14.3 32 32s-14.3 32-32 32l-125.9 0c-10.4-19.2-16.7-40.9-17.9-64z", "M48 248C48 128.7 144.7 32 264 32l24 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-24 0c-83.9 0-152 68.1-152 152l0 16c0 83.9 68.1 152 152 152l24 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-24 0C144.7 480 48 383.3 48 264l0-16z"]]
}, faEur = faEuroSign, faEuro = faEuroSign, faChair = {
  prefix: "fad",
  iconName: "chair",
  icon: [448, 512, [129681], "f6c0", ["M32 384l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96-64 0zM64 128l0 160 48 0 0-160c0-29.6 16.1-55.5 40-69.3L152 288l48 0 0-240 48 0 0 240 48 0 0-229.3c23.9 13.8 40 39.7 40 69.3l0 160 48 0 0-160C384 57.3 326.7 0 256 0L192 0C121.3 0 64 57.3 64 128zM352 384l0 96c0 17.7 14.3 32 32 32s32-14.3 32-32l0-96-64 0z", "M19.4 305.7C24.8 294.8 35.9 288 48 288l352 0c12.1 0 23.2 6.8 28.6 17.7l16 32c5 9.9 4.4 21.7-1.4 31.1s-16.1 15.2-27.2 15.2L32 384c-11.1 0-21.4-5.7-27.2-15.2s-6.4-21.2-1.4-31.1l16-32z"]]
}, faCircleCheck = {
  prefix: "fad",
  iconName: "circle-check",
  icon: [512, 512, [61533, "check-circle"], "f058", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm136 0c0-6.1 2.3-12.3 7-17c9.4-9.4 24.6-9.4 33.9 0l47 47c37-37 74-74 111-111c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7c2.3 2.3 4.1 5 5.3 7.9c.6 1.5 1 2.9 1.3 4.4c.2 1.1 .3 2.2 .3 2.2c.1 1.2 .1 1.2 .1 2.5c-.1 1.5-.1 1.9-.1 2.3c-.1 .7-.2 1.5-.3 2.2c-.3 1.5-.7 3-1.3 4.4c-1.2 2.9-2.9 5.6-5.3 7.9c-42.7 42.7-85.3 85.3-128 128c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7c-21.3-21.3-42.7-42.7-64-64c-4.7-4.7-7-10.8-7-17z", "M369 175c9.4 9.4 9.4 24.6 0 33.9L241 337c-9.4 9.4-24.6 9.4-33.9 0l-64-64c-9.4-9.4-9.4-24.6 0-33.9s24.6-9.4 33.9 0l47 47L335 175c9.4-9.4 24.6-9.4 33.9 0z"]]
}, faCheckCircle = faCircleCheck, faSquareDashedCirclePlus = {
  prefix: "fad",
  iconName: "square-dashed-circle-plus",
  icon: [576, 512, [], "e5c2", ["M0 128l0 32 64 0 0-32c0-17.7 14.3-32 32-32l32 0 0-64L96 32C43 32 0 75 0 128zm0 64L0 320l64 0 0-128L0 192zM0 352l0 32c0 53 43 96 96 96l32 0 0-64-32 0c-17.7 0-32-14.3-32-32l0-32L0 352zM160 32l0 64 128 0 0-64L160 32zm0 384l0 64 128 0 0-10.8c-11.3-16-19.9-33.9-25.4-53.2L160 416zM320 32l0 64 32 0c17.7 0 32 14.3 32 32l0 70.6c15.3-4.3 31.4-6.6 48-6.6c5.4 0 10.7 .2 16 .7l0-64.7c0-53-43-96-96-96l-32 0z", "M288 368a144 144 0 1 1 288 0 144 144 0 1 1 -288 0zm144-80c-8.8 0-16 7.2-16 16l0 48-48 0c-8.8 0-16 7.2-16 16s7.2 16 16 16l48 0 0 48c0 8.8 7.2 16 16 16s16-7.2 16-16l0-48 48 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-48 0 0-48c0-8.8-7.2-16-16-16z"]]
}, faHandHoldingCircleDollar = {
  prefix: "fad",
  iconName: "hand-holding-circle-dollar",
  icon: [576, 512, [], "e621", ["M0 416l0 64c0 17.7 14.3 32 32 32l160 0 160.5 0c29 0 57.3-9.3 80.7-26.5l126.6-93.3c10.6-7.8 16.3-20 16.3-32.2c0-8.2-2.5-16.6-7.8-23.7c-13.1-17.8-38.1-21.6-55.9-8.5L392.6 416 272 416c-8.8 0-16-7.2-16-16s7.2-16 16-16l16 0 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0-16 0-78.3 0c-29.1 0-57.3 9.9-80 28L68.8 384 32 384c-17.7 0-32 14.3-32 32z", "M272 288A144 144 0 1 0 272 0a144 144 0 1 0 0 288zM248.1 115c0 0 0 0 0 .1c0 .4 0 1.9 4.8 4.5c5.6 3 13.5 5.2 23.9 8.2l.2 0c9.3 2.6 21.1 6 30.5 11.5c10.2 6 20 16.1 20.5 32.3c.5 18.2-9.7 30.4-21.7 36.9c-5.8 3.1-12.1 5.1-18.3 6.2l0 10.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-11.4c-8.6-1.7-16.7-4.3-23.7-6.6c0 0 0 0 0 0c-1.7-.6-3.4-1.1-5-1.6c-8.4-2.6-13.1-11.6-10.5-20s11.6-13.1 20-10.5c2 .6 3.9 1.2 5.8 1.8c11.5 3.6 20.4 6.5 29.9 6.8c6.7 .2 13.8-1.1 18.5-3.6c2.2-1.2 3.4-2.4 4-3.3c.5-.8 1.1-2.1 1-4.5c0-1.4-.2-3-4.7-5.6c-5.3-3.1-12.9-5.4-23.2-8.3l-1.8-.5c-8.9-2.5-19.8-5.6-28.6-10.3c-9.9-5.3-20.6-14.7-21.6-30.7c-1.2-18.8 10-30.9 21.8-37.2c5.7-3.1 12-5.1 18-6.3l0-9.5c0-8.8 7.2-16 16-16s16 7.2 16 16l0 9.4c6.3 .9 12.3 2.3 17.9 3.7c8.6 2.1 13.8 10.8 11.7 19.4s-10.8 13.8-19.4 11.7c-9.3-2.3-18.2-4-26.4-4.1c-6.2-.1-13.6 1.3-18.7 4c-2.4 1.3-3.6 2.5-4.2 3.4c-.4 .7-.9 1.6-.8 3.6z"]]
}, faMoneySimpleFromBracket = {
  prefix: "fad",
  iconName: "money-simple-from-bracket",
  icon: [640, 512, [], "e313", ["M128 96l0 352c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-352L128 96zm96 176c0-44.2 43-80 96-80s96 35.8 96 80s-43 80-96 80s-96-35.8-96-80z", "M96 64C78.3 64 64 78.3 64 96l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 96C0 43 43 0 96 0L544 0c53 0 96 43 96 96l0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64c0-17.7-14.3-32-32-32L96 64z"]]
}, faBat = {
  prefix: "fad",
  iconName: "bat",
  icon: [576, 512, [], "f6b5", ["M195.1 159.2c8.5 4 17 8.1 25.5 12.1c6.4 3.1 13.5 4.7 20.6 4.7l93.5 0c7.1 0 14.2-1.6 20.6-4.7l25.5-12.1-19-101.4c-1.1-5.7-6-9.8-11.8-9.8c-3.8 0-7.4 1.8-9.6 4.8L329.6 67.2C323.6 75.3 314.1 80 304 80l-32 0c-10.1 0-19.6-4.7-25.6-12.8L235.6 52.8c-2.3-3-5.8-4.8-9.6-4.8c-5.8 0-10.8 4.1-11.8 9.8l-19 101.4z", "M334.8 176H241.2c-7.1 0-14.2-1.6-20.6-4.7L123.4 125c-16.2-7.7-35.5-3.6-47.1 10C27.1 192.4 0 265.6 0 341.2v37.6c0 9.7 10.2 16 18.9 11.7l63.8-31.9c7.5-3.7 16.6-1.1 20.9 6.1l29.8 49.7c5.4 8.9 17.7 10.4 25 3.1l36.6-36.6c6.8-6.8 18.1-6.1 24 1.6l56.2 73.1c6.4 8.3 19 8.3 25.4 0l56.2-73.1c5.9-7.7 17.2-8.4 24-1.6l36.6 36.6c7.4 7.4 19.7 5.8 25-3.1l29.8-49.7c4.3-7.2 13.4-9.8 20.9-6.1l63.8 31.9c8.7 4.3 18.9-2 18.9-11.7V341.2c0-75.6-27.1-148.8-76.3-206.2c-11.6-13.6-30.9-17.7-47.1-10l-97.2 46.3c-6.4 3.1-13.5 4.7-20.6 4.7z"]]
}, faCircleStop = {
  prefix: "fad",
  iconName: "circle-stop",
  icon: [512, 512, [62094, "stop-circle"], "f28d", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm160-64c0-17.7 14.3-32 32-32l128 0c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-128 0c-17.7 0-32-14.3-32-32l0-128z", "M192 160h128a32 32 0 0 1 32 32v128a32 32 0 0 1 -32 32H192a32 32 0 0 1 -32-32V192a32 32 0 0 1 32-32z"]]
}, faStopCircle = faCircleStop, faHeadSideHeadphones = {
  prefix: "fad",
  iconName: "head-side-headphones",
  icon: [512, 512, [], "f8c2", ["M0 224.2c0 49.9 16.6 98.2 46.9 137.3C57.1 374.8 64 390.6 64 407.3L64 480c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-32 64 0c35.3 0 64-28.7 64-64l0-64 20.2 0c24.2 0 43.8-19.6 43.8-43.8c0-10-3.4-19.6-9.6-27.4l-42-52.6c-8.3-10.3-12.8-23-15.1-36C429.6 71.8 348 3.9 256 .2L256 64l0 22.6c0 12.4 7.4 23.3 17.4 30.5C301.6 137.4 320 170.6 320 208c0 61.9-50.1 112-112 112s-112-50.1-112-112c0-37.5 18.4-70.6 46.6-90.9c10-7.2 17.4-18.2 17.4-30.5L160 64l0-54.7C67.4 36.9 0 122.8 0 224.2z", "M256 64L256 .2c-2.7-.1-5.3-.2-8-.2L224 0c-22.2 0-43.7 3.2-64 9.3L160 64l0 22.6c0 12.4-7.4 23.3-17.4 30.5C114.4 137.4 96 170.6 96 208c0 61.9 50.1 112 112 112s112-50.1 112-112c0-37.4-18.4-70.6-46.6-90.9c-10-7.2-17.4-18.2-17.4-30.5L256 64zM144 208a64 64 0 1 1 128 0 64 64 0 1 1 -128 0zm96 0a32 32 0 1 0 -64 0 32 32 0 1 0 64 0z"]]
}, faPhoneRotary = {
  prefix: "fad",
  iconName: "phone-rotary",
  icon: [512, 512, [9742], "f8d3", ["M0 141.3c0-8.5 3.4-16.6 9.9-22.1C38.2 95.4 125.9 32 256 32s217.8 63.4 246.1 87.2c6.5 5.5 9.9 13.6 9.9 22.1l0 34.7c0 17.7-14.3 32-32 32l-42.3 0c-13.1 0-24.9-8-29.7-20.1l-19.4-48.6c-2.9-7.3-8.4-13.2-15.7-16c-18.6-7-59.5-19.3-116.8-19.3s-98.2 12.3-116.8 19.3c-7.3 2.8-12.8 8.7-15.7 16L104 187.9C99.2 200 87.4 208 74.3 208L32 208c-17.7 0-32-14.3-32-32l0-34.7zM328 312a72 72 0 1 1 -144 0 72 72 0 1 1 144 0z", "M32 401l0 31c0 26.5 21.5 48 48 48l352 0c26.5 0 48-21.5 48-48l0-31c0-11.1-2.9-22.1-8.4-31.8l-101.1-177C359 172.3 337.8 160 314.9 160l-117.7 0c-23 0-44.2 12.3-55.6 32.2L40.4 369.2C34.9 378.9 32 389.9 32 401zM256 240a72 72 0 1 1 0 144 72 72 0 1 1 0-144z"]]
}, faArrowUpToBracket = {
  prefix: "fad",
  iconName: "arrow-up-to-bracket",
  icon: [448, 512, [], "e66a", ["M0 96l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-53-43-96-96-96L96 0C43 0 0 43 0 96z", "M246.6 169.4c-12.5-12.5-32.8-12.5-45.3 0l-128 128c-12.5 12.5-12.5 32.8 0 45.3s32.8 12.5 45.3 0L192 269.3 192 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-210.7 73.4 73.4c12.5 12.5 32.8 12.5 45.3 0s12.5-32.8 0-45.3l-128-128z"]]
}, faCompassDrafting = {
  prefix: "fad",
  iconName: "compass-drafting",
  icon: [512, 512, ["drafting-compass"], "f568", ["M31.2 276c-11.1-13.8-8.8-33.9 5-45s33.9-8.8 45 5c5.7 7.1 11.8 13.8 18.2 20.1c-11 18.9-21.9 37.8-32.9 56.8C53.7 301.6 41.8 289.3 31.2 276zm124.1 89.9l32.7-56.4c21.5 6.8 44.3 10.5 68.1 10.5s46.6-3.7 68.1-10.5c33.7-10.7 63.9-29.2 88.6-53.4c6.5-6.3 12.6-13.1 18.2-20.1c11.1-13.8 31.2-16 45-5c7.9 6.3 12 15.6 12 25c0 7-2.3 14.1-7 20c-10.7 13.3-22.5 25.6-35.3 36.8c-25.9 22.7-55.9 40.8-88.8 53C325.4 377.6 291.4 384 256 384s-69.4-6.4-100.7-18.1z", "M343.2 136.2c5.6-12.2 8.8-25.8 8.8-40.2c0-53-43-96-96-96s-96 43-96 96c0 14.3 3.1 27.9 8.8 40.2L6.5 416.5C2.2 423.9 0 432.2 0 440.6L0 496c0 5.5 2.9 10.7 7.6 13.6s10.6 3.2 15.6 .7l55.4-27.7c8.4-4.2 15.4-10.8 20.1-18.9L256 192c0 0 0 0 0 0s0 0 0 0l68 117.5c33.7-10.7 63.9-29.2 88.6-53.4L343.2 136.2zM224 96a32 32 0 1 1 64 0 32 32 0 1 1 -64 0zM356.7 365.9l56.6 97.8c4.7 8.1 11.7 14.7 20.1 18.9l55.4 27.7c5 2.5 10.9 2.2 15.6-.7s7.6-8.1 7.6-13.6l0-55.4c0-8.4-2.2-16.7-6.5-24.1l-60-103.7c-25.9 22.7-55.9 40.8-88.8 53z"]]
}, faDraftingCompass = faCompassDrafting, faPlateWheat = {
  prefix: "fad",
  iconName: "plate-wheat",
  icon: [512, 512, [], "e55a", ["M0 160c0-13.3 10.7-24 24-24l112 0c13.3 0 24 10.7 24 24s-10.7 24-24 24L24 184c-13.3 0-24-10.7-24-24zM32 88c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zm0 144c0-13.3 10.7-24 24-24l48 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-48 0c-13.3 0-24-10.7-24-24zM160 48c0-8.8 7.2-16 16-16c44.2 0 80 35.8 80 80l0 16c0 8.8-7.2 16-16 16c-44.2 0-80-35.8-80-80l0-16zm0 208c0-44.2 35.8-80 80-80c8.8 0 16 7.2 16 16l0 16c0 44.2-35.8 80-80 80c-8.8 0-16-7.2-16-16l0-16zM272 48c0-8.8 7.2-16 16-16c44.2 0 80 35.8 80 80l0 16c0 8.8-7.2 16-16 16c-44.2 0-80-35.8-80-80l0-16zm0 208c0-44.2 35.8-80 80-80c8.8 0 16 7.2 16 16l0 16c0 44.2-35.8 80-80 80c-8.8 0-16-7.2-16-16l0-16zM384 48c0-8.8 7.2-16 16-16c44.2 0 80 35.8 80 80l0 16c0 8.8-7.2 16-16 16c-44.2 0-80-35.8-80-80l0-16zm0 208c0-44.2 35.8-80 80-80c8.8 0 16 7.2 16 16l0 16c0 44.2-35.8 80-80 80c-8.8 0-16-7.2-16-16l0-16z", "M27.8 320C13 320 1.6 332.9 3.5 347.6C9.7 397.8 47.8 437 96 446l0 2c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-2c48.2-9 86.3-48.2 92.6-98.4c1.8-14.7-9.6-27.6-24.4-27.6L27.8 320z"]]
}, faCalendarCircleMinus = {
  prefix: "fad",
  iconName: "calendar-circle-minus",
  icon: [576, 512, [], "e46f", ["M0 112l0 48 448 0 0-48c0-26.5-21.5-48-48-48l-48 0 0-32c0-17.7-14.3-32-32-32s-32 14.3-32 32l0 32L160 64l0-32c0-17.7-14.3-32-32-32S96 14.3 96 32l0 32L48 64C21.5 64 0 85.5 0 112zm0 80L0 464c0 26.5 21.5 48 48 48l282.8 0C285.6 480.1 256 427.5 256 368c0-91.8 70.3-167.2 160-175.3l0-.7L0 192z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm64-128l-128 0c-8.8 0-16-7.2-16-16s7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16z"]]
}, faChopsticks = {
  prefix: "fad",
  iconName: "chopsticks",
  icon: [640, 512, [], "e3f7", ["M0 496c0 4.7 2.1 9.4 6.1 12.6C9 510.9 12.5 512 16 512c4.7 0 9.4-2.1 12.6-6.1c89.3-101.4 178.5-202.7 267.8-304c-20.2-16.1-40.3-32.3-60.5-48.4C158.4 264.4 80.9 375.2 3.4 486.1C1.1 489 0 492.5 0 496zm131.9 10.4c5.8 6.7 15.9 7.5 22.6 1.7c106-81.3 211.9-162.6 317.9-243.9c-17.8-17.8-35.5-35.5-53.2-53.2L133.6 483.9c-6.7 5.8-7.5 15.8-1.7 22.6z", "M296.3 201.9l-60.5-48.4L330.3 18.3C339 7.2 352.7 0 368 0c26.5 0 48 21.5 48 48c0 11.2-3.8 21.5-10.3 29.7L296.3 201.9zm175.9 62.4L419 211 560.8 75.6C569.2 68.4 580.1 64 592 64c26.5 0 48 21.5 48 48c0 14.6-6.5 27.6-16.8 36.4l-151 115.8z"]]
}, faCarWrench = {
  prefix: "fad",
  iconName: "car-wrench",
  icon: [512, 512, ["car-mechanic"], "f5e3", ["M10.9 43c0 6.9 6.4 13 14.6 13L56 56c13.3 0 24 10.7 24 24s-10.7 24-24 24l-30.5 0c-8.2 0-14.6 6.1-14.6 13c0 2.2 .6 4.5 2.1 6.6C27.2 145.5 51.9 160 80 160c29.1 0 54.5-15.5 68.5-38.7c3.3-5.4 8.9-9.3 15.3-9.3l184.4 0c6.4 0 12 3.8 15.3 9.3c14 23.2 39.5 38.7 68.5 38.7c28.1 0 52.8-14.5 67.1-36.4c1.4-2.2 2.1-4.4 2.1-6.6c0-6.9-6.4-13-14.6-13L456 104c-13.3 0-24-10.7-24-24s10.7-24 24-24l30.5 0c8.2 0 14.6-6.1 14.6-13c0-2.2-.6-4.5-2.1-6.6C484.8 14.5 460.1 0 432 0c-29.1 0-54.5 15.5-68.5 38.7c-3.3 5.4-8.9 9.3-15.3 9.3L163.8 48c-6.4 0-12-3.8-15.3-9.3C134.5 15.5 109.1 0 80 0C51.9 0 27.2 14.5 12.9 36.4c-1.4 2.2-2.1 4.4-2.1 6.6z", "M170.8 234.6L151.7 288l208.6 0-19.1-53.4c-2.3-6.4-8.3-10.6-15.1-10.6l-140.3 0c-6.8 0-12.8 4.3-15.1 10.6zM82.2 292.4l28.3-79.3C121.9 181.3 152 160 185.8 160l140.3 0c33.8 0 64 21.3 75.3 53.1l28.3 79.3c20.1 8.5 34.2 28.4 34.2 51.6l0 40 0 64 0 32c0 17.7-14.3 32-32 32l-16 0c-17.7 0-32-14.3-32-32l0-32-256 0 0 32c0 17.7-14.3 32-32 32l-16 0c-17.7 0-32-14.3-32-32l0-32 0-64 0-40c0-23.2 14.1-43.1 34.2-51.6zM152 368a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm232 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48z"]]
}, faCarMechanic = faCarWrench, faIcicles = {
  prefix: "fad",
  iconName: "icicles",
  icon: [512, 512, [], "f7ad", ["M336 160c8.3-41.7 16.7-83.4 25-125.2c.4-1.9 .6-3.8 .6-5.7c0-14.4-10.5-26.4-24.3-28.7c1.6-.3 3.2-.4 4.8-.4L482.4 0C498.8 0 512 13.2 512 29.6c0 1.6-.1 3.3-.4 4.9L434.6 496.1c-1.5 9.2-9.5 15.9-18.8 15.9c-9.2 0-17.1-6.6-18.7-15.6L336 160z", "M75.8 304.8L1 35.7c-.7-2.5-1-5-1-7.5C0 12.6 12.6 0 28.2 0H332.5c16.1 0 29.1 13 29.1 29.1c0 1.9-.2 3.8-.6 5.7L336 160 307.2 303.9c-1.9 9.3-10.1 16.1-19.6 16.1c-9.2 0-17.2-6.2-19.4-15.1L240 192 210.6 368.2c-1.5 9.1-9.4 15.8-18.6 15.8s-17.1-6.7-18.6-15.8L144 192 115.9 304.3c-2.3 9.2-10.6 15.7-20.1 15.7c-9.3 0-17.5-6.2-20-15.2z"]]
}, faPersonShelter = {
  prefix: "fad",
  iconName: "person-shelter",
  icon: [512, 512, [], "e54f", ["M130.9 340.6c-6.3 11.7-1.9 26.2 9.8 32.5s26.2 1.9 32.5-9.8L200 313.5 200 488c0 13.3 10.7 24 24 24s24-10.7 24-24l0-88 16 0 0 88c0 13.3 10.7 24 24 24s24-10.7 24-24l0-174.5 26.9 49.9c6.3 11.7 20.8 16 32.5 9.8c8.1-4.3 12.6-12.6 12.6-21.2c0-3.8-.9-7.7-2.9-11.4l-37.9-70.3c-15.3-28.5-45.1-46.3-77.5-46.3l-19.5 0c-32.4 0-62.1 17.8-77.5 46.3l-37.9 70.3zM216 168a40 40 0 1 0 80 0 40 40 0 1 0 -80 0z", "M240.1 4.2c9.8-5.6 21.9-5.6 31.8 0l224 128c10 5.7 16.1 16.3 16.1 27.8l0 320c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-301.4L256 68.9 64 178.6 64 480c0 17.7-14.3 32-32 32s-32-14.3-32-32L0 160c0-11.5 6.2-22.1 16.1-27.8l224-128z"]]
}, faNeuter = {
  prefix: "fad",
  iconName: "neuter",
  icon: [384, 512, [9906], "f22c", ["M112 176a80 80 0 1 0 160 0 80 80 0 1 0 -160 0z", "M80 176a112 112 0 1 1 224 0A112 112 0 1 1 80 176zM224 349.1c81.9-15 144-86.8 144-173.1C368 78.8 289.2 0 192 0S16 78.8 16 176c0 86.3 62.1 158.1 144 173.1L160 480c0 17.7 14.3 32 32 32s32-14.3 32-32l0-130.9z"]]
}, faIdBadge = {
  prefix: "fad",
  iconName: "id-badge",
  icon: [384, 512, [], "f2c1", ["M0 64L0 448c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-384c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zM80 400c0-44.2 35.8-80 80-80l64 0c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16L96 416c-8.8 0-16-7.2-16-16zM128 80c0-8.8 7.2-16 16-16l96 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-96 0c-8.8 0-16-7.2-16-16zM256 224a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M192 288a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-32 32c-44.2 0-80 35.8-80 80c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16c0-44.2-35.8-80-80-80l-64 0z"]]
}, faKazoo = {
  prefix: "fad",
  iconName: "kazoo",
  icon: [640, 512, [], "f8c7", ["M0 216l0 80c0 14.2 9.4 26.7 23 30.7l192 56c2.9 .8 5.9 1.3 9 1.3l158 0c-46.3-23.9-78-72.3-78-128c0-1.7 0-3.5 .1-5.2s.2-3.4 .3-5.2c.2-3.4 .6-6.8 1.1-10.2c1-6.7 2.4-13.3 4.2-19.6c3.7-12.7 9.1-24.8 15.9-35.8C339.3 158 358.8 140 382 128l-158 0c-3 0-6 .4-9 1.3l-192 56C9.4 189.3 0 201.8 0 216zm404.7-3.3c-6.2 6.2-6.2 16.4 0 22.6L425.4 256l-20.7 20.7c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0L448 278.6l20.7 20.7c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6L470.6 256l20.7-20.7c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0L448 233.4l-20.7-20.7c-6.2-6.2-16.4-6.2-22.6 0zM514 128c46.3 23.9 78 72.3 78 128c0 1.7 0 3.5-.1 5.2s-.2 3.4-.3 5.2c-.2 3.4-.6 6.8-1.1 10.2c-1 6.7-2.4 13.3-4.2 19.6c-3.7 12.7-9.1 24.8-15.9 35.8C556.7 354 537.2 372 514 384l94 0c17.7 0 32-14.3 32-32l0-192c0-17.7-14.3-32-32-32l-94 0z", "M448 400a144 144 0 1 0 0-288 144 144 0 1 0 0 288zm0-240a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]]
}, faMarker = {
  prefix: "fad",
  iconName: "marker",
  icon: [512, 512, [], "f5a1", ["M0 488c0 6.3 2.5 12.4 7 17s10.7 7 17 7c1.6 0 3.1-.2 4.7-.5l25-5c66.6-13.3 127.8-46.1 175.8-94.1L305 337C261.7 293.7 218.4 250.4 175 207L99.5 282.5c-48 48-80.8 109.2-94.1 175.8l-5 25c-.3 1.6-.5 3.1-.5 4.7z", "M481 31C445.1-4.8 386.9-4.8 351 31l-15 15L322.9 33C294.8 4.9 249.2 4.9 221.1 33L135 119c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L255 66.9c9.4-9.4 24.6-9.4 33.9 0L302.1 80 175 207 305 337 481 161c35.9-35.9 35.9-94.1 0-129.9z"]]
}, faBinBottles = {
  prefix: "fad",
  iconName: "bin-bottles",
  icon: [640, 512, [], "e5f5", ["M32 192l320 0c0-26.5-10.7-50.5-28.1-67.9c-1.1-1.1-2.1-2.1-3.2-3.1c-17.1-15.5-39.7-25-64.6-25L128 96c-53 0-96 43-96 96zM112 48c0 8.8 7.2 16 16 16l128 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l0-8c0-13.3-10.7-24-24-24L152 0c-13.3 0-24 10.7-24 24l0 8c-8.8 0-16 7.2-16 16zM335.4 91.6C365 115.1 384 151.3 384 192l191.1 0c-1.2-9.7-4.6-18.7-9.6-26.5c6.4-9.5 10.1-21 10.1-33.3c0-23.2-13.4-44.3-34.4-54.2L528 71.8c-5.3-2.5-10.8-4.4-16.4-5.7l0-42.1c0-13.3-10.7-24-24-24l-80 0c-13.3 0-24 10.7-24 24l0 42.1c-5.6 1.3-11.1 3.2-16.4 5.7L354.1 78c-7.2 3.4-13.5 8-18.6 13.6z", "M32 224c-17.7 0-32 14.3-32 32s14.3 32 32 32L56.2 457c4.5 31.5 31.5 55 63.4 55l401 0c31.8 0 58.9-23.4 63.4-55L608 288c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 224z"]]
}, faFaceLaughBeam = {
  prefix: "fad",
  iconName: "face-laugh-beam",
  icon: [512, 512, [128513, "laugh-beam"], "f59a", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm96.8 58.1c-3.8-13.7 7.4-26.1 21.6-26.1l275.2 0c14.2 0 25.5 12.4 21.6 26.1C396.2 382 332.1 432 256 432s-140.2-50-159.2-117.9zM120 208c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l-.2-.3c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .3c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6zm160 0c0-17.9 6.7-35.6 16.6-48.8c9.8-13 23.9-23.2 39.4-23.2s29.6 10.2 39.4 23.2c9.9 13.2 16.6 30.9 16.6 48.8c0 3.4-2.2 6.5-5.5 7.6s-6.9 0-8.9-2.8l-.2-.3c-.2-.2-.4-.5-.7-.9c-.6-.8-1.6-2-2.8-3.4c-2.5-2.8-6-6.6-10.2-10.3c-8.8-7.8-18.8-14-27.7-14s-18.9 6.2-27.7 14c-4.2 3.7-7.7 7.5-10.2 10.3c-1.2 1.4-2.2 2.6-2.8 3.4c-.3 .4-.6 .7-.7 .9l-.2 .3c-2.1 2.8-5.7 3.9-8.9 2.8s-5.5-4.1-5.5-7.6z", "M217.6 212.8s0 0 0 0s0 0 0 0s0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C126.7 172.4 120 190.1 120 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2c0 0 0 0 0 0zm160 0s0 0 0 0s0 0 0 0s0 0 0 0c2.1 2.8 5.7 3.9 8.9 2.8s5.5-4.1 5.5-7.6c0-17.9-6.7-35.6-16.6-48.8c-9.8-13-23.9-23.2-39.4-23.2s-29.6 10.2-39.4 23.2C286.7 172.4 280 190.1 280 208c0 3.4 2.2 6.5 5.5 7.6s6.9 0 8.9-2.8c0 0 0 0 0 0s0 0 0 0c0 0 0 0 0 0l.2-.2c.2-.2 .4-.5 .7-.9c.6-.8 1.6-2 2.8-3.4c2.5-2.8 6-6.6 10.2-10.3c8.8-7.8 18.8-14 27.7-14s18.9 6.2 27.7 14c4.2 3.7 7.7 7.5 10.2 10.3c1.2 1.4 2.2 2.6 2.8 3.4c.3 .4 .6 .7 .7 .9l.2 .2c0 0 0 0 0 0z"]]
}, faLaughBeam = faFaceLaughBeam, faSquareArrowDownLeft = {
  prefix: "fad",
  iconName: "square-arrow-down-left",
  icon: [448, 512, [], "e261", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm112 88c0-13.3 10.7-24 24-24s24 10.7 24 24l0 102.1L295 151c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7s7 10.8 7 17s-2.3 12.3-7 17l-135 135 94.1 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-152 0c-13.3 0-24-10.7-24-24l0-160z", "M136 368l152 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-94.1 0L329 185c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-135 135L160 184c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 160c0 13.3 10.7 24 24 24z"]]
}, faBatteryBolt = {
  prefix: "fad",
  iconName: "battery-bolt",
  icon: [576, 512, [], "f376", ["M0 176L0 336c0 44.2 35.8 80 80 80l92.2 0c-12.9-14.5-16.1-35.6-7.2-53.5l5.3-10.5L80 352c-8.8 0-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16l139.2 0 80-64L80 96C35.8 96 0 131.8 0 176zM244.8 416L464 416c44.2 0 80-35.8 80-80l0-16c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-16c0-44.2-35.8-80-80-80l-92.2 0c13 14.5 16.1 35.6 7.2 53.5L373.7 160l90.3 0c8.8 0 16 7.2 16 16l0 160c0 8.8-7.2 16-16 16l-139.2 0-80 64z", "M350.3 135.2c3.4-6.7 1.6-14.9-4.2-19.6s-14.2-4.7-20.1-.1l-160 128c-5.3 4.2-7.4 11.4-5.1 17.8s8.3 10.7 15.1 10.7l70.1 0L193.7 376.8c-3.4 6.7-1.6 14.9 4.3 19.6s14.2 4.7 20.1 .1l160-128c5.3-4.2 7.4-11.4 5.1-17.8s-8.3-10.7-15.1-10.7l-70.1 0 52.4-104.8z"]]
}, faTreeLarge = {
  prefix: "fad",
  iconName: "tree-large",
  icon: [448, 512, [], "f7dd", ["M0 487.1C0 500.9 11.1 512 24.9 512L192 512l0-288c0-17.7 14.3-32 32-32s32 14.3 32 32l0 288 167.1 0c13.7 0 24.9-11.1 24.9-24.9c0-4.7-1.3-9.2-3.8-13.2L368 352l31.8 0c13.4 0 24.2-10.9 24.2-24.2c0-5-1.6-10-4.5-14.1L344 208l24.9 0c12.7 0 23.1-10.3 23.1-23.1c0-5.7-2.1-11.3-6-15.5L237.4 5.9C234 2.1 229.1 0 224 0s-10 2.1-13.4 5.9L62 169.4c-3.9 4.2-6 9.8-6 15.5C56 197.7 66.3 208 79.1 208l24.9 0L28.5 313.7c-2.9 4.1-4.5 9-4.5 14.1C24 341.1 34.8 352 48.2 352L80 352 3.8 474c-2.5 4-3.8 8.5-3.8 13.2z", "M224 192c17.7 0 32 14.3 32 32l0 288-64 0 0-288c0-17.7 14.3-32 32-32z"]]
}, faHelicopterSymbol = {
  prefix: "fad",
  iconName: "helicopter-symbol",
  icon: [512, 512, [], "e502", ["M2 224l64.7 0C80.1 143.6 143.6 80.1 224 66.7L224 2C108.2 16.4 16.4 108.2 2 224zm0 64C16.4 403.8 108.2 495.6 224 510l0-64.7C143.6 431.9 80.1 368.4 66.7 288L2 288zM288 2l0 64.7C368.4 80.1 431.9 143.6 445.3 224l64.7 0C495.6 108.2 403.8 16.4 288 2zm0 443.4l0 64.7c115.8-14.4 207.6-106.2 222-222l-64.7 0C431.9 368.4 368.4 431.9 288 445.3z", "M176 128c17.7 0 32 14.3 32 32l0 64 96 0 0-64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 192c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-64-96 0 0 64c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-192c0-17.7 14.3-32 32-32z"]]
}, faAperture = {
  prefix: "fad",
  iconName: "aperture",
  icon: [512, 512, [], "e2df", ["M0 256c0 17.8 1.8 35.2 5.3 51.9c1.5 7.2 7.9 12.1 15.2 12.1l133.9 0c12.3 0 20-13.3 13.9-24L66.1 119c-5.7-9.8-19.4-10.7-25.6-1.2C14.9 157.7 0 205.1 0 256zM232.3 489c-5.7 9.8 .4 22.2 11.8 22.8c3.9 .2 7.9 .3 11.9 .3c65.4 0 125.1-24.5 170.3-64.9c5.4-4.9 6.5-12.9 2.9-19.2L362.2 312c-6.2-10.7-21.6-10.7-27.7 0L232.3 489zm19-353c-6.2 10.7 1.5 24 13.9 24l204.4 0c11.3 0 19-11.5 13.8-21.6C453 79.5 400.2 34 336.4 12.9c-6.9-2.3-14.4 .8-18 7.1l-67 116z", "M256 0c4 0 7.9 .1 11.9 .3c11.3 .5 17.4 12.9 11.8 22.8L177.5 200c-6.2 10.7-21.6 10.7-27.7 0L82.8 84.1c-3.6-6.3-2.6-14.3 2.9-19.2C130.9 24.5 190.6 0 256 0zM193.6 492c-3.6 6.3-11.1 9.4-18 7.1C111.8 478 59 432.5 28.5 373.6C23.3 363.5 31 352 42.3 352l204.4 0c12.3 0 20 13.3 13.9 24l-67 116zm277.9-97.8c-6.1 9.5-19.9 8.6-25.6-1.2L343.8 216c-6.2-10.7 1.5-24 13.9-24l133.9 0c7.3 0 13.7 4.9 15.2 12.1c3.5 16.8 5.3 34.1 5.3 51.9c0 50.9-14.9 98.3-40.5 138.2z"]]
}, faUniversalAccess = {
  prefix: "fad",
  iconName: "universal-access",
  icon: [512, 512, [], "f29a", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128-64c0-3.2 .6-6.4 1.9-9.4c5.2-12.2 19.3-17.8 31.5-12.6c4 1.7 7.9 3.4 11.9 5.1c26.1 11.2 54.2 17 82.7 17s56.5-5.8 82.7-17c4-1.7 7.9-3.4 11.9-5.1c12.2-5.2 26.3 .4 31.5 12.6c.7 1.5 1.1 3.1 1.5 4.7c.2 1.2 .4 2.4 .4 2.3c.1 1.2 .1 1.2 .1 2.5c0 1.2 0 1.4-.1 1.7c0 .5-.1 1.1-.2 1.7c-.2 1.1-.4 2.3-.7 3.4c-.7 2.2-1.6 4.3-2.9 6.2c-2.5 3.9-6.1 7.1-10.7 9c-4 1.7-7.9 3.4-11.9 5.1c-17.3 7.4-35.2 12.9-53.6 16.3c0 16.7 0 33.4 0 50.1c0 4.3 .7 8.6 2.1 12.6l28.7 86.1c4.2 12.6-2.6 26.2-15.2 30.4s-26.2-2.6-30.4-15.2c-8.1-24.4-16.3-48.8-24.4-73.2c-1.3-3.8-4.8-6.4-8.8-6.4s-7.6 2.6-8.8 6.4c-8.1 24.4-16.3 48.8-24.4 73.2c-4.2 12.6-17.8 19.4-30.4 15.2s-19.4-17.8-15.2-30.4c9.6-28.7 19.1-57.4 28.7-86.2c.7-2 1.2-4.1 1.5-6.3c.2-1.1 .3-2.1 .4-3.2c.1-2.1 .1-2.7 .1-3.2c0-16.7 0-33.4 0-50.1c-18.4-3.5-36.3-8.9-53.6-16.3c-4-1.7-7.9-3.4-11.9-5.1c-9.1-3.9-14.6-12.8-14.6-22.1zm88-72c0-22.1 17.9-40 40-40c11 0 21 4.5 28.3 11.7c3.6 3.6 6.5 7.9 8.6 12.7c1 2.4 1.8 4.9 2.3 7.5c.3 1.3 .5 2.6 .6 4c.1 .7 .1 1.4 .2 2s0 1.3 .1 1.7l0 .4 0 .4c0 .4 0 1-.1 1.7c0 .7-.1 1.3-.2 2c-.1 1.3-.3 2.7-.6 4c-.5 2.6-1.3 5.1-2.3 7.5c-2 4.8-5 9.1-8.6 12.7C277 155.5 267 160 256 160c-22.1 0-40-17.9-40-40z", "M256 80a40 40 0 1 1 0 80 40 40 0 1 1 0-80zM129.9 182.5c5.2-12.2 19.3-17.8 31.5-12.6l11.9 5.1c26.1 11.2 54.2 17 82.7 17s56.5-5.8 82.7-17l11.9-5.1c12.2-5.2 26.3 .4 31.5 12.6s-.4 26.3-12.6 31.5l-11.9 5.1c-17.3 7.4-35.2 12.9-53.6 16.3l0 50.1c0 4.3 .7 8.6 2.1 12.6l28.7 86.1c4.2 12.6-2.6 26.2-15.2 30.4s-26.2-2.6-30.4-15.2l-24.4-73.2c-1.3-3.8-4.8-6.4-8.8-6.4s-7.6 2.6-8.8 6.4l-24.4 73.2c-4.2 12.6-17.8 19.4-30.4 15.2s-19.4-17.8-15.2-30.4l28.7-86.1c1.4-4.1 2.1-8.3 2.1-12.6l0-50.1c-18.4-3.5-36.3-8.9-53.6-16.3l-11.9-5.1c-12.2-5.2-17.8-19.3-12.6-31.5z"]]
}, faGearComplex = {
  prefix: "fad",
  iconName: "gear-complex",
  icon: [512, 512, [], "e5e9", ["M192 256a64 64 0 1 0 128 0 64 64 0 1 0 -128 0z", "M305.4 21.8c-1.3-10.4-9.1-18.8-19.5-20C276.1 .6 266.1 0 256 0c-11.1 0-22.1 .7-32.8 2.1c-10.3 1.3-18 9.7-19.3 20l-2.9 23.1c-.8 6.4-5.4 11.6-11.5 13.7c-9.6 3.2-19 7.2-27.9 11.7c-5.8 3-12.8 2.5-18-1.5l-18-14c-8.2-6.4-19.7-6.8-27.9-.4c-16.6 13-31.5 28-44.4 44.7c-6.3 8.2-5.9 19.6 .5 27.8l14.2 18.3c4 5.1 4.4 12 1.5 17.8c-4.4 8.8-8.2 17.9-11.3 27.4c-2 6.2-7.3 10.8-13.7 11.6l-22.8 2.9c-10.3 1.3-18.7 9.1-20 19.4C.7 234.8 0 245.3 0 256c0 10.6 .6 21.1 1.9 31.4c1.3 10.3 9.7 18.1 20 19.4l22.8 2.9c6.4 .8 11.7 5.4 13.7 11.6c3.1 9.5 6.9 18.7 11.3 27.5c2.9 5.8 2.4 12.7-1.5 17.8L54 384.8c-6.4 8.2-6.8 19.6-.5 27.8c12.9 16.7 27.8 31.7 44.4 44.7c8.2 6.4 19.7 6 27.9-.4l18-14c5.1-4 12.2-4.4 18-1.5c9 4.6 18.3 8.5 27.9 11.7c6.1 2.1 10.7 7.3 11.5 13.7l2.9 23.1c1.3 10.3 9 18.7 19.3 20c10.7 1.4 21.7 2.1 32.8 2.1c10.1 0 20.1-.6 29.9-1.7c10.4-1.2 18.2-9.7 19.5-20l2.8-22.5c.8-6.5 5.5-11.8 11.7-13.8c10-3.2 19.7-7.2 29-11.8c5.8-2.9 12.7-2.4 17.8 1.5L385 457.9c8.2 6.4 19.6 6.8 27.8 .5c2.8-2.2 5.5-4.4 8.2-6.7L451.7 421c1.8-2.2 3.6-4.4 5.4-6.6c6.5-8.2 6-19.7-.4-27.9l-14-17.9c-4-5.1-4.4-12.2-1.5-18c4.8-9.4 9-19.3 12.3-29.5c2-6.2 7.3-10.8 13.7-11.6l22.8-2.8c10.3-1.3 18.8-9.1 20-19.4c.2-1.7 .4-3.5 .6-5.2l0-51.9c-.2-1.7-.4-3.5-.6-5.2c-1.3-10.3-9.7-18.1-20-19.4l-22.8-2.8c-6.4-.8-11.7-5.4-13.7-11.6c-3.4-10.2-7.5-20.1-12.3-29.5c-3-5.8-2.5-12.8 1.5-18l14-17.9c6.4-8.2 6.8-19.7 .4-27.9c-1.8-2.2-3.6-4.4-5.4-6.6L421 60.3c-2.7-2.3-5.4-4.5-8.2-6.7c-8.2-6.4-19.6-5.9-27.8 .5L366.7 68.3c-5.1 4-12.1 4.4-17.8 1.5c-9.3-4.6-19-8.6-29-11.8c-6.2-2-10.9-7.3-11.7-13.7l-2.8-22.5zM256 160a96 96 0 1 1 0 192 96 96 0 1 1 0-192z"]]
}, faFileMagnifyingGlass = {
  prefix: "fad",
  iconName: "file-magnifying-glass",
  icon: [384, 512, ["file-search"], "f865", ["M0 64C0 28.7 28.7 0 64 0L224 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64L64 512c-35.3 0-64-28.7-64-64L0 64zM80 304c0 53 43 96 96 96c17.8 0 34.4-4.8 48.7-13.2L263 425.1c4.7 4.7 10.8 7 17 7s12.3-2.3 17-7c9.4-9.4 9.4-24.6 0-33.9l-38.3-38.3c8.5-14.3 13.3-31 13.3-48.9c0-53-43-96-96-96s-96 43-96 96zm144 0a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M384 160l-128 0c-17.7 0-32-14.3-32-32L224 0 384 160zM272 304c0 17.8-4.9 34.5-13.3 48.9L297 391.2c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-38.4-38.4C210.4 395.2 193.8 400 176 400c-53 0-96-43-96-96s43-96 96-96s96 43 96 96zm-96 48a48 48 0 1 0 0-96 48 48 0 1 0 0 96z"]]
}, faFileSearch = faFileMagnifyingGlass, faUpRight = {
  prefix: "fad",
  iconName: "up-right",
  icon: [384, 512, [], "e2be", ["M0 368c0 10.2 4.1 20.1 11.3 27.3l41.4 41.4C59.9 443.9 69.8 448 80 448s20.1-4.1 27.3-11.3L241.4 302.6c-32-32-64-64-96-96L11.3 340.7C4.1 347.9 0 357.8 0 368z", "M336 80H96c-12.9 0-24.6 7.8-29.6 19.8s-2.2 25.7 6.9 34.9l240 240c9.2 9.2 22.9 11.9 34.9 6.9s19.8-16.6 19.8-29.6V112c0-17.7-14.3-32-32-32z"]]
}, faCircleChevronUp = {
  prefix: "fad",
  iconName: "circle-chevron-up",
  icon: [512, 512, ["chevron-circle-up"], "f139", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128 32c0-6.1 2.3-12.3 7-17L239 167c4.7-4.7 10.8-7 17-7s12.3 2.3 17 7L377 271c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17s-10.8 7-17 7s-12.3-2.3-17-7l-87-87-87 87c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7s-7-10.8-7-17z", "M239 167c9.4-9.4 24.6-9.4 33.9 0L377 271c9.4 9.4 9.4 24.6 0 33.9s-24.6 9.4-33.9 0l-87-87-87 87c-9.4 9.4-24.6 9.4-33.9 0s-9.4-24.6 0-33.9L239 167z"]]
}, faChevronCircleUp = faCircleChevronUp, faUserPolice = {
  prefix: "fad",
  iconName: "user-police",
  icon: [448, 512, [], "e333", ["M96 192c0-13 1.9-25.5 5.5-37.2c23.9 9.6 62.8 20.1 113.9 21.1c2.7 .1 5.5 .1 8.2 .1l.4 0 .4 0c2.7 0 5.5 0 8.2-.1c51.1-1.1 90.1-11.5 113.9-21.1c3.6 11.8 5.5 24.3 5.5 37.2c0 70.7-57.3 128-128 128s-128-57.3-128-128z", "M230.1 .8c-4-1.1-8.2-1.1-12.2 0l-152 40c-8.6 2.3-15.3 9.1-17.3 17.8s1 17.8 7.8 23.6l23.8 20.4c-.1 1-.1 2-.1 3.1l0 21.2c0 10.7 5.3 20.8 15.1 25.2c24.1 10.8 68.6 24 128.9 24s104.8-13.2 128.9-24c9.8-4.4 15.1-14.5 15.1-25.2l0-21.2c0-1-.1-2.1-.1-3.1l23.8-20.4c6.8-5.8 9.8-14.9 7.8-23.6s-8.7-15.6-17.3-17.8l-152-40zM227 48.6l32 12.8c3 1.2 5 4.2 5 7.4c0 17.2-7 46.1-36.9 58.6c-2 .8-4.2 .8-6.2 0C191 114.9 184 86 184 68.8c0-3.3 2-6.2 5-7.4l32-12.8c1.9-.8 4-.8 5.9 0zm-84.9 306c-2.2-1.7-4.9-2.6-7.7-2.6C60.2 352 0 412.2 0 486.4C0 500.5 11.5 512 25.6 512l396.8 0c14.1 0 25.6-11.5 25.6-25.6C448 412.2 387.8 352 313.6 352c-2.8 0-5.5 .9-7.7 2.6l-72.3 54.2c-5.7 4.3-13.5 4.3-19.2 0l-72.3-54.2zm217.5 59l5.4 16.6 17.4 0c3.5 0 6.6 2.2 7.6 5.5s-.1 6.9-2.9 9L373 454.8l5.4 16.6c1.1 3.3-.1 6.9-2.9 9s-6.6 2-9.4 0L352 470.1l-14.1 10.3c-2.8 2-6.6 2.1-9.4 0s-4-5.7-2.9-9l5.4-16.6-14.1-10.2c-2.8-2-4-5.7-2.9-9s4.2-5.5 7.6-5.5l17.4 0 5.4-16.6c1.1-3.3 4.1-5.5 7.6-5.5s6.5 2.2 7.6 5.5z"]]
}, faLariSign = {
  prefix: "fad",
  iconName: "lari-sign",
  icon: [384, 512, [], "e1c8", ["M112 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 32.7c-22.7 1.9-44.2 7.7-64 16.8L112 64zm0 124.1c18-14.4 40-24.1 64-27.1l0 95c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-67.9zM208 64c0-17.7 14.3-32 32-32s32 14.3 32 32l0 49.4c-19.8-9.1-41.3-14.9-64-16.8L208 64zm0 97c24 3 46 12.7 64 27.1l0 67.9c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-95z", "M64 288c0-70.7 57.3-128 128-128c61.9 0 113.6 44 125.4 102.4c3.5 17.3 20.4 28.5 37.7 25s28.5-20.4 25-37.7C362.4 162 284.9 96 192 96C86 96 0 182 0 288c0 49.2 18.5 94 48.9 128L32 416c-17.7 0-32 14.3-32 32s14.3 32 32 32l160 0 160 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-160 0c-70.7 0-128-57.3-128-128z"]]
}, faVolcano = {
  prefix: "fad",
  iconName: "volcano",
  icon: [512, 512, [127755], "f770", ["M0 459.8C0 488.6 23.4 512 52.2 512l407.7 0c28.8 0 52.2-23.4 52.2-52.2c0-12.8-4.7-25.1-13.2-34.7l-99.6-112L362 369c-6.3 9.4-16.8 15-28 15c-8.9 0-17.5-3.6-23.8-9.9c-11.5-11.5-23-23-34.5-34.5C263.1 327.1 246 320 228.3 320c-13.2 0-26.1 3.9-37.1 11.2l-17.8 11.9c-8.7 5.8-18.9 8.9-29.3 8.9s-20.6-3.1-29.3-8.9c-6-4-12-8-17.9-12l-83.6 94C4.7 434.7 0 447.1 0 459.8z", "M160 144c14.7 0 28.3-5 39.1-13.3l32 48C236.7 187 246 192 256 192s19.3-5 24.9-13.3l32-48C323.7 139 337.3 144 352 144c35.3 0 64-28.7 64-64s-28.7-64-64-64c-15.7 0-30 5.6-41.2 15C299.6 12.4 279.3 0 256 0s-43.6 12.4-54.8 31C190 21.6 175.7 16 160 16c-35.3 0-64 28.7-64 64s28.7 64 64 64zm31.1 187.2c11-7.3 23.9-11.2 37.1-11.2c17.8 0 34.8 7.1 47.3 19.6l34.5 34.5c6.3 6.3 14.9 9.9 23.8 9.9c11.3 0 21.8-5.6 28-15l37.2-55.8-50.6-56.9c-18.2-20.5-44.3-32.2-71.8-32.2l-41.8 0c-27.4 0-53.5 11.7-71.8 32.2L96.7 331.2l17.9 12c8.7 5.8 18.9 8.9 29.3 8.9s20.6-3.1 29.3-8.9l17.8-11.9z"]]
}, faTeddyBear = {
  prefix: "fad",
  iconName: "teddy-bear",
  icon: [576, 512, [], "e3cf", ["M128 56c0-30.9 25.1-56 56-56c24.2 0 44.7 15.3 52.6 36.7c-41.5 8.5-72.8 29.1-81.9 67C138.7 93.9 128 76.2 128 56zm64 360c0-35.3 28.7-64 64-64l64 0c35.3 0 64 28.7 64 64l-192 0zm32-240c0-26.5 28.7-48 64-48s64 21.5 64 48s-28.7 48-64 48s-64-21.5-64-48zm32-8c0 13.3 14.3 24 32 24s32-10.7 32-24s-14.3-24-32-24s-32 10.7-32 24zM339.4 36.7C347.3 15.3 367.8 0 392 0c30.9 0 56 25.1 56 56c0 20.2-10.7 37.9-26.7 47.7c-9.1-37.9-40.4-58.5-81.9-67z", "M288 256c-75.1 0-136-57.3-136-128s60.9-96 136-96s136 25.3 136 96s-60.9 128-136 128zM240 128a16 16 0 1 0 0-32 16 16 0 1 0 0 32zm112-16a16 16 0 1 0 -32 0 16 16 0 1 0 32 0zm0 64c0-26.5-28.7-48-64-48s-64 21.5-64 48s28.7 48 64 48s64-21.5 64-48zm-32-8c0 13.3-14.3 24-32 24s-32-10.7-32-24s14.3-24 32-24s32 10.7 32 24zM50.3 178.3c20.8-16.4 51-12.8 67.4 8L143.5 219c73.7 93.5 215.4 93.5 289.1 0l25.8-32.7c16.4-20.8 46.6-24.4 67.4-8s24.4 46.6 8 67.4l-25.8 32.7c-17.7 22.4-37.9 41.3-59.9 56.7l0 64.9 16.6 0c3.9-27.1 27.2-48 55.4-48c30.9 0 56 25.1 56 56c0 2.7-.2 5.4-.6 8l-13 53.3c-5.8 23.8-26.3 40.9-50.4 42.6l0 .1-4 0-28 0L96 512l-28 0-4 0 0-.1c-24.1-1.7-44.6-18.8-50.4-42.6L.6 416c-.4-2.6-.6-5.3-.6-8c0-30.9 25.1-56 56-56c28.2 0 51.6 20.9 55.4 48l16.6 0 0-64.9c-22-15.4-42.3-34.3-59.9-56.7L42.3 245.7c-16.4-20.8-12.8-51 8-67.4zM256 352c-35.3 0-64 28.7-64 64l192 0c0-35.3-28.7-64-64-64l-64 0z"]]
}, faStocking = {
  prefix: "fad",
  iconName: "stocking",
  icon: [384, 512, [], "f7d5", ["M0 386.9l0 2.2C0 457 55 512 122.8 512c24.2 0 48-7.2 68.1-20.6l66-44c-20.4-20.3-33-48.3-33-79.4c0-61.9 50.1-112 112-112c5.4 0 10.8 .4 16 1.1L352 96 96 96l0 142.9c0 10.7-5.3 20.7-14.2 26.6L55.7 282.9C20.9 306.1 0 345.1 0 386.9z", "M96 0C78.3 0 64 14.3 64 32l0 32c0 17.7 14.3 32 32 32l256 0c17.7 0 32-14.3 32-32l0-32c0-17.7-14.3-32-32-32L96 0zM352 315.5l0-58.4c-5.2-.7-10.6-1.1-16-1.1c-61.9 0-112 50.1-112 112c0 31 12.6 59.1 33 79.4L295 422c35.6-23.7 57-63.7 57-106.5z"]]
}, faPersonWalkingDashedLineArrowRight = {
  prefix: "fad",
  iconName: "person-walking-dashed-line-arrow-right",
  icon: [640, 512, [], "e553", ["M0 480c0 8.2 3.1 16.4 9.4 22.6c12.5 12.5 32.8 12.5 45.3 0L116.3 441c4.6-4.6 8.2-10.1 10.6-16.1l14.5-36.2-40.7-44.4c-2.5-2.7-4.8-5.6-7-8.6L68.7 398 9.4 457.4C3.1 463.6 0 471.8 0 480zM17.6 229.9c-5.6 16.8 3.5 34.9 20.2 40.5s34.9-3.5 40.5-20.2l2.6-7.8c5.7-17.1 18.3-30.9 34.7-38.2l8-3.5c1-.4 1.9-.8 2.9-1.2l-16.9 63.5c-5.6 21.1-.1 43.6 14.7 59.7l70.7 77.1 22 88.1c3.6 14.5 16.7 24.2 31 24.2c2.6 0 5.2-.3 7.8-1c17.1-4.3 27.6-21.7 23.3-38.8l-23-92.1c-1.9-7.8-5.8-14.9-11.2-20.8l-49.5-54 19.3-65.5 9.6 23c4.4 10.6 12.5 19.3 22.8 24.5l26.7 13.3c15.8 7.9 35 1.5 42.9-14.3s1.5-35-14.3-42.9L281 232.7l-15.3-36.8C248.5 154.8 208.3 128 163.7 128c-22.8 0-45.3 4.8-66.1 14l-8 3.5c-32.9 14.6-58.1 42.4-69.4 76.5l-2.6 7.8zM160 48a48 48 0 1 0 96 0 48 48 0 1 0 -96 0z", "M392 0c13.3 0 24 10.7 24 24l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24zM505.4 153.4c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3l-80 80c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3L530.7 288 384 288c-17.7 0-32-14.3-32-32s14.3-32 32-32l146.7 0-25.4-25.4c-12.5-12.5-12.5-32.8 0-45.3zM416 152l0 16c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-16c0-13.3 10.7-24 24-24s24 10.7 24 24zM392 320c13.3 0 24 10.7 24 24l0 16c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-16c0-13.3 10.7-24 24-24zm24 120l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-13.3 10.7-24 24-24s24 10.7 24 24z"]]
}, faImageSlash = {
  prefix: "fad",
  iconName: "image-slash",
  icon: [640, 512, [], "e1b7", ["M64 146.4L64 416c0 35.3 28.7 64 64 64l359.4 0-81.2-64L320 416l-72 0-96 0c-9.3 0-17.8-5.4-21.8-13.9s-2.6-18.5 3.5-25.6l88-104c.3-.4 .6-.7 1-1.1L64 146.4zM89.5 44.9c23.1 18.1 46.2 36.2 69.3 54.3c5.3-2 11.1-3.2 17.2-3.2c26.5 0 48 21.5 48 48c0 2-.1 4-.4 6c34.8 27.3 69.7 54.6 104.5 81.9l20-29.4c4.5-6.6 11.9-10.5 19.8-10.5s15.4 3.9 19.8 10.5L499.4 366.1l75.9 59.5c.5-3.1 .7-6.3 .7-9.6l0-320c0-35.3-28.7-64-64-64L128 32c-14.4 0-27.8 4.8-38.5 12.9z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faMaskSnorkel = {
  prefix: "fad",
  iconName: "mask-snorkel",
  icon: [576, 512, [], "e3b7", ["M288 384c0 1.7 .1 3.5 .4 5.3l.3 1.9c11.6 69.7 72 120.8 142.6 120.8C511.3 512 576 447.3 576 367.4L576 192l-64 0 0 175.4c0 44.5-36.1 80.6-80.6 80.6c-39.4 0-73-28.5-79.5-67.4l-.3-1.9c-2.9-17.4-19.4-29.2-36.8-26.3C299.1 355 288 368.6 288 384zM512 64l0 96 64 0 0-96c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M64 64C28.7 64 0 92.7 0 128l0 96c0 35.3 28.7 64 64 64l79.7 0c28.6 0 53.7-18.9 61.5-46.4l3.4-11.7c4.4-15.5 26.3-15.5 30.8 0l3.4 11.7c7.8 27.5 33 46.4 61.5 46.4l79.7 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64L64 64zm512 96l-64 0 0 32 64 0 0-32z"]]
}, faSmoke = {
  prefix: "fad",
  iconName: "smoke",
  icon: [640, 512, [], "f760", ["M32 128c0 32 11.7 61.2 31.1 83.6C87.3 199.1 114.8 192 144 192c9.6 0 19.1 .8 28.3 2.3C196.5 136.6 253.5 96 320 96c27.2 0 52.7 6.8 75.1 18.7c9.3-9.9 19.8-18.6 31.2-25.9C403.4 54.5 364.3 32 320 32c-22 0-42.6 5.5-60.7 15.3C235.9 18.4 200.1 0 160 0C89.3 0 32 57.3 32 128zm171.7 74.4c10.7 3.9 20.9 8.7 30.5 14.5C259.1 201.1 288.5 192 320 192c52.7 0 99.5 25.5 128.6 64.8c5.1-.5 10.2-.8 15.4-.8c52.9 0 99.1 28.5 124.1 70.9C619.6 303.6 640 266.2 640 224c0-70.7-57.3-128-128-128c-46.5 0-87.3 24.8-109.7 62c-22.3-18.7-51-30-82.3-30c-51.6 0-96 30.5-116.3 74.4z", "M0 368c0 79.5 64.5 144 144 144l320 0c61.9 0 112-50.1 112-112s-50.1-112-112-112c-10.7 0-21 1.5-30.8 4.3C411.8 251.7 369.1 224 320 224c-32.6 0-62.4 12.2-85.1 32.3C210.1 236.1 178.5 224 144 224C64.5 224 0 288.5 0 368z"]]
}, faSterlingSign = {
  prefix: "fad",
  iconName: "sterling-sign",
  icon: [320, 512, [163, "gbp", "pound-sign"], "f154", ["M0 256c0 17.7 14.3 32 32 32l16 0 0-64-16 0c-17.7 0-32 14.3-32 32zm112-32l0 64 112 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-112 0z", "M176.4 96c-35.5 0-64.4 28.8-64.4 64.4l0 172.2c0 29-7.9 57.5-22.8 82.3l-.7 1.1L288 416c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 480c-11.5 0-22.2-6.2-27.8-16.2s-5.5-22.3 .4-32.2l29.8-49.6c9-14.9 13.7-32 13.7-49.4l0-172.2C48 89.5 105.5 32 176.4 32c13.8 0 27.5 2.2 40.6 6.6l81.2 27.1c16.8 5.6 25.8 23.7 20.2 40.5s-23.7 25.8-40.5 20.2L196.7 99.3c-6.6-2.2-13.4-3.3-20.4-3.3z"]]
}, faGbp = faSterlingSign, faPoundSign = faSterlingSign, faBatteryExclamation = {
  prefix: "fad",
  iconName: "battery-exclamation",
  icon: [576, 512, [], "e0b0", ["M0 176L0 336c0 44.2 35.8 80 80 80l118.7 0c-4.3-9.8-6.7-20.6-6.7-32s2.4-22.2 6.7-32L80 352c-8.8 0-16-7.2-16-16l0-160c0-8.8 7.2-16 16-16l128 0 0-64L80 96C35.8 96 0 131.8 0 176zM336 96l0 64 128 0c8.8 0 16 7.2 16 16l0 160c0 8.8-7.2 16-16 16l-118.7 0c4.3 9.8 6.7 20.6 6.7 32s-2.4 22.2-6.7 32L464 416c44.2 0 80-35.8 80-80l0-16c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l0-16c0-44.2-35.8-80-80-80L336 96z", "M296 120c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 176c0 13.3 10.7 24 24 24s24-10.7 24-24l0-176zM272 416a32 32 0 1 0 0-64 32 32 0 1 0 0 64z"]]
}, faViruses = {
  prefix: "fad",
  iconName: "viruses",
  icon: [640, 512, [], "e076", ["M0 192c0 13.3 10.7 24 24 24l13.5 0c35.6 0 53.5 43.1 28.3 68.3l-9.5 9.5c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l9.5-9.5c25.2-25.2 68.3-7.4 68.3 28.3l0 13.5c0 13.3 10.7 24 24 24s24-10.7 24-24l0-13.5c0-35.6 43.1-53.5 68.3-28.3l9.5 9.5c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-9.5-9.5C293 259.1 310.9 216 346.5 216l13.5 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-13.5 0c-35.6 0-53.5-43.1-28.3-68.3l9.5-9.5c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-9.5 9.5C259.1 91 216 73.1 216 37.5L216 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 13.5c0 35.6-43.1 53.5-68.3 28.3l-9.5-9.5c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l9.5 9.5C91 124.9 73.1 168 37.5 168L24 168c-13.3 0-24 10.7-24 24zm192-32a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm64 48a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM448 352a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M160 192a32 32 0 1 0 0-64 32 32 0 1 0 0 64zm352 48c0-8.8-7.2-16-16-16s-16 7.2-16 16c0 33-39.9 49.5-63.2 26.2c-6.2-6.2-16.4-6.2-22.6 0s-6.2 16.4 0 22.6C417.5 312.1 401 352 368 352c-8.8 0-16 7.2-16 16s7.2 16 16 16c33 0 49.5 39.9 26.2 63.2c-6.2 6.2-6.2 16.4 0 22.6s16.4 6.2 22.6 0C440.1 446.5 480 463 480 496c0 8.8 7.2 16 16 16s16-7.2 16-16c0-33 39.9-49.5 63.2-26.2c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6C574.5 423.9 591 384 624 384c8.8 0 16-7.2 16-16s-7.2-16-16-16c-33 0-49.5-39.9-26.2-63.2c6.2-6.2 6.2-16.4 0-22.6s-16.4-6.2-22.6 0C551.9 289.5 512 273 512 240zM448 352a32 32 0 1 1 64 0 32 32 0 1 1 -64 0z"]]
}, faSquarePersonConfined = {
  prefix: "fad",
  iconName: "square-person-confined",
  icon: [448, 512, [], "e577", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM99.4 369.7l48-96c4.6-9.2 13.3-15.6 23.5-17.3s20.5 1.7 27.8 9L240 306.7l0-58.7c0-30.9 25.1-56 56-56s56 25.1 56 56l0 102.1c0 36.4-29.5 65.9-65.9 65.9c-17.5 0-34.3-6.9-46.6-19.3L184.8 342l-28.1 56.3c-7.9 15.8-27.1 22.2-42.9 14.3s-22.2-27.1-14.3-42.9zM256 144a48 48 0 1 1 -96 0 48 48 0 1 1 96 0z", "M208 192a48 48 0 1 0 0-96 48 48 0 1 0 0 96zm88 0c-30.9 0-56 25.1-56 56l0 58.7-41.4-41.4c-7.3-7.3-17.6-10.6-27.8-9s-18.9 8.1-23.5 17.3l-48 96c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3L184.8 342l54.7 54.7c12.4 12.4 29.1 19.3 46.6 19.3c36.4 0 65.9-29.5 65.9-65.9L352 248c0-30.9-25.1-56-56-56z"]]
}, faUserTie = {
  prefix: "fad",
  iconName: "user-tie",
  icon: [448, 512, [], "f508", ["M352 128A128 128 0 1 1 96 128a128 128 0 1 1 256 0z", "M190.5 328.2l18.6 31L175.8 483.1l-36-146.9c-2-8.1-9.8-13.4-17.9-11.3C51.9 342.4 0 405.8 0 481.3c0 17 13.8 30.7 30.7 30.7l131.7 0c2.1 0 4-.4 5.8-1.1L168 512l112 0-.3-1.1c1.8 .7 3.8 1.1 5.8 1.1l131.7 0c17 0 30.7-13.8 30.7-30.7c0-75.5-51.9-138.9-121.9-156.4c-8.1-2-15.9 3.3-17.9 11.3l-36 146.9L238.9 359.2l18.6-31c6.4-10.7-1.3-24.2-13.7-24.2L224 304l-19.7 0c-12.4 0-20.1 13.6-13.7 24.2z"]]
}, faUpToBracket = {
  prefix: "fad",
  iconName: "up-to-bracket",
  icon: [448, 512, [], "e66e", ["M0 96l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-17.7 14.3-32 32-32l256 0c17.7 0 32 14.3 32 32l0 64c0 17.7 14.3 32 32 32s32-14.3 32-32l0-64c0-53-43-96-96-96L96 0C43 0 0 43 0 96z", "M196.7 171.3L73.9 294.1c-6.4 6.4-9.9 15-9.9 24C64 336.8 79.2 352 97.9 352l62.1 0 0 128c0 17.7 14.3 32 32 32l64 0c17.7 0 32-14.3 32-32l0-128 62.1 0c18.7 0 33.9-15.2 33.9-33.9c0-9-3.6-17.6-9.9-24L251.3 171.3c-7.2-7.2-17.1-11.3-27.3-11.3s-20.1 4.1-27.3 11.3z"]]
}, faArrowDownLong = {
  prefix: "fad",
  iconName: "arrow-down-long",
  icon: [384, 512, ["long-arrow-down"], "f175", ["M160 32l0 370.7c10.7 10.7 21.3 21.3 32 32c10.7-10.7 21.3-21.3 32-32L224 32c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M169.4 502.6c12.5 12.5 32.8 12.5 45.3 0l128-128c12.5-12.5 12.5-32.8 0-45.3s-32.8-12.5-45.3 0L192 434.7 86.6 329.4c-12.5-12.5-32.8-12.5-45.3 0s-12.5 32.8 0 45.3l128 128z"]]
}, faLongArrowDown = faArrowDownLong, faTentArrowDownToLine = {
  prefix: "fad",
  iconName: "tent-arrow-down-to-line",
  icon: [640, 512, [], "e57e", ["M159.6 448L384 448l0-118.1c0-5.5 4.4-9.9 9.9-9.9c3.7 0 7.2 2.1 8.8 5.5L464 448l144 0c.1 0 .2 0 .4 0l-.7-4.7-24-160c-1.2-8.2-5.6-15.7-12.3-20.7l-168-128c-5.7-4.4-12.6-6.5-19.4-6.5s-13.7 2.2-19.4 6.5l-168 128c-6.6 5-11 12.5-12.3 20.7l-24 160-.7 4.7z", "M240.1 145.8c9.9-8.9 10.7-24 1.8-33.9s-24-10.7-33.9-1.8l-39.9 36L168 24c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 122.1-39.9-36c-9.9-8.9-25-8.1-33.9 1.8s-8.1 25 1.8 33.9l80 72c9.1 8.2 23 8.2 32.1 0l80-72zM32 448c-17.7 0-32 14.3-32 32s14.3 32 32 32l576 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L32 448z"]]
}, faCertificate = {
  prefix: "fad",
  iconName: "certificate",
  icon: [512, 512, [], "f0a3", ["M211 7.3C205 1 196-1.4 187.6 .8s-14.9 8.9-17.1 17.3L154.7 80.6l-62-17.5c-8.4-2.4-17.4 0-23.5 6.1s-8.5 15.1-6.1 23.5l17.5 62L18.1 170.6c-8.4 2.1-15 8.7-17.3 17.1S1 205 7.3 211l46.2 45L7.3 301C1 307-1.4 316 .8 324.4s8.9 14.9 17.3 17.1l62.5 15.8-17.5 62c-2.4 8.4 0 17.4 6.1 23.5s15.1 8.5 23.5 6.1l62-17.5 15.8 62.5c2.1 8.4 8.7 15 17.1 17.3s17.3-.2 23.4-6.4l45-46.2 45 46.2c6.1 6.2 15 8.7 23.4 6.4s14.9-8.9 17.1-17.3l15.8-62.5 62 17.5c8.4 2.4 17.4 0 23.5-6.1s8.5-15.1 6.1-23.5l-17.5-62 62.5-15.8c8.4-2.1 15-8.7 17.3-17.1s-.2-17.4-6.4-23.4l-46.2-45 46.2-45c6.2-6.1 8.7-15 6.4-23.4s-8.9-14.9-17.3-17.1l-62.5-15.8 17.5-62c2.4-8.4 0-17.4-6.1-23.5s-15.1-8.5-23.5-6.1l-62 17.5L341.4 18.1c-2.1-8.4-8.7-15-17.1-17.3S307 1 301 7.3L256 53.5 211 7.3z", ""]]
}, faCrystalBall = {
  prefix: "fad",
  iconName: "crystal-ball",
  icon: [448, 512, [], "e362", ["M0 224c0 71.4 33.4 135 85.4 176l277.2 0c52-41 85.4-104.6 85.4-176C448 100.3 347.7 0 224 0S0 100.3 0 224zM116.3 120.5l26.4-9.8 9.8-26.4c2.6-7 12.4-7 15 0l9.8 26.4 26.4 9.8c7 2.6 7 12.4 0 15l-26.4 9.8-9.8 26.4c-2.6 7-12.4 7-15 0l-9.8-26.4-26.4-9.8c-7-2.6-7-12.4 0-15zm112 80l49.8-18.4 18.4-49.8c2.6-7 12.4-7 15 0l18.4 49.8 49.8 18.4c7 2.6 7 12.4 0 15l-49.8 18.4-18.4 49.8c-2.6 7-12.4 7-15 0l-18.4-49.8-49.8-18.4c-7-2.6-7-12.4 0-15z", "M362.6 400H85.4L21.7 473.4c-3.7 4.2-5.7 9.7-5.7 15.3C16 501.6 26.4 512 39.3 512H408.7c12.9 0 23.3-10.4 23.3-23.3c0-5.6-2-11-5.7-15.3L362.6 400z"]]
}, faReplyAll = {
  prefix: "fad",
  iconName: "reply-all",
  icon: [576, 512, ["mail-reply-all"], "f122", ["M0 208c0 9.1 3.9 17.7 10.6 23.8l160 144c9.4 8.5 22.9 10.6 34.4 5.4s19-16.6 19-29.2l0-43.3c-28.5-25.6-56.9-51.2-85.4-76.9c-.5-.4-.8-.8-1.2-1.2c-.4-.4-.8-.8-1.2-1.2c-.8-.8-1.5-1.7-2.1-2.6c-1.3-1.8-2.4-3.8-3.3-5.8c-.5-1-.9-2.1-1.2-3.1s-.6-2.1-.9-3.2c-.2-1.1-.4-2.2-.5-3.4c-.1-.6-.1-1.1-.1-1.7c0-.5 0-1 0-1.3l0-.4c0-.1 0-.3 0-.4c0-.3 0-.8 0-1.3c0-.6 .1-1.1 .1-1.7c.1-1.1 .3-2.2 .5-3.3c.5-2.2 1.2-4.3 2.1-6.3c1.8-4.1 4.5-7.7 7.8-10.8c28.5-25.6 56.9-51.2 85.4-76.9L224 64c0-12.6-7.4-24.1-19-29.2c-4.2-1.9-8.6-2.8-13-2.8c-7.8 0-15.4 2.8-21.4 8.2l-160 144C3.9 190.3 0 198.9 0 208z", "M333 34.8c11.5 5.1 19 16.6 19 29.2l0 64 48 0c97.2 0 176 78.8 176 176c0 113.3-81.5 163.9-100.2 174.1c-2.5 1.4-5.3 1.9-8.1 1.9c-10.9 0-19.7-8.9-19.7-19.7c0-7.5 4.3-14.4 9.8-19.5c9.4-8.8 22.2-26.4 22.2-56.7c0-53-43-96-96-96l-32 0 0 64c0 12.6-7.4 24.1-19 29.2s-25 3-34.4-5.4l-160-144c-6.7-6.1-10.6-14.7-10.6-23.8s3.9-17.7 10.6-23.8l160-144c9.4-8.5 22.9-10.6 34.4-5.4z"]]
}, faMailReplyAll = faReplyAll, faSuitcase = {
  prefix: "fad",
  iconName: "suitcase",
  icon: [512, 512, [129523], "f0f2", ["M96 96l32 0 0 32 0 352-32 0L96 96zm288 0l32 0 0 384-32 0 0-352 0-32z", "M176 56l0 40 160 0 0-40c0-4.4-3.6-8-8-8L184 48c-4.4 0-8 3.6-8 8zM128 96l0-40c0-30.9 25.1-56 56-56L328 0c30.9 0 56 25.1 56 56l0 40 0 32 0 352-256 0 0-352 0-32zM64 96l32 0 0 384-32 0c-35.3 0-64-28.7-64-64L0 160c0-35.3 28.7-64 64-64zM448 480l-32 0 0-384 32 0c35.3 0 64 28.7 64 64l0 256c0 35.3-28.7 64-64 64z"]]
}, faPersonSkating = {
  prefix: "fad",
  iconName: "person-skating",
  icon: [448, 512, ["skating"], "f7c5", ["M0 400c0 4.1 1.6 8.2 4.7 11.3l59.6 59.6c17 17 43.1 21.3 64.6 10.5l6.2-3.1c7.9-4 11.1-13.6 7.2-21.5s-13.6-11.1-21.5-7.2l-6.2 3.1c-9.2 4.6-20.4 2.8-27.7-4.5L27.3 388.7c-3.1-3.1-7.2-4.7-11.3-4.7s-8.2 1.6-11.3 4.7S0 395.9 0 400zm256 96c0 8.8 7.2 16 16 16l88.8 0c25.7 0 48.1-17.5 54.3-42.4l.4-1.7c.3-1.3 .5-2.6 .5-3.9c0-7.2-4.9-13.7-12.1-15.5c-8.6-2.1-17.3 3.1-19.4 11.6l-.4 1.7c-2.7 10.7-12.3 18.2-23.3 18.2L272 480c-8.8 0-16 7.2-16 16z", "M352 48a48 48 0 1 1 96 0 48 48 0 1 1 -96 0zM128 128c0-17.7 14.3-32 32-32l159.4 0c43.6 0 64.6 53.4 32.8 83.1l-74.4 69.4 60.2 60.2c9 9 14.1 21.2 14.1 33.9l0 73.4c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-66.7-77.9-77.8c-26.6-26.6-24.6-70.3 4.3-94.4l20.4-17L160 160c-17.7 0-32-14.3-32-32zM81.4 353.4l86.9-86.9c4.6 10 11 19.3 19.3 27.5l21.8 21.8-82.7 82.7c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3z"]]
}, faSkating = faPersonSkating, faStarShooting = {
  prefix: "fad",
  iconName: "star-shooting",
  icon: [512, 512, [127776], "e036", ["M231 55c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l48-48c9.4-9.4 9.4-24.6 0-33.9c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7L231 55zm96 96c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0L505 41c9.4-9.4 9.4-24.6 0-33.9c-4.7-4.7-10.8-7-17-7s-12.3 2.3-17 7L327 151zm96 96c-9.4 9.4-9.4 24.6 0 33.9c4.7 4.7 10.8 7 17 7s12.3-2.3 17-7l48-48c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-48 48z", "M213.4 157.4c-8.8-17.9-34.3-17.9-43.1 0l-46.3 94L20.5 266.5C.9 269.3-7 293.5 7.2 307.4l74.9 73.2L64.5 483.9c-3.4 19.6 17.2 34.6 34.8 25.3l92.6-48.8 92.6 48.8c17.6 9.3 38.2-5.7 34.8-25.3L301.6 380.6l74.9-73.2c14.2-13.9 6.4-38.1-13.3-40.9L259.7 251.4l-46.3-94z"]]
}, faBinaryLock = {
  prefix: "fad",
  iconName: "binary-lock",
  icon: [640, 512, [], "e33d", ["M0 64l0 96c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64L64 0C28.7 0 0 28.7 0 64zM0 480c0 17.7 14.3 32 32 32l48 0 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16C5.1 311.2-3.9 329.4 1.7 346.1s23.7 25.8 40.5 20.2l5.9-2L48 448l-16 0c-17.7 0-32 14.3-32 32zM64 64l64 0 0 96-64 0 0-96zM192 352l0 96c0 35.3 28.7 64 64 64l64 0c35.3 0 64-28.7 64-64l0-96c0-35.3-28.7-64-64-64l-64 0c-35.3 0-64 28.7-64 64zm32-160c0 17.7 14.3 32 32 32l48 0 48 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-16 0 0-128c0-10.3-4.9-19.9-13.3-26s-19.1-7.7-28.8-4.4l-48 16c-16.8 5.6-25.8 23.7-20.2 40.5s23.7 25.8 40.5 20.2l5.9-2 0 83.6-16 0c-17.7 0-32 14.3-32 32zm32 160l64 0 0 96-64 0 0-96z", "M496 272l0 48 64 0 0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]]
}, faFilterCircleDollar = {
  prefix: "fad",
  iconName: "filter-circle-dollar",
  icon: [576, 512, ["funnel-dollar"], "f662", ["M3.9 22.9C-2.8 36.8-.7 53.4 9 65.3L192 288.9l0 79.1c0 10.1 4.7 19.6 12.8 25.6l64 48c1.5 1.1 3 2.1 4.7 2.9C262.3 421.4 256 395.4 256 368c0-85 60.2-155.9 140.4-172.4L503 65.3c9.8-12 11.8-28.5 5.2-42.5S487.5 0 472 0L40 0C24.5 0 10.5 8.9 3.9 22.9z", "M432 512a144 144 0 1 0 0-288 144 144 0 1 0 0 288zM408.1 339c0 0 0 0 0 .1c0 .4 0 1.9 4.8 4.5c5.6 3 13.5 5.2 23.9 8.2l.2 0c9.3 2.6 21.1 6 30.5 11.5c10.2 6 20 16.1 20.5 32.3c.5 18.2-9.7 30.4-21.7 36.9c-5.8 3.1-12.1 5.1-18.3 6.2l0 10.8c0 8.8-7.2 16-16 16s-16-7.2-16-16l0-11.4c-8.6-1.7-16.7-4.3-23.7-6.6c0 0 0 0 0 0c-1.7-.6-3.4-1.1-5-1.6c-8.4-2.6-13.2-11.6-10.5-20s11.6-13.2 20-10.5c2 .6 3.9 1.2 5.8 1.8c11.4 3.6 20.4 6.5 29.9 6.8c6.7 .2 13.8-1.1 18.5-3.6c2.2-1.2 3.4-2.4 4-3.3c.5-.8 1.1-2.1 1-4.5c0-1.4-.2-3-4.7-5.6c-5.3-3.1-12.9-5.4-23.2-8.3l-1.8-.5c-8.9-2.5-19.8-5.6-28.6-10.3c-9.9-5.3-20.6-14.7-21.6-30.7c-1.2-18.8 10-30.9 21.8-37.2c5.7-3.1 12-5.1 18-6.3l0-9.5c0-8.8 7.2-16 16-16s16 7.2 16 16l0 9.4c6.3 .9 12.3 2.3 17.9 3.7c8.6 2.1 13.8 10.8 11.7 19.4s-10.8 13.8-19.4 11.7c-9.3-2.3-18.2-4-26.4-4.1c-6.2-.1-13.6 1.3-18.7 4c-2.4 1.3-3.6 2.5-4.2 3.4c-.4 .7-.9 1.6-.8 3.6z"]]
}, faFunnelDollar = faFilterCircleDollar, faCameraRetro = {
  prefix: "fad",
  iconName: "camera-retro",
  icon: [512, 512, [128247], "f083", ["M0 128C0 92.7 28.7 64 64 64l96 0 32 0 50.5-25.2c8.9-4.4 18.7-6.8 28.6-6.8L448 32c35.3 0 64 28.7 64 64l0 64-256 0L0 160l0-32z", "M64 48c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 16L64 64l0-16zM0 416L0 160l512 0 0 256c0 35.3-28.7 64-64 64L64 480c-35.3 0-64-28.7-64-64zm256-16a96 96 0 1 0 0-192 96 96 0 1 0 0 192z"]]
}, faCircleArrowDown = {
  prefix: "fad",
  iconName: "circle-arrow-down",
  icon: [512, 512, ["arrow-circle-down"], "f0ab", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm120 8c0-6.1 2.3-12.3 7-17c9.4-9.4 24.6-9.4 33.9 0l71 71L232 136c0-13.3 10.7-24 24-24s24 10.7 24 24l0 182.1 71-71c9.4-9.4 24.6-9.4 33.9 0c4.7 4.7 7 10.8 7 17s-2.3 12.3-7 17L273 393c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7L127 281c-4.7-4.7-7-10.8-7-17z", "M239 393c9.4 9.4 24.6 9.4 33.9 0L385 281c9.4-9.4 9.4-24.6 0-33.9s-24.6-9.4-33.9 0l-71 71L280 136c0-13.3-10.7-24-24-24s-24 10.7-24 24l0 182.1-71-71c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9L239 393z"]]
}, faArrowCircleDown = faCircleArrowDown, faCommentPen = {
  prefix: "fad",
  iconName: "comment-pen",
  icon: [512, 512, ["comment-edit"], "f4ae", ["M0 240c0 45.1 17.7 86.8 47.7 120.9c-1.9 24.5-11.4 46.3-21.4 62.9c-5.5 9.2-11.1 16.6-15.2 21.6c-2.1 2.5-3.7 4.4-4.9 5.7c-.6 .6-1 1.1-1.3 1.4l-.3 .3C1.6 455.8 0 459.9 0 464c0 2.1 .4 4.1 1.2 6.1c2.5 6 8.3 9.9 14.8 9.9c28.7 0 57.6-8.9 81.6-19.3c22.9-10 42.4-21.9 54.3-30.6c31.8 11.5 67 17.9 104.1 17.9c141.4 0 256-93.1 256-208S397.4 32 256 32S0 125.1 0 240zm160 79.9c0-1.3 .2-2.6 .5-3.9l9.2-36.7c1.4-5.6 4.3-10.8 8.4-14.9c24-24 47.9-48 71.9-71.9l53.3 53.3c-24 24-47.9 48-71.9 71.9c-4.1 4.1-9.2 7-14.9 8.4c-12.2 3.1-24.4 6.1-36.6 9.2c-5.5 1.4-11.2-.2-15.2-4.2c-3-3-4.7-7.1-4.7-11.3zM272.6 170c5-5 9.9-9.9 14.9-14.9c7.4-7.4 17-11.1 26.7-11.1s19.3 3.7 26.7 11.1c14.7 14.7 14.7 38.6 0 53.3c-5 5-9.9 9.9-14.9 14.9c-17.8-17.8-35.6-35.6-53.3-53.3z", "M287.5 155L272.6 170l53.3 53.3 14.9-14.9c14.7-14.7 14.7-38.6 0-53.3s-38.6-14.7-53.3 0zM250 192.6l-71.9 71.9c-4.1 4.1-7 9.2-8.4 14.9L160.5 316c-1.4 5.5 .2 11.2 4.2 15.2s9.7 5.6 15.2 4.2l36.6-9.2c5.6-1.4 10.8-4.3 14.9-8.4l71.9-71.9L250 192.6z"]]
}, faCommentEdit = faCommentPen, faFileImport = {
  prefix: "fad",
  iconName: "file-import",
  icon: [512, 512, ["arrow-right-to-file"], "f56f", ["M128 64c0-35.3 28.7-64 64-64L352 0l0 128c0 17.7 14.3 32 32 32l128 0 0 288c0 35.3-28.7 64-64 64l-256 0c-35.3 0-64-28.7-64-64l0-112 174.1 0-39 39c-9.4 9.4-9.4 24.6 0 33.9c4.7 4.7 10.8 7 17 7s12.3-2.3 17-7l80-80c9.4-9.4 9.4-24.6 0-33.9l-80-80c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l39 39L128 288l0-224z", "M512 160L352 0l0 128c0 17.7 14.3 32 32 32l128 0zM297 215c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l39 39L24 288c-13.3 0-24 10.7-24 24s10.7 24 24 24l278.1 0-39 39c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l80-80c9.4-9.4 9.4-24.6 0-33.9l-80-80z"]]
}, faArrowRightToFile = faFileImport, faBanjo = {
  prefix: "fad",
  iconName: "banjo",
  icon: [512, 512, [129685], "f8a3", ["M24 320c0-8.1 .6-16.2 1.7-24c4.1-28.5 15.3-54.6 31.7-76.6c9.6-12.9 21.1-24.3 33.9-33.9c22-16.5 48.2-27.7 76.6-31.7c7.8-1.1 15.9-1.7 24-1.7s16.2 .6 24 1.7c25.7 3.7 49.5 13.1 70 27c2.2 1.5 4.4 3.1 6.6 4.7c12.9 9.6 24.3 21.1 33.9 33.9c1.6 2.2 3.2 4.4 4.7 6.6c13.9 20.5 23.4 44.3 27 70c1.1 7.8 1.7 15.9 1.7 24s-.6 16.2-1.7 24c-4.1 28.5-15.3 54.6-31.7 76.6c-9.6 12.9-21.1 24.3-33.9 33.9c-22 16.5-48.2 27.7-76.6 31.7c-7.8 1.1-15.9 1.7-24 1.7s-16.2-.6-24-1.7c-28.5-4.1-54.6-15.3-76.6-31.7c-12.9-9.6-24.3-21.1-33.9-33.9C41 398.6 29.8 372.5 25.7 344c-1.1-7.8-1.7-15.9-1.7-24zm56 0a112 112 0 1 0 224 0A112 112 0 1 0 80 320z", "M465 7c-9.4-9.4-24.6-9.4-33.9 0L383 55c-2.4 2.4-4.3 5.3-5.5 8.5l-15.4 41L286 180.7c2.2 1.5 4.4 3.1 6.6 4.7c12.9 9.6 24.3 21.1 33.9 33.9c1.6 2.2 3.2 4.4 4.7 6.6l76.1-76.1 41-15.4c3.2-1.2 6.1-3.1 8.5-5.5l48-48c9.4-9.4 9.4-24.6 0-33.9L465 7zM192 128c-13.3 0-24 10.7-24 24l0 1.7c7.8-1.1 15.9-1.7 24-1.7s16.2 .6 24 1.7l0-1.7c0-13.3-10.7-24-24-24zM360 320c0 8.1-.6 16.2-1.7 24l1.7 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-1.7 0c1.1 7.8 1.7 15.9 1.7 24zM292.6 454.6l1.2 1.2c9.4 9.4 24.6 9.4 33.9 0s9.4-24.6 0-33.9l-1.2-1.2c-9.6 12.9-21.1 24.3-33.9 33.9zM192 488c-8.1 0-16.2-.6-24-1.7l0 1.7c0 13.3 10.7 24 24 24s24-10.7 24-24l0-1.7c-7.8 1.1-15.9 1.7-24 1.7zM57.4 420.6l-1.2 1.2c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l1.2-1.2c-12.9-9.6-24.3-21.1-33.9-33.9zM24 320c0-8.1 .6-16.2 1.7-24L24 296c-13.3 0-24 10.7-24 24s10.7 24 24 24l1.7 0c-1.1-7.8-1.7-15.9-1.7-24zM91.4 185.4l-1.2-1.2c-9.4-9.4-24.6-9.4-33.9 0s-9.4 24.6 0 33.9l1.2 1.2c9.6-12.9 21.1-24.3 33.9-33.9zm41.3 123.2c-6.2 6.2-6.2 16.4 0 22.6l48 48c6.2 6.2 16.4 6.2 22.6 0s6.2-16.4 0-22.6l-48-48c-6.2-6.2-16.4-6.2-22.6 0z"]]
}, faSquareArrowUpRight = {
  prefix: "fad",
  iconName: "square-arrow-up-right",
  icon: [448, 512, ["external-link-square"], "f14c", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM112 344c0-6.1 2.3-12.3 7-17l135-135L160 192c-13.3 0-24-10.7-24-24s10.7-24 24-24l152 0c13.3 0 24 10.7 24 24l0 160c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-102.1L153 361c-4.7 4.7-10.8 7-17 7s-12.3-2.3-17-7s-7-10.8-7-17z", "M312 144l-152 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l94.1 0L119 327c-9.4 9.4-9.4 24.6 0 33.9s24.6 9.4 33.9 0l135-135L288 328c0 13.3 10.7 24 24 24s24-10.7 24-24l0-160c0-13.3-10.7-24-24-24z"]]
}, faExternalLinkSquare = faSquareArrowUpRight, faLightEmergencyOn = {
  prefix: "fad",
  iconName: "light-emergency-on",
  icon: [640, 512, [], "e420", ["M160 192l0 160 320 0 0-160c0-88.4-71.6-160-160-160s-160 71.6-160 160zm48 0c0-61.9 50.1-112 112-112c8.8 0 16 7.2 16 16s-7.2 16-16 16c-44.2 0-80 35.8-80 80c0 8.8-7.2 16-16 16s-16-7.2-16-16z", "M69.3 36c-11-7.4-25.9-4.4-33.3 6.7s-4.4 25.9 6.7 33.3l48 32c11 7.4 25.9 4.4 33.3-6.7s4.4-25.9-6.7-33.3l-48-32zM597.3 76c11-7.4 14-22.3 6.7-33.3s-22.3-14-33.3-6.7l-48 32c-11 7.4-14 22.3-6.7 33.3s22.3 14 33.3 6.7l48-32zM24 192c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zm528 0c-13.3 0-24 10.7-24 24s10.7 24 24 24l64 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-64 0zM128 352c-17.7 0-32 14.3-32 32l0 64c0 17.7 14.3 32 32 32l384 0c17.7 0 32-14.3 32-32l0-64c0-17.7-14.3-32-32-32l-384 0z"]]
}, faKerning = {
  prefix: "fad",
  iconName: "kerning",
  icon: [640, 512, [], "f86f", ["M0 128c0 4.8 1.1 9.7 3.4 14.3l128 256c5.4 10.8 16.5 17.7 28.6 17.7s23.2-6.8 28.6-17.7l128-256c7.9-15.8 1.5-35-14.3-42.9c-4.6-2.3-9.5-3.4-14.3-3.4c-11.7 0-23 6.5-28.6 17.7L160 312.4 60.6 113.7C52.7 97.9 33.5 91.5 17.7 99.4C6.5 105 0 116.3 0 128zM323.4 369.7c-7.9 15.8-1.5 35 14.3 42.9s35 1.5 42.9-14.3L403.8 352l152.4 0 23.2 46.3c7.9 15.8 27.1 22.2 42.9 14.3C633.5 407 640 395.7 640 384c0-4.8-1.1-9.7-3.4-14.3l-128-256C503.2 102.8 492.1 96 480 96s-23.2 6.8-28.6 17.7l-128 256zM435.8 288L480 199.6 524.2 288l-88.4 0z", "M447.2 1.7c7.9 4 11.1 13.6 7.2 21.5l-240 480c-4 7.9-13.6 11.1-21.5 7.2s-11.1-13.6-7.2-21.5l240-480c4-7.9 13.6-11.1 21.5-7.2z"]]
}, faBoxOpen = {
  prefix: "fad",
  iconName: "box-open",
  icon: [640, 512, [], "f49e", ["M17.2 125.5L58.9 42.1c3-6.1 9.6-9.6 16.3-8.7C156.8 43.6 238.4 53.8 320 64c-27.8 46.3-55.6 92.6-83.4 139c-7.5 12.4-22.3 18.3-36.2 14.3c-45.5-13-90.9-26-136.4-39c-9-2.6-18-5.1-26.9-7.7c-19.3-5.5-28.8-27.2-19.8-45.1zM320 64L564.8 33.4c6.7-.8 13.3 2.7 16.3 8.7l41.7 83.4c9 17.9-.6 39.6-19.8 45.1c-9 2.6-18 5.1-26.9 7.7c-45.5 13-90.9 26-136.4 39c-13.9 4-28.8-1.9-36.2-14.3c-27.8-46.3-55.6-92.6-83.4-139z", "M320 64L236.6 203c-7.4 12.4-22.3 18.3-36.2 14.3L64 178.3l0 200.2c0 22 15 41.2 36.4 46.6l204.1 51c10.2 2.6 20.9 2.6 31 0l204.1-51c21.4-5.3 36.4-24.5 36.4-46.6l0-200.2-136.4 39c-13.9 4-28.8-1.9-36.2-14.3L320 64z"]]
}, faSquareF = {
  prefix: "fad",
  iconName: "square-f",
  icon: [448, 512, [], "e270", ["M0 96L0 416c0 35.3 28.7 64 64 64l320 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zm128 56c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 64 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96 0-112z", "M128 152c0-13.3 10.7-24 24-24l144 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-120 0 0 64 88 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-88 0 0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96 0-112z"]]
}, faScroll = {
  prefix: "fad",
  iconName: "scroll",
  icon: [576, 512, [128220], "f70e", ["M64 32l352 0c35.3 0 64 28.7 64 64l0 256-160 0c-17.7 0-32 14.3-32 32l0 16c0 44.2-35.8 80-80 80s-80-35.8-80-80l0-240 0-64c0-35.3-28.7-64-64-64z", "M128 160l-96 0c-17.7 0-32-14.3-32-32L0 96C0 60.7 28.7 32 64 32s64 28.7 64 64l0 64zM288 400l0-16c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32c0 53-43 96-96 96l-272 0c44.2 0 80-35.8 80-80z"]]
}, faSpa = {
  prefix: "fad",
  iconName: "spa",
  icon: [576, 512, [], "f5bb", ["M183.1 235.3c19.6-113 73.8-178.8 91.3-197.7C278 33.9 282.9 32 288 32s10 1.9 13.5 5.6c17.5 18.8 71.8 84.7 91.3 197.7c-22 13.5-42.1 29.9-59.7 48.7c-8.8 9.4-17.1 19.3-24.6 29.8c-3.8 5.2-7.4 10.6-10.8 16.1c-1.7 2.7-3.4 5.5-5 8.3s-3.2 5.6-4.8 8.6c-24.5-46-60.9-84.5-104.9-111.6z", "M267.9 480l20.1 0 20.1 0C456.1 480 576 360.1 576 212.1c0-11.1-9-20.1-20.1-20.1l-9.9 0c-110.8 0-208.5 62-258 154.9C238.5 254 140.8 192 30 192l-9.9 0C9 192 0 201 0 212.1C0 360.1 119.9 480 267.9 480z"]]
}, faArrowLeftFromLine = {
  prefix: "fad",
  iconName: "arrow-left-from-line",
  icon: [448, 512, [8612, "arrow-from-right"], "f344", ["M384 96l0 320c0 17.7 14.3 32 32 32s32-14.3 32-32l0-320c0-17.7-14.3-32-32-32s-32 14.3-32 32z", "M9.4 278.6c-12.5-12.5-12.5-32.8 0-45.3l128-128c12.5-12.5 32.8-12.5 45.3 0s12.5 32.8 0 45.3L109.3 224l66.7 0 112 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-112 0-66.7 0 73.4 73.4c12.5 12.5 12.5 32.8 0 45.3s-32.8 12.5-45.3 0l-128-128z"]]
}, faArrowFromRight = faArrowLeftFromLine, faStrawberry = {
  prefix: "fad",
  iconName: "strawberry",
  icon: [512, 512, [], "e32b", ["M0 336C0 464 48 512 176 512c176 0 272-96 272-192c0-32.8-12.5-65.5-37.5-90.5l-128-128C257.6 76.6 224.9 64.1 192.2 64C96.2 64 0 160 0 336zm71.5 28.4c0-7.5 3.9-17.4 11.7-25.2c11.9-11.9 28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7c-2-2-3-5.2-3-9.1zm35-86.9c-5.9-5.9-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7zm32-96c-5.9-5.9-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7zm0 256c-5.9-5.9-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3c-7.8 7.8-17.7 11.7-25.2 11.7c-3.8 0-7.1-1-9.1-3zm32-96c-5.9-5.9-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7zm32-96c-5.9-5.9-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7zm32 160c-5.9-5.9-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7zm32-96c-5.9-5.9-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7zm64 64c-5.9-5.9-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7z", "M481.5 1.9c12.2 5.2 17.8 19.3 12.6 31.5c-13.4 31.2-36.9 59-56.3 78.7c32.8 1.8 57.4 18 68.2 26.6c4 3.2 6 8.1 6 13.2s-2 10-6 13.3C495 174.4 469.7 192 440 192c-40 0-55.3-15.3-80-40s-40-40-40-80c0-29.7 17.6-55 26.7-66c3.3-4 8.2-6 13.3-6s10 2 13.2 6C382.3 17.5 400 44.3 400 80c0 .7 0 1.4 0 2.1c.7-.7 1.4-1.3 2-2c18.2-18.2 37.7-41.7 47.9-65.5c5.2-12.2 19.3-17.8 31.5-12.6zm-300 136.6c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7zm55.3 98.3c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-32 96c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-32 96c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm104.7-66.3c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7zm32-96c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7zm55.3 98.3c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-224-96c-11.9 11.9-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7s3.2 22.4-8.7 34.3zm-23.3 61.7c5.9 5.9 3.2 22.4-8.7 34.3s-28.3 14.6-34.3 8.7s-3.2-22.4 8.7-34.3s28.3-14.6 34.3-8.7z"]]
}, faLocationPinLock = {
  prefix: "fad",
  iconName: "location-pin-lock",
  icon: [512, 512, [], "e51f", ["M0 192c0 87.4 117 243 168.3 307.2c6.1 7.7 14.9 11.5 23.7 11.5s17.6-3.8 23.7-11.5c11-13.8 25.1-31.7 40.3-52.3l0-94.8c0-23.7 12.9-44.4 32-55.4l0-24.6c0-55.6 40.5-101.7 93.6-110.5C367 70 287.7 0 192 0C86 0 0 86 0 192zm256 0a64 64 0 1 1 -128 0 64 64 0 1 1 128 0z", "M368 272l0 48 64 0 0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]]
}, faPause = {
  prefix: "fad",
  iconName: "pause",
  icon: [320, 512, [9208], "f04c", ["M48 64C21.5 64 0 85.5 0 112L0 400c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48L48 64zm192 0c-26.5 0-48 21.5-48 48l0 288c0 26.5 21.5 48 48 48l32 0c26.5 0 48-21.5 48-48l0-288c0-26.5-21.5-48-48-48l-32 0z", ""]]
}, faClockEightThirty = {
  prefix: "fad",
  iconName: "clock-eight-thirty",
  icon: [512, 512, [], "e346", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm140 77.3c-7.4-11-4.4-25.9 6.7-33.3l96-64c7.4-4.9 16.8-5.4 24.6-1.2S280 247.1 280 256l0 136c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-91.2L173.3 340c-11 7.4-25.9 4.4-33.3-6.7z", "M256 416c-13.3 0-24-10.7-24-24l0-91.2L173.3 340c-11 7.4-25.9 4.4-33.3-6.7s-4.4-25.9 6.7-33.3l96-64c7.4-4.9 16.8-5.4 24.6-1.2S280 247.1 280 256l0 136c0 13.3-10.7 24-24 24z"]]
}, faPlaneEngines = {
  prefix: "fad",
  iconName: "plane-engines",
  icon: [576, 512, [9992, "plane-alt"], "f3de", ["M166 20.5L216 192l152 0c-12.7-21.8-25.5-43.7-38.2-65.5c-12.1-20.8-24.3-41.6-36.4-62.5L265.3 15.9C259.5 6 249 0 237.6 0L181.3 0C170.7 0 163 10.2 166 20.5zm0 471c-3 10.2 4.7 20.5 15.4 20.5l56.3 0c11.4 0 21.9-6 27.6-15.9c9.4-16 18.7-32.1 28.1-48.1l36.4-62.5c12.7-21.8 25.5-43.7 38.2-65.5l-152 0L166 491.5z", "M576 256c0-35-59.5-64-93.7-64L112 192 68.8 134.4c-3-4-7.8-6.4-12.8-6.4l-42 0c-7.8 0-14 6.3-14 14c0 1.3 .2 2.6 .5 3.9l22.7 79.3C9.8 229 0 241.4 0 256s9.8 27 23.2 30.8L.5 366.1c-.4 1.3-.5 2.6-.5 3.9c0 7.8 6.3 14 14 14l42 0c5 0 9.8-2.4 12.8-6.4L112 320l370.3 0c34.2 0 93.7-28 93.7-64zM329.8 126.5C342.7 122.3 352 110.3 352 96c0-17.7-14.3-32-32-32l-26.7 0 36.4 62.5zm0 259L293.3 448l26.7 0c17.7 0 32-14.3 32-32c0-14.3-9.3-26.3-22.2-30.5z"]]
}, faPlaneAlt = faPlaneEngines, faHillAvalanche = {
  prefix: "fad",
  iconName: "hill-avalanche",
  icon: [576, 512, [], "e507", ["M128 80c0 4 .5 7.9 1.4 11.6L439.7 401.9c34.2 23.1 81.1 19.5 111.4-10.8c17.2-17.2 25.8-39.7 25.8-62.2s-8.6-45-25.8-62.2c-34.4-34.4-90.1-34.4-124.5 0l33.9 33.9c15.6-15.6 40.9-15.6 56.6 0s15.6 40.9 0 56.6s-40.9 15.6-56.6 0l-81.7-81.7C401.2 261.3 416 236.4 416 208c0-33.9-21.1-62.9-50.9-74.5c1.9-6.8 2.9-14 2.9-21.5c0-44.2-35.8-80-80-80c-27.3 0-51.5 13.7-65.9 34.6C216.3 46.6 197.9 32 176 32c-26.5 0-48 21.5-48 48zM416 64a32 32 0 1 0 64 0 32 32 0 1 0 -64 0zm32 96a32 32 0 1 0 64 0 32 32 0 1 0 -64 0z", "M54.6 73.4c-9.2-9.2-22.9-11.9-34.9-6.9S0 83.1 0 96L0 480c0 17.7 14.3 32 32 32l384 0c12.9 0 24.6-7.8 29.6-19.8s2.2-25.7-6.9-34.9l-384-384z"]]
}, faTemperatureEmpty = {
  prefix: "fad",
  iconName: "temperature-empty",
  icon: [320, 512, ["temperature-0", "thermometer-0", "thermometer-empty"], "f2cb", ["M16 368c0 79.5 64.5 144 144 144s144-64.5 144-144c0-33.2-11.2-63.8-30.1-88.1c-.9-1.2-1.5-2.2-1.7-2.8c-.1-.3-.2-.5-.2-.6L272 112C272 50.2 221.9 0 160 0S48 50.2 48 112l0 164.4c0 .1-.1 .3-.2 .6c-.2 .6-.8 1.6-1.7 2.8C27.2 304.2 16 334.8 16 368zm64 0c0-18.5 6.2-35.4 16.7-48.9c8.2-10.6 15.3-25.2 15.3-42.5L112 112c0-26.5 21.5-48 48-48s48 21.5 48 48l0 164.5c0 17.3 7.1 31.9 15.3 42.5C233.8 332.6 240 349.5 240 368c0 44.2-35.8 80-80 80s-80-35.8-80-80z", "M112 368a48 48 0 1 1 96 0 48 48 0 1 1 -96 0z"]]
}, faTemperature0 = faTemperatureEmpty, faThermometer0 = faTemperatureEmpty, faThermometerEmpty = faTemperatureEmpty, faBomb = {
  prefix: "fad",
  iconName: "bomb",
  icon: [512, 512, [128163], "f1e2", ["M352 79.7c0 4.5 3 8.7 7.2 10.2l45.7 16.8 16.8 45.8c1.5 4.4 5.8 7.5 10.4 7.5s8.9-3.1 10.4-7.5l16.5-45.8 45.7-16.8c4.2-1.5 7.2-5.7 7.2-10.2c0-4.6-3-8.9-7.2-10.4L459.1 52.4 442.6 6.5C440.7 2.6 436.5 0 432.1 0s-8.5 2.6-10.4 6.5L405.2 52.4l-46 16.8c-4.3 1.6-7.3 5.9-7.2 10.4z", "M281.4 105.4c12.5-12.5 32.8-12.5 45.3 0l80 80c12.5 12.5 12.5 32.8 0 45.3l-2.9 2.9c7.9 22 12.2 45.7 12.2 70.5c0 114.9-93.1 208-208 208S0 418.9 0 304S93.1 96 208 96c24.7 0 48.5 4.3 70.5 12.3l2.9-2.9zM96 296c0-57.4 46.6-104 104-104l8 0c8.8 0 16-7.2 16-16s-7.2-16-16-16l-8 0c-75.1 0-136 60.9-136 136l0 8c0 8.8 7.2 16 16 16s16-7.2 16-16l0-8z"]]
}, faGaugeLow = {
  prefix: "fad",
  iconName: "gauge-low",
  icon: [512, 512, ["tachometer-alt-slow"], "f627", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128 0a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm16-104c0-.3 0-.6 0 0zM288 96a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm112 48a32 32 0 1 1 -64 0 32 32 0 1 1 64 0zm48 112a32 32 0 1 1 -64 0 32 32 0 1 1 64 0z", "M190 142.3c-5.3-12.1-19.5-17.6-31.6-12.3s-17.6 19.5-12.3 31.6l64.1 145.7C198.9 318.9 192 334.6 192 352c0 35.3 28.7 64 64 64s64-28.7 64-64s-28.7-64-64-64c-.6 0-1.3 0-1.9 0L190 142.3z"]]
}, faTachometerAltSlow = faGaugeLow, faRegistered = {
  prefix: "fad",
  iconName: "registered",
  icon: [512, 512, [174], "f25d", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zM160 152c0-13.3 10.7-24 24-24l88 0c44.2 0 80 35.8 80 80c0 28-14.4 52.7-36.3 67l34.1 75.1c5.5 12.1 .1 26.3-11.9 31.8c-3.2 1.5-6.6 2.2-9.9 2.2c-9.1 0-17.8-5.2-21.9-14.1L268.9 288 208 288l0 72c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-96 0-112zm48 24l0 64 64 0c17.7 0 32-14.3 32-32s-14.3-32-32-32l-64 0z", "M184 128c-13.3 0-24 10.7-24 24l0 112 0 96c0 13.3 10.7 24 24 24s24-10.7 24-24l0-72 60.9 0 37.2 81.9c5.5 12.1 19.7 17.4 31.8 11.9s17.4-19.7 11.9-31.8L315.7 275c21.8-14.3 36.3-39 36.3-67c0-44.2-35.8-80-80-80l-88 0zm88 112l-64 0 0-64 64 0c17.7 0 32 14.3 32 32s-14.3 32-32 32z"]]
}, faTrashCanPlus = {
  prefix: "fad",
  iconName: "trash-can-plus",
  icon: [448, 512, [], "e2ac", ["M32 96l0 352c0 35.3 28.7 64 64 64l256 0c35.3 0 64-28.7 64-64l0-352L32 96zm80 192c0-13.3 10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-64-64 0c-13.3 0-24-10.7-24-24z", "M135.2 17.7C140.6 6.8 151.7 0 163.8 0L284.2 0c12.1 0 23.2 6.8 28.6 17.7L320 32l96 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L32 96C14.3 96 0 81.7 0 64S14.3 32 32 32l96 0 7.2-14.3zM200 376l0-64-64 0c-13.3 0-24-10.7-24-24s10.7-24 24-24l64 0 0-64c0-13.3 10.7-24 24-24s24 10.7 24 24l0 64 64 0c13.3 0 24 10.7 24 24s-10.7 24-24 24l-64 0 0 64c0 13.3-10.7 24-24 24s-24-10.7-24-24z"]]
}, faAddressCard = {
  prefix: "fad",
  iconName: "address-card",
  icon: [576, 512, [62140, "contact-card", "vcard"], "f2bb", ["M0 96L0 416c0 35.3 28.7 64 64 64l448 0c35.3 0 64-28.7 64-64l0-320c0-35.3-28.7-64-64-64L64 32C28.7 32 0 60.7 0 96zM64 368c0-44.2 35.8-80 80-80l64 0c44.2 0 80 35.8 80 80c0 8.8-7.2 16-16 16L80 384c-8.8 0-16-7.2-16-16zM240 192a64 64 0 1 1 -128 0 64 64 0 1 1 128 0zm112-16c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16zm0 64c0-8.8 7.2-16 16-16l128 0c8.8 0 16 7.2 16 16s-7.2 16-16 16l-128 0c-8.8 0-16-7.2-16-16z", "M176 256a64 64 0 1 0 0-128 64 64 0 1 0 0 128zm-32 32c-44.2 0-80 35.8-80 80c0 8.8 7.2 16 16 16l192 0c8.8 0 16-7.2 16-16c0-44.2-35.8-80-80-80l-64 0z"]]
}, faContactCard = faAddressCard, faVcard = faAddressCard, faChartFft = {
  prefix: "fad",
  iconName: "chart-fft",
  icon: [512, 512, [], "e69e", ["M0 64L0 400c0 44.2 35.8 80 80 80l400 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L80 416c-8.8 0-16-7.2-16-16L64 64c0-17.7-14.3-32-32-32S0 46.3 0 64z", "M254.1 64.1c12.8-.8 24.8 6.2 30.6 17.6L339.8 192l60.2 0c12.1 0 23.2 6.8 28.6 17.7l48 96c7.9 15.8 1.5 35-14.3 42.9s-35 1.5-42.9-14.3L380.2 256 320 256c-12.1 0-23.2-6.8-28.6-17.7l-30.5-60.9L206.1 330.8C201.6 343.5 189.5 352 176 352l-48 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l25.4 0L225.9 85.2c4.3-12.1 15.4-20.4 28.2-21.2z"]]
}, faScaleUnbalancedFlip = {
  prefix: "fad",
  iconName: "scale-unbalanced-flip",
  icon: [640, 512, ["balance-scale-right"], "f516", ["M96 480c0 17.7 14.3 32 32 32l192 0c17.7 0 32-14.3 32-32l0-326.7c5.1-2.2 9.9-5 14.4-8.2l135.5 45.2c16.8 5.6 34.9-3.5 40.5-20.2s-3.5-34.9-20.2-40.5L399.5 88.8c.3-2.9 .5-5.8 .5-8.8c0-44.2-35.8-80-80-80c-29.3 0-55 15.8-68.9 39.3L138.1 1.6c-16.8-5.6-34.9 3.5-40.5 20.2s3.5 34.9 20.2 40.5l125.9 42c7 22 23.3 39.9 44.2 49L288 448l-160 0c-17.7 0-32 14.3-32 32z", "M128 163.8L55.6 288l144.9 0L128 163.8zM254 305.1C243.2 350 190.9 384 128 384S12.8 350 2 305.1c-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1zm256.9-13.3L438.4 416l144.9 0L510.8 291.8zm126 141.3C626 478 573.7 512 510.8 512s-115.2-34-126-78.9c-2.6-11 1-22.3 6.7-32.1l95.2-163.2c5-8.6 14.2-13.8 24.1-13.8s19.1 5.3 24.1 13.8l95.2 163.2c5.7 9.8 9.3 21.1 6.7 32.1z"]]
}, faBalanceScaleRight = faScaleUnbalancedFlip, faGlobeSnow = {
  prefix: "fad",
  iconName: "globe-snow",
  icon: [448, 512, [], "f7a3", ["M0 224c0 71.4 33.4 135 85.4 176L192 400l0-48-64 0c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4L185.4 256 160 256c-6.5 0-12.3-3.9-14.8-9.9s-1.1-12.9 3.5-17.4l64-64c3.1-3.1 7.2-4.7 11.3-4.7s8.2 1.6 11.3 4.7l64 64c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9l-25.4 0 68.7 68.7c4.6 4.6 5.9 11.5 3.5 17.4s-8.3 9.9-14.8 9.9l-64 0 0 48 106.6 0c52-41 85.4-104.6 85.4-176C448 100.3 347.7 0 224 0S0 100.3 0 224zm96-16a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zM256 80a16 16 0 1 1 -32 0 16 16 0 1 1 32 0zm96 96a16 16 0 1 1 -32 0 16 16 0 1 1 32 0z", "M235.3 164.7c-6.2-6.2-16.4-6.2-22.6 0l-64 64c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9l25.4 0-68.7 68.7c-4.6 4.6-5.9 11.5-3.5 17.4s8.3 9.9 14.8 9.9l64 0 0 48L85.4 400 21.7 473.4c-3.7 4.2-5.7 9.7-5.7 15.3C16 501.6 26.4 512 39.3 512l369.4 0c12.9 0 23.3-10.4 23.3-23.3c0-5.6-2-11-5.7-15.3L362.6 400 256 400l0-48 64 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4L262.6 256l25.4 0c6.5 0 12.3-3.9 14.8-9.9s1.1-12.9-3.5-17.4l-64-64z"]]
}, faSubscript = {
  prefix: "fad",
  iconName: "subscript",
  icon: [512, 512, [], "f12c", ["M0 96C0 78.3 14.3 64 32 64l32 0c10.4 0 20.2 5.1 26.2 13.6L176 200.2 261.8 77.6c6-8.6 15.8-13.6 26.2-13.6l32 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-15.3 0L215.1 256l89.6 128 15.3 0c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0c-10.4 0-20.2-5.1-26.2-13.6L176 311.8 90.2 434.4C84.2 442.9 74.4 448 64 448l-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l15.3 0 89.6-128L47.3 128 32 128C14.3 128 0 113.7 0 96z", "M464.8 292.8c9.4 5.8 15.2 16.1 15.2 27.2l0 128c17.7 0 32 14.3 32 32s-14.3 32-32 32l-32 0-32 0c-17.7 0-32-14.3-32-32s14.3-32 32-32l0-80c-11.7 0-23-6.5-28.6-17.7c-7.9-15.8-1.5-35 14.3-42.9l32-16c9.9-5 21.7-4.4 31.1 1.4z"]]
}, faDiamondTurnRight = {
  prefix: "fad",
  iconName: "diamond-turn-right",
  icon: [512, 512, ["directions"], "f5eb", ["M0 256c0 10.2 3.9 20.5 11.7 28.3l216 216c15.6 15.6 40.9 15.6 56.6 0l216-216c15.6-15.6 15.6-40.9 0-56.6l-216-216C276.5 3.9 266.2 0 256 0s-20.5 3.9-28.3 11.7l-216 216C3.9 235.5 0 245.8 0 256zm160 24c0-35.3 28.7-64 64-64l64 0 0-56c0-6.5 3.9-12.3 9.9-14.8s12.9-1.1 17.4 3.5l80 80c6.2 6.2 6.2 16.4 0 22.6l-80 80c-4.6 4.6-11.5 5.9-17.4 3.5s-9.9-8.3-9.9-14.8l0-56-64 0c-8.8 0-16 7.2-16 16l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48z", "M297.9 145.2c6-2.5 12.9-1.1 17.4 3.5l80 80c6.2 6.2 6.2 16.4 0 22.6l-80 80c-4.6 4.6-11.5 5.9-17.4 3.5s-9.9-8.3-9.9-14.8l0-56-64 0c-8.8 0-16 7.2-16 16l0 48c0 13.3-10.7 24-24 24s-24-10.7-24-24l0-48c0-35.3 28.7-64 64-64l64 0 0-56c0-6.5 3.9-12.3 9.9-14.8z"]]
}, faDirections = faDiamondTurnRight, faIntegral = {
  prefix: "fad",
  iconName: "integral",
  icon: [320, 512, [], "f667", ["M216 64c-13.3 0-24 10.7-24 24l0 336c0 48.6-39.4 88-88 88s-88-39.4-88-88l0-8c0-17.7 14.3-32 32-32s32 14.3 32 32l0 8c0 13.3 10.7 24 24 24s24-10.7 24-24l0-336c0-48.6 39.4-88 88-88s88 39.4 88 88l0 8c0 17.7-14.3 32-32 32s-32-14.3-32-32l0-8c0-13.3-10.7-24-24-24z", ""]]
}, faBurst = {
  prefix: "fad",
  iconName: "burst",
  icon: [512, 512, [], "e4dc", ["M0 256c0 10.4 6.7 19.6 16.6 22.8l103.1 33.4L66.8 412.8c-4.9 9.3-3.2 20.7 4.3 28.1s18.8 9.2 28.1 4.3l100.6-52.9 33.4 103.1c3.2 9.9 12.4 16.6 22.8 16.6s19.6-6.7 22.8-16.6l33.4-103.1 100.6 52.9c9.3 4.9 20.7 3.2 28.1-4.3s9.2-18.8 4.3-28.1L392.3 312.2l103.1-33.4c9.9-3.2 16.6-12.4 16.6-22.8s-6.7-19.6-16.6-22.8L388.9 198.7l25.7-70.4c3.2-8.8 1-18.6-5.6-25.2s-16.4-8.8-25.2-5.6l-70.4 25.7L278.8 16.6C275.6 6.7 266.4 0 256 0s-19.6 6.7-22.8 16.6l-32.3 99.6L37.6 4.2C28-2.3 15.2-1.1 7 7s-9.4 21-2.8 30.5l112 163.3L16.6 233.2C6.7 236.4 0 245.6 0 256zM96 96l130.9 89.8L256 96l29.1 89.8 64.7-23.6-23.6 64.7L416 256l-89.8 29.1 45.6 86.8-86.8-45.6L256 416l-29.1-89.8-86.8 45.6 45.6-86.8L96 256l89.8-29.1L96 96z", "M256 96l29.1 89.8 64.7-23.6-23.6 64.7L416 256l-89.8 29.1 45.6 86.8-86.8-45.6L256 416l-29.1-89.8-86.8 45.6 45.6-86.8L96 256l89.8-29.1L96 96l130.9 89.8L256 96z"]]
}, faHouseLaptop = {
  prefix: "fad",
  iconName: "house-laptop",
  icon: [640, 512, ["laptop-house"], "e066", ["M2.2 235.7C7 247.9 18.8 256 32 256l32 0 0 112c0 26.5 21.5 48 48 48l160 0 0-128-64 0c-8.8 0-16-7.2-16-16l0-64c0-8.8 7.2-16 16-16l64 0c8.8 0 16 7.2 16 16l0 37.7c11.7-13.3 28.9-21.7 48-21.7l144 0c0-8.8-3.6-17.3-10.3-23.5l-208-192C255.6 2.8 247.8 0 240 0s-15.6 2.8-21.7 8.5l-208 192c-9.7 8.9-12.9 22.9-8.1 35.2z", "M352 448l192 0 0-144-192 0 0 144zm-48 0l0-160c0-17.7 14.3-32 32-32l224 0c17.7 0 32 14.3 32 32l0 160 32 0c8.8 0 16 7.2 16 16c0 26.5-21.5 48-48 48l-48 0-192 0-48 0c-26.5 0-48-21.5-48-48c0-8.8 7.2-16 16-16l32 0z"]]
}, faLaptopHouse = faHouseLaptop, faFaceTired = {
  prefix: "fad",
  iconName: "face-tired",
  icon: [512, 512, [128555, "tired"], "f5c8", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm116-98.9c0-9 9.6-14.7 17.5-10.5c30 16 59.9 32 89.9 47.9c10.7 5.7 10.7 21.1 0 26.8c-30 16-59.9 32-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6c12-14.4 24-28.8 36-43.2l-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zM128 400c0-11.6 4.2-24.2 10.3-35.9c6.3-12 15.3-24.3 26.4-35.4c22-22 53.9-40.7 91.3-40.7s69.3 18.7 91.3 40.7c11.1 11.1 20.1 23.4 26.4 35.4c6.2 11.7 10.3 24.4 10.3 35.9c0 5.2-2.6 10.2-6.9 13.2s-9.8 3.7-14.7 1.8l-20.5-7.7c-26.9-10.1-55.5-15.3-84.3-15.3l-3.2 0c-28.8 0-57.3 5.2-84.3 15.3L149.6 415c-4.9 1.8-10.4 1.2-14.7-1.8s-6.9-7.9-6.9-13.2zM288.6 194.6c30-16 59.9-32 89.9-47.9c1.8-1 3.7-1.4 5.6-1.4c6.2 0 11.9 5 11.9 11.9c0 2.8-1 5.5-2.8 7.6c-12 14.4-24 28.8-36 43.2c12 14.4 24 28.8 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5c-30-16-59.9-32-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8z", "M116 157.1c0-9 9.6-14.7 17.5-10.5l89.9 47.9c10.7 5.7 10.7 21.1 0 26.8l-89.9 47.9c-7.9 4.2-17.5-1.5-17.5-10.5c0-2.8 1-5.5 2.8-7.6l36-43.2-36-43.2c-1.8-2.1-2.8-4.8-2.8-7.6zm280 0c0 2.8-1 5.5-2.8 7.6l-36 43.2 36 43.2c1.8 2.1 2.8 4.8 2.8 7.6c0 9-9.6 14.7-17.5 10.5l-89.9-47.9c-10.7-5.7-10.7-21.1 0-26.8l89.9-47.9c7.9-4.2 17.5 1.5 17.5 10.5z"]]
}, faTired = faFaceTired, faMoneyBills = {
  prefix: "fad",
  iconName: "money-bills",
  icon: [640, 512, [], "e1f3", ["M0 120L0 360c0 66.3 53.7 120 120 120l400 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-400 0c-39.8 0-72-32.2-72-72l0-240c0-13.3-10.7-24-24-24S0 106.7 0 120zm160 40l0 96c35.3 0 64 28.7 64 64l288 0c0-35.3 28.7-64 64-64l0-96c-35.3 0-64-28.7-64-64L224 96c0 35.3-28.7 64-64 64zm288 48a80 80 0 1 1 -160 0 80 80 0 1 1 160 0z", "M160 32c-35.3 0-64 28.7-64 64l0 224c0 35.3 28.7 64 64 64l416 0c35.3 0 64-28.7 64-64l0-224c0-35.3-28.7-64-64-64L160 32zM512 96c0 35.3 28.7 64 64 64l0 96c-35.3 0-64 28.7-64 64l-288 0c0-35.3-28.7-64-64-64l0-96c35.3 0 64-28.7 64-64l288 0z"]]
}, faBlindsRaised = {
  prefix: "fad",
  iconName: "blinds-raised",
  icon: [512, 512, [], "f8fd", ["M0 107.6c0-2.4 .4-4.7 1.2-7L16.1 59.8C20.8 62.5 26.2 64 32 64l96 0 0 64L20.4 128C9.1 128 0 118.9 0 107.6zm0 96.3c0-2.6 .5-5.1 1.4-7.5L16 160l112 0 0 64L20.1 224C9 224 0 215 0 203.9zM160 64l320 0c5.8 0 11.2-1.5 15.9-4.2l14.9 40.9c.8 2.2 1.2 4.6 1.2 7c0 11.3-9.1 20.4-20.4 20.4L160 128l0-64zm0 96l336 0 14.6 36.4c1 2.4 1.4 4.9 1.4 7.5c0 11.1-9 20.1-20.1 20.1L160 224l0-64z", "M0 32C0 14.3 14.3 0 32 0L480 0c17.7 0 32 14.3 32 32s-14.3 32-32 32L160 64l0 354.7c18.6 6.6 32 24.4 32 45.3c0 26.5-21.5 48-48 48s-48-21.5-48-48c0-20.9 13.4-38.7 32-45.3L128 64 32 64C14.3 64 0 49.7 0 32z"]]
}, faSmog = {
  prefix: "fad",
  iconName: "smog",
  icon: [640, 512, [], "f75f", ["M0 488c0 13.3 10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L24 464c-13.3 0-24 10.7-24 24zm72-96c0 13.3 10.7 24 24 24l104 0c13.3 0 24-10.7 24-24s-10.7-24-24-24L96 368c-13.3 0-24 10.7-24 24zm184 0c0 13.3 10.7 24 24 24l336 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-336 0c-13.3 0-24 10.7-24 24zm160 96c0 13.3 10.7 24 24 24l112 0c13.3 0 24-10.7 24-24s-10.7-24-24-24l-112 0c-13.3 0-24 10.7-24 24z", "M176 288C96.5 288 32 223.5 32 144S96.5 0 176 0c34.5 0 66.1 12.1 90.9 32.3C289.6 12.2 319.4 0 352 0c49.1 0 91.8 27.7 113.2 68.3C475 65.5 485.3 64 496 64c61.9 0 112 50.1 112 112s-50.1 112-112 112l-27.3 0c-22.6 19.9-52.2 32-84.7 32s-62.1-12.1-84.7-32L176 288z"]]
}, faUfoBeam = {
  prefix: "fad",
  iconName: "ufo-beam",
  icon: [576, 512, [], "e048", ["M2.3 477.7l89-187.9c14.2 5.2 29.9 9.8 46.6 13.8L45.7 498.3C41.6 506.9 33 512 24 512c-3.4 0-6.9-.7-10.3-2.3c-12-5.7-17.1-20-11.4-32zM144 138.7c0-9.3 1-18.8 2.9-28.3C158.5 54.5 204.4 0 288 0s129.5 54.5 141.1 110.3c2 9.5 2.9 19 2.9 28.3c0 0-33.2 53.3-144 53.3s-144-53.3-144-53.3zM438.1 303.6c16.7-4 32.3-8.6 46.6-13.8l89 187.9c1.6 3.3 2.3 6.8 2.3 10.3c0 9-5.1 17.6-13.7 21.7c-3.3 1.6-6.8 2.3-10.3 2.3c-9 0-17.6-5.1-21.7-13.7L438.1 303.6z", "M288 192c110.8 0 144-53.3 144-53.3c0-9.3-1-18.8-2.9-28.3C516.8 129.5 576 166.1 576 208c0 61.9-128.9 112-288 112S0 269.9 0 208c0-41.9 59.2-78.5 146.9-97.7c-2 9.5-2.9 19-2.9 28.3c0 0 33.2 53.3 144 53.3zM120 208a24 24 0 1 0 -48 0 24 24 0 1 0 48 0zm360 24a24 24 0 1 0 0-48 24 24 0 1 0 0 48zM312 256a24 24 0 1 0 -48 0 24 24 0 1 0 48 0z"]]
}, faHydra = {
  prefix: "fad",
  iconName: "hydra",
  icon: [640, 512, [], "e686", ["M0 320c0 70.7 57.3 128 128 128l32 0 0 32c0 17.7 14.3 32 32 32l36.9 0c15.6 0 29-11.3 31.6-26.7l6.2-37.3 74.7 0 6.2 37.3c2.6 15.4 15.9 26.7 31.6 26.7l36.9 0c17.7 0 32-14.3 32-32l0-37.8c55.6-16.8 96-68.4 96-129.4l0-24.8 0-16c0-8.8 7.2-16 16-16l48 0c13.6 0 25.7-8.6 30.2-21.4s.4-27.1-10.2-35.6l-34-27.2c-7.3-5.8-15.6-10.1-24.6-12.7c-34.2-9.8-68.3 7.5-82.5 37l4.5 45.2c3.3 33.3-8.5 66.3-32.1 89.9c-6.2 6.2-16.4 6.2-22.6 0s-6.2-16.4 0-22.6c16.9-16.9 25.3-40.4 22.9-64.1l-11.5-115-.1-.8 0-.8c0-5.3 0-10.7 0-16c0-8.8 7.2-16 16-16l48 0c13.6 0 25.7-8.6 30.2-21.4s.4-27.1-10.2-35.6L503.3 16.1C490.3 5.7 474.1 0 457.5 0C416.9 0 384 32.9 384 73.5l0 38.5 0 16 0 34.9c0 6.3-.6 12.5-1.8 18.4C375.4 215 350.5 242.1 318 252c-8.6 2.6-17.7 4-27.1 4l-9.2 0c-46.7 0-90.4 23.4-116.3 62.2l-10.7 16.1c-7.4 11-19.7 17.7-33 17.7c-32.1 0-50.9-36.1-32.5-62.4L121.8 243c1.4-1.8 2.5-3.8 3.4-5.8c2-4.4 2.9-9 2.8-13.6s-1.1-9.2-3.2-13.5c-1.6-3.3-3.8-6.3-6.5-9c-2.7-2.6-5.8-4.7-9.1-6.2c-4.4-2-9-2.9-13.6-2.8s-9.2 1.1-13.5 3.2c-2 1-3.9 2.2-5.7 3.6l-25 18.8C19 241.8 0 279.7 0 320z", "M318 252c32.5-9.9 57.4-37 64.2-70.7l-19.9-59.7C350.8 87.2 318.6 64 282.3 64c-19.1 0-37.7 6.5-52.6 18.5L204 103c-10.6 8.5-14.7 22.8-10.2 35.6s16.6 21.4 30.2 21.4l58.5 0c7.3 0 13.7 5 15.5 12.1L318 252z"]]
}, faCircleCaretUp = {
  prefix: "fad",
  iconName: "circle-caret-up",
  icon: [512, 512, ["caret-circle-up"], "f331", ["M0 256a256 256 0 1 0 512 0A256 256 0 1 0 0 256zm128 24c0-5.9 2.2-11.8 6.4-16.3l104-112c4.5-4.9 10.9-7.7 17.6-7.7s13 2.8 17.6 7.7l104 112c4.2 4.5 6.4 10.4 6.4 16.3c0 3.2-.7 6.5-2 9.6c-3.8 8.7-12.5 14.4-22 14.4l-208 0c-9.5 0-18.2-5.7-22-14.4c-1.3-3.1-2-6.3-2-9.6z", "M273.6 151.7c-4.5-4.9-10.9-7.7-17.6-7.7s-13 2.8-17.6 7.7l-104 112c-6.5 7-8.2 17.2-4.4 25.9s12.5 14.4 22 14.4l208 0c9.5 0 18.2-5.7 22-14.4s2.1-18.9-4.4-25.9l-104-112z"]]
}, faCaretCircleUp = faCircleCaretUp, faUserVneckHairLong = {
  prefix: "fad",
  iconName: "user-vneck-hair-long",
  icon: [448, 512, [], "e463", ["M128 112c0 10.7 0 21.3 0 32c0 53 43 96 96 96s96-43 96-96l0-16 0-32c-2.7 0-5.3 0-8 0c-22.8 0-42.8-11.9-54.1-29.8C241 93.7 210.6 112 176 112c-16 0-32 0-48 0z", "M176 112l-48 0s0 0 0 0l0 32c0 53 43 96 96 96s96-43 96-96l0-16s0 0 0 0l0-32-8 0c-22.8 0-42.8-11.9-54.1-29.8C241 93.7 210.6 112 176 112zm48 160L70.6 272C58.1 272 48 261.9 48 249.4c0-6 2.4-11.8 6.6-16l3.9-3.9c24-24 37.5-56.6 37.5-90.5l0-11s0 0 0 0C96 57.3 153.3 0 224 0c70.6 0 127.8 57.1 128 127.6l0 .8 0 .2 0 10.3c0 33.9 13.5 66.5 37.5 90.5l3.9 3.9c4.2 4.2 6.6 10 6.6 16c0 12.5-10.1 22.6-22.6 22.6L224 272zm-78.1 42.9L210.7 412c6.3 9.5 20.3 9.5 26.6 0l64.8-97.1c3.5-5.2 9.8-8 15.9-6.6c74.5 17.2 130 84 130 163.7l0 8c0 17.7-14.3 32-32 32L32 512c-17.7 0-32-14.3-32-32l0-8c0-79.7 55.5-146.5 130-163.7c6.1-1.4 12.4 1.4 15.9 6.6z"]]
}, faSquareALock = {
  prefix: "fad",
  iconName: "square-a-lock",
  icon: [576, 512, [], "e44d", ["M0 96C0 60.7 28.7 32 64 32l320 0c35.3 0 64 28.7 64 64l0 65.1c-54.3 7.8-96 54.4-96 110.9l0 24.6c-9.9 5.7-18.1 14-23.8 24L245.8 141.9c-3.9-8.5-12.4-13.9-21.8-13.9s-17.9 5.4-21.8 13.9l-96 208c-5.6 12-.3 26.3 11.7 31.8s26.3 .3 31.8-11.7l12-26.1 124.4 0 12 26.1c4 8.8 12.7 13.9 21.8 13.9l0 96L64 480c-35.3 0-64-28.7-64-64L0 96zM184 296l40-86.7L264 296l-80 0z", "M432 272l0 48 64 0 0-48c0-17.7-14.3-32-32-32s-32 14.3-32 32zm-48 48l0-48c0-44.2 35.8-80 80-80s80 35.8 80 80l0 48c17.7 0 32 14.3 32 32l0 128c0 17.7-14.3 32-32 32l-160 0c-17.7 0-32-14.3-32-32l0-128c0-17.7 14.3-32 32-32z"]]
}, faCrutch = {
  prefix: "fad",
  iconName: "crutch",
  icon: [512, 512, [], "f7f7", ["M297.4 9.4C303.6 3.1 311.8 0 320 0s16.4 3.1 22.6 9.4l160 160c6.2 6.2 9.4 14.4 9.4 22.6s-3.1 16.4-9.4 22.6s-14.4 9.4-22.6 9.4s-16.4-3.1-22.6-9.4l-1.4-1.4L410.7 168c-22.3-22.2-44.5-44.5-66.7-66.7C328.9 86.2 313.8 71.1 298.7 56l-1.4-1.4c-12.5-12.5-12.5-32.8 0-45.3z", "M201.4 153.4L298.7 56 344 101.3 269.3 176 336 242.7 410.7 168 456 213.3l-97.3 97.3c0 0-.1 .1-.1 .1s-.1 .1-.1 .1l-34.7 34.7c-12.9 12.9-29.2 21.9-47.1 25.8L169.1 395.2c-5.9 1.3-11.4 4.3-15.7 8.6L54.6 502.6c-12.5 12.5-32.8 12.5-45.3 0s-12.5-32.8 0-45.3l98.8-98.8c4.3-4.3 7.3-9.7 8.6-15.7l23.9-107.6c4-17.8 12.9-34.1 25.8-47.1l34.8-34.8zM224 221.3l-12.2 12.2c-4.3 4.3-7.3 9.7-8.6 15.7l-17 76.7 76.7-17c5.9-1.3 11.4-4.3 15.7-8.6L290.7 288 224 221.3z"]]
}, faGasPumpSlash = {
  prefix: "fad",
  iconName: "gas-pump-slash",
  icon: [640, 512, [], "f5f4", ["M64 480c0 17.7 14.3 32 32 32l288 0c17.7 0 32-14.3 32-32s-14.3-32-32-32L96 448c-17.7 0-32 14.3-32 32zM96 171.6L96 416l288 0 0-17.5L96 171.6zM97.3 51L384 275.7 384 64c0-35.3-28.7-64-64-64L160 0c-30.9 0-56.7 21.9-62.7 51zM448 32c-8.8 8.8-8.8 23.2 0 32l32 32 0 64c0 29.8 20.4 54.9 48 62l0 138c0 8.5-2.7 16.4-7.2 22.9c12.6 9.9 25.2 19.8 37.8 29.6C569.5 397.9 576 379.7 576 360l0-136 0-32 0-24 0-13.5c0-17-6.7-33.3-18.7-45.3L480 32c-8.8-8.8-23.2-8.8-32 0z", "M5.1 9.2C13.3-1.2 28.4-3.1 38.8 5.1l592 464c10.4 8.2 12.3 23.3 4.1 33.7s-23.3 12.3-33.7 4.1L9.2 42.9C-1.2 34.7-3.1 19.6 5.1 9.2z"]]
}, faFontAwesome = {
  prefix: "fad",
  iconName: "font-awesome",
  icon: [512, 512, [62501, 62694, "font-awesome-flag", "font-awesome-logo-full"], "f2b4", ["M96 96l0 352 373.6 0c14.6 0 26.4-11.8 26.4-26.4c0-3.7-.8-7.3-2.3-10.7L432 272l61.7-138.9c1.5-3.4 2.3-7 2.3-10.7c0-14.6-11.8-26.4-26.4-26.4L96 96z", "M96 93c12.2-9.5 20-24.3 20-41C116 23.3 92.7 0 64 0S12 23.3 12 52c0 16.7 7.8 31.5 20 41l0 419 64 0L96 93z"]]
}, faFontAwesomeFlag = faFontAwesome, faFontAwesomeLogoFull = faFontAwesome, faCloudArrowUp = {
  prefix: "fad",
  iconName: "cloud-arrow-up",
  icon: [640, 512