var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, b as baseUrl, t as toastr, bI as ManagementFormStatus, c as Action, G as Getter, bD as Mutation, C as Component, w as createUrl, L as LoadingBarComponent, E as ErrorPanel, s as SortableHeader, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
import ErrorModal from "./errorModal-BqEHnF6f.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
import { S as SortableHeaderLink } from "./sortableHeaderLink-Dk8GE_CB.js";
import { F as FormHistoryModal } from "./formHistoryModal-DbdedW2d.js";
import { V as VueMultiselect } from "./vue-multiselect.min-BYrAqjX1.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let UserFormsRoute = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "load");
    __publicField(this, "forms");
    __publicField(this, "page");
    __publicField(this, "pages");
    __publicField(this, "loading");
    __publicField(this, "error");
    __publicField(this, "status");
    __publicField(this, "updateStatuses");
    __publicField(this, "formsPage");
    __publicField(this, "formIdHistoryToShow", null);
    __publicField(this, "showFormHistoryModal", !1);
  }
  beforeMount() {
    this.$watch(() => this.$route, (n) => this.load(), { immediate: !0 });
  }
  mounted() {
    this.token && (this.filterText = this.token);
  }
  get token() {
    return this.$store.getters["page/forms/userControlPanel/forms/getters/token"];
  }
  set token(value) {
    this.$router.push({ query: { ...this.$route.query, token: value } });
  }
  get filterText() {
    return this.$store.getters["page/forms/userControlPanel/forms/getters/filterText"];
  }
  set filterText(value) {
    this.$router.push({ query: { ...this.$route.query, filterText: value } });
  }
  get sort() {
    let sort = this.$store.getters["page/forms/userControlPanel/forms/getters/sort"];
    return !sort || sort.length <= 1 ? null : {
      by: sort.substring(1, sort.length),
      descending: sort[0] == "-"
    };
  }
  set sort(sort) {
    let current = this.$store.getters["page/forms/userControlPanel/forms/getters/sort"];
    if (!sort) {
      this.$router.push({ query: { ...this.$route.query, sort: void 0 } });
      return;
    }
    let sortValue = (sort.descending ? "-" : "+") + sort.by;
    sortValue != current && this.$router.push({ query: { ...this.$route.query, sort: sortValue } });
  }
  get username() {
    return this.$store.getters["page/forms/userControlPanel/forms/getters/username"];
  }
  set username(value) {
    this.$router.push({ query: { ...this.$route.query, username: value } });
  }
  async changePage(value) {
    this.$router.push({ query: { ...this.$route.query, page: value } });
  }
  openUrl(form) {
    return new URL(baseUrl() + "/app/forms/page/" + this.formsPage.id + "?formId=" + form.id).href;
  }
  reviewUrl(item) {
    return new URL(baseUrl() + "/app/forms/forms/" + item.id + "/review").href;
  }
  async cloneForm(item) {
    let newSessionId = await this.$store.dispatch("page/forms/userControlPanel/forms/actions/clone", item.id);
    if (newSessionId) {
      let uri = new URL(baseUrl() + "/app/forms/page/" + this.formsPage.id + "?sessionId=" + newSessionId);
      toastr.success("The form has successfully been cloned"), window.open(uri.href, "_blank");
    } else
      toastr.error("The form may have expired", "An error occurrred while cloning this form");
  }
  canView(item) {
    return item.status === "saved";
  }
  get filterStatus() {
    return this.status;
  }
  set filterStatus(value) {
    this.updateStatuses(value), this.load();
  }
  get statuses() {
    return [
      { name: "Saved", value: ManagementFormStatus.Saved },
      { name: "Deleted", value: ManagementFormStatus.Deleted },
      { name: "Approved", value: ManagementFormStatus.Approved },
      { name: "Held", value: ManagementFormStatus.Held },
      { name: "Pending", value: ManagementFormStatus.Submitted }
    ];
  }
  downloadFormUrl(item) {
    return baseUrl() + "/app/forms/forms/" + item.id + "/submitted/download?submissionId=" + item.submissionId;
  }
  resetFilters() {
    this.$router.replace({ query: null });
  }
  setHistoryToShow(formId) {
    this.formIdHistoryToShow = formId, this.showFormHistoryModal = !0;
  }
  closeHistoryModal() {
    this.formIdHistoryToShow = null, this.showFormHistoryModal = !1;
  }
  get tableFields() {
    return [
      { key: "token" },
      { key: "created" },
      { key: "lastUpdated", label: "Last Updated" },
      { key: "status", label: "Status" },
      { key: "actions", label: "" }
    ];
  }
  getStatusVariant(status) {
    switch (status) {
      case "saved":
        return "primary";
      case "submitted":
        return "warning";
      case "deleted":
        return "danger";
      case "approved":
        return "success";
      default:
        return "";
    }
  }
  getStatusIcon(status) {
    switch (status) {
      case "saved":
        return "save";
      case "submitted":
        return "paper-plane";
      case "deleted":
        return "trash";
      case "approved":
        return "check";
      default:
        return "";
    }
  }
  getStatusText(status) {
    switch (status) {
      case "saved":
        return "Active";
      case "submitted":
        return "Pending";
      case "deleted":
        return "Deleted";
      case "approved":
        return "Approved";
      default:
        return "";
    }
  }
}, __name(_a, "UserFormsRoute"), _a);
__decorateClass([
  Action("page/forms/userControlPanel/forms/actions/load")
], UserFormsRoute.prototype, "load", 2);
__decorateClass([
  Getter("page/forms/userControlPanel/forms/getters/forms")
], UserFormsRoute.prototype, "forms", 2);
__decorateClass([
  Getter("page/forms/userControlPanel/forms/getters/currentPage")
], UserFormsRoute.prototype, "page", 2);
__decorateClass([
  Getter("page/forms/userControlPanel/forms/getters/totalPages")
], UserFormsRoute.prototype, "pages", 2);
__decorateClass([
  Getter("page/forms/userControlPanel/forms/getters/loading")
], UserFormsRoute.prototype, "loading", 2);
__decorateClass([
  Getter("page/forms/userControlPanel/forms/getters/error")
], UserFormsRoute.prototype, "error", 2);
__decorateClass([
  Getter("page/forms/userControlPanel/forms/getters/status")
], UserFormsRoute.prototype, "status", 2);
__decorateClass([
  Mutation("page/forms/userControlPanel/forms/mutations/status")
], UserFormsRoute.prototype, "updateStatuses", 2);
__decorateClass([
  Getter("page/forms/userControlPanel/getters/page")
], UserFormsRoute.prototype, "formsPage", 2);
UserFormsRoute = __decorateClass([
  Component({
    components: {
      SortableHeaderLink,
      SortableHeader,
      ErrorPanel,
      LoadingBar: LoadingBarComponent,
      ErrorModal,
      ReactiveDropdown,
      PaginationControls,
      DateDisplay,
      VueMultiselect,
      FormHistoryModal
    },
    methods: {
      createUrl
    }
  })
], UserFormsRoute);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_c("h3", [_vm._v(`Forms
              `), _c("div", { staticClass: "float-right" }, [_c("div", { staticClass: "btn-group btn-group-sm", attrs: { role: "group", "aria-label": "Basic example" } }, [_c("button", { staticClass: "btn btn-default", attrs: { disabled: _vm.loading }, on: { click: _vm.load } }, [_c("font-awesome-icon", { attrs: { icon: "sync", spin: _vm.loading } })], 1), _vm._v(" "), _c("a", { staticClass: "mr-1 btn btn-success", attrs: { href: _vm.createUrl("/app/forms/page/" + _vm.formsPage.id), target: "_blank" } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } })], 1)])])])])]), _vm._v(" "), _c("b-row", { staticClass: "mb-2" }, [_c("b-col", [_c("b-input-group", [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1), _vm._v(" "), _c("b-input", { attrs: { placeholder: "Filter...", id: "searchFilterText" }, model: { value: _vm.filterText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterText = $$v;
  }, "callback"), expression: "filterText" } })], 1)], 1), _vm._v(" "), _c("b-col", [_c("vue-multiselect", { attrs: { options: _vm.statuses, multiple: !0, "track-by": "name", label: "name", loading: _vm.loading, placeholder: "Status", "close-on-select": !1, "clear-on-select": !1 }, scopedSlots: _vm._u([{ key: "selection", fn: /* @__PURE__ */ __name(function({ values, search, isOpen }) {
    return values.length && values.length > 1 ? [_c("span", { staticClass: "multiselect__single" }, [_vm._v(_vm._s(values.length) + " options selected")])] : void 0;
  }, "fn") }, { key: "option", fn: /* @__PURE__ */ __name(function(props) {
    return [_c("div", { staticClass: "option__desc" }, [_c("span", { staticClass: "option__title" }, [_vm._v(_vm._s(props.option.name))])])];
  }, "fn") }], null, !0), model: { value: _vm.filterStatus, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.filterStatus = $$v;
  }, "callback"), expression: "filterStatus" } })], 1)], 1), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_vm.error ? [_c("error-panel", { attrs: { error: _vm.error } }, [_vm._v(`
                    Failed to load forms. `), _c("a", { attrs: { role: "button" }, on: { click: _vm.load } }, [_vm._v("Retry?")])])] : !_vm.forms || _vm.loading ? [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)] : _vm.forms && _vm.forms.length ? [_c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.forms, striped: "", busy: _vm.loading, "details-td-class": "pt-0 pb-2", "sort-icon-left": "", "show-empty": "", emptyText: "No forms found" }, scopedSlots: _vm._u([{ key: "head(token)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "token", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(created)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "created", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(lastUpdated)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "lastUpdated", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "head(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("sortable-header-link", { attrs: { id: "status", label: row.label }, model: { value: _vm.sort, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.sort = $$v;
    }, "callback"), expression: "sort" } })];
  }, "fn") }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.created ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.created } }) : _vm._e()];
  }, "fn") }, { key: "cell(lastUpdated)", fn: /* @__PURE__ */ __name(function(row) {
    return [row.item.modified ? _c("date-display", { staticClass: "text-nowrap", attrs: { value: row.item.modified } }) : _vm._e()];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-dropdown", { attrs: { "no-flip": "", variant: "primary", size: "sm", "no-caret": "" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { attrs: { href: _vm.downloadFormUrl(row.item), target: "_blank" } }, [_c("font-awesome-icon", { attrs: { icon: "download" } }), _vm._v(` Download Form
                        `)], 1), _vm._v(" "), row.item.status == "saved" ? _c("b-dropdown-item", { attrs: { href: _vm.openUrl(row.item), target: "_blank" } }, [_c("font-awesome-icon", { attrs: { icon: "external-link-alt" } }), _vm._v(` Open Form
                        `)], 1) : _vm._e(), _vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.cloneForm(row.item);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "clone" } }), _vm._v(` Clone Form
                        `)], 1)], 1)];
  }, "fn") }, { key: "cell(token)", fn: /* @__PURE__ */ __name(function(row) {
    return [_vm._v(`
                    ` + _vm._s(row.item.token) + `
                    `), _c("span", { staticClass: "float-right" }, [_c("b-button", { attrs: { variant: "link", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.setHistoryToShow(row.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "history" } })], 1)], 1)];
  }, "fn") }, { key: "cell(status)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-badge", { attrs: { variant: _vm.getStatusVariant(row.item.status) } }, [_c("font-awesome-icon", { attrs: { icon: _vm.getStatusIcon(row.item.status) } }), _vm._v(` 
                    ` + _vm._s(_vm.getStatusText(row.item.status)) + `
                  `)], 1), _vm._v(`
                   
                  `), row.item.campaign ? [_c("span", { staticClass: "badge badge-secondary" }, [_c("font-awesome-icon", { attrs: { icon: "layer-group" } }), _vm._v(`
                         
                        ` + _vm._s(row.item.campaign.name) + `
                    `)], 1), _vm._v(`
                     
                  `)] : _vm._e(), _vm._v(" "), row.item.rejection ? [_c("span", { staticClass: "badge badge-secondary" }, [_vm._v(`
                        Rejected
                    `)]), _vm._v(`
                     
                  `)] : _vm._e()];
  }, "fn") }]) }), _vm._v(" "), _c("div", { staticClass: "text-center" }, [_vm.page ? _c("pagination-controls", { attrs: { count: _vm.pages, value: _vm.page }, on: { input: _vm.changePage } }) : _vm._e()], 1)] : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
                No forms found
            `)])], 2)]), _vm._v(" "), _c("form-history-modal", { attrs: { formId: _vm.formIdHistoryToShow, shouldShow: _vm.showFormHistoryModal }, on: { close: _vm.closeHistoryModal } })], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  UserFormsRoute,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "1bdbc383"
);
const forms = __component__.exports;
export {
  forms as default
};
