var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, bu as EzeScanOutputConfigurationTypeModel, n as normalizeComponent } from "./main-DAVWuHbi.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a;
let EzescanServerInstanceComponent$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loadingRoutes", !1);
    __publicField(this, "loadingQueues", !1);
    __publicField(this, "loadingInstances", !1);
    __publicField(this, "universalRoutes", !0);
    __publicField(this, "value");
    __publicField(this, "supportsType");
    __publicField(this, "uploadTypes", [
      { name: "Route", id: EzeScanOutputConfigurationTypeModel.Route },
      { name: "Document Queue", id: EzeScanOutputConfigurationTypeModel.DocumentQueue }
    ]);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get targetId() {
    if (this.model)
      return this.model.targetId;
  }
  set targetId(value) {
    this.model = { ...this.model, targetId: value, routeName: null, routeId: null, documentQueueId: null }, this.$nextTick(() => {
      (!this.routes || this.routes.length === 0) && this.refreshRoutesFor(), (!this.queues || this.queues.length === 0) && this.refreshQueuesFor();
    });
  }
  get routeId() {
    if (this.model)
      return this.model.routeId;
  }
  set routeId(value) {
    this.model = { ...this.model, routeId: value };
  }
  get documentQueueId() {
    if (this.model)
      return this.model.documentQueueId;
  }
  set documentQueueId(value) {
    this.model = { ...this.model, documentQueueId: value };
  }
  get routeName() {
    if (this.model)
      return this.model.routeName;
  }
  set routeName(value) {
    this.model = { ...this.model, routeName: value };
  }
  get uploadType() {
    var _a3;
    return ((_a3 = this.model) == null ? void 0 : _a3.type) ?? "route";
  }
  set uploadType(value) {
    this.model = { ...this.model, type: value, documentQueueId: null, routeName: null, routeId: null };
  }
  mounted() {
    this.refreshInstances();
  }
  async refreshInstances() {
    this.loadingInstances = !0;
    try {
      await this.$store.dispatch("administration/ezescan/load");
    } finally {
      this.loadingInstances = !1;
    }
    return this.route && await this.refreshRoutesFor(), this.documentQueueId && await this.refreshQueuesFor(), Promise.resolve();
  }
  refreshRoutesFor() {
    return this.loadingRoutes = !0, this.$store.dispatch("administration/ezescan/loadRoutesFor", {
      id: this.targetId,
      universal: this.universalRoutes
    }).finally(() => this.loadingRoutes = !1);
  }
  refreshQueuesFor() {
    return this.loadingQueues = !0, this.$store.dispatch("administration/ezescan/loadDocumentQueues", {
      id: this.targetId
    }).finally(() => this.loadingQueues = !1);
  }
  get targets() {
    return [...this.instances.map((i) => ({
      id: i.id,
      name: i.name,
      icon: "server"
    })), ...this.pools.map((p) => ({ id: p.id, name: `(Pool) ${p.name}`, icon: "layer-group" }))];
  }
  get instances() {
    return this.$store.getters["administration/ezescan/instances"] || [];
  }
  get pools() {
    return this.$store.getters["administration/ezescan/pools"] || [];
  }
  get instance() {
    if (this.targetId)
      return this.instances.find((i) => i.id === this.targetId);
  }
  get pool() {
    if (this.targetId)
      return this.pools.find((p) => p.id === this.targetId);
  }
  get routes() {
    {
      let routes = this.$store.getters["administration/ezescan/routes"](this.targetId);
      if (routes)
        return routes;
    }
    return [];
  }
  get queues() {
    return this.$store.getters["administration/ezescan/queues"](this.targetId);
  }
  get route() {
    if (this.instance)
      return this.model.routeId;
    if (this.pool)
      return this.model.routeName;
  }
  changeRoute(value) {
    this.instance ? (this.routeName = null, this.routeId = value) : this.pool && (this.routeId = null, this.routeName = value);
  }
  get universal() {
    return this.universalRoutes;
  }
  set universal(value) {
    this.universalRoutes = value, this.refreshRoutesFor();
  }
}, __name(_a, "EzescanServerInstanceComponent"), _a);
__decorateClass$1([
  Prop({
    required: !0
  })
], EzescanServerInstanceComponent$1.prototype, "value", 2);
__decorateClass$1([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], EzescanServerInstanceComponent$1.prototype, "supportsType", 2);
EzescanServerInstanceComponent$1 = __decorateClass$1([
  Component({
    components: {
      ReactiveDropdown
    }
  })
], EzescanServerInstanceComponent$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", [_c("h4", [_vm._v("EzeScan Server")]), _vm._v(" "), _c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Instance")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { options: _vm.targets, loading: _vm.loadingInstances, button: { icon: "sync", class: "btn-success", spin: _vm.loadingInstances, disabled: _vm.loadingInstances } }, on: { button: _vm.refreshInstances }, model: { value: _vm.targetId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.targetId = $$v;
  }, "callback"), expression: "targetId" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("EzeScan Server instance/pool to connect to")])], 1), _vm._v(" "), _vm.supportsType ? _c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Type")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { options: _vm.uploadTypes }, model: { value: _vm.uploadType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.uploadType = $$v;
  }, "callback"), expression: "uploadType" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Type of upload to do to EzeScan Server")])], 1) : _vm._e(), _vm._v(" "), !_vm.supportsType || _vm.uploadType == "route" ? _c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Route")]), _vm._v(" "), _c("b-form-checkbox", { ref: "toggleUniversalSwitch", attrs: { switch: "" }, model: { value: _vm.universal, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.universal = $$v;
  }, "callback"), expression: "universal" } }, [_c("b", [_vm._v("Only show common routes")])]), _vm._v(" "), _c("reactive-dropdown", { attrs: { options: _vm.routes, value: _vm.route, id: "routeSelector", loading: _vm.loadingRoutes || _vm.loadingInstances, button: { icon: "sync", class: "btn-success", spin: _vm.loadingRoutes || _vm.loadingInstances, disabled: _vm.loadingRoutes || _vm.loadingInstances } }, on: { input: _vm.changeRoute, button: _vm.refreshRoutesFor } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Route on the instance/pool to run")])], 1) : _vm._e(), _vm._v(" "), _vm.uploadType == "documentQueue" ? _c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Document Queue")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { options: _vm.queues, id: "documentQueueSelector", loading: _vm.loadingQueues || _vm.loadingInstances, button: { icon: "sync", class: "btn-success", spin: _vm.loadingQueues || _vm.loadingInstances, disabled: _vm.loadingQueues || _vm.loadingInstances } }, on: { button: _vm.refreshQueuesFor }, model: { value: _vm.documentQueueId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.documentQueueId = $$v;
  }, "callback"), expression: "documentQueueId" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Document Queue to upload to")])], 1) : _vm._e()], 1)], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  EzescanServerInstanceComponent$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "610432d0"
);
const EzescanServerInstanceComponent = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a2;
let EzeScanStage$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "loadingRoutes", !1);
    __publicField(this, "loadingInstances", !1);
    __publicField(this, "universal", !0);
    __publicField(this, "value");
  }
  mounted() {
  }
  refreshRoutesFor() {
    return this.loadingRoutes = !0, this.$store.dispatch("administration/ezescan/loadRoutesFor", { id: this.processor.targetId, universal: this.universal }).finally(() => this.loadingRoutes = !1);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get processor() {
    return this.model.processor;
  }
  set processor(value) {
    this.model = { ...this.model, processor: value };
  }
  get returnType() {
    return this.processor.returnType;
  }
  set returnType(value) {
    this.processor = { ...this.processor, returnType: value };
  }
  get returnTypes() {
    return returnTypes;
  }
  async toggleUniversal(value) {
    this.universal = value, await this.refreshRoutesFor();
  }
}, __name(_a2, "EzeScanStage"), _a2);
__decorateClass([
  Prop({
    required: !0
  })
], EzeScanStage$1.prototype, "value", 2);
EzeScanStage$1 = __decorateClass([
  Component({
    components: { ReactiveDropdown, EzescanServerInstanceComponent }
  })
], EzeScanStage$1);
const returnTypes = [
  { name: "None", id: "none", icon: "ban" },
  { name: "Single", id: "single", icon: "file" },
  { name: "Multiple (Split)", id: "multiple", icon: "copy" }
];
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-md-12" }, [_c("ezescan-server-instance-component", { model: { value: _vm.processor, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.processor = $$v;
  }, "callback"), expression: "processor" } }), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Return type")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { options: _vm.returnTypes }, model: { value: _vm.returnType, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.returnType = $$v;
  }, "callback"), expression: "returnType" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("How is the item expected to return?")])], 1)], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  EzeScanStage$1,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "eb2a2cdf"
);
const EzeScanStage = __component__.exports;
export {
  EzescanServerInstanceComponent as E,
  EzeScanStage as a
};
