var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, n as normalizeComponent, L as LoadingBarComponent, t as toastr } from "./main-DAVWuHbi.js";
import { E as EndpointSetting } from "./endpointSetting-BGne5Ml_.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass$2"), _a;
let ExternalApiEndpointEditorComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "template");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get name() {
    return this.model.name;
  }
  set name(value) {
    this.model = { ...this.model, name: value };
  }
  get description() {
    return this.model.description;
  }
  set description(value) {
    this.model = { ...this.model, description: value };
  }
  getSetting(id) {
    return this.settings == null ? null : this.settings.find((v) => v.id === id) || null;
  }
  setSetting(id, input) {
    let matched = this.settings.find((v) => v.id === id), newSettings = this.settings ? [...this.settings] : [];
    matched ? newSettings.splice(newSettings.indexOf(matched), 1, input) : newSettings.push(input), this.settings = newSettings;
  }
  getTemplate(value) {
    return this.template.find((t) => t.id === value);
  }
  get settings() {
    return this.model && this.model.settings ? this.model.settings : [];
  }
  set settings(value) {
    this.model = { ...this.model, settings: value };
  }
}, __name(_a, "ExternalApiEndpointEditorComponent"), _a);
__decorateClass$2([
  Prop({
    required: !0
  })
], ExternalApiEndpointEditorComponent.prototype, "value", 2);
__decorateClass$2([
  Prop({
    required: !0
  })
], ExternalApiEndpointEditorComponent.prototype, "template", 2);
ExternalApiEndpointEditorComponent = __decorateClass$2([
  Component({
    components: { EndpointSetting },
    inject: ["$validator"]
  })
], ExternalApiEndpointEditorComponent);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("name") } }, [_c("div", { staticClass: "badge badge-info" }, [_vm._v("Required")]), _vm._v(` 
        `), _c("label", [_vm._v("Endpoint Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.name, expression: "name" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", attrs: { name: "name" }, domProps: { value: _vm.name }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.name = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v("Name required")]) : _vm._e(), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Name for the endpoint instance")])]), _vm._v(" "), _c("div", { staticClass: "form-group", class: { "has-error": _vm.errors.has("description") } }, [_c("div", { staticClass: "badge badge-info" }, [_vm._v("Required")]), _vm._v(` 
        `), _c("label", [_vm._v("Description")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.description, expression: "description" }, { name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], staticClass: "form-control", attrs: { name: "description" }, domProps: { value: _vm.description }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.description = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.has("description") ? _c("p", { staticClass: "text-danger" }, [_vm._v("Description required")]) : _vm._e(), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Description for the endpoint instance")])]), _vm._v(" "), _vm._l(_vm.settings, function(setting) {
    return _c("endpoint-setting", { key: setting.id, attrs: { template: _vm.getTemplate(setting.id), value: _vm.getSetting(setting.id) }, on: { input: /* @__PURE__ */ __name(function($event) {
      return _vm.setSetting(setting.id, $event);
    }, "input") } });
  })], 2);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  ExternalApiEndpointEditorComponent,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "f12d89f9"
);
const ExternalApiEndpointEditor = __component__$2.exports;
var __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass$1"), _a2;
let AdministrationExternalApisEndpointsComponent = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "removing", !1);
  }
  async edit(index) {
    let instanceId = this.instances[index].id;
    await this.$store.dispatch("administration/externalApis/endpoints/actions/editInstance", instanceId), await this.$nextTick(), await this.initialiseDefaultSettings();
  }
  async remove(id) {
    let instance = this.instances.find((y) => y.id == id);
    if (instance == null) {
      await this.cancel();
      return;
    }
    let instanceId = instance.id;
    this.removing = !0;
    try {
      await this.$store.dispatch("administration/externalApis/endpoints/actions/removeInstance", instanceId);
    } catch (e) {
      toastr.error(e, "Failed to remove externalApi endpoint");
    } finally {
      this.removing = !1;
    }
  }
  async cancel() {
    await this.$store.dispatch("administration/externalApis/endpoints/actions/cancelEditing");
  }
  mounted() {
    this.loadInstances(), this.loadEndpoints();
  }
  async loadEndpoints() {
    await this.$store.dispatch("administration/externalApis/endpoints/actions/loadEndpoints");
  }
  get loadingEndpoints() {
    return this.$store.getters["administration/externalApis/endpoints/getters/loadingEndpoints"];
  }
  get endpoints() {
    let getter = this.$store.getters["administration/externalApis/endpoints/getters/endpoints"];
    return getter ? getter.map((value) => ({
      id: value.id,
      name: value.name
    })) : null;
  }
  async loadInstances() {
    await this.$store.dispatch("administration/externalApis/endpoints/actions/loadInstances");
  }
  get loadingInstances() {
    return this.$store.getters["administration/externalApis/endpoints/getters/loadingInstances"];
  }
  get loadingInstancesError() {
    return this.$store.getters["administration/externalApis/endpoints/getters/loadingInstancesError"];
  }
  get instances() {
    return this.$store.getters["administration/externalApis/endpoints/getters/instances"];
  }
  async create(endpointId) {
    await this.$store.dispatch("administration/externalApis/endpoints/actions/createNewInstance", endpointId), await this.initialiseDefaultSettings();
  }
  get editing() {
    return this.$store.getters["administration/externalApis/endpoints/getters/editing"];
  }
  set editing(value) {
    this.$store.dispatch("administration/externalApis/endpoints/actions/updateEditingInstance", value);
  }
  async save() {
    if (await this.$validator.validateAll()) {
      if (!this.editing)
        throw new Error("No instance currently editing");
      try {
        await this.$store.dispatch("administration/externalApis/endpoints/actions/saveInstance");
      } catch (e) {
        throw toastr.error(e, "Failed to save externalApi endpoint"), e;
      }
    }
  }
  get template() {
    return this.$store.getters["administration/externalApis/endpoints/getters/template"];
  }
  get endpoint() {
    let getter = this.$store.getters["administration/externalApis/endpoints/getters/endpoints"];
    return getter ? getter.find((p) => p.id === this.editing.endpointId) : null;
  }
  get loadingEditor() {
    return this.$store.getters["administration/externalApis/endpoints/getters/loadingEditor"];
  }
  get loadingTemplate() {
    return this.$store.getters["administration/externalApis/endpoints/getters/loadingTemplate"];
  }
  get loadingTemplateError() {
    return this.$store.getters["administration/externalApis/endpoints/getters/loadingTemplateError"];
  }
  get saving() {
    return this.$store.getters["administration/externalApis/endpoints/getters/saving"];
  }
  async initialiseDefaultSettings() {
    let newSettings = [];
    this.template.settings.forEach((t) => {
      this.editing.settings.find((s) => s.id === t.id) || newSettings.push({ id: t.id, value: null });
    }), this.editing = { ...this.editing, settings: [...this.editing.settings, ...newSettings] };
  }
}, __name(_a2, "AdministrationExternalApisEndpointsComponent"), _a2);
AdministrationExternalApisEndpointsComponent = __decorateClass$1([
  Component({
    components: { ReactiveDropdown, LoadingBar: LoadingBarComponent, ExternalApiEndpointEditor }
  })
], AdministrationExternalApisEndpointsComponent);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_vm._m(0), _vm._v(" "), _c("div", { staticClass: "col-md-6" }, [_c("h4", [_vm._v(`Configured Endpoints 
            `), _c("reactive-dropdown", { attrs: { loading: _vm.loadingEndpoints, options: _vm.endpoints, "empty-clickable": "", title: "Add Endpoint" }, on: { input: _vm.create } })], 1), _vm._v(" "), _vm.loadingInstances || _vm.loadingInstancesError ? _c("div") : _vm.instances && _vm.instances.length > 0 ? _c("div", _vm._l(_vm.instances, function(instance, index) {
    return _c("a", { key: instance.id, staticClass: "list-group-item list-group-item-action", class: { active: _vm.editing && instance.id === _vm.editing.id }, attrs: { href: "javascript:void(0)" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.edit(index);
    }, "click") } }, [_c("h4", { staticClass: "list-group-item-heading" }, [instance.name ? _c("span", [_vm._v(_vm._s(instance.name))]) : _c("span", [_c("em", [_vm._v("Unnamed Endpoint")])]), _vm._v(" "), _c("span", { staticClass: "float-right" }, [_vm.editing && instance.id === _vm.editing.id ? _c("font-awesome-icon", { attrs: { icon: "arrow-right" } }) : _vm._e()], 1)]), _vm._v(" "), _c("span", { staticClass: "clearfix" }), _vm._v(" "), _c("p", { staticClass: "list-group-item-text" }, [_vm._v(`
                    ` + _vm._s(instance.description) + `
                `)])]);
  }), 0) : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
            No endpoints currently configured
        `)])]), _vm._v(" "), _c("div", { staticClass: "col-md-6" }, [_vm.loadingEditor || _vm.loadingTemplate ? _c("loading-bar") : _vm.editing ? _c("div", [_vm.endpoint ? [_c("h3", [_vm._v(_vm._s(_vm.endpoint.name) + `
                    `), _vm.editing.id ? _vm._e() : [_c("small", [_vm._v("(New)")])], _vm._v(" "), _c("span", { staticClass: "float-right" }, [_vm.editing ? _c("button", { staticClass: "btn btn-danger", on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.remove(_vm.editing.id);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1) : _vm._e()])], 2), _vm._v(" "), _c("h6", [_c("a", { attrs: { role: "link", href: _vm.endpoint.website } }, [_vm._v("Endpoint Website")])]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v(_vm._s(_vm.endpoint.description))])] : _vm._e(), _vm._v(" "), _vm.loadingTemplate || _vm.loadingEditor ? _c("loading-bar") : _vm.loadingTemplateError ? _c("div", { staticClass: "alert alert-danger" }, [_vm._v(`
                Failed to load endpoint. `), _c("a", { attrs: { href: "javascript:void(0)" }, on: { click: _vm.loadEndpointTemplate } }, [_vm._v("Try again?")])]) : _vm.template ? [_c("external-api-endpoint-editor", { attrs: { template: _vm.template.settings }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } }), _vm._v(" "), _c("button", { staticClass: "btn btn-success", attrs: { role: "button", disabled: _vm.saving || _vm.errors.any() }, on: { click: _vm.save } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save
                `)], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-default", attrs: { role: "button" }, on: { click: _vm.cancel } }, [_vm._v(`
                    Cancel
                `)])] : _vm._e()], 2) : _vm._e()], 1)]);
}, "render"), _sfc_staticRenderFns$1 = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "col-md-12" }, [_c("h4", [_vm._v("External API Endpoints")]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Configure external API endpoints that your pages can use")])]);
}], __component__$1 = /* @__PURE__ */ normalizeComponent(
  AdministrationExternalApisEndpointsComponent,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  "584c690e"
);
const ExternalApiEndpoints = __component__$1.exports;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a3;
let AdministrationExternalApisManagementComponent = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "selected", null);
  }
  mounted() {
    this.selectTab("instances");
  }
  async selectTab(value) {
    switch (this.selected = value, this.selected) {
      case "instances":
        await this.loadEndpoints();
        break;
    }
  }
  async loadEndpoints() {
  }
  async loadTransactions() {
  }
}, __name(_a3, "AdministrationExternalApisManagementComponent"), _a3);
AdministrationExternalApisManagementComponent = __decorateClass([
  Component({
    components: {
      ExternalApiEndpoints
    }
  })
], AdministrationExternalApisManagementComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_c("font-awesome-icon", { attrs: { icon: "feather" } }), _vm._v(" External APIs")], 1)]), _vm._v(" "), _c("div", { staticClass: "mb-4" }, [_c("ul", { staticClass: "nav nav-tabs", attrs: { id: "myTab", role: "tablist" } }, [_c("li", { staticClass: "nav-item" }, [_c("a", { staticClass: "nav-link", class: { active: this.selected === "instances", "nav-link": !0 }, attrs: { title: "Manage external api endpoints", id: "instances-tab", "data-toggle": "tab", href: "#instances", role: "tab", "aria-controls": "instances", "aria-selected": "true" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.selectTab("instances");
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "store-alt" } }), _vm._v(`
                    Endpoints
                `)], 1)])])]), _vm._v(" "), _c("div", { staticClass: "tab-content" }, [_c("div", { staticClass: "container-fluid" }, [_vm.selected === "instances" ? _c("external-api-endpoints") : _vm._e()], 1)])]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AdministrationExternalApisManagementComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "574b7153"
);
const externalApis = __component__.exports;
export {
  externalApis as default
};
