var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, P as Prop, C as Component, n as normalizeComponent, x as getBrowserTheme, w as createUrl, y as CodeEditor, b6 as AdministrationAppsIndexingClient, T as Transformer, b as baseUrl, t as toastr, b7 as FileSystemDepthModel, b8 as AzureDepthModel, b9 as AdministrationMicrosoftClient, W as Watch, ba as EmailImportModesModel, g as v4, z as systemInAzureMode, _, f as draggable, L as LoadingBarComponent } from "./main-DAVWuHbi.js";
import RiaGeneral from "./general-Bh4OwfCN.js";
import PageFields from "./fields-CDjhj8cM.js";
import { R as ReactiveDropdown } from "./reactiveDropdown-7DeXBEKf.js";
import { D as DefaultableTextbox } from "./defaultableTextbox-DRxGWG_3.js";
import { P as PermissionEditor } from "./permissionEditor-CEAGzDpF.js";
import { c as configuration } from "./configuration-CoROFe-z.js";
import RiaPreProcessing from "./preProcessing-CZo94Ysu.js";
import RiaQueues from "./queues-DHyi3Hk_.js";
import RiaDisplay from "./display-D3CkKbNC.js";
import { P as PlaceholderInformation } from "./placeholderInformation-CJo0noa4.js";
import { E as ExternalConnectionDropDown } from "./externalConnectionDropDown-Du88bMty.js";
import { C as ContainerSelectionComponent } from "./containerSelector-DJmnNR6h.js";
import { Q as QueueLookup } from "./queueLookup-OcOypJ-M.js";
import IndexingCustomActionsConfigurationComponent from "./indexingCustomActionsConfiguration-DFG85Gmf.js";
var __defProp$f = Object.defineProperty, __getOwnPropDesc$f = Object.getOwnPropertyDescriptor, __decorateClass$f = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$f(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$f(target, key, result), result;
}, "__decorateClass$f"), _a;
let RiaInput$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "tab", "upload");
    __publicField(this, "loadingScanProfiles", !1);
  }
  mounted() {
    this.refreshScanProfiles();
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get importPath() {
    return this.model.import.path;
  }
  get defaultImportPath() {
    return "~/App_Data/RIA/" + this.model.id + "/Import";
  }
  set importPath(path) {
    this.model = { ...this.model, ...this.model, import: { ...this.model.import, path } };
  }
  get metadataXPath() {
    return this.model.import.metadataXPath;
  }
  set metadataXPath(path) {
    this.model = { ...this.model, ...this.model, import: { ...this.model.import, metadataXPath: path } };
  }
  get requireImportMetadata() {
    return this.model.import.requireImportMetadata;
  }
  set requireImportMetadata(value) {
    this.model = { ...this.model, ...this.model, import: { ...this.model.import, requireImportMetadata: value } };
  }
  get scanProfileId() {
    return this.model.import.scanProfileId != null ? this.model.import.scanProfileId[0] : null;
  }
  get fileTypeWhitelist() {
    return this.model.import.fileTypeWhitelist;
  }
  set fileTypeWhitelist(fileTypeWhitelist) {
    this.model = { ...this.model, ...this.model, import: { ...this.model.import, fileTypeWhitelist } };
  }
  get allowUploads() {
    return this.model.import.allowUploads || !1;
  }
  set allowUploads(value) {
    this.model = { ...this.model, ...this.model, import: { ...this.model.import, allowUploads: value } };
  }
  get uploadPermissions() {
    return this.model.import.uploadUsers || [];
  }
  set uploadPermissions(value) {
    this.model = { ...this.model, ...this.model, import: { ...this.model.import, uploadUsers: value } };
  }
  set scanProfileId(value) {
    this.model.import = { ...this.model.import, scanProfileId: [value] };
  }
  refreshScanProfiles() {
    return this.loadingScanProfiles = !0, this.$store.dispatch("administration/scanProfiles/load").finally(() => this.loadingScanProfiles = !1);
  }
  get profiles() {
    let profiles = this.$store.getters["administration/scanProfiles/get"];
    if (profiles) {
      let defaultProfile = profiles.find((p) => p.default);
      return defaultProfile ? profiles.unshift(this.defaultOption(defaultProfile.name)) : profiles.unshift(this.defaultOption(null)), profiles.map((p) => ({
        id: p.id,
        icon: null,
        name: p.name
      }));
    }
    return [];
  }
  get captureFields() {
    return [{ name: "No Field", id: null }, ...(this.model.fields || []).filter((f) => {
      switch (f.type) {
        case "custom":
          return !0;
      }
      return !1;
    }).map((f) => {
      let matched = configuration.find((c) => c.id === f.type);
      return {
        id: f.id,
        name: f.name,
        icon: (matched || {}).icon || null
      };
    })];
  }
  get captureField() {
    return this.model && this.model.import && this.model.import.capture && this.model.import.capture.fields ? this.model.import.capture.fields.find(() => !0) : null;
  }
  set captureField(id) {
    this.model = { ...this.model, import: { ...this.model.import, capture: { ...this.model.import.capture, fields: id ? [id] : [] } } };
  }
  defaultOption(name) {
    return name ? {
      id: null,
      name: "Site Default (" + name + ")",
      default: !1,
      scanSettings: null
    } : { id: null, name: "Site Default", default: !1, scanSettings: null };
  }
}, __name(_a, "RiaInput"), _a);
__decorateClass$f([
  Prop({
    required: !0
  })
], RiaInput$1.prototype, "value", 2);
RiaInput$1 = __decorateClass$f([
  Component({
    components: { PermissionsEditor: PermissionEditor, ReactiveDropdown, DefaultableTextbox }
  })
], RiaInput$1);
var _sfc_render$f = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-row", [_c("b-col", { attrs: { sm: "12", md: "4", xl: "2" } }, [_c("b-list-group", { ref: "actions" }, [_c("b-list-group-item", { ref: "upload", attrs: { active: _vm.tab === "upload", href: "#" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.tab = "upload";
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "upload" } }), _vm._v(` Upload & Import
            `)], 1), _vm._v(" "), _c("b-list-group-item", { ref: "capture", attrs: { active: _vm.tab === "capture", href: "#" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.tab = "capture";
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "camera" } }), _vm._v(` Scanning & Capture
            `)], 1)], 1)], 1), _vm._v(" "), _c("b-col", { attrs: { sm: "12", md: "8", xl: "6" } }, [_vm.tab === "upload" ? _c("div", [_c("h3", [_vm._v("Upload & Import")]), _vm._v(" "), _c("b-form-group", { attrs: { description: "Allow users to upload documents to the page." } }, [_c("b-form-checkbox", { attrs: { name: "allowUploadsSwitch", switch: "" }, model: { value: _vm.allowUploads, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.allowUploads = $$v;
  }, "callback"), expression: "allowUploads" } }, [_c("b", [_vm._v("Allow User Uploads")])])], 1), _vm._v(" "), _vm.allowUploads ? _c("b-form-group", { attrs: { description: "Configure which file type extensions are allowed to be uploaded to this page (without any periods). Leave blank to allow all file types." } }, [_c("b", [_vm._v("Restrict File Types")]), _vm._v(" "), _c("b-form-tags", { attrs: { separator: ";", placeholder: "Add an extension", "add-on-change": "", "no-add-on-enter": !1, "remove-on-delete": !0 }, model: { value: _vm.fileTypeWhitelist, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.fileTypeWhitelist = $$v;
  }, "callback"), expression: "fileTypeWhitelist" } })], 1) : _vm._e(), _vm._v(" "), _vm.allowUploads ? _c("permissions-editor", { attrs: { "element-id": "riaQueue" }, model: { value: _vm.uploadPermissions, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.uploadPermissions = $$v;
  }, "callback"), expression: "uploadPermissions" } }) : _vm._e()], 1) : _vm._e(), _vm._v(" "), _vm.tab === "capture" ? _c("div", [_c("h3", [_vm._v("Scanning & Capture")]), _vm._v(" "), _c("b-form-group", [_c("b", [_vm._v("Capture field")]), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { options: _vm.captureFields }, model: { value: _vm.captureField, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.captureField = $$v;
  }, "callback"), expression: "captureField" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Select a field to prompt the user to enter on a capture device.")])], 1), _vm._v(" "), _c("b-form-group", [_c("b", [_vm._v("Scan Profile")]), _vm._v(" "), _c("div", { staticClass: "input-group" }, [_c("reactive-dropdown", { attrs: { options: _vm.profiles, loading: _vm.loadingScanProfiles, button: { icon: "sync", class: "btn-success", spin: _vm.loadingScanProfiles, disabled: _vm.loadingScanProfiles } }, on: { button: _vm.refreshScanProfiles }, model: { value: _vm.scanProfileId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.scanProfileId = $$v;
  }, "callback"), expression: "scanProfileId" } })], 1), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Scan profile to use when scanning new items into this page.")])])], 1) : _vm._e()])], 1);
}, "render"), _sfc_staticRenderFns$f = [], __component__$f = /* @__PURE__ */ normalizeComponent(
  RiaInput$1,
  _sfc_render$f,
  _sfc_staticRenderFns$f,
  !1,
  null,
  "79b2f787"
);
const RiaInput = __component__$f.exports;
var __defProp$e = Object.defineProperty, __getOwnPropDesc$e = Object.getOwnPropertyDescriptor, __decorateClass$e = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$e(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$e(target, key, result), result;
}, "__decorateClass$e"), _a2;
let RiaNotifications$2 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "editPendingNotification", !1);
    __publicField(this, "pendingNotificationContent", "");
    __publicField(this, "pendingFileName", "RIA-NewPendingFiles.html");
    __publicField(this, "editReactivatedNotification", !1);
    __publicField(this, "reactivatedNotificationContent", "");
    __publicField(this, "reactivatedFileName", "RIA-Reactivated.html");
    __publicField(this, "editRoutedNotification", !1);
    __publicField(this, "routedNotificationContent", "");
    __publicField(this, "routedFileName", "RIA-Route.html");
    __publicField(this, "uniquePlaceHolderInfoPending", [
      { syntax: "{{numberOfFiles}}", description: "The number of files the notification is for." },
      { syntax: "{{siteLogo}}", description: "The website's logo." },
      { syntax: "{{pageLink}}", description: "The link to the page the notification is about." },
      { syntax: "{{siteUrl}}", description: "The website's base url." }
    ]);
    __publicField(this, "uniquePlaceHolderInfoRouted", [
      { syntax: "{{numberOfFiles}}", description: "The number of files the notification is for." },
      { syntax: "{{siteLogo}}", description: "The website's logo." },
      { syntax: "{{pageLink}}", description: "The link to the page the notification is about." },
      { syntax: "{{sourceUser}}", description: "The user performing the action." },
      { syntax: "{{comments}}", description: "The comments for the route action." },
      { syntax: "{{pendingFileName}}", description: "The file name for the file routed." },
      { syntax: "{{siteUrl}}", description: "The website's base url." }
    ]);
    __publicField(this, "uniquePlaceHolderInfoReactivated", [
      { syntax: "{{numberOfFiles}}", description: "The number of files the notification is for." },
      { syntax: "{{siteLogo}}", description: "The website's logo." },
      { syntax: "{{pageLink}}", description: "The link to the page the notification is about." },
      { syntax: "{{sourceUser}}", description: "The user performing the action." },
      { syntax: "{{pendingFileName}}", description: "The file name for the file reactivated." },
      { syntax: "{{siteUrl}}", description: "The website's base url." }
    ]);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  async editRoutedNotificationTemplate() {
    if (this.editRoutedNotification) {
      this.editRoutedNotification = !1;
      return;
    }
    let client = new AdministrationAppsIndexingClient(new Transformer(), baseUrl());
    try {
      let response = await client.getNotificationTemplate(this.model.id, this.routedFileName);
      this.routedNotificationContent = response;
    } catch (ex) {
      toastr.error(ex, "Failed to retrieve template");
    } finally {
      this.editRoutedNotification = !0;
    }
  }
  async saveRoutedNotification() {
    let client = new AdministrationAppsIndexingClient(new Transformer(), baseUrl());
    try {
      let response = await client.setNotificationTemplate(this.model.id, this.routedNotificationContent, this.routedFileName);
      this.routedNotificationContent = response, toastr.success("Saved 'Custom Routed template' successfully");
    } catch (ex) {
      toastr.error(ex, "Failed to save");
    } finally {
      this.editRoutedNotification = !1;
    }
  }
  async editReactivatedNotificationTemplate() {
    if (this.editReactivatedNotification) {
      this.editReactivatedNotification = !1;
      return;
    }
    let client = new AdministrationAppsIndexingClient(new Transformer(), baseUrl());
    try {
      let response = await client.getNotificationTemplate(this.model.id, this.reactivatedFileName);
      this.reactivatedNotificationContent = response;
    } catch (ex) {
      toastr.error(ex, "Failed to retrieve template");
    } finally {
      this.editReactivatedNotification = !0;
    }
  }
  async saveReactivatedNotification() {
    let client = new AdministrationAppsIndexingClient(new Transformer(), baseUrl());
    try {
      let response = await client.setNotificationTemplate(this.model.id, this.reactivatedNotificationContent, this.reactivatedFileName);
      this.reactivatedNotificationContent = response, toastr.success("Saved 'Custom Reactivated template' successfully");
    } catch (ex) {
      toastr.error(ex, "Failed to save");
    } finally {
      this.editReactivatedNotification = !1;
    }
  }
  async editPendingNotificationTemplate() {
    if (this.editPendingNotification) {
      this.editPendingNotification = !1;
      return;
    }
    let client = new AdministrationAppsIndexingClient(new Transformer(), baseUrl());
    try {
      let response = await client.getNotificationTemplate(this.model.id, this.pendingFileName);
      this.pendingNotificationContent = response;
    } catch (ex) {
      toastr.error(ex, "Failed to retrieve template");
    } finally {
      this.editPendingNotification = !0;
    }
  }
  async savePendingNotification() {
    let client = new AdministrationAppsIndexingClient(new Transformer(), baseUrl());
    try {
      let response = await client.setNotificationTemplate(this.model.id, this.pendingNotificationContent, this.pendingFileName);
      this.pendingNotificationContent = response, toastr.success("Saved 'Custom pending template' successfully");
    } catch (ex) {
      toastr.error(ex, "Failed to save");
    } finally {
      this.editPendingNotification = !1;
    }
  }
}, __name(_a2, "RiaNotifications"), _a2);
__decorateClass$e([
  Prop({
    required: !0
  })
], RiaNotifications$2.prototype, "value", 2);
RiaNotifications$2 = __decorateClass$e([
  Component({
    components: {
      PlaceholderInformation,
      CodeEditor
    },
    methods: {
      createUrl,
      getBrowserTheme
    }
  })
], RiaNotifications$2);
var _sfc_render$e = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "card-header" }, [_c("button", { staticClass: "btn btn-primary float-right", on: { click: _vm.editPendingNotificationTemplate } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(` Edit
        `)], 1), _vm._v(" "), _c("h4", [_vm._v("Custom Pending Items HTML")])]), _vm._v(" "), _c("div", { directives: [{ name: "show", rawName: "v-show", value: _vm.editPendingNotification, expression: "editPendingNotification" }], staticClass: "card-body" }, [_c("button", { staticClass: "btn btn-success float-right mb-1", on: { click: _vm.savePendingNotification } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save HTML file
        `)], 1), _vm._v(" "), _c("p", [_vm._v("This HTML will be used when pending items notitification is sent out. You can use the special "), _c("placeholder-information", { attrs: { "unique-placeholders": _vm.uniquePlaceHolderInfoPending } }), _vm._v(" to enhance the notification.")], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("code-editor", { attrs: { width: "100%", languages: [["html", "HTML"]], height: "50vh", theme: _vm.getBrowserTheme() }, model: { value: _vm.pendingNotificationContent, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pendingNotificationContent = $$v;
  }, "callback"), expression: "pendingNotificationContent" } })], 1)]), _vm._v(" "), _c("div", { staticClass: "card-header" }, [_c("button", { staticClass: "btn btn-primary float-right", on: { click: _vm.editRoutedNotificationTemplate } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(` Edit
        `)], 1), _vm._v(" "), _c("h4", [_vm._v("Custom Routed HTML")])]), _vm._v(" "), _c("div", { directives: [{ name: "show", rawName: "v-show", value: _vm.editRoutedNotification, expression: "editRoutedNotification" }], staticClass: "card-body" }, [_c("button", { staticClass: "btn btn-success float-right mb-1", on: { click: _vm.saveRoutedNotification } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save HTML file
        `)], 1), _vm._v(" "), _c("p", [_vm._v("This HTML will be used when an item has been routed. You can use the special "), _c("placeholder-information", { attrs: { "unique-placeholders": _vm.uniquePlaceHolderInfoRouted } }), _vm._v(" to enhance the notification.")], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("code-editor", { attrs: { width: "100%", languages: [["html", "HTML"]], height: "50vh", theme: _vm.getBrowserTheme() }, model: { value: _vm.routedNotificationContent, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.routedNotificationContent = $$v;
  }, "callback"), expression: "routedNotificationContent" } })], 1)]), _vm._v(" "), _c("div", { staticClass: "card-header" }, [_c("button", { staticClass: "btn btn-primary float-right", on: { click: _vm.editReactivatedNotificationTemplate } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(` Edit
        `)], 1), _vm._v(" "), _c("h4", [_vm._v("Custom Reactivated HTML")])]), _vm._v(" "), _c("div", { directives: [{ name: "show", rawName: "v-show", value: _vm.editReactivatedNotification, expression: "editReactivatedNotification" }], staticClass: "card-body" }, [_c("button", { staticClass: "btn btn-success float-right mb-1", on: { click: _vm.saveReactivatedNotification } }, [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save HTML file
        `)], 1), _vm._v(" "), _c("p", [_vm._v("This HTML will be used when an item has been reactivated. You can use the special "), _c("placeholder-information", { attrs: { "unique-placeholders": _vm.uniquePlaceHolderInfoReactivated } }), _vm._v(" to enhance the notification.")], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("code-editor", { attrs: { width: "100%", languages: [["html", "HTML"]], height: "50vh", theme: _vm.getBrowserTheme() }, model: { value: _vm.reactivatedNotificationContent, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.reactivatedNotificationContent = $$v;
  }, "callback"), expression: "reactivatedNotificationContent" } })], 1)])]);
}, "render"), _sfc_staticRenderFns$e = [], __component__$e = /* @__PURE__ */ normalizeComponent(
  RiaNotifications$2,
  _sfc_render$e,
  _sfc_staticRenderFns$e,
  !1,
  null,
  "82ed9537"
);
const TemplatesComponent = __component__$e.exports;
var __defProp$d = Object.defineProperty, __getOwnPropDesc$d = Object.getOwnPropertyDescriptor, __decorateClass$d = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$d(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$d(target, key, result), result;
}, "__decorateClass$d"), _a3;
let RiaNotifications$1 = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "editPendingNotification", !1);
    __publicField(this, "pendingNotificationContent", "");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get notifications() {
    return this.model.notifications || {};
  }
  set notifications(value) {
    this.model = { ...this.model, notifications: value };
  }
  get userRemindersEnabled() {
    return this.userRemindersDays !== 0;
  }
  set userRemindersEnabled(value) {
    value ? this.userRemindersDays = 3 : this.userRemindersDays = 0;
  }
  get userRemindersDays() {
    return this.notifications.userRemindersDays;
  }
  set userRemindersDays(value) {
    this.notifications = { ...this.notifications, userRemindersDays: value };
  }
  get managerRemindersEnabled() {
    return this.managerRemindersDays !== 0;
  }
  set managerRemindersEnabled(value) {
    value ? this.managerRemindersDays = 7 : this.managerRemindersDays = 0;
  }
  get managerRemindersDays() {
    return this.notifications.managerRemindersDays;
  }
  set managerRemindersDays(value) {
    this.notifications = { ...this.notifications, managerRemindersDays: value };
  }
  get managerRemindersAddresses() {
    return this.notifications.managerRemindersAddresses;
  }
  set managerRemindersAddresses(value) {
    this.notifications = { ...this.notifications, managerRemindersAddresses: value };
  }
  get enableCreatedNotifications() {
    return this.notifications.enableAddedNotification;
  }
  set enableCreatedNotifications(value) {
    this.notifications = { ...this.notifications, enableAddedNotification: value };
  }
  get enableRouteNotifications() {
    return this.notifications.enableRoutedNotification;
  }
  set enableRouteNotifications(value) {
    this.notifications = { ...this.notifications, enableRoutedNotification: value };
  }
  get enableReactivatedNotifications() {
    return this.notifications.enableReactivatedNotification;
  }
  set enableReactivatedNotifications(value) {
    this.notifications = { ...this.notifications, enableReactivatedNotification: value };
  }
}, __name(_a3, "RiaNotifications"), _a3);
__decorateClass$d([
  Prop({
    required: !0
  })
], RiaNotifications$1.prototype, "value", 2);
RiaNotifications$1 = __decorateClass$d([
  Component({
    components: {
      TemplatesComponent
    },
    methods: {
      createUrl
    }
  })
], RiaNotifications$1);
var _sfc_render$d = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-sm-12 col-md-4 col-xl-2" }, [_c("div", { staticClass: "list-group", attrs: { id: "list-tab", role: "tablist" } }, [_c("a", { staticClass: "list-group-item list-group-item-action active d-flex justify-content-between align-items-center", attrs: { id: "list-notifications-list", "data-toggle": "list", href: "#list-notifications", role: "tab", "aria-controls": "notifications" } }, [_vm._v(`
                    Notifications 
                    `), _vm.enableCreatedNotifications ? _c("span", { staticClass: "badge badge-pill badge-success float-right" }, [_vm._v("Enabled")]) : _c("span", { staticClass: "badge badge-pill badge-danger float-right" }, [_vm._v("Disabled")])]), _vm._v(" "), _c("a", { staticClass: "list-group-item list-group-item-action", attrs: { id: "list-reminders-list", "data-toggle": "list", href: "#list-reminders", role: "tab", "aria-controls": "reminders" } }, [_vm._v(`
                    Reminders 
                    `), _vm.userRemindersEnabled ? _c("span", { staticClass: "badge badge-pill badge-success float-right" }, [_vm._v("Enabled")]) : _c("span", { staticClass: "badge badge-pill badge-danger float-right" }, [_vm._v("Disabled")])]), _vm._v(" "), _c("a", { staticClass: "list-group-item list-group-item-action", attrs: { id: "list-templates-list", "data-toggle": "list", href: "#list-templates", role: "tab", "aria-controls": "templates", disabled: !_vm.model.id } }, [_vm._v(`
                    Templates 
                `)])])]), _vm._v(" "), _c("div", { staticClass: "col-sm-12 col-md-8 col-xl-10" }, [_c("div", { staticClass: "tab-content", attrs: { id: "nav-tabContent" } }, [_c("div", { staticClass: "tab-pane fade show active", attrs: { id: "list-notifications", role: "tabpanel", "aria-labelledby": "list-notifications-list" } }, [_c("h3", [_vm._v("Notifications")]), _vm._v(" "), _c("div", { staticClass: "alert alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` This will enable notifications to be sent when items are created or routed. 
                        Please ensure you have configured your global `), _c("a", { attrs: { href: _vm.createUrl("/Admin/Notifications#notificationConfig"), target: "_blank" } }, [_vm._v("notification settings")]), _vm._v(`.
                    `)], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "enableCreatedNotificationsSwitch", switch: "" }, model: { value: _vm.enableCreatedNotifications, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.enableCreatedNotifications = $$v;
  }, "callback"), expression: "enableCreatedNotifications" } }, [_c("b", [_vm._v("Enable item created notifications")])])], 1), _vm._v(" "), _vm._m(0)]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "enableRouteNotificationsSwitch", switch: "" }, model: { value: _vm.enableRouteNotifications, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.enableRouteNotifications = $$v;
  }, "callback"), expression: "enableRouteNotifications" } }, [_c("b", [_vm._v("Enable item routed notifications")])])], 1), _vm._v(" "), _vm._m(1)]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group" }, [_c("b-form-checkbox", { attrs: { name: "enableReactivatedNotificationsSwitch", switch: "" }, model: { value: _vm.enableReactivatedNotifications, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.enableReactivatedNotifications = $$v;
  }, "callback"), expression: "enableReactivatedNotifications" } }, [_c("b", [_vm._v("Enable item reactivated notifications")])])], 1), _vm._v(" "), _vm._m(2)])]), _vm._v(" "), _c("div", { staticClass: "tab-pane fade", attrs: { id: "list-reminders", role: "tabpanel", "aria-labelledby": "list-reminders-list" } }, [_c("h3", [_vm._v("Reminders")]), _vm._v(" "), _c("div", { staticClass: "alert alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(` This will enable reminders to be sent if an item has not yet been actioned after a period of time.
                        The global `), _c("a", { attrs: { href: _vm.createUrl("/Admin/Notifications#notificationConfig"), target: "_blank" } }, [_vm._v("notification settings")]), _vm._v(` will allow you to configure the intervals that reminders are sent at.
                    `)], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group mb-2" }, [_c("b-form-checkbox", { attrs: { name: "userRemindersEnabledSwitch", switch: "" }, model: { value: _vm.userRemindersEnabled, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.userRemindersEnabled = $$v;
  }, "callback"), expression: "userRemindersEnabled" } }, [_c("b", [_vm._v("User Reminders")])])], 1), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.userRemindersDays, expression: "userRemindersDays" }], staticClass: "form-control", attrs: { type: "number", disabled: !_vm.userRemindersEnabled, min: "0" }, domProps: { value: _vm.userRemindersDays }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.userRemindersDays = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Number of days after which a user will be reminded that old items are in the queue")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("div", { staticClass: "input-group mb-2" }, [_c("b-form-checkbox", { attrs: { name: "managerRemindersEnabledswitch", switch: "" }, model: { value: _vm.managerRemindersEnabled, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.managerRemindersEnabled = $$v;
  }, "callback"), expression: "managerRemindersEnabled" } }, [_c("b", [_vm._v("Manager Reminders")])])], 1), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.managerRemindersDays, expression: "managerRemindersDays" }], staticClass: "form-control", attrs: { type: "number", disabled: !_vm.managerRemindersEnabled, min: "0" }, domProps: { value: _vm.managerRemindersDays }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.managerRemindersDays = $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Number of days after which a manager will be reminded that old items are in a users queue")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Manager notification addresses")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.managerRemindersAddresses, expression: "managerRemindersAddresses" }], staticClass: "form-control", attrs: { type: "text", disabled: !_vm.managerRemindersEnabled }, domProps: { value: _vm.managerRemindersAddresses }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.managerRemindersAddresses = $event.target.value);
  }, "input") } }), _vm._v(" "), _vm._m(3)])]), _vm._v(" "), _c("div", { staticClass: "tab-pane fade", attrs: { id: "list-templates", role: "tabpanel", "aria-labelledby": "list-templates-list", disabled: !_vm.model.id } }, [_c("h3", [_vm._v("Templates")]), _vm._v(" "), _c("templates-component", { attrs: { value: _vm.model } })], 1)])]), _vm._v(" "), _c("div", { staticClass: "col-md-6" }), _vm._v(" "), _c("div", { staticClass: "col-md-6" })]);
}, "render"), _sfc_staticRenderFns$d = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("p", { staticClass: "text-muted" }, [_vm._v("Send notifications when items are "), _c("b", [_vm._v("created")]), _vm._v(" in a queue")]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("p", { staticClass: "text-muted" }, [_vm._v("Send notifications when items are "), _c("b", [_vm._v("routed")]), _vm._v(" into a queue")]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("p", { staticClass: "text-muted" }, [_vm._v("Send notifications when items are "), _c("b", [_vm._v("reactivated")]), _vm._v(" in a queue")]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("p", { staticClass: "text-muted" }, [_vm._v("Addresses (separated by "), _c("code", [_vm._v(";")]), _vm._v(") to send manager notifications")]);
}], __component__$d = /* @__PURE__ */ normalizeComponent(
  RiaNotifications$1,
  _sfc_render$d,
  _sfc_staticRenderFns$d,
  !1,
  null,
  "fcc6ffc0"
);
const RiaNotifications = __component__$d.exports;
var __defProp$c = Object.defineProperty, __getOwnPropDesc$c = Object.getOwnPropertyDescriptor, __decorateClass$c = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$c(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$c(target, key, result), result;
}, "__decorateClass$c"), _a4;
let ImportFileExtensions$1 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get fileExtensions() {
    return this.model.fileExtensions;
  }
  set fileExtensions(fileExtensions) {
    this.model = { ...this.model, fileExtensions };
  }
}, __name(_a4, "ImportFileExtensions"), _a4);
__decorateClass$c([
  Prop({ required: !0 })
], ImportFileExtensions$1.prototype, "value", 2);
ImportFileExtensions$1 = __decorateClass$c([
  Component({
    components: {}
  })
], ImportFileExtensions$1);
var _sfc_render$c = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-form-group", { attrs: { description: "Configure which file type extensions are allowed to be imported (without any periods). Leave blank to allow all file types." } }, [_c("b", [_vm._v("Restrict File Types")]), _vm._v(" "), _c("b-form-tags", { attrs: { placeholder: "Add an extension", "add-on-change": "", "no-add-on-enter": !1, "remove-on-delete": !0 }, model: { value: _vm.fileExtensions, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.fileExtensions = $$v;
  }, "callback"), expression: "fileExtensions" } })], 1);
}, "render"), _sfc_staticRenderFns$c = [], __component__$c = /* @__PURE__ */ normalizeComponent(
  ImportFileExtensions$1,
  _sfc_render$c,
  _sfc_staticRenderFns$c,
  !1,
  null,
  null
);
const ImportFileExtensions = __component__$c.exports;
var __defProp$b = Object.defineProperty, __getOwnPropDesc$b = Object.getOwnPropertyDescriptor, __decorateClass$b = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$b(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$b(target, key, result), result;
}, "__decorateClass$b"), _a5;
let FileSystemImportComponent$1 = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "pageId");
  }
  mounted() {
    this.value.importDirectory || (this.importDirectory = this.defaultImportDirectory);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get defaultImportDirectory() {
    return "~/App_Data/RIA/" + this.pageId + "/Import/";
  }
  get importDirectory() {
    return this.model.importDirectory;
  }
  set importDirectory(importDirectory) {
    this.model = { ...this.model, importDirectory };
  }
  get metadataXPath() {
    return this.model.metadataXPath;
  }
  set metadataXPath(metadataXPath) {
    this.model = { ...this.model, metadataXPath };
  }
  get requireImportMetadata() {
    return this.model.requireImportMetadata;
  }
  set requireImportMetadata(requireImportMetadata) {
    this.model = { ...this.model, requireImportMetadata };
  }
  get depth() {
    return this.model.depth;
  }
  set depth(depth) {
    this.model = { ...this.model, depth };
  }
  get depthModeOptions() {
    return [
      { value: FileSystemDepthModel.All, text: "All" },
      { value: FileSystemDepthModel.Root, text: "Root Directory" }
    ];
  }
}, __name(_a5, "FileSystemImportComponent"), _a5);
__decorateClass$b([
  Prop({
    required: !0
  })
], FileSystemImportComponent$1.prototype, "value", 2);
__decorateClass$b([
  Prop({
    required: !1,
    default: null
  })
], FileSystemImportComponent$1.prototype, "pageId", 2);
FileSystemImportComponent$1 = __decorateClass$b([
  Component({
    components: {
      DefaultableTextbox,
      ImportFileExtensions
    }
  })
], FileSystemImportComponent$1);
var _sfc_render$b = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Import Directory")]), _vm._v(" "), _c("defaultable-textbox", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], attrs: { name: "ImportDirectory", placeholder: "Enter a path...", defaultValue: _vm.defaultImportDirectory }, model: { value: _vm.importDirectory, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.importDirectory = $$v;
  }, "callback"), expression: "importDirectory" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Root Directory on the server to import files from.")]), _vm._v(" "), _vm.errors.first("ImportDirectory") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("ImportDirectory")))]) : _vm._e()], 1), _vm._v(" "), _c("b-form-group", { attrs: { description: "XPath syntax for the root node to pull existing metadata from. Leave blank to attempt to use WebApps Metadata format" } }, [_c("b", [_vm._v("Metadata Base Path")]), _vm._v(" "), _c("b-form-input", { ref: "metadataXPath", attrs: { name: "metadataXPath" }, model: { value: _vm.metadataXPath, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.metadataXPath = $$v;
  }, "callback"), expression: "metadataXPath" } })], 1), _vm._v(" "), _c("b-form-group", { attrs: { description: "Requires that import files from the file system are to be accompanied by a metadata (.xml) file. Files will be ignored if this is not provided." } }, [_c("b-form-checkbox", { attrs: { name: "requireImportMetadataSwitch", switch: "" }, model: { value: _vm.requireImportMetadata, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.requireImportMetadata = $$v;
  }, "callback"), expression: "requireImportMetadata" } }, [_c("b", [_vm._v("Require metadata file to import")])])], 1), _vm._v(" "), _c("import-file-extensions", { model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } }), _vm._v(" "), _c("b-form-group", { attrs: { id: "depthModeGroup", description: "Specify the folder depth to search the import directory for." } }, [_c("b", [_vm._v("Import Folder Depth")]), _vm._v(" "), _c("b-form-select", { attrs: { options: _vm.depthModeOptions }, model: { value: _vm.depth, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.depth = $$v;
  }, "callback"), expression: "depth" } })], 1)], 1);
}, "render"), _sfc_staticRenderFns$b = [], __component__$b = /* @__PURE__ */ normalizeComponent(
  FileSystemImportComponent$1,
  _sfc_render$b,
  _sfc_staticRenderFns$b,
  !1,
  null,
  null
);
const FileSystemImportComponent = __component__$b.exports;
var __defProp$a = Object.defineProperty, __getOwnPropDesc$a = Object.getOwnPropertyDescriptor, __decorateClass$a = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$a(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$a(target, key, result), result;
}, "__decorateClass$a"), _a6;
let AzureBlobStorageImportComponent$1 = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "pageId");
    __publicField(this, "uniquePlaceHolderInfo", [
      { syntax: "{{directory}}", description: "The full file path of the file to import" },
      { syntax: "{{directoryName}}", description: "The name of the folder the file is located in" }
    ]);
  }
  mounted() {
    this.value.directory || (this.directory = this.defaultDirectory);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get defaultDirectory() {
    return "RIA/" + this.pageId + "/Import/";
  }
  get container() {
    return this.model.container;
  }
  set container(value) {
    this.model = { ...this.model, container: value };
  }
  get externalConnectionId() {
    return this.model.externalConnectionId;
  }
  set externalConnectionId(value) {
    this.model = { ...this.model, externalConnectionId: value };
  }
  get directory() {
    return this.model.directory;
  }
  set directory(directory) {
    this.model = { ...this.model, directory };
  }
  get depth() {
    return this.model.depth;
  }
  set depth(depth) {
    this.model = { ...this.model, depth };
  }
  get metadataXPath() {
    return this.model.metadataXPath;
  }
  set metadataXPath(metadataXPath) {
    this.model = { ...this.model, metadataXPath };
  }
  get requireImportMetadata() {
    return this.model.requireImportMetadata;
  }
  set requireImportMetadata(requireImportMetadata) {
    this.model = { ...this.model, requireImportMetadata };
  }
  get depthModeOptions() {
    return [
      { value: AzureDepthModel.All, text: "All" },
      { value: AzureDepthModel.Root, text: "Root Directory" }
    ];
  }
}, __name(_a6, "AzureBlobStorageImportComponent"), _a6);
__decorateClass$a([
  Prop({
    required: !0
  })
], AzureBlobStorageImportComponent$1.prototype, "value", 2);
__decorateClass$a([
  Prop({
    required: !1,
    default: null
  })
], AzureBlobStorageImportComponent$1.prototype, "pageId", 2);
AzureBlobStorageImportComponent$1 = __decorateClass$a([
  Component({
    components: {
      ContainerSelectionComponent,
      ExternalConnectionDropDown,
      PlaceholderInformation,
      DefaultableTextbox,
      ImportFileExtensions
    }
  })
], AzureBlobStorageImportComponent$1);
var _sfc_render$a = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Azure Connection")]), _vm._v(" "), _c("external-connection-drop-down", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], attrs: { name: "externalConnectionId", types: ["ExternalConnection.AzureStorage", "ExternalConnection.AzureStorageBuiltIn"] }, model: { value: _vm.externalConnectionId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.externalConnectionId = $$v;
  }, "callback"), expression: "externalConnectionId" } }), _vm._v(" "), _vm.errors.first("externalConnectionId") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("externalConnectionId")))]) : _vm._e()], 1), _vm._v(" "), _c("container-selection-component", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], attrs: { name: "container", allowManual: !1, externalConnectionId: _vm.externalConnectionId }, model: { value: _vm.container, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.container = $$v;
  }, "callback"), expression: "container" } }), _vm._v(" "), _vm.errors.first("container") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("container")))]) : _vm._e(), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Import Directory")]), _vm._v(" "), _c("defaultable-textbox", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], attrs: { name: "directory", placeholder: "Enter a path...", defaultValue: _vm.defaultDirectory }, model: { value: _vm.directory, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.directory = $$v;
  }, "callback"), expression: "directory" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Root Directory on the container to import files from.")]), _vm._v(" "), _vm.errors.first("directory") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("directory")))]) : _vm._e()], 1), _vm._v(" "), _c("b-form-group", { attrs: { description: "XPath syntax for the root node to pull existing metadata from. Leave blank to attempt to use WebApps Metadata format" } }, [_c("b", [_vm._v("Metadata Base Path")]), _vm._v(" "), _c("b-form-input", { ref: "metadataXPath", attrs: { name: "metadataXPath" }, model: { value: _vm.metadataXPath, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.metadataXPath = $$v;
  }, "callback"), expression: "metadataXPath" } })], 1), _vm._v(" "), _c("b-form-group", { attrs: { description: "Requires that import files from the file system are to be accompanied by a metadata (.xml) file. Files will be ignored if this is not provided." } }, [_c("b-form-checkbox", { attrs: { name: "requireImportMetadataSwitch", switch: "" }, model: { value: _vm.requireImportMetadata, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.requireImportMetadata = $$v;
  }, "callback"), expression: "requireImportMetadata" } }, [_c("b", [_vm._v("Require metadata file to import")])])], 1), _vm._v(" "), _c("import-file-extensions", { model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.model = $$v;
  }, "callback"), expression: "model" } }), _vm._v(" "), _c("b-form-group", { attrs: { id: "depthModeGroup", description: "Specify the folder depth to search the import directory for." } }, [_c("b", [_vm._v("Import Folder Depth")]), _vm._v(" "), _c("b-form-select", { attrs: { options: _vm.depthModeOptions }, model: { value: _vm.depth, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.depth = $$v;
  }, "callback"), expression: "depth" } })], 1)], 1);
}, "render"), _sfc_staticRenderFns$a = [], __component__$a = /* @__PURE__ */ normalizeComponent(
  AzureBlobStorageImportComponent$1,
  _sfc_render$a,
  _sfc_staticRenderFns$a,
  !1,
  null,
  null
);
const AzureBlobStorageImportComponent = __component__$a.exports;
var __defProp$9 = Object.defineProperty, __getOwnPropDesc$9 = Object.getOwnPropertyDescriptor, __decorateClass$9 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$9(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$9(target, key, result), result;
}, "__decorateClass$9"), _a7;
let MicrosoftEmailSourceFolderListItem$1 = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "externalConnectionId");
    __publicField(this, "mailBox");
    __publicField(this, "mailBoxFolder");
    __publicField(this, "indentValue");
    __publicField(this, "selectedId");
    __publicField(this, "folderPathIds");
    __publicField(this, "loadingChildFolders", !1);
    __publicField(this, "loadedChildFolders", !1);
    __publicField(this, "childMailBoxFolders", []);
    __publicField(this, "administrationMicrosoftClient", new AdministrationMicrosoftClient(new Transformer(), baseUrl()));
  }
  async mounted() {
    (!this.folderPathIds.length || !this.selectedId) && this.$emit("childrenLoaded"), this.folderPathIds.includes(this.mailBoxFolder.id) && (this.selectedId === this.mailBoxFolder.id ? this.$emit("childrenLoaded") : await this.loadChildFolder());
  }
  setChildrenLoaded() {
    this.$emit("childrenLoaded");
  }
  async loadChildFolder() {
    this.loadedChildFolders ? (this.loadedChildFolders = !1, this.childMailBoxFolders = []) : (this.loadingChildFolders = !0, this.childMailBoxFolders = await this.administrationMicrosoftClient.getEmailMailboxChildrenFolders(this.externalConnectionId, this.mailBox, this.mailBoxFolder.id), this.loadedChildFolders = !0, this.loadingChildFolders = !1);
  }
  async selectSourceFolder(selected) {
    this.$emit("selectFolder", selected);
  }
}, __name(_a7, "MicrosoftEmailSourceFolderListItem"), _a7);
__decorateClass$9([
  Prop({ required: !0 })
], MicrosoftEmailSourceFolderListItem$1.prototype, "externalConnectionId", 2);
__decorateClass$9([
  Prop({ required: !0 })
], MicrosoftEmailSourceFolderListItem$1.prototype, "mailBox", 2);
__decorateClass$9([
  Prop({ required: !0 })
], MicrosoftEmailSourceFolderListItem$1.prototype, "mailBoxFolder", 2);
__decorateClass$9([
  Prop({ required: !1, default: 1 })
], MicrosoftEmailSourceFolderListItem$1.prototype, "indentValue", 2);
__decorateClass$9([
  Prop({ required: !1, default: "" })
], MicrosoftEmailSourceFolderListItem$1.prototype, "selectedId", 2);
__decorateClass$9([
  Prop({ required: !1, default: [] })
], MicrosoftEmailSourceFolderListItem$1.prototype, "folderPathIds", 2);
MicrosoftEmailSourceFolderListItem$1 = __decorateClass$9([
  Component(
    {
      components: {
        ExternalConnectionDropDown,
        DefaultableTextbox
      },
      name: "microsoft-email-source-folder-list-item"
    }
  )
], MicrosoftEmailSourceFolderListItem$1);
var _sfc_render$9 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-list-group-item", { staticClass: "d-flex justify-content-between align-items-center", style: "padding-left: " + _vm.indentValue * 15 + "px" }, [_c("b-button", { attrs: { variant: "link" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.selectSourceFolder(_vm.mailBoxFolder);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: _vm.selectedId === _vm.mailBoxFolder.id ? "circle-check" : "fa-light fa-circle" } }), _vm._v(`
          ` + _vm._s(_vm.mailBoxFolder.name) + `
        `)], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "link", disabled: _vm.loadingChildFolders || _vm.loadedChildFolders && !_vm.childMailBoxFolders.length }, on: { click: _vm.loadChildFolder } }, [_vm.loadingChildFolders ? _c("b-spinner", { attrs: { small: "" } }) : _c("font-awesome-icon", { attrs: { spin: _vm.loadingChildFolders, icon: _vm.loadedChildFolders ? "caret-down" : "caret-right" } })], 1)], 1), _vm._v(" "), _vm._l(_vm.childMailBoxFolders, function(mailBoxFolder) {
    return _c("microsoft-email-source-folder-list-item", { attrs: { "mail-box": _vm.mailBox, name: mailBoxFolder.id, "external-connection-id": _vm.externalConnectionId, "mail-box-folder": mailBoxFolder, "indent-value": _vm.indentValue + 1, selectedId: _vm.selectedId, folderPathIds: _vm.folderPathIds }, on: { selectFolder: _vm.selectSourceFolder, childrenLoaded: /* @__PURE__ */ __name(function($event) {
      return _vm.setChildrenLoaded();
    }, "childrenLoaded") } });
  })], 2);
}, "render"), _sfc_staticRenderFns$9 = [], __component__$9 = /* @__PURE__ */ normalizeComponent(
  MicrosoftEmailSourceFolderListItem$1,
  _sfc_render$9,
  _sfc_staticRenderFns$9,
  !1,
  null,
  null
);
const MicrosoftEmailSourceFolderListItem = __component__$9.exports;
var __defProp$8 = Object.defineProperty, __getOwnPropDesc$8 = Object.getOwnPropertyDescriptor, __decorateClass$8 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$8(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$8(target, key, result), result;
}, "__decorateClass$8"), _a8;
let MicrosoftEmailSourceFolderSelector$1 = (_a8 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "externalConnectionId");
    __publicField(this, "mailBox");
    __publicField(this, "label");
    __publicField(this, "mailBoxFolder", null);
    __publicField(this, "mailBoxFolders", []);
    __publicField(this, "showModal", !1);
    __publicField(this, "loadingMailBoxFolders", !1);
    __publicField(this, "loadingFolderPath", !1);
    __publicField(this, "folderPathIds", []);
    __publicField(this, "folderPath", "");
    __publicField(this, "error", "");
    __publicField(this, "administrationMicrosoftClient", new AdministrationMicrosoftClient(new Transformer(), baseUrl()));
  }
  watchShowModal() {
    this.setSourceFolder();
  }
  async mounted() {
    await this.setSourceFolder();
  }
  async setSourceFolder() {
    if (this.error = "", this.model)
      try {
        this.mailBoxFolder = await this.administrationMicrosoftClient.getEmailMailboxFolder(this.externalConnectionId, this.mailBox, this.model), this.mailBoxFolders = await this.administrationMicrosoftClient.getEmailMailboxFolders(this.externalConnectionId, this.mailBox), await this.generateFolderPath();
      } catch (ex) {
        this.error = ex, toastr.error(ex, "Unable to get mail folders");
      }
  }
  async generateFolderPath() {
    this.loadingFolderPath = !0, this.folderPathIds = [this.mailBoxFolder.id];
    let localFolderPath = this.mailBoxFolder.name, folderId = this.mailBoxFolder.parentId;
    for (; folderId != null; ) {
      let folder = await this.administrationMicrosoftClient.getEmailMailboxFolder(this.externalConnectionId, this.mailBox, folderId);
      folder.name === "" || folder.name === "Top of Information Store" ? folderId = null : (this.folderPathIds.push(folderId), localFolderPath = folder.name + "/" + localFolderPath, folderId = folder.parentId);
    }
    this.folderPath = localFolderPath, this.loadingFolderPath = !1;
  }
  async showSourceFolderModal() {
    this.showModal = !this.showModal, this.loadingMailBoxFolders = !0, this.externalConnectionId && this.mailBox && (this.mailBoxFolders = await this.administrationMicrosoftClient.getEmailMailboxFolders(this.externalConnectionId, this.mailBox));
  }
  async selectSourceFolder(selected) {
    this.model = selected.id, this.mailBoxFolder = selected, this.mailBoxFolders = [], this.showModal = !this.showModal, await this.generateFolderPath();
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
}, __name(_a8, "MicrosoftEmailSourceFolderSelector"), _a8);
__decorateClass$8([
  Prop({ required: !0 })
], MicrosoftEmailSourceFolderSelector$1.prototype, "value", 2);
__decorateClass$8([
  Prop({ required: !0 })
], MicrosoftEmailSourceFolderSelector$1.prototype, "externalConnectionId", 2);
__decorateClass$8([
  Prop({ required: !0 })
], MicrosoftEmailSourceFolderSelector$1.prototype, "mailBox", 2);
__decorateClass$8([
  Prop({ required: !1, default: "Source Folder" })
], MicrosoftEmailSourceFolderSelector$1.prototype, "label", 2);
__decorateClass$8([
  Watch("value")
], MicrosoftEmailSourceFolderSelector$1.prototype, "watchShowModal", 1);
MicrosoftEmailSourceFolderSelector$1 = __decorateClass$8([
  Component({ components: { MicrosoftEmailSourceFolderListItem, ExternalConnectionDropDown, DefaultableTextbox } })
], MicrosoftEmailSourceFolderSelector$1);
var _sfc_render$8 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-form-group", { attrs: { id: "sourceFolderGroup", label: _vm.label, "label-for": "sourceFolder", description: "The email source folder to import from" } }, [_c("b-input-group", { on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.showSourceFolderModal();
  }, "click") } }, [_vm.loadingFolderPath ? _c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_c("b-spinner", { attrs: { small: "", variant: "primary" } })], 1) : _vm._e(), _vm._v(" "), _c("b-form-input", { attrs: { readonly: "", id: "sourceFolder" }, model: { value: _vm.folderPath, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.folderPath = $$v;
  }, "callback"), expression: "folderPath" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-btn", { attrs: { variant: "primary", disabled: _vm.loadingFolderPath || _vm.loadingMailBoxFolders } }, [_c("font-awesome-icon", { attrs: { icon: "search" } })], 1)], 1)], 1)], 1), _vm._v(" "), _c("b-modal", { attrs: { id: "sourceFolderModal", scrollable: "", "hide-footer": "", title: "Microsoft Email Folder Select" }, model: { value: _vm.showModal, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.showModal = $$v;
  }, "callback"), expression: "showModal" } }, [_vm.mailBox && _vm.mailBoxFolders.length ? _c("div", [_c("div", { directives: [{ name: "show", rawName: "v-show", value: _vm.loadingMailBoxFolders, expression: "loadingMailBoxFolders" }], staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1), _vm._v(" "), _c("b-list-group", { directives: [{ name: "show", rawName: "v-show", value: !_vm.loadingMailBoxFolders, expression: "!loadingMailBoxFolders" }] }, _vm._l(_vm.mailBoxFolders, function(mailBoxFolder) {
    return _c("microsoft-email-source-folder-list-item", { attrs: { "mail-box": _vm.mailBox, "external-connection-id": _vm.externalConnectionId, "mail-box-folder": mailBoxFolder, name: _vm.mailBox, selectedId: _vm.model, folderPathIds: _vm.folderPathIds }, on: { selectFolder: _vm.selectSourceFolder, childrenLoaded: /* @__PURE__ */ __name(function($event) {
      _vm.loadingMailBoxFolders = !1;
    }, "childrenLoaded") } });
  }), 1)], 1) : _vm.error ? _c("b-alert", { attrs: { show: "", variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
        An error occurred `), _c("br"), _vm._v(`
        ` + _vm._s(_vm.error) + `
      `)], 1) : _c("b-alert", { attrs: { show: "", variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
        There is no mailbox selected
      `)], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$8 = [], __component__$8 = /* @__PURE__ */ normalizeComponent(
  MicrosoftEmailSourceFolderSelector$1,
  _sfc_render$8,
  _sfc_staticRenderFns$8,
  !1,
  null,
  null
);
const MicrosoftEmailSourceFolderSelector = __component__$8.exports;
var __defProp$7 = Object.defineProperty, __getOwnPropDesc$7 = Object.getOwnPropertyDescriptor, __decorateClass$7 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$7(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$7(target, key, result), result;
}, "__decorateClass$7"), _a9;
let MicrosoftEmailImportComponent$1 = (_a9 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "pageId");
    __publicField(this, "selectedMailBoxFolderName", null);
    __publicField(this, "showModal", !1);
  }
  async mounted() {
  }
  async selectSourceFolder(selected) {
    let folder = selected[0];
    this.sourceFolder = folder.id, this.selectedMailBoxFolderName = folder.name, this.showModal = !this.showModal;
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get emailImportModeOptions() {
    return [
      { value: EmailImportModesModel.EmlFile, text: "Eml File" },
      { value: EmailImportModesModel.RenderedEmailAndAttachments, text: "Rendered Email & Attachments" },
      { value: EmailImportModesModel.RenderedEmailOnly, text: "Rendered Email Only" },
      { value: EmailImportModesModel.AttachmentsOnly, text: "Attachments Only" },
      { value: EmailImportModesModel.ItemPerAttachment, text: "Item Per Attachment" },
      { value: EmailImportModesModel.ItemPerAttachmentWithSubject, text: "Item Per Attachment with original email" },
      { value: EmailImportModesModel.ItemPerAttachmentWithRenderedSubject, text: "Item Per Attachment with rendered original" }
    ];
  }
  get emailImportModeDescription() {
    switch (this.emailImportMode) {
      case EmailImportModesModel.RenderedEmailAndAttachments:
        return "Import a rendered pdf of the email as the subject file and all email attachments will be attachments on that subject file.";
      case EmailImportModesModel.EmlFile:
        return "Import the entire email as a raw .eml file. Then use pre-processing to pull apart the email.";
      case EmailImportModesModel.RenderedEmailOnly:
        return "Import rendered pdf of the email as the subject file and ignore all attachments.";
      case EmailImportModesModel.AttachmentsOnly:
        return "The first attachment will be used as the subject and all others will be attachments on the subject file.";
      case EmailImportModesModel.ItemPerAttachment:
        return "Creates an item for each attachment on the email with no additional attachments.";
      case EmailImportModesModel.ItemPerAttachmentWithSubject:
        return "Creates an item for each attachment on the email the original email added as an attachment.";
      case EmailImportModesModel.ItemPerAttachmentWithRenderedSubject:
        return "Creates an item for each attachment on the email the original email rendered as a pdf added as an attachment.";
    }
  }
  get externalConnectionId() {
    return this.model.externalConnectionId;
  }
  set externalConnectionId(externalConnectionId) {
    this.model = { ...this.model, externalConnectionId };
  }
  get mailBox() {
    return this.model.mailBox;
  }
  set mailBox(mailBox) {
    this.model = { ...this.model, mailBox };
  }
  get emailImportMode() {
    return this.model.emailImportMode;
  }
  set emailImportMode(emailImportMode) {
    this.model = { ...this.model, emailImportMode };
  }
  get saveEmailMetadata() {
    return this.model.saveEmailMetadata;
  }
  set saveEmailMetadata(saveEmailMetadata) {
    this.model = { ...this.model, saveEmailMetadata };
  }
  get sourceFolder() {
    return this.model.sourceFolder;
  }
  set sourceFolder(sourceFolder) {
    this.model = { ...this.model, sourceFolder };
  }
}, __name(_a9, "MicrosoftEmailImportComponent"), _a9);
__decorateClass$7([
  Prop({ required: !0 })
], MicrosoftEmailImportComponent$1.prototype, "value", 2);
__decorateClass$7([
  Prop({ required: !1, default: null })
], MicrosoftEmailImportComponent$1.prototype, "pageId", 2);
MicrosoftEmailImportComponent$1 = __decorateClass$7([
  Component({ components: { MicrosoftEmailSourceFolderSelector, ExternalConnectionDropDown, DefaultableTextbox } })
], MicrosoftEmailImportComponent$1);
var _sfc_render$7 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-form-group", { attrs: { description: "External connection to Microsoft Graph API" } }, [_c("span", { staticClass: "font-weight-bold" }, [_vm._v("External Connection")]), _vm._v(" "), _c("external-connection-drop-down", { attrs: { types: ["ExternalConnection.MicrosoftGraph"] }, model: { value: _vm.externalConnectionId, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.externalConnectionId = $$v;
  }, "callback"), expression: "externalConnectionId" } })], 1), _vm._v(" "), _vm.externalConnectionId ? _c("span", [_c("b-form-group", { directives: [{ name: "show", rawName: "v-show", value: !1, expression: "false" }], attrs: { description: "Saves header information from the email to the indexing item metadata" } }, [_c("b-form-checkbox", { attrs: { name: "saveEmailMetadataSwitch", switch: "" }, model: { value: _vm.saveEmailMetadata, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.saveEmailMetadata = $$v;
  }, "callback"), expression: "saveEmailMetadata" } }, [_c("b", [_vm._v("Save email metadata")])])], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "emailImportOptionsGroup", label: "Import Mode", "label-for": "emailImportOptions", description: _vm.emailImportModeDescription } }, [_c("b-form-select", { attrs: { options: _vm.emailImportModeOptions }, model: { value: _vm.emailImportMode, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.emailImportMode = $$v;
  }, "callback"), expression: "emailImportMode" } })], 1), _vm._v(" "), _c("b-form-group", { attrs: { label: "Mailbox", "label-for": "mailBox", description: "Enter the email address for the mailbox or shared mailbox you wish to download items from" } }, [_c("b-form-input", { attrs: { name: "mailBox" }, model: { value: _vm.mailBox, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.mailBox = $$v;
  }, "callback"), expression: "mailBox" } })], 1), _vm._v(" "), _c("microsoft-email-source-folder-selector", { attrs: { "external-connection-id": _vm.externalConnectionId, "mail-box": _vm.mailBox }, model: { value: _vm.sourceFolder, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.sourceFolder = $$v;
  }, "callback"), expression: "sourceFolder" } })], 1) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns$7 = [], __component__$7 = /* @__PURE__ */ normalizeComponent(
  MicrosoftEmailImportComponent$1,
  _sfc_render$7,
  _sfc_staticRenderFns$7,
  !1,
  null,
  null
);
const MicrosoftEmailImportComponent = __component__$7.exports, defaultTarget = {
  page: {
    id: "",
    lookup: '{{ page["id"] }}',
    lookupIsId: !0
  },
  queue: null,
  queueType: {
    id: "",
    lookup: "{{ directoryName }}",
    lookupIsId: !1
  }
}, defaultDeleteCleanup = {
  typeId: "DeleteCleanup",
  discriminator: "DeleteCleanup"
}, defaultMoveEmailCleanup = {
  typeId: "MoveEmailCleanup",
  discriminator: "MoveEmailCleanup"
}, importConfigurations = [
  {
    id: "FileSystemImport",
    name: "File System",
    icon: "folder",
    cleanups: ["DeleteCleanup", "MoveCleanup"],
    component: FileSystemImportComponent,
    factory: /* @__PURE__ */ __name(() => ({
      typeId: "FileSystemImport",
      discriminator: "FileSystemImport",
      id: v4(),
      name: "File System",
      description: "",
      enabled: !0,
      cleanup: defaultDeleteCleanup,
      fileExtensions: [],
      frequencyMinutes: 1,
      importDirectory: null,
      targetConfiguration: {
        target: defaultTarget,
        advancedMode: !1,
        queueByName: "{{directoryName}}"
      },
      depth: "all"
    }), "factory")
  },
  {
    id: "AzureBlobImport",
    name: "Azure Blob Storage",
    icon: "database",
    cleanups: ["DeleteCleanup", "MoveCleanup"],
    component: AzureBlobStorageImportComponent,
    factory: /* @__PURE__ */ __name(() => ({
      typeId: "AzureBlobImport",
      discriminator: "AzureBlobImport",
      id: v4(),
      name: "Azure Blob",
      description: "",
      enabled: !0,
      cleanup: defaultDeleteCleanup,
      fileExtensions: [],
      frequencyMinutes: 1,
      externalConnectionId: null,
      directory: null,
      container: null,
      targetConfiguration: {
        target: defaultTarget,
        advancedMode: !1,
        queueByName: "{{directoryName}}"
      },
      depth: "all"
    }), "factory")
  },
  {
    id: "MicrosoftEmailImport",
    name: "Microsoft Email Import",
    icon: "envelope",
    cleanups: ["DeleteCleanup", "MoveEmailCleanup"],
    component: MicrosoftEmailImportComponent,
    factory: /* @__PURE__ */ __name(() => ({
      typeId: "MicrosoftEmailImport",
      discriminator: "MicrosoftEmailImport",
      id: v4(),
      name: "Microsoft Email Import",
      description: "",
      enabled: !0,
      cleanup: defaultMoveEmailCleanup,
      fileExtensions: [],
      frequencyMinutes: 1,
      externalConnectionId: null,
      directory: null,
      container: null,
      targetConfiguration: {
        target: {
          page: {
            id: "",
            lookup: '{{ page["id"] }}',
            lookupIsId: !0
          },
          queue: null,
          queueType: null
        },
        advancedMode: !0,
        queueByName: null
      },
      mailBox: null,
      sourceFolder: null,
      saveEmailMetadata: !0,
      emailImportMode: EmailImportModesModel.EmlFile
    }), "factory")
  }
], importConfigurations$1 = importConfigurations.sort(function(a, b) {
  return a.name.localeCompare(b.name);
});
var __defProp$6 = Object.defineProperty, __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$6(target, key, result), result;
}, "__decorateClass$6"), _a10;
let ImportBasicSettings$1 = (_a10 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "indexingImportConfigs");
    __publicField(this, "editingIndex");
    __publicField(this, "isAzureMode", !1);
  }
  created() {
    this.$validator.extend(
      "greaterThanZero",
      {
        getMessage: /* @__PURE__ */ __name((field) => field + " must be greater than zero.", "getMessage"),
        validate: /* @__PURE__ */ __name((value) => value > 0, "validate")
      }
    ), this.$validator.extend("uniqueName", {
      getMessage: /* @__PURE__ */ __name((field) => "The name is not unique", "getMessage"),
      validate: /* @__PURE__ */ __name((value) => this.nameIsUnique(this.value), "validate")
    });
  }
  async mounted() {
    this.isAzureMode = await systemInAzureMode();
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get name() {
    return this.model.name;
  }
  set name(name) {
    this.model = { ...this.model, name };
  }
  get enabled() {
    return this.model.enabled;
  }
  set enabled(enabled) {
    this.model = { ...this.model, enabled };
  }
  get discriminator() {
    return this.model.discriminator;
  }
  get frequencyMinutes() {
    return this.model.frequencyMinutes;
  }
  set frequencyMinutes(frequencyMinutes) {
    this.model = { ...this.model, frequencyMinutes };
  }
  async toggleImportEnabled() {
    this.model.enabled = !this.model.enabled;
  }
  async nameIsUnique(importConfig) {
    let isUnique = !0;
    return this.indexingImportConfigs.forEach((existingImportConfig, index) => {
      index != this.editingIndex && importConfig.name === existingImportConfig.name && (isUnique = !1);
    }), isUnique;
  }
}, __name(_a10, "ImportBasicSettings"), _a10);
__decorateClass$6([
  Prop({ required: !0 })
], ImportBasicSettings$1.prototype, "value", 2);
__decorateClass$6([
  Prop({ required: !0 })
], ImportBasicSettings$1.prototype, "indexingImportConfigs", 2);
__decorateClass$6([
  Prop({ required: !0 })
], ImportBasicSettings$1.prototype, "editingIndex", 2);
ImportBasicSettings$1 = __decorateClass$6([
  Component({
    components: {}
  })
], ImportBasicSettings$1);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("h4", [_vm._v(`
        Basic Settings
        `), _vm._t("default")], 2)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", [_c("b-form-group", { attrs: { description: "The name of the import" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Name")]), _vm._v(" "), _c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required|uniqueName", expression: "'required|uniqueName'" }], ref: "name", attrs: { name: "name" }, model: { value: _vm.name, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.name = $$v;
  }, "callback"), expression: "name" } }), _vm._v(" "), _vm.errors.first("name") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("name")))]) : _vm._e()], 1), _vm._v(" "), _c("b-form-group", { attrs: { description: "The frequency in minutes for when this import should run", id: "frequencyGroup" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Frequency (Minutes)")]), _vm._v(" "), _c("b-form-input", { directives: [{ name: "validate", rawName: "v-validate", value: "required|greaterThanZero", expression: "'required|greaterThanZero'" }], ref: "frequencyMinutes", attrs: { type: "number", min: "1", name: "FrequencyMinutes" }, model: { value: _vm.frequencyMinutes, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.frequencyMinutes = $$v;
  }, "callback"), expression: "frequencyMinutes" } }), _vm._v(" "), _vm.errors.first("FrequencyMinutes") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("FrequencyMinutes")))]) : _vm._e()], 1), _vm._v(" "), _c("b-form-group", { attrs: { description: "Prevent this configuration from importing", id: "importEnabledButtonGroup" } }, [_vm.discriminator == "FileSystemImport" && _vm.isAzureMode ? _c("b-form-checkbox", { staticClass: "ml-1", attrs: { checked: !1, disabled: "", size: "sm", name: "importEnabledButton", switch: "" } }, [_c("b", [_vm._v("Enabled")])]) : _c("b-form-checkbox", { staticClass: "ml-1", attrs: { checked: _vm.enabled, size: "sm", name: "importEnabledButton", switch: "" }, nativeOn: { click: /* @__PURE__ */ __name(function($event) {
    return $event.preventDefault(), _vm.toggleImportEnabled();
  }, "click") } }, [_c("b", [_vm._v("Enabled")])])], 1)], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  ImportBasicSettings$1,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  null
);
const ImportBasicSettings = __component__$6.exports;
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$5"), _a11;
let DeleteCleanupComponent$1 = (_a11 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
}, __name(_a11, "DeleteCleanupComponent"), _a11);
__decorateClass$5([
  Prop({
    required: !0
  })
], DeleteCleanupComponent$1.prototype, "value", 2);
DeleteCleanupComponent$1 = __decorateClass$5([
  Component({ components: {} })
], DeleteCleanupComponent$1);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "alert alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
        The file will be deleted once it has been imported.
    `)], 1)]);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  DeleteCleanupComponent$1,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  null
);
const DeleteCleanupComponent = __component__$5.exports;
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$4"), _a12;
let MoveCleanupComponent$1 = (_a12 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "pageId");
    __publicField(this, "importType");
    __publicField(this, "uniquePlaceHolderInfo", [
      { syntax: "{{directory}}", description: "The full file path of the file to import" },
      { syntax: "{{directoryName}}", description: "The name of the folder the file is located in" },
      { syntax: "{{parentDirectoryName}}", description: "The name of the parent folder of the folder the file is located in" }
    ]);
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get moveDestination() {
    return this.model.moveDestination;
  }
  set moveDestination(value) {
    this.model = { ...this.model, moveDestination: value };
  }
  get defaultImportedDirectory() {
    switch (this.importType) {
      case "AzureBlobImport":
        return "RIA/" + this.pageId + "/Imported/";
      case "FileSystemImport":
        return "~/App_Data/RIA/" + this.pageId + "/Imported/";
    }
  }
}, __name(_a12, "MoveCleanupComponent"), _a12);
__decorateClass$4([
  Prop({
    required: !0
  })
], MoveCleanupComponent$1.prototype, "value", 2);
__decorateClass$4([
  Prop({
    required: !1,
    default: null
  })
], MoveCleanupComponent$1.prototype, "pageId", 2);
__decorateClass$4([
  Prop({
    required: !0
  })
], MoveCleanupComponent$1.prototype, "importType", 2);
MoveCleanupComponent$1 = __decorateClass$4([
  Component({ components: { DefaultableTextbox, PlaceholderInformation } })
], MoveCleanupComponent$1);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "alert alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
        The file will be moved to the destination once it has been imported.
    `)], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Move Destination")]), _vm._v(" "), _c("defaultable-textbox", { directives: [{ name: "validate", rawName: "v-validate", value: "required", expression: "'required'" }], attrs: { name: "MoveDestination", placeholder: "Enter a path...", defaultValue: _vm.defaultImportedDirectory }, model: { value: _vm.moveDestination, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.moveDestination = $$v;
  }, "callback"), expression: "moveDestination" } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("The directory to move the file to after it has been imported.")]), _vm._v(" "), _vm.errors.first("MoveDestination") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("MoveDestination")))]) : _vm._e()], 1)]);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  MoveCleanupComponent$1,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  null
);
const MoveCleanupComponent = __component__$4.exports;
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$3"), _a13;
let MoveEmailCleanupComponent$1 = (_a13 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "pageId");
    __publicField(this, "importType");
    __publicField(this, "indexingImportModel");
  }
  /*      uniquePlaceHolderInfo: UniquePlaceHolderInfo[] = [
          {syntax: '{{directory}}', description: 'The full file path of the file to import'},
          {syntax: '{{directoryName}}', description: 'The name of the folder the file is located in'},
          {syntax: '{{parentDirectoryName}}', description: 'The name of the parent folder of the folder the file is located in'},
        ]*/
  setDestinationFolder(selectedId) {
    this.moveDestinationFolder = selectedId;
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get moveDestinationFolder() {
    return this.model.moveDestinationFolder;
  }
  set moveDestinationFolder(value) {
    this.model = { ...this.model, moveDestinationFolder: value };
  }
}, __name(_a13, "MoveEmailCleanupComponent"), _a13);
__decorateClass$3([
  Prop({ required: !0 })
], MoveEmailCleanupComponent$1.prototype, "value", 2);
__decorateClass$3([
  Prop({ required: !1, default: null })
], MoveEmailCleanupComponent$1.prototype, "pageId", 2);
__decorateClass$3([
  Prop({ required: !0 })
], MoveEmailCleanupComponent$1.prototype, "importType", 2);
__decorateClass$3([
  Prop({ required: !0 })
], MoveEmailCleanupComponent$1.prototype, "indexingImportModel", 2);
MoveEmailCleanupComponent$1 = __decorateClass$3([
  Component({ components: { MicrosoftEmailSourceFolderSelector, DefaultableTextbox, PlaceholderInformation } })
], MoveEmailCleanupComponent$1);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "alert alert-info" }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(`
        The email will be moved to the destination once it has been imported.
    `)], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("microsoft-email-source-folder-selector", { attrs: { "external-connection-id": _vm.indexingImportModel.externalConnectionId, "mail-box": _vm.indexingImportModel.mailBox, label: "Move Destination Folder" }, on: { input: _vm.setDestinationFolder }, model: { value: _vm.moveDestinationFolder, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.moveDestinationFolder = $$v;
  }, "callback"), expression: "moveDestinationFolder" } })], 1)]);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  MoveEmailCleanupComponent$1,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const MoveEmailCleanupComponent = __component__$3.exports, cleanupConfigurations = [
  {
    id: "DeleteCleanup",
    name: "Delete File",
    icon: "trash",
    component: DeleteCleanupComponent,
    factory: /* @__PURE__ */ __name(() => ({
      typeId: "DeleteCleanup",
      discriminator: "DeleteCleanup"
    }), "factory")
  },
  {
    id: "MoveCleanup",
    name: "Move file",
    icon: "right-from-bracket",
    component: MoveCleanupComponent,
    factory: /* @__PURE__ */ __name(() => ({
      typeId: "MoveCleanup",
      discriminator: "MoveCleanup",
      moveDestination: ""
    }), "factory")
  },
  {
    id: "MoveEmailCleanup",
    name: "Move email",
    icon: "inbox-out",
    component: MoveEmailCleanupComponent,
    factory: /* @__PURE__ */ __name(() => ({
      typeId: "MoveEmailCleanup",
      discriminator: "MoveEmailCleanup",
      moveDestinationFolder: ""
    }), "factory")
  }
], cleanupTypes = cleanupConfigurations.sort(function(a, b) {
  return a.name.localeCompare(b.name);
});
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$2"), _a14;
let ImportCleanupComponent = (_a14 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "value");
    __publicField(this, "availableCleanups");
    __publicField(this, "pageId");
  }
  get cleanupValue() {
    var _a17, _b;
    return (_b = (_a17 = this.value) == null ? void 0 : _a17.cleanup) == null ? void 0 : _b.discriminator;
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get editor() {
    if (this.value.cleanup)
      return this.cleanups.find((t) => t.id === this.value.cleanup.discriminator).component;
  }
  get cleanups() {
    return cleanupTypes;
  }
  add(id) {
    let matched = this.cleanups.find((t) => t.id === id);
    this.value.cleanup && this.value.cleanup.discriminator == matched.id || matched && (this.value.cleanup = matched.factory());
  }
  get cleanupDropdown() {
    return this.cleanups.filter((y) => this.availableCleanups.find((c) => c == y.id) != null).map((o) => ({
      id: o.id,
      name: o.name,
      icon: o.icon
    }));
  }
  getTypeName(id) {
    let matched = this.cleanups.find((t) => t.id === id);
    return matched ? matched.name : null;
  }
  get component() {
    if (!this.value.cleanup)
      return null;
    let matched = this.cleanups.find((t) => t.id === this.value.cleanup.discriminator);
    return matched ? matched.component : null;
  }
  get editorValid() {
    let editor = this.$refs.editor;
    return editor ? !editor.$validator.errors.any() : !0;
  }
  get externalConnectionId() {
    let modeAsMicrsoftEmailModel = this.model;
    return modeAsMicrsoftEmailModel != null ? modeAsMicrsoftEmailModel.externalConnectionId : null;
  }
}, __name(_a14, "ImportCleanupComponent"), _a14);
__decorateClass$2([
  Prop({ required: !0 })
], ImportCleanupComponent.prototype, "value", 2);
__decorateClass$2([
  Prop({ required: !0 })
], ImportCleanupComponent.prototype, "availableCleanups", 2);
__decorateClass$2([
  Prop({ required: !1, default: null })
], ImportCleanupComponent.prototype, "pageId", 2);
ImportCleanupComponent = __decorateClass$2([
  Component({
    components: { ReactiveDropdown }
  })
], ImportCleanupComponent);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Clean up method")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("reactive-dropdown", { attrs: { value: _vm.cleanupValue, options: _vm.cleanupDropdown, title: "Set Clean Up" }, on: { input: _vm.add } })], 1)]), _vm._v(" "), _vm.value.cleanup ? _c("div", { staticClass: "row" }, [_vm.component ? _c("div", { staticClass: "col-md-12 mt-3" }, [_c(_vm.component, { tag: "component", attrs: { indexingImportModel: _vm.value, pageId: _vm.pageId, importType: _vm.value.discriminator }, model: { value: _vm.value.cleanup, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.value, "cleanup", $$v);
  }, "callback"), expression: "value.cleanup" } })], 1) : _vm._e()]) : _vm._e()]);
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  ImportCleanupComponent,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  "3e48cef0"
);
const ImportCleanupSettings = __component__$2.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a15;
let RiaImports = (_a15 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "isAzureMode", !1);
    __publicField(this, "value");
    __publicField(this, "pageId");
    __publicField(this, "editing", null);
    __publicField(this, "editingIndex", null);
    __publicField(this, "confirmDelete", !1);
  }
  async mounted() {
    this.isAzureMode = await systemInAzureMode();
  }
  get model() {
    return this.value;
  }
  set model(value) {
    this.$emit("input", value);
  }
  get imports() {
    return this.model.imports;
  }
  set imports(value) {
    this.model = { ...this.model, imports: value };
  }
  get importTypes() {
    return importConfigurations$1;
  }
  edit(item) {
    let index = this.imports.indexOf(item);
    index < 0 || (this.editing = _.cloneDeep(this.imports[index]), this.editing.targetConfiguration.target || (this.editing.targetConfiguration.target = {}), this.editing.targetConfiguration.target.page || (this.editing.targetConfiguration.target.page = {}), this.editing.targetConfiguration.target.page.id = this.pageId, this.confirmDelete = !1, this.editingIndex = index);
  }
  isEditing(importConfig) {
    var _a17;
    return ((_a17 = this.editing) == null ? void 0 : _a17.id) == (importConfig == null ? void 0 : importConfig.id);
  }
  remove(index) {
    if (index < 0)
      return;
    let newModel = this.imports.slice();
    newModel.splice(index, 1), this.cancel(), this.imports = newModel;
  }
  add(typeId) {
    this.cancel();
    let newImport = this.importTypes.find((o) => o.id === typeId).factory();
    this.editing = newImport, this.editing.targetConfiguration.target || (this.editing.targetConfiguration.target = {}), this.editing.targetConfiguration.target.page || (this.editing.targetConfiguration.target.page = {}), this.editing.targetConfiguration.target.page.id = this.pageId;
  }
  getImportTypeName(type) {
    let matched = this.importTypes.find((t) => t.id == type.discriminator);
    return matched ? matched.name : null;
  }
  async save() {
    if (!await this.validate() || !await this.validateCleanup())
      return;
    let updatedModel = this.imports.slice();
    this.editingIndex === null ? updatedModel.push(this.editing) : updatedModel.splice(this.editingIndex, 1, this.editing), this.imports = updatedModel, this.editing = null, this.editingIndex = null;
  }
  cancel() {
    this.editing = null, this.editingIndex = null, this.confirmDelete = !1;
  }
  get availableCleanups() {
    if (!this.editing)
      return null;
    let matched = this.importTypes.find((t) => t.id === this.editing.discriminator);
    return matched ? matched.cleanups : null;
  }
  get component() {
    if (!this.editing)
      return null;
    let matched = this.importTypes.find((t) => t.id === this.editing.discriminator);
    return matched ? matched.component : null;
  }
  get isEditingInPreview() {
    return !1;
  }
  async validate() {
    let validators = this.$children.map((c) => c.$validator);
    return Promise.all(validators.map((v) => v.validateAll())).then((r) => r.every((v) => v));
  }
  async validateCleanup() {
    let validators = this.$refs.cleanupEditor.$children.map((c) => c.$validator);
    return Promise.all(validators.map((v) => v.validateAll())).then((r) => r.every((v) => v));
  }
  get targetConfiguration() {
    return this.editing.targetConfiguration;
  }
  set targetConfiguration(targetConfiguration) {
    this.editing = { ...this.editing, targetConfiguration };
  }
  get target() {
    return this.targetConfiguration.target;
  }
  set target(target) {
    this.targetConfiguration = { ...this.targetConfiguration, target };
  }
  get uniquePlaceHolderInfo() {
    var _a17;
    switch ((_a17 = this.editing) == null ? void 0 : _a17.discriminator) {
      case "MicrosoftEmailImport":
        return [
          { syntax: "{{mailbox}}", description: "The mailbox the import is running from" },
          { syntax: '{{email["subject"]}}', description: "The subject of the incoming email" },
          { syntax: '{{email["to"]}}', description: 'The "To" address of the email, semicolon separated' },
          { syntax: '{{email["from"]}}', description: 'The "From" address of the email' },
          { syntax: '{{email["fromName"]}}', description: 'The "From Name" of the email' },
          { syntax: '{{email["cc"]}}', description: 'The list of "cc" email addresses, semicolon separated' },
          { syntax: '{{email["receivedDateTime"]}}', description: "The received date and time of the email" },
          { syntax: '{{email["attachmentCount"]}}', description: "The number of attachments on the email" },
          { syntax: '{{email["replyTo"]}}', description: 'The list of "reply to" email addresses, semicolon separated' },
          { syntax: '{{email["body"]}}', description: "The body of the incoming email" }
        ];
      default:
        return [
          { syntax: "{{filename}}", description: "The name of the file." },
          { syntax: "{{filenameNoExtension}}", description: "The name of the file with the extension removed." },
          { syntax: "{{filenameExtension}}", description: "The file extension of the file." },
          { syntax: "{{filenameExtensionNoDot}}", description: "The file extension of the file without the dot." },
          { syntax: "{{directory}}", description: "The full folder path of the item " },
          { syntax: "{{directoryName}}", description: "The name of the folder the item is located in" },
          { syntax: "{{fullName}}", description: "The full path and item name" }
        ];
    }
  }
}, __name(_a15, "RiaImports"), _a15);
__decorateClass$1([
  Prop({
    required: !0
  })
], RiaImports.prototype, "value", 2);
__decorateClass$1([
  Prop({
    required: !1,
    default: null
  })
], RiaImports.prototype, "pageId", 2);
RiaImports = __decorateClass$1([
  Component({
    methods: { systemInAzureMode },
    components: {
      PlaceholderInformation,
      QueueLookup,
      ImportBasicSettings,
      ImportCleanupSettings,
      draggable
    }
  })
], RiaImports);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", [_c("h3", [_vm.imports.length ? _c("span", { staticClass: "badge badge-info" }, [_vm._v(_vm._s(_vm.imports.length))]) : _vm._e(), _vm._v(`
        Import Configurations
        `), _c("b-dropdown", { ref: "createDropdownImportConfigurations", staticClass: "m-md-2", attrs: { "no-flip": "", variant: "outline-secondary", id: "createDropdownImportConfigurations" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
    return [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Create new
          `)];
  }, "fn"), proxy: !0 }]) }, [_vm._v(" "), _vm._l(_vm.importTypes, function(importType) {
    return _c("b-dropdown-item-button", { key: importType.name, attrs: { id: importType.id, disabled: _vm.isAzureMode && importType.id == "FileSystemImport" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.add(importType.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: importType.icon } }), _vm._v(` 
            ` + _vm._s(importType.name) + `
          `)], 1);
  })], 2)], 1)])], 1), _vm._v(" "), _c("b-row", [_c("b-col", { attrs: { md: "3" } }, [_c("b-list-group", { ref: "imports" }, [_vm.imports.length ? _vm._e() : _c("span", { staticClass: "font-italic" }, [_vm._v("No imports configured")]), _vm._v(" "), _c("draggable", { attrs: { handle: ".field-handle" }, model: { value: _vm.imports, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.imports = $$v;
  }, "callback"), expression: "imports" } }, _vm._l(_vm.imports, function(importConfig) {
    return _c("b-list-group-item", { ref: "action", refInFor: !0, attrs: { button: "", active: _vm.isEditing(importConfig) }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.edit(importConfig);
    }, "click") } }, [_c("span", { staticClass: "field-handle" }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "grip-vertical" } })], 1), _vm._v(" "), importConfig.name ? _c("span", [_vm._v(_vm._s(importConfig.name))]) : _c("span", { staticClass: "text=muted" }, [_c("font-awesome-icon", { staticClass: "text-warning fa-fw mr-1", attrs: { icon: "exclamation-triangle" } }), _vm._v("Unnamed import config")], 1), _vm._v(" "), _c("b-badge", { staticClass: "mt-1 float-right", attrs: { pill: "", variant: "info" } }, [_vm._v(_vm._s(_vm.$options.filters.addSpacesToCamelCase(importConfig.discriminator)))]), _vm._v(" "), importConfig.enabled ? importConfig.discriminator == "FileSystemImport" && _vm.isAzureMode ? _c("b-badge", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", value: "This import type isn't supported when running in Azure Mode", expression: "'This import type isn\\'t supported when running in Azure Mode'", modifiers: { hover: !0 } }], attrs: { pill: "", variant: "warning" } }, [_vm._v("Disabled")]) : _vm._e() : _c("b-badge", { attrs: { pill: "", variant: "warning" } }, [_vm._v("Disabled")])], 1);
  }), 1)], 1)], 1), _vm._v(" "), _c("b-col", { attrs: { md: "9" } }, [_vm.component ? _c("div", [_vm.isEditingInPreview ? _c("b-alert", { attrs: { show: "", variant: "warning" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" "), _c("strong", [_vm._v("Preview Feature!")]), _c("br"), _c("span", [_vm._v("This importer is currently in preview and may not be ready for general use.")])], 1) : _vm._e(), _vm._v(" "), _c("b-tabs", { attrs: { "content-class": "mt-3" } }, [_c("b-tab", { attrs: { title: "Basic", active: "" } }, [_c("import-basic-settings", { ref: "basicEditor", attrs: { "editing-index": _vm.editingIndex, "indexing-import-configs": _vm.imports }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } }, [_vm.confirmDelete ? _c("span", { staticClass: "float-right" }, [_c("b-button", { attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.remove(_vm.editingIndex);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(" Confirm")], 1), _vm._v(" "), _c("b-button", { attrs: { variant: "outline-secondary" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.confirmDelete = !1;
  }, "click") } }, [_vm._v("Cancel")])], 1) : _c("span", { staticClass: "float-right" }, [_c("b-button", { attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.confirmDelete = !0;
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } })], 1)], 1)])], 1), _vm._v(" "), _c("b-tab", { attrs: { title: "Import" } }, [_c("h5", [_vm._v("Import Settings")]), _vm._v(" "), _c(_vm.component, { ref: "editor", tag: "component", attrs: { pageId: _vm.pageId, "page-title": "Import Settings" }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } }), _vm._v(" "), _c("import-cleanup-settings", { ref: "cleanupEditor", attrs: { availableCleanups: _vm.availableCleanups, pageId: _vm.pageId }, model: { value: _vm.editing, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.editing = $$v;
  }, "callback"), expression: "editing" } })], 1), _vm._v(" "), _c("b-tab", { attrs: { title: "Output" } }, [_c("h5", [_vm._v("Output Settings")]), _vm._v(" "), _vm.editing.discriminator != "MicrosoftEmailImport" ? _c("b-form-group", { attrs: { description: "The output mode to use for this import configuration." } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Output Mode")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("b-button-group", { attrs: { size: "sm" } }, [_c("b-button", { attrs: { pressed: !_vm.targetConfiguration.advancedMode, variant: "outline-primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.targetConfiguration.advancedMode = !1;
  }, "click") } }, [_vm._v(`
                  Simple
                `)]), _vm._v(" "), _c("b-button", { attrs: { pressed: _vm.targetConfiguration.advancedMode, variant: "outline-primary" }, on: { click: /* @__PURE__ */ __name(function($event) {
    _vm.targetConfiguration.advancedMode = !0;
  }, "click") } }, [_vm._v(`
                  Advanced
                `)])], 1)], 1) : _vm._e(), _vm._v(" "), _vm.targetConfiguration.advancedMode ? [_c("b-alert", { attrs: { variant: "info", show: "" } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "exclamation-circle" } }), _c("span", [_vm._v("The following "), _c("placeholder-information", { attrs: { "unique-placeholders": _vm.uniquePlaceHolderInfo } }), _vm._v(" can be used in the queue selection options.")], 1)], 1), _vm._v(" "), _c("queue-lookup", { attrs: { showPageSelect: !1, "page-title": "" }, model: { value: _vm.target, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.target = $$v;
  }, "callback"), expression: "target" } }), _vm._v(" "), _c("b-form-group", { attrs: { description: "Creates the queue for the target queue type if the queue doesn't exist" } }, [_c("b-form-checkbox", { attrs: { switch: "" }, model: { value: _vm.targetConfiguration.createQueues, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.targetConfiguration, "createQueues", $$v);
  }, "callback"), expression: "targetConfiguration.createQueues" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Automatically create queue")])])], 1)] : [_c("b-alert", { attrs: { variant: "info", show: "" } }, [_vm.editing.discriminator === "MicrosoftEmailImport" ? _c("span", [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "exclamation-circle" } }), _c("span", [_vm._v("Simple mode will attempt to locate the destination queue using the email sent from address.")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("span", [_vm._v('If the email from address was "user@domain.com" then we will attempt to find a personal queue with the name "user@domain.com".')])], 1) : _c("span", [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "exclamation-circle" } }), _c("span", [_vm._v("Simple mode will attempt to locate the destination queue using the name of the directory that the file is located in.")]), _vm._v(" "), _c("br"), _vm._v(" "), _c("span", [_vm._v('If the file abc.pdf was located in a directory named "user@domain.com" then we will attempt to find a personal queue with the name "user@domain.com".')]), _vm._v(" "), _c("br"), _vm._v(" "), _c("span", [_vm._v('If the file abc.pdf was located in a directory named "Accounts Team" then we will attempt to find a shared queue type with the name "Accounts Team".')])], 1)])]], 2)], 1), _vm._v(" "), _c("span", { staticClass: "float-right" }, [_c("button", { staticClass: "btn btn-default", attrs: { id: "cancelImport" }, on: { click: _vm.cancel } }, [_vm._v("Cancel")]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", attrs: { id: "saveImport" }, on: { click: _vm.save } }, [_vm._v("Save")])])], 1) : _vm._e()])], 1)], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  RiaImports,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const RiaImport = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a16;
let IndexingConfigurationComponent = (_a16 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "pageId");
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
    __publicField(this, "currentTab", null);
    __publicField(this, "fieldTypes", [
      "existing",
      "custom",
      "datetime",
      "integration-find",
      "integration-lookup",
      "user",
      "idCounter",
      "html",
      "signature",
      "grid",
      "image",
      "lookup",
      "numeric",
      "barcodescan",
      "externalApi",
      "time",
      "classificationInfo",
      "rating",
      "likert",
      "lookupGrid",
      "viewer-selector"
    ]);
  }
  async created() {
    await (this.pageId ? this.loadPage(this.pageId) : this.createPage()), this.currentTab = "general";
  }
  get currentComponent() {
    return this.currentTab ? this.tabs.find((t) => t.id === this.currentTab).component : null;
  }
  activeTab(id) {
    return id === this.currentTab;
  }
  selectTab(tab) {
    this.currentTab = tab;
  }
  async loadPage(pageId) {
    this.loading = !0, this.loadingError = null;
    try {
      await this.$store.dispatch("administration/app/indexing/pages/load", pageId);
    } catch (e) {
      this.loadingError = e;
    } finally {
      this.loading = !1;
    }
  }
  get canSave() {
    return this.$store.getters["administration/app/indexing/pages/canSave"];
  }
  get saving() {
    return this.$store.getters["administration/app/getters/saving"];
  }
  async save() {
    if (!await this.validate()) {
      toastr.error("Errors in configuration. Check tabs marked");
      return;
    }
    this.$store.commit("administration/app/mutations/saving", !0);
    try {
      await this.$store.dispatch("administration/app/indexing/pages/save"), toastr.success("Page saved");
    } catch (e) {
      toastr.error(e);
    } finally {
      this.$store.commit("administration/app/mutations/saving", !1);
    }
  }
  async createPage() {
    try {
      return await this.$store.dispatch("administration/app/indexing/pages/create");
    } catch (e) {
      this.loadingError = e;
    } finally {
      this.loading = !1;
    }
  }
  get model() {
    return this.$store.getters["administration/app/indexing/pages/current"];
  }
  set model(page) {
    this.$store.dispatch("administration/app/indexing/pages/update", page);
  }
  hasError(id) {
    let refs = this.$refs[id];
    if (!refs)
      return !1;
    let component = refs.find(() => !0);
    return component && component.$validator ? component.$validator.errors.any() : !1;
  }
  get hasErrors() {
    return !!this.$children.map((c) => c.$validator).find((v) => v.errors.any());
  }
  validate() {
    let validators = this.$children.map((c) => c.$validator);
    return Promise.all(validators.map((v) => v.validateAll())).then((r) => r.every((v) => v));
  }
  get tabs() {
    var _a17, _b, _c, _d, _e, _f;
    return [
      {
        id: "general",
        name: "General",
        icon: "edit",
        description: "General page settings",
        component: RiaGeneral,
        show: !0
      },
      {
        id: "fields",
        name: "Fields",
        icon: "keyboard",
        description: "Fields configured for each item",
        component: PageFields,
        show: !0,
        count: (_a17 = this.model.fields) == null ? void 0 : _a17.length
      },
      {
        id: "display",
        name: "Display",
        icon: "desktop",
        description: "Display and visual settings for the page",
        component: RiaDisplay,
        show: !0
      },
      {
        id: "notifications",
        name: "Notifications",
        icon: "envelope",
        description: "Configure reminders and notifications",
        component: RiaNotifications,
        show: !0
      },
      {
        id: "queues",
        name: "Queues",
        icon: "list-ul",
        description: "Queue types available for this page",
        component: RiaQueues,
        show: !0,
        count: (_b = this.model.queues) == null ? void 0 : _b.length
      },
      {
        id: "input",
        name: "Input",
        icon: "upload",
        description: "Configure input file settings",
        component: RiaInput,
        show: !0
      },
      {
        id: "import",
        name: "Imports",
        icon: "file-import",
        description: "Configure imports for this page",
        component: RiaImport,
        show: !0,
        count: (_c = this.model.imports) == null ? void 0 : _c.length
      },
      {
        id: "pre-processing",
        name: "Pre-Processing",
        icon: "cogs",
        description: "Processing of an item before it is available in a queue",
        component: RiaPreProcessing,
        show: !0,
        count: (_e = (_d = this.model.preProcessing) == null ? void 0 : _d.stages) == null ? void 0 : _e.length
      },
      {
        id: "actions",
        name: "Actions",
        icon: "play",
        description: "Actions available for items being processed",
        component: IndexingCustomActionsConfigurationComponent,
        show: !0,
        count: (_f = this.model.actions) == null ? void 0 : _f.length
      }
    ];
  }
}, __name(_a16, "IndexingConfigurationComponent"), _a16);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], IndexingConfigurationComponent.prototype, "pageId", 2);
IndexingConfigurationComponent = __decorateClass([
  Component({
    components: { RiaGeneral, LoadingBar: LoadingBarComponent }
  })
], IndexingConfigurationComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "container-fluid" }, [_c("div", { staticClass: "d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom" }, [_c("h1", { staticClass: "h2" }, [_vm._v("Edit Indexing Page: "), _vm.model ? _c("small", [_vm._v(_vm._s(_vm.model.name))]) : _vm._e()])]), _vm._v(" "), _c("div", { staticClass: "row" }, [_vm.loading ? _c("div", { staticClass: "col" }, [_c("loading-bar")], 1) : _vm.loadingError ? _c("div", [_c("div", { staticClass: "alert alert-danger" }, [_c("strong", [_vm._v("Oh no!")]), _vm._v(" Failed to load the page. "), _c("a", { attrs: { role: "button" }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.loadPage(_vm.pageId);
  }, "click") } }, [_vm._v(`Try
                again?`)])])]) : _c("div", { staticClass: "col mb-4" }, [_c("ul", { staticClass: "nav nav-tabs unselectable" }, [_vm._l(_vm.tabs, function(tab) {
    return _c("li", { key: tab.id, staticClass: "nav-item", attrs: { role: "presentation" } }, [_c("button", { staticClass: "btn-link nav-link", class: { active: _vm.activeTab(tab.id), disabled: !tab.show, "has-error": _vm.hasError(tab.id) }, attrs: { title: tab.description, id: tab.id, "data-toggle": "tab" }, on: { click: /* @__PURE__ */ __name(function($event) {
      tab.show && _vm.selectTab(tab.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: tab.icon } }), _vm._v(`
                        ` + _vm._s(tab.name) + `
                        `), tab.count != null && tab.count > 0 ? _c("span", { staticClass: "badge badge-info" }, [_vm._v(_vm._s(tab.count))]) : _vm._e(), _vm._v(" "), _vm.hasError(tab.id) ? _c("span", [_vm._v(`
                             
                            `), _c("font-awesome-icon", { staticClass: "text-danger", attrs: { icon: "exclamation" } })], 1) : _vm._e(), _vm._v(" "), tab.id == "queues" && _vm.model && (!_vm.model.queues || !_vm.model.queues.length) ? _c("span", [_c("font-awesome-icon", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", value: "No queues configured", expression: "'No queues configured'", modifiers: { hover: !0 } }], staticClass: "text-warning", attrs: { icon: "exclamation-triangle" } })], 1) : _vm._e()], 1)]);
  }), _vm._v(" "), _c("li", { staticClass: "ml-auto nav-item" }, [_c("button", { staticClass: "btn btn-success", attrs: { disabled: !_vm.canSave || _vm.saving || _vm.hasErrors, id: "savePage" }, on: { click: _vm.save } }, [_vm.saving ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(` Saving...
                        `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save
                        `)], 1)])])], 2)])]), _vm._v(" "), _vm.model ? _c("div", { staticClass: "tab-content" }, _vm._l(_vm.tabs, function(tab) {
    return tab.show ? _c(tab.component, { directives: [{ name: "show", rawName: "v-show", value: tab.id === _vm.currentTab, expression: "tab.id === currentTab" }], key: tab.id, ref: tab.id, refInFor: !0, tag: "component", attrs: { "page-id": _vm.pageId, "available-fields": _vm.fieldTypes }, on: { trySavePage: _vm.save }, model: { value: _vm.model, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.model = $$v;
    }, "callback"), expression: "model" } }) : _vm._e();
  }), 1) : _vm._e()]);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  IndexingConfigurationComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "0f90fd05"
);
const Configuration = __component__.exports;
export {
  Configuration as default
};
