var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, ct as ClassificationClient, T as Transformer, b as baseUrl, t as toastr, n as normalizeComponent, W as Watch, _ } from "./main-DAVWuHbi.js";
import { P as PaginationControls } from "./paginationControls-C-ZyZ0W0.js";
import { D as DateDisplay } from "./dateDisplay-CpjGSgC5.js";
var __defProp$6 = Object.defineProperty, __getOwnPropDesc$6 = Object.getOwnPropertyDescriptor, __decorateClass$6 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$6(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$6(target, key, result), result;
}, "__decorateClass$6"), _a;
let ReclassificationPageComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "classificationAppPage");
    __publicField(this, "modalId");
    __publicField(this, "itemIds");
    __publicField(this, "classification", null);
    __publicField(this, "classificationOptions", [{ value: null, text: "Select a classification" }]);
    __publicField(this, "uploading", !1);
    __publicField(this, "classificationClient", new ClassificationClient(new Transformer(), baseUrl()));
  }
  async mounted() {
    this.classificationAppPage.classifications.forEach((classification2) => {
      this.classificationOptions.push({ value: classification2, text: classification2 });
    });
  }
  async reclassifyItems() {
    await this.classificationClient.reclassifyDocuments(this.classificationAppPage.id, this.itemIds, this.classification) ? (toastr.success("The items have been successfully reclassified"), this.$refs[this.modalId].hide(), this.$emit("reclassified")) : toastr.warning("The items could not be reclassified");
  }
}, __name(_a, "ReclassificationPageComponent"), _a);
__decorateClass$6([
  Prop({ required: !0 })
], ReclassificationPageComponent.prototype, "classificationAppPage", 2);
__decorateClass$6([
  Prop({ required: !0 })
], ReclassificationPageComponent.prototype, "modalId", 2);
__decorateClass$6([
  Prop({ required: !0 })
], ReclassificationPageComponent.prototype, "itemIds", 2);
ReclassificationPageComponent = __decorateClass$6([
  Component({})
], ReclassificationPageComponent);
var _sfc_render$6 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { ref: _vm.modalId, attrs: { "no-close-on-backdrop": "", "hide-footer": "", title: "Classify Items", id: _vm.modalId } }, [_c("b-form-group", { attrs: { description: "Select the settings file to browse" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Classification")]), _vm._v(" "), _c("b-input-group", [_c("b-form-select", { attrs: { options: _vm.classificationOptions, disabled: _vm.uploading }, model: { value: _vm.classification, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.classification = $$v;
  }, "callback"), expression: "classification" } })], 1)], 1), _vm._v(" "), _vm.itemIds.length ? _c("span", { staticClass: "font-italic font-weight-bold pt-1" }, [_vm._v(_vm._s(_vm.itemIds.length) + " items selected")]) : _vm._e(), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { variant: "success", disabled: !_vm.classification || _vm.uploading }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.reclassifyItems();
  }, "click") } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "upload" } }), _vm._v("Reclassify")], 1)], 1);
}, "render"), _sfc_staticRenderFns$6 = [], __component__$6 = /* @__PURE__ */ normalizeComponent(
  ReclassificationPageComponent,
  _sfc_render$6,
  _sfc_staticRenderFns$6,
  !1,
  null,
  null
);
const ReclassificationModal = __component__$6.exports;
var __defProp$5 = Object.defineProperty, __getOwnPropDesc$5 = Object.getOwnPropertyDescriptor, __decorateClass$5 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$5(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$5(target, key, result), result;
}, "__decorateClass$5"), _a2;
let EditClassificationContentModal$1 = (_a2 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "classificationAppPage");
    __publicField(this, "itemId");
    __publicField(this, "loading", !1);
    __publicField(this, "classificationClient", new ClassificationClient(new Transformer(), baseUrl()));
    __publicField(this, "contents", "");
  }
  async getClassificationContents() {
    try {
      this.loading = !0;
      let content = await this.classificationClient.getDocumentContent(this.classificationAppPage.id, this.itemId);
      this.contents = content, this.loading = !1;
    } catch (ex) {
      toastr.error(ex, "An error occurred when retrieving the document's contents.");
    }
  }
  async setClassificationContents() {
    try {
      this.loading = !0;
      let success = await this.classificationClient.setDocumentContent(this.classificationAppPage.id, this.itemId, this.contents);
      toastr.success("The item's contents has been updated."), this.closeModal(), this.loading = !1;
    } catch (ex) {
      toastr.error(ex, "An error occurred trying to set the document's contents.");
    }
  }
  async modalShown() {
    this.contents = "", this.loading = !1, await this.getClassificationContents();
  }
  closeModal() {
    this.$bvModal.hide("edit-classification-content-modal");
  }
}, __name(_a2, "EditClassificationContentModal"), _a2);
__decorateClass$5([
  Prop({ required: !0 })
], EditClassificationContentModal$1.prototype, "classificationAppPage", 2);
__decorateClass$5([
  Prop({ required: !0 })
], EditClassificationContentModal$1.prototype, "itemId", 2);
EditClassificationContentModal$1 = __decorateClass$5([
  Component({})
], EditClassificationContentModal$1);
var _sfc_render$5 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { "no-close-on-backdrop": "", "hide-footer": "", size: "xl", title: "View/Edit Contents", id: "edit-classification-content-modal" }, on: { shown: _vm.modalShown } }, [_c("b-form-group", [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Content")]), _vm._v(" "), _c("b-input-group", [_c("b-form-textarea", { attrs: { id: "textarea", rows: "10", "max-rows": "12" }, model: { value: _vm.contents, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.contents = $$v;
  }, "callback"), expression: "contents" } })], 1)], 1), _vm._v(" "), _c("b-button", { staticClass: "float-right ml-2", attrs: { variant: "success", disabled: _vm.loading }, on: { click: _vm.setClassificationContents } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "file-pen" } }), _vm._v(`Change Contents
  `)], 1), _vm._v(" "), _c("b-button", { staticClass: "float-right", on: { click: _vm.closeModal } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "x" } }), _vm._v("Cancel")], 1)], 1);
}, "render"), _sfc_staticRenderFns$5 = [], __component__$5 = /* @__PURE__ */ normalizeComponent(
  EditClassificationContentModal$1,
  _sfc_render$5,
  _sfc_staticRenderFns$5,
  !1,
  null,
  null
);
const EditClassificationContentModal = __component__$5.exports;
var __defProp$4 = Object.defineProperty, __getOwnPropDesc$4 = Object.getOwnPropertyDescriptor, __decorateClass$4 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$4(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$4(target, key, result), result;
}, "__decorateClass$4"), _a3;
let ClassificationDataTableComponent = (_a3 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "page");
    __publicField(this, "selectedClassification");
    __publicField(this, "refresh");
    __publicField(this, "confirmDeleteId", null);
    __publicField(this, "reclassifyItemIds", []);
    __publicField(this, "editItemId", null);
    __publicField(this, "showReclassifyModal", !1);
    __publicField(this, "classificationItemsResponse", null);
    __publicField(this, "classificationClient", new ClassificationClient(new Transformer(), baseUrl()));
    __publicField(this, "loading", !1);
    __publicField(this, "pageNumberValue", 1);
    __publicField(this, "pageSizeValue", 25);
    __publicField(this, "filterModel", {
      classification: null,
      filter: null,
      sort: {}
    });
    __publicField(this, "selectedItemIds", []);
    __publicField(this, "searchClassificationItemsDebounce", _.debounce(function() {
      this.loadClassificationItems();
    }, 500));
  }
  classificationChanged(value) {
    this.selectedClassification = value, this.loadClassificationItems();
  }
  refreshChanged(value) {
    value && (this.loadClassificationItems(), this.$emit("refreshed"));
  }
  async mounted() {
    this.filterModel.classification = this.selectedClassification, await this.loadClassificationItems();
  }
  async loadClassificationItems() {
    this.classificationItemsResponse = await this.classificationClient.getItems(this.page.id, this.filterModel, this.pageSize, this.pageNumber);
  }
  get tableFields() {
    return [
      { key: "select", label: "", sortable: !1 },
      { key: "fileName", sortable: !0, thClass: "align-middle py-1" },
      { key: "created", sortable: !0, thClass: "align-middle py-1" },
      { key: "isProcessed", sortable: !0, thClass: "align-middle py-1" },
      { key: "processed", sortable: !0, thClass: "align-middle py-1" },
      { key: "isValid", sortable: !0, thClass: "align-middle py-1" },
      { key: "actions", label: "", sortable: !1, thClass: "align-middle py-1" }
    ];
  }
  async deleteItem(itemId) {
    let ids = [itemId];
    await this.deleteItems(ids);
  }
  async reclassifyItems(itemIds) {
    this.showReclassifyModal = !0, this.reclassifyItemIds = itemIds, this.$bvModal.show("reclassificationModal");
  }
  async resetReclassify() {
    this.selectedItemIds = [], await this.loadClassificationItems();
  }
  async editClassification(itemId) {
    this.showReclassifyModal = !0, this.editItemId = itemId, this.$bvModal.show("edit-classification-content-modal");
  }
  async resetEditClassification() {
    this.editItemId = null, await this.loadClassificationItems();
  }
  async deleteItems(itemIds) {
    await this.classificationClient.deleteDocuments(this.page.id, itemIds) ? (toastr.success("The items have been successfully deleted"), this.selectedItemIds = [], await this.loadClassificationItems()) : toastr.warning("The items could not be deleted");
  }
  get pageSize() {
    return this.pageSizeValue;
  }
  set pageSize(value) {
    this.pageSizeValue = value, this.loadClassificationItems();
  }
  get pageNumber() {
    return this.pageNumberValue;
  }
  set pageNumber(value) {
    this.pageNumberValue = value, this.loadClassificationItems();
  }
  get searchFilter() {
    return this.filterModel.filter;
  }
  set searchFilter(value) {
    this.selectedItemIds = [], this.filterModel.filter = value, this.searchClassificationItemsDebounce();
  }
  isItemSelected(itemModel) {
    var _a8;
    return (_a8 = this.selectedItemIds) == null ? void 0 : _a8.includes(itemModel.id);
  }
  get selectedItems() {
    return this.selectedItemIds;
  }
  set selectedItems(value) {
    this.selectedItemIds = value;
  }
  get partiallySelectedItems() {
    var _a8;
    return ((_a8 = this.selectedItemIds) == null ? void 0 : _a8.length) > 0 && this.selectedItemIds.length < this.classificationItemsResponse.count;
  }
  toggleQueueSelected(itemModel) {
    var _a8;
    ((_a8 = this.selectedItemIds) == null ? void 0 : _a8.find((x) => x == itemModel.id)) ? this.selectedItemIds = this.selectedItemIds.filter((x) => x != itemModel.id) : this.selectedItemIds = this.selectedItemIds.concat([itemModel.id]);
  }
  toggleAllItemsSelected() {
    var _a8;
    ((_a8 = this.selectedItemIds) == null ? void 0 : _a8.length) == 0 ? this.selectedItemIds = this.classificationItemsResponse.items.map((x) => x.id) : this.selectedItemIds = [];
  }
  get totalPages() {
    if (this.classificationItemsResponse)
      return Math.ceil(this.classificationItemsResponse.count / this.pageSize);
  }
}, __name(_a3, "ClassificationDataTableComponent"), _a3);
__decorateClass$4([
  Prop({ required: !0 })
], ClassificationDataTableComponent.prototype, "page", 2);
__decorateClass$4([
  Prop({ required: !0 })
], ClassificationDataTableComponent.prototype, "selectedClassification", 2);
__decorateClass$4([
  Prop({ required: !1 })
], ClassificationDataTableComponent.prototype, "refresh", 2);
__decorateClass$4([
  Watch("selectedClassification")
], ClassificationDataTableComponent.prototype, "classificationChanged", 1);
__decorateClass$4([
  Watch("refresh")
], ClassificationDataTableComponent.prototype, "refreshChanged", 1);
ClassificationDataTableComponent = __decorateClass$4([
  Component({
    components: { ReclassificationModal, DateDisplay, PaginationControls, EditClassificationContentModal }
  })
], ClassificationDataTableComponent);
var _sfc_render$4 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-card", { attrs: { "no-body": "" }, scopedSlots: _vm._u([{ key: "header", fn: /* @__PURE__ */ __name(function() {
    return [_c("h5", { staticClass: "mb-0" }, [_c("b-button", { attrs: { variant: "link" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.$emit("close");
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "arrow-left" } })], 1), _vm._v(`
      ` + _vm._s(_vm.selectedClassification) + ` classification
      `), _c("b-button", { staticClass: "float-right", attrs: { pill: "", variant: "outline-primary", size: "sm" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.loadClassificationItems();
    }, "click") } }, [_vm.loading ? _c("span", [_c("b-spinner", { attrs: { small: "" } }), _vm._v(" Refreshing")], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync" } }), _vm._v(" Refresh")], 1)]), _vm._v(" "), _c("b-input-group", { staticClass: "float-right pr-1", staticStyle: { "max-width": "200px" }, attrs: { size: "sm" } }, [_c("b-input-group-prepend", { attrs: { "is-text": "" } }, [_vm._v(`
          Page Size
        `)]), _vm._v(" "), _c("b-form-select", { attrs: { options: [25, 100, 500, 1e3] }, model: { value: _vm.pageSize, callback: /* @__PURE__ */ __name(function($$v) {
      _vm.pageSize = $$v;
    }, "callback"), expression: "pageSize" } })], 1)], 1)];
  }, "fn"), proxy: !0 }]) }, [_c("reclassification-modal", { attrs: { "classification-app-page": _vm.page, "modal-id": "reclassificationModal", "item-ids": _vm.reclassifyItemIds }, on: { reclassified: /* @__PURE__ */ __name(function($event) {
    return _vm.resetReclassify();
  }, "reclassified") } }), _vm._v(" "), _c("edit-classification-content-modal", { attrs: { "classification-app-page": _vm.page, "item-id": _vm.editItemId }, on: { reclassified: _vm.resetEditClassification } }), _vm._v(" "), _vm._v(" "), _c("b-form-group", { staticClass: "mb-0" }, [_c("b-input-group", { attrs: { size: "sm" } }, [_c("b-form-input", { staticClass: "noAppendedBorder", attrs: { id: "filter-input", type: "search", placeholder: "Filter items...", autocomplete: "off" }, model: { value: _vm.searchFilter, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.searchFilter = $$v;
  }, "callback"), expression: "searchFilter" } }), _vm._v(" "), _c("b-input-group-append", [_c("b-input-group-text", { staticClass: "onlyBorderLeft" }, [_c("font-awesome-icon", { attrs: { icon: "filter" } })], 1)], 1)], 1)], 1), _vm._v(" "), _vm.classificationItemsResponse ? _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.classificationItemsResponse.items, striped: "", busy: _vm.loading, "show-empty": "", emptyText: "No items could be found", "thead-class": "b-table-align-th-middle", "sort-icon-left": "" }, scopedSlots: _vm._u([{ key: "table-busy", fn: /* @__PURE__ */ __name(function() {
    return [_c("div", { staticClass: "text-center text-primary my-2" }, [_c("b-spinner", { staticClass: "align-middle" }), _c("strong", [_vm._v(" Loading...")])], 1)];
  }, "fn"), proxy: !0 }, { key: "head(select)", fn: /* @__PURE__ */ __name(function(row) {
    var _a8;
    return [_c("b-checkbox", { attrs: { indeterminate: _vm.partiallySelectedItems, checked: !!((_a8 = _vm.selectedItems) != null && _a8.length) }, on: { change: _vm.toggleAllItemsSelected } })];
  }, "fn") }, { key: "head(actions)", fn: /* @__PURE__ */ __name(function(row) {
    return [_c("b-dropdown", { directives: [{ name: "b-modal", rawName: "v-b-modal", value: "confirm-action-modal", expression: "'confirm-action-modal'" }], staticClass: "float-right", attrs: { "no-flip": "", variant: "primary", "no-caret": "", right: "", size: "sm", title: "Action items", disabled: !_vm.selectedItemIds.length }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } }), _vm._v(" "), _vm.selectedItemIds.length ? _c("span", [_vm._v("Action " + _vm._s(_vm.selectedItemIds.length) + " items")]) : _vm._e()];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.reclassifyItems(_vm.selectedItemIds);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "file-export" } }), _vm._v(" Reclassify " + _vm._s(_vm.selectedItemIds.length) + ` items
      `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteItems(_vm.selectedItemIds);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(" Delete " + _vm._s(_vm.selectedItemIds.length) + ` items
        `)], 1)], 1)];
  }, "fn") }, { key: "cell(select)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("div", { staticClass: "d-inline-flex" }, [_c("b-checkbox", { attrs: { checked: _vm.isItemSelected(data.item), size: "sm" }, on: { change: /* @__PURE__ */ __name(function($event) {
      return _vm.toggleQueueSelected(data.item);
    }, "change") } })], 1)];
  }, "fn") }, { key: "cell(created)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("date-display", { attrs: { value: data.item.created } })];
  }, "fn") }, { key: "cell(processed)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.processed ? _c("date-display", { attrs: { value: data.item.processed } }) : _vm._e()];
  }, "fn") }, { key: "cell(isProcessed)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.isProcessed ? _c("font-awesome-icon", { staticClass: "text-success", attrs: { icon: "check-circle" } }) : _vm._e()];
  }, "fn") }, { key: "cell(isValid)", fn: /* @__PURE__ */ __name(function(data) {
    return [data.item.isValid ? _c("font-awesome-icon", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", value: "Document content was found", expression: "'Document content was found'", modifiers: { hover: !0 } }], staticClass: "text-success", attrs: { icon: "check-circle" } }) : _c("font-awesome-icon", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", value: "Document lacks content", expression: "'Document lacks content'", modifiers: { hover: !0 } }], staticClass: "text-danger", attrs: { icon: "circle-xmark" } })];
  }, "fn") }, { key: "cell(actions)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-dropdown", { staticClass: "float-right", attrs: { "no-flip": "", size: "sm", variant: "primary", "no-caret": "", right: "", disabled: _vm.selectedItemIds.length > 0, id: data.item.id + "-DropDown" }, scopedSlots: _vm._u([{ key: "button-content", fn: /* @__PURE__ */ __name(function() {
      return [_c("font-awesome-icon", { attrs: { icon: "ellipsis-vertical" } })];
    }, "fn"), proxy: !0 }], null, !0) }, [_vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editClassification(data.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "file-pen" } }), _vm._v(` View/Edit Contents
        `)], 1), _vm._v(" "), _c("b-dropdown-item", { on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.reclassifyItems([data.item.id]);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "file-export" } }), _vm._v(` Reclassify
        `)], 1), _vm._v(" "), _c("b-dropdown-item", { attrs: { variant: "danger" }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.deleteItem(data.item.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "trash" } }), _vm._v(` Delete
        `)], 1)], 1)];
  }, "fn") }], null, !1, 2997709096) }) : _vm._e(), _vm._v(" "), _vm.classificationItemsResponse ? _c("pagination-controls", { attrs: { count: _vm.totalPages }, model: { value: _vm.pageNumber, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.pageNumber = $$v;
  }, "callback"), expression: "pageNumber" } }) : _vm._e()], 1);
}, "render"), _sfc_staticRenderFns$4 = [], __component__$4 = /* @__PURE__ */ normalizeComponent(
  ClassificationDataTableComponent,
  _sfc_render$4,
  _sfc_staticRenderFns$4,
  !1,
  null,
  "47f7b271"
);
const ClassificationDataTable = __component__$4.exports;
var __defProp$3 = Object.defineProperty, __getOwnPropDesc$3 = Object.getOwnPropertyDescriptor, __decorateClass$3 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$3(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$3(target, key, result), result;
}, "__decorateClass$3"), _a4;
let ClassificationPageComponent$3 = (_a4 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "classificationAppPage");
    __publicField(this, "modalId");
    __publicField(this, "classificationInput");
    __publicField(this, "classification", null);
    __publicField(this, "classificationOptions", [{ value: null, text: "Select a classification" }]);
    __publicField(this, "uploading", !1);
    __publicField(this, "files", []);
    __publicField(this, "classificationClient", new ClassificationClient(new Transformer(), baseUrl()));
  }
  async mounted() {
    this.classificationAppPage.classifications.forEach((classification2) => {
      this.classificationOptions.push({ value: classification2, text: classification2 });
    });
  }
  shown() {
    this.classificationInput && this.classificationOptions.some((y) => y.value == this.classificationInput) && (this.classification = this.classificationInput);
  }
  async onFileChange(e) {
    this.files = e.target.files || e.dataTransfer.files;
  }
  async uploadClassificationFiles() {
    let count = this.files.length;
    for (let file of this.files)
      await this.uploadAndParse(file);
    this.files = [], this.$refs["classification-file-input"].reset(), this.classification = null, toastr.success(count + " files classified"), this.$emit("uploaded"), this.$emit("refresh");
  }
  async uploadAndParse(file) {
    this.uploading = !0;
    try {
      await this.classificationClient.upload(this.classificationAppPage.id, this.classification, { fileName: file.name, data: file });
    } catch {
      toastr.error(file.name + " could not be uploaded");
    } finally {
      this.uploading = !1;
    }
  }
}, __name(_a4, "ClassificationPageComponent"), _a4);
__decorateClass$3([
  Prop({ required: !0 })
], ClassificationPageComponent$3.prototype, "classificationAppPage", 2);
__decorateClass$3([
  Prop({ required: !0 })
], ClassificationPageComponent$3.prototype, "modalId", 2);
__decorateClass$3([
  Prop({ required: !1 })
], ClassificationPageComponent$3.prototype, "classificationInput", 2);
ClassificationPageComponent$3 = __decorateClass$3([
  Component({})
], ClassificationPageComponent$3);
var _sfc_render$3 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { "no-close-on-backdrop": "", "hide-footer": "", title: "Classify Items", id: _vm.modalId }, on: { show: _vm.shown } }, [_c("b-form-group", { attrs: { description: "Select the settings file to browse" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Classification")]), _vm._v(" "), _c("b-input-group", [_c("b-form-select", { attrs: { options: _vm.classificationOptions, disabled: _vm.uploading }, model: { value: _vm.classification, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.classification = $$v;
  }, "callback"), expression: "classification" } })], 1)], 1), _vm._v(" "), _c("b-form-group", { attrs: { description: "Select the files to classify" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Files")]), _vm._v(" "), _c("b-input-group", [_c("b-form-file", { ref: "classification-file-input", attrs: { multiple: "", placeholder: "Upload file(s)", "drop-placeholder": "Drop file here...", accept: ".txt,.json,.pdf,.eml,.msg", disabled: !_vm.classification || _vm.uploading }, on: { change: _vm.onFileChange } })], 1)], 1), _vm._v(" "), _vm.files.length ? _c("span", { staticClass: "font-italic font-weight-bold pt-1" }, [_vm._v(_vm._s(_vm.files.length) + " files uploaded")]) : _vm._e(), _vm._v(" "), _c("b-button", { staticClass: "float-right", attrs: { variant: "success", disabled: !_vm.classification || _vm.uploading }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.uploadClassificationFiles();
  }, "click") } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "upload" } }), _vm._v("Classify")], 1)], 1);
}, "render"), _sfc_staticRenderFns$3 = [], __component__$3 = /* @__PURE__ */ normalizeComponent(
  ClassificationPageComponent$3,
  _sfc_render$3,
  _sfc_staticRenderFns$3,
  !1,
  null,
  null
);
const ClassificationModal = __component__$3.exports;
var __defProp$2 = Object.defineProperty, __getOwnPropDesc$2 = Object.getOwnPropertyDescriptor, __decorateClass$2 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$2(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$2(target, key, result), result;
}, "__decorateClass$2"), _a5;
let ClassificationPageComponent$2 = (_a5 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "predictions", []);
  }
  async mounted() {
  }
  /*       private getScoreVariant(score: number)
         {
           if(score > 90)
             return 'success';
           else if(score > 75)
             return 'warning';
           else
             return 'danger';
         }*/
  getScore(score) {
    return (score * 100).toFixed(2);
  }
}, __name(_a5, "ClassificationPageComponent"), _a5);
__decorateClass$2([
  Prop({ required: !0 })
], ClassificationPageComponent$2.prototype, "predictions", 2);
ClassificationPageComponent$2 = __decorateClass$2([
  Component({})
], ClassificationPageComponent$2);
var _sfc_render$2 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _vm.predictions.length ? _c("b-table", { attrs: { hover: "", fields: ["classification", "score"], items: _vm.predictions, "primary-key": "classification" }, scopedSlots: _vm._u([{ key: "cell(score)", fn: /* @__PURE__ */ __name(function(data) {
    return [_c("b-badge", { attrs: { pill: "", variant: "info" } }, [_vm._v(`
      ` + _vm._s(_vm.getScore(data.item.score)) + `
    `)])];
  }, "fn") }], null, !1, 1552078710) }) : _vm._e();
}, "render"), _sfc_staticRenderFns$2 = [], __component__$2 = /* @__PURE__ */ normalizeComponent(
  ClassificationPageComponent$2,
  _sfc_render$2,
  _sfc_staticRenderFns$2,
  !1,
  null,
  null
);
const PredictionResults = __component__$2.exports;
var __defProp$1 = Object.defineProperty, __getOwnPropDesc$1 = Object.getOwnPropertyDescriptor, __decorateClass$1 = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc$1(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp$1(target, key, result), result;
}, "__decorateClass$1"), _a6;
let ClassificationPageComponent$1 = (_a6 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "classificationAppPage");
    __publicField(this, "modalId");
    __publicField(this, "classificationOptions", [{ value: null, text: "Select a classification" }]);
    __publicField(this, "uploading", !1);
    __publicField(this, "predicting", !1);
    __publicField(this, "document", null);
    __publicField(this, "filePrediction", []);
    __publicField(this, "inputText", null);
    __publicField(this, "textPrediction", []);
    __publicField(this, "classificationClient", new ClassificationClient(new Transformer(), baseUrl()));
  }
  async mounted() {
    this.classificationAppPage.classifications.forEach((classification2) => {
      this.classificationOptions.push({ value: classification2, text: classification2 });
    });
  }
  async onFileChange(e) {
    let files = e.target.files || e.dataTransfer.files;
    files.length && (this.document = files[0]);
  }
  async predictFile() {
    this.predicting = !0;
    try {
      this.filePrediction = await this.classificationClient.predictFile(this.classificationAppPage.id, { fileName: this.document.name, data: this.document }), this.$refs["classification-file-input"].reset();
    } catch (ex) {
      toastr.error("Could not predict file: " + ex);
    } finally {
      this.predicting = !1;
    }
  }
  async predictText() {
    this.predicting = !0;
    try {
      this.textPrediction = await this.classificationClient.predictText(this.classificationAppPage.id, this.inputText);
    } catch (ex) {
      toastr.error("Could not predict text: " + ex);
    } finally {
      this.predicting = !1;
    }
  }
}, __name(_a6, "ClassificationPageComponent"), _a6);
__decorateClass$1([
  Prop({ required: !0 })
], ClassificationPageComponent$1.prototype, "classificationAppPage", 2);
__decorateClass$1([
  Prop({ required: !0 })
], ClassificationPageComponent$1.prototype, "modalId", 2);
ClassificationPageComponent$1 = __decorateClass$1([
  Component({
    components: { PredictionResults }
  })
], ClassificationPageComponent$1);
var _sfc_render$1 = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("b-modal", { attrs: { "no-close-on-backdrop": "", "hide-footer": "", title: "Predict Items", id: _vm.modalId } }, [_c("b-tabs", { attrs: { "content-class": "mt-3" } }, [_c("b-tab", { attrs: { title: "File", active: "" } }, [_c("b-form-group", { attrs: { description: "Select the files to classify" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("File")]), _vm._v(" "), _c("b-input-group", [_c("b-form-file", { ref: "classification-file-input", attrs: { placeholder: "Upload file", "drop-placeholder": "Drop file here...", accept: ".txt,.json,.pdf,.eml,.msg", disabled: _vm.uploading }, on: { change: _vm.onFileChange } }), _vm._v(" "), _c("b-input-group-append", [_c("b-button", { staticClass: "float-right", attrs: { variant: "primary", disabled: !_vm.document || _vm.predicting }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.predictFile();
  }, "click") } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "upload" } }), _vm._v("Predict")], 1)], 1)], 1)], 1), _vm._v(" "), _vm.filePrediction ? _c("prediction-results", { attrs: { predictions: _vm.filePrediction } }) : _vm._e()], 1), _vm._v(" "), _c("b-tab", { attrs: { title: "Text" } }, [_c("b-form-group", { attrs: { description: "Select the files to classify" } }, [_c("label", { staticClass: "font-weight-bold" }, [_vm._v("Text")]), _vm._v(" "), _c("b-input-group", [_c("b-form-textarea", { attrs: { id: "textarea", rows: "3", "max-rows": "6" }, model: { value: _vm.inputText, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.inputText = $$v;
  }, "callback"), expression: "inputText" } })], 1), _vm._v(" "), _c("b-button", { staticClass: "float-right mt-2", attrs: { variant: "primary", disabled: !_vm.inputText || _vm.predicting }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.predictText();
  }, "click") } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "upload" } }), _vm._v("Predict")], 1)], 1), _vm._v(" "), _c("prediction-results", { attrs: { predictions: _vm.textPrediction } })], 1)], 1)], 1);
}, "render"), _sfc_staticRenderFns$1 = [], __component__$1 = /* @__PURE__ */ normalizeComponent(
  ClassificationPageComponent$1,
  _sfc_render$1,
  _sfc_staticRenderFns$1,
  !1,
  null,
  null
);
const PredictModal = __component__$1.exports;
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a7;
let ClassificationPageComponent = (_a7 = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "pageId");
    __publicField(this, "page", null);
    __publicField(this, "pageStatus", null);
    __publicField(this, "classification", null);
    __publicField(this, "classificationOptions", [{ value: null, text: "Select a classification" }]);
    __publicField(this, "building", !1);
    __publicField(this, "reloadTimer", null);
    __publicField(this, "classificationClient", new ClassificationClient(new Transformer(), baseUrl()));
    __publicField(this, "categoryCounts", []);
    __publicField(this, "selectedClassification", null);
    __publicField(this, "refreshChild", !1);
  }
  async mounted() {
    this.page = await this.classificationClient.getPage(this.pageId), await this.getClassificationCounts(), this.page.classifications.forEach((classification2) => {
      this.classificationOptions.push({ value: classification2, text: classification2 });
    }), this.reloadTimer = setInterval(() => {
      this.getStatus(), this.getClassificationCounts();
    }, 3e4), await this.getStatus();
  }
  beforeDestroy() {
    this.reloadTimer && clearTimeout(this.reloadTimer);
  }
  async getClassificationCounts() {
    this.categoryCounts = await this.classificationClient.getClassificationCounts(this.pageId);
  }
  async resetSelectedClassification() {
    this.selectedClassification = null, await this.getClassificationCounts();
  }
  get tableFields() {
    return [
      { key: "classification", sortable: !0, thClass: "align-middle py-1" },
      { key: "documentCount", label: "", sortable: !0, thClass: "align-middle py-1" }
    ];
  }
  async getStatus() {
    this.pageStatus = await this.classificationClient.getPageStatus(this.pageId);
  }
  async rebuildPage() {
    try {
      this.building = !0;
      let result = await this.classificationClient.buildPage(this.pageId);
      switch (result.status) {
        case "Success":
          toastr.success("Rebuild successful"), result.canPredict && (this.pageStatus.modelBuilt = !0), this.refreshChild = !0;
          break;
        case "Skip":
          toastr.warning(result.message, "Building page model skipped");
          break;
        case "Failed":
          toastr.error(result.message, "Building page model failed");
          break;
      }
    } catch (ex) {
      toastr.error("Could not rebuild page", ex);
    } finally {
      this.building = !1;
    }
  }
}, __name(_a7, "ClassificationPageComponent"), _a7);
__decorateClass([
  Prop({ required: !0 })
], ClassificationPageComponent.prototype, "pageId", 2);
ClassificationPageComponent = __decorateClass([
  Component({
    components: { PredictModal, ClassificationModal, ClassificationDataTable }
  })
], ClassificationPageComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _vm.page ? _c("div", [_c("b-row", [_c("b-col", [_vm.pageStatus ? _c("span", [_vm._v("Status: "), _c("span", { staticClass: "text-muted" }, [_vm._v(_vm._s(_vm.pageStatus.status))])]) : _vm._e(), _vm._v(" "), _c("span", { staticClass: "float-right" }, [_vm.page.permissions.manage ? _c("b-button", { attrs: { disabled: _vm.building, size: "sm", variant: "outline-primary" }, on: { click: _vm.rebuildPage } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { spin: _vm.building, icon: "refresh" } }), _vm._v(`Rebuild
      `)], 1) : _vm._e(), _vm._v(" "), _vm.page.permissions.manage ? _c("b-button", { directives: [{ name: "b-modal", rawName: "v-b-modal.classificationModal", modifiers: { classificationModal: !0 } }], attrs: { disabled: _vm.building, size: "sm", variant: "outline-primary" } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "file-pen" } }), _vm._v(`Classify
      `)], 1) : _vm._e(), _vm._v(" "), _c("b-button", { directives: [{ name: "b-modal", rawName: "v-b-modal.predictModal", modifiers: { predictModal: !0 } }], staticClass: "mr-1", attrs: { disabled: _vm.building || _vm.pageStatus && !_vm.pageStatus.modelBuilt, size: "sm", variant: "outline-primary" } }, [_c("font-awesome-icon", { staticClass: "mr-1", attrs: { icon: "input-text" } }), _vm._v(`Predict
      `)], 1)], 1)])], 1), _vm._v(" "), _c("b-row", { staticClass: "mt-1" }, [_c("b-col", [_vm.selectedClassification ? _vm._e() : _c("b-table", { attrs: { fields: _vm.tableFields, items: _vm.categoryCounts, striped: "", "details-td-class": "pt-0 pb-2", "sort-icon-left": "", "show-empty": "", emptyText: "No categories found", "thead-class": "pl-0", tdClass: "align-middle" }, scopedSlots: _vm._u([{ key: "cell(classification)", fn: /* @__PURE__ */ __name(function(data) {
    return [_vm.page.permissions.manage ? _c("b-button", { attrs: { variant: "link" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.selectedClassification = data.value;
    }, "click") } }, [_vm._v(_vm._s(data.value))]) : _c("span", [_vm._v(_vm._s(data.value))])];
  }, "fn") }], null, !1, 4085311751) }), _vm._v(" "), _vm.selectedClassification ? _c("span", [_vm.selectedClassification && _vm.page.permissions.manage ? _c("classification-data-table", { attrs: { refresh: _vm.refreshChild, "selected-classification": _vm.selectedClassification, page: _vm.page }, on: { refreshed: /* @__PURE__ */ __name(function($event) {
    _vm.refreshChild = !1;
  }, "refreshed"), close: _vm.resetSelectedClassification } }) : _vm._e()], 1) : _vm._e(), _vm._v(" "), _vm.page && _vm.page.permissions.manage ? _c("classification-modal", { attrs: { "classification-input": _vm.selectedClassification, "classification-app-page": _vm.page, "modal-id": "classificationModal" }, on: { refresh: /* @__PURE__ */ __name(function($event) {
    _vm.refreshChild = !0;
  }, "refresh"), uploaded: _vm.getClassificationCounts } }) : _vm._e(), _vm._v(" "), _c("predict-modal", { attrs: { "classification-app-page": _vm.page, "modal-id": "predictModal" } })], 1)], 1)], 1) : _vm._e();
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  ClassificationPageComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  null
);
const classification = __component__.exports;
export {
  classification as default
};
