var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, M as Moment, t as toastr, G as Getter, C as Component, L as LoadingBarComponent, n as normalizeComponent } from "./main-DAVWuHbi.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let CampaignsRoute = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "showingCreate", !1);
    __publicField(this, "createDialog", null);
    __publicField(this, "creatingCampaign", !1);
    __publicField(this, "createCampaignName", null);
    __publicField(this, "createDateField", null);
    __publicField(this, "createDate", null);
    __publicField(this, "editingId", null);
    __publicField(this, "showingEdit", !1);
    __publicField(this, "editDialog", null);
    __publicField(this, "editingCampaign", !1);
    __publicField(this, "editingCampaignName", null);
    __publicField(this, "editingDateField", null);
    __publicField(this, "editingDate", null);
    __publicField(this, "closingId", null);
    __publicField(this, "closeDialog", null);
    __publicField(this, "closingCampaign", !1);
    __publicField(this, "openingId", null);
    __publicField(this, "openDialog", null);
    __publicField(this, "openingCampaign", !1);
    __publicField(this, "showCampaignId", "");
    __publicField(this, "campaigns");
    __publicField(this, "loading");
  }
  get canCreateCampaign() {
    return !0;
  }
  mounted() {
    this.createDialog = $(this.$refs.createModal), this.createDialog.modal({ backdrop: "static", keyboard: !1, show: !1 }), this.createDialog.on("show.bs.modal", () => this.showingCreate = !0), this.createDialog.on("hidden.bs.modal", () => this.showingCreate = !1), this.editDialog = $(this.$refs.editModal), this.editDialog.modal({ backdrop: "static", keyboard: !1, show: !1 }), this.editDialog.on("show.bs.modal", () => this.showingEdit = !0), this.editDialog.on("hidden.bs.modal", () => {
      this.showingEdit = !1, this.editingCampaignName = null, this.editingDate = null;
    }), this.closeDialog = $(this.$refs.closeCampaignModal), this.closeDialog.modal({ backdrop: "static", keyboard: !1, show: !1 }), this.closeDialog.on("hidden.bs.modal", () => this.closingId = null), this.openDialog = $(this.$refs.openCampaignModal), this.openDialog.modal({ backdrop: "static", keyboard: !1, show: !1 }), this.openDialog.on("hidden.bs.modal", () => this.closingId = null), this.load(), this.createDateField = $(this.$refs.createModal).find(".input-group.date"), this.createDateField.datepicker({
      autoclose: !0,
      clearBtn: !0,
      todayHighlight: !0,
      format: "dd/mm/yyyy"
    }).on("changeDate", (e) => {
      this.createDate = e.date;
    }), this.editingDateField = $(this.$refs.editModal).find(".input-group.date"), this.editingDateField.datepicker({
      autoclose: !0,
      todayHighlight: !0,
      clearBtn: !0,
      format: "dd/mm/yyyy"
    }).on("changeDate", (e) => {
      this.editingDate = e.date;
    });
  }
  async load() {
    await this.$store.dispatch("page/forms/management/campaigns/actions/load");
  }
  hasExpired(date) {
    return date === null ? !1 : new Date(date).getTime() < Date.now();
  }
  showCreateModal() {
    this.showingCreate || this.createDialog.modal("show");
  }
  async create() {
    this.creatingCampaign = !0;
    let expiry = this.createDate ? Moment(this.createDate, "DD/MM/YYYY").format() : null;
    try {
      await this.$store.dispatch("page/forms/management/campaigns/actions/create", {
        name: this.createCampaignName,
        expiry
      });
    } catch (e) {
      toastr.error(e, "Failed to create campaign");
      return;
    } finally {
      this.creatingCampaign = !1;
    }
    this.createCampaignName = null, this.cancelCreate();
  }
  cancelCreate() {
    this.createDialog.modal("hide");
  }
  editCampaign(campaign) {
    this.editingDate = campaign.expiry ? Moment(campaign.expiry).format("DD/MM/YYYY") : null, this.editingDateField.datepicker("update", this.editingDate), this.editingCampaignName = campaign.name, this.editingId = campaign.id, this.editDialog.modal("show");
  }
  closeCampaign(value) {
    this.closingId = value, this.closeDialog.modal("show");
  }
  get campaignToClose() {
    return this.closingId ? this.campaigns.find((c) => c.id === this.closingId) : null;
  }
  async verifyCloseCampaign() {
    this.closingCampaign = !0;
    try {
      await this.$store.dispatch("page/forms/management/campaigns/actions/close", this.closingId), this.closeDialog.modal("hide");
    } catch (e) {
      toastr.error("Could not close campaign", e);
    } finally {
      this.closingCampaign = !1;
    }
  }
  cancelCloseCampaign() {
    this.closeDialog.modal("hide");
  }
  async saveEdit() {
    await this.$store.dispatch("page/forms/management/campaigns/actions/update", {
      id: this.editingId,
      name: this.editingCampaignName,
      expiry: this.editingDate
    }), this.editDialog.modal("hide");
  }
  openCampaign(value) {
    this.openingId = value, this.openDialog.modal("show");
  }
  get campaignToOpen() {
    return this.openingId ? this.campaigns.find((c) => c.id === this.openingId) : null;
  }
  async verifyOpenCampaign() {
    this.openingCampaign = !0;
    try {
      await this.$store.dispatch("page/forms/management/campaigns/actions/open", this.openingId), this.openDialog.modal("hide");
    } catch (e) {
      toastr.error("Could not open campaign", e);
    } finally {
      this.openingCampaign = !1;
    }
  }
  cancelOpenCampaign() {
    this.openDialog.modal("hide");
  }
  cancelEdit() {
    this.editingDate = null, this.editingId = null, this.editingCampaignName = null, this.editDialog.modal("hide");
  }
}, __name(_a, "CampaignsRoute"), _a);
__decorateClass([
  Getter("page/forms/management/campaigns/getters/campaigns")
], CampaignsRoute.prototype, "campaigns", 2);
__decorateClass([
  Getter("page/forms/management/campaigns/getters/loading")
], CampaignsRoute.prototype, "loading", 2);
CampaignsRoute = __decorateClass([
  Component({
    components: { LoadingBar: LoadingBarComponent }
  })
], CampaignsRoute);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_c("div", { staticClass: "pull-left clearfix" }, [_c("h3", [_vm._v(`Campaigns
                    `), _c("div", { staticClass: "form-group float-right" }, [_vm.canCreateCampaign ? _c("button", { staticClass: "btn btn-success", attrs: { disabled: _vm.showingCreate }, on: { click: _vm.showCreateModal } }, [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(`
                            Add Campaign
                        `)], 1) : _vm._e(), _vm._v(" "), _c("button", { staticClass: "btn btn-default", attrs: { disabled: _vm.loading }, on: { click: _vm.load } }, [_c("font-awesome-icon", { attrs: { icon: "sync", spin: _vm.loading } })], 1)])])])])]), _vm._v(" "), _c("div", { staticClass: "row" }, [_c("div", { staticClass: "col-md-12" }, [_vm.campaigns && _vm.campaigns.length ? [_c("table", { staticClass: "table table-striped" }, [_vm._m(0), _vm._v(" "), _c("tbody", _vm._l(_vm.campaigns, function(campaign) {
    return _c("tr", [_c("td", [_vm._v(`
                            ` + _vm._s(campaign.name) + `
                            `), _vm.showCampaignId != campaign.id ? _c("button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-sm btn-link", attrs: { title: "Show campaign Id" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.showCampaignId = campaign.id;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "chevron-right" } })], 1) : _vm._e(), _vm._v(" "), _vm.showCampaignId === campaign.id ? _c("button", { directives: [{ name: "b-tooltip", rawName: "v-b-tooltip.hover", modifiers: { hover: !0 } }], staticClass: "btn btn-sm btn-link", attrs: { title: "Hide campaign Id" }, on: { click: /* @__PURE__ */ __name(function($event) {
      _vm.showCampaignId = null;
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "chevron-down" } })], 1) : _vm._e(), _vm._v(" "), _vm.showCampaignId === campaign.id ? _c("span", { staticClass: "text-muted small" }, [_c("br"), _vm._v(_vm._s(campaign.id))]) : _vm._e()]), _vm._v(" "), _c("td", [_c("router-link", { staticClass: "badge badge-info", attrs: { to: { name: "pages/forms/forms", query: { campaign: campaign.id, status: ["saved"] } } } }, [_vm._v(`Active:
                                ` + _vm._s(campaign.active || 0) + `
                            `)]), _vm._v(`
                             
                            `), _c("router-link", { staticClass: "badge badge-warning", attrs: { to: { name: "pages/forms/forms", query: { campaign: campaign.id, status: ["submitted"] } } }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.console.log("click!");
    }, "click") } }, [_vm._v(`Pending:
                                ` + _vm._s(campaign.pending || 0) + `
                            `)]), _vm._v(`
                             
                            `), _c("router-link", { staticClass: "badge badge-success", attrs: { to: { name: "pages/forms/forms", query: { campaign: campaign.id, status: ["approved"] } } }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.console.log("click!");
    }, "click") } }, [_vm._v(`Approved:
                                ` + _vm._s(campaign.approved || 0) + `
                            `)]), _vm._v(`
                             
                            `), campaign.status === "open" ? _c("span", { staticClass: "badge badge-success" }, [_vm._v("Open")]) : _c("span", { staticClass: "badge badge-danger" }, [_vm._v("Closed")])], 1), _vm._v(" "), _c("td", [campaign.expiry ? [_vm.hasExpired(campaign.expiry) ? _c("span", { staticClass: "badge badge-danger" }, [_vm._v("Expired")]) : _vm._e(), _vm._v(`
                                 ` + _vm._s(_vm._f("toHumanReadableDateTime")(campaign.expiry)) + `
                            `)] : [_c("p", { staticStyle: { "font-style": "italic" } }, [_vm._v("No Expiry")])]], 2), _vm._v(" "), _c("td", { staticClass: "float-right" }, [_c("button", { staticClass: "btn btn-sm btn-primary", on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.editCampaign(campaign);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "wrench" } }), _vm._v(`
                                Edit
                            `)], 1), _vm._v(" "), campaign.status === "open" ? _c("button", { staticClass: "btn btn-sm btn-danger", on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.closeCampaign(campaign.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "times" } }), _vm._v(`
                                Close
                            `)], 1) : _vm._e(), _vm._v(" "), campaign.status === "closed" ? _c("button", { staticClass: "btn btn-sm btn-info", on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.openCampaign(campaign.id);
    }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "redo" } }), _vm._v(`
                                Open
                            `)], 1) : _vm._e()])]);
  }), 0)])] : _vm.loading ? _c("loading-bar", [_vm._v("Loading")]) : _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
                No campaigns active for this page
            `)])], 2)]), _vm._v(" "), _c("div", { ref: "closeCampaignModal", staticClass: "modal fade", attrs: { tabindex: "-1", role: "dialog" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_vm._m(1), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_vm.campaignToClose ? _c("div", { staticClass: "alert alert-danger" }, [_vm._v(`
                        Are you sure you want to close campaign ` + _vm._s(_vm.campaignToClose.name) + `
                    `)]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", disabled: _vm.closingCampaign }, on: { click: _vm.cancelCloseCampaign } }, [_vm._v(`No
                    `)]), _vm._v(" "), _c("button", { staticClass: "btn btn-danger", attrs: { type: "button", disabled: _vm.closingCampaign }, on: { click: _vm.verifyCloseCampaign } }, [_vm.closingCampaign ? [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(`
                            Closing
                        `)] : [_vm._v(`
                            Yes
                        `)]], 2)])])])]), _vm._v(" "), _c("div", { ref: "openCampaignModal", staticClass: "modal fade", attrs: { tabindex: "-1", role: "dialog" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_vm._m(2), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_vm.campaignToOpen ? _c("div", { staticClass: "alert alert-info" }, [_vm._v(`
                        Are you sure you want to open campaign ` + _vm._s(_vm.campaignToOpen.name) + `
                    `)]) : _vm._e()]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", disabled: _vm.openingCampaign }, on: { click: _vm.cancelOpenCampaign } }, [_vm._v(`No
                    `)]), _vm._v(" "), _c("button", { staticClass: "btn btn-info", attrs: { type: "button", disabled: _vm.openingCampaign }, on: { click: _vm.verifyOpenCampaign } }, [_vm.openingCampaign ? [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(`
                            Opening
                        `)] : [_vm._v(`
                            Yes
                        `)]], 2)])])])]), _vm._v(" "), _c("div", { ref: "editModal", staticClass: "modal fade", attrs: { tabindex: "-1", role: "dialog" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_vm._m(3), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Campaign Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.editingCampaignName, expression: "editingCampaignName" }], staticClass: "form-control", domProps: { value: _vm.editingCampaignName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.editingCampaignName = $event.target.value);
  }, "input") } })]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Expiry time")]), _vm._v(" "), _c("div", { staticClass: "input-group date" }, [_c("input", { staticClass: "form-control readonly", attrs: { readonly: "" } }), _vm._v(" "), _c("div", { staticClass: "input-group-append" }, [_c("span", { staticClass: "input-group-text" }, [_c("font-awesome-icon", { attrs: { icon: "calendar" } })], 1)])]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Expiry times are optional")])])]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", disabled: _vm.editingCampaign }, on: { click: _vm.cancelEdit } }, [_vm._v(`Cancel
                    `)]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", attrs: { type: "button", disabled: _vm.editingCampaign }, on: { click: _vm.saveEdit } }, [_vm.editingCampaign ? [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(`
                            Editing
                        `)] : [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save 
                        `)]], 2)])])])]), _vm._v(" "), _c("div", { ref: "createModal", staticClass: "modal fade", attrs: { tabindex: "-1", role: "dialog" } }, [_c("div", { staticClass: "modal-dialog", attrs: { role: "document" } }, [_c("div", { staticClass: "modal-content" }, [_vm._m(4), _vm._v(" "), _c("div", { staticClass: "modal-body" }, [_c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Campaign Name")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.createCampaignName, expression: "createCampaignName" }], staticClass: "form-control", domProps: { value: _vm.createCampaignName }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || (_vm.createCampaignName = $event.target.value);
  }, "input") } })]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Expiry time")]), _vm._v(" "), _c("div", { staticClass: "input-group date" }, [_c("input", { staticClass: "form-control readonly", attrs: { readonly: "" } }), _vm._v(" "), _c("div", { staticClass: "input-group-append" }, [_c("span", { staticClass: "input-group-text" }, [_c("font-awesome-icon", { attrs: { icon: "calendar" } })], 1)])]), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Expiry times are optional")])])]), _vm._v(" "), _c("div", { staticClass: "modal-footer" }, [_c("button", { staticClass: "btn btn-default", attrs: { type: "button", disabled: _vm.creatingCampaign }, on: { click: _vm.cancelCreate } }, [_vm._v(`Cancel
                    `)]), _vm._v(" "), _c("button", { staticClass: "btn btn-success", attrs: { type: "button", disabled: _vm.creatingCampaign }, on: { click: _vm.create } }, [_vm.creatingCampaign ? [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(`
                            Creating
                        `)] : [_c("font-awesome-icon", { attrs: { icon: "plus" } }), _vm._v(` Create
                        `)]], 2)])])])])]);
}, "render"), _sfc_staticRenderFns = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("thead", [_c("tr", [_c("th", [_vm._v("Name")]), _vm._v(" "), _c("th", [_vm._v("Totals")]), _vm._v(" "), _c("th", [_vm._v("Expiry")]), _vm._v(" "), _c("th")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal-header" }, [_c("h4", { staticClass: "modal-title" }, [_vm._v("Close Campaign")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal-header" }, [_c("h4", { staticClass: "modal-title" }, [_vm._v("Open Campaign")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal-header" }, [_c("h4", { staticClass: "modal-title" }, [_vm._v("Edit campaign")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "modal-header" }, [_c("h4", { staticClass: "modal-title" }, [_vm._v("Create campaign")])]);
}], __component__ = /* @__PURE__ */ normalizeComponent(
  CampaignsRoute,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "006076a4"
);
const campaigns = __component__.exports;
export {
  campaigns as default
};
