var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { V as Vue, a7 as AdministrationPagesClient, T as Transformer, b as baseUrl, t as toastr, C as Component, L as LoadingBarComponent, n as normalizeComponent } from "./main-DAVWuHbi.js";
var __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = decorator(result) || result);
  return result;
}, "__decorateClass"), _a;
let AppPageDefaultSettingsComponent$1 = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "editingPageType", "forms");
    __publicField(this, "loading", !1);
    __publicField(this, "saving", !1);
    __publicField(this, "appPageDefaultConfiguration", null);
  }
  mounted() {
    this.loadSettings();
  }
  async loadSettings() {
    this.loading = !0;
    try {
      this.appPageDefaultConfiguration = await new AdministrationPagesClient(new Transformer(), baseUrl()).getAppPageDefaultSettings();
    } catch (e) {
      toastr.error("Something has gone wrong while loading the settings: " + e);
    } finally {
      this.loading = !1;
    }
  }
  async save() {
    this.saving = !0, await new AdministrationPagesClient(new Transformer(), baseUrl()).setAppPageDefaultSettings(this.appPageDefaultConfiguration).then((model) => {
      this.appPageDefaultConfiguration = model, toastr.success("App Page default settings saved");
    }).catch((e) => {
      toastr.error("Something has gone wrong while saving the App Page default settings: " + e);
    }).finally(() => {
      this.loading = !1, this.saving = !1;
    });
  }
  get formsAppPageDefault() {
    return this.appPageDefaultConfiguration.formsAppPageDefault;
  }
  set formsAppPageDefault(value) {
    this.appPageDefaultConfiguration.formsAppPageDefault = value;
  }
  /*   get indexingAppPageDefaultSettings(): IndexingAppPageDefault {
       return this.appPageDefaultConfiguration.indexingAppPageDefaultSettings;
     }
     set indexingAppPageDefaultSettings(value: IndexingAppPageDefault) {
       this.appPageDefaultConfiguration.indexingAppPageDefaultSettings = value;
     }*/
  editAppPage(pageType) {
    this.editingPageType = pageType;
  }
  isEditing(pageType) {
    return this.editingPageType === pageType;
  }
}, __name(_a, "AppPageDefaultSettingsComponent"), _a);
AppPageDefaultSettingsComponent$1 = __decorateClass([
  Component({
    components: { LoadingBar: LoadingBarComponent },
    computed: {},
    inject: ["$validator"]
  })
], AppPageDefaultSettingsComponent$1);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", [_c("b-row", [_c("b-col", { attrs: { md: "3" } }, [_c("h2", [_vm._v("App Page Defaults")]), _vm._v(" "), _c("b-list-group", { ref: "actions" }, [_c("b-list-group-item", { ref: "action", attrs: { button: "", active: _vm.isEditing("forms") }, on: { click: /* @__PURE__ */ __name(function($event) {
    return _vm.editAppPage("forms");
  }, "click") } }, [_vm._v(`
            DFA - Forms
          `)])], 1)], 1), _vm._v(" "), _vm.appPageDefaultConfiguration ? _c("b-col", { attrs: { md: "9" } }, [_c("h2", [_vm._v(_vm._s(_vm.$options.filters.capitaliseFirstLetter(_vm.editingPageType)) + " default configuration")]), _vm._v(" "), _c("b-alert", { attrs: { show: "", variant: "info" } }, [_c("font-awesome-icon", { attrs: { icon: "circle-info" } }), _vm._v(`
          The configuration below will set the default settings for any new App Pages created after these settings are saved.
        `)], 1), _vm._v(" "), _vm.isEditing("forms") ? _c("span", [_c("h3", [_vm._v("Display")]), _vm._v(" "), _c("b-form-group", { attrs: { id: "hideFromHomePageSwitchGroup", "label-for": "hideFromHomePageSwitch", description: "Show a 'Start over' button after the submission has been completed" } }, [_c("b-form-checkbox", { attrs: { name: "hideFromHomePageSwitch", switch: "" }, model: { value: _vm.formsAppPageDefault.hideFromHomePage, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.formsAppPageDefault, "hideFromHomePage", $$v);
  }, "callback"), expression: "formsAppPageDefault.hideFromHomePage" } }, [_c("b", [_vm._v("Hide From Home Page")])])], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "showStartOverButtonSwitchGroup", "label-for": "showStartOverButtonSwitch", description: "Show a 'Start over' button after the submission has been completed" } }, [_c("b-form-checkbox", { attrs: { name: "showStartOverButtonSwitch", switch: "" }, model: { value: _vm.formsAppPageDefault.showStartOverButton, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.formsAppPageDefault, "showStartOverButton", $$v);
  }, "callback"), expression: "formsAppPageDefault.showStartOverButton" } }, [_c("b", [_vm._v("Show Start Over Button")])])], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "showInvalidFieldsModalSwitchGroup", "label-for": "showInvalidFieldsModalSwitch", description: "Show modal when submission is attempted but the form has invalid fields" } }, [_c("b-form-checkbox", { attrs: { name: "showInvalidFieldsModalSwitch", switch: "" }, model: { value: _vm.formsAppPageDefault.showInvalidFieldsModal, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.formsAppPageDefault, "showInvalidFieldsModal", $$v);
  }, "callback"), expression: "formsAppPageDefault.showInvalidFieldsModal" } }, [_c("b", [_vm._v("Show Invalid Fields Modal")])])], 1), _vm._v(" "), _c("h3", [_vm._v("Sessions")]), _vm._v(" "), _c("b-form-group", { attrs: { id: "enableSavingSwitchGroup", "label-for": "enableSavingSwitch", description: "Saved tokens will be persisted in browser storage" } }, [_c("b-form-checkbox", { attrs: { name: "enableSavingSwitch", switch: "" }, model: { value: _vm.formsAppPageDefault.enableSaving, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.formsAppPageDefault, "enableSaving", $$v);
  }, "callback"), expression: "formsAppPageDefault.enableSaving" } }, [_c("b", [_vm._v("Enable Saving")])])], 1), _vm._v(" "), _c("b-form-group", { attrs: { id: "persistTokenSwitchGroup", "label-for": "persistTokenSwitch", description: "Forms can be saved, and retrieved at a later date" } }, [_c("b-form-checkbox", { attrs: { name: "persistTokenSwitch", switch: "" }, model: { value: _vm.formsAppPageDefault.persistToken, callback: /* @__PURE__ */ __name(function($$v) {
    _vm.$set(_vm.formsAppPageDefault, "persistToken", $$v);
  }, "callback"), expression: "formsAppPageDefault.persistToken" } }, [_c("b", [_vm._v("Persist Token")])])], 1), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Saved Form Data Retention")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.formsAppPageDefault.savedFormDataRetention, expression: "formsAppPageDefault.savedFormDataRetention" }, { name: "validate", rawName: "v-validate", value: "required|numeric|min_value:0", expression: "'required|numeric|min_value:0'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("saved-retention") }, staticStyle: { "max-width": "125px" }, attrs: { type: "number", min: "0", name: "saved-retention" }, domProps: { value: _vm.formsAppPageDefault.savedFormDataRetention }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.formsAppPageDefault, "savedFormDataRetention", $event.target.value);
  }, "input") } }), _vm._v(" "), _vm.errors.first("saved-retention") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("saved-retention")))]) : _c("p", { staticClass: "text-muted" }, [_vm._v("Number of days to retain saved forms before saved data is deleted. The saved form will be marked as deleted and will be unable to be resumed. A value of "), _c("code", [_vm._v("0")]), _vm._v(" retain the form data indefinitely.")])]), _vm._v(" "), _c("div", { staticClass: "form-group" }, [_c("label", [_vm._v("Approved Form Data Retention")]), _vm._v(" "), _c("input", { directives: [{ name: "model", rawName: "v-model", value: _vm.formsAppPageDefault.approvedFormDataRetention, expression: "formsAppPageDefault.approvedFormDataRetention" }, { name: "validate", rawName: "v-validate", value: "required|numeric|min_value:0", expression: "'required|numeric|min_value:0'" }], staticClass: "form-control", class: { "is-invalid": _vm.errors.first("approved-retention") }, staticStyle: { "max-width": "125px" }, attrs: { type: "number", min: "0", name: "approved-retention" }, domProps: { value: _vm.formsAppPageDefault.approvedFormDataRetention }, on: { input: /* @__PURE__ */ __name(function($event) {
    $event.target.composing || _vm.$set(_vm.formsAppPageDefault, "approvedFormDataRetention", $event.target.value);
  }, "input") } }), _vm._v(" "), _c("p", { staticClass: "text-muted" }, [_vm._v("Number of days to retain approved forms before submitted data is deleted. Form data will no longer be visible in the history modal and outputs will no longer be able to be rerun. A value of "), _c("code", [_vm._v("0")]), _vm._v(" will retain the form data indefinitely.")]), _vm._v(" "), _vm.errors.first("approved-retention") ? _c("p", { staticClass: "text-danger" }, [_vm._v(_vm._s(_vm.errors.first("approved-retention")))]) : _vm._e()])], 1) : _vm._e()], 1) : _vm._e()], 1), _vm._v(" "), _c("b-row", [_c("b-col", [_c("span", { staticClass: "float-right" }, [_c("button", { staticClass: "btn btn-success", on: { click: _vm.save } }, [_vm.saving ? _c("span", [_c("font-awesome-icon", { attrs: { icon: "sync", spin: "" } }), _vm._v(` Saving...
            `)], 1) : _c("span", [_c("font-awesome-icon", { attrs: { icon: "save" } }), _vm._v(` Save
            `)], 1)])])])], 1)], 1);
}, "render"), _sfc_staticRenderFns = [], __component__ = /* @__PURE__ */ normalizeComponent(
  AppPageDefaultSettingsComponent$1,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "f40df3ae"
);
const AppPageDefaultSettingsComponent = __component__.exports;
export {
  AppPageDefaultSettingsComponent as A
};
