var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: !0, configurable: !0, writable: !0, value }) : obj[key] = value;
var __name = (target, value) => __defProp(target, "name", { value, configurable: !0 });
var __publicField = (obj, key, value) => __defNormalProp(obj, typeof key != "symbol" ? key + "" : key, value);
import { P as Prop, C as Component, V as Vue, aK as IntegrationProviders, a4 as IntegrationActionTypes, n as normalizeComponent } from "./main-DAVWuHbi.js";
var __defProp2 = Object.defineProperty, __getOwnPropDesc = Object.getOwnPropertyDescriptor, __decorateClass = /* @__PURE__ */ __name((decorators, target, key, kind) => {
  for (var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target, i = decorators.length - 1, decorator; i >= 0; i--)
    (decorator = decorators[i]) && (result = (kind ? decorator(target, key, result) : decorator(result)) || result);
  return kind && result && __defProp2(target, key, result), result;
}, "__decorateClass"), _a;
let IntegrationInstanceDropdownComponent = (_a = class extends Vue {
  constructor() {
    super(...arguments);
    __publicField(this, "actionFilter");
    __publicField(this, "value");
    __publicField(this, "disabled");
    __publicField(this, "allowLegacyIntegrations");
    __publicField(this, "loading", !1);
    __publicField(this, "loadingError", null);
  }
  changed(value) {
    this.$emit("input", value.id), this.$emit("integrationNameChanged", value.name);
  }
  mounted() {
    $(this.$el).find(".dropdown-menu").parent().on("shown.bs.dropdown", () => this.$emit("shown")), $(this.$el).find(".dropdown-menu").parent().on("hidden.bs.dropdown", () => this.$emit("hidden")), this.loadIntegrations();
  }
  async loadIntegrations() {
    return this.loading = !0, this.loadingError = null, this.$store.dispatch("administration/integrations/getIntegrations").catch((e) => this.loadingError = e).finally(() => this.loading = !1);
  }
  get selected() {
    return !this.loading && this.value ? this.storedInstances.find((instance) => instance.id == this.value) ?? null : null;
  }
  get storedInstances() {
    var _a2;
    return ((_a2 = this.$store.state.administration.integrations.instances) == null ? void 0 : _a2.filter(this.supportsAnyFilterAction)) ?? [];
  }
  get connectors() {
    return this.storedInstances.filter((instance) => instance.provider == IntegrationProviders.Connectors).sort((a, b) => a.name.localeCompare(b.name));
  }
  get eisIntegrations() {
    return this.allowLegacyIntegrations ? this.storedInstances.filter((instance) => instance.provider == IntegrationProviders.EzeScanIntegrationService).sort((a, b) => a.name.localeCompare(b.name)) : [];
  }
  supportsAnyFilterAction(instance) {
    return this.actionFilter.some((actionFilter) => {
      var _a2;
      switch (actionFilter) {
        case IntegrationActionTypes.Browse:
          return instance.type.browsable;
        case IntegrationActionTypes.Lookup:
          return instance.type.lookupable;
        case IntegrationActionTypes.Search:
          return instance.type.searchable;
        case IntegrationActionTypes.TableQuery:
          return (_a2 = instance.type) == null ? void 0 : _a2.supportsTableQuery;
        case IntegrationActionTypes.Upload:
          return instance.type.uploadable;
        case IntegrationActionTypes.Validation:
          return instance.type.supportsValidation;
        default:
          return console.warn(`Integration action filter ${actionFilter} is not supported`), !1;
      }
    });
  }
}, __name(_a, "IntegrationInstanceDropdownComponent"), _a);
__decorateClass([
  Prop({
    required: !0,
    type: Array
  })
], IntegrationInstanceDropdownComponent.prototype, "actionFilter", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => null, "default")
  })
], IntegrationInstanceDropdownComponent.prototype, "value", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !1, "default")
  })
], IntegrationInstanceDropdownComponent.prototype, "disabled", 2);
__decorateClass([
  Prop({
    required: !1,
    default: /* @__PURE__ */ __name(() => !0, "default")
  })
], IntegrationInstanceDropdownComponent.prototype, "allowLegacyIntegrations", 2);
IntegrationInstanceDropdownComponent = __decorateClass([
  Component({
    $_veeValidate: {
      name() {
        return this.prop.name;
      },
      value() {
        return this.value;
      }
    },
    inject: ["$validator"]
  })
], IntegrationInstanceDropdownComponent);
var _sfc_render = /* @__PURE__ */ __name(function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("div", { staticClass: "btn-group dropdown", attrs: { id: "integrationInstanceDropdown" } }, [_c("button", { staticClass: "btn btn-success", attrs: { disabled: _vm.loading }, on: { click: /* @__PURE__ */ __name(function($event) {
    return $event.preventDefault(), _vm.loadIntegrations.apply(null, arguments);
  }, "click") } }, [_c("font-awesome-icon", { attrs: { icon: "sync" } })], 1), _vm._v(" "), _c("button", { staticClass: "btn btn-outline-secondary dropdown-toggle reactive-dropdown-button", class: { "btn-danger": _vm.loadingError }, attrs: { type: "button", "aria-haspopup": "true", "aria-expanded": "true", "data-toggle": "dropdown", disabled: _vm.disabled || _vm.loading } }, [_vm.loadingError ? _c("span", { attrs: { title: "error" } }, [_c("font-awesome-icon", { attrs: { icon: "exclamation-circle" } }), _vm._v(" Error")], 1) : _vm._e(), _vm._v(" "), [_vm.selected ? _c("span", [_vm._v(`
        ` + _vm._s(_vm.selected.name) + `
      `)]) : _c("span", [_vm._v(`
          Select...
      `)])], _vm._v(" "), _c("span", { staticClass: "caret" })], 2), _vm._v(" "), _c("div", { staticClass: "dropdown-menu", staticStyle: { "z-index": "1040" } }, [_vm.loading ? [_vm.loading ? _c("button", { staticClass: "disabled dropdown-item" }, [_vm._v("Loading...")]) : _vm._e()] : [_vm._m(0), _vm._v(" "), [_vm.connectors.length == 0 ? _c("button", { staticClass: "dropdown-item", attrs: { disabled: "" } }, [_vm._v(`
          (none available)
        `)]) : _vm._l(_vm.connectors, function(connector) {
    return _c("button", { key: connector.id, staticClass: "dropdown-item ml-2", attrs: { name: connector.name, id: connector.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.changed(connector);
    }, "click") } }, [_vm._v(`
          ` + _vm._s(connector.name) + `
        `)]);
  })], _vm._v(" "), _vm.allowLegacyIntegrations ? [_vm._m(1), _vm._v(" "), _vm.eisIntegrations.length == 0 ? _c("button", { staticClass: "dropdown-item", attrs: { disabled: "" } }, [_vm._v(`
              (none available)
          `)]) : _vm._l(_vm.eisIntegrations, function(integration) {
    return _c("button", { key: integration.id, staticClass: "dropdown-item ml-2", attrs: { name: integration.name, id: integration.id }, on: { click: /* @__PURE__ */ __name(function($event) {
      return _vm.changed(integration);
    }, "click") } }, [_vm._v(`
              ` + _vm._s(integration.name) + `
          `)]);
  })] : _vm._e()]], 2)]);
}, "render"), _sfc_staticRenderFns = [function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "dropdown-item", attrs: { disabled: "" } }, [_c("strong", [_vm._v("Connectors")])]);
}, function() {
  var _vm = this, _c = _vm._self._c;
  return _vm._self._setupProxy, _c("button", { staticClass: "dropdown-item", attrs: { disabled: "" } }, [_c("strong", [_vm._v("EIS Integrations")])]);
}], __component__ = /* @__PURE__ */ normalizeComponent(
  IntegrationInstanceDropdownComponent,
  _sfc_render,
  _sfc_staticRenderFns,
  !1,
  null,
  "b808a104"
);
const IntegrationInstanceDropdown = __component__.exports;
export {
  IntegrationInstanceDropdown as I
};
