﻿//< !--Fetch data from the Apps API and populate the dropdown-- >
$(document).ready(function () {

    $.ajaxSetup({
        xhrFields: {
            withCredentials: true
        }
    });
    var apiEndpoint = window.appSwitcherBaseUrl + "/api/apps";
    // Function to fetch and populate data
    function fetchDataAndPopulate() {
        // Show loading animation
        $('#app-switcher-loading').show();

        // Fetch data from the API
        $.get(apiEndpoint, function (data) {
            // Hide loading animation
            $('#app-switcher-loading').hide();
            
            // Assuming the data is an array of objects with 'applicationName', 'applicationUrl', and 'applicationDescription' properties
            data.forEach(function (item) {
                // Append each item to the dropdown menu

                $('.app-switcher .dropdown-menu').append('<a class="dropdown-item app-switcher-item" href="' + item.applicationUrl + '"><div class="flex-row-app"><img class="app-switcher-icon" src="' + item.applicationIcon + '"/><div class="flex-column-app"><span>' + item.applicationName + '</span><small className="text-muted">' + item.applicationDescription + '</small></div></div></a>');
            });
        })
            .fail(function () {
            $('#app-switcher-loading').hide();
                $('.app-switcher .dropdown-menu').append('<a class="dropdown-item">Failed to retrieve apps</a>');
        });
    }

    // Attach an event handler to the show.bs.dropdown event
    $('.app-switcher').on('show.bs.dropdown', function () {
        // Clear existing items in the dropdown before fetching new data
        $('.app-switcher .dropdown-menu a').remove();

        // Fetch and populate data
        fetchDataAndPopulate();
    });
});